(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 13.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    186542,       3753]
NotebookOptionsPosition[    177453,       3567]
NotebookOutlinePosition[    180000,       3630]
CellTagsIndexPosition[    179876,       3624]
WindowTitle->PFusionArgon
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[GridBox[{
   {GridBox[{
      {
       ItemBox[Cell[BoxData[
         RowBox[{
          TemplateBox[{12},
           "Spacer1"], Cell["NEW EO S ARGON PACKAGE SYMBOL", "PacletNameCell",
           TextAlignment->Center,ExpressionUUID->
           "582aa3dc-00b2-4c04-b8be-9df8350fcd3d"], 
          TemplateBox[{8},
           "Spacer1"]}]],
         TextAlignment->Center,ExpressionUUID->
         "5db3672d-94b5-47ac-82f7-016e56bdce9a"],
        Background->RGBColor[0.490196, 0.576471, 0.690196],
        ItemSize->Full], ""}
     },
     GridBoxAlignment->{"Rows" -> {{Center}}},
     GridBoxItemSize->{"Columns" -> {Full, 
         Scaled[0.02]}, "Rows" -> {{2.5}}}], Cell[TextData[{
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "See Also",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "34b6a2cd-defa-4707-9493-2f1fc9faadcf"]
         }],ExpressionUUID->"2327e750-4b88-481a-86f0-88a77b640b9f"],
         StripOnInput->False],{
        "\"ptr\"" :> Documentation`HelpLookup["paclet:NewEoSArgon/ref/ptr"]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"SeeAlso"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "73449015-bbad-47b7-9522-de02e78fbe54"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "Related Guides",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "6dc8ebbf-b14b-4b54-a9e0-f37affda390d"]
         }],ExpressionUUID->"1c009faf-0848-49da-a09b-a04761dbd4d5"],
         StripOnInput->False],{
        "\"NewEoSArgon Package\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/guide/NewEoSArgon"]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"MoreAbout"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "165b5342-1053-46a7-9e88-0305ae4d5129"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "URL",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "3479ed51-38bb-40ad-ae3e-f2e51ba0b879"]
         }],ExpressionUUID->"99aa7a7d-b220-45cf-a475-e683432e8843"],
         StripOnInput->False],{
        "\"NewEoSArgon/ref/PFusionArgon\"" :> None, 
         "\"Copy Wolfram Documentation Center URL\"" :> 
         Module[{DocumentationSearch`Private`nb$}, 
           DocumentationSearch`Private`nb$ = 
            NotebookPut[
             Notebook[{Cell["NewEoSArgon/ref/PFusionArgon"]}, Visible -> 
               False]]; 
           SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
           FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
           NotebookClose[DocumentationSearch`Private`nb$]; Null], Delimiter, 
         "\"Copy web URL\"" :> 
         Module[{DocumentationSearch`Private`nb$}, 
           DocumentationSearch`Private`nb$ = 
            NotebookPut[
             Notebook[{
               Cell[BoxData[
                 MakeBoxes[
                  Hyperlink[
                   "http://reference.wolfram.com/language/NewEoSArgon/ref/\
PFusionArgon.html"], StandardForm]], "Input", TextClipboardType -> 
                 "PlainText"]}, Visible -> False]]; 
           SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
           FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
           NotebookClose[DocumentationSearch`Private`nb$]; Null], 
         "\"Go to web URL\"" :> 
         FrontEndExecute[{
           NotebookLocate[{
             URL[If[TrueQ[DocumentationBuild`Make`Private`wsmlinkQ$19037], 
                 "http://reference.wolfram.com/system-modeler/", 
                 "http://reference.wolfram.com/language/"] <> 
               "NewEoSArgon/ref/PFusionArgon" <> ".html"], None}]}]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"URLMenu"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "70329c31-0109-4352-b1b3-2b3ae52ca95e"]
    }], "AnchorBar",
     CacheGraphics->False,ExpressionUUID->
     "2ad4334a-5c32-4e56-ba59-64606cec5afa"]}
  }]], "AnchorBarGrid",
 CellID->1,ExpressionUUID->"7907dec6-c010-43e8-b04c-5a447ffdd31b"],

Cell["NewEoSArgon`", "ContextNameCell",ExpressionUUID->"67a30d41-a52e-4f5e-adbe-546f428b1198"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     Cell[
     "PFusionArgon", "ObjectName",ExpressionUUID->
      "4a8d8ce1-21a3-4e1e-b792-84b5d26f8ea8"],
     Cell[BoxData[
      TemplateBox[{8},
       "Spacer1"]],ExpressionUUID->"4a18d2f7-988a-41a1-b68f-831c1865bf3e"],
     Cell[BoxData[
     ""], "ObjectNameTranslation",ExpressionUUID->
      "6bfad840-a3d9-4c10-b8c0-95a98e91c8d9"]
    }],ExpressionUUID->"19a880ec-84cc-4e00-83b9-78071ae25054"], 
    "\[SpanFromLeft]"}
  }]], "ObjectNameGrid",ExpressionUUID->"bfdb796d-5de1-4c38-9ab0-\
5dc6cbcdadcc"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"PFusionArgon", "[", 
       StyleBox["T",
        FontSlant->"Italic"], "]"}]], "InlineFormula",
      ShowStringCharacters->False,
      FontFamily->"Source Sans Pro",ExpressionUUID->
      "17a87801-30fc-4257-ba3c-742f2f89150e"],
     " \[Congruent] ",
     Cell[BoxData[
      StyleBox[
       SubscriptBox["P", "m"],
       FontSlant->"Italic"]], "InlineFormula",
      FontFamily->"Source Sans Pro",ExpressionUUID->
      "c4a2d0ae-84e7-4e50-9d36-9bf5427a28ef"],
     " (MPa)\nPression sur la ligne de fusion de l'argon en fonction de la \
temp\[EAcute]rature ",
     StyleBox["T",
      FontSlant->"Italic"],
     " (Kelvin)\n[Function that gives the pressure versus ",
     StyleBox["T",
      FontSlant->"Italic"],
     " (Kelvin) on the melting line of argon]"
    }],ExpressionUUID->"dc194384-02c0-4ed3-87f7-cec084680d3b"]}
  }]], "Usage",ExpressionUUID->"9c419669-1a6e-43cc-b1a9-079d20051d41"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[Cell[TextData[{
   Cell[BoxData[
    DynamicBox[ToBoxes[
      If[
       MatchQ[
        CurrentValue[
         EvaluationNotebook[], {TaggingRules, "Openers", "NotesSection"}, 
         Closed], 
        Alternatives[Open, True]], 
       Style[
        Graphics[{
          Thickness[0.18], 
          RGBColor[0.8509803921568627, 0.396078431372549, 0], 
          Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
         PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
        0.68 Inherited], 
       Rotate[
        Style[
         Graphics[{
           Thickness[0.18], 
           RGBColor[0.8509803921568627, 0.396078431372549, 0], 
           Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
          PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
         0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
     ImageSizeCache->{
      13.600000000000001`, {0.5800000000000001, 13.020000000000001`}}]],
    ExpressionUUID->"1e8b5f74-a772-476e-a415-7692a58ce13f"],
   Cell[BoxData[
    TemplateBox[{1},
     "Spacer1"]],ExpressionUUID->"fc31ed7c-844b-43b7-9b41-ffd8e3273ffd"],
   "Details and Options"
  }], "NotesFrameText",ExpressionUUID->"d805c973-46fe-4034-aad5-93f788616a23"],
  Appearance->{Automatic, None, "Normal", Automatic},
  BaseStyle->None,
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"], 
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], After, CellContents]}]& ),
  Evaluator->None,
  Method->
   "Preemptive"]],ExpressionUUID->"6cced313-0ac5-47f9-a2cb-15b5a73d2e3c"]], \
"NotesSection",
 WholeCellGroupOpener->True,
 CellGroupingRules->{"SectionGrouping", 50},
 CacheGraphics->False,
 CellID->141379143,ExpressionUUID->"48ab0f55-7373-4e87-bf95-7f8fad9af03f"],

Cell[TextData[{
 "La fonction est d\[EAcute]finie pour tout ",
 StyleBox["T",
  FontSlant->"Italic"],
 " \[GreaterEqual] ",
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["ttr"]], "paclet:NewEoSArgon/ref/ttr", 
    "NewEoSArgon Package Symbol"},
   "PackageLink",
   BaseStyle->"InlineFormula"]], "InlineFormula",
  FontFamily->"Source Sans Pro",ExpressionUUID->
  "49fa602e-8e66-4281-937a-d247e340d373"]
}], "Notes",
 CellID->1067943069,ExpressionUUID->"acf42a4c-e727-40b2-b324-ed70cc4fe8cc"],

Cell["\<\
******************************************************************************\
******\
\>", "Notes",
 CellID->224665577,ExpressionUUID->"e177fc8d-746a-4f9c-9d9b-aed8434aee7d"],

Cell[TextData[{
 "The function is defined for ",
 StyleBox["T",
  FontSlant->"Italic"],
 " \[GreaterEqual] ",
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["ttr"]], "paclet:NewEoSArgon/ref/ttr", 
    "NewEoSArgon Package Symbol"},
   "PackageLink",
   BaseStyle->"InlineFormula"]], "InlineFormula",
  FontFamily->"Source Sans Pro",ExpressionUUID->
  "c96ed4ae-94c3-404b-b566-7671046b5678"]
}], "Notes",
 CellID->82812754,ExpressionUUID->"febcbd95-77f0-42e8-bbb7-636610daf25c"]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "NotesSection"}, Closed]]]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {
       TaggingRules, "Openers", "PrimaryExamplesSection"}, Open], 
      Alternatives[True, Open]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{13.600000000000001`, {5., 8.600000000000001}}]],
  ExpressionUUID->"383b7148-0766-41d9-85d4-fdffdfc0c91c"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"5debf493-8797-45f6-9b0f-759b0c676033"],
 "Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount",ExpressionUUID->
  "e390e842-883c-4817-b1e7-bb7136330e0b"]
}], "PrimaryExamplesSection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellTags->"PrimaryExamplesSection",
 CellID->218898675,ExpressionUUID->"103c2d37-f730-4e92-89ab-140e674227db"],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"},
        Closed], 
      Alternatives[Open, True]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{13.600000000000001`, {5., 8.600000000000001}}]],
  ExpressionUUID->"1212bd99-dced-4c84-a787-3cebaa20bfd6"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"38948e65-2e8c-4ebc-be92-856222716f25"],
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "9938efd6-abb3-485d-8c31-d90f0ce5c5e7"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellID->92259602,ExpressionUUID->"901ce1c1-81c8-4a3f-9860-77905828e8ab"],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<NewEoSArgon`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->87419684,ExpressionUUID->"71ed17c8-c051-4f5a-b9a7-c743abc3b327"],

Cell["Calculate with physical dimension", "ExampleText",
 CellID->285078790,ExpressionUUID->"d4be4049-68d5-407e-9b6e-d003d7543386"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Quantity", "[", 
  RowBox[{
   RowBox[{"PFusionArgon", "[", "ttr", "]"}], ",", "\"\<MPa\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->231987987,ExpressionUUID->"a4561027-48f2-47eb-afef-66d8d03130c6"],

Cell[BoxData[
 TemplateBox[{
  "0.06889100000000001`", "\"MPa\"", "megapascals", "\"Megapascals\""},
  "Quantity"]], "Output",
 CellLabel->"Out[2]=",
 CellID->117750017,ExpressionUUID->"dd04c451-f47d-4995-a809-b480b3514e6d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UnitConvert", "[", 
  RowBox[{
   TemplateBox[{"0.06889100000000001`"},
    "QuantityUnit",
    DisplayFunction->(TooltipBox[
      StyleBox[
       RowBox[{#, "\[InvisibleSpace]", 
         StyleBox[
          RowBox[{" ", "\"MPa\""}], "QuantityUnitTraditionalLabel"]}], 
       ShowStringCharacters -> False], "Unit: megapascals"]& ),
    InterpretationFunction->(RowBox[{"Quantity", "[", 
       RowBox[{#, ",", "\"Megapascals\""}], "]"}]& )], ",", "\"\<Bars\>\""}], 
  "]"}]], "Input",
 NumberMarks->False,
 CellLabel->"In[3]:=",
 CellID->114614193,ExpressionUUID->"0ae623fa-cf30-4a32-8c55-06f9a319aeff"],

Cell[BoxData[
 TemplateBox[{"0.6889100000000001`", "\"bar\"", "bars", "\"Bars\""},
  "Quantity"]], "Output",
 CellLabel->"Out[3]=",
 CellID->341710501,ExpressionUUID->"03d719ad-8957-4015-8588-2d8aaceb54b2"]
}, Open  ]],

Cell["Relative error at the triple point", "ExampleText",
 CellID->237505931,ExpressionUUID->"985a6e99-3722-49a5-9106-483c946d25db"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Quantity", "[", 
  RowBox[{
   RowBox[{"100", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"ptr", "-", 
       RowBox[{"10", "*", 
        RowBox[{"QuantityMagnitude", "@", 
         RowBox[{"Quantity", "[", 
          RowBox[{
           RowBox[{"PFusionArgon", "[", 
            RowBox[{"QuantityMagnitude", "[", 
             RowBox[{"Quantity", "[", 
              RowBox[{"ttr", ",", "\"\<Kelvins\>\""}], "]"}], "]"}], "]"}], 
           ",", "\"\<MPa\>\""}], "]"}]}]}]}], ")"}], "/", "ptr"}]}], ",", 
   "\"\<%\>\""}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->123936303,ExpressionUUID->"131d8e84-3547-4c48-b3e6-7532181b9122"],

Cell[BoxData[
 TemplateBox[{
   RowBox[{"-", "1.61156468134467`*^-14"}], "\"%\"", "percent", "\"Percent\""},
  "QuantityPostfix"]], "Output",
 CellLabel->"Out[4]=",
 CellID->52778897,ExpressionUUID->"1b958da5-3485-406b-9000-df515cfb9629"]
}, Open  ]],

Cell["\<\
The ThermodynamicData package (i.e. REFPROP from NIST) is limited to low \
temperature values\
\>", "ExampleText",
 CellID->266534198,ExpressionUUID->"ba912003-eb68-4878-bd7b-3b1976d47f8d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UnitConvert", "[", 
  RowBox[{
   RowBox[{"ThermodynamicData", "[", 
    RowBox[{"\"\<Argon\>\"", ",", "\"\<SolidLiquidPhaseBoundary\>\"", ",", 
     RowBox[{"{", 
      RowBox[{"\"\<Temperature\>\"", "\[Rule]", 
       RowBox[{"Quantity", "[", 
        RowBox[{"377.3", ",", "\"\<Kelvins\>\""}], "]"}]}], "}"}]}], "]"}], 
   ",", "\"\<MPa\>\""}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->138180430,ExpressionUUID->"c22d6173-6dec-41b8-97ff-12e3510f10ec"],

Cell[BoxData[
 RowBox[{"UnitConvert", "[", 
  RowBox[{
   RowBox[{"Missing", "[", "\<\"NotAvailable\"\>", "]"}], 
   ",", "\<\"MPa\"\>"}], "]"}]], "Output",
 CellLabel->"Out[5]=",
 CellID->113920554,ExpressionUUID->"e0e3ce94-a934-4dc4-bf7c-9619212ffeb8"]
}, Open  ]],

Cell["\<\
Plot function versus temperature in all the temperature range\
\>", "ExampleText",
 CellID->886239600,ExpressionUUID->"af6a5ddd-c80c-4786-8707-5aa224ec442d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"PFusionArgon", "[", "T", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"T", ",", "ttr", ",", "tmaxRonc"}], "}"}], ",", 
   RowBox[{"AxesOrigin", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"tc", ",", "0"}], "}"}]}], ",", 
   RowBox[{"Frame", "->", "True"}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Quantity", "[", 
       RowBox[{"T", ",", "\"\<Kelvins\>\""}], "]"}], ",", 
      RowBox[{"Quantity", "[", 
       RowBox[{"P", ",", "\"\<MPa\>\""}], "]"}]}], "}"}]}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", "Red", "}"}]}], ",", 
   RowBox[{"ImageSize", "\[Rule]", "400"}]}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->21488140,ExpressionUUID->"98efb9a0-0e2d-4bc4-bce1-c9175b4f3694"],

Cell[BoxData[
 GraphicsBox[
  InterpretationBox[{
    TagBox[{{{}, {}, 
       TagBox[
        {RGBColor[1, 0, 0], AbsoluteThickness[2], Opacity[1.], 
         LineBox[CompressedData["
1:eJwVjnk41AkAhlEqSVGUHZJlmZT7mJKjLwqpdu06qolmkKRxpANR25SR2Bw5
c/sp95nKUSpaZ46IhAzzqxQKj9wha//4nvd5n/ef71cHj7+cBPj4+CyX9z8X
L3FnIias0NaVPbay8MFe99OBGpu2WUPI3mKn9vgq9NlosCLNrbHZ+Fpffslm
VO4K6Isklr1Qi3cvVxGcOeWaqD9sQNFRbsYrGtZdvRIRk3sUVsOfyGRZU0hz
pFTiHekQv1KT5Pf2KPQjjjsQ7QyESKvrfdNywbbZtTuc+JmYMaynfc9zgSx1
KG1OkokB9dAwG8WzkA9Ij5IzY2KaLmqlS2Fh+z4Zn4sZTISKyFGZq9ygWb5h
r6SjPQI9/A7/9D4Hk+zvTYxeB1SwvzJY/hfhEVQ2ONrihGjmXEyj1FXIXLng
ImzBQr7+hPcxViA+Dmh9rKKfg9d6cj4zOBytnzsihMwuQJahKShhFoMRtoiz
xQovuERpP83amAi5SdcKuTkfRAX5SLs5EXgrMbQkR/qB+2JObO3gfZS0LjjL
xf6NSoGhUkPbLBwrTsjq/JeNe5f27R83z8NIPadQSv4GfMq1xiZFi1BJu5Lv
7ecP5cO2DlhVDFmx1a6/jHPgSwvV0dV7hC1l3IonR27igKc2L9CuBAmNpi1E
XSDiXxWnjFWVwY5W2ZmyJwjejmvvCqo9RakbxzMpKhicUwYrAvyfIUmst4kn
fBtFM+tbWOsrIXXj2hP5syFYMN4lZH2kCgqMkjN5A6EoHjL73l34EqUNi6sU
VcKR9sixrVa8GlTz2rSpnnAMz39xZ7vUgMvukjkTeweiX8yfaX6sRX+S6Cm6
aQRYFUrt3ofqwf78+reuiQhkKp8XLHzYAOeBrprZgkjcn6XPqBk1Lv9erR5n
F4Wsg+NszWdN2HSa7dtLiUb946NGSYwW7FRhI7cjGiLiR8eX+FoR1pP+eu56
DExUq/Z51bVC11Bi71eDWCy28YRN09qgdivH23YkFpN2tD1czzeoXqzdeTzu
LvKyOzI90I5UJZXKWcs4GFTa9czLd6BOr3yrpEA8FCgbfDzmO6CzMuxEz/N4
5KnOUBwG32K0ONhB2iMBOV3Gt+rqO2EaIjIwJJWIZFWqf2HmO3ze2mNKf5cI
BVo1pyixC21RTRfMbyYhmcFdsOF0Q+DlGjbXOBnUQeGKmBs9eENpWr2wmIyi
HC2667X3GD3++Fh8bgruSJo9lHHvRTZ1snpEKxWZ+X1CAhe5YEfLGrX8kwoD
5R1FJ1h9oMaJXp0kUxHYUEX9m9mPcW+F7a57CTB3cVkPaDyQB5tL78UQ0NJ3
Y/k/5mH/yc7tSncJfCgrzK0o5SHjfH9cQRyB8D1TgtPlPLgmjPuVJxKw2hCw
xuU5D9PfJPA6jUCzTfwBizoe1oWfrP9RQGDHnYJk+W4eaJ1jXX/WEeC3lqnh
LvAQNzx78F09AUv5EmPKEg8LP/mf2r4isOWQWq8NP4kqqniSczMBR98qeqsg
icOXd9tfbSdwnmoWWr2ehL309aGsfgKM+1PND2RJVKsH01VJArs3Kw6PyZFQ
PBDZ+PADgbOGVFlVBRLf3NLznw8QyAiJ7c5RIuH1osGz4ysBFY1NN9I1SXS3
v/lwfGS5n8xz/aRNQn/wvWX/KAGXRRFP+V0k+MVGdYbHCRS4K9YReiROKcxk
eEwQuKzxXpI0IFGryyc5NUmAYmLFkQUJpd+FgnynCQinhwsxjUjcdtj4Y2mG
QL9JWFbKfhL/AU8piRQ=
          "]]},
        Annotation[#, "Charting`Private`Tag#1"]& ]}, {}},
     {"WolframDynamicHighlight", <|
      "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>}], 
    DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
      Slot["HighlightElements"], 
      Slot["LayoutOptions"], 
      Slot["Meta"], 
      Charting`HighlightActionFunction["DynamicHighlight", {{{{}, {}, 
          Annotation[{
            Directive[
             Opacity[1.], 
             AbsoluteThickness[2], 
             RGBColor[1, 0, 0]], 
            Line[CompressedData["
1:eJwVjnk41AkAhlEqSVGUHZJlmZT7mJKjLwqpdu06qolmkKRxpANR25SR2Bw5
c/sp95nKUSpaZ46IhAzzqxQKj9wha//4nvd5n/ef71cHj7+cBPj4+CyX9z8X
L3FnIias0NaVPbay8MFe99OBGpu2WUPI3mKn9vgq9NlosCLNrbHZ+Fpffslm
VO4K6Isklr1Qi3cvVxGcOeWaqD9sQNFRbsYrGtZdvRIRk3sUVsOfyGRZU0hz
pFTiHekQv1KT5Pf2KPQjjjsQ7QyESKvrfdNywbbZtTuc+JmYMaynfc9zgSx1
KG1OkokB9dAwG8WzkA9Ij5IzY2KaLmqlS2Fh+z4Zn4sZTISKyFGZq9ygWb5h
r6SjPQI9/A7/9D4Hk+zvTYxeB1SwvzJY/hfhEVQ2ONrihGjmXEyj1FXIXLng
ImzBQr7+hPcxViA+Dmh9rKKfg9d6cj4zOBytnzsihMwuQJahKShhFoMRtoiz
xQovuERpP83amAi5SdcKuTkfRAX5SLs5EXgrMbQkR/qB+2JObO3gfZS0LjjL
xf6NSoGhUkPbLBwrTsjq/JeNe5f27R83z8NIPadQSv4GfMq1xiZFi1BJu5Lv
7ecP5cO2DlhVDFmx1a6/jHPgSwvV0dV7hC1l3IonR27igKc2L9CuBAmNpi1E
XSDiXxWnjFWVwY5W2ZmyJwjejmvvCqo9RakbxzMpKhicUwYrAvyfIUmst4kn
fBtFM+tbWOsrIXXj2hP5syFYMN4lZH2kCgqMkjN5A6EoHjL73l34EqUNi6sU
VcKR9sixrVa8GlTz2rSpnnAMz39xZ7vUgMvukjkTeweiX8yfaX6sRX+S6Cm6
aQRYFUrt3ofqwf78+reuiQhkKp8XLHzYAOeBrprZgkjcn6XPqBk1Lv9erR5n
F4Wsg+NszWdN2HSa7dtLiUb946NGSYwW7FRhI7cjGiLiR8eX+FoR1pP+eu56
DExUq/Z51bVC11Bi71eDWCy28YRN09qgdivH23YkFpN2tD1czzeoXqzdeTzu
LvKyOzI90I5UJZXKWcs4GFTa9czLd6BOr3yrpEA8FCgbfDzmO6CzMuxEz/N4
5KnOUBwG32K0ONhB2iMBOV3Gt+rqO2EaIjIwJJWIZFWqf2HmO3ze2mNKf5cI
BVo1pyixC21RTRfMbyYhmcFdsOF0Q+DlGjbXOBnUQeGKmBs9eENpWr2wmIyi
HC2667X3GD3++Fh8bgruSJo9lHHvRTZ1snpEKxWZ+X1CAhe5YEfLGrX8kwoD
5R1FJ1h9oMaJXp0kUxHYUEX9m9mPcW+F7a57CTB3cVkPaDyQB5tL78UQ0NJ3
Y/k/5mH/yc7tSncJfCgrzK0o5SHjfH9cQRyB8D1TgtPlPLgmjPuVJxKw2hCw
xuU5D9PfJPA6jUCzTfwBizoe1oWfrP9RQGDHnYJk+W4eaJ1jXX/WEeC3lqnh
LvAQNzx78F09AUv5EmPKEg8LP/mf2r4isOWQWq8NP4kqqniSczMBR98qeqsg
icOXd9tfbSdwnmoWWr2ehL309aGsfgKM+1PND2RJVKsH01VJArs3Kw6PyZFQ
PBDZ+PADgbOGVFlVBRLf3NLznw8QyAiJ7c5RIuH1osGz4ysBFY1NN9I1SXS3
v/lwfGS5n8xz/aRNQn/wvWX/KAGXRRFP+V0k+MVGdYbHCRS4K9YReiROKcxk
eEwQuKzxXpI0IFGryyc5NUmAYmLFkQUJpd+FgnynCQinhwsxjUjcdtj4Y2mG
QL9JWFbKfhL/AU8piRQ=
             "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
       "HighlightElements" -> <|
         "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
        "LayoutOptions" -> <|
         "PlotRange" -> {{83.8058, 2300}, {0., 35364.98932613222}}, 
          "Frame" -> {{True, True}, {True, True}}, 
          "AxesOrigin" -> {150.687, 0.}, 
          "ImageSize" -> {400, 400/GoldenRatio}, "Axes" -> {True, True}, 
          "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
          "DefaultStyle" -> {
            Directive[
             Opacity[1.], 
             AbsoluteThickness[2], 
             RGBColor[1, 0, 0]]}, 
          "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
              Identity[
               Part[#, 1]], 
              Identity[
               Part[#, 2]]}& ), 
            "ScalingFunctions" -> {{Identity, Identity}, {
              Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>,
         "Meta" -> <|
         "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
          Plot, "GroupHighlight" -> False|>|>]]& )[<|
      "HighlightElements" -> <|
        "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
       "LayoutOptions" -> <|
        "PlotRange" -> {{83.8058, 2300}, {0., 35364.98932613222}}, 
         "Frame" -> {{True, True}, {True, True}}, 
         "AxesOrigin" -> {150.687, 0.}, "ImageSize" -> {400, 400/GoldenRatio},
          "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
         GoldenRatio^(-1), "DefaultStyle" -> {
           Directive[
            Opacity[1.], 
            AbsoluteThickness[2], 
            RGBColor[1, 0, 0]]}, 
         "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
             Identity[
              Part[#, 1]], 
             Identity[
              Part[#, 2]]}& ), 
           "ScalingFunctions" -> {{Identity, Identity}, {
             Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>, 
       "Meta" -> <|
        "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
         Plot, "GroupHighlight" -> False|>|>],
     ImageSizeCache->{{4.503599627370496*^15, -4.503599627370496*^15}, {
      4.503599627370496*^15, -4.503599627370496*^15}}]},
   Annotation[{{{{}, {}, 
       Annotation[{
         Directive[
          Opacity[1.], 
          AbsoluteThickness[2], 
          RGBColor[1, 0, 0]], 
         Line[CompressedData["
1:eJwVjnk41AkAhlEqSVGUHZJlmZT7mJKjLwqpdu06qolmkKRxpANR25SR2Bw5
c/sp95nKUSpaZ46IhAzzqxQKj9wha//4nvd5n/ef71cHj7+cBPj4+CyX9z8X
L3FnIias0NaVPbay8MFe99OBGpu2WUPI3mKn9vgq9NlosCLNrbHZ+Fpffslm
VO4K6Isklr1Qi3cvVxGcOeWaqD9sQNFRbsYrGtZdvRIRk3sUVsOfyGRZU0hz
pFTiHekQv1KT5Pf2KPQjjjsQ7QyESKvrfdNywbbZtTuc+JmYMaynfc9zgSx1
KG1OkokB9dAwG8WzkA9Ij5IzY2KaLmqlS2Fh+z4Zn4sZTISKyFGZq9ygWb5h
r6SjPQI9/A7/9D4Hk+zvTYxeB1SwvzJY/hfhEVQ2ONrihGjmXEyj1FXIXLng
ImzBQr7+hPcxViA+Dmh9rKKfg9d6cj4zOBytnzsihMwuQJahKShhFoMRtoiz
xQovuERpP83amAi5SdcKuTkfRAX5SLs5EXgrMbQkR/qB+2JObO3gfZS0LjjL
xf6NSoGhUkPbLBwrTsjq/JeNe5f27R83z8NIPadQSv4GfMq1xiZFi1BJu5Lv
7ecP5cO2DlhVDFmx1a6/jHPgSwvV0dV7hC1l3IonR27igKc2L9CuBAmNpi1E
XSDiXxWnjFWVwY5W2ZmyJwjejmvvCqo9RakbxzMpKhicUwYrAvyfIUmst4kn
fBtFM+tbWOsrIXXj2hP5syFYMN4lZH2kCgqMkjN5A6EoHjL73l34EqUNi6sU
VcKR9sixrVa8GlTz2rSpnnAMz39xZ7vUgMvukjkTeweiX8yfaX6sRX+S6Cm6
aQRYFUrt3ofqwf78+reuiQhkKp8XLHzYAOeBrprZgkjcn6XPqBk1Lv9erR5n
F4Wsg+NszWdN2HSa7dtLiUb946NGSYwW7FRhI7cjGiLiR8eX+FoR1pP+eu56
DExUq/Z51bVC11Bi71eDWCy28YRN09qgdivH23YkFpN2tD1czzeoXqzdeTzu
LvKyOzI90I5UJZXKWcs4GFTa9czLd6BOr3yrpEA8FCgbfDzmO6CzMuxEz/N4
5KnOUBwG32K0ONhB2iMBOV3Gt+rqO2EaIjIwJJWIZFWqf2HmO3ze2mNKf5cI
BVo1pyixC21RTRfMbyYhmcFdsOF0Q+DlGjbXOBnUQeGKmBs9eENpWr2wmIyi
HC2667X3GD3++Fh8bgruSJo9lHHvRTZ1snpEKxWZ+X1CAhe5YEfLGrX8kwoD
5R1FJ1h9oMaJXp0kUxHYUEX9m9mPcW+F7a57CTB3cVkPaDyQB5tL78UQ0NJ3
Y/k/5mH/yc7tSncJfCgrzK0o5SHjfH9cQRyB8D1TgtPlPLgmjPuVJxKw2hCw
xuU5D9PfJPA6jUCzTfwBizoe1oWfrP9RQGDHnYJk+W4eaJ1jXX/WEeC3lqnh
LvAQNzx78F09AUv5EmPKEg8LP/mf2r4isOWQWq8NP4kqqniSczMBR98qeqsg
icOXd9tfbSdwnmoWWr2ehL309aGsfgKM+1PND2RJVKsH01VJArs3Kw6PyZFQ
PBDZ+PADgbOGVFlVBRLf3NLznw8QyAiJ7c5RIuH1osGz4ysBFY1NN9I1SXS3
v/lwfGS5n8xz/aRNQn/wvWX/KAGXRRFP+V0k+MVGdYbHCRS4K9YReiROKcxk
eEwQuKzxXpI0IFGryyc5NUmAYmLFkQUJpd+FgnynCQinhwsxjUjcdtj4Y2mG
QL9JWFbKfhL/AU8piRQ=
          "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
    "HighlightElements" -> <|
      "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
     "LayoutOptions" -> <|
      "PlotRange" -> {{83.8058, 2300}, {0., 35364.98932613222}}, 
       "Frame" -> {{True, True}, {True, True}}, "AxesOrigin" -> {150.687, 0.},
        "ImageSize" -> {400, 400/GoldenRatio}, "Axes" -> {True, True}, 
       "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), "DefaultStyle" -> {
         Directive[
          Opacity[1.], 
          AbsoluteThickness[2], 
          RGBColor[1, 0, 0]]}, 
       "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
           Identity[
            Part[#, 1]], 
           Identity[
            Part[#, 2]]}& ), 
         "ScalingFunctions" -> {{Identity, Identity}, {Identity, Identity}}|>,
        "Primitives" -> {}, "GCFlag" -> False|>, 
     "Meta" -> <|
      "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
       Plot, "GroupHighlight" -> False|>|>, "DynamicHighlight"]],
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{150.687, 0.},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{
     FormBox[
      TagBox[
       TemplateBox[{"P", "\"MPa\"", "megapascals", "\"Megapascals\""}, 
        "QuantityTF", SyntaxForm -> Mod], HoldForm], TraditionalForm], None}, {
     FormBox[
      TagBox[
       TemplateBox[{
         TagBox[
          TagBox["T", HoldForm], HoldForm], "\"K\"", "kelvins", 
         "\"Kelvins\""}, "QuantityTF", SyntaxForm -> Mod], HoldForm], 
      TraditionalForm], None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  ImageSize->400,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{83.8058, 2300}, {0., 35364.98932613222}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellLabel->"Out[6]=",
 CellID->90441827,ExpressionUUID->"844b7e28-2c73-40e3-8b62-bd7432c36740"]
}, Open  ]],

Cell["Melting point temperature", "ExampleText",
 CellID->171785798,ExpressionUUID->"b8216d2f-0e93-40ef-9ae9-9585e2ec458a"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"NormalPressure", "=", 
   RowBox[{"N", "@", 
    RowBox[{"QuantityMagnitude", "@", 
     RowBox[{"UnitConvert", "[", 
      RowBox[{
       RowBox[{"Quantity", "[", 
        RowBox[{"1", ",", "\"\<atm\>\""}], "]"}], ",", "\"\<MPa\>\""}], 
      "]"}]}]}]}], ";"}], "\n", 
 RowBox[{"Tm", "=", 
  RowBox[{"Quantity", "[", 
   RowBox[{
    RowBox[{"x", "/.", 
     RowBox[{"FindRoot", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"PFusionArgon", "[", "x", "]"}], "\[Equal]", 
        "NormalPressure"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "ttr", ",", "84"}], "}"}]}], "]"}]}], ",", 
    "\"\<Kelvins\>\""}], "]"}]}]}], "Input",
 CellLabel->"In[7]:=",
 CellID->228305278,ExpressionUUID->"c444a71a-4157-4d51-9241-d2010352045b"],

Cell[BoxData[
 TemplateBox[{"83.81369369396903`", "\"K\"", "kelvins", "\"Kelvins\""},
  "Quantity"]], "Output",
 CellLabel->"Out[7]=",
 CellID->312438537,ExpressionUUID->"a4325de1-cc40-40d5-b1c1-7dcc4cf0c4df"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UnitConvert", "[", 
  RowBox[{
   TemplateBox[{"83.81369369396903`"},
    "QuantityUnit",
    DisplayFunction->(TooltipBox[
      StyleBox[
       RowBox[{#, "\[InvisibleSpace]", 
         StyleBox[
          RowBox[{" ", "\"K\""}], "QuantityUnitTraditionalLabel"]}], 
       ShowStringCharacters -> False], "Unit: kelvins"]& ),
    InterpretationFunction->(RowBox[{"Quantity", "[", 
       RowBox[{#, ",", "\"Kelvins\""}], "]"}]& )], ",", 
   "\"\<DegreesCelsius\>\""}], "]"}]], "Input",
 NumberMarks->False,
 CellLabel->"In[8]:=",
 CellID->102930547,ExpressionUUID->"66b6c023-5e80-4c35-858a-b115131da3e9"],

Cell[BoxData[
 TemplateBox[{
   RowBox[{"-", "189.33630630603096`"}], "\"\[Degree]C\"", "degrees Celsius", 
   "\"DegreesCelsius\""},
  "Quantity"]], "Output",
 CellLabel->"Out[8]=",
 CellID->114302638,ExpressionUUID->"0648feff-340b-4cb7-9c82-ed1867bb04d4"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Tm", "-", 
  RowBox[{"Quantity", "[", 
   RowBox[{"ttr", ",", "\"\<Kelvins\>\""}], "]"}]}]], "Input",
 CellLabel->"In[9]:=",
 CellID->117973734,ExpressionUUID->"0d695bff-2a03-4cd1-b3f2-8682a66c2903"],

Cell[BoxData[
 TemplateBox[{"0.00789369396902373`", "\"K\"", "kelvins", "\"Kelvins\""},
  "Quantity"]], "Output",
 CellLabel->"Out[9]=",
 CellID->464227,ExpressionUUID->"a7c84fcf-db62-4f7a-aa5c-300852584ebb"]
}, Open  ]],

Cell["Using ThermodynamicData package (i.e. REFPROP from NIST)", "ExampleText",
 CellID->361149294,ExpressionUUID->"59c03761-feaf-4564-889b-6ce514eea766"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UnitConvert", "[", 
  RowBox[{"ThermodynamicData", "[", 
   RowBox[{"\"\<Argon\>\"", ",", "\"\<SolidLiquidPhaseBoundary\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"\"\<Pressure\>\"", "\[Rule]", 
      RowBox[{"Quantity", "[", 
       RowBox[{"1", ",", "\"\<Atmospheres\>\""}], "]"}]}], "}"}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[10]:=",
 CellID->375583457,ExpressionUUID->"75d0b063-92bf-41b9-ae00-5a6612c59db6"],

Cell[BoxData[
 TemplateBox[{"83.81393880375637`", "\"K\"", "kelvins", "\"Kelvins\""},
  "Quantity"]], "Output",
 CellLabel->"Out[10]=",
 CellID->737233985,ExpressionUUID->"d0dd4f49-3399-4557-b41c-6ee34234ea5f"]
}, Open  ]],

Cell["Using WolframAlpha", "ExampleText",
 CellID->351008126,ExpressionUUID->"38331c03-aa96-4152-9614-282de0d1ca44"],

Cell[CellGroupData[{

Cell[BoxData[
 NamespaceBox["WolframAlphaQueryResults",
  DynamicModuleBox[{Typeset`q$$ = "melting line of argon", Typeset`opts$$ = {
   AppearanceElements -> {"Extrusion", "Warnings", "Assumptions", "Pods"}, 
    Asynchronous -> All, 
    Method -> {
     "ExtrusionChosen" -> {"Result", "Result", 1, 1, "Content"}, 
      "ExtrusionOpen" -> True, 
      "Formats" -> {"cell", "minput", "moutput", "msound", "dataformats"}}}, 
   Typeset`elements$$ = {"Extrusion", "Warnings", "Assumptions", "Pods"}, 
   Typeset`pod1$$ = XMLElement[
   "pod", {"title" -> "Input interpretation", "scanner" -> "Identity", "id" -> 
     "Input", "position" -> "100", "error" -> "false", "numsubpods" -> "1"}, {
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement["cell", {"compressed" -> False, "string" -> True}, {
         Cell[
          BoxData[
           FormBox[
            TagBox[
             FormBox[
              TagBox[
               GridBox[{{
                  PaneBox[
                   StyleBox[
                    TagBox[
                    GridBox[{{
                    StyleBox[
                    TagBox[
                    TagBox["\"argon\"", 
                    $CellContext`TagBoxWrapper[
                    "Entity" -> {ChemicalData, "Argon"}]], Identity], {
                    LineIndent -> 0, LineSpacing -> {0.9, 0, 1.5}}], 
                    "\"melting curve\""}}, GridBoxBackground -> {"Columns" -> {
                    GrayLevel[0.949], None}, "Rows" -> {{None}}}, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    ColumnsEqual -> False, RowsEqual -> False, 
                    GridBoxDividers -> {"Columns" -> {
                    GrayLevel[0.84], 
                    GrayLevel[0.84], 
                    GrayLevel[0.84]}, "Rows" -> {{
                    GrayLevel[0.84]}}, 
                    "RowsIndexed" -> {
                    1 -> GrayLevel[0.84], -1 -> GrayLevel[0.84]}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {1, 1, 1}, "Rows" -> {{0.3}}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Baseline}}}, 
                    AllowScriptLevelChange -> False, BaselinePosition -> 1], 
                    $CellContext`TagBoxWrapper["Separator" -> " | "]], 
                    LineSpacing -> {1, 0, 1.5}, LineIndent -> 0], 
                   BaselinePosition -> Center]}}, 
                GridBoxItemSize -> {
                 "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                ColumnsEqual -> False, RowsEqual -> False, 
                GridBoxSpacings -> {"Columns" -> {{
                    AbsoluteThickness[-1]}}, "Rows" -> {{0}}}, 
                AllowScriptLevelChange -> False], 
               $CellContext`TagBoxWrapper["Separator" -> " | "]], 
              TraditionalForm], 
             PolynomialForm[#, TraditionalOrder -> False]& ], 
            TraditionalForm]], "Output"]}], 
       XMLElement[
       "dataformats", {}, {"plaintext,computabledata,formatteddata"}]}]}], 
   Typeset`pod2$$ = XMLElement[
   "pod", {"title" -> "Result", "scanner" -> "Data", "id" -> "Result", 
     "position" -> "200", "error" -> "false", "numsubpods" -> "1", "primary" -> 
     "true"}, {
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement["cell", {"compressed" -> True, "string" -> False}, {
         Cell[
          BoxData[
           FormBox[
            GraphicsBox[{
              RGBColor[
              0.9921487999999999, 0.8385818666666667, 0.6927381333333333], 
              PolygonBox[CompressedData["
1:eJxF12k4VP//x3EShRLNPhiDSpuSylLhVbYWSjizWGdGKEskbYpKSaSyVaKk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               "]], 
              RGBColor[0.998154, 0.933974, 0.820264], 
              
              PolygonBox[{{34.70799139519819, -2.}, {
                34.91252718895768, -1.9316183751118894`}, {
                35.119487950742865`, -1.8632367502237785`}, {
                35.328917063246706`, -1.794855125335668}, {
                35.540858950182624`, -1.7264735004475573`}, {
                35.75535910770126, -1.6580918755594465`}, {
                35.97246413695107, -1.5897102506713359`}, {
                36.19222177783202, -1.5213286257832253`}, {
                36.414680943993716`, -1.4529470008951146`}, {
                36.63989175913207, -1.3845653760070038`}, {
                36.867905594640966`, -1.3161837511188932`}, {
                37.0987751086786, -1.2478021262307823`}, {
                37.332554286710696`, -1.1794205013426717`}, {
                37.569298483596334`, -1.1110388764545611`}, {
                37.809064467285246`, -1.0426572515664505`}, {
                38.05191046419911, -0.9742756266783397}, {
                38.29789620637293, -0.905894001790229}, {
                38.54708298043684, -0.8375123769021184}, {
                38.79953367852254, -0.7691307520140076}, {
                39.055312851183345`, -0.700749127125897}, {
                39.314486762421225`, -0.6323675022377864}, {
                39.57712344691951, -0.5639858773496755}, {
                39.84329276958502, -0.4956042524615649}, {
                40.11306648750908, -0.4272226275734543}, {
                40.386518314039954`, -0.35884100268534347`}, {
                40.663723987931604`, -0.29045937779723285`}, {
                40.94476133961909, -0.22207775290912224`}, {
                41.22971036722177, -0.15369612802101162`}, {
                41.5186533113407, -0.08531450313290079}, {
                41.81167473420561, -0.016932878244790173`}, {
                42.10886160219837, 0.051448746643320664`}, {42.41030337204617,
                 0.11983037153143128`}, {42.716092080228236`, 
                0.1882119964195419}, {43.02632243742715, 
                0.2565936213076525}, {43.341091925239034`, 
                0.3249752461957631}, {43.660500899258196`, 
                0.39335687108387374`}, {43.98465269530023, 
                0.4617384959719848}, {44.31365374092918, 
                0.5301201208600954}, {44.64761367204745, 0.598501745748206}, {
                44.98664545454281, 0.6668833706363166}, {45.33086551184171, 
                0.7352649955244273}, {45.68039385814082, 
                0.8036466204125379}, {46.035354237925965`, 
                0.8720282453006489}, {46.395874272039705`, 
                0.9404098701887595}, {46.76208561066557, 
                1.0087914950768702`}, {47.134124093594, 
                1.0771731199649808`}, {47.51212991831981, 
                1.1455547448530914`}, {47.8962478160144, 1.213936369741202}, {
                48.28662723643945, 1.282317994629313}, {48.68342254176519, 
                1.3506996195174237`}, {49.086793210084316`, 
                1.4190812444055343`}, {49.49690404912585, 
                1.487462869293645}, {49.91392542077174, 
                1.5558444941817555`}, {50.33803347701921, 
                1.6242261190698661`}, {50.76941040807576, 
                1.6926077439579768`}, {51.20824470332086, 
                1.7609893688460878`}, {51.65473142591951, 
                1.8293709937341984`}, {52.109072501928544`, 
                1.897752618622309}, {52.571477024795655`, 
                1.9661342435104197`}, {53.0421615762158, 
                2.0345158683985307`}, {53.52135056437972, 
                2.1028974932866413`}, {54.0092765807242, 2.171279118174752}, {
                54.50618077637429, 2.2396607430628626`}, {55.01231325956622, 
                2.308042367950973}, {55.527933515403895`, 
                2.376423992839084}, {56.05331084946308, 
                2.4448056177271944`}, {56.58872485680818, 
                2.513187242615305}, {57.134465918150845`, 
                2.5815688675034156`}, {57.69083572499793, 
                2.6499504923915262`}, {58.25814783578402, 
                2.718332117279637}, {58.83672826514298, 
                2.7867137421677475`}, {59.42691610864493, 
                2.855095367055859}, {60.02906420551456, 
                2.9234769919439696`}, {60.64353984205222, 2.99185861683208}, {
                61.27072549870421, 3.060240241720191}, {61.911019643975656`, 
                3.1286218666083014`}, {62.56483757864846, 
                3.197003491496412}, {63.232612334063035`, 
                3.2653851163845227`}, {63.91479562854651, 
                3.3337667412726333`}, {64.61185888642648, 
                3.402148366160744}, {65.32429432446114, 
                3.4705299910488545`}, {66.05261611094704, 
                3.538911615936965}, {66.79736160324089, 
                3.6072932408250757`}, {67.55909266995438, 
                3.6756748657131864`}, {68.33839710465976, 
                3.744056490601298}, {69.13589013858054, 
                3.8124381154894085`}, {69.95221606044987, 
                3.880819740377519}, {70.78804995249891, 
                3.9492013652656297`}, {71.64409955240707, 4.01758299015374}, {
                72.52110725200659, 4.085964615041851}, {73.41985224460542, 
                4.1543462399299615`}, {74.34115283398269, 
                4.222727864818072}, {75.28586891943837, 4.291109489706183}, {
                76.2549046727596, 4.359491114594293}, {77.2492114246207, 
                4.427872739482404}, {78.26979077978572, 4.496254364370515}, {
                79.3176979825564, 4.564635989258626}, {80.39404555623624, 
                4.633017614146737}, {81.50000724299854, 4.701399239034847}, {
                82.63682227348902, 4.769780863922958}, {83.8058, 
                4.838162488879449}, {83.99084518572313, 4.847406197782846}, {
                84.1767597458391, 4.856649906686244}, {84.36356385495256, 
                4.865893615589641}, {84.5512636801047, 4.875137324493039}, {
                84.7398654406117, 4.884381033396436}, {84.92937540853102, 
                4.893624742299834}, {85.11979990913053, 4.902868451203231}, {
                85.31114532136088, 4.912112160106629}, {85.50341807833172, 
                4.921355869010026}, {85.69662466779197, 4.930599577913424}, {
                85.89077163261193, 4.939843286816821}, {86.0858655712712, 
                4.949086995720219}, {86.28191313834682, 4.958330704623616}, {
                86.47892104500943, 4.9675744135270135`}, {86.67689605951715, 
                4.97681812243041}, {86.8758450077177, 4.986061831333808}, {
                87.07577477355166, 4.995305540237205}, {87.27669229955929, 
                5.004549249140603}, {87.47860458739017, 5.013792958044}, {
                87.681518698318, 5.023036666947398}, {87.8854417537566, 
                5.032280375850795}, {88.09038093577934, 5.041524084754193}, {
                88.29634348764387, 5.05076779365759}, {88.50333671431687, 
                5.060011502560988}, {88.71136798300378, 5.069255211464385}, {
                88.92044472368262, 5.078498920367783}, {89.13057442963725, 
                5.08774262927118}, {89.3417646579974, 5.0969863381745775`}, {
                89.55402303027874, 5.1062300470779745`}, {89.76735723292755, 
                5.115473755981372}, {89.98177501786766, 5.124717464884769}, {
                90.19728420304949, 5.133961173788167}, {90.41389267300114, 
                5.143204882691564}, {90.63160837938514, 5.152448591594962}, {
                90.8504393415541, 5.161692300498359}, {91.07039364710936, 
                5.170936009401757}, {91.29147945246349, 5.180179718305154}, {
                91.51370498340428, 5.189423427208552}, {91.7370785356587, 
                5.198667136111949}, {91.96160847546244, 5.207910845015347}, {
                92.18730324012778, 5.217154553918744}, {92.41417133861542, 
                5.226398262822141}, {92.64222135210628, 
                5.2356419717255385`}, {92.87146193457643, 
                5.244885680628936}, {93.10190181337055, 5.254129389532333}, {
                93.33354978977944, 5.26337309843573}, {93.56641473961605, 
                5.272616807339128}, {93.80050561379367, 5.281860516242525}, {
                94.03583143890447, 5.291104225145923}, {94.2724013177961, 
                5.30034793404932}, {94.51022443015258, 5.309591642952718}, {
                94.74931003307108, 5.318835351856115}, {94.98966746164082, 
                5.328079060759513}, {95.23130612951962, 5.33732276966291}, {
                95.4742355295113, 5.346566478566308}, {95.71846523414051, 
                5.355810187469705}, {95.96400489622653, 
                5.3650538963731025`}, {96.2108642494558, 
                5.3742976052764995`}, {96.45905310895184, 
                5.383541314179897}, {96.7085813718428, 5.392785023083294}, {
                96.95945901782667, 5.402028731986692}, {97.21169610973278, 
                5.411272440890089}, {97.46530279408012, 5.420516149793487}, {
                97.72028930163141, 5.429759858696884}, {97.97666594794377, 
                5.439003567600282}, {98.23444313391289, 5.448247276503679}, {
                98.49363134631406, 5.457490985407077}, {98.75424115833438, 
                5.466734694310474}, {99.01628323010259, 5.475978403213872}, {
                99.27976830920771, 5.485222112117269}, {99.54470723121388, 
                5.4944658210206665`}, {99.8111109201652, 
                5.5037095299240635`}, {100.07899038908172`, 
                5.512953238827461}, {100.34835674044662`, 
                5.522196947730858}, {100.61922116668451`, 
                5.531440656634256}, {100.89159495062458`, 
                5.540684365537653}, {101.16548946595773`, 
                5.549928074441051}, {101.44091617767772`, 
                5.559171783344448}, {101.71788664250836`, 
                5.568415492247846}, {101.99641250931926`, 
                5.577659201151243}, {102.2765055195242, 5.58690291005464}, {
                102.55817750746374`, 5.596146618958038}, {102.8414404007703, 
                5.605390327861436}, {103.12630622071586`, 
                5.614634036764833}, {103.41278708253819`, 5.62387774566823}, {
                103.70089519574805`, 5.6331214545716275`}, {
                103.99064286441235`, 5.642365163475025}, {104.28204248740354`,
                 5.651608872378422}, {104.57510655868734`, 
                5.660852581281819}, {104.86984766744166`, 
                5.670096290185217}, {105.16627849830782`, 
                5.679339999088614}, {105.46441183151956`, 
                5.688583707992012}, {105.76426054302321`, 
                5.697827416895409}, {106.06583760456346`, 
                5.707071125798807}, {106.36915608373204`, 
                5.716314834702204}, {106.67422914396622`, 
                5.725558543605602}, {106.98107004456625`, 
                5.734802252508999}, {107.28969214057224`, 
                5.744045961412397}, {107.60010888267915`, 
                5.753289670315794}, {107.91233381706951`, 
                5.7625333792191915`}, {108.22638058520111`, 
                5.7717770881225885`}, {108.54226292354369`, 
                5.781020797025986}, {108.8599946632582, 5.790264505929383}, {
                109.17958972981812`, 5.799508214832781}, {109.50106214256611`,
                 5.808751923736178}, {109.82442601420873`, 
                5.817995632639576}, {110.14969555023633`, 
                5.827239341542973}, {110.4768850482724, 5.836483050446371}, {
                110.80600889734401`, 5.845726759349768}, {111.13708157706893`,
                 5.854970468253166}, {111.47011765675623`, 
                5.864214177156563}, {111.80513179441363`, 
                5.873457886059961}, {112.1421387356586, 5.882701594963358}, {
                112.48115331252426`, 5.8919453038667555`}, {
                112.82219044215708`, 5.9011890127701525`}, {
                113.16526512540015`, 5.91043272167355}, {113.51039244525099`, 
                5.919676430576947}, {113.85758756519375`, 
                5.928920139480345}, {114.2068657273904, 5.938163848383742}, {
                114.55824225073243`, 5.947407557287139}, {114.91173252873341`,
                 5.956651266190537}, {115.26735202726314`, 
                5.965894975093935}, {115.62511628210883`, 
                5.975138683997332}, {115.98504089635362`, 
                5.984382392900729}, {116.34714153756316`, 
                5.993626101804127}, {116.7114339347678, 6.002869810707525}, {
                117.0779338752275, 6.012113519610922}, {117.44665720096857`, 
                6.021357228514319}, {117.81761980507504`, 
                6.0306009374177165`}, {118.1908376277242, 
                6.039844646321114}, {118.56632665194562`, 
                6.049088355224511}, {118.94410289909038`, 
                6.058332064127908}, {119.32418242399024`, 
                6.067575773031306}, {119.70658130978738`, 
                6.076819481934704}, {120.09131566241346`, 
                6.086063190838101}, {120.47840160469522`, 
                6.095306899741498}, {120.86785527005998`, 
                6.104550608644896}, {121.25969279581635`, 
                6.113794317548294}, {121.65393031597773`, 
                6.123038026451691}, {122.05058395359653`, 
                6.132281735355088}, {122.44966981257525`, 
                6.141525444258486}, {122.85120396891317`, 
                6.150769153161883}, {123.25520246134765`, 
                6.1600128620652805`}, {123.6616812813435, 
                6.1692565709686775`}, {124.07065636238084`, 
                6.178500279872075}, {124.48214356848776`, 
                6.187743988775472}, {124.89615868195884`, 6.19698769767887}, {
                125.31271739020131`, 6.206231406582267}, {125.73183527164093`,
                 6.215475115485665}, {126.15352778061992`, 
                6.224718824389062}, {126.57781023121808`, 6.23396253329246}, {
                127.00469777991755`, 6.243206242195857}, {127.43420540703822`,
                 6.252449951099255}, {127.86634789685702`, 
                6.261693660002652}, {128.30113981632977`, 6.27093736890605}, {
                128.73859549231622`, 6.280181077809447}, {129.1787289872134, 
                6.2894247867128446`}, {129.62155407288319`, 
                6.2986684956162415`}, {130.06708420274563`, 
                6.307912204519639}, {130.5153324818963, 6.317155913423036}, {
                130.96631163507573`, 6.326399622326434}, {131.42003397229016`,
                 6.335643331229831}, {131.8765113518465, 6.344887040133228}, {
                132.3357551405165, 6.354130749036626}, {132.7977761704866, 
                6.363374457940024}, {133.2625846926909, 6.372618166843421}, {
                133.73019032603708`, 6.381861875746818}, {134.20060200194564`,
                 6.391105584650216}, {134.67382790351365`, 
                6.400349293553614}, {135.14987539847556`, 
                6.409593002457011}, {135.62875096498016`, 
                6.418836711360408}, {136.11046010900722`, 
                6.4280804202638056`}, {136.59500727201333`, 
                6.437324129167203}, {137.08239572711074`, 6.4465678380706}, {
                137.5726274617188, 6.455811546973997}, {138.06570304419176`, 
                6.465055255877395}, {138.56162147135086`, 
                6.474298964780793}, {139.06037999315362`, 6.48354267368419}, {
                139.56197390980867`, 6.492786382587587}, {140.06639633549062`,
                 6.502030091490985}, {140.57363792127995`, 
                6.511273800394383}, {141.08368652798893`, 6.52051750929778}, {
                141.5965268368966, 6.529761218201177}, {142.11213988291723`, 
                6.539004927104575}, {142.63050248996922`, 
                6.548248636007972}, {143.15158658174636`, 6.55749234491137}, {
                143.67535833187867`, 6.5667360538147665`}, {
                144.20177710423735`, 6.575979762718164}, {144.73079411460282`,
                 6.585223471621561}, {145.26235071522774`, 
                6.594467180524959}, {145.79637615679485`, 
                6.603710889428356}, {146.33278460494654`, 
                6.612954598331754}, {146.8714710530752, 6.622198307235151}, {
                147.41230552184987`, 6.631442016138549}, {147.95512442799316`,
                 6.640685725041946}, {148.49971686641967`, 
                6.649929433945344}, {149.04580060970423`, 
                6.659173142848741}, {149.5929733101083, 6.668416851752139}, {
                150.1405829400286, 6.677660560655536}, {150.687, 
                6.686904269558934}, {2999.997, 6.686904269568177}, {
                2999.997, -2}}], 
              RGBColor[0.9888385333333334, 0.7798814666666667, 0.5990192], 
              
              PolygonBox[{{0., -2}, {34.70799139519819, -2.}, {
                34.91252718895768, -1.9316183751118894`}, {
                35.119487950742865`, -1.8632367502237785`}, {
                35.328917063246706`, -1.794855125335668}, {
                35.540858950182624`, -1.7264735004475573`}, {
                35.75535910770126, -1.6580918755594465`}, {
                35.97246413695107, -1.5897102506713359`}, {
                36.19222177783202, -1.5213286257832253`}, {
                36.414680943993716`, -1.4529470008951146`}, {
                36.63989175913207, -1.3845653760070038`}, {
                36.867905594640966`, -1.3161837511188932`}, {
                37.0987751086786, -1.2478021262307823`}, {
                37.332554286710696`, -1.1794205013426717`}, {
                37.569298483596334`, -1.1110388764545611`}, {
                37.809064467285246`, -1.0426572515664505`}, {
                38.05191046419911, -0.9742756266783397}, {
                38.29789620637293, -0.905894001790229}, {
                38.54708298043684, -0.8375123769021184}, {
                38.79953367852254, -0.7691307520140076}, {
                39.055312851183345`, -0.700749127125897}, {
                39.314486762421225`, -0.6323675022377864}, {
                39.57712344691951, -0.5639858773496755}, {
                39.84329276958502, -0.4956042524615649}, {
                40.11306648750908, -0.4272226275734543}, {
                40.386518314039954`, -0.35884100268534347`}, {
                40.663723987931604`, -0.29045937779723285`}, {
                40.94476133961909, -0.22207775290912224`}, {
                41.22971036722177, -0.15369612802101162`}, {
                41.5186533113407, -0.08531450313290079}, {
                41.81167473420561, -0.016932878244790173`}, {
                42.10886160219837, 0.051448746643320664`}, {42.41030337204617,
                 0.11983037153143128`}, {42.716092080228236`, 
                0.1882119964195419}, {43.02632243742715, 
                0.2565936213076525}, {43.341091925239034`, 
                0.3249752461957631}, {43.660500899258196`, 
                0.39335687108387374`}, {43.98465269530023, 
                0.4617384959719848}, {44.31365374092918, 
                0.5301201208600954}, {44.64761367204745, 0.598501745748206}, {
                44.98664545454281, 0.6668833706363166}, {45.33086551184171, 
                0.7352649955244273}, {45.68039385814082, 
                0.8036466204125379}, {46.035354237925965`, 
                0.8720282453006489}, {46.395874272039705`, 
                0.9404098701887595}, {46.76208561066557, 
                1.0087914950768702`}, {47.134124093594, 
                1.0771731199649808`}, {47.51212991831981, 
                1.1455547448530914`}, {47.8962478160144, 1.213936369741202}, {
                48.28662723643945, 1.282317994629313}, {48.68342254176519, 
                1.3506996195174237`}, {49.086793210084316`, 
                1.4190812444055343`}, {49.49690404912585, 
                1.487462869293645}, {49.91392542077174, 
                1.5558444941817555`}, {50.33803347701921, 
                1.6242261190698661`}, {50.76941040807576, 
                1.6926077439579768`}, {51.20824470332086, 
                1.7609893688460878`}, {51.65473142591951, 
                1.8293709937341984`}, {52.109072501928544`, 
                1.897752618622309}, {52.571477024795655`, 
                1.9661342435104197`}, {53.0421615762158, 
                2.0345158683985307`}, {53.52135056437972, 
                2.1028974932866413`}, {54.0092765807242, 2.171279118174752}, {
                54.50618077637429, 2.2396607430628626`}, {55.01231325956622, 
                2.308042367950973}, {55.527933515403895`, 
                2.376423992839084}, {56.05331084946308, 
                2.4448056177271944`}, {56.58872485680818, 
                2.513187242615305}, {57.134465918150845`, 
                2.5815688675034156`}, {57.69083572499793, 
                2.6499504923915262`}, {58.25814783578402, 
                2.718332117279637}, {58.83672826514298, 
                2.7867137421677475`}, {59.42691610864493, 
                2.855095367055859}, {60.02906420551456, 
                2.9234769919439696`}, {60.64353984205222, 2.99185861683208}, {
                61.27072549870421, 3.060240241720191}, {61.911019643975656`, 
                3.1286218666083014`}, {62.56483757864846, 
                3.197003491496412}, {63.232612334063035`, 
                3.2653851163845227`}, {63.91479562854651, 
                3.3337667412726333`}, {64.61185888642648, 
                3.402148366160744}, {65.32429432446114, 
                3.4705299910488545`}, {66.05261611094704, 
                3.538911615936965}, {66.79736160324089, 
                3.6072932408250757`}, {67.55909266995438, 
                3.6756748657131864`}, {68.33839710465976, 
                3.744056490601298}, {69.13589013858054, 
                3.8124381154894085`}, {69.95221606044987, 
                3.880819740377519}, {70.78804995249891, 
                3.9492013652656297`}, {71.64409955240707, 4.01758299015374}, {
                72.52110725200659, 4.085964615041851}, {73.41985224460542, 
                4.1543462399299615`}, {74.34115283398269, 
                4.222727864818072}, {75.28586891943837, 4.291109489706183}, {
                76.2549046727596, 4.359491114594293}, {77.2492114246207, 
                4.427872739482404}, {78.26979077978572, 4.496254364370515}, {
                79.3176979825564, 4.564635989258626}, {80.39404555623624, 
                4.633017614146737}, {81.50000724299854, 4.701399239034847}, {
                82.63682227348902, 4.769780863922958}, {83.8058, 
                4.838162488879449}, {83.80671146360098, 4.860476824241787}, {
                83.80767097594419, 4.882791159604125}, {83.80868106958854, 
                4.905105494966462}, {83.80974441053836, 4.9274198303288}, {
                83.81086380527056, 4.9497341656911376`}, {83.81204220813066, 
                4.972048501053475}, {83.81328272911904, 4.994362836415813}, {
                83.81458864208517, 5.01667717177815}, {83.8159633933537, 
                5.038991507140488}, {83.81741061080334, 5.061305842502826}, {
                83.81893411342293, 5.083620177865163}, {83.82053792136963, 
                5.105934513227501}, {83.82222626655573, 5.128248848589838}, {
                83.824003603791, 5.150563183952175}, {83.82587462251092, 
                5.172877519314513}, {83.82784425911947, 
                5.1951918546768505`}, {83.82991770998137, 
                5.217506190039188}, {83.83210044509426, 5.239820525401526}, {
                83.83439822247995, 5.262134860763863}, {83.83681710332944, 
                5.284449196126201}, {83.83936346794195, 5.306763531488539}, {
                83.84204403250044, 5.329077866850876}, {83.84486586672524, 
                5.351392202213214}, {83.84783641245312, 
                5.3737065375755515`}, {83.85096350318896, 
                5.396020872937889}, {83.85425538468164, 5.418335208300227}, {
                83.85772073657549, 5.440649543662564}, {83.86136869519592, 
                5.462963879024902}, {83.865208877525, 5.48527821438724}, {
                83.86925140643142, 5.507592549749577}, {83.87350693721743, 
                5.529906885111915}, {83.87798668555295, 
                5.5522212204742525`}, {83.8827024568671, 5.57453555583659}, {
                83.88766667727263, 5.596849891198928}, {83.89289242610333, 
                5.619164226561265}, {83.89839347014585, 5.641478561923603}, {
                83.90418429965466, 5.663792897285941}, {83.9102801662406, 
                5.686107232648277}, {83.91669712272993, 5.708421568010616}, {
                83.92345206509415, 5.730735903372953}, {83.9305627765575, 
                5.75305023873529}, {83.93804797399167, 5.775364574097628}, {
                83.94592735671682, 5.7976789094599654`}, {83.95422165782873, 
                5.819993244822303}, {83.96295269818177, 5.842307580184641}, {
                83.97214344316303, 5.864621915546978}, {83.98181806239675, 
                5.886936250909316}, {83.99200199252873, 5.909250586271654}, {
                84.00272200324522, 5.931564921633991}, {84.01400626668828, 
                5.953879256996329}, {84.02588443043884, 5.976193592358666}, {
                84.0383876942443, 5.998507927721004}, {84.05154889067849, 
                6.020822263083342}, {84.06540256992854, 6.043136598445679}, {
                84.07998508891299, 6.065450933808017}, {84.0953347049451, 
                6.0877652691703545`}, {84.11149167416424, 
                6.110079604532692}, {84.12849835496944, 6.13239393989503}, {
                84.14639931669852, 6.154708275257367}, {84.16524145380751, 
                6.177022610619705}, {84.18507410581638, 6.199336945982042}, {
                84.20594918329837, 6.22165128134438}, {84.22792130020241, 
                6.243965616706717}, {84.2510479128092, 6.2662799520690555`}, {
                84.27538946563617, 6.288594287431392}, {84.30100954461697, 
                6.310908622793731}, {84.32797503789662, 
                6.3332229581560675`}, {84.35635630459535, 
                6.355537293518405}, {84.3862273519084, 6.377851628880743}, {
                84.41766602092346, 6.40016596424308}, {84.4507541815508, 
                6.422480299605418}, {84.48557793697746, 6.444794634967756}, {
                84.5222278380679, 6.467108970330093}, {84.56079910815279, 
                6.489423305692431}, {84.60139187865799, 
                6.5117376410547685`}, {84.64411143604373, 
                6.534051976417106}, {84.6890684805359, 6.556366311779444}, {
                84.73637939714894, 6.578680647141781}, {84.7861665395103, 
                6.600994982504119}, {84.8385585270137, 6.623309317866457}, {
                84.8936905558393, 6.645623653228794}, {84.95170472439358, 
                6.667937988591132}, {85.01275037373243, 
                6.6902523239534695`}, {85.07698444354347, 
                6.712566659315807}, {85.1445718442725, 6.734880994678145}, {
                85.21568584599108, 6.757195330040482}, {85.29050848460567, 
                6.77950966540282}, {85.36923098602033, 6.801824000765157}, {
                85.45205420886596, 6.824138336127495}, {85.5391891064138, 
                6.846452671489832}, {85.63085720829145, 
                6.8687670068521705`}, {85.72729112261837, 
                6.891081342214507}, {85.82873505917362, 6.913395677576846}, {
                85.93544537420267, 6.935710012939182}, {86.04769113745873, 
                6.958024348301521}, {86.16575472206436, 6.980338683663858}, {
                86.28993241775984, 7.002653019026195}, {86.42053506808601, 
                7.024967354388533}, {86.5578887320268, 7.0472816897508705`}, {
                86.702335370607, 7.069596025113208}, {86.85423355891027, 
                7.091910360475546}, {87.01395922394588, 7.114224695837883}, {
                87.18190640875179, 7.136539031200221}, {87.35848806307816, 
                7.158853366562559}, {87.54413686094314, 7.181167701924896}, {
                87.73930604530376, 7.203482037287234}, {87.9444703000219, 
                7.2257963726495715`}, {88.16012664924914, 
                7.248110708011909}, {88.38679538428492, 7.270425043374246}, {
                88.62502101789843, 7.292739378736584}, {88.87537326603164, 
                7.315053714098921}, {89.13844805673264, 7.33736804946126}, {
                89.4148685660928, 7.359682384823596}, {89.70528628089369, 
                7.381996720185935}, {90.01038208759618, 7.404311055548272}, {
                90.33086738724228, 7.42662539091061}, {90.66748523577279, 
                7.448939726272947}, {91.02101150921648, 7.471254061635285}, {
                91.39225609315281, 7.493568396997622}, {91.78206409582103, 
                7.515882732359961}, {92.19131708422152, 7.538197067722297}, {
                92.62093434255216, 7.560511403084635}, {93.07187415233095, 
                7.582825738446973}, {93.54513509358883, 7.60514007380931}, {
                94.04175736657231, 7.627454409171648}, {94.56282413347328, 
                7.6497687445339855`}, {95.10946287981552, 
                7.672083079896323}, {95.68284679526202, 7.694397415258661}, {
                96.28419617378145, 7.716711750620998}, {96.91477983331511, 
                7.739026085983336}, {97.57591655532646, 7.761340421345674}, {
                98.26897654489197, 7.783654756708011}, {98.99538291230361, 
                7.805969092070349}, {99.75661317750372, 
                7.8282834274326865`}, {100.55420079905512`, 
                7.850597762795024}, {101.38973672976707`, 
                7.872912098157361}, {102.26487100154733`, 
                7.895226433519699}, {103.18131434252106`, 
                7.917540768882036}, {104.14083982996418`, 
                7.939855104244375}, {105.1452845831084, 7.962169439606711}, {
                106.19655150041343`, 7.98448377496905}, {107.29661104643446`, 
                8.006798110331387}, {108.44750309395836`, 
                8.029112445693725}, {109.6513388276096, 8.051426781056062}, {
                110.91030271565364`, 8.0737411164184}, {112.22665455721952`, 
                8.096055451780737}, {113.60273161264449`, 
                8.118369787143076}, {115.0409508250763, 8.140684122505412}, {
                116.54381114187794`, 8.16299845786775}, {118.1138959447286, 
                8.185312793230088}, {119.75387559763219`, 
                8.207627128592424}, {121.46651012229384`, 
                8.229941463954763}, {123.25465201053218`, 
                8.252255799317101}, {125.1212491835466, 8.274570134679438}, {
                127.06934810795092`, 8.296884470041775}, {129.1020970785317, 
                8.319198805404113}, {131.22274967768627`, 
                8.341513140766452}, {133.4346684214503, 8.363827476128789}, {
                135.74132860193984`, 8.386141811491125}, {138.14632233591507`,
                 8.408456146853464}, {140.65336282903846`, 8.4307704822158}, {
                143.26628886524708`, 8.453084817578139}, {145.98906953048757`,
                 8.475399152940476}, {148.82580917991723`, 
                8.497713488302814}, {151.78075265750743`, 
                8.520027823665151}, {154.85829077686998`, 8.54234215902749}, {
                158.06296607200125`, 8.564656494389826}, {161.39947882658558`,
                 8.586970829752165}, {164.87269339043976`, 
                8.609285165114501}, {168.48764479171643`, 8.63159950047684}, {
                172.24954565351325`, 8.653913835839177}, {176.1637934236747, 
                8.676228171201515}, {180.2359779267129, 8.698542506563852}, {
                184.47188924702442`, 8.720856841926189}, {188.8775259528354, 
                8.743171177288527}, {193.45910367067233`, 
                8.765485512650866}, {198.2230640205395, 8.787799848013202}, {
                203.1760839224497, 8.81011418337554}, {208.32508528545893`, 
                8.832428518737878}, {213.67724509092633`, 
                8.854742854100216}, {219.2400058823366, 8.877057189462553}, {
                225.02108667469238`, 8.89937152482489}, {231.02849429717656`, 
                8.921685860187228}, {237.27053518357098`, 
                8.944000195549567}, {243.75582762568834`, 
                8.966314530911903}, {250.49331450592868`, 8.98862886627424}, {
                257.49227652593686`, 9.010943201636579}, {264.762345949246, 
                9.033257536998917}, {272.3135208767548, 9.055571872361254}, {
                280.1561800748349, 9.07788620772359}, {288.30109837690287`, 
                9.10020054308593}, {296.7594626803096, 9.122514878448266}, {
                305.5428885614997, 9.144829213810603}, {314.6634375334729, 
                9.167143549172941}, {324.13363497073635`, 9.18945788453528}, {
                333.96648872810255`, 9.211772219897616}, {344.1755084808982, 
                9.234086555259953}, {354.77472581538285`, 
                9.256400890622292}, {365.7787150994561, 9.27871522598463}, {
                377.20261516507696`, 9.301029561346967}, {0., 
                9.301029561369281}}], 
              RGBColor[
              0.9954590666666666, 0.8972822666666667, 0.7864570666666667], 
              PolygonBox[CompressedData["
1:eJxlkm0s1HEAxy+xZOXSVOemdr+/xEyUunkavspj42wqolge7s7Dn/N4V6a5
UZ0NjbE2h5RsdB6So1uOeWohal262qwQk7lFqxlxRVrzqhffffd583n1IbGi
UL4Bg8Gw3drf9ymi5/XaWAxacrVxvWy4dgyLN0QN/3FT8o8ijpzCpJtgwaNc
gkq3f7xHs1KT/VGMOobFoPIOBf3tOT++vRiKF17rfgUUTNn6z6/zs9FeLDg5
IaGQmTHTLZ7Kgjq0JCGFplDHo6OtzmThOaujlhFDIWC8Oa1GkYmxyYn35Rcp
uJTqmh6zMvGufoepzTkK/PmwgWPFGfiUZOvb5UlhnF0YpDHMwJcTIbnBpyh4
VrU8zctPx9JKtnLahoLwpsTB0Cgdq93VukxLCpsFijKn4jQwCgbJLjMKY6qI
qOlDaTAO1F2SG235lVL3kRAR9jHNSo+vE2hVST2O11JhoXUe6lsiiFQLXBsb
U0BVRW+cnyWYDJmiF6Zp2MXc4s5/IFj0Xelp5tBwsmmmc8YIJN/ecFqFyXBf
fPtwbz/BavXc76bOJPgo1ybudxLUtnpbCE2SEHSds/+0gkBt3JdTx0/EBS//
wKF7BNyjtuFWQwmIMkqVRpYTXLnqsN7mkADBaIVqUUbgIuc9Ma8WIrVMvSTN
JehKzFFZMIUQh89Ym6cT6J5VkBKZAHmHd0c18AkyejtGPYwEKJx1rHCLJIi4
a+f/S8ZH6aOw0Vc8ggomRuRMPipFNwxizhKsJbexF6vi8YBb77rsTGC9rJEN
28dDoX+ZJrMnYElpzc6BOLT3f29gE4JWK5cjkstxUMtYUy0HCHgBm1/1P7f6
CvY66G1CsN3bdk9/AMJrH0k=
               "]], 
              RGBColor[
              0.8980593333333333, 0.8971646666666667, 0.9449146666666667], 
              PolygonBox[{}], 
              InsetBox[
               BoxData[
                FormBox[
                 StyleBox[
                 "\"gas\"", LinebreakAdjustments -> {1, 100, 1, 0, 100}, 
                  LineIndent -> 0, {FontFamily -> "Verdana", FontSize -> 10}, 
                  GrayLevel[0.5], StripOnInput -> False], TraditionalForm]], 
               Scaled[{0.7500000000000002, 0.33556911109677956`}]], 
              InsetBox[
               BoxData[
                FormBox[
                 StyleBox[
                  TagBox[
                   
                   GridBox[{{"\"supercritical\""}, {"\"region\""}}, 
                    GridBoxAlignment -> {"Columns" -> {{Center}}}, 
                    DefaultBaseStyle -> "Column", 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{0.05}}}], 
                   "Column"], LinebreakAdjustments -> {1, 100, 1, 0, 100}, 
                  LineIndent -> 0, {FontFamily -> "Verdana", FontSize -> 10}, 
                  GrayLevel[0.5], StripOnInput -> False], TraditionalForm]], 
               Scaled[{0.798688845401159, 0.7927386364523169}]], 
              InsetBox[
               BoxData[
                FormBox[
                 StyleBox[
                 "\"liquid\"", LinebreakAdjustments -> {1, 100, 1, 0, 100}, 
                  LineIndent -> 0, {FontFamily -> "Verdana", FontSize -> 10}, 
                  GrayLevel[0.5], StripOnInput -> False], TraditionalForm]], 
               Scaled[{0.23953033268101756`, 0.7009332318900475}]], 
              GrayLevel[0.3961454], 
              Thickness[0.003], 
              LineBox[CompressedData["
1:eJwlxQk41AkfwPFxzeTK0RhEWq0kpUOSs/9v7mEYc73UFLmLJoO1lrTrqbyx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               "]], 
              InsetBox[
               BoxData[
                FormBox[
                 StyleBox[
                 "\"sublimation curve\"", 
                  LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                  0, 
                  GrayLevel[0.6], StripOnInput -> False], TraditionalForm]], 
               Scaled[{0.312583170254403, 0.19438054184862447`}]], 
              GrayLevel[0.3961454], 
              Thickness[0.003], 
              LineBox[CompressedData["
1:eJwVkHk01I0bxUl6LW9Ks3xnJkQb+SWlQkXdytJCG7MZM2ZGUZYIqWSJN1lS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               "]], 
              InsetBox[
               BoxData[
                FormBox[
                 StyleBox[
                 "\"saturation curve\"", 
                  LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                  0, 
                  GrayLevel[0.6], StripOnInput -> False], TraditionalForm]], 
               Scaled[{0.4003913894324846, 0.5278388603818929}]], 
              GrayLevel[0.3961454], 
              Thickness[0.003], 
              LineBox[CompressedData["
1:eJwV1Wk4lVsDxnEVKiRsw97bnp6tqEhSjqHizlgnSni2IfNMRDJE40HtU9Eh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               "]], 
              InsetBox[
               BoxData[
                FormBox[
                 StyleBox[
                 "\"melting curve\"", 
                  LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                  0, 
                  GrayLevel[0.6], StripOnInput -> False], TraditionalForm]], 
               Scaled[{0.4687084148727982, 0.877376727598972}]], 
              GrayLevel[0.257923], 
              PointSize[0.021], 
              PointBox[{150.687, 6.686904269568177}], 
              InsetBox[
               BoxData[
                FormBox[
                 StyleBox[
                 "\"critical point\"", 
                  LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                  0, 
                  GrayLevel[0.6], StripOnInput -> False], TraditionalForm]], 
               Scaled[{0.4399217221135022, 0.6680986809021042}]], 
              GrayLevel[0.257923], 
              PointSize[0.021], 
              PointBox[{83.8058, 4.838162488879449}], 
              InsetBox[
               BoxData[
                FormBox[
                 StyleBox[
                 "\"triple point\"", 
                  LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                  0, 
                  GrayLevel[0.6], StripOnInput -> False], TraditionalForm]], 
               Scaled[{0.3004109589041097, 0.38917386090966805`}]], 
              GrayLevel[0.5343678000000001], 
              PointSize[0.021], 
              PointBox[{293.15, 5.00572}], 
              InsetBox[
               BoxData[
                FormBox[
                 StyleBox[
                 "\"STP\"", LinebreakAdjustments -> {1, 100, 1, 0, 100}, 
                  LineIndent -> 0, 
                  GrayLevel[0.6], StripOnInput -> False], TraditionalForm]], 
               Scaled[{0.5659197651663405, 0.4571695253555573}]], 
              RGBColor[1, 0, 0], 
              PointSize[0.021], 
              Thickness[0.003], 
              LineBox[CompressedData["
1:eJwV1Wk4lVsDxnEVKiRsw97bnp6tqEhSjqHizlgnSni2IfNMRDJE40HtU9Eh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               "]]}, {GridLines -> Dynamic[
                Map[{{#, 
                   GrayLevel[0.7]}}& , 
                 MousePosition[{"Graphics", Graphics}, None]]], 
              Method -> {"GridLinesInFront" -> True}, AspectRatio -> 0.8, 
              ImageSize -> 300, 
              PlotRange -> {{-2.2250738585072014`*^-308, 500.0000000000001}, {
                2, 9.301029561369283}}, Frame -> True, PlotRangeClipping -> 
              True, FrameLabel -> {
                FormBox[
                 FormBox[
                  TagBox[
                   FormBox[
                    TemplateBox[{
                    TemplateBox[{
                    StyleBox[
                    "\"temperature\"", 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, {FontFamily -> "Verdana", FontSize -> 10}, 
                    GrayLevel[0.5], StripOnInput -> False], "\"  \""}, 
                    "RowDefault"], 
                    StyleBox[
                    RowBox[{"\"(\"", "\[NoBreak]", 
                    StyleBox[
                    TagBox[
                    RowBox[{
                    StyleBox[
                    "\"K\"", FontFamily -> "Helvetica", FontSize -> 
                    Smaller]}], Identity], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, ZeroWidthTimes -> False], "\[NoBreak]", "\")\""}], {
                    FontFamily -> "Verdana", FontSize -> 10, 
                    GrayLevel[0.5], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0}, StripOnInput -> False]}, "RowDefault"], 
                    TraditionalForm], Format[#, TraditionalForm]& ], 
                  TraditionalForm], TraditionalForm], 
                FormBox[
                 FormBox[
                  TagBox[
                   FormBox[
                    TemplateBox[{
                    TemplateBox[{
                    StyleBox[
                    "\"pressure\"", 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, {FontFamily -> "Verdana", FontSize -> 10}, 
                    GrayLevel[0.5], StripOnInput -> False], "\"  \""}, 
                    "RowDefault"], 
                    StyleBox[
                    RowBox[{"\"(\"", "\[NoBreak]", 
                    StyleBox[
                    TagBox[
                    RowBox[{
                    StyleBox[
                    "\"Pa\"", FontFamily -> "Helvetica", FontSize -> 
                    Smaller]}], Identity], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, ZeroWidthTimes -> False], "\[NoBreak]", "\")\""}], {
                    FontFamily -> "Verdana", FontSize -> 10, 
                    GrayLevel[0.5], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0}, StripOnInput -> False]}, "RowDefault"], 
                    TraditionalForm], Format[#, TraditionalForm]& ], 
                  TraditionalForm], TraditionalForm]}, FrameTicks -> {{{{2, 
                   FormBox[
                    
                    TemplateBox[{"10", "2"}, "Superscript", SyntaxForm -> 
                    SuperscriptBox], TraditionalForm]}, {3, 
                   FormBox[
                    
                    TemplateBox[{"10", "3"}, "Superscript", SyntaxForm -> 
                    SuperscriptBox], TraditionalForm]}, {4, 
                   FormBox[
                    
                    TemplateBox[{"10", "4"}, "Superscript", SyntaxForm -> 
                    SuperscriptBox], TraditionalForm]}, {5, 
                   FormBox[
                    
                    TemplateBox[{"10", "5"}, "Superscript", SyntaxForm -> 
                    SuperscriptBox], TraditionalForm]}, {6, 
                   FormBox[
                    
                    TemplateBox[{"10", "6"}, "Superscript", SyntaxForm -> 
                    SuperscriptBox], TraditionalForm]}, {7, 
                   FormBox[
                    
                    TemplateBox[{"10", "7"}, "Superscript", SyntaxForm -> 
                    SuperscriptBox], TraditionalForm]}, {8, 
                   FormBox[
                    
                    TemplateBox[{"10", "8"}, "Superscript", SyntaxForm -> 
                    SuperscriptBox], TraditionalForm]}, {9, 
                   FormBox[
                    
                    TemplateBox[{"10", "9"}, "Superscript", SyntaxForm -> 
                    SuperscriptBox], TraditionalForm]}}, None}, {
                Automatic, None}}}], TraditionalForm]], "Output"]}], 
       XMLElement["dataformats", {}, {}]}]}], Typeset`aux1$$ = {
   True, False, {False}, True}, Typeset`aux2$$ = {True, False, {False}, True},
    Typeset`asyncpods$$ = {}, Typeset`nonpods$$ = {
    XMLElement["sources", {"count" -> "1"}, {
      XMLElement[
      "source", {
       "url" -> 
        "http://www.wolframalpha.com/sources/\
ThermodynamicDataRPSourceInformationNotes.html", "text" -> 
        "Thermodynamic data RP"}, {}]}]}, Typeset`initdone$$ = True, 
   Typeset`queryinfo$$ = {
   "success" -> "true", "error" -> "false", "numpods" -> "2", "datatypes" -> 
    "ThermodynamicDataRP", "timedout" -> "", "timedoutpods" -> "", "timing" -> 
    "0.917", "parsetiming" -> "0.235", "parsetimedout" -> "false", 
    "recalculate" -> "", "id" -> 
    "MSPa43081ad2ebb4f7ih5b9i000053hfidc75ih485fg", "host" -> 
    "http://www4b.wolframalpha.com", "server" -> "54", "related" -> 
    "http://www4b.wolframalpha.com/api/v2/relatedQueries.jsp?id=\
MSPa43091ad2ebb4f7ih5b9i000054989i9h1i4ed045&s=54", "version" -> "2.6"}, 
   Typeset`sessioninfo$$ = {
   "TimeZone" -> 1., 
    "Date" -> {2014, 2, 8, 16, 49, 33.0146872`9.271282086026062}, "Line" -> 
    25, "SessionID" -> 23598627481916734218}, Typeset`showpods$$ = {1, 2}, 
   Typeset`failedpods$$ = {}, Typeset`chosen$$ = {
   "Result", "Result", 1, 1, "Content"}, Typeset`open$$ = True, 
   Typeset`newq$$ = "melting line of argon"}, 
   DynamicBox[ToBoxes[
     AlphaIntegration`FormatAlphaResults[
      Dynamic[{
       1, {Typeset`pod1$$, Typeset`pod2$$}, {Typeset`aux1$$, Typeset`aux2$$}, 
        Typeset`chosen$$, Typeset`open$$, Typeset`elements$$, Typeset`q$$, 
        Typeset`opts$$, Typeset`nonpods$$, Typeset`queryinfo$$, 
        Typeset`sessioninfo$$, Typeset`showpods$$, Typeset`failedpods$$, 
        Typeset`newq$$}]], StandardForm],
    ImageSizeCache->{560., {398., 19.}},
    TrackedSymbols:>{Typeset`showpods$$, Typeset`failedpods$$}],
   DynamicModuleValues:>{},
   Initialization:>If[
     Not[Typeset`initdone$$], Null; WolframAlphaClient`Private`doAsyncUpdates[
       Hold[{Typeset`pod1$$, Typeset`pod2$$}], Typeset`asyncpods$$, 
       Dynamic[Typeset`failedpods$$]]; Typeset`asyncpods$$ = {}; 
     Typeset`initdone$$ = True],
   SynchronousInitialization->False],
  BaseStyle->{Deployed -> True},
  DeleteWithContents->True,
  Editable->False,
  SelectWithContents->True]], "WolframAlphaShortInput",
 CellLabel->"In[76]:=",
 CellID->359475843,ExpressionUUID->"455eea46-b24f-4a9a-b912-dec27a7efdf4"],

Cell[BoxData[
 GraphicsBox[
  TagBox[RasterBox[CompressedData["
1:eJztvQ1sHdWd94/yR4iqQlSoK6SKFfqjoqJFrRbRbqtW3Q159tnSVG3Vrerd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    "], {{0, 260.}, {322., 0}}, {0, 255},
    ColorFunction->RGBColor,
    ImageResolution->{144., 144.},
    SmoothingQuality->"High"],
   BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
   Selectable->False],
  DefaultBaseStyle->"ImageGraphics",
  ImageSize->Automatic,
  ImageSizeRaw->{322., 260.},
  PlotRange->{{0, 322.}, {0, 260.}}]], "Output",
 CellTags->"RasterizedOutput",
 CellLabel->"Out[76]=",
 CellID->174563966,ExpressionUUID->"9fc69311-8f57-4f91-9fba-cec0674c2dd1"]
}, Open  ]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"}, 
  Closed]]]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "2"},
        Closed], 
      Alternatives[Open, True]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{
    13.600000000000001`, {0.5800000000000001, 13.020000000000001`}}]],
  ExpressionUUID->"d6ff4fef-3fa3-4fda-bc56-b36ab61342f9"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"9dbb5bac-1233-41dc-a02a-683b10799916"],
 "Applications",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "885c13fa-20d9-455f-b14e-e82eb096d8ec"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellID->258228157,ExpressionUUID->"113976c5-8ba3-483e-a62e-6c8a90005be3"],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<NewEoSArgon`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->64581912,ExpressionUUID->"29559e0e-3a14-4f4f-a726-563fbd07d524"],

Cell[TextData[{
 "Comparison of the model with the experimetal data of Hardy ",
 StyleBox["et al.",
  FontSlant->"Italic"],
 " (J.Chem.Phys. 54, 1971)"
}], "ExampleText",
 CellID->204406933,ExpressionUUID->"90e93284-1f91-4cd4-ba93-373e8a2ed3c9"],

Cell[BoxData[
 RowBox[{
  RowBox[{"DataHardy", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"83.81`", ",", "0.0689`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"97.795`", ",", "58.664`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"97.796`", ",", "58.676`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"105.28`", ",", "92.308`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"105.28`", ",", "92.34`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"105.28`", ",", "92.339`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"111.4`", ",", "120.86`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"111.43`", ",", "121.03`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"117.53`", ",", "150.44`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"117.53`", ",", "150.43`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"117.53`", ",", "150.44`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"126.07`", ",", "193.11`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"126.07`", ",", "193.13`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"126.08`", ",", "193.15`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"136.26`", ",", "246.18`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"136.27`", ",", "246.21`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"144.81`", ",", "292.41`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"144.81`", ",", "292.42`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"144.81`", ",", "292.48`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"151.56`", ",", "329.99`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"151.56`", ",", "329.99`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"157.8`", ",", "365.57`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"157.81`", ",", "365.61`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"168.4`", ",", "427.65`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"168.4`", ",", "427.66`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"168.4`", ",", "427.66`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"168.4`", ",", "427.66`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"174.71`", ",", "465.71`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"174.71`", ",", "465.71`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"174.71`", ",", "465.71`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"183.11`", ",", "517.43`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"183.12`", ",", "517.45`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"193.12`", ",", "580.63`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"193.12`", ",", "580.63`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"193.12`", ",", "580.63`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"193.13`", ",", "580.63`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"193.13`", ",", "580.67`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"205.81`", ",", "663.21`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"205.81`", ",", "663.22`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"205.82`", ",", "663.23`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"205.82`", ",", "663.28`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"215.17`", ",", "725.87`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"215.17`", ",", "725.89`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"218.38`", ",", "747.67`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"218.38`", ",", "747.72`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"226.17`", ",", "801.18`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"226.17`", ",", "801.18`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"226.17`", ",", "801.19`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"226.17`", ",", "801.19`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"226.17`", ",", "801.2`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"229.68`", ",", "825.65`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"229.68`", ",", "825.67`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"229.68`", ",", "825.7`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"231.79`", ",", "840.51`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"231.8`", ",", "840.53`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"240.3`", ",", "900.67`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"240.3`", ",", "900.68`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"240.3`", ",", "900.69`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"240.3`", ",", "900.7`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"245.85`", ",", "940.55`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"245.85`", ",", "940.56`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"245.85`", ",", "940.57`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"246.92`", ",", "948.27`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"246.92`", ",", "948.28`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"246.92`", ",", "948.27`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"246.92`", ",", "948.27`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"246.92`", ",", "948.27`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"246.92`", ",", "948.27`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"252.19`", ",", "986.54`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"252.19`", ",", "986.58`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"252.19`", ",", "986.58`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"252.19`", ",", "986.59`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"260.52`", ",", "1048.`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"260.52`", ",", "1048.`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"260.52`", ",", "1048.`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"260.52`", ",", "1048.`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"260.64`", ",", "1048.9`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"260.64`", ",", "1048.9`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"260.64`", ",", "1048.9`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"260.65`", ",", "1048.9`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"260.65`", ",", "1048.9`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"272.95`", ",", "1141.3`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"272.96`", ",", "1141.4`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"272.97`", ",", "1141.5`"}], "}"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->35931609,ExpressionUUID->"33c63f74-e15e-42ad-b99b-d231a169f761"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Legended", "[", 
  RowBox[{
   RowBox[{"Show", "[", 
    RowBox[{
     RowBox[{"ListPlot", "[", 
      RowBox[{
       RowBox[{"{", "DataHardy", "}"}], ",", 
       RowBox[{"PlotMarkers", "\[Rule]", 
        RowBox[{"{", "\"\<\[EmptyUpTriangle]\>\"", "}"}]}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", "Red"}], ",", 
       RowBox[{"PlotLegends", "\[Rule]", 
        RowBox[{"Placed", "[", 
         RowBox[{
          RowBox[{"PointLegend", "[", 
           RowBox[{
            RowBox[{"{", "\"\<Hardy et al. (1971)\>\"", "}"}], ",", 
            RowBox[{"LegendMarkers", "\[Rule]", "Automatic"}]}], "]"}], ",", 
          "Below"}], "]"}]}]}], "]"}], ",", 
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{"PFusionArgon", "[", "x", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "ttr", ",", 
         RowBox[{"2", "*", "tc"}]}], "}"}]}], "]"}], ",", 
     RowBox[{"AxesOrigin", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"ttr", ",", "0"}], "}"}]}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"ttr", ",", 
          RowBox[{"2", "*", "tc"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "1000"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"Frame", "\[Rule]", "True"}], ",", 
     RowBox[{"FrameLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
       "\"\<Temperature \
\!\(\*StyleBox[\"T\",FontSlant->\"Italic\"]\)\!\(\*StyleBox[\" \",FontSlant->\
\"Italic\"]\)(K)\>\"", ",", " ", 
        "\"\<Melting Pressure \
\!\(\*StyleBox[SubscriptBox[StyleBox[\"P\",FontSlant->\"Italic\"], \
\"m\"],FontSlant->\"Italic\"]\) (MPa)\>\""}], "}"}]}], ",", 
     RowBox[{"LabelStyle", "\[Rule]", 
      RowBox[{"Directive", "[", 
       RowBox[{"12", ",", 
        RowBox[{"FontFamily", "\[Rule]", "\"\<Times\>\""}]}], "]"}]}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "400"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"Placed", "[", 
     RowBox[{
      RowBox[{"LineLegend", "[", 
       RowBox[{
        RowBox[{"{", "Blue", "}"}], ",", 
        RowBox[{
        "{", "\"\<PFusionArgon[\!\(\*StyleBox[\"T\",FontSlant->\"Italic\"]\)]\
\>\"", "}"}]}], "]"}], ",", "Below"}], "]"}], "}"}]}], "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellLabel->"In[3]:=",
 CellID->204930428,ExpressionUUID->"54fd5798-38ec-46d1-bafa-92c10c89ed1c"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[{{{}, 
      InterpretationBox[{
        TagBox[{{
           TagBox[{
             Directive[
              PointSize[0.011000000000000001`], 
              AbsoluteThickness[2], 
              RGBColor[1, 0, 0]], 
             GeometricTransformationBox[
              TagBox[
               InsetBox["\[EmptyUpTriangle]", {0., 0.}], 
               "InsetString"], CompressedData["
1:eJyV001IVFEUB/DJWqRILrJFBEaUYEhtXLSSTuCoSC6UwSK/8umI5vQcRVxM
BBHTSNGXy9xEM27aTCgoaatKW4TTKhURFxLRojYiBhJC//s/zp1H4oxdeFx+
c++cc+55951x+huDh30+XwDPITx5eMbDlQXLmwGpmJu46CYmLt8pTtasD16X
uH96cydQL7d//Hm9AdcV5pWPNNVL49uSBz8bbsj7z6/808evWf8ua3n24UTG
R5qOXZiEx15grDTLcgKJLrXJrwZsWG3WfVfadO5oFWSNFH9xrBkv5exZN+VF
ou0a52yPNXZvlZ3rESTHQrukFjBglnO0Q+PNuzKA4ybg02bjJ1fjn3Tk4xY2
VA9ac93jWqRP1ux6wxH27eXQHvO8M51ax8qwrsPMD7OuwqB0mzEbsWb+A5h1
LQXFHLfl1N2cZp++dYs5drj8ntYJs8600Ue+n9L7OZ3u879mPljP26v9mola
8/ywKaNytlfjeqxzVOv8fkvOm8DJmDX7+Sam+a72ab7WEWvGh7nfH9I5/+G+
Zl+ymP2BGXcqJBVmpDJmfo+5H+Y12Q7pfa16pL/DPF/a+e5uvx5bM6/HrMdj
zjDreOfq/el6Ys3vwGPeF5hx11ztUzxj1hPff/2g5jlj/fqdfX1qze8si3lP
Yf6vNiw+M24+/2/zHHVh7U9nbrNvWcz+FQ3ovDiq7wnmOsz3AjP/0qj8BRxO
X/s=
              "]]}, Annotation[#, "Charting`Private`Tag#1"]& ]}}, {
         "WolframDynamicHighlight", <|
          "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>}], 
        DynamicBox[
         (Charting`HighlightActionBox["DynamicHighlight", {}, 
          Slot["HighlightElements"], 
          Slot["LayoutOptions"], 
          Slot["Meta"], 
          Charting`HighlightActionFunction["DynamicHighlight", {{
             Annotation[{
               Directive[
                PointSize[0.011000000000000001`], 
                AbsoluteThickness[2], 
                RGBColor[1, 0, 0]], 
               GeometricTransformation[
                Inset["\[EmptyUpTriangle]", {0., 0.}], CompressedData["
1:eJyV001IVFEUB/DJWqRILrJFBEaUYEhtXLSSTuCoSC6UwSK/8umI5vQcRVxM
BBHTSNGXy9xEM27aTCgoaatKW4TTKhURFxLRojYiBhJC//s/zp1H4oxdeFx+
c++cc+55951x+huDh30+XwDPITx5eMbDlQXLmwGpmJu46CYmLt8pTtasD16X
uH96cydQL7d//Hm9AdcV5pWPNNVL49uSBz8bbsj7z6/808evWf8ua3n24UTG
R5qOXZiEx15grDTLcgKJLrXJrwZsWG3WfVfadO5oFWSNFH9xrBkv5exZN+VF
ou0a52yPNXZvlZ3rESTHQrukFjBglnO0Q+PNuzKA4ybg02bjJ1fjn3Tk4xY2
VA9ac93jWqRP1ux6wxH27eXQHvO8M51ax8qwrsPMD7OuwqB0mzEbsWb+A5h1
LQXFHLfl1N2cZp++dYs5drj8ntYJs8600Ue+n9L7OZ3u879mPljP26v9mola
8/ywKaNytlfjeqxzVOv8fkvOm8DJmDX7+Sam+a72ab7WEWvGh7nfH9I5/+G+
Zl+ymP2BGXcqJBVmpDJmfo+5H+Y12Q7pfa16pL/DPF/a+e5uvx5bM6/HrMdj
zjDreOfq/el6Ys3vwGPeF5hx11ztUzxj1hPff/2g5jlj/fqdfX1qze8si3lP
Yf6vNiw+M24+/2/zHHVh7U9nbrNvWcz+FQ3ovDiq7wnmOsz3AjP/0qj8BRxO
X/s=
                "]]}, "Charting`Private`Tag#1"]}}, <|
           "HighlightElements" -> <|
             "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
            "LayoutOptions" -> <|
             "PlotRange" -> {{79.86916666666684, 272.97}, {0, 1141.5}}, 
              "Frame" -> {{False, False}, {False, False}}, 
              "AxesOrigin" -> {79.86916666666684, 0}, 
              "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
              "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
              "DefaultStyle" -> {
                Directive[
                 PointSize[0.011000000000000001`], 
                 AbsoluteThickness[2], 
                 RGBColor[1, 0, 0]]}, 
              "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
                  Identity[
                   Part[#, 1]], 
                  Identity[
                   Part[#, 2]]}& ), 
                "ScalingFunctions" -> {{Identity, Identity}, {
                  Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
              False|>, 
            "Meta" -> <|
             "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, 
              "Function" -> ListPlot, "GroupHighlight" -> False|>|>]]& )[<|
          "HighlightElements" -> <|
            "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
           "LayoutOptions" -> <|
            "PlotRange" -> {{79.86916666666684, 272.97}, {0, 1141.5}}, 
             "Frame" -> {{False, False}, {False, False}}, 
             "AxesOrigin" -> {79.86916666666684, 0}, 
             "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
             "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
             "DefaultStyle" -> {
               Directive[
                PointSize[0.011000000000000001`], 
                AbsoluteThickness[2], 
                RGBColor[1, 0, 0]]}, 
             "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
                 Identity[
                  Part[#, 1]], 
                 Identity[
                  Part[#, 2]]}& ), 
               "ScalingFunctions" -> {{Identity, Identity}, {
                 Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
             False|>, 
           "Meta" -> <|
            "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, 
             "Function" -> ListPlot, "GroupHighlight" -> False|>|>]]}, 
       Annotation[{{
          Annotation[{
            Directive[
             PointSize[0.011000000000000001`], 
             AbsoluteThickness[2], 
             RGBColor[1, 0, 0]], 
            GeometricTransformation[
             Inset["\[EmptyUpTriangle]", {0., 0.}], CompressedData["
1:eJyV001IVFEUB/DJWqRILrJFBEaUYEhtXLSSTuCoSC6UwSK/8umI5vQcRVxM
BBHTSNGXy9xEM27aTCgoaatKW4TTKhURFxLRojYiBhJC//s/zp1H4oxdeFx+
c++cc+55951x+huDh30+XwDPITx5eMbDlQXLmwGpmJu46CYmLt8pTtasD16X
uH96cydQL7d//Hm9AdcV5pWPNNVL49uSBz8bbsj7z6/808evWf8ua3n24UTG
R5qOXZiEx15grDTLcgKJLrXJrwZsWG3WfVfadO5oFWSNFH9xrBkv5exZN+VF
ou0a52yPNXZvlZ3rESTHQrukFjBglnO0Q+PNuzKA4ybg02bjJ1fjn3Tk4xY2
VA9ac93jWqRP1ux6wxH27eXQHvO8M51ax8qwrsPMD7OuwqB0mzEbsWb+A5h1
LQXFHLfl1N2cZp++dYs5drj8ntYJs8600Ue+n9L7OZ3u879mPljP26v9mola
8/ywKaNytlfjeqxzVOv8fkvOm8DJmDX7+Sam+a72ab7WEWvGh7nfH9I5/+G+
Zl+ymP2BGXcqJBVmpDJmfo+5H+Y12Q7pfa16pL/DPF/a+e5uvx5bM6/HrMdj
zjDreOfq/el6Ys3vwGPeF5hx11ztUzxj1hPff/2g5jlj/fqdfX1qze8si3lP
Yf6vNiw+M24+/2/zHHVh7U9nbrNvWcz+FQ3ovDiq7wnmOsz3AjP/0qj8BRxO
X/s=
             "]]}, "Charting`Private`Tag#1"]}}, <|
        "HighlightElements" -> <|
          "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
         "LayoutOptions" -> <|
          "PlotRange" -> {{79.86916666666684, 272.97}, {0, 1141.5}}, 
           "Frame" -> {{False, False}, {False, False}}, 
           "AxesOrigin" -> {79.86916666666684, 0}, 
           "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
           "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
           "DefaultStyle" -> {
             Directive[
              PointSize[0.011000000000000001`], 
              AbsoluteThickness[2], 
              RGBColor[1, 0, 0]]}, 
           "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
               Identity[
                Part[#, 1]], 
               Identity[
                Part[#, 2]]}& ), 
             "ScalingFunctions" -> {{Identity, Identity}, {
               Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
           False|>, 
         "Meta" -> <|
          "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
           ListPlot, "GroupHighlight" -> False|>|>, 
        "DynamicHighlight"]], {{}, {}}}, 
     InterpretationBox[{
       TagBox[{{{{}, {}, 
           TagBox[{
             Directive[
              Opacity[1.], 
              RGBColor[0.368417, 0.506779, 0.709798], 
              AbsoluteThickness[2]], 
             LineBox[CompressedData["
1:eJwVjnk4lAkAh0d4FFodrKUS1TZm0lOksqnmJ2nXOchtpsZ9zDjmSwdGm8oU
UwYzX4lN6jG2lpJIh8g6MyKJJEOJLSKkQy1l7R/v8/75vkb+Ua5BcygUiuMs
/9t/b6NDxgc3VLm4W8/LK2YUD5endU66wdVJterNpw4G5dC19qXTblikHs/z
qu5n5KRJWH+quMPb+fzuqSsTjO6/2bx7Ou5wMRjdddFwDtxWTYheb3bHg9LC
u1l9C7FrSL9pi8AdiZzwMJ9mI9D28Wz7VTyQZSbvzuwyRcPVsiLTtZ6QfR75
+K5tB3Tpg549Vl54xFNu9nVyQJz5mbwlLt7oXDLJpw+5ojRo2MfzoA8O3RYE
mZh6IfcZdfd4si+K2n7Lt7Vkw5/QuCksYYEWu5DeFeIHiyxueVEnGykpj6gL
zANRpVyivGlwD56KMw+49QRDS976XKHGgYhjnWDeEgbdknK35nQO6gpzjZZl
8UDrHzBU0/MDS8TOnQ6IQn5+38X7BX4oe9xr89aSj2n1tpp8c38IGr6svVBM
oGLOmSzNRn88uOFb7+QYg5NWmTXlPgFwSqif0hzcDxOj1NPnXgVAZkHGDPEO
wlLqqfl5fyAMd/9g8/anWKy8rG2SOBMImih+//prcTjIlFFE0iDs083wEHMF
aN8WQ+1dHQxFd+F6DephqDdvGttbFIxjDcId1vLfUTj2kMuxDkFsXWiPd9MR
UEs8ksXNIaANWszVlCWioMLgq5p7KMwyYn9USTiKbN+7y2behKJivj5lRfgx
BGbZ9q/ih6EpYUZ5rt1xZPIK2Y2q4XBJat8gZCThaZIj/dbZcBxmJ9vt2SDE
O8ars0+Wc2FuZVfF1DuBqNN2dyNLuFhhwaL76ZyEPD4/wWIbD2O92nfMlJOx
rhgS+1oeWuVj4oLRZMzEXmP3eETA8OY/IfXjKbjcr9V4/kUErLnG85UGRLj3
cueQYl8ktk8scbUdPYUrhyP+svseicH0jw2sodPIDWivUBJGYWKr8c76vlQo
RarVZGtGg86xrSt/L8aFuJxJR5doGIuLW94fSsOE8wXh/exoXPVnfp1RSYfc
7n5lx0A0fDs/DdeK06Gl4/2rMo0P5nEF1XNRBuZdYdHHCT6stGKtVlzMQPT8
5+yPt/jIqYzpkFAlYJEHtpyf4kOs90YYWSjBt9cCvqoNAVqXk2nlNik05n37
cjyZgKfz89KIeikE1Lz2shQCWTUfwtseSDFiY399UERALe3txs1NUrQcPRfi
kEqAWxChrtQqRcb0xqeLJQTS1t++SnZJoT8eWXLpDwLUxlZF9YgU9M6XEVVF
BDSmZc9MFpPI/nTCduI6AQNvU5pUh4Sm9rqfV90gwB9ISp3SJTHqnKA4UUog
SuXkWflSEjfkevbMO7N//b2XwlaT2FLpatxbPdvTt88p+IVEgeKr8oJaAu+d
DSy1t5JYOpX7wqqOQEvZ9RHBdhLfN4+dkTUQ8JIsSHWyJlFdLFKNeEhAsLKg
ccKBxIZWs76cZgLLw4I1WUwSeaNd91pbCMQNdAfUuZAQrjGOMX8826N8cM70
IDFp+4gZ3EbgVIDktZI3idDQA2synxCoOTKcxvUl0SVcpiZvJxB/519mB5uE
naz21VQHgblRVSsZHBL/AexoRn0=
              "]]}, Annotation[#, "Charting`Private`Tag#1"]& ]}}, {}}, {
        "WolframDynamicHighlight", <|
         "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>}], 
       DynamicBox[
        (Charting`HighlightActionBox["DynamicHighlight", {}, 
         Slot["HighlightElements"], 
         Slot["LayoutOptions"], 
         Slot["Meta"], 
         Charting`HighlightActionFunction["DynamicHighlight", {{{{}, {}, 
             Annotation[{
               Directive[
                Opacity[1.], 
                RGBColor[0.368417, 0.506779, 0.709798], 
                AbsoluteThickness[2]], 
               Line[CompressedData["
1:eJwVjnk4lAkAh0d4FFodrKUS1TZm0lOksqnmJ2nXOchtpsZ9zDjmSwdGm8oU
UwYzX4lN6jG2lpJIh8g6MyKJJEOJLSKkQy1l7R/v8/75vkb+Ua5BcygUiuMs
/9t/b6NDxgc3VLm4W8/LK2YUD5endU66wdVJterNpw4G5dC19qXTblikHs/z
qu5n5KRJWH+quMPb+fzuqSsTjO6/2bx7Ou5wMRjdddFwDtxWTYheb3bHg9LC
u1l9C7FrSL9pi8AdiZzwMJ9mI9D28Wz7VTyQZSbvzuwyRcPVsiLTtZ6QfR75
+K5tB3Tpg549Vl54xFNu9nVyQJz5mbwlLt7oXDLJpw+5ojRo2MfzoA8O3RYE
mZh6IfcZdfd4si+K2n7Lt7Vkw5/QuCksYYEWu5DeFeIHiyxueVEnGykpj6gL
zANRpVyivGlwD56KMw+49QRDS976XKHGgYhjnWDeEgbdknK35nQO6gpzjZZl
8UDrHzBU0/MDS8TOnQ6IQn5+38X7BX4oe9xr89aSj2n1tpp8c38IGr6svVBM
oGLOmSzNRn88uOFb7+QYg5NWmTXlPgFwSqif0hzcDxOj1NPnXgVAZkHGDPEO
wlLqqfl5fyAMd/9g8/anWKy8rG2SOBMImih+//prcTjIlFFE0iDs083wEHMF
aN8WQ+1dHQxFd+F6DephqDdvGttbFIxjDcId1vLfUTj2kMuxDkFsXWiPd9MR
UEs8ksXNIaANWszVlCWioMLgq5p7KMwyYn9USTiKbN+7y2behKJivj5lRfgx
BGbZ9q/ih6EpYUZ5rt1xZPIK2Y2q4XBJat8gZCThaZIj/dbZcBxmJ9vt2SDE
O8ars0+Wc2FuZVfF1DuBqNN2dyNLuFhhwaL76ZyEPD4/wWIbD2O92nfMlJOx
rhgS+1oeWuVj4oLRZMzEXmP3eETA8OY/IfXjKbjcr9V4/kUErLnG85UGRLj3
cueQYl8ktk8scbUdPYUrhyP+svseicH0jw2sodPIDWivUBJGYWKr8c76vlQo
RarVZGtGg86xrSt/L8aFuJxJR5doGIuLW94fSsOE8wXh/exoXPVnfp1RSYfc
7n5lx0A0fDs/DdeK06Gl4/2rMo0P5nEF1XNRBuZdYdHHCT6stGKtVlzMQPT8
5+yPt/jIqYzpkFAlYJEHtpyf4kOs90YYWSjBt9cCvqoNAVqXk2nlNik05n37
cjyZgKfz89KIeikE1Lz2shQCWTUfwtseSDFiY399UERALe3txs1NUrQcPRfi
kEqAWxChrtQqRcb0xqeLJQTS1t++SnZJoT8eWXLpDwLUxlZF9YgU9M6XEVVF
BDSmZc9MFpPI/nTCduI6AQNvU5pUh4Sm9rqfV90gwB9ISp3SJTHqnKA4UUog
SuXkWflSEjfkevbMO7N//b2XwlaT2FLpatxbPdvTt88p+IVEgeKr8oJaAu+d
DSy1t5JYOpX7wqqOQEvZ9RHBdhLfN4+dkTUQ8JIsSHWyJlFdLFKNeEhAsLKg
ccKBxIZWs76cZgLLw4I1WUwSeaNd91pbCMQNdAfUuZAQrjGOMX8826N8cM70
IDFp+4gZ3EbgVIDktZI3idDQA2synxCoOTKcxvUl0SVcpiZvJxB/519mB5uE
naz21VQHgblRVSsZHBL/AexoRn0=
                "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
          "HighlightElements" -> <|
            "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
           "LayoutOptions" -> <|
            "PlotRange" -> {{83.8058, 301.374}, {0., 1368.0616598193901`}}, 
             "Frame" -> {{False, False}, {False, False}}, 
             "AxesOrigin" -> {83.80580000000019, 0}, 
             "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
             "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
             "DefaultStyle" -> {
               Directive[
                Opacity[1.], 
                RGBColor[0.368417, 0.506779, 0.709798], 
                AbsoluteThickness[2]]}, 
             "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
                 Identity[
                  Part[#, 1]], 
                 Identity[
                  Part[#, 2]]}& ), 
               "ScalingFunctions" -> {{Identity, Identity}, {
                 Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
             False|>, 
           "Meta" -> <|
            "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, 
             "Function" -> Plot, "GroupHighlight" -> False|>|>]]& )[<|
         "HighlightElements" -> <|
           "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
          "LayoutOptions" -> <|
           "PlotRange" -> {{83.8058, 301.374}, {0., 1368.0616598193901`}}, 
            "Frame" -> {{False, False}, {False, False}}, 
            "AxesOrigin" -> {83.80580000000019, 0}, 
            "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
            "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
            "DefaultStyle" -> {
              Directive[
               Opacity[1.], 
               RGBColor[0.368417, 0.506779, 0.709798], 
               AbsoluteThickness[2]]}, 
            "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
                Identity[
                 Part[#, 1]], 
                Identity[
                 Part[#, 2]]}& ), 
              "ScalingFunctions" -> {{Identity, Identity}, {
                Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
            False|>, 
          "Meta" -> <|
           "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
            Plot, "GroupHighlight" -> False|>|>]]}, 
      Annotation[{{{{}, {}, 
          Annotation[{
            Directive[
             Opacity[1.], 
             RGBColor[0.368417, 0.506779, 0.709798], 
             AbsoluteThickness[2]], 
            Line[CompressedData["
1:eJwVjnk4lAkAh0d4FFodrKUS1TZm0lOksqnmJ2nXOchtpsZ9zDjmSwdGm8oU
UwYzX4lN6jG2lpJIh8g6MyKJJEOJLSKkQy1l7R/v8/75vkb+Ua5BcygUiuMs
/9t/b6NDxgc3VLm4W8/LK2YUD5endU66wdVJterNpw4G5dC19qXTblikHs/z
qu5n5KRJWH+quMPb+fzuqSsTjO6/2bx7Ou5wMRjdddFwDtxWTYheb3bHg9LC
u1l9C7FrSL9pi8AdiZzwMJ9mI9D28Wz7VTyQZSbvzuwyRcPVsiLTtZ6QfR75
+K5tB3Tpg549Vl54xFNu9nVyQJz5mbwlLt7oXDLJpw+5ojRo2MfzoA8O3RYE
mZh6IfcZdfd4si+K2n7Lt7Vkw5/QuCksYYEWu5DeFeIHiyxueVEnGykpj6gL
zANRpVyivGlwD56KMw+49QRDS976XKHGgYhjnWDeEgbdknK35nQO6gpzjZZl
8UDrHzBU0/MDS8TOnQ6IQn5+38X7BX4oe9xr89aSj2n1tpp8c38IGr6svVBM
oGLOmSzNRn88uOFb7+QYg5NWmTXlPgFwSqif0hzcDxOj1NPnXgVAZkHGDPEO
wlLqqfl5fyAMd/9g8/anWKy8rG2SOBMImih+//prcTjIlFFE0iDs083wEHMF
aN8WQ+1dHQxFd+F6DephqDdvGttbFIxjDcId1vLfUTj2kMuxDkFsXWiPd9MR
UEs8ksXNIaANWszVlCWioMLgq5p7KMwyYn9USTiKbN+7y2behKJivj5lRfgx
BGbZ9q/ih6EpYUZ5rt1xZPIK2Y2q4XBJat8gZCThaZIj/dbZcBxmJ9vt2SDE
O8ars0+Wc2FuZVfF1DuBqNN2dyNLuFhhwaL76ZyEPD4/wWIbD2O92nfMlJOx
rhgS+1oeWuVj4oLRZMzEXmP3eETA8OY/IfXjKbjcr9V4/kUErLnG85UGRLj3
cueQYl8ktk8scbUdPYUrhyP+svseicH0jw2sodPIDWivUBJGYWKr8c76vlQo
RarVZGtGg86xrSt/L8aFuJxJR5doGIuLW94fSsOE8wXh/exoXPVnfp1RSYfc
7n5lx0A0fDs/DdeK06Gl4/2rMo0P5nEF1XNRBuZdYdHHCT6stGKtVlzMQPT8
5+yPt/jIqYzpkFAlYJEHtpyf4kOs90YYWSjBt9cCvqoNAVqXk2nlNik05n37
cjyZgKfz89KIeikE1Lz2shQCWTUfwtseSDFiY399UERALe3txs1NUrQcPRfi
kEqAWxChrtQqRcb0xqeLJQTS1t++SnZJoT8eWXLpDwLUxlZF9YgU9M6XEVVF
BDSmZc9MFpPI/nTCduI6AQNvU5pUh4Sm9rqfV90gwB9ISp3SJTHqnKA4UUog
SuXkWflSEjfkevbMO7N//b2XwlaT2FLpatxbPdvTt88p+IVEgeKr8oJaAu+d
DSy1t5JYOpX7wqqOQEvZ9RHBdhLfN4+dkTUQ8JIsSHWyJlFdLFKNeEhAsLKg
ccKBxIZWs76cZgLLw4I1WUwSeaNd91pbCMQNdAfUuZAQrjGOMX8826N8cM70
IDFp+4gZ3EbgVIDktZI3idDQA2synxCoOTKcxvUl0SVcpiZvJxB/519mB5uE
naz21VQHgblRVSsZHBL/AexoRn0=
             "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
       "HighlightElements" -> <|
         "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
        "LayoutOptions" -> <|
         "PlotRange" -> {{83.8058, 301.374}, {0., 1368.0616598193901`}}, 
          "Frame" -> {{False, False}, {False, False}}, 
          "AxesOrigin" -> {83.80580000000019, 0}, 
          "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
          "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
          "DefaultStyle" -> {
            Directive[
             Opacity[1.], 
             RGBColor[0.368417, 0.506779, 0.709798], 
             AbsoluteThickness[2]]}, 
          "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
              Identity[
               Part[#, 1]], 
              Identity[
               Part[#, 2]]}& ), 
            "ScalingFunctions" -> {{Identity, Identity}, {
              Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>,
         "Meta" -> <|
         "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
          Plot, "GroupHighlight" -> False|>|>, "DynamicHighlight"]]}, {
    AxesOrigin -> {83.8058, 0}, PlotRange -> {{83.8058, 301.374}, {0, 1000}}, 
     Frame -> True, FrameLabel -> {
       FormBox[
       "\"Temperature \
\\!\\(\\*StyleBox[\\\"T\\\",FontSlant->\\\"Italic\\\"]\\)\\!\\(\\*StyleBox[\\\
\" \\\",FontSlant->\\\"Italic\\\"]\\)(K)\"", TraditionalForm], 
       FormBox[
       "\"Melting Pressure \
\\!\\(\\*StyleBox[SubscriptBox[StyleBox[\\\"P\\\",FontSlant->\\\"Italic\\\"], \
\\\"m\\\"],FontSlant->\\\"Italic\\\"]\\) (MPa)\"", TraditionalForm]}, 
     LabelStyle -> Directive[12, FontFamily -> "Times"], ImageSize -> 400, 
     DisplayFunction -> Identity, DisplayFunction -> Identity, 
     DisplayFunction -> Identity, AspectRatio -> 
     NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
     AxesLabel -> {None, None}, AxesOrigin -> {79.86916666666684, 0}, 
     DisplayFunction :> Identity, Frame -> {{False, False}, {False, False}}, 
     FrameLabel -> {{None, None}, {None, None}}, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     GridLines -> {None, None}, GridLinesStyle -> Directive[
       GrayLevel[0.5, 0.4]], 
     Method -> {
      "AxisPadding" -> Scaled[0.02], "DefaultBoundaryStyle" -> Automatic, 
       "DefaultGraphicsInteraction" -> {
        "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
         "Effects" -> {
          "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
           "Droplines" -> {
            "freeformCursorMode" -> True, 
             "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
       "DefaultMeshStyle" -> AbsolutePointSize[6], "DefaultPlotStyle" -> {
         Directive[
          RGBColor[0.368417, 0.506779, 0.709798], 
          AbsoluteThickness[2]], 
         Directive[
          RGBColor[0.880722, 0.611041, 0.142051], 
          AbsoluteThickness[2]], 
         Directive[
          RGBColor[0.560181, 0.691569, 0.194885], 
          AbsoluteThickness[2]], 
         Directive[
          RGBColor[0.922526, 0.385626, 0.209179], 
          AbsoluteThickness[2]], 
         Directive[
          RGBColor[0.528488, 0.470624, 0.701351], 
          AbsoluteThickness[2]], 
         Directive[
          RGBColor[0.772079, 0.431554, 0.102387], 
          AbsoluteThickness[2]], 
         Directive[
          RGBColor[0.363898, 0.618501, 0.782349], 
          AbsoluteThickness[2]], 
         Directive[
          RGBColor[1, 0.75, 0], 
          AbsoluteThickness[2]], 
         Directive[
          RGBColor[0.647624, 0.37816, 0.614037], 
          AbsoluteThickness[2]], 
         Directive[
          RGBColor[0.571589, 0.586483, 0.], 
          AbsoluteThickness[2]], 
         Directive[
          RGBColor[0.915, 0.3325, 0.2125], 
          AbsoluteThickness[2]], 
         Directive[
          RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
          AbsoluteThickness[2]], 
         Directive[
          RGBColor[
          0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
          AbsoluteThickness[2]], 
         Directive[
          RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
          AbsoluteThickness[2]], 
         Directive[
          RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
          AbsoluteThickness[2]]}, "DomainPadding" -> Scaled[0.02], 
       "PointSizeFunction" -> "SmallPointSize", "RangePadding" -> 
       Scaled[0.05], "OptimizePlotMarkers" -> True, "IncludeHighlighting" -> 
       "CurrentPoint", "HighlightStyle" -> Automatic, "OptimizePlotMarkers" -> 
       True, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
           Identity[
            Part[#, 1]], 
           Identity[
            Part[#, 2]]}& ), "CopiedValueFunction" -> ({
           Identity[
            Part[#, 1]], 
           Identity[
            Part[#, 2]]}& )}}, 
     PlotRange -> {{79.86916666666684, 272.97}, {0, 1141.5}}, 
     PlotRangeClipping -> True, PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.02], 
        Scaled[0.05]}}, Ticks -> {Automatic, Automatic}}], 
   FormBox[
    TemplateBox[{"\[ThinSpace]", "\" \"", 
      FormBox[
       TemplateBox[{"\"Hardy et al. (1971)\""}, "PointLegend", 
        DisplayFunction -> (StyleBox[
          StyleBox[
           PaneBox[
            TagBox[
             GridBox[{{
                TagBox[
                 GridBox[{{
                    GraphicsBox[{{}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[2], 
                    RGBColor[1, 0, 0]], {
                    InsetBox[
                    FormBox[
                    StyleBox["\"\[EmptyUpTriangle]\"", 
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[2], 
                    RGBColor[1, 0, 0]], FontSize -> 12.5, Plain, StripOnInput -> 
                    False], TraditionalForm], 
                    NCache[
                    Scaled[{
                    Rational[1, 2], 
                    Rational[1, 2]}], 
                    Scaled[{0.5, 0.5}]]]}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 12.5}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.18000000000000002`] -> 
                    Baseline)], #}}, 
                  GridBoxAlignment -> {
                   "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                  AutoDelete -> False, 
                  GridBoxDividers -> {
                   "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                  GridBoxItemSize -> {
                   "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                  GridBoxSpacings -> {"Columns" -> {{0.8, 0.5}}}], "Grid"]}}, 
              GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
              AutoDelete -> False, 
              GridBoxDividers -> {"Columns" -> {{None}}, "Rows" -> {{None}}}, 
              GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}}, 
              GridBoxSpacings -> {"Columns" -> {{0}}, "Rows" -> {{1}}}], 
             "Grid"], Alignment -> Left, AppearanceElements -> None, 
            ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
            "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
          FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
          False]& ), InterpretationFunction :> (RowBox[{"PointLegend", "[", 
           RowBox[{
             RowBox[{"{", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.011000000000000001`", "]"}], 
                   ",", 
                   RowBox[{"AbsoluteThickness", "[", "2", "]"}], ",", 
                   
                   TemplateBox[<|"color" -> RGBColor[1, 0, 0]|>, 
                    "RGBColorSwatchTemplate"]}], "]"}], "}"}], ",", 
             RowBox[{"{", #, "}"}], ",", 
             RowBox[{"LegendMarkers", "\[Rule]", 
               RowBox[{"{", 
                 RowBox[{"{", 
                   RowBox[{"\"\[EmptyUpTriangle]\"", ",", "Automatic"}], 
                   "}"}], "}"}]}], ",", 
             RowBox[{"Joined", "\[Rule]", 
               RowBox[{"{", "False", "}"}]}], ",", 
             RowBox[{"LabelStyle", "\[Rule]", 
               RowBox[{"{", "}"}]}], ",", 
             RowBox[{"LegendLayout", "\[Rule]", "\"Row\""}]}], "]"}]& ), 
        Editable -> True], TraditionalForm], 
      FormBox[
       TemplateBox[{
        "\"PFusionArgon[\\!\\(\\*StyleBox[\\\"T\\\",FontSlant->\\\"Italic\\\"]\
\\)]\""}, "LineLegend", DisplayFunction -> (StyleBox[
          StyleBox[
           PaneBox[
            TagBox[
             GridBox[{{
                TagBox[
                 GridBox[{{
                    GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0, 0, 1]], {
                    LineBox[{{0, 12.5}, {20, 12.5}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0, 0, 1]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 12.5}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.18000000000000002`] -> 
                    Baseline)], #}}, 
                  GridBoxAlignment -> {
                   "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                  AutoDelete -> False, 
                  GridBoxDividers -> {
                   "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                  GridBoxItemSize -> {
                   "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                  GridBoxSpacings -> {
                   "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
              GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
              AutoDelete -> False, 
              GridBoxItemSize -> {
               "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
              GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
             "Grid"], Alignment -> Left, AppearanceElements -> None, 
            ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
            "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
          FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
          False]& ), InterpretationFunction :> (RowBox[{"LineLegend", "[", 
           RowBox[{
             RowBox[{"{", 
               
               TemplateBox[<|"color" -> RGBColor[0, 0, 1]|>, 
                "RGBColorSwatchTemplate"], "}"}], ",", 
             RowBox[{"{", #, "}"}]}], "]"}]& ), Editable -> True], 
       TraditionalForm]}, "RowWithSeparators"], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"]}, {
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "Below"}], "]"}]}], "]"}]& )]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellLabel->"Out[3]=",
 CellID->502454435,ExpressionUUID->"627ca789-51b3-4a72-a894-34bc13f35cc2"]
}, Open  ]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "2"}, 
  Closed]]]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "PrimaryExamplesSection"}, 
  Closed]]]],

Cell[BoxData[GridBox[{
   {
    DynamicBox[FEPrivate`ImportImage[
      FrontEnd`FileName[{"Documentation", "FooterIcons"}, 
       "RelatedFunction.png"]],
     ImageSizeCache->{50., {27., 33.}}], GridBox[{
      {
       StyleBox[
        RowBox[{"See", " ", "Also"}], "SeeAlsoSection"]},
      {Cell[TextData[Cell[BoxData[
        TemplateBox[{
          Cell[
           TextData["ptr"]], "paclet:NewEoSArgon/ref/ptr", 
          "NewEoSArgon Package Symbol"},
         "PackageLink",
         BaseStyle->"InlineFormula"]], "InlineFormula",
        FontFamily->"Source Sans Pro",ExpressionUUID->
        "79011ec0-98aa-47cc-b2f9-d87f6955a1ee"]], "SeeAlso",ExpressionUUID->
        "0282ee08-f408-49dd-b94b-1d2e0794f28e"]}
     }]}
  }]], "SeeAlsoSection",ExpressionUUID->"596b97bd-3b78-417e-b7e8-\
3314b9f5eac8"],

Cell[BoxData[GridBox[{
   {
    DynamicBox[FEPrivate`ImportImage[
      FrontEnd`FileName[{"Documentation", "FooterIcons"}, "RelatedGuide.png"]],
     ImageSizeCache->{50., {27., 33.}}], GridBox[{
      {
       StyleBox[
        RowBox[{"Related", " ", "Guides"}], "MoreAboutSection"]},
      {
       RowBox[{"\[FilledVerySmallSquare]", Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["NewEoSArgon Package"]], 
           "paclet:NewEoSArgon/guide/NewEoSArgon"},
          "RefLinkPlain",
          BaseStyle->{"MoreAbout"}]], "MoreAbout",ExpressionUUID->
         "780a52af-850f-4f5b-9e9e-032b12c4e395"]}]}
     }]}
  }]], "MoreAboutSection",ExpressionUUID->"fe889782-52d3-44e9-95c8-\
6e4a8aedad06"],

Cell[BoxData[GridBox[{
   {
    TemplateBox[{29},
     "Spacer1"], GridBox[{
      {
       RowBox[{
        TemplateBox[{17},
         "Spacer1"], 
        StyleBox[
         RowBox[{"Related", " ", "Links"}], "RelatedLinksSection"]}]},
      {Cell[BoxData[Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData[
             RowBox[{
               RowBox[{"Units", " ", "&"}], " ", "Quantities"}]]], 
           "paclet:guide/Units"},
          "RefLinkPlain",
          BaseStyle->{"RelatedLinks"}]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "a693d277-d7dd-4f88-ad33-98392ee0c0d0"]], "RelatedLinks",
        ExpressionUUID->"ec75ccc0-1dab-4ada-b9d5-97b4510ab6dc"]},
      {Cell[BoxData[Cell[BoxData[Cell[BoxData[
          RowBox[{
           TemplateBox[{16},
            "Spacer1"], "\[FilledVerySmallSquare]", 
           TemplateBox[{
             Cell[
              TextData[
               Cell[
                TextData[{
                  Cell[
                   BoxData[
                    TemplateBox[{2}, "Spacer1"]]], "ThermodynamicData"}]]]], 
             "paclet:ref/ThermodynamicData"},
            "RefLink",
            BaseStyle->{"RelatedLinks"}]}]],ExpressionUUID->
          "b79a3e55-8a9a-461d-b1b5-98ffd3d226aa"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "a7cdf017-734f-408d-b5e1-b66acc64da43"]], "RelatedLinks",
        ExpressionUUID->"9d54e42e-53ac-44a7-9ac8-c119576c3112"]}
     }]}
  }]], "RelatedLinksSection",ExpressionUUID->"d7d1cad4-4b17-47e6-8050-\
3c90d723bc93"],

Cell[" ", "FooterCell",ExpressionUUID->"5067168d-4362-45ea-a5d9-9a4fd52343c7"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{900, 835.8},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"PFusionArgon",
TaggingRules->{
 "ModificationHighlight" -> False, "ColorType" -> "", "LinkTrails" -> "", 
  "HasOptions" -> True, "ExampleCounter" -> 1, 
  "Openers" -> {
   "PrimaryExamplesSection" -> Open, 
    "ExampleSection" -> {"0" -> Open, "2" -> Closed}, "NotesSection" -> 
    Closed}, "NewStyles" -> True, "CitationPopupData" -> $Failed, 
  "ShowCitation" -> False, "RootCaptions" -> "", 
  "Metadata" -> {
   "built" -> "{2023, 11, 30, 13, 55, 46.7718741}", 
    "history" -> {"XX", "", "", ""}, "context" -> "NewEoSArgon`", 
    "keywords" -> {}, "specialkeywords" -> {}, 
    "tutorialcollectionlinks" -> {}, "index" -> True, "label" -> 
    "New Eo S Argon Package Symbol", "language" -> "en", "paclet" -> 
    "NewEoSArgon Package", "status" -> "None", "summary" -> 
    "PFusionArgon[T] \\[Congruent] Pm (MPa) Pression sur la ligne de fusion \
de l'argon en fonction de la temp\[EAcute]rature T (Kelvin) [Function that \
gives the pressure versus T (Kelvin) on the melting line of argon]", 
    "synonyms" -> {}, "tabletags" -> {}, "title" -> "PFusionArgon", 
    "titlemodifier" -> "", "metadescription" -> "", "windowtitle" -> 
    "PFusionArgon", "type" -> "Symbol", "uri" -> 
    "NewEoSArgon/ref/PFusionArgon"}},
CellContext->"Global`",
FrontEndVersion->"13.3 pour Microsoft Windows (64-bit) (July 24, 2023)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "13.3 pour Microsoft Windows (64-bit) (July 24, 2023)", 
  StyleDefinitions -> "Default.nb"],
ExpressionUUID->"cec8ffe8-807f-42b7-ad82-a51422e0f777"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[10714, 294, 1420, 37, 35, "PrimaryExamplesSection",ExpressionUUID->"103c2d37-f730-4e92-89ab-140e674227db",
   CellTags->"PrimaryExamplesSection",
   CellID->218898675]},
 "RasterizedOutput"->{
  Cell[105632, 2091, 29087, 483, 281, "Output",ExpressionUUID->"9fc69311-8f57-4f91-9fba-cec0674c2dd1",
   CellTags->"RasterizedOutput",
   CellID->174563966]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 179493, 3613},
 {"RasterizedOutput", 179693, 3617}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[584, 21, 5201, 127, 56, "AnchorBarGrid",ExpressionUUID->"7907dec6-c010-43e8-b04c-5a447ffdd31b",
 CellID->1],
Cell[5788, 150, 94, 0, 23, "ContextNameCell",ExpressionUUID->"67a30d41-a52e-4f5e-adbe-546f428b1198"],
Cell[CellGroupData[{
Cell[5907, 154, 555, 14, 56, "ObjectNameGrid",ExpressionUUID->"bfdb796d-5de1-4c38-9ab0-5dc6cbcdadcc"],
Cell[6465, 170, 985, 25, 146, "Usage",ExpressionUUID->"9c419669-1a6e-43cc-b1a9-079d20051d41"]
}, Open  ]],
Cell[CellGroupData[{
Cell[7487, 200, 1919, 48, 37, "NotesSection",ExpressionUUID->"48ab0f55-7373-4e87-bf95-7f8fad9af03f",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->141379143],
Cell[9409, 250, 501, 15, 38, "Notes",ExpressionUUID->"acf42a4c-e727-40b2-b324-ed70cc4fe8cc",
 CellID->1067943069],
Cell[9913, 267, 186, 4, 36, "Notes",ExpressionUUID->"e177fc8d-746a-4f9c-9d9b-aed8434aee7d",
 CellID->224665577],
Cell[10102, 273, 485, 15, 38, "Notes",ExpressionUUID->"febcbd95-77f0-42e8-bbb7-636610daf25c",
 CellID->82812754]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "NotesSection"}, Closed]]]],
Cell[CellGroupData[{
Cell[10714, 294, 1420, 37, 35, "PrimaryExamplesSection",ExpressionUUID->"103c2d37-f730-4e92-89ab-140e674227db",
 CellTags->"PrimaryExamplesSection",
 CellID->218898675],
Cell[CellGroupData[{
Cell[12159, 335, 1397, 36, 30, "ExampleSection",ExpressionUUID->"901ce1c1-81c8-4a3f-9860-77905828e8ab",
 CellID->92259602],
Cell[13559, 373, 174, 3, 26, "Input",ExpressionUUID->"71ed17c8-c051-4f5a-b9a7-c743abc3b327",
 CellID->87419684],
Cell[13736, 378, 131, 1, 38, "ExampleText",ExpressionUUID->"d4be4049-68d5-407e-9b6e-d003d7543386",
 CellID->285078790],
Cell[CellGroupData[{
Cell[13892, 383, 237, 6, 26, "Input",ExpressionUUID->"a4561027-48f2-47eb-afef-66d8d03130c6",
 CellID->231987987],
Cell[14132, 391, 224, 5, 39, "Output",ExpressionUUID->"dd04c451-f47d-4995-a809-b480b3514e6d",
 CellID->117750017]
}, Open  ]],
Cell[CellGroupData[{
Cell[14393, 401, 632, 16, 26, "Input",ExpressionUUID->"0ae623fa-cf30-4a32-8c55-06f9a319aeff",
 CellID->114614193],
Cell[15028, 419, 206, 4, 40, "Output",ExpressionUUID->"03d719ad-8957-4015-8588-2d8aaceb54b2",
 CellID->341710501]
}, Open  ]],
Cell[15249, 426, 132, 1, 38, "ExampleText",ExpressionUUID->"985a6e99-3722-49a5-9106-483c946d25db",
 CellID->237505931],
Cell[CellGroupData[{
Cell[15406, 431, 665, 18, 57, "Input",ExpressionUUID->"131d8e84-3547-4c48-b3e6-7532181b9122",
 CellID->123936303],
Cell[16074, 451, 238, 5, 43, "Output",ExpressionUUID->"1b958da5-3485-406b-9000-df515cfb9629",
 CellID->52778897]
}, Open  ]],
Cell[16327, 459, 199, 4, 38, "ExampleText",ExpressionUUID->"ba912003-eb68-4878-bd7b-3b1976d47f8d",
 CellID->266534198],
Cell[CellGroupData[{
Cell[16551, 467, 486, 11, 42, "Input",ExpressionUUID->"c22d6173-6dec-41b8-97ff-12e3510f10ec",
 CellID->138180430],
Cell[17040, 480, 254, 6, 35, "Output",ExpressionUUID->"e0e3ce94-a934-4dc4-bf7c-9619212ffeb8",
 CellID->113920554]
}, Open  ]],
Cell[17309, 489, 167, 3, 38, "ExampleText",ExpressionUUID->"af6a5ddd-c80c-4786-8707-5aa224ec442d",
 CellID->886239600],
Cell[CellGroupData[{
Cell[17501, 496, 811, 21, 42, "Input",ExpressionUUID->"98efb9a0-0e2d-4bc4-bce1-c9175b4f3694",
 CellID->21488140],
Cell[18315, 519, 11534, 241, 70, "Output",ExpressionUUID->"844b7e28-2c73-40e3-8b62-bd7432c36740",
 CellID->90441827]
}, Open  ]],
Cell[29864, 763, 123, 1, 70, "ExampleText",ExpressionUUID->"b8216d2f-0e93-40ef-9ae9-9585e2ec458a",
 CellID->171785798],
Cell[CellGroupData[{
Cell[30012, 768, 784, 23, 70, "Input",ExpressionUUID->"c444a71a-4157-4d51-9241-d2010352045b",
 CellID->228305278],
Cell[30799, 793, 209, 4, 39, "Output",ExpressionUUID->"a4325de1-cc40-40d5-b1c1-7dcc4cf0c4df",
 CellID->312438537]
}, Open  ]],
Cell[CellGroupData[{
Cell[31045, 802, 631, 16, 70, "Input",ExpressionUUID->"66b6c023-5e80-4c35-858a-b115131da3e9",
 CellID->102930547],
Cell[31679, 820, 257, 6, 40, "Output",ExpressionUUID->"0648feff-340b-4cb7-9c82-ed1867bb04d4",
 CellID->114302638]
}, Open  ]],
Cell[CellGroupData[{
Cell[31973, 831, 223, 5, 70, "Input",ExpressionUUID->"0d695bff-2a03-4cd1-b3f2-8682a66c2903",
 CellID->117973734],
Cell[32199, 838, 208, 4, 39, "Output",ExpressionUUID->"a7c84fcf-db62-4f7a-aa5c-300852584ebb",
 CellID->464227]
}, Open  ]],
Cell[32422, 845, 154, 1, 70, "ExampleText",ExpressionUUID->"59c03761-feaf-4564-889b-6ce514eea766",
 CellID->361149294],
Cell[CellGroupData[{
Cell[32601, 850, 444, 10, 70, "Input",ExpressionUUID->"75d0b063-92bf-41b9-ae00-5a6612c59db6",
 CellID->375583457],
Cell[33048, 862, 210, 4, 39, "Output",ExpressionUUID->"d0dd4f49-3399-4557-b41c-6ee34234ea5f",
 CellID->737233985]
}, Open  ]],
Cell[33273, 869, 116, 1, 70, "ExampleText",ExpressionUUID->"38331c03-aa96-4152-9614-282de0d1ca44",
 CellID->351008126],
Cell[CellGroupData[{
Cell[33414, 874, 72215, 1215, 70, "WolframAlphaShortInput",ExpressionUUID->"455eea46-b24f-4a9a-b912-dec27a7efdf4",
 CellID->359475843],
Cell[105632, 2091, 29087, 483, 281, "Output",ExpressionUUID->"9fc69311-8f57-4f91-9fba-cec0674c2dd1",
 CellTags->"RasterizedOutput",
 CellID->174563966]
}, Open  ]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"}, Closed]]]],
Cell[CellGroupData[{
Cell[134868, 2582, 1419, 37, 70, "ExampleSection",ExpressionUUID->"113976c5-8ba3-483e-a62e-6c8a90005be3",
 CellID->258228157],
Cell[136290, 2621, 174, 3, 70, "Input",ExpressionUUID->"29559e0e-3a14-4f4f-a726-563fbd07d524",
 CellID->64581912],
Cell[136467, 2626, 245, 6, 70, "ExampleText",ExpressionUUID->"90e93284-1f91-4cd4-ba93-373e8a2ed3c9",
 CellID->204406933],
Cell[136715, 2634, 6481, 174, 70, "Input",ExpressionUUID->"33c63f74-e15e-42ad-b99b-d231a169f761",
 CellID->35931609],
Cell[CellGroupData[{
Cell[143221, 2812, 2401, 62, 70, "Input",ExpressionUUID->"54fd5798-38ec-46d1-bafa-92c10c89ed1c",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellID->204930428],
Cell[145625, 2876, 28343, 591, 307, "Output",ExpressionUUID->"627ca789-51b3-4a72-a894-34bc13f35cc2",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellID->502454435]
}, Open  ]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "2"}, Closed]]]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "PrimaryExamplesSection"}, Closed]]]],
Cell[174210, 3476, 816, 21, 70, "SeeAlsoSection",ExpressionUUID->"596b97bd-3b78-417e-b7e8-3314b9f5eac8"],
Cell[175029, 3499, 729, 19, 70, "MoreAboutSection",ExpressionUUID->"fe889782-52d3-44e9-95c8-6e4a8aedad06"],
Cell[175761, 3520, 1607, 43, 70, "RelatedLinksSection",ExpressionUUID->"d7d1cad4-4b17-47e6-8050-3c90d723bc93"],
Cell[177371, 3565, 78, 0, 70, "FooterCell",ExpressionUUID->"5067168d-4362-45ea-a5d9-9a4fd52343c7"]
}
]
*)

(* End of internal cache information *)

