(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 13.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     66005,       1369]
NotebookOptionsPosition[     60442,       1255]
NotebookOutlinePosition[     62913,       1316]
CellTagsIndexPosition[     62791,       1310]
WindowTitle->PRhoSat
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[GridBox[{
   {GridBox[{
      {
       ItemBox[Cell[BoxData[
         RowBox[{
          TemplateBox[{12},
           "Spacer1"], Cell["NEW EO S ARGON PACKAGE SYMBOL", "PacletNameCell",
           TextAlignment->Center,ExpressionUUID->
           "657fc724-ebfa-413e-9fb0-33eafe21a213"], 
          TemplateBox[{8},
           "Spacer1"]}]],
         TextAlignment->Center,ExpressionUUID->
         "0a7e029e-62fd-4eb6-b212-b151e2083a27"],
        Background->RGBColor[0.490196, 0.576471, 0.690196],
        ItemSize->Full], ""}
     },
     GridBoxAlignment->{"Rows" -> {{Center}}},
     GridBoxItemSize->{"Columns" -> {Full, 
         Scaled[0.02]}, "Rows" -> {{2.5}}}], Cell[TextData[{
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "See Also",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "a3088037-0fe4-4060-9c10-34b02da1ffa0"]
         }],ExpressionUUID->"f32220c3-ceb4-408e-8f61-cdceb7363266"],
         StripOnInput->False],{
        "\"ptrNv\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/ptrNv"], "\"pcNv\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/pcNv"], 
         "\"PRhoSatNIST\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/PRhoSatNIST"], 
         "\"rhotrgaz\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/rhotrgaz"], 
         "\"rhotrliq\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/rhotrliq"], 
         "\"TRhoSat\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/TRhoSat"]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"SeeAlso"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "c32f791a-7e10-44fe-88ec-618689cd26be"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "Related Guides",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "06d01298-cc80-4784-96ad-68b1fdb71cd6"]
         }],ExpressionUUID->"09f5bd34-5316-4c49-9667-65e4c2177d87"],
         StripOnInput->False],{
        "\"NewEoSArgon Package\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/guide/NewEoSArgon"]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"MoreAbout"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "486be04b-95ea-4008-8fb9-b343ce2b17cf"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "URL",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "3cf2c89d-4350-42be-96da-1d3da2d61c58"]
         }],ExpressionUUID->"21d7aed3-5318-447c-986e-8f27900e4d0c"],
         StripOnInput->False],{
        "\"NewEoSArgon/ref/PRhoSat\"" :> None, 
         "\"Copy Wolfram Documentation Center URL\"" :> 
         Module[{DocumentationSearch`Private`nb$}, 
           DocumentationSearch`Private`nb$ = 
            NotebookPut[
             Notebook[{Cell["NewEoSArgon/ref/PRhoSat"]}, Visible -> False]]; 
           SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
           FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
           NotebookClose[DocumentationSearch`Private`nb$]; Null], Delimiter, 
         "\"Copy web URL\"" :> 
         Module[{DocumentationSearch`Private`nb$}, 
           DocumentationSearch`Private`nb$ = 
            NotebookPut[
             Notebook[{
               Cell[BoxData[
                 MakeBoxes[
                  Hyperlink[
                   "http://reference.wolfram.com/language/NewEoSArgon/ref/\
PRhoSat.html"], StandardForm]], "Input", TextClipboardType -> "PlainText"]}, 
               Visible -> False]]; 
           SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
           FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
           NotebookClose[DocumentationSearch`Private`nb$]; Null], 
         "\"Go to web URL\"" :> 
         FrontEndExecute[{
           NotebookLocate[{
             URL[If[TrueQ[DocumentationBuild`Make`Private`wsmlinkQ$19538], 
                 "http://reference.wolfram.com/system-modeler/", 
                 "http://reference.wolfram.com/language/"] <> 
               "NewEoSArgon/ref/PRhoSat" <> ".html"], None}]}]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"URLMenu"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "6dec1b6a-27b9-42f7-9061-304cfbb89656"]
    }], "AnchorBar",
     CacheGraphics->False,ExpressionUUID->
     "77f011a6-094c-45f3-a2d8-aca44cf1a4ee"]}
  }]], "AnchorBarGrid",
 CellID->1,ExpressionUUID->"7a607811-fcdc-400e-b359-5ee22404416a"],

Cell["NewEoSArgon`", "ContextNameCell",ExpressionUUID->"c4dedda6-9bb3-4363-9022-e930a730163e"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     Cell[
     "PRhoSat", "ObjectName",ExpressionUUID->
      "3c2ae930-81bd-4222-b2b3-90e131a4f450"],
     Cell[BoxData[
      TemplateBox[{8},
       "Spacer1"]],ExpressionUUID->"4c73fa73-b5fb-4816-952a-f96facd53643"],
     Cell[BoxData[
     ""], "ObjectNameTranslation",ExpressionUUID->
      "dd94b3c7-92d9-414e-a7b8-6720bbc9e2b0"]
    }],ExpressionUUID->"ad255898-1ab7-4007-83de-54e482240a98"], 
    "\[SpanFromLeft]"}
  }]], "ObjectNameGrid",ExpressionUUID->"2bdae3e6-d207-4983-b98c-\
8535d8bd0c38"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"PRhoSat", "[", 
       StyleBox["\[Rho]", "TR"], "]"}]], "InlineFormula",
      ShowStringCharacters->False,
      FontFamily->"Source Sans Pro",ExpressionUUID->
      "00075d44-f9c8-4cd1-99a3-b2f2bdbcacc9"],
     " \[Congruent] ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["P",
        FontSlant->"Italic"], "\[Sigma]"]], "InlineFormula",
      FontFamily->"Source Sans Pro",ExpressionUUID->
      "4e2a9261-f70e-46ad-a392-6ad38436a8ac"],
     " (MPa)\nPression sur la courbe de saturation en fonction de \[Rho] (g/",
     Cell[BoxData[
      SuperscriptBox["cm", "3"]], "InlineFormula",
      FontFamily->"Source Sans Pro",ExpressionUUID->
      "e13b66c1-4ab1-476d-ac6c-5f872609e3de"],
     ")\n[Fitting function of the saturated pressure versus \[Rho] (g/",
     Cell[BoxData[
      SuperscriptBox["cm", "3"]], "InlineFormula",
      FontFamily->"Source Sans Pro",ExpressionUUID->
      "6526563a-cb08-4934-bb8e-9e83b8d3e522"],
     ")]"
    }],ExpressionUUID->"f03046fd-af18-470e-9f1c-b53cc97acd92"]}
  }]], "Usage",ExpressionUUID->"9cada933-a1fe-489e-9e49-6c9cdc5dbe71"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[Cell[TextData[{
   Cell[BoxData[
    DynamicBox[ToBoxes[
      If[
       MatchQ[
        CurrentValue[
         EvaluationNotebook[], {TaggingRules, "Openers", "NotesSection"}, 
         Closed], 
        Alternatives[Open, True]], 
       Style[
        Graphics[{
          Thickness[0.18], 
          RGBColor[0.8509803921568627, 0.396078431372549, 0], 
          Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
         PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
        0.68 Inherited], 
       Rotate[
        Style[
         Graphics[{
           Thickness[0.18], 
           RGBColor[0.8509803921568627, 0.396078431372549, 0], 
           Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
          PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
         0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
     ImageSizeCache->{
      13.600000000000001`, {0.5800000000000001, 13.020000000000001`}}]],
    ExpressionUUID->"fc9208fb-0704-417a-bf83-0307f49ef353"],
   Cell[BoxData[
    TemplateBox[{1},
     "Spacer1"]],ExpressionUUID->"31ba363c-ceb7-4668-8ce0-a853c6130f4d"],
   "Details and Options"
  }], "NotesFrameText",ExpressionUUID->"e570e84b-4b33-41fa-9798-93c01afc9fd8"],
  Appearance->{Automatic, None, "Normal", Automatic},
  BaseStyle->None,
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"], 
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], After, CellContents]}]& ),
  Evaluator->None,
  Method->
   "Preemptive"]],ExpressionUUID->"c641d3ba-ca14-4493-ac92-3ad6309e4eca"]], \
"NotesSection",
 WholeCellGroupOpener->True,
 CellGroupingRules->{"SectionGrouping", 50},
 CacheGraphics->False,
 CellID->622493562,ExpressionUUID->"21fdb5f0-0e41-475c-96c5-2638c0c24126"],

Cell[TextData[{
 "La fonction est d\[EAcute]finie pour ",
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["\[Rho]trgaz"]], "paclet:NewEoSArgon/ref/rhotrgaz", 
    "NewEoSArgon Package Symbol"},
   "PackageLink",
   BaseStyle->"InlineFormula"]], "InlineFormula",
  FontFamily->"Source Sans Pro",ExpressionUUID->
  "672f0fe0-f228-4e48-8b05-039581065196"],
 " \[LessEqual] \[Rho] \[LessEqual] ",
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["\[Rho]trliq"]], "paclet:NewEoSArgon/ref/rhotrliq", 
    "NewEoSArgon Package Symbol"},
   "PackageLink",
   BaseStyle->"InlineFormula"]], "InlineFormula",
  FontFamily->"Source Sans Pro",ExpressionUUID->
  "2d239ae3-ae7c-4ae2-a5af-6a08c3eb928e"]
}], "Notes",
 CellID->1067943069,ExpressionUUID->"28cf1b0e-1d51-48c3-ac99-dd4808383ed8"],

Cell["\<\
******************************************************************************\
******\
\>", "Notes",
 CellID->224665577,ExpressionUUID->"653a0ebf-d3b3-4539-bd79-66f059f7672e"],

Cell[TextData[{
 "The function is defined for ",
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["\[Rho]trgaz"]], "paclet:NewEoSArgon/ref/rhotrgaz", 
    "NewEoSArgon Package Symbol"},
   "PackageLink",
   BaseStyle->"InlineFormula"]], "InlineFormula",
  FontFamily->"Source Sans Pro",ExpressionUUID->
  "c6fca9f0-f807-4f84-a351-1843830f4cce"],
 " \[LessEqual] \[Rho] \[LessEqual] ",
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["\[Rho]trliq"]], "paclet:NewEoSArgon/ref/rhotrliq", 
    "NewEoSArgon Package Symbol"},
   "PackageLink",
   BaseStyle->"InlineFormula"]], "InlineFormula",
  FontFamily->"Source Sans Pro",ExpressionUUID->
  "f546c66e-7900-42e1-9c36-9a404bf29b4c"]
}], "Notes",
 CellID->620823206,ExpressionUUID->"5ae8c520-c58a-4d91-9cbb-7f6c48d46dc2"]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "NotesSection"}, Closed]]]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {
       TaggingRules, "Openers", "PrimaryExamplesSection"}, Open], 
      Alternatives[True, Open]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{13.600000000000001`, {5., 8.600000000000001}}]],
  ExpressionUUID->"17746cf7-4b3a-4b82-9bf4-f7d35bbb2922"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"b38e195b-e661-440f-b29b-6e3f53acf477"],
 "Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "c27030ca-621c-4cc0-b744-c9b6abef833c"]
}], "PrimaryExamplesSection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellTags->"PrimaryExamplesSection",
 CellID->431113162,ExpressionUUID->"4aa0bfc3-f173-46b8-8186-585365290a18"],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"},
        Closed], 
      Alternatives[Open, True]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{13.600000000000001`, {5., 8.600000000000001}}]],
  ExpressionUUID->"1eca7db2-6db9-4318-a864-50d577aa87f2"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"5f53676f-eee1-41d1-a32b-0e474db597d7"],
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "1878acfd-3ae9-4c5e-9615-f9821e47a5c5"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellID->353281578,ExpressionUUID->"36aef2ae-67d0-4fc4-8849-260c45380981"],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<NewEoSArgon`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->87419684,ExpressionUUID->"19a09e33-e64e-4087-9f68-db7fb6150084"],

Cell["Calculate with physical dimension", "ExampleText",
 CellID->285078790,ExpressionUUID->"b1097b8e-4be5-4a48-9fde-d89bc76d05e1"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Quantity", "[", 
  RowBox[{
   RowBox[{"PRhoSat", "[", "\[Rho]trgaz", "]"}], ",", "\"\<MPa\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->231987987,ExpressionUUID->"8efa602f-98bc-4eeb-85d9-5ca3c71549b0"],

Cell[BoxData[
 TemplateBox[{
  "0.06888184405318462`", "\"MPa\"", "megapascals", "\"Megapascals\""},
  "Quantity"]], "Output",
 CellLabel->"Out[2]=",
 CellID->76538561,ExpressionUUID->"d080b665-30ab-4e10-a112-63a64d41eabd"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UnitConvert", "[", 
  RowBox[{
   TemplateBox[{"0.06888184405318462`"},
    "QuantityUnit",
    DisplayFunction->(TooltipBox[
      StyleBox[
       RowBox[{#, "\[InvisibleSpace]", 
         StyleBox[
          RowBox[{" ", "\"MPa\""}], "QuantityUnitTraditionalLabel"]}], 
       ShowStringCharacters -> False], "Unit: megapascals"]& ),
    InterpretationFunction->(RowBox[{"Quantity", "[", 
       RowBox[{#, ",", "\"Megapascals\""}], "]"}]& )], ",", "\"\<Bars\>\""}], 
  "]"}]], "Input",
 NumberMarks->False,
 CellLabel->"In[3]:=",
 CellID->320323337,ExpressionUUID->"6b4600ad-a736-4346-a94d-63a0b991fcc7"],

Cell[BoxData[
 TemplateBox[{"0.6888184405318462`", "\"bar\"", "bars", "\"Bars\""},
  "Quantity"]], "Output",
 CellLabel->"Out[3]=",
 CellID->127920981,ExpressionUUID->"cf232409-0163-4b76-923c-4c9203207de9"]
}, Open  ]],

Cell["\<\
Plot function versus density and comparison with saturated curve from NIST\
\>", "ExampleText",
 CellID->886239600,ExpressionUUID->"5a4e1d92-46f7-4e56-9005-05ba73ba6a57"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"10", "*", 
      RowBox[{"PRhoSat", "[", "\[Rho]", "]"}]}], ",", 
     RowBox[{"PRhoSatNIST", "[", "\[Rho]", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Rho]", ",", "\[Rho]trgaz", ",", "\[Rho]trliq"}], "}"}], ",", 
   RowBox[{"AxesOrigin", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\[Rho]c", ",", "ptr"}], "}"}]}], ",", 
   RowBox[{"Frame", "->", "True"}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Quantity", "[", 
       RowBox[{"\[Rho]", ",", "\"\<g/cm^3\>\""}], "]"}], ",", 
      RowBox[{"Quantity", "[", 
       RowBox[{"P", ",", "\"\<Bars\>\""}], "]"}]}], "}"}]}], ",", 
   RowBox[{"ImageSize", "\[Rule]", "400"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Red", ",", 
      RowBox[{"{", 
       RowBox[{"Black", ",", "Dashed"}], "}"}]}], "}"}]}], ",", 
   RowBox[{"PlotLegends", "\[Rule]", "\"\<Expressions\>\""}]}], 
  "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->21488140,ExpressionUUID->"d04bb80c-f08d-45c7-bd79-fee576b66edd"],

Cell[BoxData[
 GraphicsBox[
  TagBox[RasterBox[CompressedData["
1:eJzs3W9sZNd52P/D3VkttRrblMRKlELbtJeWaYWW6HhtbxwmYhIaouttwTqM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    "], {{0, 264.}, {552., 0}}, {0, 255},
    ColorFunction->RGBColor,
    ImageResolution->{144., 144.},
    SmoothingQuality->"High"],
   BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
   Selectable->False],
  DefaultBaseStyle->"ImageGraphics",
  ImageSize->Automatic,
  ImageSizeRaw->{552., 264.},
  PlotRange->{{0, 552.}, {0, 264.}}]], "Output",
 CellTags->"RasterizedOutput",
 CellLabel->"Out[4]=",
 CellID->357531903,ExpressionUUID->"e6b39dea-5c4b-4dd9-bdae-9c5e104984b6"]
}, Open  ]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"}, 
  Closed]]]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "PrimaryExamplesSection"}, 
  Closed]]]],

Cell[BoxData[GridBox[{
   {
    DynamicBox[FEPrivate`ImportImage[
      FrontEnd`FileName[{"Documentation", "FooterIcons"}, 
       "RelatedFunction.png"]],
     ImageSizeCache->{50., {27., 33.}}], GridBox[{
      {
       StyleBox[
        RowBox[{"See", " ", "Also"}], "SeeAlsoSection"]},
      {Cell[TextData[{
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["ptrNv"]], "paclet:NewEoSArgon/ref/ptrNv", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "30b1c22b-4ad8-4a7b-8864-7433358781f9"],
        "\[NonBreakingSpace]",
        StyleBox[
        "\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
         "InlineSeparator"],
        " ",
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["pcNv"]], "paclet:NewEoSArgon/ref/pcNv", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "bed287ae-63d9-463b-bc1a-d2bc2cdb77ca"],
        "\[NonBreakingSpace]",
        StyleBox[
        "\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
         "InlineSeparator"],
        " ",
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["PRhoSatNIST"]], "paclet:NewEoSArgon/ref/PRhoSatNIST", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "e1baded9-24ae-4c9d-a37c-a626aba8d837"],
        "\[NonBreakingSpace]",
        StyleBox[
        "\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
         "InlineSeparator"],
        " ",
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["rhotrgaz"]], "paclet:NewEoSArgon/ref/rhotrgaz", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "cb1d2bde-7396-48dd-b97b-0e84914c5818"],
        "\[NonBreakingSpace]",
        StyleBox[
        "\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
         "InlineSeparator"],
        " ",
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["rhotrliq"]], "paclet:NewEoSArgon/ref/rhotrliq", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "64643914-fa1c-4ab8-ac47-aab96a839651"]
       }], "SeeAlso",ExpressionUUID->"cbfef795-7226-47bf-b703-e6ea5ed80c29"]}
     }]}
  }]], "SeeAlsoSection",ExpressionUUID->"841022af-e11f-47bd-a634-\
7952d25c6622"],

Cell[BoxData[GridBox[{
   {
    DynamicBox[FEPrivate`ImportImage[
      FrontEnd`FileName[{"Documentation", "FooterIcons"}, "RelatedGuide.png"]],
     ImageSizeCache->{50., {27., 33.}}], GridBox[{
      {
       StyleBox[
        RowBox[{"Related", " ", "Guides"}], "MoreAboutSection"]},
      {
       RowBox[{"\[FilledVerySmallSquare]", Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["NewEoSArgon Package"]], 
           "paclet:NewEoSArgon/guide/NewEoSArgon"},
          "RefLinkPlain",
          BaseStyle->{"MoreAbout"}]], "MoreAbout",ExpressionUUID->
         "aabeda55-4068-4648-b7e9-bfd43836a3cd"]}]}
     }]}
  }]], "MoreAboutSection",ExpressionUUID->"c149ad60-b87f-46bc-8eb6-\
6bbb8c65c069"],

Cell[BoxData[GridBox[{
   {
    TemplateBox[{29},
     "Spacer1"], GridBox[{
      {
       RowBox[{
        TemplateBox[{17},
         "Spacer1"], 
        StyleBox[
         RowBox[{"Related", " ", "Links"}], "RelatedLinksSection"]}]},
      {Cell[BoxData[Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData[
             RowBox[{
               RowBox[{"Units", " ", "&"}], " ", "Quantities"}]]], 
           "paclet:guide/Units"},
          "RefLinkPlain",
          BaseStyle->{"RelatedLinks"}]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "7b463043-64bd-49b0-b7d2-c313f9a399c9"]], "RelatedLinks",
        ExpressionUUID->"bd0328cf-e714-4c86-b779-f3a2867c2a98"]}
     }]}
  }]], "RelatedLinksSection",ExpressionUUID->"9b66d64e-08d7-4630-974c-\
f7ecbcc32667"],

Cell[" ", "FooterCell",ExpressionUUID->"96d323ad-f11a-496b-a1cb-76cc06fecccc"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{900, 835.8},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"PRhoSat",
TaggingRules->{
 "ModificationHighlight" -> False, "ColorType" -> "", "LinkTrails" -> "", 
  "HasOptions" -> True, "ExampleCounter" -> 1, 
  "Openers" -> {
   "PrimaryExamplesSection" -> Open, "ExampleSection" -> {"0" -> Open}, 
    "NotesSection" -> Closed}, "NewStyles" -> True, 
  "CitationPopupData" -> $Failed, "ShowCitation" -> False, "RootCaptions" -> 
  "", "Metadata" -> {
   "built" -> "{2023, 11, 30, 13, 55, 48.3214374}", 
    "history" -> {"XX", "", "", ""}, "context" -> "NewEoSArgon`", 
    "keywords" -> {}, "specialkeywords" -> {}, 
    "tutorialcollectionlinks" -> {}, "index" -> True, "label" -> 
    "New Eo S Argon Package Symbol", "language" -> "en", "paclet" -> 
    "NewEoSArgon Package", "status" -> "None", "summary" -> 
    "PRhoSat[\\[Rho]] \\[Congruent] P\\[Sigma] (MPa) Pression sur la courbe \
de saturation en fonction de \\[Rho] (g/cm^3) [Fitting function of the \
saturated pressure versus \\[Rho] (g/cm^3)]", "synonyms" -> {}, 
    "tabletags" -> {}, "title" -> "PRhoSat", "titlemodifier" -> "", 
    "metadescription" -> "", "windowtitle" -> "PRhoSat", "type" -> "Symbol", 
    "uri" -> "NewEoSArgon/ref/PRhoSat"}},
CellContext->"Global`",
FrontEndVersion->"13.3 pour Microsoft Windows (64-bit) (July 24, 2023)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "13.3 pour Microsoft Windows (64-bit) (July 24, 2023)", 
  StyleDefinitions -> "Default.nb"],
ExpressionUUID->"d1447d7d-913d-446f-b664-22dce4205912"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[11930, 319, 1420, 37, 35, "PrimaryExamplesSection",ExpressionUUID->"4aa0bfc3-f173-46b8-8186-585365290a18",
   CellTags->"PrimaryExamplesSection",
   CellID->431113162]},
 "RasterizedOutput"->{
  Cell[17801, 490, 37842, 627, 285, "Output",ExpressionUUID->"e6b39dea-5c4b-4dd9-bdae-9c5e104984b6",
   CellTags->"RasterizedOutput",
   CellID->357531903]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 62410, 1299},
 {"RasterizedOutput", 62610, 1303}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[579, 21, 5658, 136, 56, "AnchorBarGrid",ExpressionUUID->"7a607811-fcdc-400e-b359-5ee22404416a",
 CellID->1],
Cell[6240, 159, 94, 0, 23, "ContextNameCell",ExpressionUUID->"c4dedda6-9bb3-4363-9022-e930a730163e"],
Cell[CellGroupData[{
Cell[6359, 163, 550, 14, 56, "ObjectNameGrid",ExpressionUUID->"2bdae3e6-d207-4983-b98c-8535d8bd0c38"],
Cell[6912, 179, 1170, 27, 146, "Usage",ExpressionUUID->"9cada933-a1fe-489e-9e49-6c9cdc5dbe71"]
}, Open  ]],
Cell[CellGroupData[{
Cell[8119, 211, 1919, 48, 37, "NotesSection",ExpressionUUID->"21fdb5f0-0e41-475c-96c5-2638c0c24126",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->622493562],
Cell[10041, 261, 790, 22, 38, "Notes",ExpressionUUID->"28cf1b0e-1d51-48c3-ac99-dd4808383ed8",
 CellID->1067943069],
Cell[10834, 285, 186, 4, 36, "Notes",ExpressionUUID->"653a0ebf-d3b3-4539-bd79-66f059f7672e",
 CellID->224665577],
Cell[11023, 291, 780, 22, 38, "Notes",ExpressionUUID->"5ae8c520-c58a-4d91-9cbb-7f6c48d46dc2",
 CellID->620823206]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "NotesSection"}, Closed]]]],
Cell[CellGroupData[{
Cell[11930, 319, 1420, 37, 35, "PrimaryExamplesSection",ExpressionUUID->"4aa0bfc3-f173-46b8-8186-585365290a18",
 CellTags->"PrimaryExamplesSection",
 CellID->431113162],
Cell[CellGroupData[{
Cell[13375, 360, 1398, 36, 30, "ExampleSection",ExpressionUUID->"36aef2ae-67d0-4fc4-8849-260c45380981",
 CellID->353281578],
Cell[14776, 398, 174, 3, 26, "Input",ExpressionUUID->"19a09e33-e64e-4087-9f68-db7fb6150084",
 CellID->87419684],
Cell[14953, 403, 131, 1, 38, "ExampleText",ExpressionUUID->"b1097b8e-4be5-4a48-9fde-d89bc76d05e1",
 CellID->285078790],
Cell[CellGroupData[{
Cell[15109, 408, 240, 6, 26, "Input",ExpressionUUID->"8efa602f-98bc-4eeb-85d9-5ca3c71549b0",
 CellID->231987987],
Cell[15352, 416, 223, 5, 39, "Output",ExpressionUUID->"d080b665-30ab-4e10-a112-63a64d41eabd",
 CellID->76538561]
}, Open  ]],
Cell[CellGroupData[{
Cell[15612, 426, 632, 16, 26, "Input",ExpressionUUID->"6b4600ad-a736-4346-a94d-63a0b991fcc7",
 CellID->320323337],
Cell[16247, 444, 206, 4, 40, "Output",ExpressionUUID->"cf232409-0163-4b76-923c-4c9203207de9",
 CellID->127920981]
}, Open  ]],
Cell[16468, 451, 180, 3, 38, "ExampleText",ExpressionUUID->"5a4e1d92-46f7-4e56-9005-05ba73ba6a57",
 CellID->886239600],
Cell[CellGroupData[{
Cell[16673, 458, 1125, 30, 57, "Input",ExpressionUUID->"d04bb80c-f08d-45c7-bd79-fee576b66edd",
 CellID->21488140],
Cell[17801, 490, 37842, 627, 285, "Output",ExpressionUUID->"e6b39dea-5c4b-4dd9-bdae-9c5e104984b6",
 CellTags->"RasterizedOutput",
 CellID->357531903]
}, Open  ]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"}, Closed]]]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "PrimaryExamplesSection"}, Closed]]]],
Cell[55885, 1126, 2912, 78, 70, "SeeAlsoSection",ExpressionUUID->"841022af-e11f-47bd-a634-7952d25c6622"],
Cell[58800, 1206, 729, 19, 70, "MoreAboutSection",ExpressionUUID->"c149ad60-b87f-46bc-8eb6-6bbb8c65c069"],
Cell[59532, 1227, 825, 24, 70, "RelatedLinksSection",ExpressionUUID->"9b66d64e-08d7-4630-974c-f7ecbcc32667"],
Cell[60360, 1253, 78, 0, 70, "FooterCell",ExpressionUUID->"96d323ad-f11a-496b-a1cb-76cc06fecccc"]
}
]
*)

(* End of internal cache information *)

