(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 13.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     60806,       1330]
NotebookOptionsPosition[     55425,       1221]
NotebookOutlinePosition[     57747,       1278]
CellTagsIndexPosition[     57661,       1273]
WindowTitle->PRhoSatNIST
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[GridBox[{
   {GridBox[{
      {
       ItemBox[Cell[BoxData[
         RowBox[{
          TemplateBox[{12},
           "Spacer1"], Cell["NEW EO S ARGON PACKAGE SYMBOL", "PacletNameCell",
           TextAlignment->Center,ExpressionUUID->
           "6abf55a2-f8fa-41cd-bba5-2926dca91840"], 
          TemplateBox[{8},
           "Spacer1"]}]],
         TextAlignment->Center,ExpressionUUID->
         "46d87a6e-d32e-4399-b448-d8c2036ed572"],
        Background->RGBColor[0.490196, 0.576471, 0.690196],
        ItemSize->Full], ""}
     },
     GridBoxAlignment->{"Rows" -> {{Center}}},
     GridBoxItemSize->{"Columns" -> {Full, 
         Scaled[0.02]}, "Rows" -> {{2.5}}}], Cell[TextData[{
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "See Also",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "a90340aa-6914-4f57-bc21-c66e6181bf76"]
         }],ExpressionUUID->"b90d03c2-7b2a-42ed-9ac2-083c606511f3"],
         StripOnInput->False],{
        "\"ptr\"" :> Documentation`HelpLookup["paclet:NewEoSArgon/ref/ptr"], 
         "\"pc\"" :> Documentation`HelpLookup["paclet:NewEoSArgon/ref/pc"], 
         "\"ttr\"" :> Documentation`HelpLookup["paclet:NewEoSArgon/ref/ttr"], 
         "\"tc\"" :> Documentation`HelpLookup["paclet:NewEoSArgon/ref/tc"], 
         "\"rhotrgaz\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/rhotrgaz"], 
         "\"rhotrliq\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/rhotrliq"]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"SeeAlso"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "8ea29daa-3cb9-4f65-95a7-842164f13106"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "Related Guides",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "5db6cf9c-45a4-4ca8-9d9c-842603a4a11d"]
         }],ExpressionUUID->"e506d6ce-402e-4e0d-bd24-918277b7d764"],
         StripOnInput->False],{
        "\"NewEoSArgon Package\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/guide/NewEoSArgon"]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"MoreAbout"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "b323d241-3d23-4691-835b-9bc3b9e7cb71"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "URL",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "529542d3-f144-46d7-beae-8b1c18d29cb8"]
         }],ExpressionUUID->"5e33e9c9-2f1b-456b-bc18-0e058c31a86c"],
         StripOnInput->False],{
        "\"NewEoSArgon/ref/PRhoSatNIST\"" :> None, 
         "\"Copy Wolfram Documentation Center URL\"" :> 
         Module[{DocumentationSearch`Private`nb$}, 
           DocumentationSearch`Private`nb$ = 
            NotebookPut[
             Notebook[{Cell["NewEoSArgon/ref/PRhoSatNIST"]}, Visible -> 
               False]]; 
           SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
           FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
           NotebookClose[DocumentationSearch`Private`nb$]; Null], Delimiter, 
         "\"Copy web URL\"" :> 
         Module[{DocumentationSearch`Private`nb$}, 
           DocumentationSearch`Private`nb$ = 
            NotebookPut[
             Notebook[{
               Cell[BoxData[
                 MakeBoxes[
                  Hyperlink[
                   "http://reference.wolfram.com/language/NewEoSArgon/ref/\
PRhoSatNIST.html"], StandardForm]], "Input", TextClipboardType -> 
                 "PlainText"]}, Visible -> False]]; 
           SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
           FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
           NotebookClose[DocumentationSearch`Private`nb$]; Null], 
         "\"Go to web URL\"" :> 
         FrontEndExecute[{
           NotebookLocate[{
             URL[If[TrueQ[DocumentationBuild`Make`Private`wsmlinkQ$20064], 
                 "http://reference.wolfram.com/system-modeler/", 
                 "http://reference.wolfram.com/language/"] <> 
               "NewEoSArgon/ref/PRhoSatNIST" <> ".html"], None}]}]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"URLMenu"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "c33cbda8-6160-4e71-ba4c-61a83f96c01f"]
    }], "AnchorBar",
     CacheGraphics->False,ExpressionUUID->
     "0179ac2f-388a-4632-8859-1ac57f7d8978"]}
  }]], "AnchorBarGrid",
 CellID->1,ExpressionUUID->"caee693f-2d81-4eee-9560-2a78306c163c"],

Cell["NewEoSArgon`", "ContextNameCell",ExpressionUUID->"8d4b4e05-7ab3-4743-9fb8-962c72af96a0"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     Cell[
     "PRhoSatNIST", "ObjectName",ExpressionUUID->
      "bd509e14-46df-48eb-85d2-8a4e0374a8e3"],
     Cell[BoxData[
      TemplateBox[{8},
       "Spacer1"]],ExpressionUUID->"fc3fa4e1-7ea5-4260-9486-274eb491c1e7"],
     Cell[BoxData[
     ""], "ObjectNameTranslation",ExpressionUUID->
      "ed7e842d-f2c1-4737-8cae-651b11a97e35"]
    }],ExpressionUUID->"4967e2af-048a-4a85-aa69-8bff05993bd6"], 
    "\[SpanFromLeft]"}
  }]], "ObjectNameGrid",ExpressionUUID->"41e2212b-56b0-4655-82eb-\
55429a75643d"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"PRhoSatNIST", "[", 
       StyleBox["\[Rho]", "TR"], "]"}]], "InlineFormula",
      ShowStringCharacters->False,
      FontFamily->"Source Sans Pro",ExpressionUUID->
      "cae4bd37-1a92-43e5-8388-78f2b8dd95d5"],
     " \[Congruent] ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["P",
        FontSlant->"Italic"], "\[Sigma]"]], "InlineFormula",
      FontFamily->"Source Sans Pro",ExpressionUUID->
      "1ade650c-bb67-4a51-9c3b-39b3a8d67374"],
     " (bar)\nPression sur la courbe de saturation donn\[EAcute]e par NIST en \
fonction de \[Rho] (g/",
     Cell[BoxData[
      SuperscriptBox["cm", "3"]], "InlineFormula",
      FontFamily->"Source Sans Pro",ExpressionUUID->
      "ed36d8c5-1565-4a87-b8c9-b881322e96f4"],
     ")\n[Fitting function of the saturated pressure versus \[Rho] (g/",
     Cell[BoxData[
      SuperscriptBox["cm", "3"]], "InlineFormula",
      FontFamily->"Source Sans Pro",ExpressionUUID->
      "255c1e2f-5ba9-44ad-9eef-30c3c9b6d1a0"],
     ") from the data of NIST]"
    }],ExpressionUUID->"4a9b6939-0408-4ddc-8b3b-009944100298"]}
  }]], "Usage",ExpressionUUID->"2c085a28-6040-4106-b932-1bf9e3b13796"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[Cell[TextData[{
   Cell[BoxData[
    DynamicBox[ToBoxes[
      If[
       MatchQ[
        CurrentValue[
         EvaluationNotebook[], {TaggingRules, "Openers", "NotesSection"}, 
         Closed], 
        Alternatives[Open, True]], 
       Style[
        Graphics[{
          Thickness[0.18], 
          RGBColor[0.8509803921568627, 0.396078431372549, 0], 
          Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
         PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
        0.68 Inherited], 
       Rotate[
        Style[
         Graphics[{
           Thickness[0.18], 
           RGBColor[0.8509803921568627, 0.396078431372549, 0], 
           Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
          PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
         0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
     ImageSizeCache->{
      13.600000000000001`, {0.5800000000000001, 13.020000000000001`}}]],
    ExpressionUUID->"b8bd0033-fc10-4dff-a69d-d2fa08faf884"],
   Cell[BoxData[
    TemplateBox[{1},
     "Spacer1"]],ExpressionUUID->"7a4b45b6-4eeb-48f3-abd7-2aad255edc58"],
   "Details and Options"
  }], "NotesFrameText",ExpressionUUID->"c11b875f-1411-4097-b97d-be07217d48e7"],
  Appearance->{Automatic, None, "Normal", Automatic},
  BaseStyle->None,
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"], 
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], After, CellContents]}]& ),
  Evaluator->None,
  Method->
   "Preemptive"]],ExpressionUUID->"b56f75c2-4573-4095-a3b6-32d29b4101a7"]], \
"NotesSection",
 WholeCellGroupOpener->True,
 CellGroupingRules->{"SectionGrouping", 50},
 CacheGraphics->False,
 CellID->762116176,ExpressionUUID->"35fc0fb8-bfa8-4389-86e1-5958560054b2"],

Cell[TextData[{
 "La fonction est d\[EAcute]finie pour ",
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["\[Rho]trgaz"]], "paclet:NewEoSArgon/ref/rhotrgaz", 
    "NewEoSArgon Package Symbol"},
   "PackageLink",
   BaseStyle->"InlineFormula"]], "InlineFormula",
  FontFamily->"Source Sans Pro",ExpressionUUID->
  "3449bd24-f88a-4856-a343-3fdcdf3f7fa5"],
 " \[LessEqual] \[Rho] \[LessEqual] ",
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["\[Rho]trliq"]], "paclet:NewEoSArgon/ref/rhotrliq", 
    "NewEoSArgon Package Symbol"},
   "PackageLink",
   BaseStyle->"InlineFormula"]], "InlineFormula",
  FontFamily->"Source Sans Pro",ExpressionUUID->
  "531545e0-5842-4dea-89c9-57c203bff2a8"]
}], "Notes",
 CellID->1067943069,ExpressionUUID->"97a7c37c-cefa-419c-a445-02a0dd287bf1"],

Cell["\<\
******************************************************************************\
******\
\>", "Notes",
 CellID->224665577,ExpressionUUID->"559aebb0-1aa9-4b54-952a-6dd8073e102d"],

Cell[TextData[{
 "The function is defined for ",
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["\[Rho]trgaz"]], "paclet:NewEoSArgon/ref/rhotrgaz", 
    "NewEoSArgon Package Symbol"},
   "PackageLink",
   BaseStyle->"InlineFormula"]], "InlineFormula",
  FontFamily->"Source Sans Pro",ExpressionUUID->
  "08cf44ce-7647-4256-9d48-99c0eae37a01"],
 " \[LessEqual] \[Rho] \[LessEqual] ",
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["\[Rho]trliq"]], "paclet:NewEoSArgon/ref/rhotrliq", 
    "NewEoSArgon Package Symbol"},
   "PackageLink",
   BaseStyle->"InlineFormula"]], "InlineFormula",
  FontFamily->"Source Sans Pro",ExpressionUUID->
  "8c9b07a9-1130-43de-9a17-a55c170a016c"]
}], "Notes",
 CellID->620823206,ExpressionUUID->"2bead130-ad33-4ce2-86a3-31d288175f24"]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "NotesSection"}, Closed]]]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {
       TaggingRules, "Openers", "PrimaryExamplesSection"}, Open], 
      Alternatives[True, Open]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{13.600000000000001`, {5., 8.600000000000001}}]],
  ExpressionUUID->"46687f78-c391-408c-9cd3-d42c112184d3"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"7a1ea475-c9fa-4ec0-ad75-83af02effa99"],
 "Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "c49aa575-b575-4052-a5f3-6180112850bb"]
}], "PrimaryExamplesSection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellTags->"PrimaryExamplesSection",
 CellID->553733116,ExpressionUUID->"7d23c30a-c875-49e9-81df-360f162c760d"],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"},
        Closed], 
      Alternatives[Open, True]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{13.600000000000001`, {5., 8.600000000000001}}]],
  ExpressionUUID->"a884ee27-6060-440d-895f-0d7b6c1bc787"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"736d25f3-ef14-4dbb-8d79-4fa651aeeb6f"],
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "77606d5d-9e7c-4f86-b7f9-90e4336faf7f"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellID->18125224,ExpressionUUID->"a4a47786-5cbe-4369-80d2-e375cc075780"],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<NewEoSArgon`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->87419684,ExpressionUUID->"600a021e-3806-43e1-b1b9-28d8ef8921eb"],

Cell["Calculate with physical dimension", "ExampleText",
 CellID->285078790,ExpressionUUID->"58212621-1d89-42d2-8c3a-ebc639f4df42"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Quantity", "[", 
  RowBox[{
   RowBox[{"PRhoSatNIST", "[", "\[Rho]trgaz", "]"}], ",", "\"\<Bars\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->231987987,ExpressionUUID->"65c9ee36-69da-4d0f-96da-604c573aeac2"],

Cell[BoxData[
 TemplateBox[{"0.68891`", "\"bar\"", "bars", "\"Bars\""},
  "Quantity"]], "Output",
 CellLabel->"Out[2]=",
 CellID->165633037,ExpressionUUID->"5207a9f9-3fb2-4d7f-91ee-a4d184ed474d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UnitConvert", "[", 
  RowBox[{
   TemplateBox[{"0.68891`"},
    "QuantityUnit",
    DisplayFunction->(TooltipBox[
      StyleBox[
       RowBox[{#, "\[InvisibleSpace]", 
         StyleBox[
          RowBox[{" ", "\"bars\""}], "QuantityUnitTraditionalLabel"]}], 
       ShowStringCharacters -> False], "Unit: bars"]& ),
    InterpretationFunction->(RowBox[{"Quantity", "[", 
       RowBox[{#, ",", "\"Bars\""}], "]"}]& )], ",", "\"\<MPa\>\""}], 
  "]"}]], "Input",
 NumberMarks->False,
 CellLabel->"In[3]:=",
 CellID->52306574,ExpressionUUID->"977cbd54-699e-470a-b537-43da5071ae8f"],

Cell[BoxData[
 TemplateBox[{
  "0.06889100000000001`", "\"MPa\"", "megapascals", "\"Megapascals\""},
  "Quantity"]], "Output",
 CellLabel->"Out[3]=",
 CellID->85172826,ExpressionUUID->"dd447a99-9e11-4b70-8d6b-60d34ddeafdf"]
}, Open  ]],

Cell["Plot function versus density in all the density range", "ExampleText",
 CellID->886239600,ExpressionUUID->"57a35199-0be8-443d-b4a4-7aed3530419b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"PRhoSatNIST", "[", "\[Rho]", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Rho]", ",", "\[Rho]trgaz", ",", "\[Rho]trliq"}], "}"}], ",", 
   RowBox[{"AxesOrigin", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\[Rho]c", ",", "ptr"}], "}"}]}], ",", 
   RowBox[{"Frame", "->", "True"}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Quantity", "[", 
       RowBox[{"\[Rho]", ",", "\"\<g/cm^3\>\""}], "]"}], ",", 
      RowBox[{"Quantity", "[", 
       RowBox[{"P", ",", "\"\<Bars\>\""}], "]"}]}], "}"}]}], ",", 
   RowBox[{"ImageSize", "\[Rule]", "400"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->21488140,ExpressionUUID->"7921b9fb-ec21-4db2-8326-213af4764d02"],

Cell[BoxData[
 GraphicsBox[
  InterpretationBox[{
    TagBox[{{{}, {}, 
       TagBox[
        {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[2], 
         Opacity[1.], LineBox[CompressedData["
1:eJwV13k8VF8UAHBkSSSkDSFRtiRb9nOFmbGLUJKE/CiibClJUolIKslesqSS
NiFEpSRZsmQ3i7HvZoYkftdf7/P9vM99791z7n33nB1ufrYnOdjY2B6zs7Gt
XpWGNskkpfrDq5fqTsl8g/C14lzo2IlzMBX0pUY0bxhc7zU2ILlA0K/u+3vQ
eAzuGd4MHXsbAmFSA3ZqxtPwN3WpATWEQ7WfoqtdJhNO5s+UB0VcB06fjOKQ
g2woRXlcLeFIIkSUW3co5fOht2e9/bYTsoBN7Om4mvM2JHPC/GFkwUuoMpxY
nzElh3I/9m4d4HwPruHXjwk170PCXl+++wtWQtX1SfauDE007CByzLfrE1Q5
SMfJ2eiiIK5Rf6fTX4E80l7sowaoIDJcpphUB2wEcfuWs4bolsWpOm6RBsiS
lMpMYDNC1Jv+E8rSDUDuG6gc5TJCWt+CBR1VsC2otwz5jBDd8KpDnkUDuCog
TfomI2SwP41KvNYAbPxPmzkVjdD0jobFaFYDRCRY1OQcMkKH5vcp8nU2Ann0
35WAHCMk0LxUw9PYBIjSHeipb4wcfD++fdveBFX+ykV2B4xRJm9k9om+JpCS
TdXRJxojlQM8Vz5MNAGbdy7iOmiMbN8I6fnxNwNbQJuSt4cxun9/1+t202ao
Op504kqMMRJ3ssnI+dIMrhxy6ostxkiRlh1sVPYLIj7wvCI4m6CYr+ltvtW/
AL2xFuNzNUGjTx+oJ9f+Ailr8xv17iaowD92drz9F5C1B/4jnDZBCsvnziTN
/cLxOu6x+YIJktt2wHNEqQWqbhQIyT0wQbLWZPvbmS1A5h2N3tpogiQ/iGt0
R7WCq7GV2wlNAtpq+fcSJbYV0JikoIs2AQn3d34dSsT31Q5sPqxHQJxrHhxm
ZLWClMP2vcYHCGjYTChsfUUrkM9WPV+yJKDXXVyfgdkKbKZHcqY8CMh4cdLm
yck2ID+J5h1IICD9Wz8fFvi0QVaeRmzcXQLSlHhOLQpogwgVRqR6EgHJHfAO
rLjSBmwnAjoupBLQ+hjag/Z0PF5SUXMkh4Dat3X0rW1vAzS+6a5lGQF5a1f7
+BLaIWJNVLIuhYDYTPsT+a3agZxeWl9LI6Ckw/9KntljZwfI2Q0S0KcQba5R
D+z6a0ePjxGQePGrdM+rePy61y32TAJqUn3ccLyqHZCWrEL5WiLSUrqqYqvz
G8iP3UNC9hBRg+4jhxnD3xBxkbn1+V4iOmn+MSzBFNvnHF/fPiJKPPW3tuHw
b0DBocPamkQ0nh9wwjzkN7BdGslrNiCiLFmPROO3v6FqC/G/SGsi4pE0YWgq
d0BV8rXDs2eI6G1QSoydRge4DufefuNPRG71U1L+evi+sFLSuXNEVBmaYvnU
rAOk+sibRoOIKLh1Klfsvw5ApCsrlWFENHAz5QhbFh7/Qy+UPYaIPjGmKr8L
dQK5V59n5jER+Zub2A9uxV48evzMEyKSeJwyxiHVCVWFsc9Gcogo1Npkq55y
JyDuRpmufCJSKUg5W2jWCRFWNR8eFxJR5nETmbtXO8FqTOLCx1IiCqtLuenM
7ATX0y9OeDYQ0beMvf+E/nVCuktMVFkjEQkHfPH/xtkFI8mlnvzNRJQvNumo
KtIFwytNfk9biKjNx3DXWrUuUGg5+qW2g4iUNwx/euPfBQHj3Mx0Kv4eWpim
9/ku+LjJvLOBRkRf3gsVSER0wS85g+R/A0Tk5Kp75+btLogdlXpxaIiIbryK
P368sAtKN8a7j4wREdlOY2ndeBfwKtFiChlEpChX51c11wWDh5LGKpg4fksu
tKC/XSBvzmX0g0VE/DnRdeR13SAWq9Lbv0BE2qzu5GL5bnD6dG96egnnNzlS
w+2/biBOOcm85SQhk97GM6XUbtjDr33yhzAJKbia1puNdoNjdQfx4UYSEqB9
ku+Z6QYHz6HTJ0VIqH343cAyWw80aFlfXthEQl6MVCdjyR5o0z/EuW4bCd3i
8yI0Hu0BeoCEUI8ECfnHU7Jd3Xtgf6Vnb7wkCdkLHWWfPdUD1ZwWPEiKhCS2
WJWLXOiBLHXei+k7SKhIWl3VKbkH/JvlRExkSKhVm02C3toDdscPpJPkSaik
PPRicE8P1HRd2UbFToe5Dp6BHjAtXNlwQYGEPE0G7yrM9YBX4sS5HEUSWrCp
5/UX6oXMCkWj0T0kJO6VzFy07AXl9zbZe1RJiG1MyO6WfS+8X/qS9hKb7htb
tP1YL2SrX92jokZChQHhp5FPL8jJK4vvUSchdNmDci2mF4LNo09s1iQhjySV
n4LfeqG5tXt3vjYJubpSUiQbeqFwt7PKeh0SclZI9FJuw8+LzNh6FvtQ5dwa
C1ovJMadjtfQJSGjwWKdGyu9ULlgov1Kj4SkNfXz/+3vg4VHHb2BgOPDNhnE
D31gtWLxoBZbtC7DSIzQB+w9z0hiiISEXNj6tQ71wfZUvYcV2GzXP28K9O+D
kiZDcZYhCfW3mV4dze+DGN+Qlf3GJNSVuWjz52UftGWfmryI3e79TGLt+z54
b/NuohK74R9/mWxNHxBTgnYeMCGhStmmaVdKH/z3rihJn0BCZVMRlX7DfVB4
y0ftAnZx6b5b4VN9AEON4++wX1je3Z32rw/GiGUfFIgklBbk4PJ7Wz8st3gx
eUkklAw8SoNS/SDLVvAYsO/xlvxh7O6HcG7G+UDsW+nb7gtr9oNOVEduN/bF
mp4flrb9wCHoo5ZlSkJOm9y1v8T0g7/ljM8acxKac7YbOJ3YDyM0y9a92Lee
GN3emNIPolEHnY9iV6rJ0N2e9sPKPtv2l9g7bekJ7LX98HqfX4GVBQmVP2zT
fdrYDxOS+60DsR0oNYM2v/uhtLNU5iF2tH+uXtZgP+weZD9Fxg7+phaYyUGG
lbMaSSctSejA2DPTAG4yFL31/hOFvWGDjCRxHRkqNW+mZ2PnO4jUTQqR4aTR
s6I+7G46Q9JgBxkWn0ToWljh+7y+TCFZMrx8Kth/EjtwD72OLkcG65rulnBs
gaC2oDgVMrjr25cWYiPO4h89QIa9ubYvuK1JiF9O+VGRERkebNEQEcPuNM8N
jiKSoSy6pkcZ+9zdpB1K1mT4YqGRegjb4L3A/IotGXY807rvic3Xfb2+xYEM
kbtU/4RgP5EOCbnoQgb9Pgeeh9j+hCkLazcy3I999i4fW//Uf9I7PclwEUzb
32O3v3L8WedLBpRYFtyKzWuotVP0EhnGPov58djg+x5FCxMRZHCLcRoVxn4c
LddQHYXnE/d8eDu2XtPWUO9bZFA/sxKsir2WkWCln0AGqrI+nx522xZeGaF7
ePwKj6IJ9pnjfxpKUsng7fR9kwO2ztWzT25lrr6Pk34MmydvJNQ1mwz7+R1J
J7Fb605Yq+eR4b073dAHO2uyU2btMzJw7mpvOYftI2y72F1IhtABG7ZQbG3N
usaXr8lw/mz493DsX5fKLjiWkYG/MVXnJraCidXa0QoypP/kSYnDjuSn3g+r
JkMQza3gDnZXS9DODTVkOKga6HsfWy2V99WjWjLICXLSk7FvuaUbqNeTIUqk
RzgNe0B+X/3XRjL83vVtIWM1HjNfjhxpIcO++DvJj7DvlRweGmsngyoHLyMb
e/zyeGB4Fxk+VCzx52IbEyM4hPrw+rqrT8/DThMQScimkGENZ0b4U2xmW952
TTpeX46zXQXYVum6z2qHyZBWKrj0DDvXo1Hr6DgZiI7NtOfYy4ruXyem8Pyu
Ctx7ge0wx7KLmCPDQt8TgULswrIYivA8GX5GBdivmjtSwi9nkQwZyPnUql1M
Xy/tX8br/4eR9arfCxJi6tgpELJZmHvVgh2dW45xUWA283XC6vO9Mn1zptZS
4B1FZGb1/VWe7GqR/BTgaleSX/VW5ftVIoIUSHwyp7P6vf5MOau8jRSwiPaS
W51PbXl5t/YWCsxvSJzLx5aKsvGuF6WA89LljNV4hJoPsFwkKKDraKW4Gq9f
wuejZnZQoOqRYtqT1Xx28QlHyVJg3U2Lucer+fNS2/NUiQIaXLq2mdiqKt/K
dFUoYNPKsE/Hjpl3IjWoUWB917B2Kja1crLNdT8FljhUl1bzq3s90n1OhwIV
loyUpNX8WW6euWZAgcUFJ5F7q/kTKQjfeoACYaYPPFfXS1p280N9UwrM/DkT
H4vNOHVyd5MFBT5uiXKNxrZQ/fPWzYYCAl4nOK9h/6uSarrhSAH+v3Fll1bz
E/32mOhRCjQt+39fXb+F1qSx5y4UoJoYZQet5qPPj/vXSQooNs0Xra7/4pw1
9zy8KWB9OoLyH7aA74Md8z4U4C4xbnfD/vi3Uk88kAJmcRSuw6vx/2xbVxhC
AYOGM/q2q/GPGXQ0vEgBYZ5Hqhar8d4mEOAZSQFTxzPWgH2e/IjtzzUKvGz5
HqCF3ZynER97kwK+DDPrfav7RfPY06IE/H0VFrLS2DS75/2LGRQ4Jh4oxYa9
rqu/u/MxBUxCNnCz8P9ExXVjR0kuBbSU/lwfww73udAUXIjz0/fStg07Z/ZF
vf1rCkyzhT38jl1/nlKrXkwB6eJ7ARXYotdI1bMVeL7FxZ3Z2IZ8YRXN1RRg
7ag9kYTtdedlaVENBSJtNYOisYvTN78+85MCvRHGmqexbYsHHo/2UEB+vcSo
Anao3tbM72QKVJ7jTNqGnfXJPDV/gAKe9UkVPNiTDa/veo5TQD15PoSK/9c3
hyKiqH8pcEXW1f0OdpHv24jqFQqcb3YovojdPjcUlrWGCjn24UGr/38ZNusg
Fz4qXEkoUtmPXbV1u2eXKBVabvzzaMHnx1CGjVupBBXoic20EmwB2SiXZGkq
BGfe/JiO7bxvzMFBgQpz3XzXV8+nBdNS4i9tKiS/IohO4PNLsmnc6JU+FS4L
yZj/xCY4SKEEQyqsfVf9/Tn2PbcbWlamVFA1ep/vjb33or183WEqtE39K+nC
56cD+03Zp85U+PPJfOc77LAb5TuiXakgFHe0Ph677u5OUYIXFQI8LFoA2/P5
zLpPIVSwL3aNSDYjoYzeuPHSJCroRIeWSOPzXPjDm97rKVTQNe/YPoPP+2vJ
nQ12GVRw+xb0vBLbx0721UQOFV42XzJwxNb9Xh604x0VvmnbcoXj+qLj7dhy
dAsVTt3mS8vC9YpFotC0/W8qLHMbfXXF/ui3nyLdTQXfvH3Lkti5Clc/l1Op
UEZyS0jF9U5glmj09AwVus+cFrhhhOupW6ZChwVp8LnPi7kH109R3n4csiI0
0DhzYm8frq8WCPfnZrbQYOe3paNx2GR2SlusJA2GL3teH8b1WWHI+ZSPyjS4
sUth5o4BCZm55+3cbUmDJpmNT1/ieq8S/RRh2NDgguGosRX2Pok5rupDNHCb
+1wyhuvDrZ0Gw07ONHAgDe3YiT1k1f48/jQNtidSflzVwt+jw6XJukkDinvb
Bj4NErr6gdB/JY4Gj86PGmfg+jRSLzp6/R0aGO0vO6GCfcWAr1smmQZfHEmW
B3E9G35AKMIulwZvWKe+XduH96vZ9rqiTzTgzTq9swTXxyE/XAL0vtLAeK/V
fm3sYIss8drvNLD+JixRqkRCQVY7/fqbaBBUuu34O1xfn7OVFxHop0HOomhs
Jq7HfZ00XE7/pYF7zm4fbVmcv+5gnvllGoxzm4nk4Xrex7mkKJJjABSWey5s
xD7lorsmhXcA7u0ghg9L4/3oZphfu2UAkrroOldxf+B2ynJWVn0Awtziz10Q
w+vvwsnrZJ8BaB2O2/OfIN4vZYSMEv8BiK+ag5QNJDT7Z3dxQuAAlCpWPP0h
QELxoaN0FDYAv1gOl+TXk9DX834mj2IHIMq15U8TLwlphIRyuhUMgFdM0dxP
DhISCYyLpA0NwIpks1/QHBFR35xJ+TA2AK9+brrqP0tERXPWr+9ODcAW3bWV
3jNEZBEgTDWaH4C6frUchykiijr3wPAJNx2y464KiuL+bc7/EdtJWTpEmr0W
J+B+8Jfvu/BBNzpsGnYmyOP+Uunga6tLnnR4oUVav/STiK6pv5QQOUWHhfRm
oZ/1uH//m19peJYOphqnG73rcP8anbacdpkOhwtSluNqiMgn+2q4XRodNG6e
NIj4QETcnQfDq9rocMVjfrozl4hcy62sHDvpINvTOuKP++PSTHOJyR46RG2X
N+DG/bOPp0ml2AAd7h/SmVd8REQtc1rLwbN0SLQzTXdPxf2+gFT4ng2DoJI2
Z3n1Nu4njScvpZAG4bmvjtCVYNyfhvcekLQYhGV4VToaSETXS+t5nlgPwtde
+SrbADxf5Wd3XjgMgtT5LPp2f/y+bV45VR6DECJkEZ3lTUQZk5T6wYhBKMu0
6HFwJiKOh21iaqWDUHpB2v0aIqIfE+WlP+SHIK865lLnGiJCQ+YTaXuGoNgw
7fpzdiJ6S+6SOrNvCDz8zeMvrRBQRsvCDUHtITDYEJe87S8BnStVd7AnDUHT
M8lE7VkCPg+ez/Z5DkFhIO/IVjIBeYunKc5mD0FjQ2ynXRkB8ZhfTN8qMQxn
xR2633gR0Nph2Zv5O4Zhx4NFAzVP7GtNgVqyw3DLzKm3yJ2A1n2UtTisNAy1
0cfrcl0IiF+tafGBzjDI5ut6XjpEQEJisoe3OA6Da/nLF21AQGJjDcKbE4Yh
YN5uRHUTAe2NlY7eyDEC5esdd+SWmSD2y6WiCn9GwPz99InsPmO0bDI4UjE2
Clm/ynnODBuhoam/H1d+joH+Y8tk5sgBdMGS3eDY53GgRwRI8lYaooW4qU9e
+ROQxrZ9Ys1dhB49CoiaiZ4Ehwcw6PTRADG8hibuh01Bewp/67H1eughr/Re
xt5pOL9hQq8gTBvFaZF0FZ9NQ0NoqUJBkSaa76CaaUvMgA9PitDdbeqI5Va7
wHV7BmQ+j585k74P1X3NueDKOwvJRn8Ve3mVkUja/Mqdi7OgRz3LZRgoj9TM
DY8cnJ8FfyFUY9Atg4ZpbTaN/nMgZixXZ1shhYQn+8xlqHP4/xWt6JghioR/
9YvyHGPAt10eWbtkRZBXnjzHLxcGGMX3Co0JiKDKsICRNFcG7C1K+V2xsBF5
7+YpUfVgQCS/8fH4+o2oKkzZ3uU0A1JOxRzpDtyI/HZfuv0ulAG3AiLeydQK
o/owUU6PJAbobZB6eDZUCN3YbT9R1ciA6ZXW5dj1AihKbmtjZDMDfh2veDQ9
vB5FyHcXGbcwQPNPpKf/l/XovOKJwNp2BgQ3j5lVX1yPvPb6/m3sZYDC+iHV
/DF+ZLb/Gm//GAPCy/fwRzfxIX7iO9l/PEx4rOzjfrGQF60lnef5yMuEOnG1
YoM4XsRpqjsSwceE6JKcenEfXvTPrPo55wYmiGuu7JdX4EWTVj/V+DczQWu7
XVFk3lrU6EA3FJNhgsInC3eNPB6U6LnJRRsx4UHwidKrZVyIRZAL2XGACWJ8
fEKCKVzoyG7dBF5jJuTl5AV8COVCUsOunzqJTPjp95+ZnzYXKvR+vuuCNROk
I9e3mpVxojofo6kyFybkEw0lG6rXII6AsxF6l5hQcNKsaGKIHXnaRT2UucyE
uCD/e4d+sKPvag9e819hAue9c6JdhewogVE+0BPFhPDmUxyGwexIInit6aVb
TCijMznCudmRTmimUGUqE+LZDwu9UWJD5y7/fAxlTBje/P4pu9Q/SNs3uYWn
nAnjSy9jq2aWoIYmENdQwYRDz4oS335egq0km5Bj1Uy43tm9Rc9rCSoEW8wv
1jLBUlWb8P3NX1j7uINR3M6EXVrM4/2HFiH9C42gPMeEWW/9s09K5+FrMGc5
k8EEPVrQt4w78zAtJ7uvgsWEZKkbR794z8OBOE8xi0UmeEXNW98RnYdh+5Ep
b3YWFNQcp6mGs0B1aDI5ZwMLLJOO0B5YMqGWd3FUXIkF3Bdbji7wzwH/b+fD
25RZsFn82GvnwVmwfvKxZpMKC37YOOyZ/zgL7QbXsgTUWWA3fTKqIWAW6AGC
Dmx6LCBQKabcfTPA0bermmbOggBGken98mnQe233oOA0Cxol7j/qNJqAiMvF
nHm+LFCKCd/OzzkBny22ncv2Y4G/w8/RvC/jYDbUZ5EWwAIb73UZosRxOCJ+
iiP+Igt2Fy3co9uMQfD1CN+zsSzwrqT++B4yAmV2tC7fOBZImKfK+BqMwD8p
AunUbRbY5sjFBnCNQNQHvp3ud1m43q6UzL03DHenkzoOpbLgoIiwSOT7IWiv
+GNyMJ0FWR3bwrdfGQLRWOc3lpkscK94o7PBfAgey0rHE7JZQNe6oT/QPwiD
s1F/D+Tg59urRZQWDIJ81ZAX5LHg/aWON1+CBsEnzqxd9ykLjnNe0B9Cg1Dk
9MJI6xkLbodN0+P4BuF/52dSkg==
          "]]},
        Annotation[#, "Charting`Private`Tag#1"]& ]}, {}},
     {"WolframDynamicHighlight", <|
      "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>}], 
    DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
      Slot["HighlightElements"], 
      Slot["LayoutOptions"], 
      Slot["Meta"], 
      Charting`HighlightActionFunction["DynamicHighlight", {{{{}, {}, 
          Annotation[{
            Directive[
             Opacity[1.], 
             RGBColor[0.368417, 0.506779, 0.709798], 
             AbsoluteThickness[2]], 
            Line[CompressedData["
1:eJwV13k8VF8UAHBkSSSkDSFRtiRb9nOFmbGLUJKE/CiibClJUolIKslesqSS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             "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
       "HighlightElements" -> <|
         "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
        "LayoutOptions" -> <|
         "PlotRange" -> {{0.0040546000061275735`, 1.4168017335853793`}, {0., 
           48.63032273773682}}, "Frame" -> {{True, True}, {True, True}}, 
          "AxesOrigin" -> {0.535599, 0.68891}, 
          "ImageSize" -> {400, 400/GoldenRatio}, "Axes" -> {True, True}, 
          "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
          "DefaultStyle" -> {
            Directive[
             Opacity[1.], 
             RGBColor[0.368417, 0.506779, 0.709798], 
             AbsoluteThickness[2]]}, 
          "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
              Identity[
               Part[#, 1]], 
              Identity[
               Part[#, 2]]}& ), 
            "ScalingFunctions" -> {{Identity, Identity}, {
              Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>,
         "Meta" -> <|
         "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
          Plot, "GroupHighlight" -> False|>|>]]& )[<|
      "HighlightElements" -> <|
        "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
       "LayoutOptions" -> <|
        "PlotRange" -> {{0.0040546000061275735`, 1.4168017335853793`}, {0., 
          48.63032273773682}}, "Frame" -> {{True, True}, {True, True}}, 
         "AxesOrigin" -> {0.535599, 0.68891}, 
         "ImageSize" -> {400, 400/GoldenRatio}, "Axes" -> {True, True}, 
         "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
         "DefaultStyle" -> {
           Directive[
            Opacity[1.], 
            RGBColor[0.368417, 0.506779, 0.709798], 
            AbsoluteThickness[2]]}, 
         "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
             Identity[
              Part[#, 1]], 
             Identity[
              Part[#, 2]]}& ), 
           "ScalingFunctions" -> {{Identity, Identity}, {
             Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>, 
       "Meta" -> <|
        "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
         Plot, "GroupHighlight" -> False|>|>],
     ImageSizeCache->{{4.503599627370496*^15, -4.503599627370496*^15}, {
      4.503599627370496*^15, -4.503599627370496*^15}}]},
   Annotation[{{{{}, {}, 
       Annotation[{
         Directive[
          Opacity[1.], 
          RGBColor[0.368417, 0.506779, 0.709798], 
          AbsoluteThickness[2]], 
         Line[CompressedData["
1:eJwV13k8VF8UAHBkSSSkDSFRtiRb9nOFmbGLUJKE/CiibClJUolIKslesqSS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          "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
    "HighlightElements" -> <|
      "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
     "LayoutOptions" -> <|
      "PlotRange" -> {{0.0040546000061275735`, 1.4168017335853793`}, {0., 
        48.63032273773682}}, "Frame" -> {{True, True}, {True, True}}, 
       "AxesOrigin" -> {0.535599, 0.68891}, 
       "ImageSize" -> {400, 400/GoldenRatio}, "Axes" -> {True, True}, 
       "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), "DefaultStyle" -> {
         Directive[
          Opacity[1.], 
          RGBColor[0.368417, 0.506779, 0.709798], 
          AbsoluteThickness[2]]}, 
       "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
           Identity[
            Part[#, 1]], 
           Identity[
            Part[#, 2]]}& ), 
         "ScalingFunctions" -> {{Identity, Identity}, {Identity, Identity}}|>,
        "Primitives" -> {}, "GCFlag" -> False|>, 
     "Meta" -> <|
      "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
       Plot, "GroupHighlight" -> False|>|>, "DynamicHighlight"]],
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0.535599, 0.68891},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{
     FormBox[
      TagBox[
       TemplateBox[{"P", "\"bar\"", "bars", "\"Bars\""}, "QuantityTF", 
        SyntaxForm -> Mod], HoldForm], TraditionalForm], None}, {
     FormBox[
      TagBox[
       TemplateBox[{
         TagBox[
          TagBox["\[Rho]", HoldForm], HoldForm], 
         RowBox[{"\"g\"", "\[InvisibleSpace]", "\"/\"", "\[InvisibleSpace]", 
           SuperscriptBox["\"cm\"", "3"]}], "grams per centimeter cubed", 
         FractionBox["\"Grams\"", 
          SuperscriptBox["\"Centimeters\"", "3"]]}, "QuantityTF", SyntaxForm -> 
        Mod], HoldForm], TraditionalForm], None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  ImageSize->400,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0.0040546000061275735`, 1.4168017335853793`}, {0., 
   48.63032273773682}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellLabel->"Out[4]=",
 CellID->391408018,ExpressionUUID->"d6063b81-16f6-4099-bf0e-a1981978e8f1"]
}, Open  ]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"}, 
  Closed]]]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "PrimaryExamplesSection"}, 
  Closed]]]],

Cell[BoxData[GridBox[{
   {
    DynamicBox[FEPrivate`ImportImage[
      FrontEnd`FileName[{"Documentation", "FooterIcons"}, 
       "RelatedFunction.png"]],
     ImageSizeCache->{50., {27., 33.}}], GridBox[{
      {
       StyleBox[
        RowBox[{"See", " ", "Also"}], "SeeAlsoSection"]},
      {Cell[TextData[{
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["ptr"]], "paclet:NewEoSArgon/ref/ptr", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "729ce9dd-2cde-4274-b3a4-e6e807ea8908"],
        "\[NonBreakingSpace]",
        StyleBox[
        "\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
         "InlineSeparator"],
        " ",
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["pc"]], "paclet:NewEoSArgon/ref/pc", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "766185e8-7b6e-4a90-b287-195f3766b59d"],
        "\[NonBreakingSpace]",
        StyleBox[
        "\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
         "InlineSeparator"],
        " ",
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["ttr"]], "paclet:NewEoSArgon/ref/ttr", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "c79558f0-f4a5-4b54-af99-b2c5e384d90c"],
        "\[NonBreakingSpace]",
        StyleBox[
        "\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
         "InlineSeparator"],
        " ",
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["tc"]], "paclet:NewEoSArgon/ref/tc", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "f24c2035-187e-4ceb-ae6b-87237d619213"],
        "\[NonBreakingSpace]",
        StyleBox[
        "\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
         "InlineSeparator"],
        " ",
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["rhotrgaz"]], "paclet:NewEoSArgon/ref/rhotrgaz", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "e51e2b7d-a22a-4cb5-98d2-e27ca9f52448"],
        "\[NonBreakingSpace]",
        StyleBox[
        "\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
         "InlineSeparator"],
        " ",
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["rhotrliq"]], "paclet:NewEoSArgon/ref/rhotrliq", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "52a0ad96-a99f-4e98-a4dc-a5a52ea91468"]
       }], "SeeAlso",ExpressionUUID->"ea9d953f-a178-44bb-b02a-0a46a6d8e13a"]}
     }]}
  }]], "SeeAlsoSection",ExpressionUUID->"c2a8a869-3105-4386-8759-\
4d3ba4535a58"],

Cell[BoxData[GridBox[{
   {
    DynamicBox[FEPrivate`ImportImage[
      FrontEnd`FileName[{"Documentation", "FooterIcons"}, "RelatedGuide.png"]],
     ImageSizeCache->{50., {27., 33.}}], GridBox[{
      {
       StyleBox[
        RowBox[{"Related", " ", "Guides"}], "MoreAboutSection"]},
      {
       RowBox[{"\[FilledVerySmallSquare]", Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["NewEoSArgon Package"]], 
           "paclet:NewEoSArgon/guide/NewEoSArgon"},
          "RefLinkPlain",
          BaseStyle->{"MoreAbout"}]], "MoreAbout",ExpressionUUID->
         "f1ed4f24-fb3b-4e42-ab87-90390fc54409"]}]}
     }]}
  }]], "MoreAboutSection",ExpressionUUID->"c565bb7a-469a-4e35-b54b-\
75dc44b09c26"],

Cell[BoxData[GridBox[{
   {
    TemplateBox[{29},
     "Spacer1"], GridBox[{
      {
       RowBox[{
        TemplateBox[{17},
         "Spacer1"], 
        StyleBox[
         RowBox[{"Related", " ", "Links"}], "RelatedLinksSection"]}]},
      {Cell[BoxData[Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData[
             RowBox[{
               RowBox[{"Units", " ", "&"}], " ", "Quantities"}]]], 
           "paclet:guide/Units"},
          "RefLinkPlain",
          BaseStyle->{"RelatedLinks"}]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "6f6fd900-98e2-40ec-8b31-e824eda37716"]], "RelatedLinks",
        ExpressionUUID->"c6a8d480-9769-4c5b-8900-d5a276d05057"]},
      {Cell[TextData[Cell[BoxData[
        RowBox[{
         TemplateBox[{16},
          "Spacer1"], "\[FilledVerySmallSquare]", Cell[BoxData[
          TemplateBox[{
            Cell[
             TextData[
              Cell[
               TextData[{
                 Cell[
                  BoxData[
                   TemplateBox[{2}, "Spacer1"]]], 
                 "Webbook de chimie NIST"}]]]], 
            "http://webbook.nist.gov/chemistry/fluid/"},
           "WebLink",
           BaseStyle->{"RelatedLinks"}]],ExpressionUUID->
          "d44448d4-022c-46e4-b20b-7c775d47187e"]}]],ExpressionUUID->
        "ca4fa32f-9b70-47af-bbc4-9d1f3563cae1"]], "RelatedLinks",
        ExpressionUUID->"7f04e68c-9111-4b3d-a146-8092d02a0390"]}
     }]}
  }]], "RelatedLinksSection",ExpressionUUID->"b1e22cfd-5058-4555-b3d0-\
2c288e146ae7"],

Cell[" ", "FooterCell",ExpressionUUID->"1aac9e18-b9a9-4112-b319-6f97f4b9c42e"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{900, 835.8},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"PRhoSatNIST",
TaggingRules->{
 "ModificationHighlight" -> False, "ColorType" -> "", "LinkTrails" -> "", 
  "HasOptions" -> True, "ExampleCounter" -> 1, 
  "Openers" -> {
   "PrimaryExamplesSection" -> Open, "ExampleSection" -> {"0" -> Open}, 
    "NotesSection" -> Closed}, "NewStyles" -> True, 
  "CitationPopupData" -> $Failed, "ShowCitation" -> False, "RootCaptions" -> 
  "", "Metadata" -> {
   "built" -> "{2023, 11, 30, 13, 55, 49.3240232}", 
    "history" -> {"XX", "", "", ""}, "context" -> "NewEoSArgon`", 
    "keywords" -> {}, "specialkeywords" -> {}, 
    "tutorialcollectionlinks" -> {}, "index" -> True, "label" -> 
    "New Eo S Argon Package Symbol", "language" -> "en", "paclet" -> 
    "NewEoSArgon Package", "status" -> "None", "summary" -> 
    "PRhoSatNIST[\\[Rho]] \\[Congruent] P\\[Sigma] (bar) Pression sur la \
courbe de saturation donn\[EAcute]e par NIST en fonction de \\[Rho] (g/cm^3) \
[Fitting function of the saturated pressure versus \\[Rho] (g/cm^3) from the \
data of NIST]", "synonyms" -> {}, "tabletags" -> {}, "title" -> "PRhoSatNIST",
     "titlemodifier" -> "", "metadescription" -> "", "windowtitle" -> 
    "PRhoSatNIST", "type" -> "Symbol", "uri" -> 
    "NewEoSArgon/ref/PRhoSatNIST"}},
CellContext->"Global`",
FrontEndVersion->"13.3 pour Microsoft Windows (64-bit) (July 24, 2023)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "13.3 pour Microsoft Windows (64-bit) (July 24, 2023)", 
  StyleDefinitions -> "Default.nb"],
ExpressionUUID->"a864b6e1-6c96-4e2b-afbb-282e098f881d"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[11960, 318, 1420, 37, 35, "PrimaryExamplesSection",ExpressionUUID->"7d23c30a-c875-49e9-81df-360f162c760d",
   CellTags->"PrimaryExamplesSection",
   CellID->553733116]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 57461, 1266}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[583, 21, 5628, 134, 56, "AnchorBarGrid",ExpressionUUID->"caee693f-2d81-4eee-9560-2a78306c163c",
 CellID->1],
Cell[6214, 157, 94, 0, 23, "ContextNameCell",ExpressionUUID->"8d4b4e05-7ab3-4743-9fb8-962c72af96a0"],
Cell[CellGroupData[{
Cell[6333, 161, 554, 14, 56, "ObjectNameGrid",ExpressionUUID->"41e2212b-56b0-4655-82eb-55429a75643d"],
Cell[6890, 177, 1222, 28, 146, "Usage",ExpressionUUID->"2c085a28-6040-4106-b932-1bf9e3b13796"]
}, Open  ]],
Cell[CellGroupData[{
Cell[8149, 210, 1919, 48, 37, "NotesSection",ExpressionUUID->"35fc0fb8-bfa8-4389-86e1-5958560054b2",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->762116176],
Cell[10071, 260, 790, 22, 38, "Notes",ExpressionUUID->"97a7c37c-cefa-419c-a445-02a0dd287bf1",
 CellID->1067943069],
Cell[10864, 284, 186, 4, 36, "Notes",ExpressionUUID->"559aebb0-1aa9-4b54-952a-6dd8073e102d",
 CellID->224665577],
Cell[11053, 290, 780, 22, 38, "Notes",ExpressionUUID->"2bead130-ad33-4ce2-86a3-31d288175f24",
 CellID->620823206]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "NotesSection"}, Closed]]]],
Cell[CellGroupData[{
Cell[11960, 318, 1420, 37, 35, "PrimaryExamplesSection",ExpressionUUID->"7d23c30a-c875-49e9-81df-360f162c760d",
 CellTags->"PrimaryExamplesSection",
 CellID->553733116],
Cell[CellGroupData[{
Cell[13405, 359, 1397, 36, 30, "ExampleSection",ExpressionUUID->"a4a47786-5cbe-4369-80d2-e375cc075780",
 CellID->18125224],
Cell[14805, 397, 174, 3, 26, "Input",ExpressionUUID->"600a021e-3806-43e1-b1b9-28d8ef8921eb",
 CellID->87419684],
Cell[14982, 402, 131, 1, 38, "ExampleText",ExpressionUUID->"58212621-1d89-42d2-8c3a-ebc639f4df42",
 CellID->285078790],
Cell[CellGroupData[{
Cell[15138, 407, 245, 6, 26, "Input",ExpressionUUID->"65c9ee36-69da-4d0f-96da-604c573aeac2",
 CellID->231987987],
Cell[15386, 415, 195, 4, 40, "Output",ExpressionUUID->"5207a9f9-3fb2-4d7f-91ee-a4d184ed474d",
 CellID->165633037]
}, Open  ]],
Cell[CellGroupData[{
Cell[15618, 424, 605, 16, 26, "Input",ExpressionUUID->"977cbd54-699e-470a-b537-43da5071ae8f",
 CellID->52306574],
Cell[16226, 442, 223, 5, 39, "Output",ExpressionUUID->"dd447a99-9e11-4b70-8d6b-60d34ddeafdf",
 CellID->85172826]
}, Open  ]],
Cell[16464, 450, 151, 1, 38, "ExampleText",ExpressionUUID->"57a35199-0be8-443d-b4a4-7aed3530419b",
 CellID->886239600],
Cell[CellGroupData[{
Cell[16640, 455, 768, 19, 42, "Input",ExpressionUUID->"7921b9fb-ec21-4db2-8326-213af4764d02",
 CellID->21488140],
Cell[17411, 476, 31989, 574, 283, "Output",ExpressionUUID->"d6063b81-16f6-4099-bf0e-a1981978e8f1",
 CellID->391408018]
}, Open  ]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"}, Closed]]]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "PrimaryExamplesSection"}, Closed]]]],
Cell[49642, 1059, 3395, 92, 70, "SeeAlsoSection",ExpressionUUID->"c2a8a869-3105-4386-8759-4d3ba4535a58"],
Cell[53040, 1153, 729, 19, 70, "MoreAboutSection",ExpressionUUID->"c565bb7a-469a-4e35-b54b-75dc44b09c26"],
Cell[53772, 1174, 1568, 43, 70, "RelatedLinksSection",ExpressionUUID->"b1e22cfd-5058-4555-b3d0-2c288e146ae7"],
Cell[55343, 1219, 78, 0, 70, "FooterCell",ExpressionUUID->"1aac9e18-b9a9-4112-b319-6f97f4b9c42e"]
}
]
*)

(* End of internal cache information *)

