(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 13.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     97903,       2266]
NotebookOptionsPosition[     91466,       2136]
NotebookOutlinePosition[     93707,       2192]
CellTagsIndexPosition[     93621,       2187]
WindowTitle->PTSat
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[GridBox[{
   {GridBox[{
      {
       ItemBox[Cell[BoxData[
         RowBox[{
          TemplateBox[{12},
           "Spacer1"], Cell["NEW EO S ARGON PACKAGE SYMBOL", "PacletNameCell",
           TextAlignment->Center,ExpressionUUID->
           "0712016b-8d2f-49a9-baf1-aeba7e232c4b"], 
          TemplateBox[{8},
           "Spacer1"]}]],
         TextAlignment->Center,ExpressionUUID->
         "7d114c7d-f435-49b6-ae68-c5e0809a46c8"],
        Background->RGBColor[0.490196, 0.576471, 0.690196],
        ItemSize->Full], ""}
     },
     GridBoxAlignment->{"Rows" -> {{Center}}},
     GridBoxItemSize->{"Columns" -> {Full, 
         Scaled[0.02]}, "Rows" -> {{2.5}}}], Cell[TextData[{
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "See Also",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "9ca7d4ba-d6fc-44a0-bba7-8f6d12d7f258"]
         }],ExpressionUUID->"abb38b48-b274-4ade-b3ef-b1d3c53fa612"],
         StripOnInput->False],{
        "\"ptrNv\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/ptrNv"], 
         "\"PTSatNIST\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/PTSatNIST"], 
         "\"tcNv\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/tcNv"], "\"ttr\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/ttr"], 
         "\"RhoSatVapFromT\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/RhoSatVapFromT"], 
         "\"RhoSatLiqFromT\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/RhoSatLiqFromT"]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"SeeAlso"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "6ac29d8b-1e97-46bd-9f07-0467b735e833"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "Related Guides",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "bbac063a-30c1-43ae-8ac9-ca79908b35da"]
         }],ExpressionUUID->"a96d4bcd-7996-4aa7-9bad-783e5d9bf5ad"],
         StripOnInput->False],{
        "\"NewEoSArgon Package\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/guide/NewEoSArgon"]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"MoreAbout"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "45369cd2-b185-44ed-b487-6ea1141c9482"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "URL",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "e8c41459-1693-4184-aa18-b0a80b4e2e37"]
         }],ExpressionUUID->"c6656e08-e0b8-42fd-90ea-b35055b63012"],
         StripOnInput->False],{
        "\"NewEoSArgon/ref/PTSat\"" :> None, 
         "\"Copy Wolfram Documentation Center URL\"" :> 
         Module[{DocumentationSearch`Private`nb$}, 
           DocumentationSearch`Private`nb$ = 
            NotebookPut[
             Notebook[{Cell["NewEoSArgon/ref/PTSat"]}, Visible -> False]]; 
           SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
           FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
           NotebookClose[DocumentationSearch`Private`nb$]; Null], Delimiter, 
         "\"Copy web URL\"" :> 
         Module[{DocumentationSearch`Private`nb$}, 
           DocumentationSearch`Private`nb$ = 
            NotebookPut[
             Notebook[{
               Cell[BoxData[
                 MakeBoxes[
                  Hyperlink[
                   "http://reference.wolfram.com/language/NewEoSArgon/ref/\
PTSat.html"], StandardForm]], "Input", TextClipboardType -> "PlainText"]}, 
               Visible -> False]]; 
           SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
           FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
           NotebookClose[DocumentationSearch`Private`nb$]; Null], 
         "\"Go to web URL\"" :> 
         FrontEndExecute[{
           NotebookLocate[{
             URL[If[TrueQ[DocumentationBuild`Make`Private`wsmlinkQ$21600], 
                 "http://reference.wolfram.com/system-modeler/", 
                 "http://reference.wolfram.com/language/"] <> 
               "NewEoSArgon/ref/PTSat" <> ".html"], None}]}]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"URLMenu"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "8144b3bc-97cf-4ddd-96a3-b5ca250a230e"]
    }], "AnchorBar",
     CacheGraphics->False,ExpressionUUID->
     "e72a5f80-071a-4242-b4a9-375602a3c17f"]}
  }]], "AnchorBarGrid",
 CellID->1,ExpressionUUID->"14d7b472-2da3-4f83-8ac2-27395e2a0368"],

Cell["NewEoSArgon`", "ContextNameCell",ExpressionUUID->"b0525257-f0de-46c7-a1d2-7908143e3345"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     Cell[
     "PTSat", "ObjectName",ExpressionUUID->
      "b0e228b8-8d65-45c5-858e-dc0557d89824"],
     Cell[BoxData[
      TemplateBox[{8},
       "Spacer1"]],ExpressionUUID->"32822d0e-71f8-4da9-b786-5d14d0f5f637"],
     Cell[BoxData[
     ""], "ObjectNameTranslation",ExpressionUUID->
      "f178e009-7031-4fe6-a367-07421dbb37e5"]
    }],ExpressionUUID->"1e508404-6c9e-48a0-b4bf-5ede880de0dd"], 
    "\[SpanFromLeft]"}
  }]], "ObjectNameGrid",ExpressionUUID->"e614b761-2086-4dab-a957-\
6c647b77bb21"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     "PTsat[",
     StyleBox["T",
      FontSlant->"Italic"],
     "] \[Congruent] ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["P",
        FontSlant->"Italic"], "\[Sigma]"]], "InlineFormula",
      FontFamily->"Source Sans Pro",ExpressionUUID->
      "7994d703-6d97-4d8d-8b45-f7e28173277b"],
     " (MPa)\nPression sur la courbe de saturation en fonction de ",
     StyleBox["T",
      FontSlant->"Italic"],
     " (Kelvin)\n[Fitting function of the saturation pressure versus ",
     StyleBox["T",
      FontSlant->"Italic"],
     " (Kelvin)]"
    }],ExpressionUUID->"4ab738fe-137a-4f6a-bb14-a0439fa5f81f"]}
  }]], "Usage",ExpressionUUID->"ceee40ab-3e7f-459b-8f90-b8d563013100"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[Cell[TextData[{
   Cell[BoxData[
    DynamicBox[ToBoxes[
      If[
       MatchQ[
        CurrentValue[
         EvaluationNotebook[], {TaggingRules, "Openers", "NotesSection"}, 
         Closed], 
        Alternatives[Open, True]], 
       Style[
        Graphics[{
          Thickness[0.18], 
          RGBColor[0.8509803921568627, 0.396078431372549, 0], 
          Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
         PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
        0.68 Inherited], 
       Rotate[
        Style[
         Graphics[{
           Thickness[0.18], 
           RGBColor[0.8509803921568627, 0.396078431372549, 0], 
           Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
          PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
         0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
     ImageSizeCache->{
      13.600000000000001`, {0.5800000000000001, 13.020000000000001`}}]],
    ExpressionUUID->"e419fb9a-cc87-4a95-8a1d-6ec34480afb4"],
   Cell[BoxData[
    TemplateBox[{1},
     "Spacer1"]],ExpressionUUID->"5b3ec5f2-3cd8-488c-abd2-570ac4d881d3"],
   "Details and Options"
  }], "NotesFrameText",ExpressionUUID->"488bcf53-c091-45d7-bf61-8cab62953ff5"],
  Appearance->{Automatic, None, "Normal", Automatic},
  BaseStyle->None,
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"], 
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], After, CellContents]}]& ),
  Evaluator->None,
  Method->
   "Preemptive"]],ExpressionUUID->"b5435b68-7161-41c8-9641-03ed520ba20e"]], \
"NotesSection",
 WholeCellGroupOpener->True,
 CellGroupingRules->{"SectionGrouping", 50},
 CacheGraphics->False,
 CellID->5473010,ExpressionUUID->"922cdfeb-4a39-44eb-b1fe-e2dc36ed015e"],

Cell[TextData[{
 "La fonction est d\[EAcute]finie pour ",
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["ttr"]], "paclet:NewEoSArgon/ref/ttr", 
    "NewEoSArgon Package Symbol"},
   "PackageLink",
   BaseStyle->"InlineFormula"]], "InlineFormula",
  FontFamily->"Source Sans Pro",ExpressionUUID->
  "9bd7a45e-a072-4236-8417-f7d6ab602766"],
 " \[LessEqual] ",
 StyleBox["T",
  FontSlant->"Italic"],
 " \[LessEqual] ",
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["tcNv"]], "paclet:NewEoSArgon/ref/tcNv", 
    "NewEoSArgon Package Symbol"},
   "PackageLink",
   BaseStyle->"InlineFormula"]], "InlineFormula",
  FontFamily->"Source Sans Pro",ExpressionUUID->
  "8b6daa7d-fb8d-4a1b-986e-76a1f846c8e7"]
}], "Notes",
 CellID->1067943069,ExpressionUUID->"2eb93e1e-2cc0-4a91-b165-8f7b64fa27fb"],

Cell["\<\
******************************************************************************\
******\
\>", "Notes",
 CellID->224665577,ExpressionUUID->"8924c816-12f4-4f7e-acb8-3b5b9a194ecc"],

Cell[TextData[{
 "The function is defined for ",
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["ttr"]], "paclet:NewEoSArgon/ref/ttr", 
    "NewEoSArgon Package Symbol"},
   "PackageLink",
   BaseStyle->"InlineFormula"]], "InlineFormula",
  FontFamily->"Source Sans Pro",ExpressionUUID->
  "a6d49705-28bb-431c-a97b-5c60889c8de7"],
 " \[LessEqual] ",
 StyleBox["T",
  FontSlant->"Italic"],
 " \[LessEqual] ",
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["tcNv"]], "paclet:NewEoSArgon/ref/tcNv", 
    "NewEoSArgon Package Symbol"},
   "PackageLink",
   BaseStyle->"InlineFormula"]], "InlineFormula",
  FontFamily->"Source Sans Pro",ExpressionUUID->
  "687db7b0-086d-4be5-b921-4caf668a2650"]
}], "Notes",
 CellID->32133948,ExpressionUUID->"373d6433-40c6-4855-a5be-03e4f998a4c5"]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "NotesSection"}, Closed]]]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {
       TaggingRules, "Openers", "PrimaryExamplesSection"}, Open], 
      Alternatives[True, Open]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{13.600000000000001`, {5., 8.600000000000001}}]],
  ExpressionUUID->"b7e2f36d-255b-489f-89b4-4c9a913b2075"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"c6e62a27-ede1-49cd-a5a3-6d239f57293a"],
 "Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount",ExpressionUUID->
  "6371d5fc-30f7-45a2-b800-233ada9e2daf"]
}], "PrimaryExamplesSection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellTags->"PrimaryExamplesSection",
 CellID->63248241,ExpressionUUID->"9dd8841b-3c85-48d7-be4c-7238d87e9dc5"],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"},
        Closed], 
      Alternatives[Open, True]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{13.600000000000001`, {5., 8.600000000000001}}]],
  ExpressionUUID->"79ad80b2-6ce5-4731-97bb-763bfa2f67fe"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"3cb18c6f-3988-46c6-9d39-18e203838da6"],
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "3ce5c520-4117-4ee5-940d-696c2a6014ed"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellID->191111600,ExpressionUUID->"6c474bc2-9174-4a18-bcf7-55336f27ff44"],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<NewEoSArgon`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->87419684,ExpressionUUID->"30fbed1f-2d92-4307-b5cd-7331f8583bf7"],

Cell["Calculate with physical dimension", "ExampleText",
 CellID->285078790,ExpressionUUID->"4857eba6-75f4-481f-a5bc-5e87a1cf0116"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Quantity", "[", 
  RowBox[{
   RowBox[{"PTSat", "[", "ttr", "]"}], ",", "\"\<MPa\>\""}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->231987987,ExpressionUUID->"cd1ab246-e419-49d4-91de-62185f2ab870"],

Cell[BoxData[
 TemplateBox[{
  "0.06896569762291979`", "\"MPa\"", "megapascals", "\"Megapascals\""},
  "Quantity"]], "Output",
 CellLabel->"Out[2]=",
 CellID->347789595,ExpressionUUID->"3887f79a-cb3d-4fe8-96ee-f761f21545ac"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UnitConvert", "[", 
  RowBox[{
   TemplateBox[{"0.06896569762291979`"},
    "QuantityUnit",
    DisplayFunction->(TooltipBox[
      StyleBox[
       RowBox[{#, "\[InvisibleSpace]", 
         StyleBox[
          RowBox[{" ", "\"MPa\""}], "QuantityUnitTraditionalLabel"]}], 
       ShowStringCharacters -> False], "Unit: megapascals"]& ),
    InterpretationFunction->(RowBox[{"Quantity", "[", 
       RowBox[{#, ",", "\"Megapascals\""}], "]"}]& )], ",", "\"\<Bars\>\""}], 
  "]"}]], "Input",
 NumberMarks->False,
 CellLabel->"In[3]:=",
 CellID->357130942,ExpressionUUID->"12d66b17-8598-47e1-bf0e-c2d292fb3b46"],

Cell[BoxData[
 TemplateBox[{"0.689656976229198`", "\"bar\"", "bars", "\"Bars\""},
  "Quantity"]], "Output",
 CellLabel->"Out[3]=",
 CellID->305062684,ExpressionUUID->"e0a9c4ed-008f-4aa6-8a31-229236ec3646"]
}, Open  ]],

Cell["Atmospheric boiling point temperature", "ExampleText",
 CellID->184302421,ExpressionUUID->"09228c57-fc71-41f8-af88-13b33f569b33"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"NormalPressure", "=", 
   RowBox[{"N", "@", 
    RowBox[{"QuantityMagnitude", "@", 
     RowBox[{"UnitConvert", "[", 
      RowBox[{
       RowBox[{"Quantity", "[", 
        RowBox[{"1", ",", "\"\<atm\>\""}], "]"}], ",", "\"\<MPa\>\""}], 
      "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Tb", "=", 
  RowBox[{"Quantity", "[", 
   RowBox[{
    RowBox[{"x", "/.", 
     RowBox[{"FindRoot", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"PTSat", "[", "x", "]"}], "==", "NormalPressure"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "85", ",", "95"}], "}"}], ",", 
       RowBox[{"Method", "\[Rule]", "\"\<Secant\>\""}]}], "]"}]}], ",", 
    "\"\<Kelvins\>\""}], "]"}]}]}], "Input",
 CellLabel->"In[4]:=",
 CellID->223155686,ExpressionUUID->"b6d4ed72-7c2f-4203-98e6-c6681460f078"],

Cell[BoxData[
 TemplateBox[{"87.2938969493787`", "\"K\"", "kelvins", "\"Kelvins\""},
  "Quantity"]], "Output",
 CellLabel->"Out[4]=",
 CellID->207581601,ExpressionUUID->"8e0d2b06-e311-4585-ace3-45c7c02f3320"]
}, Open  ]],

Cell["\<\
Plot function versus temperature and comparison with saturated curve from NIST\
\>", "ExampleText",
 CellID->886239600,ExpressionUUID->"748a9366-eeda-4179-986f-350c3a829db3"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"10", "*", 
      RowBox[{"PTSat", "[", "T", "]"}]}], ",", 
     RowBox[{"PTSatNIST", "[", "T", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"T", ",", "ttr", ",", "tc"}], "}"}], ",", 
   RowBox[{"AxesOrigin", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"ttr", ",", "ptr"}], "}"}]}], ",", 
   RowBox[{"Frame", "->", "True"}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Quantity", "[", 
       RowBox[{"T", ",", "\"\<Kelvins\>\""}], "]"}], ",", 
      RowBox[{"Quantity", "[", 
       RowBox[{"P", ",", "\"\<bar\>\""}], "]"}]}], "}"}]}], ",", 
   RowBox[{"ImageSize", "\[Rule]", "400"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Red", ",", 
      RowBox[{"{", 
       RowBox[{"Black", ",", "Dashed"}], "}"}]}], "}"}]}], ",", 
   RowBox[{"PlotLegends", "\[Rule]", "\"\<Expressions\>\""}], ",", 
   RowBox[{"Epilog", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Red", ",", 
      RowBox[{"PointSize", "\[Rule]", "Medium"}], ",", 
      RowBox[{"Point", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"QuantityMagnitude", "@", "Tb"}], ",", 
         RowBox[{"NormalPressure", "*", "10"}]}], "}"}], "]"}], ",", 
      RowBox[{"Text", "[", 
       RowBox[{"\"\<\!\(\*SubscriptBox[\(T\), \(b\)]\)\>\"", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"QuantityMagnitude", "@", "Tb"}], ",", "4"}], "}"}]}], 
       "]"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->21488140,ExpressionUUID->"93f41b23-0347-49ef-afba-c818c83ec9bf"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[
    InterpretationBox[{
      TagBox[{{{}, {}, 
         TagBox[{
           RGBColor[1, 0, 0], 
           AbsoluteThickness[2], 
           Opacity[1.], 
           LineBox[CompressedData["
1:eJwVznsw1AkAB/BNkaQp8n60UfJID2tJj53f15b9bV2m1K7Xso/fnejonJPI
ae6QFDluV4qkRKVIHpkowxjCJpIuMZVH7OK6XNrkFd3eH9/5zuef73ytqPBD
QRo0Gs1Tnf873n+IkKp46MnQqS3WUxLS3ZWH3n3m4fjDgbU6dCVx3TExiPGF
h5zwsbafHJVE04J1atc0D28znnzdRyoJrQKqW3+Bh9GdvMUHTimJ8+8Hw2Ta
fJhekYcn/60kLsUNZGda8nGiU2TXKh8hyvLeqrJIPnZY8+y/Xh4jQrQme0uu
82H4orjd+8MHgil1SayZ4uP02NHMCbcJQuF+2cD8O28Uzl7Nu1CqIuiGa3rS
bngjzEAgbS/8QhzTfSKcmvFG5ki63YvKGWKPrcz4F74PtBLaykwC5gnakfhq
93s+mFSk/tNdRENn6yUL7cW+CKO1aO0r1YD9gfaK/kBf5BR5PpzT10TWjINu
aYUviFxtgX7CUoy23PV8rukHbQ/pKNdYB401ng2aYj8YlMc5T9NXoOKZ0fTW
+36ILXKfiDVeBYdl8+JjK/3B2l7dbT2oh+Qj2hULIf5g+9xW3Hi8GtMju5rP
1PrjFLWI8LljiE/n/9BdayyAv/Gzl5K3xqB5LzMqCxVAHhJiKFpphovsfC+v
FgH2CmZzbmZbYPVhYRRpFYC7fs0bknbTUZC8J4AZFYAxTlnkhGotavvJKEZn
ANirn6m8T1pjTHDcy9YmECcrzDUXZtdhbu6xYURMIMa6qc3RKTbIqmfqPu0K
hGPwUdmfPFt43Hr62NJWiGZFOn2JiT1OVcSX/54ghFnCpTOExUbkDAqS3N4I
4XDwVb2D8ya0MUUWI1tEcIpzoiaJLUgq/k1xM0WEBSO/E/ptW3GYI48I7Beh
MsNm28GPTkjUsIhkmorhWvvtupelM/JVkmY2Rwwvd8br5Egm5Cd2/br/ZzHy
Ctw9+xpcUJVqI++7IoZvsFcXk7UNxYyCmLBWMRZMnP6tu+eGzFDn3PWfxLD0
t1O0OuwA27XLN4gugbnvUWeznp2YkWpG5++VoIk+8z0Vy0JUPLn5SLQEaac9
WHGHCQwvyvXjF0qgsaZGJMwFAg2SlESHBOP5nGr+WXfkVMfpVs5JUFpoGmAn
Y2NwXDvTagOFINOBs6su7ob5g1vpDw9QeGfU1Zp1bQ9M9fjr38RRmHLpOCtt
94DVfJbZzE0KypbxK7UqDpgDdTZVtyjY7T/XOT/NAadRuTWiiELJUJ8tFjgI
PedKjt2mED7H4LZqk6gy7I7sLaHQ/HndD0pLEns3G7bXVFD41m9rLOCSiBDJ
fouto3BnZd9VxzwSp9mPUlzr1f+GXyOzgESWzdCFT2pbyZrWzxeRePSeUfJj
A4Wq+FF5VyUJzZiuHv8mCtb2W+rS5CSyM/QYO59QGI8Xd7AnSZREbmdNqZ2q
kxFcP0uizlvCrWyjMGyTxmfRuBiyKBdubKdw/3NvEGs5F5tuH0w176TQvaK+
w9OKC5yPyXql9q4lqqCXG7g4FH4tX/acQqMsPkDoyEW0y8cHy1+o90K7+ce3
cZFiYtLYonZMtlv4IhYXuXNER+JfFELvCqbS2VyU9gX3Ei8pFDFiFHQuFw0N
6cNzai9VOLmVe3LxH66FMDY=
            "]]}, Annotation[#, "Charting`Private`Tag#1"]& ], 
         TagBox[{
           GrayLevel[0], 
           AbsoluteThickness[2], 
           Opacity[1.], 
           Dashing[{Small, Small}], 
           LineBox[CompressedData["
1:eJwVzns0lAkABfCJlJY2s0Ue0zIikSKGoux3Cd+0ckqMxzBm5uuITa0kjzy2
RdbxqHbRVKiTRx7lUciQXhMRRUyt6BQJo1alpTwSdvaPe+75nXP/uEwqZG+A
Ao1Gc5Xn/47nDhIZEx4oiQmxPqkiIzJ2VO9989kDk076R6c0ZUS+aWKAxaQH
9IcGJIHrZETTvH6adNoD0bXDIq69jFhSQHX/MO+Bil8yglIiZUT66MDBTGUO
bt5XFy8flhHnYl+fz1rDQclCaICkaYS4dvHVhIjkwO/KR1Pvs++IoCVfesvy
OVA0XiV6NPKBYGVYJdZPcRBR69K3zupfYtg+Z5WOiyc6OOvfF5VOELrqP/ac
vOwJ1Ax/eHpxkjik2uY/NeMJJ+G+r2T5DOFolLn6CMcLrEWXTG085wja/vg6
+0ovfG5ui4wuoqHz4TmGsqI37pl51/iWKcB4d3tVP88b66UBx5LpShDNmKhW
VHmDtnZuQTd+Kd62lLt2KfmA29zjOq7xHRrrXSVKAh8UGlAKgXrLUfVEY9q8
xgdPK86qGGmqwWTZnODQCi6K/hnR5b2hI3m/ctV8EBf6Kcop21tWYnpke/Mf
t7g4samnqeyqOsbTT6nqrfZF6Tds9etbDZrnMo1rwb64Ene/KEZNG2cd8tzc
WnzhWrmslp7DwEp3/3CS6YdGiXjuraMuCpId/Vjhfrjs/iYz9LMebvWT4Rad
fhgyT84KPqaPd75H3YwMeVChG9oWfF2L2dkH6qFRPGivTJDWpBhCdJel+ljK
w0zMvf5f3Y3gVPz4wRojf9T6zKZkaxgjrir++u8J/sh5JmLmaG9A9oBv0taX
/ji8JEjM37wRj1h8xogZH5xdGfmMn8yQdPX4cFEqHy6sjlynNnO4O7eG8vr5
uNC871vE2GYkKjDCWFoChLZYRjoxLJE3IWx2cBbg04Jak8kRFlojtsfsOiyA
etd7FfN7VriRZtjad0GAny21ColtW3DVoiDq4EMBfovKUrhevhVZwZa5BuMC
sBKSxl6st4WDtdQ7QFcIzbGcruzubZjJUIrM2ynEpY3aDanH7BAeT27aHymE
Sr+OW6Q7gaFFuT6cQiFuv9J/0p0L8FYlyYgO+d4kvu5wij2y62JVq2eFCOys
FCmeccDAR+Us5joKavRB2fHzO6AjLj59czcFO428mJ0FjtCicwxexlLQ6+Wf
ZHU6gTkn0p4pohAUcbqlctIZrNd3DG8UUwiwDmv9MusM50aZeWgJBaux73Xs
FpEITrEm35VSeB7uWfNEhcQN9e6w3jIKixtGny1mkti5Sb29vorCwnicoNKF
RCg/83j0HQq9Lh4a3/JInHBoSLW+S+FDzmKbsGISIsPBM+NyX1yhpPy+jETD
qEXZAQmF9tiYExfEJJSipD3cJgofX1w75fOYxPk/6Rbb2igcyB3zMpwmURZm
YzclN+WVmZY/R+KOp5Bd/Uj+Z1w6r6fIxiDjuv+Gdgqm5bH1zO/Z2Fi6J02n
k0JfiZaDpQEbSI8SPZd7qU38lgZjNvaGXMrL7KJQbWRb52jGRqTVJ7HKUwoJ
f0lu+9mykaqp2dgid0lhdPoowUbuLNGR+IxCSDYrLdaJjYq+wF7ibwpxRlxz
NRc2JJLTQ7Ny94hL7hfsYeM/Hx8u/g==
            "]]}, Annotation[#, "Charting`Private`Tag#2"]& ]}, {}}, {
       "WolframDynamicHighlight", <|
        "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>}], 
      DynamicBox[
       (Charting`HighlightActionBox["DynamicHighlight", {}, 
        Slot["HighlightElements"], 
        Slot["LayoutOptions"], 
        Slot["Meta"], 
        Charting`HighlightActionFunction["DynamicHighlight", {{{{}, {}, 
            Annotation[{
              Directive[
               Opacity[1.], 
               AbsoluteThickness[2], 
               RGBColor[1, 0, 0]], 
              Line[CompressedData["
1:eJwVznsw1AkAB/BNkaQp8n60UfJID2tJj53f15b9bV2m1K7Xso/fnejonJPI
ae6QFDluV4qkRKVIHpkowxjCJpIuMZVH7OK6XNrkFd3eH9/5zuef73ytqPBD
QRo0Gs1Tnf873n+IkKp46MnQqS3WUxLS3ZWH3n3m4fjDgbU6dCVx3TExiPGF
h5zwsbafHJVE04J1atc0D28znnzdRyoJrQKqW3+Bh9GdvMUHTimJ8+8Hw2Ta
fJhekYcn/60kLsUNZGda8nGiU2TXKh8hyvLeqrJIPnZY8+y/Xh4jQrQme0uu
82H4orjd+8MHgil1SayZ4uP02NHMCbcJQuF+2cD8O28Uzl7Nu1CqIuiGa3rS
bngjzEAgbS/8QhzTfSKcmvFG5ki63YvKGWKPrcz4F74PtBLaykwC5gnakfhq
93s+mFSk/tNdRENn6yUL7cW+CKO1aO0r1YD9gfaK/kBf5BR5PpzT10TWjINu
aYUviFxtgX7CUoy23PV8rukHbQ/pKNdYB401ng2aYj8YlMc5T9NXoOKZ0fTW
+36ILXKfiDVeBYdl8+JjK/3B2l7dbT2oh+Qj2hULIf5g+9xW3Hi8GtMju5rP
1PrjFLWI8LljiE/n/9BdayyAv/Gzl5K3xqB5LzMqCxVAHhJiKFpphovsfC+v
FgH2CmZzbmZbYPVhYRRpFYC7fs0bknbTUZC8J4AZFYAxTlnkhGotavvJKEZn
ANirn6m8T1pjTHDcy9YmECcrzDUXZtdhbu6xYURMIMa6qc3RKTbIqmfqPu0K
hGPwUdmfPFt43Hr62NJWiGZFOn2JiT1OVcSX/54ghFnCpTOExUbkDAqS3N4I
4XDwVb2D8ya0MUUWI1tEcIpzoiaJLUgq/k1xM0WEBSO/E/ptW3GYI48I7Beh
MsNm28GPTkjUsIhkmorhWvvtupelM/JVkmY2Rwwvd8br5Egm5Cd2/br/ZzHy
Ctw9+xpcUJVqI++7IoZvsFcXk7UNxYyCmLBWMRZMnP6tu+eGzFDn3PWfxLD0
t1O0OuwA27XLN4gugbnvUWeznp2YkWpG5++VoIk+8z0Vy0JUPLn5SLQEaac9
WHGHCQwvyvXjF0qgsaZGJMwFAg2SlESHBOP5nGr+WXfkVMfpVs5JUFpoGmAn
Y2NwXDvTagOFINOBs6su7ob5g1vpDw9QeGfU1Zp1bQ9M9fjr38RRmHLpOCtt
94DVfJbZzE0KypbxK7UqDpgDdTZVtyjY7T/XOT/NAadRuTWiiELJUJ8tFjgI
PedKjt2mED7H4LZqk6gy7I7sLaHQ/HndD0pLEns3G7bXVFD41m9rLOCSiBDJ
fouto3BnZd9VxzwSp9mPUlzr1f+GXyOzgESWzdCFT2pbyZrWzxeRePSeUfJj
A4Wq+FF5VyUJzZiuHv8mCtb2W+rS5CSyM/QYO59QGI8Xd7AnSZREbmdNqZ2q
kxFcP0uizlvCrWyjMGyTxmfRuBiyKBdubKdw/3NvEGs5F5tuH0w176TQvaK+
w9OKC5yPyXql9q4lqqCXG7g4FH4tX/acQqMsPkDoyEW0y8cHy1+o90K7+ce3
cZFiYtLYonZMtlv4IhYXuXNER+JfFELvCqbS2VyU9gX3Ei8pFDFiFHQuFw0N
6cNzai9VOLmVe3LxH66FMDY=
               "]]}, "Charting`Private`Tag#1"], 
            Annotation[{
              Directive[
               Opacity[1.], 
               AbsoluteThickness[2], 
               GrayLevel[0], 
               Dashing[{Small, Small}]], 
              Line[CompressedData["
1:eJwVzns0lAkABfCJlJY2s0Ue0zIikSKGoux3Cd+0ckqMxzBm5uuITa0kjzy2
RdbxqHbRVKiTRx7lUciQXhMRRUyt6BQJo1alpTwSdvaPe+75nXP/uEwqZG+A
Ao1Gc5Xn/47nDhIZEx4oiQmxPqkiIzJ2VO9989kDk076R6c0ZUS+aWKAxaQH
9IcGJIHrZETTvH6adNoD0bXDIq69jFhSQHX/MO+Bil8yglIiZUT66MDBTGUO
bt5XFy8flhHnYl+fz1rDQclCaICkaYS4dvHVhIjkwO/KR1Pvs++IoCVfesvy
OVA0XiV6NPKBYGVYJdZPcRBR69K3zupfYtg+Z5WOiyc6OOvfF5VOELrqP/ac
vOwJ1Ax/eHpxkjik2uY/NeMJJ+G+r2T5DOFolLn6CMcLrEWXTG085wja/vg6
+0ovfG5ui4wuoqHz4TmGsqI37pl51/iWKcB4d3tVP88b66UBx5LpShDNmKhW
VHmDtnZuQTd+Kd62lLt2KfmA29zjOq7xHRrrXSVKAh8UGlAKgXrLUfVEY9q8
xgdPK86qGGmqwWTZnODQCi6K/hnR5b2hI3m/ctV8EBf6Kcop21tWYnpke/Mf
t7g4samnqeyqOsbTT6nqrfZF6Tds9etbDZrnMo1rwb64Ene/KEZNG2cd8tzc
WnzhWrmslp7DwEp3/3CS6YdGiXjuraMuCpId/Vjhfrjs/iYz9LMebvWT4Rad
fhgyT84KPqaPd75H3YwMeVChG9oWfF2L2dkH6qFRPGivTJDWpBhCdJel+ljK
w0zMvf5f3Y3gVPz4wRojf9T6zKZkaxgjrir++u8J/sh5JmLmaG9A9oBv0taX
/ji8JEjM37wRj1h8xogZH5xdGfmMn8yQdPX4cFEqHy6sjlynNnO4O7eG8vr5
uNC871vE2GYkKjDCWFoChLZYRjoxLJE3IWx2cBbg04Jak8kRFlojtsfsOiyA
etd7FfN7VriRZtjad0GAny21ColtW3DVoiDq4EMBfovKUrhevhVZwZa5BuMC
sBKSxl6st4WDtdQ7QFcIzbGcruzubZjJUIrM2ynEpY3aDanH7BAeT27aHymE
Sr+OW6Q7gaFFuT6cQiFuv9J/0p0L8FYlyYgO+d4kvu5wij2y62JVq2eFCOys
FCmeccDAR+Us5joKavRB2fHzO6AjLj59czcFO428mJ0FjtCicwxexlLQ6+Wf
ZHU6gTkn0p4pohAUcbqlctIZrNd3DG8UUwiwDmv9MusM50aZeWgJBaux73Xs
FpEITrEm35VSeB7uWfNEhcQN9e6w3jIKixtGny1mkti5Sb29vorCwnicoNKF
RCg/83j0HQq9Lh4a3/JInHBoSLW+S+FDzmKbsGISIsPBM+NyX1yhpPy+jETD
qEXZAQmF9tiYExfEJJSipD3cJgofX1w75fOYxPk/6Rbb2igcyB3zMpwmURZm
YzclN+WVmZY/R+KOp5Bd/Uj+Z1w6r6fIxiDjuv+Gdgqm5bH1zO/Z2Fi6J02n
k0JfiZaDpQEbSI8SPZd7qU38lgZjNvaGXMrL7KJQbWRb52jGRqTVJ7HKUwoJ
f0lu+9mykaqp2dgid0lhdPoowUbuLNGR+IxCSDYrLdaJjYq+wF7ibwpxRlxz
NRc2JJLTQ7Ny94hL7hfsYeM/Hx8u/g==
               "]]}, "Charting`Private`Tag#2"]}}, {}}, <|
         "HighlightElements" -> <|
           "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
          "LayoutOptions" -> <|
           "PlotRange" -> {{83.8058, 150.687}, {0., 48.629997570402054`}}, 
            "Frame" -> {{True, True}, {True, True}}, 
            "AxesOrigin" -> {83.8058, 0.68891}, 
            "ImageSize" -> {400, 400/GoldenRatio}, "Axes" -> {True, True}, 
            "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
            "DefaultStyle" -> {
              Directive[
               Opacity[1.], 
               AbsoluteThickness[2], 
               GrayLevel[0], 
               Dashing[{Small, Small}]], 
              Directive[
               Opacity[1.], 
               AbsoluteThickness[2], 
               RGBColor[1, 0, 0]]}, 
            "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
                Identity[
                 Part[#, 1]], 
                Identity[
                 Part[#, 2]]}& ), 
              "ScalingFunctions" -> {{Identity, Identity}, {
                Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
            False|>, 
          "Meta" -> <|
           "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
            Plot, "GroupHighlight" -> False|>|>]]& )[<|
        "HighlightElements" -> <|
          "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
         "LayoutOptions" -> <|
          "PlotRange" -> {{83.8058, 150.687}, {0., 48.629997570402054`}}, 
           "Frame" -> {{True, True}, {True, True}}, 
           "AxesOrigin" -> {83.8058, 0.68891}, 
           "ImageSize" -> {400, 400/GoldenRatio}, "Axes" -> {True, True}, 
           "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
           "DefaultStyle" -> {
             Directive[
              Opacity[1.], 
              AbsoluteThickness[2], 
              GrayLevel[0], 
              Dashing[{Small, Small}]], 
             Directive[
              Opacity[1.], 
              AbsoluteThickness[2], 
              RGBColor[1, 0, 0]]}, 
           "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
               Identity[
                Part[#, 1]], 
               Identity[
                Part[#, 2]]}& ), 
             "ScalingFunctions" -> {{Identity, Identity}, {
               Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
           False|>, 
         "Meta" -> <|
          "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
           Plot, "GroupHighlight" -> False|>|>], 
       ImageSizeCache -> {{4.503599627370496*^15, -4.503599627370496*^15}, {
        4.503599627370496*^15, -4.503599627370496*^15}}]}, 
     Annotation[{{{{}, {}, 
         Annotation[{
           Directive[
            Opacity[1.], 
            AbsoluteThickness[2], 
            RGBColor[1, 0, 0]], 
           Line[CompressedData["
1:eJwVznsw1AkAB/BNkaQp8n60UfJID2tJj53f15b9bV2m1K7Xso/fnejonJPI
ae6QFDluV4qkRKVIHpkowxjCJpIuMZVH7OK6XNrkFd3eH9/5zuef73ytqPBD
QRo0Gs1Tnf873n+IkKp46MnQqS3WUxLS3ZWH3n3m4fjDgbU6dCVx3TExiPGF
h5zwsbafHJVE04J1atc0D28znnzdRyoJrQKqW3+Bh9GdvMUHTimJ8+8Hw2Ta
fJhekYcn/60kLsUNZGda8nGiU2TXKh8hyvLeqrJIPnZY8+y/Xh4jQrQme0uu
82H4orjd+8MHgil1SayZ4uP02NHMCbcJQuF+2cD8O28Uzl7Nu1CqIuiGa3rS
bngjzEAgbS/8QhzTfSKcmvFG5ki63YvKGWKPrcz4F74PtBLaykwC5gnakfhq
93s+mFSk/tNdRENn6yUL7cW+CKO1aO0r1YD9gfaK/kBf5BR5PpzT10TWjINu
aYUviFxtgX7CUoy23PV8rukHbQ/pKNdYB401ng2aYj8YlMc5T9NXoOKZ0fTW
+36ILXKfiDVeBYdl8+JjK/3B2l7dbT2oh+Qj2hULIf5g+9xW3Hi8GtMju5rP
1PrjFLWI8LljiE/n/9BdayyAv/Gzl5K3xqB5LzMqCxVAHhJiKFpphovsfC+v
FgH2CmZzbmZbYPVhYRRpFYC7fs0bknbTUZC8J4AZFYAxTlnkhGotavvJKEZn
ANirn6m8T1pjTHDcy9YmECcrzDUXZtdhbu6xYURMIMa6qc3RKTbIqmfqPu0K
hGPwUdmfPFt43Hr62NJWiGZFOn2JiT1OVcSX/54ghFnCpTOExUbkDAqS3N4I
4XDwVb2D8ya0MUUWI1tEcIpzoiaJLUgq/k1xM0WEBSO/E/ptW3GYI48I7Beh
MsNm28GPTkjUsIhkmorhWvvtupelM/JVkmY2Rwwvd8br5Egm5Cd2/br/ZzHy
Ctw9+xpcUJVqI++7IoZvsFcXk7UNxYyCmLBWMRZMnP6tu+eGzFDn3PWfxLD0
t1O0OuwA27XLN4gugbnvUWeznp2YkWpG5++VoIk+8z0Vy0JUPLn5SLQEaac9
WHGHCQwvyvXjF0qgsaZGJMwFAg2SlESHBOP5nGr+WXfkVMfpVs5JUFpoGmAn
Y2NwXDvTagOFINOBs6su7ob5g1vpDw9QeGfU1Zp1bQ9M9fjr38RRmHLpOCtt
94DVfJbZzE0KypbxK7UqDpgDdTZVtyjY7T/XOT/NAadRuTWiiELJUJ8tFjgI
PedKjt2mED7H4LZqk6gy7I7sLaHQ/HndD0pLEns3G7bXVFD41m9rLOCSiBDJ
fouto3BnZd9VxzwSp9mPUlzr1f+GXyOzgESWzdCFT2pbyZrWzxeRePSeUfJj
A4Wq+FF5VyUJzZiuHv8mCtb2W+rS5CSyM/QYO59QGI8Xd7AnSZREbmdNqZ2q
kxFcP0uizlvCrWyjMGyTxmfRuBiyKBdubKdw/3NvEGs5F5tuH0w176TQvaK+
w9OKC5yPyXql9q4lqqCXG7g4FH4tX/acQqMsPkDoyEW0y8cHy1+o90K7+ce3
cZFiYtLYonZMtlv4IhYXuXNER+JfFELvCqbS2VyU9gX3Ei8pFDFiFHQuFw0N
6cNzai9VOLmVe3LxH66FMDY=
            "]]}, "Charting`Private`Tag#1"], 
         Annotation[{
           Directive[
            Opacity[1.], 
            AbsoluteThickness[2], 
            GrayLevel[0], 
            Dashing[{Small, Small}]], 
           Line[CompressedData["
1:eJwVzns0lAkABfCJlJY2s0Ue0zIikSKGoux3Cd+0ckqMxzBm5uuITa0kjzy2
RdbxqHbRVKiTRx7lUciQXhMRRUyt6BQJo1alpTwSdvaPe+75nXP/uEwqZG+A
Ao1Gc5Xn/47nDhIZEx4oiQmxPqkiIzJ2VO9989kDk076R6c0ZUS+aWKAxaQH
9IcGJIHrZETTvH6adNoD0bXDIq69jFhSQHX/MO+Bil8yglIiZUT66MDBTGUO
bt5XFy8flhHnYl+fz1rDQclCaICkaYS4dvHVhIjkwO/KR1Pvs++IoCVfesvy
OVA0XiV6NPKBYGVYJdZPcRBR69K3zupfYtg+Z5WOiyc6OOvfF5VOELrqP/ac
vOwJ1Ax/eHpxkjik2uY/NeMJJ+G+r2T5DOFolLn6CMcLrEWXTG085wja/vg6
+0ovfG5ui4wuoqHz4TmGsqI37pl51/iWKcB4d3tVP88b66UBx5LpShDNmKhW
VHmDtnZuQTd+Kd62lLt2KfmA29zjOq7xHRrrXSVKAh8UGlAKgXrLUfVEY9q8
xgdPK86qGGmqwWTZnODQCi6K/hnR5b2hI3m/ctV8EBf6Kcop21tWYnpke/Mf
t7g4samnqeyqOsbTT6nqrfZF6Tds9etbDZrnMo1rwb64Ene/KEZNG2cd8tzc
WnzhWrmslp7DwEp3/3CS6YdGiXjuraMuCpId/Vjhfrjs/iYz9LMebvWT4Rad
fhgyT84KPqaPd75H3YwMeVChG9oWfF2L2dkH6qFRPGivTJDWpBhCdJel+ljK
w0zMvf5f3Y3gVPz4wRojf9T6zKZkaxgjrir++u8J/sh5JmLmaG9A9oBv0taX
/ji8JEjM37wRj1h8xogZH5xdGfmMn8yQdPX4cFEqHy6sjlynNnO4O7eG8vr5
uNC871vE2GYkKjDCWFoChLZYRjoxLJE3IWx2cBbg04Jak8kRFlojtsfsOiyA
etd7FfN7VriRZtjad0GAny21ColtW3DVoiDq4EMBfovKUrhevhVZwZa5BuMC
sBKSxl6st4WDtdQ7QFcIzbGcruzubZjJUIrM2ynEpY3aDanH7BAeT27aHymE
Sr+OW6Q7gaFFuT6cQiFuv9J/0p0L8FYlyYgO+d4kvu5wij2y62JVq2eFCOys
FCmeccDAR+Us5joKavRB2fHzO6AjLj59czcFO428mJ0FjtCicwxexlLQ6+Wf
ZHU6gTkn0p4pohAUcbqlctIZrNd3DG8UUwiwDmv9MusM50aZeWgJBaux73Xs
FpEITrEm35VSeB7uWfNEhcQN9e6w3jIKixtGny1mkti5Sb29vorCwnicoNKF
RCg/83j0HQq9Lh4a3/JInHBoSLW+S+FDzmKbsGISIsPBM+NyX1yhpPy+jETD
qEXZAQmF9tiYExfEJJSipD3cJgofX1w75fOYxPk/6Rbb2igcyB3zMpwmURZm
YzclN+WVmZY/R+KOp5Bd/Uj+Z1w6r6fIxiDjuv+Gdgqm5bH1zO/Z2Fi6J02n
k0JfiZaDpQEbSI8SPZd7qU38lgZjNvaGXMrL7KJQbWRb52jGRqTVJ7HKUwoJ
f0lu+9mykaqp2dgid0lhdPoowUbuLNGR+IxCSDYrLdaJjYq+wF7ibwpxRlxz
NRc2JJLTQ7Ny94hL7hfsYeM/Hx8u/g==
            "]]}, "Charting`Private`Tag#2"]}}, {}}, <|
      "HighlightElements" -> <|
        "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
       "LayoutOptions" -> <|
        "PlotRange" -> {{83.8058, 150.687}, {0., 48.629997570402054`}}, 
         "Frame" -> {{True, True}, {True, True}}, 
         "AxesOrigin" -> {83.8058, 0.68891}, 
         "ImageSize" -> {400, 400/GoldenRatio}, "Axes" -> {True, True}, 
         "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
         "DefaultStyle" -> {
           Directive[
            Opacity[1.], 
            AbsoluteThickness[2], 
            GrayLevel[0], 
            Dashing[{Small, Small}]], 
           Directive[
            Opacity[1.], 
            AbsoluteThickness[2], 
            RGBColor[1, 0, 0]]}, 
         "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
             Identity[
              Part[#, 1]], 
             Identity[
              Part[#, 2]]}& ), 
           "ScalingFunctions" -> {{Identity, Identity}, {
             Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>, 
       "Meta" -> <|
        "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
         Plot, "GroupHighlight" -> False|>|>, "DynamicHighlight"]], 
    AspectRatio -> NCache[GoldenRatio^(-1), 0.6180339887498948], 
    Axes -> {True, True}, AxesLabel -> {None, None}, 
    AxesOrigin -> {83.8058, 0.68891}, DisplayFunction -> Identity, Epilog -> {
      RGBColor[1, 0, 0], PointSize -> Medium, 
      PointBox[{87.2938969493787, 1.01325}], 
      InsetBox[
       FormBox[
       "\"\\!\\(\\*SubscriptBox[\\(T\\), \\(b\\)]\\)\"", TraditionalForm], {
       87.2938969493787, 4}]}, Frame -> {{True, True}, {True, True}}, 
    FrameLabel -> {{
       FormBox[
        TagBox[
         TemplateBox[{"P", "\"bar\"", "bars", "\"Bars\""}, "QuantityTF", 
          SyntaxForm -> Mod], HoldForm], TraditionalForm], None}, {
       FormBox[
        TagBox[
         TemplateBox[{
           TagBox[
            TagBox["T", HoldForm], HoldForm], "\"K\"", "kelvins", 
           "\"Kelvins\""}, "QuantityTF", SyntaxForm -> Mod], HoldForm], 
        TraditionalForm], None}}, 
    FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
    GridLines -> {None, None}, GridLinesStyle -> Directive[
      GrayLevel[0.5, 0.4]], ImagePadding -> All, ImageSize -> 400, 
    Method -> {
     "DefaultBoundaryStyle" -> Automatic, 
      "DefaultGraphicsInteraction" -> {
       "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
        "Effects" -> {
         "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
          "Droplines" -> {
           "freeformCursorMode" -> True, 
            "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
      "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> None, 
      "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& ), "CopiedValueFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& )}}, 
    PlotRange -> {{83.8058, 150.687}, {0., 48.629997570402054`}}, 
    PlotRangeClipping -> True, PlotRangePadding -> {{
       Scaled[0.02], 
       Scaled[0.02]}, {
       Scaled[0.05], 
       Scaled[0.05]}}, Ticks -> {Automatic, Automatic}], 
   FormBox[
    FormBox[
     TemplateBox[{
       RowBox[{"10", " ", 
         RowBox[{"PTSat", "(", 
           TagBox["T", HoldForm], ")"}]}], 
       RowBox[{"PTSatNIST", "(", 
         TagBox["T", HoldForm], ")"}]}, "LineLegend", 
      DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    AbsoluteThickness[2], 
                    RGBColor[1, 0, 0]], {
                    LineBox[{{0, 12.5}, {40, 12.5}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    AbsoluteThickness[2], 
                    RGBColor[1, 0, 0]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {40, 12.5}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.18000000000000002`] -> 
                    Baseline)], #}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    AbsoluteThickness[2], 
                    GrayLevel[0], 
                    Dashing[{Small, Small}]], {
                    LineBox[{{0, 12.5}, {40, 12.5}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    AbsoluteThickness[2], 
                    GrayLevel[0], 
                    Dashing[{Small, Small}]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {40, 12.5}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.18000000000000002`] -> 
                    Baseline)], #2}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
         FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
         False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"LineLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   RowBox[{"AbsoluteThickness", "[", "2", "]"}], ",", 
                   
                   TemplateBox[<|"color" -> RGBColor[1, 0, 0]|>, 
                    "RGBColorSwatchTemplate"]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   RowBox[{"AbsoluteThickness", "[", "2", "]"}], ",", 
                   
                   TemplateBox[<|"color" -> GrayLevel[0]|>, 
                    "GrayLevelColorSwatchTemplate"], ",", 
                   RowBox[{"Dashing", "[", 
                    RowBox[{"{", 
                    RowBox[{"Small", ",", "Small"}], "}"}], "]"}]}], "]"}]}], 
             "}"}], ",", 
           RowBox[{"{", 
             RowBox[{
               TagBox[#, HoldForm], ",", 
               TagBox[#2, HoldForm]}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", "None"}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& ), 
      Editable -> True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Output",
 CellLabel->"Out[5]=",
 CellID->42584971,ExpressionUUID->"12f5e273-ad04-42ba-b5ca-5a152ca1b4c8"]
}, Open  ]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"}, 
  Closed]]]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "2"},
        Closed], 
      Alternatives[Open, True]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{
    13.600000000000001`, {0.5800000000000001, 13.020000000000001`}}]],
  ExpressionUUID->"d2c54892-b645-4fd4-a7d8-6f16b69b4034"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"5f6ccbb7-2008-46fc-b8e9-56188075b51f"],
 "Applications",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "76f70173-2736-40ef-ba38-ce31c77f555d"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellID->258228157,ExpressionUUID->"a3c0ba47-9acc-4dbe-93a7-c5413d744898"],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<NewEoSArgon`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->46589048,ExpressionUUID->"db81c594-7af4-4058-815c-52cb49ad4bfd"],

Cell["\<\
Phase diagram of argon for the range of temperature corresponding to NIST\
\>", "ExampleText",
 CellID->605737459,ExpressionUUID->"14b26133-f29e-4bbe-8a1e-ae7b925c225e"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"FigSat", "=", 
   RowBox[{"Quiet", "@", 
    RowBox[{"LogPlot", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"PTSat", "[", "T", "]"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"T", ",", "ttr", ",", "tcNv"}], "}"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
      RowBox[{"Frame", "\[Rule]", "True"}], ",", 
      RowBox[{"FrameLabel", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"\"\<T\>\"", ",", "\"\<P\>\""}], "}"}]}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", "Red", "}"}]}], ",", 
      RowBox[{"Epilog", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Red", ",", 
         RowBox[{"PointSize", "\[Rule]", "Medium"}], ",", 
         RowBox[{"Point", "[", 
          RowBox[{"{", 
           RowBox[{"tcNv", ",", 
            RowBox[{"Log", "[", 
             RowBox[{"pcNv", "/", "10"}], "]"}]}], "}"}], "]"}]}], "}"}]}]}], 
     "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"FigFus", "=", 
   RowBox[{"LogPlot", "[", 
    RowBox[{
     RowBox[{"PFusionArgon", "[", "T", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"T", ",", "ttr", ",", "700"}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
     RowBox[{"Frame", "\[Rule]", "True"}], ",", 
     RowBox[{"FrameLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<T\>\"", ",", "\"\<P\>\""}], "}"}]}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", "Black"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"FigPhases", "=", 
  RowBox[{"Show", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"FigSat", ",", "FigFus"}], "}"}], ",", 
    RowBox[{"PlotRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"All", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Log", "[", 
          RowBox[{"ptr", "/", "10"}], "]"}], ",", 
         RowBox[{"Log", "[", "1000", "]"}]}], "}"}]}], "}"}]}], ",", 
    RowBox[{"FrameLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
      "\"\<Temperature \!\(\*StyleBox[\"T\",FontSlant->\"Italic\"]\) (K)\>\"",
        ",", "\"\<Pressure \!\(\*StyleBox[\"P\",FontSlant->\"Italic\"]\) \
(MPa)\>\"", ",", "\"\< \>\"", ",", "\"\< \>\""}], "}"}]}], ",", 
    RowBox[{"LabelStyle", "\[Rule]", 
     RowBox[{"Directive", "[", 
      RowBox[{"12", ",", 
       RowBox[{"FontFamily", "\[Rule]", "\"\<Times\>\""}]}], "]"}]}], ",", 
    RowBox[{"ImageSize", "\[Rule]", "400"}]}], "]"}]}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->206869432,ExpressionUUID->"553cd6b0-9d97-4f9f-9a73-2ab8391b2728"],

Cell[BoxData[
 GraphicsBox[{
   InterpretationBox[{
     TagBox[{{{}, {}, 
        TagBox[
         {RGBColor[1, 0, 0], AbsoluteThickness[2], Opacity[1.], 
          LineBox[CompressedData["
1:eJwVjWs0lHkcgKUmmupsZ7bQrpRcplLEySmF/8+qFQl1ZsZljBmvW6dj2E5u
KWuOlh2xXUzb1Eol65ImW1oNivedyY7kVu1k0RqM0LiEcX3FWPvhOc95Pj3m
WOzJCH09Pb3jy/zvt31alDPJANkaibgonEKcCmtR908xQOBZ4CvnUgid+kG6
0wwDHN5LnqqCKMRuNa+xZ44B9nSP1M0nKERGTwvLTscAuWnbVrELhXDuKuU3
GTIhPkLDKzeiEEVtWO5qMybYWjQTUQ2riPMN72aSjzIhJvFF7F97VxG04eL1
wt+Z4KbhHkz8rE/o3C0zzs8zoWEdx+J54wrC1EbKxX1Y0F6CTOqleoS1D7pF
L2UB8FXmNruX8PSSmH0JSyywKXygKN62iL9xFdlp2P4QKPvWYuuXefx4WEuW
5Jk/uCBvdfX4HL4Vf+zJWhsAwlzbyHnjWVzFEkZZRgUAk94p+sF6GtdaGQy2
vwgAf0adfXzYJH7g4u36rg2BYLzTcS+/YgI/bUo3NIgOhIq6zaJz3WP4xEhA
qZEsEO5E1xtPF4/g4WSqxGtLEJjoH5jluWtw6vWar1oTg8Ayv5I6SRnAKZH3
lU5NQVA30avy2NiHj5y9QL6is+Fo2r8928e68R1Vi6muKWxIohnObj/Sifsd
jIts72DD1aCcO21HlXip54oy+b5gMPM4OeBk2owHXnX0F2UGg1XWBy1NIsen
aVyesD8Y7J0sxfbnyvCBJrvGsEMcuGjLqMmTitCaTcbiK1c4IJccDio8UolM
bk3Ku4c4kEJ1hr4IBbrASPQzghBgVa7LD65rRU3Hxl3O3A6BxwaKB+adSuTz
NjXbdDYETNx8U5R3O5DV5WfOZce4UO6En7ZY6EKaDLV3eDEX3mVRCEffXqQv
rajVW+SCeyv13Qi/DxVVt75K2MGDcVfbjeuT+pF8P8KWmDy4nq14NFkwiIR+
abvPC3jg6JZcs3RPgw4bENaZZTxYcrY2VtQOo4eBb09c6uBBmAdDdeuPUWQz
yX/0dGUo7Bm+cTPr8hjK30VxirUPhRCpdLZUMY5ki7HTW4JDwaLANNPsyQRq
j3nfG3IpFKa82ZssH2qRIV2hq5eGgg7RQl7cnkTq5EvelupQmImMTO9KnkLl
0Z6vaRswUEirE+JOTaM98x+Spg5iUNR6GATuM0jWQvrrwjH4aXueSmc8i465
0aJ+y8Gg+X6E6srCLBL46op21mDg8fFjLfFmDhUKEx8PLvdH4OSeVc6h17Lx
qsJaDKbog/HW7XNo476+JnMCA1QdZZ/dPYdKTF5pN7/EYDTbyy7g8xxq7b3m
Sm3AIOd41DbtWhKZxVm1DSkxWEn9xcHBg0Tuj+50l7zH4EflUu+AF4lODRhr
ItswsPkuvyjXh0TlAdQF9T8YvPbj8CksEn3vMmb+oRODiuiE9o5wEsWsruI3
9mDwtRFLnJ5GIhFySMzsXf5PJZgdyiBRZdJDgYcaA/ZXurzxTBLpD+eJXvZh
II5NE7CvkehGa1rV8wEMThRV37C7R6Lnhgvyc4MYRKQ8Ge4rIFGPW3zT/k8Y
fP71AC4uJtGuP6O6n2owGJIIvRbLSOQ72vPpzBAGP1MtGsvKSRRnHaS1G8ZA
1r/nCOcZiW5y//4yutyCu9RvDKpJVHPTmyIZwUDXLJKU1pDoP6SDcZ8=
           "]]},
         Annotation[#, "Charting`Private`Tag#1"]& ]}, {}},
      {"WolframDynamicHighlight", <|
       "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>}], 
     DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
       Slot["HighlightElements"], 
       Slot["LayoutOptions"], 
       Slot["Meta"], 
       Charting`HighlightActionFunction["DynamicHighlight", {{{{}, {}, 
           Annotation[{
             Directive[
              Opacity[1.], 
              AbsoluteThickness[2], 
              RGBColor[1, 0, 0]], 
             Line[CompressedData["
1:eJwVjWs0lHkcgKUmmupsZ7bQrpRcplLEySmF/8+qFQl1ZsZljBmvW6dj2E5u
KWuOlh2xXUzb1Eol65ImW1oNivedyY7kVu1k0RqM0LiEcX3FWPvhOc95Pj3m
WOzJCH09Pb3jy/zvt31alDPJANkaibgonEKcCmtR908xQOBZ4CvnUgid+kG6
0wwDHN5LnqqCKMRuNa+xZ44B9nSP1M0nKERGTwvLTscAuWnbVrELhXDuKuU3
GTIhPkLDKzeiEEVtWO5qMybYWjQTUQ2riPMN72aSjzIhJvFF7F97VxG04eL1
wt+Z4KbhHkz8rE/o3C0zzs8zoWEdx+J54wrC1EbKxX1Y0F6CTOqleoS1D7pF
L2UB8FXmNruX8PSSmH0JSyywKXygKN62iL9xFdlp2P4QKPvWYuuXefx4WEuW
5Jk/uCBvdfX4HL4Vf+zJWhsAwlzbyHnjWVzFEkZZRgUAk94p+sF6GtdaGQy2
vwgAf0adfXzYJH7g4u36rg2BYLzTcS+/YgI/bUo3NIgOhIq6zaJz3WP4xEhA
qZEsEO5E1xtPF4/g4WSqxGtLEJjoH5jluWtw6vWar1oTg8Ayv5I6SRnAKZH3
lU5NQVA30avy2NiHj5y9QL6is+Fo2r8928e68R1Vi6muKWxIohnObj/Sifsd
jIts72DD1aCcO21HlXip54oy+b5gMPM4OeBk2owHXnX0F2UGg1XWBy1NIsen
aVyesD8Y7J0sxfbnyvCBJrvGsEMcuGjLqMmTitCaTcbiK1c4IJccDio8UolM
bk3Ku4c4kEJ1hr4IBbrASPQzghBgVa7LD65rRU3Hxl3O3A6BxwaKB+adSuTz
NjXbdDYETNx8U5R3O5DV5WfOZce4UO6En7ZY6EKaDLV3eDEX3mVRCEffXqQv
rajVW+SCeyv13Qi/DxVVt75K2MGDcVfbjeuT+pF8P8KWmDy4nq14NFkwiIR+
abvPC3jg6JZcs3RPgw4bENaZZTxYcrY2VtQOo4eBb09c6uBBmAdDdeuPUWQz
yX/0dGUo7Bm+cTPr8hjK30VxirUPhRCpdLZUMY5ki7HTW4JDwaLANNPsyQRq
j3nfG3IpFKa82ZssH2qRIV2hq5eGgg7RQl7cnkTq5EvelupQmImMTO9KnkLl
0Z6vaRswUEirE+JOTaM98x+Spg5iUNR6GATuM0jWQvrrwjH4aXueSmc8i465
0aJ+y8Gg+X6E6srCLBL46op21mDg8fFjLfFmDhUKEx8PLvdH4OSeVc6h17Lx
qsJaDKbog/HW7XNo476+JnMCA1QdZZ/dPYdKTF5pN7/EYDTbyy7g8xxq7b3m
Sm3AIOd41DbtWhKZxVm1DSkxWEn9xcHBg0Tuj+50l7zH4EflUu+AF4lODRhr
ItswsPkuvyjXh0TlAdQF9T8YvPbj8CksEn3vMmb+oRODiuiE9o5wEsWsruI3
9mDwtRFLnJ5GIhFySMzsXf5PJZgdyiBRZdJDgYcaA/ZXurzxTBLpD+eJXvZh
II5NE7CvkehGa1rV8wEMThRV37C7R6Lnhgvyc4MYRKQ8Ge4rIFGPW3zT/k8Y
fP71AC4uJtGuP6O6n2owGJIIvRbLSOQ72vPpzBAGP1MtGsvKSRRnHaS1G8ZA
1r/nCOcZiW5y//4yutyCu9RvDKpJVHPTmyIZwUDXLJKU1pDoP6SDcZ8=
              "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
        "HighlightElements" -> <|
          "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
         "LayoutOptions" -> <|
          "PlotRange" -> {All, All}, "Frame" -> {{True, True}, {True, True}}, 
           "AxesOrigin" -> {83.80580137939202, -2.912087609394192}, 
           "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
           "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
           "DefaultStyle" -> {
             Directive[
              Opacity[1.], 
              AbsoluteThickness[2], 
              RGBColor[1, 0, 0]]}, 
           "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
               Identity[
                Part[#, 1]], 
               Exp[
                Part[#, 2]]}& ), 
             "ScalingFunctions" -> {{Identity, Identity}, {Log, Exp}}|>, 
           "Primitives" -> {}, "GCFlag" -> False|>, 
         "Meta" -> <|
          "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
           Plot, "GroupHighlight" -> False|>|>]]& )[<|
       "HighlightElements" -> <|
         "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
        "LayoutOptions" -> <|
         "PlotRange" -> {All, All}, "Frame" -> {{True, True}, {True, True}}, 
          "AxesOrigin" -> {83.80580137939202, -2.912087609394192}, 
          "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
          "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
          "DefaultStyle" -> {
            Directive[
             Opacity[1.], 
             AbsoluteThickness[2], 
             RGBColor[1, 0, 0]]}, 
          "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
              Identity[
               Part[#, 1]], 
              Exp[
               Part[#, 2]]}& ), 
            "ScalingFunctions" -> {{Identity, Identity}, {Log, Exp}}|>, 
          "Primitives" -> {}, "GCFlag" -> False|>, 
        "Meta" -> <|
         "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
          Plot, "GroupHighlight" -> False|>|>],
      ImageSizeCache->{{4.503599627370496*^15, -4.503599627370496*^15}, {
       4.503599627370496*^15, -4.503599627370496*^15}}]},
    Annotation[{{{{}, {}, 
        Annotation[{
          Directive[
           Opacity[1.], 
           AbsoluteThickness[2], 
           RGBColor[1, 0, 0]], 
          Line[CompressedData["
1:eJwVjWs0lHkcgKUmmupsZ7bQrpRcplLEySmF/8+qFQl1ZsZljBmvW6dj2E5u
KWuOlh2xXUzb1Eol65ImW1oNivedyY7kVu1k0RqM0LiEcX3FWPvhOc95Pj3m
WOzJCH09Pb3jy/zvt31alDPJANkaibgonEKcCmtR908xQOBZ4CvnUgid+kG6
0wwDHN5LnqqCKMRuNa+xZ44B9nSP1M0nKERGTwvLTscAuWnbVrELhXDuKuU3
GTIhPkLDKzeiEEVtWO5qMybYWjQTUQ2riPMN72aSjzIhJvFF7F97VxG04eL1
wt+Z4KbhHkz8rE/o3C0zzs8zoWEdx+J54wrC1EbKxX1Y0F6CTOqleoS1D7pF
L2UB8FXmNruX8PSSmH0JSyywKXygKN62iL9xFdlp2P4QKPvWYuuXefx4WEuW
5Jk/uCBvdfX4HL4Vf+zJWhsAwlzbyHnjWVzFEkZZRgUAk94p+sF6GtdaGQy2
vwgAf0adfXzYJH7g4u36rg2BYLzTcS+/YgI/bUo3NIgOhIq6zaJz3WP4xEhA
qZEsEO5E1xtPF4/g4WSqxGtLEJjoH5jluWtw6vWar1oTg8Ayv5I6SRnAKZH3
lU5NQVA30avy2NiHj5y9QL6is+Fo2r8928e68R1Vi6muKWxIohnObj/Sifsd
jIts72DD1aCcO21HlXip54oy+b5gMPM4OeBk2owHXnX0F2UGg1XWBy1NIsen
aVyesD8Y7J0sxfbnyvCBJrvGsEMcuGjLqMmTitCaTcbiK1c4IJccDio8UolM
bk3Ku4c4kEJ1hr4IBbrASPQzghBgVa7LD65rRU3Hxl3O3A6BxwaKB+adSuTz
NjXbdDYETNx8U5R3O5DV5WfOZce4UO6En7ZY6EKaDLV3eDEX3mVRCEffXqQv
rajVW+SCeyv13Qi/DxVVt75K2MGDcVfbjeuT+pF8P8KWmDy4nq14NFkwiIR+
abvPC3jg6JZcs3RPgw4bENaZZTxYcrY2VtQOo4eBb09c6uBBmAdDdeuPUWQz
yX/0dGUo7Bm+cTPr8hjK30VxirUPhRCpdLZUMY5ki7HTW4JDwaLANNPsyQRq
j3nfG3IpFKa82ZssH2qRIV2hq5eGgg7RQl7cnkTq5EvelupQmImMTO9KnkLl
0Z6vaRswUEirE+JOTaM98x+Spg5iUNR6GATuM0jWQvrrwjH4aXueSmc8i465
0aJ+y8Gg+X6E6srCLBL46op21mDg8fFjLfFmDhUKEx8PLvdH4OSeVc6h17Lx
qsJaDKbog/HW7XNo476+JnMCA1QdZZ/dPYdKTF5pN7/EYDTbyy7g8xxq7b3m
Sm3AIOd41DbtWhKZxVm1DSkxWEn9xcHBg0Tuj+50l7zH4EflUu+AF4lODRhr
ItswsPkuvyjXh0TlAdQF9T8YvPbj8CksEn3vMmb+oRODiuiE9o5wEsWsruI3
9mDwtRFLnJ5GIhFySMzsXf5PJZgdyiBRZdJDgYcaA/ZXurzxTBLpD+eJXvZh
II5NE7CvkehGa1rV8wEMThRV37C7R6Lnhgvyc4MYRKQ8Ge4rIFGPW3zT/k8Y
fP71AC4uJtGuP6O6n2owGJIIvRbLSOQ72vPpzBAGP1MtGsvKSRRnHaS1G8ZA
1r/nCOcZiW5y//4yutyCu9RvDKpJVHPTmyIZwUDXLJKU1pDoP6SDcZ8=
           "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
     "HighlightElements" -> <|
       "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
      "LayoutOptions" -> <|
       "PlotRange" -> {All, All}, "Frame" -> {{True, True}, {True, True}}, 
        "AxesOrigin" -> {83.80580137939202, -2.912087609394192}, 
        "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
        "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), "DefaultStyle" -> {
          Directive[
           Opacity[1.], 
           AbsoluteThickness[2], 
           RGBColor[1, 0, 0]]}, 
        "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
            Identity[
             Part[#, 1]], 
            Exp[
             Part[#, 2]]}& ), 
          "ScalingFunctions" -> {{Identity, Identity}, {Log, Exp}}|>, 
        "Primitives" -> {}, "GCFlag" -> False|>, 
      "Meta" -> <|
       "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
        Plot, "GroupHighlight" -> False|>|>, "DynamicHighlight"]], 
   InterpretationBox[{
     TagBox[{{{}, {}, 
        TagBox[
         {GrayLevel[0], AbsoluteThickness[2], Opacity[1.], 
          LineBox[CompressedData["
1:eJwV0nk4FAgfB3A5J+e4RjlnxLu2A9vaUtR80/HW0qaYMRhi5Fj3bUqTc3JF
KqSc6XBkt5aslChhnUWRMEjOZFVI48o77x+/5/t8/vt+n+dHYfmdcBUWEhLK
FNz/cyBy0vfynDX0P4Q30FzFnrrt8agvWbOGiIxRzKxXQ+3M4sTG51I0PDBS
+bBLfIga+re7X78KDeUiH/VvSU9TvwdO1M9touGld2lxMneWet7AXVXakIbY
YbFqXcICVXZ63E/HlIZvTy2sfD/wqRlFbg2mh2kYmLEYqLBbpmq6jqvSrGlw
O/fOrfD0KvUOxc3fx4mGtjwz7WjbNar+4FgD15sGZQLCqmOE8Pd1V7VcNg2e
u5hr5w6tA9VmzP/vWBr4PEp/HH8dmhRdG1+k0pD0Nc4lMlsYlh2jahPZNMh1
dO4INxKB05HRRpUKGuRJvKbHh0QxKXZK3fAZDQ5aynrez0XhXzcScLidhg5S
aqXyLjFEmYyonx4T7D8YYrFHQRySfFbgpS803JEMs/4YKo7LD97/U7xKw7/H
t/6z8kYcBdveB/Yp05HEbugYTJTA5innplkKHS5U1Wd2QxIouzOsIaVPB8H4
cmWaIQF1WsNNJofoCNKxb9vRQsCI/DvNnFA6+iycqVeG1sP7xcngimg6MrqT
qZlakphPHGpuT6GDLhLZ9sRBEqKiQ8Hf79Bh8HheqqdLEjoLAy0ne+gYN3u0
tf6+FErLHMjsETosiyrKWKNSMPIbCEn9REeWeaVxC0kaByd55GcSNjjWejV/
G1sabn39odrGNmgNm/p4U18GMxn2bbsP2MClYn/8Z1sZhFr1U6wsbTC/rLPF
JVYGcW19bTEeNkjzpvjz3sigqKZXeyzTBqU97l6zgbL4UNDzonDRBgmxD24p
JMsh0PBJRr04A6MDxPbb9+Ww9KTAcViRgeQHg6GFr+Ug3eszo6rPgEHVhVBR
aSL05URlU1gMNI6ZeTscJSIw3PBocCsDQeaGNZwGIpYIJOVLbxlI4ESW33hN
REzGMu+PMQYi0hN3Zg4TkfZXo/fEGgMn4pcS160SUTnBvGBnZIuy6kK7kZ/k
sWKV0IocW/y0zJaoSJMX/K3vFYcSW1TepsSw8+Uh42dtf6bSFr9EnZ1SL5WH
ZqLWx/JOW4gNWalJPZfHvqcVkj+I26FkfG1vyid5nN/6/oiMnx1yy7cllexX
AFHMpKkX9uBzLpTb9CsgP/eUxoaj9qhP3b43a0QBBsYpgXRbe7Tuamx6+VEB
v3kNq78OsEfFQeNa6RUFJHfGBbQV2GNqb7oKT00RkrldqrWiTHACeoRXGIoQ
2+nrc6uJiex9FkNeLYpI67ha976LieYDUsY/dipCx/OZCmWYCRLPvInXo4gD
OUp1OYtMCD/qF/thTBHRIo9JVzc7gFbNUzZfU4RQh8TThAsOSBvcvTj5kxKW
PG4o+Fk6QuaExF7KJSXsslSd9mM64sVxpY6qDCWwd15p8PdwhOzRnmfm2UpY
EOOyAyMdYbnkIM4sVMJcgcdgyH1HRHVsfm3wRAnTPIOSs8STIHvRnvw1oYQh
y5p9iR0nEf21weWcsTJY2T4PTxQ5Idfd0uJ+qzKi+UzH7j+dYDq8YsbqUEaB
tYUoo8IJL47Elst1K2NYeoulQ50TDk4t/MdhUBlOnMkJd54Top4RrJ5/VsZJ
RxcVDtEZzpYyB+uVSGCSbUML2c6QJRTWvLQlgXbrgNHKYRYGo5NWY3pJYIu/
yZc7xsJb89khmQESsj3cZTbRWBCNe7kv/R0J77cmjh9xZiHFd+Zy9gQJ/hUv
M6+eZmHc5UNn8lcSEhvtVreXsLD+0bHhVaIKaif9G3+XcgEp42rxlkMq+HFb
DqOn3QXpNfE/u5SoQOrNvWYEuYJCrxty9t6AAaPS+iWiO4IXXtU+VtiIVKXN
HuOXPeCc8u06M2cjjiuxGE6/eGJavusKXVcVc2lqX6SqvcB/0ZyNa6rgttYo
Ekx8UJVdSzETVoOOtnrM5T5fFGn4ha14qeHVWc7RHwz84fjnU75wkxqu8Zsj
LNYF4N68r3SkrjoYx6S+XXsZgK1PmAtV4eqId0s2E0oNxIbOksi6f9RRm+z9
4A+nICQR1Ey+KWvALeTCUtCmYBxNarrtYK8BJZ/17lELwejOysol3NTAI2r4
hsqGEHhc0FPUG9dA56ttuWJxobhk7hm7SVsTn0L2/JrFCMOt7z4KiU6a4PQm
txxRZ6M3lm57PlMTIhteXyTz2GjmzBb5t2si1S0kfG/pafQuXqtuE9VCSgjD
JMT3DJKrZeZKd2jhSlomZQ7hENl1u+SjpxZSU9otrsmdxfHbHiGR2VpYPbzf
gtFxFmtFxnnHm7UQoEgKdLzBgZ55cGEIXwv03B+9OafOQZNtfDBDnoyfRbff
rd8UgWidAtl5XTJUzlwlWs1FQH5Ls1qQCRk73mrqcuwiMfoq9RT/NzJcwsm0
4OeR0HQbNU1zIaPpnNmnMN0oRFfF5VqHklH8afDuRW4UauPf5h2KJyNlsni5
5d8o2NpP6x3KIuPuvvQKhWPREFrsd8ooJaNV+57wuYfRsOkedpqqIcM9YH/g
qlYMOC7fyzkdZJiS+eYJkTFIEzP0jXtHhpJN/0PjDzHozJTnJ30hQ3dm8OL8
r7HwbGrjbFxHQdksM6G+JBbLhNQyKSIFZhHrSQ8VuBjqMyB/1qJA0vuN9MMg
LgwSRzpP61OwWha/9fcQLny/5Ks/Evjz4m4L1TAu1n9adF4S+E1cXtLZM1y0
M6J5ZwwouHnTQ3JfFBfFCeKXwg0pMO1fkmhJ4aKuvIgfvp0Cv1+1RHjFXHhG
lDSxd1DAutSpnXyXi7tWOR4PBaa/jTHb+wcXmkWHRfgCm7pNRuXf54J1sk0v
bCcFhOi/hFwrubDvzzcKMaagoGr/93/rufg6td/SfzcF6UILGnmNXBRN6mXf
Ezj+v0V7LJu4yInpej8jsG+3NKeslYsqYoyTjwkFJl+6l0NfceH8jabhaUqB
vnG8ml4XF8cs46nFAmtH7Dbp7eYiixrPnBSYIJN3xqRX0Nd2/rzbHgqWrY5f
n+7jQgGstNsCz1wXeZTD40Ld6Eb2qMDDwxW9vw1yIatYlrdpLwVdeh6La0Nc
zFel57AE/h+K6UBp
           "]]},
         Annotation[#, "Charting`Private`Tag#1"]& ]}, {}},
      {"WolframDynamicHighlight", <|
       "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>}], 
     DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
       Slot["HighlightElements"], 
       Slot["LayoutOptions"], 
       Slot["Meta"], 
       Charting`HighlightActionFunction["DynamicHighlight", {{{{}, {}, 
           Annotation[{
             Directive[
              Opacity[1.], 
              AbsoluteThickness[2], 
              GrayLevel[0]], 
             Line[CompressedData["
1:eJwV0nk4FAgfB3A5J+e4RjlnxLu2A9vaUtR80/HW0qaYMRhi5Fj3bUqTc3JF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              "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
        "HighlightElements" -> <|
          "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
         "LayoutOptions" -> <|
          "PlotRange" -> {All, All}, "Frame" -> {{True, True}, {True, True}}, 
           "AxesOrigin" -> {83.80581257539203, -3.3020536761051935`}, 
           "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
           "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
           "DefaultStyle" -> {
             Directive[
              Opacity[1.], 
              AbsoluteThickness[2], 
              GrayLevel[0]]}, 
           "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
               Identity[
                Part[#, 1]], 
               Exp[
                Part[#, 2]]}& ), 
             "ScalingFunctions" -> {{Identity, Identity}, {Log, Exp}}|>, 
           "Primitives" -> {}, "GCFlag" -> False|>, 
         "Meta" -> <|
          "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
           Plot, "GroupHighlight" -> False|>|>]]& )[<|
       "HighlightElements" -> <|
         "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
        "LayoutOptions" -> <|
         "PlotRange" -> {All, All}, "Frame" -> {{True, True}, {True, True}}, 
          "AxesOrigin" -> {83.80581257539203, -3.3020536761051935`}, 
          "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
          "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
          "DefaultStyle" -> {
            Directive[
             Opacity[1.], 
             AbsoluteThickness[2], 
             GrayLevel[0]]}, 
          "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
              Identity[
               Part[#, 1]], 
              Exp[
               Part[#, 2]]}& ), 
            "ScalingFunctions" -> {{Identity, Identity}, {Log, Exp}}|>, 
          "Primitives" -> {}, "GCFlag" -> False|>, 
        "Meta" -> <|
         "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
          Plot, "GroupHighlight" -> False|>|>],
      ImageSizeCache->{{4.503599627370496*^15, -4.503599627370496*^15}, {
       4.503599627370496*^15, -4.503599627370496*^15}}]},
    Annotation[{{{{}, {}, 
        Annotation[{
          Directive[
           Opacity[1.], 
           AbsoluteThickness[2], 
           GrayLevel[0]], 
          Line[CompressedData["
1:eJwV0nk4FAgfB3A5J+e4RjlnxLu2A9vaUtR80/HW0qaYMRhi5Fj3bUqTc3JF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           "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
     "HighlightElements" -> <|
       "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
      "LayoutOptions" -> <|
       "PlotRange" -> {All, All}, "Frame" -> {{True, True}, {True, True}}, 
        "AxesOrigin" -> {83.80581257539203, -3.3020536761051935`}, 
        "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
        "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), "DefaultStyle" -> {
          Directive[
           Opacity[1.], 
           AbsoluteThickness[2], 
           GrayLevel[0]]}, 
        "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
            Identity[
             Part[#, 1]], 
            Exp[
             Part[#, 2]]}& ), 
          "ScalingFunctions" -> {{Identity, Identity}, {Log, Exp}}|>, 
        "Primitives" -> {}, "GCFlag" -> False|>, 
      "Meta" -> <|
       "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
        Plot, "GroupHighlight" -> False|>|>, "DynamicHighlight"]]},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{83.80580137939202, -2.912087609394192},
  DisplayFunction->Identity,
  Epilog->{
    RGBColor[1, 0, 0], PointSize -> Medium, 
    PointBox[{151.396, 1.6088053982786756`}]},
  Frame->{{True, True}, {True, True}},
  FrameLabel->{
    FormBox[
    "\"Temperature \\!\\(\\*StyleBox[\\\"T\\\",FontSlant->\\\"Italic\\\"]\\) \
(K)\"", TraditionalForm], 
    FormBox[
    "\"Pressure \\!\\(\\*StyleBox[\\\"P\\\",FontSlant->\\\"Italic\\\"]\\) \
(MPa)\"", TraditionalForm], 
    FormBox["\" \"", TraditionalForm], 
    FormBox["\" \"", TraditionalForm]},
  FrameTicks->FrontEndValueCache[{{
      Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
       MachinePrecision, RotateLabel -> 0], 
      Charting`ScaledFrameTicks[{Log, Exp}]}, {
     Automatic, Automatic}}, {{{{-2.3025850929940455`, 
        FormBox[
         TagBox[
          InterpretationBox[
           StyleBox["\"0.1\"", ShowStringCharacters -> False], 0.1, 
           AutoDelete -> True], NumberForm[#, {
            DirectedInfinity[1], 1}]& ], TraditionalForm], {0.01, 0.}}, {0., 
        FormBox["1", TraditionalForm], {0.01, 0.}}, {2.302585092994046, 
        FormBox["10", TraditionalForm], {0.01, 0.}}, {4.605170185988092, 
        FormBox["100", TraditionalForm], {0.01, 0.}}, {6.907755278982137, 
        FormBox["1000", TraditionalForm], {0.01, 0.}}, {-4.605170185988091, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-3.506557897319982, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-3.2188758248682006`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.8134107167600364`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.659260036932778, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.5257286443082556`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.4079456086518722`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-1.2039728043259361`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.916290731874155, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.5108256237659907, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.35667494393873245`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.2231435513142097, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.10536051565782628`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.0986122886681098`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.3862943611198906`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.791759469228055, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.9459101490553132`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.0794415416798357`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.1972245773362196`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.4011973816621555`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.6888794541139363`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.0943445622221, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.248495242049359, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.382026634673881, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.499809670330265, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       5.298317366548036, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       5.703782474656201, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       5.991464547107982, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.214608098422191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.396929655216146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.551080335043404, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.684611727667927, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.802394763324311, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       7.600902459542082, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       8.006367567650246, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       8.294049640102028, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       8.517193191416238, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       8.699514748210191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       8.85366542803745, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       8.987196820661973, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       9.104979856318357, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       9.210340371976184, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}}, {{-2.3025850929940455`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {0., 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {
       2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {
       4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {
       6.907755278982137, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 
        0.}}, {-4.605170185988091, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-3.506557897319982, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-3.2188758248682006`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.8134107167600364`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.659260036932778, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.5257286443082556`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.4079456086518722`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-1.2039728043259361`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.916290731874155, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.5108256237659907, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.35667494393873245`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.2231435513142097, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.10536051565782628`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.0986122886681098`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.3862943611198906`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.791759469228055, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.9459101490553132`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.0794415416798357`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.1972245773362196`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.4011973816621555`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.6888794541139363`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.0943445622221, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.248495242049359, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.382026634673881, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.499809670330265, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       5.298317366548036, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       5.703782474656201, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       5.991464547107982, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.214608098422191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.396929655216146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.551080335043404, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.684611727667927, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.802394763324311, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       7.600902459542082, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       8.006367567650246, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       8.294049640102028, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       8.517193191416238, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       8.699514748210191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       8.85366542803745, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       8.987196820661973, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       9.104979856318357, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       9.210340371976184, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}}}, {
     Automatic, Automatic}}],
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  ImageSize->400,
  LabelStyle->Directive[12, FontFamily -> "Times"],
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Exp[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Exp[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->NCache[{All, {-2.675229733587482, 
      Log[1000]}}, {All, {-2.675229733587482, 6.907755278982137}}],
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, 
    Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
     MachinePrecision, RotateLabel -> 0]}]], "Output",
 CellLabel->"Out[2]=",
 CellID->52919211,ExpressionUUID->"13616d9b-a4d0-4410-8068-bee51a486416"]
}, Open  ]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "2"}, 
  Closed]]]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "PrimaryExamplesSection"}, 
  Closed]]]],

Cell[BoxData[GridBox[{
   {
    DynamicBox[FEPrivate`ImportImage[
      FrontEnd`FileName[{"Documentation", "FooterIcons"}, 
       "RelatedFunction.png"]],
     ImageSizeCache->{50., {27., 33.}}], GridBox[{
      {
       StyleBox[
        RowBox[{"See", " ", "Also"}], "SeeAlsoSection"]},
      {Cell[TextData[{
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["ptrNv"]], "paclet:NewEoSArgon/ref/ptrNv", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "1854079a-56aa-49dd-8d4f-fc650173e7b2"],
        "\[NonBreakingSpace]",
        StyleBox[
        "\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
         "InlineSeparator"],
        " ",
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["PTSatNIST"]], "paclet:NewEoSArgon/ref/PTSatNIST", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "3498ce21-b120-4bfd-b58c-6f05d5543a5c"],
        "\[NonBreakingSpace]",
        StyleBox[
        "\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
         "InlineSeparator"],
        " ",
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["tcNv"]], "paclet:NewEoSArgon/ref/tcNv", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "f8f2885a-cc41-40d6-a5ab-29070b05cabf"],
        "\[NonBreakingSpace]",
        StyleBox[
        "\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
         "InlineSeparator"],
        " ",
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["ttr"]], "paclet:NewEoSArgon/ref/ttr", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "3455ad98-ac31-4447-977a-b6bc9eb89654"],
        "\[NonBreakingSpace]",
        StyleBox[
        "\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
         "InlineSeparator"],
        " ",
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["RhoSatVapFromT"]], 
           "paclet:NewEoSArgon/ref/RhoSatVapFromT", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "a8657a75-be2a-4ab1-bd5c-cf9df53b092f"],
        "\[NonBreakingSpace]",
        StyleBox[
        "\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
         "InlineSeparator"],
        " ",
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["RhoSatLiqFromT"]], 
           "paclet:NewEoSArgon/ref/RhoSatLiqFromT", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "9c2f50c7-8d6b-4793-bdb7-e9971dbe7190"]
       }], "SeeAlso",ExpressionUUID->"38959e13-7c1d-4a91-ac53-4d6f058c4d68"]}
     }]}
  }]], "SeeAlsoSection",ExpressionUUID->"52fd2c30-64c4-47a5-9a5a-\
2529b7108677"],

Cell[BoxData[GridBox[{
   {
    DynamicBox[FEPrivate`ImportImage[
      FrontEnd`FileName[{"Documentation", "FooterIcons"}, "RelatedGuide.png"]],
     ImageSizeCache->{50., {27., 33.}}], GridBox[{
      {
       StyleBox[
        RowBox[{"Related", " ", "Guides"}], "MoreAboutSection"]},
      {
       RowBox[{"\[FilledVerySmallSquare]", Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["NewEoSArgon Package"]], 
           "paclet:NewEoSArgon/guide/NewEoSArgon"},
          "RefLinkPlain",
          BaseStyle->{"MoreAbout"}]], "MoreAbout",ExpressionUUID->
         "009427d5-6634-479c-8f00-0045591a5791"]}]}
     }]}
  }]], "MoreAboutSection",ExpressionUUID->"e5d1f7c9-f8b4-451c-a672-\
5750787e3a56"],

Cell[BoxData[GridBox[{
   {
    TemplateBox[{29},
     "Spacer1"], GridBox[{
      {
       RowBox[{
        TemplateBox[{17},
         "Spacer1"], 
        StyleBox[
         RowBox[{"Related", " ", "Links"}], "RelatedLinksSection"]}]},
      {Cell[BoxData[Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData[
             RowBox[{
               RowBox[{"Units", " ", "&"}], " ", "Quantities"}]]], 
           "paclet:guide/Units"},
          "RefLinkPlain",
          BaseStyle->{"RelatedLinks"}]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "53f34e9c-b35f-442d-90a9-480119b48c3c"]], "RelatedLinks",
        ExpressionUUID->"78dc7a65-8139-4588-b91d-3ebb095c3b34"]}
     }]}
  }]], "RelatedLinksSection",ExpressionUUID->"92f37402-231b-41e3-bf46-\
6e04490d9fd3"],

Cell[" ", "FooterCell",ExpressionUUID->"09e44623-5d1e-4622-84b6-07fe2a5c02f3"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{900, 835.8},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"PTSat",
TaggingRules->{
 "ModificationHighlight" -> False, "ColorType" -> "", "LinkTrails" -> "", 
  "HasOptions" -> True, "ExampleCounter" -> 1, 
  "Openers" -> {
   "PrimaryExamplesSection" -> Open, 
    "ExampleSection" -> {"0" -> Open, "2" -> Closed}, "NotesSection" -> 
    Closed}, "NewStyles" -> True, "CitationPopupData" -> $Failed, 
  "ShowCitation" -> False, "RootCaptions" -> "", 
  "Metadata" -> {
   "built" -> "{2023, 11, 30, 13, 55, 52.0325986}", 
    "history" -> {"XX", "", "", ""}, "context" -> "NewEoSArgon`", 
    "keywords" -> {}, "specialkeywords" -> {}, 
    "tutorialcollectionlinks" -> {}, "index" -> True, "label" -> 
    "New Eo S Argon Package Symbol", "language" -> "en", "paclet" -> 
    "NewEoSArgon Package", "status" -> "None", "summary" -> 
    "PTsat[T] \\[Congruent] P\\[Sigma] (MPa) Pression sur la courbe de \
saturation en fonction de T (Kelvin) [Fitting function of the saturation \
pressure versus T (Kelvin)]", "synonyms" -> {}, "tabletags" -> {}, "title" -> 
    "PTSat", "titlemodifier" -> "", "metadescription" -> "", "windowtitle" -> 
    "PTSat", "type" -> "Symbol", "uri" -> "NewEoSArgon/ref/PTSat"}},
CellContext->"Global`",
FrontEndVersion->"13.3 pour Microsoft Windows (64-bit) (July 24, 2023)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "13.3 pour Microsoft Windows (64-bit) (July 24, 2023)", 
  StyleDefinitions -> "Default.nb"],
ExpressionUUID->"a54a4dc9-ebd9-4247-81c8-5e3c98aaac47"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[11526, 318, 1419, 37, 35, "PrimaryExamplesSection",ExpressionUUID->"9dd8841b-3c85-48d7-be4c-7238d87e9dc5",
   CellTags->"PrimaryExamplesSection",
   CellID->63248241]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 93422, 2180}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[577, 21, 5662, 136, 56, "AnchorBarGrid",ExpressionUUID->"14d7b472-2da3-4f83-8ac2-27395e2a0368",
 CellID->1],
Cell[6242, 159, 94, 0, 23, "ContextNameCell",ExpressionUUID->"b0525257-f0de-46c7-a1d2-7908143e3345"],
Cell[CellGroupData[{
Cell[6361, 163, 548, 14, 56, "ObjectNameGrid",ExpressionUUID->"e614b761-2086-4dab-a957-6c647b77bb21"],
Cell[6912, 179, 741, 20, 146, "Usage",ExpressionUUID->"ceee40ab-3e7f-459b-8f90-b8d563013100"]
}, Open  ]],
Cell[CellGroupData[{
Cell[7690, 204, 1917, 48, 37, "NotesSection",ExpressionUUID->"922cdfeb-4a39-44eb-b1fe-e2dc36ed015e",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->5473010],
Cell[9610, 254, 804, 25, 38, "Notes",ExpressionUUID->"2eb93e1e-2cc0-4a91-b165-8f7b64fa27fb",
 CellID->1067943069],
Cell[10417, 281, 186, 4, 36, "Notes",ExpressionUUID->"8924c816-12f4-4f7e-acb8-3b5b9a194ecc",
 CellID->224665577],
Cell[10606, 287, 793, 25, 38, "Notes",ExpressionUUID->"373d6433-40c6-4855-a5be-03e4f998a4c5",
 CellID->32133948]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "NotesSection"}, Closed]]]],
Cell[CellGroupData[{
Cell[11526, 318, 1419, 37, 35, "PrimaryExamplesSection",ExpressionUUID->"9dd8841b-3c85-48d7-be4c-7238d87e9dc5",
 CellTags->"PrimaryExamplesSection",
 CellID->63248241],
Cell[CellGroupData[{
Cell[12970, 359, 1398, 36, 30, "ExampleSection",ExpressionUUID->"6c474bc2-9174-4a18-bcf7-55336f27ff44",
 CellID->191111600],
Cell[14371, 397, 174, 3, 26, "Input",ExpressionUUID->"30fbed1f-2d92-4307-b5cd-7331f8583bf7",
 CellID->87419684],
Cell[14548, 402, 131, 1, 38, "ExampleText",ExpressionUUID->"4857eba6-75f4-481f-a5bc-5e87a1cf0116",
 CellID->285078790],
Cell[CellGroupData[{
Cell[14704, 407, 227, 5, 26, "Input",ExpressionUUID->"cd1ab246-e419-49d4-91de-62185f2ab870",
 CellID->231987987],
Cell[14934, 414, 224, 5, 39, "Output",ExpressionUUID->"3887f79a-cb3d-4fe8-96ee-f761f21545ac",
 CellID->347789595]
}, Open  ]],
Cell[CellGroupData[{
Cell[15195, 424, 632, 16, 26, "Input",ExpressionUUID->"12d66b17-8598-47e1-bf0e-c2d292fb3b46",
 CellID->357130942],
Cell[15830, 442, 205, 4, 40, "Output",ExpressionUUID->"e0a9c4ed-008f-4aa6-8a31-229236ec3646",
 CellID->305062684]
}, Open  ]],
Cell[16050, 449, 135, 1, 38, "ExampleText",ExpressionUUID->"09228c57-fc71-41f8-af88-13b33f569b33",
 CellID->184302421],
Cell[CellGroupData[{
Cell[16210, 454, 840, 23, 42, "Input",ExpressionUUID->"b6d4ed72-7c2f-4203-98e6-c6681460f078",
 CellID->223155686],
Cell[17053, 479, 208, 4, 39, "Output",ExpressionUUID->"8e0d2b06-e311-4585-ace3-45c7c02f3320",
 CellID->207581601]
}, Open  ]],
Cell[17276, 486, 184, 3, 38, "ExampleText",ExpressionUUID->"748a9366-eeda-4179-986f-350c3a829db3",
 CellID->886239600],
Cell[CellGroupData[{
Cell[17485, 493, 1644, 44, 72, "Input",ExpressionUUID->"93f41b23-0347-49ef-afba-c818c83ec9bf",
 CellID->21488140],
Cell[19132, 539, 23785, 495, 283, "Output",ExpressionUUID->"12f5e273-ad04-42ba-b5ca-5a152ca1b4c8",
 CellID->42584971]
}, Open  ]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"}, Closed]]]],
Cell[CellGroupData[{
Cell[43066, 1042, 1419, 37, 70, "ExampleSection",ExpressionUUID->"a3c0ba47-9acc-4dbe-93a7-c5413d744898",
 CellID->258228157],
Cell[44488, 1081, 174, 3, 70, "Input",ExpressionUUID->"db81c594-7af4-4058-815c-52cb49ad4bfd",
 CellID->46589048],
Cell[44665, 1086, 179, 3, 70, "ExampleText",ExpressionUUID->"14b26133-f29e-4bbe-8a1e-ae7b925c225e",
 CellID->605737459],
Cell[CellGroupData[{
Cell[44869, 1093, 2532, 66, 70, "Input",ExpressionUUID->"553cd6b0-9d97-4f9f-9a73-2ab8391b2728",
 CellID->206869432],
Cell[47404, 1161, 38710, 821, 70, "Output",ExpressionUUID->"13616d9b-a4d0-4410-8068-bee51a486416",
 CellID->52919211]
}, Open  ]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "2"}, Closed]]]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "PrimaryExamplesSection"}, Closed]]]],
Cell[86356, 1991, 3465, 94, 70, "SeeAlsoSection",ExpressionUUID->"52fd2c30-64c4-47a5-9a5a-2529b7108677"],
Cell[89824, 2087, 729, 19, 70, "MoreAboutSection",ExpressionUUID->"e5d1f7c9-f8b4-451c-a672-5750787e3a56"],
Cell[90556, 2108, 825, 24, 70, "RelatedLinksSection",ExpressionUUID->"92f37402-231b-41e3-bf46-6e04490d9fd3"],
Cell[91384, 2134, 78, 0, 70, "FooterCell",ExpressionUUID->"09e44623-5d1e-4622-84b6-07fe2a5c02f3"]
}
]
*)

(* End of internal cache information *)

