(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 13.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    189929,       3794]
NotebookOptionsPosition[    182363,       3641]
NotebookOutlinePosition[    184897,       3703]
CellTagsIndexPosition[    184773,       3697]
WindowTitle->PTSatNIST
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[GridBox[{
   {GridBox[{
      {
       ItemBox[Cell[BoxData[
         RowBox[{
          TemplateBox[{12},
           "Spacer1"], Cell["NEW EO S ARGON PACKAGE SYMBOL", "PacletNameCell",
           TextAlignment->Center,ExpressionUUID->
           "22c5844e-4499-499c-aee2-82f8e5a64059"], 
          TemplateBox[{8},
           "Spacer1"]}]],
         TextAlignment->Center,ExpressionUUID->
         "637c6a72-095d-455d-b872-5d9ac97b3731"],
        Background->RGBColor[0.490196, 0.576471, 0.690196],
        ItemSize->Full], ""}
     },
     GridBoxAlignment->{"Rows" -> {{Center}}},
     GridBoxItemSize->{"Columns" -> {Full, 
         Scaled[0.02]}, "Rows" -> {{2.5}}}], Cell[TextData[{
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "See Also",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "1337e440-7ce2-4fb9-bd79-b55574f510ef"]
         }],ExpressionUUID->"5fff1af5-7904-4d93-8b94-7190309d6674"],
         StripOnInput->False],{
        "\"ptr\"" :> Documentation`HelpLookup["paclet:NewEoSArgon/ref/ptr"], 
         "\"pc\"" :> Documentation`HelpLookup["paclet:NewEoSArgon/ref/pc"], 
         "\"ttr\"" :> Documentation`HelpLookup["paclet:NewEoSArgon/ref/ttr"], 
         "\"tc\"" :> Documentation`HelpLookup["paclet:NewEoSArgon/ref/tc"], 
         "\"RhoSatVapNISTFromT\"" :> 
         Documentation`HelpLookup[
          "paclet:NewEoSArgon/ref/RhoSatVapNISTFromT"], 
         "\"RhoSatLiqNISTFromT\"" :> 
         Documentation`HelpLookup[
          "paclet:NewEoSArgon/ref/RhoSatLiqNISTFromT"]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"SeeAlso"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "bb35b3b8-7d82-40c6-acc5-633d073c529d"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "Related Guides",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "6dd0c5e7-ebf2-4ca1-949f-fa576b211205"]
         }],ExpressionUUID->"6946c6f1-e298-4f3b-9278-e01f46a15449"],
         StripOnInput->False],{
        "\"NewEoSArgon Package\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/guide/NewEoSArgon"]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"MoreAbout"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "ae726b21-0c1c-4e6a-95e5-681768252997"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "URL",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "123196c9-827d-4441-819d-f19c29991ae5"]
         }],ExpressionUUID->"5756f558-8af2-4316-8e4a-3493ea2afaf1"],
         StripOnInput->False],{
        "\"NewEoSArgon/ref/PTSatNIST\"" :> None, 
         "\"Copy Wolfram Documentation Center URL\"" :> 
         Module[{DocumentationSearch`Private`nb$}, 
           DocumentationSearch`Private`nb$ = 
            NotebookPut[
             Notebook[{Cell["NewEoSArgon/ref/PTSatNIST"]}, Visible -> False]]; 
           SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
           FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
           NotebookClose[DocumentationSearch`Private`nb$]; Null], Delimiter, 
         "\"Copy web URL\"" :> 
         Module[{DocumentationSearch`Private`nb$}, 
           DocumentationSearch`Private`nb$ = 
            NotebookPut[
             Notebook[{
               Cell[BoxData[
                 MakeBoxes[
                  Hyperlink[
                   "http://reference.wolfram.com/language/NewEoSArgon/ref/\
PTSatNIST.html"], StandardForm]], "Input", TextClipboardType -> "PlainText"]},
                Visible -> False]]; 
           SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
           FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
           NotebookClose[DocumentationSearch`Private`nb$]; Null], 
         "\"Go to web URL\"" :> 
         FrontEndExecute[{
           NotebookLocate[{
             URL[If[TrueQ[DocumentationBuild`Make`Private`wsmlinkQ$22143], 
                 "http://reference.wolfram.com/system-modeler/", 
                 "http://reference.wolfram.com/language/"] <> 
               "NewEoSArgon/ref/PTSatNIST" <> ".html"], None}]}]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"URLMenu"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "92e011dd-2c3c-4a5b-9f38-c953313c6ed9"]
    }], "AnchorBar",
     CacheGraphics->False,ExpressionUUID->
     "427d39c0-c508-4486-9a02-3960ec23056b"]}
  }]], "AnchorBarGrid",
 CellID->1,ExpressionUUID->"5591d0f6-e517-4d98-a88d-4a667b28ff35"],

Cell["NewEoSArgon`", "ContextNameCell",ExpressionUUID->"1d30e667-ec04-4670-9644-2f92050722c6"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     Cell[
     "PTSatNIST", "ObjectName",ExpressionUUID->
      "bfe0caa8-1c8b-4eaa-8199-b518917b9155"],
     Cell[BoxData[
      TemplateBox[{8},
       "Spacer1"]],ExpressionUUID->"680b8ff5-e612-465e-808e-e64aaf3f9b97"],
     Cell[BoxData[
     ""], "ObjectNameTranslation",ExpressionUUID->
      "de1493d1-cc50-49ba-9ac9-937b78b99605"]
    }],ExpressionUUID->"1cb444d9-404b-46d8-9ffe-8687387e65e7"], 
    "\[SpanFromLeft]"}
  }]], "ObjectNameGrid",ExpressionUUID->"d166b3bf-aa47-43de-a65e-\
e47dd77d3c74"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     "PTSatNIST[",
     StyleBox["T",
      FontSlant->"Italic"],
     "] \[Congruent] ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["P",
        FontSlant->"Italic"], "\[Sigma]"]], "InlineFormula",
      FontFamily->"Source Sans Pro",ExpressionUUID->
      "df3ece01-8306-4d46-a788-5c90b7ed096a"],
     " (bar)\nPression sur la courbe de saturation donn\[EAcute]e par NIST en \
fonction de ",
     StyleBox["T",
      FontSlant->"Italic"],
     " (Kelvin)\n[Fitting function of the saturation pressure versus ",
     StyleBox["T ",
      FontSlant->"Italic"],
     "(Kelvin) from the data of NIST]"
    }],ExpressionUUID->"50b3b59d-84ed-45fb-9509-62ffdc3ab540"]}
  }]], "Usage",ExpressionUUID->"799a4e21-c464-4c7d-88d8-6a82adaa7e0b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[Cell[TextData[{
   Cell[BoxData[
    DynamicBox[ToBoxes[
      If[
       MatchQ[
        CurrentValue[
         EvaluationNotebook[], {TaggingRules, "Openers", "NotesSection"}, 
         Closed], 
        Alternatives[Open, True]], 
       Style[
        Graphics[{
          Thickness[0.18], 
          RGBColor[0.8509803921568627, 0.396078431372549, 0], 
          Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
         PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
        0.68 Inherited], 
       Rotate[
        Style[
         Graphics[{
           Thickness[0.18], 
           RGBColor[0.8509803921568627, 0.396078431372549, 0], 
           Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
          PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
         0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
     ImageSizeCache->{
      13.600000000000001`, {0.5800000000000001, 13.020000000000001`}}]],
    ExpressionUUID->"a49a93e2-f6a2-4830-a5f5-7f7dd05563c9"],
   Cell[BoxData[
    TemplateBox[{1},
     "Spacer1"]],ExpressionUUID->"2c92074a-68c4-471d-8ec1-9d05d8a5c05f"],
   "Details and Options"
  }], "NotesFrameText",ExpressionUUID->"de5b3ca6-c8b5-4158-9141-2e918035a64f"],
  Appearance->{Automatic, None, "Normal", Automatic},
  BaseStyle->None,
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"], 
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], After, CellContents]}]& ),
  Evaluator->None,
  Method->
   "Preemptive"]],ExpressionUUID->"a1ec8fea-e7fd-4816-8aca-c38730d131b1"]], \
"NotesSection",
 WholeCellGroupOpener->True,
 CellGroupingRules->{"SectionGrouping", 50},
 CacheGraphics->False,
 CellID->74224178,ExpressionUUID->"403ee0fa-669b-444e-ae1e-111aec9ed93b"],

Cell[TextData[{
 "La fonction est d\[EAcute]finie pour ",
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["ttr"]], "paclet:NewEoSArgon/ref/ttr", 
    "NewEoSArgon Package Symbol"},
   "PackageLink",
   BaseStyle->"InlineFormula"]], "InlineFormula",
  FontFamily->"Source Sans Pro",ExpressionUUID->
  "60b8ff33-22bc-418d-b3e3-7bacbf91c7f1"],
 " \[LessEqual] ",
 StyleBox["T",
  FontSlant->"Italic"],
 " \[LessEqual] ",
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["tc"]], "paclet:NewEoSArgon/ref/tc", 
    "NewEoSArgon Package Symbol"},
   "PackageLink",
   BaseStyle->"InlineFormula"]], "InlineFormula",
  FontFamily->"Source Sans Pro",ExpressionUUID->
  "6cd38aa8-b776-452b-a080-a5357b538bdc"]
}], "Notes",
 CellID->1067943069,ExpressionUUID->"fba69659-0210-41b2-b1bd-f7ace5363313"],

Cell["\<\
******************************************************************************\
******\
\>", "Notes",
 CellID->224665577,ExpressionUUID->"09c74a34-246a-4d8b-a9ca-090a83728ffb"],

Cell[TextData[{
 "The function is defined for ",
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["ttr"]], "paclet:NewEoSArgon/ref/ttr", 
    "NewEoSArgon Package Symbol"},
   "PackageLink",
   BaseStyle->"InlineFormula"]], "InlineFormula",
  FontFamily->"Source Sans Pro",ExpressionUUID->
  "7efe06fb-30bb-44dc-bfba-d59c43fad4e2"],
 " \[LessEqual] ",
 StyleBox["T",
  FontSlant->"Italic"],
 " \[LessEqual] ",
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["tc"]], "paclet:NewEoSArgon/ref/tc", 
    "NewEoSArgon Package Symbol"},
   "PackageLink",
   BaseStyle->"InlineFormula"]], "InlineFormula",
  FontFamily->"Source Sans Pro",ExpressionUUID->
  "5288ed2e-100d-43fd-bc7d-e2b5aafa6e41"]
}], "Notes",
 CellID->431860626,ExpressionUUID->"6471e290-7b92-4bec-9f84-4ed5b19e7f9e"]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "NotesSection"}, Closed]]]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {
       TaggingRules, "Openers", "PrimaryExamplesSection"}, Open], 
      Alternatives[True, Open]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{13.600000000000001`, {5., 8.600000000000001}}]],
  ExpressionUUID->"06e8c534-0c8d-478b-8857-80943f95dcf8"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"758eaed4-eca4-46cc-a72a-5fb24a6e9950"],
 "Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount",ExpressionUUID->
  "9708b665-2143-4ccb-860a-7a9923213fa7"]
}], "PrimaryExamplesSection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellTags->"PrimaryExamplesSection",
 CellID->993152026,ExpressionUUID->"64225709-292f-47b5-a140-ea7ed6111a65"],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"},
        Closed], 
      Alternatives[Open, True]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{13.600000000000001`, {5., 8.600000000000001}}]],
  ExpressionUUID->"86a4811c-e736-4e88-a53a-858b86519d37"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"53cfa849-047f-44cd-b5bc-9e36e498aa08"],
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "53ab347c-f3e2-41db-a7c3-a6939e74b629"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellID->546853994,ExpressionUUID->"fd6d89b0-3ed2-4094-8c6a-5be9c40e8722"],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<NewEoSArgon`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->87419684,ExpressionUUID->"efd9acd8-89ec-4440-8a19-13d7b36a9927"],

Cell["Calculate with physical dimension", "ExampleText",
 CellID->285078790,ExpressionUUID->"ba1fd61e-5478-4988-86eb-fc72a5b21483"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Quantity", "[", 
  RowBox[{
   RowBox[{"PTSatNIST", "[", "ttr", "]"}], ",", "\"\<Bars\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->231987987,ExpressionUUID->"26b28922-6eb2-4a66-8f36-ce11ef51b655"],

Cell[BoxData[
 TemplateBox[{"0.6889100000000001`", "\"bar\"", "bars", "\"Bars\""},
  "Quantity"]], "Output",
 CellLabel->"Out[2]=",
 CellID->44452636,ExpressionUUID->"dab9057c-845b-459b-b20f-55c200e3c21d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UnitConvert", "[", 
  RowBox[{
   TemplateBox[{"0.68891`"},
    "QuantityUnit",
    DisplayFunction->(TooltipBox[
      StyleBox[
       RowBox[{#, "\[InvisibleSpace]", 
         StyleBox[
          RowBox[{" ", "\"bars\""}], "QuantityUnitTraditionalLabel"]}], 
       ShowStringCharacters -> False], "Unit: bars"]& ),
    InterpretationFunction->(RowBox[{"Quantity", "[", 
       RowBox[{#, ",", "\"Bars\""}], "]"}]& )], ",", "\"\<MPa\>\""}], 
  "]"}]], "Input",
 NumberMarks->False,
 CellLabel->"In[3]:=",
 CellID->71863064,ExpressionUUID->"0ce208aa-786c-41ed-8339-21120a4db4a3"],

Cell[BoxData[
 TemplateBox[{
  "0.06889100000000001`", "\"MPa\"", "megapascals", "\"Megapascals\""},
  "Quantity"]], "Output",
 CellLabel->"Out[3]=",
 CellID->58743882,ExpressionUUID->"280e3843-de70-4241-9533-2c6952059d8b"]
}, Open  ]],

Cell["Atmospheric boiling point temperature", "ExampleText",
 CellID->184302421,ExpressionUUID->"4e130122-0db1-4957-8c40-18a04effb748"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"NormalPressure", "=", 
   RowBox[{"N", "@", 
    RowBox[{"QuantityMagnitude", "@", 
     RowBox[{"UnitConvert", "[", 
      RowBox[{
       RowBox[{"Quantity", "[", 
        RowBox[{"1", ",", "\"\<atm\>\""}], "]"}], ",", "\"\<Bars\>\""}], 
      "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Tb", "=", 
  RowBox[{"Quantity", "[", 
   RowBox[{
    RowBox[{"x", "/.", 
     RowBox[{"FindRoot", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"PTSatNIST", "[", "x", "]"}], "==", "NormalPressure"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "87", ",", "90"}], "}"}], ",", 
       RowBox[{"Method", "\[Rule]", "\"\<Secant\>\""}]}], "]"}]}], ",", 
    "\"\<Kelvins\>\""}], "]"}]}]}], "Input",
 CellLabel->"In[4]:=",
 CellID->223155686,ExpressionUUID->"0ebaab37-baa9-4e06-860b-97269a9ff6da"],

Cell[BoxData[
 TemplateBox[{"87.30146199987604`", "\"K\"", "kelvins", "\"Kelvins\""},
  "Quantity"]], "Output",
 CellLabel->"Out[4]=",
 CellID->105405309,ExpressionUUID->"d694e796-b2e9-41b7-93f3-e0338214ee24"]
}, Open  ]],

Cell["Using ThermodynamicData package (i.e. REFPROP from NIST)", "ExampleText",
 CellID->361149294,ExpressionUUID->"50412b1f-6884-481f-9b7f-10710ec997ed"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UnitConvert", "[", 
  RowBox[{"ThermodynamicData", "[", 
   RowBox[{"\"\<Argon\>\"", ",", "\"\<LiquidVaporPhaseBoundary\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"\"\<Pressure\>\"", "\[Rule]", 
      RowBox[{"Quantity", "[", 
       RowBox[{"1", ",", "\"\<Atmospheres\>\""}], "]"}]}], "}"}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->375583457,ExpressionUUID->"2cbfdcda-f933-4e96-a6bc-136dbcb43fec"],

Cell[BoxData[
 TemplateBox[{"87.30213623564593`", "\"K\"", "kelvins", "\"Kelvins\""},
  "Quantity"]], "Output",
 CellLabel->"Out[5]=",
 CellID->545338054,ExpressionUUID->"02721e87-4ca8-4fa3-8004-1c965056d651"]
}, Open  ]],

Cell["\<\
Plot function versus temperature in all the temperature range\
\>", "ExampleText",
 CellID->886239600,ExpressionUUID->"a558d9d6-b091-4659-809c-2433a6200f67"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"PTSatNIST", "[", "T", "]"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"T", ",", "ttr", ",", "tc"}], "}"}], ",", 
   RowBox[{"AxesOrigin", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"ttr", ",", "ptr"}], "}"}]}], ",", 
   RowBox[{"Frame", "->", "True"}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Quantity", "[", 
       RowBox[{"T", ",", "\"\<Kelvins\>\""}], "]"}], ",", 
      RowBox[{"Quantity", "[", 
       RowBox[{"P", ",", "\"\<Bars\>\""}], "]"}]}], "}"}]}], ",", 
   RowBox[{"ImageSize", "\[Rule]", "400"}], ",", 
   RowBox[{"Epilog", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Red", ",", 
      RowBox[{"PointSize", "\[Rule]", "Medium"}], ",", 
      RowBox[{"Point", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"QuantityMagnitude", "@", "Tb"}], ",", "NormalPressure"}], 
        "}"}], "]"}], ",", 
      RowBox[{"Text", "[", 
       RowBox[{"\"\<\!\(\*SubscriptBox[\(T\), \(b\)]\)\>\"", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"QuantityMagnitude", "@", "Tb"}], ",", "4"}], "}"}]}], 
       "]"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->21488140,ExpressionUUID->"113594e8-3c23-4903-868b-2707b41174e0"],

Cell[BoxData[
 GraphicsBox[
  InterpretationBox[{
    TagBox[{{{}, {}, 
       TagBox[
        {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[2], 
         Opacity[1.], LineBox[CompressedData["
1:eJwVzns0lAkABfCJlJY2s0Ue0zIikSKGoux3Cd+0ckqMxzBm5uuITa0kjzy2
RdbxqHbRVKiTRx7lUciQXhMRRUyt6BQJo1alpTwSdvaPe+75nXP/uEwqZG+A
Ao1Gc5Xn/47nDhIZEx4oiQmxPqkiIzJ2VO9989kDk076R6c0ZUS+aWKAxaQH
9IcGJIHrZETTvH6adNoD0bXDIq69jFhSQHX/MO+Bil8yglIiZUT66MDBTGUO
bt5XFy8flhHnYl+fz1rDQclCaICkaYS4dvHVhIjkwO/KR1Pvs++IoCVfesvy
OVA0XiV6NPKBYGVYJdZPcRBR69K3zupfYtg+Z5WOiyc6OOvfF5VOELrqP/ac
vOwJ1Ax/eHpxkjik2uY/NeMJJ+G+r2T5DOFolLn6CMcLrEWXTG085wja/vg6
+0ovfG5ui4wuoqHz4TmGsqI37pl51/iWKcB4d3tVP88b66UBx5LpShDNmKhW
VHmDtnZuQTd+Kd62lLt2KfmA29zjOq7xHRrrXSVKAh8UGlAKgXrLUfVEY9q8
xgdPK86qGGmqwWTZnODQCi6K/hnR5b2hI3m/ctV8EBf6Kcop21tWYnpke/Mf
t7g4samnqeyqOsbTT6nqrfZF6Tds9etbDZrnMo1rwb64Ene/KEZNG2cd8tzc
WnzhWrmslp7DwEp3/3CS6YdGiXjuraMuCpId/Vjhfrjs/iYz9LMebvWT4Rad
fhgyT84KPqaPd75H3YwMeVChG9oWfF2L2dkH6qFRPGivTJDWpBhCdJel+ljK
w0zMvf5f3Y3gVPz4wRojf9T6zKZkaxgjrir++u8J/sh5JmLmaG9A9oBv0taX
/ji8JEjM37wRj1h8xogZH5xdGfmMn8yQdPX4cFEqHy6sjlynNnO4O7eG8vr5
uNC871vE2GYkKjDCWFoChLZYRjoxLJE3IWx2cBbg04Jak8kRFlojtsfsOiyA
etd7FfN7VriRZtjad0GAny21ColtW3DVoiDq4EMBfovKUrhevhVZwZa5BuMC
sBKSxl6st4WDtdQ7QFcIzbGcruzubZjJUIrM2ynEpY3aDanH7BAeT27aHymE
Sr+OW6Q7gaFFuT6cQiFuv9J/0p0L8FYlyYgO+d4kvu5wij2y62JVq2eFCOys
FCmeccDAR+Us5joKavRB2fHzO6AjLj59czcFO428mJ0FjtCicwxexlLQ6+Wf
ZHU6gTkn0p4pohAUcbqlctIZrNd3DG8UUwiwDmv9MusM50aZeWgJBaux73Xs
FpEITrEm35VSeB7uWfNEhcQN9e6w3jIKixtGny1mkti5Sb29vorCwnicoNKF
RCg/83j0HQq9Lh4a3/JInHBoSLW+S+FDzmKbsGISIsPBM+NyX1yhpPy+jETD
qEXZAQmF9tiYExfEJJSipD3cJgofX1w75fOYxPk/6Rbb2igcyB3zMpwmURZm
YzclN+WVmZY/R+KOp5Bd/Uj+Z1w6r6fIxiDjuv+Gdgqm5bH1zO/Z2Fi6J02n
k0JfiZaDpQEbSI8SPZd7qU38lgZjNvaGXMrL7KJQbWRb52jGRqTVJ7HKUwoJ
f0lu+9mykaqp2dgid0lhdPoowUbuLNGR+IxCSDYrLdaJjYq+wF7ibwpxRlxz
NRc2JJLTQ7Ny94hL7hfsYeM/Hx8u/g==
          "]]},
        Annotation[#, "Charting`Private`Tag#1"]& ]}, {}},
     {"WolframDynamicHighlight", <|
      "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>}], 
    DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
      Slot["HighlightElements"], 
      Slot["LayoutOptions"], 
      Slot["Meta"], 
      Charting`HighlightActionFunction["DynamicHighlight", {{{{}, {}, 
          Annotation[{
            Directive[
             Opacity[1.], 
             RGBColor[0.368417, 0.506779, 0.709798], 
             AbsoluteThickness[2]], 
            Line[CompressedData["
1:eJwVzns0lAkABfCJlJY2s0Ue0zIikSKGoux3Cd+0ckqMxzBm5uuITa0kjzy2
RdbxqHbRVKiTRx7lUciQXhMRRUyt6BQJo1alpTwSdvaPe+75nXP/uEwqZG+A
Ao1Gc5Xn/47nDhIZEx4oiQmxPqkiIzJ2VO9989kDk076R6c0ZUS+aWKAxaQH
9IcGJIHrZETTvH6adNoD0bXDIq69jFhSQHX/MO+Bil8yglIiZUT66MDBTGUO
bt5XFy8flhHnYl+fz1rDQclCaICkaYS4dvHVhIjkwO/KR1Pvs++IoCVfesvy
OVA0XiV6NPKBYGVYJdZPcRBR69K3zupfYtg+Z5WOiyc6OOvfF5VOELrqP/ac
vOwJ1Ax/eHpxkjik2uY/NeMJJ+G+r2T5DOFolLn6CMcLrEWXTG085wja/vg6
+0ovfG5ui4wuoqHz4TmGsqI37pl51/iWKcB4d3tVP88b66UBx5LpShDNmKhW
VHmDtnZuQTd+Kd62lLt2KfmA29zjOq7xHRrrXSVKAh8UGlAKgXrLUfVEY9q8
xgdPK86qGGmqwWTZnODQCi6K/hnR5b2hI3m/ctV8EBf6Kcop21tWYnpke/Mf
t7g4samnqeyqOsbTT6nqrfZF6Tds9etbDZrnMo1rwb64Ene/KEZNG2cd8tzc
WnzhWrmslp7DwEp3/3CS6YdGiXjuraMuCpId/Vjhfrjs/iYz9LMebvWT4Rad
fhgyT84KPqaPd75H3YwMeVChG9oWfF2L2dkH6qFRPGivTJDWpBhCdJel+ljK
w0zMvf5f3Y3gVPz4wRojf9T6zKZkaxgjrir++u8J/sh5JmLmaG9A9oBv0taX
/ji8JEjM37wRj1h8xogZH5xdGfmMn8yQdPX4cFEqHy6sjlynNnO4O7eG8vr5
uNC871vE2GYkKjDCWFoChLZYRjoxLJE3IWx2cBbg04Jak8kRFlojtsfsOiyA
etd7FfN7VriRZtjad0GAny21ColtW3DVoiDq4EMBfovKUrhevhVZwZa5BuMC
sBKSxl6st4WDtdQ7QFcIzbGcruzubZjJUIrM2ynEpY3aDanH7BAeT27aHymE
Sr+OW6Q7gaFFuT6cQiFuv9J/0p0L8FYlyYgO+d4kvu5wij2y62JVq2eFCOys
FCmeccDAR+Us5joKavRB2fHzO6AjLj59czcFO428mJ0FjtCicwxexlLQ6+Wf
ZHU6gTkn0p4pohAUcbqlctIZrNd3DG8UUwiwDmv9MusM50aZeWgJBaux73Xs
FpEITrEm35VSeB7uWfNEhcQN9e6w3jIKixtGny1mkti5Sb29vorCwnicoNKF
RCg/83j0HQq9Lh4a3/JInHBoSLW+S+FDzmKbsGISIsPBM+NyX1yhpPy+jETD
qEXZAQmF9tiYExfEJJSipD3cJgofX1w75fOYxPk/6Rbb2igcyB3zMpwmURZm
YzclN+WVmZY/R+KOp5Bd/Uj+Z1w6r6fIxiDjuv+Gdgqm5bH1zO/Z2Fi6J02n
k0JfiZaDpQEbSI8SPZd7qU38lgZjNvaGXMrL7KJQbWRb52jGRqTVJ7HKUwoJ
f0lu+9mykaqp2dgid0lhdPoowUbuLNGR+IxCSDYrLdaJjYq+wF7ibwpxRlxz
NRc2JJLTQ7Ny94hL7hfsYeM/Hx8u/g==
             "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
       "HighlightElements" -> <|
         "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
        "LayoutOptions" -> <|
         "PlotRange" -> {{83.8058, 150.687}, {0., 48.629997570402054`}}, 
          "Frame" -> {{True, True}, {True, True}}, 
          "AxesOrigin" -> {83.8058, 0.68891}, 
          "ImageSize" -> {400, 400/GoldenRatio}, "Axes" -> {True, True}, 
          "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
          "DefaultStyle" -> {
            Directive[
             Opacity[1.], 
             RGBColor[0.368417, 0.506779, 0.709798], 
             AbsoluteThickness[2]]}, 
          "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
              Identity[
               Part[#, 1]], 
              Identity[
               Part[#, 2]]}& ), 
            "ScalingFunctions" -> {{Identity, Identity}, {
              Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>,
         "Meta" -> <|
         "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
          Plot, "GroupHighlight" -> False|>|>]]& )[<|
      "HighlightElements" -> <|
        "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
       "LayoutOptions" -> <|
        "PlotRange" -> {{83.8058, 150.687}, {0., 48.629997570402054`}}, 
         "Frame" -> {{True, True}, {True, True}}, 
         "AxesOrigin" -> {83.8058, 0.68891}, 
         "ImageSize" -> {400, 400/GoldenRatio}, "Axes" -> {True, True}, 
         "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
         "DefaultStyle" -> {
           Directive[
            Opacity[1.], 
            RGBColor[0.368417, 0.506779, 0.709798], 
            AbsoluteThickness[2]]}, 
         "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
             Identity[
              Part[#, 1]], 
             Identity[
              Part[#, 2]]}& ), 
           "ScalingFunctions" -> {{Identity, Identity}, {
             Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>, 
       "Meta" -> <|
        "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
         Plot, "GroupHighlight" -> False|>|>],
     ImageSizeCache->{{4.503599627370496*^15, -4.503599627370496*^15}, {
      4.503599627370496*^15, -4.503599627370496*^15}}]},
   Annotation[{{{{}, {}, 
       Annotation[{
         Directive[
          Opacity[1.], 
          RGBColor[0.368417, 0.506779, 0.709798], 
          AbsoluteThickness[2]], 
         Line[CompressedData["
1:eJwVzns0lAkABfCJlJY2s0Ue0zIikSKGoux3Cd+0ckqMxzBm5uuITa0kjzy2
RdbxqHbRVKiTRx7lUciQXhMRRUyt6BQJo1alpTwSdvaPe+75nXP/uEwqZG+A
Ao1Gc5Xn/47nDhIZEx4oiQmxPqkiIzJ2VO9989kDk076R6c0ZUS+aWKAxaQH
9IcGJIHrZETTvH6adNoD0bXDIq69jFhSQHX/MO+Bil8yglIiZUT66MDBTGUO
bt5XFy8flhHnYl+fz1rDQclCaICkaYS4dvHVhIjkwO/KR1Pvs++IoCVfesvy
OVA0XiV6NPKBYGVYJdZPcRBR69K3zupfYtg+Z5WOiyc6OOvfF5VOELrqP/ac
vOwJ1Ax/eHpxkjik2uY/NeMJJ+G+r2T5DOFolLn6CMcLrEWXTG085wja/vg6
+0ovfG5ui4wuoqHz4TmGsqI37pl51/iWKcB4d3tVP88b66UBx5LpShDNmKhW
VHmDtnZuQTd+Kd62lLt2KfmA29zjOq7xHRrrXSVKAh8UGlAKgXrLUfVEY9q8
xgdPK86qGGmqwWTZnODQCi6K/hnR5b2hI3m/ctV8EBf6Kcop21tWYnpke/Mf
t7g4samnqeyqOsbTT6nqrfZF6Tds9etbDZrnMo1rwb64Ene/KEZNG2cd8tzc
WnzhWrmslp7DwEp3/3CS6YdGiXjuraMuCpId/Vjhfrjs/iYz9LMebvWT4Rad
fhgyT84KPqaPd75H3YwMeVChG9oWfF2L2dkH6qFRPGivTJDWpBhCdJel+ljK
w0zMvf5f3Y3gVPz4wRojf9T6zKZkaxgjrir++u8J/sh5JmLmaG9A9oBv0taX
/ji8JEjM37wRj1h8xogZH5xdGfmMn8yQdPX4cFEqHy6sjlynNnO4O7eG8vr5
uNC871vE2GYkKjDCWFoChLZYRjoxLJE3IWx2cBbg04Jak8kRFlojtsfsOiyA
etd7FfN7VriRZtjad0GAny21ColtW3DVoiDq4EMBfovKUrhevhVZwZa5BuMC
sBKSxl6st4WDtdQ7QFcIzbGcruzubZjJUIrM2ynEpY3aDanH7BAeT27aHymE
Sr+OW6Q7gaFFuT6cQiFuv9J/0p0L8FYlyYgO+d4kvu5wij2y62JVq2eFCOys
FCmeccDAR+Us5joKavRB2fHzO6AjLj59czcFO428mJ0FjtCicwxexlLQ6+Wf
ZHU6gTkn0p4pohAUcbqlctIZrNd3DG8UUwiwDmv9MusM50aZeWgJBaux73Xs
FpEITrEm35VSeB7uWfNEhcQN9e6w3jIKixtGny1mkti5Sb29vorCwnicoNKF
RCg/83j0HQq9Lh4a3/JInHBoSLW+S+FDzmKbsGISIsPBM+NyX1yhpPy+jETD
qEXZAQmF9tiYExfEJJSipD3cJgofX1w75fOYxPk/6Rbb2igcyB3zMpwmURZm
YzclN+WVmZY/R+KOp5Bd/Uj+Z1w6r6fIxiDjuv+Gdgqm5bH1zO/Z2Fi6J02n
k0JfiZaDpQEbSI8SPZd7qU38lgZjNvaGXMrL7KJQbWRb52jGRqTVJ7HKUwoJ
f0lu+9mykaqp2dgid0lhdPoowUbuLNGR+IxCSDYrLdaJjYq+wF7ibwpxRlxz
NRc2JJLTQ7Ny94hL7hfsYeM/Hx8u/g==
          "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
    "HighlightElements" -> <|
      "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
     "LayoutOptions" -> <|
      "PlotRange" -> {{83.8058, 150.687}, {0., 48.629997570402054`}}, 
       "Frame" -> {{True, True}, {True, True}}, 
       "AxesOrigin" -> {83.8058, 0.68891}, 
       "ImageSize" -> {400, 400/GoldenRatio}, "Axes" -> {True, True}, 
       "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), "DefaultStyle" -> {
         Directive[
          Opacity[1.], 
          RGBColor[0.368417, 0.506779, 0.709798], 
          AbsoluteThickness[2]]}, 
       "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
           Identity[
            Part[#, 1]], 
           Identity[
            Part[#, 2]]}& ), 
         "ScalingFunctions" -> {{Identity, Identity}, {Identity, Identity}}|>,
        "Primitives" -> {}, "GCFlag" -> False|>, 
     "Meta" -> <|
      "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
       Plot, "GroupHighlight" -> False|>|>, "DynamicHighlight"]],
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{83.8058, 0.68891},
  DisplayFunction->Identity,
  Epilog->{
    RGBColor[1, 0, 0], PointSize -> Medium, 
    PointBox[{87.30146199987604, 1.01325}], 
    InsetBox[
     FormBox[
     "\"\\!\\(\\*SubscriptBox[\\(T\\), \\(b\\)]\\)\"", TraditionalForm], {
     87.30146199987604, 4}]},
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{
     FormBox[
      TagBox[
       TemplateBox[{"P", "\"bar\"", "bars", "\"Bars\""}, "QuantityTF", 
        SyntaxForm -> Mod], HoldForm], TraditionalForm], None}, {
     FormBox[
      TagBox[
       TemplateBox[{
         TagBox[
          TagBox["T", HoldForm], HoldForm], "\"K\"", "kelvins", 
         "\"Kelvins\""}, "QuantityTF", SyntaxForm -> Mod], HoldForm], 
      TraditionalForm], None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  ImageSize->400,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{83.8058, 150.687}, {0., 48.629997570402054`}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellLabel->"Out[6]=",
 CellID->145587344,ExpressionUUID->"da9236f1-0e36-4813-85d9-5d752a71fbc0"]
}, Open  ]],

Cell["Using WolframAlpha", "ExampleText",
 CellID->351008126,ExpressionUUID->"aa006b94-dafe-4b29-9c6f-21be49814bbe"],

Cell[CellGroupData[{

Cell[BoxData[
 NamespaceBox["WolframAlphaQueryResults",
  DynamicModuleBox[{Typeset`q$$ = "saturation curve of argon", 
   Typeset`opts$$ = {
   AppearanceElements -> {"Extrusion", "Warnings", "Assumptions", "Pods"}, 
    Asynchronous -> All, 
    Method -> {
     "ExtrusionChosen" -> {"Result", "Result", 1, 1, "Content"}, 
      "ExtrusionOpen" -> True, 
      "Formats" -> {"cell", "minput", "moutput", "msound", "dataformats"}}}, 
   Typeset`elements$$ = {"Extrusion", "Warnings", "Assumptions", "Pods"}, 
   Typeset`pod1$$ = XMLElement[
   "pod", {"title" -> "Input interpretation", "scanner" -> "Identity", "id" -> 
     "Input", "position" -> "100", "error" -> "false", "numsubpods" -> "1"}, {
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement["cell", {"compressed" -> False, "string" -> True}, {
         Cell[
          BoxData[
           FormBox[
            TagBox[
             FormBox[
              TagBox[
               GridBox[{{
                  PaneBox[
                   StyleBox[
                    TagBox[
                    GridBox[{{
                    StyleBox[
                    TagBox[
                    TagBox["\"argon\"", 
                    $CellContext`TagBoxWrapper[
                    "Entity" -> {ChemicalData, "Argon"}]], Identity], {
                    LineIndent -> 0, LineSpacing -> {0.9, 0, 1.5}}], 
                    "\"saturation curve\""}}, GridBoxBackground -> {"Columns" -> {
                    GrayLevel[0.949], None}, "Rows" -> {{None}}}, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    ColumnsEqual -> False, RowsEqual -> False, 
                    GridBoxDividers -> {"Columns" -> {
                    GrayLevel[0.84], 
                    GrayLevel[0.84], 
                    GrayLevel[0.84]}, "Rows" -> {{
                    GrayLevel[0.84]}}, 
                    "RowsIndexed" -> {
                    1 -> GrayLevel[0.84], -1 -> GrayLevel[0.84]}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {1, 1, 1}, "Rows" -> {{0.3}}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Baseline}}}, 
                    AllowScriptLevelChange -> False, BaselinePosition -> 1], 
                    $CellContext`TagBoxWrapper["Separator" -> " | "]], 
                    LineSpacing -> {1, 0, 1.5}, LineIndent -> 0], 
                   BaselinePosition -> Center]}}, 
                GridBoxItemSize -> {
                 "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                ColumnsEqual -> False, RowsEqual -> False, 
                GridBoxSpacings -> {"Columns" -> {{
                    AbsoluteThickness[-1]}}, "Rows" -> {{0}}}, 
                AllowScriptLevelChange -> False], 
               $CellContext`TagBoxWrapper["Separator" -> " | "]], 
              TraditionalForm], 
             PolynomialForm[#, TraditionalOrder -> False]& ], 
            TraditionalForm]], "Output"]}], 
       XMLElement[
       "dataformats", {}, {"plaintext,computabledata,formatteddata"}]}]}], 
   Typeset`pod2$$ = XMLElement[
   "pod", {"title" -> "Result", "scanner" -> "Data", "id" -> "Result", 
     "position" -> "200", "error" -> "false", "numsubpods" -> "1", "primary" -> 
     "true"}, {
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement["cell", {"compressed" -> True, "string" -> False}, {
         Cell[
          BoxData[
           FormBox[
            GraphicsBox[{
              RGBColor[
              0.9921487999999999, 0.8385818666666667, 0.6927381333333333], 
              PolygonBox[CompressedData["
1:eJxF12k4VP//x3EShRLNPhiDSpuSylLhVbYWSjizWGdGKEskbYpKSaSyVaKk
KLK2yVKRlBb0VaQIFYqkLCUh+p3/rf+tcz2uc811znNunM/7rSkJsPecJCUl
5S8tJfV/V3XZ79I+/xxRkWq9s8yDguXdqlPtFAlIO9OuLPenoLnC8bIFgwAY
HXW5uynwF+/qstYmcKj+xj/tQxScKEr4JVxMoPx02KKUKApW8ibaQ1YS+LfB
xnVmAgXtA6tqs60JmE5lx0RdoIDVofzyqwOBsMddpVLXKEi6vkvKSETgwaHC
r3sKKDAMvHzwjB+B8VVHmH3FFOyKk/WetI/AqhE7a69HFCSqb3odFkHgQCFn
d2s1BS9E3q0K8QTu7ejNcHxDQZpvcMa1VAJjuqX11W0UFCU3mdvnEFjREznJ
vJuCaq7Ru+nFBEKuEUtKByiQjwsIa3pMoESiLVoyRoHYJ9Wh8BWBEc7AqazJ
VKSka+263EbA6H3ZAw0lKpqNkqVSvxHYey6m9yyDisCSDkrOHwJFDk6qSppU
ZDdyap/J8jA8Y+76iPlUTP2Vu354Jg8GNUN7/y6lIqxoSY4Bl4fdxyszd5pQ
oZSSMD1Sl4dCi7jGHisqIg/+je1ewcOQlLusxI4Kplmzo/NaHpY9WLisSUjF
o9Uf9n4geAjeNyqx86CiWkVGfZcHD7eXP4t76kfFnoFwsdoOHn4OnHloupsK
9x3tXm/CeNDP9+grPEiFy5Re27QYHoJ8lnB0o6iQuXbTMDSZh5tz/tlkxFOR
T5y09MviYaC9Zr/qBSqMazXP+9/lQe9Scnb8VSoSFJ0dDz/mIdB5a5N8ARXC
we3nM1/zUMAwmHq4mIoPH1ujP37koa9exvBPBRUGm3ZuWNjHw6LYV54B1VSU
+lhNRI/zsN3mUuKXBip0bpVW/VXkI2+qf6VrGxW18YeeHWbz0ft4xWBDFxXF
smd12PP4WHh4qqbNABUPdK2nVhny4WfSuKlylPx/hhadjrDiI2ckPWzFZBoW
5xp+EhB89BTuyLs5nYbOzBRtbOFjfpBZy1wGDZEfP+9fuZOPbYumK6ZxaWiO
HZyxIZyP6z3Nxoz5NCQ29MkGxPHRfS1r66mlNMivdTuamcbHXI/d52RNaCi+
pnLrVwEf3hoWVQesaNjms+Qur5yPzPcqQz830ZC7zbi49iUfX8590PYV0hCz
e/SDsI2POY559u0SGhL+JhNj3/nwVN5/WOhHw9HUc6tvjfNxtWbtjbpdNJTW
V9aETReg8zj9g/VBGl4dXc8Vqwswy7JzevlxGrIy8z2FugJ4SN9aZRBPQ1lz
dZW3iQDpDw765qXQEPWv0T/GVoD2fbbJs67S0F/vFvHUVQAtA9XnKfk0nI+2
MWJtF0A82D08s5gGc0nnzcNhAlzOvzsnuoIGt5VV6tKnBfjoc5SQrqbh0cIf
mecuCcDVsT+6t4GGEVrhAcsbArh3aNzua6WhQ+/VM4UKAS5d+v7Jq4sG6zRe
SdcrAdqc7ym39dNAjBftb2kXgMOMMiNGaQhorzL5+lMA1wbe9hoZOkJ23tFV
khXiYuysi+bT6ajtUAnZQBeixWawupROx/WRus2XdYRQk384uoRLx7GTFp0z
jIVwfnJy3vV5dJRN0RSfWy9EymFnAXcp+fumA38MXYRoNpkXeW4VHRU/65oH
/IVgj/4uVLKi46DBiNGTg0II7z7ujNhEh/WnZRa34oRICoqnjAvoaB6ds6gk
XYh3i0RrgiV0tBQ2zm0uFIL5TXfHN186JHUFXrRnQvAzxy5JdtGR+j2c7dss
xFmP5y+bwuhw7InY875XiEaNc+N2x+nIm+940+ufEPSWLQufxdHxuO3H2LSZ
TiCS9J3NUsj33/zgxMtZTkh0lIq+m0HHAYWTZ3IMndCg/LJYN5+Oq8rxGzPW
O4FSm9KVUUQHV9m7t9jVCQ5R2+hqFXSohky/+jXQCfGWhpYJL+i4cOF7vsFR
J7yWlg1WaKCju6ARaeecoFL2+srhVjqojRNxc3KcsDkk7dWfL3Q0aMg0Py9z
QqzBdqnAfjrSfLrsol87oW5w5eKuETqE6+iLt35xwowCeTc3GQZsGkV5HqNO
2OT7NubNNAbe7p2YHKrkjFM6V+/Z0BmQuxgTcEfLGS87gnoqNRjwd1bSUTB0
xvQ0sFbOY0BRpdczbIMzbF2U1t7SZ2Dn50EvFZEzYpgtu+etYuCTmaNnZbAz
ahquX02zZKBa5+qFxChnKMbtaWBsYkA6vnVtRKozNthaypwWMDA/iX/tzG1n
RMtT9OUkDKw//3LgyTNnvHjyURTqy0D8Gret9DZnyIfnn/4VzMCBsMPWkT+d
sc70QJlvGAOH16nUMuVdcHx03ff2SLJnm7lhNccFz+4y1JziGDgkf/1x6jIX
TNn5ef2rZAbe6OneSVjvAuvFt/etzWDgEodimS1ywbFvh7LK8xi4Hvrrbvtu
F1RlbnxrUMRAxM7ydSYnXSC7RU0u/yEDClF3TErTXWDB7Vk2+wUDUt5b6oWl
LjjaUuRxoZ4BR++8DWqvXPA4KSKe0srAzd/FXdLdLpAhHCqivzDwvfJPt8I/
F6xR0eyX7megoFQ7zpDuivDaH5x9Iwx0P9HXOq7rikdR9237JzERz3Nt+2vh
Cmmr6APe05gozKFNPeviCkwS5LTRmBhvnNzuEOyKQ2WzmwkN0iFyBQYxrngY
8nNq7VwmfExm3TLNcMU/gwpDC30mSr/GLvK77wrTn6e87q1kYq9pund5gyvC
ClzO6FsyoSqqSzP67ooy3/mPr29kwvfbVfV3sm4Y1/kzyBUwYXW5UjOV44ZV
nU80k8RMbM1o6I82dMOBtAS7Gb5MBKw5/jLVzg33XcQHjwUzoWcWPdG0zQ1j
zMX546FMxJ0PebzqiBtWvPnbEhzJxNmHnR5PL7ghJO6FYm8sE9a6BtyQu24o
sU1a4ZHMxFLenVVEnRtG5L22NaeT79+346+gxw1GVUuTNucxcczX/ErEZHfs
DZd++uwuE/5ZtwLfc9xRZPrfkNlDJqIfDVx3MnbH8OiFWUXPmYj8WXNaxtEd
BkU+DovqmQgOTPFo3O6O3TuNwq+2MBGrv9irPsodhYvlbqp9YUIpqfLtaIY7
hr7Vf0joY0L2ac+wzUN3LMu6rKQ4QvaW7ZN98d4dwVsCTMInseA5HmQaNOyO
21wTvxFFFtTfDPddkRfhZ4tCSiCNBeppmYQrDBH0z7973sVhodi1eXbxbBGC
iGt/3Oay4DDs+qRjqQg3VYJ1Gpew0Kr65OTsNSIM1K7m2a5kYSjqRHKonQh6
0TMiHluwkFYjkut1EyHQqvX2yo0smFXRvgX6i1AwKaf9Fp8FtXfHxdMOiPCj
bK/KfDELAQdjD5dFi7BovxUu+7CQaNQpjjwvwnZDagAzmIVlO2SY3lki5P38
dPF0KAs9luxi1yIRegsKauQiWai51+HoWyXCQr/QsdBYFuYwov6dfiOC39wN
84fOs5DfGvq0ulOEnE6m0C+dBck4v5TzS4SetC+RHbksOO9O7zguI8Z81zt3
ne6yUPbkho0CRQwfVvjnV+UsZM91/XtFS4zrbzZR1z1n4XdK/W97fTG649TN
H75mIWO1pQl7jRhzN37bYdjCQlvEudo/m8XYqlCSlv+ZfP647JUfYjEyq479
N7uPhdyQwhtjO8T4Eu44ceEPC8v1ln/TCBdjjpmWLnUSG/G/vpo4x4vhNdbn
fEKRjcPJbqfzrohxtehB9CQaG1OHgsrpt8Xo3HmiZB+HjVQD8bWzlWLM0hN2
9+uw0fLyFEW3QQyP3jmMrUvI+x7smqZOMdKzfll+WMGGVCwl6sKQGO1bHgXz
LNiY+LN6KFhOAi3N2PRaWzbCX/CyJQwJxK2ury34bBwvd9D1nCvB5fMLpO+L
2Og/1/R1v7EEH4mRxUt92Ahy/rLg2noJuDOfumXvZKNG0ZzR4SyB+8vEk5qh
bFRFCVOW+EtwKVpyP+kYG72lbHFsmARtVnrfZsSyMeWVcf74aQk4MhOsyPNs
aLLf6u+5LIFrefXaiStsqL+Ylz5yS4KL+8/v2ZXLRoxxdebBxxK0GHpf6y1k
w+KEX9fYGwnUfi1741H+/87xHTzBTdaC52n3Kf7JEtRQvGwbJrhY3Tpr1zUz
CRqaYo56/+TiZb9xYES3GK2Xbt8b7eLiZOc8YXeiGJ89mwdPtnBR/l03N99C
jB8LpOdrvuJi38VHv4uHRfg9oCO+84SLXW/La7vzRPhXtDHJupQL/5QflVxv
EaaG7fqvOZ+LwesMsYW2CMoWF+S2p3NB6VVcGvjYHUyFShPpJC6GDvadeGTt
Ds26r8GJMVwssBo0tCG/L/PPKufqHObCPs3S9r2rG/RdDDtKd3GxwTLgoFm/
K1ZoubE3+nCxNdBw5vpIV5h3H938yY2LVVvMamu1XGGTn3M82IGL5AvL+1Mf
ucAx+HX5lLVc3J51USfBywWuK0Z+J6/i4nWBevhhJRd4SnEXLVrChZ2Nvdea
Umdsr7LyrJjNxY2aaVEF25yxO8b/giObCxOnyZ3pas44aJ9Y36XEhWjyl9wx
8nyPZN5T2C/DhTC2zCYxxgncB5VH1Po1MNOikG+zzgl661QG1zRpoKtnRoSM
vBPWvHETbXukAc77vZnJ1ULYi3Nfns7RQJjDoas/Y4XY8n1k1d1EDcSzHIIG
BEJyP7HOaQnVwHBjmtxebSGOyZ5hyXhrYJ9VntCvX4Bzce2R8+w08PZNpNOd
cgGy1PV+bzLWQF+v51eDOAFKrodu2a2lgaizaq/ebxHgxfLq1xcUNWDy7O7D
EysEeF/BXF35i4PoSXMs9WYK0GvrVfC1lQPFXYqVt7/xMd50W135KQcVK5MC
pZ/yoeQlHWNwg4PC7CObZDP40BjcOOpynoPOQbpOLjn/64Vd2HoknAPfItuw
DgkfqxV6Gq/7cqDqp3j2vAUf9mcNLescOfA45enxQIcPD62I279NONgxMina
dBofwfmvNdV1OODdi+VNH+Th2ApurLkyBx/7bErYTTycrfKf2DaijnkrsyCo
4CHL/p5fbLs6zE5OUIqzeShum/r+brU69D55/1h4hocXPrx1rXfUMSf3Miv7
EA/Nv9OLZFLVIbqhsk3bn4fe8IHZ8yPVsfNj+7KTTjz8VTJLtAtUh9bwKqKF
3BeVUmIm7RGq44jwnLqcEQ8cnebAi2vU8aNaRyA1l9znbut8qFygjrcB/qsr
mDzAbJdtD1UdpwPeHTFT4MG++tE95Qk1VGedWhr0l4AHX3m+YZcaZifavrDr
IxDc4ZrkWqcGzYRt2vXtBCICcuSOlqiBuNezZ6CRwNmxP8HZV9SwRfOpU0Y1
gcxIq466E2p4mbiisPMhgWJK4ubhYDUkZq+szLlL4PmlT+XqbmpY8nm68s9c
As0LFi+ysFbDgqL+oDvpBL4VHbjgo6cGeeVvij3JBP6av1CIY6lBgXYbp8j9
f3odY1/RJDVop9wsSYkmwHHx7Gr9poqAXq779CME9LpvEZPfqMJaaMVr208A
wVKP55ep4tG0qgn5XQTspTbqb85UxfpE5f4T2wlIYlLS9sSq4saRr7/dt5K9
zK9KqftUMTVZjhIuIXA0wyD0sUQVtlVVwT9cyF69o996NqhCe6vU/st8Atfu
vxKqLFfFp9lfbpyzJ3vXajwz5KhiX4F0Ta0t2dvgZ+A2RRXXH5tnYx3ZKyrN
ONrPRkjDXLvvFmRv7xRKThMbDjEDX+pA9u4lDr96xIZc/o/S7lVkr2x633AO
G6VHPxjrG5O9cf2unDPkeeQgGcheTmCxummNRRh5frB3n7TTJ3uvn1jh683G
32nT33IXE9i8vCkrzo6NF3MKbrEWkr0VcxjFxmx46i/UMJ5HYKdtcESbFhuX
S12Whc4he5sqfk6exgZ73YBmpzaBM54zJAuGWPjnsWmRnybZO+BSt7mNhZNl
+wspGgSKQrNN9z5lYWCmytwmNQLP5P/kpt5gYaamucI9NoGmM5aqT8jzXnXz
98EiJoEezYSob+Es7A3NjX5JJzCW93FYxY+FLh+ZE+NUAtNWLPIyIljYHxL1
wJxC9lbtb3AzZeHgLO2xSyoEFtk/XxOhw0Lmf+YLVJTJ3jb6zRxlFpJSjMzP
KhGw89mi8Zqct9pL9lsumk72/r558k87E/xfM1a/UyQQFP5vjFPDxMSkTrsE
BbJXydbHspAJDYFJips82Zuc/M43lYlyxfmbjaeSvXO6reLJ+fNnwkie1hSy
99bywuJAcp4bvfebJUf2mh7R/iBkQsv86T6OLNn7oi5O1pyJotI1pxZPJnt5
HKmFC8l5+0tRgo0M2dvuu92enMfXNmYNBE8iewNKWvZOMLDn5AJGljQB9TG5
DZe6GBDxo0M+S5G9kY4lT+oYKCvtTlpI2oxyRae3hIGEtt6hA/8cYXep78zM
dAYCdPxVGyccIV5gMtk4hkF+FzXPG5IOKooOct/FwNp4p8mXxx1xxPzdxwg3
BpJERcMqpBP/m70p15qBLe6fZ0b/dcRV550PXusx0HnObXQq6btdDxeMsBjQ
mKbLPzXmiKc7lZI1yP1Q/+GNRhbpd/+cp1r10nHu4tb5OaOO6DlxfbffG3K/
nlY2ZQ3pUcZwZ3wZnTzf6nXaRhwxLcPCoSSTjiZbB+uDpNX14is+xNIRYGI1
ZzbpRfc/LJYLoSN97ufI//44wmytbupCDzp+0YL0w0jbNYRMc7Ah9/slKn16
pMWiZyH7ltOxRTEjqmuY7O2lfb3EoeNf5rW6y6SP7PXgV02hY8cGpTPupBMn
33zS209DdM+8bC7pq7ETSynNNPAWHv3c+ZvsVbO5YlxJw4/uKk4u6adZ55VF
uTRsnpm2eDfpd8u6wo6doUHud+bPNaS/Plz2PTeMhtYna9fOJD1qE+5c703D
VkHmtM4hRyg2/fd8xI6GWSonNYtJq3mqG3FX0KDdbr/tFGndAZ9rVto00IS1
T71Im4YWU/2n0ZCfbay1mvQmebkjCUNUBBYscFcnLTrjMFDSRoVb1QGvsV+O
2KF52f3jUyr+xK3UfE86PO9HrdxNKiRHL+y7TzrBeNUq3WQqjJZ8c7pEOuNJ
VLbDESosnA7cPEL67ua3zBA/Ku7np/lsI/20dVZkGkE+b2lSsB3pd9uChqpM
qRjfcKzMiPTXoXKP7zpUlLp4GWmRHj08/TVFhYrBcan6aaQVlZyxYpSCWSWf
Dv75SfYmZ+WLOijwXWe75DNp3Tm/1SJrKPAQGDW/Jm16y/xEXiEF92+abq8g
vck0bqQ+lYKhL8mfbpAWvWjzHo2kwM2NM+8y6R28hY3cHRT8D+cT/OU=
               "]], 
              RGBColor[0.998154, 0.933974, 0.820264], 
              
              PolygonBox[{{34.70799139519819, -2.}, {
                34.91252718895768, -1.9316183751118894`}, {
                35.119487950742865`, -1.8632367502237785`}, {
                35.328917063246706`, -1.794855125335668}, {
                35.540858950182624`, -1.7264735004475573`}, {
                35.75535910770126, -1.6580918755594465`}, {
                35.97246413695107, -1.5897102506713359`}, {
                36.19222177783202, -1.5213286257832253`}, {
                36.414680943993716`, -1.4529470008951146`}, {
                36.63989175913207, -1.3845653760070038`}, {
                36.867905594640966`, -1.3161837511188932`}, {
                37.0987751086786, -1.2478021262307823`}, {
                37.332554286710696`, -1.1794205013426717`}, {
                37.569298483596334`, -1.1110388764545611`}, {
                37.809064467285246`, -1.0426572515664505`}, {
                38.05191046419911, -0.9742756266783397}, {
                38.29789620637293, -0.905894001790229}, {
                38.54708298043684, -0.8375123769021184}, {
                38.79953367852254, -0.7691307520140076}, {
                39.055312851183345`, -0.700749127125897}, {
                39.314486762421225`, -0.6323675022377864}, {
                39.57712344691951, -0.5639858773496755}, {
                39.84329276958502, -0.4956042524615649}, {
                40.11306648750908, -0.4272226275734543}, {
                40.386518314039954`, -0.35884100268534347`}, {
                40.663723987931604`, -0.29045937779723285`}, {
                40.94476133961909, -0.22207775290912224`}, {
                41.22971036722177, -0.15369612802101162`}, {
                41.5186533113407, -0.08531450313290079}, {
                41.81167473420561, -0.016932878244790173`}, {
                42.10886160219837, 0.051448746643320664`}, {42.41030337204617,
                 0.11983037153143128`}, {42.716092080228236`, 
                0.1882119964195419}, {43.02632243742715, 
                0.2565936213076525}, {43.341091925239034`, 
                0.3249752461957631}, {43.660500899258196`, 
                0.39335687108387374`}, {43.98465269530023, 
                0.4617384959719848}, {44.31365374092918, 
                0.5301201208600954}, {44.64761367204745, 0.598501745748206}, {
                44.98664545454281, 0.6668833706363166}, {45.33086551184171, 
                0.7352649955244273}, {45.68039385814082, 
                0.8036466204125379}, {46.035354237925965`, 
                0.8720282453006489}, {46.395874272039705`, 
                0.9404098701887595}, {46.76208561066557, 
                1.0087914950768702`}, {47.134124093594, 
                1.0771731199649808`}, {47.51212991831981, 
                1.1455547448530914`}, {47.8962478160144, 1.213936369741202}, {
                48.28662723643945, 1.282317994629313}, {48.68342254176519, 
                1.3506996195174237`}, {49.086793210084316`, 
                1.4190812444055343`}, {49.49690404912585, 
                1.487462869293645}, {49.91392542077174, 
                1.5558444941817555`}, {50.33803347701921, 
                1.6242261190698661`}, {50.76941040807576, 
                1.6926077439579768`}, {51.20824470332086, 
                1.7609893688460878`}, {51.65473142591951, 
                1.8293709937341984`}, {52.109072501928544`, 
                1.897752618622309}, {52.571477024795655`, 
                1.9661342435104197`}, {53.0421615762158, 
                2.0345158683985307`}, {53.52135056437972, 
                2.1028974932866413`}, {54.0092765807242, 2.171279118174752}, {
                54.50618077637429, 2.2396607430628626`}, {55.01231325956622, 
                2.308042367950973}, {55.527933515403895`, 
                2.376423992839084}, {56.05331084946308, 
                2.4448056177271944`}, {56.58872485680818, 
                2.513187242615305}, {57.134465918150845`, 
                2.5815688675034156`}, {57.69083572499793, 
                2.6499504923915262`}, {58.25814783578402, 
                2.718332117279637}, {58.83672826514298, 
                2.7867137421677475`}, {59.42691610864493, 
                2.855095367055859}, {60.02906420551456, 
                2.9234769919439696`}, {60.64353984205222, 2.99185861683208}, {
                61.27072549870421, 3.060240241720191}, {61.911019643975656`, 
                3.1286218666083014`}, {62.56483757864846, 
                3.197003491496412}, {63.232612334063035`, 
                3.2653851163845227`}, {63.91479562854651, 
                3.3337667412726333`}, {64.61185888642648, 
                3.402148366160744}, {65.32429432446114, 
                3.4705299910488545`}, {66.05261611094704, 
                3.538911615936965}, {66.79736160324089, 
                3.6072932408250757`}, {67.55909266995438, 
                3.6756748657131864`}, {68.33839710465976, 
                3.744056490601298}, {69.13589013858054, 
                3.8124381154894085`}, {69.95221606044987, 
                3.880819740377519}, {70.78804995249891, 
                3.9492013652656297`}, {71.64409955240707, 4.01758299015374}, {
                72.52110725200659, 4.085964615041851}, {73.41985224460542, 
                4.1543462399299615`}, {74.34115283398269, 
                4.222727864818072}, {75.28586891943837, 4.291109489706183}, {
                76.2549046727596, 4.359491114594293}, {77.2492114246207, 
                4.427872739482404}, {78.26979077978572, 4.496254364370515}, {
                79.3176979825564, 4.564635989258626}, {80.39404555623624, 
                4.633017614146737}, {81.50000724299854, 4.701399239034847}, {
                82.63682227348902, 4.769780863922958}, {83.8058, 
                4.838162488879449}, {83.99084518572313, 4.847406197782846}, {
                84.1767597458391, 4.856649906686244}, {84.36356385495256, 
                4.865893615589641}, {84.5512636801047, 4.875137324493039}, {
                84.7398654406117, 4.884381033396436}, {84.92937540853102, 
                4.893624742299834}, {85.11979990913053, 4.902868451203231}, {
                85.31114532136088, 4.912112160106629}, {85.50341807833172, 
                4.921355869010026}, {85.69662466779197, 4.930599577913424}, {
                85.89077163261193, 4.939843286816821}, {86.0858655712712, 
                4.949086995720219}, {86.28191313834682, 4.958330704623616}, {
                86.47892104500943, 4.9675744135270135`}, {86.67689605951715, 
                4.97681812243041}, {86.8758450077177, 4.986061831333808}, {
                87.07577477355166, 4.995305540237205}, {87.27669229955929, 
                5.004549249140603}, {87.47860458739017, 5.013792958044}, {
                87.681518698318, 5.023036666947398}, {87.8854417537566, 
                5.032280375850795}, {88.09038093577934, 5.041524084754193}, {
                88.29634348764387, 5.05076779365759}, {88.50333671431687, 
                5.060011502560988}, {88.71136798300378, 5.069255211464385}, {
                88.92044472368262, 5.078498920367783}, {89.13057442963725, 
                5.08774262927118}, {89.3417646579974, 5.0969863381745775`}, {
                89.55402303027874, 5.1062300470779745`}, {89.76735723292755, 
                5.115473755981372}, {89.98177501786766, 5.124717464884769}, {
                90.19728420304949, 5.133961173788167}, {90.41389267300114, 
                5.143204882691564}, {90.63160837938514, 5.152448591594962}, {
                90.8504393415541, 5.161692300498359}, {91.07039364710936, 
                5.170936009401757}, {91.29147945246349, 5.180179718305154}, {
                91.51370498340428, 5.189423427208552}, {91.7370785356587, 
                5.198667136111949}, {91.96160847546244, 5.207910845015347}, {
                92.18730324012778, 5.217154553918744}, {92.41417133861542, 
                5.226398262822141}, {92.64222135210628, 
                5.2356419717255385`}, {92.87146193457643, 
                5.244885680628936}, {93.10190181337055, 5.254129389532333}, {
                93.33354978977944, 5.26337309843573}, {93.56641473961605, 
                5.272616807339128}, {93.80050561379367, 5.281860516242525}, {
                94.03583143890447, 5.291104225145923}, {94.2724013177961, 
                5.30034793404932}, {94.51022443015258, 5.309591642952718}, {
                94.74931003307108, 5.318835351856115}, {94.98966746164082, 
                5.328079060759513}, {95.23130612951962, 5.33732276966291}, {
                95.4742355295113, 5.346566478566308}, {95.71846523414051, 
                5.355810187469705}, {95.96400489622653, 
                5.3650538963731025`}, {96.2108642494558, 
                5.3742976052764995`}, {96.45905310895184, 
                5.383541314179897}, {96.7085813718428, 5.392785023083294}, {
                96.95945901782667, 5.402028731986692}, {97.21169610973278, 
                5.411272440890089}, {97.46530279408012, 5.420516149793487}, {
                97.72028930163141, 5.429759858696884}, {97.97666594794377, 
                5.439003567600282}, {98.23444313391289, 5.448247276503679}, {
                98.49363134631406, 5.457490985407077}, {98.75424115833438, 
                5.466734694310474}, {99.01628323010259, 5.475978403213872}, {
                99.27976830920771, 5.485222112117269}, {99.54470723121388, 
                5.4944658210206665`}, {99.8111109201652, 
                5.5037095299240635`}, {100.07899038908172`, 
                5.512953238827461}, {100.34835674044662`, 
                5.522196947730858}, {100.61922116668451`, 
                5.531440656634256}, {100.89159495062458`, 
                5.540684365537653}, {101.16548946595773`, 
                5.549928074441051}, {101.44091617767772`, 
                5.559171783344448}, {101.71788664250836`, 
                5.568415492247846}, {101.99641250931926`, 
                5.577659201151243}, {102.2765055195242, 5.58690291005464}, {
                102.55817750746374`, 5.596146618958038}, {102.8414404007703, 
                5.605390327861436}, {103.12630622071586`, 
                5.614634036764833}, {103.41278708253819`, 5.62387774566823}, {
                103.70089519574805`, 5.6331214545716275`}, {
                103.99064286441235`, 5.642365163475025}, {104.28204248740354`,
                 5.651608872378422}, {104.57510655868734`, 
                5.660852581281819}, {104.86984766744166`, 
                5.670096290185217}, {105.16627849830782`, 
                5.679339999088614}, {105.46441183151956`, 
                5.688583707992012}, {105.76426054302321`, 
                5.697827416895409}, {106.06583760456346`, 
                5.707071125798807}, {106.36915608373204`, 
                5.716314834702204}, {106.67422914396622`, 
                5.725558543605602}, {106.98107004456625`, 
                5.734802252508999}, {107.28969214057224`, 
                5.744045961412397}, {107.60010888267915`, 
                5.753289670315794}, {107.91233381706951`, 
                5.7625333792191915`}, {108.22638058520111`, 
                5.7717770881225885`}, {108.54226292354369`, 
                5.781020797025986}, {108.8599946632582, 5.790264505929383}, {
                109.17958972981812`, 5.799508214832781}, {109.50106214256611`,
                 5.808751923736178}, {109.82442601420873`, 
                5.817995632639576}, {110.14969555023633`, 
                5.827239341542973}, {110.4768850482724, 5.836483050446371}, {
                110.80600889734401`, 5.845726759349768}, {111.13708157706893`,
                 5.854970468253166}, {111.47011765675623`, 
                5.864214177156563}, {111.80513179441363`, 
                5.873457886059961}, {112.1421387356586, 5.882701594963358}, {
                112.48115331252426`, 5.8919453038667555`}, {
                112.82219044215708`, 5.9011890127701525`}, {
                113.16526512540015`, 5.91043272167355}, {113.51039244525099`, 
                5.919676430576947}, {113.85758756519375`, 
                5.928920139480345}, {114.2068657273904, 5.938163848383742}, {
                114.55824225073243`, 5.947407557287139}, {114.91173252873341`,
                 5.956651266190537}, {115.26735202726314`, 
                5.965894975093935}, {115.62511628210883`, 
                5.975138683997332}, {115.98504089635362`, 
                5.984382392900729}, {116.34714153756316`, 
                5.993626101804127}, {116.7114339347678, 6.002869810707525}, {
                117.0779338752275, 6.012113519610922}, {117.44665720096857`, 
                6.021357228514319}, {117.81761980507504`, 
                6.0306009374177165`}, {118.1908376277242, 
                6.039844646321114}, {118.56632665194562`, 
                6.049088355224511}, {118.94410289909038`, 
                6.058332064127908}, {119.32418242399024`, 
                6.067575773031306}, {119.70658130978738`, 
                6.076819481934704}, {120.09131566241346`, 
                6.086063190838101}, {120.47840160469522`, 
                6.095306899741498}, {120.86785527005998`, 
                6.104550608644896}, {121.25969279581635`, 
                6.113794317548294}, {121.65393031597773`, 
                6.123038026451691}, {122.05058395359653`, 
                6.132281735355088}, {122.44966981257525`, 
                6.141525444258486}, {122.85120396891317`, 
                6.150769153161883}, {123.25520246134765`, 
                6.1600128620652805`}, {123.6616812813435, 
                6.1692565709686775`}, {124.07065636238084`, 
                6.178500279872075}, {124.48214356848776`, 
                6.187743988775472}, {124.89615868195884`, 6.19698769767887}, {
                125.31271739020131`, 6.206231406582267}, {125.73183527164093`,
                 6.215475115485665}, {126.15352778061992`, 
                6.224718824389062}, {126.57781023121808`, 6.23396253329246}, {
                127.00469777991755`, 6.243206242195857}, {127.43420540703822`,
                 6.252449951099255}, {127.86634789685702`, 
                6.261693660002652}, {128.30113981632977`, 6.27093736890605}, {
                128.73859549231622`, 6.280181077809447}, {129.1787289872134, 
                6.2894247867128446`}, {129.62155407288319`, 
                6.2986684956162415`}, {130.06708420274563`, 
                6.307912204519639}, {130.5153324818963, 6.317155913423036}, {
                130.96631163507573`, 6.326399622326434}, {131.42003397229016`,
                 6.335643331229831}, {131.8765113518465, 6.344887040133228}, {
                132.3357551405165, 6.354130749036626}, {132.7977761704866, 
                6.363374457940024}, {133.2625846926909, 6.372618166843421}, {
                133.73019032603708`, 6.381861875746818}, {134.20060200194564`,
                 6.391105584650216}, {134.67382790351365`, 
                6.400349293553614}, {135.14987539847556`, 
                6.409593002457011}, {135.62875096498016`, 
                6.418836711360408}, {136.11046010900722`, 
                6.4280804202638056`}, {136.59500727201333`, 
                6.437324129167203}, {137.08239572711074`, 6.4465678380706}, {
                137.5726274617188, 6.455811546973997}, {138.06570304419176`, 
                6.465055255877395}, {138.56162147135086`, 
                6.474298964780793}, {139.06037999315362`, 6.48354267368419}, {
                139.56197390980867`, 6.492786382587587}, {140.06639633549062`,
                 6.502030091490985}, {140.57363792127995`, 
                6.511273800394383}, {141.08368652798893`, 6.52051750929778}, {
                141.5965268368966, 6.529761218201177}, {142.11213988291723`, 
                6.539004927104575}, {142.63050248996922`, 
                6.548248636007972}, {143.15158658174636`, 6.55749234491137}, {
                143.67535833187867`, 6.5667360538147665`}, {
                144.20177710423735`, 6.575979762718164}, {144.73079411460282`,
                 6.585223471621561}, {145.26235071522774`, 
                6.594467180524959}, {145.79637615679485`, 
                6.603710889428356}, {146.33278460494654`, 
                6.612954598331754}, {146.8714710530752, 6.622198307235151}, {
                147.41230552184987`, 6.631442016138549}, {147.95512442799316`,
                 6.640685725041946}, {148.49971686641967`, 
                6.649929433945344}, {149.04580060970423`, 
                6.659173142848741}, {149.5929733101083, 6.668416851752139}, {
                150.1405829400286, 6.677660560655536}, {150.687, 
                6.686904269558934}, {2999.997, 6.686904269568177}, {
                2999.997, -2}}], 
              RGBColor[0.9888385333333334, 0.7798814666666667, 0.5990192], 
              
              PolygonBox[{{0., -2}, {34.70799139519819, -2.}, {
                34.91252718895768, -1.9316183751118894`}, {
                35.119487950742865`, -1.8632367502237785`}, {
                35.328917063246706`, -1.794855125335668}, {
                35.540858950182624`, -1.7264735004475573`}, {
                35.75535910770126, -1.6580918755594465`}, {
                35.97246413695107, -1.5897102506713359`}, {
                36.19222177783202, -1.5213286257832253`}, {
                36.414680943993716`, -1.4529470008951146`}, {
                36.63989175913207, -1.3845653760070038`}, {
                36.867905594640966`, -1.3161837511188932`}, {
                37.0987751086786, -1.2478021262307823`}, {
                37.332554286710696`, -1.1794205013426717`}, {
                37.569298483596334`, -1.1110388764545611`}, {
                37.809064467285246`, -1.0426572515664505`}, {
                38.05191046419911, -0.9742756266783397}, {
                38.29789620637293, -0.905894001790229}, {
                38.54708298043684, -0.8375123769021184}, {
                38.79953367852254, -0.7691307520140076}, {
                39.055312851183345`, -0.700749127125897}, {
                39.314486762421225`, -0.6323675022377864}, {
                39.57712344691951, -0.5639858773496755}, {
                39.84329276958502, -0.4956042524615649}, {
                40.11306648750908, -0.4272226275734543}, {
                40.386518314039954`, -0.35884100268534347`}, {
                40.663723987931604`, -0.29045937779723285`}, {
                40.94476133961909, -0.22207775290912224`}, {
                41.22971036722177, -0.15369612802101162`}, {
                41.5186533113407, -0.08531450313290079}, {
                41.81167473420561, -0.016932878244790173`}, {
                42.10886160219837, 0.051448746643320664`}, {42.41030337204617,
                 0.11983037153143128`}, {42.716092080228236`, 
                0.1882119964195419}, {43.02632243742715, 
                0.2565936213076525}, {43.341091925239034`, 
                0.3249752461957631}, {43.660500899258196`, 
                0.39335687108387374`}, {43.98465269530023, 
                0.4617384959719848}, {44.31365374092918, 
                0.5301201208600954}, {44.64761367204745, 0.598501745748206}, {
                44.98664545454281, 0.6668833706363166}, {45.33086551184171, 
                0.7352649955244273}, {45.68039385814082, 
                0.8036466204125379}, {46.035354237925965`, 
                0.8720282453006489}, {46.395874272039705`, 
                0.9404098701887595}, {46.76208561066557, 
                1.0087914950768702`}, {47.134124093594, 
                1.0771731199649808`}, {47.51212991831981, 
                1.1455547448530914`}, {47.8962478160144, 1.213936369741202}, {
                48.28662723643945, 1.282317994629313}, {48.68342254176519, 
                1.3506996195174237`}, {49.086793210084316`, 
                1.4190812444055343`}, {49.49690404912585, 
                1.487462869293645}, {49.91392542077174, 
                1.5558444941817555`}, {50.33803347701921, 
                1.6242261190698661`}, {50.76941040807576, 
                1.6926077439579768`}, {51.20824470332086, 
                1.7609893688460878`}, {51.65473142591951, 
                1.8293709937341984`}, {52.109072501928544`, 
                1.897752618622309}, {52.571477024795655`, 
                1.9661342435104197`}, {53.0421615762158, 
                2.0345158683985307`}, {53.52135056437972, 
                2.1028974932866413`}, {54.0092765807242, 2.171279118174752}, {
                54.50618077637429, 2.2396607430628626`}, {55.01231325956622, 
                2.308042367950973}, {55.527933515403895`, 
                2.376423992839084}, {56.05331084946308, 
                2.4448056177271944`}, {56.58872485680818, 
                2.513187242615305}, {57.134465918150845`, 
                2.5815688675034156`}, {57.69083572499793, 
                2.6499504923915262`}, {58.25814783578402, 
                2.718332117279637}, {58.83672826514298, 
                2.7867137421677475`}, {59.42691610864493, 
                2.855095367055859}, {60.02906420551456, 
                2.9234769919439696`}, {60.64353984205222, 2.99185861683208}, {
                61.27072549870421, 3.060240241720191}, {61.911019643975656`, 
                3.1286218666083014`}, {62.56483757864846, 
                3.197003491496412}, {63.232612334063035`, 
                3.2653851163845227`}, {63.91479562854651, 
                3.3337667412726333`}, {64.61185888642648, 
                3.402148366160744}, {65.32429432446114, 
                3.4705299910488545`}, {66.05261611094704, 
                3.538911615936965}, {66.79736160324089, 
                3.6072932408250757`}, {67.55909266995438, 
                3.6756748657131864`}, {68.33839710465976, 
                3.744056490601298}, {69.13589013858054, 
                3.8124381154894085`}, {69.95221606044987, 
                3.880819740377519}, {70.78804995249891, 
                3.9492013652656297`}, {71.64409955240707, 4.01758299015374}, {
                72.52110725200659, 4.085964615041851}, {73.41985224460542, 
                4.1543462399299615`}, {74.34115283398269, 
                4.222727864818072}, {75.28586891943837, 4.291109489706183}, {
                76.2549046727596, 4.359491114594293}, {77.2492114246207, 
                4.427872739482404}, {78.26979077978572, 4.496254364370515}, {
                79.3176979825564, 4.564635989258626}, {80.39404555623624, 
                4.633017614146737}, {81.50000724299854, 4.701399239034847}, {
                82.63682227348902, 4.769780863922958}, {83.8058, 
                4.838162488879449}, {83.80671146360098, 4.860476824241787}, {
                83.80767097594419, 4.882791159604125}, {83.80868106958854, 
                4.905105494966462}, {83.80974441053836, 4.9274198303288}, {
                83.81086380527056, 4.9497341656911376`}, {83.81204220813066, 
                4.972048501053475}, {83.81328272911904, 4.994362836415813}, {
                83.81458864208517, 5.01667717177815}, {83.8159633933537, 
                5.038991507140488}, {83.81741061080334, 5.061305842502826}, {
                83.81893411342293, 5.083620177865163}, {83.82053792136963, 
                5.105934513227501}, {83.82222626655573, 5.128248848589838}, {
                83.824003603791, 5.150563183952175}, {83.82587462251092, 
                5.172877519314513}, {83.82784425911947, 
                5.1951918546768505`}, {83.82991770998137, 
                5.217506190039188}, {83.83210044509426, 5.239820525401526}, {
                83.83439822247995, 5.262134860763863}, {83.83681710332944, 
                5.284449196126201}, {83.83936346794195, 5.306763531488539}, {
                83.84204403250044, 5.329077866850876}, {83.84486586672524, 
                5.351392202213214}, {83.84783641245312, 
                5.3737065375755515`}, {83.85096350318896, 
                5.396020872937889}, {83.85425538468164, 5.418335208300227}, {
                83.85772073657549, 5.440649543662564}, {83.86136869519592, 
                5.462963879024902}, {83.865208877525, 5.48527821438724}, {
                83.86925140643142, 5.507592549749577}, {83.87350693721743, 
                5.529906885111915}, {83.87798668555295, 
                5.5522212204742525`}, {83.8827024568671, 5.57453555583659}, {
                83.88766667727263, 5.596849891198928}, {83.89289242610333, 
                5.619164226561265}, {83.89839347014585, 5.641478561923603}, {
                83.90418429965466, 5.663792897285941}, {83.9102801662406, 
                5.686107232648277}, {83.91669712272993, 5.708421568010616}, {
                83.92345206509415, 5.730735903372953}, {83.9305627765575, 
                5.75305023873529}, {83.93804797399167, 5.775364574097628}, {
                83.94592735671682, 5.7976789094599654`}, {83.95422165782873, 
                5.819993244822303}, {83.96295269818177, 5.842307580184641}, {
                83.97214344316303, 5.864621915546978}, {83.98181806239675, 
                5.886936250909316}, {83.99200199252873, 5.909250586271654}, {
                84.00272200324522, 5.931564921633991}, {84.01400626668828, 
                5.953879256996329}, {84.02588443043884, 5.976193592358666}, {
                84.0383876942443, 5.998507927721004}, {84.05154889067849, 
                6.020822263083342}, {84.06540256992854, 6.043136598445679}, {
                84.07998508891299, 6.065450933808017}, {84.0953347049451, 
                6.0877652691703545`}, {84.11149167416424, 
                6.110079604532692}, {84.12849835496944, 6.13239393989503}, {
                84.14639931669852, 6.154708275257367}, {84.16524145380751, 
                6.177022610619705}, {84.18507410581638, 6.199336945982042}, {
                84.20594918329837, 6.22165128134438}, {84.22792130020241, 
                6.243965616706717}, {84.2510479128092, 6.2662799520690555`}, {
                84.27538946563617, 6.288594287431392}, {84.30100954461697, 
                6.310908622793731}, {84.32797503789662, 
                6.3332229581560675`}, {84.35635630459535, 
                6.355537293518405}, {84.3862273519084, 6.377851628880743}, {
                84.41766602092346, 6.40016596424308}, {84.4507541815508, 
                6.422480299605418}, {84.48557793697746, 6.444794634967756}, {
                84.5222278380679, 6.467108970330093}, {84.56079910815279, 
                6.489423305692431}, {84.60139187865799, 
                6.5117376410547685`}, {84.64411143604373, 
                6.534051976417106}, {84.6890684805359, 6.556366311779444}, {
                84.73637939714894, 6.578680647141781}, {84.7861665395103, 
                6.600994982504119}, {84.8385585270137, 6.623309317866457}, {
                84.8936905558393, 6.645623653228794}, {84.95170472439358, 
                6.667937988591132}, {85.01275037373243, 
                6.6902523239534695`}, {85.07698444354347, 
                6.712566659315807}, {85.1445718442725, 6.734880994678145}, {
                85.21568584599108, 6.757195330040482}, {85.29050848460567, 
                6.77950966540282}, {85.36923098602033, 6.801824000765157}, {
                85.45205420886596, 6.824138336127495}, {85.5391891064138, 
                6.846452671489832}, {85.63085720829145, 
                6.8687670068521705`}, {85.72729112261837, 
                6.891081342214507}, {85.82873505917362, 6.913395677576846}, {
                85.93544537420267, 6.935710012939182}, {86.04769113745873, 
                6.958024348301521}, {86.16575472206436, 6.980338683663858}, {
                86.28993241775984, 7.002653019026195}, {86.42053506808601, 
                7.024967354388533}, {86.5578887320268, 7.0472816897508705`}, {
                86.702335370607, 7.069596025113208}, {86.85423355891027, 
                7.091910360475546}, {87.01395922394588, 7.114224695837883}, {
                87.18190640875179, 7.136539031200221}, {87.35848806307816, 
                7.158853366562559}, {87.54413686094314, 7.181167701924896}, {
                87.73930604530376, 7.203482037287234}, {87.9444703000219, 
                7.2257963726495715`}, {88.16012664924914, 
                7.248110708011909}, {88.38679538428492, 7.270425043374246}, {
                88.62502101789843, 7.292739378736584}, {88.87537326603164, 
                7.315053714098921}, {89.13844805673264, 7.33736804946126}, {
                89.4148685660928, 7.359682384823596}, {89.70528628089369, 
                7.381996720185935}, {90.01038208759618, 7.404311055548272}, {
                90.33086738724228, 7.42662539091061}, {90.66748523577279, 
                7.448939726272947}, {91.02101150921648, 7.471254061635285}, {
                91.39225609315281, 7.493568396997622}, {91.78206409582103, 
                7.515882732359961}, {92.19131708422152, 7.538197067722297}, {
                92.62093434255216, 7.560511403084635}, {93.07187415233095, 
                7.582825738446973}, {93.54513509358883, 7.60514007380931}, {
                94.04175736657231, 7.627454409171648}, {94.56282413347328, 
                7.6497687445339855`}, {95.10946287981552, 
                7.672083079896323}, {95.68284679526202, 7.694397415258661}, {
                96.28419617378145, 7.716711750620998}, {96.91477983331511, 
                7.739026085983336}, {97.57591655532646, 7.761340421345674}, {
                98.26897654489197, 7.783654756708011}, {98.99538291230361, 
                7.805969092070349}, {99.75661317750372, 
                7.8282834274326865`}, {100.55420079905512`, 
                7.850597762795024}, {101.38973672976707`, 
                7.872912098157361}, {102.26487100154733`, 
                7.895226433519699}, {103.18131434252106`, 
                7.917540768882036}, {104.14083982996418`, 
                7.939855104244375}, {105.1452845831084, 7.962169439606711}, {
                106.19655150041343`, 7.98448377496905}, {107.29661104643446`, 
                8.006798110331387}, {108.44750309395836`, 
                8.029112445693725}, {109.6513388276096, 8.051426781056062}, {
                110.91030271565364`, 8.0737411164184}, {112.22665455721952`, 
                8.096055451780737}, {113.60273161264449`, 
                8.118369787143076}, {115.0409508250763, 8.140684122505412}, {
                116.54381114187794`, 8.16299845786775}, {118.1138959447286, 
                8.185312793230088}, {119.75387559763219`, 
                8.207627128592424}, {121.46651012229384`, 
                8.229941463954763}, {123.25465201053218`, 
                8.252255799317101}, {125.1212491835466, 8.274570134679438}, {
                127.06934810795092`, 8.296884470041775}, {129.1020970785317, 
                8.319198805404113}, {131.22274967768627`, 
                8.341513140766452}, {133.4346684214503, 8.363827476128789}, {
                135.74132860193984`, 8.386141811491125}, {138.14632233591507`,
                 8.408456146853464}, {140.65336282903846`, 8.4307704822158}, {
                143.26628886524708`, 8.453084817578139}, {145.98906953048757`,
                 8.475399152940476}, {148.82580917991723`, 
                8.497713488302814}, {151.78075265750743`, 
                8.520027823665151}, {154.85829077686998`, 8.54234215902749}, {
                158.06296607200125`, 8.564656494389826}, {161.39947882658558`,
                 8.586970829752165}, {164.87269339043976`, 
                8.609285165114501}, {168.48764479171643`, 8.63159950047684}, {
                172.24954565351325`, 8.653913835839177}, {176.1637934236747, 
                8.676228171201515}, {180.2359779267129, 8.698542506563852}, {
                184.47188924702442`, 8.720856841926189}, {188.8775259528354, 
                8.743171177288527}, {193.45910367067233`, 
                8.765485512650866}, {198.2230640205395, 8.787799848013202}, {
                203.1760839224497, 8.81011418337554}, {208.32508528545893`, 
                8.832428518737878}, {213.67724509092633`, 
                8.854742854100216}, {219.2400058823366, 8.877057189462553}, {
                225.02108667469238`, 8.89937152482489}, {231.02849429717656`, 
                8.921685860187228}, {237.27053518357098`, 
                8.944000195549567}, {243.75582762568834`, 
                8.966314530911903}, {250.49331450592868`, 8.98862886627424}, {
                257.49227652593686`, 9.010943201636579}, {264.762345949246, 
                9.033257536998917}, {272.3135208767548, 9.055571872361254}, {
                280.1561800748349, 9.07788620772359}, {288.30109837690287`, 
                9.10020054308593}, {296.7594626803096, 9.122514878448266}, {
                305.5428885614997, 9.144829213810603}, {314.6634375334729, 
                9.167143549172941}, {324.13363497073635`, 9.18945788453528}, {
                333.96648872810255`, 9.211772219897616}, {344.1755084808982, 
                9.234086555259953}, {354.77472581538285`, 
                9.256400890622292}, {365.7787150994561, 9.27871522598463}, {
                377.20261516507696`, 9.301029561346967}, {0., 
                9.301029561369281}}], 
              RGBColor[
              0.9954590666666666, 0.8972822666666667, 0.7864570666666667], 
              PolygonBox[CompressedData["
1:eJxlkm0s1HEAxy+xZOXSVOemdr+/xEyUunkavspj42wqolge7s7Dn/N4V6a5
UZ0NjbE2h5RsdB6So1uOeWohal262qwQk7lFqxlxRVrzqhffffd583n1IbGi
UL4Bg8Gw3drf9ymi5/XaWAxacrVxvWy4dgyLN0QN/3FT8o8ijpzCpJtgwaNc
gkq3f7xHs1KT/VGMOobFoPIOBf3tOT++vRiKF17rfgUUTNn6z6/zs9FeLDg5
IaGQmTHTLZ7Kgjq0JCGFplDHo6OtzmThOaujlhFDIWC8Oa1GkYmxyYn35Rcp
uJTqmh6zMvGufoepzTkK/PmwgWPFGfiUZOvb5UlhnF0YpDHMwJcTIbnBpyh4
VrU8zctPx9JKtnLahoLwpsTB0Cgdq93VukxLCpsFijKn4jQwCgbJLjMKY6qI
qOlDaTAO1F2SG235lVL3kRAR9jHNSo+vE2hVST2O11JhoXUe6lsiiFQLXBsb
U0BVRW+cnyWYDJmiF6Zp2MXc4s5/IFj0Xelp5tBwsmmmc8YIJN/ecFqFyXBf
fPtwbz/BavXc76bOJPgo1ybudxLUtnpbCE2SEHSds/+0gkBt3JdTx0/EBS//
wKF7BNyjtuFWQwmIMkqVRpYTXLnqsN7mkADBaIVqUUbgIuc9Ma8WIrVMvSTN
JehKzFFZMIUQh89Ym6cT6J5VkBKZAHmHd0c18AkyejtGPYwEKJx1rHCLJIi4
a+f/S8ZH6aOw0Vc8ggomRuRMPipFNwxizhKsJbexF6vi8YBb77rsTGC9rJEN
28dDoX+ZJrMnYElpzc6BOLT3f29gE4JWK5cjkstxUMtYUy0HCHgBm1/1P7f6
CvY66G1CsN3bdk9/AMJrH0k=
               "]], 
              RGBColor[
              0.8980593333333333, 0.8971646666666667, 0.9449146666666667], 
              PolygonBox[{}], 
              InsetBox[
               BoxData[
                FormBox[
                 StyleBox[
                 "\"gas\"", LinebreakAdjustments -> {1, 100, 1, 0, 100}, 
                  LineIndent -> 0, {FontFamily -> "Verdana", FontSize -> 10}, 
                  GrayLevel[0.5], StripOnInput -> False], TraditionalForm]], 
               Scaled[{0.7500000000000002, 0.35000000000000003`}]], 
              InsetBox[
               BoxData[
                FormBox[
                 StyleBox[
                  TagBox[
                   
                   GridBox[{{"\"supercritical\""}, {"\"region\""}}, 
                    GridBoxAlignment -> {"Columns" -> {{Center}}}, 
                    DefaultBaseStyle -> "Column", 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{0.05}}}], 
                   "Column"], LinebreakAdjustments -> {1, 100, 1, 0, 100}, 
                  LineIndent -> 0, {FontFamily -> "Verdana", FontSize -> 10}, 
                  GrayLevel[0.5], StripOnInput -> False], TraditionalForm]], 
               Scaled[{0.798688845401159, 0.8268297455968487}]], 
              InsetBox[
               BoxData[
                FormBox[
                 StyleBox[
                 "\"liquid\"", LinebreakAdjustments -> {1, 100, 1, 0, 100}, 
                  LineIndent -> 0, {FontFamily -> "Verdana", FontSize -> 10}, 
                  GrayLevel[0.5], StripOnInput -> False], TraditionalForm]], 
               Scaled[{0.23953033268101756`, 0.7310763209393352}]], 
              GrayLevel[0.3961454], 
              Thickness[0.003], 
              LineBox[CompressedData["
1:eJwlxQk41AkfwPFxzeTK0RhEWq0kpUOSs/9v7mEYc73UFLmLJoO1lrTrqbyx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               "]], 
              InsetBox[
               BoxData[
                FormBox[
                 StyleBox[
                 "\"sublimation curve\"", 
                  LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                  0, 
                  GrayLevel[0.6], StripOnInput -> False], TraditionalForm]], 
               Scaled[{0.312583170254403, 0.20273972602739798`}]], 
              GrayLevel[0.3961454], 
              Thickness[0.003], 
              LineBox[CompressedData["
1:eJwVkHk01I0bxUl6LW9Ks3xnJkQb+SWlQkXdytJCG7MZM2ZGUZYIqWSJN1lS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               "]], 
              InsetBox[
               BoxData[
                FormBox[
                 StyleBox[
                 "\"saturation curve\"", 
                  LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                  0, 
                  GrayLevel[0.6], StripOnInput -> False], TraditionalForm]], 
               Scaled[{0.4003913894324846, 0.5505381604696677}]], 
              GrayLevel[0.3961454], 
              Thickness[0.003], 
              LineBox[CompressedData["
1:eJwV1Wk4lVsDxnEVKiRsw97bnp6tqEhSjqHizlgnSni2IfNMRDJE40HtU9Eh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               "]], 
              InsetBox[
               BoxData[
                FormBox[
                 StyleBox[
                 "\"melting curve\"", 
                  LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                  0, 
                  GrayLevel[0.6], StripOnInput -> False], TraditionalForm]], 
               Scaled[{0.4687084148727982, 0.9151076320939342}]], 
              GrayLevel[0.257923], 
              PointSize[0.021], 
              PointBox[{150.687, 6.686904269568177}], 
              InsetBox[
               BoxData[
                FormBox[
                 StyleBox[
                 "\"critical point\"", 
                  LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                  0, 
                  GrayLevel[0.6], StripOnInput -> False], TraditionalForm]], 
               Scaled[{0.4399217221135022, 0.6968297455968695}]], 
              GrayLevel[0.257923], 
              PointSize[0.021], 
              PointBox[{83.8058, 4.838162488879449}], 
              InsetBox[
               BoxData[
                FormBox[
                 StyleBox[
                 "\"triple point\"", 
                  LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                  0, 
                  GrayLevel[0.6], StripOnInput -> False], TraditionalForm]], 
               Scaled[{0.3004109589041097, 0.40590998043052906`}]], 
              GrayLevel[0.5343678000000001], 
              PointSize[0.021], 
              PointBox[{293.15, 5.00572}], 
              InsetBox[
               BoxData[
                FormBox[
                 StyleBox[
                 "\"STP\"", LinebreakAdjustments -> {1, 100, 1, 0, 100}, 
                  LineIndent -> 0, 
                  GrayLevel[0.6], StripOnInput -> False], TraditionalForm]], 
               Scaled[{0.5659197651663405, 0.47682974559686975`}]], 
              RGBColor[1, 0, 0], 
              PointSize[0.021], 
              Thickness[0.003], 
              LineBox[CompressedData["
1:eJwVkHk01I0bxUl6LW9Ks3xnJkQb+SWlQkXdytJCG7MZM2ZGUZYIqWSJN1lS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               "]]}, {GridLines -> Dynamic[
                Map[{{#, 
                   GrayLevel[0.7]}}& , 
                 MousePosition[{"Graphics", Graphics}, None]]], 
              Method -> {"GridLinesInFront" -> True}, AspectRatio -> 0.8, 
              ImageSize -> 300, 
              PlotRange -> {{-2.2250738585072014`*^-308, 500.0000000000001}, {
                2, 9}}, Frame -> True, PlotRangeClipping -> True, FrameLabel -> {
                FormBox[
                 FormBox[
                  TagBox[
                   FormBox[
                    TemplateBox[{
                    TemplateBox[{
                    StyleBox[
                    "\"temperature\"", 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, {FontFamily -> "Verdana", FontSize -> 10}, 
                    GrayLevel[0.5], StripOnInput -> False], "\"  \""}, 
                    "RowDefault"], 
                    StyleBox[
                    RowBox[{"\"(\"", "\[NoBreak]", 
                    StyleBox[
                    TagBox[
                    RowBox[{
                    StyleBox[
                    "\"K\"", FontFamily -> "Helvetica", FontSize -> 
                    Smaller]}], Identity], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, ZeroWidthTimes -> False], "\[NoBreak]", "\")\""}], {
                    FontFamily -> "Verdana", FontSize -> 10, 
                    GrayLevel[0.5], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0}, StripOnInput -> False]}, "RowDefault"], 
                    TraditionalForm], Format[#, TraditionalForm]& ], 
                  TraditionalForm], TraditionalForm], 
                FormBox[
                 FormBox[
                  TagBox[
                   FormBox[
                    TemplateBox[{
                    TemplateBox[{
                    StyleBox[
                    "\"pressure\"", 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, {FontFamily -> "Verdana", FontSize -> 10}, 
                    GrayLevel[0.5], StripOnInput -> False], "\"  \""}, 
                    "RowDefault"], 
                    StyleBox[
                    RowBox[{"\"(\"", "\[NoBreak]", 
                    StyleBox[
                    TagBox[
                    RowBox[{
                    StyleBox[
                    "\"Pa\"", FontFamily -> "Helvetica", FontSize -> 
                    Smaller]}], Identity], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, ZeroWidthTimes -> False], "\[NoBreak]", "\")\""}], {
                    FontFamily -> "Verdana", FontSize -> 10, 
                    GrayLevel[0.5], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0}, StripOnInput -> False]}, "RowDefault"], 
                    TraditionalForm], Format[#, TraditionalForm]& ], 
                  TraditionalForm], TraditionalForm]}, FrameTicks -> {{{{2, 
                   FormBox[
                    
                    TemplateBox[{"10", "2"}, "Superscript", SyntaxForm -> 
                    SuperscriptBox], TraditionalForm]}, {3, 
                   FormBox[
                    
                    TemplateBox[{"10", "3"}, "Superscript", SyntaxForm -> 
                    SuperscriptBox], TraditionalForm]}, {4, 
                   FormBox[
                    
                    TemplateBox[{"10", "4"}, "Superscript", SyntaxForm -> 
                    SuperscriptBox], TraditionalForm]}, {5, 
                   FormBox[
                    
                    TemplateBox[{"10", "5"}, "Superscript", SyntaxForm -> 
                    SuperscriptBox], TraditionalForm]}, {6, 
                   FormBox[
                    
                    TemplateBox[{"10", "6"}, "Superscript", SyntaxForm -> 
                    SuperscriptBox], TraditionalForm]}, {7, 
                   FormBox[
                    
                    TemplateBox[{"10", "7"}, "Superscript", SyntaxForm -> 
                    SuperscriptBox], TraditionalForm]}, {8, 
                   FormBox[
                    
                    TemplateBox[{"10", "8"}, "Superscript", SyntaxForm -> 
                    SuperscriptBox], TraditionalForm]}, {9, 
                   FormBox[
                    
                    TemplateBox[{"10", "9"}, "Superscript", SyntaxForm -> 
                    SuperscriptBox], TraditionalForm]}}, None}, {
                Automatic, None}}}], TraditionalForm]], "Output"]}], 
       XMLElement["dataformats", {}, {}]}]}], Typeset`aux1$$ = {
   True, False, {False}, True}, Typeset`aux2$$ = {True, False, {False}, True},
    Typeset`asyncpods$$ = {}, Typeset`nonpods$$ = {
    XMLElement["sources", {"count" -> "1"}, {
      XMLElement[
      "source", {
       "url" -> 
        "http://www.wolframalpha.com/sources/\
ThermodynamicDataRPSourceInformationNotes.html", "text" -> 
        "Thermodynamic data RP"}, {}]}]}, Typeset`initdone$$ = True, 
   Typeset`queryinfo$$ = {
   "success" -> "true", "error" -> "false", "numpods" -> "2", "datatypes" -> 
    "ThermodynamicDataRP", "timedout" -> "", "timedoutpods" -> "", "timing" -> 
    "0.973", "parsetiming" -> "0.17", "parsetimedout" -> "false", 
    "recalculate" -> "", "id" -> "MSPa021d6021ba985cac80000226169e20fb02c2b", 
    "host" -> "http://www4b.wolframalpha.com", "server" -> "53", "related" -> 
    "http://www4b.wolframalpha.com/api/v2/relatedQueries.jsp?id=\
MSPa121d6021ba985cac800003cf2989059hicaf8&s=53", "version" -> "2.6"}, 
   Typeset`sessioninfo$$ = {
   "TimeZone" -> 1., 
    "Date" -> {2014, 2, 8, 17, 23, 17.5962436`8.997994908452052}, "Line" -> 
    13, "SessionID" -> 23598650065435982770}, Typeset`showpods$$ = {1, 2}, 
   Typeset`failedpods$$ = {}, Typeset`chosen$$ = {
   "Result", "Result", 1, 1, "Content"}, Typeset`open$$ = True, 
   Typeset`newq$$ = "saturation curve of argon"}, 
   DynamicBox[ToBoxes[
     AlphaIntegration`FormatAlphaResults[
      Dynamic[{
       1, {Typeset`pod1$$, Typeset`pod2$$}, {Typeset`aux1$$, Typeset`aux2$$}, 
        Typeset`chosen$$, Typeset`open$$, Typeset`elements$$, Typeset`q$$, 
        Typeset`opts$$, Typeset`nonpods$$, Typeset`queryinfo$$, 
        Typeset`sessioninfo$$, Typeset`showpods$$, Typeset`failedpods$$, 
        Typeset`newq$$}]], StandardForm],
    ImageSizeCache->{560., {405., 19.}},
    TrackedSymbols:>{Typeset`showpods$$, Typeset`failedpods$$}],
   DynamicModuleValues:>{},
   Initialization:>If[
     Not[Typeset`initdone$$], Null; WolframAlphaClient`Private`doAsyncUpdates[
       Hold[{Typeset`pod1$$, Typeset`pod2$$}], Typeset`asyncpods$$, 
       Dynamic[Typeset`failedpods$$]]; Typeset`asyncpods$$ = {}; 
     Typeset`initdone$$ = True],
   SynchronousInitialization->False],
  BaseStyle->{Deployed -> True},
  DeleteWithContents->True,
  Editable->False,
  SelectWithContents->True]], "WolframAlphaShortInput",
 CellLabel->"In[47]:=",
 CellID->537052260,ExpressionUUID->"d7a3c9ca-d073-45b0-b5a5-0da55a50473e"],

Cell[BoxData[
 GraphicsBox[
  TagBox[RasterBox[CompressedData["
1:eJztvQtsHVd+p2l4G0YPeho9aCTrSdDZxQQJEqQRLBaNYB+YTLRCNtNRBxNM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    "], {{0, 267.}, {322., 0}}, {0, 255},
    ColorFunction->RGBColor,
    ImageResolution->{144., 144.},
    SmoothingQuality->"High"],
   BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
   Selectable->False],
  DefaultBaseStyle->"ImageGraphics",
  ImageSize->Automatic,
  ImageSizeRaw->{322., 267.},
  PlotRange->{{0, 322.}, {0, 267.}}]], "Output",
 CellTags->"RasterizedOutput",
 CellLabel->"Out[47]=",
 CellID->234535742,ExpressionUUID->"f0cdc9ae-cd4e-4048-bee0-2f4af96e6666"]
}, Open  ]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"}, 
  Closed]]]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "2"},
        Closed], 
      Alternatives[Open, True]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{
    13.600000000000001`, {0.5800000000000001, 13.020000000000001`}}]],
  ExpressionUUID->"0f0b0700-4ff6-40b6-9cd6-3f032cf7e278"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"818c0d20-b9fc-4179-978b-5bcedf67482a"],
 "Applications",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "d8209f45-3b37-44f0-ab1e-792322755803"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellID->258228157,ExpressionUUID->"6088cdc2-5588-429b-b12e-aac5d97284ac"],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<NewEoSArgon`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->85899407,ExpressionUUID->"d47297c1-17d8-4efc-9d41-30b8c28d3484"],

Cell["\<\
Phase diagram of argon for the range of temperature corresponding to NIST\
\>", "ExampleText",
 CellID->605737459,ExpressionUUID->"372ca67a-9610-4650-8a5a-e8158552355e"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"FigSat", "=", 
   RowBox[{"Quiet", "@", 
    RowBox[{"LogPlot", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"PTSatNIST", "[", "T", "]"}], "/", "10"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"T", ",", "ttr", ",", "tc"}], "}"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
      RowBox[{"Frame", "\[Rule]", "True"}], ",", 
      RowBox[{"FrameLabel", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"\"\<T\>\"", ",", "\"\<P\>\""}], "}"}]}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", "Red", "}"}]}], ",", 
      RowBox[{"Epilog", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Red", ",", 
         RowBox[{"PointSize", "\[Rule]", "Medium"}], ",", 
         RowBox[{"Point", "[", 
          RowBox[{"{", 
           RowBox[{"tc", ",", 
            RowBox[{"Log", "[", 
             RowBox[{"pc", "/", "10"}], "]"}]}], "}"}], "]"}]}], "}"}]}]}], 
     "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"FigFus", "=", 
   RowBox[{"LogPlot", "[", 
    RowBox[{
     RowBox[{"PFusionArgon", "[", "T", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"T", ",", "ttr", ",", "700"}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
     RowBox[{"Frame", "\[Rule]", "True"}], ",", 
     RowBox[{"FrameLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<T\>\"", ",", "\"\<P\>\""}], "}"}]}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", "Black"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"FigPhases", "=", 
  RowBox[{"Show", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"FigSat", ",", "FigFus"}], "}"}], ",", 
    RowBox[{"PlotRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"All", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Log", "[", 
          RowBox[{"ptr", "/", "10"}], "]"}], ",", 
         RowBox[{"Log", "[", "1000", "]"}]}], "}"}]}], "}"}]}], ",", 
    RowBox[{"FrameLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
      "\"\<Temperature \!\(\*StyleBox[\"T\",FontSlant->\"Italic\"]\) (K)\>\"",
        ",", "\"\<Pressure \!\(\*StyleBox[\"P\",FontSlant->\"Italic\"]\) \
(MPa)\>\"", ",", "\"\< \>\"", ",", "\"\< \>\""}], "}"}]}], ",", 
    RowBox[{"LabelStyle", "\[Rule]", 
     RowBox[{"Directive", "[", 
      RowBox[{"12", ",", 
       RowBox[{"FontFamily", "\[Rule]", "\"\<Times\>\""}]}], "]"}]}], ",", 
    RowBox[{"ImageSize", "\[Rule]", "400"}]}], "]"}]}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->206869432,ExpressionUUID->"6fff82c1-4ea7-4278-9396-5941010015b7"],

Cell[BoxData[
 GraphicsBox[{
   InterpretationBox[{
     TagBox[{{{}, {}, 
        TagBox[
         {RGBColor[1, 0, 0], AbsoluteThickness[2], Opacity[1.], 
          LineBox[CompressedData["
1:eJwVz38803kcB/Cp5tQtYn60cOI4pV9Oa3X9+rzTj90q50c2Nvbr+7hNd6gk
pYsckgvpQkvSFU7ysMSWQuU7J01qhRJOE62kUudH+H5vj7pbf7wer8fz8frr
5YrtDpJNo1AofqZ87mSBAeWMB0OnOKWpT07V5GxUBz3/EAyi9l6jGUbVFC9O
lflMBkNE7e5JDyFVc/uTW2YHEQwGTob3nh1UjXkJ9sTmUzBUzfpNORuomqy3
A1G5FlzgyG/JohhUTX5C/5k8Zy5M7puyvHZ/hqbqD/24gm3ahxxUshUzNDvN
J3qUxVxoqzIkcienaZg5K1LrprhQ0V94VPnETPNyw1lbx2082Ff74Ep6M0Xj
YvdV9/FSHrTalnyw9/sPj6a1iqZIHtiE7lISmz/imzxzHfZyQyDKUnFrkbsR
p8iTazdcCYEvUrw7bJxJvK0l38lieiiUars8d7Kn8IX+OtUzYShsWF/PteNP
4ArSi1apCgVzmid1NH8cH9Je9mun8oFeWoelvRvFm+r8GqkSPhwroDUneY3g
qof2hPdVPow7KL0c3N7hXjM/SqKtBFDnouGv+es1ni63UH3aKYAA6/nLTh8b
xIlXa+8cvSkAc+Gg45xzBnwsK5s23yEM6pWdg5fS+nEKb6Z9VWQYcOtTU6N+
6sVP+xYFBmpN+0o1nRHXidN3iOLYruEQ0sUTmaU9xEvSN4Uz48LhNGu1PMu9
Gb/5jB3n0xYOSVqULQ+4ir8O2xfo6SGEkb6FvYsXBeJGY7NdTLwQhtAac9sp
FVLgTNr9DiE0Ng2fb6lqQpvL7jc7e4rA7Mjj8sPTdShRlVz9a4oIlgcd0fXG
PkIFA2Fpq56KYH93Qc12Zje6xxQ7vVomhmg+usHIeorSKpJeXswQg36AHeJ+
qh/t2HI3RvhMDPPDguzV1c9R6jSnWCZDAhzzCU5m3QtUNC6947tFAjPISNvh
54Po7v61h7bvkcAhz7evqvVDqCbT427fOQlk39KKWOQbVOFTEh/VIoF1c/Vf
rxwaRnmRywvdxySAJV17d7n5PfJldYTKXKQQ2kG4nJGOIDKHeqCII4V6vEV/
ctsoiktmL5UfkEIE119H3zyGXpgV8rl/SsFKdJa5hDWOhLZpg+iBFGI5gbtG
6B9QQW0CTW2UwuEFsto5ZhNo4L1Fnus3GKQvzx+N7p1AjtfLTtT7Y2DsOkf5
u3ISMay57k8TMCivKD/UcHIKuX5UzCMvYuA/anRa/yOBmP0NHjVlGNSriwPe
RBBoS9Ogd8wlDLp1CxSKSAJFHmOxX5djsPJSmeCfvQSqsXsS26PEoMCyvL0o
mUCcpXa6OhUG9ETf0lnnCRQjzk36pQGDa4k8taGHQEd8b2SwcAzAn3dUoSeQ
wsNwaszkniqXC5wBAt1466P8uREDS59ISsoQgajxHd2C2xhkG1gt8ZMEOvO7
tc+aVgw0bRdrHtJJpIz9bt2UycetxFsPOpCogSf9Xn0PA2dGsd7NkUQGp2rR
Ip3J1NWz97uRaEl5QKZjm+kPdR7N+VsSQVa8ostkQd48Gy2TREG7LxTltmMg
001nx6wi0YEVI9e/fISBNZ2ReAeRKGPu3CatycOxWytjNpKo0IgepD7GwIuV
cNCZTaLKvoge1IlB6cScxa1bSdTYeOKF0WSrQvm/cT+Q6H/8vlax
           "]]},
         Annotation[#, "Charting`Private`Tag#1"]& ]}, {}},
      {"WolframDynamicHighlight", <|
       "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>}], 
     DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
       Slot["HighlightElements"], 
       Slot["LayoutOptions"], 
       Slot["Meta"], 
       Charting`HighlightActionFunction["DynamicHighlight", {{{{}, {}, 
           Annotation[{
             Directive[
              Opacity[1.], 
              AbsoluteThickness[2], 
              RGBColor[1, 0, 0]], 
             Line[CompressedData["
1:eJwVz38803kcB/Cp5tQtYn60cOI4pV9Oa3X9+rzTj90q50c2Nvbr+7hNd6gk
pYsckgvpQkvSFU7ysMSWQuU7J01qhRJOE62kUudH+H5vj7pbf7wer8fz8frr
5YrtDpJNo1AofqZ87mSBAeWMB0OnOKWpT07V5GxUBz3/EAyi9l6jGUbVFC9O
lflMBkNE7e5JDyFVc/uTW2YHEQwGTob3nh1UjXkJ9sTmUzBUzfpNORuomqy3
A1G5FlzgyG/JohhUTX5C/5k8Zy5M7puyvHZ/hqbqD/24gm3ahxxUshUzNDvN
J3qUxVxoqzIkcienaZg5K1LrprhQ0V94VPnETPNyw1lbx2082Ff74Ep6M0Xj
YvdV9/FSHrTalnyw9/sPj6a1iqZIHtiE7lISmz/imzxzHfZyQyDKUnFrkbsR
p8iTazdcCYEvUrw7bJxJvK0l38lieiiUars8d7Kn8IX+OtUzYShsWF/PteNP
4ArSi1apCgVzmid1NH8cH9Je9mun8oFeWoelvRvFm+r8GqkSPhwroDUneY3g
qof2hPdVPow7KL0c3N7hXjM/SqKtBFDnouGv+es1ni63UH3aKYAA6/nLTh8b
xIlXa+8cvSkAc+Gg45xzBnwsK5s23yEM6pWdg5fS+nEKb6Z9VWQYcOtTU6N+
6sVP+xYFBmpN+0o1nRHXidN3iOLYruEQ0sUTmaU9xEvSN4Uz48LhNGu1PMu9
Gb/5jB3n0xYOSVqULQ+4ir8O2xfo6SGEkb6FvYsXBeJGY7NdTLwQhtAac9sp
FVLgTNr9DiE0Ng2fb6lqQpvL7jc7e4rA7Mjj8sPTdShRlVz9a4oIlgcd0fXG
PkIFA2Fpq56KYH93Qc12Zje6xxQ7vVomhmg+usHIeorSKpJeXswQg36AHeJ+
qh/t2HI3RvhMDPPDguzV1c9R6jSnWCZDAhzzCU5m3QtUNC6947tFAjPISNvh
54Po7v61h7bvkcAhz7evqvVDqCbT427fOQlk39KKWOQbVOFTEh/VIoF1c/Vf
rxwaRnmRywvdxySAJV17d7n5PfJldYTKXKQQ2kG4nJGOIDKHeqCII4V6vEV/
ctsoiktmL5UfkEIE119H3zyGXpgV8rl/SsFKdJa5hDWOhLZpg+iBFGI5gbtG
6B9QQW0CTW2UwuEFsto5ZhNo4L1Fnus3GKQvzx+N7p1AjtfLTtT7Y2DsOkf5
u3ISMay57k8TMCivKD/UcHIKuX5UzCMvYuA/anRa/yOBmP0NHjVlGNSriwPe
RBBoS9Ogd8wlDLp1CxSKSAJFHmOxX5djsPJSmeCfvQSqsXsS26PEoMCyvL0o
mUCcpXa6OhUG9ETf0lnnCRQjzk36pQGDa4k8taGHQEd8b2SwcAzAn3dUoSeQ
wsNwaszkniqXC5wBAt1466P8uREDS59ISsoQgajxHd2C2xhkG1gt8ZMEOvO7
tc+aVgw0bRdrHtJJpIz9bt2UycetxFsPOpCogSf9Xn0PA2dGsd7NkUQGp2rR
Ip3J1NWz97uRaEl5QKZjm+kPdR7N+VsSQVa8ostkQd48Gy2TREG7LxTltmMg
001nx6wi0YEVI9e/fISBNZ2ReAeRKGPu3CatycOxWytjNpKo0IgepD7GwIuV
cNCZTaLKvoge1IlB6cScxa1bSdTYeOKF0WSrQvm/cT+Q6H/8vlax
              "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
        "HighlightElements" -> <|
          "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
         "LayoutOptions" -> <|
          "PlotRange" -> {All, All}, "Frame" -> {{True, True}, {True, True}}, 
           "AxesOrigin" -> {83.80580136492264, -2.91172318983269}, 
           "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
           "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
           "DefaultStyle" -> {
             Directive[
              Opacity[1.], 
              AbsoluteThickness[2], 
              RGBColor[1, 0, 0]]}, 
           "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
               Identity[
                Part[#, 1]], 
               Exp[
                Part[#, 2]]}& ), 
             "ScalingFunctions" -> {{Identity, Identity}, {Log, Exp}}|>, 
           "Primitives" -> {}, "GCFlag" -> False|>, 
         "Meta" -> <|
          "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
           Plot, "GroupHighlight" -> False|>|>]]& )[<|
       "HighlightElements" -> <|
         "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
        "LayoutOptions" -> <|
         "PlotRange" -> {All, All}, "Frame" -> {{True, True}, {True, True}}, 
          "AxesOrigin" -> {83.80580136492264, -2.91172318983269}, 
          "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
          "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
          "DefaultStyle" -> {
            Directive[
             Opacity[1.], 
             AbsoluteThickness[2], 
             RGBColor[1, 0, 0]]}, 
          "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
              Identity[
               Part[#, 1]], 
              Exp[
               Part[#, 2]]}& ), 
            "ScalingFunctions" -> {{Identity, Identity}, {Log, Exp}}|>, 
          "Primitives" -> {}, "GCFlag" -> False|>, 
        "Meta" -> <|
         "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
          Plot, "GroupHighlight" -> False|>|>],
      ImageSizeCache->{{4.503599627370496*^15, -4.503599627370496*^15}, {
       4.503599627370496*^15, -4.503599627370496*^15}}]},
    Annotation[{{{{}, {}, 
        Annotation[{
          Directive[
           Opacity[1.], 
           AbsoluteThickness[2], 
           RGBColor[1, 0, 0]], 
          Line[CompressedData["
1:eJwVz38803kcB/Cp5tQtYn60cOI4pV9Oa3X9+rzTj90q50c2Nvbr+7hNd6gk
pYsckgvpQkvSFU7ysMSWQuU7J01qhRJOE62kUudH+H5vj7pbf7wer8fz8frr
5YrtDpJNo1AofqZ87mSBAeWMB0OnOKWpT07V5GxUBz3/EAyi9l6jGUbVFC9O
lflMBkNE7e5JDyFVc/uTW2YHEQwGTob3nh1UjXkJ9sTmUzBUzfpNORuomqy3
A1G5FlzgyG/JohhUTX5C/5k8Zy5M7puyvHZ/hqbqD/24gm3ahxxUshUzNDvN
J3qUxVxoqzIkcienaZg5K1LrprhQ0V94VPnETPNyw1lbx2082Ff74Ep6M0Xj
YvdV9/FSHrTalnyw9/sPj6a1iqZIHtiE7lISmz/imzxzHfZyQyDKUnFrkbsR
p8iTazdcCYEvUrw7bJxJvK0l38lieiiUars8d7Kn8IX+OtUzYShsWF/PteNP
4ArSi1apCgVzmid1NH8cH9Je9mun8oFeWoelvRvFm+r8GqkSPhwroDUneY3g
qof2hPdVPow7KL0c3N7hXjM/SqKtBFDnouGv+es1ni63UH3aKYAA6/nLTh8b
xIlXa+8cvSkAc+Gg45xzBnwsK5s23yEM6pWdg5fS+nEKb6Z9VWQYcOtTU6N+
6sVP+xYFBmpN+0o1nRHXidN3iOLYruEQ0sUTmaU9xEvSN4Uz48LhNGu1PMu9
Gb/5jB3n0xYOSVqULQ+4ir8O2xfo6SGEkb6FvYsXBeJGY7NdTLwQhtAac9sp
FVLgTNr9DiE0Ng2fb6lqQpvL7jc7e4rA7Mjj8sPTdShRlVz9a4oIlgcd0fXG
PkIFA2Fpq56KYH93Qc12Zje6xxQ7vVomhmg+usHIeorSKpJeXswQg36AHeJ+
qh/t2HI3RvhMDPPDguzV1c9R6jSnWCZDAhzzCU5m3QtUNC6947tFAjPISNvh
54Po7v61h7bvkcAhz7evqvVDqCbT427fOQlk39KKWOQbVOFTEh/VIoF1c/Vf
rxwaRnmRywvdxySAJV17d7n5PfJldYTKXKQQ2kG4nJGOIDKHeqCII4V6vEV/
ctsoiktmL5UfkEIE119H3zyGXpgV8rl/SsFKdJa5hDWOhLZpg+iBFGI5gbtG
6B9QQW0CTW2UwuEFsto5ZhNo4L1Fnus3GKQvzx+N7p1AjtfLTtT7Y2DsOkf5
u3ISMay57k8TMCivKD/UcHIKuX5UzCMvYuA/anRa/yOBmP0NHjVlGNSriwPe
RBBoS9Ogd8wlDLp1CxSKSAJFHmOxX5djsPJSmeCfvQSqsXsS26PEoMCyvL0o
mUCcpXa6OhUG9ETf0lnnCRQjzk36pQGDa4k8taGHQEd8b2SwcAzAn3dUoSeQ
wsNwaszkniqXC5wBAt1466P8uREDS59ISsoQgajxHd2C2xhkG1gt8ZMEOvO7
tc+aVgw0bRdrHtJJpIz9bt2UycetxFsPOpCogSf9Xn0PA2dGsd7NkUQGp2rR
Ip3J1NWz97uRaEl5QKZjm+kPdR7N+VsSQVa8ostkQd48Gy2TREG7LxTltmMg
001nx6wi0YEVI9e/fISBNZ2ReAeRKGPu3CatycOxWytjNpKo0IgepD7GwIuV
cNCZTaLKvoge1IlB6cScxa1bSdTYeOKF0WSrQvm/cT+Q6H/8vlax
           "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
     "HighlightElements" -> <|
       "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
      "LayoutOptions" -> <|
       "PlotRange" -> {All, All}, "Frame" -> {{True, True}, {True, True}}, 
        "AxesOrigin" -> {83.80580136492264, -2.91172318983269}, 
        "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
        "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), "DefaultStyle" -> {
          Directive[
           Opacity[1.], 
           AbsoluteThickness[2], 
           RGBColor[1, 0, 0]]}, 
        "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
            Identity[
             Part[#, 1]], 
            Exp[
             Part[#, 2]]}& ), 
          "ScalingFunctions" -> {{Identity, Identity}, {Log, Exp}}|>, 
        "Primitives" -> {}, "GCFlag" -> False|>, 
      "Meta" -> <|
       "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
        Plot, "GroupHighlight" -> False|>|>, "DynamicHighlight"]], 
   InterpretationBox[{
     TagBox[{{{}, {}, 
        TagBox[
         {GrayLevel[0], AbsoluteThickness[2], Opacity[1.], 
          LineBox[CompressedData["
1:eJwV0nk4FAgfB3A5J+e4RjlnxLu2A9vaUtR80/HW0qaYMRhi5Fj3bUqTc3JF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           "]]},
         Annotation[#, "Charting`Private`Tag#1"]& ]}, {}},
      {"WolframDynamicHighlight", <|
       "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>}], 
     DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
       Slot["HighlightElements"], 
       Slot["LayoutOptions"], 
       Slot["Meta"], 
       Charting`HighlightActionFunction["DynamicHighlight", {{{{}, {}, 
           Annotation[{
             Directive[
              Opacity[1.], 
              AbsoluteThickness[2], 
              GrayLevel[0]], 
             Line[CompressedData["
1:eJwV0nk4FAgfB3A5J+e4RjlnxLu2A9vaUtR80/HW0qaYMRhi5Fj3bUqTc3JF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              "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
        "HighlightElements" -> <|
          "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
         "LayoutOptions" -> <|
          "PlotRange" -> {All, All}, "Frame" -> {{True, True}, {True, True}}, 
           "AxesOrigin" -> {83.80581257539203, -3.3020536761051935`}, 
           "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
           "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
           "DefaultStyle" -> {
             Directive[
              Opacity[1.], 
              AbsoluteThickness[2], 
              GrayLevel[0]]}, 
           "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
               Identity[
                Part[#, 1]], 
               Exp[
                Part[#, 2]]}& ), 
             "ScalingFunctions" -> {{Identity, Identity}, {Log, Exp}}|>, 
           "Primitives" -> {}, "GCFlag" -> False|>, 
         "Meta" -> <|
          "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
           Plot, "GroupHighlight" -> False|>|>]]& )[<|
       "HighlightElements" -> <|
         "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
        "LayoutOptions" -> <|
         "PlotRange" -> {All, All}, "Frame" -> {{True, True}, {True, True}}, 
          "AxesOrigin" -> {83.80581257539203, -3.3020536761051935`}, 
          "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
          "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
          "DefaultStyle" -> {
            Directive[
             Opacity[1.], 
             AbsoluteThickness[2], 
             GrayLevel[0]]}, 
          "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
              Identity[
               Part[#, 1]], 
              Exp[
               Part[#, 2]]}& ), 
            "ScalingFunctions" -> {{Identity, Identity}, {Log, Exp}}|>, 
          "Primitives" -> {}, "GCFlag" -> False|>, 
        "Meta" -> <|
         "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
          Plot, "GroupHighlight" -> False|>|>],
      ImageSizeCache->{{4.503599627370496*^15, -4.503599627370496*^15}, {
       4.503599627370496*^15, -4.503599627370496*^15}}]},
    Annotation[{{{{}, {}, 
        Annotation[{
          Directive[
           Opacity[1.], 
           AbsoluteThickness[2], 
           GrayLevel[0]], 
          Line[CompressedData["
1:eJwV0nk4FAgfB3A5J+e4RjlnxLu2A9vaUtR80/HW0qaYMRhi5Fj3bUqTc3JF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           "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
     "HighlightElements" -> <|
       "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
      "LayoutOptions" -> <|
       "PlotRange" -> {All, All}, "Frame" -> {{True, True}, {True, True}}, 
        "AxesOrigin" -> {83.80581257539203, -3.3020536761051935`}, 
        "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
        "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), "DefaultStyle" -> {
          Directive[
           Opacity[1.], 
           AbsoluteThickness[2], 
           GrayLevel[0]]}, 
        "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
            Identity[
             Part[#, 1]], 
            Exp[
             Part[#, 2]]}& ), 
          "ScalingFunctions" -> {{Identity, Identity}, {Log, Exp}}|>, 
        "Primitives" -> {}, "GCFlag" -> False|>, 
      "Meta" -> <|
       "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
        Plot, "GroupHighlight" -> False|>|>, "DynamicHighlight"]]},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{83.80580136492264, -2.91172318983269},
  DisplayFunction->Identity,
  Epilog->{
    RGBColor[1, 0, 0], PointSize -> Medium, 
    PointBox[{150.687, 1.581655531421649}]},
  Frame->{{True, True}, {True, True}},
  FrameLabel->{
    FormBox[
    "\"Temperature \\!\\(\\*StyleBox[\\\"T\\\",FontSlant->\\\"Italic\\\"]\\) \
(K)\"", TraditionalForm], 
    FormBox[
    "\"Pressure \\!\\(\\*StyleBox[\\\"P\\\",FontSlant->\\\"Italic\\\"]\\) \
(MPa)\"", TraditionalForm], 
    FormBox["\" \"", TraditionalForm], 
    FormBox["\" \"", TraditionalForm]},
  FrameTicks->FrontEndValueCache[{{
      Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
       MachinePrecision, RotateLabel -> 0], 
      Charting`ScaledFrameTicks[{Log, Exp}]}, {
     Automatic, Automatic}}, {{{{-2.3025850929940455`, 
        FormBox[
         TagBox[
          InterpretationBox[
           StyleBox["\"0.1\"", ShowStringCharacters -> False], 0.1, 
           AutoDelete -> True], NumberForm[#, {
            DirectedInfinity[1], 1}]& ], TraditionalForm], {0.01, 0.}}, {0., 
        FormBox["1", TraditionalForm], {0.01, 0.}}, {2.302585092994046, 
        FormBox["10", TraditionalForm], {0.01, 0.}}, {4.605170185988092, 
        FormBox["100", TraditionalForm], {0.01, 0.}}, {6.907755278982137, 
        FormBox["1000", TraditionalForm], {0.01, 0.}}, {-4.605170185988091, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-3.506557897319982, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-3.2188758248682006`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.8134107167600364`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.659260036932778, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.5257286443082556`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.4079456086518722`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-1.2039728043259361`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.916290731874155, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.5108256237659907, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.35667494393873245`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.2231435513142097, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.10536051565782628`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.0986122886681098`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.3862943611198906`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.791759469228055, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.9459101490553132`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.0794415416798357`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.1972245773362196`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.4011973816621555`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.6888794541139363`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.0943445622221, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.248495242049359, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.382026634673881, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.499809670330265, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       5.298317366548036, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       5.703782474656201, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       5.991464547107982, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.214608098422191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.396929655216146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.551080335043404, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.684611727667927, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.802394763324311, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       7.600902459542082, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       8.006367567650246, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       8.294049640102028, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       8.517193191416238, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       8.699514748210191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       8.85366542803745, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       8.987196820661973, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       9.104979856318357, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       9.210340371976184, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}}, {{-2.3025850929940455`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {0., 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {
       2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {
       4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {
       6.907755278982137, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 
        0.}}, {-4.605170185988091, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-3.506557897319982, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-3.2188758248682006`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.8134107167600364`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.659260036932778, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.5257286443082556`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.4079456086518722`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-1.2039728043259361`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.916290731874155, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.5108256237659907, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.35667494393873245`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.2231435513142097, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.10536051565782628`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.0986122886681098`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.3862943611198906`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.791759469228055, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.9459101490553132`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.0794415416798357`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.1972245773362196`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.4011973816621555`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.6888794541139363`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.0943445622221, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.248495242049359, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.382026634673881, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.499809670330265, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       5.298317366548036, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       5.703782474656201, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       5.991464547107982, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.214608098422191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.396929655216146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.551080335043404, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.684611727667927, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.802394763324311, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       7.600902459542082, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       8.006367567650246, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       8.294049640102028, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       8.517193191416238, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       8.699514748210191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       8.85366542803745, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       8.987196820661973, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       9.104979856318357, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       9.210340371976184, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}}}, {
     Automatic, Automatic}}],
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  ImageSize->400,
  LabelStyle->Directive[12, FontFamily -> "Times"],
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Exp[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Exp[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->NCache[{All, {-2.675229733587482, 
      Log[1000]}}, {All, {-2.675229733587482, 6.907755278982137}}],
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, 
    Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
     MachinePrecision, RotateLabel -> 0]}]], "Output",
 CellLabel->"Out[2]=",
 CellID->135626984,ExpressionUUID->"7a6fb4f4-dedc-4bf3-be5f-da40dcf2ef27"]
}, Open  ]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "2"}, 
  Closed]]]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "PrimaryExamplesSection"}, 
  Closed]]]],

Cell[BoxData[GridBox[{
   {
    DynamicBox[FEPrivate`ImportImage[
      FrontEnd`FileName[{"Documentation", "FooterIcons"}, 
       "RelatedFunction.png"]],
     ImageSizeCache->{50., {27., 33.}}], GridBox[{
      {
       StyleBox[
        RowBox[{"See", " ", "Also"}], "SeeAlsoSection"]},
      {Cell[TextData[{
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["ptr"]], "paclet:NewEoSArgon/ref/ptr", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "c4746482-eeaa-4ab2-b316-9b37e7a63405"],
        "\[NonBreakingSpace]",
        StyleBox[
        "\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
         "InlineSeparator"],
        " ",
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["pc"]], "paclet:NewEoSArgon/ref/pc", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "260bff91-f9cb-44fd-b305-57d3a0e302dc"],
        "\[NonBreakingSpace]",
        StyleBox[
        "\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
         "InlineSeparator"],
        " ",
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["ttr"]], "paclet:NewEoSArgon/ref/ttr", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "19e84567-60ee-4541-9e58-4adab2ec098b"],
        "\[NonBreakingSpace]",
        StyleBox[
        "\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
         "InlineSeparator"],
        " ",
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["tc"]], "paclet:NewEoSArgon/ref/tc", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "5ba47149-d843-4622-8215-5a718598babe"],
        "\[NonBreakingSpace]",
        StyleBox[
        "\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
         "InlineSeparator"],
        " ",
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["RhoSatVapNISTFromT"]], 
           "paclet:NewEoSArgon/ref/RhoSatVapNISTFromT", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "e42ae0f8-df7e-4153-9c1c-7d2dcaa4c3a5"],
        "\[NonBreakingSpace]",
        StyleBox[
        "\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
         "InlineSeparator"],
        " ",
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["RhoSatLiqNISTFromT"]], 
           "paclet:NewEoSArgon/ref/RhoSatLiqNISTFromT", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "f85c0873-4418-4f61-96fc-e5af4a4df3ad"]
       }], "SeeAlso",ExpressionUUID->"515961be-6e75-4264-9b2e-97171255d582"]}
     }]}
  }]], "SeeAlsoSection",ExpressionUUID->"295d0ba5-262d-4b60-848d-\
ba164cb1d623"],

Cell[BoxData[GridBox[{
   {
    DynamicBox[FEPrivate`ImportImage[
      FrontEnd`FileName[{"Documentation", "FooterIcons"}, "RelatedGuide.png"]],
     ImageSizeCache->{50., {27., 33.}}], GridBox[{
      {
       StyleBox[
        RowBox[{"Related", " ", "Guides"}], "MoreAboutSection"]},
      {
       RowBox[{"\[FilledVerySmallSquare]", Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["NewEoSArgon Package"]], 
           "paclet:NewEoSArgon/guide/NewEoSArgon"},
          "RefLinkPlain",
          BaseStyle->{"MoreAbout"}]], "MoreAbout",ExpressionUUID->
         "598fb426-9dfc-4623-806f-27278caf3f24"]}]}
     }]}
  }]], "MoreAboutSection",ExpressionUUID->"45bd9ad8-8189-4abb-9276-\
14e617d1d47b"],

Cell[BoxData[GridBox[{
   {
    TemplateBox[{29},
     "Spacer1"], GridBox[{
      {
       RowBox[{
        TemplateBox[{17},
         "Spacer1"], 
        StyleBox[
         RowBox[{"Related", " ", "Links"}], "RelatedLinksSection"]}]},
      {Cell[BoxData[Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData[
             RowBox[{
               RowBox[{"Units", " ", "&"}], " ", "Quantities"}]]], 
           "paclet:guide/Units"},
          "RefLinkPlain",
          BaseStyle->{"RelatedLinks"}]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "e2253ac4-40cf-4236-ba91-e46c35810153"]], "RelatedLinks",
        ExpressionUUID->"77e61bd2-3108-40b4-aedd-f0591bf14921"]},
      {Cell[BoxData[Cell[BoxData[Cell[BoxData[
          RowBox[{
           TemplateBox[{16},
            "Spacer1"], "\[FilledVerySmallSquare]", 
           TemplateBox[{
             Cell[
              TextData[
               Cell[
                TextData[{
                  Cell[
                   BoxData[
                    TemplateBox[{2}, "Spacer1"]]], "ThermodynamicData"}]]]], 
             "paclet:ref/ThermodynamicData"},
            "RefLink",
            BaseStyle->{"RelatedLinks"}]}]],ExpressionUUID->
          "72b857c0-d37e-4b77-beec-21c738e41746"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "e04b1d31-fec0-49a5-8ee9-709ca86d5e93"]], "RelatedLinks",
        ExpressionUUID->"a937adde-4d92-427a-bff6-fa33a3fc087d"]},
      {Cell[TextData[Cell[BoxData[
        RowBox[{
         TemplateBox[{16},
          "Spacer1"], "\[FilledVerySmallSquare]", Cell[BoxData[
          TemplateBox[{
            Cell[
             TextData[
              Cell[
               TextData[{
                 Cell[
                  BoxData[
                   TemplateBox[{2}, "Spacer1"]]], 
                 "Webbook de chimie NIST"}]]]], 
            "http://webbook.nist.gov/chemistry/fluid/"},
           "WebLink",
           BaseStyle->{"RelatedLinks"}]],ExpressionUUID->
          "ccdccdc4-1561-4de0-b11c-d35a076cf9de"]}]],ExpressionUUID->
        "49fac205-61eb-404f-9a87-693745fa3e4f"]], "RelatedLinks",
        ExpressionUUID->"33063bdd-ae01-4bbe-a1c3-4734d41cddd8"]}
     }]}
  }]], "RelatedLinksSection",ExpressionUUID->"15daec2f-ee38-4de1-8f9a-\
2dff8b25f99f"],

Cell[" ", "FooterCell",ExpressionUUID->"cfdac9f2-411a-4689-97d0-8af5b412c498"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{900, 835.8},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"PTSatNIST",
TaggingRules->{
 "ModificationHighlight" -> False, "ColorType" -> "", "LinkTrails" -> "", 
  "HasOptions" -> True, "ExampleCounter" -> 1, 
  "Openers" -> {
   "PrimaryExamplesSection" -> Open, 
    "ExampleSection" -> {"0" -> Open, "2" -> Closed}, "NotesSection" -> 
    Closed}, "NewStyles" -> True, "CitationPopupData" -> $Failed, 
  "ShowCitation" -> False, "RootCaptions" -> "", 
  "Metadata" -> {
   "built" -> "{2023, 11, 30, 13, 55, 53.3386375}", 
    "history" -> {"XX", "", "", ""}, "context" -> "NewEoSArgon`", 
    "keywords" -> {}, "specialkeywords" -> {}, 
    "tutorialcollectionlinks" -> {}, "index" -> True, "label" -> 
    "New Eo S Argon Package Symbol", "language" -> "en", "paclet" -> 
    "NewEoSArgon Package", "status" -> "None", "summary" -> 
    "PTSatNIST[T] \\[Congruent] P\\[Sigma] (bar) Pression sur la courbe de \
saturation donn\[EAcute]e par NIST en fonction de T (Kelvin) [Fitting \
function of the saturation pressure versus T (Kelvin) from the data of NIST]",
     "synonyms" -> {}, "tabletags" -> {}, "title" -> "PTSatNIST", 
    "titlemodifier" -> "", "metadescription" -> "", "windowtitle" -> 
    "PTSatNIST", "type" -> "Symbol", "uri" -> "NewEoSArgon/ref/PTSatNIST"}},
CellContext->"Global`",
FrontEndVersion->"13.3 pour Microsoft Windows (64-bit) (July 24, 2023)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "13.3 pour Microsoft Windows (64-bit) (July 24, 2023)", 
  StyleDefinitions -> "Default.nb"],
ExpressionUUID->"46911a7e-4698-4362-9362-fa7c4dc5850f"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[11582, 318, 1420, 37, 35, "PrimaryExamplesSection",ExpressionUUID->"64225709-292f-47b5-a140-ea7ed6111a65",
   CellTags->"PrimaryExamplesSection",
   CellID->993152026]},
 "RasterizedOutput"->{
  Cell[103689, 2025, 28595, 475, 288, "Output",ExpressionUUID->"f0cdc9ae-cd4e-4048-bee0-2f4af96e6666",
   CellTags->"RasterizedOutput",
   CellID->234535742]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 184390, 3686},
 {"RasterizedOutput", 184590, 3690}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[581, 21, 5664, 135, 56, "AnchorBarGrid",ExpressionUUID->"5591d0f6-e517-4d98-a88d-4a667b28ff35",
 CellID->1],
Cell[6248, 158, 94, 0, 23, "ContextNameCell",ExpressionUUID->"1d30e667-ec04-4670-9644-2f92050722c6"],
Cell[CellGroupData[{
Cell[6367, 162, 552, 14, 56, "ObjectNameGrid",ExpressionUUID->"d166b3bf-aa47-43de-a65e-e47dd77d3c74"],
Cell[6922, 178, 793, 21, 146, "Usage",ExpressionUUID->"799a4e21-c464-4c7d-88d8-6a82adaa7e0b"]
}, Open  ]],
Cell[CellGroupData[{
Cell[7752, 204, 1918, 48, 37, "NotesSection",ExpressionUUID->"403ee0fa-669b-444e-ae1e-111aec9ed93b",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->74224178],
Cell[9673, 254, 800, 25, 38, "Notes",ExpressionUUID->"fba69659-0210-41b2-b1bd-f7ace5363313",
 CellID->1067943069],
Cell[10476, 281, 186, 4, 36, "Notes",ExpressionUUID->"09c74a34-246a-4d8b-a9ca-090a83728ffb",
 CellID->224665577],
Cell[10665, 287, 790, 25, 38, "Notes",ExpressionUUID->"6471e290-7b92-4bec-9f84-4ed5b19e7f9e",
 CellID->431860626]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "NotesSection"}, Closed]]]],
Cell[CellGroupData[{
Cell[11582, 318, 1420, 37, 35, "PrimaryExamplesSection",ExpressionUUID->"64225709-292f-47b5-a140-ea7ed6111a65",
 CellTags->"PrimaryExamplesSection",
 CellID->993152026],
Cell[CellGroupData[{
Cell[13027, 359, 1398, 36, 30, "ExampleSection",ExpressionUUID->"fd6d89b0-3ed2-4094-8c6a-5be9c40e8722",
 CellID->546853994],
Cell[14428, 397, 174, 3, 26, "Input",ExpressionUUID->"efd9acd8-89ec-4440-8a19-13d7b36a9927",
 CellID->87419684],
Cell[14605, 402, 131, 1, 38, "ExampleText",ExpressionUUID->"ba1fd61e-5478-4988-86eb-fc72a5b21483",
 CellID->285078790],
Cell[CellGroupData[{
Cell[14761, 407, 235, 6, 26, "Input",ExpressionUUID->"26b28922-6eb2-4a66-8f36-ce11ef51b655",
 CellID->231987987],
Cell[14999, 415, 205, 4, 40, "Output",ExpressionUUID->"dab9057c-845b-459b-b20f-55c200e3c21d",
 CellID->44452636]
}, Open  ]],
Cell[CellGroupData[{
Cell[15241, 424, 605, 16, 26, "Input",ExpressionUUID->"0ce208aa-786c-41ed-8339-21120a4db4a3",
 CellID->71863064],
Cell[15849, 442, 223, 5, 39, "Output",ExpressionUUID->"280e3843-de70-4241-9533-2c6952059d8b",
 CellID->58743882]
}, Open  ]],
Cell[16087, 450, 135, 1, 38, "ExampleText",ExpressionUUID->"4e130122-0db1-4957-8c40-18a04effb748",
 CellID->184302421],
Cell[CellGroupData[{
Cell[16247, 455, 845, 23, 42, "Input",ExpressionUUID->"0ebaab37-baa9-4e06-860b-97269a9ff6da",
 CellID->223155686],
Cell[17095, 480, 209, 4, 39, "Output",ExpressionUUID->"d694e796-b2e9-41b7-93f3-e0338214ee24",
 CellID->105405309]
}, Open  ]],
Cell[17319, 487, 154, 1, 38, "ExampleText",ExpressionUUID->"50412b1f-6884-481f-9b7f-10710ec997ed",
 CellID->361149294],
Cell[CellGroupData[{
Cell[17498, 492, 443, 10, 26, "Input",ExpressionUUID->"2cbfdcda-f933-4e96-a6bc-136dbcb43fec",
 CellID->375583457],
Cell[17944, 504, 209, 4, 39, "Output",ExpressionUUID->"02721e87-4ca8-4fa3-8004-1c965056d651",
 CellID->545338054]
}, Open  ]],
Cell[18168, 511, 167, 3, 38, "ExampleText",ExpressionUUID->"a558d9d6-b091-4659-809c-2433a6200f67",
 CellID->886239600],
Cell[CellGroupData[{
Cell[18360, 518, 1301, 35, 57, "Input",ExpressionUUID->"113594e8-3c23-4903-868b-2707b41174e0",
 CellID->21488140],
Cell[19664, 555, 11610, 244, 70, "Output",ExpressionUUID->"da9236f1-0e36-4813-85d9-5d752a71fbc0",
 CellID->145587344]
}, Open  ]],
Cell[31289, 802, 116, 1, 70, "ExampleText",ExpressionUUID->"aa006b94-dafe-4b29-9c6f-21be49814bbe",
 CellID->351008126],
Cell[CellGroupData[{
Cell[31430, 807, 72256, 1216, 70, "WolframAlphaShortInput",ExpressionUUID->"d7a3c9ca-d073-45b0-b5a5-0da55a50473e",
 CellID->537052260],
Cell[103689, 2025, 28595, 475, 288, "Output",ExpressionUUID->"f0cdc9ae-cd4e-4048-bee0-2f4af96e6666",
 CellTags->"RasterizedOutput",
 CellID->234535742]
}, Open  ]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"}, Closed]]]],
Cell[CellGroupData[{
Cell[132433, 2508, 1419, 37, 70, "ExampleSection",ExpressionUUID->"6088cdc2-5588-429b-b12e-aac5d97284ac",
 CellID->258228157],
Cell[133855, 2547, 174, 3, 70, "Input",ExpressionUUID->"d47297c1-17d8-4efc-9d41-30b8c28d3484",
 CellID->85899407],
Cell[134032, 2552, 179, 3, 70, "ExampleText",ExpressionUUID->"372ca67a-9610-4650-8a5a-e8158552355e",
 CellID->605737459],
Cell[CellGroupData[{
Cell[134236, 2559, 2560, 67, 70, "Input",ExpressionUUID->"6fff82c1-4ea7-4278-9396-5941010015b7",
 CellID->206869432],
Cell[136799, 2628, 38693, 821, 70, "Output",ExpressionUUID->"7a6fb4f4-dedc-4bf3-be5f-da40dcf2ef27",
 CellID->135626984]
}, Open  ]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "2"}, Closed]]]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "PrimaryExamplesSection"}, Closed]]]],
Cell[175734, 3458, 3459, 94, 70, "SeeAlsoSection",ExpressionUUID->"295d0ba5-262d-4b60-848d-ba164cb1d623"],
Cell[179196, 3554, 729, 19, 70, "MoreAboutSection",ExpressionUUID->"45bd9ad8-8189-4abb-9276-14e617d1d47b"],
Cell[179928, 3575, 2350, 62, 70, "RelatedLinksSection",ExpressionUUID->"15daec2f-ee38-4de1-8f9a-2dff8b25f99f"],
Cell[182281, 3639, 78, 0, 70, "FooterCell",ExpressionUUID->"cfdac9f2-411a-4689-97d0-8af5b412c498"]
}
]
*)

(* End of internal cache information *)

