(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 13.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     42350,       1040]
NotebookOptionsPosition[     36544,        917]
NotebookOutlinePosition[     38628,        971]
CellTagsIndexPosition[     38543,        966]
WindowTitle->RR
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[GridBox[{
   {GridBox[{
      {
       ItemBox[Cell[BoxData[
         RowBox[{
          TemplateBox[{12},
           "Spacer1"], Cell["NEW EO S ARGON PACKAGE SYMBOL", "PacletNameCell",
           TextAlignment->Center,ExpressionUUID->
           "d126844c-a797-4ef8-bd3a-2cd2d399b541"], 
          TemplateBox[{8},
           "Spacer1"]}]],
         TextAlignment->Center,ExpressionUUID->
         "21842abb-0ab7-4d55-9e0e-04776c7a91f4"],
        Background->RGBColor[0.490196, 0.576471, 0.690196],
        ItemSize->Full], ""}
     },
     GridBoxAlignment->{"Rows" -> {{Center}}},
     GridBoxItemSize->{"Columns" -> {Full, 
         Scaled[0.02]}, "Rows" -> {{2.5}}}], Cell[TextData[{
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "See Also",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "e0637d7e-e48b-4894-85c7-f3fb0e0d09cb"]
         }],ExpressionUUID->"d6eac915-6a04-4b51-ae78-f9b281427383"],
         StripOnInput->False],{
        "\"Na\"" :> Documentation`HelpLookup["paclet:NewEoSArgon/ref/Na"], 
         "\"M\"" :> Documentation`HelpLookup["paclet:NewEoSArgon/ref/M"]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"SeeAlso"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "8add881b-5317-4e20-8004-733b690ca762"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "Related Guides",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "e1c9025d-eab8-43af-b767-8a8d45ed94cd"]
         }],ExpressionUUID->"34c8eb50-b40f-4c8e-952e-2343d5dcf86a"],
         StripOnInput->False],{
        "\"NewEoSArgon Package\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/guide/NewEoSArgon"]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"MoreAbout"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "54d4782f-6131-4cbd-a6ac-75d219c09456"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "URL",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "c2bec99e-c765-4efc-86aa-4fb444abaa9b"]
         }],ExpressionUUID->"664db052-6490-4266-bebb-88c498cd82fa"],
         StripOnInput->False],{
        "\"NewEoSArgon/ref/RR\"" :> None, 
         "\"Copy Wolfram Documentation Center URL\"" :> 
         Module[{DocumentationSearch`Private`nb$}, 
           DocumentationSearch`Private`nb$ = 
            NotebookPut[
             Notebook[{Cell["NewEoSArgon/ref/RR"]}, Visible -> False]]; 
           SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
           FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
           NotebookClose[DocumentationSearch`Private`nb$]; Null], Delimiter, 
         "\"Copy web URL\"" :> 
         Module[{DocumentationSearch`Private`nb$}, 
           DocumentationSearch`Private`nb$ = 
            NotebookPut[
             Notebook[{
               Cell[BoxData[
                 MakeBoxes[
                  Hyperlink[
                   "http://reference.wolfram.com/language/NewEoSArgon/ref/RR.\
html"], StandardForm]], "Input", TextClipboardType -> "PlainText"]}, Visible -> 
               False]]; 
           SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
           FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
           NotebookClose[DocumentationSearch`Private`nb$]; Null], 
         "\"Go to web URL\"" :> 
         FrontEndExecute[{
           NotebookLocate[{
             URL[If[TrueQ[DocumentationBuild`Make`Private`wsmlinkQ$28949], 
                 "http://reference.wolfram.com/system-modeler/", 
                 "http://reference.wolfram.com/language/"] <> 
               "NewEoSArgon/ref/RR" <> ".html"], None}]}]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"URLMenu"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "6db230d9-2931-4ec5-9ab3-0f3d559a69f7"]
    }], "AnchorBar",
     CacheGraphics->False,ExpressionUUID->
     "2379adc9-ac44-4762-8765-c60d3a76ec85"]}
  }]], "AnchorBarGrid",
 CellID->1,ExpressionUUID->"9306d5f6-99a2-405b-ad6c-368c7ef786bb"],

Cell["NewEoSArgon`", "ContextNameCell",ExpressionUUID->"388c99a9-c970-491a-afd0-c1d2f40ab3eb"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     Cell[
     "RR", "ObjectName",ExpressionUUID->
      "0dbb161e-e09c-435d-a8ff-7bf36126a894"],
     Cell[BoxData[
      TemplateBox[{8},
       "Spacer1"]],ExpressionUUID->"e11a5a37-44d7-4084-83aa-6894b0059f73"],
     Cell[BoxData[
     ""], "ObjectNameTranslation",ExpressionUUID->
      "929955bf-a9b5-4180-b3cf-4dbe8fff8acc"]
    }],ExpressionUUID->"da394be2-935d-4c42-81aa-95db4e93bfdc"], 
    "\[SpanFromLeft]"}
  }]], "ObjectNameGrid",ExpressionUUID->"987715be-61df-444c-8d2b-\
67e2c7001e58"],

Cell[BoxData[GridBox[{
   {"", Cell["\<\
Constante des gaz parfaits (J/mole/K)
[Universal Gas Constant (J/mole/K)]\
\>",ExpressionUUID->"9ae37cff-f3b5-422d-8275-e237ab4f1695"]}
  }]], "Usage",ExpressionUUID->"339eadf5-e9a4-4914-8e75-371966dc0ecc"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {
       TaggingRules, "Openers", "PrimaryExamplesSection"}, Open], 
      Alternatives[True, Open]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{13.600000000000001`, {5., 8.600000000000001}}]],
  ExpressionUUID->"913bd635-eb45-47da-a65b-22e3ed1b023a"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"534cac5c-2522-4295-8f94-a5f260d9bad6"],
 "Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "5547feef-247b-4db0-9f5e-0fc1cece537a"]
}], "PrimaryExamplesSection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellTags->"PrimaryExamplesSection",
 CellID->120461571,ExpressionUUID->"81450bb6-4483-483e-b4fa-657b739edff9"],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"},
        Closed], 
      Alternatives[Open, True]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{13.600000000000001`, {5., 8.600000000000001}}]],
  ExpressionUUID->"c98f6c83-13d0-4185-9eb2-144542495a42"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"dee37cea-e448-4991-a566-ed31634b747f"],
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "53d063a4-c268-432d-a230-04734be245ef"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellID->460559860,ExpressionUUID->"66cbf9c2-4644-4a1b-ba9c-8fac742166d5"],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<NewEoSArgon`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->87419684,ExpressionUUID->"85e470f8-d0b9-48c8-8fc2-ea7c03683899"],

Cell["Give a physical dimension to the constant", "ExampleText",
 CellID->886239600,ExpressionUUID->"fbf79d46-2693-4b2d-b121-4b5f1499e888"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Quantity", "[", 
  RowBox[{"RR", ",", "\"\<J/(mol K)\>\""}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->21488140,ExpressionUUID->"9f810b54-30f6-4b6a-a4ba-892edd54e97b"],

Cell[BoxData[
 TemplateBox[{"8.31451`", 
   RowBox[{
    "\"J\"", "\[InvisibleSpace]", "\"/(\"", "\[InvisibleSpace]", "\"K\"", 
     "\[ThinSpace]", "\"mol\"", "\[InvisibleSpace]", "\")\""}], 
   "joules per kelvin mole", 
   FractionBox["\"Joules\"", 
    RowBox[{"\"Kelvins\"", " ", "\"Moles\""}]]},
  "Quantity"]], "Output",
 CellLabel->"Out[2]=",
 CellID->585853501,ExpressionUUID->"11b0d6e5-49de-4ee4-aedd-ed82f7bc427f"]
}, Open  ]],

Cell[TextData[{
 "Comparison with Universal Gas Constant given by the ",
 ButtonBox["Units package",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/Units"]
}], "ExampleText",
 CellID->388741439,ExpressionUUID->"61c0e856-4ed3-4339-8727-df45a76e7fb1"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Quantity", "[", "\"\<MolarGasConstant\>\"", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->54617350,ExpressionUUID->"ccd774a9-ee83-482d-b411-565a999ec39a"],

Cell[BoxData[
 TemplateBox[{
   InterpretationBox["\[InvisibleSpace]", 1], 
   StyleBox["\"R\"", Italic, StripOnInput -> False], "molar gas constant", 
   "\"MolarGasConstant\""},
  "Quantity"]], "Output",
 CellLabel->"Out[3]=",
 CellID->180491486,ExpressionUUID->"086ff53b-3a95-466a-8ba3-c84d8817c3f7"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "@", 
  RowBox[{"UnitConvert", "[", 
   TemplateBox[{"1"},
    "QuantityUnit",
    DisplayFunction->(TooltipBox[
      StyleBox[
       RowBox[{#, "\[InvisibleSpace]", 
         StyleBox[
          RowBox[{" ", 
            StyleBox["\"R\"", Italic, StripOnInput -> False]}], 
          "QuantityUnitTraditionalLabel"]}], ShowStringCharacters -> False], 
      "Unit: molar gas constants"]& ),
    InterpretationFunction->(RowBox[{"Quantity", "[", 
       RowBox[{#, ",", "\"MolarGasConstant\""}], "]"}]& )], "]"}]}]], "Input",
 NumberMarks->False,
 CellLabel->"In[4]:=",
 CellID->756425963,ExpressionUUID->"c7daadba-1f71-4298-be73-29c9ad20e7a6"],

Cell[BoxData[
 TemplateBox[{"8.31446261815324`", 
   RowBox[{"\"kg\"", "\[ThinSpace]", 
     SuperscriptBox["\"m\"", "2"], "\[NegativeMediumSpace]", "\"/(\"", 
     "\[InvisibleSpace]", 
     SuperscriptBox["\"s\"", "2"], "\[InvisibleSpace]", "\"K\"", 
     "\[ThinSpace]", "\"mol\"", "\[InvisibleSpace]", "\")\""}], 
   "kilogram meters squared per second squared kelvin mole", 
   FractionBox[
    RowBox[{"\"Kilograms\"", " ", 
      SuperscriptBox["\"Meters\"", "2"]}], 
    RowBox[{"\"Kelvins\"", " ", "\"Moles\"", " ", 
      SuperscriptBox["\"Seconds\"", "2"]}]]},
  "Quantity"]], "Output",
 CellLabel->"Out[4]=",
 CellID->15048148,ExpressionUUID->"7957957b-1255-49be-b220-a6c8213d3117"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Rgp", "=", 
  RowBox[{"UnitConvert", "[", 
   RowBox[{
    RowBox[{"Quantity", "[", 
     RowBox[{"8.31446261815324`", ",", 
      FractionBox[
       RowBox[{"\"\<Kilograms\>\"", " ", 
        SuperscriptBox["\"\<Meters\>\"", "2"]}], 
       RowBox[{"\"\<Kelvins\>\"", " ", "\"\<Moles\>\"", " ", 
        SuperscriptBox["\"\<Seconds\>\"", "2"]}]]}], "]"}], ",", 
    "\"\<J/Moles/K\>\""}], "]"}]}]], "Input",
 NumberMarks->False,
 CellLabel->"In[5]:=",
 CellID->248489240,ExpressionUUID->"59e83191-e82d-4771-ae0b-f12076d7ced9"],

Cell[BoxData[
 TemplateBox[{"8.31446261815324`", 
   RowBox[{
    "\"J\"", "\[InvisibleSpace]", "\"/(\"", "\[InvisibleSpace]", "\"K\"", 
     "\[ThinSpace]", "\"mol\"", "\[InvisibleSpace]", "\")\""}], 
   "joules per kelvin mole", 
   FractionBox["\"Joules\"", 
    RowBox[{"\"Kelvins\"", " ", "\"Moles\""}]]},
  "Quantity"]], "Output",
 CellLabel->"Out[5]=",
 CellID->553945234,ExpressionUUID->"25e2f70b-d9c8-43eb-be6c-0f4899a76a40"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"QuantityMagnitude", "@", "Rgp"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->54018311,ExpressionUUID->"2a8a9030-9085-4748-97f7-7dd0df0337ed"],

Cell[BoxData["8.31446261815324`"], "Output",
 CellLabel->"Out[6]=",
 CellID->129142737,ExpressionUUID->"64e6f98d-e94f-446c-a09b-c0c380b7afb4"]
}, Open  ]],

Cell["Specific gaz constant of Argon", "ExampleText",
 CellID->223004501,ExpressionUUID->"fe491f20-1e41-407d-992e-b6ff6a693f0e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Quantity", "[", 
  RowBox[{
   RowBox[{"RR", "/", "M"}], ",", "\"\<kiloJoules/(Kelvins*Kilograms)\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->469504721,ExpressionUUID->"5ae270d9-f7c3-49cd-91b5-27e62091227c"],

Cell[BoxData[
 TemplateBox[{"0.20813332332031642`", 
   RowBox[{
    "\"kJ\"", "\[InvisibleSpace]", "\"/(\"", "\[InvisibleSpace]", "\"kg\"", 
     "\[ThinSpace]", "\"K\"", "\[InvisibleSpace]", "\")\""}], 
   "kilojoules per kilogram kelvin", 
   FractionBox["\"Kilojoules\"", 
    RowBox[{"\"Kelvins\"", " ", "\"Kilograms\""}]]},
  "Quantity"]], "Output",
 CellLabel->"Out[7]=",
 CellID->848733111,ExpressionUUID->"4665cd64-9bb8-4b92-9f39-d995b2f8c4b4"]
}, Open  ]],

Cell["Using WolframAlpha", "ExampleText",
 CellID->169290125,ExpressionUUID->"894690f8-4136-4956-98d7-849699c8504a"],

Cell[CellGroupData[{

Cell[BoxData[
 NamespaceBox["WolframAlphaQueryResults",
  DynamicModuleBox[{Typeset`q$$ = "Universal gas constant", Typeset`opts$$ = {
   AppearanceElements -> {
     "Extrusion", "Warnings", "Assumptions", "Pods", "Unsuccessful"}, 
    Asynchronous -> All, 
    Method -> {
     "ExtrusionChosen" -> {
       "Fast parse", "Fast parse", 1, 0, "Input", 
        "Quantity[1, \"MolarGasConstant\"]"}, "ExtrusionOpen" -> True, 
      "Formats" -> {"cell", "minput", "moutput", "msound", "dataformats"}}}, 
   Typeset`elements$$ = {
   "Extrusion", "Warnings", "Assumptions", "Pods", "Unsuccessful"}, 
   Typeset`pod1$$ = XMLElement[
   "pod", {"title" -> "Input interpretation", "scanner" -> "Identity", "id" -> 
     "Input", "position" -> "100", "error" -> "false", "numsubpods" -> "1"}, {
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement["minput", {}, {"Quantity[1, \"MolarGasConstant\"]"}], 
       XMLElement["cell", {"compressed" -> False, "string" -> True}, {
         Cell[
          BoxData[
           FormBox[
            StyleBox[
             TagBox[
              TagBox[
               RowBox[{
                 StyleBox[
                  StyleBox["\"R\"", Italic, StripOnInput -> False], 
                  FontFamily -> "Helvetica", FontSize -> Smaller], "  ", 
                 StyleBox[
                  
                  RowBox[{
                   "\"(\"", "\[NoBreak]", "\"molar gas constant\"", 
                    "\[NoBreak]", "\")\""}], {
                  FontFamily :> $CellContext`$UnitFontFamily, FontSize -> 
                   Smaller, 
                   GrayLevel[0.6], 
                   LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                   0}, StripOnInput -> False]}], Identity], 
              PolynomialForm[#, TraditionalOrder -> False]& ], 
             LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 0, 
             ZeroWidthTimes -> False], TraditionalForm]], "Output"]}], 
       XMLElement["dataformats", {}, {"plaintext,minput"}]}]}], 
   Typeset`pod2$$ = XMLElement[
   "pod", {"title" -> "Value", "scanner" -> "Unit", "id" -> "Value", 
     "position" -> "200", "error" -> "false", "numsubpods" -> "5"}, {
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement["cell", {"compressed" -> False, "string" -> True}, {
         Cell[
          BoxData[
           FormBox[
            StyleBox[
             TagBox[
              RowBox[{
                TagBox[
                 TagBox[
                  RowBox[{
                    TagBox["8.3145", 
                    $CellContext`TagBoxWrapper["StringBoxes" -> "8.3145"]], 
                    "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    
                    RowBox[{
                    "\"J\"", "\[InvisibleSpace]", "\"/\"", 
                    "\[InvisibleSpace]", 
                    
                    RowBox[{
                    "\"(\"", "\[InvisibleSpace]", "\"mol\"", 
                    "\[InvisibleSpace]", "\"\[ThinSpace]\"", 
                    "\[InvisibleSpace]", "\"K\"", "\[InvisibleSpace]", 
                    "\")\""}]}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller]}], Identity], #& , SyntaxForm -> Dot], "  ", 
                StyleBox[
                 
                 RowBox[{
                  "\"(\"", "\[NoBreak]", "\"joules per mole kelvin\"", 
                   "\[NoBreak]", "\")\""}], {
                 FontFamily :> $CellContext`$UnitFontFamily, FontSize -> 
                  Smaller, 
                  GrayLevel[0.6], LinebreakAdjustments -> {1, 100, 1, 0, 100},
                   LineIndent -> 0}, StripOnInput -> False]}], "Unit", 
              SyntaxForm -> Dot], LinebreakAdjustments -> {1, 100, 1, 0, 100},
              LineIndent -> 0, ZeroWidthTimes -> False], TraditionalForm]], 
          "Output"]}], 
       XMLElement[
       "dataformats", {}, {
        "plaintext,computabledata,formatteddata,numberdata,quantitydata"}]}], 
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement["cell", {"compressed" -> False, "string" -> True}, {
         Cell[
          BoxData[
           FormBox[
            StyleBox[
             TagBox[
              RowBox[{
                TagBox[
                 TagBox[
                  RowBox[{
                    TagBox["0.08206", 
                    $CellContext`TagBoxWrapper["StringBoxes" -> "0.08206"]], 
                    "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    RowBox[{
                    
                    RowBox[{
                    "\"L\"", "\[InvisibleSpace]", "\"\[ThinSpace]\"", 
                    "\[InvisibleSpace]", "\"atm\""}], "\[InvisibleSpace]", 
                    "\"/\"", "\[InvisibleSpace]", 
                    
                    RowBox[{
                    "\"(\"", "\[InvisibleSpace]", "\"mol\"", 
                    "\[InvisibleSpace]", "\"\[ThinSpace]\"", 
                    "\[InvisibleSpace]", "\"K\"", "\[InvisibleSpace]", 
                    "\")\""}]}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller]}], Identity], #& , SyntaxForm -> Dot], "  ", 
                StyleBox[
                 
                 RowBox[{
                  "\"(\"", "\[NoBreak]", 
                   "\"liter atmospheres per mole kelvin\"", "\[NoBreak]", 
                   "\")\""}], {
                 FontFamily :> $CellContext`$UnitFontFamily, FontSize -> 
                  Smaller, 
                  GrayLevel[0.6], LinebreakAdjustments -> {1, 100, 1, 0, 100},
                   LineIndent -> 0}, StripOnInput -> False]}], "Unit", 
              SyntaxForm -> Dot], LinebreakAdjustments -> {1, 100, 1, 0, 100},
              LineIndent -> 0, ZeroWidthTimes -> False], TraditionalForm]], 
          "Output"]}], 
       XMLElement[
       "dataformats", {}, {
        "plaintext,computabledata,formatteddata,numberdata,quantitydata"}]}], 
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement["cell", {"compressed" -> False, "string" -> True}, {
         Cell[
          BoxData[
           FormBox[
            StyleBox[
             TagBox[
              RowBox[{
                TagBox[
                 TagBox[
                  RowBox[{
                    TagBox["1.987", 
                    $CellContext`TagBoxWrapper["StringBoxes" -> "1.987"]], 
                    "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    
                    RowBox[{
                    "\"cal\"", "\[InvisibleSpace]", "\"/\"", 
                    "\[InvisibleSpace]", 
                    
                    RowBox[{
                    "\"(\"", "\[InvisibleSpace]", "\"mol\"", 
                    "\[InvisibleSpace]", "\"\[ThinSpace]\"", 
                    "\[InvisibleSpace]", "\"K\"", "\[InvisibleSpace]", 
                    "\")\""}]}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller]}], Identity], #& , SyntaxForm -> Dot], "  ", 
                StyleBox[
                 
                 RowBox[{
                  "\"(\"", "\[NoBreak]", "\"calories per mole kelvin\"", 
                   "\[NoBreak]", "\")\""}], {
                 FontFamily :> $CellContext`$UnitFontFamily, FontSize -> 
                  Smaller, 
                  GrayLevel[0.6], LinebreakAdjustments -> {1, 100, 1, 0, 100},
                   LineIndent -> 0}, StripOnInput -> False]}], "Unit", 
              SyntaxForm -> Dot], LinebreakAdjustments -> {1, 100, 1, 0, 100},
              LineIndent -> 0, ZeroWidthTimes -> False], TraditionalForm]], 
          "Output"]}], 
       XMLElement[
       "dataformats", {}, {
        "plaintext,computabledata,formatteddata,numberdata,quantitydata"}]}], 
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement["cell", {"compressed" -> False, "string" -> True}, {
         Cell[
          BoxData[
           FormBox[
            StyleBox[
             TagBox[
              RowBox[{
                TagBox[
                 TagBox[
                  RowBox[{
                    TagBox[
                    RowBox[{"8.314", 
                    StyleBox["\[Times]", 
                    GrayLevel[0.5]], 
                    SuperscriptBox["10", "7"]}], 
                    $CellContext`TagBoxWrapper[
                    "StringBoxes" -> RowBox[{"8.314", "\[Times]", 
                    SuperscriptBox["10", "7"]}]], SyntaxForm -> CenterDot], 
                    "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    
                    RowBox[{
                    "\"erg\"", "\[InvisibleSpace]", "\"/\"", 
                    "\[InvisibleSpace]", 
                    
                    RowBox[{
                    "\"(\"", "\[InvisibleSpace]", "\"mol\"", 
                    "\[InvisibleSpace]", "\"\[ThinSpace]\"", 
                    "\[InvisibleSpace]", "\"K\"", "\[InvisibleSpace]", 
                    "\")\""}]}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller]}], Identity], #& , SyntaxForm -> Dot], "  ", 
                StyleBox[
                 
                 RowBox[{
                  "\"(\"", "\[NoBreak]", "\"ergs per mole kelvin\"", 
                   "\[NoBreak]", "\")\""}], {
                 FontFamily :> $CellContext`$UnitFontFamily, FontSize -> 
                  Smaller, 
                  GrayLevel[0.6], LinebreakAdjustments -> {1, 100, 1, 0, 100},
                   LineIndent -> 0}, StripOnInput -> False]}], "Unit", 
              SyntaxForm -> Dot], LinebreakAdjustments -> {1, 100, 1, 0, 100},
              LineIndent -> 0, ZeroWidthTimes -> False], TraditionalForm]], 
          "Output"]}], 
       XMLElement[
       "dataformats", {}, {
        "plaintext,computabledata,formatteddata,numberdata,quantitydata"}]}], 
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement["cell", {"compressed" -> False, "string" -> True}, {
         Cell[
          BoxData[
           FormBox[
            StyleBox[
             TagBox[
              RowBox[{
                TagBox[
                 TagBox[
                  RowBox[{
                    TagBox["8.314", 
                    $CellContext`TagBoxWrapper["StringBoxes" -> "8.314"]], 
                    "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["\"m\"", "3"], "\[InvisibleSpace]", 
                    "\"\[ThinSpace]\"", "\[InvisibleSpace]", "\"Pa\""}], 
                    "\[InvisibleSpace]", "\"/\"", "\[InvisibleSpace]", 
                    
                    RowBox[{
                    "\"(\"", "\[InvisibleSpace]", "\"mol\"", 
                    "\[InvisibleSpace]", "\"\[ThinSpace]\"", 
                    "\[InvisibleSpace]", "\"K\"", "\[InvisibleSpace]", 
                    "\")\""}]}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller]}], Identity], #& , SyntaxForm -> Dot], "  ", 
                StyleBox[
                 
                 RowBox[{
                  "\"(\"", "\[NoBreak]", 
                   "\"cubic meter pascals per mole kelvin\"", "\[NoBreak]", 
                   "\")\""}], {
                 FontFamily :> $CellContext`$UnitFontFamily, FontSize -> 
                  Smaller, 
                  GrayLevel[0.6], LinebreakAdjustments -> {1, 100, 1, 0, 100},
                   LineIndent -> 0}, StripOnInput -> False]}], "Unit", 
              SyntaxForm -> Dot], LinebreakAdjustments -> {1, 100, 1, 0, 100},
              LineIndent -> 0, ZeroWidthTimes -> False], TraditionalForm]], 
          "Output"]}], 
       XMLElement[
       "dataformats", {}, {
        "plaintext,computabledata,formatteddata,numberdata,quantitydata"}]}], 
     XMLElement["states", {"count" -> "1"}, {
       XMLElement[
       "state", {"name" -> "More", "input" -> "Value__More"}, {}]}]}], 
   Typeset`pod3$$ = XMLElement[
   "pod", {"title" -> "Interpretations", "scanner" -> "Unit", "id" -> 
     "Interpretation", "position" -> "300", "error" -> "false", "numsubpods" -> 
     "1"}, {
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement["cell", {"compressed" -> False, "string" -> True}, {
         Cell[
          BoxData[
           FormBox[
            TagBox["\"molar entropy\"", Identity], TraditionalForm]], 
          "Output"]}], 
       XMLElement[
       "dataformats", {}, {"plaintext,computabledata,formatteddata"}]}], 
     XMLElement["states", {"count" -> "1"}, {
       XMLElement[
       "state", {
        "name" -> "More", "input" -> "Interpretation__More"}, {}]}]}], 
   Typeset`pod4$$ = XMLElement[
   "pod", {"title" -> "Basic unit dimensions", "scanner" -> "Unit", "id" -> 
     "BasicUnitDimensions", "position" -> "400", "error" -> "false", 
     "numsubpods" -> "1"}, {
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement["cell", {"compressed" -> False, "string" -> True}, {
         Cell[
          BoxData[
           FormBox[
            TagBox[
             RowBox[{"\"[mass]\"", " ", 
               
               TemplateBox[{"\"[length]\"", "2"}, "Superscript", SyntaxForm -> 
                SuperscriptBox], " ", 
               TemplateBox[{"\"[time]\"", 
                 RowBox[{"-", "2"}]}, "Superscript", SyntaxForm -> 
                SuperscriptBox], " ", 
               TemplateBox[{"\"[temperature]\"", 
                 RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> 
                SuperscriptBox], " ", 
               TemplateBox[{"\"[amount]\"", 
                 RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> 
                SuperscriptBox]}], HoldForm], TraditionalForm]], "Output"]}], 
       XMLElement[
       "dataformats", {}, {
        "plaintext,computabledata,formatteddata,formuladata"}]}]}], 
   Typeset`aux1$$ = {True, False, {False}, True}, Typeset`aux2$$ = {
   True, False, {False, False, False, False, False}, True}, Typeset`aux3$$ = {
   True, False, {False}, True}, Typeset`aux4$$ = {True, False, {False}, True},
    Typeset`asyncpods$$ = {}, Typeset`nonpods$$ = {
    XMLElement["assumptions", {"count" -> "1"}, {
      XMLElement[
      "assumption", {
       "type" -> "Clash", "word" -> "Universal gas constant", "template" -> 
        "Assuming \"${word}\" is ${desc1}. Use as ${desc2} instead", "count" -> 
        "2"}, {
        XMLElement[
        "value", {
         "name" -> "Unit", "desc" -> "a unit", "input" -> 
          "*C.Universal+gas+constant-_*Unit-"}, {}], 
        XMLElement[
        "value", {
         "name" -> "Word", "desc" -> "a word", "input" -> 
          "*C.Universal+gas+constant-_*Word-"}, {}]}]}]}, Typeset`initdone$$ =
    True, Typeset`queryinfo$$ = {
   "success" -> "true", "error" -> "false", "numpods" -> "4", "datatypes" -> 
    "Quantity", "timedout" -> "", "timedoutpods" -> "", "timing" -> "1.351", 
    "parsetiming" -> "0.277", "parsetimedout" -> "false", "recalculate" -> "",
     "id" -> "MSPa65421i2fa8c4bba8fdab000034aebh04g0d63743", "host" -> 
    "http://www4b.wolframalpha.com", "server" -> "7", "related" -> 
    "http://www4b.wolframalpha.com/api/v2/relatedQueries.jsp?id=\
MSPa65431i2fa8c4bba8fdab000052880i8hbgg54h1b&s=7", "version" -> "2.6"}, 
   Typeset`sessioninfo$$ = {
   "TimeZone" -> 1., 
    "Date" -> {2014, 2, 6, 16, 39, 45.1557292`9.40728772632191}, "Line" -> 19,
     "SessionID" -> 23597498814303192354}, Typeset`showpods$$ = {1, 2, 3, 4}, 
   Typeset`failedpods$$ = {}, Typeset`chosen$$ = {
   "Fast parse", "Fast parse", 1, 0, "Input", 
    "Quantity[1, \"MolarGasConstant\"]"}, Typeset`open$$ = True, 
   Typeset`newq$$ = "Universal gas constant"}, 
   DynamicBox[ToBoxes[
     AlphaIntegration`FormatAlphaResults[
      Dynamic[{
       1, {Typeset`pod1$$, Typeset`pod2$$, Typeset`pod3$$, Typeset`pod4$$}, {
        Typeset`aux1$$, Typeset`aux2$$, Typeset`aux3$$, Typeset`aux4$$}, 
        Typeset`chosen$$, Typeset`open$$, Typeset`elements$$, Typeset`q$$, 
        Typeset`opts$$, Typeset`nonpods$$, Typeset`queryinfo$$, 
        Typeset`sessioninfo$$, Typeset`showpods$$, Typeset`failedpods$$, 
        Typeset`newq$$}]], StandardForm],
    ImageSizeCache->{560., {535., 19.}},
    TrackedSymbols:>{Typeset`showpods$$, Typeset`failedpods$$}],
   DynamicModuleValues:>{},
   Initialization:>If[
     Not[Typeset`initdone$$], Null; WolframAlphaClient`Private`doAsyncUpdates[
       Hold[{Typeset`pod1$$, Typeset`pod2$$, Typeset`pod3$$, Typeset`pod4$$}],
        Typeset`asyncpods$$, 
       Dynamic[Typeset`failedpods$$]]; Typeset`asyncpods$$ = {}; 
     Typeset`initdone$$ = True],
   SynchronousInitialization->False],
  BaseStyle->{Deployed -> True},
  DeleteWithContents->True,
  Editable->False,
  SelectWithContents->True]], "WolframAlphaShortInput",
 CellLabel->"In[33]:=",
 CellID->223728714,ExpressionUUID->"70703a93-197d-4be5-a424-0c312cf56b41"],

Cell[BoxData[
 TemplateBox[{
   InterpretationBox["\[InvisibleSpace]", 1], 
   StyleBox["\"R\"", Italic, StripOnInput -> False], "molar gas constant", 
   "\"MolarGasConstant\""},
  "Quantity"]], "Output",
 CellLabel->"Out[33]=",
 CellID->269609473,ExpressionUUID->"5bb6cf59-729a-4a3e-86e7-ceea9b813474"]
}, Open  ]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"}, 
  Closed]]]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "PrimaryExamplesSection"}, 
  Closed]]]],

Cell[BoxData[GridBox[{
   {
    DynamicBox[FEPrivate`ImportImage[
      FrontEnd`FileName[{"Documentation", "FooterIcons"}, 
       "RelatedFunction.png"]],
     ImageSizeCache->{50., {27., 33.}}], GridBox[{
      {
       StyleBox[
        RowBox[{"See", " ", "Also"}], "SeeAlsoSection"]},
      {Cell[TextData[{
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["Na"]], "paclet:NewEoSArgon/ref/Na", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "19ad6af9-fcb0-4579-8acb-390f9cc7d56a"],
        "\[NonBreakingSpace]",
        StyleBox[
        "\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
         "InlineSeparator"],
        " ",
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["M"]], "paclet:NewEoSArgon/ref/M", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "010626ee-d188-4e57-9270-a3f2e6ce79b0"]
       }], "SeeAlso",ExpressionUUID->"8447a63d-c76f-4e89-b7df-202a6c5421f4"]}
     }]}
  }]], "SeeAlsoSection",ExpressionUUID->"a393098c-1b15-4479-a676-\
ef58e679409d"],

Cell[BoxData[GridBox[{
   {
    DynamicBox[FEPrivate`ImportImage[
      FrontEnd`FileName[{"Documentation", "FooterIcons"}, "RelatedGuide.png"]],
     ImageSizeCache->{50., {27., 33.}}], GridBox[{
      {
       StyleBox[
        RowBox[{"Related", " ", "Guides"}], "MoreAboutSection"]},
      {
       RowBox[{"\[FilledVerySmallSquare]", Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["NewEoSArgon Package"]], 
           "paclet:NewEoSArgon/guide/NewEoSArgon"},
          "RefLinkPlain",
          BaseStyle->{"MoreAbout"}]], "MoreAbout",ExpressionUUID->
         "67bc2c0d-78b8-4734-b617-6639295cad10"]}]}
     }]}
  }]], "MoreAboutSection",ExpressionUUID->"978d2bb8-1a74-4f7f-9a65-\
74f90fea512b"],

Cell[BoxData[GridBox[{
   {
    TemplateBox[{29},
     "Spacer1"], GridBox[{
      {
       RowBox[{
        TemplateBox[{17},
         "Spacer1"], 
        StyleBox[
         RowBox[{"Related", " ", "Links"}], "RelatedLinksSection"]}]},
      {Cell[BoxData[Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData[
             RowBox[{
               RowBox[{"Units", " ", "&"}], " ", "Quantities"}]]], 
           "paclet:guide/Units"},
          "RefLinkPlain",
          BaseStyle->{"RelatedLinks"}]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "68cb184e-40bf-489f-8c8c-5d9f620ea48a"]], "RelatedLinks",
        ExpressionUUID->"e2f64664-258e-4ab6-968e-df8c17773d4f"]}
     }]}
  }]], "RelatedLinksSection",ExpressionUUID->"6b59fb20-c7a2-4f41-9180-\
0a2789917363"],

Cell[" ", "FooterCell",ExpressionUUID->"046d017a-471f-418e-b197-18bc7b48e58a"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{900, 835.8},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"RR",
TaggingRules->{
 "ModificationHighlight" -> False, "ColorType" -> "", "LinkTrails" -> "", 
  "HasOptions" -> True, "ExampleCounter" -> 1, 
  "Openers" -> {
   "PrimaryExamplesSection" -> Open, "ExampleSection" -> {"0" -> Open}}, 
  "NewStyles" -> True, "CitationPopupData" -> $Failed, "ShowCitation" -> 
  False, "RootCaptions" -> "", 
  "Metadata" -> {
   "built" -> "{2023, 11, 30, 13, 56, 6.7778052}", 
    "history" -> {"XX", "", "", ""}, "context" -> "NewEoSArgon`", 
    "keywords" -> {}, "specialkeywords" -> {}, 
    "tutorialcollectionlinks" -> {}, "index" -> True, "label" -> 
    "New Eo S Argon Package Symbol", "language" -> "en", "paclet" -> 
    "NewEoSArgon Package", "status" -> "None", "summary" -> 
    "Constante des gaz parfaits (J/mole/K) [Universal Gas Constant \
(J/mole/K)]", "synonyms" -> {}, "tabletags" -> {}, "title" -> "RR", 
    "titlemodifier" -> "", "metadescription" -> "", "windowtitle" -> "RR", 
    "type" -> "Symbol", "uri" -> "NewEoSArgon/ref/RR"}},
CellContext->"Global`",
FrontEndVersion->"13.3 pour Microsoft Windows (64-bit) (July 24, 2023)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "13.3 pour Microsoft Windows (64-bit) (July 24, 2023)", 
  StyleDefinitions -> "Default.nb"],
ExpressionUUID->"9957fd9d-7920-4617-9e71-11e5a53f77ed"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6744, 180, 1420, 37, 35, "PrimaryExamplesSection",ExpressionUUID->"81450bb6-4483-483e-b4fa-657b739edff9",
   CellTags->"PrimaryExamplesSection",
   CellID->120461571]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 38344, 959}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[574, 21, 5216, 127, 56, "AnchorBarGrid",ExpressionUUID->"9306d5f6-99a2-405b-ad6c-368c7ef786bb",
 CellID->1],
Cell[5793, 150, 94, 0, 23, "ContextNameCell",ExpressionUUID->"388c99a9-c970-491a-afd0-c1d2f40ab3eb"],
Cell[CellGroupData[{
Cell[5912, 154, 545, 14, 56, "ObjectNameGrid",ExpressionUUID->"987715be-61df-444c-8d2b-67e2c7001e58"],
Cell[6460, 170, 247, 5, 118, "Usage",ExpressionUUID->"339eadf5-e9a4-4914-8e75-371966dc0ecc"]
}, Open  ]],
Cell[CellGroupData[{
Cell[6744, 180, 1420, 37, 35, "PrimaryExamplesSection",ExpressionUUID->"81450bb6-4483-483e-b4fa-657b739edff9",
 CellTags->"PrimaryExamplesSection",
 CellID->120461571],
Cell[CellGroupData[{
Cell[8189, 221, 1398, 36, 30, "ExampleSection",ExpressionUUID->"66cbf9c2-4644-4a1b-ba9c-8fac742166d5",
 CellID->460559860],
Cell[9590, 259, 174, 3, 26, "Input",ExpressionUUID->"85e470f8-d0b9-48c8-8fc2-ea7c03683899",
 CellID->87419684],
Cell[9767, 264, 139, 1, 38, "ExampleText",ExpressionUUID->"fbf79d46-2693-4b2d-b121-4b5f1499e888",
 CellID->886239600],
Cell[CellGroupData[{
Cell[9931, 269, 198, 4, 26, "Input",ExpressionUUID->"9f810b54-30f6-4b6a-a4ba-892edd54e97b",
 CellID->21488140],
Cell[10132, 275, 425, 10, 43, "Output",ExpressionUUID->"11b0d6e5-49de-4ee4-aedd-ed82f7bc427f",
 CellID->585853501]
}, Open  ]],
Cell[10572, 288, 251, 6, 38, "ExampleText",ExpressionUUID->"61c0e856-4ed3-4339-8727-df45a76e7fb1",
 CellID->388741439],
Cell[CellGroupData[{
Cell[10848, 298, 181, 3, 26, "Input",ExpressionUUID->"ccd774a9-ee83-482d-b411-565a999ec39a",
 CellID->54617350],
Cell[11032, 303, 303, 7, 39, "Output",ExpressionUUID->"086ff53b-3a95-466a-8ba3-c84d8817c3f7",
 CellID->180491486]
}, Open  ]],
Cell[CellGroupData[{
Cell[11372, 315, 674, 17, 26, "Input",ExpressionUUID->"c7daadba-1f71-4298-be73-29c9ad20e7a6",
 CellID->756425963],
Cell[12049, 334, 694, 15, 45, "Output",ExpressionUUID->"7957957b-1255-49be-b220-a6c8213d3117",
 CellID->15048148]
}, Open  ]],
Cell[CellGroupData[{
Cell[12780, 354, 552, 14, 46, "Input",ExpressionUUID->"59e83191-e82d-4771-ae0b-f12076d7ced9",
 CellID->248489240],
Cell[13335, 370, 434, 10, 43, "Output",ExpressionUUID->"25e2f70b-d9c8-43eb-be6c-0f4899a76a40",
 CellID->553945234]
}, Open  ]],
Cell[CellGroupData[{
Cell[13806, 385, 164, 3, 26, "Input",ExpressionUUID->"2a8a9030-9085-4748-97f7-7dd0df0337ed",
 CellID->54018311],
Cell[13973, 390, 142, 2, 35, "Output",ExpressionUUID->"64e6f98d-e94f-446c-a09b-c0c380b7afb4",
 CellID->129142737]
}, Open  ]],
Cell[14130, 395, 128, 1, 38, "ExampleText",ExpressionUUID->"fe491f20-1e41-407d-992e-b6ff6a693f0e",
 CellID->223004501],
Cell[CellGroupData[{
Cell[14283, 400, 247, 6, 26, "Input",ExpressionUUID->"5ae270d9-f7c3-49cd-91b5-27e62091227c",
 CellID->469504721],
Cell[14533, 408, 453, 10, 43, "Output",ExpressionUUID->"4665cd64-9bb8-4b92-9f39-d995b2f8c4b4",
 CellID->848733111]
}, Open  ]],
Cell[15001, 421, 116, 1, 70, "ExampleText",ExpressionUUID->"894690f8-4136-4956-98d7-849699c8504a",
 CellID->169290125],
Cell[CellGroupData[{
Cell[15142, 426, 17871, 386, 70, "WolframAlphaShortInput",ExpressionUUID->"70703a93-197d-4be5-a424-0c312cf56b41",
 CellID->223728714],
Cell[33016, 814, 304, 7, 39, "Output",ExpressionUUID->"5bb6cf59-729a-4a3e-86e7-ceea9b813474",
 CellID->269609473]
}, Open  ]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"}, Closed]]]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "PrimaryExamplesSection"}, Closed]]]],
Cell[33562, 830, 1337, 36, 70, "SeeAlsoSection",ExpressionUUID->"a393098c-1b15-4479-a676-ef58e679409d"],
Cell[34902, 868, 729, 19, 70, "MoreAboutSection",ExpressionUUID->"978d2bb8-1a74-4f7f-9a65-74f90fea512b"],
Cell[35634, 889, 825, 24, 70, "RelatedLinksSection",ExpressionUUID->"6b59fb20-c7a2-4f41-9180-0a2789917363"],
Cell[36462, 915, 78, 0, 70, "FooterCell",ExpressionUUID->"046d017a-471f-418e-b197-18bc7b48e58a"]
}
]
*)

(* End of internal cache information *)

