(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 13.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    123241,       2684]
NotebookOptionsPosition[    114571,       2511]
NotebookOutlinePosition[    117069,       2573]
CellTagsIndexPosition[    116945,       2567]
WindowTitle->RhoArgonNv
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[GridBox[{
   {GridBox[{
      {
       ItemBox[Cell[BoxData[
         RowBox[{
          TemplateBox[{12},
           "Spacer1"], Cell["NEW EO S ARGON PACKAGE SYMBOL", "PacletNameCell",
           TextAlignment->Center,ExpressionUUID->
           "372258eb-6c09-4610-9ef0-c04533b71946"], 
          TemplateBox[{8},
           "Spacer1"]}]],
         TextAlignment->Center,ExpressionUUID->
         "6aded77b-7e18-4f56-9311-b2b26f3437c1"],
        Background->RGBColor[0.490196, 0.576471, 0.690196],
        ItemSize->Full], ""}
     },
     GridBoxAlignment->{"Rows" -> {{Center}}},
     GridBoxItemSize->{"Columns" -> {Full, 
         Scaled[0.02]}, "Rows" -> {{2.5}}}], Cell[TextData[{
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "See Also",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "177dcc80-e719-4d80-8a70-634b44f991d1"]
         }],ExpressionUUID->"344e0222-f32b-4eeb-92cd-4fe9a47a8641"],
         StripOnInput->False],{
        "\"PArgonNv\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/PArgonNv"], 
         "\"RhoSatLiqFromT\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/RhoSatLiqFromT"], 
         "\"RhoSatVapFromT\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/RhoSatVapFromT"]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"SeeAlso"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "9b7f8368-0ef3-48b4-a2fd-bb3ffe30f4ad"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "Related Guides",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "a448bdb4-daf8-4ce2-98e4-5b3c1c58c818"]
         }],ExpressionUUID->"0a1196e5-01e8-4a02-94d4-6ef7c5cb4349"],
         StripOnInput->False],{
        "\"NewEoSArgon Package\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/guide/NewEoSArgon"]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"MoreAbout"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "32a41be9-afc4-4174-bffd-f2409eb38382"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "URL",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "34de68e8-4698-49f8-9ed2-a3b519abf5ad"]
         }],ExpressionUUID->"7a97ce7a-0c66-4473-b226-ec9f4f9eb5b6"],
         StripOnInput->False],{
        "\"NewEoSArgon/ref/RhoArgonNv\"" :> None, 
         "\"Copy Wolfram Documentation Center URL\"" :> 
         Module[{DocumentationSearch`Private`nb$}, 
           DocumentationSearch`Private`nb$ = 
            NotebookPut[
             Notebook[{Cell["NewEoSArgon/ref/RhoArgonNv"]}, Visible -> 
               False]]; 
           SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
           FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
           NotebookClose[DocumentationSearch`Private`nb$]; Null], Delimiter, 
         "\"Copy web URL\"" :> 
         Module[{DocumentationSearch`Private`nb$}, 
           DocumentationSearch`Private`nb$ = 
            NotebookPut[
             Notebook[{
               Cell[BoxData[
                 MakeBoxes[
                  Hyperlink[
                   "http://reference.wolfram.com/language/NewEoSArgon/ref/\
RhoArgonNv.html"], StandardForm]], "Input", TextClipboardType -> 
                 "PlainText"]}, Visible -> False]]; 
           SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
           FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
           NotebookClose[DocumentationSearch`Private`nb$]; Null], 
         "\"Go to web URL\"" :> 
         FrontEndExecute[{
           NotebookLocate[{
             URL[If[TrueQ[DocumentationBuild`Make`Private`wsmlinkQ$22729], 
                 "http://reference.wolfram.com/system-modeler/", 
                 "http://reference.wolfram.com/language/"] <> 
               "NewEoSArgon/ref/RhoArgonNv" <> ".html"], None}]}]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"URLMenu"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "7ea0e8db-2016-4acb-9f84-6cd184498ffc"]
    }], "AnchorBar",
     CacheGraphics->False,ExpressionUUID->
     "a8240b99-7f46-4a0a-b5a3-d6b319ed0fe1"]}
  }]], "AnchorBarGrid",
 CellID->1,ExpressionUUID->"3897dd34-9d64-400b-bc35-1f0a79021263"],

Cell["NewEoSArgon`", "ContextNameCell",ExpressionUUID->"179d8617-0cd7-4932-9d71-0d2e9bdc2b80"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     Cell[
     "RhoArgonNv", "ObjectName",ExpressionUUID->
      "83fbbb49-c700-4f83-973b-a609ce5cf7a5"],
     Cell[BoxData[
      TemplateBox[{8},
       "Spacer1"]],ExpressionUUID->"a483388b-b17e-4c71-b2f1-e1bf5bb8a7ee"],
     Cell[BoxData[
     ""], "ObjectNameTranslation",ExpressionUUID->
      "46398f30-d694-4348-bdc6-c127087240eb"]
    }],ExpressionUUID->"6e7bb584-cd94-4794-92b2-0b36e908baf8"], 
    "\[SpanFromLeft]"}
  }]], "ObjectNameGrid",ExpressionUUID->"f5d915cd-b001-42b9-be0e-\
aee9243a02ba"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"RhoArgonNv", "[", 
       StyleBox[
        RowBox[{"T", ",", " ", "P", ",", " ", "Phase"}],
        FontSlant->"Italic"], "]"}]], "InlineFormula",
      ShowStringCharacters->False,
      FontFamily->"Source Sans Pro",ExpressionUUID->
      "e5f94fae-ba9e-4f88-bc00-8bc91c889eca"],
     " \[Congruent] \[Rho] (g/",
     Cell[BoxData[
      SuperscriptBox["cm", "3"]], "InlineFormula",
      FontFamily->"Source Sans Pro",ExpressionUUID->
      "0c5dcf33-f75f-4ab7-9afb-194ede2de773"],
     ")\nDensit\[EAcute] de l'argon en fonction de ",
     StyleBox["T",
      FontSlant->"Italic"],
     " (Kelvin) et de ",
     StyleBox["P",
      FontSlant->"Italic"],
     " (bar)\n[Argon density as a function of ",
     StyleBox["T",
      FontSlant->"Italic"],
     " (Kelvin) and ",
     StyleBox["P",
      FontSlant->"Italic"],
     " (bar)]"
    }],ExpressionUUID->"9e255043-ec5c-412d-84ec-e3c418ec6318"]}
  }]], "Usage",
 Deletable->True,ExpressionUUID->"067fca2a-4df2-4348-bc58-72448b8dce73"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[Cell[TextData[{
   Cell[BoxData[
    DynamicBox[ToBoxes[
      If[
       MatchQ[
        CurrentValue[
         EvaluationNotebook[], {TaggingRules, "Openers", "NotesSection"}, 
         Closed], 
        Alternatives[Open, True]], 
       Style[
        Graphics[{
          Thickness[0.18], 
          RGBColor[0.8509803921568627, 0.396078431372549, 0], 
          Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
         PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
        0.68 Inherited], 
       Rotate[
        Style[
         Graphics[{
           Thickness[0.18], 
           RGBColor[0.8509803921568627, 0.396078431372549, 0], 
           Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
          PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
         0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
     ImageSizeCache->{
      13.600000000000001`, {0.5800000000000001, 13.020000000000001`}}]],
    ExpressionUUID->"1403311d-e580-4b61-9c05-628f54d12879"],
   Cell[BoxData[
    TemplateBox[{1},
     "Spacer1"]],ExpressionUUID->"20cf2d9b-bda8-4b78-bbe8-445da9b3a29b"],
   "Details and Options"
  }], "NotesFrameText",ExpressionUUID->"1eeec9a7-68f6-42d0-af87-886d4b7540f5"],
  Appearance->{Automatic, None, "Normal", Automatic},
  BaseStyle->None,
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"], 
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], After, CellContents]}]& ),
  Evaluator->None,
  Method->
   "Preemptive"]],ExpressionUUID->"695f07bf-5088-4246-a6fa-2ac5fca26346"]], \
"NotesSection",
 WholeCellGroupOpener->True,
 CellGroupingRules->{"SectionGrouping", 50},
 CacheGraphics->False,
 CellID->35117658,ExpressionUUID->"0147dae7-84e6-42a4-96ec-7c8c5b6fa820"],

Cell[TextData[{
 "La fonction est d\[EAcute]finie pour ",
 StyleBox["T",
  FontSlant->"Italic"],
 " \[GreaterEqual] ",
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["ttr"]], "paclet:NewEoSArgon/ref/ttr", 
    "NewEoSArgon Package Symbol"},
   "PackageLink",
   BaseStyle->"InlineFormula"]], "InlineFormula",
  FontFamily->"Source Sans Pro",ExpressionUUID->
  "e001e229-e5cd-4662-a58c-c81bbd0dbf35"],
 " et ",
 StyleBox["P",
  FontSlant->"Italic"],
 " > 0"
}], "Notes",
 CellID->1067943069,ExpressionUUID->"70ccb58d-2362-4ff0-8506-6e1b04cb9775"],

Cell[TextData[{
 "La fonction ",
 StyleBox["RhoArgonNv",
  FontSlant->"Italic"],
 " est d\[EAcute]termin\[EAcute]e par l'inverse de la fonction ",
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["PArgonNv"]], "paclet:NewEoSArgon/ref/PArgonNv", 
    "NewEoSArgon Package Symbol"},
   "PackageLink",
   BaseStyle->"InlineFormula"]], "InlineFormula",
  FontFamily->"Source Sans Pro",ExpressionUUID->
  "b88629e5-ef60-4c9a-8023-bc603ec87c01"],
 ". L'inversion n\[EAcute]cessite de se donner une valeur initiale de la \
densit\[EAcute]; c'est le r\[OHat]le du param\[EGrave]tre \"Phase\" qui peut \
prendre les valeurs suivantes :"
}], "Notes",
 CellID->7319701,ExpressionUUID->"c3c2d82a-f3c9-44f9-a074-a347b78da439"],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon",ExpressionUUID->
     "1633da9d-ac58-4a85-984f-7ccc16cc6459"], 
    RowBox[{"\"\<G\>\"", "      "}], Cell["\<\
Une valeur de densit\[EAcute] dans le gaz est automatiquement choisie \
\>", "TableText",ExpressionUUID->"916bbae9-ae8c-4b91-a46f-e463c0749538"]},
   {Cell["      ", "TableRowIcon",ExpressionUUID->
     "eff76f8c-4962-442c-8298-bc0608a34faf"], "\"\<L\>\"", 
    RowBox[{
    "Une", " ", "valeur", " ", "de", " ", "densit\[EAcute]", " ", "dans", " ",
      "le", " ", "liquide", " ", "est", " ", "automatiquement", " ", 
     "choisie"}]},
   {Cell["      ", "TableRowIcon",ExpressionUUID->
     "cb562cd6-654a-4651-aaf2-6737fcd099e0"], "\"\<S\>\"", Cell["\<\
Une valeur proche de la densit\[EAcute] critique est automatiquement choisie \
\>", "TableText",ExpressionUUID->"cd0aa775-a424-4f37-ad3c-16b77d612e57"]},
   {Cell["      ", "TableRowIcon",ExpressionUUID->
     "a9572bd8-75da-4964-b1b4-25701397d0eb"], 
    RowBox[{"  ", "\[Rho]"}], Cell[
    "Une valeur num\[EAcute]rique  quelconque peut \[EHat]tre saisie", 
     "TableText",ExpressionUUID->"0693b125-1582-4df0-b998-1384f1f027ff"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "Notes",
 CellID->482355032,ExpressionUUID->"ea93b35e-884b-4111-8c71-f5bfd4768d2c"],

Cell["Par d\[EAcute]faut, le param\[EGrave]tre \"Phase\" est fix\[EAcute] \
\[AGrave] la valeur \"L\"", "Notes",
 CellID->46430647,ExpressionUUID->"27e8dd2b-6164-404c-9a74-d934f8bb795c"],

Cell["\<\
******************************************************************************\
*****\
\>", "Notes",
 CellID->185021568,ExpressionUUID->"1a1ec76c-d00a-4350-8704-3df6d622026c"],

Cell[TextData[{
 "The function is defined for ",
 StyleBox["T",
  FontSlant->"Italic"],
 " \[GreaterEqual] ",
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["ttr"]], "paclet:NewEoSArgon/ref/ttr", 
    "NewEoSArgon Package Symbol"},
   "PackageLink",
   BaseStyle->"InlineFormula"]], "InlineFormula",
  FontFamily->"Source Sans Pro",ExpressionUUID->
  "27afbfb3-c19e-4b00-a61d-0846345b03cc"],
 " and ",
 StyleBox["P",
  FontSlant->"Italic"],
 " > 0"
}], "Notes",
 CellID->19381920,ExpressionUUID->"becca9c9-3c07-4baf-ab30-3632d01b2645"],

Cell[TextData[{
 "The function ",
 StyleBox["RhoArgonNv",
  FontSlant->"Italic"],
 " is determined by the inverse of the function ",
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["PArgonNv"]], "paclet:NewEoSArgon/ref/PArgonNv", 
    "NewEoSArgon Package Symbol"},
   "PackageLink",
   BaseStyle->"InlineFormula"]], "InlineFormula",
  FontFamily->"Source Sans Pro",ExpressionUUID->
  "5827d826-08c0-41a9-9d9d-07ca6f08def7"],
 ". The inversion requires an initial density value; this is the role of the \
\"Phase\" parameter, which can take the following values:"
}], "Notes",
 CellID->240432791,ExpressionUUID->"a8eb8cc7-cd35-4ca5-8da4-9f113e240e53"],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon",ExpressionUUID->
     "feeeef3f-7a00-458d-bf57-2815aa2d182f"], 
    RowBox[{"\"\<G\>\"", "      "}], Cell[
    "A density value in the gas is automatically selected ", "TableText",
     ExpressionUUID->"af174c04-a7e8-485b-9063-aba21f814907"]},
   {Cell["      ", "TableRowIcon",ExpressionUUID->
     "bdefc008-4358-47f9-ae17-f049e5f1f28d"], "\"\<L\>\"", 
    RowBox[{
    "A", " ", "density", " ", "value", " ", "in", " ", "the", " ", "liquid", 
     " ", "is", " ", "automatically", " ", "selected"}]},
   {Cell["      ", "TableRowIcon",ExpressionUUID->
     "1edddb1d-f59c-42e8-8b35-2b363e0db988"], "\"\<S\>\"", Cell["\<\
A value close to the critical density is automatically selected \
\>", "TableText",ExpressionUUID->"dbf0224d-dfa8-474a-9b2b-b3c9d72897df"]},
   {Cell["      ", "TableRowIcon",ExpressionUUID->
     "cc69cdc2-e8f5-4997-a4ed-6562b753647d"], 
    RowBox[{"  ", "\[Rho]"}], Cell[
    "Any numeric value can be specified", "TableText",ExpressionUUID->
     "56481b58-16c2-4c31-9c6a-dbbe5bbbc305"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "Notes",
 CellID->363814092,ExpressionUUID->"b98327b4-bc21-4d8f-817e-248aec036972"],

Cell["By default, the \"Phase\" parameter is set to \"L\".", "Notes",
 CellID->67088494,ExpressionUUID->"39831638-1996-4655-b709-20f4be3ef205"]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "NotesSection"}, Closed]]]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {
       TaggingRules, "Openers", "PrimaryExamplesSection"}, Open], 
      Alternatives[True, Open]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{13.600000000000001`, {5., 8.600000000000001}}]],
  ExpressionUUID->"d4059265-3f4f-4959-92aa-846827c95b0a"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"31d79a40-5148-43e1-95be-677b948557e8"],
 "Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount",ExpressionUUID->
  "7a2e620c-2602-4896-b129-4a2bd95c02a1"]
}], "PrimaryExamplesSection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellTags->"PrimaryExamplesSection",
 CellID->252868828,ExpressionUUID->"fe434113-5c76-4556-8c41-6a64cdbf1502"],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"},
        Closed], 
      Alternatives[Open, True]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{13.600000000000001`, {5., 8.600000000000001}}]],
  ExpressionUUID->"1098164c-2ce7-43c8-9c56-647f03b78b16"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"e77b3dc5-1285-4195-8e40-d0dcc70f2142"],
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "5b5a76eb-0622-48c5-9c42-f39e296ab9c7"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellID->528986751,ExpressionUUID->"2035950b-8053-4196-a8cb-2b4793f47033"],

Cell[BoxData[{
 RowBox[{"Needs", "[", "\"\<NewEoSArgon`\>\"", "]"}], "\[IndentingNewLine]", 
 RowBox[{"Off", "[", 
  RowBox[{"General", "::", "munfl"}], "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->87419684,ExpressionUUID->"d5b0535c-30e7-44f9-8450-a9ffdae6757c"],

Cell["Relative error with NIST constant", "ExampleText",
 CellID->32289193,ExpressionUUID->"1271a8fd-c674-4836-9b12-b3586de33529"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Print", "[", "\"\<At the triple point:\>\"", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Quantity", "[", 
  RowBox[{
   RowBox[{"100", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"\[Rho]trliq", "-", 
       RowBox[{"RhoArgonNv", "[", 
        RowBox[{"ttr", ",", "ptr"}], "]"}]}], ")"}], "/", "\[Rho]trliq"}]}], 
   ",", "\"\<%\>\""}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Quantity", "[", 
   RowBox[{
    RowBox[{"100", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"\[Rho]trgaz", "-", 
        RowBox[{"RhoArgonNv", "[", 
         RowBox[{"ttr", ",", "ptr", ",", "\"\<G\>\""}], "]"}]}], ")"}], "/", 
      "\[Rho]trgaz"}]}], ",", "\"\<%\>\""}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", "\"\<At the critical point:\>\"", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Quantity", "[", 
  RowBox[{
   RowBox[{"100", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"\[Rho]c", "-", 
       RowBox[{"RhoArgonNv", "[", 
        RowBox[{"tc", ",", "pc", ",", "\"\<S\>\""}], "]"}]}], ")"}], "/", 
     "\[Rho]c"}]}], ",", "\"\<%\>\""}], "]"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->86367826,ExpressionUUID->"bd9ab31c-a710-4dcd-9e79-0ac5503ea32b"],

Cell[BoxData["\<\"At the triple point:\"\>"], "Print",
 CellLabel->"Lors de l\[CloseCurlyQuote]\[EAcute]valuation de In[22]:=",
 CellID->146229627,ExpressionUUID->"ef8cd3d2-7028-4ae3-baaf-2586f0acb914"],

Cell[BoxData[
 TemplateBox[{
   RowBox[{"-", "5.3559622675834476`*^-8"}], "\"%\"", "percent", 
   "\"Percent\""},
  "QuantityPostfix"]], "Output",
 CellLabel->"Out[2]=",
 CellID->755494874,ExpressionUUID->"a45e2480-aa74-4045-a9b4-b66d37f616ee"],

Cell[BoxData[
 TemplateBox[{
   RowBox[{"-", "0.000026198037036559806`"}], "\"%\"", "percent", 
   "\"Percent\""},
  "QuantityPostfix"]], "Output",
 CellLabel->"Out[2]=",
 CellID->217294124,ExpressionUUID->"1d10de82-099e-4ad7-a946-80e333be7429"],

Cell[BoxData["\<\"At the critical point:\"\>"], "Print",
 CellLabel->"Lors de l\[CloseCurlyQuote]\[EAcute]valuation de In[22]:=",
 CellID->30343616,ExpressionUUID->"b1f832c8-0d59-4200-a663-ec0cfd259aed"],

Cell[BoxData[
 TemplateBox[{"0.013608828223546207`", "\"%\"", "percent", "\"Percent\""},
  "QuantityPostfix"]], "Output",
 CellLabel->"Out[2]=",
 CellID->14652057,ExpressionUUID->"5f5bd847-3424-4eca-b716-7a64039b8fe1"]
}, Open  ]],

Cell[TextData[{
 "Plot ",
 StyleBox["RhoArgonNv",
  FontSlant->"Italic"],
 " versus temperature and comparison with saturated liquid curve from NIST"
}], "ExampleText",
 CellID->886239600,ExpressionUUID->"cc853832-73e5-4d05-99bc-45462164a9c2"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"RhoArgonNv", "[", 
      RowBox[{"T", ",", 
       RowBox[{"PTSatNIST", "[", "T", "]"}]}], "]"}], ",", 
     RowBox[{"RhoSatLiqNISTFromT", "[", "T", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"T", ",", "ttr", ",", "tc"}], "}"}], ",", 
   RowBox[{"AxesOrigin", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"ttr", ",", "\[Rho]c"}], "}"}]}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Red", ",", 
      RowBox[{"{", 
       RowBox[{"Dashed", ",", "Black"}], "}"}]}], "}"}]}], ",", 
   RowBox[{"Frame", "->", "True"}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Quantity", "[", 
       RowBox[{"T", ",", "\"\<Kelvins\>\""}], "]"}], ",", 
      RowBox[{"Quantity", "[", 
       RowBox[{"\[Rho]", ",", "\"\<g/cm^3\>\""}], "]"}]}], "}"}]}], ",", 
   RowBox[{"ImageSize", "\[Rule]", "400"}], ",", 
   RowBox[{"PlotLegends", "\[Rule]", 
    RowBox[{"Placed", "[", 
     RowBox[{"\"\<Expressions\>\"", ",", "Below"}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->21488140,ExpressionUUID->"6bb1b7fe-3b95-44c2-9016-0bc1edbba6b8"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[
    InterpretationBox[{
      TagBox[{{{}, {}, 
         TagBox[{
           RGBColor[1, 0, 0], 
           AbsoluteThickness[2], 
           Opacity[1.], 
           LineBox[CompressedData["
1:eJwV0Gs0FHgYBnASqaSksRG1ihRbaXLrSO8blmwhMq5jzPzFahU7K7IuibLW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            "]]}, Annotation[#, "Charting`Private`Tag#1"]& ], 
         TagBox[{
           GrayLevel[0], 
           AbsoluteThickness[2], 
           Opacity[1.], 
           Dashing[{Small, Small}], 
           LineBox[CompressedData["
1:eJwV03s4FHgXB3CrlPZVrUSuWy4TuiDRS+KcSiFZDTNixmXmt6IoksS2Uai8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            "]]}, Annotation[#, "Charting`Private`Tag#2"]& ]}, {}}, {
       "WolframDynamicHighlight", <|
        "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>}], 
      DynamicBox[
       (Charting`HighlightActionBox["DynamicHighlight", {}, 
        Slot["HighlightElements"], 
        Slot["LayoutOptions"], 
        Slot["Meta"], 
        Charting`HighlightActionFunction["DynamicHighlight", {{{{}, {}, 
            Annotation[{
              Directive[
               Opacity[1.], 
               AbsoluteThickness[2], 
               RGBColor[1, 0, 0]], 
              Line[CompressedData["
1:eJwV0Gs0FHgYBnASqaSksRG1ihRbaXLrSO8blmwhMq5jzPzFahU7K7IuibLW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               "]]}, "Charting`Private`Tag#1"], 
            Annotation[{
              Directive[
               Opacity[1.], 
               AbsoluteThickness[2], 
               Dashing[{Small, Small}], 
               GrayLevel[0]], 
              Line[CompressedData["
1:eJwV03s4FHgXB3CrlPZVrUSuWy4TuiDRS+KcSiFZDTNixmXmt6IoksS2Uai8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               "]]}, "Charting`Private`Tag#2"]}}, {}}, <|
         "HighlightElements" -> <|
           "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
          "LayoutOptions" -> <|
           "PlotRange" -> {{83.8058, 150.687}, {0.535599, 
             1.4168017259602959`}}, "Frame" -> {{True, True}, {True, True}}, 
            "AxesOrigin" -> {83.8058, 0.535599}, 
            "ImageSize" -> {400, 400/GoldenRatio}, "Axes" -> {True, True}, 
            "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
            "DefaultStyle" -> {
              Directive[
               Opacity[1.], 
               AbsoluteThickness[2], 
               Dashing[{Small, Small}], 
               GrayLevel[0]], 
              Directive[
               Opacity[1.], 
               AbsoluteThickness[2], 
               RGBColor[1, 0, 0]]}, 
            "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
                Identity[
                 Part[#, 1]], 
                Identity[
                 Part[#, 2]]}& ), 
              "ScalingFunctions" -> {{Identity, Identity}, {
                Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
            False|>, 
          "Meta" -> <|
           "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
            Plot, "GroupHighlight" -> False|>|>]]& )[<|
        "HighlightElements" -> <|
          "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
         "LayoutOptions" -> <|
          "PlotRange" -> {{83.8058, 150.687}, {0.535599, 
            1.4168017259602959`}}, "Frame" -> {{True, True}, {True, True}}, 
           "AxesOrigin" -> {83.8058, 0.535599}, 
           "ImageSize" -> {400, 400/GoldenRatio}, "Axes" -> {True, True}, 
           "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
           "DefaultStyle" -> {
             Directive[
              Opacity[1.], 
              AbsoluteThickness[2], 
              Dashing[{Small, Small}], 
              GrayLevel[0]], 
             Directive[
              Opacity[1.], 
              AbsoluteThickness[2], 
              RGBColor[1, 0, 0]]}, 
           "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
               Identity[
                Part[#, 1]], 
               Identity[
                Part[#, 2]]}& ), 
             "ScalingFunctions" -> {{Identity, Identity}, {
               Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
           False|>, 
         "Meta" -> <|
          "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
           Plot, "GroupHighlight" -> False|>|>], 
       ImageSizeCache -> {{4.503599627370496*^15, -4.503599627370496*^15}, {
        4.503599627370496*^15, -4.503599627370496*^15}}]}, 
     Annotation[{{{{}, {}, 
         Annotation[{
           Directive[
            Opacity[1.], 
            AbsoluteThickness[2], 
            RGBColor[1, 0, 0]], 
           Line[CompressedData["
1:eJwV0Gs0FHgYBnASqaSksRG1ihRbaXLrSO8blmwhMq5jzPzFahU7K7IuibLW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            "]]}, "Charting`Private`Tag#1"], 
         Annotation[{
           Directive[
            Opacity[1.], 
            AbsoluteThickness[2], 
            Dashing[{Small, Small}], 
            GrayLevel[0]], 
           Line[CompressedData["
1:eJwV03s4FHgXB3CrlPZVrUSuWy4TuiDRS+KcSiFZDTNixmXmt6IoksS2Uai8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            "]]}, "Charting`Private`Tag#2"]}}, {}}, <|
      "HighlightElements" -> <|
        "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
       "LayoutOptions" -> <|
        "PlotRange" -> {{83.8058, 150.687}, {0.535599, 1.4168017259602959`}}, 
         "Frame" -> {{True, True}, {True, True}}, 
         "AxesOrigin" -> {83.8058, 0.535599}, 
         "ImageSize" -> {400, 400/GoldenRatio}, "Axes" -> {True, True}, 
         "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
         "DefaultStyle" -> {
           Directive[
            Opacity[1.], 
            AbsoluteThickness[2], 
            Dashing[{Small, Small}], 
            GrayLevel[0]], 
           Directive[
            Opacity[1.], 
            AbsoluteThickness[2], 
            RGBColor[1, 0, 0]]}, 
         "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
             Identity[
              Part[#, 1]], 
             Identity[
              Part[#, 2]]}& ), 
           "ScalingFunctions" -> {{Identity, Identity}, {
             Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>, 
       "Meta" -> <|
        "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
         Plot, "GroupHighlight" -> False|>|>, "DynamicHighlight"]], 
    AspectRatio -> NCache[GoldenRatio^(-1), 0.6180339887498948], 
    Axes -> {True, True}, AxesLabel -> {None, None}, 
    AxesOrigin -> {83.8058, 0.535599}, DisplayFunction -> Identity, 
    Frame -> {{True, True}, {True, True}}, FrameLabel -> {{
       FormBox[
        TagBox[
         TemplateBox[{"\[Rho]", 
           RowBox[{"\"g\"", "\[InvisibleSpace]", "\"/\"", "\[InvisibleSpace]", 
             SuperscriptBox["\"cm\"", "3"]}], "grams per centimeter cubed", 
           FractionBox["\"Grams\"", 
            SuperscriptBox["\"Centimeters\"", "3"]]}, "QuantityTF", 
          SyntaxForm -> Mod], HoldForm], TraditionalForm], None}, {
       FormBox[
        TagBox[
         TemplateBox[{
           TagBox[
            TagBox["T", HoldForm], HoldForm], "\"K\"", "kelvins", 
           "\"Kelvins\""}, "QuantityTF", SyntaxForm -> Mod], HoldForm], 
        TraditionalForm], None}}, 
    FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
    GridLines -> {None, None}, GridLinesStyle -> Directive[
      GrayLevel[0.5, 0.4]], ImagePadding -> All, ImageSize -> 400, 
    Method -> {
     "DefaultBoundaryStyle" -> Automatic, 
      "DefaultGraphicsInteraction" -> {
       "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
        "Effects" -> {
         "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
          "Droplines" -> {
           "freeformCursorMode" -> True, 
            "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
      "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> None, 
      "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& ), "CopiedValueFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& )}}, 
    PlotRange -> {{83.8058, 150.687}, {0.535599, 1.4168017259602959`}}, 
    PlotRangeClipping -> True, PlotRangePadding -> {{
       Scaled[0.02], 
       Scaled[0.02]}, {
       Scaled[0.05], 
       Scaled[0.05]}}, Ticks -> {Automatic, Automatic}], 
   FormBox[
    FormBox[
     TemplateBox[{
       RowBox[{"RhoArgonNv", "(", 
         RowBox[{
           TagBox["T", HoldForm], ",", 
           RowBox[{"PTSatNIST", "(", 
             TagBox["T", HoldForm], ")"}]}], ")"}], 
       RowBox[{"RhoSatLiqNISTFromT", "(", 
         TagBox["T", HoldForm], ")"}]}, "LineLegend", 
      DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    AbsoluteThickness[2], 
                    RGBColor[1, 0, 0]], {
                    LineBox[{{0, 12.5}, {40, 12.5}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    AbsoluteThickness[2], 
                    RGBColor[1, 0, 0]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {40, 12.5}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.18000000000000002`] -> 
                    Baseline)], #}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.8, 0.5}}}], "Grid"]}, {
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    AbsoluteThickness[2], 
                    Dashing[{Small, Small}], 
                    GrayLevel[0]], {
                    LineBox[{{0, 12.5}, {40, 12.5}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    AbsoluteThickness[2], 
                    Dashing[{Small, Small}], 
                    GrayLevel[0]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {40, 12.5}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.18000000000000002`] -> 
                    Baseline)], #2}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.8, 0.5}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxDividers -> {"Columns" -> {{None}}, "Rows" -> {{None}}}, 
             GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}}, 
             GridBoxSpacings -> {"Columns" -> {{0}}, "Rows" -> {{1}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
         FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
         False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"LineLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   RowBox[{"AbsoluteThickness", "[", "2", "]"}], ",", 
                   
                   TemplateBox[<|"color" -> RGBColor[1, 0, 0]|>, 
                    "RGBColorSwatchTemplate"]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   RowBox[{"AbsoluteThickness", "[", "2", "]"}], ",", 
                   RowBox[{"Dashing", "[", 
                    RowBox[{"{", 
                    RowBox[{"Small", ",", "Small"}], "}"}], "]"}], ",", 
                   
                   TemplateBox[<|"color" -> GrayLevel[0]|>, 
                    "GrayLevelColorSwatchTemplate"]}], "]"}]}], "}"}], ",", 
           RowBox[{"{", 
             RowBox[{
               TagBox[#, HoldForm], ",", 
               TagBox[#2, HoldForm]}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", "None"}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Row\""}]}], "]"}]& ), 
      Editable -> True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"]}, {
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "Below"}], "]"}]}], "]"}]& )]], "Output",
 CellLabel->"Out[3]=",
 CellID->391752160,ExpressionUUID->"21f3a094-69c4-460b-8e4f-798863670655"]
}, Open  ]],

Cell["Normal density (at 0\[Degree]C)", "ExampleText",
 CellID->164375273,ExpressionUUID->"c8a31417-d952-440e-b648-4a08e581e771"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"NormalPressure", "=", 
   RowBox[{"N", "@", 
    RowBox[{"QuantityMagnitude", "@", 
     RowBox[{"UnitConvert", "[", 
      RowBox[{
       RowBox[{"Quantity", "[", 
        RowBox[{"1", ",", "\"\<atm\>\""}], "]"}], ",", "\"\<Bars\>\""}], 
      "]"}]}]}]}], ";"}], "\n", 
 RowBox[{"\[Rho]n", "=", 
  RowBox[{"Quantity", "[", 
   RowBox[{
    RowBox[{"RhoArgonNv", "[", 
     RowBox[{
      RowBox[{"N", "@", 
       RowBox[{"QuantityMagnitude", "@", 
        RowBox[{"UnitConvert", "[", 
         RowBox[{
          RowBox[{"Quantity", "[", 
           RowBox[{"0", ",", "\"\<DegreesCelsius\>\""}], "]"}], ",", 
          "\"\<Kelvins\>\""}], "]"}]}]}], ",", "NormalPressure"}], "]"}], ",", 
    RowBox[{"\"\<Grams\>\"", "/", 
     SuperscriptBox["\"\<Centimeters\>\"", "3"]}]}], "]"}]}]}], "Input",
 CellLabel->"In[4]:=",
 CellID->127806170,ExpressionUUID->"b84e5cfe-6c05-475d-8b42-a6620fb40973"],

Cell[BoxData[
 TemplateBox[{"0.0017837635522093228`", 
   RowBox[{"\"g\"", "\[InvisibleSpace]", "\"/\"", "\[InvisibleSpace]", 
     SuperscriptBox["\"cm\"", "3"]}], "grams per centimeter cubed", 
   FractionBox["\"Grams\"", 
    SuperscriptBox["\"Centimeters\"", "3"]]},
  "Quantity"]], "Output",
 CellLabel->"Out[4]=",
 CellID->115804259,ExpressionUUID->"59f250b3-fa29-4ad2-95b5-28f4dfa40a20"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UnitConvert", "[", 
  RowBox[{
   TemplateBox[{"0.0017837635522093224`"},
    "QuantityUnit",
    DisplayFunction->(TooltipBox[
      StyleBox[
       RowBox[{#, "\[InvisibleSpace]", 
         StyleBox[
          RowBox[{" ", 
            
            RowBox[{"\"g\"", "\[InvisibleSpace]", "\"/\"", 
              "\[InvisibleSpace]", 
              SuperscriptBox["\"cm\"", "3"]}]}], 
          "QuantityUnitTraditionalLabel"]}], ShowStringCharacters -> False], 
      "Unit: grams per centimeter cubed"]& ),
    InterpretationFunction->(RowBox[{"Quantity", "[", 
       RowBox[{#, ",", 
         FractionBox["\"Grams\"", 
          SuperscriptBox["\"Centimeters\"", "3"]]}], "]"}]& )], ",", 
   "\"\<kg/m^3\>\""}], "]"}]], "Input",
 NumberMarks->False,
 CellLabel->"In[5]:=",
 CellID->82940876,ExpressionUUID->"c33cab73-a2c8-4e1e-b41c-78b939f89d69"],

Cell[BoxData[
 TemplateBox[{"1.7837635522093225`", 
   RowBox[{"\"kg\"", "\[InvisibleSpace]", "\"/\"", "\[InvisibleSpace]", 
     SuperscriptBox["\"m\"", "3"]}], "kilograms per meter cubed", 
   FractionBox["\"Kilograms\"", 
    SuperscriptBox["\"Meters\"", "3"]]},
  "Quantity"]], "Output",
 CellLabel->"Out[5]=",
 CellID->5008835,ExpressionUUID->"c9cb9566-0d82-4add-81c3-2f20ea90f3c9"]
}, Open  ]],

Cell["Using ThermodynamicData package (i.e. REFPROP from NIST)", "ExampleText",
 CellID->361149294,ExpressionUUID->"92c5ec59-39c5-4d99-aeaf-18ac9b736e7c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UnitConvert", "[", 
  RowBox[{
   RowBox[{"ThermodynamicData", "[", 
    RowBox[{"\"\<Argon\>\"", ",", "\"\<Density\>\"", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<Pressure\>\"", "\[Rule]", 
        RowBox[{"Quantity", "[", 
         RowBox[{"1", ",", "\"\<Atmospheres\>\""}], "]"}]}], ",", 
       RowBox[{"\"\<Temperature\>\"", "\[Rule]", 
        RowBox[{"Quantity", "[", 
         RowBox[{"293.15", ",", "\"\<Kelvins\>\""}], "]"}]}]}], "}"}]}], 
    "]"}], ",", 
   RowBox[{"\"\<Grams\>\"", "/", 
    SuperscriptBox["\"\<Centimeters\>\"", "3"]}]}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->375583457,ExpressionUUID->"82d4a53f-24a7-4811-8443-734ed08c6b3b"],

Cell[BoxData[
 TemplateBox[{"0.0016618206815859505`", 
   RowBox[{"\"g\"", "\[InvisibleSpace]", "\"/\"", "\[InvisibleSpace]", 
     SuperscriptBox["\"cm\"", "3"]}], "grams per centimeter cubed", 
   FractionBox["\"Grams\"", 
    SuperscriptBox["\"Centimeters\"", "3"]]},
  "Quantity"]], "Output",
 CellLabel->"Out[6]=",
 CellID->45768373,ExpressionUUID->"3131c837-0989-427c-9731-2dd7986863bf"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 NamespaceBox["WolframAlphaQueryResults",
  DynamicModuleBox[{Typeset`q$$ = "density argon", Typeset`opts$$ = {
   AppearanceElements -> {
     "Extrusion", "Warnings", "Assumptions", "Pods", "Unsuccessful"}, 
    Asynchronous -> All, 
    Method -> {
     "ExtrusionChosen" -> {
       "Fast parse", "Fast parse", 1, 0, "Input", 
        "ElementData[\"Argon\", \"Density\"]"}, "ExtrusionOpen" -> True, 
      "Formats" -> {"cell", "minput", "moutput", "msound", "dataformats"}}}, 
   Typeset`elements$$ = {
   "Extrusion", "Warnings", "Assumptions", "Pods", "Unsuccessful"}, 
   Typeset`pod1$$ = XMLElement[
   "pod", {"title" -> "Input interpretation", "scanner" -> "Identity", "id" -> 
     "Input", "position" -> "100", "error" -> "false", "numsubpods" -> "1"}, {
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement["minput", {}, {"ElementData[\"Argon\", \"Density\"]"}], 
       XMLElement["cell", {"compressed" -> False, "string" -> True}, {
         Cell[
          BoxData[
           FormBox[
            TagBox[
             FormBox[
              TagBox[
               GridBox[{{
                  PaneBox[
                   StyleBox[
                    TagBox[
                    GridBox[{{
                    StyleBox[
                    TagBox[
                    TagBox["\"argon\"", 
                    $CellContext`TagBoxWrapper[
                    "Entity" -> {ElementData, "Argon"}]], Identity], {
                    LineIndent -> 0, LineSpacing -> {0.9, 0, 1.5}}], 
                    TagBox["\"density\"", Identity]}}, 
                    GridBoxBackground -> {"Columns" -> {
                    GrayLevel[0.949], None}, "Rows" -> {{None}}}, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    ColumnsEqual -> False, RowsEqual -> False, 
                    GridBoxDividers -> {"Columns" -> {
                    GrayLevel[0.84], 
                    GrayLevel[0.84], 
                    GrayLevel[0.84]}, "Rows" -> {{
                    GrayLevel[0.84]}}, 
                    "RowsIndexed" -> {
                    1 -> GrayLevel[0.84], -1 -> GrayLevel[0.84]}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {1, 1, 1}, "Rows" -> {{0.3}}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Baseline}}}, 
                    AllowScriptLevelChange -> False, BaselinePosition -> 1], 
                    $CellContext`TagBoxWrapper["Separator" -> " | "]], 
                    LineSpacing -> {1, 0, 1.5}, LineIndent -> 0], 
                   BaselinePosition -> Center]}}, 
                GridBoxItemSize -> {
                 "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                ColumnsEqual -> False, RowsEqual -> False, 
                GridBoxSpacings -> {"Columns" -> {{
                    AbsoluteThickness[-1]}}, "Rows" -> {{0}}}, 
                AllowScriptLevelChange -> False], 
               $CellContext`TagBoxWrapper["Separator" -> " | "]], 
              TraditionalForm], 
             PolynomialForm[#, TraditionalOrder -> False]& ], 
            TraditionalForm]], "Output", {}]}], 
       XMLElement[
       "dataformats", {}, {
        "plaintext,minput,computabledata,formatteddata"}]}]}], 
   Typeset`pod2$$ = XMLElement[
   "pod", {"title" -> "Result", "scanner" -> "Data", "id" -> "Result", 
     "position" -> "200", "error" -> "false", "numsubpods" -> "1", "primary" -> 
     "true"}, {
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement["cell", {"compressed" -> False, "string" -> True}, {
         Cell[
          BoxData[
           FormBox[
            StyleBox[
             TagBox[
              GridBox[{{
                 StyleBox[
                  TagBox[
                   RowBox[{
                    TagBox[
                    TagBox[
                    RowBox[{
                    TagBox["0.001784", 
                    $CellContext`TagBoxWrapper["StringBoxes" -> "0.001784"]], 
                    "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    
                    RowBox[{
                    "\"g\"", "\[InvisibleSpace]", "\"/\"", 
                    "\[InvisibleSpace]", 
                    SuperscriptBox["\"cm\"", "3"]}], FontFamily -> 
                    "Helvetica", FontSize -> Smaller]}], Identity], #& , 
                    SyntaxForm -> Dot], "  ", 
                    StyleBox[
                    
                    RowBox[{
                    "\"(\"", "\[NoBreak]", "\"grams per cubic centimeter\"", 
                    "\[NoBreak]", "\")\""}], {
                    FontFamily :> $CellContext`$UnitFontFamily, FontSize -> 
                    Smaller, 
                    GrayLevel[0.6], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0}, StripOnInput -> False]}], "Unit", SyntaxForm -> Dot], 
                  LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                  0, ZeroWidthTimes -> False]}, {
                 StyleBox[
                  
                  RowBox[{
                   "\"(\"", "\[NoBreak]", "\"at 0\[Degree] C\"", "\[NoBreak]",
                     "\")\""}], {FontFamily -> "Verdana", FontSize -> 10, 
                   GrayLevel[0.5], 
                   LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                   0}, StripOnInput -> False]}}, 
               GridBoxAlignment -> {
                "Columns" -> {Left}, "Rows" -> {{Baseline}}}, AutoDelete -> 
               False, GridBoxBackground -> {"Columns" -> {{None}}}, 
               GridBoxFrame -> {"Columns" -> None, "Rows" -> None}, 
               GridBoxItemSize -> {
                "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
               GridBoxSpacings -> {"Columns" -> {{0}}}, FrameStyle -> 
               GrayLevel[0.84], BaselinePosition -> Automatic, 
               AllowScriptLevelChange -> False], "Grid"], 
             LineSpacing -> {0.9, 0, 1.5}, LineIndent -> 0, StripOnInput -> 
             False], TraditionalForm]], "Output", {}]}], 
       XMLElement[
       "dataformats", {}, {
        "plaintext,computabledata,formatteddata,numberdata,quantitydata"}]}]}]\
, Typeset`pod3$$ = XMLElement[
   "pod", {"title" -> "Unit conversions", "scanner" -> "Unit", "id" -> 
     "UnitConversion", "position" -> "300", "error" -> "false", "numsubpods" -> 
     "2"}, {
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement["cell", {"compressed" -> False, "string" -> True}, {
         Cell[
          BoxData[
           FormBox[
            StyleBox[
             TagBox[
              RowBox[{
                TagBox[
                 TagBox[
                  RowBox[{
                    TagBox["1.784", 
                    $CellContext`TagBoxWrapper["StringBoxes" -> "1.784"]], 
                    "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    
                    RowBox[{
                    "\"kg\"", "\[InvisibleSpace]", "\"/\"", 
                    "\[InvisibleSpace]", 
                    SuperscriptBox["\"m\"", "3"]}], FontFamily -> "Helvetica",
                     FontSize -> Smaller]}], Identity], #& , SyntaxForm -> 
                 Dot], "  ", 
                StyleBox[
                 
                 RowBox[{
                  "\"(\"", "\[NoBreak]", "\"kilograms per cubic meter\"", 
                   "\[NoBreak]", "\")\""}], {
                 FontFamily :> $CellContext`$UnitFontFamily, FontSize -> 
                  Smaller, 
                  GrayLevel[0.6], LinebreakAdjustments -> {1, 100, 1, 0, 100},
                   LineIndent -> 0}, StripOnInput -> False]}], "Unit", 
              SyntaxForm -> Dot], LinebreakAdjustments -> {1, 100, 1, 0, 100},
              LineIndent -> 0, ZeroWidthTimes -> False], TraditionalForm]], 
          "Output", {}]}], 
       XMLElement[
       "dataformats", {}, {
        "plaintext,computabledata,formatteddata,numberdata,quantitydata"}]}], 
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement["cell", {"compressed" -> False, "string" -> True}, {
         Cell[
          BoxData[
           FormBox[
            StyleBox[
             TagBox[
              RowBox[{
                TagBox[
                 TagBox[
                  RowBox[{
                    TagBox["1.784", 
                    $CellContext`TagBoxWrapper["StringBoxes" -> "1.784"]], 
                    "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    
                    RowBox[{
                    "\"g\"", "\[InvisibleSpace]", "\"/\"", 
                    "\[InvisibleSpace]", "\"L\""}], FontFamily -> "Helvetica",
                     FontSize -> Smaller]}], Identity], #& , SyntaxForm -> 
                 Dot], "  ", 
                StyleBox[
                 
                 RowBox[{
                  "\"(\"", "\[NoBreak]", "\"grams per liter\"", "\[NoBreak]", 
                   "\")\""}], {
                 FontFamily :> $CellContext`$UnitFontFamily, FontSize -> 
                  Smaller, 
                  GrayLevel[0.6], LinebreakAdjustments -> {1, 100, 1, 0, 100},
                   LineIndent -> 0}, StripOnInput -> False]}], "Unit", 
              SyntaxForm -> Dot], LinebreakAdjustments -> {1, 100, 1, 0, 100},
              LineIndent -> 0, ZeroWidthTimes -> False], TraditionalForm]], 
          "Output", {}]}], 
       XMLElement[
       "dataformats", {}, {
        "plaintext,computabledata,formatteddata,numberdata,quantitydata"}]}]}]\
, Typeset`pod4$$ = XMLElement[
   "pod", {"title" -> "Comparisons as mass density", "scanner" -> "Unit", 
     "id" -> "ComparisonAsMassDensity", "position" -> "400", "error" -> 
     "false", "numsubpods" -> "3"}, {
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement["cell", {"compressed" -> False, "string" -> True}, {
         Cell[
          BoxData[
           FormBox[
            FormBox[
             TemplateBox[{"\" \[TildeTilde] \"", 
               StyleBox[
               "\"( \"", LinebreakAdjustments -> {1, 100, 1, 0, 100}, 
                LineIndent -> 0, 
                GrayLevel[0.6], StripOnInput -> False], 
               TemplateBox[{"\"\"", "0", "\".\"", "0", "9"}, "RowDefault"], 
               StyleBox[
                
                TemplateBox[{
                 "\" \[TildeTilde] \"", "\"1\"", "\"/\"", "11", "\" ) \""}, 
                 "RowDefault"], LinebreakAdjustments -> {1, 100, 1, 0, 100}, 
                LineIndent -> 0, 
                GrayLevel[0.6], StripOnInput -> False], 
               StyleBox["\"\[Times]\"", 
                GrayLevel[0.3], FontSize -> 10.219999999999999`, StripOnInput -> 
                False], "\"\[MediumSpace]\"", 
               StyleBox[
               "\"mean density inside the Schwarzschild radius of a \
supermassive black hole\"", FontFamily -> "Helvetica", FontSize -> Smaller, 
                StripOnInput -> False], "\" \"", 
               StyleBox[
                RowBox[{"\"(\"", "\[NoBreak]", 
                  TemplateBox[{"\"\[TildeTilde]\[ThinSpace]\"", 
                    StyleBox[
                    TagBox[
                    TagBox[
                    TagBox[
                    RowBox[{
                    TagBox["20", 
                    $CellContext`TagBoxWrapper["StringBoxes" -> "20"]], 
                    "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    
                    RowBox[{
                    "\"kg\"", "\[InvisibleSpace]", "\"/\"", 
                    "\[InvisibleSpace]", 
                    SuperscriptBox["\"m\"", "3"]}], FontFamily -> "Helvetica",
                     FontSize -> Smaller]}], Identity], #& , SyntaxForm -> 
                    Dot], "Unit", SyntaxForm -> Dot], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, ZeroWidthTimes -> False], "\"\[MediumSpace]\""}, 
                   "RowDefault"], "\[NoBreak]", "\")\""}], {
                FontFamily -> "Verdana", FontSize -> 10, 
                 GrayLevel[0.5], LinebreakAdjustments -> {1, 100, 1, 0, 100}, 
                 LineIndent -> 0}, StripOnInput -> False]}, "RowDefault"], 
             TraditionalForm], TraditionalForm]], "Output", {}]}], 
       XMLElement["dataformats", {}, {"plaintext"}]}], 
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement["cell", {"compressed" -> False, "string" -> True}, {
         Cell[
          BoxData[
           FormBox[
            FormBox[
             TemplateBox[{"\" \[TildeTilde] \"", 
               TemplateBox[{"\"\"", "0", "\".\"", "6"}, "RowDefault"], 
               "\" \"", 
               StyleBox["\"\[Times]\"", 
                GrayLevel[0.3], FontSize -> 10.219999999999999`, StripOnInput -> 
                False], "\"\[MediumSpace]\"", 
               StyleBox[
               "\"typical aerogel density\"", FontFamily -> "Helvetica", 
                FontSize -> Smaller, StripOnInput -> False], "\" \"", 
               StyleBox[
                RowBox[{"\"(\"", "\[NoBreak]", 
                  TemplateBox[{"\"\[TildeTilde]\[ThinSpace]\"", 
                    StyleBox[
                    TagBox[
                    TagBox[
                    TagBox[
                    RowBox[{
                    TagBox["3", 
                    $CellContext`TagBoxWrapper["StringBoxes" -> "3"]], 
                    "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    
                    RowBox[{
                    "\"kg\"", "\[InvisibleSpace]", "\"/\"", 
                    "\[InvisibleSpace]", 
                    SuperscriptBox["\"m\"", "3"]}], FontFamily -> "Helvetica",
                     FontSize -> Smaller]}], Identity], #& , SyntaxForm -> 
                    Dot], "Unit", SyntaxForm -> Dot], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, ZeroWidthTimes -> False], "\"\[MediumSpace]\""}, 
                   "RowDefault"], "\[NoBreak]", "\")\""}], {
                FontFamily -> "Verdana", FontSize -> 10, 
                 GrayLevel[0.5], LinebreakAdjustments -> {1, 100, 1, 0, 100}, 
                 LineIndent -> 0}, StripOnInput -> False]}, "RowDefault"], 
             TraditionalForm], TraditionalForm]], "Output", {}]}], 
       XMLElement["dataformats", {}, {"plaintext"}]}], 
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement["cell", {"compressed" -> False, "string" -> True}, {
         Cell[
          BoxData[
           FormBox[
            FormBox[
             TemplateBox[{"\" \[TildeTilde] \"", 
               TemplateBox[{"\"\"", "1", "\".\"", "5"}, "RowDefault"], 
               "\" \"", 
               StyleBox["\"\[Times]\"", 
                GrayLevel[0.3], FontSize -> 10.219999999999999`, StripOnInput -> 
                False], "\"\[MediumSpace]\"", 
               StyleBox[
               "\"air density at 25 \[Degree]C\"", FontFamily -> "Helvetica", 
                FontSize -> Smaller, StripOnInput -> False], "\" \"", 
               StyleBox[
                RowBox[{"\"(\"", "\[NoBreak]", 
                  TemplateBox[{"\"\[TildeTilde]\[ThinSpace]\"", 
                    StyleBox[
                    TagBox[
                    TagBox[
                    TagBox[
                    RowBox[{
                    TagBox["1.2", 
                    $CellContext`TagBoxWrapper["StringBoxes" -> "1.2"]], 
                    "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    
                    RowBox[{
                    "\"kg\"", "\[InvisibleSpace]", "\"/\"", 
                    "\[InvisibleSpace]", 
                    SuperscriptBox["\"m\"", "3"]}], FontFamily -> "Helvetica",
                     FontSize -> Smaller]}], Identity], #& , SyntaxForm -> 
                    Dot], "Unit", SyntaxForm -> Dot], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, ZeroWidthTimes -> False], "\"\[MediumSpace]\""}, 
                   "RowDefault"], "\[NoBreak]", "\")\""}], {
                FontFamily -> "Verdana", FontSize -> 10, 
                 GrayLevel[0.5], LinebreakAdjustments -> {1, 100, 1, 0, 100}, 
                 LineIndent -> 0}, StripOnInput -> False]}, "RowDefault"], 
             TraditionalForm], TraditionalForm]], "Output", {}]}], 
       XMLElement["dataformats", {}, {"plaintext"}]}]}], Typeset`aux1$$ = {
   True, False, {False}, True}, Typeset`aux2$$ = {True, False, {False}, True},
    Typeset`aux3$$ = {True, False, {False, False}, True}, Typeset`aux4$$ = {
   True, False, {False, False, False}, True}, Typeset`asyncpods$$ = {}, 
   Typeset`nonpods$$ = {
    XMLElement["sources", {"count" -> "1"}, {
      XMLElement[
      "source", {
       "url" -> 
        "http://www.wolframalpha.com/sources/\
ElementDataSourceInformationNotes.html", "text" -> "Element data"}, {}]}]}, 
   Typeset`initdone$$ = True, Typeset`queryinfo$$ = {
   "success" -> "true", "error" -> "false", "numpods" -> "4", "datatypes" -> 
    "Element", "timedout" -> "", "timedoutpods" -> "", "timing" -> "1.105", 
    "parsetiming" -> "0.308", "parsetimedout" -> "false", "recalculate" -> "",
     "id" -> "MSPa4821bf1g5c36144111h000046ebeaf412a00844", "host" -> 
    "http://www5a.wolframalpha.com", "server" -> "58", "related" -> 
    "http://www5a.wolframalpha.com/api/v2/relatedQueries.jsp?id=\
MSPa4831bf1g5c36144111h00004d18d6ie2936283g&s=58", "version" -> "2.6"}, 
   Typeset`sessioninfo$$ = {
   "TimeZone" -> 2., 
    "Date" -> {2014, 7, 7, 9, 30, 42.3442232`9.379369044796087}, "Line" -> 23,
     "SessionID" -> 23682826443479612399}, Typeset`showpods$$ = {1, 2, 3, 4}, 
   Typeset`failedpods$$ = {}, Typeset`chosen$$ = {
   "Fast parse", "Fast parse", 1, 0, "Input", 
    "ElementData[\"Argon\", \"Density\"]"}, Typeset`open$$ = True, 
   Typeset`newq$$ = "density argon"}, 
   DynamicBox[ToBoxes[
     AlphaIntegration`FormatAlphaResults[
      Dynamic[{
       1, {Typeset`pod1$$, Typeset`pod2$$, Typeset`pod3$$, Typeset`pod4$$}, {
        Typeset`aux1$$, Typeset`aux2$$, Typeset`aux3$$, Typeset`aux4$$}, 
        Typeset`chosen$$, Typeset`open$$, Typeset`elements$$, Typeset`q$$, 
        Typeset`opts$$, Typeset`nonpods$$, Typeset`queryinfo$$, 
        Typeset`sessioninfo$$, Typeset`showpods$$, Typeset`failedpods$$, 
        Typeset`newq$$}]], StandardForm],
    ImageSizeCache->{560., {493., 19.}},
    TrackedSymbols:>{Typeset`showpods$$, Typeset`failedpods$$}],
   DynamicModuleValues:>{},
   Initialization:>If[
     Not[Typeset`initdone$$], Null; WolframAlphaClient`Private`doAsyncUpdates[
       Hold[{Typeset`pod1$$, Typeset`pod2$$, Typeset`pod3$$, Typeset`pod4$$}],
        Typeset`asyncpods$$, 
       Dynamic[Typeset`failedpods$$]]; Typeset`asyncpods$$ = {}; 
     Typeset`initdone$$ = True],
   SynchronousInitialization->False],
  BaseStyle->{Deployed -> True},
  DeleteWithContents->True,
  Editable->False,
  SelectWithContents->True]], "WolframAlphaShortInput",
 CellLabel->"In[63]:=",
 CellID->381522003,ExpressionUUID->"80909ca7-243e-4bc4-80fd-4596fabf9cae"],

Cell[BoxData[
 TemplateBox[{"0.001784`4.", 
   RowBox[{"\"g\"", "\[InvisibleSpace]", "\"/\"", "\[InvisibleSpace]", 
     SuperscriptBox["\"cm\"", "3"]}], "grams per centimeter cubed", 
   FractionBox["\"Grams\"", 
    SuperscriptBox["\"Centimeters\"", "3"]]},
  "Quantity"]], "Output",
 CellLabel->"Out[63]=",
 CellID->11754751,ExpressionUUID->"e715b8af-7c35-4348-8cc3-01a43be1897c"]
}, Open  ]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"}, 
  Closed]]]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "2"},
        Closed], 
      Alternatives[Open, True]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{
    13.600000000000001`, {0.5800000000000001, 13.020000000000001`}}]],
  ExpressionUUID->"f2eee67d-ece0-4d55-9cfb-44c6390ec9cb"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"a0a712c9-3395-4cd4-b8f7-3395c55a5906"],
 "Applications",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "1bc23d53-5405-4976-90da-04dbf700416c"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellID->258228157,ExpressionUUID->"cf2e91a7-6831-4633-b7a7-077aab17efee"],

Cell[BoxData[{
 RowBox[{"Needs", "[", "\"\<NewEoSArgon`\>\"", "]"}], "\[IndentingNewLine]", 
 RowBox[{"Off", "[", 
  RowBox[{"General", "::", "munfl"}], "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->111338890,ExpressionUUID->"c47e8127-1461-48a3-be21-5715bc3369a8"],

Cell[TextData[{
 "Comparison with ",
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["NIST data"]], "http://webbook.nist.gov/chemistry/fluid/"},
   "WebLink",
   BaseStyle->{"ExampleText"}]],ExpressionUUID->
  "c34c3dd8-8737-45e5-a0b9-a4d61af7f00a"],
 " on an isotherm close to the critical isotherm"
}], "ExampleText",
 CellID->227520913,ExpressionUUID->"8ff783c0-a462-43a9-a2f6-1a0854092c30"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"datafile", "=", 
   RowBox[{"FileNameJoin", "[", 
    RowBox[{"{", 
     RowBox[{
     "\"\<NewEoSArgon\>\"", ",", "\"\<DataFiles\>\"", ",", 
      "\"\<DataCritNIST.dat\>\""}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dataNIST", "=", 
   RowBox[{"Import", "[", "datafile", "]"}]}], ";"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->531122037,ExpressionUUID->"d8de21a9-18a2-47f9-9057-5baf66bbd871"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ArT150p7Rho", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"dataNIST", "[", 
        RowBox[{"[", 
         RowBox[{"i", ",", "2"}], "]"}], "]"}], ",", 
       RowBox[{"dataNIST", "[", 
        RowBox[{"[", 
         RowBox[{"i", ",", "3"}], "]"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "2", ",", "51"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Fig150G", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"RhoArgonNv", "[", 
       RowBox[{"150.7", ",", "x", ",", "\"\<G\>\""}], "]"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0.01`", ",", "40.`"}], "}"}], ",", 
     RowBox[{"AxesOrigin", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"0", ",", "\[Rho]c"}], "}"}]}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
     RowBox[{"Frame", "\[Rule]", "True"}], ",", 
     RowBox[{"FrameLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
       "\"\<\!\(\*StyleBox[\"P\",FontSlant->\"Italic\"]\) (bar)\>\"", ",", 
        "\"\<\[Rho] (g/\!\(\*SuperscriptBox[\(cm\), \(3\)]\))\>\"", ",", 
        "\"\<ISOTHERM 150.7 K\>\""}], "}"}]}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", "Red", "}"}]}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Fig150L", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"RhoArgonNv", "[", 
       RowBox[{"150.7", ",", "x"}], "]"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "50", ",", "3000"}], "}"}], ",", 
     RowBox[{"AxesOrigin", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"0", ",", "\[Rho]c"}], "}"}]}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
     RowBox[{"Frame", "\[Rule]", "True"}], ",", 
     RowBox[{"FrameLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
       "\"\<\!\(\*StyleBox[\"P\",FontSlant->\"Italic\"]\) (bar)\>\"", ",", 
        "\"\<\[Rho] (g/\!\(\*SuperscriptBox[\(cm\), \(3\)]\))\>\"", ",", 
        "\"\<ISOTHERM 150.7 K\>\""}], "}"}]}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", "Red", "}"}]}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Legended", "[", 
  RowBox[{
   RowBox[{"Show", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"Fig150G", ",", "Fig150L"}], "}"}], ",", 
     RowBox[{"Epilog", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"PointSize", "\[Rule]", "Medium"}], ",", 
        RowBox[{"Map", "[", 
         RowBox[{"Point", ",", "ArT150p7Rho"}], "]"}]}], "}"}]}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "450"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Placed", "[", 
      RowBox[{
       RowBox[{"PointLegend", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"Directive", "[", 
           RowBox[{"Black", ",", 
            RowBox[{"AbsolutePointSize", "[", "6", "]"}]}], "]"}], "}"}], ",", 
         RowBox[{"{", "\"\<NIST database\>\"", "}"}]}], "]"}], ",", "Below"}],
       "]"}], ",", 
     RowBox[{"Placed", "[", 
      RowBox[{
       RowBox[{"LineLegend", "[", 
        RowBox[{
         RowBox[{"{", "Red", "}"}], ",", 
         RowBox[{
         "{", "\"\<RhoArgonNv[\!\(\*StyleBox[\"T\",FontSlant->\"Italic\"]\),\!\
\(\*StyleBox[\"P\",FontSlant->\"Italic\"]\)]\>\"", "}"}]}], "]"}], ",", 
       "Below"}], "]"}]}], "}"}]}], "]"}]}], "Input",
 CellLabel->"In[3]:=",
 CellID->136921489,ExpressionUUID->"1af075ca-ed92-4fc9-9c1f-12995a4086ac"],

Cell[BoxData[
 GraphicsBox[
  TagBox[RasterBox[CompressedData["
1:eJzt3U9sJNdiH2peZW48dubm9g3kYBCP4rEtXCiODAs3nRvBGDt89iDWA4Rk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    "], {{0, 335.}, {450., 0}}, {0, 255},
    ColorFunction->RGBColor,
    ImageResolution->{144., 144.},
    SmoothingQuality->"High"],
   BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
   Selectable->False],
  DefaultBaseStyle->"ImageGraphics",
  ImageSize->Automatic,
  ImageSizeRaw->{450., 335.},
  PlotRange->{{0, 450.}, {0, 335.}}]], "Output",
 CellTags->"RasterizedOutput",
 CellLabel->"Out[3]=",
 CellID->473679299,ExpressionUUID->"26c32dfc-5e02-4243-a3e7-6486481f1e5f"]
}, Open  ]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "2"}, 
  Closed]]]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "PrimaryExamplesSection"}, 
  Closed]]]],

Cell[BoxData[GridBox[{
   {
    DynamicBox[FEPrivate`ImportImage[
      FrontEnd`FileName[{"Documentation", "FooterIcons"}, 
       "RelatedFunction.png"]],
     ImageSizeCache->{50., {27., 33.}}], GridBox[{
      {
       StyleBox[
        RowBox[{"See", " ", "Also"}], "SeeAlsoSection"]},
      {Cell[TextData[{
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["PArgonNv"]], "paclet:NewEoSArgon/ref/PArgonNv", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "bad3f67a-c0ed-460a-8b85-543086c3070b"],
        "\[NonBreakingSpace]",
        StyleBox[
        "\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
         "InlineSeparator"],
        " ",
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["RhoSatLiqFromT"]], 
           "paclet:NewEoSArgon/ref/RhoSatLiqFromT", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "7e6a5a20-4116-420a-9cf9-9ac538007cc9"],
        "\[NonBreakingSpace]",
        StyleBox[
        "\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
         "InlineSeparator"],
        " ",
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["RhoSatVapFromT"]], 
           "paclet:NewEoSArgon/ref/RhoSatVapFromT", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "9a4de6f8-6d2d-475d-9805-ac1fd341ab7a"]
       }], "SeeAlso",ExpressionUUID->"43b7f504-ddd7-4fde-a57e-a0a435261995"]}
     }]}
  }]], "SeeAlsoSection",ExpressionUUID->"f799b425-ba89-49a1-87b9-\
0c50945b1394"],

Cell[BoxData[GridBox[{
   {
    DynamicBox[FEPrivate`ImportImage[
      FrontEnd`FileName[{"Documentation", "FooterIcons"}, "RelatedGuide.png"]],
     ImageSizeCache->{50., {27., 33.}}], GridBox[{
      {
       StyleBox[
        RowBox[{"Related", " ", "Guides"}], "MoreAboutSection"]},
      {
       RowBox[{"\[FilledVerySmallSquare]", Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["NewEoSArgon Package"]], 
           "paclet:NewEoSArgon/guide/NewEoSArgon"},
          "RefLinkPlain",
          BaseStyle->{"MoreAbout"}]], "MoreAbout",ExpressionUUID->
         "7dc10a03-5f08-41ee-befb-7c6f085b8e7b"]}]}
     }]}
  }]], "MoreAboutSection",ExpressionUUID->"732903b2-7ad2-43e3-93c9-\
4853ec220485"],

Cell[BoxData[GridBox[{
   {
    TemplateBox[{29},
     "Spacer1"], GridBox[{
      {
       RowBox[{
        TemplateBox[{17},
         "Spacer1"], 
        StyleBox[
         RowBox[{"Related", " ", "Links"}], "RelatedLinksSection"]}]},
      {Cell[BoxData[Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData[
             RowBox[{
               RowBox[{"Units", " ", "&"}], " ", "Quantities"}]]], 
           "paclet:guide/Units"},
          "RefLinkPlain",
          BaseStyle->{"RelatedLinks"}]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "6c605544-abb4-4bb1-ad7b-1175b6e683f5"]], "RelatedLinks",
        ExpressionUUID->"f5ebfce1-a298-473b-84b1-687069289379"]},
      {Cell[BoxData[Cell[BoxData[Cell[BoxData[
          RowBox[{
           TemplateBox[{16},
            "Spacer1"], "\[FilledVerySmallSquare]", 
           TemplateBox[{
             Cell[
              TextData[
               Cell[
                TextData[{
                  Cell[
                   BoxData[
                    TemplateBox[{2}, "Spacer1"]]], "ThermodynamicData"}]]]], 
             "paclet:ref/ThermodynamicData"},
            "RefLink",
            BaseStyle->{"RelatedLinks"}]}]],ExpressionUUID->
          "d94a80e1-c924-4591-8379-59a30d84c4ea"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "1964d453-46f2-4e7c-8b19-d1d6f5e11ff6"]], "RelatedLinks",
        ExpressionUUID->"fac05a0a-5324-4f86-bfc2-f491aac8cede"]}
     }]}
  }]], "RelatedLinksSection",ExpressionUUID->"159ff006-b02d-40c7-b617-\
b73aa52051ee"],

Cell[" ", "FooterCell",ExpressionUUID->"37659301-cba1-4b27-9d3e-aea4f546c664"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{900, 835.8},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"RhoArgonNv",
TaggingRules->{
 "ModificationHighlight" -> False, "ColorType" -> "", "LinkTrails" -> "", 
  "HasOptions" -> True, "ExampleCounter" -> 1, 
  "Openers" -> {
   "PrimaryExamplesSection" -> Open, 
    "ExampleSection" -> {"0" -> Open, "2" -> Closed}, "NotesSection" -> 
    Closed}, "NewStyles" -> True, "CitationPopupData" -> $Failed, 
  "ShowCitation" -> False, "RootCaptions" -> "", 
  "Metadata" -> {
   "built" -> "{2023, 11, 30, 13, 55, 54.9472087}", 
    "history" -> {"XX", "", "", ""}, "context" -> "NewEoSArgon`", 
    "keywords" -> {}, "specialkeywords" -> {}, 
    "tutorialcollectionlinks" -> {}, "index" -> True, "label" -> 
    "New Eo S Argon Package Symbol", "language" -> "en", "paclet" -> 
    "NewEoSArgon Package", "status" -> "None", "summary" -> 
    "RhoArgonNv[T, P, Phase] \\[Congruent] \\[Rho] (g/cm^3) Densit\[EAcute] \
de l'argon en fonction de T (Kelvin) et de P (bar) [Argon density as a \
function of T (Kelvin) and P (bar)]", "synonyms" -> {}, "tabletags" -> {}, 
    "title" -> "RhoArgonNv", "titlemodifier" -> "", "metadescription" -> "", 
    "windowtitle" -> "RhoArgonNv", "type" -> "Symbol", "uri" -> 
    "NewEoSArgon/ref/RhoArgonNv"}},
CellContext->"Global`",
FrontEndVersion->"13.3 pour Microsoft Windows (64-bit) (July 24, 2023)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "13.3 pour Microsoft Windows (64-bit) (July 24, 2023)", 
  StyleDefinitions -> "Default.nb"],
ExpressionUUID->"d24a40bc-0e82-4864-8b5e-b5a527e575be"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[15536, 411, 1420, 37, 35, "PrimaryExamplesSection",ExpressionUUID->"fe434113-5c76-4556-8c41-6a64cdbf1502",
   CellTags->"PrimaryExamplesSection",
   CellID->252868828]},
 "RasterizedOutput"->{
  Cell[82004, 1915, 27968, 465, 356, "Output",ExpressionUUID->"26c32dfc-5e02-4243-a3e7-6486481f1e5f",
   CellTags->"RasterizedOutput",
   CellID->473679299]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 116563, 2556},
 {"RasterizedOutput", 116763, 2560}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[582, 21, 5435, 132, 56, "AnchorBarGrid",ExpressionUUID->"3897dd34-9d64-400b-bc35-1f0a79021263",
 CellID->1],
Cell[6020, 155, 94, 0, 23, "ContextNameCell",ExpressionUUID->"179d8617-0cd7-4932-9d71-0d2e9bdc2b80"],
Cell[CellGroupData[{
Cell[6139, 159, 553, 14, 56, "ObjectNameGrid",ExpressionUUID->"f5d915cd-b001-42b9-be0e-aee9243a02ba"],
Cell[6695, 175, 1073, 30, 146, "Usage",ExpressionUUID->"067fca2a-4df2-4348-bc58-72448b8dce73"]
}, Open  ]],
Cell[CellGroupData[{
Cell[7805, 210, 1918, 48, 37, "NotesSection",ExpressionUUID->"0147dae7-84e6-42a4-96ec-7c8c5b6fa820",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->35117658],
Cell[9726, 260, 553, 19, 38, "Notes",ExpressionUUID->"70ccb58d-2362-4ff0-8506-6e1b04cb9775",
 CellID->1067943069],
Cell[10282, 281, 719, 18, 59, "Notes",ExpressionUUID->"c3c2d82a-f3c9-44f9-a074-a347b78da439",
 CellID->7319701],
Cell[11004, 301, 1380, 25, 107, "Notes",ExpressionUUID->"ea93b35e-884b-4111-8c71-f5bfd4768d2c",
 CellID->482355032],
Cell[12387, 328, 186, 2, 36, "Notes",ExpressionUUID->"27e8dd2b-6164-404c-9a74-d934f8bb795c",
 CellID->46430647],
Cell[12576, 332, 185, 4, 36, "Notes",ExpressionUUID->"1a1ec76c-d00a-4350-8704-3df6d622026c",
 CellID->185021568],
Cell[12764, 338, 543, 19, 38, "Notes",ExpressionUUID->"becca9c9-3c07-4baf-ab30-3632d01b2645",
 CellID->19381920],
Cell[13310, 359, 658, 17, 59, "Notes",ExpressionUUID->"a8eb8cc7-cd35-4ca5-8da4-9f113e240e53",
 CellID->240432791],
Cell[13971, 378, 1292, 24, 107, "Notes",ExpressionUUID->"b98327b4-bc21-4d8f-817e-248aec036972",
 CellID->363814092],
Cell[15266, 404, 143, 1, 36, "Notes",ExpressionUUID->"39831638-1996-4655-b709-20f4be3ef205",
 CellID->67088494]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "NotesSection"}, Closed]]]],
Cell[CellGroupData[{
Cell[15536, 411, 1420, 37, 35, "PrimaryExamplesSection",ExpressionUUID->"fe434113-5c76-4556-8c41-6a64cdbf1502",
 CellTags->"PrimaryExamplesSection",
 CellID->252868828],
Cell[CellGroupData[{
Cell[16981, 452, 1398, 36, 30, "ExampleSection",ExpressionUUID->"2035950b-8053-4196-a8cb-2b4793f47033",
 CellID->528986751],
Cell[18382, 490, 267, 5, 42, "Input",ExpressionUUID->"d5b0535c-30e7-44f9-8450-a9ffdae6757c",
 CellID->87419684],
Cell[18652, 497, 130, 1, 38, "ExampleText",ExpressionUUID->"1271a8fd-c674-4836-9b12-b3586de33529",
 CellID->32289193],
Cell[CellGroupData[{
Cell[18807, 502, 1264, 37, 102, "Input",ExpressionUUID->"bd9ab31c-a710-4dcd-9e79-0ac5503ea32b",
 CellID->86367826],
Cell[20074, 541, 202, 2, 22, "Print",ExpressionUUID->"ef8cd3d2-7028-4ae3-baaf-2586f0acb914",
 CellID->146229627],
Cell[20279, 545, 244, 6, 43, "Output",ExpressionUUID->"a45e2480-aa74-4045-a9b4-b66d37f616ee",
 CellID->755494874],
Cell[20526, 553, 245, 6, 40, "Output",ExpressionUUID->"1d10de82-099e-4ad7-a946-80e333be7429",
 CellID->217294124],
Cell[20774, 561, 203, 2, 22, "Print",ExpressionUUID->"b1f832c8-0d59-4200-a663-ec0cfd259aed",
 CellID->30343616],
Cell[20980, 565, 218, 4, 40, "Output",ExpressionUUID->"5f5bd847-3424-4eca-b716-7a64039b8fe1",
 CellID->14652057]
}, Open  ]],
Cell[21213, 572, 243, 6, 38, "ExampleText",ExpressionUUID->"cc853832-73e5-4d05-99bc-45462164a9c2",
 CellID->886239600],
Cell[CellGroupData[{
Cell[21481, 582, 1208, 32, 57, "Input",ExpressionUUID->"6bb1b7fe-3b95-44c2-9016-0bc1edbba6b8",
 CellID->21488140],
Cell[22692, 616, 28032, 562, 332, "Output",ExpressionUUID->"21f3a094-69c4-460b-8e4f-798863670655",
 CellID->391752160]
}, Open  ]],
Cell[50739, 1181, 129, 1, 70, "ExampleText",ExpressionUUID->"c8a31417-d952-440e-b648-4a08e581e771",
 CellID->164375273],
Cell[CellGroupData[{
Cell[50893, 1186, 934, 25, 70, "Input",ExpressionUUID->"b84e5cfe-6c05-475d-8b42-a6620fb40973",
 CellID->127806170],
Cell[51830, 1213, 394, 8, 45, "Output",ExpressionUUID->"59f250b3-fa29-4ad2-95b5-28f4dfa40a20",
 CellID->115804259]
}, Open  ]],
Cell[CellGroupData[{
Cell[52261, 1226, 875, 23, 70, "Input",ExpressionUUID->"c33cab73-a2c8-4e1e-b41c-78b939f89d69",
 CellID->82940876],
Cell[53139, 1251, 387, 8, 45, "Output",ExpressionUUID->"c9cb9566-0d82-4add-81c3-2f20ea90f3c9",
 CellID->5008835]
}, Open  ]],
Cell[53541, 1262, 154, 1, 70, "ExampleText",ExpressionUUID->"92c5ec59-39c5-4d99-aeaf-18ac9b736e7c",
 CellID->361149294],
Cell[CellGroupData[{
Cell[53720, 1267, 709, 17, 70, "Input",ExpressionUUID->"82d4a53f-24a7-4811-8443-734ed08c6b3b",
 CellID->375583457],
Cell[54432, 1286, 393, 8, 45, "Output",ExpressionUUID->"3131c837-0989-427c-9731-2dd7986863bf",
 CellID->45768373]
}, Open  ]],
Cell[CellGroupData[{
Cell[54862, 1299, 20492, 425, 70, "WolframAlphaShortInput",ExpressionUUID->"80909ca7-243e-4bc4-80fd-4596fabf9cae",
 CellID->381522003],
Cell[75357, 1726, 383, 8, 45, "Output",ExpressionUUID->"e715b8af-7c35-4348-8cc3-01a43be1897c",
 CellID->11754751]
}, Open  ]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"}, Closed]]]],
Cell[CellGroupData[{
Cell[75889, 1742, 1419, 37, 70, "ExampleSection",ExpressionUUID->"cf2e91a7-6831-4633-b7a7-077aab17efee",
 CellID->258228157],
Cell[77311, 1781, 268, 5, 70, "Input",ExpressionUUID->"c47e8127-1461-48a3-be21-5715bc3369a8",
 CellID->111338890],
Cell[77582, 1788, 401, 11, 70, "ExampleText",ExpressionUUID->"8ff783c0-a462-43a9-a2f6-1a0854092c30",
 CellID->227520913],
Cell[77986, 1801, 464, 13, 70, "Input",ExpressionUUID->"d8de21a9-18a2-47f9-9057-5baf66bbd871",
 CellID->531122037],
Cell[CellGroupData[{
Cell[78475, 1818, 3526, 95, 70, "Input",ExpressionUUID->"1af075ca-ed92-4fc9-9c1f-12995a4086ac",
 CellID->136921489],
Cell[82004, 1915, 27968, 465, 356, "Output",ExpressionUUID->"26c32dfc-5e02-4243-a3e7-6486481f1e5f",
 CellTags->"RasterizedOutput",
 CellID->473679299]
}, Open  ]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "2"}, Closed]]]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "PrimaryExamplesSection"}, Closed]]]],
Cell[110214, 2389, 1930, 52, 70, "SeeAlsoSection",ExpressionUUID->"f799b425-ba89-49a1-87b9-0c50945b1394"],
Cell[112147, 2443, 729, 19, 70, "MoreAboutSection",ExpressionUUID->"732903b2-7ad2-43e3-93c9-4853ec220485"],
Cell[112879, 2464, 1607, 43, 70, "RelatedLinksSection",ExpressionUUID->"159ff006-b02d-40c7-b617-b73aa52051ee"],
Cell[114489, 2509, 78, 0, 70, "FooterCell",ExpressionUUID->"37659301-cba1-4b27-9d3e-aea4f546c664"]
}
]
*)

(* End of internal cache information *)

