(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 13.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     56472,       1254]
NotebookOptionsPosition[     50856,       1139]
NotebookOutlinePosition[     53381,       1201]
CellTagsIndexPosition[     53259,       1195]
WindowTitle->RhoSatLiqFromT
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[GridBox[{
   {GridBox[{
      {
       ItemBox[Cell[BoxData[
         RowBox[{
          TemplateBox[{12},
           "Spacer1"], Cell["NEW EO S ARGON PACKAGE SYMBOL", "PacletNameCell",
           TextAlignment->Center,ExpressionUUID->
           "1685c8a3-1379-4608-bff1-78e98cefce0a"], 
          TemplateBox[{8},
           "Spacer1"]}]],
         TextAlignment->Center,ExpressionUUID->
         "ffe96eac-024f-414b-ac2e-adaf4eafd803"],
        Background->RGBColor[0.490196, 0.576471, 0.690196],
        ItemSize->Full], ""}
     },
     GridBoxAlignment->{"Rows" -> {{Center}}},
     GridBoxItemSize->{"Columns" -> {Full, 
         Scaled[0.02]}, "Rows" -> {{2.5}}}], Cell[TextData[{
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "See Also",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "700f4aa8-7472-4c10-8b9c-b3c8d500d548"]
         }],ExpressionUUID->"ae0a9bee-7044-4683-b505-af7a122f83d4"],
         StripOnInput->False],{
        "\"rhotrliqNv\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/rhotrliqNv"], 
         "\"rhocNv\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/rhocNv"], 
         "\"RhoSatLiqNISTFromT\"" :> 
         Documentation`HelpLookup[
          "paclet:NewEoSArgon/ref/RhoSatLiqNISTFromT"], "\"ttr\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/ttr"], "\"tcNv\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/tcNv"]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"SeeAlso"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "ec455f47-a5d0-4d65-9c30-605cc95a2b4c"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "Related Guides",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "9bb159fc-d817-4679-aab5-cd8206998610"]
         }],ExpressionUUID->"b3c07442-d87d-4832-992c-e68ef485d303"],
         StripOnInput->False],{
        "\"NewEoSArgon Package\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/guide/NewEoSArgon"]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"MoreAbout"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "a07d6415-d931-428c-a6b6-ff19ef7e174a"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "URL",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "a26ac7a4-2dae-45da-a46d-70770700b8e5"]
         }],ExpressionUUID->"9d070a52-2915-45b0-897a-a5da1e34654b"],
         StripOnInput->False],{
        "\"NewEoSArgon/ref/RhoSatLiqFromT\"" :> None, 
         "\"Copy Wolfram Documentation Center URL\"" :> 
         Module[{DocumentationSearch`Private`nb$}, 
           DocumentationSearch`Private`nb$ = 
            NotebookPut[
             Notebook[{Cell["NewEoSArgon/ref/RhoSatLiqFromT"]}, Visible -> 
               False]]; 
           SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
           FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
           NotebookClose[DocumentationSearch`Private`nb$]; Null], Delimiter, 
         "\"Copy web URL\"" :> 
         Module[{DocumentationSearch`Private`nb$}, 
           DocumentationSearch`Private`nb$ = 
            NotebookPut[
             Notebook[{
               Cell[BoxData[
                 MakeBoxes[
                  Hyperlink[
                   "http://reference.wolfram.com/language/NewEoSArgon/ref/\
RhoSatLiqFromT.html"], StandardForm]], "Input", TextClipboardType -> 
                 "PlainText"]}, Visible -> False]]; 
           SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
           FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
           NotebookClose[DocumentationSearch`Private`nb$]; Null], 
         "\"Go to web URL\"" :> 
         FrontEndExecute[{
           NotebookLocate[{
             URL[If[TrueQ[DocumentationBuild`Make`Private`wsmlinkQ$24791], 
                 "http://reference.wolfram.com/system-modeler/", 
                 "http://reference.wolfram.com/language/"] <> 
               "NewEoSArgon/ref/RhoSatLiqFromT" <> ".html"], None}]}]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"URLMenu"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "17cc72b3-9873-4938-b4c5-81ef1f4b6a62"]
    }], "AnchorBar",
     CacheGraphics->False,ExpressionUUID->
     "2e1b729f-5c89-4e85-b7dd-8e759fce3c0c"]}
  }]], "AnchorBarGrid",
 CellID->1,ExpressionUUID->"f372a188-f246-4d2f-ab83-542ba30ea8fb"],

Cell["NewEoSArgon`", "ContextNameCell",ExpressionUUID->"c2d5afbb-1488-46f6-9689-7495f7fe96d9"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     Cell[
     "RhoSatLiqFromT", "ObjectName",ExpressionUUID->
      "0419ffc8-7c10-43d0-8d2a-2de6cf79ca5e"],
     Cell[BoxData[
      TemplateBox[{8},
       "Spacer1"]],ExpressionUUID->"9edf65c7-48b3-44f2-9982-8fc9d79e859e"],
     Cell[BoxData[
     ""], "ObjectNameTranslation",ExpressionUUID->
      "655b16a9-e3e0-44f4-be5c-21eac08017fc"]
    }],ExpressionUUID->"376caa2e-35e7-49a7-bdf7-e7c734d49544"], 
    "\[SpanFromLeft]"}
  }]], "ObjectNameGrid",ExpressionUUID->"8a4c432d-3eab-4182-b2c7-\
da966b09bb2f"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"RhoSatLiqFromT", "[", 
       TemplateBox[{
         Cell[
          TextData["T"]], "paclet:ref/T"},
        "RefLink",
        BaseStyle->{"InlineFormula", FontSlant -> "Italic"}], "]"}]], 
      "InlineFormula",
      ShowStringCharacters->False,
      FontFamily->"Source Sans Pro",ExpressionUUID->
      "396f9ba3-8852-40de-9902-967ad5a8432f"],
     " \[Congruent] ",
     Cell[BoxData[
      SubscriptBox["\[Rho]", "\[Sigma]l"]], "InlineFormula",
      FontFamily->"Source Sans Pro",ExpressionUUID->
      "69db68df-c75e-4ab5-bcfd-980d8ffdbcc2"],
     " (g/",
     Cell[BoxData[
      SuperscriptBox["cm", "3"]], "InlineFormula",
      FontFamily->"Source Sans Pro",ExpressionUUID->
      "13ae7838-1240-4c52-bdff-6bbbc95d32a3"],
     ") \nDensit\[EAcute] du ",
     StyleBox["liquide",
      FontSlant->"Italic"],
     " sur la courbe de saturation en fonction de ",
     StyleBox["T",
      FontSlant->"Italic"],
     " (Kelvin)\n[",
     StyleBox["Liquid",
      FontSlant->"Italic"],
     " density on the saturation curve as a function of ",
     StyleBox["T",
      FontSlant->"Italic"],
     " (Kelvin)]"
    }],ExpressionUUID->"b8db0b83-b663-491f-9418-e1b3d440b21c"]}
  }]], "Usage",ExpressionUUID->"37c37b59-946e-4689-9276-148196f0d87c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[Cell[TextData[{
   Cell[BoxData[
    DynamicBox[ToBoxes[
      If[
       MatchQ[
        CurrentValue[
         EvaluationNotebook[], {TaggingRules, "Openers", "NotesSection"}, 
         Closed], 
        Alternatives[Open, True]], 
       Style[
        Graphics[{
          Thickness[0.18], 
          RGBColor[0.8509803921568627, 0.396078431372549, 0], 
          Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
         PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
        0.68 Inherited], 
       Rotate[
        Style[
         Graphics[{
           Thickness[0.18], 
           RGBColor[0.8509803921568627, 0.396078431372549, 0], 
           Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
          PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
         0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
     ImageSizeCache->{
      13.600000000000001`, {0.5800000000000001, 13.020000000000001`}}]],
    ExpressionUUID->"edd16695-706b-4816-bfc0-83640691d056"],
   Cell[BoxData[
    TemplateBox[{1},
     "Spacer1"]],ExpressionUUID->"3afd715d-3459-44c3-90e8-739a63c9a9bf"],
   "Details and Options"
  }], "NotesFrameText",ExpressionUUID->"fe6f18f7-bc3d-4579-aea0-f00af8c9634c"],
  Appearance->{Automatic, None, "Normal", Automatic},
  BaseStyle->None,
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"], 
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], After, CellContents]}]& ),
  Evaluator->None,
  Method->
   "Preemptive"]],ExpressionUUID->"11dbc8b8-3295-4daa-b6fe-18f7b1ec70b4"]], \
"NotesSection",
 WholeCellGroupOpener->True,
 CellGroupingRules->{"SectionGrouping", 50},
 CacheGraphics->False,
 CellID->183222497,ExpressionUUID->"3d6ff592-2992-4872-9299-4e022a1eacc6"],

Cell[TextData[{
 "La fonction est d\[EAcute]finie pour ",
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["ttr"]], "paclet:NewEoSArgon/ref/ttr", 
    "NewEoSArgon Package Symbol"},
   "PackageLink",
   BaseStyle->"InlineFormula"]], "InlineFormula",
  FontFamily->"Source Sans Pro",ExpressionUUID->
  "83f166c6-7d24-4b40-9723-97d3fbd91744"],
 " \[LessEqual] ",
 StyleBox["T",
  FontSlant->"Italic"],
 " \[LessEqual] ",
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["tc"]], "paclet:NewEoSArgon/ref/tc", 
    "NewEoSArgon Package Symbol"},
   "PackageLink",
   BaseStyle->"InlineFormula"]], "InlineFormula",
  FontFamily->"Source Sans Pro",ExpressionUUID->
  "f8bc3bc0-e6c6-4935-a22b-2d6ca2630b3e"]
}], "Notes",
 CellID->1067943069,ExpressionUUID->"2fd6c302-461c-49a7-924f-b4da4f2ca91d"],

Cell["\<\
******************************************************************************\
*****\
\>", "Notes",
 CellID->185021568,ExpressionUUID->"c1625e41-9b62-4537-a543-1098a1d24718"],

Cell[TextData[{
 "The function is defined for ",
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["ttr"]], "paclet:NewEoSArgon/ref/ttr", 
    "NewEoSArgon Package Symbol"},
   "PackageLink",
   BaseStyle->"InlineFormula"]], "InlineFormula",
  FontFamily->"Source Sans Pro",ExpressionUUID->
  "ad9a4c26-7ddf-433d-b83e-cf1eef5a1018"],
 " \[LessEqual] ",
 StyleBox["T",
  FontSlant->"Italic"],
 " \[LessEqual] ",
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["tc"]], "paclet:NewEoSArgon/ref/tc", 
    "NewEoSArgon Package Symbol"},
   "PackageLink",
   BaseStyle->"InlineFormula"]], "InlineFormula",
  FontFamily->"Source Sans Pro",ExpressionUUID->
  "2b831e3b-fa76-45d1-91ed-1124ff7ff072"]
}], "Notes",
 CellID->121367135,ExpressionUUID->"b5b55074-dba1-458a-b0d4-0c18d81094d6"]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "NotesSection"}, Closed]]]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {
       TaggingRules, "Openers", "PrimaryExamplesSection"}, Open], 
      Alternatives[True, Open]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{13.600000000000001`, {5., 8.600000000000001}}]],
  ExpressionUUID->"f6946594-a7dd-4049-83eb-ecbac7665278"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"17c60a37-9731-45e5-9cdb-ad0ff539c260"],
 "Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "3ee79650-5cc0-44f2-9869-4882f50033eb"]
}], "PrimaryExamplesSection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellTags->"PrimaryExamplesSection",
 CellID->93130705,ExpressionUUID->"54c4ca6c-831d-4982-81b1-a958bd3b0c83"],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"},
        Closed], 
      Alternatives[Open, True]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{13.600000000000001`, {5., 8.600000000000001}}]],
  ExpressionUUID->"c305c1b2-3b69-4efb-9704-bdb99ce0ac0f"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"2ab7a3d8-8f2e-4e2e-b9fc-2e4fdda38409"],
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "9903b0a7-984f-4c0e-91f2-0bc2fc903008"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellID->212206922,ExpressionUUID->"ff776a34-a78f-40ce-b041-238bdf8599c0"],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<NewEoSArgon`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->87419684,ExpressionUUID->"64f9ab9d-91d7-4082-9488-58ed11142e8f"],

Cell["Calculate with physical dimension", "ExampleText",
 CellID->285078790,ExpressionUUID->"23669518-2323-4d2a-858b-361a242e713e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Quantity", "[", 
  RowBox[{
   RowBox[{"RhoSatLiqFromT", "[", "ttr", "]"}], ",", "\"\<g/cm^3\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->231987987,ExpressionUUID->"d717dd29-976c-4b0b-b9d3-faa9372dc33d"],

Cell[BoxData[
 TemplateBox[{"1.4168019421690525`", 
   RowBox[{"\"g\"", "\[InvisibleSpace]", "\"/\"", "\[InvisibleSpace]", 
     SuperscriptBox["\"cm\"", "3"]}], "grams per centimeter cubed", 
   FractionBox["\"Grams\"", 
    SuperscriptBox["\"Centimeters\"", "3"]]},
  "Quantity"]], "Output",
 CellLabel->"Out[2]=",
 CellID->110838590,ExpressionUUID->"c67fe5c8-14bc-4c26-83f9-910430f18397"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UnitConvert", "[", 
  RowBox[{
   TemplateBox[{"1.4168019421690525`"},
    "QuantityUnit",
    DisplayFunction->(TooltipBox[
      StyleBox[
       RowBox[{#, "\[InvisibleSpace]", 
         StyleBox[
          RowBox[{" ", 
            
            RowBox[{"\"g\"", "\[InvisibleSpace]", "\"/\"", 
              "\[InvisibleSpace]", 
              SuperscriptBox["\"cm\"", "3"]}]}], 
          "QuantityUnitTraditionalLabel"]}], ShowStringCharacters -> False], 
      "Unit: grams per centimeter cubed"]& ),
    InterpretationFunction->(RowBox[{"Quantity", "[", 
       RowBox[{#, ",", 
         FractionBox["\"Grams\"", 
          SuperscriptBox["\"Centimeters\"", "3"]]}], "]"}]& )], ",", 
   "\"\<kg/m^3\>\""}], "]"}]], "Input",
 NumberMarks->False,
 CellLabel->"In[3]:=",
 CellID->29539404,ExpressionUUID->"f1512c5b-0e89-4383-bd6f-6a00fe7017cf"],

Cell[BoxData[
 TemplateBox[{"1416.8019421690526`", 
   RowBox[{"\"kg\"", "\[InvisibleSpace]", "\"/\"", "\[InvisibleSpace]", 
     SuperscriptBox["\"m\"", "3"]}], "kilograms per meter cubed", 
   FractionBox["\"Kilograms\"", 
    SuperscriptBox["\"Meters\"", "3"]]},
  "Quantity"]], "Output",
 CellLabel->"Out[3]=",
 CellID->541081116,ExpressionUUID->"0c1b184f-883a-49b6-87a8-d79919a887e6"]
}, Open  ]],

Cell["\<\
Plot function versus temperature and comparison with saturated curve from NIST\
\>", "ExampleText",
 CellID->886239600,ExpressionUUID->"caab759f-0e1f-403c-b2e0-53ddf5d9f60c"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"FigSat", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"RhoSatLiqFromT", "[", "T", "]"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"T", ",", "ttr", ",", "tcNv"}], "}"}], ",", 
     RowBox[{"AxesOrigin", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"ttr", ",", "\[Rho]c"}], "}"}]}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", "Red", "}"}]}], ",", 
     RowBox[{"Frame", "->", "True"}], ",", 
     RowBox[{"FrameLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Quantity", "[", 
         RowBox[{"T", ",", "\"\<Kelvins\>\""}], "]"}], ",", 
        RowBox[{"Quantity", "[", 
         RowBox[{"\[Rho]", ",", "\"\<g/cm^3\>\""}], "]"}]}], "}"}]}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "350"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"FigSatNist", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"RhoSatLiqNISTFromT", "[", "T", "]"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"T", ",", "ttr", ",", "tc"}], "}"}], ",", 
     RowBox[{"AxesOrigin", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"ttr", ",", "\[Rho]c"}], "}"}]}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"Dashed", ",", "Black"}], "}"}], "}"}]}], ",", 
     RowBox[{"Frame", "->", "True"}], ",", 
     RowBox[{"FrameLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Quantity", "[", 
         RowBox[{"T", ",", "\"\<Kelvins\>\""}], "]"}], ",", 
        RowBox[{"Quantity", "[", 
         RowBox[{"\[Rho]", ",", "\"\<g/cm^3\>\""}], "]"}]}], "}"}]}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "350"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Legended", "[", 
  RowBox[{
   RowBox[{"Show", "[", 
    RowBox[{"{", 
     RowBox[{"FigSat", ",", "FigSatNist"}], "}"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Placed", "[", 
      RowBox[{
       RowBox[{"LineLegend", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"Directive", "[", 
           RowBox[{"Black", ",", "Dashed"}], "]"}], "}"}], ",", 
         RowBox[{"{", "\"\<RhoSatVapNISTFromT[T]\>\"", "}"}]}], "]"}], ",", 
       "Below"}], "]"}], ",", 
     RowBox[{"Placed", "[", 
      RowBox[{
       RowBox[{"LineLegend", "[", 
        RowBox[{
         RowBox[{"{", "Red", "}"}], ",", 
         RowBox[{"{", "\"\<RhoSatVapFromT[T]\>\"", "}"}]}], "]"}], ",", 
       "Below"}], "]"}]}], "}"}]}], "]"}]}], "Input",
 CellLabel->"In[4]:=",
 CellID->21488140,ExpressionUUID->"527c7431-5009-45b4-9de7-91a5de23c802"],

Cell[BoxData[
 GraphicsBox[
  TagBox[RasterBox[CompressedData["
1:eJzt3XFsHNd94PEhtYrXNlMztprQMZ0wMWszjS6Rc0rMNmpCp2ys9FRUl1Nq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    "], {{0, 258.}, {350., 0}}, {0, 255},
    ColorFunction->RGBColor,
    ImageResolution->{144., 144.},
    SmoothingQuality->"High"],
   BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
   Selectable->False],
  DefaultBaseStyle->"ImageGraphics",
  ImageSize->Automatic,
  ImageSizeRaw->{350., 258.},
  PlotRange->{{0, 350.}, {0, 258.}}]], "Output",
 CellTags->"RasterizedOutput",
 CellLabel->"Out[4]=",
 CellID->34208227,ExpressionUUID->"89998052-0639-4a6a-8a24-7bd9ae33928c"]
}, Open  ]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"}, 
  Closed]]]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "PrimaryExamplesSection"}, 
  Closed]]]],

Cell[BoxData[GridBox[{
   {
    DynamicBox[FEPrivate`ImportImage[
      FrontEnd`FileName[{"Documentation", "FooterIcons"}, 
       "RelatedFunction.png"]],
     ImageSizeCache->{50., {27., 33.}}], GridBox[{
      {
       StyleBox[
        RowBox[{"See", " ", "Also"}], "SeeAlsoSection"]},
      {Cell[TextData[{
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["rhotrliqNv"]], "paclet:NewEoSArgon/ref/rhotrliqNv", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "82da23dd-2232-4865-b95c-1064193456f6"],
        "\[NonBreakingSpace]",
        StyleBox[
        "\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
         "InlineSeparator"],
        " ",
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["rhocNv"]], "paclet:NewEoSArgon/ref/rhocNv", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "77466d56-a958-4ef4-86f6-6569665cecaa"],
        "\[NonBreakingSpace]",
        StyleBox[
        "\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
         "InlineSeparator"],
        " ",
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["RhoSatLiqNISTFromT"]], 
           "paclet:NewEoSArgon/ref/RhoSatLiqNISTFromT", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "1bcb5a9e-9403-4e5c-ae11-496c13a1a265"],
        "\[NonBreakingSpace]",
        StyleBox[
        "\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
         "InlineSeparator"],
        " ",
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["ttr"]], "paclet:NewEoSArgon/ref/ttr", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "9341c1c7-caad-42ac-ab7f-fe2bf9540758"],
        "\[NonBreakingSpace]",
        StyleBox[
        "\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
         "InlineSeparator"],
        " ",
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["tcNv"]], "paclet:NewEoSArgon/ref/tcNv", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "aa43b035-58c0-457c-a669-1f6a96062cc0"]
       }], "SeeAlso",ExpressionUUID->"2f19a893-87df-4972-8329-8d2a5b4edbed"]}
     }]}
  }]], "SeeAlsoSection",ExpressionUUID->"40704d81-bd10-47c8-97c0-\
5605fda3af22"],

Cell[BoxData[GridBox[{
   {
    DynamicBox[FEPrivate`ImportImage[
      FrontEnd`FileName[{"Documentation", "FooterIcons"}, "RelatedGuide.png"]],
     ImageSizeCache->{50., {27., 33.}}], GridBox[{
      {
       StyleBox[
        RowBox[{"Related", " ", "Guides"}], "MoreAboutSection"]},
      {
       RowBox[{"\[FilledVerySmallSquare]", Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["NewEoSArgon Package"]], 
           "paclet:NewEoSArgon/guide/NewEoSArgon"},
          "RefLinkPlain",
          BaseStyle->{"MoreAbout"}]], "MoreAbout",ExpressionUUID->
         "ff070a61-7ea0-4020-bc4e-8362292f8762"]}]}
     }]}
  }]], "MoreAboutSection",ExpressionUUID->"1466166a-18a7-47ca-8015-\
ec8f1e8a0887"],

Cell[BoxData[GridBox[{
   {
    TemplateBox[{29},
     "Spacer1"], GridBox[{
      {
       RowBox[{
        TemplateBox[{17},
         "Spacer1"], 
        StyleBox[
         RowBox[{"Related", " ", "Links"}], "RelatedLinksSection"]}]},
      {Cell[BoxData[Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData[
             RowBox[{
               RowBox[{"Units", " ", "&"}], " ", "Quantities"}]]], 
           "paclet:guide/Units"},
          "RefLinkPlain",
          BaseStyle->{"RelatedLinks"}]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "8111f51d-303c-4541-b18d-2dabb603a6c2"]], "RelatedLinks",
        ExpressionUUID->"8d7f293b-2af9-47ae-846f-2baccca5d94c"]},
      {Cell[BoxData[Cell[BoxData[Cell[BoxData[
          RowBox[{
           TemplateBox[{16},
            "Spacer1"], "\[FilledVerySmallSquare]", 
           TemplateBox[{
             Cell[
              TextData[
               Cell[
                TextData[{
                  Cell[
                   BoxData[
                    TemplateBox[{2}, "Spacer1"]]], "ThermodynamicData"}]]]], 
             "paclet:ref/ThermodynamicData"},
            "RefLink",
            BaseStyle->{"RelatedLinks"}]}]],ExpressionUUID->
          "a58aa290-634c-43d6-b4f1-b5422b543b0f"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "f77c40bb-e8db-416c-ae73-f4d885d5ab71"]], "RelatedLinks",
        ExpressionUUID->"49b75150-99dc-4efa-a242-70c7ceb938af"]}
     }]}
  }]], "RelatedLinksSection",ExpressionUUID->"5bbb304d-bded-4ed2-9458-\
e5bdd6541e5e"],

Cell[" ", "FooterCell",ExpressionUUID->"d14ac6b4-e2c4-494c-aff8-f177debcd840"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{900, 835.8},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"RhoSatLiqFromT",
TaggingRules->{
 "ModificationHighlight" -> False, "ColorType" -> "", "LinkTrails" -> "", 
  "HasOptions" -> True, "ExampleCounter" -> 1, 
  "Openers" -> {
   "PrimaryExamplesSection" -> Open, "ExampleSection" -> {"0" -> Open}, 
    "NotesSection" -> Closed}, "NewStyles" -> True, 
  "CitationPopupData" -> $Failed, "ShowCitation" -> False, "RootCaptions" -> 
  "", "Metadata" -> {
   "built" -> "{2023, 11, 30, 13, 55, 59.5329032}", 
    "history" -> {"XX", "", "", ""}, "context" -> "NewEoSArgon`", 
    "keywords" -> {}, "specialkeywords" -> {}, 
    "tutorialcollectionlinks" -> {}, "index" -> True, "label" -> 
    "New Eo S Argon Package Symbol", "language" -> "en", "paclet" -> 
    "NewEoSArgon Package", "status" -> "None", "summary" -> 
    "RhoSatLiqFromT[T] \\[Congruent] \\[Rho]\\[Sigma]l (g/cm^3) Densit\
\[EAcute] du liquide sur la courbe de saturation en fonction de T (Kelvin) \
[Liquid density on the saturation curve as a function of T (Kelvin)]", 
    "synonyms" -> {}, "tabletags" -> {}, "title" -> "RhoSatLiqFromT", 
    "titlemodifier" -> "", "metadescription" -> "", "windowtitle" -> 
    "RhoSatLiqFromT", "type" -> "Symbol", "uri" -> 
    "NewEoSArgon/ref/RhoSatLiqFromT"}},
CellContext->"Global`",
FrontEndVersion->"13.3 pour Microsoft Windows (64-bit) (July 24, 2023)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "13.3 pour Microsoft Windows (64-bit) (July 24, 2023)", 
  StyleDefinitions -> "Default.nb"],
ExpressionUUID->"727f8094-ca21-48b3-9a2d-c4fe9c5c6c13"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[12086, 334, 1419, 37, 35, "PrimaryExamplesSection",ExpressionUUID->"54c4ca6c-831d-4982-81b1-a958bd3b0c83",
   CellTags->"PrimaryExamplesSection",
   CellID->93130705]},
 "RasterizedOutput"->{
  Cell[20060, 562, 25193, 419, 279, "Output",ExpressionUUID->"89998052-0639-4a6a-8a24-7bd9ae33928c",
   CellTags->"RasterizedOutput",
   CellID->34208227]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 52880, 1184},
 {"RasterizedOutput", 53079, 1188}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[586, 21, 5618, 135, 56, "AnchorBarGrid",ExpressionUUID->"f372a188-f246-4d2f-ab83-542ba30ea8fb",
 CellID->1],
Cell[6207, 158, 94, 0, 23, "ContextNameCell",ExpressionUUID->"c2d5afbb-1488-46f6-9689-7495f7fe96d9"],
Cell[CellGroupData[{
Cell[6326, 162, 557, 14, 56, "ObjectNameGrid",ExpressionUUID->"8a4c432d-3eab-4182-b2c7-da966b09bb2f"],
Cell[6886, 178, 1333, 37, 148, "Usage",ExpressionUUID->"37c37b59-946e-4689-9276-148196f0d87c"]
}, Open  ]],
Cell[CellGroupData[{
Cell[8256, 220, 1919, 48, 37, "NotesSection",ExpressionUUID->"3d6ff592-2992-4872-9299-4e022a1eacc6",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->183222497],
Cell[10178, 270, 800, 25, 38, "Notes",ExpressionUUID->"2fd6c302-461c-49a7-924f-b4da4f2ca91d",
 CellID->1067943069],
Cell[10981, 297, 185, 4, 36, "Notes",ExpressionUUID->"c1625e41-9b62-4537-a543-1098a1d24718",
 CellID->185021568],
Cell[11169, 303, 790, 25, 38, "Notes",ExpressionUUID->"b5b55074-dba1-458a-b0d4-0c18d81094d6",
 CellID->121367135]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "NotesSection"}, Closed]]]],
Cell[CellGroupData[{
Cell[12086, 334, 1419, 37, 35, "PrimaryExamplesSection",ExpressionUUID->"54c4ca6c-831d-4982-81b1-a958bd3b0c83",
 CellTags->"PrimaryExamplesSection",
 CellID->93130705],
Cell[CellGroupData[{
Cell[13530, 375, 1398, 36, 30, "ExampleSection",ExpressionUUID->"ff776a34-a78f-40ce-b041-238bdf8599c0",
 CellID->212206922],
Cell[14931, 413, 174, 3, 26, "Input",ExpressionUUID->"64f9ab9d-91d7-4082-9488-58ed11142e8f",
 CellID->87419684],
Cell[15108, 418, 131, 1, 38, "ExampleText",ExpressionUUID->"23669518-2323-4d2a-858b-361a242e713e",
 CellID->285078790],
Cell[CellGroupData[{
Cell[15264, 423, 242, 6, 26, "Input",ExpressionUUID->"d717dd29-976c-4b0b-b9d3-faa9372dc33d",
 CellID->231987987],
Cell[15509, 431, 391, 8, 45, "Output",ExpressionUUID->"c67fe5c8-14bc-4c26-83f9-910430f18397",
 CellID->110838590]
}, Open  ]],
Cell[CellGroupData[{
Cell[15937, 444, 872, 23, 30, "Input",ExpressionUUID->"f1512c5b-0e89-4383-bd6f-6a00fe7017cf",
 CellID->29539404],
Cell[16812, 469, 389, 8, 45, "Output",ExpressionUUID->"0c1b184f-883a-49b6-87a8-d79919a887e6",
 CellID->541081116]
}, Open  ]],
Cell[17216, 480, 184, 3, 38, "ExampleText",ExpressionUUID->"caab759f-0e1f-403c-b2e0-53ddf5d9f60c",
 CellID->886239600],
Cell[CellGroupData[{
Cell[17425, 487, 2632, 73, 118, "Input",ExpressionUUID->"527c7431-5009-45b4-9de7-91a5de23c802",
 CellID->21488140],
Cell[20060, 562, 25193, 419, 279, "Output",ExpressionUUID->"89998052-0639-4a6a-8a24-7bd9ae33928c",
 CellTags->"RasterizedOutput",
 CellID->34208227]
}, Open  ]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"}, Closed]]]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "PrimaryExamplesSection"}, Closed]]]],
Cell[45495, 990, 2934, 79, 70, "SeeAlsoSection",ExpressionUUID->"40704d81-bd10-47c8-97c0-5605fda3af22"],
Cell[48432, 1071, 729, 19, 70, "MoreAboutSection",ExpressionUUID->"1466166a-18a7-47ca-8015-ec8f1e8a0887"],
Cell[49164, 1092, 1607, 43, 70, "RelatedLinksSection",ExpressionUUID->"5bbb304d-bded-4ed2-9458-e5bdd6541e5e"],
Cell[50774, 1137, 78, 0, 70, "FooterCell",ExpressionUUID->"d14ac6b4-e2c4-494c-aff8-f177debcd840"]
}
]
*)

(* End of internal cache information *)

