(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 13.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     43959,       1074]
NotebookOptionsPosition[     38539,        965]
NotebookOutlinePosition[     40902,       1022]
CellTagsIndexPosition[     40816,       1017]
WindowTitle->RhoSatLiqNISTFromT
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[GridBox[{
   {GridBox[{
      {
       ItemBox[Cell[BoxData[
         RowBox[{
          TemplateBox[{12},
           "Spacer1"], Cell["NEW EO S ARGON PACKAGE SYMBOL", "PacletNameCell",
           TextAlignment->Center,ExpressionUUID->
           "5fb8bf93-10cd-41a3-8704-a0efc34df888"], 
          TemplateBox[{8},
           "Spacer1"]}]],
         TextAlignment->Center,ExpressionUUID->
         "046a102f-6eac-40f9-a125-d90956b229f6"],
        Background->RGBColor[0.490196, 0.576471, 0.690196],
        ItemSize->Full], ""}
     },
     GridBoxAlignment->{"Rows" -> {{Center}}},
     GridBoxItemSize->{"Columns" -> {Full, 
         Scaled[0.02]}, "Rows" -> {{2.5}}}], Cell[TextData[{
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "See Also",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "93c75426-88e0-42d5-ba80-053662308976"]
         }],ExpressionUUID->"13f3a73c-adde-4410-84f4-5c756c5fe1ca"],
         StripOnInput->False],{
        "\"rhotrliq\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/rhotrliq"], 
         "\"rhoc\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/rhoc"], "\"ttr\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/ttr"], "\"tc\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/tc"], 
         "\"RhoSatVapNISTFromT\"" :> 
         Documentation`HelpLookup[
          "paclet:NewEoSArgon/ref/RhoSatVapNISTFromT"]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"SeeAlso"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "ff8b3471-18ec-493b-a2a9-8a62f5cba671"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "Related Guides",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "e347c939-e729-44ec-9dc0-901a5533d780"]
         }],ExpressionUUID->"15be741a-b5a1-4624-a86d-d1070c43a452"],
         StripOnInput->False],{
        "\"NewEoSArgon Package\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/guide/NewEoSArgon"]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"MoreAbout"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "94eec1c6-5c38-4325-8096-b147d3690528"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "URL",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "85113110-df65-4f53-9bab-3068ac002bcb"]
         }],ExpressionUUID->"93a91479-2ca3-4ab5-982d-97ce947012b6"],
         StripOnInput->False],{
        "\"NewEoSArgon/ref/RhoSatLiqNISTFromT\"" :> None, 
         "\"Copy Wolfram Documentation Center URL\"" :> 
         Module[{DocumentationSearch`Private`nb$}, 
           DocumentationSearch`Private`nb$ = 
            NotebookPut[
             Notebook[{Cell["NewEoSArgon/ref/RhoSatLiqNISTFromT"]}, Visible -> 
               False]]; 
           SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
           FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
           NotebookClose[DocumentationSearch`Private`nb$]; Null], Delimiter, 
         "\"Copy web URL\"" :> 
         Module[{DocumentationSearch`Private`nb$}, 
           DocumentationSearch`Private`nb$ = 
            NotebookPut[
             Notebook[{
               Cell[BoxData[
                 MakeBoxes[
                  Hyperlink[
                   "http://reference.wolfram.com/language/NewEoSArgon/ref/\
RhoSatLiqNISTFromT.html"], StandardForm]], "Input", TextClipboardType -> 
                 "PlainText"]}, Visible -> False]]; 
           SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
           FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
           NotebookClose[DocumentationSearch`Private`nb$]; Null], 
         "\"Go to web URL\"" :> 
         FrontEndExecute[{
           NotebookLocate[{
             URL[If[TrueQ[DocumentationBuild`Make`Private`wsmlinkQ$25321], 
                 "http://reference.wolfram.com/system-modeler/", 
                 "http://reference.wolfram.com/language/"] <> 
               "NewEoSArgon/ref/RhoSatLiqNISTFromT" <> ".html"], None}]}]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"URLMenu"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "188443d3-a793-4abe-b0e3-72a377e08ef5"]
    }], "AnchorBar",
     CacheGraphics->False,ExpressionUUID->
     "73bb8bc5-1d39-4b6e-b9c9-42b5e2410c63"]}
  }]], "AnchorBarGrid",
 CellID->1,ExpressionUUID->"2dee03af-50c3-401e-a880-b8a1d8883cd5"],

Cell["NewEoSArgon`", "ContextNameCell",ExpressionUUID->"c7220829-773b-4590-ae56-14bf8d0a58f9"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     Cell[
     "RhoSatLiqNISTFromT", "ObjectName",ExpressionUUID->
      "c2fa9b85-33ac-44c3-ac41-8f1c6caeb631"],
     Cell[BoxData[
      TemplateBox[{8},
       "Spacer1"]],ExpressionUUID->"e0fbaf17-2886-4f12-9841-9e2fc5c5a48e"],
     Cell[BoxData[
     ""], "ObjectNameTranslation",ExpressionUUID->
      "1dac71da-98ee-49ee-b1c3-88203850dd83"]
    }],ExpressionUUID->"b50411bc-f491-4814-b00e-c3445021648d"], 
    "\[SpanFromLeft]"}
  }]], "ObjectNameGrid",ExpressionUUID->"0d1e0d4a-6790-4e69-beb6-\
6700b99226f0"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"RhoSatLiqNISTFromT", "[", 
       TemplateBox[{
         Cell[
          TextData["T"]], "paclet:ref/T"},
        "RefLink",
        BaseStyle->{"InlineFormula", FontSlant -> "Italic"}], "]"}]], 
      "InlineFormula",
      ShowStringCharacters->False,
      FontFamily->"Source Sans Pro",ExpressionUUID->
      "b7d27f37-0cd4-476d-99ab-65e43d0c56dc"],
     " \[Congruent] ",
     Cell[BoxData[
      SubscriptBox["\[Rho]", "\[Sigma]l"]], "InlineFormula",
      FontFamily->"Source Sans Pro",ExpressionUUID->
      "a49bf043-9f6d-4dba-a759-7d2cf51f86c2"],
     " (g/",
     Cell[BoxData[
      SuperscriptBox["cm", "3"]], "InlineFormula",
      FontFamily->"Source Sans Pro",ExpressionUUID->
      "e422a9ec-f294-4da2-a2cb-b4db030d8931"],
     ") \nDensit\[EAcute] du ",
     StyleBox["liquide",
      FontSlant->"Italic"],
     " sur la courbe de saturation donn\[EAcute]e par NIST en fonction de ",
     StyleBox["T",
      FontSlant->"Italic"],
     " (Kelvin)\n[",
     StyleBox["Liquid",
      FontSlant->"Italic"],
     " density on the saturation curve given by NIST as a function of ",
     StyleBox["T",
      FontSlant->"Italic"],
     " (Kelvin)]"
    }],ExpressionUUID->"e9de1960-5456-4b50-b653-26e79d3d128e"]}
  }]], "Usage",ExpressionUUID->"fa74bf2b-6b13-4681-86a8-ade57e6e48b3"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[Cell[TextData[{
   Cell[BoxData[
    DynamicBox[ToBoxes[
      If[
       MatchQ[
        CurrentValue[
         EvaluationNotebook[], {TaggingRules, "Openers", "NotesSection"}, 
         Closed], 
        Alternatives[Open, True]], 
       Style[
        Graphics[{
          Thickness[0.18], 
          RGBColor[0.8509803921568627, 0.396078431372549, 0], 
          Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
         PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
        0.68 Inherited], 
       Rotate[
        Style[
         Graphics[{
           Thickness[0.18], 
           RGBColor[0.8509803921568627, 0.396078431372549, 0], 
           Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
          PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
         0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
     ImageSizeCache->{
      13.600000000000001`, {0.5800000000000001, 13.020000000000001`}}]],
    ExpressionUUID->"0d7f267e-dcd4-4271-9139-e3ddf26893f1"],
   Cell[BoxData[
    TemplateBox[{1},
     "Spacer1"]],ExpressionUUID->"f3c22456-8b4a-46b5-b511-d8aedbdd64ea"],
   "Details and Options"
  }], "NotesFrameText",ExpressionUUID->"8ce37b7f-5179-4de4-812e-53a7777610c8"],
  Appearance->{Automatic, None, "Normal", Automatic},
  BaseStyle->None,
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"], 
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], After, CellContents]}]& ),
  Evaluator->None,
  Method->
   "Preemptive"]],ExpressionUUID->"d2f7b604-822f-46b8-8724-31adb89f2eeb"]], \
"NotesSection",
 WholeCellGroupOpener->True,
 CellGroupingRules->{"SectionGrouping", 50},
 CacheGraphics->False,
 CellID->584727172,ExpressionUUID->"88f98b58-9ee0-4914-9656-01f3545807fe"],

Cell[TextData[{
 "La fonction est d\[EAcute]finie pour ",
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["ttr"]], "paclet:NewEoSArgon/ref/ttr", 
    "NewEoSArgon Package Symbol"},
   "PackageLink",
   BaseStyle->"InlineFormula"]], "InlineFormula",
  FontFamily->"Source Sans Pro",ExpressionUUID->
  "5e088fa4-33dc-47db-8c1f-887c32ec82e7"],
 " \[LessEqual] ",
 StyleBox["T",
  FontSlant->"Italic"],
 " \[LessEqual] ",
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["tc"]], "paclet:NewEoSArgon/ref/tc", 
    "NewEoSArgon Package Symbol"},
   "PackageLink",
   BaseStyle->"InlineFormula"]], "InlineFormula",
  FontFamily->"Source Sans Pro",ExpressionUUID->
  "5cdbcd38-df9e-49ba-bdb3-632d17232af6"]
}], "Notes",
 CellID->1067943069,ExpressionUUID->"6bda968e-af7d-4e21-8d72-2b05a76ca5d3"],

Cell["\<\
******************************************************************************\
*****\
\>", "Notes",
 CellID->185021568,ExpressionUUID->"bd07f567-a7b2-4205-a0c5-3e5f1bae98af"],

Cell[TextData[{
 "The function is defined for ",
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["ttr"]], "paclet:NewEoSArgon/ref/ttr", 
    "NewEoSArgon Package Symbol"},
   "PackageLink",
   BaseStyle->"InlineFormula"]], "InlineFormula",
  FontFamily->"Source Sans Pro",ExpressionUUID->
  "b9e1c41c-e05f-43d8-a7a2-95be11cbe1ac"],
 " \[LessEqual] ",
 StyleBox["T",
  FontSlant->"Italic"],
 " \[LessEqual] ",
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["tc"]], "paclet:NewEoSArgon/ref/tc", 
    "NewEoSArgon Package Symbol"},
   "PackageLink",
   BaseStyle->"InlineFormula"]], "InlineFormula",
  FontFamily->"Source Sans Pro",ExpressionUUID->
  "338a255b-3594-44ab-a716-39db33c0f99c"]
}], "Notes",
 CellID->121367135,ExpressionUUID->"cb6d427a-d10f-49cb-ae02-d8bb7d69eef1"]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "NotesSection"}, Closed]]]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {
       TaggingRules, "Openers", "PrimaryExamplesSection"}, Open], 
      Alternatives[True, Open]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{13.600000000000001`, {5., 8.600000000000001}}]],
  ExpressionUUID->"46186088-641a-41e9-aae6-d46d1897218f"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"1874f7ab-cec0-4ef9-81f0-224b768a5699"],
 "Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "2fb3d0e6-b9a4-484f-a406-d6316ed2ca9d"]
}], "PrimaryExamplesSection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellTags->"PrimaryExamplesSection",
 CellID->28051787,ExpressionUUID->"9306785c-aa7f-4884-b5b7-ab6cd4c57912"],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"},
        Closed], 
      Alternatives[Open, True]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{13.600000000000001`, {5., 8.600000000000001}}]],
  ExpressionUUID->"d68380d2-b00d-4acf-a976-ef3db8c9832a"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"c3c913bc-1425-48a9-96ad-f241d0253c04"],
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "92d0c48c-8662-44aa-b6cb-32c7ac675af1"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellID->159387233,ExpressionUUID->"da9c801c-c884-41ac-9fb9-e79466cf56a5"],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<NewEoSArgon`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->87419684,ExpressionUUID->"4bf26485-5e77-4081-a96b-0384b5250f59"],

Cell["Calculate with physical dimension", "ExampleText",
 CellID->285078790,ExpressionUUID->"47607793-fc19-4fb8-a669-92904e2eed05"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Quantity", "[", 
  RowBox[{
   RowBox[{"RhoSatLiqNISTFromT", "[", "ttr", "]"}], ",", "\"\<g/cm^3\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->231987987,ExpressionUUID->"97015f6b-9918-4fe3-85ec-2198223bfb83"],

Cell[BoxData[
 TemplateBox[{"1.4168017335853793`", 
   RowBox[{"\"g\"", "\[InvisibleSpace]", "\"/\"", "\[InvisibleSpace]", 
     SuperscriptBox["\"cm\"", "3"]}], "grams per centimeter cubed", 
   FractionBox["\"Grams\"", 
    SuperscriptBox["\"Centimeters\"", "3"]]},
  "Quantity"]], "Output",
 CellLabel->"Out[2]=",
 CellID->394796393,ExpressionUUID->"ae78b1a9-cac5-40e4-b6ce-f89fe3bd6400"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UnitConvert", "[", 
  RowBox[{
   TemplateBox[{"1.4168017335853793`"},
    "QuantityUnit",
    DisplayFunction->(TooltipBox[
      StyleBox[
       RowBox[{#, "\[InvisibleSpace]", 
         StyleBox[
          RowBox[{" ", 
            
            RowBox[{"\"g\"", "\[InvisibleSpace]", "\"/\"", 
              "\[InvisibleSpace]", 
              SuperscriptBox["\"cm\"", "3"]}]}], 
          "QuantityUnitTraditionalLabel"]}], ShowStringCharacters -> False], 
      "Unit: grams per centimeter cubed"]& ),
    InterpretationFunction->(RowBox[{"Quantity", "[", 
       RowBox[{#, ",", 
         FractionBox["\"Grams\"", 
          SuperscriptBox["\"Centimeters\"", "3"]]}], "]"}]& )], ",", 
   "\"\<kg/m^3\>\""}], "]"}]], "Input",
 NumberMarks->False,
 CellLabel->"In[3]:=",
 CellID->474398445,ExpressionUUID->"52087bbc-79ca-4307-b80c-0e290c4c0bdf"],

Cell[BoxData[
 TemplateBox[{"1416.8017335853792`", 
   RowBox[{"\"kg\"", "\[InvisibleSpace]", "\"/\"", "\[InvisibleSpace]", 
     SuperscriptBox["\"m\"", "3"]}], "kilograms per meter cubed", 
   FractionBox["\"Kilograms\"", 
    SuperscriptBox["\"Meters\"", "3"]]},
  "Quantity"]], "Output",
 CellLabel->"Out[3]=",
 CellID->172769535,ExpressionUUID->"aa5a005f-b568-43a6-88a1-bc2a81c4e44a"]
}, Open  ]],

Cell["\<\
Plot function versus temperature in all the temperature range\
\>", "ExampleText",
 CellID->886239600,ExpressionUUID->"6c13bf70-c4c2-46b3-8dd7-570bd6f366af"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"RhoSatLiqNISTFromT", "[", "T", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"T", ",", "ttr", ",", "tc"}], "}"}], ",", 
   RowBox[{"AxesOrigin", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"ttr", ",", "\[Rho]c"}], "}"}]}], ",", 
   RowBox[{"Frame", "->", "True"}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Quantity", "[", 
       RowBox[{"T", ",", "\"\<Kelvins\>\""}], "]"}], ",", 
      RowBox[{"Quantity", "[", 
       RowBox[{"\[Rho]", ",", "\"\<g/cm^3\>\""}], "]"}]}], "}"}]}], ",", 
   RowBox[{"ImageSize", "\[Rule]", "400"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->21488140,ExpressionUUID->"11aead64-6d13-4d49-864e-16f478b3643c"],

Cell[BoxData[
 GraphicsBox[
  InterpretationBox[{
    TagBox[{{{}, {}, 
       TagBox[
        {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[2], 
         Opacity[1.], LineBox[CompressedData["
1:eJwV03s4FHgXB3CrlPZVrUSuWy4TuiDRS+KcSiFZDTNixmXmt6IoksS2Uai8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          "]]},
        Annotation[#, "Charting`Private`Tag#1"]& ]}, {}},
     {"WolframDynamicHighlight", <|
      "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>}], 
    DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
      Slot["HighlightElements"], 
      Slot["LayoutOptions"], 
      Slot["Meta"], 
      Charting`HighlightActionFunction["DynamicHighlight", {{{{}, {}, 
          Annotation[{
            Directive[
             Opacity[1.], 
             RGBColor[0.368417, 0.506779, 0.709798], 
             AbsoluteThickness[2]], 
            Line[CompressedData["
1:eJwV03s4FHgXB3CrlPZVrUSuWy4TuiDRS+KcSiFZDTNixmXmt6IoksS2Uai8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             "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
       "HighlightElements" -> <|
         "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
        "LayoutOptions" -> <|
         "PlotRange" -> {{83.8058, 150.687}, {0.535599, 1.4168017246892244`}},
           "Frame" -> {{True, True}, {True, True}}, 
          "AxesOrigin" -> {83.8058, 0.535599}, 
          "ImageSize" -> {400, 400/GoldenRatio}, "Axes" -> {True, True}, 
          "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
          "DefaultStyle" -> {
            Directive[
             Opacity[1.], 
             RGBColor[0.368417, 0.506779, 0.709798], 
             AbsoluteThickness[2]]}, 
          "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
              Identity[
               Part[#, 1]], 
              Identity[
               Part[#, 2]]}& ), 
            "ScalingFunctions" -> {{Identity, Identity}, {
              Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>,
         "Meta" -> <|
         "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
          Plot, "GroupHighlight" -> False|>|>]]& )[<|
      "HighlightElements" -> <|
        "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
       "LayoutOptions" -> <|
        "PlotRange" -> {{83.8058, 150.687}, {0.535599, 1.4168017246892244`}}, 
         "Frame" -> {{True, True}, {True, True}}, 
         "AxesOrigin" -> {83.8058, 0.535599}, 
         "ImageSize" -> {400, 400/GoldenRatio}, "Axes" -> {True, True}, 
         "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
         "DefaultStyle" -> {
           Directive[
            Opacity[1.], 
            RGBColor[0.368417, 0.506779, 0.709798], 
            AbsoluteThickness[2]]}, 
         "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
             Identity[
              Part[#, 1]], 
             Identity[
              Part[#, 2]]}& ), 
           "ScalingFunctions" -> {{Identity, Identity}, {
             Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>, 
       "Meta" -> <|
        "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
         Plot, "GroupHighlight" -> False|>|>],
     ImageSizeCache->{{4.503599627370496*^15, -4.503599627370496*^15}, {
      4.503599627370496*^15, -4.503599627370496*^15}}]},
   Annotation[{{{{}, {}, 
       Annotation[{
         Directive[
          Opacity[1.], 
          RGBColor[0.368417, 0.506779, 0.709798], 
          AbsoluteThickness[2]], 
         Line[CompressedData["
1:eJwV03s4FHgXB3CrlPZVrUSuWy4TuiDRS+KcSiFZDTNixmXmt6IoksS2Uai8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          "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
    "HighlightElements" -> <|
      "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
     "LayoutOptions" -> <|
      "PlotRange" -> {{83.8058, 150.687}, {0.535599, 1.4168017246892244`}}, 
       "Frame" -> {{True, True}, {True, True}}, 
       "AxesOrigin" -> {83.8058, 0.535599}, 
       "ImageSize" -> {400, 400/GoldenRatio}, "Axes" -> {True, True}, 
       "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), "DefaultStyle" -> {
         Directive[
          Opacity[1.], 
          RGBColor[0.368417, 0.506779, 0.709798], 
          AbsoluteThickness[2]]}, 
       "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
           Identity[
            Part[#, 1]], 
           Identity[
            Part[#, 2]]}& ), 
         "ScalingFunctions" -> {{Identity, Identity}, {Identity, Identity}}|>,
        "Primitives" -> {}, "GCFlag" -> False|>, 
     "Meta" -> <|
      "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
       Plot, "GroupHighlight" -> False|>|>, "DynamicHighlight"]],
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{83.8058, 0.535599},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{
     FormBox[
      TagBox[
       TemplateBox[{"\[Rho]", 
         RowBox[{"\"g\"", "\[InvisibleSpace]", "\"/\"", "\[InvisibleSpace]", 
           SuperscriptBox["\"cm\"", "3"]}], "grams per centimeter cubed", 
         FractionBox["\"Grams\"", 
          SuperscriptBox["\"Centimeters\"", "3"]]}, "QuantityTF", SyntaxForm -> 
        Mod], HoldForm], TraditionalForm], None}, {
     FormBox[
      TagBox[
       TemplateBox[{
         TagBox[
          TagBox["T", HoldForm], HoldForm], "\"K\"", "kelvins", 
         "\"Kelvins\""}, "QuantityTF", SyntaxForm -> Mod], HoldForm], 
      TraditionalForm], None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  ImageSize->400,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{83.8058, 150.687}, {0.535599, 1.4168017246892244`}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellLabel->"Out[4]=",
 CellID->632687920,ExpressionUUID->"ef738ad5-b699-42da-94d4-1fc145d31cf2"]
}, Open  ]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"}, 
  Closed]]]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "PrimaryExamplesSection"}, 
  Closed]]]],

Cell[BoxData[GridBox[{
   {
    DynamicBox[FEPrivate`ImportImage[
      FrontEnd`FileName[{"Documentation", "FooterIcons"}, 
       "RelatedFunction.png"]],
     ImageSizeCache->{50., {27., 33.}}], GridBox[{
      {
       StyleBox[
        RowBox[{"See", " ", "Also"}], "SeeAlsoSection"]},
      {Cell[TextData[{
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["rhotrliq"]], "paclet:NewEoSArgon/ref/rhotrliq", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "4d9afcf1-d9b4-4a7c-bf5c-2740bd6ad4ca"],
        "\[NonBreakingSpace]",
        StyleBox[
        "\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
         "InlineSeparator"],
        " ",
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["rhoc"]], "paclet:NewEoSArgon/ref/rhoc", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "2c16eb52-4080-4a44-83ca-a63eb43b9e59"],
        "\[NonBreakingSpace]",
        StyleBox[
        "\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
         "InlineSeparator"],
        " ",
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["ttr"]], "paclet:NewEoSArgon/ref/ttr", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "58897f7d-1b97-4684-9b3c-69c15fa1e4e1"],
        "\[NonBreakingSpace]",
        StyleBox[
        "\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
         "InlineSeparator"],
        " ",
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["tc"]], "paclet:NewEoSArgon/ref/tc", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "5551d810-1a10-4e15-b171-619111d3eb17"],
        "\[NonBreakingSpace]",
        StyleBox[
        "\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
         "InlineSeparator"],
        " ",
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["RhoSatVapNISTFromT"]], 
           "paclet:NewEoSArgon/ref/RhoSatVapNISTFromT", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "7f427e82-d44e-4236-aa6c-cc6c10650a4b"]
       }], "SeeAlso",ExpressionUUID->"012340f9-562b-40bf-83c0-607c102161c1"]}
     }]}
  }]], "SeeAlsoSection",ExpressionUUID->"e2556472-822e-406d-96fc-\
ef80125f6ffb"],

Cell[BoxData[GridBox[{
   {
    DynamicBox[FEPrivate`ImportImage[
      FrontEnd`FileName[{"Documentation", "FooterIcons"}, "RelatedGuide.png"]],
     ImageSizeCache->{50., {27., 33.}}], GridBox[{
      {
       StyleBox[
        RowBox[{"Related", " ", "Guides"}], "MoreAboutSection"]},
      {
       RowBox[{"\[FilledVerySmallSquare]", Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["NewEoSArgon Package"]], 
           "paclet:NewEoSArgon/guide/NewEoSArgon"},
          "RefLinkPlain",
          BaseStyle->{"MoreAbout"}]], "MoreAbout",ExpressionUUID->
         "01327b8e-9bb3-480d-abce-852d788aa196"]}]}
     }]}
  }]], "MoreAboutSection",ExpressionUUID->"9b9af9b3-bd5e-4893-b0c4-\
ef6a4f21b30f"],

Cell[BoxData[GridBox[{
   {
    TemplateBox[{29},
     "Spacer1"], GridBox[{
      {
       RowBox[{
        TemplateBox[{17},
         "Spacer1"], 
        StyleBox[
         RowBox[{"Related", " ", "Links"}], "RelatedLinksSection"]}]},
      {Cell[BoxData[Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData[
             RowBox[{
               RowBox[{"Units", " ", "&"}], " ", "Quantities"}]]], 
           "paclet:guide/Units"},
          "RefLinkPlain",
          BaseStyle->{"RelatedLinks"}]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "0403d939-c2d3-4014-8ff7-776dca04190b"]], "RelatedLinks",
        ExpressionUUID->"695bd62a-3578-49a1-b4d1-a01cfdeb1114"]},
      {Cell[BoxData[Cell[BoxData[Cell[BoxData[
          RowBox[{
           TemplateBox[{16},
            "Spacer1"], "\[FilledVerySmallSquare]", 
           TemplateBox[{
             Cell[
              TextData[
               Cell[
                TextData[{
                  Cell[
                   BoxData[
                    TemplateBox[{2}, "Spacer1"]]], "ThermodynamicData"}]]]], 
             "paclet:ref/ThermodynamicData"},
            "RefLink",
            BaseStyle->{"RelatedLinks"}]}]],ExpressionUUID->
          "75b4df1b-c818-4fd9-bb00-91590715e98d"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "3dc91f77-adf2-4a88-a309-238181edda3a"]], "RelatedLinks",
        ExpressionUUID->"810978a9-67c8-40f6-aa39-256e9ddebf99"]},
      {Cell[TextData[Cell[BoxData[
        RowBox[{
         TemplateBox[{16},
          "Spacer1"], "\[FilledVerySmallSquare]", Cell[BoxData[
          TemplateBox[{
            Cell[
             TextData[
              Cell[
               TextData[{
                 Cell[
                  BoxData[
                   TemplateBox[{2}, "Spacer1"]]], 
                 "Webbook de chimie NIST"}]]]], 
            "http://webbook.nist.gov/chemistry/fluid/"},
           "WebLink",
           BaseStyle->{"RelatedLinks"}]],ExpressionUUID->
          "ecc68c94-a9b9-456e-a064-e1cc45f5251d"]}]],ExpressionUUID->
        "33c0664e-f348-49b0-ab48-c3cb5ddd7125"]], "RelatedLinks",
        ExpressionUUID->"2b6c9427-299e-4308-a712-a6b9ed652af8"]}
     }]}
  }]], "RelatedLinksSection",ExpressionUUID->"262b2d20-c0bb-45e7-90e9-\
1ab47696a9c6"],

Cell[" ", "FooterCell",ExpressionUUID->"ce804c8b-ac53-4294-a443-cbe7d38a200a"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{900, 835.8},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"RhoSatLiqNISTFromT",
TaggingRules->{
 "ModificationHighlight" -> False, "ColorType" -> "", "LinkTrails" -> "", 
  "HasOptions" -> True, "ExampleCounter" -> 1, 
  "Openers" -> {
   "PrimaryExamplesSection" -> Open, "ExampleSection" -> {"0" -> Open}, 
    "NotesSection" -> Closed}, "NewStyles" -> True, 
  "CitationPopupData" -> $Failed, "ShowCitation" -> False, "RootCaptions" -> 
  "", "Metadata" -> {
   "built" -> "{2023, 11, 30, 13, 56, 0.3854513}", 
    "history" -> {"XX", "", "", ""}, "context" -> "NewEoSArgon`", 
    "keywords" -> {}, "specialkeywords" -> {}, 
    "tutorialcollectionlinks" -> {}, "index" -> True, "label" -> 
    "New Eo S Argon Package Symbol", "language" -> "en", "paclet" -> 
    "NewEoSArgon Package", "status" -> "None", "summary" -> 
    "RhoSatLiqNISTFromT[T] \\[Congruent] \\[Rho]\\[Sigma]l (g/cm^3) Densit\
\[EAcute] du liquide sur la courbe de saturation donn\[EAcute]e par NIST en \
fonction de T (Kelvin) [Liquid density on the saturation curve given by NIST \
as a function of T (Kelvin)]", "synonyms" -> {}, "tabletags" -> {}, "title" -> 
    "RhoSatLiqNISTFromT", "titlemodifier" -> "", "metadescription" -> "", 
    "windowtitle" -> "RhoSatLiqNISTFromT", "type" -> "Symbol", "uri" -> 
    "NewEoSArgon/ref/RhoSatLiqNISTFromT"}},
CellContext->"Global`",
FrontEndVersion->"13.3 pour Microsoft Windows (64-bit) (July 24, 2023)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "13.3 pour Microsoft Windows (64-bit) (July 24, 2023)", 
  StyleDefinitions -> "Default.nb"],
ExpressionUUID->"bbe7a28e-a9e9-491b-a761-8b214b8bcfbd"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[12140, 334, 1419, 37, 35, "PrimaryExamplesSection",ExpressionUUID->"9306785c-aa7f-4884-b5b7-ab6cd4c57912",
   CellTags->"PrimaryExamplesSection",
   CellID->28051787]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 40617, 1010}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[590, 21, 5622, 135, 56, "AnchorBarGrid",ExpressionUUID->"2dee03af-50c3-401e-a880-b8a1d8883cd5",
 CellID->1],
Cell[6215, 158, 94, 0, 23, "ContextNameCell",ExpressionUUID->"c7220829-773b-4590-ae56-14bf8d0a58f9"],
Cell[CellGroupData[{
Cell[6334, 162, 561, 14, 56, "ObjectNameGrid",ExpressionUUID->"0d1e0d4a-6790-4e69-beb6-6700b99226f0"],
Cell[6898, 178, 1375, 37, 148, "Usage",ExpressionUUID->"fa74bf2b-6b13-4681-86a8-ade57e6e48b3"]
}, Open  ]],
Cell[CellGroupData[{
Cell[8310, 220, 1919, 48, 37, "NotesSection",ExpressionUUID->"88f98b58-9ee0-4914-9656-01f3545807fe",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->584727172],
Cell[10232, 270, 800, 25, 38, "Notes",ExpressionUUID->"6bda968e-af7d-4e21-8d72-2b05a76ca5d3",
 CellID->1067943069],
Cell[11035, 297, 185, 4, 36, "Notes",ExpressionUUID->"bd07f567-a7b2-4205-a0c5-3e5f1bae98af",
 CellID->185021568],
Cell[11223, 303, 790, 25, 38, "Notes",ExpressionUUID->"cb6d427a-d10f-49cb-ae02-d8bb7d69eef1",
 CellID->121367135]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "NotesSection"}, Closed]]]],
Cell[CellGroupData[{
Cell[12140, 334, 1419, 37, 35, "PrimaryExamplesSection",ExpressionUUID->"9306785c-aa7f-4884-b5b7-ab6cd4c57912",
 CellTags->"PrimaryExamplesSection",
 CellID->28051787],
Cell[CellGroupData[{
Cell[13584, 375, 1398, 36, 30, "ExampleSection",ExpressionUUID->"da9c801c-c884-41ac-9fb9-e79466cf56a5",
 CellID->159387233],
Cell[14985, 413, 174, 3, 26, "Input",ExpressionUUID->"4bf26485-5e77-4081-a96b-0384b5250f59",
 CellID->87419684],
Cell[15162, 418, 131, 1, 38, "ExampleText",ExpressionUUID->"47607793-fc19-4fb8-a669-92904e2eed05",
 CellID->285078790],
Cell[CellGroupData[{
Cell[15318, 423, 246, 6, 26, "Input",ExpressionUUID->"97015f6b-9918-4fe3-85ec-2198223bfb83",
 CellID->231987987],
Cell[15567, 431, 391, 8, 45, "Output",ExpressionUUID->"ae78b1a9-cac5-40e4-b6ce-f89fe3bd6400",
 CellID->394796393]
}, Open  ]],
Cell[CellGroupData[{
Cell[15995, 444, 873, 23, 30, "Input",ExpressionUUID->"52087bbc-79ca-4307-b80c-0e290c4c0bdf",
 CellID->474398445],
Cell[16871, 469, 389, 8, 45, "Output",ExpressionUUID->"aa5a005f-b568-43a6-88a1-bc2a81c4e44a",
 CellID->172769535]
}, Open  ]],
Cell[17275, 480, 167, 3, 38, "ExampleText",ExpressionUUID->"6c13bf70-c4c2-46b3-8dd7-570bd6f366af",
 CellID->886239600],
Cell[CellGroupData[{
Cell[17467, 487, 751, 19, 42, "Input",ExpressionUUID->"11aead64-6d13-4d49-864e-16f478b3643c",
 CellID->21488140],
Cell[18221, 508, 13984, 280, 276, "Output",ExpressionUUID->"ef738ad5-b699-42da-94d4-1fc145d31cf2",
 CellID->632687920]
}, Open  ]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"}, Closed]]]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "PrimaryExamplesSection"}, Closed]]]],
Cell[32447, 797, 2922, 79, 70, "SeeAlsoSection",ExpressionUUID->"e2556472-822e-406d-96fc-ef80125f6ffb"],
Cell[35372, 878, 729, 19, 70, "MoreAboutSection",ExpressionUUID->"9b9af9b3-bd5e-4893-b0c4-ef6a4f21b30f"],
Cell[36104, 899, 2350, 62, 70, "RelatedLinksSection",ExpressionUUID->"262b2d20-c0bb-45e7-90e9-1ab47696a9c6"],
Cell[38457, 963, 78, 0, 70, "FooterCell",ExpressionUUID->"ce804c8b-ac53-4294-a443-cbe7d38a200a"]
}
]
*)

(* End of internal cache information *)

