(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 13.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     57280,       1272]
NotebookOptionsPosition[     51668,       1157]
NotebookOutlinePosition[     54187,       1219]
CellTagsIndexPosition[     54065,       1213]
WindowTitle->RhoSatVapFromT
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[GridBox[{
   {GridBox[{
      {
       ItemBox[Cell[BoxData[
         RowBox[{
          TemplateBox[{12},
           "Spacer1"], Cell["NEW EO S ARGON PACKAGE SYMBOL", "PacletNameCell",
           TextAlignment->Center,ExpressionUUID->
           "c366a5d5-1fd9-4893-8a0d-2efd67dab536"], 
          TemplateBox[{8},
           "Spacer1"]}]],
         TextAlignment->Center,ExpressionUUID->
         "e641fe68-6a94-4855-8d39-5ff3a0568eef"],
        Background->RGBColor[0.490196, 0.576471, 0.690196],
        ItemSize->Full], ""}
     },
     GridBoxAlignment->{"Rows" -> {{Center}}},
     GridBoxItemSize->{"Columns" -> {Full, 
         Scaled[0.02]}, "Rows" -> {{2.5}}}], Cell[TextData[{
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "See Also",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "9a11bfb6-78b2-411f-9d3b-f112205e8550"]
         }],ExpressionUUID->"0270704c-6a67-4c5d-8223-b947e3e5fad2"],
         StripOnInput->False],{
        "\"rhotrgazNv\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/rhotrgazNv"], 
         "\"rhocNv\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/rhocNv"], 
         "\"RhoSatVapNISTFromT\"" :> 
         Documentation`HelpLookup[
          "paclet:NewEoSArgon/ref/RhoSatVapNISTFromT"], "\"ttr\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/ttr"], "\"tcNv\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/tcNv"]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"SeeAlso"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "a983d9a0-d9d3-42b1-9d10-4e40f5dc9c03"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "Related Guides",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "bda5a51e-8040-48f2-9b8f-291619cad8c4"]
         }],ExpressionUUID->"d748317f-4ae7-4ae5-88e0-e348772bed56"],
         StripOnInput->False],{
        "\"NewEoSArgon Package\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/guide/NewEoSArgon"]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"MoreAbout"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "d1f1ea4e-e5e5-486b-9835-b36fb3175942"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "URL",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "33ce0c05-8503-4263-bff5-f0df41421c90"]
         }],ExpressionUUID->"f3a68102-b079-43e2-ac53-1b67da1935c1"],
         StripOnInput->False],{
        "\"NewEoSArgon/ref/RhoSatVapFromT\"" :> None, 
         "\"Copy Wolfram Documentation Center URL\"" :> 
         Module[{DocumentationSearch`Private`nb$}, 
           DocumentationSearch`Private`nb$ = 
            NotebookPut[
             Notebook[{Cell["NewEoSArgon/ref/RhoSatVapFromT"]}, Visible -> 
               False]]; 
           SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
           FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
           NotebookClose[DocumentationSearch`Private`nb$]; Null], Delimiter, 
         "\"Copy web URL\"" :> 
         Module[{DocumentationSearch`Private`nb$}, 
           DocumentationSearch`Private`nb$ = 
            NotebookPut[
             Notebook[{
               Cell[BoxData[
                 MakeBoxes[
                  Hyperlink[
                   "http://reference.wolfram.com/language/NewEoSArgon/ref/\
RhoSatVapFromT.html"], StandardForm]], "Input", TextClipboardType -> 
                 "PlainText"]}, Visible -> False]]; 
           SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
           FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
           NotebookClose[DocumentationSearch`Private`nb$]; Null], 
         "\"Go to web URL\"" :> 
         FrontEndExecute[{
           NotebookLocate[{
             URL[If[TrueQ[DocumentationBuild`Make`Private`wsmlinkQ$25853], 
                 "http://reference.wolfram.com/system-modeler/", 
                 "http://reference.wolfram.com/language/"] <> 
               "NewEoSArgon/ref/RhoSatVapFromT" <> ".html"], None}]}]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"URLMenu"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "ad622c7e-ecd0-4a0f-b6df-b7be5abdf8e0"]
    }], "AnchorBar",
     CacheGraphics->False,ExpressionUUID->
     "1d6a83f8-7015-4375-9b19-a3fb64da3079"]}
  }]], "AnchorBarGrid",
 CellID->1,ExpressionUUID->"302ad69b-81cd-42a1-9747-c1335b0f7b4a"],

Cell["NewEoSArgon`", "ContextNameCell",ExpressionUUID->"2737f925-2164-4c3c-a090-97fa27816986"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     Cell[
     "RhoSatVapFromT", "ObjectName",ExpressionUUID->
      "2c001fbd-5285-43e0-a869-97d065f02e6f"],
     Cell[BoxData[
      TemplateBox[{8},
       "Spacer1"]],ExpressionUUID->"d67ea85d-ba44-425f-876b-959921c10850"],
     Cell[BoxData[
     ""], "ObjectNameTranslation",ExpressionUUID->
      "853e12e8-bd13-459b-9c95-f05956b2a43a"]
    }],ExpressionUUID->"eaafd192-21f8-4133-b119-1171c883bd50"], 
    "\[SpanFromLeft]"}
  }]], "ObjectNameGrid",ExpressionUUID->"94b140fa-0d12-41df-985c-\
55aa6fb53b0e"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     "RhoSatVapFromT[",
     StyleBox["T",
      FontSlant->"Italic"],
     "] \[Congruent] ",
     Cell[BoxData[
      SubscriptBox["\[Rho]", "\[Sigma]v"]], "InlineFormula",
      FontFamily->"Source Sans Pro",ExpressionUUID->
      "facdee95-440d-4927-b751-88f758753a2b"],
     " (g/",
     Cell[BoxData[
      SuperscriptBox["cm", "3"]], "InlineFormula",
      FontFamily->"Source Sans Pro",ExpressionUUID->
      "d26fd277-b5fe-4c8b-b5bb-95a139da3444"],
     ")\nDensit\[EAcute] du ",
     StyleBox["gaz",
      FontSlant->"Italic"],
     " sur la courbe de saturation en fonction de ",
     StyleBox["T",
      FontSlant->"Italic"],
     " (Kelvin)\n[",
     StyleBox["Gas",
      FontSlant->"Italic"],
     " density on the saturation curve as a function of ",
     StyleBox["T",
      FontSlant->"Italic"],
     " (Kelvin)]"
    }],ExpressionUUID->"19ed4c40-55f1-4427-a121-55c10ca812a3"]}
  }]], "Usage",ExpressionUUID->"4f9ea030-0082-4d85-8f91-4224a0cd4787"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[Cell[TextData[{
   Cell[BoxData[
    DynamicBox[ToBoxes[
      If[
       MatchQ[
        CurrentValue[
         EvaluationNotebook[], {TaggingRules, "Openers", "NotesSection"}, 
         Closed], 
        Alternatives[Open, True]], 
       Style[
        Graphics[{
          Thickness[0.18], 
          RGBColor[0.8509803921568627, 0.396078431372549, 0], 
          Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
         PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
        0.68 Inherited], 
       Rotate[
        Style[
         Graphics[{
           Thickness[0.18], 
           RGBColor[0.8509803921568627, 0.396078431372549, 0], 
           Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
          PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
         0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
     ImageSizeCache->{
      13.600000000000001`, {0.5800000000000001, 13.020000000000001`}}]],
    ExpressionUUID->"248b88a5-a4c8-4520-bf1b-86e0c1159c30"],
   Cell[BoxData[
    TemplateBox[{1},
     "Spacer1"]],ExpressionUUID->"9007a6e6-40a1-44c8-8ee5-ac9e0bef22a9"],
   "Details and Options"
  }], "NotesFrameText",ExpressionUUID->"d8371a6f-ac46-4968-8a4d-83f515d8a993"],
  Appearance->{Automatic, None, "Normal", Automatic},
  BaseStyle->None,
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"], 
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], After, CellContents]}]& ),
  Evaluator->None,
  Method->
   "Preemptive"]],ExpressionUUID->"73904d47-f1ca-4ae6-b531-fbd41969dec6"]], \
"NotesSection",
 WholeCellGroupOpener->True,
 CellGroupingRules->{"SectionGrouping", 50},
 CacheGraphics->False,
 CellID->367976580,ExpressionUUID->"0034fc39-ab18-461e-a795-7dc7c2ce01ce"],

Cell[TextData[{
 "La fonction est d\[EAcute]finie pour ",
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["ttr"]], "paclet:NewEoSArgon/ref/ttr", 
    "NewEoSArgon Package Symbol"},
   "PackageLink",
   BaseStyle->"InlineFormula"]], "InlineFormula",
  FontFamily->"Source Sans Pro",ExpressionUUID->
  "f1b8ec50-4d14-45ba-9273-e84456e3e71a"],
 " \[LessEqual] ",
 StyleBox["T",
  FontSlant->"Italic"],
 " \[LessEqual] ",
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["tc"]], "paclet:NewEoSArgon/ref/tc", 
    "NewEoSArgon Package Symbol"},
   "PackageLink",
   BaseStyle->"InlineFormula"]], "InlineFormula",
  FontFamily->"Source Sans Pro",ExpressionUUID->
  "fb3f91cc-2cb9-482a-8509-d88979630556"]
}], "Notes",
 CellID->1067943069,ExpressionUUID->"82635f11-e0db-4ad2-b0ad-b5ea71137ea6"],

Cell["\<\
******************************************************************************\
*****\
\>", "Notes",
 CellID->185021568,ExpressionUUID->"89709649-f998-4cc8-8495-d038328dc0cd"],

Cell[TextData[{
 "The function is defined for ",
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["ttr"]], "paclet:NewEoSArgon/ref/ttr", 
    "NewEoSArgon Package Symbol"},
   "PackageLink",
   BaseStyle->"InlineFormula"]], "InlineFormula",
  FontFamily->"Source Sans Pro",ExpressionUUID->
  "0c418d5a-1df0-4dd4-a0e9-8ce9bf6bff6a"],
 " \[LessEqual] ",
 StyleBox["T",
  FontSlant->"Italic"],
 " \[LessEqual] ",
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["tc"]], "paclet:NewEoSArgon/ref/tc", 
    "NewEoSArgon Package Symbol"},
   "PackageLink",
   BaseStyle->"InlineFormula"]], "InlineFormula",
  FontFamily->"Source Sans Pro",ExpressionUUID->
  "1ea037a5-2ddd-4aee-bd81-a149c9917662"]
}], "Notes",
 CellID->121367135,ExpressionUUID->"4e31b463-0a22-4428-8817-3d3d6334f385"]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "NotesSection"}, Closed]]]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {
       TaggingRules, "Openers", "PrimaryExamplesSection"}, Open], 
      Alternatives[True, Open]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{13.600000000000001`, {5., 8.600000000000001}}]],
  ExpressionUUID->"06ee8d80-aadd-48db-bf44-ab3ad1b7d8d6"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"a37b72ef-2903-4004-897e-49286d55ce73"],
 "Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "598f3587-56c1-45a6-a034-ffd8b16b089b"]
}], "PrimaryExamplesSection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellTags->"PrimaryExamplesSection",
 CellID->106574866,ExpressionUUID->"3db9c805-b46e-4c26-8d36-af5ac4d5cebc"],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"},
        Closed], 
      Alternatives[Open, True]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{13.600000000000001`, {5., 8.600000000000001}}]],
  ExpressionUUID->"a5045892-97e8-4d77-9349-eb528646c365"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"140d9fd5-62f6-4ab0-a959-0154d1fbb445"],
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "af24c688-8d71-433e-b12a-d5a424d7ef1d"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellID->203395766,ExpressionUUID->"865e5a9f-70a6-4af5-940a-591fa2c241d3"],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<NewEoSArgon`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->87419684,ExpressionUUID->"948706f6-c01e-495e-b512-1552452a13a6"],

Cell["Calculate with physical dimension", "ExampleText",
 CellID->285078790,ExpressionUUID->"18d4cb1b-0175-4b05-9f4b-7c2749785541"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Quantity", "[", 
  RowBox[{
   RowBox[{"RhoSatVapFromT", "[", "ttr", "]"}], ",", "\"\<g/cm^3\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->231987987,ExpressionUUID->"9e6e422c-9eaa-4698-a6eb-03fd6afb04c3"],

Cell[BoxData[
 TemplateBox[{"0.004059119154294162`", 
   RowBox[{"\"g\"", "\[InvisibleSpace]", "\"/\"", "\[InvisibleSpace]", 
     SuperscriptBox["\"cm\"", "3"]}], "grams per centimeter cubed", 
   FractionBox["\"Grams\"", 
    SuperscriptBox["\"Centimeters\"", "3"]]},
  "Quantity"]], "Output",
 CellLabel->"Out[2]=",
 CellID->845188930,ExpressionUUID->"6261082a-fcbe-4d82-ae9f-c8f28767bcc3"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UnitConvert", "[", 
  RowBox[{
   TemplateBox[{"0.004059119154294162`"},
    "QuantityUnit",
    DisplayFunction->(TooltipBox[
      StyleBox[
       RowBox[{#, "\[InvisibleSpace]", 
         StyleBox[
          RowBox[{" ", 
            
            RowBox[{"\"g\"", "\[InvisibleSpace]", "\"/\"", 
              "\[InvisibleSpace]", 
              SuperscriptBox["\"cm\"", "3"]}]}], 
          "QuantityUnitTraditionalLabel"]}], ShowStringCharacters -> False], 
      "Unit: grams per centimeter cubed"]& ),
    InterpretationFunction->(RowBox[{"Quantity", "[", 
       RowBox[{#, ",", 
         FractionBox["\"Grams\"", 
          SuperscriptBox["\"Centimeters\"", "3"]]}], "]"}]& )], ",", 
   "\"\<kg/m^3\>\""}], "]"}]], "Input",
 NumberMarks->False,
 CellLabel->"In[3]:=",
 CellID->775882632,ExpressionUUID->"ec510aa7-89b0-4755-b481-11bd650ee974"],

Cell[BoxData[
 TemplateBox[{"4.059119154294161`", 
   RowBox[{"\"kg\"", "\[InvisibleSpace]", "\"/\"", "\[InvisibleSpace]", 
     SuperscriptBox["\"m\"", "3"]}], "kilograms per meter cubed", 
   FractionBox["\"Kilograms\"", 
    SuperscriptBox["\"Meters\"", "3"]]},
  "Quantity"]], "Output",
 CellLabel->"Out[3]=",
 CellID->578784612,ExpressionUUID->"753da312-f889-48a4-a60c-53e7a039409b"]
}, Open  ]],

Cell["\<\
Plot function versus temperature and comparison with saturated curve from NIST\
\>", "ExampleText",
 CellID->886239600,ExpressionUUID->"2112a483-f76b-459e-9189-6623f13bab47"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"FigSat", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"RhoSatVapFromT", "[", "T", "]"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"T", ",", "ttr", ",", "tcNv"}], "}"}], ",", 
     RowBox[{"AxesOrigin", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"ttr", ",", "\[Rho]c"}], "}"}]}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", "Red", "}"}]}], ",", 
     RowBox[{"Frame", "->", "True"}], ",", 
     RowBox[{"FrameLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Quantity", "[", 
         RowBox[{"T", ",", "\"\<Kelvins\>\""}], "]"}], ",", 
        RowBox[{"Quantity", "[", 
         RowBox[{"\[Rho]", ",", "\"\<g/cm^3\>\""}], "]"}]}], "}"}]}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "350"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"FigSatNist", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"RhoSatVapNISTFromT", "[", "T", "]"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"T", ",", "ttr", ",", "tc"}], "}"}], ",", 
     RowBox[{"AxesOrigin", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"ttr", ",", "\[Rho]c"}], "}"}]}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"Dashed", ",", "Black"}], "}"}], "}"}]}], ",", 
     RowBox[{"Frame", "->", "True"}], ",", 
     RowBox[{"FrameLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Quantity", "[", 
         RowBox[{"T", ",", "\"\<Kelvins\>\""}], "]"}], ",", 
        RowBox[{"Quantity", "[", 
         RowBox[{"\[Rho]", ",", "\"\<g/cm^3\>\""}], "]"}]}], "}"}]}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "350"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Legended", "[", 
  RowBox[{
   RowBox[{"Show", "[", 
    RowBox[{"{", 
     RowBox[{"FigSat", ",", "FigSatNist"}], "}"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Placed", "[", 
      RowBox[{
       RowBox[{"LineLegend", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"Directive", "[", 
           RowBox[{"Black", ",", "Dashed"}], "]"}], "}"}], ",", 
         RowBox[{"{", "\"\<RhoSatVapNISTFromT[T]\>\"", "}"}]}], "]"}], ",", 
       "Below"}], "]"}], ",", 
     RowBox[{"Placed", "[", 
      RowBox[{
       RowBox[{"LineLegend", "[", 
        RowBox[{
         RowBox[{"{", "Red", "}"}], ",", 
         RowBox[{"{", "\"\<RhoSatVapFromT[T]\>\"", "}"}]}], "]"}], ",", 
       "Below"}], "]"}]}], "}"}]}], "]"}]}], "Input",
 CellLabel->"In[4]:=",
 CellID->21488140,ExpressionUUID->"13b184f8-5563-46d5-b558-64d8286f8c2a"],

Cell[BoxData[
 GraphicsBox[
  TagBox[RasterBox[CompressedData["
1:eJzt3X9sHOd94P+RvLYZm7YpW74yPtlgLjyYcXUOjcoNLyBiJlAqpSV6qquc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    "], {{0, 258.}, {350., 0}}, {0, 255},
    ColorFunction->RGBColor,
    ImageResolution->{144., 144.},
    SmoothingQuality->"High"],
   BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
   Selectable->False],
  DefaultBaseStyle->"ImageGraphics",
  ImageSize->Automatic,
  ImageSizeRaw->{350., 258.},
  PlotRange->{{0, 350.}, {0, 258.}}]], "Output",
 CellTags->"RasterizedOutput",
 CellLabel->"Out[4]=",
 CellID->530850865,ExpressionUUID->"746a3389-be1a-4175-9f0b-ea642ee8208d"]
}, Open  ]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"}, 
  Closed]]]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "PrimaryExamplesSection"}, 
  Closed]]]],

Cell[BoxData[GridBox[{
   {
    DynamicBox[FEPrivate`ImportImage[
      FrontEnd`FileName[{"Documentation", "FooterIcons"}, 
       "RelatedFunction.png"]],
     ImageSizeCache->{50., {27., 33.}}], GridBox[{
      {
       StyleBox[
        RowBox[{"See", " ", "Also"}], "SeeAlsoSection"]},
      {Cell[TextData[{
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["rhotrgazNv"]], "paclet:NewEoSArgon/ref/rhotrgazNv", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "679193eb-7334-453d-a534-e3bfbbb22d5b"],
        "\[NonBreakingSpace]",
        StyleBox[
        "\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
         "InlineSeparator"],
        " ",
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["rhocNv"]], "paclet:NewEoSArgon/ref/rhocNv", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "37ba01a7-88a6-40d4-bcfa-d6ec75f3af45"],
        "\[NonBreakingSpace]",
        StyleBox[
        "\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
         "InlineSeparator"],
        " ",
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["RhoSatVapNISTFromT"]], 
           "paclet:NewEoSArgon/ref/RhoSatVapNISTFromT", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "deff673b-c5f7-4c5b-ab7f-31306d0246ff"],
        "\[NonBreakingSpace]",
        StyleBox[
        "\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
         "InlineSeparator"],
        " ",
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["ttr"]], "paclet:NewEoSArgon/ref/ttr", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "3f91bf55-4423-4abe-b06c-b90270b99f48"],
        "\[NonBreakingSpace]",
        StyleBox[
        "\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
         "InlineSeparator"],
        " ",
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["tcNv"]], "paclet:NewEoSArgon/ref/tcNv", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "619d270d-d67b-47bf-b84b-845908c291f9"]
       }], "SeeAlso",ExpressionUUID->"3b68297f-4f8b-482e-a8b4-74d1fdb1bb7e"]}
     }]}
  }]], "SeeAlsoSection",ExpressionUUID->"a6849d50-64fb-42a4-9e96-\
d5fe4c56cf5c"],

Cell[BoxData[GridBox[{
   {
    DynamicBox[FEPrivate`ImportImage[
      FrontEnd`FileName[{"Documentation", "FooterIcons"}, "RelatedGuide.png"]],
     ImageSizeCache->{50., {27., 33.}}], GridBox[{
      {
       StyleBox[
        RowBox[{"Related", " ", "Guides"}], "MoreAboutSection"]},
      {
       RowBox[{"\[FilledVerySmallSquare]", Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["NewEoSArgon Package"]], 
           "paclet:NewEoSArgon/guide/NewEoSArgon"},
          "RefLinkPlain",
          BaseStyle->{"MoreAbout"}]], "MoreAbout",ExpressionUUID->
         "289419dd-7108-4472-ae24-068ff983fb8d"]}]}
     }]}
  }]], "MoreAboutSection",ExpressionUUID->"78bffa71-c24a-4049-bbee-\
cf6641b8446f"],

Cell[BoxData[GridBox[{
   {
    TemplateBox[{29},
     "Spacer1"], GridBox[{
      {
       RowBox[{
        TemplateBox[{17},
         "Spacer1"], 
        StyleBox[
         RowBox[{"Related", " ", "Links"}], "RelatedLinksSection"]}]},
      {Cell[BoxData[Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData[
             RowBox[{
               RowBox[{"Units", " ", "&"}], " ", "Quantities"}]]], 
           "paclet:guide/Units"},
          "RefLinkPlain",
          BaseStyle->{"RelatedLinks"}]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "e9a7ff75-4e32-4fae-bf4e-35add6346dc0"]], "RelatedLinks",
        ExpressionUUID->"5f7007d9-6e26-4eaa-82db-a3772d3c1976"]},
      {Cell[BoxData[Cell[BoxData[Cell[BoxData[
          RowBox[{
           TemplateBox[{16},
            "Spacer1"], "\[FilledVerySmallSquare]", 
           TemplateBox[{
             Cell[
              TextData[
               Cell[
                TextData[{
                  Cell[
                   BoxData[
                    TemplateBox[{2}, "Spacer1"]]], "ThermodynamicData"}]]]], 
             "paclet:ref/ThermodynamicData"},
            "RefLink",
            BaseStyle->{"RelatedLinks"}]}]],ExpressionUUID->
          "fb293fbb-b724-4543-b990-b2260a500dd8"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "1784caa0-6d18-4bdf-a614-4d747c083f3b"]], "RelatedLinks",
        ExpressionUUID->"d3d09296-b67a-4a75-90a8-3cfaba6cf9f6"]},
      {Cell[TextData[Cell[BoxData[
        RowBox[{
         TemplateBox[{16},
          "Spacer1"], "\[FilledVerySmallSquare]", Cell[BoxData[
          TemplateBox[{
            Cell[
             TextData[
              Cell[
               TextData[{
                 Cell[
                  BoxData[
                   TemplateBox[{2}, "Spacer1"]]], 
                 "Webbook de chimie NIST"}]]]], 
            "http://webbook.nist.gov/chemistry/fluid/"},
           "WebLink",
           BaseStyle->{"RelatedLinks"}]],ExpressionUUID->
          "c0e3cc41-eb7d-4c95-b44b-291a4a63e65e"]}]],ExpressionUUID->
        "396288bd-4c11-4e60-921e-9f0a42c83433"]], "RelatedLinks",
        ExpressionUUID->"3768981f-7849-4e46-8c8c-5e7629521abf"]}
     }]}
  }]], "RelatedLinksSection",ExpressionUUID->"71df7465-80fd-4ddc-baf0-\
058d8a5689ff"],

Cell[" ", "FooterCell",ExpressionUUID->"afdcc91e-3a53-4f1c-ac67-3c28da81aed0"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{900, 835.8},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"RhoSatVapFromT",
TaggingRules->{
 "ModificationHighlight" -> False, "ColorType" -> "", "LinkTrails" -> "", 
  "HasOptions" -> True, "ExampleCounter" -> 1, 
  "Openers" -> {
   "PrimaryExamplesSection" -> Open, "ExampleSection" -> {"0" -> Open}, 
    "NotesSection" -> Closed}, "NewStyles" -> True, 
  "CitationPopupData" -> $Failed, "ShowCitation" -> False, "RootCaptions" -> 
  "", "Metadata" -> {
   "built" -> "{2023, 11, 30, 13, 56, 1.3061202}", 
    "history" -> {"XX", "", "", ""}, "context" -> "NewEoSArgon`", 
    "keywords" -> {}, "specialkeywords" -> {}, 
    "tutorialcollectionlinks" -> {}, "index" -> True, "label" -> 
    "New Eo S Argon Package Symbol", "language" -> "en", "paclet" -> 
    "NewEoSArgon Package", "status" -> "None", "summary" -> 
    "RhoSatVapFromT[T] \\[Congruent] \\[Rho]\\[Sigma]v (g/cm^3) Densit\
\[EAcute] du gaz sur la courbe de saturation en fonction de T (Kelvin) [Gas \
density on the saturation curve as a function of T (Kelvin)]", 
    "synonyms" -> {}, "tabletags" -> {}, "title" -> "RhoSatVapFromT", 
    "titlemodifier" -> "", "metadescription" -> "", "windowtitle" -> 
    "RhoSatVapFromT", "type" -> "Symbol", "uri" -> 
    "NewEoSArgon/ref/RhoSatVapFromT"}},
CellContext->"Global`",
FrontEndVersion->"13.3 pour Microsoft Windows (64-bit) (July 24, 2023)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "13.3 pour Microsoft Windows (64-bit) (July 24, 2023)", 
  StyleDefinitions -> "Default.nb"],
ExpressionUUID->"7c3867ce-c25d-4a90-9cee-b8276b447546"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[11766, 326, 1420, 37, 35, "PrimaryExamplesSection",ExpressionUUID->"3db9c805-b46e-4c26-8d36-af5ac4d5cebc",
   CellTags->"PrimaryExamplesSection",
   CellID->106574866]},
 "RasterizedOutput"->{
  Cell[19745, 554, 25577, 426, 279, "Output",ExpressionUUID->"746a3389-be1a-4175-9f0b-ea642ee8208d",
   CellTags->"RasterizedOutput",
   CellID->530850865]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 53684, 1202},
 {"RasterizedOutput", 53884, 1206}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[586, 21, 5618, 135, 56, "AnchorBarGrid",ExpressionUUID->"302ad69b-81cd-42a1-9747-c1335b0f7b4a",
 CellID->1],
Cell[6207, 158, 94, 0, 23, "ContextNameCell",ExpressionUUID->"2737f925-2164-4c3c-a090-97fa27816986"],
Cell[CellGroupData[{
Cell[6326, 162, 557, 14, 56, "ObjectNameGrid",ExpressionUUID->"94b140fa-0d12-41df-985c-55aa6fb53b0e"],
Cell[6886, 178, 1013, 29, 146, "Usage",ExpressionUUID->"4f9ea030-0082-4d85-8f91-4224a0cd4787"]
}, Open  ]],
Cell[CellGroupData[{
Cell[7936, 212, 1919, 48, 37, "NotesSection",ExpressionUUID->"0034fc39-ab18-461e-a795-7dc7c2ce01ce",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->367976580],
Cell[9858, 262, 800, 25, 38, "Notes",ExpressionUUID->"82635f11-e0db-4ad2-b0ad-b5ea71137ea6",
 CellID->1067943069],
Cell[10661, 289, 185, 4, 36, "Notes",ExpressionUUID->"89709649-f998-4cc8-8495-d038328dc0cd",
 CellID->185021568],
Cell[10849, 295, 790, 25, 38, "Notes",ExpressionUUID->"4e31b463-0a22-4428-8817-3d3d6334f385",
 CellID->121367135]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "NotesSection"}, Closed]]]],
Cell[CellGroupData[{
Cell[11766, 326, 1420, 37, 35, "PrimaryExamplesSection",ExpressionUUID->"3db9c805-b46e-4c26-8d36-af5ac4d5cebc",
 CellTags->"PrimaryExamplesSection",
 CellID->106574866],
Cell[CellGroupData[{
Cell[13211, 367, 1398, 36, 30, "ExampleSection",ExpressionUUID->"865e5a9f-70a6-4af5-940a-591fa2c241d3",
 CellID->203395766],
Cell[14612, 405, 174, 3, 26, "Input",ExpressionUUID->"948706f6-c01e-495e-b512-1552452a13a6",
 CellID->87419684],
Cell[14789, 410, 131, 1, 38, "ExampleText",ExpressionUUID->"18d4cb1b-0175-4b05-9f4b-7c2749785541",
 CellID->285078790],
Cell[CellGroupData[{
Cell[14945, 415, 242, 6, 26, "Input",ExpressionUUID->"9e6e422c-9eaa-4698-a6eb-03fd6afb04c3",
 CellID->231987987],
Cell[15190, 423, 393, 8, 45, "Output",ExpressionUUID->"6261082a-fcbe-4d82-ae9f-c8f28767bcc3",
 CellID->845188930]
}, Open  ]],
Cell[CellGroupData[{
Cell[15620, 436, 875, 23, 30, "Input",ExpressionUUID->"ec510aa7-89b0-4755-b481-11bd650ee974",
 CellID->775882632],
Cell[16498, 461, 388, 8, 45, "Output",ExpressionUUID->"753da312-f889-48a4-a60c-53e7a039409b",
 CellID->578784612]
}, Open  ]],
Cell[16901, 472, 184, 3, 38, "ExampleText",ExpressionUUID->"2112a483-f76b-459e-9189-6623f13bab47",
 CellID->886239600],
Cell[CellGroupData[{
Cell[17110, 479, 2632, 73, 118, "Input",ExpressionUUID->"13b184f8-5563-46d5-b558-64d8286f8c2a",
 CellID->21488140],
Cell[19745, 554, 25577, 426, 279, "Output",ExpressionUUID->"746a3389-be1a-4175-9f0b-ea642ee8208d",
 CellTags->"RasterizedOutput",
 CellID->530850865]
}, Open  ]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"}, Closed]]]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "PrimaryExamplesSection"}, Closed]]]],
Cell[45564, 989, 2934, 79, 70, "SeeAlsoSection",ExpressionUUID->"a6849d50-64fb-42a4-9e96-d5fe4c56cf5c"],
Cell[48501, 1070, 729, 19, 70, "MoreAboutSection",ExpressionUUID->"78bffa71-c24a-4049-bbee-cf6641b8446f"],
Cell[49233, 1091, 2350, 62, 70, "RelatedLinksSection",ExpressionUUID->"71df7465-80fd-4ddc-baf0-058d8a5689ff"],
Cell[51586, 1155, 78, 0, 70, "FooterCell",ExpressionUUID->"afdcc91e-3a53-4f1c-ac67-3c28da81aed0"]
}
]
*)

(* End of internal cache information *)

