(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 13.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     44659,       1085]
NotebookOptionsPosition[     39246,        976]
NotebookOutlinePosition[     41603,       1033]
CellTagsIndexPosition[     41517,       1028]
WindowTitle->RhoSatVapNISTFromT
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[GridBox[{
   {GridBox[{
      {
       ItemBox[Cell[BoxData[
         RowBox[{
          TemplateBox[{12},
           "Spacer1"], Cell["NEW EO S ARGON PACKAGE SYMBOL", "PacletNameCell",
           TextAlignment->Center,ExpressionUUID->
           "2046911c-34b0-4aac-ac82-5e16620f3eff"], 
          TemplateBox[{8},
           "Spacer1"]}]],
         TextAlignment->Center,ExpressionUUID->
         "2adebc80-0d28-48c9-8a21-2e17474cb2d2"],
        Background->RGBColor[0.490196, 0.576471, 0.690196],
        ItemSize->Full], ""}
     },
     GridBoxAlignment->{"Rows" -> {{Center}}},
     GridBoxItemSize->{"Columns" -> {Full, 
         Scaled[0.02]}, "Rows" -> {{2.5}}}], Cell[TextData[{
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "See Also",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "f3089f09-cdaf-488d-a772-daee0ee9b734"]
         }],ExpressionUUID->"1a557660-9551-48d1-9d87-9b089aa7038d"],
         StripOnInput->False],{
        "\"rhotrgaz\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/rhotrgaz"], 
         "\"rhoc\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/rhoc"], "\"ttr\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/ttr"], "\"tc\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/tc"], 
         "\"RhoSatLiqNISTFromT\"" :> 
         Documentation`HelpLookup[
          "paclet:NewEoSArgon/ref/RhoSatLiqNISTFromT"]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"SeeAlso"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "6c1afcb4-899c-4c60-87d8-cccd5f56cafb"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "Related Guides",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "290d2fea-2a52-4b66-a19f-3f3e07bf5db7"]
         }],ExpressionUUID->"5e589d8d-a194-4386-8ddb-bbae6769b477"],
         StripOnInput->False],{
        "\"NewEoSArgon Package\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/guide/NewEoSArgon"]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"MoreAbout"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "7a4b45c3-44b8-43b0-899d-a5d6015a41f4"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "URL",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "02cfec90-b3a6-4b36-9cb9-b94da7baed9b"]
         }],ExpressionUUID->"8005e2a2-21d2-4ee3-a1de-4a2f37d00335"],
         StripOnInput->False],{
        "\"NewEoSArgon/ref/RhoSatVapNISTFromT\"" :> None, 
         "\"Copy Wolfram Documentation Center URL\"" :> 
         Module[{DocumentationSearch`Private`nb$}, 
           DocumentationSearch`Private`nb$ = 
            NotebookPut[
             Notebook[{Cell["NewEoSArgon/ref/RhoSatVapNISTFromT"]}, Visible -> 
               False]]; 
           SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
           FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
           NotebookClose[DocumentationSearch`Private`nb$]; Null], Delimiter, 
         "\"Copy web URL\"" :> 
         Module[{DocumentationSearch`Private`nb$}, 
           DocumentationSearch`Private`nb$ = 
            NotebookPut[
             Notebook[{
               Cell[BoxData[
                 MakeBoxes[
                  Hyperlink[
                   "http://reference.wolfram.com/language/NewEoSArgon/ref/\
RhoSatVapNISTFromT.html"], StandardForm]], "Input", TextClipboardType -> 
                 "PlainText"]}, Visible -> False]]; 
           SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
           FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
           NotebookClose[DocumentationSearch`Private`nb$]; Null], 
         "\"Go to web URL\"" :> 
         FrontEndExecute[{
           NotebookLocate[{
             URL[If[TrueQ[DocumentationBuild`Make`Private`wsmlinkQ$26379], 
                 "http://reference.wolfram.com/system-modeler/", 
                 "http://reference.wolfram.com/language/"] <> 
               "NewEoSArgon/ref/RhoSatVapNISTFromT" <> ".html"], None}]}]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"URLMenu"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "c5cd7af2-ece5-423d-81dd-506ca34f4b03"]
    }], "AnchorBar",
     CacheGraphics->False,ExpressionUUID->
     "50be56f3-03d9-404e-aaf9-d163a2ed3d1e"]}
  }]], "AnchorBarGrid",
 CellID->1,ExpressionUUID->"eca46315-36c5-4f82-84a9-1879f277d21f"],

Cell["NewEoSArgon`", "ContextNameCell",ExpressionUUID->"3fb80573-9dcb-4d73-b595-0d82c68e35f3"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     Cell[
     "RhoSatVapNISTFromT", "ObjectName",ExpressionUUID->
      "b7cb1e94-5537-493a-a3f5-75c8e0ee78fe"],
     Cell[BoxData[
      TemplateBox[{8},
       "Spacer1"]],ExpressionUUID->"0212a9e9-3543-4aac-acb8-50b7d155133e"],
     Cell[BoxData[
     ""], "ObjectNameTranslation",ExpressionUUID->
      "957fba39-c72a-46ee-892e-63ebf1c20462"]
    }],ExpressionUUID->"6c8e05e0-2215-4d61-a6c9-020079469f3b"], 
    "\[SpanFromLeft]"}
  }]], "ObjectNameGrid",ExpressionUUID->"b0f0121b-cf3a-43ca-a5ac-\
17fa73aece85"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     "RhoSatVapNISTFromT[",
     StyleBox["T",
      FontSlant->"Italic"],
     "] \[Congruent]",
     StyleBox[" ",
      FontSlant->"Italic"],
     Cell[BoxData[
      SubscriptBox["\[Rho]", "\[Sigma]v"]], "InlineFormula",
      FontFamily->"Source Sans Pro",ExpressionUUID->
      "37f556f2-8713-42b2-be96-7bcc57182cb0"],
     StyleBox[" ",
      FontSlant->"Italic"],
     "(g/",
     Cell[BoxData[
      SuperscriptBox["cm", "3"]], "InlineFormula",
      FontFamily->"Source Sans Pro",ExpressionUUID->
      "622200a8-b56c-4c29-ae15-b8a47d4ba3c5"],
     ")\nDensit\[EAcute] du ",
     StyleBox["gaz",
      FontSlant->"Italic"],
     " sur la courbe de saturation donn\[EAcute]e par NIST en fonction de ",
     StyleBox["T",
      FontSlant->"Italic"],
     " (Kelvin)\n[",
     StyleBox["Gas",
      FontSlant->"Italic"],
     " density on the saturation curve given by NIST as a function of ",
     StyleBox["T",
      FontSlant->"Italic"],
     " (Kelvin)]"
    }],ExpressionUUID->"9ac983c0-3960-4e9c-bc2f-c1a0b04917a5"]}
  }]], "Usage",ExpressionUUID->"64438c9f-8632-47e1-8446-a8f8331e11a8"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[Cell[TextData[{
   Cell[BoxData[
    DynamicBox[ToBoxes[
      If[
       MatchQ[
        CurrentValue[
         EvaluationNotebook[], {TaggingRules, "Openers", "NotesSection"}, 
         Closed], 
        Alternatives[Open, True]], 
       Style[
        Graphics[{
          Thickness[0.18], 
          RGBColor[0.8509803921568627, 0.396078431372549, 0], 
          Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
         PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
        0.68 Inherited], 
       Rotate[
        Style[
         Graphics[{
           Thickness[0.18], 
           RGBColor[0.8509803921568627, 0.396078431372549, 0], 
           Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
          PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
         0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
     ImageSizeCache->{
      13.600000000000001`, {0.5800000000000001, 13.020000000000001`}}]],
    ExpressionUUID->"1d44ba5a-770e-4de5-a577-ef102d6eda36"],
   Cell[BoxData[
    TemplateBox[{1},
     "Spacer1"]],ExpressionUUID->"07d48770-b1d3-43c0-b098-407394f3dea4"],
   "Details and Options"
  }], "NotesFrameText",ExpressionUUID->"fb99ce4a-733c-4608-b670-eaf75ebf0698"],
  Appearance->{Automatic, None, "Normal", Automatic},
  BaseStyle->None,
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"], 
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], After, CellContents]}]& ),
  Evaluator->None,
  Method->
   "Preemptive"]],ExpressionUUID->"6e865198-1bf7-4cf4-9220-83faa7fe8396"]], \
"NotesSection",
 WholeCellGroupOpener->True,
 CellGroupingRules->{"SectionGrouping", 50},
 CacheGraphics->False,
 CellID->483489053,ExpressionUUID->"cb549ba6-0ef5-4529-9f10-e048c55031ea"],

Cell[TextData[{
 "La fonction est d\[EAcute]finie pour ",
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["ttr"]], "paclet:NewEoSArgon/ref/ttr", 
    "NewEoSArgon Package Symbol"},
   "PackageLink",
   BaseStyle->"InlineFormula"]], "InlineFormula",
  FontFamily->"Source Sans Pro",ExpressionUUID->
  "0bed2fc1-c785-4b61-b662-0707b73fedf9"],
 " \[LessEqual] ",
 StyleBox["T",
  FontSlant->"Italic"],
 " \[LessEqual] ",
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["tc"]], "paclet:NewEoSArgon/ref/tc", 
    "NewEoSArgon Package Symbol"},
   "PackageLink",
   BaseStyle->"InlineFormula"]], "InlineFormula",
  FontFamily->"Source Sans Pro",ExpressionUUID->
  "e30fe849-e1f9-4c5e-bbca-3e47bbaa9129"]
}], "Notes",
 CellID->1067943069,ExpressionUUID->"ed71064b-26a3-4594-9eda-e6f719277826"],

Cell["\<\
******************************************************************************\
*****\
\>", "Notes",
 CellID->185021568,ExpressionUUID->"99b5b200-8213-4679-b163-8716abed5385"],

Cell[TextData[{
 "The function is defined for ",
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["ttr"]], "paclet:NewEoSArgon/ref/ttr", 
    "NewEoSArgon Package Symbol"},
   "PackageLink",
   BaseStyle->"InlineFormula"]], "InlineFormula",
  FontFamily->"Source Sans Pro",ExpressionUUID->
  "68ac05d8-7106-4753-b18b-fe028eb80fe7"],
 " \[LessEqual] ",
 StyleBox["T",
  FontSlant->"Italic"],
 " \[LessEqual] ",
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["tc"]], "paclet:NewEoSArgon/ref/tc", 
    "NewEoSArgon Package Symbol"},
   "PackageLink",
   BaseStyle->"InlineFormula"]], "InlineFormula",
  FontFamily->"Source Sans Pro",ExpressionUUID->
  "30d7c77f-caaf-4c92-af6b-be422706fbc0"]
}], "Notes",
 CellID->121367135,ExpressionUUID->"d6f3a321-db77-41a2-a9e1-0bf58a89cb4d"]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "NotesSection"}, Closed]]]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {
       TaggingRules, "Openers", "PrimaryExamplesSection"}, Open], 
      Alternatives[True, Open]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{13.600000000000001`, {5., 8.600000000000001}}]],
  ExpressionUUID->"14c87242-994a-411e-a3eb-92f9654f38f2"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"5ca61d3c-4041-458b-b0c1-69b436ecb461"],
 "Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "7192c391-4a59-4312-abd7-c1a919e54789"]
}], "PrimaryExamplesSection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellTags->"PrimaryExamplesSection",
 CellID->235161822,ExpressionUUID->"7f70f538-0c9f-4380-8670-d6f440426cdf"],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"},
        Closed], 
      Alternatives[Open, True]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{13.600000000000001`, {5., 8.600000000000001}}]],
  ExpressionUUID->"d2d8d713-2112-42c3-bc42-dc6df784b396"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"6c20fdf5-c844-4bf2-8c6c-0155a6946985"],
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "4a7347d6-b957-4a3d-89f0-e8a353a76e55"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellID->318086271,ExpressionUUID->"93d7c282-e6a9-40db-bfb0-d1af8aab8577"],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<NewEoSArgon`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->87419684,ExpressionUUID->"c76ba398-874f-43d8-a12b-948e2c208745"],

Cell["Calculate with physical dimension", "ExampleText",
 CellID->285078790,ExpressionUUID->"febbdf98-ccc9-41b2-a537-9c83b47c222a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Quantity", "[", 
  RowBox[{
   RowBox[{"RhoSatVapNISTFromT", "[", "ttr", "]"}], ",", "\"\<g/cm^3\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->231987987,ExpressionUUID->"e0f998a1-8fbf-423f-8c57-d8dcd4cede7b"],

Cell[BoxData[
 TemplateBox[{"0.0040546000061275735`", 
   RowBox[{"\"g\"", "\[InvisibleSpace]", "\"/\"", "\[InvisibleSpace]", 
     SuperscriptBox["\"cm\"", "3"]}], "grams per centimeter cubed", 
   FractionBox["\"Grams\"", 
    SuperscriptBox["\"Centimeters\"", "3"]]},
  "Quantity"]], "Output",
 CellLabel->"Out[2]=",
 CellID->701682200,ExpressionUUID->"58154c84-876f-42ae-b0bd-50d270e58a7d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UnitConvert", "[", 
  RowBox[{
   TemplateBox[{"0.0040546000061275735`"},
    "QuantityUnit",
    DisplayFunction->(TooltipBox[
      StyleBox[
       RowBox[{#, "\[InvisibleSpace]", 
         StyleBox[
          RowBox[{" ", 
            
            RowBox[{"\"g\"", "\[InvisibleSpace]", "\"/\"", 
              "\[InvisibleSpace]", 
              SuperscriptBox["\"cm\"", "3"]}]}], 
          "QuantityUnitTraditionalLabel"]}], ShowStringCharacters -> False], 
      "Unit: grams per centimeter cubed"]& ),
    InterpretationFunction->(RowBox[{"Quantity", "[", 
       RowBox[{#, ",", 
         FractionBox["\"Grams\"", 
          SuperscriptBox["\"Centimeters\"", "3"]]}], "]"}]& )], ",", 
   "\"\<kg/m^3\>\""}], "]"}]], "Input",
 NumberMarks->False,
 CellLabel->"In[3]:=",
 CellID->124097849,ExpressionUUID->"94a76964-62a6-4fa1-ac3d-dbb4f808b608"],

Cell[BoxData[
 TemplateBox[{"4.054600006127574`", 
   RowBox[{"\"kg\"", "\[InvisibleSpace]", "\"/\"", "\[InvisibleSpace]", 
     SuperscriptBox["\"m\"", "3"]}], "kilograms per meter cubed", 
   FractionBox["\"Kilograms\"", 
    SuperscriptBox["\"Meters\"", "3"]]},
  "Quantity"]], "Output",
 CellLabel->"Out[3]=",
 CellID->25903961,ExpressionUUID->"aca997ec-fd35-4a87-ae81-86b0f303cd39"]
}, Open  ]],

Cell["\<\
Plot function versus temperature in all the temperature range\
\>", "ExampleText",
 CellID->886239600,ExpressionUUID->"334a670b-2a55-46ca-809c-ef0584fae067"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"RhoSatVapNISTFromT", "[", "T", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"T", ",", "ttr", ",", "tc"}], "}"}], ",", 
   RowBox[{"AxesOrigin", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"ttr", ",", "\[Rho]c"}], "}"}]}], ",", 
   RowBox[{"Frame", "->", "True"}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Quantity", "[", 
       RowBox[{"T", ",", "\"\<Kelvins\>\""}], "]"}], ",", 
      RowBox[{"Quantity", "[", 
       RowBox[{"\[Rho]", ",", "\"\<g/cm^3\>\""}], "]"}]}], "}"}]}], ",", 
   RowBox[{"ImageSize", "\[Rule]", "400"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->21488140,ExpressionUUID->"be580c10-332e-4fc7-a818-2a7367f2fcde"],

Cell[BoxData[
 GraphicsBox[
  InterpretationBox[{
    TagBox[{{{}, {}, 
       TagBox[
        {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[2], 
         Opacity[1.], LineBox[CompressedData["
1:eJwV1Hk4FegXB3ARqWGULUvGUlIoZbSRznFLUklXyN71JiklS8oUyqVM3DJc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          "]]},
        Annotation[#, "Charting`Private`Tag#1"]& ]}, {}},
     {"WolframDynamicHighlight", <|
      "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>}], 
    DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
      Slot["HighlightElements"], 
      Slot["LayoutOptions"], 
      Slot["Meta"], 
      Charting`HighlightActionFunction["DynamicHighlight", {{{{}, {}, 
          Annotation[{
            Directive[
             Opacity[1.], 
             RGBColor[0.368417, 0.506779, 0.709798], 
             AbsoluteThickness[2]], 
            Line[CompressedData["
1:eJwV1Hk4FegXB3ARqWGULUvGUlIoZbSRznFLUklXyN71JiklS8oUyqVM3DJc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             "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
       "HighlightElements" -> <|
         "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
        "LayoutOptions" -> <|
         "PlotRange" -> {{83.8058, 150.687}, {0., 0.535599}}, 
          "Frame" -> {{True, True}, {True, True}}, 
          "AxesOrigin" -> {83.8058, 0.535599}, 
          "ImageSize" -> {400, 400/GoldenRatio}, "Axes" -> {True, True}, 
          "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
          "DefaultStyle" -> {
            Directive[
             Opacity[1.], 
             RGBColor[0.368417, 0.506779, 0.709798], 
             AbsoluteThickness[2]]}, 
          "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
              Identity[
               Part[#, 1]], 
              Identity[
               Part[#, 2]]}& ), 
            "ScalingFunctions" -> {{Identity, Identity}, {
              Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>,
         "Meta" -> <|
         "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
          Plot, "GroupHighlight" -> False|>|>]]& )[<|
      "HighlightElements" -> <|
        "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
       "LayoutOptions" -> <|
        "PlotRange" -> {{83.8058, 150.687}, {0., 0.535599}}, 
         "Frame" -> {{True, True}, {True, True}}, 
         "AxesOrigin" -> {83.8058, 0.535599}, 
         "ImageSize" -> {400, 400/GoldenRatio}, "Axes" -> {True, True}, 
         "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
         "DefaultStyle" -> {
           Directive[
            Opacity[1.], 
            RGBColor[0.368417, 0.506779, 0.709798], 
            AbsoluteThickness[2]]}, 
         "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
             Identity[
              Part[#, 1]], 
             Identity[
              Part[#, 2]]}& ), 
           "ScalingFunctions" -> {{Identity, Identity}, {
             Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>, 
       "Meta" -> <|
        "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
         Plot, "GroupHighlight" -> False|>|>],
     ImageSizeCache->{{4.503599627370496*^15, -4.503599627370496*^15}, {
      4.503599627370496*^15, -4.503599627370496*^15}}]},
   Annotation[{{{{}, {}, 
       Annotation[{
         Directive[
          Opacity[1.], 
          RGBColor[0.368417, 0.506779, 0.709798], 
          AbsoluteThickness[2]], 
         Line[CompressedData["
1:eJwV1Hk4FegXB3ARqWGULUvGUlIoZbSRznFLUklXyN71JiklS8oUyqVM3DJc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          "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
    "HighlightElements" -> <|
      "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
     "LayoutOptions" -> <|
      "PlotRange" -> {{83.8058, 150.687}, {0., 0.535599}}, 
       "Frame" -> {{True, True}, {True, True}}, 
       "AxesOrigin" -> {83.8058, 0.535599}, 
       "ImageSize" -> {400, 400/GoldenRatio}, "Axes" -> {True, True}, 
       "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), "DefaultStyle" -> {
         Directive[
          Opacity[1.], 
          RGBColor[0.368417, 0.506779, 0.709798], 
          AbsoluteThickness[2]]}, 
       "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
           Identity[
            Part[#, 1]], 
           Identity[
            Part[#, 2]]}& ), 
         "ScalingFunctions" -> {{Identity, Identity}, {Identity, Identity}}|>,
        "Primitives" -> {}, "GCFlag" -> False|>, 
     "Meta" -> <|
      "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
       Plot, "GroupHighlight" -> False|>|>, "DynamicHighlight"]],
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{83.8058, 0.535599},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{
     FormBox[
      TagBox[
       TemplateBox[{"\[Rho]", 
         RowBox[{"\"g\"", "\[InvisibleSpace]", "\"/\"", "\[InvisibleSpace]", 
           SuperscriptBox["\"cm\"", "3"]}], "grams per centimeter cubed", 
         FractionBox["\"Grams\"", 
          SuperscriptBox["\"Centimeters\"", "3"]]}, "QuantityTF", SyntaxForm -> 
        Mod], HoldForm], TraditionalForm], None}, {
     FormBox[
      TagBox[
       TemplateBox[{
         TagBox[
          TagBox["T", HoldForm], HoldForm], "\"K\"", "kelvins", 
         "\"Kelvins\""}, "QuantityTF", SyntaxForm -> Mod], HoldForm], 
      TraditionalForm], None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  ImageSize->400,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{83.8058, 150.687}, {0., 0.535599}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellLabel->"Out[4]=",
 CellID->21972355,ExpressionUUID->"6c8d85b4-5b59-40c1-bd5e-d125bf97f58f"]
}, Open  ]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"}, 
  Closed]]]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "PrimaryExamplesSection"}, 
  Closed]]]],

Cell[BoxData[GridBox[{
   {
    DynamicBox[FEPrivate`ImportImage[
      FrontEnd`FileName[{"Documentation", "FooterIcons"}, 
       "RelatedFunction.png"]],
     ImageSizeCache->{50., {27., 33.}}], GridBox[{
      {
       StyleBox[
        RowBox[{"See", " ", "Also"}], "SeeAlsoSection"]},
      {Cell[TextData[{
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["rhotrgaz"]], "paclet:NewEoSArgon/ref/rhotrgaz", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "dfa9113a-df62-470a-909c-4d6d52216d5b"],
        "\[NonBreakingSpace]",
        StyleBox[
        "\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
         "InlineSeparator"],
        " ",
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["rhoc"]], "paclet:NewEoSArgon/ref/rhoc", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "6af60b73-e334-4b57-87d5-6661a32b82bb"],
        "\[NonBreakingSpace]",
        StyleBox[
        "\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
         "InlineSeparator"],
        " ",
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["ttr"]], "paclet:NewEoSArgon/ref/ttr", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "8d948a7d-2806-4180-ae8f-a0d79445410d"],
        "\[NonBreakingSpace]",
        StyleBox[
        "\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
         "InlineSeparator"],
        " ",
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["tc"]], "paclet:NewEoSArgon/ref/tc", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "ea4d4335-ca68-4af8-a61f-c80077a71453"],
        "\[NonBreakingSpace]",
        StyleBox[
        "\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
         "InlineSeparator"],
        " ",
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["RhoSatLiqNISTFromT"]], 
           "paclet:NewEoSArgon/ref/RhoSatLiqNISTFromT", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "43b4dcad-b1f4-461b-bfb3-ab0848104cae"]
       }], "SeeAlso",ExpressionUUID->"8cfb14d3-7daa-468c-b773-632ef082ff52"]}
     }]}
  }]], "SeeAlsoSection",ExpressionUUID->"72f9ce86-c2b3-4156-8fe2-\
acb14c9955bc"],

Cell[BoxData[GridBox[{
   {
    DynamicBox[FEPrivate`ImportImage[
      FrontEnd`FileName[{"Documentation", "FooterIcons"}, "RelatedGuide.png"]],
     ImageSizeCache->{50., {27., 33.}}], GridBox[{
      {
       StyleBox[
        RowBox[{"Related", " ", "Guides"}], "MoreAboutSection"]},
      {
       RowBox[{"\[FilledVerySmallSquare]", Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["NewEoSArgon Package"]], 
           "paclet:NewEoSArgon/guide/NewEoSArgon"},
          "RefLinkPlain",
          BaseStyle->{"MoreAbout"}]], "MoreAbout",ExpressionUUID->
         "8d444578-bc78-4b4d-8a4e-66ed9aac0010"]}]}
     }]}
  }]], "MoreAboutSection",ExpressionUUID->"3b14f6de-1319-4e6f-b235-\
5623581ae8a0"],

Cell[BoxData[GridBox[{
   {
    TemplateBox[{29},
     "Spacer1"], GridBox[{
      {
       RowBox[{
        TemplateBox[{17},
         "Spacer1"], 
        StyleBox[
         RowBox[{"Related", " ", "Links"}], "RelatedLinksSection"]}]},
      {Cell[BoxData[Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData[
             RowBox[{
               RowBox[{"Units", " ", "&"}], " ", "Quantities"}]]], 
           "paclet:guide/Units"},
          "RefLinkPlain",
          BaseStyle->{"RelatedLinks"}]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "8f78894e-8497-480e-af07-a42accbbaf54"]], "RelatedLinks",
        ExpressionUUID->"e4e4bca9-cc55-4bae-a9f2-1b251978b37e"]},
      {Cell[BoxData[Cell[BoxData[Cell[BoxData[
          RowBox[{
           TemplateBox[{16},
            "Spacer1"], "\[FilledVerySmallSquare]", 
           TemplateBox[{
             Cell[
              TextData[
               Cell[
                TextData[{
                  Cell[
                   BoxData[
                    TemplateBox[{2}, "Spacer1"]]], "ThermodynamicData"}]]]], 
             "paclet:ref/ThermodynamicData"},
            "RefLink",
            BaseStyle->{"RelatedLinks"}]}]],ExpressionUUID->
          "76f29f94-6d71-48ea-baa8-752ddc16330d"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "e9601b19-eae5-46f2-b854-bf4d3063c6f0"]], "RelatedLinks",
        ExpressionUUID->"62644567-c828-41d9-bca9-35349f04860e"]},
      {Cell[TextData[Cell[BoxData[
        RowBox[{
         TemplateBox[{16},
          "Spacer1"], "\[FilledVerySmallSquare]", Cell[BoxData[
          TemplateBox[{
            Cell[
             TextData[
              Cell[
               TextData[{
                 Cell[
                  BoxData[
                   TemplateBox[{2}, "Spacer1"]]], 
                 "Webbook de chimie NIST"}]]]], 
            "http://webbook.nist.gov/chemistry/fluid/"},
           "WebLink",
           BaseStyle->{"RelatedLinks"}]],ExpressionUUID->
          "8dbd8178-2b54-4537-bf57-bb0cf6e0f91d"]}]],ExpressionUUID->
        "f956cce3-9e43-4913-984e-709ce9dc1eb2"]], "RelatedLinks",
        ExpressionUUID->"3de6d275-7d77-4ae4-928e-86eb87b0cd89"]}
     }]}
  }]], "RelatedLinksSection",ExpressionUUID->"2845bf6c-33c0-441d-892a-\
163b9d6f66e2"],

Cell[" ", "FooterCell",ExpressionUUID->"0c31a344-2153-4330-ad93-0f7d30d842fa"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{900, 835.8},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"RhoSatVapNISTFromT",
TaggingRules->{
 "ModificationHighlight" -> False, "ColorType" -> "", "LinkTrails" -> "", 
  "HasOptions" -> True, "ExampleCounter" -> 1, 
  "Openers" -> {
   "PrimaryExamplesSection" -> Open, "ExampleSection" -> {"0" -> Open}, 
    "NotesSection" -> Closed}, "NewStyles" -> True, 
  "CitationPopupData" -> $Failed, "ShowCitation" -> False, "RootCaptions" -> 
  "", "Metadata" -> {
   "built" -> "{2023, 11, 30, 13, 56, 2.3144541}", 
    "history" -> {"XX", "", "", ""}, "context" -> "NewEoSArgon`", 
    "keywords" -> {}, "specialkeywords" -> {}, 
    "tutorialcollectionlinks" -> {}, "index" -> True, "label" -> 
    "New Eo S Argon Package Symbol", "language" -> "en", "paclet" -> 
    "NewEoSArgon Package", "status" -> "None", "summary" -> 
    "RhoSatVapNISTFromT[T] \\[Congruent] \\[Rho]\\[Sigma]v (g/cm^3) Densit\
\[EAcute] du gaz sur la courbe de saturation donn\[EAcute]e par NIST en \
fonction de T (Kelvin) [Gas density on the saturation curve given by NIST as \
a function of T (Kelvin)]", "synonyms" -> {}, "tabletags" -> {}, "title" -> 
    "RhoSatVapNISTFromT", "titlemodifier" -> "", "metadescription" -> "", 
    "windowtitle" -> "RhoSatVapNISTFromT", "type" -> "Symbol", "uri" -> 
    "NewEoSArgon/ref/RhoSatVapNISTFromT"}},
CellContext->"Global`",
FrontEndVersion->"13.3 pour Microsoft Windows (64-bit) (July 24, 2023)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "13.3 pour Microsoft Windows (64-bit) (July 24, 2023)", 
  StyleDefinitions -> "Default.nb"],
ExpressionUUID->"7f067f2c-8f47-4d02-b97f-a18b2fb4dc18"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[11912, 330, 1420, 37, 35, "PrimaryExamplesSection",ExpressionUUID->"7f70f538-0c9f-4380-8670-d6f440426cdf",
   CellTags->"PrimaryExamplesSection",
   CellID->235161822]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 41317, 1021}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[590, 21, 5622, 135, 56, "AnchorBarGrid",ExpressionUUID->"eca46315-36c5-4f82-84a9-1879f277d21f",
 CellID->1],
Cell[6215, 158, 94, 0, 23, "ContextNameCell",ExpressionUUID->"3fb80573-9dcb-4d73-b595-0d82c68e35f3"],
Cell[CellGroupData[{
Cell[6334, 162, 561, 14, 56, "ObjectNameGrid",ExpressionUUID->"b0f0121b-cf3a-43ca-a5ac-17fa73aece85"],
Cell[6898, 178, 1147, 33, 146, "Usage",ExpressionUUID->"64438c9f-8632-47e1-8446-a8f8331e11a8"]
}, Open  ]],
Cell[CellGroupData[{
Cell[8082, 216, 1919, 48, 37, "NotesSection",ExpressionUUID->"cb549ba6-0ef5-4529-9f10-e048c55031ea",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->483489053],
Cell[10004, 266, 800, 25, 38, "Notes",ExpressionUUID->"ed71064b-26a3-4594-9eda-e6f719277826",
 CellID->1067943069],
Cell[10807, 293, 185, 4, 36, "Notes",ExpressionUUID->"99b5b200-8213-4679-b163-8716abed5385",
 CellID->185021568],
Cell[10995, 299, 790, 25, 38, "Notes",ExpressionUUID->"d6f3a321-db77-41a2-a9e1-0bf58a89cb4d",
 CellID->121367135]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "NotesSection"}, Closed]]]],
Cell[CellGroupData[{
Cell[11912, 330, 1420, 37, 35, "PrimaryExamplesSection",ExpressionUUID->"7f70f538-0c9f-4380-8670-d6f440426cdf",
 CellTags->"PrimaryExamplesSection",
 CellID->235161822],
Cell[CellGroupData[{
Cell[13357, 371, 1398, 36, 30, "ExampleSection",ExpressionUUID->"93d7c282-e6a9-40db-bfb0-d1af8aab8577",
 CellID->318086271],
Cell[14758, 409, 174, 3, 26, "Input",ExpressionUUID->"c76ba398-874f-43d8-a12b-948e2c208745",
 CellID->87419684],
Cell[14935, 414, 131, 1, 38, "ExampleText",ExpressionUUID->"febbdf98-ccc9-41b2-a537-9c83b47c222a",
 CellID->285078790],
Cell[CellGroupData[{
Cell[15091, 419, 246, 6, 26, "Input",ExpressionUUID->"e0f998a1-8fbf-423f-8c57-d8dcd4cede7b",
 CellID->231987987],
Cell[15340, 427, 394, 8, 45, "Output",ExpressionUUID->"58154c84-876f-42ae-b0bd-50d270e58a7d",
 CellID->701682200]
}, Open  ]],
Cell[CellGroupData[{
Cell[15771, 440, 876, 23, 30, "Input",ExpressionUUID->"94a76964-62a6-4fa1-ac3d-dbb4f808b608",
 CellID->124097849],
Cell[16650, 465, 387, 8, 45, "Output",ExpressionUUID->"aca997ec-fd35-4a87-ae81-86b0f303cd39",
 CellID->25903961]
}, Open  ]],
Cell[17052, 476, 167, 3, 38, "ExampleText",ExpressionUUID->"334a670b-2a55-46ca-809c-ef0584fae067",
 CellID->886239600],
Cell[CellGroupData[{
Cell[17244, 483, 751, 19, 42, "Input",ExpressionUUID->"be580c10-332e-4fc7-a818-2a7367f2fcde",
 CellID->21488140],
Cell[17998, 504, 14914, 295, 276, "Output",ExpressionUUID->"6c8d85b4-5b59-40c1-bd5e-d125bf97f58f",
 CellID->21972355]
}, Open  ]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"}, Closed]]]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "PrimaryExamplesSection"}, Closed]]]],
Cell[33154, 808, 2922, 79, 70, "SeeAlsoSection",ExpressionUUID->"72f9ce86-c2b3-4156-8fe2-acb14c9955bc"],
Cell[36079, 889, 729, 19, 70, "MoreAboutSection",ExpressionUUID->"3b14f6de-1319-4e6f-b235-5623581ae8a0"],
Cell[36811, 910, 2350, 62, 70, "RelatedLinksSection",ExpressionUUID->"2845bf6c-33c0-441d-892a-163b9d6f66e2"],
Cell[39164, 974, 78, 0, 70, "FooterCell",ExpressionUUID->"0c31a344-2153-4330-ad93-0f7d30d842fa"]
}
]
*)

(* End of internal cache information *)

