(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 13.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     74712,       1732]
NotebookOptionsPosition[     68112,       1599]
NotebookOutlinePosition[     70399,       1656]
CellTagsIndexPosition[     70313,       1651]
WindowTitle->StotalAdimNv
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[GridBox[{
   {GridBox[{
      {
       ItemBox[Cell[BoxData[
         RowBox[{
          TemplateBox[{12},
           "Spacer1"], Cell["NEW EO S ARGON PACKAGE SYMBOL", "PacletNameCell",
           TextAlignment->Center,ExpressionUUID->
           "85e22a2d-5ffb-4450-aeaa-d2f528a992e0"], 
          TemplateBox[{8},
           "Spacer1"]}]],
         TextAlignment->Center,ExpressionUUID->
         "431c42d7-3b31-44c5-a09a-bc0db648a15e"],
        Background->RGBColor[0.490196, 0.576471, 0.690196],
        ItemSize->Full], ""}
     },
     GridBoxAlignment->{"Rows" -> {{Center}}},
     GridBoxItemSize->{"Columns" -> {Full, 
         Scaled[0.02]}, "Rows" -> {{2.5}}}], Cell[TextData[{
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "See Also",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "ec24cf82-ba50-4428-af75-bbf4523951c3"]
         }],ExpressionUUID->"1f6447f9-c188-4b38-b3c7-1fd7d6c6de4f"],
         StripOnInput->False],{
        "\"RhoArgonNv\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/RhoArgonNv"], 
         "\"FtotalAdimNv\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/FtotalAdimNv"]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"SeeAlso"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "8c7eacaf-8461-475b-82bb-728e74ace69d"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "Related Guides",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "3e5f7634-b556-4ee9-9b1b-7bdd28f9c961"]
         }],ExpressionUUID->"78b124bc-ecc4-4a74-92bc-50e79d6f79ac"],
         StripOnInput->False],{
        "\"NewEoSArgon Package\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/guide/NewEoSArgon"]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"MoreAbout"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "f718beb7-b26b-45ae-905a-e84123459fb3"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "URL",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "c73f212f-e27d-42c5-bcfd-144ea1b75840"]
         }],ExpressionUUID->"9bba562c-e5d1-4b6d-be78-d39c9a4d3767"],
         StripOnInput->False],{
        "\"NewEoSArgon/ref/StotalAdimNv\"" :> None, 
         "\"Copy Wolfram Documentation Center URL\"" :> 
         Module[{DocumentationSearch`Private`nb$}, 
           DocumentationSearch`Private`nb$ = 
            NotebookPut[
             Notebook[{Cell["NewEoSArgon/ref/StotalAdimNv"]}, Visible -> 
               False]]; 
           SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
           FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
           NotebookClose[DocumentationSearch`Private`nb$]; Null], Delimiter, 
         "\"Copy web URL\"" :> 
         Module[{DocumentationSearch`Private`nb$}, 
           DocumentationSearch`Private`nb$ = 
            NotebookPut[
             Notebook[{
               Cell[BoxData[
                 MakeBoxes[
                  Hyperlink[
                   "http://reference.wolfram.com/language/NewEoSArgon/ref/\
StotalAdimNv.html"], StandardForm]], "Input", TextClipboardType -> 
                 "PlainText"]}, Visible -> False]]; 
           SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
           FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
           NotebookClose[DocumentationSearch`Private`nb$]; Null], 
         "\"Go to web URL\"" :> 
         FrontEndExecute[{
           NotebookLocate[{
             URL[If[TrueQ[DocumentationBuild`Make`Private`wsmlinkQ$29442], 
                 "http://reference.wolfram.com/system-modeler/", 
                 "http://reference.wolfram.com/language/"] <> 
               "NewEoSArgon/ref/StotalAdimNv" <> ".html"], None}]}]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"URLMenu"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "0e6de113-e709-4db5-b808-9605a05b8bca"]
    }], "AnchorBar",
     CacheGraphics->False,ExpressionUUID->
     "11c547a7-1c15-4548-a615-eb45c01dcd60"]}
  }]], "AnchorBarGrid",
 CellID->1,ExpressionUUID->"3ac329df-aced-47e0-b950-d7d7c5f291ff"],

Cell["NewEoSArgon`", "ContextNameCell",ExpressionUUID->"fd347afb-f5a1-4b44-be79-5739dd51b126"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     Cell[
     "StotalAdimNv", "ObjectName",ExpressionUUID->
      "0371731b-0f53-4ff7-9652-4312d6e5c826"],
     Cell[BoxData[
      TemplateBox[{8},
       "Spacer1"]],ExpressionUUID->"70b1adb5-76c0-487b-ae2f-f874d2144b0c"],
     Cell[BoxData[
     ""], "ObjectNameTranslation",ExpressionUUID->
      "2c07da16-74b9-4b31-8ebf-1f6bbf2ee0eb"]
    }],ExpressionUUID->"86b7c50e-59b0-4272-912f-6e7d98e5f02d"], 
    "\[SpanFromLeft]"}
  }]], "ObjectNameGrid",ExpressionUUID->"c72527d3-50c8-4fb5-b9bd-\
c2ab75ddf63d"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     "StotalAdimNv[",
     StyleBox["T",
      FontSlant->"Italic"],
     ", \[Rho]] \[Congruent] ",
     StyleBox["S",
      FontSlant->"Italic"],
     "/",
     StyleBox["R",
      FontSlant->"Italic"],
     "\nEntropie adimensionnelle en fonction de ",
     StyleBox["T",
      FontSlant->"Italic"],
     " (Kelvin) et \[Rho] (g/",
     Cell[BoxData[
      SuperscriptBox["cm", "3"]], "InlineFormula",
      FontFamily->"Source Sans Pro",ExpressionUUID->
      "ee677062-7ef2-4266-84ed-052d90d33c11"],
     ")\n[Non-dimensionnal entropy versus ",
     StyleBox["T",
      FontSlant->"Italic"],
     " (Kelvin) and \[Rho] (g/",
     Cell[BoxData[
      SuperscriptBox["cm", "3"]], "InlineFormula",
      FontFamily->"Source Sans Pro",ExpressionUUID->
      "68478a24-b299-4100-9c4d-6ba689505e5e"],
     ")]"
    }],ExpressionUUID->"b24d94bb-0389-4436-bddb-a49c35f98ad6"]}
  }]], "Usage",ExpressionUUID->"e6a36fb7-0ad8-4a3b-bc74-80052ecc9d6e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[Cell[TextData[{
   Cell[BoxData[
    DynamicBox[ToBoxes[
      If[
       MatchQ[
        CurrentValue[
         EvaluationNotebook[], {TaggingRules, "Openers", "NotesSection"}, 
         Closed], 
        Alternatives[Open, True]], 
       Style[
        Graphics[{
          Thickness[0.18], 
          RGBColor[0.8509803921568627, 0.396078431372549, 0], 
          Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
         PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
        0.68 Inherited], 
       Rotate[
        Style[
         Graphics[{
           Thickness[0.18], 
           RGBColor[0.8509803921568627, 0.396078431372549, 0], 
           Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
          PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
         0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
     ImageSizeCache->{
      13.600000000000001`, {0.5800000000000001, 13.020000000000001`}}]],
    ExpressionUUID->"7d03e155-8275-4731-97fd-fa380f058768"],
   Cell[BoxData[
    TemplateBox[{1},
     "Spacer1"]],ExpressionUUID->"247e8b44-fbb0-4c7a-b44e-401af129574f"],
   "Details and Options"
  }], "NotesFrameText",ExpressionUUID->"ff38c11f-cf88-4297-b47d-126ade44fc63"],
  Appearance->{Automatic, None, "Normal", Automatic},
  BaseStyle->None,
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"], 
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], After, CellContents]}]& ),
  Evaluator->None,
  Method->
   "Preemptive"]],ExpressionUUID->"015b4c13-9431-40b7-bda2-9bb737571000"]], \
"NotesSection",
 WholeCellGroupOpener->True,
 CellGroupingRules->{"SectionGrouping", 50},
 CacheGraphics->False,
 CellID->380956477,ExpressionUUID->"58f83cd3-cfd9-423e-bc38-2f19a7429c48"],

Cell[TextData[{
 "La fonction est d\[EAcute]finie pour ",
 StyleBox["T",
  FontSlant->"Italic"],
 " \[GreaterEqual] 0 et \[Rho] \[GreaterEqual] 0"
}], "Notes",
 CellID->1067943069,ExpressionUUID->"9d81b9b4-69e7-45e6-bac8-d80e0c11b2b6"],

Cell["\<\
******************************************************************************\
*****\
\>", "Notes",
 CellID->185021568,ExpressionUUID->"90e79ced-f11f-4968-aea5-99668367118f"],

Cell[TextData[{
 "The function is defined for ",
 StyleBox["T",
  FontSlant->"Italic"],
 " >0 and \[Rho] \[GreaterEqual] 0."
}], "Notes",
 CellID->175218415,ExpressionUUID->"8ea07c27-b295-4e68-b75b-4ac1e6074141"]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "NotesSection"}, Closed]]]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {
       TaggingRules, "Openers", "PrimaryExamplesSection"}, Open], 
      Alternatives[True, Open]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{13.600000000000001`, {5., 8.600000000000001}}]],
  ExpressionUUID->"757ff610-d51f-4393-8461-27f8b3d1bd14"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"88702918-04f1-413d-b5d5-40b88c3a1bbf"],
 "Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount",ExpressionUUID->
  "62e3b91f-ee6e-498c-8484-fec2feae8b2b"]
}], "PrimaryExamplesSection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellTags->"PrimaryExamplesSection",
 CellID->127113187,ExpressionUUID->"0af2eadb-f53e-4410-9900-4f8568537bfd"],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"},
        Closed], 
      Alternatives[Open, True]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{13.600000000000001`, {5., 8.600000000000001}}]],
  ExpressionUUID->"876cadcb-45bd-4231-a6a4-194df3ff9d30"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"185e24d4-f3f5-4e38-b4ca-9234f0115562"],
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "641f6a9a-de6e-4141-9640-f1cef738d823"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellID->425197576,ExpressionUUID->"41caf944-9fdb-408b-8d71-e1150cb376a0"],

Cell[BoxData[{
 RowBox[{"Needs", "[", "\"\<NewEoSArgon`\>\"", "]"}], "\[IndentingNewLine]", 
 RowBox[{"Off", "[", 
  RowBox[{"General", "::", "munfl"}], "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->143015886,ExpressionUUID->"af527d2f-f23f-42b6-8bc5-a1987051d008"],

Cell[TextData[{
 "Calculated value of ",
 Cell[BoxData["S"], "InlineFormula",
  FontFamily->"Source Sans Pro",
  FontSlant->"Italic",ExpressionUUID->"3d878e91-e0ed-4f0e-995f-e0b803dcd191"],
 " for atmospheric pressure and 20\[Degree]C"
}], "ExampleText",
 CellID->544149791,ExpressionUUID->"376a31a3-58fa-4fa0-a95b-27837776aa3a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UnitSimplify", "@", 
  RowBox[{"UnitConvert", "[", 
   RowBox[{
    RowBox[{"StotalAdimNv", "[", 
     RowBox[{"293.15", ",", 
      RowBox[{"RhoArgonNv", "[", 
       RowBox[{"293.15", ",", 
        RowBox[{"QuantityMagnitude", "@", 
         RowBox[{"N", "@", 
          RowBox[{"UnitConvert", "[", 
           RowBox[{
            TemplateBox[{"1"},
             "QuantityUnit",
             DisplayFunction->(TooltipBox[
               StyleBox[
                RowBox[{#, "\[InvisibleSpace]", 
                  StyleBox[
                   RowBox[{" ", "\"atm\""}], 
                   "QuantityUnitTraditionalLabel"]}], ShowStringCharacters -> 
                False], "Unit: atmospheres"]& ),
             InterpretationFunction->(RowBox[{"Quantity", "[", 
                RowBox[{#, ",", "\"Atmospheres\""}], "]"}]& )], ",", 
            "\"\<Bars\>\""}], "]"}]}]}], ",", "\"\<G\>\""}], "]"}]}], "]"}], 
    "*", 
    RowBox[{"Quantity", "[", "\"\<MolarGasConstant\>\"", "]"}]}], 
   "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->5710145,ExpressionUUID->"d7473c58-96dc-4c57-b3a1-584095d80cca"],

Cell[BoxData[
 TemplateBox[{"154.35853274102183`", 
   RowBox[{"\"kg\"", "\[ThinSpace]", 
     SuperscriptBox["\"m\"", "2"], "\[NegativeMediumSpace]", "\"/(\"", 
     "\[InvisibleSpace]", 
     SuperscriptBox["\"s\"", "2"], "\[InvisibleSpace]", "\"K\"", 
     "\[ThinSpace]", "\"mol\"", "\[InvisibleSpace]", "\")\""}], 
   "kilogram meters squared per second squared kelvin mole", 
   FractionBox[
    RowBox[{"\"Kilograms\"", " ", 
      SuperscriptBox["\"Meters\"", "2"]}], 
    RowBox[{"\"Kelvins\"", " ", "\"Moles\"", " ", 
      SuperscriptBox["\"Seconds\"", "2"]}]]},
  "Quantity"]], "Output",
 CellLabel->"Out[2]=",
 CellID->286211667,ExpressionUUID->"5f025169-5165-4b9c-be38-432490d864e8"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UnitConvert", "[", 
  RowBox[{
   RowBox[{"Quantity", "[", 
    RowBox[{"154.35853274102183`", ",", 
     FractionBox[
      RowBox[{"\"\<Kilograms\>\"", " ", 
       SuperscriptBox["\"\<Meters\>\"", "2"]}], 
      RowBox[{"\"\<Kelvins\>\"", " ", "\"\<Moles\>\"", " ", 
       SuperscriptBox["\"\<Seconds\>\"", "2"]}]]}], "]"}], ",", 
   RowBox[{
    RowBox[{"\"\<Joules\>\"", "/", "\"\<Kelvins\>\""}], "/", 
    "\"\<Moles\>\""}]}], "]"}]], "Input",
 NumberMarks->False,
 CellLabel->"In[3]:=",
 CellID->2876315,ExpressionUUID->"263d4153-c6db-41d5-a996-2cd8535a6eab"],

Cell[BoxData[
 TemplateBox[{"154.35853274102183`", 
   RowBox[{
    "\"J\"", "\[InvisibleSpace]", "\"/(\"", "\[InvisibleSpace]", "\"K\"", 
     "\[ThinSpace]", "\"mol\"", "\[InvisibleSpace]", "\")\""}], 
   "joules per kelvin mole", 
   FractionBox["\"Joules\"", 
    RowBox[{"\"Kelvins\"", " ", "\"Moles\""}]]},
  "Quantity"]], "Output",
 CellLabel->"Out[3]=",
 CellID->240276877,ExpressionUUID->"415f1e9f-f658-49b4-8225-df25c6bd017f"]
}, Open  ]],

Cell["Using ThermodynamicData package (i.e. REFPROP from NIST)", "ExampleText",
 CellID->361149294,ExpressionUUID->"9aa04035-22c7-48a2-86d7-105eb61ef25f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UnitConvert", "[", 
  RowBox[{
   RowBox[{"ThermodynamicData", "[", 
    RowBox[{"\"\<Argon\>\"", ",", "\"\<MolarEntropy\>\"", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<Pressure\>\"", "\[Rule]", 
        RowBox[{"Quantity", "[", 
         RowBox[{"1", ",", "\"\<Atmospheres\>\""}], "]"}]}], ",", 
       RowBox[{"\"\<Temperature\>\"", "\[Rule]", 
        RowBox[{"Quantity", "[", 
         RowBox[{"293.15", ",", "\"\<Kelvins\>\""}], "]"}]}]}], "}"}]}], 
    "]"}], ",", "\"\<J/K/Moles\>\""}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->375583457,ExpressionUUID->"58361fdc-e15e-45b0-aa29-d31958c9bed1"],

Cell[BoxData[
 TemplateBox[{"154.36399071058855`", 
   RowBox[{
    "\"J\"", "\[InvisibleSpace]", "\"/(\"", "\[InvisibleSpace]", "\"K\"", 
     "\[ThinSpace]", "\"mol\"", "\[InvisibleSpace]", "\")\""}], 
   "joules per kelvin mole", 
   FractionBox["\"Joules\"", 
    RowBox[{"\"Kelvins\"", " ", "\"Moles\""}]]},
  "Quantity"]], "Output",
 CellLabel->"Out[4]=",
 CellID->170622407,ExpressionUUID->"8c49a132-0c3f-43c6-b3a3-6c4b0c25eefa"]
}, Open  ]],

Cell["Entropy on the saturation curve from NIST", "ExampleText",
 CellID->286706321,ExpressionUUID->"057b1f31-b7e5-455d-80b7-5284254ae413"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"StotalAdimNv", "[", 
     RowBox[{
      RowBox[{"TSatNIST", "[", "\[Rho]", "]"}], ",", "\[Rho]"}], "]"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"\[Rho]", ",", "\[Rho]trgaz", ",", "\[Rho]trliq"}], "}"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", "Red", "}"}]}], ",", 
   RowBox[{"AxesOrigin", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\[Rho]c", ",", "0"}], "}"}]}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "\"\<\[Rho] (g/\!\(\*SuperscriptBox[\(cm\), \(3\)]\))\>\"", ",", 
      "\"\<\!\(\*StyleBox[\"S\",FontSlant->\"Italic\"]\)/\!\(\*StyleBox[\"R\",\
FontSlant->\"Italic\"]\)\>\""}], "}"}]}], ",", 
   RowBox[{"ImageSize", "\[Rule]", "500"}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->605199954,ExpressionUUID->"8b135769-b9e7-4e3b-babe-43cc363d844c"],

Cell[BoxData[
 GraphicsBox[
  InterpretationBox[{
    TagBox[{{{}, {}, 
       TagBox[
        {RGBColor[1, 0, 0], AbsoluteThickness[2], Opacity[1.], 
         LineBox[CompressedData["
1:eJwVzmk8lAsbgHEcjhSVwcmMso5lntmIRKn7brGEtKskZQ0hS3qzj6UJRU4k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          "]]},
        Annotation[#, "Charting`Private`Tag#1"]& ]}, {}},
     {"WolframDynamicHighlight", <|
      "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>}], 
    DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
      Slot["HighlightElements"], 
      Slot["LayoutOptions"], 
      Slot["Meta"], 
      Charting`HighlightActionFunction["DynamicHighlight", {{{{}, {}, 
          Annotation[{
            Directive[
             Opacity[1.], 
             AbsoluteThickness[2], 
             RGBColor[1, 0, 0]], 
            Line[CompressedData["
1:eJwVzmk8lAsbgHEcjhSVwcmMso5lntmIRKn7brGEtKskZQ0hS3qzj6UJRU4k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             "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
       "HighlightElements" -> <|
         "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
        "LayoutOptions" -> <|
         "PlotRange" -> {{0.0040546000061275735`, 1.4168017335853793`}, {0., 
           15.77096681345962}}, "Frame" -> {{True, True}, {True, True}}, 
          "AxesOrigin" -> {0.535599, 0.}, 
          "ImageSize" -> {500, 500/GoldenRatio}, "Axes" -> {True, True}, 
          "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
          "DefaultStyle" -> {
            Directive[
             Opacity[1.], 
             AbsoluteThickness[2], 
             RGBColor[1, 0, 0]]}, 
          "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
              Identity[
               Part[#, 1]], 
              Identity[
               Part[#, 2]]}& ), 
            "ScalingFunctions" -> {{Identity, Identity}, {
              Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>,
         "Meta" -> <|
         "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
          Plot, "GroupHighlight" -> False|>|>]]& )[<|
      "HighlightElements" -> <|
        "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
       "LayoutOptions" -> <|
        "PlotRange" -> {{0.0040546000061275735`, 1.4168017335853793`}, {0., 
          15.77096681345962}}, "Frame" -> {{True, True}, {True, True}}, 
         "AxesOrigin" -> {0.535599, 0.}, 
         "ImageSize" -> {500, 500/GoldenRatio}, "Axes" -> {True, True}, 
         "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
         "DefaultStyle" -> {
           Directive[
            Opacity[1.], 
            AbsoluteThickness[2], 
            RGBColor[1, 0, 0]]}, 
         "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
             Identity[
              Part[#, 1]], 
             Identity[
              Part[#, 2]]}& ), 
           "ScalingFunctions" -> {{Identity, Identity}, {
             Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>, 
       "Meta" -> <|
        "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
         Plot, "GroupHighlight" -> False|>|>],
     ImageSizeCache->{{4.503599627370496*^15, -4.503599627370496*^15}, {
      4.503599627370496*^15, -4.503599627370496*^15}}]},
   Annotation[{{{{}, {}, 
       Annotation[{
         Directive[
          Opacity[1.], 
          AbsoluteThickness[2], 
          RGBColor[1, 0, 0]], 
         Line[CompressedData["
1:eJwVzmk8lAsbgHEcjhSVwcmMso5lntmIRKn7brGEtKskZQ0hS3qzj6UJRU4k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          "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
    "HighlightElements" -> <|
      "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
     "LayoutOptions" -> <|
      "PlotRange" -> {{0.0040546000061275735`, 1.4168017335853793`}, {0., 
        15.77096681345962}}, "Frame" -> {{True, True}, {True, True}}, 
       "AxesOrigin" -> {0.535599, 0.}, "ImageSize" -> {500, 500/GoldenRatio}, 
       "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
       GoldenRatio^(-1), "DefaultStyle" -> {
         Directive[
          Opacity[1.], 
          AbsoluteThickness[2], 
          RGBColor[1, 0, 0]]}, 
       "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
           Identity[
            Part[#, 1]], 
           Identity[
            Part[#, 2]]}& ), 
         "ScalingFunctions" -> {{Identity, Identity}, {Identity, Identity}}|>,
        "Primitives" -> {}, "GCFlag" -> False|>, 
     "Meta" -> <|
      "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
       Plot, "GroupHighlight" -> False|>|>, "DynamicHighlight"]],
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0.535599, 0.},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{
     FormBox[
      TagBox[
      "\"\\!\\(\\*StyleBox[\\\"S\\\",FontSlant->\\\"Italic\\\"]\\)/\\!\\(\\*\
StyleBox[\\\"R\\\",FontSlant->\\\"Italic\\\"]\\)\"", HoldForm], 
      TraditionalForm], None}, {
     FormBox[
      TagBox[
      "\"\[Rho] (g/\\!\\(\\*SuperscriptBox[\\(cm\\), \\(3\\)]\\))\"", 
       HoldForm], TraditionalForm], None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  ImageSize->500,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0.0040546000061275735`, 1.4168017335853793`}, {0., 
   15.77096681345962}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellLabel->"Out[5]=",
 CellID->865202625,ExpressionUUID->"1063e17c-a740-4e72-b008-a7b1035d2ac3"]
}, Open  ]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"}, 
  Closed]]]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "2"},
        Closed], 
      Alternatives[Open, True]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{
    13.600000000000001`, {0.5800000000000001, 13.020000000000001`}}]],
  ExpressionUUID->"93adb6a2-1851-4b56-8aee-2cb79298e0b5"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"ae4172e1-0921-4764-a0b5-ffe804230ef1"],
 "Applications",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "0b5db4ff-a80d-4242-9835-f8d60d212dae"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellID->258228157,ExpressionUUID->"eaa5a026-4717-4b70-882a-e1f07166ad70"],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<NewEoSArgon`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->87419684,ExpressionUUID->"cf021c17-c2c9-4bfd-ab36-dbc29aca0043"],

Cell[TextData[{
 "Comparison with ",
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["NIST data"]], "http://webbook.nist.gov/chemistry/fluid/"},
   "WebLink",
   BaseStyle->{"ExampleText"}]],ExpressionUUID->
  "958bfb31-64b5-4e47-a637-130b08402cea"],
 " on an isotherm close to the critical isotherm"
}], "ExampleText",
 CellID->227520913,ExpressionUUID->"6d6e3a22-8da1-495e-998b-afe20962455b"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"datafile", "=", 
   RowBox[{"FileNameJoin", "[", 
    RowBox[{"{", 
     RowBox[{
     "\"\<NewEoSArgon\>\"", ",", "\"\<DataFiles\>\"", ",", 
      "\"\<DataCritNIST.dat\>\""}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dataNIST", "=", 
   RowBox[{"Import", "[", "datafile", "]"}]}], ";"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->531122037,ExpressionUUID->"63ecc5ac-573d-4eb5-ab20-5102087cde7f"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ArT150p7S", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"dataNIST", "[", 
        RowBox[{"[", 
         RowBox[{"i", ",", "3"}], "]"}], "]"}], ",", 
       RowBox[{"dataNIST", "[", 
        RowBox[{"[", 
         RowBox[{"i", ",", "7"}], "]"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "2", ",", "51"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Legended", "[", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"RR", "*", 
       RowBox[{"StotalAdimNv", "[", 
        RowBox[{"150.7", ",", "x"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0.0000319`", ",", "1.6046`"}], "}"}], ",", 
     RowBox[{"AxesOrigin", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\[Rho]c", ",", "0"}], "}"}]}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
     RowBox[{"Frame", "\[Rule]", "True"}], ",", 
     RowBox[{"FrameLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
       "\"\<\[Rho] (g/\!\(\*SuperscriptBox[\(cm\), \(3\)]\))\>\"", ",", 
        "\"\<\!\(\*StyleBox[\"S\",FontSlant->\"Italic\"]\) (J/mole/K)\>\"", 
        ",", "\"\<ISOTHERM 150.7 K\>\""}], "}"}]}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", "Red", "}"}]}], ",", 
     RowBox[{"Epilog", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"PointSize", "\[Rule]", "Medium"}], ",", 
        RowBox[{"Map", "[", 
         RowBox[{"Point", ",", "ArT150p7S"}], "]"}]}], "}"}]}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "450"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Placed", "[", 
      RowBox[{
       RowBox[{"PointLegend", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"Directive", "[", 
           RowBox[{"Black", ",", 
            RowBox[{"AbsolutePointSize", "[", "6", "]"}]}], "]"}], "}"}], ",", 
         RowBox[{"{", "\"\<NIST database\>\"", "}"}]}], "]"}], ",", "Below"}],
       "]"}], ",", 
     RowBox[{"Placed", "[", 
      RowBox[{
       RowBox[{"LineLegend", "[", 
        RowBox[{
         RowBox[{"{", "Red", "}"}], ",", 
         RowBox[{
         "{", "\"\<StotalAdimNv[\!\(\*StyleBox[\"T\",FontSlant->\"Italic\"]\),\
\[Rho]]\>\"", "}"}]}], "]"}], ",", "Below"}], "]"}]}], "}"}]}], 
  "]"}]}], "Input",
 CellLabel->"In[3]:=",
 CellID->136921489,ExpressionUUID->"ffc9a9cc-cbe7-4b02-b20f-a526526abd1b"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[
    InterpretationBox[{
      TagBox[{{{{}, {}, 
          TagBox[{
            Directive[
             Opacity[1.], 
             AbsoluteThickness[2], 
             RGBColor[1, 0, 0]], 
            LineBox[CompressedData["
1:eJwVxXk8lAkfAHBKW1urnFmMpaSEtmFVYtbvN6FQjzHjnsuMLiVLteSqKZRI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             "]]}, Annotation[#, "Charting`Private`Tag#1"]& ]}}, {}}, {
       "WolframDynamicHighlight", <|
        "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>}], 
      DynamicBox[
       (Charting`HighlightActionBox["DynamicHighlight", {}, 
        Slot["HighlightElements"], 
        Slot["LayoutOptions"], 
        Slot["Meta"], 
        Charting`HighlightActionFunction["DynamicHighlight", {{{{}, {}, 
            Annotation[{
              Directive[
               Opacity[1.], 
               AbsoluteThickness[2], 
               RGBColor[1, 0, 0]], 
              Line[CompressedData["
1:eJwVxXk8lAkfAHBKW1urnFmMpaSEtmFVYtbvN6FQjzHjnsuMLiVLteSqKZRI
NdS6IsoRS72jjTIhg6w7OSsSpXK0E7J4divv+/7x/XzX+AWx9i9SUFBI/p//
X7S9rX2ySgEsFWeVZ3gHMDrEj/OdGR3i1Cxst4TsxbIVH7opBa7Q0nry+0f1
flg4sD7qp3JvsPvVV+Mgxw/beyWqRnsFsBD/JXSRih86gst+asA+kFL3BFj3
CLH21sQDm+P+QFgyBr7JFyJNJf67XZFHoIt6rMs4Sogcmjq1iB4MJnGfhbe9
hZg2Ofz8jsMx+IWizmZuF2J3niTmntOvsKVXj79NT4iqPqJNUiIUxoOzjGSL
heii7NL3iBkGmQzFlPAPArwgo5x57BEBZtKha0v7BNgYMmHS4hMFWfHBw0Z1
AlwTZA8T1NNQcrv/Nj1bgNhkqiG3OANFByOPyS8JkG+oPjZpGQ2Hw10SzooE
mNE3nDxrFQtbg1zOq+4V4APzpoOk9Vl4dOFT46CHAPsuSGifaefAKWZVpYOT
ADVQ9E6Rfh5ct96YLjYXoEXGgYdKdvEQs8J6+Op6ATJnCPFShwRI1RjxGNcV
4KVCirWyUyIcviBSerhUgLHLXu5MNBaDyHv8/OkGX7xS5lp6sUgMHwPfhuaX
+eJNv3rdyyZJUGN3RXNXvi/KKosnk8ySISto8bqRs774NTgiI5V6FRS+VfYa
3O2Lyj/IldJLr8I2xdpcmq0vUlqEQRkWv0GHc0/9BNUXbYyc7LMsU4A9Gvfb
Ji1fDHuuJb9plQa1a4xZI+/4GHfugndeRRrYUXqXH+nnY8pPC7X51umwvPGl
wKyDj2UX36UW0jJgZqZfxUXKx2l6Gf0OZoL7zhcnBsV83OpR1MxdlwP25GhK
iwMfC83EIc6Hc6CRlnqTQeOjrtIJAytJDoh1Sw6RFnxU+MM+VJ12A2jhDcwK
Az42qwytaXa7CWXcJfdbvvCQ37o6fFtMHhwzF4UeruJhR+4XQ6OmPJi3CmZ3
lvHQLnKkXW1VPmhU2dQz7/DQ2OTuOnlGPuyxrZJdzebhdBzRkXe3ALYqtzXr
xvDwnF3sBrXXhWCqGGEgI3g4rxPQubChCPKcDpTs3cXDgGnmyb8Ci6Ct2tBh
NZ2Hrjf0uxrJIphTXIS/W/JQZ0F6SqRaDK1lkv2xFB7ekU71fMDb0NbKC5fJ
uTiRtrn2zRMJZCttTK25xkWT+MSg+EkJJDb2vNuSykX/8DHKZtVSWJyeOX43
mYsjPrknIlilUL6CSK+L5+KAjtYm1Z5SYNCvRNPCuNia+TXV9sVdEN6qfhvi
ycWSnLbA9JF7sGLnx5wALS6Oi010YUkZGLxRe1KozkXjM3GNI0ZlUD7w/t/x
VVzME9INqQfLoIryo8apZVzMXFv2rGGsDPRLV+W8JDmYmJdpNyMvh3rSdyHk
JQcDCwO0GeQDeF3gaFJ+i4O9uoo9rtoV4Mg5qpqQx0Hbyyli1vYKaBMd8RDe
4ODKUNlSz/AKGJ1qeap9jYMSO61ZLlkBXtk190ovcXB6sLbzMCmF7GJt59BQ
DoZp6iSeIyvhP3wr3hpHDu6g71sYjKqBkmPpz6XTbDS3ydCxuVQDT7Px1r8f
2WiwpWNLanYNSHkUqe1fbPxqTDvCqK2BV7LkzJb3bKxQ0Xj+aKkMYt1TuxYG
2EgdqrubkyyDE6Ux1PY/2agvMjzgV1gLDKHn0XfX2fi58nXr26560L9/+R8H
FhsZTUmpfw41wnisXvXYUx9kjqhUhdm3wXJPG9Ggpw8yLDq6e5o6oMs5fFpr
3Btl1pImbmsndIefX6J00RsTnOcDdv/TDSHrRKVXN3tjzs1niRsW90FYcfAr
/qAXcjbRk+oVn8P1J55bq694YeAjVbsm03547OI2/2aXF7amRxx/SH0JJzYa
B1Yu8cLoyN1MTeErKP7e9rFenSfKd7G+Tasbgp2FWboD5zxxx6zzRkr9MCzI
8q5UsjyRXjin7/7iNXgdSvm+R88TD5ya7Fk0+AaKtscc6Zd74DbvLL/9cyOw
AUxjbas8kLN7pbBwxTsYo8s12xI9MN+v5Qc/5ffQxl97eY+vB147SfvjybpR
6Ha063PZ5IH3K8lv7m0cgws/zyzr+eKORpqRrWEbx0Emt7zq3+6OcFTiP2U7
AaIk50v96e4omjKvH6J/gH2pVq2Sg+4YEHJwNob9FxyyO3l/EdUdi9SEGUt/
kQPjorPq/Jwbruwu+KIY9BHG2acwuNYNxXs6dJ/tmAS/61HSr+fc0Ix+PG28
fhJspptYVBc3PLpjngi0nwI98UK7naYbJjr0yZvap6B3VLlWr5eFUjb34zBj
GiIbWraNpbOw+qhNf1f/NOQfL35I92JhT0bN+jP8T7Bhz+piqRYLf+vYUHx9
8BM0P9Supz9joumyMZ2UQzPg4/jdEu1kJnYzXccdJ2Yg6823o/4MJrplqeb3
nPgbKoaSz/QvYWLk3/fSOhVnIaJ6NnZvpSuW+36dSIiehaxP+yybQl3xz5Yb
Jnor58Do7L9sGxNXnHCaaDwsnoPo0IbZojoGVnSvzjFWmYdl7jMhFEsGcoWZ
fjUZ8/Cq+vO9aykuqKbQGKtOIaEo/pvhRkUX/PFM/T/uP5DwszYUmC4Q6LxI
FpxiQIKkO8720mcCY5SkXG0jEm7nRr5nzRE4s6zEUv9HEi6vAs0XHwjsVRWP
mCAJmki/+6qPwAxDb/sd+0h4Sr0T1XCbwPI8d2nMARLWpZz+2bCYwE4jJvWx
PwkfONJmUSGBK4ydKY6BJJzVvOhklUtglBlthgglISCts7MgjUD+FoM8n/Mk
MPuc3obHEBhRTtG5lkDCM1mSW9dpAlO2aYsHEkkIWjyVYHaKwCfb1aJ8k0gw
P7vefTCMQLRVct+fQcJK3SfO8AuB3EcKzQWZJFiutficEkBgGH6B0eskWBeq
h8j9CZTsmDUNyCWBNh5fmbmXwNa66Rsl+ST0bn+Y8ElA4Kj9Ry35LRLOv8rV
d+YTqNQwcXHz7yRodapF5nAIXLNrdPHREhKizfsyZ70J/C9GSk6f
               "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
         "HighlightElements" -> <|
           "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
          "LayoutOptions" -> <|
           "PlotRange" -> {All, All}, "Frame" -> {{True, True}, {True, True}},
             "AxesOrigin" -> {0.535599, 0.}, 
            "ImageSize" -> {450, 450/GoldenRatio}, "Axes" -> {True, True}, 
            "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
            "DefaultStyle" -> {
              Directive[
               Opacity[1.], 
               AbsoluteThickness[2], 
               RGBColor[1, 0, 0]]}, 
            "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
                Identity[
                 Part[#, 1]], 
                Identity[
                 Part[#, 2]]}& ), 
              "ScalingFunctions" -> {{Identity, Identity}, {
                Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
            False|>, 
          "Meta" -> <|
           "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
            Plot, "GroupHighlight" -> False|>|>]]& )[<|
        "HighlightElements" -> <|
          "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
         "LayoutOptions" -> <|
          "PlotRange" -> {All, All}, "Frame" -> {{True, True}, {True, True}}, 
           "AxesOrigin" -> {0.535599, 0.}, 
           "ImageSize" -> {450, 450/GoldenRatio}, "Axes" -> {True, True}, 
           "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
           "DefaultStyle" -> {
             Directive[
              Opacity[1.], 
              AbsoluteThickness[2], 
              RGBColor[1, 0, 0]]}, 
           "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
               Identity[
                Part[#, 1]], 
               Identity[
                Part[#, 2]]}& ), 
             "ScalingFunctions" -> {{Identity, Identity}, {
               Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
           False|>, 
         "Meta" -> <|
          "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
           Plot, "GroupHighlight" -> False|>|>]]}, 
     Annotation[{{{{}, {}, 
         Annotation[{
           Directive[
            Opacity[1.], 
            AbsoluteThickness[2], 
            RGBColor[1, 0, 0]], 
           Line[CompressedData["
1:eJwVxXk8lAkfAHBKW1urnFmMpaSEtmFVYtbvN6FQjzHjnsuMLiVLteSqKZRI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            "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
      "HighlightElements" -> <|
        "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
       "LayoutOptions" -> <|
        "PlotRange" -> {All, All}, "Frame" -> {{True, True}, {True, True}}, 
         "AxesOrigin" -> {0.535599, 0.}, 
         "ImageSize" -> {450, 450/GoldenRatio}, "Axes" -> {True, True}, 
         "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
         "DefaultStyle" -> {
           Directive[
            Opacity[1.], 
            AbsoluteThickness[2], 
            RGBColor[1, 0, 0]]}, 
         "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
             Identity[
              Part[#, 1]], 
             Identity[
              Part[#, 2]]}& ), 
           "ScalingFunctions" -> {{Identity, Identity}, {
             Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>, 
       "Meta" -> <|
        "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
         Plot, "GroupHighlight" -> False|>|>, "DynamicHighlight"]], {
    DisplayFunction -> Identity, DisplayFunction -> Identity, 
     Ticks -> {Automatic, Automatic}, AxesOrigin -> {0.535599, 0.}, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     GridLines -> {None, None}, DisplayFunction -> Identity, 
     PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.05], 
        Scaled[0.05]}}, PlotRangeClipping -> True, ImagePadding -> All, 
     DisplayFunction -> Identity, AspectRatio -> 
     NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
     AxesLabel -> {None, None}, AxesOrigin -> {0.535599, 0.}, DisplayFunction :> 
     Identity, Epilog -> {PointSize -> Medium, {
        PointBox[{0.0000319, 178.95}], 
        PointBox[{0.0000638, 173.19}], 
        PointBox[{0.0000957, 169.82}], 
        PointBox[{0.00012756, 167.42}], 
        PointBox[{0.00015946, 165.57}], 
        PointBox[{0.00019137, 164.05}], 
        PointBox[{0.00022328, 162.77}], 
        PointBox[{0.0002552, 161.66}], 
        PointBox[{0.00028711, 160.67}], 
        PointBox[{0.00031904, 159.8}], 
        PointBox[{0.00063851, 154.02}], 
        PointBox[{0.00095842, 150.64}], 
        PointBox[{0.0012788, 148.24}], 
        PointBox[{0.0015996, 146.37}], 
        PointBox[{0.0019208, 144.85}], 
        PointBox[{0.0022425, 143.55}], 
        PointBox[{0.0025646, 142.43}], 
        PointBox[{0.0028872, 141.44}], 
        PointBox[{0.0032102, 140.55}], 
        PointBox[{0.0064655, 134.68}], 
        PointBox[{0.0097676, 131.2}], 
        PointBox[{0.013118, 128.69}], 
        PointBox[{0.016519, 126.72}], 
        PointBox[{0.019972, 125.08}], 
        PointBox[{0.023479, 123.68}], 
        PointBox[{0.027044, 122.45}], 
        PointBox[{0.030667, 121.34}], 
        PointBox[{0.034351, 120.34}], 
        PointBox[{0.0753, 113.14}], 
        PointBox[{0.12749, 107.9}], 
        PointBox[{0.20492, 102.68}], 
        PointBox[{0.71774, 85.53}], 
        PointBox[{0.8327, 82.846}], 
        PointBox[{0.87947, 81.697}], 
        PointBox[{0.91145, 80.888}], 
        PointBox[{0.93632, 80.246}], 
        PointBox[{0.9569, 79.706}], 
        PointBox[{1.0764, 76.403}], 
        PointBox[{1.1436, 74.422}], 
        PointBox[{1.1924, 72.928}], 
        PointBox[{1.2313, 71.7}], 
        PointBox[{1.2641, 70.646}], 
        PointBox[{1.2925, 69.715}], 
        PointBox[{1.3177, 68.877}], 
        PointBox[{1.3405, 68.112}], 
        PointBox[{1.3612, 67.406}], 
        PointBox[{1.4449, 64.485}], 
        PointBox[{1.5084, 62.198}], 
        PointBox[{1.5603, 60.292}], 
        PointBox[{1.6046, 58.645}]}}, Frame -> {{True, True}, {True, True}}, 
     FrameLabel -> {{
        FormBox[
         TagBox[
         "\"\\!\\(\\*StyleBox[\\\"S\\\",FontSlant->\\\"Italic\\\"]\\) \
(J/mole/K)\"", HoldForm], TraditionalForm], None}, {
        FormBox[
         TagBox[
         "\"\[Rho] (g/\\!\\(\\*SuperscriptBox[\\(cm\\), \\(3\\)]\\))\"", 
          HoldForm], TraditionalForm], 
        FormBox[
         TagBox["\"ISOTHERM 150.7 K\"", HoldForm], TraditionalForm]}}, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     GridLines -> {None, None}, GridLinesStyle -> Directive[
       GrayLevel[0.5, 0.4]], ImageSize -> 450, 
     Method -> {
      "DefaultBoundaryStyle" -> Automatic, 
       "DefaultGraphicsInteraction" -> {
        "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
         "Effects" -> {
          "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
           "Droplines" -> {
            "freeformCursorMode" -> True, 
             "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
       "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> None,
        "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
           (Identity[#]& )[
            Part[#, 1]], 
           (Identity[#]& )[
            Part[#, 2]]}& ), "CopiedValueFunction" -> ({
           (Identity[#]& )[
            Part[#, 1]], 
           (Identity[#]& )[
            Part[#, 2]]}& )}}, PlotRange -> {All, All}, PlotRangeClipping -> 
     True, PlotRangePadding -> {{Automatic, Automatic}, {
       Automatic, Automatic}}, Ticks -> {Automatic, Automatic}}], 
   FormBox[
    TemplateBox[{"\[ThinSpace]", "\" \"", 
      FormBox[
       TemplateBox[{"\"NIST database\""}, "PointLegend", 
        DisplayFunction -> (FormBox[
          StyleBox[
           StyleBox[
            PaneBox[
             TagBox[
              GridBox[{{
                 TagBox[
                  GridBox[{{
                    GraphicsBox[{{}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    GrayLevel[0], 
                    AbsolutePointSize[6]], {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    GrayLevel[0], 
                    AbsolutePointSize[6]], 
                    PointBox[
                    NCache[{
                    Scaled[{
                    Rational[1, 2], 
                    Rational[1, 2]}]}, {
                    Scaled[{0.5, 0.5}]}]]}}}, AspectRatio -> Full, 
                    ImageSize -> {10, 12.5}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.18000000000000002`] -> 
                    Baseline)], #}}, 
                   GridBoxAlignment -> {
                    "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                   AutoDelete -> False, 
                   GridBoxDividers -> {
                    "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                   GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                   GridBoxSpacings -> {
                    "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
               GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}},
                AutoDelete -> False, 
               GridBoxItemSize -> {
                "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
               GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
              "Grid"], Alignment -> Left, AppearanceElements -> None, 
             ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
             "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
           FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
           False], TraditionalForm]& ), 
        InterpretationFunction :> (RowBox[{"PointLegend", "[", 
           RowBox[{
             RowBox[{"{", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   
                   TemplateBox[<|"color" -> GrayLevel[0]|>, 
                    "GrayLevelColorSwatchTemplate"], ",", 
                   RowBox[{"AbsolutePointSize", "[", "6", "]"}]}], "]"}], 
               "}"}], ",", 
             RowBox[{"{", #, "}"}]}], "]"}]& ), Editable -> True], 
       TraditionalForm], 
      FormBox[
       TemplateBox[{
        "\"StotalAdimNv[\\!\\(\\*StyleBox[\\\"T\\\",FontSlant->\\\"Italic\\\"]\
\\),\[Rho]]\""}, "LineLegend", DisplayFunction -> (FormBox[
          StyleBox[
           StyleBox[
            PaneBox[
             TagBox[
              GridBox[{{
                 TagBox[
                  GridBox[{{
                    GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[1, 0, 0]], {
                    LineBox[{{0, 12.5}, {20, 12.5}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[1, 0, 0]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 12.5}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.18000000000000002`] -> 
                    Baseline)], #}}, 
                   GridBoxAlignment -> {
                    "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                   AutoDelete -> False, 
                   GridBoxDividers -> {
                    "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                   GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                   GridBoxSpacings -> {
                    "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
               GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}},
                AutoDelete -> False, 
               GridBoxItemSize -> {
                "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
               GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
              "Grid"], Alignment -> Left, AppearanceElements -> None, 
             ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
             "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
           FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
           False], TraditionalForm]& ), 
        InterpretationFunction :> (RowBox[{"LineLegend", "[", 
           RowBox[{
             RowBox[{"{", 
               
               TemplateBox[<|"color" -> RGBColor[1, 0, 0]|>, 
                "RGBColorSwatchTemplate"], "}"}], ",", 
             RowBox[{"{", #, "}"}]}], "]"}]& ), Editable -> True], 
       TraditionalForm]}, "RowWithSeparators"], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"]}, {
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "Below"}], "]"}]}], "]"}]& )]], "Output",
 CellLabel->"Out[3]=",
 CellID->103670911,ExpressionUUID->"4dd134d8-f97a-4882-9081-826583d86f5c"]
}, Open  ]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "2"}, 
  Closed]]]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "PrimaryExamplesSection"}, 
  Closed]]]],

Cell[BoxData[GridBox[{
   {
    DynamicBox[FEPrivate`ImportImage[
      FrontEnd`FileName[{"Documentation", "FooterIcons"}, 
       "RelatedFunction.png"]],
     ImageSizeCache->{50., {27., 33.}}], GridBox[{
      {
       StyleBox[
        RowBox[{"See", " ", "Also"}], "SeeAlsoSection"]},
      {Cell[TextData[{
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["RhoArgonNv"]], "paclet:NewEoSArgon/ref/RhoArgonNv", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "693b1895-9c46-46f2-9177-822b82d97d8b"],
        "\[NonBreakingSpace]",
        StyleBox[
        "\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
         "InlineSeparator"],
        " ",
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["FtotalAdimNv"]], "paclet:NewEoSArgon/ref/FtotalAdimNv", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "a5be3481-a7d7-462a-a20a-e7bb5ee0c8b0"]
       }], "SeeAlso",ExpressionUUID->"f0a447ef-8c85-4e21-ac9c-7325e51a5734"]}
     }]}
  }]], "SeeAlsoSection",ExpressionUUID->"bdf03b8c-69bd-4432-a790-\
298769914b71"],

Cell[BoxData[GridBox[{
   {
    DynamicBox[FEPrivate`ImportImage[
      FrontEnd`FileName[{"Documentation", "FooterIcons"}, "RelatedGuide.png"]],
     ImageSizeCache->{50., {27., 33.}}], GridBox[{
      {
       StyleBox[
        RowBox[{"Related", " ", "Guides"}], "MoreAboutSection"]},
      {
       RowBox[{"\[FilledVerySmallSquare]", Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["NewEoSArgon Package"]], 
           "paclet:NewEoSArgon/guide/NewEoSArgon"},
          "RefLinkPlain",
          BaseStyle->{"MoreAbout"}]], "MoreAbout",ExpressionUUID->
         "ba19f69b-cc88-4e33-ad59-9fbaa1edb489"]}]}
     }]}
  }]], "MoreAboutSection",ExpressionUUID->"87a3d17c-558e-4cab-a7e0-\
808fe7bd56cb"],

Cell[BoxData[GridBox[{
   {
    TemplateBox[{29},
     "Spacer1"], GridBox[{
      {
       RowBox[{
        TemplateBox[{17},
         "Spacer1"], 
        StyleBox[
         RowBox[{"Related", " ", "Links"}], "RelatedLinksSection"]}]},
      {Cell[BoxData[Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData[
             RowBox[{
               RowBox[{"Units", " ", "&"}], " ", "Quantities"}]]], 
           "paclet:guide/Units"},
          "RefLinkPlain",
          BaseStyle->{"RelatedLinks"}]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "b8a1bda7-bacf-4bac-9e03-e9eb4df8afe5"]], "RelatedLinks",
        ExpressionUUID->"f9e19e80-aee0-498d-9d39-5d36d0ecb722"]},
      {Cell[BoxData[Cell[BoxData[Cell[BoxData[
          RowBox[{
           TemplateBox[{16},
            "Spacer1"], "\[FilledVerySmallSquare]", 
           TemplateBox[{
             Cell[
              TextData[
               Cell[
                TextData[{
                  Cell[
                   BoxData[
                    TemplateBox[{2}, "Spacer1"]]], "ThermodynamicData"}]]]], 
             "paclet:ref/ThermodynamicData"},
            "RefLink",
            BaseStyle->{"RelatedLinks"}]}]],ExpressionUUID->
          "6795ec3c-3824-4e75-b930-fd9a45f58020"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "4fe3c02e-8314-4ab4-9dca-d77e7a67d325"]], "RelatedLinks",
        ExpressionUUID->"757064cf-0141-403f-8b3a-cdf7c3bf2a34"]}
     }]}
  }]], "RelatedLinksSection",ExpressionUUID->"ff04e112-0b48-4efc-a326-\
99638391fb5c"],

Cell[" ", "FooterCell",ExpressionUUID->"97c9c906-fa67-47e0-bc26-18baa54efde0"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{900, 835.8},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"StotalAdimNv",
TaggingRules->{
 "ModificationHighlight" -> False, "ColorType" -> "", "LinkTrails" -> "", 
  "HasOptions" -> True, "ExampleCounter" -> 1, 
  "Openers" -> {
   "PrimaryExamplesSection" -> Open, 
    "ExampleSection" -> {"0" -> Open, "2" -> Closed}, "NotesSection" -> 
    Closed}, "NewStyles" -> True, "CitationPopupData" -> $Failed, 
  "ShowCitation" -> False, "RootCaptions" -> "", 
  "Metadata" -> {
   "built" -> "{2023, 11, 30, 13, 56, 7.9312751}", 
    "history" -> {"XX", "", "", ""}, "context" -> "NewEoSArgon`", 
    "keywords" -> {}, "specialkeywords" -> {}, 
    "tutorialcollectionlinks" -> {}, "index" -> True, "label" -> 
    "New Eo S Argon Package Symbol", "language" -> "en", "paclet" -> 
    "NewEoSArgon Package", "status" -> "None", "summary" -> 
    "StotalAdimNv[T, \\[Rho]] \\[Congruent] S/R Entropie adimensionnelle en \
fonction de T (Kelvin) et \\[Rho] (g/cm^3) [Non-dimensionnal entropy versus T \
(Kelvin) and \\[Rho] (g/cm^3)]", "synonyms" -> {}, "tabletags" -> {}, "title" -> 
    "StotalAdimNv", "titlemodifier" -> "", "metadescription" -> "", 
    "windowtitle" -> "StotalAdimNv", "type" -> "Symbol", "uri" -> 
    "NewEoSArgon/ref/StotalAdimNv"}},
CellContext->"Global`",
FrontEndVersion->"13.3 pour Microsoft Windows (64-bit) (July 24, 2023)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "13.3 pour Microsoft Windows (64-bit) (July 24, 2023)", 
  StyleDefinitions -> "Default.nb"],
ExpressionUUID->"9bbdbfad-7a0d-44e4-8caa-135707ac20d3"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[10311, 283, 1420, 37, 35, "PrimaryExamplesSection",ExpressionUUID->"0af2eadb-f53e-4410-9900-4f8568537bfd",
   CellTags->"PrimaryExamplesSection",
   CellID->127113187]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 70113, 1644}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[584, 21, 5332, 130, 56, "AnchorBarGrid",ExpressionUUID->"3ac329df-aced-47e0-b950-d7d7c5f291ff",
 CellID->1],
Cell[5919, 153, 94, 0, 23, "ContextNameCell",ExpressionUUID->"fd347afb-f5a1-4b44-be79-5739dd51b126"],
Cell[CellGroupData[{
Cell[6038, 157, 555, 14, 56, "ObjectNameGrid",ExpressionUUID->"c72527d3-50c8-4fb5-b9bd-c2ab75ddf63d"],
Cell[6596, 173, 991, 29, 146, "Usage",ExpressionUUID->"e6a36fb7-0ad8-4a3b-bc74-80052ecc9d6e"]
}, Open  ]],
Cell[CellGroupData[{
Cell[7624, 207, 1919, 48, 37, "NotesSection",ExpressionUUID->"58f83cd3-cfd9-423e-bc38-2f19a7429c48",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->380956477],
Cell[9546, 257, 235, 6, 36, "Notes",ExpressionUUID->"9d81b9b4-69e7-45e6-bac8-d80e0c11b2b6",
 CellID->1067943069],
Cell[9784, 265, 185, 4, 36, "Notes",ExpressionUUID->"90e79ced-f11f-4968-aea5-99668367118f",
 CellID->185021568],
Cell[9972, 271, 212, 6, 36, "Notes",ExpressionUUID->"8ea07c27-b295-4e68-b75b-4ac1e6074141",
 CellID->175218415]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "NotesSection"}, Closed]]]],
Cell[CellGroupData[{
Cell[10311, 283, 1420, 37, 35, "PrimaryExamplesSection",ExpressionUUID->"0af2eadb-f53e-4410-9900-4f8568537bfd",
 CellTags->"PrimaryExamplesSection",
 CellID->127113187],
Cell[CellGroupData[{
Cell[11756, 324, 1398, 36, 30, "ExampleSection",ExpressionUUID->"41caf944-9fdb-408b-8d71-e1150cb376a0",
 CellID->425197576],
Cell[13157, 362, 268, 5, 42, "Input",ExpressionUUID->"af527d2f-f23f-42b6-8bc5-a1987051d008",
 CellID->143015886],
Cell[13428, 369, 329, 7, 38, "ExampleText",ExpressionUUID->"376a31a3-58fa-4fa0-a95b-27837776aa3a",
 CellID->544149791],
Cell[CellGroupData[{
Cell[13782, 380, 1131, 28, 57, "Input",ExpressionUUID->"d7473c58-96dc-4c57-b3a1-584095d80cca",
 CellID->5710145],
Cell[14916, 410, 697, 15, 45, "Output",ExpressionUUID->"5f025169-5165-4b9c-be38-432490d864e8",
 CellID->286211667]
}, Open  ]],
Cell[CellGroupData[{
Cell[15650, 430, 591, 15, 46, "Input",ExpressionUUID->"263d4153-c6db-41d5-a996-2cd8535a6eab",
 CellID->2876315],
Cell[16244, 447, 436, 10, 43, "Output",ExpressionUUID->"415f1e9f-f658-49b4-8225-df25c6bd017f",
 CellID->240276877]
}, Open  ]],
Cell[16695, 460, 154, 1, 38, "ExampleText",ExpressionUUID->"9aa04035-22c7-48a2-86d7-105eb61ef25f",
 CellID->361149294],
Cell[CellGroupData[{
Cell[16874, 465, 650, 15, 42, "Input",ExpressionUUID->"58361fdc-e15e-45b0-aa29-d31958c9bed1",
 CellID->375583457],
Cell[17527, 482, 436, 10, 43, "Output",ExpressionUUID->"8c49a132-0c3f-43c6-b3a3-6c4b0c25eefa",
 CellID->170622407]
}, Open  ]],
Cell[17978, 495, 139, 1, 38, "ExampleText",ExpressionUUID->"057b1f31-b7e5-455d-80b7-5284254ae413",
 CellID->286706321],
Cell[CellGroupData[{
Cell[18142, 500, 952, 24, 46, "Input",ExpressionUUID->"8b135769-b9e7-4e3b-babe-43cc363d844c",
 CellID->605199954],
Cell[19097, 526, 15337, 302, 345, "Output",ExpressionUUID->"1063e17c-a740-4e72-b008-a7b1035d2ac3",
 CellID->865202625]
}, Open  ]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"}, Closed]]]],
Cell[CellGroupData[{
Cell[34583, 836, 1419, 37, 70, "ExampleSection",ExpressionUUID->"eaa5a026-4717-4b70-882a-e1f07166ad70",
 CellID->258228157],
Cell[36005, 875, 174, 3, 70, "Input",ExpressionUUID->"cf021c17-c2c9-4bfd-ab36-dbc29aca0043",
 CellID->87419684],
Cell[36182, 880, 401, 11, 70, "ExampleText",ExpressionUUID->"6d6e3a22-8da1-495e-998b-afe20962455b",
 CellID->227520913],
Cell[36586, 893, 464, 13, 70, "Input",ExpressionUUID->"63ecc5ac-573d-4eb5-ab20-5102087cde7f",
 CellID->531122037],
Cell[CellGroupData[{
Cell[37075, 910, 2454, 68, 70, "Input",ExpressionUUID->"ffc9a9cc-cbe7-4b02-b20f-a526526abd1b",
 CellID->136921489],
Cell[39532, 980, 24536, 504, 359, "Output",ExpressionUUID->"4dd134d8-f97a-4882-9081-826583d86f5c",
 CellID->103670911]
}, Open  ]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "2"}, Closed]]]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "PrimaryExamplesSection"}, Closed]]]],
Cell[64310, 1493, 1375, 36, 70, "SeeAlsoSection",ExpressionUUID->"bdf03b8c-69bd-4432-a790-298769914b71"],
Cell[65688, 1531, 729, 19, 70, "MoreAboutSection",ExpressionUUID->"87a3d17c-558e-4cab-a7e0-808fe7bd56cb"],
Cell[66420, 1552, 1607, 43, 70, "RelatedLinksSection",ExpressionUUID->"ff04e112-0b48-4efc-a326-99638391fb5c"],
Cell[68030, 1597, 78, 0, 70, "FooterCell",ExpressionUUID->"97c9c906-fa67-47e0-bc26-18baa54efde0"]
}
]
*)

(* End of internal cache information *)

