(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 13.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     67823,       1436]
NotebookOptionsPosition[     61625,       1308]
NotebookOutlinePosition[     64093,       1369]
CellTagsIndexPosition[     63971,       1363]
WindowTitle->TRhoSat
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[GridBox[{
   {GridBox[{
      {
       ItemBox[Cell[BoxData[
         RowBox[{
          TemplateBox[{12},
           "Spacer1"], Cell["NEW EO S ARGON PACKAGE SYMBOL", "PacletNameCell",
           TextAlignment->Center,ExpressionUUID->
           "0dd30054-4f46-49d9-aeda-711c8fada79f"], 
          TemplateBox[{8},
           "Spacer1"]}]],
         TextAlignment->Center,ExpressionUUID->
         "3033bca8-a46a-46c9-9e3e-14bfdb3acdb3"],
        Background->RGBColor[0.490196, 0.576471, 0.690196],
        ItemSize->Full], ""}
     },
     GridBoxAlignment->{"Rows" -> {{Center}}},
     GridBoxItemSize->{"Columns" -> {Full, 
         Scaled[0.02]}, "Rows" -> {{2.5}}}], Cell[TextData[{
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "See Also",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "ec259f46-c5f6-4f23-8c12-6886d007e4a3"]
         }],ExpressionUUID->"579cf4c4-9ed5-4108-81df-5b23730bd875"],
         StripOnInput->False],{
        "\"ttr\"" :> Documentation`HelpLookup["paclet:NewEoSArgon/ref/ttr"], 
         "\"tcNv\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/tcNv"], 
         "\"rhotrgaz\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/rhotrgaz"], 
         "\"rhotrliq\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/rhotrliq"], 
         "\"TSatNIST\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/TSatNIST"], 
         "\"PRhoSat\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/PRhoSat"]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"SeeAlso"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "81d81bbf-a2da-4fc0-b10e-dfe866af8c47"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "Related Guides",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "609d2f0c-10f8-4434-a5de-3289b910c1cf"]
         }],ExpressionUUID->"404f3f7c-96fb-4a72-9038-1218a6dd84f6"],
         StripOnInput->False],{
        "\"NewEoSArgon package\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/guide/NewEoSArgon"]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"MoreAbout"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "d72263ef-bf57-4b06-9c6e-de75d4f6640a"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "URL",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "bce04075-58f3-4da5-be1d-7ce8fae8fdf0"]
         }],ExpressionUUID->"5750bda2-7f26-4f37-934e-936f348b0ddb"],
         StripOnInput->False],{
        "\"NewEoSArgon/ref/TRhoSsat\"" :> None, 
         "\"Copy Wolfram Documentation Center URL\"" :> 
         Module[{DocumentationSearch`Private`nb$}, 
           DocumentationSearch`Private`nb$ = 
            NotebookPut[
             Notebook[{Cell["NewEoSArgon/ref/TRhoSsat"]}, Visible -> False]]; 
           SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
           FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
           NotebookClose[DocumentationSearch`Private`nb$]; Null], Delimiter, 
         "\"Copy web URL\"" :> 
         Module[{DocumentationSearch`Private`nb$}, 
           DocumentationSearch`Private`nb$ = 
            NotebookPut[
             Notebook[{
               Cell[BoxData[
                 MakeBoxes[
                  Hyperlink[
                   "http://reference.wolfram.com/language/NewEoSArgon/ref/\
TRhoSsat.html"], StandardForm]], "Input", TextClipboardType -> "PlainText"]}, 
               Visible -> False]]; 
           SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
           FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
           NotebookClose[DocumentationSearch`Private`nb$]; Null], 
         "\"Go to web URL\"" :> 
         FrontEndExecute[{
           NotebookLocate[{
             URL[If[TrueQ[DocumentationBuild`Make`Private`wsmlinkQ$31919], 
                 "http://reference.wolfram.com/system-modeler/", 
                 "http://reference.wolfram.com/language/"] <> 
               "NewEoSArgon/ref/TRhoSsat" <> ".html"], None}]}]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"URLMenu"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "017808b1-24ff-44d5-aa21-9bf9f304870a"]
    }], "AnchorBar",
     CacheGraphics->False,ExpressionUUID->
     "9cae21d8-8524-4f61-9938-718f56453692"]}
  }]], "AnchorBarGrid",
 CellID->1,ExpressionUUID->"209e2213-3686-48b8-bdaa-ce8ed9a5f8f8"],

Cell["NewEoSArgon`", "ContextNameCell",ExpressionUUID->"30aec7b7-e1a8-439a-829f-24f02d3b1c76"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     Cell[
     "TRhoSat", "ObjectName",ExpressionUUID->
      "75529301-ca38-442b-aa96-ed21129fdb36"],
     Cell[BoxData[
      TemplateBox[{8},
       "Spacer1"]],ExpressionUUID->"ee2299bb-b2d8-47a2-8f75-8b785e0cf8c7"],
     Cell[BoxData[
     ""], "ObjectNameTranslation",ExpressionUUID->
      "92aa3f7c-850f-4d46-a042-8b92e67db715"]
    }],ExpressionUUID->"a137218e-84da-4380-87f2-a7febb86df40"], 
    "\[SpanFromLeft]"}
  }]], "ObjectNameGrid",ExpressionUUID->"30235695-6fe2-436e-89ff-\
15ee9e179be4"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     "TRhoSat[\[Rho]] \[Congruent] ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["T",
        FontSlant->"Italic"], "\[Sigma]"]],ExpressionUUID->
      "d3732130-f5f6-4d65-9ef7-5985af5f1770"],
     " (Kelvin)\nTemp\[EAcute]rature sur la courbe de saturation en fonction \
de \[Rho] (g/",
     Cell[BoxData[
      SuperscriptBox["cm", "3"]], "InlineFormula",
      FontFamily->"Source Sans Pro",ExpressionUUID->
      "3bb6494a-34ae-4efb-b08a-10f2743b659a"],
     ")\n[Fitting function of the saturation temperature versus \[Rho] (g/",
     Cell[BoxData[
      SuperscriptBox["cm", "3"]], "InlineFormula",
      FontFamily->"Source Sans Pro",ExpressionUUID->
      "b00ac1ef-55e4-4afa-8c76-75a5b9dab33b"],
     ")]"
    }],ExpressionUUID->"ff4f7bfe-3422-4867-8cc3-386332859fef"]}
  }]], "Usage",ExpressionUUID->"501af892-95a1-4adc-b504-02a4625b9574"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[Cell[TextData[{
   Cell[BoxData[
    DynamicBox[ToBoxes[
      If[
       MatchQ[
        CurrentValue[
         EvaluationNotebook[], {TaggingRules, "Openers", "NotesSection"}, 
         Closed], 
        Alternatives[Open, True]], 
       Style[
        Graphics[{
          Thickness[0.18], 
          RGBColor[0.8509803921568627, 0.396078431372549, 0], 
          Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
         PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
        0.68 Inherited], 
       Rotate[
        Style[
         Graphics[{
           Thickness[0.18], 
           RGBColor[0.8509803921568627, 0.396078431372549, 0], 
           Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
          PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
         0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
     ImageSizeCache->{
      13.600000000000001`, {0.5800000000000001, 13.020000000000001`}}]],
    ExpressionUUID->"29b94e04-1e1d-4b4a-b48d-44bcd1336093"],
   Cell[BoxData[
    TemplateBox[{1},
     "Spacer1"]],ExpressionUUID->"ed9f1623-5ccc-44d3-ae14-38a7417d2dad"],
   "Details"
  }], "NotesFrameText",ExpressionUUID->"88f836df-3593-4cff-8320-9a9ff1759712"],
  Appearance->{Automatic, None, "Normal", Automatic},
  BaseStyle->None,
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"], 
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], After, CellContents]}]& ),
  Evaluator->None,
  Method->
   "Preemptive"]],ExpressionUUID->"ac164354-aafe-47ec-ba67-df85bd61de75"]], \
"NotesSection",
 WholeCellGroupOpener->True,
 CellGroupingRules->{"SectionGrouping", 50},
 CacheGraphics->False,
 CellID->583696783,ExpressionUUID->"7043d752-9b36-48e4-b59a-4e3157a6902c"],

Cell[TextData[{
 "La fonction est d\[EAcute]finie pour ",
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["\[Rho]trgaz"]], "paclet:NewEoSArgon/ref/rhotrgaz", 
    "NewEoSArgon Package Symbol"},
   "PackageLink",
   BaseStyle->"InlineFormula"]], "InlineFormula",
  FontFamily->"Source Sans Pro",ExpressionUUID->
  "5034e8c1-784e-4c6b-8471-e2f9a5998a25"],
 " \[LessEqual] \[Rho] \[LessEqual] ",
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["\[Rho]trliq"]], "paclet:NewEoSArgon/ref/rhotrliq", 
    "NewEoSArgon Package Symbol"},
   "PackageLink",
   BaseStyle->"InlineFormula"]], "InlineFormula",
  FontFamily->"Source Sans Pro",ExpressionUUID->
  "9d24d602-cca4-4726-81e4-5a2bb14c485a"]
}], "Notes",
 CellID->1067943069,ExpressionUUID->"eb3e02e8-ed89-44a9-93d6-da816c56fe58"],

Cell["\<\
******************************************************************************\
*****\
\>", "Notes",
 CellID->185021568,ExpressionUUID->"e95bea44-4779-40c3-944a-d6951765dddb"],

Cell[TextData[{
 "The function is defined for ",
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["\[Rho]trgaz"]], "paclet:NewEoSArgon/ref/rhotrgaz", 
    "NewEoSArgon Package Symbol"},
   "PackageLink",
   BaseStyle->"InlineFormula"]], "InlineFormula",
  FontFamily->"Source Sans Pro",ExpressionUUID->
  "0c9c39ff-6699-4fbd-8a1e-df8a11b45907"],
 " \[LessEqual] \[Rho] \[LessEqual] ",
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["\[Rho]trliq"]], "paclet:NewEoSArgon/ref/rhotrliq", 
    "NewEoSArgon Package Symbol"},
   "PackageLink",
   BaseStyle->"InlineFormula"]], "InlineFormula",
  FontFamily->"Source Sans Pro",ExpressionUUID->
  "558ecc75-be63-48fb-9fa8-4e39ac6f410f"]
}], "Notes",
 CellID->20759926,ExpressionUUID->"790ce115-ca1c-4c78-8d12-c1118de29955"]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "NotesSection"}, Closed]]]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {
       TaggingRules, "Openers", "PrimaryExamplesSection"}, Open], 
      Alternatives[True, Open]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{13.600000000000001`, {5., 8.600000000000001}}]],
  ExpressionUUID->"5a115e0a-a6b9-4baa-9215-475dc314d399"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"844e204b-e921-4000-bb05-860ab77b8fa2"],
 "Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "907131a6-d1e7-4437-94fa-7ea5345b91dc"]
}], "PrimaryExamplesSection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellTags->"PrimaryExamplesSection",
 CellID->211881788,ExpressionUUID->"6f11bceb-2bb8-4c2b-99ff-78f0b4c3a7c9"],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"},
        Closed], 
      Alternatives[Open, True]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{13.600000000000001`, {5., 8.600000000000001}}]],
  ExpressionUUID->"f5f889af-c2b1-4a51-b37e-4f58c6dfc565"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"b2cd4c64-da8b-47db-8441-1f4ed59e9610"],
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "84575f50-6614-4bd8-b16d-9822e9f7921b"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellID->570908607,ExpressionUUID->"07b9aa56-e26d-488d-bdcb-8facc9d455d5"],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<NewEoSArgon`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->87419684,ExpressionUUID->"265ae8f1-f9c6-42a4-a9b6-04861588914a"],

Cell["Calculate with physical dimension", "ExampleText",
 CellID->285078790,ExpressionUUID->"8341e2b4-0274-4299-8c13-ebf72c7dadd6"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Quantity", "[", 
  RowBox[{
   RowBox[{"TRhoSat", "[", "\[Rho]trgaz", "]"}], ",", "\"\<Kelvins\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->231987987,ExpressionUUID->"a5281f34-c92f-4f31-b456-e466ce1647da"],

Cell[BoxData[
 TemplateBox[{"83.79525609856708`", "\"K\"", "kelvins", "\"Kelvins\""},
  "Quantity"]], "Output",
 CellLabel->"Out[2]=",
 CellID->470727148,ExpressionUUID->"899e18ec-5242-4852-a71c-952091d25deb"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UnitConvert", "[", 
  RowBox[{
   TemplateBox[{"83.79525609856708`"},
    "QuantityUnit",
    DisplayFunction->(TooltipBox[
      StyleBox[
       RowBox[{#, "\[InvisibleSpace]", 
         StyleBox[
          RowBox[{" ", "\"K\""}], "QuantityUnitTraditionalLabel"]}], 
       ShowStringCharacters -> False], "Unit: kelvins"]& ),
    InterpretationFunction->(RowBox[{"Quantity", "[", 
       RowBox[{#, ",", "\"Kelvins\""}], "]"}]& )], ",", 
   "\"\<DegreesCelsius\>\""}], "]"}]], "Input",
 NumberMarks->False,
 CellLabel->"In[3]:=",
 CellID->67341159,ExpressionUUID->"c5c181dc-3fe1-4637-8a19-268edc96ec3b"],

Cell[BoxData[
 TemplateBox[{
   RowBox[{"-", "189.3547439014329`"}], "\"\[Degree]C\"", "degrees Celsius", 
   "\"DegreesCelsius\""},
  "Quantity"]], "Output",
 CellLabel->"Out[3]=",
 CellID->171534721,ExpressionUUID->"ed152733-01bd-4bf6-858f-4dad9ae4e540"]
}, Open  ]],

Cell["Relative error with NIST triple point temperature", "ExampleText",
 CellID->1251536,ExpressionUUID->"70256b85-f572-482b-b67a-c3c3c6e94065"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Quantity", "[", 
  RowBox[{
   RowBox[{"100", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Quantity", "[", 
        RowBox[{"ttr", ",", "\"\<Kelvins\>\""}], "]"}], "-", 
       RowBox[{"Quantity", "[", 
        RowBox[{
         RowBox[{"TRhoSat", "[", "\[Rho]trgaz", "]"}], ",", 
         "\"\<Kelvins\>\""}], "]"}]}], ")"}], "/", 
     RowBox[{"Quantity", "[", 
      RowBox[{"ttr", ",", "\"\<Kelvins\>\""}], "]"}]}]}], ",", "\"\<%\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->16757904,ExpressionUUID->"1b5fdc60-1b2b-40e3-912e-2cab92e08e6b"],

Cell[BoxData[
 TemplateBox[{"0.012581350494744924`", "\"%\"", "percent", "\"Percent\""},
  "QuantityPostfix"]], "Output",
 CellLabel->"Out[4]=",
 CellID->40314536,ExpressionUUID->"a86a0341-7aa6-4239-8683-6b48078ce220"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Quantity", "[", 
  RowBox[{
   RowBox[{"100", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Quantity", "[", 
        RowBox[{"ttr", ",", "\"\<Kelvins\>\""}], "]"}], "-", 
       RowBox[{"Quantity", "[", 
        RowBox[{
         RowBox[{"TRhoSat", "[", "\[Rho]trliq", "]"}], ",", 
         "\"\<Kelvins\>\""}], "]"}]}], ")"}], "/", 
     RowBox[{"Quantity", "[", 
      RowBox[{"ttr", ",", "\"\<Kelvins\>\""}], "]"}]}]}], ",", "\"\<%\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->238004640,ExpressionUUID->"ddc42642-87a5-4b9a-91ea-70da7149cca1"],

Cell[BoxData[
 TemplateBox[{
   RowBox[{"-", "0.00004046838782134072`"}], "\"%\"", "percent", 
   "\"Percent\""},
  "QuantityPostfix"]], "Output",
 CellLabel->"Out[5]=",
 CellID->455983648,ExpressionUUID->"13491268-dba1-4894-9142-2cb3d59d8628"]
}, Open  ]],

Cell["\<\
Plot function versus density and comparison with saturated curve from NIST\
\>", "ExampleText",
 CellID->886239600,ExpressionUUID->"277bef1e-d714-42c5-b888-838391bf23f2"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"TRhoSat", "[", "\[Rho]", "]"}], ",", 
     RowBox[{"TSatNIST", "[", "\[Rho]", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Rho]", ",", "\[Rho]trgaz", ",", "\[Rho]trliq"}], "}"}], ",", 
   RowBox[{"AxesOrigin", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\[Rho]c", ",", "ttr"}], "}"}]}], ",", 
   RowBox[{"Frame", "->", "True"}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Quantity", "[", 
       RowBox[{"\[Rho]", ",", "\"\<g/cm^3\>\""}], "]"}], ",", 
      RowBox[{"Quantity", "[", 
       RowBox[{"T", ",", "\"\<Kelvins\>\""}], "]"}]}], "}"}]}], ",", 
   RowBox[{"ImageSize", "\[Rule]", "400"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Red", ",", 
      RowBox[{"{", 
       RowBox[{"Black", ",", "Dashed"}], "}"}]}], "}"}]}], ",", 
   RowBox[{"PlotLegends", "\[Rule]", "\"\<Expressions\>\""}]}], 
  "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->2227668,ExpressionUUID->"d50be1da-fdc7-4467-8273-338c56dace86"],

Cell[BoxData[
 GraphicsBox[
  TagBox[RasterBox[CompressedData["
1:eJzs3X9sHOd54PGX1EpaW2ubcpmaTpmEtWmbTmSf2jIN47AWG6tnpVF8TKs2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    "], {{0, 261.}, {529., 0}}, {0, 255},
    ColorFunction->RGBColor,
    ImageResolution->{144., 144.},
    SmoothingQuality->"High"],
   BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
   Selectable->False],
  DefaultBaseStyle->"ImageGraphics",
  ImageSize->Automatic,
  ImageSizeRaw->{529., 261.},
  PlotRange->{{0, 529.}, {0, 261.}}]], "Output",
 CellTags->"RasterizedOutput",
 CellLabel->"Out[6]=",
 CellID->552284900,ExpressionUUID->"7e0c535e-1476-47a8-afcf-941f957993ec"]
}, Open  ]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"}, 
  Closed]]]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "PrimaryExamplesSection"}, 
  Closed]]]],

Cell[BoxData[GridBox[{
   {
    DynamicBox[FEPrivate`ImportImage[
      FrontEnd`FileName[{"Documentation", "FooterIcons"}, 
       "RelatedFunction.png"]],
     ImageSizeCache->{50., {27., 33.}}], GridBox[{
      {
       StyleBox[
        RowBox[{"See", " ", "Also"}], "SeeAlsoSection"]},
      {Cell[TextData[{
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["ttr"]], "paclet:NewEoSArgon/ref/ttr", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "c23ddca3-3cdf-4a2e-aa10-e1ae509d83f0"],
        "\[NonBreakingSpace]",
        StyleBox[
        "\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
         "InlineSeparator"],
        " ",
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["tcNv"]], "paclet:NewEoSArgon/ref/tcNv", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "e924f678-4842-41d3-85a2-5b1e2649e6da"],
        "\[NonBreakingSpace]",
        StyleBox[
        "\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
         "InlineSeparator"],
        " ",
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["rhotrgaz"]], "paclet:NewEoSArgon/ref/rhotrgaz", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "8cfa2a1c-c6f0-4064-be1e-f385ebaf84bc"],
        "\[NonBreakingSpace]",
        StyleBox[
        "\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
         "InlineSeparator"],
        " ",
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["rhotrliq"]], "paclet:NewEoSArgon/ref/rhotrliq", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "3d05bf68-aa84-40a5-8391-687ef3654568"],
        "\[NonBreakingSpace]",
        StyleBox[
        "\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
         "InlineSeparator"],
        " ",
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["TSatNIST"]], "paclet:NewEoSArgon/ref/TSatNIST", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "5a06aae1-7991-487d-a900-f2082b613656"],
        "\[NonBreakingSpace]",
        StyleBox[
        "\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
         "InlineSeparator"],
        " ",
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["PRhoSat"]], "paclet:NewEoSArgon/ref/PRhoSat", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "e7ad1062-2edb-463c-ac2f-252bc92c1c06"]
       }], "SeeAlso",ExpressionUUID->"486dd311-2a33-4061-b0a3-c0819945fb3f"]}
     }]}
  }]], "SeeAlsoSection",ExpressionUUID->"faf17669-f640-41ca-a863-\
92a30128d9eb"],

Cell[BoxData[GridBox[{
   {
    DynamicBox[FEPrivate`ImportImage[
      FrontEnd`FileName[{"Documentation", "FooterIcons"}, "RelatedGuide.png"]],
     ImageSizeCache->{50., {27., 33.}}], GridBox[{
      {
       StyleBox[
        RowBox[{"Related", " ", "Guides"}], "MoreAboutSection"]},
      {
       RowBox[{"\[FilledVerySmallSquare]", Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["NewEoSArgon package"]], 
           "paclet:NewEoSArgon/guide/NewEoSArgon"},
          "RefLinkPlain",
          BaseStyle->{"MoreAbout"}]], "MoreAbout",ExpressionUUID->
         "b39552b2-71da-424b-8640-ad8fe2099094"]}]}
     }]}
  }]], "MoreAboutSection",ExpressionUUID->"b3153f06-f970-49b8-b84d-\
7cfc1ab62bf5"],

Cell[BoxData[GridBox[{
   {
    TemplateBox[{29},
     "Spacer1"], GridBox[{
      {
       RowBox[{
        TemplateBox[{17},
         "Spacer1"], 
        StyleBox[
         RowBox[{"Related", " ", "Links"}], "RelatedLinksSection"]}]},
      {Cell[BoxData[Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData[
             RowBox[{
               RowBox[{"Units", " ", "&"}], " ", "Quantities"}]]], 
           "paclet:guide/Units"},
          "RefLinkPlain",
          BaseStyle->{"RelatedLinks"}]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "3015a9af-a6a6-4a40-bfb8-d32e310b3adc"]], "RelatedLinks",
        ExpressionUUID->"5246fdb2-ff59-4673-b928-e687c1e84f2a"]}
     }]}
  }]], "RelatedLinksSection",ExpressionUUID->"98a0d189-d019-474e-ad8d-\
27552de6a2d4"],

Cell[" ", "FooterCell",ExpressionUUID->"0431419d-64ad-4754-bddb-253d19add321"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{900, 835.8},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"TRhoSat",
TaggingRules->{
 "ModificationHighlight" -> False, "ColorType" -> "", "LinkTrails" -> "", 
  "ExampleCounter" -> 1, 
  "Openers" -> {
   "PrimaryExamplesSection" -> Open, "ExampleSection" -> {"0" -> Open}, 
    "NotesSection" -> Closed}, "NewStyles" -> True, 
  "CitationPopupData" -> $Failed, "ShowCitation" -> False, "RootCaptions" -> 
  "", "Metadata" -> {
   "built" -> "{2023, 11, 30, 13, 56, 12.4109705}", 
    "history" -> {"XX", "", "", ""}, "context" -> "NewEoSArgon`", 
    "keywords" -> {}, "specialkeywords" -> {}, 
    "tutorialcollectionlinks" -> {}, "index" -> True, "label" -> 
    "New Eo S Argon Package Symbol", "language" -> "en", "paclet" -> 
    "NewEoSArgon Package", "status" -> "None", "summary" -> 
    "TRhoSat[\\[Rho]] \\[Congruent] T\\[Sigma] (Kelvin) Temp\[EAcute]rature \
sur la courbe de saturation en fonction de \\[Rho] (g/cm^3) [Fitting function \
of the saturation temperature versus \\[Rho] (g/cm^3)]", "synonyms" -> {}, 
    "tabletags" -> {}, "title" -> "TRhoSat", "titlemodifier" -> "", 
    "metadescription" -> "", "windowtitle" -> "TRhoSat", "type" -> "Symbol", 
    "uri" -> "NewEoSArgon/ref/TRhoSsat"}},
CellContext->"Global`",
FrontEndVersion->"13.3 pour Microsoft Windows (64-bit) (July 24, 2023)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "13.3 pour Microsoft Windows (64-bit) (July 24, 2023)", 
  StyleDefinitions -> "Default.nb"],
ExpressionUUID->"a72213e9-ed92-4682-a9b4-49cf017667af"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[11648, 313, 1420, 37, 35, "PrimaryExamplesSection",ExpressionUUID->"6f11bceb-2bb8-4c2b-99ff-78f0b4c3a7c9",
   CellTags->"PrimaryExamplesSection",
   CellID->211881788]},
 "RasterizedOutput"->{
  Cell[19421, 545, 36898, 611, 282, "Output",ExpressionUUID->"7e0c535e-1476-47a8-afcf-941f957993ec",
   CellTags->"RasterizedOutput",
   CellID->552284900]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 63590, 1352},
 {"RasterizedOutput", 63790, 1356}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[579, 21, 5652, 136, 56, "AnchorBarGrid",ExpressionUUID->"209e2213-3686-48b8-bdaa-ce8ed9a5f8f8",
 CellID->1],
Cell[6234, 159, 94, 0, 23, "ContextNameCell",ExpressionUUID->"30aec7b7-e1a8-439a-829f-24f02d3b1c76"],
Cell[CellGroupData[{
Cell[6353, 163, 550, 14, 56, "ObjectNameGrid",ExpressionUUID->"30235695-6fe2-436e-89ff-15ee9e179be4"],
Cell[6906, 179, 908, 21, 146, "Usage",ExpressionUUID->"501af892-95a1-4adc-b504-02a4625b9574"]
}, Open  ]],
Cell[CellGroupData[{
Cell[7851, 205, 1907, 48, 37, "NotesSection",ExpressionUUID->"7043d752-9b36-48e4-b59a-4e3157a6902c",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->583696783],
Cell[9761, 255, 790, 22, 38, "Notes",ExpressionUUID->"eb3e02e8-ed89-44a9-93d6-da816c56fe58",
 CellID->1067943069],
Cell[10554, 279, 185, 4, 36, "Notes",ExpressionUUID->"e95bea44-4779-40c3-944a-d6951765dddb",
 CellID->185021568],
Cell[10742, 285, 779, 22, 38, "Notes",ExpressionUUID->"790ce115-ca1c-4c78-8d12-c1118de29955",
 CellID->20759926]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "NotesSection"}, Closed]]]],
Cell[CellGroupData[{
Cell[11648, 313, 1420, 37, 35, "PrimaryExamplesSection",ExpressionUUID->"6f11bceb-2bb8-4c2b-99ff-78f0b4c3a7c9",
 CellTags->"PrimaryExamplesSection",
 CellID->211881788],
Cell[CellGroupData[{
Cell[13093, 354, 1398, 36, 30, "ExampleSection",ExpressionUUID->"07b9aa56-e26d-488d-bdcb-8facc9d455d5",
 CellID->570908607],
Cell[14494, 392, 174, 3, 26, "Input",ExpressionUUID->"265ae8f1-f9c6-42a4-a9b6-04861588914a",
 CellID->87419684],
Cell[14671, 397, 131, 1, 38, "ExampleText",ExpressionUUID->"8341e2b4-0274-4299-8c13-ebf72c7dadd6",
 CellID->285078790],
Cell[CellGroupData[{
Cell[14827, 402, 244, 6, 26, "Input",ExpressionUUID->"a5281f34-c92f-4f31-b456-e466ce1647da",
 CellID->231987987],
Cell[15074, 410, 209, 4, 39, "Output",ExpressionUUID->"899e18ec-5242-4852-a71c-952091d25deb",
 CellID->470727148]
}, Open  ]],
Cell[CellGroupData[{
Cell[15320, 419, 630, 16, 26, "Input",ExpressionUUID->"c5c181dc-3fe1-4637-8a19-268edc96ec3b",
 CellID->67341159],
Cell[15953, 437, 256, 6, 40, "Output",ExpressionUUID->"ed152733-01bd-4bf6-858f-4dad9ae4e540",
 CellID->171534721]
}, Open  ]],
Cell[16224, 446, 145, 1, 38, "ExampleText",ExpressionUUID->"70256b85-f572-482b-b67a-c3c3c6e94065",
 CellID->1251536],
Cell[CellGroupData[{
Cell[16394, 451, 601, 17, 26, "Input",ExpressionUUID->"1b5fdc60-1b2b-40e3-912e-2cab92e08e6b",
 CellID->16757904],
Cell[16998, 470, 218, 4, 40, "Output",ExpressionUUID->"a86a0341-7aa6-4239-8683-6b48078ce220",
 CellID->40314536]
}, Open  ]],
Cell[CellGroupData[{
Cell[17253, 479, 602, 17, 26, "Input",ExpressionUUID->"ddc42642-87a5-4b9a-91ea-70da7149cca1",
 CellID->238004640],
Cell[17858, 498, 244, 6, 40, "Output",ExpressionUUID->"13491268-dba1-4894-9142-2cb3d59d8628",
 CellID->455983648]
}, Open  ]],
Cell[18117, 507, 180, 3, 38, "ExampleText",ExpressionUUID->"277bef1e-d714-42c5-b888-838391bf23f2",
 CellID->886239600],
Cell[CellGroupData[{
Cell[18322, 514, 1096, 29, 57, "Input",ExpressionUUID->"d50be1da-fdc7-4467-8273-338c56dace86",
 CellID->2227668],
Cell[19421, 545, 36898, 611, 282, "Output",ExpressionUUID->"7e0c535e-1476-47a8-afcf-941f957993ec",
 CellTags->"RasterizedOutput",
 CellID->552284900]
}, Open  ]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"}, Closed]]]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "PrimaryExamplesSection"}, Closed]]]],
Cell[56561, 1165, 3419, 92, 70, "SeeAlsoSection",ExpressionUUID->"faf17669-f640-41ca-a863-92a30128d9eb"],
Cell[59983, 1259, 729, 19, 70, "MoreAboutSection",ExpressionUUID->"b3153f06-f970-49b8-b84d-7cfc1ab62bf5"],
Cell[60715, 1280, 825, 24, 70, "RelatedLinksSection",ExpressionUUID->"98a0d189-d019-474e-ad8d-27552de6a2d4"],
Cell[61543, 1306, 78, 0, 70, "FooterCell",ExpressionUUID->"0431419d-64ad-4754-bddb-253d19add321"]
}
]
*)

(* End of internal cache information *)

