(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 13.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     63831,       1374]
NotebookOptionsPosition[     58448,       1265]
NotebookOutlinePosition[     60772,       1322]
CellTagsIndexPosition[     60686,       1317]
WindowTitle->TSatNIST
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[GridBox[{
   {GridBox[{
      {
       ItemBox[Cell[BoxData[
         RowBox[{
          TemplateBox[{12},
           "Spacer1"], Cell["NEW EO S ARGON PACKAGE SYMBOL", "PacletNameCell",
           TextAlignment->Center,ExpressionUUID->
           "056ea15d-5a0a-44a1-868b-12f59552b8c8"], 
          TemplateBox[{8},
           "Spacer1"]}]],
         TextAlignment->Center,ExpressionUUID->
         "46711802-1b5a-4019-b9ee-f6f920ec2635"],
        Background->RGBColor[0.490196, 0.576471, 0.690196],
        ItemSize->Full], ""}
     },
     GridBoxAlignment->{"Rows" -> {{Center}}},
     GridBoxItemSize->{"Columns" -> {Full, 
         Scaled[0.02]}, "Rows" -> {{2.5}}}], Cell[TextData[{
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "See Also",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "ad0cb7e3-c973-4845-83f8-0e1b2a22b9d7"]
         }],ExpressionUUID->"92492259-8cef-4875-b108-c4ec7d7b220e"],
         StripOnInput->False],{
        "\"ttr\"" :> Documentation`HelpLookup["paclet:NewEoSArgon/ref/ttr"], 
         "\"tc\"" :> Documentation`HelpLookup["paclet:NewEoSArgon/ref/tc"], 
         "\"rhotrgaz\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/rhotrgaz"], 
         "\"rhotrliq\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/rhotrliq"], 
         "\"PRhoSatNIST\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/PRhoSatNIST"]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"SeeAlso"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "ccd3f858-622f-42af-97de-a286f246bbee"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "Related Guides",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "db9fae21-0e33-45a3-9728-1ddc91af1810"]
         }],ExpressionUUID->"f2ebe7a0-4f9c-4389-b258-4567e28773c6"],
         StripOnInput->False],{
        "\"NewEoSArgon Package\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/guide/NewEoSArgon"]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"MoreAbout"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "dd7091ff-8255-42f9-ba8a-8f37dc96d230"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "URL",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "ccebd713-338c-4fce-ac80-66e51e1b5322"]
         }],ExpressionUUID->"2fbf24dc-5d27-4791-b15c-b491f0a5077d"],
         StripOnInput->False],{
        "\"NewEoSArgon/ref/TSatNIST\"" :> None, 
         "\"Copy Wolfram Documentation Center URL\"" :> 
         Module[{DocumentationSearch`Private`nb$}, 
           DocumentationSearch`Private`nb$ = 
            NotebookPut[
             Notebook[{Cell["NewEoSArgon/ref/TSatNIST"]}, Visible -> False]]; 
           SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
           FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
           NotebookClose[DocumentationSearch`Private`nb$]; Null], Delimiter, 
         "\"Copy web URL\"" :> 
         Module[{DocumentationSearch`Private`nb$}, 
           DocumentationSearch`Private`nb$ = 
            NotebookPut[
             Notebook[{
               Cell[BoxData[
                 MakeBoxes[
                  Hyperlink[
                   "http://reference.wolfram.com/language/NewEoSArgon/ref/\
TSatNIST.html"], StandardForm]], "Input", TextClipboardType -> "PlainText"]}, 
               Visible -> False]]; 
           SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
           FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
           NotebookClose[DocumentationSearch`Private`nb$]; Null], 
         "\"Go to web URL\"" :> 
         FrontEndExecute[{
           NotebookLocate[{
             URL[If[TrueQ[DocumentationBuild`Make`Private`wsmlinkQ$32452], 
                 "http://reference.wolfram.com/system-modeler/", 
                 "http://reference.wolfram.com/language/"] <> 
               "NewEoSArgon/ref/TSatNIST" <> ".html"], None}]}]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"URLMenu"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "c4bae84f-7998-457e-aa38-cfd077633d3c"]
    }], "AnchorBar",
     CacheGraphics->False,ExpressionUUID->
     "d36939a1-c261-4f66-834d-989d0a191d35"]}
  }]], "AnchorBarGrid",
 CellID->1,ExpressionUUID->"0d9ae007-c3d4-4343-bd8e-212765caccb0"],

Cell["NewEoSArgon`", "ContextNameCell",ExpressionUUID->"5d49b186-8d1f-449d-b0ac-47a7ef779aa8"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     Cell[
     "TSatNIST", "ObjectName",ExpressionUUID->
      "7d5b16d0-0812-4df4-ab3b-c4940cc10666"],
     Cell[BoxData[
      TemplateBox[{8},
       "Spacer1"]],ExpressionUUID->"74fad1a6-47c0-45e2-81f7-982bb0c45808"],
     Cell[BoxData[
     ""], "ObjectNameTranslation",ExpressionUUID->
      "4bc5ff0e-7a82-4a30-bc98-3158b9bf22c9"]
    }],ExpressionUUID->"5f1d8665-e72e-4642-8435-0ac3adddbaaa"], 
    "\[SpanFromLeft]"}
  }]], "ObjectNameGrid",ExpressionUUID->"c25f325f-3fc8-446c-82e6-\
0f9d94260283"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     "TSatNIST[\[Rho]] \[Congruent] ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["T",
        FontSlant->"Italic"], "\[Sigma]"]],ExpressionUUID->
      "3ee0794d-40a2-4920-947f-b50e89ba8284"],
     " (Kelvin)\nTemp\[EAcute]rature sur la courbe de saturation \
donn\[EAcute]e par NIST en fonction de \[Rho] (g/",
     Cell[BoxData[
      SuperscriptBox["cm", "3"]], "InlineFormula",
      FontFamily->"Source Sans Pro",ExpressionUUID->
      "dd02ed64-9978-44fa-82e4-cf30f3717f40"],
     ")\n[Fitting function of the saturated temperature versus \[Rho] (g/",
     Cell[BoxData[
      SuperscriptBox["cm", "3"]], "InlineFormula",
      FontFamily->"Source Sans Pro",ExpressionUUID->
      "4130ff63-61af-4b07-89ab-85540d320c8f"],
     ") from the data of NIST]"
    }],ExpressionUUID->"3f470edf-71d8-47f0-bf47-4a0e1427c138"]}
  }]], "Usage",ExpressionUUID->"d1164e0b-b8a7-4536-bc31-3b4c52692572"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[Cell[TextData[{
   Cell[BoxData[
    DynamicBox[ToBoxes[
      If[
       MatchQ[
        CurrentValue[
         EvaluationNotebook[], {TaggingRules, "Openers", "NotesSection"}, 
         Closed], 
        Alternatives[Open, True]], 
       Style[
        Graphics[{
          Thickness[0.18], 
          RGBColor[0.8509803921568627, 0.396078431372549, 0], 
          Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
         PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
        0.68 Inherited], 
       Rotate[
        Style[
         Graphics[{
           Thickness[0.18], 
           RGBColor[0.8509803921568627, 0.396078431372549, 0], 
           Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
          PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
         0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
     ImageSizeCache->{
      13.600000000000001`, {0.5800000000000001, 13.020000000000001`}}]],
    ExpressionUUID->"de89a832-3ea8-40e8-b98e-f4e3a6f51305"],
   Cell[BoxData[
    TemplateBox[{1},
     "Spacer1"]],ExpressionUUID->"3040dc64-5cab-423c-80a9-fc00ad74272c"],
   "Details and Options"
  }], "NotesFrameText",ExpressionUUID->"d4be0ff3-ef12-4a28-8d2f-b3e7f034f376"],
  Appearance->{Automatic, None, "Normal", Automatic},
  BaseStyle->None,
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"], 
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], After, CellContents]}]& ),
  Evaluator->None,
  Method->
   "Preemptive"]],ExpressionUUID->"54b69111-f5aa-48d8-8d84-e6bcbcbee1c7"]], \
"NotesSection",
 WholeCellGroupOpener->True,
 CellGroupingRules->{"SectionGrouping", 50},
 CacheGraphics->False,
 CellID->268947875,ExpressionUUID->"358632a4-9a18-45a9-8d29-48554f7a0576"],

Cell[TextData[{
 "La fonction est d\[EAcute]finie pour ",
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["\[Rho]trgaz"]], "paclet:NewEoSArgon/ref/rhotrgaz", 
    "NewEoSArgon Package Symbol"},
   "PackageLink",
   BaseStyle->"InlineFormula"]], "InlineFormula",
  FontFamily->"Source Sans Pro",ExpressionUUID->
  "9272c6af-955f-4e70-b928-926ea974d212"],
 " \[LessEqual] \[Rho] \[LessEqual] ",
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["\[Rho]trliq"]], "paclet:NewEoSArgon/ref/rhotrliq", 
    "NewEoSArgon Package Symbol"},
   "PackageLink",
   BaseStyle->"InlineFormula"]], "InlineFormula",
  FontFamily->"Source Sans Pro",ExpressionUUID->
  "2c735a1c-a769-4799-92b0-7693e3d6fe76"]
}], "Notes",
 CellID->1067943069,ExpressionUUID->"8b94fbbd-626a-452d-9e47-aa743d0067b5"],

Cell["\<\
******************************************************************************\
*****\
\>", "Notes",
 CellID->185021568,ExpressionUUID->"94dd3c3d-2abb-4d14-998b-445859fb219b"],

Cell[TextData[{
 "The function is defined for ",
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["\[Rho]trgaz"]], "paclet:NewEoSArgon/ref/rhotrgaz", 
    "NewEoSArgon Package Symbol"},
   "PackageLink",
   BaseStyle->"InlineFormula"]], "InlineFormula",
  FontFamily->"Source Sans Pro",ExpressionUUID->
  "c78fa570-0ccf-48eb-85c6-c40b9d95f611"],
 " \[LessEqual] \[Rho] \[LessEqual] ",
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["\[Rho]trliq"]], "paclet:NewEoSArgon/ref/rhotrliq", 
    "NewEoSArgon Package Symbol"},
   "PackageLink",
   BaseStyle->"InlineFormula"]], "InlineFormula",
  FontFamily->"Source Sans Pro",ExpressionUUID->
  "fc92dd79-a5f3-4ca5-aab3-3c125b4ad9f3"]
}], "Notes",
 CellID->20759926,ExpressionUUID->"bd78a4a7-477b-428c-8e82-22ee9934f7be"]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "NotesSection"}, Closed]]]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {
       TaggingRules, "Openers", "PrimaryExamplesSection"}, Open], 
      Alternatives[True, Open]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{13.600000000000001`, {5., 8.600000000000001}}]],
  ExpressionUUID->"0600659c-898e-4fe9-a95a-8e9f8330ebbf"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"ac5d811d-1ba1-4146-ae73-020a93d525f7"],
 "Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "51c75d5c-1bb7-4939-99a0-240f7b47ecf6"]
}], "PrimaryExamplesSection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellTags->"PrimaryExamplesSection",
 CellID->255424843,ExpressionUUID->"63748961-3524-45b7-be30-a2e18eaaa106"],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"},
        Closed], 
      Alternatives[Open, True]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{13.600000000000001`, {5., 8.600000000000001}}]],
  ExpressionUUID->"c7928776-38b0-401d-98de-f9e1150ac380"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"486a15ee-def0-4547-b6e4-55636c6a96b3"],
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "7da1cc92-4e7f-47da-aa36-92c608e4336e"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellID->140377763,ExpressionUUID->"a9d74a81-5bd9-480f-b0f8-5074a85be7ca"],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<NewEoSArgon`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->87419684,ExpressionUUID->"25de729f-1764-4ea1-a5c3-75720a51a320"],

Cell["Calculate with physical dimension", "ExampleText",
 CellID->285078790,ExpressionUUID->"4691c890-68d3-4812-b396-932442500760"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Quantity", "[", 
  RowBox[{
   RowBox[{"TSatNIST", "[", "\[Rho]trgaz", "]"}], ",", "\"\<Kelvins\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->231987987,ExpressionUUID->"26c994b9-6853-4b59-8095-81f0c0ba9a44"],

Cell[BoxData[
 TemplateBox[{"83.8058`", "\"K\"", "kelvins", "\"Kelvins\""},
  "Quantity"]], "Output",
 CellLabel->"Out[2]=",
 CellID->295362895,ExpressionUUID->"134f6326-2a23-42f3-b5bf-c04e634bb59f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UnitConvert", "[", 
  RowBox[{
   TemplateBox[{"83.8058`"},
    "QuantityUnit",
    DisplayFunction->(TooltipBox[
      StyleBox[
       RowBox[{#, "\[InvisibleSpace]", 
         StyleBox[
          RowBox[{" ", "\"K\""}], "QuantityUnitTraditionalLabel"]}], 
       ShowStringCharacters -> False], "Unit: kelvins"]& ),
    InterpretationFunction->(RowBox[{"Quantity", "[", 
       RowBox[{#, ",", "\"Kelvins\""}], "]"}]& )], ",", 
   "\"\<DegreesCelsius\>\""}], "]"}]], "Input",
 NumberMarks->False,
 CellLabel->"In[3]:=",
 CellID->191739545,ExpressionUUID->"0344f5a1-5e1e-45d1-bb44-b5f0a7fa84fd"],

Cell[BoxData[
 TemplateBox[{
   RowBox[{"-", "189.34419999999997`"}], "\"\[Degree]C\"", "degrees Celsius", 
   "\"DegreesCelsius\""},
  "Quantity"]], "Output",
 CellLabel->"Out[3]=",
 CellID->845483645,ExpressionUUID->"5dc80b3f-0bea-48e3-91e4-eae85833da79"]
}, Open  ]],

Cell["Plot function versus density in all the density range", "ExampleText",
 CellID->886239600,ExpressionUUID->"23834f21-f2cc-4ed7-9b5f-2a425c4fac9a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"TSatNIST", "[", "\[Rho]", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Rho]", ",", "\[Rho]trgaz", ",", "\[Rho]trliq"}], "}"}], ",", 
   RowBox[{"AxesOrigin", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\[Rho]c", ",", "ttr"}], "}"}]}], ",", 
   RowBox[{"Frame", "->", "True"}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Quantity", "[", 
       RowBox[{"\[Rho]", ",", "\"\<g/cm^3\>\""}], "]"}], ",", 
      RowBox[{"Quantity", "[", 
       RowBox[{"T", ",", "\"\<Kelvins\>\""}], "]"}]}], "}"}]}], ",", 
   RowBox[{"ImageSize", "\[Rule]", "400"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->21488140,ExpressionUUID->"39671e78-80ca-48df-b83c-54be50e84a3a"],

Cell[BoxData[
 GraphicsBox[
  InterpretationBox[{
    TagBox[{{{}, {}, 
       TagBox[
        {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[2], 
         Opacity[1.], LineBox[CompressedData["
1:eJwV13c81e8XAHD8EqKyyqgk8U2SVBqkzoPITjYZ14eKIkpWSTIyK9GQrIRo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          "]]},
        Annotation[#, "Charting`Private`Tag#1"]& ]}, {}},
     {"WolframDynamicHighlight", <|
      "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>}], 
    DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
      Slot["HighlightElements"], 
      Slot["LayoutOptions"], 
      Slot["Meta"], 
      Charting`HighlightActionFunction["DynamicHighlight", {{{{}, {}, 
          Annotation[{
            Directive[
             Opacity[1.], 
             RGBColor[0.368417, 0.506779, 0.709798], 
             AbsoluteThickness[2]], 
            Line[CompressedData["
1:eJwV13c81e8XAHD8EqKyyqgk8U2SVBqkzoPITjYZ14eKIkpWSTIyK9GQrIRo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             "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
       "HighlightElements" -> <|
         "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
        "LayoutOptions" -> <|
         "PlotRange" -> {{0.0040546000061275735`, 1.4168017335853793`}, {
           83.8058, 150.6871481725743}}, 
          "Frame" -> {{True, True}, {True, True}}, 
          "AxesOrigin" -> {0.535599, 83.8058}, 
          "ImageSize" -> {400, 400/GoldenRatio}, "Axes" -> {True, True}, 
          "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
          "DefaultStyle" -> {
            Directive[
             Opacity[1.], 
             RGBColor[0.368417, 0.506779, 0.709798], 
             AbsoluteThickness[2]]}, 
          "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
              Identity[
               Part[#, 1]], 
              Identity[
               Part[#, 2]]}& ), 
            "ScalingFunctions" -> {{Identity, Identity}, {
              Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>,
         "Meta" -> <|
         "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
          Plot, "GroupHighlight" -> False|>|>]]& )[<|
      "HighlightElements" -> <|
        "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
       "LayoutOptions" -> <|
        "PlotRange" -> {{0.0040546000061275735`, 1.4168017335853793`}, {
          83.8058, 150.6871481725743}}, 
         "Frame" -> {{True, True}, {True, True}}, 
         "AxesOrigin" -> {0.535599, 83.8058}, 
         "ImageSize" -> {400, 400/GoldenRatio}, "Axes" -> {True, True}, 
         "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
         "DefaultStyle" -> {
           Directive[
            Opacity[1.], 
            RGBColor[0.368417, 0.506779, 0.709798], 
            AbsoluteThickness[2]]}, 
         "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
             Identity[
              Part[#, 1]], 
             Identity[
              Part[#, 2]]}& ), 
           "ScalingFunctions" -> {{Identity, Identity}, {
             Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>, 
       "Meta" -> <|
        "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
         Plot, "GroupHighlight" -> False|>|>],
     ImageSizeCache->{{4.503599627370496*^15, -4.503599627370496*^15}, {
      4.503599627370496*^15, -4.503599627370496*^15}}]},
   Annotation[{{{{}, {}, 
       Annotation[{
         Directive[
          Opacity[1.], 
          RGBColor[0.368417, 0.506779, 0.709798], 
          AbsoluteThickness[2]], 
         Line[CompressedData["
1:eJwV13c81e8XAHD8EqKyyqgk8U2SVBqkzoPITjYZ14eKIkpWSTIyK9GQrIRo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          "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
    "HighlightElements" -> <|
      "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
     "LayoutOptions" -> <|
      "PlotRange" -> {{0.0040546000061275735`, 1.4168017335853793`}, {83.8058,
         150.6871481725743}}, "Frame" -> {{True, True}, {True, True}}, 
       "AxesOrigin" -> {0.535599, 83.8058}, 
       "ImageSize" -> {400, 400/GoldenRatio}, "Axes" -> {True, True}, 
       "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), "DefaultStyle" -> {
         Directive[
          Opacity[1.], 
          RGBColor[0.368417, 0.506779, 0.709798], 
          AbsoluteThickness[2]]}, 
       "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
           Identity[
            Part[#, 1]], 
           Identity[
            Part[#, 2]]}& ), 
         "ScalingFunctions" -> {{Identity, Identity}, {Identity, Identity}}|>,
        "Primitives" -> {}, "GCFlag" -> False|>, 
     "Meta" -> <|
      "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
       Plot, "GroupHighlight" -> False|>|>, "DynamicHighlight"]],
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0.535599, 83.8058},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{
     FormBox[
      TagBox[
       TemplateBox[{"T", "\"K\"", "kelvins", "\"Kelvins\""}, "QuantityTF", 
        SyntaxForm -> Mod], HoldForm], TraditionalForm], None}, {
     FormBox[
      TagBox[
       TemplateBox[{
         TagBox[
          TagBox["\[Rho]", HoldForm], HoldForm], 
         RowBox[{"\"g\"", "\[InvisibleSpace]", "\"/\"", "\[InvisibleSpace]", 
           SuperscriptBox["\"cm\"", "3"]}], "grams per centimeter cubed", 
         FractionBox["\"Grams\"", 
          SuperscriptBox["\"Centimeters\"", "3"]]}, "QuantityTF", SyntaxForm -> 
        Mod], HoldForm], TraditionalForm], None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  ImageSize->400,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0.0040546000061275735`, 1.4168017335853793`}, {83.8058, 
   150.6871481725743}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellLabel->"Out[4]=",
 CellID->254916495,ExpressionUUID->"530672f9-ed32-408a-b0c4-e306b9e4a56d"]
}, Open  ]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"}, 
  Closed]]]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "PrimaryExamplesSection"}, 
  Closed]]]],

Cell[BoxData[GridBox[{
   {
    DynamicBox[FEPrivate`ImportImage[
      FrontEnd`FileName[{"Documentation", "FooterIcons"}, 
       "RelatedFunction.png"]],
     ImageSizeCache->{50., {27., 33.}}], GridBox[{
      {
       StyleBox[
        RowBox[{"See", " ", "Also"}], "SeeAlsoSection"]},
      {Cell[TextData[{
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["ttr"]], "paclet:NewEoSArgon/ref/ttr", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "ac063ea3-7b7c-422e-8683-05801d41d510"],
        "\[NonBreakingSpace]",
        StyleBox[
        "\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
         "InlineSeparator"],
        " ",
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["tc"]], "paclet:NewEoSArgon/ref/tc", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "dac5110d-5da3-46b7-98dd-7aa298a2ce87"],
        "\[NonBreakingSpace]",
        StyleBox[
        "\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
         "InlineSeparator"],
        " ",
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["rhotrgaz"]], "paclet:NewEoSArgon/ref/rhotrgaz", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "36a53092-b5b6-476f-afed-5e47b902bec0"],
        "\[NonBreakingSpace]",
        StyleBox[
        "\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
         "InlineSeparator"],
        " ",
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["rhotrliq"]], "paclet:NewEoSArgon/ref/rhotrliq", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "fb5dec99-7867-4119-b85e-deae867a0af1"],
        "\[NonBreakingSpace]",
        StyleBox[
        "\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
         "InlineSeparator"],
        " ",
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["PRhoSatNIST"]], "paclet:NewEoSArgon/ref/PRhoSatNIST", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "bd4f738c-28e9-45c2-af56-8f198abb7153"]
       }], "SeeAlso",ExpressionUUID->"dc37167a-4d6a-4e41-93c1-9c83929cd2c0"]}
     }]}
  }]], "SeeAlsoSection",ExpressionUUID->"31f8940c-246d-44c0-99ee-\
3bdc14e35d81"],

Cell[BoxData[GridBox[{
   {
    DynamicBox[FEPrivate`ImportImage[
      FrontEnd`FileName[{"Documentation", "FooterIcons"}, "RelatedGuide.png"]],
     ImageSizeCache->{50., {27., 33.}}], GridBox[{
      {
       StyleBox[
        RowBox[{"Related", " ", "Guides"}], "MoreAboutSection"]},
      {
       RowBox[{"\[FilledVerySmallSquare]", Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["NewEoSArgon Package"]], 
           "paclet:NewEoSArgon/guide/NewEoSArgon"},
          "RefLinkPlain",
          BaseStyle->{"MoreAbout"}]], "MoreAbout",ExpressionUUID->
         "5b7fd32e-b52d-4d2d-a586-d95832e5d0ef"]}]}
     }]}
  }]], "MoreAboutSection",ExpressionUUID->"983b7b43-eea9-4536-995b-\
b513653c0648"],

Cell[BoxData[GridBox[{
   {
    TemplateBox[{29},
     "Spacer1"], GridBox[{
      {
       RowBox[{
        TemplateBox[{17},
         "Spacer1"], 
        StyleBox[
         RowBox[{"Related", " ", "Links"}], "RelatedLinksSection"]}]},
      {Cell[BoxData[Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData[
             RowBox[{
               RowBox[{"Units", " ", "&"}], " ", "Quantities"}]]], 
           "paclet:guide/Units"},
          "RefLinkPlain",
          BaseStyle->{"RelatedLinks"}]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "a7d6adb0-e4d4-4f57-88a5-fa3ebac9cfae"]], "RelatedLinks",
        ExpressionUUID->"30d979e5-e9d3-4371-b192-ef32cae0a736"]},
      {Cell[TextData[Cell[BoxData[
        RowBox[{
         TemplateBox[{16},
          "Spacer1"], "\[FilledVerySmallSquare]", Cell[BoxData[
          TemplateBox[{
            Cell[
             TextData[
              Cell[
               TextData[{
                 Cell[
                  BoxData[
                   TemplateBox[{2}, "Spacer1"]]], 
                 "Webbook de chimie NIST"}]]]], 
            "http://webbook.nist.gov/chemistry/fluid/"},
           "WebLink",
           BaseStyle->{"RelatedLinks"}]],ExpressionUUID->
          "de4883ea-e630-4f72-a6db-44d81ad62e6b"]}]],ExpressionUUID->
        "b3d48c0a-4c22-4808-8fce-addf009e9a2d"]], "RelatedLinks",
        ExpressionUUID->"9e229d03-053b-4d15-846e-313afaa77fa1"]}
     }]}
  }]], "RelatedLinksSection",ExpressionUUID->"a2e190ac-dfdf-4a31-bfbf-\
b1a9f006aef6"],

Cell[" ", "FooterCell",ExpressionUUID->"23f80b4f-3e84-4ff9-b01f-233127a48b11"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{900, 835.8},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"TSatNIST",
TaggingRules->{
 "ModificationHighlight" -> False, "ColorType" -> "", "LinkTrails" -> "", 
  "HasOptions" -> True, "ExampleCounter" -> 1, 
  "Openers" -> {
   "PrimaryExamplesSection" -> Open, "ExampleSection" -> {"0" -> Open}, 
    "NotesSection" -> Closed}, "NewStyles" -> True, 
  "CitationPopupData" -> $Failed, "ShowCitation" -> False, "RootCaptions" -> 
  "", "Metadata" -> {
   "built" -> "{2023, 11, 30, 13, 56, 13.5429631}", 
    "history" -> {"XX", "", "", ""}, "context" -> "NewEoSArgon`", 
    "keywords" -> {}, "specialkeywords" -> {}, 
    "tutorialcollectionlinks" -> {}, "index" -> True, "label" -> 
    "New Eo S Argon Package Symbol", "language" -> "en", "paclet" -> 
    "NewEoSArgon Package", "status" -> "None", "summary" -> 
    "TSatNIST[\\[Rho]] \\[Congruent] T\\[Sigma] (Kelvin) Temp\[EAcute]rature \
sur la courbe de saturation donn\[EAcute]e par NIST en fonction de \\[Rho] \
(g/cm^3) [Fitting function of the saturated temperature versus \\[Rho] \
(g/cm^3) from the data of NIST]", "synonyms" -> {}, "tabletags" -> {}, 
    "title" -> "TSatNIST", "titlemodifier" -> "", "metadescription" -> "", 
    "windowtitle" -> "TSatNIST", "type" -> "Symbol", "uri" -> 
    "NewEoSArgon/ref/TSatNIST"}},
CellContext->"Global`",
FrontEndVersion->"13.3 pour Microsoft Windows (64-bit) (July 24, 2023)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "13.3 pour Microsoft Windows (64-bit) (July 24, 2023)", 
  StyleDefinitions -> "Default.nb"],
ExpressionUUID->"f64cf59e-1466-4dbd-af65-df8c413a7f3f"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[11603, 310, 1420, 37, 35, "PrimaryExamplesSection",ExpressionUUID->"63748961-3524-45b7-be30-a2e18eaaa106",
   CellTags->"PrimaryExamplesSection",
   CellID->255424843]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 60486, 1310}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[580, 21, 5547, 133, 56, "AnchorBarGrid",ExpressionUUID->"0d9ae007-c3d4-4343-bd8e-212765caccb0",
 CellID->1],
Cell[6130, 156, 94, 0, 23, "ContextNameCell",ExpressionUUID->"5d49b186-8d1f-449d-b0ac-47a7ef779aa8"],
Cell[CellGroupData[{
Cell[6249, 160, 551, 14, 56, "ObjectNameGrid",ExpressionUUID->"c25f325f-3fc8-446c-82e6-0f9d94260283"],
Cell[6803, 176, 954, 21, 146, "Usage",ExpressionUUID->"d1164e0b-b8a7-4536-bc31-3b4c52692572"]
}, Open  ]],
Cell[CellGroupData[{
Cell[7794, 202, 1919, 48, 37, "NotesSection",ExpressionUUID->"358632a4-9a18-45a9-8d29-48554f7a0576",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->268947875],
Cell[9716, 252, 790, 22, 38, "Notes",ExpressionUUID->"8b94fbbd-626a-452d-9e47-aa743d0067b5",
 CellID->1067943069],
Cell[10509, 276, 185, 4, 36, "Notes",ExpressionUUID->"94dd3c3d-2abb-4d14-998b-445859fb219b",
 CellID->185021568],
Cell[10697, 282, 779, 22, 38, "Notes",ExpressionUUID->"bd78a4a7-477b-428c-8e82-22ee9934f7be",
 CellID->20759926]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "NotesSection"}, Closed]]]],
Cell[CellGroupData[{
Cell[11603, 310, 1420, 37, 35, "PrimaryExamplesSection",ExpressionUUID->"63748961-3524-45b7-be30-a2e18eaaa106",
 CellTags->"PrimaryExamplesSection",
 CellID->255424843],
Cell[CellGroupData[{
Cell[13048, 351, 1398, 36, 30, "ExampleSection",ExpressionUUID->"a9d74a81-5bd9-480f-b0f8-5074a85be7ca",
 CellID->140377763],
Cell[14449, 389, 174, 3, 26, "Input",ExpressionUUID->"25de729f-1764-4ea1-a5c3-75720a51a320",
 CellID->87419684],
Cell[14626, 394, 131, 1, 38, "ExampleText",ExpressionUUID->"4691c890-68d3-4812-b396-932442500760",
 CellID->285078790],
Cell[CellGroupData[{
Cell[14782, 399, 245, 6, 26, "Input",ExpressionUUID->"26c994b9-6853-4b59-8095-81f0c0ba9a44",
 CellID->231987987],
Cell[15030, 407, 199, 4, 39, "Output",ExpressionUUID->"134f6326-2a23-42f3-b5bf-c04e634bb59f",
 CellID->295362895]
}, Open  ]],
Cell[CellGroupData[{
Cell[15266, 416, 621, 16, 26, "Input",ExpressionUUID->"0344f5a1-5e1e-45d1-bb44-b5f0a7fa84fd",
 CellID->191739545],
Cell[15890, 434, 257, 6, 40, "Output",ExpressionUUID->"5dc80b3f-0bea-48e3-91e4-eae85833da79",
 CellID->845483645]
}, Open  ]],
Cell[16162, 443, 151, 1, 38, "ExampleText",ExpressionUUID->"23834f21-f2cc-4ed7-9b5f-2a425c4fac9a",
 CellID->886239600],
Cell[CellGroupData[{
Cell[16338, 448, 768, 19, 42, "Input",ExpressionUUID->"39671e78-80ca-48df-b83c-54be50e84a3a",
 CellID->21488140],
Cell[17109, 469, 35805, 639, 280, "Output",ExpressionUUID->"530672f9-ed32-408a-b0c4-e306b9e4a56d",
 CellID->254916495]
}, Open  ]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"}, Closed]]]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "PrimaryExamplesSection"}, Closed]]]],
Cell[53156, 1117, 2904, 78, 70, "SeeAlsoSection",ExpressionUUID->"31f8940c-246d-44c0-99ee-3bdc14e35d81"],
Cell[56063, 1197, 729, 19, 70, "MoreAboutSection",ExpressionUUID->"983b7b43-eea9-4536-995b-b513653c0648"],
Cell[56795, 1218, 1568, 43, 70, "RelatedLinksSection",ExpressionUUID->"a2e190ac-dfdf-4a31-bfbf-b1a9f006aef6"],
Cell[58366, 1263, 78, 0, 70, "FooterCell",ExpressionUUID->"23f80b4f-3e84-4ff9-b01f-233127a48b11"]
}
]
*)

(* End of internal cache information *)

