(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 13.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     96457,       1906]
NotebookOptionsPosition[     90097,       1777]
NotebookOutlinePosition[     92613,       1839]
CellTagsIndexPosition[     92491,       1833]
WindowTitle->Tdiv
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[GridBox[{
   {GridBox[{
      {
       ItemBox[Cell[BoxData[
         RowBox[{
          TemplateBox[{12},
           "Spacer1"], Cell["NEW EO S ARGON PACKAGE SYMBOL", "PacletNameCell",
           TextAlignment->Center,ExpressionUUID->
           "a96fa94e-f79c-4004-95cc-5fcde64d4dc9"], 
          TemplateBox[{8},
           "Spacer1"]}]],
         TextAlignment->Center,ExpressionUUID->
         "a2d76ec4-2a8a-45ab-90cb-2cf6bf509a40"],
        Background->RGBColor[0.490196, 0.576471, 0.690196],
        ItemSize->Full], ""}
     },
     GridBoxAlignment->{"Rows" -> {{Center}}},
     GridBoxItemSize->{"Columns" -> {Full, 
         Scaled[0.02]}, "Rows" -> {{2.5}}}], Cell[TextData[{
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "See Also",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "722e5e2b-eeee-419c-a452-eab94696c9b3"]
         }],ExpressionUUID->"f9c8f41b-3c57-48dc-9d5b-d4ca098343e1"],
         StripOnInput->False],{
        "\"TRhoSat\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/TRhoSat"], 
         "\"TSatNIST\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/TSatNIST"]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"SeeAlso"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "12dccd00-ec74-40b6-a6e7-48ab9f44695d"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "Related Guides",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "9c294f49-9caf-47c1-bb92-aee517e2fe3b"]
         }],ExpressionUUID->"25c5ff75-d7fc-4321-b246-f58613696a3f"],
         StripOnInput->False],{
        "\"NewEoSArgon Package\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/guide/NewEoSArgon"]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"MoreAbout"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "37a2c81d-1c47-420d-8bbb-bef56884bef2"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "URL",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "e48e4580-8e29-4a13-83b5-e44b48d2a9fd"]
         }],ExpressionUUID->"fe50a11e-412b-483e-a3b1-2edaa5bdf60b"],
         StripOnInput->False],{
        "\"NewEoSArgon/ref/Tdiv\"" :> None, 
         "\"Copy Wolfram Documentation Center URL\"" :> 
         Module[{DocumentationSearch`Private`nb$}, 
           DocumentationSearch`Private`nb$ = 
            NotebookPut[
             Notebook[{Cell["NewEoSArgon/ref/Tdiv"]}, Visible -> False]]; 
           SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
           FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
           NotebookClose[DocumentationSearch`Private`nb$]; Null], Delimiter, 
         "\"Copy web URL\"" :> 
         Module[{DocumentationSearch`Private`nb$}, 
           DocumentationSearch`Private`nb$ = 
            NotebookPut[
             Notebook[{
               Cell[BoxData[
                 MakeBoxes[
                  Hyperlink[
                   "http://reference.wolfram.com/language/NewEoSArgon/ref/\
Tdiv.html"], StandardForm]], "Input", TextClipboardType -> "PlainText"]}, 
               Visible -> False]]; 
           SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
           FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
           NotebookClose[DocumentationSearch`Private`nb$]; Null], 
         "\"Go to web URL\"" :> 
         FrontEndExecute[{
           NotebookLocate[{
             URL[If[TrueQ[DocumentationBuild`Make`Private`wsmlinkQ$30930], 
                 "http://reference.wolfram.com/system-modeler/", 
                 "http://reference.wolfram.com/language/"] <> 
               "NewEoSArgon/ref/Tdiv" <> ".html"], None}]}]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"URLMenu"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "b73016d0-cab2-499a-adc4-91a5e39d7627"]
    }], "AnchorBar",
     CacheGraphics->False,ExpressionUUID->
     "85207415-4d8f-4901-9634-d0839ec771ea"]}
  }]], "AnchorBarGrid",
 CellID->1,ExpressionUUID->"df1644a8-7ab4-4671-8579-06e2d0cee236"],

Cell["NewEoSArgon`", "ContextNameCell",ExpressionUUID->"1fbe9333-e7bc-425d-85be-90698e4d266e"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     Cell[
     "Tdiv", "ObjectName",ExpressionUUID->
      "18dc5c5c-09b5-4b70-a198-18ec33d7367d"],
     Cell[BoxData[
      TemplateBox[{8},
       "Spacer1"]],ExpressionUUID->"29aa94a7-ca0f-461a-ba35-3fca3bd5f7da"],
     Cell[BoxData[
     ""], "ObjectNameTranslation",ExpressionUUID->
      "b4b77fd8-2a9b-4914-b298-a52e6ea772b1"]
    }],ExpressionUUID->"b0adbfa9-1be6-4ef0-b8dd-4455de2d82a6"], 
    "\[SpanFromLeft]"}
  }]], "ObjectNameGrid",ExpressionUUID->"006aaeb2-05f0-45c5-93c3-\
db61fe05151d"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     "Tdiv[\[Rho]] (Kelvin)\nFonction permettant de calculer la temperature \
correspondante \[AGrave] la divergence du ",
     Cell[BoxData[
      StyleBox[
       SubscriptBox["C", "V"],
       FontSlant->"Italic"]], "InlineFormula",
      FontFamily->"Source Sans Pro",ExpressionUUID->
      "6f9e7d0f-f3ae-4096-b90c-c1fc0f9f97b0"],
     " en fonction de \[Rho] (g/",
     Cell[BoxData[
      SuperscriptBox["cm", "3"]], "InlineFormula",
      FontFamily->"Source Sans Pro",ExpressionUUID->
      "8f014741-bc71-4b38-95ec-41e57c78a822"],
     ")\n[Temperature corresponding to the divergence of ",
     Cell[BoxData[
      SubscriptBox["C", "V"]], "InlineFormula",
      FontFamily->"Source Sans Pro",
      FontSlant->"Italic",ExpressionUUID->
      "38a88d2b-8355-4220-8f44-1a6866449841"],
     " versus \[Rho] (g/",
     Cell[BoxData[
      SuperscriptBox["cm", "3"]], "InlineFormula",
      FontFamily->"Source Sans Pro",ExpressionUUID->
      "2f7f6785-9404-4896-83e6-93f5aaea4d48"],
     ")]"
    }],ExpressionUUID->"91dbd36b-ec34-4296-ab0a-5bbb4868b387"]}
  }]], "Usage",ExpressionUUID->"03093bcf-7505-48bd-8e45-977980469ef6"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[Cell[TextData[{
   Cell[BoxData[
    DynamicBox[ToBoxes[
      If[
       MatchQ[
        CurrentValue[
         EvaluationNotebook[], {TaggingRules, "Openers", "NotesSection"}, 
         Closed], 
        Alternatives[Open, True]], 
       Style[
        Graphics[{
          Thickness[0.18], 
          RGBColor[0.8509803921568627, 0.396078431372549, 0], 
          Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
         PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
        0.68 Inherited], 
       Rotate[
        Style[
         Graphics[{
           Thickness[0.18], 
           RGBColor[0.8509803921568627, 0.396078431372549, 0], 
           Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
          PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
         0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
     ImageSizeCache->{
      13.600000000000001`, {0.5800000000000001, 13.020000000000001`}}]],
    ExpressionUUID->"65043167-baa0-44e4-8d06-d40da36bca5d"],
   Cell[BoxData[
    TemplateBox[{1},
     "Spacer1"]],ExpressionUUID->"066e0952-4c84-41d0-968f-22252d5d5cbf"],
   "Details and Options"
  }], "NotesFrameText",ExpressionUUID->"d2ca93eb-5520-4d40-bc4d-25878fb3e6c6"],
  Appearance->{Automatic, None, "Normal", Automatic},
  BaseStyle->None,
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"], 
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], After, CellContents]}]& ),
  Evaluator->None,
  Method->
   "Preemptive"]],ExpressionUUID->"a44c7665-89d8-40ab-a46a-07159175b57a"]], \
"NotesSection",
 WholeCellGroupOpener->True,
 CellGroupingRules->{"SectionGrouping", 50},
 CacheGraphics->False,
 CellID->159919811,ExpressionUUID->"1cbe12bf-7f6e-43d8-939b-15f27fca2283"],

Cell["La fonction est d\[EAcute]finie pour \[Rho] \[GreaterEqual] 0", "Notes",
 CellID->1067943069,ExpressionUUID->"a26615f9-d166-403f-b2a4-9cacaad75474"],

Cell["\<\
******************************************************************************\
*****\
\>", "Notes",
 CellID->185021568,ExpressionUUID->"124b87d1-3c51-4b87-936d-a5380841dacd"],

Cell["The function is defined for \[Rho] \[GreaterEqual] 0.", "Notes",
 CellID->175218415,ExpressionUUID->"90fabfcb-11ce-46b4-8b3f-41653b102852"]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "NotesSection"}, Closed]]]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {
       TaggingRules, "Openers", "PrimaryExamplesSection"}, Open], 
      Alternatives[True, Open]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{13.600000000000001`, {5., 8.600000000000001}}]],
  ExpressionUUID->"26593bde-552f-45e2-8b4b-234ffa220674"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"2e07679b-6fb2-4e9b-a196-834416f8c734"],
 "Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount",ExpressionUUID->
  "f9ea323b-d251-4dbf-9176-46eb703584dc"]
}], "PrimaryExamplesSection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellTags->"PrimaryExamplesSection",
 CellID->371674515,ExpressionUUID->"004a50de-a2a1-4f94-91e3-a3ab798faa4a"],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"},
        Closed], 
      Alternatives[Open, True]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{13.600000000000001`, {5., 8.600000000000001}}]],
  ExpressionUUID->"22dd995f-9eb3-404c-9924-de944cf28874"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"81207647-aad8-4d98-872f-05196bdb0ab9"],
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "fbd637fd-0673-4646-b0b6-279f07907fcc"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellID->427693066,ExpressionUUID->"3c38f21b-ed9e-4919-818d-f42c331a1a80"],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<NewEoSArgon`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->87419684,ExpressionUUID->"06b71d69-3263-4199-adca-de4f27d7e3aa"],

Cell["Calculate with physical dimension", "ExampleText",
 CellID->285078790,ExpressionUUID->"047f3637-b842-494b-a01c-52afb79eab95"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Quantity", "[", 
  RowBox[{
   RowBox[{"Tdiv", "[", "\[Rho]c", "]"}], ",", "\"\<Kelvins\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->231987987,ExpressionUUID->"a1fb7acc-a599-48ab-85c0-9dc4923c66b8"],

Cell[BoxData[
 TemplateBox[{"143.21134362084734`", "\"K\"", "kelvins", "\"Kelvins\""},
  "Quantity"]], "Output",
 CellLabel->"Out[2]=",
 CellID->3937713,ExpressionUUID->"024f1303-1f20-4c33-a89d-f010ff3342b7"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UnitConvert", "[", 
  RowBox[{
   TemplateBox[{"143.21134362084734`", "\"K\"", "kelvins", "\"Kelvins\""},
    "Quantity"], ",", "\"\<DegreesCelsius\>\""}], "]"}]], "Input",
 NumberMarks->False,
 CellLabel->"In[3]:=",
 CellID->191739545,ExpressionUUID->"b23f0e73-f09a-4a06-95ac-3d9416c70292"],

Cell[BoxData[
 TemplateBox[{
   RowBox[{"-", "129.93865637915263`"}], "\"\[Degree]C\"", "degrees Celsius", 
   "\"DegreesCelsius\""},
  "Quantity"]], "Output",
 CellLabel->"Out[3]=",
 CellID->255579222,ExpressionUUID->"cd6a936e-1f4c-4c07-8402-8d6641bf9bae"]
}, Open  ]],

Cell["Plot function versus density in all the range of density", "ExampleText",
 CellID->630903743,ExpressionUUID->"8ef5f7ef-1aff-44a7-afa9-e104da61c5c4"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"Tdiv", "[", "\[Rho]", "]"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Rho]", ",", "0", ",", "\[Rho]maxRonc"}], "}"}], ",", 
   RowBox[{"AxesOrigin", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\[Rho]c", ",", "ttr"}], "}"}]}], ",", 
   RowBox[{"Frame", "->", "True"}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Quantity", "[", 
       RowBox[{"\[Rho]", ",", "\"\<g/cm^3\>\""}], "]"}], ",", 
      RowBox[{"Quantity", "[", 
       RowBox[{"T", ",", "\"\<Kelvins\>\""}], "]"}]}], "}"}]}], ",", 
   RowBox[{"ImageSize", "\[Rule]", "400"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->142124557,ExpressionUUID->"d77bb7c8-1840-4a3c-9d58-1ed44e1f3f98"],

Cell[BoxData[
 GraphicsBox[
  InterpretationBox[{
    TagBox[{{{}, {}, 
       TagBox[
        {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[2], 
         Opacity[1.], LineBox[CompressedData["
1:eJwV13k8VO3bAPCZsTbakLX42UIoa0rJdSUJUQjJNjOUsiRJoRJZerJUWpSl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          "]]},
        Annotation[#, "Charting`Private`Tag#1"]& ]}, {}},
     {"WolframDynamicHighlight", <|
      "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>}], 
    DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
      Slot["HighlightElements"], 
      Slot["LayoutOptions"], 
      Slot["Meta"], 
      Charting`HighlightActionFunction["DynamicHighlight", {{{{}, {}, 
          Annotation[{
            Directive[
             Opacity[1.], 
             RGBColor[0.368417, 0.506779, 0.709798], 
             AbsoluteThickness[2]], 
            Line[CompressedData["
1:eJwV13k8VO3bAPCZsTbakLX42UIoa0rJdSUJUQjJNjOUsiRJoRJZerJUWpSl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             "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
       "HighlightElements" -> <|
         "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
        "LayoutOptions" -> <|
         "PlotRange" -> {{0, 3.356974789915966}, {0., 143.2272866055989}}, 
          "Frame" -> {{True, True}, {True, True}}, 
          "AxesOrigin" -> {0.535599, 83.8058}, 
          "ImageSize" -> {400, 400/GoldenRatio}, "Axes" -> {True, True}, 
          "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
          "DefaultStyle" -> {
            Directive[
             Opacity[1.], 
             RGBColor[0.368417, 0.506779, 0.709798], 
             AbsoluteThickness[2]]}, 
          "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
              Identity[
               Part[#, 1]], 
              Identity[
               Part[#, 2]]}& ), 
            "ScalingFunctions" -> {{Identity, Identity}, {
              Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>,
         "Meta" -> <|
         "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
          Plot, "GroupHighlight" -> False|>|>]]& )[<|
      "HighlightElements" -> <|
        "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
       "LayoutOptions" -> <|
        "PlotRange" -> {{0, 3.356974789915966}, {0., 143.2272866055989}}, 
         "Frame" -> {{True, True}, {True, True}}, 
         "AxesOrigin" -> {0.535599, 83.8058}, 
         "ImageSize" -> {400, 400/GoldenRatio}, "Axes" -> {True, True}, 
         "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
         "DefaultStyle" -> {
           Directive[
            Opacity[1.], 
            RGBColor[0.368417, 0.506779, 0.709798], 
            AbsoluteThickness[2]]}, 
         "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
             Identity[
              Part[#, 1]], 
             Identity[
              Part[#, 2]]}& ), 
           "ScalingFunctions" -> {{Identity, Identity}, {
             Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>, 
       "Meta" -> <|
        "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
         Plot, "GroupHighlight" -> False|>|>],
     ImageSizeCache->{{4.503599627370496*^15, -4.503599627370496*^15}, {
      4.503599627370496*^15, -4.503599627370496*^15}}]},
   Annotation[{{{{}, {}, 
       Annotation[{
         Directive[
          Opacity[1.], 
          RGBColor[0.368417, 0.506779, 0.709798], 
          AbsoluteThickness[2]], 
         Line[CompressedData["
1:eJwV13k8VO3bAPCZsTbakLX42UIoa0rJdSUJUQjJNjOUsiRJoRJZerJUWpSl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          "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
    "HighlightElements" -> <|
      "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
     "LayoutOptions" -> <|
      "PlotRange" -> {{0, 3.356974789915966}, {0., 143.2272866055989}}, 
       "Frame" -> {{True, True}, {True, True}}, 
       "AxesOrigin" -> {0.535599, 83.8058}, 
       "ImageSize" -> {400, 400/GoldenRatio}, "Axes" -> {True, True}, 
       "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), "DefaultStyle" -> {
         Directive[
          Opacity[1.], 
          RGBColor[0.368417, 0.506779, 0.709798], 
          AbsoluteThickness[2]]}, 
       "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
           Identity[
            Part[#, 1]], 
           Identity[
            Part[#, 2]]}& ), 
         "ScalingFunctions" -> {{Identity, Identity}, {Identity, Identity}}|>,
        "Primitives" -> {}, "GCFlag" -> False|>, 
     "Meta" -> <|
      "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
       Plot, "GroupHighlight" -> False|>|>, "DynamicHighlight"]],
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0.535599, 83.8058},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{
     FormBox[
      TagBox[
       TemplateBox[{"T", "\"K\"", "kelvins", "\"Kelvins\""}, "QuantityTF", 
        SyntaxForm -> Mod], HoldForm], TraditionalForm], None}, {
     FormBox[
      TagBox[
       TemplateBox[{
         TagBox[
          TagBox["\[Rho]", HoldForm], HoldForm], 
         RowBox[{"\"g\"", "\[InvisibleSpace]", "\"/\"", "\[InvisibleSpace]", 
           SuperscriptBox["\"cm\"", "3"]}], "grams per centimeter cubed", 
         FractionBox["\"Grams\"", 
          SuperscriptBox["\"Centimeters\"", "3"]]}, "QuantityTF", SyntaxForm -> 
        Mod], HoldForm], TraditionalForm], None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  ImageSize->400,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 3.356974789915966}, {0., 143.2272866055989}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellLabel->"Out[4]=",
 CellID->202793156,ExpressionUUID->"b5afaf9b-70e9-4dca-9e52-d38218629554"]
}, Open  ]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"}, 
  Closed]]]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "1"},
        Closed], 
      Alternatives[Open, True]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{
    13.600000000000001`, {0.5800000000000001, 13.020000000000001`}}]],
  ExpressionUUID->"d4825273-9628-4faa-81c1-6b61621139ff"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"11ec6079-11ea-47e3-a2a5-e6e78f67d59d"],
 "Scope",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "9b27466b-2cce-4cbc-b90f-0c5e7cbd7152"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellID->1293636265,ExpressionUUID->"4f7869cf-9465-4c02-b005-d9f0524e0f96"],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<NewEoSArgon`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->349404325,ExpressionUUID->"2d842018-1127-422c-8814-d8313eb38e83"],

Cell["\<\
Plot function versus density and comparison with saturated curve from NIST\
\>", "ExampleText",
 CellID->886239600,ExpressionUUID->"7c88fb1a-665d-41a1-b9e0-b0a5c58c55b6"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Tdiv", "[", "\[Rho]", "]"}], ",", 
     RowBox[{"TSatNIST", "[", "\[Rho]", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Rho]", ",", "\[Rho]trgaz", ",", "\[Rho]trliq"}], "}"}], ",", 
   RowBox[{"AxesOrigin", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\[Rho]c", ",", "ttr"}], "}"}]}], ",", 
   RowBox[{"Frame", "->", "True"}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Quantity", "[", 
       RowBox[{"\[Rho]", ",", "\"\<g/cm^3\>\""}], "]"}], ",", 
      RowBox[{"Quantity", "[", 
       RowBox[{"T", ",", "\"\<Kelvins\>\""}], "]"}]}], "}"}]}], ",", 
   RowBox[{"ImageSize", "\[Rule]", "400"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Red", ",", 
      RowBox[{"{", 
       RowBox[{"Black", ",", "Dashed"}], "}"}]}], "}"}]}], ",", 
   RowBox[{"PlotLegends", "\[Rule]", "\"\<Expressions\>\""}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->2227668,ExpressionUUID->"cfd95697-2510-4881-99a5-3318ceaa177e"],

Cell[BoxData[
 GraphicsBox[
  TagBox[RasterBox[CompressedData["
1:eJzs3T9MI9u+6PnWjANrRMCRCBwQMLMJCAgcEBAQMBLSZiQH6D1Gh4CA98Td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    "], {{0, 261.}, {529., 0}}, {0, 255},
    ColorFunction->RGBColor,
    ImageResolution->{144., 144.},
    SmoothingQuality->"High"],
   BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
   Selectable->False],
  DefaultBaseStyle->"ImageGraphics",
  ImageSize->Automatic,
  ImageSizeRaw->{529., 261.},
  PlotRange->{{0, 529.}, {0, 261.}}]], "Output",
 CellTags->"RasterizedOutput",
 CellLabel->"Out[2]=",
 CellID->80628476,ExpressionUUID->"000d167b-b700-4ae6-ac3d-76ed32443b00"]
}, Open  ]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "1"}, 
  Closed]]]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "PrimaryExamplesSection"}, 
  Closed]]]],

Cell[BoxData[GridBox[{
   {
    DynamicBox[FEPrivate`ImportImage[
      FrontEnd`FileName[{"Documentation", "FooterIcons"}, 
       "RelatedFunction.png"]],
     ImageSizeCache->{50., {27., 33.}}], GridBox[{
      {
       StyleBox[
        RowBox[{"See", " ", "Also"}], "SeeAlsoSection"]},
      {Cell[TextData[Cell[BoxData[
        TemplateBox[{
          Cell[
           TextData["TSatNIST"]], "paclet:NewEoSArgon/ref/TSatNIST", 
          "NewEoSArgon Package Symbol"},
         "PackageLink",
         BaseStyle->"InlineFormula"]], "InlineFormula",
        FontFamily->"Source Sans Pro",ExpressionUUID->
        "470afa4b-c937-4b54-920f-31b931716a02"]], "SeeAlso",ExpressionUUID->
        "c6d67c58-c82f-41b3-a846-587b37c99144"]}
     }]}
  }]], "SeeAlsoSection",ExpressionUUID->"3ab65763-8359-4a5f-baff-\
74624563cf15"],

Cell[BoxData[GridBox[{
   {
    DynamicBox[FEPrivate`ImportImage[
      FrontEnd`FileName[{"Documentation", "FooterIcons"}, "RelatedGuide.png"]],
     ImageSizeCache->{50., {27., 33.}}], GridBox[{
      {
       StyleBox[
        RowBox[{"Related", " ", "Guides"}], "MoreAboutSection"]},
      {
       RowBox[{"\[FilledVerySmallSquare]", Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["NewEoSArgon Package"]], 
           "paclet:NewEoSArgon/guide/NewEoSArgon"},
          "RefLinkPlain",
          BaseStyle->{"MoreAbout"}]], "MoreAbout",ExpressionUUID->
         "f2b39e32-0b2e-45fc-867a-cdbe20555a3f"]}]}
     }]}
  }]], "MoreAboutSection",ExpressionUUID->"ec2e6cdc-af67-4372-a846-\
fbbb30c5e2a8"],

Cell[BoxData[GridBox[{
   {
    TemplateBox[{29},
     "Spacer1"], GridBox[{
      {
       RowBox[{
        TemplateBox[{17},
         "Spacer1"], 
        StyleBox[
         RowBox[{"Related", " ", "Links"}], "RelatedLinksSection"]}]},
      {Cell[BoxData[Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData[
             RowBox[{
               RowBox[{"Units", " ", "&"}], " ", "Quantities"}]]], 
           "paclet:guide/Units"},
          "RefLinkPlain",
          BaseStyle->{"RelatedLinks"}]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "504d4421-42c5-4673-a283-63c5f9e61739"]], "RelatedLinks",
        ExpressionUUID->"2ac2694a-193f-4fe4-9c52-527dd3576025"]}
     }]}
  }]], "RelatedLinksSection",ExpressionUUID->"eb152308-5736-44da-a576-\
1bd7519f13fe"],

Cell[" ", "FooterCell",ExpressionUUID->"1d11eba3-95bd-44e3-aa4b-fcd9bf819e6f"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{900, 835.8},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Tdiv",
TaggingRules->{
 "ModificationHighlight" -> False, "ColorType" -> "", "LinkTrails" -> "", 
  "HasOptions" -> True, "ExampleCounter" -> 1, 
  "Openers" -> {
   "PrimaryExamplesSection" -> Open, 
    "ExampleSection" -> {"0" -> Open, "1" -> Closed}, "NotesSection" -> 
    Closed}, "NewStyles" -> True, "CitationPopupData" -> $Failed, 
  "ShowCitation" -> False, "RootCaptions" -> "", 
  "Metadata" -> {
   "built" -> "{2023, 11, 30, 13, 56, 10.6360506}", 
    "history" -> {"XX", "", "", ""}, "context" -> "NewEoSArgon`", 
    "keywords" -> {}, "specialkeywords" -> {}, 
    "tutorialcollectionlinks" -> {}, "index" -> True, "label" -> 
    "New Eo S Argon Package Symbol", "language" -> "en", "paclet" -> 
    "NewEoSArgon Package", "status" -> "None", "summary" -> 
    "Tdiv[\\[Rho]] (Kelvin) Fonction permettant de calculer la temperature \
correspondante \[AGrave] la divergence du CV en fonction de \\[Rho] (g/cm^3) \
[Temperature corresponding to the divergence of CV versus \\[Rho] (g/cm^3)]", 
    "synonyms" -> {}, "tabletags" -> {}, "title" -> "Tdiv", "titlemodifier" -> 
    "", "metadescription" -> "", "windowtitle" -> "Tdiv", "type" -> "Symbol", 
    "uri" -> "NewEoSArgon/ref/Tdiv"}},
CellContext->"Global`",
FrontEndVersion->"13.3 pour Microsoft Windows (64-bit) (July 24, 2023)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "13.3 pour Microsoft Windows (64-bit) (July 24, 2023)", 
  StyleDefinitions -> "Default.nb"],
ExpressionUUID->"29074759-316b-4824-ba80-ed103c7d3a4e"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[10275, 271, 1420, 37, 35, "PrimaryExamplesSection",ExpressionUUID->"004a50de-a2a1-4f94-91e3-a3ab798faa4a",
   CellTags->"PrimaryExamplesSection",
   CellID->371674515]},
 "RasterizedOutput"->{
  Cell[51028, 1094, 36356, 602, 282, "Output",ExpressionUUID->"000d167b-b700-4ae6-ac3d-76ed32443b00",
   CellTags->"RasterizedOutput",
   CellID->80628476]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 92110, 1822},
 {"RasterizedOutput", 92310, 1826}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[576, 21, 5268, 129, 56, "AnchorBarGrid",ExpressionUUID->"df1644a8-7ab4-4671-8579-06e2d0cee236",
 CellID->1],
Cell[5847, 152, 94, 0, 23, "ContextNameCell",ExpressionUUID->"1fbe9333-e7bc-425d-85be-90698e4d266e"],
Cell[CellGroupData[{
Cell[5966, 156, 547, 14, 56, "ObjectNameGrid",ExpressionUUID->"006aaeb2-05f0-45c5-93c3-db61fe05151d"],
Cell[6516, 172, 1183, 28, 146, "Usage",ExpressionUUID->"03093bcf-7505-48bd-8e45-977980469ef6"]
}, Open  ]],
Cell[CellGroupData[{
Cell[7736, 205, 1919, 48, 37, "NotesSection",ExpressionUUID->"1cbe12bf-7f6e-43d8-939b-15f27fca2283",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->159919811],
Cell[9658, 255, 154, 1, 36, "Notes",ExpressionUUID->"a26615f9-d166-403f-b2a4-9cacaad75474",
 CellID->1067943069],
Cell[9815, 258, 185, 4, 36, "Notes",ExpressionUUID->"124b87d1-3c51-4b87-936d-a5380841dacd",
 CellID->185021568],
Cell[10003, 264, 145, 1, 36, "Notes",ExpressionUUID->"90fabfcb-11ce-46b4-8b3f-41653b102852",
 CellID->175218415]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "NotesSection"}, Closed]]]],
Cell[CellGroupData[{
Cell[10275, 271, 1420, 37, 35, "PrimaryExamplesSection",ExpressionUUID->"004a50de-a2a1-4f94-91e3-a3ab798faa4a",
 CellTags->"PrimaryExamplesSection",
 CellID->371674515],
Cell[CellGroupData[{
Cell[11720, 312, 1398, 36, 30, "ExampleSection",ExpressionUUID->"3c38f21b-ed9e-4919-818d-f42c331a1a80",
 CellID->427693066],
Cell[13121, 350, 174, 3, 26, "Input",ExpressionUUID->"06b71d69-3263-4199-adca-de4f27d7e3aa",
 CellID->87419684],
Cell[13298, 355, 131, 1, 38, "ExampleText",ExpressionUUID->"047f3637-b842-494b-a01c-52afb79eab95",
 CellID->285078790],
Cell[CellGroupData[{
Cell[13454, 360, 237, 6, 26, "Input",ExpressionUUID->"a1fb7acc-a599-48ab-85c0-9dc4923c66b8",
 CellID->231987987],
Cell[13694, 368, 208, 4, 39, "Output",ExpressionUUID->"024f1303-1f20-4c33-a89d-f010ff3342b7",
 CellID->3937713]
}, Open  ]],
Cell[CellGroupData[{
Cell[13939, 377, 315, 7, 31, "Input",ExpressionUUID->"b23f0e73-f09a-4a06-95ac-3d9416c70292",
 CellID->191739545],
Cell[14257, 386, 257, 6, 40, "Output",ExpressionUUID->"cd6a936e-1f4c-4c07-8402-8d6641bf9bae",
 CellID->255579222]
}, Open  ]],
Cell[14529, 395, 154, 1, 38, "ExampleText",ExpressionUUID->"8ef5f7ef-1aff-44a7-afa9-e104da61c5c4",
 CellID->630903743],
Cell[CellGroupData[{
Cell[14708, 400, 782, 20, 42, "Input",ExpressionUUID->"d77bb7c8-1840-4a3c-9d58-1ed44e1f3f98",
 CellID->142124557],
Cell[15493, 422, 32491, 582, 280, "Output",ExpressionUUID->"b5afaf9b-70e9-4dca-9e52-d38218629554",
 CellID->202793156]
}, Open  ]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"}, Closed]]]],
Cell[CellGroupData[{
Cell[48133, 1012, 1413, 37, 70, "ExampleSection",ExpressionUUID->"4f7869cf-9465-4c02-b005-d9f0524e0f96",
 CellID->1293636265],
Cell[49549, 1051, 175, 3, 70, "Input",ExpressionUUID->"2d842018-1127-422c-8814-d8313eb38e83",
 CellID->349404325],
Cell[49727, 1056, 180, 3, 70, "ExampleText",ExpressionUUID->"7c88fb1a-665d-41a1-b9e0-b0a5c58c55b6",
 CellID->886239600],
Cell[CellGroupData[{
Cell[49932, 1063, 1093, 29, 70, "Input",ExpressionUUID->"cfd95697-2510-4881-99a5-3318ceaa177e",
 CellID->2227668],
Cell[51028, 1094, 36356, 602, 282, "Output",ExpressionUUID->"000d167b-b700-4ae6-ac3d-76ed32443b00",
 CellTags->"RasterizedOutput",
 CellID->80628476]
}, Open  ]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "1"}, Closed]]]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "PrimaryExamplesSection"}, Closed]]]],
Cell[87626, 1705, 826, 21, 70, "SeeAlsoSection",ExpressionUUID->"3ab65763-8359-4a5f-baff-74624563cf15"],
Cell[88455, 1728, 729, 19, 70, "MoreAboutSection",ExpressionUUID->"ec2e6cdc-af67-4372-a846-fbbb30c5e2a8"],
Cell[89187, 1749, 825, 24, 70, "RelatedLinksSection",ExpressionUUID->"eb152308-5736-44da-a576-1bd7519f13fe"],
Cell[90015, 1775, 78, 0, 70, "FooterCell",ExpressionUUID->"1d11eba3-95bd-44e3-aa4b-fcd9bf819e6f"]
}
]
*)

(* End of internal cache information *)

