(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 13.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    221986,       4429]
NotebookOptionsPosition[    214678,       4281]
NotebookOutlinePosition[    217207,       4344]
CellTagsIndexPosition[    217083,       4338]
WindowTitle->UtotalAdimNv
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[GridBox[{
   {GridBox[{
      {
       ItemBox[Cell[BoxData[
         RowBox[{
          TemplateBox[{12},
           "Spacer1"], Cell["NEW EO S ARGON PACKAGE SYMBOL", "PacletNameCell",
           TextAlignment->Center,ExpressionUUID->
           "271b5637-ca7a-4768-a743-b35a7dd29a78"], 
          TemplateBox[{8},
           "Spacer1"]}]],
         TextAlignment->Center,ExpressionUUID->
         "07a12401-3a02-4023-8ef2-93fa5cfd2812"],
        Background->RGBColor[0.490196, 0.576471, 0.690196],
        ItemSize->Full], ""}
     },
     GridBoxAlignment->{"Rows" -> {{Center}}},
     GridBoxItemSize->{"Columns" -> {Full, 
         Scaled[0.02]}, "Rows" -> {{2.5}}}], Cell[TextData[{
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "See Also",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "cd717958-5018-4f3a-8f7a-6e39a0847150"]
         }],ExpressionUUID->"79078b0b-2331-4ebc-8214-64ecdc2b88b4"],
         StripOnInput->False],{
        "\"RhoArgonNv\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/RhoArgonNv"], 
         "\"FtotalAdimNv\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/FtotalAdimNv"], 
         "\"HtotalAdimNv\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/HtotalAdimNv"]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"SeeAlso"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "ca90d69d-4ff1-47fc-8b40-afd6a111ae70"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "Related Guides",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "c28144f6-a8b5-4d5e-9b99-457f537da4b1"]
         }],ExpressionUUID->"aba36782-4853-49a3-bc6a-d8f690ea01a3"],
         StripOnInput->False],{
        "\"NewEoSArgon Package\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/guide/NewEoSArgon"]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"MoreAbout"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "90bcf3ed-5ddf-4695-acdf-3ff775f98125"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "URL",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "422a46a6-cc6f-4867-bbac-7e3bacf2a82a"]
         }],ExpressionUUID->"27e4bad3-a7fc-41f0-a26c-bb8e0bbe59ba"],
         StripOnInput->False],{
        "\"NewEoSArgon/ref/UtotalAdimNv\"" :> None, 
         "\"Copy Wolfram Documentation Center URL\"" :> 
         Module[{DocumentationSearch`Private`nb$}, 
           DocumentationSearch`Private`nb$ = 
            NotebookPut[
             Notebook[{Cell["NewEoSArgon/ref/UtotalAdimNv"]}, Visible -> 
               False]]; 
           SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
           FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
           NotebookClose[DocumentationSearch`Private`nb$]; Null], Delimiter, 
         "\"Copy web URL\"" :> 
         Module[{DocumentationSearch`Private`nb$}, 
           DocumentationSearch`Private`nb$ = 
            NotebookPut[
             Notebook[{
               Cell[BoxData[
                 MakeBoxes[
                  Hyperlink[
                   "http://reference.wolfram.com/language/NewEoSArgon/ref/\
UtotalAdimNv.html"], StandardForm]], "Input", TextClipboardType -> 
                 "PlainText"]}, Visible -> False]]; 
           SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
           FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
           NotebookClose[DocumentationSearch`Private`nb$]; Null], 
         "\"Go to web URL\"" :> 
         FrontEndExecute[{
           NotebookLocate[{
             URL[If[TrueQ[DocumentationBuild`Make`Private`wsmlinkQ$33513], 
                 "http://reference.wolfram.com/system-modeler/", 
                 "http://reference.wolfram.com/language/"] <> 
               "NewEoSArgon/ref/UtotalAdimNv" <> ".html"], None}]}]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"URLMenu"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "5bd2ff4b-a79d-4f98-969d-ab91e4346199"]
    }], "AnchorBar",
     CacheGraphics->False,ExpressionUUID->
     "75cd5994-3398-4314-ac49-79e7e8232ffe"]}
  }]], "AnchorBarGrid",
 CellID->1,ExpressionUUID->"2c0bfde0-2c28-478e-a877-b6b575e63038"],

Cell["NewEoSArgon`", "ContextNameCell",ExpressionUUID->"d65a84e0-33f1-41b1-a9f8-1a2cd9b9813e"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     Cell[
     "UtotalAdimNv", "ObjectName",ExpressionUUID->
      "88b93466-47a4-439d-ae81-4cac0569df8a"],
     Cell[BoxData[
      TemplateBox[{8},
       "Spacer1"]],ExpressionUUID->"fb545bdd-797f-40e6-b680-860325c726b9"],
     Cell[BoxData[
     ""], "ObjectNameTranslation",ExpressionUUID->
      "bff7f571-bf5c-48dc-8d12-90290ad0ef39"]
    }],ExpressionUUID->"596138fb-0c2f-4454-b646-21475e070d6e"], 
    "\[SpanFromLeft]"}
  }]], "ObjectNameGrid",ExpressionUUID->"90104a61-c7d7-4843-b71a-\
11150af37657"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     "UtotalAdimNv[",
     StyleBox["T",
      FontSlant->"Italic"],
     ", \[Rho]] \[Congruent] ",
     StyleBox["U",
      FontSlant->"Italic"],
     "/",
     StyleBox["RT",
      FontSlant->"Italic"],
     "\nEnergie interne adimensionnelle en fonction de ",
     StyleBox["T",
      FontSlant->"Italic"],
     " (Kelvin) et de \[Rho] (g/",
     Cell[BoxData[
      SuperscriptBox["cm", "3"]], "InlineFormula",
      FontFamily->"Source Sans Pro",ExpressionUUID->
      "0174ab7b-dab6-4df4-9df9-68aba175174c"],
     ")\n[Non-dimension internal energy versus ",
     StyleBox["T",
      FontSlant->"Italic"],
     " (Kelvin) and \[Rho] (g/",
     Cell[BoxData[
      SuperscriptBox["cm", "3"]], "InlineFormula",
      FontFamily->"Source Sans Pro",ExpressionUUID->
      "e7b70ae4-2d9b-47df-a168-f7f359c3f8d6"],
     ")]"
    }],ExpressionUUID->"fba93df4-c25b-438c-82ad-5ef363880248"]}
  }]], "Usage",ExpressionUUID->"e524aeb2-bdcd-48f8-a7f6-8f2b775a7589"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[Cell[TextData[{
   Cell[BoxData[
    DynamicBox[ToBoxes[
      If[
       MatchQ[
        CurrentValue[
         EvaluationNotebook[], {TaggingRules, "Openers", "NotesSection"}, 
         Closed], 
        Alternatives[Open, True]], 
       Style[
        Graphics[{
          Thickness[0.18], 
          RGBColor[0.8509803921568627, 0.396078431372549, 0], 
          Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
         PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
        0.68 Inherited], 
       Rotate[
        Style[
         Graphics[{
           Thickness[0.18], 
           RGBColor[0.8509803921568627, 0.396078431372549, 0], 
           Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
          PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
         0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
     ImageSizeCache->{
      13.600000000000001`, {0.5800000000000001, 13.020000000000001`}}]],
    ExpressionUUID->"2f76fdac-650b-4a95-a6f0-7a9262b82838"],
   Cell[BoxData[
    TemplateBox[{1},
     "Spacer1"]],ExpressionUUID->"8a7f9d67-0043-46d3-bd28-c4198e9ad552"],
   "Details and Options"
  }], "NotesFrameText",ExpressionUUID->"16b7ca5a-0ffd-4dda-a4c8-34f39df915f7"],
  Appearance->{Automatic, None, "Normal", Automatic},
  BaseStyle->None,
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"], 
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], After, CellContents]}]& ),
  Evaluator->None,
  Method->
   "Preemptive"]],ExpressionUUID->"ab9c6d9c-d821-4d6a-bb2e-0591cd960411"]], \
"NotesSection",
 WholeCellGroupOpener->True,
 CellGroupingRules->{"SectionGrouping", 50},
 CacheGraphics->False,
 CellID->13438702,ExpressionUUID->"b40cae98-3ab6-4ff2-9cb8-0e07270e91c8"],

Cell[TextData[{
 "La fonction est d\[EAcute]finie pour ",
 StyleBox["T",
  FontSlant->"Italic"],
 " >0 et \[Rho] \[GreaterEqual] 0"
}], "Notes",
 CellID->1067943069,ExpressionUUID->"53cc1fd5-3f47-43a1-97b2-c9126259ce1a"],

Cell["\<\
******************************************************************************\
*****\
\>", "Notes",
 CellID->185021568,ExpressionUUID->"7af6172c-ff60-4f51-9dac-2a5f54a29876"],

Cell[TextData[{
 "The function is defined for ",
 StyleBox["T",
  FontSlant->"Italic"],
 " >0 and \[Rho] \[GreaterEqual] 0."
}], "Notes",
 CellID->175218415,ExpressionUUID->"76e090c0-7fa8-49cd-b41d-a26faaa04610"]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "NotesSection"}, Closed]]]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {
       TaggingRules, "Openers", "PrimaryExamplesSection"}, Open], 
      Alternatives[True, Open]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{13.600000000000001`, {5., 8.600000000000001}}]],
  ExpressionUUID->"37956262-aef5-450d-b0e1-a8a37bc7d3af"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"37a44822-2e48-4d6b-863b-c1a30228024e"],
 "Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount",ExpressionUUID->
  "75d706a5-7e60-438f-a18e-52f4729be47f"]
}], "PrimaryExamplesSection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellTags->"PrimaryExamplesSection",
 CellID->161518599,ExpressionUUID->"84a282e3-749f-4714-9015-b93208a5f0ef"],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"},
        Closed], 
      Alternatives[Open, True]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{13.600000000000001`, {5., 8.600000000000001}}]],
  ExpressionUUID->"55a3b47a-d6f2-4ccf-aded-230c97610f48"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"cfa7042f-7023-4fc7-b0aa-9e061f1c6633"],
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "941be355-c8b5-4f23-839c-231fd5782d44"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellID->594191624,ExpressionUUID->"e8d55563-d083-4665-94f6-284160824303"],

Cell[BoxData[{
 RowBox[{"Needs", "[", "\"\<NewEoSArgon`\>\"", "]"}], "\[IndentingNewLine]", 
 RowBox[{"Off", "[", 
  RowBox[{"General", "::", "munfl"}], "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->143015886,ExpressionUUID->"cdab92c3-7799-4555-ba1c-b0491d03be8b"],

Cell[TextData[{
 "Calculated value of ",
 StyleBox["U",
  FontSlant->"Italic"],
 " for atmospheric pressure and 20\[Degree]C"
}], "ExampleText",
 CellID->544149791,ExpressionUUID->"3bf6d715-d6be-40a6-ba2c-25b84d1d17e6"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UnitSimplify", "[", 
  RowBox[{
   RowBox[{"UtotalAdimNv", "[", 
    RowBox[{"293.15", ",", 
     RowBox[{"RhoArgonNv", "[", 
      RowBox[{"293.15", ",", 
       RowBox[{"QuantityMagnitude", "@", 
        RowBox[{"N", "@", 
         RowBox[{"UnitConvert", "[", 
          RowBox[{
           TemplateBox[{"1"},
            "QuantityUnit",
            DisplayFunction->(TooltipBox[
              StyleBox[
               RowBox[{#, "\[InvisibleSpace]", 
                 StyleBox[
                  RowBox[{" ", "\"atm\""}], "QuantityUnitTraditionalLabel"]}],
                ShowStringCharacters -> False], "Unit: atmospheres"]& ),
            InterpretationFunction->(RowBox[{"Quantity", "[", 
               RowBox[{#, ",", "\"Atmospheres\""}], "]"}]& )], ",", 
           "\"\<Bars\>\""}], "]"}]}]}], ",", "\"\<G\>\""}], "]"}]}], "]"}], 
   "*", 
   RowBox[{"Quantity", "[", "\"\<MolarGasConstant\>\"", "]"}], "*", 
   RowBox[{
    RowBox[{"Quantity", "[", 
     RowBox[{"293.15", ",", "\"\<Kelvins\>\""}], "]"}], "/", 
    RowBox[{"Quantity", "[", 
     RowBox[{"M", ",", 
      RowBox[{"\"\<Grams\>\"", "/", "\"\<Moles\>\""}]}], "]"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->5710145,ExpressionUUID->"3a9246e7-f95e-4068-8868-f017865f32e5"],

Cell[BoxData[
 TemplateBox[{"91348.7525052516`", 
   RowBox[{
     SuperscriptBox["\"m\"", "2"], "\[NegativeMediumSpace]", "\"/\"", 
     "\[InvisibleSpace]", 
     SuperscriptBox["\"s\"", "2"]}], "meters squared per second squared", 
   FractionBox[
    SuperscriptBox["\"Meters\"", "2"], 
    SuperscriptBox["\"Seconds\"", "2"]]},
  "Quantity"]], "Output",
 CellLabel->"Out[2]=",
 CellID->135488993,ExpressionUUID->"6362c9e9-acc6-4235-9687-b7dc979ff7d9"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UnitConvert", "[", 
  RowBox[{
   RowBox[{"Quantity", "[", 
    RowBox[{"91348.7525052516`", ",", 
     FractionBox[
      SuperscriptBox["\"\<Meters\>\"", "2"], 
      SuperscriptBox["\"\<Seconds\>\"", "2"]]}], "]"}], ",", 
   RowBox[{"\"\<Joules\>\"", "/", "\"\<Kilograms\>\""}]}], "]"}]], "Input",
 NumberMarks->False,
 CellLabel->"In[3]:=",
 CellID->201965141,ExpressionUUID->"f8c5b8bf-debd-46bf-ab82-1ff91a046d58"],

Cell[BoxData[
 TemplateBox[{"91348.7525052516`", 
   RowBox[{
    "\"J\"", "\[InvisibleSpace]", "\"/\"", "\[InvisibleSpace]", "\"kg\""}], 
   "joules per kilogram", 
   FractionBox["\"Joules\"", "\"Kilograms\""]},
  "Quantity"]], "Output",
 CellLabel->"Out[3]=",
 CellID->130685192,ExpressionUUID->"9d949770-33fe-4a91-9ce1-846b15c36b5c"]
}, Open  ]],

Cell["Using ThermodynamicData package (i.e. REFPROP from NIST)", "ExampleText",
 CellID->361149294,ExpressionUUID->"eb38d447-973c-4a09-9690-02190c9cee9c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UnitConvert", "[", 
  RowBox[{
   RowBox[{"ThermodynamicData", "[", 
    RowBox[{"\"\<Argon\>\"", ",", "\"\<InternalEnergy\>\"", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<Pressure\>\"", "\[Rule]", 
        RowBox[{"Quantity", "[", 
         RowBox[{"1", ",", "\"\<Atmospheres\>\""}], "]"}]}], ",", 
       RowBox[{"\"\<Temperature\>\"", "\[Rule]", 
        RowBox[{"Quantity", "[", 
         RowBox[{"293.15", ",", "\"\<Kelvins\>\""}], "]"}]}]}], "}"}]}], 
    "]"}], ",", 
   RowBox[{"\"\<Joules\>\"", "/", "\"\<Kilograms\>\""}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->375583457,ExpressionUUID->"a5cd4836-4d78-4bbc-887f-e7d932c9bf9b"],

Cell[BoxData[
 TemplateBox[{"91353.15025648654`", 
   RowBox[{
    "\"J\"", "\[InvisibleSpace]", "\"/\"", "\[InvisibleSpace]", "\"kg\""}], 
   "joules per kilogram", 
   FractionBox["\"Joules\"", "\"Kilograms\""]},
  "Quantity"]], "Output",
 CellLabel->"Out[4]=",
 CellID->579155892,ExpressionUUID->"33c5787b-060f-4e90-8fed-62ff28a6c65a"]
}, Open  ]],

Cell["Using WolframAlpha", "ExampleText",
 CellID->721118955,ExpressionUUID->"4c060db4-d48f-4b54-848b-23d1d43fb2a5"],

Cell[CellGroupData[{

Cell[BoxData[
 NamespaceBox["WolframAlphaQueryResults",
  DynamicModuleBox[{Typeset`q$$ = "specific internal energy of argon", 
   Typeset`opts$$ = {
   AppearanceElements -> {"Extrusion", "Warnings", "Assumptions", "Pods"}, 
    Asynchronous -> All, 
    PodStates -> {
     "FeatureHighlightPhaseDiagram:ThermodynamicDataRP__Use kelvins"}, 
    Method -> {
     "ExtrusionChosen" -> {
       "FeatureHighlightPhaseDiagram:ThermodynamicDataRP", "Phase diagram", 1,
         1, "Content"}, "ExtrusionOpen" -> True, 
      "Formats" -> {"cell", "minput", "moutput", "msound", "dataformats"}}}, 
   Typeset`elements$$ = {"Extrusion", "Warnings", "Assumptions", "Pods"}, 
   Typeset`pod1$$ = XMLElement[
   "pod", {"title" -> "Input interpretation", "scanner" -> "Identity", "id" -> 
     "Input", "position" -> "100", "error" -> "false", "numsubpods" -> "1"}, {
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement["cell", {"compressed" -> True, "string" -> False}, {
         Cell[
          BoxData[
           FormBox[
            TagBox[
             FormBox[
              TagBox[
               GridBox[{{
                  PaneBox[
                   StyleBox[
                    TagBox[
                    GridBox[{{
                    StyleBox[
                    TagBox[
                    TagBox["\"argon\"", 
                    $CellContext`TagBoxWrapper[
                    "Entity" -> {ChemicalData, "Argon"}]], Identity], {
                    LineIndent -> 0, LineSpacing -> {0.9, 0, 1.5}}], 
                    TagBox["\"specific internal energy\"", 
                    $CellContext`TagBoxWrapper[
                    "Property" -> {$CellContext`ThermodynamicDataRP, 
                    "InternalEnergy"}]]}}, GridBoxBackground -> {"Columns" -> {
                    GrayLevel[0.949], None}, "Rows" -> {{None}}}, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    ColumnsEqual -> False, RowsEqual -> False, 
                    GridBoxDividers -> {"Columns" -> {
                    GrayLevel[0.84], 
                    GrayLevel[0.84], 
                    GrayLevel[0.84]}, "Rows" -> {{
                    GrayLevel[0.84]}}, 
                    "RowsIndexed" -> {
                    1 -> GrayLevel[0.84], -1 -> GrayLevel[0.84]}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {2, 2, 2}, "Rows" -> {{1}}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Baseline}}}, 
                    AllowScriptLevelChange -> False, BaselinePosition -> 1], 
                    $CellContext`TagBoxWrapper["Separator" -> " | "]], 
                    LineSpacing -> {1, 0, 1.5}, LineIndent -> 0], 
                   BaselinePosition -> Center], 
                  PaneBox[
                   StyleBox[
                    TagBox[
                    GridBox[{{
                    StyleBox["\"temperature\"", {
                    GrayLevel[0.6]}], 
                    StyleBox[
                    TagBox[
                    RowBox[{
                    TagBox[
                    TagBox[
                    RowBox[{"\"20\"", "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    TagBox[
                    StyleBox[
                    "\"\[Degree]C\"", FontFamily -> "Helvetica", FontSize -> 
                    Smaller], HoldForm]}], Identity], #& , SyntaxForm -> Dot],
                     "  ", 
                    StyleBox[
                    
                    RowBox[{"\"(\"", "\[NoBreak]", "\"degrees Celsius\"", 
                    "\[NoBreak]", "\")\""}], {
                    FontFamily :> $CellContext`$UnitFontFamily, FontSize -> 
                    Smaller, 
                    GrayLevel[0.6], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0}, StripOnInput -> False]}], "Unit", SyntaxForm -> Dot], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, ZeroWidthTimes -> False]}, {
                    StyleBox["\"pressure\"", {
                    GrayLevel[0.6]}], 
                    StyleBox[
                    TagBox[
                    RowBox[{
                    TagBox[
                    TagBox[
                    RowBox[{"\"1\"", "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    TagBox[
                    StyleBox[
                    "\"atm\"", FontFamily -> "Helvetica", FontSize -> 
                    Smaller], HoldForm]}], Identity], #& , SyntaxForm -> Dot],
                     "  ", 
                    StyleBox[
                    
                    RowBox[{"\"(\"", "\[NoBreak]", "\"atmosphere\"", 
                    "\[NoBreak]", "\")\""}], {
                    FontFamily :> $CellContext`$UnitFontFamily, FontSize -> 
                    Smaller, 
                    GrayLevel[0.6], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0}, StripOnInput -> False]}], "Unit", SyntaxForm -> Dot], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, ZeroWidthTimes -> False]}}, 
                    GridBoxBackground -> {
                    "Columns" -> {None, None}, "Rows" -> {{None}}}, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    ColumnsEqual -> False, RowsEqual -> False, 
                    GridBoxDividers -> {"Columns" -> {
                    GrayLevel[0.84], 
                    GrayLevel[0.84], 
                    GrayLevel[0.84]}, "Rows" -> {{
                    GrayLevel[0.84]}}, 
                    "RowsIndexed" -> {
                    1 -> GrayLevel[0.84], -1 -> GrayLevel[0.84]}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {2, 2, 2}, "Rows" -> {{1}}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Baseline}}}, 
                    AllowScriptLevelChange -> False, BaselinePosition -> 
                    Automatic], 
                    $CellContext`TagBoxWrapper["Separator" -> " | "]], 
                    LineSpacing -> {1, 0, 1.5}, LineIndent -> 0], 
                   BaselinePosition -> Center]}}, 
                GridBoxItemSize -> {
                 "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                ColumnsEqual -> False, RowsEqual -> False, 
                GridBoxSpacings -> {"Columns" -> {{
                    AbsoluteThickness[-1]}}, "Rows" -> {{0}}}, 
                AllowScriptLevelChange -> False], 
               $CellContext`TagBoxWrapper["Separator" -> " | "]], 
              TraditionalForm], 
             PolynomialForm[#, TraditionalOrder -> False]& ], 
            TraditionalForm]], "Output"]}], 
       XMLElement[
       "dataformats", {}, {"plaintext,computabledata,formatteddata"}]}]}], 
   Typeset`pod2$$ = XMLElement[
   "pod", {"title" -> "Result", "scanner" -> "Data", "id" -> "Result", 
     "position" -> "200", "error" -> "false", "numsubpods" -> "1", "primary" -> 
     "true"}, {
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement[
       "moutput", {}, {"Quantity[91353, \"Joules\"/\"Kilograms\"]"}], 
       XMLElement["cell", {"compressed" -> False, "string" -> True}, {
         Cell[
          BoxData[
           FormBox[
            StyleBox[
             TagBox[
              RowBox[{
                TagBox[
                 TagBox[
                  RowBox[{
                    TagBox["91\[ThinSpace]353", 
                    $CellContext`TagBoxWrapper["StringBoxes" -> "91353"]], 
                    "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    
                    RowBox[{
                    "\"J\"", "\[InvisibleSpace]", "\"/\"", 
                    "\[InvisibleSpace]", "\"kg\""}], FontFamily -> 
                    "Helvetica", FontSize -> Smaller]}], Identity], #& , 
                 SyntaxForm -> Dot], "  ", 
                StyleBox[
                 
                 RowBox[{
                  "\"(\"", "\[NoBreak]", "\"joules per kilogram\"", 
                   "\[NoBreak]", "\")\""}], {
                 FontFamily :> $CellContext`$UnitFontFamily, FontSize -> 
                  Smaller, 
                  GrayLevel[0.6], LinebreakAdjustments -> {1, 100, 1, 0, 100},
                   LineIndent -> 0}, StripOnInput -> False]}], "Unit", 
              SyntaxForm -> Dot], LinebreakAdjustments -> {1, 100, 1, 0, 100},
              LineIndent -> 0, ZeroWidthTimes -> False], TraditionalForm]], 
          "Output"]}], 
       XMLElement[
       "dataformats", {}, {
        "plaintext,moutput,computabledata,formatteddata,numberdata,\
quantitydata"}]}]}], Typeset`pod3$$ = XMLElement[
   "pod", {"title" -> "Unit conversions", "scanner" -> "Unit", "id" -> 
     "UnitConversion", "position" -> "300", "error" -> "false", "numsubpods" -> 
     "5"}, {
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement["cell", {"compressed" -> False, "string" -> True}, {
         Cell[
          BoxData[
           FormBox[
            StyleBox[
             TagBox[
              RowBox[{
                TagBox[
                 TagBox[
                  RowBox[{
                    TagBox["91.35", 
                    $CellContext`TagBoxWrapper["StringBoxes" -> "91.35"]], 
                    "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    
                    RowBox[{
                    "\"J\"", "\[InvisibleSpace]", "\"/\"", 
                    "\[InvisibleSpace]", "\"g\""}], FontFamily -> "Helvetica",
                     FontSize -> Smaller]}], Identity], #& , SyntaxForm -> 
                 Dot], "  ", 
                StyleBox[
                 
                 RowBox[{
                  "\"(\"", "\[NoBreak]", "\"joules per gram\"", "\[NoBreak]", 
                   "\")\""}], {
                 FontFamily :> $CellContext`$UnitFontFamily, FontSize -> 
                  Smaller, 
                  GrayLevel[0.6], LinebreakAdjustments -> {1, 100, 1, 0, 100},
                   LineIndent -> 0}, StripOnInput -> False]}], "Unit", 
              SyntaxForm -> Dot], LinebreakAdjustments -> {1, 100, 1, 0, 100},
              LineIndent -> 0, ZeroWidthTimes -> False], TraditionalForm]], 
          "Output"]}], 
       XMLElement[
       "dataformats", {}, {
        "plaintext,computabledata,formatteddata,numberdata,quantitydata"}]}], 
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement["cell", {"compressed" -> False, "string" -> True}, {
         Cell[
          BoxData[
           FormBox[
            StyleBox[
             TagBox[
              RowBox[{
                TagBox[
                 TagBox[
                  RowBox[{
                    TagBox["21.83", 
                    $CellContext`TagBoxWrapper["StringBoxes" -> "21.83"]], 
                    "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    RowBox[{
                    SubscriptBox["\"cal\"", "\"th\""], "\[InvisibleSpace]", 
                    "\"/\"", "\[InvisibleSpace]", "\"g\""}], FontFamily -> 
                    "Helvetica", FontSize -> Smaller]}], Identity], #& , 
                 SyntaxForm -> Dot], "  ", 
                StyleBox[
                 
                 RowBox[{
                  "\"(\"", "\[NoBreak]", 
                   "\"thermochemical calories per gram\"", "\[NoBreak]", 
                   "\")\""}], {
                 FontFamily :> $CellContext`$UnitFontFamily, FontSize -> 
                  Smaller, 
                  GrayLevel[0.6], LinebreakAdjustments -> {1, 100, 1, 0, 100},
                   LineIndent -> 0}, StripOnInput -> False]}], "Unit", 
              SyntaxForm -> Dot], LinebreakAdjustments -> {1, 100, 1, 0, 100},
              LineIndent -> 0, ZeroWidthTimes -> False], TraditionalForm]], 
          "Output"]}], 
       XMLElement[
       "dataformats", {}, {
        "plaintext,computabledata,formatteddata,numberdata,quantitydata"}]}], 
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement["cell", {"compressed" -> False, "string" -> True}, {
         Cell[
          BoxData[
           FormBox[
            StyleBox[
             TagBox[
              RowBox[{
                TagBox[
                 TagBox[
                  RowBox[{
                    TagBox["21.83", 
                    $CellContext`TagBoxWrapper["StringBoxes" -> "21.83"]], 
                    "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    RowBox[{
                    SubscriptBox["\"kcal\"", "\"th\""], "\[InvisibleSpace]", 
                    "\"/\"", "\[InvisibleSpace]", "\"kg\""}], FontFamily -> 
                    "Helvetica", FontSize -> Smaller]}], Identity], #& , 
                 SyntaxForm -> Dot], "  ", 
                StyleBox[
                 
                 RowBox[{
                  "\"(\"", "\[NoBreak]", 
                   "\"thermochemical kilocalories per kilogram\"", 
                   "\[NoBreak]", "\")\""}], {
                 FontFamily :> $CellContext`$UnitFontFamily, FontSize -> 
                  Smaller, 
                  GrayLevel[0.6], LinebreakAdjustments -> {1, 100, 1, 0, 100},
                   LineIndent -> 0}, StripOnInput -> False]}], "Unit", 
              SyntaxForm -> Dot], LinebreakAdjustments -> {1, 100, 1, 0, 100},
              LineIndent -> 0, ZeroWidthTimes -> False], TraditionalForm]], 
          "Output"]}], 
       XMLElement[
       "dataformats", {}, {
        "plaintext,computabledata,formatteddata,numberdata,quantitydata"}]}], 
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement["cell", {"compressed" -> False, "string" -> True}, {
         Cell[
          BoxData[
           FormBox[
            StyleBox[
             TagBox[
              RowBox[{
                TagBox[
                 TagBox[
                  RowBox[{
                    TagBox["0.02183", 
                    $CellContext`TagBoxWrapper["StringBoxes" -> "0.02183"]], 
                    "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    RowBox[{
                    SubscriptBox["\"kcal\"", "\"th\""], "\[InvisibleSpace]", 
                    "\"/\"", "\[InvisibleSpace]", "\"g\""}], FontFamily -> 
                    "Helvetica", FontSize -> Smaller]}], Identity], #& , 
                 SyntaxForm -> Dot], "  ", 
                StyleBox[
                 
                 RowBox[{
                  "\"(\"", "\[NoBreak]", 
                   "\"thermochemical kilocalories per gram\"", "\[NoBreak]", 
                   "\")\""}], {
                 FontFamily :> $CellContext`$UnitFontFamily, FontSize -> 
                  Smaller, 
                  GrayLevel[0.6], LinebreakAdjustments -> {1, 100, 1, 0, 100},
                   LineIndent -> 0}, StripOnInput -> False]}], "Unit", 
              SyntaxForm -> Dot], LinebreakAdjustments -> {1, 100, 1, 0, 100},
              LineIndent -> 0, ZeroWidthTimes -> False], TraditionalForm]], 
          "Output"]}], 
       XMLElement[
       "dataformats", {}, {
        "plaintext,computabledata,formatteddata,numberdata,quantitydata"}]}], 
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement["cell", {"compressed" -> False, "string" -> True}, {
         Cell[
          BoxData[
           FormBox[
            StyleBox[
             TagBox[
              RowBox[{
                TagBox[
                 TagBox[
                  RowBox[{
                    TagBox["39.27", 
                    $CellContext`TagBoxWrapper["StringBoxes" -> "39.27"]], 
                    "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    RowBox[{
                    SubscriptBox["\"BTU\"", "\"IT\""], "\[InvisibleSpace]", 
                    "\"/\"", "\[InvisibleSpace]", "\"lb\""}], FontFamily -> 
                    "Helvetica", FontSize -> Smaller]}], Identity], #& , 
                 SyntaxForm -> Dot], "  ", 
                StyleBox[
                 
                 RowBox[{
                  "\"(\"", "\[NoBreak]", 
                   "\"IT British thermal units per pound\"", "\[NoBreak]", 
                   "\")\""}], {
                 FontFamily :> $CellContext`$UnitFontFamily, FontSize -> 
                  Smaller, 
                  GrayLevel[0.6], LinebreakAdjustments -> {1, 100, 1, 0, 100},
                   LineIndent -> 0}, StripOnInput -> False]}], "Unit", 
              SyntaxForm -> Dot], LinebreakAdjustments -> {1, 100, 1, 0, 100},
              LineIndent -> 0, ZeroWidthTimes -> False], TraditionalForm]], 
          "Output"]}], 
       XMLElement[
       "dataformats", {}, {
        "plaintext,computabledata,formatteddata,numberdata,quantitydata"}]}], 
     XMLElement["states", {"count" -> "1"}, {
       XMLElement[
       "state", {
        "name" -> "More", "input" -> "UnitConversion__More"}, {}]}]}], 
   Typeset`pod4$$ = XMLElement[
   "pod", {"title" -> "Thermodynamic properties", "scanner" -> "Data", "id" -> 
     "EntrainedTable:ThermodynamicDataRP", "position" -> "400", "error" -> 
     "false", "numsubpods" -> "1"}, {
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement["cell", {"compressed" -> True, "string" -> False}, {
         Cell[
          BoxData[
           FormBox[
            StyleBox[
             TagBox[
              GridBox[{{
                 TagBox[
                  PaneBox[
                  "\"phase\"", 
                   BaseStyle -> {{
                    BaselinePosition -> Baseline, FontColor -> 
                    GrayLevel[0.3]}, LineSpacing -> {0.9, 0, 1.5}, 
                    LinebreakAdjustments -> {1, 10, 10000, 0, 100}, 
                    TextAlignment -> Left}, BaselinePosition -> Baseline], 
                  $CellContext`TagBoxWrapper["Label"]], 
                 TemplateBox[{"\"gas\""}, "RowDefault"]}, {
                 TagBox[
                  PaneBox[
                  "\"temperature\"", 
                   BaseStyle -> {{
                    BaselinePosition -> Baseline, FontColor -> 
                    GrayLevel[0.3]}, LineSpacing -> {0.9, 0, 1.5}, 
                    LinebreakAdjustments -> {1, 10, 10000, 0, 100}, 
                    TextAlignment -> Left}, BaselinePosition -> Baseline], 
                  $CellContext`TagBoxWrapper["Label"]], 
                 TagBox[
                  GridBox[{{
                    StyleBox[
                    TagBox[
                    TagBox[
                    TagBox[
                    RowBox[{
                    TagBox["293.2", 
                    $CellContext`TagBoxWrapper["StringBoxes" -> "293.2"]], 
                    "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    "\"K\"", FontFamily -> "Helvetica", FontSize -> 
                    Smaller]}], Identity], #& , SyntaxForm -> Dot], "Unit", 
                    SyntaxForm -> Dot], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, ZeroWidthTimes -> False]}, {
                    StyleBox[
                    TagBox[
                    TagBox[
                    TagBox[
                    RowBox[{
                    TagBox["20", 
                    $CellContext`TagBoxWrapper["StringBoxes" -> "20"]], 
                    "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    "\"\[Degree]C\"", FontFamily -> "Helvetica", FontSize -> 
                    Smaller]}], Identity], #& , SyntaxForm -> Dot], "Unit", 
                    SyntaxForm -> Dot], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, ZeroWidthTimes -> False]}}, 
                   GridBoxAlignment -> {"Columns" -> {{Left}}}, 
                   DefaultBaseStyle -> "Column", 
                   GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
                  "Column"]}, {
                 TagBox[
                  PaneBox[
                  "\"pressure\"", 
                   BaseStyle -> {{
                    BaselinePosition -> Baseline, FontColor -> 
                    GrayLevel[0.3]}, LineSpacing -> {0.9, 0, 1.5}, 
                    LinebreakAdjustments -> {1, 10, 10000, 0, 100}, 
                    TextAlignment -> Left}, BaselinePosition -> Baseline], 
                  $CellContext`TagBoxWrapper["Label"]], 
                 TagBox[
                  GridBox[{{
                    StyleBox[
                    TagBox[
                    TagBox[
                    TagBox[
                    RowBox[{
                    TagBox["101\[ThinSpace]325", 
                    $CellContext`TagBoxWrapper["StringBoxes" -> "101325"]], 
                    "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    "\"Pa\"", FontFamily -> "Helvetica", FontSize -> 
                    Smaller]}], Identity], #& , SyntaxForm -> Dot], "Unit", 
                    SyntaxForm -> Dot], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, ZeroWidthTimes -> False]}, {
                    StyleBox[
                    TagBox[
                    TagBox[
                    TagBox[
                    RowBox[{
                    TagBox["1", 
                    $CellContext`TagBoxWrapper["StringBoxes" -> "1"]], 
                    "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    "\"atm\"", FontFamily -> "Helvetica", FontSize -> 
                    Smaller]}], Identity], #& , SyntaxForm -> Dot], "Unit", 
                    SyntaxForm -> Dot], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, ZeroWidthTimes -> False]}}, 
                   GridBoxAlignment -> {"Columns" -> {{Left}}}, 
                   DefaultBaseStyle -> "Column", 
                   GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
                  "Column"]}, {
                 TagBox[
                  PaneBox[
                  "\"density\"", 
                   BaseStyle -> {{
                    BaselinePosition -> Baseline, FontColor -> 
                    GrayLevel[0.3]}, LineSpacing -> {0.9, 0, 1.5}, 
                    LinebreakAdjustments -> {1, 10, 10000, 0, 100}, 
                    TextAlignment -> Left}, BaselinePosition -> Baseline], 
                  $CellContext`TagBoxWrapper["Label"]], 
                 TagBox[
                  GridBox[{{
                    StyleBox[
                    TagBox[
                    TagBox[
                    TagBox[
                    RowBox[{
                    TagBox["1.662", 
                    $CellContext`TagBoxWrapper["StringBoxes" -> "1.662"]], 
                    "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    
                    RowBox[{"\"kg\"", "\[InvisibleSpace]", "\"/\"", 
                    "\[InvisibleSpace]", 
                    SuperscriptBox["\"m\"", "3"]}], FontFamily -> "Helvetica",
                     FontSize -> Smaller]}], Identity], #& , SyntaxForm -> 
                    Dot], "Unit", SyntaxForm -> Dot], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, ZeroWidthTimes -> False]}, {
                    StyleBox[
                    TagBox[
                    TagBox[
                    TagBox[
                    RowBox[{
                    TagBox["0.001662", 
                    $CellContext`TagBoxWrapper["StringBoxes" -> "0.001662"]], 
                    "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    
                    RowBox[{"\"g\"", "\[InvisibleSpace]", "\"/\"", 
                    "\[InvisibleSpace]", 
                    SuperscriptBox["\"cm\"", "3"]}], FontFamily -> 
                    "Helvetica", FontSize -> Smaller]}], Identity], #& , 
                    SyntaxForm -> Dot], "Unit", SyntaxForm -> Dot], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, ZeroWidthTimes -> False]}}, 
                   GridBoxAlignment -> {"Columns" -> {{Left}}}, 
                   DefaultBaseStyle -> "Column", 
                   GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
                  "Column"]}, {
                 TagBox[
                  PaneBox[
                   TagBox["\"speed of sound\"", 
                    $CellContext`TagBoxWrapper[
                    "Property" -> {$CellContext`ThermodynamicDataRP, 
                    "SoundSpeed"}]], 
                   BaseStyle -> {{
                    BaselinePosition -> Baseline, FontColor -> 
                    GrayLevel[0.3]}, LineSpacing -> {0.9, 0, 1.5}, 
                    LinebreakAdjustments -> {1, 10, 10000, 0, 100}, 
                    TextAlignment -> Left}, BaselinePosition -> Baseline], 
                  $CellContext`TagBoxWrapper["Label"]], 
                 TagBox[
                  GridBox[{{
                    StyleBox[
                    TagBox[
                    TagBox[
                    TagBox[
                    RowBox[{
                    TagBox["1148", 
                    $CellContext`TagBoxWrapper["StringBoxes" -> "1148"]], 
                    "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    
                    RowBox[{"\"km\"", "\[InvisibleSpace]", "\"/\"", 
                    "\[InvisibleSpace]", "\"h\""}], FontFamily -> "Helvetica",
                     FontSize -> Smaller]}], Identity], #& , SyntaxForm -> 
                    Dot], "Unit", SyntaxForm -> Dot], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, ZeroWidthTimes -> False]}, {
                    StyleBox[
                    TagBox[
                    TagBox[
                    TagBox[
                    RowBox[{
                    TagBox["319", 
                    $CellContext`TagBoxWrapper["StringBoxes" -> "319"]], 
                    "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    
                    RowBox[{"\"m\"", "\[InvisibleSpace]", "\"/\"", 
                    "\[InvisibleSpace]", "\"s\""}], FontFamily -> "Helvetica",
                     FontSize -> Smaller]}], Identity], #& , SyntaxForm -> 
                    Dot], "Unit", SyntaxForm -> Dot], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, ZeroWidthTimes -> False]}}, 
                   GridBoxAlignment -> {"Columns" -> {{Left}}}, 
                   DefaultBaseStyle -> "Column", 
                   GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
                  "Column"]}}, 
               GridBoxAlignment -> {
                "Columns" -> {Left, Left}, "Rows" -> {{Baseline}}}, 
               AutoDelete -> False, 
               GridBoxBackground -> {"Columns" -> {None, None}}, 
               GridBoxFrame -> {"Columns" -> {{True}}, "Rows" -> {{True}}}, 
               GridBoxItemSize -> {
                "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
               GridBoxSpacings -> {"Columns" -> {{1.5}, 2}, "Rows" -> {{1}}}, 
               FrameStyle -> GrayLevel[0.84], BaselinePosition -> Automatic, 
               AllowScriptLevelChange -> False], "Grid"], 
             LineSpacing -> {0.9, 0, 1.5}, LineIndent -> 0, StripOnInput -> 
             False], TraditionalForm]], "Output"]}], 
       XMLElement[
       "dataformats", {}, {
        "plaintext,computabledata,formatteddata,numberdata,quantitydata"}]}], 
     XMLElement["states", {"count" -> "2"}, {
       XMLElement[
       "state", {
        "name" -> "Show non-metric", "input" -> 
         "EntrainedTable:ThermodynamicDataRP__Show non-metric"}, {}], 
       XMLElement[
       "state", {
        "name" -> "More", "input" -> 
         "EntrainedTable:ThermodynamicDataRP__More"}, {}]}], 
     XMLElement["infos", {"count" -> "1"}, {
       XMLElement["info", {}, {
         XMLElement["units", {"count" -> "7"}, {
           XMLElement[
           "unit", {"short" -> "atm", "long" -> "atmospheres"}, {}], 
           XMLElement[
           "unit", {
            "short" -> "g/cm^3", "long" -> "grams per cubic centimeter"}, {}], 
           XMLElement[
           "unit", {
            "short" -> "kg/m^3", "long" -> "kilograms per cubic meter"}, {}], 
           XMLElement["unit", {"short" -> "K", "long" -> "kelvins"}, {}], 
           XMLElement[
           "unit", {"short" -> "km/h", "long" -> "kilometers per hour"}, {}], 
           XMLElement[
           "unit", {"short" -> "m/s", "long" -> "meters per second"}, {}], 
           XMLElement["unit", {"short" -> "Pa", "long" -> "pascals"}, {}], 
           XMLElement["cell", {"compressed" -> False, "string" -> True}, {
             Cell[
              BoxData[
               FormBox[
                StyleBox[
                 TagBox[
                  GridBox[{{
                    StyleBox[
                    StyleBox[
                    TagBox[
                    RowBox[{
                    StyleBox[
                    "\"atm\"", FontFamily -> "Helvetica", FontSize -> 
                    Smaller]}], Identity], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, ZeroWidthTimes -> False], 10, StripOnInput -> False], 
                    StyleBox[
                    "\"atmospheres\"", FontSize -> 10, 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, {FontFamily :> $CellContext`$UnitFontFamily, FontSize -> 
                    Smaller}, 
                    GrayLevel[0.6], StripOnInput -> False]}, {
                    StyleBox[
                    StyleBox[
                    TagBox[
                    RowBox[{
                    StyleBox[
                    
                    RowBox[{
                    "\"g\"", "\[InvisibleSpace]", "\"/\"", 
                    "\[InvisibleSpace]", 
                    SuperscriptBox["\"cm\"", "3"]}], FontFamily -> 
                    "Helvetica", FontSize -> Smaller]}], Identity], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, ZeroWidthTimes -> False], 10, StripOnInput -> False], 
                    StyleBox[
                    "\"grams per cubic centimeter\"", FontSize -> 10, 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, {FontFamily :> $CellContext`$UnitFontFamily, FontSize -> 
                    Smaller}, 
                    GrayLevel[0.6], StripOnInput -> False]}, {
                    StyleBox[
                    StyleBox[
                    TagBox[
                    RowBox[{
                    StyleBox[
                    
                    RowBox[{
                    "\"kg\"", "\[InvisibleSpace]", "\"/\"", 
                    "\[InvisibleSpace]", 
                    SuperscriptBox["\"m\"", "3"]}], FontFamily -> "Helvetica",
                     FontSize -> Smaller]}], Identity], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, ZeroWidthTimes -> False], 10, StripOnInput -> False], 
                    StyleBox[
                    "\"kilograms per cubic meter\"", FontSize -> 10, 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, {FontFamily :> $CellContext`$UnitFontFamily, FontSize -> 
                    Smaller}, 
                    GrayLevel[0.6], StripOnInput -> False]}, {
                    StyleBox[
                    StyleBox[
                    TagBox[
                    RowBox[{
                    StyleBox[
                    "\"K\"", FontFamily -> "Helvetica", FontSize -> 
                    Smaller]}], Identity], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, ZeroWidthTimes -> False], 10, StripOnInput -> False], 
                    StyleBox[
                    "\"kelvins\"", FontSize -> 10, 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, {FontFamily :> $CellContext`$UnitFontFamily, FontSize -> 
                    Smaller}, 
                    GrayLevel[0.6], StripOnInput -> False]}, {
                    StyleBox[
                    StyleBox[
                    TagBox[
                    RowBox[{
                    StyleBox[
                    
                    RowBox[{
                    "\"km\"", "\[InvisibleSpace]", "\"/\"", 
                    "\[InvisibleSpace]", "\"h\""}], FontFamily -> "Helvetica",
                     FontSize -> Smaller]}], Identity], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, ZeroWidthTimes -> False], 10, StripOnInput -> False], 
                    StyleBox[
                    "\"kilometers per hour\"", FontSize -> 10, 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, {FontFamily :> $CellContext`$UnitFontFamily, FontSize -> 
                    Smaller}, 
                    GrayLevel[0.6], StripOnInput -> False]}, {
                    StyleBox[
                    StyleBox[
                    TagBox[
                    RowBox[{
                    StyleBox[
                    
                    RowBox[{
                    "\"m\"", "\[InvisibleSpace]", "\"/\"", 
                    "\[InvisibleSpace]", "\"s\""}], FontFamily -> "Helvetica",
                     FontSize -> Smaller]}], Identity], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, ZeroWidthTimes -> False], 10, StripOnInput -> False], 
                    StyleBox[
                    "\"meters per second\"", FontSize -> 10, 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, {FontFamily :> $CellContext`$UnitFontFamily, FontSize -> 
                    Smaller}, 
                    GrayLevel[0.6], StripOnInput -> False]}, {
                    StyleBox[
                    StyleBox[
                    TagBox[
                    RowBox[{
                    StyleBox[
                    "\"Pa\"", FontFamily -> "Helvetica", FontSize -> Smaller]}
                    ], Identity], LinebreakAdjustments -> {1, 100, 1, 0, 100},
                     LineIndent -> 0, ZeroWidthTimes -> False], 10, 
                    StripOnInput -> False], 
                    StyleBox[
                    "\"pascals\"", FontSize -> 10, 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, {FontFamily :> $CellContext`$UnitFontFamily, FontSize -> 
                    Smaller}, 
                    GrayLevel[0.6], StripOnInput -> False]}}, 
                   GridBoxAlignment -> {
                    "Columns" -> {Left, Left}, "Rows" -> {{Baseline}}}, 
                   AutoDelete -> False, 
                   GridBoxBackground -> {"Columns" -> {{None}}}, 
                   GridBoxFrame -> {
                    "Columns" -> {{True}}, "Rows" -> {{True}}}, 
                   GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                   GridBoxSpacings -> {
                    "Columns" -> {{1.5}}, "Rows" -> {{0.5}}}, FrameStyle -> 
                   GrayLevel[0.84], BaselinePosition -> Automatic, 
                   AllowScriptLevelChange -> False], "Grid"], 
                 LineSpacing -> {0.9, 0, 1.5}, LineIndent -> 0, StripOnInput -> 
                 False], TraditionalForm]], "Output"]}]}]}]}]}], 
   Typeset`pod5$$ = XMLElement[
   "pod", {"title" -> "Phase diagram", "scanner" -> "Data", "id" -> 
     "FeatureHighlightPhaseDiagram:ThermodynamicDataRP", "position" -> "500", 
     "error" -> "false", "numsubpods" -> "1"}, {
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement["cell", {"compressed" -> True, "string" -> False}, {
         Cell[
          BoxData[
           FormBox[
            GraphicsBox[{
              RGBColor[
              0.9921487999999999, 0.8385818666666667, 0.6927381333333333], 
              PolygonBox[CompressedData["
1:eJxF13c81e/7B3B7V0bDiESioZQyiq4rI4o+SY49DkVlRJKWkJGIEJWQKCEU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               "]], 
              RGBColor[0.998154, 0.933974, 0.820264], 
              PolygonBox[
               
               NCache[{{34.70799139519819, -7.00571661241373}, {
                 34.91252718895768, -6.937334987525619}, {
                 35.119487950742865`, -6.868953362637509}, {
                 35.328917063246706`, -6.800571737749398}, {
                 35.540858950182624`, -6.7321901128612875`}, {
                 35.75535910770126, -6.663808487973176}, {
                 35.97246413695107, -6.595426863085066}, {
                 36.19222177783202, -6.527045238196955}, {
                 36.414680943993716`, -6.458663613308845}, {
                 36.63989175913207, -6.390281988420734}, {
                 36.867905594640966`, -6.321900363532623}, {
                 37.0987751086786, -6.253518738644512}, {
                 37.332554286710696`, -6.185137113756402}, {
                 37.569298483596334`, -6.116755488868291}, {
                 37.809064467285246`, -6.0483738639801805`}, {
                 38.05191046419911, -5.97999223909207}, {
                 38.29789620637293, -5.911610614203959}, {
                 38.54708298043684, -5.843228989315849}, {
                 38.79953367852254, -5.774847364427737}, {
                 39.055312851183345`, -5.706465739539627}, {
                 39.314486762421225`, -5.638084114651516}, {
                 39.57712344691951, -5.569702489763405}, {
                 39.84329276958502, -5.501320864875295}, {
                 40.11306648750908, -5.432939239987184}, {
                 40.386518314039954`, -5.3645576150990735`}, {
                 40.663723987931604`, -5.296175990210963}, {
                 40.94476133961909, -5.227794365322852}, {
                 41.22971036722177, -5.159412740434742}, {
                 41.5186533113407, -5.091031115546631}, {
                 41.81167473420561, -5.02264949065852}, {
                 42.10886160219837, -4.95426786577041}, {
                 42.41030337204617, -4.885886240882298}, {
                 42.716092080228236`, -4.8175046159941886`}, {
                 43.02632243742715, -4.749122991106077}, {
                 43.341091925239034`, -4.680741366217967}, {
                 43.660500899258196`, -4.612359741329856}, {
                 43.98465269530023, -4.543978116441745}, {
                 44.31365374092918, -4.475596491553635}, {
                 44.64761367204745, -4.407214866665524}, {
                 44.98664545454281, -4.338833241777413}, {
                 45.33086551184171, -4.270451616889303}, {
                 45.68039385814082, -4.202069992001192}, {
                 46.035354237925965`, -4.133688367113081}, {
                 46.395874272039705`, -4.065306742224971}, {
                 46.76208561066557, -3.99692511733686}, {
                 47.134124093594, -3.9285434924487492`}, {
                 47.51212991831981, -3.8601618675606386`}, {
                 47.8962478160144, -3.791780242672528}, {
                 48.28662723643945, -3.723398617784417}, {
                 48.68342254176519, -3.6550169928963063`}, {
                 49.086793210084316`, -3.5866353680081957`}, {
                 49.49690404912585, -3.518253743120085}, {
                 49.91392542077174, -3.4498721182319745`}, {
                 50.33803347701921, -3.381490493343864}, {
                 50.76941040807576, -3.3131088684557533`}, {
                 51.20824470332086, -3.244727243567642}, {
                 51.65473142591951, -3.1763456186795316`}, {
                 52.109072501928544`, -3.107963993791421}, {
                 52.571477024795655`, -3.0395823689033103`}, {
                 53.0421615762158, -2.9712007440151993`}, {
                 53.52135056437972, -2.9028191191270887`}, {
                 54.0092765807242, -2.834437494238978}, {
                 54.50618077637429, -2.7660558693508674`}, {
                 55.01231325956622, -2.697674244462757}, {
                 55.527933515403895`, -2.629292619574646}, {
                 56.05331084946308, -2.5609109946865356`}, {
                 56.58872485680818, -2.492529369798425}, {
                 57.134465918150845`, -2.4241477449103144`}, {
                 57.69083572499793, -2.3557661200222038`}, {
                 58.25814783578402, -2.287384495134093}, {
                 58.83672826514298, -2.2190028702459825`}, {
                 59.42691610864493, -2.150621245357871}, {
                 60.02906420551456, -2.0822396204697604`}, {
                 60.64353984205222, -2.01385799558165}, {
                 61.27072549870421, -1.9454763706935392`}, {
                 61.911019643975656`, -1.8770947458054286`}, {
                 62.56483757864846, -1.808713120917318}, {
                 63.232612334063035`, -1.7403314960292073`}, {
                 63.91479562854651, -1.6719498711410967`}, {
                 64.61185888642648, -1.603568246252986}, {
                 65.32429432446114, -1.5351866213648755`}, {
                 66.05261611094704, -1.4668049964767649`}, {
                 66.79736160324089, -1.3984233715886543`}, {
                 67.55909266995438, -1.3300417467005436`}, {
                 68.33839710465976, -1.2616601218124321`}, {
                 69.13589013858054, -1.1932784969243215`}, {
                 69.95221606044987, -1.124896872036211}, {
                 70.78804995249891, -1.0565152471481003`}, {
                 71.64409955240707, -0.9881336222599897}, {
                 72.52110725200659, -0.9197519973718791}, {
                 73.41985224460542, -0.8513703724837685}, {
                 74.34115283398269, -0.7829887475956578}, {
                 75.28586891943837, -0.7146071227075472}, {
                 76.2549046727596, -0.6462254978194366}, {
                 77.2492114246207, -0.577843872931326}, {
                 78.26979077978572, -0.5094622480432154}, {
                 79.3176979825564, -0.4410806231551039}, {
                 80.39404555623624, -0.37269899826699326`}, {
                 81.50000724299854, -0.30431737337888265`}, {
                 82.63682227348902, -0.23593574849077203`}, {
                 83.8058, -0.16755412353428056`}, {
                 83.99084518572313, -0.15831041463088358`}, {
                 84.1767597458391, -0.1490667057274857}, {
                 84.36356385495256, -0.13982299682408872`}, {
                 84.5512636801047, -0.13057928792069085`}, {
                 84.7398654406117, -0.12133557901729386`}, {
                 84.92937540853102, -0.11209187011389599`}, {
                 85.11979990913053, -0.102848161210499}, {
                 85.31114532136088, -0.09360445230710113}, {
                 85.50341807833172, -0.08436074340370414}, {
                 85.69662466779197, -0.07511703450030627}, {
                 85.89077163261193, -0.06587332559690928}, {
                 86.0858655712712, -0.05662961669351141}, {
                 86.28191313834682, -0.04738590779011442}, {
                 86.47892104500943, -0.03814219888671655}, {
                 86.67689605951715, -0.028898489983319564`}, {
                 86.8758450077177, -0.01965478107992169}, {
                 87.07577477355166, -0.010411072176524705`}, {
                 87.27669229955929, -0.0011673632731268313`}, {
                 87.47860458739017, 0.008076345630270154}, {87.681518698318, 
                 0.017320054533668028`}, {87.8854417537566, 
                 0.026563763437065013`}, {88.09038093577934, 
                 0.03580747234046289}, {88.29634348764387, 
                 0.04505118124385987}, {88.50333671431687, 
                 0.054294890147257746`}, {88.71136798300378, 
                 0.06353859905065473}, {88.92044472368262, 
                 0.0727823079540526}, {89.13057442963725, 
                 0.08202601685744959}, {89.3417646579974, 
                 0.09126972576084746}, {89.55402303027874, 
                 0.10051343466424445`}, {89.76735723292755, 
                 0.10975714356764232`}, {89.98177501786766, 
                 0.11900085247103931`}, {90.19728420304949, 
                 0.12824456137443718`}, {90.41389267300114, 
                 0.13748827027783417`}, {90.63160837938514, 
                 0.14673197918123204`}, {90.8504393415541, 
                 0.15597568808462903`}, {91.07039364710936, 
                 0.1652193969880269}, {91.29147945246349, 
                 0.1744631058914239}, {91.51370498340428, 
                 0.18370681479482176`}, {91.7370785356587, 
                 0.19295052369821875`}, {91.96160847546244, 
                 0.20219423260161662`}, {92.18730324012778, 
                 0.2114379415050136}, {92.41417133861542, 
                 0.2206816504084106}, {92.64222135210628, 
                 0.22992535931180846`}, {92.87146193457643, 
                 0.23916906821520634`}, {93.10190181337055, 
                 0.24841277711860332`}, {93.33354978977944, 
                 0.2576564860220003}, {93.56641473961605, 
                 0.2669001949253982}, {93.80050561379367, 
                 0.27614390382879517`}, {94.03583143890447, 
                 0.28538761273219304`}, {94.2724013177961, 
                 0.29463132163559}, {94.51022443015258, 0.3038750305389879}, {
                 94.74931003307108, 0.3131187394423849}, {94.98966746164082, 
                 0.32236244834578276`}, {95.23130612951962, 
                 0.33160615724917974`}, {95.4742355295113, 
                 0.3408498661525776}, {95.71846523414051, 
                 0.3500935750559746}, {95.96400489622653, 
                 0.3593372839593725}, {96.2108642494558, 
                 0.36858099286276946`}, {96.45905310895184, 
                 0.37782470176616734`}, {96.7085813718428, 
                 0.3870684106695643}, {96.95945901782667, 
                 0.3963121195729622}, {97.21169610973278, 
                 0.4055558284763592}, {97.46530279408012, 
                 0.41479953737975706`}, {97.72028930163141, 
                 0.42404324628315404`}, {97.97666594794377, 
                 0.4332869551865519}, {98.23444313391289, 
                 0.4425306640899489}, {98.49363134631406, 
                 0.4517743729933468}, {98.75424115833438, 
                 0.46101808189674376`}, {99.01628323010259, 
                 0.47026179080014163`}, {99.27976830920771, 
                 0.4795054997035386}, {99.54470723121388, 
                 0.4887492086069365}, {99.8111109201652, 
                 0.4979929175103335}, {100.07899038908172`, 
                 0.5072366264137314}, {100.34835674044662`, 
                 0.5164803353171283}, {100.61922116668451`, 
                 0.5257240442205262}, {100.89159495062458`, 
                 0.5349677531239232}, {101.16548946595773`, 
                 0.5442114620273211}, {101.44091617767772`, 
                 0.553455170930718}, {101.71788664250836`, 
                 0.5626988798341159}, {101.99641250931926`, 
                 0.5719425887375129}, {102.2765055195242, 
                 0.5811862976409099}, {102.55817750746374`, 
                 0.5904300065443078}, {102.8414404007703, 
                 0.5996737154477056}, {103.12630622071586`, 
                 0.6089174243511026}, {103.41278708253819`, 
                 0.6181611332544996}, {103.70089519574805`, 
                 0.6274048421578975}, {103.99064286441235`, 
                 0.6366485510612954}, {104.28204248740354`, 
                 0.6458922599646924}, {104.57510655868734`, 
                 0.6551359688680893}, {104.86984766744166`, 
                 0.6643796777714872}, {105.16627849830782`, 
                 0.6736233866748842}, {105.46441183151956`, 
                 0.6828670955782821}, {105.76426054302321`, 
                 0.692110804481679}, {106.06583760456346`, 
                 0.7013545133850769}, {106.36915608373204`, 
                 0.7105982222884739}, {106.67422914396622`, 
                 0.7198419311918718}, {106.98107004456625`, 
                 0.7290856400952688}, {107.28969214057224`, 
                 0.7383293489986666}, {107.60010888267915`, 
                 0.7475730579020636}, {107.91233381706951`, 
                 0.7568167668054615}, {108.22638058520111`, 
                 0.7660604757088585}, {108.54226292354369`, 
                 0.7753041846122564}, {108.8599946632582, 
                 0.7845478935156533}, {109.17958972981812`, 
                 0.7937916024190512}, {109.50106214256611`, 
                 0.8030353113224482}, {109.82442601420873`, 
                 0.8122790202258461}, {110.14969555023633`, 
                 0.8215227291292431}, {110.4768850482724, 
                 0.8307664380326409}, {110.80600889734401`, 
                 0.8400101469360379}, {111.13708157706893`, 
                 0.8492538558394358}, {111.47011765675623`, 
                 0.8584975647428328}, {111.80513179441363`, 
                 0.8677412736462307}, {112.1421387356586, 
                 0.8769849825496276}, {112.48115331252426`, 
                 0.8862286914530255}, {112.82219044215708`, 
                 0.8954724003564225}, {113.16526512540015`, 
                 0.9047161092598204}, {113.51039244525099`, 
                 0.9139598181632174}, {113.85758756519375`, 
                 0.9232035270666152}, {114.2068657273904, 
                 0.9324472359700122}, {114.55824225073243`, 
                 0.9416909448734092}, {114.91173252873341`, 
                 0.9509346537768071}, {115.26735202726314`, 
                 0.960178362680205}, {115.62511628210883`, 
                 0.9694220715836019}, {115.98504089635362`, 
                 0.9786657804869989}, {116.34714153756316`, 
                 0.9879094893903968}, {116.7114339347678, 
                 0.9971531982937947}, {117.0779338752275, 
                 1.0063969071971917`}, {117.44665720096857`, 
                 1.0156406161005886`}, {117.81761980507504`, 
                 1.0248843250039865`}, {118.1908376277242, 
                 1.0341280339073844`}, {118.56632665194562`, 
                 1.0433717428107814`}, {118.94410289909038`, 
                 1.0526154517141784`}, {119.32418242399024`, 
                 1.0618591606175762`}, {119.70658130978738`, 
                 1.071102869520974}, {120.09131566241346`, 
                 1.080346578424371}, {120.47840160469522`, 
                 1.089590287327768}, {120.86785527005998`, 
                 1.098833996231166}, {121.25969279581635`, 
                 1.1080777051345638`}, {121.65393031597773`, 
                 1.1173214140379608`}, {122.05058395359653`, 
                 1.1265651229413578`}, {122.44966981257525`, 
                 1.1358088318447557`}, {122.85120396891317`, 
                 1.1450525407481527`}, {123.25520246134765`, 
                 1.1542962496515505`}, {123.6616812813435, 
                 1.1635399585549475`}, {124.07065636238084`, 
                 1.1727836674583454`}, {124.48214356848776`, 
                 1.1820273763617424`}, {124.89615868195884`, 
                 1.1912710852651403`}, {125.31271739020131`, 
                 1.2005147941685372`}, {125.73183527164093`, 
                 1.209758503071935}, {126.15352778061992`, 
                 1.219002211975332}, {126.57781023121808`, 
                 1.22824592087873}, {127.00469777991755`, 
                 1.237489629782127}, {127.43420540703822`, 
                 1.2467333386855248`}, {127.86634789685702`, 
                 1.2559770475889218`}, {128.30113981632977`, 
                 1.2652207564923197`}, {128.73859549231622`, 
                 1.2744644653957167`}, {129.1787289872134, 
                 1.2837081742991145`}, {129.62155407288319`, 
                 1.2929518832025115`}, {130.06708420274563`, 
                 1.3021955921059094`}, {130.5153324818963, 
                 1.3114393010093064`}, {130.96631163507573`, 
                 1.3206830099127043`}, {131.42003397229016`, 
                 1.3299267188161012`}, {131.8765113518465, 
                 1.3391704277194982`}, {132.3357551405165, 
                 1.348414136622896}, {132.7977761704866, 1.357657845526294}, {
                 133.2625846926909, 1.366901554429691}, {133.73019032603708`, 
                 1.376145263333088}, {134.20060200194564`, 
                 1.3853889722364858`}, {134.67382790351365`, 
                 1.3946326811398837`}, {135.14987539847556`, 
                 1.4038763900432807`}, {135.62875096498016`, 
                 1.4131200989466777`}, {136.11046010900722`, 
                 1.4223638078500755`}, {136.59500727201333`, 
                 1.4316075167534734`}, {137.08239572711074`, 
                 1.4408512256568704`}, {137.5726274617188, 
                 1.4500949345602674`}, {138.06570304419176`, 
                 1.4593386434636653`}, {138.56162147135086`, 
                 1.4685823523670631`}, {139.06037999315362`, 
                 1.4778260612704601`}, {139.56197390980867`, 
                 1.487069770173857}, {140.06639633549062`, 
                 1.496313479077255}, {140.57363792127995`, 
                 1.5055571879806529`}, {141.08368652798893`, 
                 1.5148008968840498`}, {141.5965268368966, 
                 1.5240446057874468`}, {142.11213988291723`, 
                 1.5332883146908447`}, {142.63050248996922`, 
                 1.5425320235942417`}, {143.15158658174636`, 
                 1.5517757324976396`}, {143.67535833187867`, 
                 1.5610194414010365`}, {144.20177710423735`, 
                 1.5702631503044344`}, {144.73079411460282`, 
                 1.5795068592078314`}, {145.26235071522774`, 
                 1.5887505681112293`}, {145.79637615679485`, 
                 1.5979942770146263`}, {146.33278460494654`, 
                 1.6072379859180241`}, {146.8714710530752, 
                 1.6164816948214211`}, {147.41230552184987`, 
                 1.625725403724819}, {147.95512442799316`, 
                 1.634969112628216}, {148.49971686641967`, 
                 1.6442128215316139`}, {149.04580060970423`, 
                 1.6534565304350108`}, {149.5929733101083, 
                 1.6627002393384087`}, {150.1405829400286, 
                 1.6719439482418057`}, {150.687, 1.6811876571452036`}, {
                 2999.997, 1.6811876571544468`}, {
                 2999.997, -2 - Log[10]^(-1) Log[101325]}}, CompressedData["
1:eJxV2Gc8lm/YB3CSSH+lrNsqKqWhJavoPOyZjNte961UsqUtW3ZmykjICpVE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                "]]], 
              RGBColor[0.9888385333333334, 0.7798814666666667, 0.5990192], 
              PolygonBox[
               
               NCache[{{0., -2 - Log[10]^(-1) Log[101325]}, {
                 34.70799139519819, -7.00571661241373}, {
                 34.91252718895768, -6.937334987525619}, {
                 35.119487950742865`, -6.868953362637509}, {
                 35.328917063246706`, -6.800571737749398}, {
                 35.540858950182624`, -6.7321901128612875`}, {
                 35.75535910770126, -6.663808487973176}, {
                 35.97246413695107, -6.595426863085066}, {
                 36.19222177783202, -6.527045238196955}, {
                 36.414680943993716`, -6.458663613308845}, {
                 36.63989175913207, -6.390281988420734}, {
                 36.867905594640966`, -6.321900363532623}, {
                 37.0987751086786, -6.253518738644512}, {
                 37.332554286710696`, -6.185137113756402}, {
                 37.569298483596334`, -6.116755488868291}, {
                 37.809064467285246`, -6.0483738639801805`}, {
                 38.05191046419911, -5.97999223909207}, {
                 38.29789620637293, -5.911610614203959}, {
                 38.54708298043684, -5.843228989315849}, {
                 38.79953367852254, -5.774847364427737}, {
                 39.055312851183345`, -5.706465739539627}, {
                 39.314486762421225`, -5.638084114651516}, {
                 39.57712344691951, -5.569702489763405}, {
                 39.84329276958502, -5.501320864875295}, {
                 40.11306648750908, -5.432939239987184}, {
                 40.386518314039954`, -5.3645576150990735`}, {
                 40.663723987931604`, -5.296175990210963}, {
                 40.94476133961909, -5.227794365322852}, {
                 41.22971036722177, -5.159412740434742}, {
                 41.5186533113407, -5.091031115546631}, {
                 41.81167473420561, -5.02264949065852}, {
                 42.10886160219837, -4.95426786577041}, {
                 42.41030337204617, -4.885886240882298}, {
                 42.716092080228236`, -4.8175046159941886`}, {
                 43.02632243742715, -4.749122991106077}, {
                 43.341091925239034`, -4.680741366217967}, {
                 43.660500899258196`, -4.612359741329856}, {
                 43.98465269530023, -4.543978116441745}, {
                 44.31365374092918, -4.475596491553635}, {
                 44.64761367204745, -4.407214866665524}, {
                 44.98664545454281, -4.338833241777413}, {
                 45.33086551184171, -4.270451616889303}, {
                 45.68039385814082, -4.202069992001192}, {
                 46.035354237925965`, -4.133688367113081}, {
                 46.395874272039705`, -4.065306742224971}, {
                 46.76208561066557, -3.99692511733686}, {
                 47.134124093594, -3.9285434924487492`}, {
                 47.51212991831981, -3.8601618675606386`}, {
                 47.8962478160144, -3.791780242672528}, {
                 48.28662723643945, -3.723398617784417}, {
                 48.68342254176519, -3.6550169928963063`}, {
                 49.086793210084316`, -3.5866353680081957`}, {
                 49.49690404912585, -3.518253743120085}, {
                 49.91392542077174, -3.4498721182319745`}, {
                 50.33803347701921, -3.381490493343864}, {
                 50.76941040807576, -3.3131088684557533`}, {
                 51.20824470332086, -3.244727243567642}, {
                 51.65473142591951, -3.1763456186795316`}, {
                 52.109072501928544`, -3.107963993791421}, {
                 52.571477024795655`, -3.0395823689033103`}, {
                 53.0421615762158, -2.9712007440151993`}, {
                 53.52135056437972, -2.9028191191270887`}, {
                 54.0092765807242, -2.834437494238978}, {
                 54.50618077637429, -2.7660558693508674`}, {
                 55.01231325956622, -2.697674244462757}, {
                 55.527933515403895`, -2.629292619574646}, {
                 56.05331084946308, -2.5609109946865356`}, {
                 56.58872485680818, -2.492529369798425}, {
                 57.134465918150845`, -2.4241477449103144`}, {
                 57.69083572499793, -2.3557661200222038`}, {
                 58.25814783578402, -2.287384495134093}, {
                 58.83672826514298, -2.2190028702459825`}, {
                 59.42691610864493, -2.150621245357871}, {
                 60.02906420551456, -2.0822396204697604`}, {
                 60.64353984205222, -2.01385799558165}, {
                 61.27072549870421, -1.9454763706935392`}, {
                 61.911019643975656`, -1.8770947458054286`}, {
                 62.56483757864846, -1.808713120917318}, {
                 63.232612334063035`, -1.7403314960292073`}, {
                 63.91479562854651, -1.6719498711410967`}, {
                 64.61185888642648, -1.603568246252986}, {
                 65.32429432446114, -1.5351866213648755`}, {
                 66.05261611094704, -1.4668049964767649`}, {
                 66.79736160324089, -1.3984233715886543`}, {
                 67.55909266995438, -1.3300417467005436`}, {
                 68.33839710465976, -1.2616601218124321`}, {
                 69.13589013858054, -1.1932784969243215`}, {
                 69.95221606044987, -1.124896872036211}, {
                 70.78804995249891, -1.0565152471481003`}, {
                 71.64409955240707, -0.9881336222599897}, {
                 72.52110725200659, -0.9197519973718791}, {
                 73.41985224460542, -0.8513703724837685}, {
                 74.34115283398269, -0.7829887475956578}, {
                 75.28586891943837, -0.7146071227075472}, {
                 76.2549046727596, -0.6462254978194366}, {
                 77.2492114246207, -0.577843872931326}, {
                 78.26979077978572, -0.5094622480432154}, {
                 79.3176979825564, -0.4410806231551039}, {
                 80.39404555623624, -0.37269899826699326`}, {
                 81.50000724299854, -0.30431737337888265`}, {
                 82.63682227348902, -0.23593574849077203`}, {
                 83.8058, -0.16755412353428056`}, {
                 83.80671146360098, -0.14523978817194294`}, {
                 83.80767097594419, -0.12292545280960532`}, {
                 83.80868106958854, -0.1006111174472677}, {
                 83.80974441053836, -0.07829678208493007}, {
                 83.81086380527056, -0.05598244672259245}, {
                 83.81204220813066, -0.03366811136025483}, {
                 83.81328272911904, -0.011353775997917204`}, {
                 83.81458864208517, 0.010960559364420419`}, {83.8159633933537,
                  0.03327489472675804}, {83.81741061080334, 
                 0.055589230089095665`}, {83.81893411342293, 
                 0.07790356545143329}, {83.82053792136963, 
                 0.10021790081377091`}, {83.82222626655573, 
                 0.12253223617610765`}, {83.824003603791, 
                 0.14484657153844527`}, {83.82587462251092, 
                 0.1671609069007829}, {83.82784425911947, 
                 0.1894752422631205}, {83.82991770998137, 
                 0.21178957762545814`}, {83.83210044509426, 
                 0.23410391298779576`}, {83.83439822247995, 
                 0.2564182483501334}, {83.83681710332944, 
                 0.278732583712471}, {83.83936346794195, 
                 0.3010469190748086}, {83.84204403250044, 
                 0.32336125443714625`}, {83.84486586672524, 
                 0.3456755897994839}, {83.84783641245312, 
                 0.3679899251618215}, {83.85096350318896, 
                 0.3903042605241591}, {83.85425538468164, 
                 0.41261859588649674`}, {83.85772073657549, 
                 0.43493293124883436`}, {83.86136869519592, 
                 0.457247266611172}, {83.865208877525, 0.4795616019735096}, {
                 83.86925140643142, 0.5018759373358472}, {83.87350693721743, 
                 0.5241902726981849}, {83.87798668555295, 
                 0.5465046080605225}, {83.8827024568671, 
                 0.5688189434228601}, {83.88766667727263, 
                 0.5911332787851977}, {83.89289242610333, 
                 0.6134476141475353}, {83.89839347014585, 
                 0.635761949509873}, {83.90418429965466, 
                 0.6580762848722106}, {83.9102801662406, 
                 0.6803906202345473}, {83.91669712272993, 
                 0.7027049555968858}, {83.92345206509415, 
                 0.7250192909592226}, {83.9305627765575, 
                 0.7473336263215602}, {83.93804797399167, 
                 0.7696479616838978}, {83.94592735671682, 
                 0.7919622970462354}, {83.95422165782873, 
                 0.8142766324085731}, {83.96295269818177, 
                 0.8365909677709107}, {83.97214344316303, 
                 0.8589053031332483}, {83.98181806239675, 
                 0.8812196384955859}, {83.99200199252873, 
                 0.9035339738579236}, {84.00272200324522, 
                 0.9258483092202612}, {84.01400626668828, 
                 0.9481626445825988}, {84.02588443043884, 
                 0.9704769799449364}, {84.0383876942443, 0.992791315307274}, {
                 84.05154889067849, 1.0151056506696117`}, {84.06540256992854, 
                 1.0374199860319493`}, {84.07998508891299, 
                 1.059734321394287}, {84.0953347049451, 
                 1.0820486567566245`}, {84.11149167416424, 
                 1.1043629921189622`}, {84.12849835496944, 
                 1.1266773274812998`}, {84.14639931669852, 
                 1.1489916628436374`}, {84.16524145380751, 
                 1.171305998205975}, {84.18507410581638, 
                 1.1936203335683118`}, {84.20594918329837, 
                 1.2159346689306503`}, {84.22792130020241, 
                 1.238249004292987}, {84.2510479128092, 
                 1.2605633396553255`}, {84.27538946563617, 
                 1.2828776750176623`}, {84.30100954461697, 
                 1.3051920103800008`}, {84.32797503789662, 
                 1.3275063457423375`}, {84.35635630459535, 
                 1.3498206811046751`}, {84.3862273519084, 
                 1.3721350164670127`}, {84.41766602092346, 
                 1.3944493518293504`}, {84.4507541815508, 
                 1.416763687191688}, {84.48557793697746, 
                 1.4390780225540256`}, {84.5222278380679, 
                 1.4613923579163632`}, {84.56079910815279, 
                 1.4837066932787009`}, {84.60139187865799, 
                 1.5060210286410385`}, {84.64411143604373, 
                 1.528335364003376}, {84.6890684805359, 
                 1.5506496993657137`}, {84.73637939714894, 
                 1.5729640347280514`}, {84.7861665395103, 
                 1.595278370090389}, {84.8385585270137, 
                 1.6175927054527266`}, {84.8936905558393, 
                 1.6399070408150642`}, {84.95170472439358, 
                 1.6622213761774018`}, {85.01275037373243, 
                 1.6845357115397395`}, {85.07698444354347, 
                 1.706850046902077}, {85.1445718442725, 
                 1.7291643822644147`}, {85.21568584599108, 
                 1.7514787176267523`}, {85.29050848460567, 
                 1.77379305298909}, {85.36923098602033, 
                 1.7961073883514267`}, {85.45205420886596, 
                 1.8184217237137652`}, {85.5391891064138, 
                 1.840736059076102}, {85.63085720829145, 
                 1.8630503944384404`}, {85.72729112261837, 
                 1.8853647298007772`}, {85.82873505917362, 
                 1.9076790651631157`}, {85.93544537420267, 
                 1.9299934005254524`}, {86.04769113745873, 
                 1.952307735887791}, {86.16575472206436, 
                 1.9746220712501277`}, {86.28993241775984, 
                 1.9969364066124653`}, {86.42053506808601, 
                 2.019250741974803}, {86.5578887320268, 
                 2.0415650773371405`}, {86.702335370607, 2.063879412699478}, {
                 86.85423355891027, 2.086193748061816}, {87.01395922394588, 
                 2.1085080834241534`}, {87.18190640875179, 
                 2.130822418786491}, {87.35848806307816, 
                 2.1531367541488287`}, {87.54413686094314, 
                 2.1754510895111663`}, {87.73930604530376, 
                 2.197765424873504}, {87.9444703000219, 
                 2.2200797602358415`}, {88.16012664924914, 
                 2.242394095598179}, {88.38679538428492, 2.264708430960516}, {
                 88.62502101789843, 2.2870227663228544`}, {88.87537326603164, 
                 2.309337101685191}, {89.13844805673264, 
                 2.3316514370475296`}, {89.4148685660928, 
                 2.3539657724098664`}, {89.70528628089369, 
                 2.376280107772205}, {90.01038208759618, 
                 2.3985944431345416`}, {90.33086738724228, 
                 2.42090877849688}, {90.66748523577279, 2.443223113859217}, {
                 91.02101150921648, 2.4655374492215554`}, {91.39225609315281, 
                 2.487851784583892}, {91.78206409582103, 
                 2.5101661199462306`}, {92.19131708422152, 
                 2.5324804553085674`}, {92.62093434255216, 
                 2.554794790670905}, {93.07187415233095, 
                 2.5771091260332426`}, {93.54513509358883, 
                 2.5994234613955802`}, {94.04175736657231, 
                 2.621737796757918}, {94.56282413347328, 
                 2.6440521321202555`}, {95.10946287981552, 
                 2.666366467482593}, {95.68284679526202, 
                 2.6886808028449307`}, {96.28419617378145, 
                 2.7109951382072683`}, {96.91477983331511, 
                 2.733309473569606}, {97.57591655532646, 
                 2.7556238089319436`}, {98.26897654489197, 
                 2.777938144294281}, {98.99538291230361, 2.800252479656619}, {
                 99.75661317750372, 2.8225668150189565`}, {
                 100.55420079905512`, 2.844881150381294}, {
                 101.38973672976707`, 2.867195485743631}, {
                 102.26487100154733`, 2.8895098211059693`}, {
                 103.18131434252106`, 2.911824156468306}, {
                 104.14083982996418`, 2.9341384918306446`}, {
                 105.1452845831084, 2.9564528271929813`}, {
                 106.19655150041343`, 2.97876716255532}, {107.29661104643446`,
                  3.0010814979176565`}, {108.44750309395836`, 
                 3.023395833279995}, {109.6513388276096, 3.045710168642332}, {
                 110.91030271565364`, 3.0680245040046703`}, {
                 112.22665455721952`, 3.090338839367007}, {
                 113.60273161264449`, 3.1126531747293456`}, {
                 115.0409508250763, 3.1349675100916823`}, {
                 116.54381114187794`, 3.157281845454021}, {118.1138959447286, 
                 3.1795961808163575`}, {119.75387559763219`, 
                 3.2019105161786943`}, {121.46651012229384`, 
                 3.2242248515410328`}, {123.25465201053218`, 
                 3.2465391869033713`}, {125.1212491835466, 
                 3.268853522265708}, {127.06934810795092`, 
                 3.2911678576280448`}, {129.1020970785317, 
                 3.3134821929903833`}, {131.22274967768627`, 
                 3.335796528352722}, {133.4346684214503, 
                 3.3581108637150585`}, {135.74132860193984`, 
                 3.3804251990773952`}, {138.14632233591507`, 
                 3.4027395344397338`}, {140.65336282903846`, 
                 3.4250538698020705`}, {143.26628886524708`, 
                 3.447368205164409}, {145.98906953048757`, 
                 3.4696825405267457`}, {148.82580917991723`, 
                 3.4919968758890843`}, {151.78075265750743`, 
                 3.514311211251421}, {154.85829077686998`, 
                 3.5366255466137595`}, {158.06296607200125`, 
                 3.5589398819760962`}, {161.39947882658558`, 
                 3.5812542173384347`}, {164.87269339043976`, 
                 3.6035685527007715`}, {168.48764479171643`, 
                 3.62588288806311}, {172.24954565351325`, 
                 3.6481972234254467`}, {176.1637934236747, 
                 3.6705115587877852`}, {180.2359779267129, 
                 3.692825894150122}, {184.47188924702442`, 
                 3.7151402295124587`}, {188.8775259528354, 
                 3.737454564874797}, {193.45910367067233`, 
                 3.7597689002371357`}, {198.2230640205395, 
                 3.7820832355994725`}, {203.1760839224497, 
                 3.804397570961809}, {208.32508528545893`, 
                 3.8267119063241477`}, {213.67724509092633`, 
                 3.849026241686486}, {219.2400058823366, 3.871340577048823}, {
                 225.02108667469238`, 3.8936549124111597`}, {
                 231.02849429717656`, 3.915969247773498}, {
                 237.27053518357098`, 3.9382835831358367`}, {
                 243.75582762568834`, 3.9605979184981734`}, {
                 250.49331450592868`, 3.98291225386051}, {257.49227652593686`,
                  4.005226589222849}, {264.762345949246, 4.027540924585187}, {
                 272.3135208767548, 4.049855259947524}, {280.1561800748349, 
                 4.072169595309861}, {288.30109837690287`, 
                 4.094483930672199}, {296.7594626803096, 4.116798266034536}, {
                 305.5428885614997, 4.139112601396873}, {314.6634375334729, 
                 4.161426936759211}, {324.13363497073635`, 
                 4.18374127212155}, {333.96648872810255`, 
                 4.206055607483886}, {344.1755084808982, 4.228369942846223}, {
                 354.77472581538285`, 4.250684278208562}, {365.7787150994561, 
                 4.2729986135709}, {377.20261516507696`, 4.295312948933237}, {
                 0., 4.2953129489555515`}}, CompressedData["
1:eJw12Hc4Vv//wHHztrnJupFIRihKMqLzctv7Nm4rhMzskVGKUGQUUZlfKiIU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                "]]], 
              RGBColor[
              0.9954590666666666, 0.8972822666666667, 0.7864570666666667], 
              PolygonBox[CompressedData["
1:eJxlknss1AEAx8+rTPf42Ww4MvKYZKe5bB6pL0upOMZ6UEznXri6B+5kbUnm
EUl1a+UxyxJDaE6X187U5pFdXccmCT08zlgtdcl5pDV/9cd3333++fz1cWGL
YrimJBLJc2t//0ixcM44ysaXpsSd7rOrhwOUA7INUd1/PMwtyOMxrDEZyNMH
35Wj3uwfk7WGqswJGTpvjXwvsbWGMX/mKNdbhiGHPRfaSNag0o0fNbmZGK8T
vX6nJ5Au/dQtm8rAIrMnmKQjUMMSJrqGZmBDbdXk0U0gXNckrmpIBzXiLD2y
loB/2UJji106nMZqC9NLCXDnTvd5lEixn7NseCAnoKMXRmjNpQj9Bm5vEoFD
FU+eXc2VIOZKqW72OAF+npxhbiEBx3IihMIksHm94bZviRgyxd5WpiOBYVVc
wrStGPnOcqd4iy1/W07QYJQI3nFF9iYfaBhVpfb4ZF1CtMTNENlCQ3wXL6C+
/iIyitRvy6/RMBk1JdRPC6F4GN8yF0vDUpihp8lZCGXHz+IDHjTIv75xbuan
YUxbJri2QsWvypn1xvZUrOn3hWmGqKhuDrHnW6XC0bTfxaGKii7L3uwabgoO
0tkbfBEVfm6eZ1z7BUjyXR9XhlBxPomx2soQIO/EfZWJDRX+5aynNpV8PGIz
FaxZCjpTslX2ND5eZmvEFc8pWOhQuNws4GH+Tkrk/A0KpGrlq2ALHsiN5l5+
CRTE3fM6tlbAhfeL6h25PhQoaBgsp3ER/T7ws8aEgt9prfSlCg7Ey6NqhxEy
3H9oCwa8OVDsklQKHpNhlyPUmvUlQ+lKvtyeRUazq7+T/FwyxoLqTpmeJIMV
vrloXGFjJTbUN2o3Gdu9bff0B5xyHHA=
               "]], 
              RGBColor[
              0.8980593333333333, 0.8971646666666667, 0.9449146666666667], 
              PolygonBox[{}], 
              InsetBox[
               BoxData[
                FormBox[
                 StyleBox[
                 "\"gas\"", LinebreakAdjustments -> {1, 100, 1, 0, 100}, 
                  LineIndent -> 0, {FontFamily -> "Verdana", FontSize -> 10}, 
                  GrayLevel[0.5], StripOnInput -> False], TraditionalForm]], 
               Scaled[{0.7500000000000002, 0.35000000000000003`}]], 
              InsetBox[
               BoxData[
                FormBox[
                 StyleBox[
                  TagBox[
                   
                   GridBox[{{"\"supercritical\""}, {"\"region\""}}, 
                    GridBoxAlignment -> {"Columns" -> {{Center}}}, 
                    DefaultBaseStyle -> "Column", 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{0.05}}}], 
                   "Column"], LinebreakAdjustments -> {1, 100, 1, 0, 100}, 
                  LineIndent -> 0, {FontFamily -> "Verdana", FontSize -> 10}, 
                  GrayLevel[0.5], StripOnInput -> False], TraditionalForm]], 
               Scaled[{0.798688845401159, 0.8268297455968487}]], 
              InsetBox[
               BoxData[
                FormBox[
                 StyleBox[
                 "\"liquid\"", LinebreakAdjustments -> {1, 100, 1, 0, 100}, 
                  LineIndent -> 0, {FontFamily -> "Verdana", FontSize -> 10}, 
                  GrayLevel[0.5], StripOnInput -> False], TraditionalForm]], 
               Scaled[{0.23953033268101756`, 0.7310763209393352}]], 
              GrayLevel[0.3961454], 
              Thickness[0.003], 
              LineBox[CompressedData["
1:eJwVxX081IcfAHAPeUh57M7dca38ipHMmmeRj3t2x7k7t3qlJZQ2406nVilS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               "]], 
              InsetBox[
               BoxData[
                FormBox[
                 StyleBox[
                 "\"sublimation curve\"", 
                  LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                  0, 
                  GrayLevel[0.6], StripOnInput -> False], TraditionalForm]], 
               Scaled[{0.312583170254403, 0.20273972602739798`}]], 
              GrayLevel[0.3961454], 
              Thickness[0.003], 
              LineBox[CompressedData["
1:eJwVznk4FNobB3CSEi26JHG5IlE3bcpyS+/JHt1SxjLGMjNIWSJp+Um2yJKy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               "]], 
              InsetBox[
               BoxData[
                FormBox[
                 StyleBox[
                 "\"saturation curve\"", 
                  LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                  0, 
                  GrayLevel[0.6], StripOnInput -> False], TraditionalForm]], 
               Scaled[{0.4003913894324846, 0.5505381604696677}]], 
              GrayLevel[0.3961454], 
              Thickness[0.003], 
              LineBox[CompressedData["
1:eJwV0nk8VPsbwPHBGMwMM6TFkjVLUkTdKO73sbUS0ZlhQkPWKJNduRFKCamm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               "]], 
              InsetBox[
               BoxData[
                FormBox[
                 StyleBox[
                 "\"melting curve\"", 
                  LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                  0, 
                  GrayLevel[0.6], StripOnInput -> False], TraditionalForm]], 
               Scaled[{0.4687084148727982, 0.9151076320939342}]], 
              GrayLevel[0.257923], 
              PointSize[0.021], 
              PointBox[{150.687, 1.6811876571544468`}], 
              InsetBox[
               BoxData[
                FormBox[
                 StyleBox[
                 "\"critical point\"", 
                  LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                  0, 
                  GrayLevel[0.6], StripOnInput -> False], TraditionalForm]], 
               Scaled[{0.4399217221135022, 0.6968297455968695}]], 
              GrayLevel[0.257923], 
              PointSize[0.021], 
              PointBox[{83.8058, -0.16755412353428056`}], 
              InsetBox[
               BoxData[
                FormBox[
                 StyleBox[
                 "\"triple point\"", 
                  LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                  0, 
                  GrayLevel[0.6], StripOnInput -> False], TraditionalForm]], 
               Scaled[{0.3004109589041097, 0.40590998043052906`}]], 
              GrayLevel[0.5343678000000001], 
              PointSize[0.021], 
              PointBox[{293.15, 3.3875862701648884`*^-6}], 
              InsetBox[
               BoxData[
                FormBox[
                 StyleBox[
                 "\"STP\"", LinebreakAdjustments -> {1, 100, 1, 0, 100}, 
                  LineIndent -> 0, 
                  GrayLevel[0.6], StripOnInput -> False], TraditionalForm]], 
               Scaled[{0.5659197651663405, 0.47682974559686975`}]], 
              RGBColor[1, 0, 0], 
              PointSize[0.021], 
              Thickness[0.003], 
              PointBox[{{293.15, 0.}}]}, {GridLines -> Dynamic[
                Map[{{#, 
                   GrayLevel[0.7]}}& , 
                 MousePosition[{"Graphics", Graphics}, None]]], 
              Method -> {"GridLinesInFront" -> True}, AspectRatio -> 0.8, 
              ImageSize -> 300, PlotRange -> 
              NCache[{{-2.2250738585072014`*^-308, 500.0000000000001}, {
                 2 - Log[10]^(-1) Log[101325], 9 - Log[10]^(-1) 
                  Log[101325]}}, {{-2.2250738585072014`*^-308, 
                500.0000000000001}, {-3.00571661241373, 3.99428338758627}}], 
              Frame -> True, PlotRangeClipping -> True, FrameLabel -> {
                FormBox[
                 FormBox[
                  TagBox[
                   FormBox[
                    TemplateBox[{
                    TemplateBox[{
                    StyleBox[
                    "\"temperature\"", 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, {FontFamily -> "Verdana", FontSize -> 10}, 
                    GrayLevel[0.5], StripOnInput -> False], "\"  \""}, 
                    "RowDefault"], 
                    StyleBox[
                    RowBox[{"\"(\"", "\[NoBreak]", 
                    StyleBox[
                    TagBox[
                    RowBox[{
                    StyleBox[
                    "\"K\"", FontFamily -> "Helvetica", FontSize -> 
                    Smaller]}], Identity], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, ZeroWidthTimes -> False], "\[NoBreak]", "\")\""}], {
                    FontFamily -> "Verdana", FontSize -> 10, 
                    GrayLevel[0.5], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0}, StripOnInput -> False]}, "RowDefault"], 
                    TraditionalForm], Format[#, TraditionalForm]& ], 
                  TraditionalForm], TraditionalForm], 
                FormBox[
                 FormBox[
                  TagBox[
                   FormBox[
                    TemplateBox[{
                    TemplateBox[{
                    StyleBox[
                    "\"pressure\"", 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, {FontFamily -> "Verdana", FontSize -> 10}, 
                    GrayLevel[0.5], StripOnInput -> False], "\"  \""}, 
                    "RowDefault"], 
                    StyleBox[
                    RowBox[{"\"(\"", "\[NoBreak]", 
                    StyleBox[
                    TagBox[
                    RowBox[{
                    StyleBox[
                    "\"atm\"", FontFamily -> "Helvetica", FontSize -> 
                    Smaller]}], Identity], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, ZeroWidthTimes -> False], "\[NoBreak]", "\")\""}], {
                    FontFamily -> "Verdana", FontSize -> 10, 
                    GrayLevel[0.5], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0}, StripOnInput -> False]}, "RowDefault"], 
                    TraditionalForm], Format[#, TraditionalForm]& ], 
                  TraditionalForm], TraditionalForm]}, FrameTicks -> {{{{-3, 
                   FormBox[
                    TemplateBox[{"10", 
                    RowBox[{"-", "3"}]}, "Superscript", SyntaxForm -> 
                    SuperscriptBox], TraditionalForm]}, {-2, 
                   FormBox[
                    TemplateBox[{"10", 
                    RowBox[{"-", "2"}]}, "Superscript", SyntaxForm -> 
                    SuperscriptBox], TraditionalForm]}, {-1, 
                   FormBox[
                    TemplateBox[{"10", 
                    RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> 
                    SuperscriptBox], TraditionalForm]}, {0, 
                   FormBox["1", TraditionalForm]}, {1, 
                   FormBox["10", TraditionalForm]}, {2, 
                   FormBox[
                    
                    TemplateBox[{"10", "2"}, "Superscript", SyntaxForm -> 
                    SuperscriptBox], TraditionalForm]}, {3, 
                   FormBox[
                    
                    TemplateBox[{"10", "3"}, "Superscript", SyntaxForm -> 
                    SuperscriptBox], TraditionalForm]}, {4, 
                   FormBox[
                    
                    TemplateBox[{"10", "4"}, "Superscript", SyntaxForm -> 
                    SuperscriptBox], TraditionalForm]}}, None}, {
                Automatic, None}}}], TraditionalForm]], "Output"]}], 
       XMLElement["dataformats", {}, {}]}], 
     XMLElement["states", {"count" -> "3"}, {
       XMLElement[
       "state", {
        "name" -> "Use Celsius", "input" -> 
         "FeatureHighlightPhaseDiagram:ThermodynamicDataRP__Use Celsius"}, \
{}], 
       XMLElement[
       "state", {
        "name" -> "Use megapascals", "input" -> 
         "FeatureHighlightPhaseDiagram:ThermodynamicDataRP__Use \
megapascals"}, {}], 
       XMLElement[
       "state", {
        "name" -> "Hide labels", "input" -> 
         "FeatureHighlightPhaseDiagram:ThermodynamicDataRP__Hide labels"}, \
{}]}]}], Typeset`aux1$$ = {True, False, {False}, True}, Typeset`aux2$$ = {
   True, False, {False}, True}, Typeset`aux3$$ = {
   True, False, {False, False, False, False, False}, True}, Typeset`aux4$$ = {
   True, False, {False}, True}, Typeset`aux5$$ = {True, False, {False}, True},
    Typeset`asyncpods$$ = {}, Typeset`nonpods$$ = {
    XMLElement["sources", {"count" -> "1"}, {
      XMLElement[
      "source", {
       "url" -> 
        "http://www.wolframalpha.com/sources/\
ThermodynamicDataRPSourceInformationNotes.html", "text" -> 
        "Thermodynamic data RP"}, {}]}]}, Typeset`initdone$$ = True, 
   Typeset`queryinfo$$ = {
   "success" -> "true", "error" -> "false", "numpods" -> "5", "datatypes" -> 
    "ThermodynamicDataRP", "timedout" -> "", "timedoutpods" -> "", "timing" -> 
    "1.804", "parsetiming" -> "0.229", "parsetimedout" -> "false", 
    "recalculate" -> "", "id" -> 
    "MSPa74511ib75c8fci6563g800001h47472250f3a8a5", "host" -> 
    "http://www4c.wolframalpha.com", "server" -> "16", "related" -> 
    "http://www4c.wolframalpha.com/api/v2/relatedQueries.jsp?id=\
MSPa74521ib75c8fci6563g8000068c2g5h29i45851c&s=16", "version" -> "2.6"}, 
   Typeset`sessioninfo$$ = {
   "TimeZone" -> 1., 
    "Date" -> {2014, 2, 10, 17, 9, 57.820776`9.514658749635867}, "Line" -> 11,
     "SessionID" -> 23599777074698404575}, Typeset`showpods$$ = {1, 2, 3, 4, 
   5}, Typeset`failedpods$$ = {}, Typeset`chosen$$ = {
   "FeatureHighlightPhaseDiagram:ThermodynamicDataRP", "Phase diagram", 1, 1, 
    "Content"}, Typeset`open$$ = True, Typeset`newq$$ = 
   "specific internal energy of argon"}, 
   DynamicBox[ToBoxes[
     AlphaIntegration`FormatAlphaResults[
      Dynamic[{
       1, {Typeset`pod1$$, Typeset`pod2$$, Typeset`pod3$$, Typeset`pod4$$, 
         Typeset`pod5$$}, {
        Typeset`aux1$$, Typeset`aux2$$, Typeset`aux3$$, Typeset`aux4$$, 
         Typeset`aux5$$}, Typeset`chosen$$, Typeset`open$$, 
        Typeset`elements$$, Typeset`q$$, Typeset`opts$$, Typeset`nonpods$$, 
        Typeset`queryinfo$$, Typeset`sessioninfo$$, Typeset`showpods$$, 
        Typeset`failedpods$$, Typeset`newq$$}]], StandardForm],
    ImageSizeCache->{560., {1021., 19.}},
    TrackedSymbols:>{Typeset`showpods$$, Typeset`failedpods$$}],
   DynamicModuleValues:>{},
   Initialization:>If[
     Not[Typeset`initdone$$], Null; WolframAlphaClient`Private`doAsyncUpdates[
       Hold[{
        Typeset`pod1$$, Typeset`pod2$$, Typeset`pod3$$, Typeset`pod4$$, 
         Typeset`pod5$$}], Typeset`asyncpods$$, 
       Dynamic[Typeset`failedpods$$]]; Typeset`asyncpods$$ = {}; 
     Typeset`initdone$$ = True],
   SynchronousInitialization->False],
  BaseStyle->{Deployed -> True},
  DeleteWithContents->True,
  Editable->False,
  SelectWithContents->True]], "WolframAlphaShortInput",
 CellLabel->"In[11]:=",
 CellID->214209891,ExpressionUUID->"c02f04c3-74ef-4d08-99f3-ebd2ccaa2eec"],

Cell[BoxData[
 GraphicsBox[
  TagBox[RasterBox[CompressedData["
1:eJztvWt3FFeep9vrnDfTa50X/Q1m5luct2fWmjPdXdO1Tt9Wr3kxfbrndEqW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    "], {{0, 262.}, {322., 0}}, {0, 255},
    ColorFunction->RGBColor,
    ImageResolution->{144., 144.},
    SmoothingQuality->"High"],
   BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
   Selectable->False],
  DefaultBaseStyle->"ImageGraphics",
  ImageSize->Automatic,
  ImageSizeRaw->{322., 262.},
  PlotRange->{{0, 322.}, {0, 262.}}]], "Output",
 CellTags->"RasterizedOutput",
 CellLabel->"Out[11]=",
 CellID->47342067,ExpressionUUID->"997d384c-788d-4631-9098-a4cb060e85e9"]
}, Open  ]],

Cell["Internal energy on the saturation curve from NIST", "ExampleText",
 CellID->286706321,ExpressionUUID->"d5724cee-163f-45d1-b558-8828a6e78a86"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"UtotalAdimNv", "[", 
     RowBox[{
      RowBox[{"TSatNIST", "[", "\[Rho]", "]"}], ",", "\[Rho]"}], "]"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"\[Rho]", ",", "\[Rho]trgaz", ",", "\[Rho]trliq"}], "}"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", "Red", "}"}]}], ",", 
   RowBox[{"AxesOrigin", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\[Rho]c", ",", "0"}], "}"}]}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "\"\<\[Rho] (g/\!\(\*SuperscriptBox[\(cm\), \(3\)]\))\>\"", ",", 
      "\"\<\!\(\*StyleBox[\"U\",FontSlant->\"Italic\"]\)/\!\(\*StyleBox[\"RT\"\
,FontSlant->\"Italic\"]\)\>\""}], "}"}]}], ",", 
   RowBox[{"ImageSize", "\[Rule]", "400"}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->605199954,ExpressionUUID->"99e925d7-7dc6-497c-b085-e0802c723c61"],

Cell[BoxData[
 GraphicsBox[
  InterpretationBox[{
    TagBox[{{{}, {}, 
       TagBox[
        {RGBColor[1, 0, 0], AbsoluteThickness[2], Opacity[1.], 
         LineBox[CompressedData["
1:eJwVxXk41GkAB3BsUuuIQWtmhERla2WLio6vozxCbWorWZWrck2urTZyFUpW
hGyIRFLY7HaPNr/XXTTs0op6SCbj1mhmXkL2+OPzfBZ7Be06rCAnJ+f+n/9f
2a9tlJkTDPOG5/yDyydQ/zT01LBnKAy3f05X0ZmAR0ZLs/XyH2Fcqy5eNm8C
GTaJp4bvn0SXe1vuqUGK6ZyZZuvmKHi0PuPcKqc4fGv8j+MxCdCrPLhA0Z7i
rmb+0Xzvc6jSj/VKsKSYjdrBarI/jzaNEBeTbyiu7Ck9aqB6AYo/8PoFWhQv
FA6zmrKS4WLKDuH1yZBtOrImdX8aqtU2HDJOksHaxy7RuCkN663MQ9bHyNCf
ld1dsTEdnvWpPQeOy2CuuC2xTz8DYtfWx12HZGh+U9RtJboMqzteg4UWMsgn
HkrsC82C2iaF42KhFPdD/IIW2edjc+Z9w4htUoR+Up9TfjYfLt7LzD0hhVns
4yvWVfnwn5zb7WIhRWmqUrX3xuuoWaezx2axFAXlRVolqwvglhajW/BJgtTR
d/y1+jfQvja9+qsyCQL93ObsnCzGQfn5JxsWSmDk6ZR1pqQcmp2Ggjufx3GT
6dJ5P+cRMix8Oq5zxGD51j4PVq/E4/rKqE31IxjYq3WA97oaw7oRefqbB3Fc
cSjYLaAe1rYN8rMsEUrORBk9dGiEmeiGMKSyFz87+zfO1WqGypII/gvdt1D7
a6ZOqeVP5F+NfXzZoRMrhIUn7CpaER6tcaZPow36T3Qt3sS9hOtKx2tBDxvh
Z1kVyLNvx5/rJL77XBgo6W+VrjXtAFH2qW/Kz8PpxuxEd1kneiJd7QwNypit
XS3H+L1voB67d53/tWrGJ9NMoN7QBTJcGqBRKWDctL0tay+8hceO4hd/i9qY
1siK8H0VPTDI21Wkb9TJCHeXvZ3Ke4eX7AUXv2zuYvK6kkf4mb0wU95y9dH3
75g4K8W1NFGIGOsmg7YyIbM3/HBCT+B7rK68nTD2ro9p5T2IEnn1Yaw3KVTD
bYCx3DIWme0gQsICrbj06iGmafQPfpNJP9RGbC28N40ySk4RuTp6A3gvqFC9
/6WYWZVkeF5TYRAz3JQQnbBxRj6az/n60yBMj6hMCFgSZnaraPDp8BB0dyp2
mDRImf4P08w/gmHEy0m8zcMpE75dfvOBmhHUhgVIRWGTzGTyh2rfW6NoCgyw
UQmaYq5fD4sbPz+GqkW233rEzTBS3/7Ry6c/4M1M6vhzySyTNd9wlXSVGC+E
kfH0nhxJXu+wYUWpGPGvZl0fGCmQiY5eR0u9cdR8MxRcnv0FoV7PJhVTxqG5
5YRP4HJF0lhfFO4x/yMWpnjkdszOJVpXJ/65FPERc2+ZLp3onkfWONnsd5n4
CF/VMk0+W5kMCP/e2RIswRTPoas4TpWwxrqdjHoluDmjp71PXp2wWt9ylA5I
sb+33NQyVoOcW7ZnlLRIcelezkiHuiZJO6J90NJahrSUeVO5dVokNFpQgAoZ
/KIDmGuvF5Jn86eGdFdSsPjkwVlVNlF55e7KNqV4ufv0tOwrNvnuBlOnbUbB
X+iqdcyQTdo3x+ermVP0TYe1BK1jk74w9b1yGyl+Ev/+mu/JJgrdS6uEThQ1
5TF3Ax6xyca7u38pCaAoru6Z53GUQ2KiH84p5lHE1pl9SA/lkBpndmhhEEX8
5R7t5kgOcezvdr4aRjFmZbliTwaH7Nf1V7gYQdEa8iTzThWHnEiI4YUkUfAC
/IwuLuKSit3C17xkCtvoZtZSEy75bGDv4J9CYbCNGNWac0ncE+Ul3ukUDZ1+
CSxnLkkXZ3Z8n0NRQb120XAuaX/6aatLLsVKZ49jTxO4hJPkfm/7NQrz8bqO
xDQuKTA2vGhfSPHArnP7tyVcIvoYN21bRCE7peCo/JBLTEi/L4opFu3kLRmo
4pLAZMf2DbcpCtfoJdUJuOQ3t1/t1pdScD+LH13p5JJ/AWcS7hw=
          "]]},
        Annotation[#, "Charting`Private`Tag#1"]& ]}, {}},
     {"WolframDynamicHighlight", <|
      "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>}], 
    DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
      Slot["HighlightElements"], 
      Slot["LayoutOptions"], 
      Slot["Meta"], 
      Charting`HighlightActionFunction["DynamicHighlight", {{{{}, {}, 
          Annotation[{
            Directive[
             Opacity[1.], 
             AbsoluteThickness[2], 
             RGBColor[1, 0, 0]], 
            Line[CompressedData["
1:eJwVxXk41GkAB3BsUuuIQWtmhERla2WLio6vozxCbWorWZWrck2urTZyFUpW
hGyIRFLY7HaPNr/XXTTs0op6SCbj1mhmXkL2+OPzfBZ7Be06rCAnJ+f+n/9f
2a9tlJkTDPOG5/yDyydQ/zT01LBnKAy3f05X0ZmAR0ZLs/XyH2Fcqy5eNm8C
GTaJp4bvn0SXe1vuqUGK6ZyZZuvmKHi0PuPcKqc4fGv8j+MxCdCrPLhA0Z7i
rmb+0Xzvc6jSj/VKsKSYjdrBarI/jzaNEBeTbyiu7Ck9aqB6AYo/8PoFWhQv
FA6zmrKS4WLKDuH1yZBtOrImdX8aqtU2HDJOksHaxy7RuCkN663MQ9bHyNCf
ld1dsTEdnvWpPQeOy2CuuC2xTz8DYtfWx12HZGh+U9RtJboMqzteg4UWMsgn
HkrsC82C2iaF42KhFPdD/IIW2edjc+Z9w4htUoR+Up9TfjYfLt7LzD0hhVns
4yvWVfnwn5zb7WIhRWmqUrX3xuuoWaezx2axFAXlRVolqwvglhajW/BJgtTR
d/y1+jfQvja9+qsyCQL93ObsnCzGQfn5JxsWSmDk6ZR1pqQcmp2Ggjufx3GT
6dJ5P+cRMix8Oq5zxGD51j4PVq/E4/rKqE31IxjYq3WA97oaw7oRefqbB3Fc
cSjYLaAe1rYN8rMsEUrORBk9dGiEmeiGMKSyFz87+zfO1WqGypII/gvdt1D7
a6ZOqeVP5F+NfXzZoRMrhIUn7CpaER6tcaZPow36T3Qt3sS9hOtKx2tBDxvh
Z1kVyLNvx5/rJL77XBgo6W+VrjXtAFH2qW/Kz8PpxuxEd1kneiJd7QwNypit
XS3H+L1voB67d53/tWrGJ9NMoN7QBTJcGqBRKWDctL0tay+8hceO4hd/i9qY
1siK8H0VPTDI21Wkb9TJCHeXvZ3Ke4eX7AUXv2zuYvK6kkf4mb0wU95y9dH3
75g4K8W1NFGIGOsmg7YyIbM3/HBCT+B7rK68nTD2ro9p5T2IEnn1Yaw3KVTD
bYCx3DIWme0gQsICrbj06iGmafQPfpNJP9RGbC28N40ySk4RuTp6A3gvqFC9
/6WYWZVkeF5TYRAz3JQQnbBxRj6az/n60yBMj6hMCFgSZnaraPDp8BB0dyp2
mDRImf4P08w/gmHEy0m8zcMpE75dfvOBmhHUhgVIRWGTzGTyh2rfW6NoCgyw
UQmaYq5fD4sbPz+GqkW233rEzTBS3/7Ry6c/4M1M6vhzySyTNd9wlXSVGC+E
kfH0nhxJXu+wYUWpGPGvZl0fGCmQiY5eR0u9cdR8MxRcnv0FoV7PJhVTxqG5
5YRP4HJF0lhfFO4x/yMWpnjkdszOJVpXJ/65FPERc2+ZLp3onkfWONnsd5n4
CF/VMk0+W5kMCP/e2RIswRTPoas4TpWwxrqdjHoluDmjp71PXp2wWt9ylA5I
sb+33NQyVoOcW7ZnlLRIcelezkiHuiZJO6J90NJahrSUeVO5dVokNFpQgAoZ
/KIDmGuvF5Jn86eGdFdSsPjkwVlVNlF55e7KNqV4ufv0tOwrNvnuBlOnbUbB
X+iqdcyQTdo3x+ermVP0TYe1BK1jk74w9b1yGyl+Ev/+mu/JJgrdS6uEThQ1
5TF3Ax6xyca7u38pCaAoru6Z53GUQ2KiH84p5lHE1pl9SA/lkBpndmhhEEX8
5R7t5kgOcezvdr4aRjFmZbliTwaH7Nf1V7gYQdEa8iTzThWHnEiI4YUkUfAC
/IwuLuKSit3C17xkCtvoZtZSEy75bGDv4J9CYbCNGNWac0ncE+Ul3ukUDZ1+
CSxnLkkXZ3Z8n0NRQb120XAuaX/6aatLLsVKZ49jTxO4hJPkfm/7NQrz8bqO
xDQuKTA2vGhfSPHArnP7tyVcIvoYN21bRCE7peCo/JBLTEi/L4opFu3kLRmo
4pLAZMf2DbcpCtfoJdUJuOQ3t1/t1pdScD+LH13p5JJ/AWcS7hw=
             "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
       "HighlightElements" -> <|
         "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
        "LayoutOptions" -> <|
         "PlotRange" -> {{0.0040546000061275735`, 
           1.4168017335853793`}, {-6.962496637424262, 1.4473559625007058`}}, 
          "Frame" -> {{True, True}, {True, True}}, 
          "AxesOrigin" -> {0.535599, 0.}, 
          "ImageSize" -> {400, 400/GoldenRatio}, "Axes" -> {True, True}, 
          "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
          "DefaultStyle" -> {
            Directive[
             Opacity[1.], 
             AbsoluteThickness[2], 
             RGBColor[1, 0, 0]]}, 
          "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
              Identity[
               Part[#, 1]], 
              Identity[
               Part[#, 2]]}& ), 
            "ScalingFunctions" -> {{Identity, Identity}, {
              Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>,
         "Meta" -> <|
         "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
          Plot, "GroupHighlight" -> False|>|>]]& )[<|
      "HighlightElements" -> <|
        "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
       "LayoutOptions" -> <|
        "PlotRange" -> {{0.0040546000061275735`, 
          1.4168017335853793`}, {-6.962496637424262, 1.4473559625007058`}}, 
         "Frame" -> {{True, True}, {True, True}}, 
         "AxesOrigin" -> {0.535599, 0.}, 
         "ImageSize" -> {400, 400/GoldenRatio}, "Axes" -> {True, True}, 
         "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
         "DefaultStyle" -> {
           Directive[
            Opacity[1.], 
            AbsoluteThickness[2], 
            RGBColor[1, 0, 0]]}, 
         "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
             Identity[
              Part[#, 1]], 
             Identity[
              Part[#, 2]]}& ), 
           "ScalingFunctions" -> {{Identity, Identity}, {
             Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>, 
       "Meta" -> <|
        "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
         Plot, "GroupHighlight" -> False|>|>],
     ImageSizeCache->{{4.503599627370496*^15, -4.503599627370496*^15}, {
      4.503599627370496*^15, -4.503599627370496*^15}}]},
   Annotation[{{{{}, {}, 
       Annotation[{
         Directive[
          Opacity[1.], 
          AbsoluteThickness[2], 
          RGBColor[1, 0, 0]], 
         Line[CompressedData["
1:eJwVxXk41GkAB3BsUuuIQWtmhERla2WLio6vozxCbWorWZWrck2urTZyFUpW
hGyIRFLY7HaPNr/XXTTs0op6SCbj1mhmXkL2+OPzfBZ7Be06rCAnJ+f+n/9f
2a9tlJkTDPOG5/yDyydQ/zT01LBnKAy3f05X0ZmAR0ZLs/XyH2Fcqy5eNm8C
GTaJp4bvn0SXe1vuqUGK6ZyZZuvmKHi0PuPcKqc4fGv8j+MxCdCrPLhA0Z7i
rmb+0Xzvc6jSj/VKsKSYjdrBarI/jzaNEBeTbyiu7Ck9aqB6AYo/8PoFWhQv
FA6zmrKS4WLKDuH1yZBtOrImdX8aqtU2HDJOksHaxy7RuCkN663MQ9bHyNCf
ld1dsTEdnvWpPQeOy2CuuC2xTz8DYtfWx12HZGh+U9RtJboMqzteg4UWMsgn
HkrsC82C2iaF42KhFPdD/IIW2edjc+Z9w4htUoR+Up9TfjYfLt7LzD0hhVns
4yvWVfnwn5zb7WIhRWmqUrX3xuuoWaezx2axFAXlRVolqwvglhajW/BJgtTR
d/y1+jfQvja9+qsyCQL93ObsnCzGQfn5JxsWSmDk6ZR1pqQcmp2Ggjufx3GT
6dJ5P+cRMix8Oq5zxGD51j4PVq/E4/rKqE31IxjYq3WA97oaw7oRefqbB3Fc
cSjYLaAe1rYN8rMsEUrORBk9dGiEmeiGMKSyFz87+zfO1WqGypII/gvdt1D7
a6ZOqeVP5F+NfXzZoRMrhIUn7CpaER6tcaZPow36T3Qt3sS9hOtKx2tBDxvh
Z1kVyLNvx5/rJL77XBgo6W+VrjXtAFH2qW/Kz8PpxuxEd1kneiJd7QwNypit
XS3H+L1voB67d53/tWrGJ9NMoN7QBTJcGqBRKWDctL0tay+8hceO4hd/i9qY
1siK8H0VPTDI21Wkb9TJCHeXvZ3Ke4eX7AUXv2zuYvK6kkf4mb0wU95y9dH3
75g4K8W1NFGIGOsmg7YyIbM3/HBCT+B7rK68nTD2ro9p5T2IEnn1Yaw3KVTD
bYCx3DIWme0gQsICrbj06iGmafQPfpNJP9RGbC28N40ySk4RuTp6A3gvqFC9
/6WYWZVkeF5TYRAz3JQQnbBxRj6az/n60yBMj6hMCFgSZnaraPDp8BB0dyp2
mDRImf4P08w/gmHEy0m8zcMpE75dfvOBmhHUhgVIRWGTzGTyh2rfW6NoCgyw
UQmaYq5fD4sbPz+GqkW233rEzTBS3/7Ry6c/4M1M6vhzySyTNd9wlXSVGC+E
kfH0nhxJXu+wYUWpGPGvZl0fGCmQiY5eR0u9cdR8MxRcnv0FoV7PJhVTxqG5
5YRP4HJF0lhfFO4x/yMWpnjkdszOJVpXJ/65FPERc2+ZLp3onkfWONnsd5n4
CF/VMk0+W5kMCP/e2RIswRTPoas4TpWwxrqdjHoluDmjp71PXp2wWt9ylA5I
sb+33NQyVoOcW7ZnlLRIcelezkiHuiZJO6J90NJahrSUeVO5dVokNFpQgAoZ
/KIDmGuvF5Jn86eGdFdSsPjkwVlVNlF55e7KNqV4ufv0tOwrNvnuBlOnbUbB
X+iqdcyQTdo3x+ermVP0TYe1BK1jk74w9b1yGyl+Ev/+mu/JJgrdS6uEThQ1
5TF3Ax6xyca7u38pCaAoru6Z53GUQ2KiH84p5lHE1pl9SA/lkBpndmhhEEX8
5R7t5kgOcezvdr4aRjFmZbliTwaH7Nf1V7gYQdEa8iTzThWHnEiI4YUkUfAC
/IwuLuKSit3C17xkCtvoZtZSEy75bGDv4J9CYbCNGNWac0ncE+Ul3ukUDZ1+
CSxnLkkXZ3Z8n0NRQb120XAuaX/6aatLLsVKZ49jTxO4hJPkfm/7NQrz8bqO
xDQuKTA2vGhfSPHArnP7tyVcIvoYN21bRCE7peCo/JBLTEi/L4opFu3kLRmo
4pLAZMf2DbcpCtfoJdUJuOQ3t1/t1pdScD+LH13p5JJ/AWcS7hw=
          "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
    "HighlightElements" -> <|
      "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
     "LayoutOptions" -> <|
      "PlotRange" -> {{0.0040546000061275735`, 
        1.4168017335853793`}, {-6.962496637424262, 1.4473559625007058`}}, 
       "Frame" -> {{True, True}, {True, True}}, 
       "AxesOrigin" -> {0.535599, 0.}, "ImageSize" -> {400, 400/GoldenRatio}, 
       "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
       GoldenRatio^(-1), "DefaultStyle" -> {
         Directive[
          Opacity[1.], 
          AbsoluteThickness[2], 
          RGBColor[1, 0, 0]]}, 
       "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
           Identity[
            Part[#, 1]], 
           Identity[
            Part[#, 2]]}& ), 
         "ScalingFunctions" -> {{Identity, Identity}, {Identity, Identity}}|>,
        "Primitives" -> {}, "GCFlag" -> False|>, 
     "Meta" -> <|
      "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
       Plot, "GroupHighlight" -> False|>|>, "DynamicHighlight"]],
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0.535599, 0.},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{
     FormBox[
      TagBox[
      "\"\\!\\(\\*StyleBox[\\\"U\\\",FontSlant->\\\"Italic\\\"]\\)/\\!\\(\\*\
StyleBox[\\\"RT\\\",FontSlant->\\\"Italic\\\"]\\)\"", HoldForm], 
      TraditionalForm], None}, {
     FormBox[
      TagBox[
      "\"\[Rho] (g/\\!\\(\\*SuperscriptBox[\\(cm\\), \\(3\\)]\\))\"", 
       HoldForm], TraditionalForm], None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  ImageSize->400,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0.0040546000061275735`, 
   1.4168017335853793`}, {-6.962496637424262, 1.4473559625007058`}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellLabel->"Out[5]=",
 CellID->390212211,ExpressionUUID->"e8c33912-03f5-4f56-914a-79b14d655930"]
}, Open  ]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"}, 
  Closed]]]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "2"},
        Closed], 
      Alternatives[Open, True]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{
    13.600000000000001`, {0.5800000000000001, 13.020000000000001`}}]],
  ExpressionUUID->"db832231-a023-4500-99c3-29836c446e88"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"d8a3a577-10db-4f09-8c19-86ae29b90e6e"],
 "Applications",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "3ce77e39-a24a-482b-8211-1f6fb8a41f17"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellID->258228157,ExpressionUUID->"54c8d2c9-b487-447e-ab66-f09d5b43da72"],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<NewEoSArgon`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->87419684,ExpressionUUID->"58e49f81-881c-4a35-9470-35347f5dcf9f"],

Cell[TextData[{
 "Comparison with ",
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["NIST data"]], "http://webbook.nist.gov/chemistry/fluid/"},
   "WebLink",
   BaseStyle->{"ExampleText"}]],ExpressionUUID->
  "f69a0c1f-7715-48cf-9934-59d22aced8ea"],
 " on an isotherm close to the critical isotherm"
}], "ExampleText",
 CellID->227520913,ExpressionUUID->"3dd5e761-b419-41f5-a311-bc066f1ddce5"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"datafile", "=", 
   RowBox[{"FileNameJoin", "[", 
    RowBox[{"{", 
     RowBox[{
     "\"\<NewEoSArgon\>\"", ",", "\"\<DataFiles\>\"", ",", 
      "\"\<DataCritNIST.dat\>\""}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dataNIST", "=", 
   RowBox[{"Import", "[", "datafile", "]"}]}], ";"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->531122037,ExpressionUUID->"469daa66-25b5-4402-ac6f-c1fb9677b59c"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ArT150p7U", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"dataNIST", "[", 
        RowBox[{"[", 
         RowBox[{"i", ",", "3"}], "]"}], "]"}], ",", 
       RowBox[{"dataNIST", "[", 
        RowBox[{"[", 
         RowBox[{"i", ",", "5"}], "]"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "2", ",", "51"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Legended", "[", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"RR", "*", "150.7", "*", 
      RowBox[{
       RowBox[{"UtotalAdimNv", "[", 
        RowBox[{"150.7", ",", "x"}], "]"}], "/", "1000"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0.0000319`", ",", "1.6046`"}], "}"}], ",", 
     RowBox[{"AxesOrigin", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\[Rho]c", ",", "0"}], "}"}]}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
     RowBox[{"Frame", "\[Rule]", "True"}], ",", 
     RowBox[{"FrameLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
       "\"\<\[Rho] (g/\!\(\*SuperscriptBox[\(cm\), \(3\)]\))\>\"", ",", 
        "\"\<\!\(\*StyleBox[\"U\",FontSlant->\"Italic\"]\) (kJ/mole)\>\"", 
        ",", "\"\<ISOTHERM 150.7 K\>\""}], "}"}]}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", "Red", "}"}]}], ",", 
     RowBox[{"Epilog", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"PointSize", "\[Rule]", "Medium"}], ",", 
        RowBox[{"Map", "[", 
         RowBox[{"Point", ",", "ArT150p7U"}], "]"}]}], "}"}]}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "450"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Placed", "[", 
      RowBox[{
       RowBox[{"PointLegend", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"Directive", "[", 
           RowBox[{"Black", ",", 
            RowBox[{"AbsolutePointSize", "[", "6", "]"}]}], "]"}], "}"}], ",", 
         RowBox[{"{", "\"\<NIST database\>\"", "}"}]}], "]"}], ",", "Below"}],
       "]"}], ",", 
     RowBox[{"Placed", "[", 
      RowBox[{
       RowBox[{"LineLegend", "[", 
        RowBox[{
         RowBox[{"{", "Red", "}"}], ",", 
         RowBox[{
         "{", "\"\<UtotalAdimNv[\!\(\*StyleBox[\"T\",FontSlant->\"Italic\"]\),\
\[Rho]]\>\"", "}"}]}], "]"}], ",", "Below"}], "]"}]}], "}"}]}], 
  "]"}]}], "Input",
 CellLabel->"In[3]:=",
 CellID->136921489,ExpressionUUID->"7f23fa86-e59b-42a3-ba94-0bb6b40b9dd4"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[
    InterpretationBox[{
      TagBox[{{{{}, {}, 
          TagBox[{
            Directive[
             Opacity[1.], 
             AbsoluteThickness[2], 
             RGBColor[1, 0, 0]], 
            LineBox[CompressedData["
1:eJwVyms0lHkcwPFxTcY8YposSSlyL10d1vYzkwrluKQiliiiIazIonIp25Hd
qFaasLQIsdmSmOT5xxAZlxixRK6FGZcxg3lGtLsvvufz5qvrF+rqL0sikY7/
1/8WW7a2zb0mwYPp9XeUsVVIjPTzVDGlAyM9eLRXbhVekAU87UJnqGdLOVXE
CrR9KFfTP3sGzF7X93uOr4CnNdW8mB4GXQFpySdrVkA31Bb45vEwYnH5TkfQ
ClxXGjicapgGcfKZWtc4X2H/ieJ3Xnq5cO7BhOMPscvAz9xZN9peDvd5qdV7
qiQQUsTUdCKqQJAvJhsaLwKDfu7bYBwCZ0zVrq1MBF9rRrjjXRxgDmBzN2SE
4NScfv/tUBPsF2jVhVGnwWVs3eto21agiq38Gdwv4LS7g9fd3AFRGs7rvz0f
gTdW5c1e3E6o1v1ZW33DR0hxkDCPSnmgId2kvNWiE3If9aYayPVAitjuVH5C
HXia0dM5Mv9ADqvyhu3VXyAEVzvYbNIPXZfGAg3cEc59EBPxynwAksidyWWb
OvDE2KMuNN9PINg+JfSx6cVnjriuzawfgiJh7aHzFZ9wxqKDkTZnGKQf1Oig
PYrTi5Y2u/WNQI/xvOvfEZ/xgKtz3bKDo8CgSW7vuzSJW7hn+/kvjUHRgjqL
8kSAex7FfIvIn0FBToG3u28WL/Br0fGjfIHkbbhKZZgQf3jF+nm73gScKXQp
GdIR4S9rCMUKo0nwuR0feoktxvVpsdxooylQbHKKCzu1iEN4eaDwAB9KP6lM
S3Ul+DXhLs4QXQBXiu+2MHsInBl5fjHp9DREedxVpr9axovVfVlrLs5AmFeK
h8YfKzjGK1yRCZ2F4OKugu+CvuFpxzo29jLmYDxC8Lj1KQmZ0iMypzhzkM3N
UXXMkkHhDIljiK0QynIDjxndkEWph3pmmtuE4EhkT0oT5BD7tNfssNM8JA6P
HpAGy6Pa8O/7u/rngZm+5q/kIAXUzULbE7xFcC9PMVLNVRH93mHwJGdQBDcl
INu0aw0yUZrUyggSw9kGqt4hHSXEc3GesuOLIYBotOwVKaHj2WoF3ZcXgPbe
Wkf0fi2KXajI7JRZhO4u54GFXGVU6bPKT0lcBAUydV/dSTJ625JnvAlbAipj
UiyiqCC+Pb/pQtoSJK/lU0NKVFA1b0Ou4ToJqB7uGePupSAv3yw/xJLAQckZ
3q0qCupR1X/akCWBWyI7hgubglxry5bf5UjAqnvbb7QaCrLbiN/rfiQBTS/n
WhZOQXu6hxunSiTQ19QTdb+RgpTtDUxoryTwTNF+2YNHQS/Nn4mC+iWgF7H8
hTRLQeqkputUbQL8P36l1W/B0I4EjtRNh4DzlUZ7grZiyEH2TVjGFgLuvr/W
QtHDUJI820tTnwBJHofpaoAhsVLp3s07CHjx8sqPzWYY+qCWNmZsQ8BBpyNZ
IVYYYm1zt2WcI6Ai2A5SXTFUme/GTgogQKe1upfkhqFOfRfzhkACpMEegxEn
MEQ2dNC2CyFAI8fO9IQ7huJMrcWOUQSYhc02yHtjyHvflnyPmwTUWIzf1AjC
UEylttbDFAJY8XjZTxcwlGGhmfYxlYC4UX8LLhND7ZbqcT7pBDy1pV+OuYgh
mwPybv4sAsh+Pln1ERjywknvCrMIGGxv7FOLxFC0zQpM5BBgv8slxjsKQ+WM
RRPmnwQIxpf75qMxxK2fzyst+O9f3f3QKgZDE7azGjOPCYjIYLPjYzEk38j/
dWcJAb32OpYNcRjSPTIhF15KQF3rJE3pKob+BV4QpQY=
             "]]}, Annotation[#, "Charting`Private`Tag#1"]& ]}}, {}}, {
       "WolframDynamicHighlight", <|
        "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>}], 
      DynamicBox[
       (Charting`HighlightActionBox["DynamicHighlight", {}, 
        Slot["HighlightElements"], 
        Slot["LayoutOptions"], 
        Slot["Meta"], 
        Charting`HighlightActionFunction["DynamicHighlight", {{{{}, {}, 
            Annotation[{
              Directive[
               Opacity[1.], 
               AbsoluteThickness[2], 
               RGBColor[1, 0, 0]], 
              Line[CompressedData["
1:eJwVyms0lHkcwPFxTcY8YposSSlyL10d1vYzkwrluKQiliiiIazIonIp25Hd
qFaasLQIsdmSmOT5xxAZlxixRK6FGZcxg3lGtLsvvufz5qvrF+rqL0sikY7/
1/8WW7a2zb0mwYPp9XeUsVVIjPTzVDGlAyM9eLRXbhVekAU87UJnqGdLOVXE
CrR9KFfTP3sGzF7X93uOr4CnNdW8mB4GXQFpySdrVkA31Bb45vEwYnH5TkfQ
ClxXGjicapgGcfKZWtc4X2H/ieJ3Xnq5cO7BhOMPscvAz9xZN9peDvd5qdV7
qiQQUsTUdCKqQJAvJhsaLwKDfu7bYBwCZ0zVrq1MBF9rRrjjXRxgDmBzN2SE
4NScfv/tUBPsF2jVhVGnwWVs3eto21agiq38Gdwv4LS7g9fd3AFRGs7rvz0f
gTdW5c1e3E6o1v1ZW33DR0hxkDCPSnmgId2kvNWiE3If9aYayPVAitjuVH5C
HXia0dM5Mv9ADqvyhu3VXyAEVzvYbNIPXZfGAg3cEc59EBPxynwAksidyWWb
OvDE2KMuNN9PINg+JfSx6cVnjriuzawfgiJh7aHzFZ9wxqKDkTZnGKQf1Oig
PYrTi5Y2u/WNQI/xvOvfEZ/xgKtz3bKDo8CgSW7vuzSJW7hn+/kvjUHRgjqL
8kSAex7FfIvIn0FBToG3u28WL/Br0fGjfIHkbbhKZZgQf3jF+nm73gScKXQp
GdIR4S9rCMUKo0nwuR0feoktxvVpsdxooylQbHKKCzu1iEN4eaDwAB9KP6lM
S3Ul+DXhLs4QXQBXiu+2MHsInBl5fjHp9DREedxVpr9axovVfVlrLs5AmFeK
h8YfKzjGK1yRCZ2F4OKugu+CvuFpxzo29jLmYDxC8Lj1KQmZ0iMypzhzkM3N
UXXMkkHhDIljiK0QynIDjxndkEWph3pmmtuE4EhkT0oT5BD7tNfssNM8JA6P
HpAGy6Pa8O/7u/rngZm+5q/kIAXUzULbE7xFcC9PMVLNVRH93mHwJGdQBDcl
INu0aw0yUZrUyggSw9kGqt4hHSXEc3GesuOLIYBotOwVKaHj2WoF3ZcXgPbe
Wkf0fi2KXajI7JRZhO4u54GFXGVU6bPKT0lcBAUydV/dSTJ625JnvAlbAipj
UiyiqCC+Pb/pQtoSJK/lU0NKVFA1b0Ou4ToJqB7uGePupSAv3yw/xJLAQckZ
3q0qCupR1X/akCWBWyI7hgubglxry5bf5UjAqnvbb7QaCrLbiN/rfiQBTS/n
WhZOQXu6hxunSiTQ19QTdb+RgpTtDUxoryTwTNF+2YNHQS/Nn4mC+iWgF7H8
hTRLQeqkputUbQL8P36l1W/B0I4EjtRNh4DzlUZ7grZiyEH2TVjGFgLuvr/W
QtHDUJI820tTnwBJHofpaoAhsVLp3s07CHjx8sqPzWYY+qCWNmZsQ8BBpyNZ
IVYYYm1zt2WcI6Ai2A5SXTFUme/GTgogQKe1upfkhqFOfRfzhkACpMEegxEn
MEQ2dNC2CyFAI8fO9IQ7huJMrcWOUQSYhc02yHtjyHvflnyPmwTUWIzf1AjC
UEylttbDFAJY8XjZTxcwlGGhmfYxlYC4UX8LLhND7ZbqcT7pBDy1pV+OuYgh
mwPybv4sAsh+Pln1ERjywknvCrMIGGxv7FOLxFC0zQpM5BBgv8slxjsKQ+WM
RRPmnwQIxpf75qMxxK2fzyst+O9f3f3QKgZDE7azGjOPCYjIYLPjYzEk38j/
dWcJAb32OpYNcRjSPTIhF15KQF3rJE3pKob+BV4QpQY=
               "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
         "HighlightElements" -> <|
           "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
          "LayoutOptions" -> <|
           "PlotRange" -> {All, All}, "Frame" -> {{True, True}, {True, True}},
             "AxesOrigin" -> {0.535599, 0.}, 
            "ImageSize" -> {450, 450/GoldenRatio}, "Axes" -> {True, True}, 
            "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
            "DefaultStyle" -> {
              Directive[
               Opacity[1.], 
               AbsoluteThickness[2], 
               RGBColor[1, 0, 0]]}, 
            "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
                Identity[
                 Part[#, 1]], 
                Identity[
                 Part[#, 2]]}& ), 
              "ScalingFunctions" -> {{Identity, Identity}, {
                Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
            False|>, 
          "Meta" -> <|
           "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
            Plot, "GroupHighlight" -> False|>|>]]& )[<|
        "HighlightElements" -> <|
          "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
         "LayoutOptions" -> <|
          "PlotRange" -> {All, All}, "Frame" -> {{True, True}, {True, True}}, 
           "AxesOrigin" -> {0.535599, 0.}, 
           "ImageSize" -> {450, 450/GoldenRatio}, "Axes" -> {True, True}, 
           "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
           "DefaultStyle" -> {
             Directive[
              Opacity[1.], 
              AbsoluteThickness[2], 
              RGBColor[1, 0, 0]]}, 
           "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
               Identity[
                Part[#, 1]], 
               Identity[
                Part[#, 2]]}& ), 
             "ScalingFunctions" -> {{Identity, Identity}, {
               Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
           False|>, 
         "Meta" -> <|
          "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
           Plot, "GroupHighlight" -> False|>|>]]}, 
     Annotation[{{{{}, {}, 
         Annotation[{
           Directive[
            Opacity[1.], 
            AbsoluteThickness[2], 
            RGBColor[1, 0, 0]], 
           Line[CompressedData["
1:eJwVyms0lHkcwPFxTcY8YposSSlyL10d1vYzkwrluKQiliiiIazIonIp25Hd
qFaasLQIsdmSmOT5xxAZlxixRK6FGZcxg3lGtLsvvufz5qvrF+rqL0sikY7/
1/8WW7a2zb0mwYPp9XeUsVVIjPTzVDGlAyM9eLRXbhVekAU87UJnqGdLOVXE
CrR9KFfTP3sGzF7X93uOr4CnNdW8mB4GXQFpySdrVkA31Bb45vEwYnH5TkfQ
ClxXGjicapgGcfKZWtc4X2H/ieJ3Xnq5cO7BhOMPscvAz9xZN9peDvd5qdV7
qiQQUsTUdCKqQJAvJhsaLwKDfu7bYBwCZ0zVrq1MBF9rRrjjXRxgDmBzN2SE
4NScfv/tUBPsF2jVhVGnwWVs3eto21agiq38Gdwv4LS7g9fd3AFRGs7rvz0f
gTdW5c1e3E6o1v1ZW33DR0hxkDCPSnmgId2kvNWiE3If9aYayPVAitjuVH5C
HXia0dM5Mv9ADqvyhu3VXyAEVzvYbNIPXZfGAg3cEc59EBPxynwAksidyWWb
OvDE2KMuNN9PINg+JfSx6cVnjriuzawfgiJh7aHzFZ9wxqKDkTZnGKQf1Oig
PYrTi5Y2u/WNQI/xvOvfEZ/xgKtz3bKDo8CgSW7vuzSJW7hn+/kvjUHRgjqL
8kSAex7FfIvIn0FBToG3u28WL/Br0fGjfIHkbbhKZZgQf3jF+nm73gScKXQp
GdIR4S9rCMUKo0nwuR0feoktxvVpsdxooylQbHKKCzu1iEN4eaDwAB9KP6lM
S3Ul+DXhLs4QXQBXiu+2MHsInBl5fjHp9DREedxVpr9axovVfVlrLs5AmFeK
h8YfKzjGK1yRCZ2F4OKugu+CvuFpxzo29jLmYDxC8Lj1KQmZ0iMypzhzkM3N
UXXMkkHhDIljiK0QynIDjxndkEWph3pmmtuE4EhkT0oT5BD7tNfssNM8JA6P
HpAGy6Pa8O/7u/rngZm+5q/kIAXUzULbE7xFcC9PMVLNVRH93mHwJGdQBDcl
INu0aw0yUZrUyggSw9kGqt4hHSXEc3GesuOLIYBotOwVKaHj2WoF3ZcXgPbe
Wkf0fi2KXajI7JRZhO4u54GFXGVU6bPKT0lcBAUydV/dSTJ625JnvAlbAipj
UiyiqCC+Pb/pQtoSJK/lU0NKVFA1b0Ou4ToJqB7uGePupSAv3yw/xJLAQckZ
3q0qCupR1X/akCWBWyI7hgubglxry5bf5UjAqnvbb7QaCrLbiN/rfiQBTS/n
WhZOQXu6hxunSiTQ19QTdb+RgpTtDUxoryTwTNF+2YNHQS/Nn4mC+iWgF7H8
hTRLQeqkputUbQL8P36l1W/B0I4EjtRNh4DzlUZ7grZiyEH2TVjGFgLuvr/W
QtHDUJI820tTnwBJHofpaoAhsVLp3s07CHjx8sqPzWYY+qCWNmZsQ8BBpyNZ
IVYYYm1zt2WcI6Ai2A5SXTFUme/GTgogQKe1upfkhqFOfRfzhkACpMEegxEn
MEQ2dNC2CyFAI8fO9IQ7huJMrcWOUQSYhc02yHtjyHvflnyPmwTUWIzf1AjC
UEylttbDFAJY8XjZTxcwlGGhmfYxlYC4UX8LLhND7ZbqcT7pBDy1pV+OuYgh
mwPybv4sAsh+Pln1ERjywknvCrMIGGxv7FOLxFC0zQpM5BBgv8slxjsKQ+WM
RRPmnwQIxpf75qMxxK2fzyst+O9f3f3QKgZDE7azGjOPCYjIYLPjYzEk38j/
dWcJAb32OpYNcRjSPTIhF15KQF3rJE3pKob+BV4QpQY=
            "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
      "HighlightElements" -> <|
        "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
       "LayoutOptions" -> <|
        "PlotRange" -> {All, All}, "Frame" -> {{True, True}, {True, True}}, 
         "AxesOrigin" -> {0.535599, 0.}, 
         "ImageSize" -> {450, 450/GoldenRatio}, "Axes" -> {True, True}, 
         "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
         "DefaultStyle" -> {
           Directive[
            Opacity[1.], 
            AbsoluteThickness[2], 
            RGBColor[1, 0, 0]]}, 
         "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
             Identity[
              Part[#, 1]], 
             Identity[
              Part[#, 2]]}& ), 
           "ScalingFunctions" -> {{Identity, Identity}, {
             Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>, 
       "Meta" -> <|
        "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
         Plot, "GroupHighlight" -> False|>|>, "DynamicHighlight"]], {
    DisplayFunction -> Identity, DisplayFunction -> Identity, 
     Ticks -> {Automatic, Automatic}, AxesOrigin -> {0.535599, 0.}, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     GridLines -> {None, None}, DisplayFunction -> Identity, 
     PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.05], 
        Scaled[0.05]}}, PlotRangeClipping -> True, ImagePadding -> All, 
     DisplayFunction -> Identity, AspectRatio -> 
     NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
     AxesLabel -> {None, None}, AxesOrigin -> {0.535599, 0.}, DisplayFunction :> 
     Identity, Epilog -> {PointSize -> Medium, {
        PointBox[{0.0000319, 1.8789}], 
        PointBox[{0.0000638, 1.8787}], 
        PointBox[{0.0000957, 1.8786}], 
        PointBox[{0.00012756, 1.8784}], 
        PointBox[{0.00015946, 1.8782}], 
        PointBox[{0.00019137, 1.8781}], 
        PointBox[{0.00022328, 1.8779}], 
        PointBox[{0.0002552, 1.8778}], 
        PointBox[{0.00028711, 1.8776}], 
        PointBox[{0.00031904, 1.8774}], 
        PointBox[{0.00063851, 1.8758}], 
        PointBox[{0.00095842, 1.8741}], 
        PointBox[{0.0012788, 1.8725}], 
        PointBox[{0.0015996, 1.8708}], 
        PointBox[{0.0019208, 1.8692}], 
        PointBox[{0.0022425, 1.8675}], 
        PointBox[{0.0025646, 1.8659}], 
        PointBox[{0.0028872, 1.8642}], 
        PointBox[{0.0032102, 1.8626}], 
        PointBox[{0.0064655, 1.8458}], 
        PointBox[{0.0097676, 1.8289}], 
        PointBox[{0.013118, 1.8117}], 
        PointBox[{0.016519, 1.7943}], 
        PointBox[{0.019972, 1.7766}], 
        PointBox[{0.023479, 1.7587}], 
        PointBox[{0.027044, 1.7405}], 
        PointBox[{0.030667, 1.7221}], 
        PointBox[{0.034351, 1.7033}], 
        PointBox[{0.0753, 1.4961}], 
        PointBox[{0.12749, 1.236}], 
        PointBox[{0.20492, 0.85952}], 
        PointBox[{0.71774, -1.085}], 
        PointBox[{0.8327, -1.4484}], 
        PointBox[{0.87947, -1.6051}], 
        PointBox[{0.91145, -1.7151}], 
        PointBox[{0.93632, -1.8019}], 
        PointBox[{0.9569, -1.8747}], 
        PointBox[{1.0764, -2.3069}], 
        PointBox[{1.1436, -2.5519}], 
        PointBox[{1.1924, -2.7275}], 
        PointBox[{1.2313, -2.865}], 
        PointBox[{1.2641, -2.9777}], 
        PointBox[{1.2925, -3.0729}], 
        PointBox[{1.3177, -3.1549}], 
        PointBox[{1.3405, -3.2266}], 
        PointBox[{1.3612, -3.2899}], 
        PointBox[{1.4449, -3.5208}], 
        PointBox[{1.5084, -3.6632}], 
        PointBox[{1.5603, -3.7532}], 
        PointBox[{1.6046, -3.8079}]}}, Frame -> {{True, True}, {True, True}}, 
     FrameLabel -> {{
        FormBox[
         TagBox[
         "\"\\!\\(\\*StyleBox[\\\"U\\\",FontSlant->\\\"Italic\\\"]\\) \
(kJ/mole)\"", HoldForm], TraditionalForm], None}, {
        FormBox[
         TagBox[
         "\"\[Rho] (g/\\!\\(\\*SuperscriptBox[\\(cm\\), \\(3\\)]\\))\"", 
          HoldForm], TraditionalForm], 
        FormBox[
         TagBox["\"ISOTHERM 150.7 K\"", HoldForm], TraditionalForm]}}, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     GridLines -> {None, None}, GridLinesStyle -> Directive[
       GrayLevel[0.5, 0.4]], ImageSize -> 450, 
     Method -> {
      "DefaultBoundaryStyle" -> Automatic, 
       "DefaultGraphicsInteraction" -> {
        "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
         "Effects" -> {
          "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
           "Droplines" -> {
            "freeformCursorMode" -> True, 
             "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
       "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> None,
        "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
           (Identity[#]& )[
            Part[#, 1]], 
           (Identity[#]& )[
            Part[#, 2]]}& ), "CopiedValueFunction" -> ({
           (Identity[#]& )[
            Part[#, 1]], 
           (Identity[#]& )[
            Part[#, 2]]}& )}}, PlotRange -> {All, All}, PlotRangeClipping -> 
     True, PlotRangePadding -> {{Automatic, Automatic}, {
       Automatic, Automatic}}, Ticks -> {Automatic, Automatic}}], 
   FormBox[
    TemplateBox[{"\[ThinSpace]", "\" \"", 
      FormBox[
       TemplateBox[{"\"NIST database\""}, "PointLegend", 
        DisplayFunction -> (FormBox[
          StyleBox[
           StyleBox[
            PaneBox[
             TagBox[
              GridBox[{{
                 TagBox[
                  GridBox[{{
                    GraphicsBox[{{}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    GrayLevel[0], 
                    AbsolutePointSize[6]], {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    GrayLevel[0], 
                    AbsolutePointSize[6]], 
                    PointBox[
                    NCache[{
                    Scaled[{
                    Rational[1, 2], 
                    Rational[1, 2]}]}, {
                    Scaled[{0.5, 0.5}]}]]}}}, AspectRatio -> Full, 
                    ImageSize -> {10, 12.5}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.18000000000000002`] -> 
                    Baseline)], #}}, 
                   GridBoxAlignment -> {
                    "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                   AutoDelete -> False, 
                   GridBoxDividers -> {
                    "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                   GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                   GridBoxSpacings -> {
                    "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
               GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}},
                AutoDelete -> False, 
               GridBoxItemSize -> {
                "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
               GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
              "Grid"], Alignment -> Left, AppearanceElements -> None, 
             ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
             "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
           FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
           False], TraditionalForm]& ), 
        InterpretationFunction :> (RowBox[{"PointLegend", "[", 
           RowBox[{
             RowBox[{"{", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   
                   TemplateBox[<|"color" -> GrayLevel[0]|>, 
                    "GrayLevelColorSwatchTemplate"], ",", 
                   RowBox[{"AbsolutePointSize", "[", "6", "]"}]}], "]"}], 
               "}"}], ",", 
             RowBox[{"{", #, "}"}]}], "]"}]& ), Editable -> True], 
       TraditionalForm], 
      FormBox[
       TemplateBox[{
        "\"UtotalAdimNv[\\!\\(\\*StyleBox[\\\"T\\\",FontSlant->\\\"Italic\\\"]\
\\),\[Rho]]\""}, "LineLegend", DisplayFunction -> (FormBox[
          StyleBox[
           StyleBox[
            PaneBox[
             TagBox[
              GridBox[{{
                 TagBox[
                  GridBox[{{
                    GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[1, 0, 0]], {
                    LineBox[{{0, 12.5}, {20, 12.5}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[1, 0, 0]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 12.5}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.18000000000000002`] -> 
                    Baseline)], #}}, 
                   GridBoxAlignment -> {
                    "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                   AutoDelete -> False, 
                   GridBoxDividers -> {
                    "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                   GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                   GridBoxSpacings -> {
                    "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
               GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}},
                AutoDelete -> False, 
               GridBoxItemSize -> {
                "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
               GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
              "Grid"], Alignment -> Left, AppearanceElements -> None, 
             ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
             "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
           FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
           False], TraditionalForm]& ), 
        InterpretationFunction :> (RowBox[{"LineLegend", "[", 
           RowBox[{
             RowBox[{"{", 
               
               TemplateBox[<|"color" -> RGBColor[1, 0, 0]|>, 
                "RGBColorSwatchTemplate"], "}"}], ",", 
             RowBox[{"{", #, "}"}]}], "]"}]& ), Editable -> True], 
       TraditionalForm]}, "RowWithSeparators"], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"]}, {
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "Below"}], "]"}]}], "]"}]& )]], "Output",
 CellLabel->"Out[3]=",
 CellID->531384185,ExpressionUUID->"6d5b4d02-5a42-4be1-8010-5a4763175223"]
}, Open  ]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "2"}, 
  Closed]]]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "PrimaryExamplesSection"}, 
  Closed]]]],

Cell[BoxData[GridBox[{
   {
    DynamicBox[FEPrivate`ImportImage[
      FrontEnd`FileName[{"Documentation", "FooterIcons"}, 
       "RelatedFunction.png"]],
     ImageSizeCache->{50., {27., 33.}}], GridBox[{
      {
       StyleBox[
        RowBox[{"See", " ", "Also"}], "SeeAlsoSection"]},
      {Cell[TextData[{
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["RhoArgonNv"]], "paclet:NewEoSArgon/ref/RhoArgonNv", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "c48eceeb-e253-478a-b53b-a46989faa1af"],
        "\[NonBreakingSpace]",
        StyleBox[
        "\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
         "InlineSeparator"],
        " ",
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["FtotalAdimNv"]], "paclet:NewEoSArgon/ref/FtotalAdimNv", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "6f88077d-10f1-46d3-b5a4-a84ed4b69230"],
        "\[NonBreakingSpace]",
        StyleBox[
        "\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
         "InlineSeparator"],
        " ",
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["HtotalAdimNv"]], "paclet:NewEoSArgon/ref/HtotalAdimNv", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "afdcd72e-f364-47b5-9f53-245b7d6f5310"]
       }], "SeeAlso",ExpressionUUID->"d8903d7b-7acd-4c23-b208-18a3246669ba"]}
     }]}
  }]], "SeeAlsoSection",ExpressionUUID->"fae26a00-0e12-4151-88d8-\
c727913441d9"],

Cell[BoxData[GridBox[{
   {
    DynamicBox[FEPrivate`ImportImage[
      FrontEnd`FileName[{"Documentation", "FooterIcons"}, "RelatedGuide.png"]],
     ImageSizeCache->{50., {27., 33.}}], GridBox[{
      {
       StyleBox[
        RowBox[{"Related", " ", "Guides"}], "MoreAboutSection"]},
      {
       RowBox[{"\[FilledVerySmallSquare]", Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["NewEoSArgon Package"]], 
           "paclet:NewEoSArgon/guide/NewEoSArgon"},
          "RefLinkPlain",
          BaseStyle->{"MoreAbout"}]], "MoreAbout",ExpressionUUID->
         "e7f34690-586c-4ee4-b5f3-bfaffef49317"]}]}
     }]}
  }]], "MoreAboutSection",ExpressionUUID->"ebe148f5-3ff5-4995-95c8-\
a2794a82c485"],

Cell[BoxData[GridBox[{
   {
    TemplateBox[{29},
     "Spacer1"], GridBox[{
      {
       RowBox[{
        TemplateBox[{17},
         "Spacer1"], 
        StyleBox[
         RowBox[{"Related", " ", "Links"}], "RelatedLinksSection"]}]},
      {Cell[BoxData[Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData[
             RowBox[{
               RowBox[{"Units", " ", "&"}], " ", "Quantities"}]]], 
           "paclet:guide/Units"},
          "RefLinkPlain",
          BaseStyle->{"RelatedLinks"}]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "8238c600-e253-48db-8c77-7e65e9e145dc"]], "RelatedLinks",
        ExpressionUUID->"481ea6ba-e9b2-4184-8ba7-07d59caec4d2"]},
      {Cell[BoxData[Cell[BoxData[Cell[BoxData[
          RowBox[{
           TemplateBox[{16},
            "Spacer1"], "\[FilledVerySmallSquare]", 
           TemplateBox[{
             Cell[
              TextData[
               Cell[
                TextData[{
                  Cell[
                   BoxData[
                    TemplateBox[{2}, "Spacer1"]]], "ThermodynamicData"}]]]], 
             "paclet:ref/ThermodynamicData"},
            "RefLink",
            BaseStyle->{"RelatedLinks"}]}]],ExpressionUUID->
          "33fa889b-c076-445b-9f68-c99e69ae2397"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "3365d732-8f0b-49eb-904d-9814952a0482"]], "RelatedLinks",
        ExpressionUUID->"09ba09d1-4eb8-4b7a-b866-0cd77c665f6d"]}
     }]}
  }]], "RelatedLinksSection",ExpressionUUID->"d0e3c4df-4bb8-4998-b2a5-\
9af59957984c"],

Cell[" ", "FooterCell",ExpressionUUID->"2c76b81c-040d-4b12-8250-171c7ed9b53b"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{900, 835.8},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"UtotalAdimNv",
TaggingRules->{
 "ModificationHighlight" -> False, "ColorType" -> "", "LinkTrails" -> "", 
  "HasOptions" -> True, "ExampleCounter" -> 1, 
  "Openers" -> {
   "PrimaryExamplesSection" -> Open, 
    "ExampleSection" -> {"0" -> Open, "2" -> Closed}, "NotesSection" -> 
    Closed}, "NewStyles" -> True, "CitationPopupData" -> $Failed, 
  "ShowCitation" -> False, "RootCaptions" -> "", 
  "Metadata" -> {
   "built" -> "{2023, 11, 30, 13, 56, 16.0122029}", 
    "history" -> {"XX", "", "", ""}, "context" -> "NewEoSArgon`", 
    "keywords" -> {}, "specialkeywords" -> {}, 
    "tutorialcollectionlinks" -> {}, "index" -> True, "label" -> 
    "New Eo S Argon Package Symbol", "language" -> "en", "paclet" -> 
    "NewEoSArgon Package", "status" -> "None", "summary" -> 
    "UtotalAdimNv[T, \\[Rho]] \\[Congruent] U/RT Energie interne \
adimensionnelle en fonction de T (Kelvin) et de \\[Rho] (g/cm^3) \
[Non-dimension internal energy versus T (Kelvin) and \\[Rho] (g/cm^3)]", 
    "synonyms" -> {}, "tabletags" -> {}, "title" -> "UtotalAdimNv", 
    "titlemodifier" -> "", "metadescription" -> "", "windowtitle" -> 
    "UtotalAdimNv", "type" -> "Symbol", "uri" -> 
    "NewEoSArgon/ref/UtotalAdimNv"}},
CellContext->"Global`",
FrontEndVersion->"13.3 pour Microsoft Windows (64-bit) (July 24, 2023)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "13.3 pour Microsoft Windows (64-bit) (July 24, 2023)", 
  StyleDefinitions -> "Default.nb"],
ExpressionUUID->"3d854d86-a63d-4b96-a520-33235b0c11ee"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[10418, 285, 1420, 37, 35, "PrimaryExamplesSection",ExpressionUUID->"84a282e3-749f-4714-9015-b93208a5f0ef",
   CellTags->"PrimaryExamplesSection",
   CellID->161518599]},
 "RasterizedOutput"->{
  Cell[138679, 2738, 32116, 533, 283, "Output",ExpressionUUID->"997d384c-788d-4631-9098-a4cb060e85e9",
   CellTags->"RasterizedOutput",
   CellID->47342067]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 216701, 4327},
 {"RasterizedOutput", 216901, 4331}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[584, 21, 5439, 132, 56, "AnchorBarGrid",ExpressionUUID->"2c0bfde0-2c28-478e-a877-b6b575e63038",
 CellID->1],
Cell[6026, 155, 94, 0, 23, "ContextNameCell",ExpressionUUID->"d65a84e0-33f1-41b1-a9f8-1a2cd9b9813e"],
Cell[CellGroupData[{
Cell[6145, 159, 555, 14, 56, "ObjectNameGrid",ExpressionUUID->"90104a61-c7d7-4843-b71a-11150af37657"],
Cell[6703, 175, 1007, 29, 146, "Usage",ExpressionUUID->"e524aeb2-bdcd-48f8-a7f6-8f2b775a7589"]
}, Open  ]],
Cell[CellGroupData[{
Cell[7747, 209, 1918, 48, 37, "NotesSection",ExpressionUUID->"b40cae98-3ab6-4ff2-9cb8-0e07270e91c8",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->13438702],
Cell[9668, 259, 220, 6, 36, "Notes",ExpressionUUID->"53cc1fd5-3f47-43a1-97b2-c9126259ce1a",
 CellID->1067943069],
Cell[9891, 267, 185, 4, 36, "Notes",ExpressionUUID->"7af6172c-ff60-4f51-9dac-2a5f54a29876",
 CellID->185021568],
Cell[10079, 273, 212, 6, 36, "Notes",ExpressionUUID->"76e090c0-7fa8-49cd-b41d-a26faaa04610",
 CellID->175218415]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "NotesSection"}, Closed]]]],
Cell[CellGroupData[{
Cell[10418, 285, 1420, 37, 35, "PrimaryExamplesSection",ExpressionUUID->"84a282e3-749f-4714-9015-b93208a5f0ef",
 CellTags->"PrimaryExamplesSection",
 CellID->161518599],
Cell[CellGroupData[{
Cell[11863, 326, 1398, 36, 30, "ExampleSection",ExpressionUUID->"e8d55563-d083-4665-94f6-284160824303",
 CellID->594191624],
Cell[13264, 364, 268, 5, 42, "Input",ExpressionUUID->"cdab92c3-7799-4555-ba1c-b0491d03be8b",
 CellID->143015886],
Cell[13535, 371, 219, 6, 38, "ExampleText",ExpressionUUID->"3bf6d715-d6be-40a6-ba2c-25b84d1d17e6",
 CellID->544149791],
Cell[CellGroupData[{
Cell[13779, 381, 1285, 32, 42, "Input",ExpressionUUID->"3a9246e7-f95e-4068-8868-f017865f32e5",
 CellID->5710145],
Cell[15067, 415, 456, 11, 43, "Output",ExpressionUUID->"6362c9e9-acc6-4235-9687-b7dc979ff7d9",
 CellID->135488993]
}, Open  ]],
Cell[CellGroupData[{
Cell[15560, 431, 443, 11, 46, "Input",ExpressionUUID->"f8c5b8bf-debd-46bf-ab82-1ff91a046d58",
 CellID->201965141],
Cell[16006, 444, 337, 8, 43, "Output",ExpressionUUID->"9d949770-33fe-4a91-9ce1-846b15c36b5c",
 CellID->130685192]
}, Open  ]],
Cell[16358, 455, 154, 1, 38, "ExampleText",ExpressionUUID->"eb38d447-973c-4a09-9690-02190c9cee9c",
 CellID->361149294],
Cell[CellGroupData[{
Cell[16537, 460, 689, 16, 42, "Input",ExpressionUUID->"a5cd4836-4d78-4bbc-887f-e7d932c9bf9b",
 CellID->375583457],
Cell[17229, 478, 338, 8, 43, "Output",ExpressionUUID->"33c5787b-060f-4e90-8fed-62ff28a6c65a",
 CellID->579155892]
}, Open  ]],
Cell[17582, 489, 116, 1, 38, "ExampleText",ExpressionUUID->"4c060db4-d48f-4b54-848b-23d1d43fb2a5",
 CellID->721118955],
Cell[CellGroupData[{
Cell[17723, 494, 120953, 2242, 1057, "WolframAlphaShortInput",ExpressionUUID->"c02f04c3-74ef-4d08-99f3-ebd2ccaa2eec",
 CellID->214209891],
Cell[138679, 2738, 32116, 533, 283, "Output",ExpressionUUID->"997d384c-788d-4631-9098-a4cb060e85e9",
 CellTags->"RasterizedOutput",
 CellID->47342067]
}, Open  ]],
Cell[170810, 3274, 147, 1, 70, "ExampleText",ExpressionUUID->"d5724cee-163f-45d1-b558-8828a6e78a86",
 CellID->286706321],
Cell[CellGroupData[{
Cell[170982, 3279, 953, 24, 70, "Input",ExpressionUUID->"99e925d7-7dc6-497c-b085-e0802c723c61",
 CellID->605199954],
Cell[171938, 3305, 12364, 254, 70, "Output",ExpressionUUID->"e8c33912-03f5-4f56-914a-79b14d655930",
 CellID->390212211]
}, Open  ]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"}, Closed]]]],
Cell[CellGroupData[{
Cell[184451, 3567, 1419, 37, 70, "ExampleSection",ExpressionUUID->"54c8d2c9-b487-447e-ab66-f09d5b43da72",
 CellID->258228157],
Cell[185873, 3606, 174, 3, 70, "Input",ExpressionUUID->"58e49f81-881c-4a35-9470-35347f5dcf9f",
 CellID->87419684],
Cell[186050, 3611, 401, 11, 70, "ExampleText",ExpressionUUID->"3dd5e761-b419-41f5-a311-bc066f1ddce5",
 CellID->227520913],
Cell[186454, 3624, 464, 13, 70, "Input",ExpressionUUID->"469daa66-25b5-4402-ac6f-c1fb9677b59c",
 CellID->531122037],
Cell[CellGroupData[{
Cell[186943, 3641, 2470, 68, 70, "Input",ExpressionUUID->"7f23fa86-e59b-42a3-ba94-0bb6b40b9dd4",
 CellID->136921489],
Cell[189416, 3711, 20691, 441, 362, "Output",ExpressionUUID->"6d5b4d02-5a42-4be1-8010-5a4763175223",
 CellID->531384185]
}, Open  ]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "2"}, Closed]]]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "PrimaryExamplesSection"}, Closed]]]],
Cell[210349, 4161, 1902, 50, 70, "SeeAlsoSection",ExpressionUUID->"fae26a00-0e12-4151-88d8-c727913441d9"],
Cell[212254, 4213, 729, 19, 70, "MoreAboutSection",ExpressionUUID->"ebe148f5-3ff5-4995-95c8-a2794a82c485"],
Cell[212986, 4234, 1607, 43, 70, "RelatedLinksSection",ExpressionUUID->"d0e3c4df-4bb8-4998-b2a5-9af59957984c"],
Cell[214596, 4279, 78, 0, 70, "FooterCell",ExpressionUUID->"2c76b81c-040d-4b12-8250-171c7ed9b53b"]
}
]
*)

(* End of internal cache information *)

