(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 13.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     99704,       2139]
NotebookOptionsPosition[     92238,       1990]
NotebookOutlinePosition[     94751,       2052]
CellTagsIndexPosition[     94629,       2046]
WindowTitle->ZtotalNv
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[GridBox[{
   {GridBox[{
      {
       ItemBox[Cell[BoxData[
         RowBox[{
          TemplateBox[{12},
           "Spacer1"], Cell["NEW EO S ARGON PACKAGE SYMBOL", "PacletNameCell",
           TextAlignment->Center,ExpressionUUID->
           "5551910c-835e-4bbc-9f22-99833ab29544"], 
          TemplateBox[{8},
           "Spacer1"]}]],
         TextAlignment->Center,ExpressionUUID->
         "20726ad9-50dc-45f2-98a2-b14c809d0d37"],
        Background->RGBColor[0.490196, 0.576471, 0.690196],
        ItemSize->Full], ""}
     },
     GridBoxAlignment->{"Rows" -> {{Center}}},
     GridBoxItemSize->{"Columns" -> {Full, 
         Scaled[0.02]}, "Rows" -> {{2.5}}}], Cell[TextData[{
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "See Also",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "1380ab55-2c24-4559-90f3-8130b536b9bf"]
         }],ExpressionUUID->"62575784-b2ae-460c-a018-c46b8b0c69cf"],
         StripOnInput->False],{
        "\"zc\"" :> Documentation`HelpLookup["paclet:NewEoSArgon/ref/zc"], 
         "\"PArgonNv\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/PArgonNv"], 
         "\"RhoArgonNv\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/RhoArgonNv"], 
         "\"dZtotalNv\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/dZtotalNv"], 
         "\"dZtotalNvdT\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/dZtotalNvdT"]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"SeeAlso"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "aa45538b-f5ed-4a5c-b83a-e62254aeda77"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "Related Guides",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "2724e73b-091f-4db7-b4fa-985a731c6191"]
         }],ExpressionUUID->"c02a2a30-4eb3-4fa4-ac53-8bdd8392edcb"],
         StripOnInput->False],{
        "\"NewEoSArgon Package\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/guide/NewEoSArgon"]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"MoreAbout"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "3739f457-9063-41f8-ae62-303ce5043fdb"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "URL",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "dc67fb4f-eb03-4af5-be35-2660d6594043"]
         }],ExpressionUUID->"75df71fb-ce92-4c92-975e-8eee9a6098d9"],
         StripOnInput->False],{
        "\"NewEoSArgon/ref/ZtotalNv\"" :> None, 
         "\"Copy Wolfram Documentation Center URL\"" :> 
         Module[{DocumentationSearch`Private`nb$}, 
           DocumentationSearch`Private`nb$ = 
            NotebookPut[
             Notebook[{Cell["NewEoSArgon/ref/ZtotalNv"]}, Visible -> False]]; 
           SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
           FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
           NotebookClose[DocumentationSearch`Private`nb$]; Null], Delimiter, 
         "\"Copy web URL\"" :> 
         Module[{DocumentationSearch`Private`nb$}, 
           DocumentationSearch`Private`nb$ = 
            NotebookPut[
             Notebook[{
               Cell[BoxData[
                 MakeBoxes[
                  Hyperlink[
                   "http://reference.wolfram.com/language/NewEoSArgon/ref/\
ZtotalNv.html"], StandardForm]], "Input", TextClipboardType -> "PlainText"]}, 
               Visible -> False]]; 
           SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
           FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
           NotebookClose[DocumentationSearch`Private`nb$]; Null], 
         "\"Go to web URL\"" :> 
         FrontEndExecute[{
           NotebookLocate[{
             URL[If[TrueQ[DocumentationBuild`Make`Private`wsmlinkQ$36091], 
                 "http://reference.wolfram.com/system-modeler/", 
                 "http://reference.wolfram.com/language/"] <> 
               "NewEoSArgon/ref/ZtotalNv" <> ".html"], None}]}]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"URLMenu"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "a6a48ce0-5241-4e98-8e6f-b12b636e4254"]
    }], "AnchorBar",
     CacheGraphics->False,ExpressionUUID->
     "edf4b964-cdf1-4db6-996a-d77648d2af3f"]}
  }]], "AnchorBarGrid",
 CellID->1,ExpressionUUID->"1bdc8a54-da07-4a36-a071-2f1411996d2c"],

Cell["NewEoSArgon`", "ContextNameCell",ExpressionUUID->"117f1746-cd1a-4b94-9bec-a534042021f3"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     Cell[
     "ZtotalNv", "ObjectName",ExpressionUUID->
      "ea03622b-6654-4805-ba65-6af6276fc734"],
     Cell[BoxData[
      TemplateBox[{8},
       "Spacer1"]],ExpressionUUID->"8597b782-7393-49f6-b540-9f69bf7672b1"],
     Cell[BoxData[
     ""], "ObjectNameTranslation",ExpressionUUID->
      "53746836-cadb-463d-9467-bcc37e8ad46d"]
    }],ExpressionUUID->"0dfb3b09-39c9-468a-a318-444575b7499c"], 
    "\[SpanFromLeft]"}
  }]], "ObjectNameGrid",ExpressionUUID->"70b9d607-5c8d-492b-8523-\
df3bc0a7cd27"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     "ZtotalNv[",
     StyleBox["T",
      FontSlant->"Italic"],
     ", \[Rho]] \[Congruent] ",
     StyleBox["PV",
      FontSlant->"Italic"],
     "/",
     StyleBox["RT",
      FontSlant->"Italic"],
     "\nFacteur de compressibilit\[EAcute] en fonction de ",
     StyleBox["T",
      FontSlant->"Italic"],
     " (Kelvin) et de \[Rho] (g/",
     Cell[BoxData[
      SuperscriptBox["cm", "3"]], "InlineFormula",
      FontFamily->"Source Sans Pro",ExpressionUUID->
      "c1a15175-465a-4198-817b-3f4c6b0b4fd3"],
     ")\n[Compressibility factor versus ",
     StyleBox["T",
      FontSlant->"Italic"],
     " (Kelvin) and \[Rho] (g/",
     Cell[BoxData[
      SuperscriptBox["cm", "3"]], "InlineFormula",
      FontFamily->"Source Sans Pro",ExpressionUUID->
      "93fecbc4-dbe0-408f-828d-4ee78535c6c5"],
     ")]"
    }],ExpressionUUID->"16d63e4f-aba7-401b-9904-cfb9125f5964"]}
  }]], "Usage",ExpressionUUID->"98a3ff35-4e12-40b2-b5d6-14ce180ffd73"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[Cell[TextData[{
   Cell[BoxData[
    DynamicBox[ToBoxes[
      If[
       MatchQ[
        CurrentValue[
         EvaluationNotebook[], {TaggingRules, "Openers", "NotesSection"}, 
         Closed], 
        Alternatives[Open, True]], 
       Style[
        Graphics[{
          Thickness[0.18], 
          RGBColor[0.8509803921568627, 0.396078431372549, 0], 
          Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
         PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
        0.68 Inherited], 
       Rotate[
        Style[
         Graphics[{
           Thickness[0.18], 
           RGBColor[0.8509803921568627, 0.396078431372549, 0], 
           Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
          PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
         0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
     ImageSizeCache->{
      13.600000000000001`, {0.5800000000000001, 13.020000000000001`}}]],
    ExpressionUUID->"a4b1233b-58d4-43de-b4d6-15c994329eef"],
   Cell[BoxData[
    TemplateBox[{1},
     "Spacer1"]],ExpressionUUID->"cf0d17f8-5456-4a65-957e-39ec83be8578"],
   "Details and Options"
  }], "NotesFrameText",ExpressionUUID->"670dbfbf-e527-4aee-9ef7-3806e55c2bed"],
  Appearance->{Automatic, None, "Normal", Automatic},
  BaseStyle->None,
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"], 
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], After, CellContents]}]& ),
  Evaluator->None,
  Method->
   "Preemptive"]],ExpressionUUID->"fbf1a63b-eb98-4b99-9eef-3b1ee721b67b"]], \
"NotesSection",
 WholeCellGroupOpener->True,
 CellGroupingRules->{"SectionGrouping", 50},
 CacheGraphics->False,
 CellID->135262610,ExpressionUUID->"53015c4c-7005-4bd0-a623-e501fb28d89b"],

Cell[TextData[{
 "La fonction est d\[EAcute]finie pour ",
 StyleBox["T",
  FontSlant->"Italic"],
 " > 0 et \[Rho] \[GreaterEqual] 0"
}], "Notes",
 CellID->1067943069,ExpressionUUID->"5e24421f-634b-4d7a-9ab0-db229cf7d996"],

Cell["\<\
******************************************************************************\
*****\
\>", "Notes",
 CellID->185021568,ExpressionUUID->"0e37eba5-e18f-432a-9810-ab6bf000a722"],

Cell[TextData[{
 "The function is defined for ",
 StyleBox["T",
  FontSlant->"Italic"],
 " >0 and \[Rho] \[GreaterEqual] 0."
}], "Notes",
 CellID->175218415,ExpressionUUID->"5f788dbc-2799-4287-be93-30d4ff2ce2f7"]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "NotesSection"}, Closed]]]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {
       TaggingRules, "Openers", "PrimaryExamplesSection"}, Open], 
      Alternatives[True, Open]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{13.600000000000001`, {5., 8.600000000000001}}]],
  ExpressionUUID->"32028804-36f9-472f-b5de-708216680ee8"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"ff19e1ce-e3af-4d34-b0be-a41d2015decd"],
 "Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount",ExpressionUUID->
  "d29551e0-4335-4fff-8f26-1222a2c995e2"]
}], "PrimaryExamplesSection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellTags->"PrimaryExamplesSection",
 CellID->126709650,ExpressionUUID->"b960118a-b692-4364-bf5a-1ccd5547e457"],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"},
        Closed], 
      Alternatives[Open, True]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{13.600000000000001`, {5., 8.600000000000001}}]],
  ExpressionUUID->"bcb65e5a-355a-42de-b368-b3f2e2d1af47"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"97156133-37fb-495e-8444-4668d3252171"],
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "8f981641-ff24-45e0-b1f3-f68d00ca64d2"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellID->41313577,ExpressionUUID->"7d0adc17-f821-4167-b6ff-85b7931a19de"],

Cell[BoxData[{
 RowBox[{"Needs", "[", "\"\<NewEoSArgon`\>\"", "]"}], "\[IndentingNewLine]", 
 RowBox[{"Off", "[", 
  RowBox[{"General", "::", "munfl"}], "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->143015886,ExpressionUUID->"f46eef0c-5ddf-43dc-9215-6e093f8ebbe6"],

Cell[TextData[{
 "Calculated value of ",
 StyleBox["Z",
  FontSlant->"Italic"],
 " for atmospheric pressure and 20\[Degree]C"
}], "ExampleText",
 CellID->544149791,ExpressionUUID->"daeea5c5-9b7b-4153-99dc-0945470f429a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ZtotalNv", "[", 
  RowBox[{"293.15", ",", 
   RowBox[{"RhoArgonNv", "[", 
    RowBox[{"293.15", ",", 
     RowBox[{"QuantityMagnitude", "@", 
      RowBox[{"N", "@", 
       RowBox[{"UnitConvert", "[", 
        RowBox[{
         TemplateBox[{"1"},
          "QuantityUnit",
          DisplayFunction->(TooltipBox[
            StyleBox[
             RowBox[{#, "\[InvisibleSpace]", 
               StyleBox[
                RowBox[{" ", "\"atm\""}], "QuantityUnitTraditionalLabel"]}], 
             ShowStringCharacters -> False], "Unit: atmospheres"]& ),
          InterpretationFunction->(RowBox[{"Quantity", "[", 
             RowBox[{#, ",", "\"Atmospheres\""}], "]"}]& )], ",", 
         "\"\<Bars\>\""}], "]"}]}]}], ",", "\"\<G\>\""}], "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->5710145,ExpressionUUID->"dc8cb18b-2075-4181-b11c-67168ce698d3"],

Cell[BoxData["0.9994101792253464`"], "Output",
 CellLabel->"Out[2]=",
 CellID->488525156,ExpressionUUID->"b44cc92e-50e4-4baf-85e5-4dc32ba87385"]
}, Open  ]],

Cell["Using ThermodynamicData package (i.e. REFPROP from NIST)", "ExampleText",
 CellID->361149294,ExpressionUUID->"d7c8f829-734d-4c14-9e79-fc6e4161c419"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ThermodynamicData", "[", 
  RowBox[{"\"\<Argon\>\"", ",", "\"\<CompressibilityFactor\>\"", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\"\<Pressure\>\"", "\[Rule]", 
      RowBox[{"Quantity", "[", 
       RowBox[{"1", ",", "\"\<Atmospheres\>\""}], "]"}]}], ",", 
     RowBox[{"\"\<Temperature\>\"", "\[Rule]", 
      RowBox[{"Quantity", "[", 
       RowBox[{"293.15", ",", "\"\<Kelvins\>\""}], "]"}]}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->67978501,ExpressionUUID->"d8926024-2f41-4d13-aeb5-bdb7f4438fbb"],

Cell[BoxData["0.9993116158038163`"], "Output",
 CellLabel->"Out[3]=",
 CellID->239767589,ExpressionUUID->"f45d50de-ec60-4b7b-85cc-a612e3dc1988"]
}, Open  ]],

Cell["Compressibility factor on the saturation curve from NIST", "ExampleText",
 CellID->286706321,ExpressionUUID->"dfbb3a0a-e5e9-4de2-836e-b5857d0f5034"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ZtotalNv", "[", 
     RowBox[{
      RowBox[{"TSatNIST", "[", "\[Rho]", "]"}], ",", "\[Rho]"}], "]"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"\[Rho]", ",", "\[Rho]trgaz", ",", "\[Rho]trliq"}], "}"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", "Red", "}"}]}], ",", 
   RowBox[{"AxesOrigin", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\[Rho]c", ",", "0"}], "}"}]}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "\"\<\[Rho] (g/\!\(\*SuperscriptBox[\(cm\), \(3\)]\))\>\"", ",", 
      "\"\<\!\(\*StyleBox[\"Z\",FontSlant->\"Italic\"]\)\>\""}], "}"}]}], ",", 
   RowBox[{"ImageSize", "\[Rule]", "400"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->605199954,ExpressionUUID->"20bc9cd3-555b-4cf8-a223-ae2462b7b876"],

Cell[BoxData[
 GraphicsBox[
  InterpretationBox[{
    TagBox[{{{}, {}, 
       TagBox[
        {RGBColor[1, 0, 0], AbsoluteThickness[2], Opacity[1.], 
         LineBox[CompressedData["
1:eJwVlHk4FGwXxuUllJBS0mLJkkhRKel1S5G1olLSIiRrQqRsYwmzMSRlTbYW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          "]]},
        Annotation[#, "Charting`Private`Tag#1"]& ]}, {}},
     {"WolframDynamicHighlight", <|
      "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>}], 
    DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
      Slot["HighlightElements"], 
      Slot["LayoutOptions"], 
      Slot["Meta"], 
      Charting`HighlightActionFunction["DynamicHighlight", {{{{}, {}, 
          Annotation[{
            Directive[
             Opacity[1.], 
             AbsoluteThickness[2], 
             RGBColor[1, 0, 0]], 
            Line[CompressedData["
1:eJwVlHk4FGwXxuUllJBS0mLJkkhRKel1S5G1olLSIiRrQqRsYwmzMSRlTbYW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             "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
       "HighlightElements" -> <|
         "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
        "LayoutOptions" -> <|
         "PlotRange" -> {{0.0040546000061275735`, 1.4168017335853793`}, {0., 
           0.9740889164841625}}, "Frame" -> {{True, True}, {True, True}}, 
          "AxesOrigin" -> {0.535599, 0.}, 
          "ImageSize" -> {400, 400/GoldenRatio}, "Axes" -> {True, True}, 
          "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
          "DefaultStyle" -> {
            Directive[
             Opacity[1.], 
             AbsoluteThickness[2], 
             RGBColor[1, 0, 0]]}, 
          "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
              Identity[
               Part[#, 1]], 
              Identity[
               Part[#, 2]]}& ), 
            "ScalingFunctions" -> {{Identity, Identity}, {
              Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>,
         "Meta" -> <|
         "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
          Plot, "GroupHighlight" -> False|>|>]]& )[<|
      "HighlightElements" -> <|
        "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
       "LayoutOptions" -> <|
        "PlotRange" -> {{0.0040546000061275735`, 1.4168017335853793`}, {0., 
          0.9740889164841625}}, "Frame" -> {{True, True}, {True, True}}, 
         "AxesOrigin" -> {0.535599, 0.}, 
         "ImageSize" -> {400, 400/GoldenRatio}, "Axes" -> {True, True}, 
         "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
         "DefaultStyle" -> {
           Directive[
            Opacity[1.], 
            AbsoluteThickness[2], 
            RGBColor[1, 0, 0]]}, 
         "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
             Identity[
              Part[#, 1]], 
             Identity[
              Part[#, 2]]}& ), 
           "ScalingFunctions" -> {{Identity, Identity}, {
             Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>, 
       "Meta" -> <|
        "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
         Plot, "GroupHighlight" -> False|>|>],
     ImageSizeCache->{{4.503599627370496*^15, -4.503599627370496*^15}, {
      4.503599627370496*^15, -4.503599627370496*^15}}]},
   Annotation[{{{{}, {}, 
       Annotation[{
         Directive[
          Opacity[1.], 
          AbsoluteThickness[2], 
          RGBColor[1, 0, 0]], 
         Line[CompressedData["
1:eJwVlHk4FGwXxuUllJBS0mLJkkhRKel1S5G1olLSIiRrQqRsYwmzMSRlTbYW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          "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
    "HighlightElements" -> <|
      "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
     "LayoutOptions" -> <|
      "PlotRange" -> {{0.0040546000061275735`, 1.4168017335853793`}, {0., 
        0.9740889164841625}}, "Frame" -> {{True, True}, {True, True}}, 
       "AxesOrigin" -> {0.535599, 0.}, "ImageSize" -> {400, 400/GoldenRatio}, 
       "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
       GoldenRatio^(-1), "DefaultStyle" -> {
         Directive[
          Opacity[1.], 
          AbsoluteThickness[2], 
          RGBColor[1, 0, 0]]}, 
       "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
           Identity[
            Part[#, 1]], 
           Identity[
            Part[#, 2]]}& ), 
         "ScalingFunctions" -> {{Identity, Identity}, {Identity, Identity}}|>,
        "Primitives" -> {}, "GCFlag" -> False|>, 
     "Meta" -> <|
      "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
       Plot, "GroupHighlight" -> False|>|>, "DynamicHighlight"]],
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0.535599, 0.},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{
     FormBox[
      TagBox[
      "\"\\!\\(\\*StyleBox[\\\"Z\\\",FontSlant->\\\"Italic\\\"]\\)\"", 
       HoldForm], TraditionalForm], None}, {
     FormBox[
      TagBox[
      "\"\[Rho] (g/\\!\\(\\*SuperscriptBox[\\(cm\\), \\(3\\)]\\))\"", 
       HoldForm], TraditionalForm], None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  ImageSize->400,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0.0040546000061275735`, 1.4168017335853793`}, {0., 
   0.9740889164841625}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellLabel->"Out[4]=",
 CellID->176894861,ExpressionUUID->"70195fe1-7639-4b14-88dd-e0a60183a670"]
}, Open  ]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"}, 
  Closed]]]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "2"},
        Closed], 
      Alternatives[Open, True]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{
    13.600000000000001`, {0.5800000000000001, 13.020000000000001`}}]],
  ExpressionUUID->"92c1082b-96c9-4f3e-aae7-a2babe4045b0"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"59fa5ac3-604e-4683-8590-ae33dc5085cd"],
 "Applications",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "8eed3427-347f-4109-bc23-44db7d1bcd49"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellID->258228157,ExpressionUUID->"48e306df-7e6e-45d2-8f84-d64e8b8f0b92"],

Cell[BoxData[{
 RowBox[{"Needs", "[", "\"\<NewEoSArgon`\>\"", "]"}], "\[IndentingNewLine]", 
 RowBox[{"Off", "[", 
  RowBox[{"General", "::", "munfl"}], "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->87419684,ExpressionUUID->"2c4a871d-a11b-4c28-b554-3887e056c910"],

Cell[TextData[{
 "Comparison with ",
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["NIST data"]], "http://webbook.nist.gov/chemistry/fluid/"},
   "WebLink",
   BaseStyle->{"ExampleText"}]],ExpressionUUID->
  "f4533469-5f99-4c42-a9d0-e1a8d9065f47"],
 " on an isotherm close to the critical isotherm"
}], "ExampleText",
 CellID->227520913,ExpressionUUID->"76fef120-b1ac-4736-9122-4404f50faba0"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"datafile", "=", 
   RowBox[{"FileNameJoin", "[", 
    RowBox[{"{", 
     RowBox[{
     "\"\<NewEoSArgon\>\"", ",", "\"\<DataFiles\>\"", ",", 
      "\"\<DataCritNIST.dat\>\""}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dataNIST", "=", 
   RowBox[{"Import", "[", "datafile", "]"}]}], ";"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->531122037,ExpressionUUID->"d469060d-2860-46b4-876c-2759dfe531f5"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ArT150p7Z", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"dataNIST", "[", 
        RowBox[{"[", 
         RowBox[{"i", ",", "3"}], "]"}], "]"}], ",", 
       RowBox[{
        RowBox[{"dataNIST", "[", 
         RowBox[{"[", 
          RowBox[{"i", ",", "2"}], "]"}], "]"}], "*", 
        RowBox[{"dataNIST", "[", 
         RowBox[{"[", 
          RowBox[{"i", ",", "4"}], "]"}], "]"}], "*", 
        RowBox[{"M", "/", 
         RowBox[{"(", 
          RowBox[{"10", "*", "RR", "*", 
           RowBox[{"dataNIST", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "1"}], "]"}], "]"}]}], ")"}]}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "2", ",", "51"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Legended", "[", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"ZtotalNv", "[", 
       RowBox[{"150.7", ",", "x"}], "]"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0.0000319`", ",", "1.6046`"}], "}"}], ",", 
     RowBox[{"AxesOrigin", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\[Rho]c", ",", "1"}], "}"}]}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
     RowBox[{"Frame", "\[Rule]", "True"}], ",", 
     RowBox[{"FrameLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
       "\"\<\[Rho] (g/\!\(\*SuperscriptBox[\(cm\), \(3\)]\))\>\"", ",", 
        "\"\<\!\(\*StyleBox[\"Z\",FontSlant->\"Italic\"]\)\>\"", ",", 
        "\"\<ISOTHERM 150.7 K\>\""}], "}"}]}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", "Red", "}"}]}], ",", 
     RowBox[{"Epilog", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"PointSize", "\[Rule]", "Medium"}], ",", 
        RowBox[{"Map", "[", 
         RowBox[{"Point", ",", "ArT150p7Z"}], "]"}]}], "}"}]}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "450"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Placed", "[", 
      RowBox[{
       RowBox[{"PointLegend", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"Directive", "[", 
           RowBox[{"Black", ",", 
            RowBox[{"AbsolutePointSize", "[", "6", "]"}]}], "]"}], "}"}], ",", 
         RowBox[{"{", "\"\<NIST database\>\"", "}"}]}], "]"}], ",", "Below"}],
       "]"}], ",", 
     RowBox[{"Placed", "[", 
      RowBox[{
       RowBox[{"LineLegend", "[", 
        RowBox[{
         RowBox[{"{", "Red", "}"}], ",", 
         RowBox[{
         "{", "\"\<ZtotalNv[\!\(\*StyleBox[\"T\",FontSlant->\"Italic\"]\),\
\[Rho]]\>\"", "}"}]}], "]"}], ",", "Below"}], "]"}]}], "}"}]}], 
  "]"}]}], "Input",
 CellLabel->"In[3]:=",
 CellID->136921489,ExpressionUUID->"273bb52a-cc61-4eb6-ad73-1c9454dd49c8"],

Cell[BoxData[
 GraphicsBox[
  TagBox[RasterBox[CompressedData["
1:eJzt3U1oHFue533de1WFLqWqzlutKQztmnLTmil3t5vRVOUMHtAw+cyIKT9g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    "], {{0, 345.}, {450., 0}}, {0, 255},
    ColorFunction->RGBColor,
    ImageResolution->{144., 144.},
    SmoothingQuality->"High"],
   BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
   Selectable->False],
  DefaultBaseStyle->"ImageGraphics",
  ImageSize->Automatic,
  ImageSizeRaw->{450., 345.},
  PlotRange->{{0, 450.}, {0, 345.}}]], "Output",
 CellTags->"RasterizedOutput",
 CellLabel->"Out[3]=",
 CellID->12208912,ExpressionUUID->"dd0f010f-b47c-453b-970e-1686b4870f64"]
}, Open  ]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "2"}, 
  Closed]]]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "3"},
        Closed], 
      Alternatives[Open, True]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{
    13.600000000000001`, {0.5800000000000001, 13.020000000000001`}}]],
  ExpressionUUID->"3dafa5b3-db04-4fea-8e35-6d6ef730d547"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"28f788a3-a19c-4744-b5bc-5064fdf319f7"],
 "Possible Issues",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "8cee2210-df86-4eef-a305-795fb3adb4d3"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellID->1305812373,ExpressionUUID->"c980011f-7ad3-4a1f-9569-a7724cb0f16c"],

Cell[BoxData[{
 RowBox[{"Needs", "[", "\"\<NewEoSArgon`\>\"", "]"}], "\[IndentingNewLine]", 
 RowBox[{"Off", "[", 
  RowBox[{"General", "::", "munfl"}], "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->768708256,ExpressionUUID->"63ff29f5-a594-4102-90e9-cc0985b5a77c"],

Cell["Corresponding properties of the ideal curve Z = 1", "ExampleText",
 CellID->109328850,ExpressionUUID->"cfa50dfa-d584-41d5-9316-1461a73c848f"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", 
   RowBox[{"\[Rho]", ",", "P"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Off", "[", 
  RowBox[{"FindRoot", "::", "lstol"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"DataPT\[Rho]", "=", 
   RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Rho]GazParfait", "=", "1.4"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"For", "[", 
    RowBox[{
     RowBox[{"i", "=", "1"}], ",", 
     RowBox[{"i", "\[LessEqual]", "28"}], ",", 
     RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"T", "=", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "+", 
          FractionBox["i", "8"]}], ")"}], 
        FractionBox["tc", "1.8"]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"sol", "=", 
       RowBox[{"Module", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"s", "=", "0"}], ",", 
           RowBox[{"e", "=", "0"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"First", "@", 
            RowBox[{"FindRoot", "[", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"ZtotalNv", "[", 
                 RowBox[{"T", ",", "\[Rho]"}], "]"}], "-", "1"}], "\[Equal]", 
               "0"}], ",", 
              RowBox[{"{", 
               RowBox[{"\[Rho]", ",", "\[Rho]GazParfait"}], "}"}], ",", 
              RowBox[{"StepMonitor", "\[RuleDelayed]", 
               RowBox[{"s", "++"}]}], ",", 
              RowBox[{"EvaluationMonitor", "\[RuleDelayed]", 
               RowBox[{"e", "++"}]}]}], "]"}]}], ",", 
           RowBox[{"\"\<Steps\>\"", "\[Rule]", "s"}], ",", 
           RowBox[{"\"\<Evaluations\>\"", "\[Rule]", "e"}]}], "}"}]}], 
        "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"\[Rho]GazParfait", "=", 
       RowBox[{"\[Rho]", "/.", 
        RowBox[{"First", "@", "sol"}]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"P", "=", 
       RowBox[{"\[Rho]GazParfait", "*", 
        FractionBox["RR", "M"], "*", "T"}]}], ";", 
      RowBox[{"(*", "MPa", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"\[Rho]GazParfait", ">", "0"}], "&&", 
         RowBox[{"\[Rho]GazParfait", "<", "2"}]}], ",", 
        RowBox[{"AppendTo", "[", 
         RowBox[{"DataPT\[Rho]", ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"10", "*", 
             RowBox[{"P", "/", "pc"}]}], ",", 
            RowBox[{"T", "/", "tc"}], ",", 
            RowBox[{"\[Rho]GazParfait", "/", "\[Rho]c"}]}], "}"}]}], "]"}]}], 
       "]"}], ";"}]}], "\[IndentingNewLine]", "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"For", "[", 
    RowBox[{
     RowBox[{"i", "=", "1"}], ",", 
     RowBox[{"i", "\[LessEqual]", "5"}], ",", 
     RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"T", "=", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"2.45", "+", 
          RowBox[{"0.05", "*", "i"}]}], ")"}], "tc"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"sol", "=", 
       RowBox[{"Module", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"s", "=", "0"}], ",", 
           RowBox[{"e", "=", "0"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"First", "@", 
            RowBox[{"FindRoot", "[", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"ZtotalNv", "[", 
                 RowBox[{"T", ",", "\[Rho]"}], "]"}], "-", "1"}], "\[Equal]", 
               "0"}], ",", 
              RowBox[{"{", 
               RowBox[{"\[Rho]", ",", "\[Rho]GazParfait"}], "}"}], ",", 
              RowBox[{"StepMonitor", "\[RuleDelayed]", 
               RowBox[{"s", "++"}]}], ",", 
              RowBox[{"EvaluationMonitor", "\[RuleDelayed]", 
               RowBox[{"e", "++"}]}]}], "]"}]}], ",", 
           RowBox[{"\"\<Steps\>\"", "\[Rule]", "s"}], ",", 
           RowBox[{"\"\<Evaluations\>\"", "\[Rule]", "e"}]}], "}"}]}], 
        "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"\[Rho]GazParfait", "=", 
       RowBox[{"\[Rho]", "/.", 
        RowBox[{"First", "@", "sol"}]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"P", "=", 
       RowBox[{"\[Rho]GazParfait", "*", 
        FractionBox["RR", "M"], "*", "T"}]}], ";", 
      RowBox[{"(*", "MPa", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"\[Rho]GazParfait", ">", "0"}], "&&", 
         RowBox[{"\[Rho]GazParfait", "<", "2"}]}], ",", 
        RowBox[{"AppendTo", "[", 
         RowBox[{"DataPT\[Rho]", ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"10", "*", 
             RowBox[{"P", "/", "pc"}]}], ",", 
            RowBox[{"T", "/", "tc"}], ",", 
            RowBox[{"\[Rho]GazParfait", "/", "\[Rho]c"}]}], "}"}]}], "]"}]}], 
       "]"}], ";"}]}], "\[IndentingNewLine]", "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
  "Print", "[", 
   "\"\<In the following table, \!\(\*SubscriptBox[StyleBox[\"P\",FontSlant->\
\"Italic\"], \"c\"]\), \!\(\*StyleBox[SubscriptBox[\"T\", \
\"c\"],FontSlant->\"Italic\"]\) and \
\!\(\*SubscriptBox[StyleBox[\"\[Rho]\",FontSlant->\"Italic\"], \"c\"]\) are \
the values given by NIST\>\"", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"TableForm", "[", 
  RowBox[{"DataPT\[Rho]", ",", 
   RowBox[{"TableHeadings", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"None", ",", 
      RowBox[{"{", 
       RowBox[{
       "\"\<P/\!\(\*SubscriptBox[\(P\), \(c\)]\)\>\"", ",", 
        "\"\<T/\!\(\*SubscriptBox[\(T\), \(c\)]\)\>\"", ",", 
        "\"\<\[Rho]/\!\(\*SubscriptBox[\(\[Rho]\), \(c\)]\)\>\""}], "}"}]}], 
     "}"}]}]}], "]"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->746773888,ExpressionUUID->"bd6bbf65-f28c-4b42-be59-d0179a1e3a4f"],

Cell[BoxData["\<\"In the following table, \
\\!\\(\\*SubscriptBox[StyleBox[\\\"P\\\",FontSlant->\\\"Italic\\\"], \
\\\"c\\\"]\\), \\!\\(\\*StyleBox[SubscriptBox[\\\"T\\\", \
\\\"c\\\"],FontSlant->\\\"Italic\\\"]\\) and \
\\!\\(\\*SubscriptBox[StyleBox[\\\"\[Rho]\\\",FontSlant->\\\"Italic\\\"], \
\\\"c\\\"]\\) are the values given by NIST\"\>"], "Print",
 CellLabel->"Lors de l\[CloseCurlyQuote]\[EAcute]valuation de In[35]:=",
 CellID->592507982,ExpressionUUID->"f660b9d4-b578-4e1d-a421-e9ac23060719"],

Cell[BoxData[
 TagBox[
  TagBox[GridBox[{
     {
      TagBox["\<\"P/\\!\\(\\*SubscriptBox[\\(P\\), \\(c\\)]\\)\"\>",
       HoldForm], 
      TagBox["\<\"T/\\!\\(\\*SubscriptBox[\\(T\\), \\(c\\)]\\)\"\>",
       HoldForm], 
      TagBox["\<\"\[Rho]/\\!\\(\\*SubscriptBox[\\(\[Rho]\\), \\(c\\)]\\)\"\>",
       HoldForm]},
     {"5.764080095531424`", "0.625`", "2.6699129157900705`"},
     {"6.193481743641259`", "0.6944444444444445`", "2.5819299808983525`"},
     {"6.585007360462284`", "0.7638888888888888`", "2.4955896643595703`"},
     {"6.937196467047992`", "0.8333333333333334`", "2.409973942906807`"},
     {"7.247969860634172`", "0.9027777777777778`", "2.324248852188228`"},
     {"7.515383749223485`", "0.9722222222222222`", "2.2378590247029044`"},
     {"7.737961108590456`", "1.0416666666666667`", "2.1505269146127826`"},
     {"7.914912922651068`", "1.1111111111111112`", "2.062223622457355`"},
     {"8.046201386790491`", "1.1805555555555556`", "1.9731112627570893`"},
     {"8.132397325931194`", "1.25`", "1.883456882709963`"},
     {"8.174374336024004`", "1.3194444444444444`", "1.7935377399783639`"},
     {"8.172904588497126`", "1.388888888888889`", "1.7035544998358447`"},
     {"8.128360103412053`", "1.4583333333333333`", "1.6135901701036588`"},
     {"8.040610633583121`", "1.5277777777777777`", "1.523617491514922`"},
     {"7.909074685260662`", "1.5972222222222223`", "1.4335321563993473`"},
     {"7.732988709844925`", "1.6666666666666667`", "1.3432156188773157`"},
     {"7.511761268386088`", "1.736111111111111`", "1.2525969999417161`"},
     {"7.2453215687557275`", "1.8055555555555556`", "1.161699804477503`"},
     {"6.934328195003415`", "1.8750000000000002`", "1.070656670467377`"},
     {"6.580134006226795`", "1.9444444444444444`", "0.9796846548993983`"},
     {"6.184500056208201`", "2.013888888888889`", "0.8890295543589736`"},
     {"5.749159868390089`", "2.0833333333333335`", "0.7989005669502995`"},
     {"5.275365318791728`", "2.1527777777777777`", "0.7094151269892539`"},
     {"4.763492423715587`", "2.2222222222222223`", "0.6205618872615859`"},
     {"4.21274074100014`", "2.291666666666667`", "0.5321822576838329`"},
     {"3.6209701909503855`", "2.361111111111111`", "0.44397205106009396`"},
     {"2.98473696332664`", "2.4305555555555554`", "0.35550655948526944`"},
     {"2.2996385236635026`", "2.5`", "0.2662972449297448`"},
     {"2.2996385236635026`", "2.5`", "0.2662972449297448`"},
     {"1.773722565572441`", "2.5500000000000003`", "0.20136900188121296`"},
     {"1.2210930141103447`", "2.6000000000000005`", "0.13596355308189406`"},
     {"0.6624486965928533`", "2.6500000000000004`", "0.07236915181706481`"},
     {"0.2201541657262757`", "2.7`", "0.023605339446887565`"}
    },
    GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
    GridBoxDividers->{
     "Columns" -> {{False}}, "Rows" -> {False, True, {False}, False}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[2.0999999999999996`]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}],
   {None, OutputFormsDump`HeadedColumns}],
  Function[BoxForm`e$, 
   TableForm[
   BoxForm`e$, 
    TableHeadings -> {
     None, {"P/\!\(\*SubscriptBox[\(P\), \(c\)]\)", 
       "T/\!\(\*SubscriptBox[\(T\), \(c\)]\)", 
       "\[Rho]/\!\(\*SubscriptBox[\(\[Rho]\), \(c\)]\)"}}]]]], "Output",
 CellLabel->"Out[2]//TableForm=",
 CellID->563970,ExpressionUUID->"59e9d9a8-b3f7-4bbc-8c5d-99e14307bf93"]
}, Open  ]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "3"}, 
  Closed]]]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "PrimaryExamplesSection"}, 
  Closed]]]],

Cell[BoxData[GridBox[{
   {
    DynamicBox[FEPrivate`ImportImage[
      FrontEnd`FileName[{"Documentation", "FooterIcons"}, 
       "RelatedFunction.png"]],
     ImageSizeCache->{50., {27., 33.}}], GridBox[{
      {
       StyleBox[
        RowBox[{"See", " ", "Also"}], "SeeAlsoSection"]},
      {Cell[TextData[{
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["zc"]], "paclet:NewEoSArgon/ref/zc", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "514d182d-b73e-4bcf-84a0-f1c1edafa8dc"],
        "\[NonBreakingSpace]",
        StyleBox[
        "\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
         "InlineSeparator"],
        " ",
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["PArgonNv"]], "paclet:NewEoSArgon/ref/PArgonNv", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "43abe798-9bdf-443f-a226-5db35e644171"],
        "\[NonBreakingSpace]",
        StyleBox[
        "\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
         "InlineSeparator"],
        " ",
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["RhoArgonNv"]], "paclet:NewEoSArgon/ref/RhoArgonNv", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "a602e24b-6ce7-43fb-88aa-3d82ad8861a2"],
        "\[NonBreakingSpace]",
        StyleBox[
        "\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
         "InlineSeparator"],
        " ",
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["dZtotalNv"]], "paclet:NewEoSArgon/ref/dZtotalNv", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "daa91afd-b1c1-4d69-b733-2cfd07516084"],
        "\[NonBreakingSpace]",
        StyleBox[
        "\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
         "InlineSeparator"],
        " ",
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["dZtotalNvdT"]], "paclet:NewEoSArgon/ref/dZtotalNvdT", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "57a58fd1-6375-45db-8b9d-5043438dc7c6"]
       }], "SeeAlso",ExpressionUUID->"0c139bd6-81c6-4e85-8493-9696d5a7e6f3"]}
     }]}
  }]], "SeeAlsoSection",ExpressionUUID->"345969b6-45ce-4ad8-ad59-\
8959bdb06c51"],

Cell[BoxData[GridBox[{
   {
    DynamicBox[FEPrivate`ImportImage[
      FrontEnd`FileName[{"Documentation", "FooterIcons"}, "RelatedGuide.png"]],
     ImageSizeCache->{50., {27., 33.}}], GridBox[{
      {
       StyleBox[
        RowBox[{"Related", " ", "Guides"}], "MoreAboutSection"]},
      {
       RowBox[{"\[FilledVerySmallSquare]", Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["NewEoSArgon Package"]], 
           "paclet:NewEoSArgon/guide/NewEoSArgon"},
          "RefLinkPlain",
          BaseStyle->{"MoreAbout"}]], "MoreAbout",ExpressionUUID->
         "c566f7a4-07e0-4524-b72a-05987ac7410e"]}]}
     }]}
  }]], "MoreAboutSection",ExpressionUUID->"21c73190-3b71-4ec2-9b36-\
b0f89f2a7912"],

Cell[BoxData[GridBox[{
   {
    TemplateBox[{29},
     "Spacer1"], GridBox[{
      {
       RowBox[{
        TemplateBox[{17},
         "Spacer1"], 
        StyleBox[
         RowBox[{"Related", " ", "Links"}], "RelatedLinksSection"]}]},
      {Cell[BoxData[Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData[
             RowBox[{
               RowBox[{"Units", " ", "&"}], " ", "Quantities"}]]], 
           "paclet:guide/Units"},
          "RefLinkPlain",
          BaseStyle->{"RelatedLinks"}]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "bd4ea698-fbce-4c5b-9bc8-ddd0c7f26165"]], "RelatedLinks",
        ExpressionUUID->"4cd77345-8b6b-423a-9727-a73053711b76"]},
      {Cell[BoxData[Cell[BoxData[Cell[BoxData[
          RowBox[{
           TemplateBox[{16},
            "Spacer1"], "\[FilledVerySmallSquare]", 
           TemplateBox[{
             Cell[
              TextData[
               Cell[
                TextData[{
                  Cell[
                   BoxData[
                    TemplateBox[{2}, "Spacer1"]]], "ThermodynamicData"}]]]], 
             "paclet:ref/ThermodynamicData"},
            "RefLink",
            BaseStyle->{"RelatedLinks"}]}]],ExpressionUUID->
          "197ea1de-7f5c-4231-a70e-b596eadc32b8"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "bdf50a4d-86d0-42bd-9c3d-1cd717bd7a22"]], "RelatedLinks",
        ExpressionUUID->"304b9eeb-3af9-4263-acd0-b3f866333609"]}
     }]}
  }]], "RelatedLinksSection",ExpressionUUID->"69d9de9b-0bbd-429e-8baa-\
ab7d2a319fe0"],

Cell[" ", "FooterCell",ExpressionUUID->"e754e42a-2a31-49df-a47c-18595afb8af8"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{900, 835.8},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ZtotalNv",
TaggingRules->{
 "ModificationHighlight" -> False, "ColorType" -> "", "LinkTrails" -> "", 
  "HasOptions" -> True, "ExampleCounter" -> 1, 
  "Openers" -> {
   "PrimaryExamplesSection" -> Open, 
    "ExampleSection" -> {"0" -> Open, "2" -> Closed, "3" -> Closed}, 
    "NotesSection" -> Closed}, "NewStyles" -> True, 
  "CitationPopupData" -> $Failed, "ShowCitation" -> False, "RootCaptions" -> 
  "", "Metadata" -> {
   "built" -> "{2023, 11, 30, 13, 56, 20.7025367}", 
    "history" -> {"XX", "", "", ""}, "context" -> "NewEoSArgon`", 
    "keywords" -> {}, "specialkeywords" -> {}, 
    "tutorialcollectionlinks" -> {}, "index" -> True, "label" -> 
    "New Eo S Argon Package Symbol", "language" -> "en", "paclet" -> 
    "NewEoSArgon Package", "status" -> "None", "summary" -> 
    "ZtotalNv[T, \\[Rho]] \\[Congruent] PV/RT Facteur de compressibilit\
\[EAcute] en fonction de T (Kelvin) et de \\[Rho] (g/cm^3) [Compressibility \
factor versus T (Kelvin) and \\[Rho] (g/cm^3)]", "synonyms" -> {}, 
    "tabletags" -> {}, "title" -> "ZtotalNv", "titlemodifier" -> "", 
    "metadescription" -> "", "windowtitle" -> "ZtotalNv", "type" -> "Symbol", 
    "uri" -> "NewEoSArgon/ref/ZtotalNv"}},
CellContext->"Global`",
FrontEndVersion->"13.3 pour Microsoft Windows (64-bit) (July 24, 2023)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "13.3 pour Microsoft Windows (64-bit) (July 24, 2023)", 
  StyleDefinitions -> "Default.nb"],
ExpressionUUID->"4033cf6c-3944-473d-9d24-cdf67c88fb4d"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[10539, 287, 1420, 37, 35, "PrimaryExamplesSection",ExpressionUUID->"b960118a-b692-4364-bf5a-1ccd5547e457",
   CellTags->"PrimaryExamplesSection",
   CellID->126709650]},
 "RasterizedOutput"->{
  Cell[44010, 1036, 30533, 507, 366, "Output",ExpressionUUID->"dd0f010f-b47c-453b-970e-1686b4870f64",
   CellTags->"RasterizedOutput",
   CellID->12208912]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 94248, 2035},
 {"RasterizedOutput", 94448, 2039}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[580, 21, 5573, 134, 56, "AnchorBarGrid",ExpressionUUID->"1bdc8a54-da07-4a36-a071-2f1411996d2c",
 CellID->1],
Cell[6156, 157, 94, 0, 23, "ContextNameCell",ExpressionUUID->"117f1746-cd1a-4b94-9bec-a534042021f3"],
Cell[CellGroupData[{
Cell[6275, 161, 551, 14, 56, "ObjectNameGrid",ExpressionUUID->"70b9d607-5c8d-492b-8523-df3bc0a7cd27"],
Cell[6829, 177, 1000, 29, 146, "Usage",ExpressionUUID->"98a3ff35-4e12-40b2-b5d6-14ce180ffd73"]
}, Open  ]],
Cell[CellGroupData[{
Cell[7866, 211, 1919, 48, 37, "NotesSection",ExpressionUUID->"53015c4c-7005-4bd0-a623-e501fb28d89b",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->135262610],
Cell[9788, 261, 221, 6, 36, "Notes",ExpressionUUID->"5e24421f-634b-4d7a-9ab0-db229cf7d996",
 CellID->1067943069],
Cell[10012, 269, 185, 4, 36, "Notes",ExpressionUUID->"0e37eba5-e18f-432a-9810-ab6bf000a722",
 CellID->185021568],
Cell[10200, 275, 212, 6, 36, "Notes",ExpressionUUID->"5f788dbc-2799-4287-be93-30d4ff2ce2f7",
 CellID->175218415]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "NotesSection"}, Closed]]]],
Cell[CellGroupData[{
Cell[10539, 287, 1420, 37, 35, "PrimaryExamplesSection",ExpressionUUID->"b960118a-b692-4364-bf5a-1ccd5547e457",
 CellTags->"PrimaryExamplesSection",
 CellID->126709650],
Cell[CellGroupData[{
Cell[11984, 328, 1397, 36, 30, "ExampleSection",ExpressionUUID->"7d0adc17-f821-4167-b6ff-85b7931a19de",
 CellID->41313577],
Cell[13384, 366, 268, 5, 42, "Input",ExpressionUUID->"f46eef0c-5ddf-43dc-9215-6e093f8ebbe6",
 CellID->143015886],
Cell[13655, 373, 219, 6, 38, "ExampleText",ExpressionUUID->"daeea5c5-9b7b-4153-99dc-0945470f429a",
 CellID->544149791],
Cell[CellGroupData[{
Cell[13899, 383, 889, 22, 26, "Input",ExpressionUUID->"dc8cb18b-2075-4181-b11c-67168ce698d3",
 CellID->5710145],
Cell[14791, 407, 144, 2, 35, "Output",ExpressionUUID->"b44cc92e-50e4-4baf-85e5-4dc32ba87385",
 CellID->488525156]
}, Open  ]],
Cell[14950, 412, 154, 1, 38, "ExampleText",ExpressionUUID->"d7c8f829-734d-4c14-9e79-fc6e4161c419",
 CellID->361149294],
Cell[CellGroupData[{
Cell[15129, 417, 560, 13, 42, "Input",ExpressionUUID->"d8926024-2f41-4d13-aeb5-bdb7f4438fbb",
 CellID->67978501],
Cell[15692, 432, 144, 2, 35, "Output",ExpressionUUID->"f45d50de-ec60-4b7b-85cc-a612e3dc1988",
 CellID->239767589]
}, Open  ]],
Cell[15851, 437, 154, 1, 38, "ExampleText",ExpressionUUID->"dfbb3a0a-e5e9-4de2-836e-b5857d0f5034",
 CellID->286706321],
Cell[CellGroupData[{
Cell[16030, 442, 900, 23, 46, "Input",ExpressionUUID->"20bc9cd3-555b-4cf8-a223-ae2462b7b876",
 CellID->605199954],
Cell[16933, 467, 21579, 406, 281, "Output",ExpressionUUID->"70195fe1-7639-4b14-88dd-e0a60183a670",
 CellID->176894861]
}, Open  ]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"}, Closed]]]],
Cell[CellGroupData[{
Cell[38661, 881, 1419, 37, 70, "ExampleSection",ExpressionUUID->"48e306df-7e6e-45d2-8f84-d64e8b8f0b92",
 CellID->258228157],
Cell[40083, 920, 267, 5, 70, "Input",ExpressionUUID->"2c4a871d-a11b-4c28-b554-3887e056c910",
 CellID->87419684],
Cell[40353, 927, 401, 11, 70, "ExampleText",ExpressionUUID->"76fef120-b1ac-4736-9122-4404f50faba0",
 CellID->227520913],
Cell[40757, 940, 464, 13, 70, "Input",ExpressionUUID->"d469060d-2860-46b4-876c-2759dfe531f5",
 CellID->531122037],
Cell[CellGroupData[{
Cell[41246, 957, 2761, 77, 70, "Input",ExpressionUUID->"273bb52a-cc61-4eb6-ad73-1c9454dd49c8",
 CellID->136921489],
Cell[44010, 1036, 30533, 507, 366, "Output",ExpressionUUID->"dd0f010f-b47c-453b-970e-1686b4870f64",
 CellTags->"RasterizedOutput",
 CellID->12208912]
}, Open  ]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "2"}, Closed]]]],
Cell[CellGroupData[{
Cell[74692, 1551, 1423, 37, 70, "ExampleSection",ExpressionUUID->"c980011f-7ad3-4a1f-9569-a7724cb0f16c",
 CellID->1305812373],
Cell[76118, 1590, 268, 5, 70, "Input",ExpressionUUID->"63ff29f5-a594-4102-90e9-cc0985b5a77c",
 CellID->768708256],
Cell[76389, 1597, 147, 1, 70, "ExampleText",ExpressionUUID->"cfa50dfa-d584-41d5-9316-1461a73c848f",
 CellID->109328850],
Cell[CellGroupData[{
Cell[76561, 1602, 6044, 157, 70, "Input",ExpressionUUID->"bd6bbf65-f28c-4b42-be59-d0179a1e3a4f",
 CellID->746773888],
Cell[82608, 1761, 503, 7, 70, "Print",ExpressionUUID->"f660b9d4-b578-4e1d-a421-e9ac23060719",
 CellID->592507982],
Cell[83114, 1770, 3535, 63, 558, "Output",ExpressionUUID->"59e9d9a8-b3f7-4bbc-8c5d-99e14307bf93",
 CellID->563970]
}, Open  ]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "3"}, Closed]]]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "PrimaryExamplesSection"}, Closed]]]],
Cell[86891, 1842, 2920, 78, 70, "SeeAlsoSection",ExpressionUUID->"345969b6-45ce-4ad8-ad59-8959bdb06c51"],
Cell[89814, 1922, 729, 19, 70, "MoreAboutSection",ExpressionUUID->"21c73190-3b71-4ec2-9b36-b0f89f2a7912"],
Cell[90546, 1943, 1607, 43, 70, "RelatedLinksSection",ExpressionUUID->"69d9de9b-0bbd-429e-8baa-ab7d2a319fe0"],
Cell[92156, 1988, 78, 0, 70, "FooterCell",ExpressionUUID->"e754e42a-2a31-49df-a47c-18595afb8af8"]
}
]
*)

(* End of internal cache information *)

