(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 13.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    111020,       2321]
NotebookOptionsPosition[    104156,       2184]
NotebookOutlinePosition[    106923,       2250]
CellTagsIndexPosition[    106799,       2244]
WindowTitle->d2FtotalAdimNvdT2
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[GridBox[{
   {GridBox[{
      {
       ItemBox[Cell[BoxData[
         RowBox[{
          TemplateBox[{12},
           "Spacer1"], Cell["NEW EO S ARGON PACKAGE SYMBOL", "PacletNameCell",
           TextAlignment->Center,ExpressionUUID->
           "f7b9fe9a-db2f-4a7d-8e42-5d019dfb50ac"], 
          TemplateBox[{8},
           "Spacer1"]}]],
         TextAlignment->Center,ExpressionUUID->
         "fbc831c5-e0a2-4172-a041-58e35e30532b"],
        Background->RGBColor[0.490196, 0.576471, 0.690196],
        ItemSize->Full], ""}
     },
     GridBoxAlignment->{"Rows" -> {{Center}}},
     GridBoxItemSize->{"Columns" -> {Full, 
         Scaled[0.02]}, "Rows" -> {{2.5}}}], Cell[TextData[{
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "See Also",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "ab1ca250-c69c-41a0-8fa9-95c4dcee1510"]
         }],ExpressionUUID->"bd50906c-6483-4054-94ab-f3d440834f0b"],
         StripOnInput->False],{
        "\"FtotalAdimNv\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/FtotalAdimNv"], 
         "\"UtotalAdimNv\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/UtotalAdimNv"], 
         "\"CVAdimNv\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/CVAdimNv"], 
         "\"dFtotalAdimNvdT\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/dFtotalAdimNvdT"], 
         "\"RhoArgonNv\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/RhoArgonNv"]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"SeeAlso"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "80962cd9-3ef4-4f57-8dfd-78232d163c59"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "Related Guides",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "d62345ca-5320-4f30-8eef-49e8c5c5e28f"]
         }],ExpressionUUID->"ae099c4a-1580-4ed3-b931-a68f9c895a49"],
         StripOnInput->False],{
        "\"NewEoSArgon Package\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/guide/NewEoSArgon"]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"MoreAbout"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "ed6052a7-cb02-42a9-9316-436ac68ccf6f"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "URL",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "354ed1f1-063b-48bb-8dcf-1a1e1b810be0"]
         }],ExpressionUUID->"88ad79c1-418f-45d9-8688-87be4e7fce5a"],
         StripOnInput->False],{
        "\"NewEoSArgon/ref/d2FtotalAdimNvdT2\"" :> None, 
         "\"Copy Wolfram Documentation Center URL\"" :> 
         Module[{DocumentationSearch`Private`nb$}, 
           DocumentationSearch`Private`nb$ = 
            NotebookPut[
             Notebook[{Cell["NewEoSArgon/ref/d2FtotalAdimNvdT2"]}, Visible -> 
               False]]; 
           SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
           FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
           NotebookClose[DocumentationSearch`Private`nb$]; Null], Delimiter, 
         "\"Copy web URL\"" :> 
         Module[{DocumentationSearch`Private`nb$}, 
           DocumentationSearch`Private`nb$ = 
            NotebookPut[
             Notebook[{
               Cell[BoxData[
                 MakeBoxes[
                  Hyperlink[
                   "http://reference.wolfram.com/language/NewEoSArgon/ref/\
d2FtotalAdimNvdT2.html"], StandardForm]], "Input", TextClipboardType -> 
                 "PlainText"]}, Visible -> False]]; 
           SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
           FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
           NotebookClose[DocumentationSearch`Private`nb$]; Null], 
         "\"Go to web URL\"" :> 
         FrontEndExecute[{
           NotebookLocate[{
             URL[If[TrueQ[DocumentationBuild`Make`Private`wsmlinkQ$11464], 
                 "http://reference.wolfram.com/system-modeler/", 
                 "http://reference.wolfram.com/language/"] <> 
               "NewEoSArgon/ref/d2FtotalAdimNvdT2" <> ".html"], None}]}]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"URLMenu"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "35425368-7510-4aea-8715-c934a8fae83b"]
    }], "AnchorBar",
     CacheGraphics->False,ExpressionUUID->
     "e45c471c-bba3-4c12-815a-4ca02712f4f7"]}
  }]], "AnchorBarGrid",
 CellID->1,ExpressionUUID->"c1b92823-f975-4f5c-ad36-ed2fcc7a7e2d"],

Cell["NewEoSArgon`", "ContextNameCell",ExpressionUUID->"ff760ee5-b044-4c57-b8b2-7f5ab9f8eb73"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     Cell[
     "d2FtotalAdimNvdT2", "ObjectName",ExpressionUUID->
      "e9ca2c15-fdbf-4035-921d-3c3d0dd1c652"],
     Cell[BoxData[
      TemplateBox[{8},
       "Spacer1"]],ExpressionUUID->"673bb963-03c2-4f74-b2d6-ce6d27c2e643"],
     Cell[BoxData[
     ""], "ObjectNameTranslation",ExpressionUUID->
      "c5fc41bb-54a2-433c-8f15-9c8d236ef749"]
    }],ExpressionUUID->"f22fbd7c-5feb-426f-9f76-fa14a620ab92"], 
    "\[SpanFromLeft]"}
  }]], "ObjectNameGrid",ExpressionUUID->"ae0eb3c3-3f07-405c-8107-\
c94ab8a9d2d3"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     "d2FtotalAdimNvdT2[",
     StyleBox["T",
      FontSlant->"Italic"],
     ", \[Rho]] \[Congruent] ",
     Cell[BoxData[
      SubscriptBox[
       RowBox[{"(", 
        FractionBox[
         RowBox[{
          SuperscriptBox["\[PartialD]", "2"], 
          StyleBox["a",
           FontSlant->"Italic"]}], 
         RowBox[{"\[PartialD]", 
          SuperscriptBox[
           StyleBox["T",
            FontSlant->"Italic"], "2"]}]], ")"}], 
       StyleBox["V",
        FontSlant->"Italic"]]], "InlineFormula",
      FontFamily->"Source Sans Pro",ExpressionUUID->
      "86789aa3-0bea-47e2-9bdf-018d338d4472"],
     " = ",
     Cell[BoxData[
      RowBox[{
       FractionBox["1", 
        StyleBox[
         SuperscriptBox[
          StyleBox["T",
           FontSlant->"Italic"], "2"],
         FontSlant->"Italic"]], 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", 
          FractionBox[
           StyleBox["U",
            FontSlant->"Italic"], 
           StyleBox["RT",
            FontSlant->"Italic"]]}], "-", 
         FractionBox[
          StyleBox[
           SubscriptBox["C", "V"],
           FontSlant->"Italic"], 
          StyleBox["R",
           FontSlant->"Italic"]]}], ")"}]}]], "InlineFormula",
      FontFamily->"Source Sans Pro",ExpressionUUID->
      "91f206b4-3560-4e35-97b5-5bd6c4a33e18"],
     " (",
     Cell[BoxData[
      SuperscriptBox["K", 
       RowBox[{"-", "2"}]]], "InlineFormula",
      FontFamily->"Source Sans Pro",ExpressionUUID->
      "a176b501-cbec-472d-b239-b782ad181aa8"],
     ")\nD\[EAcute]riv\[EAcute]e partielle seconde par rapport \[AGrave] ",
     StyleBox["T",
      FontSlant->"Italic"],
     " de l'\[EAcute]nergie libre adimensionnelle ",
     StyleBox["a",
      FontSlant->"Italic"],
     " = ",
     StyleBox["F",
      FontSlant->"Italic"],
     "/",
     StyleBox["RT ",
      FontSlant->"Italic"],
     "en fonction de ",
     StyleBox["T",
      FontSlant->"Italic"],
     " (Kelvin) et de \[Rho] (g/",
     Cell[BoxData[
      SuperscriptBox["cm", "3"]], "InlineFormula",
      FontFamily->"Source Sans Pro",ExpressionUUID->
      "0d8fd160-e620-4ae8-8280-5e004f5c5ff2"],
     ")\n[Second derivative with respect to temperature of non-dimensionnal \
free energy ",
     StyleBox["a",
      FontSlant->"Italic"],
     " = ",
     StyleBox["F",
      FontSlant->"Italic"],
     "/",
     StyleBox["RT",
      FontSlant->"Italic"],
     " versus ",
     StyleBox["T",
      FontSlant->"Italic"],
     " (Kelvin) and \[Rho] (g/",
     Cell[BoxData[
      SuperscriptBox["cm", "3"]], "InlineFormula",
      FontFamily->"Source Sans Pro",ExpressionUUID->
      "90479053-7f4d-4f48-a51a-7cdee7324beb"],
     ")]"
    }],ExpressionUUID->"49d39b3d-8a86-4445-9ee3-22ae864b8636"]}
  }]], "Usage",ExpressionUUID->"cac3f2e2-18c3-4d22-83c1-c9f6962016cb"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[Cell[TextData[{
   Cell[BoxData[
    DynamicBox[ToBoxes[
      If[
       MatchQ[
        CurrentValue[
         EvaluationNotebook[], {TaggingRules, "Openers", "NotesSection"}, 
         Closed], 
        Alternatives[Open, True]], 
       Style[
        Graphics[{
          Thickness[0.18], 
          RGBColor[0.8509803921568627, 0.396078431372549, 0], 
          Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
         PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
        0.68 Inherited], 
       Rotate[
        Style[
         Graphics[{
           Thickness[0.18], 
           RGBColor[0.8509803921568627, 0.396078431372549, 0], 
           Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
          PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
         0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
     ImageSizeCache->{
      13.600000000000001`, {0.5800000000000001, 13.020000000000001`}}]],
    ExpressionUUID->"fb59c368-2a1c-43de-a00d-dfbf1cc1ff93"],
   Cell[BoxData[
    TemplateBox[{1},
     "Spacer1"]],ExpressionUUID->"53c622ac-153d-43ab-9bf8-2058ebacdaa9"],
   "Details and Options"
  }], "NotesFrameText",ExpressionUUID->"9d701a72-e455-43af-ba34-7784585a2dfb"],
  Appearance->{Automatic, None, "Normal", Automatic},
  BaseStyle->None,
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"], 
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], After, CellContents]}]& ),
  Evaluator->None,
  Method->
   "Preemptive"]],ExpressionUUID->"64af00f4-ed58-435c-a738-4c3b9379d090"]], \
"NotesSection",
 WholeCellGroupOpener->True,
 CellGroupingRules->{"SectionGrouping", 50},
 CacheGraphics->False,
 CellID->107640032,ExpressionUUID->"060262ba-f2be-422b-bafa-e07287f2c5fe"],

Cell[TextData[{
 "La fonction est d\[EAcute]finie pour ",
 StyleBox["T",
  FontSlant->"Italic"],
 " > 0 et \[Rho] \[GreaterEqual] 0"
}], "Notes",
 CellID->1067943069,ExpressionUUID->"f841e013-2aff-4d52-a71d-abb08709c7bf"],

Cell["\<\
******************************************************************************\
*****\
\>", "Notes",
 CellID->185021568,ExpressionUUID->"8daaaeb2-706e-4993-a3b6-7b594ef3da2a"],

Cell[TextData[{
 "The function is defined for ",
 StyleBox["T",
  FontSlant->"Italic"],
 " >0 and \[Rho] \[GreaterEqual] 0."
}], "Notes",
 CellID->175218415,ExpressionUUID->"3f3c8959-8f96-4d1f-9a2c-81a67e7ce0bc"]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "NotesSection"}, Closed]]]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {
       TaggingRules, "Openers", "PrimaryExamplesSection"}, Open], 
      Alternatives[True, Open]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{13.600000000000001`, {5., 8.600000000000001}}]],
  ExpressionUUID->"4bdc6aa9-6faa-445d-853e-6080b4ea46f2"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"0e7b9a3c-2469-48a7-8721-fa0bb30911ff"],
 "Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount",ExpressionUUID->
  "ef6f5778-01da-410a-a826-fae72fddddb5"]
}], "PrimaryExamplesSection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellTags->"PrimaryExamplesSection",
 CellID->568424512,ExpressionUUID->"ff48b480-a640-4d0e-919a-5f876faca8a4"],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"},
        Closed], 
      Alternatives[Open, True]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{13.600000000000001`, {5., 8.600000000000001}}]],
  ExpressionUUID->"9548b9fa-4a82-4b7f-81eb-3d63e3b535c8"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"3aad1a99-5d29-44df-9f86-46cde2acf6a5"],
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "a339b01f-f738-4902-b206-68becd8cd54a"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellID->442358265,ExpressionUUID->"02170251-3bf1-4eb2-83a7-b6ec2568f59b"],

Cell[BoxData[{
 RowBox[{"Needs", "[", "\"\<NewEoSArgon`\>\"", "]"}], "\[IndentingNewLine]", 
 RowBox[{"Off", "[", 
  RowBox[{"General", "::", "munfl"}], "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->143015886,ExpressionUUID->"24dfa350-97ac-4f7c-a18d-60c6772c0c03"],

Cell[TextData[{
 "Calculated value of ",
 Cell[BoxData[
  SubscriptBox[
   RowBox[{"(", 
    FractionBox[
     RowBox[{
      SuperscriptBox["\[PartialD]", "2"], 
      StyleBox["a",
       FontSlant->"Italic"]}], 
     RowBox[{"\[PartialD]", 
      SuperscriptBox[
       StyleBox["T",
        FontSlant->"Italic"], "2"]}]], ")"}], 
   StyleBox["V",
    FontSlant->"Italic"]]], "InlineFormula",
  FontFamily->"Source Sans Pro",ExpressionUUID->
  "87cb0ade-e299-4540-8048-fecef9c9cb91"],
 " for atmospheric pressure and 20\[Degree]C"
}], "ExampleText",
 CellID->544149791,ExpressionUUID->"82ebb88a-d63f-4ed7-ac4d-e516b7ee3af4"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Quantity", "[", 
  RowBox[{
   RowBox[{"d2FtotalAdimNvdT2", "[", 
    RowBox[{"293.15", ",", 
     RowBox[{"RhoArgonNv", "[", 
      RowBox[{"293.15", ",", 
       RowBox[{"QuantityMagnitude", "@", 
        RowBox[{"N", "@", 
         RowBox[{"UnitConvert", "[", 
          RowBox[{
           TemplateBox[{"1"},
            "QuantityUnit",
            DisplayFunction->(TooltipBox[
              StyleBox[
               RowBox[{#, "\[InvisibleSpace]", 
                 StyleBox[
                  RowBox[{" ", "\"atm\""}], "QuantityUnitTraditionalLabel"]}],
                ShowStringCharacters -> False], "Unit: atmospheres"]& ),
            InterpretationFunction->(RowBox[{"Quantity", "[", 
               RowBox[{#, ",", "\"Atmospheres\""}], "]"}]& )], ",", 
           "\"\<Bars\>\""}], "]"}]}]}], ",", "\"\<G\>\""}], "]"}]}], "]"}], 
   ",", 
   RowBox[{"1", "/", 
    SuperscriptBox["\"\<Kelvins\>\"", "2"]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->5710145,ExpressionUUID->"aef08539-1320-4888-9ab9-7c63c2ccb4e2"],

Cell[BoxData[
 TemplateBox[{"0.000017377759915202714`", 
   RowBox[{"\"/\"", "\[InvisibleSpace]", 
     SuperscriptBox["\"K\"", "2"]}], "per kelvins squared", 
   FractionBox["1", 
    SuperscriptBox["\"Kelvins\"", "2"]]},
  "Quantity"]], "Output",
 CellLabel->"Out[2]=",
 CellID->20335808,ExpressionUUID->"2aecd6cf-cda4-4c0a-8268-3462eea7ed67"]
}, Open  ]],

Cell[TextData[{
 "Verification of formula ",
 Cell[BoxData[
  SubscriptBox[
   RowBox[{"(", 
    FractionBox[
     RowBox[{
      SuperscriptBox["\[PartialD]", "2"], 
      StyleBox["a",
       FontSlant->"Italic"]}], 
     RowBox[{"\[PartialD]", 
      SuperscriptBox[
       StyleBox["T",
        FontSlant->"Italic"], "2"]}]], ")"}], 
   StyleBox["V",
    FontSlant->"Italic"]]], "InlineFormula",
  FontFamily->"Source Sans Pro",ExpressionUUID->
  "fc577f35-4498-4597-8762-77b266a133bb"],
 " = ",
 Cell[BoxData[
  RowBox[{
   FractionBox["1", 
    StyleBox[
     SuperscriptBox[
      StyleBox["T",
       FontSlant->"Italic"], "2"],
     FontSlant->"Italic"]], 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"2", 
      FractionBox[
       StyleBox["U",
        FontSlant->"Italic"], 
       StyleBox["RT",
        FontSlant->"Italic"]]}], "-", 
     FractionBox[
      StyleBox[
       SubscriptBox["C", "V"],
       FontSlant->"Italic"], 
      StyleBox["R",
       FontSlant->"Italic"]]}], ")"}]}]], "InlineFormula",
  FontFamily->"Source Sans Pro",ExpressionUUID->
  "d9dc6d0d-18e6-4948-9af8-595a80556a56"]
}], "ExampleText",
 CellID->336157766,ExpressionUUID->"ff42293a-f459-4276-9fce-d2bf6dfe15cc"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Quantity", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"2", "*", 
       RowBox[{"UtotalAdimNv", "[", 
        RowBox[{"293.15", ",", 
         RowBox[{"RhoArgonNv", "[", 
          RowBox[{"293.15", ",", 
           RowBox[{"QuantityMagnitude", "@", 
            RowBox[{"N", "@", 
             RowBox[{"UnitConvert", "[", 
              RowBox[{
               TemplateBox[{"1"},
                "QuantityUnit",
                DisplayFunction->(TooltipBox[
                  StyleBox[
                   RowBox[{#, "\[InvisibleSpace]", 
                    StyleBox[
                    RowBox[{" ", "\"atm\""}], 
                    "QuantityUnitTraditionalLabel"]}], ShowStringCharacters -> 
                   False], "Unit: atmospheres"]& ),
                InterpretationFunction->(RowBox[{"Quantity", "[", 
                   RowBox[{#, ",", "\"Atmospheres\""}], "]"}]& )], ",", 
               "\"\<Bars\>\""}], "]"}]}]}], ",", "\"\<G\>\""}], "]"}]}], 
        "]"}]}], "-", 
      RowBox[{"CVAdimNv", "[", 
       RowBox[{"293.15", ",", 
        RowBox[{"RhoArgonNv", "[", 
         RowBox[{"293.15", ",", 
          RowBox[{"QuantityMagnitude", "@", 
           RowBox[{"N", "@", 
            RowBox[{"UnitConvert", "[", 
             RowBox[{
              TemplateBox[{"1"},
               "QuantityUnit",
               DisplayFunction->(TooltipBox[
                 StyleBox[
                  RowBox[{#, "\[InvisibleSpace]", 
                    StyleBox[
                    RowBox[{" ", "\"atm\""}], 
                    "QuantityUnitTraditionalLabel"]}], ShowStringCharacters -> 
                  False], "Unit: atmospheres"]& ),
               InterpretationFunction->(RowBox[{"Quantity", "[", 
                  RowBox[{#, ",", "\"Atmospheres\""}], "]"}]& )], ",", 
              "\"\<Bars\>\""}], "]"}]}]}], ",", "\"\<G\>\""}], "]"}]}], 
       "]"}]}], ")"}], "/", 
    SuperscriptBox["293.15", "2"]}], ",", 
   RowBox[{"1", "/", 
    SuperscriptBox["\"\<Kelvins\>\"", "2"]}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->132231421,ExpressionUUID->"7598e04f-92c8-4b49-8c73-c06cae295c46"],

Cell[BoxData[
 TemplateBox[{"0.000017377759915202717`", 
   RowBox[{"\"/\"", "\[InvisibleSpace]", 
     SuperscriptBox["\"K\"", "2"]}], "per kelvins squared", 
   FractionBox["1", 
    SuperscriptBox["\"Kelvins\"", "2"]]},
  "Quantity"]], "Output",
 CellLabel->"Out[3]=",
 CellID->213516437,ExpressionUUID->"6687c46d-cade-4c03-94ae-56a05bd21235"]
}, Open  ]],

Cell["\<\
Second derivative of free energy on the saturation curve from NIST\
\>", "ExampleText",
 CellID->286706321,ExpressionUUID->"4d478ef1-a29c-488c-af39-03507ddb3e74"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"d2FtotalAdimNvdT2", "[", 
     RowBox[{
      RowBox[{"TSatNIST", "[", "\[Rho]", "]"}], ",", "\[Rho]"}], "]"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"\[Rho]", ",", "\[Rho]trgaz", ",", "\[Rho]trliq"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", "Red", "}"}]}], ",", 
   RowBox[{"AxesOrigin", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\[Rho]c", ",", "Automatic"}], "}"}]}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "\"\<\[Rho] (g/\!\(\*SuperscriptBox[\(cm\), \(3\)]\))\>\"", ",", 
      "\"\<(\!\(\*FractionBox[RowBox[{SuperscriptBox[\"\[PartialD]\", \"2\"], \
StyleBox[\"a\",FontSlant->\"Italic\"]}], RowBox[{\"\[PartialD]\", \
SuperscriptBox[StyleBox[\"T\",FontSlant->\"Italic\"], \
\"2\"]}]]\)\!\(\*SubscriptBox[\")\", StyleBox[\"V\",FontSlant->\"Italic\"]]\) \
(\!\(\*SuperscriptBox[\(K\), \(-2\)]\))\>\""}], "}"}]}], ",", 
   RowBox[{"ImageSize", "\[Rule]", "450"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->605199954,ExpressionUUID->"701e7507-34bb-443d-8f79-3801ca81fb33"],

Cell[BoxData[
 GraphicsBox[
  InterpretationBox[{
    TagBox[{{{}, {}, 
       TagBox[
        {RGBColor[1, 0, 0], AbsoluteThickness[2], Opacity[1.], 
         LineBox[CompressedData["
1:eJwV13k8VF8bAHCUXUJEkl0qMwxCljz2bEXZIiEia9l3kqUoShJCkShSksoW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          "]]},
        Annotation[#, "Charting`Private`Tag#1"]& ]}, {}},
     {"WolframDynamicHighlight", <|
      "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>}], 
    DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
      Slot["HighlightElements"], 
      Slot["LayoutOptions"], 
      Slot["Meta"], 
      Charting`HighlightActionFunction["DynamicHighlight", {{{{}, {}, 
          Annotation[{
            Directive[
             Opacity[1.], 
             AbsoluteThickness[2], 
             RGBColor[1, 0, 0]], 
            Line[CompressedData["
1:eJwV13k8VF8bAHCUXUJEkl0qMwxCljz2bEXZIiEia9l3kqUoShJCkShSksoW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             "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
       "HighlightElements" -> <|
         "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
        "LayoutOptions" -> <|
         "PlotRange" -> {All, All}, "Frame" -> {{True, True}, {True, True}}, 
          "AxesOrigin" -> {0.535599, 0}, 
          "ImageSize" -> {450, 450/GoldenRatio}, "Axes" -> {True, True}, 
          "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
          "DefaultStyle" -> {
            Directive[
             Opacity[1.], 
             AbsoluteThickness[2], 
             RGBColor[1, 0, 0]]}, 
          "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
              Identity[
               Part[#, 1]], 
              Identity[
               Part[#, 2]]}& ), 
            "ScalingFunctions" -> {{Identity, Identity}, {
              Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>,
         "Meta" -> <|
         "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
          Plot, "GroupHighlight" -> False|>|>]]& )[<|
      "HighlightElements" -> <|
        "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
       "LayoutOptions" -> <|
        "PlotRange" -> {All, All}, "Frame" -> {{True, True}, {True, True}}, 
         "AxesOrigin" -> {0.535599, 0}, "ImageSize" -> {450, 450/GoldenRatio},
          "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
         GoldenRatio^(-1), "DefaultStyle" -> {
           Directive[
            Opacity[1.], 
            AbsoluteThickness[2], 
            RGBColor[1, 0, 0]]}, 
         "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
             Identity[
              Part[#, 1]], 
             Identity[
              Part[#, 2]]}& ), 
           "ScalingFunctions" -> {{Identity, Identity}, {
             Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>, 
       "Meta" -> <|
        "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
         Plot, "GroupHighlight" -> False|>|>],
     ImageSizeCache->{{4.503599627370496*^15, -4.503599627370496*^15}, {
      4.503599627370496*^15, -4.503599627370496*^15}}]},
   Annotation[{{{{}, {}, 
       Annotation[{
         Directive[
          Opacity[1.], 
          AbsoluteThickness[2], 
          RGBColor[1, 0, 0]], 
         Line[CompressedData["
1:eJwV13k8VF8bAHCUXUJEkl0qMwxCljz2bEXZIiEia9l3kqUoShJCkShSksoW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          "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
    "HighlightElements" -> <|
      "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
     "LayoutOptions" -> <|
      "PlotRange" -> {All, All}, "Frame" -> {{True, True}, {True, True}}, 
       "AxesOrigin" -> {0.535599, 0}, "ImageSize" -> {450, 450/GoldenRatio}, 
       "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
       GoldenRatio^(-1), "DefaultStyle" -> {
         Directive[
          Opacity[1.], 
          AbsoluteThickness[2], 
          RGBColor[1, 0, 0]]}, 
       "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
           Identity[
            Part[#, 1]], 
           Identity[
            Part[#, 2]]}& ), 
         "ScalingFunctions" -> {{Identity, Identity}, {Identity, Identity}}|>,
        "Primitives" -> {}, "GCFlag" -> False|>, 
     "Meta" -> <|
      "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
       Plot, "GroupHighlight" -> False|>|>, "DynamicHighlight"]],
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0.535599, 0},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{
     FormBox[
      TagBox[
      "\"(\\!\\(\\*FractionBox[RowBox[{SuperscriptBox[\\\"\[PartialD]\\\", \\\
\"2\\\"], StyleBox[\\\"a\\\",FontSlant->\\\"Italic\\\"]}], RowBox[{\\\"\
\[PartialD]\\\", \
SuperscriptBox[StyleBox[\\\"T\\\",FontSlant->\\\"Italic\\\"], \
\\\"2\\\"]}]]\\)\\!\\(\\*SubscriptBox[\\\")\\\", \
StyleBox[\\\"V\\\",FontSlant->\\\"Italic\\\"]]\\) \
(\\!\\(\\*SuperscriptBox[\\(K\\), \\(-2\\)]\\))\"", HoldForm], 
      TraditionalForm], None}, {
     FormBox[
      TagBox[
      "\"\[Rho] (g/\\!\\(\\*SuperscriptBox[\\(cm\\), \\(3\\)]\\))\"", 
       HoldForm], TraditionalForm], None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  ImageSize->450,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellLabel->"Out[4]=",
 CellID->453856339,ExpressionUUID->"4c41fd9e-f511-4e53-84b1-388f2077a036"]
}, Open  ]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"}, 
  Closed]]]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "2"},
        Closed], 
      Alternatives[Open, True]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{
    13.600000000000001`, {0.5800000000000001, 13.020000000000001`}}]],
  ExpressionUUID->"30def6fd-6b19-477a-9064-e843670ce79b"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"6bb59f64-2624-4e08-8d35-d221e34434c9"],
 "Applications",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "ad155ed9-ef90-48ca-93a0-0a39082ff403"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellID->134465257,ExpressionUUID->"4ee5cf87-9456-482c-a242-30d0b85cbfec"],

Cell[BoxData[{
 RowBox[{"Needs", "[", "\"\<NewEoSArgon`\>\"", "]"}], "\[IndentingNewLine]", 
 RowBox[{"Off", "[", 
  RowBox[{"General", "::", "munfl"}], "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->87419684,ExpressionUUID->"d87b7c67-cb79-409a-8057-e64c97aa04d3"],

Cell[TextData[{
 "Comparison with ",
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["NIST data"]], "http://webbook.nist.gov/chemistry/fluid/"},
   "WebLink",
   BaseStyle->{"ExampleText"}]],ExpressionUUID->
  "00fc310a-335b-4b16-b0ac-71142a1e6b37"],
 " on an isotherm close to the critical isotherm"
}], "ExampleText",
 CellID->227520913,ExpressionUUID->"059acf41-a674-4b29-836a-8b2b632bb65c"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"datafile", "=", 
   RowBox[{"FileNameJoin", "[", 
    RowBox[{"{", 
     RowBox[{
     "\"\<NewEoSArgon\>\"", ",", "\"\<DataFiles\>\"", ",", 
      "\"\<DataCritNIST.dat\>\""}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dataNIST", "=", 
   RowBox[{"Import", "[", "datafile", "]"}]}], ";"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->531122037,ExpressionUUID->"dc191b79-8d0a-4c4d-ab21-0380a10f23ed"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ArT150p7Fpp", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"dataNIST", "[", 
        RowBox[{"[", 
         RowBox[{"i", ",", "3"}], "]"}], "]"}], ",", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", "*", 
           RowBox[{"dataNIST", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "5"}], "]"}], "]"}], "*", 
           RowBox[{"1000", "/", 
            RowBox[{"(", 
             RowBox[{"RR", "*", 
              RowBox[{"dataNIST", "[", 
               RowBox[{"[", 
                RowBox[{"i", ",", "1"}], "]"}], "]"}]}], ")"}]}]}], "-", 
          RowBox[{
           RowBox[{"dataNIST", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "8"}], "]"}], "]"}], "/", "RR"}]}], ")"}], "/", 
        SuperscriptBox[
         RowBox[{"dataNIST", "[", 
          RowBox[{"[", 
           RowBox[{"i", ",", "1"}], "]"}], "]"}], "2"]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "2", ",", "51"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Legended", "[", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"d2FtotalAdimNvdT2", "[", 
      RowBox[{"150.7", ",", "x"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0.0000319`", ",", "1.6046`"}], "}"}], ",", 
     RowBox[{"AxesOrigin", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\[Rho]c", ",", "Automatic"}], "}"}]}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
     RowBox[{"Frame", "\[Rule]", "True"}], ",", 
     RowBox[{"FrameLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
       "\"\<\[Rho] (g/\!\(\*SuperscriptBox[\(cm\), \(3\)]\))\>\"", ",", 
        "\"\<(\!\(\*FractionBox[RowBox[{SuperscriptBox[\"\[PartialD]\", \
\"2\"], StyleBox[\"a\",FontSlant->\"Italic\"]}], RowBox[{\"\[PartialD]\", \
SuperscriptBox[StyleBox[\"T\",FontSlant->\"Italic\"], \
\"2\"]}]]\)\!\(\*SubscriptBox[\")\", StyleBox[\"V\",FontSlant->\"Italic\"]]\) \
(\!\(\*SuperscriptBox[\(K\), \(-2\)]\))\>\"", ",", 
        "\"\<ISOTHERM 150.7 K\>\""}], "}"}]}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", "Red", "}"}]}], ",", 
     RowBox[{"Epilog", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"PointSize", "\[Rule]", "Medium"}], ",", 
        RowBox[{"Map", "[", 
         RowBox[{"Point", ",", "ArT150p7Fpp"}], "]"}]}], "}"}]}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "450"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Placed", "[", 
      RowBox[{
       RowBox[{"PointLegend", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"Directive", "[", 
           RowBox[{"Black", ",", 
            RowBox[{"AbsolutePointSize", "[", "6", "]"}]}], "]"}], "}"}], ",", 
         RowBox[{"{", "\"\<NIST database\>\"", "}"}]}], "]"}], ",", "Below"}],
       "]"}], ",", 
     RowBox[{"Placed", "[", 
      RowBox[{
       RowBox[{"LineLegend", "[", 
        RowBox[{
         RowBox[{"{", "Red", "}"}], ",", 
         RowBox[{
         "{", "\"\<d2FtotalAdimNvdT2[\!\(\*StyleBox[\"T\",FontSlant->\"Italic\
\"]\),\[Rho]]\>\"", "}"}]}], "]"}], ",", "Below"}], "]"}]}], "}"}]}], 
  "]"}]}], "Input",
 CellLabel->"In[3]:=",
 CellID->136921489,ExpressionUUID->"ab5af983-15d4-4abb-ae1c-cecf64b53193"],

Cell[BoxData[
 GraphicsBox[
  TagBox[RasterBox[CompressedData["
1:eJzt3U9onFt+53/1jbpbaXyb6uCZNowHHOJJPBkPfemuhQe80ICg/QMTzPwc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    "], {{0, 317.}, {450., 0}}, {0, 255},
    ColorFunction->RGBColor,
    ImageResolution->{144., 144.},
    SmoothingQuality->"High"],
   BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
   Selectable->False],
  DefaultBaseStyle->"ImageGraphics",
  ImageSize->Automatic,
  ImageSizeRaw->{450., 317.},
  PlotRange->{{0, 450.}, {0, 317.}}]], "Output",
 CellTags->"RasterizedOutput",
 CellLabel->"Out[3]=",
 CellID->335198732,ExpressionUUID->"63738ff6-5d0e-4bfd-8ac4-5d85ac61a30e"]
}, Open  ]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "2"}, 
  Closed]]]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "PrimaryExamplesSection"}, 
  Closed]]]],

Cell[BoxData[GridBox[{
   {
    DynamicBox[FEPrivate`ImportImage[
      FrontEnd`FileName[{"Documentation", "FooterIcons"}, 
       "RelatedFunction.png"]],
     ImageSizeCache->{50., {27., 33.}}], GridBox[{
      {
       StyleBox[
        RowBox[{"See", " ", "Also"}], "SeeAlsoSection"]},
      {Cell[TextData[{
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["FtotalAdimNv"]], "paclet:NewEoSArgon/ref/FtotalAdimNv", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "9161528d-cc4c-4a5f-87c8-fb4a3ce72da9"],
        "\[NonBreakingSpace]",
        StyleBox[
        "\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
         "InlineSeparator"],
        " ",
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["UtotalAdimNv"]], "paclet:NewEoSArgon/ref/UtotalAdimNv", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "77dbecf5-7283-4cdf-b63b-b60bbd41a8b9"],
        "\[NonBreakingSpace]",
        StyleBox[
        "\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
         "InlineSeparator"],
        " ",
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["CVAdimNv"]], "paclet:NewEoSArgon/ref/CVAdimNv", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "ce27f871-23f0-479f-8c76-6f38d82753f0"],
        "\[NonBreakingSpace]",
        StyleBox[
        "\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
         "InlineSeparator"],
        " ",
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["dFtotalAdimNvdT"]], 
           "paclet:NewEoSArgon/ref/dFtotalAdimNvdT", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "e0907551-281d-45cd-bfda-7f9c350e891e"],
        "\[NonBreakingSpace]",
        StyleBox[
        "\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
         "InlineSeparator"],
        " ",
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["RhoArgonNv"]], "paclet:NewEoSArgon/ref/RhoArgonNv", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "770006ac-071a-48f3-9cec-d5906ba45e43"]
       }], "SeeAlso",ExpressionUUID->"e0803b18-7cac-46b6-bbc3-1620658e167b"]}
     }]}
  }]], "SeeAlsoSection",ExpressionUUID->"4d88e48c-18ac-4b4c-a317-\
b8a8b414e039"],

Cell[BoxData[GridBox[{
   {
    DynamicBox[FEPrivate`ImportImage[
      FrontEnd`FileName[{"Documentation", "FooterIcons"}, "RelatedGuide.png"]],
     ImageSizeCache->{50., {27., 33.}}], GridBox[{
      {
       StyleBox[
        RowBox[{"Related", " ", "Guides"}], "MoreAboutSection"]},
      {
       RowBox[{"\[FilledVerySmallSquare]", Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["NewEoSArgon Package"]], 
           "paclet:NewEoSArgon/guide/NewEoSArgon"},
          "RefLinkPlain",
          BaseStyle->{"MoreAbout"}]], "MoreAbout",ExpressionUUID->
         "801fcd7c-9934-4975-9de3-c6fbad2ee887"]}]}
     }]}
  }]], "MoreAboutSection",ExpressionUUID->"be8843c2-f344-4789-990b-\
0be17c9201c9"],

Cell[BoxData[GridBox[{
   {
    TemplateBox[{29},
     "Spacer1"], GridBox[{
      {
       RowBox[{
        TemplateBox[{17},
         "Spacer1"], 
        StyleBox[
         RowBox[{"Related", " ", "Links"}], "RelatedLinksSection"]}]},
      {Cell[BoxData[Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData[
             RowBox[{
               RowBox[{"Units", " ", "&"}], " ", "Quantities"}]]], 
           "paclet:guide/Units"},
          "RefLinkPlain",
          BaseStyle->{"RelatedLinks"}]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "4f922453-60c5-4630-a2ce-4ccc83c84092"]], "RelatedLinks",
        ExpressionUUID->"8808a88e-5c8a-465f-aadb-da8c828280b2"]},
      {Cell[BoxData[Cell[BoxData[Cell[BoxData[
          RowBox[{
           TemplateBox[{16},
            "Spacer1"], "\[FilledVerySmallSquare]", 
           TemplateBox[{
             Cell[
              TextData[
               Cell[
                TextData[{
                  Cell[
                   BoxData[
                    TemplateBox[{2}, "Spacer1"]]], "ThermodynamicData"}]]]], 
             "paclet:ref/ThermodynamicData"},
            "RefLink",
            BaseStyle->{"RelatedLinks"}]}]],ExpressionUUID->
          "5f541472-e07a-4b85-abfc-09a0904eab1f"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "54424927-b0a5-4536-a2ef-76d3782cc7d7"]], "RelatedLinks",
        ExpressionUUID->"a5c6af96-d117-48e4-9622-d87d835e71f4"]}
     }]}
  }]], "RelatedLinksSection",ExpressionUUID->"fa3551fa-84a6-4f51-9828-\
c2175097eb5b"],

Cell[" ", "FooterCell",ExpressionUUID->"c2620c5c-52f7-4a6e-b221-ddf86bd6d10b"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{900, 835.8},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"d2FtotalAdimNvdT2",
TaggingRules->{
 "ModificationHighlight" -> False, "ColorType" -> "", "LinkTrails" -> "", 
  "HasOptions" -> True, "ExampleCounter" -> 1, 
  "Openers" -> {
   "PrimaryExamplesSection" -> Open, 
    "ExampleSection" -> {"0" -> Open, "2" -> Closed}, "NotesSection" -> 
    Closed}, "NewStyles" -> True, "CitationPopupData" -> $Failed, 
  "ShowCitation" -> False, "RootCaptions" -> "", 
  "Metadata" -> {
   "built" -> "{2023, 11, 30, 13, 55, 31.0609636}", 
    "history" -> {"XX", "", "", ""}, "context" -> "NewEoSArgon`", 
    "keywords" -> {}, "specialkeywords" -> {}, 
    "tutorialcollectionlinks" -> {}, "index" -> True, "label" -> 
    "New Eo S Argon Package Symbol", "language" -> "en", "paclet" -> 
    "NewEoSArgon Package", "status" -> "None", "summary" -> 
    "d2FtotalAdimNvdT2[T, \\[Rho]] \\[Congruent] ((\\[PartialD]^2 \
a)/\\[PartialD]T^2) V = 1/(T 2) (2 U/RT - CV/R) (K -2) \
D\[EAcute]riv\[EAcute]e partielle seconde par rapport \[AGrave] T de l'\
\[EAcute]nergie libre adimensionnelle a = F/RT en fonction de T (Kelvin) et \
de \\[Rho] (g/cm^3) [Second derivative with respect to temperature of \
non-dimensionnal free energy a = F/RT versus T (Kelvin) and \\[Rho] \
(g/cm^3)]", "synonyms" -> {}, "tabletags" -> {}, "title" -> 
    "d2FtotalAdimNvdT2", "titlemodifier" -> "", "metadescription" -> "", 
    "windowtitle" -> "d2FtotalAdimNvdT2", "type" -> "Symbol", "uri" -> 
    "NewEoSArgon/ref/d2FtotalAdimNvdT2"}},
CellContext->"Global`",
FrontEndVersion->"13.3 pour Microsoft Windows (64-bit) (July 24, 2023)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "13.3 pour Microsoft Windows (64-bit) (July 24, 2023)", 
  StyleDefinitions -> "Default.nb"],
ExpressionUUID->"a1ac6c33-ae17-4692-832b-e4c62d133387"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[12528, 353, 1420, 37, 35, "PrimaryExamplesSection",ExpressionUUID->"ff48b480-a640-4d0e-919a-5f876faca8a4",
   CellTags->"PrimaryExamplesSection",
   CellID->568424512]},
 "RasterizedOutput"->{
  Cell[65938, 1486, 32583, 540, 338, "Output",ExpressionUUID->"63738ff6-5d0e-4bfd-8ac4-5d85ac61a30e",
   CellTags->"RasterizedOutput",
   CellID->335198732]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 106417, 2233},
 {"RasterizedOutput", 106617, 2237}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[589, 21, 5671, 136, 56, "AnchorBarGrid",ExpressionUUID->"c1b92823-f975-4f5c-ad36-ed2fcc7a7e2d",
 CellID->1],
Cell[6263, 159, 94, 0, 23, "ContextNameCell",ExpressionUUID->"ff760ee5-b044-4c57-b8b2-7f5ab9f8eb73"],
Cell[CellGroupData[{
Cell[6382, 163, 560, 14, 56, "ObjectNameGrid",ExpressionUUID->"ae0eb3c3-3f07-405c-8107-c94ab8a9d2d3"],
Cell[6945, 179, 2873, 93, 153, "Usage",ExpressionUUID->"cac3f2e2-18c3-4d22-83c1-c9f6962016cb"]
}, Open  ]],
Cell[CellGroupData[{
Cell[9855, 277, 1919, 48, 37, "NotesSection",ExpressionUUID->"060262ba-f2be-422b-bafa-e07287f2c5fe",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->107640032],
Cell[11777, 327, 221, 6, 36, "Notes",ExpressionUUID->"f841e013-2aff-4d52-a71d-abb08709c7bf",
 CellID->1067943069],
Cell[12001, 335, 185, 4, 36, "Notes",ExpressionUUID->"8daaaeb2-706e-4993-a3b6-7b594ef3da2a",
 CellID->185021568],
Cell[12189, 341, 212, 6, 36, "Notes",ExpressionUUID->"3f3c8959-8f96-4d1f-9a2c-81a67e7ce0bc",
 CellID->175218415]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "NotesSection"}, Closed]]]],
Cell[CellGroupData[{
Cell[12528, 353, 1420, 37, 35, "PrimaryExamplesSection",ExpressionUUID->"ff48b480-a640-4d0e-919a-5f876faca8a4",
 CellTags->"PrimaryExamplesSection",
 CellID->568424512],
Cell[CellGroupData[{
Cell[13973, 394, 1398, 36, 30, "ExampleSection",ExpressionUUID->"02170251-3bf1-4eb2-83a7-b6ec2568f59b",
 CellID->442358265],
Cell[15374, 432, 268, 5, 42, "Input",ExpressionUUID->"24dfa350-97ac-4f7c-a18d-60c6772c0c03",
 CellID->143015886],
Cell[15645, 439, 627, 20, 46, "ExampleText",ExpressionUUID->"82ebb88a-d63f-4ed7-ac4d-e516b7ee3af4",
 CellID->544149791],
Cell[CellGroupData[{
Cell[16297, 463, 1058, 26, 46, "Input",ExpressionUUID->"aef08539-1320-4888-9ab9-7c63c2ccb4e2",
 CellID->5710145],
Cell[17358, 491, 345, 8, 43, "Output",ExpressionUUID->"2aecd6cf-cda4-4c0a-8268-3462eea7ed67",
 CellID->20335808]
}, Open  ]],
Cell[17718, 502, 1205, 44, 46, "ExampleText",ExpressionUUID->"ff42293a-f459-4276-9fce-d2bf6dfe15cc",
 CellID->336157766],
Cell[CellGroupData[{
Cell[18948, 550, 2173, 53, 61, "Input",ExpressionUUID->"7598e04f-92c8-4b49-8c73-c06cae295c46",
 CellID->132231421],
Cell[21124, 605, 346, 8, 43, "Output",ExpressionUUID->"6687c46d-cade-4c03-94ae-56a05bd21235",
 CellID->213516437]
}, Open  ]],
Cell[21485, 616, 172, 3, 38, "ExampleText",ExpressionUUID->"4d478ef1-a29c-488c-af39-03507ddb3e74",
 CellID->286706321],
Cell[CellGroupData[{
Cell[21682, 623, 1234, 28, 68, "Input",ExpressionUUID->"701e7507-34bb-443d-8f79-3801ca81fb33",
 CellID->605199954],
Cell[22919, 653, 36967, 659, 284, "Output",ExpressionUUID->"4c41fd9e-f511-4e53-84b1-388f2077a036",
 CellID->453856339]
}, Open  ]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"}, Closed]]]],
Cell[CellGroupData[{
Cell[60035, 1320, 1419, 37, 70, "ExampleSection",ExpressionUUID->"4ee5cf87-9456-482c-a242-30d0b85cbfec",
 CellID->134465257],
Cell[61457, 1359, 267, 5, 70, "Input",ExpressionUUID->"d87b7c67-cb79-409a-8057-e64c97aa04d3",
 CellID->87419684],
Cell[61727, 1366, 401, 11, 70, "ExampleText",ExpressionUUID->"059acf41-a674-4b29-836a-8b2b632bb65c",
 CellID->227520913],
Cell[62131, 1379, 464, 13, 70, "Input",ExpressionUUID->"dc191b79-8d0a-4c4d-ab21-0380a10f23ed",
 CellID->531122037],
Cell[CellGroupData[{
Cell[62620, 1396, 3315, 88, 70, "Input",ExpressionUUID->"ab5af983-15d4-4abb-ae1c-cecf64b53193",
 CellID->136921489],
Cell[65938, 1486, 32583, 540, 338, "Output",ExpressionUUID->"63738ff6-5d0e-4bfd-8ac4-5d85ac61a30e",
 CellTags->"RasterizedOutput",
 CellID->335198732]
}, Open  ]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "2"}, Closed]]]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "PrimaryExamplesSection"}, Closed]]]],
Cell[98763, 2035, 2966, 79, 70, "SeeAlsoSection",ExpressionUUID->"4d88e48c-18ac-4b4c-a317-b8a8b414e039"],
Cell[101732, 2116, 729, 19, 70, "MoreAboutSection",ExpressionUUID->"be8843c2-f344-4789-990b-0be17c9201c9"],
Cell[102464, 2137, 1607, 43, 70, "RelatedLinksSection",ExpressionUUID->"fa3551fa-84a6-4f51-9828-c2175097eb5b"],
Cell[104074, 2182, 78, 0, 70, "FooterCell",ExpressionUUID->"c2620c5c-52f7-4a6e-b221-ddf86bd6d10b"]
}
]
*)

(* End of internal cache information *)

