(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 13.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     76238,       1806]
NotebookOptionsPosition[     69655,       1676]
NotebookOutlinePosition[     72183,       1736]
CellTagsIndexPosition[     72097,       1731]
WindowTitle->dFtotalAdimNvdT
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[GridBox[{
   {GridBox[{
      {
       ItemBox[Cell[BoxData[
         RowBox[{
          TemplateBox[{12},
           "Spacer1"], Cell["NEW EO S ARGON PACKAGE SYMBOL", "PacletNameCell",
           TextAlignment->Center,ExpressionUUID->
           "a03664bb-3e60-4add-a1e3-e793c4cd6efa"], 
          TemplateBox[{8},
           "Spacer1"]}]],
         TextAlignment->Center,ExpressionUUID->
         "755a6976-d735-457a-9458-2787070ab334"],
        Background->RGBColor[0.490196, 0.576471, 0.690196],
        ItemSize->Full], ""}
     },
     GridBoxAlignment->{"Rows" -> {{Center}}},
     GridBoxItemSize->{"Columns" -> {Full, 
         Scaled[0.02]}, "Rows" -> {{2.5}}}], Cell[TextData[{
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "See Also",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "b5131eb4-4408-4015-a17b-593594f86360"]
         }],ExpressionUUID->"e2710f19-a92a-4be3-930d-eabc80b31412"],
         StripOnInput->False],{
        "\"FtotalAdimNv\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/FtotalAdimNv"], 
         "\"StotalAdimNv\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/StotalAdimNv"], 
         "\"UtotalAdimNv\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/UtotalAdimNv"], 
         "\"d2FtotalAdimNvdT2\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/d2FtotalAdimNvdT2"],
          "\"RhoArgonNv\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/RhoArgonNv"]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"SeeAlso"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "9039b1dc-d3c8-4fd4-a629-ffaf16fe0577"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "Related Guides",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "86413feb-5252-4bbf-9ce1-ee72f0b9cec0"]
         }],ExpressionUUID->"e600ae75-f30e-4316-b03d-483c4e9c994a"],
         StripOnInput->False],{
        "\"NewEoSArgon Package\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/guide/NewEoSArgon"]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"MoreAbout"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "7d6c867f-0a89-4e89-a31d-6537ddd1c077"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "URL",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "1d64568e-b370-41f7-91e3-1e5adfd6e40b"]
         }],ExpressionUUID->"89205a84-99c2-4aa2-8d9a-daf84aebc863"],
         StripOnInput->False],{
        "\"NewEoSArgon/ref/dFtotalAdimNvdT\"" :> None, 
         "\"Copy Wolfram Documentation Center URL\"" :> 
         Module[{DocumentationSearch`Private`nb$}, 
           DocumentationSearch`Private`nb$ = 
            NotebookPut[
             Notebook[{Cell["NewEoSArgon/ref/dFtotalAdimNvdT"]}, Visible -> 
               False]]; 
           SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
           FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
           NotebookClose[DocumentationSearch`Private`nb$]; Null], Delimiter, 
         "\"Copy web URL\"" :> 
         Module[{DocumentationSearch`Private`nb$}, 
           DocumentationSearch`Private`nb$ = 
            NotebookPut[
             Notebook[{
               Cell[BoxData[
                 MakeBoxes[
                  Hyperlink[
                   "http://reference.wolfram.com/language/NewEoSArgon/ref/\
dFtotalAdimNvdT.html"], StandardForm]], "Input", TextClipboardType -> 
                 "PlainText"]}, Visible -> False]]; 
           SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
           FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
           NotebookClose[DocumentationSearch`Private`nb$]; Null], 
         "\"Go to web URL\"" :> 
         FrontEndExecute[{
           NotebookLocate[{
             URL[If[TrueQ[DocumentationBuild`Make`Private`wsmlinkQ$11994], 
                 "http://reference.wolfram.com/system-modeler/", 
                 "http://reference.wolfram.com/language/"] <> 
               "NewEoSArgon/ref/dFtotalAdimNvdT" <> ".html"], None}]}]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"URLMenu"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "b07b8137-26cb-4d7f-b326-69645ecc86e6"]
    }], "AnchorBar",
     CacheGraphics->False,ExpressionUUID->
     "1364e225-2b12-4d64-81df-c03604cdcf6e"]}
  }]], "AnchorBarGrid",
 CellID->1,ExpressionUUID->"d5adc3b0-9240-4504-ad26-a1bda82b72ba"],

Cell["NewEoSArgon`", "ContextNameCell",ExpressionUUID->"2a68458d-fdfb-4424-b309-807861ee0eda"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     Cell[
     "dFtotalAdimNvdT", "ObjectName",ExpressionUUID->
      "3bd733cf-41ef-47af-8426-b92bf25365fb"],
     Cell[BoxData[
      TemplateBox[{8},
       "Spacer1"]],ExpressionUUID->"cd4520c1-e43d-4070-9b81-b226ec17be6d"],
     Cell[BoxData[
     ""], "ObjectNameTranslation",ExpressionUUID->
      "7172b9b5-3b78-406a-b865-f15d44223298"]
    }],ExpressionUUID->"3eeddf2d-3411-497c-83ae-fad15631940d"], 
    "\[SpanFromLeft]"}
  }]], "ObjectNameGrid",ExpressionUUID->"0031efcb-71f5-4527-8772-\
9adb75ece24c"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     "dFtotalAdimNvdT[",
     StyleBox["T",
      FontSlant->"Italic"],
     ", \[Rho]] \[Congruent] ",
     Cell[BoxData[
      SubscriptBox[
       RowBox[{"(", 
        FractionBox[
         RowBox[{"\[PartialD]", 
          StyleBox["a",
           FontSlant->"Italic"]}], 
         RowBox[{"\[PartialD]", 
          StyleBox["T",
           FontSlant->"Italic"]}]], ")"}], 
       StyleBox["V",
        FontSlant->"Italic"]]], "InlineFormula",
      FontFamily->"Source Sans Pro",ExpressionUUID->
      "a996edb6-e5ea-437c-82d5-908fdeec9a03"],
     " = -",
     Cell[BoxData[
      RowBox[{
       RowBox[{
        FractionBox["1", 
         StyleBox["T",
          FontSlant->"Italic"]], 
        RowBox[{"(", 
         RowBox[{
          StyleBox["a",
           FontSlant->"Italic"], " ", "+", " ", 
          FractionBox[
           StyleBox["S",
            FontSlant->"Italic"], 
           StyleBox["R",
            FontSlant->"Italic"]]}], ")"}]}], "=", " ", 
       RowBox[{"-", 
        FractionBox[
         StyleBox["U",
          FontSlant->"Italic"], 
         SuperscriptBox[
          StyleBox["RT",
           FontSlant->"Italic"], "2"]]}]}]], "InlineFormula",
      FontFamily->"Source Sans Pro",ExpressionUUID->
      "38f5774d-d420-4073-a082-d894664b9956"],
     " (",
     Cell[BoxData[
      SuperscriptBox["K", 
       RowBox[{"-", "1"}]]], "InlineFormula",
      FontFamily->"Source Sans Pro",ExpressionUUID->
      "b9da42d1-9795-4689-bc58-3180035fdc52"],
     ")\nD\[EAcute]riv\[EAcute]e partielle premi\[EGrave]re par rapport \
\[AGrave] ",
     StyleBox["T",
      FontSlant->"Italic"],
     " de l'\[EAcute]nergie libre adimensionnelle ",
     StyleBox["a",
      FontSlant->"Italic"],
     " = ",
     StyleBox["F",
      FontSlant->"Italic"],
     "/",
     StyleBox["RT ",
      FontSlant->"Italic"],
     "en fonction de ",
     StyleBox["T",
      FontSlant->"Italic"],
     " (Kelvin) et de \[Rho] (g/",
     Cell[BoxData[
      SuperscriptBox["cm", "3"]], "InlineFormula",
      FontFamily->"Source Sans Pro",ExpressionUUID->
      "bbd0e106-7273-4ea0-b267-c55e3bdac2f9"],
     ")\n[First derivative with temperature of non-dimensionnal free energy ",
     StyleBox["a",
      FontSlant->"Italic"],
     " = ",
     StyleBox["F",
      FontSlant->"Italic"],
     "/",
     StyleBox["RT",
      FontSlant->"Italic"],
     " versus ",
     StyleBox["T",
      FontSlant->"Italic"],
     " (Kelvin) and \[Rho] (g/",
     Cell[BoxData[
      SuperscriptBox["cm", "3"]], "InlineFormula",
      FontFamily->"Source Sans Pro",ExpressionUUID->
      "78d2a1af-0b1f-4722-bd19-a9b86dfba4c0"],
     ")]"
    }],ExpressionUUID->"d4a2ad98-33c8-4d3a-9023-507ad0e0169c"]}
  }]], "Usage",ExpressionUUID->"2aff678c-bacf-4039-ac16-d592115c3a88"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[Cell[TextData[{
   Cell[BoxData[
    DynamicBox[ToBoxes[
      If[
       MatchQ[
        CurrentValue[
         EvaluationNotebook[], {TaggingRules, "Openers", "NotesSection"}, 
         Closed], 
        Alternatives[Open, True]], 
       Style[
        Graphics[{
          Thickness[0.18], 
          RGBColor[0.8509803921568627, 0.396078431372549, 0], 
          Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
         PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
        0.68 Inherited], 
       Rotate[
        Style[
         Graphics[{
           Thickness[0.18], 
           RGBColor[0.8509803921568627, 0.396078431372549, 0], 
           Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
          PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
         0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
     ImageSizeCache->{
      13.600000000000001`, {0.5800000000000001, 13.020000000000001`}}]],
    ExpressionUUID->"a86869cc-01ac-414b-8d87-eb16aba1a04e"],
   Cell[BoxData[
    TemplateBox[{1},
     "Spacer1"]],ExpressionUUID->"8e7f86ec-18d5-4645-b84a-5903051430c8"],
   "Details and Options"
  }], "NotesFrameText",ExpressionUUID->"1c4dd37d-1782-4596-b937-7a52d55d2a0d"],
  Appearance->{Automatic, None, "Normal", Automatic},
  BaseStyle->None,
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"], 
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], After, CellContents]}]& ),
  Evaluator->None,
  Method->
   "Preemptive"]],ExpressionUUID->"4059d434-eb77-4e44-84fa-27afb452090e"]], \
"NotesSection",
 WholeCellGroupOpener->True,
 CellGroupingRules->{"SectionGrouping", 50},
 CacheGraphics->False,
 CellID->174751640,ExpressionUUID->"d9bad81c-78ac-46ab-b1e5-6e015e504a5b"],

Cell[TextData[{
 "La fonction est d\[EAcute]finie pour ",
 StyleBox["T",
  FontSlant->"Italic"],
 " > 0 et \[Rho] \[GreaterEqual] 0"
}], "Notes",
 CellID->1067943069,ExpressionUUID->"e796c3b8-0735-4dc5-ad1e-b500aeef6bfd"],

Cell["\<\
******************************************************************************\
*****\
\>", "Notes",
 CellID->185021568,ExpressionUUID->"bc6e6be9-e3a0-4f42-89f6-b0509e122c44"],

Cell[TextData[{
 "The function is defined for ",
 StyleBox["T",
  FontSlant->"Italic"],
 " >0 and \[Rho] \[GreaterEqual] 0."
}], "Notes",
 CellID->175218415,ExpressionUUID->"857d8369-99df-41dd-baed-d95097935d58"]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "NotesSection"}, Closed]]]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {
       TaggingRules, "Openers", "PrimaryExamplesSection"}, Open], 
      Alternatives[True, Open]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{13.600000000000001`, {5., 8.600000000000001}}]],
  ExpressionUUID->"12811fc3-313a-484e-a38a-d8a666b2c431"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"e0ed5afb-a846-4182-ab88-46fe2a32c63d"],
 "Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount",ExpressionUUID->
  "50bf4175-1ec8-4ddb-8b53-877f79269ae2"]
}], "PrimaryExamplesSection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellTags->"PrimaryExamplesSection",
 CellID->112647223,ExpressionUUID->"a2ddd6f6-def3-41f1-a487-9bfa28bba695"],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"},
        Closed], 
      Alternatives[Open, True]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{13.600000000000001`, {5., 8.600000000000001}}]],
  ExpressionUUID->"a9f343ae-f5f4-445f-aa04-29a24ddea727"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"f2f3cfdb-4981-40d3-b6d2-21bdb7e47c8c"],
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "ae5a70bd-edf7-42e7-89b3-0431577ace77"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellID->748424143,ExpressionUUID->"423aad2e-0b62-41a2-8f00-00faf7b50209"],

Cell[BoxData[{
 RowBox[{"Needs", "[", "\"\<NewEoSArgon`\>\"", "]"}], "\[IndentingNewLine]", 
 RowBox[{"Off", "[", 
  RowBox[{"General", "::", "munfl"}], "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->143015886,ExpressionUUID->"9c6126c2-49e9-434d-b05d-ba2bd809b531"],

Cell[TextData[{
 "Calculated value of ",
 Cell[BoxData[
  SubscriptBox[
   RowBox[{"(", 
    FractionBox[
     RowBox[{"\[PartialD]", 
      StyleBox["a",
       FontSlant->"Italic"]}], 
     RowBox[{"\[PartialD]", 
      StyleBox["T",
       FontSlant->"Italic"]}]], ")"}], 
   StyleBox["V",
    FontSlant->"Italic"]]], "InlineFormula",
  FontFamily->"Source Sans Pro",ExpressionUUID->
  "dbb75108-d67c-4375-8361-1a8f5657d747"],
 " for atmospheric pressure and 20\[Degree]C"
}], "ExampleText",
 CellID->544149791,ExpressionUUID->"eebf35e7-b6bd-44e4-b989-b9f1d0d4c644"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Quantity", "[", 
  RowBox[{
   RowBox[{"dFtotalAdimNvdT", "[", 
    RowBox[{"293.15", ",", 
     RowBox[{"RhoArgonNv", "[", 
      RowBox[{"293.15", ",", 
       RowBox[{"QuantityMagnitude", "@", 
        RowBox[{"N", "@", 
         RowBox[{"UnitConvert", "[", 
          RowBox[{
           TemplateBox[{"1"},
            "QuantityUnit",
            DisplayFunction->(TooltipBox[
              StyleBox[
               RowBox[{#, "\[InvisibleSpace]", 
                 StyleBox[
                  RowBox[{" ", "\"atm\""}], "QuantityUnitTraditionalLabel"]}],
                ShowStringCharacters -> False], "Unit: atmospheres"]& ),
            InterpretationFunction->(RowBox[{"Quantity", "[", 
               RowBox[{#, ",", "\"Atmospheres\""}], "]"}]& )], ",", 
           "\"\<Bars\>\""}], "]"}]}]}], ",", "\"\<G\>\""}], "]"}]}], "]"}], 
   ",", 
   RowBox[{"1", "/", "\"\<Kelvins\>\""}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->5710145,ExpressionUUID->"34562558-9186-4b6f-a6ad-bfa11020b453"],

Cell[BoxData[
 TemplateBox[{
   RowBox[{"-", "0.00510720957946778`"}], 
   RowBox[{"\"/\"", "\[InvisibleSpace]", "\"K\""}], "reciprocal kelvins", 
   FractionBox["1", "\"Kelvins\""]},
  "Quantity"]], "Output",
 CellLabel->"Out[2]=",
 CellID->747090223,ExpressionUUID->"6d627cdd-ec87-4af1-a2d8-e38c9406abbf"]
}, Open  ]],

Cell[TextData[{
 "Verification of formula ",
 Cell[BoxData[
  SubscriptBox[
   RowBox[{"(", 
    FractionBox[
     RowBox[{"\[PartialD]", 
      StyleBox["a",
       FontSlant->"Italic"]}], 
     RowBox[{"\[PartialD]", 
      StyleBox["T",
       FontSlant->"Italic"]}]], ")"}], 
   StyleBox["V",
    FontSlant->"Italic"]]],ExpressionUUID->
  "cf159a8d-af73-4442-aa78-028f9f33a2f5"],
 "=",
 Cell[BoxData[
  RowBox[{"-", 
   FractionBox[
    StyleBox["U",
     FontSlant->"Italic"], 
    SuperscriptBox[
     StyleBox["RT",
      FontSlant->"Italic"], "2"]]}]],ExpressionUUID->
  "ef849b10-6938-41a0-9803-8ce1f60e7bbb"]
}], "ExampleText",
 CellID->75491617,ExpressionUUID->"17fbe9c7-31b0-44de-b42f-bbb818713dcc"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Quantity", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     RowBox[{"UtotalAdimNv", "[", 
      RowBox[{"293.15", ",", 
       RowBox[{"RhoArgonNv", "[", 
        RowBox[{"293.15", ",", 
         RowBox[{"QuantityMagnitude", "@", 
          RowBox[{"N", "@", 
           RowBox[{"UnitConvert", "[", 
            RowBox[{
             TemplateBox[{"1"},
              "QuantityUnit",
              DisplayFunction->(TooltipBox[
                StyleBox[
                 RowBox[{#, "\[InvisibleSpace]", 
                   StyleBox[
                    RowBox[{" ", "\"atm\""}], 
                    "QuantityUnitTraditionalLabel"]}], ShowStringCharacters -> 
                 False], "Unit: atmospheres"]& ),
              InterpretationFunction->(RowBox[{"Quantity", "[", 
                 RowBox[{#, ",", "\"Atmospheres\""}], "]"}]& )], ",", 
             "\"\<Bars\>\""}], "]"}]}]}], ",", "\"\<G\>\""}], "]"}]}], 
      "]"}]}], "/", "293.15"}], ",", 
   RowBox[{"1", "/", "\"\<Kelvins\>\""}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->311444489,ExpressionUUID->"4c8cd4a4-613b-491d-9fdf-414513c9eb0d"],

Cell[BoxData[
 TemplateBox[{
   RowBox[{"-", "0.005107209579467779`"}], 
   RowBox[{"\"/\"", "\[InvisibleSpace]", "\"K\""}], "reciprocal kelvins", 
   FractionBox["1", "\"Kelvins\""]},
  "Quantity"]], "Output",
 CellLabel->"Out[3]=",
 CellID->31771702,ExpressionUUID->"e9449fdb-2f57-4a71-a8cf-464754489e2c"]
}, Open  ]],

Cell["\<\
First derivative of free energy on the saturation curve from NIST\
\>", "ExampleText",
 CellID->286706321,ExpressionUUID->"b6dc2b7b-33af-4069-a569-52b209661337"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"dFtotalAdimNvdT", "[", 
     RowBox[{
      RowBox[{"TSatNIST", "[", "\[Rho]", "]"}], ",", "\[Rho]"}], "]"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"\[Rho]", ",", "\[Rho]trgaz", ",", "\[Rho]trliq"}], "}"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", "Red", "}"}]}], ",", 
   RowBox[{"AxesOrigin", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\[Rho]c", ",", "Automatic"}], "}"}]}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "\"\<\[Rho] (g/\!\(\*SuperscriptBox[\(cm\), \(3\)]\))\>\"", ",", 
      "\"\<(\!\(\*FractionBox[RowBox[{\"\[PartialD]\", \
StyleBox[\"a\",FontSlant->\"Italic\"]}], RowBox[{\"\[PartialD]\", \
StyleBox[\"T\",FontSlant->\"Italic\"]}]]\)\!\(\*SubscriptBox[\")\", StyleBox[\
\"V\",FontSlant->\"Italic\"]]\) (\!\(\*SuperscriptBox[\(K\), \
\(-1\)]\))\>\""}], "}"}]}], ",", 
   RowBox[{"ImageSize", "\[Rule]", "450"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->605199954,ExpressionUUID->"9f38ff0a-b204-4c6f-91fc-6fdaefd79678"],

Cell[BoxData[
 GraphicsBox[
  InterpretationBox[{
    TagBox[{{{}, {}, 
       TagBox[
        {RGBColor[1, 0, 0], AbsoluteThickness[2], Opacity[1.], 
         LineBox[CompressedData["
1:eJwVlGk41XkDhvFWUpIh08JkGSoRqZOIt4csiVKmFGJSqsEwWbPr2PccS4rI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          "]]},
        Annotation[#, "Charting`Private`Tag#1"]& ]}, {}},
     {"WolframDynamicHighlight", <|
      "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>}], 
    DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
      Slot["HighlightElements"], 
      Slot["LayoutOptions"], 
      Slot["Meta"], 
      Charting`HighlightActionFunction["DynamicHighlight", {{{{}, {}, 
          Annotation[{
            Directive[
             Opacity[1.], 
             AbsoluteThickness[2], 
             RGBColor[1, 0, 0]], 
            Line[CompressedData["
1:eJwVlGk41XkDhvFWUpIh08JkGSoRqZOIt4csiVKmFGJSqsEwWbPr2PccS4rI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             "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
       "HighlightElements" -> <|
         "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
        "LayoutOptions" -> <|
         "PlotRange" -> {{0.0040546000061275735`, 
           1.4168017335853793`}, {-0.017270341686495317`, 
           0.08307893092301027}}, "Frame" -> {{True, True}, {True, True}}, 
          "AxesOrigin" -> {0.535599, 0}, 
          "ImageSize" -> {450, 450/GoldenRatio}, "Axes" -> {True, True}, 
          "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
          "DefaultStyle" -> {
            Directive[
             Opacity[1.], 
             AbsoluteThickness[2], 
             RGBColor[1, 0, 0]]}, 
          "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
              Identity[
               Part[#, 1]], 
              Identity[
               Part[#, 2]]}& ), 
            "ScalingFunctions" -> {{Identity, Identity}, {
              Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>,
         "Meta" -> <|
         "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
          Plot, "GroupHighlight" -> False|>|>]]& )[<|
      "HighlightElements" -> <|
        "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
       "LayoutOptions" -> <|
        "PlotRange" -> {{0.0040546000061275735`, 
          1.4168017335853793`}, {-0.017270341686495317`, 
          0.08307893092301027}}, "Frame" -> {{True, True}, {True, True}}, 
         "AxesOrigin" -> {0.535599, 0}, "ImageSize" -> {450, 450/GoldenRatio},
          "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
         GoldenRatio^(-1), "DefaultStyle" -> {
           Directive[
            Opacity[1.], 
            AbsoluteThickness[2], 
            RGBColor[1, 0, 0]]}, 
         "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
             Identity[
              Part[#, 1]], 
             Identity[
              Part[#, 2]]}& ), 
           "ScalingFunctions" -> {{Identity, Identity}, {
             Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>, 
       "Meta" -> <|
        "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
         Plot, "GroupHighlight" -> False|>|>],
     ImageSizeCache->{{4.503599627370496*^15, -4.503599627370496*^15}, {
      4.503599627370496*^15, -4.503599627370496*^15}}]},
   Annotation[{{{{}, {}, 
       Annotation[{
         Directive[
          Opacity[1.], 
          AbsoluteThickness[2], 
          RGBColor[1, 0, 0]], 
         Line[CompressedData["
1:eJwVlGk41XkDhvFWUpIh08JkGSoRqZOIt4csiVKmFGJSqsEwWbPr2PccS4rI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          "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
    "HighlightElements" -> <|
      "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
     "LayoutOptions" -> <|
      "PlotRange" -> {{0.0040546000061275735`, 
        1.4168017335853793`}, {-0.017270341686495317`, 0.08307893092301027}}, 
       "Frame" -> {{True, True}, {True, True}}, "AxesOrigin" -> {0.535599, 0},
        "ImageSize" -> {450, 450/GoldenRatio}, "Axes" -> {True, True}, 
       "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), "DefaultStyle" -> {
         Directive[
          Opacity[1.], 
          AbsoluteThickness[2], 
          RGBColor[1, 0, 0]]}, 
       "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
           Identity[
            Part[#, 1]], 
           Identity[
            Part[#, 2]]}& ), 
         "ScalingFunctions" -> {{Identity, Identity}, {Identity, Identity}}|>,
        "Primitives" -> {}, "GCFlag" -> False|>, 
     "Meta" -> <|
      "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
       Plot, "GroupHighlight" -> False|>|>, "DynamicHighlight"]],
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0.535599, 0},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{
     FormBox[
      TagBox[
      "\"(\\!\\(\\*FractionBox[RowBox[{\\\"\[PartialD]\\\", \
StyleBox[\\\"a\\\",FontSlant->\\\"Italic\\\"]}], RowBox[{\\\"\[PartialD]\\\", \
StyleBox[\\\"T\\\",FontSlant->\\\"Italic\\\"]}]]\\)\\!\\(\\*SubscriptBox[\\\")\
\\\", StyleBox[\\\"V\\\",FontSlant->\\\"Italic\\\"]]\\) \
(\\!\\(\\*SuperscriptBox[\\(K\\), \\(-1\\)]\\))\"", HoldForm], 
      TraditionalForm], None}, {
     FormBox[
      TagBox[
      "\"\[Rho] (g/\\!\\(\\*SuperscriptBox[\\(cm\\), \\(3\\)]\\))\"", 
       HoldForm], TraditionalForm], None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  ImageSize->450,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0.0040546000061275735`, 
   1.4168017335853793`}, {-0.017270341686495317`, 0.08307893092301027}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellLabel->"Out[4]=",
 CellID->436341296,ExpressionUUID->"f171a0c7-0662-4c61-9f93-a47d52dd898f"]
}, Open  ]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"}, 
  Closed]]]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "2"},
        Closed], 
      Alternatives[Open, True]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{
    13.600000000000001`, {0.5800000000000001, 13.020000000000001`}}]],
  ExpressionUUID->"52238375-baf2-45ad-9ad9-a148d480515a"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"d1da39f8-e338-44d4-83c3-4f566dd3396c"],
 "Applications",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "de6ef5c2-2230-49c3-871c-2f1b8e428caa"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellID->258228157,ExpressionUUID->"c6d9089b-43bb-42cd-957a-d996f9807c82"],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<NewEoSArgon`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->87419684,ExpressionUUID->"3cf1b70a-3be4-4c2d-9177-5d67a8823118"],

Cell[TextData[{
 "Comparison with ",
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["NIST data"]], "http://webbook.nist.gov/chemistry/fluid/"},
   "WebLink",
   BaseStyle->{"ExampleText"}]],ExpressionUUID->
  "9721d520-196f-4f7a-8ff4-627914e19661"],
 " on an isotherm close to the critical isotherm"
}], "ExampleText",
 CellID->227520913,ExpressionUUID->"0d60131a-2cad-4f61-b5ad-f6cdd9decc83"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"datafile", "=", 
   RowBox[{"FileNameJoin", "[", 
    RowBox[{"{", 
     RowBox[{
     "\"\<NewEoSArgon\>\"", ",", "\"\<DataFiles\>\"", ",", 
      "\"\<DataCritNIST.dat\>\""}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dataNIST", "=", 
   RowBox[{"Import", "[", "datafile", "]"}]}], ";"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->531122037,ExpressionUUID->"629f6e56-3fda-49c3-a493-234b2296b882"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ArT150p7Fp", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"dataNIST", "[", 
        RowBox[{"[", 
         RowBox[{"i", ",", "3"}], "]"}], "]"}], ",", 
       RowBox[{
        RowBox[{"-", 
         RowBox[{"dataNIST", "[", 
          RowBox[{"[", 
           RowBox[{"i", ",", "5"}], "]"}], "]"}]}], "*", 
        RowBox[{"1000", "/", 
         RowBox[{"(", 
          RowBox[{"RR", "*", 
           SuperscriptBox[
            RowBox[{"dataNIST", "[", 
             RowBox[{"[", 
              RowBox[{"i", ",", "1"}], "]"}], "]"}], "2"]}], ")"}]}]}]}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "2", ",", "51"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Legended", "[", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"dFtotalAdimNvdT", "[", 
      RowBox[{"150.7", ",", "x"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0.0000319`", ",", "1.6046`"}], "}"}], ",", 
     RowBox[{"AxesOrigin", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\[Rho]c", ",", "Automatic"}], "}"}]}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
     RowBox[{"Frame", "\[Rule]", "True"}], ",", 
     RowBox[{"FrameLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
       "\"\<\[Rho] (g/\!\(\*SuperscriptBox[\(cm\), \(3\)]\))\>\"", ",", 
        "\"\<(\!\(\*FractionBox[RowBox[{\"\[PartialD]\", \
StyleBox[\"a\",FontSlant->\"Italic\"]}], RowBox[{\"\[PartialD]\", \
StyleBox[\"T\",FontSlant->\"Italic\"]}]]\)\!\(\*SubscriptBox[\")\", StyleBox[\
\"V\",FontSlant->\"Italic\"]]\) (\!\(\*SuperscriptBox[\(K\), \(-1\)]\))\>\"", 
        ",", "\"\<ISOTHERM 150.7 K\>\""}], "}"}]}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", "Red", "}"}]}], ",", 
     RowBox[{"Epilog", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"PointSize", "\[Rule]", "Medium"}], ",", 
        RowBox[{"Map", "[", 
         RowBox[{"Point", ",", "ArT150p7Fp"}], "]"}]}], "}"}]}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "450"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Placed", "[", 
      RowBox[{
       RowBox[{"PointLegend", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"Directive", "[", 
           RowBox[{"Black", ",", 
            RowBox[{"AbsolutePointSize", "[", "6", "]"}]}], "]"}], "}"}], ",", 
         RowBox[{"{", "\"\<NIST database\>\"", "}"}]}], "]"}], ",", "Below"}],
       "]"}], ",", 
     RowBox[{"Placed", "[", 
      RowBox[{
       RowBox[{"LineLegend", "[", 
        RowBox[{
         RowBox[{"{", "Red", "}"}], ",", 
         RowBox[{
         "{", "\"\<dFtotalAdimNvdT[\!\(\*StyleBox[\"T\",FontSlant->\"Italic\"]\
\),\[Rho]]\>\"", "}"}]}], "]"}], ",", "Below"}], "]"}]}], "}"}]}], 
  "]"}]}], "Input",
 CellLabel->"In[3]:=",
 CellID->136921489,ExpressionUUID->"873fd569-037b-4a40-b7e1-f2a0dfcc17ff"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[
    InterpretationBox[{
      TagBox[{{{{}, {}, 
          TagBox[{
            Directive[
             Opacity[1.], 
             AbsoluteThickness[2], 
             RGBColor[1, 0, 0]], 
            LineBox[CompressedData["
1:eJwVi2k0lAsAhofcspSoSEXllC1C29WiXiNZpkVKHeGGsSXZcmUXZpKkIl9I
SLIWtynSpeWzTFkay7Ukl0RJ04w1Yr6irvvjOe95znseVabPEVdxGo12dI7/
t3BHY9PYcxq8pZsiExzYZHQA026hDh27+wXB+TZs8rHMULty3mHYhvbbNlix
yaY3HHk1Z0eUG0gUz+xlk3aGS/UL6b6QqoxR1dVkk6o+JhDqR6KC4AXuHmOR
bMl3pvGaCfgSJzOrE8kifz9W2GC/PgvXpVQ8fmRFk8JUveqPzRwEME5Xl1RF
kl4Fnissqb/h5hIqz1kYQRrTXX71hlWCbdgnNlUcQs48+8D71MbFB0GGgZFs
IGlZn5hS21eHym4+m/PYn7QakHseZNKIuoHNwTWqvqTl5pb2jvoW8Dt+lJvb
eZBVOzn19rxWSHPDpcaknMk4hshz//d2pBvEuNMe2ZBZ2W/jNeZ14q1S2naJ
5Rak3UZ6IlesCzTLaueGrsWkFym/t167G5EsadM7mqbg3Qzxf6r/DnUznjMn
uo4hOnS/lYLTe/Tcqo4P9nXEiNkRqdSaPli3xS9+H+4K4ymGljK3Hzx1g5lM
vgfoBdNrrP/9gNLhln1MX2+4RYx1iPd+hJxu6zU1uh8MbDKYrtMDiK03LR72
9ofdflmnAplB6D8UdoSnBCCX+Xo1c9FnuDWM6/3MCcStcMOS5vV8HIjomtQb
CsaTZ9T8Uq0vaDWLmtq4MgxqCqG8IC0BuC8cTy9jRAB+nFPje4RoNk2Z/94u
EufHN3H76ENYGDjPzI0dBc8A9ymW7TAckn/b6MiLRuESp7QF3iPIO+z82nYZ
G7LtebNiPqP4xWjMbWVcQMKBllVvjcegVXSzIuB2DHTo/qkC7hjObN8mVOy7
CD9j0UEvk3EwFUsf1K+6hPh9nSP1TeNw5pufvXw2DhW29qP9ll+Rvlt1dN3D
y3jht6u7rfsrPjf6fr644Ao60irVo05OQGxnyi6e8VXcaNG4n9k7gV05r8yU
zl6DtuSXlckekzgeXL3J7kQC2q0OC8yFkwjKbmtTFSTgaIZ8bkfgNzScecDj
RCYi9FtpaqvYFMyV/ZwkFl1HmcNPYVz0FP4akS8zir2O2td3NqjITiPaZouV
j0QShBbCutMJ04i7UNUT6Z2E8nbFLE05EayjDmQd5CXB3imdWZkmwqFh/pp0
NQKdi9UevEwXoUesLLxZncCRF8U/GjJFGFz+SVFck4D5KpLoyBZBxT74u8sG
Als6+l8J7omw2U14XlWPgLSFhrbCUxHqzGItA7YTeKL/aMKjWwR1d/7JGAaB
JbQ69lJlCgKezTb6GQK6Udzv1qspxJ3rtHHwIsAQr/JNXktBY37Vn2HeBFgS
FfYr1CgIra4QJb4EJiWLtq7RpdCjouSpEEDgjXzCwAYjCnITLJ38cAJp62xM
jF0o3LU4Xku7SqAsx7qC5UbhnOVR29k5b1Wz0n95aq5PSeoWXSMgo8lQNvei
MKSQnj+USCBMx3Dy4DkK3Efif9TeIHBy29qcE7EUNPli0+YZBELKlFfeiqPg
SE8x35pJINlgRUJPPIXeZG/W6tsEmncsCXNIpND0T07JaBYBoz0S1q5pFLIW
RHxj5xCwJ2kNeekUlOz9Yt1zCQQZzYKfOfef0ha3yCPAMZ7S9rxLoUTzSYFk
AQFezdc7RbkUVGoE7YNzzjcZXT6ST0H6Y8FgTSEBiVfCK3r3KATdzX53+x4B
VTP+PL8iCof0LpWH3CfwH9hmlXc=
             "]]}, Annotation[#, "Charting`Private`Tag#1"]& ]}}, {}}, {
       "WolframDynamicHighlight", <|
        "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>}], 
      DynamicBox[
       (Charting`HighlightActionBox["DynamicHighlight", {}, 
        Slot["HighlightElements"], 
        Slot["LayoutOptions"], 
        Slot["Meta"], 
        Charting`HighlightActionFunction["DynamicHighlight", {{{{}, {}, 
            Annotation[{
              Directive[
               Opacity[1.], 
               AbsoluteThickness[2], 
               RGBColor[1, 0, 0]], 
              Line[CompressedData["
1:eJwVi2k0lAsAhofcspSoSEXllC1C29WiXiNZpkVKHeGGsSXZcmUXZpKkIl9I
SLIWtynSpeWzTFkay7Ukl0RJ04w1Yr6irvvjOe95znseVabPEVdxGo12dI7/
t3BHY9PYcxq8pZsiExzYZHQA026hDh27+wXB+TZs8rHMULty3mHYhvbbNlix
yaY3HHk1Z0eUG0gUz+xlk3aGS/UL6b6QqoxR1dVkk6o+JhDqR6KC4AXuHmOR
bMl3pvGaCfgSJzOrE8kifz9W2GC/PgvXpVQ8fmRFk8JUveqPzRwEME5Xl1RF
kl4Fnissqb/h5hIqz1kYQRrTXX71hlWCbdgnNlUcQs48+8D71MbFB0GGgZFs
IGlZn5hS21eHym4+m/PYn7QakHseZNKIuoHNwTWqvqTl5pb2jvoW8Dt+lJvb
eZBVOzn19rxWSHPDpcaknMk4hshz//d2pBvEuNMe2ZBZ2W/jNeZ14q1S2naJ
5Rak3UZ6IlesCzTLaueGrsWkFym/t167G5EsadM7mqbg3Qzxf6r/DnUznjMn
uo4hOnS/lYLTe/Tcqo4P9nXEiNkRqdSaPli3xS9+H+4K4ymGljK3Hzx1g5lM
vgfoBdNrrP/9gNLhln1MX2+4RYx1iPd+hJxu6zU1uh8MbDKYrtMDiK03LR72
9ofdflmnAplB6D8UdoSnBCCX+Xo1c9FnuDWM6/3MCcStcMOS5vV8HIjomtQb
CsaTZ9T8Uq0vaDWLmtq4MgxqCqG8IC0BuC8cTy9jRAB+nFPje4RoNk2Z/94u
EufHN3H76ENYGDjPzI0dBc8A9ymW7TAckn/b6MiLRuESp7QF3iPIO+z82nYZ
G7LtebNiPqP4xWjMbWVcQMKBllVvjcegVXSzIuB2DHTo/qkC7hjObN8mVOy7
CD9j0UEvk3EwFUsf1K+6hPh9nSP1TeNw5pufvXw2DhW29qP9ll+Rvlt1dN3D
y3jht6u7rfsrPjf6fr644Ao60irVo05OQGxnyi6e8VXcaNG4n9k7gV05r8yU
zl6DtuSXlckekzgeXL3J7kQC2q0OC8yFkwjKbmtTFSTgaIZ8bkfgNzScecDj
RCYi9FtpaqvYFMyV/ZwkFl1HmcNPYVz0FP4akS8zir2O2td3NqjITiPaZouV
j0QShBbCutMJ04i7UNUT6Z2E8nbFLE05EayjDmQd5CXB3imdWZkmwqFh/pp0
NQKdi9UevEwXoUesLLxZncCRF8U/GjJFGFz+SVFck4D5KpLoyBZBxT74u8sG
Als6+l8J7omw2U14XlWPgLSFhrbCUxHqzGItA7YTeKL/aMKjWwR1d/7JGAaB
JbQ69lJlCgKezTb6GQK6Udzv1qspxJ3rtHHwIsAQr/JNXktBY37Vn2HeBFgS
FfYr1CgIra4QJb4EJiWLtq7RpdCjouSpEEDgjXzCwAYjCnITLJ38cAJp62xM
jF0o3LU4Xku7SqAsx7qC5UbhnOVR29k5b1Wz0n95aq5PSeoWXSMgo8lQNvei
MKSQnj+USCBMx3Dy4DkK3Efif9TeIHBy29qcE7EUNPli0+YZBELKlFfeiqPg
SE8x35pJINlgRUJPPIXeZG/W6tsEmncsCXNIpND0T07JaBYBoz0S1q5pFLIW
RHxj5xCwJ2kNeekUlOz9Yt1zCQQZzYKfOfef0ha3yCPAMZ7S9rxLoUTzSYFk
AQFezdc7RbkUVGoE7YNzzjcZXT6ST0H6Y8FgTSEBiVfCK3r3KATdzX53+x4B
VTP+PL8iCof0LpWH3CfwH9hmlXc=
               "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
         "HighlightElements" -> <|
           "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
          "LayoutOptions" -> <|
           "PlotRange" -> {All, All}, "Frame" -> {{True, True}, {True, True}},
             "AxesOrigin" -> {0.535599, 0}, 
            "ImageSize" -> {450, 450/GoldenRatio}, "Axes" -> {True, True}, 
            "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
            "DefaultStyle" -> {
              Directive[
               Opacity[1.], 
               AbsoluteThickness[2], 
               RGBColor[1, 0, 0]]}, 
            "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
                Identity[
                 Part[#, 1]], 
                Identity[
                 Part[#, 2]]}& ), 
              "ScalingFunctions" -> {{Identity, Identity}, {
                Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
            False|>, 
          "Meta" -> <|
           "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
            Plot, "GroupHighlight" -> False|>|>]]& )[<|
        "HighlightElements" -> <|
          "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
         "LayoutOptions" -> <|
          "PlotRange" -> {All, All}, "Frame" -> {{True, True}, {True, True}}, 
           "AxesOrigin" -> {0.535599, 0}, 
           "ImageSize" -> {450, 450/GoldenRatio}, "Axes" -> {True, True}, 
           "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
           "DefaultStyle" -> {
             Directive[
              Opacity[1.], 
              AbsoluteThickness[2], 
              RGBColor[1, 0, 0]]}, 
           "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
               Identity[
                Part[#, 1]], 
               Identity[
                Part[#, 2]]}& ), 
             "ScalingFunctions" -> {{Identity, Identity}, {
               Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
           False|>, 
         "Meta" -> <|
          "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
           Plot, "GroupHighlight" -> False|>|>]]}, 
     Annotation[{{{{}, {}, 
         Annotation[{
           Directive[
            Opacity[1.], 
            AbsoluteThickness[2], 
            RGBColor[1, 0, 0]], 
           Line[CompressedData["
1:eJwVi2k0lAsAhofcspSoSEXllC1C29WiXiNZpkVKHeGGsSXZcmUXZpKkIl9I
SLIWtynSpeWzTFkay7Ukl0RJ04w1Yr6irvvjOe95znseVabPEVdxGo12dI7/
t3BHY9PYcxq8pZsiExzYZHQA026hDh27+wXB+TZs8rHMULty3mHYhvbbNlix
yaY3HHk1Z0eUG0gUz+xlk3aGS/UL6b6QqoxR1dVkk6o+JhDqR6KC4AXuHmOR
bMl3pvGaCfgSJzOrE8kifz9W2GC/PgvXpVQ8fmRFk8JUveqPzRwEME5Xl1RF
kl4Fnissqb/h5hIqz1kYQRrTXX71hlWCbdgnNlUcQs48+8D71MbFB0GGgZFs
IGlZn5hS21eHym4+m/PYn7QakHseZNKIuoHNwTWqvqTl5pb2jvoW8Dt+lJvb
eZBVOzn19rxWSHPDpcaknMk4hshz//d2pBvEuNMe2ZBZ2W/jNeZ14q1S2naJ
5Rak3UZ6IlesCzTLaueGrsWkFym/t167G5EsadM7mqbg3Qzxf6r/DnUznjMn
uo4hOnS/lYLTe/Tcqo4P9nXEiNkRqdSaPli3xS9+H+4K4ymGljK3Hzx1g5lM
vgfoBdNrrP/9gNLhln1MX2+4RYx1iPd+hJxu6zU1uh8MbDKYrtMDiK03LR72
9ofdflmnAplB6D8UdoSnBCCX+Xo1c9FnuDWM6/3MCcStcMOS5vV8HIjomtQb
CsaTZ9T8Uq0vaDWLmtq4MgxqCqG8IC0BuC8cTy9jRAB+nFPje4RoNk2Z/94u
EufHN3H76ENYGDjPzI0dBc8A9ymW7TAckn/b6MiLRuESp7QF3iPIO+z82nYZ
G7LtebNiPqP4xWjMbWVcQMKBllVvjcegVXSzIuB2DHTo/qkC7hjObN8mVOy7
CD9j0UEvk3EwFUsf1K+6hPh9nSP1TeNw5pufvXw2DhW29qP9ll+Rvlt1dN3D
y3jht6u7rfsrPjf6fr644Ao60irVo05OQGxnyi6e8VXcaNG4n9k7gV05r8yU
zl6DtuSXlckekzgeXL3J7kQC2q0OC8yFkwjKbmtTFSTgaIZ8bkfgNzScecDj
RCYi9FtpaqvYFMyV/ZwkFl1HmcNPYVz0FP4akS8zir2O2td3NqjITiPaZouV
j0QShBbCutMJ04i7UNUT6Z2E8nbFLE05EayjDmQd5CXB3imdWZkmwqFh/pp0
NQKdi9UevEwXoUesLLxZncCRF8U/GjJFGFz+SVFck4D5KpLoyBZBxT74u8sG
Als6+l8J7omw2U14XlWPgLSFhrbCUxHqzGItA7YTeKL/aMKjWwR1d/7JGAaB
JbQ69lJlCgKezTb6GQK6Udzv1qspxJ3rtHHwIsAQr/JNXktBY37Vn2HeBFgS
FfYr1CgIra4QJb4EJiWLtq7RpdCjouSpEEDgjXzCwAYjCnITLJ38cAJp62xM
jF0o3LU4Xku7SqAsx7qC5UbhnOVR29k5b1Wz0n95aq5PSeoWXSMgo8lQNvei
MKSQnj+USCBMx3Dy4DkK3Efif9TeIHBy29qcE7EUNPli0+YZBELKlFfeiqPg
SE8x35pJINlgRUJPPIXeZG/W6tsEmncsCXNIpND0T07JaBYBoz0S1q5pFLIW
RHxj5xCwJ2kNeekUlOz9Yt1zCQQZzYKfOfef0ha3yCPAMZ7S9rxLoUTzSYFk
AQFezdc7RbkUVGoE7YNzzjcZXT6ST0H6Y8FgTSEBiVfCK3r3KATdzX53+x4B
VTP+PL8iCof0LpWH3CfwH9hmlXc=
            "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
      "HighlightElements" -> <|
        "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
       "LayoutOptions" -> <|
        "PlotRange" -> {All, All}, "Frame" -> {{True, True}, {True, True}}, 
         "AxesOrigin" -> {0.535599, 0}, "ImageSize" -> {450, 450/GoldenRatio},
          "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
         GoldenRatio^(-1), "DefaultStyle" -> {
           Directive[
            Opacity[1.], 
            AbsoluteThickness[2], 
            RGBColor[1, 0, 0]]}, 
         "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
             Identity[
              Part[#, 1]], 
             Identity[
              Part[#, 2]]}& ), 
           "ScalingFunctions" -> {{Identity, Identity}, {
             Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>, 
       "Meta" -> <|
        "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
         Plot, "GroupHighlight" -> False|>|>, "DynamicHighlight"]], {
    DisplayFunction -> Identity, DisplayFunction -> Identity, 
     Ticks -> {Automatic, Automatic}, AxesOrigin -> {0.535599, 0}, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     GridLines -> {None, None}, DisplayFunction -> Identity, 
     PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.05], 
        Scaled[0.05]}}, PlotRangeClipping -> True, ImagePadding -> All, 
     DisplayFunction -> Identity, AspectRatio -> 
     NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
     AxesLabel -> {None, None}, AxesOrigin -> {0.535599, 0}, DisplayFunction :> 
     Identity, Epilog -> {PointSize -> Medium, {
        PointBox[{0.0000319, -0.009950399137160802}], 
        PointBox[{0.0000638, -0.009949339964332322}], 
        PointBox[{0.0000957, -0.009948810377918083}], 
        PointBox[{0.00012756, -0.009947751205089601}], 
        PointBox[{0.00015946, -0.009946692032261121}], 
        PointBox[{0.00019137, -0.009946162445846882}], 
        PointBox[{0.00022328, -0.0099451032730184}], 
        PointBox[{0.0002552, -0.009944573686604159}], 
        PointBox[{0.00028711, -0.009943514513775679}], 
        PointBox[{0.00031904, -0.009942455340947199}], 
        PointBox[{0.00063851, -0.009933981958319352}], 
        PointBox[{0.00095842, -0.009924978989277269}], 
        PointBox[{0.0012788, -0.009916505606649424}], 
        PointBox[{0.0015996, -0.009907502637607339}], 
        PointBox[{0.0019208, -0.009899029254979494}], 
        PointBox[{0.0022425, -0.009890026285937409}], 
        PointBox[{0.0025646, -0.009881552903309564}], 
        PointBox[{0.0028872, -0.00987254993426748}], 
        PointBox[{0.0032102, -0.009864076551639636}], 
        PointBox[{0.0064655, -0.009775106034047267}], 
        PointBox[{0.0097676, -0.009685605930040657}], 
        PointBox[{0.013118, -0.009594517066791328}], 
        PointBox[{0.016519, -0.009502369030713517}], 
        PointBox[{0.019972, -0.009408632235392986}], 
        PointBox[{0.023479, -0.009313836267243974}], 
        PointBox[{0.027044, -0.00921745153985224}], 
        PointBox[{0.030667, -0.009120007639632029}], 
        PointBox[{0.034351, -0.009020445393754854}], 
        PointBox[{0.0753, -0.007923142343448973}], 
        PointBox[{0.12749, -0.0065456880800099804`}], 
        PointBox[{0.20492, -0.004551901147678138}], 
        PointBox[{0.71774, 0.005746012594507143}], 
        PointBox[{0.8327, 0.007670529623856355}], 
        PointBox[{0.87947, 0.00850039153497089}], 
        PointBox[{0.91145, 0.009082936590635209}], 
        PointBox[{0.93632, 0.00954261759819578}], 
        PointBox[{0.9569, 0.00992815650776271}], 
        PointBox[{1.0764, 0.012217028990109244`}], 
        PointBox[{1.1436, 0.013514515704997952`}], 
        PointBox[{1.1924, 0.0144444694484039}], 
        PointBox[{1.2313, 0.0151726507679843}], 
        PointBox[{1.2641, 0.015769494656833107`}], 
        PointBox[{1.2925, 0.016273660923189864`}], 
        PointBox[{1.3177, 0.0167079217828669}], 
        PointBox[{1.3405, 0.017087635241877185`}], 
        PointBox[{1.3612, 0.017422863442091287`}], 
        PointBox[{1.4449, 0.01864567847257212}], 
        PointBox[{1.5084, 0.01939980952645029}], 
        PointBox[{1.5603, 0.019876437299266553`}], 
        PointBox[{1.6046, 0.02016612106785599}]}}, 
     Frame -> {{True, True}, {True, True}}, FrameLabel -> {{
        FormBox[
         TagBox[
         "\"(\\!\\(\\*FractionBox[RowBox[{\\\"\[PartialD]\\\", StyleBox[\\\"a\
\\\",FontSlant->\\\"Italic\\\"]}], RowBox[{\\\"\[PartialD]\\\", \
StyleBox[\\\"T\\\",FontSlant->\\\"Italic\\\"]}]]\\)\\!\\(\\*SubscriptBox[\\\")\
\\\", StyleBox[\\\"V\\\",FontSlant->\\\"Italic\\\"]]\\) \
(\\!\\(\\*SuperscriptBox[\\(K\\), \\(-1\\)]\\))\"", HoldForm], 
         TraditionalForm], None}, {
        FormBox[
         TagBox[
         "\"\[Rho] (g/\\!\\(\\*SuperscriptBox[\\(cm\\), \\(3\\)]\\))\"", 
          HoldForm], TraditionalForm], 
        FormBox[
         TagBox["\"ISOTHERM 150.7 K\"", HoldForm], TraditionalForm]}}, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     GridLines -> {None, None}, GridLinesStyle -> Directive[
       GrayLevel[0.5, 0.4]], ImageSize -> 450, 
     Method -> {
      "DefaultBoundaryStyle" -> Automatic, 
       "DefaultGraphicsInteraction" -> {
        "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
         "Effects" -> {
          "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
           "Droplines" -> {
            "freeformCursorMode" -> True, 
             "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
       "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> None,
        "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
           (Identity[#]& )[
            Part[#, 1]], 
           (Identity[#]& )[
            Part[#, 2]]}& ), "CopiedValueFunction" -> ({
           (Identity[#]& )[
            Part[#, 1]], 
           (Identity[#]& )[
            Part[#, 2]]}& )}}, PlotRange -> {All, All}, PlotRangeClipping -> 
     True, PlotRangePadding -> {{Automatic, Automatic}, {
       Automatic, Automatic}}, Ticks -> {Automatic, Automatic}}], 
   FormBox[
    TemplateBox[{"\[ThinSpace]", "\" \"", 
      FormBox[
       TemplateBox[{"\"NIST database\""}, "PointLegend", 
        DisplayFunction -> (FormBox[
          StyleBox[
           StyleBox[
            PaneBox[
             TagBox[
              GridBox[{{
                 TagBox[
                  GridBox[{{
                    GraphicsBox[{{}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    GrayLevel[0], 
                    AbsolutePointSize[6]], {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    GrayLevel[0], 
                    AbsolutePointSize[6]], 
                    PointBox[
                    NCache[{
                    Scaled[{
                    Rational[1, 2], 
                    Rational[1, 2]}]}, {
                    Scaled[{0.5, 0.5}]}]]}}}, AspectRatio -> Full, 
                    ImageSize -> {10, 12.5}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.18000000000000002`] -> 
                    Baseline)], #}}, 
                   GridBoxAlignment -> {
                    "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                   AutoDelete -> False, 
                   GridBoxDividers -> {
                    "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                   GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                   GridBoxSpacings -> {
                    "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
               GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}},
                AutoDelete -> False, 
               GridBoxItemSize -> {
                "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
               GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
              "Grid"], Alignment -> Left, AppearanceElements -> None, 
             ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
             "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
           FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
           False], TraditionalForm]& ), 
        InterpretationFunction :> (RowBox[{"PointLegend", "[", 
           RowBox[{
             RowBox[{"{", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   
                   TemplateBox[<|"color" -> GrayLevel[0]|>, 
                    "GrayLevelColorSwatchTemplate"], ",", 
                   RowBox[{"AbsolutePointSize", "[", "6", "]"}]}], "]"}], 
               "}"}], ",", 
             RowBox[{"{", #, "}"}]}], "]"}]& ), Editable -> True], 
       TraditionalForm], 
      FormBox[
       TemplateBox[{
        "\"dFtotalAdimNvdT[\\!\\(\\*StyleBox[\\\"T\\\",FontSlant->\\\"Italic\\\
\"]\\),\[Rho]]\""}, "LineLegend", DisplayFunction -> (FormBox[
          StyleBox[
           StyleBox[
            PaneBox[
             TagBox[
              GridBox[{{
                 TagBox[
                  GridBox[{{
                    GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[1, 0, 0]], {
                    LineBox[{{0, 12.5}, {20, 12.5}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[1, 0, 0]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 12.5}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.18000000000000002`] -> 
                    Baseline)], #}}, 
                   GridBoxAlignment -> {
                    "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                   AutoDelete -> False, 
                   GridBoxDividers -> {
                    "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                   GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                   GridBoxSpacings -> {
                    "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
               GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}},
                AutoDelete -> False, 
               GridBoxItemSize -> {
                "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
               GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
              "Grid"], Alignment -> Left, AppearanceElements -> None, 
             ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
             "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
           FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
           False], TraditionalForm]& ), 
        InterpretationFunction :> (RowBox[{"LineLegend", "[", 
           RowBox[{
             RowBox[{"{", 
               
               TemplateBox[<|"color" -> RGBColor[1, 0, 0]|>, 
                "RGBColorSwatchTemplate"], "}"}], ",", 
             RowBox[{"{", #, "}"}]}], "]"}]& ), Editable -> True], 
       TraditionalForm]}, "RowWithSeparators"], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"]}, {
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "Below"}], "]"}]}], "]"}]& )]], "Output",
 CellLabel->"Out[3]=",
 CellID->75372308,ExpressionUUID->"a4c10ed0-d167-454d-a238-e80886076cf7"]
}, Open  ]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "2"}, 
  Closed]]]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "PrimaryExamplesSection"}, 
  Closed]]]],

Cell[BoxData[GridBox[{
   {
    DynamicBox[FEPrivate`ImportImage[
      FrontEnd`FileName[{"Documentation", "FooterIcons"}, 
       "RelatedFunction.png"]],
     ImageSizeCache->{50., {27., 33.}}], GridBox[{
      {
       StyleBox[
        RowBox[{"See", " ", "Also"}], "SeeAlsoSection"]},
      {Cell[TextData[{
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["FtotalAdimNv"]], "paclet:NewEoSArgon/ref/FtotalAdimNv", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "6e17f41f-f967-4b71-b9c0-106f2f7b84ad"],
        "\[NonBreakingSpace]",
        StyleBox[
        "\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
         "InlineSeparator"],
        " ",
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["StotalAdimNv"]], "paclet:NewEoSArgon/ref/StotalAdimNv", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "4805cd58-1a56-4803-aa20-63bd0e3a7d48"],
        "\[NonBreakingSpace]",
        StyleBox[
        "\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
         "InlineSeparator"],
        " ",
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["UtotalAdimNv"]], "paclet:NewEoSArgon/ref/UtotalAdimNv", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "5d3206f1-38f8-4cc7-b5c1-845f1cea77ec"],
        "\[NonBreakingSpace]",
        StyleBox[
        "\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
         "InlineSeparator"],
        " ",
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["d2FtotalAdimNvdT2"]], 
           "paclet:NewEoSArgon/ref/d2FtotalAdimNvdT2", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "d9fe0f1f-f54a-480d-baf0-9bd03ba278da"],
        "\[NonBreakingSpace]",
        StyleBox[
        "\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
         "InlineSeparator"],
        " ",
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["RhoArgonNv"]], "paclet:NewEoSArgon/ref/RhoArgonNv", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "0f0844d0-86a6-4461-877f-4a8d6cdf264d"]
       }], "SeeAlso",ExpressionUUID->"b0b8acb5-e694-4eef-a91b-547a575ec718"]}
     }]}
  }]], "SeeAlsoSection",ExpressionUUID->"0475397f-86c0-4999-8bbc-\
2a0bc641f917"],

Cell[BoxData[GridBox[{
   {
    DynamicBox[FEPrivate`ImportImage[
      FrontEnd`FileName[{"Documentation", "FooterIcons"}, "RelatedGuide.png"]],
     ImageSizeCache->{50., {27., 33.}}], GridBox[{
      {
       StyleBox[
        RowBox[{"Related", " ", "Guides"}], "MoreAboutSection"]},
      {
       RowBox[{"\[FilledVerySmallSquare]", Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["NewEoSArgon Package"]], 
           "paclet:NewEoSArgon/guide/NewEoSArgon"},
          "RefLinkPlain",
          BaseStyle->{"MoreAbout"}]], "MoreAbout",ExpressionUUID->
         "d355bba9-2bd5-4b80-8aa3-075d4fb22151"]}]}
     }]}
  }]], "MoreAboutSection",ExpressionUUID->"fad01766-1164-4acf-a20b-\
b0cb8b701be8"],

Cell[BoxData[GridBox[{
   {
    TemplateBox[{29},
     "Spacer1"], GridBox[{
      {
       RowBox[{
        TemplateBox[{17},
         "Spacer1"], 
        StyleBox[
         RowBox[{"Related", " ", "Links"}], "RelatedLinksSection"]}]},
      {Cell[BoxData[Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData[
             RowBox[{
               RowBox[{"Units", " ", "&"}], " ", "Quantities"}]]], 
           "paclet:guide/Units"},
          "RefLinkPlain",
          BaseStyle->{"RelatedLinks"}]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "23f0b9b7-caf0-4105-a324-84c1b9094ab8"]], "RelatedLinks",
        ExpressionUUID->"1fed49c9-7068-4340-a318-fa342272227d"]},
      {Cell[BoxData[Cell[BoxData[Cell[BoxData[
          RowBox[{
           TemplateBox[{16},
            "Spacer1"], "\[FilledVerySmallSquare]", 
           TemplateBox[{
             Cell[
              TextData[
               Cell[
                TextData[{
                  Cell[
                   BoxData[
                    TemplateBox[{2}, "Spacer1"]]], "ThermodynamicData"}]]]], 
             "paclet:ref/ThermodynamicData"},
            "RefLink",
            BaseStyle->{"RelatedLinks"}]}]],ExpressionUUID->
          "420f388c-b99a-4218-9ce1-26724780fb1a"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "a61ad3c4-f8eb-40b8-bc15-94cdd35d3957"]], "RelatedLinks",
        ExpressionUUID->"c104d3ec-475a-471c-a543-f20c9a28d669"]}
     }]}
  }]], "RelatedLinksSection",ExpressionUUID->"7e87b645-f0af-4efe-8cbe-\
1d7645b6a5c8"],

Cell[" ", "FooterCell",ExpressionUUID->"a432fda0-966e-4669-943d-40aec89cbe2f"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{900, 835.8},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"dFtotalAdimNvdT",
TaggingRules->{
 "ModificationHighlight" -> False, "ColorType" -> "", "LinkTrails" -> "", 
  "HasOptions" -> True, "ExampleCounter" -> 1, 
  "Openers" -> {
   "PrimaryExamplesSection" -> Open, 
    "ExampleSection" -> {"0" -> Open, "2" -> Closed}, "NotesSection" -> 
    Closed}, "NewStyles" -> True, "CitationPopupData" -> $Failed, 
  "ShowCitation" -> False, "RootCaptions" -> "", 
  "Metadata" -> {
   "built" -> "{2023, 11, 30, 13, 55, 32.1714499}", 
    "history" -> {"XX", "", "", ""}, "context" -> "NewEoSArgon`", 
    "keywords" -> {}, "specialkeywords" -> {}, 
    "tutorialcollectionlinks" -> {}, "index" -> True, "label" -> 
    "New Eo S Argon Package Symbol", "language" -> "en", "paclet" -> 
    "NewEoSArgon Package", "status" -> "None", "summary" -> 
    "dFtotalAdimNvdT[T, \\[Rho]] \\[Congruent] (\\[PartialD]a/\\[PartialD]T) \
V = -1/T (a + S/R) = -(U/RT^2) (K -1) D\[EAcute]riv\[EAcute]e partielle premi\
\[EGrave]re par rapport \[AGrave] T de l'\[EAcute]nergie libre \
adimensionnelle a = F/RT en fonction de T (Kelvin) et de \\[Rho] (g/cm^3) \
[First derivative with temperature of non-dimensionnal free energy a = F/RT \
versus T (Kelvin) and \\[Rho] (g/cm^3)]", "synonyms" -> {}, "tabletags" -> {},
     "title" -> "dFtotalAdimNvdT", "titlemodifier" -> "", "metadescription" -> 
    "", "windowtitle" -> "dFtotalAdimNvdT", "type" -> "Symbol", "uri" -> 
    "NewEoSArgon/ref/dFtotalAdimNvdT"}},
CellContext->"Global`",
FrontEndVersion->"13.3 pour Microsoft Windows (64-bit) (July 24, 2023)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "13.3 pour Microsoft Windows (64-bit) (July 24, 2023)", 
  StyleDefinitions -> "Default.nb"],
ExpressionUUID->"d2bd6cb4-3243-42b0-bb89-6ee264331d26"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[12470, 351, 1420, 37, 35, "PrimaryExamplesSection",ExpressionUUID->"a2ddd6f6-def3-41f1-a487-9bfa28bba695",
   CellTags->"PrimaryExamplesSection",
   CellID->112647223]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 71897, 1724}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[587, 21, 5675, 136, 56, "AnchorBarGrid",ExpressionUUID->"d5adc3b0-9240-4504-ad26-a1bda82b72ba",
 CellID->1],
Cell[6265, 159, 94, 0, 23, "ContextNameCell",ExpressionUUID->"2a68458d-fdfb-4424-b309-807861ee0eda"],
Cell[CellGroupData[{
Cell[6384, 163, 558, 14, 56, "ObjectNameGrid",ExpressionUUID->"0031efcb-71f5-4527-8772-9adb75ece24c"],
Cell[6945, 179, 2815, 91, 150, "Usage",ExpressionUUID->"2aff678c-bacf-4039-ac16-d592115c3a88"]
}, Open  ]],
Cell[CellGroupData[{
Cell[9797, 275, 1919, 48, 37, "NotesSection",ExpressionUUID->"d9bad81c-78ac-46ab-b1e5-6e015e504a5b",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->174751640],
Cell[11719, 325, 221, 6, 36, "Notes",ExpressionUUID->"e796c3b8-0735-4dc5-ad1e-b500aeef6bfd",
 CellID->1067943069],
Cell[11943, 333, 185, 4, 36, "Notes",ExpressionUUID->"bc6e6be9-e3a0-4f42-89f6-b0509e122c44",
 CellID->185021568],
Cell[12131, 339, 212, 6, 36, "Notes",ExpressionUUID->"857d8369-99df-41dd-baed-d95097935d58",
 CellID->175218415]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "NotesSection"}, Closed]]]],
Cell[CellGroupData[{
Cell[12470, 351, 1420, 37, 35, "PrimaryExamplesSection",ExpressionUUID->"a2ddd6f6-def3-41f1-a487-9bfa28bba695",
 CellTags->"PrimaryExamplesSection",
 CellID->112647223],
Cell[CellGroupData[{
Cell[13915, 392, 1398, 36, 30, "ExampleSection",ExpressionUUID->"423aad2e-0b62-41a2-8f00-00faf7b50209",
 CellID->748424143],
Cell[15316, 430, 268, 5, 42, "Input",ExpressionUUID->"9c6126c2-49e9-434d-b05d-ba2bd809b531",
 CellID->143015886],
Cell[15587, 437, 569, 18, 42, "ExampleText",ExpressionUUID->"eebf35e7-b6bd-44e4-b989-b9f1d0d4c644",
 CellID->544149791],
Cell[CellGroupData[{
Cell[16181, 459, 1030, 25, 42, "Input",ExpressionUUID->"34562558-9186-4b6f-a6ad-bfa11020b453",
 CellID->5710145],
Cell[17214, 486, 307, 7, 40, "Output",ExpressionUUID->"6d627cdd-ec87-4af1-a2d8-e38c9406abbf",
 CellID->747090223]
}, Open  ]],
Cell[17536, 496, 711, 26, 43, "ExampleText",ExpressionUUID->"17fbe9c7-31b0-44de-b42f-bbb818713dcc",
 CellID->75491617],
Cell[CellGroupData[{
Cell[18272, 526, 1140, 28, 42, "Input",ExpressionUUID->"4c8cd4a4-613b-491d-9fdf-414513c9eb0d",
 CellID->311444489],
Cell[19415, 556, 307, 7, 40, "Output",ExpressionUUID->"e9449fdb-2f57-4a71-a8cf-464754489e2c",
 CellID->31771702]
}, Open  ]],
Cell[19737, 566, 171, 3, 38, "ExampleText",ExpressionUUID->"b6dc2b7b-33af-4069-a569-52b209661337",
 CellID->286706321],
Cell[CellGroupData[{
Cell[19933, 573, 1136, 27, 64, "Input",ExpressionUUID->"9f38ff0a-b204-4c6f-91fc-6fdaefd79678",
 CellID->605199954],
Cell[21072, 602, 15770, 309, 294, "Output",ExpressionUUID->"f171a0c7-0662-4c61-9f93-a47d52dd898f",
 CellID->436341296]
}, Open  ]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"}, Closed]]]],
Cell[CellGroupData[{
Cell[36991, 919, 1419, 37, 70, "ExampleSection",ExpressionUUID->"c6d9089b-43bb-42cd-957a-d996f9807c82",
 CellID->258228157],
Cell[38413, 958, 174, 3, 70, "Input",ExpressionUUID->"3cf1b70a-3be4-4c2d-9177-5d67a8823118",
 CellID->87419684],
Cell[38590, 963, 401, 11, 70, "ExampleText",ExpressionUUID->"0d60131a-2cad-4f61-b5ad-f6cdd9decc83",
 CellID->227520913],
Cell[38994, 976, 464, 13, 70, "Input",ExpressionUUID->"629f6e56-3fda-49c3-a493-234b2296b882",
 CellID->531122037],
Cell[CellGroupData[{
Cell[39483, 993, 2926, 79, 70, "Input",ExpressionUUID->"873fd569-037b-4a40-b7e1-f2a0dfcc17ff",
 CellID->136921489],
Cell[42412, 1074, 21596, 444, 343, "Output",ExpressionUUID->"a4c10ed0-d167-454d-a238-e80886076cf7",
 CellID->75372308]
}, Open  ]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "2"}, Closed]]]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "PrimaryExamplesSection"}, Closed]]]],
Cell[64250, 1527, 2978, 79, 70, "SeeAlsoSection",ExpressionUUID->"0475397f-86c0-4999-8bbc-2a0bc641f917"],
Cell[67231, 1608, 729, 19, 70, "MoreAboutSection",ExpressionUUID->"fad01766-1164-4acf-a20b-b0cb8b701be8"],
Cell[67963, 1629, 1607, 43, 70, "RelatedLinksSection",ExpressionUUID->"7e87b645-f0af-4efe-8cbe-1d7645b6a5c8"],
Cell[69573, 1674, 78, 0, 70, "FooterCell",ExpressionUUID->"a432fda0-966e-4669-943d-40aec89cbe2f"]
}
]
*)

(* End of internal cache information *)

