(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 13.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     67918,       1523]
NotebookOptionsPosition[     62068,       1406]
NotebookOutlinePosition[     64501,       1465]
CellTagsIndexPosition[     64415,       1460]
WindowTitle->dPArgonNvdRho
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[GridBox[{
   {GridBox[{
      {
       ItemBox[Cell[BoxData[
         RowBox[{
          TemplateBox[{12},
           "Spacer1"], Cell["NEW EO S ARGON PACKAGE SYMBOL", "PacletNameCell",
           TextAlignment->Center,ExpressionUUID->
           "db18bddb-9a7c-4c58-86e2-de995f3a0f30"], 
          TemplateBox[{8},
           "Spacer1"]}]],
         TextAlignment->Center,ExpressionUUID->
         "99ad7de0-3196-4051-a35e-3e489ffa821c"],
        Background->RGBColor[0.490196, 0.576471, 0.690196],
        ItemSize->Full], ""}
     },
     GridBoxAlignment->{"Rows" -> {{Center}}},
     GridBoxItemSize->{"Columns" -> {Full, 
         Scaled[0.02]}, "Rows" -> {{2.5}}}], Cell[TextData[{
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "See Also",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "910c3a92-3f56-47ad-b034-37204e9880d3"]
         }],ExpressionUUID->"8ee4367e-b0ce-49b4-a983-e2d6ba455337"],
         StripOnInput->False],{
        "\"PArgonNv\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/PArgonNv"], 
         "\"RhoArgonNv\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/RhoArgonNv"], 
         "\"ZtotalNv\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/ZtotalNv"], 
         "\"dZtotalNv\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/dZtotalNv"], 
         "\"CompressibiliteKTNv\"" :> 
         Documentation`HelpLookup[
          "paclet:NewEoSArgon/ref/CompressibiliteKTNv"]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"SeeAlso"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "e3ffa461-808a-43e6-99d7-ec6cafb124cc"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "Related Guides",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "5658cbc6-ef9d-4d31-b103-13247258889e"]
         }],ExpressionUUID->"1bd8a757-c5cc-499c-9ccd-f7fa0abe4420"],
         StripOnInput->False],{
        "\"NewEoSArgon Package\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/guide/NewEoSArgon"]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"MoreAbout"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "67097988-6321-4767-97c6-29350cb15323"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "URL",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "76368015-a734-4321-a5f9-e2ad676eea2f"]
         }],ExpressionUUID->"175ceb2f-054f-4f4e-9447-953a426bccfb"],
         StripOnInput->False],{
        "\"NewEoSArgon/ref/dPArgonNvdRho\"" :> None, 
         "\"Copy Wolfram Documentation Center URL\"" :> 
         Module[{DocumentationSearch`Private`nb$}, 
           DocumentationSearch`Private`nb$ = 
            NotebookPut[
             Notebook[{Cell["NewEoSArgon/ref/dPArgonNvdRho"]}, Visible -> 
               False]]; 
           SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
           FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
           NotebookClose[DocumentationSearch`Private`nb$]; Null], Delimiter, 
         "\"Copy web URL\"" :> 
         Module[{DocumentationSearch`Private`nb$}, 
           DocumentationSearch`Private`nb$ = 
            NotebookPut[
             Notebook[{
               Cell[BoxData[
                 MakeBoxes[
                  Hyperlink[
                   "http://reference.wolfram.com/language/NewEoSArgon/ref/\
dPArgonNvdRho.html"], StandardForm]], "Input", TextClipboardType -> 
                 "PlainText"]}, Visible -> False]]; 
           SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
           FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
           NotebookClose[DocumentationSearch`Private`nb$]; Null], 
         "\"Go to web URL\"" :> 
         FrontEndExecute[{
           NotebookLocate[{
             URL[If[TrueQ[DocumentationBuild`Make`Private`wsmlinkQ$12520], 
                 "http://reference.wolfram.com/system-modeler/", 
                 "http://reference.wolfram.com/language/"] <> 
               "NewEoSArgon/ref/dPArgonNvdRho" <> ".html"], None}]}]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"URLMenu"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "0d574b5b-17de-4c0d-8939-002bce16451c"]
    }], "AnchorBar",
     CacheGraphics->False,ExpressionUUID->
     "1da48e27-8b25-4ba0-a2fa-a60507524261"]}
  }]], "AnchorBarGrid",
 CellID->1,ExpressionUUID->"34f8f768-cc8d-4c64-8ae1-5bdefa12e0ab"],

Cell["NewEoSArgon`", "ContextNameCell",ExpressionUUID->"83962e57-31b5-4837-acce-11823e108da4"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     Cell[
     "dPArgonNvdRho", "ObjectName",ExpressionUUID->
      "ee95865a-02e0-4376-89b9-67d7d53a2860"],
     Cell[BoxData[
      TemplateBox[{8},
       "Spacer1"]],ExpressionUUID->"715fa4ef-4bb3-4d3f-893a-cb88a43e4c6d"],
     Cell[BoxData[
     ""], "ObjectNameTranslation",ExpressionUUID->
      "be3507ea-ee98-4fc1-a0b7-9fc2c64b52e4"]
    }],ExpressionUUID->"4db42fbd-1eaa-4c20-88a8-7cacbea03c3e"], 
    "\[SpanFromLeft]"}
  }]], "ObjectNameGrid",ExpressionUUID->"81e02b4f-accf-42b6-ab45-\
4094d8ad3ce9"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"dPArgonNvdRho", "[", 
       RowBox[{
        StyleBox["T",
         FontSlant->"Italic"], ",", "\[Rho]"}], "]"}]], "InlineFormula",
      ShowStringCharacters->False,
      FontFamily->"Source Sans Pro",ExpressionUUID->
      "31a3a6bc-9340-4c97-8c1b-ac1c6120b6db"],
     " \[Congruent] ",
     Cell[BoxData[
      SubscriptBox[
       RowBox[{"(", 
        FractionBox[
         RowBox[{"\[PartialD]", 
          StyleBox["P",
           FontSlant->"Italic"]}], 
         RowBox[{"\[PartialD]", 
          StyleBox["\[Rho]",
           FontSlant->"Italic"]}]], ")"}], 
       StyleBox["T",
        FontSlant->"Italic"]]],ExpressionUUID->
      "56d373db-d1ad-4032-aa06-c0751d999fa2"],
     "= ",
     Cell[BoxData[
      SubscriptBox["\[Gamma]", 
       StyleBox["T",
        FontSlant->"Italic"]]],ExpressionUUID->
      "a5f58d69-0b1f-4b81-9616-dc0a5707ffb2"],
     " (J/g)\nD\[EAcute]riv\[EAcute]e partielle premi\[EGrave]re par rapport \
\[AGrave] \[Rho] de la pression en fonction de ",
     StyleBox["T",
      FontSlant->"Italic"],
     " (Kelvin) et de \[Rho] (g/",
     Cell[BoxData[
      SuperscriptBox["cm", "3"]], "InlineFormula",
      FontFamily->"Source Sans Pro",ExpressionUUID->
      "c90c026a-2a67-4dfe-a5d6-4ffe1846dae2"],
     ")  \n[First derivative of pressure with respect to density versus ",
     StyleBox["T",
      FontSlant->"Italic"],
     " (Kelvin) and \[Rho] (g/",
     Cell[BoxData[
      SuperscriptBox["cm", "3"]], "InlineFormula",
      FontFamily->"Source Sans Pro",ExpressionUUID->
      "24591ad4-5677-4111-916a-0a4ab6ea9c6b"],
     ")]"
    }],ExpressionUUID->"468c07a7-92a6-4232-8729-b60dfe0722ad"]}
  }]], "Usage",
 Deletable->True,ExpressionUUID->"2034a6c4-5985-4308-b230-6d69e71d997c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[Cell[TextData[{
   Cell[BoxData[
    DynamicBox[ToBoxes[
      If[
       MatchQ[
        CurrentValue[
         EvaluationNotebook[], {TaggingRules, "Openers", "NotesSection"}, 
         Closed], 
        Alternatives[Open, True]], 
       Style[
        Graphics[{
          Thickness[0.18], 
          RGBColor[0.8509803921568627, 0.396078431372549, 0], 
          Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
         PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
        0.68 Inherited], 
       Rotate[
        Style[
         Graphics[{
           Thickness[0.18], 
           RGBColor[0.8509803921568627, 0.396078431372549, 0], 
           Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
          PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
         0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
     ImageSizeCache->{
      13.600000000000001`, {0.5800000000000001, 13.020000000000001`}}]],
    ExpressionUUID->"b5c7e3d6-75fe-4c1d-b28a-eff2306fe53a"],
   Cell[BoxData[
    TemplateBox[{1},
     "Spacer1"]],ExpressionUUID->"a94368a4-143f-47af-9947-131fb8e8aa41"],
   "Details and Options"
  }], "NotesFrameText",ExpressionUUID->"78ceb8da-5ba8-42da-813d-4d647f8a2f36"],
  Appearance->{Automatic, None, "Normal", Automatic},
  BaseStyle->None,
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"], 
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], After, CellContents]}]& ),
  Evaluator->None,
  Method->
   "Preemptive"]],ExpressionUUID->"b102c34a-ef87-404d-b697-e7dafe0368f6"]], \
"NotesSection",
 WholeCellGroupOpener->True,
 CellGroupingRules->{"SectionGrouping", 50},
 CacheGraphics->False,
 CellID->298052541,ExpressionUUID->"e0813745-8e3e-42b3-8840-f5f1fa103a02"],

Cell[TextData[{
 "La fonction est d\[EAcute]finie pour ",
 StyleBox["T",
  FontSlant->"Italic"],
 " \[GreaterEqual] ",
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["ttr"]], "paclet:NewEoSArgon/ref/ttr", 
    "NewEoSArgon Package Symbol"},
   "PackageLink",
   BaseStyle->"InlineFormula"]], "InlineFormula",
  FontFamily->"Source Sans Pro",ExpressionUUID->
  "ad9ca3e2-fd37-4dc0-aac9-c9a72caf1c84"],
 " et \[Rho] \[GreaterEqual] 0"
}], "Notes",
 CellID->1067943069,ExpressionUUID->"5b2aa50f-9f78-412d-8059-b4f1180d13b7"],

Cell[TextData[{
 "La fonction ",
 Cell[BoxData[
  StyleBox[
   SubscriptBox["\[Gamma]", 
    StyleBox["T",
     FontSlant->"Italic"]],
   FontSlant->"Italic"]], "InlineFormula",
  FontFamily->"Source Sans Pro",ExpressionUUID->
  "ff0f3a21-09f7-474d-9756-5618b8b6ee2a"],
 "(",
 StyleBox["T",
  FontSlant->"Italic"],
 ", \[Rho]) est ici d\[EAcute]termin\[EAcute]e \[AGrave] partir de la \
relation suivante: ",
 Cell[BoxData[
  StyleBox[
   SubscriptBox["\[Gamma]", 
    StyleBox["T",
     FontSlant->"Italic"]],
   FontSlant->"Italic"]], "InlineFormula",
  FontFamily->"Source Sans Pro",ExpressionUUID->
  "dc5b3dcd-654e-41f1-8c0a-35b68fadbb3d"],
 " = ",
 StyleBox["RTZ",
  FontSlant->"Italic"],
 " + \[Rho]",
 StyleBox["RT",
  FontSlant->"Italic"],
 Cell[BoxData[
  SubscriptBox[
   RowBox[{"(", 
    FractionBox[
     RowBox[{"\[PartialD]", 
      StyleBox["Z",
       FontSlant->"Italic"]}], 
     RowBox[{"\[PartialD]", 
      StyleBox["\[Rho]",
       FontSlant->"Italic"]}]], ")"}], 
   StyleBox["T",
    FontSlant->"Italic"]]],ExpressionUUID->
  "3f0e87ef-5c2d-455d-a355-ac4c91e433d4"]
}], "Notes",
 CellID->524000197,ExpressionUUID->"6f332252-edea-4113-879c-0aaa69eaebf0"],

Cell["\<\
******************************************************************************\
*****\
\>", "Notes",
 CellID->185021568,ExpressionUUID->"e1bd3fb4-c572-4ae6-ab71-1064d0fdfc98"],

Cell[TextData[{
 "The function is defined for ",
 StyleBox["T",
  FontSlant->"Italic"],
 " \[GreaterEqual] ",
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["ttr"]], "paclet:NewEoSArgon/ref/ttr", 
    "NewEoSArgon Package Symbol"},
   "PackageLink",
   BaseStyle->"InlineFormula"]], "InlineFormula",
  FontFamily->"Source Sans Pro",ExpressionUUID->
  "79a0e6ad-9e54-48b4-a01b-17a6f75329b6"],
 " and \[Rho] \[GreaterEqual] 0."
}], "Notes",
 CellID->175218415,ExpressionUUID->"5aa0359e-2238-4837-836a-698041a8818d"],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  StyleBox[
   SubscriptBox["\[Gamma]", 
    StyleBox["T",
     FontSlant->"Italic"]],
   FontSlant->"Italic"]],ExpressionUUID->
  "553e1bb0-8cb5-4240-bc6e-598c0a86ce77"],
 "(",
 StyleBox["T",
  FontSlant->"Italic"],
 ", \[Rho]) function is determined here from the following relationship: ",
 Cell[BoxData[
  StyleBox[
   SubscriptBox["\[Gamma]", 
    StyleBox["T",
     FontSlant->"Italic"]],
   FontSlant->"Italic"]], "InlineFormula",
  FontFamily->"Source Sans Pro",ExpressionUUID->
  "00fb1fd0-71d5-45db-b396-7f34e6fa3a93"],
 " = ",
 StyleBox["RTZ",
  FontSlant->"Italic"],
 " + \[Rho]",
 StyleBox["RT",
  FontSlant->"Italic"],
 Cell[BoxData[
  SubscriptBox[
   RowBox[{"(", 
    FractionBox[
     RowBox[{"\[PartialD]", 
      StyleBox["Z",
       FontSlant->"Italic"]}], 
     RowBox[{"\[PartialD]", 
      StyleBox["\[Rho]",
       FontSlant->"Italic"]}]], ")"}], 
   StyleBox["T",
    FontSlant->"Italic"]]],ExpressionUUID->
  "7770583e-e28e-4a7b-8092-9bf53b6a935e"]
}], "Notes",
 CellID->536882946,ExpressionUUID->"03dc42f3-a60b-40af-8c23-a31e18ba6f11"]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "NotesSection"}, Closed]]]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {
       TaggingRules, "Openers", "PrimaryExamplesSection"}, Open], 
      Alternatives[True, Open]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{13.600000000000001`, {5., 8.600000000000001}}]],
  ExpressionUUID->"15cc7d77-12c2-48f3-8855-cd3fbdba6515"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"c2047646-788e-4569-9020-55c6903fe7c7"],
 "Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "6ca8344e-3399-4e57-8bfc-c840348eba1b"]
}], "PrimaryExamplesSection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellTags->"PrimaryExamplesSection",
 CellID->693119026,ExpressionUUID->"9a999f90-3878-4b90-a84a-1a2579561e8c"],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"},
        Closed], 
      Alternatives[Open, True]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{13.600000000000001`, {5., 8.600000000000001}}]],
  ExpressionUUID->"2f50c7e6-e169-4adc-832d-db1a5ef771a7"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"7db97f87-7514-4f96-9731-2278a4d91270"],
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "4aa91a3a-4ccc-4ca3-8ced-d0f042c51986"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellID->163242786,ExpressionUUID->"8096030d-e839-48fc-a719-2677f3782083"],

Cell[BoxData[{
 RowBox[{"Needs", "[", "\"\<NewEoSArgon`\>\"", "]"}], "\[IndentingNewLine]", 
 RowBox[{"Off", "[", 
  RowBox[{"General", "::", "munfl"}], "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->143015886,ExpressionUUID->"a0fed3c3-165f-48d0-8276-09efdc5fabe4"],

Cell[TextData[{
 "Calculated value of ",
 Cell[BoxData[
  SubscriptBox["\[Gamma]", 
   StyleBox["T",
    FontSlant->"Italic"]]], "InlineFormula",
  FontFamily->"Source Sans Pro",ExpressionUUID->
  "1738e031-5e4a-44c7-bf6d-ce8f217f75f1"],
 " for atmospheric pressure and 20\[Degree]C"
}], "ExampleText",
 CellID->544149791,ExpressionUUID->"d73c850e-3305-4c71-a2ec-6b6b7b773805"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Quantity", "[", 
  RowBox[{
   RowBox[{"dPArgonNvdRho", "[", 
    RowBox[{"293.15", ",", 
     RowBox[{"RhoArgonNv", "[", 
      RowBox[{"293.15", ",", 
       RowBox[{"QuantityMagnitude", "@", 
        RowBox[{"N", "@", 
         RowBox[{"UnitConvert", "[", 
          RowBox[{
           TemplateBox[{"1"},
            "QuantityUnit",
            DisplayFunction->(TooltipBox[
              StyleBox[
               RowBox[{#, "\[InvisibleSpace]", 
                 StyleBox[
                  RowBox[{" ", "\"atm\""}], "QuantityUnitTraditionalLabel"]}],
                ShowStringCharacters -> False], "Unit: atmospheres"]& ),
            InterpretationFunction->(RowBox[{"Quantity", "[", 
               RowBox[{#, ",", "\"Atmospheres\""}], "]"}]& )], ",", 
           "\"\<Bars\>\""}], "]"}]}]}], ",", "\"\<G\>\""}], "]"}]}], "]"}], 
   ",", 
   RowBox[{"\"\<Joules\>\"", "/", "\"\<Grams\>\""}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->254692277,ExpressionUUID->"6f966a83-cf34-4872-bfcd-5f218d01cb3d"],

Cell[BoxData[
 TemplateBox[{"60.93534342592249`", 
   RowBox[{
    "\"J\"", "\[InvisibleSpace]", "\"/\"", "\[InvisibleSpace]", "\"g\""}], 
   "joules per gram", 
   FractionBox["\"Joules\"", "\"Grams\""]},
  "Quantity"]], "Output",
 CellLabel->"Out[2]=",
 CellID->1393530,ExpressionUUID->"5f2e8489-7280-4d9e-a9bd-8560b769b8ad"]
}, Open  ]],

Cell["Using ThermodynamicData package (i.e. REFPROP from NIST)", "ExampleText",
 CellID->361149294,ExpressionUUID->"06538180-7c18-4053-8d11-f0c92a724185"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UnitConvert", "[", 
  RowBox[{
   RowBox[{"ThermodynamicData", "[", 
    RowBox[{
    "\"\<Argon\>\"", ",", 
     "\"\<FirstDerivativeOfPressureWithRespectToDensity\>\"", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<Pressure\>\"", "\[Rule]", 
        RowBox[{"Quantity", "[", 
         RowBox[{"1", ",", "\"\<Atmospheres\>\""}], "]"}]}], ",", 
       RowBox[{"\"\<Temperature\>\"", "\[Rule]", 
        RowBox[{"Quantity", "[", 
         RowBox[{"293.15", ",", "\"\<Kelvins\>\""}], "]"}]}]}], "}"}]}], 
    "]"}], ",", 
   RowBox[{"\"\<Joules\>\"", "/", "\"\<Grams\>\""}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->375583457,ExpressionUUID->"0b6bb541-0dde-4e39-945b-c8fb0564a7aa"],

Cell[BoxData[
 TemplateBox[{"60.93039486022215`", 
   RowBox[{
    "\"J\"", "\[InvisibleSpace]", "\"/\"", "\[InvisibleSpace]", "\"g\""}], 
   "joules per gram", 
   FractionBox["\"Joules\"", "\"Grams\""]},
  "Quantity"]], "Output",
 CellLabel->"Out[3]=",
 CellID->65109017,ExpressionUUID->"cacbe79c-f596-475d-af20-2540bfcaeec8"]
}, Open  ]],

Cell[TextData[{
 "First derivative of ",
 StyleBox["P",
  FontSlant->"Italic"],
 " on the saturation curve from NIST"
}], "ExampleText",
 CellID->286706321,ExpressionUUID->"d6108381-c8c4-4fb0-9443-12df49b8a52a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"dPArgonNvdRho", "[", 
     RowBox[{
      RowBox[{"TSatNIST", "[", "\[Rho]", "]"}], ",", "\[Rho]"}], "]"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"\[Rho]", ",", "\[Rho]trgaz", ",", "\[Rho]trliq"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", "Red", "}"}]}], ",", 
   RowBox[{"AxesOrigin", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\[Rho]c", ",", "0"}], "}"}]}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "\"\<\[Rho] (g/\!\(\*SuperscriptBox[\(cm\), \(3\)]\))\>\"", ",", 
      "\"\<\!\(\*StyleBox[\"(\",FontSlant->\"Italic\"]\)\!\(\*StyleBox[\
FractionBox[RowBox[{\"\[PartialD]\", StyleBox[\"P\",FontSlant->\"Italic\"]}], \
RowBox[{\"\[PartialD]\", \
StyleBox[\"\[Rho]\",FontSlant->\"Italic\"]}]],FontSlant->\"Italic\"]\)\!\(\*\
StyleBox[SubscriptBox[\")\", \
StyleBox[\"T\",FontSlant->\"Italic\"]],FontSlant->\"Italic\"]\)\!\(\*StyleBox[\
\" \",FontSlant->\"Italic\"]\)\!\(\*StyleBox[\"(\",FontSlant->\"Italic\"]\)\!\
\(\*StyleBox[\"J\",FontSlant->\"Italic\"]\)\!\(\*StyleBox[\"/\",FontSlant->\"\
Italic\"]\)\!\(\*StyleBox[\"g\",FontSlant->\"Italic\"]\)\!\(\*StyleBox[\")\",\
FontSlant->\"Italic\"]\)\>\""}], "}"}]}], ",", 
   RowBox[{"ImageSize", "\[Rule]", "400"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->605199954,ExpressionUUID->"977822ca-3099-4b69-ad8b-5b8073537da0"],

Cell[BoxData[
 GraphicsBox[
  InterpretationBox[{
    TagBox[{{{}, {}, 
       TagBox[
        {RGBColor[1, 0, 0], AbsoluteThickness[2], Opacity[1.], 
         LineBox[CompressedData["
1:eJwVl3c8le8bx0+KUpJVWSFRkuRYWXXdWckuslJESWUlWyEjMwkRyUhKCMnX
ziNkHjNkZa+srI5V+t2/v87r/bo+n+v6XPfzvJ7zug9b2F+6SUMikb5sI5H+
/ysyuV8g5qUDMNzy4owJEkM1nx3dZ647wqFJxw/Cb8WQeXRLMxJygg9vaReu
VoihjTsiAjHzzkBzKUCt4LsYij4X7D6T7wqijK4WCbNiSJR9ohl5ukODvbWn
5T8xVDevKBBzzhMOUJ8uazORkcXXJPeZnQ/B3qv8WAwvGW2+/NOMmr0gaOWq
6K2TZKReLMKioe4DLdVPOqdkyShWoK/M+eQjcHs0e0hBhYzGngbfSmbyhWdy
U0YPdciIvHmapXHZF3zexO74akRGXlYTZb+7/ED/96yL0HUyamyLvsVX4g/J
aoU3SqzJiP2MEovGqwAIP3tRK9SejG6mL5Y5+zyG69nWbe+dySiPNflWsmUg
xFvGrvN7ktGWlzZLo2oQuJbqOtD4kJHG9J+y38eDYfxbw8dL/mT04nLmLb69
IfBTb0LiUBAZjVcYs2gshIDfj4+Bd0LJSFxk12fnb6Fwdl+Ws2I4GXnHFtxK
LggDr5q3+7MiyIhCc5OlMe4J9N2+M/ohkow47Fg//34QDh+LT7VqRZORVc+X
W3zmT2FlruHis+dkZMIvE5x2OAL8fertH8aQEcno6YBcVATI7uxtPhBLRm+f
TEi07ngGcxe/lFzHrFV1JvimyzP4T4btlAXmlbXogY3JZ8C4Z2yAC3O86KxE
hHEkFP/0k4/E/dANpWDBxkioZw/0qMPzJuPiB0oUokAQsb78gvOEtyxK6GZH
QcFK0h2fKDKSpL0QPM4bDWM9x4J34vy9cskDHs+iQfj6uo0x3u+Rw6oE0/bn
oLRd3MoN7y/0Vjs4zek5ZNDHp1iFkVFzX9qA3MRzuH04+sTREDJyYv4r0WoY
A+FHA5eKAsmI67x+8M36GGgo5a/nCyAj6zwayYisWOBJiL7n4k1GjFPGwYI8
L6DsfIH9rQdklH/o40DJ0xfwRV2/R8KdjLYFmwWPO8ZBsGz0nRuOZJReXjDg
MRYHLnaPBBrtyEh7Za8kk0E8fDCqdWC5i8/DrGxATvYlUPqOnjlvifeT5pCM
+JcAXEs1Z60u4f3uOgQL3nsF9qZL4fNaeL+U2oGSkVcQztItbnYB78PgEjz+
NREG0y2j/wDOc++2/SHVZDj5702XvAgZOa4z7cjxS4ZbMU/7Mo+Skdijohfo
SzJ8VEwNoztMRpkROystFVJA3YR06Nx+Mnqdk8aWIf4aNPZzLf39I4Yi5oaL
pXnfAGNeWeyNejFkc9tkh+7aO4gufbPuYiSGBK5rxPlm5IChjuulXWWi6C3x
g31sRyEISq/Fh7QKIxbr6noHpnII6dRtIv05iqYM2K7a9lZC56ZZVRLjEeRM
O+1gcrcGNAO3Pn68xYsyfL0ECtQaILtD0tNglh2Fad5poGNrBrv7t/9u3GJF
I8EOc6L8zSDG6fbynz4rkql1YTIUa4ZKH7PVfYqsaPycn8E7zWZA4dZjetys
6OzphJHzAc1AtxB+37qNBS0cbt4IojZDfv1BnaozLEh/lXxiT08L5F8Jq5Ti
ZUaMbX++7mxphWQzuU8X6BmRgS2Rn9/VCg5XlBOvT+xFSfS+qdcHWiEilIYm
umovElPc+ah0rhVap+wPqnntRZc+MSvYM7SBk9X9j7MrDOj586N5XRfaoLVT
78ThyT2I20Q3Ma0aM3dhEGmQHp0YTXVRKmkHyqtCqWJOOhRS86rT9ks7OB3I
GWQl0aHp97GSL+raQTdAusRvnBZlOIQuzXa1Q2te2NDrXFokvOVoF7PcDjfq
lBgHztMiIQ5Fq58i32DqKHMZ8tiBBHWGLj9N+gbVSy39D+ZpEG8pt1SffwcU
RZpJLrCQELvW5sPh0A4Q6hrQ8938ByyDPTWTkR3goNvdp9b2D3ZsjzVaSe6A
oPAyb6WH/2BKnfnB3s+4Tm1Tnuvagrxe2ir43QHI30t0x7O/oLwxr/vmZifI
xOd+a+DdhDNhTXEZNp0Q9E+GeWh9A6R5skZy73cC6czHroMdGyCkeNvp86NO
SO5nKZwP2oC9IaOxXa86YSHP7u/plXXo4uge2NXVCUUyfwSF29bgtuwXG1vV
LhjK2feM4w0VSBcGIxm0u2Bh/oiVnzcVYoz+FmVexkyNcmK9QoVKV1na6Rtd
YPTQYTqNhQrcBR9fWfl1gQ/r/d/P/H5Dq/jrZrOKLpiaZHd0slkBGRE/sUty
34Fp6uOZb8ZL0CyfYrB47jsMySTq9csuwU0N4kHEBVyne8dCz7kEkXc265qN
voNaLJ98U+8izKbfv67h+h2m+rb+/b26CMmCNyKV87/Di5BPRxbuLMBOXpUV
adFuaC1YSmI8Mwf5zvEhelLdUGG2+d6Ofg4sKL/4HBS6IcJO2WFX1yyUu8dr
vVfvBvPP6TlT9rPg0vHrLdetbtBlX71r9HYGxoLjjUnJ3ZAs+/Vm96FpqFz5
VV7P3APo7r5hZ+lJcNBQuTzB3gPmcxxqzfSTwPM6foaGrwccRI/om/6YAHcd
FXYF0R4guYp3sQdMgFhG/L1s9R7IfWjTv+/7OCSZqQhE+WG9XWdkt/8YPGiI
Dzb93QO6S9+93rOMQG3iqb/Mf7Hf/aLNr6lhYLlf7VC7oxcq+t1JdsQwpHPN
G4qz9UJy+sYVNtth6LQ5d3SXBOY9NlGkxiEQ3TdV+cmhF8y/x7oa8Q/CkJ7U
n92zvYBu2daNh/TCCaEG+4plrG+JC+lT7gWXP9dGnTd7gW/XIVrpfz3AkBbU
MLS7D8yf/Od+0LkHZKl9LwqO90Hy8d53Pje7IfKFr5TFrT4gHTswHGbUBSo/
WuyKRzBrP7Ty8G8HYfMLFPVp7P/09z3SaAfG0crj/Yt9gAa8LpuwtEPX1H9j
W6R+QNF1+x+ntIH1yksTZd5+8DE/6JJX1Qphe6xVW67gOgeL29zJZuiQJfGM
d/RDRf7ViqSZWigqc/d06cf6kORlsbBaeAXL3TvHMD8NnbhwshasVCaihJf7
gWRi3s94rwbWdCn0Dsw/gMSb6l27VQ3c1i9+b2j9AKRsXrxdvBJuxIg1MdX+
AB/TvWvDg8Vgbj4cz9uMOXg2OupCMZgKR1qLdmL//muVy5+KQL98ebvmKGaq
qVxRSCEoTRTIBf77Pydd4kb/Ab/0mfS/pwfA59NUXGpdLgx2XvCbTh8A0svv
D6UfJ4PJfkvZ6pBBIJUc5+aFRGLZVG/sbiTmBfu1XULJRNgbpaes8Zif5o/u
EUshyiUExi3eY17STv9yNpU4cmk8Ylsd5m2jhU6G7wiXWgmnJJohIKVOJ8t4
5BBoR0FjP2CmKXX4962QYBASTclVGgKfs4nJyZeLiB6Nty7+5zHr+i0afS8i
HKNiDovoYP25jniuvmLiDb+rq+c1XC+37FAdKyXoz8kc4Xw4hJ/XTbIaqYJo
f1jiYViCmVNX/61yNSGsor1r+jNmm7VmmcBqwpdh5PmDL7hf86CnUkM1IfGS
/mNKHe5nefTc1MWvRHSR0eRMF64r8qVUWtcQBstUPZ9l7JcwZj1fU0dkl4QM
s6zi+uHZrAMc9QSdL4992sYQVGR5mKra1ROFTKohDduGgbTGQ3E93EAwdfcc
vEo7DD6bj+lTfRoI6yTbtF+7hgHZ09QkjjUQFVbbJHwZhqHiek5WqnYjwS76
vIKNCfv5edxcKxoJh99C2u9YsZ+mVa9TgULUlZX1yR7E+u8KRhfrKASfv+5t
CieuD+xUenO3iXDXGKNe48Fs6xEbLN9MtLO4+S8exnzj2WBZaAsh3LuHxV8Q
++/mBai/bCF8U5KSDhzH3FvGu/G+mei1ljj5XgTP729PLRBpJsTFakvkxTB/
dI3j6WkiQlZN1JolsP7QY86Bl03ESPl8p/lp3L/3BEeRTRMh/9jXclkO681D
7+qdbyKitQ4sBpzF9XtGgQeONxGzbBle7IrYvx4iepGpiVDuP8OQqYK5gOrf
s0khElLb4s5cwP5DdNPd0xRi5c7NY62auD5rJZPTTyE0xdfzLXTx+UnWhgy3
Uog362GKv/Uwr7Zd3VdLIf5W8LUGGmJ/gMbdmXIKYRCUf5XzCuYM3ybpIgqR
raM2k3UN55nWiP2cRyHoDva7gQVm74jr+tkU4tqAPV37TaxPtPTuyqAQBWnb
o2/cxvxmKk0gnUIw2sYeXrXBebwfTRx5SyGsJE/kBDtg/7vEsbI3FILYLFfg
dsIs7HO6L5VCsFddash2xfkafszaYHYImTA854m5JFDAAnPdRY/xb164n6Qs
kYWZj4PxvpXv/8/HhBvhfm5DKaT1ANyvznuUKY1CtL2TCg8NxnneiX1nw/OF
7eu5eJ5gfiSWo/iOQvhKX32fG4H9GhVrz3De3r8L0krReB4bZXPjPYUQ/+pf
3RmL+0lyvnHJpBCjelmDG4mYv0frh+H9d/cO9vW8xiyVOyefSyHEzFm7i95i
f6Vj7PhHCmE4odoRm4HnORvL+n2iEF42Hq0u2ZiNrh7b9x+FSFv6QLmch+dr
1+z3L6AQFLfhOskCXKeNYPxRSCGWt9i+spbg/nYC1vuLKQRngNqXpc+YmyQ+
C5VQiHN7Hnxu+4L1ymHjLKUUwvpZTnHuV1znrPjVgvnpwdH/ntbjPHyhXKZl
+Pm8OpBn14SZub3jE+YfR9Sztdowm4vnfMO8I+NhhkgnZqCzKMJ8Quzj2z09
mEl91dcwXyoYez3dj/MynKZU4f7uCuxJ9UN4Hqp6PIbzJFdqvEwfw7z6gbMc
561V844NxP97FUYGVVr4fZpvzouymsV5v59qicD77r888VRlAevlv73yz6cQ
Cn0cYQIruF6jkngUv28W17WCtq/h+R1mWk45FCJ40sd/ZBNz8FXJu1kUItc2
3+fLP6znCZ/chZ9X1/Lkg+TtI4ByeWg18PP/687l7r1zBEgeOyRPpVAIAZKO
87U9I+Cjscr/KYFCaDz2vXdm3whUMIYEdsRSCEeGAltuVsyNOoeeRVKICvZD
Vr2c2G92cqz9MYWYTNS1KObBvKcmVc8Hv9+C/tde8ON5xjq5Vu4UwpQ8Y2Ag
jJlnY17uDoXwK+TRkxLFnP3o6+p1CpFx5pIOmzjmnUNiZ40pxNqF4vPtsnje
y3guM1UKwds6q/TxDM4nkaUqhb9fqgZ8KOIc5q8GV8PIFCLaIlBG+wKeP2/w
Op+TQpROlUie1MK8cMz9ESOFGLGbF2O4iPWPGcNqtlGIU56XjzcY4XnPIt/n
TjQSBtuCBd+b4vpEz8WL3Y3Eg8Cyw0HmmHdI37te30g0RB3hVLXG+jfC8rXv
G4lFDsMDgjY4X6HEffY4/L1NDmHZ4YD1OusKrYGNhFXW4u5KV8z6dQF3LBuJ
J+KCO1M8MVuoeKnpNhL5RUbbfbyxvwI2/RQaCZqvxOaZQNz/MKPhbtZGIvHH
k9niGKwP3v6FtaiBYCn99ONxPK6LiBBMyQ1EwIueZr3E/+c5STYLbCBs9AQ/
zqVhvfjKrUm9BkK+vsz58H+4/8kYdHOsnsh+O2I1X4TPQ7+dObumnuD332VU
Wob588C6VHo9sRv05S5XY/b/lb5uXU90589sBX3DHBJ5iHG4jtCMZF64/B33
e6+sv/dzHUHYnx7m78Pz41KfyLyoI94K+1WVjWBe5lGn16wjnJI5gxYWsb9L
/ojO+1qCOewCsxHTKFTkBkyfkakh/G/b0wiyjeL38XrVN9oaYk31+fLiQcwl
HIG27V+JoW3DnaG8WH+8wOO19Vci29UtnhAdBVKwm1F9UDXBfzkxNEx8FHyK
Q/qltKuJ5+LVD4ylsf+vueMzlmriwdw+s+Uz2C9DVt3zoopQt3x35JgW1tcE
XSOeVxLlqIltRRfzXT9Nk0uVBJlnmfaLPu4fUcjQsreSYO85O2ViilkuWUP+
0RdiUrsrK/wu7pet5f3NuILwl6OVpgZjVr3noZFUSviVqg4+eoL5MsPm6p8S
wlchKGjvM5znoNN9Y6MS4tHZPX0CLzArnnp1fFcx4aXI7KP3Fut1Hv/z1Sgg
3NQPNeRW4vpDIXn5q7mEa+O1+wo1eL4Y+/ELQjmEi2Yyd109zvtq1Hgt4gPh
rH3EfrAV16sVf9ddyiAcLx1nYxzEHBiYrxCbStiaSF27u4l546/rbnt/wqbP
Zefq1v/3Q2ykeHfCxrQo15dmDEhMbq0DujeIO9fkt8fTY05H++SUncHa4lx6
3UHM2pnjTZHPweKO1pKgJOZLE9vdjmeBgcfNx0M2mE0tH92brACBEtXEIocx
GOqwPJaX8gWW1o8VRDiNgfkUv+nc1UoId58eRw+wXqs54Wp/FdS42aukhGK9
1OcjNos1IOXqvsMiYwx8aIlYO68moCk04ZbLxvrx41L+xs3QSpWXZMnDXL53
qVS6BWxctiwri8fAIS00o8mzFd44+1Xx12Ne3r/54UI7sDk98R2dHAOmCzSf
XDi7YOSTXXzpzBjomo+3JcZ1Qe6yTl7ULzzv8T/XaY7voHmfZURpdQwq7GZr
Fg51g79j7Lk3dOOga23H1Y3vHcsOKaSbguOQ/ChAnebFALTb/uc1YTEOEemB
sTS8YyByMQ/fDMZh18bJy474XAIkc3jY7ozDgsO7SceSMZDZTC8/d28c+G5c
NRMywvejoIStBO9xGGKb0rsXPwE2qX5eegm4H4PoxqDcT6DruehV0TkO3XTr
AUrz82Bepq1t2DMObglVAhnav6A4SYNnvh/3j6uPysn5BTZWKuVcY+Mgwiql
SpFdgG/LMlsuS9jPYHrWdRu+TzLyeZ3ch+9pBOuu7clLIKs8/zBebQLqskx7
jLmoMOT1Q5FXcwLYm5XzC/Wp8LiYsvONzgT4F96hsw6nQrto5rMPBhPgZPev
voJmFWw4rNMqbkzAWP/xfsNfq5A4P0yZ8JkAc25PPeXudaCJ6+SSKJ4A02Ce
Gr3pv5D+rXqosAzXw4XGjES3QJsxP02hYgIYaGP4Chy34KVf5CnV2gl4YOCS
5v5nCyTtdJSMOydAeNWth203CVkp1d/xXsT5nUxPCgtvQ41zZcWNxydBqzz9
mF/YdoQmNeYSTuJ769wXzcjC7Sh/qJfPjjwJt452P+4e2Y4Sv60FMslOwuTs
0fe75XYgx2JJg8tqkzDdG5y7a2YH4gzIWhqwmoSIiDBef0M6dJs74cRS6iTo
PMpKkr9Cjwb2nzCrejcJNzTNTC2f0KNL+0oiozMnYeRIdOZXgh4p0HSvS3+a
hNPNqo5ygrsR0xRrnWflJCwv5xdOLu1GRZ9Cb9AOT4JoleSv23EMaKeG5yt2
nikoTjvrMU3PhHZNCQanH54Cmxab+g4BzAGtTjKCUxB3JvNYLzCh3YSgppHI
FPy5XIGkXZgQg0TrRqzcFAypj5ClxpgQM5eg0UHDKcj+esXH6Csz4pppZjkQ
MQWFCweYghNY0alQ/iBWmp+Q8Fc9GKUcRFsTNiO/aH/CxCBFS7jmIGpWLFSg
0P8E3bPsHqdnDiKbDY1Ff+afkCnhoFEmxY4ybjubUPl+gtRL7YR7FHYkoFYn
0gM/gb+092YciROx09q1JT78CTYBboGX/LnRNu9iTuH1n5B/hUk7dosPcYtT
b6/8+QmhClvvdPYfRjLj4sXlpGm4xw7CXCKHkYNGlqHermnQso1unDE+jIYO
JkU/ODgNvOWaXk4Fh1FFrj9ji9Q0MGT+TDtxnx/5jOjQODlOw0BUyKbj5hG0
pTLx8/PMNMyrtvjGXziG3iacXVT9NQ2ON2+cDbE8hrSWY9ZalnC9hXc47OEx
lJB8fufI+jRsuQpub/x4DMlvpgvQ7ZoB7YGephNcQsgt966ZtsAM8HfGXQha
FEJLnIsdA6YzoL7tPvE7SxhN/tok/jXNgMe+vTuZr4uia7QrUp1tM8B5dkoo
21cUdXDOZmZ0zoCJwc/2G29EUYVKf+zlHzPgnXnoH8+UKIp/WWafOTsDtJZR
bnUOp5Dm+Ye8hntmQbFDh85bSQzlJm55ZavNQkyzymKeJRl5aG07e7VqFvoj
X20ONkmgB3T78WdzFhi3lbrUDEkgL0IoPqBhFjr2lHUVL0sgX7Iu9UPbLKTs
PWBWyyGJQvYnZW8NzoKRmaCyl5Ukiv+hwJv8ZxbmY37NmNNIoWJbN9Ko1BxY
+PfoCypLo7Unvyqt0+egRl/F8s+CDEpJue+/GDQP+p5rI5d6zqIV68m55w9+
wV5Pre0jJ5RQHD3/qZVTC0Bd6722onAePZFRkz+RuQAnLBMKr5lootXuEXVZ
nkXgsnXdeWRBF1Et6tZony6C5p/fymu79FFDTZqHOf0SqF33KMsZNERsCav/
nnkuQbzb21dDi1eQhMY544urS/D6ZyZ7jIs5mhrt1G1xWAY6ncxzJ6QsEcv8
gIbAyDJECdYoC9BbIZb2Qc6dV1fgXO9AqrnlbRR47PJcRcsKPH28PP6y2gZF
Wu2/Jot+wzqPtHiggANy9G56DSW/weXr7n0nBBxRHf3GNLcIFTbHwlA2kxNi
+G5qxCFKhX3dInJXOZyQzhvi634xKqieKf3NwO+Eus4GJDNKUoGxZFupnYQT
Gr/PZEBSoILhGkeHvIETohk4+mVUgwp2jFnS2xKckEKeXmzGXSqsT9CiXCFn
5ONdsOOdLRXCj2ieiyI7oypNDsdUeyqIZ3Nu95RzRuqTA5oJ96nwRGaT/oqm
MzLmvkMT7kmFT3z2TI4OzijhJ8U+5CEVTGTsC566O6OhglM/HntTgcRQE1Ls
64ysL/4u9PajwnP1Y7Uyz52Ry2Mf23uhVDDwMus4XuqMSvRGe22fUEEgutF8
ttoZ/eVTVbvzlArI5ZpTR7Mz8i/dc8Qyigoxdor5p0adUdRCTLf+SyqM65S7
8u1zQV2f11UuvsL5WG8cYOdyQZyhpp+0kqggqafWFHvMBb0W5A9XTaXCKYqX
p4OiC5pY8t9UTKNCNe+kRqWuCzpeMWkN76jwfTWQW8XMBdk8Ue+Sf0+FGwMj
OcU2LijX5IOSTCYVnKYe3G1zcUH/A2On9sU=
          "]]},
        Annotation[#, "Charting`Private`Tag#1"]& ]}, {}},
     {"WolframDynamicHighlight", <|
      "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>}], 
    DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
      Slot["HighlightElements"], 
      Slot["LayoutOptions"], 
      Slot["Meta"], 
      Charting`HighlightActionFunction["DynamicHighlight", {{{{}, {}, 
          Annotation[{
            Directive[
             Opacity[1.], 
             AbsoluteThickness[2], 
             RGBColor[1, 0, 0]], 
            Line[CompressedData["
1:eJwVl3c8le8bx0+KUpJVWSFRkuRYWXXdWckuslJESWUlWyEjMwkRyUhKCMnX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             "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
       "HighlightElements" -> <|
         "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
        "LayoutOptions" -> <|
         "PlotRange" -> {All, All}, "Frame" -> {{True, True}, {True, True}}, 
          "AxesOrigin" -> {0.535599, 0.}, 
          "ImageSize" -> {400, 400/GoldenRatio}, "Axes" -> {True, True}, 
          "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
          "DefaultStyle" -> {
            Directive[
             Opacity[1.], 
             AbsoluteThickness[2], 
             RGBColor[1, 0, 0]]}, 
          "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
              Identity[
               Part[#, 1]], 
              Identity[
               Part[#, 2]]}& ), 
            "ScalingFunctions" -> {{Identity, Identity}, {
              Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>,
         "Meta" -> <|
         "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
          Plot, "GroupHighlight" -> False|>|>]]& )[<|
      "HighlightElements" -> <|
        "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
       "LayoutOptions" -> <|
        "PlotRange" -> {All, All}, "Frame" -> {{True, True}, {True, True}}, 
         "AxesOrigin" -> {0.535599, 0.}, 
         "ImageSize" -> {400, 400/GoldenRatio}, "Axes" -> {True, True}, 
         "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
         "DefaultStyle" -> {
           Directive[
            Opacity[1.], 
            AbsoluteThickness[2], 
            RGBColor[1, 0, 0]]}, 
         "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
             Identity[
              Part[#, 1]], 
             Identity[
              Part[#, 2]]}& ), 
           "ScalingFunctions" -> {{Identity, Identity}, {
             Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>, 
       "Meta" -> <|
        "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
         Plot, "GroupHighlight" -> False|>|>],
     ImageSizeCache->{{4.503599627370496*^15, -4.503599627370496*^15}, {
      4.503599627370496*^15, -4.503599627370496*^15}}]},
   Annotation[{{{{}, {}, 
       Annotation[{
         Directive[
          Opacity[1.], 
          AbsoluteThickness[2], 
          RGBColor[1, 0, 0]], 
         Line[CompressedData["
1:eJwVl3c8le8bx0+KUpJVWSFRkuRYWXXdWckuslJESWUlWyEjMwkRyUhKCMnX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          "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
    "HighlightElements" -> <|
      "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
     "LayoutOptions" -> <|
      "PlotRange" -> {All, All}, "Frame" -> {{True, True}, {True, True}}, 
       "AxesOrigin" -> {0.535599, 0.}, "ImageSize" -> {400, 400/GoldenRatio}, 
       "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
       GoldenRatio^(-1), "DefaultStyle" -> {
         Directive[
          Opacity[1.], 
          AbsoluteThickness[2], 
          RGBColor[1, 0, 0]]}, 
       "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
           Identity[
            Part[#, 1]], 
           Identity[
            Part[#, 2]]}& ), 
         "ScalingFunctions" -> {{Identity, Identity}, {Identity, Identity}}|>,
        "Primitives" -> {}, "GCFlag" -> False|>, 
     "Meta" -> <|
      "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
       Plot, "GroupHighlight" -> False|>|>, "DynamicHighlight"]],
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0.535599, 0.},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{
     FormBox[
      TagBox[
      "\"\\!\\(\\*StyleBox[\\\"(\\\",FontSlant->\\\"Italic\\\"]\\)\\!\\(\\*\
StyleBox[FractionBox[RowBox[{\\\"\[PartialD]\\\", \
StyleBox[\\\"P\\\",FontSlant->\\\"Italic\\\"]}], RowBox[{\\\"\[PartialD]\\\", \
StyleBox[\\\"\[Rho]\\\",FontSlant->\\\"Italic\\\"]}]],FontSlant->\\\"Italic\\\
\"]\\)\\!\\(\\*StyleBox[SubscriptBox[\\\")\\\", \
StyleBox[\\\"T\\\",FontSlant->\\\"Italic\\\"]],FontSlant->\\\"Italic\\\"]\\)\\\
!\\(\\*StyleBox[\\\" \
\\\",FontSlant->\\\"Italic\\\"]\\)\\!\\(\\*StyleBox[\\\"(\\\",FontSlant->\\\"\
Italic\\\"]\\)\\!\\(\\*StyleBox[\\\"J\\\",FontSlant->\\\"Italic\\\"]\\)\\!\\(\
\\*StyleBox[\\\"/\\\",FontSlant->\\\"Italic\\\"]\\)\\!\\(\\*StyleBox[\\\"g\\\"\
,FontSlant->\\\"Italic\\\"]\\)\\!\\(\\*StyleBox[\\\")\\\",FontSlant->\\\"\
Italic\\\"]\\)\"", HoldForm], TraditionalForm], None}, {
     FormBox[
      TagBox[
      "\"\[Rho] (g/\\!\\(\\*SuperscriptBox[\\(cm\\), \\(3\\)]\\))\"", 
       HoldForm], TraditionalForm], None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  ImageSize->400,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellLabel->"Out[4]=",
 CellID->619320615,ExpressionUUID->"d99386ed-3ac7-4fc4-b3db-fce9c92c29f6"]
}, Open  ]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"}, 
  Closed]]]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "PrimaryExamplesSection"}, 
  Closed]]]],

Cell[BoxData[GridBox[{
   {
    DynamicBox[FEPrivate`ImportImage[
      FrontEnd`FileName[{"Documentation", "FooterIcons"}, 
       "RelatedFunction.png"]],
     ImageSizeCache->{50., {27., 33.}}], GridBox[{
      {
       StyleBox[
        RowBox[{"See", " ", "Also"}], "SeeAlsoSection"]},
      {Cell[TextData[{
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["PArgonNv"]], "paclet:NewEoSArgon/ref/PArgonNv", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "06811102-98b4-49f4-aa7a-cfbd21438d88"],
        "\[NonBreakingSpace]",
        StyleBox[
        "\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
         "InlineSeparator"],
        " ",
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["RhoArgonNv"]], "paclet:NewEoSArgon/ref/RhoArgonNv", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "7c2ee3d5-f3ed-4736-826c-d60def1166e0"],
        "\[NonBreakingSpace]",
        StyleBox[
        "\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
         "InlineSeparator"],
        " ",
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["ZtotalNv"]], "paclet:NewEoSArgon/ref/ZtotalNv", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "a8606684-e060-4273-87e1-922173f6b696"],
        "\[NonBreakingSpace]",
        StyleBox[
        "\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
         "InlineSeparator"],
        " ",
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["dZtotalNv"]], "paclet:NewEoSArgon/ref/dZtotalNv", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "78da5fe7-3b1e-4280-b690-638d05d605d4"],
        "\[NonBreakingSpace]",
        StyleBox[
        "\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
         "InlineSeparator"],
        " ",
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["CompressibiliteKTNv"]], 
           "paclet:NewEoSArgon/ref/CompressibiliteKTNv", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "179f0a48-7e6f-4ed7-aa61-63d0a7464f49"]
       }], "SeeAlso",ExpressionUUID->"cc2b2192-596e-41e6-ab5d-c8d877f2c608"]}
     }]}
  }]], "SeeAlsoSection",ExpressionUUID->"c78f7cbf-ea87-4859-a678-\
20dd3c7b8530"],

Cell[BoxData[GridBox[{
   {
    DynamicBox[FEPrivate`ImportImage[
      FrontEnd`FileName[{"Documentation", "FooterIcons"}, "RelatedGuide.png"]],
     ImageSizeCache->{50., {27., 33.}}], GridBox[{
      {
       StyleBox[
        RowBox[{"Related", " ", "Guides"}], "MoreAboutSection"]},
      {
       RowBox[{"\[FilledVerySmallSquare]", Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["NewEoSArgon Package"]], 
           "paclet:NewEoSArgon/guide/NewEoSArgon"},
          "RefLinkPlain",
          BaseStyle->{"MoreAbout"}]], "MoreAbout",ExpressionUUID->
         "87e1b080-d7de-4d52-9519-f68157bbb596"]}]}
     }]}
  }]], "MoreAboutSection",ExpressionUUID->"4d6cd712-0a15-4a1b-a7b7-\
70086e093d5d"],

Cell[BoxData[GridBox[{
   {
    TemplateBox[{29},
     "Spacer1"], GridBox[{
      {
       RowBox[{
        TemplateBox[{17},
         "Spacer1"], 
        StyleBox[
         RowBox[{"Related", " ", "Links"}], "RelatedLinksSection"]}]},
      {Cell[BoxData[Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData[
             RowBox[{
               RowBox[{"Units", " ", "&"}], " ", "Quantities"}]]], 
           "paclet:guide/Units"},
          "RefLinkPlain",
          BaseStyle->{"RelatedLinks"}]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "4d7dfca7-4521-4d01-96e0-e602fbf91405"]], "RelatedLinks",
        ExpressionUUID->"6387d036-8719-4dd3-93dd-09a4a0c14427"]},
      {Cell[BoxData[Cell[BoxData[Cell[BoxData[
          RowBox[{
           TemplateBox[{16},
            "Spacer1"], "\[FilledVerySmallSquare]", 
           TemplateBox[{
             Cell[
              TextData[
               Cell[
                TextData[{
                  Cell[
                   BoxData[
                    TemplateBox[{2}, "Spacer1"]]], "ThermodynamicData"}]]]], 
             "paclet:ref/ThermodynamicData"},
            "RefLink",
            BaseStyle->{"RelatedLinks"}]}]],ExpressionUUID->
          "394f4092-9c8e-482d-802c-c5f9d8a5fd39"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "c41548c5-b3e4-4e39-8d63-69d597e39c7f"]], "RelatedLinks",
        ExpressionUUID->"a53f7323-6ea7-4826-88a3-2edd26dcf4b1"]}
     }]}
  }]], "RelatedLinksSection",ExpressionUUID->"ef8a34ef-2210-46d5-bf25-\
8c9cc5f25d38"],

Cell[" ", "FooterCell",ExpressionUUID->"f564575b-a2e1-4d24-a238-fcf2c2c297c5"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{900, 835.8},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"dPArgonNvdRho",
TaggingRules->{
 "ModificationHighlight" -> False, "ColorType" -> "", "LinkTrails" -> "", 
  "HasOptions" -> True, "ExampleCounter" -> 1, 
  "Openers" -> {
   "PrimaryExamplesSection" -> Open, "ExampleSection" -> {"0" -> Open}, 
    "NotesSection" -> Closed}, "NewStyles" -> True, 
  "CitationPopupData" -> $Failed, "ShowCitation" -> False, "RootCaptions" -> 
  "", "Metadata" -> {
   "built" -> "{2023, 11, 30, 13, 55, 33.1289028}", 
    "history" -> {"XX", "", "", ""}, "context" -> "NewEoSArgon`", 
    "keywords" -> {}, "specialkeywords" -> {}, 
    "tutorialcollectionlinks" -> {}, "index" -> True, "label" -> 
    "New Eo S Argon Package Symbol", "language" -> "en", "paclet" -> 
    "NewEoSArgon Package", "status" -> "None", "summary" -> 
    "dPArgonNvdRho[T, \\[Rho]] \\[Congruent] \
(\\[PartialD]P/\\[PartialD]\\[Rho]) T= \\[Gamma]T (J/g) \
D\[EAcute]riv\[EAcute]e partielle premi\[EGrave]re par rapport \[AGrave] \
\\[Rho] de la pression en fonction de T (Kelvin) et de \\[Rho] (g/cm^3) \
[First derivative of pressure with respect to density versus T (Kelvin) and \
\\[Rho] (g/cm^3)]", "synonyms" -> {}, "tabletags" -> {}, "title" -> 
    "dPArgonNvdRho", "titlemodifier" -> "", "metadescription" -> "", 
    "windowtitle" -> "dPArgonNvdRho", "type" -> "Symbol", "uri" -> 
    "NewEoSArgon/ref/dPArgonNvdRho"}},
CellContext->"Global`",
FrontEndVersion->"13.3 pour Microsoft Windows (64-bit) (July 24, 2023)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "13.3 pour Microsoft Windows (64-bit) (July 24, 2023)", 
  StyleDefinitions -> "Default.nb"],
ExpressionUUID->"32a6f070-c79d-46c3-923c-b512bb3fa168"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[14355, 419, 1420, 37, 35, "PrimaryExamplesSection",ExpressionUUID->"9a999f90-3878-4b90-a84a-1a2579561e8c",
   CellTags->"PrimaryExamplesSection",
   CellID->693119026]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 64215, 1453}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[585, 21, 5660, 137, 56, "AnchorBarGrid",ExpressionUUID->"34f8f768-cc8d-4c64-8ae1-5bdefa12e0ab",
 CellID->1],
Cell[6248, 160, 94, 0, 23, "ContextNameCell",ExpressionUUID->"83962e57-31b5-4837-acce-11823e108da4"],
Cell[CellGroupData[{
Cell[6367, 164, 556, 14, 56, "ObjectNameGrid",ExpressionUUID->"81e02b4f-accf-42b6-ab45-4094d8ad3ce9"],
Cell[6926, 180, 1814, 50, 154, "Usage",ExpressionUUID->"2034a6c4-5985-4308-b230-6d69e71d997c"]
}, Open  ]],
Cell[CellGroupData[{
Cell[8777, 235, 1919, 48, 37, "NotesSection",ExpressionUUID->"e0813745-8e3e-42b3-8840-f5f1fa103a02",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->298052541],
Cell[10699, 285, 529, 16, 38, "Notes",ExpressionUUID->"5b2aa50f-9f78-412d-8059-b4f1180d13b7",
 CellID->1067943069],
Cell[11231, 303, 1179, 43, 43, "Notes",ExpressionUUID->"6f332252-edea-4113-879c-0aaa69eaebf0",
 CellID->524000197],
Cell[12413, 348, 185, 4, 36, "Notes",ExpressionUUID->"e1bd3fb4-c572-4ae6-ab71-1064d0fdfc98",
 CellID->185021568],
Cell[12601, 354, 521, 16, 38, "Notes",ExpressionUUID->"5aa0359e-2238-4837-836a-698041a8818d",
 CellID->175218415],
Cell[13125, 372, 1103, 41, 43, "Notes",ExpressionUUID->"03dc42f3-a60b-40af-8c23-a31e18ba6f11",
 CellID->536882946]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "NotesSection"}, Closed]]]],
Cell[CellGroupData[{
Cell[14355, 419, 1420, 37, 35, "PrimaryExamplesSection",ExpressionUUID->"9a999f90-3878-4b90-a84a-1a2579561e8c",
 CellTags->"PrimaryExamplesSection",
 CellID->693119026],
Cell[CellGroupData[{
Cell[15800, 460, 1398, 36, 30, "ExampleSection",ExpressionUUID->"8096030d-e839-48fc-a719-2677f3782083",
 CellID->163242786],
Cell[17201, 498, 268, 5, 42, "Input",ExpressionUUID->"a0fed3c3-165f-48d0-8276-09efdc5fabe4",
 CellID->143015886],
Cell[17472, 505, 377, 10, 38, "ExampleText",ExpressionUUID->"d73c850e-3305-4c71-a2ec-6b6b7b773805",
 CellID->544149791],
Cell[CellGroupData[{
Cell[17874, 519, 1041, 25, 42, "Input",ExpressionUUID->"6f966a83-cf34-4872-bfcd-5f218d01cb3d",
 CellID->254692277],
Cell[18918, 546, 327, 8, 42, "Output",ExpressionUUID->"5f2e8489-7280-4d9e-a9bd-8560b769b8ad",
 CellID->1393530]
}, Open  ]],
Cell[19260, 557, 154, 1, 38, "ExampleText",ExpressionUUID->"06538180-7c18-4053-8d11-f0c92a724185",
 CellID->361149294],
Cell[CellGroupData[{
Cell[19439, 562, 727, 18, 42, "Input",ExpressionUUID->"0b6bb541-0dde-4e39-945b-c8fb0564a7aa",
 CellID->375583457],
Cell[20169, 582, 328, 8, 42, "Output",ExpressionUUID->"cacbe79c-f596-475d-af20-2540bfcaeec8",
 CellID->65109017]
}, Open  ]],
Cell[20512, 593, 211, 6, 38, "ExampleText",ExpressionUUID->"d6108381-c8c4-4fb0-9443-12df49b8a52a",
 CellID->286706321],
Cell[CellGroupData[{
Cell[20748, 603, 1529, 33, 66, "Input",ExpressionUUID->"977822ca-3099-4b69-ad8b-5b8073537da0",
 CellID->605199954],
Cell[22280, 638, 34159, 610, 267, "Output",ExpressionUUID->"d99386ed-3ac7-4fc4-b3db-fce9c92c29f6",
 CellID->619320615]
}, Open  ]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"}, Closed]]]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "PrimaryExamplesSection"}, Closed]]]],
Cell[56681, 1257, 2960, 79, 70, "SeeAlsoSection",ExpressionUUID->"c78f7cbf-ea87-4859-a678-20dd3c7b8530"],
Cell[59644, 1338, 729, 19, 70, "MoreAboutSection",ExpressionUUID->"4d6cd712-0a15-4a1b-a7b7-70086e093d5d"],
Cell[60376, 1359, 1607, 43, 70, "RelatedLinksSection",ExpressionUUID->"ef8a34ef-2210-46d5-bf25-8c9cc5f25d38"],
Cell[61986, 1404, 78, 0, 70, "FooterCell",ExpressionUUID->"f564575b-a2e1-4d24-a238-fcf2c2c297c5"]
}
]
*)

(* End of internal cache information *)

