(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 13.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    104405,       2403]
NotebookOptionsPosition[     97246,       2259]
NotebookOutlinePosition[     99595,       2317]
CellTagsIndexPosition[     99509,       2312]
WindowTitle->dPArgonNvdT
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[GridBox[{
   {GridBox[{
      {
       ItemBox[Cell[BoxData[
         RowBox[{
          TemplateBox[{12},
           "Spacer1"], Cell["NEW EO S ARGON PACKAGE SYMBOL", "PacletNameCell",
           TextAlignment->Center,ExpressionUUID->
           "e7baa3d6-cd73-44ad-ad26-c7246d82877b"], 
          TemplateBox[{8},
           "Spacer1"]}]],
         TextAlignment->Center,ExpressionUUID->
         "f41c6a6b-f422-4bfa-8ca6-39bbde005996"],
        Background->RGBColor[0.490196, 0.576471, 0.690196],
        ItemSize->Full], ""}
     },
     GridBoxAlignment->{"Rows" -> {{Center}}},
     GridBoxItemSize->{"Columns" -> {Full, 
         Scaled[0.02]}, "Rows" -> {{2.5}}}], Cell[TextData[{
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "See Also",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "c20b4c9b-d9d8-4354-b46c-e3d497774487"]
         }],ExpressionUUID->"8da95a4b-b6ca-4397-bf95-86765ae1253a"],
         StripOnInput->False],{
        "\"PArgonNv\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/PArgonNv"], 
         "\"RhoArgonNv\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/RhoArgonNv"], 
         "\"ZtotalNv\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/ZtotalNv"], 
         "\"dZtotalNvdT\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/dZtotalNvdT"]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"SeeAlso"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "480217a9-6c39-4556-8ad5-162340b26fbc"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "Related Guides",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "51384e53-8442-4e79-9144-29c8d1e74c0e"]
         }],ExpressionUUID->"e672210e-2899-4058-a3b3-64bb7253b034"],
         StripOnInput->False],{
        "\"NewEoSArgon Package\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/guide/NewEoSArgon"]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"MoreAbout"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "3b05b15d-f8ba-45f1-bc5a-75ab882cb751"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "URL",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "c2898cec-bf2c-48fb-8fd8-95833e73a901"]
         }],ExpressionUUID->"41dd6238-c5d7-4805-8c25-8ee9c714b51c"],
         StripOnInput->False],{
        "\"NewEoSArgon/ref/dPArgonNvdT\"" :> None, 
         "\"Copy Wolfram Documentation Center URL\"" :> 
         Module[{DocumentationSearch`Private`nb$}, 
           DocumentationSearch`Private`nb$ = 
            NotebookPut[
             Notebook[{Cell["NewEoSArgon/ref/dPArgonNvdT"]}, Visible -> 
               False]]; 
           SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
           FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
           NotebookClose[DocumentationSearch`Private`nb$]; Null], Delimiter, 
         "\"Copy web URL\"" :> 
         Module[{DocumentationSearch`Private`nb$}, 
           DocumentationSearch`Private`nb$ = 
            NotebookPut[
             Notebook[{
               Cell[BoxData[
                 MakeBoxes[
                  Hyperlink[
                   "http://reference.wolfram.com/language/NewEoSArgon/ref/\
dPArgonNvdT.html"], StandardForm]], "Input", TextClipboardType -> 
                 "PlainText"]}, Visible -> False]]; 
           SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
           FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
           NotebookClose[DocumentationSearch`Private`nb$]; Null], 
         "\"Go to web URL\"" :> 
         FrontEndExecute[{
           NotebookLocate[{
             URL[If[TrueQ[DocumentationBuild`Make`Private`wsmlinkQ$13050], 
                 "http://reference.wolfram.com/system-modeler/", 
                 "http://reference.wolfram.com/language/"] <> 
               "NewEoSArgon/ref/dPArgonNvdT" <> ".html"], None}]}]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"URLMenu"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "35b158fd-46d4-4456-9607-69d2b8caff5b"]
    }], "AnchorBar",
     CacheGraphics->False,ExpressionUUID->
     "8605691b-37d0-4a97-933d-d228735bb13c"]}
  }]], "AnchorBarGrid",
 CellID->1,ExpressionUUID->"68585001-c235-4df9-a2c3-5268dc47568c"],

Cell["NewEoSArgon`", "ContextNameCell",ExpressionUUID->"3d340d71-2a7d-4d53-9069-103ab1285c66"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     Cell[
     "dPArgonNvdT", "ObjectName",ExpressionUUID->
      "483b2409-1e2b-4041-a629-2628b0b278fc"],
     Cell[BoxData[
      TemplateBox[{8},
       "Spacer1"]],ExpressionUUID->"1a2241bf-a6fa-40cf-8e7a-27aca14624d9"],
     Cell[BoxData[
     ""], "ObjectNameTranslation",ExpressionUUID->
      "9930ab5f-b324-4f2b-aa48-b81ea767f72b"]
    }],ExpressionUUID->"53c79f14-6421-4aa3-bb16-e3e6e04b1ed2"], 
    "\[SpanFromLeft]"}
  }]], "ObjectNameGrid",ExpressionUUID->"23315f5d-43cb-41f9-a028-\
6d9e83676370"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     "dPArgonNvdT[",
     StyleBox["T",
      FontSlant->"Italic"],
     ", \[Rho]] \[Congruent] ",
     Cell[BoxData[
      SubscriptBox[
       RowBox[{"(", 
        FractionBox[
         RowBox[{"\[PartialD]", 
          StyleBox["P",
           FontSlant->"Italic"]}], 
         RowBox[{"\[PartialD]", 
          StyleBox["T",
           FontSlant->"Italic"]}]], ")"}], 
       StyleBox["V",
        FontSlant->"Italic"]]],ExpressionUUID->
      "ca3c495b-5a10-4d13-bf58-c01ecfb90067"],
     "= ",
     Cell[BoxData[
      SubscriptBox["\[Gamma]", 
       StyleBox["V",
        FontSlant->"Italic"]]], "InlineFormula",
      FontFamily->"Source Sans Pro",ExpressionUUID->
      "dac921d0-6d85-4d80-a0f1-67b741452ae9"],
     " (bar/K)\nCoefficient de pression thermique en fonction de ",
     StyleBox["T",
      FontSlant->"Italic"],
     " (Kelvin) et de \[Rho] (g/",
     Cell[BoxData[
      SuperscriptBox["cm", "3"]], "InlineFormula",
      FontFamily->"Source Sans Pro",ExpressionUUID->
      "3addf3b5-fa43-4bf0-8f16-e5bde831d5f6"],
     ")  \n[Thermal-pressure coefficient versus ",
     StyleBox["T",
      FontSlant->"Italic"],
     " (Kelvin) and \[Rho] (g/",
     Cell[BoxData[
      SuperscriptBox["cm", "3"]], "InlineFormula",
      FontFamily->"Source Sans Pro",ExpressionUUID->
      "6b9ffb3a-6a47-40dd-ad97-6fe9211a264f"],
     ")]"
    }],ExpressionUUID->"040e10da-e9e7-4fd2-818c-eac79b37d3ba"]}
  }]], "Usage",ExpressionUUID->"2d8c68a8-241b-40ad-88f3-557d170a84d6"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[Cell[TextData[{
   Cell[BoxData[
    DynamicBox[ToBoxes[
      If[
       MatchQ[
        CurrentValue[
         EvaluationNotebook[], {TaggingRules, "Openers", "NotesSection"}, 
         Closed], 
        Alternatives[Open, True]], 
       Style[
        Graphics[{
          Thickness[0.18], 
          RGBColor[0.8509803921568627, 0.396078431372549, 0], 
          Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
         PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
        0.68 Inherited], 
       Rotate[
        Style[
         Graphics[{
           Thickness[0.18], 
           RGBColor[0.8509803921568627, 0.396078431372549, 0], 
           Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
          PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
         0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
     ImageSizeCache->{
      13.600000000000001`, {0.5800000000000001, 13.020000000000001`}}]],
    ExpressionUUID->"6b9205dc-492d-4d05-86d3-46166a7f08bb"],
   Cell[BoxData[
    TemplateBox[{1},
     "Spacer1"]],ExpressionUUID->"f2bec688-0684-4fe5-a4d3-66b6b19de7a6"],
   "Details and Options"
  }], "NotesFrameText",ExpressionUUID->"c541536d-c133-442b-9c21-cf7338865489"],
  Appearance->{Automatic, None, "Normal", Automatic},
  BaseStyle->None,
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"], 
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], After, CellContents]}]& ),
  Evaluator->None,
  Method->
   "Preemptive"]],ExpressionUUID->"44a157fe-570d-4ad9-8f1c-e3005d1da669"]], \
"NotesSection",
 WholeCellGroupOpener->True,
 CellGroupingRules->{"SectionGrouping", 50},
 CacheGraphics->False,
 CellID->163485631,ExpressionUUID->"9ab85a72-37df-46b4-bef2-debbc40d29ae"],

Cell[TextData[{
 "La fonction est d\[EAcute]finie pour ",
 StyleBox["T",
  FontSlant->"Italic"],
 " \[GreaterEqual] ",
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["ttr"]], "paclet:NewEoSArgon/ref/ttr", 
    "NewEoSArgon Package Symbol"},
   "PackageLink",
   BaseStyle->"InlineFormula"]], "InlineFormula",
  FontFamily->"Source Sans Pro",ExpressionUUID->
  "5f0b598c-bef3-41c8-8964-710c4a7072c7"],
 " et \[Rho] \[GreaterEqual] 0"
}], "Notes",
 CellID->1067943069,ExpressionUUID->"bf838369-f3e0-4556-9ccc-33d8bb1180df"],

Cell[TextData[{
 "La fonction ",
 Cell[BoxData[
  SubscriptBox["\[Gamma]", 
   StyleBox["V",
    FontSlant->"Italic"]]],ExpressionUUID->
  "c4e6935d-29d6-4dfd-8902-6196ce7c0f83"],
 "(",
 StyleBox["T",
  FontSlant->"Italic"],
 ", \[Rho]) est ici d\[EAcute]termin\[EAcute]e \[AGrave] partir de la \
relation suivante: ",
 Cell[BoxData[
  SubscriptBox["\[Gamma]", 
   StyleBox["V",
    FontSlant->"Italic"]]],ExpressionUUID->
  "373dfa93-f90b-4d7d-a00b-a66b4d931475"],
 " = \[Rho]",
 StyleBox["R",
  FontSlant->"Italic"],
 "Z + \[Rho]",
 StyleBox["RT",
  FontSlant->"Italic"],
 Cell[BoxData[
  SubscriptBox[
   RowBox[{"(", 
    FractionBox[
     RowBox[{"\[PartialD]", 
      StyleBox["Z",
       FontSlant->"Italic"]}], 
     RowBox[{"\[PartialD]", 
      StyleBox["T",
       FontSlant->"Italic"]}]], ")"}], 
   StyleBox["\[Rho]",
    FontSlant->"Italic"]]],ExpressionUUID->
  "7511717a-268e-4c16-bafa-2f796a9c0bcf"]
}], "Notes",
 CellID->524000197,ExpressionUUID->"cbbea908-d519-4bd2-8cc4-82b08dd86768"],

Cell["\<\
******************************************************************************\
*****\
\>", "Notes",
 CellID->185021568,ExpressionUUID->"f7ce3fa4-8b27-45dd-a5c6-67516c5e1d91"],

Cell[TextData[{
 "The function is defined for ",
 StyleBox["T",
  FontSlant->"Italic"],
 " \[GreaterEqual] ",
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["ttr"]], "paclet:NewEoSArgon/ref/ttr", 
    "NewEoSArgon Package Symbol"},
   "PackageLink",
   BaseStyle->"InlineFormula"]], "InlineFormula",
  FontFamily->"Source Sans Pro",ExpressionUUID->
  "5c3a1906-7bee-4ae7-9740-e2f6a9e5f0e2"],
 " and \[Rho] \[GreaterEqual] 0."
}], "Notes",
 CellID->175218415,ExpressionUUID->"0b8af056-205d-4a83-8b52-1c50534bea6b"],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  SubscriptBox["\[Gamma]", 
   StyleBox["V",
    FontSlant->"Italic"]]],ExpressionUUID->
  "4c455222-dc5a-44b2-bde3-c82df8e5d2f0"],
 "(",
 StyleBox["T",
  FontSlant->"Italic"],
 ", \[Rho]) function is determined here from the following relationship: ",
 Cell[BoxData[
  SubscriptBox["\[Gamma]", 
   StyleBox["V",
    FontSlant->"Italic"]]],ExpressionUUID->
  "841fb884-40c5-4a80-a2a6-39da4d17eba9"],
 " = \[Rho]",
 StyleBox["R",
  FontSlant->"Italic"],
 "Z + \[Rho]",
 StyleBox["RT",
  FontSlant->"Italic"],
 Cell[BoxData[
  SubscriptBox[
   RowBox[{"(", 
    FractionBox[
     RowBox[{"\[PartialD]", 
      StyleBox["Z",
       FontSlant->"Italic"]}], 
     RowBox[{"\[PartialD]", 
      StyleBox["T",
       FontSlant->"Italic"]}]], ")"}], 
   StyleBox["\[Rho]",
    FontSlant->"Italic"]]],ExpressionUUID->
  "34a36c7e-ddbc-4d2c-9dd8-d8c843e0d57b"]
}], "Notes",
 CellID->536882946,ExpressionUUID->"1b8687c6-250e-42c5-b5a1-5bbc9cce450f"]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "NotesSection"}, Closed]]]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {
       TaggingRules, "Openers", "PrimaryExamplesSection"}, Open], 
      Alternatives[True, Open]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{13.600000000000001`, {5., 8.600000000000001}}]],
  ExpressionUUID->"1269c941-b463-46a3-8488-b9605cf24179"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"05fc60e7-4469-4d29-b977-bae90bb95aa1"],
 "Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount",ExpressionUUID->
  "90da8ce9-0bfc-4c07-ae0c-5e74c83d2bca"]
}], "PrimaryExamplesSection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellTags->"PrimaryExamplesSection",
 CellID->164815156,ExpressionUUID->"00a93731-ddaf-4caa-8ba8-86023a93b065"],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"},
        Closed], 
      Alternatives[Open, True]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{13.600000000000001`, {5., 8.600000000000001}}]],
  ExpressionUUID->"2a4f4e9a-7950-4bf6-8c33-dd1e4227581d"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"5e27df7b-d595-4a1d-bf98-75631110a565"],
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "05c50a5b-dd0c-4025-9d19-85f753efd5d5"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellID->511559263,ExpressionUUID->"13369477-3942-4c59-8b44-1a0f379d4e5e"],

Cell[BoxData[{
 RowBox[{"Needs", "[", "\"\<NewEoSArgon`\>\"", "]"}], "\[IndentingNewLine]", 
 RowBox[{"Off", "[", 
  RowBox[{"General", "::", "munfl"}], "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->143015886,ExpressionUUID->"55ec19d3-d37e-4a88-b0d6-ef1ea7055aec"],

Cell[TextData[{
 "Calculated value of ",
 Cell[BoxData[
  SubscriptBox["\[Gamma]", 
   StyleBox["V",
    FontSlant->"Italic"]]], "InlineFormula",
  FontFamily->"Source Sans Pro",ExpressionUUID->
  "97f4118a-3bcd-42f0-a62b-7665d4dca8cb"],
 " for atmospheric pressure and 20\[Degree]C"
}], "ExampleText",
 CellID->544149791,ExpressionUUID->"df9f8cb0-70fa-41a0-85d9-d9e80a74909b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Quantity", "[", 
  RowBox[{
   RowBox[{"dPArgonNvdT", "[", 
    RowBox[{"293.15", ",", 
     RowBox[{"RhoArgonNv", "[", 
      RowBox[{"293.15", ",", 
       RowBox[{"QuantityMagnitude", "@", 
        RowBox[{"N", "@", 
         RowBox[{"UnitConvert", "[", 
          RowBox[{
           TemplateBox[{"1"},
            "QuantityUnit",
            DisplayFunction->(TooltipBox[
              StyleBox[
               RowBox[{#, "\[InvisibleSpace]", 
                 StyleBox[
                  RowBox[{" ", "\"atm\""}], "QuantityUnitTraditionalLabel"]}],
                ShowStringCharacters -> False], "Unit: atmospheres"]& ),
            InterpretationFunction->(RowBox[{"Quantity", "[", 
               RowBox[{#, ",", "\"Atmospheres\""}], "]"}]& )], ",", 
           "\"\<Bars\>\""}], "]"}]}]}], ",", "\"\<G\>\""}], "]"}]}], "]"}], 
   ",", "\"\<Bars/Kelvins\>\""}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->254692277,ExpressionUUID->"deffc7f1-2ee9-4a84-8573-6b5ccdbd2f69"],

Cell[BoxData[
 TemplateBox[{"0.0034648598393155114`", 
   RowBox[{
    "\"bar\"", "\[InvisibleSpace]", "\"/\"", "\[InvisibleSpace]", "\"K\""}], 
   "bars per kelvin", 
   FractionBox["\"Bars\"", "\"Kelvins\""]},
  "Quantity"]], "Output",
 CellLabel->"Out[2]=",
 CellID->197396477,ExpressionUUID->"99d81386-2395-4416-997e-180ae839b5e3"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UnitConvert", "[", 
  RowBox[{
   TemplateBox[{"0.0034648598393155114`"},
    "QuantityUnit",
    DisplayFunction->(TooltipBox[
      StyleBox[
       RowBox[{#, "\[InvisibleSpace]", 
         StyleBox[
          RowBox[{" ", 
            
            RowBox[{"\"bars\"", "\[InvisibleSpace]", "\"/\"", 
              "\[InvisibleSpace]", "\"K\""}]}], 
          "QuantityUnitTraditionalLabel"]}], ShowStringCharacters -> False], 
      "Unit: bars per kelvin difference"]& ),
    InterpretationFunction->(RowBox[{"Quantity", "[", 
       RowBox[{#, ",", 
         FractionBox["\"Bars\"", "\"KelvinsDifference\""]}], "]"}]& )], ",", 
   "\"\<MPa/K\>\""}], "]"}]], "Input",
 NumberMarks->False,
 CellLabel->"In[3]:=",
 CellID->153659259,ExpressionUUID->"29681f2a-4b6e-4858-b96a-af78bca3f930"],

Cell[BoxData[
 TemplateBox[{"0.00034648598393155114`", 
   RowBox[{
    "\"MPa\"", "\[InvisibleSpace]", "\"/\"", "\[InvisibleSpace]", "\"K\""}], 
   "megapascals per kelvin", 
   FractionBox["\"Megapascals\"", "\"Kelvins\""]},
  "Quantity"]], "Output",
 CellLabel->"Out[3]=",
 CellID->219615560,ExpressionUUID->"c32d4ae9-6dd4-4c20-82e0-d0ded5492342"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UnitConvert", "[", 
  RowBox[{
   TemplateBox[{"0.00034648598393155114`"},
    "QuantityUnit",
    DisplayFunction->(TooltipBox[
      StyleBox[
       RowBox[{#, "\[InvisibleSpace]", 
         StyleBox[
          RowBox[{" ", 
            
            RowBox[{"\"MPa\"", "\[InvisibleSpace]", "\"/\"", 
              "\[InvisibleSpace]", "\"K\""}]}], 
          "QuantityUnitTraditionalLabel"]}], ShowStringCharacters -> False], 
      "Unit: megapascals per kelvin difference"]& ),
    InterpretationFunction->(RowBox[{"Quantity", "[", 
       RowBox[{#, ",", 
         FractionBox["\"Megapascals\"", "\"KelvinsDifference\""]}], "]"}]& )],
    ",", "\"\<Atmospheres/KelvinsDifference\>\""}], "]"}]], "Input",
 NumberMarks->False,
 CellLabel->"In[4]:=",
 CellID->106075116,ExpressionUUID->"dfb00744-9f4c-48f0-a333-5803b9f789ae"],

Cell[BoxData[
 TemplateBox[{"0.003419550791330384`", 
   RowBox[{
    "\"atm\"", "\[InvisibleSpace]", "\"/\"", "\[InvisibleSpace]", "\"K\""}], 
   "atmospheres per kelvin", 
   FractionBox["\"Atmospheres\"", "\"Kelvins\""]},
  "Quantity"]], "Output",
 CellLabel->"Out[4]=",
 CellID->63089429,ExpressionUUID->"02343666-c721-4812-938a-131a095a6f1b"]
}, Open  ]],

Cell["Using ThermodynamicData package (i.e. REFPROP from NIST)", "ExampleText",
 CellID->361149294,ExpressionUUID->"1adaae23-908e-4b78-bde7-9c060f62e9e4"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UnitConvert", "[", 
  RowBox[{
   RowBox[{"ThermodynamicData", "[", 
    RowBox[{
    "\"\<Argon\>\"", ",", 
     "\"\<FirstDerivativeOfPressureWithRespectToTemperature\>\"", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<Pressure\>\"", "\[Rule]", 
        RowBox[{"Quantity", "[", 
         RowBox[{"1", ",", "\"\<Atmospheres\>\""}], "]"}]}], ",", 
       RowBox[{"\"\<Temperature\>\"", "\[Rule]", 
        RowBox[{"Quantity", "[", 
         RowBox[{"293.15", ",", "\"\<Kelvins\>\""}], "]"}]}]}], "}"}]}], 
    "]"}], ",", "\"\<Bars/Kelvins\>\""}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->375583457,ExpressionUUID->"fafde767-0bcd-4459-b55d-bf9ec5f5760e"],

Cell[BoxData[
 TemplateBox[{"0.0034653510800446686`", 
   RowBox[{
    "\"bar\"", "\[InvisibleSpace]", "\"/\"", "\[InvisibleSpace]", "\"K\""}], 
   "bars per kelvin", 
   FractionBox["\"Bars\"", "\"Kelvins\""]},
  "Quantity"]], "Output",
 CellLabel->"Out[5]=",
 CellID->60093725,ExpressionUUID->"55be8e8e-7ca1-41e5-b1c6-8a3c8a2256b5"]
}, Open  ]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"}, 
  Closed]]]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "2"},
        Closed], 
      Alternatives[Open, True]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{
    13.600000000000001`, {0.5800000000000001, 13.020000000000001`}}]],
  ExpressionUUID->"c52ca659-2497-4dc9-845c-0bb5542e917c"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"b2720d61-bde2-42dc-a9ed-c282f6322360"],
 "Applications",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "883df556-d7df-4c84-8440-f9bcc5cc1e3b"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellID->258228157,ExpressionUUID->"5721227d-c1be-4f8b-b3ba-6a9f2e44860c"],

Cell[BoxData[{
 RowBox[{"Needs", "[", "\"\<NewEoSArgon`\>\"", "]"}], "\[IndentingNewLine]", 
 RowBox[{"Off", "[", 
  RowBox[{"General", "::", "munfl"}], "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->279378555,ExpressionUUID->"93886600-5b99-485a-82f9-c34ab71889e7"],

Cell["\<\
Comparison with Streett data (Physica 76, 1974) on an isotherm close to the \
critical isotherm\
\>", "ExampleText",
 CellID->227520913,ExpressionUUID->"dbcb60d0-d986-42d8-9482-4fffe59e0499"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"dataStreett150", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"80", ",", "5.26"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"100", ",", "5.96"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"200", ",", "8.27"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"400", ",", "11.1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"600", ",", "13.2"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"800", ",", "14.9"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1000", ",", "16.4"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1200", ",", "17.7"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1400", ",", "18.9"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1600", ",", "20"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1800", ",", "21"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"2000", ",", "21.9"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"2200", ",", "22.8"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"2400", ",", "23.6"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"2600", ",", "24.4"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"2800", ",", "25.1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"3000", ",", "25.8"}], "}"}]}], "}"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"atm", ",", 
    RowBox[{"atm", "/", "K"}]}], "*)"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->243734080,ExpressionUUID->"f41602c0-441e-4568-9ca9-4851e8e30ca9"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"data150", "=", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"dataStreett150", "[", 
         RowBox[{"[", 
          RowBox[{"i", ",", "1"}], "]"}], "]"}], ",", 
        RowBox[{
         RowBox[{"dPArgonNvdT", "[", 
          RowBox[{"150", ",", 
           RowBox[{"RhoArgonNv", "[", 
            RowBox[{"150", ",", 
             RowBox[{
              RowBox[{"dataStreett150", "[", 
               RowBox[{"[", 
                RowBox[{"i", ",", "1"}], "]"}], "]"}], "*", "1.01325"}]}], 
            "]"}]}], "]"}], "/", "1.01325"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "1", ",", 
        RowBox[{"Length", "@", "dataStreett150"}]}], "}"}]}], "]"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"atm", ",", 
    RowBox[{"atm", "/", "K"}]}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"AppendTo", "[", 
   RowBox[{"data150", ",", 
    RowBox[{"{", 
     RowBox[{"300", ",", 
      RowBox[{
       RowBox[{"dPArgonNvdT", "[", 
        RowBox[{"150", ",", 
         RowBox[{"RhoArgonNv", "[", 
          RowBox[{"150", ",", 
           RowBox[{"300", "*", "1.01325"}]}], "]"}]}], "]"}], "/", 
       "1.01325"}]}], "}"}]}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"\[Gamma]V", "=", 
  RowBox[{"Interpolation", "[", "data150", "]"}]}]}], "Input",
 CellLabel->"In[3]:=",
 CellID->123312038,ExpressionUUID->"da26ac08-1328-4efa-abea-11b6fe36da37"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox["InterpolatingFunction",
    "SummaryHead"], "[", 
   DynamicModuleBox[{Typeset`open$$ = False, Typeset`embedState$$ = "Ready"}, 
    TemplateBox[{
      PaneSelectorBox[{False -> GridBox[{{
            PaneBox[
             ButtonBox[
              DynamicBox[
               FEPrivate`FrontEndResource["FEBitmaps", "SummaryBoxOpener"]], 
              ButtonFunction :> (Typeset`open$$ = True), Appearance -> None, 
              BaseStyle -> {}, Evaluator -> Automatic, Method -> 
              "Preemptive"], Alignment -> {Center, Center}, ImageSize -> 
             Dynamic[{
               Automatic, 
                3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}]], 
            GraphicsBox[
             InterpretationBox[{
               TagBox[{{{{}, {}, 
                   TagBox[{
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                    LineBox[CompressedData["
1:eJwVxXswGwYAB+CgvbWdSTyyGaUclcY7iSRMu/2u8ajRdl7TetdwVXVKtV7V
UvFskBQh6hGJoM7pekxpaHFkmmYcd/Xco82qtIu6aaubGtv++O6zjEkOiNMm
EAiH//P/GvPqSQIhCDEm7FZiFxk+QXxu5osoBDyfbmDMmMI48uwlUXw8/Hjq
plwrC6hqLvgXnT8PirCvyH7EEk8ds/aY2qagUNI5oLaxQk5kWZV2ZBpirw5a
v8u0xibf6Ad6WDpiNBGPWXUHYUJa1bpYm4Xt9AzpP/dsEBqcP1SpyAEn/n1r
+CAFgxOKku3IXGROKwwo4kMwF6X5yDfz4OEW9sa7kIq12PDA/dn5mLhg3z4c
YIspQyvh6hsuPLx7dxIM7bArwWBNwSuEuls5Kl6wQ9tD95se+4pRk0vyDuXZ
49ZAma+yrQRuT+aUW54OENc/ODJ05AZqms23Tm04wOgqNSu0jwebkIhEp2pH
LOweVG0FlIPpV8qZc3cCqaI0gTNdgThhrPznaSf4RkHvUR8fT7XCq4zcnCFc
seW2cwVQKKJ4uwqcIUqlH1g4ehPv3aOT/nrkjLGTJ8aI+pXw55AkiwY03HYo
4tdMVWIz7OLpr4NpIOc4ZYSUV0El1R/5o4qGjgOac6Zh1bjG6rGMnKNhY2Ts
Os1ECIvfH3a8JtOR2N8t830phFsvyccrhI6zlvpLDT016HV1/HGfkA6z0hs+
R1NrUbDY4Xtuko4Pnib9r74SgR7GbEjSZUCgrTi+tCOCNMaB6u/BwB3nZ9uf
DdRBXOY6bpPFwMZdkvxE8S1cIq47VXQz8I4RUT/rVQ9duyW++woD+/c+KI4l
NyDba3MxycIFH351r+PMNEBglLthGuSCGBvqeGhlI0ThnT3kQhesD9lqXY5u
gkVqCLla7gKzrpY7fxLFUEv0BC81Lvj24JexHeli3E6sXR6yZCIwmEi59osY
W8Srx0nBTHTuTt66crgZPxmk5GRymRD9dmr2irQZxl7y6fR7TKjdpkZlOhLw
4sh9379gYs0vb+jVGQkcZyPI7UYsCErkw7RxCcbWsgUMLxYqvLhPmilSON+1
bqSlsWDpMPvasEKKiZW870ZlLKSrznwqeStFvMpu3X6GBaom65vTgS3o11ea
mOmwkcw05xvcb0FX0EdJnQw29HdOqt9+LsPycMHUZDQbx9Y//mI+T4br8wTj
QgEbnMadpvllGaqmdMnUYTbqlHnGOt6toHakeKasslFgUS507GpFE1OpOWbm
CtXGIUq+XhueUyjPJnxcsTck/++d5DY8zvhk7P5lV/wLXvquzQ==
                    "]]}, Annotation[#, "Charting`Private`Tag#1"]& ]}}, {}}, {
                "WolframDynamicHighlight", <|
                 "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>}], 
               DynamicBox[
                (Charting`HighlightActionBox["DynamicHighlight", {}, 
                 Slot["HighlightElements"], 
                 Slot["LayoutOptions"], 
                 Slot["Meta"], 
                 Charting`HighlightActionFunction[
                 "DynamicHighlight", {{{{}, {}, 
                    Annotation[{
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                    Line[CompressedData["
1:eJwVxXswGwYAB+CgvbWdSTyyGaUclcY7iSRMu/2u8ajRdl7TetdwVXVKtV7V
UvFskBQh6hGJoM7pekxpaHFkmmYcd/Xco82qtIu6aaubGtv++O6zjEkOiNMm
EAiH//P/GvPqSQIhCDEm7FZiFxk+QXxu5osoBDyfbmDMmMI48uwlUXw8/Hjq
plwrC6hqLvgXnT8PirCvyH7EEk8ds/aY2qagUNI5oLaxQk5kWZV2ZBpirw5a
v8u0xibf6Ad6WDpiNBGPWXUHYUJa1bpYm4Xt9AzpP/dsEBqcP1SpyAEn/n1r
+CAFgxOKku3IXGROKwwo4kMwF6X5yDfz4OEW9sa7kIq12PDA/dn5mLhg3z4c
YIspQyvh6hsuPLx7dxIM7bArwWBNwSuEuls5Kl6wQ9tD95se+4pRk0vyDuXZ
49ZAma+yrQRuT+aUW54OENc/ODJ05AZqms23Tm04wOgqNSu0jwebkIhEp2pH
LOweVG0FlIPpV8qZc3cCqaI0gTNdgThhrPznaSf4RkHvUR8fT7XCq4zcnCFc
seW2cwVQKKJ4uwqcIUqlH1g4ehPv3aOT/nrkjLGTJ8aI+pXw55AkiwY03HYo
4tdMVWIz7OLpr4NpIOc4ZYSUV0El1R/5o4qGjgOac6Zh1bjG6rGMnKNhY2Ts
Os1ECIvfH3a8JtOR2N8t830phFsvyccrhI6zlvpLDT016HV1/HGfkA6z0hs+
R1NrUbDY4Xtuko4Pnib9r74SgR7GbEjSZUCgrTi+tCOCNMaB6u/BwB3nZ9uf
DdRBXOY6bpPFwMZdkvxE8S1cIq47VXQz8I4RUT/rVQ9duyW++woD+/c+KI4l
NyDba3MxycIFH351r+PMNEBglLthGuSCGBvqeGhlI0ThnT3kQhesD9lqXY5u
gkVqCLla7gKzrpY7fxLFUEv0BC81Lvj24JexHeli3E6sXR6yZCIwmEi59osY
W8Srx0nBTHTuTt66crgZPxmk5GRymRD9dmr2irQZxl7y6fR7TKjdpkZlOhLw
4sh9379gYs0vb+jVGQkcZyPI7UYsCErkw7RxCcbWsgUMLxYqvLhPmilSON+1
bqSlsWDpMPvasEKKiZW870ZlLKSrznwqeStFvMpu3X6GBaom65vTgS3o11ea
mOmwkcw05xvcb0FX0EdJnQw29HdOqt9+LsPycMHUZDQbx9Y//mI+T4br8wTj
QgEbnMadpvllGaqmdMnUYTbqlHnGOt6toHakeKasslFgUS507GpFE1OpOWbm
CtXGIUq+XhueUyjPJnxcsTck/++d5DY8zvhk7P5lV/wLXvquzQ==
                    "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
                  "HighlightElements" -> <|
                    "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
                   "LayoutOptions" -> <|
                    "PlotRange" -> {{80., 3000.}, {5.419981572259163, 
                    24.463787380017305`}}, 
                    "Frame" -> {{True, True}, {True, True}}, 
                    "AxesOrigin" -> {0, 5.419981572259175}, 
                    "ImageSize" -> {360, 360}, "Axes" -> {False, False}, 
                    "LabelStyle" -> {}, "AspectRatio" -> 1, "DefaultStyle" -> {
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]]}, 
                    "HighlightLabelingFunctions" -> <|
                    "CoordinatesToolOptions" -> ({
                    Identity[
                    Part[#, 1]], 
                    Identity[
                    Part[#, 2]]}& ), 
                    "ScalingFunctions" -> {{Identity, Identity}, {
                    Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
                    False|>, 
                   "Meta" -> <|
                    "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, 
                    "Function" -> Plot, "GroupHighlight" -> False|>|>]]& )[<|
                 "HighlightElements" -> <|
                   "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
                  "LayoutOptions" -> <|
                   "PlotRange" -> {{80., 3000.}, {5.419981572259163, 
                    24.463787380017305`}}, 
                    "Frame" -> {{True, True}, {True, True}}, 
                    "AxesOrigin" -> {0, 5.419981572259175}, 
                    "ImageSize" -> {360, 360}, "Axes" -> {False, False}, 
                    "LabelStyle" -> {}, "AspectRatio" -> 1, "DefaultStyle" -> {
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]]}, 
                    "HighlightLabelingFunctions" -> <|
                    "CoordinatesToolOptions" -> ({
                    Identity[
                    Part[#, 1]], 
                    Identity[
                    Part[#, 2]]}& ), 
                    "ScalingFunctions" -> {{Identity, Identity}, {
                    Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
                    False|>, 
                  "Meta" -> <|
                   "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, 
                    "Function" -> Plot, "GroupHighlight" -> False|>|>]]}, 
              Annotation[{{{{}, {}, 
                  Annotation[{
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                    Line[CompressedData["
1:eJwVxXswGwYAB+CgvbWdSTyyGaUclcY7iSRMu/2u8ajRdl7TetdwVXVKtV7V
UvFskBQh6hGJoM7pekxpaHFkmmYcd/Xco82qtIu6aaubGtv++O6zjEkOiNMm
EAiH//P/GvPqSQIhCDEm7FZiFxk+QXxu5osoBDyfbmDMmMI48uwlUXw8/Hjq
plwrC6hqLvgXnT8PirCvyH7EEk8ds/aY2qagUNI5oLaxQk5kWZV2ZBpirw5a
v8u0xibf6Ad6WDpiNBGPWXUHYUJa1bpYm4Xt9AzpP/dsEBqcP1SpyAEn/n1r
+CAFgxOKku3IXGROKwwo4kMwF6X5yDfz4OEW9sa7kIq12PDA/dn5mLhg3z4c
YIspQyvh6hsuPLx7dxIM7bArwWBNwSuEuls5Kl6wQ9tD95se+4pRk0vyDuXZ
49ZAma+yrQRuT+aUW54OENc/ODJ05AZqms23Tm04wOgqNSu0jwebkIhEp2pH
LOweVG0FlIPpV8qZc3cCqaI0gTNdgThhrPznaSf4RkHvUR8fT7XCq4zcnCFc
seW2cwVQKKJ4uwqcIUqlH1g4ehPv3aOT/nrkjLGTJ8aI+pXw55AkiwY03HYo
4tdMVWIz7OLpr4NpIOc4ZYSUV0El1R/5o4qGjgOac6Zh1bjG6rGMnKNhY2Ts
Os1ECIvfH3a8JtOR2N8t830phFsvyccrhI6zlvpLDT016HV1/HGfkA6z0hs+
R1NrUbDY4Xtuko4Pnib9r74SgR7GbEjSZUCgrTi+tCOCNMaB6u/BwB3nZ9uf
DdRBXOY6bpPFwMZdkvxE8S1cIq47VXQz8I4RUT/rVQ9duyW++woD+/c+KI4l
NyDba3MxycIFH351r+PMNEBglLthGuSCGBvqeGhlI0ThnT3kQhesD9lqXY5u
gkVqCLla7gKzrpY7fxLFUEv0BC81Lvj24JexHeli3E6sXR6yZCIwmEi59osY
W8Srx0nBTHTuTt66crgZPxmk5GRymRD9dmr2irQZxl7y6fR7TKjdpkZlOhLw
4sh9379gYs0vb+jVGQkcZyPI7UYsCErkw7RxCcbWsgUMLxYqvLhPmilSON+1
bqSlsWDpMPvasEKKiZW870ZlLKSrznwqeStFvMpu3X6GBaom65vTgS3o11ea
mOmwkcw05xvcb0FX0EdJnQw29HdOqt9+LsPycMHUZDQbx9Y//mI+T4br8wTj
QgEbnMadpvllGaqmdMnUYTbqlHnGOt6toHakeKasslFgUS507GpFE1OpOWbm
CtXGIUq+XhueUyjPJnxcsTck/++d5DY8zvhk7P5lV/wLXvquzQ==
                    "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
               "HighlightElements" -> <|
                 "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
                "LayoutOptions" -> <|
                 "PlotRange" -> {{80., 3000.}, {5.419981572259163, 
                   24.463787380017305`}}, 
                  "Frame" -> {{True, True}, {True, True}}, 
                  "AxesOrigin" -> {0, 5.419981572259175}, 
                  "ImageSize" -> {360, 360}, "Axes" -> {False, False}, 
                  "LabelStyle" -> {}, "AspectRatio" -> 1, "DefaultStyle" -> {
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]]}, 
                  "HighlightLabelingFunctions" -> <|
                   "CoordinatesToolOptions" -> ({
                    Identity[
                    Part[#, 1]], 
                    Identity[
                    Part[#, 2]]}& ), 
                    "ScalingFunctions" -> {{Identity, Identity}, {
                    Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
                  False|>, 
                "Meta" -> <|
                 "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, 
                  "Function" -> Plot, "GroupHighlight" -> False|>|>, 
               "DynamicHighlight"]], {
             DisplayFunction -> Identity, DisplayFunction -> Identity, 
              Ticks -> {Automatic, Automatic}, 
              AxesOrigin -> {0, 5.419981572259175}, 
              FrameTicks -> {{{}, {}}, {{}, {}}}, GridLines -> {None, None}, 
              DisplayFunction -> Identity, PlotRangePadding -> {{
                 Scaled[0.1], 
                 Scaled[0.1]}, {
                 Scaled[0.1], 
                 Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
              All, DisplayFunction -> Identity, AspectRatio -> 1, 
              Axes -> {False, False}, AxesLabel -> {None, None}, 
              AxesOrigin -> {0, 5.419981572259163}, DisplayFunction :> 
              Identity, Frame -> {{True, True}, {True, True}}, 
              FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
              Directive[
                Opacity[0.5], 
                Thickness[Tiny], 
                RGBColor[0.368417, 0.506779, 0.709798]], 
              FrameTicks -> {{None, None}, {None, None}}, 
              GridLines -> {None, None}, GridLinesStyle -> Directive[
                GrayLevel[0.5, 0.4]], ImageSize -> 
              Dynamic[{
                Automatic, 
                 3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                  Magnification])}], 
              Method -> {
               "DefaultBoundaryStyle" -> Automatic, 
                "DefaultGraphicsInteraction" -> {
                 "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
                  "Effects" -> {
                   "Highlight" -> {"ratio" -> 2}, 
                    "HighlightPoint" -> {"ratio" -> 2}, 
                    "Droplines" -> {
                    "freeformCursorMode" -> True, 
                    "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
                "DefaultMeshStyle" -> AbsolutePointSize[6], 
                "ScalingFunctions" -> None, 
                "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
                    (Identity[#]& )[
                    Part[#, 1]], 
                    (Identity[#]& )[
                    Part[#, 2]]}& ), "CopiedValueFunction" -> ({
                    (Identity[#]& )[
                    Part[#, 1]], 
                    (Identity[#]& )[
                    Part[#, 2]]}& )}}, 
              PlotRange -> {{80., 3000.}, {5.419981572259163, 
               24.463787380017305`}}, PlotRangeClipping -> True, 
              PlotRangePadding -> {{
                 Scaled[0.1], 
                 Scaled[0.1]}, {
                 Scaled[0.1], 
                 Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
            GridBox[{{
               RowBox[{
                 TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                 "\[InvisibleSpace]", 
                 TagBox[
                  RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{"80.`", ",", "3000.`"}], "}"}], "}"}], 
                  "SummaryItem"]}]}, {
               RowBox[{
                 TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                 "\[InvisibleSpace]", 
                 TagBox["\"scalar\"", "SummaryItem"]}]}}, 
             GridBoxAlignment -> {
              "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, AutoDelete -> 
             False, GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{2}}, "Rows" -> {{Automatic}}},
              BaseStyle -> {
              ShowStringCharacters -> False, NumberMarks -> False, 
               PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
          GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
          AutoDelete -> False, 
          GridBoxItemSize -> {
           "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
          BaselinePosition -> {1, 1}], True -> GridBox[{{
            PaneBox[
             ButtonBox[
              DynamicBox[
               FEPrivate`FrontEndResource["FEBitmaps", "SummaryBoxCloser"]], 
              ButtonFunction :> (Typeset`open$$ = False), Appearance -> None, 
              BaseStyle -> {}, Evaluator -> Automatic, Method -> 
              "Preemptive"], Alignment -> {Center, Center}, ImageSize -> 
             Dynamic[{
               Automatic, 
                3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}]], 
            GraphicsBox[
             InterpretationBox[{
               TagBox[{{{{}, {}, 
                   TagBox[{
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                    LineBox[CompressedData["
1:eJwVxXswGwYAB+CgvbWdSTyyGaUclcY7iSRMu/2u8ajRdl7TetdwVXVKtV7V
UvFskBQh6hGJoM7pekxpaHFkmmYcd/Xco82qtIu6aaubGtv++O6zjEkOiNMm
EAiH//P/GvPqSQIhCDEm7FZiFxk+QXxu5osoBDyfbmDMmMI48uwlUXw8/Hjq
plwrC6hqLvgXnT8PirCvyH7EEk8ds/aY2qagUNI5oLaxQk5kWZV2ZBpirw5a
v8u0xibf6Ad6WDpiNBGPWXUHYUJa1bpYm4Xt9AzpP/dsEBqcP1SpyAEn/n1r
+CAFgxOKku3IXGROKwwo4kMwF6X5yDfz4OEW9sa7kIq12PDA/dn5mLhg3z4c
YIspQyvh6hsuPLx7dxIM7bArwWBNwSuEuls5Kl6wQ9tD95se+4pRk0vyDuXZ
49ZAma+yrQRuT+aUW54OENc/ODJ05AZqms23Tm04wOgqNSu0jwebkIhEp2pH
LOweVG0FlIPpV8qZc3cCqaI0gTNdgThhrPznaSf4RkHvUR8fT7XCq4zcnCFc
seW2cwVQKKJ4uwqcIUqlH1g4ehPv3aOT/nrkjLGTJ8aI+pXw55AkiwY03HYo
4tdMVWIz7OLpr4NpIOc4ZYSUV0El1R/5o4qGjgOac6Zh1bjG6rGMnKNhY2Ts
Os1ECIvfH3a8JtOR2N8t830phFsvyccrhI6zlvpLDT016HV1/HGfkA6z0hs+
R1NrUbDY4Xtuko4Pnib9r74SgR7GbEjSZUCgrTi+tCOCNMaB6u/BwB3nZ9uf
DdRBXOY6bpPFwMZdkvxE8S1cIq47VXQz8I4RUT/rVQ9duyW++woD+/c+KI4l
NyDba3MxycIFH351r+PMNEBglLthGuSCGBvqeGhlI0ThnT3kQhesD9lqXY5u
gkVqCLla7gKzrpY7fxLFUEv0BC81Lvj24JexHeli3E6sXR6yZCIwmEi59osY
W8Srx0nBTHTuTt66crgZPxmk5GRymRD9dmr2irQZxl7y6fR7TKjdpkZlOhLw
4sh9379gYs0vb+jVGQkcZyPI7UYsCErkw7RxCcbWsgUMLxYqvLhPmilSON+1
bqSlsWDpMPvasEKKiZW870ZlLKSrznwqeStFvMpu3X6GBaom65vTgS3o11ea
mOmwkcw05xvcb0FX0EdJnQw29HdOqt9+LsPycMHUZDQbx9Y//mI+T4br8wTj
QgEbnMadpvllGaqmdMnUYTbqlHnGOt6toHakeKasslFgUS507GpFE1OpOWbm
CtXGIUq+XhueUyjPJnxcsTck/++d5DY8zvhk7P5lV/wLXvquzQ==
                    "]]}, Annotation[#, "Charting`Private`Tag#1"]& ]}}, {}}, {
                "WolframDynamicHighlight", <|
                 "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>}], 
               DynamicBox[
                (Charting`HighlightActionBox["DynamicHighlight", {}, 
                 Slot["HighlightElements"], 
                 Slot["LayoutOptions"], 
                 Slot["Meta"], 
                 Charting`HighlightActionFunction[
                 "DynamicHighlight", {{{{}, {}, 
                    Annotation[{
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                    Line[CompressedData["
1:eJwVxXswGwYAB+CgvbWdSTyyGaUclcY7iSRMu/2u8ajRdl7TetdwVXVKtV7V
UvFskBQh6hGJoM7pekxpaHFkmmYcd/Xco82qtIu6aaubGtv++O6zjEkOiNMm
EAiH//P/GvPqSQIhCDEm7FZiFxk+QXxu5osoBDyfbmDMmMI48uwlUXw8/Hjq
plwrC6hqLvgXnT8PirCvyH7EEk8ds/aY2qagUNI5oLaxQk5kWZV2ZBpirw5a
v8u0xibf6Ad6WDpiNBGPWXUHYUJa1bpYm4Xt9AzpP/dsEBqcP1SpyAEn/n1r
+CAFgxOKku3IXGROKwwo4kMwF6X5yDfz4OEW9sa7kIq12PDA/dn5mLhg3z4c
YIspQyvh6hsuPLx7dxIM7bArwWBNwSuEuls5Kl6wQ9tD95se+4pRk0vyDuXZ
49ZAma+yrQRuT+aUW54OENc/ODJ05AZqms23Tm04wOgqNSu0jwebkIhEp2pH
LOweVG0FlIPpV8qZc3cCqaI0gTNdgThhrPznaSf4RkHvUR8fT7XCq4zcnCFc
seW2cwVQKKJ4uwqcIUqlH1g4ehPv3aOT/nrkjLGTJ8aI+pXw55AkiwY03HYo
4tdMVWIz7OLpr4NpIOc4ZYSUV0El1R/5o4qGjgOac6Zh1bjG6rGMnKNhY2Ts
Os1ECIvfH3a8JtOR2N8t830phFsvyccrhI6zlvpLDT016HV1/HGfkA6z0hs+
R1NrUbDY4Xtuko4Pnib9r74SgR7GbEjSZUCgrTi+tCOCNMaB6u/BwB3nZ9uf
DdRBXOY6bpPFwMZdkvxE8S1cIq47VXQz8I4RUT/rVQ9duyW++woD+/c+KI4l
NyDba3MxycIFH351r+PMNEBglLthGuSCGBvqeGhlI0ThnT3kQhesD9lqXY5u
gkVqCLla7gKzrpY7fxLFUEv0BC81Lvj24JexHeli3E6sXR6yZCIwmEi59osY
W8Srx0nBTHTuTt66crgZPxmk5GRymRD9dmr2irQZxl7y6fR7TKjdpkZlOhLw
4sh9379gYs0vb+jVGQkcZyPI7UYsCErkw7RxCcbWsgUMLxYqvLhPmilSON+1
bqSlsWDpMPvasEKKiZW870ZlLKSrznwqeStFvMpu3X6GBaom65vTgS3o11ea
mOmwkcw05xvcb0FX0EdJnQw29HdOqt9+LsPycMHUZDQbx9Y//mI+T4br8wTj
QgEbnMadpvllGaqmdMnUYTbqlHnGOt6toHakeKasslFgUS507GpFE1OpOWbm
CtXGIUq+XhueUyjPJnxcsTck/++d5DY8zvhk7P5lV/wLXvquzQ==
                    "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
                  "HighlightElements" -> <|
                    "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
                   "LayoutOptions" -> <|
                    "PlotRange" -> {{80., 3000.}, {5.419981572259163, 
                    24.463787380017305`}}, 
                    "Frame" -> {{True, True}, {True, True}}, 
                    "AxesOrigin" -> {0, 5.419981572259175}, 
                    "ImageSize" -> {360, 360}, "Axes" -> {False, False}, 
                    "LabelStyle" -> {}, "AspectRatio" -> 1, "DefaultStyle" -> {
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]]}, 
                    "HighlightLabelingFunctions" -> <|
                    "CoordinatesToolOptions" -> ({
                    Identity[
                    Part[#, 1]], 
                    Identity[
                    Part[#, 2]]}& ), 
                    "ScalingFunctions" -> {{Identity, Identity}, {
                    Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
                    False|>, 
                   "Meta" -> <|
                    "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, 
                    "Function" -> Plot, "GroupHighlight" -> False|>|>]]& )[<|
                 "HighlightElements" -> <|
                   "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
                  "LayoutOptions" -> <|
                   "PlotRange" -> {{80., 3000.}, {5.419981572259163, 
                    24.463787380017305`}}, 
                    "Frame" -> {{True, True}, {True, True}}, 
                    "AxesOrigin" -> {0, 5.419981572259175}, 
                    "ImageSize" -> {360, 360}, "Axes" -> {False, False}, 
                    "LabelStyle" -> {}, "AspectRatio" -> 1, "DefaultStyle" -> {
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]]}, 
                    "HighlightLabelingFunctions" -> <|
                    "CoordinatesToolOptions" -> ({
                    Identity[
                    Part[#, 1]], 
                    Identity[
                    Part[#, 2]]}& ), 
                    "ScalingFunctions" -> {{Identity, Identity}, {
                    Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
                    False|>, 
                  "Meta" -> <|
                   "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, 
                    "Function" -> Plot, "GroupHighlight" -> False|>|>]]}, 
              Annotation[{{{{}, {}, 
                  Annotation[{
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                    Line[CompressedData["
1:eJwVxXswGwYAB+CgvbWdSTyyGaUclcY7iSRMu/2u8ajRdl7TetdwVXVKtV7V
UvFskBQh6hGJoM7pekxpaHFkmmYcd/Xco82qtIu6aaubGtv++O6zjEkOiNMm
EAiH//P/GvPqSQIhCDEm7FZiFxk+QXxu5osoBDyfbmDMmMI48uwlUXw8/Hjq
plwrC6hqLvgXnT8PirCvyH7EEk8ds/aY2qagUNI5oLaxQk5kWZV2ZBpirw5a
v8u0xibf6Ad6WDpiNBGPWXUHYUJa1bpYm4Xt9AzpP/dsEBqcP1SpyAEn/n1r
+CAFgxOKku3IXGROKwwo4kMwF6X5yDfz4OEW9sa7kIq12PDA/dn5mLhg3z4c
YIspQyvh6hsuPLx7dxIM7bArwWBNwSuEuls5Kl6wQ9tD95se+4pRk0vyDuXZ
49ZAma+yrQRuT+aUW54OENc/ODJ05AZqms23Tm04wOgqNSu0jwebkIhEp2pH
LOweVG0FlIPpV8qZc3cCqaI0gTNdgThhrPznaSf4RkHvUR8fT7XCq4zcnCFc
seW2cwVQKKJ4uwqcIUqlH1g4ehPv3aOT/nrkjLGTJ8aI+pXw55AkiwY03HYo
4tdMVWIz7OLpr4NpIOc4ZYSUV0El1R/5o4qGjgOac6Zh1bjG6rGMnKNhY2Ts
Os1ECIvfH3a8JtOR2N8t830phFsvyccrhI6zlvpLDT016HV1/HGfkA6z0hs+
R1NrUbDY4Xtuko4Pnib9r74SgR7GbEjSZUCgrTi+tCOCNMaB6u/BwB3nZ9uf
DdRBXOY6bpPFwMZdkvxE8S1cIq47VXQz8I4RUT/rVQ9duyW++woD+/c+KI4l
NyDba3MxycIFH351r+PMNEBglLthGuSCGBvqeGhlI0ThnT3kQhesD9lqXY5u
gkVqCLla7gKzrpY7fxLFUEv0BC81Lvj24JexHeli3E6sXR6yZCIwmEi59osY
W8Srx0nBTHTuTt66crgZPxmk5GRymRD9dmr2irQZxl7y6fR7TKjdpkZlOhLw
4sh9379gYs0vb+jVGQkcZyPI7UYsCErkw7RxCcbWsgUMLxYqvLhPmilSON+1
bqSlsWDpMPvasEKKiZW870ZlLKSrznwqeStFvMpu3X6GBaom65vTgS3o11ea
mOmwkcw05xvcb0FX0EdJnQw29HdOqt9+LsPycMHUZDQbx9Y//mI+T4br8wTj
QgEbnMadpvllGaqmdMnUYTbqlHnGOt6toHakeKasslFgUS507GpFE1OpOWbm
CtXGIUq+XhueUyjPJnxcsTck/++d5DY8zvhk7P5lV/wLXvquzQ==
                    "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
               "HighlightElements" -> <|
                 "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
                "LayoutOptions" -> <|
                 "PlotRange" -> {{80., 3000.}, {5.419981572259163, 
                   24.463787380017305`}}, 
                  "Frame" -> {{True, True}, {True, True}}, 
                  "AxesOrigin" -> {0, 5.419981572259175}, 
                  "ImageSize" -> {360, 360}, "Axes" -> {False, False}, 
                  "LabelStyle" -> {}, "AspectRatio" -> 1, "DefaultStyle" -> {
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]]}, 
                  "HighlightLabelingFunctions" -> <|
                   "CoordinatesToolOptions" -> ({
                    Identity[
                    Part[#, 1]], 
                    Identity[
                    Part[#, 2]]}& ), 
                    "ScalingFunctions" -> {{Identity, Identity}, {
                    Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
                  False|>, 
                "Meta" -> <|
                 "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, 
                  "Function" -> Plot, "GroupHighlight" -> False|>|>, 
               "DynamicHighlight"]], {
             DisplayFunction -> Identity, DisplayFunction -> Identity, 
              Ticks -> {Automatic, Automatic}, 
              AxesOrigin -> {0, 5.419981572259175}, 
              FrameTicks -> {{{}, {}}, {{}, {}}}, GridLines -> {None, None}, 
              DisplayFunction -> Identity, PlotRangePadding -> {{
                 Scaled[0.1], 
                 Scaled[0.1]}, {
                 Scaled[0.1], 
                 Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
              All, DisplayFunction -> Identity, AspectRatio -> 1, 
              Axes -> {False, False}, AxesLabel -> {None, None}, 
              AxesOrigin -> {0, 5.419981572259163}, DisplayFunction :> 
              Identity, Frame -> {{True, True}, {True, True}}, 
              FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
              Directive[
                Opacity[0.5], 
                Thickness[Tiny], 
                RGBColor[0.368417, 0.506779, 0.709798]], 
              FrameTicks -> {{None, None}, {None, None}}, 
              GridLines -> {None, None}, GridLinesStyle -> Directive[
                GrayLevel[0.5, 0.4]], ImageSize -> 
              Dynamic[{
                Automatic, 
                 3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                  Magnification])}], 
              Method -> {
               "DefaultBoundaryStyle" -> Automatic, 
                "DefaultGraphicsInteraction" -> {
                 "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
                  "Effects" -> {
                   "Highlight" -> {"ratio" -> 2}, 
                    "HighlightPoint" -> {"ratio" -> 2}, 
                    "Droplines" -> {
                    "freeformCursorMode" -> True, 
                    "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
                "DefaultMeshStyle" -> AbsolutePointSize[6], 
                "ScalingFunctions" -> None, 
                "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
                    (Identity[#]& )[
                    Part[#, 1]], 
                    (Identity[#]& )[
                    Part[#, 2]]}& ), "CopiedValueFunction" -> ({
                    (Identity[#]& )[
                    Part[#, 1]], 
                    (Identity[#]& )[
                    Part[#, 2]]}& )}}, 
              PlotRange -> {{80., 3000.}, {5.419981572259163, 
               24.463787380017305`}}, PlotRangeClipping -> True, 
              PlotRangePadding -> {{
                 Scaled[0.1], 
                 Scaled[0.1]}, {
                 Scaled[0.1], 
                 Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
            GridBox[{{
               RowBox[{
                 TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                 "\[InvisibleSpace]", 
                 TagBox[
                  RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{"80.`", ",", "3000.`"}], "}"}], "}"}], 
                  "SummaryItem"]}]}, {
               RowBox[{
                 TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                 "\[InvisibleSpace]", 
                 TagBox["\"scalar\"", "SummaryItem"]}]}, {
               RowBox[{
                 TagBox["\"Order: \"", "SummaryItemAnnotation"], 
                 "\[InvisibleSpace]", 
                 TagBox["3", "SummaryItem"]}]}, {
               RowBox[{
                 TagBox["\"Method: \"", "SummaryItemAnnotation"], 
                 "\[InvisibleSpace]", 
                 TagBox["\"Hermite\"", "SummaryItem"]}]}, {
               RowBox[{
                 TagBox["\"Periodic: \"", "SummaryItemAnnotation"], 
                 "\[InvisibleSpace]", 
                 TagBox["False", "SummaryItem"]}]}}, 
             GridBoxAlignment -> {
              "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, AutoDelete -> 
             False, GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{2}}, "Rows" -> {{Automatic}}},
              BaseStyle -> {
              ShowStringCharacters -> False, NumberMarks -> False, 
               PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
          GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
          AutoDelete -> False, 
          GridBoxItemSize -> {
           "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
          BaselinePosition -> {1, 1}]}, 
       Dynamic[Typeset`open$$], ImageSize -> Automatic]},
     "SummaryPanel"],
    DynamicModuleValues:>{}], "]"}],
  InterpolatingFunction[{{80., 3000.}}, {
   5, 7, 0, {18}, {4}, 0, 0, 0, 0, Automatic, {}, {}, False}, {{80., 100., 
   200., 300., 400., 600., 800., 1000., 1200., 1400., 1600., 1800., 2000., 
   2200., 2400., 2600., 2800., 3000.}}, {
   Developer`PackedArrayForm, {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 
    14, 15, 16, 17, 18}, {5.419979637834522, 6.141331315320897, 
    8.412021429837276, 9.907235886082173, 11.08764591350968, 
    12.967883705145912`, 14.490510623344646`, 15.799991209788535`, 
    16.962523028239215`, 18.01291437015032, 18.97497398979403, 
    19.865473578083066`, 20.699842758615127`, 21.493206659921444`, 
    22.25875150532928, 23.005964744246587`, 23.740237368227987`, 
    24.463787557921613`}}, {Automatic}],
  Editable->False,
  SelectWithContents->True,
  Selectable->False]], "Output",
 CellLabel->"Out[3]=",
 CellID->70494877,ExpressionUUID->"1dd532b9-8eb1-4558-bcfb-5fedc7f7ab3a"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "The", " ", "corresponding", " ", "function", " ", "of", " ", "\[Gamma]V", 
    " ", "from", " ", "the", " ", "ThermodynamicData", " ", "package"}], 
   "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"GammaVNIST", "[", "P_", "]"}], ":=", 
   RowBox[{"QuantityMagnitude", "@", 
    RowBox[{"UnitConvert", "[", 
     RowBox[{
      RowBox[{"ThermodynamicData", "[", 
       RowBox[{
       "\"\<Argon\>\"", ",", 
        "\"\<FirstDerivativeOfPressureWithRespectToTemperature\>\"", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"\"\<Pressure\>\"", "\[Rule]", 
           RowBox[{"Quantity", "[", 
            RowBox[{"P", ",", "\"\<Atmospheres\>\""}], "]"}]}], ",", 
          RowBox[{"\"\<Temperature\>\"", "\[Rule]", 
           RowBox[{"Quantity", "[", 
            RowBox[{"150", ",", "\"\<Kelvins\>\""}], "]"}]}]}], "}"}]}], 
       "]"}], ",", "\"\<Atmospheres/Kelvins\>\""}], "]"}]}]}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->8281198,ExpressionUUID->"92c97270-71f8-466a-ae9f-3abcb7785299"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Legended", "[", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\[Gamma]V", "[", "x", "]"}], ",", 
       RowBox[{"GammaVNIST", "[", "x", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "80", ",", "3000"}], "}"}], ",", 
     RowBox[{"AxesOrigin", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"pc", ",", "0"}], "}"}]}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"All", ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "30"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"Frame", "\[Rule]", "True"}], ",", 
     RowBox[{"FrameLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
       "\"\<\!\(\*StyleBox[\"P\",FontSlant->\"Italic\"]\) (atm)\>\"", ",", 
        "\"\<\!\(\*StyleBox[SubscriptBox[StyleBox[\"\[Gamma]\",FontSlant->\"\
Italic\"], \"V\"],FontSlant->\"Italic\"]\) (atm/K)\>\"", ",", 
        "\"\<ISOTHERM 150 K\>\""}], "}"}]}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Red", ",", 
        RowBox[{"Directive", "[", 
         RowBox[{"Dashed", ",", "Black"}], "]"}]}], "}"}]}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "450"}], ",", 
     RowBox[{"Epilog", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"PointSize", "\[Rule]", "Medium"}], ",", 
        RowBox[{"Map", "[", 
         RowBox[{"Point", ",", "dataStreett150"}], "]"}]}], "}"}]}]}], "]"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Placed", "[", 
      RowBox[{
       RowBox[{"PointLegend", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"Directive", "[", 
           RowBox[{"Black", ",", 
            RowBox[{"AbsolutePointSize", "[", "6", "]"}]}], "]"}], "}"}], ",", 
         RowBox[{"{", "\"\<STREETT (1974)\>\"", "}"}]}], "]"}], ",", 
       "Below"}], "]"}], ",", 
     RowBox[{"Placed", "[", 
      RowBox[{
       RowBox[{"LineLegend", "[", 
        RowBox[{
         RowBox[{"{", "Red", "}"}], ",", 
         RowBox[{
         "{", "\"\<dPArgonNvdT[\!\(\*StyleBox[\"T\",FontSlant->\"Italic\"]\),\
\[Rho]]\>\"", "}"}]}], "]"}], ",", "Below"}], "]"}], ",", 
     RowBox[{"Placed", "[", 
      RowBox[{
       RowBox[{"LineLegend", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"Directive", "[", 
           RowBox[{"Black", ",", " ", "Dashed"}], "]"}], "}"}], ",", 
         RowBox[{
         "{", "\"\<FirstDerivativeOfPressureWithRespectToTemperature\>\"", 
          "}"}]}], "]"}], ",", "Below"}], "]"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->283061935,ExpressionUUID->"449b6eaa-581f-44b0-b413-380b5b81db7e"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[
    InterpretationBox[{
      TagBox[{{{{}, {}, 
          TagBox[{
            Directive[
             Opacity[1.], 
             AbsoluteThickness[2], 
             RGBColor[1, 0, 0]], 
            LineBox[CompressedData["
1:eJwVkHk41IkDh4dtk47Vj8gZZtwy7vENmw9F2FVsSgxqiIwcI2tt7mINSqmc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             "]]}, Annotation[#, "Charting`Private`Tag#1"]& ], 
          TagBox[{
            Directive[
             Opacity[1.], 
             AbsoluteThickness[2], 
             Dashing[{Small, Small}], 
             GrayLevel[0]], 
            LineBox[CompressedData["
1:eJwVzns01AkfBvApEUc1u3KLkesUuRvmJ7xvj163vFtuE2mQmakYZcnl7ews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             "]]}, Annotation[#, "Charting`Private`Tag#2"]& ]}}, {}}, {
       "WolframDynamicHighlight", <|
        "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>}], 
      DynamicBox[
       (Charting`HighlightActionBox["DynamicHighlight", {}, 
        Slot["HighlightElements"], 
        Slot["LayoutOptions"], 
        Slot["Meta"], 
        Charting`HighlightActionFunction["DynamicHighlight", {{{{}, {}, 
            Annotation[{
              Directive[
               Opacity[1.], 
               AbsoluteThickness[2], 
               RGBColor[1, 0, 0]], 
              Line[CompressedData["
1:eJwVkHk41IkDh4dtk47Vj8gZZtwy7vENmw9F2FVsSgxqiIwcI2tt7mINSqmc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               "]]}, "Charting`Private`Tag#1"], 
            Annotation[{
              Directive[
               Opacity[1.], 
               AbsoluteThickness[2], 
               Dashing[{Small, Small}], 
               GrayLevel[0]], 
              Line[CompressedData["
1:eJwVzns01AkfBvApEUc1u3KLkesUuRvmJ7xvj163vFtuE2mQmakYZcnl7ews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               "]]}, "Charting`Private`Tag#2"]}}, {}}, <|
         "HighlightElements" -> <|
           "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
          "LayoutOptions" -> <|
           "PlotRange" -> {All, {0., 30.}}, 
            "Frame" -> {{True, True}, {True, True}}, 
            "AxesOrigin" -> {48.63, 0.}, 
            "ImageSize" -> {450, 450/GoldenRatio}, "Axes" -> {True, True}, 
            "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
            "DefaultStyle" -> {
              Directive[
               Opacity[1.], 
               AbsoluteThickness[2], 
               Dashing[{Small, Small}], 
               GrayLevel[0]], 
              Directive[
               Opacity[1.], 
               AbsoluteThickness[2], 
               RGBColor[1, 0, 0]]}, 
            "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
                Identity[
                 Part[#, 1]], 
                Identity[
                 Part[#, 2]]}& ), 
              "ScalingFunctions" -> {{Identity, Identity}, {
                Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
            False|>, 
          "Meta" -> <|
           "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
            Plot, "GroupHighlight" -> False|>|>]]& )[<|
        "HighlightElements" -> <|
          "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
         "LayoutOptions" -> <|
          "PlotRange" -> {All, {0., 30.}}, 
           "Frame" -> {{True, True}, {True, True}}, 
           "AxesOrigin" -> {48.63, 0.}, "ImageSize" -> {450, 450/GoldenRatio},
            "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
           GoldenRatio^(-1), "DefaultStyle" -> {
             Directive[
              Opacity[1.], 
              AbsoluteThickness[2], 
              Dashing[{Small, Small}], 
              GrayLevel[0]], 
             Directive[
              Opacity[1.], 
              AbsoluteThickness[2], 
              RGBColor[1, 0, 0]]}, 
           "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
               Identity[
                Part[#, 1]], 
               Identity[
                Part[#, 2]]}& ), 
             "ScalingFunctions" -> {{Identity, Identity}, {
               Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
           False|>, 
         "Meta" -> <|
          "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
           Plot, "GroupHighlight" -> False|>|>]]}, 
     Annotation[{{{{}, {}, 
         Annotation[{
           Directive[
            Opacity[1.], 
            AbsoluteThickness[2], 
            RGBColor[1, 0, 0]], 
           Line[CompressedData["
1:eJwVkHk41IkDh4dtk47Vj8gZZtwy7vENmw9F2FVsSgxqiIwcI2tt7mINSqmc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            "]]}, "Charting`Private`Tag#1"], 
         Annotation[{
           Directive[
            Opacity[1.], 
            AbsoluteThickness[2], 
            Dashing[{Small, Small}], 
            GrayLevel[0]], 
           Line[CompressedData["
1:eJwVzns01AkfBvApEUc1u3KLkesUuRvmJ7xvj163vFtuE2mQmakYZcnl7ews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            "]]}, "Charting`Private`Tag#2"]}}, {}}, <|
      "HighlightElements" -> <|
        "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
       "LayoutOptions" -> <|
        "PlotRange" -> {All, {0., 30.}}, 
         "Frame" -> {{True, True}, {True, True}}, "AxesOrigin" -> {48.63, 0.},
          "ImageSize" -> {450, 450/GoldenRatio}, "Axes" -> {True, True}, 
         "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
         "DefaultStyle" -> {
           Directive[
            Opacity[1.], 
            AbsoluteThickness[2], 
            Dashing[{Small, Small}], 
            GrayLevel[0]], 
           Directive[
            Opacity[1.], 
            AbsoluteThickness[2], 
            RGBColor[1, 0, 0]]}, 
         "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
             Identity[
              Part[#, 1]], 
             Identity[
              Part[#, 2]]}& ), 
           "ScalingFunctions" -> {{Identity, Identity}, {
             Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>, 
       "Meta" -> <|
        "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
         Plot, "GroupHighlight" -> False|>|>, "DynamicHighlight"]], {
    DisplayFunction -> Identity, DisplayFunction -> Identity, 
     Ticks -> {Automatic, Automatic}, AxesOrigin -> {48.63, 0.}, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     GridLines -> {None, None}, DisplayFunction -> Identity, 
     PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {0, 0}}, PlotRangeClipping -> True, ImagePadding -> 
     All, DisplayFunction -> Identity, AspectRatio -> 
     NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
     AxesLabel -> {None, None}, AxesOrigin -> {48.63, 0.}, DisplayFunction :> 
     Identity, Epilog -> {PointSize -> Medium, {
        PointBox[{80, 5.26}], 
        PointBox[{100, 5.96}], 
        PointBox[{200, 8.27}], 
        PointBox[{400, 11.1}], 
        PointBox[{600, 13.2}], 
        PointBox[{800, 14.9}], 
        PointBox[{1000, 16.4}], 
        PointBox[{1200, 17.7}], 
        PointBox[{1400, 18.9}], 
        PointBox[{1600, 20}], 
        PointBox[{1800, 21}], 
        PointBox[{2000, 21.9}], 
        PointBox[{2200, 22.8}], 
        PointBox[{2400, 23.6}], 
        PointBox[{2600, 24.4}], 
        PointBox[{2800, 25.1}], 
        PointBox[{3000, 25.8}]}}, Frame -> {{True, True}, {True, True}}, 
     FrameLabel -> {{
        FormBox[
         TagBox[
         "\"\\!\\(\\*StyleBox[SubscriptBox[StyleBox[\\\"\[Gamma]\\\",\
FontSlant->\\\"Italic\\\"], \\\"V\\\"],FontSlant->\\\"Italic\\\"]\\) \
(atm/K)\"", HoldForm], TraditionalForm], None}, {
        FormBox[
         TagBox[
         "\"\\!\\(\\*StyleBox[\\\"P\\\",FontSlant->\\\"Italic\\\"]\\) \
(atm)\"", HoldForm], TraditionalForm], 
        FormBox[
         TagBox["\"ISOTHERM 150 K\"", HoldForm], TraditionalForm]}}, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     GridLines -> {None, None}, GridLinesStyle -> Directive[
       GrayLevel[0.5, 0.4]], ImageSize -> 450, 
     Method -> {
      "DefaultBoundaryStyle" -> Automatic, 
       "DefaultGraphicsInteraction" -> {
        "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
         "Effects" -> {
          "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
           "Droplines" -> {
            "freeformCursorMode" -> True, 
             "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
       "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> None,
        "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
           (Identity[#]& )[
            Part[#, 1]], 
           (Identity[#]& )[
            Part[#, 2]]}& ), "CopiedValueFunction" -> ({
           (Identity[#]& )[
            Part[#, 1]], 
           (Identity[#]& )[
            Part[#, 2]]}& )}}, PlotRange -> {All, {0., 30.}}, 
     PlotRangeClipping -> True, 
     PlotRangePadding -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     Ticks -> {Automatic, Automatic}}], 
   FormBox[
    TemplateBox[{"\[ThinSpace]", "\" \"", 
      FormBox[
       TemplateBox[{"\"STREETT (1974)\""}, "PointLegend", 
        DisplayFunction -> (FormBox[
          StyleBox[
           StyleBox[
            PaneBox[
             TagBox[
              GridBox[{{
                 TagBox[
                  GridBox[{{
                    GraphicsBox[{{}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    GrayLevel[0], 
                    AbsolutePointSize[6]], {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    GrayLevel[0], 
                    AbsolutePointSize[6]], 
                    PointBox[
                    NCache[{
                    Scaled[{
                    Rational[1, 2], 
                    Rational[1, 2]}]}, {
                    Scaled[{0.5, 0.5}]}]]}}}, AspectRatio -> Full, 
                    ImageSize -> {10, 12.5}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.18000000000000002`] -> 
                    Baseline)], #}}, 
                   GridBoxAlignment -> {
                    "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                   AutoDelete -> False, 
                   GridBoxDividers -> {
                    "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                   GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                   GridBoxSpacings -> {
                    "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
               GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}},
                AutoDelete -> False, 
               GridBoxItemSize -> {
                "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
               GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
              "Grid"], Alignment -> Left, AppearanceElements -> None, 
             ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
             "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
           FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
           False], TraditionalForm]& ), 
        InterpretationFunction :> (RowBox[{"PointLegend", "[", 
           RowBox[{
             RowBox[{"{", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   
                   TemplateBox[<|"color" -> GrayLevel[0]|>, 
                    "GrayLevelColorSwatchTemplate"], ",", 
                   RowBox[{"AbsolutePointSize", "[", "6", "]"}]}], "]"}], 
               "}"}], ",", 
             RowBox[{"{", #, "}"}]}], "]"}]& ), Editable -> True], 
       TraditionalForm], 
      FormBox[
       TemplateBox[{
        "\"dPArgonNvdT[\\!\\(\\*StyleBox[\\\"T\\\",FontSlant->\\\"Italic\\\"]\
\\),\[Rho]]\""}, "LineLegend", DisplayFunction -> (FormBox[
          StyleBox[
           StyleBox[
            PaneBox[
             TagBox[
              GridBox[{{
                 TagBox[
                  GridBox[{{
                    GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[1, 0, 0]], {
                    LineBox[{{0, 12.5}, {20, 12.5}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[1, 0, 0]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 12.5}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.18000000000000002`] -> 
                    Baseline)], #}}, 
                   GridBoxAlignment -> {
                    "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                   AutoDelete -> False, 
                   GridBoxDividers -> {
                    "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                   GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                   GridBoxSpacings -> {
                    "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
               GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}},
                AutoDelete -> False, 
               GridBoxItemSize -> {
                "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
               GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
              "Grid"], Alignment -> Left, AppearanceElements -> None, 
             ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
             "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
           FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
           False], TraditionalForm]& ), 
        InterpretationFunction :> (RowBox[{"LineLegend", "[", 
           RowBox[{
             RowBox[{"{", 
               
               TemplateBox[<|"color" -> RGBColor[1, 0, 0]|>, 
                "RGBColorSwatchTemplate"], "}"}], ",", 
             RowBox[{"{", #, "}"}]}], "]"}]& ), Editable -> True], 
       TraditionalForm], 
      FormBox[
       TemplateBox[{"\"FirstDerivativeOfPressureWithRespectToTemperature\""}, 
        "LineLegend", DisplayFunction -> (FormBox[
          StyleBox[
           StyleBox[
            PaneBox[
             TagBox[
              GridBox[{{
                 TagBox[
                  GridBox[{{
                    GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    GrayLevel[0], 
                    Dashing[{Small, Small}]], {
                    LineBox[{{0, 12.5}, {40, 12.5}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    GrayLevel[0], 
                    Dashing[{Small, Small}]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {40, 12.5}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.18000000000000002`] -> 
                    Baseline)], #}}, 
                   GridBoxAlignment -> {
                    "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                   AutoDelete -> False, 
                   GridBoxDividers -> {
                    "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                   GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                   GridBoxSpacings -> {
                    "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
               GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}},
                AutoDelete -> False, 
               GridBoxItemSize -> {
                "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
               GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
              "Grid"], Alignment -> Left, AppearanceElements -> None, 
             ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
             "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
           FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
           False], TraditionalForm]& ), 
        InterpretationFunction :> (RowBox[{"LineLegend", "[", 
           RowBox[{
             RowBox[{"{", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   
                   TemplateBox[<|"color" -> GrayLevel[0]|>, 
                    "GrayLevelColorSwatchTemplate"], ",", 
                   RowBox[{"Dashing", "[", 
                    RowBox[{"{", 
                    RowBox[{"Small", ",", "Small"}], "}"}], "]"}]}], "]"}], 
               "}"}], ",", 
             RowBox[{"{", #, "}"}]}], "]"}]& ), Editable -> True], 
       TraditionalForm]}, "RowWithSeparators"], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"]}, {
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "Below"}], "]"}]}], "]"}]& )]], "Output",
 CellLabel->"Out[5]=",
 CellID->78270366,ExpressionUUID->"84c14913-7e77-44bd-af70-6d482fceb30a"]
}, Open  ]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "2"}, 
  Closed]]]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "PrimaryExamplesSection"}, 
  Closed]]]],

Cell[BoxData[GridBox[{
   {
    DynamicBox[FEPrivate`ImportImage[
      FrontEnd`FileName[{"Documentation", "FooterIcons"}, 
       "RelatedFunction.png"]],
     ImageSizeCache->{50., {27., 33.}}], GridBox[{
      {
       StyleBox[
        RowBox[{"See", " ", "Also"}], "SeeAlsoSection"]},
      {Cell[TextData[{
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["PArgonNv"]], "paclet:NewEoSArgon/ref/PArgonNv", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "ea6e4421-d3bd-4b93-b498-cfb66f6531c5"],
        "\[NonBreakingSpace]",
        StyleBox[
        "\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
         "InlineSeparator"],
        " ",
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["RhoArgonNv"]], "paclet:NewEoSArgon/ref/RhoArgonNv", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "1281001d-8fef-4cec-93a0-0c0d560384e4"],
        "\[NonBreakingSpace]",
        StyleBox[
        "\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
         "InlineSeparator"],
        " ",
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["ZtotalNv"]], "paclet:NewEoSArgon/ref/ZtotalNv", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "1e9503d3-f667-432e-a48f-09f0113ab474"],
        "\[NonBreakingSpace]",
        StyleBox[
        "\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
         "InlineSeparator"],
        " ",
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["dZtotalNvdT"]], "paclet:NewEoSArgon/ref/dZtotalNvdT", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "0498d3b1-03c3-42a4-8326-f47015eb9aa0"]
       }], "SeeAlso",ExpressionUUID->"40875285-828f-4784-9721-c1c91c59fc68"]}
     }]}
  }]], "SeeAlsoSection",ExpressionUUID->"b34cdc9f-750f-4ce2-ac68-\
7697d1899133"],

Cell[BoxData[GridBox[{
   {
    DynamicBox[FEPrivate`ImportImage[
      FrontEnd`FileName[{"Documentation", "FooterIcons"}, "RelatedGuide.png"]],
     ImageSizeCache->{50., {27., 33.}}], GridBox[{
      {
       StyleBox[
        RowBox[{"Related", " ", "Guides"}], "MoreAboutSection"]},
      {
       RowBox[{"\[FilledVerySmallSquare]", Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["NewEoSArgon Package"]], 
           "paclet:NewEoSArgon/guide/NewEoSArgon"},
          "RefLinkPlain",
          BaseStyle->{"MoreAbout"}]], "MoreAbout",ExpressionUUID->
         "746d8ed8-4b2f-43ff-bd63-f2b60faba37d"]}]}
     }]}
  }]], "MoreAboutSection",ExpressionUUID->"92e20181-bab8-4e48-8c1f-\
d5648f831bd4"],

Cell[BoxData[GridBox[{
   {
    TemplateBox[{29},
     "Spacer1"], GridBox[{
      {
       RowBox[{
        TemplateBox[{17},
         "Spacer1"], 
        StyleBox[
         RowBox[{"Related", " ", "Links"}], "RelatedLinksSection"]}]},
      {Cell[BoxData[Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData[
             RowBox[{
               RowBox[{"Units", " ", "&"}], " ", "Quantities"}]]], 
           "paclet:guide/Units"},
          "RefLinkPlain",
          BaseStyle->{"RelatedLinks"}]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "6e6a8be0-04bf-49d2-88ac-59531508a636"]], "RelatedLinks",
        ExpressionUUID->"761c0b67-a909-4341-992f-b339fb6601e6"]},
      {Cell[BoxData[Cell[BoxData[Cell[BoxData[
          RowBox[{
           TemplateBox[{16},
            "Spacer1"], "\[FilledVerySmallSquare]", 
           TemplateBox[{
             Cell[
              TextData[
               Cell[
                TextData[{
                  Cell[
                   BoxData[
                    TemplateBox[{2}, "Spacer1"]]], "ThermodynamicData"}]]]], 
             "paclet:ref/ThermodynamicData"},
            "RefLink",
            BaseStyle->{"RelatedLinks"}]}]],ExpressionUUID->
          "26aaacfe-6d9f-48b0-8ebc-75dad50e293b"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "8cc5a079-4da3-4567-a2cd-9c95172d163e"]], "RelatedLinks",
        ExpressionUUID->"995112b5-3311-4444-9e45-6cbd9d038025"]}
     }]}
  }]], "RelatedLinksSection",ExpressionUUID->"8205690c-ed5f-4437-b07b-\
f7e0d78f42fa"],

Cell[" ", "FooterCell",ExpressionUUID->"b72f4d7d-041c-4786-a4d9-e5b012a94275"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{900, 835.8},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"dPArgonNvdT",
TaggingRules->{
 "ModificationHighlight" -> False, "ColorType" -> "", "LinkTrails" -> "", 
  "HasOptions" -> True, "ExampleCounter" -> 1, 
  "Openers" -> {
   "PrimaryExamplesSection" -> Open, 
    "ExampleSection" -> {"0" -> Open, "2" -> Closed}, "NotesSection" -> 
    Closed}, "NewStyles" -> True, "CitationPopupData" -> $Failed, 
  "ShowCitation" -> False, "RootCaptions" -> "", 
  "Metadata" -> {
   "built" -> "{2023, 11, 30, 13, 55, 34.1612413}", 
    "history" -> {"XX", "", "", ""}, "context" -> "NewEoSArgon`", 
    "keywords" -> {}, "specialkeywords" -> {}, 
    "tutorialcollectionlinks" -> {}, "index" -> True, "label" -> 
    "New Eo S Argon Package Symbol", "language" -> "en", "paclet" -> 
    "NewEoSArgon Package", "status" -> "None", "summary" -> 
    "dPArgonNvdT[T, \\[Rho]] \\[Congruent] (\\[PartialD]P/\\[PartialD]T) V= \
\\[Gamma]V (bar/K) Coefficient de pression thermique en fonction de T \
(Kelvin) et de \\[Rho] (g/cm^3) [Thermal-pressure coefficient versus T \
(Kelvin) and \\[Rho] (g/cm^3)]", "synonyms" -> {}, "tabletags" -> {}, "title" -> 
    "dPArgonNvdT", "titlemodifier" -> "", "metadescription" -> "", 
    "windowtitle" -> "dPArgonNvdT", "type" -> "Symbol", "uri" -> 
    "NewEoSArgon/ref/dPArgonNvdT"}},
CellContext->"Global`",
FrontEndVersion->"13.3 pour Microsoft Windows (64-bit) (July 24, 2023)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "13.3 pour Microsoft Windows (64-bit) (July 24, 2023)", 
  StyleDefinitions -> "Default.nb"],
ExpressionUUID->"af926425-6773-4a09-b020-d2be9ff382ed"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[13636, 399, 1420, 37, 35, "PrimaryExamplesSection",ExpressionUUID->"00a93731-ddaf-4caa-8ba8-86023a93b065",
   CellTags->"PrimaryExamplesSection",
   CellID->164815156]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 99309, 2305}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[583, 21, 5524, 134, 56, "AnchorBarGrid",ExpressionUUID->"68585001-c235-4df9-a2c3-5268dc47568c",
 CellID->1],
Cell[6110, 157, 94, 0, 23, "ContextNameCell",ExpressionUUID->"3d340d71-2a7d-4d53-9069-103ab1285c66"],
Cell[CellGroupData[{
Cell[6229, 161, 554, 14, 56, "ObjectNameGrid",ExpressionUUID->"23315f5d-43cb-41f9-a028-6d9e83676370"],
Cell[6786, 177, 1535, 44, 150, "Usage",ExpressionUUID->"2d8c68a8-241b-40ad-88f3-557d170a84d6"]
}, Open  ]],
Cell[CellGroupData[{
Cell[8358, 226, 1919, 48, 37, "NotesSection",ExpressionUUID->"9ab85a72-37df-46b4-bef2-debbc40d29ae",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->163485631],
Cell[10280, 276, 529, 16, 38, "Notes",ExpressionUUID->"bf838369-f3e0-4556-9ccc-33d8bb1180df",
 CellID->1067943069],
Cell[10812, 294, 1004, 37, 40, "Notes",ExpressionUUID->"cbbea908-d519-4bd2-8cc4-82b08dd86768",
 CellID->524000197],
Cell[11819, 333, 185, 4, 36, "Notes",ExpressionUUID->"f7ce3fa4-8b27-45dd-a5c6-67516c5e1d91",
 CellID->185021568],
Cell[12007, 339, 521, 16, 38, "Notes",ExpressionUUID->"0b8af056-205d-4a83-8b52-1c50534bea6b",
 CellID->175218415],
Cell[12531, 357, 978, 36, 40, "Notes",ExpressionUUID->"1b8687c6-250e-42c5-b5a1-5bbc9cce450f",
 CellID->536882946]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "NotesSection"}, Closed]]]],
Cell[CellGroupData[{
Cell[13636, 399, 1420, 37, 35, "PrimaryExamplesSection",ExpressionUUID->"00a93731-ddaf-4caa-8ba8-86023a93b065",
 CellTags->"PrimaryExamplesSection",
 CellID->164815156],
Cell[CellGroupData[{
Cell[15081, 440, 1398, 36, 30, "ExampleSection",ExpressionUUID->"13369477-3942-4c59-8b44-1a0f379d4e5e",
 CellID->511559263],
Cell[16482, 478, 268, 5, 42, "Input",ExpressionUUID->"55ec19d3-d37e-4a88-b0d6-ef1ea7055aec",
 CellID->143015886],
Cell[16753, 485, 377, 10, 38, "ExampleText",ExpressionUUID->"df9f8cb0-70fa-41a0-85d9-d9e80a74909b",
 CellID->544149791],
Cell[CellGroupData[{
Cell[17155, 499, 1009, 24, 42, "Input",ExpressionUUID->"deffc7f1-2ee9-4a84-8573-6b5ccdbd2f69",
 CellID->254692277],
Cell[18167, 525, 335, 8, 41, "Output",ExpressionUUID->"99d81386-2395-4416-997e-180ae839b5e3",
 CellID->197396477]
}, Open  ]],
Cell[CellGroupData[{
Cell[18539, 538, 814, 21, 26, "Input",ExpressionUUID->"29681f2a-4b6e-4858-b96a-af78bca3f930",
 CellID->153659259],
Cell[19356, 561, 350, 8, 40, "Output",ExpressionUUID->"c32d4ae9-6dd4-4c20-82e0-d0ded5492342",
 CellID->219615560]
}, Open  ]],
Cell[CellGroupData[{
Cell[19743, 574, 852, 21, 26, "Input",ExpressionUUID->"dfb00744-9f4c-48f0-a333-5803b9f789ae",
 CellID->106075116],
Cell[20598, 597, 347, 8, 40, "Output",ExpressionUUID->"02343666-c721-4812-938a-131a095a6f1b",
 CellID->63089429]
}, Open  ]],
Cell[20960, 608, 154, 1, 38, "ExampleText",ExpressionUUID->"1adaae23-908e-4b78-bde7-9c060f62e9e4",
 CellID->361149294],
Cell[CellGroupData[{
Cell[21139, 613, 701, 17, 42, "Input",ExpressionUUID->"fafde767-0bcd-4459-b55d-bf9ec5f5760e",
 CellID->375583457],
Cell[21843, 632, 334, 8, 41, "Output",ExpressionUUID->"55be8e8e-7ca1-41e5-b1c6-8a3c8a2256b5",
 CellID->60093725]
}, Open  ]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"}, Closed]]]],
Cell[CellGroupData[{
Cell[22326, 648, 1419, 37, 30, "ExampleSection",ExpressionUUID->"5721227d-c1be-4f8b-b3ba-6a9f2e44860c",
 CellID->258228157],
Cell[23748, 687, 268, 5, 70, "Input",ExpressionUUID->"93886600-5b99-485a-82f9-c34ab71889e7",
 CellID->279378555],
Cell[24019, 694, 201, 4, 70, "ExampleText",ExpressionUUID->"dbcb60d0-d986-42d8-9482-4fffe59e0499",
 CellID->227520913],
Cell[24223, 700, 1502, 44, 70, "Input",ExpressionUUID->"f41602c0-441e-4568-9ca9-4851e8e30ca9",
 CellID->243734080],
Cell[CellGroupData[{
Cell[25750, 748, 1477, 42, 70, "Input",ExpressionUUID->"da26ac08-1328-4efa-abea-11b6fe36da37",
 CellID->123312038],
Cell[27230, 792, 29682, 571, 70, "Output",ExpressionUUID->"1dd532b9-8eb1-4558-bcfb-5fedc7f7ab3a",
 CellID->70494877]
}, Open  ]],
Cell[56927, 1366, 1080, 26, 70, "Input",ExpressionUUID->"92c97270-71f8-466a-ae9f-3abcb7785299",
 CellID->8281198],
Cell[CellGroupData[{
Cell[58032, 1396, 2655, 71, 70, "Input",ExpressionUUID->"449b6eaa-581f-44b0-b413-380b5b81db7e",
 CellID->283061935],
Cell[60690, 1469, 31476, 647, 357, "Output",ExpressionUUID->"84c14913-7e77-44bd-af70-6d482fceb30a",
 CellID->78270366]
}, Open  ]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "2"}, Closed]]]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "PrimaryExamplesSection"}, Closed]]]],
Cell[92408, 2125, 2411, 64, 114, "SeeAlsoSection",ExpressionUUID->"b34cdc9f-750f-4ce2-ac68-7697d1899133"],
Cell[94822, 2191, 729, 19, 70, "MoreAboutSection",ExpressionUUID->"92e20181-bab8-4e48-8c1f-d5648f831bd4"],
Cell[95554, 2212, 1607, 43, 70, "RelatedLinksSection",ExpressionUUID->"8205690c-ed5f-4437-b07b-f7e0d78f42fa"],
Cell[97164, 2257, 78, 0, 70, "FooterCell",ExpressionUUID->"b72f4d7d-041c-4786-a4d9-e5b012a94275"]
}
]
*)

(* End of internal cache information *)

