(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 13.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     60062,       1469]
NotebookOptionsPosition[     53396,       1336]
NotebookOutlinePosition[     55861,       1395]
CellTagsIndexPosition[     55775,       1390]
WindowTitle->dZtotalNv
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[GridBox[{
   {GridBox[{
      {
       ItemBox[Cell[BoxData[
         RowBox[{
          TemplateBox[{12},
           "Spacer1"], Cell["NEW EO S ARGON PACKAGE SYMBOL", "PacletNameCell",
           TextAlignment->Center,ExpressionUUID->
           "159d785f-760c-4343-802b-3ef693adb084"], 
          TemplateBox[{8},
           "Spacer1"]}]],
         TextAlignment->Center,ExpressionUUID->
         "92ae2337-3b05-4d5a-a6b9-ce0e1803ba39"],
        Background->RGBColor[0.490196, 0.576471, 0.690196],
        ItemSize->Full], ""}
     },
     GridBoxAlignment->{"Rows" -> {{Center}}},
     GridBoxItemSize->{"Columns" -> {Full, 
         Scaled[0.02]}, "Rows" -> {{2.5}}}], Cell[TextData[{
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "See Also",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "8eb55afa-351f-4987-83dc-fbf566176a27"]
         }],ExpressionUUID->"69797b7b-9199-4044-b28b-45e4084a7ac5"],
         StripOnInput->False],{
        "\"ZtotalNv\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/ZtotalNv"], 
         "\"dPArgonNvdRho\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/dPArgonNvdRho"]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"SeeAlso"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "8ed12a09-040f-463a-9a54-9d99214fc69e"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "Related Guides",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "8afb9e8d-eca7-4a15-b17c-28639187572c"]
         }],ExpressionUUID->"8eef73ac-3438-42ce-908e-16afa4e3108e"],
         StripOnInput->False],{
        "\"NewEoSArgon Package\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/guide/NewEoSArgon"]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"MoreAbout"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "d711162d-e21d-429c-b2e7-16cf216ec26d"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "URL",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "7b5f39d8-f7fc-4cad-b4e2-e8dbcf035c96"]
         }],ExpressionUUID->"1c85588f-a5d1-41a6-b679-a2115c1a179a"],
         StripOnInput->False],{
        "\"NewEoSArgon/ref/dZtotalNv\"" :> None, 
         "\"Copy Wolfram Documentation Center URL\"" :> 
         Module[{DocumentationSearch`Private`nb$}, 
           DocumentationSearch`Private`nb$ = 
            NotebookPut[
             Notebook[{Cell["NewEoSArgon/ref/dZtotalNv"]}, Visible -> False]]; 
           SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
           FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
           NotebookClose[DocumentationSearch`Private`nb$]; Null], Delimiter, 
         "\"Copy web URL\"" :> 
         Module[{DocumentationSearch`Private`nb$}, 
           DocumentationSearch`Private`nb$ = 
            NotebookPut[
             Notebook[{
               Cell[BoxData[
                 MakeBoxes[
                  Hyperlink[
                   "http://reference.wolfram.com/language/NewEoSArgon/ref/\
dZtotalNv.html"], StandardForm]], "Input", TextClipboardType -> "PlainText"]},
                Visible -> False]]; 
           SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
           FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
           NotebookClose[DocumentationSearch`Private`nb$]; Null], 
         "\"Go to web URL\"" :> 
         FrontEndExecute[{
           NotebookLocate[{
             URL[If[TrueQ[DocumentationBuild`Make`Private`wsmlinkQ$14051], 
                 "http://reference.wolfram.com/system-modeler/", 
                 "http://reference.wolfram.com/language/"] <> 
               "NewEoSArgon/ref/dZtotalNv" <> ".html"], None}]}]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"URLMenu"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "e3a49900-c266-4816-89bb-69aa330bc915"]
    }], "AnchorBar",
     CacheGraphics->False,ExpressionUUID->
     "ffcc8fc4-4167-4a4e-873b-4d11726a4deb"]}
  }]], "AnchorBarGrid",
 CellID->1,ExpressionUUID->"166700ad-d5cc-4139-8726-e68a609ead99"],

Cell["NewEoSArgon`", "ContextNameCell",ExpressionUUID->"5041cc22-4360-4645-a788-256078674a04"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     Cell[
     "dZtotalNv", "ObjectName",ExpressionUUID->
      "9b25e161-1fb8-41c1-81af-e4410bcc0816"],
     Cell[BoxData[
      TemplateBox[{8},
       "Spacer1"]],ExpressionUUID->"bd66ca2a-ab11-4e63-bfe7-dbd1f27c7fa2"],
     Cell[BoxData[
     ""], "ObjectNameTranslation",ExpressionUUID->
      "fb0632ce-0128-42cf-9f4c-2a1c9595af91"]
    }],ExpressionUUID->"a5d3defa-142c-44b1-872e-1d4ba28c27e2"], 
    "\[SpanFromLeft]"}
  }]], "ObjectNameGrid",ExpressionUUID->"81845bb1-85e4-46fb-8567-\
f29c307fc737"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     "dZtotalNv[",
     StyleBox["T",
      FontSlant->"Italic"],
     ", \[Rho]] \[Congruent] ",
     Cell[BoxData[
      SubscriptBox[
       RowBox[{"(", 
        FractionBox[
         RowBox[{"\[PartialD]", 
          StyleBox["Z",
           FontSlant->"Italic"]}], 
         RowBox[{"\[PartialD]", "\[Rho]"}]], ")"}], 
       StyleBox["T",
        FontSlant->"Italic"]]], "InlineFormula",
      FontFamily->"Source Sans Pro",ExpressionUUID->
      "c98c607f-ca79-44dd-80fe-00636043a700"],
     " (",
     Cell[BoxData[
      RowBox[{
       SuperscriptBox["cm", "3"], "/", "g"}]], "InlineFormula",
      FontFamily->"Source Sans Pro",ExpressionUUID->
      "24216d38-b3b4-4468-9a9a-cc4004435e63"],
     ")\nD\[EAcute]riv\[EAcute]e partielle premi\[EGrave]re par rapport \
\[AGrave] ",
     StyleBox["T",
      FontSlant->"Italic"],
     " du facteur de compressibilit\[EAcute] ",
     StyleBox["Z",
      FontSlant->"Italic"],
     " en fonction de ",
     StyleBox["T",
      FontSlant->"Italic"],
     " (Kelvin) et de \[Rho] (g/",
     Cell[BoxData[
      SuperscriptBox["cm", "3"]], "InlineFormula",
      FontFamily->"Source Sans Pro",ExpressionUUID->
      "da7de19d-e789-4fef-829e-353eec3fd871"],
     ") \n[First partial derivative of compressibility factor ",
     StyleBox["Z",
      FontSlant->"Italic"],
     " with respect to density versus ",
     StyleBox["T",
      FontSlant->"Italic"],
     " (Kelvin) and \[Rho] (g/",
     Cell[BoxData[
      SuperscriptBox["cm", "3"]], "InlineFormula",
      FontFamily->"Source Sans Pro",ExpressionUUID->
      "61b296f5-0e4c-40b9-a8e7-ff3c6f229515"],
     ")]"
    }],ExpressionUUID->"7f38dcf8-8288-4ffe-a336-fce5b0438f7f"]}
  }]], "Usage",ExpressionUUID->"d1be4379-f018-4721-a203-ec3ec2be425a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[Cell[TextData[{
   Cell[BoxData[
    DynamicBox[ToBoxes[
      If[
       MatchQ[
        CurrentValue[
         EvaluationNotebook[], {TaggingRules, "Openers", "NotesSection"}, 
         Closed], 
        Alternatives[Open, True]], 
       Style[
        Graphics[{
          Thickness[0.18], 
          RGBColor[0.8509803921568627, 0.396078431372549, 0], 
          Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
         PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
        0.68 Inherited], 
       Rotate[
        Style[
         Graphics[{
           Thickness[0.18], 
           RGBColor[0.8509803921568627, 0.396078431372549, 0], 
           Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
          PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
         0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
     ImageSizeCache->{
      13.600000000000001`, {0.5800000000000001, 13.020000000000001`}}]],
    ExpressionUUID->"50b46721-3847-4a50-93fa-068adf343512"],
   Cell[BoxData[
    TemplateBox[{1},
     "Spacer1"]],ExpressionUUID->"3aa8e171-324b-4399-b87f-aa5a911b1795"],
   "Details and Options"
  }], "NotesFrameText",ExpressionUUID->"6f76a404-03ab-4a2f-bc01-d6f705768f84"],
  Appearance->{Automatic, None, "Normal", Automatic},
  BaseStyle->None,
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"], 
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], After, CellContents]}]& ),
  Evaluator->None,
  Method->
   "Preemptive"]],ExpressionUUID->"d33ce2a9-34cf-456d-87df-0acdeb341e8d"]], \
"NotesSection",
 WholeCellGroupOpener->True,
 CellGroupingRules->{"SectionGrouping", 50},
 CacheGraphics->False,
 CellID->320147203,ExpressionUUID->"4c5f1473-2ed9-4772-b483-7739f2f5c270"],

Cell[TextData[{
 "La fonction est d\[EAcute]finie pour ",
 StyleBox["T",
  FontSlant->"Italic"],
 " >0 et \[Rho] \[GreaterEqual] 0"
}], "Notes",
 CellID->1067943069,ExpressionUUID->"ad6a8455-9f87-4e81-9939-a6fda6aed529"],

Cell["\<\
******************************************************************************\
*****\
\>", "Notes",
 CellID->185021568,ExpressionUUID->"791285a3-9baf-4605-8cfb-8913b0ff906a"],

Cell[TextData[{
 "The function is defined for ",
 StyleBox["T",
  FontSlant->"Italic"],
 " >0 and \[Rho] \[GreaterEqual] 0."
}], "Notes",
 CellID->175218415,ExpressionUUID->"af529707-de8f-4e53-a3f1-b4aeb2c31667"]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "NotesSection"}, Closed]]]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {
       TaggingRules, "Openers", "PrimaryExamplesSection"}, Open], 
      Alternatives[True, Open]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{13.600000000000001`, {5., 8.600000000000001}}]],
  ExpressionUUID->"275909bb-0e79-495c-8870-48beb2798265"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"bff1e8a5-aa83-4c63-b4bb-3f83904af09f"],
 "Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount",ExpressionUUID->
  "8a0ba1b3-8179-4be0-b41d-cbc5403af98f"]
}], "PrimaryExamplesSection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellTags->"PrimaryExamplesSection",
 CellID->276086021,ExpressionUUID->"d0f77958-e074-47d0-967d-a25780ffb3c6"],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"},
        Closed], 
      Alternatives[Open, True]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{13.600000000000001`, {5., 8.600000000000001}}]],
  ExpressionUUID->"7bf39b3e-15e3-480d-aeb3-485c3a06b438"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"5f6e8709-b439-437e-8cab-3c98b446d984"],
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "d1d94cf8-1f6c-4920-bbac-17cf6e632cde"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellID->300887851,ExpressionUUID->"456cd1ba-fd96-42f7-87d0-bfa33eb46abe"],

Cell[BoxData[{
 RowBox[{"Needs", "[", "\"\<NewEoSArgon`\>\"", "]"}], "\[IndentingNewLine]", 
 RowBox[{"Off", "[", 
  RowBox[{"General", "::", "munfl"}], "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->143015886,ExpressionUUID->"5885db29-64c5-4e3d-ac5b-10d79cb8a8fd"],

Cell[TextData[{
 "Calculated value of ",
 Cell[BoxData[
  SubscriptBox[
   RowBox[{"(", 
    FractionBox[
     RowBox[{"\[PartialD]", 
      StyleBox["Z",
       FontSlant->"Italic"]}], 
     RowBox[{"\[PartialD]", "\[Rho]"}]], ")"}], 
   StyleBox["T",
    FontSlant->"Italic"]]],ExpressionUUID->
  "fca413fc-fc6a-43e4-b3be-fdf459d1db55"],
 " for atmospheric pressure and 20\[Degree]C"
}], "ExampleText",
 CellID->544149791,ExpressionUUID->"50f7973d-94c7-494e-9658-3c8c21de2c39"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UnitSimplify", "[", 
  RowBox[{
   RowBox[{"Quantity", "[", 
    RowBox[{
     RowBox[{"dZtotalNv", "[", 
      RowBox[{"293.15", ",", 
       RowBox[{"RhoArgonNv", "[", 
        RowBox[{"293.15", ",", 
         RowBox[{"QuantityMagnitude", "@", 
          RowBox[{"N", "@", 
           RowBox[{"UnitConvert", "[", 
            RowBox[{
             TemplateBox[{"1"},
              "QuantityUnit",
              DisplayFunction->(TooltipBox[
                StyleBox[
                 RowBox[{#, "\[InvisibleSpace]", 
                   StyleBox[
                    RowBox[{" ", "\"atm\""}], 
                    "QuantityUnitTraditionalLabel"]}], ShowStringCharacters -> 
                 False], "Unit: atmospheres"]& ),
              InterpretationFunction->(RowBox[{"Quantity", "[", 
                 RowBox[{#, ",", "\"Atmospheres\""}], "]"}]& )], ",", 
             "\"\<Bars\>\""}], "]"}]}]}], ",", "\"\<G\>\""}], "]"}]}], "]"}], 
     ",", "\"\<cm^3/g\>\""}], "]"}], "*", 
   RowBox[{"Quantity", "[", 
    RowBox[{"M", ",", "\"\<g/mol\>\""}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->254692277,ExpressionUUID->"6b02e2d8-4460-448d-823c-cb29596ca006"],

Cell[BoxData[
 TemplateBox[{
   RowBox[{"-", "16.924420685412464`"}], 
   RowBox[{
     SuperscriptBox["\"cm\"", "3"], "\[NegativeMediumSpace]", "\"/\"", 
     "\[InvisibleSpace]", "\"mol\""}], "centimeters cubed per mole", 
   FractionBox[
    SuperscriptBox["\"Centimeters\"", "3"], "\"Moles\""]},
  "Quantity"]], "Output",
 CellLabel->"Out[2]=",
 CellID->748553549,ExpressionUUID->"a51d9c79-d00f-43d7-8c60-832b3ceca17a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UnitConvert", "[", 
  RowBox[{
   TemplateBox[{
     RowBox[{"-", "16.924420685417008`"}]},
    "QuantityUnit",
    DisplayFunction->(TooltipBox[
      StyleBox[
       RowBox[{#, "\[InvisibleSpace]", 
         StyleBox[
          RowBox[{" ", 
            RowBox[{
              SuperscriptBox["\"cm\"", "3"], "\[NegativeMediumSpace]", 
              "\"/\"", "\[InvisibleSpace]", "\"mol\""}]}], 
          "QuantityUnitTraditionalLabel"]}], ShowStringCharacters -> False], 
      "Unit: centimeters cubed per mole"]& ),
    InterpretationFunction->(RowBox[{"Quantity", "[", 
       RowBox[{#, ",", 
         FractionBox[
          SuperscriptBox["\"Centimeters\"", "3"], "\"Moles\""]}], "]"}]& )], 
   ",", "\"\<dm^3/mol\>\""}], "]"}]], "Input",
 NumberMarks->False,
 CellLabel->"In[3]:=",
 CellID->308610514,ExpressionUUID->"6ce740ab-0895-4b44-b0a1-34ca35e1021e"],

Cell[BoxData[
 TemplateBox[{
   RowBox[{"-", "0.016924420685417007`"}], 
   RowBox[{
     SuperscriptBox["\"dm\"", "3"], "\[NegativeMediumSpace]", "\"/\"", 
     "\[InvisibleSpace]", "\"mol\""}], "decimeters cubed per mole", 
   FractionBox[
    SuperscriptBox["\"Decimeters\"", "3"], "\"Moles\""]},
  "Quantity"]], "Output",
 CellLabel->"Out[3]=",
 CellID->4623770,ExpressionUUID->"6f4e1b7a-224f-4fb9-b64d-31a2c8fce284"]
}, Open  ]],

Cell[TextData[{
 "First derivative of ",
 StyleBox["Z",
  FontSlant->"Italic"],
 " on the saturation curve from NIST"
}], "ExampleText",
 CellID->286706321,ExpressionUUID->"e852b0e2-6b17-4b18-a864-5b651243d3bc"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Rho]BoyleSat", "=", 
  RowBox[{"\[Rho]", "/.", 
   RowBox[{"First", "@", 
    RowBox[{"FindRoot", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"dZtotalNv", "[", 
        RowBox[{
         RowBox[{"TSatNIST", "[", "\[Rho]", "]"}], ",", "\[Rho]"}], "]"}], 
       "\[Equal]", "0"}], ",", 
      RowBox[{"{", 
       RowBox[{"\[Rho]", ",", "0.8"}], "}"}]}], "]"}]}]}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->268249372,ExpressionUUID->"a530487e-cc99-4243-af13-7894d2b4fa09"],

Cell[BoxData["0.7775963533655086`"], "Output",
 CellLabel->"Out[4]=",
 CellID->117169991,ExpressionUUID->"ed8887d0-ec00-4b57-a553-e890b973d765"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"dZtotalNv", "[", 
     RowBox[{
      RowBox[{"TSatNIST", "[", "\[Rho]", "]"}], ",", "\[Rho]"}], "]"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"\[Rho]", ",", "\[Rho]trgaz", ",", "\[Rho]trliq"}], "}"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", "Red", "}"}]}], ",", 
   RowBox[{"AxesOrigin", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\[Rho]c", ",", "0"}], "}"}]}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "\"\<\[Rho] (g/\!\(\*SuperscriptBox[\(cm\), \(3\)]\))\>\"", ",", 
      "\"\<\!\(\*StyleBox[\"(\",FontSlant->\"Italic\"]\)\!\(\*StyleBox[\
FractionBox[RowBox[{\"\[PartialD]\", StyleBox[\"Z\",FontSlant->\"Italic\"]}], \
RowBox[{\"\[PartialD]\", \
StyleBox[\"\[Rho]\",FontSlant->\"Italic\"]}]],FontSlant->\"Italic\"]\)\!\(\*\
StyleBox[SubscriptBox[\")\", \
StyleBox[\"T\",FontSlant->\"Italic\"]],FontSlant->\"Italic\"]\)\!\(\*StyleBox[\
\" \",FontSlant->\"Italic\"]\)\!\(\*StyleBox[\"(\",FontSlant->\"Italic\"]\)\!\
\(\*StyleBox[SuperscriptBox[StyleBox[\"cm\",FontSlant->\"Italic\"], \
\"3\"],FontSlant->\"Italic\"]\)\!\(\*StyleBox[\"/\",FontSlant->\"Italic\"]\)\!\
\(\*StyleBox[\"g\",FontSlant->\"Italic\"]\)\!\(\*StyleBox[\")\",FontSlant->\"\
Italic\"]\)\>\""}], "}"}]}], ",", 
   RowBox[{"ImageSize", "\[Rule]", "400"}], ",", 
   RowBox[{"Epilog", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"PointSize", "[", "Medium", "]"}], ",", 
      RowBox[{"Point", "[", 
       RowBox[{"{", 
        RowBox[{"\[Rho]BoyleSat", ",", "0"}], "}"}], "]"}], ",", 
      RowBox[{"Text", "[", 
       RowBox[{"\"\<\!\(\*SubscriptBox[\(\[Rho]\), \(Boyle\)]\)\>\"", ",", 
        RowBox[{"{", 
         RowBox[{"\[Rho]BoyleSat", ",", "1"}], "}"}]}], "]"}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->605199954,ExpressionUUID->"eb1217c8-6d8a-4b62-93f6-55b0dbd9ead6"],

Cell[BoxData[
 GraphicsBox[
  InterpretationBox[{
    TagBox[{{{}, {}, 
       TagBox[
        {RGBColor[1, 0, 0], AbsoluteThickness[2], Opacity[1.], 
         LineBox[CompressedData["
1:eJwVxXk8lPseAGCmsY9pjJkMqZDUmLGVSNT3LZFQR8l6OC2WELKkQpYkWc7E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          "]]},
        Annotation[#, "Charting`Private`Tag#1"]& ]}, {}},
     {"WolframDynamicHighlight", <|
      "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>}], 
    DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
      Slot["HighlightElements"], 
      Slot["LayoutOptions"], 
      Slot["Meta"], 
      Charting`HighlightActionFunction["DynamicHighlight", {{{{}, {}, 
          Annotation[{
            Directive[
             Opacity[1.], 
             AbsoluteThickness[2], 
             RGBColor[1, 0, 0]], 
            Line[CompressedData["
1:eJwVxXk8lPseAGCmsY9pjJkMqZDUmLGVSNT3LZFQR8l6OC2WELKkQpYkWc7E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             "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
       "HighlightElements" -> <|
         "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
        "LayoutOptions" -> <|
         "PlotRange" -> {{0.0040546000061275735`, 
           1.4168017335853793`}, {-6.465856433181198, 14.542065605047137`}}, 
          "Frame" -> {{True, True}, {True, True}}, 
          "AxesOrigin" -> {0.535599, 0.}, 
          "ImageSize" -> {400, 400/GoldenRatio}, "Axes" -> {True, True}, 
          "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
          "DefaultStyle" -> {
            Directive[
             Opacity[1.], 
             AbsoluteThickness[2], 
             RGBColor[1, 0, 0]]}, 
          "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
              Identity[
               Part[#, 1]], 
              Identity[
               Part[#, 2]]}& ), 
            "ScalingFunctions" -> {{Identity, Identity}, {
              Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>,
         "Meta" -> <|
         "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
          Plot, "GroupHighlight" -> False|>|>]]& )[<|
      "HighlightElements" -> <|
        "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
       "LayoutOptions" -> <|
        "PlotRange" -> {{0.0040546000061275735`, 
          1.4168017335853793`}, {-6.465856433181198, 14.542065605047137`}}, 
         "Frame" -> {{True, True}, {True, True}}, 
         "AxesOrigin" -> {0.535599, 0.}, 
         "ImageSize" -> {400, 400/GoldenRatio}, "Axes" -> {True, True}, 
         "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
         "DefaultStyle" -> {
           Directive[
            Opacity[1.], 
            AbsoluteThickness[2], 
            RGBColor[1, 0, 0]]}, 
         "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
             Identity[
              Part[#, 1]], 
             Identity[
              Part[#, 2]]}& ), 
           "ScalingFunctions" -> {{Identity, Identity}, {
             Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>, 
       "Meta" -> <|
        "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
         Plot, "GroupHighlight" -> False|>|>],
     ImageSizeCache->{{4.503599627370496*^15, -4.503599627370496*^15}, {
      4.503599627370496*^15, -4.503599627370496*^15}}]},
   Annotation[{{{{}, {}, 
       Annotation[{
         Directive[
          Opacity[1.], 
          AbsoluteThickness[2], 
          RGBColor[1, 0, 0]], 
         Line[CompressedData["
1:eJwVxXk8lPseAGCmsY9pjJkMqZDUmLGVSNT3LZFQR8l6OC2WELKkQpYkWc7E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          "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
    "HighlightElements" -> <|
      "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
     "LayoutOptions" -> <|
      "PlotRange" -> {{0.0040546000061275735`, 
        1.4168017335853793`}, {-6.465856433181198, 14.542065605047137`}}, 
       "Frame" -> {{True, True}, {True, True}}, 
       "AxesOrigin" -> {0.535599, 0.}, "ImageSize" -> {400, 400/GoldenRatio}, 
       "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
       GoldenRatio^(-1), "DefaultStyle" -> {
         Directive[
          Opacity[1.], 
          AbsoluteThickness[2], 
          RGBColor[1, 0, 0]]}, 
       "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
           Identity[
            Part[#, 1]], 
           Identity[
            Part[#, 2]]}& ), 
         "ScalingFunctions" -> {{Identity, Identity}, {Identity, Identity}}|>,
        "Primitives" -> {}, "GCFlag" -> False|>, 
     "Meta" -> <|
      "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
       Plot, "GroupHighlight" -> False|>|>, "DynamicHighlight"]],
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0.535599, 0.},
  DisplayFunction->Identity,
  Epilog->{
    PointSize[Medium], 
    PointBox[{0.7775963533655086, 0}], 
    InsetBox[
     FormBox[
     "\"\\!\\(\\*SubscriptBox[\\(\[Rho]\\), \\(Boyle\\)]\\)\"", 
      TraditionalForm], {0.7775963533655086, 1}]},
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{
     FormBox[
      TagBox[
      "\"\\!\\(\\*StyleBox[\\\"(\\\",FontSlant->\\\"Italic\\\"]\\)\\!\\(\\*\
StyleBox[FractionBox[RowBox[{\\\"\[PartialD]\\\", \
StyleBox[\\\"Z\\\",FontSlant->\\\"Italic\\\"]}], RowBox[{\\\"\[PartialD]\\\", \
StyleBox[\\\"\[Rho]\\\",FontSlant->\\\"Italic\\\"]}]],FontSlant->\\\"Italic\\\
\"]\\)\\!\\(\\*StyleBox[SubscriptBox[\\\")\\\", \
StyleBox[\\\"T\\\",FontSlant->\\\"Italic\\\"]],FontSlant->\\\"Italic\\\"]\\)\\\
!\\(\\*StyleBox[\\\" \
\\\",FontSlant->\\\"Italic\\\"]\\)\\!\\(\\*StyleBox[\\\"(\\\",FontSlant->\\\"\
Italic\\\"]\\)\\!\\(\\*StyleBox[SuperscriptBox[StyleBox[\\\"cm\\\",FontSlant->\
\\\"Italic\\\"], \\\"3\\\"],FontSlant->\\\"Italic\\\"]\\)\\!\\(\\*StyleBox[\\\
\"/\\\",FontSlant->\\\"Italic\\\"]\\)\\!\\(\\*StyleBox[\\\"g\\\",FontSlant->\\\
\"Italic\\\"]\\)\\!\\(\\*StyleBox[\\\")\\\",FontSlant->\\\"Italic\\\"]\\)\"", 
       HoldForm], TraditionalForm], None}, {
     FormBox[
      TagBox[
      "\"\[Rho] (g/\\!\\(\\*SuperscriptBox[\\(cm\\), \\(3\\)]\\))\"", 
       HoldForm], TraditionalForm], None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  ImageSize->400,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0.0040546000061275735`, 
   1.4168017335853793`}, {-6.465856433181198, 14.542065605047137`}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellLabel->"Out[5]=",
 CellID->127282287,ExpressionUUID->"ea2208e6-f4a4-4166-aaa0-977e61a663ee"]
}, Open  ]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"}, 
  Closed]]]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "2"},
        Closed], 
      Alternatives[Open, True]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{
    13.600000000000001`, {0.5800000000000001, 13.020000000000001`}}]],
  ExpressionUUID->"3528b015-c02c-42b1-85ff-d006ff1b84fd"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"5a4acfd9-11f7-431e-9b5a-ff76b75a3569"],
 "Possible Issues",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "e0ba6d8f-4a7e-402e-88a8-a32beb4883f4"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellID->1305812373,ExpressionUUID->"f89058d9-8d97-4caa-b226-694728682cba"],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<NewEoSArgon`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->510497063,ExpressionUUID->"374e2f4c-0bb3-4ee1-a106-ee14f2c34704"],

Cell["Corresponding properties of the Boyle inversion curve", "ExampleText",
 CellID->109328850,ExpressionUUID->"a9163867-ec02-4725-ac85-69d0f44377f6"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", 
   RowBox[{"\[Rho]", ",", "P"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"DataPT\[Rho]", "=", 
   RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Rho]Boyle", "=", "\[Rho]trliq"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 StyleBox[
  RowBox[{
   RowBox[{"T", "=", "tc"}], ";"}],
  FontColor->RGBColor[1, 0, 1]], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sol", "=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"s", "=", "0"}], ",", 
       RowBox[{"e", "=", "0"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"First", "@", 
        RowBox[{"FindRoot", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"dZtotalNv", "[", 
            RowBox[{"T", ",", "\[Rho]"}], "]"}], "\[Equal]", "0"}], ",", 
          RowBox[{"{", 
           RowBox[{"\[Rho]", ",", "\[Rho]trliq"}], "}"}], ",", 
          RowBox[{"StepMonitor", "\[RuleDelayed]", 
           RowBox[{"s", "++"}]}], ",", 
          RowBox[{"EvaluationMonitor", "\[RuleDelayed]", 
           RowBox[{"e", "++"}]}]}], "]"}]}], ",", 
       RowBox[{"\"\<Steps\>\"", "\[Rule]", "s"}], ",", 
       RowBox[{"\"\<Evaluations\>\"", "\[Rule]", "e"}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Rho]Boyle", "=", 
   RowBox[{"\[Rho]", "/.", 
    RowBox[{"First", "@", "sol"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"P", "=", 
    RowBox[{"PArgonNv", "[", 
     RowBox[{"T", ",", "\[Rho]Boyle"}], "]"}]}], ";"}], 
  RowBox[{"(*", "bar", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"\[Rho]Boyle", ">", "0"}], "&&", 
      RowBox[{"\[Rho]Boyle", "<", "2"}]}], ",", 
     RowBox[{"AppendTo", "[", 
      RowBox[{"DataPT\[Rho]", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"P", "/", "pc"}], ",", 
         RowBox[{"T", "/", "tc"}], ",", 
         RowBox[{"\[Rho]Boyle", "/", "\[Rho]c"}]}], "}"}]}], "]"}]}], "]"}], 
   ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 StyleBox[
  RowBox[{
   RowBox[{"T", "=", "tcNv"}], ";"}],
  FontColor->RGBColor[1, 0, 1]], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sol", "=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"s", "=", "0"}], ",", 
       RowBox[{"e", "=", "0"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"First", "@", 
        RowBox[{"FindRoot", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"dZtotalNv", "[", 
            RowBox[{"T", ",", "\[Rho]"}], "]"}], "\[Equal]", "0"}], ",", 
          RowBox[{"{", 
           RowBox[{"\[Rho]", ",", "\[Rho]trliq"}], "}"}], ",", 
          RowBox[{"StepMonitor", "\[RuleDelayed]", 
           RowBox[{"s", "++"}]}], ",", 
          RowBox[{"EvaluationMonitor", "\[RuleDelayed]", 
           RowBox[{"e", "++"}]}]}], "]"}]}], ",", 
       RowBox[{"\"\<Steps\>\"", "\[Rule]", "s"}], ",", 
       RowBox[{"\"\<Evaluations\>\"", "\[Rule]", "e"}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Rho]Boyle", "=", 
   RowBox[{"\[Rho]", "/.", 
    RowBox[{"First", "@", "sol"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"P", "=", 
    RowBox[{"PArgonNv", "[", 
     RowBox[{"T", ",", "\[Rho]Boyle"}], "]"}]}], ";"}], 
  RowBox[{"(*", "bar", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"\[Rho]Boyle", ">", "0"}], "&&", 
      RowBox[{"\[Rho]Boyle", "<", "2"}]}], ",", 
     RowBox[{"AppendTo", "[", 
      RowBox[{"DataPT\[Rho]", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"P", "/", "pc"}], ",", 
         RowBox[{"T", "/", "tc"}], ",", 
         RowBox[{"\[Rho]Boyle", "/", "\[Rho]c"}]}], "}"}]}], "]"}]}], "]"}], 
   ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"For", "[", 
    RowBox[{
     RowBox[{"i", "=", "1"}], ",", 
     RowBox[{"i", "\[LessEqual]", "9"}], ",", 
     RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"T", "=", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "+", 
          FractionBox["i", "5"]}], ")"}], 
        FractionBox["tcNv", "1.05"]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"sol", "=", 
       RowBox[{"Module", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"s", "=", "0"}], ",", 
           RowBox[{"e", "=", "0"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"First", "@", 
            RowBox[{"FindRoot", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"Re", "[", 
                RowBox[{"dZtotalNv", "[", 
                 RowBox[{"T", ",", "\[Rho]"}], "]"}], "]"}], "\[Equal]", 
               "0"}], ",", 
              RowBox[{"{", 
               RowBox[{"\[Rho]", ",", "\[Rho]trliq"}], "}"}], ",", 
              RowBox[{"StepMonitor", "\[RuleDelayed]", 
               RowBox[{"s", "++"}]}], ",", 
              RowBox[{"EvaluationMonitor", "\[RuleDelayed]", 
               RowBox[{"e", "++"}]}]}], "]"}]}], ",", 
           RowBox[{"\"\<Steps\>\"", "\[Rule]", "s"}], ",", 
           RowBox[{"\"\<Evaluations\>\"", "\[Rule]", "e"}]}], "}"}]}], 
        "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"\[Rho]Boyle", "=", 
       RowBox[{"\[Rho]", "/.", 
        RowBox[{"First", "@", "sol"}]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"P", "=", 
       RowBox[{"PArgonNv", "[", 
        RowBox[{"T", ",", "\[Rho]Boyle"}], "]"}]}], ";", 
      RowBox[{"(*", "bar", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"\[Rho]Boyle", ">", "0"}], "&&", 
         RowBox[{"\[Rho]Boyle", "<", "2"}]}], ",", 
        RowBox[{"AppendTo", "[", 
         RowBox[{"DataPT\[Rho]", ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"P", "/", "pc"}], ",", 
            RowBox[{"T", "/", "tc"}], ",", 
            RowBox[{"\[Rho]Boyle", "/", "\[Rho]c"}]}], "}"}]}], "]"}]}], 
       "]"}], ";"}]}], "\[IndentingNewLine]", "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
  "Print", "[", 
   "\"\<In the following table, \!\(\*SubscriptBox[StyleBox[\"P\",FontSlant->\
\"Italic\"], \"c\"]\), \!\(\*StyleBox[SubscriptBox[\"T\", \
\"c\"],FontSlant->\"Italic\"]\) and \
\!\(\*SubscriptBox[StyleBox[\"\[Rho]\",FontSlant->\"Italic\"], \"c\"]\) are \
the values given by NIST\>\"", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"TableForm", "[", 
  RowBox[{"DataPT\[Rho]", ",", 
   RowBox[{"TableHeadings", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"None", ",", 
      RowBox[{"{", 
       RowBox[{
       "\"\<P/\!\(\*SubscriptBox[\(P\), \(c\)]\)\>\"", ",", 
        "\"\<T/\!\(\*SubscriptBox[\(T\), \(c\)]\)\>\"", ",", 
        "\"\<\[Rho]/\!\(\*SubscriptBox[\(\[Rho]\), \(c\)]\)\>\""}], "}"}]}], 
     "}"}]}]}], "]"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->708360938,ExpressionUUID->"8ff05ced-c907-4ceb-8351-f30353a86d69"],

Cell[BoxData["\<\"In the following table, \
\\!\\(\\*SubscriptBox[StyleBox[\\\"P\\\",FontSlant->\\\"Italic\\\"], \
\\\"c\\\"]\\), \\!\\(\\*StyleBox[SubscriptBox[\\\"T\\\", \
\\\"c\\\"],FontSlant->\\\"Italic\\\"]\\) and \
\\!\\(\\*SubscriptBox[StyleBox[\\\"\[Rho]\\\",FontSlant->\\\"Italic\\\"], \
\\\"c\\\"]\\) are the values given by NIST\"\>"], "Print",
 CellLabel->"Lors de l\[CloseCurlyQuote]\[EAcute]valuation de In[20]:=",
 CellID->201320480,ExpressionUUID->"13fa2096-0c8b-428b-b445-e5496914b0d5"],

Cell[BoxData[
 TagBox[
  TagBox[GridBox[{
     {
      TagBox["\<\"P/\\!\\(\\*SubscriptBox[\\(P\\), \\(c\\)]\\)\"\>",
       HoldForm], 
      TagBox["\<\"T/\\!\\(\\*SubscriptBox[\\(T\\), \\(c\\)]\\)\"\>",
       HoldForm], 
      TagBox["\<\"\[Rho]/\\!\\(\\*SubscriptBox[\\(\[Rho]\\), \\(c\\)]\\)\"\>",
       HoldForm]},
     {"1.0655580170076548`", "1.`", "1.4172521420517548`"},
     {"1.1079331112874775`", "1.0047051172297543`", "1.4092370278204482`"},
     {"2.2091797247115705`", "1.1482344196911476`", "1.220121195213534`"},
     {"3.1433725534214343`", "1.3396068229730054`", "1.0246762644922922`"},
     {"3.5841655363780416`", "1.5309792262548636`", "0.8528655757357154`"},
     {"3.6320758533310227`", "1.7223516295367214`", "0.6943104041579005`"},
     {"3.364576155246406`", "1.9137240328185794`", "0.5454075846327923`"},
     {"2.844034929822863`", "2.105096436100437`", "0.40459931041864666`"},
     {"2.1199809007559454`", "2.296468839382295`", "0.27094671774341006`"},
     {"1.220133221974465`", "2.487841242664153`", "0.14247216835300086`"},
     {"0.18575261608871146`", "2.6792136459460107`", "0.020073267243154568`"}
    },
    GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
    GridBoxDividers->{
     "Columns" -> {{False}}, "Rows" -> {False, True, {False}, False}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[2.0999999999999996`]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}],
   {None, OutputFormsDump`HeadedColumns}],
  Function[BoxForm`e$, 
   TableForm[
   BoxForm`e$, 
    TableHeadings -> {
     None, {"P/\!\(\*SubscriptBox[\(P\), \(c\)]\)", 
       "T/\!\(\*SubscriptBox[\(T\), \(c\)]\)", 
       "\[Rho]/\!\(\*SubscriptBox[\(\[Rho]\), \(c\)]\)"}}]]]], "Output",
 CellLabel->"Out[2]//TableForm=",
 CellID->263491252,ExpressionUUID->"4effbf63-05fc-4615-82fe-bded5370d8a3"]
}, Open  ]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "2"}, 
  Closed]]]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "PrimaryExamplesSection"}, 
  Closed]]]],

Cell[BoxData[GridBox[{
   {
    DynamicBox[FEPrivate`ImportImage[
      FrontEnd`FileName[{"Documentation", "FooterIcons"}, 
       "RelatedFunction.png"]],
     ImageSizeCache->{50., {27., 33.}}], GridBox[{
      {
       StyleBox[
        RowBox[{"See", " ", "Also"}], "SeeAlsoSection"]},
      {Cell[TextData[{
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["ZtotalNv"]], "paclet:NewEoSArgon/ref/ZtotalNv", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "907bdeb1-80d7-49ad-a59b-b569d5db3722"],
        "\[NonBreakingSpace]",
        StyleBox[
        "\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
         "InlineSeparator"],
        " ",
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["dPArgonNvdRho"]], 
           "paclet:NewEoSArgon/ref/dPArgonNvdRho", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "633ae372-215a-4966-83f3-86b4c6fc20a6"]
       }], "SeeAlso",ExpressionUUID->"54fd1629-4b42-4ba4-b7f6-f94ce580328c"]}
     }]}
  }]], "SeeAlsoSection",ExpressionUUID->"c489b950-ec8a-4027-a02f-\
95300df62e07"],

Cell[BoxData[GridBox[{
   {
    DynamicBox[FEPrivate`ImportImage[
      FrontEnd`FileName[{"Documentation", "FooterIcons"}, "RelatedGuide.png"]],
     ImageSizeCache->{50., {27., 33.}}], GridBox[{
      {
       StyleBox[
        RowBox[{"Related", " ", "Guides"}], "MoreAboutSection"]},
      {
       RowBox[{"\[FilledVerySmallSquare]", Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["NewEoSArgon Package"]], 
           "paclet:NewEoSArgon/guide/NewEoSArgon"},
          "RefLinkPlain",
          BaseStyle->{"MoreAbout"}]], "MoreAbout",ExpressionUUID->
         "1015a9e9-dd3d-43d8-96ce-2c43cbc51ce2"]}]}
     }]}
  }]], "MoreAboutSection",ExpressionUUID->"1f83d676-a016-40f8-81f1-\
1df21ed053f4"],

Cell[BoxData[GridBox[{
   {
    TemplateBox[{29},
     "Spacer1"], GridBox[{
      {
       RowBox[{
        TemplateBox[{17},
         "Spacer1"], 
        StyleBox[
         RowBox[{"Related", " ", "Links"}], "RelatedLinksSection"]}]},
      {Cell[BoxData[Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData[
             RowBox[{
               RowBox[{"Units", " ", "&"}], " ", "Quantities"}]]], 
           "paclet:guide/Units"},
          "RefLinkPlain",
          BaseStyle->{"RelatedLinks"}]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "1f339bc0-b37e-4a87-9aed-dbf55b58b26a"]], "RelatedLinks",
        ExpressionUUID->"9b81c962-aed8-4963-a41c-601bff847b37"]},
      {Cell[BoxData[Cell[BoxData[Cell[BoxData[
          RowBox[{
           TemplateBox[{16},
            "Spacer1"], "\[FilledVerySmallSquare]", 
           TemplateBox[{
             Cell[
              TextData[
               Cell[
                TextData[{
                  Cell[
                   BoxData[
                    TemplateBox[{2}, "Spacer1"]]], "ThermodynamicData"}]]]], 
             "paclet:ref/ThermodynamicData"},
            "RefLink",
            BaseStyle->{"RelatedLinks"}]}]],ExpressionUUID->
          "d2825ae6-3b96-4655-b9f7-902d128cce4b"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "9d622a7a-432d-41cd-ba7d-711d453e24d1"]], "RelatedLinks",
        ExpressionUUID->"dedd3947-4a85-45cd-b2ca-151a404f4c8a"]}
     }]}
  }]], "RelatedLinksSection",ExpressionUUID->"e6a5bf1d-df2e-4a76-b6f5-\
18af619d2b59"],

Cell[" ", "FooterCell",ExpressionUUID->"8de37772-b62f-4c5e-a422-ff5b8f0ef6ff"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{900, 835.8},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"dZtotalNv",
TaggingRules->{
 "ModificationHighlight" -> False, "ColorType" -> "", "LinkTrails" -> "", 
  "HasOptions" -> True, "ExampleCounter" -> 1, 
  "Openers" -> {
   "PrimaryExamplesSection" -> Open, 
    "ExampleSection" -> {"0" -> Open, "2" -> Closed}, "NotesSection" -> 
    Closed}, "NewStyles" -> True, "CitationPopupData" -> $Failed, 
  "ShowCitation" -> False, "RootCaptions" -> "", 
  "Metadata" -> {
   "built" -> "{2023, 11, 30, 13, 55, 36.2150406}", 
    "history" -> {"XX", "", "", ""}, "context" -> "NewEoSArgon`", 
    "keywords" -> {}, "specialkeywords" -> {}, 
    "tutorialcollectionlinks" -> {}, "index" -> True, "label" -> 
    "New Eo S Argon Package Symbol", "language" -> "en", "paclet" -> 
    "NewEoSArgon Package", "status" -> "None", "summary" -> 
    "dZtotalNv[T, \\[Rho]] \\[Congruent] (\\[PartialD]Z/\\[PartialD]\\[Rho]) \
T (cm^3/g) D\[EAcute]riv\[EAcute]e partielle premi\[EGrave]re par rapport \
\[AGrave] T du facteur de compressibilit\[EAcute] Z en fonction de T (Kelvin) \
et de \\[Rho] (g/cm^3) [First partial derivative of compressibility factor Z \
with respect to density versus T (Kelvin) and \\[Rho] (g/cm^3)]", 
    "synonyms" -> {}, "tabletags" -> {}, "title" -> "dZtotalNv", 
    "titlemodifier" -> "", "metadescription" -> "", "windowtitle" -> 
    "dZtotalNv", "type" -> "Symbol", "uri" -> "NewEoSArgon/ref/dZtotalNv"}},
CellContext->"Global`",
FrontEndVersion->"13.3 pour Microsoft Windows (64-bit) (July 24, 2023)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "13.3 pour Microsoft Windows (64-bit) (July 24, 2023)", 
  StyleDefinitions -> "Default.nb"],
ExpressionUUID->"1332d37c-30f8-4358-b99f-dee6cfff43e9"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[11071, 305, 1420, 37, 35, "PrimaryExamplesSection",ExpressionUUID->"d0f77958-e074-47d0-967d-a25780ffb3c6",
   CellTags->"PrimaryExamplesSection",
   CellID->276086021]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 55575, 1383}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[581, 21, 5300, 129, 56, "AnchorBarGrid",ExpressionUUID->"166700ad-d5cc-4139-8726-e68a609ead99",
 CellID->1],
Cell[5884, 152, 94, 0, 23, "ContextNameCell",ExpressionUUID->"5041cc22-4360-4645-a788-256078674a04"],
Cell[CellGroupData[{
Cell[6003, 156, 552, 14, 56, "ObjectNameGrid",ExpressionUUID->"81845bb1-85e4-46fb-8567-f29c307fc737"],
Cell[6558, 172, 1804, 52, 151, "Usage",ExpressionUUID->"d1be4379-f018-4721-a203-ec3ec2be425a"]
}, Open  ]],
Cell[CellGroupData[{
Cell[8399, 229, 1919, 48, 37, "NotesSection",ExpressionUUID->"4c5f1473-2ed9-4772-b483-7739f2f5c270",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->320147203],
Cell[10321, 279, 220, 6, 36, "Notes",ExpressionUUID->"ad6a8455-9f87-4e81-9939-a6fda6aed529",
 CellID->1067943069],
Cell[10544, 287, 185, 4, 36, "Notes",ExpressionUUID->"791285a3-9baf-4605-8cfb-8913b0ff906a",
 CellID->185021568],
Cell[10732, 293, 212, 6, 36, "Notes",ExpressionUUID->"af529707-de8f-4e53-a3f1-b4aeb2c31667",
 CellID->175218415]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "NotesSection"}, Closed]]]],
Cell[CellGroupData[{
Cell[11071, 305, 1420, 37, 35, "PrimaryExamplesSection",ExpressionUUID->"d0f77958-e074-47d0-967d-a25780ffb3c6",
 CellTags->"PrimaryExamplesSection",
 CellID->276086021],
Cell[CellGroupData[{
Cell[12516, 346, 1398, 36, 30, "ExampleSection",ExpressionUUID->"456cd1ba-fd96-42f7-87d0-bfa33eb46abe",
 CellID->300887851],
Cell[13917, 384, 268, 5, 42, "Input",ExpressionUUID->"5885db29-64c5-4e3d-ac5b-10d79cb8a8fd",
 CellID->143015886],
Cell[14188, 391, 479, 15, 46, "ExampleText",ExpressionUUID->"50f7973d-94c7-494e-9658-3c8c21de2c39",
 CellID->544149791],
Cell[CellGroupData[{
Cell[14692, 410, 1200, 29, 57, "Input",ExpressionUUID->"6b02e2d8-4460-448d-823c-cb29596ca006",
 CellID->254692277],
Cell[15895, 441, 423, 10, 43, "Output",ExpressionUUID->"a51d9c79-d00f-43d7-8c60-832b3ceca17a",
 CellID->748553549]
}, Open  ]],
Cell[CellGroupData[{
Cell[16355, 456, 890, 23, 30, "Input",ExpressionUUID->"6ce740ab-0895-4b44-b0a1-34ca35e1021e",
 CellID->308610514],
Cell[17248, 481, 421, 10, 43, "Output",ExpressionUUID->"6f4e1b7a-224f-4fb9-b64d-31a2c8fce284",
 CellID->4623770]
}, Open  ]],
Cell[17684, 494, 211, 6, 38, "ExampleText",ExpressionUUID->"e852b0e2-6b17-4b18-a864-5b651243d3bc",
 CellID->286706321],
Cell[CellGroupData[{
Cell[17920, 504, 506, 14, 26, "Input",ExpressionUUID->"a530487e-cc99-4243-af13-7894d2b4fa09",
 CellID->268249372],
Cell[18429, 520, 144, 2, 35, "Output",ExpressionUUID->"ed8887d0-ec00-4b57-a553-e890b973d765",
 CellID->117169991]
}, Open  ]],
Cell[CellGroupData[{
Cell[18610, 527, 1978, 45, 88, "Input",ExpressionUUID->"eb1217c8-6d8a-4b62-93f6-55b0dbd9ead6",
 CellID->605199954],
Cell[20591, 574, 17160, 337, 270, "Output",ExpressionUUID->"ea2208e6-f4a4-4166-aaa0-977e61a663ee",
 CellID->127282287]
}, Open  ]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"}, Closed]]]],
Cell[CellGroupData[{
Cell[37900, 919, 1423, 37, 70, "ExampleSection",ExpressionUUID->"f89058d9-8d97-4caa-b226-694728682cba",
 CellID->1305812373],
Cell[39326, 958, 175, 3, 70, "Input",ExpressionUUID->"374e2f4c-0bb3-4ee1-a106-ee14f2c34704",
 CellID->510497063],
Cell[39504, 963, 151, 1, 70, "ExampleText",ExpressionUUID->"a9163867-ec02-4725-ac85-69d0f44377f6",
 CellID->109328850],
Cell[CellGroupData[{
Cell[39680, 968, 7199, 200, 70, "Input",ExpressionUUID->"8ff05ced-c907-4ceb-8351-f30353a86d69",
 CellID->708360938],
Cell[46882, 1170, 503, 7, 70, "Print",ExpressionUUID->"13fa2096-0c8b-428b-b445-e5496914b0d5",
 CellID->201320480],
Cell[47388, 1179, 1954, 41, 217, "Output",ExpressionUUID->"4effbf63-05fc-4615-82fe-bded5370d8a3",
 CellID->263491252]
}, Open  ]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "2"}, Closed]]]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "PrimaryExamplesSection"}, Closed]]]],
Cell[49584, 1229, 1385, 37, 70, "SeeAlsoSection",ExpressionUUID->"c489b950-ec8a-4027-a02f-95300df62e07"],
Cell[50972, 1268, 729, 19, 70, "MoreAboutSection",ExpressionUUID->"1f83d676-a016-40f8-81f1-1df21ed053f4"],
Cell[51704, 1289, 1607, 43, 70, "RelatedLinksSection",ExpressionUUID->"e6a5bf1d-df2e-4a76-b6f5-18af619d2b59"],
Cell[53314, 1334, 78, 0, 70, "FooterCell",ExpressionUUID->"8de37772-b62f-4c5e-a422-ff5b8f0ef6ff"]
}
]
*)

(* End of internal cache information *)

