(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 13.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     57466,       1259]
NotebookOptionsPosition[     52198,       1154]
NotebookOutlinePosition[     54666,       1213]
CellTagsIndexPosition[     54580,       1208]
WindowTitle->dZtotalNvdT
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[GridBox[{
   {GridBox[{
      {
       ItemBox[Cell[BoxData[
         RowBox[{
          TemplateBox[{12},
           "Spacer1"], Cell["NEW EO S ARGON PACKAGE SYMBOL", "PacletNameCell",
           TextAlignment->Center,ExpressionUUID->
           "98d4e11e-46dc-4562-ac0c-cb186e15a85b"], 
          TemplateBox[{8},
           "Spacer1"]}]],
         TextAlignment->Center,ExpressionUUID->
         "8c17d8ba-e697-49d1-b21c-b1daeead2b19"],
        Background->RGBColor[0.490196, 0.576471, 0.690196],
        ItemSize->Full], ""}
     },
     GridBoxAlignment->{"Rows" -> {{Center}}},
     GridBoxItemSize->{"Columns" -> {Full, 
         Scaled[0.02]}, "Rows" -> {{2.5}}}], Cell[TextData[{
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "See Also",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "6e614c82-04bf-4e10-a709-cb30e35ed4db"]
         }],ExpressionUUID->"fbafb464-4b18-4986-802c-3bf7d67215b4"],
         StripOnInput->False],{
        "\"ZtotalNv\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/ZtotalNv"], 
         "\"dPArgonNvdT\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/dPArgonNvdT"]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"SeeAlso"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "acb5462e-4451-4487-8cfe-29a6f17a7bf8"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "Related Guides",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "1fecaacf-2df3-4f7c-a4a3-022f8fdb3041"]
         }],ExpressionUUID->"87d172bd-2aa7-4134-ae43-ffa5928fb836"],
         StripOnInput->False],{
        "\"NewEoSArgon Package\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/guide/NewEoSArgon"]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"MoreAbout"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "ce7adfe8-dba4-4c65-89c8-1eb475513871"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "URL",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "255038fc-d01b-4bdf-849a-f0ba4bf0ec63"]
         }],ExpressionUUID->"17baa76c-0ec1-470e-9488-5813ab163c6f"],
         StripOnInput->False],{
        "\"NewEoSArgon/ref/dZtotalNvdT\"" :> None, 
         "\"Copy Wolfram Documentation Center URL\"" :> 
         Module[{DocumentationSearch`Private`nb$}, 
           DocumentationSearch`Private`nb$ = 
            NotebookPut[
             Notebook[{Cell["NewEoSArgon/ref/dZtotalNvdT"]}, Visible -> 
               False]]; 
           SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
           FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
           NotebookClose[DocumentationSearch`Private`nb$]; Null], Delimiter, 
         "\"Copy web URL\"" :> 
         Module[{DocumentationSearch`Private`nb$}, 
           DocumentationSearch`Private`nb$ = 
            NotebookPut[
             Notebook[{
               Cell[BoxData[
                 MakeBoxes[
                  Hyperlink[
                   "http://reference.wolfram.com/language/NewEoSArgon/ref/\
dZtotalNvdT.html"], StandardForm]], "Input", TextClipboardType -> 
                 "PlainText"]}, Visible -> False]]; 
           SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
           FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
           NotebookClose[DocumentationSearch`Private`nb$]; Null], 
         "\"Go to web URL\"" :> 
         FrontEndExecute[{
           NotebookLocate[{
             URL[If[TrueQ[DocumentationBuild`Make`Private`wsmlinkQ$13565], 
                 "http://reference.wolfram.com/system-modeler/", 
                 "http://reference.wolfram.com/language/"] <> 
               "NewEoSArgon/ref/dZtotalNvdT" <> ".html"], None}]}]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"URLMenu"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "59fb1378-fab5-446c-8f2d-a307e45b0be9"]
    }], "AnchorBar",
     CacheGraphics->False,ExpressionUUID->
     "f9744e00-962c-4e99-91ab-c52269c0e190"]}
  }]], "AnchorBarGrid",
 CellID->1,ExpressionUUID->"c03ce585-5095-4534-a9f1-7c654ae27e0d"],

Cell["NewEoSArgon`", "ContextNameCell",ExpressionUUID->"c205c592-8b10-4177-82ba-e384916b2741"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     Cell[
     "dZtotalNvdT", "ObjectName",ExpressionUUID->
      "89664bf9-2b4d-45c1-a357-fef589c94d0e"],
     Cell[BoxData[
      TemplateBox[{8},
       "Spacer1"]],ExpressionUUID->"3b69168c-9c4d-4375-bbde-365a9e3cc5ff"],
     Cell[BoxData[
     ""], "ObjectNameTranslation",ExpressionUUID->
      "dfd55dcc-d43b-4969-8d3f-b07d42998cf4"]
    }],ExpressionUUID->"1e983d95-fff9-40e1-a8fc-93a6eb44f949"], 
    "\[SpanFromLeft]"}
  }]], "ObjectNameGrid",ExpressionUUID->"064557f9-97f7-4f35-932a-\
c9e586957cad"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     "dZtotalNvdT[",
     StyleBox["T",
      FontSlant->"Italic"],
     ", \[Rho]] \[Congruent] ",
     Cell[BoxData[
      SubscriptBox[
       RowBox[{"(", 
        FractionBox[
         RowBox[{"\[PartialD]", 
          StyleBox["Z",
           FontSlant->"Italic"]}], 
         RowBox[{"\[PartialD]", 
          StyleBox["T",
           FontSlant->"Italic"]}]], ")"}], 
       StyleBox["\[Rho]",
        FontSlant->"Italic"]]], "InlineFormula",
      FontFamily->"Source Sans Pro",ExpressionUUID->
      "8f8483dd-7f2e-419c-993f-c780ef75af5a"],
     " (",
     Cell[BoxData[
      SuperscriptBox["K", 
       RowBox[{"-", "1"}]]], "InlineFormula",
      FontFamily->"Source Sans Pro",ExpressionUUID->
      "6990d26a-053f-4143-95fb-d873edbc75b4"],
     ")\nD\[EAcute]riv\[EAcute]e partielle premi\[EGrave]re par rapport \
\[AGrave] ",
     StyleBox["T",
      FontSlant->"Italic"],
     " du facteur de compressibilit\[EAcute] Z en fonction de ",
     StyleBox["T",
      FontSlant->"Italic"],
     " (Kelvin) et de \[Rho] (g/",
     Cell[BoxData[
      SuperscriptBox["cm", "3"]], "InlineFormula",
      FontFamily->"Source Sans Pro",ExpressionUUID->
      "34c8637a-b854-4f23-a5b8-981a23ae4702"],
     ") \n[First partial derivative of compressibility factor ",
     StyleBox["Z",
      FontSlant->"Italic"],
     " with respect to temperature as a function of ",
     StyleBox["T",
      FontSlant->"Italic"],
     " (Kelvin) and \[Rho] (g/",
     Cell[BoxData[
      SuperscriptBox["cm", "3"]], "InlineFormula",
      FontFamily->"Source Sans Pro",ExpressionUUID->
      "1970ae1f-f075-4171-bc9e-05134cfe236a"],
     ")]"
    }],ExpressionUUID->"8f5b9c81-9138-4880-9cf4-48b7d2d965bd"]}
  }]], "Usage",ExpressionUUID->"d41f9f13-aa02-445a-8f40-22b1024a58a7"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[Cell[TextData[{
   Cell[BoxData[
    DynamicBox[ToBoxes[
      If[
       MatchQ[
        CurrentValue[
         EvaluationNotebook[], {TaggingRules, "Openers", "NotesSection"}, 
         Closed], 
        Alternatives[Open, True]], 
       Style[
        Graphics[{
          Thickness[0.18], 
          RGBColor[0.8509803921568627, 0.396078431372549, 0], 
          Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
         PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
        0.68 Inherited], 
       Rotate[
        Style[
         Graphics[{
           Thickness[0.18], 
           RGBColor[0.8509803921568627, 0.396078431372549, 0], 
           Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
          PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
         0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
     ImageSizeCache->{
      13.600000000000001`, {0.5800000000000001, 13.020000000000001`}}]],
    ExpressionUUID->"53556f5f-66c6-46a3-bd87-b0bb31e5566b"],
   Cell[BoxData[
    TemplateBox[{1},
     "Spacer1"]],ExpressionUUID->"15b6c291-0b11-4d8a-b261-c8cf738dbbb0"],
   "Details and Options"
  }], "NotesFrameText",ExpressionUUID->"e47a88cb-23e4-41c1-a21c-bcfcc01c0f90"],
  Appearance->{Automatic, None, "Normal", Automatic},
  BaseStyle->None,
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"], 
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], After, CellContents]}]& ),
  Evaluator->None,
  Method->
   "Preemptive"]],ExpressionUUID->"22c00887-58b3-4017-81a4-3a2a2fdf4220"]], \
"NotesSection",
 WholeCellGroupOpener->True,
 CellGroupingRules->{"SectionGrouping", 50},
 CacheGraphics->False,
 CellID->442837337,ExpressionUUID->"e3ae314d-8c4f-43f7-b33c-45511e897cbe"],

Cell[TextData[{
 "La fonction est d\[EAcute]finie pour ",
 StyleBox["T",
  FontSlant->"Italic"],
 " >0 et \[Rho] \[GreaterEqual] 0."
}], "Notes",
 CellID->1067943069,ExpressionUUID->"21cffe5c-d9e8-4dea-9853-bbcb00777681"],

Cell["\<\
******************************************************************************\
*****\
\>", "Notes",
 CellID->185021568,ExpressionUUID->"d321960d-a048-4baf-b21c-4a9a4bdf9996"],

Cell[TextData[{
 "The function is defined for ",
 StyleBox["T",
  FontSlant->"Italic"],
 " >0 and \[Rho] \[GreaterEqual] 0."
}], "Notes",
 CellID->175218415,ExpressionUUID->"5540d3ad-1758-46eb-aa66-10e2101f2c20"]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "NotesSection"}, Closed]]]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {
       TaggingRules, "Openers", "PrimaryExamplesSection"}, Open], 
      Alternatives[True, Open]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{13.600000000000001`, {5., 8.600000000000001}}]],
  ExpressionUUID->"fc39cfd8-3b3e-419e-9673-befcf42425a7"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"87e83e56-2253-4501-a2ac-2eb61780c8d1"],
 "Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "9d693ac8-503f-4ef4-92b3-2b29e3223277"]
}], "PrimaryExamplesSection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellTags->"PrimaryExamplesSection",
 CellID->60898654,ExpressionUUID->"2ccd642f-02c1-491b-a704-9dab0ed8ef5e"],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"},
        Closed], 
      Alternatives[Open, True]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{13.600000000000001`, {5., 8.600000000000001}}]],
  ExpressionUUID->"212b7955-642c-433d-9db8-cb845f9caf04"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"2a634f53-85b7-4791-b809-a11a0d178f68"],
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "8d83e8ed-169e-4f38-b710-f64bfe9c80bd"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellID->20119962,ExpressionUUID->"499036ff-e713-4789-9023-2d218f8898c9"],

Cell[BoxData[{
 RowBox[{"Needs", "[", "\"\<NewEoSArgon`\>\"", "]"}], "\[IndentingNewLine]", 
 RowBox[{"Off", "[", 
  RowBox[{"General", "::", "munfl"}], "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->143015886,ExpressionUUID->"6a75588a-1d43-4217-893e-879d74d9507b"],

Cell[TextData[{
 "Calculated value of ",
 Cell[BoxData[
  SubscriptBox[
   RowBox[{"(", 
    FractionBox[
     RowBox[{"\[PartialD]", 
      StyleBox["Z",
       FontSlant->"Italic"]}], 
     RowBox[{"\[PartialD]", 
      StyleBox["T",
       FontSlant->"Italic"]}]], ")"}], 
   StyleBox["\[Rho]",
    FontSlant->"Italic"]]],ExpressionUUID->
  "34381c52-251f-434d-9f2f-aff93868dc2b"],
 " for atmospheric pressure and 20\[Degree]C"
}], "ExampleText",
 CellID->544149791,ExpressionUUID->"e961e820-c5da-4bf4-9385-f6d2ca771d45"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Quantity", "[", 
  RowBox[{
   RowBox[{"dZtotalNvdT", "[", 
    RowBox[{"293.15", ",", 
     RowBox[{"RhoArgonNv", "[", 
      RowBox[{"293.15", ",", 
       RowBox[{"QuantityMagnitude", "@", 
        RowBox[{"N", "@", 
         RowBox[{"UnitConvert", "[", 
          RowBox[{
           TemplateBox[{"1"},
            "QuantityUnit",
            DisplayFunction->(TooltipBox[
              StyleBox[
               RowBox[{#, "\[InvisibleSpace]", 
                 StyleBox[
                  RowBox[{" ", "\"atm\""}], "QuantityUnitTraditionalLabel"]}],
                ShowStringCharacters -> False], "Unit: atmospheres"]& ),
            InterpretationFunction->(RowBox[{"Quantity", "[", 
               RowBox[{#, ",", "\"Atmospheres\""}], "]"}]& )], ",", 
           "\"\<Bars\>\""}], "]"}]}]}], ",", "\"\<G\>\""}], "]"}]}], "]"}], 
   ",", 
   RowBox[{"1", "/", "\"\<Kelvins\>\""}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->254692277,ExpressionUUID->"244efadb-3db0-4ac4-a9ee-73ec28e26149"],

Cell[BoxData[
 TemplateBox[{"8.322955962834686`*^-6", 
   RowBox[{"\"/\"", "\[InvisibleSpace]", "\"K\""}], "reciprocal kelvins", 
   FractionBox["1", "\"Kelvins\""]},
  "Quantity"]], "Output",
 CellLabel->"Out[2]=",
 CellID->54677457,ExpressionUUID->"978f1742-c9b4-4d48-96c9-3fdb1ed8f44d"]
}, Open  ]],

Cell[TextData[{
 "First derivative of ",
 StyleBox["Z",
  FontSlant->"Italic"],
 " on the saturation curve from NIST"
}], "ExampleText",
 CellID->286706321,ExpressionUUID->"2bd8d481-0473-49b0-9b4a-5976ab43e198"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"dZtotalNvdT", "[", 
     RowBox[{
      RowBox[{"TSatNIST", "[", "\[Rho]", "]"}], ",", "\[Rho]"}], "]"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"\[Rho]", ",", "\[Rho]trgaz", ",", "\[Rho]trliq"}], "}"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", "Red", "}"}]}], ",", 
   RowBox[{"AxesOrigin", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\[Rho]c", ",", "0"}], "}"}]}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "\"\<\[Rho] (g/\!\(\*SuperscriptBox[\(cm\), \(3\)]\))\>\"", ",", 
      "\"\<\!\(\*StyleBox[\"(\",FontSlant->\"Italic\"]\)\!\(\*StyleBox[\
FractionBox[RowBox[{\"\[PartialD]\", StyleBox[\"Z\",FontSlant->\"Italic\"]}], \
RowBox[{\"\[PartialD]\", StyleBox[\"T\",FontSlant->\"Italic\"]}]],FontSlant->\
\"Italic\"]\)\!\(\*StyleBox[SubscriptBox[\")\", \
StyleBox[\"\[Rho]\",FontSlant->\"Italic\"]],FontSlant->\"Italic\"]\)\!\(\*\
StyleBox[\" \
\",FontSlant->\"Italic\"]\)\!\(\*StyleBox[\"(\",FontSlant->\"Italic\"]\)\!\(\*\
StyleBox[SuperscriptBox[StyleBox[\"K\",FontSlant->\"Italic\"], RowBox[{\"-\", \
\"1\"}]],FontSlant->\"Italic\"]\)\!\(\*StyleBox[\")\",FontSlant->\"Italic\"]\)\
\>\""}], "}"}]}], ",", 
   RowBox[{"ImageSize", "\[Rule]", "400"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->605199954,ExpressionUUID->"cb4634ef-1b48-44f0-8b82-861a32627c23"],

Cell[BoxData[
 GraphicsBox[
  InterpretationBox[{
    TagBox[{{{}, {}, 
       TagBox[
        {RGBColor[1, 0, 0], AbsoluteThickness[2], Opacity[1.], 
         LineBox[CompressedData["
1:eJwV13k41F0UB3CkJKWISELiDUlCJduXLFlbiMiSJNkjpajEDEVI0YKsLUgl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          "]]},
        Annotation[#, "Charting`Private`Tag#1"]& ]}, {}},
     {"WolframDynamicHighlight", <|
      "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>}], 
    DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
      Slot["HighlightElements"], 
      Slot["LayoutOptions"], 
      Slot["Meta"], 
      Charting`HighlightActionFunction["DynamicHighlight", {{{{}, {}, 
          Annotation[{
            Directive[
             Opacity[1.], 
             AbsoluteThickness[2], 
             RGBColor[1, 0, 0]], 
            Line[CompressedData["
1:eJwV13k41F0UB3CkJKWISELiDUlCJduXLFlbiMiSJNkjpajEDEVI0YKsLUgl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             "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
       "HighlightElements" -> <|
         "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
        "LayoutOptions" -> <|
         "PlotRange" -> {{0.0040546000061275735`, 1.4168017335853793`}, {0., 
           0.08962786864333014}}, "Frame" -> {{True, True}, {True, True}}, 
          "AxesOrigin" -> {0.535599, 0.}, 
          "ImageSize" -> {400, 400/GoldenRatio}, "Axes" -> {True, True}, 
          "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
          "DefaultStyle" -> {
            Directive[
             Opacity[1.], 
             AbsoluteThickness[2], 
             RGBColor[1, 0, 0]]}, 
          "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
              Identity[
               Part[#, 1]], 
              Identity[
               Part[#, 2]]}& ), 
            "ScalingFunctions" -> {{Identity, Identity}, {
              Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>,
         "Meta" -> <|
         "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
          Plot, "GroupHighlight" -> False|>|>]]& )[<|
      "HighlightElements" -> <|
        "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
       "LayoutOptions" -> <|
        "PlotRange" -> {{0.0040546000061275735`, 1.4168017335853793`}, {0., 
          0.08962786864333014}}, "Frame" -> {{True, True}, {True, True}}, 
         "AxesOrigin" -> {0.535599, 0.}, 
         "ImageSize" -> {400, 400/GoldenRatio}, "Axes" -> {True, True}, 
         "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
         "DefaultStyle" -> {
           Directive[
            Opacity[1.], 
            AbsoluteThickness[2], 
            RGBColor[1, 0, 0]]}, 
         "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
             Identity[
              Part[#, 1]], 
             Identity[
              Part[#, 2]]}& ), 
           "ScalingFunctions" -> {{Identity, Identity}, {
             Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>, 
       "Meta" -> <|
        "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
         Plot, "GroupHighlight" -> False|>|>],
     ImageSizeCache->{{4.503599627370496*^15, -4.503599627370496*^15}, {
      4.503599627370496*^15, -4.503599627370496*^15}}]},
   Annotation[{{{{}, {}, 
       Annotation[{
         Directive[
          Opacity[1.], 
          AbsoluteThickness[2], 
          RGBColor[1, 0, 0]], 
         Line[CompressedData["
1:eJwV13k41F0UB3CkJKWISELiDUlCJduXLFlbiMiSJNkjpajEDEVI0YKsLUgl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          "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
    "HighlightElements" -> <|
      "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
     "LayoutOptions" -> <|
      "PlotRange" -> {{0.0040546000061275735`, 1.4168017335853793`}, {0., 
        0.08962786864333014}}, "Frame" -> {{True, True}, {True, True}}, 
       "AxesOrigin" -> {0.535599, 0.}, "ImageSize" -> {400, 400/GoldenRatio}, 
       "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
       GoldenRatio^(-1), "DefaultStyle" -> {
         Directive[
          Opacity[1.], 
          AbsoluteThickness[2], 
          RGBColor[1, 0, 0]]}, 
       "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
           Identity[
            Part[#, 1]], 
           Identity[
            Part[#, 2]]}& ), 
         "ScalingFunctions" -> {{Identity, Identity}, {Identity, Identity}}|>,
        "Primitives" -> {}, "GCFlag" -> False|>, 
     "Meta" -> <|
      "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
       Plot, "GroupHighlight" -> False|>|>, "DynamicHighlight"]],
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0.535599, 0.},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{
     FormBox[
      TagBox[
      "\"\\!\\(\\*StyleBox[\\\"(\\\",FontSlant->\\\"Italic\\\"]\\)\\!\\(\\*\
StyleBox[FractionBox[RowBox[{\\\"\[PartialD]\\\", \
StyleBox[\\\"Z\\\",FontSlant->\\\"Italic\\\"]}], RowBox[{\\\"\[PartialD]\\\", \
StyleBox[\\\"T\\\",FontSlant->\\\"Italic\\\"]}]],FontSlant->\\\"Italic\\\"]\\)\
\\!\\(\\*StyleBox[SubscriptBox[\\\")\\\", StyleBox[\\\"\[Rho]\\\",FontSlant->\
\\\"Italic\\\"]],FontSlant->\\\"Italic\\\"]\\)\\!\\(\\*StyleBox[\\\" \
\\\",FontSlant->\\\"Italic\\\"]\\)\\!\\(\\*StyleBox[\\\"(\\\",FontSlant->\\\"\
Italic\\\"]\\)\\!\\(\\*StyleBox[SuperscriptBox[StyleBox[\\\"K\\\",FontSlant->\
\\\"Italic\\\"], RowBox[{\\\"-\\\", \
\\\"1\\\"}]],FontSlant->\\\"Italic\\\"]\\)\\!\\(\\*StyleBox[\\\")\\\",\
FontSlant->\\\"Italic\\\"]\\)\"", HoldForm], TraditionalForm], None}, {
     FormBox[
      TagBox[
      "\"\[Rho] (g/\\!\\(\\*SuperscriptBox[\\(cm\\), \\(3\\)]\\))\"", 
       HoldForm], TraditionalForm], None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  ImageSize->400,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0.0040546000061275735`, 1.4168017335853793`}, {0., 
   0.08962786864333014}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellLabel->"Out[3]=",
 CellID->274158550,ExpressionUUID->"2aacaf20-9b15-4ac8-9ce0-16398d529a4b"]
}, Open  ]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"}, 
  Closed]]]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "PrimaryExamplesSection"}, 
  Closed]]]],

Cell[BoxData[GridBox[{
   {
    DynamicBox[FEPrivate`ImportImage[
      FrontEnd`FileName[{"Documentation", "FooterIcons"}, 
       "RelatedFunction.png"]],
     ImageSizeCache->{50., {27., 33.}}], GridBox[{
      {
       StyleBox[
        RowBox[{"See", " ", "Also"}], "SeeAlsoSection"]},
      {Cell[TextData[{
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["ZtotalNv"]], "paclet:NewEoSArgon/ref/ZtotalNv", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "1cc2ca40-1112-4424-86aa-0425ee94e2ba"],
        "\[NonBreakingSpace]",
        StyleBox[
        "\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
         "InlineSeparator"],
        " ",
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["dPArgonNvdT"]], "paclet:NewEoSArgon/ref/dPArgonNvdT", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "2708becb-ed57-416d-ac11-a4ae9b88a9d3"]
       }], "SeeAlso",ExpressionUUID->"f669f1cf-a972-4f47-9cae-5384465cf210"]}
     }]}
  }]], "SeeAlsoSection",ExpressionUUID->"2d2b53f2-4af3-43bc-a493-\
1650523a86ef"],

Cell[BoxData[GridBox[{
   {
    DynamicBox[FEPrivate`ImportImage[
      FrontEnd`FileName[{"Documentation", "FooterIcons"}, "RelatedGuide.png"]],
     ImageSizeCache->{50., {27., 33.}}], GridBox[{
      {
       StyleBox[
        RowBox[{"Related", " ", "Guides"}], "MoreAboutSection"]},
      {
       RowBox[{"\[FilledVerySmallSquare]", Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["NewEoSArgon Package"]], 
           "paclet:NewEoSArgon/guide/NewEoSArgon"},
          "RefLinkPlain",
          BaseStyle->{"MoreAbout"}]], "MoreAbout",ExpressionUUID->
         "6fc15566-1bdb-4a7d-bc59-4740d2ef54db"]}]}
     }]}
  }]], "MoreAboutSection",ExpressionUUID->"a28bd02a-9ed4-4085-ac3f-\
2521baab99a7"],

Cell[BoxData[GridBox[{
   {
    TemplateBox[{29},
     "Spacer1"], GridBox[{
      {
       RowBox[{
        TemplateBox[{17},
         "Spacer1"], 
        StyleBox[
         RowBox[{"Related", " ", "Links"}], "RelatedLinksSection"]}]},
      {Cell[BoxData[Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData[
             RowBox[{
               RowBox[{"Units", " ", "&"}], " ", "Quantities"}]]], 
           "paclet:guide/Units"},
          "RefLinkPlain",
          BaseStyle->{"RelatedLinks"}]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "0e6768a3-ac55-4204-993c-47d75a2d0e88"]], "RelatedLinks",
        ExpressionUUID->"02a736b3-1520-450a-9197-b581a6cf5440"]},
      {Cell[BoxData[Cell[BoxData[Cell[BoxData[
          RowBox[{
           TemplateBox[{16},
            "Spacer1"], "\[FilledVerySmallSquare]", 
           TemplateBox[{
             Cell[
              TextData[
               Cell[
                TextData[{
                  Cell[
                   BoxData[
                    TemplateBox[{2}, "Spacer1"]]], "ThermodynamicData"}]]]], 
             "paclet:ref/ThermodynamicData"},
            "RefLink",
            BaseStyle->{"RelatedLinks"}]}]],ExpressionUUID->
          "a7139cbc-8e97-4c06-97c0-97d899bf4866"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "3d521e87-b080-4f5a-876e-a2a9e825fa95"]], "RelatedLinks",
        ExpressionUUID->"37c0f4d8-4606-4c0d-813f-2a4287e2f147"]}
     }]}
  }]], "RelatedLinksSection",ExpressionUUID->"1c0c3139-605e-483e-8736-\
9f1ab9b220a1"],

Cell[" ", "FooterCell",ExpressionUUID->"ae4a1dd6-59c5-4f4e-9879-6fb319a59560"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{900, 835.8},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"dZtotalNvdT",
TaggingRules->{
 "ModificationHighlight" -> False, "ColorType" -> "", "LinkTrails" -> "", 
  "HasOptions" -> True, "ExampleCounter" -> 1, 
  "Openers" -> {
   "PrimaryExamplesSection" -> Open, "ExampleSection" -> {"0" -> Open}, 
    "NotesSection" -> Closed}, "NewStyles" -> True, 
  "CitationPopupData" -> $Failed, "ShowCitation" -> False, "RootCaptions" -> 
  "", "Metadata" -> {
   "built" -> "{2023, 11, 30, 13, 55, 35.3077924}", 
    "history" -> {"XX", "", "", ""}, "context" -> "NewEoSArgon`", 
    "keywords" -> {}, "specialkeywords" -> {}, 
    "tutorialcollectionlinks" -> {}, "index" -> True, "label" -> 
    "New Eo S Argon Package Symbol", "language" -> "en", "paclet" -> 
    "NewEoSArgon Package", "status" -> "None", "summary" -> 
    "dZtotalNvdT[T, \\[Rho]] \\[Congruent] (\\[PartialD]Z/\\[PartialD]T) \
\\[Rho] (K -1) D\[EAcute]riv\[EAcute]e partielle premi\[EGrave]re par rapport \
\[AGrave] T du facteur de compressibilit\[EAcute] Z en fonction de T (Kelvin) \
et de \\[Rho] (g/cm^3) [First partial derivative of compressibility factor Z \
with respect to temperature as a function of T (Kelvin) and \\[Rho] \
(g/cm^3)]", "synonyms" -> {}, "tabletags" -> {}, "title" -> "dZtotalNvdT", 
    "titlemodifier" -> "", "metadescription" -> "", "windowtitle" -> 
    "dZtotalNvdT", "type" -> "Symbol", "uri" -> 
    "NewEoSArgon/ref/dZtotalNvdT"}},
CellContext->"Global`",
FrontEndVersion->"13.3 pour Microsoft Windows (64-bit) (July 24, 2023)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "13.3 pour Microsoft Windows (64-bit) (July 24, 2023)", 
  StyleDefinitions -> "Default.nb"],
ExpressionUUID->"1741d82e-af1c-4c8f-b023-c7466d79388b"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[11106, 305, 1419, 37, 35, "PrimaryExamplesSection",ExpressionUUID->"2ccd642f-02c1-491b-a704-9dab0ed8ef5e",
   CellTags->"PrimaryExamplesSection",
   CellID->60898654]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 54381, 1201}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[583, 21, 5322, 130, 56, "AnchorBarGrid",ExpressionUUID->"c03ce585-5095-4534-a9f1-7c654ae27e0d",
 CellID->1],
Cell[5908, 153, 94, 0, 23, "ContextNameCell",ExpressionUUID->"c205c592-8b10-4177-82ba-e384916b2741"],
Cell[CellGroupData[{
Cell[6027, 157, 554, 14, 56, "ObjectNameGrid",ExpressionUUID->"064557f9-97f7-4f35-932a-c9e586957cad"],
Cell[6584, 173, 1812, 51, 150, "Usage",ExpressionUUID->"d41f9f13-aa02-445a-8f40-22b1024a58a7"]
}, Open  ]],
Cell[CellGroupData[{
Cell[8433, 229, 1919, 48, 37, "NotesSection",ExpressionUUID->"e3ae314d-8c4f-43f7-b33c-45511e897cbe",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->442837337],
Cell[10355, 279, 221, 6, 36, "Notes",ExpressionUUID->"21cffe5c-d9e8-4dea-9853-bbcb00777681",
 CellID->1067943069],
Cell[10579, 287, 185, 4, 36, "Notes",ExpressionUUID->"d321960d-a048-4baf-b21c-4a9a4bdf9996",
 CellID->185021568],
Cell[10767, 293, 212, 6, 36, "Notes",ExpressionUUID->"5540d3ad-1758-46eb-aa66-10e2101f2c20",
 CellID->175218415]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "NotesSection"}, Closed]]]],
Cell[CellGroupData[{
Cell[11106, 305, 1419, 37, 35, "PrimaryExamplesSection",ExpressionUUID->"2ccd642f-02c1-491b-a704-9dab0ed8ef5e",
 CellTags->"PrimaryExamplesSection",
 CellID->60898654],
Cell[CellGroupData[{
Cell[12550, 346, 1397, 36, 30, "ExampleSection",ExpressionUUID->"499036ff-e713-4789-9023-2d218f8898c9",
 CellID->20119962],
Cell[13950, 384, 268, 5, 42, "Input",ExpressionUUID->"6a75588a-1d43-4217-893e-879d74d9507b",
 CellID->143015886],
Cell[14221, 391, 524, 17, 42, "ExampleText",ExpressionUUID->"e961e820-c5da-4bf4-9385-f6d2ca771d45",
 CellID->544149791],
Cell[CellGroupData[{
Cell[14770, 412, 1028, 25, 42, "Input",ExpressionUUID->"244efadb-3db0-4ac4-a9ee-73ec28e26149",
 CellID->254692277],
Cell[15801, 439, 289, 6, 43, "Output",ExpressionUUID->"978f1742-c9b4-4d48-96c9-3fdb1ed8f44d",
 CellID->54677457]
}, Open  ]],
Cell[16105, 448, 211, 6, 38, "ExampleText",ExpressionUUID->"2bd8d481-0473-49b0-9b4a-5976ab43e198",
 CellID->286706321],
Cell[CellGroupData[{
Cell[16341, 458, 1459, 32, 64, "Input",ExpressionUUID->"cb4634ef-1b48-44f0-8b82-861a32627c23",
 CellID->605199954],
Cell[17803, 492, 30357, 547, 266, "Output",ExpressionUUID->"2aacaf20-9b15-4ac8-9ce0-16398d529a4b",
 CellID->274158550]
}, Open  ]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"}, Closed]]]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "PrimaryExamplesSection"}, Closed]]]],
Cell[48402, 1048, 1369, 36, 70, "SeeAlsoSection",ExpressionUUID->"2d2b53f2-4af3-43bc-a493-1650523a86ef"],
Cell[49774, 1086, 729, 19, 70, "MoreAboutSection",ExpressionUUID->"a28bd02a-9ed4-4085-ac3f-2521baab99a7"],
Cell[50506, 1107, 1607, 43, 70, "RelatedLinksSection",ExpressionUUID->"1c0c3139-605e-483e-8736-9f1ab9b220a1"],
Cell[52116, 1152, 78, 0, 70, "FooterCell",ExpressionUUID->"ae4a1dd6-59c5-4f4e-9879-6fb319a59560"]
}
]
*)

(* End of internal cache information *)

