(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 13.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     41697,       1009]
NotebookOptionsPosition[     36761,        906]
NotebookOutlinePosition[     38880,        960]
CellTagsIndexPosition[     38795,        955]
WindowTitle->pc
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[GridBox[{
   {GridBox[{
      {
       ItemBox[Cell[BoxData[
         RowBox[{
          TemplateBox[{12},
           "Spacer1"], Cell["NEW EO S ARGON PACKAGE SYMBOL", "PacletNameCell",
           TextAlignment->Center,ExpressionUUID->
           "171ca05b-d0c3-4479-bf32-4fd75cf32c77"], 
          TemplateBox[{8},
           "Spacer1"]}]],
         TextAlignment->Center,ExpressionUUID->
         "3635f6f8-4217-4387-a9e3-91f83df77318"],
        Background->RGBColor[0.490196, 0.576471, 0.690196],
        ItemSize->Full], ""}
     },
     GridBoxAlignment->{"Rows" -> {{Center}}},
     GridBoxItemSize->{"Columns" -> {Full, 
         Scaled[0.02]}, "Rows" -> {{2.5}}}], Cell[TextData[{
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "See Also",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "3bf97518-a9e4-4078-b59a-aa3d17778c0b"]
         }],ExpressionUUID->"b6702caf-02e7-46a1-9b78-765585cceaff"],
         StripOnInput->False],{
        "\"tc\"" :> Documentation`HelpLookup["paclet:NewEoSArgon/ref/tc"], 
         "\"rhoc\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/rhoc"], "\"vc\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/vc"], "\"zc\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/zc"]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"SeeAlso"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "2fec0cf9-193a-4361-93cb-6ef84c46cbb0"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "Related Guides",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "bea0701a-e7d9-4fef-a818-724fed26a013"]
         }],ExpressionUUID->"29a2a0b3-11a7-46b4-837d-d2f05122190e"],
         StripOnInput->False],{
        "\"NewEoSArgon Package\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/guide/NewEoSArgon"]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"MoreAbout"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "0addc717-0bc5-4011-83b1-77ec7a2d8df8"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "URL",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "8c7b31b3-d9ca-4a79-9685-1a83c1eb3c74"]
         }],ExpressionUUID->"ec79ab1e-ca05-493a-b357-054916c8fab1"],
         StripOnInput->False],{
        "\"NewEoSArgon/ref/pc\"" :> None, 
         "\"Copy Wolfram Documentation Center URL\"" :> 
         Module[{DocumentationSearch`Private`nb$}, 
           DocumentationSearch`Private`nb$ = 
            NotebookPut[
             Notebook[{Cell["NewEoSArgon/ref/pc"]}, Visible -> False]]; 
           SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
           FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
           NotebookClose[DocumentationSearch`Private`nb$]; Null], Delimiter, 
         "\"Copy web URL\"" :> 
         Module[{DocumentationSearch`Private`nb$}, 
           DocumentationSearch`Private`nb$ = 
            NotebookPut[
             Notebook[{
               Cell[BoxData[
                 MakeBoxes[
                  Hyperlink[
                   "http://reference.wolfram.com/language/NewEoSArgon/ref/pc.\
html"], StandardForm]], "Input", TextClipboardType -> "PlainText"]}, Visible -> 
               False]]; 
           SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
           FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
           NotebookClose[DocumentationSearch`Private`nb$]; Null], 
         "\"Go to web URL\"" :> 
         FrontEndExecute[{
           NotebookLocate[{
             URL[If[TrueQ[DocumentationBuild`Make`Private`wsmlinkQ$18031], 
                 "http://reference.wolfram.com/system-modeler/", 
                 "http://reference.wolfram.com/language/"] <> 
               "NewEoSArgon/ref/pc" <> ".html"], None}]}]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"URLMenu"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "a6273b83-39b1-4fda-ac11-a6b7d6f82637"]
    }], "AnchorBar",
     CacheGraphics->False,ExpressionUUID->
     "bfe8b98a-fb71-4f60-9fcf-1de642340b7c"]}
  }]], "AnchorBarGrid",
 CellID->1,ExpressionUUID->"21010359-bb18-48fd-91e7-1b6465e9b888"],

Cell["NewEoSArgon`", "ContextNameCell",ExpressionUUID->"ff436952-545c-4e15-a38c-fc896a4389ad"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     Cell[
     "pc", "ObjectName",ExpressionUUID->
      "f9dfd3fe-a6b7-4802-b1b3-11d1113062f6"],
     Cell[BoxData[
      TemplateBox[{8},
       "Spacer1"]],ExpressionUUID->"e4e5daea-1e8e-4d99-b4e0-4b273ed70331"],
     Cell[BoxData[
     ""], "ObjectNameTranslation",ExpressionUUID->
      "07497cfc-dc95-483c-a817-588dc954e93b"]
    }],ExpressionUUID->"62acd0bc-c747-491a-9dec-117415875376"], 
    "\[SpanFromLeft]"}
  }]], "ObjectNameGrid",ExpressionUUID->"c3f78003-1dcb-41ef-a933-\
31eabd8330f9"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["pc"], "InlineFormula",
      ShowStringCharacters->False,
      FontFamily->"Source Sans Pro",ExpressionUUID->
      "9f7b9eb6-52d6-4d1c-a818-341498b484a3"],
     " (bar) \nPression du point critique de l'argon donn\[EAcute]e par NIST \
\n[Critical pressure of Argon from NIST]"
    }],ExpressionUUID->"4df00e14-ffa4-47d3-bac9-609d58ca0e9f"]}
  }]], "Usage",
 Deletable->True,ExpressionUUID->"b3e5b9fb-609a-4792-888f-55a203360826"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {
       TaggingRules, "Openers", "PrimaryExamplesSection"}, Open], 
      Alternatives[True, Open]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{13.600000000000001`, {5., 8.600000000000001}}]],
  ExpressionUUID->"f489aee1-5fbf-457a-a4c2-91cd57161ec9"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"fd8f8d20-243c-4c0b-8baa-fa2eba099fb1"],
 "Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "96c7d30c-6ee5-4652-bb40-cf2d9c420574"]
}], "PrimaryExamplesSection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellTags->"PrimaryExamplesSection",
 CellID->9868075,ExpressionUUID->"b610b7eb-50fd-4854-be0b-8892ac4ef240"],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"},
        Closed], 
      Alternatives[Open, True]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{13.600000000000001`, {5., 8.600000000000001}}]],
  ExpressionUUID->"1a571ea7-d583-4901-8d70-928646c1bbb4"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"fb18ecd3-a314-4496-bad2-13dbbffa61a4"],
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "bd15b2e9-b302-43c4-a090-28eba9cad150"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellID->330167012,ExpressionUUID->"ef77cd61-b491-4d0b-815c-ea25f22dfc79"],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<NewEoSArgon`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->87419684,ExpressionUUID->"df9462c8-2f01-41e3-85a2-82bc92b1ee5d"],

Cell["Give a physical dimension to the constant", "ExampleText",
 CellID->886239600,ExpressionUUID->"8257ab80-d1d1-4e7f-bcdc-645e0a94ff2e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Quantity", "[", 
  RowBox[{"pc", ",", "\"\<Bars\>\""}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->21488140,ExpressionUUID->"340602fb-966c-44c5-8a95-f4d44fc65f08"],

Cell[BoxData[
 TemplateBox[{"48.63`", "\"bar\"", "bars", "\"Bars\""},
  "Quantity"]], "Output",
 CellLabel->"Out[2]=",
 CellID->436383695,ExpressionUUID->"22d94170-008f-4d6d-a2af-e55b560ccf34"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UnitConvert", "[", 
  RowBox[{
   RowBox[{"Quantity", "[", 
    RowBox[{"48.63`", ",", "\"\<Bars\>\""}], "]"}], ",", "\"\<MPa\>\""}], 
  "]"}]], "Input",
 NumberMarks->False,
 CellLabel->"In[3]:=",
 CellID->987884442,ExpressionUUID->"3850171d-6ba3-4988-b28d-983342983be5"],

Cell[BoxData[
 TemplateBox[{"4.863`", "\"MPa\"", "megapascals", "\"Megapascals\""},
  "Quantity"]], "Output",
 CellLabel->"Out[3]=",
 CellID->453132190,ExpressionUUID->"78b71245-0292-4b42-a7eb-91649f25aa97"]
}, Open  ]],

Cell["Using WolframAlpha", "ExampleText",
 CellID->351008126,ExpressionUUID->"4c1420b0-7864-4ef4-8301-65c6812b940d"],

Cell[CellGroupData[{

Cell[BoxData[
 NamespaceBox["WolframAlphaQueryResults",
  DynamicModuleBox[{Typeset`q$$ = "critical pressure of argon", 
   Typeset`opts$$ = {
   AppearanceElements -> {
     "Extrusion", "Warnings", "Assumptions", "Pods", "Unsuccessful"}, 
    Asynchronous -> All, 
    Method -> {
     "ExtrusionChosen" -> {
       "Fast parse", "Fast parse", 1, 0, "Input", 
        "ElementData[\"Argon\", \"CriticalPressure\"]"}, "ExtrusionOpen" -> 
      True, "Formats" -> {
       "cell", "minput", "moutput", "msound", "dataformats"}}}, 
   Typeset`elements$$ = {
   "Extrusion", "Warnings", "Assumptions", "Pods", "Unsuccessful"}, 
   Typeset`pod1$$ = XMLElement[
   "pod", {"title" -> "Input interpretation", "scanner" -> "Identity", "id" -> 
     "Input", "position" -> "100", "error" -> "false", "numsubpods" -> "1"}, {
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement[
       "minput", {}, {"ElementData[\"Argon\", \"CriticalPressure\"]"}], 
       XMLElement["cell", {"compressed" -> False, "string" -> True}, {
         Cell[
          BoxData[
           FormBox[
            TagBox[
             FormBox[
              TagBox[
               GridBox[{{
                  PaneBox[
                   StyleBox[
                    TagBox[
                    GridBox[{{
                    StyleBox[
                    TagBox[
                    TagBox["\"argon\"", 
                    $CellContext`TagBoxWrapper[
                    "Entity" -> {ElementData, "Argon"}]], Identity], {
                    LineIndent -> 0, LineSpacing -> {0.9, 0, 1.5}}], 
                    TagBox["\"critical pressure\"", 
                    $CellContext`TagBoxWrapper[
                    "Property" -> {ElementData, "CriticalPressure"}]]}}, 
                    GridBoxBackground -> {"Columns" -> {
                    GrayLevel[0.949], None}, "Rows" -> {{None}}}, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    ColumnsEqual -> False, RowsEqual -> False, 
                    GridBoxDividers -> {"Columns" -> {
                    GrayLevel[0.84], 
                    GrayLevel[0.84], 
                    GrayLevel[0.84]}, "Rows" -> {{
                    GrayLevel[0.84]}}, 
                    "RowsIndexed" -> {
                    1 -> GrayLevel[0.84], -1 -> GrayLevel[0.84]}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {1, 1, 1}, "Rows" -> {{0.3}}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Baseline}}}, 
                    AllowScriptLevelChange -> False, BaselinePosition -> 1], 
                    $CellContext`TagBoxWrapper["Separator" -> " | "]], 
                    LineSpacing -> {1, 0, 1.5}, LineIndent -> 0], 
                   BaselinePosition -> Center]}}, 
                GridBoxItemSize -> {
                 "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                ColumnsEqual -> False, RowsEqual -> False, 
                GridBoxSpacings -> {"Columns" -> {{
                    AbsoluteThickness[-1]}}, "Rows" -> {{0}}}, 
                AllowScriptLevelChange -> False], 
               $CellContext`TagBoxWrapper["Separator" -> " | "]], 
              TraditionalForm], 
             PolynomialForm[#, TraditionalOrder -> False]& ], 
            TraditionalForm]], "Output"]}], 
       XMLElement[
       "dataformats", {}, {
        "plaintext,minput,computabledata,formatteddata"}]}]}], 
   Typeset`pod2$$ = XMLElement[
   "pod", {"title" -> "Result", "scanner" -> "Data", "id" -> "Result", 
     "position" -> "200", "error" -> "false", "numsubpods" -> "1", "primary" -> 
     "true"}, {
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement["moutput", {}, {"Quantity[4.898, \"Megapascals\"]"}], 
       XMLElement["cell", {"compressed" -> False, "string" -> True}, {
         Cell[
          BoxData[
           FormBox[
            StyleBox[
             TagBox[
              RowBox[{
                TagBox[
                 TagBox[
                  RowBox[{
                    TagBox["4.898", 
                    $CellContext`TagBoxWrapper["StringBoxes" -> "4.898"]], 
                    "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    "\"MPa\"", FontFamily -> "Helvetica", FontSize -> 
                    Smaller]}], Identity], #& , SyntaxForm -> Dot], "  ", 
                StyleBox[
                 
                 RowBox[{
                  "\"(\"", "\[NoBreak]", "\"megapascals\"", "\[NoBreak]", 
                   "\")\""}], {
                 FontFamily :> $CellContext`$UnitFontFamily, FontSize -> 
                  Smaller, 
                  GrayLevel[0.6], LinebreakAdjustments -> {1, 100, 1, 0, 100},
                   LineIndent -> 0}, StripOnInput -> False]}], "Unit", 
              SyntaxForm -> Dot], LinebreakAdjustments -> {1, 100, 1, 0, 100},
              LineIndent -> 0, ZeroWidthTimes -> False], TraditionalForm]], 
          "Output"]}], 
       XMLElement[
       "dataformats", {}, {
        "plaintext,moutput,computabledata,formatteddata,numberdata,\
quantitydata"}]}]}], Typeset`pod3$$ = XMLElement[
   "pod", {"title" -> "Unit conversions", "scanner" -> "Unit", "id" -> 
     "UnitConversion", "position" -> "300", "error" -> "false", "numsubpods" -> 
     "5"}, {
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement["cell", {"compressed" -> False, "string" -> True}, {
         Cell[
          BoxData[
           FormBox[
            StyleBox[
             TagBox[
              RowBox[{
                TagBox[
                 TagBox[
                  RowBox[{
                    TagBox[
                    RowBox[{"4.898", 
                    StyleBox["\[Times]", 
                    GrayLevel[0.5]], 
                    SuperscriptBox["10", "6"]}], 
                    $CellContext`TagBoxWrapper[
                    "StringBoxes" -> RowBox[{"4.898", "\[Times]", 
                    SuperscriptBox["10", "6"]}]], SyntaxForm -> CenterDot], 
                    "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    "\"Pa\"", FontFamily -> "Helvetica", FontSize -> 
                    Smaller]}], Identity], #& , SyntaxForm -> Dot], "  ", 
                StyleBox[
                 
                 RowBox[{
                  "\"(\"", "\[NoBreak]", "\"pascals\"", "\[NoBreak]", 
                   "\")\""}], {
                 FontFamily :> $CellContext`$UnitFontFamily, FontSize -> 
                  Smaller, 
                  GrayLevel[0.6], LinebreakAdjustments -> {1, 100, 1, 0, 100},
                   LineIndent -> 0}, StripOnInput -> False]}], "Unit", 
              SyntaxForm -> Dot], LinebreakAdjustments -> {1, 100, 1, 0, 100},
              LineIndent -> 0, ZeroWidthTimes -> False], TraditionalForm]], 
          "Output"]}], 
       XMLElement[
       "dataformats", {}, {
        "plaintext,computabledata,formatteddata,numberdata,quantitydata"}]}], 
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement["cell", {"compressed" -> False, "string" -> True}, {
         Cell[
          BoxData[
           FormBox[
            StyleBox[
             TagBox[
              RowBox[{
                TagBox[
                 TagBox[
                  RowBox[{
                    TagBox[
                    RowBox[{"4.898", 
                    StyleBox["\[Times]", 
                    GrayLevel[0.5]], 
                    SuperscriptBox["10", "6"]}], 
                    $CellContext`TagBoxWrapper[
                    "StringBoxes" -> RowBox[{"4.898", "\[Times]", 
                    SuperscriptBox["10", "6"]}]], SyntaxForm -> CenterDot], 
                    "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    
                    RowBox[{
                    "\"N\"", "\[InvisibleSpace]", "\"/\"", 
                    "\[InvisibleSpace]", 
                    SuperscriptBox["\"m\"", "2"]}], FontFamily -> "Helvetica",
                     FontSize -> Smaller]}], Identity], #& , SyntaxForm -> 
                 Dot], "  ", 
                StyleBox[
                 
                 RowBox[{
                  "\"(\"", "\[NoBreak]", "\"newtons per square meter\"", 
                   "\[NoBreak]", "\")\""}], {
                 FontFamily :> $CellContext`$UnitFontFamily, FontSize -> 
                  Smaller, 
                  GrayLevel[0.6], LinebreakAdjustments -> {1, 100, 1, 0, 100},
                   LineIndent -> 0}, StripOnInput -> False]}], "Unit", 
              SyntaxForm -> Dot], LinebreakAdjustments -> {1, 100, 1, 0, 100},
              LineIndent -> 0, ZeroWidthTimes -> False], TraditionalForm]], 
          "Output"]}], 
       XMLElement[
       "dataformats", {}, {
        "plaintext,computabledata,formatteddata,numberdata,quantitydata"}]}], 
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement["cell", {"compressed" -> False, "string" -> True}, {
         Cell[
          BoxData[
           FormBox[
            StyleBox[
             TagBox[
              RowBox[{
                TagBox[
                 TagBox[
                  RowBox[{
                    TagBox["499.5", 
                    $CellContext`TagBoxWrapper["StringBoxes" -> "499.5"]], 
                    "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    
                    RowBox[{
                    "\"tf\"", "\[InvisibleSpace]", "\"/\"", 
                    "\[InvisibleSpace]", 
                    SuperscriptBox["\"m\"", "2"]}], FontFamily -> "Helvetica",
                     FontSize -> Smaller]}], Identity], #& , SyntaxForm -> 
                 Dot], "  ", 
                StyleBox[
                 
                 RowBox[{
                  "\"(\"", "\[NoBreak]", 
                   "\"metric tons\[Hyphen]force per square meter\"", 
                   "\[NoBreak]", "\")\""}], {
                 FontFamily :> $CellContext`$UnitFontFamily, FontSize -> 
                  Smaller, 
                  GrayLevel[0.6], LinebreakAdjustments -> {1, 100, 1, 0, 100},
                   LineIndent -> 0}, StripOnInput -> False]}], "Unit", 
              SyntaxForm -> Dot], LinebreakAdjustments -> {1, 100, 1, 0, 100},
              LineIndent -> 0, ZeroWidthTimes -> False], TraditionalForm]], 
          "Output"]}], 
       XMLElement[
       "dataformats", {}, {
        "plaintext,computabledata,formatteddata,numberdata,quantitydata"}]}], 
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement["cell", {"compressed" -> False, "string" -> True}, {
         Cell[
          BoxData[
           FormBox[
            TagBox[
             GridBox[{{
                StyleBox[
                 TagBox[
                  RowBox[{
                    TagBox[
                    TagBox[
                    RowBox[{
                    TagBox["48.34", 
                    $CellContext`TagBoxWrapper["StringBoxes" -> "48.34"]], 
                    "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    "\"atm\"", FontFamily -> "Helvetica", FontSize -> 
                    Smaller]}], Identity], #& , SyntaxForm -> Dot], "  ", 
                    StyleBox[
                    
                    RowBox[{
                    "\"(\"", "\[NoBreak]", "\"atmospheres\"", "\[NoBreak]", 
                    "\")\""}], {
                    FontFamily :> $CellContext`$UnitFontFamily, FontSize -> 
                    Smaller, 
                    GrayLevel[0.6], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0}, StripOnInput -> False]}], "Unit", SyntaxForm -> Dot], 
                 LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 0,
                  ZeroWidthTimes -> False]}, {
                TemplateBox[{"\" \"", 
                  StyleBox[
                   
                   RowBox[{
                    "\"(\"", "\[NoBreak]", "\"unit officially deprecated\"", 
                    "\[NoBreak]", "\")\""}], {
                   FontFamily -> "Verdana", FontSize -> 10, 
                    GrayLevel[0.5], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0}, StripOnInput -> False]}, "RowDefault"]}}, 
              GridBoxAlignment -> {"Columns" -> {{Left}}}, 
              AllowScriptLevelChange -> False, DefaultBaseStyle -> "Column", 
              GridBoxItemSize -> {
               "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
              GridBoxSpacings -> {
               "Columns" -> {{Automatic}}, "Rows" -> {{0}}}], "Column"], 
            TraditionalForm]], "Output"]}], 
       XMLElement[
       "dataformats", {}, {
        "plaintext,computabledata,formatteddata,numberdata,quantitydata"}]}], 
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement["cell", {"compressed" -> False, "string" -> True}, {
         Cell[
          BoxData[
           FormBox[
            TagBox[
             GridBox[{{
                StyleBox[
                 TagBox[
                  TagBox[
                   TagBox[
                    RowBox[{
                    TagBox["48.98", 
                    $CellContext`TagBoxWrapper["StringBoxes" -> "48.98"]], 
                    "\[InvisibleSpace]", " ", 
                    StyleBox[
                    "\"bars\"", LinebreakAdjustments -> {1, 100, 1, 0, 100}, 
                    LineIndent -> 0, {
                    FontFamily :> $CellContext`$UnitFontFamily, FontSize -> 
                    Smaller}, StripOnInput -> False]}], Identity], #& , 
                   SyntaxForm -> Dot], "Unit", SyntaxForm -> Dot], 
                 LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 0,
                  ZeroWidthTimes -> False]}, {
                TemplateBox[{"\" \"", 
                  StyleBox[
                   
                   RowBox[{
                    "\"(\"", "\[NoBreak]", "\"unit officially deprecated\"", 
                    "\[NoBreak]", "\")\""}], {
                   FontFamily -> "Verdana", FontSize -> 10, 
                    GrayLevel[0.5], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0}, StripOnInput -> False]}, "RowDefault"]}}, 
              GridBoxAlignment -> {"Columns" -> {{Left}}}, 
              AllowScriptLevelChange -> False, DefaultBaseStyle -> "Column", 
              GridBoxItemSize -> {
               "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
              GridBoxSpacings -> {
               "Columns" -> {{Automatic}}, "Rows" -> {{0}}}], "Column"], 
            TraditionalForm]], "Output"]}], 
       XMLElement[
       "dataformats", {}, {
        "plaintext,computabledata,formatteddata,numberdata,quantitydata"}]}], 
     XMLElement["states", {"count" -> "1"}, {
       XMLElement[
       "state", {
        "name" -> "More", "input" -> "UnitConversion__More"}, {}]}]}], 
   Typeset`aux1$$ = {True, False, {False}, True}, Typeset`aux2$$ = {
   True, False, {False}, True}, Typeset`aux3$$ = {
   True, False, {False, False, False, False, False}, True}, 
   Typeset`asyncpods$$ = {}, Typeset`nonpods$$ = {
    XMLElement["sources", {"count" -> "1"}, {
      XMLElement[
      "source", {
       "url" -> 
        "http://www.wolframalpha.com/sources/\
ElementDataSourceInformationNotes.html", "text" -> "Element data"}, {}]}]}, 
   Typeset`initdone$$ = True, Typeset`queryinfo$$ = {
   "success" -> "true", "error" -> "false", "numpods" -> "3", "datatypes" -> 
    "Element", "timedout" -> "", "timedoutpods" -> "", "timing" -> "0.977", 
    "parsetiming" -> "0.313", "parsetimedout" -> "false", "recalculate" -> "",
     "id" -> "MSPa33661h19g90ici15c6ig000048ae5i79d5481d6d", "host" -> 
    "http://www4c.wolframalpha.com", "server" -> "50", "related" -> 
    "http://www4c.wolframalpha.com/api/v2/relatedQueries.jsp?id=\
MSPa33671h19g90ici15c6ig00005g0ea4ff7gd8g86i&s=50", "version" -> "2.6"}, 
   Typeset`sessioninfo$$ = {
   "TimeZone" -> 1., 
    "Date" -> {2014, 2, 6, 16, 37, 43.4755589`9.390820045659057}, "Line" -> 
    17, "SessionID" -> 23597498814303192354}, Typeset`showpods$$ = {1, 2, 3}, 
   Typeset`failedpods$$ = {}, Typeset`chosen$$ = {
   "Fast parse", "Fast parse", 1, 0, "Input", 
    "ElementData[\"Argon\", \"CriticalPressure\"]"}, Typeset`open$$ = True, 
   Typeset`newq$$ = "critical pressure of argon"}, 
   DynamicBox[ToBoxes[
     AlphaIntegration`FormatAlphaResults[
      Dynamic[{
       1, {Typeset`pod1$$, Typeset`pod2$$, Typeset`pod3$$}, {
        Typeset`aux1$$, Typeset`aux2$$, Typeset`aux3$$}, Typeset`chosen$$, 
        Typeset`open$$, Typeset`elements$$, Typeset`q$$, Typeset`opts$$, 
        Typeset`nonpods$$, Typeset`queryinfo$$, Typeset`sessioninfo$$, 
        Typeset`showpods$$, Typeset`failedpods$$, Typeset`newq$$}]], 
     StandardForm],
    ImageSizeCache->{560., {465., 19.}},
    TrackedSymbols:>{Typeset`showpods$$, Typeset`failedpods$$}],
   DynamicModuleValues:>{},
   Initialization:>If[
     Not[Typeset`initdone$$], Null; WolframAlphaClient`Private`doAsyncUpdates[
       Hold[{Typeset`pod1$$, Typeset`pod2$$, Typeset`pod3$$}], 
       Typeset`asyncpods$$, 
       Dynamic[Typeset`failedpods$$]]; Typeset`asyncpods$$ = {}; 
     Typeset`initdone$$ = True],
   SynchronousInitialization->False],
  BaseStyle->{Deployed -> True},
  DeleteWithContents->True,
  Editable->False,
  SelectWithContents->True]], "WolframAlphaShortInput",
 CellLabel->"In[13]:=",
 CellID->566659464,ExpressionUUID->"f8dca93d-72f0-4cc3-904d-ccce8dd41fab"],

Cell[BoxData[
 TemplateBox[{"4.898`4.", "\"MPa\"", "megapascals", "\"Megapascals\""},
  "Quantity"]], "Output",
 CellLabel->"Out[13]=",
 CellID->854119107,ExpressionUUID->"7b5a64da-a611-4865-b50b-4002ed292308"]
}, Open  ]],

Cell["Using ThermodynamicData package (i.e. REFPROP from NIST)", "ExampleText",
 CellID->361149294,ExpressionUUID->"db31810a-4a17-4453-a244-a1a596ef049f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UnitConvert", "[", 
  RowBox[{
   RowBox[{"ThermodynamicData", "[", 
    RowBox[{"\"\<Argon\>\"", ",", "\"\<CriticalPressure\>\""}], "]"}], ",", 
   "\"\<Bars\>\""}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->305288497,ExpressionUUID->"e3895813-82b7-4f8c-8194-8034f8ef64ad"],

Cell[BoxData[
 TemplateBox[{"48.63`", "\"bar\"", "bars", "\"Bars\""},
  "Quantity"]], "Output",
 CellLabel->"Out[4]=",
 CellID->640604060,ExpressionUUID->"6780ef34-1dd7-46e1-91ca-76658df9a7b7"]
}, Open  ]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"}, 
  Closed]]]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "PrimaryExamplesSection"}, 
  Closed]]]],

Cell[BoxData[GridBox[{
   {
    DynamicBox[FEPrivate`ImportImage[
      FrontEnd`FileName[{"Documentation", "FooterIcons"}, 
       "RelatedFunction.png"]],
     ImageSizeCache->{50., {27., 33.}}], GridBox[{
      {
       StyleBox[
        RowBox[{"See", " ", "Also"}], "SeeAlsoSection"]},
      {Cell[TextData[{
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["tc"]], "paclet:NewEoSArgon/ref/tc", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "e32cdfe2-d57a-45c9-a83a-bc5da30b8960"],
        "\[NonBreakingSpace]",
        StyleBox[
        "\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
         "InlineSeparator"],
        " ",
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["rhoc"]], "paclet:NewEoSArgon/ref/rhoc", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "fbd1a809-99f7-4139-ae11-8b8d97382c14"],
        "\[NonBreakingSpace]",
        StyleBox[
        "\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
         "InlineSeparator"],
        " ",
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["vc"]], "paclet:NewEoSArgon/ref/vc", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "a790bea8-ed49-4616-a270-b8e2c77b0ffb"],
        "\[NonBreakingSpace]",
        StyleBox[
        "\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
         "InlineSeparator"],
        " ",
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["zc"]], "paclet:NewEoSArgon/ref/zc", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "b69dc448-a3c3-46e4-9416-63e88dcd80b6"]
       }], "SeeAlso",ExpressionUUID->"5312d40a-9360-461b-a53f-ac97e1967777"]}
     }]}
  }]], "SeeAlsoSection",ExpressionUUID->"52de7cb8-4bd4-4f1a-b084-\
943020eb8a3e"],

Cell[BoxData[GridBox[{
   {
    DynamicBox[FEPrivate`ImportImage[
      FrontEnd`FileName[{"Documentation", "FooterIcons"}, "RelatedGuide.png"]],
     ImageSizeCache->{50., {27., 33.}}], GridBox[{
      {
       StyleBox[
        RowBox[{"Related", " ", "Guides"}], "MoreAboutSection"]},
      {
       RowBox[{"\[FilledVerySmallSquare]", Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["NewEoSArgon Package"]], 
           "paclet:NewEoSArgon/guide/NewEoSArgon"},
          "RefLinkPlain",
          BaseStyle->{"MoreAbout"}]], "MoreAbout",ExpressionUUID->
         "4d63e15a-7454-40d9-bd9d-e35aa6336a2e"]}]}
     }]}
  }]], "MoreAboutSection",ExpressionUUID->"54ba8bf6-5482-4a73-b55c-\
f7d74ee60bb8"],

Cell[BoxData[GridBox[{
   {
    TemplateBox[{29},
     "Spacer1"], GridBox[{
      {
       RowBox[{
        TemplateBox[{17},
         "Spacer1"], 
        StyleBox[
         RowBox[{"Related", " ", "Links"}], "RelatedLinksSection"]}]},
      {Cell[BoxData[Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData[
             RowBox[{
               RowBox[{"Units", " ", "&"}], " ", "Quantities"}]]], 
           "paclet:guide/Units"},
          "RefLinkPlain",
          BaseStyle->{"RelatedLinks"}]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "5e4a2621-10fb-403b-aade-b490fb4370a1"]], "RelatedLinks",
        ExpressionUUID->"fd6bad11-e255-4821-a284-395475ba826d"]},
      {Cell[BoxData[Cell[BoxData[Cell[BoxData[
          RowBox[{
           TemplateBox[{16},
            "Spacer1"], "\[FilledVerySmallSquare]", 
           TemplateBox[{
             Cell[
              TextData[
               Cell[
                TextData[{
                  Cell[
                   BoxData[
                    TemplateBox[{2}, "Spacer1"]]], "ThermodynamicData"}]]]], 
             "paclet:ref/ThermodynamicData"},
            "RefLink",
            BaseStyle->{"RelatedLinks"}]}]],ExpressionUUID->
          "ce8e3137-0519-4c7c-9691-74a7c28a9ebd"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "85d5e3d9-256d-47e2-8884-eb6d660298fb"]], "RelatedLinks",
        ExpressionUUID->"c501ae27-48fc-452e-a1bf-0443aecf9a8f"]},
      {Cell[TextData[Cell[BoxData[
        RowBox[{
         TemplateBox[{16},
          "Spacer1"], "\[FilledVerySmallSquare]", Cell[BoxData[
          TemplateBox[{
            Cell[
             TextData[
              Cell[
               TextData[{
                 Cell[
                  BoxData[
                   TemplateBox[{2}, "Spacer1"]]], 
                 "Webbook de chimie NIST"}]]]], 
            "http://webbook.nist.gov/chemistry/fluid/"},
           "WebLink",
           BaseStyle->{"RelatedLinks"}]],ExpressionUUID->
          "e18d6d6e-dafa-44ee-88b5-6530d8f20625"]}]],ExpressionUUID->
        "fa769122-2ac0-4b8e-bece-5561390d7364"]], "RelatedLinks",
        ExpressionUUID->"e220f7c4-5d4c-4d60-839c-5855a0f0c969"]}
     }]}
  }]], "RelatedLinksSection",ExpressionUUID->"22cc37bd-b165-4908-8b72-\
c2dddcfad482"],

Cell[" ", "FooterCell",ExpressionUUID->"8cb94e34-07ef-4314-8a43-897d64c84877"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{900, 835.8},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"pc",
TaggingRules->{
 "ModificationHighlight" -> False, "ColorType" -> "", "LinkTrails" -> "", 
  "HasOptions" -> True, "ExampleCounter" -> 1, 
  "Openers" -> {
   "PrimaryExamplesSection" -> Open, "ExampleSection" -> {"0" -> Open}}, 
  "NewStyles" -> True, "CitationPopupData" -> $Failed, "ShowCitation" -> 
  False, "RootCaptions" -> "", 
  "Metadata" -> {
   "built" -> "{2023, 11, 30, 13, 55, 44.8712244}", 
    "history" -> {"XX", "", "", ""}, "context" -> "NewEoSArgon`", 
    "keywords" -> {}, "specialkeywords" -> {}, 
    "tutorialcollectionlinks" -> {}, "index" -> True, "label" -> 
    "New Eo S Argon Package Symbol", "language" -> "en", "paclet" -> 
    "NewEoSArgon Package", "status" -> "None", "summary" -> 
    "pc (bar) Pression du point critique de l'argon donn\[EAcute]e par NIST \
[Critical pressure of Argon from NIST]", "synonyms" -> {}, "tabletags" -> {}, 
    "title" -> "pc", "titlemodifier" -> "", "metadescription" -> "", 
    "windowtitle" -> "pc", "type" -> "Symbol", "uri" -> "NewEoSArgon/ref/pc"}},
CellContext->"Global`",
FrontEndVersion->"13.3 pour Microsoft Windows (64-bit) (July 24, 2023)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "13.3 pour Microsoft Windows (64-bit) (July 24, 2023)", 
  StyleDefinitions -> "Default.nb"],
ExpressionUUID->"ede699d3-d062-444d-9d75-4ef62a380028"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7164, 188, 1418, 37, 35, "PrimaryExamplesSection",ExpressionUUID->"b610b7eb-50fd-4854-be0b-8892ac4ef240",
   CellTags->"PrimaryExamplesSection",
   CellID->9868075]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 38598, 948}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[574, 21, 5386, 130, 56, "AnchorBarGrid",ExpressionUUID->"21010359-bb18-48fd-91e7-1b6465e9b888",
 CellID->1],
Cell[5963, 153, 94, 0, 23, "ContextNameCell",ExpressionUUID->"ff436952-545c-4e15-a38c-fc896a4389ad"],
Cell[CellGroupData[{
Cell[6082, 157, 545, 14, 56, "ObjectNameGrid",ExpressionUUID->"c3f78003-1dcb-41ef-a933-31eabd8330f9"],
Cell[6630, 173, 497, 10, 146, "Usage",ExpressionUUID->"b3e5b9fb-609a-4792-888f-55a203360826"]
}, Open  ]],
Cell[CellGroupData[{
Cell[7164, 188, 1418, 37, 35, "PrimaryExamplesSection",ExpressionUUID->"b610b7eb-50fd-4854-be0b-8892ac4ef240",
 CellTags->"PrimaryExamplesSection",
 CellID->9868075],
Cell[CellGroupData[{
Cell[8607, 229, 1398, 36, 30, "ExampleSection",ExpressionUUID->"ef77cd61-b491-4d0b-815c-ea25f22dfc79",
 CellID->330167012],
Cell[10008, 267, 174, 3, 26, "Input",ExpressionUUID->"df9462c8-2f01-41e3-85a2-82bc92b1ee5d",
 CellID->87419684],
Cell[10185, 272, 139, 1, 38, "ExampleText",ExpressionUUID->"8257ab80-d1d1-4e7f-bcdc-645e0a94ff2e",
 CellID->886239600],
Cell[CellGroupData[{
Cell[10349, 277, 193, 4, 26, "Input",ExpressionUUID->"340602fb-966c-44c5-8a95-f4d44fc65f08",
 CellID->21488140],
Cell[10545, 283, 193, 4, 40, "Output",ExpressionUUID->"22d94170-008f-4d6d-a2af-e55b560ccf34",
 CellID->436383695]
}, Open  ]],
Cell[CellGroupData[{
Cell[10775, 292, 296, 8, 26, "Input",ExpressionUUID->"3850171d-6ba3-4988-b28d-983342983be5",
 CellID->987884442],
Cell[11074, 302, 207, 4, 39, "Output",ExpressionUUID->"78b71245-0292-4b42-a7eb-91649f25aa97",
 CellID->453132190]
}, Open  ]],
Cell[11296, 309, 116, 1, 38, "ExampleText",ExpressionUUID->"4c1420b0-7864-4ef4-8301-65c6812b940d",
 CellID->351008126],
Cell[CellGroupData[{
Cell[11437, 314, 18647, 403, 501, "WolframAlphaShortInput",ExpressionUUID->"f8dca93d-72f0-4cc3-904d-ccce8dd41fab",
 CellID->566659464],
Cell[30087, 719, 210, 4, 39, "Output",ExpressionUUID->"7b5a64da-a611-4865-b50b-4002ed292308",
 CellID->854119107]
}, Open  ]],
Cell[30312, 726, 154, 1, 70, "ExampleText",ExpressionUUID->"db31810a-4a17-4453-a244-a1a596ef049f",
 CellID->361149294],
Cell[CellGroupData[{
Cell[30491, 731, 305, 7, 70, "Input",ExpressionUUID->"e3895813-82b7-4f8c-8194-8034f8ef64ad",
 CellID->305288497],
Cell[30799, 740, 193, 4, 40, "Output",ExpressionUUID->"6780ef34-1dd7-46e1-91ca-76658df9a7b7",
 CellID->640604060]
}, Open  ]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"}, Closed]]]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "PrimaryExamplesSection"}, Closed]]]],
Cell[31234, 753, 2357, 64, 70, "SeeAlsoSection",ExpressionUUID->"52de7cb8-4bd4-4f1a-b084-943020eb8a3e"],
Cell[33594, 819, 729, 19, 70, "MoreAboutSection",ExpressionUUID->"54ba8bf6-5482-4a73-b55c-f7d74ee60bb8"],
Cell[34326, 840, 2350, 62, 70, "RelatedLinksSection",ExpressionUUID->"22cc37bd-b165-4908-8b72-c2dddcfad482"],
Cell[36679, 904, 78, 0, 70, "FooterCell",ExpressionUUID->"8cb94e34-07ef-4314-8a43-897d64c84877"]
}
]
*)

(* End of internal cache information *)

