(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 13.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     20330,        537]
NotebookOptionsPosition[     15754,        441]
NotebookOutlinePosition[     17920,        496]
CellTagsIndexPosition[     17835,        491]
WindowTitle->pcNv
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[GridBox[{
   {GridBox[{
      {
       ItemBox[Cell[BoxData[
         RowBox[{
          TemplateBox[{12},
           "Spacer1"], Cell["NEW EO S ARGON PACKAGE SYMBOL", "PacletNameCell",
           TextAlignment->Center,ExpressionUUID->
           "25437a16-de3d-4646-aea1-9ef82228937e"], 
          TemplateBox[{8},
           "Spacer1"]}]],
         TextAlignment->Center,ExpressionUUID->
         "dc5e3e38-955b-42f6-bffb-aaebbf6f3c2c"],
        Background->RGBColor[0.490196, 0.576471, 0.690196],
        ItemSize->Full], ""}
     },
     GridBoxAlignment->{"Rows" -> {{Center}}},
     GridBoxItemSize->{"Columns" -> {Full, 
         Scaled[0.02]}, "Rows" -> {{2.5}}}], Cell[TextData[{
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "See Also",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "7f5bf8c4-ef62-4d51-b553-b729c4ba0dcf"]
         }],ExpressionUUID->"c157e6b2-7d05-45b7-8288-58413b17bba5"],
         StripOnInput->False],{
        "\"pc\"" :> Documentation`HelpLookup["paclet:NewEoSArgon/ref/pc"], 
         "\"tcNv\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/tcNv"], 
         "\"rhocNv\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/rhocNv"]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"SeeAlso"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "71c4302a-430e-450a-8cc2-82578fba74f8"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "Related Guides",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "e57493c0-6ecb-49e1-876b-360b3e96d8c4"]
         }],ExpressionUUID->"445191c6-6846-43d6-bc18-65c8a6b0d0ed"],
         StripOnInput->False],{
        "\"NewEoSArgon Package\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/guide/NewEoSArgon"]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"MoreAbout"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "858589a6-62bc-4aa3-a095-329d5cc645b9"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "URL",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "da332374-a23c-4275-979b-4be2d41fd11f"]
         }],ExpressionUUID->"e9b9e911-8d5a-4174-9e38-3d30678a2163"],
         StripOnInput->False],{
        "\"NewEoSArgon/ref/pcNv\"" :> None, 
         "\"Copy Wolfram Documentation Center URL\"" :> 
         Module[{DocumentationSearch`Private`nb$}, 
           DocumentationSearch`Private`nb$ = 
            NotebookPut[
             Notebook[{Cell["NewEoSArgon/ref/pcNv"]}, Visible -> False]]; 
           SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
           FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
           NotebookClose[DocumentationSearch`Private`nb$]; Null], Delimiter, 
         "\"Copy web URL\"" :> 
         Module[{DocumentationSearch`Private`nb$}, 
           DocumentationSearch`Private`nb$ = 
            NotebookPut[
             Notebook[{
               Cell[BoxData[
                 MakeBoxes[
                  Hyperlink[
                   "http://reference.wolfram.com/language/NewEoSArgon/ref/\
pcNv.html"], StandardForm]], "Input", TextClipboardType -> "PlainText"]}, 
               Visible -> False]]; 
           SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
           FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
           NotebookClose[DocumentationSearch`Private`nb$]; Null], 
         "\"Go to web URL\"" :> 
         FrontEndExecute[{
           NotebookLocate[{
             URL[If[TrueQ[DocumentationBuild`Make`Private`wsmlinkQ$18535], 
                 "http://reference.wolfram.com/system-modeler/", 
                 "http://reference.wolfram.com/language/"] <> 
               "NewEoSArgon/ref/pcNv" <> ".html"], None}]}]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"URLMenu"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "af8c2e12-03f8-4240-b716-dae9afb80824"]
    }], "AnchorBar",
     CacheGraphics->False,ExpressionUUID->
     "e13d1af5-ffe4-4d22-af5d-af08112791da"]}
  }]], "AnchorBarGrid",
 CellID->1,ExpressionUUID->"390fba28-81c7-4f4d-a832-360d20b939cd"],

Cell["NewEoSArgon`", "ContextNameCell",ExpressionUUID->"fd1801d8-9fc1-423e-8f92-463af76d5e79"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     Cell[
     "pcNv", "ObjectName",ExpressionUUID->
      "e90f783f-37a8-4cec-affb-d8af8579a32c"],
     Cell[BoxData[
      TemplateBox[{8},
       "Spacer1"]],ExpressionUUID->"77a39355-ecc1-4546-a474-ecec5a79f55f"],
     Cell[BoxData[
     ""], "ObjectNameTranslation",ExpressionUUID->
      "3ce9c9b2-d5a1-4b71-b638-b9168bb8ee99"]
    }],ExpressionUUID->"63683c5f-3098-42a9-8800-1d3de78b4f1f"], 
    "\[SpanFromLeft]"}
  }]], "ObjectNameGrid",ExpressionUUID->"540a4e24-46e3-46b3-91e7-\
170d2d5cb2ec"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["pcNv"], "InlineFormula",
      ShowStringCharacters->False,
      FontFamily->"Source Sans Pro",ExpressionUUID->
      "f730205a-0d95-43c1-9267-669db49eff02"],
     " (bar)\nPression du point critique de l'argon d\[EAcute]duite des \
relations de Maxwell \n[Critical pressure of argon from Maxwell relations]"
    }],ExpressionUUID->"f9a70ec4-59f2-48ab-8784-1e5420135cd5"]}
  }]], "Usage",
 Deletable->True,ExpressionUUID->"db73585c-7a76-4b85-8a87-70aff4109983"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {
       TaggingRules, "Openers", "PrimaryExamplesSection"}, Open], 
      Alternatives[True, Open]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{13.600000000000001`, {5., 8.600000000000001}}]],
  ExpressionUUID->"1738388e-0a17-48c5-b1b4-632784d5edb4"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"9674a4ca-3289-4287-bdf9-2e394afb770c"],
 "Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "3b97dcd2-525f-46da-a559-72a8ada05637"]
}], "PrimaryExamplesSection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellTags->"PrimaryExamplesSection",
 CellID->206826702,ExpressionUUID->"33506a4d-5912-4270-b732-d1c5eec4f407"],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"},
        Closed], 
      Alternatives[Open, True]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{13.600000000000001`, {5., 8.600000000000001}}]],
  ExpressionUUID->"f5a39088-d119-43ae-9064-dfff55f94279"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"31b87ac4-a286-48d7-9227-b28d815fc27e"],
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "f8b97df3-835c-4e93-a6c1-663f8f25022a"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellID->926065,ExpressionUUID->"14b92b98-b09a-4dd8-9dcc-0cadc36e957d"],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<NewEoSArgon`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->87419684,ExpressionUUID->"e2e53856-5b58-46ba-b95f-c8c2fd60e7f4"],

Cell["Give a physical dimension to the constant", "ExampleText",
 CellID->886239600,ExpressionUUID->"a2cef37a-5da1-40e6-a661-a6f3024b9ac1"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Quantity", "[", 
  RowBox[{"pcNv", ",", "\"\<Bars\>\""}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->21488140,ExpressionUUID->"aa4bbe1f-c383-4638-922c-3bc5881cbed9"],

Cell[BoxData[
 TemplateBox[{"49.96838429197424`", "\"bar\"", "bars", "\"Bars\""},
  "Quantity"]], "Output",
 CellLabel->"Out[2]=",
 CellID->330992777,ExpressionUUID->"9dd8b63c-8b9d-4cf9-b7e1-443ae08de4d1"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UnitConvert", "[", 
  RowBox[{
   RowBox[{"Quantity", "[", 
    RowBox[{"49.96838429197424`", ",", "\"\<Bars\>\""}], "]"}], ",", 
   "\"\<MPa\>\""}], "]"}]], "Input",
 NumberMarks->False,
 CellLabel->"In[3]:=",
 CellID->365175868,ExpressionUUID->"6a20311c-2e98-40f2-848e-045697a31143"],

Cell[BoxData[
 TemplateBox[{
  "4.996838429197425`", "\"MPa\"", "megapascals", "\"Megapascals\""},
  "Quantity"]], "Output",
 CellLabel->"Out[3]=",
 CellID->148890417,ExpressionUUID->"d54c0b55-dbe3-44a4-a9cf-3596a1514b7c"]
}, Open  ]],

Cell["Relative error with NIST constant", "ExampleText",
 CellID->32289193,ExpressionUUID->"3a08ad60-3ea5-4f86-aebf-ad77b8ced68d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Quantity", "[", 
  RowBox[{
   RowBox[{"100", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"pc", "-", "pcNv"}], ")"}], "/", "pc"}]}], ",", "\"\<%\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->91147354,ExpressionUUID->"88d44a35-b5e2-4c20-a115-96782132bc41"],

Cell[BoxData[
 TemplateBox[{
   RowBox[{"-", "2.752178268505524`"}], "\"%\"", "percent", "\"Percent\""},
  "QuantityPostfix"]], "Output",
 CellLabel->"Out[4]=",
 CellID->16981765,ExpressionUUID->"5e50d198-63a0-4d29-927e-35e3e63155c5"]
}, Open  ]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"}, 
  Closed]]]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "PrimaryExamplesSection"}, 
  Closed]]]],

Cell[BoxData[GridBox[{
   {
    DynamicBox[FEPrivate`ImportImage[
      FrontEnd`FileName[{"Documentation", "FooterIcons"}, 
       "RelatedFunction.png"]],
     ImageSizeCache->{50., {27., 33.}}], GridBox[{
      {
       StyleBox[
        RowBox[{"See", " ", "Also"}], "SeeAlsoSection"]},
      {Cell[TextData[{
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["pc"]], "paclet:NewEoSArgon/ref/pc", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "9fb924e6-fc56-4441-8d43-09a170af1da9"],
        "\[NonBreakingSpace]",
        StyleBox[
        "\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
         "InlineSeparator"],
        " ",
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["tcNv"]], "paclet:NewEoSArgon/ref/tcNv", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "bc269300-1223-47cc-a9ba-e1900e7ff966"],
        "\[NonBreakingSpace]",
        StyleBox[
        "\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
         "InlineSeparator"],
        " ",
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["rhocNv"]], "paclet:NewEoSArgon/ref/rhocNv", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "eb6b2f52-06e3-4618-83b0-f2259500f7ad"]
       }], "SeeAlso",ExpressionUUID->"5ddbebbf-1b7d-4815-95a8-4fdaf3ac90f0"]}
     }]}
  }]], "SeeAlsoSection",ExpressionUUID->"0a497a32-905f-4a41-8f8c-\
d1bc40a71567"],

Cell[BoxData[GridBox[{
   {
    DynamicBox[FEPrivate`ImportImage[
      FrontEnd`FileName[{"Documentation", "FooterIcons"}, "RelatedGuide.png"]],
     ImageSizeCache->{50., {27., 33.}}], GridBox[{
      {
       StyleBox[
        RowBox[{"Related", " ", "Guides"}], "MoreAboutSection"]},
      {
       RowBox[{"\[FilledVerySmallSquare]", Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["NewEoSArgon Package"]], 
           "paclet:NewEoSArgon/guide/NewEoSArgon"},
          "RefLinkPlain",
          BaseStyle->{"MoreAbout"}]], "MoreAbout",ExpressionUUID->
         "27c697e1-8060-44f2-8ea1-015095934c55"]}]}
     }]}
  }]], "MoreAboutSection",ExpressionUUID->"9ae7b007-0c2d-4c8a-8c6f-\
86950dabec9f"],

Cell[BoxData[GridBox[{
   {
    TemplateBox[{29},
     "Spacer1"], GridBox[{
      {
       RowBox[{
        TemplateBox[{17},
         "Spacer1"], 
        StyleBox[
         RowBox[{"Related", " ", "Links"}], "RelatedLinksSection"]}]},
      {Cell[BoxData[Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData[
             RowBox[{
               RowBox[{"Units", " ", "&"}], " ", "Quantities"}]]], 
           "paclet:guide/Units"},
          "RefLinkPlain",
          BaseStyle->{"RelatedLinks"}]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "88881e1d-eea3-43f4-87db-4711b94c8100"]], "RelatedLinks",
        ExpressionUUID->"6fb052fa-d56e-4042-9e88-472a4de30d1b"]}
     }]}
  }]], "RelatedLinksSection",ExpressionUUID->"2fcacf36-81d7-49b6-af3e-\
6d0b3c7c746f"],

Cell[" ", "FooterCell",ExpressionUUID->"b5b66613-6e98-4314-8134-993718ed5b71"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{900, 835.8},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"pcNv",
TaggingRules->{
 "ModificationHighlight" -> False, "ColorType" -> "", "LinkTrails" -> "", 
  "HasOptions" -> True, "ExampleCounter" -> 1, 
  "Openers" -> {
   "PrimaryExamplesSection" -> Open, "ExampleSection" -> {"0" -> Open}}, 
  "NewStyles" -> True, "CitationPopupData" -> $Failed, "ShowCitation" -> 
  False, "RootCaptions" -> "", 
  "Metadata" -> {
   "built" -> "{2023, 11, 30, 13, 55, 45.7814906}", 
    "history" -> {"XX", "", "", ""}, "context" -> "NewEoSArgon`", 
    "keywords" -> {}, "specialkeywords" -> {}, 
    "tutorialcollectionlinks" -> {}, "index" -> True, "label" -> 
    "New Eo S Argon Package Symbol", "language" -> "en", "paclet" -> 
    "NewEoSArgon Package", "status" -> "None", "summary" -> 
    "pcNv (bar) Pression du point critique de l'argon d\[EAcute]duite des \
relations de Maxwell [Critical pressure of argon from Maxwell relations]", 
    "synonyms" -> {}, "tabletags" -> {}, "title" -> "pcNv", "titlemodifier" -> 
    "", "metadescription" -> "", "windowtitle" -> "pcNv", "type" -> "Symbol", 
    "uri" -> "NewEoSArgon/ref/pcNv"}},
CellContext->"Global`",
FrontEndVersion->"13.3 pour Microsoft Windows (64-bit) (July 24, 2023)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "13.3 pour Microsoft Windows (64-bit) (July 24, 2023)", 
  StyleDefinitions -> "Default.nb"],
ExpressionUUID->"942cea62-af13-46ae-9413-7767fa98d381"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7148, 188, 1420, 37, 35, "PrimaryExamplesSection",ExpressionUUID->"33506a4d-5912-4270-b732-d1c5eec4f407",
   CellTags->"PrimaryExamplesSection",
   CellID->206826702]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 17636, 484}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[576, 21, 5335, 130, 56, "AnchorBarGrid",ExpressionUUID->"390fba28-81c7-4f4d-a832-360d20b939cd",
 CellID->1],
Cell[5914, 153, 94, 0, 23, "ContextNameCell",ExpressionUUID->"fd1801d8-9fc1-423e-8f92-463af76d5e79"],
Cell[CellGroupData[{
Cell[6033, 157, 547, 14, 56, "ObjectNameGrid",ExpressionUUID->"540a4e24-46e3-46b3-91e7-170d2d5cb2ec"],
Cell[6583, 173, 528, 10, 146, "Usage",ExpressionUUID->"db73585c-7a76-4b85-8a87-70aff4109983"]
}, Open  ]],
Cell[CellGroupData[{
Cell[7148, 188, 1420, 37, 35, "PrimaryExamplesSection",ExpressionUUID->"33506a4d-5912-4270-b732-d1c5eec4f407",
 CellTags->"PrimaryExamplesSection",
 CellID->206826702],
Cell[CellGroupData[{
Cell[8593, 229, 1395, 36, 30, "ExampleSection",ExpressionUUID->"14b92b98-b09a-4dd8-9dcc-0cadc36e957d",
 CellID->926065],
Cell[9991, 267, 174, 3, 26, "Input",ExpressionUUID->"e2e53856-5b58-46ba-b95f-c8c2fd60e7f4",
 CellID->87419684],
Cell[10168, 272, 139, 1, 38, "ExampleText",ExpressionUUID->"a2cef37a-5da1-40e6-a661-a6f3024b9ac1",
 CellID->886239600],
Cell[CellGroupData[{
Cell[10332, 277, 195, 4, 26, "Input",ExpressionUUID->"aa4bbe1f-c383-4638-922c-3bc5881cbed9",
 CellID->21488140],
Cell[10530, 283, 205, 4, 40, "Output",ExpressionUUID->"9dd8b63c-8b9d-4cf9-b7e1-443ae08de4d1",
 CellID->330992777]
}, Open  ]],
Cell[CellGroupData[{
Cell[10772, 292, 309, 8, 26, "Input",ExpressionUUID->"6a20311c-2e98-40f2-848e-045697a31143",
 CellID->365175868],
Cell[11084, 302, 222, 5, 39, "Output",ExpressionUUID->"d54c0b55-dbe3-44a4-a9cf-3596a1514b7c",
 CellID->148890417]
}, Open  ]],
Cell[11321, 310, 130, 1, 38, "ExampleText",ExpressionUUID->"3a08ad60-3ea5-4f86-aebf-ad77b8ced68d",
 CellID->32289193],
Cell[CellGroupData[{
Cell[11476, 315, 296, 9, 26, "Input",ExpressionUUID->"88d44a35-b5e2-4c20-a115-96782132bc41",
 CellID->91147354],
Cell[11775, 326, 234, 5, 40, "Output",ExpressionUUID->"5e50d198-63a0-4d29-927e-35e3e63155c5",
 CellID->16981765]
}, Open  ]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"}, Closed]]]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "PrimaryExamplesSection"}, Closed]]]],
Cell[12251, 340, 1858, 50, 114, "SeeAlsoSection",ExpressionUUID->"0a497a32-905f-4a41-8f8c-d1bc40a71567"],
Cell[14112, 392, 729, 19, 114, "MoreAboutSection",ExpressionUUID->"9ae7b007-0c2d-4c8a-8c6f-86950dabec9f"],
Cell[14844, 413, 825, 24, 101, "RelatedLinksSection",ExpressionUUID->"2fcacf36-81d7-49b6-af3e-6d0b3c7c746f"],
Cell[15672, 439, 78, 0, 70, "FooterCell",ExpressionUUID->"b5b66613-6e98-4314-8134-993718ed5b71"]
}
]
*)

(* End of internal cache information *)

