(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 13.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    139423,       2821]
NotebookOptionsPosition[    134455,       2717]
NotebookOutlinePosition[    136590,       2772]
CellTagsIndexPosition[    136503,       2767]
WindowTitle->ptr
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[GridBox[{
   {GridBox[{
      {
       ItemBox[Cell[BoxData[
         RowBox[{
          TemplateBox[{12},
           "Spacer1"], Cell["NEW EO S ARGON PACKAGE SYMBOL", "PacletNameCell",
           TextAlignment->Center,ExpressionUUID->
           "f0c38e49-8752-46d2-a5e9-a2776a5db4f2"], 
          TemplateBox[{8},
           "Spacer1"]}]],
         TextAlignment->Center,ExpressionUUID->
         "4dd7b5ad-b06c-4563-bd10-87ad10597ff6"],
        Background->RGBColor[0.490196, 0.576471, 0.690196],
        ItemSize->Full], ""}
     },
     GridBoxAlignment->{"Rows" -> {{Center}}},
     GridBoxItemSize->{"Columns" -> {Full, 
         Scaled[0.02]}, "Rows" -> {{2.5}}}], Cell[TextData[{
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "See Also",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "7105d015-044e-4d27-ab87-82c294ef3417"]
         }],ExpressionUUID->"9524b0e6-58a3-46b0-807c-014fb7e2a051"],
         StripOnInput->False],{
        "\"ttr\"" :> Documentation`HelpLookup["paclet:NewEoSArgon/ref/ttr"], 
         "\"rhotrgaz\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/rhotrgaz"], 
         "\"rhotrliq\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/rhotrliq"]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"SeeAlso"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "7f50f32b-883f-4625-b155-00167c017fe8"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "Related Guides",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "63bdcea0-9954-4826-b336-ce4c035c08d4"]
         }],ExpressionUUID->"0e616226-f556-4da1-a15b-3046e1831994"],
         StripOnInput->False],{
        "\"NewEoSArgon Package\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/guide/NewEoSArgon"]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"MoreAbout"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "7eb87b6d-225f-457e-9efb-aa89e56ff7e6"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "URL",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "712fb755-ff53-4d3d-914b-1a01c5c89c8e"]
         }],ExpressionUUID->"1c8052c4-cd4d-4f64-816c-e2e1961d9eb3"],
         StripOnInput->False],{
        "\"NewEoSArgon/ref/ptr\"" :> None, 
         "\"Copy Wolfram Documentation Center URL\"" :> 
         Module[{DocumentationSearch`Private`nb$}, 
           DocumentationSearch`Private`nb$ = 
            NotebookPut[
             Notebook[{Cell["NewEoSArgon/ref/ptr"]}, Visible -> False]]; 
           SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
           FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
           NotebookClose[DocumentationSearch`Private`nb$]; Null], Delimiter, 
         "\"Copy web URL\"" :> 
         Module[{DocumentationSearch`Private`nb$}, 
           DocumentationSearch`Private`nb$ = 
            NotebookPut[
             Notebook[{
               Cell[BoxData[
                 MakeBoxes[
                  Hyperlink[
                   "http://reference.wolfram.com/language/NewEoSArgon/ref/ptr.\
html"], StandardForm]], "Input", TextClipboardType -> "PlainText"]}, Visible -> 
               False]]; 
           SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
           FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
           NotebookClose[DocumentationSearch`Private`nb$]; Null], 
         "\"Go to web URL\"" :> 
         FrontEndExecute[{
           NotebookLocate[{
             URL[If[TrueQ[DocumentationBuild`Make`Private`wsmlinkQ$20603], 
                 "http://reference.wolfram.com/system-modeler/", 
                 "http://reference.wolfram.com/language/"] <> 
               "NewEoSArgon/ref/ptr" <> ".html"], None}]}]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"URLMenu"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "41e694b6-f369-418e-ad03-fb0a2a268f02"]
    }], "AnchorBar",
     CacheGraphics->False,ExpressionUUID->
     "3b3169ac-1090-45ca-8215-3465a65580a5"]}
  }]], "AnchorBarGrid",
 CellID->1,ExpressionUUID->"11c96cab-b502-46b6-9785-44cc529cb29b"],

Cell["NewEoSArgon`", "ContextNameCell",ExpressionUUID->"2af85584-f021-4cb9-9c25-a55b75b15856"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     Cell[
     "ptr", "ObjectName",ExpressionUUID->
      "3c29309f-37dd-4c84-b4a5-1db61ba0a321"],
     Cell[BoxData[
      TemplateBox[{8},
       "Spacer1"]],ExpressionUUID->"e6abe891-ab79-4777-9642-223718d19f02"],
     Cell[BoxData[
     ""], "ObjectNameTranslation",ExpressionUUID->
      "86d499ed-2049-429f-8ddf-b3b188a4d1cd"]
    }],ExpressionUUID->"fd788978-a77d-44dc-bf1e-4c9bef241bb4"], 
    "\[SpanFromLeft]"}
  }]], "ObjectNameGrid",ExpressionUUID->"2d0ab0d6-5cd6-4072-9733-\
3313ff97da87"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["ptr"], "InlineFormula",
      ShowStringCharacters->False,
      FontFamily->"Source Sans Pro",ExpressionUUID->
      "2335069d-7bdc-48da-97f1-30a74a372ca1"],
     " (bar)\nPression du point triple de l'argon donn\[EAcute]e par NIST  \n\
[Triple point pressure of argon from NIST]"
    }],ExpressionUUID->"a1c802ed-7bd5-4a49-9313-e76f2209201e"]}
  }]], "Usage",
 Deletable->True,ExpressionUUID->"b24aec3e-5417-4524-84bb-dcff0c972aae"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {
       TaggingRules, "Openers", "PrimaryExamplesSection"}, Open], 
      Alternatives[True, Open]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{13.600000000000001`, {5., 8.600000000000001}}]],
  ExpressionUUID->"b9f45956-0ad7-460a-927f-c99a216018a1"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"bd2242a2-1398-41f2-bcef-aef7f03d6397"],
 "Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "245ad6a5-ab73-4aad-bb0a-3a925dd71a46"]
}], "PrimaryExamplesSection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellTags->"PrimaryExamplesSection",
 CellID->244780177,ExpressionUUID->"37ddc2a3-4643-4ab2-bd86-b9b5dfa4e03b"],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"},
        Closed], 
      Alternatives[Open, True]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{13.600000000000001`, {5., 8.600000000000001}}]],
  ExpressionUUID->"2a1cfd0d-4925-4168-a422-2edc530d351c"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"64d1594b-bbe5-46cf-abeb-12835a9da079"],
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "54662daa-3669-44f7-8ae2-7f570f460b6c"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellID->75002553,ExpressionUUID->"1c49bda3-50aa-42e8-b122-9f4e995dc81e"],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<NewEoSArgon`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->87419684,ExpressionUUID->"54168b4e-f021-4ad8-973a-d0494e2ba13b"],

Cell["Give a physical dimension to the constant", "ExampleText",
 CellID->886239600,ExpressionUUID->"63773d97-9c0f-4721-bca7-6b488f59a18d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Quantity", "[", 
  RowBox[{"ptr", ",", "\"\<Bars\>\""}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->21488140,ExpressionUUID->"1bb3af40-1cb5-474b-a356-0e3587668692"],

Cell[BoxData[
 TemplateBox[{"0.68891`", "\"bar\"", "bars", "\"Bars\""},
  "Quantity"]], "Output",
 CellLabel->"Out[2]=",
 CellID->86698468,ExpressionUUID->"e307ab7f-966d-4bd2-9dbc-73fd3cad02e5"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UnitConvert", "[", 
  RowBox[{
   RowBox[{"Quantity", "[", 
    RowBox[{"0.68891`", ",", "\"\<Bars\>\""}], "]"}], ",", "\"\<MPa\>\""}], 
  "]"}]], "Input",
 NumberMarks->False,
 CellLabel->"In[3]:=",
 CellID->204817585,ExpressionUUID->"5ba5c25b-35a8-49ee-98e8-ab499f0d2897"],

Cell[BoxData[
 TemplateBox[{
  "0.06889100000000001`", "\"MPa\"", "megapascals", "\"Megapascals\""},
  "Quantity"]], "Output",
 CellLabel->"Out[3]=",
 CellID->413504480,ExpressionUUID->"d1e0274e-7577-4f9c-a7db-2622a6bb223c"]
}, Open  ]],

Cell["Using WolframAlpha", "ExampleText",
 CellID->351008126,ExpressionUUID->"f29d6492-6ca4-4eab-aa12-98a68c4ea3ec"],

Cell[CellGroupData[{

Cell[BoxData[
 NamespaceBox["WolframAlphaQueryResults",
  DynamicModuleBox[{Typeset`q$$ = "triple point pressure of argon", 
   Typeset`opts$$ = {
   AppearanceElements -> {"Extrusion", "Warnings", "Assumptions", "Pods"}, 
    Asynchronous -> All, 
    Method -> {
     "ExtrusionChosen" -> {
       "Result", "Result", 1, 1, "Output", "Quantity[68891, \"Pascals\"]"}, 
      "Formats" -> {"cell", "minput", "moutput", "msound", "dataformats"}, 
      "ExtrusionOpen" -> True}}, Typeset`elements$$ = {
   "Extrusion", "Warnings", "Assumptions", "Pods"}, Typeset`pod1$$ = 
   XMLElement[
   "pod", {"title" -> "Input interpretation", "scanner" -> "Identity", "id" -> 
     "Input", "position" -> "100", "error" -> "false", "numsubpods" -> "1"}, {
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement["cell", {"compressed" -> False, "string" -> True}, {
         Cell[
          BoxData[
           FormBox[
            TagBox[
             FormBox[
              TagBox[
               GridBox[{{
                  PaneBox[
                   StyleBox[
                    TagBox[
                    GridBox[{{
                    StyleBox[
                    TagBox[
                    TagBox["\"argon\"", 
                    $CellContext`TagBoxWrapper[
                    "Entity" -> {ChemicalData, "Argon"}]], Identity], {
                    LineIndent -> 0, LineSpacing -> {0.9, 0, 1.5}}], 
                    "\"triple point pressure\""}}, 
                    GridBoxBackground -> {"Columns" -> {
                    GrayLevel[0.949], None}, "Rows" -> {{None}}}, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    ColumnsEqual -> False, RowsEqual -> False, 
                    GridBoxDividers -> {"Columns" -> {
                    GrayLevel[0.84], 
                    GrayLevel[0.84], 
                    GrayLevel[0.84]}, "Rows" -> {{
                    GrayLevel[0.84]}}, 
                    "RowsIndexed" -> {
                    1 -> GrayLevel[0.84], -1 -> GrayLevel[0.84]}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {1, 1, 1}, "Rows" -> {{0.3}}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Baseline}}}, 
                    AllowScriptLevelChange -> False, BaselinePosition -> 1], 
                    $CellContext`TagBoxWrapper["Separator" -> " | "]], 
                    LineSpacing -> {1, 0, 1.5}, LineIndent -> 0], 
                   BaselinePosition -> Center]}}, 
                GridBoxItemSize -> {
                 "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                ColumnsEqual -> False, RowsEqual -> False, 
                GridBoxSpacings -> {"Columns" -> {{
                    AbsoluteThickness[-1]}}, "Rows" -> {{0}}}, 
                AllowScriptLevelChange -> False], 
               $CellContext`TagBoxWrapper["Separator" -> " | "]], 
              TraditionalForm], 
             PolynomialForm[#, TraditionalOrder -> False]& ], 
            TraditionalForm]], "Output"]}], 
       XMLElement[
       "dataformats", {}, {"plaintext,computabledata,formatteddata"}]}]}], 
   Typeset`pod2$$ = XMLElement[
   "pod", {"title" -> "Result", "scanner" -> "Data", "id" -> "Result", 
     "position" -> "200", "error" -> "false", "numsubpods" -> "1", "primary" -> 
     "true"}, {
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement["moutput", {}, {"Quantity[68891, \"Pascals\"]"}], 
       XMLElement["cell", {"compressed" -> False, "string" -> True}, {
         Cell[
          BoxData[
           FormBox[
            StyleBox[
             TagBox[
              RowBox[{
                TagBox[
                 TagBox[
                  RowBox[{
                    TagBox["68\[ThinSpace]891", 
                    $CellContext`TagBoxWrapper["StringBoxes" -> "68891"]], 
                    "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    "\"Pa\"", FontFamily -> "Helvetica", FontSize -> 
                    Smaller]}], Identity], #& , SyntaxForm -> Dot], "  ", 
                StyleBox[
                 
                 RowBox[{
                  "\"(\"", "\[NoBreak]", "\"pascals\"", "\[NoBreak]", 
                   "\")\""}], {
                 FontFamily :> $CellContext`$UnitFontFamily, FontSize -> 
                  Smaller, 
                  GrayLevel[0.6], LinebreakAdjustments -> {1, 100, 1, 0, 100},
                   LineIndent -> 0}, StripOnInput -> False]}], "Unit", 
              SyntaxForm -> Dot], LinebreakAdjustments -> {1, 100, 1, 0, 100},
              LineIndent -> 0, ZeroWidthTimes -> False], TraditionalForm]], 
          "Output"]}], 
       XMLElement[
       "dataformats", {}, {
        "plaintext,moutput,computabledata,formatteddata,numberdata,\
quantitydata"}]}]}], Typeset`pod3$$ = XMLElement[
   "pod", {"title" -> "Unit conversions", "scanner" -> "Unit", "id" -> 
     "UnitConversion", "position" -> "300", "error" -> "false", "numsubpods" -> 
     "5"}, {
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement["cell", {"compressed" -> False, "string" -> True}, {
         Cell[
          BoxData[
           FormBox[
            StyleBox[
             TagBox[
              RowBox[{
                TagBox[
                 TagBox[
                  RowBox[{
                    TagBox["68.89", 
                    $CellContext`TagBoxWrapper["StringBoxes" -> "68.89"]], 
                    "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    "\"kPa\"", FontFamily -> "Helvetica", FontSize -> 
                    Smaller]}], Identity], #& , SyntaxForm -> Dot], "  ", 
                StyleBox[
                 
                 RowBox[{
                  "\"(\"", "\[NoBreak]", "\"kilopascals\"", "\[NoBreak]", 
                   "\")\""}], {
                 FontFamily :> $CellContext`$UnitFontFamily, FontSize -> 
                  Smaller, 
                  GrayLevel[0.6], LinebreakAdjustments -> {1, 100, 1, 0, 100},
                   LineIndent -> 0}, StripOnInput -> False]}], "Unit", 
              SyntaxForm -> Dot], LinebreakAdjustments -> {1, 100, 1, 0, 100},
              LineIndent -> 0, ZeroWidthTimes -> False], TraditionalForm]], 
          "Output"]}], 
       XMLElement[
       "dataformats", {}, {
        "plaintext,computabledata,formatteddata,numberdata,quantitydata"}]}], 
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement["cell", {"compressed" -> False, "string" -> True}, {
         Cell[
          BoxData[
           FormBox[
            StyleBox[
             TagBox[
              RowBox[{
                TagBox[
                 TagBox[
                  RowBox[{
                    TagBox["0.06889", 
                    $CellContext`TagBoxWrapper["StringBoxes" -> "0.06889"]], 
                    "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    "\"MPa\"", FontFamily -> "Helvetica", FontSize -> 
                    Smaller]}], Identity], #& , SyntaxForm -> Dot], "  ", 
                StyleBox[
                 
                 RowBox[{
                  "\"(\"", "\[NoBreak]", "\"megapascals\"", "\[NoBreak]", 
                   "\")\""}], {
                 FontFamily :> $CellContext`$UnitFontFamily, FontSize -> 
                  Smaller, 
                  GrayLevel[0.6], LinebreakAdjustments -> {1, 100, 1, 0, 100},
                   LineIndent -> 0}, StripOnInput -> False]}], "Unit", 
              SyntaxForm -> Dot], LinebreakAdjustments -> {1, 100, 1, 0, 100},
              LineIndent -> 0, ZeroWidthTimes -> False], TraditionalForm]], 
          "Output"]}], 
       XMLElement[
       "dataformats", {}, {
        "plaintext,computabledata,formatteddata,numberdata,quantitydata"}]}], 
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement["cell", {"compressed" -> False, "string" -> True}, {
         Cell[
          BoxData[
           FormBox[
            StyleBox[
             TagBox[
              RowBox[{
                TagBox[
                 TagBox[
                  RowBox[{
                    TagBox["68\[ThinSpace]891", 
                    $CellContext`TagBoxWrapper["StringBoxes" -> "68891"]], 
                    "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    
                    RowBox[{
                    "\"N\"", "\[InvisibleSpace]", "\"/\"", 
                    "\[InvisibleSpace]", 
                    SuperscriptBox["\"m\"", "2"]}], FontFamily -> "Helvetica",
                     FontSize -> Smaller]}], Identity], #& , SyntaxForm -> 
                 Dot], "  ", 
                StyleBox[
                 
                 RowBox[{
                  "\"(\"", "\[NoBreak]", "\"newtons per square meter\"", 
                   "\[NoBreak]", "\")\""}], {
                 FontFamily :> $CellContext`$UnitFontFamily, FontSize -> 
                  Smaller, 
                  GrayLevel[0.6], LinebreakAdjustments -> {1, 100, 1, 0, 100},
                   LineIndent -> 0}, StripOnInput -> False]}], "Unit", 
              SyntaxForm -> Dot], LinebreakAdjustments -> {1, 100, 1, 0, 100},
              LineIndent -> 0, ZeroWidthTimes -> False], TraditionalForm]], 
          "Output"]}], 
       XMLElement[
       "dataformats", {}, {
        "plaintext,computabledata,formatteddata,numberdata,quantitydata"}]}], 
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement["cell", {"compressed" -> False, "string" -> True}, {
         Cell[
          BoxData[
           FormBox[
            TagBox[
             GridBox[{{
                StyleBox[
                 TagBox[
                  RowBox[{
                    TagBox[
                    TagBox[
                    RowBox[{
                    TagBox["0.6799", 
                    $CellContext`TagBoxWrapper["StringBoxes" -> "0.6799"]], 
                    "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    "\"atm\"", FontFamily -> "Helvetica", FontSize -> 
                    Smaller]}], Identity], #& , SyntaxForm -> Dot], "  ", 
                    StyleBox[
                    
                    RowBox[{
                    "\"(\"", "\[NoBreak]", "\"atmospheres\"", "\[NoBreak]", 
                    "\")\""}], {
                    FontFamily :> $CellContext`$UnitFontFamily, FontSize -> 
                    Smaller, 
                    GrayLevel[0.6], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0}, StripOnInput -> False]}], "Unit", SyntaxForm -> Dot], 
                 LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 0,
                  ZeroWidthTimes -> False]}, {
                TemplateBox[{"\" \"", 
                  StyleBox[
                   
                   RowBox[{
                    "\"(\"", "\[NoBreak]", "\"unit officially deprecated\"", 
                    "\[NoBreak]", "\")\""}], {
                   FontFamily -> "Verdana", FontSize -> 10, 
                    GrayLevel[0.5], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0}, StripOnInput -> False]}, "RowDefault"]}}, 
              GridBoxAlignment -> {"Columns" -> {{Left}}}, 
              AllowScriptLevelChange -> False, DefaultBaseStyle -> "Column", 
              GridBoxItemSize -> {
               "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
              GridBoxSpacings -> {
               "Columns" -> {{Automatic}}, "Rows" -> {{0}}}], "Column"], 
            TraditionalForm]], "Output"]}], 
       XMLElement[
       "dataformats", {}, {
        "plaintext,computabledata,formatteddata,numberdata,quantitydata"}]}], 
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement["cell", {"compressed" -> False, "string" -> True}, {
         Cell[
          BoxData[
           FormBox[
            TagBox[
             GridBox[{{
                StyleBox[
                 TagBox[
                  RowBox[{
                    TagBox[
                    TagBox[
                    RowBox[{
                    TagBox["0.7025", 
                    $CellContext`TagBoxWrapper["StringBoxes" -> "0.7025"]], 
                    "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    "\"at\"", FontFamily -> "Helvetica", FontSize -> 
                    Smaller]}], Identity], #& , SyntaxForm -> Dot], "  ", 
                    StyleBox[
                    
                    RowBox[{
                    "\"(\"", "\[NoBreak]", "\"technical atmospheres\"", 
                    "\[NoBreak]", "\")\""}], {
                    FontFamily :> $CellContext`$UnitFontFamily, FontSize -> 
                    Smaller, 
                    GrayLevel[0.6], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0}, StripOnInput -> False]}], "Unit", SyntaxForm -> Dot], 
                 LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 0,
                  ZeroWidthTimes -> False]}, {
                TemplateBox[{"\" \"", 
                  StyleBox[
                   
                   RowBox[{
                    "\"(\"", "\[NoBreak]", "\"unit officially deprecated\"", 
                    "\[NoBreak]", "\")\""}], {
                   FontFamily -> "Verdana", FontSize -> 10, 
                    GrayLevel[0.5], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0}, StripOnInput -> False]}, "RowDefault"]}}, 
              GridBoxAlignment -> {"Columns" -> {{Left}}}, 
              AllowScriptLevelChange -> False, DefaultBaseStyle -> "Column", 
              GridBoxItemSize -> {
               "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
              GridBoxSpacings -> {
               "Columns" -> {{Automatic}}, "Rows" -> {{0}}}], "Column"], 
            TraditionalForm]], "Output"]}], 
       XMLElement[
       "dataformats", {}, {
        "plaintext,computabledata,formatteddata,numberdata,quantitydata"}]}], 
     XMLElement["states", {"count" -> "1"}, {
       XMLElement[
       "state", {
        "name" -> "More", "input" -> "UnitConversion__More"}, {}]}]}], 
   Typeset`pod4$$ = XMLElement[
   "pod", {"title" -> "Comparisons as pressure", "scanner" -> "Unit", "id" -> 
     "ComparisonAsPressure", "position" -> "400", "error" -> "false", 
     "numsubpods" -> "3"}, {
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement["cell", {"compressed" -> False, "string" -> True}, {
         Cell[
          BoxData[
           FormBox[
            FormBox[
             TemplateBox[{"\" \[TildeTilde] \"", 
               TemplateBox[{"\"\"", "0", "\".\"", "6", "8"}, "RowDefault"], 
               "\" \"", 
               StyleBox["\"\[Times]\"", 
                GrayLevel[0.3], FontSize -> 10.219999999999999`, StripOnInput -> 
                False], "\"\[MediumSpace]\"", 
               StyleBox[
               "\"standard atmospheric pressure at sea level\"", FontFamily -> 
                "Helvetica", FontSize -> Smaller, StripOnInput -> False], 
               "\" \"", 
               StyleBox[
                RowBox[{"\"(\"", "\[NoBreak]", 
                  TemplateBox[{"\"\[MediumSpace]\"", 
                    StyleBox[
                    TagBox[
                    TagBox[
                    TagBox[
                    RowBox[{
                    TagBox["1", 
                    $CellContext`TagBoxWrapper["StringBoxes" -> "1"]], 
                    "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    "\"atm\"", FontFamily -> "Helvetica", FontSize -> 
                    Smaller]}], Identity], #& , SyntaxForm -> Dot], "Unit", 
                    SyntaxForm -> Dot], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, ZeroWidthTimes -> False], "\"\[MediumSpace]\""}, 
                   "RowDefault"], "\[NoBreak]", "\")\""}], {
                FontFamily -> "Verdana", FontSize -> 10, 
                 GrayLevel[0.5], LinebreakAdjustments -> {1, 100, 1, 0, 100}, 
                 LineIndent -> 0}, StripOnInput -> False]}, "RowDefault"], 
             TraditionalForm], TraditionalForm]], "Output"]}], 
       XMLElement["dataformats", {}, {"plaintext"}]}], 
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement["cell", {"compressed" -> False, "string" -> True}, {
         Cell[
          BoxData[
           FormBox[
            FormBox[
             TemplateBox[{"\" \[TildeTilde] \"", 
               InterpretationBox[
                Cell[
                 BoxData[
                  FormBox[
                   FormBox[
                    TagBox[
                    FormBox[
                    TemplateBox[{
                    TemplateBox[{
                    StyleBox[
                    "\"(\"", LinebreakAdjustments -> {1, 100, 1, 0, 100}, 
                    LineIndent -> 0, 
                    GrayLevel[0.6], StripOnInput -> False]}, "RowDefault"], 
                    "0.4", 
                    TemplateBox[{
                    StyleBox[
                    "\" to\[MediumSpace]\"", 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, 
                    GrayLevel[0.6], StripOnInput -> False]}, "RowDefault"], 
                    "1.3", 
                    TemplateBox[{
                    StyleBox[
                    "\")\"", LinebreakAdjustments -> {1, 100, 1, 0, 100}, 
                    LineIndent -> 0, 
                    GrayLevel[0.6], StripOnInput -> False]}, "RowDefault"]}, 
                    "RowDefault"], TraditionalForm], 
                    Format[#, TraditionalForm]& ], TraditionalForm], 
                   TraditionalForm]]], 
                TextCell[
                 $CellContext`RowTemplate[
                 "<GrayText>(</GrayText>`1`<GrayText> \
to\[MediumSpace]</GrayText>`2`<GrayText>)</GrayText>", {
                   $CellContext`NRat[0.3827277777777773893`1.], 
                   $CellContext`NRat[1.377820000000001377`2.]}]]], "\" \"", 
               StyleBox["\"\[Times]\"", 
                GrayLevel[0.3], FontSize -> 10.219999999999999`, StripOnInput -> 
                False], "\"\[MediumSpace]\"", 
               StyleBox[
               "\"overpressure in a typical automobile tire\"", FontFamily -> 
                "Helvetica", FontSize -> Smaller, StripOnInput -> False], 
               "\" \"", 
               StyleBox[
                RowBox[{"\"(\"", "\[NoBreak]", 
                  TemplateBox[{"\"\[MediumSpace]\"", 
                    StyleBox[
                    TagBox[
                    TagBox[
                    RowBox[{
                    TemplateBox[{
                    TagBox["50", 
                    $CellContext`TagBoxWrapper["StringBoxes" -> "50"]], 
                    TagBox["180", 
                    $CellContext`TagBoxWrapper["StringBoxes" -> "180"]], 
                    RowBox[{
                    TagBox["50", 
                    $CellContext`TagBoxWrapper["StringBoxes" -> "50"]], 
                    StyleBox["\"\[MediumSpace]to\[MediumSpace]\"", 
                    GrayLevel[0.6]], 
                    TagBox["180", 
                    $CellContext`TagBoxWrapper["StringBoxes" -> "180"]]}]}, 
                    "Interval", DisplayFunction -> (#3& ), 
                    InterpretationFunction -> (RowBox[{"Interval", "[", 
                    RowBox[{"{", #, ",", #2, "}"}], "]"}]& )], "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    "\"kPa\"", FontFamily -> "Helvetica", FontSize -> 
                    Smaller]}], #& , SyntaxForm -> Dot], "Unit", SyntaxForm -> 
                    Dot], LinebreakAdjustments -> {1, 100, 1, 0, 100}, 
                    LineIndent -> 0, ZeroWidthTimes -> False], 
                    "\"\[MediumSpace]\""}, "RowDefault"], "\[NoBreak]", 
                  "\")\""}], {FontFamily -> "Verdana", FontSize -> 10, 
                 GrayLevel[0.5], LinebreakAdjustments -> {1, 100, 1, 0, 100}, 
                 LineIndent -> 0}, StripOnInput -> False]}, "RowDefault"], 
             TraditionalForm], TraditionalForm]], "Output"]}], 
       XMLElement["dataformats", {}, {"plaintext"}]}], 
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement["cell", {"compressed" -> False, "string" -> True}, {
         Cell[
          BoxData[
           FormBox[
            FormBox[
             
             TemplateBox[{
              "\" \[TildeTilde] \"", 
               "0.98415714285714285714285714285714285714`2.7932309427302924", 
               "\" \"", 
               StyleBox["\"\[Times]\"", 
                GrayLevel[0.3], FontSize -> 10.219999999999999`, StripOnInput -> 
                False], "\"\[MediumSpace]\"", 
               StyleBox[
               "\"pressure inside an incandescent light bulb\"", FontFamily -> 
                "Helvetica", FontSize -> Smaller, StripOnInput -> False], 
               "\" \"", 
               StyleBox[
                RowBox[{"\"(\"", "\[NoBreak]", 
                  TemplateBox[{"\"\[TildeTilde]\[ThinSpace]\"", 
                    StyleBox[
                    TagBox[
                    TagBox[
                    TagBox[
                    RowBox[{
                    TagBox["70\[ThinSpace]000", 
                    $CellContext`TagBoxWrapper["StringBoxes" -> "70000"]], 
                    "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    "\"Pa\"", FontFamily -> "Helvetica", FontSize -> 
                    Smaller]}], Identity], #& , SyntaxForm -> Dot], "Unit", 
                    SyntaxForm -> Dot], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, ZeroWidthTimes -> False], "\"\[MediumSpace]\""}, 
                   "RowDefault"], "\[NoBreak]", "\")\""}], {
                FontFamily -> "Verdana", FontSize -> 10, 
                 GrayLevel[0.5], LinebreakAdjustments -> {1, 100, 1, 0, 100}, 
                 LineIndent -> 0}, StripOnInput -> False]}, "RowDefault"], 
             TraditionalForm], TraditionalForm]], "Output"]}], 
       XMLElement["dataformats", {}, {"plaintext"}]}]}], Typeset`pod5$$ = 
   XMLElement[
   "pod", {"title" -> "Corresponding quantities", "scanner" -> "Unit", "id" -> 
     "CorrespondingQuantity", "position" -> "500", "error" -> "false", 
     "numsubpods" -> "2"}, {
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement["cell", {"compressed" -> False, "string" -> True}, {
         Cell[
          BoxData[
           FormBox[
            TagBox[
             GridBox[{{
                InterpretationBox[
                 Cell[
                  TextData[{"Depth of water ", 
                    Cell[
                    BoxData[
                    FormBox["d", TraditionalForm]]], " giving overpressure ", 
                    Cell[
                    BoxData[
                    FormBox["P", TraditionalForm]]], " from ", 
                    Cell[
                    BoxData[
                    FormBox[
                    FormBox[
                    TemplateBox[{
                    TagBox[
                    RowBox[{"P", "\[LongEqual]", 
                    RowBox[{
                    SubscriptBox["\[Rho]", "\"water\""], "\[InvisibleSpace]", 
                    "g", "\[InvisibleSpace]", "h"}]}], 
                    PolynomialForm[#, TraditionalOrder -> False]& ], "\":\""},
                     "RowDefault"], TraditionalForm], TraditionalForm]]]}]], 
                 TextCell[
                  Row[{"Depth of water ", 
                    $CellContext`CalculateSymbol["d"], 
                    " giving overpressure ", 
                    $CellContext`CalculateSymbol["P"], " from ", 
                    $CellContext`InlineForm[
                    "P \[LongEqual] Subscript[\[Rho],\"water\"] g h", 
                    ":"]}]]]}, {
                TagBox[
                 GridBox[{{
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {10, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[10]], 
                    StyleBox[
                    TagBox[
                    TagBox[
                    TagBox[
                    RowBox[{
                    TagBox["7", 
                    $CellContext`TagBoxWrapper["StringBoxes" -> "7"]], 
                    "\[InvisibleSpace]", " ", 
                    StyleBox[
                    "\"meters\"", LinebreakAdjustments -> {1, 100, 1, 0, 100},
                     LineIndent -> 0, {
                    FontFamily :> $CellContext`$UnitFontFamily, FontSize -> 
                    Smaller}, StripOnInput -> False]}], Identity], #& , 
                    SyntaxForm -> Dot], "Unit", SyntaxForm -> Dot], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, ZeroWidthTimes -> False]}, {
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {10, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[10]], 
                    StyleBox[
                    TagBox[
                    TagBox[
                    TagBox[
                    RowBox[{
                    TagBox["23", 
                    $CellContext`TagBoxWrapper["StringBoxes" -> "23"]], 
                    "\[InvisibleSpace]", " ", 
                    StyleBox[
                    "\"feet\"", LinebreakAdjustments -> {1, 100, 1, 0, 100}, 
                    LineIndent -> 0, {
                    FontFamily :> $CellContext`$UnitFontFamily, FontSize -> 
                    Smaller}, StripOnInput -> False]}], Identity], #& , 
                    SyntaxForm -> Dot], "Unit", SyntaxForm -> Dot], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, ZeroWidthTimes -> False]}, {
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {10, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[10]], 
                    StyleBox[
                    RowBox[{"\"(\"", "\[NoBreak]", 
                    FormBox[
                    TagBox[
                    FormBox[
                    
                    TemplateBox[{
                    "\"assuming \"", "\"maximum water density\"", 
                    "\" \[TildeTilde] \"", 
                    StyleBox[
                    TagBox[
                    TagBox[
                    TagBox[
                    RowBox[{
                    TagBox["1000", 
                    $CellContext`TagBoxWrapper["StringBoxes" -> "1000"]], 
                    "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    
                    RowBox[{"\"kg\"", "\[InvisibleSpace]", "\"/\"", 
                    "\[InvisibleSpace]", 
                    SuperscriptBox["\"m\"", "3"]}], FontFamily -> "Helvetica",
                     FontSize -> Smaller]}], Identity], #& , SyntaxForm -> 
                    Dot], "Unit", SyntaxForm -> Dot], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, ZeroWidthTimes -> False]}, "RowDefault"], 
                    TraditionalForm], Format[#, TraditionalForm]& ], 
                    TraditionalForm], "\[NoBreak]", "\")\""}], {
                    FontFamily -> "Verdana", FontSize -> 10, 
                    GrayLevel[0.5], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0}, StripOnInput -> False]}}, 
                  GridBoxAlignment -> {"Columns" -> {{Left}}}, AutoDelete -> 
                  False, GridBoxItemSize -> {
                   "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
                 "Grid"]}}, GridBoxAlignment -> {"Columns" -> {{Left}}}, 
              DefaultBaseStyle -> "Column", 
              GridBoxItemSize -> {"ColumnsIndexed" -> {1 -> 0}}], "Column"], 
            TraditionalForm]], "Output"]}], 
       XMLElement[
       "dataformats", {}, {
        "plaintext,computabledata,formatteddata,numberdata,quantitydata"}]}], 
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement["cell", {"compressed" -> False, "string" -> True}, {
         Cell[
          BoxData[
           FormBox[
            TagBox[
             GridBox[{{
                InterpretationBox[
                 Cell[
                  TextData[{"Standard Atmosphere altitude:"}]], 
                 TextCell[
                  Row[{"Standard Atmosphere altitude:"}]]]}, {
                TagBox[
                 GridBox[{{
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {10, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[10]], 
                    StyleBox[
                    TagBox[
                    RowBox[{
                    TagBox[
                    TagBox[
                    RowBox[{
                    TagBox["3.1", 
                    $CellContext`TagBoxWrapper["StringBoxes" -> "3.1"]], 
                    "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    "\"km\"", FontFamily -> "Helvetica", FontSize -> 
                    Smaller]}], Identity], #& , SyntaxForm -> Dot], "  ", 
                    StyleBox[
                    
                    RowBox[{
                    "\"(\"", "\[NoBreak]", "\"kilometers\"", "\[NoBreak]", 
                    "\")\""}], {
                    FontFamily :> $CellContext`$UnitFontFamily, FontSize -> 
                    Smaller, 
                    GrayLevel[0.6], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0}, StripOnInput -> False]}], "Unit", SyntaxForm -> Dot], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, ZeroWidthTimes -> False]}, {
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {10, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[10]], 
                    StyleBox[
                    TagBox[
                    TagBox[
                    TagBox[
                    RowBox[{
                    TagBox["2", 
                    $CellContext`TagBoxWrapper["StringBoxes" -> "2"]], 
                    "\[InvisibleSpace]", " ", 
                    StyleBox[
                    "\"miles\"", LinebreakAdjustments -> {1, 100, 1, 0, 100}, 
                    LineIndent -> 0, {
                    FontFamily :> $CellContext`$UnitFontFamily, FontSize -> 
                    Smaller}, StripOnInput -> False]}], Identity], #& , 
                    SyntaxForm -> Dot], "Unit", SyntaxForm -> Dot], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, ZeroWidthTimes -> False]}, {
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {10, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[10]], 
                    StyleBox[
                    TagBox[
                    TagBox[
                    TagBox[
                    RowBox[{
                    TagBox["10\[ThinSpace]299", 
                    $CellContext`TagBoxWrapper["StringBoxes" -> "10299"]], 
                    "\[InvisibleSpace]", " ", 
                    StyleBox[
                    "\"feet\"", LinebreakAdjustments -> {1, 100, 1, 0, 100}, 
                    LineIndent -> 0, {
                    FontFamily :> $CellContext`$UnitFontFamily, FontSize -> 
                    Smaller}, StripOnInput -> False]}], Identity], #& , 
                    SyntaxForm -> Dot], "Unit", SyntaxForm -> Dot], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, ZeroWidthTimes -> False]}, {
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {10, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[10]], 
                    StyleBox[
                    
                    RowBox[{
                    "\"(\"", "\[NoBreak]", 
                    "\"based on 1976 US Standard Atmosphere\"", "\[NoBreak]", 
                    "\")\""}], {FontFamily -> "Verdana", FontSize -> 10, 
                    GrayLevel[0.5], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0}, StripOnInput -> False]}}, 
                  GridBoxAlignment -> {"Columns" -> {{Left}}}, AutoDelete -> 
                  False, GridBoxItemSize -> {
                   "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
                 "Grid"]}}, GridBoxAlignment -> {"Columns" -> {{Left}}}, 
              DefaultBaseStyle -> "Column", 
              GridBoxItemSize -> {"ColumnsIndexed" -> {1 -> 0}}], "Column"], 
            TraditionalForm]], "Output"]}], 
       XMLElement[
       "dataformats", {}, {
        "plaintext,computabledata,formatteddata,numberdata,quantitydata"}]}]}]\
, Typeset`pod6$$ = XMLElement[
   "pod", {"title" -> "Triple point", "scanner" -> "Data", "id" -> 
     "TriplePoint:ThermodynamicDataRP", "position" -> "600", "error" -> 
     "false", "numsubpods" -> "1"}, {
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement["cell", {"compressed" -> True, "string" -> False}, {
         Cell[
          BoxData[
           FormBox[
            StyleBox[
             TagBox[
              GridBox[{{
                 TagBox[
                  PaneBox[
                   TagBox["\"temperature\"", Identity], 
                   BaseStyle -> {{
                    BaselinePosition -> Baseline, FontColor -> 
                    GrayLevel[0.3]}, LineSpacing -> {0.9, 0, 1.5}, 
                    LinebreakAdjustments -> {1, 10, 10000, 0, 100}, 
                    TextAlignment -> Left}, BaselinePosition -> Baseline], 
                  $CellContext`TagBoxWrapper["Label"]], 
                 TagBox[
                  GridBox[{{
                    StyleBox[
                    TagBox[
                    RowBox[{
                    TagBox[
                    TagBox[
                    RowBox[{
                    TagBox["83.81", 
                    $CellContext`TagBoxWrapper["StringBoxes" -> "83.81"]], 
                    "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    "\"K\"", FontFamily -> "Helvetica", FontSize -> 
                    Smaller]}], Identity], #& , SyntaxForm -> Dot], "  ", 
                    StyleBox[
                    
                    RowBox[{
                    "\"(\"", "\[NoBreak]", "\"kelvins\"", "\[NoBreak]", 
                    "\")\""}], {
                    FontFamily :> $CellContext`$UnitFontFamily, FontSize -> 
                    Smaller, 
                    GrayLevel[0.6], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0}, StripOnInput -> False]}], "Unit", SyntaxForm -> Dot], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, ZeroWidthTimes -> False]}, {
                    StyleBox[
                    TagBox[
                    RowBox[{
                    TagBox[
                    TagBox[
                    RowBox[{
                    RowBox[{"-", 
                    TagBox["189.3", 
                    $CellContext`TagBoxWrapper["StringBoxes" -> "189.3"]]}], 
                    "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    "\"\[Degree]C\"", FontFamily -> "Helvetica", FontSize -> 
                    Smaller]}], Identity], #& , SyntaxForm -> Dot], "  ", 
                    StyleBox[
                    
                    RowBox[{
                    "\"(\"", "\[NoBreak]", "\"degrees Celsius\"", 
                    "\[NoBreak]", "\")\""}], {
                    FontFamily :> $CellContext`$UnitFontFamily, FontSize -> 
                    Smaller, 
                    GrayLevel[0.6], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0}, StripOnInput -> False]}], "Unit", SyntaxForm -> Dot], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, ZeroWidthTimes -> False]}}, 
                   GridBoxAlignment -> {"Columns" -> {{Left}}}, 
                   DefaultBaseStyle -> "Column", 
                   GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
                  "Column"], "\[SpanFromLeft]"}, {
                 TagBox[
                  PaneBox[
                   TagBox["\"pressure\"", Identity], 
                   BaseStyle -> {{
                    BaselinePosition -> Baseline, FontColor -> 
                    GrayLevel[0.3]}, LineSpacing -> {0.9, 0, 1.5}, 
                    LinebreakAdjustments -> {1, 10, 10000, 0, 100}, 
                    TextAlignment -> Left}, BaselinePosition -> Baseline], 
                  $CellContext`TagBoxWrapper["Label"]], 
                 TagBox[
                  GridBox[{{
                    StyleBox[
                    TagBox[
                    RowBox[{
                    TagBox[
                    TagBox[
                    RowBox[{
                    TagBox["68\[ThinSpace]891", 
                    $CellContext`TagBoxWrapper["StringBoxes" -> "68891"]], 
                    "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    "\"Pa\"", FontFamily -> "Helvetica", FontSize -> 
                    Smaller]}], Identity], #& , SyntaxForm -> Dot], "  ", 
                    StyleBox[
                    
                    RowBox[{
                    "\"(\"", "\[NoBreak]", "\"pascals\"", "\[NoBreak]", 
                    "\")\""}], {
                    FontFamily :> $CellContext`$UnitFontFamily, FontSize -> 
                    Smaller, 
                    GrayLevel[0.6], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0}, StripOnInput -> False]}], "Unit", SyntaxForm -> Dot], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, ZeroWidthTimes -> False]}, {
                    StyleBox[
                    TagBox[
                    RowBox[{
                    TagBox[
                    TagBox[
                    RowBox[{
                    TagBox["0.6799", 
                    $CellContext`TagBoxWrapper["StringBoxes" -> "0.6799"]], 
                    "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    "\"atm\"", FontFamily -> "Helvetica", FontSize -> 
                    Smaller]}], Identity], #& , SyntaxForm -> Dot], "  ", 
                    StyleBox[
                    
                    RowBox[{
                    "\"(\"", "\[NoBreak]", "\"atmospheres\"", "\[NoBreak]", 
                    "\")\""}], {
                    FontFamily :> $CellContext`$UnitFontFamily, FontSize -> 
                    Smaller, 
                    GrayLevel[0.6], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0}, StripOnInput -> False]}], "Unit", SyntaxForm -> Dot], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, ZeroWidthTimes -> False]}}, 
                   GridBoxAlignment -> {"Columns" -> {{Left}}}, 
                   DefaultBaseStyle -> "Column", 
                   GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
                  "Column"], "\[SpanFromLeft]"}, {
                 TagBox[
                  PaneBox[
                   TagBox["\"density\"", Identity], 
                   BaseStyle -> {{
                    BaselinePosition -> Baseline, FontColor -> 
                    GrayLevel[0.3]}, LineSpacing -> {0.9, 0, 1.5}, 
                    LinebreakAdjustments -> {1, 10, 10000, 0, 100}, 
                    TextAlignment -> Left}, BaselinePosition -> Baseline], 
                  $CellContext`TagBoxWrapper["Label"]], 
                 StyleBox[
                 "\"liquid\"", LinebreakAdjustments -> {1, 100, 1, 0, 100}, 
                  LineIndent -> 0, 
                  GrayLevel[0.6], StripOnInput -> False], 
                 StyleBox[
                  TagBox[
                   RowBox[{
                    TagBox[
                    TagBox[
                    RowBox[{
                    TagBox["1416.75", 
                    $CellContext`TagBoxWrapper["StringBoxes" -> "1416.75"]], 
                    "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    
                    RowBox[{
                    "\"kg\"", "\[InvisibleSpace]", "\"/\"", 
                    "\[InvisibleSpace]", 
                    SuperscriptBox["\"m\"", "3"]}], FontFamily -> "Helvetica",
                     FontSize -> Smaller]}], Identity], #& , SyntaxForm -> 
                    Dot], "  ", 
                    StyleBox[
                    
                    RowBox[{
                    "\"(\"", "\[NoBreak]", "\"kilograms per cubic meter\"", 
                    "\[NoBreak]", "\")\""}], {
                    FontFamily :> $CellContext`$UnitFontFamily, FontSize -> 
                    Smaller, 
                    GrayLevel[0.6], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0}, StripOnInput -> False]}], "Unit", SyntaxForm -> Dot], 
                  LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                  0, ZeroWidthTimes -> False]}, {"\[SpanFromAbove]", 
                 StyleBox[
                 "\"vapor\"", LinebreakAdjustments -> {1, 100, 1, 0, 100}, 
                  LineIndent -> 0, 
                  GrayLevel[0.6], StripOnInput -> False], 
                 StyleBox[
                  TagBox[
                   RowBox[{
                    TagBox[
                    TagBox[
                    RowBox[{
                    TagBox["4.05458", 
                    $CellContext`TagBoxWrapper["StringBoxes" -> "4.05458"]], 
                    "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    
                    RowBox[{
                    "\"kg\"", "\[InvisibleSpace]", "\"/\"", 
                    "\[InvisibleSpace]", 
                    SuperscriptBox["\"m\"", "3"]}], FontFamily -> "Helvetica",
                     FontSize -> Smaller]}], Identity], #& , SyntaxForm -> 
                    Dot], "  ", 
                    StyleBox[
                    
                    RowBox[{
                    "\"(\"", "\[NoBreak]", "\"kilograms per cubic meter\"", 
                    "\[NoBreak]", "\")\""}], {
                    FontFamily :> $CellContext`$UnitFontFamily, FontSize -> 
                    Smaller, 
                    GrayLevel[0.6], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0}, StripOnInput -> False]}], "Unit", SyntaxForm -> Dot], 
                  LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                  0, ZeroWidthTimes -> False]}}, 
               GridBoxAlignment -> {
                "Columns" -> {Left, Left, Left}, "Rows" -> {{Baseline}}}, 
               AutoDelete -> False, 
               GridBoxBackground -> {"Columns" -> {None, None}}, 
               GridBoxFrame -> {"Columns" -> {{True}}, "Rows" -> {{True}}}, 
               GridBoxItemSize -> {
                "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
               GridBoxSpacings -> {"Columns" -> {{1.5}, 2}, "Rows" -> {{1}}}, 
               FrameStyle -> GrayLevel[0.84], BaselinePosition -> Automatic, 
               AllowScriptLevelChange -> False], "Grid"], 
             LineSpacing -> {0.9, 0, 1.5}, LineIndent -> 0, StripOnInput -> 
             False], TraditionalForm]], "Output"]}], 
       XMLElement[
       "dataformats", {}, {
        "plaintext,computabledata,formatteddata,numberdata,quantitydata"}]}]}]\
, Typeset`pod7$$ = XMLElement[
   "pod", {"title" -> "Phase diagram", "scanner" -> "Data", "id" -> 
     "TriplePointPhaseDiagram:ThermodynamicDataRP", "position" -> "700", 
     "error" -> "false", "numsubpods" -> "1"}, {
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement["cell", {"compressed" -> True, "string" -> False}, {
         Cell[
          BoxData[
           FormBox[
            GraphicsBox[{
              RGBColor[
              0.9921487999999999, 0.8385818666666667, 0.6927381333333333], 
              PolygonBox[CompressedData["
1:eJxF2Hk01N/7APCxZkuoVIpspc2SypLqXlmT+ggzZqwzhBRZSoRQaSFKUSRZ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               "]], 
              RGBColor[0.998154, 0.933974, 0.820264], 
              
              PolygonBox[{{34.70799139519819, -8.}, {
                34.91252718895768, -7.931618375111889}, {
                35.119487950742865`, -7.863236750223779}, {
                35.328917063246706`, -7.794855125335668}, {
                35.540858950182624`, -7.7264735004475575`}, {
                35.75535910770126, -7.658091875559446}, {
                35.97246413695107, -7.589710250671336}, {
                36.19222177783202, -7.521328625783225}, {
                36.414680943993716`, -7.452947000895115}, {
                36.63989175913207, -7.384565376007004}, {
                36.867905594640966`, -7.316183751118893}, {
                37.0987751086786, -7.247802126230782}, {
                37.332554286710696`, -7.179420501342672}, {
                37.569298483596334`, -7.111038876454561}, {
                37.809064467285246`, -7.0426572515664505`}, {
                38.05191046419911, -6.97427562667834}, {
                38.29789620637293, -6.905894001790229}, {
                38.54708298043684, -6.837512376902119}, {
                38.79953367852254, -6.769130752014007}, {
                39.055312851183345`, -6.700749127125897}, {
                39.314486762421225`, -6.632367502237786}, {
                39.57712344691951, -6.563985877349675}, {
                39.84329276958502, -6.495604252461565}, {
                40.11306648750908, -6.427222627573454}, {
                40.386518314039954`, -6.3588410026853435`}, {
                40.663723987931604`, -6.290459377797233}, {
                40.94476133961909, -6.222077752909122}, {
                41.22971036722177, -6.153696128021012}, {
                41.5186533113407, -6.085314503132901}, {
                41.81167473420561, -6.01693287824479}, {
                42.10886160219837, -5.94855125335668}, {
                42.41030337204617, -5.880169628468568}, {
                42.716092080228236`, -5.8117880035804586`}, {
                43.02632243742715, -5.743406378692347}, {
                43.341091925239034`, -5.675024753804237}, {
                43.660500899258196`, -5.606643128916126}, {
                43.98465269530023, -5.538261504028015}, {
                44.31365374092918, -5.469879879139905}, {
                44.64761367204745, -5.401498254251794}, {
                44.98664545454281, -5.333116629363683}, {
                45.33086551184171, -5.264735004475573}, {
                45.68039385814082, -5.196353379587462}, {
                46.035354237925965`, -5.127971754699351}, {
                46.395874272039705`, -5.059590129811241}, {
                46.76208561066557, -4.991208504923129}, {
                47.134124093594, -4.92282688003502}, {
                47.51212991831981, -4.854445255146908}, {
                47.8962478160144, -4.786063630258798}, {
                48.28662723643945, -4.717682005370687}, {
                48.68342254176519, -4.649300380482576}, {
                49.086793210084316`, -4.580918755594466}, {
                49.49690404912585, -4.512537130706355}, {
                49.91392542077174, -4.4441555058182445`}, {
                50.33803347701921, -4.375773880930134}, {
                50.76941040807576, -4.307392256042023}, {
                51.20824470332086, -4.239010631153912}, {
                51.65473142591951, -4.170629006265802}, {
                52.109072501928544`, -4.1022473813776905`}, {
                52.571477024795655`, -4.033865756489581}, {
                53.0421615762158, -3.9654841316014693`}, {
                53.52135056437972, -3.8971025067133587`}, {
                54.0092765807242, -3.828720881825248}, {
                54.50618077637429, -3.7603392569371374`}, {
                55.01231325956622, -3.691957632049027}, {
                55.527933515403895`, -3.623576007160916}, {
                56.05331084946308, -3.5551943822728056`}, {
                56.58872485680818, -3.486812757384695}, {
                57.134465918150845`, -3.4184311324965844`}, {
                57.69083572499793, -3.3500495076084738`}, {
                58.25814783578402, -3.281667882720363}, {
                58.83672826514298, -3.2132862578322525`}, {
                59.42691610864493, -3.144904632944141}, {
                60.02906420551456, -3.0765230080560304`}, {
                60.64353984205222, -3.00814138316792}, {
                61.27072549870421, -2.939759758279809}, {
                61.911019643975656`, -2.8713781333916986`}, {
                62.56483757864846, -2.802996508503588}, {
                63.232612334063035`, -2.7346148836154773`}, {
                63.91479562854651, -2.6662332587273667`}, {
                64.61185888642648, -2.597851633839256}, {
                65.32429432446114, -2.5294700089511455`}, {
                66.05261611094704, -2.461088384063035}, {
                66.79736160324089, -2.3927067591749243`}, {
                67.55909266995438, -2.3243251342868136`}, {
                68.33839710465976, -2.255943509398702}, {
                69.13589013858054, -2.1875618845105915`}, {
                69.95221606044987, -2.119180259622481}, {
                70.78804995249891, -2.0507986347343703`}, {
                71.64409955240707, -1.9824170098462597`}, {
                72.52110725200659, -1.914035384958149}, {
                73.41985224460542, -1.8456537600700385`}, {
                74.34115283398269, -1.7772721351819278`}, {
                75.28586891943837, -1.7088905102938172`}, {
                76.2549046727596, -1.6405088854057066`}, {
                77.2492114246207, -1.572127260517596}, {
                78.26979077978572, -1.5037456356294854`}, {
                79.3176979825564, -1.4353640107413739`}, {
                80.39404555623624, -1.3669823858532633`}, {
                81.50000724299854, -1.2986007609651526`}, {
                82.63682227348902, -1.230219136077042}, {
                83.8058, -1.1618375111205506`}, {
                83.99084518572313, -1.1525938022171536`}, {
                84.1767597458391, -1.1433500933137557`}, {
                84.36356385495256, -1.1341063844103587`}, {
                84.5512636801047, -1.1248626755069608`}, {
                84.7398654406117, -1.1156189666035639`}, {
                84.92937540853102, -1.106375257700166}, {
                85.11979990913053, -1.097131548796769}, {
                85.31114532136088, -1.0878878398933711`}, {
                85.50341807833172, -1.0786441309899741`}, {
                85.69662466779197, -1.0694004220865763`}, {
                85.89077163261193, -1.0601567131831793`}, {
                86.0858655712712, -1.0509130042797814`}, {
                86.28191313834682, -1.0416692953763844`}, {
                86.47892104500943, -1.0324255864729865`}, {
                86.67689605951715, -1.0231818775695896`}, {
                86.8758450077177, -1.0139381686661917`}, {
                87.07577477355166, -1.0046944597627947`}, {
                87.27669229955929, -0.9954507508593968}, {
                87.47860458739017, -0.9862070419559998}, {
                87.681518698318, -0.976963333052602}, {
                87.8854417537566, -0.967719624149205}, {
                88.09038093577934, -0.9584759152458071}, {
                88.29634348764387, -0.9492322063424101}, {
                88.50333671431687, -0.9399884974390122}, {
                88.71136798300378, -0.9307447885356153}, {
                88.92044472368262, -0.9215010796322174}, {
                89.13057442963725, -0.9122573707288204}, {
                89.3417646579974, -0.9030136618254225}, {
                89.55402303027874, -0.8937699529220255}, {
                89.76735723292755, -0.8845262440186277}, {
                89.98177501786766, -0.8752825351152307}, {
                90.19728420304949, -0.8660388262118328}, {
                90.41389267300114, -0.8567951173084358}, {
                90.63160837938514, -0.847551408405038}, {
                90.8504393415541, -0.838307699501641}, {
                91.07039364710936, -0.8290639905982431}, {
                91.29147945246349, -0.8198202816948461}, {
                91.51370498340428, -0.8105765727914482}, {
                91.7370785356587, -0.8013328638880513}, {
                91.96160847546244, -0.7920891549846534}, {
                92.18730324012778, -0.7828454460812564}, {
                92.41417133861542, -0.7736017371778594}, {
                92.64222135210628, -0.7643580282744615}, {
                92.87146193457643, -0.7551143193710637}, {
                93.10190181337055, -0.7458706104676667}, {
                93.33354978977944, -0.7366269015642697}, {
                93.56641473961605, -0.7273831926608718}, {
                93.80050561379367, -0.7181394837574748}, {
                94.03583143890447, -0.708895774854077}, {
                94.2724013177961, -0.69965206595068}, {
                94.51022443015258, -0.6904083570472821}, {
                94.74931003307108, -0.6811646481438851}, {
                94.98966746164082, -0.6719209392404872}, {
                95.23130612951962, -0.6626772303370903}, {
                95.4742355295113, -0.6534335214336924}, {
                95.71846523414051, -0.6441898125302954}, {
                95.96400489622653, -0.6349461036268975}, {
                96.2108642494558, -0.6257023947235005}, {
                96.45905310895184, -0.6164586858201027}, {
                96.7085813718428, -0.6072149769167057}, {
                96.95945901782667, -0.5979712680133078}, {
                97.21169610973278, -0.5887275591099108}, {
                97.46530279408012, -0.5794838502065129}, {
                97.72028930163141, -0.570240141303116}, {
                97.97666594794377, -0.5609964323997181}, {
                98.23444313391289, -0.5517527234963211}, {
                98.49363134631406, -0.5425090145929232}, {
                98.75424115833438, -0.5332653056895262}, {
                99.01628323010259, -0.5240215967861284}, {
                99.27976830920771, -0.5147778878827314}, {
                99.54470723121388, -0.5055341789793335}, {
                99.8111109201652, -0.4962904700759365}, {
                100.07899038908172`, -0.48704676117253864`}, {
                100.34835674044662`, -0.47780305226914166`}, {
                100.61922116668451`, -0.4685593433657438}, {
                100.89159495062458`, -0.4593156344623468}, {
                101.16548946595773`, -0.4500719255589489}, {
                101.44091617767772`, -0.44082821665555194`}, {
                101.71788664250836`, -0.43158450775215407`}, {
                101.99641250931926`, -0.4223407988487571}, {
                102.2765055195242, -0.4130970899453601}, {
                102.55817750746374`, -0.4038533810419622}, {
                102.8414404007703, -0.39460967213856435`}, {
                103.12630622071586`, -0.38536596323516736`}, {
                103.41278708253819`, -0.3761222543317704}, {
                103.70089519574805`, -0.3668785454283725}, {
                103.99064286441235`, -0.35763483652497463`}, {
                104.28204248740354`, -0.34839112762157765`}, {
                104.57510655868734`, -0.33914741871818066`}, {
                104.86984766744166`, -0.3299037098147828}, {
                105.16627849830782`, -0.3206600009113858}, {
                105.46441183151956`, -0.3114162920079879}, {
                105.76426054302321`, -0.30217258310459094`}, {
                106.06583760456346`, -0.29292887420119307`}, {
                106.36915608373204`, -0.2836851652977961}, {
                106.67422914396622`, -0.2744414563943982}, {
                106.98107004456625`, -0.2651977474910012}, {
                107.28969214057224`, -0.25595403858760335`}, {
                107.60010888267915`, -0.24671032968420636`}, {
                107.91233381706951`, -0.2374666207808085}, {
                108.22638058520111`, -0.2282229118774115}, {
                108.54226292354369`, -0.21897920297401363`}, {
                108.8599946632582, -0.20973549407061665`}, {
                109.17958972981812`, -0.20049178516721877`}, {
                109.50106214256611`, -0.1912480762638218}, {
                109.82442601420873`, -0.1820043673604239}, {
                110.14969555023633`, -0.17276065845702693`}, {
                110.4768850482724, -0.16351694955362905`}, {
                110.80600889734401`, -0.15427324065023207`}, {
                111.13708157706893`, -0.1450295317468342}, {
                111.47011765675623`, -0.1357858228434372}, {
                111.80513179441363`, -0.12654211394003934`}, {
                112.1421387356586, -0.11729840503664235`}, {
                112.48115331252426`, -0.10805469613324448`}, {
                112.82219044215708`, -0.09881098722984749}, {
                113.16526512540015`, -0.08956727832644962}, {
                113.51039244525099`, -0.08032356942305263}, {
                113.85758756519375`, -0.07107986051965476}, {
                114.2068657273904, -0.06183615161625777}, {
                114.55824225073243`, -0.05259244271286079}, {
                114.91173252873341`, -0.043348733809462914`}, {
                115.26735202726314`, -0.03410502490606504}, {
                115.62511628210883`, -0.024861316002668055`}, {
                115.98504089635362`, -0.01561760709927107}, {
                116.34714153756316`, -0.0063738981958731955`}, {
                116.7114339347678, 0.002869810707524678}, {117.0779338752275, 
                0.012113519610921664`}, {117.44665720096857`, 
                0.02135722851431865}, {117.81761980507504`, 
                0.030600937417716523`}, {118.1908376277242, 
                0.039844646321114396`}, {118.56632665194562`, 
                0.04908835522451138}, {118.94410289909038`, 
                0.05833206412790837}, {119.32418242399024`, 
                0.06757577303130624}, {119.70658130978738`, 
                0.07681948193470411}, {120.09131566241346`, 
                0.0860631908381011}, {120.47840160469522`, 
                0.09530689974149809}, {120.86785527005998`, 
                0.10455060864489596`}, {121.25969279581635`, 
                0.11379431754829383`}, {121.65393031597773`, 
                0.12303802645169082`}, {122.05058395359653`, 
                0.1322817353550878}, {122.44966981257525`, 
                0.14152544425848568`}, {122.85120396891317`, 
                0.15076915316188266`}, {123.25520246134765`, 
                0.16001286206528054`}, {123.6616812813435, 
                0.16925657096867752`}, {124.07065636238084`, 
                0.1785002798720754}, {124.48214356848776`, 
                0.18774398877547238`}, {124.89615868195884`, 
                0.19698769767887025`}, {125.31271739020131`, 
                0.20623140658226724`}, {125.73183527164093`, 
                0.21547511548566511`}, {126.15352778061992`, 
                0.2247188243890621}, {126.57781023121808`, 
                0.23396253329245997`}, {127.00469777991755`, 
                0.24320624219585696`}, {127.43420540703822`, 
                0.25244995109925483`}, {127.86634789685702`, 
                0.2616936600026518}, {128.30113981632977`, 
                0.2709373689060497}, {128.73859549231622`, 
                0.2801810778094467}, {129.1787289872134, 
                0.28942478671284455`}, {129.62155407288319`, 
                0.29866849561624154`}, {130.06708420274563`, 
                0.3079122045196394}, {130.5153324818963, 
                0.3171559134230364}, {130.96631163507573`, 
                0.32639962232643427`}, {131.42003397229016`, 
                0.33564333122983125`}, {131.8765113518465, 
                0.34488704013322824`}, {132.3357551405165, 
                0.3541307490366261}, {132.7977761704866, 0.363374457940024}, {
                133.2625846926909, 0.372618166843421}, {133.73019032603708`, 
                0.38186187574681796`}, {134.20060200194564`, 
                0.39110558465021583`}, {134.67382790351365`, 
                0.4003492935536137}, {135.14987539847556`, 
                0.4095930024570107}, {135.62875096498016`, 
                0.4188367113604077}, {136.11046010900722`, 
                0.42808042026380555`}, {136.59500727201333`, 
                0.4373241291672034}, {137.08239572711074`, 
                0.4465678380706004}, {137.5726274617188, 
                0.4558115469739974}, {138.06570304419176`, 
                0.46505525587739527`}, {138.56162147135086`, 
                0.47429896478079314`}, {139.06037999315362`, 
                0.4835426736841901}, {139.56197390980867`, 
                0.4927863825875871}, {140.06639633549062`, 
                0.502030091490985}, {140.57363792127995`, 
                0.5112738003943829}, {141.08368652798893`, 
                0.5205175092977798}, {141.5965268368966, 
                0.5297612182011768}, {142.11213988291723`, 
                0.5390049271045747}, {142.63050248996922`, 
                0.5482486360079717}, {143.15158658174636`, 
                0.5574923449113696}, {143.67535833187867`, 
                0.5667360538147665}, {144.20177710423735`, 
                0.5759797627181644}, {144.73079411460282`, 
                0.5852234716215614}, {145.26235071522774`, 
                0.5944671805249593}, {145.79637615679485`, 
                0.6037108894283563}, {146.33278460494654`, 
                0.6129545983317541}, {146.8714710530752, 
                0.6221983072351511}, {147.41230552184987`, 
                0.631442016138549}, {147.95512442799316`, 
                0.640685725041946}, {148.49971686641967`, 
                0.6499294339453439}, {149.04580060970423`, 
                0.6591731428487408}, {149.5929733101083, 
                0.6684168517521387}, {150.1405829400286, 
                0.6776605606555357}, {150.687, 0.6869042695589336}, {2999.997,
                 0.6869042695681769}, {2999.997, -8}}], 
              RGBColor[0.9888385333333334, 0.7798814666666667, 0.5990192], 
              
              PolygonBox[{{0., -8}, {34.70799139519819, -8.}, {
                34.91252718895768, -7.931618375111889}, {
                35.119487950742865`, -7.863236750223779}, {
                35.328917063246706`, -7.794855125335668}, {
                35.540858950182624`, -7.7264735004475575`}, {
                35.75535910770126, -7.658091875559446}, {
                35.97246413695107, -7.589710250671336}, {
                36.19222177783202, -7.521328625783225}, {
                36.414680943993716`, -7.452947000895115}, {
                36.63989175913207, -7.384565376007004}, {
                36.867905594640966`, -7.316183751118893}, {
                37.0987751086786, -7.247802126230782}, {
                37.332554286710696`, -7.179420501342672}, {
                37.569298483596334`, -7.111038876454561}, {
                37.809064467285246`, -7.0426572515664505`}, {
                38.05191046419911, -6.97427562667834}, {
                38.29789620637293, -6.905894001790229}, {
                38.54708298043684, -6.837512376902119}, {
                38.79953367852254, -6.769130752014007}, {
                39.055312851183345`, -6.700749127125897}, {
                39.314486762421225`, -6.632367502237786}, {
                39.57712344691951, -6.563985877349675}, {
                39.84329276958502, -6.495604252461565}, {
                40.11306648750908, -6.427222627573454}, {
                40.386518314039954`, -6.3588410026853435`}, {
                40.663723987931604`, -6.290459377797233}, {
                40.94476133961909, -6.222077752909122}, {
                41.22971036722177, -6.153696128021012}, {
                41.5186533113407, -6.085314503132901}, {
                41.81167473420561, -6.01693287824479}, {
                42.10886160219837, -5.94855125335668}, {
                42.41030337204617, -5.880169628468568}, {
                42.716092080228236`, -5.8117880035804586`}, {
                43.02632243742715, -5.743406378692347}, {
                43.341091925239034`, -5.675024753804237}, {
                43.660500899258196`, -5.606643128916126}, {
                43.98465269530023, -5.538261504028015}, {
                44.31365374092918, -5.469879879139905}, {
                44.64761367204745, -5.401498254251794}, {
                44.98664545454281, -5.333116629363683}, {
                45.33086551184171, -5.264735004475573}, {
                45.68039385814082, -5.196353379587462}, {
                46.035354237925965`, -5.127971754699351}, {
                46.395874272039705`, -5.059590129811241}, {
                46.76208561066557, -4.991208504923129}, {
                47.134124093594, -4.92282688003502}, {
                47.51212991831981, -4.854445255146908}, {
                47.8962478160144, -4.786063630258798}, {
                48.28662723643945, -4.717682005370687}, {
                48.68342254176519, -4.649300380482576}, {
                49.086793210084316`, -4.580918755594466}, {
                49.49690404912585, -4.512537130706355}, {
                49.91392542077174, -4.4441555058182445`}, {
                50.33803347701921, -4.375773880930134}, {
                50.76941040807576, -4.307392256042023}, {
                51.20824470332086, -4.239010631153912}, {
                51.65473142591951, -4.170629006265802}, {
                52.109072501928544`, -4.1022473813776905`}, {
                52.571477024795655`, -4.033865756489581}, {
                53.0421615762158, -3.9654841316014693`}, {
                53.52135056437972, -3.8971025067133587`}, {
                54.0092765807242, -3.828720881825248}, {
                54.50618077637429, -3.7603392569371374`}, {
                55.01231325956622, -3.691957632049027}, {
                55.527933515403895`, -3.623576007160916}, {
                56.05331084946308, -3.5551943822728056`}, {
                56.58872485680818, -3.486812757384695}, {
                57.134465918150845`, -3.4184311324965844`}, {
                57.69083572499793, -3.3500495076084738`}, {
                58.25814783578402, -3.281667882720363}, {
                58.83672826514298, -3.2132862578322525`}, {
                59.42691610864493, -3.144904632944141}, {
                60.02906420551456, -3.0765230080560304`}, {
                60.64353984205222, -3.00814138316792}, {
                61.27072549870421, -2.939759758279809}, {
                61.911019643975656`, -2.8713781333916986`}, {
                62.56483757864846, -2.802996508503588}, {
                63.232612334063035`, -2.7346148836154773`}, {
                63.91479562854651, -2.6662332587273667`}, {
                64.61185888642648, -2.597851633839256}, {
                65.32429432446114, -2.5294700089511455`}, {
                66.05261611094704, -2.461088384063035}, {
                66.79736160324089, -2.3927067591749243`}, {
                67.55909266995438, -2.3243251342868136`}, {
                68.33839710465976, -2.255943509398702}, {
                69.13589013858054, -2.1875618845105915`}, {
                69.95221606044987, -2.119180259622481}, {
                70.78804995249891, -2.0507986347343703`}, {
                71.64409955240707, -1.9824170098462597`}, {
                72.52110725200659, -1.914035384958149}, {
                73.41985224460542, -1.8456537600700385`}, {
                74.34115283398269, -1.7772721351819278`}, {
                75.28586891943837, -1.7088905102938172`}, {
                76.2549046727596, -1.6405088854057066`}, {
                77.2492114246207, -1.572127260517596}, {
                78.26979077978572, -1.5037456356294854`}, {
                79.3176979825564, -1.4353640107413739`}, {
                80.39404555623624, -1.3669823858532633`}, {
                81.50000724299854, -1.2986007609651526`}, {
                82.63682227348902, -1.230219136077042}, {
                83.8058, -1.1618375111205506`}, {
                83.80671146360098, -1.139523175758213}, {
                83.80767097594419, -1.1172088403958753`}, {
                83.80868106958854, -1.0948945050335377`}, {
                83.80974441053836, -1.0725801696712}, {
                83.81086380527056, -1.0502658343088624`}, {
                83.81204220813066, -1.0279514989465248`}, {
                83.81328272911904, -1.0056371635841872`}, {
                83.81458864208517, -0.9833228282218496}, {
                83.8159633933537, -0.961008492859512}, {
                83.81741061080334, -0.9386941574971743}, {
                83.81893411342293, -0.9163798221348367}, {
                83.82053792136963, -0.8940654867724991}, {
                83.82222626655573, -0.8717511514101624}, {
                83.824003603791, -0.8494368160478247}, {
                83.82587462251092, -0.8271224806854871}, {
                83.82784425911947, -0.8048081453231495}, {
                83.82991770998137, -0.7824938099608119}, {
                83.83210044509426, -0.7601794745984742}, {
                83.83439822247995, -0.7378651392361366}, {
                83.83681710332944, -0.715550803873799}, {
                83.83936346794195, -0.6932364685114614}, {
                83.84204403250044, -0.6709221331491237}, {
                83.84486586672524, -0.6486077977867861}, {
                83.84783641245312, -0.6262934624244485}, {
                83.85096350318896, -0.6039791270621109}, {
                83.85425538468164, -0.5816647916997733}, {
                83.85772073657549, -0.5593504563374356}, {
                83.86136869519592, -0.537036120975098}, {
                83.865208877525, -0.5147217856127604}, {
                83.86925140643142, -0.49240745025042276`}, {
                83.87350693721743, -0.47009311488808514`}, {
                83.87798668555295, -0.4477787795257475}, {
                83.8827024568671, -0.4254644441634099}, {
                83.88766667727263, -0.40315010880107227`}, {
                83.89289242610333, -0.38083577343873465`}, {
                83.89839347014585, -0.358521438076397}, {
                83.90418429965466, -0.3362071027140594}, {
                83.9102801662406, -0.31389276735172267`}, {
                83.91669712272993, -0.29157843198938416`}, {
                83.92345206509415, -0.2692640966270474}, {
                83.9305627765575, -0.2469497612647098}, {
                83.93804797399167, -0.22463542590237218`}, {
                83.94592735671682, -0.20232109054003455`}, {
                83.95422165782873, -0.18000675517769693`}, {
                83.96295269818177, -0.1576924198153593}, {
                83.97214344316303, -0.13537808445302169`}, {
                83.98181806239675, -0.11306374909068406`}, {
                83.99200199252873, -0.09074941372834644}, {
                84.00272200324522, -0.06843507836600882}, {
                84.01400626668828, -0.046120743003671194`}, {
                84.02588443043884, -0.02380640764133357}, {
                84.0383876942443, -0.0014920722789959484`}, {
                84.05154889067849, 0.020822263083341674`}, {84.06540256992854,
                 0.0431365984456793}, {84.07998508891299, 
                0.06545093380801692}, {84.0953347049451, 
                0.08776526917035454}, {84.11149167416424, 
                0.11007960453269217`}, {84.12849835496944, 
                0.1323939398950298}, {84.14639931669852, 
                0.1547082752573674}, {84.16524145380751, 
                0.17702261061970503`}, {84.18507410581638, 
                0.19933694598204177`}, {84.20594918329837, 
                0.22165128134438028`}, {84.22792130020241, 
                0.24396561670671701`}, {84.2510479128092, 
                0.2662799520690555}, {84.27538946563617, 
                0.28859428743139226`}, {84.30100954461697, 
                0.31090862279373077`}, {84.32797503789662, 
                0.3332229581560675}, {84.35635630459535, 
                0.35553729351840513`}, {84.3862273519084, 
                0.37785162888074275`}, {84.41766602092346, 
                0.4001659642430804}, {84.4507541815508, 0.422480299605418}, {
                84.48557793697746, 0.4447946349677556}, {84.5222278380679, 
                0.46710897033009324`}, {84.56079910815279, 
                0.48942330569243087`}, {84.60139187865799, 
                0.5117376410547685}, {84.64411143604373, 
                0.5340519764171061}, {84.6890684805359, 0.5563663117794437}, {
                84.73637939714894, 0.5786806471417814}, {84.7861665395103, 
                0.600994982504119}, {84.8385585270137, 0.6233093178664566}, {
                84.8936905558393, 0.6456236532287942}, {84.95170472439358, 
                0.6679379885911318}, {85.01275037373243, 
                0.6902523239534695}, {85.07698444354347, 
                0.7125666593158071}, {85.1445718442725, 0.7348809946781447}, {
                85.21568584599108, 0.7571953300404823}, {85.29050848460567, 
                0.77950966540282}, {85.36923098602033, 0.8018240007651567}, {
                85.45205420886596, 0.8241383361274952}, {85.5391891064138, 
                0.8464526714898319}, {85.63085720829145, 
                0.8687670068521705}, {85.72729112261837, 
                0.8910813422145072}, {85.82873505917362, 
                0.9133956775768457}, {85.93544537420267, 
                0.9357100129391824}, {86.04769113745873, 0.958024348301521}, {
                86.16575472206436, 0.9803386836638577}, {86.28993241775984, 
                1.0026530190261953`}, {86.42053506808601, 
                1.024967354388533}, {86.5578887320268, 1.0472816897508705`}, {
                86.702335370607, 1.0695960251132082`}, {86.85423355891027, 
                1.0919103604755458`}, {87.01395922394588, 
                1.1142246958378834`}, {87.18190640875179, 
                1.136539031200221}, {87.35848806307816, 
                1.1588533665625587`}, {87.54413686094314, 
                1.1811677019248963`}, {87.73930604530376, 
                1.203482037287234}, {87.9444703000219, 1.2257963726495715`}, {
                88.16012664924914, 1.2481107080119092`}, {88.38679538428492, 
                1.2704250433742459`}, {88.62502101789843, 
                1.2927393787365844`}, {88.87537326603164, 
                1.3150537140989211`}, {89.13844805673264, 
                1.3373680494612596`}, {89.4148685660928, 
                1.3596823848235964`}, {89.70528628089369, 
                1.381996720185935}, {90.01038208759618, 
                1.4043110555482716`}, {90.33086738724228, 
                1.4266253909106101`}, {90.66748523577279, 
                1.4489397262729469`}, {91.02101150921648, 
                1.4712540616352854`}, {91.39225609315281, 
                1.4935683969976221`}, {91.78206409582103, 
                1.5158827323599606`}, {92.19131708422152, 
                1.5381970677222974`}, {92.62093434255216, 
                1.560511403084635}, {93.07187415233095, 
                1.5828257384469726`}, {93.54513509358883, 
                1.6051400738093102`}, {94.04175736657231, 
                1.6274544091716479`}, {94.56282413347328, 
                1.6497687445339855`}, {95.10946287981552, 
                1.672083079896323}, {95.68284679526202, 
                1.6943974152586607`}, {96.28419617378145, 
                1.7167117506209983`}, {96.91477983331511, 
                1.739026085983336}, {97.57591655532646, 
                1.7613404213456736`}, {98.26897654489197, 
                1.7836547567080112`}, {98.99538291230361, 
                1.8059690920703488`}, {99.75661317750372, 
                1.8282834274326865`}, {100.55420079905512`, 
                1.850597762795024}, {101.38973672976707`, 
                1.8729120981573608`}, {102.26487100154733`, 
                1.8952264335196993`}, {103.18131434252106`, 
                1.917540768882036}, {104.14083982996418`, 
                1.9398551042443746`}, {105.1452845831084, 
                1.9621694396067113`}, {106.19655150041343`, 
                1.9844837749690498`}, {107.29661104643446`, 
                2.0067981103313866`}, {108.44750309395836`, 
                2.029112445693725}, {109.6513388276096, 2.051426781056062}, {
                110.91030271565364`, 2.0737411164184003`}, {
                112.22665455721952`, 2.096055451780737}, {113.60273161264449`,
                 2.1183697871430756`}, {115.0409508250763, 
                2.1406841225054123`}, {116.54381114187794`, 
                2.162998457867751}, {118.1138959447286, 
                2.1853127932300875`}, {119.75387559763219`, 
                2.2076271285924243`}, {121.46651012229384`, 
                2.229941463954763}, {123.25465201053218`, 
                2.2522557993171013`}, {125.1212491835466, 
                2.274570134679438}, {127.06934810795092`, 
                2.2968844700417748`}, {129.1020970785317, 
                2.3191988054041133`}, {131.22274967768627`, 
                2.341513140766452}, {133.4346684214503, 
                2.3638274761287885`}, {135.74132860193984`, 
                2.3861418114911253`}, {138.14632233591507`, 
                2.4084561468534638`}, {140.65336282903846`, 
                2.4307704822158005`}, {143.26628886524708`, 
                2.453084817578139}, {145.98906953048757`, 
                2.4753991529404757`}, {148.82580917991723`, 
                2.4977134883028143`}, {151.78075265750743`, 
                2.520027823665151}, {154.85829077686998`, 
                2.5423421590274895`}, {158.06296607200125`, 
                2.5646564943898262`}, {161.39947882658558`, 
                2.5869708297521647`}, {164.87269339043976`, 
                2.6092851651145015`}, {168.48764479171643`, 
                2.63159950047684}, {172.24954565351325`, 
                2.6539138358391767`}, {176.1637934236747, 
                2.6762281712015152`}, {180.2359779267129, 
                2.698542506563852}, {184.47188924702442`, 
                2.7208568419261887`}, {188.8775259528354, 
                2.743171177288527}, {193.45910367067233`, 
                2.7654855126508657`}, {198.2230640205395, 
                2.7877998480132025`}, {203.1760839224497, 
                2.810114183375539}, {208.32508528545893`, 
                2.8324285187378777`}, {213.67724509092633`, 
                2.854742854100216}, {219.2400058823366, 2.877057189462553}, {
                225.02108667469238`, 2.8993715248248897`}, {
                231.02849429717656`, 2.921685860187228}, {237.27053518357098`,
                 2.9440001955495667`}, {243.75582762568834`, 
                2.9663145309119034`}, {250.49331450592868`, 
                2.98862886627424}, {257.49227652593686`, 
                3.0109432016365787`}, {264.762345949246, 3.033257536998917}, {
                272.3135208767548, 3.055571872361254}, {280.1561800748349, 
                3.0778862077235907`}, {288.30109837690287`, 
                3.100200543085929}, {296.7594626803096, 3.122514878448266}, {
                305.5428885614997, 3.1448292138106027`}, {314.6634375334729, 
                3.167143549172941}, {324.13363497073635`, 
                3.1894578845352797`}, {333.96648872810255`, 
                3.2117722198976164`}, {344.1755084808982, 
                3.234086555259953}, {354.77472581538285`, 
                3.2564008906222917`}, {365.7787150994561, 3.27871522598463}, {
                377.20261516507696`, 3.301029561346967}, {0., 
                3.3010295613692815`}}], 
              RGBColor[
              0.9954590666666666, 0.8972822666666667, 0.7864570666666667], 
              PolygonBox[CompressedData["
1:eJxlknss1AEAx8XvnjuPPygudIam8som51XfGmU93K2aQqqde7m7wjmn0Urn
Fi1KYzLOLH/UeXQhr0gaNWclzKgtc2o73O1ovRRHemz+6o/PPvv8//HipR8X
2NrY2Pj94a9jbsrmrBM8uM5q6z2txn3hbXrlr/QH/3WTbihIJaZjOkJoii7L
Ad+s/9eMsaWa7Cklimz5jJEIOqzXjQcF/kpomevzW+3pcGBaP7xRZUMfUvVS
bKAhS/7xqdKggOVwaF17Cw118bKz3gcUcEodvWKrpiFuvCmjpiELwXnSZE4C
DexSc+Mj1yxwy8hsjR8NgrmE/u3Fciga7zmbVqgYZxYdHSPkqByI+hw6TMXe
6ocdV1WZ6Hr/dlhVS4VInRNIkDIx9VXeMJJJxXpBw52Q4gzYMBwK3WOoeN2Z
mDKzJQMsn/rUtM1UCB7nRw5x0oGoGHTMUzDRKekNunQR/JMGd7seCpJ6hOFa
7QUUyXKXOSUUTHMMMtOMDFq1y6TmHAULsUu9TSwZ9JrmVtNuCnI+jbJ0Iiks
bUdu7yEo+KExrjW2S+A0PCstmCSjVrffTUSXINh4LW5US0YP9XlunSAN3DV3
X488MkJ9/E55D4qhcOnaJDlGxpnzgSvNgWJUBpyY7thGBrsqvsVZI0JX7GK3
3RcSutNyO90cRXiXcuMu9wUJ5iflXiWFQqxm+yhqKkiQ97W9iiYJwbrVxzWL
SUis2HlotVAA3E8KCIskodwRQ1WOAvCffaep7UlYljYzF6r5UE+Wzo4aCPh+
GyvU+/OhXdw14NFKwDVfNmbXnwo9ebBWoiag82Z75iSnwuLJu9yZQCA+bt1i
/ckDI2ztNLGDwMZvGz/9Bt9fHrQ=
               "]], 
              RGBColor[
              0.8980593333333333, 0.8971646666666667, 0.9449146666666667], 
              PolygonBox[{}], 
              InsetBox[
               BoxData[
                FormBox[
                 StyleBox[
                 "\"gas\"", LinebreakAdjustments -> {1, 100, 1, 0, 100}, 
                  LineIndent -> 0, {FontFamily -> "Verdana", FontSize -> 10}, 
                  GrayLevel[0.5], StripOnInput -> False], TraditionalForm]], 
               Scaled[{0.7500000000000002, 0.35000000000000003`}]], 
              InsetBox[
               BoxData[
                FormBox[
                 StyleBox[
                  TagBox[
                   
                   GridBox[{{"\"supercritical\""}, {"\"region\""}}, 
                    GridBoxAlignment -> {"Columns" -> {{Center}}}, 
                    DefaultBaseStyle -> "Column", 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{0.05}}}], 
                   "Column"], LinebreakAdjustments -> {1, 100, 1, 0, 100}, 
                  LineIndent -> 0, {FontFamily -> "Verdana", FontSize -> 10}, 
                  GrayLevel[0.5], StripOnInput -> False], TraditionalForm]], 
               Scaled[{0.798688845401159, 0.8268297455968487}]], 
              InsetBox[
               BoxData[
                FormBox[
                 StyleBox[
                 "\"liquid\"", LinebreakAdjustments -> {1, 100, 1, 0, 100}, 
                  LineIndent -> 0, {FontFamily -> "Verdana", FontSize -> 10}, 
                  GrayLevel[0.5], StripOnInput -> False], TraditionalForm]], 
               Scaled[{0.23953033268101756`, 0.7310763209393352}]], 
              GrayLevel[0.3961454], 
              Thickness[0.003], 
              LineBox[CompressedData["
1:eJwdxQk8FIgewPFxDDkKmRmDoVhpXNVmV0yO/9xjXDNjGmvIoq1NOXKsl9RS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               "]], 
              InsetBox[
               BoxData[
                FormBox[
                 StyleBox[
                 "\"sublimation curve\"", 
                  LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                  0, 
                  GrayLevel[0.6], StripOnInput -> False], TraditionalForm]], 
               Scaled[{0.312583170254403, 0.20273972602739798`}]], 
              GrayLevel[0.3961454], 
              Thickness[0.003], 
              LineBox[CompressedData["
1:eJwV1nk4FdrXB3AlGSohpSuEBk1KkuFW9i7CxXUV55g5h4uSuTRIppeMXWOE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               "]], 
              InsetBox[
               BoxData[
                FormBox[
                 StyleBox[
                 "\"saturation curve\"", 
                  LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                  0, 
                  GrayLevel[0.6], StripOnInput -> False], TraditionalForm]], 
               Scaled[{0.4003913894324846, 0.5505381604696677}]], 
              GrayLevel[0.3961454], 
              Thickness[0.003], 
              LineBox[CompressedData["
1:eJwV1nk4VfkfB/CLaydLpQjZChHSNETN9yNLWpRwL1f2XZQlWzQxuTMiykSR
bqGZ4SZrZZdD9UMT2UqK7FfIci+yL7/v/HGe87ye73O+5/N+P+c55yi6BVh5
cpNIpCZ8/Hd2cpJXz56zgSM5Z3KvGs4SP0YzBouxY7roLlIDHKKm5JdL9dhv
+Kqli+kcwt1O/0sHtoAep+OEOofwO2FxgIV92ls1cbiFTahUDkYvYSenOZr+
GswmZtdJnSLzNvChMWVDagebqHLw0lfC1mGnBLiGzxDrp/6o1ceusCQNpdZN
E4EH00MssaHE36ZJcJqoKcy64IvdJPG5YdVqijCxv1oSi20ZbHpYmzFJ6B/4
bp+JPdBR8tSN9Z1wozOu1GD7HJSXv6f1nVj601CxB5udkpD8NnyCcGq46rWK
HTG/wL1eN04EFmk4y/2wARLFPVRHaJwozDusZIR9o7T1m7v1GLGd1tLohS0u
dcQ+jfGNUB6y8r2FnR7GbP6XNUqoSCQpVmArfNqGNrRGCR+7XJERbKbebyUH
IljE1/+Zm0su4LzpU8qe9SME30Lu3DHsiiXavXShEeKcZJZ2GDbQGgSarYeJ
6bEG+XzspkrdqE3GEEHVpLNGsC1lMqd0RweJhAn1PIVFG+iOFHbx0h4kgk5t
ueuM7dIT3nE/YoDYzM1py8ZuC2+Kz4jtJzyE/47/hj2gn32JS6qPiD4gMaOz
hPtYvmLtw+wl5rcH617DJlVb6bca9BB/qbHiWrHFr2rI/dzymQg4arZ3zzLO
d5TM/dC5m/hsYX08Gltno3eUZ7aLeK7SqdqHDUTpuwv0j8QXkVr+Yyt4nphb
xe1SH4i0hz77nv5nI++7+k86CN264i7pVfx8cUNkpmE7sVtkv+0tbIW4A7Ui
jFZiJM1pRWAN7yc4HPelrpnwcGZJJmC73Ew9x2S9JdJdyhcl1vH1oma7woQa
CfM79uRs7KzbiyPG2m+I9c+K9/U2bKBO4kmhhE09EaB6cVfXf1YtZddyaoiU
vskfVzdxXs2ddHvDcqK2aixdk0QB0InasUAvIVxsEyJZ2CTfGoryw1wiPElj
B5MLe5i8/MIlnTDvYnJCuLFBzPenYDtifbQ85TQP9uqQ3yWru6i86tgtbTJ2
qIYYSSoHKRk3XpHnxfuX6YZ41BejgJXqBWk+vP6sdaApvAzNpSwXKPFToK7A
32K/Vg0ihPedOyyA/YH81Xy2Du22O/rASZACWVbWW6NaXqMN7hHLFCEKxLRl
nyhgNiDbeTGjbmG8/xl2dH/sWzRUGWWqJYrd/EuZhHMzSn+gb3xvC77fyaRJ
Y4NWlNtqrCEhjj1yUaJaqB1FqyivZkpQYEDprqZNRAeKiox/abwV27Xm+BSr
E327wHNzfRueJ2vY7Q/rjyji1/yE91IUKO4Xura7vgvtOjc1W74Tzyeve79C
qxtJKhoLVctQINmR9uIc4zPiSEqofZbF8zJiWicEe1BSbVTp1t0UCOzJnYgN
70Wb7me1/BUp4CLTyivH+opkTnAUR5QpYElbUCiz6kfZVQ4//bqXAgrNWx6p
ugwgT13N3YfVKZDu91hjXmoQ/bu36Jm0JgXEhX+urGsZRGsiop8UtClwI++t
WRJ9CJFkwpIsdf/L7/iBZjiM7li7cfIOUSBinO26d3YYVdH7D+sepgD7Bn1m
ljmC+Aqnq8aOUMBHbeevhDMLWSdyRtsA99H4VChRahRFflCznDKhgJ03Srdr
GUVP3hjnwQkKtPF17tlD/4auFHE1t1hQwDzH6znHYAwN7hktTrPC/ZmuQC1n
DCn7kKKybSmgw0p6n8AcRxYNDSHTDrhPuqKDrfMEEsjg23rdDedVKR1XlvqO
imPHF5x9cL+vzcPZzd/RyVRx9s1LOK97L/ll7CR6JdKwIRiK++YOvBNvMIWO
08yofVE472MeBSpnCgVMKjiLxuL+jdIKlJjTSPlBSeWDBJx3YJ/hjNMMEtr+
HG7docBP4DzyVYiNBMW/C09k4HUxdQ0TLzbSKGcHv/iLAvn9s0F59Wx0gCUq
PpeP+ymqqRCX46DUPMPXT8sooBL9x2ZYBAe9TzUoHanDfZ2xNPvayUEeio32
f7+jAENeJslYexZRqifCOV24v+nhzicJs0gxxVe5c4gC22oLZMRHZ9GeVIt/
LWdwn0nhrmFGc+gd89bB4DUKJDoaMXsZc+h2QHcsEqKC+X7hmWNLc+hTwEWj
+p1UIK1/OPTEeh5Nv1O1I6lRoa750VWxonkUS0uT49OnQgTD53Wo0A+ktHiE
0mtOBX1/XaFezx/o8sDQT0n2VGAbrlkeq/+BXIolfJUvUqFYuCGNKbuA9uZn
S+fFUMGn53bflogFpDPoPa15lwpqT2l7QjsXEEra2FqRR4WBSGX/Hq1FpG7I
BLt6KmSdnHpmlLCIBmZOV8p8poKdTPlyLmsRUauTqaKzVNg5EQNbjJZQ0DJ3
wi8ittBWeTIuhLGE3G95ur9UtYXE+G3vvywuoV3+wvfum9iCOa1vm5H1MvIr
t7g27GYLZHXm+dzCZTQyK6Waf90W6paCHosKraDSvNizvH/bwtUmw/HLniuo
3jA9kKvRFvTTeXW+1K0g4VDh18+/28K8d2sYyK6iBO69pjqSdlCsd/9lTvgq
OtpUVnfTwA78+d3Jop2rKP6ebHuPhx2ofdI8dVlrDc1Meo7//KcdjOQs/Pk5
fg19+hhn/4Kwg6ywum7EWkNXzApo/mw7cDBL2J0D62ixK4svQpkGO6VsvEQY
6+iOtHUwx44GbSy5guDFdXTNOuafuWQaJJd+m+u22kDyPRG5Ge9oYP57iQEq
3EDfJsR+5xG0BwFK1G//CG4iSZNS29Mn7KFOxbRJ2HMT0ZJrT6cm2kPM/Bax
4LpN5EIezV/tsAdZt8l9k6IkOGpPHvlL9jysnTh3JtOQBMXNIvFFvueh+0BZ
kJUvCSxPW3kdqzoPFdK77vKmkaCjSO76b1scIJUrpqLiDQmeqzxUTfFygJDx
kR6/WRJkMA6xH71yAMv2E5vyClxwxAO1tCg5gk5loVKHBRf4BOpJnoxzBJHs
rWa/R3HBKdOAaMR2hLEbEb76T7jAKsvUosfRCZoCvyZ+7+ICDbNZvdNtTsC0
O1b8iMwNP6Jnbr467gx0yO08p8sNWyeFDwa+cQYXNZFFsgs3zD7Z4Wqi7AIg
HiRTkcQNFx9Mv1bwdgGFpY9H/aq5IfQT0TJW4AJr/Qau8uPccOXhq4WKRRfo
bsykt0vxADG1P7/QxBUqishMugkPJI2o08ZSXSE1zfedXjAPvGcfDvx9zBVC
ot9PT2TygNFXldAc5AaW3gclH7XwgOdtZ/6LGW6gczb90LlVHjhjvjm5uuQG
InrrdmR1MhQq68uHn3eHSXm3q+VUMuyM8W/neeUOTXyNmRfoZNgz3x7XpOkB
zGmN13LPyLDsVywz9cAD6F3Jo239ZEgVg7cZYp7gUftDkC7KC7R7+46vxXkC
5Njv1zPkhWDixbujvF6gcIuwnPDhhYnKVMWkOC9YC1UJeXiPF6p8I8ulxbyh
2zE+zfINL+hnnCnZxvCGCtPpKp5ZXnBw0Vop1vKB9P3WfWW7+eCQipqtcqMP
hGyv4LpgwQfVAnWRjz19wXJddo9cFB9kFhpJewtdwO/r38zbmHywyGCtPy29
AOIto36xXXwQPtOmUOjtB5MvTt3+mcwPU6YLL/MV/KGJUfxs/AA/9J3t9x8f
8AcmfXsXw5kf7Ku9DjOZF+GGf+Ty2SR++Fh+4aV2xCXwsOmX5anmB8/nMYZv
zwYAHDGBsjF+aC6nOQ7sCMTfgyfuvlICsBmb96duYiCQRLbEyZoIgDc9XIvM
GwS9c8F5rUEC8MuDgrLo60FQ0fOp5XqmAHTK3DjdTg6G9NdHOIdaBMDzG/XV
3sRgCHmavW18RQD0kyeeFu28DJYpfPoMNUEw78wPfJh3Gf8O+Z0/SxWEx2f8
nZSPheDvTds1brogXA4eqgnrD4HJk4cel5YIwhaZ1cH310OhSTfjfz79grD6
B8vMUzMMmDKbY7tEhUCkfeFhaG8Y3OD2EGk1EII+A6/xoynh4DHRpH3dRwj+
D24l5V8=
               "]], 
              InsetBox[
               BoxData[
                FormBox[
                 StyleBox[
                 "\"melting curve\"", 
                  LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                  0, 
                  GrayLevel[0.6], StripOnInput -> False], TraditionalForm]], 
               Scaled[{0.4687084148727982, 0.9151076320939342}]], 
              GrayLevel[0.257923], 
              PointSize[0.021], 
              PointBox[{150.687, 0.6869042695681769}], 
              InsetBox[
               BoxData[
                FormBox[
                 StyleBox[
                 "\"critical point\"", 
                  LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                  0, 
                  GrayLevel[0.6], StripOnInput -> False], TraditionalForm]], 
               Scaled[{0.4399217221135022, 0.6968297455968695}]], 
              GrayLevel[0.257923], 
              PointSize[0.021], 
              PointBox[{83.8058, -1.1618375111205506`}], 
              InsetBox[
               BoxData[
                FormBox[
                 StyleBox[
                 "\"triple point\"", 
                  LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                  0, 
                  GrayLevel[0.6], StripOnInput -> False], TraditionalForm]], 
               Scaled[{0.3004109589041097, 0.40590998043052906`}]], 
              GrayLevel[0.5343678000000001], 
              PointSize[0.021], 
              PointBox[{293.15, -0.9942799999999998}], 
              InsetBox[
               BoxData[
                FormBox[
                 StyleBox[
                 "\"STP\"", LinebreakAdjustments -> {1, 100, 1, 0, 100}, 
                  LineIndent -> 0, 
                  GrayLevel[0.6], StripOnInput -> False], TraditionalForm]], 
               Scaled[{0.5659197651663405, 0.47682974559686975`}]], 
              RGBColor[1, 0, 0], 
              PointSize[0.021], 
              Thickness[0.003], 
              PointBox[{{83.8058, -1.1618375111205506`}}]}, {
             GridLines -> Dynamic[
                Map[{{#, 
                   GrayLevel[0.7]}}& , 
                 MousePosition[{"Graphics", Graphics}, None]]], 
              Method -> {"GridLinesInFront" -> True}, AspectRatio -> 0.8, 
              ImageSize -> 300, 
              PlotRange -> {{-2.2250738585072014`*^-308, 
                500.0000000000001}, {-4, 3}}, Frame -> True, 
              PlotRangeClipping -> True, FrameLabel -> {
                FormBox[
                 FormBox[
                  TagBox[
                   FormBox[
                    TemplateBox[{
                    TemplateBox[{
                    StyleBox[
                    "\"temperature\"", 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, {FontFamily -> "Verdana", FontSize -> 10}, 
                    GrayLevel[0.5], StripOnInput -> False], "\"  \""}, 
                    "RowDefault"], 
                    StyleBox[
                    RowBox[{"\"(\"", "\[NoBreak]", 
                    StyleBox[
                    TagBox[
                    RowBox[{
                    StyleBox[
                    "\"K\"", FontFamily -> "Helvetica", FontSize -> 
                    Smaller]}], Identity], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, ZeroWidthTimes -> False], "\[NoBreak]", "\")\""}], {
                    FontFamily -> "Verdana", FontSize -> 10, 
                    GrayLevel[0.5], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0}, StripOnInput -> False]}, "RowDefault"], 
                    TraditionalForm], Format[#, TraditionalForm]& ], 
                  TraditionalForm], TraditionalForm], 
                FormBox[
                 FormBox[
                  TagBox[
                   FormBox[
                    TemplateBox[{
                    TemplateBox[{
                    StyleBox[
                    "\"pressure\"", 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, {FontFamily -> "Verdana", FontSize -> 10}, 
                    GrayLevel[0.5], StripOnInput -> False], "\"  \""}, 
                    "RowDefault"], 
                    StyleBox[
                    RowBox[{"\"(\"", "\[NoBreak]", 
                    StyleBox[
                    TagBox[
                    RowBox[{
                    StyleBox[
                    "\"MPa\"", FontFamily -> "Helvetica", FontSize -> 
                    Smaller]}], Identity], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, ZeroWidthTimes -> False], "\[NoBreak]", "\")\""}], {
                    FontFamily -> "Verdana", FontSize -> 10, 
                    GrayLevel[0.5], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0}, StripOnInput -> False]}, "RowDefault"], 
                    TraditionalForm], Format[#, TraditionalForm]& ], 
                  TraditionalForm], TraditionalForm]}, FrameTicks -> {{{{-4, 
                   FormBox[
                    TemplateBox[{"10", 
                    RowBox[{"-", "4"}]}, "Superscript", SyntaxForm -> 
                    SuperscriptBox], TraditionalForm]}, {-3, 
                   FormBox[
                    TemplateBox[{"10", 
                    RowBox[{"-", "3"}]}, "Superscript", SyntaxForm -> 
                    SuperscriptBox], TraditionalForm]}, {-2, 
                   FormBox[
                    TemplateBox[{"10", 
                    RowBox[{"-", "2"}]}, "Superscript", SyntaxForm -> 
                    SuperscriptBox], TraditionalForm]}, {-1, 
                   FormBox[
                    TemplateBox[{"10", 
                    RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> 
                    SuperscriptBox], TraditionalForm]}, {0, 
                   FormBox["1", TraditionalForm]}, {1, 
                   FormBox["10", TraditionalForm]}, {2, 
                   FormBox[
                    
                    TemplateBox[{"10", "2"}, "Superscript", SyntaxForm -> 
                    SuperscriptBox], TraditionalForm]}, {3, 
                   FormBox[
                    
                    TemplateBox[{"10", "3"}, "Superscript", SyntaxForm -> 
                    SuperscriptBox], TraditionalForm]}}, None}, {
                Automatic, None}}}], TraditionalForm]], "Output"]}], 
       XMLElement["dataformats", {}, {}]}], 
     XMLElement["states", {"count" -> "3"}, {
       XMLElement[
       "state", {
        "name" -> "Use Celsius", "input" -> 
         "TriplePointPhaseDiagram:ThermodynamicDataRP__Use Celsius"}, {}], 
       XMLElement[
       "state", {
        "name" -> "Use atmospheres", "input" -> 
         "TriplePointPhaseDiagram:ThermodynamicDataRP__Use atmospheres"}, {}], 
       XMLElement[
       "state", {
        "name" -> "Hide labels", "input" -> 
         "TriplePointPhaseDiagram:ThermodynamicDataRP__Hide labels"}, {}]}]}],
    Typeset`aux1$$ = {True, False, {False}, True}, Typeset`aux2$$ = {
   True, False, {False}, True}, Typeset`aux3$$ = {
   True, False, {False, False, False, False, False}, True}, Typeset`aux4$$ = {
   True, False, {False, False, False}, True}, Typeset`aux5$$ = {
   True, False, {False, False}, True}, Typeset`aux6$$ = {
   True, False, {False}, True}, Typeset`aux7$$ = {True, False, {False}, True},
    Typeset`asyncpods$$ = {}, Typeset`nonpods$$ = {
    XMLElement["sources", {"count" -> "1"}, {
      XMLElement[
      "source", {
       "url" -> 
        "http://www.wolframalpha.com/sources/\
ThermodynamicDataRPSourceInformationNotes.html", "text" -> 
        "Thermodynamic data RP"}, {}]}]}, Typeset`initdone$$ = True, 
   Typeset`queryinfo$$ = {
   "success" -> "true", "error" -> "false", "numpods" -> "7", "datatypes" -> 
    "Chemical,ThermodynamicDataRP", "timedout" -> "", "timedoutpods" -> "", 
    "timing" -> "1.75", "parsetiming" -> "0.496", "parsetimedout" -> "false", 
    "recalculate" -> "", "id" -> 
    "MSPa2729230g1g9074h11fb300001447740g94fh7gf6", "host" -> 
    "http://www4b.wolframalpha.com", "server" -> "10", "related" -> 
    "http://www4b.wolframalpha.com/api/v2/relatedQueries.jsp?id=\
MSPa2730230g1g9074h11fb300004d26gfa3a2402d35&s=10", "version" -> "2.6"}, 
   Typeset`sessioninfo$$ = {
   "TimeZone" -> 1., 
    "Date" -> {2014, 2, 6, 17, 8, 37.0798571`9.32171294001368}, "Line" -> 35, 
    "SessionID" -> 23597506324272770568}, Typeset`showpods$$ = {1, 2, 3, 4, 5,
    6, 7}, Typeset`failedpods$$ = {}, Typeset`chosen$$ = {
   "Result", "Result", 1, 1, "Output", "Quantity[68891, \"Pascals\"]"}, 
   Typeset`open$$ = True, Typeset`newq$$ = "triple point pressure of argon"}, 
   DynamicBox[ToBoxes[
     AlphaIntegration`FormatAlphaResults[
      Dynamic[{
       1, {Typeset`pod1$$, Typeset`pod2$$, Typeset`pod3$$, Typeset`pod4$$, 
         Typeset`pod5$$, Typeset`pod6$$, Typeset`pod7$$}, {
        Typeset`aux1$$, Typeset`aux2$$, Typeset`aux3$$, Typeset`aux4$$, 
         Typeset`aux5$$, Typeset`aux6$$, Typeset`aux7$$}, Typeset`chosen$$, 
        Typeset`open$$, Typeset`elements$$, Typeset`q$$, Typeset`opts$$, 
        Typeset`nonpods$$, Typeset`queryinfo$$, Typeset`sessioninfo$$, 
        Typeset`showpods$$, Typeset`failedpods$$, Typeset`newq$$}]], 
     StandardForm],
    ImageSizeCache->{560., {1298., 19.}},
    TrackedSymbols:>{Typeset`showpods$$, Typeset`failedpods$$}],
   DynamicModuleValues:>{},
   Initialization:>If[
     Not[Typeset`initdone$$], Null; WolframAlphaClient`Private`doAsyncUpdates[
       Hold[{
        Typeset`pod1$$, Typeset`pod2$$, Typeset`pod3$$, Typeset`pod4$$, 
         Typeset`pod5$$, Typeset`pod6$$, Typeset`pod7$$}], 
       Typeset`asyncpods$$, 
       Dynamic[Typeset`failedpods$$]]; Typeset`asyncpods$$ = {}; 
     Typeset`initdone$$ = True],
   SynchronousInitialization->False],
  BaseStyle->{Deployed -> True},
  DeleteWithContents->True,
  Editable->False,
  SelectWithContents->True]], "WolframAlphaShortInput",
 CellLabel->"In[18]:=",
 CellID->54389272,ExpressionUUID->"22db4d01-fa1c-4ebb-b99f-29d603a7ec86"],

Cell[BoxData[
 TemplateBox[{"68891", "\"Pa\"", "pascals", "\"Pascals\""},
  "Quantity"]], "Output",
 CellLabel->"Out[18]=",
 CellID->26131358,ExpressionUUID->"babd60de-ae4e-40c0-a525-20b67dc624c5"]
}, Open  ]],

Cell["Using ThermodynamicData package (i.e. REFPROP from NIST)", "ExampleText",
 CellID->361149294,ExpressionUUID->"80fda3e6-fa13-42bb-a334-e1ca69c8842e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UnitConvert", "[", 
  RowBox[{
   RowBox[{"ThermodynamicData", "[", 
    RowBox[{"\"\<Argon\>\"", ",", "\"\<TriplePointPressure\>\""}], "]"}], 
   ",", "\"\<Bars\>\""}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->133137483,ExpressionUUID->"ca19b138-a52f-40dc-8738-930cb9dabed3"],

Cell[BoxData[
 TemplateBox[{"0.68891`", "\"bar\"", "bars", "\"Bars\""},
  "Quantity"]], "Output",
 CellLabel->"Out[4]=",
 CellID->154853330,ExpressionUUID->"cfa9afab-f4f6-4269-9cf8-d285aeb91dd1"]
}, Open  ]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"}, 
  Closed]]]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "PrimaryExamplesSection"}, 
  Closed]]]],

Cell[BoxData[GridBox[{
   {
    DynamicBox[FEPrivate`ImportImage[
      FrontEnd`FileName[{"Documentation", "FooterIcons"}, 
       "RelatedFunction.png"]],
     ImageSizeCache->{50., {27., 33.}}], GridBox[{
      {
       StyleBox[
        RowBox[{"See", " ", "Also"}], "SeeAlsoSection"]},
      {Cell[TextData[{
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["ttr"]], "paclet:NewEoSArgon/ref/ttr", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "e330d390-b62e-4650-a30d-7aae64fa3256"],
        "\[NonBreakingSpace]",
        StyleBox[
        "\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
         "InlineSeparator"],
        " ",
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["rhotrgaz"]], "paclet:NewEoSArgon/ref/rhotrgaz", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "692b99f2-17e8-4155-8b1a-d167e4132e2e"],
        "\[NonBreakingSpace]",
        StyleBox[
        "\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
         "InlineSeparator"],
        " ",
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["rhotrliq"]], "paclet:NewEoSArgon/ref/rhotrliq", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "618cf65a-b208-415b-81fc-dfbf2a735bd5"]
       }], "SeeAlso",ExpressionUUID->"ada7aff8-8aec-4a01-bb13-d46144c1ab0d"]}
     }]}
  }]], "SeeAlsoSection",ExpressionUUID->"2fe87e5f-0718-4e39-8b27-\
f8feccda8f8e"],

Cell[BoxData[GridBox[{
   {
    DynamicBox[FEPrivate`ImportImage[
      FrontEnd`FileName[{"Documentation", "FooterIcons"}, "RelatedGuide.png"]],
     ImageSizeCache->{50., {27., 33.}}], GridBox[{
      {
       StyleBox[
        RowBox[{"Related", " ", "Guides"}], "MoreAboutSection"]},
      {
       RowBox[{"\[FilledVerySmallSquare]", Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["NewEoSArgon Package"]], 
           "paclet:NewEoSArgon/guide/NewEoSArgon"},
          "RefLinkPlain",
          BaseStyle->{"MoreAbout"}]], "MoreAbout",ExpressionUUID->
         "83800fe0-6cdc-4cb8-89e9-afaa5955a15d"]}]}
     }]}
  }]], "MoreAboutSection",ExpressionUUID->"31227842-b8aa-40bf-b604-\
b7ac5d04e977"],

Cell[BoxData[GridBox[{
   {
    TemplateBox[{29},
     "Spacer1"], GridBox[{
      {
       RowBox[{
        TemplateBox[{17},
         "Spacer1"], 
        StyleBox[
         RowBox[{"Related", " ", "Links"}], "RelatedLinksSection"]}]},
      {Cell[BoxData[Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData[
             RowBox[{
               RowBox[{"Units", " ", "&"}], " ", "Quantities"}]]], 
           "paclet:guide/Units"},
          "RefLinkPlain",
          BaseStyle->{"RelatedLinks"}]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "aa01a312-ed5d-4ec9-813c-2e2db3575e1b"]], "RelatedLinks",
        ExpressionUUID->"358fba36-3d1b-4421-aed9-015e51a7e94d"]},
      {Cell[BoxData[Cell[BoxData[Cell[BoxData[
          RowBox[{
           TemplateBox[{16},
            "Spacer1"], "\[FilledVerySmallSquare]", 
           TemplateBox[{
             Cell[
              TextData[
               Cell[
                TextData[{
                  Cell[
                   BoxData[
                    TemplateBox[{2}, "Spacer1"]]], "ThermodynamicData"}]]]], 
             "paclet:ref/ThermodynamicData"},
            "RefLink",
            BaseStyle->{"RelatedLinks"}]}]],ExpressionUUID->
          "8c4524f9-3365-49cc-bc59-c44220a1fc63"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "6a8ad685-1f83-4915-80e4-106596e6af7c"]], "RelatedLinks",
        ExpressionUUID->"82f38290-d2f1-4a16-9ba4-67442a3fd5ab"]},
      {Cell[TextData[Cell[BoxData[
        RowBox[{
         TemplateBox[{16},
          "Spacer1"], "\[FilledVerySmallSquare]", Cell[BoxData[
          TemplateBox[{
            Cell[
             TextData[
              Cell[
               TextData[{
                 Cell[
                  BoxData[
                   TemplateBox[{2}, "Spacer1"]]], 
                 "Webbook de chimie NIST"}]]]], 
            "http://webbook.nist.gov/chemistry/fluid/"},
           "WebLink",
           BaseStyle->{"RelatedLinks"}]],ExpressionUUID->
          "cf53c520-94be-4a25-a934-498d7ad6e246"]}]],ExpressionUUID->
        "c90f940c-7654-4f3e-a89d-0c778d20e748"]], "RelatedLinks",
        ExpressionUUID->"a59dc7f6-2270-4646-96c3-bd9289131f03"]}
     }]}
  }]], "RelatedLinksSection",ExpressionUUID->"c846126a-a184-4ced-9018-\
dd5a6923dda5"],

Cell[" ", "FooterCell",ExpressionUUID->"e69fb290-46fd-4279-bc5c-ca063601f406"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{900, 835.8},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ptr",
TaggingRules->{
 "ModificationHighlight" -> False, "ColorType" -> "", "LinkTrails" -> "", 
  "HasOptions" -> True, "ExampleCounter" -> 1, 
  "Openers" -> {
   "PrimaryExamplesSection" -> Open, "ExampleSection" -> {"0" -> Open}}, 
  "NewStyles" -> True, "CitationPopupData" -> $Failed, "ShowCitation" -> 
  False, "RootCaptions" -> "", 
  "Metadata" -> {
   "built" -> "{2023, 11, 30, 13, 55, 50.2088725}", 
    "history" -> {"XX", "", "", ""}, "context" -> "NewEoSArgon`", 
    "keywords" -> {}, "specialkeywords" -> {}, 
    "tutorialcollectionlinks" -> {}, "index" -> True, "label" -> 
    "New Eo S Argon Package Symbol", "language" -> "en", "paclet" -> 
    "NewEoSArgon Package", "status" -> "None", "summary" -> 
    "ptr (bar) Pression du point triple de l'argon donn\[EAcute]e par NIST \
[Triple point pressure of argon from NIST]", "synonyms" -> {}, 
    "tabletags" -> {}, "title" -> "ptr", "titlemodifier" -> "", 
    "metadescription" -> "", "windowtitle" -> "ptr", "type" -> "Symbol", 
    "uri" -> "NewEoSArgon/ref/ptr"}},
CellContext->"Global`",
FrontEndVersion->"13.3 pour Microsoft Windows (64-bit) (July 24, 2023)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "13.3 pour Microsoft Windows (64-bit) (July 24, 2023)", 
  StyleDefinitions -> "Default.nb"],
ExpressionUUID->"0caaa9be-9f24-4a8c-bd87-4a40844c147a"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7128, 188, 1420, 37, 35, "PrimaryExamplesSection",ExpressionUUID->"37ddc2a3-4643-4ab2-bd86-b9b5dfa4e03b",
   CellTags->"PrimaryExamplesSection",
   CellID->244780177]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 136304, 2760}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[575, 21, 5345, 130, 56, "AnchorBarGrid",ExpressionUUID->"11c96cab-b502-46b6-9785-44cc529cb29b",
 CellID->1],
Cell[5923, 153, 94, 0, 23, "ContextNameCell",ExpressionUUID->"2af85584-f021-4cb9-9c25-a55b75b15856"],
Cell[CellGroupData[{
Cell[6042, 157, 546, 14, 56, "ObjectNameGrid",ExpressionUUID->"2d0ab0d6-5cd6-4072-9733-3313ff97da87"],
Cell[6591, 173, 500, 10, 146, "Usage",ExpressionUUID->"b24aec3e-5417-4524-84bb-dcff0c972aae"]
}, Open  ]],
Cell[CellGroupData[{
Cell[7128, 188, 1420, 37, 35, "PrimaryExamplesSection",ExpressionUUID->"37ddc2a3-4643-4ab2-bd86-b9b5dfa4e03b",
 CellTags->"PrimaryExamplesSection",
 CellID->244780177],
Cell[CellGroupData[{
Cell[8573, 229, 1397, 36, 30, "ExampleSection",ExpressionUUID->"1c49bda3-50aa-42e8-b122-9f4e995dc81e",
 CellID->75002553],
Cell[9973, 267, 174, 3, 26, "Input",ExpressionUUID->"54168b4e-f021-4ad8-973a-d0494e2ba13b",
 CellID->87419684],
Cell[10150, 272, 139, 1, 38, "ExampleText",ExpressionUUID->"63773d97-9c0f-4721-bca7-6b488f59a18d",
 CellID->886239600],
Cell[CellGroupData[{
Cell[10314, 277, 194, 4, 26, "Input",ExpressionUUID->"1bb3af40-1cb5-474b-a356-0e3587668692",
 CellID->21488140],
Cell[10511, 283, 194, 4, 40, "Output",ExpressionUUID->"e307ab7f-966d-4bd2-9dbc-73fd3cad02e5",
 CellID->86698468]
}, Open  ]],
Cell[CellGroupData[{
Cell[10742, 292, 298, 8, 26, "Input",ExpressionUUID->"5ba5c25b-35a8-49ee-98e8-ab499f0d2897",
 CellID->204817585],
Cell[11043, 302, 224, 5, 39, "Output",ExpressionUUID->"d1e0274e-7577-4f9c-a7db-2622a6bb223c",
 CellID->413504480]
}, Open  ]],
Cell[11282, 310, 116, 1, 38, "ExampleText",ExpressionUUID->"f29d6492-6ca4-4eab-aa12-98a68c4ea3ec",
 CellID->351008126],
Cell[CellGroupData[{
Cell[11423, 315, 116848, 2227, 1334, "WolframAlphaShortInput",ExpressionUUID->"22db4d01-fa1c-4ebb-b99f-29d603a7ec86",
 CellID->54389272],
Cell[128274, 2544, 197, 4, 39, "Output",ExpressionUUID->"babd60de-ae4e-40c0-a525-20b67dc624c5",
 CellID->26131358]
}, Open  ]],
Cell[128486, 2551, 154, 1, 70, "ExampleText",ExpressionUUID->"80fda3e6-fa13-42bb-a334-e1ca69c8842e",
 CellID->361149294],
Cell[CellGroupData[{
Cell[128665, 2556, 308, 7, 70, "Input",ExpressionUUID->"ca19b138-a52f-40dc-8738-930cb9dabed3",
 CellID->133137483],
Cell[128976, 2565, 195, 4, 40, "Output",ExpressionUUID->"cfa9afab-f4f6-4269-9cf8-d285aeb91dd1",
 CellID->154853330]
}, Open  ]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"}, Closed]]]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "PrimaryExamplesSection"}, Closed]]]],
Cell[129413, 2578, 1872, 50, 70, "SeeAlsoSection",ExpressionUUID->"2fe87e5f-0718-4e39-8b27-f8feccda8f8e"],
Cell[131288, 2630, 729, 19, 70, "MoreAboutSection",ExpressionUUID->"31227842-b8aa-40bf-b604-b7ac5d04e977"],
Cell[132020, 2651, 2350, 62, 70, "RelatedLinksSection",ExpressionUUID->"c846126a-a184-4ced-9018-dd5a6923dda5"],
Cell[134373, 2715, 78, 0, 70, "FooterCell",ExpressionUUID->"e69fb290-46fd-4279-bc5c-ca063601f406"]
}
]
*)

(* End of internal cache information *)

