(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 13.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     21069,        555]
NotebookOptionsPosition[     16480,        459]
NotebookOutlinePosition[     18653,        514]
CellTagsIndexPosition[     18568,        509]
WindowTitle->ptrNv
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[GridBox[{
   {GridBox[{
      {
       ItemBox[Cell[BoxData[
         RowBox[{
          TemplateBox[{12},
           "Spacer1"], Cell["NEW EO S ARGON PACKAGE SYMBOL", "PacletNameCell",
           TextAlignment->Center,ExpressionUUID->
           "925ccd18-7956-4718-90b5-63f6f34bde2b"], 
          TemplateBox[{8},
           "Spacer1"]}]],
         TextAlignment->Center,ExpressionUUID->
         "cefbccc3-994c-4c44-8e46-5cf81f58a199"],
        Background->RGBColor[0.490196, 0.576471, 0.690196],
        ItemSize->Full], ""}
     },
     GridBoxAlignment->{"Rows" -> {{Center}}},
     GridBoxItemSize->{"Columns" -> {Full, 
         Scaled[0.02]}, "Rows" -> {{2.5}}}], Cell[TextData[{
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "See Also",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "badf788d-ffac-4835-a79c-0a32bca7308c"]
         }],ExpressionUUID->"a396b020-8ac3-46dc-b080-711309ced028"],
         StripOnInput->False],{
        "\"ttr\"" :> Documentation`HelpLookup["paclet:NewEoSArgon/ref/ttr"], 
         "\"rhotrgazNv\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/rhotrgazNv"], 
         "\"rhotrliqNv\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/rhotrliqNv"]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"SeeAlso"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "28ea3841-84e7-4da4-9429-836bbeb578f2"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "Related Guides",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "2c778aa9-20a4-47a0-a393-0a1827c0eeca"]
         }],ExpressionUUID->"0e8abda7-e624-4f1a-9808-f7d27be59303"],
         StripOnInput->False],{
        "\"NewEoSArgon Package\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/guide/NewEoSArgon"]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"MoreAbout"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "05e2d61c-412a-4768-b4bc-c8ec7348ec31"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "URL",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "4436f6bf-4b52-4c8d-ac7f-6ffe816a41df"]
         }],ExpressionUUID->"905e55db-9604-4c07-a8af-389d22635707"],
         StripOnInput->False],{
        "\"NewEoSArgon/ref/ptrNv\"" :> None, 
         "\"Copy Wolfram Documentation Center URL\"" :> 
         Module[{DocumentationSearch`Private`nb$}, 
           DocumentationSearch`Private`nb$ = 
            NotebookPut[
             Notebook[{Cell["NewEoSArgon/ref/ptrNv"]}, Visible -> False]]; 
           SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
           FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
           NotebookClose[DocumentationSearch`Private`nb$]; Null], Delimiter, 
         "\"Copy web URL\"" :> 
         Module[{DocumentationSearch`Private`nb$}, 
           DocumentationSearch`Private`nb$ = 
            NotebookPut[
             Notebook[{
               Cell[BoxData[
                 MakeBoxes[
                  Hyperlink[
                   "http://reference.wolfram.com/language/NewEoSArgon/ref/\
ptrNv.html"], StandardForm]], "Input", TextClipboardType -> "PlainText"]}, 
               Visible -> False]]; 
           SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
           FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
           NotebookClose[DocumentationSearch`Private`nb$]; Null], 
         "\"Go to web URL\"" :> 
         FrontEndExecute[{
           NotebookLocate[{
             URL[If[TrueQ[DocumentationBuild`Make`Private`wsmlinkQ$21098], 
                 "http://reference.wolfram.com/system-modeler/", 
                 "http://reference.wolfram.com/language/"] <> 
               "NewEoSArgon/ref/ptrNv" <> ".html"], None}]}]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"URLMenu"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "9c7a03e1-47dc-44e5-9a40-ed0f987b9022"]
    }], "AnchorBar",
     CacheGraphics->False,ExpressionUUID->
     "6148ceaa-4370-4757-ae37-fdef7fe0f38a"]}
  }]], "AnchorBarGrid",
 CellID->1,ExpressionUUID->"0d306a37-8171-4440-bb43-3611522e8b81"],

Cell["NewEoSArgon`", "ContextNameCell",ExpressionUUID->"1d3444e6-0a4e-4926-9862-b93193b0992b"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     Cell[
     "ptrNv", "ObjectName",ExpressionUUID->
      "9e22d086-42cd-4dfd-a376-0f66a8bf78d9"],
     Cell[BoxData[
      TemplateBox[{8},
       "Spacer1"]],ExpressionUUID->"f873b516-5084-4bc5-894c-854b3f25291a"],
     Cell[BoxData[
     ""], "ObjectNameTranslation",ExpressionUUID->
      "ed04da46-d927-4580-9365-4535ae6f44d1"]
    }],ExpressionUUID->"e43d0025-946e-4330-b4e2-bd46220b8ec1"], 
    "\[SpanFromLeft]"}
  }]], "ObjectNameGrid",ExpressionUUID->"5608c861-3dee-46f7-a378-\
fe241f923c43"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["ptrNv"], "InlineFormula",
      ShowStringCharacters->False,
      FontFamily->"Source Sans Pro",ExpressionUUID->
      "5f06383d-6f5d-4b60-9045-8cb4241d2200"],
     " (MPa)\nPression du point triple de l'argon d\[EAcute]duite des \
relations de Maxwell \n[Triple point pressure of argon from Maxwell relations]"
    }],ExpressionUUID->"53632bec-c66b-477c-83fb-8e6891c9788e"]}
  }]], "Usage",
 Deletable->True,ExpressionUUID->"0160c21d-37f2-47c9-9ba7-cb3c0580492a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {
       TaggingRules, "Openers", "PrimaryExamplesSection"}, Open], 
      Alternatives[True, Open]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{13.600000000000001`, {5., 8.600000000000001}}]],
  ExpressionUUID->"be9f32b6-b8eb-458f-825a-737a7a3b516d"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"c541b6bc-3ebc-49a1-b2f8-a6cddf7af5d2"],
 "Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "6da2652c-cf2c-45bb-ac1e-a9400decd6fa"]
}], "PrimaryExamplesSection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellTags->"PrimaryExamplesSection",
 CellID->211945210,ExpressionUUID->"c1cad2af-ea73-4229-b48e-b753eef56b85"],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"},
        Closed], 
      Alternatives[Open, True]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{13.600000000000001`, {5., 8.600000000000001}}]],
  ExpressionUUID->"f11e32f5-bf1e-48a2-93b7-09ace6105350"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"ed6fc250-a391-43d3-a33d-e40c78536618"],
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "863e8d93-6756-485f-960e-668c14f310dc"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellID->674490704,ExpressionUUID->"acac72b3-b4a9-4ff1-81e2-e7b98b9747f3"],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<NewEoSArgon`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->87419684,ExpressionUUID->"30f5667a-aa0e-40d1-8786-60a28af9a88c"],

Cell["Give a physical dimension to the constant", "ExampleText",
 CellID->886239600,ExpressionUUID->"a82d49df-8047-41de-9622-c6f5e27f0e23"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Quantity", "[", 
  RowBox[{"ptrNv", ",", "\"\<MPa\>\""}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->21488140,ExpressionUUID->"fad2fb4a-3f60-4ba5-9a3c-6e1933e85ff1"],

Cell[BoxData[
 TemplateBox[{
  "0.06896569762291979`", "\"MPa\"", "megapascals", "\"Megapascals\""},
  "Quantity"]], "Output",
 CellLabel->"Out[2]=",
 CellID->148952135,ExpressionUUID->"6e6f5517-c355-41b4-b379-91df263d2b29"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UnitConvert", "[", 
  RowBox[{
   TemplateBox[{"0.06896569762291979`"},
    "QuantityUnit",
    DisplayFunction->(TooltipBox[
      StyleBox[
       RowBox[{#, "\[InvisibleSpace]", 
         StyleBox[
          RowBox[{" ", "\"MPa\""}], "QuantityUnitTraditionalLabel"]}], 
       ShowStringCharacters -> False], "Unit: megapascals"]& ),
    InterpretationFunction->(RowBox[{"Quantity", "[", 
       RowBox[{#, ",", "\"Megapascals\""}], "]"}]& )], ",", "\"\<Bars\>\""}], 
  "]"}]], "Input",
 NumberMarks->False,
 CellLabel->"In[3]:=",
 CellID->227516567,ExpressionUUID->"c5f3d43e-ab26-467d-9b90-f6d77e98e7df"],

Cell[BoxData[
 TemplateBox[{"0.689656976229198`", "\"bar\"", "bars", "\"Bars\""},
  "Quantity"]], "Output",
 CellLabel->"Out[3]=",
 CellID->11943587,ExpressionUUID->"0f0204e2-ad6f-413c-a11b-a8d6f3d22ea8"]
}, Open  ]],

Cell["Relative error with NIST constant", "ExampleText",
 CellID->32289193,ExpressionUUID->"eec91c77-da69-46c8-b1bc-b531d69c965b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Quantity", "[", 
  RowBox[{
   RowBox[{"100", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"ptr", "-", 
       RowBox[{"ptrNv", "*", "10"}]}], ")"}], "/", "ptr"}]}], ",", 
   "\"\<%\>\""}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->91147354,ExpressionUUID->"a2dca434-fec3-4b7b-bfb9-f125852866b0"],

Cell[BoxData[
 TemplateBox[{
   RowBox[{"-", "0.10842871045534956`"}]},
  "QuantityUnit",
  DisplayFunction->(TooltipBox[
    StyleBox[
     RowBox[{#, "\[InvisibleSpace]", 
       StyleBox[
        RowBox[{" ", 
          RowBox[{"\"%\""}]}], "QuantityUnitTraditionalLabel"]}], 
     ShowStringCharacters -> False], "Unit: percent"]& ),
  InterpretationFunction->(RowBox[{"Quantity", "[", 
     RowBox[{#, ",", "\"Percent\""}], "]"}]& )]], "Output",
 CellLabel->"Out[4]=",
 CellID->13390846,ExpressionUUID->"946aeb7f-fc17-4bd0-9d1c-8a6f0e41cf56"]
}, Open  ]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"}, 
  Closed]]]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "PrimaryExamplesSection"}, 
  Closed]]]],

Cell[BoxData[GridBox[{
   {
    DynamicBox[FEPrivate`ImportImage[
      FrontEnd`FileName[{"Documentation", "FooterIcons"}, 
       "RelatedFunction.png"]],
     ImageSizeCache->{50., {27., 33.}}], GridBox[{
      {
       StyleBox[
        RowBox[{"See", " ", "Also"}], "SeeAlsoSection"]},
      {Cell[TextData[{
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["ttr"]], "paclet:NewEoSArgon/ref/ttr", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "922cbae5-74e3-4d17-9875-2152ddae50e7"],
        "\[NonBreakingSpace]",
        StyleBox[
        "\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
         "InlineSeparator"],
        " ",
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["rhotrgazNv"]], "paclet:NewEoSArgon/ref/rhotrgazNv", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "8e2d9bce-3659-43d5-9940-9c415ca9dc4e"],
        "\[NonBreakingSpace]",
        StyleBox[
        "\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
         "InlineSeparator"],
        " ",
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["rhotrliqNv"]], "paclet:NewEoSArgon/ref/rhotrliqNv", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "dc438eda-b354-4046-976a-fde1d49dc14b"]
       }], "SeeAlso",ExpressionUUID->"15560bb6-cd43-4a6b-9518-45744645e78b"]}
     }]}
  }]], "SeeAlsoSection",ExpressionUUID->"80a78ea9-139c-49d9-b2d1-\
06dce6a01e5a"],

Cell[BoxData[GridBox[{
   {
    DynamicBox[FEPrivate`ImportImage[
      FrontEnd`FileName[{"Documentation", "FooterIcons"}, "RelatedGuide.png"]],
     ImageSizeCache->{50., {27., 33.}}], GridBox[{
      {
       StyleBox[
        RowBox[{"Related", " ", "Guides"}], "MoreAboutSection"]},
      {
       RowBox[{"\[FilledVerySmallSquare]", Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["NewEoSArgon Package"]], 
           "paclet:NewEoSArgon/guide/NewEoSArgon"},
          "RefLinkPlain",
          BaseStyle->{"MoreAbout"}]], "MoreAbout",ExpressionUUID->
         "835ca054-7fa2-4fbb-9b67-33bc96c21a7b"]}]}
     }]}
  }]], "MoreAboutSection",ExpressionUUID->"1b81ae8d-44fc-4039-a436-\
7290c13c4f90"],

Cell[BoxData[GridBox[{
   {
    TemplateBox[{29},
     "Spacer1"], GridBox[{
      {
       RowBox[{
        TemplateBox[{17},
         "Spacer1"], 
        StyleBox[
         RowBox[{"Related", " ", "Links"}], "RelatedLinksSection"]}]},
      {Cell[BoxData[Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData[
             RowBox[{
               RowBox[{"Units", " ", "&"}], " ", "Quantities"}]]], 
           "paclet:guide/Units"},
          "RefLinkPlain",
          BaseStyle->{"RelatedLinks"}]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "937d0810-a835-4318-a1cc-a09c37c1c64d"]], "RelatedLinks",
        ExpressionUUID->"ee9bc9b4-cb3c-4bec-9997-599b0278140e"]}
     }]}
  }]], "RelatedLinksSection",ExpressionUUID->"76d44913-c43c-4da9-9995-\
cc3e45e7de7a"],

Cell[" ", "FooterCell",ExpressionUUID->"f04c99b2-eb6b-4946-a66f-44ea287f6249"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{900, 835.8},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ptrNv",
TaggingRules->{
 "ModificationHighlight" -> False, "ColorType" -> "", "LinkTrails" -> "", 
  "HasOptions" -> True, "ExampleCounter" -> 1, 
  "Openers" -> {
   "PrimaryExamplesSection" -> Open, "ExampleSection" -> {"0" -> Open}}, 
  "NewStyles" -> True, "CitationPopupData" -> $Failed, "ShowCitation" -> 
  False, "RootCaptions" -> "", 
  "Metadata" -> {
   "built" -> "{2023, 11, 30, 13, 55, 51.2248357}", 
    "history" -> {"XX", "", "", ""}, "context" -> "NewEoSArgon`", 
    "keywords" -> {}, "specialkeywords" -> {}, 
    "tutorialcollectionlinks" -> {}, "index" -> True, "label" -> 
    "New Eo S Argon Package Symbol", "language" -> "en", "paclet" -> 
    "NewEoSArgon Package", "status" -> "None", "summary" -> 
    "ptrNv (MPa) Pression du point triple de l'argon d\[EAcute]duite des \
relations de Maxwell [Triple point pressure of argon from Maxwell relations]",
     "synonyms" -> {}, "tabletags" -> {}, "title" -> "ptrNv", "titlemodifier" -> 
    "", "metadescription" -> "", "windowtitle" -> "ptrNv", "type" -> "Symbol",
     "uri" -> "NewEoSArgon/ref/ptrNv"}},
CellContext->"Global`",
FrontEndVersion->"13.3 pour Microsoft Windows (64-bit) (July 24, 2023)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "13.3 pour Microsoft Windows (64-bit) (July 24, 2023)", 
  StyleDefinitions -> "Default.nb"],
ExpressionUUID->"3b36748e-b59d-4630-9018-b9125425d4dc"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7179, 188, 1420, 37, 35, "PrimaryExamplesSection",ExpressionUUID->"c1cad2af-ea73-4229-b48e-b753eef56b85",
   CellTags->"PrimaryExamplesSection",
   CellID->211945210]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 18369, 502}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[577, 21, 5361, 130, 56, "AnchorBarGrid",ExpressionUUID->"0d306a37-8171-4440-bb43-3611522e8b81",
 CellID->1],
Cell[5941, 153, 94, 0, 23, "ContextNameCell",ExpressionUUID->"1d3444e6-0a4e-4926-9862-b93193b0992b"],
Cell[CellGroupData[{
Cell[6060, 157, 548, 14, 56, "ObjectNameGrid",ExpressionUUID->"5608c861-3dee-46f7-a378-fe241f923c43"],
Cell[6611, 173, 531, 10, 146, "Usage",ExpressionUUID->"0160c21d-37f2-47c9-9ba7-cb3c0580492a"]
}, Open  ]],
Cell[CellGroupData[{
Cell[7179, 188, 1420, 37, 35, "PrimaryExamplesSection",ExpressionUUID->"c1cad2af-ea73-4229-b48e-b753eef56b85",
 CellTags->"PrimaryExamplesSection",
 CellID->211945210],
Cell[CellGroupData[{
Cell[8624, 229, 1398, 36, 30, "ExampleSection",ExpressionUUID->"acac72b3-b4a9-4ff1-81e2-e7b98b9747f3",
 CellID->674490704],
Cell[10025, 267, 174, 3, 26, "Input",ExpressionUUID->"30f5667a-aa0e-40d1-8786-60a28af9a88c",
 CellID->87419684],
Cell[10202, 272, 139, 1, 38, "ExampleText",ExpressionUUID->"a82d49df-8047-41de-9622-c6f5e27f0e23",
 CellID->886239600],
Cell[CellGroupData[{
Cell[10366, 277, 195, 4, 26, "Input",ExpressionUUID->"fad2fb4a-3f60-4ba5-9a3c-6e1933e85ff1",
 CellID->21488140],
Cell[10564, 283, 224, 5, 39, "Output",ExpressionUUID->"6e6f5517-c355-41b4-b379-91df263d2b29",
 CellID->148952135]
}, Open  ]],
Cell[CellGroupData[{
Cell[10825, 293, 632, 16, 26, "Input",ExpressionUUID->"c5f3d43e-ab26-467d-9b90-f6d77e98e7df",
 CellID->227516567],
Cell[11460, 311, 204, 4, 40, "Output",ExpressionUUID->"0f0204e2-ad6f-413c-a11b-a8d6f3d22ea8",
 CellID->11943587]
}, Open  ]],
Cell[11679, 318, 130, 1, 38, "ExampleText",ExpressionUUID->"eec91c77-da69-46c8-b1bc-b531d69c965b",
 CellID->32289193],
Cell[CellGroupData[{
Cell[11834, 323, 329, 10, 26, "Input",ExpressionUUID->"a2dca434-fec3-4b7b-bfb9-f125852866b0",
 CellID->91147354],
Cell[12166, 335, 547, 14, 35, "Output",ExpressionUUID->"946aeb7f-fc17-4bd0-9d1c-8a6f0e41cf56",
 CellID->13390846]
}, Open  ]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"}, Closed]]]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "PrimaryExamplesSection"}, Closed]]]],
Cell[12955, 358, 1880, 50, 114, "SeeAlsoSection",ExpressionUUID->"80a78ea9-139c-49d9-b2d1-06dce6a01e5a"],
Cell[14838, 410, 729, 19, 114, "MoreAboutSection",ExpressionUUID->"1b81ae8d-44fc-4039-a436-7290c13c4f90"],
Cell[15570, 431, 825, 24, 101, "RelatedLinksSection",ExpressionUUID->"76d44913-c43c-4da9-9995-cc3e45e7de7a"],
Cell[16398, 457, 78, 0, 70, "FooterCell",ExpressionUUID->"f04c99b2-eb6b-4946-a66f-44ea287f6249"]
}
]
*)

(* End of internal cache information *)

