(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 13.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     23367,        613]
NotebookOptionsPosition[     18354,        508]
NotebookOutlinePosition[     20575,        564]
CellTagsIndexPosition[     20490,        559]
WindowTitle->rhocNv [\:03C1cNv]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[GridBox[{
   {GridBox[{
      {
       ItemBox[Cell[BoxData[
         RowBox[{
          TemplateBox[{12},
           "Spacer1"], Cell["NEW EO S ARGON PACKAGE SYMBOL", "PacletNameCell",
           TextAlignment->Center,ExpressionUUID->
           "a805e1a1-a3ee-458e-8d56-12b97e7aed3b"], 
          TemplateBox[{8},
           "Spacer1"]}]],
         TextAlignment->Center,ExpressionUUID->
         "b934b02c-f958-455b-8e17-b993265f5b6a"],
        Background->RGBColor[0.490196, 0.576471, 0.690196],
        ItemSize->Full], ""}
     },
     GridBoxAlignment->{"Rows" -> {{Center}}},
     GridBoxItemSize->{"Columns" -> {Full, 
         Scaled[0.02]}, "Rows" -> {{2.5}}}], Cell[TextData[{
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "See Also",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "71e0d1e0-9657-43f0-82d2-a257ce98508b"]
         }],ExpressionUUID->"758bdcba-9ab9-4868-9fd4-8b7dc0261dff"],
         StripOnInput->False],{
        "\"rhoc\"" :> Documentation`HelpLookup["paclet:NewEoSArgon/ref/rhoc"],
          "\"pcNv\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/pcNv"], "\"tcNv\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/tcNv"], "\"M\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/M"]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"SeeAlso"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "ecceb4b5-942c-4330-a167-16cee287d7a2"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "Related Guides",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "041bb4f3-3d6e-4da4-97d5-72c257a83d64"]
         }],ExpressionUUID->"449bcbe4-72d9-4713-9ded-58c0f7907933"],
         StripOnInput->False],{
        "\"NewEoSArgon Package\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/guide/NewEoSArgon"]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"MoreAbout"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "fe931778-e2cc-48ed-83f3-63d6121d250e"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "URL",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "d2778025-d8ba-40ee-ae91-88029f9eff3f"]
         }],ExpressionUUID->"67b64618-657c-4b98-8dda-bdeca807cf25"],
         StripOnInput->False],{
        "\"NewEoSArgon/ref/rhocNv\"" :> None, 
         "\"Copy Wolfram Documentation Center URL\"" :> 
         Module[{DocumentationSearch`Private`nb$}, 
           DocumentationSearch`Private`nb$ = 
            NotebookPut[
             Notebook[{Cell["NewEoSArgon/ref/rhocNv"]}, Visible -> False]]; 
           SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
           FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
           NotebookClose[DocumentationSearch`Private`nb$]; Null], Delimiter, 
         "\"Copy web URL\"" :> 
         Module[{DocumentationSearch`Private`nb$}, 
           DocumentationSearch`Private`nb$ = 
            NotebookPut[
             Notebook[{
               Cell[BoxData[
                 MakeBoxes[
                  Hyperlink[
                   "http://reference.wolfram.com/language/NewEoSArgon/ref/\
rhocNv.html"], StandardForm]], "Input", TextClipboardType -> "PlainText"]}, 
               Visible -> False]]; 
           SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
           FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
           NotebookClose[DocumentationSearch`Private`nb$]; Null], 
         "\"Go to web URL\"" :> 
         FrontEndExecute[{
           NotebookLocate[{
             URL[If[TrueQ[DocumentationBuild`Make`Private`wsmlinkQ$23764], 
                 "http://reference.wolfram.com/system-modeler/", 
                 "http://reference.wolfram.com/language/"] <> 
               "NewEoSArgon/ref/rhocNv" <> ".html"], None}]}]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"URLMenu"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "f68190fb-1297-45e1-8e80-f4550a2bed3c"]
    }], "AnchorBar",
     CacheGraphics->False,ExpressionUUID->
     "e1c99d03-d272-4220-b7a3-866b2e765a78"]}
  }]], "AnchorBarGrid",
 CellID->1,ExpressionUUID->"75ff88c8-470a-420c-88c8-2118bf2d26dd"],

Cell["NewEoSArgon`", "ContextNameCell",ExpressionUUID->"18396a8f-113f-446d-9190-0bd436714e7e"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     Cell[
     "rhocNv [\[Rho]cNv]", "ObjectName",ExpressionUUID->
      "0d0c1ada-0b81-42a1-bfb6-470dc5d43ab0"],
     Cell[BoxData[
      TemplateBox[{8},
       "Spacer1"]],ExpressionUUID->"8e5dff75-d881-4f69-8713-c7b33842cd6d"],
     Cell[BoxData[
     ""], "ObjectNameTranslation",ExpressionUUID->
      "1a4a1507-c058-4e0e-8ff5-ecee3c79dc2c"]
    }],ExpressionUUID->"745fbb01-b816-4a3f-9c9e-c3740912e829"], 
    "\[SpanFromLeft]"}
  }]], "ObjectNameGrid",ExpressionUUID->"446d1a55-7c87-4515-b374-\
27eb01e39bb7"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["rhocNv"], "InlineFormula",
      ShowStringCharacters->False,
      FontFamily->"Source Sans Pro",ExpressionUUID->
      "2544aa87-98ea-4b07-91ba-a9343be8bfcb"],
     " (g/",
     Cell[BoxData[
      SuperscriptBox["cm", "3"]], "InlineFormula",
      FontFamily->"Source Sans Pro",ExpressionUUID->
      "6818209b-7435-4f10-ab96-4b31b9cc2af6"],
     ")\nDensit\[EAcute] du point critique de l'argon d\[EAcute]duite des \
relations de Maxwell\n[Critical density of argon from Maxwell relations]"
    }],ExpressionUUID->"cc1c443d-6669-4bd4-9bda-e0af45e387da"]}
  }]], "Usage",
 Deletable->True,ExpressionUUID->"a8a90742-b095-4785-ad25-c005a33132de"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {
       TaggingRules, "Openers", "PrimaryExamplesSection"}, Open], 
      Alternatives[True, Open]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{13.600000000000001`, {5., 8.600000000000001}}]],
  ExpressionUUID->"3bb7bc04-e6d7-4073-b0da-af71cdea70e5"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"252cabef-fce2-4b52-8563-6920427bf93c"],
 "Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "fd5a8f67-407f-4eab-894f-af9b264a1679"]
}], "PrimaryExamplesSection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellTags->"PrimaryExamplesSection",
 CellID->1782189,ExpressionUUID->"6df018dd-3702-45e9-acc5-816d56b9b00d"],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"},
        Closed], 
      Alternatives[Open, True]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{13.600000000000001`, {5., 8.600000000000001}}]],
  ExpressionUUID->"4191a5a4-a0ea-4a70-a0a4-a57ea1030758"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"ee288ea6-798d-4ce7-94fe-4ec54b5b01b7"],
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "16527045-fee4-46c1-9528-5046b9385b88"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellID->353420945,ExpressionUUID->"4934ff1c-f53c-4d64-9628-c272aaa42463"],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<NewEoSArgon`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->87419684,ExpressionUUID->"fe64dc5d-4dd3-4a34-a335-78413904eb81"],

Cell["Give a physical dimension to the constant", "ExampleText",
 CellID->886239600,ExpressionUUID->"c20becba-a0c4-49bb-b9fe-3702e418f8d2"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Quantity", "[", 
  RowBox[{"\[Rho]cNv", ",", "\"\<g/cm^3\>\""}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->21488140,ExpressionUUID->"90daa03f-a633-4fb2-b5e5-e19247886a2b"],

Cell[BoxData[
 TemplateBox[{"0.5437860867`", 
   RowBox[{"\"g\"", "\[InvisibleSpace]", "\"/\"", "\[InvisibleSpace]", 
     SuperscriptBox["\"cm\"", "3"]}], "grams per centimeter cubed", 
   FractionBox["\"Grams\"", 
    SuperscriptBox["\"Centimeters\"", "3"]]},
  "Quantity"]], "Output",
 CellLabel->"Out[2]=",
 CellID->224254855,ExpressionUUID->"8b1b2b59-65ba-4d02-be70-99bff32583f2"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UnitConvert", "[", 
  RowBox[{
   TemplateBox[{"0.5437860867`"},
    "QuantityUnit",
    DisplayFunction->(TooltipBox[
      StyleBox[
       RowBox[{#, "\[InvisibleSpace]", 
         StyleBox[
          RowBox[{" ", 
            
            RowBox[{"\"g\"", "\[InvisibleSpace]", "\"/\"", 
              "\[InvisibleSpace]", 
              SuperscriptBox["\"cm\"", "3"]}]}], 
          "QuantityUnitTraditionalLabel"]}], ShowStringCharacters -> False], 
      "Unit: grams per centimeter cubed"]& ),
    InterpretationFunction->(RowBox[{"Quantity", "[", 
       RowBox[{#, ",", 
         FractionBox["\"Grams\"", 
          SuperscriptBox["\"Centimeters\"", "3"]]}], "]"}]& )], ",", 
   "\"\<kg/m^3\>\""}], "]"}]], "Input",
 NumberMarks->False,
 CellLabel->"In[3]:=",
 CellID->191277971,ExpressionUUID->"094ba670-3575-432a-bbdd-0615a45d1244"],

Cell[BoxData[
 TemplateBox[{"543.7860866999999`", 
   RowBox[{"\"kg\"", "\[InvisibleSpace]", "\"/\"", "\[InvisibleSpace]", 
     SuperscriptBox["\"m\"", "3"]}], "kilograms per meter cubed", 
   FractionBox["\"Kilograms\"", 
    SuperscriptBox["\"Meters\"", "3"]]},
  "Quantity"]], "Output",
 CellLabel->"Out[3]=",
 CellID->13285204,ExpressionUUID->"8b5a96d5-52f6-412f-88ee-9db867e01c69"]
}, Open  ]],

Cell["Relative error with NIST constant", "ExampleText",
 CellID->32289193,ExpressionUUID->"748e0e29-bbad-4f9c-b476-18b41e8427cc"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Quantity", "[", 
  RowBox[{
   RowBox[{"100", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"\[Rho]c", "-", "\[Rho]cNv"}], ")"}], "/", "\[Rho]c"}]}], ",", 
   "\"\<%\>\""}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->91147354,ExpressionUUID->"145e2b74-9534-4431-8058-25f938763a4a"],

Cell[BoxData[
 TemplateBox[{
   RowBox[{"-", "1.5285851355211457`"}], "\"%\"", "percent", "\"Percent\""},
  "QuantityPostfix"]], "Output",
 CellLabel->"Out[4]=",
 CellID->666250124,ExpressionUUID->"9ae255f9-c6e4-4080-8488-2a4b828535f6"]
}, Open  ]],

Cell["Molar volume corresponding to \[Rho]cNv", "ExampleText",
 CellID->222855593,ExpressionUUID->"f1515e73-d95a-4a73-97fa-4b4cccc6b8f5"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Quantity", "[", 
   RowBox[{"M", ",", "\"\<g/mol\>\""}], "]"}], "/", 
  RowBox[{"Quantity", "[", 
   RowBox[{"\[Rho]cNv", ",", "\"\<g/cm^3\>\""}], "]"}]}]], "Input",
 CellLabel->"In[5]:=",
 CellID->295872759,ExpressionUUID->"b98b32df-048f-40c7-afb5-859e890c8b2f"],

Cell[BoxData[
 TemplateBox[{"73.46271075530261`", 
   RowBox[{
     SuperscriptBox["\"cm\"", "3"], "\[NegativeMediumSpace]", "\"/\"", 
     "\[InvisibleSpace]", "\"mol\""}], "centimeters cubed per mole", 
   FractionBox[
    SuperscriptBox["\"Centimeters\"", "3"], "\"Moles\""]},
  "Quantity"]], "Output",
 CellLabel->"Out[5]=",
 CellID->13187280,ExpressionUUID->"4a1913a0-e648-4afd-9cd0-f1859eb367a5"]
}, Open  ]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"}, 
  Closed]]]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "PrimaryExamplesSection"}, 
  Closed]]]],

Cell[BoxData[GridBox[{
   {
    DynamicBox[FEPrivate`ImportImage[
      FrontEnd`FileName[{"Documentation", "FooterIcons"}, 
       "RelatedFunction.png"]],
     ImageSizeCache->{50., {27., 33.}}], GridBox[{
      {
       StyleBox[
        RowBox[{"See", " ", "Also"}], "SeeAlsoSection"]},
      {Cell[TextData[{
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["rhoc"]], "paclet:NewEoSArgon/ref/rhoc", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "45924072-8fa4-4087-9119-bc3c22abe387"],
        "\[NonBreakingSpace]",
        StyleBox[
        "\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
         "InlineSeparator"],
        " ",
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["pcNv"]], "paclet:NewEoSArgon/ref/pcNv", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "9ea216a7-e6d1-40cb-826c-997173cbd3f5"],
        "\[NonBreakingSpace]",
        StyleBox[
        "\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
         "InlineSeparator"],
        " ",
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["tcNv"]], "paclet:NewEoSArgon/ref/tcNv", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "98f9f367-099a-4e0d-b2a6-6c7b2a862665"],
        "\[NonBreakingSpace]",
        StyleBox[
        "\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
         "InlineSeparator"],
        " ",
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["M"]], "paclet:NewEoSArgon/ref/M", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "fbc884af-4493-4242-8d57-22a308772b41"]
       }], "SeeAlso",ExpressionUUID->"be32d3fc-4c6e-468c-82a0-483d882f4c90"]}
     }]}
  }]], "SeeAlsoSection",ExpressionUUID->"d0e6b2ea-22a8-4965-bb12-\
327149a5fcbe"],

Cell[BoxData[GridBox[{
   {
    DynamicBox[FEPrivate`ImportImage[
      FrontEnd`FileName[{"Documentation", "FooterIcons"}, "RelatedGuide.png"]],
     ImageSizeCache->{50., {27., 33.}}], GridBox[{
      {
       StyleBox[
        RowBox[{"Related", " ", "Guides"}], "MoreAboutSection"]},
      {
       RowBox[{"\[FilledVerySmallSquare]", Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["NewEoSArgon Package"]], 
           "paclet:NewEoSArgon/guide/NewEoSArgon"},
          "RefLinkPlain",
          BaseStyle->{"MoreAbout"}]], "MoreAbout",ExpressionUUID->
         "e9faff0a-83b6-4768-870e-df1e1b599193"]}]}
     }]}
  }]], "MoreAboutSection",ExpressionUUID->"74ae061b-6f2a-41ec-8775-\
c26136fec802"],

Cell[BoxData[GridBox[{
   {
    TemplateBox[{29},
     "Spacer1"], GridBox[{
      {
       RowBox[{
        TemplateBox[{17},
         "Spacer1"], 
        StyleBox[
         RowBox[{"Related", " ", "Links"}], "RelatedLinksSection"]}]},
      {Cell[BoxData[Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData[
             RowBox[{
               RowBox[{"Units", " ", "&"}], " ", "Quantities"}]]], 
           "paclet:guide/Units"},
          "RefLinkPlain",
          BaseStyle->{"RelatedLinks"}]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "87225369-03e4-4fcc-8d1b-e9264e111fc4"]], "RelatedLinks",
        ExpressionUUID->"912f454d-a65d-4d41-8782-b347b838bbf6"]}
     }]}
  }]], "RelatedLinksSection",ExpressionUUID->"d16d2ef5-ba3e-41f5-8035-\
f6f02fa4f0d5"],

Cell[" ", "FooterCell",ExpressionUUID->"5ba2e1d0-adc0-4cea-abdb-bba658818d04"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{900, 835.8},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"rhocNv [\[Rho]cNv]",
TaggingRules->{
 "ModificationHighlight" -> False, "ColorType" -> "", "LinkTrails" -> "", 
  "HasOptions" -> True, "ExampleCounter" -> 1, 
  "Openers" -> {
   "PrimaryExamplesSection" -> Open, "ExampleSection" -> {"0" -> Open}}, 
  "NewStyles" -> True, "CitationPopupData" -> $Failed, "ShowCitation" -> 
  False, "RootCaptions" -> "", 
  "Metadata" -> {
   "built" -> "{2023, 11, 30, 13, 55, 57.9722378}", 
    "history" -> {"XX", "", "", ""}, "context" -> "NewEoSArgon`", 
    "keywords" -> {}, "specialkeywords" -> {}, 
    "tutorialcollectionlinks" -> {}, "index" -> True, "label" -> 
    "New Eo S Argon Package Symbol", "language" -> "en", "paclet" -> 
    "NewEoSArgon Package", "status" -> "None", "summary" -> 
    "rhocNv (g/cm^3) Densit\[EAcute] du point critique de l'argon \
d\[EAcute]duite des relations de Maxwell [Critical density of argon from \
Maxwell relations]", "synonyms" -> {}, "tabletags" -> {}, "title" -> 
    "rhocNv [\[Rho]cNv]", "titlemodifier" -> "", "metadescription" -> "", 
    "windowtitle" -> "rhocNv [\[Rho]cNv]", "type" -> "Symbol", "uri" -> 
    "NewEoSArgon/ref/rhocNv"}},
CellContext->"Global`",
FrontEndVersion->"13.3 pour Microsoft Windows (64-bit) (July 24, 2023)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "13.3 pour Microsoft Windows (64-bit) (July 24, 2023)", 
  StyleDefinitions -> "Default.nb"],
ExpressionUUID->"af5dfad1-197b-49dc-a9dc-3b7507cffbdf"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7434, 193, 1418, 37, 35, "PrimaryExamplesSection",ExpressionUUID->"6df018dd-3702-45e9-acc5-816d56b9b00d",
   CellTags->"PrimaryExamplesSection",
   CellID->1782189]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 20293, 552}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[590, 21, 5408, 130, 56, "AnchorBarGrid",ExpressionUUID->"75ff88c8-470a-420c-88c8-2118bf2d26dd",
 CellID->1],
Cell[6001, 153, 94, 0, 23, "ContextNameCell",ExpressionUUID->"18396a8f-113f-446d-9190-0bd436714e7e"],
Cell[CellGroupData[{
Cell[6120, 157, 561, 14, 56, "ObjectNameGrid",ExpressionUUID->"446d1a55-7c87-4515-b374-27eb01e39bb7"],
Cell[6684, 173, 713, 15, 146, "Usage",ExpressionUUID->"a8a90742-b095-4785-ad25-c005a33132de"]
}, Open  ]],
Cell[CellGroupData[{
Cell[7434, 193, 1418, 37, 35, "PrimaryExamplesSection",ExpressionUUID->"6df018dd-3702-45e9-acc5-816d56b9b00d",
 CellTags->"PrimaryExamplesSection",
 CellID->1782189],
Cell[CellGroupData[{
Cell[8877, 234, 1398, 36, 30, "ExampleSection",ExpressionUUID->"4934ff1c-f53c-4d64-9628-c272aaa42463",
 CellID->353420945],
Cell[10278, 272, 174, 3, 26, "Input",ExpressionUUID->"fe64dc5d-4dd3-4a34-a335-78413904eb81",
 CellID->87419684],
Cell[10455, 277, 139, 1, 38, "ExampleText",ExpressionUUID->"c20becba-a0c4-49bb-b9fe-3702e418f8d2",
 CellID->886239600],
Cell[CellGroupData[{
Cell[10619, 282, 202, 4, 26, "Input",ExpressionUUID->"90daa03f-a633-4fb2-b5e5-e19247886a2b",
 CellID->21488140],
Cell[10824, 288, 385, 8, 45, "Output",ExpressionUUID->"8b1b2b59-65ba-4d02-be70-99bff32583f2",
 CellID->224254855]
}, Open  ]],
Cell[CellGroupData[{
Cell[11246, 301, 867, 23, 30, "Input",ExpressionUUID->"094ba670-3575-432a-bbdd-0615a45d1244",
 CellID->191277971],
Cell[12116, 326, 387, 8, 45, "Output",ExpressionUUID->"8b5a96d5-52f6-412f-88ee-9db867e01c69",
 CellID->13285204]
}, Open  ]],
Cell[12518, 337, 130, 1, 38, "ExampleText",ExpressionUUID->"748e0e29-bbad-4f9c-b476-18b41e8427cc",
 CellID->32289193],
Cell[CellGroupData[{
Cell[12673, 342, 312, 9, 26, "Input",ExpressionUUID->"145e2b74-9534-4431-8058-25f938763a4a",
 CellID->91147354],
Cell[12988, 353, 236, 5, 40, "Output",ExpressionUUID->"9ae255f9-c6e4-4080-8488-2a4b828535f6",
 CellID->666250124]
}, Open  ]],
Cell[13239, 361, 137, 1, 38, "ExampleText",ExpressionUUID->"f1515e73-d95a-4a73-97fa-4b4cccc6b8f5",
 CellID->222855593],
Cell[CellGroupData[{
Cell[13401, 366, 298, 7, 26, "Input",ExpressionUUID->"b98b32df-048f-40c7-afb5-859e890c8b2f",
 CellID->295872759],
Cell[13702, 375, 402, 9, 43, "Output",ExpressionUUID->"4a1913a0-e648-4afd-9cd0-f1859eb367a5",
 CellID->13187280]
}, Open  ]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"}, Closed]]]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "PrimaryExamplesSection"}, Closed]]]],
Cell[14346, 393, 2363, 64, 114, "SeeAlsoSection",ExpressionUUID->"d0e6b2ea-22a8-4965-bb12-327149a5fcbe"],
Cell[16712, 459, 729, 19, 70, "MoreAboutSection",ExpressionUUID->"74ae061b-6f2a-41ec-8775-c26136fec802"],
Cell[17444, 480, 825, 24, 70, "RelatedLinksSection",ExpressionUUID->"d16d2ef5-ba3e-41f5-8035-f6f02fa4f0d5"],
Cell[18272, 506, 78, 0, 70, "FooterCell",ExpressionUUID->"5ba2e1d0-adc0-4cea-abdb-bba658818d04"]
}
]
*)

(* End of internal cache information *)

