(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 13.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     26614,        693]
NotebookOptionsPosition[     21309,        585]
NotebookOutlinePosition[     23565,        641]
CellTagsIndexPosition[     23480,        636]
WindowTitle->rhomaxRonc [\:03C1maxRonc]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[GridBox[{
   {GridBox[{
      {
       ItemBox[Cell[BoxData[
         RowBox[{
          TemplateBox[{12},
           "Spacer1"], Cell["NEW EO S ARGON PACKAGE SYMBOL", "PacletNameCell",
           TextAlignment->Center,ExpressionUUID->
           "1b4f957d-a41c-41ff-a31b-74565b0d6de8"], 
          TemplateBox[{8},
           "Spacer1"]}]],
         TextAlignment->Center,ExpressionUUID->
         "8837359d-1e7e-467f-bf50-e8ed8c4dad13"],
        Background->RGBColor[0.490196, 0.576471, 0.690196],
        ItemSize->Full], ""}
     },
     GridBoxAlignment->{"Rows" -> {{Center}}},
     GridBoxItemSize->{"Columns" -> {Full, 
         Scaled[0.02]}, "Rows" -> {{2.5}}}], Cell[TextData[{
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "See Also",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "4da543af-bb4d-496e-82dc-4fba71425402"]
         }],ExpressionUUID->"c8d61d69-b654-4bcb-a630-cfbd03d0ad3f"],
         StripOnInput->False],{
        "\"rhotrgaz\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/rhotrgaz"], 
         "\"rhoc\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/rhoc"], 
         "\"rhotrliq\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/rhotrliq"], "\"M\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/M"]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"SeeAlso"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "74da5473-9626-459c-9db9-f671b3d59775"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "Related Guides",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "2e50445e-4e43-49e2-86f6-48f54de23661"]
         }],ExpressionUUID->"ac9b05eb-d045-4021-98bd-cf904b9ef488"],
         StripOnInput->False],{
        "\"NewEoSArgon Package\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/guide/NewEoSArgon"]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"MoreAbout"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "8870dcc1-164c-462c-a19d-a7a57ca29d55"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "URL",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "71c155ea-c593-45d4-ae92-2ed29cf43e44"]
         }],ExpressionUUID->"d13e8b06-f707-4638-8f64-be6470117a75"],
         StripOnInput->False],{
        "\"NewEoSArgon/ref/rhomaxRonc\"" :> None, 
         "\"Copy Wolfram Documentation Center URL\"" :> 
         Module[{DocumentationSearch`Private`nb$}, 
           DocumentationSearch`Private`nb$ = 
            NotebookPut[
             Notebook[{Cell["NewEoSArgon/ref/rhomaxRonc"]}, Visible -> 
               False]]; 
           SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
           FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
           NotebookClose[DocumentationSearch`Private`nb$]; Null], Delimiter, 
         "\"Copy web URL\"" :> 
         Module[{DocumentationSearch`Private`nb$}, 
           DocumentationSearch`Private`nb$ = 
            NotebookPut[
             Notebook[{
               Cell[BoxData[
                 MakeBoxes[
                  Hyperlink[
                   "http://reference.wolfram.com/language/NewEoSArgon/ref/\
rhomaxRonc.html"], StandardForm]], "Input", TextClipboardType -> 
                 "PlainText"]}, Visible -> False]]; 
           SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
           FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
           NotebookClose[DocumentationSearch`Private`nb$]; Null], 
         "\"Go to web URL\"" :> 
         FrontEndExecute[{
           NotebookLocate[{
             URL[If[TrueQ[DocumentationBuild`Make`Private`wsmlinkQ$24269], 
                 "http://reference.wolfram.com/system-modeler/", 
                 "http://reference.wolfram.com/language/"] <> 
               "NewEoSArgon/ref/rhomaxRonc" <> ".html"], None}]}]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"URLMenu"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "292d3412-a3f8-4e89-b44f-60852bcb66e7"]
    }], "AnchorBar",
     CacheGraphics->False,ExpressionUUID->
     "b9375f4e-83c1-4fca-81ab-9204ce26b204"]}
  }]], "AnchorBarGrid",
 CellID->1,ExpressionUUID->"e8ccdd8e-29d8-4035-919d-3d858d3ed85d"],

Cell["NewEoSArgon`", "ContextNameCell",ExpressionUUID->"f01362c8-58fd-45dc-8c36-50db402bcf02"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     Cell[
     "rhomaxRonc [\[Rho]maxRonc]", "ObjectName",ExpressionUUID->
      "43e4d01f-515d-49d4-b5e4-0a4be8118f23"],
     Cell[BoxData[
      TemplateBox[{8},
       "Spacer1"]],ExpressionUUID->"26866379-b23c-4508-8a68-3b5ef3ad96bc"],
     Cell[BoxData[
     ""], "ObjectNameTranslation",ExpressionUUID->
      "b1a9244b-5947-4adb-8a9d-6304f7bc04d8"]
    }],ExpressionUUID->"09a2df7f-3b3a-4f28-ac71-b00b1f40f9f4"], 
    "\[SpanFromLeft]"}
  }]], "ObjectNameGrid",ExpressionUUID->"fe5ea887-2628-4e6f-bc7b-\
3760c02987a7"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["rhomaxRonc"], "InlineFormula",
      ShowStringCharacters->False,
      FontFamily->"Source Sans Pro",ExpressionUUID->
      "54bfc1d9-58b5-47ec-a8f6-15dab33104df"],
     " (g/",
     Cell[BoxData[
      SuperscriptBox["cm", "3"]], "InlineFormula",
      FontFamily->"Source Sans Pro",ExpressionUUID->
      "daeff972-1a33-4671-aa37-17b035631e03"],
     ")\nDensit\[EAcute] maximum des data de Ronchi relatives \[AGrave] \
l'argon\n[Maximum density of Ronchi's data]"
    }],ExpressionUUID->"1ae21537-ef06-43f3-847d-a208eb5c7a9e"]}
  }]], "Usage",
 Deletable->True,ExpressionUUID->"d11bb985-bc3b-4779-a896-93a0b174904c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[Cell[TextData[{
   Cell[BoxData[
    DynamicBox[ToBoxes[
      If[
       MatchQ[
        CurrentValue[
         EvaluationNotebook[], {TaggingRules, "Openers", "NotesSection"}, 
         Closed], 
        Alternatives[Open, True]], 
       Style[
        Graphics[{
          Thickness[0.18], 
          RGBColor[0.8509803921568627, 0.396078431372549, 0], 
          Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
         PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
        0.68 Inherited], 
       Rotate[
        Style[
         Graphics[{
           Thickness[0.18], 
           RGBColor[0.8509803921568627, 0.396078431372549, 0], 
           Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
          PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
         0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
     ImageSizeCache->{
      13.600000000000001`, {0.5800000000000001, 13.020000000000001`}}]],
    ExpressionUUID->"a9158880-ab1d-4561-886f-94b62178661d"],
   Cell[BoxData[
    TemplateBox[{1},
     "Spacer1"]],ExpressionUUID->"d7693b12-75f0-409a-b65a-5237a3c4004c"],
   "Details and Options"
  }], "NotesFrameText",ExpressionUUID->"2861f7dd-2b1b-407d-9c7d-59fc4a4435ce"],
  Appearance->{Automatic, None, "Normal", Automatic},
  BaseStyle->None,
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"], 
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], After, CellContents]}]& ),
  Evaluator->None,
  Method->
   "Preemptive"]],ExpressionUUID->"0632988e-d912-41b3-a299-7cd1135837bd"]], \
"NotesSection",
 WholeCellGroupOpener->True,
 CellGroupingRules->{"SectionGrouping", 50},
 CacheGraphics->False,
 CellID->81149809,ExpressionUUID->"db50620f-9de8-42f2-b383-9862eba12bc5"],

Cell[TextData[{
 Cell[BoxData[
  SubscriptBox["\[Rho]", 
   RowBox[{"max", ",", "Ronc"}]]], "InlineFormula",
  FontFamily->"Source Sans Pro",ExpressionUUID->
  "d7eff328-f762-4b52-8424-92c6dd96e223"],
 " = \[Rho]maxRonc repr\[EAcute]sente \[EAcute]galement la densit\[EAcute] \
maximum pour laquelle le mod\[EGrave]le est coh\[EAcute]rent et valide.\n",
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["C. Ronchi, J. Nucl. Mater. 96, 314 (1981)"]], 
    "http://dx.doi.org/10.1016/0022-3115(81)90575-4"},
   "WebLink",
   BaseStyle->{"Notes"}]],ExpressionUUID->
  "9f188f1e-0e6b-4561-bda7-268f1bffb930"]
}], "Notes",
 CellID->1067943069,ExpressionUUID->"6b6d4247-dbf5-41cb-b3aa-752ba2fe221d"],

Cell["\<\
******************************************************************************\
*****\
\>", "Notes",
 CellID->185021568,ExpressionUUID->"4af8b179-6c34-4605-8b61-817cbdb6c257"],

Cell[TextData[{
 Cell[BoxData[
  SubscriptBox["\[Rho]", 
   RowBox[{"max", ",", "Ronc"}]]], "InlineFormula",
  FontFamily->"Source Sans Pro",ExpressionUUID->
  "d49f475b-f088-4918-a333-e24843211060"],
 " = \[Rho]maxRonc also represents the maximum density for which the model is \
consistent and valid.\n",
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["C. Ronchi, J. Nucl. Mater. 96, 314 (1981)"]], 
    "http://dx.doi.org/10.1016/0022-3115(81)90575-4"},
   "WebLink",
   BaseStyle->{"Notes"}]],ExpressionUUID->
  "a35edd6c-9de6-4b56-919c-2d313df7950d"]
}], "Notes",
 CellID->140761484,ExpressionUUID->"98fe97c3-bc2f-4e5a-b166-4efaa7336412"]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "NotesSection"}, Closed]]]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {
       TaggingRules, "Openers", "PrimaryExamplesSection"}, Open], 
      Alternatives[True, Open]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{13.600000000000001`, {5., 8.600000000000001}}]],
  ExpressionUUID->"37f72ca8-f7b8-4c7e-bd22-5720d5e9f8ee"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"f8ab991a-ab56-42d0-9483-fb84154ab786"],
 "Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "04430053-b817-492e-a30f-251004a56cc4"]
}], "PrimaryExamplesSection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellTags->"PrimaryExamplesSection",
 CellID->940864403,ExpressionUUID->"1e736797-96d4-4a9e-a5aa-831253fa40b2"],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"},
        Closed], 
      Alternatives[Open, True]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{13.600000000000001`, {5., 8.600000000000001}}]],
  ExpressionUUID->"d7910189-3393-4e3a-9c93-fb67aae246f5"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"efe628fc-6bf6-4ebb-8fa6-07db52941320"],
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "fdd442fb-ac1a-45a6-a2e9-164e77af8941"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellID->361979321,ExpressionUUID->"d2d0d839-9bd8-43ce-b90f-bb9927c7d433"],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<NewEoSArgon`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->87419684,ExpressionUUID->"fc3a7434-d739-4af0-9966-b20c79c9f3ec"],

Cell["Give a physical dimension to the constant", "ExampleText",
 CellID->886239600,ExpressionUUID->"da6813d0-fb9a-4b12-9275-2940fdbf4a45"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Quantity", "[", 
  RowBox[{"\[Rho]maxRonc", ",", "\"\<g/cm^3\>\""}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->21488140,ExpressionUUID->"449a50a2-ddb1-4300-8bd3-dca6a12831ef"],

Cell[BoxData[
 TemplateBox[{"3.356974789915966`", 
   RowBox[{"\"g\"", "\[InvisibleSpace]", "\"/\"", "\[InvisibleSpace]", 
     SuperscriptBox["\"cm\"", "3"]}], "grams per centimeter cubed", 
   FractionBox["\"Grams\"", 
    SuperscriptBox["\"Centimeters\"", "3"]]},
  "Quantity"]], "Output",
 CellLabel->"Out[2]=",
 CellID->14941933,ExpressionUUID->"691cc23e-ce20-4c61-856c-69bfc95b84b8"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UnitConvert", "[", 
  RowBox[{
   TemplateBox[{"3.356974789915966`"},
    "QuantityUnit",
    DisplayFunction->(TooltipBox[
      StyleBox[
       RowBox[{#, "\[InvisibleSpace]", 
         StyleBox[
          RowBox[{" ", 
            
            RowBox[{"\"g\"", "\[InvisibleSpace]", "\"/\"", 
              "\[InvisibleSpace]", 
              SuperscriptBox["\"cm\"", "3"]}]}], 
          "QuantityUnitTraditionalLabel"]}], ShowStringCharacters -> False], 
      "Unit: grams per centimeter cubed"]& ),
    InterpretationFunction->(RowBox[{"Quantity", "[", 
       RowBox[{#, ",", 
         FractionBox["\"Grams\"", 
          SuperscriptBox["\"Centimeters\"", "3"]]}], "]"}]& )], ",", 
   "\"\<kg/m^3\>\""}], "]"}]], "Input",
 NumberMarks->False,
 CellLabel->"In[3]:=",
 CellID->301596363,ExpressionUUID->"8b538c01-5fb6-48cb-a845-e11d0b933012"],

Cell[BoxData[
 TemplateBox[{"3356.974789915966`", 
   RowBox[{"\"kg\"", "\[InvisibleSpace]", "\"/\"", "\[InvisibleSpace]", 
     SuperscriptBox["\"m\"", "3"]}], "kilograms per meter cubed", 
   FractionBox["\"Kilograms\"", 
    SuperscriptBox["\"Meters\"", "3"]]},
  "Quantity"]], "Output",
 CellLabel->"Out[3]=",
 CellID->829937645,ExpressionUUID->"234d17eb-5412-41a3-af16-4baba179107c"]
}, Open  ]],

Cell["Molar volume corresponding to \[Rho]maxRonc", "ExampleText",
 CellID->222855593,ExpressionUUID->"f8614ab0-43f0-4c40-972d-71f2aafe4ea8"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Quantity", "[", 
   RowBox[{"M", ",", "\"\<g/mol\>\""}], "]"}], "/", 
  RowBox[{"Quantity", "[", 
   RowBox[{"\[Rho]maxRonc", ",", "\"\<g/cm^3\>\""}], "]"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->295872759,ExpressionUUID->"37c301bb-21f3-4135-9e9a-d0babac7466c"],

Cell[BoxData[
 TemplateBox[{"11.9`", 
   RowBox[{
     SuperscriptBox["\"cm\"", "3"], "\[NegativeMediumSpace]", "\"/\"", 
     "\[InvisibleSpace]", "\"mol\""}], "centimeters cubed per mole", 
   FractionBox[
    SuperscriptBox["\"Centimeters\"", "3"], "\"Moles\""]},
  "Quantity"]], "Output",
 CellLabel->"Out[4]=",
 CellID->240530017,ExpressionUUID->"94180fc8-d912-48d9-bf7d-5978240d3b07"]
}, Open  ]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"}, 
  Closed]]]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "PrimaryExamplesSection"}, 
  Closed]]]],

Cell[BoxData[GridBox[{
   {
    DynamicBox[FEPrivate`ImportImage[
      FrontEnd`FileName[{"Documentation", "FooterIcons"}, 
       "RelatedFunction.png"]],
     ImageSizeCache->{50., {27., 33.}}], GridBox[{
      {
       StyleBox[
        RowBox[{"See", " ", "Also"}], "SeeAlsoSection"]},
      {Cell[TextData[{
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["rhotrgaz"]], "paclet:NewEoSArgon/ref/rhotrgaz", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "8b7f0df9-10d6-4ea8-bebf-5a084d29fb1b"],
        "\[NonBreakingSpace]",
        StyleBox[
        "\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
         "InlineSeparator"],
        " ",
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["rhoc"]], "paclet:NewEoSArgon/ref/rhoc", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "0754fde9-4a8e-42f2-83f3-8a65a83f1594"],
        "\[NonBreakingSpace]",
        StyleBox[
        "\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
         "InlineSeparator"],
        " ",
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["rhotrliq"]], "paclet:NewEoSArgon/ref/rhotrliq", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "c4b8282f-9afe-4771-b245-9d9b0af97a1a"],
        "\[NonBreakingSpace]",
        StyleBox[
        "\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
         "InlineSeparator"],
        " ",
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["M"]], "paclet:NewEoSArgon/ref/M", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "694e0041-e4ef-43b8-a019-cb3b6a445fd9"]
       }], "SeeAlso",ExpressionUUID->"e6ca21a0-519c-4a98-afb2-299d705ae9e6"]}
     }]}
  }]], "SeeAlsoSection",ExpressionUUID->"ddf29fe5-f5d5-4173-88e4-\
8860cfcb1f09"],

Cell[BoxData[GridBox[{
   {
    DynamicBox[FEPrivate`ImportImage[
      FrontEnd`FileName[{"Documentation", "FooterIcons"}, "RelatedGuide.png"]],
     ImageSizeCache->{50., {27., 33.}}], GridBox[{
      {
       StyleBox[
        RowBox[{"Related", " ", "Guides"}], "MoreAboutSection"]},
      {
       RowBox[{"\[FilledVerySmallSquare]", Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["NewEoSArgon Package"]], 
           "paclet:NewEoSArgon/guide/NewEoSArgon"},
          "RefLinkPlain",
          BaseStyle->{"MoreAbout"}]], "MoreAbout",ExpressionUUID->
         "aa3d7cc3-c0ce-4198-b8e2-332a02927e7d"]}]}
     }]}
  }]], "MoreAboutSection",ExpressionUUID->"175dac8f-38ba-4c0a-b2bf-\
ed9dccfe2aaa"],

Cell[BoxData[GridBox[{
   {
    TemplateBox[{29},
     "Spacer1"], GridBox[{
      {
       RowBox[{
        TemplateBox[{17},
         "Spacer1"], 
        StyleBox[
         RowBox[{"Related", " ", "Links"}], "RelatedLinksSection"]}]},
      {Cell[BoxData[Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData[
             RowBox[{
               RowBox[{"Units", " ", "&"}], " ", "Quantities"}]]], 
           "paclet:guide/Units"},
          "RefLinkPlain",
          BaseStyle->{"RelatedLinks"}]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "13595384-ef5a-4201-baa6-761da8fb1edf"]], "RelatedLinks",
        ExpressionUUID->"1847073f-82ba-4876-8baa-e3b4b8b943e4"]}
     }]}
  }]], "RelatedLinksSection",ExpressionUUID->"352c902a-a467-419a-998e-\
ee152210e913"],

Cell[" ", "FooterCell",ExpressionUUID->"3dab6c67-e0cb-4d07-a9ea-68cbfcb62647"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{900, 835.8},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"rhomaxRonc [\[Rho]maxRonc]",
TaggingRules->{
 "ModificationHighlight" -> False, "ColorType" -> "", "LinkTrails" -> "", 
  "HasOptions" -> True, "ExampleCounter" -> 1, 
  "Openers" -> {
   "PrimaryExamplesSection" -> Open, "ExampleSection" -> {"0" -> Open}, 
    "NotesSection" -> Closed}, "NewStyles" -> True, 
  "CitationPopupData" -> $Failed, "ShowCitation" -> False, "RootCaptions" -> 
  "", "Metadata" -> {
   "built" -> "{2023, 11, 30, 13, 55, 58.6601856}", 
    "history" -> {"XX", "", "", ""}, "context" -> "NewEoSArgon`", 
    "keywords" -> {}, "specialkeywords" -> {}, 
    "tutorialcollectionlinks" -> {}, "index" -> True, "label" -> 
    "New Eo S Argon Package Symbol", "language" -> "en", "paclet" -> 
    "NewEoSArgon Package", "status" -> "None", "summary" -> 
    "rhomaxRonc (g/cm^3) Densit\[EAcute] maximum des data de Ronchi relatives \
\[AGrave] l'argon [Maximum density of Ronchi's data]", "synonyms" -> {}, 
    "tabletags" -> {}, "title" -> "rhomaxRonc [\[Rho]maxRonc]", 
    "titlemodifier" -> "", "metadescription" -> "", "windowtitle" -> 
    "rhomaxRonc [\[Rho]maxRonc]", "type" -> "Symbol", "uri" -> 
    "NewEoSArgon/ref/rhomaxRonc"}},
CellContext->"Global`",
FrontEndVersion->"13.3 pour Microsoft Windows (64-bit) (July 24, 2023)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "13.3 pour Microsoft Windows (64-bit) (July 24, 2023)", 
  StyleDefinitions -> "Default.nb"],
ExpressionUUID->"48886b58-d396-48ec-a594-d82d340cdc04"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[11082, 294, 1420, 37, 35, "PrimaryExamplesSection",ExpressionUUID->"1e736797-96d4-4a9e-a5aa-831253fa40b2",
   CellTags->"PrimaryExamplesSection",
   CellID->940864403]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 23280, 629}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[598, 21, 5478, 133, 56, "AnchorBarGrid",ExpressionUUID->"e8ccdd8e-29d8-4035-919d-3d858d3ed85d",
 CellID->1],
Cell[6079, 156, 94, 0, 23, "ContextNameCell",ExpressionUUID->"f01362c8-58fd-45dc-8c36-50db402bcf02"],
Cell[CellGroupData[{
Cell[6198, 160, 569, 14, 56, "ObjectNameGrid",ExpressionUUID->"fe5ea887-2628-4e6f-bc7b-3760c02987a7"],
Cell[6770, 176, 686, 15, 146, "Usage",ExpressionUUID->"d11bb985-bc3b-4779-a896-93a0b174904c"]
}, Open  ]],
Cell[CellGroupData[{
Cell[7493, 196, 1918, 48, 37, "NotesSection",ExpressionUUID->"db50620f-9de8-42f2-b383-9862eba12bc5",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->81149809],
Cell[9414, 246, 699, 17, 79, "Notes",ExpressionUUID->"6b6d4247-dbf5-41cb-b3aa-752ba2fe221d",
 CellID->1067943069],
Cell[10116, 265, 185, 4, 36, "Notes",ExpressionUUID->"4af8b179-6c34-4605-8b61-817cbdb6c257",
 CellID->185021568],
Cell[10304, 271, 651, 17, 79, "Notes",ExpressionUUID->"98fe97c3-bc2f-4e5a-b166-4efaa7336412",
 CellID->140761484]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "NotesSection"}, Closed]]]],
Cell[CellGroupData[{
Cell[11082, 294, 1420, 37, 35, "PrimaryExamplesSection",ExpressionUUID->"1e736797-96d4-4a9e-a5aa-831253fa40b2",
 CellTags->"PrimaryExamplesSection",
 CellID->940864403],
Cell[CellGroupData[{
Cell[12527, 335, 1398, 36, 30, "ExampleSection",ExpressionUUID->"d2d0d839-9bd8-43ce-b90f-bb9927c7d433",
 CellID->361979321],
Cell[13928, 373, 174, 3, 26, "Input",ExpressionUUID->"fc3a7434-d739-4af0-9966-b20c79c9f3ec",
 CellID->87419684],
Cell[14105, 378, 139, 1, 38, "ExampleText",ExpressionUUID->"da6813d0-fb9a-4b12-9275-2940fdbf4a45",
 CellID->886239600],
Cell[CellGroupData[{
Cell[14269, 383, 206, 4, 26, "Input",ExpressionUUID->"449a50a2-ddb1-4300-8bd3-dca6a12831ef",
 CellID->21488140],
Cell[14478, 389, 389, 8, 45, "Output",ExpressionUUID->"691cc23e-ce20-4c61-856c-69bfc95b84b8",
 CellID->14941933]
}, Open  ]],
Cell[CellGroupData[{
Cell[14904, 402, 872, 23, 30, "Input",ExpressionUUID->"8b538c01-5fb6-48cb-a845-e11d0b933012",
 CellID->301596363],
Cell[15779, 427, 388, 8, 45, "Output",ExpressionUUID->"234d17eb-5412-41a3-af16-4baba179107c",
 CellID->829937645]
}, Open  ]],
Cell[16182, 438, 141, 1, 38, "ExampleText",ExpressionUUID->"f8614ab0-43f0-4c40-972d-71f2aafe4ea8",
 CellID->222855593],
Cell[CellGroupData[{
Cell[16348, 443, 302, 7, 26, "Input",ExpressionUUID->"37c301bb-21f3-4135-9e9a-d0babac7466c",
 CellID->295872759],
Cell[16653, 452, 390, 9, 43, "Output",ExpressionUUID->"94180fc8-d912-48d9-bf7d-5978240d3b07",
 CellID->240530017]
}, Open  ]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"}, Closed]]]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "PrimaryExamplesSection"}, Closed]]]],
Cell[17285, 470, 2379, 64, 114, "SeeAlsoSection",ExpressionUUID->"ddf29fe5-f5d5-4173-88e4-8860cfcb1f09"],
Cell[19667, 536, 729, 19, 114, "MoreAboutSection",ExpressionUUID->"175dac8f-38ba-4c0a-b2bf-ed9dccfe2aaa"],
Cell[20399, 557, 825, 24, 70, "RelatedLinksSection",ExpressionUUID->"352c902a-a467-419a-998e-ee152210e913"],
Cell[21227, 583, 78, 0, 70, "FooterCell",ExpressionUUID->"3dab6c67-e0cb-4d07-a9ea-68cbfcb62647"]
}
]
*)

(* End of internal cache information *)

