(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 13.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     74201,       1703]
NotebookOptionsPosition[     68109,       1579]
NotebookOutlinePosition[     70363,       1635]
CellTagsIndexPosition[     70277,       1630]
WindowTitle->rhotrgaz [\:03C1trgaz]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[GridBox[{
   {GridBox[{
      {
       ItemBox[Cell[BoxData[
         RowBox[{
          TemplateBox[{12},
           "Spacer1"], Cell["NEW EO S ARGON PACKAGE SYMBOL", "PacletNameCell",
           TextAlignment->Center,ExpressionUUID->
           "5bdcbf9c-6353-4db2-a8e3-b72ad3e67670"], 
          TemplateBox[{8},
           "Spacer1"]}]],
         TextAlignment->Center,ExpressionUUID->
         "06243e99-2480-4fbb-b7ff-a976aa75cc54"],
        Background->RGBColor[0.490196, 0.576471, 0.690196],
        ItemSize->Full], ""}
     },
     GridBoxAlignment->{"Rows" -> {{Center}}},
     GridBoxItemSize->{"Columns" -> {Full, 
         Scaled[0.02]}, "Rows" -> {{2.5}}}], Cell[TextData[{
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "See Also",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "0aad348f-1a40-400e-ad94-99c5514b61f4"]
         }],ExpressionUUID->"9a701849-6284-4d9b-9d5e-fd37734e0366"],
         StripOnInput->False],{
        "\"vtrgaz\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/vtrgaz"], "\"ttr\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/ttr"], "\"ptr\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/ptr"], 
         "\"rhotrliq\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/rhotrliq"], 
         "\"vtrliq\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/vtrliq"]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"SeeAlso"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "e91dc02b-b438-4a92-ab92-4dcb84cbea5a"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "Related Guides",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "8ffd5b97-94e4-4034-b863-cc3dbffdba4e"]
         }],ExpressionUUID->"198d5b35-a882-4edd-a7a5-9df85ff4d0e2"],
         StripOnInput->False],{
        "\"NewEoSArgon Package\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/guide/NewEoSArgon"]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"MoreAbout"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "722094f8-ef6c-494c-962b-a3183acadd71"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "URL",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "0da11d5b-cde2-4af5-9492-5ce09d92a079"]
         }],ExpressionUUID->"b5dee4bb-9cbd-4309-a494-a32b6c5a1283"],
         StripOnInput->False],{
        "\"NewEoSArgon/ref/rhotrgaz\"" :> None, 
         "\"Copy Wolfram Documentation Center URL\"" :> 
         Module[{DocumentationSearch`Private`nb$}, 
           DocumentationSearch`Private`nb$ = 
            NotebookPut[
             Notebook[{Cell["NewEoSArgon/ref/rhotrgaz"]}, Visible -> False]]; 
           SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
           FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
           NotebookClose[DocumentationSearch`Private`nb$]; Null], Delimiter, 
         "\"Copy web URL\"" :> 
         Module[{DocumentationSearch`Private`nb$}, 
           DocumentationSearch`Private`nb$ = 
            NotebookPut[
             Notebook[{
               Cell[BoxData[
                 MakeBoxes[
                  Hyperlink[
                   "http://reference.wolfram.com/language/NewEoSArgon/ref/\
rhotrgaz.html"], StandardForm]], "Input", TextClipboardType -> "PlainText"]}, 
               Visible -> False]]; 
           SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
           FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
           NotebookClose[DocumentationSearch`Private`nb$]; Null], 
         "\"Go to web URL\"" :> 
         FrontEndExecute[{
           NotebookLocate[{
             URL[If[TrueQ[DocumentationBuild`Make`Private`wsmlinkQ$26910], 
                 "http://reference.wolfram.com/system-modeler/", 
                 "http://reference.wolfram.com/language/"] <> 
               "NewEoSArgon/ref/rhotrgaz" <> ".html"], None}]}]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"URLMenu"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "941a07b0-3aff-445d-b92f-852bebda0ed5"]
    }], "AnchorBar",
     CacheGraphics->False,ExpressionUUID->
     "ae24d9b9-3c56-4f61-900d-70c2457baa36"]}
  }]], "AnchorBarGrid",
 CellID->1,ExpressionUUID->"983742d9-6a9a-47ea-be2b-04e402c2320e"],

Cell["NewEoSArgon`", "ContextNameCell",ExpressionUUID->"2ee595a1-555d-4ca7-801a-24c87aa103eb"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     Cell[
     "rhotrgaz [\[Rho]trgaz]", "ObjectName",ExpressionUUID->
      "829eed02-2777-4225-9aab-205994c69d7b"],
     Cell[BoxData[
      TemplateBox[{8},
       "Spacer1"]],ExpressionUUID->"c7f1ca8a-9570-4609-bcd9-52881f6b0dfc"],
     Cell[BoxData[
     ""], "ObjectNameTranslation",ExpressionUUID->
      "0628134f-0890-40a3-9950-1c681d952f7f"]
    }],ExpressionUUID->"320888c7-a8f5-468b-959b-309d1531fc51"], 
    "\[SpanFromLeft]"}
  }]], "ObjectNameGrid",ExpressionUUID->"5c91bafb-78d9-44ed-87f5-\
91f298b61584"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["rhotrgaz"], "InlineFormula",
      ShowStringCharacters->False,
      FontFamily->"Source Sans Pro",ExpressionUUID->
      "143967af-da58-4ee4-ae67-77b299411e98"],
     " (g/",
     Cell[BoxData[
      SuperscriptBox["cm", "3"]], "InlineFormula",
      FontFamily->"Source Sans Pro",ExpressionUUID->
      "338c6917-30c4-4cbf-9429-9be730db561a"],
     ") \nDensit\[EAcute] du ",
     StyleBox["gaz",
      FontSlant->"Italic"],
     " au point triple de l'argon donn\[EAcute]e par NIST \n[Triple point ",
     StyleBox["gas",
      FontSlant->"Italic"],
     " density of argon from NIST]"
    }],ExpressionUUID->"a6af07d5-f197-4fe3-8a27-9361aec04071"]}
  }]], "Usage",
 Deletable->True,ExpressionUUID->"2a6f4ef7-b569-4918-aa4d-e968a95a3026"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[Cell[TextData[{
   Cell[BoxData[
    DynamicBox[ToBoxes[
      If[
       MatchQ[
        CurrentValue[
         EvaluationNotebook[], {TaggingRules, "Openers", "NotesSection"}, 
         Closed], 
        Alternatives[Open, True]], 
       Style[
        Graphics[{
          Thickness[0.18], 
          RGBColor[0.8509803921568627, 0.396078431372549, 0], 
          Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
         PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
        0.68 Inherited], 
       Rotate[
        Style[
         Graphics[{
           Thickness[0.18], 
           RGBColor[0.8509803921568627, 0.396078431372549, 0], 
           Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
          PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
         0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
     ImageSizeCache->{
      13.600000000000001`, {0.5800000000000001, 13.020000000000001`}}]],
    ExpressionUUID->"17719ab2-9cf3-464d-ac74-1cf8c7a25b19"],
   Cell[BoxData[
    TemplateBox[{1},
     "Spacer1"]],ExpressionUUID->"3f4d491d-6955-4c56-ab91-1c7a28f74280"],
   "Details and Options"
  }], "NotesFrameText",ExpressionUUID->"cc24954c-a880-4f77-beb0-6201722a6ff2"],
  Appearance->{Automatic, None, "Normal", Automatic},
  BaseStyle->None,
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"], 
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], After, CellContents]}]& ),
  Evaluator->None,
  Method->
   "Preemptive"]],ExpressionUUID->"6547a48d-b371-4e70-b52f-41a24014ead4"]], \
"NotesSection",
 WholeCellGroupOpener->True,
 CellGroupingRules->{"SectionGrouping", 50},
 CacheGraphics->False,
 CellID->221388201,ExpressionUUID->"a2a6d702-475c-4a34-afa7-75679b8d6658"],

Cell[TextData[{
 "La densit\[EAcute] du gaz au point triple peut encore se d\[EAcute]duire du \
volume molaire au point triple telle que \[Rho]trgaz = ",
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["M"]], "paclet:NewEoSArgon/ref/M", "NewEoSArgon Package Symbol"},
   "PackageLink",
   BaseStyle->"InlineFormula"]], "InlineFormula",
  FontFamily->"Source Sans Pro",ExpressionUUID->
  "a8a6c618-621c-42cc-aa37-fd37005ad403"],
 " / ",
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["vtrgaz"]], "paclet:NewEoSArgon/ref/vtrgaz", 
    "NewEoSArgon Package Symbol"},
   "PackageLink",
   BaseStyle->"InlineFormula"]], "InlineFormula",
  FontFamily->"Source Sans Pro",ExpressionUUID->
  "7a0b1334-57ec-412d-9563-34d81fe1ed7e"],
 "."
}], "Notes",
 CellID->1067943069,ExpressionUUID->"0c0ead95-819e-47b6-a391-3b7c6048d4f6"],

Cell["\<\
******************************************************************************\
*****\
\>", "Notes",
 CellID->185021568,ExpressionUUID->"ee1f834e-ec84-442a-9e22-2eac72858d20"],

Cell[TextData[{
 "The gas density at the triple point can still be deduced from the molar \
volume at the triple point as follows \[Rho]trgaz = ",
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["M"]], "paclet:NewEoSArgon/ref/M", "NewEoSArgon Package Symbol"},
   "PackageLink",
   BaseStyle->"InlineFormula"]], "InlineFormula",
  FontFamily->"Source Sans Pro",ExpressionUUID->
  "f081890b-8786-46c9-a1c2-68b598a0f1f3"],
 " / ",
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["vtrgaz"]], "paclet:NewEoSArgon/ref/vtrgaz", 
    "NewEoSArgon Package Symbol"},
   "PackageLink",
   BaseStyle->"InlineFormula"]], "InlineFormula",
  FontFamily->"Source Sans Pro",ExpressionUUID->
  "f5c2dfef-89c0-4b93-9657-f4001d0d7cd8"],
 "."
}], "Notes",
 CellID->489383078,ExpressionUUID->"618ce1bf-87f2-42f7-9ded-bbef593952bc"]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "NotesSection"}, Closed]]]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {
       TaggingRules, "Openers", "PrimaryExamplesSection"}, Open], 
      Alternatives[True, Open]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{13.600000000000001`, {5., 8.600000000000001}}]],
  ExpressionUUID->"8ca3231a-da87-4e66-8781-a4aafed78bad"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"7c0c1760-045d-4dfa-a445-7e7ecc081bce"],
 "Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "028a4f80-f61e-4e8e-b404-83112013efd8"]
}], "PrimaryExamplesSection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellTags->"PrimaryExamplesSection",
 CellID->455893982,ExpressionUUID->"9cf55fbf-129d-4cff-b943-866092bc0809"],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"},
        Closed], 
      Alternatives[Open, True]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{13.600000000000001`, {5., 8.600000000000001}}]],
  ExpressionUUID->"c94731f4-9447-4b6d-89cd-b85f8126dabd"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"17c83f3a-283d-4472-be71-7a2dcdc96852"],
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "dbf6bf32-d041-4422-bc99-00eb8d46bfcf"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellID->330640,ExpressionUUID->"b26aa42f-3983-4a88-ae67-81d271a75e69"],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<NewEoSArgon`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->87419684,ExpressionUUID->"7d47f9c7-c432-4ce3-8649-a5708d6e3e6c"],

Cell["Give a physical dimension to the constant", "ExampleText",
 CellID->886239600,ExpressionUUID->"7fafdf7b-1ba7-41be-adbd-3e3476db3086"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Quantity", "[", 
  RowBox[{"\[Rho]trgaz", ",", "\"\<g/cm^3\>\""}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->21488140,ExpressionUUID->"a4fac448-a6a6-429b-bfb2-f91bdc1e1124"],

Cell[BoxData[
 TemplateBox[{"0.0040546000061275735`", 
   RowBox[{"\"g\"", "\[InvisibleSpace]", "\"/\"", "\[InvisibleSpace]", 
     SuperscriptBox["\"cm\"", "3"]}], "grams per centimeter cubed", 
   FractionBox["\"Grams\"", 
    SuperscriptBox["\"Centimeters\"", "3"]]},
  "Quantity"]], "Output",
 CellLabel->"Out[2]=",
 CellID->36001421,ExpressionUUID->"0f8070cd-4d57-403a-9f69-dc2dee013417"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UnitConvert", "[", 
  RowBox[{
   TemplateBox[{"0.0040546000061275735`"},
    "QuantityUnit",
    DisplayFunction->(TooltipBox[
      StyleBox[
       RowBox[{#, "\[InvisibleSpace]", 
         StyleBox[
          RowBox[{" ", 
            
            RowBox[{"\"g\"", "\[InvisibleSpace]", "\"/\"", 
              "\[InvisibleSpace]", 
              SuperscriptBox["\"cm\"", "3"]}]}], 
          "QuantityUnitTraditionalLabel"]}], ShowStringCharacters -> False], 
      "Unit: grams per centimeter cubed"]& ),
    InterpretationFunction->(RowBox[{"Quantity", "[", 
       RowBox[{#, ",", 
         FractionBox["\"Grams\"", 
          SuperscriptBox["\"Centimeters\"", "3"]]}], "]"}]& )], ",", 
   "\"\<kg/m^3\>\""}], "]"}]], "Input",
 NumberMarks->False,
 CellLabel->"In[3]:=",
 CellID->1017974,ExpressionUUID->"642c8b54-bdd3-472f-8c8e-4331752a1bd2"],

Cell[BoxData[
 TemplateBox[{"4.054600006127574`", 
   RowBox[{"\"kg\"", "\[InvisibleSpace]", "\"/\"", "\[InvisibleSpace]", 
     SuperscriptBox["\"m\"", "3"]}], "kilograms per meter cubed", 
   FractionBox["\"Kilograms\"", 
    SuperscriptBox["\"Meters\"", "3"]]},
  "Quantity"]], "Output",
 CellLabel->"Out[3]=",
 CellID->875135877,ExpressionUUID->"d4456e60-82ba-4fdd-8804-6c919e30ecdd"]
}, Open  ]],

Cell["Other way to define the triple point density", "ExampleText",
 CellID->278961620,ExpressionUUID->"f9ac8c33-2eaa-4829-8bb9-0f330b502d14"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Quantity", "[", 
   RowBox[{"M", ",", "\"\<g/mol\>\""}], "]"}], "/", 
  RowBox[{"Quantity", "[", 
   RowBox[{"vtrgaz", ",", "\"\<cm^3/mol\>\""}], "]"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->295872759,ExpressionUUID->"ed0ea4b1-b7c8-4b2e-a2c8-261d1199cd48"],

Cell[BoxData[
 TemplateBox[{"0.0040546000061275735`", 
   RowBox[{"\"g\"", "\[InvisibleSpace]", "\"/\"", "\[InvisibleSpace]", 
     SuperscriptBox["\"cm\"", "3"]}], "grams per centimeter cubed", 
   FractionBox["\"Grams\"", 
    SuperscriptBox["\"Centimeters\"", "3"]]},
  "Quantity"]], "Output",
 CellLabel->"Out[4]=",
 CellID->95049339,ExpressionUUID->"dccb3e63-849e-4d62-9bce-f0c66786c557"]
}, Open  ]],

Cell["Using WolframAlpha", "ExampleText",
 CellID->351008126,ExpressionUUID->"23251533-7656-4b14-8cca-46616c4cc135"],

Cell[CellGroupData[{

Cell[BoxData[
 NamespaceBox["WolframAlphaQueryResults",
  DynamicModuleBox[{Typeset`q$$ = "triple point gas density of argon ", 
   Typeset`opts$$ = {
   AppearanceElements -> {"Extrusion", "Warnings", "Assumptions", "Pods"}, 
    Asynchronous -> All, PodStates -> {"Result__Show details"}, 
    Method -> {
     "ExtrusionChosen" -> {
       "Result", "Results", 1, 2, "Output", 
        "Quantity[0.04902, \"Kilograms\"/\"Meters\"^3]"}, "ExtrusionOpen" -> 
      True, "Formats" -> {
       "cell", "minput", "moutput", "msound", "dataformats"}}}, 
   Typeset`elements$$ = {"Extrusion", "Warnings", "Assumptions", "Pods"}, 
   Typeset`pod1$$ = XMLElement[
   "pod", {"error" -> "false", "id" -> "Input", "numsubpods" -> "1", 
     "position" -> "100", "scanner" -> "Identity", "title" -> 
     "Input interpretation"}, {
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement["cell", {"compressed" -> False, "string" -> True}, {
         Cell[
          BoxData[
           FormBox[
            TagBox[
             RowBox[{
               RowBox[{"(", 
                 TagBox[
                  RowBox[{"3", " ", 
                    RowBox[{"(", 
                    StyleBox[
                    RowBox[{
                    TagBox[
                    RowBox[{
                    StyleBox[
                    "\"p.p.\"", {
                    FontFamily -> "Roboto", FontSize -> 0.9 Inherited, 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0}]}], Identity], "  ", 
                    StyleBox[
                    
                    RowBox[{
                    "\"(\"", "\[NoBreak]", "\"percentage point\"", 
                    "\[NoBreak]", "\")\""}], {
                    FontFamily -> "Roboto", FontSize -> 0.9 Inherited, 
                    GrayLevel[0.6], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0}]}], LinebreakAdjustments -> {1, 100, 1, 0, 100}, 
                    LineIndent -> 0, ZeroWidthTimes -> False], ")"}]}], 
                  PolynomialForm[#, TraditionalOrder -> False]& ], ")"}], " ", 
               FormBox[
                TagBox[
                 GridBox[{{
                    PaneBox[
                    StyleBox[
                    TagBox[
                    GridBox[{{
                    StyleBox[
                    TagBox[
                    TagBox["\"argon\"", 
                    $CellContext`TagBoxWrapper[
                    "Entity" -> {ChemicalData, "Argon"}, 
                    "SRString" :> $CellContext`GeneralData[
                    ChemicalData, "Argon", "SpokenName"]]], Identity], {
                    LineIndent -> 0, LineSpacing -> {0.9, 0, 1.5}}], 
                    "\"density\"", 
                    StyleBox["\"phase\"", {
                    GrayLevel[0.6]}], "\"gas\""}}, 
                    GridBoxBackground -> {"Columns" -> {
                    GrayLevel[0.949], None, None, None}, "Rows" -> {{None}}}, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    ColumnsEqual -> False, RowsEqual -> False, 
                    GridBoxDividers -> {"Columns" -> {
                    GrayLevel[0.84], 
                    GrayLevel[0.84], 
                    GrayLevel[0.84], 
                    GrayLevel[0.84], 
                    GrayLevel[0.84]}, "Rows" -> {{
                    GrayLevel[0.84]}}, 
                    "RowsIndexed" -> {
                    1 -> GrayLevel[0.84], -1 -> GrayLevel[0.84]}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {2, 2, 2, 2, 2}, "Rows" -> {{1}}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Baseline}}}, 
                    AllowScriptLevelChange -> False, BaselinePosition -> 1], 
                    $CellContext`TagBoxWrapper["Separator" -> " | "]], 
                    LineSpacing -> {1, 0, 1.5}, LineIndent -> 0], 
                    BaselinePosition -> Center]}}, 
                  GridBoxItemSize -> {
                   "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                  ColumnsEqual -> False, RowsEqual -> False, 
                  GridBoxSpacings -> {"Columns" -> {{
                    AbsoluteThickness[-1]}}, "Rows" -> {{0}}}, 
                  AllowScriptLevelChange -> False], 
                 $CellContext`TagBoxWrapper["Separator" -> " | "]], 
                TraditionalForm]}], 
             PolynomialForm[#, TraditionalOrder -> False]& ], 
            TraditionalForm]], "Output", {
          Background -> None, 
           GraphicsBoxOptions -> {
            DefaultBaseStyle -> {FontFamily -> "Times", "Graphics"}, 
             DefaultAxesStyle -> Directive[
               GrayLevel[0, 0.35], FontColor -> GrayLevel[0.25], FontOpacity -> 
               1, "GraphicsAxes"], DefaultFrameStyle -> Directive[
               GrayLevel[0, 0.35], FontColor -> GrayLevel[0.25], FontOpacity -> 
               1, "GraphicsFrame"], DefaultFrameTicksStyle -> 
             Directive[
              FontFamily -> "Times", FontSize -> 10, "GraphicsFrameTicks"], 
             DefaultTicksStyle -> 
             Directive[
              FontFamily -> "Times", FontSize -> 10, "GraphicsTicks"]}, 
           Graphics3DBoxOptions -> {
            DefaultBaseStyle -> {FontFamily -> "Times", "Graphics3D"}}}, 
          NumberPoint -> ".", CellSize -> {550, Automatic}, 
          AutoStyleOptions -> {"HighlightFormattingErrors" -> False}, 
          RenderingOptions -> {
           "3DRenderingMethod" -> "BSPTreeOrDepthBuffer"}]}], 
       XMLElement["dataformats", {}, {"plaintext"}]}], 
     XMLElement["expressiontypes", {"count" -> "1"}, {"\n   ", 
       XMLElement["expressiontype", {"name" -> "Grid"}, {}], "\n  "}]}], 
   Typeset`pod2$$ = XMLElement[
   "pod", {"error" -> "false", "id" -> "Result", "numsubpods" -> "2", 
     "position" -> "200", "primary" -> "true", "scanner" -> "Data", "title" -> 
     "Results"}, {
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement["microsources", {}, {"\n    ", 
         XMLElement["microsource", {}, {"ChemicalData"}], "\n   "}], 
       XMLElement["datasources", {}, {"\n    ", 
         XMLElement["datasource", {}, {"CRCHandbook"}], "\n    ", 
         XMLElement["datasource", {}, {"NISTREFPROP"}], "\n   "}], 
       XMLElement[
       "moutput", {}, {"Quantity[0.04902, \"Kilograms\"/\"Meters\"^3]"}], 
       XMLElement["cell", {"compressed" -> False, "string" -> True}, {
         Cell[
          BoxData[
           FormBox[
            StyleBox[
             TagBox[
              RowBox[{
                TagBox[
                 TagBox[
                  RowBox[{
                    TagBox["0.04902", 
                    $CellContext`TagBoxWrapper[
                    "StringBoxes" -> "0.04902", "SRString" -> "0.04902"]], 
                    "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], {
                    FontFamily -> "Roboto", FontSize -> 0.9 Inherited, 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0}], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    
                    RowBox[{
                    "\"kg\"", "\[InvisibleSpace]", "\"/\"", 
                    "\[InvisibleSpace]", 
                    SuperscriptBox["\"m\"", "3"]}], {
                    FontFamily -> "Roboto", FontSize -> 0.9 Inherited, 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0}]}], Identity], #& , SyntaxForm -> Dot], "  ", 
                StyleBox[
                 
                 RowBox[{
                  "\"(\"", "\[NoBreak]", "\"kilograms per cubic meter\"", 
                   "\[NoBreak]", "\")\""}], {
                 FontFamily -> "Roboto", FontSize -> 0.9 Inherited, 
                  GrayLevel[0.6], LinebreakAdjustments -> {1, 100, 1, 0, 100},
                   LineIndent -> 0}]}], "Unit", SyntaxForm -> Dot], 
             LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 0, 
             ZeroWidthTimes -> False], TraditionalForm]], "Output", {
          Background -> None, 
           GraphicsBoxOptions -> {
            DefaultBaseStyle -> {FontFamily -> "Times", "Graphics"}, 
             DefaultAxesStyle -> Directive[
               GrayLevel[0, 0.35], FontColor -> GrayLevel[0.25], FontOpacity -> 
               1, "GraphicsAxes"], DefaultFrameStyle -> Directive[
               GrayLevel[0, 0.35], FontColor -> GrayLevel[0.25], FontOpacity -> 
               1, "GraphicsFrame"], DefaultFrameTicksStyle -> 
             Directive[
              FontFamily -> "Times", FontSize -> 10, "GraphicsFrameTicks"], 
             DefaultTicksStyle -> 
             Directive[
              FontFamily -> "Times", FontSize -> 10, "GraphicsTicks"]}, 
           Graphics3DBoxOptions -> {
            DefaultBaseStyle -> {FontFamily -> "Times", "Graphics3D"}}}, 
          NumberPoint -> ".", CellSize -> {550, Automatic}, 
          AutoStyleOptions -> {"HighlightFormattingErrors" -> False}, 
          RenderingOptions -> {
           "3DRenderingMethod" -> "BSPTreeOrDepthBuffer"}]}], 
       XMLElement[
       "dataformats", {}, {
        "plaintext,moutput,computabledata,formatteddata,numberdata,\
quantitydata"}]}], 
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement["microsources", {}, {"\n    ", 
         XMLElement["microsource", {}, {"ChemicalData"}], "\n   "}], 
       XMLElement["datasources", {}, {"\n    ", 
         XMLElement["datasource", {}, {"CRCHandbook"}], "\n    ", 
         XMLElement["datasource", {}, {"NISTREFPROP"}], "\n   "}], 
       XMLElement["cell", {"compressed" -> True, "string" -> False}, {
         Cell[
          BoxData[
           FormBox[
            StyleBox[
             TagBox[
              GridBox[{{
                 TagBox[
                  PaneBox[
                   TagBox[
                    FormBox[
                    TagBox[
                    GridBox[{{
                    PaneBox[
                    StyleBox[
                    TagBox[
                    GridBox[{{
                    StyleBox[
                    TagBox[
                    TagBox["\"argon\"", 
                    $CellContext`TagBoxWrapper[
                    "Entity" -> {ChemicalData, "Argon"}, 
                    "SRString" :> $CellContext`GeneralData[
                    ChemicalData, "Argon", "SpokenName"]]], Identity], {
                    LineIndent -> 0, LineSpacing -> {0.9, 0, 1.5}}], 
                    "\"density\"", 
                    StyleBox["\"phase\"", {
                    GrayLevel[0.6]}], "\"gas\""}}, 
                    GridBoxBackground -> {"Columns" -> {
                    GrayLevel[0.949], None, None, None}, "Rows" -> {{None}}}, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    ColumnsEqual -> False, RowsEqual -> False, 
                    GridBoxDividers -> {"Columns" -> {
                    GrayLevel[0.84], 
                    GrayLevel[0.84], 
                    GrayLevel[0.84], 
                    GrayLevel[0.84], 
                    GrayLevel[0.84]}, "Rows" -> {{
                    GrayLevel[0.84]}}, 
                    "RowsIndexed" -> {
                    1 -> GrayLevel[0.84], -1 -> GrayLevel[0.84]}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {2, 2, 2, 2, 2}, "Rows" -> {{1}}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Baseline}}}, 
                    AllowScriptLevelChange -> False, BaselinePosition -> 1], 
                    $CellContext`TagBoxWrapper["Separator" -> " | "]], 
                    LineSpacing -> {1, 0, 1.5}, LineIndent -> 0], 
                    BaselinePosition -> Center]}}, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    ColumnsEqual -> False, RowsEqual -> False, 
                    GridBoxSpacings -> {"Columns" -> {{
                    AbsoluteThickness[-1]}}, "Rows" -> {{0}}}, 
                    AllowScriptLevelChange -> False], 
                    $CellContext`TagBoxWrapper["Separator" -> " | "]], 
                    TraditionalForm], HoldForm], 
                   BaseStyle -> {{
                    BaselinePosition -> Baseline, FontColor -> 
                    GrayLevel[0.3]}, LineSpacing -> {0.9, 0, 1.5}, 
                    LinebreakAdjustments -> {1, 10, 10000, 0, 100}, 
                    TextAlignment -> Left}, BaselinePosition -> Baseline], 
                  $CellContext`TagBoxWrapper["Label"]], 
                 ItemBox[
                  StyleBox[
                   TagBox[
                    RowBox[{
                    TagBox[
                    TagBox[
                    RowBox[{
                    TagBox["1.634", 
                    $CellContext`TagBoxWrapper[
                    "StringBoxes" -> "1.634", "SRString" -> "1.634"]], 
                    "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], {
                    FontFamily -> "Roboto", FontSize -> 0.9 Inherited, 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0}], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    
                    RowBox[{
                    "\"kg\"", "\[InvisibleSpace]", "\"/\"", 
                    "\[InvisibleSpace]", 
                    SuperscriptBox["\"m\"", "3"]}], {
                    FontFamily -> "Roboto", FontSize -> 0.9 Inherited, 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0}]}], Identity], #& , SyntaxForm -> Dot], "  ", 
                    StyleBox[
                    
                    RowBox[{
                    "\"(\"", "\[NoBreak]", "\"kilograms per cubic meter\"", 
                    "\[NoBreak]", "\")\""}], {
                    FontFamily -> "Roboto", FontSize -> 0.9 Inherited, 
                    GrayLevel[0.6], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0}]}], "Unit", SyntaxForm -> Dot], 
                   LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                   0, ZeroWidthTimes -> False], StripOnInput -> False]}}, 
               GridBoxAlignment -> {
                "Columns" -> {Left, Left}, "Rows" -> {{Baseline}}}, 
               AutoDelete -> False, 
               GridBoxBackground -> {"Columns" -> {None, None}}, 
               GridBoxFrame -> {"Columns" -> {{True}}, "Rows" -> {{True}}}, 
               GridBoxItemSize -> {
                "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
               GridBoxSpacings -> {"Columns" -> {{1.5}, 2}, "Rows" -> {{1}}}, 
               FrameStyle -> GrayLevel[0.84], BaselinePosition -> Automatic, 
               AllowScriptLevelChange -> False], "Grid"], 
             LineSpacing -> {0.9, 0, 1.5}, LineIndent -> 0, StripOnInput -> 
             False], TraditionalForm]], "Output", {
          Background -> None, 
           GraphicsBoxOptions -> {
            DefaultBaseStyle -> {FontFamily -> "Times", "Graphics"}, 
             DefaultAxesStyle -> Directive[
               GrayLevel[0, 0.35], FontColor -> GrayLevel[0.25], FontOpacity -> 
               1, "GraphicsAxes"], DefaultFrameStyle -> Directive[
               GrayLevel[0, 0.35], FontColor -> GrayLevel[0.25], FontOpacity -> 
               1, "GraphicsFrame"], DefaultFrameTicksStyle -> 
             Directive[
              FontFamily -> "Times", FontSize -> 10, "GraphicsFrameTicks"], 
             DefaultTicksStyle -> 
             Directive[
              FontFamily -> "Times", FontSize -> 10, "GraphicsTicks"]}, 
           Graphics3DBoxOptions -> {
            DefaultBaseStyle -> {FontFamily -> "Times", "Graphics3D"}}}, 
          NumberPoint -> ".", CellSize -> {550, Automatic}, 
          AutoStyleOptions -> {"HighlightFormattingErrors" -> False}, 
          RenderingOptions -> {
           "3DRenderingMethod" -> "BSPTreeOrDepthBuffer"}]}], 
       XMLElement[
       "dataformats", {}, {
        "plaintext,computabledata,formatteddata,numberdata,quantitydata"}]}], 
     XMLElement["expressiontypes", {"count" -> "2"}, {"\n   ", 
       XMLElement["expressiontype", {"name" -> "Default"}, {}], "\n   ", 
       XMLElement["expressiontype", {"name" -> "Grid"}, {}], "\n  "}], 
     XMLElement["states", {"count" -> "1"}, {
       XMLElement[
       "state", {
        "name" -> "Hide details", "input" -> "Result__Hide details"}, {}]}]}],
    Typeset`pod3$$ = XMLElement[
   "pod", {"error" -> "false", "id" -> "UnitConversion", "numsubpods" -> "3", 
     "position" -> "300", "scanner" -> "Unit", "title" -> 
     "Unit conversions"}, {
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement["cell", {"compressed" -> False, "string" -> True}, {
         Cell[
          BoxData[
           FormBox[
            StyleBox[
             TagBox[
              RowBox[{
                TagBox[
                 TagBox[
                  RowBox[{
                    TagBox["49.02", 
                    $CellContext`TagBoxWrapper[
                    "StringBoxes" -> "49.02", "SRString" -> "49.02"]], 
                    "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], {
                    FontFamily -> "Roboto", FontSize -> 0.9 Inherited, 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0}], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    
                    RowBox[{
                    "\"g\"", "\[InvisibleSpace]", "\"/\"", 
                    "\[InvisibleSpace]", 
                    SuperscriptBox["\"m\"", "3"]}], {
                    FontFamily -> "Roboto", FontSize -> 0.9 Inherited, 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0}]}], Identity], #& , SyntaxForm -> Dot], "  ", 
                StyleBox[
                 
                 RowBox[{
                  "\"(\"", "\[NoBreak]", "\"grams per cubic meter\"", 
                   "\[NoBreak]", "\")\""}], {
                 FontFamily -> "Roboto", FontSize -> 0.9 Inherited, 
                  GrayLevel[0.6], LinebreakAdjustments -> {1, 100, 1, 0, 100},
                   LineIndent -> 0}]}], "Unit", SyntaxForm -> Dot], 
             LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 0, 
             ZeroWidthTimes -> False], TraditionalForm]], "Output", {
          Background -> None, 
           GraphicsBoxOptions -> {
            DefaultBaseStyle -> {FontFamily -> "Times", "Graphics"}, 
             DefaultAxesStyle -> Directive[
               GrayLevel[0, 0.35], FontColor -> GrayLevel[0.25], FontOpacity -> 
               1, "GraphicsAxes"], DefaultFrameStyle -> Directive[
               GrayLevel[0, 0.35], FontColor -> GrayLevel[0.25], FontOpacity -> 
               1, "GraphicsFrame"], DefaultFrameTicksStyle -> 
             Directive[
              FontFamily -> "Times", FontSize -> 10, "GraphicsFrameTicks"], 
             DefaultTicksStyle -> 
             Directive[
              FontFamily -> "Times", FontSize -> 10, "GraphicsTicks"]}, 
           Graphics3DBoxOptions -> {
            DefaultBaseStyle -> {FontFamily -> "Times", "Graphics3D"}}}, 
          NumberPoint -> ".", CellSize -> {550, Automatic}, 
          AutoStyleOptions -> {"HighlightFormattingErrors" -> False}, 
          RenderingOptions -> {
           "3DRenderingMethod" -> "BSPTreeOrDepthBuffer"}]}], 
       XMLElement[
       "dataformats", {}, {
        "plaintext,computabledata,formatteddata,numberdata,quantitydata"}]}], 
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement["cell", {"compressed" -> False, "string" -> True}, {
         Cell[
          BoxData[
           FormBox[
            StyleBox[
             TagBox[
              RowBox[{
                TagBox[
                 TagBox[
                  RowBox[{
                    TagBox[
                    RowBox[{"4.902", 
                    StyleBox["\[Times]", 
                    GrayLevel[0.5]], 
                    SuperscriptBox["10", "-5"]}], 
                    $CellContext`TagBoxWrapper[
                    "StringBoxes" -> RowBox[{"4.902", "\[Times]", 
                    SuperscriptBox["10", "-5"]}], "SRString" -> 
                    "4.902 times 10 to the negative 5"], SyntaxForm -> 
                    CenterDot], "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], {
                    FontFamily -> "Roboto", FontSize -> 0.9 Inherited, 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0}], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    
                    RowBox[{
                    "\"g\"", "\[InvisibleSpace]", "\"/\"", 
                    "\[InvisibleSpace]", 
                    SuperscriptBox["\"cm\"", "3"]}], {
                    FontFamily -> "Roboto", FontSize -> 0.9 Inherited, 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0}]}], Identity], #& , SyntaxForm -> Dot], "  ", 
                StyleBox[
                 
                 RowBox[{
                  "\"(\"", "\[NoBreak]", "\"grams per cubic centimeter\"", 
                   "\[NoBreak]", "\")\""}], {
                 FontFamily -> "Roboto", FontSize -> 0.9 Inherited, 
                  GrayLevel[0.6], LinebreakAdjustments -> {1, 100, 1, 0, 100},
                   LineIndent -> 0}]}], "Unit", SyntaxForm -> Dot], 
             LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 0, 
             ZeroWidthTimes -> False], TraditionalForm]], "Output", {
          Background -> None, 
           GraphicsBoxOptions -> {
            DefaultBaseStyle -> {FontFamily -> "Times", "Graphics"}, 
             DefaultAxesStyle -> Directive[
               GrayLevel[0, 0.35], FontColor -> GrayLevel[0.25], FontOpacity -> 
               1, "GraphicsAxes"], DefaultFrameStyle -> Directive[
               GrayLevel[0, 0.35], FontColor -> GrayLevel[0.25], FontOpacity -> 
               1, "GraphicsFrame"], DefaultFrameTicksStyle -> 
             Directive[
              FontFamily -> "Times", FontSize -> 10, "GraphicsFrameTicks"], 
             DefaultTicksStyle -> 
             Directive[
              FontFamily -> "Times", FontSize -> 10, "GraphicsTicks"]}, 
           Graphics3DBoxOptions -> {
            DefaultBaseStyle -> {FontFamily -> "Times", "Graphics3D"}}}, 
          NumberPoint -> ".", CellSize -> {550, Automatic}, 
          AutoStyleOptions -> {"HighlightFormattingErrors" -> False}, 
          RenderingOptions -> {
           "3DRenderingMethod" -> "BSPTreeOrDepthBuffer"}]}], 
       XMLElement[
       "dataformats", {}, {
        "plaintext,computabledata,formatteddata,numberdata,quantitydata"}]}], 
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement["cell", {"compressed" -> False, "string" -> True}, {
         Cell[
          BoxData[
           FormBox[
            StyleBox[
             TagBox[
              RowBox[{
                TagBox[
                 TagBox[
                  RowBox[{
                    TagBox["0.04902", 
                    $CellContext`TagBoxWrapper[
                    "StringBoxes" -> "0.04902", "SRString" -> "0.04902"]], 
                    "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], {
                    FontFamily -> "Roboto", FontSize -> 0.9 Inherited, 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0}], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    
                    RowBox[{
                    "\"g\"", "\[InvisibleSpace]", "\"/\"", 
                    "\[InvisibleSpace]", "\"L\""}], {
                    FontFamily -> "Roboto", FontSize -> 0.9 Inherited, 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0}]}], Identity], #& , SyntaxForm -> Dot], "  ", 
                StyleBox[
                 
                 RowBox[{
                  "\"(\"", "\[NoBreak]", "\"grams per liter\"", "\[NoBreak]", 
                   "\")\""}], {
                 FontFamily -> "Roboto", FontSize -> 0.9 Inherited, 
                  GrayLevel[0.6], LinebreakAdjustments -> {1, 100, 1, 0, 100},
                   LineIndent -> 0}]}], "Unit", SyntaxForm -> Dot], 
             LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 0, 
             ZeroWidthTimes -> False], TraditionalForm]], "Output", {
          Background -> None, 
           GraphicsBoxOptions -> {
            DefaultBaseStyle -> {FontFamily -> "Times", "Graphics"}, 
             DefaultAxesStyle -> Directive[
               GrayLevel[0, 0.35], FontColor -> GrayLevel[0.25], FontOpacity -> 
               1, "GraphicsAxes"], DefaultFrameStyle -> Directive[
               GrayLevel[0, 0.35], FontColor -> GrayLevel[0.25], FontOpacity -> 
               1, "GraphicsFrame"], DefaultFrameTicksStyle -> 
             Directive[
              FontFamily -> "Times", FontSize -> 10, "GraphicsFrameTicks"], 
             DefaultTicksStyle -> 
             Directive[
              FontFamily -> "Times", FontSize -> 10, "GraphicsTicks"]}, 
           Graphics3DBoxOptions -> {
            DefaultBaseStyle -> {FontFamily -> "Times", "Graphics3D"}}}, 
          NumberPoint -> ".", CellSize -> {550, Automatic}, 
          AutoStyleOptions -> {"HighlightFormattingErrors" -> False}, 
          RenderingOptions -> {
           "3DRenderingMethod" -> "BSPTreeOrDepthBuffer"}]}], 
       XMLElement[
       "dataformats", {}, {
        "plaintext,computabledata,formatteddata,numberdata,quantitydata"}]}], 
     XMLElement["expressiontypes", {"count" -> "3"}, {"\n   ", 
       XMLElement["expressiontype", {"name" -> "Default"}, {}], "\n   ", 
       XMLElement["expressiontype", {"name" -> "Default"}, {}], "\n   ", 
       XMLElement["expressiontype", {"name" -> "Default"}, {}], "\n  "}], 
     XMLElement["states", {"count" -> "2"}, {
       XMLElement[
       "state", {
        "name" -> "More digits", "input" -> 
         "UnitConversion__More digits"}, {}], 
       XMLElement[
       "state", {
        "name" -> "Exact forms", "input" -> 
         "UnitConversion__Exact forms"}, {}]}]}], Typeset`pod4$$ = XMLElement[
   "pod", {"error" -> "false", "id" -> "ComparisonAsMassDensity", 
     "numsubpods" -> "2", "position" -> "400", "scanner" -> "Unit", "title" -> 
     "Comparisons as mass density"}, {
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement["cell", {"compressed" -> False, "string" -> True}, {
         Cell[
          BoxData[
           FormBox[
            FormBox[
             TemplateBox[{"\" \[TildeTilde] \"", 
               StyleBox["\"( \"", {
                 GrayLevel[0.6], LinebreakAdjustments -> {1, 100, 1, 0, 100}, 
                 LineIndent -> 0}], 
               
               TemplateBox[{"\"\"", "0", "\".\"", "0", "0", "2"}, 
                "RowDefault"], 
               StyleBox[
                
                TemplateBox[{
                 "\" \[TildeTilde] \"", "\"1\"", "\"/\"", "410", "\" ) \""}, 
                 "RowDefault"], {
                 GrayLevel[0.6], LinebreakAdjustments -> {1, 100, 1, 0, 100}, 
                 LineIndent -> 0}], 
               StyleBox[
                StyleBox["\"\[Times]\"", {
                  GrayLevel[0.6], LinebreakAdjustments -> {1, 100, 1, 0, 100},
                   LineIndent -> 0}], FontSize -> 10.219999999999999`, 
                StripOnInput -> False], "\"\[MediumSpace]\"", 
               StyleBox[
               "\"mean density inside the Schwarzschild radius of a \
supermassive black hole\"", {
                FontFamily -> "Roboto", FontSize -> 0.9 Inherited, 
                 LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                 0}], 
               TemplateBox[{"\" \"", 
                 StyleBox[
                  RowBox[{"\"(\"", "\[NoBreak]", 
                    
                    TemplateBox[{
                    "\"\[MediumSpace]\[TildeTilde]\[ThinSpace]\"", 
                    StyleBox[
                    TagBox[
                    TagBox[
                    TagBox[
                    RowBox[{
                    TagBox["20", 
                    $CellContext`TagBoxWrapper[
                    "StringBoxes" -> "20", "SRString" -> "20"]], "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], {
                    FontFamily -> "Roboto", FontSize -> 10, 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0}], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    
                    RowBox[{"\"kg\"", "\[InvisibleSpace]", "\"/\"", 
                    "\[InvisibleSpace]", 
                    SuperscriptBox["\"m\"", "3"]}], {
                    FontFamily -> "Roboto", FontSize -> 10, 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0}]}], Identity], #& , SyntaxForm -> Dot], "Unit", 
                    SyntaxForm -> Dot], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, ZeroWidthTimes -> False], "\"\[MediumSpace]\""}, 
                    "RowDefault"], "\[NoBreak]", "\")\""}], {
                  FontFamily -> "Roboto", FontSize -> 10, 
                   GrayLevel[0.5], 
                   LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                   0}]}, "RowDefault"]}, "RowDefault"], TraditionalForm], 
            TraditionalForm]], "Output", {
          Background -> None, 
           GraphicsBoxOptions -> {
            DefaultBaseStyle -> {FontFamily -> "Times", "Graphics"}, 
             DefaultAxesStyle -> Directive[
               GrayLevel[0, 0.35], FontColor -> GrayLevel[0.25], FontOpacity -> 
               1, "GraphicsAxes"], DefaultFrameStyle -> Directive[
               GrayLevel[0, 0.35], FontColor -> GrayLevel[0.25], FontOpacity -> 
               1, "GraphicsFrame"], DefaultFrameTicksStyle -> 
             Directive[
              FontFamily -> "Times", FontSize -> 10, "GraphicsFrameTicks"], 
             DefaultTicksStyle -> 
             Directive[
              FontFamily -> "Times", FontSize -> 10, "GraphicsTicks"]}, 
           Graphics3DBoxOptions -> {
            DefaultBaseStyle -> {FontFamily -> "Times", "Graphics3D"}}}, 
          NumberPoint -> ".", CellSize -> {550, Automatic}, 
          AutoStyleOptions -> {"HighlightFormattingErrors" -> False}, 
          RenderingOptions -> {
           "3DRenderingMethod" -> "BSPTreeOrDepthBuffer"}]}], 
       XMLElement["dataformats", {}, {"plaintext"}]}], 
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement["cell", {"compressed" -> False, "string" -> True}, {
         Cell[
          BoxData[
           FormBox[
            FormBox[
             TemplateBox[{"\" \[TildeTilde] \"", "50", "\" \"", 
               StyleBox[
                StyleBox["\"\[Times]\"", {
                  GrayLevel[0.6], LinebreakAdjustments -> {1, 100, 1, 0, 100},
                   LineIndent -> 0}], FontSize -> 10.219999999999999`, 
                StripOnInput -> False], "\"\[MediumSpace]\"", 
               StyleBox[
               "\"density achievable from a mechanical vacuum pump\"", {
                FontFamily -> "Roboto", FontSize -> 0.9 Inherited, 
                 LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                 0}], 
               TemplateBox[{"\" \"", 
                 StyleBox[
                  RowBox[{"\"(\"", "\[NoBreak]", 
                    
                    TemplateBox[{
                    "\"\[MediumSpace]\[TildeTilde]\[ThinSpace]\"", 
                    StyleBox[
                    TagBox[
                    TagBox[
                    TagBox[
                    RowBox[{
                    TagBox["1", 
                    $CellContext`TagBoxWrapper[
                    "StringBoxes" -> "1", "SRString" -> "1"]], "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], {
                    FontFamily -> "Roboto", FontSize -> 10, 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0}], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    
                    RowBox[{"\"g\"", "\[InvisibleSpace]", "\"/\"", 
                    "\[InvisibleSpace]", 
                    SuperscriptBox["\"m\"", "3"]}], {
                    FontFamily -> "Roboto", FontSize -> 10, 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0}]}], Identity], #& , SyntaxForm -> Dot], "Unit", 
                    SyntaxForm -> Dot], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, ZeroWidthTimes -> False], "\"\[MediumSpace]\""}, 
                    "RowDefault"], "\[NoBreak]", "\")\""}], {
                  FontFamily -> "Roboto", FontSize -> 10, 
                   GrayLevel[0.5], 
                   LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                   0}]}, "RowDefault"]}, "RowDefault"], TraditionalForm], 
            TraditionalForm]], "Output", {
          Background -> None, 
           GraphicsBoxOptions -> {
            DefaultBaseStyle -> {FontFamily -> "Times", "Graphics"}, 
             DefaultAxesStyle -> Directive[
               GrayLevel[0, 0.35], FontColor -> GrayLevel[0.25], FontOpacity -> 
               1, "GraphicsAxes"], DefaultFrameStyle -> Directive[
               GrayLevel[0, 0.35], FontColor -> GrayLevel[0.25], FontOpacity -> 
               1, "GraphicsFrame"], DefaultFrameTicksStyle -> 
             Directive[
              FontFamily -> "Times", FontSize -> 10, "GraphicsFrameTicks"], 
             DefaultTicksStyle -> 
             Directive[
              FontFamily -> "Times", FontSize -> 10, "GraphicsTicks"]}, 
           Graphics3DBoxOptions -> {
            DefaultBaseStyle -> {FontFamily -> "Times", "Graphics3D"}}}, 
          NumberPoint -> ".", CellSize -> {550, Automatic}, 
          AutoStyleOptions -> {"HighlightFormattingErrors" -> False}, 
          RenderingOptions -> {
           "3DRenderingMethod" -> "BSPTreeOrDepthBuffer"}]}], 
       XMLElement["dataformats", {}, {"plaintext"}]}], 
     XMLElement["expressiontypes", {"count" -> "2"}, {"\n   ", 
       XMLElement["expressiontype", {"name" -> "Default"}, {}], "\n   ", 
       XMLElement["expressiontype", {"name" -> "Default"}, {}], "\n  "}]}], 
   Typeset`aux1$$ = {True, False, {False}, True}, Typeset`aux2$$ = {
   True, False, {False, False}, True}, Typeset`aux3$$ = {
   True, False, {False, False, False}, True}, Typeset`aux4$$ = {
   True, False, {False, False}, True}, Typeset`asyncpods$$ = {}, 
   Typeset`nonpods$$ = {
    XMLElement["assumptions", {"count" -> "2"}, {
      XMLElement[
      "assumption", {
       "type" -> "Unit", "word" -> "point", "template" -> 
        "Assuming percentage points for \"point\"${separator}Use ${desc} or \
${pulldown} instead", "count" -> "5", "pulldown" -> "true", "pulldownlabel" -> 
        "more >>", "pulldownlength" -> "3", "default" -> 
        "\"UnitClash\" -> {\"point\", {\"PercentagePoints\", \"dflt\"}}"}, {
        XMLElement[
        "value", {
         "name" -> "PercentagePoints", "desc" -> "percentage points", "input" -> 
          "\"UnitClash\" -> {\"point\", {\"PercentagePoints\"}}"}, {}], 
        XMLElement[
        "value", {
         "name" -> "DesktopPublishingPoints", "desc" -> 
          "desktop publishing points", "input" -> 
          "\"UnitClash\" -> {\"point\", {\"DesktopPublishingPoints\"}}"}, {}], 
        XMLElement[
        "value", {
         "name" -> "JohnsonPoints", "desc" -> "Johnson points", "input" -> 
          "\"UnitClash\" -> {\"point\", {\"JohnsonPoints\"}}"}, {}], 
        XMLElement[
        "value", {
         "name" -> "DataPoints", "desc" -> "data points", "input" -> 
          "\"UnitClash\" -> {\"point\", {\"DataPoints\"}}"}, {}], 
        XMLElement[
        "value", {
         "name" -> "CaratPoints", "desc" -> "carat points", "input" -> 
          "\"UnitClash\" -> {\"point\", {\"CaratPoints\"}}"}, {}]}], 
      XMLElement[
      "assumption", {
       "type" -> "ListOrTimes", "word" -> "", "template" -> 
        "Assuming multiplication${separator}Use ${desc} instead", "count" -> 
        "2", "pulldown" -> "false", "default" -> 
        "\"ListOrTimes\" -> \"Times\""}, {
        XMLElement[
        "value", {
         "name" -> "Times", "desc" -> "multiplication", "input" -> 
          "\"ListOrTimes\" -> \"Times\""}, {}], 
        XMLElement[
        "value", {
         "name" -> "List", "desc" -> "a list", "input" -> 
          "\"ListOrTimes\" -> \"List\""}, {}]}]}], 
    XMLElement["sources", {"count" -> "2"}, {
      XMLElement[
      "source", {
       "url" -> 
        "https://www6b3.wolframalpha.com/sources/\
ChemicalDataSourceInformationNotes.html", "text" -> "Chemical data"}, {}], 
      XMLElement[
      "source", {
       "url" -> 
        "https://www6b3.wolframalpha.com/sources/\
ThermodynamicDataSourceInformationNotes.html", "text" -> 
        "Thermodynamic data"}, {}]}]}, Typeset`initdone$$ = 
   FrontEnd`SuppressEvaluationHash[True], Typeset`queryinfo$$ = {
   "success" -> "true", "error" -> 
    "false", {"http://www.w3.org/XML/1998/namespace", "space"} -> "preserve", 
    "numpods" -> "4", "datatypes" -> "Chemical,Math,Thermodynamic", 
    "timedout" -> "", "timedoutpods" -> "", "timing" -> "1.25", "parsetiming" -> 
    "0.541", "parsetimedout" -> "false", "recalculate" -> "", "id" -> 
    "MSP4111hca0g9d8g4a3023000014fa9bdiffi4e3ag", "host" -> 
    "https://www6b3.wolframalpha.com", "server" -> "10", "related" -> 
    "https://www6b3.wolframalpha.com/api/v1/relatedQueries.jsp?id=\
MSPa4121hca0g9d8g4a30230000371fgfd0fcg4gh613142019838491228908", "version" -> 
    "2.6", "inputstring" -> "triple point gas density of argon"}, 
   Typeset`sessioninfo$$ = {
   "TimeZone" -> 1., 
    "Date" -> {2023, 11, 28, 14, 4, 53.8118872`9.48345306776008}, "Line" -> 
    12, "SessionID" -> 28650755250118511663}, Typeset`showpods$$ = {1, 2, 3, 
   4}, Typeset`failedpods$$ = {}, Typeset`chosen$$ = {
   "Result", "Results", 1, 2, "Output", 
    "Quantity[0.04902, \"Kilograms\"/\"Meters\"^3]"}, Typeset`open$$ = True, 
   Typeset`newq$$ = "triple point gas density of argon "}, 
   DynamicBox[ToBoxes[
     AlphaIntegration`FormatAlphaResults[
      Dynamic[{
       1, {Typeset`pod1$$, Typeset`pod2$$, Typeset`pod3$$, Typeset`pod4$$}, {
        Typeset`aux1$$, Typeset`aux2$$, Typeset`aux3$$, Typeset`aux4$$}, 
        Typeset`chosen$$, Typeset`open$$, Typeset`elements$$, Typeset`q$$, 
        Typeset`opts$$, Typeset`nonpods$$, Typeset`queryinfo$$, 
        Typeset`sessioninfo$$, Typeset`showpods$$, Typeset`failedpods$$, 
        Typeset`newq$$}]], StandardForm],
    ImageSizeCache->{560., {681., 19.}},
    TrackedSymbols:>{Typeset`showpods$$, Typeset`failedpods$$}],
   DynamicModuleValues:>{},
   Initialization:>If[
     And[
      Not[Typeset`initdone$$ === True], 
      Not[Typeset`initdone$$ === FrontEnd`SuppressEvaluationHash[True]]], 
     Null; WolframAlphaClient`Private`doAsyncUpdates[
       Hold[{Typeset`pod1$$, Typeset`pod2$$, Typeset`pod3$$, Typeset`pod4$$}],
        Typeset`asyncpods$$, 
       Dynamic[Typeset`failedpods$$]]; Typeset`asyncpods$$ = {}; 
     Typeset`initdone$$ = FrontEnd`SuppressEvaluationHash[True]],
   SynchronousInitialization->False],
  BaseStyle->{Deployed -> True},
  DeleteWithContents->True,
  Editable->False,
  SelectWithContents->True]], "WolframAlphaShortInput",
 CellLabel->"In[12]:=",
 CellID->529056361,ExpressionUUID->"87dc4754-8a69-4309-96e1-7db3a6ee74d9"],

Cell[BoxData[
 InterpretationBox[
  FrameBox[
   StyleBox[
    FormBox[
     StyleBox[
      StyleBox[
       RowBox[{
       "0.04902", "\[NoBreak]", "\[InvisibleSpace]", "\[ThickSpace]", 
        "\[InvisibleSpace]", 
        StyleBox[
         RowBox[{"\<\"kg\"\>", "\[InvisibleSpace]", "\<\"/\"\>", 
          "\[InvisibleSpace]", 
          SuperscriptBox["\<\"m\"\>", "3"]}],
         LineIndent->0,
         LinebreakAdjustments->{1, 100, 1, 0, 100},
         FontFamily->"Roboto",
         FontSize->0.9 Inherited], "  ", 
        StyleBox[
         RowBox[{"\<\"(\"\>", 
          "\[NoBreak]", "\<\"kilograms per cubic meter\"\>", 
          "\[NoBreak]", "\<\")\"\>"}],
         LineIndent->0,
         LinebreakAdjustments->{1, 100, 1, 0, 100},
         LineColor->GrayLevel[0.6],
         FrontFaceColor->GrayLevel[0.6],
         BackFaceColor->GrayLevel[0.6],
         GraphicsColor->GrayLevel[0.6],
         FontFamily->"Roboto",
         FontSize->0.9 Inherited,
         FontColor->GrayLevel[0.6]]}], "Unit"],
      ZeroWidthTimes->False,
      LineIndent->0,
      LinebreakAdjustments->{1, 100, 1, 0, 100}],
     TraditionalForm], "Output",
    CellSize->{550, Automatic},
    AutoStyleOptions->{"HighlightFormattingErrors"->False},
    ScriptLevel->0,
    NumberPoint->".",
    RenderingOptions->{"3DRenderingMethod"->"BSPTreeOrDepthBuffer"},
    FontFamily->"Times",
    FontSize->14,
    Background->None,
    GraphicsBoxOptions->{DefaultAxesStyle->Directive[
      GrayLevel[0, 0.35], FontColor -> GrayLevel[0.25], FontOpacity -> 1, 
      "GraphicsAxes"],
    DefaultBaseStyle->{FontFamily -> "Times", "Graphics"},
    DefaultFrameStyle->Directive[
      GrayLevel[0, 0.35], FontColor -> GrayLevel[0.25], FontOpacity -> 1, 
      "GraphicsFrame"],
    DefaultFrameTicksStyle->Directive[
     FontFamily -> "Times", FontSize -> 10, "GraphicsFrameTicks"],
    DefaultTicksStyle->Directive[
     FontFamily -> "Times", FontSize -> 10, "GraphicsTicks"]},
    Graphics3DBoxOptions->{
    DefaultBaseStyle->{FontFamily -> "Times", "Graphics3D"}}],
   BaseStyle->{Plain},
   FrameMargins->10,
   FrameStyle->GrayLevel[0.85],
   RoundingRadius->5,
   StripOnInput->False],
  WolframAlphaResult[
  "triple point gas density of argon ", {{"Result", 1}, 
    "Content"}]]], "Output",
 CellLabel->"Out[12]=",
 CellID->498312631,ExpressionUUID->"e19de0bf-c392-491e-8004-ad6e62b111ff"]
}, Open  ]],

Cell["Using ThermodynamicData package (i.e. REFPROP from NIST)", "ExampleText",
 CellID->361149294,ExpressionUUID->"aa1b0e95-1dab-4188-a811-d49aa0ec5b8a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UnitConvert", "[", 
  RowBox[{
   RowBox[{"ThermodynamicData", "[", 
    RowBox[{"\"\<Argon\>\"", ",", "\"\<TriplePointGasDensity\>\""}], "]"}], 
   ",", 
   FractionBox["\"\<Grams\>\"", 
    SuperscriptBox["\"\<Centimeters\>\"", "3"]]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->305288497,ExpressionUUID->"8e3ef3b7-67d8-42bd-a2ae-64ad7063ae21"],

Cell[BoxData[
 TemplateBox[{"0.00405458`6.", 
   RowBox[{"\"g\"", "\[InvisibleSpace]", "\"/\"", "\[InvisibleSpace]", 
     SuperscriptBox["\"cm\"", "3"]}], "grams per centimeter cubed", 
   FractionBox["\"Grams\"", 
    SuperscriptBox["\"Centimeters\"", "3"]]},
  "Quantity"]], "Output",
 CellLabel->"Out[5]=",
 CellID->15690842,ExpressionUUID->"1c8ca208-7408-412a-a21f-aecd12920c0e"]
}, Open  ]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"}, 
  Closed]]]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "PrimaryExamplesSection"}, 
  Closed]]]],

Cell[BoxData[GridBox[{
   {
    DynamicBox[FEPrivate`ImportImage[
      FrontEnd`FileName[{"Documentation", "FooterIcons"}, 
       "RelatedFunction.png"]],
     ImageSizeCache->{50., {27., 33.}}], GridBox[{
      {
       StyleBox[
        RowBox[{"See", " ", "Also"}], "SeeAlsoSection"]},
      {Cell[TextData[{
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["vtrgaz"]], "paclet:NewEoSArgon/ref/vtrgaz", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "71178113-99b8-4f9d-b772-35fa03f5a2cb"],
        "\[NonBreakingSpace]",
        StyleBox[
        "\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
         "InlineSeparator"],
        " ",
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["ttr"]], "paclet:NewEoSArgon/ref/ttr", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "3bebabd3-a186-4c30-8f95-e2e1ead2a929"],
        "\[NonBreakingSpace]",
        StyleBox[
        "\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
         "InlineSeparator"],
        " ",
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["ptr"]], "paclet:NewEoSArgon/ref/ptr", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "6ca1d42c-6b55-4d8c-9c4d-b2f21e65731f"],
        "\[NonBreakingSpace]",
        StyleBox[
        "\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
         "InlineSeparator"],
        " ",
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["rhotrliq"]], "paclet:NewEoSArgon/ref/rhotrliq", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "ed60dc11-2c2a-4314-8598-2f0891369326"],
        "\[NonBreakingSpace]",
        StyleBox[
        "\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
         "InlineSeparator"],
        " ",
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["vtrliq"]], "paclet:NewEoSArgon/ref/vtrliq", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "8cf17b8d-cc8f-469d-a932-c9a2c3e1fd0f"]
       }], "SeeAlso",ExpressionUUID->"cc802a3b-7cdc-402e-a489-f867cd76a892"]}
     }]}
  }]], "SeeAlsoSection",ExpressionUUID->"d93f192e-6c25-45b2-ba85-\
09355659abfc"],

Cell[BoxData[GridBox[{
   {
    DynamicBox[FEPrivate`ImportImage[
      FrontEnd`FileName[{"Documentation", "FooterIcons"}, "RelatedGuide.png"]],
     ImageSizeCache->{50., {27., 33.}}], GridBox[{
      {
       StyleBox[
        RowBox[{"Related", " ", "Guides"}], "MoreAboutSection"]},
      {
       RowBox[{"\[FilledVerySmallSquare]", Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["NewEoSArgon Package"]], 
           "paclet:NewEoSArgon/guide/NewEoSArgon"},
          "RefLinkPlain",
          BaseStyle->{"MoreAbout"}]], "MoreAbout",ExpressionUUID->
         "8c78597c-7899-4d86-86d1-f13001d58ba0"]}]}
     }]}
  }]], "MoreAboutSection",ExpressionUUID->"bed3e1fd-5f2a-4842-a47f-\
61260b3e69a5"],

Cell[BoxData[GridBox[{
   {
    TemplateBox[{29},
     "Spacer1"], GridBox[{
      {
       RowBox[{
        TemplateBox[{17},
         "Spacer1"], 
        StyleBox[
         RowBox[{"Related", " ", "Links"}], "RelatedLinksSection"]}]},
      {Cell[BoxData[Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData[
             RowBox[{
               RowBox[{"Units", " ", "&"}], " ", "Quantities"}]]], 
           "paclet:guide/Units"},
          "RefLinkPlain",
          BaseStyle->{"RelatedLinks"}]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "e69a837d-88e0-47aa-af19-47cbc146c47e"]], "RelatedLinks",
        ExpressionUUID->"354dd8aa-82e9-4ea8-9051-02c5d756bf3d"]},
      {Cell[BoxData[Cell[BoxData[Cell[BoxData[
          RowBox[{
           TemplateBox[{16},
            "Spacer1"], "\[FilledVerySmallSquare]", 
           TemplateBox[{
             Cell[
              TextData[
               Cell[
                TextData[{
                  Cell[
                   BoxData[
                    TemplateBox[{2}, "Spacer1"]]], "ThermodynamicData"}]]]], 
             "paclet:ref/ThermodynamicData"},
            "RefLink",
            BaseStyle->{"RelatedLinks"}]}]],ExpressionUUID->
          "a9d4567b-174e-47b8-97f4-b3700196551b"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "8ac81e71-5e60-4f06-bddf-5f0a6a077bbd"]], "RelatedLinks",
        ExpressionUUID->"81cd891e-bb67-49e0-97f2-4f906d5bb06f"]},
      {Cell[TextData[Cell[BoxData[
        RowBox[{
         TemplateBox[{16},
          "Spacer1"], "\[FilledVerySmallSquare]", Cell[BoxData[
          TemplateBox[{
            Cell[
             TextData[
              Cell[
               TextData[{
                 Cell[
                  BoxData[
                   TemplateBox[{2}, "Spacer1"]]], 
                 "Webbook de chimie NIST"}]]]], 
            "http://webbook.nist.gov/chemistry/fluid/"},
           "WebLink",
           BaseStyle->{"RelatedLinks"}]],ExpressionUUID->
          "e19df9cf-1171-457c-b7f2-47f90b918bdb"]}]],ExpressionUUID->
        "c4143be8-f078-459d-b990-e8288555a8dd"]], "RelatedLinks",
        ExpressionUUID->"693f18ca-6d91-44b5-8b8d-8b21ea45ca75"]}
     }]}
  }]], "RelatedLinksSection",ExpressionUUID->"84f97285-4506-4f87-b806-\
517972639cbe"],

Cell[" ", "FooterCell",ExpressionUUID->"38b5073d-f400-41b9-8971-6ee21c98f606"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{900, 835.8},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"rhotrgaz [\[Rho]trgaz]",
TaggingRules->{
 "ModificationHighlight" -> False, "ColorType" -> "", "LinkTrails" -> "", 
  "HasOptions" -> True, "ExampleCounter" -> 1, 
  "Openers" -> {
   "PrimaryExamplesSection" -> Open, "ExampleSection" -> {"0" -> Open}, 
    "NotesSection" -> Closed}, "NewStyles" -> True, 
  "CitationPopupData" -> $Failed, "ShowCitation" -> False, "RootCaptions" -> 
  "", "Metadata" -> {
   "built" -> "{2023, 11, 30, 13, 56, 3.1537866}", 
    "history" -> {"XX", "", "", ""}, "context" -> "NewEoSArgon`", 
    "keywords" -> {}, "specialkeywords" -> {}, 
    "tutorialcollectionlinks" -> {}, "index" -> True, "label" -> 
    "New Eo S Argon Package Symbol", "language" -> "en", "paclet" -> 
    "NewEoSArgon Package", "status" -> "None", "summary" -> 
    "rhotrgaz (g/cm^3) Densit\[EAcute] du gaz au point triple de l'argon donn\
\[EAcute]e par NIST [Triple point gas density of argon from NIST]", 
    "synonyms" -> {}, "tabletags" -> {}, "title" -> "rhotrgaz [\[Rho]trgaz]", 
    "titlemodifier" -> "", "metadescription" -> "", "windowtitle" -> 
    "rhotrgaz [\[Rho]trgaz]", "type" -> "Symbol", "uri" -> 
    "NewEoSArgon/ref/rhotrgaz"}},
CellContext->"Global`",
FrontEndVersion->"13.3 pour Microsoft Windows (64-bit) (July 24, 2023)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "13.3 pour Microsoft Windows (64-bit) (July 24, 2023)", 
  StyleDefinitions -> "Default.nb"],
ExpressionUUID->"56f94df2-c231-40f9-a514-6b8770c5fc53"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[11560, 311, 1420, 37, 35, "PrimaryExamplesSection",ExpressionUUID->"9cf55fbf-129d-4cff-b943-866092bc0809",
   CellTags->"PrimaryExamplesSection",
   CellID->455893982]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 70077, 1623}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[594, 21, 5535, 133, 56, "AnchorBarGrid",ExpressionUUID->"983742d9-6a9a-47ea-be2b-04e402c2320e",
 CellID->1],
Cell[6132, 156, 94, 0, 23, "ContextNameCell",ExpressionUUID->"2ee595a1-555d-4ca7-801a-24c87aa103eb"],
Cell[CellGroupData[{
Cell[6251, 160, 565, 14, 56, "ObjectNameGrid",ExpressionUUID->"5c91bafb-78d9-44ed-87f5-91f298b61584"],
Cell[6819, 176, 808, 20, 146, "Usage",ExpressionUUID->"2a6f4ef7-b569-4918-aa4d-e968a95a3026"]
}, Open  ]],
Cell[CellGroupData[{
Cell[7664, 201, 1919, 48, 37, "NotesSection",ExpressionUUID->"a2a6d702-475c-4a34-afa7-75679b8d6658",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->221388201],
Cell[9586, 251, 832, 23, 38, "Notes",ExpressionUUID->"0c0ead95-819e-47b6-a391-3b7c6048d4f6",
 CellID->1067943069],
Cell[10421, 276, 185, 4, 36, "Notes",ExpressionUUID->"ee1f834e-ec84-442a-9e22-2eac72858d20",
 CellID->185021568],
Cell[10609, 282, 824, 23, 38, "Notes",ExpressionUUID->"618ce1bf-87f2-42f7-9ded-bbef593952bc",
 CellID->489383078]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "NotesSection"}, Closed]]]],
Cell[CellGroupData[{
Cell[11560, 311, 1420, 37, 35, "PrimaryExamplesSection",ExpressionUUID->"9cf55fbf-129d-4cff-b943-866092bc0809",
 CellTags->"PrimaryExamplesSection",
 CellID->455893982],
Cell[CellGroupData[{
Cell[13005, 352, 1395, 36, 30, "ExampleSection",ExpressionUUID->"b26aa42f-3983-4a88-ae67-81d271a75e69",
 CellID->330640],
Cell[14403, 390, 174, 3, 26, "Input",ExpressionUUID->"7d47f9c7-c432-4ce3-8649-a5708d6e3e6c",
 CellID->87419684],
Cell[14580, 395, 139, 1, 38, "ExampleText",ExpressionUUID->"7fafdf7b-1ba7-41be-adbd-3e3476db3086",
 CellID->886239600],
Cell[CellGroupData[{
Cell[14744, 400, 204, 4, 26, "Input",ExpressionUUID->"a4fac448-a6a6-429b-bfb2-f91bdc1e1124",
 CellID->21488140],
Cell[14951, 406, 393, 8, 45, "Output",ExpressionUUID->"0f8070cd-4d57-403a-9f69-dc2dee013417",
 CellID->36001421]
}, Open  ]],
Cell[CellGroupData[{
Cell[15381, 419, 874, 23, 30, "Input",ExpressionUUID->"642c8b54-bdd3-472f-8c8e-4331752a1bd2",
 CellID->1017974],
Cell[16258, 444, 388, 8, 45, "Output",ExpressionUUID->"d4456e60-82ba-4fdd-8804-6c919e30ecdd",
 CellID->875135877]
}, Open  ]],
Cell[16661, 455, 142, 1, 38, "ExampleText",ExpressionUUID->"f9ac8c33-2eaa-4829-8bb9-0f330b502d14",
 CellID->278961620],
Cell[CellGroupData[{
Cell[16828, 460, 297, 7, 26, "Input",ExpressionUUID->"ed0ea4b1-b7c8-4b2e-a2c8-261d1199cd48",
 CellID->295872759],
Cell[17128, 469, 393, 8, 45, "Output",ExpressionUUID->"dccb3e63-849e-4d62-9bce-f0c66786c557",
 CellID->95049339]
}, Open  ]],
Cell[17536, 480, 116, 1, 38, "ExampleText",ExpressionUUID->"23251533-7656-4b14-8cca-46616c4cc135",
 CellID->351008126],
Cell[CellGroupData[{
Cell[17677, 485, 40772, 824, 717, "WolframAlphaShortInput",ExpressionUUID->"87dc4754-8a69-4309-96e1-7db3a6ee74d9",
 CellID->529056361],
Cell[58452, 1311, 2395, 65, 62, "Output",ExpressionUUID->"e19de0bf-c392-491e-8004-ad6e62b111ff",
 CellID->498312631]
}, Open  ]],
Cell[60862, 1379, 154, 1, 70, "ExampleText",ExpressionUUID->"aa1b0e95-1dab-4188-a811-d49aa0ec5b8a",
 CellID->361149294],
Cell[CellGroupData[{
Cell[61041, 1384, 377, 9, 70, "Input",ExpressionUUID->"8e3ef3b7-67d8-42bd-a2ae-64ad7063ae21",
 CellID->305288497],
Cell[61421, 1395, 384, 8, 45, "Output",ExpressionUUID->"1c8ca208-7408-412a-a21f-aecd12920c0e",
 CellID->15690842]
}, Open  ]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"}, Closed]]]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "PrimaryExamplesSection"}, Closed]]]],
Cell[62047, 1412, 2892, 78, 70, "SeeAlsoSection",ExpressionUUID->"d93f192e-6c25-45b2-ba85-09355659abfc"],
Cell[64942, 1492, 729, 19, 70, "MoreAboutSection",ExpressionUUID->"bed3e1fd-5f2a-4842-a47f-61260b3e69a5"],
Cell[65674, 1513, 2350, 62, 70, "RelatedLinksSection",ExpressionUUID->"84f97285-4506-4f87-b806-517972639cbe"],
Cell[68027, 1577, 78, 0, 70, "FooterCell",ExpressionUUID->"38b5073d-f400-41b9-8971-6ee21c98f606"]
}
]
*)

(* End of internal cache information *)

