(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 13.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     23263,        612]
NotebookOptionsPosition[     18201,        507]
NotebookOutlinePosition[     20469,        563]
CellTagsIndexPosition[     20384,        558]
WindowTitle->rhotrgazNv [\:03C1trgazNv]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[GridBox[{
   {GridBox[{
      {
       ItemBox[Cell[BoxData[
         RowBox[{
          TemplateBox[{12},
           "Spacer1"], Cell["NEW EO S ARGON PACKAGE SYMBOL", "PacletNameCell",
           TextAlignment->Center,ExpressionUUID->
           "aace4738-ceaf-4ac0-9035-3debbca0a3f9"], 
          TemplateBox[{8},
           "Spacer1"]}]],
         TextAlignment->Center,ExpressionUUID->
         "7441301e-d80f-4048-be89-450cf4cfa6c0"],
        Background->RGBColor[0.490196, 0.576471, 0.690196],
        ItemSize->Full], ""}
     },
     GridBoxAlignment->{"Rows" -> {{Center}}},
     GridBoxItemSize->{"Columns" -> {Full, 
         Scaled[0.02]}, "Rows" -> {{2.5}}}], Cell[TextData[{
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "See Also",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "befb4bc0-d676-4c62-9d65-03d43059bccf"]
         }],ExpressionUUID->"a1d31d0f-0ba2-4c2a-a723-45aaf7e538f7"],
         StripOnInput->False],{
        "\"ttr\"" :> Documentation`HelpLookup["paclet:NewEoSArgon/ref/ttr"], 
         "\"ptrNv\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/ptrNv"], 
         "\"rhotrliqNv\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/rhotrliqNv"]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"SeeAlso"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "c071701a-ee68-4caa-9be6-d3b090397729"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "Related Guides",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "d398939a-0015-409f-b430-ebe85d778176"]
         }],ExpressionUUID->"ca45432a-cd39-4267-9778-a0fa57c824e8"],
         StripOnInput->False],{
        "\"NewEoSArgon Package\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/guide/NewEoSArgon"]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"MoreAbout"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "3d273168-39ce-416f-9da2-70b2fe05f4d0"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "URL",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "7a2db99f-33a2-4d34-9124-f00821a0524e"]
         }],ExpressionUUID->"5781394d-f944-41dd-96fa-8df8d1ee8676"],
         StripOnInput->False],{
        "\"NewEoSArgon/ref/rhotrgazNv\"" :> None, 
         "\"Copy Wolfram Documentation Center URL\"" :> 
         Module[{DocumentationSearch`Private`nb$}, 
           DocumentationSearch`Private`nb$ = 
            NotebookPut[
             Notebook[{Cell["NewEoSArgon/ref/rhotrgazNv"]}, Visible -> 
               False]]; 
           SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
           FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
           NotebookClose[DocumentationSearch`Private`nb$]; Null], Delimiter, 
         "\"Copy web URL\"" :> 
         Module[{DocumentationSearch`Private`nb$}, 
           DocumentationSearch`Private`nb$ = 
            NotebookPut[
             Notebook[{
               Cell[BoxData[
                 MakeBoxes[
                  Hyperlink[
                   "http://reference.wolfram.com/language/NewEoSArgon/ref/\
rhotrgazNv.html"], StandardForm]], "Input", TextClipboardType -> 
                 "PlainText"]}, Visible -> False]]; 
           SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
           FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
           NotebookClose[DocumentationSearch`Private`nb$]; Null], 
         "\"Go to web URL\"" :> 
         FrontEndExecute[{
           NotebookLocate[{
             URL[If[TrueQ[DocumentationBuild`Make`Private`wsmlinkQ$27429], 
                 "http://reference.wolfram.com/system-modeler/", 
                 "http://reference.wolfram.com/language/"] <> 
               "NewEoSArgon/ref/rhotrgazNv" <> ".html"], None}]}]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"URLMenu"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "bbaab944-0bf9-44b1-9048-db89fdf3f7c6"]
    }], "AnchorBar",
     CacheGraphics->False,ExpressionUUID->
     "bf994713-1b7c-4eed-96dc-77f1b5058319"]}
  }]], "AnchorBarGrid",
 CellID->1,ExpressionUUID->"60e05248-f938-4488-b241-ec44cb4ce455"],

Cell["NewEoSArgon`", "ContextNameCell",ExpressionUUID->"f4e48517-5304-49fc-b0fe-128a67f02462"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     Cell[
     "rhotrgazNv [\[Rho]trgazNv]", "ObjectName",ExpressionUUID->
      "27b715c8-c0f8-4601-b591-ff0adf29f183"],
     Cell[BoxData[
      TemplateBox[{8},
       "Spacer1"]],ExpressionUUID->"b5b4db2b-25c6-40ce-8a3c-bbf7d0e46c3a"],
     Cell[BoxData[
     ""], "ObjectNameTranslation",ExpressionUUID->
      "e50a8945-1848-4cee-93c9-b806a0125145"]
    }],ExpressionUUID->"fbfa01a6-6f11-4b97-ad03-85fb6ea88d8b"], 
    "\[SpanFromLeft]"}
  }]], "ObjectNameGrid",ExpressionUUID->"d2667339-9b8c-4c5b-bed6-\
abf5d1f96736"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["rhotrgazNv"], "InlineFormula",
      ShowStringCharacters->False,
      FontFamily->"Source Sans Pro",ExpressionUUID->
      "1525ffe7-239f-4110-9895-7866fefcefff"],
     " (g/",
     Cell[BoxData[
      SuperscriptBox["cm", "3"]], "InlineFormula",
      FontFamily->"Source Sans Pro",ExpressionUUID->
      "63bc9a28-8784-44b6-b70b-5ff7843f6a56"],
     ")\nDensit\[EAcute] du ",
     StyleBox["gaz",
      FontSlant->"Italic"],
     " au point triple de l'argon d\[EAcute]duite des relations de Maxwell \n\
[Triple point ",
     StyleBox["gas",
      FontSlant->"Italic"],
     " density of argon from Maxwell relations]"
    }],ExpressionUUID->"a2232d27-d9d2-4d94-9a15-eb047464e46a"]}
  }]], "Usage",
 Deletable->True,ExpressionUUID->"8843f182-8feb-4d5b-90d4-c243775d778c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {
       TaggingRules, "Openers", "PrimaryExamplesSection"}, Open], 
      Alternatives[True, Open]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{13.600000000000001`, {5., 8.600000000000001}}]],
  ExpressionUUID->"947e1e61-568f-4c59-ae31-ae67599fb2ae"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"74567681-25fa-42e7-933a-c13f41900a44"],
 "Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "81d85a58-0dc4-4388-bd3c-ae50c491ecf4"]
}], "PrimaryExamplesSection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellTags->"PrimaryExamplesSection",
 CellID->1012398660,ExpressionUUID->"8a825aae-cd61-47c5-9c9e-f7d490da6502"],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"},
        Closed], 
      Alternatives[Open, True]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{13.600000000000001`, {5., 8.600000000000001}}]],
  ExpressionUUID->"140caeb0-fb6e-45f8-b24b-6c54ef1c187b"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"00a6af9c-43b5-429c-a34f-df18f2b2cfe8"],
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "8404aafc-a495-4a71-8e9d-c09a3ac5cb40"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellID->11818053,ExpressionUUID->"95ec0f14-d12a-4462-8766-20e5bfe59913"],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<NewEoSArgon`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->87419684,ExpressionUUID->"6b078ab6-e1b6-47bf-914b-0e96fd8955a2"],

Cell["Give a physical dimension to the constant", "ExampleText",
 CellID->886239600,ExpressionUUID->"63b034e2-868e-489d-8682-9ce7b7b02256"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Quantity", "[", 
  RowBox[{"\[Rho]trgazNv", ",", "\"\<g/cm^3\>\""}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->21488140,ExpressionUUID->"505057d3-6881-4fac-a6f8-84e1f8b011e3"],

Cell[BoxData[
 TemplateBox[{"0.00405911915480945`", 
   RowBox[{"\"g\"", "\[InvisibleSpace]", "\"/\"", "\[InvisibleSpace]", 
     SuperscriptBox["\"cm\"", "3"]}], "grams per centimeter cubed", 
   FractionBox["\"Grams\"", 
    SuperscriptBox["\"Centimeters\"", "3"]]},
  "Quantity"]], "Output",
 CellLabel->"Out[2]=",
 CellID->315646393,ExpressionUUID->"7d4b661e-4222-4527-9fab-9e9161629ebf"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UnitConvert", "[", 
  RowBox[{
   TemplateBox[{"0.00405911915480945`"},
    "QuantityUnit",
    DisplayFunction->(TooltipBox[
      StyleBox[
       RowBox[{#, "\[InvisibleSpace]", 
         StyleBox[
          RowBox[{" ", 
            
            RowBox[{"\"g\"", "\[InvisibleSpace]", "\"/\"", 
              "\[InvisibleSpace]", 
              SuperscriptBox["\"cm\"", "3"]}]}], 
          "QuantityUnitTraditionalLabel"]}], ShowStringCharacters -> False], 
      "Unit: grams per centimeter cubed"]& ),
    InterpretationFunction->(RowBox[{"Quantity", "[", 
       RowBox[{#, ",", 
         FractionBox["\"Grams\"", 
          SuperscriptBox["\"Centimeters\"", "3"]]}], "]"}]& )], ",", 
   "\"\<kg/m^3\>\""}], "]"}]], "Input",
 NumberMarks->False,
 CellLabel->"In[3]:=",
 CellID->25911720,ExpressionUUID->"44186ae1-cebc-456b-962a-21dfbc8029e2"],

Cell[BoxData[
 TemplateBox[{"4.05911915480945`", 
   RowBox[{"\"kg\"", "\[InvisibleSpace]", "\"/\"", "\[InvisibleSpace]", 
     SuperscriptBox["\"m\"", "3"]}], "kilograms per meter cubed", 
   FractionBox["\"Kilograms\"", 
    SuperscriptBox["\"Meters\"", "3"]]},
  "Quantity"]], "Output",
 CellLabel->"Out[3]=",
 CellID->137786474,ExpressionUUID->"a4238495-8743-4f7e-b8ba-a29751421baa"]
}, Open  ]],

Cell["Relative error with NIST constant", "ExampleText",
 CellID->32289193,ExpressionUUID->"58998c0a-131d-48a0-a3c4-4546d587dbe3"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Quantity", "[", 
  RowBox[{
   RowBox[{"100", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"\[Rho]trgaz", "-", "\[Rho]trgazNv"}], ")"}], "/", 
     "\[Rho]trgaz"}]}], ",", "\"\<%\>\""}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->91147354,ExpressionUUID->"d07a4fb0-a9c8-427a-8cd4-5744c59e1de7"],

Cell[BoxData[
 TemplateBox[{
   RowBox[{"-", "0.11145732439813497`"}], "\"%\"", "percent", "\"Percent\""},
  "QuantityPostfix"]], "Output",
 ImageSize->{71, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->318848690,ExpressionUUID->"15b8662c-46c2-42df-98ef-f422920f619e"]
}, Open  ]],

Cell["Molar volume corresponding to \[Rho]trgazNv", "ExampleText",
 CellID->222855593,ExpressionUUID->"ac420174-a805-4252-b10b-a8aaa0fa6e73"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Quantity", "[", 
   RowBox[{"M", ",", "\"\<g/mol\>\""}], "]"}], "/", 
  RowBox[{"Quantity", "[", 
   RowBox[{"\[Rho]trgazNv", ",", "\"\<g/cm^3\>\""}], "]"}]}]], "Input",
 CellLabel->"In[5]:=",
 CellID->295872759,ExpressionUUID->"2830ac99-2495-4d85-b426-b0abc5dffd30"],

Cell[BoxData[
 TemplateBox[{"9841.54405831314`", 
   RowBox[{
     SuperscriptBox["\"cm\"", "3"], "\[NegativeMediumSpace]", "\"/\"", 
     "\[InvisibleSpace]", "\"mol\""}], "centimeters cubed per mole", 
   FractionBox[
    SuperscriptBox["\"Centimeters\"", "3"], "\"Moles\""]},
  "Quantity"]], "Output",
 ImageSize->{102, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->7658542,ExpressionUUID->"e213c0a4-03b7-42ed-a60d-44d930dc5598"]
}, Open  ]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"}, 
  Closed]]]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "PrimaryExamplesSection"}, 
  Closed]]]],

Cell[BoxData[GridBox[{
   {
    DynamicBox[FEPrivate`ImportImage[
      FrontEnd`FileName[{"Documentation", "FooterIcons"}, 
       "RelatedFunction.png"]],
     ImageSizeCache->{50., {27., 33.}}], GridBox[{
      {
       StyleBox[
        RowBox[{"See", " ", "Also"}], "SeeAlsoSection"]},
      {Cell[TextData[{
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["ttr"]], "paclet:NewEoSArgon/ref/ttr", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "bd665bb9-7e4d-46ce-9c43-7e50174d28cd"],
        "\[NonBreakingSpace]",
        StyleBox[
        "\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
         "InlineSeparator"],
        " ",
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["ptrNv"]], "paclet:NewEoSArgon/ref/ptrNv", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "c186be19-9648-4bd4-b4ed-955d8f2f75d5"],
        "\[NonBreakingSpace]",
        StyleBox[
        "\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
         "InlineSeparator"],
        " ",
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["rhotrliqNv"]], "paclet:NewEoSArgon/ref/rhotrliqNv", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "b23f4775-0416-40ca-a68f-227f7ebde822"]
       }], "SeeAlso",ExpressionUUID->"ae82a68c-5358-4b94-9839-0a71a2f34780"]}
     }]}
  }]], "SeeAlsoSection",ExpressionUUID->"3d605db7-11af-43bc-8c0e-\
67f7b6b143e3"],

Cell[BoxData[GridBox[{
   {
    DynamicBox[FEPrivate`ImportImage[
      FrontEnd`FileName[{"Documentation", "FooterIcons"}, "RelatedGuide.png"]],
     ImageSizeCache->{50., {27., 33.}}], GridBox[{
      {
       StyleBox[
        RowBox[{"Related", " ", "Guides"}], "MoreAboutSection"]},
      {
       RowBox[{"\[FilledVerySmallSquare]", Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["NewEoSArgon Package"]], 
           "paclet:NewEoSArgon/guide/NewEoSArgon"},
          "RefLinkPlain",
          BaseStyle->{"MoreAbout"}]], "MoreAbout",ExpressionUUID->
         "be32e916-ca4f-49da-9694-34bf88401914"]}]}
     }]}
  }]], "MoreAboutSection",ExpressionUUID->"28d300d9-10a9-4a65-8b51-\
5323772677d8"],

Cell[BoxData[GridBox[{
   {
    TemplateBox[{29},
     "Spacer1"], GridBox[{
      {
       RowBox[{
        TemplateBox[{17},
         "Spacer1"], 
        StyleBox[
         RowBox[{"Related", " ", "Links"}], "RelatedLinksSection"]}]},
      {Cell[BoxData[Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData[
             RowBox[{
               RowBox[{"Units", " ", "&"}], " ", "Quantities"}]]], 
           "paclet:guide/Units"},
          "RefLinkPlain",
          BaseStyle->{"RelatedLinks"}]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "769a2bbc-1477-4e5a-8264-bffd4504a5a9"]], "RelatedLinks",
        ExpressionUUID->"cd21761f-3172-408b-a16e-af516f2c10d9"]}
     }]}
  }]], "RelatedLinksSection",ExpressionUUID->"449d2f4c-801c-4528-a704-\
2a11dcc00b74"],

Cell[" ", "FooterCell",ExpressionUUID->"0146914d-8140-4523-99da-a9d763f8d3df"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{900, 835.8},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"rhotrgazNv [\[Rho]trgazNv]",
TaggingRules->{
 "ModificationHighlight" -> False, "ColorType" -> "", "LinkTrails" -> "", 
  "HasOptions" -> True, "ExampleCounter" -> 1, 
  "Openers" -> {
   "PrimaryExamplesSection" -> Open, "ExampleSection" -> {"0" -> Open}}, 
  "NewStyles" -> True, "CitationPopupData" -> $Failed, "ShowCitation" -> 
  False, "RootCaptions" -> "", 
  "Metadata" -> {
   "built" -> "{2023, 11, 30, 13, 56, 4.2959742}", 
    "history" -> {"XX", "", "", ""}, "context" -> "NewEoSArgon`", 
    "keywords" -> {}, "specialkeywords" -> {}, 
    "tutorialcollectionlinks" -> {}, "index" -> True, "label" -> 
    "New Eo S Argon Package Symbol", "language" -> "en", "paclet" -> 
    "NewEoSArgon Package", "status" -> "None", "summary" -> 
    "rhotrgazNv (g/cm^3) Densit\[EAcute] du gaz au point triple de l'argon d\
\[EAcute]duite des relations de Maxwell [Triple point gas density of argon \
from Maxwell relations]", "synonyms" -> {}, "tabletags" -> {}, "title" -> 
    "rhotrgazNv [\[Rho]trgazNv]", "titlemodifier" -> "", "metadescription" -> 
    "", "windowtitle" -> "rhotrgazNv [\[Rho]trgazNv]", "type" -> "Symbol", 
    "uri" -> "NewEoSArgon/ref/rhotrgazNv"}},
CellContext->"Global`",
FrontEndVersion->"13.3 pour Microsoft Windows (64-bit) (July 24, 2023)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "13.3 pour Microsoft Windows (64-bit) (July 24, 2023)", 
  StyleDefinitions -> "Default.nb"],
ExpressionUUID->"a83b269a-b552-4921-9999-864ccc3a43f4"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7559, 200, 1421, 37, 35, "PrimaryExamplesSection",ExpressionUUID->"8a825aae-cd61-47c5-9c9e-f7d490da6502",
   CellTags->"PrimaryExamplesSection",
   CellID->1012398660]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 20184, 551}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[598, 21, 5389, 131, 56, "AnchorBarGrid",ExpressionUUID->"60e05248-f938-4488-b241-ec44cb4ce455",
 CellID->1],
Cell[5990, 154, 94, 0, 23, "ContextNameCell",ExpressionUUID->"f4e48517-5304-49fc-b0fe-128a67f02462"],
Cell[CellGroupData[{
Cell[6109, 158, 569, 14, 56, "ObjectNameGrid",ExpressionUUID->"d2667339-9b8c-4c5b-bed6-abf5d1f96736"],
Cell[6681, 174, 841, 21, 146, "Usage",ExpressionUUID->"8843f182-8feb-4d5b-90d4-c243775d778c"]
}, Open  ]],
Cell[CellGroupData[{
Cell[7559, 200, 1421, 37, 35, "PrimaryExamplesSection",ExpressionUUID->"8a825aae-cd61-47c5-9c9e-f7d490da6502",
 CellTags->"PrimaryExamplesSection",
 CellID->1012398660],
Cell[CellGroupData[{
Cell[9005, 241, 1397, 36, 30, "ExampleSection",ExpressionUUID->"95ec0f14-d12a-4462-8766-20e5bfe59913",
 CellID->11818053],
Cell[10405, 279, 174, 3, 26, "Input",ExpressionUUID->"6b078ab6-e1b6-47bf-914b-0e96fd8955a2",
 CellID->87419684],
Cell[10582, 284, 139, 1, 38, "ExampleText",ExpressionUUID->"63b034e2-868e-489d-8682-9ce7b7b02256",
 CellID->886239600],
Cell[CellGroupData[{
Cell[10746, 289, 206, 4, 26, "Input",ExpressionUUID->"505057d3-6881-4fac-a6f8-84e1f8b011e3",
 CellID->21488140],
Cell[10955, 295, 392, 8, 45, "Output",ExpressionUUID->"7d4b661e-4222-4527-9fab-9e9161629ebf",
 CellID->315646393]
}, Open  ]],
Cell[CellGroupData[{
Cell[11384, 308, 873, 23, 30, "Input",ExpressionUUID->"44186ae1-cebc-456b-962a-21dfbc8029e2",
 CellID->25911720],
Cell[12260, 333, 387, 8, 45, "Output",ExpressionUUID->"a4238495-8743-4f7e-b8ba-a29751421baa",
 CellID->137786474]
}, Open  ]],
Cell[12662, 344, 130, 1, 38, "ExampleText",ExpressionUUID->"58998c0a-131d-48a0-a3c4-4546d587dbe3",
 CellID->32289193],
Cell[CellGroupData[{
Cell[12817, 349, 326, 9, 26, "Input",ExpressionUUID->"d07a4fb0-a9c8-427a-8cd4-5744c59e1de7",
 CellID->91147354],
Cell[13146, 360, 324, 8, 40, "Output",ExpressionUUID->"15b8662c-46c2-42df-98ef-f422920f619e",
 CellID->318848690]
}, Open  ]],
Cell[13485, 371, 141, 1, 38, "ExampleText",ExpressionUUID->"ac420174-a805-4252-b10b-a8aaa0fa6e73",
 CellID->222855593],
Cell[CellGroupData[{
Cell[13651, 376, 302, 7, 26, "Input",ExpressionUUID->"2830ac99-2495-4d85-b426-b0abc5dffd30",
 CellID->295872759],
Cell[13956, 385, 488, 12, 43, "Output",ExpressionUUID->"e213c0a4-03b7-42ed-a60d-44d930dc5598",
 CellID->7658542]
}, Open  ]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"}, Closed]]]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "PrimaryExamplesSection"}, Closed]]]],
Cell[14686, 406, 1870, 50, 114, "SeeAlsoSection",ExpressionUUID->"3d605db7-11af-43bc-8c0e-67f7b6b143e3"],
Cell[16559, 458, 729, 19, 70, "MoreAboutSection",ExpressionUUID->"28d300d9-10a9-4a65-8b51-5323772677d8"],
Cell[17291, 479, 825, 24, 70, "RelatedLinksSection",ExpressionUUID->"449d2f4c-801c-4528-a704-2a11dcc00b74"],
Cell[18119, 505, 78, 0, 70, "FooterCell",ExpressionUUID->"0146914d-8140-4523-99da-a9d763f8d3df"]
}
]
*)

(* End of internal cache information *)

