(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 13.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     59041,       1417]
NotebookOptionsPosition[     52940,       1293]
NotebookOutlinePosition[     55200,       1349]
CellTagsIndexPosition[     55114,       1344]
WindowTitle->rhotrliq [\:03C1trliq]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[GridBox[{
   {GridBox[{
      {
       ItemBox[Cell[BoxData[
         RowBox[{
          TemplateBox[{12},
           "Spacer1"], Cell["NEW EO S ARGON PACKAGE SYMBOL", "PacletNameCell",
           TextAlignment->Center,ExpressionUUID->
           "15c46e9a-85fb-492d-8df4-be2252511c80"], 
          TemplateBox[{8},
           "Spacer1"]}]],
         TextAlignment->Center,ExpressionUUID->
         "5bd70ce0-d4fc-44d8-b633-ad96edeb1352"],
        Background->RGBColor[0.490196, 0.576471, 0.690196],
        ItemSize->Full], ""}
     },
     GridBoxAlignment->{"Rows" -> {{Center}}},
     GridBoxItemSize->{"Columns" -> {Full, 
         Scaled[0.02]}, "Rows" -> {{2.5}}}], Cell[TextData[{
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "See Also",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "77bc96ba-7641-4bd4-b2cd-2a31dbaf9fd2"]
         }],ExpressionUUID->"c4c28c19-d60a-473e-9f97-6809b6128916"],
         StripOnInput->False],{
        "\"vtrliq\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/vtrliq"], "\"ttr\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/ttr"], "\"ptr\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/ptr"], 
         "\"rhotrgaz\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/rhotrgaz"], 
         "\"vtrgaz\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/vtrgaz"]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"SeeAlso"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "e5787f4e-74e7-4038-8bd2-f74a41a86274"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "Related Guides",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "f52c425b-4293-454d-887b-bf7212f41733"]
         }],ExpressionUUID->"7d71b540-95d5-47c2-81f2-39191e8f107e"],
         StripOnInput->False],{
        "\"NewEoSArgon Package\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/guide/NewEoSArgon"]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"MoreAbout"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "d06c7314-81c8-45ec-a61e-e9fa239f30ef"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "URL",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "94c85848-dfc3-4ca9-9e0f-05c30fc198a3"]
         }],ExpressionUUID->"1d480831-b646-4a0c-8d19-2319ed12fac6"],
         StripOnInput->False],{
        "\"NewEoSArgon/ref/rhotrliq\"" :> None, 
         "\"Copy Wolfram Documentation Center URL\"" :> 
         Module[{DocumentationSearch`Private`nb$}, 
           DocumentationSearch`Private`nb$ = 
            NotebookPut[
             Notebook[{Cell["NewEoSArgon/ref/rhotrliq"]}, Visible -> False]]; 
           SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
           FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
           NotebookClose[DocumentationSearch`Private`nb$]; Null], Delimiter, 
         "\"Copy web URL\"" :> 
         Module[{DocumentationSearch`Private`nb$}, 
           DocumentationSearch`Private`nb$ = 
            NotebookPut[
             Notebook[{
               Cell[BoxData[
                 MakeBoxes[
                  Hyperlink[
                   "http://reference.wolfram.com/language/NewEoSArgon/ref/\
rhotrliq.html"], StandardForm]], "Input", TextClipboardType -> "PlainText"]}, 
               Visible -> False]]; 
           SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
           FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
           NotebookClose[DocumentationSearch`Private`nb$]; Null], 
         "\"Go to web URL\"" :> 
         FrontEndExecute[{
           NotebookLocate[{
             URL[If[TrueQ[DocumentationBuild`Make`Private`wsmlinkQ$27937], 
                 "http://reference.wolfram.com/system-modeler/", 
                 "http://reference.wolfram.com/language/"] <> 
               "NewEoSArgon/ref/rhotrliq" <> ".html"], None}]}]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"URLMenu"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "75d40327-a459-4f1f-91aa-b38aa0c7fd1b"]
    }], "AnchorBar",
     CacheGraphics->False,ExpressionUUID->
     "459cabf5-cde7-4c7f-bdec-bbee79199191"]}
  }]], "AnchorBarGrid",
 CellID->1,ExpressionUUID->"b0237bfe-5541-4683-9331-36d977b16d9b"],

Cell["NewEoSArgon`", "ContextNameCell",ExpressionUUID->"44f88f3f-807c-4fd0-bc78-cc1c4014a8fe"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     Cell[
     "rhotrliq [\[Rho]trliq]", "ObjectName",ExpressionUUID->
      "73e4ed97-d4e6-4720-9b60-01a8bbdc7f6f"],
     Cell[BoxData[
      TemplateBox[{8},
       "Spacer1"]],ExpressionUUID->"1383c079-f2db-45b2-b005-8385716aba03"],
     Cell[BoxData[
     ""], "ObjectNameTranslation",ExpressionUUID->
      "1ce7ec8d-d2ec-4581-9819-5fffd09c1116"]
    }],ExpressionUUID->"e9265b11-36d3-4c10-9ad1-84d6e0ef2001"], 
    "\[SpanFromLeft]"}
  }]], "ObjectNameGrid",ExpressionUUID->"87d48d4a-23fc-4f4b-8ec1-\
5b73d68f467d"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["rhotrliq"], "InlineFormula",
      ShowStringCharacters->False,
      FontFamily->"Source Sans Pro",ExpressionUUID->
      "fad628c5-d191-418c-8797-c6f87f24ad3e"],
     " (g/",
     Cell[BoxData[
      SuperscriptBox["cm", "3"]], "InlineFormula",
      FontFamily->"Source Sans Pro",ExpressionUUID->
      "0b11cc8f-e494-4893-8c0b-1f296cd018ec"],
     ")\nDensit\[EAcute] du ",
     StyleBox["liquide",
      FontSlant->"Italic"],
     " au point triple de l'argon donn\[EAcute]e par NIST \n[Triple point ",
     StyleBox["liquid",
      FontSlant->"Italic"],
     " density of argon from NIST]"
    }],ExpressionUUID->"e1b1a5b6-9a26-4594-8640-f3c6aeafbae1"]}
  }]], "Usage",
 Deletable->True,ExpressionUUID->"638eccee-912a-408a-88f8-5e6b87a55620"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[Cell[TextData[{
   Cell[BoxData[
    DynamicBox[ToBoxes[
      If[
       MatchQ[
        CurrentValue[
         EvaluationNotebook[], {TaggingRules, "Openers", "NotesSection"}, 
         Closed], 
        Alternatives[Open, True]], 
       Style[
        Graphics[{
          Thickness[0.18], 
          RGBColor[0.8509803921568627, 0.396078431372549, 0], 
          Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
         PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
        0.68 Inherited], 
       Rotate[
        Style[
         Graphics[{
           Thickness[0.18], 
           RGBColor[0.8509803921568627, 0.396078431372549, 0], 
           Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
          PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
         0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
     ImageSizeCache->{
      13.600000000000001`, {0.5800000000000001, 13.020000000000001`}}]],
    ExpressionUUID->"c8c2e8e6-a47d-4db9-a695-0c2c613df051"],
   Cell[BoxData[
    TemplateBox[{1},
     "Spacer1"]],ExpressionUUID->"efe5d88d-e6c6-48ff-b568-af833be16c23"],
   "Details and Options"
  }], "NotesFrameText",ExpressionUUID->"f33969d0-3655-44ef-ae20-492a22a33e1f"],
  Appearance->{Automatic, None, "Normal", Automatic},
  BaseStyle->None,
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"], 
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], After, CellContents]}]& ),
  Evaluator->None,
  Method->
   "Preemptive"]],ExpressionUUID->"f9588c55-9a82-49e9-bb19-255c0c6b3c08"]], \
"NotesSection",
 WholeCellGroupOpener->True,
 CellGroupingRules->{"SectionGrouping", 50},
 CacheGraphics->False,
 CellID->1268058,ExpressionUUID->"490d0fa3-d3e1-4bca-bc5b-078e9dd05360"],

Cell[TextData[{
 "La densit\[EAcute] du gaz au point triple peut encore se d\[EAcute]duire du \
volume molaire au point triple telle que \[Rho]trliq = ",
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["M"]], "paclet:NewEoSArgon/ref/M", "NewEoSArgon Package Symbol"},
   "PackageLink",
   BaseStyle->"InlineFormula"]], "InlineFormula",
  FontFamily->"Source Sans Pro",ExpressionUUID->
  "aaed4b55-62d2-434e-9e1a-7d23e1c83bb6"],
 " / ",
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["vtrliq"]], "paclet:NewEoSArgon/ref/vtrliq", 
    "NewEoSArgon Package Symbol"},
   "PackageLink",
   BaseStyle->"InlineFormula"]], "InlineFormula",
  FontFamily->"Source Sans Pro",ExpressionUUID->
  "affffc29-f478-4462-9934-ec9667fcae8c"],
 "."
}], "Notes",
 CellID->1067943069,ExpressionUUID->"7287a4f4-bafa-4edf-b5a3-dfa8c17eee42"],

Cell["\<\
******************************************************************************\
*****\
\>", "Notes",
 CellID->185021568,ExpressionUUID->"6d6cad60-4254-45fc-8fe4-dbf2d75f8a31"],

Cell[TextData[{
 "The liquid density at the triple point can still be deduced from the molar \
volume at the triple point as follows \[Rho]trliq = ",
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["M"]], "paclet:NewEoSArgon/ref/M", "NewEoSArgon Package Symbol"},
   "PackageLink",
   BaseStyle->"InlineFormula"]], "InlineFormula",
  FontFamily->"Source Sans Pro",ExpressionUUID->
  "71db8adb-df7b-4462-8dce-ee1e02330d4e"],
 " / ",
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["vtrliq"]], "paclet:NewEoSArgon/ref/vtrliq", 
    "NewEoSArgon Package Symbol"},
   "PackageLink",
   BaseStyle->"InlineFormula"]], "InlineFormula",
  FontFamily->"Source Sans Pro",ExpressionUUID->
  "ee19c436-f4aa-423b-a940-335a79ea81b0"],
 "."
}], "Notes",
 CellID->489383078,ExpressionUUID->"210fc90c-f0b2-4628-ba86-0bebd6b0a4de"]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "NotesSection"}, Closed]]]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {
       TaggingRules, "Openers", "PrimaryExamplesSection"}, Open], 
      Alternatives[True, Open]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{13.600000000000001`, {5., 8.600000000000001}}]],
  ExpressionUUID->"bdcbb481-5f73-4485-bc45-8404034aa22b"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"34830c7b-f620-4d23-8516-69ae915af6d7"],
 "Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "832bc946-aa9e-4715-a417-2b2f881ad78c"]
}], "PrimaryExamplesSection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellTags->"PrimaryExamplesSection",
 CellID->14172657,ExpressionUUID->"5dea2b5f-d39a-4729-9efd-392005e96f59"],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"},
        Closed], 
      Alternatives[Open, True]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{13.600000000000001`, {5., 8.600000000000001}}]],
  ExpressionUUID->"de471f24-25a5-4ce6-a617-01ca6b26b87e"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"fd94d55f-dd50-466b-8a6e-549edb123653"],
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "ac360423-8950-4e54-b631-c12ada9d41d5"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellID->192488861,ExpressionUUID->"3a252e9c-a01b-4f5b-872a-49dabd985c65"],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<NewEoSArgon`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->87419684,ExpressionUUID->"072f710b-25bb-483a-aaf3-e6d7cba0a9eb"],

Cell["Give a physical dimension to the constant", "ExampleText",
 CellID->886239600,ExpressionUUID->"306e9caa-6f7c-43cb-9874-19c3fefc1b05"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Quantity", "[", 
  RowBox[{"\[Rho]trliq", ",", "\"\<g/cm^3\>\""}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->21488140,ExpressionUUID->"b2acd08d-48fd-4f20-a767-b80d4b6e0594"],

Cell[BoxData[
 TemplateBox[{"1.4168017335853793`", 
   RowBox[{"\"g\"", "\[InvisibleSpace]", "\"/\"", "\[InvisibleSpace]", 
     SuperscriptBox["\"cm\"", "3"]}], "grams per centimeter cubed", 
   FractionBox["\"Grams\"", 
    SuperscriptBox["\"Centimeters\"", "3"]]},
  "Quantity"]], "Output",
 CellLabel->"Out[2]=",
 CellID->358226006,ExpressionUUID->"c4f41dfe-e90c-464b-83c1-8427ec837ea3"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UnitConvert", "[", 
  RowBox[{
   TemplateBox[{"1.4168017335853793`"},
    "QuantityUnit",
    DisplayFunction->(TooltipBox[
      StyleBox[
       RowBox[{#, "\[InvisibleSpace]", 
         StyleBox[
          RowBox[{" ", 
            
            RowBox[{"\"g\"", "\[InvisibleSpace]", "\"/\"", 
              "\[InvisibleSpace]", 
              SuperscriptBox["\"cm\"", "3"]}]}], 
          "QuantityUnitTraditionalLabel"]}], ShowStringCharacters -> False], 
      "Unit: grams per centimeter cubed"]& ),
    InterpretationFunction->(RowBox[{"Quantity", "[", 
       RowBox[{#, ",", 
         FractionBox["\"Grams\"", 
          SuperscriptBox["\"Centimeters\"", "3"]]}], "]"}]& )], ",", 
   "\"\<kg/m^3\>\""}], "]"}]], "Input",
 NumberMarks->False,
 CellLabel->"In[3]:=",
 CellID->15641702,ExpressionUUID->"615fdc8f-35f0-4c0d-9451-5bad628e935e"],

Cell[BoxData[
 TemplateBox[{"1416.8017335853792`", 
   RowBox[{"\"kg\"", "\[InvisibleSpace]", "\"/\"", "\[InvisibleSpace]", 
     SuperscriptBox["\"m\"", "3"]}], "kilograms per meter cubed", 
   FractionBox["\"Kilograms\"", 
    SuperscriptBox["\"Meters\"", "3"]]},
  "Quantity"]], "Output",
 CellLabel->"Out[3]=",
 CellID->162896280,ExpressionUUID->"7a8e4e53-869a-4775-a905-60c4ab5cb4de"]
}, Open  ]],

Cell["Other way to define the triple point density", "ExampleText",
 CellID->278961620,ExpressionUUID->"c2466b1e-7ad1-4baf-adfd-42c7f20f43b8"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Quantity", "[", 
   RowBox[{"M", ",", "\"\<g/mol\>\""}], "]"}], "/", 
  RowBox[{"Quantity", "[", 
   RowBox[{"vtrliq", ",", "\"\<cm^3/mol\>\""}], "]"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->295872759,ExpressionUUID->"df461d77-2588-43f2-b679-17e0f7d0dc1d"],

Cell[BoxData[
 TemplateBox[{"1.4168017335853793`", 
   RowBox[{"\"g\"", "\[InvisibleSpace]", "\"/\"", "\[InvisibleSpace]", 
     SuperscriptBox["\"cm\"", "3"]}], "grams per centimeter cubed", 
   FractionBox["\"Grams\"", 
    SuperscriptBox["\"Centimeters\"", "3"]]},
  "Quantity"]], "Output",
 CellLabel->"Out[4]=",
 CellID->62816057,ExpressionUUID->"df1d5d89-30ab-4f3f-a306-e8bda8d0971f"]
}, Open  ]],

Cell["Using WolframAlpha", "ExampleText",
 CellID->351008126,ExpressionUUID->"daf18fd5-b7d9-4185-a368-58ed44ad3d62"],

Cell[CellGroupData[{

Cell[BoxData[
 NamespaceBox["WolframAlphaQueryResults",
  DynamicModuleBox[{Typeset`q$$ = "triple point density of argon ", 
   Typeset`opts$$ = {
   AppearanceElements -> {"Extrusion", "Warnings", "Assumptions", "Pods"}, 
    Asynchronous -> All, PodStates -> {"Result__Show details"}, 
    Method -> {
     "ExtrusionChosen" -> {"Result", "Result", 1, 1, "Content"}, 
      "ExtrusionOpen" -> True, 
      "Formats" -> {"cell", "minput", "moutput", "msound", "dataformats"}}}, 
   Typeset`elements$$ = {"Extrusion", "Warnings", "Assumptions", "Pods"}, 
   Typeset`pod1$$ = XMLElement[
   "pod", {"title" -> "Input interpretation", "scanner" -> "Identity", "id" -> 
     "Input", "position" -> "100", "error" -> "false", "numsubpods" -> "1"}, {
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement["cell", {"compressed" -> False, "string" -> True}, {
         Cell[
          BoxData[
           FormBox[
            TagBox[
             FormBox[
              TagBox[
               GridBox[{{
                  PaneBox[
                   StyleBox[
                    TagBox[
                    GridBox[{{
                    StyleBox[
                    TagBox[
                    TagBox["\"argon\"", 
                    $CellContext`TagBoxWrapper[
                    "Entity" -> {ChemicalData, "Argon"}]], Identity], {
                    LineIndent -> 0, LineSpacing -> {0.9, 0, 1.5}}], 
                    "\"triple point density\""}}, 
                    GridBoxBackground -> {"Columns" -> {
                    GrayLevel[0.949], None}, "Rows" -> {{None}}}, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    ColumnsEqual -> False, RowsEqual -> False, 
                    GridBoxDividers -> {"Columns" -> {
                    GrayLevel[0.84], 
                    GrayLevel[0.84], 
                    GrayLevel[0.84]}, "Rows" -> {{
                    GrayLevel[0.84]}}, 
                    "RowsIndexed" -> {
                    1 -> GrayLevel[0.84], -1 -> GrayLevel[0.84]}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {1, 1, 1}, "Rows" -> {{0.3}}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Baseline}}}, 
                    AllowScriptLevelChange -> False, BaselinePosition -> 1], 
                    $CellContext`TagBoxWrapper["Separator" -> " | "]], 
                    LineSpacing -> {1, 0, 1.5}, LineIndent -> 0], 
                   BaselinePosition -> Center]}}, 
                GridBoxItemSize -> {
                 "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                ColumnsEqual -> False, RowsEqual -> False, 
                GridBoxSpacings -> {"Columns" -> {{
                    AbsoluteThickness[-1]}}, "Rows" -> {{0}}}, 
                AllowScriptLevelChange -> False], 
               $CellContext`TagBoxWrapper["Separator" -> " | "]], 
              TraditionalForm], 
             PolynomialForm[#, TraditionalOrder -> False]& ], 
            TraditionalForm]], "Output"]}], 
       XMLElement[
       "dataformats", {}, {"plaintext,computabledata,formatteddata"}]}]}], 
   Typeset`pod2$$ = XMLElement[
   "pod", {"title" -> "Result", "scanner" -> "Data", "id" -> "Result", 
     "position" -> "200", "error" -> "false", "numsubpods" -> "1", "primary" -> 
     "true"}, {
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement["cell", {"compressed" -> False, "string" -> True}, {
         Cell[
          BoxData[
           FormBox[
            StyleBox[
             TagBox[
              GridBox[{{
                 StyleBox[
                 "\"liquid\"", LinebreakAdjustments -> {1, 100, 1, 0, 100}, 
                  LineIndent -> 0, 
                  GrayLevel[0.6], StripOnInput -> False], 
                 StyleBox[
                  TagBox[
                   RowBox[{
                    TagBox[
                    TagBox[
                    RowBox[{
                    TagBox["1416.75", 
                    $CellContext`TagBoxWrapper["StringBoxes" -> "1416.75"]], 
                    "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    
                    RowBox[{
                    "\"kg\"", "\[InvisibleSpace]", "\"/\"", 
                    "\[InvisibleSpace]", 
                    SuperscriptBox["\"m\"", "3"]}], FontFamily -> "Helvetica",
                     FontSize -> Smaller]}], Identity], #& , SyntaxForm -> 
                    Dot], "  ", 
                    StyleBox[
                    
                    RowBox[{
                    "\"(\"", "\[NoBreak]", "\"kilograms per cubic meter\"", 
                    "\[NoBreak]", "\")\""}], {
                    FontFamily :> $CellContext`$UnitFontFamily, FontSize -> 
                    Smaller, 
                    GrayLevel[0.6], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0}, StripOnInput -> False]}], "Unit", SyntaxForm -> Dot], 
                  LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                  0, ZeroWidthTimes -> False]}, {
                 StyleBox[
                 "\"vapor\"", LinebreakAdjustments -> {1, 100, 1, 0, 100}, 
                  LineIndent -> 0, 
                  GrayLevel[0.6], StripOnInput -> False], 
                 StyleBox[
                  TagBox[
                   RowBox[{
                    TagBox[
                    TagBox[
                    RowBox[{
                    TagBox["4.05458", 
                    $CellContext`TagBoxWrapper["StringBoxes" -> "4.05458"]], 
                    "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    
                    RowBox[{
                    "\"kg\"", "\[InvisibleSpace]", "\"/\"", 
                    "\[InvisibleSpace]", 
                    SuperscriptBox["\"m\"", "3"]}], FontFamily -> "Helvetica",
                     FontSize -> Smaller]}], Identity], #& , SyntaxForm -> 
                    Dot], "  ", 
                    StyleBox[
                    
                    RowBox[{
                    "\"(\"", "\[NoBreak]", "\"kilograms per cubic meter\"", 
                    "\[NoBreak]", "\")\""}], {
                    FontFamily :> $CellContext`$UnitFontFamily, FontSize -> 
                    Smaller, 
                    GrayLevel[0.6], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0}, StripOnInput -> False]}], "Unit", SyntaxForm -> Dot], 
                  LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                  0, ZeroWidthTimes -> False]}}, 
               GridBoxAlignment -> {
                "Columns" -> {Left, Right}, "Rows" -> {{Baseline}}}, 
               AutoDelete -> False, 
               GridBoxBackground -> {"Columns" -> {{None}}}, 
               GridBoxFrame -> {"Columns" -> {{True}}, "Rows" -> {{True}}}, 
               GridBoxItemSize -> {
                "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
               GridBoxSpacings -> {"Columns" -> {{1.5}, 2}, "Rows" -> {{1}}}, 
               FrameStyle -> GrayLevel[0.84], BaselinePosition -> Automatic, 
               AllowScriptLevelChange -> False], "Grid"], 
             LineSpacing -> {0.9, 0, 1.5}, LineIndent -> 0, StripOnInput -> 
             False], TraditionalForm]], "Output"]}], 
       XMLElement[
       "dataformats", {}, {
        "plaintext,computabledata,formatteddata,numberdata,quantitydata"}]}]}]\
, Typeset`pod3$$ = XMLElement[
   "pod", {"title" -> "Triple point", "scanner" -> "Data", "id" -> 
     "TriplePoint:ThermodynamicDataRP", "position" -> "300", "error" -> 
     "false", "numsubpods" -> "1"}, {
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement["cell", {"compressed" -> True, "string" -> False}, {
         Cell[
          BoxData[
           FormBox[
            StyleBox[
             TagBox[
              GridBox[{{
                 TagBox[
                  PaneBox[
                   TagBox["\"temperature\"", Identity], 
                   BaseStyle -> {{
                    BaselinePosition -> Baseline, FontColor -> 
                    GrayLevel[0.3]}, LineSpacing -> {0.9, 0, 1.5}, 
                    LinebreakAdjustments -> {1, 10, 10000, 0, 100}, 
                    TextAlignment -> Left}, BaselinePosition -> Baseline], 
                  $CellContext`TagBoxWrapper["Label"]], 
                 TagBox[
                  GridBox[{{
                    StyleBox[
                    TagBox[
                    RowBox[{
                    TagBox[
                    TagBox[
                    RowBox[{
                    TagBox["83.81", 
                    $CellContext`TagBoxWrapper["StringBoxes" -> "83.81"]], 
                    "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    "\"K\"", FontFamily -> "Helvetica", FontSize -> 
                    Smaller]}], Identity], #& , SyntaxForm -> Dot], "  ", 
                    StyleBox[
                    
                    RowBox[{
                    "\"(\"", "\[NoBreak]", "\"kelvins\"", "\[NoBreak]", 
                    "\")\""}], {
                    FontFamily :> $CellContext`$UnitFontFamily, FontSize -> 
                    Smaller, 
                    GrayLevel[0.6], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0}, StripOnInput -> False]}], "Unit", SyntaxForm -> Dot], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, ZeroWidthTimes -> False]}, {
                    StyleBox[
                    TagBox[
                    RowBox[{
                    TagBox[
                    TagBox[
                    RowBox[{
                    RowBox[{"-", 
                    TagBox["189.3", 
                    $CellContext`TagBoxWrapper["StringBoxes" -> "189.3"]]}], 
                    "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    "\"\[Degree]C\"", FontFamily -> "Helvetica", FontSize -> 
                    Smaller]}], Identity], #& , SyntaxForm -> Dot], "  ", 
                    StyleBox[
                    
                    RowBox[{
                    "\"(\"", "\[NoBreak]", "\"degrees Celsius\"", 
                    "\[NoBreak]", "\")\""}], {
                    FontFamily :> $CellContext`$UnitFontFamily, FontSize -> 
                    Smaller, 
                    GrayLevel[0.6], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0}, StripOnInput -> False]}], "Unit", SyntaxForm -> Dot], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, ZeroWidthTimes -> False]}}, 
                   GridBoxAlignment -> {"Columns" -> {{Left}}}, 
                   DefaultBaseStyle -> "Column", 
                   GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
                  "Column"], "\[SpanFromLeft]"}, {
                 TagBox[
                  PaneBox[
                   TagBox["\"pressure\"", Identity], 
                   BaseStyle -> {{
                    BaselinePosition -> Baseline, FontColor -> 
                    GrayLevel[0.3]}, LineSpacing -> {0.9, 0, 1.5}, 
                    LinebreakAdjustments -> {1, 10, 10000, 0, 100}, 
                    TextAlignment -> Left}, BaselinePosition -> Baseline], 
                  $CellContext`TagBoxWrapper["Label"]], 
                 TagBox[
                  GridBox[{{
                    StyleBox[
                    TagBox[
                    RowBox[{
                    TagBox[
                    TagBox[
                    RowBox[{
                    TagBox["68\[ThinSpace]891", 
                    $CellContext`TagBoxWrapper["StringBoxes" -> "68891"]], 
                    "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    "\"Pa\"", FontFamily -> "Helvetica", FontSize -> 
                    Smaller]}], Identity], #& , SyntaxForm -> Dot], "  ", 
                    StyleBox[
                    
                    RowBox[{
                    "\"(\"", "\[NoBreak]", "\"pascals\"", "\[NoBreak]", 
                    "\")\""}], {
                    FontFamily :> $CellContext`$UnitFontFamily, FontSize -> 
                    Smaller, 
                    GrayLevel[0.6], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0}, StripOnInput -> False]}], "Unit", SyntaxForm -> Dot], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, ZeroWidthTimes -> False]}, {
                    StyleBox[
                    TagBox[
                    RowBox[{
                    TagBox[
                    TagBox[
                    RowBox[{
                    TagBox["0.6799", 
                    $CellContext`TagBoxWrapper["StringBoxes" -> "0.6799"]], 
                    "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    "\"atm\"", FontFamily -> "Helvetica", FontSize -> 
                    Smaller]}], Identity], #& , SyntaxForm -> Dot], "  ", 
                    StyleBox[
                    
                    RowBox[{
                    "\"(\"", "\[NoBreak]", "\"atmospheres\"", "\[NoBreak]", 
                    "\")\""}], {
                    FontFamily :> $CellContext`$UnitFontFamily, FontSize -> 
                    Smaller, 
                    GrayLevel[0.6], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0}, StripOnInput -> False]}], "Unit", SyntaxForm -> Dot], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, ZeroWidthTimes -> False]}}, 
                   GridBoxAlignment -> {"Columns" -> {{Left}}}, 
                   DefaultBaseStyle -> "Column", 
                   GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
                  "Column"], "\[SpanFromLeft]"}, {
                 TagBox[
                  PaneBox[
                   TagBox["\"density\"", Identity], 
                   BaseStyle -> {{
                    BaselinePosition -> Baseline, FontColor -> 
                    GrayLevel[0.3]}, LineSpacing -> {0.9, 0, 1.5}, 
                    LinebreakAdjustments -> {1, 10, 10000, 0, 100}, 
                    TextAlignment -> Left}, BaselinePosition -> Baseline], 
                  $CellContext`TagBoxWrapper["Label"]], 
                 StyleBox[
                 "\"liquid\"", LinebreakAdjustments -> {1, 100, 1, 0, 100}, 
                  LineIndent -> 0, 
                  GrayLevel[0.6], StripOnInput -> False], 
                 StyleBox[
                  TagBox[
                   RowBox[{
                    TagBox[
                    TagBox[
                    RowBox[{
                    TagBox["1416.75", 
                    $CellContext`TagBoxWrapper["StringBoxes" -> "1416.75"]], 
                    "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    
                    RowBox[{
                    "\"kg\"", "\[InvisibleSpace]", "\"/\"", 
                    "\[InvisibleSpace]", 
                    SuperscriptBox["\"m\"", "3"]}], FontFamily -> "Helvetica",
                     FontSize -> Smaller]}], Identity], #& , SyntaxForm -> 
                    Dot], "  ", 
                    StyleBox[
                    
                    RowBox[{
                    "\"(\"", "\[NoBreak]", "\"kilograms per cubic meter\"", 
                    "\[NoBreak]", "\")\""}], {
                    FontFamily :> $CellContext`$UnitFontFamily, FontSize -> 
                    Smaller, 
                    GrayLevel[0.6], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0}, StripOnInput -> False]}], "Unit", SyntaxForm -> Dot], 
                  LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                  0, ZeroWidthTimes -> False]}, {"\[SpanFromAbove]", 
                 StyleBox[
                 "\"vapor\"", LinebreakAdjustments -> {1, 100, 1, 0, 100}, 
                  LineIndent -> 0, 
                  GrayLevel[0.6], StripOnInput -> False], 
                 StyleBox[
                  TagBox[
                   RowBox[{
                    TagBox[
                    TagBox[
                    RowBox[{
                    TagBox["4.05458", 
                    $CellContext`TagBoxWrapper["StringBoxes" -> "4.05458"]], 
                    "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    
                    RowBox[{
                    "\"kg\"", "\[InvisibleSpace]", "\"/\"", 
                    "\[InvisibleSpace]", 
                    SuperscriptBox["\"m\"", "3"]}], FontFamily -> "Helvetica",
                     FontSize -> Smaller]}], Identity], #& , SyntaxForm -> 
                    Dot], "  ", 
                    StyleBox[
                    
                    RowBox[{
                    "\"(\"", "\[NoBreak]", "\"kilograms per cubic meter\"", 
                    "\[NoBreak]", "\")\""}], {
                    FontFamily :> $CellContext`$UnitFontFamily, FontSize -> 
                    Smaller, 
                    GrayLevel[0.6], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0}, StripOnInput -> False]}], "Unit", SyntaxForm -> Dot], 
                  LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                  0, ZeroWidthTimes -> False]}}, 
               GridBoxAlignment -> {
                "Columns" -> {Left, Left, Left}, "Rows" -> {{Baseline}}}, 
               AutoDelete -> False, 
               GridBoxBackground -> {"Columns" -> {None, None}}, 
               GridBoxFrame -> {"Columns" -> {{True}}, "Rows" -> {{True}}}, 
               GridBoxItemSize -> {
                "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
               GridBoxSpacings -> {"Columns" -> {{1.5}, 2}, "Rows" -> {{1}}}, 
               FrameStyle -> GrayLevel[0.84], BaselinePosition -> Automatic, 
               AllowScriptLevelChange -> False], "Grid"], 
             LineSpacing -> {0.9, 0, 1.5}, LineIndent -> 0, StripOnInput -> 
             False], TraditionalForm]], "Output"]}], 
       XMLElement[
       "dataformats", {}, {
        "plaintext,computabledata,formatteddata,numberdata,quantitydata"}]}]}]\
, Typeset`aux1$$ = {True, False, {False}, True}, Typeset`aux2$$ = {
   True, False, {False}, True}, Typeset`aux3$$ = {True, False, {False}, True},
    Typeset`asyncpods$$ = {}, Typeset`nonpods$$ = {
    XMLElement["sources", {"count" -> "1"}, {
      XMLElement[
      "source", {
       "url" -> 
        "http://www.wolframalpha.com/sources/\
ThermodynamicDataRPSourceInformationNotes.html", "text" -> 
        "Thermodynamic data RP"}, {}]}]}, Typeset`initdone$$ = True, 
   Typeset`queryinfo$$ = {
   "success" -> "true", "error" -> "false", "numpods" -> "3", "datatypes" -> 
    "Chemical,ThermodynamicDataRP", "timedout" -> "", "timedoutpods" -> "", 
    "timing" -> "1.226", "parsetiming" -> "0.558", "parsetimedout" -> "false",
     "recalculate" -> "", "id" -> 
    "MSPa27281b4ehebc563027fb00004739ehbfce7f119g", "host" -> 
    "http://www4c.wolframalpha.com", "server" -> "9", "related" -> 
    "http://www4c.wolframalpha.com/api/v2/relatedQueries.jsp?id=\
MSPa27291b4ehebc563027fb0000601ca8f93e45f101&s=9", "version" -> "2.6"}, 
   Typeset`sessioninfo$$ = {
   "TimeZone" -> 1., 
    "Date" -> {2014, 2, 6, 17, 18, 53.4993398`9.480923267313967}, "Line" -> 
    43, "SessionID" -> 23597506324272770568}, Typeset`showpods$$ = {1, 2, 3}, 
   Typeset`failedpods$$ = {}, Typeset`chosen$$ = {
   "Result", "Result", 1, 1, "Content"}, Typeset`open$$ = True, 
   Typeset`newq$$ = "triple point density of argon "}, 
   DynamicBox[ToBoxes[
     AlphaIntegration`FormatAlphaResults[
      Dynamic[{
       1, {Typeset`pod1$$, Typeset`pod2$$, Typeset`pod3$$}, {
        Typeset`aux1$$, Typeset`aux2$$, Typeset`aux3$$}, Typeset`chosen$$, 
        Typeset`open$$, Typeset`elements$$, Typeset`q$$, Typeset`opts$$, 
        Typeset`nonpods$$, Typeset`queryinfo$$, Typeset`sessioninfo$$, 
        Typeset`showpods$$, Typeset`failedpods$$, Typeset`newq$$}]], 
     StandardForm],
    ImageSizeCache->{560., {421., 19.}},
    TrackedSymbols:>{Typeset`showpods$$, Typeset`failedpods$$}],
   DynamicModuleValues:>{},
   Initialization:>If[
     Not[Typeset`initdone$$], Null; WolframAlphaClient`Private`doAsyncUpdates[
       Hold[{Typeset`pod1$$, Typeset`pod2$$, Typeset`pod3$$}], 
       Typeset`asyncpods$$, 
       Dynamic[Typeset`failedpods$$]]; Typeset`asyncpods$$ = {}; 
     Typeset`initdone$$ = True],
   SynchronousInitialization->False],
  BaseStyle->{Deployed -> True},
  DeleteWithContents->True,
  Editable->False,
  SelectWithContents->True]], "WolframAlphaShortInput",
 CellLabel->"In[11]:=",
 CellID->19751437,ExpressionUUID->"dd4b2b2c-b76c-4ded-af01-9493a1203a54"],

Cell[BoxData[
 InterpretationBox[
  FrameBox[
   StyleBox[
    FormBox[
     StyleBox[
      StyleBox[GridBox[{
         {
          StyleBox["\<\"liquid\"\>",
           LineIndent->0,
           LinebreakAdjustments->{1, 100, 1, 0, 100},
           LineColor->GrayLevel[0.6],
           FrontFaceColor->GrayLevel[0.6],
           BackFaceColor->GrayLevel[0.6],
           GraphicsColor->GrayLevel[0.6],
           FontColor->GrayLevel[0.6]], 
          StyleBox[
           StyleBox[
            RowBox[{
            "1416.75", "\[NoBreak]", "\[InvisibleSpace]", "\[ThickSpace]", 
             "\[InvisibleSpace]", 
             StyleBox[
              
              RowBox[{"\<\"kg\"\>", "\[InvisibleSpace]", "\<\"/\"\>", 
               "\[InvisibleSpace]", 
               SuperscriptBox["\<\"m\"\>", "3"]}],
              LineIndent->0,
              LinebreakAdjustments->{1, 100, 1, 0, 100},
              FontFamily->"Roboto",
              FontSize->0.9 Inherited], "  ", 
             StyleBox[
              
              RowBox[{"\<\"(\"\>", 
               "\[NoBreak]", "\<\"kilograms per cubic meter\"\>", 
               "\[NoBreak]", "\<\")\"\>"}],
              LineIndent->0,
              LinebreakAdjustments->{1, 100, 1, 0, 100},
              LineColor->GrayLevel[0.6],
              FrontFaceColor->GrayLevel[0.6],
              BackFaceColor->GrayLevel[0.6],
              GraphicsColor->GrayLevel[0.6],
              FontFamily->"Roboto",
              FontSize->0.9 Inherited,
              FontColor->GrayLevel[0.6]]}], "Unit"],
           ZeroWidthTimes->False,
           LineIndent->0,
           LinebreakAdjustments->{1, 100, 1, 0, 100}]},
         {
          StyleBox["\<\"vapor\"\>",
           LineIndent->0,
           LinebreakAdjustments->{1, 100, 1, 0, 100},
           LineColor->GrayLevel[0.6],
           FrontFaceColor->GrayLevel[0.6],
           BackFaceColor->GrayLevel[0.6],
           GraphicsColor->GrayLevel[0.6],
           FontColor->GrayLevel[0.6]], 
          StyleBox[
           StyleBox[
            RowBox[{
            "4.05458", "\[NoBreak]", "\[InvisibleSpace]", "\[ThickSpace]", 
             "\[InvisibleSpace]", 
             StyleBox[
              
              RowBox[{"\<\"kg\"\>", "\[InvisibleSpace]", "\<\"/\"\>", 
               "\[InvisibleSpace]", 
               SuperscriptBox["\<\"m\"\>", "3"]}],
              LineIndent->0,
              LinebreakAdjustments->{1, 100, 1, 0, 100},
              FontFamily->"Roboto",
              FontSize->0.9 Inherited], "  ", 
             StyleBox[
              
              RowBox[{"\<\"(\"\>", 
               "\[NoBreak]", "\<\"kilograms per cubic meter\"\>", 
               "\[NoBreak]", "\<\")\"\>"}],
              LineIndent->0,
              LinebreakAdjustments->{1, 100, 1, 0, 100},
              LineColor->GrayLevel[0.6],
              FrontFaceColor->GrayLevel[0.6],
              BackFaceColor->GrayLevel[0.6],
              GraphicsColor->GrayLevel[0.6],
              FontFamily->"Roboto",
              FontSize->0.9 Inherited,
              FontColor->GrayLevel[0.6]]}], "Unit"],
           ZeroWidthTimes->False,
           LineIndent->0,
           LinebreakAdjustments->{1, 100, 1, 0, 100}]}
        },
        AllowScriptLevelChange->False,
        AutoDelete->False,
        BaselinePosition->Automatic,
        FrameStyle->GrayLevel[0.84],
        GridBoxAlignment->{"Columns" -> {Left, Left}, "Rows" -> {{Baseline}}},
        GridBoxBackground->{"Columns" -> {{None}}},
        GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}},
        GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {{1.5}, 2}, "Rows" -> {{1}}}], "Grid"],
      StripOnInput->False,
      LineSpacing->{0.9, 0, 1.5},
      LineIndent->0],
     TraditionalForm], "Output",
    CellSize->{550, Automatic},
    AutoStyleOptions->{"HighlightFormattingErrors"->False},
    ScriptLevel->0,
    NumberPoint->".",
    RenderingOptions->{"3DRenderingMethod"->"BSPTreeOrDepthBuffer"},
    FontFamily->"Times",
    FontSize->14,
    Background->None,
    GraphicsBoxOptions->{DefaultAxesStyle->Directive[
      GrayLevel[0, 0.35], FontColor -> GrayLevel[0.25], FontOpacity -> 1, 
      "GraphicsAxes"],
    DefaultBaseStyle->{FontFamily -> "Times", "Graphics"},
    DefaultFrameStyle->Directive[
      GrayLevel[0, 0.35], FontColor -> GrayLevel[0.25], FontOpacity -> 1, 
      "GraphicsFrame"],
    DefaultFrameTicksStyle->Directive[
     FontFamily -> "Times", FontSize -> 10, "GraphicsFrameTicks"],
    DefaultTicksStyle->Directive[
     FontFamily -> "Times", FontSize -> 10, "GraphicsTicks"]},
    Graphics3DBoxOptions->{
    DefaultBaseStyle->{FontFamily -> "Times", "Graphics3D"}}],
   BaseStyle->{Plain},
   FrameMargins->10,
   FrameStyle->GrayLevel[0.85],
   RoundingRadius->5,
   StripOnInput->False],
  WolframAlphaResult[
  "triple point density of argon ", {{"Result", 1}, "Content"}, 
   PodStates -> {"Result__Show details"}]]], "Output",
 CellLabel->"Out[11]=",
 CellID->151370983,ExpressionUUID->"4a407343-6833-4567-8b62-62308c2af00c"]
}, Open  ]],

Cell["Using ThermodynamicData package (i.e. REFPROP from NIST)", "ExampleText",
 CellID->361149294,ExpressionUUID->"97c07137-3c0f-429d-8df9-b07a88b16414"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UnitConvert", "[", 
  RowBox[{
   RowBox[{"ThermodynamicData", "[", 
    RowBox[{"\"\<Argon\>\"", ",", "\"\<TriplePointLiquidDensity\>\""}], "]"}],
    ",", 
   FractionBox["\"\<Grams\>\"", 
    SuperscriptBox["\"\<Centimeters\>\"", "3"]]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->305288497,ExpressionUUID->"8b6e4c55-8bc9-4f93-bb47-72cda64c6305"],

Cell[BoxData[
 TemplateBox[{"1.41675`6.", 
   RowBox[{"\"g\"", "\[InvisibleSpace]", "\"/\"", "\[InvisibleSpace]", 
     SuperscriptBox["\"cm\"", "3"]}], "grams per centimeter cubed", 
   FractionBox["\"Grams\"", 
    SuperscriptBox["\"Centimeters\"", "3"]]},
  "Quantity"]], "Output",
 CellLabel->"Out[5]=",
 CellID->677200180,ExpressionUUID->"d487e864-36c9-4616-a75f-3eba6f3c6173"]
}, Open  ]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"}, 
  Closed]]]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "PrimaryExamplesSection"}, 
  Closed]]]],

Cell[BoxData[GridBox[{
   {
    DynamicBox[FEPrivate`ImportImage[
      FrontEnd`FileName[{"Documentation", "FooterIcons"}, 
       "RelatedFunction.png"]],
     ImageSizeCache->{50., {27., 33.}}], GridBox[{
      {
       StyleBox[
        RowBox[{"See", " ", "Also"}], "SeeAlsoSection"]},
      {Cell[TextData[{
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["vtrliq"]], "paclet:NewEoSArgon/ref/vtrliq", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "e00d751e-077a-46b1-be14-9ff76a15a8ed"],
        "\[NonBreakingSpace]",
        StyleBox[
        "\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
         "InlineSeparator"],
        " ",
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["ttr"]], "paclet:NewEoSArgon/ref/ttr", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "de58f0bb-e313-478c-a32f-20da04ec60db"],
        "\[NonBreakingSpace]",
        StyleBox[
        "\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
         "InlineSeparator"],
        " ",
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["ptr"]], "paclet:NewEoSArgon/ref/ptr", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "ee754a3a-5c41-464b-aaef-c5f35981bbb7"],
        "\[NonBreakingSpace]",
        StyleBox[
        "\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
         "InlineSeparator"],
        " ",
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["rhotrgaz"]], "paclet:NewEoSArgon/ref/rhotrgaz", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "3a927219-1d15-43af-83c7-1cafb28154de"],
        "\[NonBreakingSpace]",
        StyleBox[
        "\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
         "InlineSeparator"],
        " ",
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["vtrgaz"]], "paclet:NewEoSArgon/ref/vtrgaz", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "13f26643-9450-4f78-a25b-934a22e66b43"]
       }], "SeeAlso",ExpressionUUID->"2d17b0de-17bf-40e8-b7e2-5b9025856aca"]}
     }]}
  }]], "SeeAlsoSection",ExpressionUUID->"54b5bbb9-c79a-441a-ba02-\
3a829cc7247c"],

Cell[BoxData[GridBox[{
   {
    DynamicBox[FEPrivate`ImportImage[
      FrontEnd`FileName[{"Documentation", "FooterIcons"}, "RelatedGuide.png"]],
     ImageSizeCache->{50., {27., 33.}}], GridBox[{
      {
       StyleBox[
        RowBox[{"Related", " ", "Guides"}], "MoreAboutSection"]},
      {
       RowBox[{"\[FilledVerySmallSquare]", Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["NewEoSArgon Package"]], 
           "paclet:NewEoSArgon/guide/NewEoSArgon"},
          "RefLinkPlain",
          BaseStyle->{"MoreAbout"}]], "MoreAbout",ExpressionUUID->
         "91236f2b-53cd-41c5-8c20-250232582732"]}]}
     }]}
  }]], "MoreAboutSection",ExpressionUUID->"d5b74f93-0298-42c2-8849-\
8bcd096e0fd7"],

Cell[BoxData[GridBox[{
   {
    TemplateBox[{29},
     "Spacer1"], GridBox[{
      {
       RowBox[{
        TemplateBox[{17},
         "Spacer1"], 
        StyleBox[
         RowBox[{"Related", " ", "Links"}], "RelatedLinksSection"]}]},
      {Cell[BoxData[Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData[
             RowBox[{
               RowBox[{"Units", " ", "&"}], " ", "Quantities"}]]], 
           "paclet:guide/Units"},
          "RefLinkPlain",
          BaseStyle->{"RelatedLinks"}]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "1be5dcd7-5388-4054-a5de-9b587495ae9e"]], "RelatedLinks",
        ExpressionUUID->"a649c0f3-0fbc-4977-86d5-3c86f8a4cb13"]},
      {Cell[BoxData[Cell[BoxData[Cell[BoxData[
          RowBox[{
           TemplateBox[{16},
            "Spacer1"], "\[FilledVerySmallSquare]", 
           TemplateBox[{
             Cell[
              TextData[
               Cell[
                TextData[{
                  Cell[
                   BoxData[
                    TemplateBox[{2}, "Spacer1"]]], "ThermodynamicData"}]]]], 
             "paclet:ref/ThermodynamicData"},
            "RefLink",
            BaseStyle->{"RelatedLinks"}]}]],ExpressionUUID->
          "4d753ada-3891-4538-a0d0-7c5d0de3ae78"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "ff892c50-2c7a-4f06-9f27-4177d617bd44"]], "RelatedLinks",
        ExpressionUUID->"1b98b043-2a5d-4a43-bd6e-1ddd45c5b147"]},
      {Cell[TextData[Cell[BoxData[
        RowBox[{
         TemplateBox[{16},
          "Spacer1"], "\[FilledVerySmallSquare]", Cell[BoxData[
          TemplateBox[{
            Cell[
             TextData[
              Cell[
               TextData[{
                 Cell[
                  BoxData[
                   TemplateBox[{2}, "Spacer1"]]], 
                 "Webbook de chimie NIST"}]]]], 
            "http://webbook.nist.gov/chemistry/fluid/"},
           "WebLink",
           BaseStyle->{"RelatedLinks"}]],ExpressionUUID->
          "97019bba-c6d7-4f37-beab-6a05c565c7d3"]}]],ExpressionUUID->
        "e007b739-ef3c-4dc1-a4c5-da1adb575631"]], "RelatedLinks",
        ExpressionUUID->"ba2a0b6c-62d2-484e-b4d7-fffef6f82b30"]}
     }]}
  }]], "RelatedLinksSection",ExpressionUUID->"8a8332f5-72d4-4fb0-b9fe-\
2b97c0882a0f"],

Cell[" ", "FooterCell",ExpressionUUID->"d1226ccd-48af-49e6-902e-c18c2f0a4774"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{900, 835.8},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"rhotrliq [\[Rho]trliq]",
TaggingRules->{
 "ModificationHighlight" -> False, "ColorType" -> "", "LinkTrails" -> "", 
  "HasOptions" -> True, "ExampleCounter" -> 1, 
  "Openers" -> {
   "PrimaryExamplesSection" -> Open, "ExampleSection" -> {"0" -> Open}, 
    "NotesSection" -> Closed}, "NewStyles" -> True, 
  "CitationPopupData" -> $Failed, "ShowCitation" -> False, "RootCaptions" -> 
  "", "Metadata" -> {
   "built" -> "{2023, 11, 30, 13, 56, 5.0562754}", 
    "history" -> {"XX", "", "", ""}, "context" -> "NewEoSArgon`", 
    "keywords" -> {}, "specialkeywords" -> {}, 
    "tutorialcollectionlinks" -> {}, "index" -> True, "label" -> 
    "New Eo S Argon Package Symbol", "language" -> "en", "paclet" -> 
    "NewEoSArgon Package", "status" -> "None", "summary" -> 
    "rhotrliq (g/cm^3) Densit\[EAcute] du liquide au point triple de l'argon \
donn\[EAcute]e par NIST [Triple point liquid density of argon from NIST]", 
    "synonyms" -> {}, "tabletags" -> {}, "title" -> "rhotrliq [\[Rho]trliq]", 
    "titlemodifier" -> "", "metadescription" -> "", "windowtitle" -> 
    "rhotrliq [\[Rho]trliq]", "type" -> "Symbol", "uri" -> 
    "NewEoSArgon/ref/rhotrliq"}},
CellContext->"Global`",
FrontEndVersion->"13.3 pour Microsoft Windows (64-bit) (July 24, 2023)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "13.3 pour Microsoft Windows (64-bit) (July 24, 2023)", 
  StyleDefinitions -> "Default.nb"],
ExpressionUUID->"90845377-834f-47ed-bd05-b446352a520d"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[11567, 311, 1419, 37, 35, "PrimaryExamplesSection",ExpressionUUID->"5dea2b5f-d39a-4729-9efd-392005e96f59",
   CellTags->"PrimaryExamplesSection",
   CellID->14172657]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 54915, 1337}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[594, 21, 5535, 133, 56, "AnchorBarGrid",ExpressionUUID->"b0237bfe-5541-4683-9331-36d977b16d9b",
 CellID->1],
Cell[6132, 156, 94, 0, 23, "ContextNameCell",ExpressionUUID->"44f88f3f-807c-4fd0-bc78-cc1c4014a8fe"],
Cell[CellGroupData[{
Cell[6251, 160, 565, 14, 56, "ObjectNameGrid",ExpressionUUID->"87d48d4a-23fc-4f4b-8ec1-5b73d68f467d"],
Cell[6819, 176, 814, 20, 146, "Usage",ExpressionUUID->"638eccee-912a-408a-88f8-5e6b87a55620"]
}, Open  ]],
Cell[CellGroupData[{
Cell[7670, 201, 1917, 48, 37, "NotesSection",ExpressionUUID->"490d0fa3-d3e1-4bca-bc5b-078e9dd05360",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1268058],
Cell[9590, 251, 832, 23, 38, "Notes",ExpressionUUID->"7287a4f4-bafa-4edf-b5a3-dfa8c17eee42",
 CellID->1067943069],
Cell[10425, 276, 185, 4, 36, "Notes",ExpressionUUID->"6d6cad60-4254-45fc-8fe4-dbf2d75f8a31",
 CellID->185021568],
Cell[10613, 282, 827, 23, 38, "Notes",ExpressionUUID->"210fc90c-f0b2-4628-ba86-0bebd6b0a4de",
 CellID->489383078]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "NotesSection"}, Closed]]]],
Cell[CellGroupData[{
Cell[11567, 311, 1419, 37, 35, "PrimaryExamplesSection",ExpressionUUID->"5dea2b5f-d39a-4729-9efd-392005e96f59",
 CellTags->"PrimaryExamplesSection",
 CellID->14172657],
Cell[CellGroupData[{
Cell[13011, 352, 1398, 36, 30, "ExampleSection",ExpressionUUID->"3a252e9c-a01b-4f5b-872a-49dabd985c65",
 CellID->192488861],
Cell[14412, 390, 174, 3, 26, "Input",ExpressionUUID->"072f710b-25bb-483a-aaf3-e6d7cba0a9eb",
 CellID->87419684],
Cell[14589, 395, 139, 1, 38, "ExampleText",ExpressionUUID->"306e9caa-6f7c-43cb-9874-19c3fefc1b05",
 CellID->886239600],
Cell[CellGroupData[{
Cell[14753, 400, 204, 4, 26, "Input",ExpressionUUID->"b2acd08d-48fd-4f20-a767-b80d4b6e0594",
 CellID->21488140],
Cell[14960, 406, 391, 8, 45, "Output",ExpressionUUID->"c4f41dfe-e90c-464b-83c1-8427ec837ea3",
 CellID->358226006]
}, Open  ]],
Cell[CellGroupData[{
Cell[15388, 419, 872, 23, 30, "Input",ExpressionUUID->"615fdc8f-35f0-4c0d-9451-5bad628e935e",
 CellID->15641702],
Cell[16263, 444, 389, 8, 45, "Output",ExpressionUUID->"7a8e4e53-869a-4775-a905-60c4ab5cb4de",
 CellID->162896280]
}, Open  ]],
Cell[16667, 455, 142, 1, 38, "ExampleText",ExpressionUUID->"c2466b1e-7ad1-4baf-adfd-42c7f20f43b8",
 CellID->278961620],
Cell[CellGroupData[{
Cell[16834, 460, 297, 7, 26, "Input",ExpressionUUID->"df461d77-2588-43f2-b679-17e0f7d0dc1d",
 CellID->295872759],
Cell[17134, 469, 390, 8, 45, "Output",ExpressionUUID->"df1d5d89-30ab-4f3f-a306-e8bda8d0971f",
 CellID->62816057]
}, Open  ]],
Cell[17539, 480, 116, 1, 38, "ExampleText",ExpressionUUID->"daf18fd5-b7d9-4185-a368-58ed44ad3d62",
 CellID->351008126],
Cell[CellGroupData[{
Cell[17680, 485, 22863, 472, 457, "WolframAlphaShortInput",ExpressionUUID->"dd4b2b2c-b76c-4ded-af01-9493a1203a54",
 CellID->19751437],
Cell[40546, 959, 5131, 131, 106, "Output",ExpressionUUID->"4a407343-6833-4567-8b62-62308c2af00c",
 CellID->151370983]
}, Open  ]],
Cell[45692, 1093, 154, 1, 70, "ExampleText",ExpressionUUID->"97c07137-3c0f-429d-8df9-b07a88b16414",
 CellID->361149294],
Cell[CellGroupData[{
Cell[45871, 1098, 380, 9, 70, "Input",ExpressionUUID->"8b6e4c55-8bc9-4f93-bb47-72cda64c6305",
 CellID->305288497],
Cell[46254, 1109, 382, 8, 45, "Output",ExpressionUUID->"d487e864-36c9-4616-a75f-3eba6f3c6173",
 CellID->677200180]
}, Open  ]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"}, Closed]]]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "PrimaryExamplesSection"}, Closed]]]],
Cell[46878, 1126, 2892, 78, 70, "SeeAlsoSection",ExpressionUUID->"54b5bbb9-c79a-441a-ba02-3a829cc7247c"],
Cell[49773, 1206, 729, 19, 70, "MoreAboutSection",ExpressionUUID->"d5b74f93-0298-42c2-8849-8bcd096e0fd7"],
Cell[50505, 1227, 2350, 62, 70, "RelatedLinksSection",ExpressionUUID->"8a8332f5-72d4-4fb0-b9fe-2b97c0882a0f"],
Cell[52858, 1291, 78, 0, 70, "FooterCell",ExpressionUUID->"d1226ccd-48af-49e6-902e-c18c2f0a4774"]
}
]
*)

(* End of internal cache information *)

