(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 13.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     23288,        613]
NotebookOptionsPosition[     18219,        508]
NotebookOutlinePosition[     20493,        564]
CellTagsIndexPosition[     20408,        559]
WindowTitle->rhotrliqNv [\:03C1trliqNv]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[GridBox[{
   {GridBox[{
      {
       ItemBox[Cell[BoxData[
         RowBox[{
          TemplateBox[{12},
           "Spacer1"], Cell["NEW EO S ARGON PACKAGE SYMBOL", "PacletNameCell",
           TextAlignment->Center,ExpressionUUID->
           "cd9cdc77-c11a-402e-b4f1-835d47a6a040"], 
          TemplateBox[{8},
           "Spacer1"]}]],
         TextAlignment->Center,ExpressionUUID->
         "795e3998-37a8-4271-9f90-d227cee0a9fc"],
        Background->RGBColor[0.490196, 0.576471, 0.690196],
        ItemSize->Full], ""}
     },
     GridBoxAlignment->{"Rows" -> {{Center}}},
     GridBoxItemSize->{"Columns" -> {Full, 
         Scaled[0.02]}, "Rows" -> {{2.5}}}], Cell[TextData[{
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "See Also",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "d6a1731c-bc64-416e-b152-dc4b3dcd17bb"]
         }],ExpressionUUID->"59a9c32d-464d-4ff0-be15-2662c7747d82"],
         StripOnInput->False],{
        "\"ttr\"" :> Documentation`HelpLookup["paclet:NewEoSArgon/ref/ttr"], 
         "\"ptrNv\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/ptrNv"], 
         "\"rhotrgazNv\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/rhotrgazNv"]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"SeeAlso"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "067d3f14-fb75-49a7-8eb2-f33e43b7c8b8"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "Related Guides",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "b1a4f041-bc66-4130-b587-e40e72ac2607"]
         }],ExpressionUUID->"3ef1066a-9e65-4789-8fcc-807982dc169d"],
         StripOnInput->False],{
        "\"NewEoSArgon Package\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/guide/NewEoSArgon"]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"MoreAbout"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "d8319d49-cfcd-4e15-933d-3409eecdd149"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "URL",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "bf7de5d8-5487-444b-93d4-6869b8d48a5a"]
         }],ExpressionUUID->"3556d71d-fcd2-4872-8610-6dd836e7448e"],
         StripOnInput->False],{
        "\"NewEoSArgon/ref/rhotrliqNv\"" :> None, 
         "\"Copy Wolfram Documentation Center URL\"" :> 
         Module[{DocumentationSearch`Private`nb$}, 
           DocumentationSearch`Private`nb$ = 
            NotebookPut[
             Notebook[{Cell["NewEoSArgon/ref/rhotrliqNv"]}, Visible -> 
               False]]; 
           SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
           FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
           NotebookClose[DocumentationSearch`Private`nb$]; Null], Delimiter, 
         "\"Copy web URL\"" :> 
         Module[{DocumentationSearch`Private`nb$}, 
           DocumentationSearch`Private`nb$ = 
            NotebookPut[
             Notebook[{
               Cell[BoxData[
                 MakeBoxes[
                  Hyperlink[
                   "http://reference.wolfram.com/language/NewEoSArgon/ref/\
rhotrliqNv.html"], StandardForm]], "Input", TextClipboardType -> 
                 "PlainText"]}, Visible -> False]]; 
           SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
           FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
           NotebookClose[DocumentationSearch`Private`nb$]; Null], 
         "\"Go to web URL\"" :> 
         FrontEndExecute[{
           NotebookLocate[{
             URL[If[TrueQ[DocumentationBuild`Make`Private`wsmlinkQ$28456], 
                 "http://reference.wolfram.com/system-modeler/", 
                 "http://reference.wolfram.com/language/"] <> 
               "NewEoSArgon/ref/rhotrliqNv" <> ".html"], None}]}]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"URLMenu"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "a9b06987-50b7-496a-8ca3-7d4e520c696e"]
    }], "AnchorBar",
     CacheGraphics->False,ExpressionUUID->
     "11a6673e-652d-49bb-830c-e6ce707aa7ae"]}
  }]], "AnchorBarGrid",
 CellID->1,ExpressionUUID->"c9d8014f-3127-41b3-b61d-ada1139e7494"],

Cell["NewEoSArgon`", "ContextNameCell",ExpressionUUID->"a0c3ce12-a6af-4400-94df-68b071f3f427"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     Cell[
     "rhotrliqNv [\[Rho]trliqNv]", "ObjectName",ExpressionUUID->
      "ee5328c6-d2ad-4930-9176-a935bfd2093d"],
     Cell[BoxData[
      TemplateBox[{8},
       "Spacer1"]],ExpressionUUID->"de590862-4e64-4253-93d1-8697faba5018"],
     Cell[BoxData[
     ""], "ObjectNameTranslation",ExpressionUUID->
      "d6fd3a53-725c-4977-98dc-8ac00e5bebd5"]
    }],ExpressionUUID->"db178823-a009-4127-926f-2c43afed573e"], 
    "\[SpanFromLeft]"}
  }]], "ObjectNameGrid",ExpressionUUID->"ef51a601-e817-47eb-bd05-\
e687a9f4b0de"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["rhotrliqNv"], "InlineFormula",
      ShowStringCharacters->False,
      FontFamily->"Source Sans Pro",ExpressionUUID->
      "a78a9e30-5135-41c0-8775-972e0b6d4363"],
     "  (g/",
     Cell[BoxData[
      SuperscriptBox["cm", "3"]], "InlineFormula",
      FontFamily->"Source Sans Pro",ExpressionUUID->
      "c5c30dbf-c93d-49fb-8c4b-90e0dcc647fd"],
     ")\nDensit\[EAcute] du ",
     StyleBox["liquide",
      FontSlant->"Italic"],
     " au point triple de l'argon d\[EAcute]duite des relations de Maxwell\n\
[Triple point ",
     StyleBox["liquid",
      FontSlant->"Italic"],
     " density of argon from Maxwell relations]"
    }],ExpressionUUID->"f0490c60-6318-49a3-90b4-799cc26708fd"]}
  }]], "Usage",
 Deletable->True,ExpressionUUID->"4ad1963b-b45a-49bb-9298-8b5691424317"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {
       TaggingRules, "Openers", "PrimaryExamplesSection"}, Open], 
      Alternatives[True, Open]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{13.600000000000001`, {5., 8.600000000000001}}]],
  ExpressionUUID->"d1beed43-fbbf-4845-81b1-404b11b9338f"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"b4d95434-4c05-403d-ac7c-1fac11607afb"],
 "Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "95486ae1-8c3f-4d3e-8dfa-fd22aaaaac32"]
}], "PrimaryExamplesSection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellTags->"PrimaryExamplesSection",
 CellID->150723261,ExpressionUUID->"32036e65-9788-4d31-87cc-c5ea25c2bf61"],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"},
        Closed], 
      Alternatives[Open, True]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{13.600000000000001`, {5., 8.600000000000001}}]],
  ExpressionUUID->"44588821-0cb3-4626-b5d4-19f0d9e6714c"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"d9ab2a87-a152-40ed-8c88-429bdbe4c8cb"],
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "54d9e7e1-7c27-4642-b437-f9b320c9561b"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellID->261316281,ExpressionUUID->"6eb5b69c-a02c-439d-af0e-056ee2df8fa9"],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<NewEoSArgon`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->87419684,ExpressionUUID->"4187c56b-4381-44cf-9301-707c4862f6e9"],

Cell["Give a physical dimension to the constant", "ExampleText",
 CellID->886239600,ExpressionUUID->"1be2d1b6-7211-4839-b36e-cb0c572420af"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Quantity", "[", 
  RowBox[{"\[Rho]trliqNv", ",", "\"\<g/cm^3\>\""}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->21488140,ExpressionUUID->"75291729-0d69-4ce6-a735-ef1368d5c2d8"],

Cell[BoxData[
 TemplateBox[{"1.4168019421690525`", 
   RowBox[{"\"g\"", "\[InvisibleSpace]", "\"/\"", "\[InvisibleSpace]", 
     SuperscriptBox["\"cm\"", "3"]}], "grams per centimeter cubed", 
   FractionBox["\"Grams\"", 
    SuperscriptBox["\"Centimeters\"", "3"]]},
  "Quantity"]], "Output",
 CellLabel->"Out[2]=",
 CellID->147073226,ExpressionUUID->"e199851e-9742-4e49-9bf5-1b05c1e422ee"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UnitConvert", "[", 
  RowBox[{
   TemplateBox[{"1.4168019421690525`"},
    "QuantityUnit",
    DisplayFunction->(TooltipBox[
      StyleBox[
       RowBox[{#, "\[InvisibleSpace]", 
         StyleBox[
          RowBox[{" ", 
            
            RowBox[{"\"g\"", "\[InvisibleSpace]", "\"/\"", 
              "\[InvisibleSpace]", 
              SuperscriptBox["\"cm\"", "3"]}]}], 
          "QuantityUnitTraditionalLabel"]}], ShowStringCharacters -> False], 
      "Unit: grams per centimeter cubed"]& ),
    InterpretationFunction->(RowBox[{"Quantity", "[", 
       RowBox[{#, ",", 
         FractionBox["\"Grams\"", 
          SuperscriptBox["\"Centimeters\"", "3"]]}], "]"}]& )], ",", 
   "\"\<kg/m^3\>\""}], "]"}]], "Input",
 NumberMarks->False,
 CellLabel->"In[3]:=",
 CellID->192322222,ExpressionUUID->"896aa2ef-66af-4f3a-941d-99fd26f1fb5f"],

Cell[BoxData[
 TemplateBox[{"1416.8019421690526`", 
   RowBox[{"\"kg\"", "\[InvisibleSpace]", "\"/\"", "\[InvisibleSpace]", 
     SuperscriptBox["\"m\"", "3"]}], "kilograms per meter cubed", 
   FractionBox["\"Kilograms\"", 
    SuperscriptBox["\"Meters\"", "3"]]},
  "Quantity"]], "Output",
 CellLabel->"Out[3]=",
 CellID->14406995,ExpressionUUID->"f45619a1-8b94-4512-896d-cb2304e6404c"]
}, Open  ]],

Cell["Relative error with NIST constant", "ExampleText",
 CellID->32289193,ExpressionUUID->"988cb3c1-a66c-4819-9338-1db7ce832fe7"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Quantity", "[", 
  RowBox[{
   RowBox[{"100", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"\[Rho]trliq", "-", "\[Rho]trliqNv"}], ")"}], "/", 
     "\[Rho]trliq"}]}], ",", "\"\<%\>\""}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->91147354,ExpressionUUID->"98a5ad42-4fb7-4a5d-ab9e-33a8e94c1a2d"],

Cell[BoxData[
 TemplateBox[{
   RowBox[{"-", "0.000014722149774235647`"}], "\"%\"", "percent", 
   "\"Percent\""},
  "QuantityPostfix"]], "Output",
 ImageSize->{71, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->520541975,ExpressionUUID->"78744f38-3143-4e8b-a5a7-1398ba59aff2"]
}, Open  ]],

Cell["Molar volume corresponding to \[Rho]trliqNv", "ExampleText",
 CellID->222855593,ExpressionUUID->"b19df81e-5857-4573-895e-d97e78fee14c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Quantity", "[", 
   RowBox[{"M", ",", "\"\<g/mol\>\""}], "]"}], "/", 
  RowBox[{"Quantity", "[", 
   RowBox[{"\[Rho]trliqNv", ",", "\"\<g/cm^3\>\""}], "]"}]}]], "Input",
 CellLabel->"In[5]:=",
 CellID->295872759,ExpressionUUID->"70119826-a7fa-4d95-935f-a59e5ab1c894"],

Cell[BoxData[
 TemplateBox[{"28.195895848957985`", 
   RowBox[{
     SuperscriptBox["\"cm\"", "3"], "\[NegativeMediumSpace]", "\"/\"", 
     "\[InvisibleSpace]", "\"mol\""}], "centimeters cubed per mole", 
   FractionBox[
    SuperscriptBox["\"Centimeters\"", "3"], "\"Moles\""]},
  "Quantity"]], "Output",
 ImageSize->{102, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->17688701,ExpressionUUID->"46796c79-b279-483d-a935-4621c64d3597"]
}, Open  ]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"}, 
  Closed]]]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "PrimaryExamplesSection"}, 
  Closed]]]],

Cell[BoxData[GridBox[{
   {
    DynamicBox[FEPrivate`ImportImage[
      FrontEnd`FileName[{"Documentation", "FooterIcons"}, 
       "RelatedFunction.png"]],
     ImageSizeCache->{50., {27., 33.}}], GridBox[{
      {
       StyleBox[
        RowBox[{"See", " ", "Also"}], "SeeAlsoSection"]},
      {Cell[TextData[{
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["ttr"]], "paclet:NewEoSArgon/ref/ttr", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "86649928-fa2c-493b-ba43-9b6909ff71a0"],
        "\[NonBreakingSpace]",
        StyleBox[
        "\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
         "InlineSeparator"],
        " ",
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["ptrNv"]], "paclet:NewEoSArgon/ref/ptrNv", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "fcbb7767-dc68-425b-a608-8176d7da8450"],
        "\[NonBreakingSpace]",
        StyleBox[
        "\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
         "InlineSeparator"],
        " ",
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["rhotrgazNv"]], "paclet:NewEoSArgon/ref/rhotrgazNv", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "73427598-b7ba-452a-8c70-69b838b1871f"]
       }], "SeeAlso",ExpressionUUID->"3e362985-bb4f-4fc9-b668-88f5198eaa68"]}
     }]}
  }]], "SeeAlsoSection",ExpressionUUID->"243f745c-84e1-4b0e-b741-\
43d3991fd2da"],

Cell[BoxData[GridBox[{
   {
    DynamicBox[FEPrivate`ImportImage[
      FrontEnd`FileName[{"Documentation", "FooterIcons"}, "RelatedGuide.png"]],
     ImageSizeCache->{50., {27., 33.}}], GridBox[{
      {
       StyleBox[
        RowBox[{"Related", " ", "Guides"}], "MoreAboutSection"]},
      {
       RowBox[{"\[FilledVerySmallSquare]", Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["NewEoSArgon Package"]], 
           "paclet:NewEoSArgon/guide/NewEoSArgon"},
          "RefLinkPlain",
          BaseStyle->{"MoreAbout"}]], "MoreAbout",ExpressionUUID->
         "cc246836-83e9-48d1-ac59-97b73f63089e"]}]}
     }]}
  }]], "MoreAboutSection",ExpressionUUID->"6e25caaf-6c2e-44a7-a8d1-\
3a2e0e9ebf81"],

Cell[BoxData[GridBox[{
   {
    TemplateBox[{29},
     "Spacer1"], GridBox[{
      {
       RowBox[{
        TemplateBox[{17},
         "Spacer1"], 
        StyleBox[
         RowBox[{"Related", " ", "Links"}], "RelatedLinksSection"]}]},
      {Cell[BoxData[Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData[
             RowBox[{
               RowBox[{"Units", " ", "&"}], " ", "Quantities"}]]], 
           "paclet:guide/Units"},
          "RefLinkPlain",
          BaseStyle->{"RelatedLinks"}]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "32988943-ab0b-4dd0-9598-eeb1034e27a8"]], "RelatedLinks",
        ExpressionUUID->"0dd9f047-5894-4485-ad07-184e2de1b988"]}
     }]}
  }]], "RelatedLinksSection",ExpressionUUID->"bf9db254-197d-4cf8-b804-\
6b4947ab3bdc"],

Cell[" ", "FooterCell",ExpressionUUID->"13ad1cd8-a235-41e2-99e7-05b619a17d3c"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{900, 835.8},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"rhotrliqNv [\[Rho]trliqNv]",
TaggingRules->{
 "ModificationHighlight" -> False, "ColorType" -> "", "LinkTrails" -> "", 
  "HasOptions" -> True, "ExampleCounter" -> 1, 
  "Openers" -> {
   "PrimaryExamplesSection" -> Open, "ExampleSection" -> {"0" -> Open}}, 
  "NewStyles" -> True, "CitationPopupData" -> $Failed, "ShowCitation" -> 
  False, "RootCaptions" -> "", 
  "Metadata" -> {
   "built" -> "{2023, 11, 30, 13, 56, 6.0617195}", 
    "history" -> {"XX", "", "", ""}, "context" -> "NewEoSArgon`", 
    "keywords" -> {}, "specialkeywords" -> {}, 
    "tutorialcollectionlinks" -> {}, "index" -> True, "label" -> 
    "New Eo S Argon Package Symbol", "language" -> "en", "paclet" -> 
    "NewEoSArgon Package", "status" -> "None", "summary" -> 
    "rhotrliqNv (g/cm^3) Densit\[EAcute] du liquide au point triple de \
l'argon d\[EAcute]duite des relations de Maxwell [Triple point liquid density \
of argon from Maxwell relations]", "synonyms" -> {}, "tabletags" -> {}, 
    "title" -> "rhotrliqNv [\[Rho]trliqNv]", "titlemodifier" -> "", 
    "metadescription" -> "", "windowtitle" -> "rhotrliqNv [\[Rho]trliqNv]", 
    "type" -> "Symbol", "uri" -> "NewEoSArgon/ref/rhotrliqNv"}},
CellContext->"Global`",
FrontEndVersion->"13.3 pour Microsoft Windows (64-bit) (July 24, 2023)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "13.3 pour Microsoft Windows (64-bit) (July 24, 2023)", 
  StyleDefinitions -> "Default.nb"],
ExpressionUUID->"b05982dc-e750-440d-a3b5-5eb4705f5c24"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7566, 200, 1420, 37, 35, "PrimaryExamplesSection",ExpressionUUID->"32036e65-9788-4d31-87cc-c5ea25c2bf61",
   CellTags->"PrimaryExamplesSection",
   CellID->150723261]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 20209, 552}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[598, 21, 5389, 131, 56, "AnchorBarGrid",ExpressionUUID->"c9d8014f-3127-41b3-b61d-ada1139e7494",
 CellID->1],
Cell[5990, 154, 94, 0, 23, "ContextNameCell",ExpressionUUID->"a0c3ce12-a6af-4400-94df-68b071f3f427"],
Cell[CellGroupData[{
Cell[6109, 158, 569, 14, 56, "ObjectNameGrid",ExpressionUUID->"ef51a601-e817-47eb-bd05-e687a9f4b0de"],
Cell[6681, 174, 848, 21, 146, "Usage",ExpressionUUID->"4ad1963b-b45a-49bb-9298-8b5691424317"]
}, Open  ]],
Cell[CellGroupData[{
Cell[7566, 200, 1420, 37, 35, "PrimaryExamplesSection",ExpressionUUID->"32036e65-9788-4d31-87cc-c5ea25c2bf61",
 CellTags->"PrimaryExamplesSection",
 CellID->150723261],
Cell[CellGroupData[{
Cell[9011, 241, 1398, 36, 30, "ExampleSection",ExpressionUUID->"6eb5b69c-a02c-439d-af0e-056ee2df8fa9",
 CellID->261316281],
Cell[10412, 279, 174, 3, 26, "Input",ExpressionUUID->"4187c56b-4381-44cf-9301-707c4862f6e9",
 CellID->87419684],
Cell[10589, 284, 139, 1, 38, "ExampleText",ExpressionUUID->"1be2d1b6-7211-4839-b36e-cb0c572420af",
 CellID->886239600],
Cell[CellGroupData[{
Cell[10753, 289, 206, 4, 26, "Input",ExpressionUUID->"75291729-0d69-4ce6-a735-ef1368d5c2d8",
 CellID->21488140],
Cell[10962, 295, 391, 8, 45, "Output",ExpressionUUID->"e199851e-9742-4e49-9bf5-1b05c1e422ee",
 CellID->147073226]
}, Open  ]],
Cell[CellGroupData[{
Cell[11390, 308, 873, 23, 30, "Input",ExpressionUUID->"896aa2ef-66af-4f3a-941d-99fd26f1fb5f",
 CellID->192322222],
Cell[12266, 333, 388, 8, 45, "Output",ExpressionUUID->"f45619a1-8b94-4512-896d-cb2304e6404c",
 CellID->14406995]
}, Open  ]],
Cell[12669, 344, 130, 1, 38, "ExampleText",ExpressionUUID->"988cb3c1-a66c-4819-9338-1db7ce832fe7",
 CellID->32289193],
Cell[CellGroupData[{
Cell[12824, 349, 326, 9, 26, "Input",ExpressionUUID->"98a5ad42-4fb7-4a5d-ab9e-33a8e94c1a2d",
 CellID->91147354],
Cell[13153, 360, 332, 9, 40, "Output",ExpressionUUID->"78744f38-3143-4e8b-a5a7-1398ba59aff2",
 CellID->520541975]
}, Open  ]],
Cell[13500, 372, 141, 1, 38, "ExampleText",ExpressionUUID->"b19df81e-5857-4573-895e-d97e78fee14c",
 CellID->222855593],
Cell[CellGroupData[{
Cell[13666, 377, 302, 7, 26, "Input",ExpressionUUID->"70119826-a7fa-4d95-935f-a59e5ab1c894",
 CellID->295872759],
Cell[13971, 386, 491, 12, 43, "Output",ExpressionUUID->"46796c79-b279-483d-a935-4621c64d3597",
 CellID->17688701]
}, Open  ]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"}, Closed]]]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "PrimaryExamplesSection"}, Closed]]]],
Cell[14704, 407, 1870, 50, 114, "SeeAlsoSection",ExpressionUUID->"243f745c-84e1-4b0e-b741-43d3991fd2da"],
Cell[16577, 459, 729, 19, 70, "MoreAboutSection",ExpressionUUID->"6e25caaf-6c2e-44a7-a8d1-3a2e0e9ebf81"],
Cell[17309, 480, 825, 24, 70, "RelatedLinksSection",ExpressionUUID->"bf9db254-197d-4cf8-b804-6b4947ab3bdc"],
Cell[18137, 506, 78, 0, 70, "FooterCell",ExpressionUUID->"13ad1cd8-a235-41e2-99e7-05b619a17d3c"]
}
]
*)

(* End of internal cache information *)

