(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 13.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     39214,        956]
NotebookOptionsPosition[     34259,        852]
NotebookOutlinePosition[     36401,        907]
CellTagsIndexPosition[     36316,        902]
WindowTitle->tc
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[GridBox[{
   {GridBox[{
      {
       ItemBox[Cell[BoxData[
         RowBox[{
          TemplateBox[{12},
           "Spacer1"], Cell["NEW EO S ARGON PACKAGE SYMBOL", "PacletNameCell",
           TextAlignment->Center,ExpressionUUID->
           "c5881aba-e28f-4509-9d6a-ddb9c9451e45"], 
          TemplateBox[{8},
           "Spacer1"]}]],
         TextAlignment->Center,ExpressionUUID->
         "fb11702e-33bb-4d47-98b9-073012c9b558"],
        Background->RGBColor[0.490196, 0.576471, 0.690196],
        ItemSize->Full], ""}
     },
     GridBoxAlignment->{"Rows" -> {{Center}}},
     GridBoxItemSize->{"Columns" -> {Full, 
         Scaled[0.02]}, "Rows" -> {{2.5}}}], Cell[TextData[{
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "See Also",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "3978f187-359a-41f4-9ea1-e20c4cf39a3d"]
         }],ExpressionUUID->"8c2fa6c4-5683-4785-92bf-ffd3a60785ea"],
         StripOnInput->False],{
        "\"pc\"" :> Documentation`HelpLookup["paclet:NewEoSArgon/ref/pc"], 
         "\"rhoc\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/rhoc"], "\"zc\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/zc"]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"SeeAlso"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "dfbc44e9-eca1-4f36-b764-56568cf5d325"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "Related Guides",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "b5f892d1-c897-437c-ada8-e7d9360506aa"]
         }],ExpressionUUID->"d295ac82-efc1-40cd-a5c8-311378f90ccb"],
         StripOnInput->False],{
        "\"NewEoSArgon Package\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/guide/NewEoSArgon"]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"MoreAbout"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "abc65cd7-c74a-4f08-9d81-88d715f9ed77"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "URL",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "f61940b7-dd9b-4444-8f90-68e5a640e52b"]
         }],ExpressionUUID->"cd0f6e0a-f131-47cb-b744-1a27b5db9352"],
         StripOnInput->False],{
        "\"NewEoSArgon/ref/tc\"" :> None, 
         "\"Copy Wolfram Documentation Center URL\"" :> 
         Module[{DocumentationSearch`Private`nb$}, 
           DocumentationSearch`Private`nb$ = 
            NotebookPut[
             Notebook[{Cell["NewEoSArgon/ref/tc"]}, Visible -> False]]; 
           SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
           FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
           NotebookClose[DocumentationSearch`Private`nb$]; Null], Delimiter, 
         "\"Copy web URL\"" :> 
         Module[{DocumentationSearch`Private`nb$}, 
           DocumentationSearch`Private`nb$ = 
            NotebookPut[
             Notebook[{
               Cell[BoxData[
                 MakeBoxes[
                  Hyperlink[
                   "http://reference.wolfram.com/language/NewEoSArgon/ref/tc.\
html"], StandardForm]], "Input", TextClipboardType -> "PlainText"]}, Visible -> 
               False]]; 
           SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
           FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
           NotebookClose[DocumentationSearch`Private`nb$]; Null], 
         "\"Go to web URL\"" :> 
         FrontEndExecute[{
           NotebookLocate[{
             URL[If[TrueQ[DocumentationBuild`Make`Private`wsmlinkQ$29941], 
                 "http://reference.wolfram.com/system-modeler/", 
                 "http://reference.wolfram.com/language/"] <> 
               "NewEoSArgon/ref/tc" <> ".html"], None}]}]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"URLMenu"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "2a5d8ba9-5be9-4e1d-8757-6ae21627440f"]
    }], "AnchorBar",
     CacheGraphics->False,ExpressionUUID->
     "6d68afc5-73e2-4a2f-973a-d2bc3f29d421"]}
  }]], "AnchorBarGrid",
 CellID->1,ExpressionUUID->"07021055-cdc8-490a-954d-90f7a90e9f7e"],

Cell["NewEoSArgon`", "ContextNameCell",ExpressionUUID->"b0ad21a0-5883-4c5a-ace8-f55a550983c0"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     Cell[
     "tc", "ObjectName",ExpressionUUID->
      "7c03bab3-d3be-40ac-b998-506626752b3f"],
     Cell[BoxData[
      TemplateBox[{8},
       "Spacer1"]],ExpressionUUID->"89ffbb5c-7576-49e4-a608-87f8b47e8a83"],
     Cell[BoxData[
     ""], "ObjectNameTranslation",ExpressionUUID->
      "81175556-3503-4192-895e-1b7848c67187"]
    }],ExpressionUUID->"7f3c68d9-8974-4299-a3b6-89628ef0fdf5"], 
    "\[SpanFromLeft]"}
  }]], "ObjectNameGrid",ExpressionUUID->"7bd45079-f633-449d-b970-\
b410b8598110"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["tc"], "InlineFormula",
      ShowStringCharacters->False,
      FontFamily->"Source Sans Pro",ExpressionUUID->
      "644f2fb2-1cc2-4dbf-9ddd-c5ce7ab49907"],
     " (Kelvin)\nTemp\[EAcute]rature du point critique de l'argon donn\
\[EAcute]e par NIST \n[Critical temperature of argon from NIST]"
    }],ExpressionUUID->"6592554e-4cde-4ed6-b95a-5e7791e80c47"]}
  }]], "Usage",
 Deletable->True,ExpressionUUID->"14405733-9548-49cc-9d46-1853a073bd51"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {
       TaggingRules, "Openers", "PrimaryExamplesSection"}, Open], 
      Alternatives[True, Open]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{13.600000000000001`, {5., 8.600000000000001}}]],
  ExpressionUUID->"5e70778a-7eab-4ab5-a830-b79f43a4d8eb"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"489aec67-35c1-4eda-af99-dba4d9cbd959"],
 "Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "80c61f8e-bb1e-438a-9e3c-a64af884b18f"]
}], "PrimaryExamplesSection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellTags->"PrimaryExamplesSection",
 CellID->249437731,ExpressionUUID->"91548560-dee9-44f2-a965-3805352a5313"],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"},
        Closed], 
      Alternatives[Open, True]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{13.600000000000001`, {5., 8.600000000000001}}]],
  ExpressionUUID->"c284e516-77b4-45bf-9b46-c6c990df595c"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"0cfc99f6-01ca-42dc-b415-80a9557a2423"],
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "6417e850-d7d9-4dba-8189-2e5ad521491a"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellID->203980695,ExpressionUUID->"b3e8af8e-517d-47fb-8233-9538b2f06e2b"],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<NewEoSArgon`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->87419684,ExpressionUUID->"39c322b8-7f13-4b53-88f1-acc9a42faa37"],

Cell["Give a physical dimension to the constant", "ExampleText",
 CellID->886239600,ExpressionUUID->"0a3e1c2e-ac71-4e32-adf2-2463f29001c2"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Quantity", "[", 
  RowBox[{"tc", ",", "\"\<Kelvins\>\""}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->21488140,ExpressionUUID->"2d9e4e45-463c-4d0e-8a0f-c5ed45c70495"],

Cell[BoxData[
 TemplateBox[{"150.687`", "\"K\"", "kelvins", "\"Kelvins\""},
  "Quantity"]], "Output",
 CellLabel->"Out[2]=",
 CellID->66912053,ExpressionUUID->"90afe8ce-6a1e-417c-90db-afb9e7613324"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UnitConvert", "[", 
  RowBox[{
   TemplateBox[{"150.687`"},
    "QuantityUnit",
    DisplayFunction->(TooltipBox[
      StyleBox[
       RowBox[{#, "\[InvisibleSpace]", 
         StyleBox[
          RowBox[{" ", "\"K\""}], "QuantityUnitTraditionalLabel"]}], 
       ShowStringCharacters -> False], "Unit: kelvins"]& ),
    InterpretationFunction->(RowBox[{"Quantity", "[", 
       RowBox[{#, ",", "\"Kelvins\""}], "]"}]& )], ",", 
   "\"\<DegreesCelsius\>\""}], "]"}]], "Input",
 NumberMarks->False,
 CellLabel->"In[3]:=",
 CellID->822596027,ExpressionUUID->"15ec4e93-2b27-4e54-b839-76692315078c"],

Cell[BoxData[
 TemplateBox[{
   RowBox[{"-", "122.46299999999997`"}], "\"\[Degree]C\"", "degrees Celsius", 
   "\"DegreesCelsius\""},
  "Quantity"]], "Output",
 CellLabel->"Out[3]=",
 CellID->14287866,ExpressionUUID->"5e865723-4a1a-4957-ac3e-97f84daae788"]
}, Open  ]],

Cell["Using WolframAlpha", "ExampleText",
 CellID->351008126,ExpressionUUID->"d57b667e-e649-4e26-a161-420c45226a82"],

Cell[CellGroupData[{

Cell[BoxData[
 NamespaceBox["WolframAlphaQueryResults",
  DynamicModuleBox[{Typeset`q$$ = "Critical temperature of argon", 
   Typeset`opts$$ = {
   AppearanceElements -> {
     "Extrusion", "Warnings", "Assumptions", "Pods", "Unsuccessful"}, 
    Asynchronous -> All, 
    Method -> {
     "ExtrusionChosen" -> {
       "Fast parse", "Fast parse", 1, 0, "Input", 
        "ElementData[\"Argon\", \"CriticalTemperature\"]"}, "ExtrusionOpen" -> 
      True, "Formats" -> {
       "cell", "minput", "moutput", "msound", "dataformats"}}}, 
   Typeset`elements$$ = {
   "Extrusion", "Warnings", "Assumptions", "Pods", "Unsuccessful"}, 
   Typeset`pod1$$ = XMLElement[
   "pod", {"title" -> "Input interpretation", "scanner" -> "Identity", "id" -> 
     "Input", "position" -> "100", "error" -> "false", "numsubpods" -> "1"}, {
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement[
       "minput", {}, {"ElementData[\"Argon\", \"CriticalTemperature\"]"}], 
       XMLElement["cell", {"compressed" -> False, "string" -> True}, {
         Cell[
          BoxData[
           FormBox[
            TagBox[
             FormBox[
              TagBox[
               GridBox[{{
                  PaneBox[
                   StyleBox[
                    TagBox[
                    GridBox[{{
                    StyleBox[
                    TagBox[
                    TagBox["\"argon\"", 
                    $CellContext`TagBoxWrapper[
                    "Entity" -> {ElementData, "Argon"}]], Identity], {
                    LineIndent -> 0, LineSpacing -> {0.9, 0, 1.5}}], 
                    TagBox["\"critical temperature\"", 
                    $CellContext`TagBoxWrapper[
                    "Property" -> {ElementData, "CriticalTemperature"}]]}}, 
                    GridBoxBackground -> {"Columns" -> {
                    GrayLevel[0.949], None}, "Rows" -> {{None}}}, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    ColumnsEqual -> False, RowsEqual -> False, 
                    GridBoxDividers -> {"Columns" -> {
                    GrayLevel[0.84], 
                    GrayLevel[0.84], 
                    GrayLevel[0.84]}, "Rows" -> {{
                    GrayLevel[0.84]}}, 
                    "RowsIndexed" -> {
                    1 -> GrayLevel[0.84], -1 -> GrayLevel[0.84]}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {1, 1, 1}, "Rows" -> {{0.3}}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Baseline}}}, 
                    AllowScriptLevelChange -> False, BaselinePosition -> 1], 
                    $CellContext`TagBoxWrapper["Separator" -> " | "]], 
                    LineSpacing -> {1, 0, 1.5}, LineIndent -> 0], 
                   BaselinePosition -> Center]}}, 
                GridBoxItemSize -> {
                 "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                ColumnsEqual -> False, RowsEqual -> False, 
                GridBoxSpacings -> {"Columns" -> {{
                    AbsoluteThickness[-1]}}, "Rows" -> {{0}}}, 
                AllowScriptLevelChange -> False], 
               $CellContext`TagBoxWrapper["Separator" -> " | "]], 
              TraditionalForm], 
             PolynomialForm[#, TraditionalOrder -> False]& ], 
            TraditionalForm]], "Output"]}], 
       XMLElement[
       "dataformats", {}, {
        "plaintext,minput,computabledata,formatteddata"}]}]}], 
   Typeset`pod2$$ = XMLElement[
   "pod", {"title" -> "Result", "scanner" -> "Data", "id" -> "Result", 
     "position" -> "200", "error" -> "false", "numsubpods" -> "1", "primary" -> 
     "true"}, {
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement["moutput", {}, {"Quantity[150.87, \"Kelvins\"]"}], 
       XMLElement["cell", {"compressed" -> False, "string" -> True}, {
         Cell[
          BoxData[
           FormBox[
            StyleBox[
             TagBox[
              RowBox[{
                TagBox[
                 TagBox[
                  RowBox[{
                    TagBox["150.87", 
                    $CellContext`TagBoxWrapper["StringBoxes" -> "150.87"]], 
                    "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    "\"K\"", FontFamily -> "Helvetica", FontSize -> 
                    Smaller]}], Identity], #& , SyntaxForm -> Dot], "  ", 
                StyleBox[
                 
                 RowBox[{
                  "\"(\"", "\[NoBreak]", "\"kelvins\"", "\[NoBreak]", 
                   "\")\""}], {
                 FontFamily :> $CellContext`$UnitFontFamily, FontSize -> 
                  Smaller, 
                  GrayLevel[0.6], LinebreakAdjustments -> {1, 100, 1, 0, 100},
                   LineIndent -> 0}, StripOnInput -> False]}], "Unit", 
              SyntaxForm -> Dot], LinebreakAdjustments -> {1, 100, 1, 0, 100},
              LineIndent -> 0, ZeroWidthTimes -> False], TraditionalForm]], 
          "Output"]}], 
       XMLElement[
       "dataformats", {}, {
        "plaintext,moutput,computabledata,formatteddata,numberdata,\
quantitydata"}]}]}], Typeset`pod3$$ = XMLElement[
   "pod", {"title" -> "Unit conversions", "scanner" -> "Unit", "id" -> 
     "UnitConversion", "position" -> "300", "error" -> "false", "numsubpods" -> 
     "5"}, {
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement["cell", {"compressed" -> False, "string" -> True}, {
         Cell[
          BoxData[
           FormBox[
            StyleBox[
             TagBox[
              RowBox[{
                TagBox[
                 TagBox[
                  RowBox[{
                    RowBox[{"-", 
                    TagBox["122.28", 
                    $CellContext`TagBoxWrapper["StringBoxes" -> "122.28"]]}], 
                    "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    "\"\[Degree]C\"", FontFamily -> "Helvetica", FontSize -> 
                    Smaller]}], Identity], #& , SyntaxForm -> Dot], "  ", 
                StyleBox[
                 
                 RowBox[{
                  "\"(\"", "\[NoBreak]", "\"degrees Celsius\"", "\[NoBreak]", 
                   "\")\""}], {
                 FontFamily :> $CellContext`$UnitFontFamily, FontSize -> 
                  Smaller, 
                  GrayLevel[0.6], LinebreakAdjustments -> {1, 100, 1, 0, 100},
                   LineIndent -> 0}, StripOnInput -> False]}], "Unit", 
              SyntaxForm -> Dot], LinebreakAdjustments -> {1, 100, 1, 0, 100},
              LineIndent -> 0, ZeroWidthTimes -> False], TraditionalForm]], 
          "Output"]}], 
       XMLElement[
       "dataformats", {}, {
        "plaintext,computabledata,formatteddata,numberdata,quantitydata"}]}], 
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement["cell", {"compressed" -> False, "string" -> True}, {
         Cell[
          BoxData[
           FormBox[
            StyleBox[
             TagBox[
              RowBox[{
                TagBox[
                 TagBox[
                  RowBox[{
                    RowBox[{"-", 
                    TagBox["188.1", 
                    $CellContext`TagBoxWrapper["StringBoxes" -> "188.1"]]}], 
                    "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    "\"\[Degree]F\"", FontFamily -> "Helvetica", FontSize -> 
                    Smaller]}], Identity], #& , SyntaxForm -> Dot], "  ", 
                StyleBox[
                 
                 RowBox[{
                  "\"(\"", "\[NoBreak]", "\"degrees Fahrenheit\"", 
                   "\[NoBreak]", "\")\""}], {
                 FontFamily :> $CellContext`$UnitFontFamily, FontSize -> 
                  Smaller, 
                  GrayLevel[0.6], LinebreakAdjustments -> {1, 100, 1, 0, 100},
                   LineIndent -> 0}, StripOnInput -> False]}], "Unit", 
              SyntaxForm -> Dot], LinebreakAdjustments -> {1, 100, 1, 0, 100},
              LineIndent -> 0, ZeroWidthTimes -> False], TraditionalForm]], 
          "Output"]}], 
       XMLElement[
       "dataformats", {}, {
        "plaintext,computabledata,formatteddata,numberdata,quantitydata"}]}], 
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement["cell", {"compressed" -> False, "string" -> True}, {
         Cell[
          BoxData[
           FormBox[
            StyleBox[
             TagBox[
              RowBox[{
                TagBox[
                 TagBox[
                  RowBox[{
                    TagBox["271.57", 
                    $CellContext`TagBoxWrapper["StringBoxes" -> "271.57"]], 
                    "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    "\"\[Degree]R\"", FontFamily -> "Helvetica", FontSize -> 
                    Smaller]}], Identity], #& , SyntaxForm -> Dot], "  ", 
                StyleBox[
                 
                 RowBox[{
                  "\"(\"", "\[NoBreak]", "\"degrees Rankine\"", "\[NoBreak]", 
                   "\")\""}], {
                 FontFamily :> $CellContext`$UnitFontFamily, FontSize -> 
                  Smaller, 
                  GrayLevel[0.6], LinebreakAdjustments -> {1, 100, 1, 0, 100},
                   LineIndent -> 0}, StripOnInput -> False]}], "Unit", 
              SyntaxForm -> Dot], LinebreakAdjustments -> {1, 100, 1, 0, 100},
              LineIndent -> 0, ZeroWidthTimes -> False], TraditionalForm]], 
          "Output"]}], 
       XMLElement[
       "dataformats", {}, {
        "plaintext,computabledata,formatteddata,numberdata,quantitydata"}]}], 
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement["cell", {"compressed" -> False, "string" -> True}, {
         Cell[
          BoxData[
           FormBox[
            StyleBox[
             TagBox[
              RowBox[{
                TagBox[
                 TagBox[
                  RowBox[{
                    RowBox[{"-", 
                    TagBox["97.82", 
                    $CellContext`TagBoxWrapper["StringBoxes" -> "97.82"]]}], 
                    "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    "\"\[Degree]R\[EAcute]\"", FontFamily -> "Helvetica", 
                    FontSize -> Smaller]}], Identity], #& , SyntaxForm -> 
                 Dot], "  ", 
                StyleBox[
                 
                 RowBox[{
                  "\"(\"", "\[NoBreak]", "\"degrees R\[EAcute]aumur\"", 
                   "\[NoBreak]", "\")\""}], {
                 FontFamily :> $CellContext`$UnitFontFamily, FontSize -> 
                  Smaller, 
                  GrayLevel[0.6], LinebreakAdjustments -> {1, 100, 1, 0, 100},
                   LineIndent -> 0}, StripOnInput -> False]}], "Unit", 
              SyntaxForm -> Dot], LinebreakAdjustments -> {1, 100, 1, 0, 100},
              LineIndent -> 0, ZeroWidthTimes -> False], TraditionalForm]], 
          "Output"]}], 
       XMLElement[
       "dataformats", {}, {
        "plaintext,computabledata,formatteddata,numberdata,quantitydata"}]}], 
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement["cell", {"compressed" -> False, "string" -> True}, {
         Cell[
          BoxData[
           FormBox[
            StyleBox[
             TagBox[
              RowBox[{
                TagBox[
                 TagBox[
                  RowBox[{
                    RowBox[{"-", 
                    TagBox["56.697", 
                    $CellContext`TagBoxWrapper["StringBoxes" -> "56.697"]]}], 
                    "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    "\"\[Degree]R\[OSlash]\"", FontFamily -> "Helvetica", 
                    FontSize -> Smaller]}], Identity], #& , SyntaxForm -> 
                 Dot], "  ", 
                StyleBox[
                 
                 RowBox[{
                  "\"(\"", "\[NoBreak]", "\"degrees R\[OSlash]mer\"", 
                   "\[NoBreak]", "\")\""}], {
                 FontFamily :> $CellContext`$UnitFontFamily, FontSize -> 
                  Smaller, 
                  GrayLevel[0.6], LinebreakAdjustments -> {1, 100, 1, 0, 100},
                   LineIndent -> 0}, StripOnInput -> False]}], "Unit", 
              SyntaxForm -> Dot], LinebreakAdjustments -> {1, 100, 1, 0, 100},
              LineIndent -> 0, ZeroWidthTimes -> False], TraditionalForm]], 
          "Output"]}], 
       XMLElement[
       "dataformats", {}, {
        "plaintext,computabledata,formatteddata,numberdata,quantitydata"}]}]}]\
, Typeset`aux1$$ = {True, False, {False}, True}, Typeset`aux2$$ = {
   True, False, {False}, True}, Typeset`aux3$$ = {
   True, False, {False, False, False, False, False}, True}, 
   Typeset`asyncpods$$ = {}, Typeset`nonpods$$ = {
    XMLElement["sources", {"count" -> "1"}, {
      XMLElement[
      "source", {
       "url" -> 
        "http://www.wolframalpha.com/sources/\
ElementDataSourceInformationNotes.html", "text" -> "Element data"}, {}]}]}, 
   Typeset`initdone$$ = True, Typeset`queryinfo$$ = {
   "success" -> "true", "error" -> "false", "numpods" -> "3", "datatypes" -> 
    "Element", "timedout" -> "", "timedoutpods" -> "", "timing" -> "0.908", 
    "parsetiming" -> "0.331", "parsetimedout" -> "false", "recalculate" -> "",
     "id" -> "MSPa4041bcg1187d37bah3300001f941d108a9e7076", "host" -> 
    "http://www4b.wolframalpha.com", "server" -> "61", "related" -> 
    "http://www4b.wolframalpha.com/api/v2/relatedQueries.jsp?id=\
MSPa4051bcg1187d37bah3300000ga47bd1d814ae0d&s=61", "version" -> "2.6"}, 
   Typeset`sessioninfo$$ = {
   "TimeZone" -> 1., 
    "Date" -> {2014, 2, 6, 16, 51, 42.3292748`9.379215702655888}, "Line" -> 
    15, "SessionID" -> 23597506324272770568}, Typeset`showpods$$ = {1, 2, 3}, 
   Typeset`failedpods$$ = {}, Typeset`chosen$$ = {
   "Fast parse", "Fast parse", 1, 0, "Input", 
    "ElementData[\"Argon\", \"CriticalTemperature\"]"}, Typeset`open$$ = True,
    Typeset`newq$$ = "Critical temperature of argon"}, 
   DynamicBox[ToBoxes[
     AlphaIntegration`FormatAlphaResults[
      Dynamic[{
       1, {Typeset`pod1$$, Typeset`pod2$$, Typeset`pod3$$}, {
        Typeset`aux1$$, Typeset`aux2$$, Typeset`aux3$$}, Typeset`chosen$$, 
        Typeset`open$$, Typeset`elements$$, Typeset`q$$, Typeset`opts$$, 
        Typeset`nonpods$$, Typeset`queryinfo$$, Typeset`sessioninfo$$, 
        Typeset`showpods$$, Typeset`failedpods$$, Typeset`newq$$}]], 
     StandardForm],
    ImageSizeCache->{560., {445., 19.}},
    TrackedSymbols:>{Typeset`showpods$$, Typeset`failedpods$$}],
   DynamicModuleValues:>{},
   Initialization:>If[
     Not[Typeset`initdone$$], Null; WolframAlphaClient`Private`doAsyncUpdates[
       Hold[{Typeset`pod1$$, Typeset`pod2$$, Typeset`pod3$$}], 
       Typeset`asyncpods$$, 
       Dynamic[Typeset`failedpods$$]]; Typeset`asyncpods$$ = {}; 
     Typeset`initdone$$ = True],
   SynchronousInitialization->False],
  BaseStyle->{Deployed -> True},
  DeleteWithContents->True,
  Editable->False,
  SelectWithContents->True]], "WolframAlphaShortInput",
 CellLabel->"In[9]:=",
 CellID->987070,ExpressionUUID->"4df2cb60-f94b-4186-83b7-0e06fe67fd13"],

Cell[BoxData[
 TemplateBox[{"150.87`5.", "\"K\"", "kelvins", "\"Kelvins\""},
  "Quantity"]], "Output",
 CellLabel->"Out[9]=",
 CellID->35931389,ExpressionUUID->"81d6da42-6b0d-4cbb-9200-87554dbe24ec"]
}, Open  ]],

Cell["Using ThermodynamicData package (i.e. REFPROP from NIST)", "ExampleText",
 CellID->361149294,ExpressionUUID->"ab287160-21cc-4f77-9d76-e22df386cb9d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ThermodynamicData", "[", 
  RowBox[{"\"\<Argon\>\"", ",", "\"\<CriticalTemperature\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->305288497,ExpressionUUID->"b475d0bc-da15-48f5-b778-3151a6726b11"],

Cell[BoxData[
 TemplateBox[{"150.687`", "\"K\"", "kelvins", "\"Kelvins\""},
  "Quantity"]], "Output",
 CellLabel->"Out[4]=",
 CellID->352939475,ExpressionUUID->"f6d8cf75-79b7-44e6-b3df-ab2e19c1dfd4"]
}, Open  ]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"}, 
  Closed]]]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "PrimaryExamplesSection"}, 
  Closed]]]],

Cell[BoxData[GridBox[{
   {
    DynamicBox[FEPrivate`ImportImage[
      FrontEnd`FileName[{"Documentation", "FooterIcons"}, 
       "RelatedFunction.png"]],
     ImageSizeCache->{50., {27., 33.}}], GridBox[{
      {
       StyleBox[
        RowBox[{"See", " ", "Also"}], "SeeAlsoSection"]},
      {Cell[TextData[{
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["pc"]], "paclet:NewEoSArgon/ref/pc", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "096b25b0-9b0d-4f9d-91cd-7b3aa55ebb15"],
        "\[NonBreakingSpace]",
        StyleBox[
        "\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
         "InlineSeparator"],
        " ",
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["rhoc"]], "paclet:NewEoSArgon/ref/rhoc", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "4e18f90b-6c33-4b6c-a46c-4cf479a71f2d"],
        "\[NonBreakingSpace]",
        StyleBox[
        "\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
         "InlineSeparator"],
        " ",
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["zc"]], "paclet:NewEoSArgon/ref/zc", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "b93ede62-0f71-4702-a801-00396597f726"]
       }], "SeeAlso",ExpressionUUID->"19843045-accf-4fa1-be77-2a044ac890ff"]}
     }]}
  }]], "SeeAlsoSection",ExpressionUUID->"e653a5b4-5326-4f52-a2de-\
9e66ae957f02"],

Cell[BoxData[GridBox[{
   {
    DynamicBox[FEPrivate`ImportImage[
      FrontEnd`FileName[{"Documentation", "FooterIcons"}, "RelatedGuide.png"]],
     ImageSizeCache->{50., {27., 33.}}], GridBox[{
      {
       StyleBox[
        RowBox[{"Related", " ", "Guides"}], "MoreAboutSection"]},
      {
       RowBox[{"\[FilledVerySmallSquare]", Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["NewEoSArgon Package"]], 
           "paclet:NewEoSArgon/guide/NewEoSArgon"},
          "RefLinkPlain",
          BaseStyle->{"MoreAbout"}]], "MoreAbout",ExpressionUUID->
         "e6e75d7b-296a-47d2-aedf-0cafd9086bbc"]}]}
     }]}
  }]], "MoreAboutSection",ExpressionUUID->"51fd00ed-a805-400e-ad95-\
2919200fbd85"],

Cell[BoxData[GridBox[{
   {
    TemplateBox[{29},
     "Spacer1"], GridBox[{
      {
       RowBox[{
        TemplateBox[{17},
         "Spacer1"], 
        StyleBox[
         RowBox[{"Related", " ", "Links"}], "RelatedLinksSection"]}]},
      {Cell[BoxData[Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData[
             RowBox[{
               RowBox[{"Units", " ", "&"}], " ", "Quantities"}]]], 
           "paclet:guide/Units"},
          "RefLinkPlain",
          BaseStyle->{"RelatedLinks"}]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "185e5c2d-a97a-46ee-a865-ccf6933b30ef"]], "RelatedLinks",
        ExpressionUUID->"79e01bb9-a624-4dcb-8102-2af144407e61"]},
      {Cell[BoxData[Cell[BoxData[Cell[BoxData[
          RowBox[{
           TemplateBox[{16},
            "Spacer1"], "\[FilledVerySmallSquare]", 
           TemplateBox[{
             Cell[
              TextData[
               Cell[
                TextData[{
                  Cell[
                   BoxData[
                    TemplateBox[{2}, "Spacer1"]]], "ThermodynamicData"}]]]], 
             "paclet:ref/ThermodynamicData"},
            "RefLink",
            BaseStyle->{"RelatedLinks"}]}]],ExpressionUUID->
          "586e7ec5-6267-41da-bc0e-189b08bc454e"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "87017ac0-2585-4f50-8c50-079e1962ea1f"]], "RelatedLinks",
        ExpressionUUID->"822f0d5d-3e66-474d-adbd-9f4697d20e9e"]},
      {Cell[TextData[Cell[BoxData[
        RowBox[{
         TemplateBox[{16},
          "Spacer1"], "\[FilledVerySmallSquare]", Cell[BoxData[
          TemplateBox[{
            Cell[
             TextData[
              Cell[
               TextData[{
                 Cell[
                  BoxData[
                   TemplateBox[{2}, "Spacer1"]]], 
                 "Webbook de chimie NIST"}]]]], 
            "http://webbook.nist.gov/chemistry/fluid/"},
           "WebLink",
           BaseStyle->{"RelatedLinks"}]],ExpressionUUID->
          "bf5a21f4-5a42-4b85-9535-5f5be331b664"]}]],ExpressionUUID->
        "3682a5d1-1763-4f3e-832d-0428b0b0e406"]], "RelatedLinks",
        ExpressionUUID->"9ce42c12-d064-42e8-83e2-c409dc69e912"]}
     }]}
  }]], "RelatedLinksSection",ExpressionUUID->"50229d5a-d2a1-467c-8607-\
a2793347b88a"],

Cell[" ", "FooterCell",ExpressionUUID->"27347e64-7714-42f8-b8bb-67999ef268ab"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{900, 835.8},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"tc",
TaggingRules->{
 "ModificationHighlight" -> False, "ColorType" -> "", "LinkTrails" -> "", 
  "HasOptions" -> True, "ExampleCounter" -> 1, 
  "Openers" -> {
   "PrimaryExamplesSection" -> Open, "ExampleSection" -> {"0" -> Open}}, 
  "NewStyles" -> True, "CitationPopupData" -> $Failed, "ShowCitation" -> 
  False, "RootCaptions" -> "", 
  "Metadata" -> {
   "built" -> "{2023, 11, 30, 13, 56, 9.0057793}", 
    "history" -> {"XX", "", "", ""}, "context" -> "NewEoSArgon`", 
    "keywords" -> {}, "specialkeywords" -> {}, 
    "tutorialcollectionlinks" -> {}, "index" -> True, "label" -> 
    "New Eo S Argon Package Symbol", "language" -> "en", "paclet" -> 
    "NewEoSArgon Package", "status" -> "None", "summary" -> 
    "tc (Kelvin) Temp\[EAcute]rature du point critique de l'argon donn\
\[EAcute]e par NIST [Critical temperature of argon from NIST]", 
    "synonyms" -> {}, "tabletags" -> {}, "title" -> "tc", "titlemodifier" -> 
    "", "metadescription" -> "", "windowtitle" -> "tc", "type" -> "Symbol", 
    "uri" -> "NewEoSArgon/ref/tc"}},
CellContext->"Global`",
FrontEndVersion->"13.3 pour Microsoft Windows (64-bit) (July 24, 2023)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "13.3 pour Microsoft Windows (64-bit) (July 24, 2023)", 
  StyleDefinitions -> "Default.nb"],
ExpressionUUID->"7a07d5ba-ca17-4ee3-a1ef-c55bc09cd8ae"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7103, 187, 1420, 37, 35, "PrimaryExamplesSection",ExpressionUUID->"91548560-dee9-44f2-a965-3805352a5313",
   CellTags->"PrimaryExamplesSection",
   CellID->249437731]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 36117, 895}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[574, 21, 5309, 129, 56, "AnchorBarGrid",ExpressionUUID->"07021055-cdc8-490a-954d-90f7a90e9f7e",
 CellID->1],
Cell[5886, 152, 94, 0, 23, "ContextNameCell",ExpressionUUID->"b0ad21a0-5883-4c5a-ace8-f55a550983c0"],
Cell[CellGroupData[{
Cell[6005, 156, 545, 14, 56, "ObjectNameGrid",ExpressionUUID->"7bd45079-f633-449d-b970-b410b8598110"],
Cell[6553, 172, 513, 10, 146, "Usage",ExpressionUUID->"14405733-9548-49cc-9d46-1853a073bd51"]
}, Open  ]],
Cell[CellGroupData[{
Cell[7103, 187, 1420, 37, 35, "PrimaryExamplesSection",ExpressionUUID->"91548560-dee9-44f2-a965-3805352a5313",
 CellTags->"PrimaryExamplesSection",
 CellID->249437731],
Cell[CellGroupData[{
Cell[8548, 228, 1398, 36, 30, "ExampleSection",ExpressionUUID->"b3e8af8e-517d-47fb-8233-9538b2f06e2b",
 CellID->203980695],
Cell[9949, 266, 174, 3, 26, "Input",ExpressionUUID->"39c322b8-7f13-4b53-88f1-acc9a42faa37",
 CellID->87419684],
Cell[10126, 271, 139, 1, 38, "ExampleText",ExpressionUUID->"0a3e1c2e-ac71-4e32-adf2-2463f29001c2",
 CellID->886239600],
Cell[CellGroupData[{
Cell[10290, 276, 196, 4, 26, "Input",ExpressionUUID->"2d9e4e45-463c-4d0e-8a0f-c5ed45c70495",
 CellID->21488140],
Cell[10489, 282, 198, 4, 39, "Output",ExpressionUUID->"90afe8ce-6a1e-417c-90db-afb9e7613324",
 CellID->66912053]
}, Open  ]],
Cell[CellGroupData[{
Cell[10724, 291, 621, 16, 26, "Input",ExpressionUUID->"15ec4e93-2b27-4e54-b839-76692315078c",
 CellID->822596027],
Cell[11348, 309, 256, 6, 40, "Output",ExpressionUUID->"5e865723-4a1a-4957-ac3e-97f84daae788",
 CellID->14287866]
}, Open  ]],
Cell[11619, 318, 116, 1, 38, "ExampleText",ExpressionUUID->"d57b667e-e649-4e26-a161-420c45226a82",
 CellID->351008126],
Cell[CellGroupData[{
Cell[11760, 323, 16407, 356, 481, "WolframAlphaShortInput",ExpressionUUID->"4df2cb60-f94b-4186-83b7-0e06fe67fd13",
 CellID->987070],
Cell[28170, 681, 199, 4, 39, "Output",ExpressionUUID->"81d6da42-6b0d-4cbb-9200-87554dbe24ec",
 CellID->35931389]
}, Open  ]],
Cell[28384, 688, 154, 1, 70, "ExampleText",ExpressionUUID->"ab287160-21cc-4f77-9d76-e22df386cb9d",
 CellID->361149294],
Cell[CellGroupData[{
Cell[28563, 693, 232, 5, 70, "Input",ExpressionUUID->"b475d0bc-da15-48f5-b778-3151a6726b11",
 CellID->305288497],
Cell[28798, 700, 199, 4, 39, "Output",ExpressionUUID->"f6d8cf75-79b7-44e6-b3df-ab2e19c1dfd4",
 CellID->352939475]
}, Open  ]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"}, Closed]]]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "PrimaryExamplesSection"}, Closed]]]],
Cell[29239, 713, 1850, 50, 70, "SeeAlsoSection",ExpressionUUID->"e653a5b4-5326-4f52-a2de-9e66ae957f02"],
Cell[31092, 765, 729, 19, 70, "MoreAboutSection",ExpressionUUID->"51fd00ed-a805-400e-ad95-2919200fbd85"],
Cell[31824, 786, 2350, 62, 70, "RelatedLinksSection",ExpressionUUID->"50229d5a-d2a1-467c-8607-a2793347b88a"],
Cell[34177, 850, 78, 0, 70, "FooterCell",ExpressionUUID->"27347e64-7714-42f8-b8bb-67999ef268ab"]
}
]
*)

(* End of internal cache information *)

