(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 13.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     20714,        547]
NotebookOptionsPosition[     16121,        451]
NotebookOutlinePosition[     18300,        506]
CellTagsIndexPosition[     18215,        501]
WindowTitle->tcNv
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[GridBox[{
   {GridBox[{
      {
       ItemBox[Cell[BoxData[
         RowBox[{
          TemplateBox[{12},
           "Spacer1"], Cell["NEW EO S ARGON PACKAGE SYMBOL", "PacletNameCell",
           TextAlignment->Center,ExpressionUUID->
           "061cef40-6fc8-4e88-b3d4-ece729bacfc2"], 
          TemplateBox[{8},
           "Spacer1"]}]],
         TextAlignment->Center,ExpressionUUID->
         "e4260122-6a70-4e9a-98f5-a179251c3406"],
        Background->RGBColor[0.490196, 0.576471, 0.690196],
        ItemSize->Full], ""}
     },
     GridBoxAlignment->{"Rows" -> {{Center}}},
     GridBoxItemSize->{"Columns" -> {Full, 
         Scaled[0.02]}, "Rows" -> {{2.5}}}], Cell[TextData[{
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "See Also",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "36c1ff79-bc83-4f90-b6cd-ed4eece21651"]
         }],ExpressionUUID->"f549f1c7-e89e-4481-aa70-2050fde54810"],
         StripOnInput->False],{
        "\"tc\"" :> Documentation`HelpLookup["paclet:NewEoSArgon/ref/tc"], 
         "\"pcNv\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/pcNv"], 
         "\"rhocNv\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/rhocNv"]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"SeeAlso"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "8a962539-da6d-4614-9936-421c70dc84e3"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "Related Guides",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "2a49d293-e43d-4b86-930b-ec358d3c8ddb"]
         }],ExpressionUUID->"415b67a5-8670-45de-a819-679867904588"],
         StripOnInput->False],{
        "\"NewEoSArgon Package\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/guide/NewEoSArgon"]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"MoreAbout"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "162b0051-7599-403a-b1f5-923d25f117fb"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "URL",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "bb108624-58a4-410f-9ca8-801aed88a5a9"]
         }],ExpressionUUID->"140e9c74-0a52-4899-8d7b-fb66f221cfff"],
         StripOnInput->False],{
        "\"NewEoSArgon/ref/tcNv\"" :> None, 
         "\"Copy Wolfram Documentation Center URL\"" :> 
         Module[{DocumentationSearch`Private`nb$}, 
           DocumentationSearch`Private`nb$ = 
            NotebookPut[
             Notebook[{Cell["NewEoSArgon/ref/tcNv"]}, Visible -> False]]; 
           SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
           FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
           NotebookClose[DocumentationSearch`Private`nb$]; Null], Delimiter, 
         "\"Copy web URL\"" :> 
         Module[{DocumentationSearch`Private`nb$}, 
           DocumentationSearch`Private`nb$ = 
            NotebookPut[
             Notebook[{
               Cell[BoxData[
                 MakeBoxes[
                  Hyperlink[
                   "http://reference.wolfram.com/language/NewEoSArgon/ref/\
tcNv.html"], StandardForm]], "Input", TextClipboardType -> "PlainText"]}, 
               Visible -> False]]; 
           SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
           FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
           NotebookClose[DocumentationSearch`Private`nb$]; Null], 
         "\"Go to web URL\"" :> 
         FrontEndExecute[{
           NotebookLocate[{
             URL[If[TrueQ[DocumentationBuild`Make`Private`wsmlinkQ$30436], 
                 "http://reference.wolfram.com/system-modeler/", 
                 "http://reference.wolfram.com/language/"] <> 
               "NewEoSArgon/ref/tcNv" <> ".html"], None}]}]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"URLMenu"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "be5c123e-46a1-4057-bc24-db4d81e4fb6f"]
    }], "AnchorBar",
     CacheGraphics->False,ExpressionUUID->
     "04447fac-6c90-4f07-8162-573d68e9e612"]}
  }]], "AnchorBarGrid",
 CellID->1,ExpressionUUID->"cc1e8504-59b6-4b36-a416-4b9d2da6064d"],

Cell["NewEoSArgon`", "ContextNameCell",ExpressionUUID->"f9c98cbe-b78b-43ac-ad43-79e6074f530c"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     Cell[
     "tcNv", "ObjectName",ExpressionUUID->
      "e53e573d-a94d-49f2-8afd-c59d4b209345"],
     Cell[BoxData[
      TemplateBox[{8},
       "Spacer1"]],ExpressionUUID->"fad48f83-bb1e-472c-aea0-d4f71b1b7f79"],
     Cell[BoxData[
     ""], "ObjectNameTranslation",ExpressionUUID->
      "1f39990a-94fc-4f78-9279-147e81a3bc6e"]
    }],ExpressionUUID->"94a5d43c-00b1-43b1-b17a-7041286a4181"], 
    "\[SpanFromLeft]"}
  }]], "ObjectNameGrid",ExpressionUUID->"49a57c26-4ee3-4cb4-82a2-\
a328dcfc6cd1"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["tcNv"], "InlineFormula",
      ShowStringCharacters->False,
      FontFamily->"Source Sans Pro",ExpressionUUID->
      "f2d3b367-6568-4264-96a6-a0ad538cddf6"],
     " (Kelvin)\nTemp\[EAcute]rature du point critique de l'argon \
d\[EAcute]duite des relations de Maxwell \n[Critical temperature of argon \
from Maxwell relations]"
    }],ExpressionUUID->"0f37fd58-3782-4077-93ce-22cd1d92793f"]}
  }]], "Usage",
 Deletable->True,ExpressionUUID->"cb62570c-389c-4551-b9fb-1c52437d3511"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {
       TaggingRules, "Openers", "PrimaryExamplesSection"}, Open], 
      Alternatives[True, Open]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{13.600000000000001`, {5., 8.600000000000001}}]],
  ExpressionUUID->"6d012a7c-daaa-43a9-baaf-3f1d52614c8e"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"59276c08-18e1-4882-a292-f76f8698224c"],
 "Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "c138f212-af7a-42ed-bb4c-78319a5b6405"]
}], "PrimaryExamplesSection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellTags->"PrimaryExamplesSection",
 CellID->333431793,ExpressionUUID->"165357a7-4939-4af5-9678-7cad14f39bbd"],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"},
        Closed], 
      Alternatives[Open, True]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{13.600000000000001`, {5., 8.600000000000001}}]],
  ExpressionUUID->"73a62fb7-a377-481d-8b37-6b773950cfb9"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"b573b11f-be59-4a6d-aa4c-0be456737e91"],
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "5e20e15a-723f-48d9-94d0-f8adbf7a6784"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellID->44923733,ExpressionUUID->"e21bd267-1e56-49fe-83c3-e28a173b3e7f"],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<NewEoSArgon`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->87419684,ExpressionUUID->"a0981e91-d980-4879-82f1-f4b94dcf5d17"],

Cell["Give a physical dimension to the constant", "ExampleText",
 CellID->886239600,ExpressionUUID->"e7dbfcdd-5e59-4318-a3c1-f19903a533a8"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Quantity", "[", 
  RowBox[{"tcNv", ",", "\"\<Kelvins\>\""}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->21488140,ExpressionUUID->"a326070b-72da-4415-ba87-44b7ccbf9c25"],

Cell[BoxData[
 TemplateBox[{"151.396`", "\"K\"", "kelvins", "\"Kelvins\""},
  "Quantity"]], "Output",
 CellLabel->"Out[2]=",
 CellID->902692789,ExpressionUUID->"4c5e38a0-33ae-47ae-a179-b29e3de8a93b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UnitConvert", "[", 
  RowBox[{
   TemplateBox[{"151.396`"},
    "QuantityUnit",
    DisplayFunction->(TooltipBox[
      StyleBox[
       RowBox[{#, "\[InvisibleSpace]", 
         StyleBox[
          RowBox[{" ", "\"K\""}], "QuantityUnitTraditionalLabel"]}], 
       ShowStringCharacters -> False], "Unit: kelvins"]& ),
    InterpretationFunction->(RowBox[{"Quantity", "[", 
       RowBox[{#, ",", "\"Kelvins\""}], "]"}]& )], ",", 
   "\"\<DegreesCelsius\>\""}], "]"}]], "Input",
 NumberMarks->False,
 CellLabel->"In[3]:=",
 CellID->190718082,ExpressionUUID->"0616bd42-f989-467e-a86f-ec0f97c8c4f3"],

Cell[BoxData[
 TemplateBox[{
   RowBox[{"-", "121.75399999999999`"}], "\"\[Degree]C\"", "degrees Celsius", 
   "\"DegreesCelsius\""},
  "Quantity"]], "Output",
 CellLabel->"Out[3]=",
 CellID->105597256,ExpressionUUID->"b3ad4267-4b82-4337-aeb5-2ead63940ec3"]
}, Open  ]],

Cell["Relative error with NIST constant", "ExampleText",
 CellID->32289193,ExpressionUUID->"1b0cb201-dfba-471c-b5b4-aa2e67be088e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Quantity", "[", 
  RowBox[{
   RowBox[{"100", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"tc", "-", "tcNv"}], ")"}], "/", "tc"}]}], ",", "\"\<%\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->91147354,ExpressionUUID->"061e6f8a-4fc5-4782-bb7b-1a72fdb3c7d8"],

Cell[BoxData[
 TemplateBox[{
   RowBox[{"-", "0.47051172297542243`"}], "\"%\"", "percent", "\"Percent\""},
  "QuantityPostfix"]], "Output",
 CellLabel->"Out[4]=",
 CellID->47721908,ExpressionUUID->"4aa6fa61-47ea-4676-9ee0-5b428ac0d9c4"]
}, Open  ]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"}, 
  Closed]]]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "PrimaryExamplesSection"}, 
  Closed]]]],

Cell[BoxData[GridBox[{
   {
    DynamicBox[FEPrivate`ImportImage[
      FrontEnd`FileName[{"Documentation", "FooterIcons"}, 
       "RelatedFunction.png"]],
     ImageSizeCache->{50., {27., 33.}}], GridBox[{
      {
       StyleBox[
        RowBox[{"See", " ", "Also"}], "SeeAlsoSection"]},
      {Cell[TextData[{
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["tc"]], "paclet:NewEoSArgon/ref/tc", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "2688dd93-150c-41f1-86d9-0e2e5dcaa9f0"],
        "\[NonBreakingSpace]",
        StyleBox[
        "\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
         "InlineSeparator"],
        " ",
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["pcNv"]], "paclet:NewEoSArgon/ref/pcNv", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "06d4e2a0-857c-4c9f-bbb3-4f35f08d4579"],
        "\[NonBreakingSpace]",
        StyleBox[
        "\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
         "InlineSeparator"],
        " ",
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["rhocNv"]], "paclet:NewEoSArgon/ref/rhocNv", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "ffef03c2-a4d6-4a48-9fcb-80428a53ddb3"]
       }], "SeeAlso",ExpressionUUID->"517e51e7-ed4f-40d6-a860-67bf596e9d62"]}
     }]}
  }]], "SeeAlsoSection",ExpressionUUID->"b87818d2-3751-4063-ba4c-\
7a3bf4918d87"],

Cell[BoxData[GridBox[{
   {
    DynamicBox[FEPrivate`ImportImage[
      FrontEnd`FileName[{"Documentation", "FooterIcons"}, "RelatedGuide.png"]],
     ImageSizeCache->{50., {27., 33.}}], GridBox[{
      {
       StyleBox[
        RowBox[{"Related", " ", "Guides"}], "MoreAboutSection"]},
      {
       RowBox[{"\[FilledVerySmallSquare]", Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["NewEoSArgon Package"]], 
           "paclet:NewEoSArgon/guide/NewEoSArgon"},
          "RefLinkPlain",
          BaseStyle->{"MoreAbout"}]], "MoreAbout",ExpressionUUID->
         "cab1ea92-da44-4164-922a-40b024c543d0"]}]}
     }]}
  }]], "MoreAboutSection",ExpressionUUID->"c5a6dd49-7971-4018-91d6-\
c383f6141bbd"],

Cell[BoxData[GridBox[{
   {
    TemplateBox[{29},
     "Spacer1"], GridBox[{
      {
       RowBox[{
        TemplateBox[{17},
         "Spacer1"], 
        StyleBox[
         RowBox[{"Related", " ", "Links"}], "RelatedLinksSection"]}]},
      {Cell[BoxData[Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData[
             RowBox[{
               RowBox[{"Units", " ", "&"}], " ", "Quantities"}]]], 
           "paclet:guide/Units"},
          "RefLinkPlain",
          BaseStyle->{"RelatedLinks"}]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "747fb13a-3c41-4878-85dc-7f10180037f4"]], "RelatedLinks",
        ExpressionUUID->"3d913e07-7c56-4ffe-9363-c61310ba00ae"]}
     }]}
  }]], "RelatedLinksSection",ExpressionUUID->"7f33e9cd-0ba2-464e-bc4f-\
2cc32afb4ea5"],

Cell[" ", "FooterCell",ExpressionUUID->"f983ce00-39f2-44ce-ab89-fdfe57438d13"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{900, 835.8},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"tcNv",
TaggingRules->{
 "ModificationHighlight" -> False, "ColorType" -> "", "LinkTrails" -> "", 
  "HasOptions" -> True, "ExampleCounter" -> 1, 
  "Openers" -> {
   "PrimaryExamplesSection" -> Open, "ExampleSection" -> {"0" -> Open}}, 
  "NewStyles" -> True, "CitationPopupData" -> $Failed, "ShowCitation" -> 
  False, "RootCaptions" -> "", 
  "Metadata" -> {
   "built" -> "{2023, 11, 30, 13, 56, 9.8703860}", 
    "history" -> {"XX", "", "", ""}, "context" -> "NewEoSArgon`", 
    "keywords" -> {}, "specialkeywords" -> {}, 
    "tutorialcollectionlinks" -> {}, "index" -> True, "label" -> 
    "New Eo S Argon Package Symbol", "language" -> "en", "paclet" -> 
    "NewEoSArgon Package", "status" -> "None", "summary" -> 
    "tcNv (Kelvin) Temp\[EAcute]rature du point critique de l'argon \
d\[EAcute]duite des relations de Maxwell [Critical temperature of argon from \
Maxwell relations]", "synonyms" -> {}, "tabletags" -> {}, "title" -> "tcNv", 
    "titlemodifier" -> "", "metadescription" -> "", "windowtitle" -> "tcNv", 
    "type" -> "Symbol", "uri" -> "NewEoSArgon/ref/tcNv"}},
CellContext->"Global`",
FrontEndVersion->"13.3 pour Microsoft Windows (64-bit) (July 24, 2023)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "13.3 pour Microsoft Windows (64-bit) (July 24, 2023)", 
  StyleDefinitions -> "Default.nb"],
ExpressionUUID->"149edba6-87a8-4ee0-8936-ff04dd72552b"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7167, 189, 1420, 37, 35, "PrimaryExamplesSection",ExpressionUUID->"165357a7-4939-4af5-9678-7cad14f39bbd",
   CellTags->"PrimaryExamplesSection",
   CellID->333431793]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 18016, 494}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[576, 21, 5335, 130, 56, "AnchorBarGrid",ExpressionUUID->"cc1e8504-59b6-4b36-a416-4b9d2da6064d",
 CellID->1],
Cell[5914, 153, 94, 0, 23, "ContextNameCell",ExpressionUUID->"f9c98cbe-b78b-43ac-ad43-79e6074f530c"],
Cell[CellGroupData[{
Cell[6033, 157, 547, 14, 56, "ObjectNameGrid",ExpressionUUID->"49a57c26-4ee3-4cb4-82a2-a328dcfc6cd1"],
Cell[6583, 173, 547, 11, 146, "Usage",ExpressionUUID->"cb62570c-389c-4551-b9fb-1c52437d3511"]
}, Open  ]],
Cell[CellGroupData[{
Cell[7167, 189, 1420, 37, 35, "PrimaryExamplesSection",ExpressionUUID->"165357a7-4939-4af5-9678-7cad14f39bbd",
 CellTags->"PrimaryExamplesSection",
 CellID->333431793],
Cell[CellGroupData[{
Cell[8612, 230, 1397, 36, 30, "ExampleSection",ExpressionUUID->"e21bd267-1e56-49fe-83c3-e28a173b3e7f",
 CellID->44923733],
Cell[10012, 268, 174, 3, 26, "Input",ExpressionUUID->"a0981e91-d980-4879-82f1-f4b94dcf5d17",
 CellID->87419684],
Cell[10189, 273, 139, 1, 38, "ExampleText",ExpressionUUID->"e7dbfcdd-5e59-4318-a3c1-f19903a533a8",
 CellID->886239600],
Cell[CellGroupData[{
Cell[10353, 278, 198, 4, 26, "Input",ExpressionUUID->"a326070b-72da-4415-ba87-44b7ccbf9c25",
 CellID->21488140],
Cell[10554, 284, 199, 4, 39, "Output",ExpressionUUID->"4c5e38a0-33ae-47ae-a179-b29e3de8a93b",
 CellID->902692789]
}, Open  ]],
Cell[CellGroupData[{
Cell[10790, 293, 621, 16, 26, "Input",ExpressionUUID->"0616bd42-f989-467e-a86f-ec0f97c8c4f3",
 CellID->190718082],
Cell[11414, 311, 257, 6, 40, "Output",ExpressionUUID->"b3ad4267-4b82-4337-aeb5-2ead63940ec3",
 CellID->105597256]
}, Open  ]],
Cell[11686, 320, 130, 1, 38, "ExampleText",ExpressionUUID->"1b0cb201-dfba-471c-b5b4-aa2e67be088e",
 CellID->32289193],
Cell[CellGroupData[{
Cell[11841, 325, 296, 9, 26, "Input",ExpressionUUID->"061e6f8a-4fc5-4782-bb7b-1a72fdb3c7d8",
 CellID->91147354],
Cell[12140, 336, 236, 5, 40, "Output",ExpressionUUID->"4aa6fa61-47ea-4676-9ee0-5b428ac0d9c4",
 CellID->47721908]
}, Open  ]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"}, Closed]]]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "PrimaryExamplesSection"}, Closed]]]],
Cell[12618, 350, 1858, 50, 114, "SeeAlsoSection",ExpressionUUID->"b87818d2-3751-4063-ba4c-7a3bf4918d87"],
Cell[14479, 402, 729, 19, 114, "MoreAboutSection",ExpressionUUID->"c5a6dd49-7971-4018-91d6-c383f6141bbd"],
Cell[15211, 423, 825, 24, 101, "RelatedLinksSection",ExpressionUUID->"7f33e9cd-0ba2-464e-bc4f-2cc32afb4ea5"],
Cell[16039, 449, 78, 0, 70, "FooterCell",ExpressionUUID->"f983ce00-39f2-44ce-ab89-fdfe57438d13"]
}
]
*)

(* End of internal cache information *)

