(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 13.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     23993,        629]
NotebookOptionsPosition[     19111,        529]
NotebookOutlinePosition[     21306,        584]
CellTagsIndexPosition[     21221,        579]
WindowTitle->tmaxRonc
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[GridBox[{
   {GridBox[{
      {
       ItemBox[Cell[BoxData[
         RowBox[{
          TemplateBox[{12},
           "Spacer1"], Cell["NEW EO S ARGON SYMBOL", "PacletNameCell",
           TextAlignment->Center,ExpressionUUID->
           "6ab7f576-85dc-452d-ac3b-1025ccecff53"], 
          TemplateBox[{8},
           "Spacer1"]}]],
         TextAlignment->Center,ExpressionUUID->
         "07047d28-229e-44b9-8930-befc2a504c66"],
        Background->RGBColor[0.490196, 0.576471, 0.690196],
        ItemSize->Full], ""}
     },
     GridBoxAlignment->{"Rows" -> {{Center}}},
     GridBoxItemSize->{"Columns" -> {Full, 
         Scaled[0.02]}, "Rows" -> {{2.5}}}], Cell[TextData[{
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "See Also",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "70558f5a-8473-45fe-bab7-04da7f995803"]
         }],ExpressionUUID->"1e31b61b-f7fe-45dc-bd01-0a72eee6018b"],
         StripOnInput->False],{
        "\"ttr\"" :> Documentation`HelpLookup["paclet:NewEoSArgon/ref/ttr"], 
         "\"tc\"" :> Documentation`HelpLookup["paclet:NewEoSArgon/ref/tc"], 
         "\"rhomaxRonc\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/rhomaxRonc"]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"SeeAlso"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "ae74f579-b401-42b7-b0aa-4fa6cc9181d6"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "Related Guides",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "08671a2d-95c1-4ca3-be26-5f16dfa14a0a"]
         }],ExpressionUUID->"d9448742-aef3-4c4d-848b-6f111f6ee201"],
         StripOnInput->False],{
        "\"NewEoSArgon Package\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/guide/NewEoSArgon"]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"MoreAbout"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "364a8623-f0ba-4179-94cd-d3ee19d5ddfa"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "URL",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "97743d44-c97c-46a7-bf16-f1c2319c39b8"]
         }],ExpressionUUID->"b08a4531-7c6e-4bbc-8439-a9b7d910cfce"],
         StripOnInput->False],{
        "\"NewEoSArgon/ref/tmaxRonc\"" :> None, 
         "\"Copy Wolfram Documentation Center URL\"" :> 
         Module[{DocumentationSearch`Private`nb$}, 
           DocumentationSearch`Private`nb$ = 
            NotebookPut[
             Notebook[{Cell["NewEoSArgon/ref/tmaxRonc"]}, Visible -> False]]; 
           SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
           FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
           NotebookClose[DocumentationSearch`Private`nb$]; Null], Delimiter, 
         "\"Copy web URL\"" :> 
         Module[{DocumentationSearch`Private`nb$}, 
           DocumentationSearch`Private`nb$ = 
            NotebookPut[
             Notebook[{
               Cell[BoxData[
                 MakeBoxes[
                  Hyperlink[
                   "http://reference.wolfram.com/language/NewEoSArgon/ref/\
tmaxRonc.html"], StandardForm]], "Input", TextClipboardType -> "PlainText"]}, 
               Visible -> False]]; 
           SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
           FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
           NotebookClose[DocumentationSearch`Private`nb$]; Null], 
         "\"Go to web URL\"" :> 
         FrontEndExecute[{
           NotebookLocate[{
             URL[If[TrueQ[DocumentationBuild`Make`Private`wsmlinkQ$31414], 
                 "http://reference.wolfram.com/system-modeler/", 
                 "http://reference.wolfram.com/language/"] <> 
               "NewEoSArgon/ref/tmaxRonc" <> ".html"], None}]}]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"URLMenu"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "62923661-12f2-4b62-b961-11c3f7e990fc"]
    }], "AnchorBar",
     CacheGraphics->False,ExpressionUUID->
     "339757ab-2f7f-4f22-9196-9c4e9d6812de"]}
  }]], "AnchorBarGrid",
 CellID->1,ExpressionUUID->"e0088ce1-fabc-4551-bdc5-8cc13efd7819"],

Cell["NewEoSArgon`", "ContextNameCell",ExpressionUUID->"a045cdd4-0b2c-489e-9575-989299bde985"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     Cell[
     "tmaxRonc", "ObjectName",ExpressionUUID->
      "7aedb5ef-2bb1-4c8a-bb15-821844589b62"],
     Cell[BoxData[
      TemplateBox[{8},
       "Spacer1"]],ExpressionUUID->"a196834e-66ac-4755-b011-151ed9a851a0"],
     Cell[BoxData[
     ""], "ObjectNameTranslation",ExpressionUUID->
      "5a8b77c7-0d83-4dde-95c1-02bbeca3ca6d"]
    }],ExpressionUUID->"81b15b4d-6392-4630-bdad-dae330606707"], 
    "\[SpanFromLeft]"}
  }]], "ObjectNameGrid",ExpressionUUID->"d4fee7be-57e0-4da2-bc8a-\
b0123595a8bb"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{" ", "tmaxRonc"}]], "InlineFormula",
      ShowStringCharacters->False,
      FontFamily->"Source Sans Pro",ExpressionUUID->
      "640bfd1c-ddcb-4c22-990a-71f1187d30a2"],
     " (Kelvin)\nTemp\[EAcute]rature maximum des data de Ronchi relatives \
\[AGrave] l'argon\n[Maximum temperature of Ronchi's data for argon]"
    }],ExpressionUUID->"a8540b5d-804e-4b9e-bfac-8364303c3734"]}
  }]], "Usage",
 Deletable->True,
 CellID->982511436,ExpressionUUID->"a4f93283-52c7-4688-ab82-226a5e0c4171"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[Cell[TextData[{
   Cell[BoxData[
    DynamicBox[ToBoxes[
      If[
       MatchQ[
        CurrentValue[
         EvaluationNotebook[], {TaggingRules, "Openers", "NotesSection"}, 
         Closed], 
        Alternatives[Open, True]], 
       Style[
        Graphics[{
          Thickness[0.18], 
          RGBColor[0.8509803921568627, 0.396078431372549, 0], 
          Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
         PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
        0.68 Inherited], 
       Rotate[
        Style[
         Graphics[{
           Thickness[0.18], 
           RGBColor[0.8509803921568627, 0.396078431372549, 0], 
           Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
          PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
         0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
     ImageSizeCache->{
      13.600000000000001`, {0.5800000000000001, 13.020000000000001`}}]],
    ExpressionUUID->"c50caacc-be95-4401-8327-50d1a8e047f0"],
   Cell[BoxData[
    TemplateBox[{1},
     "Spacer1"]],ExpressionUUID->"288d83b1-6525-457f-bd43-eab4d94bc89e"],
   "Details and Options"
  }], "NotesFrameText",ExpressionUUID->"46e0a1b6-f325-40b4-9416-b24f0a3f9b21"],
  Appearance->{Automatic, None, "Normal", Automatic},
  BaseStyle->None,
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"], 
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], After, CellContents]}]& ),
  Evaluator->None,
  Method->
   "Preemptive"]],ExpressionUUID->"7cabdc05-6cc7-47a1-abda-fe5d2224c205"]], \
"NotesSection",
 WholeCellGroupOpener->True,
 CellGroupingRules->{"SectionGrouping", 50},
 CacheGraphics->False,
 CellID->173501745,ExpressionUUID->"8560dcd4-b883-40fd-a583-0b06fa7b87b6"],

Cell[TextData[{
 Cell[BoxData[
  SubscriptBox[
   StyleBox["T",
    FontSlant->"Italic"], 
   RowBox[{"max", ",", "Ronc"}]]], "InlineFormula",
  FontFamily->"Source Sans Pro",ExpressionUUID->
  "100a5d2d-25d7-484f-929d-8097716c6db7"],
 " = tmaxRonc repr\[EAcute]sente \[EAcute]galement la temp\[EAcute]rature \
maximum pour laquelle le mod\[EGrave]le est coh\[EAcute]rent et valide.\n",
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["C. Ronchi, J. Nucl. Mater. 96, 314 (1981)"]], 
    "http://dx.doi.org/10.1016/0022-3115(81)90575-4"},
   "WebLink",
   BaseStyle->{"Notes"}]],ExpressionUUID->
  "a56783b8-33bf-4943-beb6-2f56ce6862c5"]
}], "Notes",
 CellID->1067943069,ExpressionUUID->"ab9a2219-1d5d-4b52-876e-c528f3066a82"],

Cell["\<\
******************************************************************************\
*****\
\>", "Notes",
 CellID->185021568,ExpressionUUID->"c099a302-4087-4848-acba-684d27741bac"],

Cell[TextData[{
 Cell[BoxData[
  SubscriptBox[
   StyleBox["T",
    FontSlant->"Italic"], 
   RowBox[{"max", ",", "Ronc"}]]], "InlineFormula",
  FontFamily->"Source Sans Pro",ExpressionUUID->
  "d10444b5-9948-4333-805c-d405e149aeea"],
 " = tmaxRonc also represents the maximum temperature for which the model is \
consistent and valid.\n",
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["C. Ronchi, J. Nucl. Mater. 96, 314 (1981)"]], 
    "http://dx.doi.org/10.1016/0022-3115(81)90575-4"},
   "WebLink",
   BaseStyle->{"Notes"}]],ExpressionUUID->
  "cf915bcf-7e70-4cf5-8bc5-4710eea24550"]
}], "Notes",
 CellID->140761484,ExpressionUUID->"3ab9c684-920a-4d27-a688-3b928a893405"]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "NotesSection"}, Closed]]]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {
       TaggingRules, "Openers", "PrimaryExamplesSection"}, Open], 
      Alternatives[True, Open]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{13.600000000000001`, {5., 8.600000000000001}}]],
  ExpressionUUID->"a7907c74-9bf8-4298-aae9-2328429d61fd"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"787d25e1-a8a8-43c2-b93f-d352e1249e5a"],
 "Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "6e0e3012-e3a7-4246-aa76-cc20c4939d68"]
}], "PrimaryExamplesSection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellTags->"PrimaryExamplesSection",
 CellID->58762634,ExpressionUUID->"a981d2d6-d1eb-45e8-a7db-0c5030d1efc0"],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"},
        Closed], 
      Alternatives[Open, True]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{13.600000000000001`, {5., 8.600000000000001}}]],
  ExpressionUUID->"f9d5aca1-5b6b-45cd-8e35-b16e80ecf038"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"f2c280b4-5e93-4647-92cb-41c542ba95b4"],
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "a5185fe7-bf9a-4200-b1cd-c3e49fb7f29a"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellID->38820072,ExpressionUUID->"eac5d035-8e5a-416b-80e9-405a4f496952"],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<NewEoSArgon`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->87419684,ExpressionUUID->"f6aa8573-751e-43e3-a3d7-2fa5c1fc1d84"],

Cell["Give a physical dimension to the constant", "ExampleText",
 CellID->886239600,ExpressionUUID->"250c00b2-0e13-4ff1-bd5e-e6f67516adae"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Quantity", "[", 
  RowBox[{"tmaxRonc", ",", "\"\<Kelvins\>\""}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->21488140,ExpressionUUID->"097425a9-8c4a-4ee1-9f0a-fca136454e50"],

Cell[BoxData[
 TemplateBox[{"2300", "\"K\"", "kelvins", "\"Kelvins\""},
  "Quantity"]], "Output",
 CellLabel->"Out[2]=",
 CellID->212082245,ExpressionUUID->"264c2781-7daa-465a-a1dd-4d2c500aa7aa"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "@", 
  RowBox[{"UnitConvert", "[", 
   RowBox[{
    TemplateBox[{"2300"},
     "QuantityUnit",
     DisplayFunction->(TooltipBox[
       StyleBox[
        RowBox[{#, "\[InvisibleSpace]", 
          StyleBox[
           RowBox[{" ", "\"K\""}], "QuantityUnitTraditionalLabel"]}], 
        ShowStringCharacters -> False], "Unit: kelvins"]& ),
     InterpretationFunction->(RowBox[{"Quantity", "[", 
        RowBox[{#, ",", "\"Kelvins\""}], "]"}]& )], ",", 
    "\"\<DegreesCelsius\>\""}], "]"}]}]], "Input",
 NumberMarks->False,
 CellLabel->"In[3]:=",
 CellID->509781380,ExpressionUUID->"040e2480-6efb-45ed-9261-db8afac03098"],

Cell[BoxData[
 TemplateBox[{
  "2026.85`", "\"\[Degree]C\"", "degrees Celsius", "\"DegreesCelsius\""},
  "Quantity"]], "Output",
 CellLabel->"Out[3]=",
 CellID->844950976,ExpressionUUID->"82722c1c-52a1-4315-a1e7-697114a3a93c"]
}, Open  ]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"}, 
  Closed]]]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "PrimaryExamplesSection"}, 
  Closed]]]],

Cell[BoxData[GridBox[{
   {
    DynamicBox[FEPrivate`ImportImage[
      FrontEnd`FileName[{"Documentation", "FooterIcons"}, 
       "RelatedFunction.png"]],
     ImageSizeCache->{50., {27., 33.}}], GridBox[{
      {
       StyleBox[
        RowBox[{"See", " ", "Also"}], "SeeAlsoSection"]},
      {Cell[TextData[{
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["ttr"]], "paclet:NewEoSArgon/ref/ttr", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "70ff6274-c469-443e-a256-35fab0485aae"],
        "\[NonBreakingSpace]",
        StyleBox[
        "\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
         "InlineSeparator"],
        " ",
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["tc"]], "paclet:NewEoSArgon/ref/tc", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "4a3e2a45-7c71-43e2-966b-1245c44a0353"],
        "\[NonBreakingSpace]",
        StyleBox[
        "\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
         "InlineSeparator"],
        " ",
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["rhomaxRonc"]], "paclet:NewEoSArgon/ref/rhomaxRonc", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "e0e87680-4977-4d5a-9570-63d8ed281e17"]
       }], "SeeAlso",ExpressionUUID->"50f12bea-06dc-4909-b772-300043bc6998"]}
     }]}
  }]], "SeeAlsoSection",ExpressionUUID->"ddaf1061-04d8-4499-89ad-\
0c67c2443e78"],

Cell[BoxData[GridBox[{
   {
    DynamicBox[FEPrivate`ImportImage[
      FrontEnd`FileName[{"Documentation", "FooterIcons"}, "RelatedGuide.png"]],
     ImageSizeCache->{50., {27., 33.}}], GridBox[{
      {
       StyleBox[
        RowBox[{"Related", " ", "Guides"}], "MoreAboutSection"]},
      {
       RowBox[{"\[FilledVerySmallSquare]", Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["NewEoSArgon Package"]], 
           "paclet:NewEoSArgon/guide/NewEoSArgon"},
          "RefLinkPlain",
          BaseStyle->{"MoreAbout"}]], "MoreAbout",ExpressionUUID->
         "aaa0fc43-0ed0-416c-a4f0-b47f3b17fc3f"]}]}
     }]}
  }]], "MoreAboutSection",ExpressionUUID->"a747158d-342a-45b7-add0-\
fd79553403a6"],

Cell[BoxData[GridBox[{
   {
    TemplateBox[{29},
     "Spacer1"], GridBox[{
      {
       RowBox[{
        TemplateBox[{17},
         "Spacer1"], 
        StyleBox[
         RowBox[{"Related", " ", "Links"}], "RelatedLinksSection"]}]},
      {Cell[BoxData[Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData[
             RowBox[{
               RowBox[{"Units", " ", "&"}], " ", "Quantities"}]]], 
           "paclet:guide/Units"},
          "RefLinkPlain",
          BaseStyle->{"RelatedLinks"}]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "6baeb27c-5b7c-4486-9cb8-573f3fd4428f"]], "RelatedLinks",
        ExpressionUUID->"a3ffe874-98c0-4484-b8e7-aa6f5c7b1635"]}
     }]}
  }]], "RelatedLinksSection",ExpressionUUID->"659f6b16-5edb-4fa9-be2d-\
6ad63fb0bdf9"],

Cell[" ", "FooterCell",ExpressionUUID->"5a91d6a2-191a-4f2a-9e4f-3ccf6cbf5ab2"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{900, 835.8},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"tmaxRonc",
TaggingRules->{
 "ModificationHighlight" -> False, "ColorType" -> "", "LinkTrails" -> "", 
  "HasOptions" -> True, "ExampleCounter" -> 1, 
  "Openers" -> {
   "PrimaryExamplesSection" -> Open, "ExampleSection" -> {"0" -> Open}, 
    "NotesSection" -> Closed}, "NewStyles" -> True, 
  "CitationPopupData" -> $Failed, "ShowCitation" -> False, "RootCaptions" -> 
  "", "Metadata" -> {
   "built" -> "{2023, 11, 30, 13, 56, 11.6520236}", 
    "history" -> {"0.0", "", "", ""}, "context" -> "NewEoSArgon`", 
    "keywords" -> {}, "specialkeywords" -> {}, 
    "tutorialcollectionlinks" -> {}, "index" -> True, "label" -> 
    "New Eo S Argon Symbol", "language" -> "en", "paclet" -> "NewEoSArgon", 
    "status" -> "None", "summary" -> 
    "tmaxRonc (Kelvin) Temp\[EAcute]rature maximum des data de Ronchi \
relatives \[AGrave] l'argon [Maximum temperature of Ronchi's data for argon]",
     "synonyms" -> {}, "tabletags" -> {}, "title" -> "tmaxRonc", 
    "titlemodifier" -> "", "metadescription" -> "", "windowtitle" -> 
    "tmaxRonc", "type" -> "Symbol", "uri" -> "NewEoSArgon/ref/tmaxRonc"}},
CellContext->"Global`",
FrontEndVersion->"13.3 pour Microsoft Windows (64-bit) (July 24, 2023)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "13.3 pour Microsoft Windows (64-bit) (July 24, 2023)", 
  StyleDefinitions -> "Default.nb"],
ExpressionUUID->"ee20ad79-a829-4ba3-a794-695e98b37047"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[10857, 291, 1419, 37, 35, "PrimaryExamplesSection",ExpressionUUID->"a981d2d6-d1eb-45e8-a7db-0c5030d1efc0",
   CellTags->"PrimaryExamplesSection",
   CellID->58762634]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 21022, 572}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[580, 21, 5339, 129, 56, "AnchorBarGrid",ExpressionUUID->"e0088ce1-fabc-4551-bdc5-8cc13efd7819",
 CellID->1],
Cell[5922, 152, 94, 0, 23, "ContextNameCell",ExpressionUUID->"a045cdd4-0b2c-489e-9575-989299bde985"],
Cell[CellGroupData[{
Cell[6041, 156, 551, 14, 56, "ObjectNameGrid",ExpressionUUID->"d4fee7be-57e0-4da2-bc8a-b0123595a8bb"],
Cell[6595, 172, 569, 12, 146, "Usage",ExpressionUUID->"a4f93283-52c7-4688-ab82-226a5e0c4171",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[7201, 189, 1919, 48, 37, "NotesSection",ExpressionUUID->"8560dcd4-b883-40fd-a583-0b06fa7b87b6",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->173501745],
Cell[9123, 239, 732, 19, 79, "Notes",ExpressionUUID->"ab9a2219-1d5d-4b52-876e-c528f3066a82",
 CellID->1067943069],
Cell[9858, 260, 185, 4, 36, "Notes",ExpressionUUID->"c099a302-4087-4848-acba-684d27741bac",
 CellID->185021568],
Cell[10046, 266, 684, 19, 79, "Notes",ExpressionUUID->"3ab9c684-920a-4d27-a688-3b928a893405",
 CellID->140761484]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "NotesSection"}, Closed]]]],
Cell[CellGroupData[{
Cell[10857, 291, 1419, 37, 35, "PrimaryExamplesSection",ExpressionUUID->"a981d2d6-d1eb-45e8-a7db-0c5030d1efc0",
 CellTags->"PrimaryExamplesSection",
 CellID->58762634],
Cell[CellGroupData[{
Cell[12301, 332, 1397, 36, 30, "ExampleSection",ExpressionUUID->"eac5d035-8e5a-416b-80e9-405a4f496952",
 CellID->38820072],
Cell[13701, 370, 174, 3, 26, "Input",ExpressionUUID->"f6aa8573-751e-43e3-a3d7-2fa5c1fc1d84",
 CellID->87419684],
Cell[13878, 375, 139, 1, 38, "ExampleText",ExpressionUUID->"250c00b2-0e13-4ff1-bd5e-e6f67516adae",
 CellID->886239600],
Cell[CellGroupData[{
Cell[14042, 380, 202, 4, 26, "Input",ExpressionUUID->"097425a9-8c4a-4ee1-9f0a-fca136454e50",
 CellID->21488140],
Cell[14247, 386, 195, 4, 39, "Output",ExpressionUUID->"264c2781-7daa-465a-a1dd-4d2c500aa7aa",
 CellID->212082245]
}, Open  ]],
Cell[CellGroupData[{
Cell[14479, 395, 652, 17, 26, "Input",ExpressionUUID->"040e2480-6efb-45ed-9261-db8afac03098",
 CellID->509781380],
Cell[15134, 414, 226, 5, 40, "Output",ExpressionUUID->"82722c1c-52a1-4315-a1e7-697114a3a93c",
 CellID->844950976]
}, Open  ]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"}, Closed]]]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "PrimaryExamplesSection"}, Closed]]]],
Cell[15602, 428, 1864, 50, 114, "SeeAlsoSection",ExpressionUUID->"ddaf1061-04d8-4499-89ad-0c67c2443e78"],
Cell[17469, 480, 729, 19, 114, "MoreAboutSection",ExpressionUUID->"a747158d-342a-45b7-add0-fd79553403a6"],
Cell[18201, 501, 825, 24, 101, "RelatedLinksSection",ExpressionUUID->"659f6b16-5edb-4fa9-be2d-6ad63fb0bdf9"],
Cell[19029, 527, 78, 0, 70, "FooterCell",ExpressionUUID->"5a91d6a2-191a-4f2a-9e4f-3ccf6cbf5ab2"]
}
]
*)

(* End of internal cache information *)

