(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 13.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     28731,        750]
NotebookOptionsPosition[     23123,        635]
NotebookOutlinePosition[     25300,        690]
CellTagsIndexPosition[     25215,        685]
WindowTitle->vc
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[GridBox[{
   {GridBox[{
      {
       ItemBox[Cell[BoxData[
         RowBox[{
          TemplateBox[{12},
           "Spacer1"], Cell["NEW EO S ARGON PACKAGE SYMBOL", "PacletNameCell",
           TextAlignment->Center,ExpressionUUID->
           "8c2eb968-0bb6-435f-85ce-109c188cb86d"], 
          TemplateBox[{8},
           "Spacer1"]}]],
         TextAlignment->Center,ExpressionUUID->
         "18bf68dc-468c-4b54-855f-e20ef01cd5e6"],
        Background->RGBColor[0.490196, 0.576471, 0.690196],
        ItemSize->Full], ""}
     },
     GridBoxAlignment->{"Rows" -> {{Center}}},
     GridBoxItemSize->{"Columns" -> {Full, 
         Scaled[0.02]}, "Rows" -> {{2.5}}}], Cell[TextData[{
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "See Also",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "0db80a7a-1da2-4623-8417-4e0986bd2bbe"]
         }],ExpressionUUID->"0ca4dda2-2e42-4ff5-953b-a8ee0be0fa62"],
         StripOnInput->False],{
        "\"rhoc\"" :> Documentation`HelpLookup["paclet:NewEoSArgon/ref/rhoc"],
          "\"tc\"" :> Documentation`HelpLookup["paclet:NewEoSArgon/ref/tc"], 
         "\"pc\"" :> Documentation`HelpLookup["paclet:NewEoSArgon/ref/pc"]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"SeeAlso"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "c329d86f-78dc-448d-bef0-438051740635"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "Related Guides",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "b836f98a-bc67-41f6-b61a-e14df8cb5eea"]
         }],ExpressionUUID->"3daab322-68ba-4afd-9fd2-e6bbefdc6494"],
         StripOnInput->False],{
        "\"NewEoSArgon package\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/guide/NewEoSArgon"]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"MoreAbout"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "1db115c9-5702-4bdf-8ec2-345075579786"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "URL",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "993d855f-4afc-4bf9-af57-fefb954a39df"]
         }],ExpressionUUID->"e53f7831-50b4-4002-98d4-cc91b56cf803"],
         StripOnInput->False],{
        "\"NewEoSArgon/ref/vc\"" :> None, 
         "\"Copy Wolfram Documentation Center URL\"" :> 
         Module[{DocumentationSearch`Private`nb$}, 
           DocumentationSearch`Private`nb$ = 
            NotebookPut[
             Notebook[{Cell["NewEoSArgon/ref/vc"]}, Visible -> False]]; 
           SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
           FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
           NotebookClose[DocumentationSearch`Private`nb$]; Null], Delimiter, 
         "\"Copy web URL\"" :> 
         Module[{DocumentationSearch`Private`nb$}, 
           DocumentationSearch`Private`nb$ = 
            NotebookPut[
             Notebook[{
               Cell[BoxData[
                 MakeBoxes[
                  Hyperlink[
                   "http://reference.wolfram.com/language/NewEoSArgon/ref/vc.\
html"], StandardForm]], "Input", TextClipboardType -> "PlainText"]}, Visible -> 
               False]]; 
           SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
           FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
           NotebookClose[DocumentationSearch`Private`nb$]; Null], 
         "\"Go to web URL\"" :> 
         FrontEndExecute[{
           NotebookLocate[{
             URL[If[TrueQ[DocumentationBuild`Make`Private`wsmlinkQ$34021], 
                 "http://reference.wolfram.com/system-modeler/", 
                 "http://reference.wolfram.com/language/"] <> 
               "NewEoSArgon/ref/vc" <> ".html"], None}]}]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"URLMenu"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "4b744602-5658-41be-a9eb-8db4bed8c2ae"]
    }], "AnchorBar",
     CacheGraphics->False,ExpressionUUID->
     "3bf7c984-da9d-4009-8b54-dfae6b38f867"]}
  }]], "AnchorBarGrid",
 CellID->1,ExpressionUUID->"cccc18cf-5f77-4cc6-8011-f5b92a5635a2"],

Cell["NewEoSArgon`", "ContextNameCell",ExpressionUUID->"ad7f68c0-2b33-4ceb-9540-2d899fe78c00"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     Cell[
     "vc", "ObjectName",ExpressionUUID->
      "f270475f-9cde-4f8c-8d86-640b45d69b34"],
     Cell[BoxData[
      TemplateBox[{8},
       "Spacer1"]],ExpressionUUID->"543b38ae-7019-4e7b-bdd5-f65c773110b6"],
     Cell[BoxData[
     ""], "ObjectNameTranslation",ExpressionUUID->
      "08b346f6-e994-4f2e-91ca-e99316c41e1a"]
    }],ExpressionUUID->"101d91f5-ce60-4636-be70-981451009375"], 
    "\[SpanFromLeft]"}
  }]], "ObjectNameGrid",ExpressionUUID->"f90fca45-f243-46bb-ad04-\
783695cad7e9"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["vc"], "InlineFormula",
      ShowStringCharacters->False,
      FontFamily->"Source Sans Pro",ExpressionUUID->
      "92aec46e-bbd5-43e2-aaf3-92469f537bcd"],
     " (",
     Cell[BoxData[
      SuperscriptBox["cm", "3"]], "InlineFormula",
      FontFamily->"Source Sans Pro",ExpressionUUID->
      "576af455-ee8e-4c31-873c-4ef50ec6de80"],
     "/mole)\nVolume molaire du point critique de l'argon donn\[EAcute]e par \
NIST \n[Critical point molar volume of argon from NIST]"
    }],ExpressionUUID->"6a5f8425-475b-45cb-bbf5-c1fb5333d4b7"]}
  }]], "Usage",
 Deletable->True,ExpressionUUID->"e6a27b36-5cd8-4896-8fe8-3ddb5051819f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[Cell[TextData[{
   Cell[BoxData[
    DynamicBox[ToBoxes[
      If[
       MatchQ[
        CurrentValue[
         EvaluationNotebook[], {TaggingRules, "Openers", "NotesSection"}, 
         Closed], 
        Alternatives[Open, True]], 
       Style[
        Graphics[{
          Thickness[0.18], 
          RGBColor[0.8509803921568627, 0.396078431372549, 0], 
          Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
         PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
        0.68 Inherited], 
       Rotate[
        Style[
         Graphics[{
           Thickness[0.18], 
           RGBColor[0.8509803921568627, 0.396078431372549, 0], 
           Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
          PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
         0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
     ImageSizeCache->{
      13.600000000000001`, {0.5800000000000001, 13.020000000000001`}}]],
    ExpressionUUID->"4d518055-7d3b-4aa6-9ade-f69860550d62"],
   Cell[BoxData[
    TemplateBox[{1},
     "Spacer1"]],ExpressionUUID->"e5fb3163-922e-4719-831a-137cbc7f5862"],
   "Details and Options"
  }], "NotesFrameText",ExpressionUUID->"81b1beb5-62f8-4063-afb5-0fb0fc7201ff"],
  Appearance->{Automatic, None, "Normal", Automatic},
  BaseStyle->None,
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"], 
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], After, CellContents]}]& ),
  Evaluator->None,
  Method->
   "Preemptive"]],ExpressionUUID->"e7d05533-41d6-41e6-8578-88f3b9284834"]], \
"NotesSection",
 WholeCellGroupOpener->True,
 CellGroupingRules->{"SectionGrouping", 50},
 CacheGraphics->False,
 CellID->310297506,ExpressionUUID->"2e06ea1b-adbc-4aaf-a591-1b66c8d49ffc"],

Cell[TextData[{
 "Le volume molaire de l'argon au point critique peut encore se \
d\[EAcute]duire de la densit\[EAcute] au point critique telle que vc = ",
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["M"]], "paclet:NewEoSArgon/ref/M", "NewEoSArgon Package Symbol"},
   "PackageLink",
   BaseStyle->"InlineFormula"]], "InlineFormula",
  FontFamily->"Source Sans Pro",ExpressionUUID->
  "5e3324ed-c121-4bfb-97c5-6b2670d195eb"],
 " / \[Rho]c."
}], "Notes",
 CellID->1067943069,ExpressionUUID->"9f9c364e-3a70-4cf7-bc91-58ac7750e4e3"],

Cell["\<\
******************************************************************************\
*****\
\>", "Notes",
 CellID->185021568,ExpressionUUID->"6530270e-1ff9-4dc4-9e97-0f64ae84ffaf"],

Cell[TextData[{
 "The molar volume of argon at the critical point can still be deduced from \
the critical point density as follows vc = ",
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["M"]], "paclet:NewEoSArgon/ref/M", "NewEoSArgon Package Symbol"},
   "PackageLink",
   BaseStyle->"InlineFormula"]], "InlineFormula",
  FontFamily->"Source Sans Pro",ExpressionUUID->
  "26bf5ed4-42ef-46cc-9f49-9dee53e33fab"],
 " / \[Rho]c."
}], "Notes",
 CellID->21318053,ExpressionUUID->"0cbb5c64-f0f8-4990-8bf8-353641bfca04"]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "NotesSection"}, Closed]]]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {
       TaggingRules, "Openers", "PrimaryExamplesSection"}, Open], 
      Alternatives[True, Open]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{13.600000000000001`, {5., 8.600000000000001}}]],
  ExpressionUUID->"a912f03a-4d2c-4a44-b38b-0cf65f54e6fa"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"4a3dc68b-2075-4140-9cd8-d135c502ed97"],
 "Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "b2986756-e336-4c22-b186-7b0e51a78c25"]
}], "PrimaryExamplesSection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellTags->"PrimaryExamplesSection",
 CellID->212508920,ExpressionUUID->"6ba74473-48ba-4783-8c5d-4fbc91c6b09e"],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"},
        Closed], 
      Alternatives[Open, True]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{13.600000000000001`, {5., 8.600000000000001}}]],
  ExpressionUUID->"df902165-4df3-4128-a7c8-5aa606afe5a3"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"fd5bbfdb-ca6e-474c-b085-0614a2f7ca75"],
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "04f76383-f5ca-4d36-898e-b187e34b571b"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellID->542135346,ExpressionUUID->"8f839920-63ea-4929-a7ba-cab336eabe36"],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<NewEoSArgon`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->87419684,ExpressionUUID->"a85fdbdf-2e65-44f6-8301-b3e5f115e2b4"],

Cell["Give a physical dimension to the constant", "ExampleText",
 CellID->886239600,ExpressionUUID->"9f85f1ce-8f30-47f6-a8d9-a9326d5d1416"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Quantity", "[", 
  RowBox[{"vc", ",", "\"\<cm^3/mol\>\""}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->21488140,ExpressionUUID->"d1e2f4b7-759b-487d-b31f-36cb4bfa3c0d"],

Cell[BoxData[
 TemplateBox[{"74.5857`", 
   RowBox[{
     SuperscriptBox["\"cm\"", "3"], "\[NegativeMediumSpace]", "\"/\"", 
     "\[InvisibleSpace]", "\"mol\""}], "centimeters cubed per mole", 
   FractionBox[
    SuperscriptBox["\"Centimeters\"", "3"], "\"Moles\""]},
  "Quantity"]], "Output",
 CellLabel->"Out[2]=",
 CellID->691578526,ExpressionUUID->"f6d7cfee-da8f-4438-af1c-9dfb6fc11868"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UnitConvert", "[", 
  RowBox[{
   TemplateBox[{"74.5857`"},
    "QuantityUnit",
    DisplayFunction->(TooltipBox[
      StyleBox[
       RowBox[{#, "\[InvisibleSpace]", 
         StyleBox[
          RowBox[{" ", 
            RowBox[{
              SuperscriptBox["\"cm\"", "3"], "\[NegativeMediumSpace]", 
              "\"/\"", "\[InvisibleSpace]", "\"mol\""}]}], 
          "QuantityUnitTraditionalLabel"]}], ShowStringCharacters -> False], 
      "Unit: centimeters cubed per mole"]& ),
    InterpretationFunction->(RowBox[{"Quantity", "[", 
       RowBox[{#, ",", 
         FractionBox[
          SuperscriptBox["\"Centimeters\"", "3"], "\"Moles\""]}], "]"}]& )], 
   ",", "\"\<m^3/mol\>\""}], "]"}]], "Input",
 NumberMarks->False,
 CellLabel->"In[3]:=",
 CellID->298264493,ExpressionUUID->"9e5b10fd-9417-4f50-8d60-2e456c116799"],

Cell[BoxData[
 TemplateBox[{"0.0000745857`", 
   RowBox[{
     SuperscriptBox["\"m\"", "3"], "\[NegativeMediumSpace]", "\"/\"", 
     "\[InvisibleSpace]", "\"mol\""}], "meters cubed per mole", 
   FractionBox[
    SuperscriptBox["\"Meters\"", "3"], "\"Moles\""]},
  "Quantity"]], "Output",
 CellLabel->"Out[3]=",
 CellID->714777892,ExpressionUUID->"207dadc4-10d6-493b-bbf0-d4d6257100ba"]
}, Open  ]],

Cell["Other way to define the triple point density", "ExampleText",
 CellID->278961620,ExpressionUUID->"c62843d6-5d01-4a25-aae4-1f3ee1d06859"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Quantity", "[", 
   RowBox[{"M", ",", "\"\<g/mol\>\""}], "]"}], "/", 
  RowBox[{"Quantity", "[", 
   RowBox[{"\[Rho]c", ",", "\"\<g/cm^3\>\""}], "]"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->295872759,ExpressionUUID->"0712c559-7c0f-44bc-b6a1-6a97c35678cc"],

Cell[BoxData[
 TemplateBox[{"74.58565083205906`", 
   RowBox[{
     SuperscriptBox["\"cm\"", "3"], "\[NegativeMediumSpace]", "\"/\"", 
     "\[InvisibleSpace]", "\"mol\""}], "centimeters cubed per mole", 
   FractionBox[
    SuperscriptBox["\"Centimeters\"", "3"], "\"Moles\""]},
  "Quantity"]], "Output",
 CellLabel->"Out[4]=",
 CellID->260226914,ExpressionUUID->"575f6b25-9eeb-473d-ab1d-777a6796a95e"]
}, Open  ]],

Cell["Using ThermodynamicData package (i.e. REFPROP from NIST)", "ExampleText",
 CellID->361149294,ExpressionUUID->"c5ca677f-6780-4b67-9009-3dd53460d2d1"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UnitConvert", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{"ThermodynamicData", "[", 
     RowBox[{"\"\<Argon\>\"", ",", "\"\<MolarDensity\>\"", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"\"\<Pressure\>\"", "\[Rule]", 
         RowBox[{"Quantity", "[", 
          RowBox[{"pc", ",", "\"\<Bars\>\""}], "]"}]}], ",", 
        RowBox[{"\"\<Temperature\>\"", "\[Rule]", 
         RowBox[{"Quantity", "[", 
          RowBox[{"tc", ",", "\"\<Kelvins\>\""}], "]"}]}]}], "}"}]}], "]"}]}],
    ",", 
   FractionBox[
    SuperscriptBox["\"\<Centimeters\>\"", "3"], "\"\<Moles\>\""]}], 
  "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->770911047,ExpressionUUID->"91837f6b-3c3d-445b-ba7f-19e5b9e559cf"],

Cell[BoxData[
 TemplateBox[{"75.40948679639779`", 
   RowBox[{
     SuperscriptBox["\"cm\"", "3"], "\[NegativeMediumSpace]", "\"/\"", 
     "\[InvisibleSpace]", "\"mol\""}], "centimeters cubed per mole", 
   FractionBox[
    SuperscriptBox["\"Centimeters\"", "3"], "\"Moles\""]},
  "Quantity"]], "Output",
 CellLabel->"Out[5]=",
 CellID->329430237,ExpressionUUID->"da5d3876-d31b-4f1c-a236-2fa4b8865f74"]
}, Open  ]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"}, 
  Closed]]]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "PrimaryExamplesSection"}, 
  Closed]]]],

Cell[BoxData[GridBox[{
   {
    DynamicBox[FEPrivate`ImportImage[
      FrontEnd`FileName[{"Documentation", "FooterIcons"}, 
       "RelatedFunction.png"]],
     ImageSizeCache->{50., {27., 33.}}], GridBox[{
      {
       StyleBox[
        RowBox[{"See", " ", "Also"}], "SeeAlsoSection"]},
      {Cell[TextData[{
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["rhoc"]], "paclet:NewEoSArgon/ref/rhoc", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "ad1fbce6-9b0f-4d37-9039-1ed6bafe7c5b"],
        "\[NonBreakingSpace]",
        StyleBox[
        "\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
         "InlineSeparator"],
        " ",
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["tc"]], "paclet:NewEoSArgon/ref/tc", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "7daed9eb-5df4-4257-b312-854dca85dae3"],
        "\[NonBreakingSpace]",
        StyleBox[
        "\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
         "InlineSeparator"],
        " ",
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["pc"]], "paclet:NewEoSArgon/ref/pc", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "3d1019ba-5afb-46db-92f2-4ec45e62e92d"]
       }], "SeeAlso",ExpressionUUID->"757e48a0-d0c0-484e-aabb-8a14e6a3ba2f"]}
     }]}
  }]], "SeeAlsoSection",ExpressionUUID->"537d40be-64ca-401f-8a03-\
717ede2fdb2d"],

Cell[BoxData[GridBox[{
   {
    DynamicBox[FEPrivate`ImportImage[
      FrontEnd`FileName[{"Documentation", "FooterIcons"}, "RelatedGuide.png"]],
     ImageSizeCache->{50., {27., 33.}}], GridBox[{
      {
       StyleBox[
        RowBox[{"Related", " ", "Guides"}], "MoreAboutSection"]},
      {
       RowBox[{"\[FilledVerySmallSquare]", Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["NewEoSArgon package"]], 
           "paclet:NewEoSArgon/guide/NewEoSArgon"},
          "RefLinkPlain",
          BaseStyle->{"MoreAbout"}]], "MoreAbout",ExpressionUUID->
         "32b8570d-42de-4919-b5dc-869af097359c"]}]}
     }]}
  }]], "MoreAboutSection",ExpressionUUID->"c04c5a44-c2ef-482d-812d-\
f0df45ef65cd"],

Cell[BoxData[GridBox[{
   {
    TemplateBox[{29},
     "Spacer1"], GridBox[{
      {
       RowBox[{
        TemplateBox[{17},
         "Spacer1"], 
        StyleBox[
         RowBox[{"Related", " ", "Links"}], "RelatedLinksSection"]}]},
      {Cell[BoxData[Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData[
             RowBox[{
               RowBox[{"Units", " ", "&"}], " ", "Quantities"}]]], 
           "paclet:guide/Units"},
          "RefLinkPlain",
          BaseStyle->{"RelatedLinks"}]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "d0cef6ae-a54d-49cb-aad1-bcbbe43c331d"]], "RelatedLinks",
        ExpressionUUID->"04fb03c1-3678-49ae-976d-e8246ad2973b"]},
      {Cell[BoxData[Cell[BoxData[Cell[BoxData[
          RowBox[{
           TemplateBox[{16},
            "Spacer1"], "\[FilledVerySmallSquare]", 
           TemplateBox[{
             Cell[
              TextData[
               Cell[
                TextData[{
                  Cell[
                   BoxData[
                    TemplateBox[{2}, "Spacer1"]]], "ThermodynamicData"}]]]], 
             "paclet:ref/ThermodynamicData"},
            "RefLink",
            BaseStyle->{"RelatedLinks"}]}]],ExpressionUUID->
          "14646cf6-1151-49eb-8bb2-04f8c447f3cc"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "2ea0af9c-34c3-4aed-a865-cec0b3ed0c7e"]], "RelatedLinks",
        ExpressionUUID->"86edc208-fd63-485e-8317-f65c0dd1f450"]},
      {Cell[TextData[Cell[BoxData[
        RowBox[{
         TemplateBox[{16},
          "Spacer1"], "\[FilledVerySmallSquare]", Cell[BoxData[
          TemplateBox[{
            Cell[
             TextData[
              Cell[
               TextData[{
                 Cell[
                  BoxData[
                   TemplateBox[{2}, "Spacer1"]]], 
                 "Webbook de chimie NIST"}]]]], 
            "http://webbook.nist.gov/chemistry/fluid/"},
           "WebLink",
           BaseStyle->{"RelatedLinks"}]],ExpressionUUID->
          "07ca496b-9d16-4ed8-aeb9-97f0ed2c5aee"]}]],ExpressionUUID->
        "4258159e-da75-4340-8588-7c125a012d32"]], "RelatedLinks",
        ExpressionUUID->"37a4396a-26f1-4c88-ab33-163712ed097b"]}
     }]}
  }]], "RelatedLinksSection",ExpressionUUID->"f0503841-2ce7-4896-86ca-\
fe216bf09656"],

Cell[" ", "FooterCell",ExpressionUUID->"e8721e60-3266-4e36-84dc-2da093c14ebd"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{900, 835.8},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"vc",
TaggingRules->{
 "ModificationHighlight" -> False, "ColorType" -> "", "LinkTrails" -> "", 
  "HasOptions" -> True, "ExampleCounter" -> 1, 
  "Openers" -> {
   "PrimaryExamplesSection" -> Open, "ExampleSection" -> {"0" -> Open}, 
    "NotesSection" -> Closed}, "NewStyles" -> True, 
  "CitationPopupData" -> $Failed, "ShowCitation" -> False, "RootCaptions" -> 
  "", "Metadata" -> {
   "built" -> "{2023, 11, 30, 13, 56, 17.3645526}", 
    "history" -> {"XX", "", "", ""}, "context" -> "NewEoSArgon`", 
    "keywords" -> {}, "specialkeywords" -> {}, 
    "tutorialcollectionlinks" -> {}, "index" -> True, "label" -> 
    "New Eo S Argon Package Symbol", "language" -> "en", "paclet" -> 
    "NewEoSArgon Package", "status" -> "None", "summary" -> 
    "vc (cm^3/mole) Volume molaire du point critique de l'argon \
donn\[EAcute]e par NIST [Critical point molar volume of argon from NIST]", 
    "synonyms" -> {}, "tabletags" -> {}, "title" -> "vc", "titlemodifier" -> 
    "", "metadescription" -> "", "windowtitle" -> "vc", "type" -> "Symbol", 
    "uri" -> "NewEoSArgon/ref/vc"}},
CellContext->"Global`",
FrontEndVersion->"13.3 pour Microsoft Windows (64-bit) (July 24, 2023)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "13.3 pour Microsoft Windows (64-bit) (July 24, 2023)", 
  StyleDefinitions -> "Default.nb"],
ExpressionUUID->"11b06216-af52-434b-bee8-39b291a18321"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[10575, 281, 1420, 37, 35, "PrimaryExamplesSection",ExpressionUUID->"6ba74473-48ba-4783-8c5d-4fbc91c6b09e",
   CellTags->"PrimaryExamplesSection",
   CellID->212508920]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 25015, 678}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[574, 21, 5299, 128, 56, "AnchorBarGrid",ExpressionUUID->"cccc18cf-5f77-4cc6-8011-f5b92a5635a2",
 CellID->1],
Cell[5876, 151, 94, 0, 23, "ContextNameCell",ExpressionUUID->"ad7f68c0-2b33-4ceb-9540-2d899fe78c00"],
Cell[CellGroupData[{
Cell[5995, 155, 545, 14, 56, "ObjectNameGrid",ExpressionUUID->"f90fca45-f243-46bb-ad04-783695cad7e9"],
Cell[6543, 171, 693, 15, 146, "Usage",ExpressionUUID->"e6a27b36-5cd8-4896-8fe8-3ddb5051819f"]
}, Open  ]],
Cell[CellGroupData[{
Cell[7273, 191, 1919, 48, 37, "NotesSection",ExpressionUUID->"2e06ea1b-adbc-4aaf-a591-1b66c8d49ffc",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->310297506],
Cell[9195, 241, 540, 13, 38, "Notes",ExpressionUUID->"9f9c364e-3a70-4cf7-bc91-58ac7750e4e3",
 CellID->1067943069],
Cell[9738, 256, 185, 4, 36, "Notes",ExpressionUUID->"6530270e-1ff9-4dc4-9e97-0f64ae84ffaf",
 CellID->185021568],
Cell[9926, 262, 522, 13, 38, "Notes",ExpressionUUID->"0cbb5c64-f0f8-4990-8bf8-353641bfca04",
 CellID->21318053]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "NotesSection"}, Closed]]]],
Cell[CellGroupData[{
Cell[10575, 281, 1420, 37, 35, "PrimaryExamplesSection",ExpressionUUID->"6ba74473-48ba-4783-8c5d-4fbc91c6b09e",
 CellTags->"PrimaryExamplesSection",
 CellID->212508920],
Cell[CellGroupData[{
Cell[12020, 322, 1398, 36, 30, "ExampleSection",ExpressionUUID->"8f839920-63ea-4929-a7ba-cab336eabe36",
 CellID->542135346],
Cell[13421, 360, 174, 3, 26, "Input",ExpressionUUID->"a85fdbdf-2e65-44f6-8301-b3e5f115e2b4",
 CellID->87419684],
Cell[13598, 365, 139, 1, 38, "ExampleText",ExpressionUUID->"9f85f1ce-8f30-47f6-a8d9-a9326d5d1416",
 CellID->886239600],
Cell[CellGroupData[{
Cell[13762, 370, 197, 4, 26, "Input",ExpressionUUID->"d1e2f4b7-759b-487d-b31f-36cb4bfa3c0d",
 CellID->21488140],
Cell[13962, 376, 393, 9, 43, "Output",ExpressionUUID->"f6d7cfee-da8f-4438-af1c-9dfb6fc11868",
 CellID->691578526]
}, Open  ]],
Cell[CellGroupData[{
Cell[14392, 390, 857, 22, 30, "Input",ExpressionUUID->"9e5b10fd-9417-4f50-8d60-2e456c116799",
 CellID->298264493],
Cell[15252, 414, 387, 9, 43, "Output",ExpressionUUID->"207dadc4-10d6-493b-bbf0-d4d6257100ba",
 CellID->714777892]
}, Open  ]],
Cell[15654, 426, 142, 1, 38, "ExampleText",ExpressionUUID->"c62843d6-5d01-4a25-aae4-1f3ee1d06859",
 CellID->278961620],
Cell[CellGroupData[{
Cell[15821, 431, 296, 7, 26, "Input",ExpressionUUID->"0712c559-7c0f-44bc-b6a1-6a97c35678cc",
 CellID->295872759],
Cell[16120, 440, 403, 9, 43, "Output",ExpressionUUID->"575f6b25-9eeb-473d-ab1d-777a6796a95e",
 CellID->260226914]
}, Open  ]],
Cell[16538, 452, 154, 1, 38, "ExampleText",ExpressionUUID->"c5ca677f-6780-4b67-9009-3dd53460d2d1",
 CellID->361149294],
Cell[CellGroupData[{
Cell[16717, 457, 738, 19, 67, "Input",ExpressionUUID->"91837f6b-3c3d-445b-ba7f-19e5b9e559cf",
 CellID->770911047],
Cell[17458, 478, 403, 9, 43, "Output",ExpressionUUID->"da5d3876-d31b-4f1c-a236-2fa4b8865f74",
 CellID->329430237]
}, Open  ]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"}, Closed]]]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "PrimaryExamplesSection"}, Closed]]]],
Cell[18103, 496, 1850, 50, 114, "SeeAlsoSection",ExpressionUUID->"537d40be-64ca-401f-8a03-717ede2fdb2d"],
Cell[19956, 548, 729, 19, 70, "MoreAboutSection",ExpressionUUID->"c04c5a44-c2ef-482d-812d-f0df45ef65cd"],
Cell[20688, 569, 2350, 62, 70, "RelatedLinksSection",ExpressionUUID->"f0503841-2ce7-4896-86ca-fe216bf09656"],
Cell[23041, 633, 78, 0, 70, "FooterCell",ExpressionUUID->"e8721e60-3266-4e36-84dc-2da093c14ebd"]
}
]
*)

(* End of internal cache information *)

