(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 13.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     29945,        784]
NotebookOptionsPosition[     24307,        669]
NotebookOutlinePosition[     26511,        724]
CellTagsIndexPosition[     26426,        719]
WindowTitle->vtrgaz
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[GridBox[{
   {GridBox[{
      {
       ItemBox[Cell[BoxData[
         RowBox[{
          TemplateBox[{12},
           "Spacer1"], Cell["NEW EO S ARGON PACKAGE SYMBOL", "PacletNameCell",
           TextAlignment->Center,ExpressionUUID->
           "06baf73b-6a77-4489-95e0-93532f429f25"], 
          TemplateBox[{8},
           "Spacer1"]}]],
         TextAlignment->Center,ExpressionUUID->
         "1a24e103-65cf-41a4-92b7-3c2ff91ea3a9"],
        Background->RGBColor[0.490196, 0.576471, 0.690196],
        ItemSize->Full], ""}
     },
     GridBoxAlignment->{"Rows" -> {{Center}}},
     GridBoxItemSize->{"Columns" -> {Full, 
         Scaled[0.02]}, "Rows" -> {{2.5}}}], Cell[TextData[{
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "See Also",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "90f26099-0ace-44b7-a211-afa4b41bdf93"]
         }],ExpressionUUID->"cd9c6a8d-e706-4d89-8560-9130c0eeae65"],
         StripOnInput->False],{
        "\"rhotrgaz\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/rhotrgaz"], 
         "\"ttr\"" :> Documentation`HelpLookup["paclet:NewEoSArgon/ref/ttr"], 
         "\"ptr\"" :> Documentation`HelpLookup["paclet:NewEoSArgon/ref/ptr"], 
         "\"rhotrliq\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/rhotrliq"], 
         "\"vtrliq\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/vtrliq"]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"SeeAlso"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "7d0f2cdd-4301-46dd-929c-0b548f0339e8"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "Related Guides",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "105cffe5-25fe-4822-94df-5b6c7358805e"]
         }],ExpressionUUID->"011d87ae-0c0c-4fb2-b7ab-a5bece707d30"],
         StripOnInput->False],{
        "\"NewEoSArgon package\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/guide/NewEoSArgon"]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"MoreAbout"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "4e924e9e-4a5c-4f4f-b5f8-c45037a79e93"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "URL",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "7c86df04-2c8e-4c4d-b91a-f39bdc5e6a23"]
         }],ExpressionUUID->"d65678bb-6b93-40a4-bdfe-5368345d2ff0"],
         StripOnInput->False],{
        "\"NewEoSArgon/ref/vtrgaz\"" :> None, 
         "\"Copy Wolfram Documentation Center URL\"" :> 
         Module[{DocumentationSearch`Private`nb$}, 
           DocumentationSearch`Private`nb$ = 
            NotebookPut[
             Notebook[{Cell["NewEoSArgon/ref/vtrgaz"]}, Visible -> False]]; 
           SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
           FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
           NotebookClose[DocumentationSearch`Private`nb$]; Null], Delimiter, 
         "\"Copy web URL\"" :> 
         Module[{DocumentationSearch`Private`nb$}, 
           DocumentationSearch`Private`nb$ = 
            NotebookPut[
             Notebook[{
               Cell[BoxData[
                 MakeBoxes[
                  Hyperlink[
                   "http://reference.wolfram.com/language/NewEoSArgon/ref/\
vtrgaz.html"], StandardForm]], "Input", TextClipboardType -> "PlainText"]}, 
               Visible -> False]]; 
           SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
           FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
           NotebookClose[DocumentationSearch`Private`nb$]; Null], 
         "\"Go to web URL\"" :> 
         FrontEndExecute[{
           NotebookLocate[{
             URL[If[TrueQ[DocumentationBuild`Make`Private`wsmlinkQ$34526], 
                 "http://reference.wolfram.com/system-modeler/", 
                 "http://reference.wolfram.com/language/"] <> 
               "NewEoSArgon/ref/vtrgaz" <> ".html"], None}]}]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"URLMenu"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "072e35b2-2edb-4d1d-9b90-7d4fae71b8a4"]
    }], "AnchorBar",
     CacheGraphics->False,ExpressionUUID->
     "af91d4f5-b605-4746-acae-3e5bb36d9858"]}
  }]], "AnchorBarGrid",
 CellID->1,ExpressionUUID->"85f22b7f-fd60-4517-af8f-aca348b051d4"],

Cell["NewEoSArgon`", "ContextNameCell",ExpressionUUID->"7519359d-5018-4fe5-a2d8-4ec7e1b542e4"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     Cell[
     "vtrgaz", "ObjectName",ExpressionUUID->
      "0326c5ca-c655-481e-917e-bb26f63b746d"],
     Cell[BoxData[
      TemplateBox[{8},
       "Spacer1"]],ExpressionUUID->"7a48307e-9042-480e-acd7-c6b34a378dd3"],
     Cell[BoxData[
     ""], "ObjectNameTranslation",ExpressionUUID->
      "0f9b1e20-fa4f-4f5f-9ec0-6b35b15026a5"]
    }],ExpressionUUID->"c12a5a32-2025-4aab-8dd9-ba7107bf9fa6"], 
    "\[SpanFromLeft]"}
  }]], "ObjectNameGrid",ExpressionUUID->"cbda561e-5915-451a-bb6f-\
112056b43460"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["vtrgaz"], "InlineFormula",
      ShowStringCharacters->False,
      FontFamily->"Source Sans Pro",ExpressionUUID->
      "851d44c8-59d5-4ad6-ba77-ec3c96b0669b"],
     " (",
     Cell[BoxData[
      SuperscriptBox["cm", "3"]], "InlineFormula",
      FontFamily->"Source Sans Pro",ExpressionUUID->
      "7441596b-93f5-4ac5-a54a-fc445ab3e973"],
     "/mole)\nVolume molaire du ",
     StyleBox["gaz",
      FontSlant->"Italic"],
     " au point triple de l'argon donn\[EAcute]e par NIST \n[",
     StyleBox["Gas",
      FontSlant->"Italic"],
     " triple point molar volume of argon from NIST]"
    }],ExpressionUUID->"52335c49-8ba6-464c-9875-d17b51b59eea"]}
  }]], "Usage",
 Deletable->True,ExpressionUUID->"99bf1a16-1478-43f8-978b-8abe668a6398"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[Cell[TextData[{
   Cell[BoxData[
    DynamicBox[ToBoxes[
      If[
       MatchQ[
        CurrentValue[
         EvaluationNotebook[], {TaggingRules, "Openers", "NotesSection"}, 
         Closed], 
        Alternatives[Open, True]], 
       Style[
        Graphics[{
          Thickness[0.18], 
          RGBColor[0.8509803921568627, 0.396078431372549, 0], 
          Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
         PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
        0.68 Inherited], 
       Rotate[
        Style[
         Graphics[{
           Thickness[0.18], 
           RGBColor[0.8509803921568627, 0.396078431372549, 0], 
           Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
          PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
         0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
     ImageSizeCache->{
      13.600000000000001`, {0.5800000000000001, 13.020000000000001`}}]],
    ExpressionUUID->"2454d9fb-048d-45f8-b928-07d10e015806"],
   Cell[BoxData[
    TemplateBox[{1},
     "Spacer1"]],ExpressionUUID->"b06bc97b-8d06-4fd7-a7d0-4882fb83ff6c"],
   "Details and Options"
  }], "NotesFrameText",ExpressionUUID->"da4b1e84-b300-4bdf-bf70-5f12625f4d3f"],
  Appearance->{Automatic, None, "Normal", Automatic},
  BaseStyle->None,
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"], 
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], After, CellContents]}]& ),
  Evaluator->None,
  Method->
   "Preemptive"]],ExpressionUUID->"0c8e3fcc-e636-4719-a261-02ce51a1c0ef"]], \
"NotesSection",
 WholeCellGroupOpener->True,
 CellGroupingRules->{"SectionGrouping", 50},
 CacheGraphics->False,
 CellID->311459477,ExpressionUUID->"e34719f9-1dc3-495a-94e2-87c6f3feef3e"],

Cell[TextData[{
 "Le volume molaire du gaz au point triple peut encore se d\[EAcute]duire de \
la densit\[EAcute] au point triple telle que vtrgaz = ",
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["M"]], "paclet:NewEoSArgon/ref/M", "NewEoSArgon Package Symbol"},
   "PackageLink",
   BaseStyle->"InlineFormula"]], "InlineFormula",
  FontFamily->"Source Sans Pro",ExpressionUUID->
  "dce85b08-81dc-48d4-802f-fdb616e545f0"],
 " / ",
 "\[Rho]trgaz",
 "."
}], "Notes",
 CellID->1067943069,ExpressionUUID->"6d72be24-1300-42a4-a37b-6fb6baedb8ff"],

Cell["\<\
******************************************************************************\
*****\
\>", "Notes",
 CellID->185021568,ExpressionUUID->"d4f9aced-a709-4bc6-8999-fb643ac109f9"],

Cell[TextData[{
 "The molar volume of the gas at the triple point can still be deduced from \
the gas density at the triple point as follows vtrgaz = ",
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["M"]], "paclet:NewEoSArgon/ref/M", "NewEoSArgon Package Symbol"},
   "PackageLink",
   BaseStyle->"InlineFormula"]], "InlineFormula",
  FontFamily->"Source Sans Pro",ExpressionUUID->
  "89d46289-1533-4e7e-8296-82401993e570"],
 " / \[Rho]trgaz."
}], "Notes",
 CellID->186926766,ExpressionUUID->"d1271ea5-0c8c-4fb9-aefe-a0e459d38f1e"]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "NotesSection"}, Closed]]]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {
       TaggingRules, "Openers", "PrimaryExamplesSection"}, Open], 
      Alternatives[True, Open]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{13.600000000000001`, {5., 8.600000000000001}}]],
  ExpressionUUID->"b3d230fc-96a6-45cd-86e1-93b3df9163a2"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"801b18a6-facc-4cf4-9f92-9a87c97e7e57"],
 "Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "60e95c35-3afe-4fd5-b239-8d66748cffeb"]
}], "PrimaryExamplesSection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellTags->"PrimaryExamplesSection",
 CellID->198148547,ExpressionUUID->"7951b187-deb0-47d9-b6d7-ad9ca83d9f63"],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"},
        Closed], 
      Alternatives[Open, True]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{13.600000000000001`, {5., 8.600000000000001}}]],
  ExpressionUUID->"bc1d8c0e-c968-47fc-a6ee-b672021aaf44"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"28879390-80f5-42df-86c9-aeffaa64c270"],
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "02d6d4ed-9253-4029-a7b0-c93d609f7107"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellID->363688247,ExpressionUUID->"095d9145-6a87-4c5d-9797-c1d33df1276d"],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<NewEoSArgon`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->87419684,ExpressionUUID->"98703be4-298c-4fe4-908f-b8ab3e97eb10"],

Cell["Give a physical dimension to the constant", "ExampleText",
 CellID->886239600,ExpressionUUID->"d3844751-d0cf-4102-983d-a0188541621a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Quantity", "[", 
  RowBox[{"vtrgaz", ",", "\"\<cm^3/mol\>\""}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->21488140,ExpressionUUID->"8b789012-0ebd-490e-8a8b-2894eec832f5"],

Cell[BoxData[
 TemplateBox[{"9852.51318`", 
   RowBox[{
     SuperscriptBox["\"cm\"", "3"], "\[NegativeMediumSpace]", "\"/\"", 
     "\[InvisibleSpace]", "\"mol\""}], "centimeters cubed per mole", 
   FractionBox[
    SuperscriptBox["\"Centimeters\"", "3"], "\"Moles\""]},
  "Quantity"]], "Output",
 CellLabel->"Out[2]=",
 CellID->216278621,ExpressionUUID->"5774b6af-175f-41db-8e5c-7b5ef9985c7e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UnitConvert", "[", 
  RowBox[{
   TemplateBox[{"9852.51318`"},
    "QuantityUnit",
    DisplayFunction->(TooltipBox[
      StyleBox[
       RowBox[{#, "\[InvisibleSpace]", 
         StyleBox[
          RowBox[{" ", 
            RowBox[{
              SuperscriptBox["\"cm\"", "3"], "\[NegativeMediumSpace]", 
              "\"/\"", "\[InvisibleSpace]", "\"mol\""}]}], 
          "QuantityUnitTraditionalLabel"]}], ShowStringCharacters -> False], 
      "Unit: centimeters cubed per mole"]& ),
    InterpretationFunction->(RowBox[{"Quantity", "[", 
       RowBox[{#, ",", 
         FractionBox[
          SuperscriptBox["\"Centimeters\"", "3"], "\"Moles\""]}], "]"}]& )], 
   ",", "\"\<m^3/mol\>\""}], "]"}]], "Input",
 NumberMarks->False,
 CellLabel->"In[3]:=",
 CellID->180544031,ExpressionUUID->"ad780cb8-90f2-4d8f-970b-d1c1d1c2fae2"],

Cell[BoxData[
 TemplateBox[{"0.00985251318`", 
   RowBox[{
     SuperscriptBox["\"m\"", "3"], "\[NegativeMediumSpace]", "\"/\"", 
     "\[InvisibleSpace]", "\"mol\""}], "meters cubed per mole", 
   FractionBox[
    SuperscriptBox["\"Meters\"", "3"], "\"Moles\""]},
  "Quantity"]], "Output",
 CellLabel->"Out[3]=",
 CellID->104412570,ExpressionUUID->"58e0f4de-e5df-4583-80ce-0ae1c84675b3"]
}, Open  ]],

Cell["Other way to define the triple point density", "ExampleText",
 CellID->278961620,ExpressionUUID->"a2c6554b-a6e6-4193-8c0b-725d164e916d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Quantity", "[", 
   RowBox[{"M", ",", "\"\<g/mol\>\""}], "]"}], "/", 
  RowBox[{"Quantity", "[", 
   RowBox[{"\[Rho]trgaz", ",", "\"\<g/cm^3\>\""}], "]"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->295872759,ExpressionUUID->"6a80a1ca-d6f5-40b5-8d1b-63b742cf3086"],

Cell[BoxData[
 TemplateBox[{"9852.51318`", 
   RowBox[{
     SuperscriptBox["\"cm\"", "3"], "\[NegativeMediumSpace]", "\"/\"", 
     "\[InvisibleSpace]", "\"mol\""}], "centimeters cubed per mole", 
   FractionBox[
    SuperscriptBox["\"Centimeters\"", "3"], "\"Moles\""]},
  "Quantity"]], "Output",
 CellLabel->"Out[4]=",
 CellID->403718067,ExpressionUUID->"42a3cc92-f195-40e5-99e5-ba52a9916895"]
}, Open  ]],

Cell["Using ThermodynamicData package (i.e. REFPROP from NIST)", "ExampleText",
 CellID->361149294,ExpressionUUID->"86af6c52-dfc3-41b9-ab47-b89180eba303"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UnitConvert", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Quantity", "[", 
     RowBox[{"M", ",", "\"\<g/mol\>\""}], "]"}], "/", 
    RowBox[{"ThermodynamicData", "[", 
     RowBox[{"\"\<Argon\>\"", ",", "\"\<TriplePointGasDensity\>\""}], "]"}]}],
    ",", 
   FractionBox[
    SuperscriptBox["\"\<Centimeters\>\"", "3"], "\"\<Moles\>\""]}], 
  "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->770911047,ExpressionUUID->"abfdffee-603c-4e33-86ee-97081d92c882"],

Cell[BoxData[
 TemplateBox[{"9852.561794316553`", 
   RowBox[{
     SuperscriptBox["\"cm\"", "3"], "\[NegativeMediumSpace]", "\"/\"", 
     "\[InvisibleSpace]", "\"mol\""}], "centimeters cubed per mole", 
   FractionBox[
    SuperscriptBox["\"Centimeters\"", "3"], "\"Moles\""]},
  "Quantity"]], "Output",
 CellLabel->"Out[5]=",
 CellID->332946540,ExpressionUUID->"582746f6-a787-469c-ab91-51e17c653e56"]
}, Open  ]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"}, 
  Closed]]]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "PrimaryExamplesSection"}, 
  Closed]]]],

Cell[BoxData[GridBox[{
   {
    DynamicBox[FEPrivate`ImportImage[
      FrontEnd`FileName[{"Documentation", "FooterIcons"}, 
       "RelatedFunction.png"]],
     ImageSizeCache->{50., {27., 33.}}], GridBox[{
      {
       StyleBox[
        RowBox[{"See", " ", "Also"}], "SeeAlsoSection"]},
      {Cell[TextData[{
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["rhotrgaz"]], "paclet:NewEoSArgon/ref/rhotrgaz", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "36116dff-5d46-46b0-95f8-645e4193b256"],
        "\[NonBreakingSpace]",
        StyleBox[
        "\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
         "InlineSeparator"],
        " ",
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["ttr"]], "paclet:NewEoSArgon/ref/ttr", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "70573d4d-c607-4c41-b6b3-cb9e6e17e233"],
        "\[NonBreakingSpace]",
        StyleBox[
        "\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
         "InlineSeparator"],
        " ",
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["ptr"]], "paclet:NewEoSArgon/ref/ptr", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "36a5ec43-f80f-44d7-baa9-cae4c50d922e"],
        "\[NonBreakingSpace]",
        StyleBox[
        "\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
         "InlineSeparator"],
        " ",
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["rhotrliq"]], "paclet:NewEoSArgon/ref/rhotrliq", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "7ed2c853-968a-4268-bf95-755110f6b3f4"],
        "\[NonBreakingSpace]",
        StyleBox[
        "\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
         "InlineSeparator"],
        " ",
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["vtrliq"]], "paclet:NewEoSArgon/ref/vtrliq", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "df94d4ce-99f3-4ffa-bb59-13532c3c58c6"]
       }], "SeeAlso",ExpressionUUID->"a64cd84b-2339-40c4-8a30-ec568389a637"]}
     }]}
  }]], "SeeAlsoSection",ExpressionUUID->"997d80e9-d0a2-4c93-b3d1-\
946c151c1053"],

Cell[BoxData[GridBox[{
   {
    DynamicBox[FEPrivate`ImportImage[
      FrontEnd`FileName[{"Documentation", "FooterIcons"}, "RelatedGuide.png"]],
     ImageSizeCache->{50., {27., 33.}}], GridBox[{
      {
       StyleBox[
        RowBox[{"Related", " ", "Guides"}], "MoreAboutSection"]},
      {
       RowBox[{"\[FilledVerySmallSquare]", Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["NewEoSArgon package"]], 
           "paclet:NewEoSArgon/guide/NewEoSArgon"},
          "RefLinkPlain",
          BaseStyle->{"MoreAbout"}]], "MoreAbout",ExpressionUUID->
         "6eb548e8-3506-476f-a188-8173a5b14b96"]}]}
     }]}
  }]], "MoreAboutSection",ExpressionUUID->"0af6982e-33ad-4154-b566-\
da4322d9f5b9"],

Cell[BoxData[GridBox[{
   {
    TemplateBox[{29},
     "Spacer1"], GridBox[{
      {
       RowBox[{
        TemplateBox[{17},
         "Spacer1"], 
        StyleBox[
         RowBox[{"Related", " ", "Links"}], "RelatedLinksSection"]}]},
      {Cell[BoxData[Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData[
             RowBox[{
               RowBox[{"Units", " ", "&"}], " ", "Quantities"}]]], 
           "paclet:guide/Units"},
          "RefLinkPlain",
          BaseStyle->{"RelatedLinks"}]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "678391dc-f33b-400b-920b-5a52c79e4926"]], "RelatedLinks",
        ExpressionUUID->"bc4332fc-cc26-4d13-a1f8-98656bd3b025"]},
      {Cell[BoxData[Cell[BoxData[Cell[BoxData[
          RowBox[{
           TemplateBox[{16},
            "Spacer1"], "\[FilledVerySmallSquare]", 
           TemplateBox[{
             Cell[
              TextData[
               Cell[
                TextData[{
                  Cell[
                   BoxData[
                    TemplateBox[{2}, "Spacer1"]]], "ThermodynamicData"}]]]], 
             "paclet:ref/ThermodynamicData"},
            "RefLink",
            BaseStyle->{"RelatedLinks"}]}]],ExpressionUUID->
          "436f02a0-79a3-4359-9621-69ca4110de3b"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "db544d6e-0350-43c1-aff0-6acef79f3dba"]], "RelatedLinks",
        ExpressionUUID->"4ab05a9b-6b24-4873-b27a-18539c424575"]},
      {Cell[TextData[Cell[BoxData[
        RowBox[{
         TemplateBox[{16},
          "Spacer1"], "\[FilledVerySmallSquare]", Cell[BoxData[
          TemplateBox[{
            Cell[
             TextData[
              Cell[
               TextData[{
                 Cell[
                  BoxData[
                   TemplateBox[{2}, "Spacer1"]]], 
                 "Webbook de chimie NIST"}]]]], 
            "http://webbook.nist.gov/chemistry/fluid/"},
           "WebLink",
           BaseStyle->{"RelatedLinks"}]],ExpressionUUID->
          "fcf78d84-9c6b-409c-95f1-fab883246e06"]}]],ExpressionUUID->
        "abb5c739-8430-474d-ba1b-b3e95f3bfd49"]], "RelatedLinks",
        ExpressionUUID->"f0d69585-3f79-4ccf-82df-21574c008bf1"]}
     }]}
  }]], "RelatedLinksSection",ExpressionUUID->"0afcabf6-79e3-458e-8587-\
3acc0acd2cca"],

Cell[" ", "FooterCell",ExpressionUUID->"2453c91f-1bc2-4ddb-9abd-a43a82683976"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{900, 835.8},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"vtrgaz",
TaggingRules->{
 "ModificationHighlight" -> False, "ColorType" -> "", "LinkTrails" -> "", 
  "HasOptions" -> True, "ExampleCounter" -> 1, 
  "Openers" -> {
   "PrimaryExamplesSection" -> Open, "ExampleSection" -> {"0" -> Open}, 
    "NotesSection" -> Closed}, "NewStyles" -> True, 
  "CitationPopupData" -> $Failed, "ShowCitation" -> False, "RootCaptions" -> 
  "", "Metadata" -> {
   "built" -> "{2023, 11, 30, 13, 56, 18.1673892}", 
    "history" -> {"XX", "", "", ""}, "context" -> "NewEoSArgon`", 
    "keywords" -> {}, "specialkeywords" -> {}, 
    "tutorialcollectionlinks" -> {}, "index" -> True, "label" -> 
    "New Eo S Argon Package Symbol", "language" -> "en", "paclet" -> 
    "NewEoSArgon Package", "status" -> "None", "summary" -> 
    "vtrgaz (cm^3/mole) Volume molaire du gaz au point triple de l'argon donn\
\[EAcute]e par NIST [Gas triple point molar volume of argon from NIST]", 
    "synonyms" -> {}, "tabletags" -> {}, "title" -> "vtrgaz", "titlemodifier" -> 
    "", "metadescription" -> "", "windowtitle" -> "vtrgaz", "type" -> 
    "Symbol", "uri" -> "NewEoSArgon/ref/vtrgaz"}},
CellContext->"Global`",
FrontEndVersion->"13.3 pour Microsoft Windows (64-bit) (July 24, 2023)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "13.3 pour Microsoft Windows (64-bit) (July 24, 2023)", 
  StyleDefinitions -> "Default.nb"],
ExpressionUUID->"b9cd8add-3cc2-444c-af26-40adcdb4ad31"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[10962, 293, 1420, 37, 35, "PrimaryExamplesSection",ExpressionUUID->"7951b187-deb0-47d9-b6d7-ad9ca83d9f63",
   CellTags->"PrimaryExamplesSection",
   CellID->198148547]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 26226, 712}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[578, 21, 5531, 133, 56, "AnchorBarGrid",ExpressionUUID->"85f22b7f-fd60-4517-af8f-aca348b051d4",
 CellID->1],
Cell[6112, 156, 94, 0, 23, "ContextNameCell",ExpressionUUID->"7519359d-5018-4fe5-a2d8-4ec7e1b542e4"],
Cell[CellGroupData[{
Cell[6231, 160, 549, 14, 56, "ObjectNameGrid",ExpressionUUID->"cbda561e-5915-451a-bb6f-112056b43460"],
Cell[6783, 176, 812, 20, 146, "Usage",ExpressionUUID->"99bf1a16-1478-43f8-978b-8abe668a6398"]
}, Open  ]],
Cell[CellGroupData[{
Cell[7632, 201, 1919, 48, 37, "NotesSection",ExpressionUUID->"e34719f9-1dc3-495a-94e2-87c6f3feef3e",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->311459477],
Cell[9554, 251, 550, 15, 38, "Notes",ExpressionUUID->"6d72be24-1300-42a4-a37b-6fb6baedb8ff",
 CellID->1067943069],
Cell[10107, 268, 185, 4, 36, "Notes",ExpressionUUID->"d4f9aced-a709-4bc6-8999-fb643ac109f9",
 CellID->185021568],
Cell[10295, 274, 540, 13, 59, "Notes",ExpressionUUID->"d1271ea5-0c8c-4fb9-aefe-a0e459d38f1e",
 CellID->186926766]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "NotesSection"}, Closed]]]],
Cell[CellGroupData[{
Cell[10962, 293, 1420, 37, 35, "PrimaryExamplesSection",ExpressionUUID->"7951b187-deb0-47d9-b6d7-ad9ca83d9f63",
 CellTags->"PrimaryExamplesSection",
 CellID->198148547],
Cell[CellGroupData[{
Cell[12407, 334, 1398, 36, 30, "ExampleSection",ExpressionUUID->"095d9145-6a87-4c5d-9797-c1d33df1276d",
 CellID->363688247],
Cell[13808, 372, 174, 3, 26, "Input",ExpressionUUID->"98703be4-298c-4fe4-908f-b8ab3e97eb10",
 CellID->87419684],
Cell[13985, 377, 139, 1, 38, "ExampleText",ExpressionUUID->"d3844751-d0cf-4102-983d-a0188541621a",
 CellID->886239600],
Cell[CellGroupData[{
Cell[14149, 382, 201, 4, 26, "Input",ExpressionUUID->"8b789012-0ebd-490e-8a8b-2894eec832f5",
 CellID->21488140],
Cell[14353, 388, 396, 9, 43, "Output",ExpressionUUID->"5774b6af-175f-41db-8e5c-7b5ef9985c7e",
 CellID->216278621]
}, Open  ]],
Cell[CellGroupData[{
Cell[14786, 402, 860, 22, 30, "Input",ExpressionUUID->"ad780cb8-90f2-4d8f-970b-d1c1d1c2fae2",
 CellID->180544031],
Cell[15649, 426, 388, 9, 43, "Output",ExpressionUUID->"58e0f4de-e5df-4583-80ce-0ae1c84675b3",
 CellID->104412570]
}, Open  ]],
Cell[16052, 438, 142, 1, 38, "ExampleText",ExpressionUUID->"a2c6554b-a6e6-4193-8c0b-725d164e916d",
 CellID->278961620],
Cell[CellGroupData[{
Cell[16219, 443, 300, 7, 26, "Input",ExpressionUUID->"6a80a1ca-d6f5-40b5-8d1b-63b742cf3086",
 CellID->295872759],
Cell[16522, 452, 396, 9, 43, "Output",ExpressionUUID->"42a3cc92-f195-40e5-99e5-ba52a9916895",
 CellID->403718067]
}, Open  ]],
Cell[16933, 464, 154, 1, 38, "ExampleText",ExpressionUUID->"86af6c52-dfc3-41b9-ab47-b89180eba303",
 CellID->361149294],
Cell[CellGroupData[{
Cell[17112, 469, 481, 13, 45, "Input",ExpressionUUID->"abfdffee-603c-4e33-86ee-97081d92c882",
 CellID->770911047],
Cell[17596, 484, 403, 9, 43, "Output",ExpressionUUID->"582746f6-a787-469c-ab91-51e17c653e56",
 CellID->332946540]
}, Open  ]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"}, Closed]]]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "PrimaryExamplesSection"}, Closed]]]],
Cell[18241, 502, 2896, 78, 114, "SeeAlsoSection",ExpressionUUID->"997d80e9-d0a2-4c93-b3d1-946c151c1053"],
Cell[21140, 582, 729, 19, 70, "MoreAboutSection",ExpressionUUID->"0af6982e-33ad-4154-b566-da4322d9f5b9"],
Cell[21872, 603, 2350, 62, 70, "RelatedLinksSection",ExpressionUUID->"0afcabf6-79e3-458e-8587-3acc0acd2cca"],
Cell[24225, 667, 78, 0, 70, "FooterCell",ExpressionUUID->"2453c91f-1bc2-4ddb-9abd-a43a82683976"]
}
]
*)

(* End of internal cache information *)

