(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 13.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     30199,        788]
NotebookOptionsPosition[     24558,        673]
NotebookOutlinePosition[     26768,        728]
CellTagsIndexPosition[     26683,        723]
WindowTitle->vtrliq
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[GridBox[{
   {GridBox[{
      {
       ItemBox[Cell[BoxData[
         RowBox[{
          TemplateBox[{12},
           "Spacer1"], Cell["NEW EO S ARGON PACKAGE SYMBOL", "PacletNameCell",
           TextAlignment->Center,ExpressionUUID->
           "16878e99-05e1-4835-9e1c-338229b4a265"], 
          TemplateBox[{8},
           "Spacer1"]}]],
         TextAlignment->Center,ExpressionUUID->
         "026f119a-e5c7-4a80-9027-8863e247dc88"],
        Background->RGBColor[0.490196, 0.576471, 0.690196],
        ItemSize->Full], ""}
     },
     GridBoxAlignment->{"Rows" -> {{Center}}},
     GridBoxItemSize->{"Columns" -> {Full, 
         Scaled[0.02]}, "Rows" -> {{2.5}}}], Cell[TextData[{
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "See Also",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "52b552d5-20ea-4aa7-b88c-12fd75a8c9bb"]
         }],ExpressionUUID->"42588bdf-4e64-47a7-aca8-56c36c5f11bd"],
         StripOnInput->False],{
        "\"rhotrliq\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/rhotrliq"], 
         "\"ttr\"" :> Documentation`HelpLookup["paclet:NewEoSArgon/ref/ttr"], 
         "\"ptr\"" :> Documentation`HelpLookup["paclet:NewEoSArgon/ref/ptr"], 
         "\"rhotrgaz\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/rhotrgaz"], 
         "\"vtrgaz\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/vtrgaz"]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"SeeAlso"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "f09d8a55-c5b5-49d0-bbb1-ccab1bf03120"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "Related Guides",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "5bbd5c42-4965-4785-851b-ca0149a5b677"]
         }],ExpressionUUID->"b7b318c4-75a0-4a54-a5d1-7eb9f9998ecc"],
         StripOnInput->False],{
        "\"NewEoSArgon package\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/guide/NewEoSArgon"]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"MoreAbout"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "f442d76b-9fe4-4f0a-ae89-1b07c9e86521"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "URL",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "c3980a89-5ccd-4ac4-b31a-1e1082ef97b1"]
         }],ExpressionUUID->"d2b1ecb6-1424-464f-abfc-75ec76f717aa"],
         StripOnInput->False],{
        "\"NewEoSArgon/ref/vtrliq\"" :> None, 
         "\"Copy Wolfram Documentation Center URL\"" :> 
         Module[{DocumentationSearch`Private`nb$}, 
           DocumentationSearch`Private`nb$ = 
            NotebookPut[
             Notebook[{Cell["NewEoSArgon/ref/vtrliq"]}, Visible -> False]]; 
           SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
           FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
           NotebookClose[DocumentationSearch`Private`nb$]; Null], Delimiter, 
         "\"Copy web URL\"" :> 
         Module[{DocumentationSearch`Private`nb$}, 
           DocumentationSearch`Private`nb$ = 
            NotebookPut[
             Notebook[{
               Cell[BoxData[
                 MakeBoxes[
                  Hyperlink[
                   "http://reference.wolfram.com/language/NewEoSArgon/ref/\
vtrliq.html"], StandardForm]], "Input", TextClipboardType -> "PlainText"]}, 
               Visible -> False]]; 
           SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
           FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
           NotebookClose[DocumentationSearch`Private`nb$]; Null], 
         "\"Go to web URL\"" :> 
         FrontEndExecute[{
           NotebookLocate[{
             URL[If[TrueQ[DocumentationBuild`Make`Private`wsmlinkQ$35049], 
                 "http://reference.wolfram.com/system-modeler/", 
                 "http://reference.wolfram.com/language/"] <> 
               "NewEoSArgon/ref/vtrliq" <> ".html"], None}]}]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"URLMenu"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "e0b96754-8003-4947-afd2-9d2c5716fca4"]
    }], "AnchorBar",
     CacheGraphics->False,ExpressionUUID->
     "5dbd8adb-248f-4ab6-b8ae-f3d5c5abf394"]}
  }]], "AnchorBarGrid",
 CellID->1,ExpressionUUID->"71f334f5-9d6e-4e67-b3cd-ebae61a34fff"],

Cell["NewEoSArgon`", "ContextNameCell",ExpressionUUID->"31843d5d-120b-42f2-bb01-186e22d0e82f"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     Cell[
     "vtrliq", "ObjectName",ExpressionUUID->
      "d9012b26-fae1-4ec2-83c5-33bdc90801e8"],
     Cell[BoxData[
      TemplateBox[{8},
       "Spacer1"]],ExpressionUUID->"117145f8-e804-452f-8b0e-f902081c4e7f"],
     Cell[BoxData[
     ""], "ObjectNameTranslation",ExpressionUUID->
      "4e48d3ae-c069-4d85-8ca5-cb8a08e05155"]
    }],ExpressionUUID->"18ff9cf1-4869-43ee-ba53-b123ee89a0ce"], 
    "\[SpanFromLeft]"}
  }]], "ObjectNameGrid",ExpressionUUID->"53e1c9f2-3e01-46d3-85bc-\
339783ce83c3"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["vtrliq"], "InlineFormula",
      ShowStringCharacters->False,
      FontFamily->"Source Sans Pro",ExpressionUUID->
      "bb074a0f-0455-4874-a883-7010519c313f"],
     " (",
     Cell[BoxData[
      SuperscriptBox["cm", "3"]], "InlineFormula",
      FontFamily->"Source Sans Pro",ExpressionUUID->
      "acfaa03d-3af0-43aa-b608-918670f2d8da"],
     "/mole)\nVolume molaire du ",
     StyleBox["liquide",
      FontSlant->"Italic"],
     " au point triple de l'argon donn\[EAcute] par NIST \n[",
     StyleBox["Liquid",
      FontSlant->"Italic"],
     " triple point molar volume of argon from NIST]"
    }],ExpressionUUID->"6457de5f-d300-4052-82f4-0b321de4f080"]}
  }]], "Usage",
 Deletable->True,ExpressionUUID->"0143fb9f-95b3-4089-b4e6-489ca3244ca2"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[Cell[TextData[{
   Cell[BoxData[
    DynamicBox[ToBoxes[
      If[
       MatchQ[
        CurrentValue[
         EvaluationNotebook[], {TaggingRules, "Openers", "NotesSection"}, 
         Closed], 
        Alternatives[Open, True]], 
       Style[
        Graphics[{
          Thickness[0.18], 
          RGBColor[0.8509803921568627, 0.396078431372549, 0], 
          Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
         PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
        0.68 Inherited], 
       Rotate[
        Style[
         Graphics[{
           Thickness[0.18], 
           RGBColor[0.8509803921568627, 0.396078431372549, 0], 
           Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
          PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
         0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
     ImageSizeCache->{
      13.600000000000001`, {0.5800000000000001, 13.020000000000001`}}]],
    ExpressionUUID->"4891d718-8e0c-4e73-a82f-3dcbf69fed83"],
   Cell[BoxData[
    TemplateBox[{1},
     "Spacer1"]],ExpressionUUID->"d131ab0b-9f2f-4782-9671-28a33990e8d5"],
   "Details and Options"
  }], "NotesFrameText",ExpressionUUID->"79ee030e-142e-441d-931f-72fffcdc86a8"],
  Appearance->{Automatic, None, "Normal", Automatic},
  BaseStyle->None,
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"], 
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], After, CellContents]}]& ),
  Evaluator->None,
  Method->
   "Preemptive"]],ExpressionUUID->"efa05595-49a6-4e81-8ae1-b43da11941c2"]], \
"NotesSection",
 WholeCellGroupOpener->True,
 CellGroupingRules->{"SectionGrouping", 50},
 CacheGraphics->False,
 CellID->54933607,ExpressionUUID->"f6035c10-704e-4b8b-91de-2ea61954949e"],

Cell[TextData[{
 "Le volume molaire du gaz au point triple peut encore se d\[EAcute]duire de \
la densit\[EAcute] au point triple telle que vtrliq = ",
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["M"]], "paclet:NewEoSArgon/ref/M", "NewEoSArgon Package Symbol"},
   "PackageLink",
   BaseStyle->"InlineFormula"]], "InlineFormula",
  FontFamily->"Source Sans Pro",ExpressionUUID->
  "4bac827e-0fd7-4b14-b05c-feddf62fd540"],
 " / \[Rho]trliq."
}], "Notes",
 CellID->1067943069,ExpressionUUID->"01c42ad2-38d3-4527-bc7d-f21e9b7aaa6c"],

Cell["\<\
******************************************************************************\
*****\
\>", "Notes",
 CellID->185021568,ExpressionUUID->"7aa2f2db-3349-4a71-8c67-f4e5c855950c"],

Cell[TextData[{
 "The molar volume of the liquid at the triple point can still be deduced \
from the liquid density at the triple point as follows vtrliq = ",
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["M"]], "paclet:NewEoSArgon/ref/M", "NewEoSArgon Package Symbol"},
   "PackageLink",
   BaseStyle->"InlineFormula"]], "InlineFormula",
  FontFamily->"Source Sans Pro",ExpressionUUID->
  "16661a33-eb09-40ad-8029-7a9117306d78"],
 " / \[Rho]trliq."
}], "Notes",
 CellID->186926766,ExpressionUUID->"e61fd6d0-f567-4794-a5cc-19f3078197df"]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "NotesSection"}, Closed]]]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {
       TaggingRules, "Openers", "PrimaryExamplesSection"}, Open], 
      Alternatives[True, Open]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{13.600000000000001`, {5., 8.600000000000001}}]],
  ExpressionUUID->"4110f007-a6d3-4734-8590-8a26576a69ac"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"1a5fa565-18e6-42e0-b146-b24625aff4ac"],
 "Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "ec15128b-517b-4bec-a2a6-edfe1048ba1f"]
}], "PrimaryExamplesSection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellTags->"PrimaryExamplesSection",
 CellID->581348844,ExpressionUUID->"fed5d3a3-965f-483f-9fe3-a337060ad885"],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"},
        Closed], 
      Alternatives[Open, True]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{13.600000000000001`, {5., 8.600000000000001}}]],
  ExpressionUUID->"8dd562cf-809d-4199-b5c8-399aa657f43c"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"932a3514-ab52-4294-ba16-48d9c654ce2d"],
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "c374cb93-3a16-4709-8a3e-120db3936e93"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellID->23204566,ExpressionUUID->"b81e93b1-4b7a-42ec-b462-5b348990c311"],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<NewEoSArgon`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->87419684,ExpressionUUID->"a3eacdd7-0d63-4ac5-897f-9d74ac32c907"],

Cell["Give a physical dimension to the constant", "ExampleText",
 CellID->886239600,ExpressionUUID->"2f8820ad-4940-4891-a95e-ff2d9649ee88"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Quantity", "[", 
  RowBox[{"vtrliq", ",", "\"\<cm^3/mol\>\""}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->21488140,ExpressionUUID->"0c03b691-25d6-42ce-bada-62e3fa43025f"],

Cell[BoxData[
 TemplateBox[{"28.1959`", 
   RowBox[{
     SuperscriptBox["\"cm\"", "3"], "\[NegativeMediumSpace]", "\"/\"", 
     "\[InvisibleSpace]", "\"mol\""}], "centimeters cubed per mole", 
   FractionBox[
    SuperscriptBox["\"Centimeters\"", "3"], "\"Moles\""]},
  "Quantity"]], "Output",
 CellLabel->"Out[2]=",
 CellID->188224687,ExpressionUUID->"97c90843-d482-422a-9a63-eadc856949ad"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UnitConvert", "[", 
  RowBox[{
   TemplateBox[{"28.1959`"},
    "QuantityUnit",
    DisplayFunction->(TooltipBox[
      StyleBox[
       RowBox[{#, "\[InvisibleSpace]", 
         StyleBox[
          RowBox[{" ", 
            RowBox[{
              SuperscriptBox["\"cm\"", "3"], "\[NegativeMediumSpace]", 
              "\"/\"", "\[InvisibleSpace]", "\"mol\""}]}], 
          "QuantityUnitTraditionalLabel"]}], ShowStringCharacters -> False], 
      "Unit: centimeters cubed per mole"]& ),
    InterpretationFunction->(RowBox[{"Quantity", "[", 
       RowBox[{#, ",", 
         FractionBox[
          SuperscriptBox["\"Centimeters\"", "3"], "\"Moles\""]}], "]"}]& )], 
   ",", "\"\<m^3/mol\>\""}], "]"}]], "Input",
 NumberMarks->False,
 CellLabel->"In[3]:=",
 CellID->133018084,ExpressionUUID->"f8bdd0de-1c4c-4e68-bc30-25abb9b3fd1e"],

Cell[BoxData[
 TemplateBox[{"0.0000281959`", 
   RowBox[{
     SuperscriptBox["\"m\"", "3"], "\[NegativeMediumSpace]", "\"/\"", 
     "\[InvisibleSpace]", "\"mol\""}], "meters cubed per mole", 
   FractionBox[
    SuperscriptBox["\"Meters\"", "3"], "\"Moles\""]},
  "Quantity"]], "Output",
 CellLabel->"Out[3]=",
 CellID->247734263,ExpressionUUID->"52ac665d-f52f-481a-a392-2868d3e987cf"]
}, Open  ]],

Cell["Other way to define the triple point density", "ExampleText",
 CellID->278961620,ExpressionUUID->"3e65f845-b7e3-40bb-9955-9f4a298e660e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Quantity", "[", 
   RowBox[{"M", ",", "\"\<g/mol\>\""}], "]"}], "/", 
  RowBox[{"Quantity", "[", 
   RowBox[{"\[Rho]trliq", ",", "\"\<g/cm^3\>\""}], "]"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->295872759,ExpressionUUID->"6ad810f9-69b7-433f-af36-59e7c8f8a67d"],

Cell[BoxData[
 TemplateBox[{"28.1959`", 
   RowBox[{
     SuperscriptBox["\"cm\"", "3"], "\[NegativeMediumSpace]", "\"/\"", 
     "\[InvisibleSpace]", "\"mol\""}], "centimeters cubed per mole", 
   FractionBox[
    SuperscriptBox["\"Centimeters\"", "3"], "\"Moles\""]},
  "Quantity"]], "Output",
 CellLabel->"Out[4]=",
 CellID->178222833,ExpressionUUID->"d403a82b-a79a-4bd7-86b7-ca14a0be0e8b"]
}, Open  ]],

Cell["Using ThermodynamicData package (i.e. REFPROP from NIST)", "ExampleText",
 CellID->361149294,ExpressionUUID->"c6394698-7150-43a3-8e52-4fb4c7e8deeb"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UnitConvert", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{"ThermodynamicData", "[", 
     RowBox[{"\"\<Argon\>\"", ",", "\"\<MolarDensity\>\"", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"\"\<Pressure\>\"", "\[Rule]", 
         RowBox[{"Quantity", "[", 
          RowBox[{"ptr", ",", "\"\<Bars\>\""}], "]"}]}], ",", 
        RowBox[{"\"\<Temperature\>\"", "\[Rule]", 
         RowBox[{"Quantity", "[", 
          RowBox[{"ttr", ",", "\"\<Kelvins\>\""}], "]"}]}]}], "}"}]}], 
     "]"}]}], ",", 
   FractionBox[
    SuperscriptBox["\"\<Centimeters\>\"", "3"], "\"\<Moles\>\""]}], 
  "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->770911047,ExpressionUUID->"5e748e83-8f99-439a-886b-338beadfbcd6"],

Cell[BoxData[
 TemplateBox[{"28.196595784784282`", 
   RowBox[{
     SuperscriptBox["\"cm\"", "3"], "\[NegativeMediumSpace]", "\"/\"", 
     "\[InvisibleSpace]", "\"mol\""}], "centimeters cubed per mole", 
   FractionBox[
    SuperscriptBox["\"Centimeters\"", "3"], "\"Moles\""]},
  "Quantity"]], "Output",
 CellLabel->"Out[5]=",
 CellID->77158274,ExpressionUUID->"0d10dc60-bd08-459c-ab60-cb641260e077"]
}, Open  ]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"}, 
  Closed]]]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "PrimaryExamplesSection"}, 
  Closed]]]],

Cell[BoxData[GridBox[{
   {
    DynamicBox[FEPrivate`ImportImage[
      FrontEnd`FileName[{"Documentation", "FooterIcons"}, 
       "RelatedFunction.png"]],
     ImageSizeCache->{50., {27., 33.}}], GridBox[{
      {
       StyleBox[
        RowBox[{"See", " ", "Also"}], "SeeAlsoSection"]},
      {Cell[TextData[{
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["rhotrliq"]], "paclet:NewEoSArgon/ref/rhotrliq", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "47f96883-127e-4f18-b6b3-08aaca6aff88"],
        "\[NonBreakingSpace]",
        StyleBox[
        "\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
         "InlineSeparator"],
        " ",
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["ttr"]], "paclet:NewEoSArgon/ref/ttr", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "212524c4-5a1d-4656-935e-1d341b5a4171"],
        "\[NonBreakingSpace]",
        StyleBox[
        "\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
         "InlineSeparator"],
        " ",
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["ptr"]], "paclet:NewEoSArgon/ref/ptr", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "6dfe713b-e7b2-455a-afa0-53cc49079dad"],
        "\[NonBreakingSpace]",
        StyleBox[
        "\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
         "InlineSeparator"],
        " ",
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["rhotrgaz"]], "paclet:NewEoSArgon/ref/rhotrgaz", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "bed37140-ce42-42e1-b887-ec5df7199ee1"],
        "\[NonBreakingSpace]",
        StyleBox[
        "\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
         "InlineSeparator"],
        " ",
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["vtrgaz"]], "paclet:NewEoSArgon/ref/vtrgaz", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "2f4d8e52-8550-453a-8f28-26535779e445"]
       }], "SeeAlso",ExpressionUUID->"e42c9ccf-fcba-4307-9a7b-5086c09d57b5"]}
     }]}
  }]], "SeeAlsoSection",ExpressionUUID->"a07225e8-a599-494f-b61e-\
6c40fe924157"],

Cell[BoxData[GridBox[{
   {
    DynamicBox[FEPrivate`ImportImage[
      FrontEnd`FileName[{"Documentation", "FooterIcons"}, "RelatedGuide.png"]],
     ImageSizeCache->{50., {27., 33.}}], GridBox[{
      {
       StyleBox[
        RowBox[{"Related", " ", "Guides"}], "MoreAboutSection"]},
      {
       RowBox[{"\[FilledVerySmallSquare]", Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["NewEoSArgon package"]], 
           "paclet:NewEoSArgon/guide/NewEoSArgon"},
          "RefLinkPlain",
          BaseStyle->{"MoreAbout"}]], "MoreAbout",ExpressionUUID->
         "f22f9b53-23fb-4120-90fb-a8eb888cca1a"]}]}
     }]}
  }]], "MoreAboutSection",ExpressionUUID->"820a4173-bdde-4eae-bbcd-\
03fa69b30f51"],

Cell[BoxData[GridBox[{
   {
    TemplateBox[{29},
     "Spacer1"], GridBox[{
      {
       RowBox[{
        TemplateBox[{17},
         "Spacer1"], 
        StyleBox[
         RowBox[{"Related", " ", "Links"}], "RelatedLinksSection"]}]},
      {Cell[BoxData[Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData[
             RowBox[{
               RowBox[{"Units", " ", "&"}], " ", "Quantities"}]]], 
           "paclet:guide/Units"},
          "RefLinkPlain",
          BaseStyle->{"RelatedLinks"}]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "f89e0b81-9e90-4cbd-b4a5-c3b3ec7c70cb"]], "RelatedLinks",
        ExpressionUUID->"2e0ff74a-ca5d-4fe9-882b-91afaa7d5dc4"]},
      {Cell[BoxData[Cell[BoxData[Cell[BoxData[
          RowBox[{
           TemplateBox[{16},
            "Spacer1"], "\[FilledVerySmallSquare]", 
           TemplateBox[{
             Cell[
              TextData[
               Cell[
                TextData[{
                  Cell[
                   BoxData[
                    TemplateBox[{2}, "Spacer1"]]], "ThermodynamicData"}]]]], 
             "paclet:ref/ThermodynamicData"},
            "RefLink",
            BaseStyle->{"RelatedLinks"}]}]],ExpressionUUID->
          "ba470e81-d42b-4e7a-875a-cb78ecdddb7f"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "dfa787bd-470d-43e1-b052-44a4a661b548"]], "RelatedLinks",
        ExpressionUUID->"0bf3446b-3c84-43c8-9659-b41767c73655"]},
      {Cell[TextData[Cell[BoxData[
        RowBox[{
         TemplateBox[{16},
          "Spacer1"], "\[FilledVerySmallSquare]", Cell[BoxData[
          TemplateBox[{
            Cell[
             TextData[
              Cell[
               TextData[{
                 Cell[
                  BoxData[
                   TemplateBox[{2}, "Spacer1"]]], 
                 "Webbook de chimie NIST"}]]]], 
            "http://webbook.nist.gov/chemistry/fluid/"},
           "WebLink",
           BaseStyle->{"RelatedLinks"}]],ExpressionUUID->
          "aff986cc-9164-4d04-b857-da7bc1647046"]}]],ExpressionUUID->
        "494f7e84-87ae-4029-8566-f8dc622ec66b"]], "RelatedLinks",
        ExpressionUUID->"9c168f14-9857-471a-8825-fbf0e1183d4e"]}
     }]}
  }]], "RelatedLinksSection",ExpressionUUID->"861eb564-01a7-4cd4-bd3d-\
0d5f7690c1d9"],

Cell[" ", "FooterCell",ExpressionUUID->"068d6e62-3b19-41c9-9f1c-1c4a40884dfc"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{900, 835.8},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"vtrliq",
TaggingRules->{
 "ModificationHighlight" -> False, "ColorType" -> "", "LinkTrails" -> "", 
  "HasOptions" -> True, "ExampleCounter" -> 1, 
  "Openers" -> {
   "PrimaryExamplesSection" -> Open, "ExampleSection" -> {"0" -> Open}, 
    "NotesSection" -> Closed}, "NewStyles" -> True, 
  "CitationPopupData" -> $Failed, "ShowCitation" -> False, "RootCaptions" -> 
  "", "Metadata" -> {
   "built" -> "{2023, 11, 30, 13, 56, 19.0158803}", 
    "history" -> {"XX", "", "", ""}, "context" -> "NewEoSArgon`", 
    "keywords" -> {}, "specialkeywords" -> {}, 
    "tutorialcollectionlinks" -> {}, "index" -> True, "label" -> 
    "New Eo S Argon Package Symbol", "language" -> "en", "paclet" -> 
    "NewEoSArgon Package", "status" -> "None", "summary" -> 
    "vtrliq (cm^3/mole) Volume molaire du liquide au point triple de l'argon \
donn\[EAcute] par NIST [Liquid triple point molar volume of argon from NIST]",
     "synonyms" -> {}, "tabletags" -> {}, "title" -> "vtrliq", 
    "titlemodifier" -> "", "metadescription" -> "", "windowtitle" -> "vtrliq",
     "type" -> "Symbol", "uri" -> "NewEoSArgon/ref/vtrliq"}},
CellContext->"Global`",
FrontEndVersion->"13.3 pour Microsoft Windows (64-bit) (July 24, 2023)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "13.3 pour Microsoft Windows (64-bit) (July 24, 2023)", 
  StyleDefinitions -> "Default.nb"],
ExpressionUUID->"6c86f37e-aa13-421c-b654-1a29f063bd66"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[10963, 291, 1420, 37, 35, "PrimaryExamplesSection",ExpressionUUID->"fed5d3a3-965f-483f-9fe3-a337060ad885",
   CellTags->"PrimaryExamplesSection",
   CellID->581348844]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 26483, 716}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[578, 21, 5531, 133, 56, "AnchorBarGrid",ExpressionUUID->"71f334f5-9d6e-4e67-b3cd-ebae61a34fff",
 CellID->1],
Cell[6112, 156, 94, 0, 23, "ContextNameCell",ExpressionUUID->"31843d5d-120b-42f2-bb01-186e22d0e82f"],
Cell[CellGroupData[{
Cell[6231, 160, 549, 14, 56, "ObjectNameGrid",ExpressionUUID->"53e1c9f2-3e01-46d3-85bc-339783ce83c3"],
Cell[6783, 176, 818, 20, 146, "Usage",ExpressionUUID->"0143fb9f-95b3-4089-b4e6-489ca3244ca2"]
}, Open  ]],
Cell[CellGroupData[{
Cell[7638, 201, 1918, 48, 37, "NotesSection",ExpressionUUID->"f6035c10-704e-4b8b-91de-2ea61954949e",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->54933607],
Cell[9559, 251, 540, 13, 38, "Notes",ExpressionUUID->"01c42ad2-38d3-4527-bc7d-f21e9b7aaa6c",
 CellID->1067943069],
Cell[10102, 266, 185, 4, 36, "Notes",ExpressionUUID->"7aa2f2db-3349-4a71-8c67-f4e5c855950c",
 CellID->185021568],
Cell[10290, 272, 546, 13, 59, "Notes",ExpressionUUID->"e61fd6d0-f567-4794-a5cc-19f3078197df",
 CellID->186926766]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "NotesSection"}, Closed]]]],
Cell[CellGroupData[{
Cell[10963, 291, 1420, 37, 35, "PrimaryExamplesSection",ExpressionUUID->"fed5d3a3-965f-483f-9fe3-a337060ad885",
 CellTags->"PrimaryExamplesSection",
 CellID->581348844],
Cell[CellGroupData[{
Cell[12408, 332, 1397, 36, 30, "ExampleSection",ExpressionUUID->"b81e93b1-4b7a-42ec-b462-5b348990c311",
 CellID->23204566],
Cell[13808, 370, 174, 3, 26, "Input",ExpressionUUID->"a3eacdd7-0d63-4ac5-897f-9d74ac32c907",
 CellID->87419684],
Cell[13985, 375, 139, 1, 38, "ExampleText",ExpressionUUID->"2f8820ad-4940-4891-a95e-ff2d9649ee88",
 CellID->886239600],
Cell[CellGroupData[{
Cell[14149, 380, 201, 4, 26, "Input",ExpressionUUID->"0c03b691-25d6-42ce-bada-62e3fa43025f",
 CellID->21488140],
Cell[14353, 386, 393, 9, 43, "Output",ExpressionUUID->"97c90843-d482-422a-9a63-eadc856949ad",
 CellID->188224687]
}, Open  ]],
Cell[CellGroupData[{
Cell[14783, 400, 857, 22, 30, "Input",ExpressionUUID->"f8bdd0de-1c4c-4e68-bc30-25abb9b3fd1e",
 CellID->133018084],
Cell[15643, 424, 387, 9, 43, "Output",ExpressionUUID->"52ac665d-f52f-481a-a392-2868d3e987cf",
 CellID->247734263]
}, Open  ]],
Cell[16045, 436, 142, 1, 38, "ExampleText",ExpressionUUID->"3e65f845-b7e3-40bb-9955-9f4a298e660e",
 CellID->278961620],
Cell[CellGroupData[{
Cell[16212, 441, 300, 7, 26, "Input",ExpressionUUID->"6ad810f9-69b7-433f-af36-59e7c8f8a67d",
 CellID->295872759],
Cell[16515, 450, 393, 9, 43, "Output",ExpressionUUID->"d403a82b-a79a-4bd7-86b7-ca14a0be0e8b",
 CellID->178222833]
}, Open  ]],
Cell[16923, 462, 154, 1, 38, "ExampleText",ExpressionUUID->"c6394698-7150-43a3-8e52-4fb4c7e8deeb",
 CellID->361149294],
Cell[CellGroupData[{
Cell[17102, 467, 742, 19, 67, "Input",ExpressionUUID->"5e748e83-8f99-439a-886b-338beadfbcd6",
 CellID->770911047],
Cell[17847, 488, 403, 9, 43, "Output",ExpressionUUID->"0d10dc60-bd08-459c-ab60-cb641260e077",
 CellID->77158274]
}, Open  ]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"}, Closed]]]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "PrimaryExamplesSection"}, Closed]]]],
Cell[18492, 506, 2896, 78, 114, "SeeAlsoSection",ExpressionUUID->"a07225e8-a599-494f-b61e-6c40fe924157"],
Cell[21391, 586, 729, 19, 70, "MoreAboutSection",ExpressionUUID->"820a4173-bdde-4eae-bbcd-03fa69b30f51"],
Cell[22123, 607, 2350, 62, 70, "RelatedLinksSection",ExpressionUUID->"861eb564-01a7-4cd4-bd3d-0d5f7690c1d9"],
Cell[24476, 671, 78, 0, 70, "FooterCell",ExpressionUUID->"068d6e62-3b19-41c9-9f1c-1c4a40884dfc"]
}
]
*)

(* End of internal cache information *)

