(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 13.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     22712,        592]
NotebookOptionsPosition[     18115,        496]
NotebookOutlinePosition[     20297,        551]
CellTagsIndexPosition[     20212,        546]
WindowTitle->zc
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[GridBox[{
   {GridBox[{
      {
       ItemBox[Cell[BoxData[
         RowBox[{
          TemplateBox[{12},
           "Spacer1"], Cell["NEW EO S ARGON PACKAGE SYMBOL", "PacletNameCell",
           TextAlignment->Center,ExpressionUUID->
           "29e57d03-4262-46d5-867d-fe83ad503fe3"], 
          TemplateBox[{8},
           "Spacer1"]}]],
         TextAlignment->Center,ExpressionUUID->
         "fdca7554-6223-4f46-9238-9ba17fa4e766"],
        Background->RGBColor[0.490196, 0.576471, 0.690196],
        ItemSize->Full], ""}
     },
     GridBoxAlignment->{"Rows" -> {{Center}}},
     GridBoxItemSize->{"Columns" -> {Full, 
         Scaled[0.02]}, "Rows" -> {{2.5}}}], Cell[TextData[{
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "See Also",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "15e1feb9-953a-4315-a67e-2ff7043d62c1"]
         }],ExpressionUUID->"33244d3b-b355-43a1-ba51-b20bd195ea71"],
         StripOnInput->False],{
        "\"pc\"" :> Documentation`HelpLookup["paclet:NewEoSArgon/ref/pc"], 
         "\"vc\"" :> Documentation`HelpLookup["paclet:NewEoSArgon/ref/vc"], 
         "\"tc\"" :> Documentation`HelpLookup["paclet:NewEoSArgon/ref/tc"], 
         "\"rhoc\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/rhoc"], "\"RR\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/RR"]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"SeeAlso"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "cc3604fc-b908-40ab-93d4-2e38327957f2"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "Related Guides",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "981028a9-a8ae-45c4-ad54-58981d277fa8"]
         }],ExpressionUUID->"2c8a6690-68d6-4ed3-9dce-fdb4f12bca6b"],
         StripOnInput->False],{
        "\"NewEoSArgon Package\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/guide/NewEoSArgon"]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"MoreAbout"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "1f4a6bd4-f8ba-4309-9f09-6a279978418f"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "URL",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "a1e87fb0-5502-4bf8-930b-24b2a9b78dde"]
         }],ExpressionUUID->"f677bc23-ffe6-4425-8cd0-d56f8979a974"],
         StripOnInput->False],{
        "\"NewEoSArgon/ref/zc\"" :> None, 
         "\"Copy Wolfram Documentation Center URL\"" :> 
         Module[{DocumentationSearch`Private`nb$}, 
           DocumentationSearch`Private`nb$ = 
            NotebookPut[
             Notebook[{Cell["NewEoSArgon/ref/zc"]}, Visible -> False]]; 
           SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
           FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
           NotebookClose[DocumentationSearch`Private`nb$]; Null], Delimiter, 
         "\"Copy web URL\"" :> 
         Module[{DocumentationSearch`Private`nb$}, 
           DocumentationSearch`Private`nb$ = 
            NotebookPut[
             Notebook[{
               Cell[BoxData[
                 MakeBoxes[
                  Hyperlink[
                   "http://reference.wolfram.com/language/NewEoSArgon/ref/zc.\
html"], StandardForm]], "Input", TextClipboardType -> "PlainText"]}, Visible -> 
               False]]; 
           SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
           FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
           NotebookClose[DocumentationSearch`Private`nb$]; Null], 
         "\"Go to web URL\"" :> 
         FrontEndExecute[{
           NotebookLocate[{
             URL[If[TrueQ[DocumentationBuild`Make`Private`wsmlinkQ$35569], 
                 "http://reference.wolfram.com/system-modeler/", 
                 "http://reference.wolfram.com/language/"] <> 
               "NewEoSArgon/ref/zc" <> ".html"], None}]}]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"URLMenu"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "0bbe6e5b-ab0e-46be-9b2a-511448223c6a"]
    }], "AnchorBar",
     CacheGraphics->False,ExpressionUUID->
     "19c2eb10-dd55-46f2-aa13-26ac032dfed7"]}
  }]], "AnchorBarGrid",
 CellID->1,ExpressionUUID->"2a9b0983-90a4-4fe0-a81d-4cec46095e45"],

Cell["NewEoSArgon`", "ContextNameCell",ExpressionUUID->"9292abf7-0345-4d1c-b75f-82fdf26eb4a4"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     Cell[
     "zc", "ObjectName",ExpressionUUID->
      "a82f72e4-f176-4517-9919-f34a5090c0be"],
     Cell[BoxData[
      TemplateBox[{8},
       "Spacer1"]],ExpressionUUID->"4f6e4724-2524-43a6-b34a-41f417a71285"],
     Cell[BoxData[
     ""], "ObjectNameTranslation",ExpressionUUID->
      "236eaf7b-f7ed-4b4f-ae87-b3392ca27890"]
    }],ExpressionUUID->"777d5902-f8e6-41de-ac33-cc60b6cb8ae2"], 
    "\[SpanFromLeft]"}
  }]], "ObjectNameGrid",ExpressionUUID->"86e7ecca-f0ad-4a1e-8de5-\
f472d4b75700"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["zc"], "InlineFormula",
      ShowStringCharacters->False,
      FontFamily->"Source Sans Pro",ExpressionUUID->
      "f3b2743f-218b-434e-b09b-43f98a19cc2f"],
     " \[Congruent] ",
     Cell[BoxData[
      FractionBox[
       RowBox[{"pc", "\[Cross]", "vc"}], 
       RowBox[{"R", "*", "tc"}]]], "InlineFormula",
      FontFamily->"Source Sans Pro",ExpressionUUID->
      "448f2656-d2e7-469d-911c-37b677221e71"],
     "\nFacteur de compressibilit\[EAcute] du point critique de l'argon donn\
\[EAcute]e par NIST\n[Critical compressibility factor of argon from NIST]"
    }],ExpressionUUID->"e9a9ea6b-dce9-4d5e-8831-feaaacee8e31"]}
  }]], "Usage",
 Deletable->True,ExpressionUUID->"d368fbce-f275-4ad6-a7d8-ca677d0f8f4c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {
       TaggingRules, "Openers", "PrimaryExamplesSection"}, Open], 
      Alternatives[True, Open]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{13.600000000000001`, {5., 8.600000000000001}}]],
  ExpressionUUID->"233a218c-6e7b-484a-8b1d-d3c0e47b971e"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"51532ced-3d26-48bd-9389-2d56ea6ee6a1"],
 "Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "fe27793d-d0c3-42d4-9504-e6db0561fbbc"]
}], "PrimaryExamplesSection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellTags->"PrimaryExamplesSection",
 CellID->5183969,ExpressionUUID->"d70781f1-b6d5-48ac-80ac-70ecde890a1f"],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"},
        Closed], 
      Alternatives[Open, True]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{13.600000000000001`, {5., 8.600000000000001}}]],
  ExpressionUUID->"6c59ca6f-0f4a-4634-919a-cbd4f971c918"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"0124434d-d171-416b-b5f6-5482da7ee881"],
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "8974c5c3-79fd-48c3-84a7-7cd046b05d0c"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellID->25060910,ExpressionUUID->"2833f330-cdfb-4e2b-9a6e-0b64d356aeb2"],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<NewEoSArgon`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->87419684,ExpressionUUID->"f810d037-ac70-4771-96f4-b46d99894f92"],

Cell[CellGroupData[{

Cell[BoxData["zc"], "Input",
 CellLabel->"In[2]:=",
 CellID->14204249,ExpressionUUID->"b341e3a6-bb0d-4562-9848-ecb8c0df9495"],

Cell[BoxData["0.289501`"], "Output",
 CellLabel->"Out[2]=",
 CellID->221688037,ExpressionUUID->"45bf2b4a-3dd1-4a26-9c01-3aa19a30906e"]
}, Open  ]],

Cell["Definition of the compressibility factor", "ExampleText",
 CellID->278961620,ExpressionUUID->"a13b340e-ffb9-43fe-948c-75ecf350e2e2"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Quantity", "[", 
   RowBox[{
    RowBox[{"pc", "/", "10"}], ",", "\"\<MPa\>\""}], "]"}], "*", 
  RowBox[{
   RowBox[{"Quantity", "[", 
    RowBox[{"vc", ",", "\"\<cm^3/mol\>\""}], "]"}], "/", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"Quantity", "[", "\"\<MolarGasConstant\>\"", "]"}], "*", 
     RowBox[{"Quantity", "[", 
      RowBox[{"tc", ",", "\"\<Kelvins\>\""}], "]"}]}], ")"}]}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->295872759,ExpressionUUID->"6c232c49-7d68-4da9-805a-1de5b1f75a34"],

Cell[BoxData["0.2895008664325015`"], "Output",
 CellLabel->"Out[3]=",
 CellID->587903186,ExpressionUUID->"4d33ff51-f33b-4fed-9946-c8987048af84"]
}, Open  ]],

Cell["Using ThermodynamicData package (i.e. REFPROP from NIST)", "ExampleText",
 CellID->361149294,ExpressionUUID->"9ea2b331-9d5a-4728-a03e-ac4ba9f4d5d6"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ThermodynamicData", "[", 
  RowBox[{"\"\<Argon\>\"", ",", "\"\<CompressibilityFactor\>\"", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\"\<Pressure\>\"", "\[Rule]", 
      RowBox[{"Quantity", "[", 
       RowBox[{"pc", ",", "\"\<Bars\>\""}], "]"}]}], ",", 
     RowBox[{"\"\<Temperature\>\"", "\[Rule]", 
      RowBox[{"Quantity", "[", 
       RowBox[{"tc", ",", "\"\<Kelvins\>\""}], "]"}]}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->770911047,ExpressionUUID->"4c4c7678-14c3-455f-8326-36e9c6d23c21"],

Cell[BoxData["0.29269668791692993`"], "Output",
 CellLabel->"Out[4]=",
 CellID->13282099,ExpressionUUID->"da73ee7a-07d7-4f48-a6de-eac3c9309d08"]
}, Open  ]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"}, 
  Closed]]]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "PrimaryExamplesSection"}, 
  Closed]]]],

Cell[BoxData[GridBox[{
   {
    DynamicBox[FEPrivate`ImportImage[
      FrontEnd`FileName[{"Documentation", "FooterIcons"}, 
       "RelatedFunction.png"]],
     ImageSizeCache->{50., {27., 33.}}], GridBox[{
      {
       StyleBox[
        RowBox[{"See", " ", "Also"}], "SeeAlsoSection"]},
      {Cell[TextData[{
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["pc"]], "paclet:NewEoSArgon/ref/pc", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "bd0f7017-994e-48e9-bafa-1533d1703478"],
        "\[NonBreakingSpace]",
        StyleBox[
        "\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
         "InlineSeparator"],
        " ",
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["vc"]], "paclet:NewEoSArgon/ref/vc", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "ac78c37d-89a1-4976-b52f-53347130a664"],
        "\[NonBreakingSpace]",
        StyleBox[
        "\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
         "InlineSeparator"],
        " ",
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["tc"]], "paclet:NewEoSArgon/ref/tc", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "49f84fdf-4663-4006-882c-fdf49682ea3f"],
        "\[NonBreakingSpace]",
        StyleBox[
        "\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
         "InlineSeparator"],
        " ",
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["rhoc"]], "paclet:NewEoSArgon/ref/rhoc", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "d68d054e-a726-4ffd-9232-ee3f6a00288e"],
        "\[NonBreakingSpace]",
        StyleBox[
        "\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
         "InlineSeparator"],
        " ",
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["RR"]], "paclet:NewEoSArgon/ref/RR", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "fa5670e6-ac7e-42ed-a5d3-05a8fb82e92c"]
       }], "SeeAlso",ExpressionUUID->"9978aa5c-6cd0-4592-926c-6eb6e266297a"]}
     }]}
  }]], "SeeAlsoSection",ExpressionUUID->"0c0283ad-d03d-43bf-a451-\
2d02476cf9a8"],

Cell[BoxData[GridBox[{
   {
    DynamicBox[FEPrivate`ImportImage[
      FrontEnd`FileName[{"Documentation", "FooterIcons"}, "RelatedGuide.png"]],
     ImageSizeCache->{50., {27., 33.}}], GridBox[{
      {
       StyleBox[
        RowBox[{"Related", " ", "Guides"}], "MoreAboutSection"]},
      {
       RowBox[{"\[FilledVerySmallSquare]", Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["NewEoSArgon Package"]], 
           "paclet:NewEoSArgon/guide/NewEoSArgon"},
          "RefLinkPlain",
          BaseStyle->{"MoreAbout"}]], "MoreAbout",ExpressionUUID->
         "2a29e31d-7e67-4c7d-b546-26deda9593fa"]}]}
     }]}
  }]], "MoreAboutSection",ExpressionUUID->"a2c5b944-23e4-4e8c-88d5-\
6dbd0cd547e5"],

Cell[BoxData[GridBox[{
   {
    TemplateBox[{29},
     "Spacer1"], GridBox[{
      {
       RowBox[{
        TemplateBox[{17},
         "Spacer1"], 
        StyleBox[
         RowBox[{"Related", " ", "Links"}], "RelatedLinksSection"]}]},
      {Cell[BoxData[Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData[
             RowBox[{
               RowBox[{"Units", " ", "&"}], " ", "Quantities"}]]], 
           "paclet:guide/Units"},
          "RefLinkPlain",
          BaseStyle->{"RelatedLinks"}]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "4c03dff5-4ddc-480a-8439-6ba9830a6c76"]], "RelatedLinks",
        ExpressionUUID->"ea3a7aba-ce3f-48b3-91bb-8893e9630d1a"]},
      {Cell[BoxData[Cell[BoxData[Cell[BoxData[
          RowBox[{
           TemplateBox[{16},
            "Spacer1"], "\[FilledVerySmallSquare]", 
           TemplateBox[{
             Cell[
              TextData[
               Cell[
                TextData[{
                  Cell[
                   BoxData[
                    TemplateBox[{2}, "Spacer1"]]], "ThermodynamicData"}]]]], 
             "paclet:ref/ThermodynamicData"},
            "RefLink",
            BaseStyle->{"RelatedLinks"}]}]],ExpressionUUID->
          "cfc426af-9549-4d2e-a64b-a9cd26aa5d5f"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "5df5cac2-5da7-486a-8520-650e4043ffd3"]], "RelatedLinks",
        ExpressionUUID->"28215f43-518b-450a-b27c-159d29dac5a1"]}
     }]}
  }]], "RelatedLinksSection",ExpressionUUID->"d38b402b-fb9f-4d79-a281-\
7df0dd41f767"],

Cell[" ", "FooterCell",ExpressionUUID->"387d66c1-411d-40e9-8aa0-8bbc3b643737"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{900, 835.8},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"zc",
TaggingRules->{
 "ModificationHighlight" -> False, "ColorType" -> "", "LinkTrails" -> "", 
  "HasOptions" -> True, "ExampleCounter" -> 1, 
  "Openers" -> {
   "PrimaryExamplesSection" -> Open, "ExampleSection" -> {"0" -> Open}}, 
  "NewStyles" -> True, "CitationPopupData" -> $Failed, "ShowCitation" -> 
  False, "RootCaptions" -> "", 
  "Metadata" -> {
   "built" -> "{2023, 11, 30, 13, 56, 19.8395591}", 
    "history" -> {"XX", "", "", ""}, "context" -> "NewEoSArgon`", 
    "keywords" -> {}, "specialkeywords" -> {}, 
    "tutorialcollectionlinks" -> {}, "index" -> True, "label" -> 
    "New Eo S Argon Package Symbol", "language" -> "en", "paclet" -> 
    "NewEoSArgon Package", "status" -> "None", "summary" -> 
    "zc \\[Congruent] pc*vc/(R*tc) Facteur de compressibilit\[EAcute] du \
point critique de l'argon donn\[EAcute]e par NIST [Critical compressibility \
factor of argon from NIST]", "synonyms" -> {}, "tabletags" -> {}, "title" -> 
    "zc", "titlemodifier" -> "", "metadescription" -> "", "windowtitle" -> 
    "zc", "type" -> "Symbol", "uri" -> "NewEoSArgon/ref/zc"}},
CellContext->"Global`",
FrontEndVersion->"13.3 pour Microsoft Windows (64-bit) (July 24, 2023)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "13.3 pour Microsoft Windows (64-bit) (July 24, 2023)", 
  StyleDefinitions -> "Default.nb"],
ExpressionUUID->"b2006c13-f6fa-482d-a30b-464d87c77f53"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7528, 196, 1418, 37, 35, "PrimaryExamplesSection",ExpressionUUID->"d70781f1-b6d5-48ac-80ac-70ecde890a1f",
   CellTags->"PrimaryExamplesSection",
   CellID->5183969]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 20015, 539}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[574, 21, 5463, 131, 56, "AnchorBarGrid",ExpressionUUID->"2a9b0983-90a4-4fe0-a81d-4cec46095e45",
 CellID->1],
Cell[6040, 154, 94, 0, 23, "ContextNameCell",ExpressionUUID->"9292abf7-0345-4d1c-b75f-82fdf26eb4a4"],
Cell[CellGroupData[{
Cell[6159, 158, 545, 14, 56, "ObjectNameGrid",ExpressionUUID->"86e7ecca-f0ad-4a1e-8de5-f472d4b75700"],
Cell[6707, 174, 784, 17, 150, "Usage",ExpressionUUID->"d368fbce-f275-4ad6-a7d8-ca677d0f8f4c"]
}, Open  ]],
Cell[CellGroupData[{
Cell[7528, 196, 1418, 37, 35, "PrimaryExamplesSection",ExpressionUUID->"d70781f1-b6d5-48ac-80ac-70ecde890a1f",
 CellTags->"PrimaryExamplesSection",
 CellID->5183969],
Cell[CellGroupData[{
Cell[8971, 237, 1397, 36, 30, "ExampleSection",ExpressionUUID->"2833f330-cdfb-4e2b-9a6e-0b64d356aeb2",
 CellID->25060910],
Cell[10371, 275, 174, 3, 26, "Input",ExpressionUUID->"f810d037-ac70-4771-96f4-b46d99894f92",
 CellID->87419684],
Cell[CellGroupData[{
Cell[10570, 282, 125, 2, 26, "Input",ExpressionUUID->"b341e3a6-bb0d-4562-9848-ecb8c0df9495",
 CellID->14204249],
Cell[10698, 286, 134, 2, 35, "Output",ExpressionUUID->"45bf2b4a-3dd1-4a26-9c01-3aa19a30906e",
 CellID->221688037]
}, Open  ]],
Cell[10847, 291, 138, 1, 38, "ExampleText",ExpressionUUID->"a13b340e-ffb9-43fe-948c-75ecf350e2e2",
 CellID->278961620],
Cell[CellGroupData[{
Cell[11010, 296, 533, 14, 26, "Input",ExpressionUUID->"6c232c49-7d68-4da9-805a-1de5b1f75a34",
 CellID->295872759],
Cell[11546, 312, 144, 2, 35, "Output",ExpressionUUID->"4d33ff51-f33b-4fed-9946-c8987048af84",
 CellID->587903186]
}, Open  ]],
Cell[11705, 317, 154, 1, 38, "ExampleText",ExpressionUUID->"9ea2b331-9d5a-4728-a03e-ac4ba9f4d5d6",
 CellID->361149294],
Cell[CellGroupData[{
Cell[11884, 322, 551, 13, 42, "Input",ExpressionUUID->"4c4c7678-14c3-455f-8326-36e9c6d23c21",
 CellID->770911047],
Cell[12438, 337, 144, 2, 35, "Output",ExpressionUUID->"da73ee7a-07d7-4f48-a6de-eac3c9309d08",
 CellID->13282099]
}, Open  ]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"}, Closed]]]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "PrimaryExamplesSection"}, Closed]]]],
Cell[12824, 348, 2864, 78, 114, "SeeAlsoSection",ExpressionUUID->"0c0283ad-d03d-43bf-a451-2d02476cf9a8"],
Cell[15691, 428, 729, 19, 114, "MoreAboutSection",ExpressionUUID->"a2c5b944-23e4-4e8c-88d5-6dbd0cd547e5"],
Cell[16423, 449, 1607, 43, 70, "RelatedLinksSection",ExpressionUUID->"d38b402b-fb9f-4d79-a281-7df0dd41f767"],
Cell[18033, 494, 78, 0, 70, "FooterCell",ExpressionUUID->"387d66c1-411d-40e9-8aa0-8bbc3b643737"]
}
]
*)

(* End of internal cache information *)

