(* ::Package:: *)

(* ::Title:: *)
(*EQUATIONS D'ETAT DE l'ARGON FLUIDE FAVORISANT LES DATA RONCHI (mod\[EGrave]le non- extensif)*)


(* Title: NexEoSArgon.m *)
(* Context: *)
(* 
  Author:Fr\[EAcute]d\[EAcute]ric Aitken *)
(* Date: 30.01.2014, Grenoble *)
(* 
  Summary: Equations of State for Argon fluid from Subscript[T, triple] to 2300 K *)
(* Package Version: 0.0.1 *)
(* 
  Mathematica Version: 9.0 *)
(*
Les quantit\[EAcute]s thermostatiques propres au mod\[EGrave]le non-extensif se terminent toutes par Nv.
Les \[EAcute]quations d'\[EAcute]tat fondamentales sont toutes calculables telles que T > 0 et \[Rho] \[GreaterEqual] 0.
En revanche les \[EAcute]quations d'\[EAcute]tat s'exprimant \[AGrave] l'aide des quantit\[EAcute]s fondamentales sont calculables uniquement dans le domaine fluide, soit T \[GreaterEqual] Subscript[T, triple] et \[Rho] \[GreaterEqual] 0.
*)


(*******************************************)
BeginPackage["NewEoSArgon`"];
(*******************************************)
Off[Protect::locked];
Off[Attributes::locked];
Off[ClearAll::wrsym];
Off[SetDelayed::write]
Off[SetAttributes::sym]
Off[General::munfl]
Unprotect@@Names["NewEoSArgon`*"];
ClearAll@@Names["NewEoSArgon`*"];


(*D\[EAcute]finitions des constantes*)
RR::usage="Constante des gaz parfaits (J/mole/K)";
M::usage="Masse molaire de l'argon (g/mole)";
Na::usage="Nombre d'Avogadro (\!\(\*SuperscriptBox[\(mole\), \(-1\)]\))";

vtrliq::usage="Volume molaire du liquide au point triple (\!\(\*SuperscriptBox[\(cm\), \(3\)]\)/mole) donn\[EAcute]e par NIST";
rhotrliq::usage="Densit\[EAcute] du liquide au point triple (g/\!\(\*SuperscriptBox[\(cm\), \(3\)]\)) donn\[EAcute]e par NIST";
\[Rho]trliq::usage="Idem que rhotrliq";
vtrgaz::usage="Volume molaire du gaz au point triple (\!\(\*SuperscriptBox[\(cm\), \(3\)]\)/mole) donn\[EAcute]e par NIST";
rhotrgaz::usage="Densit\[EAcute] du gaz au point triple (g/\!\(\*SuperscriptBox[\(cm\), \(3\)]\)) donn\[EAcute]e par NIST";
\[Rho]trgaz::usage="Idem que rhotrgaz";

ttr::usage="Temp\[EAcute]rature du point triple (K) donn\[EAcute]e par NIST";
ptr::usage="Pression du point triple (bar) donn\[EAcute]e par NIST";
tc::usage="Temp\[EAcute]rature du point critique (K) donn\[EAcute]e par NIST";
vc::usage="Volume molaire du point critique donn\[EAcute]e par NIST (\!\(\*SuperscriptBox[\(cm\), \(3\)]\)/mole)";
rhoc::usage="Densit\[EAcute] du point critique donn\[EAcute]e par NIST (g/\!\(\*SuperscriptBox[\(cm\), \(3\)]\))";
\[Rho]c::usage="Idem que rhoc";
pc::usage="Pression du point critique donn\[EAcute]e par NIST (bar)";
zc::usage="Facteur de compressibilit\[EAcute] du point critique donn\[EAcute]e par NIST";

ptrNv::usage="Pression du point triple (bar) d\[EAcute]duite des relations de Maxwell";
rhotrgazNv::usage="Densit\[EAcute] du gaz au point triple (g/\!\(\*SuperscriptBox[\(cm\), \(3\)]\)) d\[EAcute]duite des relations de Maxwell";
\[Rho]trgazNv::usage="Idem que rhotrgazNv";
rhotrliqNv::usage="Densit\[EAcute] du liquide au point triple (g/\!\(\*SuperscriptBox[\(cm\), \(3\)]\)) d\[EAcute]duite des relations de Maxwell";
\[Rho]trliqNv::usage="Idem que rhotrliqNv";
pcNv::usage="Pression du point critique (bar) d\[EAcute]duite des relations de Maxwell";
tcNv::usage="Temp\[EAcute]rature du point critique (K) d\[EAcute]duite des relations de Maxwell";
rhocNv::usage="Densit\[EAcute] du point critique (g/\!\(\*SuperscriptBox[\(cm\), \(3\)]\)) d\[EAcute]duite des relations de Maxwell";
\[Rho]cNv::usage="Idem que rhocNv";

rhomaxRonc::usage="Densit\[EAcute] maximum des data Ronchi (g/\!\(\*SuperscriptBox[\(cm\), \(3\)]\))";
\[Rho]maxRonc::usage="Idem que rhomaxRonc";
tmaxRonc::usage="Temp\[EAcute]rature maximum des data Ronchi (K)";

(*D\[EAcute]finitions des fonctions*)
NewEoSArgonFunctions::usage="Liste des fonctions et param\[EGrave]tres publics";

Tdiv::usage="Fonction permettant de calculer la temperature (K) correspondante \[AGrave] la divergence du \!\(\*
StyleBox[SubscriptBox[\"C\", \"V\"],\nFontSlant->\"Italic\"]\) en fonction de \[Rho] (g/\!\(\*SuperscriptBox[\(cm\), \(3\)]\))";
Tdiv::argx="La fonction contient comme seul argument la densit\[EAcute] \[Rho] en g/\!\(\*SuperscriptBox[\(cm\), \(3\)]\) o\[UGrave] \[Rho] \[GreaterEqual] 0";

TSatNIST::usage="Fonction fittant la temp\[EAcute]rature (K) sur la courbe de saturation donn\[EAcute]e par NIST en fonction de \[Rho] (g/\!\(\*SuperscriptBox[\(cm\), \(3\)]\))";
TSatNIST::argx="La fonction contient comme seul argument la densit\[EAcute] \[Rho] en g/\!\(\*SuperscriptBox[\(cm\), \(3\)]\) o\[UGrave] \[Rho]trgaz \[LessEqual] \[Rho] \[LessEqual] \[Rho]trliq";
RhoSatLiqNISTFromT::usage="Fonction permettant de d\[EAcute]terminer la densit\[EAcute] du liquide (g/\!\(\*SuperscriptBox[\(cm\), \(3\)]\)) sur la courbe de saturation donn\[EAcute]e par NIST en fonction de T (K)";
RhoSatLiqNISTFromT::argx="La fonction contient comme seul argument la temp\[EAcute]rature \!\(\*
StyleBox[\"T\",\nFontSlant->\"Italic\"]\) en K o\[UGrave] ttr \[LessEqual] \!\(\*
StyleBox[\"T\",\nFontSlant->\"Italic\"]\) \[LessEqual] tc";
RhoSatVapNISTFromT::usage="Fonction permettant de d\[EAcute]terminer la densit\[EAcute] du gaz (g/\!\(\*SuperscriptBox[\(cm\), \(3\)]\)) sur la courbe de saturation donn\[EAcute]e par NIST en fonction de T (K)";
RhoSatVapNISTFromT::argx="La fonction contient comme seul argument la temp\[EAcute]rature \!\(\*
StyleBox[\"T\",\nFontSlant->\"Italic\"]\) en K o\[UGrave] ttr \[LessEqual] \!\(\*
StyleBox[\"T\",\nFontSlant->\"Italic\"]\) \[LessEqual] tc";
PRhoSatNIST::usage="Fonction permettant de d\[EAcute]terminer la pression (bar) sur la courbe de saturation donn\[EAcute]e par NIST en fonction de \[Rho] (g/\!\(\*SuperscriptBox[\(cm\), \(3\)]\))";
PRhoSatNIST::argx="La fonction contient comme seul argument la densit\[EAcute] \[Rho] en g/\!\(\*SuperscriptBox[\(cm\), \(3\)]\) o\[UGrave] \[Rho]trgaz \[LessEqual] \[Rho] \[LessEqual] \[Rho]trliq";
PTSatNIST::usage="Fonction permettant de d\[EAcute]terminer la pression (bar) sur la courbe de saturation donn\[EAcute]e par NIST en fonction de \!\(\*
StyleBox[\"T\",\nFontSlant->\"Italic\"]\) (K)";

CVAdimNv::usage=ToString[DisplayForm["Fonction permettant de calculer la capacit\[EAcute] calorifique isochore adimensionnelle \!\(\*
StyleBox[SubscriptBox[\"C\", \"V\"],\nFontSlant->\"Italic\"]\)/\!\(\*
StyleBox[\"R\",\nFontSlant->\"Italic\"]\) versus \!\(\*
StyleBox[\"T\",\nFontSlant->\"Italic\"]\) (K) et \[Rho] (g/\!\(\*SuperscriptBox[\(cm\), \(3\)]\))"], StandardForm];
CVAdimNv::argx="La fonction contient deux arguments: respectivement, la temp\[EAcute]rature \!\(\*
StyleBox[\"T\",\nFontSlant->\"Italic\"]\) en K o\[UGrave] \!\(\*
StyleBox[\"T\",\nFontSlant->\"Italic\"]\) \[GreaterEqual] 0 et la la densit\[EAcute] \[Rho] en g/\!\(\*SuperscriptBox[\(cm\), \(3\)]\) o\[UGrave] \[Rho] \[GreaterEqual] 0";
UtotalAdimNv::usage="Fonction permettant de calculer l'\[EAcute]nergie interne adimensionnelle \!\(\*
StyleBox[\"U\",\nFontSlant->\"Italic\"]\)/\!\(\*
StyleBox[\"RT\",\nFontSlant->\"Italic\"]\) en fonction de \!\(\*
StyleBox[\"T\",\nFontSlant->\"Italic\"]\) (K) et de \[Rho] (g/\!\(\*SuperscriptBox[\(cm\), \(3\)]\))";
UtotalAdimNv::argx="La fonction contient deux arguments: respectivement, la temp\[EAcute]rature \!\(\*
StyleBox[\"T\",\nFontSlant->\"Italic\"]\) en K o\[UGrave] \!\(\*
StyleBox[\"T\",\nFontSlant->\"Italic\"]\) > 0 et la la densit\[EAcute] \[Rho] en g/\!\(\*SuperscriptBox[\(cm\), \(3\)]\) o\[UGrave] \[Rho] \[GreaterEqual] 0";
StotalAdimNv::usage="Fonction permettant de calculer l'entropie adimensionnelle \!\(\*
StyleBox[\"S\",\nFontSlant->\"Italic\"]\)/\!\(\*
StyleBox[\"R\",\nFontSlant->\"Italic\"]\) versus \!\(\*
StyleBox[\"T\",\nFontSlant->\"Italic\"]\) (K) et \[Rho] (g/\!\(\*SuperscriptBox[\(cm\), \(3\)]\))";
FtotalAdimNv::usage="Fonction permettant de calculer l'\[EAcute]nergie libre adimensionnelle \!\(\*
StyleBox[\"a\",\nFontSlant->\"Italic\"]\)=\!\(\*
StyleBox[\"F\",\nFontSlant->\"Italic\"]\)/\!\(\*
StyleBox[\"RT\",\nFontSlant->\"Italic\"]\) versus \!\(\*
StyleBox[\"T\",\nFontSlant->\"Italic\"]\) (K) et \[Rho] (g/\!\(\*SuperscriptBox[\(cm\), \(3\)]\))";
dFtotalAdimNvdT::usage=ToString[DisplayForm["D\[EAcute]riv\[EAcute]e partielle premi\[EGrave]re par rapport \[AGrave] T de l'\[EAcute]nergie libre adimensionnelle a=\!\(\*FormBox[FractionBox[\(F\), \(RT\)],
TraditionalForm]\) (\!\(\*SuperscriptBox[\(K\), \(-1\)]\)): \!\(\*FormBox[SubscriptBox[\((\*FractionBox[\(\[PartialD]a\), \(\[PartialD]T\)])\), \(V\)],
TraditionalForm]\)=-\!\(\*FormBox[FractionBox[\(1\), \(T\)],
TraditionalForm]\)(\!\(\*FormBox[FractionBox[\(S\), \(R\)],
TraditionalForm]\)+\!\(\*FormBox[FractionBox[\(F\), \(RT\)],
TraditionalForm]\))"], StandardForm];
d2FtotalAdimNvdT2::usage="D\[EAcute]riv\[EAcute]e partielle seconde par rapport \[AGrave] \!\(\*
StyleBox[\"T\",\nFontSlant->\"Italic\"]\) de l'\[EAcute]nergie libre adimensionnelle \!\(\*
StyleBox[\"a\",\nFontSlant->\"Italic\"]\)=\!\(\*FormBox[FractionBox[\(\!\(\*
StyleBox[\"F\",\nFontSlant->\"Italic\"]\)\), \(\!\(\*
StyleBox[\"RT\",\nFontSlant->\"Italic\"]\)\)],
TraditionalForm]\) : (\!\(\*FractionBox[\(\*SuperscriptBox[\(\[PartialD]\), \(2\)]\*
StyleBox[\"a\",\nFontSlant->\"Italic\"]\), \(\[PartialD]\*SuperscriptBox[
StyleBox[\"T\",\nFontSlant->\"Italic\"], \"2\"]\)]\)\!\(\*SubscriptBox[\()\), 
StyleBox[\"V\",\nFontSlant->\"Italic\"]]\) = \!\(\*FractionBox[\(1\), 
StyleBox[SuperscriptBox[
StyleBox[\"T\",\nFontSlant->\"Italic\"], \"2\"],\nFontSlant->\"Italic\"]]\)(2\!\(\*FractionBox[
StyleBox[\"U\",\nFontSlant->\"Italic\"], 
StyleBox[\"RT\",\nFontSlant->\"Italic\"]]\)-\!\(\*FractionBox[
StyleBox[SubscriptBox[\"C\", \"V\"],\nFontSlant->\"Italic\"], 
StyleBox[\"R\",\nFontSlant->\"Italic\"]]\)) (\!\(\*SuperscriptBox[\(K\), \(-2\)]\))";
ZtotalNv::usage="Fonction permettant de calculer le facteur de compressibilit\[EAcute] \!\(\*
StyleBox[\"Z\",\nFontSlant->\"Italic\"]\)=\!\(\*
StyleBox[\"PV\",\nFontSlant->\"Italic\"]\)/\!\(\*
StyleBox[\"RT\",\nFontSlant->\"Italic\"]\) versus \!\(\*
StyleBox[\"T\",\nFontSlant->\"Italic\"]\) (K) et \[Rho] (g/\!\(\*SuperscriptBox[\(cm\), \(3\)]\))";
RhoArgonNv::usage="Fonction permettant de calculer la densit\[EAcute] \[Rho] (g/\!\(\*SuperscriptBox[\(cm\), \(3\)]\)) versus \!\(\*
StyleBox[\"T\",\nFontSlant->\"Italic\"]\) (K) et \!\(\*
StyleBox[\"P\",\nFontSlant->\"Italic\"]\) (bar)";
PArgonNv::usage="Fonction permettant de calculer la pression \!\(\*
StyleBox[\"P\",\nFontSlant->\"Italic\"]\) (bar) versus \!\(\*
StyleBox[\"T\",\nFontSlant->\"Italic\"]\) (K) et \[Rho] (g/\!\(\*SuperscriptBox[\(cm\), \(3\)]\))";
PFusionArgon::usage="Fonction permettant de calculer la pression \*
StyleBox[\(\!\(\*
StyleBox[\"P\",\nFontSlant->\"Italic\"]\)\!\(\*
StyleBox[\"m\",\nFontSlant->\"Plain\"]\)\)] (MPa) sur la ligne de fusion en fonction de \!\(\*
StyleBox[\"T\",\nFontSlant->\"Italic\"]\) (K)";
dZtotalNvdT::usage="D\[EAcute]riv\[EAcute]e partielle premi\[EGrave]re par rapport \[AGrave] \!\(\*
StyleBox[\"T\",\nFontSlant->\"Italic\"]\) de \!\(\*
StyleBox[\"Z\",\nFontSlant->\"Italic\"]\) (\!\(\*SuperscriptBox[\(K\), \(-1\)]\))";
dZtotalNv::usage="D\[EAcute]riv\[EAcute]e partielle premi\[EGrave]re par rapport \[AGrave] \[Rho] de \!\(\*
StyleBox[\"Z\",\nFontSlant->\"Italic\"]\) (\!\(\*SuperscriptBox[\(cm\), \(3\)]\)/g)";
dPArgonNvdT::usage="D\[EAcute]riv\[EAcute]e partielle premi\[EGrave]re de la pression \!\(\*
StyleBox[\"P\",\nFontSlant->\"Italic\"]\) par rapport \[AGrave] \!\(\*
StyleBox[\"T\",\nFontSlant->\"Italic\"]\): (\!\(\*FractionBox[\(\[PartialD]\!\(\*
StyleBox[\"P\",\nFontSlant->\"Italic\"]\)\), \(\[PartialD]\!\(\*
StyleBox[\"T\",\nFontSlant->\"Italic\"]\)\)]\)\!\(\*SubscriptBox[\()\), \(\[Rho]\)]\) (bar/K)";
dPArgonNvdRho::usage="D\[EAcute]riv\[EAcute]e partielle premi\[EGrave]re de la pression \!\(\*
StyleBox[\"P\",\nFontSlant->\"Italic\"]\) par rapport \[AGrave] \[Rho]: (\!\(\*FractionBox[\(\[PartialD]\!\(\*
StyleBox[\"P\",\nFontSlant->\"Italic\"]\)\), \(\[PartialD]\[Rho]\)]\)\!\(\*SubscriptBox[\()\), \(T\)]\) (J/g)";
HtotalAdimNv::usage="Fonction permettant de calculer l'enthalpie adimensionnelle \!\(\*
StyleBox[\"H\",\nFontSlant->\"Italic\"]\)/\!\(\*
StyleBox[\"RT\",\nFontSlant->\"Italic\"]\) versus \!\(\*
StyleBox[\"T\",\nFontSlant->\"Italic\"]\) (K) et \[Rho] (g/\!\(\*SuperscriptBox[\(cm\), \(3\)]\))";
CompressibiliteKTNv::usage="Fonction permettant de calculer le coefficient de compressibilit\[EAcute] isotherme \!\(\*SubscriptBox[\(K\), \(T\)]\)=-\!\(\*FractionBox[\(1\), \(\!\(\*
StyleBox[\"V\",\nFontSlant->\"Italic\"]\)\)]\)(\!\(\*FractionBox[\(\[PartialD]\!\(\*
StyleBox[\"V\",\nFontSlant->\"Italic\"]\)\), \(\[PartialD]\!\(\*
StyleBox[\"P\",\nFontSlant->\"Italic\"]\)\)]\)\!\(\*SubscriptBox[\()\), \(\!\(\*
StyleBox[\"T\",\nFontSlant->\"Italic\"]\)\)]\) (\!\(\*SuperscriptBox[\(bar\), \(-1\)]\)) versus \!\(\*
StyleBox[\"T\",\nFontSlant->\"Italic\"]\) (K) et \[Rho] (g/\!\(\*SuperscriptBox[\(cm\), \(3\)]\))";
CompressibiliteKSNv::usage="Fonction permettant de calculer le coefficient de compressibilit\[EAcute] adiabatique \!\(\*SubscriptBox[\(K\), \(S\)]\) (\!\(\*SuperscriptBox[\(bar\), \(-1\)]\)) versus \!\(\*
StyleBox[\"T\",\nFontSlant->\"Italic\"]\) (K) et \[Rho] (g/\!\(\*SuperscriptBox[\(cm\), \(3\)]\))";
CpAdimNv::usage="Fonction permettant de calculer la capacit\[EAcute] calorifique isobare adimensionnelle \!\(\*
StyleBox[SubscriptBox[\"C\", \"P\"],\nFontSlant->\"Italic\"]\)/\!\(\*
StyleBox[\"R\",\nFontSlant->\"Italic\"]\) versus \!\(\*
StyleBox[\"T\",\nFontSlant->\"Italic\"]\) (K) et \[Rho] (g/\!\(\*SuperscriptBox[\(cm\), \(3\)]\))";
CeleriteSonNv::usage="Fonction permettant de calculer la c\[EAcute]l\[EAcute]rit\[EAcute] du son \!\(\*
StyleBox[\"c\",\nFontSlant->\"Italic\"]\) versus \!\(\*
StyleBox[\"T\",\nFontSlant->\"Italic\"]\) (K) et \[Rho] (g/\!\(\*SuperscriptBox[\(cm\), \(3\)]\))";
CoefDilatationThermiqueNv::usage="Fonction permettant de calculer le coefficient de dilatation thermique isobare \[Beta]=\!\(\*FractionBox[\(1\), \(\!\(\*
StyleBox[\"V\",\nFontSlant->\"Italic\"]\)\)]\)(\!\(\*FractionBox[\(\[PartialD]\!\(\*
StyleBox[\"V\",\nFontSlant->\"Italic\"]\)\), \(\[PartialD]\!\(\*
StyleBox[\"T\",\nFontSlant->\"Italic\"]\)\)]\)\!\(\*SubscriptBox[\()\), \(P\)]\) versus \!\(\*
StyleBox[\"T\",\nFontSlant->\"Italic\"]\) (K) et \[Rho] (g/\!\(\*SuperscriptBox[\(cm\), \(3\)]\))";
CoefExpansionAdimNv::usage="D\[EAcute]riv\[EAcute]e partielle premi\[EGrave]re adimensionnelle de l'enthalpie par rapport \[AGrave] P en fonction de \!\(\*
StyleBox[\"T\",\nFontSlant->\"Italic\"]\) (K) et de \[Rho] (g/\!\(\*SuperscriptBox[\(cm\), \(3\)]\)) : \!\(\*SubscriptBox[\(\[Delta]\), \(T\)]\) = (\!\(\*FractionBox[\(\[PartialD]\*
StyleBox[\"H\",\nFontSlant->\"Italic\"]\), \(\[PartialD]\*
StyleBox[\"P\",\nFontSlant->\"Italic\"]\)]\)\!\(\*SubscriptBox[\()\), 
StyleBox[\"T\",\nFontSlant->\"Italic\"]]\) = V(1-T\[Beta])";
CoefJouleThomsonAdimNv::usage="Coefficient de Joule-Thomson adimensionnel en fonction de \!\(\*
StyleBox[\"T\",\nFontSlant->\"Italic\"]\) (K) et de \[Rho] (g/\!\(\*SuperscriptBox[\(cm\), \(3\)]\)) : \[Mu] = (\!\(\*FractionBox[\(\[PartialD]\*
StyleBox[\"T\",\nFontSlant->\"Italic\"]\), \(\[PartialD]\*
StyleBox[\"P\",\nFontSlant->\"Italic\"]\)]\)\!\(\*SubscriptBox[\()\), \(H\)]\) = -\!\(\*FractionBox[\(1\), 
StyleBox[SubscriptBox[\"C\", \"P\"],\nFontSlant->\"Italic\"]]\)(\!\(\*FractionBox[\(\[PartialD]\*
StyleBox[\"H\",\nFontSlant->\"Italic\"]\), \(\[PartialD]\*
StyleBox[\"P\",\nFontSlant->\"Italic\"]\)]\)\!\(\*SubscriptBox[\()\), 
StyleBox[\"T\",\nFontSlant->\"Italic\"]]\)";

PTSat::usage="Fonction permettant de d\[EAcute]terminer la pression \!\(\*SubscriptBox[\(\!\(\*
StyleBox[\"P\",\nFontSlant->\"Italic\"]\)\), \(\[Sigma]\)]\) (MPa) sur la courbe de saturation en fonction de \!\(\*
StyleBox[\"T\",\nFontSlant->\"Italic\"]\) (K)";
PRhoSat::usage="Fonction permettant de d\[EAcute]terminer la Pression \!\(\*SubscriptBox[\(\!\(\*
StyleBox[\"P\",\nFontSlant->\"Italic\"]\)\), \(\[Sigma]\)]\) (MPa) sur la courbe de saturation en fonction de \[Rho] (g/\!\(\*SuperscriptBox[\(cm\), \(3\)]\))";
PRhoSat::argx="La fonction contient comme seul argument la densit\[EAcute] \[Rho] en g/\!\(\*SuperscriptBox[\(cm\), \(3\)]\) o\[UGrave] \[Rho]trgaz \[LessEqual] \[Rho] \[LessEqual] \[Rho]trliq";
TRhoSsat::usage="Fonction permettant de d\[EAcute]terminer Temp\[EAcute]rature \!\(\*SubscriptBox[\(\!\(\*
StyleBox[\"T\",\nFontSlant->\"Italic\"]\)\), \(\[Sigma]\)]\) (K) sur la courbe de saturation en fonction de \[Rho] (g/\!\(\*SuperscriptBox[\(cm\), \(3\)]\))";
TRhoSat::argx="La fonction contient comme seul argument la densit\[EAcute] \[Rho] en g/\!\(\*SuperscriptBox[\(cm\), \(3\)]\) o\[UGrave] \[Rho]trgaz \[LessEqual] \[Rho] \[LessEqual] \[Rho]trliq";
RhoSatLiqFromT::usage="Fonction permettant de d\[EAcute]terminer la densit\[EAcute] du liquide (g/\!\(\*SuperscriptBox[\(cm\), \(3\)]\)) sur la courbe de saturation en fonction de \!\(\*
StyleBox[\"T\",\nFontSlant->\"Italic\"]\) (K)";
RhoSatLiqFromT::argx="La fonction contient comme seul argument la temp\[EAcute]rature \!\(\*
StyleBox[\"T\",\nFontSlant->\"Italic\"]\) en K o\[UGrave] ttr \[LessEqual] \!\(\*
StyleBox[\"T\",\nFontSlant->\"Italic\"]\) \[LessEqual] tcNv";
RhoSatVapFromT::usage="Fonction permettant de d\[EAcute]terminer la densit\[EAcute] du gaz (g/\!\(\*SuperscriptBox[\(cm\), \(3\)]\)) sur la courbe de saturation en fonction de \!\(\*
StyleBox[\"T\",\nFontSlant->\"Italic\"]\) (K)";
RhoSatVapFromT::argx="La fonction contient comme seul argument la temp\[EAcute]rature \!\(\*
StyleBox[\"T\",\nFontSlant->\"Italic\"]\) en K o\[UGrave] ttr \[LessEqual] \!\(\*
StyleBox[\"T\",\nFontSlant->\"Italic\"]\) \[LessEqual] tcNv";
LvapAdimNv::usage="Fonction permettant de calculer la chaleur latente de vaporisation adimensionnelle Lv = \*
StyleBox[\(\[CapitalDelta]\!\(\*
StyleBox[\"H\",\nFontSlant->\"Italic\"]\)\)]/\!\(\*
StyleBox[\"RT\",\nFontSlant->\"Italic\"]\) en fonction de \!\(\*
StyleBox[\"T\",\nFontSlant->\"Italic\"]\) (K)";
LvapAdimNv::argx="La fonction contient comme seul argument la temp\[EAcute]rature \!\(\*
StyleBox[\"T\",\nFontSlant->\"Italic\"]\) en K o\[UGrave] ttr \[LessEqual] \!\(\*
StyleBox[\"T\",\nFontSlant->\"Italic\"]\) \[LessEqual] tcNv";


(*******************************)
Begin["`Private`"]
(*******************************)
Off[General::unfl];
Off[NIntegrate::inumr];
Off[General::stop];
Off[General::munfl];


(****************  NewEoSArgonFunctions **********************************)
SetAttributes[NewEoSArgonFunctions,HoldAll];
NewEoSArgonFunctions[a_String]:=ToExpression[StringJoin["?NewEoSArgon`",a]];
NewEoSArgonFunctions[a_]:=ToExpression[
  StringJoin["?NewEoSArgon`",StringDrop[StringDrop[ToString[Hold[a]],5],-1],"*"]
			];
NewEoSArgonFunctions[]:=ToExpression["?NewEoSArgon`*"];


(* ::Subtitle:: *)
(*Constantes du mod\[EGrave]le:*)


SetAttributes[{RR,M,fmol,Na,vtrliq,\[Rho]trliq,rhotrliq,vtrgaz,\[Rho]trgaz,rhotrgaz,ttr,ptr,tc,vc,rhoc,\[Rho]c,pc,zc},Constant];

RR=8.31451;(*Joule/mole/K*)
M=39.948;(*g/mole*)
fmol=10^20;
Na=6.02214179*10^23; (*nombre d'Avogadro/mole*)

vtrliq=28.1959; (*cm^3/mole*)
\[Rho]trliq=M/vtrliq;
rhotrliq=\[Rho]trliq;
vtrgaz=9852.51318; (*cm^3/mole*)
\[Rho]trgaz=M/vtrgaz;
rhotrgaz=\[Rho]trgaz;
(*temp\[EAcute]rature triple liquide et gaz d'apr\[EGrave]s NIST*)
ttr=83.8058; (*K temp\[EAcute]rature triple*)
ptr=0.68891; (*bar*)
tc=150.687;(*K NIST*)
vc=74.5857;(*cm^3/mole*)
rhoc=0.535599;(*g/cm^3*)
\[Rho]c=rhoc;
pc=48.630;(*bar*)
zc=0.289501;

(**********************************************************************************)
SetAttributes[{\[Alpha]4a,\[Epsilon]4a1,\[Epsilon]4a2,\[Alpha]4b,\[Epsilon]4b1,\[Epsilon]4b2},Constant];
\[Alpha]4a=102.06515;\[Epsilon]4a1=0.9218165;\[Epsilon]4a2=1.1328347;
\[Alpha]4b=120.40518;\[Epsilon]4b1=0.12035802;\[Epsilon]4b2=4.424004;

SetAttributes[{\[Alpha]Nonreg1,\[Epsilon]6a,\[Epsilon]6b,\[Alpha]Nonreg2,\[Epsilon]6c,\[Epsilon]6d},Constant];
\[Alpha]Nonreg1=0.089409;\[Epsilon]6a=0.71915;\[Epsilon]6b=0.22569;
\[Alpha]Nonreg2=0.015481;\[Epsilon]6c=1.3401;\[Epsilon]6d=0.29485;

SetAttributes[{\[Alpha]7a,\[Epsilon]7a1,\[Epsilon]7a2,\[Alpha]7b,\[Epsilon]7b,V7R,\[Rho]7R,\[Epsilon]7R,\[Alpha]Reg1},Constant];
\[Alpha]7a=0.0161233845;
\[Epsilon]7a1=0.23513928;(*=Subscript[\[Epsilon], reg,1b]*)
\[Epsilon]7a2=1.1178177;(*=Subscript[\[Epsilon], reg,1a]*)
\[Alpha]7b=0.53278931;
\[Epsilon]7b=2.9322362;(*=Subscript[\[Epsilon], reg,2a]*)
V7R=11.3116;(*cm^3/mole*)
\[Rho]7R=M/V7R;(*g/cm^3*)
\[Epsilon]7R=15.5957;(*=Subscript[\[Epsilon], reg,2b]*)
\[Alpha]Reg1=\[Alpha]7a*(\[Rho]trliq/\[Rho]trgaz)^\[Epsilon]7a2;

SetAttributes[{\[Alpha]8a,\[Alpha]8b,\[Alpha]8c,\[Epsilon]8c1,\[Epsilon]8c2,\[Alpha]8d,\[Epsilon]8d,V8R,\[Rho]8R,\[Epsilon]8R1,\[Epsilon]8R2},Constant];
\[Alpha]8a=0.07079238;(*=Subscript[\[Alpha], m,1]*)
\[Alpha]8b=-0.24008716;(*=Subscript[\[Alpha], m,4]*)
\[Alpha]8c=1.3019754;(*=Subscript[\[Alpha], m,3]*)
\[Epsilon]8c1=1.5;\[Epsilon]8c2=1;
\[Alpha]8d=0.33623345;(*=Subscript[\[Alpha], m,2]*)
\[Epsilon]8d=1.5;
V8R=10.8591;(*cm^3/mole*)
\[Rho]8R=M/V8R;(*g/cm^3*)
\[Epsilon]8R1=14.4899;
\[Epsilon]8R2=7.20862;

SetAttributes[{\[Alpha]1a,\[Rho]1a,\[Alpha]1b,\[Epsilon]1b,\[Rho]1b,\[Alpha]1c,\[Epsilon]1c,\[Rho]1c,\[Alpha]1d,\[Alpha]1e,\[Epsilon]1e,\[Alpha]1f,\[Alpha]1g,\[Epsilon]1g,\[Zeta]0},Constant];
\[Alpha]1a=71.08169282062299;
\[Rho]1a=6.611531073290496;
\[Alpha]1b=12.166714374200609;
\[Epsilon]1b=2.5779509039255792;
\[Rho]1b=3.999259751446566;
\[Alpha]1c=22.41395798599219;
\[Epsilon]1c=2.0191604181950775;
\[Rho]1c=3.9087064026467453;
\[Alpha]1d=16.869693253184483;(*=Subscript[\[Alpha], u,0]*)
\[Alpha]1e=0.13352634571030841;
\[Epsilon]1e=12.94678106481888;
\[Alpha]1f=16612.441986451926;
\[Alpha]1g=0.0485595044425591;
\[Epsilon]1g=1.7873862492067378;
\[Zeta]0=-0.87869/(RR*tc);

SetAttributes[{\[Alpha]2a,\[Epsilon]2a,\[Rho]2a,\[Alpha]2b,\[Epsilon]2b,\[Alpha]2c,\[Epsilon]2c,\[Alpha]2d,\[Epsilon]2d,\[Rho]2d,\[Alpha]2e,\[Epsilon]2e,\[Alpha]2f,\[Alpha]2g,\[Epsilon]2g,\[Alpha]2h,\[Rho]2h},Constant];
\[Alpha]2a=10.691987592443645;
\[Epsilon]2a=2.218112191389372;
\[Rho]2a=1.516484775521022;
\[Alpha]2b=7.287471074094199;
\[Epsilon]2b=3.3157894360022038;
\[Alpha]2c=9.010312944309103;
\[Epsilon]2c=2.653532486852318;
\[Alpha]2d=0.04408728124927161;
\[Epsilon]2d=1.5898489255468995;
\[Rho]2d=1.1822328984888224;
\[Alpha]2e=0.3461523990133497;
\[Epsilon]2e=21.402656629146545;
\[Alpha]2f=0.48552564826473027;
\[Alpha]2g=17.242306518582875*\[Rho]2cR1;(*=Subscript[\[Alpha], sRonc,1]*)
\[Epsilon]2g=62.54042041084944;
\[Alpha]2h=60.867828022789936*\[Rho]2cR1;(*=Subscript[\[Alpha], sRonc,2]*)
\[Rho]2h=4.286348978055625;

SetAttributes[{\[Rho]2cR1,\[Omega]0},Constant];
\[Rho]2cR1=M/12.146;
\[Omega]0=-5.1957/RR;

SetAttributes[\[Alpha]Tsmall,Constant];
\[Alpha]Tsmall=1;

SetAttributes[{\[Alpha]9a,\[Alpha]9b,\[Epsilon]9a,\[Epsilon]9b},Constant];
\[Alpha]9a=701.52;(*=Subscript[\[Alpha], crit,a]*)
\[Alpha]9b=4.27385;(*=Subscript[\[Alpha], crit,b]*)
\[Epsilon]9a=0.80803;(*=Subscript[\[Epsilon], crit,a]*)
\[Epsilon]9b=1.134;(*=Subscript[\[Epsilon], crit,b]*)

SetAttributes[{\[Epsilon]10a,\[Epsilon]10b,\[Epsilon]10c,\[Rho]10a,\[Epsilon]10d,\[Epsilon]10e,\[Rho]10b},Constant];
\[Epsilon]10a=1.436786;
\[Epsilon]10b=123.1335;
\[Epsilon]10c=2.205614;
\[Rho]10a=0.511824;
\[Epsilon]10d=26.32662;
\[Epsilon]10e=4.437711;
\[Rho]10b=0.7308586;

SetAttributes[{T0reg,\[Lambda],T0gp,\[Lambda]gp},Constant];
T0reg=22;
\[Lambda]=tc/T0reg;
T0gp=8.274;
\[Lambda]gp=tc/T0gp;

SetAttributes[{\[Rho]maxRonc,rhomaxRonc,tmaxRonc},Constant];
\[Rho]maxRonc=M/11.9;
rhomaxRonc=\[Rho]maxRonc;
tmaxRonc=2300;
(*********************************************************************)


(* ::Subtitle:: *)
(*Fonctions de \[Rho] du mod\[EGrave]les et leurs d\[EAcute]riv\[EAcute]es:*)


Attributes[Tdiv]={ReadProtected,NumericFunction};
Tdiv[\[Rho]_/;\[Rho]>=0]:= \[Alpha]4a* E^-(\[Rho]/\[Rho]c)^\[Epsilon]4a2 (\[Rho]/\[Rho]c)^\[Epsilon]4a1 +\[Alpha]4b E^-(\[Rho]/\[Rho]trliq)^\[Epsilon]4b2*(\[Rho]/\[Rho]trliq)^\[Epsilon]4b1;
nCrit[\[Rho]_]:=\[Alpha]9a*(\[Rho]/\[Rho]c)^\[Epsilon]9a*Exp[-((\[Alpha]9b*(\[Rho]-\[Rho]c)/\[Rho]c)^2)^\[Epsilon]9b];
\[Epsilon]Crit[\[Rho]_]:=\[Epsilon]10a+\[Epsilon]10b*Exp[-(\[Epsilon]10c*(\[Rho]-\[Rho]10a)/\[Rho]10a)^2]+\[Epsilon]10d*Exp[-(\[Epsilon]10e*(\[Rho]-\[Rho]10b)/\[Rho]10b)^2];(*250512*)
nNonregIn[\[Rho]_]:=\[Alpha]Nonreg1*(\[Rho]/\[Rho]trgaz)^\[Epsilon]6a E^(- (\[Rho]trliq/\[Rho]trgaz)^\[Epsilon]6b*(\[Rho]/(\[Rho]trliq-\[Rho]))^\[Epsilon]6b)+\[Alpha]Nonreg2*(\[Rho]/\[Rho]trgaz)^\[Epsilon]6c E^(- (\[Rho]trliq/\[Rho]trgaz)^\[Epsilon]6d*(\[Rho]/(\[Rho]trliq-\[Rho]))^\[Epsilon]6d);
nNonreg[\[Rho]_]:=Piecewise[{{nNonregIn[\[Rho]],\[Rho]<\[Rho]trliq}},0];
nReg[\[Rho]_]:=\[Alpha]Reg1* E^-(\[Rho]/\[Rho]trgaz)^\[Epsilon]7a1 (\[Rho]/(\[Rho]+\[Rho]trliq))^\[Epsilon]7a2+\[Alpha]7b*(\[Rho]/\[Rho]trliq)^\[Epsilon]7b*(1-If[\[Rho]>=\[Rho]trliq,E^-(\[Rho]/\[Rho]7R)^-\[Epsilon]7R,0]);
mRonc[\[Rho]_]:=Piecewise[{{0,M/12.9>\[Rho]}},(1+\[Rho]/\[Rho]8R)^\[Epsilon]8R1 (\[Alpha]8a+\[Alpha]8b*Log[(\[Rho]/\[Rho]c)])Exp[-Exp[(\[Rho]8R/\[Rho])^\[Epsilon]8R2]]];
m[\[Rho]_]:= -\[Alpha]8a+ \[Alpha]8d*E^-(\[Rho]/\[Rho]trliq)^\[Epsilon]8d+ \[Alpha]8c*(\[Rho]/\[Rho]c)^\[Epsilon]8c1 E^-(\[Rho]/\[Rho]c)^\[Epsilon]8c2-\[Alpha]8b* Log[\[Rho]/\[Rho]c]+mRonc[\[Rho]];
(*********************************************************************)
U0[\[Rho]_]:=\[Alpha]1d \[Rho]/\[Rho]trliq-\[Alpha]1a \[Rho]trliq/\[Rho]1a E^(-(\[Rho]1a/\[Rho]))+(\[Alpha]1b (\[Rho]/(-\[Rho]+\[Rho]1b))^(\[Epsilon]1b-1) (\[Rho]1b/\[Rho]trliq)^(\[Epsilon]1b-1))/(-1+\[Epsilon]1b)-(\[Alpha]1c (\[Rho]/(-\[Rho]+\[Rho]1c))^(\[Epsilon]1c-1) (\[Rho]1c/\[Rho]trliq)^(\[Epsilon]1c-1))/(-1+\[Epsilon]1c)-(\[Alpha]1e (\[Rho]/\[Rho]trliq)^(\[Epsilon]1e-1))/(-1+\[Epsilon]1e)+If[\[Rho]<\[Rho]trgaz/10,0,(\[Alpha]1f*\[Rho]^2)/(2 \[Rho]trliq^2) (E^(-(\[Rho]1a^2/\[Rho]^2)) -\[Rho]1a^2/\[Rho]^2 Gamma[0,\[Rho]1a^2/\[Rho]^2])]-(\[Alpha]1g (\[Rho]/(\[Rho]+\[Rho]c))^(-1+\[Epsilon]1g) \[Rho]trliq)/((-1+\[Epsilon]1g) \[Rho]c);(*100312*)
(*******************************************************************)
S0Num[\[Rho]_]:=-(\[Alpha]2h/\[Rho]2cR1)*NIntegrate[Exp[-(\[Rho]2h/u)]*(u/\[Rho]2cR1)*(1-Exp[-(u/\[Rho]c)^2]),{u,0,\[Rho]}];(*260312*)
S0nous[\[Rho]_]:=-((\[Alpha]2a (\[Rho]2a/(\[Rho]+\[Rho]2a))^(-1+\[Epsilon]2a) (\[Rho]/\[Rho]trliq)^(-1+\[Epsilon]2a))/(-1+\[Epsilon]2a))-(Sqrt[\[Pi]] \[Alpha]2f \[Rho]c Erf[(\[Rho]-\[Rho]2d)/\[Rho]c])/(2 \[Rho]trliq)+\[Alpha]2d (\[Rho]/\[Rho]trliq)^(-1+\[Epsilon]2d) ExpIntegralE[2-\[Epsilon]2d,\[Rho]/\[Rho]2d]+(\[Alpha]2e \[Rho] ExpIntegralE[(-1+\[Epsilon]2e)/\[Epsilon]2e,(\[Rho]/\[Rho]2a)^\[Epsilon]2e])/(\[Epsilon]2e \[Rho]trliq)-Log[\[Rho]/\[Rho]trliq]+(\[Alpha]2b (\[Rho]/\[Rho]trliq)^(-1+\[Epsilon]2b) (-1+(-1+\[Epsilon]2b) Log[\[Rho]/\[Rho]trliq]))/(-1+\[Epsilon]2b)^2-(\[Alpha]2c (\[Rho]/\[Rho]trliq)^(-1+\[Epsilon]2c) (-1+(-1+\[Epsilon]2c) Log[\[Rho]/\[Rho]trliq]))/(-1+\[Epsilon]2c)^2+(\[Alpha]2g (\[Rho]/\[Rho]2cR1)^(1+\[Epsilon]2g) (2+(1+\[Epsilon]2g) ExpIntegralE[1/2-\[Epsilon]2g/2,\[Rho]^2/\[Rho]c^2]))/(2 (1+\[Epsilon]2g))+If[\[Rho]<0.01,0,S0Num[\[Rho]]];(*260312*)
S0[\[Rho]_]:=S0nous[\[Rho]];
(*********************************************************************)
(*Temp\[EAcute]rature (K) sur la courbe de saturation; data donn\[EAcute]es par NIST*)
Attributes[TSatNIST]={ReadProtected,NumericFunction};
TSatNIST[\[Rho]_/;\[Rho]trgaz<=\[Rho]<=M/1190]:=ttr-9.2683981*Log[\[Rho]trgaz/\[Rho]]*(\[Rho]/\[Rho]trgaz)^0.1369143+0.18707819*(1-\[Rho]trgaz/\[Rho]);
TSatNIST[\[Rho]_/;M/1190<\[Rho]<=M/99.5]:=(0.2148293*tc)/(1+0.0354994*((Abs[\[Rho]c/\[Rho]-1])^1.084816-1))+10.87595*tc*Exp[(-(0.9369809*Abs[(1-\[Rho]/\[Rho]c)])^3.766441)]-10.09782*tc*Exp[(-(0.9508112*Abs[(1-\[Rho]/\[Rho]c)])^3.7897261)];
TSatNIST[\[Rho]_/;M/99.5<\[Rho]<=M/60]:=0.5*tc*((\[Rho]/\[Rho]c)^0.012513047+(\[Rho]c/\[Rho])^0.045357625-0.032446167*(\[Rho]c/\[Rho]-1))*Exp[-0.19008081*Abs[1-\[Rho]/\[Rho]c]^2.9266194];
TSatNIST[\[Rho]_/;M/60<\[Rho]<=M/33.4]:=(0.4877795*tc)/(1+81.67852*((\[Rho]/\[Rho]c)^0.1845557-1)^2.958731)+0.5122082*tc*Exp[-(0.5374175*Abs[1-\[Rho]/\[Rho]c])^3.682591];
TSatNIST[\[Rho]_/;M/33.4<\[Rho]<=\[Rho]trliq]:=ttr+22.664011*(\[Rho]/\[Rho]trliq)^1.0067955*vtrliq^1.0053041*(\[Rho]trliq/\[Rho]-1)^1.0053041*Exp[-(\[Rho]trliq/\[Rho])^0.75408469];

Attributes[RhoSatLiqNISTFromT]={ReadProtected,NumericFunction};
RhoSatLiqNISTFromT[T_/;ttr<=T<=tc]:=With[{sol=If[T<=90,FindRoot[TSatNIST[\[Rho]]-T==0,{\[Rho],\[Rho]c,\[Rho]trliq},Method->"Secant"],FindRoot[TSatNIST[\[Rho]]-T==0,{\[Rho],1.4}]]},
\[Rho]/.First@sol
];
RhoSatLiqNISTFromT[args___]:=(Message[RhoSatLiqNISTFromT::argx, Length[{args}]];$Failed);
Attributes[RhoSatVapNISTFromT]={ReadProtected,NumericFunction};
RhoSatVapNISTFromT[T_/;ttr<=T<=tc]:=With[{sol=If[T<=110,FindRoot[TSatNIST[\[Rho]]-T==0,{\[Rho],\[Rho]trgaz,\[Rho]c},Method->"Secant"],FindRoot[TSatNIST[\[Rho]]-T==0,{\[Rho],0.01}]]},
\[Rho]/.First@sol
];
RhoSatVapNISTFromT[args___]:=(Message[RhoSatVapNISTFromT::argx, Length[{args}]];$Failed);

(*Pression (bar) sur la courbe de saturation; repr\[EAcute]sentation ds data donn\[EAcute]es par NIST*)
Attributes[PRhoSatNIST]={ReadProtected,NumericFunction};
PRhoSatNIST[\[Rho]_/;M/29.17<\[Rho]<=\[Rho]trliq]:=ptr+1.72343*vtrliq^0.987436*(\[Rho]trliq/\[Rho]-1)^0.987436*Exp[-(\[Rho]/\[Rho]trliq)^11.2239];
PRhoSatNIST[\[Rho]_/;M/34<=\[Rho]<=M/29.17]:=0.800406+1.88925*(\[Rho]trliq/\[Rho])^5.95762*vtrliq^1.33543*(\[Rho]trliq/\[Rho]-1)^1.33543*Exp[-(\[Rho]trliq/\[Rho])^3.013872];
PRhoSatNIST[\[Rho]_/;M/58.8<=\[Rho]<=M/34]:=(1.78965*pc)/(1+0.366959*((\[Rho]/\[Rho]c)^1.09006-1)^2.57592)-0.787351*pc*Exp[-(0.5374175*Abs[1-\[Rho]/\[Rho]c])^7.79253];
PRhoSatNIST[\[Rho]_/;M/100.5<=\[Rho]<M/58.8]:=pc*((\[Rho]c/\[Rho])^0.103486-0.102209*(\[Rho]c/\[Rho]-1))*Exp[-1.09534*(Abs[1-\[Rho]/\[Rho]c])^2.91885];
PRhoSatNIST[\[Rho]_/;M/218<=\[Rho]<M/100.5]:=26.821916*pc* Exp[-(0.35105492*Abs[1-\[Rho]/\[Rho]c])^2.8625652]-25.821383*pc*Exp[-(0.27883138*Abs[1-\[Rho]/\[Rho]c])^3.5413443];
PRhoSatNIST[\[Rho]_/;M/500<=\[Rho]<M/218]:=21.846415*pc* Exp[-(0.54716493*Abs[1-\[Rho]/\[Rho]c])^3.0382885]-20.858694*pc*Exp[-(0.49454387*Abs[1-\[Rho]/\[Rho]c])^3.0982306];
PRhoSatNIST[\[Rho]_/;M/1900<=\[Rho]<M/500]:=19.984796*pc* Exp[-(0.31354057*Abs[1-\[Rho]/\[Rho]c])^2.4980423]-18.933882*pc*Exp[-(0.76957594*Abs[1-\[Rho]/\[Rho]c])^26.395107];
PRhoSatNIST[\[Rho]_/;\[Rho]trgaz<=\[Rho]<M/1900]:=ptr-0.630666*Log[\[Rho]trgaz/\[Rho]]*(\[Rho]/\[Rho]trgaz)^0.703584+0.131651*(1-\[Rho]trgaz/\[Rho]);
PRhoSatNIST[args___]:=(Message[PRhoSatNIST::argx, Length[{args}]];$Failed);
(* Pression de vapeur saturante en fonction de T en K: PsatNistdeT en bar *)
PsatNISTdeT[T_]=Interpolation[Table[{TSatNIST[\[Rho]trgaz+i*(\[Rho]c-\[Rho]trgaz)/100],PRhoSatNIST[\[Rho]trgaz+i*(\[Rho]c-\[Rho]trgaz)/100]},{i,0,100,1}],T];
Attributes[PTSatNIST]={ReadProtected,NumericFunction};
PTSatNIST[T_/;ttr<=T<=tc]:=PsatNISTdeT[T];
(*********************************************************************)


dTdiv[\[Rho]_]:= 1/\[Rho] (\[Alpha]4a*E^-(\[Rho]/\[Rho]c)^\[Epsilon]4a2 (\[Rho]/\[Rho]c)^\[Epsilon]4a1 (-\[Epsilon]4a2 (\[Rho]/\[Rho]c)^\[Epsilon]4a2+\[Epsilon]4a1 )+ \[Alpha]4b*E^-(\[Rho]/\[Rho]trliq)^\[Epsilon]4b2 (\[Rho]/\[Rho]trliq)^\[Epsilon]4b1 (-\[Epsilon]4b2 (\[Rho]/\[Rho]trliq)^\[Epsilon]4b2+\[Epsilon]4b1 ));
dnCrit[\[Rho]_]:=1/\[Rho] E^-((\[Alpha]9b^2 (\[Rho]-\[Rho]c)^2)/\[Rho]c^2)^\[Epsilon]9b \[Alpha]9a (\[Epsilon]9a -2 \[Epsilon]9b \[Rho] ((\[Alpha]9b^2) /\[Rho]c^2)^\[Epsilon]9b ((\[Rho]-\[Rho]c)^2)^(\[Epsilon]9b-1/2)*Sign[\[Rho]-\[Rho]c]) (\[Rho]/\[Rho]c)^\[Epsilon]9a;
d\[Epsilon]Crit[\[Rho]_]:=(2 E^(-((\[Epsilon]10c^2 (\[Rho]-\[Rho]10a)^2)/\[Rho]10a^2)) \[Epsilon]10b \[Epsilon]10c^2 (-\[Rho]+\[Rho]10a))/\[Rho]10a^2+(2 E^(-((\[Epsilon]10e^2 (\[Rho]-\[Rho]10b)^2)/\[Rho]10b^2)) \[Epsilon]10d \[Epsilon]10e^2 (-\[Rho]+\[Rho]10b))/\[Rho]10b^2;(*250512*)
dnNonregIn[\[Rho]_]:=1/\[Rho] (E^(-(\[Rho]trliq/\[Rho]trgaz)^\[Epsilon]6b (\[Rho]/(-\[Rho]+\[Rho]trliq))^\[Epsilon]6b) \[Alpha]Nonreg1 (\[Rho]/\[Rho]trgaz)^\[Epsilon]6a  \[Rho]trliq /\[Rho] (-\[Epsilon]6b (\[Rho]trliq/\[Rho]trgaz)^\[Epsilon]6b (\[Rho]/(\[Rho]trliq-\[Rho]))^(\[Epsilon]6b+1)+\[Epsilon]6a \[Rho]/\[Rho]trliq )+E^(-(\[Rho]trliq/\[Rho]trgaz)^\[Epsilon]6d (\[Rho]/(-\[Rho]+\[Rho]trliq))^\[Epsilon]6d) \[Alpha]Nonreg2 (\[Rho]/\[Rho]trgaz)^\[Epsilon]6c  \[Rho]trliq /\[Rho] (-\[Epsilon]6d (\[Rho]trliq/\[Rho]trgaz)^\[Epsilon]6d (\[Rho]/(\[Rho]trliq-\[Rho]))^(\[Epsilon]6d+1)+\[Epsilon]6c \[Rho]/\[Rho]trliq));
dnNonreg[\[Rho]_]:=Piecewise[{{dnNonregIn[\[Rho]],\[Rho]<\[Rho]trliq}},0];
dnReg[\[Rho]_]:=1/\[Rho] (-\[Alpha]7b*(\[Rho]/\[Rho]trliq)^\[Epsilon]7b (-\[Epsilon]7b(1-If[\[Rho]>=\[Rho]trliq,E^-(\[Rho]/\[Rho]7R)^-\[Epsilon]7R,0])+\[Epsilon]7R*Piecewise[{{E^-(\[Rho]/\[Rho]7R)^-\[Epsilon]7R,\[Rho]>=\[Rho]trliq}},0]*(\[Rho]/\[Rho]7R)^-\[Epsilon]7R)+\[Alpha]Reg1* E^-(\[Rho]/\[Rho]trgaz)^\[Epsilon]7a1 (\[Rho]/(\[Rho]+\[Rho]trliq))^\[Epsilon]7a2 (\[Epsilon]7a2  \[Rho]trliq/(\[Rho]+\[Rho]trliq)-\[Epsilon]7a1 (\[Rho]/\[Rho]trgaz)^\[Epsilon]7a1));
dmRonc[\[Rho]_]:=Piecewise[{{0,M/12.9>\[Rho]}},1/\[Rho]8R E^-E^(\[Rho]8R/\[Rho])^\[Epsilon]8R2 ((\[Rho]+\[Rho]8R)/\[Rho]8R)^(\[Epsilon]8R1-1) (\[Alpha]8a*\[Epsilon]8R1+\[Alpha]8b(1+ \[Rho]8R/\[Rho]+\[Epsilon]8R1 Log[\[Rho]/\[Rho]c])+E^(\[Rho]8R/\[Rho])^\[Epsilon]8R2 \[Epsilon]8R2 (\[Rho]8R/\[Rho])^\[Epsilon]8R2 ((\[Rho]+\[Rho]8R)/\[Rho]) (\[Alpha]8a+\[Alpha]8b Log[\[Rho]/\[Rho]c]))];
dm[\[Rho]_]:=-(1/\[Rho])(\[Alpha]8b+\[Alpha]8c*(-\[Epsilon]8c1+\[Epsilon]8c2 (\[Rho]/\[Rho]c)^\[Epsilon]8c2)*(\[Rho]/\[Rho]c)^\[Epsilon]8c1 E^-(\[Rho]/\[Rho]c)^\[Epsilon]8c2+\[Alpha]8d*\[Epsilon]8d*E^-(\[Rho]/\[Rho]trliq)^\[Epsilon]8d*(\[Rho]/\[Rho]trliq)^\[Epsilon]8d)+dmRonc[\[Rho]];
(*********************************************************************)
dU0[\[Rho]_]:=\[Alpha]1d/\[Rho]trliq-1/\[Rho] (\[Rho]trliq/\[Rho])(\[Alpha]1a*Exp[-(\[Rho]1a/\[Rho])]-\[Alpha]1b*(\[Rho]1b/\[Rho]trliq)^\[Epsilon]1b (\[Rho]/(\[Rho]1b-\[Rho]))^\[Epsilon]1b+\[Alpha]1c*(\[Rho]1c/\[Rho]trliq)^\[Epsilon]1c (\[Rho]/(\[Rho]1c-\[Rho]))^\[Epsilon]1c+\[Alpha]1e*(\[Rho]/\[Rho]trliq)^\[Epsilon]1e-If[\[Rho]<\[Rho]trgaz,0,\[Alpha]1f*(\[Rho]/\[Rho]trliq)^3 Exp[-(\[Rho]1a/\[Rho])^2]]+\[Alpha]1g*(\[Rho]/(\[Rho]+\[Rho]c))^\[Epsilon]1g);(*100312*)
(*********************************************************************)
dS0[\[Rho]_]:=-(1/\[Rho])(1+\[Alpha]2a*(\[Rho]/\[Rho]trliq)^(\[Epsilon]2a-1) (\[Rho]2a/(\[Rho]+\[Rho]2a))^\[Epsilon]2a-\[Alpha]2b*(\[Rho]/\[Rho]trliq)^(\[Epsilon]2b-1) Log[\[Rho]/\[Rho]trliq]+\[Alpha]2c*(\[Rho]/\[Rho]trliq)^(\[Epsilon]2c-1) Log[\[Rho]/\[Rho]trliq]+\[Alpha]2d*(\[Rho]/\[Rho]trliq)^(\[Epsilon]2d-1) Exp[-(\[Rho]/\[Rho]2d)]+\[Alpha]2e*(\[Rho]/\[Rho]trliq)Exp[-(\[Rho]/\[Rho]2a)^\[Epsilon]2e]+\[Alpha]2f*(\[Rho]/\[Rho]trliq)Exp[-((\[Rho]-\[Rho]2d)/\[Rho]c)^2])+1/\[Rho]2cR1 (\[Alpha]2g*(\[Rho]/\[Rho]2cR1)^\[Epsilon]2g-\[Alpha]2h*Exp[-(\[Rho]2h/\[Rho])]*(\[Rho]/\[Rho]2cR1))*(1-Exp[-(\[Rho]/\[Rho]c)^2]);(*260312*)
(*********************************************************************)


d2Tdiv[\[Rho]_]:=1/\[Rho]^2 (E^-(\[Rho]/\[Rho]c)^\[Epsilon]4a2 \[Alpha]4a (\[Rho]/\[Rho]c)^\[Epsilon]4a1 ((-1+\[Epsilon]4a1) \[Epsilon]4a1-\[Epsilon]4a2 (-1+2 \[Epsilon]4a1+\[Epsilon]4a2) (\[Rho]/\[Rho]c)^\[Epsilon]4a2+\[Epsilon]4a2^2 (\[Rho]/\[Rho]c)^(2 \[Epsilon]4a2)) +E^-(\[Rho]/\[Rho]trliq)^\[Epsilon]4b2 \[Alpha]4b (\[Rho]/\[Rho]trliq)^\[Epsilon]4b1 ((-1+\[Epsilon]4b1) \[Epsilon]4b1-\[Epsilon]4b2 (-1+2 \[Epsilon]4b1+\[Epsilon]4b2) (\[Rho]/\[Rho]trliq)^\[Epsilon]4b2+\[Epsilon]4b2^2 (\[Rho]/\[Rho]trliq)^(2 \[Epsilon]4b2)));
d2nCrit[\[Rho]_]:=1/(\[Rho]-\[Rho]c)^2 E^-((\[Alpha]9b^2 (\[Rho]-\[Rho]c)^2)/\[Rho]c^2)^\[Epsilon]9b \[Alpha]9a (\[Rho]/\[Rho]c)^\[Epsilon]9a ((-1+\[Epsilon]9a) \[Epsilon]9a  ((\[Rho]-\[Rho]c)^2)/\[Rho]^2+4 \[Epsilon]9b^2 ((\[Alpha]9b^2 (\[Rho]-\[Rho]c)^2)/\[Rho]c^2)^(2 \[Epsilon]9b)-2 \[Epsilon]9b ((\[Alpha]9b^2 (\[Rho]-\[Rho]c)^2)/\[Rho]c^2)^\[Epsilon]9b ((-1+2 \[Epsilon]9a+2 \[Epsilon]9b)-2 \[Epsilon]9a \[Rho]c/\[Rho]));
d2nCrit[\[Rho]_/;\[Rho]==\[Rho]c]:=\[Alpha]9a ((-1+\[Epsilon]9a) \[Epsilon]9a  1/\[Rho]c^2);
d2\[Epsilon]Crit[\[Rho]_]:=(2 E^(-((\[Epsilon]10c^2 (\[Rho]-\[Rho]10a)^2)/\[Rho]10a^2)) \[Epsilon]10b \[Epsilon]10c^2 (2 \[Epsilon]10c^2 (\[Rho]-\[Rho]10a)^2-\[Rho]10a^2))/\[Rho]10a^4+(2 E^(-((\[Epsilon]10e^2 (\[Rho]-\[Rho]10b)^2)/\[Rho]10b^2)) \[Epsilon]10d \[Epsilon]10e^2 (2 \[Epsilon]10e^2 (\[Rho]-\[Rho]10b)^2-\[Rho]10b^2))/\[Rho]10b^4; (*250512*)
d2nNonregIn[\[Rho]_]:=1/\[Rho]^2 \[Rho]trliq^2/(\[Rho]-\[Rho]trliq)^2 (E^(-(\[Rho]trliq/\[Rho]trgaz)^\[Epsilon]6b (\[Rho]/(-\[Rho]+\[Rho]trliq))^\[Epsilon]6b) \[Alpha]Nonreg1 (\[Rho]/\[Rho]trgaz)^\[Epsilon]6a ((-1+\[Epsilon]6a) \[Epsilon]6a (\[Rho]/\[Rho]trliq-1)^2+\[Epsilon]6b^2 (\[Rho]trliq/\[Rho]trgaz)^(2 \[Epsilon]6b) (\[Rho]/(-\[Rho]+\[Rho]trliq))^(2 \[Epsilon]6b)+\[Epsilon]6b (\[Rho]trliq/\[Rho]trgaz)^\[Epsilon]6b (\[Rho]/(-\[Rho]+\[Rho]trliq))^\[Epsilon]6b (2 (-1+\[Epsilon]6a) \[Rho]/\[Rho]trliq+1-(2 \[Epsilon]6a+\[Epsilon]6b)))+E^(-(\[Rho]trliq/\[Rho]trgaz)^\[Epsilon]6d (\[Rho]/(-\[Rho]+\[Rho]trliq))^\[Epsilon]6d) \[Alpha]Nonreg2 (\[Rho]/\[Rho]trgaz)^\[Epsilon]6c ((-1+\[Epsilon]6c) \[Epsilon]6c (\[Rho]/\[Rho]trliq-1)^2 +\[Epsilon]6d^2 (\[Rho]trliq/\[Rho]trgaz)^(2 \[Epsilon]6d) (\[Rho]/(-\[Rho]+\[Rho]trliq))^(2 \[Epsilon]6d)+\[Epsilon]6d (\[Rho]trliq/\[Rho]trgaz)^\[Epsilon]6d (\[Rho]/(-\[Rho]+\[Rho]trliq))^\[Epsilon]6d (2 (-1+\[Epsilon]6c) \[Rho]/\[Rho]trliq+1-(2 \[Epsilon]6c+\[Epsilon]6d))));
d2nNonreg[\[Rho]_]:=Piecewise[{{d2nNonregIn[\[Rho]],\[Rho]<\[Rho]trliq}},0];
d2nReg[\[Rho]_]:= 1/\[Rho]^2 (If[\[Rho]<\[Rho]trliq,0,E^-(\[Rho]/\[Rho]7R)^-\[Epsilon]7R \[Alpha]7b \[Epsilon]7R (\[Rho]/\[Rho]7R)^(-2 \[Epsilon]7R) (\[Rho]/\[Rho]trliq)^\[Epsilon]7b (-\[Epsilon]7R+(1-2 \[Epsilon]7b+\[Epsilon]7R) (\[Rho]/\[Rho]7R)^\[Epsilon]7R)]+\[Alpha]7b (-1+\[Epsilon]7b) \[Epsilon]7b (\[Rho]/\[Rho]trliq)^\[Epsilon]7b (1-If[\[Rho]<\[Rho]trliq,0,E^-(\[Rho]/\[Rho]7R)^-\[Epsilon]7R])+E^-(\[Rho]/\[Rho]trgaz)^\[Epsilon]7a1 \[Alpha]Reg1 (\[Rho]/(\[Rho]+\[Rho]trliq))^\[Epsilon]7a2 (\[Epsilon]7a1^2 (-1+(\[Rho]/\[Rho]trgaz)^\[Epsilon]7a1) (\[Rho]/\[Rho]trgaz)^\[Epsilon]7a1+\[Epsilon]7a2 (\[Rho]trliq/(\[Rho]+\[Rho]trliq))^2 (-2 \[Rho]/\[Rho]trliq+(-1+\[Epsilon]7a2))+\[Epsilon]7a1 (\[Rho]/\[Rho]trgaz)^\[Epsilon]7a1 (1-2 \[Epsilon]7a2 \[Rho]trliq/(\[Rho]+\[Rho]trliq))));
d2mRonc[\[Rho]_]:= Piecewise[{{0,M/12.9>\[Rho]}},1/\[Rho]^2 E^-E^(\[Rho]8R/\[Rho])^\[Epsilon]8R2 ((\[Rho]+\[Rho]8R)/\[Rho]8R)^\[Epsilon]8R1 (\[Alpha]8b (2 \[Epsilon]8R1 \[Rho]/(\[Rho]+\[Rho]8R)-1+2 E^(\[Rho]8R/\[Rho])^\[Epsilon]8R2 \[Epsilon]8R2 (\[Rho]8R/\[Rho])^\[Epsilon]8R2)+(\[Alpha]8a+\[Alpha]8b*Log[\[Rho]/\[Rho]c])((-1+\[Epsilon]8R1) \[Epsilon]8R1 (\[Rho]/(\[Rho]+\[Rho]8R))^2+E^(\[Rho]8R/\[Rho])^\[Epsilon]8R2 (-1+E^(\[Rho]8R/\[Rho])^\[Epsilon]8R2) \[Epsilon]8R2^2 (\[Rho]8R/\[Rho])^(2 \[Epsilon]8R2) -E^(\[Rho]8R/\[Rho])^\[Epsilon]8R2 \[Epsilon]8R2 (\[Rho]8R/\[Rho])^\[Epsilon]8R2 (-2 \[Epsilon]8R1 \[Rho]/(\[Rho]+\[Rho]8R)+\[Epsilon]8R2+1)))];
d2m[\[Rho]_]:=1/\[Rho]^2 (E^-(\[Rho]/\[Rho]c)^\[Epsilon]8c2 \[Alpha]8c (\[Rho]/\[Rho]c)^\[Epsilon]8c1 ((-1+\[Epsilon]8c1) \[Epsilon]8c1-\[Epsilon]8c2 (-1+2 \[Epsilon]8c1+\[Epsilon]8c2) (\[Rho]/\[Rho]c)^\[Epsilon]8c2+\[Epsilon]8c2^2 (\[Rho]/\[Rho]c)^(2 \[Epsilon]8c2))+\[Alpha]8b+\[Alpha]8d \[Epsilon]8d*E^-(\[Rho]/\[Rho]trliq)^\[Epsilon]8d (1+\[Epsilon]8d (-1+(\[Rho]/\[Rho]trliq)^\[Epsilon]8d)) (\[Rho]/\[Rho]trliq)^\[Epsilon]8d) +d2mRonc[\[Rho]];
(*********************************************************************)
d2U0[\[Rho]_]:= 1/\[Rho]^2 \[Rho]trliq/\[Rho] (E^(-(\[Rho]1a/\[Rho])) \[Alpha]1a (2-\[Rho]1a/\[Rho])+\[Alpha]1g (\[Rho]/(\[Rho]+\[Rho]c))^(\[Epsilon]1g+1) (2-(-2+\[Epsilon]1g) \[Rho]c/\[Rho])-\[Alpha]1e (-2+\[Epsilon]1e) (\[Rho]/\[Rho]trliq)^\[Epsilon]1e+\[Alpha]1b (\[Rho]/(-\[Rho]+\[Rho]1b))^(1+\[Epsilon]1b) (2+(-2+\[Epsilon]1b) \[Rho]1b/\[Rho]) (\[Rho]1b/\[Rho]trliq)^\[Epsilon]1b-\[Alpha]1c (\[Rho]/(-\[Rho]+\[Rho]1c))^(\[Epsilon]1c+1) (2+(-2+\[Epsilon]1c) \[Rho]1c/\[Rho]) (\[Rho]1c/\[Rho]trliq)^\[Epsilon]1c+If[\[Rho]<\[Rho]trgaz/10,0,(\[Rho]/\[Rho]trliq)^3 E^(-(\[Rho]1a^2/\[Rho]^2)) \[Alpha]1f (1+2 \[Rho]1a^2/\[Rho]^2)]);(*100312*)
d2S0[\[Rho]_]:=\!\(\*
TagBox[
RowBox[{
FractionBox["1", 
SuperscriptBox["\[Rho]2cR1", "2"]], "\[Alpha]2g", "*", "\[Epsilon]2g", 
RowBox[{"(", 
RowBox[{"1", "-", 
RowBox[{"Exp", "[", 
RowBox[{"-", 
SuperscriptBox[
RowBox[{"(", 
FractionBox["\[Rho]", "\[Rho]c"], ")"}], "2"]}], "]"}]}], ")"}], 
SuperscriptBox[
RowBox[{"(", 
FractionBox["\[Rho]", "\[Rho]2cR1"], ")"}], 
RowBox[{"\[Epsilon]2g", "-", "1"}]]}],
CheckAbort[#, Defer[#]]& ]\)+1/\[Rho]2cR1^2 E^(-(\[Rho]2h/\[Rho])-\[Rho]^2/\[Rho]c^2) \[Alpha]2h (-2 (\[Rho]/\[Rho]c)^2+1+\[Rho]2h/\[Rho]-(1+\[Rho]2h/\[Rho]) E^(\[Rho]^2/\[Rho]c^2))+2/\[Rho]c^2 (E^(-(\[Rho]^2/\[Rho]c^2)) \[Alpha]2g (\[Rho]/\[Rho]2cR1)^(\[Epsilon]2g+1)+(E^(-((\[Rho]-\[Rho]2d)^2/\[Rho]c^2)) \[Alpha]2f (\[Rho]-\[Rho]2d))/\[Rho]trliq)+1/\[Rho]^2 (1+(\[Alpha]2a \[Epsilon]2a (\[Rho]2a/(\[Rho]+\[Rho]2a))^(\[Epsilon]2a+1) (\[Rho]/\[Rho]trliq)^\[Epsilon]2a \[Rho]trliq)/\[Rho]2a+(E^(-(\[Rho]/\[Rho]2d)) \[Alpha]2d (\[Rho]/\[Rho]trliq)^\[Epsilon]2d \[Rho]trliq)/\[Rho]2d+\[Rho]/\[Rho]trliq E^-(\[Rho]/\[Rho]2a)^\[Epsilon]2e \[Alpha]2e \[Epsilon]2e (\[Rho]/\[Rho]2a)^\[Epsilon]2e-\[Rho]trliq/\[Rho] ((\[Alpha]2a (-2+\[Epsilon]2a) (\[Rho]2a/(\[Rho]+\[Rho]2a))^\[Epsilon]2a (\[Rho]/\[Rho]trliq)^\[Epsilon]2a-\[Alpha]2b (\[Rho]/\[Rho]trliq)^\[Epsilon]2b+\[Alpha]2c (\[Rho]/\[Rho]trliq)^\[Epsilon]2c)+\[Alpha]2d (-2+\[Epsilon]2d) E^(-(\[Rho]/\[Rho]2d)) (\[Rho]/\[Rho]trliq)^\[Epsilon]2d)+\[Rho]trliq/\[Rho] (\[Alpha]2b (-2+\[Epsilon]2b) (\[Rho]/\[Rho]trliq)^\[Epsilon]2b-\[Alpha]2c (-2+\[Epsilon]2c) (\[Rho]/\[Rho]trliq)^\[Epsilon]2c)Log[\[Rho]/\[Rho]trliq]);
(*********************************************************************)


(* ::Subtitle:: *)
(*Capacit\[EAcute] calorifique \[AGrave] volume constant Subscript[C, V](T,\[Rho]) sous forme adimensionnelle Subscript[c, V] = Subscript[C, V]/R:*)


CvgpAdim[T_]:=Switch[\[Alpha]Tsmall,0,3/2,_,3/2*(1-Exp[-((\[Lambda]gp*T)/tc)^\[Alpha]Tsmall])];
CvRegAdim[T_,\[Rho]_/;\[Rho]>0]:=If[T==0,0,Chop[Switch[\[Alpha]Tsmall,0,3/2*nReg[\[Rho]]*(T/tc)^(m[\[Rho]]-1),_,3/2*nReg[\[Rho]]*(1-Exp[-((\[Lambda]*T)/tc)^(\[Alpha]Tsmall+1-m[\[Rho]])])*(T/tc)^(m[\[Rho]]-1)]]];
CvRegAdim[T_,\[Rho]_/;\[Rho]==0]:=0;
(** Terme critique **)
CvCritAdim[T_,\[Rho]_/;\[Rho]>0]:=3/2*nCrit[\[Rho]]*Piecewise[{{(Tdiv[\[Rho]]/T) ^\[Epsilon]Crit[\[Rho]],T>=Tdiv[\[Rho]]}},(T/Tdiv[\[Rho]]) ^\[Epsilon]Crit[\[Rho]]];
CvCritAdim[T_,\[Rho]_/;\[Rho]==0]:=0;
(* Modif. pour faire converger Cv nonreg \[AGrave] T = Tdiv *)
Nv[\[Rho]_]:=fmol*Na*\[Rho]/\[Rho]c;
CvNonRegDNv[T_,\[Rho]_]:=3/2*nNonreg[\[Rho]]*Exp[-(T/Tdiv[\[Rho]])^((3/2))]*(1-Nv[\[Rho]]^-(1-Tdiv[\[Rho]]/T))/(1-Tdiv[\[Rho]]/T);
CvNonRegGNv[T_,\[Rho]_]:=3/2*nNonreg[\[Rho]]*Exp[-(T/Tdiv[\[Rho]])^(-(3/2))]*(1-Nv[\[Rho]]^-(1-(Tdiv[\[Rho]]/T)^-1))/(1-T/Tdiv[\[Rho]]);
CvNonRegNv[T_,\[Rho]_/;\[Rho]>0]:=If[T==0,Limit[CvNonRegGNv[x,\[Rho]],x->0],If[T>Tdiv[\[Rho]],CvNonRegDNv[T,\[Rho]],CvNonRegGNv[T,\[Rho]]]];
CvNonRegNv[T_,\[Rho]_/;\[Rho]==0]:=0;
(*** TOTAL ***)
CRhoAdimNv[T_,\[Rho]_]:=(CvgpAdim[T]+CvRegAdim[T,\[Rho]]+CvNonRegNv[T,\[Rho]]+CvCritAdim[T,\[Rho]]);
Attributes[CVAdimNv]={ReadProtected,NumericFunction};
CVAdimNv[T_/;T>=0,\[Rho]_/;\[Rho]>=0]:=CRhoAdimNv[T,\[Rho]];
CVAdimNv[args___]:=(Message[CVAdimNv::argx, Length[{args}]];$Failed);
(*********************************************************************)


(* ::Subtitle:: *)
(*Fonctions d'\[EAcute]tat U, S, F sous forme adimensionnelle: u = U/(RT), s = S/R et a = F/(RT)*)


UgpAdim[T_]:=If[T==0,Limit[3/2*(1+tc/(\[Lambda]gp*x) E^(-((x \[Lambda]gp)/tc)))+\[Zeta]0 tc/x,x->0],3/2*(1+tc/(\[Lambda]gp*T) E^(-((T \[Lambda]gp)/tc)))+\[Zeta]0 tc/T];
(** Termes critiques **)
UcritDroite[T_,\[Rho]_]:=(Tdiv[\[Rho]]/T)^\[Epsilon]Crit[\[Rho]]/(1-\[Epsilon]Crit[\[Rho]]);
UcritGauche[T_,\[Rho]_]:=(T/Tdiv[\[Rho]])^\[Epsilon]Crit[\[Rho]]/(1+\[Epsilon]Crit[\[Rho]]);
UcritAdim[T_,\[Rho]_/;\[Rho]>0]:=3/2*nCrit[\[Rho]]*Piecewise[{{UcritDroite[T,\[Rho]],T>=Tdiv[\[Rho]]}},(UcritGauche[T,\[Rho]]+(2*\[Epsilon]Crit[\[Rho]])/(1-\[Epsilon]Crit[\[Rho]]^2))];
UcritAdim[T_,\[Rho]_/;\[Rho]==0]:=0;
(** Termes r\[EAcute]guliers **)
UregAdim[T_,\[Rho]_/;\[Rho]>0]:=If[T==0,Limit[3/2*nReg[\[Rho]]*tc/x*(((x/tc)^m[\[Rho]]-1)/m[\[Rho]]+\[Lambda]^-m[\[Rho]]/(2-m[\[Rho]])*Gamma[m[\[Rho]]/(2-m[\[Rho]]),((x \[Lambda])/tc)^(2-m[\[Rho]])]),x->0],3/2*nReg[\[Rho]]*tc/T*(((T/tc)^m[\[Rho]]-1)/m[\[Rho]]+\[Lambda]^-m[\[Rho]]/(2-m[\[Rho]])*Gamma[m[\[Rho]]/(2-m[\[Rho]]),((T \[Lambda])/tc)^(2-m[\[Rho]])])];
UregAdim[T_,\[Rho]_/;\[Rho]==0]:=0;
U0Adim[T_,\[Rho]_/;\[Rho]>0]:=If[T==0,Limit[3/2*tc/x*U0[\[Rho]],x->0],3/2*tc/T*U0[\[Rho]]];
U0Adim[T_,\[Rho]_/;\[Rho]==0]:=0;
(*********************************************************************)
SgpAdim[T_]:=If[ T==0,Limit[3/2 (Log[x]-ExpIntegralEi[-((x \[Lambda]gp)/tc)])+Log[M/\[Rho]trliq]+\[Omega]0,x->0],3/2 (Log[T]-ExpIntegralEi[-((T \[Lambda]gp)/tc)])+Log[M/\[Rho]trliq]+\[Omega]0];
(** Termes critiques **)
ScritDroite[T_,\[Rho]_]:=-((Tdiv[\[Rho]]/T)^\[Epsilon]Crit[\[Rho]]/\[Epsilon]Crit[\[Rho]]);
ScritGauche[T_,\[Rho]_]:=(T/Tdiv[\[Rho]])^\[Epsilon]Crit[\[Rho]]/\[Epsilon]Crit[\[Rho]];
ScritAdim[T_,\[Rho]_/;\[Rho]>0]:=3/2*nCrit[\[Rho]]*Piecewise[{{ScritDroite[T,\[Rho]],T>=Tdiv[\[Rho]]}},(ScritGauche[T,\[Rho]]-2/\[Epsilon]Crit[\[Rho]])];
(** Termes r\[EAcute]guliers **)
SregAdim[T_,\[Rho]_/;\[Rho]>0]:=If[T==0,Limit[3/2*nReg[\[Rho]]*(((x/tc)^(m[\[Rho]]-1)-1)/(m[\[Rho]]-1)+\[Lambda]^(1-m[\[Rho]])/(2-m[\[Rho]]) Gamma[(m[\[Rho]]-1)/(2-m[\[Rho]]),((x \[Lambda])/tc)^(2-m[\[Rho]])]),x->0],3/2*nReg[\[Rho]]*(((T/tc)^(m[\[Rho]]-1)-1)/(m[\[Rho]]-1)+\[Lambda]^(1-m[\[Rho]])/(2-m[\[Rho]]) Gamma[(m[\[Rho]]-1)/(2-m[\[Rho]]),((T \[Lambda])/tc)^(2-m[\[Rho]])])];
SregAdim[T_,\[Rho]_/;\[Rho]==0]:=0;
S0Adim[T_,\[Rho]_/;\[Rho]>0]:=S0[\[Rho]];
S0Adim[T_,\[Rho]_/;\[Rho]==0]:=\[Infinity];
(*********************************************************************)
FgpAdim[T_]:=UgpAdim[T]-SgpAdim[T];
(** Termes critiques **)
FcritDroite[T_,\[Rho]_]:=UcritDroite[T,\[Rho]]-ScritDroite[T,\[Rho]];
FcritGauche[T_,\[Rho]_]:=-UcritGauche[T,\[Rho]]+ScritGauche[T,\[Rho]]+2/(1-\[Epsilon]Crit[\[Rho]]^2);
FcritAdim[T_,\[Rho]_]:=3/2*nCrit[\[Rho]]*Piecewise[{{FcritDroite[T,\[Rho]],T>=Tdiv[\[Rho]]},{FcritGauche[T,\[Rho]],T<Tdiv[\[Rho]]}}];
(** Termes r\[EAcute]guliers **)
FregAdim[T_,\[Rho]_]:=UregAdim[T,\[Rho]]-SregAdim[T,\[Rho]];
F0Adim[T_,\[Rho]_]:=U0Adim[T,\[Rho]]-S0Adim[T,\[Rho]];
(*********************************************************************************)
(* Int\[EAcute]gration num\[EAcute]rique du Cv nonreg *)
UnonregNv[T_,\[Rho]_/;\[Rho]>=0]:=1/T NIntegrate[(CvNonRegNv[u,\[Rho]]),{u,\[Infinity],T},AccuracyGoal->20];
Attributes[UtotalAdimNv]={ReadProtected,NumericFunction};
UtotalAdimNv[T_/;T>0,\[Rho]_/;\[Rho]>=0]:=Re[UgpAdim[T]+UregAdim[T,\[Rho]]+UnonregNv[T,\[Rho]]+UcritAdim[T,\[Rho]]+U0Adim[T,\[Rho]]];
SnonregNv[T_,\[Rho]_/;\[Rho]>=0]:=NIntegrate[(CvNonRegNv[u,\[Rho]]/u),{u,\[Infinity],T},AccuracyGoal->20];
Attributes[StotalAdimNv]={ReadProtected,NumericFunction};
StotalAdimNv[T_/;T>=0,\[Rho]_/;\[Rho]>=0]:=Re[SgpAdim[T]+SregAdim[T,\[Rho]]+SnonregNv[T,\[Rho]]+ScritAdim[T,\[Rho]]+S0Adim[T,\[Rho]]];
FnonregNv[T_,\[Rho]_]:=UnonregNv[T,\[Rho]]-SnonregNv[T,\[Rho]];
(*** TOTAL ***)
Attributes[FtotalAdimNv]={ReadProtected,NumericFunction};
FtotalAdimNv[T_/;T>0,\[Rho]_/;\[Rho]>=0]:=FgpAdim[T]+Re@FregAdim[T,\[Rho]]+FnonregNv[T,\[Rho]]+FcritAdim[T,\[Rho]]+F0Adim[T,\[Rho]];


(* ::Subtitle:: *)
(*D\[EAcute]riv\[EAcute]es partielles par rapport \[AGrave] T de l'\[EAcute]nergie libre F:*)


(* ::Subsubtitle:: *)
(*D\[EAcute]riv\[EAcute]e premi\[EGrave]re par rapport \[AGrave] T: Subscript[(\[PartialD]F/\[PartialD]T), V]= - S mais Subscript[(\[PartialD]a/\[PartialD]T), V]=-1/T(S/R+F/RT)=-1/T(U/RT) avec a=F/RT*)


dFgpAdimdT[T_]:=If[T==0,Limit[-(1/x)(3/2 (1+tc/(\[Lambda]gp*x) E^(-((x \[Lambda]gp)/tc)))+tc/x \[Zeta]0),x->0],-(1/T)(3/2 (1+tc/(\[Lambda]gp*T) E^(-((T \[Lambda]gp)/tc)))+tc/T \[Zeta]0)];
dF0AdimdT[T_,\[Rho]_]:=If[T==0,Limit[-(3/2) 1/x (tc U0[\[Rho]])/x,x->0],-(3/2) 1/T (tc U0[\[Rho]])/T];
dF0AdimdT[T_,\[Rho]_/;\[Rho]==0]:=Limit[-(3/2) 1/T (tc U0[x])/T,x->0];
(** Termes critiques **)
dFcritdroitedT[T_,\[Rho]_]:=-(1/(1-\[Epsilon]Crit[\[Rho]])) (Tdiv[\[Rho]]/T)^\[Epsilon]Crit[\[Rho]];
dFcritgauchedT[T_,\[Rho]_]:=1/(1+\[Epsilon]Crit[\[Rho]]) (T/Tdiv[\[Rho]])^\[Epsilon]Crit[\[Rho]];
dFCritAdimdT[T_,\[Rho]_]:=If[T==0,Limit[3/2*nCrit[\[Rho]]/x*dFcritgauchedT[x,\[Rho]],x->0],3/2*nCrit[\[Rho]]/T*Piecewise[{{dFcritdroitedT[T,\[Rho]],T>=Tdiv[\[Rho]]},{dFcritgauchedT[T,\[Rho]],T<Tdiv[\[Rho]]}}]];
(** Termes r\[EAcute]guliers pour \[Alpha]Tsmall=1 **)
dFRegAdimdT[T_,\[Rho]_]:=If[T==0,Limit[3/2 nReg[\[Rho]]/x tc/x 1/m[\[Rho]] (m[\[Rho]]/(m[\[Rho]]-2) \[Lambda]^-m[\[Rho]] Re@Gamma[m[\[Rho]]/(2-m[\[Rho]]),((x \[Lambda])/tc)^(2-m[\[Rho]])]+1-(x/tc)^m[\[Rho]]),x->0],3/2 nReg[\[Rho]]/T tc/T 1/m[\[Rho]] (m[\[Rho]]/(m[\[Rho]]-2) \[Lambda]^-m[\[Rho]] Re@Gamma[m[\[Rho]]/(2-m[\[Rho]]),((T \[Lambda])/tc)^(2-m[\[Rho]])]+1-(T/tc)^m[\[Rho]])];
dFRegAdimdT[T_,\[Rho]_/;\[Rho]==0]:=0;
(** Int\[EAcute]gration num\[EAcute]rique du terme non regulier **)
dFnonregNvdT[T_,\[Rho]_]:=-(1/T^2)NIntegrate[CvNonRegNv[u,\[Rho]],{u,\[Infinity],T},AccuracyGoal->20];
(*** TOTAL ***)
Attributes[dFtotalAdimNvdT]={ReadProtected,NumericFunction};
dFtotalAdimNvdT[T_/;T>0,\[Rho]_/;\[Rho]>=0]:=dFgpAdimdT[T]+dFRegAdimdT[T,\[Rho]]+dFnonregNvdT[T,\[Rho]]+dFCritAdimdT[T,\[Rho]]+dF0AdimdT[T,\[Rho]];
(****************************************************************************************************)


(* ::Subsubtitle:: *)
(*D\[EAcute]riv\[EAcute]e seconde par rapport \[AGrave] T :*)


d2FgpAdimdT2[T_]:=If[T==0,Limit[3/2 1/x^2 (1+4/3 tc/x \[Zeta]0)+3/2 1/x^2 (2 tc/(x \[Lambda]gp)+1)E^(-((x \[Lambda]gp)/tc)),x->0],3/2 1/T^2 (1+4/3 tc/T \[Zeta]0)+3/2 1/T^2 (2 tc/(T \[Lambda]gp)+1)E^(-((T \[Lambda]gp)/tc))];
d2F0AdimdT2[T_,\[Rho]_]:=If[T==0,Limit[(3 tc U0[\[Rho]])/x^3,x->0],(3 tc U0[\[Rho]])/T^3];
d2F0AdimdT2[T_,\[Rho]_/;\[Rho]==0]:=Limit[(3 tc U0[x])/T^3,x->0];
(** Termes critiques **)
d2FcritdroitedT2[T_,\[Rho]_]:=-((1+\[Epsilon]Crit[\[Rho]])/(-1+\[Epsilon]Crit[\[Rho]])) (Tdiv[\[Rho]]/T)^\[Epsilon]Crit[\[Rho]];
d2FcritgauchedT2[T_,\[Rho]_]:=(-1+\[Epsilon]Crit[\[Rho]])/(1+\[Epsilon]Crit[\[Rho]]) (T/Tdiv[\[Rho]])^\[Epsilon]Crit[\[Rho]];
d2FCritAdimdT2[T_,\[Rho]_]:=If[T==0,Limit[3/2*nCrit[\[Rho]]/x^2*d2FcritgauchedT2[x,\[Rho]],x->0],3/2*nCrit[\[Rho]]/T^2*Piecewise[{{d2FcritdroitedT2[T,\[Rho]],T>=Tdiv[\[Rho]]},{d2FcritgauchedT2[T,\[Rho]],T<Tdiv[\[Rho]]}}]];
(** Termes r\[EAcute]guliers pour \[Alpha]Tsmall=1 **)
d2FRegAdimdT2[T_,\[Rho]_]:=If[T==0,Limit[3/2 nReg[\[Rho]]/x^2 tc/x ( (x/tc)^m[\[Rho]] ((2-m[\[Rho]])/m[\[Rho]]+E^-((x \[Lambda])/tc)^(2-m[\[Rho]]))-2/m[\[Rho]]+(2 \[Lambda]^-m[\[Rho]])/(2-m[\[Rho]]) Re@Gamma[m[\[Rho]]/(2-m[\[Rho]]),((x \[Lambda])/tc)^(2-m[\[Rho]])]),x->0],3/2 nReg[\[Rho]]/T^2 tc/T ( (T/tc)^m[\[Rho]] ((2-m[\[Rho]])/m[\[Rho]]+E^-((T \[Lambda])/tc)^(2-m[\[Rho]]))-2/m[\[Rho]]+(2 \[Lambda]^-m[\[Rho]])/(2-m[\[Rho]]) Re@Gamma[m[\[Rho]]/(2-m[\[Rho]]),((T \[Lambda])/tc)^(2-m[\[Rho]])])];
d2FRegAdimdT2[T_,\[Rho]_/;\[Rho]==0]:=0;
(****************************************************************************************************)
(** Int\[EAcute]gration num\[EAcute]rique du terme non regulier **)
d2FnonregNvdT2[T_,\[Rho]_]:=If[T<10^-3,0,-(1/T^2)CvNonRegNv[T,\[Rho]]]+2/T^3 NIntegrate[CvNonRegNv[u,\[Rho]],{u,\[Infinity],T},AccuracyGoal->20];
(*** TOTAL ***)
Attributes[d2FtotalAdimNvdT2]={ReadProtected,NumericFunction};
d2FtotalAdimNvdT2[T_/;T>0,\[Rho]_/;\[Rho]>=0]:=d2FgpAdimdT2[T]+d2FRegAdimdT2[T,\[Rho]]+d2FnonregNvdT2[T,\[Rho]]+d2FCritAdimdT2[T,\[Rho]]+d2F0AdimdT2[T,\[Rho]];
(****************************************************************************************************)


(* ::Subtitle:: *)
(*Equation d'\[EAcute]tat Z(T,\[Rho]) = P/(\[Rho]RT):*)


(** Termes r\[EAcute]guliers **)
PUregAdim[T_,\[Rho]_]:=3/2*\[Rho]*dnReg[\[Rho]]*tc/T*(((T/tc)^m[\[Rho]]-1)/m[\[Rho]]+\[Lambda]^-m[\[Rho]]/(2-m[\[Rho]])*Re@Gamma[m[\[Rho]]/(2-m[\[Rho]]),((T \[Lambda])/tc)^(2-m[\[Rho]])])+3/2*nReg[\[Rho]]*tc/T*\[Rho]*dm[\[Rho]]*((1-(T/tc)^m[\[Rho]])/(m[\[Rho]])^2+((T/tc)^m[\[Rho]] Log[T/tc])/m[\[Rho]]+\[Lambda]^-m[\[Rho]]/(2-m[\[Rho]])^3 (E^-((T \[Lambda])/tc)^(2-m[\[Rho]]) ((T \[Lambda])/tc)^m[\[Rho]] Log[(T \[Lambda])/tc] (m[\[Rho]]-2)^2+2 Re@Gamma[m[\[Rho]]/(2-m[\[Rho]]),((T \[Lambda])/tc)^(2-m[\[Rho]])]*(Log[((T \[Lambda])/tc)^(2-m[\[Rho]])]+(1-1/2 m[\[Rho]]) (1-Log[\[Lambda]^(2-m[\[Rho]])]))+Piecewise[{{2*MeijerG[{{},{1,1}},{{0,0,m[\[Rho]]/(2-m[\[Rho]])},{}},((T \[Lambda])/tc)^(2-m[\[Rho]])],T<ttr}},0]));
PSregAdim[T_,\[Rho]_]:=3/2*\[Rho]*dnReg[\[Rho]]*(((T/tc)^(m[\[Rho]]-1)-1)/(m[\[Rho]]-1)+\[Lambda]^(1-m[\[Rho]])/(2-m[\[Rho]])*Re@Gamma[(m[\[Rho]]-1)/(2-m[\[Rho]]),((T \[Lambda])/tc)^(2-m[\[Rho]])])+3/2*nReg[\[Rho]]*\[Rho]*dm[\[Rho]]*((1-(T/tc)^(-1+m[\[Rho]]))/(m[\[Rho]]-1)^2+((T/tc)^(-1+m[\[Rho]]) Log[T/tc])/(m[\[Rho]]-1)+\[Lambda]^(1-m[\[Rho]])/(2-m[\[Rho]])^3*(E^-((T \[Lambda])/tc)^(2-m[\[Rho]]) ((T \[Lambda])/tc)^(m[\[Rho]]-1) Log[(T \[Lambda])/tc] (2-m[\[Rho]])^2+Re@Gamma[(m[\[Rho]]-1)/(2-m[\[Rho]]),((T \[Lambda])/tc)^(2-m[\[Rho]])](Log[((T \[Lambda])/tc)^(2-m[\[Rho]])]+(2-m[\[Rho]])*(1-Log[\[Lambda]^(2-m[\[Rho]])]))+Piecewise[{{MeijerG[{{},{1,1}},{{0,0,(m[\[Rho]]-1)/(2-m[\[Rho]])},{}},((T \[Lambda])/tc)^(2-m[\[Rho]])],T<ttr}},0]));
Zreg[T_,\[Rho]_/;\[Rho]>0]:=PUregAdim[T,\[Rho]]-PSregAdim[T,\[Rho]];
Zreg[T_,\[Rho]_/;\[Rho]==0]:=0;
Z0[T_,\[Rho]_/;\[Rho]>0]:=If[T==0,Limit[\[Rho](3/2*tc/x*dU0[\[Rho]]-dS0[\[Rho]]),x->0],\[Rho](3/2*tc/T*dU0[\[Rho]]-dS0[\[Rho]])];
Z0[T_,\[Rho]_/;\[Rho]==0]:=1;
(** Termes critiques **)
dFcritDroite[T_,\[Rho]_]:=(Tdiv[\[Rho]]/T)^\[Epsilon]Crit[\[Rho]] d\[Epsilon]Crit[\[Rho]] (-1+2 \[Epsilon]Crit[\[Rho]])/((-1+\[Epsilon]Crit[\[Rho]])^2 \[Epsilon]Crit[\[Rho]]^2)-(Tdiv[\[Rho]]/T)^\[Epsilon]Crit[\[Rho]] (dTdiv[\[Rho]]/Tdiv[\[Rho]]+Log[Tdiv[\[Rho]]/T] d\[Epsilon]Crit[\[Rho]]/\[Epsilon]Crit[\[Rho]]) 1/(-1+\[Epsilon]Crit[\[Rho]]);
dFcritGauche[T_,\[Rho]_]:=-(T/Tdiv[\[Rho]])^\[Epsilon]Crit[\[Rho]] d\[Epsilon]Crit[\[Rho]]/\[Epsilon]Crit[\[Rho]] (1+2*\[Epsilon]Crit[\[Rho]])/(\[Epsilon]Crit[\[Rho]](1+\[Epsilon]Crit[\[Rho]])^2)+(4 \[Epsilon]Crit[\[Rho]] d\[Epsilon]Crit[\[Rho]])/(1-\[Epsilon]Crit[\[Rho]]^2)^2+(T/Tdiv[\[Rho]])^\[Epsilon]Crit[\[Rho]] (-(dTdiv[\[Rho]]/Tdiv[\[Rho]])+Log[T/Tdiv[\[Rho]]] d\[Epsilon]Crit[\[Rho]]/\[Epsilon]Crit[\[Rho]]) 1/(1+\[Epsilon]Crit[\[Rho]]);
Zcrit[T_,\[Rho]_/;\[Rho]>0]:=If[T==0,Limit[3/2*\[Rho]*dnCrit[\[Rho]]*FcritGauche[x,\[Rho]]+3/2*\[Rho]*nCrit[\[Rho]]*dFcritGauche[x,\[Rho]],x->0],3/2*\[Rho]*dnCrit[\[Rho]]*Re[Piecewise[{{FcritDroite[T,\[Rho]],T>=Tdiv[\[Rho]]}},FcritGauche[T,\[Rho]]]]+3/2*\[Rho]*nCrit[\[Rho]]*Re[Piecewise[{{dFcritDroite[T,\[Rho]],T>=Tdiv[\[Rho]]}},dFcritGauche[T,\[Rho]]]]];
Zcrit[T_,\[Rho]_/;\[Rho]==0]:=0;
(*********************************************************************************)
(** Int\[EAcute]gration num\[EAcute]rique du terme non regulier **)
dCvNonRegDNv[T_,\[Rho]_]:=3/2 E^-(T/Tdiv[\[Rho]])^(3/2)/(1-Tdiv[\[Rho]]/T) (dnNonreg[\[Rho]](1-Nv[\[Rho]]^(-1+Tdiv[\[Rho]]/T))+nNonreg[\[Rho]]  dTdiv[\[Rho]]/T ((1-Nv[\[Rho]]^(-1+Tdiv[\[Rho]]/T))/(1-Tdiv[\[Rho]]/T)-  Nv[\[Rho]]^(-1+Tdiv[\[Rho]]/T) Log[Nv[\[Rho]]]+3/2 (T/Tdiv[\[Rho]])^(5/2) (1-Nv[\[Rho]]^(-1+Tdiv[\[Rho]]/T))));
dCvNonRegGNv[T_,\[Rho]_]:=3/2 E^-(T/Tdiv[\[Rho]])^(-3/2)/(1-T/Tdiv[\[Rho]])*(dnNonreg[\[Rho]](1-Nv[\[Rho]]^(-1+T/Tdiv[\[Rho]]))-nNonreg[\[Rho]]*(T/Tdiv[\[Rho]])^2*dTdiv[\[Rho]]/T*((1-Nv[\[Rho]]^(-1+T/Tdiv[\[Rho]]))/(1-T/Tdiv[\[Rho]])- Nv[\[Rho]]^(-1+T/Tdiv[\[Rho]]) Log[Nv[\[Rho]]]+3/2 (T/Tdiv[\[Rho]])^(-5/2) (1-Nv[\[Rho]]^(-1+T/Tdiv[\[Rho]]))));
dCvnonregNv[T_,\[Rho]_]:=If[T>Tdiv[\[Rho]],dCvNonRegDNv[T,\[Rho]],dCvNonRegGNv[T,\[Rho]]];
ZnonregNv[T_,\[Rho]_/;\[Rho]>0]:=\[Rho]/T NIntegrate[((1-T/u)*dCvnonregNv[u,\[Rho]]),{u,\[Infinity],T},MinRecursion->2,AccuracyGoal->20];
ZnonregNv[T_,\[Rho]_/;\[Rho]==0]:=0;
(*** TOTAL ***)
Attributes[ZtotalNv]={ReadProtected,NumericFunction};
ZtotalNv[T_/;T>0,\[Rho]_/;\[Rho]>=0]:=Zreg[T,\[Rho]]+ZnonregNv[T,\[Rho]]+Zcrit[T,\[Rho]]+Z0[T,\[Rho]];


(*********************************************************************************)
(*Calculs de \[Rho] et P sous forme dimensionnelle: T en K, P en bar, \[Rho] en g/cm^3; phase = S, L ou G*)
\[Rho]ArgonNv[T_/;T>=ttr,P_/;P>0,phase_:"L"]:=With[{\[Rho]ini=If[StringQ[phase]==False,phase,Switch[phase,"G",\[Rho]trgaz/100,"L",1.5,_,\[Rho]c]]},
With[{sol=If[phase=="S",FindRoot[\[Rho] RR/M T*ZtotalNv[T,\[Rho]]*10-P==0,{\[Rho],0.8*\[Rho]ini,\[Rho]ini},Method->"Secant"],FindRoot[\[Rho] RR/M T*ZtotalNv[T,\[Rho]]*10-P==0,{\[Rho],\[Rho]ini}]]},
\[Rho]/.First@sol
]];
Attributes[RhoArgonNv]={ReadProtected,NumericFunction};
RhoArgonNv[T_/;T>=ttr,P_/;P>0,phase_:"L"]:=\[Rho]ArgonNv[T,P,phase];
Attributes[PArgonNv]={ReadProtected,NumericFunction};
PArgonNv[T_/;T>=ttr,\[Rho]_/;\[Rho]>=0]:=\[Rho]*RR/M*T*ZtotalNv[T,\[Rho]]*10;(*bar*)
Attributes[PFusionArgon]={ReadProtected,NumericFunction};
PFusionArgon[T_/;T>=ttr]:=0.1*ptr+225.285807 ((T/ttr)^1.52844446382-1);(*MPa*)


(* ::Subtitle:: *)
(*D\[EAcute]riv\[EAcute]es premi\[EGrave]res de Z(T, \[Rho]):*)


(* ::Subsubtitle:: *)
(*D\[EAcute]riv\[EAcute]e partielle de Z par rapport \[AGrave] T:*)


(** Termes r\[EAcute]guliers **)
dPUregAdimdT[T_,\[Rho]_]:=(3 tc \[Rho])/(2 T^2) \[Lambda]^-m[\[Rho]] dnReg[\[Rho]]((1-E^-((T \[Lambda])/tc)^(2-m[\[Rho]])) ((T \[Lambda])/tc)^m[\[Rho]]+Re@Gamma[m[\[Rho]]/(2-m[\[Rho]]),((T \[Lambda])/tc)^(2-m[\[Rho]])]/(-2+m[\[Rho]])+(\[Lambda]^m[\[Rho]]-((T \[Lambda])/tc)^m[\[Rho]])/m[\[Rho]])+(3 tc \[Rho])/(2 T^2) dm[\[Rho]] nReg[\[Rho]]((-1+(T/tc)^m[\[Rho]] (1+Log[T/tc] (-1+m[\[Rho]]) m[\[Rho]]))/m[\[Rho]]^2+\[Lambda]^-m[\[Rho]]/(2-m[\[Rho]])^3 (-2 Re@Gamma[m[\[Rho]]/(2-m[\[Rho]]),((T \[Lambda])/tc)^(2-m[\[Rho]])](Log[((T \[Lambda])/tc)^(2-m[\[Rho]])]+1/2 (1+Log[\[Lambda]^(2-m[\[Rho]])])(-2+m[\[Rho]]))+E^-((T \[Lambda])/tc)^(2-m[\[Rho]]) (-2+m[\[Rho]])^2 ((T \[Lambda])/tc)^2 (((T \[Lambda])/tc)^(m[\[Rho]]-2) (Log[\[Lambda]^(2-m[\[Rho]])]-Log[((T \[Lambda])/tc)^2])-Log[((T \[Lambda])/tc)^(2-m[\[Rho]])](1+((T \[Lambda])/tc)^(m[\[Rho]]-2) (-1+m[\[Rho]])/(-2+m[\[Rho]])))+2 (-2+m[\[Rho]]) MeijerG[{{},{1}},{{0,m[\[Rho]]/(2-m[\[Rho]])},{}},((T \[Lambda])/tc)^(2-m[\[Rho]])]-Piecewise[{{2 MeijerG[{{},{1,1}},{{0,0,m[\[Rho]]/(2-m[\[Rho]])},{}},((T \[Lambda])/tc)^(2-m[\[Rho]])],T<ttr}},0]));
dPSregAdimdT[T_,\[Rho]_]:=3/2 \[Rho]/T dnReg[\[Rho]](T/tc)^(m[\[Rho]]-1) (1-E^-((T \[Lambda])/tc)^(2-m[\[Rho]]))+3/2 \[Rho]/T nReg[\[Rho]]*dm[\[Rho]]((T/tc)^(m[\[Rho]]-1) Log[T/tc]+\[Lambda]^(1-m[\[Rho]])/(-2+m[\[Rho]])^2 (Re@Gamma[(1-m[\[Rho]])/(-2+m[\[Rho]]),((T \[Lambda])/tc)^(2-m[\[Rho]])]+E^-((T \[Lambda])/tc)^(2-m[\[Rho]]) ((T \[Lambda])/tc)^(-1+m[\[Rho]])  (-2+m[\[Rho]])((1+((T \[Lambda])/tc)^(2-m[\[Rho]])) Log[((T \[Lambda])/tc)^(2-m[\[Rho]])]-Log[\[Lambda]^(2-m[\[Rho]])])-Piecewise[{{MeijerG[{{},{1}},{{0,(1-m[\[Rho]])/(-2+m[\[Rho]])},{}},((T \[Lambda])/tc)^(2-m[\[Rho]])],T<ttr}},0]));
dZregdT[T_,\[Rho]_]:=Re@dPUregAdimdT[T,\[Rho]]-Re@dPSregAdimdT[T,\[Rho]];
dZregdT[T_,\[Rho]_/;\[Rho]==0]:=0;
dZ0dT[T_,\[Rho]_]:=If[T==0,Limit[-((3 tc)/(2 x^2))\[Rho]*dU0[\[Rho]],x->0],-((3 tc)/(2 T^2))\[Rho]*dU0[\[Rho]]];
dZ0dT[T_,\[Rho]_/;\[Rho]==0]:=0;
(** Termes critiques **)
d2FcritDroitedT[T_,\[Rho]_]:=1/(T^2 (-1+\[Epsilon]Crit[\[Rho]])^2) (Tdiv[\[Rho]]/T)^(-1+\[Epsilon]Crit[\[Rho]]) (dTdiv[\[Rho]] (-1+\[Epsilon]Crit[\[Rho]]) \[Epsilon]Crit[\[Rho]]+d\[Epsilon]Crit[\[Rho]] Tdiv[\[Rho]] (-1+Log[Tdiv[\[Rho]]/T] (-1+\[Epsilon]Crit[\[Rho]])));
d2FcritGauchedT[T_,\[Rho]_]:=1/(Tdiv[\[Rho]]^2 (1+\[Epsilon]Crit[\[Rho]])^2) (T/Tdiv[\[Rho]])^(-1+\[Epsilon]Crit[\[Rho]]) (dTdiv[\[Rho]] \[Epsilon]Crit[\[Rho]] (1+\[Epsilon]Crit[\[Rho]])-d\[Epsilon]Crit[\[Rho]] Tdiv[\[Rho]] (-1+Log[T/Tdiv[\[Rho]]] (1+\[Epsilon]Crit[\[Rho]])));
dZcritdT[T_,\[Rho]_]:=If[T==0,Limit[3/2*\[Rho]*dnCrit[\[Rho]]/x*dFcritgauchedT[x,\[Rho]]+3/2*\[Rho]*nCrit[\[Rho]]*d2FcritGauchedT[x,\[Rho]],x->0],3/2*\[Rho]*dnCrit[\[Rho]]/T*Re[Piecewise[{{dFcritdroitedT[T,\[Rho]],T>=Tdiv[\[Rho]]}},dFcritgauchedT[T,\[Rho]]]]+3/2*\[Rho]*nCrit[\[Rho]]*Re[Piecewise[{{d2FcritDroitedT[T,\[Rho]],T>=Tdiv[\[Rho]]}},d2FcritGauchedT[T,\[Rho]]]]];
dZcritdT[T_,\[Rho]_/;\[Rho]==0]:=0;
(** Int\[EAcute]gration num\[EAcute]rique du terme non regulier **)
dZnonregNvdT[T_,\[Rho]_]:=-(\[Rho]/T^2)NIntegrate[Re@dCvnonregNv[u,\[Rho]],{u,\[Infinity],T},MinRecursion->2,AccuracyGoal->20];
dZnonregNvdT[T_,\[Rho]_/;\[Rho]==0]:=0;
(*** TOTAL ***)
Attributes[dZtotalNvdT]={ReadProtected,NumericFunction};
dZtotalNvdT[T_/;T>0,\[Rho]_/;\[Rho]>=0]:=dZregdT[T,\[Rho]]+dZnonregNvdT[T,\[Rho]]+dZcritdT[T,\[Rho]]+dZ0dT[T,\[Rho]];
(*********************************************************************************)


(* ::Subsubtitle:: *)
(*D\[EAcute]riv\[EAcute]e partielle de Z par rapport \[AGrave] \[Rho]:*)


(** Termes r\[EAcute]guliers **)
dPUregAdim[T_,\[Rho]_]:=(3 tc)/(2 T) (dnReg[\[Rho]]+\[Rho]*d2nReg[\[Rho]])(\[Lambda]^-m[\[Rho]]/(2-m[\[Rho]]) Gamma[m[\[Rho]]/(2-m[\[Rho]]),((T \[Lambda])/tc)^(2-m[\[Rho]])]-(1-(T/tc)^m[\[Rho]])/m[\[Rho]])+(3 tc)/(2 T) \[Rho] dm[\[Rho]]^2 nReg[\[Rho]] 1/m[\[Rho]]^3 (-2+2(T/tc)^m[\[Rho]] (1- Log[(T/tc)^m[\[Rho]]]+1/2 Log[(T/tc)^m[\[Rho]]]^2))+(3 tc)/(2 T) (dm[\[Rho]] nReg[\[Rho]]+\[Rho] nReg[\[Rho]] d2m[\[Rho]]+2\[Rho] dm[\[Rho]] dnReg[\[Rho]])((1-(T/tc)^m[\[Rho]])/m[\[Rho]]^2+((T/tc)^m[\[Rho]] Log[T/tc])/m[\[Rho]])-(3 tc)/(2 T) (dm[\[Rho]] nReg[\[Rho]]+\[Rho] nReg[\[Rho]] d2m[\[Rho]]+\[Rho] dm[\[Rho]] dnReg[\[Rho]]) \[Lambda]^-m[\[Rho]]/(-2+m[\[Rho]])^3 (Gamma[m[\[Rho]]/(2-m[\[Rho]]),((T \[Lambda])/tc)^(2-m[\[Rho]])] (2Log[((T \[Lambda])/tc)^(2-m[\[Rho]])]-(1+Log[\[Lambda]^(-2+m[\[Rho]])]) (-2+m[\[Rho]]))+E^-((T \[Lambda])/tc)^(2-m[\[Rho]]) ((T \[Lambda])/tc)^m[\[Rho]] Log[(T \[Lambda])/tc] (-2+m[\[Rho]])^2+Piecewise[{{2 MeijerG[{{},{1,1}},{{0,0,m[\[Rho]]/(2-m[\[Rho]])},{}},((T \[Lambda])/tc)^(2-m[\[Rho]])],T<ttr}},0])+(3 tc)/(2 T) \[Rho] dnReg[\[Rho]]dm[\[Rho]] \[Lambda]^-m[\[Rho]]/(-2+m[\[Rho]])^2 Gamma[m[\[Rho]]/(2-m[\[Rho]]),((T \[Lambda])/tc)^(2-m[\[Rho]])](1+ Log[\[Lambda]^(-2+m[\[Rho]])])+(3 tc)/(2 T) \[Rho]*dm[\[Rho]] \[Lambda]^-m[\[Rho]]/(-2+m[\[Rho]])^4 (E^-((T \[Lambda])/tc)^(2-m[\[Rho]]) ((T \[Lambda])/tc)^m[\[Rho]] Log[((T \[Lambda])/tc)^(2-m[\[Rho]])](2-m[\[Rho]])+2Gamma[m[\[Rho]]/(2-m[\[Rho]]),((T \[Lambda])/tc)^(2-m[\[Rho]])] Log[((T \[Lambda])/tc)^(2-m[\[Rho]])]+Piecewise[{{2MeijerG[{{},{1,1}},{{0,0,m[\[Rho]]/(2-m[\[Rho]])},{}},((T \[Lambda])/tc)^(2-m[\[Rho]])],T<ttr}},0])(dnReg[\[Rho]](2-m[\[Rho]])+dm[\[Rho]] nReg[\[Rho]](1+2Log[T/tc]+Log[\[Lambda]^m[\[Rho]]]))-(3 tc)/(2 T) \[Rho] dm[\[Rho]]^2 nReg[\[Rho]] \[Lambda]^-m[\[Rho]]/(-2+m[\[Rho]])^3 (Gamma[m[\[Rho]]/(2-m[\[Rho]]),((T \[Lambda])/tc)^(2-m[\[Rho]])](2+(2+Log[\[Lambda]^(-2+m[\[Rho]])])(2Log[T/tc]+Log[\[Lambda]^m[\[Rho]]]))+E^-((T \[Lambda])/tc)^(2-m[\[Rho]]) ((T \[Lambda])/tc)^m[\[Rho]] Log[((T \[Lambda])/tc)^(2-m[\[Rho]])](1+Log[(T/tc)^(2-m[\[Rho]])]+((T \[Lambda])/tc)^(2-m[\[Rho]]) Log[((T \[Lambda])/tc)^(2-m[\[Rho]])]))-3 tc/T \[Rho] dm[\[Rho]]^2 nReg[\[Rho]] \[Lambda]^-m[\[Rho]]/(-2+m[\[Rho]])^5 (((T \[Lambda])/tc)^(m[\[Rho]]-2) Log[((T \[Lambda])/tc)^(2-m[\[Rho]])] (2-m[\[Rho]]) Piecewise[{{MeijerG[{{},{2}},{{1,2/(2-m[\[Rho]])},{}},((T \[Lambda])/tc)^(2-m[\[Rho]])],T<ttr}},0]+(2-m[\[Rho]])(2Log[T/tc]+Log[\[Lambda]^m[\[Rho]]]+3)Piecewise[{{MeijerG[{{},{1,1}},{{0,0,m[\[Rho]]/(2-m[\[Rho]])},{}},((T \[Lambda])/tc)^(2-m[\[Rho]])],T<ttr}},0]+Piecewise[{{4MeijerG[{{},{1,1,1}},{{0,0,0,m[\[Rho]]/(2-m[\[Rho]])},{}},((T \[Lambda])/tc)^(2-m[\[Rho]])],T<ttr}},0]);
dPSregAdim[T_,\[Rho]_]:=3/2 (dnReg[\[Rho]]+\[Rho]*d2nReg[\[Rho]])(\[Lambda]^(1-m[\[Rho]])/(2-m[\[Rho]]) Gamma[(1-m[\[Rho]])/(-2+m[\[Rho]]),((T \[Lambda])/tc)^(2-m[\[Rho]])]+(-1+(T/tc)^(-1+m[\[Rho]]))/(-1+m[\[Rho]]))+3/2 (nReg[\[Rho]] dm[\[Rho]]+2\[Rho] dnReg[\[Rho]]dm[\[Rho]]+\[Rho] nReg[\[Rho]] d2m[\[Rho]]) ((1-(T/tc)^(-1+m[\[Rho]]))/(-1+m[\[Rho]])^2+((T/tc)^(-1+m[\[Rho]]) Log[T/tc])/(-1+m[\[Rho]]))+3/2 (nReg[\[Rho]] dm[\[Rho]]+\[Rho] dnReg[\[Rho]]dm[\[Rho]]+\[Rho] nReg[\[Rho]] d2m[\[Rho]]) \[Lambda]^(1-m[\[Rho]])/(2-m[\[Rho]])^2 (Gamma[(1-m[\[Rho]])/(-2+m[\[Rho]]),((T \[Lambda])/tc)^(2-m[\[Rho]])] (Log[(T \[Lambda])/tc]+1-Log[\[Lambda]^(2-m[\[Rho]])])+E^-((T \[Lambda])/tc)^(2-m[\[Rho]]) ((T \[Lambda])/tc)^(-1+m[\[Rho]]) Log[((T \[Lambda])/tc)^(2-m[\[Rho]])])+3/2 \[Rho] dnReg[\[Rho]]dm[\[Rho]] \[Lambda]^(1-m[\[Rho]])/(-2+m[\[Rho]])^2 (1+Log[\[Lambda]^(-2+m[\[Rho]])]) Gamma[(1-m[\[Rho]])/(-2+m[\[Rho]]),((T \[Lambda])/tc)^(2-m[\[Rho]])]-3/2 \[Rho] dm[\[Rho]]^2 nReg[\[Rho]] 1/(-1+m[\[Rho]])^3 (2 (1-(T/tc)^(-1+m[\[Rho]]))+2 (T/tc)^(-1+m[\[Rho]]) Log[(T/tc)^(-1+m[\[Rho]])]-(T/tc)^(-1+m[\[Rho]]) Log[(T/tc)^(-1+m[\[Rho]])]^2)-3/2 \[Rho] dm[\[Rho]]^2 nReg[\[Rho]] \[Lambda]^(1-m[\[Rho]])/(-2+m[\[Rho]])^3 (Log[\[Lambda]^(-2+m[\[Rho]])]+3)((Log[(T \[Lambda])/tc]+1-Log[\[Lambda]^(2-m[\[Rho]])])Gamma[(1-m[\[Rho]])/(-2+m[\[Rho]]),((T \[Lambda])/tc)^(2-m[\[Rho]])]+E^-((T \[Lambda])/tc)^(2-m[\[Rho]]) ((T \[Lambda])/tc)^(-1+m[\[Rho]]) Log[((T \[Lambda])/tc)^(2-m[\[Rho]])])-3/2 \[Rho] dm[\[Rho]]^2 nReg[\[Rho]] \[Lambda]^(1-m[\[Rho]])/(2-m[\[Rho]])^3 (Gamma[(1-m[\[Rho]])/(-2+m[\[Rho]]),((T \[Lambda])/tc)^(2-m[\[Rho]])] (1+Log[(T \[Lambda])/tc]-2Log[\[Lambda]^(2-m[\[Rho]])])+ E^-((T \[Lambda])/tc)^(2-m[\[Rho]]) ((T \[Lambda])/tc)^(-1+m[\[Rho]]) Log[((T \[Lambda])/tc)^(2-m[\[Rho]])](2-Log[((T \[Lambda])/tc)^(2-m[\[Rho]])])-E^-((T \[Lambda])/tc)^(2-m[\[Rho]]) (T \[Lambda])/tc Log[((T \[Lambda])/tc)^(2-m[\[Rho]])]^2-((T \[Lambda])/tc)^(-2+m[\[Rho]]) Log[(T \[Lambda])/tc] Piecewise[{{MeijerG[{{},{2}},{{1,1/(2-m[\[Rho]])},{}},((T \[Lambda])/tc)^(2-m[\[Rho]])],T<ttr}},0])+3/2 \[Rho] dm[\[Rho]] \[Lambda]^(1-m[\[Rho]])/(-2+m[\[Rho]])^4 (dm[\[Rho]] nReg[\[Rho]](Log[(T \[Lambda])/tc]+1-Log[\[Lambda]^(2-m[\[Rho]])])+dnReg[\[Rho]](2-m[\[Rho]])) Log[((T \[Lambda])/tc)^(2-m[\[Rho]])](E^-((T \[Lambda])/tc)^(2-m[\[Rho]]) ((T \[Lambda])/tc)^(m[\[Rho]]-1) (2-m[\[Rho]])+Gamma[(1-m[\[Rho]])/(-2+m[\[Rho]]),((T \[Lambda])/tc)^(2-m[\[Rho]])])-3 \[Rho] dm[\[Rho]]^2 nReg[\[Rho]] \[Lambda]^(1-m[\[Rho]])/(-2+m[\[Rho]])^5 ((Log[((T \[Lambda])/tc)^(2-m[\[Rho]])]+(2-m[\[Rho]]) (2-Log[\[Lambda]^(2-m[\[Rho]])]))Piecewise[{{MeijerG[{{},{1,1}},{{0,0,(1-m[\[Rho]])/(-2+m[\[Rho]])},{}},((T \[Lambda])/tc)^(2-m[\[Rho]])],T<ttr}},0]+ Piecewise[{{MeijerG[{{},{1,1,1}},{{0,0,0,(1-m[\[Rho]])/(-2+m[\[Rho]])},{}},((T \[Lambda])/tc)^(2-m[\[Rho]])],T<ttr}},0])-3/2 \[Lambda]^(1-m[\[Rho]])/(-2+m[\[Rho]])^3 (2\[Rho] dnReg[\[Rho]]dm[\[Rho]]+nReg[\[Rho]] dm[\[Rho]]+\[Rho] nReg[\[Rho]] d2m[\[Rho]]) Piecewise[{{MeijerG[{{},{1,1}},{{0,0,(1-m[\[Rho]])/(-2+m[\[Rho]])},{}},((T \[Lambda])/tc)^(2-m[\[Rho]])],T<ttr}},0];
dZreg[T_,\[Rho]_]:=Re@dPUregAdim[T,\[Rho]]-Re@dPSregAdim[T,\[Rho]];
dZ0[T_,\[Rho]_]:=If[T==0,Limit[3/2 tc/x (dU0[\[Rho]]+\[Rho]*d2U0[\[Rho]])-dS0[\[Rho]]-\[Rho] d2S0[\[Rho]],x->0],3/2 tc/T (dU0[\[Rho]]+\[Rho]*d2U0[\[Rho]])-dS0[\[Rho]]-\[Rho] d2S0[\[Rho]]];
(** Termes critiques **)
d2FcritDroite[T_,\[Rho]_]:=-(Tdiv[\[Rho]]/T)^\[Epsilon]Crit[\[Rho]](dTdiv[\[Rho]]^2/Tdiv[\[Rho]]^2+(2 d\[Epsilon]Crit[\[Rho]]^2)/((-1+\[Epsilon]Crit[\[Rho]])^3 \[Epsilon]Crit[\[Rho]]^3))-1/(Tdiv[\[Rho]] (-1+\[Epsilon]Crit[\[Rho]])^2) (Tdiv[\[Rho]]/T)^\[Epsilon]Crit[\[Rho]] ((-1+\[Epsilon]Crit[\[Rho]]) d2Tdiv[\[Rho]]+(-1+Log[(Tdiv[\[Rho]]/T)^(\[Epsilon]Crit[\[Rho]]-1)]) 2 dTdiv[\[Rho]] d\[Epsilon]Crit[\[Rho]])-1/((-1+\[Epsilon]Crit[\[Rho]])^2 \[Epsilon]Crit[\[Rho]]^2) (Tdiv[\[Rho]]/T)^\[Epsilon]Crit[\[Rho]] (d2\[Epsilon]Crit[\[Rho]](1-(2+Log[Tdiv[\[Rho]]/T]) \[Epsilon]Crit[\[Rho]]+Log[Tdiv[\[Rho]]/T] \[Epsilon]Crit[\[Rho]]^2)+6 d\[Epsilon]Crit[\[Rho]]^2+d\[Epsilon]Crit[\[Rho]]^2 Log[Tdiv[\[Rho]]/T] (2-(4+Log[Tdiv[\[Rho]]/T]) \[Epsilon]Crit[\[Rho]]+Log[Tdiv[\[Rho]]/T] \[Epsilon]Crit[\[Rho]]^2));
d2FcritGauche[T_,\[Rho]_]:=-(1/(Tdiv[\[Rho]]^2 \[Epsilon]Crit[\[Rho]]^3 (1+\[Epsilon]Crit[\[Rho]])^3)) (T/Tdiv[\[Rho]])^\[Epsilon]Crit[\[Rho]] (dTdiv[\[Rho]] \[Epsilon]Crit[\[Rho]]^3 (1+\[Epsilon]Crit[\[Rho]])^3 dTdiv[\[Rho]]-Tdiv[\[Rho]] \[Epsilon]Crit[\[Rho]]^3 (1+\[Epsilon]Crit[\[Rho]]) ((1+\[Epsilon]Crit[\[Rho]]) d2Tdiv[\[Rho]]+(-1+Log[T/Tdiv[\[Rho]]]+Log[T/Tdiv[\[Rho]]] \[Epsilon]Crit[\[Rho]]) (d\[Epsilon]Crit[\[Rho]] dTdiv[\[Rho]]+dTdiv[\[Rho]] d\[Epsilon]Crit[\[Rho]]))+Tdiv[\[Rho]]^2 (2 d\[Epsilon]Crit[\[Rho]] d\[Epsilon]Crit[\[Rho]]+\[Epsilon]Crit[\[Rho]] (1+\[Epsilon]Crit[\[Rho]]) (d2\[Epsilon]Crit[\[Rho]](-1+\[Epsilon]Crit[\[Rho]] (-2+Log[T/Tdiv[\[Rho]]]+Log[T/Tdiv[\[Rho]]] \[Epsilon]Crit[\[Rho]]))+6 d\[Epsilon]Crit[\[Rho]]^2+d\[Epsilon]Crit[\[Rho]]^2 Log[T/Tdiv[\[Rho]]] (-2+\[Epsilon]Crit[\[Rho]] (-4+Log[T/Tdiv[\[Rho]]]+Log[T/Tdiv[\[Rho]]] \[Epsilon]Crit[\[Rho]])))));
dZcritDroite[T_,\[Rho]_]:=3/2*(dnCrit[\[Rho]]+\[Rho]*d2nCrit[\[Rho]])*FcritDroite[T,\[Rho]]+3/2*(2\[Rho]*dnCrit[\[Rho]]+nCrit[\[Rho]])*dFcritDroite[T,\[Rho]]+3/2*\[Rho]*nCrit[\[Rho]]*d2FcritDroite[T,\[Rho]];(* Valable pour T >= Tdiv *)
dZcrit[T_,\[Rho]_]:=If[T==0,Limit[3/2*(dnCrit[\[Rho]]+\[Rho]*d2nCrit[\[Rho]])*FcritGauche[x,\[Rho]]+3/2*(2\[Rho]*dnCrit[\[Rho]]+nCrit[\[Rho]])*dFcritGauche[x,\[Rho]]+3/2*\[Rho]*nCrit[\[Rho]]*d2FcritGauche[x,\[Rho]],x->0],3/2*(dnCrit[\[Rho]]+\[Rho]*d2nCrit[\[Rho]])*Piecewise[{{FcritDroite[T,\[Rho]],T>=Tdiv[\[Rho]]}},FcritGauche[T,\[Rho]]]+3/2*(2\[Rho]*dnCrit[\[Rho]]+nCrit[\[Rho]])*Piecewise[{{dFcritDroite[T,\[Rho]],T>=Tdiv[\[Rho]]}},dFcritGauche[T,\[Rho]]]+3/2*\[Rho]*nCrit[\[Rho]]*Piecewise[{{d2FcritDroite[T,\[Rho]],T>=Tdiv[\[Rho]]}},d2FcritGauche[T,\[Rho]]]];
dZcrit[T_,\[Rho]_/;\[Rho]==0]:=0;
(** Termes non r\[EAcute]guliers **)
d2CvNonRegDNv[T_,\[Rho]_]:=-(3/2) dTdiv[\[Rho]]/(T-Tdiv[\[Rho]]) (dnNonreg[\[Rho]]+nNonreg[\[Rho]] dTdiv[\[Rho]]/(T-Tdiv[\[Rho]])+1/2 nNonreg[\[Rho]]*d2Tdiv[\[Rho]]/dTdiv[\[Rho]]) E^-(T/Tdiv[\[Rho]])^(3/2) (3(-1+Nv[\[Rho]]^(Tdiv[\[Rho]]/T-1)) (T/Tdiv[\[Rho]])^(5/2)+2 Nv[\[Rho]]^(Tdiv[\[Rho]]/T-1) Log[Nv[\[Rho]]])-3/8 (nNonreg[\[Rho]]*dTdiv[\[Rho]]^2)/(Tdiv[\[Rho]](T-Tdiv[\[Rho]])) E^-(T/Tdiv[\[Rho]])^(3/2) (T/Tdiv[\[Rho]])^(5/2) (3(-1+Nv[\[Rho]]^(Tdiv[\[Rho]]/T-1)) (3(T/Tdiv[\[Rho]])^(3/2)-5)+4 Nv[\[Rho]]^(Tdiv[\[Rho]]/T-1) Log[Nv[\[Rho]]] Tdiv[\[Rho]]/T (3+Log[Nv[\[Rho]]] (Tdiv[\[Rho]]/T)^(5/2)))+-(3/2) T/(T-Tdiv[\[Rho]])^3 E^-(T/Tdiv[\[Rho]])^(3/2) (-1+Nv[\[Rho]]^(Tdiv[\[Rho]]/T-1)) (2 (T-Tdiv[\[Rho]]) dnNonreg[\[Rho]] dTdiv[\[Rho]]+(T-Tdiv[\[Rho]])^2 d2nNonreg[\[Rho]]+nNonreg[\[Rho]] (2 dTdiv[\[Rho]]^2+(T-Tdiv[\[Rho]]) d2Tdiv[\[Rho]]));
d2CvNonRegGNv[T_,\[Rho]_]:=-(3/2) dTdiv[\[Rho]]/(T-Tdiv[\[Rho]]) E^-(Tdiv[\[Rho]]/T)^(3/2) (Tdiv[\[Rho]]/T)^(3/2) (2 Nv[\[Rho]]^(T/Tdiv[\[Rho]]-1) (T/Tdiv[\[Rho]])^(5/2) Log[Nv[\[Rho]]]+3(-1+Nv[\[Rho]]^(T/Tdiv[\[Rho]]-1)))  (dnNonreg[\[Rho]]+T/Tdiv[\[Rho]] nNonreg[\[Rho]] dTdiv[\[Rho]]/(T-Tdiv[\[Rho]])+1/2 nNonreg[\[Rho]] d2Tdiv[\[Rho]]/dTdiv[\[Rho]])+3/8 (nNonreg[\[Rho]]*dTdiv[\[Rho]]^2)/(Tdiv[\[Rho]](T-Tdiv[\[Rho]])) T/Tdiv[\[Rho]] E^-(Tdiv[\[Rho]]/T)^(3/2) (4 Nv[\[Rho]]^(T/Tdiv[\[Rho]]-1) Log[Nv[\[Rho]]](2+Log[Nv[\[Rho]]] T/Tdiv[\[Rho]]+3(Tdiv[\[Rho]]/T)^(3/2))+3(-1+Nv[\[Rho]]^(T/Tdiv[\[Rho]]-1)) (Tdiv[\[Rho]]/T)^4 (3-(T/Tdiv[\[Rho]])^(3/2)))+3/2 T /(T-Tdiv[\[Rho]])^3 E^-(Tdiv[\[Rho]]/T)^(3/2) (-1+Nv[\[Rho]]^(T/Tdiv[\[Rho]]-1)) (2(T-Tdiv[\[Rho]]) dnNonreg[\[Rho]] dTdiv[\[Rho]]+(T-Tdiv[\[Rho]])^2 Tdiv[\[Rho]]/T d2nNonreg[\[Rho]]+nNonreg[\[Rho]] (2 dTdiv[\[Rho]]^2+(T-Tdiv[\[Rho]]) d2Tdiv[\[Rho]]));
d2CvnonregNv[T_,\[Rho]_]:=If[T>=Tdiv[\[Rho]],d2CvNonRegDNv[T,\[Rho]],d2CvNonRegGNv[T,\[Rho]]];
(** Int\[EAcute]gration num\[EAcute]rique du terme non regulier **)
dZnonregNvDroite[T_,\[Rho]_]:=1/T NIntegrate[((1-T/u)*dCvNonRegDNv[u,\[Rho]]),{u,\[Infinity],T}]+\[Rho]/T NIntegrate[((1-T/u)*d2CvNonRegDNv[u,\[Rho]]),{u,\[Infinity],T},MinRecursion->2];(* Valable pour T >= Tdiv *)
dZnonregNv[T_,\[Rho]_]:=1/T NIntegrate[((1-T/u)*dCvnonregNv[u,\[Rho]]),{u,\[Infinity],T},AccuracyGoal->20,PrecisionGoal->5,MaxRecursion->20]+\[Rho]/T NIntegrate[((1-T/u)*d2CvnonregNv[u,\[Rho]]),{u,\[Infinity],T},AccuracyGoal->20,PrecisionGoal->5,MaxRecursion->20];
dZnonregNv[T_,\[Rho]_/;\[Rho]==0]:=0;
(*** TOTAL ***)
Attributes[dZtotalNv]={ReadProtected,NumericFunction};
dZtotalNv[T_/;T>0,\[Rho]_/;\[Rho]>0]:=dZreg[T,\[Rho]]+dZnonregNv[T,\[Rho]]+dZcrit[T,\[Rho]]+dZ0[T,\[Rho]];


(*********************************************************************************)
(*Subscript[(\[PartialD]P/\[PartialD]T), \[Rho]]*)
Attributes[dPArgonNvdT]={ReadProtected,NumericFunction};
dPArgonNvdT[T_/;T>=ttr,\[Rho]_/;\[Rho]>=0]:=\[Rho]*(RR/M)*ZtotalNv[T,\[Rho]]*10+\[Rho]*(RR/M)*T*dZtotalNvdT[T,\[Rho]]*10;(*bar/K*)
(*Subscript[(\[PartialD]P/\[PartialD]\[Rho]), T]*)
dPArgonNvd\[Rho][T_/;T>=ttr,\[Rho]_/;\[Rho]>0]:=(RR/M)*T*ZtotalNv[T,\[Rho]]+\[Rho]*(RR/M)*T*dZtotalNv[T,\[Rho]];(*J/g*)
Attributes[dPArgonNvdRho]={ReadProtected,NumericFunction};
dPArgonNvdRho[T_/;T>=ttr,\[Rho]_/;\[Rho]>0]:=dPArgonNvd\[Rho][T,\[Rho]];


(* ::Subtitle:: *)
(*Autres \[EAcute]quations d'\[EAcute]tat d\[EAcute]termin\[EAcute]es \[AGrave] partir de Subscript[C, V](\[Rho],T) et de Z(\[Rho],T) :*)


(** Enthalpie sous forme adimensionnelle **)
Attributes[HtotalAdimNv]={ReadProtected,NumericFunction};
HtotalAdimNv[T_/;T>0,\[Rho]_/;\[Rho]>=0]:=UtotalAdimNv[T,\[Rho]]+ZtotalNv[T,\[Rho]];
(*********************************************************************************)
(*Compressibilit\[EAcute] isotherme Subscript[K, T]*)
Attributes[CompressibiliteKTNv]={ReadProtected,NumericFunction};
CompressibiliteKTNv[T_/;T>=ttr,\[Rho]_/;\[Rho]>0]:=1/(\[Rho]*dPArgonNvd\[Rho][T,\[Rho]]*10);(*bar^-1*)
(*Capacit\[EAcute] calorifique \[AGrave] pression constante sous forme adimensionnelle*)
Attributes[CpAdimNv]={ReadProtected,NumericFunction};
CpAdimNv[T_/;T>=ttr,\[Rho]_/;\[Rho]>0]:=CVAdimNv[T,\[Rho]]+(T*M)/(10*RR*\[Rho])*CompressibiliteKTNv[T,\[Rho]]*dPArgonNvdT[T,\[Rho]]^2;
(*Compressibilit\[EAcute] adiabatique Subscript[K, S]*)
Attributes[CompressibiliteKSNv]={ReadProtected,NumericFunction};
CompressibiliteKSNv[T_/;T>=ttr,\[Rho]_/;\[Rho]>0]:=CompressibiliteKTNv[T,\[Rho]] CVAdimNv[T,\[Rho]]/CpAdimNv[T,\[Rho]];(*bar^-1*)
(*C\[EAcute]l\[EAcute]rit\[EAcute] du son*)
Attributes[CeleriteSonNv]={ReadProtected,NumericFunction};
CeleriteSonNv[T_/;T>=ttr,\[Rho]_/;\[Rho]>0]:=10/Sqrt[\[Rho]*CompressibiliteKSNv[T,\[Rho]]];(*m/s*)
(*Dilatation thermique isobare \[Beta]*)
\[Beta]ThermiqueNv[T_/;T>=ttr,\[Rho]_/;\[Rho]>0]:=Sqrt[(CompressibiliteKTNv[T,\[Rho]]*10*RR*\[Rho])/(T*M) (CpAdimNv[T,\[Rho]]-CVAdimNv[T,\[Rho]])];(*K^-1*)
Attributes[CoefDilatationThermiqueNv]={ReadProtected,NumericFunction};
CoefDilatationThermiqueNv[T_/;T>=ttr,\[Rho]_/;\[Rho]>0]:=\[Beta]ThermiqueNv[T,\[Rho]];
(*Subscript[\[Delta], T] = Subscript[(\[PartialD]H/\[PartialD]P), T] = V(1-T\[Beta])*)
Attributes[\[Delta]TAdimNv]={ReadProtected,NumericFunction};
\[Delta]TAdimNv[T_/;T>=ttr,\[Rho]_/;\[Rho]>0]:=1-T*\[Beta]ThermiqueNv[T,\[Rho]];
CoefExpansionAdimNv[T_/;T>=ttr,\[Rho]_/;\[Rho]>0]:=\[Delta]TAdimNv[T,\[Rho]];
(*Coefficient de Joule-Thomson adimensionnel: \[Mu] = Subscript[(\[PartialD]T/\[PartialD]P), H] = -(1/Subscript[C, P])Subscript[(\[PartialD]H/\[PartialD]P), T]*)
\[Mu]AdimNv[T_/;T>=ttr,\[Rho]_/;\[Rho]>0]:=-\[Delta]TAdimNv[T,\[Rho]]/CpAdimNv[T,\[Rho]];
Attributes[CoefJouleThomsonAdimNv]={ReadProtected,NumericFunction};
CoefJouleThomsonAdimNv[T_/;T>=ttr,\[Rho]_/;\[Rho]>0]:=\[Mu]AdimNv[T,\[Rho]];


(* ::Subtitle:: *)
(*Courbe de pression de vapeur saturante*)


(** Etats caract\[EAcute]ristiques du mod\[EGrave]le **)
SetAttributes[{ptrNv,\[Rho]trgazNv,rhotrgazNv,\[Rho]trliqNv,rhotrliqNv,pcNv,tcNv,\[Rho]cNv,rhocNv},Constant];
ptrNv=0.06896569762291979;(*MPa*)
\[Rho]trgazNv=0.00405911915480945;(*g/cm^3*)
rhotrgazNv=\[Rho]trgazNv;
\[Rho]trliqNv=1.4168019421690525;(*g/cm^3*)
rhotrliqNv=\[Rho]trliqNv;
pcNv=49.96838429197424;(*bar*)
tcNv=151.396;(*K*)
\[Rho]cNv=0.5437860867;(*g/cm^3*)
rhocNv=\[Rho]cNv;
(*********************************************************************************)
(*P en MPa, T en K et \[Rho] en g/cm^3*)
DataPT\[Rho]Sat={{0.06896569762291979`,83.8058`,0.00405911915480945`,1.4168019421690525`},{0.07827299187516908`,84.92`,0.00455805271231392`,1.4099192750701142`},{0.08666611658732776`,85.84`,0.005003814392754522`,1.4042019158123227`},{0.09573665613573719`,86.76`,0.005481666681151469`,1.3984686584504393`},{0.10551989560654863`,87.68`,0.005993067583390191`,1.3927205694279108`},{0.11605175792757003`,88.6`,0.006539504761093485`,1.3869565620022908`},{0.12736886472003436`,89.52`,0.00712249623795369`,1.3811750005944816`},{0.13950817974403476`,90.44`,0.007743591498599685`,1.3753740730290753`},{0.15250741772213813`,91.36`,0.008404372842044629`,1.3695518909658517`},{0.16640491031688295`,92.28`,0.009106456962060513`,1.3637065172919807`},{0.1812390498988348`,93.2`,0.009851496751432282`,1.357835971716768`},{0.1970490787800849`,94.12`,0.010641183338267761`,1.3519382296745721`},{0.2138745564512075`,95.04`,0.011477248363208957`,1.346011219253465`},{0.23175576138692722`,95.96`,0.012361466513246487`,1.3400528176247104`},{0.2507325143481137`,96.88`,0.013295658326593993`,1.334060847370562`},{0.2708457794805663`,97.8`,0.014281693287834676`,1.3280330727522933`},{0.2921370462831067`,98.72`,0.015321493234732187`,1.3219671958537407`},{0.3146469526420747`,99.64`,0.016417036101325902`,1.3158608525124167`},{0.33841752918140566`,100.56`,0.01757036002571219`,1.309711607955441`},{0.363491318141606`,101.48`,0.01878356785532761`,1.303516952067212`},{0.389909553919869`,102.4`,0.020058832085855335`,1.2972742942256108`},{0.41771580370466654`,103.32`,0.021398400279208224`,1.2909809576494633`},{0.44695171473703427`,104.24`,0.022804601004839296`,1.284634173203003`},{0.4776607451125859`,105.16`,0.024279850364338496`,1.2782310726030692`},{0.5098868709324474`,106.08`,0.02582665916882369`,1.2717686809725792`},{0.5436720329309116`,107.`,0.02744764079412937`,1.2652439086741223`},{0.5790613306371619`,107.92`,0.02914551994223797`,1.2586535423667347`},{0.6160969689872863`,108.84`,0.030923142166397327`,1.2519942351869449`},{0.6548245493134808`,109.76`,0.032783484510706444`,1.2452624959849672`},{0.695286495443665`,110.68`,0.034729667249308496`,1.238454677500295`},{0.7375289188958406`,111.6`,0.03676496692159552`,1.2315669633616706`},{0.7815944232510298`,112.52`,0.038892830823767106`,1.2245953537717016`},{0.8275296592756596`,113.44`,0.04111689319704796`,1.217535649719671`},{0.8753773774637551`,114.36`,0.04344099322417789`,1.210383435522377`},{0.9251848203330117`,115.28`,0.04586919531191673`,1.203134059495534`},{0.9769960640535187`,116.2`,0.04840581177492534`,1.1957826124779276`},{1.030855410364296`,117.12`,0.05105542842084711`,1.1883239039197047`},{1.0868108254653228`,118.04`,0.05382293344880457`,1.180752435175914`},{1.144906979380675`,118.96`,0.056713550176601346`,1.1730623695824987`},{1.2051887464149462`,119.88`,0.059732874263395234`,1.1652474988184771`},{1.2677050640362302`,120.8`,0.06288691615189015`,1.1573012049524762`},{1.3325013166716597`,121.72`,0.06618214966224704`,1.1492164174581356`},{1.3996245256277573`,122.64`,0.06962556783869571`,1.1409855643315492`},{1.4691220785840444`,123.56`,0.07322474739544217`,1.1326005162583714`},{1.541040380556248`,124.48`,0.0769879234142715`,1.124052522543182`},{1.6154304796581411`,125.4`,0.08092407633051`,1.1153321372123153`},{1.692339742506927`,126.32`,0.08504303373936832`,1.1064291333081442`},{1.7718175313594369`,127.24`,0.08935559019293617`,1.0973324028689062`},{1.8539153080668`,128.16`,0.09387364897873406`,1.088029839369153`},{1.9386810273144073`,129.08`,0.09861039098513238`,1.078508198394041`},{2.026167745737462`,130.`,0.10358047719803498`,1.0687529308750217`},{2.07815184681817`,130.53333333333333`,0.10657490378858518`,1.0629844763094123`},{2.131077090995597`,131.06666666666666`,0.10965671050687766`,1.0571287563465668`},{2.184956847593976`,131.6`,0.11282964008574814`,1.0511821657294103`},{2.2398003975503293`,132.13333333333333`,0.11609771127437551`,1.0451408607924828`},{2.295618626457182`,132.66666666666666`,0.11946524795730633`,1.0390007343573602`},{2.3524225977808952`,133.2`,0.1229369122648435`,1.0327573867430528`},{2.410222216361693`,133.73333333333332`,0.1265177423564865`,1.0264060921302627`},{2.4690316893693853`,134.26666666666668`,0.13021319569952192`,1.019941759384976`},{2.5288613217909126`,134.8`,0.13402919883912728`,1.0133588863136545`},{2.5897230680006422`,135.33333333333334`,0.1379722052779033`,1.0066515062998453`},{2.651629140255808`,135.86666666666667`,0.14204926013706917`,0.9998131254729079`},{2.714592074817473`,136.4`,0.14626808189332915`,0.9928366511121437`},{2.778624719332827`,136.93333333333334`,0.15063714939498946`,0.9857143070119241`},{2.8437415408038316`,137.46666666666667`,0.15516581111836467`,0.9784375381510347`},{2.909953643719391`,138.`,0.15986441184987396`,0.9709969022965811`},{2.9772763185950177`,138.53333333333333`,0.16474444425781004`,0.96338194915321`},{3.04572408703558`,139.06666666666666`,0.16981873094470498`,0.9555810872326613`},{3.115313172166497`,139.6`,0.17510164478940185`,0.9475814384872625`},{3.186056950226574`,140.13333333333333`,0.18060937785719966`,0.9393686793991959`},{3.2579729079079094`,140.66666666666666`,0.18636027254592832`,0.9309268638755978`},{3.3310793355444943`,141.2`,0.19237523364707934`,0.9222382170047345`},{3.405392077470839`,141.73333333333332`,0.19867824332874293`,0.9132828773333669`},{3.4809325227970813`,142.26666666666668`,0.2052970256657751`,0.9040385546744939`},{3.557719998857333`,142.8`,0.21226388048220113`,0.8944800390184084`},{3.6357765272886344`,143.33333333333334`,0.21961679470298545`,0.884578493626484`},{3.7151259435741126`,143.86666666666667`,0.22740089443231828`,0.8743004191892864`},{3.7957942378297798`,144.4`,0.23567040458052943`,0.8636061676375948`},{3.8778099411690397`,144.93333333333334`,0.2444913346715742`,0.8524478456930302`},{3.9612045744968687`,145.46666666666667`,0.2539452461146247`,0.8407663966933766`},{4.046014018003584`,146.`,0.2641346791803278`,0.8284875367028093`},{4.067441198755248`,146.13333333333333`,0.2668115915194533`,0.8253138781176018`},{4.088960655420569`,146.26666666666668`,0.2695449031202888`,0.8220953294657782`},{4.110572238906947`,146.4`,0.27233719014778146`,0.818830029753192`},{4.1322758858545034`,146.53333333333333`,0.2751912192638166`,0.8155159833969301`},{4.154073891911813`,146.66666666666666`,0.27810996726469545`,0.8121510471867758`},{4.175966206749697`,146.8`,0.28109664334177314`,0.8087329155833349`},{4.197953609168553`,146.93333333333334`,0.2841547143954547`,0.8052591040729316`},{4.220036182690482`,147.06666666666666`,0.2872879339191903`,0.8017269302436172`},{4.242216236927942`,147.2`,0.2905003750706923`,0.7981334921752689`},{4.264493889190142`,147.33333333333334`,0.293796468677421`,0.7944756436570409`},{4.286870043197926`,147.46666666666667`,0.2971810470781562`,0.7907499656341714`},{4.309344944126132`,147.6`,0.3006593949003187`,0.7869527331588411`},{4.331920986044151`,147.73333333333332`,0.30423730811600186`,0.783079876949814`},{4.354598475409111`,147.86666666666667`,0.3079211630280157`,0.7791269384547634`},{4.377378485030738`,148.`,0.3117179972248172`,0.7750890170345918`},{4.400262139552285`,148.13333333333333`,0.3156356050380928`,0.7709607075388695`},{4.423250620250016`,148.26666666666668`,0.3196826506633541`,0.7667360260749282`},{4.446345170422733`,148.4`,0.32386880291620695`,0.7624083211664825`},{4.469547101445907`,148.53333333333333`,0.3282048966333026`,0.7579701666799534`},{4.4928577995594505`,148.66666666666666`,0.33270312708161254`,0.7534132317927567`},{4.51627873346034`,148.8`,0.3373772854895066`,0.7487281217689941`},{4.53981146276964`,148.93333333333334`,0.342243046107305`,0.7439041812069735`},{4.563457647405227`,149.06666666666666`,0.3473183181997932`,0.7389292484625597`},{4.587219057849575`,149.2`,0.3526236802936951`,0.7337893456993776`},{4.611097586200779`,149.33333333333334`,0.3581829191434815`,0.7284682827964021`},{4.6350952577083655`,149.46666666666667`,0.3640237025722105`,0.7229471440427739`},{4.6592147845703495`,149.6`,0.37017842406114687`,0.7172036123141569`},{4.683457406909599`,149.73333333333332`,0.37668526824582177`,0.7112110630226356`},{4.70782615408094`,149.86666666666667`,0.38358956119169363`,0.7049373238013978`},{4.73232417778984`,150.`,0.3909454891716338`,0.6983429348164123`},{4.740904465563949`,150.04653333333334`,0.39363066471191355`,0.695957292863866`},{4.749501389096977`,150.09306666666666`,0.3963818153023404`,0.6935242764364649`},{4.7581140971077875`,150.1396`,0.3992023040367375`,0.6910412261082234`},{4.766743680978616`,150.18613333333334`,0.40209573510557206`,0.688505231682206`},{4.775389307614782`,150.23266666666666`,0.4050659752175767`,0.6859130979100881`},{4.784052052594717`,150.2792`,0.40811717761041055`,0.6832613039055451`},{4.792731554158477`,150.32573333333332`,0.41125380925638655`,0.6805459547637057`},{4.801427498015786`,150.37226666666666`,0.4144806820894424`,0.6777627234697454`},{4.810140896752327`,150.4188`,0.4178029894209469`,0.6749067805919514`},{4.8188709758369725`,150.46533333333332`,0.421226349225686`,0.6719727084589548`},{4.827618724282214`,150.51186666666666`,0.4247568566890137`,0.668954395406019`},{4.836383789123684`,150.5584`,0.4284011494815077`,0.6658449041283595`},{4.84516584797485`,150.60493333333332`,0.43216649073963426`,0.6626363059320255`},{4.853965804856172`,150.65146666666666`,0.4360608769851511`,0.6593194694459622`},{4.862783283537678`,150.69799999999998`,0.44009318141246045`,0.6558837875117773`},{4.871618308621998`,150.74453333333332`,0.44427334774133687`,0.6523168186501792`},{4.8804705012558705`,150.79106666666667`,0.44861265675982476`,0.6486038080523853`},{4.8893405704409`,150.83759999999998`,0.4531240981460587`,0.644727034704564`},{4.898228028683356`,150.88413333333332`,0.4578228960927418`,0.6406649007926426`},{4.907132708989923`,150.93066666666667`,0.4627272624928442`,0.6363906271039144`},{4.916054357476712`,150.97719999999998`,0.46785949265070265`,0.6318703236216149`},{4.924992604065639`,151.02373333333333`,0.47324758927362487`,0.6270600250721098`},{4.933946611382704`,151.07026666666667`,0.47892772776017567`,0.6219009178642178`},{4.9429162418662695`,151.11679999999998`,0.48494811921233283`,0.6163111895422169`},{4.95190032176204`,151.16333333333333`,0.49137532309186266`,0.6101710070706281`},{4.960896539383002`,151.20986666666664`,0.49830515711872675`,0.6032918149325539`},{4.969902266658082`,151.25639999999999`,0.5058830534952005`,0.5953434720577984`},{4.97891189976946`,151.30293333333333`,0.5143466840030382`,0.5856344244226375`},{4.987911461810569`,151.34946666666664`,0.524138540485853`,0.5720353507856337`},{4.996838429197424`,151.396`,0.5437860867152905`,0.5437860867019602`}};
DataPTSat=Take[DataPT\[Rho]Sat,All,{1,-3}];
(*Subscript[P, \[Sigma]] = f(T)*)
ifunPTsat[T_]=Interpolation[RotateLeft[DataPTSat,{0,-1}],T];
Attributes[PTSat]={ReadProtected,NumericFunction};
PTSat[T_/;tcNv>=T>=ttr]:=ifunPTsat[T];

DataP\[Rho]vap=Take[DataPT\[Rho]Sat,All,{1,-1,2}];
DataP\[Rho]liq=Take[DataPT\[Rho]Sat,All,{1,-1,3}];
(*Subscript[P, \[Sigma]] = f(\[Rho])*)
ifunP\[Rho]sat[\[Rho]_]=Interpolation[Join[RotateLeft[DataP\[Rho]vap,{0,-1}],RotateLeft[DataP\[Rho]liq,{0,-1}]],\[Rho]];
Attributes[PRhoSat]={ReadProtected,NumericFunction};
PRhoSat[\[Rho]_/;\[Rho]trgaz<=\[Rho]<=\[Rho]trliq]:=ifunP\[Rho]sat[\[Rho]];
PRhoSat[args___]:=(Message[PRhoSat::argx, Length[{args}]];$Failed);

DataT\[Rho]v=Take[DataPT\[Rho]Sat,All,{2,-2}];
DataT\[Rho]l=Take[DataPT\[Rho]Sat,All,{2,-1,2}];
ifunT\[Rho]v[\[Rho]_]=Interpolation[RotateLeft[DataT\[Rho]v,{0,-1}],\[Rho]];
ifunT\[Rho]l[\[Rho]_]=Interpolation[RotateLeft[DataT\[Rho]l,{0,-1}],\[Rho]];
(*Subscript[T, \[Sigma]] = f(\[Rho])*)
ifunT\[Rho]sat[\[Rho]_]=Interpolation[Join[RotateLeft[DataT\[Rho]v,{0,-1}],RotateLeft[DataT\[Rho]l,{0,-1}]],\[Rho]];
Attributes[TRhoSat]={ReadProtected,NumericFunction};
TRhoSat[\[Rho]_/;\[Rho]trgaz<=\[Rho]<=\[Rho]trliq]:=ifunT\[Rho]sat[\[Rho]];
TRhoSat[args___]:=(Message[TRhoSat::argx, Length[{args}]];$Failed);
(*Subscript[\[Rho], \[Sigma]l]=f(T)*)
Attributes[RhoSatLiqFromT]={ReadProtected,NumericFunction};
RhoSatLiqFromT[T_/;tcNv>=T>=ttr]:=Quiet@With[{sol=If[T<=90,FindRoot[ifunT\[Rho]l[\[Rho]]-T==0,{\[Rho],\[Rho]c,\[Rho]trliq},Method->"Secant"],FindRoot[ifunT\[Rho]l[\[Rho]]-T==0,{\[Rho],1.4}]]},
\[Rho]/.First@sol
];
RhoSatLiqFromT[args___]:=(Message[RhoSatLiqFromT::argx, Length[{args}]];$Failed);
(*Subscript[\[Rho], \[Sigma]v]=f(T)*)
Attributes[RhoSatVapFromT]={ReadProtected,NumericFunction};
RhoSatVapFromT[T_/;tcNv>=T>=ttr]:=Quiet@With[{sol=If[T<=110,FindRoot[ifunT\[Rho]v[\[Rho]]-T==0,{\[Rho],\[Rho]trgaz,\[Rho]c},Method->"Secant"],FindRoot[ifunT\[Rho]v[\[Rho]]-T==0,{\[Rho],0.01}]]},
\[Rho]/.First@sol
];
RhoSatVapFromT[args___]:=(Message[RhoSatVapFromT::argx, Length[{args}]];$Failed);
(*Chaleur latente de vaporisation adimensionnelle Lv = \[CapitalDelta]H/(Subscript[R, A]T)*)
Attributes[LvapAdimNv]={ReadProtected,NumericFunction};
LvapAdimNv[T_/;tcNv>=T>=ttr]:=HtotalAdimNv[T,RhoSatVapFromT[T]]-HtotalAdimNv[T,RhoSatLiqFromT[T]];
LvapAdimNv[args___]:=(Message[LvapAdimNv::argx, Length[{args}]];$Failed);


(*******************************)
End[]   (* end private context *)
(*******************************)
Protect["NewEoSArgon`*"];
Map[SetAttributes[#,Locked]&,Select[Names["NewEoSArgon`*Nv*"],MemberQ[Attributes[#],NumericFunction]&]];
(*******************************)
EndPackage[];
(*******************************)






