(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Wolfram 14.2' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       154,          7]
NotebookDataLength[   2624326,      51314]
NotebookOptionsPosition[   2604105,      50940]
NotebookOutlinePosition[   2604502,      50956]
CellTagsIndexPosition[   2604459,      50953]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "Chapter 2 Figures & Tables for ",
 StyleBox["Fundamental Concepts of \nProbabilistic Seismic Hazard Analysis", 
  "Subtitle",
  FontSize->48]
}], "Title",
 CellChangeTimes->{{3.947391415550271*^9, 3.947391424639997*^9}, 
   3.947393193223259*^9, {3.947575011347905*^9, 3.9475750117033157`*^9}, {
   3.951811488489608*^9, 3.9518114994215727`*^9}, {3.955792394506338*^9, 
   3.955792402726025*^9}},
 $CellContext`InitializationGroup -> 
 True,ExpressionUUID->"1442f2c9-7a9e-4e81-bbfc-4cce0a6d264e"],

Cell[TextData[{
 "\nThe outermost cell of this notebook is defined  as",
 StyleBox[" Initialization Group ",
  FontSlant->"Italic"],
 "so that all figures, some of which may depend on previously generated ones, \
are produced in the proper sequence."
}], "Text",
 CellChangeTimes->{{3.951733887645832*^9, 3.951733900624896*^9}, {
  3.951789880822382*^9, 3.951789882112493*^9}, {3.9557694079288607`*^9, 
  3.9557695585520773`*^9}, {3.955769617637073*^9, 3.95576961819106*^9}},
 $CellContext`InitializationGroup -> 
 True,ExpressionUUID->"92b58fad-6be0-40d2-8ee7-3a9a81417e30"],

Cell[CellGroupData[{

Cell["Warranty Disclaimer", "Section",
 CellChangeTimes->{{3.95162435258323*^9, 3.951624383820673*^9}, {
  3.9516668189919157`*^9, 3.951666836375389*^9}, {3.951718418324568*^9, 
  3.951718418763173*^9}, {3.951730306823305*^9, 3.951730313723783*^9}, {
  3.95173243157547*^9, 3.9517324338531847`*^9}, {3.951733794512895*^9, 
  3.9517337992616243`*^9}},
 $CellContext`InitializationGroup -> 
 True,ExpressionUUID->"30267105-04b4-464e-8c1b-d01a44246960"],

Cell["\<\

This software is provided \[OpenCurlyDoubleQuote]as is,\
\[CloseCurlyDoubleQuote] without any express or implied warranties, including \
but not limited to warranties of merchantability, fitness for a particular \
purpose, or non-infringement. In no event shall the author be liable for any \
claim, damages, or other liability arising from the use or inability to use \
this software. Use at your own risk.\
\>", "Text",
 CellChangeTimes->{{3.951733887645832*^9, 3.951733900624896*^9}, {
  3.951789880822382*^9, 3.951789882112493*^9}},
 $CellContext`InitializationGroup -> 
 True,ExpressionUUID->"e67f1d20-d376-460b-b571-450910ba6205"]
}, Open  ]],

Cell[CellGroupData[{

Cell["General definitions", "Section",
 CellChangeTimes->{{3.5723397514739923`*^9, 3.5723397663929567`*^9}, {
   3.947393424561935*^9, 3.947393447165543*^9}, {3.947397145993101*^9, 
   3.947397154149987*^9}, 3.9474033249834642`*^9, 3.94740884697871*^9, 
   3.951811157549309*^9, {3.9557693090948267`*^9, 3.955769313817622*^9}},
 $CellContext`InitializationGroup -> 
 True,ExpressionUUID->"b953e342-f979-490d-acd5-641bbf3a6885"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"iSize", "=", " ", "350"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"labFontSize", " ", "=", " ", "14"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"fs", " ", "=", " ", "20"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ls", " ", "=", " ", "15"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ff", " ", "=", " ", "\"\<Times\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ms", " ", "=", " ", "10"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"iSize", "=", " ", "350"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"labFontSize", " ", "=", " ", "14"}], ";"}], "\[IndentingNewLine]", 

 RowBox[{
  RowBox[{
   RowBox[{"textstyle", "=", "$TextStyle"}], ";"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"barstyle", "=", "LightGray"}], ";"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"barstyle", "=", 
   RowBox[{
    RowBox[{"ColorData", "[", "\"\<HTML\>\"", "]"}], 
    "[", "\"\<LightSteelBlue\>\"", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetOptions", "[", 
   RowBox[{"Histogram", ",", " ", 
    RowBox[{"ChartStyle", "->", "barstyle"}]}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetOptions", "[", 
   RowBox[{"BarChart", ",", " ", 
    RowBox[{"ChartStyle", "->", "barstyle"}]}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.5517713586813107`*^9, 3.5517714849521017`*^9}, {
   3.551771951043*^9, 3.551771956466942*^9}, 3.551772077751997*^9, {
   3.5520223809767*^9, 3.5520224480666533`*^9}, {3.552029639239017*^9, 
   3.552029655604446*^9}, {3.552029764413485*^9, 3.5520297822572937`*^9}, {
   3.552030322982337*^9, 3.55203032356559*^9}, {3.552099179603568*^9, 
   3.552099186634179*^9}, {3.572088103250422*^9, 3.572088117389421*^9}, 
   3.572088703842696*^9, {3.572333339064139*^9, 3.572333339384529*^9}, {
   3.572424962365041*^9, 3.57242496329135*^9}, {3.9473904694386044`*^9, 
   3.947390469716896*^9}, {3.947390578614436*^9, 3.947390610428872*^9}, {
   3.947577126362227*^9, 3.947577126816843*^9}, 3.951811172330789*^9, {
   3.951811220527495*^9, 3.951811223718421*^9}},
 CellLabel->"In[325]:=",
 $CellContext`InitializationGroup -> 
 True,ExpressionUUID->"642e14f9-cc59-479e-ad68-557b59742cb0"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Section 1", "Section"]], "Chapter",
 CellChangeTimes->{{3.551606318467031*^9, 3.5516063376815357`*^9}, {
   3.551606927739052*^9, 3.551606929779048*^9}, {3.551607356500638*^9, 
   3.551607362899152*^9}, {3.5516077024987803`*^9, 3.551607709561294*^9}, 
   3.9473904389895573`*^9, {3.9473935757603807`*^9, 3.947393577947782*^9}},
 $CellContext`InitializationGroup -> 
 True,ExpressionUUID->"b4b0a4e8-c2a4-4a96-bd4b-ddef6faf7f2b"],

Cell[CellGroupData[{

Cell["c2s1Figure1", "Section",
 CellChangeTimes->{{3.5723420028690567`*^9, 3.572342011627058*^9}, {
   3.947391571097383*^9, 3.947391617058372*^9}, 3.9473923450883703`*^9, 
   3.947393236393119*^9, 3.947575060658597*^9},
 $CellContext`InitializationGroup -> 
 True,ExpressionUUID->"d20ba830-87eb-43b6-b321-e032578c9a15"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", 
   RowBox[{"dice", ",", "n", ",", "dat", ",", "c2s1Figure1", ",", "no"}], 
   "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"dice", "[", "x_Integer", "]"}], ":=", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"Apply", "[", 
      RowBox[{"Plus", ",", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"Random", "[", "Integer", "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", "1", ",", "x"}], "}"}]}], "]"}]}], "]"}], "/", 
     "x"}], "//", "N"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"n", "=", "5000"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"dat", "=", 
    RowBox[{"Transpose", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Table", "[", 
        RowBox[{"i", ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", "1", ",", "n"}], "}"}]}], "]"}], ",", 
       RowBox[{"Map", "[", 
        RowBox[{"dice", ",", 
         RowBox[{"Table", "[", 
          RowBox[{"i", ",", 
           RowBox[{"{", 
            RowBox[{"i", ",", "1", ",", "n"}], "}"}]}], "]"}]}], 
        StyleBox["]", "Input"]}]}], 
      StyleBox["}", "Input"]}], 
     StyleBox["]", "Input"]}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"c2s1Figure1", "=", 
  RowBox[{"Manipulate", "[", 
   RowBox[{
    RowBox[{"Show", "[", 
     RowBox[{
      RowBox[{"ListPlot", "[", 
       RowBox[{
        RowBox[{"Take", "[", 
         RowBox[{"dat", ",", "no"}], "]"}], ",", 
        RowBox[{"Frame", "\[Rule]", " ", "True"}], ",", 
        RowBox[{"FrameLabel", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{"\"\<Trial Number\>\"", ",", "\"\<Relative Frequency\>\""}],
           "}"}]}], ",", "\[IndentingNewLine]", 
        RowBox[{"LabelStyle", "\[Rule]", "labFontSize"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"Joined", "\[Rule]", " ", "True"}], ",", 
        RowBox[{"PlotRange", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1"}], "}"}]}], ",", "\[IndentingNewLine]", 
        RowBox[{"PlotStyle", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{"AbsoluteThickness", "[", "1", "]"}], "}"}]}], ",", 
        RowBox[{"FrameTicks", "\[Rule]", " ", "Automatic"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"Epilog", "\[Rule]", 
         RowBox[{"Inset", "[", 
          RowBox[{
           RowBox[{"AngularGauge", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"dat", "[", 
               RowBox[{"[", "no", "]"}], "]"}], "[", 
              RowBox[{"[", "2", "]"}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"0.4", ",", ".6"}], "}"}], ",", 
             RowBox[{"ScaleOrigin", "\[Rule]", 
              RowBox[{"{", 
               RowBox[{"\[Pi]", ",", "0"}], "}"}]}], ",", 
             RowBox[{"ImageSize", "\[Rule]", " ", "100"}]}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"no", " ", ".8"}], ",", ".8"}], "}"}]}], "]"}]}]}], 
       "]"}], ",", 
      RowBox[{"ImageSize", "\[Rule]", " ", "Full"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"no", ",", "200", ",", "\"\<Number of Trials\>\""}], "}"}], ",",
       "100", ",", "5000", ",", "100"}], "}"}], ",", 
    RowBox[{"ContentSize", "\[Rule]", "iSize"}], ",", " ", 
    RowBox[{"SaveDefinitions", "\[Rule]", " ", "True"}]}], "]"}]}]}], "Input",\

 CellChangeTimes->{{3.552033186760354*^9, 3.552033192191132*^9}, {
   3.55203332788169*^9, 3.5520333318739567`*^9}, {3.552033683251492*^9, 
   3.552033737908283*^9}, 3.55209854405126*^9, {3.552098625004458*^9, 
   3.552098641342558*^9}, {3.552098675461482*^9, 3.552098868847788*^9}, {
   3.552098963417955*^9, 3.5520989742299137`*^9}, {3.552099145947969*^9, 
   3.5520991678777733`*^9}, {3.5520992064886627`*^9, 
   3.5520992148814487`*^9}, {3.552099303749185*^9, 3.5520993273806553`*^9}, {
   3.552110914878346*^9, 3.5521109208348913`*^9}, {3.5521159659856167`*^9, 
   3.552116005332266*^9}, {3.5521160451829433`*^9, 3.5521161175914497`*^9}, {
   3.552116157890585*^9, 3.5521161595209017`*^9}, {3.5521980170830507`*^9, 
   3.552198017462161*^9}, {3.552205058886694*^9, 3.552205105800816*^9}, {
   3.589621114677544*^9, 3.589621130390593*^9}, 3.5896211660611753`*^9, {
   3.5896212314191504`*^9, 3.589621253655416*^9}, {3.589621311271389*^9, 
   3.589621350144436*^9}, {3.58962142332586*^9, 3.5896214350786133`*^9}, {
   3.5896214891136627`*^9, 3.589621518224966*^9}, {3.5896215537486267`*^9, 
   3.589621585732224*^9}, {3.589621644616939*^9, 3.589621658927073*^9}, {
   3.947581228810305*^9, 3.947581233100583*^9}},
 CellLabel->"In[92]:=",
 CellID->295814055,
 $CellContext`InitializationGroup -> 
 True,ExpressionUUID->"b2f5f2b8-1f96-48fb-8298-d014d6936119"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`no$$ = 200, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`no$$], 200, "Number of Trials"}, 100, 5000, 100, 
      ControlType -> Manipulator}}, Typeset`size$$ = {
    330., {107.83694307014119`, 113.56887666389119`}}, Typeset`update$$ = 0, 
    Typeset`initDone$$, Typeset`skipInitDone$$ = False, 
    Typeset`keyframeActionsQ$$ = False, Typeset`keyframeList$$ = {}}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`no$$ = 200}, 
      "ControllerVariables" :> {}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$, Typeset`keyframeActionsQ$$, 
        Typeset`keyframeList$$}, "Body" :> Show[
        ListPlot[
         Take[$CellContext`dat, $CellContext`no$$], Frame -> True, 
         FrameLabel -> {"Trial Number", "Relative Frequency"}, 
         LabelStyle -> $CellContext`labFontSize, Joined -> True, 
         PlotRange -> {0, 1}, PlotStyle -> {
           AbsoluteThickness[1]}, FrameTicks -> Automatic, Epilog -> Inset[
           AngularGauge[
            Part[
             Part[$CellContext`dat, $CellContext`no$$], 2], {0.4, 0.6}, 
            ScaleOrigin -> {Pi, 0}, ImageSize -> 100], {$CellContext`no$$ 0.8,
             0.8}]], ImageSize -> Full], 
      "Specifications" :> {{{$CellContext`no$$, 200, "Number of Trials"}, 100,
          5000, 100}}, "Options" :> {ContentSize -> 350}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{370., {154.20736848518024`, 159.93930207893024`}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    Initialization:>({$CellContext`dat = {{1, 0.}, {2, 0.}, {
         3, 0.6666666666666666}, {4, 0.5}, {5, 0.4}, {6, 0.5}, {
         7, 0.5714285714285714}, {8, 0.625}, {9, 0.6666666666666666}, {
         10, 0.6}, {11, 0.36363636363636365`}, {12, 0.75}, {
         13, 0.7692307692307693}, {14, 0.42857142857142855`}, {
         15, 0.5333333333333333}, {16, 0.5625}, {17, 0.5294117647058824}, {
         18, 0.5555555555555556}, {19, 0.5263157894736842}, {20, 0.5}, {
         21, 0.6190476190476191}, {22, 0.5}, {23, 0.43478260869565216`}, {
         24, 0.5416666666666666}, {25, 0.48}, {26, 0.5769230769230769}, {
         27, 0.48148148148148145`}, {28, 0.5}, {29, 0.5172413793103449}, {
         30, 0.5333333333333333}, {31, 0.5483870967741935}, {32, 0.46875}, {
         33, 0.48484848484848486`}, {34, 0.5588235294117647}, {
         35, 0.4857142857142857}, {36, 0.5277777777777778}, {
         37, 0.43243243243243246`}, {38, 0.47368421052631576`}, {
         39, 0.5128205128205128}, {40, 0.45}, {41, 0.5365853658536586}, {
         42, 0.5714285714285714}, {43, 0.5813953488372093}, {
         44, 0.36363636363636365`}, {45, 0.4444444444444444}, {
         46, 0.43478260869565216`}, {47, 0.6170212765957447}, {
         48, 0.4791666666666667}, {49, 0.4897959183673469}, {50, 0.46}, {
         51, 0.5490196078431373}, {52, 0.5769230769230769}, {
         53, 0.4716981132075472}, {54, 0.42592592592592593`}, {
         55, 0.41818181818181815`}, {56, 0.5535714285714286}, {
         57, 0.49122807017543857`}, {58, 0.5689655172413793}, {
         59, 0.5932203389830508}, {60, 0.5666666666666667}, {
         61, 0.5245901639344263}, {62, 0.5645161290322581}, {
         63, 0.5238095238095238}, {64, 0.5625}, {65, 0.47692307692307695`}, {
         66, 0.42424242424242425`}, {67, 0.44776119402985076`}, {
         68, 0.47058823529411764`}, {69, 0.4782608695652174}, {
         70, 0.5571428571428572}, {71, 0.4788732394366197}, {
         72, 0.5555555555555556}, {73, 0.410958904109589}, {
         74, 0.6081081081081081}, {75, 0.4666666666666667}, {
         76, 0.5263157894736842}, {77, 0.4675324675324675}, {
         78, 0.4358974358974359}, {79, 0.5569620253164557}, {80, 0.45}, {
         81, 0.4691358024691358}, {82, 0.45121951219512196`}, {
         83, 0.46987951807228917`}, {84, 0.4166666666666667}, {
         85, 0.5176470588235295}, {86, 0.47674418604651164`}, {
         87, 0.4942528735632184}, {88, 0.5227272727272727}, {
         89, 0.3707865168539326}, {90, 0.4666666666666667}, {
         91, 0.5274725274725275}, {92, 0.44565217391304346`}, {
         93, 0.5698924731182796}, {94, 0.6170212765957447}, {
         95, 0.5052631578947369}, {96, 0.5104166666666666}, {
         97, 0.4948453608247423}, {98, 0.4897959183673469}, {
         99, 0.5050505050505051}, {100, 0.5}, {101, 0.36633663366336633`}, {
         102, 0.47058823529411764`}, {103, 0.5242718446601942}, {
         104, 0.5096153846153846}, {105, 0.6285714285714286}, {
         106, 0.5660377358490566}, {107, 0.48598130841121495`}, {
         108, 0.5555555555555556}, {109, 0.44954128440366975`}, {
         110, 0.4727272727272727}, {111, 0.4594594594594595}, {
         112, 0.5446428571428571}, {113, 0.4690265486725664}, {
         114, 0.45614035087719296`}, {115, 0.4782608695652174}, {
         116, 0.5086206896551724}, {117, 0.5042735042735043}, {
         118, 0.5254237288135594}, {119, 0.44537815126050423`}, {
         120, 0.5166666666666667}, {121, 0.4793388429752066}, {
         122, 0.5081967213114754}, {123, 0.5203252032520326}, {
         124, 0.5241935483870968}, {125, 0.488}, {
         126, 0.42857142857142855`}, {127, 0.5748031496062992}, {
         128, 0.421875}, {129, 0.49612403100775193`}, {
         130, 0.5538461538461539}, {131, 0.5572519083969466}, {
         132, 0.5303030303030303}, {133, 0.5037593984962406}, {
         134, 0.4925373134328358}, {135, 0.48148148148148145`}, {
         136, 0.4117647058823529}, {137, 0.46715328467153283`}, {
         138, 0.391304347826087}, {139, 0.4892086330935252}, {
         140, 0.5071428571428571}, {141, 0.5177304964539007}, {
         142, 0.5211267605633803}, {143, 0.4825174825174825}, {
         144, 0.5486111111111112}, {145, 0.42758620689655175`}, {
         146, 0.4178082191780822}, {147, 0.47619047619047616`}, {148, 0.5}, {
         149, 0.4697986577181208}, {150, 0.47333333333333333`}, {
         151, 0.46357615894039733`}, {152, 0.48026315789473684`}, {
         153, 0.5163398692810458}, {154, 0.43506493506493504`}, {
         155, 0.5161290322580645}, {156, 0.46794871794871795`}, {
         157, 0.49044585987261147`}, {158, 0.569620253164557}, {
         159, 0.48427672955974843`}, {160, 0.53125}, {
         161, 0.577639751552795}, {162, 0.5432098765432098}, {
         163, 0.5460122699386503}, {164, 0.4817073170731707}, {
         165, 0.48484848484848486`}, {166, 0.43373493975903615`}, {
         167, 0.49700598802395207`}, {168, 0.5}, {169, 0.5562130177514792}, {
         170, 0.48823529411764705`}, {171, 0.5029239766081871}, {
         172, 0.5465116279069767}, {173, 0.5086705202312138}, {
         174, 0.4942528735632184}, {175, 0.46285714285714286`}, {
         176, 0.5511363636363636}, {177, 0.4519774011299435}, {
         178, 0.5280898876404494}, {179, 0.553072625698324}, {
         180, 0.4666666666666667}, {181, 0.4530386740331492}, {
         182, 0.521978021978022}, {183, 0.48633879781420764`}, {
         184, 0.44565217391304346`}, {185, 0.4756756756756757}, {
         186, 0.5268817204301075}, {187, 0.48128342245989303`}, {
         188, 0.48404255319148937`}, {189, 0.5661375661375662}, {
         190, 0.5052631578947369}, {191, 0.418848167539267}, {
         192, 0.5416666666666666}, {193, 0.44559585492227977`}, {
         194, 0.5309278350515464}, {195, 0.5333333333333333}, {
         196, 0.5204081632653061}, {197, 0.48223350253807107`}, {
         198, 0.5353535353535354}, {199, 0.5125628140703518}, {200, 0.555}, {
         201, 0.5422885572139303}, {202, 0.43564356435643564`}, {
         203, 0.5172413793103449}, {204, 0.49019607843137253`}, {
         205, 0.4682926829268293}, {206, 0.558252427184466}, {
         207, 0.5072463768115942}, {208, 0.46153846153846156`}, {
         209, 0.507177033492823}, {210, 0.5047619047619047}, {
         211, 0.4834123222748815}, {212, 0.46226415094339623`}, {
         213, 0.539906103286385}, {214, 0.5280373831775701}, {
         215, 0.4883720930232558}, {216, 0.5231481481481481}, {
         217, 0.5714285714285714}, {218, 0.555045871559633}, {
         219, 0.4977168949771689}, {220, 0.4909090909090909}, {
         221, 0.4751131221719457}, {222, 0.4594594594594595}, {
         223, 0.515695067264574}, {224, 0.53125}, {
         225, 0.49333333333333335`}, {226, 0.5353982300884956}, {
         227, 0.5594713656387665}, {228, 0.4517543859649123}, {
         229, 0.49344978165938863`}, {230, 0.4608695652173913}, {
         231, 0.45021645021645024`}, {232, 0.46551724137931033`}, {
         233, 0.5364806866952789}, {234, 0.44017094017094016`}, {
         235, 0.4978723404255319}, {236, 0.5254237288135594}, {
         237, 0.5611814345991561}, {238, 0.4831932773109244}, {
         239, 0.4811715481171548}, {240, 0.49166666666666664`}, {
         241, 0.48132780082987553`}, {242, 0.5454545454545454}, {
         243, 0.551440329218107}, {244, 0.48770491803278687`}, {
         245, 0.5183673469387755}, {246, 0.483739837398374}, {
         247, 0.4817813765182186}, {248, 0.47580645161290325`}, {
         249, 0.4979919678714859}, {250, 0.42}, {251, 0.4940239043824701}, {
         252, 0.5079365079365079}, {253, 0.4980237154150198}, {
         254, 0.515748031496063}, {255, 0.4823529411764706}, {
         256, 0.4921875}, {257, 0.5019455252918288}, {
         258, 0.49612403100775193`}, {259, 0.5096525096525096}, {
         260, 0.4576923076923077}, {261, 0.47509578544061304`}, {
         262, 0.48854961832061067`}, {263, 0.4752851711026616}, {
         264, 0.5378787878787878}, {265, 0.4981132075471698}, {
         266, 0.5075187969924813}, {267, 0.50187265917603}, {
         268, 0.5149253731343284}, {269, 0.5390334572490706}, {
         270, 0.5370370370370371}, {271, 0.4981549815498155}, {
         272, 0.4852941176470588}, {273, 0.47985347985347987`}, {
         274, 0.4854014598540146}, {275, 0.4909090909090909}, {
         276, 0.48188405797101447`}, {277, 0.4657039711191336}, {
         278, 0.48201438848920863`}, {279, 0.5161290322580645}, {
         280, 0.5178571428571429}, {281, 0.4804270462633452}, {
         282, 0.5141843971631206}, {283, 0.4911660777385159}, {
         284, 0.5035211267605634}, {285, 0.4842105263157895}, {
         286, 0.5104895104895105}, {287, 0.5087108013937283}, {
         288, 0.5104166666666666}, {289, 0.5190311418685121}, {
         290, 0.506896551724138}, {291, 0.48109965635738833`}, {
         292, 0.4554794520547945}, {293, 0.49829351535836175`}, {
         294, 0.46258503401360546`}, {295, 0.4915254237288136}, {
         296, 0.5405405405405406}, {297, 0.45454545454545453`}, {
         298, 0.5268456375838926}, {299, 0.48494983277591974`}, {
         300, 0.4766666666666667}, {301, 0.5049833887043189}, {
         302, 0.5099337748344371}, {303, 0.5214521452145214}, {
         304, 0.46381578947368424`}, {305, 0.5245901639344263}, {
         306, 0.4869281045751634}, {307, 0.5179153094462541}, {
         308, 0.4805194805194805}, {309, 0.5436893203883495}, {
         310, 0.4612903225806452}, {311, 0.4758842443729904}, {
         312, 0.5352564102564102}, {313, 0.5431309904153354}, {
         314, 0.48089171974522293`}, {315, 0.5111111111111111}, {
         316, 0.5411392405063291}, {317, 0.5173501577287066}, {
         318, 0.5031446540880503}, {319, 0.5109717868338558}, {
         320, 0.528125}, {321, 0.5202492211838006}, {
         322, 0.5062111801242236}, {323, 0.49226006191950467`}, {
         324, 0.5740740740740741}, {325, 0.5169230769230769}, {
         326, 0.5153374233128835}, {327, 0.4892966360856269}, {
         328, 0.4420731707317073}, {329, 0.48328267477203646`}, {
         330, 0.49393939393939396`}, {331, 0.4471299093655589}, {
         332, 0.44879518072289154`}, {333, 0.47147147147147145`}, {
         334, 0.4550898203592814}, {335, 0.4208955223880597}, {
         336, 0.5029761904761905}, {337, 0.486646884272997}, {
         338, 0.47633136094674555`}, {339, 0.4808259587020649}, {
         340, 0.5235294117647059}, {341, 0.5131964809384164}, {
         342, 0.4649122807017544}, {343, 0.47230320699708456`}, {
         344, 0.48255813953488375`}, {345, 0.5565217391304348}, {
         346, 0.4624277456647399}, {347, 0.5014409221902018}, {
         348, 0.46264367816091956`}, {349, 0.4871060171919771}, {
         350, 0.5514285714285714}, {351, 0.50997150997151}, {
         352, 0.48011363636363635`}, {353, 0.4702549575070821}, {
         354, 0.5282485875706214}, {355, 0.5380281690140845}, {
         356, 0.4943820224719101}, {357, 0.49019607843137253`}, {
         358, 0.5223463687150838}, {359, 0.4456824512534819}, {
         360, 0.5111111111111111}, {361, 0.4903047091412742}, {
         362, 0.4889502762430939}, {363, 0.4986225895316804}, {
         364, 0.5274725274725275}, {365, 0.4547945205479452}, {
         366, 0.4781420765027322}, {367, 0.5395095367847411}, {
         368, 0.4782608695652174}, {369, 0.5311653116531165}, {
         370, 0.5162162162162162}, {371, 0.49595687331536387`}, {
         372, 0.4946236559139785}, {373, 0.5093833780160858}, {
         374, 0.49732620320855614`}, {375, 0.48533333333333334`}, {
         376, 0.47606382978723405`}, {377, 0.5278514588859416}, {
         378, 0.48148148148148145`}, {379, 0.42216358839050133`}, {
         380, 0.5394736842105263}, {381, 0.5065616797900262}, {
         382, 0.5418848167539267}, {383, 0.48825065274151436`}, {
         384, 0.4791666666666667}, {385, 0.4909090909090909}, {
         386, 0.49222797927461137`}, {387, 0.49870801033591733`}, {
         388, 0.5180412371134021}, {389, 0.4910025706940874}, {
         390, 0.517948717948718}, {391, 0.5038363171355499}, {
         392, 0.5255102040816326}, {393, 0.5241730279898219}, {
         394, 0.5076142131979695}, {395, 0.5189873417721519}, {
         396, 0.4772727272727273}, {397, 0.5264483627204031}, {
         398, 0.48743718592964824`}, {399, 0.518796992481203}, {
         400, 0.4925}, {401, 0.5187032418952618}, {402, 0.4925373134328358}, {
         403, 0.5136476426799007}, {404, 0.48267326732673266`}, {
         405, 0.528395061728395}, {406, 0.5073891625615764}, {
         407, 0.4914004914004914}, {408, 0.5073529411764706}, {
         409, 0.48655256723716384`}, {410, 0.5121951219512195}, {
         411, 0.48661800486618007`}, {412, 0.49514563106796117`}, {
         413, 0.5423728813559322}, {414, 0.47101449275362317`}, {
         415, 0.4795180722891566}, {416, 0.47596153846153844`}, {
         417, 0.5179856115107914}, {418, 0.48564593301435405`}, {
         419, 0.5011933174224343}, {420, 0.49047619047619045`}, {
         421, 0.505938242280285}, {422, 0.5260663507109005}, {
         423, 0.4728132387706856}, {424, 0.4811320754716981}, {
         425, 0.4752941176470588}, {426, 0.4624413145539906}, {
         427, 0.49882903981264637`}, {428, 0.4929906542056075}, {
         429, 0.4755244755244755}, {430, 0.46511627906976744`}, {
         431, 0.5104408352668214}, {432, 0.5185185185185185}, {
         433, 0.5080831408775982}, {434, 0.5276497695852534}, {
         435, 0.5057471264367817}, {436, 0.49311926605504586`}, {
         437, 0.494279176201373}, {438, 0.5114155251141552}, {
         439, 0.4874715261958998}, {440, 0.49318181818181817`}, {
         441, 0.4965986394557823}, {442, 0.5407239819004525}, {
         443, 0.5237020316027088}, {444, 0.5247747747747747}, {
         445, 0.5101123595505618}, {446, 0.4910313901345291}, {
         447, 0.5078299776286354}, {448, 0.4888392857142857}, {
         449, 0.47438752783964366`}, {450, 0.5222222222222223}, {
         451, 0.49445676274944567`}, {452, 0.5199115044247787}, {
         453, 0.4746136865342163}, {454, 0.4911894273127753}, {
         455, 0.5208791208791209}, {456, 0.5219298245614035}, {
         457, 0.5251641137855579}, {458, 0.4585152838427948}, {
         459, 0.4684095860566449}, {460, 0.532608695652174}, {
         461, 0.4750542299349241}, {462, 0.47619047619047616`}, {
         463, 0.4557235421166307}, {464, 0.5}, {465, 0.4989247311827957}, {
         466, 0.49356223175965663`}, {467, 0.4582441113490364}, {
         468, 0.47435897435897434`}, {469, 0.47547974413646055`}, {
         470, 0.48723404255319147`}, {471, 0.4564755838641189}, {
         472, 0.5042372881355932}, {473, 0.5031712473572939}, {
         474, 0.5274261603375527}, {475, 0.5557894736842105}, {476, 0.5}, {
         477, 0.49266247379454925`}, {478, 0.5125523012552301}, {
         479, 0.5198329853862212}, {480, 0.5291666666666667}, {
         481, 0.5072765072765073}, {482, 0.520746887966805}, {
         483, 0.4824016563146998}, {484, 0.47107438016528924`}, {
         485, 0.5051546391752577}, {486, 0.4670781893004115}, {
         487, 0.486652977412731}, {488, 0.48565573770491804`}, {
         489, 0.49897750511247446`}, {490, 0.5102040816326531}, {
         491, 0.5091649694501018}, {492, 0.47560975609756095`}, {
         493, 0.4847870182555781}, {494, 0.5060728744939271}, {
         495, 0.5151515151515151}, {496, 0.5161290322580645}, {
         497, 0.5251509054325956}, {498, 0.4959839357429719}, {
         499, 0.501002004008016}, {500, 0.5}, {501, 0.5049900199600799}, {
         502, 0.5079681274900398}, {503, 0.5049701789264414}, {
         504, 0.498015873015873}, {505, 0.5188118811881188}, {
         506, 0.5039525691699605}, {507, 0.5384615384615384}, {
         508, 0.49015748031496065`}, {509, 0.5284872298624754}, {
         510, 0.5411764705882353}, {511, 0.5264187866927593}, {
         512, 0.47265625}, {513, 0.5243664717348928}, {
         514, 0.4591439688715953}, {515, 0.5631067961165048}, {
         516, 0.5058139534883721}, {517, 0.5203094777562862}, {
         518, 0.528957528957529}, {519, 0.4624277456647399}, {
         520, 0.49423076923076925`}, {521, 0.4798464491362764}, {
         522, 0.5172413793103449}, {523, 0.49904397705544934`}, {
         524, 0.4580152671755725}, {525, 0.4857142857142857}, {
         526, 0.47338403041825095`}, {527, 0.47058823529411764`}, {
         528, 0.5208333333333334}, {529, 0.46880907372400754`}, {530, 0.5}, {
         531, 0.4745762711864407}, {532, 0.5131578947368421}, {
         533, 0.49343339587242024`}, {534, 0.5131086142322098}, {
         535, 0.5065420560747663}, {536, 0.4944029850746269}, {
         537, 0.4823091247672253}, {538, 0.5185873605947955}, {
         539, 0.5046382189239332}, {540, 0.562962962962963}, {
         541, 0.5064695009242144}, {542, 0.4944649446494465}, {
         543, 0.5156537753222836}, {544, 0.5055147058823529}, {
         545, 0.5082568807339449}, {546, 0.489010989010989}, {
         547, 0.5502742230347349}, {548, 0.5383211678832117}, {
         549, 0.5428051001821493}, {550, 0.46545454545454545`}, {
         551, 0.5208711433756806}, {552, 0.5108695652173914}, {
         553, 0.488245931283906}, {554, 0.5108303249097473}, {
         555, 0.47387387387387386`}, {556, 0.5035971223021583}, {
         557, 0.48114901256732495`}, {558, 0.5}, {559, 0.5152057245080501}, {
         560, 0.5339285714285714}, {561, 0.49910873440285203`}, {
         562, 0.49644128113879005`}, {563, 0.5257548845470693}, {
         564, 0.5230496453900709}, {565, 0.5256637168141592}, {
         566, 0.4911660777385159}, {567, 0.4973544973544973}, {
         568, 0.49119718309859156`}, {569, 0.5588752196836555}, {
         570, 0.49122807017543857`}, {571, 0.5131348511383538}, {
         572, 0.5087412587412588}, {573, 0.5322862129144852}, {
         574, 0.5087108013937283}, {575, 0.48869565217391303`}, {
         576, 0.515625}, {577, 0.4488734835355286}, {
         578, 0.5051903114186851}, {579, 0.47322970639032813`}, {
         580, 0.5120689655172413}, {581, 0.49225473321858865`}, {
         582, 0.4965635738831615}, {583, 0.4939965694682676}, {
         584, 0.5325342465753424}, {585, 0.4888888888888889}, {
         586, 0.5051194539249146}, {587, 0.47700170357751276`}, {
         588, 0.477891156462585}, {589, 0.499151103565365}, {
         590, 0.4915254237288136}, {591, 0.5076142131979695}, {
         592, 0.4983108108108108}, {593, 0.48903878583473864`}, {
         594, 0.5016835016835017}, {595, 0.4957983193277311}, {
         596, 0.4848993288590604}, {597, 0.5159128978224455}, {
         598, 0.5150501672240803}, {599, 0.48080133555926546`}, {
         600, 0.5183333333333333}, {601, 0.4841930116472546}, {
         602, 0.4883720930232558}, {603, 0.5157545605306799}, {
         604, 0.4917218543046358}, {605, 0.45289256198347105`}, {
         606, 0.47854785478547857`}, {607, 0.4827018121911038}, {
         608, 0.4868421052631579}, {609, 0.4975369458128079}, {
         610, 0.5032786885245901}, {611, 0.5122749590834698}, {
         612, 0.5032679738562091}, {613, 0.466557911908646}, {
         614, 0.503257328990228}, {615, 0.5008130081300813}, {
         616, 0.49512987012987014`}, {617, 0.5008103727714749}, {
         618, 0.47896440129449835`}, {619, 0.5088852988691438}, {
         620, 0.5096774193548387}, {621, 0.499194847020934}, {
         622, 0.5048231511254019}, {623, 0.4911717495987159}, {
         624, 0.5112179487179487}, {625, 0.504}, {
         626, 0.48722044728434505`}, {627, 0.5119617224880383}, {
         628, 0.5143312101910829}, {629, 0.519872813990461}, {
         630, 0.5253968253968254}, {631, 0.5277337559429477}, {
         632, 0.5189873417721519}, {633, 0.4597156398104265}, {
         634, 0.5078864353312302}, {635, 0.494488188976378}, {
         636, 0.5157232704402516}, {637, 0.48194662480376765`}, {
         638, 0.47335423197492166`}, {639, 0.48200312989045385`}, {
         640, 0.5125}, {641, 0.5054602184087363}, {642, 0.5264797507788161}, {
         643, 0.4867807153965785}, {644, 0.5139751552795031}, {
         645, 0.4806201550387597}, {646, 0.5263157894736842}, {
         647, 0.48377125193199383`}, {648, 0.4737654320987654}, {
         649, 0.5130970724191063}, {650, 0.47846153846153844`}, {
         651, 0.4823348694316436}, {652, 0.5168711656441718}, {
         653, 0.5283307810107197}, {654, 0.4984709480122324}, {
         655, 0.5068702290076336}, {656, 0.5091463414634146}, {
         657, 0.4855403348554033}, {658, 0.4817629179331307}, {
         659, 0.49165402124430957`}, {660, 0.47424242424242424`}, {
         661, 0.4962178517397882}, {662, 0.4818731117824773}, {
         663, 0.5082956259426847}, {664, 0.5301204819277109}, {
         665, 0.48120300751879697`}, {666, 0.527027027027027}, {
         667, 0.49325337331334335`}, {668, 0.468562874251497}, {
         669, 0.47384155455904337`}, {670, 0.49701492537313435`}, {
         671, 0.5126676602086438}, {672, 0.4955357142857143}, {
         673, 0.5349182763744428}, {674, 0.4970326409495549}, {
         675, 0.4888888888888889}, {676, 0.5029585798816568}, {
         677, 0.5022156573116692}, {678, 0.5176991150442478}, {
         679, 0.49337260677466865`}, {680, 0.5029411764705882}, {
         681, 0.5139500734214391}, {682, 0.5219941348973607}, {
         683, 0.49194729136163984`}, {684, 0.5}, {685, 0.5021897810218978}, {
         686, 0.478134110787172}, {687, 0.4890829694323144}, {
         688, 0.5145348837209303}, {689, 0.4876632801161103}, {
         690, 0.5231884057971015}, {691, 0.4717800289435601}, {
         692, 0.5101156069364162}, {693, 0.5108225108225108}, {
         694, 0.4711815561959654}, {695, 0.5021582733812949}, {
         696, 0.4956896551724138}, {697, 0.48637015781922527`}, {
         698, 0.5071633237822349}, {699, 0.49642346208869814`}, {
         700, 0.5185714285714286}, {701, 0.5192582025677603}, {
         702, 0.49002849002849}, {703, 0.5163584637268848}, {
         704, 0.4872159090909091}, {705, 0.5120567375886524}, {
         706, 0.4886685552407932}, {707, 0.5134370579915134}, {
         708, 0.4774011299435028}, {709, 0.4767277856135402}, {
         710, 0.532394366197183}, {711, 0.4964838255977497}, {
         712, 0.5098314606741573}, {713, 0.4964936886395512}, {
         714, 0.5154061624649859}, {715, 0.5020979020979021}, {
         716, 0.4762569832402235}, {717, 0.5285913528591353}, {
         718, 0.49164345403899723`}, {719, 0.48956884561891517`}, {
         720, 0.49027777777777776`}, {721, 0.4798890429958391}, {
         722, 0.5013850415512465}, {723, 0.49100968188105115`}, {
         724, 0.5220994475138122}, {725, 0.5310344827586206}, {
         726, 0.5041322314049587}, {727, 0.4896836313617607}, {
         728, 0.489010989010989}, {729, 0.5006858710562414}, {
         730, 0.4863013698630137}, {731, 0.5020519835841313}, {
         732, 0.505464480874317}, {733, 0.5129604365620737}, {
         734, 0.5040871934604905}, {735, 0.5102040816326531}, {
         736, 0.5244565217391305}, {737, 0.49525101763907736`}, {
         738, 0.508130081300813}, {739, 0.4939106901217862}, {
         740, 0.48783783783783785`}, {741, 0.50472334682861}, {
         742, 0.4919137466307278}, {743, 0.5074024226110363}, {
         744, 0.5040322580645161}, {745, 0.5114093959731544}, {746, 0.5}, {
         747, 0.5167336010709505}, {748, 0.5307486631016043}, {
         749, 0.46194926568758343`}, {750, 0.496}, {
         751, 0.49001331557922767`}, {752, 0.49601063829787234`}, {
         753, 0.4953519256308101}, {754, 0.48938992042440316`}, {
         755, 0.4781456953642384}, {756, 0.5158730158730159}, {
         757, 0.535006605019815}, {758, 0.4841688654353562}, {
         759, 0.49670619235836627`}, {760, 0.48947368421052634`}, {
         761, 0.5019710906701709}, {762, 0.4921259842519685}, {
         763, 0.4639580602883355}, {764, 0.5287958115183246}, {
         765, 0.48366013071895425`}, {766, 0.5117493472584856}, {
         767, 0.5045632333767927}, {768, 0.5286458333333334}, {
         769, 0.47464239271781533`}, {770, 0.5181818181818182}, {
         771, 0.5239948119325551}, {772, 0.5103626943005182}, {
         773, 0.5097024579560155}, {774, 0.4896640826873385}, {
         775, 0.472258064516129}, {776, 0.5038659793814433}, {
         777, 0.49034749034749037`}, {778, 0.5282776349614395}, {
         779, 0.49293966623876767`}, {780, 0.5128205128205128}, {
         781, 0.4942381562099872}, {782, 0.5268542199488491}, {
         783, 0.5070242656449553}, {784, 0.5038265306122449}, {
         785, 0.4789808917197452}, {786, 0.49236641221374045`}, {
         787, 0.5209656925031766}, {788, 0.516497461928934}, {
         789, 0.49809885931558934`}, {790, 0.5075949367088608}, {
         791, 0.4740834386852086}, {792, 0.4911616161616162}, {
         793, 0.5044136191677175}, {794, 0.5188916876574308}, {
         795, 0.5031446540880503}, {796, 0.5087939698492462}, {
         797, 0.5219573400250941}, {798, 0.49624060150375937`}, {
         799, 0.5118898623279099}, {800, 0.52375}, {
         801, 0.4794007490636704}, {802, 0.49002493765586036`}, {
         803, 0.48816936488169366`}, {804, 0.4975124378109453}, {
         805, 0.5080745341614907}, {806, 0.4739454094292804}, {
         807, 0.48203221809169766`}, {808, 0.49504950495049505`}, {
         809, 0.4721878862793572}, {810, 0.4740740740740741}, {
         811, 0.4969173859432799}, {812, 0.5098522167487685}, {
         813, 0.4735547355473555}, {814, 0.4606879606879607}, {
         815, 0.5030674846625767}, {816, 0.47671568627450983`}, {
         817, 0.5336597307221542}, {818, 0.48655256723716384`}, {
         819, 0.5201465201465202}, {820, 0.4951219512195122}, {
         821, 0.4445797807551766}, {822, 0.5060827250608273}, {
         823, 0.5297691373025516}, {824, 0.49271844660194175`}, {
         825, 0.4909090909090909}, {826, 0.5084745762711864}, {
         827, 0.5139056831922612}, {828, 0.5120772946859904}, {
         829, 0.5150784077201448}, {830, 0.4602409638554217}, {
         831, 0.49458483754512633`}, {832, 0.49399038461538464`}, {
         833, 0.4921968787515006}, {834, 0.5047961630695443}, {
         835, 0.5401197604790419}, {836, 0.5191387559808612}, {
         837, 0.48984468339307047`}, {838, 0.5011933174224343}, {
         839, 0.5113230035756854}, {840, 0.49642857142857144`}, {
         841, 0.5457788347205708}, {842, 0.49287410926365793`}, {
         843, 0.5041518386714117}, {844, 0.49644549763033174`}, {
         845, 0.5100591715976331}, {846, 0.475177304964539}, {
         847, 0.5053128689492326}, {848, 0.4882075471698113}, {
         849, 0.4829210836277974}, {850, 0.4929411764705882}, {
         851, 0.5158636897767332}, {852, 0.5093896713615024}, {
         853, 0.5357561547479485}, {854, 0.49063231850117095`}, {
         855, 0.52046783625731}, {856, 0.514018691588785}, {
         857, 0.49941656942823803`}, {858, 0.5081585081585082}, {
         859, 0.5087310826542492}, {860, 0.5279069767441861}, {
         861, 0.48548199767711964`}, {862, 0.4988399071925754}, {
         863, 0.5098493626882966}, {864, 0.5057870370370371}, {
         865, 0.5086705202312138}, {866, 0.49191685912240185`}, {
         867, 0.5040369088811996}, {868, 0.5011520737327189}, {
         869, 0.522439585730725}, {870, 0.5}, {871, 0.4856486796785304}, {
         872, 0.4805045871559633}, {873, 0.4856815578465063}, {
         874, 0.5377574370709383}, {875, 0.5245714285714286}, {
         876, 0.4874429223744292}, {877, 0.49942987457240595`}, {
         878, 0.5125284738041003}, {879, 0.5085324232081911}, {
         880, 0.4784090909090909}, {881, 0.47559591373439275`}, {
         882, 0.518140589569161}, {883, 0.5084937712344281}, {
         884, 0.5237556561085973}, {885, 0.49830508474576274`}, {
         886, 0.4762979683972912}, {887, 0.5152198421645998}, {
         888, 0.47635135135135137`}, {889, 0.5061867266591676}, {
         890, 0.4786516853932584}, {891, 0.5084175084175084}, {
         892, 0.5179372197309418}, {893, 0.5184770436730123}, {
         894, 0.4966442953020134}, {895, 0.5374301675977654}, {
         896, 0.48549107142857145`}, {897, 0.5083612040133779}, {
         898, 0.4844097995545657}, {899, 0.5139043381535039}, {
         900, 0.5055555555555555}, {901, 0.5049944506104328}, {
         902, 0.5221729490022173}, {903, 0.4839424141749723}, {
         904, 0.461283185840708}, {905, 0.46519337016574586`}, {
         906, 0.5044150110375276}, {907, 0.4696802646085998}, {
         908, 0.4779735682819383}, {909, 0.48624862486248627`}, {
         910, 0.5065934065934066}, {911, 0.5038419319429198}, {
         912, 0.5263157894736842}, {913, 0.5071193866374589}, {
         914, 0.5032822757111597}, {915, 0.4907103825136612}, {
         916, 0.5229257641921398}, {917, 0.5158124318429662}, {
         918, 0.5446623093681917}, {919, 0.5016322089227421}, {
         920, 0.5195652173913043}, {921, 0.5179153094462541}, {
         922, 0.5043383947939263}, {923, 0.5178764897074756}, {
         924, 0.49783549783549785`}, {925, 0.492972972972973}, {
         926, 0.5043196544276458}, {927, 0.5102481121898598}, {
         928, 0.5129310344827587}, {929, 0.4983853606027987}, {
         930, 0.4935483870967742}, {931, 0.5026852846401718}, {
         932, 0.5300429184549357}, {933, 0.49517684887459806`}, {
         934, 0.49678800856531047`}, {935, 0.4994652406417112}, {
         936, 0.5106837606837606}, {937, 0.5133404482390609}, {
         938, 0.5063965884861408}, {939, 0.5058572949946751}, {
         940, 0.5234042553191489}, {941, 0.49415515409139216`}, {
         942, 0.470276008492569}, {943, 0.5090137857900318}, {
         944, 0.4989406779661017}, {945, 0.4962962962962963}, {
         946, 0.48731501057082455`}, {947, 0.5174234424498416}, {
         948, 0.4704641350210971}, {949, 0.4952581664910432}, {
         950, 0.5126315789473684}, {951, 0.4784437434279706}, {
         952, 0.47794117647058826`}, {953, 0.4753410283315845}, {
         954, 0.4937106918238994}, {955, 0.4900523560209424}, {
         956, 0.5062761506276151}, {957, 0.5067920585161965}, {
         958, 0.5156576200417536}, {959, 0.49530761209593327`}, {
         960, 0.49166666666666664`}, {961, 0.49427679500520294`}, {
         962, 0.5228690228690228}, {963, 0.5233644859813084}, {
         964, 0.5051867219917012}, {965, 0.48393782383419687`}, {
         966, 0.520703933747412}, {967, 0.4860392967942089}, {
         968, 0.4927685950413223}, {969, 0.49742002063983487`}, {
         970, 0.4896907216494845}, {971, 0.5221421215242018}, {
         972, 0.4845679012345679}, {973, 0.5097636176772867}, {
         974, 0.48973305954825463`}, {975, 0.521025641025641}, {
         976, 0.5061475409836066}, {977, 0.5076765609007164}, {
         978, 0.4652351738241309}, {979, 0.48621041879468846`}, {
         980, 0.5051020408163265}, {981, 0.4943934760448522}, {
         982, 0.5040733197556008}, {983, 0.5320447609359105}, {
         984, 0.4928861788617886}, {985, 0.49137055837563454`}, {
         986, 0.5141987829614605}, {987, 0.5065856129685917}, {
         988, 0.4716599190283401}, {989, 0.5136501516683518}, {
         990, 0.5111111111111111}, {991, 0.515640766902119}, {
         992, 0.49899193548387094`}, {993, 0.499496475327291}, {
         994, 0.4909456740442656}, {995, 0.4894472361809045}, {
         996, 0.4939759036144578}, {997, 0.5055165496489469}, {
         998, 0.48096192384769537`}, {999, 0.5185185185185185}, {
         1000, 0.49}, {1001, 0.5004995004995005}, {
         1002, 0.5089820359281437}, {1003, 0.5154536390827518}, {
         1004, 0.4860557768924303}, {1005, 0.49950248756218907`}, {
         1006, 0.49304174950298213`}, {1007, 0.4746772591857001}, {
         1008, 0.4880952380952381}, {1009, 0.5213082259663032}, {
         1010, 0.4801980198019802}, {1011, 0.506429277942631}, {
         1012, 0.508893280632411}, {1013, 0.5054294175715696}, {
         1014, 0.5088757396449705}, {1015, 0.4886699507389163}, {
         1016, 0.48523622047244097`}, {1017, 0.48672566371681414`}, {
         1018, 0.5068762278978389}, {1019, 0.5122669283611384}, {
         1020, 0.4950980392156863}, {1021, 0.5132223310479922}, {
         1022, 0.4755381604696673}, {1023, 0.5298142717497556}, {
         1024, 0.515625}, {1025, 0.49365853658536585`}, {
         1026, 0.5087719298245614}, {1027, 0.47127555988315484`}, {
         1028, 0.48540856031128404`}, {1029, 0.5014577259475219}, {
         1030, 0.5087378640776699}, {1031, 0.4917555771096023}, {
         1032, 0.49709302325581395`}, {1033, 0.4753146176185866}, {
         1034, 0.4816247582205029}, {1035, 0.4666666666666667}, {
         1036, 0.47297297297297297`}, {1037, 0.4773384763741562}, {
         1038, 0.5279383429672447}, {1039, 0.4870067372473532}, {
         1040, 0.49423076923076925`}, {1041, 0.4745437079731028}, {
         1042, 0.525911708253359}, {1043, 0.4947267497603068}, {
         1044, 0.5172413793103449}, {1045, 0.5157894736842106}, {
         1046, 0.4894837476099426}, {1047, 0.49570200573065903`}, {
         1048, 0.4961832061068702}, {1049, 0.5262154432793136}, {
         1050, 0.49142857142857144`}, {1051, 0.5023786869647955}, {
         1052, 0.48098859315589354`}, {1053, 0.4843304843304843}, {
         1054, 0.47533206831119545`}, {1055, 0.4957345971563981}, {
         1056, 0.5037878787878788}, {1057, 0.5146641438032167}, {
         1058, 0.5141776937618148}, {1059, 0.48914069877242683`}, {
         1060, 0.5028301886792453}, {1061, 0.5032987747408105}, {
         1062, 0.4821092278719397}, {1063, 0.4816556914393227}, {
         1064, 0.4981203007518797}, {1065, 0.49953051643192486`}, {
         1066, 0.5131332082551595}, {1067, 0.5164011246485474}, {
         1068, 0.5131086142322098}, {1069, 0.48269410664172124`}, {
         1070, 0.5280373831775701}, {1071, 0.484593837535014}, {
         1072, 0.5018656716417911}, {1073, 0.5097856477166822}, {
         1074, 0.5242085661080075}, {1075, 0.521860465116279}, {1076, 0.5}, {
         1077, 0.510677808727948}, {1078, 0.46289424860853434`}, {
         1079, 0.4911955514365153}, {1080, 0.5046296296296297}, {
         1081, 0.5069380203515264}, {1082, 0.5184842883548983}, {
         1083, 0.48107109879963067`}, {1084, 0.477859778597786}, {
         1085, 0.5188940092165899}, {1086, 0.5082872928176796}, {
         1087, 0.5280588776448942}, {1088, 0.5165441176470589}, {
         1089, 0.5160697887970616}, {1090, 0.4798165137614679}, {
         1091, 0.5050412465627865}, {1092, 0.49542124542124544`}, {
         1093, 0.4986276303751144}, {1094, 0.5082266910420475}, {
         1095, 0.4840182648401826}, {1096, 0.5282846715328468}, {
         1097, 0.5150410209662717}, {1098, 0.48816029143898}, {
         1099, 0.48498635122838946`}, {1100, 0.49636363636363634`}, {
         1101, 0.48864668483197093`}, {1102, 0.4900181488203267}, {
         1103, 0.47778785131459656`}, {1104, 0.5117753623188406}, {
         1105, 0.5194570135746607}, {1106, 0.4909584086799277}, {
         1107, 0.46251129177958444`}, {1108, 0.4963898916967509}, {
         1109, 0.47790802524797116`}, {1110, 0.5207207207207207}, {
         1111, 0.5013501350135013}, {1112, 0.5062949640287769}, {
         1113, 0.49056603773584906`}, {1114, 0.49461400359066426`}, {
         1115, 0.4834080717488789}, {1116, 0.48655913978494625`}, {
         1117, 0.4977618621307073}, {1118, 0.5044722719141324}, {
         1119, 0.47810545129579984`}, {1120, 0.48125}, {
         1121, 0.4790365744870651}, {1122, 0.535650623885918}, {
         1123, 0.5057880676758683}, {1124, 0.541814946619217}, {
         1125, 0.5146666666666667}, {1126, 0.49822380106571934`}, {
         1127, 0.4906832298136646}, {1128, 0.49556737588652483`}, {
         1129, 0.5110717449069974}, {1130, 0.4929203539823009}, {
         1131, 0.5083996463306808}, {1132, 0.49469964664310956`}, {
         1133, 0.5101500441306267}, {1134, 0.5008818342151675}, {
         1135, 0.5268722466960353}, {1136, 0.5308098591549296}, {
         1137, 0.5021987686895338}, {1138, 0.5333919156414763}, {
         1139, 0.4986830553116769}, {1140, 0.4868421052631579}, {
         1141, 0.5127081507449606}, {1142, 0.4929947460595447}, {
         1143, 0.4768153980752406}, {1144, 0.5131118881118881}, {
         1145, 0.5117903930131005}, {1146, 0.48778359511343805`}, {
         1147, 0.4873583260680035}, {1148, 0.49477351916376305`}, {
         1149, 0.4934725848563969}, {1150, 0.5139130434782608}, {
         1151, 0.49695916594265854`}, {1152, 0.5034722222222222}, {
         1153, 0.49609713790112747`}, {1154, 0.5077989601386482}, {
         1155, 0.4831168831168831}, {1156, 0.4922145328719723}, {
         1157, 0.5004321521175453}, {1158, 0.49568221070811747`}, {
         1159, 0.5211389128559103}, {1160, 0.5060344827586207}, {
         1161, 0.49440137812230833`}, {1162, 0.4664371772805508}, {
         1163, 0.4866723989681857}, {1164, 0.5146048109965635}, {
         1165, 0.4858369098712446}, {1166, 0.5}, {
         1167, 0.49700085689802914`}, {1168, 0.5256849315068494}, {
         1169, 0.5115483319076134}, {1170, 0.4811965811965812}, {
         1171, 0.5004269854824936}, {1172, 0.523037542662116}, {
         1173, 0.4961636828644501}, {1174, 0.48126064735945484`}, {
         1175, 0.5097872340425532}, {1176, 0.5110544217687075}, {
         1177, 0.4995751911639762}, {1178, 0.5178268251273345}, {
         1179, 0.5055131467345207}, {1180, 0.5288135593220339}, {
         1181, 0.4961896697713802}, {1182, 0.4873096446700508}, {
         1183, 0.5232459847844463}, {1184, 0.5202702702702703}, {
         1185, 0.4936708860759494}, {1186, 0.5101180438448567}, {
         1187, 0.4987363100252738}, {1188, 0.484006734006734}, {
         1189, 0.5054667788057191}, {1190, 0.5}, {
         1191, 0.49370277078085645`}, {1192, 0.48406040268456374`}, {
         1193, 0.4878457669740151}, {1194, 0.4949748743718593}, {
         1195, 0.5096234309623431}, {1196, 0.5008361204013378}, {
         1197, 0.5121136173767753}, {1198, 0.508347245409015}, {
         1199, 0.5137614678899083}, {1200, 0.48833333333333334`}, {
         1201, 0.5170691090757702}, {1202, 0.4891846921797005}, {
         1203, 0.5095594347464671}, {1204, 0.49335548172757476`}, {
         1205, 0.4979253112033195}, {1206, 0.494195688225539}, {
         1207, 0.5062137531068766}, {1208, 0.49834437086092714`}, {
         1209, 0.5161290322580645}, {1210, 0.5132231404958678}, {
         1211, 0.49380677126341865`}, {1212, 0.5066006600660066}, {
         1213, 0.4649629018961253}, {1214, 0.49835255354200986`}, {
         1215, 0.45843621399176954`}, {1216, 0.4901315789473684}, {
         1217, 0.524239934264585}, {1218, 0.49014778325123154`}, {
         1219, 0.48974569319114025`}, {1220, 0.5278688524590164}, {
         1221, 0.5045045045045045}, {1222, 0.5040916530278232}, {
         1223, 0.49550286181520853`}, {1224, 0.48284313725490197`}, {
         1225, 0.46448979591836737`}, {1226, 0.4812398042414356}, {
         1227, 0.5004074979625102}, {1228, 0.48534201954397393`}, {
         1229, 0.5296989422294548}, {1230, 0.4886178861788618}, {
         1231, 0.49553208773354995`}, {1232, 0.49756493506493504`}, {
         1233, 0.5174371451743714}, {1234, 0.5235008103727715}, {
         1235, 0.5093117408906883}, {1236, 0.5080906148867314}, {
         1237, 0.5109135004042037}, {1238, 0.5040387722132472}, {
         1239, 0.4947538337368846}, {1240, 0.5233870967741936}, {
         1241, 0.49556809024979853`}, {1242, 0.5177133655394525}, {
         1243, 0.46178600160901045`}, {1244, 0.4847266881028939}, {
         1245, 0.4955823293172691}, {1246, 0.5176565008025682}, {
         1247, 0.4699278267842823}, {1248, 0.49439102564102566`}, {
         1249, 0.4899919935948759}, {1250, 0.504}, {
         1251, 0.5003996802557954}, {1252, 0.4992012779552716}, {
         1253, 0.5011971268954509}, {1254, 0.5015948963317385}, {
         1255, 0.5099601593625498}, {1256, 0.49920382165605093`}, {
         1257, 0.5322195704057279}, {1258, 0.5047694753577107}, {
         1259, 0.5234312946783162}, {1260, 0.5087301587301587}, {
         1261, 0.500396510705789}, {1262, 0.5150554675118859}, {
         1263, 0.5019794140934284}, {1264, 0.4723101265822785}, {
         1265, 0.5359683794466403}, {1266, 0.48894154818325436`}, {
         1267, 0.48855564325177586`}, {1268, 0.5165615141955836}, {
         1269, 0.4980299448384555}, {1270, 0.5078740157480315}, {
         1271, 0.5059008654602675}, {1272, 0.4921383647798742}, {
         1273, 0.4831107619795758}, {1274, 0.489010989010989}, {
         1275, 0.49098039215686273`}, {1276, 0.512539184952978}, {
         1277, 0.48472983555207516`}, {1278, 0.4890453834115806}, {
         1279, 0.4988272087568413}, {1280, 0.51171875}, {
         1281, 0.507416081186573}, {1282, 0.4906396255850234}, {
         1283, 0.5128604832424006}, {1284, 0.528816199376947}, {
         1285, 0.5066147859922179}, {1286, 0.4665629860031104}, {
         1287, 0.5081585081585082}, {1288, 0.48214285714285715`}, {
         1289, 0.4887509697439876}, {1290, 0.5077519379844961}, {
         1291, 0.5259488768396592}, {1292, 0.5023219814241486}, {
         1293, 0.494199535962877}, {1294, 0.5208655332302936}, {
         1295, 0.5042471042471043}, {1296, 0.47608024691358025`}, {
         1297, 0.5173477255204317}, {1298, 0.49922958397534667`}, {
         1299, 0.49653579676674364`}, {1300, 0.5030769230769231}, {
         1301, 0.504227517294389}, {1302, 0.5053763440860215}, {
         1303, 0.49347659247889486`}, {1304, 0.5176380368098159}, {
         1305, 0.5042145593869731}, {1306, 0.5091883614088821}, {
         1307, 0.49273144605967867`}, {1308, 0.49311926605504586`}, {
         1309, 0.46524064171123}, {1310, 0.4946564885496183}, {
         1311, 0.4820747520976354}, {1312, 0.5160060975609756}, {
         1313, 0.5095201827875095}, {1314, 0.4954337899543379}, {
         1315, 0.48517110266159696`}, {1316, 0.5151975683890577}, {
         1317, 0.4753227031131359}, {1318, 0.5212443095599393}, {
         1319, 0.49052312357846856`}, {1320, 0.4696969696969697}, {
         1321, 0.4738834216502649}, {1322, 0.48184568835098335`}, {
         1323, 0.5192743764172335}, {1324, 0.5226586102719033}, {
         1325, 0.4981132075471698}, {1326, 0.49095022624434387`}, {
         1327, 0.47324792765636775`}, {1328, 0.5120481927710844}, {
         1329, 0.5334838224228743}, {1330, 0.493984962406015}, {
         1331, 0.49812171299774605`}, {1332, 0.5187687687687688}, {
         1333, 0.49212303075768943`}, {1334, 0.5089955022488756}, {
         1335, 0.501123595505618}, {1336, 0.5194610778443114}, {
         1337, 0.5100972326103216}, {1338, 0.49327354260089684`}, {
         1339, 0.4936519790888723}, {1340, 0.49701492537313435`}, {
         1341, 0.511558538404176}, {1342, 0.49552906110283157`}, {
         1343, 0.5078183172002978}, {1344, 0.49181547619047616`}, {
         1345, 0.4758364312267658}, {1346, 0.5111441307578009}, {
         1347, 0.4662212323682257}, {1348, 0.5096439169139466}, {
         1349, 0.4825796886582654}, {1350, 0.48148148148148145`}, {
         1351, 0.49074759437453735`}, {1352, 0.4881656804733728}, {
         1353, 0.5114560236511456}, {1354, 0.4911373707533235}, {
         1355, 0.5040590405904058}, {1356, 0.49262536873156343`}, {
         1357, 0.4937361827560796}, {1358, 0.49779086892488955`}, {
         1359, 0.48859455481972036`}, {1360, 0.5169117647058824}, {
         1361, 0.5165319617927994}, {1362, 0.4933920704845815}, {
         1363, 0.504035216434336}, {1364, 0.501466275659824}, {
         1365, 0.484981684981685}, {1366, 0.4765739385065886}, {
         1367, 0.5047549378200439}, {1368, 0.4963450292397661}, {
         1369, 0.4864864864864865}, {1370, 0.4927007299270073}, {
         1371, 0.4989059080962801}, {1372, 0.5}, {1373, 0.5287691187181355}, {
         1374, 0.5145560407569141}, {1375, 0.5105454545454545}, {
         1376, 0.5152616279069767}, {1377, 0.4807552650689906}, {
         1378, 0.5087082728592163}, {1379, 0.5279187817258884}, {
         1380, 0.4855072463768116}, {1381, 0.47356987690079655`}, {
         1382, 0.4927641099855282}, {1383, 0.5075921908893709}, {
         1384, 0.49710982658959535`}, {1385, 0.4981949458483754}, {
         1386, 0.5122655122655123}, {1387, 0.4931506849315068}, {
         1388, 0.4978386167146974}, {1389, 0.48740100791936647`}, {
         1390, 0.4913669064748201}, {1391, 0.4874191229331416}, {
         1392, 0.5179597701149425}, {1393, 0.5096913137114142}, {
         1394, 0.509325681492109}, {1395, 0.4845878136200717}, {
         1396, 0.49355300859598855`}, {1397, 0.4917680744452398}, {
         1398, 0.4899856938483548}, {1399, 0.4996426018584703}, {
         1400, 0.48928571428571427`}, {1401, 0.4925053533190578}, {
         1402, 0.48502139800285304`}, {1403, 0.4746970776906629}, {
         1404, 0.5192307692307693}, {1405, 0.49395017793594304`}, {
         1406, 0.4822190611664296}, {1407, 0.4918265813788202}, {
         1408, 0.5319602272727273}, {1409, 0.47764371894960966`}, {
         1410, 0.475177304964539}, {1411, 0.5152374202693125}, {
         1412, 0.5049575070821529}, {1413, 0.5095541401273885}, {
         1414, 0.5134370579915134}, {1415, 0.4925795053003534}, {
         1416, 0.4943502824858757}, {1417, 0.4918842625264644}, {
         1418, 0.4922425952045134}, {1419, 0.49612403100775193`}, {
         1420, 0.5028169014084507}, {1421, 0.4933145672061928}, {
         1422, 0.4971870604781997}, {1423, 0.48348559381588196`}, {
         1424, 0.5063202247191011}, {1425, 0.4863157894736842}, {
         1426, 0.5112201963534362}, {1427, 0.5059565522074282}, {
         1428, 0.5035014005602241}, {1429, 0.5010496850944717}, {
         1430, 0.47762237762237764`}, {1431, 0.5059399021663172}, {
         1432, 0.49511173184357543`}, {1433, 0.4975575715282624}, {
         1434, 0.5083682008368201}, {1435, 0.5052264808362369}, {
         1436, 0.4909470752089137}, {1437, 0.4857341684064022}, {
         1438, 0.48956884561891517`}, {1439, 0.5079916608756081}, {
         1440, 0.5027777777777778}, {1441, 0.5079805690492714}, {
         1442, 0.5055478502080444}, {1443, 0.49480249480249483`}, {
         1444, 0.4743767313019391}, {1445, 0.501038062283737}, {
         1446, 0.5048409405255878}, {1447, 0.5093296475466482}, {
         1448, 0.48480662983425415`}, {1449, 0.47964113181504486`}, {
         1450, 0.5082758620689655}, {1451, 0.4906960716747071}, {
         1452, 0.5048209366391184}, {1453, 0.48107364074328973`}, {
         1454, 0.4828060522696011}, {1455, 0.4872852233676976}, {
         1456, 0.5048076923076923}, {1457, 0.5030885380919699}, {
         1458, 0.5041152263374485}, {1459, 0.49211788896504455`}, {
         1460, 0.4958904109589041}, {1461, 0.48528405201916497`}, {
         1462, 0.5191518467852257}, {1463, 0.5263157894736842}, {
         1464, 0.5034153005464481}, {1465, 0.5119453924914675}, {
         1466, 0.5300136425648022}, {1467, 0.49079754601226994`}, {
         1468, 0.5224795640326976}, {1469, 0.4914908100748809}, {
         1470, 0.4748299319727891}, {1471, 0.49014276002719237`}, {
         1472, 0.501358695652174}, {1473, 0.5044127630685675}, {
         1474, 0.5020352781546812}, {1475, 0.5098305084745762}, {
         1476, 0.483739837398374}, {1477, 0.4813811780636425}, {
         1478, 0.5040595399188093}, {1479, 0.4983096686950642}, {
         1480, 0.4905405405405405}, {1481, 0.5070898041863605}, {
         1482, 0.5020242914979757}, {1483, 0.5232636547538773}, {
         1484, 0.49663072776280326`}, {1485, 0.49292929292929294`}, {
         1486, 0.4959623149394347}, {1487, 0.49831876260928043`}, {
         1488, 0.5161290322580645}, {1489, 0.5043653458697113}, {
         1490, 0.5114093959731544}, {1491, 0.5016767270288397}, {
         1492, 0.5194369973190348}, {1493, 0.4983255190890824}, {
         1494, 0.4785809906291834}, {1495, 0.5036789297658862}, {
         1496, 0.47794117647058826`}, {1497, 0.5123580494321978}, {
         1498, 0.493324432576769}, {1499, 0.4883255503669113}, {
         1500, 0.5066666666666667}, {1501, 0.49700199866755496`}, {
         1502, 0.4973368841544607}, {1503, 0.4856952761144378}, {
         1504, 0.504654255319149}, {1505, 0.49700996677740866`}, {
         1506, 0.5073041168658698}, {1507, 0.47577969475779697`}, {
         1508, 0.5159151193633952}, {1509, 0.510934393638171}, {
         1510, 0.4735099337748344}, {1511, 0.4738583719391132}, {
         1512, 0.48148148148148145`}, {1513, 0.5135492399206874}, {
         1514, 0.4669749009247028}, {1515, 0.49438943894389437`}, {
         1516, 0.4980211081794195}, {1517, 0.5003295978905735}, {
         1518, 0.5151515151515151}, {1519, 0.5082290980908493}, {
         1520, 0.5013157894736842}, {1521, 0.48586456278763973`}, {
         1522, 0.49868593955321944`}, {1523, 0.49047931713722914`}, {
         1524, 0.5098425196850394}, {1525, 0.48262295081967216`}, {
         1526, 0.5144167758846658}, {1527, 0.495743287491814}, {
         1528, 0.49149214659685864`}, {1529, 0.49051667756703726`}, {
         1530, 0.5176470588235295}, {1531, 0.5016329196603527}, {
         1532, 0.5091383812010444}, {1533, 0.48140900195694714`}, {
         1534, 0.5345501955671447}, {1535, 0.49315960912052115`}, {
         1536, 0.513671875}, {1537, 0.4977228366948601}, {
         1538, 0.5026007802340702}, {1539, 0.4996751137102014}, {
         1540, 0.4792207792207792}, {1541, 0.4879948085658663}, {
         1542, 0.5019455252918288}, {1543, 0.47375243033052494`}, {
         1544, 0.49740932642487046`}, {1545, 0.4964401294498382}, {
         1546, 0.5032341526520052}, {1547, 0.524240465416936}, {
         1548, 0.5109819121447028}, {1549, 0.49580374435119434`}, {
         1550, 0.4761290322580645}, {1551, 0.4938749194068343}, {
         1552, 0.5083762886597938}, {1553, 0.4977462974887315}, {
         1554, 0.5051480051480052}, {1555, 0.5048231511254019}, {
         1556, 0.5019280205655527}, {1557, 0.4983943481053308}, {
         1558, 0.5051347881899871}, {1559, 0.514432328415651}, {
         1560, 0.49551282051282053`}, {1561, 0.48814862267777065`}, {
         1562, 0.4884763124199744}, {1563, 0.4868841970569418}, {
         1564, 0.48081841432225064`}, {1565, 0.4939297124600639}, {
         1566, 0.4846743295019157}, {1567, 0.5162731333758774}, {
         1568, 0.49362244897959184`}, {1569, 0.49394518801784576`}, {
         1570, 0.5210191082802548}, {1571, 0.521323997453851}, {
         1572, 0.4872773536895674}, {1573, 0.4901462174189447}, {
         1574, 0.4891994917407878}, {1575, 0.4965079365079365}, {
         1576, 0.4873096446700508}, {1577, 0.5155358275206088}, {
         1578, 0.4873257287705957}, {1579, 0.49778340721975933`}, {
         1580, 0.4873417721518987}, {1581, 0.5142314990512334}, {
         1582, 0.4797724399494311}, {1583, 0.5097915350600126}, {
         1584, 0.49684343434343436`}, {1585, 0.5123028391167193}, {
         1586, 0.5006305170239597}, {1587, 0.48834278512917456`}, {
         1588, 0.510705289672544}, {1589, 0.48332284455632474`}, {
         1590, 0.5056603773584906}, {1591, 0.49591451917033313`}, {
         1592, 0.4805276381909548}, {1593, 0.49968612680477087`}, {
         1594, 0.5075282308657465}, {1595, 0.4827586206896552}, {
         1596, 0.4981203007518797}, {1597, 0.5122103944896681}, {
         1598, 0.5031289111389237}, {1599, 0.4796747967479675}, {
         1600, 0.505}, {1601, 0.49406620861961276`}, {
         1602, 0.4794007490636704}, {1603, 0.5028072364316906}, {
         1604, 0.506857855361596}, {1605, 0.5289719626168224}, {
         1606, 0.4800747198007472}, {1607, 0.4903546981953951}, {
         1608, 0.5180348258706468}, {1609, 0.5027967681789932}, {
         1610, 0.515527950310559}, {1611, 0.4897579143389199}, {
         1612, 0.49317617866004965`}, {1613, 0.51828890266584}, {
         1614, 0.5012391573729864}, {1615, 0.5275541795665635}, {
         1616, 0.510519801980198}, {1617, 0.5200989486703772}, {
         1618, 0.4758961681087763}, {1619, 0.4898085237801112}, {
         1620, 0.5166666666666667}, {1621, 0.5027760641579272}, {
         1622, 0.4963008631319359}, {1623, 0.4984596426370918}, {
         1624, 0.5067733990147784}, {1625, 0.5095384615384615}, {
         1626, 0.4981549815498155}, {1627, 0.4960049170251998}, {
         1628, 0.49447174447174447`}, {1629, 0.5089011663597299}, {
         1630, 0.48957055214723927`}, {1631, 0.5107296137339056}, {
         1632, 0.4889705882352941}, {1633, 0.5107164727495407}, {
         1634, 0.49938800489596086`}, {1635, 0.5143730886850153}, {
         1636, 0.5079462102689487}, {1637, 0.5045815516188149}, {
         1638, 0.5115995115995116}, {1639, 0.5149481391092129}, {
         1640, 0.4975609756097561}, {1641, 0.453382084095064}, {
         1642, 0.5176613885505481}, {1643, 0.5045648204503956}, {
         1644, 0.5036496350364964}, {1645, 0.5094224924012158}, {
         1646, 0.5024301336573511}, {1647, 0.4978749241044323}, {
         1648, 0.4975728155339806}, {1649, 0.4887810794420861}, {
         1650, 0.4903030303030303}, {1651, 0.465778316172017}, {
         1652, 0.5048426150121066}, {1653, 0.5251058681185723}, {
         1654, 0.4909310761789601}, {1655, 0.4936555891238671}, {
         1656, 0.5157004830917874}, {1657, 0.48823174411587206`}, {
         1658, 0.5072376357056695}, {1659, 0.4978902953586498}, {1660, 0.5}, {
         1661, 0.50210716435882}, {1662, 0.4981949458483754}, {
         1663, 0.5111244738424534}, {1664, 0.5132211538461539}, {
         1665, 0.5057057057057057}, {1666, 0.5090036014405762}, {
         1667, 0.4979004199160168}, {1668, 0.4940047961630695}, {
         1669, 0.49011384062312763`}, {1670, 0.47784431137724553`}, {
         1671, 0.48952722920406944`}, {1672, 0.5035885167464115}, {
         1673, 0.497907949790795}, {1674, 0.5173237753882916}, {
         1675, 0.5008955223880597}, {1676, 0.5459427207637232}, {
         1677, 0.49254621347644606`}, {1678, 0.5119189511323003}, {
         1679, 0.5026801667659321}, {1680, 0.513095238095238}, {
         1681, 0.47888161808447355`}, {1682, 0.4994054696789536}, {
         1683, 0.47831253713606653`}, {1684, 0.5124703087885986}, {
         1685, 0.46943620178041545`}, {1686, 0.5059311981020166}, {
         1687, 0.5080023710729105}, {1688, 0.49111374407582936`}, {
         1689, 0.5139135583185317}, {1690, 0.4952662721893491}, {
         1691, 0.4961561206386753}, {1692, 0.5135933806146572}, {
         1693, 0.5026580035440047}, {1694, 0.5165289256198347}, {
         1695, 0.5185840707964602}, {1696, 0.4893867924528302}, {
         1697, 0.5079552150854449}, {1698, 0.49411071849234395`}, {
         1699, 0.4961742201294879}, {1700, 0.4888235294117647}, {
         1701, 0.48853615520282184`}, {1702, 0.5035252643948296}, {
         1703, 0.5073399882560188}, {1704, 0.4953051643192488}, {
         1705, 0.4838709677419355}, {1706, 0.5}, {1707, 0.4991212653778559}, {
         1708, 0.5117096018735363}, {1709, 0.48507899356348744`}, {
         1710, 0.5011695906432748}, {1711, 0.5113968439509059}, {
         1712, 0.4848130841121495}, {1713, 0.4985405720957385}, {
         1714, 0.5134189031505251}, {1715, 0.4763848396501458}, {
         1716, 0.5052447552447552}, {1717, 0.48456610366919045`}, {
         1718, 0.490104772991851}, {1719, 0.5107620709714951}, {
         1720, 0.4883720930232558}, {1721, 0.47937245787332944`}, {
         1722, 0.502903600464576}, {1723, 0.497968659315148}, {
         1724, 0.5208816705336426}, {1725, 0.4991304347826087}, {
         1726, 0.4976825028968714}, {1727, 0.49623624782860454`}, {
         1728, 0.5127314814814815}, {1729, 0.4939271255060729}, {
         1730, 0.5156069364161849}, {1731, 0.49913344887348354`}, {
         1732, 0.4913394919168591}, {1733, 0.49740334679746107`}, {
         1734, 0.47693194925028837`}, {1735, 0.5123919308357349}, {
         1736, 0.49481566820276496`}, {1737, 0.5066206102475532}, {
         1738, 0.49252013808975836`}, {1739, 0.5169637722829212}, {
         1740, 0.48333333333333334`}, {1741, 0.5025847214244687}, {
         1742, 0.49885189437428246`}, {1743, 0.5054503729202524}, {
         1744, 0.5160550458715596}, {1745, 0.5065902578796562}, {
         1746, 0.48625429553264604`}, {1747, 0.5157412707498569}, {
         1748, 0.4851258581235698}, {1749, 0.4928530588907947}, {
         1750, 0.49542857142857144`}, {1751, 0.5134209023415192}, {
         1752, 0.521689497716895}, {1753, 0.4945807187678266}, {
         1754, 0.4846066134549601}, {1755, 0.5025641025641026}, {
         1756, 0.5005694760820045}, {1757, 0.4968696642003415}, {
         1758, 0.48464163822525597`}, {1759, 0.4860716316088687}, {
         1760, 0.4903409090909091}, {1761, 0.49290176036342986`}, {
         1762, 0.5005675368898979}, {1763, 0.49801474758933634`}, {
         1764, 0.5022675736961452}, {1765, 0.49745042492917846`}, {
         1766, 0.522083805209513}, {1767, 0.4946236559139785}, {
         1768, 0.5107466063348416}, {1769, 0.5025438100621821}, {
         1770, 0.511864406779661}, {1771, 0.5059288537549407}, {
         1772, 0.5073363431151241}, {1773, 0.5138183869148336}, {
         1774, 0.4954904171364149}, {1775, 0.5115492957746479}, {
         1776, 0.509009009009009}, {1777, 0.5109735509285313}, {
         1778, 0.49100112485939257`}, {1779, 0.49971894322653176`}, {
         1780, 0.499438202247191}, {1781, 0.4879281302638967}, {
         1782, 0.4988776655443322}, {1783, 0.5148625911385306}, {
         1784, 0.5056053811659192}, {1785, 0.5025210084033613}, {
         1786, 0.4798432250839866}, {1787, 0.4991606043648573}, {
         1788, 0.4955257270693512}, {1789, 0.5025153717160424}, {
         1790, 0.49664804469273743`}, {1791, 0.486320491345617}, {
         1792, 0.5022321428571429}, {1793, 0.47183491355270496`}, {
         1794, 0.49052396878483834`}, {1795, 0.4963788300835655}, {
         1796, 0.49498886414253895`}, {1797, 0.5091819699499165}, {
         1798, 0.5216907675194661}, {1799, 0.5036131183991106}, {
         1800, 0.4855555555555556}, {1801, 0.5163797890061077}, {
         1802, 0.49667036625971145`}, {1803, 0.5108153078202995}, {
         1804, 0.49445676274944567`}, {1805, 0.5119113573407202}, {
         1806, 0.4750830564784053}, {1807, 0.496956281128943}, {
         1808, 0.514933628318584}, {1809, 0.5041459369817579}, {
         1810, 0.4845303867403315}, {1811, 0.49530646051905025`}, {
         1812, 0.49337748344370863`}, {1813, 0.5008273579702152}, {
         1814, 0.49503858875413453`}, {1815, 0.4997245179063361}, {
         1816, 0.5033039647577092}, {1817, 0.4914694551458448}, {
         1818, 0.48734873487348734`}, {1819, 0.4793842770753161}, {
         1820, 0.5087912087912088}, {1821, 0.5030203185063152}, {
         1822, 0.495609220636663}, {1823, 0.47668678003291276`}, {
         1824, 0.5043859649122807}, {1825, 0.4882191780821918}, {
         1826, 0.511500547645126}, {1827, 0.4827586206896552}, {
         1828, 0.49671772428884026`}, {1829, 0.4980863860032805}, {
         1830, 0.4830601092896175}, {1831, 0.4860731840524304}, {
         1832, 0.5010917030567685}, {1833, 0.4948172394980906}, {
         1834, 0.49182115594329334`}, {1835, 0.49645776566757494`}, {
         1836, 0.48257080610021785`}, {1837, 0.502449646162221}, {
         1838, 0.49020674646354734`}, {1839, 0.4893964110929853}, {
         1840, 0.5190217391304348}, {1841, 0.485605649103748}, {
         1842, 0.510314875135722}, {1843, 0.4877916440586001}, {
         1844, 0.5103036876355749}, {1845, 0.5008130081300813}, {
         1846, 0.5005417118093174}, {1847, 0.5148890092041147}, {
         1848, 0.5070346320346321}, {1849, 0.5137912385073012}, {
         1850, 0.5037837837837837}, {1851, 0.5072933549432739}, {
         1852, 0.490280777537797}, {1853, 0.49865083648138153`}, {
         1854, 0.4989212513484358}, {1855, 0.5115902964959569}, {
         1856, 0.509698275862069}, {1857, 0.4868066774367259}, {
         1858, 0.4865446716899892}, {1859, 0.516406670252824}, {
         1860, 0.4806451612903226}, {1861, 0.4830736163353036}, {
         1862, 0.5096670247046187}, {1863, 0.4949006977992485}, {
         1864, 0.5118025751072961}, {1865, 0.4970509383378016}, {
         1866, 0.4705251875669882}, {1867, 0.5158007498660954}, {
         1868, 0.5107066381156317}, {1869, 0.49973247726056713`}, {
         1870, 0.5096256684491979}, {1871, 0.5018706574024586}, {
         1872, 0.5112179487179487}, {1873, 0.5034703683929524}, {
         1874, 0.5208110992529349}, {1875, 0.49866666666666665`}, {
         1876, 0.5}, {1877, 0.5103889184869472}, {1878, 0.5101171458998935}, {
         1879, 0.5055880787653007}, {1880, 0.5106382978723404}, {
         1881, 0.5029239766081871}, {1882, 0.5015940488841658}, {
         1883, 0.4944237918215613}, {1884, 0.5318471337579618}, {
         1885, 0.49124668435013263`}, {1886, 0.5185577942735949}, {
         1887, 0.5007949125596184}, {1888, 0.5111228813559322}, {
         1889, 0.5029115934356803}, {1890, 0.4973544973544973}, {
         1891, 0.48704389212057114`}, {1892, 0.5264270613107822}, {
         1893, 0.5113576333861596}, {1894, 0.49366420274551215`}, {
         1895, 0.49234828496042216`}, {1896, 0.4931434599156118}, {
         1897, 0.4844491302055878}, {1898, 0.48788198103266595`}, {
         1899, 0.5055292259083728}, {1900, 0.5163157894736842}, {
         1901, 0.4950026301946344}, {1902, 0.5315457413249212}, {
         1903, 0.5228586442459274}, {1904, 0.5047268907563025}, {
         1905, 0.48293963254593175`}, {1906, 0.5015739769150053}, {
         1907, 0.4672260094389093}, {1908, 0.5036687631027253}, {
         1909, 0.49921424829753797`}, {1910, 0.4931937172774869}, {
         1911, 0.4908424908424908}, {1912, 0.5120292887029289}, {
         1913, 0.4924202822791427}, {1914, 0.46760710553814}, {
         1915, 0.4929503916449086}, {1916, 0.48956158663883087`}, {
         1917, 0.4887845592070944}, {1918, 0.5052137643378519}, {
         1919, 0.49088066701406985`}, {1920, 0.5161458333333333}, {
         1921, 0.4971369078604893}, {1922, 0.5015608740894901}, {
         1923, 0.48205928237129486`}, {1924, 0.487006237006237}, {
         1925, 0.5137662337662338}, {1926, 0.5020768431983386}, {
         1927, 0.508562532433835}, {1928, 0.49118257261410786`}, {
         1929, 0.5075168481078279}, {1930, 0.4979274611398964}, {
         1931, 0.5064733298808908}, {1932, 0.5036231884057971}, {
         1933, 0.5012933264355923}, {1934, 0.5098241985522234}, {
         1935, 0.5012919896640827}, {1936, 0.48037190082644626`}, {
         1937, 0.48373773877129583`}, {1938, 0.5128998968008256}, {
         1939, 0.5023207839092315}, {1940, 0.5046391752577319}, {
         1941, 0.506439979392066}, {1942, 0.5010298661174047}, {
         1943, 0.4981986618630983}, {1944, 0.5066872427983539}, {
         1945, 0.506426735218509}, {1946, 0.5025693730729702}, {
         1947, 0.49512069851052903`}, {1948, 0.5025667351129364}, {
         1949, 0.5012827090815803}, {1950, 0.5112820512820513}, {
         1951, 0.5069195284469503}, {1952, 0.4953893442622951}, {
         1953, 0.4935995903737839}, {1954, 0.4938587512794268}, {
         1955, 0.4859335038363171}, {1956, 0.5117586912065439}, {
         1957, 0.4920797138477261}, {1958, 0.5035750766087844}, {
         1959, 0.5028075548749362}, {1960, 0.5051020408163265}, {
         1961, 0.4992350841407445}, {1962, 0.5091743119266054}, {
         1963, 0.5084055017829853}, {1964, 0.5173116089613035}, {
         1965, 0.4961832061068702}, {1966, 0.4979654120040692}, {
         1967, 0.5083884087442806}, {1968, 0.49339430894308944`}, {
         1969, 0.5017775520568817}, {1970, 0.4873096446700508}, {
         1971, 0.5058346017250127}, {1972, 0.49898580121703856`}, {
         1973, 0.501773948302078}, {1974, 0.5096251266464032}, {
         1975, 0.479493670886076}, {1976, 0.49291497975708504`}, {
         1977, 0.5118866970156803}, {1978, 0.48533872598584427`}, {
         1979, 0.5007579585649318}, {1980, 0.5035353535353535}, {
         1981, 0.4936900555275114}, {1982, 0.5131180625630676}, {
         1983, 0.5042864346949067}, {1984, 0.49747983870967744`}, {
         1985, 0.5042821158690176}, {1986, 0.4954682779456193}, {
         1987, 0.5078007045797684}, {1988, 0.49346076458752514`}, {
         1989, 0.5143288084464555}, {1990, 0.5236180904522613}, {
         1991, 0.49623304871923657`}, {1992, 0.5150602409638554}, {
         1993, 0.5173105870546915}, {1994, 0.49398194583751254`}, {
         1995, 0.5182957393483709}, {1996, 0.5}, {1997, 0.4872308462694041}, {
         1998, 0.497997997997998}, {1999, 0.5082541270635318}, {
         2000, 0.503}, {2001, 0.49775112443778113`}, {
         2002, 0.508991008991009}, {2003, 0.4962556165751373}, {
         2004, 0.4930139720558882}, {2005, 0.5077306733167082}, {
         2006, 0.4900299102691924}, {2007, 0.4987543597409068}, {
         2008, 0.5034860557768924}, {2009, 0.5166749626679941}, {
         2010, 0.4975124378109453}, {2011, 0.4987568373943312}, {
         2012, 0.4826043737574553}, {2013, 0.5106805762543467}, {
         2014, 0.4900695134061569}, {2015, 0.5052109181141439}, {
         2016, 0.4935515873015873}, {2017, 0.4992563212692117}, {
         2018, 0.4930624380574827}, {2019, 0.49876176324913324`}, {
         2020, 0.5}, {2021, 0.48787728847105394`}, {
         2022, 0.5044510385756676}, {2023, 0.5071675729115176}, {
         2024, 0.5009881422924901}, {2025, 0.5041975308641975}, {
         2026, 0.49654491609081935`}, {2027, 0.5032067094227923}, {
         2028, 0.5231755424063116}, {2029, 0.5012321340561853}, {2030, 0.5}, {
         2031, 0.4854751354012802}, {2032, 0.5029527559055118}, {
         2033, 0.4869650762420069}, {2034, 0.49262536873156343`}, {
         2035, 0.5071253071253071}, {2036, 0.47593320235756387`}, {
         2037, 0.524300441826215}, {2038, 0.4847890088321884}, {
         2039, 0.506620892594409}, {2040, 0.5230392156862745}, {
         2041, 0.5022048015678588}, {2042, 0.5073457394711067}, {
         2043, 0.5208027410670583}, {2044, 0.5009784735812133}, {
         2045, 0.5114914425427873}, {2046, 0.5068426197458455}, {
         2047, 0.49096238397655106`}, {2048, 0.49560546875}, {
         2049, 0.4997559785261103}, {2050, 0.4946341463414634}, {
         2051, 0.5017064846416383}, {2052, 0.5160818713450293}, {
         2053, 0.49001461276181196`}, {2054, 0.508763388510224}, {
         2055, 0.49878345498783455`}, {2056, 0.5068093385214008}, {
         2057, 0.5002430724355859}, {2058, 0.5048590864917396}, {
         2059, 0.4958717824186498}, {2060, 0.5063106796116504}, {
         2061, 0.50509461426492}, {2062, 0.510184287099903}, {
         2063, 0.5036354823073195}, {2064, 0.5033914728682171}, {
         2065, 0.4861985472154964}, {2066, 0.5111326234269119}, {
         2067, 0.505563618771166}, {2068, 0.5009671179883946}, {
         2069, 0.5326244562590623}, {2070, 0.4966183574879227}, {
         2071, 0.47706422018348627`}, {2072, 0.5077220077220077}, {
         2073, 0.5171249397009166}, {2074, 0.49855351976856316`}, {
         2075, 0.48481927710843375`}, {2076, 0.4816955684007707}, {
         2077, 0.49879634087626384`}, {2078, 0.4971126082771896}, {
         2079, 0.5132275132275133}, {2080, 0.49903846153846154`}, {
         2081, 0.48678519942335413`}, {2082, 0.4956772334293948}, {
         2083, 0.48727796447431587`}, {2084, 0.4918426103646833}, {
         2085, 0.4762589928057554}, {2086, 0.5153403643336529}, {
         2087, 0.49353138476281744`}, {2088, 0.5081417624521073}, {
         2089, 0.501675442795596}, {2090, 0.5191387559808612}, {
         2091, 0.5117168818747011}, {2092, 0.4947418738049713}, {
         2093, 0.49976110845676064`}, {2094, 0.4904489016236867}, {
         2095, 0.4949880668257757}, {2096, 0.5090648854961832}, {
         2097, 0.49213161659513593`}, {2098, 0.4852240228789323}, {
         2099, 0.5002382086707956}, {2100, 0.4828571428571429}, {
         2101, 0.4940504521656354}, {2102, 0.5047573739295909}, {
         2103, 0.5183071802187351}, {2104, 0.4919201520912547}, {
         2105, 0.5121140142517815}, {2106, 0.5094966761633428}, {
         2107, 0.517797816801139}, {2108, 0.5170777988614801}, {
         2109, 0.48364153627311524`}, {2110, 0.5109004739336492}, {
         2111, 0.5011842728564662}, {2112, 0.48863636363636365`}, {
         2113, 0.4865120681495504}, {2114, 0.49621570482497634`}, {
         2115, 0.500709219858156}, {2116, 0.4966918714555766}, {
         2117, 0.4874822862541332}, {2118, 0.4971671388101983}, {
         2119, 0.5040113260972157}, {2120, 0.5160377358490567}, {
         2121, 0.5011786892975012}, {2122, 0.49858623939679547`}, {
         2123, 0.5082430522845031}, {2124, 0.5037664783427496}, {
         2125, 0.49976470588235294`}, {2126, 0.4943555973659454}, {
         2127, 0.5086976962858486}, {2128, 0.5122180451127819}, {
         2129, 0.4964772193518084}, {2130, 0.48169014084507045`}, {
         2131, 0.48427968090098544`}, {2132, 0.4826454033771107}, {
         2133, 0.509142053445851}, {2134, 0.49343955014058105`}, {
         2135, 0.5021077283372365}, {2136, 0.5112359550561798}, {
         2137, 0.5011698642957417}, {2138, 0.49111318989710007`}, {
         2139, 0.4848059841047218}, {2140, 0.4855140186915888}, {
         2141, 0.5137786081270435}, {2142, 0.5200746965452848}, {
         2143, 0.4857676154923005}, {2144, 0.5004664179104478}, {
         2145, 0.5039627039627039}, {2146, 0.5060577819198508}, {
         2147, 0.47554727526781554`}, {2148, 0.48743016759776536`}, {
         2149, 0.5044206607724523}, {2150, 0.4758139534883721}, {
         2151, 0.5151092515109251}, {2152, 0.5060408921933085}, {
         2153, 0.5039479795633999}, {2154, 0.5055710306406686}, {
         2155, 0.5006960556844547}, {2156, 0.49489795918367346`}, {
         2157, 0.5053314789058878}, {2158, 0.494902687673772}, {
         2159, 0.47383047707271886`}, {2160, 0.5055555555555555}, {
         2161, 0.5048588616381305}, {2162, 0.5120259019426457}, {
         2163, 0.5071659731853907}, {2164, 0.5013863216266173}, {
         2165, 0.5062355658198614}, {2166, 0.4709141274238227}, {
         2167, 0.5182279649284726}, {2168, 0.4981549815498155}, {
         2169, 0.5099124020285846}, {2170, 0.4967741935483871}, {
         2171, 0.5071395670198066}, {2172, 0.4871086556169429}, {
         2173, 0.49746893695352046`}, {2174, 0.5009199632014719}, {
         2175, 0.5094252873563219}, {2176, 0.5041360294117647}, {
         2177, 0.5057418465778595}, {2178, 0.48943985307621674`}, {
         2179, 0.4997705369435521}, {2180, 0.49770642201834864`}, {
         2181, 0.4974782209995415}, {2182, 0.49816681943171404`}, {
         2183, 0.4864864864864865}, {2184, 0.516941391941392}, {
         2185, 0.4805491990846682}, {2186, 0.5132662397072278}, {
         2187, 0.49657064471879286`}, {2188, 0.506398537477148}, {
         2189, 0.51301964367291}, {2190, 0.49817351598173515`}, {
         2191, 0.508443633044272}, {2192, 0.49954379562043794`}, {
         2193, 0.5056999544003647}, {2194, 0.4927073837739289}, {
         2195, 0.489749430523918}, {2196, 0.49089253187613846`}, {
         2197, 0.5079654073736914}, {2198, 0.4854413102820746}, {
         2199, 0.493406093678945}, {2200, 0.5081818181818182}, {
         2201, 0.5152203543843707}, {2202, 0.4895549500454133}, {
         2203, 0.5097594189741262}, {2204, 0.4922867513611615}, {
         2205, 0.4984126984126984}, {2206, 0.5004533091568449}, {
         2207, 0.49841413683733576`}, {2208, 0.5172101449275363}, {
         2209, 0.5024898143956541}, {2210, 0.4995475113122172}, {
         2211, 0.506558118498417}, {2212, 0.5081374321880651}, {
         2213, 0.4722096701310438}, {2214, 0.5031616982836495}, {
         2215, 0.5128668171557562}, {2216, 0.5135379061371841}, {
         2217, 0.507893549842129}, {2218, 0.5022542831379622}, {
         2219, 0.4993240198287517}, {2220, 0.4882882882882883}, {
         2221, 0.4844664565511031}, {2222, 0.4945994599459946}, {
         2223, 0.5051731893837157}, {2224, 0.529226618705036}, {
         2225, 0.4885393258426966}, {2226, 0.4995507637017071}, {
         2227, 0.48405927256398745`}, {2228, 0.5008976660682226}, {
         2229, 0.4876626289816061}, {2230, 0.49417040358744396`}, {
         2231, 0.5078440161362617}, {2232, 0.4959677419354839}, {
         2233, 0.5002239140170175}, {2234, 0.4865711727842435}, {
         2235, 0.5024608501118568}, {2236, 0.5080500894454383}, {
         2237, 0.4894948591864104}, {2238, 0.5183199285075961}, {
         2239, 0.507815989280929}, {2240, 0.5004464285714286}, {
         2241, 0.5136099955377064}, {2242, 0.5026761819803747}, {
         2243, 0.5251894783771734}, {2244, 0.5120320855614974}, {
         2245, 0.48596881959910915`}, {2246, 0.4946571682991986}, {
         2247, 0.5068980863373387}, {2248, 0.5226868327402135}, {
         2249, 0.5024455313472654}, {2250, 0.5142222222222222}, {
         2251, 0.5033318525099956}, {2252, 0.48756660746003555`}, {
         2253, 0.5028850421660009}, {2254, 0.5044365572315883}, {
         2255, 0.5024390243902439}, {2256, 0.49069148936170215`}, {
         2257, 0.5081967213114754}, {2258, 0.5128432240921169}, {
         2259, 0.5033200531208499}, {2260, 0.5004424778761062}, {
         2261, 0.4834144183989385}, {2262, 0.48983200707338637`}, {
         2263, 0.5086168802474591}, {2264, 0.49337455830388693`}, {
         2265, 0.4949227373068433}, {2266, 0.5105913503971756}, {
         2267, 0.4984561093956771}, {2268, 0.4894179894179894}, {
         2269, 0.47818422212428385`}, {2270, 0.4960352422907489}, {
         2271, 0.48392778511668866`}, {2272, 0.522887323943662}, {
         2273, 0.49626044874615044`}, {2274, 0.5145118733509235}, {
         2275, 0.48835164835164835`}, {2276, 0.4969244288224956}, {
         2277, 0.49670619235836627`}, {2278, 0.5}, {
         2279, 0.5037297060114085}, {2280, 0.5030701754385964}, {
         2281, 0.48268303375712407`}, {2282, 0.5021910604732691}, {
         2283, 0.5028471309680246}, {2284, 0.4934325744308231}, {
         2285, 0.4975929978118162}, {2286, 0.5144356955380578}, {
         2287, 0.5024048972452995}, {2288, 0.49213286713286714`}, {
         2289, 0.5028396679772826}, {2290, 0.4812227074235808}, {
         2291, 0.5072020951549542}, {2292, 0.5026178010471204}, {
         2293, 0.5063235935455734}, {2294, 0.500871839581517}, {
         2295, 0.4971677559912854}, {2296, 0.4969512195121951}, {
         2297, 0.4936874183717893}, {2298, 0.5056570931244561}, {
         2299, 0.4954327968682036}, {2300, 0.4930434782608696}, {
         2301, 0.5249891351586267}, {2302, 0.5160729800173762}, {
         2303, 0.5028224055579679}, {2304, 0.4939236111111111}, {
         2305, 0.49587852494577006`}, {2306, 0.5082393755420642}, {
         2307, 0.4880797572605115}, {2308, 0.5008665511265165}, {
         2309, 0.5075790385448246}, {2310, 0.5034632034632035}, {
         2311, 0.504110774556469}, {2312, 0.5017301038062284}, {
         2313, 0.5006485084306096}, {2314, 0.496542783059637}, {
         2315, 0.48812095032397407`}, {2316, 0.49222797927461137`}, {
         2317, 0.4812257229175658}, {2318, 0.5094909404659189}, {
         2319, 0.5239327296248383}, {2320, 0.5081896551724138}, {
         2321, 0.5006462731581215}, {2322, 0.5025839793281653}, {
         2323, 0.48902281532501074`}, {2324, 0.4866609294320138}, {
         2325, 0.4761290322580645}, {2326, 0.5073086844368013}, {
         2327, 0.49591749033089816`}, {2328, 0.4952749140893471}, {
         2329, 0.501932159725204}, {2330, 0.5042918454935622}, {
         2331, 0.504075504075504}, {2332, 0.4944253859348199}, {
         2333, 0.49335619374196316`}, {2334, 0.49657240788346185`}, {
         2335, 0.5032119914346895}, {2336, 0.502568493150685}, {
         2337, 0.5121951219512195}, {2338, 0.5008554319931565}, {
         2339, 0.5079093629756306}, {2340, 0.4700854700854701}, {
         2341, 0.4822725331055105}, {2342, 0.5106746370623398}, {
         2343, 0.5061886470337175}, {2344, 0.5046928327645052}, {
         2345, 0.4976545842217484}, {2346, 0.505541346973572}, {
         2347, 0.4835960801022582}, {2348, 0.4936115843270869}, {
         2349, 0.5019157088122606}, {2350, 0.5157446808510638}, {
         2351, 0.5036154827732879}, {2352, 0.5029761904761905}, {
         2353, 0.4959626009349766}, {2354, 0.48853016142735767`}, {
         2355, 0.5121019108280255}, {2356, 0.4864176570458404}, {
         2357, 0.4789987271955876}, {2358, 0.5262934690415606}, {
         2359, 0.486646884272997}, {2360, 0.5055084745762712}, {
         2361, 0.49894112664125373`}, {2362, 0.5029635901778154}, {
         2363, 0.46974185357596276`}, {2364, 0.5076142131979695}, {
         2365, 0.4896405919661734}, {2366, 0.49577345731191885`}, {
         2367, 0.507815800591466}, {2368, 0.49113175675675674`}, {
         2369, 0.4871253693541579}, {2370, 0.5037974683544304}, {
         2371, 0.49768030366933785`}, {2372, 0.5008431703204047}, {
         2373, 0.5187526337968816}, {2374, 0.4945240101095198}, {
         2375, 0.512}, {2376, 0.5025252525252525}, {
         2377, 0.5018931426167438}, {2378, 0.4760302775441548}, {
         2379, 0.5023118957545187}, {2380, 0.5042016806722689}, {
         2381, 0.4922301553968921}, {2382, 0.4727120067170445}, {
         2383, 0.5039865715484683}, {2384, 0.5004194630872483}, {
         2385, 0.5123689727463312}, {2386, 0.5113160100586757}, {
         2387, 0.5123586091328027}, {2388, 0.4807370184254606}, {
         2389, 0.49100041858518206`}, {2390, 0.5046025104602511}, {
         2391, 0.5010455876202425}, {2392, 0.4870401337792642}, {
         2393, 0.4868366067697451}, {2394, 0.5100250626566416}, {
         2395, 0.5014613778705637}, {2396, 0.5020868113522537}, {
         2397, 0.48936170212765956`}, {2398, 0.4891576313594662}, {
         2399, 0.5127136306794498}, {2400, 0.4866666666666667}, {
         2401, 0.5002082465639317}, {2402, 0.4962531223980017}, {
         2403, 0.5118601747815231}, {2404, 0.5128951747088186}, {
         2405, 0.5027027027027027}, {2406, 0.5087281795511222}, {
         2407, 0.5114250103863731}, {2408, 0.49294019933554817`}, {
         2409, 0.48609381486093817`}, {2410, 0.4991701244813278}, {
         2411, 0.5250933222729158}, {2412, 0.49129353233830847`}, {
         2413, 0.5126398673849979}, {2414, 0.503728251864126}, {
         2415, 0.48198757763975153`}, {2416, 0.5136589403973509}, {
         2417, 0.5018618121638395}, {2418, 0.5124069478908189}, {
         2419, 0.4989665150888797}, {2420, 0.49421487603305786`}, {
         2421, 0.4969021065675341}, {2422, 0.5016515276630884}, {
         2423, 0.5138258357408172}, {2424, 0.5041254125412541}, {
         2425, 0.5051546391752577}, {2426, 0.510717230008244}, {
         2427, 0.5195714874330449}, {2428, 0.5127677100494233}, {
         2429, 0.5125566076574722}, {2430, 0.4810699588477366}, {
         2431, 0.49238996297819826`}, {2432, 0.4954769736842105}, {
         2433, 0.4928072338676531}, {2434, 0.5102711585866886}, {
         2435, 0.5055441478439425}, {2436, 0.5098522167487685}, {
         2437, 0.4985638079606073}, {2438, 0.5045118949958983}, {
         2439, 0.4911849118491185}, {2440, 0.49385245901639346`}, {
         2441, 0.4752150757886112}, {2442, 0.5032760032760033}, {
         2443, 0.5124846500204666}, {2444, 0.5110474631751227}, {
         2445, 0.49243353783231086`}, {2446, 0.49141455437448894`}, {
         2447, 0.4965263588067021}, {2448, 0.4889705882352941}, {
         2449, 0.4912209064924459}, {2450, 0.4910204081632653}, {
         2451, 0.5010199918400653}, {2452, 0.48858075040783033`}, {
         2453, 0.506318793314309}, {2454, 0.5118174409127955}, {
         2455, 0.5042769857433809}, {2456, 0.4995928338762215}, {
         2457, 0.49694749694749696`}, {2458, 0.4902359641985354}, {
         2459, 0.49247661651077673`}, {2460, 0.49308943089430896`}, {
         2461, 0.5050792360828932}, {2462, 0.4890333062550772}, {
         2463, 0.47503045066991473`}, {2464, 0.5064935064935064}, {
         2465, 0.5066937119675456}, {2466, 0.505271695052717}, {
         2467, 0.4864207539521686}, {2468, 0.49027552674230146`}, {
         2469, 0.49169704333738357`}, {2470, 0.4842105263157895}, {
         2471, 0.518818292189397}, {2472, 0.5004045307443366}, {
         2473, 0.5196118075212293}, {2474, 0.4975747776879547}, {
         2475, 0.4993939393939394}, {2476, 0.49636510500807757`}, {
         2477, 0.46507872426322167`}, {2478, 0.49878934624697335`}, {
         2479, 0.49697458652682536`}, {2480, 0.5161290322580645}, {
         2481, 0.4977831519548569}, {2482, 0.48348106365834004`}, {
         2483, 0.5118807893677003}, {2484, 0.49114331723027377`}, {
         2485, 0.49818913480885313`}, {2486, 0.498390989541432}, {
         2487, 0.49859268194611983`}, {2488, 0.4991961414790997}, {
         2489, 0.48854961832061067`}, {2490, 0.5208835341365462}, {
         2491, 0.4885588117221999}, {2492, 0.5060192616372392}, {
         2493, 0.4989971921379864}, {2494, 0.5152365677626303}, {
         2495, 0.5034068136272545}, {2496, 0.5012019230769231}, {
         2497, 0.4981978374048859}, {2498, 0.5052041633306645}, {
         2499, 0.4793917567026811}, {2500, 0.52}, {
         2501, 0.48620551779288285`}, {2502, 0.4860111910471623}, {
         2503, 0.4990011985617259}, {2504, 0.5111821086261981}, {
         2505, 0.48423153692614773`}, {2506, 0.4896249002394254}, {
         2507, 0.5065815715995213}, {2508, 0.5107655502392344}, {
         2509, 0.5105619768832204}, {2510, 0.5075697211155379}, {
         2511, 0.5033851055356432}, {2512, 0.5071656050955414}, {
         2513, 0.49462793473935535`}, {2514, 0.4785202863961814}, {
         2515, 0.5129224652087475}, {2516, 0.5047694753577107}, {
         2517, 0.49662296384584825`}, {2518, 0.48768864177918986`}, {
         2519, 0.4870980547836443}, {2520, 0.4785714285714286}, {
         2521, 0.5236017453391512}, {2522, 0.5027755749405234}, {
         2523, 0.5049544193420531}, {2524, 0.5154516640253566}, {
         2525, 0.5017821782178218}, {2526, 0.5}, {2527, 0.4910961614562723}, {
         2528, 0.5031645569620253}, {2529, 0.487149070778964}, {
         2530, 0.5011857707509881}, {2531, 0.5088897668905571}, {
         2532, 0.5106635071090048}, {2533, 0.48637978681405447`}, {
         2534, 0.5015785319652722}, {2535, 0.517948717948718}, {
         2536, 0.49290220820189273`}, {2537, 0.5053212455656287}, {
         2538, 0.512608353033885}, {2539, 0.4895628200078771}, {
         2540, 0.5003937007874015}, {2541, 0.4801259346713892}, {
         2542, 0.5121951219512195}, {2543, 0.4974439638222572}, {
         2544, 0.49803459119496857`}, {2545, 0.4943025540275049}, {
         2546, 0.516496465043205}, {2547, 0.5115822536317236}, {
         2548, 0.4933281004709576}, {2549, 0.48371910553158104`}, {
         2550, 0.49176470588235294`}, {2551, 0.5080360642885143}, {
         2552, 0.5074451410658307}, {2553, 0.4880532706619663}, {
         2554, 0.4745497259201253}, {2555, 0.5021526418786693}, {
         2556, 0.4894366197183099}, {2557, 0.4912006257332812}, {
         2558, 0.4910086004691165}, {2559, 0.5130910511918718}, {
         2560, 0.507421875}, {2561, 0.5158141351034752}, {
         2562, 0.4960967993754879}, {2563, 0.5271166601638705}, {
         2564, 0.499609984399376}, {2565, 0.49902534113060426`}, {
         2566, 0.49805144193296963`}, {2567, 0.5099337748344371}, {
         2568, 0.492601246105919}, {2569, 0.5099260412611911}, {
         2570, 0.4964980544747082}, {2571, 0.49941656942823803`}, {
         2572, 0.49611197511664074`}, {2573, 0.5149630781189273}, {
         2574, 0.47591297591297593`}, {2575, 0.4733980582524272}, {
         2576, 0.5205745341614907}, {2577, 0.4959254947613504}, {
         2578, 0.5015515903801396}, {2579, 0.5122140364482357}, {
         2580, 0.4906976744186046}, {2581, 0.4932196822936846}, {
         2582, 0.5112316034082107}, {2583, 0.4878048780487805}, {
         2584, 0.49458204334365324`}, {2585, 0.5106382978723404}, {
         2586, 0.5}, {2587, 0.4797062234248164}, {2588, 0.5100463678516228}, {
         2589, 0.5009656237929703}, {2590, 0.5061776061776062}, {
         2591, 0.5059822462369742}, {2592, 0.4930555555555556}, {
         2593, 0.49865021210952565`}, {2594, 0.49113338473400153`}, {
         2595, 0.5036608863198458}, {2596, 0.4984591679506934}, {
         2597, 0.49595687331536387`}, {2598, 0.4880677444187837}, {
         2599, 0.4855713736052328}, {2600, 0.48384615384615387`}, {
         2601, 0.4998077662437524}, {2602, 0.4792467332820907}, {
         2603, 0.5067230119093353}, {2604, 0.5019201228878648}, {
         2605, 0.5117082533589251}, {2606, 0.5084420567920184}, {
         2607, 0.507096279248178}, {2608, 0.4881134969325153}, {
         2609, 0.48217707934074355`}, {2610, 0.4754789272030651}, {
         2611, 0.4810417464572961}, {2612, 0.5022970903522205}, {
         2613, 0.5066972828166858}, {2614, 0.49655700076511095`}, {
         2615, 0.511281070745698}, {2616, 0.4996177370030581}, {
         2617, 0.5162399694306458}, {2618, 0.5118411000763942}, {
         2619, 0.4925544100801833}, {2620, 0.5194656488549618}, {
         2621, 0.4994276993513926}, {2622, 0.5026697177726926}, {
         2623, 0.49904689287075865`}, {2624, 0.49352134146341464`}, {
         2625, 0.5020952380952381}, {2626, 0.49047981721249045`}, {
         2627, 0.4895317853064332}, {2628, 0.4904870624048706}, {
         2629, 0.503993914035755}, {2630, 0.5045627376425855}, {
         2631, 0.5051311288483467}, {2632, 0.5087386018237082}, {
         2633, 0.49373338397265476`}, {2634, 0.4977220956719818}, {
         2635, 0.5020872865275142}, {2636, 0.49013657056145676`}, {
         2637, 0.490709139173303}, {2638, 0.4890068233510235}, {
         2639, 0.49677908298597956`}, {2640, 0.49962121212121213`}, {
         2641, 0.510412722453616}, {2642, 0.53444360333081}, {
         2643, 0.5270525917517972}, {2644, 0.5219364599092284}, {
         2645, 0.5035916824196597}, {2646, 0.5113378684807256}, {
         2647, 0.49678881752927845`}, {2648, 0.49244712990936557`}, {
         2649, 0.49867874669686674`}, {2650, 0.4958490566037736}, {
         2651, 0.4986797434930215}, {2652, 0.5094268476621417}, {
         2653, 0.502826988315115}, {2654, 0.49698568198944987`}, {
         2655, 0.4937853107344633}, {2656, 0.5003765060240963}, {
         2657, 0.4979299962363568}, {2658, 0.4966139954853273}, {
         2659, 0.5204964272282813}, {2660, 0.49849624060150377`}, {
         2661, 0.5122134535888764}, {2662, 0.48760330578512395`}, {
         2663, 0.5137063462260608}, {2664, 0.5056306306306306}, {
         2665, 0.49343339587242024`}, {2666, 0.5056264066016504}, {
         2667, 0.49643794525684287`}, {2668, 0.4816341829085457}, {
         2669, 0.5009366804046459}, {2670, 0.4902621722846442}, {
         2671, 0.4968176712841632}, {2672, 0.4883982035928144}, {
         2673, 0.5024317246539469}, {2674, 0.4887808526551982}, {
         2675, 0.5091588785046729}, {2676, 0.4992526158445441}, {
         2677, 0.5087784833769144}, {2678, 0.5100821508588499}, {
         2679, 0.49869354236655467`}, {2680, 0.5097014925373134}, {
         2681, 0.5065274151436031}, {2682, 0.5070842654735273}, {
         2683, 0.49161386507640703`}, {2684, 0.49850968703427717`}, {
         2685, 0.48640595903165734`}, {2686, 0.507446016381236}, {
         2687, 0.48902121324897657`}, {2688, 0.5085565476190477}, {
         2689, 0.4975827445146895}, {2690, 0.5159851301115241}, {
         2691, 0.4975845410628019}, {2692, 0.5070579494799405}, {
         2693, 0.4831043445971036}, {2694, 0.5037119524870082}, {
         2695, 0.4946196660482375}, {2696, 0.5037091988130564}, {
         2697, 0.5120504263997033}, {2698, 0.5055596738324685}, {
         2699, 0.5164875879955539}, {2700, 0.4988888888888889}, {
         2701, 0.5168456127360237}, {2702, 0.4933382679496669}, {
         2703, 0.49500554938956715`}, {2704, 0.4974112426035503}, {
         2705, 0.5131238447319778}, {2706, 0.4892830746489283}, {
         2707, 0.5068341337273735}, {2708, 0.5033234859675036}, {
         2709, 0.5090439276485789}, {2710, 0.5107011070110701}, {
         2711, 0.49760236075248987`}, {2712, 0.49041297935103245`}, {
         2713, 0.4976041282712864}, {2714, 0.4882092851879145}, {
         2715, 0.512707182320442}, {2716, 0.5165684830633285}, {
         2717, 0.4898785425101215}, {2718, 0.5088300220750552}, {
         2719, 0.4987127620448694}, {2720, 0.5113970588235294}, {
         2721, 0.5167217934582874}, {2722, 0.5007347538574578}, {
         2723, 0.4950422328314359}, {2724, 0.5018355359765051}, {
         2725, 0.5005504587155963}, {2726, 0.5062362435803375}, {
         2727, 0.49138247158049136`}, {2728, 0.4970674486803519}, {
         2729, 0.5042139978013924}, {2730, 0.5051282051282051}, {
         2731, 0.48553643354082754`}, {2732, 0.503294289897511}, {
         2733, 0.49286498353457736`}, {2734, 0.4959765910753475}, {
         2735, 0.5140767824497258}, {2736, 0.4956140350877193}, {
         2737, 0.49835586408476434`}, {2738, 0.5032870708546384}, {
         2739, 0.4801022270901789}, {2740, 0.4996350364963504}, {
         2741, 0.4990879241152864}, {2742, 0.48614150255288113`}, {
         2743, 0.5195041924899745}, {2744, 0.5018221574344023}, {
         2745, 0.497632058287796}, {2746, 0.47960670065549893`}, {
         2747, 0.50309428467419}, {2748, 0.5054585152838428}, {
         2749, 0.5078210258275737}, {2750, 0.5138181818181818}, {
         2751, 0.4954561977462741}, {2752, 0.4949127906976744}, {
         2753, 0.5070831819832909}, {2754, 0.5156136528685549}, {
         2755, 0.5161524500907441}, {2756, 0.5177793904208998}, {
         2757, 0.4889372506347479}, {2758, 0.5090645395213923}, {
         2759, 0.5034432765494744}, {2760, 0.5202898550724637}, {
         2761, 0.49547265483520464`}, {2762, 0.4960173787110789}, {
         2763, 0.499457111834962}, {2764, 0.5083212735166426}, {
         2765, 0.5045207956600362}, {2766, 0.5130151843817787}, {
         2767, 0.5056017347307553}, {2768, 0.5054190751445087}, {
         2769, 0.4911520404478151}, {2770, 0.4826714801444043}, {
         2771, 0.5009022013713461}, {2772, 0.49963924963924966`}, {
         2773, 0.49657410746483954`}, {2774, 0.4967555875991348}, {
         2775, 0.4962162162162162}, {2776, 0.5126080691642652}, {
         2777, 0.5070219661505222}, {2778, 0.49640028797696184`}, {
         2779, 0.4904641957538683}, {2780, 0.49712230215827335`}, {
         2781, 0.5120460266091335}, {2782, 0.49460819554277496`}, {
         2783, 0.48041681638519584`}, {2784, 0.4992816091954023}, {
         2785, 0.5012567324955116}, {2786, 0.5061019382627423}, {
         2787, 0.5062791532113383}, {2788, 0.5003586800573888}, {
         2789, 0.49731086410899966`}, {2790, 0.5089605734767025}, {
         2791, 0.5116445718380509}, {2792, 0.4992836676217765}, {
         2793, 0.5044754744002864}, {2794, 0.5007158196134575}, {
         2795, 0.4937388193202147}, {2796, 0.4946351931330472}, {
         2797, 0.5105470146585628}, {2798, 0.5103645461043602}, {
         2799, 0.5141121829224723}, {2800, 0.49107142857142855`}, {
         2801, 0.49839343091752947`}, {2802, 0.5121341898643826}, {
         2803, 0.5094541562611488}, {2804, 0.49072753209700426`}, {
         2805, 0.49625668449197863`}, {2806, 0.4932287954383464}, {
         2807, 0.5012468827930174}, {2808, 0.48896011396011396`}, {
         2809, 0.5008899964400142}, {2810, 0.4935943060498221}, {
         2811, 0.5001778726431875}, {2812, 0.5007112375533428}, {
         2813, 0.4788482047635976}, {2814, 0.488272921108742}, {
         2815, 0.4969804618117229}, {2816, 0.4971590909090909}, {
         2817, 0.4994675186368477}, {2818, 0.5078069552874379}, {
         2819, 0.4884710890386662}, {2820, 0.49148936170212765`}, {
         2821, 0.5097483161999291}, {2822, 0.49574769666902907`}, {
         2823, 0.504073680481757}, {2824, 0.4964589235127479}, {
         2825, 0.4860176991150442}, {2826, 0.5021231422505308}, {
         2827, 0.4771842943049169}, {2828, 0.481966053748232}, {
         2829, 0.5015906680805938}, {2830, 0.4929328621908127}, {
         2831, 0.5213705404450724}, {2832, 0.4897598870056497}, {
         2833, 0.5192375573596894}, {2834, 0.4911785462244178}, {
         2835, 0.48677248677248675`}, {2836, 0.502820874471086}, {
         2837, 0.5054635178004935}, {2838, 0.5232558139534884}, {
         2839, 0.5019373018668545}, {2840, 0.4915492957746479}, {
         2841, 0.5075677578317493}, {2842, 0.504222378606615}, {
         2843, 0.49947238832219487`}, {2844, 0.4957805907172996}, {
         2845, 0.5040421792618629}, {2846, 0.4877020379479972}, {
         2847, 0.49736564805057953`}, {2848, 0.5066713483146067}, {
         2849, 0.5008775008775008}, {2850, 0.49298245614035086`}, {
         2851, 0.49175727814801823`}, {2852, 0.4957924263674614}, {
         2853, 0.49631966351209256`}, {2854, 0.5052557813594954}, {
         2855, 0.5043782837127846}, {2856, 0.5108543417366946}, {
         2857, 0.48127406370318515`}, {2858, 0.49510146955913226`}, {
         2859, 0.5012242042672262}, {2860, 0.5017482517482518}, {
         2861, 0.4879412792729815}, {2862, 0.4979035639412998}, {
         2863, 0.5078588892769822}, {2864, 0.4888268156424581}, {
         2865, 0.5005235602094241}, {2866, 0.49860432658757853`}, {
         2867, 0.5252877572375305}, {2868, 0.4884937238493724}, {
         2869, 0.5130707563611014}, {2870, 0.5114982578397212}, {
         2871, 0.5060954371299199}, {2872, 0.49129526462395545`}, {
         2873, 0.5026105116602854}, {2874, 0.5020876826722338}, {
         2875, 0.5029565217391304}, {2876, 0.5045201668984701}, {
         2877, 0.4744525547445255}, {2878, 0.4906184850590688}, {
         2879, 0.4835012156998958}, {2880, 0.5038194444444445}, {
         2881, 0.4925373134328358}, {2882, 0.5100624566273422}, {
         2883, 0.48664585501214014`}, {2884, 0.49514563106796117`}, {
         2885, 0.5012131715771231}, {2886, 0.49306999306999305`}, {
         2887, 0.49982680983720124`}, {2888, 0.5051939058171745}, {
         2889, 0.4949809622706819}, {2890, 0.5044982698961937}, {
         2891, 0.5057073676928399}, {2892, 0.4847856154910097}, {
         2893, 0.5150362945039751}, {2894, 0.51209398756047}, {
         2895, 0.4918825561312608}, {2896, 0.5027624309392266}, {
         2897, 0.4894718674490853}, {2898, 0.4906832298136646}, {
         2899, 0.5067264573991032}, {2900, 0.47586206896551725`}, {
         2901, 0.5084453636677008}, {2902, 0.49517574086836663`}, {
         2903, 0.49362728212194285`}, {2904, 0.4810606060606061}, {
         2905, 0.5049913941480206}, {2906, 0.5075705437026841}, {
         2907, 0.5111799105607155}, {2908, 0.5106602475928473}, {
         2909, 0.5056720522516328}, {2910, 0.4986254295532646}, {
         2911, 0.5060116798351082}, {2912, 0.5020604395604396}, {
         2913, 0.4998283556470992}, {2914, 0.5003431708991077}, {
         2915, 0.5063464837049743}, {2916, 0.5123456790123457}, {
         2917, 0.5107987658553308}, {2918, 0.5092529129540782}, {
         2919, 0.5001712915381981}, {2920, 0.5041095890410959}, {
         2921, 0.49948647723382406`}, {2922, 0.5023956194387406}, {
         2923, 0.49196031474512486`}, {2924, 0.49897400820793436`}, {
         2925, 0.5052991452991453}, {2926, 0.5095693779904307}, {
         2927, 0.49231294841134265`}, {2928, 0.49556010928961747`}, {
         2929, 0.498122226015705}, {2930, 0.5037542662116041}, {
         2931, 0.4977823268509041}, {2932, 0.4897680763983629}, {
         2933, 0.49539720422775313`}, {2934, 0.4863667348329925}, {
         2935, 0.5155025553662692}, {2936, 0.5047683923705722}, {
         2937, 0.48552945182158663`}, {2938, 0.49863852961198096`}, {
         2939, 0.5100374276964954}, {2940, 0.4897959183673469}, {
         2941, 0.5086705202312138}, {2942, 0.4989802855200544}, {
         2943, 0.4926945293917771}, {2944, 0.49184782608695654`}, {
         2945, 0.5039049235993209}, {2946, 0.48879837067209775`}, {
         2947, 0.48286392941974887`}, {2948, 0.5050881953867028}, {
         2949, 0.4899966090200068}, {2950, 0.48033898305084743`}, {
         2951, 0.5042358522534734}, {2952, 0.4959349593495935}, {
         2953, 0.49407382323061294`}, {2954, 0.5084631008801624}, {
         2955, 0.5025380710659898}, {2956, 0.4861299052774019}, {
         2957, 0.512005410889415}, {2958, 0.4898580121703854}, {
         2959, 0.48935451165934435`}, {2960, 0.5023648648648649}, {
         2961, 0.497129348193178}, {2962, 0.4898717083051992}, {
         2963, 0.4954438069524131}, {2964, 0.49426450742240213`}, {
         2965, 0.5025295109612141}, {2966, 0.5020229265003372}, {
         2967, 0.5153353555780249}, {2968, 0.5148247978436657}, {
         2969, 0.5058942404850117}, {2970, 0.4986531986531986}, {
         2971, 0.5011780545270953}, {2972, 0.5053835800807537}, {
         2973, 0.5021863437605113}, {2974, 0.49630127774041694`}, {
         2975, 0.48638655462184877`}, {2976, 0.5050403225806451}, {
         2977, 0.5018474974806852}, {2978, 0.487239758226998}, {
         2979, 0.5085599194360524}, {2980, 0.5070469798657719}, {
         2981, 0.5005031868500504}, {2982, 0.4778672032193159}, {
         2983, 0.5025142474019444}, {2984, 0.5013404825737265}, {
         2985, 0.4964824120603015}, {2986, 0.5056932350971199}, {
         2987, 0.5001673920321392}, {2988, 0.4959839357429719}, {
         2989, 0.48745399799263966`}, {2990, 0.5117056856187291}, {
         2991, 0.5105315947843531}, {2992, 0.5140374331550802}, {
         2993, 0.5095222185098564}, {2994, 0.49599198396793587`}, {
         2995, 0.527212020033389}, {2996, 0.49833110814419224`}, {
         2997, 0.5081748415081748}, {2998, 0.5096731154102735}, {
         2999, 0.49949983327775926`}, {3000, 0.5006666666666667}, {
         3001, 0.4901699433522159}, {3002, 0.5123251165889408}, {
         3003, 0.49916749916749914`}, {3004, 0.48169107856191745`}, {
         3005, 0.49650582362728785`}, {3006, 0.49500998003992014`}, {
         3007, 0.50881277020286}, {3008, 0.5069813829787234}, {
         3009, 0.5104685942173479}, {3010, 0.5119601328903655}, {
         3011, 0.48987047492527397`}, {3012, 0.4903718459495352}, {
         3013, 0.48954530368403587`}, {3014, 0.5056403450564034}, {
         3015, 0.5170812603648425}, {3016, 0.513262599469496}, {
         3017, 0.49287371561153465`}, {3018, 0.4887342611000663}, {
         3019, 0.511758860549851}, {3020, 0.5006622516556292}, {
         3021, 0.5110890433631248}, {3022, 0.5029781601588352}, {
         3023, 0.5183592457823354}, {3024, 0.5076058201058201}, {
         3025, 0.4866115702479339}, {3026, 0.4993390614672835}, {
         3027, 0.5028080607862571}, {3028, 0.511889035667107}, {
         3029, 0.5090789039286894}, {3030, 0.4858085808580858}, {
         3031, 0.5064335202903332}, {3032, 0.5052770448548812}, {
         3033, 0.5031322123310253}, {3034, 0.4911008569545155}, {
         3035, 0.5060955518945635}, {3036, 0.4894598155467721}, {
         3037, 0.5113598946328614}, {3038, 0.4861751152073733}, {
         3039, 0.4945705824284304}, {3040, 0.5098684210526315}, {
         3041, 0.507398881946728}, {3042, 0.5013149243918474}, {
         3043, 0.49884981925731187`}, {3044, 0.4963863337713535}, {
         3045, 0.5070607553366174}, {3046, 0.4901510177281681}, {
         3047, 0.49622579586478505`}, {3048, 0.484251968503937}, {
         3049, 0.4922925549360446}, {3050, 0.5062295081967213}, {
         3051, 0.49098656178302197`}, {3052, 0.4983617300131062}, {
         3053, 0.47756305273501476`}, {3054, 0.49705304518664045`}, {
         3055, 0.5191489361702127}, {3056, 0.49345549738219896`}, {
         3057, 0.4975466143277723}, {3058, 0.49934597776324396`}, {
         3059, 0.5053939195815627}, {3060, 0.5130718954248366}, {
         3061, 0.49362953283240774`}, {3062, 0.49738732854343565`}, {
         3063, 0.5004897159647405}, {3064, 0.5003263707571801}, {
         3065, 0.48548123980424146`}, {3066, 0.5009784735812133}, {
         3067, 0.5053798500163026}, {3068, 0.5055410691003911}, {
         3069, 0.5073313782991202}, {3070, 0.5156351791530944}, {
         3071, 0.5118853793552589}, {3072, 0.4993489583333333}, {
         3073, 0.5161080377481289}, {3074, 0.5026024723487313}, {
         3075, 0.4978861788617886}, {3076, 0.494148244473342}, {
         3077, 0.4988625284367891}, {3078, 0.5038986354775828}, {
         3079, 0.5125040597596622}, {3080, 0.49642857142857144`}, {
         3081, 0.5128205128205128}, {3082, 0.4990266060999351}, {
         3083, 0.5024326954265326}, {3084, 0.4980544747081712}, {
         3085, 0.5170178282009724}, {3086, 0.4909267660401815}, {
         3087, 0.48817622287010043`}, {3088, 0.49870466321243523`}, {
         3089, 0.4991906765943671}, {3090, 0.5084142394822007}, {
         3091, 0.4949854416046587}, {3092, 0.5022639068564037}, {
         3093, 0.47171031361138055`}, {3094, 0.5038784744667097}, {
         3095, 0.48659127625201937`}, {3096, 0.48578811369509045`}, {
         3097, 0.4853083629318696}, {3098, 0.4903163331181407}, {
         3099, 0.5095191997418522}, {3100, 0.4958064516129032}, {
         3101, 0.4946791357626572}, {3102, 0.48452611218568664`}, {
         3103, 0.5082178536899774}, {3104, 0.5115979381443299}, {
         3105, 0.48695652173913045`}, {3106, 0.4974243399871217}, {
         3107, 0.5008046346958481}, {3108, 0.5077220077220077}, {
         3109, 0.48536506915406885`}, {3110, 0.5102893890675241}, {
         3111, 0.5020893603342976}, {3112, 0.4926092544987147}, {
         3113, 0.5159010600706714}, {3114, 0.5122029543994862}, {
         3115, 0.4914927768860353}, {3116, 0.5057766367137355}, {
         3117, 0.48925248636509466`}, {3118, 0.5115458627325209}, {
         3119, 0.5190766271240782}, {3120, 0.48685897435897435`}, {
         3121, 0.5209868631848766}, {3122, 0.5064061499039078}, {
         3123, 0.48703170028818443`}, {3124, 0.5060819462227913}, {
         3125, 0.49408}, {3126, 0.49744081893793984`}, {
         3127, 0.5027182603133994}, {3128, 0.48945012787723785`}, {
         3129, 0.5132630233301374}, {3130, 0.5031948881789138}, {
         3131, 0.4918556371766209}, {3132, 0.4929757343550447}, {
         3133, 0.4896265560165975}, {3134, 0.49393746011486916`}, {
         3135, 0.5052631578947369}, {3136, 0.4996811224489796}, {
         3137, 0.5109977685686962}, {3138, 0.5031867431485022}, {
         3139, 0.4979292768397579}, {3140, 0.5152866242038217}, {
         3141, 0.5055714740528494}, {3142, 0.4952259707192871}, {
         3143, 0.4893413935730194}, {3144, 0.5}, {3145, 0.5001589825119237}, {
         3146, 0.5092180546726002}, {3147, 0.5055608516047029}, {
         3148, 0.48856416772554}, {3149, 0.5014290250873293}, {
         3150, 0.49873015873015875`}, {3151, 0.49412884798476675`}, {
         3152, 0.5041243654822335}, {3153, 0.5049159530605772}, {
         3154, 0.5082435003170577}, {3155, 0.5061806656101426}, {
         3156, 0.49746514575411915`}, {3157, 0.4957237884067152}, {
         3158, 0.49651678277390754`}, {3159, 0.5068059512503957}, {
         3160, 0.5117088607594936}, {3161, 0.4761151534324581}, {
         3162, 0.48956356736242884`}, {3163, 0.5134366108125198}, {
         3164, 0.5053729456384324}, {3165, 0.49636650868878357`}, {
         3166, 0.4914718888186987}, {3167, 0.5029996842437638}, {
         3168, 0.49242424242424243`}, {3169, 0.502366677185232}, {
         3170, 0.48580441640378547`}, {3171, 0.4992116051718701}, {
         3172, 0.48833543505674654`}, {3173, 0.49889694295619286`}, {
         3174, 0.48424700693131695`}, {3175, 0.4859842519685039}, {
         3176, 0.4870906801007557}, {3177, 0.5064526282656594}, {
         3178, 0.47954688483322844`}, {3179, 0.5007864108210129}, {
         3180, 0.4968553459119497}, {3181, 0.49607041810751334`}, {
         3182, 0.4908862350722816}, {3183, 0.4948162111215834}, {
         3184, 0.4937185929648241}, {3185, 0.5051805337519624}, {
         3186, 0.5034526051475204}, {3187, 0.4841543771572011}, {
         3188, 0.5062735257214555}, {3189, 0.4929444967074318}, {
         3190, 0.5094043887147336}, {3191, 0.5048574114697587}, {
         3192, 0.49906015037593987`}, {3193, 0.4982774819918572}, {
         3194, 0.5081402629931121}, {3195, 0.4945226917057903}, {
         3196, 0.493116395494368}, {3197, 0.4842039411948702}, {
         3198, 0.49906191369606}, {3199, 0.49859331040950294`}, {
         3200, 0.4840625}, {3201, 0.5048422368009997}, {
         3202, 0.49594003747657717`}, {3203, 0.5110833593506088}, {
         3204, 0.5009363295880149}, {3205, 0.5057722308892356}, {
         3206, 0.5084217092950717}, {3207, 0.4982850015590895}, {
         3208, 0.4940773067331671}, {3209, 0.5148021190401995}, {
         3210, 0.5024922118380062}, {3211, 0.5038928682653379}, {
         3212, 0.5065379825653799}, {3213, 0.49610955493308434`}, {
         3214, 0.5034225264467953}, {3215, 0.49673405909797824`}, {
         3216, 0.5046641791044776}, {3217, 0.5119676717438607}, {
         3218, 0.4925419515226849}, {3219, 0.49642746194470333`}, {
         3220, 0.5027950310559006}, {3221, 0.49705060540204904`}, {
         3222, 0.49875853507138423`}, {3223, 0.5041886441203848}, {
         3224, 0.5055831265508685}, {3225, 0.5156589147286822}, {
         3226, 0.49194048357098574`}, {3227, 0.5007747133560583}, {
         3228, 0.5046468401486989}, {3229, 0.4982966862805822}, {
         3230, 0.5024767801857585}, {3231, 0.5069637883008357}, {
         3232, 0.48948019801980197`}, {3233, 0.5069594803587999}, {
         3234, 0.49598021026592454`}, {3235, 0.512210200927357}, {
         3236, 0.507416563658838}, {3237, 0.49613839975285756`}, {
         3238, 0.48579369981470044`}, {3239, 0.4989194195739426}, {
         3240, 0.5083333333333333}, {3241, 0.5007713668620796}, {
         3242, 0.512646514497224}, {3243, 0.49707061362935556`}, {
         3244, 0.500924784217016}, {3245, 0.4884437596302003}, {
         3246, 0.5049291435613062}, {3247, 0.5010779180782261}, {
         3248, 0.49476600985221675`}, {3249, 0.5084641428131733}, {
         3250, 0.4969230769230769}, {3251, 0.4918486619501692}, {
         3252, 0.498769987699877}, {3253, 0.513064863203197}, {
         3254, 0.49784880147510757`}, {3255, 0.4946236559139785}, {
         3256, 0.4950859950859951}, {3257, 0.5234878722750997}, {
         3258, 0.5159607120933087}, {3259, 0.509051856397668}, {
         3260, 0.5101226993865031}, {3261, 0.4973934375958295}, {
         3262, 0.5018393623543839}, {3263, 0.503524364082133}, {
         3264, 0.5003063725490197}, {3265, 0.5099540581929556}, {
         3266, 0.5116350275566443}, {3267, 0.5084175084175084}, {
         3268, 0.5152998776009792}, {3269, 0.5013765677577241}, {
         3270, 0.500611620795107}, {3271, 0.5230816264139407}, {
         3272, 0.5125305623471883}, {3273, 0.5004582951420715}, {
         3274, 0.48014660965180206`}, {3275, 0.5062595419847328}, {
         3276, 0.5094627594627594}, {3277, 0.4974061641745499}, {3278, 0.5}, {
         3279, 0.5025922537358951}, {3280, 0.510060975609756}, {
         3281, 0.4989332520572996}, {3282, 0.4960390006093845}, {
         3283, 0.5092902832774902}, {3284, 0.5036540803897686}, {
         3285, 0.4812785388127854}, {3286, 0.5127814972611078}, {
         3287, 0.5132339519318527}, {3288, 0.5088199513381995}, {
         3289, 0.47917300091213133`}, {3290, 0.4972644376899696}, {
         3291, 0.4980249164387724}, {3292, 0.5051640340218712}, {
         3293, 0.5129061645915578}, {3294, 0.49058894960534305`}, {
         3295, 0.5007587253414264}, {3296, 0.5097087378640777}, {
         3297, 0.4910524719441917}, {3298, 0.5027289266221953}, {
         3299, 0.4937859957562898}, {3300, 0.5072727272727273}, {
         3301, 0.49378976067858227`}, {3302, 0.514839491217444}, {
         3303, 0.5083257644565546}, {3304, 0.49909200968523004`}, {
         3305, 0.49712556732223906`}, {3306, 0.5054446460980037}, {
         3307, 0.4974296945872392}, {3308, 0.5}, {3309, 0.4904805077062557}, {
         3310, 0.49123867069486404`}, {3311, 0.4844457867713682}, {
         3312, 0.5009057971014492}, {3313, 0.49924539692121944`}, {
         3314, 0.5087507543753772}, {3315, 0.5131221719457013}, {
         3316, 0.4969843184559711}, {3317, 0.5058788061501357}, {
         3318, 0.4984930681133213}, {3319, 0.5001506477854776}, {
         3320, 0.5177710843373494}, {3321, 0.5106895513399579}, {
         3322, 0.5078266104756171}, {3323, 0.5040625940415288}, {
         3324, 0.509927797833935}, {3325, 0.4938345864661654}, {
         3326, 0.5039085989176187}, {3327, 0.49894800120228433`}, {
         3328, 0.5018028846153846}, {3329, 0.5052568338840493}, {
         3330, 0.4828828828828829}, {3331, 0.5043530471329931}, {
         3332, 0.49429771908763503`}, {3333, 0.49174917491749176`}, {
         3334, 0.5095980803839232}, {3335, 0.5031484257871065}, {
         3336, 0.5002997601918465}, {3337, 0.5127359904105484}, {
         3338, 0.4781306171360096}, {3339, 0.4917640011979635}, {
         3340, 0.47664670658682634`}, {3341, 0.5121221191260101}, {
         3342, 0.5017953321364452}, {3343, 0.49925216871073885`}, {
         3344, 0.5128588516746412}, {3345, 0.512406576980568}, {
         3346, 0.4943215780035864}, {3347, 0.5067224380041828}, {
         3348, 0.502389486260454}, {3349, 0.5079128097939684}, {
         3350, 0.5143283582089552}, {3351, 0.4938824231572665}, {
         3352, 0.5038782816229117}, {3353, 0.5073068893528184}, {
         3354, 0.49612403100775193`}, {3355, 0.49299552906110283`}, {
         3356, 0.5041716328963052}, {3357, 0.4965743223115877}, {
         3358, 0.5008933889219773}, {3359, 0.5022328073831498}, {
         3360, 0.49851190476190477`}, {3361, 0.5069919666765843}, {
         3362, 0.5121951219512195}, {3363, 0.5069878085043116}, {
         3364, 0.4958382877526754}, {3365, 0.5052005943536404}, {
         3366, 0.4958407605466429}, {3367, 0.49717849717849716`}, {
         3368, 0.48693586698337293`}, {3369, 0.4951024042742654}, {
         3370, 0.4937685459940653}, {3371, 0.49599525363393654`}, {
         3372, 0.4919928825622776}, {3373, 0.49747998814112065`}, {
         3374, 0.4967397747480735}, {3375, 0.5096296296296297}, {
         3376, 0.49229857819905215`}, {3377, 0.47260882440035534`}, {
         3378, 0.49822380106571934`}, {3379, 0.48831015093222846`}, {
         3380, 0.5032544378698225}, {3381, 0.5001478852410529}, {
         3382, 0.47930218805440566`}, {3383, 0.507537688442211}, {
         3384, 0.48817966903073284`}, {3385, 0.5087149187592319}, {
         3386, 0.5062020082693444}, {3387, 0.5187481547091821}, {
         3388, 0.4881936245572609}, {3389, 0.5001475361463559}, {
         3390, 0.4920353982300885}, {3391, 0.5131229725744618}, {
         3392, 0.4994103773584906}, {3393, 0.49572649572649574`}, {
         3394, 0.49440188568061283`}, {3395, 0.5010309278350515}, {
         3396, 0.4958775029446408}, {3397, 0.5069178687076833}, {
         3398, 0.49117127722189524`}, {3399, 0.5030891438658429}, {
         3400, 0.49470588235294116`}, {3401, 0.49573654807409584`}, {
         3402, 0.5020576131687243}, {3403, 0.5004407875404056}, {
         3404, 0.4973560517038778}, {3405, 0.4919236417033774}, {
         3406, 0.5032295948326483}, {3407, 0.49280892280598765`}, {
         3408, 0.48151408450704225`}, {3409, 0.5051334702258727}, {
         3410, 0.5228739002932551}, {3411, 0.514805042509528}, {
         3412, 0.5011723329425557}, {3413, 0.5089364195722238}, {
         3414, 0.507908611599297}, {3415, 0.49633967789165445`}, {
         3416, 0.48975409836065575`}, {3417, 0.482294410301434}, {
         3418, 0.5017554125219427}, {3419, 0.49839134249780637`}, {
         3420, 0.49239766081871345`}, {3421, 0.503946214557147}, {
         3422, 0.49590882524839275`}, {3423, 0.49167397020157755`}, {
         3424, 0.5032126168224299}, {3425, 0.5036496350364964}, {
         3426, 0.4941622883829539}, {3427, 0.492850889991246}, {
         3428, 0.49008168028004667`}, {3429, 0.4989792942548848}, {
         3430, 0.5020408163265306}, {3431, 0.49956280967647915`}, {
         3432, 0.5017482517482518}, {3433, 0.49752403145936497`}, {
         3434, 0.49039021549213746`}, {3435, 0.5080058224163028}, {
         3436, 0.5061117578579744}, {3437, 0.5027640384055863}, {
         3438, 0.49941826643397325`}, {3439, 0.49520209363186973`}, {
         3440, 0.49796511627906975`}, {3441, 0.4954954954954955}, {
         3442, 0.49825682742591515`}, {3443, 0.5013069997095556}, {
         3444, 0.5043554006968641}, {3445, 0.49288824383164004`}, {
         3446, 0.5046430644225188}, {3447, 0.48970118944009283`}, {
         3448, 0.4965197215777262}, {3449, 0.512032473180632}, {
         3450, 0.5017391304347826}, {3451, 0.5027528252680382}, {
         3452, 0.4985515643105446}, {3453, 0.5010136113524472}, {
         3454, 0.5026056745801969}, {3455, 0.5015918958031838}, {
         3456, 0.48929398148148145`}, {3457, 0.4911773213769164}, {
         3458, 0.496818970503181}, {3459, 0.5001445504481064}, {
         3460, 0.4930635838150289}, {3461, 0.5036116729268998}, {
         3462, 0.5098209127671866}, {3463, 0.49754548079699684`}, {
         3464, 0.4896073903002309}, {3465, 0.49927849927849927`}, {
         3466, 0.49682631275245237`}, {3467, 0.5191808479953851}, {
         3468, 0.49019607843137253`}, {3469, 0.5010089362928798}, {
         3470, 0.5123919308357349}, {3471, 0.5036012676462115}, {
         3472, 0.5118087557603687}, {3473, 0.49812841923409157`}, {
         3474, 0.5112262521588946}, {3475, 0.4909352517985612}, {
         3476, 0.5057537399309551}, {3477, 0.5081967213114754}, {
         3478, 0.4905117883841288}, {3479, 0.5058924978442081}, {
         3480, 0.5002873563218391}, {3481, 0.5262855501292732}, {
         3482, 0.49798966111430215`}, {3483, 0.5024404249210451}, {
         3484, 0.5045924225028703}, {3485, 0.5015781922525108}, {
         3486, 0.5014343086632244}, {3487, 0.48293662173788354`}, {
         3488, 0.5086009174311926}, {3489, 0.5093149899684724}, {
         3490, 0.49312320916905444`}, {3491, 0.5098825551417931}, {
         3492, 0.5080183276059564}, {3493, 0.4958488405382193}, {
         3494, 0.49456210646823123`}, {3495, 0.49298998569384833`}, {
         3496, 0.5031464530892449}, {3497, 0.5058621675722047}, {
         3498, 0.5008576329331046}, {3499, 0.49042583595312944`}, {
         3500, 0.4962857142857143}, {3501, 0.4961439588688946}, {
         3502, 0.4971444888635066}, {3503, 0.4835854981444476}, {
         3504, 0.495148401826484}, {3505, 0.5007132667617689}, {
         3506, 0.49429549343981743`}, {3507, 0.5086968919304249}, {
         3508, 0.49173318129988597`}, {3509, 0.5081219720718153}, {
         3510, 0.4931623931623932}, {3511, 0.49416120763315297`}, {
         3512, 0.5111047835990888}, {3513, 0.506689439225733}, {
         3514, 0.50199203187251}, {3515, 0.5089615931721195}, {
         3516, 0.5008532423208191}, {3517, 0.4972988342337219}, {
         3518, 0.48692438885730527`}, {3519, 0.5004262574595055}, {
         3520, 0.49232954545454544`}, {3521, 0.5032661175802329}, {
         3522, 0.49744463373083475`}, {3523, 0.5120635821742833}, {
         3524, 0.5127695800227015}, {3525, 0.48936170212765956`}, {
         3526, 0.5}, {3527, 0.49645591153955204`}, {
         3528, 0.49744897959183676`}, {3529, 0.4990082176253896}, {
         3530, 0.4915014164305949}, {3531, 0.514018691588785}, {
         3532, 0.5039637599093998}, {3533, 0.49278233795641097`}, {
         3534, 0.49971703452178834`}, {3535, 0.499009900990099}, {
         3536, 0.4912330316742081}, {3537, 0.4953350296861747}, {
         3538, 0.5076314301865461}, {3539, 0.513421870584911}, {
         3540, 0.5096045197740113}, {3541, 0.504659700649534}, {
         3542, 0.5206098249576511}, {3543, 0.4995766299745978}, {
         3544, 0.5160835214446953}, {3545, 0.5055007052186178}, {
         3546, 0.4966159052453469}, {3547, 0.5026783197067944}, {
         3548, 0.5064825253664036}, {3549, 0.482952944491406}, {
         3550, 0.5146478873239436}, {3551, 0.5142213460996903}, {
         3552, 0.5076013513513513}, {3553, 0.5012665353222628}, {
         3554, 0.4966235227912212}, {3555, 0.509423347398031}, {
         3556, 0.49268841394825647`}, {3557, 0.5029519257801518}, {
         3558, 0.5061832490163013}, {3559, 0.5082888451812306}, {
         3560, 0.5106741573033707}, {3561, 0.5094074698118506}, {
         3562, 0.508422234699607}, {3563, 0.4810552904855459}, {
         3564, 0.4890572390572391}, {3565, 0.5018232819074334}, {
         3566, 0.4988782950084128}, {3567, 0.5012615643397813}, {
         3568, 0.51597533632287}, {3569, 0.49873914261697955`}, {
         3570, 0.492436974789916}, {3571, 0.5068608232987959}, {
         3572, 0.5053191489361702}, {3573, 0.49286314021830396`}, {
         3574, 0.5044767767207611}, {3575, 0.49874125874125874`}, {
         3576, 0.5103467561521253}, {3577, 0.5163544870002795}, {
         3578, 0.5075461151481274}, {3579, 0.5110366024029058}, {
         3580, 0.5041899441340782}, {3581, 0.4937168388718235}, {
         3582, 0.4946957007258515}, {3583, 0.5107451855986603}, {
         3584, 0.4946986607142857}, {3585, 0.501255230125523}, {
         3586, 0.5119910764082544}, {3587, 0.5087817117368274}, {
         3588, 0.4972129319955407}, {3589, 0.5057118974644748}, {
         3590, 0.48802228412256266`}, {3591, 0.5015316067947647}, {
         3592, 0.5091870824053452}, {3593, 0.49123295296409686`}, {
         3594, 0.5108514190317195}, {3595, 0.5034770514603616}, {
         3596, 0.5088987764182424}, {3597, 0.49902696691687515`}, {
         3598, 0.49694274596998333`}, {3599, 0.504306751875521}, {
         3600, 0.5108333333333334}, {3601, 0.5120799777839489}, {
         3602, 0.5080510827318157}, {3603, 0.5004163197335554}, {
         3604, 0.49778024417314093`}, {3605, 0.507628294036061}, {
         3606, 0.5174708818635607}, {3607, 0.5029110063764901}, {
         3608, 0.5005543237250555}, {3609, 0.5065114990302023}, {
         3610, 0.4883656509695291}, {3611, 0.49903073940736636`}, {
         3612, 0.4952934662236988}, {3613, 0.5084417381677276}, {
         3614, 0.5179856115107914}, {3615, 0.5048409405255878}, {
         3616, 0.5080199115044248}, {3617, 0.4893558197401161}, {
         3618, 0.48258706467661694`}, {3619, 0.5012434374136502}, {
         3620, 0.5027624309392266}, {3621, 0.49930958298812483`}, {
         3622, 0.4955825510767532}, {3623, 0.49875793541264146`}, {
         3624, 0.5066225165562914}, {3625, 0.5026206896551724}, {
         3626, 0.4988968560397132}, {3627, 0.4918665563826854}, {
         3628, 0.5049614112458655}, {3629, 0.5048222650868007}, {
         3630, 0.503305785123967}, {3631, 0.49490498485265766`}, {
         3632, 0.5162444933920705}, {3633, 0.4877511698320947}, {
         3634, 0.4865162355531095}, {3635, 0.5130674002751031}, {
         3636, 0.5027502750275028}, {3637, 0.48941435248831455`}, {
         3638, 0.488455195162177}, {3639, 0.5147018411651553}, {
         3640, 0.5082417582417582}, {3641, 0.49409502883823125`}, {
         3642, 0.4925864909390445}, {3643, 0.49903925336261323`}, {
         3644, 0.49121844127332603`}, {3645, 0.49382716049382713`}, {
         3646, 0.49808008776741636`}, {3647, 0.5075404442007129}, {
         3648, 0.5079495614035088}, {3649, 0.5050698821594958}, {
         3650, 0.49424657534246574`}, {3651, 0.4968501780334155}, {
         3652, 0.49890470974808326`}, {3653, 0.49876813577881196`}, {
         3654, 0.5046524356869184}, {3655, 0.5058823529411764}, {
         3656, 0.49179431072210067`}, {3657, 0.5099808586272901}, {
         3658, 0.5125751776927283}, {3659, 0.4957638699098114}, {
         3660, 0.4792349726775956}, {3661, 0.5058727123736684}, {
         3662, 0.4986346258874932}, {3663, 0.4933114933114933}, {
         3664, 0.5087336244541485}, {3665, 0.4903137789904502}, {
         3666, 0.5013638843426077}, {3667, 0.485955822197982}, {
         3668, 0.5084514721919302}, {3669, 0.5053147996729354}, {
         3670, 0.502724795640327}, {3671, 0.49414328520839007`}, {
         3672, 0.49155773420479304`}, {3673, 0.500136128505309}, {
         3674, 0.49836690255851934`}, {3675, 0.487891156462585}, {
         3676, 0.49782372143634385`}, {3677, 0.49959205874354096`}, {
         3678, 0.4940184883088635}, {3679, 0.48654525686327804`}, {
         3680, 0.483695652173913}, {3681, 0.49578918772072805`}, {
         3682, 0.5010863661053775}, {3683, 0.49904968775454794`}, {
         3684, 0.494299674267101}, {3685, 0.4936227951153324}, {
         3686, 0.4967444384156267}, {3687, 0.5128831027935992}, {
         3688, 0.5043383947939263}, {3689, 0.5071835185687178}, {
         3690, 0.4994579945799458}, {3691, 0.5028447575182877}, {
         3692, 0.5111050920910076}, {3693, 0.4849715678310317}, {
         3694, 0.4956686518678939}, {3695, 0.4803788903924222}, {
         3696, 0.5100108225108225}, {3697, 0.4920205572085475}, {
         3698, 0.4975662520281233}, {3699, 0.5071640984049743}, {
         3700, 0.5151351351351351}, {3701, 0.4990543096460416}, {
         3702, 0.5113452188006483}, {3703, 0.5036456926816095}, {
         3704, 0.5099892008639308}, {3705, 0.5036437246963563}, {
         3706, 0.488667026443605}, {3707, 0.5028324790936067}, {
         3708, 0.5008090614886731}, {3709, 0.5146939875977352}, {
         3710, 0.5080862533692723}, {3711, 0.5068714632174616}, {
         3712, 0.49757543103448276`}, {3713, 0.4909776461082683}, {
         3714, 0.5021540118470652}, {3715, 0.4920592193808883}, {
         3716, 0.5021528525296017}, {3717, 0.487758945386064}, {
         3718, 0.49327595481441633`}, {3719, 0.4891099757999462}, {
         3720, 0.5099462365591397}, {3721, 0.4845471647406611}, {
         3722, 0.4938205265986029}, {3723, 0.5071179156594144}, {
         3724, 0.4943609022556391}, {3725, 0.49771812080536915`}, {
         3726, 0.4967793880837359}, {3727, 0.5041588408907969}, {
         3728, 0.49543991416309013`}, {3729, 0.5009385894341647}, {
         3730, 0.48552278820375333`}, {3731, 0.49825783972125437`}, {
         3732, 0.49732047159699894`}, {3733, 0.4947763193142245}, {
         3734, 0.5251740760578468}, {3735, 0.4958500669344043}, {
         3736, 0.49678800856531047`}, {3737, 0.4929087503344929}, {
         3738, 0.5029427501337613}, {3739, 0.5062851029687082}, {
         3740, 0.513903743315508}, {3741, 0.5094894413258487}, {
         3742, 0.49305184393372525`}, {3743, 0.49532460593107136`}, {
         3744, 0.5050747863247863}, {3745, 0.5068090787716956}, {
         3746, 0.4922584089695675}, {3747, 0.4931945556445156}, {
         3748, 0.48986125933831376`}, {3749, 0.49533208855694855`}, {
         3750, 0.5096}, {3751, 0.5027992535323914}, {
         3752, 0.5005330490405118}, {3753, 0.486810551558753}, {
         3754, 0.5018646776771444}, {3755, 0.4929427430093209}, {
         3756, 0.4933439829605964}, {3757, 0.48948629225445833`}, {
         3758, 0.49414582224587544`}, {3759, 0.48789571694599626`}, {
         3760, 0.5013297872340425}, {3761, 0.5094389789949482}, {
         3762, 0.5037214247740563}, {3763, 0.504384799362211}, {
         3764, 0.49946865037194477`}, {3765, 0.500929614873838}, {
         3766, 0.49734466277217204`}, {3767, 0.4871250331829042}, {
         3768, 0.49654989384288745`}, {3769, 0.5083576545502786}, {
         3770, 0.5010610079575597}, {3771, 0.5062317687616017}, {
         3772, 0.5026511134676565}, {3773, 0.48263980917042143`}, {
         3774, 0.49576046634870163`}, {3775, 0.5017218543046358}, {
         3776, 0.5121822033898306}, {3777, 0.49827905745300505`}, {
         3778, 0.5100582318687136}, {3779, 0.4969568668960042}, {
         3780, 0.4984126984126984}, {3781, 0.5215551441417614}, {
         3782, 0.4949762030671602}, {3783, 0.49537404176579436`}, {
         3784, 0.4894291754756871}, {3785, 0.49616908850726554`}, {
         3786, 0.5108293713681986}, {3787, 0.4953789279112754}, {
         3788, 0.498416050686378}, {3789, 0.5067300079176563}, {
         3790, 0.5197889182058048}, {3791, 0.5069902400422053}, {
         3792, 0.4978902953586498}, {3793, 0.5035591879778539}, {
         3794, 0.4831312598840274}, {3795, 0.5148880105401844}, {
         3796, 0.4965753424657534}, {3797, 0.499341585462207}, {
         3798, 0.5073723012111637}, {3799, 0.5048697025533035}, {
         3800, 0.5060526315789474}, {3801, 0.4938174164693502}, {
         3802, 0.4994739610731194}, {3803, 0.48987641335787535`}, {
         3804, 0.5055205047318612}, {3805, 0.5103810775295664}, {
         3806, 0.5021019442984761}, {3807, 0.491725768321513}, {
         3808, 0.510766806722689}, {3809, 0.49041743239695457`}, {
         3810, 0.49816272965879266`}, {3811, 0.5030175806874836}, {
         3812, 0.4960650577124869}, {3813, 0.5048518227117755}, {
         3814, 0.5023597273203986}, {3815, 0.5019659239842726}, {
         3816, 0.48742138364779874`}, {3817, 0.4962012051349227}, {
         3818, 0.50130958617077}, {3819, 0.4927991620843153}, {
         3820, 0.4950261780104712}, {3821, 0.49070923841926195`}, {
         3822, 0.5036630036630036}, {3823, 0.5040544075333507}, {
         3824, 0.5010460251046025}, {3825, 0.4956862745098039}, {
         3826, 0.48823836905384216`}, {3827, 0.49176900966814735`}, {
         3828, 0.5049634273772204}, {3829, 0.4962131104727083}, {
         3830, 0.5002610966057441}, {3831, 0.4964761158966327}, {
         3832, 0.49399791231732776`}, {3833, 0.48525958779024264`}, {
         3834, 0.5020865936358894}, {3835, 0.4821382007822686}, {
         3836, 0.49739311783107404`}, {3837, 0.49648162627052383`}, {
         3838, 0.5026055237102658}, {3839, 0.5126334983068508}, {
         3840, 0.5018229166666667}, {3841, 0.5024733142410831}, {
         3842, 0.5083289953149401}, {3843, 0.4899817850637523}, {
         3844, 0.5005202913631633}, {3845, 0.5045513654096229}, {
         3846, 0.49765990639625585`}, {3847, 0.5009097998440343}, {
         3848, 0.4987006237006237}, {3849, 0.5084437516237984}, {
         3850, 0.5038961038961038}, {3851, 0.5107764217086471}, {
         3852, 0.4935098650051921}, {3853, 0.5055800674798858}, {
         3854, 0.50570835495589}, {3855, 0.4972762645914397}, {
         3856, 0.5038900414937759}, {3857, 0.5099818511796733}, {
         3858, 0.48989113530326595`}, {3859, 0.49727908784659236`}, {
         3860, 0.5023316062176166}, {3861, 0.49391349391349393`}, {
         3862, 0.4997410668047644}, {3863, 0.5161791353870049}, {
         3864, 0.49145962732919257`}, {3865, 0.4990944372574386}, {
         3866, 0.49405069839627525`}, {3867, 0.5053012671321437}, {
         3868, 0.5012926577042399}, {3869, 0.5021969501163092}, {
         3870, 0.5020671834625323}, {3871, 0.5009041591320073}, {
         3872, 0.4956095041322314}, {3873, 0.4990963077717532}, {
         3874, 0.4922560660815694}, {3875, 0.5132903225806451}, {
         3876, 0.5147058823529411}, {3877, 0.4918751612071189}, {
         3878, 0.5165033522434245}, {3879, 0.5003866976024749}, {
         3880, 0.5015463917525773}, {3881, 0.4975521772738985}, {
         3882, 0.49484801648634724`}, {3883, 0.49163018284831317`}, {
         3884, 0.5066941297631308}, {3885, 0.5001287001287001}, {
         3886, 0.489963973237262}, {3887, 0.507332132750193}, {
         3888, 0.5010288065843621}, {3889, 0.499357161223965}, {
         3890, 0.5017994858611825}, {3891, 0.5001285016705217}, {
         3892, 0.49563206577595065`}, {3893, 0.5078345748779861}, {
         3894, 0.4881869542886492}, {3895, 0.489602053915276}, {
         3896, 0.5007700205338809}, {3897, 0.5101360020528611}, {
         3898, 0.5064135454079015}, {3899, 0.5085919466529879}, {
         3900, 0.49641025641025643`}, {3901, 0.5091002307100744}, {
         3902, 0.5023065094823168}, {3903, 0.4924417115039713}, {
         3904, 0.48258196721311475`}, {3905, 0.49884763124199744`}, {
         3906, 0.5074244751664106}, {3907, 0.5042231891476836}, {
         3908, 0.5071647901740021}, {3909, 0.4932207725761064}, {
         3910, 0.5063938618925832}, {3911, 0.4730248018409614}, {
         3912, 0.49233128834355827`}, {3913, 0.5134168157423972}, {
         3914, 0.49310168625447115`}, {3915, 0.49757343550447}, {
         3916, 0.5020429009193054}, {3917, 0.49808526933877967`}, {
         3918, 0.49387442572741197`}, {3919, 0.5098239346772135}, {
         3920, 0.48239795918367345`}, {3921, 0.4912012241775057}, {
         3922, 0.48470168281489034`}, {3923, 0.4975783838898802}, {
         3924, 0.4908256880733945}, {3925, 0.4988535031847134}, {
         3926, 0.499745287824758}, {3927, 0.5044563279857398}, {
         3928, 0.5038187372708758}, {3929, 0.4886739628404174}, {
         3930, 0.5035623409669211}, {3931, 0.5029254642584584}, {
         3932, 0.4928789420142421}, {3933, 0.4988558352402746}, {
         3934, 0.5025419420437214}, {3935, 0.49580686149936465`}, {
         3936, 0.5114329268292683}, {3937, 0.49580899161798325`}, {
         3938, 0.505332656170645}, {3939, 0.4970804772784971}, {
         3940, 0.5139593908629442}, {3941, 0.4887084496320731}, {
         3942, 0.49644850329781837`}, {3943, 0.5130611209738778}, {
         3944, 0.4977180527383367}, {3945, 0.4879594423320659}, {
         3946, 0.5048150025342119}, {3947, 0.504433747149734}, {
         3948, 0.5005065856129686}, {3949, 0.490503925044315}, {
         3950, 0.5073417721518987}, {3951, 0.5031637560111364}, {
         3952, 0.49873481781376516`}, {3953, 0.5188464457374147}, {
         3954, 0.48887202832574606`}, {3955, 0.5011378002528445}, {
         3956, 0.5123862487360971}, {3957, 0.5168056608541824}, {
         3958, 0.504800404244568}, {3959, 0.5006314725940895}, {
         3960, 0.5095959595959596}, {3961, 0.5021459227467812}, {
         3962, 0.5073195355880868}, {3963, 0.49104213979308603`}, {
         3964, 0.4979818365287588}, {3965, 0.5145018915510718}, {
         3966, 0.5090771558245083}, {3967, 0.5180236954877742}, {
         3968, 0.5073084677419355}, {3969, 0.491055681531872}, {
         3970, 0.5065491183879093}, {3971, 0.5152354570637119}, {
         3972, 0.5002517623363545}, {3973, 0.4960986659954694}, {
         3974, 0.4969803724207348}, {3975, 0.5011320754716981}, {
         3976, 0.5047786720321932}, {3977, 0.5174754840331909}, {
         3978, 0.5035193564605329}, {3979, 0.4847951746670018}, {
         3980, 0.4992462311557789}, {3981, 0.4958553127354936}, {
         3982, 0.4982420894023104}, {3983, 0.4973637961335677}, {
         3984, 0.49698795180722893`}, {3985, 0.514930991217064}, {
         3986, 0.48795785248369294`}, {3987, 0.5056433408577878}, {
         3988, 0.5067703109327983}, {3989, 0.4966156931561795}, {
         3990, 0.5142857142857142}, {3991, 0.5076421949386118}, {
         3992, 0.5057615230460922}, {3993, 0.4866015527172552}, {
         3994, 0.49248873309964947`}, {3995, 0.49737171464330415`}, {
         3996, 0.4922422422422422}, {3997, 0.4963722792094071}, {
         3998, 0.5065032516258129}, {3999, 0.5113778444611152}, {
         4000, 0.5085}, {4001, 0.49612596850787305`}, {
         4002, 0.49900049975012495`}, {4003, 0.496127904071946}, {
         4004, 0.5034965034965035}, {4005, 0.48963795255930087`}, {
         4006, 0.4982526210683974}, {4007, 0.4973795857249813}, {
         4008, 0.5169660678642715}, {4009, 0.5051134946370666}, {
         4010, 0.5012468827930174}, {4011, 0.487658937920718}, {
         4012, 0.47781655034895315`}, {4013, 0.49962621480189384`}, {
         4014, 0.4900348779272546}, {4015, 0.5013698630136987}, {
         4016, 0.5057270916334662}, {4017, 0.4916604431167538}, {
         4018, 0.5171727227476356}, {4019, 0.5115700422990793}, {
         4020, 0.48855721393034823`}, {4021, 0.49639393185774683`}, {
         4022, 0.5017404276479364}, {4023, 0.5028585632612478}, {
         4024, 0.5029821073558648}, {4025, 0.48397515527950313`}, {
         4026, 0.5129160457029309}, {4027, 0.49739259995033525`}, {
         4028, 0.49751737835153925`}, {4029, 0.5162571357656986}, {
         4030, 0.4985111662531017}, {4031, 0.5031009675018606}, {
         4032, 0.4928075396825397}, {4033, 0.5135135135135135}, {
         4034, 0.5024789291026277}, {4035, 0.5003717472118959}, {
         4036, 0.5047076313181368}, {4037, 0.47981174139212285`}, {
         4038, 0.4995047052996533}, {4039, 0.49467690022282745`}, {
         4040, 0.4943069306930693}, {4041, 0.5124969067062608}, {
         4042, 0.48911429985155863`}, {4043, 0.5030917635419243}, {
         4044, 0.4950544015825915}, {4045, 0.49443757725587145`}, {
         4046, 0.5029658922392486}, {4047, 0.49493451939708427`}, {
         4048, 0.5029644268774703}, {4049, 0.506544825882934}, {
         4050, 0.48592592592592593`}, {4051, 0.49740804739570477`}, {
         4052, 0.4898815399802567}, {4053, 0.4988897113249445}, {
         4054, 0.5014800197335965}, {4055, 0.48951911220715166`}, {
         4056, 0.513560157790927}, {4057, 0.50529948237614}, {
         4058, 0.5019714144898965}, {4059, 0.4924858339492486}, {
         4060, 0.5064039408866995}, {4061, 0.5129278502831814}, {
         4062, 0.5115706548498277}, {4063, 0.49224710804824023`}, {
         4064, 0.4874507874015748}, {4065, 0.4870848708487085}, {
         4066, 0.49188391539596654`}, {4067, 0.49717236292107203`}, {
         4068, 0.497787610619469}, {4069, 0.4861145244531826}, {
         4070, 0.5117936117936118}, {4071, 0.4858757062146893}, {
         4072, 0.5103143418467584}, {4073, 0.5173091087650381}, {
         4074, 0.5027000490918017}, {4075, 0.5052760736196319}, {
         4076, 0.48994111874386653`}, {4077, 0.5089526612705421}, {
         4078, 0.5036782736635605}, {4079, 0.4991419465555283}, {
         4080, 0.5044117647058823}, {4081, 0.5116393040921343}, {
         4082, 0.49583537481626655`}, {4083, 0.5082047514082783}, {
         4084, 0.5056317335945152}, {4085, 0.5040391676866585}, {
         4086, 0.5134605971610376}, {4087, 0.5001223391240519}, {
         4088, 0.5061154598825832}, {4089, 0.49645390070921985`}, {
         4090, 0.4941320293398533}, {4091, 0.4952334392569054}, {
         4092, 0.4868035190615836}, {4093, 0.4976789640850232}, {
         4094, 0.5061064973131412}, {4095, 0.4967032967032967}, {
         4096, 0.4951171875}, {4097, 0.49548450085428364`}, {
         4098, 0.5029282576866764}, {4099, 0.4971944376677238}, {
         4100, 0.4895121951219512}, {4101, 0.4981711777615216}, {
         4102, 0.5053632374451487}, {4103, 0.5096271021203997}, {
         4104, 0.4958576998050682}, {4105, 0.4930572472594397}, {
         4106, 0.4909887968826108}, {4107, 0.4986608229851473}, {
         4108, 0.508763388510224}, {4109, 0.48503285470917495`}, {
         4110, 0.49659367396593673`}, {4111, 0.49355387983459015`}, {
         4112, 0.4995136186770428}, {4113, 0.4923413566739606}, {
         4114, 0.4934370442391833}, {4115, 0.4882138517618469}, {
         4116, 0.5046161321671526}, {4117, 0.49599222735001214`}, {
         4118, 0.4995143273433706}, {4119, 0.4989075018208303}, {
         4120, 0.49514563106796117`}, {4121, 0.4996360106770201}, {
         4122, 0.5036390101892285}, {4123, 0.5003638127577007}, {
         4124, 0.520368574199806}, {4125, 0.5117575757575757}, {
         4126, 0.48691226369365004`}, {4127, 0.4867942815604555}, {
         4128, 0.4949127906976744}, {4129, 0.5013320416565754}, {
         4130, 0.49951573849878933`}, {4131, 0.5022996853062213}, {
         4132, 0.48451113262342693`}, {4133, 0.49987902250181465`}, {
         4134, 0.49733913884857284`}, {4135, 0.486819830713422}, {
         4136, 0.4985493230174081}, {4137, 0.5151075658689872}, {
         4138, 0.48815853069115517`}, {4139, 0.49697994684706454`}, {
         4140, 0.4886473429951691}, {4141, 0.49963776865491427`}, {
         4142, 0.5019314340898117}, {4143, 0.49625874969828626`}, {
         4144, 0.5098938223938224}, {4145, 0.5020506634499396}, {
         4146, 0.5007235890014472}, {4147, 0.49578008198697854`}, {
         4148, 0.5113307618129219}, {4149, 0.5054229934924078}, {
         4150, 0.5180722891566265}, {4151, 0.506143098048663}, {
         4152, 0.5036127167630058}, {4153, 0.5049361907055141}, {
         4154, 0.496870486278286}, {4155, 0.49795427196149217`}, {
         4156, 0.5153994225216555}, {4157, 0.5025258599951888}, {
         4158, 0.51010101010101}, {4159, 0.4856936763645107}, {
         4160, 0.5091346153846154}, {4161, 0.4929103580869983}, {
         4162, 0.5052859202306583}, {4163, 0.5090079269757386}, {
         4164, 0.5079250720461095}, {4165, 0.517406962785114}, {
         4166, 0.500240038406145}, {4167, 0.4895608351331893}, {4168, 0.5}, {
         4169, 0.4965219477092828}, {4170, 0.5023980815347722}, {
         4171, 0.5013186286262287}, {4172, 0.4983221476510067}, {
         4173, 0.49796309609393724`}, {4174, 0.498083373263057}, {
         4175, 0.4888622754491018}, {4176, 0.49952107279693486`}, {
         4177, 0.5032319846779986}, {4178, 0.5009573958831977}, {
         4179, 0.4852835606604451}, {4180, 0.5126794258373206}, {
         4181, 0.5099258550585984}, {4182, 0.49904351984696316`}, {
         4183, 0.4943820224719101}, {4184, 0.48852772466539196`}, {
         4185, 0.5010752688172043}, {4186, 0.49665551839464883`}, {
         4187, 0.4857893479818486}, {4188, 0.4990448901623687}, {
         4189, 0.5008355216042015}, {4190, 0.4909307875894988}, {
         4191, 0.4958243855881651}, {4192, 0.48711832061068705`}, {
         4193, 0.5063200572382542}, {4194, 0.49523128278493084`}, {
         4195, 0.4936829558998808}, {4196, 0.4921353670162059}, {
         4197, 0.4960686204431737}, {4198, 0.4959504525964745}, {
         4199, 0.5015479876160991}, {4200, 0.49785714285714283`}, {
         4201, 0.4994049035943823}, {4202, 0.5083293669681104}, {
         4203, 0.48798477278134667`}, {4204, 0.5152235965746907}, {
         4205, 0.4768133174791914}, {4206, 0.4980979553019496}, {
         4207, 0.5160446874257191}, {4208, 0.49334600760456276`}, {
         4209, 0.5193632691850796}, {4210, 0.497624703087886}, {
         4211, 0.4894324388506293}, {4212, 0.5111585944919278}, {
         4213, 0.49370994540707336`}, {4214, 0.502610346464167}, {
         4215, 0.49869513641755636`}, {4216, 0.49430740037950666`}, {
         4217, 0.49774721365899927`}, {4218, 0.4871977240398293}, {
         4219, 0.49727423560085326`}, {4220, 0.5109004739336492}, {
         4221, 0.4949064202795546}, {4222, 0.5101847465656087}, {
         4223, 0.5020127871181624}, {4224, 0.5075757575757576}, {
         4225, 0.5005917159763313}, {4226, 0.514907714150497}, {
         4227, 0.4958599479536314}, {4228, 0.500236518448439}, {
         4229, 0.4916055805154883}, {4230, 0.4983451536643026}, {
         4231, 0.5105176081304656}, {4232, 0.47802457466918713`}, {
         4233, 0.49728325064965745`}, {4234, 0.49244213509683515`}, {
         4235, 0.4923258559622196}, {4236, 0.48937677053824363`}, {
         4237, 0.4873731413736134}, {4238, 0.500943841434639}, {
         4239, 0.49610757254069354`}, {4240, 0.49221698113207546`}, {
         4241, 0.4998821032775289}, {4242, 0.5148514851485149}, {
         4243, 0.4946971482441669}, {4244, 0.49081055607917057`}, {
         4245, 0.5034157832744405}, {4246, 0.509185115402732}, {
         4247, 0.4906993171650577}, {4248, 0.5115348399246704}, {
         4249, 0.4902329959990586}, {4250, 0.4934117647058823}, {
         4251, 0.5012938132204188}, {4252, 0.49764816556914393`}, {
         4253, 0.4897719256995062}, {4254, 0.49506346967559944`}, {
         4255, 0.4864864864864865}, {4256, 0.4943609022556391}, {
         4257, 0.5024665257223396}, {4258, 0.5035227806481917}, {
         4259, 0.49823902324489316`}, {4260, 0.4962441314553991}, {
         4261, 0.5022295235860127}, {4262, 0.498122946973252}, {
         4263, 0.47783251231527096`}, {4264, 0.4974202626641651}, {
         4265, 0.4930832356389215}, {4266, 0.4960150023441163}, {
         4267, 0.49425826107335363`}, {4268, 0.5103092783505154}, {
         4269, 0.5033965799953151}, {4270, 0.4997658079625293}, {
         4271, 0.4921564036525404}, {4272, 0.4897003745318352}, {
         4273, 0.5003510414228879}, {4274, 0.5046794571829668}, {
         4275, 0.49309941520467837`}, {4276, 0.5032740879326474}, {
         4277, 0.5008183306055647}, {4278, 0.5014025245441796}, {
         4279, 0.4980135545688245}, {4280, 0.4983644859813084}, {
         4281, 0.5015183368371876}, {4282, 0.5056048575432041}, {
         4283, 0.4898435675928088}, {4284, 0.49533146591970123`}, {
         4285, 0.502683780630105}, {4286, 0.5006999533364442}, {
         4287, 0.49148588756706324`}, {4288, 0.5055970149253731}, {
         4289, 0.49848449522033106`}, {4290, 0.49347319347319346`}, {
         4291, 0.510836634817059}, {4292, 0.48718546132339235`}, {
         4293, 0.49173072443512694`}, {4294, 0.49534233814625056`}, {
         4295, 0.49941792782305006`}, {4296, 0.49813780260707635`}, {
         4297, 0.502443565278101}, {4298, 0.4888320148906468}, {
         4299, 0.49430100023261225`}, {4300, 0.5134883720930232}, {
         4301, 0.499418739827947}, {4302, 0.500697350069735}, {
         4303, 0.4980246339762956}, {4304, 0.5055762081784386}, {
         4305, 0.5001161440185831}, {4306, 0.4932652113330237}, {
         4307, 0.5019735314604132}, {4308, 0.5062674094707521}, {
         4309, 0.4827106057089812}, {4310, 0.4951276102088167}, {
         4311, 0.5073068893528184}, {4312, 0.48678107606679033`}, {
         4313, 0.4945513563644795}, {4314, 0.4993045897079277}, {
         4315, 0.49710312862108924`}, {4316, 0.5016218721037998}, {
         4317, 0.5098447996293722}, {4318, 0.49119962945808243`}, {
         4319, 0.5063672146330169}, {4320, 0.5041666666666667}, {
         4321, 0.515158528118491}, {4322, 0.50462748727441}, {
         4323, 0.4850798056904927}, {4324, 0.4879740980573543}, {
         4325, 0.5107514450867052}, {4326, 0.4963014331946371}, {
         4327, 0.4920268084122949}, {4328, 0.5131700554528651}, {
         4329, 0.49572649572649574`}, {4330, 0.49630484988452656`}, {
         4331, 0.5095820826598938}, {4332, 0.5147737765466297}, {
         4333, 0.4996538195245788}, {4334, 0.502307337332718}, {
         4335, 0.5028835063437139}, {4336, 0.49031365313653136`}, {
         4337, 0.5019598801014526}, {4338, 0.4988473951129553}, {
         4339, 0.48490435584235997`}, {4340, 0.5025345622119816}, {
         4341, 0.502418797512094}, {4342, 0.49792722247812066`}, {
         4343, 0.5116279069767442}, {4344, 0.4958563535911602}, {
         4345, 0.5012658227848101}, {4346, 0.48826507132995856`}, {
         4347, 0.49528410397975614`}, {4348, 0.4965501379944802}, {
         4349, 0.5003449068751437}, {4350, 0.5160919540229885}, {
         4351, 0.4840266605378074}, {4352, 0.49471507352941174`}, {
         4353, 0.49023661842407534`}, {4354, 0.5025264124942581}, {
         4355, 0.49230769230769234`}, {4356, 0.5119375573921029}, {
         4357, 0.5005737893045674}, {4358, 0.5075722808627811}, {
         4359, 0.49850883230098647`}, {4360, 0.49793577981651377`}, {
         4361, 0.5019490942444393}, {4362, 0.5038972948188905}, {
         4363, 0.4943845977538391}, {4364, 0.4970210815765353}, {
         4365, 0.49919816723940436`}, {4366, 0.4951901053595969}, {
         4367, 0.5060682390657202}, {4368, 0.49473443223443225`}, {
         4369, 0.4934767681391623}, {4370, 0.48810068649885585`}, {
         4371, 0.49256463051933197`}, {4372, 0.4954254345837146}, {
         4373, 0.494397438829179}, {4374, 0.5027434842249657}, {
         4375, 0.4985142857142857}, {4376, 0.5}, {4377, 0.5117660498058031}, {
         4378, 0.49862951119232524`}, {4379, 0.5081068737154602}, {
         4380, 0.4922374429223744}, {4381, 0.5026249714677015}, {
         4382, 0.5075308078502967}, {4383, 0.5042208532968286}, {
         4384, 0.49863138686131386`}, {4385, 0.4992018244013683}, {
         4386, 0.4952120383036936}, {4387, 0.5001139731023478}, {
         4388, 0.49430264357338194`}, {4389, 0.4889496468443837}, {
         4390, 0.5109339407744875}, {4391, 0.4905488499202915}, {
         4392, 0.4899817850637523}, {4393, 0.5085363077623491}, {
         4394, 0.502730996813837}, {4395, 0.5128555176336747}, {
         4396, 0.5009099181073703}, {4397, 0.5169433704798726}, {
         4398, 0.49818099135970895`}, {4399, 0.503068879290748}, {
         4400, 0.49454545454545457`}, {4401, 0.515791865485117}, {
         4402, 0.5}, {4403, 0.49034749034749037`}, {
         4404, 0.490236148955495}, {4405, 0.49035187287173665`}, {
         4406, 0.5040853381752156}, {4407, 0.4967097798956206}, {
         4408, 0.4970508166969147}, {4409, 0.48718530278974825`}, {
         4410, 0.49387755102040815`}, {4411, 0.5010201768306507}, {
         4412, 0.4972801450589302}, {4413, 0.4980738726489916}, {
         4414, 0.5036248300860897}, {4415, 0.5062287655719139}, {
         4416, 0.494338768115942}, {4417, 0.5003395970115463}, {
         4418, 0.5156179266636487}, {4419, 0.4865354152523195}, {
         4420, 0.5131221719457013}, {4421, 0.49106536982583127`}, {
         4422, 0.5047489823609227}, {4423, 0.4811214108071445}, {
         4424, 0.5009041591320073}, {4425, 0.512542372881356}, {
         4426, 0.4948034342521464}, {4427, 0.5107296137339056}, {
         4428, 0.5088075880758808}, {4429, 0.48475953939941296`}, {
         4430, 0.4945823927765237}, {4431, 0.4985330625141052}, {
         4432, 0.4970667870036101}, {4433, 0.49740581998646516`}, {
         4434, 0.5040595399188093}, {4435, 0.5028184892897407}, {
         4436, 0.49909828674481516`}, {4437, 0.49335136353391934`}, {
         4438, 0.5006759801712483}, {4439, 0.5068709168731697}, {
         4440, 0.5110360360360361}, {4441, 0.4949335735194776}, {
         4442, 0.5009004952723998}, {4443, 0.5030384875084403}, {
         4444, 0.5011251125112511}, {4445, 0.510236220472441}, {
         4446, 0.5123706702654071}, {4447, 0.48909377108162805`}, {
         4448, 0.5013489208633094}, {4449, 0.5041582378062486}, {4450, 0.5}, {
         4451, 0.49090092114131656`}, {4452, 0.5087601078167115}, {
         4453, 0.4942735234673254}, {4454, 0.4988774135608442}, {
         4455, 0.4922558922558923}, {4456, 0.49169658886894074`}, {
         4457, 0.4949517612743998}, {4458, 0.5121130551816958}, {
         4459, 0.5039246467817896}, {4460, 0.5033632286995515}, {
         4461, 0.5119928267204663}, {4462, 0.49036306588973555`}, {
         4463, 0.4893569347972216}, {4464, 0.49350358422939067`}, {
         4465, 0.48936170212765956`}, {4466, 0.49641737572772054`}, {
         4467, 0.49608238191179765`}, {4468, 0.4959713518352731}, {
         4469, 0.4992168270306556}, {4470, 0.49440715883668906`}, {
         4471, 0.4978751957056587}, {4472, 0.5}, {
         4473, 0.48826291079812206`}, {4474, 0.49932945909700494`}, {
         4475, 0.5110614525139665}, {4476, 0.4962019660411081}, {
         4477, 0.513290149653786}, {4478, 0.5015631978561857}, {
         4479, 0.49609287787452555`}, {4480, 0.496875}, {
         4481, 0.5117161347913413}, {4482, 0.49776885319053993`}, {
         4483, 0.5030113763105064}, {4484, 0.4928635147190009}, {
         4485, 0.5043478260869565}, {4486, 0.5062416406598306}, {
         4487, 0.512814798306218}, {4488, 0.48685383244206776`}, {
         4489, 0.501447983960793}, {4490, 0.488641425389755}, {
         4491, 0.5021153417947005}, {4492, 0.5084594835262689}, {
         4493, 0.5018918317382595}, {4494, 0.5008900756564308}, {
         4495, 0.48631813125695217`}, {4496, 0.4902135231316726}, {
         4497, 0.5098954858794752}, {4498, 0.5055580257892397}, {
         4499, 0.5185596799288731}, {4500, 0.48977777777777776`}, {
         4501, 0.5023328149300156}, {4502, 0.49222567747667706`}, {
         4503, 0.5141017099711304}, {4504, 0.5144316163410302}, {
         4505, 0.49056603773584906`}, {4506, 0.49822458943630715`}, {
         4507, 0.5076547592633681}, {4508, 0.5035492457852706}, {
         4509, 0.49567531603459747`}, {4510, 0.5044345898004434}, {
         4511, 0.5045444469075593}, {4512, 0.499113475177305}, {
         4513, 0.5103035674717483}, {4514, 0.4935755427558706}, {
         4515, 0.49036544850498337`}, {4516, 0.5026572187776793}, {
         4517, 0.505645339827319}, {4518, 0.5099601593625498}, {
         4519, 0.4903739765434831}, {4520, 0.4798672566371681}, {
         4521, 0.500110595001106}, {4522, 0.49778858911985846`}, {
         4523, 0.49723634755693125`}, {4524, 0.4854111405835544}, {
         4525, 0.5034254143646408}, {4526, 0.49536014140521434`}, {
         4527, 0.5029821073558648}, {4528, 0.5094964664310954}, {
         4529, 0.49569441377787593`}, {4530, 0.5006622516556292}, {
         4531, 0.4996689472522622}, {4532, 0.4988967343336275}, {
         4533, 0.499669093315685}, {4534, 0.5026466696074107}, {
         4535, 0.4994487320837927}, {4536, 0.5022045855379189}, {
         4537, 0.5001102049812651}, {4538, 0.5134420449537241}, {
         4539, 0.49790702797973124`}, {4540, 0.49581497797356827`}, {
         4541, 0.5067165822506056}, {4542, 0.5022016732716865}, {
         4543, 0.4935064935064935}, {4544, 0.5008802816901409}, {
         4545, 0.508030803080308}, {4546, 0.5039595248570171}, {
         4547, 0.4979107103584781}, {4548, 0.5013192612137203}, {
         4549, 0.49923060013189713`}, {4550, 0.5}, {
         4551, 0.4957152274225445}, {4552, 0.4991212653778559}, {
         4553, 0.4987920052712497}, {4554, 0.5059288537549407}, {
         4555, 0.49857299670691546`}, {4556, 0.48485513608428443`}, {
         4557, 0.5034013605442177}, {4558, 0.5059236507240018}, {
         4559, 0.49374862908532574`}, {4560, 0.4949561403508772}, {
         4561, 0.4950668713001535}, {4562, 0.5039456378781236}, {
         4563, 0.5095332018408941}, {4564, 0.49846625766871167`}, {
         4565, 0.49375684556407445`}, {4566, 0.4918966272448533}, {
         4567, 0.5005474052988833}, {4568, 0.5102889667250438}, {
         4569, 0.4972641715911578}, {4570, 0.49934354485776805`}, {
         4571, 0.4924524174141326}, {4572, 0.4995625546806649}, {
         4573, 0.5095123551279248}, {4574, 0.4905990380411019}, {
         4575, 0.49573770491803276`}, {4576, 0.4978146853146853}, {
         4577, 0.4994537906925934}, {4578, 0.5069899519440804}, {
         4579, 0.503385018563005}, {4580, 0.5056768558951965}, {
         4581, 0.495743287491814}, {4582, 0.49628982976866}, {
         4583, 0.4889810168012219}, {4584, 0.5032722513089005}, {
         4585, 0.5016357688113413}, {4586, 0.5034888791975578}, {
         4587, 0.4981469369958579}, {4588, 0.5028334786399302}, {
         4589, 0.4833297014600131}, {4590, 0.5169934640522876}, {
         4591, 0.5018514484861686}, {4592, 0.5034843205574913}, {
         4593, 0.5020683649031135}, {4594, 0.5084893339138006}, {
         4595, 0.49336235038084875`}, {4596, 0.4926022628372498}, {
         4597, 0.49771590167500546`}, {4598, 0.49478033927794696`}, {
         4599, 0.5064144379212873}, {4600, 0.495}, {
         4601, 0.5016300804173006}, {4602, 0.5002172968274663}, {
         4603, 0.4903323919183141}, {4604, 0.5032580364900087}, {
         4605, 0.5001085776330076}, {4606, 0.48588797221016067`}, {
         4607, 0.5048838723681355}, {4608, 0.5078125}, {
         4609, 0.4899110436103276}, {4610, 0.5017353579175705}, {
         4611, 0.501626545217957}, {4612, 0.5151777970511708}, {
         4613, 0.49490570127899414`}, {4614, 0.5019505851755527}, {
         4615, 0.5018418201516793}, {4616, 0.4815857885615251}, {
         4617, 0.49859215941087287`}, {4618, 0.5097444781290602}, {
         4619, 0.49296384498809265`}, {4620, 0.508008658008658}, {
         4621, 0.5001082016879463}, {4622, 0.4924275205538728}, {
         4623, 0.5130867402119835}, {4624, 0.5155709342560554}, {
         4625, 0.5014054054054055}, {4626, 0.5004323389537397}, {
         4627, 0.5074562351415604}, {4628, 0.4969749351771824}, {
         4629, 0.4901706632101966}, {4630, 0.5}, {4631, 0.5078816670265601}, {
         4632, 0.4961139896373057}, {4633, 0.5132743362831859}, {
         4634, 0.4997842037116962}, {4635, 0.4964401294498382}, {
         4636, 0.48490077653149266`}, {4637, 0.5050679318524909}, {
         4638, 0.4963346269943941}, {4639, 0.4998922181504635}, {
         4640, 0.4993534482758621}, {4641, 0.5048480930833872}, {
         4642, 0.503877638948729}, {4643, 0.5085074305405988}, {
         4644, 0.5047372954349698}, {4645, 0.507427341227126}, {
         4646, 0.5053809728798967}, {4647, 0.5061329890251776}, {
         4648, 0.5030120481927711}, {4649, 0.49279414927941495`}, {
         4650, 0.5105376344086021}, {4651, 0.49666738335841754`}, {
         4652, 0.5045141874462596}, {4653, 0.49688373092628413`}, {
         4654, 0.5019338203695746}, {4655, 0.5031149301825993}, {
         4656, 0.506872852233677}, {4657, 0.49345071934721924`}, {
         4658, 0.4909832546157149}, {4659, 0.48637046576518567`}, {
         4660, 0.498068669527897}, {4661, 0.4945290710148037}, {
         4662, 0.5004290004290004}, {4663, 0.5078275788119236}, {
         4664, 0.4875643224699828}, {4665, 0.4983922829581994}, {
         4666, 0.508786969567081}, {4667, 0.49089350760659956`}, {
         4668, 0.4877892030848329}, {4669, 0.5003212679374598}, {
         4670, 0.5087794432548179}, {4671, 0.49496895739670305`}, {
         4672, 0.509417808219178}, {4673, 0.5180826021827519}, {
         4674, 0.4993581514762516}, {4675, 0.49711229946524066`}, {
         4676, 0.504704875962361}, {4677, 0.5007483429548856}, {
         4678, 0.5014963659683626}, {4679, 0.5101517418251763}, {
         4680, 0.5008547008547009}, {4681, 0.49391155735953857`}, {
         4682, 0.5066211020931226}, {4683, 0.49690369421311126`}, {
         4684, 0.503202391118702}, {4685, 0.49882604055496266`}, {
         4686, 0.5053350405463082}, {4687, 0.5099210582462129}, {
         4688, 0.5159982935153583}, {4689, 0.4996801023672425}, {
         4690, 0.5211087420042644}, {4691, 0.49754849712214877`}, {
         4692, 0.4955242966751918}, {4693, 0.5007457916045174}, {
         4694, 0.48593949723050706`}, {4695, 0.4956336528221512}, {
         4696, 0.5029812606473595}, {4697, 0.5052160953800298}, {
         4698, 0.5074499787143465}, {4699, 0.5015960842732496}, {
         4700, 0.49638297872340426`}, {4701, 0.513507764305467}, {
         4702, 0.5019140791152701}, {4703, 0.4967042313416968}, {
         4704, 0.501062925170068}, {4705, 0.5086078639744952}, {
         4706, 0.511049723756906}, {4707, 0.5030805183768855}, {
         4708, 0.4993627867459643}, {4709, 0.4971331492885963}, {
         4710, 0.510828025477707}, {4711, 0.5096582466567607}, {
         4712, 0.5004244482173175}, {4713, 0.5028644175684277}, {
         4714, 0.49406024607551974`}, {4715, 0.5060445387062567}, {
         4716, 0.49681933842239184`}, {4717, 0.5168539325842697}, {
         4718, 0.5014836795252225}, {4719, 0.5034965034965035}, {
         4720, 0.4978813559322034}, {4721, 0.49968227070535903`}, {
         4722, 0.49682337992376113`}, {4723, 0.5092102477239043}, {
         4724, 0.506138865368332}, {4725, 0.5017989417989418}, {
         4726, 0.49767245027507406`}, {4727, 0.5037021366617305}, {
         4728, 0.4883671742808799}, {4729, 0.5037005709452316}, {
         4730, 0.5040169133192389}, {4731, 0.5039103783555273}, {
         4732, 0.4913355874894336}, {4733, 0.48975279949292205`}, {
         4734, 0.5016899028305872}, {4735, 0.49482576557550156`}, {
         4736, 0.5095016891891891}, {4737, 0.4887059320244881}, {
         4738, 0.4989447024060785}, {4739, 0.4931420130829289}, {
         4740, 0.509915611814346}, {4741, 0.4885045349082472}, {
         4742, 0.5046393926613243}, {4743, 0.49673202614379086`}, {
         4744, 0.4751264755480607}, {4745, 0.5053740779768177}, {
         4746, 0.5080067425200169}, {4747, 0.49504950495049505`}, {
         4748, 0.5065290648694187}, {4749, 0.4952621604548326}, {
         4750, 0.49094736842105263`}, {4751, 0.4864239107556304}, {
         4752, 0.5039983164983165}, {4753, 0.500525983589312}, {
         4754, 0.5046276819520404}, {4755, 0.4929547844374343}, {
         4756, 0.49747687132043733`}, {4757, 0.498213159554341}, {
         4758, 0.5121899957965532}, {4759, 0.5047278840092456}, {
         4760, 0.5016806722689076}, {4761, 0.5131274942239026}, {
         4762, 0.5090298194036119}, {4763, 0.49317656938904053`}, {
         4764, 0.49853064651553314`}, {4765, 0.4875131164742917}, {
         4766, 0.4989509022240873}, {4767, 0.5059786028949025}, {
         4768, 0.49601510067114096`}, {4769, 0.4942335919479975}, {
         4770, 0.5117400419287211}, {4771, 0.49654160553343113`}, {
         4772, 0.4991617770326907}, {4773, 0.5068091347161114}, {
         4774, 0.5002094679514034}, {4775, 0.49654450261780103`}, {
         4776, 0.4932998324958124}, {4777, 0.4936152396901821}, {
         4778, 0.4970699037254081}, {4779, 0.5080560786775477}, {
         4780, 0.49079497907949793`}, {4781, 0.5097259987450324}, {
         4782, 0.5037641154328732}, {4783, 0.49257787999163705`}, {
         4784, 0.49498327759197325`}, {4785, 0.48798328108672934`}, {
         4786, 0.49623903050564144`}, {4787, 0.5032379360768748}, {
         4788, 0.49832915622389307`}, {4789, 0.5021925245353936}, {
         4790, 0.5056367432150313}, {4791, 0.5057399290336047}, {
         4792, 0.4958263772954925}, {4793, 0.49634884206133945`}, {
         4794, 0.5004171881518565}, {4795, 0.5046923879040668}, {
         4796, 0.5031276063386155}, {4797, 0.49572649572649574`}, {
         4798, 0.5064610254272613}, {4799, 0.5036465930402168}, {
         4800, 0.5079166666666667}, {4801, 0.5067694230368673}, {
         4802, 0.4956268221574344}, {4803, 0.5069748074120342}, {
         4804, 0.503955037468776}, {4805, 0.5028095733610822}, {
         4806, 0.49833541406575116`}, {4807, 0.5090493030996464}, {
         4808, 0.5016638935108153}, {4809, 0.50509461426492}, {
         4810, 0.5004158004158004}, {4811, 0.49407607565994593`}, {
         4812, 0.48877805486284287`}, {4813, 0.5003116559318512}, {
         4814, 0.4943913585375987}, {4815, 0.4834890965732087}, {4816, 0.5}, {
         4817, 0.49761262196387795`}, {4818, 0.5062266500622665}, {
         4819, 0.5104793525627723}, {4820, 0.5022821576763485}, {
         4821, 0.4951254926363825}, {4822, 0.5016590626296142}, {
         4823, 0.49782293178519593`}, {4824, 0.5047678275290216}, {
         4825, 0.49740932642487046`}, {4826, 0.4962702030667219}, {
         4827, 0.505489952351357}, {4828, 0.49171499585749795`}, {
         4829, 0.4969973079312487}, {4830, 0.5198757763975155}, {
         4831, 0.5013454771268888}, {4832, 0.5010347682119205}, {
         4833, 0.5067246016966688}, {4834, 0.5037236243276789}, {
         4835, 0.5141675284384695}, {4836, 0.5024813895781638}, {
         4837, 0.492040520984081}, {4838, 0.49359239355105416`}, {
         4839, 0.49969001859888407`}, {4840, 0.49855371900826445`}, {
         4841, 0.5100185912001652}, {4842, 0.5010326311441553}, {
         4843, 0.49762543877761717`}, {4844, 0.5006193228736582}, {
         4845, 0.5021671826625387}, {4846, 0.4993809327280231}, {
         4847, 0.5015473488755932}, {4848, 0.49422442244224424`}, {
         4849, 0.5137141678696638}, {4850, 0.4952577319587629}, {
         4851, 0.4881467738610596}, {4852, 0.4857790601813685}, {
         4853, 0.49021223985163814`}, {4854, 0.5063864853728883}, {
         4855, 0.501956745623069}, {4856, 0.5059719934102141}, {
         4857, 0.49536751080914143`}, {4858, 0.500617538081515}, {
         4859, 0.5023667421280099}, {4860, 0.5094650205761316}, {
         4861, 0.5005142974696565}, {4862, 0.5150143973673386}, {
         4863, 0.4873534855027761}, {4864, 0.49609375}, {
         4865, 0.49681397738951694`}, {4866, 0.5004110152075627}, {
         4867, 0.4933223751797822}, {4868, 0.5059572719802794}, {
         4869, 0.5037995481618402}, {4870, 0.5141683778234086}, {
         4871, 0.498870868404845}, {4872, 0.5116995073891626}, {
         4873, 0.4964087830904987}, {4874, 0.5008206811653673}, {
         4875, 0.49128205128205127`}, {4876, 0.49815422477440524`}, {
         4877, 0.502563051055977}, {4878, 0.492619926199262}, {
         4879, 0.5019471203115392}, {4880, 0.49754098360655735`}, {
         4881, 0.4896537594755173}, {4882, 0.49098730028676774`}, {
         4883, 0.4994880196600451}, {4884, 0.5057330057330057}, {
         4885, 0.5080859774820881}, {4886, 0.4920180106426525}, {
         4887, 0.5140167792101493}, {4888, 0.5010229132569558}, {
         4889, 0.5093066066680303}, {4890, 0.4950920245398773}, {
         4891, 0.49805765692087506`}, {4892, 0.49672935404742435`}, {
         4893, 0.5058246474555488}, {4894, 0.5030649775234982}, {
         4895, 0.4968335035750766}, {4896, 0.497140522875817}, {
         4897, 0.4882581172146212}, {4898, 0.4897917517354022}, {
         4899, 0.518269034496836}, {4900, 0.49448979591836734`}, {
         4901, 0.4980616200775352}, {4902, 0.5014279885760914}, {
         4903, 0.494187232306751}, {4904, 0.49367862969004894`}, {
         4905, 0.5029561671763506}, {4906, 0.5016306563391765}, {
         4907, 0.4913389036070919}, {4908, 0.49775876120619394`}, {
         4909, 0.5003055612140965}, {4910, 0.5014256619144603}, {
         4911, 0.5074322948482998}, {4912, 0.502442996742671}, {
         4913, 0.5086505190311419}, {4914, 0.5063085063085063}, {
         4915, 0.4931841302136317}, {4916, 0.4871847030105777}, {
         4917, 0.5051860890787065}, {4918, 0.4928832858885726}, {
         4919, 0.48932709900386256`}, {4920, 0.49329268292682926`}, {
         4921, 0.5023369233895549}, {4922, 0.48821617228768793`}, {
         4923, 0.5009140767824497}, {4924, 0.49573517465475225`}, {
         4925, 0.49908629441624364`}, {4926, 0.49106780349167684`}, {
         4927, 0.49969555510452607`}, {4928, 0.5093344155844156}, {
         4929, 0.4923919659160073}, {4930, 0.5022312373225152}, {
         4931, 0.4980734131007909}, {4932, 0.49939172749391725`}, {
         4933, 0.4976687614027975}, {4934, 0.5012160518848804}, {
         4935, 0.4911854103343465}, {4936, 0.49655591572123176`}, {
         4937, 0.49767065019242457`}, {4938, 0.5052652895909275}, {
         4939, 0.5077951002227171}, {4940, 0.4917004048582996}, {
         4941, 0.495243877757539}, {4942, 0.5070821529745042}, {
         4943, 0.4948411895609953}, {4944, 0.5046521035598706}, {
         4945, 0.4962588473205258}, {4946, 0.5010109179134654}, {
         4947, 0.5009096422073984}, {4948, 0.5034357316087308}, {
         4949, 0.5025257627803597}, {4950, 0.49636363636363634`}, {
         4951, 0.49404160775600886`}, {4952, 0.4993941841680129}, {
         4953, 0.49464970724813245`}, {4954, 0.5036334275333064}, {
         4955, 0.48698284561049443`}, {4956, 0.5119047619047619}, {
         4957, 0.5130119023602986}, {4958, 0.5086728519564341}, {
         4959, 0.49405122000403306`}, {4960, 0.49959677419354837`}, {
         4961, 0.5029227978230195}, {4962, 0.4989923417976622}, {
         4963, 0.5093693330646786}, {4964, 0.5018130539887188}, {
         4965, 0.494662638469285}, {4966, 0.4995972613773661}, {
         4967, 0.5091604590295953}, {4968, 0.4975845410628019}, {
         4969, 0.5043268263232039}, {4970, 0.506036217303823}, {
         4971, 0.5063367531683766}, {4972, 0.5074416733708769}, {
         4973, 0.48522018902071185`}, {4974, 0.5082428628870125}, {
         4975, 0.5131658291457286}, {4976, 0.49638263665594856`}, {
         4977, 0.506730962427165}, {4978, 0.5040176777822418}, {
         4979, 0.5071299457722435}, {4980, 0.49618473895582327`}, {
         4981, 0.5071270829150772}, {4982, 0.5048173424327579}, {
         4983, 0.4926750953241019}, {4984, 0.49979935794542535`}, {
         4985, 0.5051153460381144}, {4986, 0.5052146008824709}, {
         4987, 0.49629035492279927`}, {4988, 0.4967923015236568}, {
         4989, 0.49989977951493286`}, {4990, 0.5054108216432865}, {
         4991, 0.49969945902624724`}, {4992, 0.500801282051282}, {
         4993, 0.5057079911876627}, {4994, 0.4915899078894674}, {
         4995, 0.5067067067067067}, {4996, 0.4953963170536429}, {
         4997, 0.501300780468281}, {4998, 0.49779911964785917`}, {
         4999, 0.5121024204840968}, {5000, 0.5024}}, $CellContext`labFontSize = 
       14}; Typeset`initDone$$ = True),
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{3.947581234517589*^9, 3.951815787100726*^9, 
  3.9557693314458103`*^9},
 CellLabel->"Out[96]=",
 $CellContext`InitializationGroup -> 
 True,ExpressionUUID->"5e82bcc9-3525-4160-a746-1809f18f7461"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["c2s1Table1", "Section",
 CellChangeTimes->{{3.5723420028690567`*^9, 3.572342011627058*^9}, {
   3.947391571097383*^9, 3.947391617058372*^9}, 3.9473923450883703`*^9, 
   3.947393236393119*^9, 3.947575060658597*^9, 3.94757625885634*^9},
 $CellContext`InitializationGroup -> 
 True,ExpressionUUID->"ab00b494-d2b5-47dd-879f-2b612aec829b"],

Cell[BoxData[
 RowBox[{
  RowBox[{"data1", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"Pane", "[", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{"#", ",", "\"\<Text\>\"", ",", "Italic"}], "]"}], ",", " ", 
         
         RowBox[{"ImageSizeAction", "\[Rule]", "\"\<ShrinkToFit\>\""}], ",", 
         RowBox[{"BaseStyle", " ", "->", " ", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"LineIndent", " ", "->", " ", "0"}], ",", " ", 
            RowBox[{"LinebreakAdjustments", " ", "->", " ", 
             RowBox[{"{", 
              RowBox[{
              "1", ",", " ", "1", ",", " ", "0", ",", " ", "0", ",", " ", 
               "0"}], "}"}]}], ",", " ", 
            RowBox[{"LineBreakWithin", " ", "->", " ", "Automatic"}], ",", 
            " ", 
            RowBox[{"Hyphenation", " ", "->", " ", "True"}], ",", " ", 
            RowBox[{"TextAlignment", " ", "->", " ", "Left"}], 
            ",", "\"\<TR\>\""}], "}"}]}], ",", " ", 
         RowBox[{"BaselinePosition", " ", "->", " ", "Bottom"}]}], "]"}], 
       "&"}], " ", "/@", 
      RowBox[{"{", 
       RowBox[{"\"\<Statement A\>\"", 
        ",", "\"\<Payoff for the bet on the truth of A\>\"", " ", ",", 
        " ", "\"\<Payoff for the bet against the truth of A\>\""}], "}"}]}], ",",
      "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"Pane", "[", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{"#", ",", "\"\<Text\>\""}], "]"}], ",", " ", 
         RowBox[{"ImageSizeAction", "\[Rule]", "\"\<ShrinkToFit\>\""}], ",", 
         RowBox[{"BaseStyle", " ", "->", " ", 
          RowBox[{"{", "\"\<TR\>\"", "}"}]}], ",", " ", 
         RowBox[{"BaselinePosition", " ", "->", " ", "Bottom"}]}], "]"}], 
       "&"}], " ", "/@", 
      RowBox[{"{", 
       RowBox[{"\"\<A is true\>\"", ",", "\"\<(1 - p)\[CenterDot]n$\>\"", " ",
         ",", "\"\<-(1 - p)\[CenterDot]n$\>\""}], "}"}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"Pane", "[", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{"#", ",", "\"\<Text\>\""}], "]"}], ",", " ", 
         RowBox[{"ImageSizeAction", "\[Rule]", "\"\<ShrinkToFit\>\""}], ",", 
         RowBox[{"BaseStyle", " ", "->", " ", 
          RowBox[{"{", "\"\<TR\>\"", "}"}]}], ",", " ", 
         RowBox[{"BaselinePosition", " ", "->", " ", "Bottom"}]}], "]"}], 
       "&"}], " ", "/@", 
      RowBox[{"{", 
       RowBox[{"\"\<A is false\>\"", ",", "\"\< -p\[CenterDot]n$\>\"", " ", 
        ",", "\"\< p\[CenterDot]n$\>\""}], "}"}]}]}], "\[IndentingNewLine]", 
    "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.5521026014655943`*^9, 3.552102635822619*^9}, {
   3.552102697058507*^9, 3.552102716541814*^9}, {3.5521027575340023`*^9, 
   3.552102834490437*^9}, {3.552102930967421*^9, 3.552103016046608*^9}, {
   3.552103053928179*^9, 3.552103076113628*^9}, 3.552103370609177*^9, {
   3.552103414717738*^9, 3.552103415932863*^9}, {3.55210350254058*^9, 
   3.552103524828726*^9}, 3.552103560364336*^9, {3.552103591006752*^9, 
   3.552103610543189*^9}, {3.5521036960756397`*^9, 3.552103696506854*^9}, {
   3.552103733992571*^9, 3.552103739207076*^9}, {3.552103787702858*^9, 
   3.552103789126577*^9}, {3.552103879548175*^9, 3.5521040126709642`*^9}, {
   3.552104052071844*^9, 3.5521040530385237`*^9}, {3.552104156608767*^9, 
   3.55210415660883*^9}, 3.552104200775548*^9, {3.5521042390852537`*^9, 
   3.5521042493497963`*^9}, {3.5521043177224207`*^9, 3.552104356637162*^9}, 
   3.55210647809912*^9},
 CellLabel->"In[97]:=",
 $CellContext`InitializationGroup -> 
 True,ExpressionUUID->"a792b3ff-55b6-45ff-be54-8b8cc06b364e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"c2s1Table1", "=", 
  RowBox[{"Grid", "[", 
   RowBox[{"data1", ",", 
    RowBox[{"Dividers", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Darker", "[", 
          RowBox[{"Gray", ",", ".6"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"Darker", "[", 
           RowBox[{"Gray", ",", ".5"}], "]"}], "}"}], ",", 
         RowBox[{"Darker", "[", 
          RowBox[{"Gray", ",", ".6"}], "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Darker", "[", 
          RowBox[{"Gray", ",", ".6"}], "]"}], ",", 
         RowBox[{"Darker", "[", 
          RowBox[{"Gray", ",", ".6"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"Lighter", "[", 
           RowBox[{"Gray", ",", ".5"}], "]"}], "}"}], ",", 
         RowBox[{"Darker", "[", 
          RowBox[{"Gray", ",", ".6"}], "]"}]}], "}"}]}], "}"}]}], ",", 
    RowBox[{"Spacings", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"Automatic", ",", ".8"}], "}"}]}], ",", 
    RowBox[{"Alignment", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"Left", ",", "Center", ",", 
        RowBox[{"{", "Center", "}"}]}], "}"}], "}"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.552103386035222*^9, 3.5521033974669657`*^9}, 
   3.552104364482621*^9, {3.552104402128168*^9, 3.552104415560268*^9}, {
   3.55210444905976*^9, 3.552104469761512*^9}, {3.552104512676922*^9, 
   3.552104548013364*^9}, {3.552104624638319*^9, 3.5521046317368526`*^9}, 
   3.552106479811811*^9},
 CellLabel->"In[98]:=",
 $CellContext`InitializationGroup -> 
 True,ExpressionUUID->"68d1c5a2-cbbc-4e3e-bf27-a5be4acaacee"],

Cell[BoxData[
 TagBox[GridBox[{
    {
     PaneBox[
      StyleBox["\<\"Statement A\"\>", "Text",
       StripOnInput->False,
       FontSlant->Italic],
      BaseStyle->{
       LineIndent -> 0, LinebreakAdjustments -> {1, 1, 0, 0, 0}, 
        LineBreakWithin -> Automatic, Hyphenation -> True, TextAlignment -> 
        Left, "TR"},
      BaselinePosition->Bottom,
      ImageSizeAction->"ShrinkToFit"], 
     PaneBox[
      StyleBox["\<\"Payoff for the bet on the truth of A\"\>", "Text",
       StripOnInput->False,
       FontSlant->Italic],
      BaseStyle->{
       LineIndent -> 0, LinebreakAdjustments -> {1, 1, 0, 0, 0}, 
        LineBreakWithin -> Automatic, Hyphenation -> True, TextAlignment -> 
        Left, "TR"},
      BaselinePosition->Bottom,
      ImageSizeAction->"ShrinkToFit"], 
     PaneBox[
      StyleBox["\<\"Payoff for the bet against the truth of A\"\>", "Text",
       StripOnInput->False,
       FontSlant->Italic],
      BaseStyle->{
       LineIndent -> 0, LinebreakAdjustments -> {1, 1, 0, 0, 0}, 
        LineBreakWithin -> Automatic, Hyphenation -> True, TextAlignment -> 
        Left, "TR"},
      BaselinePosition->Bottom,
      ImageSizeAction->"ShrinkToFit"]},
    {
     PaneBox[
      StyleBox["\<\"A is true\"\>", "Text",
       StripOnInput->False],
      BaseStyle->{"TR"},
      BaselinePosition->Bottom,
      ImageSizeAction->"ShrinkToFit"], 
     PaneBox[
      StyleBox["\<\"(1 - p)\[CenterDot]n$\"\>", "Text",
       StripOnInput->False],
      BaseStyle->{"TR"},
      BaselinePosition->Bottom,
      ImageSizeAction->"ShrinkToFit"], 
     PaneBox[
      StyleBox["\<\"-(1 - p)\[CenterDot]n$\"\>", "Text",
       StripOnInput->False],
      BaseStyle->{"TR"},
      BaselinePosition->Bottom,
      ImageSizeAction->"ShrinkToFit"]},
    {
     PaneBox[
      StyleBox["\<\"A is false\"\>", "Text",
       StripOnInput->False],
      BaseStyle->{"TR"},
      BaselinePosition->Bottom,
      ImageSizeAction->"ShrinkToFit"], 
     PaneBox[
      StyleBox["\<\" -p\[CenterDot]n$\"\>", "Text",
       StripOnInput->False],
      BaseStyle->{"TR"},
      BaselinePosition->Bottom,
      ImageSizeAction->"ShrinkToFit"], 
     PaneBox[
      StyleBox["\<\" p\[CenterDot]n$\"\>", "Text",
       StripOnInput->False],
      BaseStyle->{"TR"},
      BaselinePosition->Bottom,
      ImageSizeAction->"ShrinkToFit"]}
   },
   AutoDelete->False,
   GridBoxAlignment->{"Columns" -> {Left, Center, {Center}}},
   GridBoxDividers->{"Columns" -> {
       RGBColor[0.2, 0.2, 0.2], {
        RGBColor[0.25, 0.25, 0.25]}, 
       RGBColor[0.2, 0.2, 0.2]}, "Rows" -> {
       RGBColor[0.2, 0.2, 0.2], 
       RGBColor[0.2, 0.2, 0.2], {
        RGBColor[0.75, 0.75, 0.75]}, 
       RGBColor[0.2, 0.2, 0.2]}},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{0.8}}}],
  "Grid"]], "Output",
 CellChangeTimes->{3.947576680418264*^9, 3.951815794093813*^9, 
  3.9557693315089617`*^9},
 CellLabel->"Out[98]=",
 $CellContext`InitializationGroup -> 
 True,ExpressionUUID->"c956697d-fcda-48f1-946f-8bd78dcbd2e3"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["c2s1Table2", "Section",
 CellChangeTimes->{{3.5723420028690567`*^9, 3.572342011627058*^9}, {
   3.947391571097383*^9, 3.947391617058372*^9}, 3.9473923450883703`*^9, 
   3.947393236393119*^9, 3.947575060658597*^9, 3.94757625885634*^9, 
   3.947576305999908*^9},
 $CellContext`InitializationGroup -> 
 True,ExpressionUUID->"91edcfe0-d4e5-4621-a6d2-825128f412dd"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"SetOptions", "[", 
    RowBox[{"Pane", ",", 
     RowBox[{"ImageSizeAction", "\[Rule]", "\"\<ShrinkToFit\>\""}], ",", 
     RowBox[{"BaseStyle", " ", "->", " ", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"LineIndent", " ", "->", " ", "0"}], ",", " ", 
        RowBox[{"LinebreakAdjustments", " ", "->", " ", 
         RowBox[{"{", 
          RowBox[{
          "1", ",", " ", "1", ",", " ", "0", ",", " ", "0", ",", " ", "0"}], 
          "}"}]}], ",", " ", 
        RowBox[{"LineBreakWithin", " ", "->", " ", "Automatic"}], ",", " ", 
        RowBox[{"Hyphenation", " ", "->", " ", "True"}], ",", " ", 
        RowBox[{"TextAlignment", " ", "->", " ", "Left"}], 
        ",", "\"\<TR\>\""}], "}"}]}]}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"data2", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Pane", "[", 
        RowBox[{"Style", "[", 
         RowBox[{"\"\<Axiom I\>\"", ",", "\"\<TR\>\"", ",", "Bold"}], "]"}], 
        "]"}], ",", 
       RowBox[{"Pane", "[", 
        RowBox[{"Style", "[", 
         RowBox[{"\"\<For each A, 0 \[LessEqual] P(A) \[LessEqual] 1\>\"", 
          ",", "\"\<TR\>\"", ",", "Italic"}], "]"}], "]"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Pane", "[", 
        RowBox[{"Style", "[", 
         RowBox[{"\"\<Axiom II\>\"", ",", "\"\<TR\>\"", ",", "Bold"}], "]"}], 
        "]"}], ",", 
       RowBox[{"Pane", "[", 
        RowBox[{"Style", "[", 
         RowBox[{"\"\<If A is impossible (A = \[EmptySet], the empty set), \
then P(A) = 0\>\"", ",", "\"\<TR\>\"", ",", "Italic"}], "]"}], "]"}]}], "}"}],
      ",", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Pane", "[", 
        RowBox[{"Style", "[", 
         RowBox[{"\"\<Axiom III\>\"", ",", "\"\<TR\>\"", ",", "Bold"}], "]"}],
         "]"}], ",", 
       RowBox[{"Pane", "[", 
        RowBox[{"Style", "[", 
         RowBox[{"\"\<If A is certain (A = \[CapitalOmega], the sample \
space), then P(A) = 1\>\"", ",", "\"\<TR\>\"", ",", "Italic"}], "]"}], 
        "]"}]}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Pane", "[", 
        RowBox[{"Style", "[", 
         RowBox[{"\"\<Axiom IV\>\"", ",", "\"\<TR\>\"", ",", "Bold"}], "]"}], 
        "]"}], ",", 
       RowBox[{"Pane", "[", 
        RowBox[{"Style", "[", 
         RowBox[{"\"\<If A and B are disjoint events (A \[Intersection] B = \
\[EmptySet]),  P(A\[Union]B) = P(A) + P(B)\>\"", ",", "\"\<TR\>\"", ",", 
          "Italic"}], "]"}], "]"}]}], "}"}]}], "}"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.5521026014655943`*^9, 3.552102635822619*^9}, {
   3.552102697058507*^9, 3.552102716541814*^9}, {3.5521027575340023`*^9, 
   3.552102834490437*^9}, {3.552102930967421*^9, 3.552103016046608*^9}, {
   3.552103053928179*^9, 3.552103076113628*^9}, 3.552103370609177*^9, {
   3.552103414717738*^9, 3.552103415932863*^9}, {3.55210350254058*^9, 
   3.552103524828726*^9}, 3.552103560364336*^9, {3.552103591006752*^9, 
   3.552103610543189*^9}, {3.5521036960756397`*^9, 3.552103696506854*^9}, {
   3.552103733992571*^9, 3.552103739207076*^9}, {3.552103787702858*^9, 
   3.552103789126577*^9}, {3.552103879548175*^9, 3.5521040126709642`*^9}, {
   3.552104052071844*^9, 3.5521040530385237`*^9}, {3.552104156608767*^9, 
   3.55210415660883*^9}, 3.552104200775548*^9, {3.5521042390852537`*^9, 
   3.5521042493497963`*^9}, {3.5521043177224207`*^9, 3.552104356637162*^9}, {
   3.552104955566662*^9, 3.55210495626079*^9}, {3.552105000304809*^9, 
   3.552105272663146*^9}, {3.552105364271854*^9, 3.55210539775602*^9}, 
   3.5521064709349613`*^9},
 CellLabel->"In[99]:=",
 $CellContext`InitializationGroup -> 
 True,ExpressionUUID->"016c9d1b-bd78-46b9-99e9-cc20b6c72d2c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"c2s1Table2", "=", 
  RowBox[{"Grid", "[", 
   RowBox[{"data2", ",", 
    RowBox[{"Dividers", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Darker", "[", 
          RowBox[{"Gray", ",", ".6"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"Darker", "[", 
           RowBox[{"Gray", ",", ".5"}], "]"}], "}"}], ",", 
         RowBox[{"Darker", "[", 
          RowBox[{"Gray", ",", ".6"}], "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Darker", "[", 
          RowBox[{"Gray", ",", ".6"}], "]"}], ",", 
         RowBox[{"Lighter", "[", 
          RowBox[{"Gray", ",", ".6"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"Lighter", "[", 
           RowBox[{"Gray", ",", ".5"}], "]"}], "}"}], ",", 
         RowBox[{"Darker", "[", 
          RowBox[{"Gray", ",", ".6"}], "]"}]}], "}"}]}], "}"}]}], ",", 
    RowBox[{"Spacings", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"Automatic", ",", ".8"}], "}"}]}], ",", 
    RowBox[{"Alignment", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"Left", ",", "Center", ",", 
        RowBox[{"{", "Center", "}"}]}], "}"}], "}"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.552103386035222*^9, 3.5521033974669657`*^9}, 
   3.552104364482621*^9, {3.552104402128168*^9, 3.552104415560268*^9}, {
   3.55210444905976*^9, 3.552104469761512*^9}, {3.552104512676922*^9, 
   3.552104548013364*^9}, {3.552104624638319*^9, 3.5521046317368526`*^9}, {
   3.5521053027244463`*^9, 3.552105341477475*^9}, {3.552105426778727*^9, 
   3.5521054577949867`*^9}, 3.552106473443452*^9},
 CellLabel->"In[101]:=",
 $CellContext`InitializationGroup -> 
 True,ExpressionUUID->"0c18cd37-979a-4761-a096-10f48e98e6e0"],

Cell[BoxData[
 TagBox[GridBox[{
    {
     PaneBox[
      StyleBox["\<\"Axiom I\"\>", "TR",
       StripOnInput->False,
       FontWeight->Bold]], 
     PaneBox[
      StyleBox["\<\"For each A, 0 \[LessEqual] P(A) \[LessEqual] 1\"\>", "TR",
       
       StripOnInput->False,
       FontSlant->Italic]]},
    {
     PaneBox[
      StyleBox["\<\"Axiom II\"\>", "TR",
       StripOnInput->False,
       FontWeight->Bold]], 
     PaneBox[
      StyleBox["\<\"If A is impossible (A = \[EmptySet], the empty set), then \
P(A) = 0\"\>", "TR",
       StripOnInput->False,
       FontSlant->Italic]]},
    {
     PaneBox[
      StyleBox["\<\"Axiom III\"\>", "TR",
       StripOnInput->False,
       FontWeight->Bold]], 
     PaneBox[
      StyleBox["\<\"If A is certain (A = \[CapitalOmega], the sample space), \
then P(A) = 1\"\>", "TR",
       StripOnInput->False,
       FontSlant->Italic]]},
    {
     PaneBox[
      StyleBox["\<\"Axiom IV\"\>", "TR",
       StripOnInput->False,
       FontWeight->Bold]], 
     PaneBox[
      StyleBox["\<\"If A and B are disjoint events (A \[Intersection] B = \
\[EmptySet]),  P(A\[Union]B) = P(A) + P(B)\"\>", "TR",
       StripOnInput->False,
       FontSlant->Italic]]}
   },
   AutoDelete->False,
   GridBoxAlignment->{"Columns" -> {Left, Center, {Center}}},
   GridBoxDividers->{"Columns" -> {
       RGBColor[0.2, 0.2, 0.2], {
        RGBColor[0.25, 0.25, 0.25]}, 
       RGBColor[0.2, 0.2, 0.2]}, "Rows" -> {
       RGBColor[0.2, 0.2, 0.2], 
       RGBColor[0.8, 0.8, 0.8], {
        RGBColor[0.75, 0.75, 0.75]}, 
       RGBColor[0.2, 0.2, 0.2]}},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{0.8}}}],
  "Grid"]], "Output",
 CellChangeTimes->{3.9475766805333557`*^9, 3.951815800963888*^9, 
  3.955769331521893*^9},
 CellLabel->"Out[101]=",
 $CellContext`InitializationGroup -> 
 True,ExpressionUUID->"f6f2d8e8-76dc-4500-b0a5-eded31d8b042"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["c2s1Table3", "Section",
 CellChangeTimes->{{3.5723420028690567`*^9, 3.572342011627058*^9}, {
   3.947391571097383*^9, 3.947391617058372*^9}, 3.9473923450883703`*^9, 
   3.947393236393119*^9, 3.947575060658597*^9, 3.94757625885634*^9, {
   3.947576305999908*^9, 3.94757631894092*^9}},
 $CellContext`InitializationGroup -> 
 True,ExpressionUUID->"9b9bc741-4a56-499f-85f9-6e37c26d1f0f"],

Cell[BoxData[
 RowBox[{
  RowBox[{"data3", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"Pane", "[", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{"#", ",", "\"\<Text\>\"", ",", "Italic"}], "]"}], ",", " ", 
         
         RowBox[{"ImageSizeAction", "\[Rule]", "\"\<ShrinkToFit\>\""}], ",", 
         RowBox[{"BaseStyle", " ", "->", " ", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"LineIndent", " ", "->", " ", "0"}], ",", " ", 
            RowBox[{"LinebreakAdjustments", " ", "->", " ", 
             RowBox[{"{", 
              RowBox[{
              "1", ",", " ", "1", ",", " ", "0", ",", " ", "0", ",", " ", 
               "0"}], "}"}]}], ",", " ", 
            RowBox[{"LineBreakWithin", " ", "->", " ", "Automatic"}], ",", 
            " ", 
            RowBox[{"Hyphenation", " ", "->", " ", "True"}], ",", " ", 
            RowBox[{"TextAlignment", " ", "->", " ", "Left"}], 
            ",", "\"\<TR\>\""}], "}"}]}], ",", " ", 
         RowBox[{"BaselinePosition", " ", "->", " ", "Bottom"}]}], "]"}], 
       "&"}], " ", "/@", 
      RowBox[{"{", 
       RowBox[{"\"\<Statement A\>\"", 
        ",", "\"\<Payoff for the bet on the truth of A\>\"", " ", ",", 
        " ", "\"\<Payoff for the bet against the truth of A\>\""}], "}"}]}], ",",
      "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"Pane", "[", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{"#", ",", "\"\<Text\>\""}], "]"}], ",", " ", 
         RowBox[{"ImageSizeAction", "\[Rule]", "\"\<ShrinkToFit\>\""}], ",", 
         RowBox[{"BaseStyle", " ", "->", " ", 
          RowBox[{"{", "\"\<TR\>\"", "}"}]}], ",", " ", 
         RowBox[{"BaselinePosition", " ", "->", " ", "Bottom"}]}], "]"}], 
       "&"}], " ", "/@", 
      RowBox[{"{", 
       RowBox[{"\"\<A is true\>\"", 
        ",", "\"\<(1 - p)\[CenterDot]n$ (always > 0)\>\"", " ", 
        ",", "\"\<-(1 - p)\[CenterDot]n$ \
\!\(\*StyleBox[\"(\",FontColor->RGBColor[1, 0, \
0]]\)\!\(\*StyleBox[\"always\",FontColor->RGBColor[1, 0, 0]]\)\!\(\*StyleBox[\
\" \",FontColor->RGBColor[1, 0, \
0]]\)\!\(\*StyleBox[\"<\",FontColor->RGBColor[1, 0, 0]]\)\!\(\*StyleBox[\" \
\",FontColor->RGBColor[1, 0, 0]]\)\!\(\*StyleBox[\"0\",FontColor->RGBColor[1, \
0, 0]]\)\!\(\*StyleBox[\")\",FontColor->RGBColor[1, 0, 0]]\)\>\""}], "}"}]}], 
     ",", 
     RowBox[{
      RowBox[{
       RowBox[{"Pane", "[", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{"#", ",", "\"\<Text\>\""}], "]"}], ",", " ", 
         RowBox[{"ImageSizeAction", "\[Rule]", "\"\<ShrinkToFit\>\""}], ",", 
         RowBox[{"BaseStyle", " ", "->", " ", 
          RowBox[{"{", "\"\<TR\>\"", "}"}]}], ",", " ", 
         RowBox[{"BaselinePosition", " ", "->", " ", "Bottom"}]}], "]"}], 
       "&"}], " ", "/@", 
      RowBox[{"{", 
       RowBox[{"\"\<A is false\>\"", 
        ",", "\"\< -p\[CenterDot]n$ (always > 0)\>\"", " ", 
        ",", "\"\< p\[CenterDot]n$ \
\!\(\*StyleBox[\"(\",FontColor->RGBColor[1, 0, \
0]]\)\!\(\*StyleBox[\"always\",FontColor->RGBColor[1, 0, 0]]\)\!\(\*StyleBox[\
\" \",FontColor->RGBColor[1, 0, \
0]]\)\!\(\*StyleBox[\"<\",FontColor->RGBColor[1, 0, 0]]\)\!\(\*StyleBox[\" \
\",FontColor->RGBColor[1, 0, 0]]\)\!\(\*StyleBox[\"0\",FontColor->RGBColor[1, \
0, 0]]\)\!\(\*StyleBox[\")\",FontColor->RGBColor[1, 0, 0]]\)\>\""}], 
       "}"}]}]}], "\[IndentingNewLine]", "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.5521026014655943`*^9, 3.552102635822619*^9}, {
   3.552102697058507*^9, 3.552102716541814*^9}, {3.5521027575340023`*^9, 
   3.552102834490437*^9}, {3.552102930967421*^9, 3.552103016046608*^9}, {
   3.552103053928179*^9, 3.552103076113628*^9}, 3.552103370609177*^9, {
   3.552103414717738*^9, 3.552103415932863*^9}, {3.55210350254058*^9, 
   3.552103524828726*^9}, 3.552103560364336*^9, {3.552103591006752*^9, 
   3.552103610543189*^9}, {3.5521036960756397`*^9, 3.552103696506854*^9}, {
   3.552103733992571*^9, 3.552103739207076*^9}, {3.552103787702858*^9, 
   3.552103789126577*^9}, {3.552103879548175*^9, 3.5521040126709642`*^9}, {
   3.552104052071844*^9, 3.5521040530385237`*^9}, {3.552104156608767*^9, 
   3.55210415660883*^9}, 3.552104200775548*^9, {3.5521042390852537`*^9, 
   3.5521042493497963`*^9}, {3.5521043177224207`*^9, 3.552104356637162*^9}, 
   3.552106100331746*^9, {3.552106138566402*^9, 3.552106261482822*^9}, 
   3.9469688618251133`*^9},
 CellLabel->"In[102]:=",
 $CellContext`InitializationGroup -> 
 True,ExpressionUUID->"fd540430-ca5d-4579-b6d5-94aec2ce3dfa"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"c2s1Table3", "=", 
  RowBox[{"Grid", "[", 
   RowBox[{"data3", ",", 
    RowBox[{"Dividers", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Darker", "[", 
          RowBox[{"Gray", ",", ".6"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"Darker", "[", 
           RowBox[{"Gray", ",", ".5"}], "]"}], "}"}], ",", 
         RowBox[{"Darker", "[", 
          RowBox[{"Gray", ",", ".6"}], "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Darker", "[", 
          RowBox[{"Gray", ",", ".6"}], "]"}], ",", 
         RowBox[{"Darker", "[", 
          RowBox[{"Gray", ",", ".6"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"Lighter", "[", 
           RowBox[{"Gray", ",", ".5"}], "]"}], "}"}], ",", 
         RowBox[{"Darker", "[", 
          RowBox[{"Gray", ",", ".6"}], "]"}]}], "}"}]}], "}"}]}], ",", 
    RowBox[{"Spacings", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"Automatic", ",", ".8"}], "}"}]}], ",", 
    RowBox[{"Alignment", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"Left", ",", "Center", ",", 
        RowBox[{"{", "Center", "}"}]}], "}"}], "}"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.552103386035222*^9, 3.5521033974669657`*^9}, 
   3.552104364482621*^9, {3.552104402128168*^9, 3.552104415560268*^9}, {
   3.55210444905976*^9, 3.552104469761512*^9}, {3.552104512676922*^9, 
   3.552104548013364*^9}, {3.552104624638319*^9, 3.5521046317368526`*^9}, {
   3.5521060943418818`*^9, 3.5521061025404263`*^9}},
 CellLabel->"In[103]:=",
 $CellContext`InitializationGroup -> 
 True,ExpressionUUID->"faddc5c7-bbd8-4034-b670-4a6ded10993e"],

Cell[BoxData[
 TagBox[GridBox[{
    {
     PaneBox[
      StyleBox["\<\"Statement A\"\>", "Text",
       StripOnInput->False,
       FontSlant->Italic],
      BaseStyle->{
       LineIndent -> 0, LinebreakAdjustments -> {1, 1, 0, 0, 0}, 
        LineBreakWithin -> Automatic, Hyphenation -> True, TextAlignment -> 
        Left, "TR"},
      BaselinePosition->Bottom,
      ImageSizeAction->"ShrinkToFit"], 
     PaneBox[
      StyleBox["\<\"Payoff for the bet on the truth of A\"\>", "Text",
       StripOnInput->False,
       FontSlant->Italic],
      BaseStyle->{
       LineIndent -> 0, LinebreakAdjustments -> {1, 1, 0, 0, 0}, 
        LineBreakWithin -> Automatic, Hyphenation -> True, TextAlignment -> 
        Left, "TR"},
      BaselinePosition->Bottom,
      ImageSizeAction->"ShrinkToFit"], 
     PaneBox[
      StyleBox["\<\"Payoff for the bet against the truth of A\"\>", "Text",
       StripOnInput->False,
       FontSlant->Italic],
      BaseStyle->{
       LineIndent -> 0, LinebreakAdjustments -> {1, 1, 0, 0, 0}, 
        LineBreakWithin -> Automatic, Hyphenation -> True, TextAlignment -> 
        Left, "TR"},
      BaselinePosition->Bottom,
      ImageSizeAction->"ShrinkToFit"]},
    {
     PaneBox[
      StyleBox["\<\"A is true\"\>", "Text",
       StripOnInput->False],
      BaseStyle->{"TR"},
      BaselinePosition->Bottom,
      ImageSizeAction->"ShrinkToFit"], 
     PaneBox[
      StyleBox["\<\"(1 - p)\[CenterDot]n$ (always > 0)\"\>", "Text",
       StripOnInput->False],
      BaseStyle->{"TR"},
      BaselinePosition->Bottom,
      ImageSizeAction->"ShrinkToFit"], 
     PaneBox[
      StyleBox["\<\"-(1 - p)\[CenterDot]n$ \
\\!\\(\\*StyleBox[\\\"(\\\",FontColor->RGBColor[1, 0, \
0]]\\)\\!\\(\\*StyleBox[\\\"always\\\",FontColor->RGBColor[1, 0, 0]]\\)\\!\\(\
\\*StyleBox[\\\" \\\",FontColor->RGBColor[1, 0, 0]]\\)\\!\\(\\*StyleBox[\\\"<\
\\\",FontColor->RGBColor[1, 0, 0]]\\)\\!\\(\\*StyleBox[\\\" \
\\\",FontColor->RGBColor[1, 0, \
0]]\\)\\!\\(\\*StyleBox[\\\"0\\\",FontColor->RGBColor[1, 0, \
0]]\\)\\!\\(\\*StyleBox[\\\")\\\",FontColor->RGBColor[1, 0, 0]]\\)\"\>", 
       "Text",
       StripOnInput->False],
      BaseStyle->{"TR"},
      BaselinePosition->Bottom,
      ImageSizeAction->"ShrinkToFit"]},
    {
     PaneBox[
      StyleBox["\<\"A is false\"\>", "Text",
       StripOnInput->False],
      BaseStyle->{"TR"},
      BaselinePosition->Bottom,
      ImageSizeAction->"ShrinkToFit"], 
     PaneBox[
      StyleBox["\<\" -p\[CenterDot]n$ (always > 0)\"\>", "Text",
       StripOnInput->False],
      BaseStyle->{"TR"},
      BaselinePosition->Bottom,
      ImageSizeAction->"ShrinkToFit"], 
     PaneBox[
      StyleBox["\<\" p\[CenterDot]n$ \
\\!\\(\\*StyleBox[\\\"(\\\",FontColor->RGBColor[1, 0, \
0]]\\)\\!\\(\\*StyleBox[\\\"always\\\",FontColor->RGBColor[1, 0, 0]]\\)\\!\\(\
\\*StyleBox[\\\" \\\",FontColor->RGBColor[1, 0, 0]]\\)\\!\\(\\*StyleBox[\\\"<\
\\\",FontColor->RGBColor[1, 0, 0]]\\)\\!\\(\\*StyleBox[\\\" \
\\\",FontColor->RGBColor[1, 0, \
0]]\\)\\!\\(\\*StyleBox[\\\"0\\\",FontColor->RGBColor[1, 0, \
0]]\\)\\!\\(\\*StyleBox[\\\")\\\",FontColor->RGBColor[1, 0, 0]]\\)\"\>", 
       "Text",
       StripOnInput->False],
      BaseStyle->{"TR"},
      BaselinePosition->Bottom,
      ImageSizeAction->"ShrinkToFit"]}
   },
   AutoDelete->False,
   GridBoxAlignment->{"Columns" -> {Left, Center, {Center}}},
   GridBoxDividers->{"Columns" -> {
       RGBColor[0.2, 0.2, 0.2], {
        RGBColor[0.25, 0.25, 0.25]}, 
       RGBColor[0.2, 0.2, 0.2]}, "Rows" -> {
       RGBColor[0.2, 0.2, 0.2], 
       RGBColor[0.2, 0.2, 0.2], {
        RGBColor[0.75, 0.75, 0.75]}, 
       RGBColor[0.2, 0.2, 0.2]}},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{0.8}}}],
  "Grid"]], "Output",
 CellChangeTimes->{3.9475766805444202`*^9, 3.951815806894703*^9, 
  3.955769331537599*^9},
 CellLabel->"Out[103]=",
 $CellContext`InitializationGroup -> 
 True,ExpressionUUID->"46ca386b-ba33-4a9c-8c53-b05edb5e9860"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["c2s1Table4", "Section",
 CellChangeTimes->{{3.5723420028690567`*^9, 3.572342011627058*^9}, {
   3.947391571097383*^9, 3.947391617058372*^9}, 3.9473923450883703`*^9, 
   3.947393236393119*^9, 3.947575060658597*^9, 3.94757625885634*^9, {
   3.947576305999908*^9, 3.9475763418928547`*^9}},
 $CellContext`InitializationGroup -> 
 True,ExpressionUUID->"9c97c27d-6328-4cd8-8f94-8efb8e4c5969"],

Cell[BoxData[
 RowBox[{
  RowBox[{"data4", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"Pane", "[", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{"#", ",", "\"\<Text\>\"", ",", "Italic"}], "]"}], ",", " ", 
         
         RowBox[{"ImageSizeAction", "\[Rule]", "\"\<ShrinkToFit\>\""}], ",", 
         RowBox[{"BaseStyle", " ", "->", " ", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"LineIndent", " ", "->", " ", "0"}], ",", " ", 
            RowBox[{"LinebreakAdjustments", " ", "->", " ", 
             RowBox[{"{", 
              RowBox[{
              "1", ",", " ", "1", ",", " ", "0", ",", " ", "0", ",", " ", 
               "0"}], "}"}]}], ",", " ", 
            RowBox[{"LineBreakWithin", " ", "->", " ", "Automatic"}], ",", 
            " ", 
            RowBox[{"Hyphenation", " ", "->", " ", "True"}], ",", " ", 
            RowBox[{"TextAlignment", " ", "->", " ", "Left"}], 
            ",", "\"\<TR\>\""}], "}"}]}], ",", " ", 
         RowBox[{"BaselinePosition", " ", "->", " ", "Bottom"}]}], "]"}], 
       "&"}], " ", "/@", 
      RowBox[{"{", 
       RowBox[{"\"\<Statement A\>\"", 
        ",", "\"\<Payoff for the bet on the truth of A\>\"", " ", ",", 
        " ", "\"\<Payoff for the bet against the truth of A\>\""}], "}"}]}], ",",
      "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"Pane", "[", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{"#", ",", "\"\<Text\>\""}], "]"}], ",", " ", 
         RowBox[{"ImageSizeAction", "\[Rule]", "\"\<ShrinkToFit\>\""}], ",", 
         RowBox[{"BaseStyle", " ", "->", " ", 
          RowBox[{"{", "\"\<TR\>\"", "}"}]}], ",", " ", 
         RowBox[{"BaselinePosition", " ", "->", " ", "Bottom"}]}], "]"}], 
       "&"}], " ", "/@", 
      RowBox[{"{", 
       RowBox[{"\"\<A is false\>\"", 
        ",", "\"\< -p\[CenterDot]n$ \
\!\(\*StyleBox[\"(\",FontColor->RGBColor[1, 0, \
0]]\)\!\(\*StyleBox[\"always\",FontColor->RGBColor[1, 0, 0]]\)\!\(\*StyleBox[\
\" \",FontColor->RGBColor[1, 0, \
0]]\)\!\(\*StyleBox[\"<\",FontColor->RGBColor[1, 0, 0]]\)\!\(\*StyleBox[\" \
\",FontColor->RGBColor[1, 0, 0]]\)\!\(\*StyleBox[\"0\",FontColor->RGBColor[1, \
0, 0]]\)\!\(\*StyleBox[\")\",FontColor->RGBColor[1, 0, 0]]\)\>\"", " ", 
        ",", "\"\< p\[CenterDot]n$ (always > 0)\>\""}], "}"}]}]}], 
    "\[IndentingNewLine]", "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.5521026014655943`*^9, 3.552102635822619*^9}, {
   3.552102697058507*^9, 3.552102716541814*^9}, {3.5521027575340023`*^9, 
   3.552102834490437*^9}, {3.552102930967421*^9, 3.552103016046608*^9}, {
   3.552103053928179*^9, 3.552103076113628*^9}, 3.552103370609177*^9, {
   3.552103414717738*^9, 3.552103415932863*^9}, {3.55210350254058*^9, 
   3.552103524828726*^9}, 3.552103560364336*^9, {3.552103591006752*^9, 
   3.552103610543189*^9}, {3.5521036960756397`*^9, 3.552103696506854*^9}, {
   3.552103733992571*^9, 3.552103739207076*^9}, {3.552103787702858*^9, 
   3.552103789126577*^9}, {3.552103879548175*^9, 3.5521040126709642`*^9}, {
   3.552104052071844*^9, 3.5521040530385237`*^9}, {3.552104156608767*^9, 
   3.55210415660883*^9}, 3.552104200775548*^9, {3.5521042390852537`*^9, 
   3.5521042493497963`*^9}, {3.5521043177224207`*^9, 3.552104356637162*^9}, 
   3.552106100331746*^9, {3.552106138566402*^9, 3.552106261482822*^9}, 
   3.552106520254457*^9, 3.552106551093672*^9, {3.589608084406666*^9, 
   3.589608089045755*^9}, {3.589608119426508*^9, 3.589608141287786*^9}},
 CellLabel->"In[104]:=",
 $CellContext`InitializationGroup -> 
 True,ExpressionUUID->"71fa5c6d-750b-4909-b2fb-dfd733388f70"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"c2s1Table4", "=", 
  RowBox[{"Grid", "[", 
   RowBox[{"data4", ",", 
    RowBox[{"Dividers", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Darker", "[", 
          RowBox[{"Gray", ",", ".6"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"Darker", "[", 
           RowBox[{"Gray", ",", ".5"}], "]"}], "}"}], ",", 
         RowBox[{"Darker", "[", 
          RowBox[{"Gray", ",", ".6"}], "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Darker", "[", 
          RowBox[{"Gray", ",", ".6"}], "]"}], ",", 
         RowBox[{"Darker", "[", 
          RowBox[{"Gray", ",", ".6"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"Lighter", "[", 
           RowBox[{"Gray", ",", ".5"}], "]"}], "}"}], ",", 
         RowBox[{"Darker", "[", 
          RowBox[{"Gray", ",", ".6"}], "]"}]}], "}"}]}], "}"}]}], ",", 
    RowBox[{"Spacings", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"Automatic", ",", ".8"}], "}"}]}], ",", 
    RowBox[{"Alignment", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"Left", ",", "Center", ",", 
        RowBox[{"{", "Center", "}"}]}], "}"}], "}"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.552103386035222*^9, 3.5521033974669657`*^9}, 
   3.552104364482621*^9, {3.552104402128168*^9, 3.552104415560268*^9}, {
   3.55210444905976*^9, 3.552104469761512*^9}, {3.552104512676922*^9, 
   3.552104548013364*^9}, {3.552104624638319*^9, 3.5521046317368526`*^9}, {
   3.5521060943418818`*^9, 3.5521061025404263`*^9}, {3.5521065597852716`*^9, 
   3.552106564295773*^9}},
 CellLabel->"In[105]:=",
 $CellContext`InitializationGroup -> 
 True,ExpressionUUID->"4e161610-e724-4a08-8b1d-f7bf14f45e24"],

Cell[BoxData[
 TagBox[GridBox[{
    {
     PaneBox[
      StyleBox["\<\"Statement A\"\>", "Text",
       StripOnInput->False,
       FontSlant->Italic],
      BaseStyle->{
       LineIndent -> 0, LinebreakAdjustments -> {1, 1, 0, 0, 0}, 
        LineBreakWithin -> Automatic, Hyphenation -> True, TextAlignment -> 
        Left, "TR"},
      BaselinePosition->Bottom,
      ImageSizeAction->"ShrinkToFit"], 
     PaneBox[
      StyleBox["\<\"Payoff for the bet on the truth of A\"\>", "Text",
       StripOnInput->False,
       FontSlant->Italic],
      BaseStyle->{
       LineIndent -> 0, LinebreakAdjustments -> {1, 1, 0, 0, 0}, 
        LineBreakWithin -> Automatic, Hyphenation -> True, TextAlignment -> 
        Left, "TR"},
      BaselinePosition->Bottom,
      ImageSizeAction->"ShrinkToFit"], 
     PaneBox[
      StyleBox["\<\"Payoff for the bet against the truth of A\"\>", "Text",
       StripOnInput->False,
       FontSlant->Italic],
      BaseStyle->{
       LineIndent -> 0, LinebreakAdjustments -> {1, 1, 0, 0, 0}, 
        LineBreakWithin -> Automatic, Hyphenation -> True, TextAlignment -> 
        Left, "TR"},
      BaselinePosition->Bottom,
      ImageSizeAction->"ShrinkToFit"]},
    {
     PaneBox[
      StyleBox["\<\"A is false\"\>", "Text",
       StripOnInput->False],
      BaseStyle->{"TR"},
      BaselinePosition->Bottom,
      ImageSizeAction->"ShrinkToFit"], 
     PaneBox[
      StyleBox["\<\" -p\[CenterDot]n$ \
\\!\\(\\*StyleBox[\\\"(\\\",FontColor->RGBColor[1, 0, \
0]]\\)\\!\\(\\*StyleBox[\\\"always\\\",FontColor->RGBColor[1, 0, 0]]\\)\\!\\(\
\\*StyleBox[\\\" \\\",FontColor->RGBColor[1, 0, 0]]\\)\\!\\(\\*StyleBox[\\\"<\
\\\",FontColor->RGBColor[1, 0, 0]]\\)\\!\\(\\*StyleBox[\\\" \
\\\",FontColor->RGBColor[1, 0, \
0]]\\)\\!\\(\\*StyleBox[\\\"0\\\",FontColor->RGBColor[1, 0, \
0]]\\)\\!\\(\\*StyleBox[\\\")\\\",FontColor->RGBColor[1, 0, 0]]\\)\"\>", 
       "Text",
       StripOnInput->False],
      BaseStyle->{"TR"},
      BaselinePosition->Bottom,
      ImageSizeAction->"ShrinkToFit"], 
     PaneBox[
      StyleBox["\<\" p\[CenterDot]n$ (always > 0)\"\>", "Text",
       StripOnInput->False],
      BaseStyle->{"TR"},
      BaselinePosition->Bottom,
      ImageSizeAction->"ShrinkToFit"]}
   },
   AutoDelete->False,
   GridBoxAlignment->{"Columns" -> {Left, Center, {Center}}},
   GridBoxDividers->{"Columns" -> {
       RGBColor[0.2, 0.2, 0.2], {
        RGBColor[0.25, 0.25, 0.25]}, 
       RGBColor[0.2, 0.2, 0.2]}, "Rows" -> {
       RGBColor[0.2, 0.2, 0.2], 
       RGBColor[0.2, 0.2, 0.2], {
        RGBColor[0.75, 0.75, 0.75]}, 
       RGBColor[0.2, 0.2, 0.2]}},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{0.8}}}],
  "Grid"]], "Output",
 CellChangeTimes->{3.947576680559122*^9, 3.9518158122100763`*^9, 
  3.955769331552054*^9},
 CellLabel->"Out[105]=",
 $CellContext`InitializationGroup -> 
 True,ExpressionUUID->"de654a4a-c930-4b3b-9f40-1934f5572a0f"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["c2s1Table5", "Section",
 CellChangeTimes->{{3.5723420028690567`*^9, 3.572342011627058*^9}, {
   3.947391571097383*^9, 3.947391617058372*^9}, 3.9473923450883703`*^9, 
   3.947393236393119*^9, 3.947575060658597*^9, 3.94757625885634*^9, {
   3.947576305999908*^9, 3.9475763418928547`*^9}, 3.947576372325828*^9},
 $CellContext`InitializationGroup -> 
 True,ExpressionUUID->"f11e1757-113d-4235-821c-9248eb8506a3"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"SetOptions", "[", 
    RowBox[{"Pane", ",", 
     RowBox[{"ImageSizeAction", "\[Rule]", "\"\<ShrinkToFit\>\""}], ",", 
     RowBox[{"BaseStyle", " ", "->", " ", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"LineIndent", " ", "->", " ", "0"}], ",", " ", 
        RowBox[{"LinebreakAdjustments", " ", "->", " ", 
         RowBox[{"{", 
          RowBox[{
          "1", ",", " ", "1", ",", " ", "0", ",", " ", "0", ",", " ", "0"}], 
          "}"}]}], ",", " ", 
        RowBox[{"LineBreakWithin", " ", "->", " ", "Automatic"}], ",", " ", 
        RowBox[{"Hyphenation", " ", "->", " ", "True"}], ",", " ", 
        RowBox[{"TextAlignment", " ", "->", " ", "Left"}], 
        ",", "\"\<TR\>\""}], "}"}]}]}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"data5", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Pane", "[", 
        RowBox[{"Style", "[", 
         RowBox[{"\"\<\!\(\*StyleBox[\"Union\",FontWeight->\"Bold\"]\) \
(\!\(\*StyleBox[\"A\",FontSlant->\"Italic\"]\) \[Union] \
\!\(\*StyleBox[\"B\",FontSlant->\"Italic\"]\))\>\"", ",", "\"\<TR\>\"", ",", 
          "Bold"}], "]"}], "]"}], ",", 
       RowBox[{"Pane", "[", 
        RowBox[{"Style", "[", 
         RowBox[{"\"\<Set of all elements of \!\(\*StyleBox[\"A\", \
\"TI\",FontSlant->\"Italic\"]\) or \!\(\*StyleBox[\"B\", \"TI\"]\)\>\"", 
          ",", "\"\<TR\>\"", ",", "Italic"}], "]"}], "]"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Pane", "[", 
        RowBox[{"Style", "[", 
         RowBox[{"\"\<\!\(\*StyleBox[\"Intersection\",FontWeight->\"Bold\"]\) \
(\!\(\*StyleBox[\"A\", \"TI\"]\) \[Intersection] \!\(\*StyleBox[\"B\", \
\"TI\"]\))\>\"", ",", "\"\<TR\>\"", ",", "Bold"}], "]"}], "]"}], ",", 
       RowBox[{"Pane", "[", 
        RowBox[{"Style", "[", 
         RowBox[{"\"\<Set of all elements of \!\(\*StyleBox[\"A\", \"TI\"]\) \
and \!\(\*StyleBox[\"B\", \"TI\"]\). If \!\(\*StyleBox[\"A\", \"TI\"]\) \
\[Intersection] \!\(\*StyleBox[\"B\", \"TI\"]\)\!\(\*StyleBox[\" \", \
\"TI\"]\)= \[EmptySet] (empty set), the two sets are said to be disjoint or \
mutually exclusive.\>\"", ",", "\"\<TR\>\"", ",", "Italic", ",", " ", 
          RowBox[{"TextAlignment", " ", "->", " ", "Center"}]}], "]"}], 
        "]"}]}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Pane", "[", 
        RowBox[{"Style", "[", 
         RowBox[{"\"\<\!\(\*StyleBox[\"Difference\",FontWeight->\"Bold\"]\) (\
\!\(\*StyleBox[\"A\", \"TI\"]\) \\\\ \!\(\*StyleBox[\"B\", \"TI\"]\))\>\"", 
          ",", "\"\<TR\>\"", ",", "Bold"}], "]"}], "]"}], ",", 
       RowBox[{"Pane", "[", 
        RowBox[{"Style", "[", 
         RowBox[{"\"\<Set of all elements of \!\(\*StyleBox[\"A\", \"TI\"]\) \
which are not in \!\(\*StyleBox[\"B\", \"TI\"]\)\>\"", ",", "\"\<TR\>\"", ",",
           "Italic"}], "]"}], "]"}]}], "}"}]}], "}"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.5521026014655943`*^9, 3.552102635822619*^9}, {
   3.552102697058507*^9, 3.552102716541814*^9}, {3.5521027575340023`*^9, 
   3.552102834490437*^9}, {3.552102930967421*^9, 3.552103016046608*^9}, {
   3.552103053928179*^9, 3.552103076113628*^9}, 3.552103370609177*^9, {
   3.552103414717738*^9, 3.552103415932863*^9}, {3.55210350254058*^9, 
   3.552103524828726*^9}, 3.552103560364336*^9, {3.552103591006752*^9, 
   3.552103610543189*^9}, {3.5521036960756397`*^9, 3.552103696506854*^9}, {
   3.552103733992571*^9, 3.552103739207076*^9}, {3.552103787702858*^9, 
   3.552103789126577*^9}, {3.552103879548175*^9, 3.5521040126709642`*^9}, {
   3.552104052071844*^9, 3.5521040530385237`*^9}, {3.552104156608767*^9, 
   3.55210415660883*^9}, 3.552104200775548*^9, {3.5521042390852537`*^9, 
   3.5521042493497963`*^9}, {3.5521043177224207`*^9, 3.552104356637162*^9}, {
   3.552104955566662*^9, 3.55210495626079*^9}, {3.552105000304809*^9, 
   3.552105272663146*^9}, {3.552105364271854*^9, 3.55210539775602*^9}, 
   3.5521064709349613`*^9, 3.552110092310583*^9, {3.552110243966226*^9, 
   3.552110379185286*^9}, {3.552110414253248*^9, 3.552110498206272*^9}, {
   3.552110544801558*^9, 3.5521105927947607`*^9}, {3.5521106875790577`*^9, 
   3.552110722662979*^9}, 3.947001873893052*^9},
 CellLabel->"In[106]:=",
 $CellContext`InitializationGroup -> 
 True,ExpressionUUID->"b6e0c269-b9d1-416f-b382-376a8b2e74b1"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"c2s1Table5", "=", 
  RowBox[{"Grid", "[", 
   RowBox[{"data5", ",", 
    RowBox[{"Dividers", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Darker", "[", 
          RowBox[{"Gray", ",", ".6"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"Darker", "[", 
           RowBox[{"Gray", ",", ".5"}], "]"}], "}"}], ",", 
         RowBox[{"Darker", "[", 
          RowBox[{"Gray", ",", ".6"}], "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Darker", "[", 
          RowBox[{"Gray", ",", ".6"}], "]"}], ",", 
         RowBox[{"Lighter", "[", 
          RowBox[{"Gray", ",", ".6"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"Lighter", "[", 
           RowBox[{"Gray", ",", ".5"}], "]"}], "}"}], ",", 
         RowBox[{"Darker", "[", 
          RowBox[{"Gray", ",", ".6"}], "]"}]}], "}"}]}], "}"}]}], ",", 
    RowBox[{"Spacings", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"Automatic", ",", ".8"}], "}"}]}], ",", 
    RowBox[{"Alignment", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"Left", ",", "Center", ",", 
        RowBox[{"{", "Center", "}"}]}], "}"}], "}"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.552103386035222*^9, 3.5521033974669657`*^9}, 
   3.552104364482621*^9, {3.552104402128168*^9, 3.552104415560268*^9}, {
   3.55210444905976*^9, 3.552104469761512*^9}, {3.552104512676922*^9, 
   3.552104548013364*^9}, {3.552104624638319*^9, 3.5521046317368526`*^9}, {
   3.5521053027244463`*^9, 3.552105341477475*^9}, {3.552105426778727*^9, 
   3.5521054577949867`*^9}, 3.552106473443452*^9, {3.552110094582501*^9, 
   3.5521100962012043`*^9}},
 CellLabel->"In[108]:=",
 $CellContext`InitializationGroup -> 
 True,ExpressionUUID->"48263d1d-ee13-4cae-a61e-58900ad47479"],

Cell[BoxData[
 TagBox[GridBox[{
    {
     PaneBox[
      StyleBox["\<\"\\!\\(\\*StyleBox[\\\"Union\\\",FontWeight->\\\"Bold\\\"]\
\\) (\\!\\(\\*StyleBox[\\\"A\\\",FontSlant->\\\"Italic\\\"]\\) \[Union] \
\\!\\(\\*StyleBox[\\\"B\\\",FontSlant->\\\"Italic\\\"]\\))\"\>", "TR",
       StripOnInput->False,
       FontWeight->Bold]], 
     PaneBox[
      StyleBox["\<\"Set of all elements of \\!\\(\\*StyleBox[\\\"A\\\", \
\\\"TI\\\",FontSlant->\\\"Italic\\\"]\\) or \\!\\(\\*StyleBox[\\\"B\\\", \
\\\"TI\\\"]\\)\"\>", "TR",
       StripOnInput->False,
       FontSlant->Italic]]},
    {
     PaneBox[
      StyleBox["\<\"\\!\\(\\*StyleBox[\\\"Intersection\\\",FontWeight->\\\"\
Bold\\\"]\\) (\\!\\(\\*StyleBox[\\\"A\\\", \\\"TI\\\"]\\) \[Intersection] \\!\
\\(\\*StyleBox[\\\"B\\\", \\\"TI\\\"]\\))\"\>", "TR",
       StripOnInput->False,
       FontWeight->Bold]], 
     PaneBox[
      StyleBox["\<\"Set of all elements of \\!\\(\\*StyleBox[\\\"A\\\", \
\\\"TI\\\"]\\) and \\!\\(\\*StyleBox[\\\"B\\\", \\\"TI\\\"]\\). If \
\\!\\(\\*StyleBox[\\\"A\\\", \\\"TI\\\"]\\) \[Intersection] \
\\!\\(\\*StyleBox[\\\"B\\\", \\\"TI\\\"]\\)\\!\\(\\*StyleBox[\\\" \\\", \
\\\"TI\\\"]\\)= \[EmptySet] (empty set), the two sets are said to be disjoint \
or mutually exclusive.\"\>", "TR",
       StripOnInput->False,
       TextAlignment->Center,
       FontSlant->Italic]]},
    {
     PaneBox[
      StyleBox["\<\"\\!\\(\\*StyleBox[\\\"Difference\\\",FontWeight->\\\"Bold\
\\\"]\\) (\\!\\(\\*StyleBox[\\\"A\\\", \\\"TI\\\"]\\) \\\\ \\!\\(\\*StyleBox[\
\\\"B\\\", \\\"TI\\\"]\\))\"\>", "TR",
       StripOnInput->False,
       FontWeight->Bold]], 
     PaneBox[
      StyleBox["\<\"Set of all elements of \\!\\(\\*StyleBox[\\\"A\\\", \
\\\"TI\\\"]\\) which are not in \\!\\(\\*StyleBox[\\\"B\\\", \\\"TI\\\"]\\)\"\
\>", "TR",
       StripOnInput->False,
       FontSlant->Italic]]}
   },
   AutoDelete->False,
   GridBoxAlignment->{"Columns" -> {Left, Center, {Center}}},
   GridBoxDividers->{"Columns" -> {
       RGBColor[0.2, 0.2, 0.2], {
        RGBColor[0.25, 0.25, 0.25]}, 
       RGBColor[0.2, 0.2, 0.2]}, "Rows" -> {
       RGBColor[0.2, 0.2, 0.2], 
       RGBColor[0.8, 0.8, 0.8], {
        RGBColor[0.75, 0.75, 0.75]}, 
       RGBColor[0.2, 0.2, 0.2]}},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{0.8}}}],
  "Grid"]], "Output",
 CellChangeTimes->{3.947576680571546*^9, 3.951815818365497*^9, 
  3.955769331571484*^9},
 CellLabel->"Out[108]=",
 $CellContext`InitializationGroup -> 
 True,ExpressionUUID->"2c4e1eb5-3d99-4a83-b642-5c8449622b82"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["c2s1Figure2", "Section",
 CellChangeTimes->{{3.5723420028690567`*^9, 3.572342011627058*^9}, {
   3.947391571097383*^9, 3.947391617058372*^9}, 3.9473923450883703`*^9, 
   3.947393236393119*^9, 3.947575060658597*^9, 3.94757625885634*^9, {
   3.947576305999908*^9, 3.9475763418928547`*^9}, 3.947576372325828*^9, 
   3.947576440530884*^9, {3.947576492156948*^9, 3.947576493252994*^9}},
 $CellContext`InitializationGroup -> 
 True,ExpressionUUID->"c4b665dc-0c39-4994-9c3a-a4d9691bc55f"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"dice", " ", "=", 
    GraphicsBox[
     TagBox[RasterBox[CompressedData["
1:eJzsfQeUFUX2vrur5KSgoAICIqIoIgZMKCsGWERQgqAiShIFBSQjQ8455wxD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       "], {{0, 458.}, {460., 0}}, {0, 255},
       ColorFunction->RGBColor],
      BoxForm`ImageTag["Byte", ColorSpace -> ColorProfileData[CompressedData["

1:eJyVlwdUU9kWhs+96SGhJUQ6oTdBOgGkhNACKEgHGyEJIRBCSAFB7AyO4FhQ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         "], "RGB", "XYZ"], Interleaving -> True, 
       MetaInformation -> <|
        "Exif" -> <|
          "XResolution" -> 144, "YResolution" -> 144, "ResolutionUnit" -> 
           "Inch", "ExifTag" -> 78, "UserComment" -> "ASCIIScreenshot", 
           "PixelXDimension" -> 460, "PixelYDimension" -> 458|>|>],
      Selectable->False],
     DefaultBaseStyle->"ImageGraphics",
     ImageSize->{43.268229166662664`, Automatic},
     ImageSizeRaw->{460., 458.},
     PlotRange->{{0, 460.}, {0, 458.}}]}], ";"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{"free", " ", "image", " ", "from", " ", "the", " ", "web"}], " ", 
   "*)"}]}]], "Input",
 CellChangeTimes->{{3.946984540005321*^9, 3.946984546789527*^9}, {
  3.946985400819227*^9, 3.9469854112277107`*^9}, {3.946985848280445*^9, 
  3.946985848787325*^9}, {3.9469872821645117`*^9, 3.946987282866935*^9}, {
  3.947576464306458*^9, 3.947576483998459*^9}},
 CellLabel->"In[109]:=",
 $CellContext`InitializationGroup -> 
 True,ExpressionUUID->"1f738c6f-d5a0-4334-9939-b0faa6c68278"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"c2s1Figure2", "=", 
  RowBox[{"Show", "[", 
   RowBox[{
    RowBox[{"TreeGraph", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"1", "\[UndirectedEdge]", "2"}], ",", 
        RowBox[{"2", "\[UndirectedEdge]", "3"}], ",", 
        RowBox[{"1", "\[UndirectedEdge]", "4"}], ",", 
        RowBox[{"1", "\[UndirectedEdge]", "5"}]}], "}"}], ",", 
      RowBox[{"EdgeLabels", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"1", "\[UndirectedEdge]", "2"}], "\[Rule]", 
          RowBox[{"Framed", "[", 
           RowBox[{"\"\<Fabian\\nwins round\>\"", ",", 
            RowBox[{"Background", "\[Rule]", "LightGray"}]}], "]"}]}], ",", 
         RowBox[{
          RowBox[{"2", "\[UndirectedEdge]", "3"}], "\[Rule]", 
          RowBox[{"Framed", "[", 
           RowBox[{"\"\<Fabrice\\nwins round\>\"", ",", 
            RowBox[{"Background", "\[Rule]", "LightGray"}]}], "]"}]}], ",", 
         RowBox[{
          RowBox[{"1", "\[UndirectedEdge]", "4"}], "\[Rule]", 
          RowBox[{"Framed", "[", 
           RowBox[{"\"\<Fabian\\nwins round\>\"", ",", 
            RowBox[{"Background", "\[Rule]", "LightGray"}]}], "]"}]}], ",", 
         RowBox[{
          RowBox[{"1", "\[UndirectedEdge]", "5"}], "\[Rule]", 
          RowBox[{"Framed", "[", 
           RowBox[{"\"\<Fabrice\\nwins round\>\"", ",", 
            RowBox[{"Background", "\[Rule]", "LightGray"}]}], "]"}]}]}], " ", 
        "}"}]}], ",", 
      RowBox[{"VertexLabels", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"1", "\[Rule]", 
          RowBox[{"Placed", "[", 
           RowBox[{
            GraphicsBox[
             TagBox[RasterBox[CompressedData["
1:eJzsfQeUFUX2vrur5KSgoAICIqIoIgZMKCsGWERQgqAiShIFBSQjQ8455wxD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               "], {{0, 458.}, {460., 0}}, {0, 255},
               ColorFunction->RGBColor],
              BoxForm`ImageTag[
              "Byte", ColorSpace -> ColorProfileData[CompressedData["
1:eJyVlwdUU9kWhs+96SGhJUQ6oTdBOgGkhNACKEgHGyEJIRBCSAFB7AyO4FhQ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                 "], "RGB", "XYZ"], Interleaving -> True, 
               MetaInformation -> <|
                "Exif" -> <|
                  "XResolution" -> 144, "YResolution" -> 144, 
                   "ResolutionUnit" -> "Inch", "ExifTag" -> 78, "UserComment" -> 
                   "ASCIIScreenshot", "PixelXDimension" -> 460, 
                   "PixelYDimension" -> 458|>|>],
              Selectable->False],
             DefaultBaseStyle->"ImageGraphics",
             ImageSize->{31.37499999999608, Automatic},
             ImageSizeRaw->{460., 458.},
             PlotRange->{{0, 460.}, {0, 458.}}], ",", "Center"}], "]"}]}], ",", 
         RowBox[{"2", "\[Rule]", 
          RowBox[{"Placed", "[", 
           RowBox[{
            GraphicsBox[
             TagBox[RasterBox[CompressedData["
1:eJzsfQeUFUX2vrur5KSgoAICIqIoIgZMKCsGWERQgqAiShIFBSQjQ8455wxD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               "], {{0, 458.}, {460., 0}}, {0, 255},
               ColorFunction->RGBColor],
              BoxForm`ImageTag[
              "Byte", ColorSpace -> ColorProfileData[CompressedData["
1:eJyVlwdUU9kWhs+96SGhJUQ6oTdBOgGkhNACKEgHGyEJIRBCSAFB7AyO4FhQ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                 "], "RGB", "XYZ"], Interleaving -> True, 
               MetaInformation -> <|
                "Exif" -> <|
                  "XResolution" -> 144, "YResolution" -> 144, 
                   "ResolutionUnit" -> "Inch", "ExifTag" -> 78, "UserComment" -> 
                   "ASCIIScreenshot", "PixelXDimension" -> 460, 
                   "PixelYDimension" -> 458|>|>],
              Selectable->False],
             DefaultBaseStyle->"ImageGraphics",
             ImageSize->{31.37499999999608, Automatic},
             ImageSizeRaw->{460., 458.},
             PlotRange->{{0, 460.}, {0, 458.}}], ",", "Center"}], "]"}]}], ",", 
         RowBox[{"3", "\[Rule]", 
          RowBox[{"Placed", "[", 
           RowBox[{
            RowBox[{"Framed", "[", 
             RowBox[{"\"\<Fabrice\\nwins game\>\"", ",", 
              RowBox[{"Background", "\[Rule]", "LightRed"}], ",", 
              RowBox[{"RoundingRadius", "\[Rule]", "10"}]}], "]"}], ",", 
            "Center"}], "]"}]}], ",", 
         RowBox[{"4", "\[Rule]", 
          RowBox[{"Placed", "[", 
           RowBox[{
            RowBox[{"Framed", "[", 
             RowBox[{"\"\<Fabian\\nwins game\>\"", ",", 
              RowBox[{"Background", "\[Rule]", "LightGreen"}], ",", 
              RowBox[{"RoundingRadius", "\[Rule]", "10"}]}], "]"}], ",", 
            "Center"}], "]"}]}], ",", 
         RowBox[{"5", "\[Rule]", 
          RowBox[{"Placed", "[", 
           RowBox[{
            RowBox[{"Framed", "[", 
             RowBox[{"\"\<Fabrice\\nwins game\>\"", ",", 
              RowBox[{"Background", "\[Rule]", "LightRed"}], ",", 
              RowBox[{"RoundingRadius", "\[Rule]", "10"}]}], "]"}], ",", 
            "Center"}], "]"}]}]}], "}"}]}]}], "]"}], ",", 
    RowBox[{"ImageSize", "->", " ", "250"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.946986177809579*^9, 3.946986194957024*^9}, {
   3.946986248583611*^9, 3.946986263165331*^9}, 3.946986297547101*^9, {
   3.946986332928388*^9, 3.946986349558762*^9}, {3.946986413265324*^9, 
   3.946986514600255*^9}, {3.946986634980537*^9, 3.9469866936228237`*^9}, {
   3.946986735127836*^9, 3.946986870674926*^9}, {3.946986923065173*^9, 
   3.9469870635785093`*^9}, {3.946987141880189*^9, 3.946987212830246*^9}, {
   3.946987252022006*^9, 3.946987267165893*^9}, 3.946987324096249*^9, {
   3.946987399283025*^9, 3.9469874795362873`*^9}, 3.9470026691965637`*^9, {
   3.947041418315742*^9, 3.947041456888193*^9}, {3.947576451918129*^9, 
   3.947576453039029*^9}},
 CellLabel->"In[110]:=",
 $CellContext`InitializationGroup -> 
 True,ExpressionUUID->"f0bb16b2-4ff6-446e-9b56-c369c008ef9c"],

Cell[BoxData[
 GraphicsBox[{
   {Hue[0.6, 0.7, 0.7], Opacity[0.7], CapForm["Round"], {
     {Arrowheads[0.], 
      ArrowBox[{{0.4472135954999579, 0.8944271909999159}, {0.8944271909999159,
        1.7888543819998317`}}, 0.020874891668923312`]}, InsetBox[
      FrameBox["\<\"Fabian\\nwins round\"\>",
       Background->GrayLevel[0.85],
       StripOnInput->False], {0.6708203932499369, 1.3416407864998738}, 
      ImageScaled[{0.5, 0.5}],
      BaseStyle->"Graphics"]}, {
     {Arrowheads[0.], 
      ArrowBox[{{0.4472135954999579, 0.8944271909999159}, {0., 0.}}, 
       0.020874891668923312`]}, InsetBox[
      FrameBox["\<\"Fabian\\nwins round\"\>",
       Background->GrayLevel[0.85],
       StripOnInput->False], {0.22360679774997896, 0.4472135954999579}, 
      ImageScaled[{0.5, 0.5}],
      BaseStyle->"Graphics"]}, {
     {Arrowheads[0.], 
      ArrowBox[{{0.4472135954999579, 0.8944271909999159}, {0.8944271909999159,
        0.}}, 0.020874891668923312`]}, InsetBox[
      FrameBox["\<\"Fabrice\\nwins round\"\>",
       Background->GrayLevel[0.85],
       StripOnInput->False], {0.6708203932499369, 0.4472135954999579}, 
      ImageScaled[{0.5, 0.5}],
      BaseStyle->"Graphics"]}, {
     {Arrowheads[0.], 
      ArrowBox[{{0.8944271909999159, 1.7888543819998317`}, {
       1.3416407864998738`, 0.8944271909999159}}, 0.020874891668923312`]}, 
     InsetBox[
      FrameBox["\<\"Fabrice\\nwins round\"\>",
       Background->GrayLevel[0.85],
       StripOnInput->False], {1.118033988749895, 1.3416407864998738}, 
      ImageScaled[{0.5, 0.5}],
      BaseStyle->"Graphics"]}}, 
   {Hue[0.6, 0.5, 1.], EdgeForm[{GrayLevel[0], Opacity[
    0.7]}], {DiskBox[{0.4472135954999579, 0.8944271909999159}, 
      0.020874891668923312], InsetBox[
      FormBox[
       GraphicsBox[
        TagBox[RasterBox[CompressedData["
1:eJzsfQeUFUX2vrur5KSgoAICIqIoIgZMKCsGWERQgqAiShIFBSQjQ8455wxD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          "], {{0, 458.}, {460., 0}}, {0, 255},
          ColorFunction->RGBColor],
         BoxForm`ImageTag[
         "Byte", ColorSpace -> ColorProfileData[CompressedData["
1:eJyVlwdUU9kWhs+96SGhJUQ6oTdBOgGkhNACKEgHGyEJIRBCSAFB7AyO4FhQ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            "], "RGB", "XYZ"], Interleaving -> True, 
          MetaInformation -> <|
           "Exif" -> <|
             "XResolution" -> 144, "YResolution" -> 144, "ResolutionUnit" -> 
              "Inch", "ExifTag" -> 78, "UserComment" -> "ASCIIScreenshot", 
              "PixelXDimension" -> 460, "PixelYDimension" -> 458|>|>],
         Selectable->False],
        DefaultBaseStyle->"ImageGraphics",
        ImageSize->{31.37499999999608, Automatic},
        ImageSizeRaw->{460., 458.},
        PlotRange->{{0, 460.}, {0, 458.}}],
       TraditionalForm], {0.4472135954999579, 0.8944271909999159},
      BaseStyle->"Graphics"]}, {
     DiskBox[{0.8944271909999159, 1.7888543819998317`}, 0.020874891668923312],
      InsetBox[
      FormBox[
       GraphicsBox[
        TagBox[RasterBox[CompressedData["
1:eJzsfQeUFUX2vrur5KSgoAICIqIoIgZMKCsGWERQgqAiShIFBSQjQ8455wxD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          "], {{0, 458.}, {460., 0}}, {0, 255},
          ColorFunction->RGBColor],
         BoxForm`ImageTag[
         "Byte", ColorSpace -> ColorProfileData[CompressedData["
1:eJyVlwdUU9kWhs+96SGhJUQ6oTdBOgGkhNACKEgHGyEJIRBCSAFB7AyO4FhQ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            "], "RGB", "XYZ"], Interleaving -> True, 
          MetaInformation -> <|
           "Exif" -> <|
             "XResolution" -> 144, "YResolution" -> 144, "ResolutionUnit" -> 
              "Inch", "ExifTag" -> 78, "UserComment" -> "ASCIIScreenshot", 
              "PixelXDimension" -> 460, "PixelYDimension" -> 458|>|>],
         Selectable->False],
        DefaultBaseStyle->"ImageGraphics",
        ImageSize->{31.37499999999608, Automatic},
        ImageSizeRaw->{460., 458.},
        PlotRange->{{0, 460.}, {0, 458.}}],
       TraditionalForm], {0.8944271909999159, 1.7888543819998317},
      BaseStyle->"Graphics"]}, {
     DiskBox[{1.3416407864998738`, 0.8944271909999159}, 0.020874891668923312],
      InsetBox[
      FrameBox["\<\"Fabrice\\nwins game\"\>",
       Background->RGBColor[1, 0.85, 0.85],
       RoundingRadius->10,
       StripOnInput->False], {1.3416407864998738, 0.8944271909999159},
      BaseStyle->"Graphics"]}, {DiskBox[{0., 0.}, 0.020874891668923312], 
     InsetBox[
      FrameBox["\<\"Fabian\\nwins game\"\>",
       Background->RGBColor[0.88, 1, 0.88],
       RoundingRadius->10,
       StripOnInput->False], {0., 0.},
      BaseStyle->"Graphics"]}, {
     DiskBox[{0.8944271909999159, 0.}, 0.020874891668923312], InsetBox[
      FrameBox["\<\"Fabrice\\nwins game\"\>",
       Background->RGBColor[1, 0.85, 0.85],
       RoundingRadius->10,
       StripOnInput->False], {0.8944271909999159, 0.},
      BaseStyle->"Graphics"]}}},
  FormatType->TraditionalForm,
  FrameTicks->None,
  ImageSize->250]], "Output",
 CellChangeTimes->{3.94757668059798*^9, 3.951815823957758*^9, 
  3.955769331599638*^9},
 CellLabel->"Out[110]=",
 $CellContext`InitializationGroup -> 
 True,ExpressionUUID->"caeb811c-12bc-495f-83ae-0ccac6d104e4"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["c2s1Figure3", "Section",
 CellChangeTimes->{{3.5723420028690567`*^9, 3.572342011627058*^9}, {
   3.947391571097383*^9, 3.947391617058372*^9}, 3.9473923450883703`*^9, 
   3.947393236393119*^9, 3.947575060658597*^9, 3.94757625885634*^9, {
   3.947576305999908*^9, 3.9475763418928547`*^9}, 3.947576372325828*^9, 
   3.947576440530884*^9, {3.947576492156948*^9, 3.947576493252994*^9}, 
   3.9475765978329144`*^9},
 $CellContext`InitializationGroup -> 
 True,ExpressionUUID->"f3ddc1d4-c4aa-4196-a367-e1943f8d5d94"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"mnames", "=", 
   RowBox[{"{", "\"\<\>\"", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"colorlist", "=", 
   RowBox[{"{", 
    RowBox[{"ColorData", "[", 
     RowBox[{"\"\<HTML\>\"", ",", "\"\<Red\>\""}], "]"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"imgSize", "=", "250"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"UrnFrame", "[", 
   RowBox[{"nx_", ",", "ny_"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "dtop", ",", "dopen", ",", "margin", ",", "lmo", ",", "rmo", ",", 
      "ptlist", ",", "box"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"dtop", "=", " ", "2."}], ";", "\[IndentingNewLine]", 
     RowBox[{"dopen", " ", "=", " ", "3."}], ";", "\[IndentingNewLine]", 
     RowBox[{"margin", "=", " ", "0.6"}], ";", 
     RowBox[{"(*", " ", 
      RowBox[{
      "calculated", " ", "from", " ", "the", " ", "central", " ", "position", 
       " ", "of", " ", "the", " ", "disk"}], " ", "*)"}], 
     "\[IndentingNewLine]", 
     RowBox[{"lmo", "=", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"nx", "+", "1"}], ")"}], "/", "2"}], " ", "-", " ", 
       RowBox[{"dopen", "/", "2"}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"rmo", "=", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"nx", "+", "1"}], ")"}], "/", "2"}], " ", "+", " ", 
       RowBox[{"dopen", "/", "2"}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"ptlist", "=", 
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"lmo", ",", 
          RowBox[{"ny", "+", "margin", "+", "dtop"}]}], "}"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{"lmo", ",", 
          RowBox[{"ny", "+", "margin"}]}], "}"}], ",", "\[IndentingNewLine]", 
        
        RowBox[{"{", 
         RowBox[{
          RowBox[{"1", "-", "margin"}], ",", 
          RowBox[{"ny", "+", "margin"}]}], "}"}], ",", "\[IndentingNewLine]", 
        
        RowBox[{"{", 
         RowBox[{
          RowBox[{"1", "-", "margin"}], ",", 
          RowBox[{"1", "-", "margin"}]}], "}"}], ",", "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"nx", "+", "margin"}], ",", 
          RowBox[{"1", "-", "margin"}]}], "}"}], ",", "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"nx", "+", "margin"}], ",", 
          RowBox[{"ny", "+", "margin"}]}], "}"}], ",", "\[IndentingNewLine]", 
        
        RowBox[{"{", 
         RowBox[{"rmo", ",", 
          RowBox[{"ny", "+", "margin"}]}], "}"}], ",", "\[IndentingNewLine]", 
        
        RowBox[{"{", 
         RowBox[{"rmo", ",", 
          RowBox[{"ny", "+", "margin", "+", "dtop"}]}], "}"}]}], 
       "\[IndentingNewLine]", "}"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"box", "=", 
      RowBox[{"Graphics", " ", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"AbsoluteThickness", "[", "4", "]"}], ",", 
         RowBox[{"Line", " ", "/@", " ", 
          RowBox[{"Partition", "[", 
           RowBox[{"ptlist", ",", "2", ",", "1"}], "]"}]}]}], " ", "}"}], 
       "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"Show", "[", 
      RowBox[{"box", ",", 
       RowBox[{"ImageSize", "\[Rule]", " ", "imgSize"}]}], "]"}]}]}], 
   "\[IndentingNewLine]", "]"}]}], "\n", 
 RowBox[{
  RowBox[{"DiskCoordinates", "[", 
   RowBox[{"nx_", ",", "ny_"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"ntot", ",", "coords", ",", "size", ",", "sizelist"}], "}"}], ",",
     "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"size", " ", "=", " ", ".95"}], ";", "\[IndentingNewLine]", 
     RowBox[{"ntot", "=", " ", 
      RowBox[{"nx", " ", "ny"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"coords", "=", 
      RowBox[{"Partition", "[", 
       RowBox[{
        RowBox[{"Flatten", "[", " ", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"i", ",", "j"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"j", ",", "ny"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"i", ",", "nx"}], "}"}]}], "]"}], "]"}], ",", "2"}], 
       "]"}]}], ";", " ", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{
      "from", " ", "lower", " ", "left", " ", "to", " ", "upper", " ", 
       "right"}], " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"sizelist", "=", " ", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"size", "/", "2"}], ",", 
        RowBox[{"{", "ntot", "}"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"coords", ",", "sizelist"}], "}"}]}]}], "\[IndentingNewLine]", 
   "]"}]}], "\n", 
 RowBox[{
  RowBox[{"BallsInUrn", "[", 
   RowBox[{"balltext_", ",", "ballcol_", ",", "textcol_", ",", "textsize_", ",", 
    RowBox[{"{", 
     RowBox[{"coords1_", ",", "sizelist1_"}], "}"}]}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"disks1", ",", "colors1", ",", "texts1", ",", "coloreddisks1"}], 
     "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"disks1", "=", " ", 
      RowBox[{"MapThread", "[", 
       RowBox[{"Disk", ",", 
        RowBox[{"{", 
         RowBox[{"coords1", ",", "sizelist1"}], "}"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"colors1", "=", 
      RowBox[{"Table", "[", 
       RowBox[{"ballcol", ",", 
        RowBox[{"{", 
         RowBox[{"Length", "[", "coords1", "]"}], "}"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"texts1", "=", 
      RowBox[{"Map", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Graphics", "[", 
          RowBox[{"Text", "[", 
           RowBox[{
            RowBox[{"Style", "[", 
             RowBox[{
             "balltext", ",", "textsize", ",", "Bold", ",", "textcol"}], 
             "]"}], ",", "#"}], "]"}], "]"}], "&"}], ",", "coords1"}], 
       "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"coloreddisks1", "=", 
      RowBox[{"MapThread", "[", " ", 
       RowBox[{
        RowBox[{
         RowBox[{"Graphics", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"EdgeForm", "[", "Black", "]"}], ",", "#1", ",", "#2"}], 
           "}"}], "]"}], "&"}], ",", 
        RowBox[{"{", 
         RowBox[{"colors1", ",", "disks1"}], "}"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Transpose", "[", 
      RowBox[{"{", 
       RowBox[{"coloreddisks1", ",", "texts1"}], "}"}], "]"}]}]}], 
   "\[IndentingNewLine]", "]"}]}], "\n", 
 RowBox[{
  RowBox[{"FractionOfBalls", "[", 
   RowBox[{"frac_", ",", "sel_", ",", "ntot_"}], "]"}], ":=", 
  RowBox[{"RandomSample", "[", 
   RowBox[{
    RowBox[{"alldisks", "[", 
     RowBox[{"[", "sel", "]"}], "]"}], ",", 
    RowBox[{"Round", "[", 
     RowBox[{"ntot", " ", "frac"}], "]"}]}], "]"}]}], "\n", 
 RowBox[{
  RowBox[{"Urn1", "[", 
   RowBox[{"p_", ",", "mod_"}], "]"}], ":=", 
  RowBox[{"Show", "[", 
   RowBox[{"frame", ",", "restdisks", ",", 
    RowBox[{"FractionOfBalls", "[", 
     RowBox[{"p", ",", "mod", ",", "ntot"}], "]"}]}], "]"}]}], "\n", 
 RowBox[{
  RowBox[{"nx", "=", "10"}], ";", 
  RowBox[{"ny", "=", "10"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ntot", "=", 
   RowBox[{"nx", " ", "ny"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"frame", "=", 
   RowBox[{"UrnFrame", "[", 
    RowBox[{"nx", ",", "ny"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"coas", "=", 
   RowBox[{"DiskCoordinates", "[", 
    RowBox[{"nx", ",", "ny"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"restdisks", "=", 
   RowBox[{"BallsInUrn", "[", 
    RowBox[{"\"\< \>\"", ",", " ", "Black", ",", "LightGray", ",", "12", ",", 
     "coas"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"bgdisks", "=", 
   RowBox[{"BallsInUrn", "[", 
    RowBox[{"\"\<+\>\"", ",", " ", "LightGray", ",", "LightGreen", ",", "12", 
     ",", "coas"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"alldisks", "=", 
    RowBox[{"MapThread", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"BallsInUrn", "[", 
        RowBox[{
        "#1", ",", " ", "#2", ",", "LightGray", ",", "12", ",", "coas"}], 
        "]"}], "&"}], " ", ",", 
      RowBox[{"{", 
       RowBox[{"mnames", ",", "colorlist"}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"p", "=", ".01"}], ";", 
  RowBox[{"c2s1Figure3", " ", "=", 
   RowBox[{"Manipulate", "[", 
    RowBox[{
     RowBox[{"Urn1", "[", 
      RowBox[{"p", ",", "1"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"p", ",", ".1", ",", "\"\<fraction of red balls\>\""}], "}"}],
        ",", "0", ",", "1", ",", ".0001", ",", 
       RowBox[{"Appearance", "->", "\"\<Labeled\>\""}]}], "}"}], ",", 
     RowBox[{"SaveDefinitions", "->", "True"}], ",", 
     RowBox[{"TrackedSymbols", ":>", 
      RowBox[{"{", "p", "}"}]}]}], "]"}]}]}]}], "Input",
 CellChangeTimes->{{3.9469762140190268`*^9, 3.9469762260498953`*^9}, {
   3.946976269129236*^9, 3.9469763501514273`*^9}, {3.94697641195732*^9, 
   3.946976416394808*^9}, {3.946976487126225*^9, 3.9469765391996603`*^9}, {
   3.946976658912937*^9, 3.946976829185161*^9}, {3.9469816307232857`*^9, 
   3.946981817944262*^9}, {3.9469818739412394`*^9, 3.9469818854500303`*^9}, {
   3.946981977494583*^9, 3.9469820172079887`*^9}, {3.9469821242274446`*^9, 
   3.946982129732952*^9}, {3.9469821988532953`*^9, 3.9469822702648907`*^9}, {
   3.946982330986024*^9, 3.946982331738019*^9}, {3.946982382709482*^9, 
   3.9469826037139473`*^9}, {3.946983425904619*^9, 3.946983545935223*^9}, {
   3.947005784288171*^9, 3.9470058276488132`*^9}, 3.947041490320643*^9, {
   3.947576540285738*^9, 3.9475765434010763`*^9}, 3.947576603991249*^9, {
   3.951815896061941*^9, 3.951815909243021*^9}},
 CellLabel->"In[111]:=",
 $CellContext`InitializationGroup -> 
 True,ExpressionUUID->"a92f1f99-2123-4af0-ad13-9649dcdfd594"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`p$$ = 0.01, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`p$$], 0.1, "fraction of red balls"}, 0, 1, 0.0001, 
      ControlType -> Manipulator}}, Typeset`size$$ = {
    250., {145.37012732077204`, 151.10206091452204`}}, Typeset`update$$ = 0, 
    Typeset`initDone$$, Typeset`skipInitDone$$ = False, 
    Typeset`keyframeActionsQ$$ = False, Typeset`keyframeList$$ = {}}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`p$$ = 0.1}, 
      "ControllerVariables" :> {}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$, Typeset`keyframeActionsQ$$, 
        Typeset`keyframeList$$}, 
      "Body" :> $CellContext`Urn1[$CellContext`p$$, 1], 
      "Specifications" :> {{{$CellContext`p$$, 0.1, "fraction of red balls"}, 
         0, 1, 0.0001, Appearance -> "Labeled"}}, 
      "Options" :> {TrackedSymbols :> {$CellContext`p$$}}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{367.67064453125, {193.0405527358111, 198.7724863295611}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    Initialization:>({$CellContext`Urn1[
         Pattern[$CellContext`p, 
          Blank[]], 
         Pattern[$CellContext`mod, 
          Blank[]]] := Show[$CellContext`frame, $CellContext`restdisks, 
         $CellContext`FractionOfBalls[$CellContext`p, $CellContext`mod, \
$CellContext`ntot]], $CellContext`p$$ = 0.01, $CellContext`frame = Graphics[{
          AbsoluteThickness[4], {
           Line[{{4., 12.6}, {4., 10.6}}], 
           Line[{{4., 10.6}, {0.4, 10.6}}], 
           Line[{{0.4, 10.6}, {0.4, 0.4}}], 
           Line[{{0.4, 0.4}, {10.6, 0.4}}], 
           Line[{{10.6, 0.4}, {10.6, 10.6}}], 
           Line[{{10.6, 10.6}, {7., 10.6}}], 
           Line[{{7., 10.6}, {7., 12.6}}]}}, {
         ImageSize -> 250}], $CellContext`restdisks = {{
          Graphics[{
            EdgeForm[
             GrayLevel[0]], 
            GrayLevel[0], 
            Disk[{1, 1}, 0.475]}], 
          Graphics[
           Text[
            Style[" ", 12, Bold, 
             GrayLevel[0.85]], {1, 1}]]}, {
          Graphics[{
            EdgeForm[
             GrayLevel[0]], 
            GrayLevel[0], 
            Disk[{2, 1}, 0.475]}], 
          Graphics[
           Text[
            Style[" ", 12, Bold, 
             GrayLevel[0.85]], {2, 1}]]}, {
          Graphics[{
            EdgeForm[
             GrayLevel[0]], 
            GrayLevel[0], 
            Disk[{3, 1}, 0.475]}], 
          Graphics[
           Text[
            Style[" ", 12, Bold, 
             GrayLevel[0.85]], {3, 1}]]}, {
          Graphics[{
            EdgeForm[
             GrayLevel[0]], 
            GrayLevel[0], 
            Disk[{4, 1}, 0.475]}], 
          Graphics[
           Text[
            Style[" ", 12, Bold, 
             GrayLevel[0.85]], {4, 1}]]}, {
          Graphics[{
            EdgeForm[
             GrayLevel[0]], 
            GrayLevel[0], 
            Disk[{5, 1}, 0.475]}], 
          Graphics[
           Text[
            Style[" ", 12, Bold, 
             GrayLevel[0.85]], {5, 1}]]}, {
          Graphics[{
            EdgeForm[
             GrayLevel[0]], 
            GrayLevel[0], 
            Disk[{6, 1}, 0.475]}], 
          Graphics[
           Text[
            Style[" ", 12, Bold, 
             GrayLevel[0.85]], {6, 1}]]}, {
          Graphics[{
            EdgeForm[
             GrayLevel[0]], 
            GrayLevel[0], 
            Disk[{7, 1}, 0.475]}], 
          Graphics[
           Text[
            Style[" ", 12, Bold, 
             GrayLevel[0.85]], {7, 1}]]}, {
          Graphics[{
            EdgeForm[
             GrayLevel[0]], 
            GrayLevel[0], 
            Disk[{8, 1}, 0.475]}], 
          Graphics[
           Text[
            Style[" ", 12, Bold, 
             GrayLevel[0.85]], {8, 1}]]}, {
          Graphics[{
            EdgeForm[
             GrayLevel[0]], 
            GrayLevel[0], 
            Disk[{9, 1}, 0.475]}], 
          Graphics[
           Text[
            Style[" ", 12, Bold, 
             GrayLevel[0.85]], {9, 1}]]}, {
          Graphics[{
            EdgeForm[
             GrayLevel[0]], 
            GrayLevel[0], 
            Disk[{10, 1}, 0.475]}], 
          Graphics[
           Text[
            Style[" ", 12, Bold, 
             GrayLevel[0.85]], {10, 1}]]}, {
          Graphics[{
            EdgeForm[
             GrayLevel[0]], 
            GrayLevel[0], 
            Disk[{1, 2}, 0.475]}], 
          Graphics[
           Text[
            Style[" ", 12, Bold, 
             GrayLevel[0.85]], {1, 2}]]}, {
          Graphics[{
            EdgeForm[
             GrayLevel[0]], 
            GrayLevel[0], 
            Disk[{2, 2}, 0.475]}], 
          Graphics[
           Text[
            Style[" ", 12, Bold, 
             GrayLevel[0.85]], {2, 2}]]}, {
          Graphics[{
            EdgeForm[
             GrayLevel[0]], 
            GrayLevel[0], 
            Disk[{3, 2}, 0.475]}], 
          Graphics[
           Text[
            Style[" ", 12, Bold, 
             GrayLevel[0.85]], {3, 2}]]}, {
          Graphics[{
            EdgeForm[
             GrayLevel[0]], 
            GrayLevel[0], 
            Disk[{4, 2}, 0.475]}], 
          Graphics[
           Text[
            Style[" ", 12, Bold, 
             GrayLevel[0.85]], {4, 2}]]}, {
          Graphics[{
            EdgeForm[
             GrayLevel[0]], 
            GrayLevel[0], 
            Disk[{5, 2}, 0.475]}], 
          Graphics[
           Text[
            Style[" ", 12, Bold, 
             GrayLevel[0.85]], {5, 2}]]}, {
          Graphics[{
            EdgeForm[
             GrayLevel[0]], 
            GrayLevel[0], 
            Disk[{6, 2}, 0.475]}], 
          Graphics[
           Text[
            Style[" ", 12, Bold, 
             GrayLevel[0.85]], {6, 2}]]}, {
          Graphics[{
            EdgeForm[
             GrayLevel[0]], 
            GrayLevel[0], 
            Disk[{7, 2}, 0.475]}], 
          Graphics[
           Text[
            Style[" ", 12, Bold, 
             GrayLevel[0.85]], {7, 2}]]}, {
          Graphics[{
            EdgeForm[
             GrayLevel[0]], 
            GrayLevel[0], 
            Disk[{8, 2}, 0.475]}], 
          Graphics[
           Text[
            Style[" ", 12, Bold, 
             GrayLevel[0.85]], {8, 2}]]}, {
          Graphics[{
            EdgeForm[
             GrayLevel[0]], 
            GrayLevel[0], 
            Disk[{9, 2}, 0.475]}], 
          Graphics[
           Text[
            Style[" ", 12, Bold, 
             GrayLevel[0.85]], {9, 2}]]}, {
          Graphics[{
            EdgeForm[
             GrayLevel[0]], 
            GrayLevel[0], 
            Disk[{10, 2}, 0.475]}], 
          Graphics[
           Text[
            Style[" ", 12, Bold, 
             GrayLevel[0.85]], {10, 2}]]}, {
          Graphics[{
            EdgeForm[
             GrayLevel[0]], 
            GrayLevel[0], 
            Disk[{1, 3}, 0.475]}], 
          Graphics[
           Text[
            Style[" ", 12, Bold, 
             GrayLevel[0.85]], {1, 3}]]}, {
          Graphics[{
            EdgeForm[
             GrayLevel[0]], 
            GrayLevel[0], 
            Disk[{2, 3}, 0.475]}], 
          Graphics[
           Text[
            Style[" ", 12, Bold, 
             GrayLevel[0.85]], {2, 3}]]}, {
          Graphics[{
            EdgeForm[
             GrayLevel[0]], 
            GrayLevel[0], 
            Disk[{3, 3}, 0.475]}], 
          Graphics[
           Text[
            Style[" ", 12, Bold, 
             GrayLevel[0.85]], {3, 3}]]}, {
          Graphics[{
            EdgeForm[
             GrayLevel[0]], 
            GrayLevel[0], 
            Disk[{4, 3}, 0.475]}], 
          Graphics[
           Text[
            Style[" ", 12, Bold, 
             GrayLevel[0.85]], {4, 3}]]}, {
          Graphics[{
            EdgeForm[
             GrayLevel[0]], 
            GrayLevel[0], 
            Disk[{5, 3}, 0.475]}], 
          Graphics[
           Text[
            Style[" ", 12, Bold, 
             GrayLevel[0.85]], {5, 3}]]}, {
          Graphics[{
            EdgeForm[
             GrayLevel[0]], 
            GrayLevel[0], 
            Disk[{6, 3}, 0.475]}], 
          Graphics[
           Text[
            Style[" ", 12, Bold, 
             GrayLevel[0.85]], {6, 3}]]}, {
          Graphics[{
            EdgeForm[
             GrayLevel[0]], 
            GrayLevel[0], 
            Disk[{7, 3}, 0.475]}], 
          Graphics[
           Text[
            Style[" ", 12, Bold, 
             GrayLevel[0.85]], {7, 3}]]}, {
          Graphics[{
            EdgeForm[
             GrayLevel[0]], 
            GrayLevel[0], 
            Disk[{8, 3}, 0.475]}], 
          Graphics[
           Text[
            Style[" ", 12, Bold, 
             GrayLevel[0.85]], {8, 3}]]}, {
          Graphics[{
            EdgeForm[
             GrayLevel[0]], 
            GrayLevel[0], 
            Disk[{9, 3}, 0.475]}], 
          Graphics[
           Text[
            Style[" ", 12, Bold, 
             GrayLevel[0.85]], {9, 3}]]}, {
          Graphics[{
            EdgeForm[
             GrayLevel[0]], 
            GrayLevel[0], 
            Disk[{10, 3}, 0.475]}], 
          Graphics[
           Text[
            Style[" ", 12, Bold, 
             GrayLevel[0.85]], {10, 3}]]}, {
          Graphics[{
            EdgeForm[
             GrayLevel[0]], 
            GrayLevel[0], 
            Disk[{1, 4}, 0.475]}], 
          Graphics[
           Text[
            Style[" ", 12, Bold, 
             GrayLevel[0.85]], {1, 4}]]}, {
          Graphics[{
            EdgeForm[
             GrayLevel[0]], 
            GrayLevel[0], 
            Disk[{2, 4}, 0.475]}], 
          Graphics[
           Text[
            Style[" ", 12, Bold, 
             GrayLevel[0.85]], {2, 4}]]}, {
          Graphics[{
            EdgeForm[
             GrayLevel[0]], 
            GrayLevel[0], 
            Disk[{3, 4}, 0.475]}], 
          Graphics[
           Text[
            Style[" ", 12, Bold, 
             GrayLevel[0.85]], {3, 4}]]}, {
          Graphics[{
            EdgeForm[
             GrayLevel[0]], 
            GrayLevel[0], 
            Disk[{4, 4}, 0.475]}], 
          Graphics[
           Text[
            Style[" ", 12, Bold, 
             GrayLevel[0.85]], {4, 4}]]}, {
          Graphics[{
            EdgeForm[
             GrayLevel[0]], 
            GrayLevel[0], 
            Disk[{5, 4}, 0.475]}], 
          Graphics[
           Text[
            Style[" ", 12, Bold, 
             GrayLevel[0.85]], {5, 4}]]}, {
          Graphics[{
            EdgeForm[
             GrayLevel[0]], 
            GrayLevel[0], 
            Disk[{6, 4}, 0.475]}], 
          Graphics[
           Text[
            Style[" ", 12, Bold, 
             GrayLevel[0.85]], {6, 4}]]}, {
          Graphics[{
            EdgeForm[
             GrayLevel[0]], 
            GrayLevel[0], 
            Disk[{7, 4}, 0.475]}], 
          Graphics[
           Text[
            Style[" ", 12, Bold, 
             GrayLevel[0.85]], {7, 4}]]}, {
          Graphics[{
            EdgeForm[
             GrayLevel[0]], 
            GrayLevel[0], 
            Disk[{8, 4}, 0.475]}], 
          Graphics[
           Text[
            Style[" ", 12, Bold, 
             GrayLevel[0.85]], {8, 4}]]}, {
          Graphics[{
            EdgeForm[
             GrayLevel[0]], 
            GrayLevel[0], 
            Disk[{9, 4}, 0.475]}], 
          Graphics[
           Text[
            Style[" ", 12, Bold, 
             GrayLevel[0.85]], {9, 4}]]}, {
          Graphics[{
            EdgeForm[
             GrayLevel[0]], 
            GrayLevel[0], 
            Disk[{10, 4}, 0.475]}], 
          Graphics[
           Text[
            Style[" ", 12, Bold, 
             GrayLevel[0.85]], {10, 4}]]}, {
          Graphics[{
            EdgeForm[
             GrayLevel[0]], 
            GrayLevel[0], 
            Disk[{1, 5}, 0.475]}], 
          Graphics[
           Text[
            Style[" ", 12, Bold, 
             GrayLevel[0.85]], {1, 5}]]}, {
          Graphics[{
            EdgeForm[
             GrayLevel[0]], 
            GrayLevel[0], 
            Disk[{2, 5}, 0.475]}], 
          Graphics[
           Text[
            Style[" ", 12, Bold, 
             GrayLevel[0.85]], {2, 5}]]}, {
          Graphics[{
            EdgeForm[
             GrayLevel[0]], 
            GrayLevel[0], 
            Disk[{3, 5}, 0.475]}], 
          Graphics[
           Text[
            Style[" ", 12, Bold, 
             GrayLevel[0.85]], {3, 5}]]}, {
          Graphics[{
            EdgeForm[
             GrayLevel[0]], 
            GrayLevel[0], 
            Disk[{4, 5}, 0.475]}], 
          Graphics[
           Text[
            Style[" ", 12, Bold, 
             GrayLevel[0.85]], {4, 5}]]}, {
          Graphics[{
            EdgeForm[
             GrayLevel[0]], 
            GrayLevel[0], 
            Disk[{5, 5}, 0.475]}], 
          Graphics[
           Text[
            Style[" ", 12, Bold, 
             GrayLevel[0.85]], {5, 5}]]}, {
          Graphics[{
            EdgeForm[
             GrayLevel[0]], 
            GrayLevel[0], 
            Disk[{6, 5}, 0.475]}], 
          Graphics[
           Text[
            Style[" ", 12, Bold, 
             GrayLevel[0.85]], {6, 5}]]}, {
          Graphics[{
            EdgeForm[
             GrayLevel[0]], 
            GrayLevel[0], 
            Disk[{7, 5}, 0.475]}], 
          Graphics[
           Text[
            Style[" ", 12, Bold, 
             GrayLevel[0.85]], {7, 5}]]}, {
          Graphics[{
            EdgeForm[
             GrayLevel[0]], 
            GrayLevel[0], 
            Disk[{8, 5}, 0.475]}], 
          Graphics[
           Text[
            Style[" ", 12, Bold, 
             GrayLevel[0.85]], {8, 5}]]}, {
          Graphics[{
            EdgeForm[
             GrayLevel[0]], 
            GrayLevel[0], 
            Disk[{9, 5}, 0.475]}], 
          Graphics[
           Text[
            Style[" ", 12, Bold, 
             GrayLevel[0.85]], {9, 5}]]}, {
          Graphics[{
            EdgeForm[
             GrayLevel[0]], 
            GrayLevel[0], 
            Disk[{10, 5}, 0.475]}], 
          Graphics[
           Text[
            Style[" ", 12, Bold, 
             GrayLevel[0.85]], {10, 5}]]}, {
          Graphics[{
            EdgeForm[
             GrayLevel[0]], 
            GrayLevel[0], 
            Disk[{1, 6}, 0.475]}], 
          Graphics[
           Text[
            Style[" ", 12, Bold, 
             GrayLevel[0.85]], {1, 6}]]}, {
          Graphics[{
            EdgeForm[
             GrayLevel[0]], 
            GrayLevel[0], 
            Disk[{2, 6}, 0.475]}], 
          Graphics[
           Text[
            Style[" ", 12, Bold, 
             GrayLevel[0.85]], {2, 6}]]}, {
          Graphics[{
            EdgeForm[
             GrayLevel[0]], 
            GrayLevel[0], 
            Disk[{3, 6}, 0.475]}], 
          Graphics[
           Text[
            Style[" ", 12, Bold, 
             GrayLevel[0.85]], {3, 6}]]}, {
          Graphics[{
            EdgeForm[
             GrayLevel[0]], 
            GrayLevel[0], 
            Disk[{4, 6}, 0.475]}], 
          Graphics[
           Text[
            Style[" ", 12, Bold, 
             GrayLevel[0.85]], {4, 6}]]}, {
          Graphics[{
            EdgeForm[
             GrayLevel[0]], 
            GrayLevel[0], 
            Disk[{5, 6}, 0.475]}], 
          Graphics[
           Text[
            Style[" ", 12, Bold, 
             GrayLevel[0.85]], {5, 6}]]}, {
          Graphics[{
            EdgeForm[
             GrayLevel[0]], 
            GrayLevel[0], 
            Disk[{6, 6}, 0.475]}], 
          Graphics[
           Text[
            Style[" ", 12, Bold, 
             GrayLevel[0.85]], {6, 6}]]}, {
          Graphics[{
            EdgeForm[
             GrayLevel[0]], 
            GrayLevel[0], 
            Disk[{7, 6}, 0.475]}], 
          Graphics[
           Text[
            Style[" ", 12, Bold, 
             GrayLevel[0.85]], {7, 6}]]}, {
          Graphics[{
            EdgeForm[
             GrayLevel[0]], 
            GrayLevel[0], 
            Disk[{8, 6}, 0.475]}], 
          Graphics[
           Text[
            Style[" ", 12, Bold, 
             GrayLevel[0.85]], {8, 6}]]}, {
          Graphics[{
            EdgeForm[
             GrayLevel[0]], 
            GrayLevel[0], 
            Disk[{9, 6}, 0.475]}], 
          Graphics[
           Text[
            Style[" ", 12, Bold, 
             GrayLevel[0.85]], {9, 6}]]}, {
          Graphics[{
            EdgeForm[
             GrayLevel[0]], 
            GrayLevel[0], 
            Disk[{10, 6}, 0.475]}], 
          Graphics[
           Text[
            Style[" ", 12, Bold, 
             GrayLevel[0.85]], {10, 6}]]}, {
          Graphics[{
            EdgeForm[
             GrayLevel[0]], 
            GrayLevel[0], 
            Disk[{1, 7}, 0.475]}], 
          Graphics[
           Text[
            Style[" ", 12, Bold, 
             GrayLevel[0.85]], {1, 7}]]}, {
          Graphics[{
            EdgeForm[
             GrayLevel[0]], 
            GrayLevel[0], 
            Disk[{2, 7}, 0.475]}], 
          Graphics[
           Text[
            Style[" ", 12, Bold, 
             GrayLevel[0.85]], {2, 7}]]}, {
          Graphics[{
            EdgeForm[
             GrayLevel[0]], 
            GrayLevel[0], 
            Disk[{3, 7}, 0.475]}], 
          Graphics[
           Text[
            Style[" ", 12, Bold, 
             GrayLevel[0.85]], {3, 7}]]}, {
          Graphics[{
            EdgeForm[
             GrayLevel[0]], 
            GrayLevel[0], 
            Disk[{4, 7}, 0.475]}], 
          Graphics[
           Text[
            Style[" ", 12, Bold, 
             GrayLevel[0.85]], {4, 7}]]}, {
          Graphics[{
            EdgeForm[
             GrayLevel[0]], 
            GrayLevel[0], 
            Disk[{5, 7}, 0.475]}], 
          Graphics[
           Text[
            Style[" ", 12, Bold, 
             GrayLevel[0.85]], {5, 7}]]}, {
          Graphics[{
            EdgeForm[
             GrayLevel[0]], 
            GrayLevel[0], 
            Disk[{6, 7}, 0.475]}], 
          Graphics[
           Text[
            Style[" ", 12, Bold, 
             GrayLevel[0.85]], {6, 7}]]}, {
          Graphics[{
            EdgeForm[
             GrayLevel[0]], 
            GrayLevel[0], 
            Disk[{7, 7}, 0.475]}], 
          Graphics[
           Text[
            Style[" ", 12, Bold, 
             GrayLevel[0.85]], {7, 7}]]}, {
          Graphics[{
            EdgeForm[
             GrayLevel[0]], 
            GrayLevel[0], 
            Disk[{8, 7}, 0.475]}], 
          Graphics[
           Text[
            Style[" ", 12, Bold, 
             GrayLevel[0.85]], {8, 7}]]}, {
          Graphics[{
            EdgeForm[
             GrayLevel[0]], 
            GrayLevel[0], 
            Disk[{9, 7}, 0.475]}], 
          Graphics[
           Text[
            Style[" ", 12, Bold, 
             GrayLevel[0.85]], {9, 7}]]}, {
          Graphics[{
            EdgeForm[
             GrayLevel[0]], 
            GrayLevel[0], 
            Disk[{10, 7}, 0.475]}], 
          Graphics[
           Text[
            Style[" ", 12, Bold, 
             GrayLevel[0.85]], {10, 7}]]}, {
          Graphics[{
            EdgeForm[
             GrayLevel[0]], 
            GrayLevel[0], 
            Disk[{1, 8}, 0.475]}], 
          Graphics[
           Text[
            Style[" ", 12, Bold, 
             GrayLevel[0.85]], {1, 8}]]}, {
          Graphics[{
            EdgeForm[
             GrayLevel[0]], 
            GrayLevel[0], 
            Disk[{2, 8}, 0.475]}], 
          Graphics[
           Text[
            Style[" ", 12, Bold, 
             GrayLevel[0.85]], {2, 8}]]}, {
          Graphics[{
            EdgeForm[
             GrayLevel[0]], 
            GrayLevel[0], 
            Disk[{3, 8}, 0.475]}], 
          Graphics[
           Text[
            Style[" ", 12, Bold, 
             GrayLevel[0.85]], {3, 8}]]}, {
          Graphics[{
            EdgeForm[
             GrayLevel[0]], 
            GrayLevel[0], 
            Disk[{4, 8}, 0.475]}], 
          Graphics[
           Text[
            Style[" ", 12, Bold, 
             GrayLevel[0.85]], {4, 8}]]}, {
          Graphics[{
            EdgeForm[
             GrayLevel[0]], 
            GrayLevel[0], 
            Disk[{5, 8}, 0.475]}], 
          Graphics[
           Text[
            Style[" ", 12, Bold, 
             GrayLevel[0.85]], {5, 8}]]}, {
          Graphics[{
            EdgeForm[
             GrayLevel[0]], 
            GrayLevel[0], 
            Disk[{6, 8}, 0.475]}], 
          Graphics[
           Text[
            Style[" ", 12, Bold, 
             GrayLevel[0.85]], {6, 8}]]}, {
          Graphics[{
            EdgeForm[
             GrayLevel[0]], 
            GrayLevel[0], 
            Disk[{7, 8}, 0.475]}], 
          Graphics[
           Text[
            Style[" ", 12, Bold, 
             GrayLevel[0.85]], {7, 8}]]}, {
          Graphics[{
            EdgeForm[
             GrayLevel[0]], 
            GrayLevel[0], 
            Disk[{8, 8}, 0.475]}], 
          Graphics[
           Text[
            Style[" ", 12, Bold, 
             GrayLevel[0.85]], {8, 8}]]}, {
          Graphics[{
            EdgeForm[
             GrayLevel[0]], 
            GrayLevel[0], 
            Disk[{9, 8}, 0.475]}], 
          Graphics[
           Text[
            Style[" ", 12, Bold, 
             GrayLevel[0.85]], {9, 8}]]}, {
          Graphics[{
            EdgeForm[
             GrayLevel[0]], 
            GrayLevel[0], 
            Disk[{10, 8}, 0.475]}], 
          Graphics[
           Text[
            Style[" ", 12, Bold, 
             GrayLevel[0.85]], {10, 8}]]}, {
          Graphics[{
            EdgeForm[
             GrayLevel[0]], 
            GrayLevel[0], 
            Disk[{1, 9}, 0.475]}], 
          Graphics[
           Text[
            Style[" ", 12, Bold, 
             GrayLevel[0.85]], {1, 9}]]}, {
          Graphics[{
            EdgeForm[
             GrayLevel[0]], 
            GrayLevel[0], 
            Disk[{2, 9}, 0.475]}], 
          Graphics[
           Text[
            Style[" ", 12, Bold, 
             GrayLevel[0.85]], {2, 9}]]}, {
          Graphics[{
            EdgeForm[
             GrayLevel[0]], 
            GrayLevel[0], 
            Disk[{3, 9}, 0.475]}], 
          Graphics[
           Text[
            Style[" ", 12, Bold, 
             GrayLevel[0.85]], {3, 9}]]}, {
          Graphics[{
            EdgeForm[
             GrayLevel[0]], 
            GrayLevel[0], 
            Disk[{4, 9}, 0.475]}], 
          Graphics[
           Text[
            Style[" ", 12, Bold, 
             GrayLevel[0.85]], {4, 9}]]}, {
          Graphics[{
            EdgeForm[
             GrayLevel[0]], 
            GrayLevel[0], 
            Disk[{5, 9}, 0.475]}], 
          Graphics[
           Text[
            Style[" ", 12, Bold, 
             GrayLevel[0.85]], {5, 9}]]}, {
          Graphics[{
            EdgeForm[
             GrayLevel[0]], 
            GrayLevel[0], 
            Disk[{6, 9}, 0.475]}], 
          Graphics[
           Text[
            Style[" ", 12, Bold, 
             GrayLevel[0.85]], {6, 9}]]}, {
          Graphics[{
            EdgeForm[
             GrayLevel[0]], 
            GrayLevel[0], 
            Disk[{7, 9}, 0.475]}], 
          Graphics[
           Text[
            Style[" ", 12, Bold, 
             GrayLevel[0.85]], {7, 9}]]}, {
          Graphics[{
            EdgeForm[
             GrayLevel[0]], 
            GrayLevel[0], 
            Disk[{8, 9}, 0.475]}], 
          Graphics[
           Text[
            Style[" ", 12, Bold, 
             GrayLevel[0.85]], {8, 9}]]}, {
          Graphics[{
            EdgeForm[
             GrayLevel[0]], 
            GrayLevel[0], 
            Disk[{9, 9}, 0.475]}], 
          Graphics[
           Text[
            Style[" ", 12, Bold, 
             GrayLevel[0.85]], {9, 9}]]}, {
          Graphics[{
            EdgeForm[
             GrayLevel[0]], 
            GrayLevel[0], 
            Disk[{10, 9}, 0.475]}], 
          Graphics[
           Text[
            Style[" ", 12, Bold, 
             GrayLevel[0.85]], {10, 9}]]}, {
          Graphics[{
            EdgeForm[
             GrayLevel[0]], 
            GrayLevel[0], 
            Disk[{1, 10}, 0.475]}], 
          Graphics[
           Text[
            Style[" ", 12, Bold, 
             GrayLevel[0.85]], {1, 10}]]}, {
          Graphics[{
            EdgeForm[
             GrayLevel[0]], 
            GrayLevel[0], 
            Disk[{2, 10}, 0.475]}], 
          Graphics[
           Text[
            Style[" ", 12, Bold, 
             GrayLevel[0.85]], {2, 10}]]}, {
          Graphics[{
            EdgeForm[
             GrayLevel[0]], 
            GrayLevel[0], 
            Disk[{3, 10}, 0.475]}], 
          Graphics[
           Text[
            Style[" ", 12, Bold, 
             GrayLevel[0.85]], {3, 10}]]}, {
          Graphics[{
            EdgeForm[
             GrayLevel[0]], 
            GrayLevel[0], 
            Disk[{4, 10}, 0.475]}], 
          Graphics[
           Text[
            Style[" ", 12, Bold, 
             GrayLevel[0.85]], {4, 10}]]}, {
          Graphics[{
            EdgeForm[
             GrayLevel[0]], 
            GrayLevel[0], 
            Disk[{5, 10}, 0.475]}], 
          Graphics[
           Text[
            Style[" ", 12, Bold, 
             GrayLevel[0.85]], {5, 10}]]}, {
          Graphics[{
            EdgeForm[
             GrayLevel[0]], 
            GrayLevel[0], 
            Disk[{6, 10}, 0.475]}], 
          Graphics[
           Text[
            Style[" ", 12, Bold, 
             GrayLevel[0.85]], {6, 10}]]}, {
          Graphics[{
            EdgeForm[
             GrayLevel[0]], 
            GrayLevel[0], 
            Disk[{7, 10}, 0.475]}], 
          Graphics[
           Text[
            Style[" ", 12, Bold, 
             GrayLevel[0.85]], {7, 10}]]}, {
          Graphics[{
            EdgeForm[
             GrayLevel[0]], 
            GrayLevel[0], 
            Disk[{8, 10}, 0.475]}], 
          Graphics[
           Text[
            Style[" ", 12, Bold, 
             GrayLevel[0.85]], {8, 10}]]}, {
          Graphics[{
            EdgeForm[
             GrayLevel[0]], 
            GrayLevel[0], 
            Disk[{9, 10}, 0.475]}], 
          Graphics[
           Text[
            Style[" ", 12, Bold, 
             GrayLevel[0.85]], {9, 10}]]}, {
          Graphics[{
            EdgeForm[
             GrayLevel[0]], 
            GrayLevel[0], 
            Disk[{10, 10}, 0.475]}], 
          Graphics[
           Text[
            Style[" ", 12, Bold, 
             GrayLevel[0.85]], {10, 10}]]}}, $CellContext`FractionOfBalls[
         Pattern[$CellContext`frac, 
          Blank[]], 
         Pattern[$CellContext`sel, 
          Blank[]], 
         Pattern[$CellContext`ntot, 
          Blank[]]] := RandomSample[
         Part[$CellContext`alldisks, $CellContext`sel], 
         Round[$CellContext`ntot $CellContext`frac]], $CellContext`ntot = 
       100, $CellContext`alldisks = {{{
           Graphics[{
             EdgeForm[
              GrayLevel[0]], 
             RGBColor[1., 0, 0], 
             Disk[{1, 1}, 0.475]}], 
           Graphics[
            Text[
             Style["", 12, Bold, 
              GrayLevel[0.85]], {1, 1}]]}, {
           Graphics[{
             EdgeForm[
              GrayLevel[0]], 
             RGBColor[1., 0, 0], 
             Disk[{2, 1}, 0.475]}], 
           Graphics[
            Text[
             Style["", 12, Bold, 
              GrayLevel[0.85]], {2, 1}]]}, {
           Graphics[{
             EdgeForm[
              GrayLevel[0]], 
             RGBColor[1., 0, 0], 
             Disk[{3, 1}, 0.475]}], 
           Graphics[
            Text[
             Style["", 12, Bold, 
              GrayLevel[0.85]], {3, 1}]]}, {
           Graphics[{
             EdgeForm[
              GrayLevel[0]], 
             RGBColor[1., 0, 0], 
             Disk[{4, 1}, 0.475]}], 
           Graphics[
            Text[
             Style["", 12, Bold, 
              GrayLevel[0.85]], {4, 1}]]}, {
           Graphics[{
             EdgeForm[
              GrayLevel[0]], 
             RGBColor[1., 0, 0], 
             Disk[{5, 1}, 0.475]}], 
           Graphics[
            Text[
             Style["", 12, Bold, 
              GrayLevel[0.85]], {5, 1}]]}, {
           Graphics[{
             EdgeForm[
              GrayLevel[0]], 
             RGBColor[1., 0, 0], 
             Disk[{6, 1}, 0.475]}], 
           Graphics[
            Text[
             Style["", 12, Bold, 
              GrayLevel[0.85]], {6, 1}]]}, {
           Graphics[{
             EdgeForm[
              GrayLevel[0]], 
             RGBColor[1., 0, 0], 
             Disk[{7, 1}, 0.475]}], 
           Graphics[
            Text[
             Style["", 12, Bold, 
              GrayLevel[0.85]], {7, 1}]]}, {
           Graphics[{
             EdgeForm[
              GrayLevel[0]], 
             RGBColor[1., 0, 0], 
             Disk[{8, 1}, 0.475]}], 
           Graphics[
            Text[
             Style["", 12, Bold, 
              GrayLevel[0.85]], {8, 1}]]}, {
           Graphics[{
             EdgeForm[
              GrayLevel[0]], 
             RGBColor[1., 0, 0], 
             Disk[{9, 1}, 0.475]}], 
           Graphics[
            Text[
             Style["", 12, Bold, 
              GrayLevel[0.85]], {9, 1}]]}, {
           Graphics[{
             EdgeForm[
              GrayLevel[0]], 
             RGBColor[1., 0, 0], 
             Disk[{10, 1}, 0.475]}], 
           Graphics[
            Text[
             Style["", 12, Bold, 
              GrayLevel[0.85]], {10, 1}]]}, {
           Graphics[{
             EdgeForm[
              GrayLevel[0]], 
             RGBColor[1., 0, 0], 
             Disk[{1, 2}, 0.475]}], 
           Graphics[
            Text[
             Style["", 12, Bold, 
              GrayLevel[0.85]], {1, 2}]]}, {
           Graphics[{
             EdgeForm[
              GrayLevel[0]], 
             RGBColor[1., 0, 0], 
             Disk[{2, 2}, 0.475]}], 
           Graphics[
            Text[
             Style["", 12, Bold, 
              GrayLevel[0.85]], {2, 2}]]}, {
           Graphics[{
             EdgeForm[
              GrayLevel[0]], 
             RGBColor[1., 0, 0], 
             Disk[{3, 2}, 0.475]}], 
           Graphics[
            Text[
             Style["", 12, Bold, 
              GrayLevel[0.85]], {3, 2}]]}, {
           Graphics[{
             EdgeForm[
              GrayLevel[0]], 
             RGBColor[1., 0, 0], 
             Disk[{4, 2}, 0.475]}], 
           Graphics[
            Text[
             Style["", 12, Bold, 
              GrayLevel[0.85]], {4, 2}]]}, {
           Graphics[{
             EdgeForm[
              GrayLevel[0]], 
             RGBColor[1., 0, 0], 
             Disk[{5, 2}, 0.475]}], 
           Graphics[
            Text[
             Style["", 12, Bold, 
              GrayLevel[0.85]], {5, 2}]]}, {
           Graphics[{
             EdgeForm[
              GrayLevel[0]], 
             RGBColor[1., 0, 0], 
             Disk[{6, 2}, 0.475]}], 
           Graphics[
            Text[
             Style["", 12, Bold, 
              GrayLevel[0.85]], {6, 2}]]}, {
           Graphics[{
             EdgeForm[
              GrayLevel[0]], 
             RGBColor[1., 0, 0], 
             Disk[{7, 2}, 0.475]}], 
           Graphics[
            Text[
             Style["", 12, Bold, 
              GrayLevel[0.85]], {7, 2}]]}, {
           Graphics[{
             EdgeForm[
              GrayLevel[0]], 
             RGBColor[1., 0, 0], 
             Disk[{8, 2}, 0.475]}], 
           Graphics[
            Text[
             Style["", 12, Bold, 
              GrayLevel[0.85]], {8, 2}]]}, {
           Graphics[{
             EdgeForm[
              GrayLevel[0]], 
             RGBColor[1., 0, 0], 
             Disk[{9, 2}, 0.475]}], 
           Graphics[
            Text[
             Style["", 12, Bold, 
              GrayLevel[0.85]], {9, 2}]]}, {
           Graphics[{
             EdgeForm[
              GrayLevel[0]], 
             RGBColor[1., 0, 0], 
             Disk[{10, 2}, 0.475]}], 
           Graphics[
            Text[
             Style["", 12, Bold, 
              GrayLevel[0.85]], {10, 2}]]}, {
           Graphics[{
             EdgeForm[
              GrayLevel[0]], 
             RGBColor[1., 0, 0], 
             Disk[{1, 3}, 0.475]}], 
           Graphics[
            Text[
             Style["", 12, Bold, 
              GrayLevel[0.85]], {1, 3}]]}, {
           Graphics[{
             EdgeForm[
              GrayLevel[0]], 
             RGBColor[1., 0, 0], 
             Disk[{2, 3}, 0.475]}], 
           Graphics[
            Text[
             Style["", 12, Bold, 
              GrayLevel[0.85]], {2, 3}]]}, {
           Graphics[{
             EdgeForm[
              GrayLevel[0]], 
             RGBColor[1., 0, 0], 
             Disk[{3, 3}, 0.475]}], 
           Graphics[
            Text[
             Style["", 12, Bold, 
              GrayLevel[0.85]], {3, 3}]]}, {
           Graphics[{
             EdgeForm[
              GrayLevel[0]], 
             RGBColor[1., 0, 0], 
             Disk[{4, 3}, 0.475]}], 
           Graphics[
            Text[
             Style["", 12, Bold, 
              GrayLevel[0.85]], {4, 3}]]}, {
           Graphics[{
             EdgeForm[
              GrayLevel[0]], 
             RGBColor[1., 0, 0], 
             Disk[{5, 3}, 0.475]}], 
           Graphics[
            Text[
             Style["", 12, Bold, 
              GrayLevel[0.85]], {5, 3}]]}, {
           Graphics[{
             EdgeForm[
              GrayLevel[0]], 
             RGBColor[1., 0, 0], 
             Disk[{6, 3}, 0.475]}], 
           Graphics[
            Text[
             Style["", 12, Bold, 
              GrayLevel[0.85]], {6, 3}]]}, {
           Graphics[{
             EdgeForm[
              GrayLevel[0]], 
             RGBColor[1., 0, 0], 
             Disk[{7, 3}, 0.475]}], 
           Graphics[
            Text[
             Style["", 12, Bold, 
              GrayLevel[0.85]], {7, 3}]]}, {
           Graphics[{
             EdgeForm[
              GrayLevel[0]], 
             RGBColor[1., 0, 0], 
             Disk[{8, 3}, 0.475]}], 
           Graphics[
            Text[
             Style["", 12, Bold, 
              GrayLevel[0.85]], {8, 3}]]}, {
           Graphics[{
             EdgeForm[
              GrayLevel[0]], 
             RGBColor[1., 0, 0], 
             Disk[{9, 3}, 0.475]}], 
           Graphics[
            Text[
             Style["", 12, Bold, 
              GrayLevel[0.85]], {9, 3}]]}, {
           Graphics[{
             EdgeForm[
              GrayLevel[0]], 
             RGBColor[1., 0, 0], 
             Disk[{10, 3}, 0.475]}], 
           Graphics[
            Text[
             Style["", 12, Bold, 
              GrayLevel[0.85]], {10, 3}]]}, {
           Graphics[{
             EdgeForm[
              GrayLevel[0]], 
             RGBColor[1., 0, 0], 
             Disk[{1, 4}, 0.475]}], 
           Graphics[
            Text[
             Style["", 12, Bold, 
              GrayLevel[0.85]], {1, 4}]]}, {
           Graphics[{
             EdgeForm[
              GrayLevel[0]], 
             RGBColor[1., 0, 0], 
             Disk[{2, 4}, 0.475]}], 
           Graphics[
            Text[
             Style["", 12, Bold, 
              GrayLevel[0.85]], {2, 4}]]}, {
           Graphics[{
             EdgeForm[
              GrayLevel[0]], 
             RGBColor[1., 0, 0], 
             Disk[{3, 4}, 0.475]}], 
           Graphics[
            Text[
             Style["", 12, Bold, 
              GrayLevel[0.85]], {3, 4}]]}, {
           Graphics[{
             EdgeForm[
              GrayLevel[0]], 
             RGBColor[1., 0, 0], 
             Disk[{4, 4}, 0.475]}], 
           Graphics[
            Text[
             Style["", 12, Bold, 
              GrayLevel[0.85]], {4, 4}]]}, {
           Graphics[{
             EdgeForm[
              GrayLevel[0]], 
             RGBColor[1., 0, 0], 
             Disk[{5, 4}, 0.475]}], 
           Graphics[
            Text[
             Style["", 12, Bold, 
              GrayLevel[0.85]], {5, 4}]]}, {
           Graphics[{
             EdgeForm[
              GrayLevel[0]], 
             RGBColor[1., 0, 0], 
             Disk[{6, 4}, 0.475]}], 
           Graphics[
            Text[
             Style["", 12, Bold, 
              GrayLevel[0.85]], {6, 4}]]}, {
           Graphics[{
             EdgeForm[
              GrayLevel[0]], 
             RGBColor[1., 0, 0], 
             Disk[{7, 4}, 0.475]}], 
           Graphics[
            Text[
             Style["", 12, Bold, 
              GrayLevel[0.85]], {7, 4}]]}, {
           Graphics[{
             EdgeForm[
              GrayLevel[0]], 
             RGBColor[1., 0, 0], 
             Disk[{8, 4}, 0.475]}], 
           Graphics[
            Text[
             Style["", 12, Bold, 
              GrayLevel[0.85]], {8, 4}]]}, {
           Graphics[{
             EdgeForm[
              GrayLevel[0]], 
             RGBColor[1., 0, 0], 
             Disk[{9, 4}, 0.475]}], 
           Graphics[
            Text[
             Style["", 12, Bold, 
              GrayLevel[0.85]], {9, 4}]]}, {
           Graphics[{
             EdgeForm[
              GrayLevel[0]], 
             RGBColor[1., 0, 0], 
             Disk[{10, 4}, 0.475]}], 
           Graphics[
            Text[
             Style["", 12, Bold, 
              GrayLevel[0.85]], {10, 4}]]}, {
           Graphics[{
             EdgeForm[
              GrayLevel[0]], 
             RGBColor[1., 0, 0], 
             Disk[{1, 5}, 0.475]}], 
           Graphics[
            Text[
             Style["", 12, Bold, 
              GrayLevel[0.85]], {1, 5}]]}, {
           Graphics[{
             EdgeForm[
              GrayLevel[0]], 
             RGBColor[1., 0, 0], 
             Disk[{2, 5}, 0.475]}], 
           Graphics[
            Text[
             Style["", 12, Bold, 
              GrayLevel[0.85]], {2, 5}]]}, {
           Graphics[{
             EdgeForm[
              GrayLevel[0]], 
             RGBColor[1., 0, 0], 
             Disk[{3, 5}, 0.475]}], 
           Graphics[
            Text[
             Style["", 12, Bold, 
              GrayLevel[0.85]], {3, 5}]]}, {
           Graphics[{
             EdgeForm[
              GrayLevel[0]], 
             RGBColor[1., 0, 0], 
             Disk[{4, 5}, 0.475]}], 
           Graphics[
            Text[
             Style["", 12, Bold, 
              GrayLevel[0.85]], {4, 5}]]}, {
           Graphics[{
             EdgeForm[
              GrayLevel[0]], 
             RGBColor[1., 0, 0], 
             Disk[{5, 5}, 0.475]}], 
           Graphics[
            Text[
             Style["", 12, Bold, 
              GrayLevel[0.85]], {5, 5}]]}, {
           Graphics[{
             EdgeForm[
              GrayLevel[0]], 
             RGBColor[1., 0, 0], 
             Disk[{6, 5}, 0.475]}], 
           Graphics[
            Text[
             Style["", 12, Bold, 
              GrayLevel[0.85]], {6, 5}]]}, {
           Graphics[{
             EdgeForm[
              GrayLevel[0]], 
             RGBColor[1., 0, 0], 
             Disk[{7, 5}, 0.475]}], 
           Graphics[
            Text[
             Style["", 12, Bold, 
              GrayLevel[0.85]], {7, 5}]]}, {
           Graphics[{
             EdgeForm[
              GrayLevel[0]], 
             RGBColor[1., 0, 0], 
             Disk[{8, 5}, 0.475]}], 
           Graphics[
            Text[
             Style["", 12, Bold, 
              GrayLevel[0.85]], {8, 5}]]}, {
           Graphics[{
             EdgeForm[
              GrayLevel[0]], 
             RGBColor[1., 0, 0], 
             Disk[{9, 5}, 0.475]}], 
           Graphics[
            Text[
             Style["", 12, Bold, 
              GrayLevel[0.85]], {9, 5}]]}, {
           Graphics[{
             EdgeForm[
              GrayLevel[0]], 
             RGBColor[1., 0, 0], 
             Disk[{10, 5}, 0.475]}], 
           Graphics[
            Text[
             Style["", 12, Bold, 
              GrayLevel[0.85]], {10, 5}]]}, {
           Graphics[{
             EdgeForm[
              GrayLevel[0]], 
             RGBColor[1., 0, 0], 
             Disk[{1, 6}, 0.475]}], 
           Graphics[
            Text[
             Style["", 12, Bold, 
              GrayLevel[0.85]], {1, 6}]]}, {
           Graphics[{
             EdgeForm[
              GrayLevel[0]], 
             RGBColor[1., 0, 0], 
             Disk[{2, 6}, 0.475]}], 
           Graphics[
            Text[
             Style["", 12, Bold, 
              GrayLevel[0.85]], {2, 6}]]}, {
           Graphics[{
             EdgeForm[
              GrayLevel[0]], 
             RGBColor[1., 0, 0], 
             Disk[{3, 6}, 0.475]}], 
           Graphics[
            Text[
             Style["", 12, Bold, 
              GrayLevel[0.85]], {3, 6}]]}, {
           Graphics[{
             EdgeForm[
              GrayLevel[0]], 
             RGBColor[1., 0, 0], 
             Disk[{4, 6}, 0.475]}], 
           Graphics[
            Text[
             Style["", 12, Bold, 
              GrayLevel[0.85]], {4, 6}]]}, {
           Graphics[{
             EdgeForm[
              GrayLevel[0]], 
             RGBColor[1., 0, 0], 
             Disk[{5, 6}, 0.475]}], 
           Graphics[
            Text[
             Style["", 12, Bold, 
              GrayLevel[0.85]], {5, 6}]]}, {
           Graphics[{
             EdgeForm[
              GrayLevel[0]], 
             RGBColor[1., 0, 0], 
             Disk[{6, 6}, 0.475]}], 
           Graphics[
            Text[
             Style["", 12, Bold, 
              GrayLevel[0.85]], {6, 6}]]}, {
           Graphics[{
             EdgeForm[
              GrayLevel[0]], 
             RGBColor[1., 0, 0], 
             Disk[{7, 6}, 0.475]}], 
           Graphics[
            Text[
             Style["", 12, Bold, 
              GrayLevel[0.85]], {7, 6}]]}, {
           Graphics[{
             EdgeForm[
              GrayLevel[0]], 
             RGBColor[1., 0, 0], 
             Disk[{8, 6}, 0.475]}], 
           Graphics[
            Text[
             Style["", 12, Bold, 
              GrayLevel[0.85]], {8, 6}]]}, {
           Graphics[{
             EdgeForm[
              GrayLevel[0]], 
             RGBColor[1., 0, 0], 
             Disk[{9, 6}, 0.475]}], 
           Graphics[
            Text[
             Style["", 12, Bold, 
              GrayLevel[0.85]], {9, 6}]]}, {
           Graphics[{
             EdgeForm[
              GrayLevel[0]], 
             RGBColor[1., 0, 0], 
             Disk[{10, 6}, 0.475]}], 
           Graphics[
            Text[
             Style["", 12, Bold, 
              GrayLevel[0.85]], {10, 6}]]}, {
           Graphics[{
             EdgeForm[
              GrayLevel[0]], 
             RGBColor[1., 0, 0], 
             Disk[{1, 7}, 0.475]}], 
           Graphics[
            Text[
             Style["", 12, Bold, 
              GrayLevel[0.85]], {1, 7}]]}, {
           Graphics[{
             EdgeForm[
              GrayLevel[0]], 
             RGBColor[1., 0, 0], 
             Disk[{2, 7}, 0.475]}], 
           Graphics[
            Text[
             Style["", 12, Bold, 
              GrayLevel[0.85]], {2, 7}]]}, {
           Graphics[{
             EdgeForm[
              GrayLevel[0]], 
             RGBColor[1., 0, 0], 
             Disk[{3, 7}, 0.475]}], 
           Graphics[
            Text[
             Style["", 12, Bold, 
              GrayLevel[0.85]], {3, 7}]]}, {
           Graphics[{
             EdgeForm[
              GrayLevel[0]], 
             RGBColor[1., 0, 0], 
             Disk[{4, 7}, 0.475]}], 
           Graphics[
            Text[
             Style["", 12, Bold, 
              GrayLevel[0.85]], {4, 7}]]}, {
           Graphics[{
             EdgeForm[
              GrayLevel[0]], 
             RGBColor[1., 0, 0], 
             Disk[{5, 7}, 0.475]}], 
           Graphics[
            Text[
             Style["", 12, Bold, 
              GrayLevel[0.85]], {5, 7}]]}, {
           Graphics[{
             EdgeForm[
              GrayLevel[0]], 
             RGBColor[1., 0, 0], 
             Disk[{6, 7}, 0.475]}], 
           Graphics[
            Text[
             Style["", 12, Bold, 
              GrayLevel[0.85]], {6, 7}]]}, {
           Graphics[{
             EdgeForm[
              GrayLevel[0]], 
             RGBColor[1., 0, 0], 
             Disk[{7, 7}, 0.475]}], 
           Graphics[
            Text[
             Style["", 12, Bold, 
              GrayLevel[0.85]], {7, 7}]]}, {
           Graphics[{
             EdgeForm[
              GrayLevel[0]], 
             RGBColor[1., 0, 0], 
             Disk[{8, 7}, 0.475]}], 
           Graphics[
            Text[
             Style["", 12, Bold, 
              GrayLevel[0.85]], {8, 7}]]}, {
           Graphics[{
             EdgeForm[
              GrayLevel[0]], 
             RGBColor[1., 0, 0], 
             Disk[{9, 7}, 0.475]}], 
           Graphics[
            Text[
             Style["", 12, Bold, 
              GrayLevel[0.85]], {9, 7}]]}, {
           Graphics[{
             EdgeForm[
              GrayLevel[0]], 
             RGBColor[1., 0, 0], 
             Disk[{10, 7}, 0.475]}], 
           Graphics[
            Text[
             Style["", 12, Bold, 
              GrayLevel[0.85]], {10, 7}]]}, {
           Graphics[{
             EdgeForm[
              GrayLevel[0]], 
             RGBColor[1., 0, 0], 
             Disk[{1, 8}, 0.475]}], 
           Graphics[
            Text[
             Style["", 12, Bold, 
              GrayLevel[0.85]], {1, 8}]]}, {
           Graphics[{
             EdgeForm[
              GrayLevel[0]], 
             RGBColor[1., 0, 0], 
             Disk[{2, 8}, 0.475]}], 
           Graphics[
            Text[
             Style["", 12, Bold, 
              GrayLevel[0.85]], {2, 8}]]}, {
           Graphics[{
             EdgeForm[
              GrayLevel[0]], 
             RGBColor[1., 0, 0], 
             Disk[{3, 8}, 0.475]}], 
           Graphics[
            Text[
             Style["", 12, Bold, 
              GrayLevel[0.85]], {3, 8}]]}, {
           Graphics[{
             EdgeForm[
              GrayLevel[0]], 
             RGBColor[1., 0, 0], 
             Disk[{4, 8}, 0.475]}], 
           Graphics[
            Text[
             Style["", 12, Bold, 
              GrayLevel[0.85]], {4, 8}]]}, {
           Graphics[{
             EdgeForm[
              GrayLevel[0]], 
             RGBColor[1., 0, 0], 
             Disk[{5, 8}, 0.475]}], 
           Graphics[
            Text[
             Style["", 12, Bold, 
              GrayLevel[0.85]], {5, 8}]]}, {
           Graphics[{
             EdgeForm[
              GrayLevel[0]], 
             RGBColor[1., 0, 0], 
             Disk[{6, 8}, 0.475]}], 
           Graphics[
            Text[
             Style["", 12, Bold, 
              GrayLevel[0.85]], {6, 8}]]}, {
           Graphics[{
             EdgeForm[
              GrayLevel[0]], 
             RGBColor[1., 0, 0], 
             Disk[{7, 8}, 0.475]}], 
           Graphics[
            Text[
             Style["", 12, Bold, 
              GrayLevel[0.85]], {7, 8}]]}, {
           Graphics[{
             EdgeForm[
              GrayLevel[0]], 
             RGBColor[1., 0, 0], 
             Disk[{8, 8}, 0.475]}], 
           Graphics[
            Text[
             Style["", 12, Bold, 
              GrayLevel[0.85]], {8, 8}]]}, {
           Graphics[{
             EdgeForm[
              GrayLevel[0]], 
             RGBColor[1., 0, 0], 
             Disk[{9, 8}, 0.475]}], 
           Graphics[
            Text[
             Style["", 12, Bold, 
              GrayLevel[0.85]], {9, 8}]]}, {
           Graphics[{
             EdgeForm[
              GrayLevel[0]], 
             RGBColor[1., 0, 0], 
             Disk[{10, 8}, 0.475]}], 
           Graphics[
            Text[
             Style["", 12, Bold, 
              GrayLevel[0.85]], {10, 8}]]}, {
           Graphics[{
             EdgeForm[
              GrayLevel[0]], 
             RGBColor[1., 0, 0], 
             Disk[{1, 9}, 0.475]}], 
           Graphics[
            Text[
             Style["", 12, Bold, 
              GrayLevel[0.85]], {1, 9}]]}, {
           Graphics[{
             EdgeForm[
              GrayLevel[0]], 
             RGBColor[1., 0, 0], 
             Disk[{2, 9}, 0.475]}], 
           Graphics[
            Text[
             Style["", 12, Bold, 
              GrayLevel[0.85]], {2, 9}]]}, {
           Graphics[{
             EdgeForm[
              GrayLevel[0]], 
             RGBColor[1., 0, 0], 
             Disk[{3, 9}, 0.475]}], 
           Graphics[
            Text[
             Style["", 12, Bold, 
              GrayLevel[0.85]], {3, 9}]]}, {
           Graphics[{
             EdgeForm[
              GrayLevel[0]], 
             RGBColor[1., 0, 0], 
             Disk[{4, 9}, 0.475]}], 
           Graphics[
            Text[
             Style["", 12, Bold, 
              GrayLevel[0.85]], {4, 9}]]}, {
           Graphics[{
             EdgeForm[
              GrayLevel[0]], 
             RGBColor[1., 0, 0], 
             Disk[{5, 9}, 0.475]}], 
           Graphics[
            Text[
             Style["", 12, Bold, 
              GrayLevel[0.85]], {5, 9}]]}, {
           Graphics[{
             EdgeForm[
              GrayLevel[0]], 
             RGBColor[1., 0, 0], 
             Disk[{6, 9}, 0.475]}], 
           Graphics[
            Text[
             Style["", 12, Bold, 
              GrayLevel[0.85]], {6, 9}]]}, {
           Graphics[{
             EdgeForm[
              GrayLevel[0]], 
             RGBColor[1., 0, 0], 
             Disk[{7, 9}, 0.475]}], 
           Graphics[
            Text[
             Style["", 12, Bold, 
              GrayLevel[0.85]], {7, 9}]]}, {
           Graphics[{
             EdgeForm[
              GrayLevel[0]], 
             RGBColor[1., 0, 0], 
             Disk[{8, 9}, 0.475]}], 
           Graphics[
            Text[
             Style["", 12, Bold, 
              GrayLevel[0.85]], {8, 9}]]}, {
           Graphics[{
             EdgeForm[
              GrayLevel[0]], 
             RGBColor[1., 0, 0], 
             Disk[{9, 9}, 0.475]}], 
           Graphics[
            Text[
             Style["", 12, Bold, 
              GrayLevel[0.85]], {9, 9}]]}, {
           Graphics[{
             EdgeForm[
              GrayLevel[0]], 
             RGBColor[1., 0, 0], 
             Disk[{10, 9}, 0.475]}], 
           Graphics[
            Text[
             Style["", 12, Bold, 
              GrayLevel[0.85]], {10, 9}]]}, {
           Graphics[{
             EdgeForm[
              GrayLevel[0]], 
             RGBColor[1., 0, 0], 
             Disk[{1, 10}, 0.475]}], 
           Graphics[
            Text[
             Style["", 12, Bold, 
              GrayLevel[0.85]], {1, 10}]]}, {
           Graphics[{
             EdgeForm[
              GrayLevel[0]], 
             RGBColor[1., 0, 0], 
             Disk[{2, 10}, 0.475]}], 
           Graphics[
            Text[
             Style["", 12, Bold, 
              GrayLevel[0.85]], {2, 10}]]}, {
           Graphics[{
             EdgeForm[
              GrayLevel[0]], 
             RGBColor[1., 0, 0], 
             Disk[{3, 10}, 0.475]}], 
           Graphics[
            Text[
             Style["", 12, Bold, 
              GrayLevel[0.85]], {3, 10}]]}, {
           Graphics[{
             EdgeForm[
              GrayLevel[0]], 
             RGBColor[1., 0, 0], 
             Disk[{4, 10}, 0.475]}], 
           Graphics[
            Text[
             Style["", 12, Bold, 
              GrayLevel[0.85]], {4, 10}]]}, {
           Graphics[{
             EdgeForm[
              GrayLevel[0]], 
             RGBColor[1., 0, 0], 
             Disk[{5, 10}, 0.475]}], 
           Graphics[
            Text[
             Style["", 12, Bold, 
              GrayLevel[0.85]], {5, 10}]]}, {
           Graphics[{
             EdgeForm[
              GrayLevel[0]], 
             RGBColor[1., 0, 0], 
             Disk[{6, 10}, 0.475]}], 
           Graphics[
            Text[
             Style["", 12, Bold, 
              GrayLevel[0.85]], {6, 10}]]}, {
           Graphics[{
             EdgeForm[
              GrayLevel[0]], 
             RGBColor[1., 0, 0], 
             Disk[{7, 10}, 0.475]}], 
           Graphics[
            Text[
             Style["", 12, Bold, 
              GrayLevel[0.85]], {7, 10}]]}, {
           Graphics[{
             EdgeForm[
              GrayLevel[0]], 
             RGBColor[1., 0, 0], 
             Disk[{8, 10}, 0.475]}], 
           Graphics[
            Text[
             Style["", 12, Bold, 
              GrayLevel[0.85]], {8, 10}]]}, {
           Graphics[{
             EdgeForm[
              GrayLevel[0]], 
             RGBColor[1., 0, 0], 
             Disk[{9, 10}, 0.475]}], 
           Graphics[
            Text[
             Style["", 12, Bold, 
              GrayLevel[0.85]], {9, 10}]]}, {
           Graphics[{
             EdgeForm[
              GrayLevel[0]], 
             RGBColor[1., 0, 0], 
             Disk[{10, 10}, 0.475]}], 
           Graphics[
            Text[
             Style["", 12, Bold, 
              GrayLevel[0.85]], {10, 10}]]}}}}; Typeset`initDone$$ = True),
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{
  3.94757668063275*^9, 3.951815841629395*^9, {3.951815902678966*^9, 
   3.951815910507709*^9}, 3.9557693316285048`*^9},
 CellLabel->"Out[126]=",
 $CellContext`InitializationGroup -> 
 True,ExpressionUUID->"efbd10d4-fb70-4fbe-9066-80cd26840ef0"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["c2s1Figure4", "Section",
 CellChangeTimes->{{3.5723420028690567`*^9, 3.572342011627058*^9}, {
   3.947391571097383*^9, 3.947391617058372*^9}, 3.9473923450883703`*^9, 
   3.947393236393119*^9, 3.947575060658597*^9, 3.94757625885634*^9, {
   3.947576305999908*^9, 3.9475763418928547`*^9}, 3.947576372325828*^9, 
   3.947576440530884*^9, {3.947576492156948*^9, 3.947576493252994*^9}, 
   3.947576563434869*^9, 3.947576606306798*^9},
 $CellContext`InitializationGroup -> 
 True,ExpressionUUID->"92ed4660-1e8b-43d9-80b6-bb09f95cea08"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"a", "=", " ", 
   RowBox[{"Disk", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{".9", ",", "1.3"}], "}"}], ",", "0.5"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"labA", "=", 
   RowBox[{"Text", "[", 
    RowBox[{
     RowBox[{"Style", "[", 
      RowBox[{"\"\<A\>\"", ",", "Black", ",", "20"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{".9", ",", "1.3"}], "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"b", "=", " ", 
   RowBox[{"Disk", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1.9", ",", ".9"}], "}"}], ",", "0.3"}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"labB", "=", 
   RowBox[{"Text", "[", 
    RowBox[{
     RowBox[{"Style", "[", 
      RowBox[{"\"\<B\>\"", ",", "Black", ",", "20"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.9", ",", ".9"}], "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rect", "=", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"EdgeForm", "[", 
       RowBox[{"Directive", "[", 
        RowBox[{"Thick", ",", "Black"}], "]"}], "]"}], ",", "White", ",", 
      RowBox[{"Rectangle", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0.", ",", "0."}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"3.", ",", "2."}], "}"}]}], "]"}]}], "}"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"bg", "=", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"EdgeForm", "[", 
       RowBox[{"Directive", "[", 
        RowBox[{"Thick", ",", "Black"}], "]"}], "]"}], ",", "White", ",", 
      RowBox[{"Rectangle", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0.", ",", "0."}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"3.", ",", "2."}], "}"}]}], "]"}], ",", 
      RowBox[{"Text", "[", 
       RowBox[{
        RowBox[{"Style", "[", 
         RowBox[{"\"\<\[CapitalOmega]\>\"", ",", "Black", ",", "24"}], "]"}], 
        ",", 
        RowBox[{"{", 
         RowBox[{"2.85", ",", "0.15"}], "}"}]}], "]"}], ",", "a", ",", "b", ",",
       ",", "labA", ",", "labB"}], "}"}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.9469762140190268`*^9, 3.9469762260498953`*^9}, {
   3.946976269129236*^9, 3.9469763501514273`*^9}, {3.94697641195732*^9, 
   3.946976416394808*^9}, {3.946976487126225*^9, 3.9469765391996603`*^9}, {
   3.946976658912937*^9, 3.946976829185161*^9}, {3.9469816307232857`*^9, 
   3.946981817944262*^9}, {3.9469818739412394`*^9, 3.9469818854500303`*^9}, {
   3.946981977494583*^9, 3.9469820172079887`*^9}, {3.9469821242274446`*^9, 
   3.946982129732952*^9}, {3.9469821988532953`*^9, 3.9469822702648907`*^9}, {
   3.946982330986024*^9, 3.946982331738019*^9}, {3.946982382709482*^9, 
   3.9469826037139473`*^9}, {3.946983425904619*^9, 3.946983545935223*^9}, 
   3.9475766475556517`*^9},
 CellLabel->"In[127]:=",
 $CellContext`InitializationGroup -> 
 True,ExpressionUUID->"760ec9ba-d994-4d02-b5d4-96f2650df4a7"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"c2s1Figure4", "=", "bg"}]], "Input",
 CellChangeTimes->{{3.552101147722106*^9, 3.552101153255982*^9}, {
   3.5521013496445227`*^9, 3.552101351220228*^9}, {3.552110958393509*^9, 
   3.552111003016033*^9}, {3.9469835637167063`*^9, 3.946983570710126*^9}, 
   3.947002703961092*^9, {3.947576614584337*^9, 3.9475766163418016`*^9}},
 CellLabel->"In[133]:=",
 $CellContext`InitializationGroup -> 
 True,ExpressionUUID->"231d0f2d-9b7a-450e-adeb-31fb5fc8b367"],

Cell[BoxData[
 GraphicsBox[
  {GrayLevel[1], EdgeForm[{GrayLevel[0], Thickness[Large]}], 
   RectangleBox[{0., 0.}, {3., 2.}], InsetBox[
    StyleBox["\<\"\[CapitalOmega]\"\>",
     StripOnInput->False,
     LineColor->GrayLevel[0],
     FrontFaceColor->GrayLevel[0],
     BackFaceColor->GrayLevel[0],
     GraphicsColor->GrayLevel[0],
     FontSize->24,
     FontColor->GrayLevel[0]], {2.85, 0.15}], DiskBox[{0.9, 1.3}, 0.5], 
   DiskBox[{1.9, 0.9}, 0.3], InsetBox[
    StyleBox["\<\"A\"\>",
     StripOnInput->False,
     LineColor->GrayLevel[0],
     FrontFaceColor->GrayLevel[0],
     BackFaceColor->GrayLevel[0],
     GraphicsColor->GrayLevel[0],
     FontSize->20,
     FontColor->GrayLevel[0]], {0.9, 1.3}], InsetBox[
    StyleBox["\<\"B\"\>",
     StripOnInput->False,
     LineColor->GrayLevel[0],
     FrontFaceColor->GrayLevel[0],
     BackFaceColor->GrayLevel[0],
     GraphicsColor->GrayLevel[0],
     FontSize->20,
     FontColor->GrayLevel[0]], {1.9, 0.9}]}]], "Output",
 CellChangeTimes->{3.947576680710106*^9, 3.951815919412518*^9, 
  3.955769331690724*^9},
 CellLabel->"Out[133]=",
 $CellContext`InitializationGroup -> 
 True,ExpressionUUID->"bf8555ff-a11d-4283-9932-61821d3d7fb2"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["c2s1Figure5", "Section",
 CellChangeTimes->{{3.5723420028690567`*^9, 3.572342011627058*^9}, {
   3.947391571097383*^9, 3.947391617058372*^9}, 3.9473923450883703`*^9, 
   3.947393236393119*^9, 3.947575060658597*^9, 3.94757625885634*^9, {
   3.947576305999908*^9, 3.9475763418928547`*^9}, 3.947576372325828*^9, 
   3.947576440530884*^9, {3.947576492156948*^9, 3.947576493252994*^9}, {
   3.947576563434869*^9, 3.947576571567623*^9}, 3.9475766237210608`*^9},
 $CellContext`InitializationGroup -> 
 True,ExpressionUUID->"965cfd6f-5713-4ea9-a460-16c44b246f7a"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"a", "=", " ", 
   RowBox[{"Disk", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{".9", ",", "1.3"}], "}"}], ",", "0.5"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"labA", "=", 
   RowBox[{"Text", "[", 
    RowBox[{
     RowBox[{"Style", "[", 
      RowBox[{"\"\<A\>\"", ",", "Black", ",", "20"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{".6", ",", "1.3"}], "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"b", "=", " ", 
   RowBox[{"Disk", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1.4", ",", "1.3"}], "}"}], ",", "0.3"}], "]"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"labB", "=", 
   RowBox[{"Text", "[", 
    RowBox[{
     RowBox[{"Style", "[", 
      RowBox[{"\"\<B\>\"", ",", "Black", ",", "20"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.6", ",", "1.3"}], "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rect", "=", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"EdgeForm", "[", 
       RowBox[{"Directive", "[", 
        RowBox[{"Thick", ",", "Black"}], "]"}], "]"}], ",", "White", ",", 
      RowBox[{"Rectangle", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0.", ",", "0."}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"3.", ",", "2."}], "}"}]}], "]"}]}], "}"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"bg", "=", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"EdgeForm", "[", 
       RowBox[{"Directive", "[", 
        RowBox[{"Thick", ",", "Black"}], "]"}], "]"}], ",", "White", ",", 
      RowBox[{"Rectangle", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0.", ",", "0."}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"3.", ",", "2."}], "}"}]}], "]"}], ",", 
      RowBox[{"Text", "[", 
       RowBox[{
        RowBox[{"Style", "[", 
         RowBox[{"\"\<\[CapitalOmega]\>\"", ",", "Black", ",", "24"}], "]"}], 
        ",", 
        RowBox[{"{", 
         RowBox[{"2.85", ",", "0.15"}], "}"}]}], "]"}], ",", "a", ",", "b", ",",
       "labA", ",", "labB"}], "}"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"intersection", "=", 
    RowBox[{"RegionPlot", "[", 
     RowBox[{
      RowBox[{"RegionDifference", "[", 
       RowBox[{"a", ",", "b"}], "]"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", "LightGray"}], ",", 
      RowBox[{"BoundaryStyle", "\[Rule]", 
       RowBox[{"Directive", "[", 
        RowBox[{"Black", ",", "Thick"}], "]"}]}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"c2s1Figure5", "=", 
  RowBox[{"Show", "[", 
   RowBox[{"bg", ",", "intersection", ",", 
    RowBox[{"Graphics", "[", "labA", "]"}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.9469762140190268`*^9, 3.9469762260498953`*^9}, {
   3.946976269129236*^9, 3.9469763501514273`*^9}, {3.94697641195732*^9, 
   3.946976416394808*^9}, {3.946976487126225*^9, 3.9469765391996603`*^9}, {
   3.946976658912937*^9, 3.946976829185161*^9}, {3.9469816307232857`*^9, 
   3.946981817944262*^9}, {3.9469818739412394`*^9, 3.9469818854500303`*^9}, {
   3.946981977494583*^9, 3.9469820172079887`*^9}, {3.9469821242274446`*^9, 
   3.946982129732952*^9}, {3.9469821988532953`*^9, 3.9469822702648907`*^9}, {
   3.946982330986024*^9, 3.946982331738019*^9}, {3.946982382709482*^9, 
   3.9469826037139473`*^9}, 3.946983608024239*^9, 3.94698412931633*^9, {
   3.94700194390949*^9, 3.947001945556903*^9}, {3.947002166908988*^9, 
   3.947002175336884*^9}, {3.94700226961658*^9, 3.947002279645124*^9}, {
   3.9470023129196777`*^9, 3.947002328741795*^9}, {3.947002370393057*^9, 
   3.9470023886639223`*^9}, 3.947002724515781*^9, {3.947576636157908*^9, 
   3.947576637610886*^9}},
 CellLabel->"In[134]:=",
 $CellContext`InitializationGroup -> 
 True,ExpressionUUID->"61aeb5b6-eddb-4a9a-99ae-7d28bf983d8c"],

Cell[BoxData[
 GraphicsBox[{
   {GrayLevel[1], EdgeForm[{GrayLevel[0], Thickness[Large]}], 
    RectangleBox[{0., 0.}, {3., 2.}], InsetBox[
     StyleBox["\<\"\[CapitalOmega]\"\>",
      StripOnInput->False,
      LineColor->GrayLevel[0],
      FrontFaceColor->GrayLevel[0],
      BackFaceColor->GrayLevel[0],
      GraphicsColor->GrayLevel[0],
      FontSize->24,
      FontColor->GrayLevel[0]], {2.85, 0.15}], DiskBox[{0.9, 1.3}, 0.5], 
    DiskBox[{1.4, 1.3}, 0.3], InsetBox[
     StyleBox["\<\"A\"\>",
      StripOnInput->False,
      LineColor->GrayLevel[0],
      FrontFaceColor->GrayLevel[0],
      BackFaceColor->GrayLevel[0],
      GraphicsColor->GrayLevel[0],
      FontSize->20,
      FontColor->GrayLevel[0]], {0.6, 1.3}], InsetBox[
     StyleBox["\<\"B\"\>",
      StripOnInput->False,
      LineColor->GrayLevel[0],
      FrontFaceColor->GrayLevel[0],
      BackFaceColor->GrayLevel[0],
      GraphicsColor->GrayLevel[0],
      FontSize->20,
      FontColor->GrayLevel[0]], {1.6, 1.3}]}, {
    GraphicsComplexBox[CompressedData["
1:eJxFV3k4ld3XJkORJmmQHClEFMmLUEuaUJE0oCinSfplbjAmIZWkQYRkToaT
NJGKSgMheTWY5ziD43meMx+nfM/vu76zP/+49rX3Xute932vdfajTfXfdXSK
jIzMclkZmf/+T19XEPt4PxeCXMwXb2SxYYu1vGNwLAcCjmoXWe4YA+L3LkOH
GwR0RFw4aI8zIZR9hO59CYfntUtpXb0M2EN32evzHwyEa/7xracwgBfzt/Vz
IhsSlBKnGVXQQR4boJlZsMAkulZ/TyYdHsf2v20ZosOtV1Wc6m46rLy7WN8+
dwRmq8bemAhhQGrtutDx8GHI0nKt6/Bign546IULkYNAizI+73mHBYu2PtvQ
+7gf7sS5LexTY4PPddnbbUv7IH6SF2PdOg7LA64EfHjcDUXea4fPDWBQ7BPe
vux5J4xsPMY2wXHIU1HSuuPZAT4xuXXRszhQpDxiFvKoHTT5MdZOFly0jsyb
77WNykPnTRcI2hZe4aN4T/asKfEpEqB8hMWhp0teCBGen3cpv8LLRQjv172n
rhlcF6N6NnbIdvg6TaB6vygFWBgxJhAfN5N/tmgclCC+dla/ul9dLEF8xriv
VfD/IkF8/7jtmnKxVoL0yJqMGjK7IkF6wdoEuxIDCdJzZeevE7zsCaT3wO+E
zX8IMUj90B8QNf3cMjFolMnfC+JyQU3wBQo8RRB74L1NmR0Xmvc/bv24UARX
Rg+O91/gQMUOx53Hc4TAkq3Y5tRBQIHcX628aULIT1e2eOBCQPYnDWWaqwCS
3wgmb7FwuBFhkf44gQ/vCqoa42g4zNgQfiyVxoO7//uHQ1Pjf/+4aP+aG2XN
FCYH3VfSpE6OzOag+OJvkdeZmwmUn5eSEcpPxhG+0W3ODqZCDOFvXDf6sTUa
Q/XF5za5c60xaJEfYl3P4IIB5pF82AuDS7lz7mwd4EBHnUZCzCsMrHkJmgtX
cYAdcNr79iYc7J283opTCBA+SZQPZOKQbnQhQ1OLgBiB/6cTJQQYVLj9TmzC
4YuVrTovkgO0+wZPZuXjUHaTd36E5Fm6HlPMV69Yx0Pnv3q5R+dr8FG8hbkG
rcZsPsqXO6ySok8TIDyl+jqWCnuECG9tW+ScBd1CVE/gw/VK5tYi8OC1zVYt
4oJ4TUFBUq0IAl7tPq6KkfqXXCyyuiqGxTdKrHqUOTCtv3yfyGECnjP2X9mj
QoD5FZO9O4cnYORkp9awCAO/zItzMXcJtKz4VtNYMQ5WjnSbAwUSiKjCav96
j4HR2S07RB8k4GFFrZwykwknlMN3zauWwPjMyZDE96OA6zpWMmMlMGBU1qJx
/Tesalomn68jgb57+yMrI4ZgKlGZsC1zArS9U73LUwfgctqLNQ1sMWw42clw
Z/SBq/BDRauWGCI+bdn+YqIHhnxgS/MaEfiwphRwn3RB68f6R3XGQii0spN0
KXVCkPm8Wlt1ARROFxrEKXaAW3e8uimfh/pd6jfpvt0r1ejjeRx0X/9wbLtb
NIHif279Sm87gaP8z008XL8cxRC+JLsHTdc4bIR/6ZS6L1l7xlB9es5vtTPF
TFT/zzTmCiadgfjZNZL1br8BA/FHpaxLmvaajvjt2lSYZvuAjvivzTpUFTZK
R/rsExuquJ5nIP0+U1rjb/owkb66gd8u2t5nIf0DOw0HXi9mI3/Al9GReWRc
Gd2Y9GfdLMQP3427SfYzF9wc1HiGOzCIP+97IkyVC66yMQ+KszAY8AtR/LOP
Aye9qHsOU3BYpJ8Qr1NJAF9HrWbNGxzuD24+QbUk4M3QmZLicwQcsNQPnt2N
A8PQJdFvKwcqc/Eax4c43ONdbg9ZxoX8TO/Ctiwcuk9YBoMCD/iGl92VyDhs
Z1+O5jAPUk6/avqlQMDu6ybPA6r5cCbETNISTEDO3tvOzGgB3A6/Z7ZGngP6
8+cYta0SQsKHyndqFRxYO2fIBGqEUFz+722KPxeypwhP/TUQgdU31l67Zi5c
Sqkk1K+LQOGPhNevywXqTFkP931iWP1737siEidvMNMpnDIBbT4/Pb46EVBR
Id+39P0EmKzMjs2zxeEHQ6GkaYMEvEBz/8hSDFg6T5M/p0rAMktQf1gwBrKK
OwLXv5eAcUruk4xcJvBXdxjakesWh4CMVbvpkB0gV/oveX7a4BHJ44Uj0EeL
ZPSS8WwebZ9wlQwBPVKtz5rMp+OXgKcpD8Kxqq74dBLPKnf7O4ud+uHGA/Ul
USRePY6OVXl2L3jJGs/SDRKBPe2jcrdpN1An1SqCgoVQ9K3HV+ZQJ6huyX/W
dkgAOonR+TNMO2CzeP1ZXVs+6g/dysB5iQt4sPyq/yNJRzuYtDd0e4yR8zev
4FrVkw74HDT3K+sTAZdXAKj80wVu0zVYMWU4tGb4eL3Z2wPG9Q6Ll+ZjsDvS
D1Lj+0A5x6loiDoOlN2F3z7pDEDXxplB8GwMYhN9Jxf/GQTGsXMtEfYseHWG
lx+n8BusDtwXUHWYMLPtmhPDdBQeR8wpNnRmQHyv9usToQwIOzVhS22ik3OP
/uJuIwviqU/6GnLoMPDjeH2D1jjo7OYfciX3s4rnV+s9wUA/1cR6Jnk/7T99
VZ31ONT4h6VbkPGn2kxWzG0mQObsw8BNZP7O8NJfdi/J91C23uaJp2MQpv66
of8C6f+kWTFGzuPIP+I7OYYZ/hjyl3fCMx+PDgz5L+hiwqkPvjjyp8hOwZG2
kED+3aJ8YlC/h0D+LnUwLgx/ykH+f23sredxm4v640/erFqdMzzUP+Wn7GcY
7uKj/up6upTNXiJA/ZcfEtdxtFOA+tPY2mKTebgQ9e/WtAUEWyxE/W23My7/
1HYRqtev9YabHCFCfFAdFAUaNWLE16KeukNnT08gPl96H2iMnCpBfCs6yUao
BkmQHgn+FPp4hQTptW8UDJ5+liA9uwY0QkfJfanedp3JdXLkfakfIpj1mj5k
fKlfdI95rt5P5pf6qfTszT7RGzHy2zyHoM3LR0XIjydbnCPP8oTIr3ZJUWXz
WQLk51a9+IbSb3zkd9/a5ur1pf//e3G6f3nsjBgu6pc99z2WhrhzUD8luPIG
60gdpP1mmR47oqeHo360SfO9ErIcQ/2qOjRJmMeyUT/71Ibq/uWxUL9TLZSD
q0uZaB6EfLfwCn7EQPOCcDHqvCrHQPPE4WtUJ62UjuaN6fK7O5+Ta+k8OkBv
mJNLnpfOq3jP5d2pZDzpPPvWZBA8RuaTzjvHk6IUGz4LzcOg+avPR5N4pfNy
rnx/4Xll8n3l8XD1DX0c2uxDih/UEVB0VdXznzgcwnturUoj3y09ckdPhzZj
0EPRTi2fxoEj5c6ffGMwoNaWjlIOcOCalreZZAvZn1SKo8YrDuweaGxfQ8Gg
8aIi5xCZd4H7P7anlTDUD9K19PdBer553q1CyxAeihdkEe4c1c1D+SzbWeVh
6/gIz6uwc1PoyXyE/+NO3XG8jY/wa1UrnJSVF8CY3HT/M1dxOCKztqpsiwDO
jTimnzHGwc2m6KVcqQCaXfgXu8h3IuPHetXD04WQEdVsmLYOg5iSqBsz3YVw
PGrxWI3POGSZ6Qd43RLC6AODlRvs2RA7vTNWrUoI6/2rVnZojYEkR2nG4Xoh
lBkHGXTxmJDBzJuFvxeC8G7t1JwWBhwMvWrXVSQEvCj1mc9zOvzdfs6n8pwQ
AvrZ0y3KRsG3992KRDMhzH6v8rfi5QiUmNpFf+kWwJLPtHdTh35DMrW+xvmM
AA7W7cr+vPI3/FoUf3mHjADSmy7wf2YMk77a9sY+ig8rclxUdq0ehmzZwI+K
HB74zqtZEIENgep3g+Dz3jxY8T2s40XHEHofSPcT6vz1Flly0X1xqv6/Nws5
KH6Ds1PnTg0Oyv8uau7s7XcJhE/ZoqXdYRmB8I8f26feXI2j+kxe/vCbcRRH
9Wdu117dvwRH/FgvmbnvNYYh/ibLeJeLvmOI3yzB9UTzFgzxPz/pjVpcH4b0
kRwJNLBWxJF+C9mLpl0l+0Sqb/k7j0vmSTjSf6Mn3pMyhiN/mN891MfcRUAg
bbK92oADWwNfMqbvxCE1bv3gzy8EjIwrn9ROx+Hp0MzFW23J7yNX5vk48vtU
ksL/4/SefA/lLDIMOkzAlAbHtGOeOCS3zmk4wiCAW1LnqqhKfv98smDWkd81
8Xa922sGMXhqY//bV4cL3WHbODptGNJDuj98wOXJqtM84P3f/Rut3rS2BXwU
X/nTpa9mj/go/yNBlN9ycwHCJ95MU1cjv3el+J8+TFp1blKA6nPV76VdcxBC
qEysaekvAqhT712W+yqEtmMutOvWBOgl58bCURG4dB8b/072U3OdtshuRATD
eyx+adZgYLTNjuK3Qww3o0pctv4ch49GftG3UsQwOy85vFWLDe+mqYUbkPPc
YgoNs/JmgZAemLnroxje2ARSFQoYQKH96zlQJobzb1RjHnJHYcnt2Plep8Uw
3yjIzct9BIKPbtERa4qh4UH135HOYfBp/Op266EIKEkrGo7HDgFlbGVL/iIR
dGT3jRt7DIJgdcRxqxAhvJ3ReTPj8ABQrjVp9lUJwCJDOI9V0A/4J0FV0jgf
sjj2/ka6/UD8+Um5o86HgzvU1TWG+iDz4466OBseWv9t3fZ9ricXnS/KeBsm
F81B8R5+y+lVLiZQvkiVxvCqXhzhyTuuaXpQF0d4I0pP1nOjMFTPkfRbF1T6
xlG9Tj6FjPUCNuKDp7xC8Szpcylfoh9Xz/r9HEN82h10Fl8rHEN8P9Kevq7v
+RjSo7h9r6nKNDbSqyuTxt+bxkZ6pj0cty07Mo70DlESqHmYYcgPFjcls+40
YPA/Vre+qQ==
     "], {{
       {GrayLevel[0.85], AbsoluteThickness[2.], Opacity[1], EdgeForm[None], 
        GraphicsGroupBox[PolygonBox[CompressedData["
1:eJxFVnfcz1UYPd/XyKpQxmu/VnvR1t57aO+ilMpokJSolBQpLU3tPTUopbSM
JEJLilCyM4oW5zjn/fjjvPeec8997ve+v3uf55Z16Na+awmAT4mKxDhiDfE5
0THtWmJ8uNq/iQnhU4iSApgarrYC+dfhE4l/iS/C1f5HTApXnH/iE59MgPO/
CldbFF5H/EtiXXziWqcix6eF/0DUIJ8ZPp2oTD4jXO0m5N+EryJak68O/56o
XjiOuOJWKhxH/FuiKvl34YpTpbAurnU3Jf8xXL5qheN2zL7/zz7E5duM47PC
1W5O/lP4XKIO+bzw2URt8jnharcg/yX8Z6JWYZ+49C0LxxFfQDQg/z1cceuS
zw//lahP/lu42tLC88Q1ryH5wvBFRGPyxeF/EC3IV4RLb0K+JFxtU/Kl4dpn
zcLfLb6MKCNfHi5fs8K6uPTmhdcR1zotyVeGq21V+HcV13c2Kvyd4vqdtyL/
M1z7rld43+KfEX/B4x2Irjl/j2kecRF8P+4jdobvi/wXEm3SH5dYinExfF8e
IHbMvDXxtImucd2rXTOmNdrCd68TfP/uJ3ZKv1O846OvjbdtYmnN3eC7dSl8
3x4itiMuge/bMGKH9KXtDt/BB+H7OjHasHgmJGbnjMu3feIqvu71HhnrnH75
Xdc37Amf/Yfh8z8p2mXh0rclHoHvt+7HXsS9+b2Un9hs+NOFTTs4N8h7ObE3
nBMejWdyNOWmbmz3hXNTl4zLtzU8Js9wtq3h37lI/mmXvs7APnAOGh7/lGiP
w/luatboHi69FZw7rmR7AJxDnoDzlfLWfsQV4dJbZi/r8n/YJrG6x1ue6zRn
fzg3PZk1pkV7Cs5307PmVeHSm8PfIr/mtYDPrc6szv0u8WrOgXCufBrOlzOi
XR0uvYx4Fs6Hyn8HE8/A+VB58SCiR7j0ZsTzcH5VPjw0Yz0yVzGUK6/JmDw9
E1/rNCWei0d59RDYKy69Sbw9MyZPr6yndRsTL8H5Vnn3COIFuF4o3x9GXBsu
vVH60g6Hc7ti9YpXc16E8/3MeNTvndhao3c0+RoS12V9fUeD9KUdCef+l+H8
Pyva9eHSS9OXdhScO1+F873y59HEDeHS6xF94Pz6Ctv66feJt7xWaM4x2Fhb
+rI9Fq4tr8P1ZU601+KZnTl9w6XXhdepmfqlb+yX+YpTh3gDrkeqS8cRN8H1
bYR8xI0Z3+BLX9rxcA0bEf/caOorxglwLdNa/RJba7wJ17d58dwcLr12+tJO
hGvBW3A9mB9NZ11nXmdZZ7p/xuWrRbwN10vVj/bErXC9fEe/FXFLxuWrmb60
k+DaehtcT0fpnMDzSlN/5RmVcdXdUzKmNU6Ga/IAuJ6P1FlKf0C85bVaa5wK
18J34Xq4MNodcH0ezbZaxgayPQ2ume/B9X1RNO29f/aqPQ/MHMWtQdwev+ZV
T1/a6dj4FtCaZ8Bvgffh98CSaKPjWZw5I7OnBdmzaoVqhmqDasSgzFecqsQH
8HtB74YziTvh98QY/ZbpSzsbfkvIO5jtWfAbY0w8y6J9CL83lmfOR/D7Ru+P
c4i7wqVXIobEr3mV0x8Sr+YMzpr6ziqZqxjnwm+Zu+H3zFj4Pa63zFC258Nv
Go3Jcx781vk4npXRhoZLr0B8Ar9vVyXG2MRYkTXvybh8JelLuwB+K6nuqv6u
jqb/9aD8b5dmTDVabyW9d9YDBGmCYg==
          "]]]}, {}, {}, {}, {}}, 
      {GrayLevel[0], Thickness[Large], 
       LineBox[{100, 49, 197, 98, 148, 1, 196, 97, 147, 2, 195, 96, 146, 3, 
        194, 95, 145, 4, 193, 94, 144, 5, 192, 93, 143, 6, 191, 92, 142, 7, 
        190, 91, 141, 8, 189, 90, 140, 9, 188, 89, 139, 10, 187, 88, 138, 11, 
        186, 87, 137, 12, 185, 86, 136, 13, 184, 85, 135, 14, 183, 84, 134, 
        15, 182, 83, 133, 16, 181, 82, 132, 17, 180, 81, 131, 18, 179, 80, 
        130, 19, 178, 79, 129, 20, 177, 78, 128, 21, 176, 77, 127, 22, 175, 
        76, 126, 23, 174, 75, 125, 24, 173, 74, 124, 25, 172, 73, 123, 26, 
        171, 72, 122, 27, 170, 71, 121, 28, 169, 70, 120, 29, 168, 69, 119, 
        30, 167, 68, 118, 31, 166, 67, 117, 32, 165, 66, 116, 33, 164, 65, 
        115, 34, 163, 64, 114, 35, 162, 63, 113, 36, 161, 62, 112, 37, 160, 
        61, 111, 38, 159, 60, 110, 39, 158, 59, 109, 40, 157, 58, 108, 41, 
        156, 57, 107, 42, 155, 56, 106, 43, 154, 55, 105, 44, 153, 54, 104, 
        45, 152, 53, 103, 46, 151, 52, 102, 47, 150, 51, 101, 48, 149, 50, 
        100}]}}], {}}, InsetBox[
    StyleBox["\<\"A\"\>",
     StripOnInput->False,
     LineColor->GrayLevel[0],
     FrontFaceColor->GrayLevel[0],
     BackFaceColor->GrayLevel[0],
     GraphicsColor->GrayLevel[0],
     FontSize->20,
     FontColor->GrayLevel[0]], {0.6, 1.3}]}]], "Output",
 CellChangeTimes->{3.947576680998258*^9, 3.95181592392108*^9, 
  3.9557693318497066`*^9},
 CellLabel->"Out[141]=",
 $CellContext`InitializationGroup -> 
 True,ExpressionUUID->"b9cc508f-7ffd-41bb-84e1-056f17053289"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Section 2", "Section"]], "Chapter",
 CellChangeTimes->{{3.551606318467031*^9, 3.5516063376815357`*^9}, {
   3.551606927739052*^9, 3.551606929779048*^9}, {3.551607356500638*^9, 
   3.551607362899152*^9}, {3.5516077024987803`*^9, 3.551607709561294*^9}, 
   3.9473904389895573`*^9, {3.9473935757603807`*^9, 3.947393577947782*^9}, 
   3.947576219236577*^9},
 $CellContext`InitializationGroup -> 
 True,ExpressionUUID->"a890b416-dac5-4b8c-817c-bc8678b16382"],

Cell[CellGroupData[{

Cell["c2s2Figure1", "Section",
 CellChangeTimes->{{3.5723420028690567`*^9, 3.572342011627058*^9}, {
   3.947391571097383*^9, 3.947391617058372*^9}, 3.9473923450883703`*^9, 
   3.947393236393119*^9, 3.947575060658597*^9, 3.94757673982978*^9},
 $CellContext`InitializationGroup -> 
 True,ExpressionUUID->"ade3dec2-f0b2-480c-a6c3-d8d24ff792fa"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"a", "=", " ", 
   RowBox[{"Disk", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{".9", ",", "1.3"}], "}"}], ",", "0.5"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"labA", "=", 
   RowBox[{"Text", "[", 
    RowBox[{
     RowBox[{"Style", "[", 
      RowBox[{"\"\<A\>\"", ",", "Black", ",", "20"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{".6", ",", "1.3"}], "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"b", "=", " ", 
   RowBox[{"Disk", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1.4", ",", "1.3"}], "}"}], ",", "0.4"}], "]"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"labB", "=", 
   RowBox[{"Text", "[", 
    RowBox[{
     RowBox[{"Style", "[", 
      RowBox[{"\"\<B\>\"", ",", "Black", ",", "20"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.6", ",", "1.3"}], "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rect", "=", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"EdgeForm", "[", 
       RowBox[{"Directive", "[", 
        RowBox[{"Thick", ",", "Black"}], "]"}], "]"}], ",", "White", ",", 
      RowBox[{"Rectangle", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0.", ",", "0."}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"3.", ",", "2."}], "}"}]}], "]"}]}], "}"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"bg", "=", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"EdgeForm", "[", 
       RowBox[{"Directive", "[", 
        RowBox[{"Thick", ",", "Black"}], "]"}], "]"}], ",", "White", ",", 
      RowBox[{"Rectangle", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0.", ",", "0."}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"3.", ",", "2."}], "}"}]}], "]"}], ",", 
      RowBox[{"Text", "[", 
       RowBox[{
        RowBox[{"Style", "[", 
         RowBox[{"\"\<\[CapitalOmega]\>\"", ",", "Black", ",", "24"}], "]"}], 
        ",", 
        RowBox[{"{", 
         RowBox[{"2.85", ",", "0.15"}], "}"}]}], "]"}], ",", "a", ",", "b", ",",
       ",", "labA", ",", "labB"}], "}"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"intersection", "=", 
   RowBox[{"RegionPlot", "[", 
    RowBox[{
     RowBox[{"BooleanRegion", "[", 
      RowBox[{"And", ",", 
       RowBox[{"{", 
        RowBox[{"a", ",", "b"}], "}"}]}], "]"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", "LightGray"}], ",", 
     RowBox[{"BoundaryStyle", "\[Rule]", 
      RowBox[{"Directive", "[", 
       RowBox[{"Black", ",", "Thick"}], "]"}]}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"c2s2Figure1", "=", 
  RowBox[{"Show", "[", 
   RowBox[{"bg", ",", "intersection"}], "]"}]}]}], "Input",
 CellLabel->"In[142]:=",
 $CellContext`InitializationGroup -> 
 True,ExpressionUUID->"12ef28d4-d3a2-443d-9a61-839f29bb4115"],

Cell[BoxData[
 GraphicsBox[{
   {GrayLevel[1], EdgeForm[{GrayLevel[0], Thickness[Large]}], 
    RectangleBox[{0., 0.}, {3., 2.}], InsetBox[
     StyleBox["\<\"\[CapitalOmega]\"\>",
      StripOnInput->False,
      LineColor->GrayLevel[0],
      FrontFaceColor->GrayLevel[0],
      BackFaceColor->GrayLevel[0],
      GraphicsColor->GrayLevel[0],
      FontSize->24,
      FontColor->GrayLevel[0]], {2.85, 0.15}], DiskBox[{0.9, 1.3}, 0.5], 
    DiskBox[{1.4, 1.3}, 0.4], InsetBox[
     StyleBox["\<\"A\"\>",
      StripOnInput->False,
      LineColor->GrayLevel[0],
      FrontFaceColor->GrayLevel[0],
      BackFaceColor->GrayLevel[0],
      GraphicsColor->GrayLevel[0],
      FontSize->20,
      FontColor->GrayLevel[0]], {0.6, 1.3}], InsetBox[
     StyleBox["\<\"B\"\>",
      StripOnInput->False,
      LineColor->GrayLevel[0],
      FrontFaceColor->GrayLevel[0],
      BackFaceColor->GrayLevel[0],
      GraphicsColor->GrayLevel[0],
      FontSize->20,
      FontColor->GrayLevel[0]], {1.6, 1.3}]}, {
    GraphicsComplexBox[CompressedData["
1:eJxFVgs0lVkbFidTpFwig65S7vfIpV4Spj+pTBciRSMkojCSWzRJoYtQqlNE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     "], {{
       {GrayLevel[0.85], AbsoluteThickness[2.], Opacity[1], EdgeForm[None], 
        GraphicsGroupBox[PolygonBox[CompressedData["
1:eJwNwwNbIwAYAOCu62wbXbZtfNk2lm3bNTSj2mr2qlULW2MNDf/pep/ndUUM
lCCcnZycNu+73EfJkIA+wgDuFA/IQzRgT3CAOd4G/BkBCAoiUJU02LneBeI5
CUgXZCBfUoByRYVtORbEDgnQVDsgsouBodsH1i0b6FoGMG9YsK8/ALaRAxwT
F4Q2Eexp6MA184Bn4QP/TgACqxB21XtwYGDCllSSnn/a/wMlzXDrOkS6S1Eg
yZR1unbKUG4djs0HWYddf7uP0B7ZR91/jrI9MT3HGM+c457fxzle27JMd2SG
dOtfr3zbS57rjT3J88ENnOF98076fp7m++L7T3E+BWcD388K/AhF50Nf+06w
3oMKgl+hYvCbotCfOHRO9M+V9/46LwogDV+QAoovhr+MXJIDSy5HPl+WBFFG
ryhBpVejn65Kg6ljSmpwmXLso7IshDauooWUq8Y/qMpDdyaud0IrrifeX1eE
7U6qd8Mq1ZPv1JXhe1OavfAqzdRbTVUEfVpLj6jWTr/RVkcyZnSMyBrdzGtd
TdT+rH4/qlY/+0pfG30wZziIvigOJNcZ5l7O3zBjbupjWYtGdlz9zfyL24Y4
9sItK7bRuPjM2BjPaTYvP1mx8BKXTJz4JtPSU1NTAnfZzE1ouF14bm5O5CEs
K48NdTHMlrvVR6t3/KS7lmRBq3XNZc0qSLa2pggPszzQ6zZhyqZDnGZBJPFt
bamiDbsotd2+4WxvTxO32dYfOjrSJf8B2HkIow==
          "]]]}, {}, {}, {}, {}}, 
      {GrayLevel[0], Thickness[Large], 
       LineBox[{70, 34, 137, 68, 103, 1, 136, 67, 102, 2, 135, 66, 101, 3, 
        134, 65, 100, 4, 133, 64, 99, 5, 132, 63, 98, 6, 131, 62, 97, 7, 130, 
        61, 96, 8, 129, 60, 95, 9, 128, 59, 94, 10, 127, 58, 93, 11, 126, 57, 
        92, 12, 125, 56, 91, 13, 124, 55, 90, 14, 123, 54, 89, 15, 122, 53, 
        88, 16, 121, 52, 87, 17, 120, 51, 86, 18, 119, 50, 85, 19, 118, 49, 
        84, 20, 117, 48, 83, 21, 116, 47, 82, 22, 115, 46, 81, 23, 114, 45, 
        80, 24, 113, 44, 79, 25, 112, 43, 78, 26, 111, 42, 77, 27, 110, 41, 
        76, 28, 109, 40, 75, 29, 108, 39, 74, 30, 107, 38, 73, 31, 106, 37, 
        72, 32, 105, 36, 71, 33, 104, 35, 70}]}}], {}}}]], "Output",
 CellChangeTimes->{3.947576991938446*^9, 3.951815996740526*^9, 
  3.955769331876863*^9},
 CellLabel->"Out[149]=",
 $CellContext`InitializationGroup -> 
 True,ExpressionUUID->"661d813d-e6d6-48b5-9aea-244b8f3c3991"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["c2s2Figure2", "Section",
 CellChangeTimes->{{3.5723420028690567`*^9, 3.572342011627058*^9}, {
   3.947391571097383*^9, 3.947391617058372*^9}, 3.9473923450883703`*^9, 
   3.947393236393119*^9, 3.947575060658597*^9, 3.94757673982978*^9, 
   3.947576818368909*^9},
 $CellContext`InitializationGroup -> 
 True,ExpressionUUID->"83c1b029-6559-47e3-9816-38439ceab298"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ProbabilityOfBeingSick", "[", 
    RowBox[{
    "prior_", ",", "recogdisease_", ",", "recoghealth_", ",", "ntot_"}], 
    "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "res", ",", "nsick", ",", "nhealthy", ",", "rightpositive", ",", 
       "rightnegative", ",", "\[IndentingNewLine]", "wrongpositive", ",", 
       "wrongnegative", ",", " ", "a11", ",", "a12", ",", "a13", ",", "a21", ",",
        "a22", ",", "a23", ",", "outstring"}], "}"}], ",", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"a13", "=", 
       RowBox[{"nsick", "=", " ", 
        RowBox[{"Round", "[", 
         RowBox[{"ntot", " ", "prior"}], "]"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"a23", "=", 
       RowBox[{"nhealthy", "=", " ", 
        RowBox[{"Round", "[", 
         RowBox[{"ntot", "-", " ", "nsick"}], "]"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"a11", "=", 
       RowBox[{"rightpositive", "=", " ", 
        RowBox[{"Round", "[", 
         RowBox[{"nsick", " ", "recogdisease"}], " ", "]"}]}]}], ";", " ", 
      "\[IndentingNewLine]", 
      RowBox[{"a12", "=", 
       RowBox[{"wrongnegative", "=", " ", 
        RowBox[{"Round", "[", 
         RowBox[{"nsick", " ", "-", " ", "rightpositive"}], "]"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"a22", " ", "=", 
       RowBox[{"rightnegative", " ", "=", " ", 
        RowBox[{"Round", "[", 
         RowBox[{"nhealthy", " ", "recoghealth"}], "]"}]}]}], ";", " ", 
      "\[IndentingNewLine]", 
      RowBox[{"a21", "=", 
       RowBox[{"wrongpositive", "=", " ", 
        RowBox[{"Round", "[", 
         RowBox[{"nhealthy", " ", "-", " ", "rightnegative"}], "]"}]}]}], ";",
       "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"a11", "+", "a21"}], ">", "0"}], ",", 
        RowBox[{"outstring", " ", "=", " ", 
         RowBox[{"\"\<P(sick|positive test): \>\"", "<>", 
          RowBox[{"ToString", "[", "a11", "]"}], "<>", "\"\</\>\"", "<>", 
          RowBox[{"ToString", "[", 
           RowBox[{"a11", "+", "a21"}], "]"}], "<>", "\"\< = \>\"", "<>", 
          RowBox[{"ToString", "[", 
           RowBox[{"N", "[", 
            RowBox[{"a11", "/", 
             RowBox[{"(", 
              RowBox[{"a11", "+", "a21"}], ")"}]}], "]"}], "]"}]}]}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{
        "outstring", " ", "=", " ", "\"\<P(sick|positive test): 0\>\""}]}], 
       "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"res", "=", 
       RowBox[{"Grid", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            
            RowBox[{"\"\<Probability of being sick after having \
tested\\npositive for a disease: P(sick|positive test)\>\"", ",", 
             "SpanFromLeft"}], "}"}], ",", 
           RowBox[{"{", 
            
            RowBox[{"\"\<\>\"", ",", "\"\<positive test\>\"", 
             ",", "\"\<negative test\>\"", ",", "\"\<Total\>\""}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"\"\<sick\>\"", ",", "a11", ",", 
             RowBox[{"Item", "[", 
              RowBox[{"a12", ",", 
               RowBox[{"Background", "\[Rule]", "LightRed"}]}], "]"}], ",", 
             "a13"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"\"\<healthy\>\"", ",", 
             RowBox[{"Item", "[", 
              RowBox[{"a21", ",", 
               RowBox[{"Background", "\[Rule]", "LightYellow"}]}], "]"}], ",",
              "a22", ",", "a23"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"\"\<Total\>\"", ",", 
             RowBox[{"a11", "+", "a21"}], ",", 
             RowBox[{"a12", "+", "a22"}], ",", 
             RowBox[{"a11", "+", "a12", "+", "a21", "+", "a22"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"\"\< \>\"", ",", "SpanFromLeft"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"Item", "[", "outstring", "]"}], ",", "SpanFromLeft"}], 
            "}"}]}], "}"}], ",", 
         RowBox[{"Frame", "\[Rule]", "All"}], ",", 
         RowBox[{"ItemSize", "\[Rule]", "7"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Return", "[", 
       RowBox[{"Text", " ", "@", " ", "res"}], "]"}], ";"}]}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{
  3.35696210375764*^9, {3.439833000173912*^9, 3.439833003373694*^9}, {
   3.44021133278951*^9, 3.440211342348435*^9}, {3.440211438818808*^9, 
   3.440211441360989*^9}, {3.44021149054255*^9, 3.4402116205706778`*^9}, 
   3.440211748263135*^9, {3.440211809314609*^9, 3.4402118128506317`*^9}},
 CellLabel->"In[150]:=",
 CellID->1038874391,
 $CellContext`InitializationGroup -> 
 True,ExpressionUUID->"94b512b6-9bb6-4dee-b707-1adfb7f2f245"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"c2s2Figure2", "=", 
  RowBox[{"Manipulate", "[", 
   RowBox[{
    RowBox[{"ProbabilityOfBeingSick", "[", 
     RowBox[{"prior", ",", "recogdisease", ",", "recoghealth", ",", "ntot"}], 
     "]"}], ",", 
    "\[IndentingNewLine]", "\"\<How good is the test in detecting the \
disease?\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "recogdisease", ",", "0.95", ",", "\"\<P(positive test| sick):\>\""}], 
       "}"}], ",", "0", ",", "1.", ",", 
      RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}], ",", 
    "\[IndentingNewLine]", "\"\<How good is the test in detecting the absence \
of the disease?\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "recoghealth", ",", "0.9", ",", "\"\<P(negative test| healthy):\>\""}],
        "}"}], ",", "0", ",", "1.", ",", 
      RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}], ",", 
    "\[IndentingNewLine]", "Delimiter", ",", 
    "\[IndentingNewLine]", "\"\<How likely is the disease?\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"prior", ",", "0.01", ",", "\"\<P(disease)\>\""}], "}"}], ",", 
      "0.", ",", "1.", ",", 
      RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}], ",", 
    "\[IndentingNewLine]", "Delimiter", ",", 
    "\[IndentingNewLine]", "\"\<Number of people for reference\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"ntot", ",", "3000", ",", "\"\<N\>\""}], "}"}], ",", "1", ",", 
      "10000", ",", "1", ",", 
      RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"ControlPlacement", "\[Rule]", "Top"}], ",", 
    RowBox[{"SaveDefinitions", "\[Rule]", "True"}]}], "\[IndentingNewLine]", 
   "]"}]}]], "Input",
 CellChangeTimes->{
  3.35696210375764*^9, 3.4396509638266172`*^9, {3.439654136582481*^9, 
   3.4396542173316107`*^9}, {3.439654259765335*^9, 3.4396542600420237`*^9}, 
   3.4396543065977287`*^9, 3.439654458549364*^9, {3.439654493154024*^9, 
   3.439654516581482*^9}, {3.43982545271875*^9, 3.439825486546875*^9}, 
   3.4398331214131193`*^9, {3.4400224031675596`*^9, 3.4400224053081846`*^9}, {
   3.5521338849412537`*^9, 3.552133888248808*^9}, 3.552136879312202*^9},
 CellLabel->"In[151]:=",
 $CellContext`InitializationGroup -> 
 True,ExpressionUUID->"b48c12d4-a6b0-44aa-9bcd-f56c8f21f8f5"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`ntot$$ = 100, $CellContext`prior$$ = 
    0.01, $CellContext`recogdisease$$ = 0.95, $CellContext`recoghealth$$ = 
    0.9, Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{
      Hold["How good is the test in detecting the disease?"], 
      Manipulate`Dump`ThisIsNotAControl, ControlType -> None}, {{
       Hold[$CellContext`recogdisease$$], 0.95, "P(positive test| sick):"}, 0,
       1., ControlType -> Manipulator}, {
      Hold["How good is the test in detecting the absence of the disease?"], 
      Manipulate`Dump`ThisIsNotAControl, ControlType -> None}, {{
       Hold[$CellContext`recoghealth$$], 0.9, "P(negative test| healthy):"}, 
      0, 1., ControlType -> Manipulator}, {
      Hold["How likely is the disease?"], Manipulate`Dump`ThisIsNotAControl, 
      ControlType -> None}, {{
       Hold[$CellContext`prior$$], 0.01, "P(disease)"}, 0., 1., ControlType -> 
      Manipulator}, {
      Hold["Number of people for reference"], 
      Manipulate`Dump`ThisIsNotAControl, ControlType -> None}, {{
       Hold[$CellContext`ntot$$], 3000, "N"}, 1, 10000, 1, ControlType -> 
      Manipulator}}, Typeset`size$$ = {
    329.01484374999995`, {71.441943359375, 78.157763671875}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = False, 
    Typeset`keyframeActionsQ$$ = False, Typeset`keyframeList$$ = {}}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`ntot$$ = 3000, $CellContext`prior$$ = 
        0.01, $CellContext`recogdisease$$ = 0.95, $CellContext`recoghealth$$ = 
        0.9}, "ControllerVariables" :> {}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$, Typeset`keyframeActionsQ$$, 
        Typeset`keyframeList$$}, 
      "Body" :> $CellContext`ProbabilityOfBeingSick[$CellContext`prior$$, \
$CellContext`recogdisease$$, $CellContext`recoghealth$$, $CellContext`ntot$$],
       "Specifications" :> {
       "How good is the test in detecting the disease?", \
{{$CellContext`recogdisease$$, 0.95, "P(positive test| sick):"}, 0, 1., 
         Appearance -> "Labeled"}, 
        "How good is the test in detecting the absence of the disease?", \
{{$CellContext`recoghealth$$, 0.9, "P(negative test| healthy):"}, 0, 1., 
         Appearance -> "Labeled"}, Delimiter, 
        "How likely is the disease?", {{$CellContext`prior$$, 0.01, 
          "P(disease)"}, 0., 1., Appearance -> "Labeled"}, Delimiter, 
        "Number of people for reference", {{$CellContext`ntot$$, 3000, "N"}, 
         1, 10000, 1, Appearance -> "Labeled"}}, 
      "Options" :> {ControlPlacement -> Top}, "DefaultOptions" :> {}],
     ImageSizeCache->{391.2990625, {202.32550354003905`, 208.05743713378905`}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    Initialization:>({$CellContext`ProbabilityOfBeingSick[
         Pattern[$CellContext`prior, 
          Blank[]], 
         Pattern[$CellContext`recogdisease, 
          Blank[]], 
         Pattern[$CellContext`recoghealth, 
          Blank[]], 
         Pattern[$CellContext`ntot, 
          Blank[]]] := 
       Module[{$CellContext`res, $CellContext`nsick, $CellContext`nhealthy, \
$CellContext`rightpositive, $CellContext`rightnegative, \
$CellContext`wrongpositive, $CellContext`wrongnegative, $CellContext`a11, \
$CellContext`a12, $CellContext`a13, $CellContext`a21, $CellContext`a22, \
$CellContext`a23, $CellContext`outstring}, $CellContext`a13 = \
($CellContext`nsick = 
           Round[$CellContext`ntot $CellContext`prior]); $CellContext`a23 = \
($CellContext`nhealthy = 
           Round[$CellContext`ntot - $CellContext`nsick]); $CellContext`a11 = \
($CellContext`rightpositive = 
           Round[$CellContext`nsick $CellContext`recogdisease]); \
$CellContext`a12 = ($CellContext`wrongnegative = 
           Round[$CellContext`nsick - $CellContext`rightpositive]); \
$CellContext`a22 = ($CellContext`rightnegative = 
           Round[$CellContext`nhealthy $CellContext`recoghealth]); \
$CellContext`a21 = ($CellContext`wrongpositive = 
           Round[$CellContext`nhealthy - $CellContext`rightnegative]); 
         If[$CellContext`a11 + $CellContext`a21 > 
           0, $CellContext`outstring = (((("P(sick|positive test): " <> 
                ToString[$CellContext`a11]) <> "/") <> 
              ToString[$CellContext`a11 + $CellContext`a21]) <> " = ") <> 
            ToString[
              
              N[$CellContext`a11/($CellContext`a11 + $CellContext`a21)]], \
$CellContext`outstring = "P(sick|positive test): 0"]; $CellContext`res = 
          Grid[{{"Probability of being sick after having tested\npositive for \
a disease: P(sick|positive test)", SpanFromLeft}, {
             "", "positive test", "negative test", "Total"}, {
             "sick", $CellContext`a11, 
              
              Item[$CellContext`a12, Background -> 
               LightRed], $CellContext`a13}, {"healthy", 
              
              Item[$CellContext`a21, Background -> 
               LightYellow], $CellContext`a22, $CellContext`a23}, {
             "Total", $CellContext`a11 + $CellContext`a21, $CellContext`a12 + \
$CellContext`a22, $CellContext`a11 + $CellContext`a12 + $CellContext`a21 + \
$CellContext`a22}, {" ", SpanFromLeft}, {
              Item[$CellContext`outstring], SpanFromLeft}}, Frame -> All, 
            ItemSize -> 7]; Return[
           Text[$CellContext`res]]; Null], $CellContext`ntot$$ = 
       100, $CellContext`res = 
       Grid[{{"Probabilities for IAFC-infection.", SpanFromLeft}, {
          "", "positive test", "negative test", "Marginals"}, {
          "IAFC-infected", 0.009, 
           Item[0.0001, Background -> RGBColor[1, 0.85, 0.85]], 0.001}, {
          "Healthy", 
           Item[0.00999, Background -> RGBColor[1, 1, 0.85]], 0.98901, 
           0.999}, {"Total", 0.01089, 0.98911, 1.}, {" ", SpanFromLeft}}, 
         Frame -> All, ItemSize -> 7]}; Typeset`initDone$$ = True),
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{3.9475769920280247`*^9, 3.951815996788786*^9, 
  3.9557693318908043`*^9},
 CellLabel->"Out[151]=",
 $CellContext`InitializationGroup -> 
 True,ExpressionUUID->"9940fa76-9d9b-4c58-bcc1-2e6a8509caa0"]
}, Open  ]],

Cell["\<\
For rare diseases, people tend to intuitively overestimate the probability of \
being sick after having received a positive test result. This probability is \
calculated using Bayes's theorem from some of the conditional probabilities \
involved in the scenario. Understanding these probabilities, such as the \
probability of being sick when having received a positive test result, \
expressed as P(sick| positive test), can become easier using a contingency \
table like the one shown. Given properties of the test, the probability of \
the disease, and the size of the reference group, the table shows the number \
of people falling into the four different possible categories. The \
conditional probability of being sick after having received a positive test \
result is simply the ratio of the people that are sick and that have tested \
positive to the total number of people having tested positive.\
\>", "Text",
 $CellContext`InitializationGroup -> 
 True,ExpressionUUID->"74f57098-3644-4dd8-914b-9a774a521a61"],

Cell["\<\
Even very good medical tests for diseases have\[LongDash]usually very small\
\[LongDash]probabilities for false positive and false negative results. For \
rare diseases, the number of healthy people getting a false positive test \
(light yellow background) can become much larger than the number of sick \
people getting a positive test (pink background).\
\>", "Text",
 $CellContext`InitializationGroup -> 
 True,ExpressionUUID->"df9ea19d-3baf-4b55-85ad-147514e49650"],

Cell["Recommended reading on the subject:", "Text",
 $CellContext`InitializationGroup -> 
 True,ExpressionUUID->"924a8344-b634-4c96-bca2-63375deba649"],

Cell[TextData[{
 "G. Gigerenzer, ",
 StyleBox["Reckoning with Risk: Learning to Live with Uncertainty",
  FontSlant->"Italic"],
 ", London, UK: Penguin, 2002."
}], "Text",
 $CellContext`InitializationGroup -> 
 True,ExpressionUUID->"ae8facca-4ee9-4c42-bd05-471679fd442f"],

Cell["\<\
\"Probability of Being Sick After Having Tested Positive for a Disease \
(Bayes's Rule)\" from the Wolfram Demonstrations Project
 http://demonstrations.wolfram.com/\
ProbabilityOfBeingSickAfterHavingTestedPositiveForADiseaseBa/
Contributed by: Frank Scherbaum
After work by: Gerd Gigerenzer\
\>", "Text",
 $CellContext`InitializationGroup -> 
 True,ExpressionUUID->"b849f007-6b7e-4418-a7b3-6c9a70e47668"]
}, Open  ]],

Cell[CellGroupData[{

Cell["c2s2Table1", "Section",
 CellChangeTimes->{{3.5723420028690567`*^9, 3.572342011627058*^9}, {
   3.947391571097383*^9, 3.947391617058372*^9}, 3.9473923450883703`*^9, 
   3.947393236393119*^9, 3.947575060658597*^9, 3.94757673982978*^9, 
   3.9475768749673862`*^9},
 $CellContext`InitializationGroup -> 
 True,ExpressionUUID->"11749dba-2b08-4cc2-a41e-0edcca2ca35e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"c2s2Table1", "=", " ", 
   RowBox[{"Text", "@", 
    RowBox[{"Grid", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"\"\<Probabilities for IAFC-infection.\>\"", ",", 
          "SpanFromLeft"}], "}"}], ",", " ", 
        RowBox[{"{", 
         RowBox[{"\"\<\>\"", ",", " ", "\"\<positive test\>\"", ",", 
          " ", "\"\<negative test\>\"", ",", " ", "\"\<Marginals\>\""}], 
         "}"}], ",", " ", 
        RowBox[{"{", 
         RowBox[{"\"\<IAFC-infected\>\"", ",", "0.009", ",", " ", 
          RowBox[{"Item", "[", "0.0001", "]"}], ",", " ", "0.001"}], "}"}], ",",
         " ", 
        RowBox[{"{", 
         RowBox[{"\"\<Healthy\>\"", ",", " ", 
          RowBox[{"Item", "[", "0.00999", "]"}], ",", " ", "0.98901", ",", 
          "0.999"}], "}"}], ",", " ", 
        RowBox[{"{", 
         RowBox[{"\"\<Total\>\"", ",", " ", "0.01089", ",", "0.98911", ",", 
          " ", "1.000"}], "}"}], ",", " ", 
        RowBox[{"{", 
         RowBox[{"\"\< \>\"", ",", " ", "SpanFromLeft"}], "}"}]}], "}"}], ",",
       " ", 
      RowBox[{"Frame", " ", "->", " ", "All"}], ",", " ", 
      RowBox[{"ItemSize", " ", "->", " ", "7"}]}], "]"}]}]}], "\n"}]], "Input",\

 CellChangeTimes->{{3.5521348143765497`*^9, 3.552134819567934*^9}, {
  3.552134891812051*^9, 3.552135055450034*^9}, {3.552135096204897*^9, 
  3.5521352357065697`*^9}, {3.5521355034551287`*^9, 3.5521355104867353`*^9}},
 CellLabel->"In[152]:=",
 $CellContext`InitializationGroup -> 
 True,ExpressionUUID->"16454c3b-dc20-414c-be25-331e6ed14021"],

Cell[BoxData[
 InterpretationBox[Cell[BoxData[
   FormBox[
    TagBox[GridBox[{
       {"\<\"Probabilities for IAFC-infection.\"\>", "\[SpanFromLeft]", 
        "\[SpanFromLeft]", "\[SpanFromLeft]"},
       {"\<\"\"\>", "\<\"positive test\"\>", "\<\"negative test\"\>", \
"\<\"Marginals\"\>"},
       {"\<\"IAFC-infected\"\>", "0.009`", 
        ItemBox["0.0001`",
         StripOnInput->False], "0.001`"},
       {"\<\"Healthy\"\>", 
        ItemBox["0.00999`",
         StripOnInput->False], "0.98901`", "0.999`"},
       {"\<\"Total\"\>", "0.01089`", "0.98911`", "1.`"},
       {"\<\" \"\>", "\[SpanFromLeft]", "\[SpanFromLeft]", "\[SpanFromLeft]"}
      },
      AutoDelete->False,
      GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}},
      GridBoxItemSize->{"Columns" -> {{7}}}],
     "Grid"], TextForm]], "InlineText",ExpressionUUID->
   "216595df-c678-4bb6-afb2-1789f44de7dd"],
  Text[
   Grid[{{"Probabilities for IAFC-infection.", SpanFromLeft}, {
     "", "positive test", "negative test", "Marginals"}, {
     "IAFC-infected", 0.009, 
      Item[0.0001], 0.001}, {"Healthy", 
      Item[0.00999], 0.98901, 0.999}, {"Total", 0.01089, 0.98911, 1.}, {
     " ", SpanFromLeft}}, Frame -> All, ItemSize -> 7]]]], "Output",
 CellChangeTimes->{3.9475769920643597`*^9, 3.95181599681693*^9, 
  3.955769331919848*^9},
 CellLabel->"Out[152]=",
 $CellContext`InitializationGroup -> 
 True,ExpressionUUID->"ee64bd5a-805e-42a6-80c1-843724962aff"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["c2s2Table2", "Section",
 CellChangeTimes->{{3.5723420028690567`*^9, 3.572342011627058*^9}, {
   3.947391571097383*^9, 3.947391617058372*^9}, 3.9473923450883703`*^9, 
   3.947393236393119*^9, 3.947575060658597*^9, 3.94757673982978*^9, 
   3.9475768904690332`*^9},
 $CellContext`InitializationGroup -> 
 True,ExpressionUUID->"91341419-04c7-47f2-b054-5c7e6cf07892"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"c2s2Table2", "=", " ", 
   RowBox[{"Text", "@", 
    RowBox[{"Grid", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"\"\<Natural frequencies for IAFC-infection.\>\"", ",", 
          "SpanFromLeft"}], "}"}], ",", " ", 
        RowBox[{"{", 
         RowBox[{"\"\<\>\"", ",", " ", "\"\<positive test\>\"", ",", 
          " ", "\"\<negative test\>\"", ",", " ", "\"\<Sum\>\""}], "}"}], ",",
         " ", 
        RowBox[{"{", 
         RowBox[{"\"\<IAFC-infected\>\"", ",", 
          RowBox[{"Item", "[", 
           RowBox[{"9", ",", " ", 
            RowBox[{"Background", " ", "->", " ", "LightGray"}]}], "]"}], ",",
           " ", 
          RowBox[{"Item", "[", "1", "]"}], ",", " ", "10"}], "}"}], ",", " ", 
        
        RowBox[{"{", 
         RowBox[{"\"\<Healthy\>\"", ",", " ", 
          RowBox[{"Item", "[", "\"\<\[TildeTilde]100\>\"", "]"}], ",", 
          " ", "\"\<\[TildeTilde]9890\>\"", 
          ",", "\"\<\[TildeTilde]9990\>\""}], "}"}], ",", " ", 
        RowBox[{"{", 
         RowBox[{"\"\<Total\>\"", ",", " ", 
          RowBox[{"Item", "[", 
           RowBox[{"\"\<\[TildeTilde]109\>\"", ",", " ", 
            RowBox[{"Background", " ", "->", " ", "LightGray"}]}], "]"}], 
          ",", "\"\<\[TildeTilde]9891\>\"", 
          ",", "\"\<\[TildeTilde]10000\>\""}], "}"}], ",", " ", 
        RowBox[{"{", 
         RowBox[{"\"\< \>\"", ",", " ", "SpanFromLeft"}], "}"}]}], "}"}], ",",
       " ", 
      RowBox[{"Frame", " ", "->", " ", "All"}], ",", " ", 
      RowBox[{"ItemSize", " ", "->", " ", "7"}]}], "]"}]}]}], "\n"}]], "Input",\

 CellChangeTimes->{{3.5521348143765497`*^9, 3.552134819567934*^9}, {
   3.552134891812051*^9, 3.552135055450034*^9}, {3.552135096204897*^9, 
   3.5521352357065697`*^9}, 3.552135493826015*^9, {3.552135645771021*^9, 
   3.552135671644115*^9}, {3.5521357092006273`*^9, 3.5521358513199587`*^9}, {
   3.5521359044357347`*^9, 3.552135913455946*^9}, {3.552135945928618*^9, 
   3.5521359872831697`*^9}},
 CellLabel->"In[153]:=",
 $CellContext`InitializationGroup -> 
 True,ExpressionUUID->"550cce58-07b8-4910-a575-0894e8bb8098"],

Cell[BoxData[
 InterpretationBox[Cell[BoxData[
   FormBox[
    TagBox[GridBox[{
       {"\<\"Natural frequencies for IAFC-infection.\"\>", "\[SpanFromLeft]", 
        "\[SpanFromLeft]", "\[SpanFromLeft]"},
       {"\<\"\"\>", "\<\"positive test\"\>", "\<\"negative test\"\>", \
"\<\"Sum\"\>"},
       {"\<\"IAFC-infected\"\>", 
        ItemBox["9",
         Background->GrayLevel[0.85],
         StripOnInput->False], 
        ItemBox["1",
         StripOnInput->False], "10"},
       {"\<\"Healthy\"\>", 
        ItemBox["\<\"\[TildeTilde]100\"\>",
         StripOnInput->
          False], "\<\"\[TildeTilde]9890\"\>", "\<\"\[TildeTilde]9990\"\>"},
       {"\<\"Total\"\>", 
        ItemBox["\<\"\[TildeTilde]109\"\>",
         Background->GrayLevel[0.85],
         StripOnInput->
          False], "\<\"\[TildeTilde]9891\"\>", "\<\"\[TildeTilde]10000\"\>"},
       {"\<\" \"\>", "\[SpanFromLeft]", "\[SpanFromLeft]", "\[SpanFromLeft]"}
      },
      AutoDelete->False,
      GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}},
      GridBoxItemSize->{"Columns" -> {{7}}}],
     "Grid"], TextForm]], "InlineText",ExpressionUUID->
   "81fcc80f-3047-49a4-8e53-6c7be2ab700b"],
  Text[
   Grid[{{"Natural frequencies for IAFC-infection.", SpanFromLeft}, {
     "", "positive test", "negative test", "Sum"}, {"IAFC-infected", 
      Item[9, Background -> GrayLevel[0.85]], 
      Item[1], 10}, {"Healthy", 
      Item["\[TildeTilde]100"], "\[TildeTilde]9890", "\[TildeTilde]9990"}, {
     "Total", 
      Item["\[TildeTilde]109", Background -> GrayLevel[0.85]], 
      "\[TildeTilde]9891", "\[TildeTilde]10000"}, {" ", SpanFromLeft}}, Frame -> 
    All, ItemSize -> 7]]]], "Output",
 CellChangeTimes->{3