(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Wolfram 14.2' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       154,          7]
NotebookDataLength[  23324748,     417387]
NotebookOptionsPosition[  23284220,     416767]
NotebookOutlinePosition[  23284617,     416783]
CellTagsIndexPosition[  23284574,     416780]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "Chapter 4 Figures for ",
 StyleBox["Fundamental Concepts of \nProbabilistic Seismic Hazard Analysis", 
  "Subtitle",
  FontSize->48]
}], "Title",
 CellChangeTimes->{{3.947391415550271*^9, 3.947391424639997*^9}, 
   3.947393193223259*^9, {3.947575011347905*^9, 3.9475750117033157`*^9}, 
   3.9476544237524347`*^9, 3.95181694800498*^9, {3.9518169816366777`*^9, 
   3.951816985550569*^9}, {3.9557924629231787`*^9, 3.955792463388468*^9}},
 $CellContext`InitializationGroup -> 
 True,ExpressionUUID->"8e805505-12fd-4a21-940f-d3af8460f1b1"],

Cell[TextData[{
 "\nThe outermost cell of this notebook is defined  as",
 StyleBox[" Initialization Group ",
  FontSlant->"Italic"],
 "so that all figures, some of which may depend on previously generated ones, \
are produced in the proper sequence."
}], "Text",
 CellChangeTimes->{{3.951733887645832*^9, 3.951733900624896*^9}, {
  3.951789880822382*^9, 3.951789882112493*^9}, {3.9557694079288607`*^9, 
  3.9557695585520773`*^9}, {3.955769617637073*^9, 3.95576961819106*^9}},
 $CellContext`InitializationGroup -> 
 True,ExpressionUUID->"b15231ce-9e66-41e7-87d3-491a951169ac"],

Cell[CellGroupData[{

Cell["Warranty Disclaimer", "Section",
 CellChangeTimes->{{3.95162435258323*^9, 3.951624383820673*^9}, {
  3.9516668189919157`*^9, 3.951666836375389*^9}, {3.951718418324568*^9, 
  3.951718418763173*^9}, {3.951730306823305*^9, 3.951730313723783*^9}, {
  3.95173243157547*^9, 3.9517324338531847`*^9}, {3.951733794512895*^9, 
  3.9517337992616243`*^9}},
 $CellContext`InitializationGroup -> 
 True,ExpressionUUID->"fcd79155-82c1-4b91-a6b5-58c44e7c1b05"],

Cell["\<\

This software is provided \[OpenCurlyDoubleQuote]as is,\
\[CloseCurlyDoubleQuote] without any express or implied warranties, including \
but not limited to warranties of merchantability, fitness for a particular \
purpose, or non-infringement. In no event shall the author be liable for any \
claim, damages, or other liability arising from the use or inability to use \
this software. Use at your own risk.\
\>", "Text",
 CellChangeTimes->{{3.951733887645832*^9, 3.951733900624896*^9}, {
  3.951789880822382*^9, 3.951789882112493*^9}},
 $CellContext`InitializationGroup -> 
 True,ExpressionUUID->"5736372e-2ce9-4e8f-b1a8-47897d15fc98"]
}, Open  ]],

Cell[CellGroupData[{

Cell["General definitions", "Section",
 CellChangeTimes->{{3.5723397514739923`*^9, 3.5723397663929567`*^9}, {
   3.947393424561935*^9, 3.947393447165543*^9}, {3.947397145993101*^9, 
   3.947397154149987*^9}, 3.9474033249834642`*^9, 3.94740884697871*^9, {
   3.955778311455771*^9, 3.9557783153232937`*^9}},
 $CellContext`InitializationGroup -> 
 True,ExpressionUUID->"10c6c766-0840-483c-9b56-2edd8b2fc2c7"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"barstyle", "=", 
   RowBox[{
    RowBox[{"ColorData", "[", "\"\<HTML\>\"", "]"}], 
    "[", "\"\<LightSteelBlue\>\"", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetOptions", "[", 
   RowBox[{"Histogram", ",", " ", 
    RowBox[{"ChartStyle", "->", "barstyle"}]}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetOptions", "[", 
   RowBox[{"BarChart", ",", " ", 
    RowBox[{"ChartStyle", "->", "barstyle"}]}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{
  3.552285144030374*^9, {3.5763234889542513`*^9, 3.576323498588771*^9}, 
   3.947074411032844*^9, {3.9470744451185303`*^9, 3.94707444548285*^9}, {
   3.9476600277865677`*^9, 3.9476600281136103`*^9}, {3.9476600650637093`*^9, 
   3.947660069467613*^9}, 3.947660237185025*^9, {3.9476615308003073`*^9, 
   3.947661533973165*^9}, {3.9518170054913*^9, 3.951817033809801*^9}},
 CellLabel->"In[402]:=",
 $CellContext`InitializationGroup -> 
 True,ExpressionUUID->"7d3b9837-0241-466f-8d1c-4c2dc4dc9131"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"iSize", "=", " ", "350"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"labFontSize", " ", "=", " ", "14"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"colorscheme", "=", "\"\<Rainbow\>\""}], ";"}]}], "Input",
 CellChangeTimes->{{3.5517713586813107`*^9, 3.5517714849521017`*^9}, {
   3.551771951043*^9, 3.551771956466942*^9}, 3.551772077751997*^9, {
   3.5520223809767*^9, 3.5520224480666533`*^9}, {3.552029639239017*^9, 
   3.552029655604446*^9}, {3.552029764413485*^9, 3.5520297822572937`*^9}, {
   3.552030322982337*^9, 3.55203032356559*^9}, {3.552099179603568*^9, 
   3.552099186634179*^9}, {3.574734626728828*^9, 3.57473462722639*^9}},
 CellLabel->"In[405]:=",
 $CellContext`InitializationGroup -> 
 True,ExpressionUUID->"0f0369da-4d50-45d6-adef-adb1857ced78"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Section 1", "Section"]], "Chapter",
 CellChangeTimes->{{3.551606318467031*^9, 3.5516063376815357`*^9}, {
   3.551606927739052*^9, 3.551606929779048*^9}, {3.551607356500638*^9, 
   3.551607362899152*^9}, {3.5516077024987803`*^9, 3.551607709561294*^9}, 
   3.9473904389895573`*^9, {3.9473935757603807`*^9, 3.947393577947782*^9}},
 $CellContext`InitializationGroup -> 
 True,ExpressionUUID->"d8d9ba98-d8fd-4e10-a10a-3965b9871e11"],

Cell[CellGroupData[{

Cell["c4s1Figure1", "Section",
 CellChangeTimes->{{3.5723420028690567`*^9, 3.572342011627058*^9}, {
   3.947391571097383*^9, 3.947391617058372*^9}, 3.9473923450883703`*^9, 
   3.947393236393119*^9, 3.947575060658597*^9, 3.947654618026465*^9, 
   3.9476590855619097`*^9},
 $CellContext`InitializationGroup -> 
 True,ExpressionUUID->"2483f95a-f74a-479a-b13a-1af52c231ff8"],

Cell[CellGroupData[{

Cell["Code for c4s1Figure1", "Subsection",
 CellChangeTimes->{{3.5723420028690567`*^9, 3.572342011627058*^9}, {
   3.947391571097383*^9, 3.947391617058372*^9}, 3.9473923450883703`*^9, 
   3.947393236393119*^9, 3.947575060658597*^9, 3.947654618026465*^9, 
   3.9476590855619097`*^9, {3.951883669324441*^9, 3.9518836710776033`*^9}},
 $CellContext`InitializationGroup -> 
 True,ExpressionUUID->"2949bf8c-9d64-4320-acef-b3bae1b44f5c"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"numintegrate", "::", "usage"}], 
   "=", "\"\<numintegrate[list, dtsamp] numerically integrates the de-meaned \
data list assumed to be generated by sampling with sampling interval \
dtsamp.\>\""}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"doubleintegrate", "::", "usage"}], 
   "=", "\"\<doubleintegrate[list, dtsamp] performs double integration of \
data list list using numintegrate[list, dtsamp].\>\""}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"dispsdofspec", "::", "usage"}], 
   "=", "\"\<dispsdofspec[f, fres, damping] calculates the displacement SDOF \
damped oscillator response.\>\""}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"velsdofspec", "::", "usage"}], 
   "=", "\"\<velsdofspec[f, fres, damping] calculates the velocity SDOF \
damped oscillator response.\>\""}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"accsdofspec", "::", "usage"}], 
   "=", "\"\<accsdofspec[f, fres, damping] calculates the acceleration SDOF \
damped oscillator response.\>\""}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"sdofresponse", "::", "usage"}], 
   "=", "\"\<sdofresponse[inptrace, fo, dampfac, dtsamp] returns the absolute \
acceleration response of a SDOF oscillator for oscillator frequency fo and \
fraction of critical damping dampfac, driven by input acceleration trace \
inptrace (sampled with sampling interval dtsamp). Output: {Transpose[{times, \
resdat}], resmax, posmax, pos5percent}.\>\""}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"animateSDOFresponse", "::", "usage"}], 
   "=", "\"\<animateSDOFresponse[acctrace2D,dtsamp] returns \
{responseplot[],maxidx} which can be used to generate a list of plots of the \
displacement of a SDOF, which is excited by the input acceleration contained \
in acctrace2D.maxidx is the maximum index for which respplot[maxidx] is \
defined.\>\""}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"amplifymotionSDOFresponse", "::", "usage"}], 
   "=", "\"\<Option for animateSDOFresponse[acctrace2D,dtsamp] defining \
factor by which theoscillator mass motion is amplified in the plot. Default \
value: 2.\>\""}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"foscSDOFresponse", "::", "usage"}], 
   "=", "\"\<Option for animateSDOFresponse[acctrace2D,dtsamp] defining the \
oscillator frequency in Hz.\>\""}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"dampfacSDOFresponse", "::", "usage"}], 
   "=", "\"\<Option for animateSDOFresponse[acctrace2D,dtsamp] defining the \
oscilator damping factor. Default: 0.05.\>\""}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"heightdSDOFresponse", "::", "usage"}], 
   "=", "\"\<Option for animateSDOFresponse[acctrace2D,dtsamp] defining \
height of oscillating beam.\>\""}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"nzSDOFresponse", "::", "usage"}], 
   "=", "\"\<Option for animateSDOFresponse[acctrace2D,dtsamp] defining \
number of elements of oscillating beam.\>\""}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"posdamperSDOFresponse", "::", "usage"}], 
   "=", "\"\<Option for animateSDOFresponse[acctrace2D,dtsamp] defining \
position of damping element in terms of beam segments.  Default: -3.\>\""}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"timeivSDOFresponse", "::", "usage"}], 
   "=", "\"\<Option for animateSDOFresponse[acctrace2D,dtsamp] defining time \
interval in seconds used for recentering the displayed time interval. \
Default: 20.\>\""}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"spheresizeSDOFresponse", "::", "usage"}], 
   "=", "\"\<Option for animateSDOFresponse[acctrace2D,dtsamp] defining \
sphere size of oscillator mass. Default: 0.5.\>\""}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"imagesizeSDOFresponse", "::", "usage"}], 
   "=", "\"\<Option for animateSDOFresponse[acctrace2D,dtsamp] defining size \
of the output image. Default: 450.\>\""}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"inputtypeSDOFresponse", "::", "usage"}], 
   "=", "\"\<Option for animateSDOFresponse[acctrace2D,dtsamp] defining the \
input type of the trace. Default: \\\"Acceleration\\\". Other options are \
\\\"Velocity\\\" or\\\"Displacement\\\".\>\""}], ";"}]}], "Input",
 CellChangeTimes->{{3.951884061855403*^9, 3.951884202589917*^9}},
 CellLabel->"In[408]:=",
 $CellContext`InitializationGroup -> 
 True,ExpressionUUID->"7eb2e3f9-a39d-48de-8adb-3e83033d3d36"],

Cell[BoxData[
 RowBox[{
  RowBox[{
  "(*", "*********************************************************************************************************************************)"}\
], 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Options", "[", "animateSDOFresponse", "]"}], "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"amplifymotionSDOFresponse", "->", "Automatic"}], ",", 
       RowBox[{"foscSDOFresponse", "->", "1.0"}], ",", 
       RowBox[{"dampfacSDOFresponse", "->", "0.05"}], ",", 
       RowBox[{"heightdSDOFresponse", "->", "Automatic"}], ",", 
       RowBox[{"nzSDOFresponse", "->", "Automatic"}], ",", 
       RowBox[{"(*", 
        RowBox[{
         RowBox[{"dSDOFresponse", "->", "Automatic"}], ","}], "*)"}], 
       RowBox[{"posdamperSDOFresponse", "->", "Automatic"}], ",", 
       RowBox[{"timeivSDOFresponse", "->", "Automatic"}], ",", 
       RowBox[{"spheresizeSDOFresponse", "->", "Automatic"}], ",", 
       RowBox[{"imagesizeSDOFresponse", "->", "450"}], ",", 
       RowBox[{"inputtypeSDOFresponse", "->", "\"\<Acceleration\>\""}]}], 
      "}"}]}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"animateSDOFresponse", "[", 
      RowBox[{"trace2D_", ",", "dtsamp_", ",", 
       RowBox[{"decimfac_", ":", "10"}], ",", 
       RowBox[{"opts", ":", 
        RowBox[{"OptionsPattern", "[", 
         RowBox[{"{", "animateSDOFresponse", "}"}], "]"}]}]}], "]"}], ":=", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "amplifymotion", ",", "fosc", ",", "dampfac", ",", "height", ",", 
         "nz", ",", "d", ",", "maxz", ",", "scale", ",", "displdat", ",", 
         "inptrace1D", ",", "maxval", ",", "time", ",", "inptrace2D", ",", 
         "inptrace3D", ",", "posdamper", ",", "i", ",", 
         "responseOfSDOFoscillator", ",", "buildingresp3D", ",", "z", ",", 
         "swayingCylinder", ",", "respplot", ",", "timeiv", ",", "spheresize",
          ",", "tidx", ",", "pllist", ",", "imagesize", ",", "inputtype", ",",
          "inpdat"}], "}"}], ",", 
       RowBox[{
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"OptionValue", "[", "amplifymotionSDOFresponse", "]"}], "===",
            "Automatic"}], ",", 
          RowBox[{"amplifymotion", "=", "2"}], ",", 
          RowBox[{"amplifymotion", "=", 
           RowBox[{"OptionValue", "[", "amplifymotionSDOFresponse", "]"}]}]}],
          "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"OptionValue", "[", "heightdSDOFresponse", "]"}], "===", 
           "Automatic"}], ",", 
          RowBox[{"height", "=", "6"}], ",", 
          RowBox[{"height", "=", 
           RowBox[{"OptionValue", "[", "heightdSDOFresponse", "]"}]}]}], 
         "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"OptionValue", "[", "nzSDOFresponse", "]"}], "===", 
           "Automatic"}], ",", 
          RowBox[{"nz", "=", "6"}], ",", 
          RowBox[{"nz", "=", 
           RowBox[{"OptionValue", "[", "nzSDOFresponse", "]"}]}]}], "]"}], ";",
         "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"OptionValue", "[", "dSDOFresponse", "]"}], "===", 
             "Automatic"}], ",", 
            RowBox[{"d", "=", ".5"}], ",", 
            RowBox[{"d", "=", 
             RowBox[{"OptionValue", "[", "dSDOFresponse", "]"}]}]}], "]"}], 
          ";"}], "*)"}], 
        RowBox[{"d", "=", "0.5"}], ";", "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"OptionValue", "[", "posdamperSDOFresponse", "]"}], "===", 
           "Automatic"}], ",", 
          RowBox[{"posdamper", "=", 
           RowBox[{"-", "3"}]}], ",", 
          RowBox[{"posdamper", "=", 
           RowBox[{"OptionValue", "[", "posdamperSDOFresponse", "]"}]}]}], 
         "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"OptionValue", "[", "timeivSDOFresponse", "]"}], "===", 
           "Automatic"}], ",", 
          RowBox[{"timeiv", "=", "20"}], ",", 
          RowBox[{"timeiv", "=", 
           RowBox[{"OptionValue", "[", "timeivSDOFresponse", "]"}]}]}], "]"}],
         ";", "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"OptionValue", "[", "spheresizeSDOFresponse", "]"}], "===",
            "Automatic"}], ",", 
          RowBox[{"spheresize", "=", "0.5"}], ",", 
          RowBox[{"spheresize", "=", 
           RowBox[{"OptionValue", "[", "spheresizeSDOFresponse", "]"}]}]}], 
         "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"fosc", "=", 
         RowBox[{"OptionValue", "[", "foscSDOFresponse", "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"dampfac", "=", 
         RowBox[{"OptionValue", "[", "dampfacSDOFresponse", "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"imagesize", "=", 
         RowBox[{"OptionValue", "[", "imagesizeSDOFresponse", "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"inputtype", "=", 
         RowBox[{"OptionValue", "[", "inputtypeSDOFresponse", "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"maxz", "=", 
         RowBox[{
          RowBox[{"Floor", "[", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", "height"}], "-", "1"}], ")"}], "/", "2"}], 
           "]"}], "+", 
          RowBox[{"d", " ", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"-", "1"}], ")"}], "^", 
            RowBox[{"(", 
             RowBox[{"2", " ", "height"}], ")"}]}]}]}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"scale", "=", 
         RowBox[{"nz", "/", 
          RowBox[{"(", 
           RowBox[{"maxz", " ", 
            RowBox[{"Exp", "[", 
             RowBox[{"maxz", "/", "nz"}], "]"}]}], ")"}]}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"inpdat", "=", 
         RowBox[{
          RowBox[{"Transpose", "[", "trace2D", "]"}], "[", 
          RowBox[{"[", "2", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{
          RowBox[{
          "showstate", "[", "\"\<Generate displacement trace\>\"", "]"}], 
          ";"}], "*)"}], "\[IndentingNewLine]", 
        RowBox[{"Which", "[", 
         RowBox[{
          RowBox[{"inputtype", "===", "\"\<Acceleration\>\""}], ",", 
          RowBox[{
           RowBox[{"displdat", "=", 
            RowBox[{"doubleintegrate", "[", 
             RowBox[{"inpdat", ",", "dtsamp"}], "]"}]}], ";"}], ",", 
          RowBox[{"inputtype", "===", "\"\<Velocity\>\""}], ",", 
          RowBox[{
           RowBox[{"displdat", "=", 
            RowBox[{"numintegrate", "[", 
             RowBox[{"inpdat", ",", "dtsamp"}], "]"}]}], ";"}], ",", "True", ",", 
          RowBox[{
           RowBox[{"displdat", "=", "inpdat"}], ";"}]}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"inptrace1D", "=", "displdat"}], ";", "\[IndentingNewLine]", 
        RowBox[{"maxval", "=", 
         RowBox[{"Max", "[", 
          RowBox[{"Abs", "[", "inptrace1D", "]"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"inptrace1D", "/=", "maxval"}], ";", "\[IndentingNewLine]", 
        RowBox[{"time", "=", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"dtsamp", "*", 
            RowBox[{"(", 
             RowBox[{"i", "-", "1"}], ")"}]}], ",", 
           RowBox[{"{", 
            RowBox[{"i", ",", "1", ",", 
             RowBox[{"Length", "[", "inptrace1D", "]"}]}], "}"}]}], "]"}]}], ";",
         "\[IndentingNewLine]", 
        RowBox[{"inptrace2D", "=", 
         RowBox[{"Transpose", "[", 
          RowBox[{"{", 
           RowBox[{"time", ",", "inptrace1D"}], "}"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"inptrace3D", "=", 
         RowBox[{"Transpose", "[", 
          RowBox[{"{", 
           RowBox[{"inptrace1D", ",", "time", ",", 
            RowBox[{"Table", "[", 
             RowBox[{
              RowBox[{"-", "2."}], ",", 
              RowBox[{"{", 
               RowBox[{"i", ",", "1", ",", 
                RowBox[{"Length", "[", "inptrace1D", "]"}]}], "}"}]}], 
             "]"}]}], "}"}], "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{
          RowBox[{
          "showstate", "[", "\"\<Build responseOfSDOFoscillator\>\"", "]"}], 
          ";"}], "*)"}], "\[IndentingNewLine]", 
        RowBox[{"responseOfSDOFoscillator", "=", 
         RowBox[{"amplifymotion", " ", 
          RowBox[{
           RowBox[{"Transpose", "[", 
            RowBox[{
             RowBox[{"sdofresponse", "[", 
              RowBox[{
              "inptrace2D", ",", "fosc", ",", "dampfac", ",", "dtsamp"}], 
              "]"}], "[", 
             RowBox[{"[", "1", "]"}], "]"}], "]"}], "[", 
           RowBox[{"[", "2", "]"}], "]"}]}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{
          RowBox[{"showstate", "[", "\"\<Build buildingresp3D\>\"", "]"}], 
          ";"}], "*)"}], "\[IndentingNewLine]", 
        RowBox[{"buildingresp3D", "=", 
         RowBox[{"Transpose", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{"1", "/", "nz"}], " ", "scale", " ", "maxz", " ", 
             RowBox[{"Exp", "[", 
              RowBox[{"maxz", "/", "nz"}], "]"}], " ", 
             "responseOfSDOFoscillator"}], ",", "time", ",", 
            RowBox[{"Table", "[", 
             RowBox[{"maxz", ",", 
              RowBox[{"{", 
               RowBox[{"i", ",", "1", ",", 
                RowBox[{"Length", "[", "inptrace1D", "]"}]}], "}"}]}], 
             "]"}]}], "}"}], "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{
          RowBox[{"showstate", "[", "\"\<Build swaying cylinder\>\"", "]"}], 
          ";"}], "*)"}], "\[IndentingNewLine]", 
        RowBox[{"Clear", "[", "swayingCylinder", "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"swayingCylinder", "[", "t_", "]"}], ":=", 
         RowBox[{"Partition", "[", 
          RowBox[{
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"With", "[", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"pt", "=", 
                 RowBox[{"{", 
                  RowBox[{"0.", ",", "0.", ",", 
                   RowBox[{
                    RowBox[{"Floor", "[", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"z", "-", "1"}], ")"}], "/", "2"}], "]"}], "+", 
                    RowBox[{"d", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"-", "1"}], ")"}], "^", "z"}]}]}]}], "}"}]}], 
                "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{
                  RowBox[{
                   RowBox[{"1", "/", "nz"}], " ", "scale", " ", 
                   RowBox[{"pt", "[", 
                    RowBox[{"[", "3", "]"}], "]"}], " ", 
                   RowBox[{"Exp", "[", 
                    RowBox[{
                    RowBox[{"pt", "[", 
                    RowBox[{"[", "3", "]"}], "]"}], "/", "nz"}], "]"}], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"responseOfSDOFoscillator", "[", 
                    RowBox[{"[", "t", "]"}], "]"}], "-", 
                    RowBox[{"inptrace1D", "[", 
                    RowBox[{"[", "t", "]"}], "]"}]}], ")"}]}], "+", 
                  RowBox[{"inptrace1D", "[", 
                   RowBox[{"[", "t", "]"}], "]"}]}], ",", 
                 RowBox[{"pt", "[", 
                  RowBox[{"[", "2", "]"}], "]"}], ",", 
                 RowBox[{"pt", "[", 
                  RowBox[{"[", "3", "]"}], "]"}]}], "}"}]}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"z", ",", 
               RowBox[{"2", " ", "height"}]}], "}"}]}], "]"}], ",", "2"}], 
          "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{
          RowBox[{"showstate", "[", "\"\<Build response plot\>\"", "]"}], 
          ";"}], "*)"}], "\[IndentingNewLine]", 
        RowBox[{"Clear", "[", "respplot", "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"respplot", "[", "t_", "]"}], ":=", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"1", "<=", "t", "<=", 
            RowBox[{"Length", "[", "inptrace1D", "]"}]}], ",", 
           RowBox[{"Graphics3D", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"Black", ",", "Thick", ",", 
                 RowBox[{"Dynamic", "@", 
                  RowBox[{"Line", "[", 
                   RowBox[{"recenterintval", "[", 
                    RowBox[{
                    "inptrace3D", ",", "t", ",", "dtsamp", ",", "timeiv"}], 
                    "]"}], "]"}]}]}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"Red", ",", "Thick", ",", 
                 RowBox[{"Dynamic", "@", 
                  RowBox[{"Line", "[", 
                   RowBox[{"recenterintval", "[", 
                    RowBox[{
                    "buildingresp3D", ",", "t", ",", "dtsamp", ",", 
                    "timeiv"}], "]"}], "]"}]}]}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ColorData", "[", 
                  RowBox[{"\"\<HTML\>\"", ",", "\"\<Gold\>\""}], "]"}], ",", 
                 RowBox[{"Dynamic", "@", 
                  RowBox[{"Sphere", "[", 
                   RowBox[{
                    RowBox[{"recenterintval", "[", 
                    RowBox[{
                    "buildingresp3D", ",", "t", ",", "dtsamp", ",", "0."}], 
                    "]"}], ",", "spheresize"}], "]"}]}]}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ColorData", "[", 
                  RowBox[{"\"\<HTML\>\"", ",", "\"\<Silver\>\""}], "]"}], ",", 
                 RowBox[{"Dynamic", "@", 
                  RowBox[{"Cylinder", "[", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"inptrace1D", "[", 
                    RowBox[{"[", "t", "]"}], "]"}], ",", "0", ",", 
                    RowBox[{"-", "2"}]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"inptrace1D", "[", 
                    RowBox[{"[", "t", "]"}], "]"}], ",", "0", ",", 
                    RowBox[{"-", ".5"}]}], "}"}]}], "}"}], ",", ".4"}], 
                   "]"}]}]}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ColorData", "[", 
                  RowBox[{"\"\<HTML\>\"", ",", "\"\<DarkGreen\>\""}], "]"}], ",", 
                 RowBox[{"Dynamic", "@", 
                  RowBox[{"Cylinder", "[", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"posdamper", ",", "0", ",", 
                    RowBox[{"-", "1"}]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"posdamper", "/", "2"}], ",", "0", ",", 
                    RowBox[{"-", "1."}]}], "}"}]}], "}"}], ",", ".4"}], 
                   "]"}]}]}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ColorData", "[", 
                  RowBox[{"\"\<HTML\>\"", ",", "\"\<SpringGreen\>\""}], "]"}],
                  ",", 
                 RowBox[{"Dynamic", "@", 
                  RowBox[{"Cylinder", "[", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"posdamper", "/", "2"}], ",", "0", ",", 
                    RowBox[{"-", "1"}]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"inptrace1D", "[", 
                    RowBox[{"[", "t", "]"}], "]"}], ",", "0", ",", 
                    RowBox[{"-", "1."}]}], "}"}]}], "}"}], ",", ".05"}], 
                   "]"}]}]}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ColorData", "[", 
                  RowBox[{"\"\<HTML\>\"", ",", "\"\<LightSteelBlue\>\""}], 
                  "]"}], ",", 
                 RowBox[{"Specularity", "[", 
                  RowBox[{"White", ",", "20"}], "]"}], ",", 
                 RowBox[{"Dynamic", "@", 
                  RowBox[{"MapThread", "[", 
                   RowBox[{"Cylinder", ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"swayingCylinder", "[", "t", "]"}], ",", 
                    RowBox[{"Table", "[", 
                    RowBox[{".07", ",", 
                    RowBox[{"{", "height", "}"}]}], "]"}]}], "}"}]}], 
                   "]"}]}]}], "}"}]}], "\[IndentingNewLine]", 
              RowBox[{"(*", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ColorData", "[", 
                  RowBox[{"\"\<HTML\>\"", ",", "\"\<LightSteelBlue\>\""}], 
                  "]"}], ",", 
                 RowBox[{"Specularity", "[", 
                  RowBox[{"White", ",", "20"}], "]"}], ",", 
                 RowBox[{"Dynamic", "@", 
                  RowBox[{"MapThread", "[", 
                   RowBox[{"Cylinder", ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"swayingCylinderInt", "[", 
                    RowBox[{
                    "1", ",", "1", ",", "height", ",", ".5", ",", "t"}], 
                    "]"}], ",", 
                    RowBox[{"Table", "[", 
                    RowBox[{".1", ",", 
                    RowBox[{"{", "nz", "}"}]}], "]"}]}], "}"}]}], "]"}]}]}], 
                "}"}], "*)"}], "}"}], ",", 
             RowBox[{"ImageSize", "->", "imagesize"}], ",", 
             RowBox[{"Boxed", "->", "False"}], ",", 
             RowBox[{"PlotRange", "->", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "2"}], ",", "timeiv"}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "8"}], ",", "height"}], "}"}]}], "}"}]}], ",", 
             
             RowBox[{"PlotRangePadding", "->", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"2", ",", "2"}], "}"}], ",", "2", ",", 
                RowBox[{"{", 
                 RowBox[{"2", ",", "2"}], "}"}]}], "}"}]}], ",", 
             RowBox[{"Lighting", "->", "\"\<Neutral\>\""}], ",", 
             RowBox[{"ViewAngle", "->", ".2"}], ",", 
             RowBox[{"ViewPoint", "->", 
              RowBox[{"{", 
               RowBox[{"2.", ",", 
                RowBox[{"-", "3.1986514670399693`"}], ",", "1.0"}], "}"}]}], ",", 
             RowBox[{"ViewVertical", "->", 
              RowBox[{"{", 
               RowBox[{"0.", ",", "0.", ",", "2."}], "}"}]}]}], "]"}], ",", 
           "Null"}], "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{
          RowBox[{"showstate", "[", "\"\<Done\>\"", "]"}], ";"}], "*)"}], 
        "\[IndentingNewLine]", 
        RowBox[{"pllist", "=", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"respplot", "[", "tidx", "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"tidx", ",", "1", ",", 
             RowBox[{"Length", "[", "inptrace1D", "]"}], ",", "decimfac"}], "}"}]\
}], "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"Return", "[", "pllist", "]"}], ";"}]}], "]"}]}], 
    ";"}]}]}]], "Input",
 CellChangeTimes->{{3.9518836137716637`*^9, 3.951883613773921*^9}, {
  3.95188378430884*^9, 3.951883834195795*^9}, {3.951884231791985*^9, 
  3.95188426163531*^9}},
 CellLabel->"In[425]:=",
 $CellContext`InitializationGroup -> 
 True,ExpressionUUID->"a571804c-e2e7-4805-8a2a-33ed79dd7e35"],

Cell[BoxData[
 RowBox[{
  RowBox[{
  "(*", "*********************************************************************************************************************************)"}\
], 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"doubleintegrate", "[", 
      RowBox[{"li_", ",", "dtsamp_"}], "]"}], ":=", 
     RowBox[{"numintegrate", "[", 
      RowBox[{
       RowBox[{"numintegrate", "[", 
        RowBox[{"li", ",", "dtsamp"}], "]"}], ",", "dtsamp"}], "]"}]}], ";"}],
    "\n", 
   RowBox[{
    RowBox[{"numintegrate", "[", 
     RowBox[{"li_", ",", "dtsamp_"}], "]"}], ":=", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"dat2", ",", "datint"}], "}"}], ",", 
      RowBox[{
       RowBox[{"dat2", "=", 
        RowBox[{"li", "-", 
         RowBox[{"Mean", "[", "li", "]"}]}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"datint", "=", 
        RowBox[{"FoldList", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"SumAddPt", "[", 
            RowBox[{"#1", ",", "#2", ",", "dtsamp"}], "]"}], "&"}], ",", "0", 
          ",", "dat2"}], "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"Drop", "[", 
        RowBox[{"datint", ",", "1"}], "]"}]}]}], "]"}]}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"SumAddPt", "[", 
      RowBox[{"val1_", ",", "val2_", ",", "dtsamp_"}], "]"}], ":=", 
     RowBox[{"val1", "+", 
      RowBox[{"dtsamp", " ", "val2"}]}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{"recenterintval", "[", 
     RowBox[{"dat3D_", ",", "k_", ",", "dt_", ",", "ivsec_"}], "]"}], ":=", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"iv", ",", "x", ",", "time", ",", "z"}], "}"}], ",", 
      RowBox[{
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"ivsec", ">", "0"}], ",", 
         RowBox[{"iv", "=", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Max", "[", 
             RowBox[{
              RowBox[{"Round", "[", 
               RowBox[{"k", "-", 
                RowBox[{".1", " ", 
                 RowBox[{"ivsec", "/", "dt"}]}]}], "]"}], ",", "1"}], "]"}], ",", 
            RowBox[{"Min", "[", 
             RowBox[{
              RowBox[{"Round", "[", 
               RowBox[{"k", "+", 
                RowBox[{".9", " ", 
                 RowBox[{"ivsec", "/", "dt"}]}]}], "]"}], ",", 
              RowBox[{"Length", "[", "dat3D", "]"}]}], "]"}]}], "}"}]}], ",", 
         
         RowBox[{
          RowBox[{"iv", "=", 
           RowBox[{"{", "k", "}"}]}], ";"}]}], "]"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"x", ",", "time", ",", "z"}], "}"}], "=", 
        RowBox[{"Transpose", "[", 
         RowBox[{"Take", "[", 
          RowBox[{"dat3D", ",", "iv"}], "]"}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"Transpose", "[", 
        RowBox[{"{", 
         RowBox[{"x", ",", 
          RowBox[{"time", "-", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"k", "-", "1"}], ")"}], " ", "dt"}]}], ",", "z"}], "}"}],
         "]"}]}]}], "]"}]}], "\n", 
   RowBox[{
   "(*", "********************************************************************************************)"}\
], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"dispsdofspec", "[", 
      RowBox[{"x_", ",", "fosc_", ",", "h_"}], "]"}], ":=", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"x", "^", "2"}], ")"}], "/", 
      RowBox[{"Sqrt", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"x", "^", "2"}], "-", 
           RowBox[{"fosc", "^", "2"}]}], ")"}], "^", "2"}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"2", " ", "x", " ", "fosc", " ", "h"}], ")"}], "^", "2"}]}],
        "]"}]}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"velsdofspec", "[", 
      RowBox[{"x_", ",", "fosc_", ",", "h_"}], "]"}], ":=", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"x", ">", "0"}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"2", " ", "Pi", " ", "fosc"}], ")"}], "^", "2"}], " ", 
        RowBox[{
         RowBox[{"dispsdofspec", "[", 
          RowBox[{"x", ",", "fosc", ",", "h"}], "]"}], "/", 
         RowBox[{"(", 
          RowBox[{"2", " ", "Pi", " ", "x"}], ")"}]}]}], ",", "0"}], "]"}]}], 
    ";"}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"accsdofspec", "[", 
      RowBox[{"x_", ",", "fosc_", ",", "h_"}], "]"}], ":=", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"x", ">", "0"}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"2", " ", "Pi", " ", "fosc"}], ")"}], "^", "2"}], " ", 
        RowBox[{
         RowBox[{"dispsdofspec", "[", 
          RowBox[{"x", ",", "fosc", ",", "h"}], "]"}], "/", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"2", " ", "Pi", " ", "x"}], ")"}], "^", "2"}]}]}], ",", 
       "1"}], "]"}]}], ";"}], "\n", 
   RowBox[{
   "(*", "********************************************************************************************)"}\
], "\[IndentingNewLine]", 
   RowBox[{
   "(*", "*********************************************************************************************************************************)"}\
], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"sdofresponse", "[", 
      RowBox[{"inptrace_", ",", "fo_", ",", "dampfac_", ",", "dtsamp_"}], 
      "]"}], ":=", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "deltaalist", ",", "omegaosc", ",", "lambda", ",", "c1", ",", "c2", ",",
          "y0", ",", "it2", ",", "sdofresp", ",", "posmax", ",", "resmax", ",",
          "times", ",", "dat", ",", "resdat", ",", "fosc", ",", "dt", ",", 
         "damp", ",", "cumsum", ",", "pos5percent"}], "}"}], ",", 
       RowBox[{
        RowBox[{"fosc", "=", "fo"}], ";", "\[IndentingNewLine]", 
        RowBox[{"dt", "=", "dtsamp"}], ";", "\[IndentingNewLine]", 
        RowBox[{"damp", "=", "dampfac"}], ";", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"times", ",", "dat"}], "}"}], "=", 
         RowBox[{"Transpose", "[", "inptrace", "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"deltaalist", "=", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"#", "[", 
             RowBox[{"[", "2", "]"}], "]"}], "-", 
            RowBox[{"#", "[", 
             RowBox[{"[", "1", "]"}], "]"}]}], "&"}], "/@", 
          RowBox[{"Partition", "[", 
           RowBox[{"dat", ",", "2", ",", "1"}], "]"}]}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"omegaosc", "=", 
         RowBox[{"2", " ", "Pi", " ", "fosc"}]}], ";", "\[IndentingNewLine]", 
        
        RowBox[{"lambda", "=", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "damp"}], " ", "omegaosc"}], "+", 
          RowBox[{"I", " ", "omegaosc", " ", 
           RowBox[{"Sqrt", "[", 
            RowBox[{"1", "-", 
             RowBox[{"damp", "^", "2"}]}], "]"}]}]}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"c1", "=", 
         RowBox[{"Exp", "[", 
          RowBox[{"lambda", " ", "dt"}], "]"}]}], ";", "\[IndentingNewLine]", 
        
        RowBox[{"c2", "=", 
         RowBox[{"2", " ", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "c1"}], ")"}], "/", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"lambda", "-", 
               RowBox[{"Conjugate", "[", "lambda", "]"}]}], ")"}], " ", 
             "dt"}], ")"}]}]}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"Clear", "[", "it2", "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"it2", "[", 
          RowBox[{"yi_", ",", "deltaai_"}], "]"}], ":=", 
         RowBox[{
          RowBox[{"c1", " ", "yi"}], "+", 
          RowBox[{"c2", " ", "deltaai"}]}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"y0", "=", 
         RowBox[{"2", " ", "lambda", " ", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"-", 
             RowBox[{"dat", "[", 
              RowBox[{"[", "1", "]"}], "]"}]}], ")"}], "/", 
           RowBox[{"(", 
            RowBox[{"lambda", "-", 
             RowBox[{"Conjugate", "[", "lambda", "]"}]}], ")"}]}]}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"sdofresp", "=", 
         RowBox[{"Re", "[", 
          RowBox[{"FoldList", "[", 
           RowBox[{"it2", ",", "y0", ",", "deltaalist"}], "]"}], "]"}]}], ";",
         "\[IndentingNewLine]", 
        RowBox[{"resdat", "=", 
         RowBox[{"sdofresp", "+", "dat"}]}], ";", 
        RowBox[{"(*", 
         RowBox[{"absolute", " ", "movement"}], "*)"}], 
        RowBox[{"posmax", "=", 
         RowBox[{
          RowBox[{"Flatten", "[", 
           RowBox[{"Position", "[", 
            RowBox[{
             RowBox[{"Abs", "[", "resdat", "]"}], ",", 
             RowBox[{"Max", "[", 
              RowBox[{"Abs", "[", "resdat", "]"}], "]"}]}], "]"}], "]"}], "[", 
          RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"resmax", "=", 
         RowBox[{"resdat", "[", 
          RowBox[{"[", "posmax", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{"determine", " ", 
          RowBox[{"no", ".", "of"}], " ", "samples", " ", "resdat", " ", 
          "which", " ", "are", " ", "below", " ", "5", "%", " ", "cumulative",
           " ", "amplitude"}], "*)"}], 
        RowBox[{"cumsum", "=", 
         RowBox[{"FoldList", "[", 
          RowBox[{"Plus", ",", "0", ",", 
           RowBox[{"Abs", "[", "resdat", "]"}]}], "]"}]}], ";", 
        RowBox[{"(*", 
         RowBox[{
         "still", " ", "contains", " ", "the", " ", "0", " ", "as", " ", 
          "first", " ", 
          RowBox[{"element", ".", "Leave"}], " ", "this", " ", "element", " ",
           "in", " ", "so", " ", "that", " ", "length", " ", "of", " ", 
          "selected", " ", "list", " ", "is", " ", "always", " ", "at", " ", 
          "least", " ", "1"}], "*)"}], 
        RowBox[{"cumsum", "/=", 
         RowBox[{"Last", "[", "cumsum", "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"pos5percent", "=", 
         RowBox[{
          RowBox[{"Select", "[", 
           RowBox[{"cumsum", ",", 
            RowBox[{
             RowBox[{"#", "<", ".05"}], "&"}]}], "]"}], "//", "Length"}]}], ";",
         "\[IndentingNewLine]", 
        RowBox[{"Return", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Transpose", "[", 
            RowBox[{"{", 
             RowBox[{"times", ",", "resdat"}], "}"}], "]"}], ",", "resmax", ",",
            "posmax", ",", "pos5percent"}], "}"}], "]"}], ";"}]}], "]"}]}], 
    ";"}], "\n", 
   RowBox[{
   "(*", "*********************************************************************************************************************************)"}\
]}]}]], "Input",
 CellChangeTimes->{{3.951883895191401*^9, 3.9518838951933327`*^9}, 
   3.9518840016622543`*^9},
 CellLabel->"In[427]:=",
 $CellContext`InitializationGroup -> 
 True,ExpressionUUID->"c1ac73e5-c810-4c06-b5aa-12e39a8a685a"]
}, Open  ]],

Cell[CellGroupData[{

Cell["c4s1Figure1", "Subsection",
 CellChangeTimes->{{3.5723420028690567`*^9, 3.572342011627058*^9}, {
   3.947391571097383*^9, 3.947391617058372*^9}, 3.9473923450883703`*^9, 
   3.947393236393119*^9, 3.947575060658597*^9, 3.947654618026465*^9, 
   3.9476590855619097`*^9},
 $CellContext`InitializationGroup -> 
 True,ExpressionUUID->"bd4676c9-3d6b-4a80-a72b-f2ec5e63c464"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"fdig", "=", "20."}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dampfac", "=", "0.05"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"fosc", "=", "0.5"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"lensec", "=", "25"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dat", "=", 
   RowBox[{"Table", "[", 
    RowBox[{"0", ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", 
       RowBox[{"Round", "[", 
        RowBox[{"fdig", " ", "lensec"}], " ", "]"}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"dat", "[", 
    RowBox[{"[", 
     RowBox[{"Round", "[", 
      RowBox[{"fdig", " ", 
       RowBox[{"lensec", "/", "10"}]}], "  ", "]"}], "]"}], "]"}], "=", 
   "1."}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dat", "=", 
   RowBox[{"Join", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{"0", ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", 
         RowBox[{"Round", "[", 
          RowBox[{"fdig", " ", 
           RowBox[{"lensec", "/", "10"}]}], "  ", "]"}]}], "}"}]}], "]"}], ",",
      "\[IndentingNewLine]", 
     RowBox[{"Table", "[", 
      RowBox[{"1", ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", 
         RowBox[{
          RowBox[{"Round", "[", 
           RowBox[{"fdig", " ", 
            RowBox[{"lensec", "/", "10"}]}], "  ", "]"}], "+", "1"}], ",", 
         RowBox[{"Round", "[", 
          RowBox[{"fdig", " ", "lensec"}], "]"}]}], "}"}]}], "]"}]}], "]"}]}],
   ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"time", "=", 
   RowBox[{"Table", "[", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"i", "-", "1"}], ")"}], "/", "fdig"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", 
       RowBox[{"Length", "[", "dat", "]"}]}], "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"inptrace1D", "=", "dat"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"maxval", "=", 
   RowBox[{"Max", "[", 
    RowBox[{"Abs", "[", "inptrace1D", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"inptrace1D", "/=", " ", "maxval"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"time", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"i", "-", "1"}], ")"}], "/", "fdig"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", 
       RowBox[{"Length", "[", "inptrace1D", "]"}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"inptrace2D", "=", 
   RowBox[{"Transpose", "[", 
    RowBox[{"{", 
     RowBox[{"time", ",", " ", "inptrace1D"}], "}"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"resp", "=", 
   RowBox[{
    RowBox[{
     StyleBox["sdofresponse",
      FontColor->GrayLevel[0]], "[", 
     RowBox[{"inptrace2D", ",", "fosc", ",", "dampfac", ",", 
      RowBox[{"1", "/", "fdig"}]}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Max", "[", 
  RowBox[{"Abs", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Transpose", "[", "resp", "]"}], "[", 
     RowBox[{"[", "2", "]"}], "]"}], " ", "-", "inptrace1D"}], "]"}], "]"}], "\n", 
 RowBox[{
  RowBox[{"pllist1", "=", 
   RowBox[{"animateSDOFresponse", "[", 
    RowBox[{"inptrace2D", ",", 
     RowBox[{"1", "/", "fdig"}], ",", "5", ",", 
     RowBox[{"inputtypeSDOFresponse", "\[Rule]", "\"\<Displacement\>\""}], 
     " ", ",", 
     RowBox[{"imagesizeSDOFresponse", "\[Rule]", "iSize"}]}], "]"}]}], ";", 
  RowBox[{"i", "=", "1"}], ";", 
  RowBox[{"c4s1Figure1", "=", 
   RowBox[{"Manipulate", "[", 
    RowBox[{
     RowBox[{"Show", "[", 
      RowBox[{
       RowBox[{"pllist1", "[", 
        RowBox[{"[", "i", "]"}], "]"}], ",", 
       RowBox[{"ImageSize", "\[Rule]", "iSize"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", "\"\<Time\>\""}], "}"}], ",", "1", ",", 
       RowBox[{"Length", "[", "pllist1", "]"}], ",", "1"}], "}"}], ",", 
     RowBox[{"SaveDefinitions", "\[Rule]", " ", "True"}]}], 
    "]"}]}]}]}], "Input",
 CellChangeTimes->{{3.444555653120572*^9, 3.4445556622732964`*^9}, {
   3.444555697905819*^9, 3.444555761266117*^9}, {3.444555844898076*^9, 
   3.444555876826292*^9}, {3.444556651561014*^9, 3.4445566568561907`*^9}, {
   3.4445575057295322`*^9, 3.44455762883394*^9}, {3.444557695716154*^9, 
   3.444557744259487*^9}, {3.4445578095306587`*^9, 3.444557820098275*^9}, {
   3.444557894276079*^9, 3.4445579104258204`*^9}, 3.444558049076096*^9, {
   3.4445584830984697`*^9, 3.4445585271785994`*^9}, {3.4445586042964354`*^9, 
   3.44455868739417*^9}, {3.444558720333364*^9, 3.444558731082513*^9}, 
   3.444558776008828*^9, 3.444559018025036*^9, 3.4445591364381943`*^9, {
   3.444559203605926*^9, 3.444559219701565*^9}, {3.5764953184320107`*^9, 
   3.5764953725520973`*^9}, 3.576495417149148*^9, {3.576495484801271*^9, 
   3.576495501041934*^9}, {3.5764955478184767`*^9, 3.57649563946952*^9}, {
   3.576495672647068*^9, 3.576495681446814*^9}, {3.576495897941279*^9, 
   3.576495914829652*^9}, {3.576496097035695*^9, 3.576496151090472*^9}, {
   3.5764962258887444`*^9, 3.5764962312473993`*^9}, 3.576989033601306*^9, {
   3.576992576991387*^9, 3.5769925872161283`*^9}, 3.577162533332405*^9, 
   3.5771626010647697`*^9, {3.951884332568865*^9, 3.9518843331761293`*^9}},
 CellLabel->"In[435]:=",
 $CellContext`InitializationGroup -> 
 True,ExpressionUUID->"aabafa66-27ee-4b69-87d0-016b3ae7b939"],

Cell[BoxData["0.9881118228644474`"], "Output",
 CellChangeTimes->{
  3.577174452060298*^9, 3.5897094539666843`*^9, 3.944744146062351*^9, 
   3.944746550349701*^9, 3.947143650917859*^9, 3.947232825719569*^9, 
   3.947232945648159*^9, 3.947659206578864*^9, 3.947659982490571*^9, 
   3.947660049298995*^9, 3.947660082882288*^9, 3.947660829353046*^9, {
   3.951884313026202*^9, 3.951884336501727*^9}, 3.9557719112525463`*^9, 
   3.955772228046484*^9, 3.9557724204884157`*^9},
 CellLabel->"Out[449]=",
 $CellContext`InitializationGroup -> 
 True,ExpressionUUID->"a4500d03-c643-467c-b948-116b045debb8"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`i$$ = 1, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`i$$], 1, "Time"}, 1, 100, 1, ControlType -> 
      Manipulator}}, Typeset`size$$ = {
    350., {172.134033203125, 177.865966796875}}, Typeset`update$$ = 0, 
    Typeset`initDone$$, Typeset`skipInitDone$$ = False, 
    Typeset`keyframeActionsQ$$ = False, Typeset`keyframeList$$ = {}}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`i$$ = 1}, 
      "ControllerVariables" :> {}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$, Typeset`keyframeActionsQ$$, 
        Typeset`keyframeList$$}, "Body" :> Show[
        Part[$CellContext`pllist1, $CellContext`i$$], 
        ImageSize -> $CellContext`iSize], 
      "Specifications" :> {{{$CellContext`i$$, 1, "Time"}, 1, 100, 1}}, 
      "Options" :> {}, "DefaultOptions" :> {}],
     ImageSizeCache->{399.1, {219.80445861816406`, 225.53639221191406`}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    Initialization:>({$CellContext`pllist1 = {
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$64517, 1, 
               0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               1, 0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               1, 0.05, 0.], $CellContext`spheresize$64517]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$64517, 1], 0, -2}, {
                Part[$CellContext`inptrace1D$64517, 1], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$64517, 
                0, -1}, {$CellContext`posdamper$64517/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$64517/2, 0, -1}, {
                Part[$CellContext`inptrace1D$64517, 1], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$64517[1], 
               Table[0.07, {$CellContext`height$64517}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$64517, 6, 
               0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               6, 0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               6, 0.05, 0.], $CellContext`spheresize$64517]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$64517, 6], 0, -2}, {
                Part[$CellContext`inptrace1D$64517, 6], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$64517, 
                0, -1}, {$CellContext`posdamper$64517/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$64517/2, 0, -1}, {
                Part[$CellContext`inptrace1D$64517, 6], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$64517[6], 
               Table[0.07, {$CellContext`height$64517}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$64517, 11, 
               0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               11, 0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               11, 0.05, 0.], $CellContext`spheresize$64517]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$64517, 11], 0, -2}, {
                Part[$CellContext`inptrace1D$64517, 11], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$64517, 
                0, -1}, {$CellContext`posdamper$64517/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$64517/2, 0, -1}, {
                Part[$CellContext`inptrace1D$64517, 11], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$64517[11], 
               Table[0.07, {$CellContext`height$64517}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$64517, 16, 
               0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               16, 0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               16, 0.05, 0.], $CellContext`spheresize$64517]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$64517, 16], 0, -2}, {
                Part[$CellContext`inptrace1D$64517, 16], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$64517, 
                0, -1}, {$CellContext`posdamper$64517/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$64517/2, 0, -1}, {
                Part[$CellContext`inptrace1D$64517, 16], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$64517[16], 
               Table[0.07, {$CellContext`height$64517}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$64517, 21, 
               0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               21, 0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               21, 0.05, 0.], $CellContext`spheresize$64517]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$64517, 21], 0, -2}, {
                Part[$CellContext`inptrace1D$64517, 21], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$64517, 
                0, -1}, {$CellContext`posdamper$64517/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$64517/2, 0, -1}, {
                Part[$CellContext`inptrace1D$64517, 21], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$64517[21], 
               Table[0.07, {$CellContext`height$64517}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$64517, 26, 
               0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               26, 0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               26, 0.05, 0.], $CellContext`spheresize$64517]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$64517, 26], 0, -2}, {
                Part[$CellContext`inptrace1D$64517, 26], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$64517, 
                0, -1}, {$CellContext`posdamper$64517/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$64517/2, 0, -1}, {
                Part[$CellContext`inptrace1D$64517, 26], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$64517[26], 
               Table[0.07, {$CellContext`height$64517}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$64517, 31, 
               0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               31, 0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               31, 0.05, 0.], $CellContext`spheresize$64517]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$64517, 31], 0, -2}, {
                Part[$CellContext`inptrace1D$64517, 31], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$64517, 
                0, -1}, {$CellContext`posdamper$64517/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$64517/2, 0, -1}, {
                Part[$CellContext`inptrace1D$64517, 31], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$64517[31], 
               Table[0.07, {$CellContext`height$64517}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$64517, 36, 
               0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               36, 0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               36, 0.05, 0.], $CellContext`spheresize$64517]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$64517, 36], 0, -2}, {
                Part[$CellContext`inptrace1D$64517, 36], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$64517, 
                0, -1}, {$CellContext`posdamper$64517/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$64517/2, 0, -1}, {
                Part[$CellContext`inptrace1D$64517, 36], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$64517[36], 
               Table[0.07, {$CellContext`height$64517}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$64517, 41, 
               0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               41, 0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               41, 0.05, 0.], $CellContext`spheresize$64517]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$64517, 41], 0, -2}, {
                Part[$CellContext`inptrace1D$64517, 41], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$64517, 
                0, -1}, {$CellContext`posdamper$64517/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$64517/2, 0, -1}, {
                Part[$CellContext`inptrace1D$64517, 41], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$64517[41], 
               Table[0.07, {$CellContext`height$64517}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$64517, 46, 
               0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               46, 0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               46, 0.05, 0.], $CellContext`spheresize$64517]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$64517, 46], 0, -2}, {
                Part[$CellContext`inptrace1D$64517, 46], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$64517, 
                0, -1}, {$CellContext`posdamper$64517/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$64517/2, 0, -1}, {
                Part[$CellContext`inptrace1D$64517, 46], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$64517[46], 
               Table[0.07, {$CellContext`height$64517}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$64517, 51, 
               0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               51, 0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               51, 0.05, 0.], $CellContext`spheresize$64517]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$64517, 51], 0, -2}, {
                Part[$CellContext`inptrace1D$64517, 51], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$64517, 
                0, -1}, {$CellContext`posdamper$64517/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$64517/2, 0, -1}, {
                Part[$CellContext`inptrace1D$64517, 51], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$64517[51], 
               Table[0.07, {$CellContext`height$64517}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$64517, 56, 
               0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               56, 0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               56, 0.05, 0.], $CellContext`spheresize$64517]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$64517, 56], 0, -2}, {
                Part[$CellContext`inptrace1D$64517, 56], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$64517, 
                0, -1}, {$CellContext`posdamper$64517/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$64517/2, 0, -1}, {
                Part[$CellContext`inptrace1D$64517, 56], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$64517[56], 
               Table[0.07, {$CellContext`height$64517}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$64517, 61, 
               0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               61, 0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               61, 0.05, 0.], $CellContext`spheresize$64517]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$64517, 61], 0, -2}, {
                Part[$CellContext`inptrace1D$64517, 61], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$64517, 
                0, -1}, {$CellContext`posdamper$64517/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$64517/2, 0, -1}, {
                Part[$CellContext`inptrace1D$64517, 61], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$64517[61], 
               Table[0.07, {$CellContext`height$64517}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$64517, 66, 
               0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               66, 0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               66, 0.05, 0.], $CellContext`spheresize$64517]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$64517, 66], 0, -2}, {
                Part[$CellContext`inptrace1D$64517, 66], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$64517, 
                0, -1}, {$CellContext`posdamper$64517/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$64517/2, 0, -1}, {
                Part[$CellContext`inptrace1D$64517, 66], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$64517[66], 
               Table[0.07, {$CellContext`height$64517}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$64517, 71, 
               0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               71, 0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               71, 0.05, 0.], $CellContext`spheresize$64517]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$64517, 71], 0, -2}, {
                Part[$CellContext`inptrace1D$64517, 71], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$64517, 
                0, -1}, {$CellContext`posdamper$64517/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$64517/2, 0, -1}, {
                Part[$CellContext`inptrace1D$64517, 71], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$64517[71], 
               Table[0.07, {$CellContext`height$64517}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$64517, 76, 
               0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               76, 0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               76, 0.05, 0.], $CellContext`spheresize$64517]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$64517, 76], 0, -2}, {
                Part[$CellContext`inptrace1D$64517, 76], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$64517, 
                0, -1}, {$CellContext`posdamper$64517/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$64517/2, 0, -1}, {
                Part[$CellContext`inptrace1D$64517, 76], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$64517[76], 
               Table[0.07, {$CellContext`height$64517}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$64517, 81, 
               0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               81, 0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               81, 0.05, 0.], $CellContext`spheresize$64517]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$64517, 81], 0, -2}, {
                Part[$CellContext`inptrace1D$64517, 81], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$64517, 
                0, -1}, {$CellContext`posdamper$64517/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$64517/2, 0, -1}, {
                Part[$CellContext`inptrace1D$64517, 81], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$64517[81], 
               Table[0.07, {$CellContext`height$64517}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$64517, 86, 
               0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               86, 0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               86, 0.05, 0.], $CellContext`spheresize$64517]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$64517, 86], 0, -2}, {
                Part[$CellContext`inptrace1D$64517, 86], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$64517, 
                0, -1}, {$CellContext`posdamper$64517/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$64517/2, 0, -1}, {
                Part[$CellContext`inptrace1D$64517, 86], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$64517[86], 
               Table[0.07, {$CellContext`height$64517}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$64517, 91, 
               0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               91, 0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               91, 0.05, 0.], $CellContext`spheresize$64517]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$64517, 91], 0, -2}, {
                Part[$CellContext`inptrace1D$64517, 91], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$64517, 
                0, -1}, {$CellContext`posdamper$64517/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$64517/2, 0, -1}, {
                Part[$CellContext`inptrace1D$64517, 91], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$64517[91], 
               Table[0.07, {$CellContext`height$64517}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$64517, 96, 
               0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               96, 0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               96, 0.05, 0.], $CellContext`spheresize$64517]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$64517, 96], 0, -2}, {
                Part[$CellContext`inptrace1D$64517, 96], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$64517, 
                0, -1}, {$CellContext`posdamper$64517/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$64517/2, 0, -1}, {
                Part[$CellContext`inptrace1D$64517, 96], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$64517[96], 
               Table[0.07, {$CellContext`height$64517}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$64517, 101, 
               0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               101, 0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               101, 0.05, 0.], $CellContext`spheresize$64517]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$64517, 101], 0, -2}, {
                Part[$CellContext`inptrace1D$64517, 101], 0, -0.5}}, 0.4]]}, {
           
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$64517, 
                0, -1}, {$CellContext`posdamper$64517/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$64517/2, 0, -1}, {
                Part[$CellContext`inptrace1D$64517, 101], 0, -1.}}, 0.05]]}, {
           
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$64517[101], 
               Table[0.07, {$CellContext`height$64517}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$64517, 106, 
               0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               106, 0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               106, 0.05, 0.], $CellContext`spheresize$64517]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$64517, 106], 0, -2}, {
                Part[$CellContext`inptrace1D$64517, 106], 0, -0.5}}, 0.4]]}, {
           
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$64517, 
                0, -1}, {$CellContext`posdamper$64517/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$64517/2, 0, -1}, {
                Part[$CellContext`inptrace1D$64517, 106], 0, -1.}}, 0.05]]}, {
           
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$64517[106], 
               Table[0.07, {$CellContext`height$64517}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$64517, 111, 
               0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               111, 0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               111, 0.05, 0.], $CellContext`spheresize$64517]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$64517, 111], 0, -2}, {
                Part[$CellContext`inptrace1D$64517, 111], 0, -0.5}}, 0.4]]}, {
           
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$64517, 
                0, -1}, {$CellContext`posdamper$64517/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$64517/2, 0, -1}, {
                Part[$CellContext`inptrace1D$64517, 111], 0, -1.}}, 0.05]]}, {
           
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$64517[111], 
               Table[0.07, {$CellContext`height$64517}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$64517, 116, 
               0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               116, 0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               116, 0.05, 0.], $CellContext`spheresize$64517]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$64517, 116], 0, -2}, {
                Part[$CellContext`inptrace1D$64517, 116], 0, -0.5}}, 0.4]]}, {
           
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$64517, 
                0, -1}, {$CellContext`posdamper$64517/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$64517/2, 0, -1}, {
                Part[$CellContext`inptrace1D$64517, 116], 0, -1.}}, 0.05]]}, {
           
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$64517[116], 
               Table[0.07, {$CellContext`height$64517}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$64517, 121, 
               0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               121, 0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               121, 0.05, 0.], $CellContext`spheresize$64517]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$64517, 121], 0, -2}, {
                Part[$CellContext`inptrace1D$64517, 121], 0, -0.5}}, 0.4]]}, {
           
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$64517, 
                0, -1}, {$CellContext`posdamper$64517/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$64517/2, 0, -1}, {
                Part[$CellContext`inptrace1D$64517, 121], 0, -1.}}, 0.05]]}, {
           
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$64517[121], 
               Table[0.07, {$CellContext`height$64517}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$64517, 126, 
               0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               126, 0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               126, 0.05, 0.], $CellContext`spheresize$64517]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$64517, 126], 0, -2}, {
                Part[$CellContext`inptrace1D$64517, 126], 0, -0.5}}, 0.4]]}, {
           
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$64517, 
                0, -1}, {$CellContext`posdamper$64517/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$64517/2, 0, -1}, {
                Part[$CellContext`inptrace1D$64517, 126], 0, -1.}}, 0.05]]}, {
           
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$64517[126], 
               Table[0.07, {$CellContext`height$64517}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$64517, 131, 
               0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               131, 0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               131, 0.05, 0.], $CellContext`spheresize$64517]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$64517, 131], 0, -2}, {
                Part[$CellContext`inptrace1D$64517, 131], 0, -0.5}}, 0.4]]}, {
           
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$64517, 
                0, -1}, {$CellContext`posdamper$64517/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$64517/2, 0, -1}, {
                Part[$CellContext`inptrace1D$64517, 131], 0, -1.}}, 0.05]]}, {
           
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$64517[131], 
               Table[0.07, {$CellContext`height$64517}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$64517, 136, 
               0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               136, 0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               136, 0.05, 0.], $CellContext`spheresize$64517]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$64517, 136], 0, -2}, {
                Part[$CellContext`inptrace1D$64517, 136], 0, -0.5}}, 0.4]]}, {
           
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$64517, 
                0, -1}, {$CellContext`posdamper$64517/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$64517/2, 0, -1}, {
                Part[$CellContext`inptrace1D$64517, 136], 0, -1.}}, 0.05]]}, {
           
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$64517[136], 
               Table[0.07, {$CellContext`height$64517}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$64517, 141, 
               0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               141, 0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               141, 0.05, 0.], $CellContext`spheresize$64517]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$64517, 141], 0, -2}, {
                Part[$CellContext`inptrace1D$64517, 141], 0, -0.5}}, 0.4]]}, {
           
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$64517, 
                0, -1}, {$CellContext`posdamper$64517/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$64517/2, 0, -1}, {
                Part[$CellContext`inptrace1D$64517, 141], 0, -1.}}, 0.05]]}, {
           
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$64517[141], 
               Table[0.07, {$CellContext`height$64517}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$64517, 146, 
               0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               146, 0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               146, 0.05, 0.], $CellContext`spheresize$64517]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$64517, 146], 0, -2}, {
                Part[$CellContext`inptrace1D$64517, 146], 0, -0.5}}, 0.4]]}, {
           
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$64517, 
                0, -1}, {$CellContext`posdamper$64517/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$64517/2, 0, -1}, {
                Part[$CellContext`inptrace1D$64517, 146], 0, -1.}}, 0.05]]}, {
           
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$64517[146], 
               Table[0.07, {$CellContext`height$64517}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$64517, 151, 
               0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               151, 0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               151, 0.05, 0.], $CellContext`spheresize$64517]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$64517, 151], 0, -2}, {
                Part[$CellContext`inptrace1D$64517, 151], 0, -0.5}}, 0.4]]}, {
           
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$64517, 
                0, -1}, {$CellContext`posdamper$64517/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$64517/2, 0, -1}, {
                Part[$CellContext`inptrace1D$64517, 151], 0, -1.}}, 0.05]]}, {
           
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$64517[151], 
               Table[0.07, {$CellContext`height$64517}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$64517, 156, 
               0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               156, 0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               156, 0.05, 0.], $CellContext`spheresize$64517]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$64517, 156], 0, -2}, {
                Part[$CellContext`inptrace1D$64517, 156], 0, -0.5}}, 0.4]]}, {
           
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$64517, 
                0, -1}, {$CellContext`posdamper$64517/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$64517/2, 0, -1}, {
                Part[$CellContext`inptrace1D$64517, 156], 0, -1.}}, 0.05]]}, {
           
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$64517[156], 
               Table[0.07, {$CellContext`height$64517}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$64517, 161, 
               0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               161, 0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               161, 0.05, 0.], $CellContext`spheresize$64517]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$64517, 161], 0, -2}, {
                Part[$CellContext`inptrace1D$64517, 161], 0, -0.5}}, 0.4]]}, {
           
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$64517, 
                0, -1}, {$CellContext`posdamper$64517/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$64517/2, 0, -1}, {
                Part[$CellContext`inptrace1D$64517, 161], 0, -1.}}, 0.05]]}, {
           
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$64517[161], 
               Table[0.07, {$CellContext`height$64517}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$64517, 166, 
               0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               166, 0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               166, 0.05, 0.], $CellContext`spheresize$64517]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$64517, 166], 0, -2}, {
                Part[$CellContext`inptrace1D$64517, 166], 0, -0.5}}, 0.4]]}, {
           
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$64517, 
                0, -1}, {$CellContext`posdamper$64517/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$64517/2, 0, -1}, {
                Part[$CellContext`inptrace1D$64517, 166], 0, -1.}}, 0.05]]}, {
           
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$64517[166], 
               Table[0.07, {$CellContext`height$64517}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$64517, 171, 
               0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               171, 0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               171, 0.05, 0.], $CellContext`spheresize$64517]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$64517, 171], 0, -2}, {
                Part[$CellContext`inptrace1D$64517, 171], 0, -0.5}}, 0.4]]}, {
           
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$64517, 
                0, -1}, {$CellContext`posdamper$64517/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$64517/2, 0, -1}, {
                Part[$CellContext`inptrace1D$64517, 171], 0, -1.}}, 0.05]]}, {
           
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$64517[171], 
               Table[0.07, {$CellContext`height$64517}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$64517, 176, 
               0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               176, 0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               176, 0.05, 0.], $CellContext`spheresize$64517]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$64517, 176], 0, -2}, {
                Part[$CellContext`inptrace1D$64517, 176], 0, -0.5}}, 0.4]]}, {
           
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$64517, 
                0, -1}, {$CellContext`posdamper$64517/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$64517/2, 0, -1}, {
                Part[$CellContext`inptrace1D$64517, 176], 0, -1.}}, 0.05]]}, {
           
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$64517[176], 
               Table[0.07, {$CellContext`height$64517}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$64517, 181, 
               0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               181, 0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               181, 0.05, 0.], $CellContext`spheresize$64517]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$64517, 181], 0, -2}, {
                Part[$CellContext`inptrace1D$64517, 181], 0, -0.5}}, 0.4]]}, {
           
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$64517, 
                0, -1}, {$CellContext`posdamper$64517/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$64517/2, 0, -1}, {
                Part[$CellContext`inptrace1D$64517, 181], 0, -1.}}, 0.05]]}, {
           
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$64517[181], 
               Table[0.07, {$CellContext`height$64517}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$64517, 186, 
               0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               186, 0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               186, 0.05, 0.], $CellContext`spheresize$64517]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$64517, 186], 0, -2}, {
                Part[$CellContext`inptrace1D$64517, 186], 0, -0.5}}, 0.4]]}, {
           
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$64517, 
                0, -1}, {$CellContext`posdamper$64517/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$64517/2, 0, -1}, {
                Part[$CellContext`inptrace1D$64517, 186], 0, -1.}}, 0.05]]}, {
           
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$64517[186], 
               Table[0.07, {$CellContext`height$64517}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$64517, 191, 
               0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               191, 0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               191, 0.05, 0.], $CellContext`spheresize$64517]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$64517, 191], 0, -2}, {
                Part[$CellContext`inptrace1D$64517, 191], 0, -0.5}}, 0.4]]}, {
           
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$64517, 
                0, -1}, {$CellContext`posdamper$64517/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$64517/2, 0, -1}, {
                Part[$CellContext`inptrace1D$64517, 191], 0, -1.}}, 0.05]]}, {
           
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$64517[191], 
               Table[0.07, {$CellContext`height$64517}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$64517, 196, 
               0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               196, 0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               196, 0.05, 0.], $CellContext`spheresize$64517]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$64517, 196], 0, -2}, {
                Part[$CellContext`inptrace1D$64517, 196], 0, -0.5}}, 0.4]]}, {
           
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$64517, 
                0, -1}, {$CellContext`posdamper$64517/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$64517/2, 0, -1}, {
                Part[$CellContext`inptrace1D$64517, 196], 0, -1.}}, 0.05]]}, {
           
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$64517[196], 
               Table[0.07, {$CellContext`height$64517}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$64517, 201, 
               0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               201, 0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               201, 0.05, 0.], $CellContext`spheresize$64517]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$64517, 201], 0, -2}, {
                Part[$CellContext`inptrace1D$64517, 201], 0, -0.5}}, 0.4]]}, {
           
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$64517, 
                0, -1}, {$CellContext`posdamper$64517/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$64517/2, 0, -1}, {
                Part[$CellContext`inptrace1D$64517, 201], 0, -1.}}, 0.05]]}, {
           
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$64517[201], 
               Table[0.07, {$CellContext`height$64517}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$64517, 206, 
               0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               206, 0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               206, 0.05, 0.], $CellContext`spheresize$64517]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$64517, 206], 0, -2}, {
                Part[$CellContext`inptrace1D$64517, 206], 0, -0.5}}, 0.4]]}, {
           
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$64517, 
                0, -1}, {$CellContext`posdamper$64517/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$64517/2, 0, -1}, {
                Part[$CellContext`inptrace1D$64517, 206], 0, -1.}}, 0.05]]}, {
           
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$64517[206], 
               Table[0.07, {$CellContext`height$64517}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$64517, 211, 
               0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               211, 0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               211, 0.05, 0.], $CellContext`spheresize$64517]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$64517, 211], 0, -2}, {
                Part[$CellContext`inptrace1D$64517, 211], 0, -0.5}}, 0.4]]}, {
           
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$64517, 
                0, -1}, {$CellContext`posdamper$64517/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$64517/2, 0, -1}, {
                Part[$CellContext`inptrace1D$64517, 211], 0, -1.}}, 0.05]]}, {
           
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$64517[211], 
               Table[0.07, {$CellContext`height$64517}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$64517, 216, 
               0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               216, 0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               216, 0.05, 0.], $CellContext`spheresize$64517]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$64517, 216], 0, -2}, {
                Part[$CellContext`inptrace1D$64517, 216], 0, -0.5}}, 0.4]]}, {
           
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$64517, 
                0, -1}, {$CellContext`posdamper$64517/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$64517/2, 0, -1}, {
                Part[$CellContext`inptrace1D$64517, 216], 0, -1.}}, 0.05]]}, {
           
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$64517[216], 
               Table[0.07, {$CellContext`height$64517}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$64517, 221, 
               0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               221, 0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               221, 0.05, 0.], $CellContext`spheresize$64517]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$64517, 221], 0, -2}, {
                Part[$CellContext`inptrace1D$64517, 221], 0, -0.5}}, 0.4]]}, {
           
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$64517, 
                0, -1}, {$CellContext`posdamper$64517/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$64517/2, 0, -1}, {
                Part[$CellContext`inptrace1D$64517, 221], 0, -1.}}, 0.05]]}, {
           
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$64517[221], 
               Table[0.07, {$CellContext`height$64517}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$64517, 226, 
               0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               226, 0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               226, 0.05, 0.], $CellContext`spheresize$64517]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$64517, 226], 0, -2}, {
                Part[$CellContext`inptrace1D$64517, 226], 0, -0.5}}, 0.4]]}, {
           
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$64517, 
                0, -1}, {$CellContext`posdamper$64517/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$64517/2, 0, -1}, {
                Part[$CellContext`inptrace1D$64517, 226], 0, -1.}}, 0.05]]}, {
           
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$64517[226], 
               Table[0.07, {$CellContext`height$64517}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$64517, 231, 
               0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               231, 0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               231, 0.05, 0.], $CellContext`spheresize$64517]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$64517, 231], 0, -2}, {
                Part[$CellContext`inptrace1D$64517, 231], 0, -0.5}}, 0.4]]}, {
           
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$64517, 
                0, -1}, {$CellContext`posdamper$64517/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$64517/2, 0, -1}, {
                Part[$CellContext`inptrace1D$64517, 231], 0, -1.}}, 0.05]]}, {
           
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$64517[231], 
               Table[0.07, {$CellContext`height$64517}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$64517, 236, 
               0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               236, 0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               236, 0.05, 0.], $CellContext`spheresize$64517]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$64517, 236], 0, -2}, {
                Part[$CellContext`inptrace1D$64517, 236], 0, -0.5}}, 0.4]]}, {
           
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$64517, 
                0, -1}, {$CellContext`posdamper$64517/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$64517/2, 0, -1}, {
                Part[$CellContext`inptrace1D$64517, 236], 0, -1.}}, 0.05]]}, {
           
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$64517[236], 
               Table[0.07, {$CellContext`height$64517}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$64517, 241, 
               0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               241, 0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               241, 0.05, 0.], $CellContext`spheresize$64517]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$64517, 241], 0, -2}, {
                Part[$CellContext`inptrace1D$64517, 241], 0, -0.5}}, 0.4]]}, {
           
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$64517, 
                0, -1}, {$CellContext`posdamper$64517/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$64517/2, 0, -1}, {
                Part[$CellContext`inptrace1D$64517, 241], 0, -1.}}, 0.05]]}, {
           
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$64517[241], 
               Table[0.07, {$CellContext`height$64517}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$64517, 246, 
               0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               246, 0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               246, 0.05, 0.], $CellContext`spheresize$64517]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$64517, 246], 0, -2}, {
                Part[$CellContext`inptrace1D$64517, 246], 0, -0.5}}, 0.4]]}, {
           
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$64517, 
                0, -1}, {$CellContext`posdamper$64517/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$64517/2, 0, -1}, {
                Part[$CellContext`inptrace1D$64517, 246], 0, -1.}}, 0.05]]}, {
           
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$64517[246], 
               Table[0.07, {$CellContext`height$64517}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$64517, 251, 
               0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               251, 0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               251, 0.05, 0.], $CellContext`spheresize$64517]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$64517, 251], 0, -2}, {
                Part[$CellContext`inptrace1D$64517, 251], 0, -0.5}}, 0.4]]}, {
           
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$64517, 
                0, -1}, {$CellContext`posdamper$64517/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$64517/2, 0, -1}, {
                Part[$CellContext`inptrace1D$64517, 251], 0, -1.}}, 0.05]]}, {
           
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$64517[251], 
               Table[0.07, {$CellContext`height$64517}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$64517, 256, 
               0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               256, 0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               256, 0.05, 0.], $CellContext`spheresize$64517]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$64517, 256], 0, -2}, {
                Part[$CellContext`inptrace1D$64517, 256], 0, -0.5}}, 0.4]]}, {
           
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$64517, 
                0, -1}, {$CellContext`posdamper$64517/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$64517/2, 0, -1}, {
                Part[$CellContext`inptrace1D$64517, 256], 0, -1.}}, 0.05]]}, {
           
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$64517[256], 
               Table[0.07, {$CellContext`height$64517}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$64517, 261, 
               0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               261, 0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               261, 0.05, 0.], $CellContext`spheresize$64517]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$64517, 261], 0, -2}, {
                Part[$CellContext`inptrace1D$64517, 261], 0, -0.5}}, 0.4]]}, {
           
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$64517, 
                0, -1}, {$CellContext`posdamper$64517/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$64517/2, 0, -1}, {
                Part[$CellContext`inptrace1D$64517, 261], 0, -1.}}, 0.05]]}, {
           
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$64517[261], 
               Table[0.07, {$CellContext`height$64517}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$64517, 266, 
               0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               266, 0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               266, 0.05, 0.], $CellContext`spheresize$64517]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$64517, 266], 0, -2}, {
                Part[$CellContext`inptrace1D$64517, 266], 0, -0.5}}, 0.4]]}, {
           
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$64517, 
                0, -1}, {$CellContext`posdamper$64517/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$64517/2, 0, -1}, {
                Part[$CellContext`inptrace1D$64517, 266], 0, -1.}}, 0.05]]}, {
           
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$64517[266], 
               Table[0.07, {$CellContext`height$64517}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$64517, 271, 
               0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               271, 0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               271, 0.05, 0.], $CellContext`spheresize$64517]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$64517, 271], 0, -2}, {
                Part[$CellContext`inptrace1D$64517, 271], 0, -0.5}}, 0.4]]}, {
           
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$64517, 
                0, -1}, {$CellContext`posdamper$64517/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$64517/2, 0, -1}, {
                Part[$CellContext`inptrace1D$64517, 271], 0, -1.}}, 0.05]]}, {
           
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$64517[271], 
               Table[0.07, {$CellContext`height$64517}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$64517, 276, 
               0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               276, 0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               276, 0.05, 0.], $CellContext`spheresize$64517]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$64517, 276], 0, -2}, {
                Part[$CellContext`inptrace1D$64517, 276], 0, -0.5}}, 0.4]]}, {
           
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$64517, 
                0, -1}, {$CellContext`posdamper$64517/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$64517/2, 0, -1}, {
                Part[$CellContext`inptrace1D$64517, 276], 0, -1.}}, 0.05]]}, {
           
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$64517[276], 
               Table[0.07, {$CellContext`height$64517}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$64517, 281, 
               0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               281, 0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               281, 0.05, 0.], $CellContext`spheresize$64517]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$64517, 281], 0, -2}, {
                Part[$CellContext`inptrace1D$64517, 281], 0, -0.5}}, 0.4]]}, {
           
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$64517, 
                0, -1}, {$CellContext`posdamper$64517/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$64517/2, 0, -1}, {
                Part[$CellContext`inptrace1D$64517, 281], 0, -1.}}, 0.05]]}, {
           
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$64517[281], 
               Table[0.07, {$CellContext`height$64517}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$64517, 286, 
               0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               286, 0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               286, 0.05, 0.], $CellContext`spheresize$64517]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$64517, 286], 0, -2}, {
                Part[$CellContext`inptrace1D$64517, 286], 0, -0.5}}, 0.4]]}, {
           
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$64517, 
                0, -1}, {$CellContext`posdamper$64517/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$64517/2, 0, -1}, {
                Part[$CellContext`inptrace1D$64517, 286], 0, -1.}}, 0.05]]}, {
           
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$64517[286], 
               Table[0.07, {$CellContext`height$64517}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$64517, 291, 
               0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               291, 0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               291, 0.05, 0.], $CellContext`spheresize$64517]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$64517, 291], 0, -2}, {
                Part[$CellContext`inptrace1D$64517, 291], 0, -0.5}}, 0.4]]}, {
           
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$64517, 
                0, -1}, {$CellContext`posdamper$64517/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$64517/2, 0, -1}, {
                Part[$CellContext`inptrace1D$64517, 291], 0, -1.}}, 0.05]]}, {
           
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$64517[291], 
               Table[0.07, {$CellContext`height$64517}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$64517, 296, 
               0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               296, 0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               296, 0.05, 0.], $CellContext`spheresize$64517]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$64517, 296], 0, -2}, {
                Part[$CellContext`inptrace1D$64517, 296], 0, -0.5}}, 0.4]]}, {
           
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$64517, 
                0, -1}, {$CellContext`posdamper$64517/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$64517/2, 0, -1}, {
                Part[$CellContext`inptrace1D$64517, 296], 0, -1.}}, 0.05]]}, {
           
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$64517[296], 
               Table[0.07, {$CellContext`height$64517}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$64517, 301, 
               0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               301, 0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               301, 0.05, 0.], $CellContext`spheresize$64517]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$64517, 301], 0, -2}, {
                Part[$CellContext`inptrace1D$64517, 301], 0, -0.5}}, 0.4]]}, {
           
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$64517, 
                0, -1}, {$CellContext`posdamper$64517/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$64517/2, 0, -1}, {
                Part[$CellContext`inptrace1D$64517, 301], 0, -1.}}, 0.05]]}, {
           
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$64517[301], 
               Table[0.07, {$CellContext`height$64517}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$64517, 306, 
               0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               306, 0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               306, 0.05, 0.], $CellContext`spheresize$64517]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$64517, 306], 0, -2}, {
                Part[$CellContext`inptrace1D$64517, 306], 0, -0.5}}, 0.4]]}, {
           
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$64517, 
                0, -1}, {$CellContext`posdamper$64517/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$64517/2, 0, -1}, {
                Part[$CellContext`inptrace1D$64517, 306], 0, -1.}}, 0.05]]}, {
           
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$64517[306], 
               Table[0.07, {$CellContext`height$64517}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$64517, 311, 
               0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               311, 0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               311, 0.05, 0.], $CellContext`spheresize$64517]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$64517, 311], 0, -2}, {
                Part[$CellContext`inptrace1D$64517, 311], 0, -0.5}}, 0.4]]}, {
           
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$64517, 
                0, -1}, {$CellContext`posdamper$64517/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$64517/2, 0, -1}, {
                Part[$CellContext`inptrace1D$64517, 311], 0, -1.}}, 0.05]]}, {
           
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$64517[311], 
               Table[0.07, {$CellContext`height$64517}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$64517, 316, 
               0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               316, 0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               316, 0.05, 0.], $CellContext`spheresize$64517]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$64517, 316], 0, -2}, {
                Part[$CellContext`inptrace1D$64517, 316], 0, -0.5}}, 0.4]]}, {
           
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$64517, 
                0, -1}, {$CellContext`posdamper$64517/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$64517/2, 0, -1}, {
                Part[$CellContext`inptrace1D$64517, 316], 0, -1.}}, 0.05]]}, {
           
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$64517[316], 
               Table[0.07, {$CellContext`height$64517}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$64517, 321, 
               0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               321, 0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               321, 0.05, 0.], $CellContext`spheresize$64517]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$64517, 321], 0, -2}, {
                Part[$CellContext`inptrace1D$64517, 321], 0, -0.5}}, 0.4]]}, {
           
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$64517, 
                0, -1}, {$CellContext`posdamper$64517/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$64517/2, 0, -1}, {
                Part[$CellContext`inptrace1D$64517, 321], 0, -1.}}, 0.05]]}, {
           
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$64517[321], 
               Table[0.07, {$CellContext`height$64517}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$64517, 326, 
               0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               326, 0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               326, 0.05, 0.], $CellContext`spheresize$64517]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$64517, 326], 0, -2}, {
                Part[$CellContext`inptrace1D$64517, 326], 0, -0.5}}, 0.4]]}, {
           
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$64517, 
                0, -1}, {$CellContext`posdamper$64517/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$64517/2, 0, -1}, {
                Part[$CellContext`inptrace1D$64517, 326], 0, -1.}}, 0.05]]}, {
           
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$64517[326], 
               Table[0.07, {$CellContext`height$64517}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$64517, 331, 
               0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               331, 0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               331, 0.05, 0.], $CellContext`spheresize$64517]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$64517, 331], 0, -2}, {
                Part[$CellContext`inptrace1D$64517, 331], 0, -0.5}}, 0.4]]}, {
           
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$64517, 
                0, -1}, {$CellContext`posdamper$64517/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$64517/2, 0, -1}, {
                Part[$CellContext`inptrace1D$64517, 331], 0, -1.}}, 0.05]]}, {
           
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$64517[331], 
               Table[0.07, {$CellContext`height$64517}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$64517, 336, 
               0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               336, 0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               336, 0.05, 0.], $CellContext`spheresize$64517]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$64517, 336], 0, -2}, {
                Part[$CellContext`inptrace1D$64517, 336], 0, -0.5}}, 0.4]]}, {
           
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$64517, 
                0, -1}, {$CellContext`posdamper$64517/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$64517/2, 0, -1}, {
                Part[$CellContext`inptrace1D$64517, 336], 0, -1.}}, 0.05]]}, {
           
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$64517[336], 
               Table[0.07, {$CellContext`height$64517}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$64517, 341, 
               0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               341, 0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               341, 0.05, 0.], $CellContext`spheresize$64517]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$64517, 341], 0, -2}, {
                Part[$CellContext`inptrace1D$64517, 341], 0, -0.5}}, 0.4]]}, {
           
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$64517, 
                0, -1}, {$CellContext`posdamper$64517/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$64517/2, 0, -1}, {
                Part[$CellContext`inptrace1D$64517, 341], 0, -1.}}, 0.05]]}, {
           
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$64517[341], 
               Table[0.07, {$CellContext`height$64517}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$64517, 346, 
               0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               346, 0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               346, 0.05, 0.], $CellContext`spheresize$64517]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$64517, 346], 0, -2}, {
                Part[$CellContext`inptrace1D$64517, 346], 0, -0.5}}, 0.4]]}, {
           
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$64517, 
                0, -1}, {$CellContext`posdamper$64517/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$64517/2, 0, -1}, {
                Part[$CellContext`inptrace1D$64517, 346], 0, -1.}}, 0.05]]}, {
           
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$64517[346], 
               Table[0.07, {$CellContext`height$64517}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$64517, 351, 
               0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               351, 0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               351, 0.05, 0.], $CellContext`spheresize$64517]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$64517, 351], 0, -2}, {
                Part[$CellContext`inptrace1D$64517, 351], 0, -0.5}}, 0.4]]}, {
           
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$64517, 
                0, -1}, {$CellContext`posdamper$64517/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$64517/2, 0, -1}, {
                Part[$CellContext`inptrace1D$64517, 351], 0, -1.}}, 0.05]]}, {
           
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$64517[351], 
               Table[0.07, {$CellContext`height$64517}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$64517, 356, 
               0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               356, 0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               356, 0.05, 0.], $CellContext`spheresize$64517]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$64517, 356], 0, -2}, {
                Part[$CellContext`inptrace1D$64517, 356], 0, -0.5}}, 0.4]]}, {
           
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$64517, 
                0, -1}, {$CellContext`posdamper$64517/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$64517/2, 0, -1}, {
                Part[$CellContext`inptrace1D$64517, 356], 0, -1.}}, 0.05]]}, {
           
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$64517[356], 
               Table[0.07, {$CellContext`height$64517}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$64517, 361, 
               0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               361, 0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               361, 0.05, 0.], $CellContext`spheresize$64517]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$64517, 361], 0, -2}, {
                Part[$CellContext`inptrace1D$64517, 361], 0, -0.5}}, 0.4]]}, {
           
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$64517, 
                0, -1}, {$CellContext`posdamper$64517/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$64517/2, 0, -1}, {
                Part[$CellContext`inptrace1D$64517, 361], 0, -1.}}, 0.05]]}, {
           
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$64517[361], 
               Table[0.07, {$CellContext`height$64517}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$64517, 366, 
               0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               366, 0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               366, 0.05, 0.], $CellContext`spheresize$64517]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$64517, 366], 0, -2}, {
                Part[$CellContext`inptrace1D$64517, 366], 0, -0.5}}, 0.4]]}, {
           
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$64517, 
                0, -1}, {$CellContext`posdamper$64517/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$64517/2, 0, -1}, {
                Part[$CellContext`inptrace1D$64517, 366], 0, -1.}}, 0.05]]}, {
           
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$64517[366], 
               Table[0.07, {$CellContext`height$64517}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$64517, 371, 
               0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               371, 0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               371, 0.05, 0.], $CellContext`spheresize$64517]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$64517, 371], 0, -2}, {
                Part[$CellContext`inptrace1D$64517, 371], 0, -0.5}}, 0.4]]}, {
           
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$64517, 
                0, -1}, {$CellContext`posdamper$64517/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$64517/2, 0, -1}, {
                Part[$CellContext`inptrace1D$64517, 371], 0, -1.}}, 0.05]]}, {
           
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$64517[371], 
               Table[0.07, {$CellContext`height$64517}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$64517, 376, 
               0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               376, 0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               376, 0.05, 0.], $CellContext`spheresize$64517]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$64517, 376], 0, -2}, {
                Part[$CellContext`inptrace1D$64517, 376], 0, -0.5}}, 0.4]]}, {
           
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$64517, 
                0, -1}, {$CellContext`posdamper$64517/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$64517/2, 0, -1}, {
                Part[$CellContext`inptrace1D$64517, 376], 0, -1.}}, 0.05]]}, {
           
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$64517[376], 
               Table[0.07, {$CellContext`height$64517}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$64517, 381, 
               0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               381, 0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               381, 0.05, 0.], $CellContext`spheresize$64517]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$64517, 381], 0, -2}, {
                Part[$CellContext`inptrace1D$64517, 381], 0, -0.5}}, 0.4]]}, {
           
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$64517, 
                0, -1}, {$CellContext`posdamper$64517/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$64517/2, 0, -1}, {
                Part[$CellContext`inptrace1D$64517, 381], 0, -1.}}, 0.05]]}, {
           
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$64517[381], 
               Table[0.07, {$CellContext`height$64517}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$64517, 386, 
               0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               386, 0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               386, 0.05, 0.], $CellContext`spheresize$64517]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$64517, 386], 0, -2}, {
                Part[$CellContext`inptrace1D$64517, 386], 0, -0.5}}, 0.4]]}, {
           
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$64517, 
                0, -1}, {$CellContext`posdamper$64517/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$64517/2, 0, -1}, {
                Part[$CellContext`inptrace1D$64517, 386], 0, -1.}}, 0.05]]}, {
           
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$64517[386], 
               Table[0.07, {$CellContext`height$64517}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$64517, 391, 
               0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               391, 0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               391, 0.05, 0.], $CellContext`spheresize$64517]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$64517, 391], 0, -2}, {
                Part[$CellContext`inptrace1D$64517, 391], 0, -0.5}}, 0.4]]}, {
           
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$64517, 
                0, -1}, {$CellContext`posdamper$64517/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$64517/2, 0, -1}, {
                Part[$CellContext`inptrace1D$64517, 391], 0, -1.}}, 0.05]]}, {
           
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$64517[391], 
               Table[0.07, {$CellContext`height$64517}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$64517, 396, 
               0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               396, 0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               396, 0.05, 0.], $CellContext`spheresize$64517]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$64517, 396], 0, -2}, {
                Part[$CellContext`inptrace1D$64517, 396], 0, -0.5}}, 0.4]]}, {
           
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$64517, 
                0, -1}, {$CellContext`posdamper$64517/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$64517/2, 0, -1}, {
                Part[$CellContext`inptrace1D$64517, 396], 0, -1.}}, 0.05]]}, {
           
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$64517[396], 
               Table[0.07, {$CellContext`height$64517}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$64517, 401, 
               0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               401, 0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               401, 0.05, 0.], $CellContext`spheresize$64517]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$64517, 401], 0, -2}, {
                Part[$CellContext`inptrace1D$64517, 401], 0, -0.5}}, 0.4]]}, {
           
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$64517, 
                0, -1}, {$CellContext`posdamper$64517/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$64517/2, 0, -1}, {
                Part[$CellContext`inptrace1D$64517, 401], 0, -1.}}, 0.05]]}, {
           
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$64517[401], 
               Table[0.07, {$CellContext`height$64517}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$64517, 406, 
               0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               406, 0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               406, 0.05, 0.], $CellContext`spheresize$64517]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$64517, 406], 0, -2}, {
                Part[$CellContext`inptrace1D$64517, 406], 0, -0.5}}, 0.4]]}, {
           
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$64517, 
                0, -1}, {$CellContext`posdamper$64517/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$64517/2, 0, -1}, {
                Part[$CellContext`inptrace1D$64517, 406], 0, -1.}}, 0.05]]}, {
           
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$64517[406], 
               Table[0.07, {$CellContext`height$64517}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$64517, 411, 
               0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               411, 0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               411, 0.05, 0.], $CellContext`spheresize$64517]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$64517, 411], 0, -2}, {
                Part[$CellContext`inptrace1D$64517, 411], 0, -0.5}}, 0.4]]}, {
           
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$64517, 
                0, -1}, {$CellContext`posdamper$64517/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$64517/2, 0, -1}, {
                Part[$CellContext`inptrace1D$64517, 411], 0, -1.}}, 0.05]]}, {
           
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$64517[411], 
               Table[0.07, {$CellContext`height$64517}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$64517, 416, 
               0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               416, 0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               416, 0.05, 0.], $CellContext`spheresize$64517]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$64517, 416], 0, -2}, {
                Part[$CellContext`inptrace1D$64517, 416], 0, -0.5}}, 0.4]]}, {
           
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$64517, 
                0, -1}, {$CellContext`posdamper$64517/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$64517/2, 0, -1}, {
                Part[$CellContext`inptrace1D$64517, 416], 0, -1.}}, 0.05]]}, {
           
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$64517[416], 
               Table[0.07, {$CellContext`height$64517}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$64517, 421, 
               0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               421, 0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               421, 0.05, 0.], $CellContext`spheresize$64517]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$64517, 421], 0, -2}, {
                Part[$CellContext`inptrace1D$64517, 421], 0, -0.5}}, 0.4]]}, {
           
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$64517, 
                0, -1}, {$CellContext`posdamper$64517/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$64517/2, 0, -1}, {
                Part[$CellContext`inptrace1D$64517, 421], 0, -1.}}, 0.05]]}, {
           
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$64517[421], 
               Table[0.07, {$CellContext`height$64517}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$64517, 426, 
               0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               426, 0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               426, 0.05, 0.], $CellContext`spheresize$64517]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$64517, 426], 0, -2}, {
                Part[$CellContext`inptrace1D$64517, 426], 0, -0.5}}, 0.4]]}, {
           
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$64517, 
                0, -1}, {$CellContext`posdamper$64517/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$64517/2, 0, -1}, {
                Part[$CellContext`inptrace1D$64517, 426], 0, -1.}}, 0.05]]}, {
           
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$64517[426], 
               Table[0.07, {$CellContext`height$64517}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$64517, 431, 
               0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               431, 0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               431, 0.05, 0.], $CellContext`spheresize$64517]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$64517, 431], 0, -2}, {
                Part[$CellContext`inptrace1D$64517, 431], 0, -0.5}}, 0.4]]}, {
           
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$64517, 
                0, -1}, {$CellContext`posdamper$64517/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$64517/2, 0, -1}, {
                Part[$CellContext`inptrace1D$64517, 431], 0, -1.}}, 0.05]]}, {
           
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$64517[431], 
               Table[0.07, {$CellContext`height$64517}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$64517, 436, 
               0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               436, 0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               436, 0.05, 0.], $CellContext`spheresize$64517]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$64517, 436], 0, -2}, {
                Part[$CellContext`inptrace1D$64517, 436], 0, -0.5}}, 0.4]]}, {
           
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$64517, 
                0, -1}, {$CellContext`posdamper$64517/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$64517/2, 0, -1}, {
                Part[$CellContext`inptrace1D$64517, 436], 0, -1.}}, 0.05]]}, {
           
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$64517[436], 
               Table[0.07, {$CellContext`height$64517}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$64517, 441, 
               0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               441, 0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               441, 0.05, 0.], $CellContext`spheresize$64517]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$64517, 441], 0, -2}, {
                Part[$CellContext`inptrace1D$64517, 441], 0, -0.5}}, 0.4]]}, {
           
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$64517, 
                0, -1}, {$CellContext`posdamper$64517/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$64517/2, 0, -1}, {
                Part[$CellContext`inptrace1D$64517, 441], 0, -1.}}, 0.05]]}, {
           
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$64517[441], 
               Table[0.07, {$CellContext`height$64517}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$64517, 446, 
               0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               446, 0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               446, 0.05, 0.], $CellContext`spheresize$64517]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$64517, 446], 0, -2}, {
                Part[$CellContext`inptrace1D$64517, 446], 0, -0.5}}, 0.4]]}, {
           
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$64517, 
                0, -1}, {$CellContext`posdamper$64517/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$64517/2, 0, -1}, {
                Part[$CellContext`inptrace1D$64517, 446], 0, -1.}}, 0.05]]}, {
           
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$64517[446], 
               Table[0.07, {$CellContext`height$64517}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$64517, 451, 
               0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               451, 0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               451, 0.05, 0.], $CellContext`spheresize$64517]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$64517, 451], 0, -2}, {
                Part[$CellContext`inptrace1D$64517, 451], 0, -0.5}}, 0.4]]}, {
           
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$64517, 
                0, -1}, {$CellContext`posdamper$64517/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$64517/2, 0, -1}, {
                Part[$CellContext`inptrace1D$64517, 451], 0, -1.}}, 0.05]]}, {
           
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$64517[451], 
               Table[0.07, {$CellContext`height$64517}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$64517, 456, 
               0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               456, 0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               456, 0.05, 0.], $CellContext`spheresize$64517]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$64517, 456], 0, -2}, {
                Part[$CellContext`inptrace1D$64517, 456], 0, -0.5}}, 0.4]]}, {
           
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$64517, 
                0, -1}, {$CellContext`posdamper$64517/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$64517/2, 0, -1}, {
                Part[$CellContext`inptrace1D$64517, 456], 0, -1.}}, 0.05]]}, {
           
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$64517[456], 
               Table[0.07, {$CellContext`height$64517}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$64517, 461, 
               0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               461, 0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               461, 0.05, 0.], $CellContext`spheresize$64517]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$64517, 461], 0, -2}, {
                Part[$CellContext`inptrace1D$64517, 461], 0, -0.5}}, 0.4]]}, {
           
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$64517, 
                0, -1}, {$CellContext`posdamper$64517/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$64517/2, 0, -1}, {
                Part[$CellContext`inptrace1D$64517, 461], 0, -1.}}, 0.05]]}, {
           
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$64517[461], 
               Table[0.07, {$CellContext`height$64517}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$64517, 466, 
               0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               466, 0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               466, 0.05, 0.], $CellContext`spheresize$64517]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$64517, 466], 0, -2}, {
                Part[$CellContext`inptrace1D$64517, 466], 0, -0.5}}, 0.4]]}, {
           
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$64517, 
                0, -1}, {$CellContext`posdamper$64517/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$64517/2, 0, -1}, {
                Part[$CellContext`inptrace1D$64517, 466], 0, -1.}}, 0.05]]}, {
           
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$64517[466], 
               Table[0.07, {$CellContext`height$64517}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$64517, 471, 
               0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               471, 0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               471, 0.05, 0.], $CellContext`spheresize$64517]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$64517, 471], 0, -2}, {
                Part[$CellContext`inptrace1D$64517, 471], 0, -0.5}}, 0.4]]}, {
           
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$64517, 
                0, -1}, {$CellContext`posdamper$64517/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$64517/2, 0, -1}, {
                Part[$CellContext`inptrace1D$64517, 471], 0, -1.}}, 0.05]]}, {
           
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$64517[471], 
               Table[0.07, {$CellContext`height$64517}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$64517, 476, 
               0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               476, 0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               476, 0.05, 0.], $CellContext`spheresize$64517]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$64517, 476], 0, -2}, {
                Part[$CellContext`inptrace1D$64517, 476], 0, -0.5}}, 0.4]]}, {
           
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$64517, 
                0, -1}, {$CellContext`posdamper$64517/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$64517/2, 0, -1}, {
                Part[$CellContext`inptrace1D$64517, 476], 0, -1.}}, 0.05]]}, {
           
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$64517[476], 
               Table[0.07, {$CellContext`height$64517}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$64517, 481, 
               0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               481, 0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               481, 0.05, 0.], $CellContext`spheresize$64517]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$64517, 481], 0, -2}, {
                Part[$CellContext`inptrace1D$64517, 481], 0, -0.5}}, 0.4]]}, {
           
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$64517, 
                0, -1}, {$CellContext`posdamper$64517/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$64517/2, 0, -1}, {
                Part[$CellContext`inptrace1D$64517, 481], 0, -1.}}, 0.05]]}, {
           
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$64517[481], 
               Table[0.07, {$CellContext`height$64517}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$64517, 486, 
               0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               486, 0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               486, 0.05, 0.], $CellContext`spheresize$64517]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$64517, 486], 0, -2}, {
                Part[$CellContext`inptrace1D$64517, 486], 0, -0.5}}, 0.4]]}, {
           
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$64517, 
                0, -1}, {$CellContext`posdamper$64517/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$64517/2, 0, -1}, {
                Part[$CellContext`inptrace1D$64517, 486], 0, -1.}}, 0.05]]}, {
           
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$64517[486], 
               Table[0.07, {$CellContext`height$64517}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$64517, 491, 
               0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               491, 0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               491, 0.05, 0.], $CellContext`spheresize$64517]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$64517, 491], 0, -2}, {
                Part[$CellContext`inptrace1D$64517, 491], 0, -0.5}}, 0.4]]}, {
           
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$64517, 
                0, -1}, {$CellContext`posdamper$64517/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$64517/2, 0, -1}, {
                Part[$CellContext`inptrace1D$64517, 491], 0, -1.}}, 0.05]]}, {
           
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$64517[491], 
               Table[0.07, {$CellContext`height$64517}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$64517, 496, 
               0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               496, 0.05, $CellContext`timeiv$64517]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$64517, 
               496, 0.05, 0.], $CellContext`spheresize$64517]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$64517, 496], 0, -2}, {
                Part[$CellContext`inptrace1D$64517, 496], 0, -0.5}}, 0.4]]}, {
           
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$64517, 
                0, -1}, {$CellContext`posdamper$64517/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$64517/2, 0, -1}, {
                Part[$CellContext`inptrace1D$64517, 496], 0, -1.}}, 0.05]]}, {
           
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$64517[496], 
               Table[0.07, {$CellContext`height$64517}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}]}, $CellContext`recenterintval[
         Pattern[$CellContext`dat3D, 
          Blank[]], 
         Pattern[$CellContext`k, 
          Blank[]], 
         Pattern[$CellContext`dt, 
          Blank[]], 
         Pattern[$CellContext`ivsec, 
          Blank[]]] := 
       Module[{$CellContext`iv, $CellContext`x, $CellContext`time, \
$CellContext`z}, If[$CellContext`ivsec > 0, $CellContext`iv = {
             Max[
              
              Round[$CellContext`k - 
               0.1 ($CellContext`ivsec/$CellContext`dt)], 1], 
             Min[
              
              Round[$CellContext`k + 
               0.9 ($CellContext`ivsec/$CellContext`dt)], 
              
              Length[$CellContext`dat3D]]}, $CellContext`iv = \
{$CellContext`k}; Null]; {$CellContext`x, $CellContext`time, $CellContext`z} = 
          Transpose[
            Take[$CellContext`dat3D, $CellContext`iv]]; 
         Transpose[{$CellContext`x, $CellContext`time - ($CellContext`k - 
             1) $CellContext`dt, $CellContext`z}]], $CellContext`dt = 
       0.005, $CellContext`time = CompressedData["
1:eJwt1MmKY1UAx+HTU3V1d3V1zfOUmucpNe0qD5CVu2yFjksXeYE8QF7g+AAB
13flLuBKOIIgCAEXinJQFGlNq622A+X97qKKOue7P/6EUJV333/n5b0Qwuu7
H54P4t3z4W35+6Pbi+rd87G/P7kt1WfOP799r3n3fOG+f/tpunu+5L5y/jX/
jftvvZe577jvuR+4H7mfuFfOX/E/u//FewPuNfea+5X7jfude8O94f7g/uT+
4t5yb7m/uX+4f7lQK89DrfSh9v919V6tfO9erWT3ufvc/VrZecA94B5yD7mH
3CPuETfEDXFD3GPuMTfMDXPD3BPuCfeUe8o95Z5xz7gRboQb4Z5zz7lRbpQb
5V5wL7gxn9cYP+Z+zHtj3Dg3zo1z49w4N8FNcBPcBDfBTdozyU1yk9wkN8VN
cVPcFDfFTXPT3DQ3zU1zM9wMN8PNcDPcLDfLzXKz3Cw3x81xc9wcN8fNc/Pc
PDfPzXML3AK3wC1wC9wit8gtcovcIrfELXFL3BK3xC1zy9wyt8wtcyvcCrfC
rXAr3Cq3yq1yq9wqt1aez6/53qyV9/U1762Vrs1FruASl7lQ0avoVfQqehU9
LnIFl7jMhXW9db11vXW9dT0ucgWXuMyFDb0Nn8+G3obehh4XuYJLXObCpt6m
3qbept6mHhe5gktc5sKW3pbelt6W3pYeF7mCS1zmwrbett623rbeth4XuYJL
XObCjt6O3o7ejt6OHhe5gktc5sKu3q7ert6u3q4eF7mCS1zmwp7ent6e3p7e
nh4XuYJLXObCvt6+3r7evt6+Hhe5gktc5sKB3oHegd6B3oEeF7mCS1zmwqHe
od6h3qHeoR4XuYJLXObCkd6R3pHekd6RHhe5gktc5sKx3rHesd6x3rEeF7mC
S1zmwoneid6J3oneiR4XuYJLXObCaXk+cqp7Wt5vn/p/c1q6GlfnGlyTa3Ft
rsNFrssVXI9LXJ/L3IALZ/ad2Xdm35l9Z/Zxda7BNbkW1+Y6XOS6XMH1uMT1
ucwNuHBu37l95/ad23duH1fnGlyTa3FtrsNFrssVXI9LXJ/L3IALVfuq9lXt
q/r+VO3j6lyDa3Itrs11uMh1uYLrcYnrc5kbcOHCvgv7Luy7sO/CPq7ONbgm
1+LaXIeLXJcruB6XuD6XuQEXLu27tO/Svkv7Lu3j6lyDa3Itrs11uMh1uYLr
cYnrc5kbcOHKviv7ruy7su/KPq7ONbgm1+LaXIeLXJcruB6XuD6XuQEXru27
tu/avmv7ru3j6lyDa3Itrs11uMh1uYLrcYnrc5kbcOHGvhv7buy7se/GPq7O
Nbgm1+LaXIeLXJcruB6XuD6XucFN7T/4YKr+
        "], 
       Attributes[$CellContext`inptrace3D$64517] = {
        Temporary}, $CellContext`inptrace3D$64517 = {{0, 0., -2.}, {
         0, 0.05, -2.}, {0, 0.1, -2.}, {0, 0.15000000000000002`, -2.}, {
         0, 0.2, -2.}, {0, 0.25, -2.}, {0, 0.30000000000000004`, -2.}, {
         0, 0.35000000000000003`, -2.}, {0, 0.4, -2.}, {0, 0.45, -2.}, {
         0, 0.5, -2.}, {0, 0.55, -2.}, {0, 0.6000000000000001, -2.}, {
         0, 0.65, -2.}, {0, 0.7000000000000001, -2.}, {0, 0.75, -2.}, {
         0, 0.8, -2.}, {0, 0.8500000000000001, -2.}, {0, 0.9, -2.}, {
         0, 0.9500000000000001, -2.}, {0, 1., -2.}, {0, 1.05, -2.}, {
         0, 1.1, -2.}, {0, 1.1500000000000001`, -2.}, {
         0, 1.2000000000000002`, -2.}, {0, 1.25, -2.}, {0, 1.3, -2.}, {
         0, 1.35, -2.}, {0, 1.4000000000000001`, -2.}, {
         0, 1.4500000000000002`, -2.}, {0, 1.5, -2.}, {0, 1.55, -2.}, {
         0, 1.6, -2.}, {0, 1.6500000000000001`, -2.}, {
         0, 1.7000000000000002`, -2.}, {0, 1.75, -2.}, {0, 1.8, -2.}, {
         0, 1.85, -2.}, {0, 1.9000000000000001`, -2.}, {
         0, 1.9500000000000002`, -2.}, {0, 2., -2.}, {
         0, 2.0500000000000003`, -2.}, {0, 2.1, -2.}, {0, 2.15, -2.}, {
         0, 2.2, -2.}, {0, 2.25, -2.}, {0, 2.3000000000000003`, -2.}, {
         0, 2.35, -2.}, {0, 2.4000000000000004`, -2.}, {0, 2.45, -2.}, {
         1, 2.5, -2.}, {1, 2.5500000000000003`, -2.}, {1, 2.6, -2.}, {
         1, 2.6500000000000004`, -2.}, {1, 2.7, -2.}, {1, 2.75, -2.}, {
         1, 2.8000000000000003`, -2.}, {1, 2.85, -2.}, {
         1, 2.9000000000000004`, -2.}, {1, 2.95, -2.}, {1, 3., -2.}, {
         1, 3.0500000000000003`, -2.}, {1, 3.1, -2.}, {
         1, 3.1500000000000004`, -2.}, {1, 3.2, -2.}, {1, 3.25, -2.}, {
         1, 3.3000000000000003`, -2.}, {1, 3.35, -2.}, {
         1, 3.4000000000000004`, -2.}, {1, 3.45, -2.}, {1, 3.5, -2.}, {
         1, 3.5500000000000003`, -2.}, {1, 3.6, -2.}, {
         1, 3.6500000000000004`, -2.}, {1, 3.7, -2.}, {1, 3.75, -2.}, {
         1, 3.8000000000000003`, -2.}, {1, 3.85, -2.}, {
         1, 3.9000000000000004`, -2.}, {1, 3.95, -2.}, {1, 4., -2.}, {
         1, 4.05, -2.}, {1, 4.1000000000000005`, -2.}, {1, 4.15, -2.}, {
         1, 4.2, -2.}, {1, 4.25, -2.}, {1, 4.3, -2.}, {
         1, 4.3500000000000005`, -2.}, {1, 4.4, -2.}, {1, 4.45, -2.}, {
         1, 4.5, -2.}, {1, 4.55, -2.}, {1, 4.6000000000000005`, -2.}, {
         1, 4.65, -2.}, {1, 4.7, -2.}, {1, 4.75, -2.}, {
         1, 4.800000000000001, -2.}, {1, 4.8500000000000005`, -2.}, {
         1, 4.9, -2.}, {1, 4.95, -2.}, {1, 5., -2.}, {
         1, 5.050000000000001, -2.}, {1, 5.1000000000000005`, -2.}, {
         1, 5.15, -2.}, {1, 5.2, -2.}, {1, 5.25, -2.}, {
         1, 5.300000000000001, -2.}, {1, 5.3500000000000005`, -2.}, {
         1, 5.4, -2.}, {1, 5.45, -2.}, {1, 5.5, -2.}, {
         1, 5.550000000000001, -2.}, {1, 5.6000000000000005`, -2.}, {
         1, 5.65, -2.}, {1, 5.7, -2.}, {1, 5.75, -2.}, {
         1, 5.800000000000001, -2.}, {1, 5.8500000000000005`, -2.}, {
         1, 5.9, -2.}, {1, 5.95, -2.}, {1, 6., -2.}, {
         1, 6.050000000000001, -2.}, {1, 6.1000000000000005`, -2.}, {
         1, 6.15, -2.}, {1, 6.2, -2.}, {1, 6.25, -2.}, {
         1, 6.300000000000001, -2.}, {1, 6.3500000000000005`, -2.}, {
         1, 6.4, -2.}, {1, 6.45, -2.}, {1, 6.5, -2.}, {
         1, 6.550000000000001, -2.}, {1, 6.6000000000000005`, -2.}, {
         1, 6.65, -2.}, {1, 6.7, -2.}, {1, 6.75, -2.}, {
         1, 6.800000000000001, -2.}, {1, 6.8500000000000005`, -2.}, {
         1, 6.9, -2.}, {1, 6.95, -2.}, {1, 7., -2.}, {
         1, 7.050000000000001, -2.}, {1, 7.1000000000000005`, -2.}, {
         1, 7.15, -2.}, {1, 7.2, -2.}, {1, 7.25, -2.}, {
         1, 7.300000000000001, -2.}, {1, 7.3500000000000005`, -2.}, {
         1, 7.4, -2.}, {1, 7.45, -2.}, {1, 7.5, -2.}, {
         1, 7.550000000000001, -2.}, {1, 7.6000000000000005`, -2.}, {
         1, 7.65, -2.}, {1, 7.7, -2.}, {1, 7.75, -2.}, {
         1, 7.800000000000001, -2.}, {1, 7.8500000000000005`, -2.}, {
         1, 7.9, -2.}, {1, 7.95, -2.}, {1, 8., -2.}, {1, 8.05, -2.}, {
         1, 8.1, -2.}, {1, 8.15, -2.}, {1, 8.200000000000001, -2.}, {
         1, 8.25, -2.}, {1, 8.3, -2.}, {1, 8.35, -2.}, {1, 8.4, -2.}, {
         1, 8.450000000000001, -2.}, {1, 8.5, -2.}, {1, 8.55, -2.}, {
         1, 8.6, -2.}, {1, 8.65, -2.}, {1, 8.700000000000001, -2.}, {
         1, 8.75, -2.}, {1, 8.8, -2.}, {1, 8.85, -2.}, {1, 8.9, -2.}, {
         1, 8.950000000000001, -2.}, {1, 9., -2.}, {1, 9.05, -2.}, {
         1, 9.1, -2.}, {1, 9.15, -2.}, {1, 9.200000000000001, -2.}, {
         1, 9.25, -2.}, {1, 9.3, -2.}, {1, 9.35, -2.}, {1, 9.4, -2.}, {
         1, 9.450000000000001, -2.}, {1, 9.5, -2.}, {1, 9.55, -2.}, {
         1, 9.600000000000001, -2.}, {1, 9.65, -2.}, {
         1, 9.700000000000001, -2.}, {1, 9.75, -2.}, {1, 9.8, -2.}, {
         1, 9.850000000000001, -2.}, {1, 9.9, -2.}, {
         1, 9.950000000000001, -2.}, {1, 10., -2.}, {1, 10.05, -2.}, {
         1, 10.100000000000001`, -2.}, {1, 10.15, -2.}, {
         1, 10.200000000000001`, -2.}, {1, 10.25, -2.}, {1, 10.3, -2.}, {
         1, 10.350000000000001`, -2.}, {1, 10.4, -2.}, {
         1, 10.450000000000001`, -2.}, {1, 10.5, -2.}, {1, 10.55, -2.}, {
         1, 10.600000000000001`, -2.}, {1, 10.65, -2.}, {
         1, 10.700000000000001`, -2.}, {1, 10.75, -2.}, {1, 10.8, -2.}, {
         1, 10.850000000000001`, -2.}, {1, 10.9, -2.}, {
         1, 10.950000000000001`, -2.}, {1, 11., -2.}, {1, 11.05, -2.}, {
         1, 11.100000000000001`, -2.}, {1, 11.15, -2.}, {
         1, 11.200000000000001`, -2.}, {1, 11.25, -2.}, {1, 11.3, -2.}, {
         1, 11.350000000000001`, -2.}, {1, 11.4, -2.}, {
         1, 11.450000000000001`, -2.}, {1, 11.5, -2.}, {1, 11.55, -2.}, {
         1, 11.600000000000001`, -2.}, {1, 11.65, -2.}, {
         1, 11.700000000000001`, -2.}, {1, 11.75, -2.}, {1, 11.8, -2.}, {
         1, 11.850000000000001`, -2.}, {1, 11.9, -2.}, {
         1, 11.950000000000001`, -2.}, {1, 12., -2.}, {1, 12.05, -2.}, {
         1, 12.100000000000001`, -2.}, {1, 12.15, -2.}, {
         1, 12.200000000000001`, -2.}, {1, 12.25, -2.}, {1, 12.3, -2.}, {
         1, 12.350000000000001`, -2.}, {1, 12.4, -2.}, {
         1, 12.450000000000001`, -2.}, {1, 12.5, -2.}, {1, 12.55, -2.}, {
         1, 12.600000000000001`, -2.}, {1, 12.65, -2.}, {
         1, 12.700000000000001`, -2.}, {1, 12.75, -2.}, {1, 12.8, -2.}, {
         1, 12.850000000000001`, -2.}, {1, 12.9, -2.}, {
         1, 12.950000000000001`, -2.}, {1, 13., -2.}, {1, 13.05, -2.}, {
         1, 13.100000000000001`, -2.}, {1, 13.15, -2.}, {
         1, 13.200000000000001`, -2.}, {1, 13.25, -2.}, {1, 13.3, -2.}, {
         1, 13.350000000000001`, -2.}, {1, 13.4, -2.}, {
         1, 13.450000000000001`, -2.}, {1, 13.5, -2.}, {1, 13.55, -2.}, {
         1, 13.600000000000001`, -2.}, {1, 13.65, -2.}, {
         1, 13.700000000000001`, -2.}, {1, 13.75, -2.}, {1, 13.8, -2.}, {
         1, 13.850000000000001`, -2.}, {1, 13.9, -2.}, {
         1, 13.950000000000001`, -2.}, {1, 14., -2.}, {1, 14.05, -2.}, {
         1, 14.100000000000001`, -2.}, {1, 14.15, -2.}, {
         1, 14.200000000000001`, -2.}, {1, 14.25, -2.}, {1, 14.3, -2.}, {
         1, 14.350000000000001`, -2.}, {1, 14.4, -2.}, {
         1, 14.450000000000001`, -2.}, {1, 14.5, -2.}, {1, 14.55, -2.}, {
         1, 14.600000000000001`, -2.}, {1, 14.65, -2.}, {
         1, 14.700000000000001`, -2.}, {1, 14.75, -2.}, {1, 14.8, -2.}, {
         1, 14.850000000000001`, -2.}, {1, 14.9, -2.}, {
         1, 14.950000000000001`, -2.}, {1, 15., -2.}, {1, 15.05, -2.}, {
         1, 15.100000000000001`, -2.}, {1, 15.15, -2.}, {
         1, 15.200000000000001`, -2.}, {1, 15.25, -2.}, {1, 15.3, -2.}, {
         1, 15.350000000000001`, -2.}, {1, 15.4, -2.}, {
         1, 15.450000000000001`, -2.}, {1, 15.5, -2.}, {1, 15.55, -2.}, {
         1, 15.600000000000001`, -2.}, {1, 15.65, -2.}, {
         1, 15.700000000000001`, -2.}, {1, 15.75, -2.}, {1, 15.8, -2.}, {
         1, 15.850000000000001`, -2.}, {1, 15.9, -2.}, {
         1, 15.950000000000001`, -2.}, {1, 16., -2.}, {1, 16.05, -2.}, {
         1, 16.1, -2.}, {1, 16.150000000000002`, -2.}, {1, 16.2, -2.}, {
         1, 16.25, -2.}, {1, 16.3, -2.}, {1, 16.35, -2.}, {
         1, 16.400000000000002`, -2.}, {1, 16.45, -2.}, {1, 16.5, -2.}, {
         1, 16.55, -2.}, {1, 16.6, -2.}, {1, 16.650000000000002`, -2.}, {
         1, 16.7, -2.}, {1, 16.75, -2.}, {1, 16.8, -2.}, {1, 16.85, -2.}, {
         1, 16.900000000000002`, -2.}, {1, 16.95, -2.}, {1, 17., -2.}, {
         1, 17.05, -2.}, {1, 17.1, -2.}, {1, 17.150000000000002`, -2.}, {
         1, 17.2, -2.}, {1, 17.25, -2.}, {1, 17.3, -2.}, {1, 17.35, -2.}, {
         1, 17.400000000000002`, -2.}, {1, 17.45, -2.}, {1, 17.5, -2.}, {
         1, 17.55, -2.}, {1, 17.6, -2.}, {1, 17.650000000000002`, -2.}, {
         1, 17.7, -2.}, {1, 17.75, -2.}, {1, 17.8, -2.}, {1, 17.85, -2.}, {
         1, 17.900000000000002`, -2.}, {1, 17.95, -2.}, {1, 18., -2.}, {
         1, 18.05, -2.}, {1, 18.1, -2.}, {1, 18.150000000000002`, -2.}, {
         1, 18.2, -2.}, {1, 18.25, -2.}, {1, 18.3, -2.}, {1, 18.35, -2.}, {
         1, 18.400000000000002`, -2.}, {1, 18.45, -2.}, {1, 18.5, -2.}, {
         1, 18.55, -2.}, {1, 18.6, -2.}, {1, 18.650000000000002`, -2.}, {
         1, 18.7, -2.}, {1, 18.75, -2.}, {1, 18.8, -2.}, {1, 18.85, -2.}, {
         1, 18.900000000000002`, -2.}, {1, 18.95, -2.}, {1, 19., -2.}, {
         1, 19.05, -2.}, {1, 19.1, -2.}, {1, 19.150000000000002`, -2.}, {
         1, 19.200000000000003`, -2.}, {1, 19.25, -2.}, {1, 19.3, -2.}, {
         1, 19.35, -2.}, {1, 19.400000000000002`, -2.}, {
         1, 19.450000000000003`, -2.}, {1, 19.5, -2.}, {1, 19.55, -2.}, {
         1, 19.6, -2.}, {1, 19.650000000000002`, -2.}, {
         1, 19.700000000000003`, -2.}, {1, 19.75, -2.}, {1, 19.8, -2.}, {
         1, 19.85, -2.}, {1, 19.900000000000002`, -2.}, {
         1, 19.950000000000003`, -2.}, {1, 20., -2.}, {1, 20.05, -2.}, {
         1, 20.1, -2.}, {1, 20.150000000000002`, -2.}, {
         1, 20.200000000000003`, -2.}, {1, 20.25, -2.}, {1, 20.3, -2.}, {
         1, 20.35, -2.}, {1, 20.400000000000002`, -2.}, {
         1, 20.450000000000003`, -2.}, {1, 20.5, -2.}, {1, 20.55, -2.}, {
         1, 20.6, -2.}, {1, 20.650000000000002`, -2.}, {
         1, 20.700000000000003`, -2.}, {1, 20.75, -2.}, {1, 20.8, -2.}, {
         1, 20.85, -2.}, {1, 20.900000000000002`, -2.}, {
         1, 20.950000000000003`, -2.}, {1, 21., -2.}, {1, 21.05, -2.}, {
         1, 21.1, -2.}, {1, 21.150000000000002`, -2.}, {
         1, 21.200000000000003`, -2.}, {1, 21.25, -2.}, {1, 21.3, -2.}, {
         1, 21.35, -2.}, {1, 21.400000000000002`, -2.}, {
         1, 21.450000000000003`, -2.}, {1, 21.5, -2.}, {1, 21.55, -2.}, {
         1, 21.6, -2.}, {1, 21.650000000000002`, -2.}, {
         1, 21.700000000000003`, -2.}, {1, 21.75, -2.}, {1, 21.8, -2.}, {
         1, 21.85, -2.}, {1, 21.900000000000002`, -2.}, {
         1, 21.950000000000003`, -2.}, {1, 22., -2.}, {1, 22.05, -2.}, {
         1, 22.1, -2.}, {1, 22.150000000000002`, -2.}, {
         1, 22.200000000000003`, -2.}, {1, 22.25, -2.}, {1, 22.3, -2.}, {
         1, 22.35, -2.}, {1, 22.400000000000002`, -2.}, {
         1, 22.450000000000003`, -2.}, {1, 22.5, -2.}, {1, 22.55, -2.}, {
         1, 22.6, -2.}, {1, 22.650000000000002`, -2.}, {
         1, 22.700000000000003`, -2.}, {1, 22.75, -2.}, {1, 22.8, -2.}, {
         1, 22.85, -2.}, {1, 22.900000000000002`, -2.}, {
         1, 22.950000000000003`, -2.}, {1, 23., -2.}, {1, 23.05, -2.}, {
         1, 23.1, -2.}, {1, 23.150000000000002`, -2.}, {
         1, 23.200000000000003`, -2.}, {1, 23.25, -2.}, {1, 23.3, -2.}, {
         1, 23.35, -2.}, {1, 23.400000000000002`, -2.}, {
         1, 23.450000000000003`, -2.}, {1, 23.5, -2.}, {1, 23.55, -2.}, {
         1, 23.6, -2.}, {1, 23.650000000000002`, -2.}, {
         1, 23.700000000000003`, -2.}, {1, 23.75, -2.}, {1, 23.8, -2.}, {
         1, 23.85, -2.}, {1, 23.900000000000002`, -2.}, {
         1, 23.950000000000003`, -2.}, {1, 24., -2.}, {1, 24.05, -2.}, {
         1, 24.1, -2.}, {1, 24.150000000000002`, -2.}, {
         1, 24.200000000000003`, -2.}, {1, 24.25, -2.}, {1, 24.3, -2.}, {
         1, 24.35, -2.}, {1, 24.400000000000002`, -2.}, {
         1, 24.450000000000003`, -2.}, {1, 24.5, -2.}, {1, 24.55, -2.}, {
         1, 24.6, -2.}, {1, 24.650000000000002`, -2.}, {
         1, 24.700000000000003`, -2.}, {1, 24.75, -2.}, {1, 24.8, -2.}, {
         1, 24.85, -2.}, {1, 24.900000000000002`, -2.}, {
         1, 24.950000000000003`, -2.}}, 
       Attributes[$CellContext`timeiv$64517] = {
        Temporary}, $CellContext`timeiv$64517 = 20, 
       Attributes[$CellContext`buildingresp3D$64517] = {
        Temporary}, $CellContext`buildingresp3D$64517 = CompressedData["
1:eJx12nk4lfn/x3Gc4yBbCpFJlJRlpCRrOa1GSEmFFqXSpiSjhRatmlYKU741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        "], 
       Attributes[$CellContext`spheresize$64517] = {
        Temporary}, $CellContext`spheresize$64517 = 0.5, 
       Attributes[$CellContext`inptrace1D$64517] = {
        Temporary}, $CellContext`inptrace1D$64517 = CompressedData["
1:eJxTTMoPSmJkYGD4AiJIBoyjYIgDALz5BF8=
        "], 
       Attributes[$CellContext`posdamper$64517] = {
        Temporary}, $CellContext`posdamper$64517 = -3, 
       Attributes[$CellContext`swayingCylinder$64517] = {
        Temporary}, $CellContext`swayingCylinder$64517[
         Pattern[$CellContext`t$, 
          Blank[]]] := Partition[
         Table[
          
          With[{$CellContext`pt$ = {
             0., 0., Floor[($CellContext`z$64517 - 1)/
                2] + $CellContext`d$64517 (-1)^$CellContext`z$64517}}, {(
              1/$CellContext`nz$64517) $CellContext`scale$64517 
             Part[$CellContext`pt$, 3] 
             Exp[Part[$CellContext`pt$, 3]/$CellContext`nz$64517] (
              Part[$CellContext`responseOfSDOFoscillator$64517, \
$CellContext`t$] - Part[$CellContext`inptrace1D$64517, $CellContext`t$]) + 
            Part[$CellContext`inptrace1D$64517, $CellContext`t$], 
            Part[$CellContext`pt$, 2], 
            Part[$CellContext`pt$, 3]}], {$CellContext`z$64517, 
           2 $CellContext`height$64517}], 2], 
       Attributes[$CellContext`t$] = {Temporary}, 
       Attributes[$CellContext`pt$] = {Temporary}, 
       Attributes[$CellContext`z$64517] = {Temporary}, 
       Attributes[$CellContext`d$64517] = {Temporary}, $CellContext`d$64517 = 
       0.5, Attributes[$CellContext`nz$64517] = {
        Temporary}, $CellContext`nz$64517 = 6, 
       Attributes[$CellContext`scale$64517] = {
        Temporary}, $CellContext`scale$64517 = 0.4361996229216517, 
       Attributes[$CellContext`responseOfSDOFoscillator$64517] = {
        Temporary}, $CellContext`responseOfSDOFoscillator$64517 = \
CompressedData["
1:eJztlfk/Vd0Xx8+911iGFEW+CUkZHknJ3NrNSSiJiyS30iSSNKAShSZReMrT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        "], 
       Attributes[$CellContext`height$64517] = {
        Temporary}, $CellContext`height$64517 = 6, $CellContext`i$$ = 
       1, $CellContext`iSize = 350}; Typeset`initDone$$ = True),
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{
  3.577174452060298*^9, 3.5897094539666843`*^9, 3.944744146062351*^9, 
   3.944746550349701*^9, 3.947143650917859*^9, 3.947232825719569*^9, 
   3.947232945648159*^9, 3.947659206578864*^9, 3.947659982490571*^9, 
   3.947660049298995*^9, 3.947660082882288*^9, 3.947660829353046*^9, {
   3.951884313026202*^9, 3.951884336501727*^9}, 3.9557719112525463`*^9, 
   3.955772228046484*^9, 3.9557724205546217`*^9},
 CellLabel->"Out[450]=",
 $CellContext`InitializationGroup -> 
 True,ExpressionUUID->"e8cd9990-db55-4cf3-85ab-4d664205b9cb"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["c4s1Figure2", "Subsection",
 CellChangeTimes->{{3.5723420028690567`*^9, 3.572342011627058*^9}, {
   3.947391571097383*^9, 3.947391617058372*^9}, 3.9473923450883703`*^9, 
   3.947393236393119*^9, 3.947575060658597*^9, 3.947654618026465*^9, 
   3.9476590855619097`*^9, 3.947659216858295*^9},
 $CellContext`InitializationGroup -> 
 True,ExpressionUUID->"c5d7e34f-c49a-4b13-9a60-697631c6b2ee"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"c4s1Figure2", "=", 
  RowBox[{"ListPlot", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"inptrace2D", ",", "resp"}], "}"}], ",", 
    RowBox[{"Joined", "\[Rule]", " ", "True"}], ",", 
    RowBox[{"Joined", "\[Rule]", " ", "True"}], ",", 
    RowBox[{"Frame", "\[Rule]", " ", "True"}], ",", 
    RowBox[{"LabelStyle", "\[Rule]", " ", "labFontSize"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"PlotStyle", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", "Black", "}"}], ",", 
       RowBox[{"{", "Red", "}"}]}], "}"}]}], ",", 
    RowBox[{"FrameLabel", "\[Rule]", " ", 
     RowBox[{"{", 
      RowBox[{"\"\<Time (sec)\>\"", ",", "\"\<\>\"", ",", 
       RowBox[{"\"\<\!\(\*SubscriptBox[\(f\), \(osc\)]\)= \>\"", "<>", 
        RowBox[{"ToString", "[", "fosc", "]"}], "<>", "\"\< (Hz)\>\""}], 
       ",", "\"\<\>\""}], "}"}]}], ",", 
    RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
    RowBox[{"ImageSize", "\[Rule]", " ", "iSize"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.552033911361219*^9, 3.5520339560443697`*^9}},
 CellLabel->"In[451]:=",
 CellID->1868399858,
 $CellContext`InitializationGroup -> 
 True,ExpressionUUID->"c5293d1d-7dc4-41bd-9a76-216b74138a86"],

Cell[BoxData[
 GraphicsBox[{{}, 
   InterpretationBox[{
     TagBox[{{}, {}, 
       TagBox[
        {GrayLevel[0], PointSize[0.004583333333333334], AbsoluteThickness[2], 
         LineBox[CompressedData["
1:eJxd1stqZEUcx/GaUTOZTCaTe3Jy71xO7tfKbZd+gFq5660wx6WLfoHzAP0C
5QM0uK6VuwZXQgmCIDS4UJRCUSTaUUcdL8QjOfy+tTn86KpP/fhzOHTjnffe
fvnYGHP3yJj7J9f7/n59cKP5w4d8bu/XR/j94xtVPsX+zx7yu8X9+hzn+w/5
k3i/voD3JfZ/Bf9rnP8G9yV438L7Dt738H6A9yO8W+y/hf8Tzv+M+wbw7uDd
wfsF3q/wfoP3Ct4reL/D+wPen/Bew3sN7y94f8P7B55p6v46V36d/ztuHz3k
6r46V+sxvDpXXp2rPm/Aq3O13vw/395UXp0rr86V99ZDrrw6V88heEPwhuA9
gfcE3jC8YXjD8J7CewpvBN4IvBF4z+A9gzcKbxTeKLzn8J7DG4M3Bm8M3gt4
L+CNP+Tq/apz5Y/jfJ2r+8bhTcCbgDcBbwLeBLxJeJPwJuFNwpuEN4X5TMGb
gjcFbwreNLxpeNPwpuFNw5uBNwNvBt4MvBl4s/Bm4c3Cm4U3C28O3hy8OXhz
8ObgzcObhzcPbx7ePLwMXgYvg5fBy+AtwFuAtwBvAd4CvEV4i/AW4S3CW4S3
BG8J3hK8JXhL8JbhLcNbhrcMbxneCrwVeCvwVuCtwFuFtwpvFd4qvFV4a7o/
q3P1vVnT867O1X1r6pXwPLwAL8JL8EwD/Rrq2YZ6rqFe0VCvhOfhBXgRXoJn
1tFvXT27rp6rc9WvzlU/eB5egBfhJXhmA/3qXL0/G+q5DfWKDfVKeB5egBfh
JXhmE/021bOb6rlN9YpN9Up4Hl6AF+EleGYL/bbUs1vquS31ii31SngeXoAX
4SV4Jke/XD2bq+dy9YpcvRKehxfgRXgJntlGv2317LZ6blu9Ylu9Ep6HF+BF
eAme2UG/HfXsjnpuR71iR70SnocX4EV4CZ7ZRb9d9eyuem5XvWJXvRKehxfg
RXgJntlDvz317J56bk+9Yk+9Ep6HF+BFeAme2Ue/ffXsvnpuX71iX70SnocX
4EV4CZ45QL8D9eyBeu5AveJAvRKehxfgRXgJnjlEv0P17KF67lC94lC9Ep6H
F+BFeAmeOUK/I/XskXruSL3iSL0SnocX4EV4CZ45Rr9j9eyxeu5YveJYvRKe
hxfgRXgJnjnR/aN1rvqe6Pm8ztX/mxP1mvAcvBa8Al4bXgmvA8/D68IL8Hrw
Irw+vARvAM+cYn6n6mWn6uWn6tlT9ZrwHLwWvAJeG14JrwPPw+vCC/B68CK8
PrwEbwDPnGF+Z+plZ+rlZ+rZM/Wa8By8FrwCXhteCa8Dz8PrwgvwevAivD68
BG8Az1jMz6qXWfXyOlffH6teE56D14JXwGvDK+F14Hl4XXgBXg9ehNeHl+AN
4JlzzO9cvexcvfxcPXuuXhOeg9eCV8BrwyvhdeB5eF14AV4PXoTXh5fgDeCZ
C8zvQr3sQr38Qj17oV4TnoPXglfAa8Mr4XXgeXhdeAFeD16E14eX4A3gmUvM
71K97FK9/FI9e6leE56D14JXwGvDK+F14Hl4XXgBXg9ehNeHl+AN4JkrzO9K
vexKvfxKPXulXhOeg9eCV8BrwyvhdeB5eF14AV4PXoTXh5fgDeCZa8zvWr3s
Wr38Wj17rV4TnoPXglfAa8Mr4XXgeXhdeAFeD16E14eX4A3q/C/1PL+9
          "]]},
        Annotation[#, "Charting`Private`Tag#1"]& ], 
       TagBox[
        {RGBColor[1, 0, 0], PointSize[0.004583333333333334], 
         AbsoluteThickness[2], LineBox[CompressedData["
1:eJxdmHk8Vfn/xyVSIrIvybVdu7u7d5K8iMokLVOhNK0k2qloG820SooWQ4tK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          "]]},
        Annotation[#, "Charting`Private`Tag#2"]& ]},
      {"WolframDynamicHighlight", <|
       "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>}], 
     StyleBox[
      DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
        Slot["HighlightElements"], 
        Slot["LayoutOptions"], 
        Slot["Meta"], 
        Charting`HighlightActionFunction["DynamicHighlight", {{{}, {}, 
           Annotation[{
             Hue[0.67, 0.6, 0.6], 
             Directive[
              PointSize[0.004583333333333334], 
              AbsoluteThickness[2], 
              GrayLevel[0]], 
             Line[CompressedData["
1:eJxd1stqZEUcx/GaUTOZTCaTe3Jy71xO7tfKbZd+gFq5660wx6WLfoHzAP0C
5QM0uK6VuwZXQgmCIDS4UJRCUSTaUUcdL8QjOfy+tTn86KpP/fhzOHTjnffe
fvnYGHP3yJj7J9f7/n59cKP5w4d8bu/XR/j94xtVPsX+zx7yu8X9+hzn+w/5
k3i/voD3JfZ/Bf9rnP8G9yV438L7Dt738H6A9yO8W+y/hf8Tzv+M+wbw7uDd
wfsF3q/wfoP3Ct4reL/D+wPen/Bew3sN7y94f8P7B55p6v46V36d/ztuHz3k
6r46V+sxvDpXXp2rPm/Aq3O13vw/395UXp0rr86V99ZDrrw6V88heEPwhuA9
gfcE3jC8YXjD8J7CewpvBN4IvBF4z+A9gzcKbxTeKLzn8J7DG4M3Bm8M3gt4
L+CNP+Tq/apz5Y/jfJ2r+8bhTcCbgDcBbwLeBLxJeJPwJuFNwpuEN4X5TMGb
gjcFbwreNLxpeNPwpuFNw5uBNwNvBt4MvBl4s/Bm4c3Cm4U3C28O3hy8OXhz
8ObgzcObhzcPbx7ePLwMXgYvg5fBy+AtwFuAtwBvAd4CvEV4i/AW4S3CW4S3
BG8J3hK8JXhL8JbhLcNbhrcMbxneCrwVeCvwVuCtwFuFtwpvFd4qvFV4a7o/
q3P1vVnT867O1X1r6pXwPLwAL8JL8EwD/Rrq2YZ6rqFe0VCvhOfhBXgRXoJn
1tFvXT27rp6rc9WvzlU/eB5egBfhJXhmA/3qXL0/G+q5DfWKDfVKeB5egBfh
JXhmE/021bOb6rlN9YpN9Up4Hl6AF+EleGYL/bbUs1vquS31ii31SngeXoAX
4SV4Jke/XD2bq+dy9YpcvRKehxfgRXgJntlGv2317LZ6blu9Ylu9Ep6HF+BF
eAme2UG/HfXsjnpuR71iR70SnocX4EV4CZ7ZRb9d9eyuem5XvWJXvRKehxfg
RXgJntlDvz317J56bk+9Yk+9Ep6HF+BFeAme2Ue/ffXsvnpuX71iX70SnocX
4EV4CZ45QL8D9eyBeu5AveJAvRKehxfgRXgJnjlEv0P17KF67lC94lC9Ep6H
F+BFeAmeOUK/I/XskXruSL3iSL0SnocX4EV4CZ45Rr9j9eyxeu5YveJYvRKe
hxfgRXgJnjnR/aN1rvqe6Pm8ztX/mxP1mvAcvBa8Al4bXgmvA8/D68IL8Hrw
Irw+vARvAM+cYn6n6mWn6uWn6tlT9ZrwHLwWvAJeG14JrwPPw+vCC/B68CK8
PrwEbwDPnGF+Z+plZ+rlZ+rZM/Wa8By8FrwCXhteCa8Dz8PrwgvwevAivD68
BG8Az1jMz6qXWfXyOlffH6teE56D14JXwGvDK+F14Hl4XXgBXg9ehNeHl+AN
4JlzzO9cvexcvfxcPXuuXhOeg9eCV8BrwyvhdeB5eF14AV4PXoTXh5fgDeCZ
C8zvQr3sQr38Qj17oV4TnoPXglfAa8Mr4XXgeXhdeAFeD16E14eX4A3gmUvM
71K97FK9/FI9e6leE56D14JXwGvDK+F14Hl4XXgBXg9ehNeHl+AN4JkrzO9K
vexKvfxKPXulXhOeg9eCV8BrwyvhdeB5eF14AV4PXoTXh5fgDeCZa8zvWr3s
Wr38Wj17rV4TnoPXglfAa8Mr4XXgeXhdeAFeD16E14eX4A3q/C/1PL+9
              "]]}, "Charting`Private`Tag#1"], 
           Annotation[{
             Hue[0.9060679774997897, 0.6, 0.6], 
             Directive[
              PointSize[0.004583333333333334], 
              AbsoluteThickness[2], 
              RGBColor[1, 0, 0]], 
             Line[CompressedData["
1:eJxdmHk8Vfn/xyVSIrIvybVdu7u7d5K8iMokLVOhNK0k2qloG820SooWQ4tK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              "]]}, "Charting`Private`Tag#2"]}}, <|
         "HighlightElements" -> <|
           "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
          "LayoutOptions" -> <|
           "PanelPlotLayout" -> <||>, 
            "PlotRange" -> {{0, 24.950000000000003`}, {0, 1.857742865486998}},
             "Frame" -> {{True, True}, {True, True}}, "AxesOrigin" -> {0, 0}, 
            "ImageSize" -> {350, 350/GoldenRatio}, "Axes" -> {True, True}, 
            "LabelStyle" -> {FontSize -> 14}, "AspectRatio" -> 
            GoldenRatio^(-1), "DefaultStyle" -> {
              Directive[
               PointSize[0.004583333333333334], 
               AbsoluteThickness[2], 
               RGBColor[1, 0, 0]], 
              Directive[
               PointSize[0.004583333333333334], 
               AbsoluteThickness[2], 
               GrayLevel[0]]}, 
            "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
                (Identity[#]& )[
                 Part[#, 1]], 
                (Identity[#]& )[
                 Part[#, 2]]}& ), 
              "ScalingFunctions" -> {{Identity, Identity}, {
                Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
            False|>, 
          "Meta" -> <|
           "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
            ListPlot, "GroupHighlight" -> False|>|>]]& )[<|
        "HighlightElements" -> <|
          "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
         "LayoutOptions" -> <|
          "PanelPlotLayout" -> <||>, 
           "PlotRange" -> {{0, 24.950000000000003`}, {0, 1.857742865486998}}, 
           "Frame" -> {{True, True}, {True, True}}, "AxesOrigin" -> {0, 0}, 
           "ImageSize" -> {350, 350/GoldenRatio}, "Axes" -> {True, True}, 
           "LabelStyle" -> {FontSize -> 14}, "AspectRatio" -> 
           GoldenRatio^(-1), "DefaultStyle" -> {
             Directive[
              PointSize[0.004583333333333334], 
              AbsoluteThickness[2], 
              RGBColor[1, 0, 0]], 
             Directive[
              PointSize[0.004583333333333334], 
              AbsoluteThickness[2], 
              GrayLevel[0]]}, 
           "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
               (Identity[#]& )[
                Part[#, 1]], 
               (Identity[#]& )[
                Part[#, 2]]}& ), 
             "ScalingFunctions" -> {{Identity, Identity}, {
               Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
           False|>, 
         "Meta" -> <|
          "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
           ListPlot, "GroupHighlight" -> False|>|>],
       ImageSizeCache->{{4.503599627370496*^15, -4.503599627370496*^15}, {
        4.503599627370496*^15, -4.503599627370496*^15}}],
      Selectable->False]},
    Annotation[{{{}, {}, 
       Annotation[{
         Hue[0.67, 0.6, 0.6], 
         Directive[
          PointSize[0.004583333333333334], 
          AbsoluteThickness[2], 
          GrayLevel[0]], 
         Line[CompressedData["
1:eJxd1stqZEUcx/GaUTOZTCaTe3Jy71xO7tfKbZd+gFq5660wx6WLfoHzAP0C
5QM0uK6VuwZXQgmCIDS4UJRCUSTaUUcdL8QjOfy+tTn86KpP/fhzOHTjnffe
fvnYGHP3yJj7J9f7/n59cKP5w4d8bu/XR/j94xtVPsX+zx7yu8X9+hzn+w/5
k3i/voD3JfZ/Bf9rnP8G9yV438L7Dt738H6A9yO8W+y/hf8Tzv+M+wbw7uDd
wfsF3q/wfoP3Ct4reL/D+wPen/Bew3sN7y94f8P7B55p6v46V36d/ztuHz3k
6r46V+sxvDpXXp2rPm/Aq3O13vw/395UXp0rr86V99ZDrrw6V88heEPwhuA9
gfcE3jC8YXjD8J7CewpvBN4IvBF4z+A9gzcKbxTeKLzn8J7DG4M3Bm8M3gt4
L+CNP+Tq/apz5Y/jfJ2r+8bhTcCbgDcBbwLeBLxJeJPwJuFNwpuEN4X5TMGb
gjcFbwreNLxpeNPwpuFNw5uBNwNvBt4MvBl4s/Bm4c3Cm4U3C28O3hy8OXhz
8ObgzcObhzcPbx7ePLwMXgYvg5fBy+AtwFuAtwBvAd4CvEV4i/AW4S3CW4S3
BG8J3hK8JXhL8JbhLcNbhrcMbxneCrwVeCvwVuCtwFuFtwpvFd4qvFV4a7o/
q3P1vVnT867O1X1r6pXwPLwAL8JL8EwD/Rrq2YZ6rqFe0VCvhOfhBXgRXoJn
1tFvXT27rp6rc9WvzlU/eB5egBfhJXhmA/3qXL0/G+q5DfWKDfVKeB5egBfh
JXhmE/021bOb6rlN9YpN9Up4Hl6AF+EleGYL/bbUs1vquS31ii31SngeXoAX
4SV4Jke/XD2bq+dy9YpcvRKehxfgRXgJntlGv2317LZ6blu9Ylu9Ep6HF+BF
eAme2UG/HfXsjnpuR71iR70SnocX4EV4CZ7ZRb9d9eyuem5XvWJXvRKehxfg
RXgJntlDvz317J56bk+9Yk+9Ep6HF+BFeAme2Ue/ffXsvnpuX71iX70SnocX
4EV4CZ45QL8D9eyBeu5AveJAvRKehxfgRXgJnjlEv0P17KF67lC94lC9Ep6H
F+BFeAmeOUK/I/XskXruSL3iSL0SnocX4EV4CZ45Rr9j9eyxeu5YveJYvRKe
hxfgRXgJnjnR/aN1rvqe6Pm8ztX/mxP1mvAcvBa8Al4bXgmvA8/D68IL8Hrw
Irw+vARvAM+cYn6n6mWn6uWn6tlT9ZrwHLwWvAJeG14JrwPPw+vCC/B68CK8
PrwEbwDPnGF+Z+plZ+rlZ+rZM/Wa8By8FrwCXhteCa8Dz8PrwgvwevAivD68
BG8Az1jMz6qXWfXyOlffH6teE56D14JXwGvDK+F14Hl4XXgBXg9ehNeHl+AN
4JlzzO9cvexcvfxcPXuuXhOeg9eCV8BrwyvhdeB5eF14AV4PXoTXh5fgDeCZ
C8zvQr3sQr38Qj17oV4TnoPXglfAa8Mr4XXgeXhdeAFeD16E14eX4A3gmUvM
71K97FK9/FI9e6leE56D14JXwGvDK+F14Hl4XXgBXg9ehNeHl+AN4JkrzO9K
vexKvfxKPXulXhOeg9eCV8BrwyvhdeB5eF14AV4PXoTXh5fgDeCZa8zvWr3s
Wr38Wj17rV4TnoPXglfAa8Mr4XXgeXhdeAFeD16E14eX4A3q/C/1PL+9
          "]]}, "Charting`Private`Tag#1"], 
       Annotation[{
         Hue[0.9060679774997897, 0.6, 0.6], 
         Directive[
          PointSize[0.004583333333333334], 
          AbsoluteThickness[2], 
          RGBColor[1, 0, 0]], 
         Line[CompressedData["
1:eJxdmHk8Vfn/xyVSIrIvybVdu7u7d5K8iMokLVOhNK0k2qloG820SooWQ4tK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          "]]}, "Charting`Private`Tag#2"]}}, <|
     "HighlightElements" -> <|
       "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
      "LayoutOptions" -> <|
       "PanelPlotLayout" -> <||>, 
        "PlotRange" -> {{0, 24.950000000000003`}, {0, 1.857742865486998}}, 
        "Frame" -> {{True, True}, {True, True}}, "AxesOrigin" -> {0, 0}, 
        "ImageSize" -> {350, 350/GoldenRatio}, "Axes" -> {True, True}, 
        "LabelStyle" -> {FontSize -> 14}, "AspectRatio" -> GoldenRatio^(-1), 
        "DefaultStyle" -> {
          Directive[
           PointSize[0.004583333333333334], 
           AbsoluteThickness[2], 
           RGBColor[1, 0, 0]], 
          Directive[
           PointSize[0.004583333333333334], 
           AbsoluteThickness[2], 
           GrayLevel[0]]}, 
        "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& ), 
          "ScalingFunctions" -> {{Identity, Identity}, {
            Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>, 
      "Meta" -> <|
       "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
        ListPlot, "GroupHighlight" -> False|>|>, 
     "DynamicHighlight"]], {{}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{
     FormBox[
      TagBox["\"\"", HoldForm], TraditionalForm], None}, {
     FormBox[
      TagBox["\"Time (sec)\"", HoldForm], TraditionalForm], None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImageSize->350,
  LabelStyle->14,
  Method->{
   "AxisPadding" -> Scaled[0.02], "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "DefaultPlotStyle" -> {
      Directive[
       RGBColor[0.24, 0.6, 0.8], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.95, 0.627, 0.1425], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.455, 0.7, 0.21], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.922526, 0.385626, 0.209179], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.578, 0.51, 0.85], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.772079, 0.431554, 0.102387], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.4, 0.64, 1.], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[1., 0.75, 0.], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.8, 0.4, 0.76], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.637, 0.65, 0.], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.915, 0.3325, 0.2125], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
       AbsoluteThickness[2]]}, "DomainPadding" -> Scaled[0.02], 
    "PointSizeFunction" -> "SmallPointSize", "RangePadding" -> Scaled[0.05], 
    "OptimizePlotMarkers" -> True, "IncludeHighlighting" -> "CurrentSet", 
    "HighlightStyle" -> Automatic, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 24.950000000000003`}, {0, 1.857742865486998}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.552033958902014*^9, {3.552041667748144*^9, 3.552041682237453*^9}, {
   3.552044159550449*^9, 3.5520441738467417`*^9}, {3.552045141140141*^9, 
   3.552045156332535*^9}, {3.564115860912567*^9, 3.564115874338284*^9}, 
   3.577174554429834*^9, 3.589709454439146*^9, 3.9447465607066927`*^9, 
   3.9471436510597878`*^9, 3.947232825821266*^9, 3.947232950416286*^9, 
   3.94765927956453*^9, 3.947660089745369*^9, 3.951884458851076*^9, 
   3.955771911390029*^9, 3.955772228470352*^9, 3.955772420618778*^9},
 CellLabel->"Out[451]=",
 $CellContext`InitializationGroup -> 
 True,ExpressionUUID->"c630f12f-488f-4333-abdc-1f7cbf34aa29"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["c4s1Figure3", "Subsection",
 CellChangeTimes->{{3.5723420028690567`*^9, 3.572342011627058*^9}, {
   3.947391571097383*^9, 3.947391617058372*^9}, 3.9473923450883703`*^9, 
   3.947393236393119*^9, 3.947575060658597*^9, 3.947654618026465*^9, 
   3.9476590855619097`*^9, 3.947659285767861*^9},
 $CellContext`InitializationGroup -> 
 True,ExpressionUUID->"23df05c9-3a10-47b4-999f-6ce26841708e"],

Cell["Data trace:  El Centro record", "MathCaption",
 CellChangeTimes->{{3.577175759701857*^9, 3.577175760444902*^9}, {
  3.5771758694604263`*^9, 3.577175875642249*^9}, {3.5771771806409683`*^9, 
  3.577177182641569*^9}, {3.951886059885148*^9, 3.951886080778648*^9}},
 CellID->2048694520,
 $CellContext`InitializationGroup -> 
 True,ExpressionUUID->"761c77f7-d1ef-4f8d-a610-21bff0b87bb9"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", 
   RowBox[{"dtsamp", ",", "d1", ",", "d2", ",", "acctrace2D"}], "]"}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"dtsamp", ",", "d1", ",", "d2", ",", "acctrace2D"}], "}"}], " ", "=",
    " ", 
   RowBox[{"Uncompress", "[", 
    InterpretationBox[
     DynamicModuleBox[{Typeset`open = False}, 
      TemplateBox[{"String", 
        StyleBox[
        "\"El Centro record\"", "IconizedCustomName", StripOnInput -> False], 
        
        GridBox[{{
           RowBox[{
             TagBox["\"Head: \"", "IconizedLabel"], "\[InvisibleSpace]", 
             TagBox["String", "IconizedItem"]}]}, {
           RowBox[{
             TagBox["\"String length: \"", "IconizedLabel"], 
             "\[InvisibleSpace]", 
             TagBox["63530", "IconizedItem"]}]}, {
           RowBox[{
             TagBox["\"Byte count: \"", "IconizedLabel"], "\[InvisibleSpace]", 
             TagBox["65536", "IconizedItem"]}]}}, 
         GridBoxAlignment -> {"Columns" -> {{Left}}}, DefaultBaseStyle -> 
         "Column", 
         GridBoxItemSize -> {
          "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
        Dynamic[Typeset`open]},
       "IconizedObject"]],
     "1:eJx0nXlcjV309isSkSRzmTKnVIo0OZEMKTKTIRWSEIcyhAYypyhKyEwZK6nIkEgSKZWSTK\
lMTRok9Phdp/W+v8/7tu7jj+ef79M597nvfe1rrbXX3ndfR7fpy1rKyMisk/\
zH2mXderFnp2sTPm7eIRL36132R+lA6ySXfKBlp5T/n/9pmdz/9ycy/+ef2KbPRbWITlH3m/H//\
cgU745TMydcE+bBIvEdq5yqfrbuomY8oZff92kJ4SLxhHC3rQbiG805/\
f05kXiDVdrljzbRzXnYUcm/SJE4zLWFWd04xunzr4nEZgmn3t95FdWcl02T/B/RIvGVbo/\
8MscwTt8fKxLfPhI8wmb79eZcMe/sGjPFeJE4rkDpbL/P14Sv75ZI/\
Dps0qqWLxgfsiAguW7wHZF4aUZYrHt/9vl0/fdE4izVpU799zJ+Dt+\
edzZJJN78Jetl5GXG6fc9EImPqqSma/sxrt/076FIbK3TIav3ZMbp9z8SiY/\
4dbVK59f3sG4wfkGKSKw+yKabbWcp9ydVJC5va3apQonx6U0/\
8IlInHB3k4XpPyn3L00kHm7jOrRfEeMfN0su8KlIXGyv8akmQcr9fSYS133Nzni5n/G1ktu35rlI/\
DdffXH+Ssbp/meIxHPLd+2uc2ac1JEpEtdM929038Y4PR/w6+GLzk48w/jEph+\
QJRJ3MZqpVfmMcXp+4Omlg5Ypy7P7J/l1CwJeisSvSnqFqI2R8nyzReILaQ/9KhYz3vR48sCVykI+\
vp0j5fnniMRrlye4bhcx3ltye3rlisSO3z6tOagvZXyAb/bSiEgwZNx5meTfK5E4xLbzxyD++TR+\
8kTi6lmqbR4ZMS65uk7XwFXWHJOd31HK+MoXieVrF9jI8PHxU3J5deDFnzTlrYZLGX+\
vRWLT4nZvgu9fbc5HN11ggUhsmdQ6vnUG4zQ+wXVVbda0CmSf33T7/N6IxM8Nl/jl3WHXT+\
O3UCT2XbZn2PkNbH56/kzyD7zf/YhP4+TY/Efj+\
61IvLrA8NeW9Yx3brqB70TiE4dej5u3Q8r8CZ5x2jG8TQ77/qbLW/BeJPYKHFBp+\
k2KPj6IxHcz9yX6Xr4s/HzANSrlpl0KiRDWD3ivQv3d6s/PCz8/8HtG5Z7n088K6+\
sjxmfQnJwOOueEny/4y5LNtipvLwrrD1xtn2W2houU518kEmuX7NAwv83uD+kTPP/Spa09zzFOlwd+\
Je5VlFVPdv9Iv59wfWefLxl3kN0/Gj/gHRdf1dB9yTjJB3y56xyf9jelzI/FIvGY92tLJsxhz5/\
0D55no+qzpCfzZxp/4B9zsyeErIkVnh9KoL9/saPip9wUHp/gxXOGq1WbMk7zB3idn+Xed1Hs+\
2n8lorEM27kWwZas+un+QX8xxjvGNEUKf4KruKvae9iImX++Qz9eTsGrg6XMv7BQyPi2nw/\
wL6f5ifwww/GPflSyDjp44tIrLw7Yt08f8ZJH+BOU9YGLt7Fvp/0AT6vdamPvhYbn6QP8OOb++\
3dUMrGN+njq0g8NawyYqvOGWF9gG8d/rs0uS5UWB/g5v03L2i1Yo+\
wPr6JxB2OzB870sG6eXwY2KQP8N3TWvkM7bK3OSd9gPc9ramooRvcnJM+vovEI2+\
Meddr95HmnPQBPn7KSNsL1aHNOekDfErtsfi+104156SPMpHYqqHT5sWXI4TjW/\
AA1zvLxq2Nbs5JH+A2i2v6uE2Ma85JH+UicWPKZ9ePtQnNOekD3MHBMPydAeOkD/\
CSft5z7Ctjm3PSR4VIvOfehtKvNuz6SB/gsVtaZsQvvNqckz7AF5fWBY6tiWzOSR+VIvHK+\
rthnt4XmnPSB/hFgwj7AS3PNOekD/CwR0lm46+\
daM5JH1UisZuquVx4jZTnA37wtbFuVDV7PqQf8Ettyk9ZjIgRfn7g+knXbuSks/tL+\
gIPzu34dJPPfeHnC24/8UjMwoTk5pz0B56UNObmKZMU4ef/QyTe6dCu74/\
rqc056RP857GffmuXPRUeH+D+bSw2d3j1rDkn/YK/y96y1OLVc+HxA2555byt5xDGSd/\
gtRGhNvXX04XHVzX0WXNW+XlxWnNO+gdv39BHb+kM9vto/IFn1tsO7Vr+sDkn/wR/\
YZQxsPxHkvD4BH+1KNBlQzv2fGj+AJ9xtk+Ho63uCI/fGpG4Sr37lKdyLL+l+\
QV8eqLVjWfaLL6g8Q2u/+fwf0mNKcL+DN7pyYdbbzyzhf0BfHfJ3ZxJcq+F/\
Ru82FDDdaoD46SPWpHYPX2Av9/+XGF/B/933GTQx9xMYX8BH/dk7o+R49KF/R98lvhl//\
Ftngj7D7jc7X/ap6aw30/6ADc9puJ77WqSsD+Br/x8Mn1eA/\
N30kedSLzv1LdWpqLDwv4FXnnkfPZvezY/kD7AJ+xSH3SrFZsfSR/gsn+\
SlWos2PghfYCPLWnZ8ZYf0y/pA9xpU/1T/WIp+vgJ/1tpH2+2LUtYH+BV8ulRrU/lCusD/\
Hrb9ynixQXC+gCv3DXhP+NN74X1AT5vo8sMJesiYX2A79C7GWv0olhYH/WIP0O+rMmc9VlYH+\
AKa1afsy37Kjz/g6/N2HQx+ud3YX8G37e90VBrYJmwP4AXX01MGdXmm7B/g5/qo2K74napsH/\
8wvwbv2/R1uBPwv4B7t3f4WuS5Udh/wDv0dW/xVSDD8L+8UsSPyp6nA9knPQB/mtykOuqe+zzSR/\
gGhYmS83C2fMhfYBfb3d+ZvA+xkkfDfC3K7Wbf99nn0/6AL996U/p1Gp2faQPcFs9l9jwSsZJH+\
B1ic/27tVn30/6AH/k9ajGfQ0bP6QPcMW4ml9q79nzIX38hv4jnLXH5X8R1gf4dR0vj9O/2PgjfYC/\
35Q5++QcNv4pvgSPc7yqMuQ4yx9JH+Aqub3nXHhWKpyfgYd+nj129p9a4fzgD+LHv/u8+mn+\
Fs7fwB/svuAzT4Zx0ge495J7V3pBaIL6AJfpfuJU2xj2/aQP8I16++a+Xcg46QO82DG6eg0mSkF9/\
BWJDcL39/hYzzjpA/zKZbmb3a4wTvoAv9UleqPXY/b9pA9wI9OMbRUDGCd9gP85mnvksB7jpA/\
w7Qs2aMtEM076AI+NyffJELHrI300isSeY031zSIYJ32A30rp+f3WZ8ZJH+\
Bz4n92fpXNOOkDfP3shLMKCoyTPsCn9go782N1jXD+\
BH52jaVnb88fwvntfyJxVn57z3cWlcL5FbibdcOcIW3KhPNfcH9F09+v/\
n5pzkkf4HaBw3xNbpcI6wN8U+vU6WNLPgrrA9y1POrY9Y0Fwvr4JxKHDPR6Pcr7hbA+\
wDOdZb4fFMUI6wPcNTC38vbSW8L+AV57dFq6f3GmsH+A/8pqE55u/0bYP8DnTVa1TmzH/\
IH0IWMufrroyHi9UDY/0fMBtxryOn2pdYWwv4BniKpvtmxXLTy/gS8qkrveo7ZW2H/\
Aq84tuTvmdX1z3vR4l4EfKjzUQjXxt7A/\
gb860VvbNbxROH4A1z7qtGmOpUySoD7BA709tOYnyTbnND7A8wo9xstotWjOSb/gJaeH9Ki0b9mc0/\
gB990+eMCAafLNOekbvFI19/C1/q2acxpfsubiXZ5q0wJbKTTnpH/wKX3t55+pZ5zGH/j/XRITnB/\
A4woWG6zSYZzGJ/j8y/2nljxm10fzB/g7u+ILvUPY76fxC17nHfZqqyO7vzS/gCtp/\
9VUzP0pPL7Bd2pPCD+eekXYn8GD3cVLc0oahP0BfPQt2d/5E+\
XNBecn8IqujTEp71s25yQPOXPxjP2Lss9l/ic8f4HX3nxT1rWzFH8BT1TzOL8zmc1/pA/\
wTsNb3rv0t1rYf8AVD00J0B/N/IHmP/Aj6g/y+oayvyd9gPd45DZvLZ8/SR/g/bQvhr0P/iDsX+\
CjDsf+t2bTU+H5EzzkVt6HbNeVwvEf+OkXV//czn8gHJ+DP1MdavX6M5vfSB/gxzQOu8h+\
YfkB6aOFufijX1F62EE2v5E+wIfuMzSV7cPia9IHuPIspxf3jaqE40vwctH8466DaoTjf/CHEXe/\
f6ioE44/wWu1Osx+XPNLeH4H39oYPCOz6x/h+BRca0uq8bIV7PNJH+C+6Y364e+PC+sDfN+ktDsnd/\
wV1gf40jlGo2T1FYT1Ae6hEJls2ruVsD5amotHyh2RbbdGij7AHbt9C4htycYn6QP8UomBzmaLb8L6\
AL+Tv3jGZr/vwvoAP+O9fUt/p3JhfYC/T7BzeP2BxQekD/BRbafMs+v7Rlgf4EFaEyaqPPERzn/\
AO4wYfDLJ5YVwfgq++vCuhTKpx4TjP/Dw4jM3G4+w30/6AHf6nK+\
wuRN7fqQP8NoRa67oKso1fz6kD3mM/9ON5qd0ZZtz0gf43dmf77669Ec4fgEPa/\
9rzjeDn8LxJXgLN51WjsfY/ET6AL/n4TC9+yEp8Se4c/65mKAN7PNJH+BP9/ZTyL4qJT4FN3cu6Ko/\
nsWfpA/wMTei9WXHVwnHr+B2JkXrEwzY+CJ9gNcl1R99M/CzcHwLPr5wlvvmH5+E849WiC+\
OnFEd94TNr6QP8F0rgkVDlrD4kvQBbjRq9DZHl5fC+gDvcGVmyMAxj4T1AX631Z/fQTknhfUB3u/\
2iIKxCfHC8RX41T1By29vZPVP0gf42vwQtbp8Vp8lfYAbXFLQvDmI1SdJH+Aui/zSDva/\
J6wPcD3P8apt3POE9QH+qiJi4l3XImF9gDeO2BytUMKeH+lDwVzstTjN+4oV80fSB/\
iThLdDKlUrhPUBHv44cOPO/uzvSR/gvWPGd3xUyr6f9AG+orPis2PxbPyQPsB36s6ePiSajR/SB/\
hhpen+314VCusDvG5g2eNrr9n9I32AK+1bvs5WKUtYH+BjGmd9y37F6pukD/\
CSQQa5FnmBwvURcM0XMZfkDjwSzj9am4tN28d9y3zxUjj/AO8SKX5Z9JX5P+\
kDPHvrsL07j7H6EOkD3CRfMe57HqvfkD7AW/pPbLzbh8UPpA/wX9cH/93RnV0f6QP8+\
o2gmTctUoXzT/BtHRe9ml7+Xji+Al98/dDe/lfeCcdX4E4a5tdmf2f1a9IH+If80PjBFqw/\
jfQBPv14sJNDNKvfkj7A19tq6Xl+Z/EX6aONufiW7xGLlBD2+0kf4NfW/TuxwC1POL4Cn+\
OYkfFUh9XfSB/giqPOeAfcLxGOr8A/r8zpvXo4q6+SPsAL5e3K7lRUCsdX4M7aD3cNVWT5KekD/\
IGNW6eggSw/JX2AG5rouf1XzOIv0gf4mLebtWRl2d+TPsC77hyxs8cOVt8jfYAXvDR5PMTzrrA+\
FDG/bZjSbeVpNj+SPsCf1k56qKvN6vukD/Bkg0m+QwKl6ANcodC/R59n7P6SPsCrl48eO/gbu7+kD/\
DPkc+OT1jO4mfSB3iO54vypxY/mnPSB/iwr6XfPmxn8TXpA7yf3Uld3WKWH5I+\
wI9v7NN53T1WHyB9gLfsp+PqGM3qA6QP8ANV0wo8LBuE9QFusm7LeaXZ+cL6aGsuVomasmV6Gxb/\
kD7AJ25OUVnXkcVfpA/wxnTHPnlejcL+AR7mY3h44ExWHyN9gF+/WBiq9YfN36QP8B3jDu/Y+\
uG0sH+AH3/rtrGC96eSPsCL008+fbT7lrB/gMd2kzu99hdbfyJ9gHtWuptvsWPzN+\
kDfOSvSbPehr0T1ge4rXXd8Yiqh8LxVTs8n/MpKtN3sPiP9AH+d72HiqYPy09IH+AtJ55UH7iT3X/\
SB3iA34t1IRek1IfBJx4MuH99qpT8A/x2TXvZrIVS8g/J54+PCOrWhcX/pA8JX+i25/FMFl+\
QPsBfTrn0qrqO/\
T3pAzxVVS23OJ7VP0kf4PLz1iRePPFWOL4C3y4bZDy9lq2vkj7AtSdPeRG38Y5wfKVkLh5nWX/\
UKZv1Z5E+wCfstCyQmfxMOL4CPz3A+X3XMyz+IX2A+ylZ/SwwZesbpA/wN9uNlB3+\
SImvwFdqbng34SKLv0kf4PPN3pUmBD0X1gf4i6khn3rIJgvrAzzhYeXojT5s/\
iZ9gHfMKw9MHHVbOL4C7/O7474X/mx9h/QB7v/7T/0FRdb/Qfpoj/\
x2zs7wBGUp67fgHa72fPdqxSth/wBfeFXLYMcYpk/SB7j23d5eN+3Z+hnpA/zUeMuA/lFS4ivw+\
YqPkj0NmD+RPsAvZs1fe20Duz7SB/jp2Htf6t6x/gnSB3intE+OPxul9D+\
Dr3M6lvlnLatvkT7AK588TS51ZPMr6QPc6L292+CeLD4jfYAfWr3hZb/HrH+R9KFsLvZOPm5lM+\
uecHwF3ipt83f3oSw+I32AJ/xTX++xnd0f0gf4UIXU8i6VhcLxFfif5yW+\
irfY8yN9gMuvzPv6Xp2tD5A+wO/Fpi7QlWHrA6QPcENdrwsF75j/kz7AA3q6V/Xbw+\
In0gd4qaQ9QZWtD5A+wHVXrtA6G8n8m/QB3t/10mYTRVZfI310gD9Fl8bpy7H6HD0fcL1Gu62P+\
foH6Qdcp2DS8nsvMoSfH7hdulzK+GNs/iB9ge/TcJx+eJ6U9SPw81Yfb+m8vC6sP/\
Dwurejet9m8Qk9f/A/Z3Ya/HvB4m/SJ/hk07cvil4yf6bxAb41NMtWI5DFl7Q+\
A37slulVpWOsf4bGD7iS+zm3wlasf4f0DT4gaIOsyTI2/9P4Al+scSvUR39P8++n+\
gN4pWFRUdtUNr/R+APvHPo05tCdHOH5AdzWwszSTsTyFxqf4NF7ThduD38tHH+Ca/\
32m9o3mM2PNH7BZSL3/qtVZ/MfzS/gHuvbji8PY/kBjW9wl5snO2h2Yf0jNP+\
Aa6amHrvdg8XfNP7BFTr1P3z1P6Y/mp/AN16esTc5m8XfpA8Vc/HJoffsc+JZ/\
kP6AFc27HHSJp7pk/QB/sKlbt6BXKZP0gf4xlkjPL0U/gr7D/h/FaMtlOtZ/E76AB/S2GHhxPb/\
hPUB3jg0MyivN+OkD/DBH/wT6+P+E9YH+PcFV1p4bmCc9AE+rvbmxuQFjJO/gYebpLkZnGPXT/oA3/\
XuVIrrAzY/kT4k92+tZfCdyez+kj7A1RQO9lJ3ZOOH9CG5/n6mXUp+\
svo26QO858xl61YcZPEt6QP8osjsWu1FVp8lfYB3eOW37lijlPgTPKX80lf3yDTh+Ae8IGDL+\
lcD2foQ6QO8/G/X+UFXWf8r6QN8Xu3Qn6ldWP8g6QN8wEvzNQmtWP5E+gDvXrbU/sxU1p9C+\
gAf1sM4oHwPq7+TPjqai7d9ymj4PEZGuP4O7n3272DVTqw+T/oALz7562avP4yTPsAftT+\
x1WU446QP8AzlVSqOo9j3kz7A2+s4Gy+ZyK6f9AGumr7B+LQKWz8lfYBrv448JQpkz5/\
0AR4Uf8Cwx1+Wf5E+wLt/bZF15T6rv5M+wNvE1vlVuX8V9g/wNwrvp6oNZ/E/\
6QPcrO3j6IfT2fgifYBfmVPUTXZSorA+wDu3tjTsNYPN76QP8PdTDUNuHmX1KdIH+BTj+\
6GHj7P4gPQBPtp46+y/NWx+JX2A591ae+7IUxZ/kD7A413a+FnVsvmB9AG++b1xvfxa9vekD/\
Dwsz5LIqPZ/ED6kNyfskNnH59n8SvpA3z+w+sv9wxk+RXpA7ybk9yVFB1WvyR9qMK/7PxLApex/\
hbSh4QvXTFMxYHFn6QPcL26ExdcnrH4k/QB/vvX2MxvIaw/k/QBLpt806rbHSnrv+\
CeJ6fuCbzP6lukD3C1D/PKBxmw+JT0AW7+7vLsgVrM30gf4L45hUnZt9n8T/\
oAz7q0Na8mlfWnkD7Al2dPdp1zUE64/wJ8fv8uj23LWX8K6QNc9bzRnnWK7O9JH+\
BvfccGprxj9VHSB/jSX93GzTJn9WvSh6rU+ZH0AZ7vtnjaYR02P5E+wFXKt5yxN2LzL+\
kDvJepRbaxPpsfSB/gCzZ1PqB5kV0f6UPy/ZkyVSUt2foQ6QO88E/uYZ3ObH2G9AF+3rfP4/tvpaz/\
geeeOVvbYpMUfYC3batuPmg7q9+QPjqZi2etfXP+\
UhmbX0kf4HmKPg3xA9j9I32A271dJmtZJGV9F1zjfet/H0zY35M+\
wM0TV7bRvyOlvxP8UpHxjoZYdn2kD3Bf11iznyuk9B+CayqWdatdK6V+Br6ry8l+q+ukrB+\
DW8X9TSgewPyF9AE+58NMo0GzmL+QPsAHH0ieNDiMxSekD/A9i77Xu4xh9THSB3jDGa/NPe4y/\
yF9gHu6xz7xrGf1I9IH+Pg7Xmsc+rP1OdIHuMeFH7s8MouF4yvwsycuXQ3PYfEL6QNcLX/\
l29g4dv9IH+AHv4V//TSJPT/SB3iH7T9uq8VL6a8Fv+r//d5nXda/QfoAt4lYkPDuCrv/pA/wvoZl+\
4fMYZz0Aa4j/y7i6D32+0gfnc3F+oMPBKvYMP2QPsBfn/ard9jC9Ef6AF/5n//VF5fZ/\
ED6AH868kjGfnO2f4X0AX7nbcX+nWtZ/Y70AW71zPZbRaKxsH+\
Ar6sr22FnliGsD8nve6h9p9c9tr5M+gAvdipSPyKW0l8N3rBjTZ3eJDb/kj7AT6YEm+v9k9J/\
Ad7Zrc3SnWPZ/SV9gKs/0Qse/ZzNn6QP8PiK9TMHzpaiD8n16x0UtTFjnPQBPlN+\
Tsu6NlL0AX5cXrmDxiFWfyZ9gG+tldlUcHC3sD7AZQ33dW1rweozpA/\
wuwPC95nFsfoY6QPcdmxk1SY1tn5M+pDc30m5s+T1WfxB+\
gA3NjVR66nL8nfSB3jJ8IzCZ9tZfEL6AL8yvYeB6xT2/aSPLrg/rduvXzCExa+kD/Bf5z+\
27mDD9qeRPsC9162wW50fJhxfgb/\
UmnLIXZXtLyd9gNeb9u87svGYcHwFHmXx9Yhq1BNhfYDrPdyn3ecaq7+QPsD/sx5dOXCAlPoV+\
N6ANa/ip7D6CukD/G23A0NsxWx/BukDPHBdpqOXI7v/pA/wjP1PHsTpsPiQ9AE+\
7vn4E26aLH4ifYDLjVuWHXeBxY+kD/\
AOYQlRaXVsfZP0Ab5sycu8gsEsviR9gDfKKhzLW8LyA9IHeFBCQ7u0ESz+JH2AW/WdfepQAau/\
kD7Aq2w2XgsuYPkF6QN8V1LMlJW67PeTPsCNPnfMUdnP7j/pA7z07r+0e8rs+ZM+wMdc/9GwaD/\
rHyF9gMv+11Vc+pDVD0gfXc3FD5V7Vji+Yf15pA/woqNeb6PHsfop6QM8s7Xd+\
vrWb4X1AT78ufjacm9W/yN9gJ+IOWCyZzXjpA/wioGKe88fZ/37pA/\
wm24V13vVZwvrA9xGtPK9vQP7/aQP8GsVp3N2n2TnT5A+wMcscL4xfQ6r35I+wB16evpMrWT+\
RfqQ3L9280adW8nyb9KH5P7tXL3HVY31D5E+wKv/JFx3es3Wl0kf4GPPKw/\
PTGbra6SPrpL8MG9aTQGrH5M+wK/\
XTmjzphfrnyN9gMtWnnfr05Jx0gd4398peUuGsc8nfYCXfmi5cvDaB8LxFXjA190+\
CtrsfAPSB7j56u9Xfis5C+sDXEe8dq9fV7a/nvQB7uytMeWNFevPI32Az0vNHHEng9W/SR/\
dzMUXw7dcX6TGxjfpA/zN5L/WalFsfY70AV6SaT+64xbGSR/gg20MOxlEMn8ifYCf0I1oE7/nsbA+\
wLuOf+vp8eSCcP4BnhPt+VpVV0p8Be4hJ1cWcD1fOL4CX1r6cfc7Hr+TPsCTJm74WTqMxYekD/\
Du5TdbTvgcJ6wP8BZexl2Sd7H+R9IHeO26u90v1rL5ifQBvvDTY1OVzqz/itY/\
wZ0O3D08KJHdP9IHuLnhqcIoFba/mPQBbhw2zijCjemf9AGuEG5/29mRjX/SB3gPP4ukUWsShfUB/\
nzNaZ8nY1h/\
GukDXDF9z96GBBafkD7AC2ztW6VfZPeH9AHeYWF57IZ7bP8x6QPcpujpu9oFbPyTPiTPx9n9c1B3Nj\
5JH92RvxuoV3t0YvM36QNcO7nHrKpZTD+kD/BZm/dbdNrH5m/SB/g8/\
eLK54VM36QP8Ho9RfcTdez8GdIHePvOOVl9VrP96aQP8HzPDjOMljJO+gD36vY50FaR9R+\
QPsCn7yvave1OoLA+wEcuP1F+6i47P4P0Ae5Z5XLPJZn9PtIH+PrJx6/\
2F7HzKUgf4FF9RjpkxLH9P6QP8E/Oyy9f63mo+fWRPsB9hixKGjg+Xtg/wOcnyg6yS7ovrA/\
wJ2meeek67P6QPsBXzI4ZnjIzUlgf4BOSbvaa4O0grA9wmyHTVlXohwjrA3xT+vikDjZs/z/\
pA3xl4pINhZPPC+sDfHjs1x8WP9j5J6QPcKc3b6a7ejFO+gAvUPxq93qkgXB+\
3sNcbHbjg4atNsuPSR/gEb3qe6wLZfkb6QN83RW3nUaP2fxM+gBP+Tj8kO5G1p9E+\
gAXexzp7vKGrW+RPsBfBif5L8nJEdYHuMuavlEVbqz+TfoA36CimpLizfRD+gDvbuMy+FpP1v9L+\
gCv+5g76YsB6y8hfYC3WfpzZ1wti59IHxJulPHj90f2/aQP8K2yO7eWJbPxS/oAX+\
PvqFKVz85PIn2A67617rpaj62vkT7A5/o/re7Rh8XfpA/wwRdtFDbqM/\
8hfYBnrDu4Nq61lPN3wMdPztskcmD9Y6QP8IdPjEfF5LD7Q/oADy+/\
a6gwht0f0gd45b1l4abf2PlTpA/wk+POj3vjvaM5J32AJ27o2m9QXkhzTvoA17/h92rTUzY/\
kz7UzMWH/qzdE+jK4kPSB/iMGT6TPliy/RukD/Crp7d3tXzD/p70AZ4T7NLb+\
SqLP0gf4GsWfbh4oea4sD7Ax/0L3yozhM0/pA/w+COrDp1LYefHkD7AHS0/9C+YxPqXSR/\
gZ6922LA2ho0P0gf4rHvndtnJsP4m0gd4/Ru/7R2Gs/NDSB/g894dL+7XhdVvSB/gA/LubwvJZ+\
tLpA/wletvu+6dxNaXSB/gqtWFZ715/znpA3xF/7hN3/3Y+hrpA7z0/uNJlctZfw3pAzxm46i+\
G3bvF9YH+P0Hmbaps1n8SfoAH138ZOg8fRa/kj7ADTQal6cPZn9P+gA3k90sf3gry79IH+\
DXL93z7ah7Wdg/JNfvWu/ro83610gf4HNPLnu9wVVKfq4Of7lzYs/\
cxYyTPsB3xedvrlrI4gfSB3isUnGk08ATwvoAvzxtallADzY/\
kz7AF6sOcLramvUnkT7A7dsvrbTvzPyH9AF+\
4GrKpidlUvpTwUfueKkfwuufpA9wyzO9G5ItWf8C6QP83/uAt7qazD9JH+Bjvt496KHF5gfSB/\
jzouAluUEs/yd9gJ9rN+Jf9HN2fhzpA9x71LJ31r9ZfEb6AD/777RZfJKU/ENd0n/\
RQulUA9M36QN8svPKOS1vsf5F0gd41HZVl2cbmX5IH+ADX2se+DGZ1W9IH+Cr1C+eG6rH6r+kD/\
CXy1XCYmecFY6vwH1+Rm7Tf8fqD6QPcNdBV1e+\
7cz6Q0kf4CPGu31sn8E46QPc2tz4fVoQy79IHz3NxTtudSuZ/I/N76QP8D1jB4SW7bsi7B/\
gqgu1uifmsviV9AHeb9vFR9lbpegD/Op90+PreX8e6QO814iybtmf2N+\
TPsBDN61rWZLE5hfSB3iPL49OecntFNYHeIf41Rb3J7L5h/\
QBbq0nl3UllO1fJH2ArxRNULsewPoXSR/\
gx24q55nmsfiG9AHu3nNXj5snWH8h6QP8cfbu3vHlbHyTPsCTz//YOHkGy09JH+ARPY+6PV7NPp/\
0AR64482VvbvZ/Er6AE9V89nplMr8m/QBHqAkity5iJ1/SfoA9wof0N324l5h/wBvL2+\
w8JHPbWF9gJ+4HFJj0539PtIHuILOpr13Kpl+SR/gu9uW21nx85lIH+CzA8vVn4ey+\
hLpo5e5eNgMpYujW0ipX4Ef++mstv8Zuz7SB/jW7c/6fj/N+oNIH+C+fy97Bt7yFc7PwRu15NuIO/\
sJ6wM8NLRw79ykWcLxFfjz95FnCh6vEtYH+I34jlP23TogrA/w2U8PX0n5b7qwPsBV/VQdvQ+\
fFtYHuJznb2+dIaw+Q/oArzWftsdS+6awPsAvzWj329qR9d+TPiT8e+IX69msPkn6AJ/6+/\
54oydS9AG+MqZLy2EXmD+QPsBtVDRUZFuy+jnpAzwnMC8nUFfK+XHgLdotajHGgY0v0odk/\
JSpuS2sl3K+Gfgy9T59D5ew8Uv6AK+2nvazKImNT9IHuLLTlW6Ruaz+\
RPoAbxfwUxx9n62PkD7Ae9gVr9XeJaV+1dtcvPHI4OAvDez3kz7A/xbZFP49ydYXSR/\
g71v773MKkdJ/BX6wb6T3a3vGSR/gAW4uH/sHsvib9AH+tf3K11vbs99H+gB3Kl6b9NSTza+kD/\
Dchr1W9asZJ32A+8oPrFl5ne1PJ32A71TLGvEwmu1fI32A99LKt71mfVc4vgL/Yfzm1WAHFp+\
RPsAvPMme7vGQxd+kD/AOv/YX7tBh9QnSB3jejiE5XeVZfEr6AC/R089QsGH7u0kf4C6G2/eu+\
sviS9IHuP2DYWt96ln95FaTPiTP31knfncLFv+SPsC7hZ2zHz+OcdIHuNWE6uQHWWx9n/\
QBrukwWvG7M+OkD3D1hh2jJmez6yN9gH85Pj/FpAOrH5E+\
wBWiDt7pf4bVd0gffczFa3vuulLThs2PdDwG+LNOaR20e7L4kfQDbmZ7pW7dbza+aHsNeMchc3/++\
7hWWF/g1fMrNsq7s/WnpufbHdyqbYLTg/ssfyD9gR/fYrEpcw3rH2p6/v3ApzdqBo52Z/vfSJ/\
ge9ouW9G1M+vfbLq8YeCHdp/4PMdaSn4Ebrx2/O7tX1h82yS/UZLPf6uQkBXMxj/\
pGzxLccDPrR6vBMfXWPCTvSOHW3mx8U36B48TnY2TH87+vmn8WYMbNlyU2fuIfT/ND+\
BpZb1tz59h19/0eOeAyxQej/m6numb5g9wf7XcigZlxpsuz0Fy/2amnB+Txvb30P4Z8D/\
RCo7VkYw3jW9X8BH2jr7Zy9nn0/wDXhamr+75RDi/cAcvle3WXt6P/\
X6an8CTb6z4Y1XG5p8meXiDDxicHBmXzjjNX+AqO9VOxoxl47fp8e4F33ujpNXeaqY/\
Wt8Ft03z6HQqm+VXTfoIlvDQDstjtrD6Gs1/4C+1lXoFufsI6iMcfOjsy3fGZ7D9kTQ/gs+/\
GDxlniI7/7ZJHxHgi9SylGKWSDl/D1y5vv/9JbVsfalJHjfAQz6XLYyrZPELxR/\
gK8cHO519zniTPu6C/9IumrPTmHGaf8H7jjUZemiJ8P6/VPDKIzN6xY9h/krzM/ixMDs32TLGm/\
SRBT4vznnz9QTGaf4Gt9e+Mnd6Kvt+er2HZH5MXHwkmJ//S/M7uKuxteX6o+z+\
0esNwBeknVrzdxxbP6P5HzzioXX2lG/s+TTpowpcLzNrxwsVKedfgA/yeznBs1g4//stmZ/\
yTJJvt2bnd5N/9DUXjw0aPe/sWlb/IP8ATxu76UHuWuYP5B/gw/YWFKi1Y/Ev+Qf4/O7PPpz+\
IuV8FPBfCu+mFY1h10f+Ad4jbmjaGA82f5J/gH+V+6acks76M8k/wA+1+L2qZynrzyb/AH/\
jNflE9hS2f4T8A9wtt+GDlS77e/IPcEW1mVntV7P+U/IPcO1NJ+f8/sL6T8k/JPdveUbCxizGyT/\
AP+pVLz86lPUPk3+A53TNG/6rkv09+Qe44SfVkVqJ7Pw+8g9wpQkDrl89y/pXyT/\
AV1xJ9FHbws6XIv8AP359QM21dOH+cwfwTYkPU1o/ZP5O8Sl45eglPTMVWX8m+Qf4kHvFD5Xdmb+\
Tf4Df+HdOTWm6cPzkDj5u0fARrx8xfyH/AP8ZtWvRYcPHwv4BbrniUPr24+x8CfIP8ABn66lb7Fl+\
S/4BPj7Vr7JmerCwf4AP3dr1g6Ice78K+Yfk+huyFpSOYOsr5B/g/\
Qdq9ZBZwtbnyD8kz2dX3ZhaDynnw4PLmb1/P8qO1bfIP8A7/Vzy7Zweqy+Sf4AnpTi3HTWQ+Q/\
5B3hxi82OU9+w9xeQf4Dr6rjVG7uz9yeQf4DnBsneGnSH9Z+Qf4Cb+FgfUexySdg/\
wNcY6ck4HGP1J/IPyfxT0kpDWYnN3+Qf4HZjF9aFLGX5M/kHePv3OnP67GHrJ+Qf4Jn247efU5Cy/\
xX8Qw/9Yv1a4fNpSiXXP8g/InEi608k/wBfNmxOYdthwuc3VoEnJlzr9Poo638k/5A835jZDj+2C+/\
f/A1+bdm9f8s6sf5N8g8Nc7G13bwfDbbs95N/gL/3WzdszFYW/5N/gD/eatj7xQDW303+Ad751a+\
Okwey+ZX8Azwr4YFzv/ls/wP5B/i1ryei//Vm+S/5B7iicdYngx5sfJF/gAc7PdM4eGG9sH+\
Ap470V93aj80/5B/gg2RCom96sf0b5B/gCZ0+jV5hx+Zn8g/wsOfOLqYmzN/IP8B7KKprWRSy+\
Zf8A/z4cJFtVgnbP0D+Af4u6e3+K9OF19+swUe/FhUt6ypl/\
Qe850Kv2ol67P6Tf4A3atf7GayTcr4J+NC5fn9GJbPPJ/8A/9Ol4fi+/lL6D8DHba6VSW5g+ib/\
AG9T6+u7xJDVl8g/JM8/qvF0ZTyrH5F/gCvFmp23uFQuqI/N4FH9c5wd5Vl/NPmHRB+Dr88fYMD0Q/\
4BvtQ7wcVExPRH/gFeNO7gGN3rrL+a/ENyfS1lh6+3Zv3f5B/ga0TeyrmRbH4j/\
wBvbxnU18aWxZfkH+Dpiha31hux+jf5h+T63Z/V+WsKv78hArysy/xvakfY/En+Ab4zT/\
Fikh2LH8k/wAvXLvI8XcTOHyf/AHcfX2LWqjfLn8k/wG8MVHi+cD0bX+\
Qf4GtVtF7ImbD4hPwDPMj0ud9qe3b+EfmHZH64dnVx2GJ2fhL5B/jMtm/kjXoxfZN/gK+\
yvl1T8oPFb+Qf4J/2Khd2CWDxH/kHuNi6cZ5XT/b35B+S8X3P823EPHZ95B8S/cjdPf+6iP1+8g/\
wicljX32ZyuYH8g/w/9ZuWRZZzfRJ/gF+YuWh8W9rjgrGVzL9MH6fz0sx0pGSf4AHdHIY/O+\
HlP0h4AN2pj3uIsv688k/wDes+r7Nez47X4L8A1zD+XLhLCPh/QvdwT+2XDlYr1LK+Q/\
gzxe2uTJiF/Nf8g9wM5XKhmB3Vr8m/wB32Vlyw5HnN+Qf4CPz/47RiGHPh/wDfHXGqLEWuezvyT/\
AH06QyTaJPycYX5mB96sW1crdY/kn+Qf4AuOvtT+UWP8q+Qd4/8umui45wu/fsgbf7eC9oeVzdv4L+\
Qf4mG2r1U33sP4J8g/w7prB9+34+jr5B3jihGytjm/Y/E3+Ab5w6DjZXdNZ/\
wv5B7hpgGz7d1uFzzd0lfz+T3r5nTqz30/+Ad67Trd4nQ6rT5N/gLtVbVNe00vK/\
k1wI6WuBTd3sP3B5B/gX00OXbxly+rL5B+S5zs2YdIRB9afT/4h+f3TPvSLk3Z+\
AHjqhdDogEq2fkb+Af463vrGEh+2Pk/+AV7V0NO5Zrnw+nw4+Faj8JmHz7H3c5F/gFt3/\
D4nWpv1X5F/gJc9TUjqeZzVT8g/wIP7d98e2pnpi/wDPKbLU9873syfyD/AXV2H20w/\
zM5HIP8An7BX3/pAPZtfyD/A8xY4tHoZzdaPyD/Ap24fPsBCjvkz+Qe4jsWI3ds7sv135B/\
gIV3yaoL2s+sj/wAPXHHVTTuard+Rf4AHPbtdPOcp0w/5B/gJ27ti1dXC738rBfcNd3qs85TNH+\
Qf4GFHpo7ZuGODsH+A5yz33DbT/qBw/gEeHfTlxa8VLD8m/wBHcNJrrZOU/pL+\
5mLzSH2bgy5sfYX8A9xv9PB/n8ay+gL5B7jeuYL3/lUsPib/AG8zfdfnEaul9P+CF+UsWNX2Ojs/\
mPwD/GWHKaOnHmX1M/\
IP8ILqm3YrHVl9kvwDvGz36YsHD0jZnwWuGPus1f19bPyTf4APzxny5m8a0w/5B/iDa+VeuYHs+ZB/\
gPd5lbBXYT+rj5B/gLev/V3wfDnrnyH/AN8xtN2TudNY/yr5B3jexkcmwatZfYH8A3zdTY0BGatZ/\
zj5B/iYCRXH0t6z/iLyD3DDP9mXT/WRsv4BLurbMP3gKpa/kX+A5/sa5uyNZ/Mv+\
Qd4wLAbQ3MuMU7+AT7hdkKVbjr7fPIP8Is/F/h1G8XWN8g/JFy1W1ZqEOtfIv8Av5G5K3jvLdY/\
TP4B7jpk2yIfb9bfTv4huT+bnrmWzGX9h+Qf4B47psvJnWL5FfmH5PtvOPess2Pji/\
wD3HPWuW6v1dj4JP8AX7vFpt3078y/yT/Av19eO2foNzY/kn+Af/W++tboP+H3+\
0SA73QwtVO4KuX8PvBdqyoWvCpjnPwD/JH60vFmk9jnk39I9GVUfWSJHbt+8g9w59+q/35cYvVv8g/\
wtt5ro4csZfef/ANcfWFRr5aabHyQf4B3UQl12inL1q/JP8Czuo6cvzCHxe/kH+D+1d5m6qfY+\
h35B7h25IILf5JY/YT8AzzXeIqmFa8/kn+AzymxPFFhxN5PRf4B/nZbz6FmGuz8APIP8IUTA35tPM/\
yG/IP8Bo5pRhTTZZfkX9Inp9N1CbZiSx/I/8YYC7+FWirW+YpxT/AV6rJF/p8Zr+P/AN8qG/\
G1CEabH8O+Qf44Ji7S1qvnyqcf4AfWBE16M511p9G/gG+9NjFLTJGUvwD3HJmHwOD/\
9j6FPmH5Pr0Brc4E8H6d8g/\
wIvUFoWbaAjn58PAT0xQzNmWIhxf6YM79HKbuEBJeH1wFPiaz09vbfBh6zvkH+\
DVp4JirCt0hf0DXGZFt7hZ5az+Tv4B3vlM6YDLwSz+JP8Ab2GnmafJ329K/gFuteOG9al65l/kH+\
AXl7x693WZFP8Ar7X8zyzLj60fk3+AR7ZaGZIxiq0/kH+Ar6g7dqn+O9v/\
Sf4Bvrt62JVZdlLOx5aMX+W0xZo3Wf5H/iG5vwvvr4h8z+Ib8g/wuJzvC2f7C7//w1vy/\
HZkGg5YyOp35B/gP8bXJI4JZfoi/wCfWNy91R2e35B/gDurBeywSGL1S/IPcOXJXq1aLWPXR/\
4BrnenpfEZB+a/5B/gxhtPjP1uyOZP8g/wQ2NnisaIhfuHI8ALZ/5T2ivD6k/kH+DpG+\
69ThnF3q9N/gE+op/br0XuUt4fAt7j1cIr1XdY/y/5B3jBiiG1E/47LOwf4H/brA/dVMP6Y8k/\
wMMu2PZtl8DO7yX/AA/p89slSpvtTyb/ALcujw070pPlf+Qf4LH+J5IL1rD1KfIPcPVjF8LUd7P+C/\
IP8Nz2d6IqLFl8RP4h0f+WZ52GFTL9kX9Ixp9FcElBK3Z95B/geRs+bVl+mtUXyD/\
AHwR371MymNUfyT8k47f+S1cXeRafk38MNBevj5G7camW7d8h/wDPLPqS1b8V6x8k/\
wAffC5RtPICy+/IP8C/brHp8mg0q0+Qf4BnRUzTeuvK4g/yD3DF3kWZbn1Yfyn5B7hJassBYbfZ+\
h35B7h6zrgN2yzZ+CH/ANfaUVZrWMbOByb/ALedpZpnfpQ9X/IP8EmjJmcMbSf8/\
pBR4J679to5TmP6Jv8AL/dYqu9gxvq7yD/A106We+1fxvyb/AM8+GPDvW6pwu/\
vsQY3N7Mb3WYF239I/gEea2P0d+OndYL5+Rxw1eMzGoyWsf0/5B/gM96WXYy6wM6XIf8YKHk/\
yO1FX7+w+Jr8AzxKw/JQYJRw/60r+Lbqq6GFbdn+EvIP8Hnjq6+91WTfT/4B/m7QY8NVq1h8Q/\
4hGT8JhzRyfrP7T/4B/jcqZ+SZ9cx/yD/AV79TinRLZfEh+Qf46VMPl741YfM/+\
Qf4SeedLmVxrD5K/gGeN1XtusYU4fXBo+CWpr8KrELY35N/gG/8uln3iCb7fvIPif6f9VKyvsGun/\
xD8vyTe8/ysmPrD+Qf4Ilnv0wqSWbxO/kHeI+sqPpl/P1a5B/gW1a0uW3akvk/+Yfk89uutrmZI2X/\
HXj2385ze31l8yv5B/iCuaEK13ax/ID8QzJ+clRyoocI9ydmgd+cnZ5rYc/ia/IP8JmLVsj/m8/qM+\
Qf4BPDZUISL7LnR/4hmd/qeh+auZHFD+Qf4HV9dNXaPWDxB/kH+\
IehzlfXtJSSf4BfjTD769yP5RfkH+AN5bMXmG2Xkn+A268+p+meLOV8uEHIj0Ki1zlVs/ow+Qd4+\
8RBD7dUsviL/ANcwfBItuUKNn7JP8Cd/4zXHPuB3V/yD/BDSYqfbgSz8Uv+AW6/zyZoubyU/\
l3wgQbKPidbC59/1g88ddPHtGcb2Pgk/5B8/rPVxXe+CZ9vMww83l+le4W/\
lP1b4KMu2NQE7Wf7B8k/wC9N/Tsz2oq9P4b8Azw622e35n83BOOrseA1Ew+\
0jGnN5kfyD3CVrXK9cs6w/J78A9zD/M+8japsfib/AP9zOEpPia8PkX+An2gr7zyFv9+A/\
APcx0NrfqAjix/IP8Bb/jo+NOaZlPezS/6+MfPfDl1Wnyb/kFz/4Z3po6NY/wr5B/gGxYN7Zc1Y/\
wr5B3jWj4DHt9OlvF9J8vlRuba651j9hfwDfNbAp93+6yrlfDLwb/594tYsZpz8A/y6/\
vozqglSzocFnz7oQchRA3a+MfkHeEjSTa3kB4yTf0jun9XKyEnT2Po/+Qe4l3u1+/\
wewuuDZ8HXPL6TOdODrT+Sf4A/7Pmg6t5y1r9D/gF+xnXOi9Jg9v4o8g/wOD2DC5susfPRyD/\
AZYZY7ow6z85/J/8AfzRwfcAMFXa+L/kH+IinSRomA4XPp08FPzYn3/vxObZ+Sv4Bfkv+\
wrD1p9j4IP8Av7lq4eu+oaz+Tf4hmT/TKvp9myIcXxWCb/GrUZ1YJ2X/K/\
jKjR0e7K9n8Qv5B3hCtdEE325S6lfgSSYj5/7IlrJ+Lrm+ZY9j0ssZJ/+Q6L9kbMbDASy+\
IP8Ar9hetLVtNJu/yT8Gm4tNe1euTP0ifP6rPHg3r5vWPvz9kOQf4Be7H3/ZNoL5V9P+HWXwLuUa+\
rELpfRfDZbk5+qFVquE32/aHfzx47fH++6S8n4x8OGL+yuf9GL1PfIPCV/24faYUNb/RP4BrhMeZ+\
vxivk3+Qf4k9JlCw7uZv0P5B/g57Yt3t+Tv/+S/AM8uHfFugkaUt7vC579+kJWpy2s/kH+\
Ab5puZHXX3/GyT8k3//j6aQ4Q/b55B/gp+fG1fVXYNdH/gFuuKutxfxPjJN/gHs88HSblco4+\
Qe427lPJ2cbMk7+Ad4x9prFkyes/5f8A7x0c8m9X2mMk3+At6i8/jGoM/t88g/\
whs39J7VYzzj5B7jxmi+Fr+5JOd8VXHf6xxHZH4TPp/\
YGzzcZUPLwBuPkH5LxOdSj97oe7PrJP8BbLTh+ykWfxV+0vw1c/f0T21ftWXxL/\
gHeoeDzjvlbE4TzD3Cbr2UX9l9g/S/kH+BOP8raWJWw+IL8A3zGv8EtVrxj/RvkH+BeGvpmXu/Z/\
lXyD/BPnTeITTuz/WHkH+DR4+MVc2ax/JH8Q3J9ExWmFb1i68/kH+Bp0aUfb9xjnPwD/\
Hm3vs52uVL2f4CLdF1nzdFm8Rf5B/jA2P4Pnvuy+0f+Ab7AP39ZsSXrfyP/AA/qce+y6UAp6+\
fgS0aaDQ8LFe4v+Qi+PnVoxLxHLP4i/wCXCevWOGwh6z8g/5CM74yfN9QUmL+Rf4AfKDasHd6S3R/\
yD8n4bBx0Vec2e/7kH+AZOa37dVrM+qvJP4YgPht49pzLPlb/\
If8AHz7aO3PNeNYfQP4BHtkupVvcXFY/I/8A/ydaUW6fw+Jf8g/w+Q19FpQos/tP/gHefbeZ663/\
2P0h/wAfWj+toUu98P7qfuA3L+j+EKuw/h3yD/CfDWEbu5xl/enkH+\
Dudp83t8iVsn4ObhAfc8XqgLA+RoGbaBpN9ygX3h9lBm77yE53C99/Sf4BPlrurcuf6yw/\
If8ALzMY2TVoq5ewf4CnHjl0tnXyEWH/ANfPlHV/PDdM2D/Aj/Vsr9/wiNW/yT/AH2do501tZPkX+\
Qf43EbFZ+oRrD5M/gHudPTM1Ko7rP5G/gGetPT0YOVZl4T9A7xFZ6070w94C+cf4DYTu+\
hd8Gbng5F/gFcVWp6uvBQtnH+AZ+rs+jbXjZ3fQf4huf8LV70uOnpQ2D/At+9reL/cmq0/kX+A710+\
pku7way+Qv4xROK/77a8S5GyfxrcWd7phF2C8Plz4eAB1xoXvtRk/bHkH+DZI/Y0jl0u/\
H63CPCvm8JznKay+h/5h+T5GCud7BQVLuwf4I+UP4/T+cjq7+Qf4K6iUVU+7mz+Iv8ATy+\
obnXGldXfyT/AG92NT/Y5w+rb5B+S5ztXc0PCBynno4MXbil7vPIu4+Qf4LlnL5SaRTNO/gFu/\
zIrr6s6W18l/wAfG5lXeHu7lPMTwH01HWIWb2Oc/AP8S73i4+6p7PvJP8A3Ob0befiEcH97FXjKX5+\
uGitZ/ED+AX42fcjq54Zs/if/kMyPyktGjIth/R/kH5rm4tbRQ1TnF7D9h+Qf4N3jDl7et0rK+\
dXgx+vO+h++zPyZ/AN82/4dm4xmSDnfGjznmLrsTi32/Mk/wNsdmV76sqsU/wA/d/qw8wlf5j/kH+\
BtD9R4b9jF1sfJP8DL9d/tW1kuZf0c/PmJYSkGE6ScHwF+s/TLKotU4f7EUeD/vBM3PI1j/YfkH+A/\
Nrx+2DuY9ceQf4BHeQ6cN+8Pq++Qf4D/Htftu78/648l/wB/EzT59fnfUt6vDW61rf5U4zv2/\
eQf4ClLFLO9t0ipX4EHzvE7P2qS8Pm4DuCjAh+GRQaz/nHyD/BB5vEqf0ay/J78A/ynfPuuZ9KZ/\
5B/SMbvj141FifY+i/5B/jgigCdWQZSzscAf6IUrNbxPJtfyT/A33umKpdeldK/\
C34i9v7JedlsfYT8QzI+bdfrJMWx9THyD3CvXuYdR2my9QHyD3Df4rF7L4Sy9VfyD/\
AKE5kD19ew30f+Ibm+4ynb5tszfyD/kIwv6wsX1Vaw9TXyD3DdZSqXE/dIef82+IEe42dk1zJ/IP+\
QjL9jaZPvO0nJP8DlZ23Mu/CecfIP8F+zrGOfnmDv7yL/AK8bvqRXrSK7P+\
Qf4JpR8vaPi1n9hfwDfLtL+d0UFcbJPyTzk3bGIJVqVt8m/wBfW7T+46VPB4T9Q/\
L9fyd0CS1m8SH5B/iqAA//SxNY/w/5B7hz4b+kqcOknM+jKTn/tsOCZZrC64NVmpL+0PMZFlUs/if/\
AH97aOpp21zh811/g6sXaazeHiKlfjXUXPwif8X32CGsPkP+AX6udOLtiGGs/kP+AT64Y+aqOS/Z+\
g75B/itVzVj6xSE8/NO4L1ljWeZHxE+X7k7eP3g154WMex8YvIP8Ojuk/a1WndU2D/\
AN0zY1SpqOZu/yD8k1yfX+vKlMax/n/wDfPxP2wfDn7P+O/IPcM20oJxzW1h/NPkHeKdh6+/\
2Mmf9Q+Qf4L/nqUZMWyFl/Rzc8+m5pYNDpJxfAp66f3z96zIp55eAT3qSHli6kumL/\
AO8V8qFnV1nCOtjDvjN84c0exey6yf/AA+1HLpaZYSU/itw9Q8/2twYLqX/CvzXGd/hkYls/iL/AA/\
bt33MrCHsfGLyD3D3bkfiyhNYfkL+Ae54Ylr6nxKWX5F/gGc/n/lrujfLH8g/\
wHcPd6ryMTghnH9Irk8lOW3mY7b/hvxD8vdffP1/72X5LfmH5P7kn36x446U/l3wgkCvZR3sWfxN/\
gF+/2SLIGd94fgqHPxCulzV4zksfiH/AM94N2/3X75+RP4BbiVaOsBzipT+XfDalh5JrkEsPiH/AE+\
/p7i+y2Qp52+Cz7q49dVileuC+rgLvm2aX1zWVjZ/kH+AF81bkPL2AKsPkn+AmznsmFLQn81v5B/\
g3SuXPCwsZevD5B/gX99+v/G1Datvk39Int8/8+Ly72z+I/8Av1Hp8vLIcnZ95B/\
gfRcm2xUtED6foRS883LL9lVfhM9n+A5+7WV2i4dFbH2Y/EOir+5TE4pC2f0j/5A8358zH+7+KHy+\
z2/wpxWzVul0kLL/Q8tcHFez6/uf8+z8BPIP8MbQ/X2Uw7cL+wd4lwc7Yj3jLwrnH+DPyheUL//\
K9k+Rf4Bb+m7STnIXfn93d3CrNrXHei9l+iH/AD/2b5Z6+40svyP/AC9YG+pmdZHV18g/\
wGWnbMyZv4rVF8g/wDs+Wavu68yeD/kH+KUt6wNU6tjzJ/8AH+nt3j9qC3v+5B/\
g67prts0oFD5fbSy4ieWvoQO+MU7+AS6W/74iobtwfGUN7ncsP6G1Lbs+8g/J/\
bkVEXKwQPj9mHPA47XHeA6vY/E3+YeW5P2RBvY58cwfyD/AtwXtSd1izPrfyD/Ap094nbCjK6ufk3+\
AD4yy65wQz/JL8g/J9a/XqVI2Y+vz5B/g/d9FK3UfwOY38g/wQqMV+XoebH8C+\
YdkfJmorQ7ZyOZP8g/J93/OOLlxNlu/Jv8AHyLjurnuCFufJv8A7zz5b9chpxgn/wBvOVe+9JcT+\
3zyD/BJ+jc0rrRn10f+IeFWncvXWbH8lfwD3M0sJve+mXB+\
HgHe4mrFk6QqKedfgasNuPq8VSnbn0r+IdGvRf7lmAjWf07+Ae5z60vtzATh84Pvgq8y3hcZH8XyJ/\
IP8Pav2z5p7cb2V5F/gJ9SVD298jzrzyX/AM9O+3t6wBN2vjX5B/jsWO35L0ay+Yn8A1xFyy2w/\
SPm/+Qf4Fr7Rv8sGc78k/wD3Drps8n2dmx8k3+AFxX36uzRinHyD/BiY58xcdXC5+NXgW/\
wtuslW8TyN/IP8Id7e4ckyrP5n/wDvNMgjTtrGlj+T/6hbS4O71S3/M9q5i/kH+Cd/v7tVtmLPV/\
yD/C2Sm+mKOcK13eVwafI3etk8YrF9+Qf4B+XrDD3yt4mnH+Afzh+cNJzrSPC/gEecPZL2sl/\
awTz837g5Zm3sxUOs/tD/gFeNnOeyj059vvIP8ArTp4IUM5m9WnyD/\
DVj9RfaDZKOT8R3KVmcc4NdynnJ4KbnjZ+6pUp5fxE8LuyDvJPu0jxD3CNsGqfHjy/JP/\
QlvTnze9cv4/FP+Qf4CvN8+NlbrL1efIP8DUn5tVOKpNyfgm4e07bnvd1WX8I+Qd4yqE/X0KqWf5D/\
gH+paNmx7q77P6Tf2hL3q9aNbdVNBtf5B/g3vVKYY0t2ftHyD/A39YdC0h1YPsvyT/\
AjXbv7G12a5mwf4AfLb3k/lufnT9I/gH+OXKlptpqtr+B/EPy+6xwcxpYfkL+AW577U7Npffs/\
GXyD/ChMrmLDp9h9WXyD/DFvxQz9/Vg9UPyD3CbnmHLx48Q3l97Frxlx8phu/zY/Eb+\
Ad41ZOSimFAWf5F/gM9S/Bd38Sx7fxL5B3hrd71MrXcs/iX/AF9+6kV2sjbrXyX/AG+\
xvyR0ToVwf0ky+FKF7wkTfrPxT/4BHm8U2/1eTzb+yD8k81dv65vKWqw+R/4Bfr/dmwI3x63C/gF+\
WfxK+6Qse78V+YdEf4OeGBfpsedP/gH+/MKtY38aWPxE/gH+6XrMNi+ef5J/gB/SLbeK1ZKy/\
iH5fd8ztFaGSVn/AN8/6G7Y30lsfYP8A1xJJdj0gPJFYf8YhvxAYZvMoyhW/yL/AI/cl6jimcTmT/\
IPcEudytIb5oyTf4BXGio5LU9k+if/AN/hfbw6/yd7fxn5B3jJ5NrVI3uw/J/8A3yTZ3b469ZS9p+\
DG87z7XBrtZT9g+DzP9331ZJj9X26PPCkzkstql+x/gjyD3DlBbMWjdnJzk8g/\
wB3zGhfWurE4mPyD/A4j7c7VSzZ95N/gPsatagwNZHyfl7wmdEBfQYcYOtf5B/gG5WiB4uqlwn7B/\
jX9YEi53ts/Zv8Q/L5VUnirrrs/FjyD/BF7vsnbG9k8SH5B3hywwy9Ec/Y/kDyD/CKz12P/\
1SRcv4u+O5xi2XcVrPPJ/8AbxNhZdZqEns/FfkH+MW5QZvWmzwU9g/wL4/bT/iux+qn5B/\
gP52mfYjrzt4vQP4B7pWb+iwzkcV35B/g9b6r0qzzpJy/D/6n0bjiSADrbyH/kPx+\
kyuXPLJYfyj5B7jq49j2Kb3Z9ZN/gDtPfRGZMY6tj5B/gP9IPPD2Ej+/m/\
wDfEmH17fSzrP4hfwDfLJK99k/Stn6D/kH+NydWy8NLGL5K/mHZH7QChp39har35J/\
gJ88m6isn8TGH/kHeNu7PTav0mP9F+Qf4B5VMQknHrL3Z5N/gNecWhc0YBg7v4H8Q6IfW+\
UBX9RZfED+AV69tCBGwZbNv+Qf4PO+rXHqs4G9n5v8A/zv5rJZfrdYfx35B3iHf+/\
eDvdg8yf5B3jYJhcZfQtWnyX/AB/Tc6TD4pvJwv4Bvs/Jc/hpQ5Y/\
kX9Inu9uKwWVVCnvN9CBPkalqkw1ZfVT8g9wuQ7Thu3uwvJb8g9wD70K39DZbP4j/wD/\
s8ugfttbKe+/Bd9qmLGrS7Lw+QzdJd+vGz7G4h+Lj8g/wO8MP78tUk6Kf+j87/\
ncwv4BfuqlONbVQfj9ScPA9UzKFIyvs/V98g/waXKxHQ7OZb+v6fz/UZLr1z9sMCJA+HwGM8n1+S+\
p9fwqfL7PWPBrIab9M9sz/yH/AJ+osfHk3u/s/pN/gJduza2X5+tz5B/gl0qnaR09LPx+\
zDngR69P03SLleIf4J6Ld6uNHiLl/BLwe2PvyWV3YvML+Qe46OUQ/1VfpZy/C35gU8+1T5ax/\
nLyDwkP3LJd9pxwf7s7+PptN516Lmb1R/IP8NO+W0YeeShl/yB4gdb0W6vk2foM+Qd4+\
6bzi9n6DPkHuKPSlNEfQ1j/GvkH+Nx5n0wTnrH3J5J/SMZP1eEzoafZ+x/JP8A//WzXO78F6x8j/\
wDXnvC5pVkVW/8j/wCf+eNW9dvZUvafgxvO8Sn5rxXLj8k/wGMUa2+527P+\
APIP8L7qYVMjl7D8lN6PAb5ErdRk8Qn2fMg/wM/GH8kYcoT1F5B/gJfsnbw7/SJbfyP/\
AL9hFr6n7iarr5B/gJvNM+h05Rp7fuQfTfo70XLMBLY+Q/4hub63/yZmT2DnF5F/\
gGsc1ar55crO1yD/AI+L+HlL5MHOpyD/AF82yWPw5/4sPyX/AL9SY6IqVmX7/8k/\
wPPcvLdvDGT5IfkHuFGptWXVYua/5B/gqf1nz231hsVf5B+65mLX6GulSq7C5y/JgW9+\
MPCWUy2LH8lfwPssl995ZQrTX9PzUwA/9/pM1bNMNr+Q/4Bf++usWBPC/r7p+bYDz9j/6/\
czLRZf0v5E8G47Z8qGVbH9eU3PXwXcZpf9OP0trL5J/\
gUu28a5w9Qs4fdvdwUvWrHwhPtZVv8lfwMvPR4/ouNPNj/T6xXBl2+f9n3oeyn758F/Ld4/qNVBVt+\
k49nBTev3PXUOZf5A/ghuphzbb9o/1v9F27vBtU8qjR1dLny+6mDw1pFtOlrw9z81jc+\
h4AM7pt0Q32fxB/kreNiHNr8d7rL8sGn86oJPadH+9udV7Hwz8l/\
woLVtizepMv03je8R4A9GWtYOqWT7myi/A4/XfPtdZT7bf9E0/o3BbQf1SfqvG+Pk3+D6++N2/z7B/\
KdJHubgOsNMn30TCc9fYyXj47Fxh287WXzf9HgtwSsi1Exz3Nn8Rf4P3vf8ipOxB1j/\
WdPlWYFvMhtUPL8lq/9SfCD5feO266xUZvW1Jn1MBfc4sqPl/ffs+VD8AJ4V8GfxwnwWfzXpYyb43/\
KnMban2POn+AJcMeZPJ7W+rD7SpI954BtkXd7V+bL5j+IP8FX2vnIBkez9ak36WAT+\
yXVxwPU3bH8GxSfgocGHbJPiWXzYpA8n8Eg3+8GFviz+pPfPgA+evnBFehD7fU36WA6etnO/\
teM74fdvuIKPzWwzqy6CrY806WM1eFLXhqytBqw+QPEPeI5BVWWEifD59+vAD5eo9/\
PYJOV8BfArnR7O9PnN8temx7sR/Jjdiokv9Rin+AnceElm/d1drD7apI+tkvH1J2Hrh1Fs/\
0CTPrzBvX5+WX/Tgc2/TfrwBc81dVe/GM/qGxR/SeYv+16/jG6z/dlN+tgFHqL50uOKDqv/U3wG/\
uTqw62z27H+oiZ97Ad/+tPk4d3NjNP+Xcn87fDlclJP4fMHDkr8oS4j/sdApl+\
K78DDNRLDlzqz9ZEmfYRIft/KLsOMvR2bc4r/wHec6TjWpIa9X7pJH8fB646Vqf43k+mH4kPJ/\
FHYbsaIs6z/sUkfp8GjbsiZDGvP+s8ofgS3OxTQW0OdPZ8meVzQlewPUWzMU2bzM8WXkvnhwZmeh/\
2Zfzfp4zL48d9pn7SOsPoxxZ/gFkOn3H5hz+5/kz6iwN9bFzzY1JH9PcWn4Id2rbij0JV9f5M+\
boLLNOwyvP6cfT7VP8AdP40+vHm8cH/ubYn/zr+jc7SKxR8U34Iva8yPP6PP4qcmfSSBv+\
xTEXPZTzi+SgZ/\
FzxZdZqB8PphimT8tjMWJwawv6f4GPzq9hHDutuy9ckmfTyV6NNR9ov3RlbfoPgZ/\
IzOsoA7DvsF9fFCEh9+dHr02CRI0D+yJPP/74djoxvDBfWRI5n/P91KN2rD6icUf4O3/\
HDx4SoHlp816eM1eES6QqT3YuH8tRD8wJIF9gdCWfzfpI934HtM7Ovbiln/\
G8Xv4OJ33z9p8P7UJn18AjfPbvCXG8jiO3o/E/jvMRWt6mWFz1f9IhkfQb7Jw+\
Kl7N8DN0jW25EWyurXTfqoANfNHmbX9qjw+QlV4CNvah5caM36N5r0UQMefGjht6Oj2fsHKH8AX+\
DietEukvVHNOnjF/jlW5FuLUax66P8AlxLyS+sWEV4f0EjePtqh6Ddcuz3N+lDRg/xU6+Ukm+\
3Wf8S5R/geqHV+vvi2PoZ5R/gCeW2M1uYsPUhyj/AvTz9zjybuKc5p/\
wDfNfdZYapRsLxVTvwp3t7Tel+no1fyj/Ax8zq0PBNgemT8g/wiEUDL5S4ME75B/iUM7n/\
tQ0Trv93Bc/d73DkaR6rP1D+AT5td3VoYB3r/6T8Azzqz5Kdm2tYfzHlH+Brvr7+ZuTJ/IfyD/\
DY1NEFh3n9lfIP8M0va0/OVmLxS1P+OxD8Q6++sx+cYvEH5R+S3zfuxZOJIlafp/wDfFOCS8R8Y3a+\
N+Uf4Ffd2t0xWOMr6B+64MfvptUpzmPPj/\
IPcIdraRbrfVn8QfkHeIf9omFPFwj7xyjw4kSdgG38fDLKP8An/hv7SNGf1Vco/wA/\
9r51mxkBwv3t5uCH9mR2jPBh9TPKP8C3K243/RcpfL6iJfjMkrU51zTY31P+\
Ae54qfWM1TnC52dZgRuZN8wIfs/WDyj/AH9po/xE+75wfDUVvFWn21FKNVLePynRx9Hvdx/qCp+\
PPRO8j0NPl3BVKedrgpu/H2IQFyfcfz8PfN3pvc/WPAoU1McC8AsfXu4rUF0u6B+LwIct6Bqb+\
ZLpj/IP8JKj/tM8Vwi/H8sJ/HnOqim/Hdnvp/qpZPxGP+zu/lx4/Wc5eP7fX5P39ZByPjS4Yl/\
VEeZ+jFP+AS6/4MXB9josf6X8A3zIxxlW3YtYfZDyD/DLXbwdR49l8RflH+\
BuVx95vHrJ4kPKP8DNEvQaLNpJef8m+J5fD/If7xZef9oKvsoyM/fKFfZ+hCZ9eINPnW6lbvxXuH/\
UF9ync//XT/ex+iTlH+C/rGszIkoZp/wDPOnW3t3tqqXsr9KTvD95eBeDb8L62C/RX8fQM9/4+\
WuUf0j8JfFCcV0Ue/6Uf+hJ8q96TYtWTF+Uf0jm7xeK41qos/tH+Qf46jfd4iPGsPtP+\
Qe4S7b3wkEhwvsjjkt+f841/9M/2Pow5R/gE5Lzf0wcx+ZPyj/AvU3mZ6p6M/1S/gE+ffZl7Q1ZzP+\
a9HEB/HVtdOf9G9j7Tyn/kMyfF5WvDunB+hco/5D8/qDs4wdbS3n/A7jueu/ECSosPqH8QxJfdLm+\
YeYdtj+R8g/wLjaLV4XLsPiM8g/wjVkLJvXJZf23lH+Af3nZsqGukcVflH+AT+rQZUn8Nfb9lH9I/\
PPZi673tVh81qSPJHC/SddzDS3Y+hPlH+DKPoONk2aw+I3yD4l/vun8rm0Bqz9S/gF+\
5eC1qG5fWf2I8g9w8SLZ/tNWsPVPyj/AZ93w2Vg6zaM5p/wDPLBFxe9tT9n5tJR/SObvGcFzH21m/\
TWUf4AnbqlKmeF4TTj/kMRveSnbHaNZ/Ef5h2R+6t3QJjEuQjj/AO8sa3kmeP0+4fxDMr7b+\
oXcO31cOP+QxA9nOsh0f8biL8o/JPHT4jTRTW12vi+tL4C3WZyp21uRrU9Q/gGek1PZLe88239A+\
Qf4CPm+yvrf2Po55R8S/wzuZHrZia1vUP4B/tgrc1mn/Sx+o/wD/HaQhfqL56z+SPkH+\
AGT2rQ0eVY/o/wDvKzHlM5Ok1l9g/IPyfePzdxYPYXVNyj/kMQXsyu0ptuw/oMmfcgMR/\
zgYuT64jPLjyn/ADfoPOdk5dNEQf+QB1+grCL/5hDbv0X5B3i/Z1lJJ1uw66P8A3xX/8khHfey+\
JryD/BJGlcP2v1gv5/yD/Bexy0utUtj+qL8A3xVh1md9nxnf0/5B/igyPfB+TvZ+KH8A/x0Qtq+\
BEO2vkz5B7jbh4leN8zY+baUf4CX2zpo3x3H6tuUf4CvHDnkYxd+Pj7lH8Ml/VfZsQNHC+\
8f7gde8y22t9lj1j9H+Qf4yfF76sx3svOdKf8AX14wWeajG9Mf5R/gs0ou/\
A9d5x3P9Rc9frOUSqSBUp/QFkVRMlIaVmlJJKPSJKRSCCENJZuISihapGkl7YSohGQUSolKU/qd+\
z6/7/eP77n+fj7evN+v1z333uc5d9zzGUfyo+gfwK/bfju2uZO0f/QP9nwm+\
MZaFvHzuxrAW6RG229JIPcnoX8A33N6q6bmRjL+oX8AX5lx+X3dS5KfQv8AHjnoZLztOzI/Q/\
8APj8ralysH3//uQFwSdUJjp33e9jfydqP15X+jTo91D+AN8xfarhkBhnf0T+A2+be/zxGhcQn+\
gfjDvf6t8o6cOPDFPiDjDXqpZeG8/0DeL9+/2kcvhvC9w/g+ybYXNqfTzj6B/\
Ahkvcm9Jq6ixsflsDzDZc6lcie4saHFfCUyCFFms/I+0X/AP7218rp3r9J/Qb9g32/kVc/Gsy+wh0/\
7IG/jJqxKlWJ1E/QP4DHlkaIO9zljx/rgd+pjR1oUEn6H/QPFv8mzx9ap5D+A/2Dvf/jpd93/\
eLHhzPwsOLrIyp/kfwa+gfw84k2Ki37SX4A/QN46ePwKWuqyP519A/gNcmHBvuNIeu30T+\
AK9QeypJ5wD/fajfwKt2rtwpkSP0K/QP45AlJKwucyPxREB++wKNsjedFXSf1J/QP4Ou7qnxG0/\
O30D/Y+8l89+WMCX996X7gs1wO7L6XRPbXo38Ab57kNfjRDlLfQv9g379r+UH7vmT9LfoH8MyOaZJ+\
j0j+Ev2Dvb/Boh1pOuTz6B/ApXJUuroUyfdD/wAev3VjeORFkr9D/wB+eMzNtEJpUt9C/\
wCuN2ezpU8imZ+gfwCPU922QWs0iS/0D+BXV417N2HUAb5/AF93IEz3mjTJH6B/\
ABeeWbenu5Dkj9A/gK8oKZj3Woisf0f/YPFbJ6J1K8yL6+cXgHdGDMj0ryfrS9E/\
2PxB9aLkuHiS30T/mMruh5Tf3bGR3K+G/gH87KrJhW/TyfiL/gG8W6XvjtudpP9H/2D997vh5t+\
nkfwQ+gfw8L/6d8685NfPC4BrDxi4yiudn78qBG6tsrAjaTT5PPoH8F+WRs6zusn/R/8Afs5Qx/\
qxMf9+6EfA7//XNdNqCd/Pn7D+a+Xlqb/OkfwG+gfw2Yauo5YFkPUz6B/Ap46VnN/\
sQtavon8AfyYWr+NrRfov9A82/+nzdJRkIukf0D+AP1LI2O63iPQP6B/AzWK+faorIvsf0D+\
AO6lJOPzXTfZXoH8An7tAUzfnF7n/DP0D+PMyldQtsqT9oH8AD7GuMFjxluwfQv8APjpYcmpCBtk/\
hP4B3G79xbM3dAlH/wD+wya2K6+av3+pnc2vZnT1PxbJ31/2FfiFQWpCJ1/w77fpBF7m4DGq8zj//\
oifwJM2ZsqKDiLtD/0D+JFHgT5TLEh+CP0D+IS+H4d9c+WvTxTSMHAb2Bk2Rewk+\
X3oH8CHHhkdFSJM9pejfwDv9jc2i5ck4zP6B/Dj9tdC77kQjv4BvML8cuhLCeKH6B/Af1gdM5l+\
i8wf0D+A+zcoxCw0Ivl59A/gh7crxmrZkPkB+gfw2MB22bd0/QL6B/BJIXFVMod7WH8FPPzw7+96/\
fn7T4cDP1Jy0mH5BFK/Q/8APmPqh2zNJSS+0D+A50Qm38hWI+tD0D+ALxr31qxzBhn/0D+AL+9+\
ajXoYQ/774EPOvaqavtavp9PBH6zsGCwjx2Z/6N/sP//+sLv0n1kfR76B/CitW5XO71J+0P/\
AG5ZuvfZbwfS/6N/AC8bPE399JYe6h/Az1wRXnS0L79+PhP4icd+NWZ9iL+\
hfwDXKbhWc8aLfH9BeBgAH777wQep3SQ/if4BvFbhev/mv+T7oX8Alwgol+xznL8+cT7wlTGylQ+\
VCUf/AL5EZ/+4hjLy/9E/gL8VMfQxSiD5f/QP9v5V5/Ta/ozML9A/2Pdz1p+\
dfmwfNz6WAXc4mRttTu+3Rf8AvqHsc9AEbTK+oH9osPz/o8pltH6N/gE8e4/O/t6a/\
PWJtsBdhxw78HoW//xBe+DuldO/rP3Ajw9H4AF3JDbdSe7h/hngI/b+zJTfQfI/6B/Axby2JVt+J/\
kN9A/g50Zoz5vuS9Z3on8A/6Bx6s21CuJn6B/A86JddGYlkPwi+gfwNZs9QpQnk/OT0D+\
A914yOmcRXT+L/sGe/57W3ckfSftG/wC+xd4n90Ie38+9ge9bJf1yzTwyPxHEhy/\
wxzJ3Jt3I4MeHP+v/LUwHzDzA318YCNxK4U5si14SNz72s/6jONJX7i55vugfwL+UB3enBZD+G/\
0DuMGg7EL7KvL+0T9Y/xv2rdvzF/EX9A/ghrVG22s0+ftPIoB/S3ki29+c5O/\
RP4DXv3yRczyGfB79A7i9zKTGpnrSf6N/ADdPauz2MSX5HfQPFv/744wMLpDxGf0DeKedfu7NZrI+\
Dv0D+NjKY76WI0n+Gf0D+HUbp15v7fj779PY+1n+57dHNn9/UjpwLy8Pp31LSH4N/QP4/\
SOpEQXmpP2hfwA3NbvkcvQbf/zIAt5/2pUF503586ts4AdX29jMGcO/X/46i58BpU/2NvfgH2x+\
NLKov+fqHu4nAn65JDvskRupnwniowC4aMpJ3yeZpH6I/gF8tLyRir0i//7Ou+zzF277vZ3IPz/\
gPvCN62r2/XLn1wcfAQ+Mc4sfNJL4CfoHcA/hxP3jvcn8E/0D+C39q43BduT7oX8Af/Vd7+\
SgfuT3oX8AV+zt2KTuQp4P+gfwmN7FFYZPCUf/AC5kXnv1zFrC0T+A95K+mzdvK2kf6B/\
AbWYtMgnbRebn6B/A1ZtCSw5IEb9A/wB+4ZKmj3kmya+jf7D2kbNVe/lTf+740cL6J+ETx4aNIfGJ/\
sHGX/E5jovySP0Q/QP4E/FBacb7yf2J6B8sfhbOXXvU+DjfP9j8acArdwdbsn4A/QP41UN1V0aMJ/\
UF9A/gMyMWN6YsIflT9A/gV1KsXUvEyfo/9A/gq82HZJpcJ58XxIeQpoHbsQObm2/7kPw4+\
gfw1tBI0XGHyPpf9A/gl53sHgy0JfMP9A/g8gmn+o1oJn6L/gF814PkjjIlsn8Q/\
QO4x97Fbg1RpH9H/wCekP9PJvIeqV+ifwA/0KTyZaMuqY+if7Df13duzvqlhKN/AC9usxkrq0Q4+\
gfwrcJZlRmTCUf/AN4SPc0lWYVw9A/ghyNFRcd7k/os+gfwsyviC1Tfkf3v6B/A79dPjwg6TJ4P+\
gfwDUf+GPauJftL0D+ARx/tXWL4iMz/0D+Ab48yStrzgOQ30T+Ah14L9Or7huTv0D+\
A607qE3LVkdS/UD+Av+j9yjRuEFm/if4B/Nu/3R/UE4hfoH8A//JoU9HAGtL/oH8A/8+toERTm/\
Rf6B/Aa8f0zlgkSdZnCMLDAPjadWvcXswg+SP0D+BJKs92K5wi4wP6B/\
Bh4x7qVpj0cP4M8PkXPA7dSiT9O/oH8BsVhbXKp0n/jv4B/\
KLZpmkyh3pYfwW8punU5P6aPZyfCfzg95LKGTrEz9A/gA/8HdJbP5r0T+gfwIcfVMgQ7k3yX+\
gf7PcrnZi8byU/v2sDvHqeXtXPe6R9oX8AV/LaI5f7H2mf6B/Apx74MHidCP/\
8bUfgDRVDcpOHkfUL6B/AE1tv3+3VQDj6B/DmtLV7x6ry90dtBu6XveJrQgeZv6J/AJe+9edQTi8y/\
0X/AH786vxb8wb3UP8Abin31TbtAf/+WQ/2eacDWTf+I/Uh9A/2/p+cuD2qr/P/5egfwAOO+\
r9u1yd+iv7B+pc/hYbvlpL5oyA+fIFPWKFsu8SOXx/0Z+1r9LhUSRP+/CqQ9R9/Tnn2XU3iD/\
2DjS9PM5NCZ5L5KfoH8AXxA6InryJ+hv4B/Kde04mQ6ES+f7D+31V8qsFc8nzRP4BfsnCQG7SQjG/\
oH8BH20S93zGTfz9MNHCxJeZfpZbxz5ePBT7isarBh3WkfaF/sPYnOd1/gRPZf47+\
AXyMjcvmbav49/edBC5sP/T8l3YyPqB/AL+QlVPeRNs3+gcbP7f+fLqwm3x/9A/\
gkUNKZ1z0JPkF9A/gh1Qs59rQ/WfoH8B3OmxJFbYg+1vQP9j3T7zjtK3zIDc+soCf2njE/NAU/\
vlV2cBTcr6XGB8l/o3+wfqXd6JS9zeT/hP9g/1/6/D0CzX89bu5wP+cbK/9epK/frcA+\
J2F5pftfHqofwCfvldu9+TV5Hwm9A82fq87VemyjuxfRP9g7WebUlBsLjkfFv0D+\
LkysZvH4no4Pxb47oEf+8k6kfvD0D+AT9xnqnojg3x/9A/gVk9Ha20aTPLj6B/AH/9+\
5j3ZmIxf6B8svm7kxAetJ+MP+gdrP+YJKTK9yf4S9A/g1nvXJpzIJusr0D+AP1dw0gjIIPGJ/\
gH80ZKl9be2kPaN/gHczjB18JDkHs4nZONPoYr0RG/+/toWNr/bEfD55T0Sv+gfwIc+\
F4642Id8Hv2D9e9Wrg8kJXu43wn4yWVfRb+Zk/k1+gfwQhOjTakVPZxfBbzXiwJDlaNkfEL/AD7W+\
2PHRxrf6B9s/vjkr3FHJ+HoH8B9+q27H32fXz8XmmbgFr6hq2JAIP/+IhHgMknfrtlkkfoD+\
gdwN29PzROWPay/Aj5gl8S/riRyPib6B/AiMxNzBSP+/cT9gC81HDE/RJusb0X/AH72tWllwVP++\
QPSwBuHdw8/nn6EGx+ywNuWWoxIlyTnP6B/AP/3Wjsz9xWpf6N/AN++5vTH31mk/aN/AF/yL/\
zE1toezu8CrmORlOM7jB8f/wG323pSW+dgD/UP4NMU3+SO3UvaJ/oHcIsnbgUmW3q4/wS42L/\
h60x68fdHTWSfrzLf2qu7h/PBgAesaL3pHsk/H1edPV/NLKNbU8n3R/8A3pEyLrBRg9Rn0D+Af3+\
c7jhBi+w/Rv8Arpfx1TT4PVk/h/4B3GD2x+A3TaQ+j/4B3PW6nqmX4mm+\
fwCPvuYgtGoQvz5oCLwupqH4tij/fBMj4NY+k25E7OTfzz2fvV/\
zzxpGlfz5lTHwfdozUw9L889nMAV+cMe7YRuye/AP4AlndaT+KyDzO/QP4FvV9f8GVxM/\
Qv8APtfLZNI0Wt9H/2Dvp13q1KJ2wtE/gIeGDzTV1iEc/QP4Q9ULuuPCiN+hfwB3Mb23PqB/D+\
fjAC+Yu+hViTvxK/QP4FsuKI5Sbenh/oBprL4qlfJnOel/0D+AT/9l+Pz07R7uFwD+qsBuz4Fh/\
PNXnYG/dnwwbfIUkv9H/2DxET0047wDyR+hfwDfZTbw9vlAsv4B/QP4GtXUxBh6fh36B/\
AhGxb5Ov4m8zP0D+CjNRbvL5Ah9U30D+CTpHfdnXj/DN8/WPvV2zJD13w/3z+\
AF26MWZ6hSM6fQP8A7ujm8zp3PDl/Bf0DuG9fr8czzEj/jP4BvNPqwoBz5YSjfwA3/jzYL34aqT+\
hfwB3zvA5XCQSw42PY8D9ytV1o8+S/D/6B+v/263D82l+EP1DEJ/yktq3yPiH/\
sHe7y9LCUllMr6hfwBf2fnhkZgaab/oH8Cf7WvR7D5L2j/6B/CQccs7pvqT/gH9A/\
jgHydL908m8YX+AVz70omVXptIfQD9A3ip0KaMzsOk/ov+ATxukFzn/SHk+6N/sP6t+cWS12qkf0T/\
AL7zzArPy7Hk8+gfbH6iK/MjuYW/Pyob+PGtYhsuZpDfh/7Bnq+i0tisIuLH6B/Aj4bJBwgN6sE/\
gFdLT+xa2Jv0b4L4KACe69lmt3kImZ+jfwCX9utcoLCS+Av6B/DUqMPNNonk/BX0D+\
Cf1z0MujiRrN9C/wC+ekv04eH65PPoH+z51VTP+qZIvh/6B/D5czqULn8n/\
TP6B3DdkH4rCqeQ8Qn9A7jX8+ANIck97D9n8fM+ef3EPmT9K/oH8K6F/\
S3Sg8j8Gf2Dfb5vy2xFeVI/RP8AfmOJgnTU8x7OP2f906LK0YVHyfwJ/YP1/\
wuea13U5uevmoCvChr6oOYD8Qv0D+BHlvqZx7qQ/AD6B/Cyiu0Sbzx68A/\
gn64vLb5lx59ftbPvX39EpLct/3y9r8BVFIaO/W8deT7oH8D/cw1JfivCv5/rJ2u/+\
1LPPugkHP2DjV838k5tiiPzO/QP4P2XR+TPmNjD+YnTDdzUNvZK8Jcifx/9A7h4/\
4STapn89bviwGNW3f7XNoD4DfoH8E9PFIfm9SLrn9A/gL85+eqZmz/xF/QP4CF55Xsc6Pms6B/\
AJWW1CtVVSf+K/gH8gmOEQmlwD/dXTWfnN9TliNuR/gX9A7jTHPuiLmXC0T+AB1l1VIbpE79H/\
wCek2Gv227DHz8Ugac+kDCa95DU/9A/gPd/NfBRvSq5vwD9A3ih1CCvzw9JfQH9A/\
i4g8UjrlaR9bPoH8AzluQUbrQl60/QP4AXrGyeoqrYQ/0DuMXTgbeNq0l8o38Afzl0R58NwiR+0D+\
Ax0erllfbE47+AdwsTNwi9hI5HwH9A/iM/he/G+wj7RP9A/i1RXMmOigSv0H/AO6veijqRx/y+\
wXhYQB8VYWvq6Qe8R/0D+BpgYruUb4kf4r+Adw9rt7m7gqyvhn9A/jucOV32Z/I/jj0D+\
AS3do2S56S8w3QP4C/ndvv+PxIcj4i+gdwzytaN5XjnP7v30f/AD5i51qZ0vGk/aB/\
AO81cPoWfQmyPwP9A3iiUtki+5n884GtgJ/r7B25ZyI5nxj9g7X/2BVW99XJ+i70D+BjNGcKd3WR/\
Cj6B3CbwH3uXffI80f/AJ75q8lZX420f/QP4NdNN28qnUvyK+gfwAfZj/zTUEHuN0H/\
AH517ywXrbvk+aF/AD/m3L9t301y/gr6B/AvHzfUpQeQ+wvRP4C7rntyr+8cV75/AO+\
3yStXZyuZP6N/AO8j3/xbcwJZ34T+wfqPG+li1zZE8v0DeERihmjZ8MXc+PAF7mO6+OOnQnJ+\
JPoH8MsP5AfFefrx/QN47sKRtz/WJ3LnV/uns/tVGtVmR5P12egfwJ2HZjxtn0n8DP0DuHVp2D/vY+\
T8HPQP4FvPTex8N5X4P/oHax8+JYv0HpP5N/oH8JTjw0bp+ZHxBf0D+KKNWq8OjuH7eSzr/\
4JXpqw6S+af6B+s/TdUT7T+QOaX6B/Ah/7ubV/+jHD0D+C/O3fZ+vYi/x/9A/\
ji7Xerp5uQ8RX9A3hJ9RCPIPlwvn8AF3nbYZOpS9bHoX8A//bM6vkFRxK/6B/AHdL61hluJvMD9A/\
2/5etvh/YQfJ36B/Ad8ieePbxN8m/on8A79g07Y+zAVm/if7B+u/sXobfTEl+Dv1jOrsf6/UB+\
zrC0T/Y/OaT/ZdLQ8n4JYiPAuAJ90fKntcn4yP6B/BRu85lFc4h3x/9A/jNVevD+s7hz6/\
uA294IBwqX0c4+gcbP8TaxDpGkL+P/sH6XxnjstX2hKN/AG/eoL9+3FYy/qN/AH+\
x1FVMpYv4AfoH8EOVJvOqssn4i/4BfGfeQvkdmvz17a+AN4nKzcj/SOrD6B8s/\
kuOp5ztTdbHon8A944wW+5uTe6vR/9g8XflV7hIDNkfj/4BXKn3wCmbUvj7a5uAa0TFWVxxJfM79A/\
GTyo2fAwg/Qf6x3SWX288LjqB+DH6B/Dqjmv/fZxKPo/+wdrvU/t7qu9J/4X+Adx40mR1qyfE79E/\
gI9c+D5+yDH++pKfrP+4a52wRJP8PvQPNr9+1PR10Tr+/ah/gUdNHX256gz5+\
4L4ENIycNug18srUpP0P+gfwFesf7hpFV0/jP4B3OREnyWPi/\
j53d7Az6empth08vO7fYG7D3ymkqHSw/m7wD/qWTsUfCLPH/\
0DeP3syMiAIfzzS6SBe3ssTWyVIBz9A/hrifd/ZniTv4/+AbyPmNKPAiX+/dNywIemVh96EMI/\
v2Q48L9Of+6fG0ryW+gfwDviayqv2JL8GfoH8LG1bkOjT8bz/QN4noHUXN3BZP6H/\
gFcqs7Bf1se2f+K/gH8Q61KrOIS/v1/E4FrCufPCxtF6mPoH8C3ropKStrHHz/UgQ8vW7Y/\
1IfkN9A/gO+vj7w2dT6pX6B/AC+tUFgcfYTMH9E/gEc7pC739iT9D/oH8N1/5eZUNhOO/\
gF8cqiGjegkMn8VhIcBcH8VHZuH4WR+jP4BPGO2nE35DPL90T+AH4/9tEjiCxmf0T+AR07dd8yklr+\
+3Ri4/qchib1fEY7+Afxp1egfMZnk/aN/AK80/as7oZbsv0P/AD5jz+DU15p7uPGxDLiL+u1TdwzI/\
A/9A/i7ouamJ8akf0b/AF428K3VxRDSf6B/ALe5ZR8bdJPkT9E/gMt9OdB2Y2MP9Q/\
gYUeLNpw9QfJz6B/AFa3X5JS2k/oO+gfwlvE5g8u/k/oQ+gfw4B9Hzu9Yyj9fdDPwQy7FhXO8Sf+J/\
gFcZ9SnM/NpfQT9A7iQcsMToQv88+Hcgdecz4x3WknqE+gfWmx/2gLnNqUwvn8AD9V6M3q5Gnn/6B/\
A8x0n2Y6WJ/ND9A/g/UYETnvzjNR3BfHhC9zu4qS0qit8P/cHfnR34JGWk6R/QP/Q+p/9LyQ+0T+\
AT9APW7V9LOHoH8DnPZGfJCbBP9/nMPCvq8cvWthK4hf9A/jmeX7J9VP58XEM+IkKmQUV84i/oX+\
w93Ndybm2lJx/j/4BvF29QH67NzkfA/0DuITiGY2MV2T8RP8Ann1JWuREUw/1D+Ba3QkjJDPJ30f/\
AD6+Yn6zzByyvwj9gz3/+Mhj5fvJ80P/AK5toFzRXs7fP5jG4kvZJ7nf3R7WXwFfHrFg4oFF/\
PzVBeADB1oWbUkh4wv6B/CZA5qrjG+T/YnoH8Av7L8x/kHAIb5/AD/Qx8yncClZX47+Abw2/22/\
pon8+wtuAk85lTgop5jUr9A/gFsUhl8yOUmevyA+CoC7Tvjg/aOE+DH6B+v/\
rlaXFj4n90OgfwBXPtGnPu72Sb5/AL9z7qN50EL+/YWPgKsa+5aYzuPfD/aEjf8jGiP+viD5N/\
QP4FtiRrmq0feP/gG8uF0lzSWI5P/QP4BvtL94ftwlkp9H/wAep3hPbKos8Tf0D+BX7b2aRV0JR/\
8AfssqNbd4An//YC1wUZl3OYO2E79B/wBuvfKnZ5Uf2V+A/sHid29thOpmcn8u+gebPyT4bNkSQ94/\
+geb/46euq6/P5k/on8Af2OdmXLgIclfoH8Ad9T72fvJALK/B/2Dxddra6O+t8jn0T+\
Ar0lJPnBKiF8f7AR+Mnhz+euX/P2DP9nzz3Upe/CJjD/oH1psffqqbX93H+aOH3+B//\
K0Eh5nQOZvgvgQ0jZwEz5VddioieQX0D+Am6xu+mfynPgt+gfwqLUbh397SN4v+gfwTx81fOVbe6h/\
AB97LaRPmgq5Hwf9A/jCv1bSTx5E/d/fj/dTAQ9YpWwmMpE8H/QP4LvW7Mye+ZjM79E/gF8/\
LfWg9RTxA/QP4EEu2TW95pH5B/oH8BXLrb+HF/PvBx8OXLlw/Kcb9PwK9A/govvCtnzWJ+sr0T+\
Axzz7enLECLI+FP0D+CPhldv8Dr/nxscY4DdHrZNQSiD3g6J/AD8/TXjnTRH+/U0TgacqdpVPOkl+\
P/oH8Pjv8f1tnvHPZ1AH/iX+1FvJOLL+Af0DeF/Pn3eyzhE/Qv8A7qn488tbur4Q/QP4x46RE8fdJ/\
0T+gdwtZWO0z9+4J9Prcvav8TUt+XHyPmNgvAwYO13fvqL2IR2vn8A/yerU7mphX8/\
uhHwxrA1Q4zECUf/YO3nXP2FJHtyPiT6B/Dn619Mmeraw/1gwMNnF3ywMyfjuyA+FgG/\
6DJPMfEBGb/RP4DvNkxeU7aG9K/oH8CvhcyKNfYn8x/0D+D3876EvBrUw/or4Lm9s4t/qJL2i/\
7Bvr/FxK2fNNv5/gG8ZXZG0Wqrr3z/AN6xJEncsoRw9A/gT+78HLloSgffP4BnCFlpSs0h65/\
RP4CL2JsmFn7v4X4z4I83WITeoPlv9A8W371OWZ5YwL/fYJv2/56PwfcP1v4fPkh7Hkz2H6J/\
AA98FlDb5UH6b/QP4N9TPFa3byP5V/QP1j+OtBlwcTjZf4f+Adzw27zqDQvI+C6ID1/\
gWqWeQxYZkPwr+gfwA9rXrl80Ift/0D+A+4j+d89Gg39++37grw58vVHZh9Sn0D+\
A74wdVty5g9TX0D+Aa0dc7qc1m4w/eH8b8AurPYzcdpLzw9A/gE+7G7pKnZ4fgv4BfMfUHH+RA/\
z7caKBe/07IPnRkeTf0T+0mX//ypa+wZ9fxbP+\
69iUyH3WJP7RP4AfubqntDWccPQP4CXq2WcGLCH5e/QP1n9Panr6/i55/+gfrP3nq30/Z0w4+\
gcbn6pdzRvyyfdH/wBe3TzlkcYi/vrdC8DNv5a6zNvdw/m7wB0OWhcHdRCO/gF88S/1dJnzhKN/\
AJfXmbpV6zn5/+gfwIUy9nbcOtVD/QO4jk+URcpqfnzkAq+\
d82mntTVZPyKIjwLgpaNNzGeV89e3F7L2c2Gs0JsG4r/oH8Bfmvwze7iW5H/QP4DfjfixKsaCzB/\
RP9j4G6g8QHMmyf+gfwC/Z/vpr5kH6d8F8VHC5mffFlY9MeSf314GXP/xzKu7j5P5LfoH+/u+\
D5uqMvnnU78ELnFGISn7Csn/on8AX/5mf/uooT3sP2fjt9KNQcoHSf4I/QO4e/Wfc4PdyfoV9A/\
gZj4xu2J+k/kZ+geLnz3fNqXIkfkZ+gebv8y/vDIuiD+/agHeELrepjyZjH/oH8At3KJ2HWsnHP0D+\
G/bLZ9DFpP5HfoHcFv5tGXPDcj4hf4BfOQBE7nJtmT/EPoH8Ksj/u18+ZN8Hv0D+NbRttGys8nvQ/\
8AXrbvwoHtx/n3P/4FPq+vbNzHzaT+IIgPoRkGbpp5zRrJbmR9K/\
oH8HkJH97lV5D9jegfwBNuDtqw/wOpj6F/AC/xKK0+8o9fH+wL/J5HwM13V0n/jf4BPF1D58KnBNJ/\
o38Af1tlskvWknD0D+BpIbtGakuQv4/+AXzut7qfihbk+6F/AK9ucXb6Eck/30cO+Dmp/\
DvTm8n4hv4BXFxFaYt8H5JfR/8A/kdG+MbB9SQ/gf4B3F0iUzkig+Qf0D+AOxboZTz6ROYX6B/\
AIwPPfb9V2sP+D+D/HjjmxLfw90dNBL4/ZfzKeCeyfhH9A/gLg5lSortJ/47+\
AbwqbW6kXjH5fugfwBX+S98ZNqSH/R/Aj71uOx9RRZ4vTp+Bl6mcUz69lsw/0D+\
ABygvjm1dQPp39A/W/ptmDNs6ldzPIggPA/Z87vufKJpPzkdH/wC+4/mi3CCDoP8bP+\
gfwE992q5brk/OR0f/AD7ymG7Dqrf8+2+Ngbe8t+8rNoW/P8oU+LpQpY/3Vcj6Q/\
QP9n7K1OTqVPjrdy2AL5BJ6xgqQvpn9A/gh3YpTP8ymr8+0RL48nuxEkMC+esTrRgfesvg6+\
Ie9n8AP3jquejdO2R+j/4BfGlKw8BboeR+FfQP4A9GCj1c+ZX0z+gfwNtfSXRHBfD9fD3wzlr3W1+\
Syfpo9A/ge31dzaro+WToH8B1t6kbLTybzvcP4KsVo+45fOLXB7cBf1S2qWUjvT8R/\
QN4X5Ozs47PJesP0T+AGxnsGz3ChMQ3+gfwSR9eb/RKIvGN/gHc9rtI68dEcv4F+gfwNWNy/\
dZ48u838AWu3j2qX8tO/v3b/sA37TqppNFI+gf0D+AmCnHfPt8m66/RP4DntQqrzhpE+g/0D+\
CFIw53tznwx4/DwE9Uj+m7tps8P/QP1v8cXG8724Y8P/QP4KbuF3M835L5LfoH8Icdu6Lrg0n/\
iP4BfFtDv/nLY8jzQf9g8XHyiL92Fnn+6B/A1Wa8r16mS+6fQP8ALtpXZKSsBMlfoH8Av5PyS0k/\
guRX0D+Ad3+Z4rwig9xPhv7Bnk9T9pgTS8j9ZugfwBWft84WNicc/QN41JsSWVUP8vfRP9j46uO7/\
Kc8/361S8B/OkwYJy5E7udA/wC+ea7jv2cbyPNH/2Dj4wNlEauVpP2gf7D2uXrMpaQcMr9B/wCe2F+\
0ynM0qU+hfwAvtwxzskwm81dBfBQAH23o8ULBnczv0D+AS5sOH/I9heRH0D+AX5ObFZRi0Mn3D+\
Cpci+8I68Sjv4BPOSIp+XwqV/4/gH8m1K7vOhs0j+ifwCf8N++54eySP0Y/QN47vchoxRkSP4W/\
QO43u1x3d8OkvV76B/Am+fOOqRXQ/IT6B/AHTaMdCu+QfIf6B/Ah0bUzlaXJ+8f/\
YPNXwa7Xn75gMQP+gfwcI29MgU3CEf/YO+/SdvoSjfpP9E/WP9YN/BiSArpX9A/gK+\
dOtDmYQXJz6N/sPFbY5fneyn++sQ2Nr/88Dawt/debny0A7dI3Nt4RYVfP/8K/PT47thgV/\
79zp3Azxxy/zL2MMmfoX8Ad12ifFJlOnn/6B+sfZ4ckDBFh39/1F82PzIcbfp8Pfl+gvgQmgntR/\
yS5YM/ZH0z+gfwZ7ebrJOGEL9A/wA+8FvsZd3dZPxE/wAuvuLSrUsjyPiC/gF8k/nuG1O0Sf+M/\
gF83o99H/1FSP+G/gH8dnyZbnASyS+jfwBfm+fmXnfoC98/gLcXF9aFrSIc/QO4o9P7I22B5O+\
jfwCP95teW7iG5MfRP4BrnTk8YtIm8v3RP9jzL0txttQl/S/6B3CnjsglqhKk/0X/AO619bjfgmNk/\
EL/AG4zfsDbrrf8/VHjgK+uWDbTZDmZH6B/sOejdK6ragjJb6F/ANfvqzUkQYv0D+gfwAs68l/\
1mU78Dv0D+CKt0D9zJUj9GP0D+MNp2kp1Q0h9HP0D+NLMQhOPOz2cfwU8WONzuZwF//\
x2XeBf1unXflpC/F4QHgbAx/yp1AuPIueHoH/MZOfD5vSZOYX07+gfwJeL56hV9+OPH/\
OBB92VjEob8p3vH+z5FczOTtIhn0f/AG7bNOHJlIsk/4/+AfxVt/WH+CDy/dA/gH+oGZl9rp6Mf+\
gfwFuNp78tGEo4+gdwQ5Mp7z/M+sz3D+CnnxvVv5Mi+Rf0D+AjO54/v7aL+AX6B/CJ0z1fRe4nfoL+\
AfyRzrLZF8fz17c7Ao/QvlzdmU/8CP0DuPGOubNktxGO/gH8jGe/7rh5pP9F/wBusqZ5Qi9dkn9D/\
wB+806eefdR0j7RP4BbJGUOELcm8xv0D9Y+kzfvHPOR5DfRP2ay+3WvXenO4d9vsAu4TP8f00+N4p+\
fuJvxu5eHH2om4wP6B/BeZ0xD1VKIHwviwxf4+6zRt96b3+TGhz/w0Hd6LYWLyfmP6B/\
Ab6QavJ8yhZwPi/4B3F7MJyDZjtw/g/4BXFjxgMjvl2T/DfoH8BHOLzvyrpL9S+\
gfwKNDXab53yL3x6B/AP+1+m3iwSvkfiT0D/Z+nhp4iKpF8f0D+M5K+zp/N7I/C/0D+JHKIYWP5/\
Dvj4oHXpK1/NzcUHI/APoH+//KH5esXE/W76B/AB8v71Pq5E/OD0D/YO07/OSv+\
dER3PhIAT5ZK2NeyOCN3PhIA+482KTlw+gQvn8Av7rEa5/RbrL+Hv2DxU/TytrlUqQ+i/4BfL+\
CwyLjZrK+D/2D9Q+a3k6R48j8Dv0D+OKavWUvHMj8BP0D+Oz1WWv8JvH3194EfmvMT82Ix2R8Q/\
8AnnBnyqmR4aQ+IoiPAjY/cZW6ezuP+C36Bxvf/J8Oap1M/Bb9A3ig3t9+srqEo38AP9tWN2jCK/\
L30T+Ab8/37hpvyz9f9AnwBcW3zzutIn6G/gG85Un1JeXqHvZ/sPZXUz1BWoOs30b/\
AJ74qihbLo2s70P/YHyQjbW9IYkv9A/gP67P9na84cr3D/Z+VIJs6h9Ec+\
OjlsXX07uDii4mcOOjno0Ppe15lvZkfSX6B/AHys2uIQPJ/lv0D+BPFRQe3jpP4g/9g/WvHrs+\
dzmR+hX6B/AMn7eWKq6kf0X/AK60YdBvj+3880vagVed+Nki9ZOcj4L+wcb3TebiGb/J/jf0D+\
Cd44a53Z1G6u/oH8C3/hi7V+EwuZ8M/QP4yqsv7MbtI/0n+gfwsV0niq/c5q/fFdKB/\
jdn9YsIuv8W/QO4VMRv0a5npL6P/gH8mvGS+3Ezelh/BXzEn8FSC6aS/Db6B/\
BkzUzHl36Eo38Anzau4OmSZYSjfwDvXbVkbs1y8v/RP4DnbW7WWBZK/An9A7jkoRPDA3qT+j/\
6B3C3XL/yBdnRfP8APmC4WX7UOJL/RP8AHinUb7qOO7mfCf0D+O/gyFU3xXvY/8H+\
vtO6mPVepP2hfwAfV3d15viT5P4H9A/gS/vOuSjSROYv6B/A5T20L1XuI+tT0T+Aj59c5O43gJyfg/\
4BfMqhp1Ifcsn8Av0DeOPvidoFrWe58aEBPCVQtblhMXl+6B/A/+SsXeT/j9Tn0D+\
A35D8d9G6gMyf0D+AW7eY5Wi38c+n1gVuOaLV8GwQWd8rCA8D4G3bT2/58JFw9A/gQk9/XgxpJs8X/\
YO1nyMrjr42IP0D+gfwMHud6b0nkPMH0T+AZzh2zrXbya+fmwKfOzFEcdBOkn9C/2CfX7gxSvgS+\
X7oHyz++vlnDlcl81f0D+B+BzSGxjf3cP4ucJeapqsy28n8E/0D+MuUxKpVJqR9o38An7H79+\
s9gaT9on8Av50w+0l7A//8dnvg9TkBexVSSH4H/QN4yaC45qldPdx/DnyR1ZMV3fpk/\
QD6B3BxwwEdb+z563c3A/f0eRCadIS/PtEZeE3KAiU9Z7J+AP0DeNJZ2WPydfz1u+\
7Abz4e9idxKPEf9A/g4Y9vrz12mvgP+gdr/3I6Pn+6+H6+G7h2gV5x5Qr+/kFv4J/VD41L3tnD+\
bvAjx8almIxnrQf9A8Wv+/kYi53kPV96B9s/IgUn7SugqyvRf8AfrXfhuLuM6Q+\
if4BXGfCmPArS0h9E/2DPf/Bp3V0NpHz99E/gE9e2r9X6wtPbnwc02H10z1yC+j9YOgfwDeG2/\
2tf0P6d/QP4MsPPjGa682Pj1jg79Z/N8i9QO7/Rf8A7nhhg/zbcP74cQK4r9wypwnmJD+D/\
sH612Ga2a1b+PcbnAbelCLaYPCYv782BXjM2AbdRLq/BP0D+NC8ncLylaR/Qv9g7XOl2bRAHxKf6B/\
s+xl/yLU9w/fzS8Cra1uk9DNJ/KB/APf5tn1Y/3UkftA/gKvv8l4pUknqv+gfwD/YiVh50/ow+\
gfwfaePPPfNJefLoH8AtwjfMf6hBKk/C+KjgLVf4TczP5WT/gP9A7jr4GUf5b6T54P+\
wfqHP6Uvcxr4+2vvA98murTqRSrp/9E/WP+6/NvAlTlk/EL/YP2XVfScUWWk/aB/sPExpnDzmRwy/\
0b/YPO7rWf3jjtI4gv9A3jwRJGilHKy/gP9A3iqWMpT4Qr++pJXwEtby+WHZfVw/\
hXrn5dettwRxL9frRb4lcGVOVVb+Per1QMvGDB7t9o+4p/oH8CLDKec8tfl36/WBFxDv+VTqB/Z/\
4L+wfpPBZXSmjiSf0X/AL6s9nPsh1rib+gfwCsN3VSvd/Rw/znw7+4dywb1Iv6G/\
gG8q7fe1NIScn4N+gd7f7bGs5TXkfkb+gfw/f+kKhVvkfEf/QN49sO4vEIP0r+gfwA3exmY+c+OjO+\
C+BCaBb9/zKaUshGk/0D/AD6xbs2+fkVk/Ef/AG76sqn66CLiV+gfwI/\
ZSDp3qZL5LfoH8P4RFreGXSJ+iP4BPFxb9NiMWrJ+Bf0D+IyXUTX9H5PzW9A/ZrH1k9aH+mda8/\
0DeGJGQ5TcF3K/OfoH42bV+gP2kf1J6B/Alf/rsuh0IvUz9A/gcjPKSha7k/0N6B/Ahw77PKJtMWl/\
6B/AX2gevTfMjMQf+gfwGMUi0d59SfyhfwB/nLprm7YMiT/0D+B3dM50GrcQjv4BfLj1VfdPxSS+\
0D+Av+m35287PZ8D/QP4nvcF5nnLSP+C/gHcKUbm77rz/PsNpgH/t6VhbIEP2R+E/\
gFcVvHa060dZP6C/sF+v+sm6Zj/SPygf7D3N/L5mhhZ/v5BA+CP/v5Ikyzu4f5B4Hr7W+6dG0rGF/\
QP4FW/o34YFJHPo38Azy+UmFYWQeIT/QO40R2nEJc1ZP6C/sHiY9feYdPvkv2l6B/AVb2WLpGt38/\
1cwvgHrIN2n3KyP3J6B/AB66c+ruxnJw/jf4BvDhwi3nkS3793Ap41rzh02+uJPkD9A/\
gaw0O1D6g56ugfwAvczN66hRI2hf6B3BL+8pe4b1J/KB/ADeY5O66woX03+gfrH0NbPTTVSfr99A/\
gNuOcRumX0XWZ6B/sO+vMOWM7yzC0T+ASz3KCBAzJufDon8A/9DnWWPWYnI+\
NPoHcN8hKptVm3y48eEBvF1r6PPqJwf5/gG89auoynl/sv4B/QN4S+d59zQ1sn8d/UPw/\
B0W5DQTLogPX+BffaV32n4g52+hfwAfM3DwV1FhUt9A/wB+w8Or6ur6NL5/AF+hdcp1rSEZH9E/\
gH8XHnVGdiQ/Pg4DV/9ZWDZvEfFf9A/ghj+my+64S/IT6B/Av8m5eqttI/Nz9A/g6zeuSHQXJeMv+\
gd7vm19er3wJferoH+w/qHXmf/ua5D6BPoH8NKRne26vYz4/gE81rbtef4zUn9B/wD+\
ycdReLNJADc+TgNfPXhdscQ58v/RP4Bf2nNn8gkRcr8K+gdw6fxxDiGPyPwW/QO4s/PW1bONSH4F/\
QP4lMJgnSa6/wD9A/izN3dT3UJI/4r+AXzO6pJSt7Ae7h9k8e/Tp2N5UA/n7wK/O+WOao5iD/\
cPAs92cF+fSM+XQf8A/nZTvPCNmz3sPwceveWrcIY5388LgVce/Ve63Zf4J/\
oH8KTYnCEuxuT9oH8A766733eVIpm/oH8Af1DzLjfsPOm/0T9Y/HpKN1RIkvwz+\
gdwMc2JBw1yyfwD/YPNT7L2mG063cP+c+BPD//8/WQSf3/US+AHJbbkRwWR+gv6B3BPz9SvhRmEo3+\
w+d2kuUbJb8jfR/8AHqVxK2/7M+IP6B+sfzo+ZVQfOv9B/wDe+8iHu06byO9D/2Dtp9+XJRusyfiE/\
sHmZ8MTpM9dJfl79A82/ylyCei4S9bnon8AT5V3OaTWSM7PQP9g/XteW1eWCBm/0D+Aj45Tcc8PI+\
fToH+w32/lUfD5MRmf0D+Ab7dMWqeVQM4/QP8A/u5Dhv6AHQF8/2D9l/d8kcD35HxbQXwI6UL/\
17iuovwOmf+jfwBvVD++s0yW+DH6B/CTXaKi/YeR/h39A7j53TdWamKEo38Az1wz8EhDM/n76B/A+\
wp3P25MIvNH9A/g30eKnUs6QfJD6B/AR6a9bjW4SOIb/QO4Wdc/J48sMj6gfwBvMjSQ0/\
Mmzwf9A3hnnsv9/sfJ59E/gG/KvFw5/zTpv9E/gJd27fC78JL4GfoH8Hl7LNeNm0T6N/\
QP4O0b4jK7S0j/jv4B/HFU6eKWtyR/gv4BPK1xknH1A5J/Qf8AvvNQxax7jaT/R/\
8AbldjlmvTxj8fTp09v2a7NwsfkvEB/QP43q0vVf+e7eH+c+DqkQ8WfZtA/j/6B/\
B3BTcHdgXxz4ebCXzf16/tF116uP8c+IctBuIzFpD5hyA8DIBLN60J9/tJ6jfoH8Ar1ln3m/KO+\
BH6B4sfjfbqogjip+gfwBdF3y1qOs0/n8EYuFWFyV4dbeKv6B/AH1mMurpZiz9+LAL+86fk68/7+\
ftrLYB/GlUTLO9K6ofoH+z57IhSqp5M5vfoH8CfqisEr1xI7mdG/wDeVqR9Wy2evz/\
KBrjquOSmfAn+/ihb4OKeN4dU7Cf9L/oHcEulNzHnThOO/\
gFcY1p0cNpp8vfRP4DH6L3a4thG6sPoH6z9BOw8kyxB6qfoH8BXBTcK3Tfl36/mzOInV0V+qRx5/\
ugfwKcUpyZpB/HPF3Vn/ePNkcKfYvjnM3iw9pmqnSWygcwv0D9Y+3tUp5c6pofzr4BrZUb+mXba/\
v9y9A/gD8qExB6lk/ynID58gTc/+6c/q5O/f9CfxfezZ1V9ppP+G/0D+Pg3j3earCD9J/\
oHcPlLjvb1h0j8oX8Av/2i1FslaCffP4CXrL95ze4GOd8a/QP40B0v8k1c0rnxcQy4715nGb/pxC/\
RP4Bf3Gm//q82Of8O/QP40Wd909WKyfoi9A/gZxwkVzv+IvMD9A/gV/taxc/KIO8P/\
QP47mNlZi9HkPo8+gfw1OkukttiyPop9A8WXzqJHq+vE39E/wCePC17ufRNkv9D/\
wAe4rW2JGsZ8UP0D+ANF4zt1yiT8Rf9A/hSn3eLz2iR9oH+wfrHU2+27U0nHP0D+MBrznPyFxCO/\
gF8vpTnsvtb+fc7XweuqX/9yu4A/v04N1n7OL20K6CSzE/QP4APDrIVN3Xm3+9cALzf15UyyiPJ+\
IL+ATzhVr8WM2l+/fwu6x8/na2RnkXGf/QP4DXLrtn8XMPPXz0C/uNsXHDxV+I/6B/Anbe+\
svB9Sc7vQf8AvmBi4+GQr6Hc+VUZ6z9e/NrXXU7iC/2Dtd+gm7ZBeiS+0D+Ar/kWG37Cl6yPRP9g/\
bvkIhtTHf757TXAH7bL7PloyR8/aoHbJHr2+hNL1u+hfwAvOv5W3S6S9O/oH8Dn/E60WbyBjK/\
oH8DtL4+Trx5Exj/0D+DuC8/o/j1Bxhf0D+BiflG/2+rI+jT0DzZ++PsNtJ1Gfh/6Bxvf0+\
q2GL8l63fQP1j7uW+Qvt+AjI/oH8CHL3dIz79K+if0D9Y/5bfelh5MPo/+wf5+RcbDV0f55yf+\
BS7ZXC2s8o78PkF8COlB/7TSdn/yNDI/QP8AfqpyU787YSR/iP4BfKa2+7apLuT5oH8At0z+\
8UhmBRkf0T+ArxbzyOo9hvx+9A/g5kclU4aNJu0P/QP42aNmNha65HwU9A/gotlzctJcSP0C/\
QP4m6yL53eFkfuv0D+Al7+qC5uYZsv3D+Cy9TISom/5+avhwK3eeYS8873E9w/gZ677HguYTvpv9A/\
gtwO1tVJOkPUL6B/AnwltcnzxgvTv6B/A0yPjR6dEkv4H/QN4pXRRiTZdH4j+ocfub9B6emwcWb+C/\
gHcT+hPo0IO8Qv0D/Z+/nyfckefv75EA/iC7OilS9/z15dMA240YNPnNjmyvh/9A/iAflejg+\
8Sjv4BXLE0ONhiBf98Bl3gz51qa1Qyyf8XhIcB+3yWlNX2gWR9C/oH8Pszs9Ujaok/\
oX8ALxnRFG5fRp4f+gfwiO1Sws5ZpL6I/gG8VXFPq4YUyb+ifwDfInZa+mY6WR+C/\
gF8SnhZ1PkKkh9F/wC+4nbl67UJJH7QP4DnnX2h9rCB9C/oH8C/brlXtjmR9C/oHyy+\
ZczTNG4Qjv4BfP6y/L7JUqR/Qf8AHmq21nP9BtI/oX8AP77nvNJdQzK+\
oH8An2obOaN4AqnPoH8Az2+LuzApi4w/6B+sfZdvP521l38+9WbWfmKWHFU4Tuo76B/\
AtcJ96pskSX0H/QP4v1+Lfdb8IPVL9A/g78M8/2bMI/k39A/gfxOnPbNfy1/fvgv4jZfDu8omku+H/\
gFcc+Jy809vyPiK/gFc3Ek2T3Qieb6C+PAFvnicz+Z0Q9I+0D/Y8y0Zm3Q9gMwv0D+Ab/8+8HJ0+\
D7u+LEf+CZb3/vX15Hz+dE/gB+4fE59nhdZf4n+ATxlt4uDsCeZ36F/AJ9jOkUpagfp/9A/gH+\
I2D3O6QLJX6B/sPj4viNsfj+S30H/AD4tYUx36z2SH0H/AP7bZet9lXWkf0D/AK77JGJN2SX++\
dQngIePOr8ggN4Pj/4B/EWY7sQpx0n/gv4B/Kel97DjIuT3o38Ab4qI/5QVyF+/mwZc5fFlyS+\
ZZH6N/gG8KDm65JsuGX/QP4B3H8tZ5PCYf37iJeBtG5c99XvD31+bBXzolP76UnVk/o/+\
wcb3k3a7g1L4+6OuA18/vHXy3Tf8/VE3gX9fdWL2aFeSP0T/YP2LWVT63hdkfBbERwHwh8/yjzb3J+\
vn0T/Y+GCelj/zqTffP4BnLz3XWZ0Szo2P++z7aZn49HEj+5/QP4AHhm/\
L1fflr098Aly9NTQ1oYhw9A/g23aM9ZK6T/bvoH+w7/9tna7IO1K/Rf8AXihy6Vyr6Gm+fwC/\
q2xnc30l4egfwPtYFMs+kyX/H/0D+KH1m0cf7Sb5e/QP4AeXv1QzOkfyA+gfwBNXP3u1oI5/\
f1QjcDXDOM+8auIP6B+sfxv31z55fg/+AVxu5LsLdy+T9R/oH2z+UPKoSV+P5P/\
QP4A7eUicMpxD6k/oH8AT2jPHP73H31/7FXjzX+XG3BLC0T9Y/9VfL7jTmPz9GwL/\
YPNT4a35upPJ90P/YLwtdaRYPvl96B/Ac5LaTqzVJOOrID6E9A3cfF0kwooHkPEZ/QN45cR3DeF0/\
wj6B/C2ylK5kHlkfoD+AfyyVHX6w6nk8+gfwKe97Oq9cxf5/+gfwFcuCJil50N+H/\
oH8P4uo5xjvvDzu9LAr0UHG3lakvEX/QN4w0FdWRF/\
8vzRP4C7ix3s7d1BOPoH8H0qx592hvDXlwwHXvDTa8ctL/L90T+Adyp9UZhswp9f/\
QdcbnrN6wOfyP0P6B/ADV+vzsw4QeIf/QN4cpX4cg1R/v1R44BP/vzp32kdkr9E/wAu8vGSt5UPqc+\
gfwB/MUq4bvIVsv4U/QP47p9fPxr85d+PowE8oCpu68nXPdQ/gNv42UklypL6uSA+tIE/O/Fy/\
p3TPew/Bx44NbvtrQS/fq4LfELKAU8/mR7WXwHf+Dp6aNB6fv3cELjJiqdnxyaQ9R/\
oH8CXJuVoWV0l+9PQP4DPOH2/2aiM5JfQP4CPiPbcM2lAEDc+TIH/ty/C+UiSCt8/\
gF8KNvVR6SbjH/oHcJ3xioknrUl9D/0D+MH8n1PfjyL749A/2PNvn+y49zQZv9E/gK/+oq3/sqKH/\
R/A/wz6rW0RQjj6B/DB0ncaGzr5+6PsgTenPxiw4D5/fbsj8MUPd8gmlROO/\
gH8XqjmRqdY8vfRP4DP/2pdsnk++f3oH/r/mz/hxocz8KzbdYnfvpLni/4BXLxaW7y+nvgj+\
gfwZT55Cnn9Sf4Z/QP454SuEIeLZH2vID52sf7169s4kdhAvn8Af3ry67XQPmT8R/\
8Anunar3mzKllfLIgPX312v5hGoL4N8Vf0D+A/6lJGtQ0ifoL+ATx1o3DbzFVkfED/\
AN7RoSW9rpuMX+gf7PlJOgWcmUvGR/QP4M/Nhu3TrSH9N/oHcNP5h+t2VvH31x4DHpS7dJd4Yg/\
n7wJ/Y2iltEeLcPQP4MMlh69vG0z+\
PvoHcPmSt3leIvz17fHAjyU8NVukROpj6B9sfNzqG91G84foH8CDF0p0GeSR/\
aHoH8B7WSvdzXQi9RP0D9Z/eDt6Nk85zPcP4FZ918Y6t5P9v+gfwIduzd1/OJCsj0X/\
YOO3e59a07o4vn8A/35wyscnL0j/hf4BPMOjZfFxDdK/on+\
w8dvPIXmJERnfBPFxHXhRxbUFlwfw17ffBJ4t9Xb9q0X88xlygccqLdPTEyLjoyA+CoBfdR0p+\
9ma5I/QP4D7NMec+duPrF9D/wBeevR2dvlD8vfRP4CXuTaPvmVN6jPoH2z8fzl4ndEsUt9A/wC+wN/\
s+7/D/PXtJcCj4iz+Dgwk7xf9A/iq/VqamwPJ+k/0Dzb+Ssf+u7H5CHf8eAk8pctktJ0pWT+P/\
gH8ydl75qtfkf+P/gF8yEbr/NZbZH6D/gH806ELY+2f+3DHj3rgZ6OG/es7hIyv6B+\
sf5hcMHFPViLfP4BfUErUab5L/Aj9A7idweIPp5by769tZb9f71d/1RjiT+\
gfrH0qGafnBJL8DfoH619mB300mk7y6+gf7P3P+lw7ZzWp36J/AP91QUZkUyipv6J/AP9pIiQR/4B/\
vuhv/f+p35P6CPoHG39zJ3/flkj6f0F8CBkYuGllHxQ9OI/kJwXvRxj49Pci5e4lJD+\
JfgLcosb4Ta/VZPwQvD9R4Blb3DuU5cn6AfQX4NuOO+iIRhF/FEwPegE/k504uFGf9L/oNwas/\
v87yP8jGX8E71+CfX7ok+jHU3o4/xe4r6um7ttNZHwQtA9J4EFh38b/ziafRz8CLtHaec5tNz//\
OQB401ktbZMN5Pvj/YnAv6xpsumlQZ6PoH0NBJ60Xm2XchKpr6FfAde7YTE8q52s/xG0v0HAc5v/\
TEo5M4LvX8B/z69vy6oj5z8I2udg4EtPHRarjDnN7T+GAt/vXewTmUI+L5jeDgPuVp15SD+\
CcPQ34EdeZclXzyTrOwTtWx54mlybnvpAUj9CvwMuJPPy34QYMr4I2v8I4O39r+\
YvHkT8AP0PuIGKtcJUWv8XhMco9vu++c3RnEDWh6AfAo+4e7PXxWkkPyuIj9HA905/HFlzgJx/g/\
4IfKKtuO5T+fXc+FAB/vfJLvkvEmT/rSA+xgDfuEFu7JI4sv9PEB9jgdckyb8KP0z6L/RP4H5j/\
r3Pv0LyQ4L4mAB8pnL10OdFJD+Efgo8WNoksnUoyY8L4mMScJk+m9qSHUh8o7+y91OSY7HhIuGC+\
FADLq7c+WtfDelf0G9Z/zEh/29cNamvCuJjCnDR/Ic2vn3I70f/\
Bb6sxLT9YSNZPy2ID03gZ2OuL1xmRObv6MfArdfeaO88tpUbH1rA++z/+emeExkf///\
1KwZu9fpPBy/LJfOrODye1cDt+qeR59P+kfaPfg28YLGDuNop/vrPWcD37Hw3ydSGrC9B/\
wbetvdL36W/CR+J6WEDt6pl/pvGrSLrW///8GHgFuefeXNsHcn/CuJjNvA3MWLCpc78+DAE/\
jm9TEtuF9n/IYiPOcCVL4X0Wp1Fng/6PfDYhoqi3vVkf4kgPuax97d3juhyoxN8/\
weuWd3vvEwomd8I4mMB8MlSMq9N249y53fGLL6udS+IUiXrnwXxYQL8tcny7g8z/\
LjzP1PgxTGKTZ86yfndgvgwB55t0bIzoB/JT+D9osBDe7mIfbtH2pcgPhYDH1/o2q+/Bpn/Y/6BjQ/\
T5oi425PfLwiPpWz8anJIeRhLPo/5CeABB95lFIeT/y+Ij+XA5bzzwmd+488/\
LYHfPPFjsm7Efm58rAR+tf9jhcqb5PlhfgN44w/ZQa2/d3DjYxVwsecV5w/Gm3D9zgb4HT+\
n72YnyPldgvhYzfqHLWdrtjeR9e+YHwG+2n1MR0MYGX8F8WHHxs8tM7//\
USDzP8yfAI85NkRIvIjkFwXx4QC8XP/5WVfdHtaXAldUyRhyuoPv9+uAq8e2b5FsIvM7QXysB75+\
sWP3hQ1kfieIDyfWf3wVOeA5jHwe8zPAhzyrckr1IvMTQXxsAv5Wd97v9XvI+IL5G+\
CFql98Th0kfiyIjy3s99kp7xliRfIfmN8BXvt557XQY6T+I3i9LsBd7GYdLjcl9SPM/\
wBfcrBtlKIbaT+C+HAFrqbhVK2jkciND3cWn8e1d7VsJ/dbCuJjO5t/ClneHX2mh/tjgbf+FVF0/\
ck/v2In6391O0eKTeCvH9zF2tfOqS5B1/n7AzyBj4mxtV9cTM7Xw/wT6/+\
n7o9LfkHutxbEhxfrP5Kn/1Sz8+COH97MH/rv7WU8i+wvFcSHD5tffuzl7DmN5DcE8eHL5g/\
vQo5riBO/E8SHH4tvvZZli6aQ/Bjmt4Bvt0+0/SND/E8QH/uA2wWLtU615K+PDwT+\
03bGfAlJ0r4E4REE/NWuiBu2t8j+WMyPse+XavSoK+gcNz6CWf/ypC07KodfnzwIvG9pV/gfEdK/\
COLjEHt+mqbBoc7k+WF+DXhIQrtM/G/\
iz4L4OAI8TCJpQ9HE5dzx4yjwZOPFSWnxIdzxI5T1P14tK5YPJu0D83Ms/qtGqTvUk/\
3HgvgIB646X+3q01DiD5i/Y/ODj/cmNtWT+BLERyRwhZhy5X1KJD+B+T32/\
o8XKnQoBXPjIwa4sOq9cd4Xd3HjIxb47vSwwtaLG7jxEcf6L9/\
k71IpLtz4iGfzn0jTRXqmZHwSxEcC8GvrJ0n+kybPF/OHwNdkKxyZvZeMn4L4SGK/z+uv5YyXZPzF/\
CJwf0eZ6NOHiV8I4uMU8J1nxvzY08S/v/40cO/df+JyVxI/E8THGeBzh66aeSuQcEF8pAD3/\
KRf9Ww6+f+C+EgF3vLU1k8ujcyPMH8JfOrudZ3qFfzzTc+x8Vf/bdvZmghufKQDH3bl9/nQ+2T+\
LoiPDNZ/Lp/93SiHrG/E/CdwZ8de3br0fnZBfFwEXpHxoXmXEX//9iXgj98O9y18TvxCEB+\
X2fxTMSnDw5XvH1nAj6nIRCak8c9XvQJ80M57ASKe5PthfhX42A/\
ptz3FSf8iiI9rwPuHV9Udbgv7vxzXfwCvdHQca3bWnxsfN4Bf3FRj39qbxC/mZ5kfBt/d51tK8r+C+\
MgBvnitY8rPT8QPMH8LfHrvzHdqC8n4KIiPPOAvZ4oXLish9RlBfBQwP1Ae1rw2nYxvgvi4Dbz30og\
IEWdyvh3mf1l86M2P7bOc+JUgPu6w/vnAzc2KIsSvMD/M/CDkrLgBPR9YEB/32Pga9zI9uaGH/\
DFwIxep+b9+kPyzID4esP5jb3Fw3u8e7ndj/jBshdWEapLfFsTHY+CGp2uL/\
60m9TXMP7P4mt5XYXJfMv8QxMdT4AYT3P56WZDnj/dTM/9cEzfINIH4myA+SoHrprlYvLpC2g/\
mr4EfmHw9v/U58TdBfJSz+cGi4I3tFmR8wPw28C1V43UiYkj/KIiP58B95189L7aI9D+Y/\
wYufzVxSfPEDdz4qASe2dcxqW08uV8Z8+NsfBn4M2/NOzI+C+KjCvjf0apGkQ/J/beYPwcumZ9d+\
PokmZ8I4uM1cKfUlKkzK8n8GPPrwH+FWOupfCfnxwvio4493wSZypYy4geYf2fzA+fUZVae/\
PWLDcCjssvGr6b5IczPAze7qr0uVo+/vvEd8NTn62VdS0n/JIiPJjZ+VlTEfVMi63MF8dEM3OS/c/\
X3pd2486sW4JNien0t+RPIjY8PwCUenS9OOUfmD5j/B/7wc69Za6NI/UsQHx+Zn/\
5KUVMwIeMn1gfY+BKWIDlyPMkvCOLjM/B7Db//8z5Pxk+sHwAf6N171Hl7Mn8SxEcH84+GxTN/\
XCLxg/UF4BPE0qWCO0l+RBAf34BLmTVa77lH4hPrD2z+Nshx8iQVEt+C+\
PgBvMTz3Yy3I8n6etyfAbxs8gNbnf6k/iWIj1/AhVKjumfdJf0j1i+AXwiOa/\
lqQdYXCuKjC3igmnWZli/pn7C+wea/z77sKX9D/\
EcQH93A8wqk7579RvLDgvgQmm3gtnVr8ppLZYRj/QO4eajYmDcLerifEPjcGxsi0t/z9yeIAm/\
ruHPTop5//rs48MgH60N9x5DxD+sfwJPV9Fc91yLPH+sfwJ9fn7VL4RD/fA4J4KsUjqQOm9HD/\
nfgQ7XX/tqhxj9/VhK4VcSKxCUeZH0r1j+Ap/a32hrlRTjWP4Brz99zZKUS+ftY/wB+\
ZfPhZm9V8v2w/gHc/3nVr6UfSPvC+gfwC/3S+ikdJPlLrH8Ad1fZum2OBPFnrH8Av/63/cGasaQ+\
gPUP4JsPXYxV2sP386HAH1qKx4wK4MfHMOAtHUWi32bzz3+RA67eUL/Up4m0L6x/AHd+\
vVDBM4W0D6x/AB+ySvFipzB/fjUCuHD82mN91pL8K9Y/gOuF2ym2LyD9kyA8RgE/\
WyupXdRJxkesfwD/obDjnP5HMr5h/QN4a0fvrAwlMn/G+gfwF70kzdTryfoVrH8A/\
yQjYZbWRPJfuL4O+DSTSK2U6/\
z9V2OBjzX9pzZhM1mfgfUP4FHX1YWKjEj9DesfrP2sty790kHqE1j/AL7/\
aEn3cA2yfwDrH8BF1cs1BomT9TNY/wD++Oul7Cgh8v+x/gHcdMxc08cF/PMH1YHbWLy4bKhNfj/\
WP4CP8Vnc/1oSqY9g/QP4Hx1Nm71fyfiO9Q/gI9zEHhzdzT8/ZBrwL4tv909/RvwF6x/A/\
1pOyPj6mbQPrH+w9//P88TIYkvu/GoG8LryU433JPn+MZN9/5sJJRYppH/F+gfwmRNKtr6oJ/GJ9Q/\
g1ya8bpW2Jv0D1j+Ab/hcfujqNX590AD49klFE9ItSf+D9Q/gNQE7MpQNSf+F9Q/\
ghcqv5jUmkfUtWP8AHjS4ZPSr62T9HNY/GJeVjGyI5p8fOw/45ILg+0dF+Pt35wOf7iGUn7yPrB/F+\
gdwMd+a2s1lPezPAp4XqfdyszZZ34n1D+C7V48sd6TnY2D9A/iNYnFDdxuyfwTrH7P/Z380+X5Y/\
wD+SGGn/+WFZP8x1j+AD3+rWLfvO/98LwvWPu9qjjRdRp4v1j+A68w6d33HXDJ/\
wfoH8Hi7wdNrb5D2hfUP1v9N2zm8rA9/fmUJ3EU66dqyIuI/WP8AfsjSK82vnNQXsf4B/LTM7CHmc+\
O4/rGKxcc5K/+M9yQ/ifUP4GFnXWvKwsj6Fax/AJeWNjFcNYCsP8H6B/CcQ6vvGTiS/\
kUQH3bAVfeOkS7+Q/onrH8A/+reEiv6nr//1oGNT1ER23+/I/0j1j+AnzsmVZX2kn8/\
2zrgQqK1yy2ukPUXuP4U+BMd6z/hs/j3JzgBPzz0fFkDvf8A6x/A09Ti/\
Prk8u9X2AS8fvt2ywo3wrH+ATziR9ZiuRz++sktwB31J2oMn0vW12P9A3ifvLODI0zJ+\
nasfwCfrThjadwnsr4f6x/s+Y7Ordt/hNTXsf4B3Glbg0n6SlL/wfrHbHa+gENAtDp5/1j/\
YP37sVppAw3++OEB/NjmV9GeI/j7j3ey8fNbltiISH59cBfwqZXObhuaSXxh/QP4/cZZu3538f1jN/\
DBg9tvZN0g/SfWP4B/L3ZrXBVK+k+sf7D5l3Tx8hW9Sf+E9Q/gRVln1xwRJefrCuLDl8X39q/\
Dqp345+v7Ae/vE7bNNpNwrH8Av/3fovaRCvz9bfuAW4ze2Pu2Ifn/WP9g/esT//eXd/\
DPbwoCXnBbKruvM/l9WP8A/vSC+82He8j59Fj/AB6ytkVizx5+/uogm3//uO97RIy/f+\
4Q8KV2k554ZPSwvxG4V5tCtIoRf/33Eda/uX+oVhlI5tdY/wCekXMr7N9Gkh/E+gebP3icX/\
J3G7kfCusfwEdmRzeMbjrCjY9w5idH9VbcEyL1Kax/ML4nL0/0EsmfYP2DzX+fXTWS+Ebmx1j/\
AF5mHWysupJ/fkIMm9/+/m/JeSeSH8L6B3s/71Wlr3SQz2P9Y/b/nl/CHT/\
igfe9uEX8RBjhWP8Aft5rROW3oeT/Y/2DzW+ndWZWRPPzV0nAXxo7dN7Yyj9/\
6STrfyUkok8lkPoz1j+Yv7UlO+RE8fe3nQZ+4Oyq70N78c93ODOb3a/9sXZSOen/cH02mx/\
WHe5j9pF/vlYqcIN1gZ8+/CO/D+sfrP/wrl5xoR8ZX7H+AbxrjdNYu8ck/4f1DzY/s7OveZtO/\
ArrH8Cfnz6pGpBG1odh/YP1/xfqjGftIvVxrH8wP5l4612jEqkPYP2DcWn3/bKD+fmry8C3/\
opfKHGf+CfWP5jfNyToBpwj8Yn1D+ANv3Ms5v9H5tdY/wD+TfnqWeUtJH+A9Q/gVw++Lmxs59/\
vdB14o5fodyMhMn/E+gfw5f/irbz/EI71D9Y/nxkvu7eK5O+x/sGeb6RNaHsq/3z2XDY+\
pfSOkbjJX3+VB/yX8QHVgb1JfksQHwXA9eMtlU7eJ/ULrH8AD3VwPrdjMMn/Yf2DjQ8ZprErf/Dv/\
7oDPEXXs2mJGbk/DOsfwJMf+Km5SpPPC+LjHvNnw9yNA+RJ+\
8D6Bxtfsy1CPL4QjvUP5jf7z801uUw41j/Y/GqYw5ejBwjH+geL3yzJ0xn/EX/E+\
gebP80M8R42l3CsfwD37rg/6sc0Mj/H+gfwU/YW5YorSP0T6x/A9/6VvViQQ+q/WP9g/9+\
7fkT1bl9ufJSz3zejzT5s0x5ufFSw/vGSoa/ZCvJ5rH8A/3f4sfA4MRK/WP8AriCyccP52L3c+\
KgE7vu1Ov3eWrI+\
BusfbP5xUebMCM0t3PioAi7rKb5W1t6BGx81wIfOuBJ85KwdNz5eA084dLtQXpqsX8D6B3BLrQ3hC4\
57cMePOuBWq4r+NMbyz0euZ34ut/3Dsm7SP2L9A/jGM1WX1AvI+Iz1D9a/poUcdXtK1m9h/\
QP4paTuT8fK+PmrJuCfM9ICyjT440cz8Ez79BdLVpL5NdY/2PiV++Zo1mDy/7H+\
wcafSx88VbJIfgbrH8zvHnWn9uki+1ex/gH8y5YWsd19SX0L6x+s/\
y2aXeGuRur3WP8AfsTxQ1B15CFufLQDH78m4+7ZRz3UP1j/qpaTOn0dqS9j/\
YPNz0xkFj78QvKjWP9g/WukbtfBzST/ivUP5odui9Xe9+Gfv/qDvZ/gbdeGJvDvP/vJ5m+/\
6ruTa8j/x/oHcJU+6Z5VQ/j53d/As6LWvoxIIxzrH8CTSirUT4mQ/h/rH8BLfjTN21lPPo/1Dza/\
8m9+FPWGfD9BfAgZGrjFth5/dXsYf/2uMHCN+mmdjZmkvo71D+BTXRbbd6eR/hPrH8Bz2nLcPQ+S+\
TPWP4AHVgf+/XiUrK8RxEcv4E/kZsmrOZH1ZVj/AH5LVmis7+Lj3PiQAD75iPLE2VNJ+8b6B/\
BsiV7itjXEP7H+AXybWeCXky78+3X7AW9zsW6cG03ym1j/AC7jH7ZSMpasT8H6B/DdNsPMIovJ+\
jesfwC/c753fqkY+TzWP4DPHpzfYTyYrB/D+gfwnebqO6xfkPVzWP8AvmTRs+\
KK4cRPsP4BfOKsmift18n6E6x/sPbzSiZzzAbSv2D9A/iEJVX9VWfyz9eTM2T7x8dfaZYk62Ox/\
gFc21u5UEaafz7lcOBO5oNfbmolfoT1D+C6k9Zd2RpO+kesfwB/Pa0l4kgk+\
bwgPEYBf9rt9cPuCpl/Y/2DtS+N6NWuTSR/hvUP4M7mC31jQvnjhxLwV4sabyWHk/k71j+AD/\
cpD3lG8+tY/2DxOXzQU5tywrH+AfyzscLoXXT/A9Y/WPu+vCv9uBh5/lj/AN6ZeFFcrT95/lj/\
AK7pFxc29AV5flj/AG6zYatzlSfxG6x/AH8Q9krJRIH4I9Y/gPedlh6SoEb8CesfwFccd8moOkk+j/\
UP4FKaKueDpvDPR9cAnrdbS7TfO/J+sf4BvDnTKndlNd/PpwEfKbRl+QvHHuofwDta9//ne43ED9Y/\
gLs3JlhssCD5Wax/AJ8/ZbLEVj9yfiXWP4DfE3ozpg/dH471D+BjM1fPThjPz+/qAv+\
UNWb7qPP89SV6rH+KlrGcE8ePDwPgJwcdz0+2Is8XywvAPdrXiWusJe8H6x/Ak8aIp2x+yV/\
fPgf4UnVTZ7tm4vdY/wA+ICJ0pM19wrH+ATysbrRY4k7SfrD+AVxWyuhJ6hTy+7D+\
AVxxd17T6i4Sn1j/AO7yNlh2Xjx5P1j/AG4/11ROroY/vzIFHrpy7pQV6eT8Uqx/\
sPiT7XZXHUPWH2H9A3hk7Bn5cUlkfo31DxZfcbNHyraS+1uw/sHa7zqjkooA4m9Y/2Dfv/\
XzRblOcr4j1j+AB02tqcrwIuf7Y/0DuPSLfEWVfmT+\
hvUP9nzNc4MODOLff7YSuJf5cOcfVfz5lRXw9HcXyy69IfM3rH8ATyiPV87wJPlBrH/\
8v7rOPB7LbQvARJOiThFuaSApDZR0lFuG6EQSkSkZU0KDqVBEVIZC4kNFUXTpGIqSo+\
FQGlRXUooSkQbRYCgU3bWt371/tPb9+/kZvu/da6/hed/9Ag8MW9xzs4XMh9F/AJ+Wd2lVszPp39F/\
AHeJVgq4fYt/frsD8NXO/nOuipD5J/oP4NWlE413TCLzZfQfwKvkYl7odZH5KvoP4L+/fd44YQ+\
Zz6L/AB7VOaZWt4Q/390EPFMiXBCbQubD6D+A7+y9PP/\
4ODJfRv8BfInf0ofXlvL9oBvwXrk90QW2hKP/AP5YbKNN6WHC0X+w6yN8ILCtjHD0H+\
z6mxubVJwnHP0H8PiR3YEiEwhH/wG8Mzv++jcJ8vnRfwDPOHzGoucz+X7RfwA/OKqsrp2eH4r+g+\
3vE6fdlFTjv3/cF7hwpJSdtB+5vug/gL9WU9Ee8SdZH+g/gBsqTqhbSN8fhv4DeOmmhMwf9P2T6D+\
Ah1kVd4ULk/WL/gN4TpnSpDt1/PMXAoHfvXWgRTSb78+D2Pdb0nndcwN/fhUM3DNXKU5uDf/\
81xDgAvOul48nkvkW+g/gQ3eWTxcfQvYX9B/Aj4X3qM3LI/NH9B9s/ayeE77AlfQ36D/Y/\
uVuvPNFP9nf0H8M1gcrBgTaZL6G/oPVXyENI4ZHkP0T/Qfrn1x7MwXW/PlVFPDWyo5DdVJk/ob+\
A3i/YOTzxgbSX6H/AG6yp/hjzpEIbnzEsPpsWYuCq8CHGx+\
xwH9UVwQYKThx66sjwJsuN9fs30nOr0T/Adzd1veV+yJy/zn6D7a/vpRevO9RCre+SgD+\
l0GjbVYF3w8mAo+MmSYv30Kez0H/AXzm6uLibRL8/iMZ+FexVNPaUsLRf7D+R+aCsZ0b4eg/\
gB9vqiybJ084+g8Wf3dfxXsbEI7+g+XPlJzuafR8icH4OAX8ycMnwnf2EI7+A/jZ5JBaBUXC0X+w/\
nD/zwqjFP79V6eBJ6X7Cu0dx+8/Mlh+qf+UKZnG7z8ygY+8sDZUZiW//zjL+ptzbdXHOsn5G+g/\
2P54IM5jgw7h6D+Aj/rafuRaNrm+6D9Y/FyJWrNLlvw8+g/gwx95fp6RzX9+MBe4TGv9k05/8v2h/\
2D1x8g40wEn0h+h/wAuLhesNkyS9EfoP4Bv2nCwVvUcqS/Rf7D+/lXPm8wtpH5G/\
8H6a6ndBuOof0P/AXyj1M8xjrGkfkb/Afy7oNl2Qzapj9F/sPp48p7XBU/I/BH9B/\
CsJbLW4beJP0P/weqbFTeSb+fzzze+wvrjj6N1/LYRv4b+g9W3q+QfvDvJP//\
4GvD0k4ldnrKED8bH38CbnXTXSavxzy8pBV4oFjHZy578/+g/gO8Sn/jqZhn5/Og/2P54+oSblRH/+\
dpyVv8lrcxMPsvvP26x/SHtUpO8Hpnfov8Art2v7LariVxf9B/\
AT6j1yqtr8ee7FcDHDWkbWPee9HfoP4DLdejnaHny4+M+8D4pmZf2lmT+g/4D+Ok6McvRZWS+hf4D+\
Iws33yN3aR/Qf/B+hPvxqfecQnc+KjS/a+fIf4R/QfrT+/U7l37nvw8+g9ddv/FkJUzxMn8D/\
0H8KsRl/0n+5L5GvoP4KJd3y/mqpP5GfoP4HZn/JTO2ZDPj/6D9d+b907VOEvma+g/\
gIfHLnAOdSHzQ/QfwBtLLMT3+xP/gP6D7X/G1VMXPMzixsdLlt/\
jZG5rJpD5wmB8NAKPEbEW7Ksg1x/9B/CThjEztxwi+z/6D+BClTPkp0uS9YX+g/1+/XClyN1kf0T/\
AXy9mfPSivtkvoD+g+2fNSYVrTlk/0T/ATzEe6WSw1bC0X8ANxYrPT6snT+/amX1S1FTlVoL2d/\
RfwC/JLp8/NzpfH/exuqHvhUL+xfw88dH4DWaMevTZxOO/gO4tH5dxD9jCUf/werb307N3H+\
bcPQfrH6KclcbnvF/3i8OPGiN/stCmn/RfwD/KCPmENdArj/6D+ASosLvzQWEo/\
8Afi1mlneIBuHoP1h/+SjjjmsweX4J/Qfw+x1fZvmnkvWL/oNdHydbWSVTMh9B/8H49q3qb3tIfYj+\
A7hprIpk/0PyfCj6D+CSG9uLylQjufEhtFzb68xCibSJlTu58SEM/KZNgov/xrXc/mMI8D7B9klPs/\
25/YcIcLG7ZWJ37cnzZ+g/gNepKrgeTCbnt6H/AG70e/leswBy/gf6D+DaEjEeFZ/\
458uOAN4VZjr6y0pyvgf6D+CeJolSqWnk/UvoP4DbSE6ZMyGWPD+F/gP40j69IM1kcj4h+g/\
gYQKHkPGjyfux0H8AF7zpabhz0IYbH2OB90QMnN41g7z/GP0H8NbP6q4PZkRw42M88OPq5+\
fJ3jnCjQ9J9vvtitIeZBC/if4DuF1UTI91FVl/6D+AX/20+6egjZ8/ZID7H96+f5E5Wd/\
oP4DbXlA9NWcX4eg/gJ94YJp1/wPxP+g/2PoYVtI3yYzkR/QfwI17S8WLk4K58TGZrR+jupKxOY7c/\
nwqcCkzhUn6TWT9ov8APtZnlKzCdDJfRP8B3EnNsn9ZMnm+Dv0HcBHHkCNxP/\
jvh1YE7mJdMufzE3I+GPoP4AumLRdsruT350psfapfbcoVIudzoP8AvqnxiaduCP/\
9bsrADQrVNCLKyPN16D+AF31RWasnTean6D+Ar3CYZ/fXVnJ/CPoP4InRiyufJZL+\
Hf0H8NpOraW1PiT+0X8ALw7b+1XEluwf6D+\
Ah0i7F36IIOcLof8AHiVrW5soRp6fRP8BvPvEo9aYgdBfOfoP4F9VnbP/0U7OP0D/AdxDO6BE4xI5/\
xH9B/CkzqioRbsCfuXoP4APL/RVFqrin++zBLiK0EuVBfWev3L0H8ALMj7m72sg6xv9B7v+\
55UyJvuZcONjGfBXJy9JDTz35OYPbeA10rbvuu8GcvOHDvAZ3lcXGvWQ+Qj6D/\
b5y3sKoq3CufXVcuChZcJzJdPJ/B/9B/DHsx9dHHs0lltfrQDuN03PLCudzF/\
QfwBfq5CtIStG8if6D+Duo8prTbtJfY7+A7je9g6pm6vI70f/AbwwfvSyelny/6H/\
AD4kzMHD2ot8PvQfwOvz19W2Xif7O/oP4KsWzVTSCyX3B6D/AK4qPGEgt5+8/xz9B9uf+\
2Yt3SCyj5s/zIAHzbPzmPo3ub7oP4APzV/tkfDeh5s/1gHXHF36NC9Wh5s/LIE7NohLhb/mx4fV8v/\
Nz7jxYQ18cm/AwuR15Plk9B9sfRhvVS5ZQOaL6D+A/wh/G3i9iOxv6D+A73/QouKfR+aX6D/Y9+\
vgE5BUT/hgfDgAF5exqd82i+zf6D+AK+r09l7qIBz9B/C4Gx6eWdP558M5s/hsKlM1yCH7N/\
oP4Oc1421G7yb3d6P/YH9/z5SsN5pk/ov+A/gd5bTqFlcyP0b/AVzZREwn15L/\
fh434DJNw7rON5D8g/6D1R8ZGvM+XiX5C/0H8ISABzmaNeTzo/8A3tQ0X7psFzk/\
GP0Hi49L9seCXcn3i/6D5U/NhcX31pDrh/4DuOEIFwMZIf75z94s/1g2HrhykKwv9B8svwjt+\
RYvRvI7+g/gF0qaf5xZTc53QP8BfNSkdy8qn5P1jf4D+L2zRXLHG0h9gf6D5WevI21pdiT/ov9g++\
NOPwsvGVL/ov9g69924tVZ98j5Eug/gL99v1ZQ5EDqY/QfwPu7DiSldvDP9wkGfmp7eUvoCRLf6D+\
An83d8lRxMzlfHv0HcIeHze5T1pD6AP0HcN9VYW0RLeT+U/QfbP86OdPwd13iB9B/sJ8fFm/\
UaUDuH0X/Adx57qyC+CLiD9B/sP3bfUnxNxVrbnxEAs/6WTdgqGvGzR9RwOPX73r4w8yFmz8OAZ+\
kVp1WNJ5w9B+sPtihH1z21pabP2JYf5Pisnu2uyk3f8QCl71gkN4QSc4PRP/B6lf3shGZz4y5+\
eMoW18t+YqPo0h9gf4DuInbm7mFDw25+SMB+MWMM9ut9Jdx80ci8GPLUkUff1Hn9h9JrD/I+\
5SdeNCA238kD9ZvA1PCJ5DvB/0H8BfD/3jcbE/Op0X/\
AXxJ56Y6mQce3P4jBfjCQx1H10fu4NZXqcCv1Rw3yFUi53sMxscp4LeTJfZG3vTm1ldpLD9bhJV2TS\
X3/6L/AF6+6LDXrG8kP6P/AO7l2x884hT5++g/gJtv8XBZ9H0rt77KBL7u+s2gvCzy/aD/\
AD43JVdUZYsDt776F/CJoyp67+as49ZX2cAlpypaBh9cwY2Pc8BTjd8ctpeV4sbHn8B1b3SU+\
YrpcPNHLqt/fcZ8dXxlys0fecD3elp8v/yaxC/6D1Y/+tb43Nch7wdF/\
8HiUzbwxKEVttz8UQC8z2NkrdU3c27+KGT9V3OE+zt5A27+uAh8jkie/\
Uynxdz8UQRcriF0bqHhDG7+uAz8jajLWK2c/mW8+CgG/uiiyZwc1ync+PgL+\
GkPn6Y4UTVufFwBPtu273mGEIlf9B9s/5lTJ/lBaTk3Pq4Bn955dIuOuj43Pv5m+\
UV8dnjqKT1ufJSy+qNzdL+4O6k/0X+w9fEu6myAYDE3Pm4Af/qiOF9bQ5UbH+XA1Rp0te4+JueLo/\
8ALn++cImIUfev3y/6D+DPHnwrfB9N3p+D/oPVF/WKvY5m6tz8UQH8kG7QIiFfbW59dY/\
FT7F56NtmfW59dZ/l3+gNUj0GK7nx8W/gCvOn5jiLrODGRyXrzy+mvNTZSOIL/Qfr/\
7v8L9Tqa3Hjowr4ynMFh93i/uDGRzVb32s81SRnW3Dj4zHbn79e0j3RSfpb9B/Aq3LMPkWLk/\
MN0X8AdysKnhK9hDy/gf4D+DmjCe03Lmzj1le1jLvf7smV3sGtr+pY/nVxONaQTTj6D9b/eil/\
eaZC+nf0H8Ar49921wsIR/8BXCLpjGLfLcIH46OR9QeyCXGy+YSj/wB+vFzY+jcrwtF/\
sP50u1GDUxX5/9F/sPXpNdIvZSbh6D+Aj1ka+MX8Cvn+0H+w+nqn4+z0G+T7R/\
8B3LPRz1pusxs3Pt4BjxRJMtzQvZkbH62s/7tl7m9x3YUbHx+A26d/bjhd78yNjzbgeW/\
2qOppkvsL0X8An29xP1axhDy/g/6D1e/b2otCckl+QP8BfEdBkHP3YpIf0H8Ar+m+\
Nspvrg03PjpZfa+7u/JeiBU3PrpYfFebvXs4xZIbH93L2ftZg8oF3eT5IvQfLL7CpHTa+0h+\
Qv8BPGXkPxoGFAlH/8HW79D1+786mXHjo4/Vd/3Kux2PEr+A/gP4T7mImoYTJD+j/\
2D9VWeWlkyACTc+BoDrD/VOXe1qrPUf6IZgSA==",
     SelectWithContents->True,
     Selectable->False], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.551608151882104*^9, 3.551608165518792*^9}, {
   3.551608207595106*^9, 3.5516082080964727`*^9}, {3.5517553746008997`*^9, 
   3.551755376733405*^9}, 3.551771965743866*^9, {3.551772073923181*^9, 
   3.551772074281142*^9}, {3.551772121429042*^9, 3.551772184086084*^9}, {
   3.552029663698885*^9, 3.552029672790202*^9}, {3.552030296927742*^9, 
   3.552030308266099*^9}, {3.552033600767323*^9, 3.552033615436562*^9}, {
   3.552033982802248*^9, 3.552033984370804*^9}, {3.577175468360276*^9, 
   3.577175511239974*^9}, 3.577177340619754*^9, {3.577177414205421*^9, 
   3.57717742142934*^9}, {3.577177471693286*^9, 3.577177472098276*^9}, 
   3.94776062089117*^9, {3.9477608862437983`*^9, 3.9477609996206217`*^9}, 
   3.947761056672229*^9, 3.947761097040501*^9, {3.951885480352862*^9, 
   3.9518854832296677`*^9}, 3.951885521422985*^9},
 CellLabel->"In[452]:=",
 $CellContext`InitializationGroup -> 
 True,ExpressionUUID->"0e69e9bb-3f25-407d-8d99-ab3bb64977f3"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"pllist3", "=", 
   RowBox[{"animateSDOFresponse", "[", 
    RowBox[{"acctrace2D", ",", "dtsamp", ",", "20", ",", 
     RowBox[{"amplifymotionSDOFresponse", "\[Rule]", "Automatic"}], ",", 
     RowBox[{"foscSDOFresponse", "\[Rule]", ".5"}], ",", 
     RowBox[{"imagesizeSDOFresponse", "\[Rule]", "iSize"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"i", "=", "1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"c4s1Figure3", "=", 
  RowBox[{"Manipulate", "[", 
   RowBox[{
    RowBox[{"Show", "[", 
     RowBox[{
      RowBox[{"pllist3", "[", 
       RowBox[{"[", "i", "]"}], "]"}], ",", 
      RowBox[{"ImageSize", "\[Rule]", " ", "iSize"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"i", ",", "1", ",", "\"\<Time\>\""}], "}"}], ",", "1", ",", 
      RowBox[{"Length", "[", "pllist3", "]"}], ",", "1"}], "}"}], ",", 
    RowBox[{"SaveDefinitions", "\[Rule]", " ", "True"}]}], "]"}]}]}], "Input",\

 CellChangeTimes->{
  3.947761100386962*^9, {3.9477612178023376`*^9, 3.947761272621972*^9}, 
   3.9477613050232677`*^9, {3.9477613426407213`*^9, 3.947761355814521*^9}, {
   3.947761395737571*^9, 3.947761421847115*^9}, {3.947761457285321*^9, 
   3.947761514898693*^9}, {3.947761550993279*^9, 3.947761653622703*^9}, {
   3.951884700531157*^9, 3.951884704586317*^9}, {3.951885506548834*^9, 
   3.951885510907916*^9}},
 CellLabel->"In[454]:=",
 $CellContext`InitializationGroup -> 
 True,ExpressionUUID->"98649cdb-2232-4fe0-a8de-fdec5565c189"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`i$$ = 1, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`i$$], 1, "Time"}, 1, 200, 1, ControlType -> 
      Manipulator}}, Typeset`size$$ = {
    350., {172.134033203125, 177.865966796875}}, Typeset`update$$ = 0, 
    Typeset`initDone$$, Typeset`skipInitDone$$ = False, 
    Typeset`keyframeActionsQ$$ = False, Typeset`keyframeList$$ = {}}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`i$$ = 1}, 
      "ControllerVariables" :> {}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$, Typeset`keyframeActionsQ$$, 
        Typeset`keyframeList$$}, "Body" :> Show[
        Part[$CellContext`pllist3, $CellContext`i$$], 
        ImageSize -> $CellContext`iSize], 
      "Specifications" :> {{{$CellContext`i$$, 1, "Time"}, 1, 200, 1}}, 
      "Options" :> {}, "DefaultOptions" :> {}],
     ImageSizeCache->{399.1, {219.80445861816406`, 225.53639221191406`}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    Initialization:>({$CellContext`pllist3 = {
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 1, 
               0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               1, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               1, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 1], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 1], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 1], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[1], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 21, 
               0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               21, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               21, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 21], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 21], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 21], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[21], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 41, 
               0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               41, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               41, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 41], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 41], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 41], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[41], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 61, 
               0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               61, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               61, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 61], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 61], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 61], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[61], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 81, 
               0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               81, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               81, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 81], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 81], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 81], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[81], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 101, 
               0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               101, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               101, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 101], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 101], 0, -0.5}}, 0.4]]}, {
           
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 101], 0, -1.}}, 0.05]]}, {
           
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[101], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 121, 
               0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               121, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               121, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 121], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 121], 0, -0.5}}, 0.4]]}, {
           
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 121], 0, -1.}}, 0.05]]}, {
           
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[121], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 141, 
               0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               141, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               141, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 141], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 141], 0, -0.5}}, 0.4]]}, {
           
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 141], 0, -1.}}, 0.05]]}, {
           
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[141], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 161, 
               0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               161, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               161, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 161], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 161], 0, -0.5}}, 0.4]]}, {
           
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 161], 0, -1.}}, 0.05]]}, {
           
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[161], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 181, 
               0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               181, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               181, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 181], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 181], 0, -0.5}}, 0.4]]}, {
           
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 181], 0, -1.}}, 0.05]]}, {
           
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[181], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 201, 
               0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               201, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               201, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 201], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 201], 0, -0.5}}, 0.4]]}, {
           
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 201], 0, -1.}}, 0.05]]}, {
           
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[201], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 221, 
               0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               221, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               221, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 221], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 221], 0, -0.5}}, 0.4]]}, {
           
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 221], 0, -1.}}, 0.05]]}, {
           
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[221], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 241, 
               0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               241, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               241, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 241], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 241], 0, -0.5}}, 0.4]]}, {
           
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 241], 0, -1.}}, 0.05]]}, {
           
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[241], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 261, 
               0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               261, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               261, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 261], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 261], 0, -0.5}}, 0.4]]}, {
           
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 261], 0, -1.}}, 0.05]]}, {
           
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[261], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 281, 
               0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               281, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               281, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 281], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 281], 0, -0.5}}, 0.4]]}, {
           
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 281], 0, -1.}}, 0.05]]}, {
           
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[281], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 301, 
               0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               301, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               301, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 301], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 301], 0, -0.5}}, 0.4]]}, {
           
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 301], 0, -1.}}, 0.05]]}, {
           
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[301], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 321, 
               0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               321, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               321, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 321], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 321], 0, -0.5}}, 0.4]]}, {
           
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 321], 0, -1.}}, 0.05]]}, {
           
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[321], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 341, 
               0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               341, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               341, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 341], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 341], 0, -0.5}}, 0.4]]}, {
           
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 341], 0, -1.}}, 0.05]]}, {
           
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[341], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 361, 
               0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               361, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               361, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 361], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 361], 0, -0.5}}, 0.4]]}, {
           
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 361], 0, -1.}}, 0.05]]}, {
           
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[361], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 381, 
               0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               381, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               381, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 381], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 381], 0, -0.5}}, 0.4]]}, {
           
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 381], 0, -1.}}, 0.05]]}, {
           
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[381], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 401, 
               0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               401, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               401, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 401], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 401], 0, -0.5}}, 0.4]]}, {
           
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 401], 0, -1.}}, 0.05]]}, {
           
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[401], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 421, 
               0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               421, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               421, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 421], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 421], 0, -0.5}}, 0.4]]}, {
           
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 421], 0, -1.}}, 0.05]]}, {
           
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[421], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 441, 
               0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               441, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               441, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 441], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 441], 0, -0.5}}, 0.4]]}, {
           
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 441], 0, -1.}}, 0.05]]}, {
           
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[441], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 461, 
               0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               461, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               461, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 461], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 461], 0, -0.5}}, 0.4]]}, {
           
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 461], 0, -1.}}, 0.05]]}, {
           
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[461], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 481, 
               0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               481, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               481, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 481], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 481], 0, -0.5}}, 0.4]]}, {
           
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 481], 0, -1.}}, 0.05]]}, {
           
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[481], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 501, 
               0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               501, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               501, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 501], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 501], 0, -0.5}}, 0.4]]}, {
           
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 501], 0, -1.}}, 0.05]]}, {
           
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[501], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 521, 
               0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               521, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               521, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 521], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 521], 0, -0.5}}, 0.4]]}, {
           
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 521], 0, -1.}}, 0.05]]}, {
           
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[521], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 541, 
               0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               541, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               541, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 541], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 541], 0, -0.5}}, 0.4]]}, {
           
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 541], 0, -1.}}, 0.05]]}, {
           
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[541], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 561, 
               0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               561, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               561, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 561], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 561], 0, -0.5}}, 0.4]]}, {
           
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 561], 0, -1.}}, 0.05]]}, {
           
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[561], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 581, 
               0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               581, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               581, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 581], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 581], 0, -0.5}}, 0.4]]}, {
           
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 581], 0, -1.}}, 0.05]]}, {
           
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[581], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 601, 
               0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               601, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               601, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 601], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 601], 0, -0.5}}, 0.4]]}, {
           
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 601], 0, -1.}}, 0.05]]}, {
           
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[601], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 621, 
               0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               621, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               621, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 621], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 621], 0, -0.5}}, 0.4]]}, {
           
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 621], 0, -1.}}, 0.05]]}, {
           
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[621], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 641, 
               0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               641, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               641, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 641], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 641], 0, -0.5}}, 0.4]]}, {
           
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 641], 0, -1.}}, 0.05]]}, {
           
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[641], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 661, 
               0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               661, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               661, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 661], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 661], 0, -0.5}}, 0.4]]}, {
           
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 661], 0, -1.}}, 0.05]]}, {
           
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[661], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 681, 
               0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               681, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               681, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 681], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 681], 0, -0.5}}, 0.4]]}, {
           
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 681], 0, -1.}}, 0.05]]}, {
           
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[681], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 701, 
               0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               701, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               701, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 701], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 701], 0, -0.5}}, 0.4]]}, {
           
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 701], 0, -1.}}, 0.05]]}, {
           
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[701], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 721, 
               0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               721, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               721, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 721], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 721], 0, -0.5}}, 0.4]]}, {
           
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 721], 0, -1.}}, 0.05]]}, {
           
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[721], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 741, 
               0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               741, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               741, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 741], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 741], 0, -0.5}}, 0.4]]}, {
           
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 741], 0, -1.}}, 0.05]]}, {
           
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[741], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 761, 
               0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               761, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               761, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 761], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 761], 0, -0.5}}, 0.4]]}, {
           
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 761], 0, -1.}}, 0.05]]}, {
           
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[761], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 781, 
               0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               781, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               781, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 781], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 781], 0, -0.5}}, 0.4]]}, {
           
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 781], 0, -1.}}, 0.05]]}, {
           
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[781], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 801, 
               0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               801, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               801, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 801], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 801], 0, -0.5}}, 0.4]]}, {
           
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 801], 0, -1.}}, 0.05]]}, {
           
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[801], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 821, 
               0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               821, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               821, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 821], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 821], 0, -0.5}}, 0.4]]}, {
           
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 821], 0, -1.}}, 0.05]]}, {
           
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[821], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 841, 
               0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               841, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               841, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 841], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 841], 0, -0.5}}, 0.4]]}, {
           
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 841], 0, -1.}}, 0.05]]}, {
           
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[841], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 861, 
               0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               861, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               861, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 861], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 861], 0, -0.5}}, 0.4]]}, {
           
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 861], 0, -1.}}, 0.05]]}, {
           
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[861], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 881, 
               0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               881, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               881, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 881], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 881], 0, -0.5}}, 0.4]]}, {
           
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 881], 0, -1.}}, 0.05]]}, {
           
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[881], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 901, 
               0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               901, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               901, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 901], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 901], 0, -0.5}}, 0.4]]}, {
           
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 901], 0, -1.}}, 0.05]]}, {
           
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[901], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 921, 
               0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               921, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               921, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 921], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 921], 0, -0.5}}, 0.4]]}, {
           
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 921], 0, -1.}}, 0.05]]}, {
           
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[921], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 941, 
               0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               941, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               941, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 941], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 941], 0, -0.5}}, 0.4]]}, {
           
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 941], 0, -1.}}, 0.05]]}, {
           
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[941], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 961, 
               0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               961, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               961, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 961], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 961], 0, -0.5}}, 0.4]]}, {
           
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 961], 0, -1.}}, 0.05]]}, {
           
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[961], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 981, 
               0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               981, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               981, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 981], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 981], 0, -0.5}}, 0.4]]}, {
           
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 981], 0, -1.}}, 0.05]]}, {
           
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[981], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 1001,
                0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               1001, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               1001, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 1001], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 1001], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 1001], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[1001], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 1021,
                0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               1021, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               1021, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 1021], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 1021], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 1021], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[1021], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 1041,
                0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               1041, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               1041, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 1041], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 1041], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 1041], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[1041], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 1061,
                0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               1061, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               1061, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 1061], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 1061], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 1061], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[1061], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 1081,
                0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               1081, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               1081, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 1081], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 1081], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 1081], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[1081], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 1101,
                0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               1101, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               1101, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 1101], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 1101], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 1101], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[1101], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 1121,
                0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               1121, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               1121, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 1121], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 1121], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 1121], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[1121], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 1141,
                0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               1141, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               1141, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 1141], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 1141], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 1141], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[1141], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 1161,
                0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               1161, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               1161, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 1161], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 1161], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 1161], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[1161], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 1181,
                0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               1181, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               1181, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 1181], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 1181], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 1181], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[1181], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 1201,
                0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               1201, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               1201, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 1201], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 1201], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 1201], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[1201], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 1221,
                0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               1221, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               1221, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 1221], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 1221], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 1221], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[1221], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 1241,
                0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               1241, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               1241, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 1241], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 1241], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 1241], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[1241], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 1261,
                0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               1261, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               1261, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 1261], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 1261], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 1261], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[1261], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 1281,
                0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               1281, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               1281, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 1281], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 1281], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 1281], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[1281], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 1301,
                0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               1301, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               1301, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 1301], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 1301], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 1301], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[1301], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 1321,
                0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               1321, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               1321, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 1321], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 1321], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 1321], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[1321], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 1341,
                0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               1341, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               1341, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 1341], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 1341], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 1341], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[1341], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 1361,
                0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               1361, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               1361, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 1361], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 1361], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 1361], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[1361], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 1381,
                0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               1381, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               1381, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 1381], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 1381], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 1381], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[1381], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 1401,
                0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               1401, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               1401, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 1401], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 1401], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 1401], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[1401], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 1421,
                0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               1421, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               1421, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 1421], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 1421], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 1421], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[1421], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 1441,
                0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               1441, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               1441, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 1441], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 1441], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 1441], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[1441], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 1461,
                0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               1461, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               1461, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 1461], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 1461], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 1461], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[1461], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 1481,
                0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               1481, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               1481, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 1481], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 1481], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 1481], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[1481], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 1501,
                0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               1501, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               1501, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 1501], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 1501], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 1501], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[1501], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 1521,
                0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               1521, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               1521, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 1521], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 1521], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 1521], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[1521], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 1541,
                0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               1541, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               1541, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 1541], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 1541], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 1541], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[1541], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 1561,
                0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               1561, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               1561, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 1561], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 1561], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 1561], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[1561], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 1581,
                0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               1581, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               1581, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 1581], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 1581], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 1581], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[1581], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 1601,
                0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               1601, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               1601, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 1601], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 1601], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 1601], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[1601], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 1621,
                0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               1621, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               1621, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 1621], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 1621], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 1621], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[1621], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 1641,
                0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               1641, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               1641, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 1641], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 1641], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 1641], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[1641], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 1661,
                0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               1661, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               1661, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 1661], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 1661], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 1661], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[1661], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 1681,
                0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               1681, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               1681, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 1681], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 1681], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 1681], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[1681], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 1701,
                0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               1701, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               1701, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 1701], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 1701], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 1701], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[1701], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 1721,
                0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               1721, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               1721, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 1721], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 1721], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 1721], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[1721], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 1741,
                0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               1741, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               1741, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 1741], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 1741], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 1741], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[1741], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 1761,
                0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               1761, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               1761, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 1761], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 1761], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 1761], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[1761], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 1781,
                0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               1781, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               1781, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 1781], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 1781], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 1781], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[1781], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 1801,
                0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               1801, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               1801, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 1801], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 1801], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 1801], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[1801], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 1821,
                0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               1821, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               1821, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 1821], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 1821], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 1821], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[1821], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 1841,
                0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               1841, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               1841, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 1841], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 1841], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 1841], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[1841], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 1861,
                0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               1861, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               1861, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 1861], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 1861], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 1861], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[1861], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 1881,
                0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               1881, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               1881, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 1881], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 1881], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 1881], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[1881], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 1901,
                0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               1901, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               1901, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 1901], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 1901], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 1901], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[1901], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 1921,
                0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               1921, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               1921, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 1921], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 1921], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 1921], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[1921], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 1941,
                0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               1941, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               1941, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 1941], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 1941], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 1941], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[1941], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 1961,
                0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               1961, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               1961, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 1961], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 1961], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 1961], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[1961], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 1981,
                0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               1981, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               1981, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 1981], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 1981], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 1981], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[1981], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 2001,
                0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               2001, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               2001, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 2001], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 2001], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 2001], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[2001], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 2021,
                0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               2021, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               2021, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 2021], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 2021], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 2021], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[2021], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 2041,
                0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               2041, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               2041, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 2041], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 2041], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 2041], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[2041], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 2061,
                0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               2061, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               2061, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 2061], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 2061], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 2061], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[2061], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 2081,
                0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               2081, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               2081, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 2081], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 2081], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 2081], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[2081], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 2101,
                0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               2101, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               2101, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 2101], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 2101], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 2101], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[2101], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 2121,
                0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               2121, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               2121, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 2121], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 2121], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 2121], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[2121], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 2141,
                0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               2141, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               2141, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 2141], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 2141], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 2141], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[2141], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 2161,
                0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               2161, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               2161, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 2161], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 2161], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 2161], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[2161], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 2181,
                0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               2181, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               2181, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 2181], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 2181], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 2181], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[2181], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 2201,
                0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               2201, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               2201, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 2201], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 2201], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 2201], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[2201], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 2221,
                0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               2221, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               2221, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 2221], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 2221], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 2221], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[2221], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 2241,
                0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               2241, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               2241, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 2241], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 2241], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 2241], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[2241], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 2261,
                0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               2261, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               2261, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 2261], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 2261], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 2261], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[2261], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 2281,
                0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               2281, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               2281, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 2281], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 2281], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 2281], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[2281], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 2301,
                0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               2301, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               2301, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 2301], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 2301], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 2301], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[2301], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 2321,
                0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               2321, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               2321, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 2321], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 2321], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 2321], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[2321], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 2341,
                0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               2341, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               2341, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 2341], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 2341], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 2341], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[2341], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 2361,
                0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               2361, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               2361, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 2361], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 2361], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 2361], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[2361], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 2381,
                0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               2381, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               2381, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 2381], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 2381], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 2381], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[2381], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 2401,
                0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               2401, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               2401, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 2401], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 2401], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 2401], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[2401], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 2421,
                0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               2421, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               2421, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 2421], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 2421], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 2421], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[2421], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 2441,
                0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               2441, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               2441, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 2441], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 2441], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 2441], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[2441], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 2461,
                0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               2461, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               2461, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 2461], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 2461], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 2461], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[2461], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 2481,
                0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               2481, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               2481, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 2481], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 2481], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 2481], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[2481], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 2501,
                0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               2501, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               2501, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 2501], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 2501], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 2501], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[2501], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 2521,
                0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               2521, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               2521, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 2521], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 2521], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 2521], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[2521], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 2541,
                0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               2541, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               2541, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 2541], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 2541], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 2541], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[2541], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 2561,
                0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               2561, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               2561, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 2561], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 2561], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 2561], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[2561], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 2581,
                0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               2581, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               2581, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 2581], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 2581], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 2581], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[2581], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 2601,
                0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               2601, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               2601, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 2601], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 2601], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 2601], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[2601], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 2621,
                0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               2621, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               2621, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 2621], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 2621], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 2621], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[2621], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 2641,
                0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               2641, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               2641, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 2641], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 2641], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 2641], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[2641], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 2661,
                0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               2661, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               2661, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 2661], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 2661], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 2661], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[2661], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 2681,
                0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               2681, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               2681, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 2681], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 2681], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 2681], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[2681], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 2701,
                0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               2701, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               2701, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 2701], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 2701], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 2701], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[2701], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 2721,
                0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               2721, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               2721, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 2721], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 2721], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 2721], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[2721], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 2741,
                0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               2741, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               2741, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 2741], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 2741], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 2741], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[2741], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 2761,
                0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               2761, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               2761, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 2761], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 2761], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 2761], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[2761], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 2781,
                0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               2781, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               2781, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 2781], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 2781], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 2781], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[2781], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 2801,
                0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               2801, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               2801, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 2801], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 2801], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 2801], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[2801], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 2821,
                0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               2821, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               2821, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 2821], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 2821], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 2821], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[2821], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 2841,
                0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               2841, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               2841, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 2841], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 2841], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 2841], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[2841], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 2861,
                0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               2861, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               2861, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 2861], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 2861], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 2861], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[2861], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 2881,
                0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               2881, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               2881, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 2881], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 2881], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 2881], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[2881], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 2901,
                0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               2901, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               2901, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 2901], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 2901], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 2901], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[2901], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 2921,
                0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               2921, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               2921, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 2921], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 2921], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 2921], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[2921], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 2941,
                0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               2941, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               2941, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 2941], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 2941], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 2941], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[2941], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 2961,
                0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               2961, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               2961, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 2961], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 2961], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 2961], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[2961], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 2981,
                0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               2981, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               2981, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 2981], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 2981], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 2981], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[2981], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 3001,
                0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               3001, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               3001, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 3001], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 3001], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 3001], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[3001], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 3021,
                0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               3021, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               3021, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 3021], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 3021], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 3021], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[3021], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 3041,
                0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               3041, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               3041, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 3041], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 3041], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 3041], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[3041], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 3061,
                0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               3061, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               3061, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 3061], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 3061], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 3061], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[3061], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 3081,
                0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               3081, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               3081, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 3081], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 3081], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 3081], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[3081], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 3101,
                0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               3101, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               3101, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 3101], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 3101], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 3101], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[3101], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 3121,
                0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               3121, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               3121, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 3121], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 3121], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 3121], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[3121], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 3141,
                0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               3141, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               3141, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 3141], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 3141], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 3141], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[3141], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 3161,
                0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               3161, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               3161, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 3161], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 3161], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 3161], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[3161], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 3181,
                0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               3181, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               3181, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 3181], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 3181], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 3181], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[3181], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 3201,
                0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               3201, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               3201, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 3201], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 3201], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 3201], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[3201], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 3221,
                0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               3221, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               3221, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 3221], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 3221], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 3221], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[3221], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 3241,
                0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               3241, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               3241, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 3241], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 3241], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 3241], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[3241], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 3261,
                0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               3261, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               3261, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 3261], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 3261], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 3261], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[3261], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 3281,
                0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               3281, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               3281, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 3281], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 3281], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 3281], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[3281], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 3301,
                0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               3301, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               3301, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 3301], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 3301], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 3301], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[3301], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 3321,
                0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               3321, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               3321, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 3321], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 3321], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 3321], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[3321], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 3341,
                0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               3341, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               3341, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 3341], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 3341], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 3341], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[3341], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 3361,
                0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               3361, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               3361, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 3361], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 3361], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 3361], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[3361], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 3381,
                0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               3381, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               3381, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 3381], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 3381], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 3381], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[3381], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 3401,
                0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               3401, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               3401, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 3401], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 3401], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 3401], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[3401], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 3421,
                0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               3421, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               3421, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 3421], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 3421], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 3421], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[3421], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 3441,
                0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               3441, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               3441, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 3441], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 3441], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 3441], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[3441], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 3461,
                0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               3461, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               3461, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 3461], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 3461], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 3461], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[3461], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 3481,
                0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               3481, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               3481, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 3481], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 3481], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 3481], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[3481], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 3501,
                0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               3501, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               3501, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 3501], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 3501], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 3501], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[3501], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 3521,
                0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               3521, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               3521, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 3521], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 3521], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 3521], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[3521], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 3541,
                0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               3541, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               3541, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 3541], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 3541], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 3541], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[3541], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 3561,
                0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               3561, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               3561, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 3561], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 3561], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 3561], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[3561], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 3581,
                0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               3581, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               3581, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 3581], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 3581], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 3581], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[3581], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 3601,
                0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               3601, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               3601, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 3601], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 3601], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 3601], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[3601], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 3621,
                0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               3621, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               3621, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 3621], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 3621], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 3621], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[3621], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 3641,
                0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               3641, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               3641, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 3641], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 3641], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 3641], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[3641], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 3661,
                0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               3661, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               3661, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 3661], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 3661], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 3661], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[3661], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 3681,
                0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               3681, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               3681, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 3681], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 3681], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 3681], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[3681], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 3701,
                0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               3701, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               3701, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 3701], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 3701], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 3701], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[3701], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 3721,
                0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               3721, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               3721, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 3721], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 3721], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 3721], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[3721], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 3741,
                0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               3741, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               3741, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 3741], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 3741], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 3741], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[3741], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 3761,
                0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               3761, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               3761, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 3761], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 3761], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 3761], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[3761], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 3781,
                0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               3781, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               3781, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 3781], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 3781], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 3781], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[3781], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 3801,
                0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               3801, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               3801, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 3801], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 3801], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 3801], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[3801], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 3821,
                0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               3821, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               3821, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 3821], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 3821], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 3821], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[3821], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 3841,
                0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               3841, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               3841, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 3841], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 3841], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 3841], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[3841], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 3861,
                0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               3861, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               3861, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 3861], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 3861], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 3861], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[3861], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 3881,
                0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               3881, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               3881, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 3881], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 3881], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 3881], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[3881], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 3901,
                0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               3901, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               3901, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 3901], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 3901], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 3901], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[3901], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 3921,
                0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               3921, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               3921, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 3921], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 3921], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 3921], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[3921], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 3941,
                0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               3941, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               3941, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 3941], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 3941], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 3941], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[3941], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 3961,
                0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               3961, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               3961, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 3961], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 3961], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 3961], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[3961], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}], 
         Graphics3D[{{
            GrayLevel[0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`inptrace3D$65018, 3981,
                0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1, 0, 0], 
            Thickness[Large], 
            Dynamic[
             Line[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               3981, 0.01, $CellContext`timeiv$65018]]]}, {
            RGBColor[1., 0.8431372549019608, 0], 
            Dynamic[
             Sphere[
              $CellContext`recenterintval[$CellContext`buildingresp3D$65018, 
               3981, 0.01, 0.], $CellContext`spheresize$65018]]}, {
            RGBColor[
            0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
            Dynamic[
             Cylinder[{{
                Part[$CellContext`inptrace1D$65018, 3981], 0, -2}, {
                Part[$CellContext`inptrace1D$65018, 3981], 0, -0.5}}, 0.4]]}, {
            RGBColor[0, 0.39215686274509803`, 0], 
            Dynamic[
             
             Cylinder[{{$CellContext`posdamper$65018, 
                0, -1}, {$CellContext`posdamper$65018/2, 0, -1.}}, 0.4]]}, {
            RGBColor[0, 1., 0.4980392156862745], 
            Dynamic[
             Cylinder[{{$CellContext`posdamper$65018/2, 0, -1}, {
                Part[$CellContext`inptrace1D$65018, 3981], 0, -1.}}, 0.05]]}, {
            RGBColor[
            0.6901960784313725, 0.7686274509803921, 0.8705882352941177], 
            Specularity[
             GrayLevel[1], 20], 
            Dynamic[
             MapThread[Cylinder, {
               $CellContext`swayingCylinder$65018[3981], 
               Table[0.07, {$CellContext`height$65018}]}]]}}, ImageSize -> 
          350, Boxed -> False, PlotRange -> {{-2, 2}, {-2, 20}, {-8, 6}}, 
          PlotRangePadding -> {{2, 2}, 2, {2, 2}}, Lighting -> "Neutral", 
          ViewAngle -> 0.2, ViewPoint -> {2., -3.1986514670399693`, 1.}, 
          ViewVertical -> {0., 0., 2.}]}, $CellContext`recenterintval[
         Pattern[$CellContext`dat3D, 
          Blank[]], 
         Pattern[$CellContext`k, 
          Blank[]], 
         Pattern[$CellContext`dt, 
          Blank[]], 
         Pattern[$CellContext`ivsec, 
          Blank[]]] := 
       Module[{$CellContext`iv, $CellContext`x, $CellContext`time, \
$CellContext`z}, If[$CellContext`ivsec > 0, $CellContext`iv = {
             Max[
              
              Round[$CellContext`k - 
               0.1 ($CellContext`ivsec/$CellContext`dt)], 1], 
             Min[
              
              Round[$CellContext`k + 
               0.9 ($CellContext`ivsec/$CellContext`dt)], 
              
              Length[$CellContext`dat3D]]}, $CellContext`iv = \
{$CellContext`k}; Null]; {$CellContext`x, $CellContext`time, $CellContext`z} = 
          Transpose[
            Take[$CellContext`dat3D, $CellContext`iv]]; 
         Transpose[{$CellContext`x, $CellContext`time - ($CellContext`k - 
             1) $CellContext`dt, $CellContext`z}]], $CellContext`dt = 
       0.005, $CellContext`time = CompressedData["
1:eJwt1MmKY1UAx+HTU3V1d3V1zfOUmucpNe0qD5CVu2yFjksXeYE8QF7g+AAB
13flLuBKOIIgCAEXinJQFGlNq622A+X97qKKOue7P/6EUJV333/n5b0Qwuu7
H54P4t3z4W35+6Pbi+rd87G/P7kt1WfOP799r3n3fOG+f/tpunu+5L5y/jX/
jftvvZe577jvuR+4H7mfuFfOX/E/u//FewPuNfea+5X7jfude8O94f7g/uT+
4t5yb7m/uX+4f7lQK89DrfSh9v919V6tfO9erWT3ufvc/VrZecA94B5yD7mH
3CPuETfEDXFD3GPuMTfMDXPD3BPuCfeUe8o95Z5xz7gRboQb4Z5zz7lRbpQb
5V5wL7gxn9cYP+Z+zHtj3Dg3zo1z49w4N8FNcBPcBDfBTdozyU1yk9wkN8VN
cVPcFDfFTXPT3DQ3zU1zM9wMN8PNcDPcLDfLzXKz3Cw3x81xc9wcN8fNc/Pc
PDfPzXML3AK3wC1wC9wit8gtcovcIrfELXFL3BK3xC1zy9wyt8wtcyvcCrfC
rXAr3Cq3yq1yq9wqt1aez6/53qyV9/U1762Vrs1FruASl7lQ0avoVfQqehU9
LnIFl7jMhXW9db11vXW9dT0ucgWXuMyFDb0Nn8+G3obehh4XuYJLXObCpt6m
3qbept6mHhe5gktc5sKW3pbelt6W3pYeF7mCS1zmwrbett623rbeth4XuYJL
XObCjt6O3o7ejt6OHhe5gktc5sKu3q7ert6u3q4eF7mCS1zmwp7ent6e3p7e
nh4XuYJLXObCvt6+3r7evt6+Hhe5gktc5sKB3oHegd6B3oEeF7mCS1zmwqHe
od6h3qHeoR4XuYJLXObCkd6R3pHekd6RHhe5gktc5sKx3rHesd6x3rEeF7mC
S1zmwoneid6J3oneiR4XuYJLXObCaXk+cqp7Wt5vn/p/c1q6GlfnGlyTa3Ft
rsNFrssVXI9LXJ/L3IALZ/ad2Xdm35l9Z/Zxda7BNbkW1+Y6XOS6XMH1uMT1
ucwNuHBu37l95/ad23duH1fnGlyTa3FtrsNFrssVXI9LXJ/L3IALVfuq9lXt
q/r+VO3j6lyDa3Itrs11uMh1uYLrcYnrc5kbcOHCvgv7Luy7sO/CPq7ONbgm
1+LaXIeLXJcruB6XuD6XuQEXLu27tO/Svkv7Lu3j6lyDa3Itrs11uMh1uYLr
cYnrc5kbcOHKviv7ruy7su/KPq7ONbgm1+LaXIeLXJcruB6XuD6XuQEXru27
tu/avmv7ru3j6lyDa3Itrs11uMh1uYLrcYnrc5kbcOHGvhv7buy7se/GPq7O
Nbgm1+LaXIeLXJcruB6XuD6XucFN7T/4YKr+
        "], 
       Attributes[$CellContext`inptrace3D$65018] = {
        Temporary}, $CellContext`inptrace3D$65018 = CompressedData["
1:eJxU3XdcTv3/B3ArySqEBiUpUYhQWWWTSFZWyQgpSSiyEimESkMoTQ1FQ3vv
vffepaJESlY/3/t6n+t1/fxzPzxvj7quc17ndT7X53zOdcROXNijM2rEiBFu
vCNGjP73X72ArfbGi0YnjPj/fxKlHnfJTxYVTbjO/25rk+k9JcYTZkVf7c9d
QG7P9rxj4h/VtWQSIkUsutUjXdl+60vEjh5hKfr3Xmy3Wz7ljctUoYQXzv/7
48f2dQNVsZsjRymxfs47trsE6uQbFcgofVL/3/8JZntlcvwkcfu1Sqyf/4Ht
R1Ptbl5o36o0vsLTcO34CLYranaNb9morsT6vVFsX9Rn1C9xSENpwdGnyd+l
Ytnuk9i0zXyFFr2eeLZ7h5zPb/t0Qsnr30+v8Exku8Dtn3ct556h15nE9hur
Gyf1Ruspyf33J4Xtv2S2RxcdNqTXn8r28sObexR5LimlfJf694rS2D63yOim
18cr9L4y2D7xbPvKnz+uKu3574Vmst3wr7LspFU36P1msX3fbA/9V29vKzWZ
/u8XZ7P92vOqecFv7tB2yGV7X0KOlOPTu0oX//d2DfPYfr1y45lrNha0ffLZ
3nRjnru+nyX9vZDtEyKbBa2rH9B2g7s1DJsMiVsrbfvvBRWxffLXqNFNFk9o
e8LFj4ZNVjSzUfrfqzz6tJjt0tJ6X5qzbGk7l7CdR/L+sy7RZ0r/bbYK+IW3
Tke3mNvT9i9lu/z0bQ59XxyURP/3tkTK2C7ybUzTZz0n2i/w4BsrD6379lzp
zOn//Sln+4eln0Ia77+g/VWB1x8950Sa5Cul//1W/nfwEO3hpMxiF9qPlWxP
PMg9Lfzha6WB//3a7/Bqb9Pxsj5utH+r2D5i4O3a9ifuSuv++8XVbH+l4tru
ecOD9jv8x6Whw16Gnkr/vV2LGrbvtEyfOE/Pi/JQy3b7kbZvD+l7K+Xl/u8P
XGv8pi1Gl99QTurYbjvgKnL5ro/S9P/ecD3bK0ZN9RF09qX8wJ/NsDas/OCn
9N+vPdqAPD8Oez2x3J/+3ojt8/l+vtDvt7Td4KMt8icYSwZS3uDDVVv4ova9
o+0JP3NmxtXB++8ph01sbywMtPquFUTbGX5nNtev/X+CKJ/wTXqqS0a/Dqbt
34x+kMjN+LExhHIL/7PvSnZ7dwjtF/jxjuOd1o6hlOcWtodeePOob+MH2l/w
xNnxTzX7P1DO4dbHhnat8A2j/djK9sIYxyPFx8Ip//BUbzUXE+EI2r8c/z58
U+vumgg6LtrYruwt/f7w60ja73B5HuX6LWei6HiBt97d+fbVsmjKQzvbjb0b
v48bGUPHETzR6ETzg+IYygl8zuO5/Ht8Yun46mC7hqfuT5vbcZQf+Bb1o4P7
j8TTcQc/PcLtkO2qBPr7R7Z3zrgdbTk5kXIFvxBbICh/J5FyBX8kL7GG/3si
5QpecuXIn3LdJMpVJ/pTVkZDviGJcgVfdaX3a8e+ZMoVPE19zuhn2cmUqy62
J2eNyOtWSlGy+S9X8E93P8qnfUihXMF1+wuv8i1IpVx1s1018K1a/KtUyhXc
pG+5pzNvGuUK/uFrx/O1d9IoV59wvBTUrF7Ql0a5gpt5HjvQrJVOuYJPOfH7
jER2OuXqM9u7fhtrc8llUK44vPR0ZalzBuUKrpEhY9r7N4Ny1cP27OvzLjud
yKRcwW/oLm4bTM2kXMFXDi3Zv0Yyi3LVy/acJzqnXO5nUa7guhE/Fmxsz6Jc
we/G8A1P3cycX7+w3W/trK8+Htm03eA5viPWXfybTXmDC549+ThTI4e2J3z+
082mY97lUA7hSl8vLnk6Ipe2M3zFA8eczl25lE94TcV87efPc2n792Gctv7m
lyl1uZRb+KvR3NdrhPNov8AD5PlNkvflUZ7hJjvkhj5a5tH+gj/Z9MXEOSyP
cg43PRR6b3F9Hu3Hr2zfVTAiZ8GofMo/fGKMZ//Kufm0f+FvKjQffFqXT30L
f6WcutnuYD7td7j/wND1yxfy6XiB3/YcfS/5Xj7l4RvyP7Q2bNTLfDqO4ENV
iaecw/IpJ/Bt9h+yGyry6fiCy+U6NY0eU0D5gdcWuEhIryqg4w4+buztwOKr
BfT3frZnzRE1EYkvoFzBN1TxP9UZU0i5gtueXpciJFNIuYIHTRvb17m/kHIF
//ojfLXWnULKFTyn2CAkP7CQcgX3tvFfa15dSLn6jn9fa3E5f2wR5Qoepjzc
MntZEeUKrm7/0b/5SBHlCh418HyG1d0iyhVcYn3qofO+RZQr+LVMiX0NWUWU
qwGM635naU/qKKJcwUvrZW25h4soV3Ce4QSrXL5iyhX85IPNEYeEiylX8Nk1
408Gzy6mXMFnBetfK51RTLkaZPvWhHK3OK5iyhV8TqllumtnEeUKPv+Q9xKd
5CLKFbxS/N6GdpsiyhV8De+bSYYHiihX8FNnR91W5mfG2T/YzmUW5qacU0i5
gu88kqNee53JFdzs2VyJXgkmV/Axi3lnjbEroFzBtV7Y372WlU+5gs9/WqG4
82se5QqefuRLk+ikPMrVEMaNc0QTnwkxfQX3XT6/318oh3IFT8vP+qQzMZty
BS94eNxrRE8m5Qq+JHNG1dO4DMoVXP537a9719IpVz/Z/s1d65bN3DTKFVzh
07qidQkplCv4wPOcP3+OJtN5HC6cGiYfPTGJcgWf7KRtNi8mgXIFvykiYHzm
fRzl6hfGOZNtDaK+x1Cu4N2ycmZJ96IpV/BJ/wa7gvujKFfwExfzOyJ1IilX
cPvkvsjbURGUK/hj1ZlSL/cwn8N/I283JCfMko2gXMGvHGnKWqQWQbmCb8nd
7FsWGEG5gi+5GaOvoBpJuYILun1c/lE6inIFV9r8/b3PrmjKFXzDhfNGiWEx
lKs/GM/4OFX+PB5HuYIP2PPMFtibQLmC79wa93VbSiLlCq7VYzo/6FcS5Qq+
3VP+Z4BaCuUKPj6lKH5fbCrl6i/br3KVygkrpVOu4Dkf44Kel2VQruCFZRaR
q25mUa7gD45s3ftrWQ7lCv55rrT6om+5lCv4UQfRPw5RzHlwmO0Grf4RbcqF
lCu4qGl8TYI401fwojv63JtHF1Ou4LmflwydrCumXMEFq9REh9+XUK7gasNK
d9uvsj+3KzN+0T5MuHpFGW03+FvXAjeb1jLKG1xgTN+IBPNy2p5wo599prMm
V1AO4Ure23pP3KtQ+m8zn4bzjxozfkdLBeUTfkXc9Px9qUo6X8C5dlRxJ/z7
nM/KLXzOiG/cEUcrab/Ak/paLay2VlKe4RvcnJrD+Sppf8FXjZmxpz+8gnIO
/2gTpFOrUEH7cSTb7c+KRny1L6f8w1cFt3Ztzy6j/Qt3MInZY1JVSscFXMWt
tiw0tYT2O7xg6uNEo6fFdLzAVY1Mh5PXMecveOjeDTtFIwvoOII7/fU+vLMv
l3LC8XNyr/Id2ptNxxc8WO3vN5sfGZQf+E5pZV2/hjQ67uA/7vs3Hx9k5ulG
sf2M/5ICLdlkyhU8oeEm1wmLRMoVXOLzA6PwL3GUK/h12yDbRzNiKFfwotil
p3hNIun4hR+9OJenaDTzOR2+99SlsXH+oZQruPQ470Sho8GUK3jUVttrTkLv
KFdw1a63Y9oM/ChXcHF7Z2cLXy/KFbxllmn2iQvMfBR8oFbq18qpDpSr0Wx/
Jf6hf8ece5QreO6J40ot3UcSWLmCiwnbHaj+a53AyhX8qp7QvN/7XiWwcgXv
+BbVnxLincDKFTxBj197QntgAitX8OW7JuxS2h1K88/wKd6Pd7W9i0hg5Qoe
miTI9Sg0JoGVKziv6nSHZImEBFau4F6ho1VlxiYlsHIFH7ngXPiF7ckJrL+O
Ybuus6buJsOUBFau4PHvrbS0zVMTWLmCv6x/ZZV2Ky2BlSu4Tv55nl8n0xNY
uYJ/Va92eroiI4GVK/j0kTaKhr8zaH4e7sGT0W2VkpnAyhV8Wo51colNVgIr
V/BLo7QULmhm0/w/vN/5xES+6TkJrFzB/VbKhhx3y0lg5YpjO9Ru80n9mpPA
yhXcLlD4Qcfk3ARWrrjYfnZV3+fjwzkJrFzBJcTTQotycyhX8JHndPnjruVQ
ruCXVnEnuY7JoVzB39sudZ2on025gvdIG3JvDs6iXMHlosX1plVmUq7gWk42
g3JtGZQruJmitGFdbTrlCv7HY/v7DclplCt4wXz55G6nVMoVfLFIyiwN7RTK
1Vi2a3oPyhwSSaZcwWt0/fJmliVSruC3T2lues+bQLmCr+IzHulyKZZyBffR
TjqqUBtFuYJntGYONeyKoFzBDz56lv4x9wPlCi7wyWX+7d0hlCu4/ZG7CVte
vadcwXdxX978yMifcgVXOZg6I3CyN+UKHu8l+C4n3pVyBS+Te7TQP9COcsXN
9pUvbn+OMzWhXMGbEudHhVneovMgfOexGoMzUQ50HoRndzql+0t60HkQrrs2
O1fN24/Og3DLwis3Y3yD6DwIn79U3cjN9gOdB+HfbHb7DFky43B4v8/WR4P3
Yuk8CL90ie+ajXIinQc53tcj+T1Oq5j5Rrjm720GyxYx16XGsT3ZSeTFkunM
5x34o2Iz0229GXQehH95Putab2QWnQfhi3PiZty+lEPnQXjfQfWmLsk8Og/C
uZ/Ov/K5Pp/Og3BemWbZVPVCGt/CR6h4XRNZVUTnQbjaSOsARQnmczpcxv1w
iwNvCZ0H4YY3k/tXDpbQeRD+wG7o/Z2aUjoPwp/eevNCLLaMzoM8bHe+8FNu
7nNmfAWfFJs3L/F8BeUKfv6SbUrWqkrKFfxlyaI8gT+VlCsOP31kdEFIFeUK
/rPhzsvth6spV3D+TA35+r5qyhW8y9HxtczVGsoV/PrL6vchPTWUK3jp1z8d
fUdqKVfwDT0tf2IzailX8Gk3Z6ePX8FcHxrP9rIV/FwFbnWUK/gP13Znb656
yhXc1nxo8N6xesoVvFldQT0voJ5yBW99b5Qk/rmecgWXWf1uZo1oA+UKnlIQ
ly+zsYFyBT+y9uBPg30NlCv4kkxrY6fdDZQr+HyfKx57VjRQruC1jtxPZo9t
oFzB79pZ+wgX11Ou4DMTb4R/DKynXE1g++pS7qVvvOopV/D5I4y/+oXUU67g
4xcIOvPk1VOu4DNGXVz1vauecgXfE+IQqc7TQLmCjyhsSfKUaqBcwb/r/52v
sL2BcgX3q1KrSTnbQLni+L0rbzbMuttAuYI/7RC11HdqoFzBQ/d6eIUGNlCu
4KPPTsjULmGuF05k+/1qmVdPxzVSruAHR9Rf5pdrpFzB31nMKhQ/3Ui5gv9q
Xaf0y7WRcgVXeX5vqnttI+UKfvJZpJi+aBPlCl5pPzcj70wT5Qqetq+6wCys
iXIFv/pKzuIGdzPlCu625t3AyaPNlCv4finpa4MhzZQruH/fyg/rxrdQruCT
JORXdxxvoVxNYvsuhZ6e/ugWyhVccJTiA5WZrZQreOKEYZ7RV1spV/C/m5Me
BNS2Uq7gx+cF/xzY2Ea5gqse/Z0XHtBGuYI7xNz5dGhGO+UKvmPY/EWcWTvl
Cl5/3y4vvbudcgWPz03h4dfooFzBBUaL6fYmdVCu4Pfb7y++Is1cz5vM9hDV
pN+pdh8pV/CmK/c+CQx+pFzBn2bLzszT6KRcwXtfe815/aGTcgWf5LT73MTJ
XZQr+EpTx6sbdLooV/DLSybZesZ0Ua7gPsMl109P7aZcwW9zTVU2OddNuYLP
Hl70Z11qN+UKvsHjxRhN0U+UK3iwnn54seknyhX81PJNA1ZlnyhXvGzf2TD2
15vFnylX8HVSfS+sLT5TruA6D9Njnao+U67g8m8jTfsW9FCu4Hqfrvo/uNJD
uYKPXfP698qYHsoVPC90hWPFUA/lCq4QYqmmJdtLuYLLqjc6Zmv2Uq7g5ye4
Kc6800u5gnck6YpGOfdSruCxtkJ6zb7M9UI+bE+nX3FTQnppu8HPFTWKxkb1
Ut7gh7pvbqxN7qXtCY8Pr1lolddLOYSPsGv0Lajope0M1y073fCmoZfyCW8+
vkRqUWsvbX+4R4Cz4uT2XsotfN61+ulSHb20X+Dv5WPsrnb20rwZPPr3z76a
z720v+AJL9+UeX/rpZzDQ88+qz4y1Ev7Ec7ltmN16J9emg+Bp/n1TBse7qX9
y7Ed/vvzhY4L+DCPsojpH2a/w9cnr1f4MthLxwu8NVVC0b2HyQP8pInFTv/G
XjqO4Aduf5VekMfkBK74JSBwZ2gvHV9wJZPvHw/aMfmBL5G9UWSr20vHHXy2
yv6LigpMrqawXXzb1NH3//RQruC5K1pfuUf2UK7gH38+t3l3todyBXcSDz3W
ObGHcgV3zXRtafFijl94c8H4JU6ynylXcMs6aXeZoE+UK3hK8sPNceKfKFfw
2xPevdn7qJtyBZ/MHWCn0MH0JNyv1+HmQoUuyhV84kTTrO7bnZQr+AiVAk2+
lI+UK3jDYNDvgXEfKVfwbeLPU479O4+wcgU/9WyWfeS7dsoV/LmGj8qpCcx5
Cp7+Ys/gXt02yhVcU7B0rl56K+UK/tKt98Jy8VbKFTx60G+xiXkL5Qr+YvWi
F5UdzHgAbizIu0L/QDPlCr5Vv+zL+sImyhX8zA2+Q90HmHVOU9mu6zSkWNnd
SLmCT5ycWxf/lBl3wYXkMzpHbGikXMFnbU4S4R3JjMfg6os2L3/k2EC5gn8w
OvIsYV0D5QoumqumnvSDGd/CLV/ZOFomM58L4CPfq6bfc2bGvXCXOVlKj02Z
zwvwp9sHDw4dr6dcwd9PelzUuqOecgVv6znbaLK8nnIFN9DMWjZRoJ5yBT/a
HSAm/K2OcgXn/zHVc0ZyHeUKfuzNuKn77tRRruDmC4aWjVpUR7mCfw2essQj
uZZyBU9epms5tKmWcgVPfxw3+UdcDeUKzn27zzNIsYZyBa9bv19BMr6acgVv
nCAy02ZbNeUK/uvIngNRRcz6xWlsF7SUNffYW0W5greoLN6TklNJuYIfCr5x
K0exknIFN41XTt3qUkG5gluaOBev7S+nXMGde00WbVzNXA+CPzr9V1nfoIxy
BRcO+Gsz52Ep5Qr+/KQp3+FHzHUQuJCk+8itF4opV/Cx77x2Jssx6x/g6dPu
ZD+KKKBcwd1u2m7M7cylXMFPhi6t0JbKplzBv8ae7PnzLINyBed5PaX1/bI0
yhX8gVelMfdAMuUKPkF14S/lvETKFXzmU/kDPcfjKFfwx+bdmVmbmeuw8G7H
xpwpu8IoV/DT/VLVo24EU67g0g4t/KUv3lKu4NGvF650dfKiXMF7nd9sWqHy
inLFz/Yef6dRtb9tKFfw2KwND8Vyb1Ku4G5C+UnGq5VoPhBuumFRjt35GzSP
Ch+z0Oy33soHNP8Mb3u0MMJnoi3Nr8J5t/x4cfyCPc1Lw6V8M15YZjnSvCs8
/1eC8velz2m+Gh5c9qJvee5zmo+FfwsudnoU/5zmseHCs07fjFz4nOZp4dVe
bvzrFjnR/DY8p22qrm+1A83fwnuf7GlYv8Se5r3h6suszE1H2NG8LnyU0czW
Z1Oe0Hw4XC6+xXHVzPs03wtPO7zLfkepCc2Tw08H//yx74Y45Qp+/cua9689
blCu4AvWP2wJGnpMuYKv7HmwffdrJ8oVXDnNQmaahRvlCr61UmpzwTNvytV0
tl8WWLvBvNOfcgU/Nk7I3UkhiHIFT9P9muw6IZT6Cp7SZLvap5VZrwu3+CD9
wD8ukvoKfqjieelLjxjqK/ijiPwB3sh46is490Bo4U2+JOoruMJM5TGOfcnU
V3BdxZ98p76nUl/Bz13dw3eLl1mfCefvyvQ/r5BFfQW/oWfbr2yQQ30Fd9Zc
P7s1KI/6Cs5jqPDd8S9z/Re+K8nNX3cBM68Ld7pg/ubdXmb9APzVjDi3QdMS
6iv4uK4TZY6vSqmv4Nt9xhtuDS+jXMEFda8v504vp1zBrSp0d/tmV1Cu4CWj
fkSXpFZSruBbtzUb/Q6volzBMzyL/Bd7MevyZ7A9SPTsa/6nNZQreMiFpibv
a7WUK45/r3y/OexUHeUKLifE53BejZlHhb8/NXNkuDwzvoL/PrFR028SMw8G
3z44fGvbjUbKFdwu/mu4QAczPwZvWZh/9/rOJsoVPOyXPY//uybKFTza8FBJ
ME8z5QouJO4w7almM+UKXlL0MXOLXzPlCr76r1hGb3cz5Qq+UfVCz9t5LZQr
+L6uuS+c97RQruA7HrQeG3mlhXIFH6W6cjW3dQvlCh6RbjxHybmFcgWfEGwt
qvK6hXIFH/w65Nrsxozb4Y/lc1qW/3NWruDD4nHpd11bKFdwUYtC3a8vmfk9
uMztzZ35Tsz9ADPZXhHzPWyLLTPvBzfesdakybKFcgXXnbFE0vQ6Mx8Idxbm
uT9Vv4VyBd9k9Dyz71AL5Qo+T3Pd78rNLZQruNzZjJxW2RbKFfyv45x962a1
UK7guybySeaMa6FcwU0/LLtVP9BMuYJrTQrNXdbO5Apu+G3HpT3lTK44Xuct
qc3TM5hcwUvfP+lNjWRyBV+wurCh8W0z5QoubL9tT7pbM+UK7ic518vIqZly
Bf/s/TDK/Ckz3wvPKh438oJVM+UKbn7mjE7SHWYeGF6nPmI97/VmyhWc67r8
+6JLzOdB+NC2bZX79JjPg3AZrsh32drNlCv41L5Zfsf3MverCLB9xvmzd65v
aKZcwYNNZ1+fu7iZcgVv/inpvH5mM+UKft/eQn7TcBPlCn5v9fjEJx1NlCv4
Codg7QNFTZQr+ORHA5sexzVRruBV/ZMnnQ9oolzBTxwqkV7qwvQVXPMjV73F
E6avOH7+wgu3JW83Ua7gbR83x8sZMPP/8E21iVevHmmiXMH7Ii5vdN3KXBeA
+5ZY726Ta6JcwV+GnavWFmOuF3Bs/yPnIjfwNVGu4ErlD7KKhhspV/B1e/q1
R/Y2Uq7giuVG97jqGilXcC6117ymWY2UK/iHqdVuiz80Uq7gQ1J8Ak2vGilX
8P5faXWCdxspVxz7pf7yyiOnmfuyBNleM3DiU8QWZp4BPjNVYvV8CWaeAf5j
gZrS2NHMPAPcfvQ18ZLkBsoVXPSdal34HeY8CF8voJITvoGZZ4B71+hfGx7T
QLmCH+IpGL6RwcwzwN86r+U/+ICZZ4A/OubeOE2FmWeAm45PcXXhYeYZ4MZ1
5pJGmXWUK3ijzLym25Z1lCv4ai0Vw9CtdZQr+MnnjRUmPMw8A9y6OqXyfm4t
5QouX7wiZYVNLeUKPjYi/2X33lrKFVzr+JL1B2cy8wzw4JF2PFrVNZQr+Pay
s+frXjHzDHDuqonVr7WYeQZ4puJUEV/RGsoVvP7i8JngRmaeAc5lcd9f3pMZ
XwnBP4z/Mlq3mnIFv6Q3Z0WoXDXlCv6j1u/JsjHVlCu4x+gbtrLVVZQruJdu
yCmVD1WUK/jCidoDArZVlCv4xwkJl8YaVlGu4J2/PB1Wq1dRruDWzpdOjV1R
RbmCnyozfKQtXEW54ng9R44ubxnNrBOAH7NZXD7wuZJyBdfyEGpJr6ykXMFD
xxRt+JtcSbmCJy9fYa34tpJyBTdTTtTYZMusd4U36fR0OBlXUq44fr7rcKK6
JrMOluP1HOzIctpSSbmCFwvOuTKwlFkfCx/7fv0ueZFKyhX8u5+z1fPxzLpZ
ju1vGjN282AF5Qp+h794xI9WZj0t/HlkbdGJUuY+XmH46h1meWnMOlv49g19
PL8iKyhX8LtmtQ1bAisoV3Czy9OFe9yZ+Ss43zr7zaqOzLoR+NUtq+PKH1RQ
ruCFL8Xu9F6voFzBV586tz5Hj1nnDI8sWzHx9sEKyhXcUXLeizHrKyhXcIfH
HwaGxSsoVxw/R3+5oPVwOeUKnit6z+xuUTnlCn7aUWtH4vNyyhU8TD7wftiB
csoVfN4fRcUrvOWUK3jj+0OfuDPLKFfwFWs0F+rdK6NcwYVdkvWHNpdRruCP
8gSk1CYwnwfhtjJjQtuLSilX8D22eX7FTqWUK/hlhVGh64+WUq7gpx5Jfv8h
wqwjgq/15Hkw1MDcrz6L7ZWfVmU1vC6hXMFdZKsnz9UuoVzBm6Zu8X87t4Ry
BZdxXHT6SGcx5Qo+4kh7ZEYYc/8RfFDPT63JqphyBZ86rXHSyRPFlCt4duvz
b43KxZQreEJp8aync4spV3Cn3JqWHi5mXhT+e49/cWcnMy8Kt/8z5Y5jXhHl
Cr7l/Mt27iBmPTmcW2xJ4yqbIsoVPKrwWBT/eeb+Mo6fX+KvcGkzM88Av5G8
cLKzAHNfFfyVvxBff3sh5Qqu/dC9ZF9IIeUKLsCd4rb6JnM/HTzshWHx3+2F
lCv466yulDlChZQruOvvb88e1RRQruB/616GvrMsoFzBC1XP3J6xkrl/cDbb
3ZY/CmtvY+7vgPMtDbl+9Hk+5QrOrZF/57JaPuUK3ug64CU5MZ9yBe9ec1by
aV4e5Qqu7mzadcc2j3IFL+riXha9P49yBf/oWir4QiCPcsXhE4fVJKtyKVfw
T6u/xDo45lKu4FsWcdV/VMulXMEldd45ZI3OpVzBV/NqJPwOYuav4PZ+D7cd
1sihXMHrM+f77/rB3F8G//1i6Uplx2zKFZwrgi/qpVw25Qpeu8dOpqEoi3IF
33niaI6xYRblCm57qXPNxYlZlCv4mhXnegLcMylX8FuHq7S3yWRSruC+Hu/0
LP2Y+93ghqP2qLcKZFCu4AJyMjsKbqRTrkTY7r7yUMGHqjTKFTxVTjGmUS6N
cgWXyTB6VfQ4lXIFv2w0bjrXxxTKFbzD4NxY2Q0plCt47Aaru0avmPvlOX6v
mhjXjEHmfny4iHT99BB1Zl4U7uhlvcrwbSLlCn73ate74NGJlCv4z4E23qjQ
eMoVfL5lsfLzQ3GUK7iHXFXq1e8xlCv4856sdPW70ZQruG1BzVrV4UjKFbys
RkJxQCeCcgUPvpzrPeZDGOUKnmSTb/CmPZRyBa/b6x/W8zuYcgVfOL3oj1Df
e8oV/Ixtg7tO1FvKFfzcMr1Tnw76UK7gKXwfqoaKPShXcGmF5w9vbX9FueLI
j8eOGFErO8qVKNtjdi4slHhgRrmCawu51loWnaJ173DjWUdTXkhY03Uc+G3R
p2L2I17QdRz4gjKeOU+FPek6Dry/ScCzfLcfXceBT9XPOjrR7T1dx4HzmkVW
9o0Kpes4cKlbUppfFcPpOg7cesnnndJ6zLp6+KWpMsUmT2PpOg5c4guvnoxX
Al3Hgf/U+NB9bV8SXceBz17UlG2Xn5zAyhW88oC1ialSKl3HgR/rLEsTe5NG
13HghneUAhJHMvc1wO/fSTD4rJ6ZEPVfruBb7JbefeKYRddx4HOTg2cUFWTT
en745jeVnfV/cug+CPjVQTHXr3PyaJ0/vH72NRGrVfl0fwS8UenGKv9dBbT+
n2N7KhkHFS0tpPsm5rB9QsW2B1sSClnbjQsu9izyl6NaEd0vAF+w7/jd7w1F
rOtivPCZf4K5g/SLKYdwgfUqEwq+FrO2syC87/uyuDrDEson/JbjviNKHSWs
7S8OvzZh59dgjVLKLfzj+lF8fSmlrP2yGP5998YmH5kyyjPcfmrHv/NvGeu6
mwL8c//BgM99ZZRzeOqCsK7wneWs/bgB/kVv9QlR73LKP1zV6aGv+49y1v5V
ha+S1Tznt62Cjgv4rFAXaSOHCtZ+14CvjeEt422ooOMFfuKt9beHEpWsPByH
Z6XZuLSfrUxgrTeD1/fv8ePyq2TlRA9+/pdItEdbJR1f8Cm1M8VOi1Sx8nMF
vntx5QievVV03MGr/1xJt71bxcqVGdzXpeCKWVAVHY9wtTEKFoHVVaxcPYQn
np65enhUNV1vhXvfr1PZtbCalSt7+KTFQhl31Kvp+IUnNN/08LhWzcqVK7yn
d/W7cs9qOq458ukoZ7qlqJqVK1+O12k1dLByVA0d7/ADxteOfFGoYeUqFL5t
mniW5aUaup4LF7Yyd7kTUsPKVRx8utQH8fbvNdQP8KGCAz8b19aycpUBvym9
KPLZw1rqDfjloqK1/TW1rFwVwe3GB/QWL62jPoEv86rx//6ojpWrWo79eKvV
SqqrjnoGLurWe1xKtZ6Vq3a43ItP+28F11P/wI9wO4fcFmxg5eoLvHDts7s2
dxuolzjylnWs7k5vAytXP+E27ru7Sxc3Ul+JsV2pYM4PtTON1Fdwu4m5Z665
N1JfwY2WblM0q2ukvoK3egTOMRVqor6Cmzxw9Bff30R9BT8bVjQk86CJ+gqe
bRsZmxnaRH0F3yi1yudsaRP1FXzDuscJzd1N1Fdw5YDPr3f+aqK+gjty7U3b
MLqZ+gquq+l+Jeefs/oKPmZEx9zU303UV/CbP2ft3dTTRH0FPxxvWpFW2UR9
Bb/+3TyKJ66J+orj54h9Tmp62UR9BW+aJqk4zriJ+gr+9nCN2gzVJuoreOBj
60MOIk103ocvWvv27LSeRuor+Akx/vPSMY3UV3BNi4gC8/uN1FdwacGUyKTd
jdRXcMnjyWX3hChXZvDdtsf7jmU2UF/BxSadm2h8pIH6Cq54kafH/HM99RX8
a6Kbhe3Neuor+OzevTlcE+qpr+BOXsrH+BzrqK/gj2wHm6pF66iv4EmuM+6J
+NdSX8HNd6yYcXVlLfUV3OrBH4OUNKavON6vtEKCvwbTV/BDFcbpv7uqqa84
ttv8sPPfblVTX8HnvLQ6r89fTX3FcbzEDtdXBVZRX8Eto9yXzNtVRX0Ff6bs
sTdisJL6iuN4cfsrdSigkvoK7pHnP+Rwns6DTXD9W2mpSmsrWblq5ziO5n7W
ez2bzoPd8IOyTz6dmULnwS8c27+Sr6dNqJL6Cj795EXTRQqV1FfwTmmPUB+t
SuqruWxfH/LLx+1WJfUVfOd9+2Vdjyupr+DiIxU+7fznrL6CP/D/3LLpXiX1
Ffz0cNrC3GuV1FfwkZpKMuGGldRX8D8RwzVPz1RSX8EfC9/2fnOokvoKrpG/
Yef29ZXUV/DrgRr9q4Qrqa/gF2zKF2t9rKC+gmsd846dGVBBfQWfFjrN+b5u
BfUV/GWnxsZUsQrqK7i+flG5bwkzvoJ/0xaWXnqznPoK3r0gYH397HLqK/ip
A0freyLKqK/gJkWr9PTUyqiv4HxLZ/4w+FhKfQW3OGyUpXe/lPoKvvPQs8/2
MqXUV/C8tfodF+tLqK/gG3mbAoXcSqiv4NvtY8e/uVJCfQUvGHcwJEi7hPoK
vi/Wnt9ds4T6Cv6QK3dP36kS6iu4rmp9z75/43BWX3G8HtNDs8/dKqG+gscq
LDB5a0vjdlf4s+Sz2jcCaNzuybHdHI6prs0vob6Cb7447865byXUV3AHviPb
/GaWUl/Bfx/lHvdIvpT6Ct6Qc21M7+5S6it47tqCjxonSqmv4Eu4446Lnyul
voI37bw99uDpUuor+C+ReVIT9pdSX8FDawSzc5aXUl/BW58Jd8zmKqW+gn+6
0i4gkVFCfQVvLoiRe36zhPoKnnLPZES+dAn1Fby+1U2ypLSY+gr+pGxa55Lr
xdRX8DFpO+JWiRVTX8Enh6/2upJVRH0lzvbIzCWu+cZF1FfwqLrGlDIZ5vMg
/MOXuLjU3kLqK/hv+dPGa1ILqa/gt6oKDy4MLKS+god9O2nI71NIfQVf0fps
nNw/Z/UVvMRFtSHIo5D6Ch6+Jfn1GMdC6it4z0B/h9e9QuoruPt9x66MS4XU
VxyvX8Ngh8LpQuoruNFuv6DII4XUV3CR/hn12XsKqa/gKZsc47xVCqmv4GN1
Aveu3lRIfQUX3h62T3VDIfUVfExC6j2nbYXUV/Ah/yvf/A4VUl/BucJvpI64
XEh9BQ8YnrrrrG0h9RXH9n/mMaPSr5D6Cl6l+nHWz4hC6iv4sG4M14TYQuor
OL+pmdj9aJpnMIOfa5ygvyyS5hks4ApO6xbI//v5rL6CL1SJmDscTrl6CjfM
u75gWjjlyh7+QPJSWlUo5cqZ49+nTTs2L5hy5Qpfe+fXtob3lCtPOPfQHc2r
IZQrX7iFT9VouRjK1Tv4Kc/piq9zKFehcO2F72Y8baVcRcINfG0OPxlbRH0F
X7wp68aOZUXUV3DNmXord5wtor6Ct4fqfFvsW0R9BRdbH9Nm96WI+gre3zvr
kbVSMfUV3GXNtu9jnhVTX8Fdt6i25n4spr6CK346xiWgxPQV/FposO1uB6av
4G5jP3QldJdQX8Hn+PPn9awvpb6CT+/Y3RXmUEp9BZfaFlvM31pKfTWP7buE
G+4oSZdRX8HPed08Plu/jPoK7uf4wy7Or4z6Cm6hmXvKrqOM+go+1PJ6taJU
OfUVfOHrq+U3zpdTX8FjW/9qZ0SWU19xvE4btRyV8RXUV/DPXnf1w45VUF/B
0zd4GmuEVVBfwc/ffqCYOK6S+go+d82a3qp/4zdWX8HPtE0eKehfSX0FPzWt
PaT4ZyX1FbxCPHhG/w4at6tyvE53mZD+lzRuV4crNE/4nP6xivoK/q2S1ztD
tpr6Ch5hvnObyKVq6it4ZnfMwbz31dRXcNuJRQbPO6qpr+DBA3u5nYVrqK/g
Kbd/CmSq1lBfwX88D/Auvl5DfQW/cuaZ6FG/GuoreFj/m36r8hrqK/jBwvij
Cly11FfwV7u3T4+Sr6W+gmdNPfzyqGEt9RU81eValHJwLfUV/L1Ww2fN37XU
VxzbOewBf9he5vMg3ErY5+jfyDrqK/jZ2ytF9GXqqa/g9gdV9XPf1lNfwflC
t0sul2ugvoJ/2Tj+mkp8A/UV/IXNnBHm8xqpr+BTTfU//jzTSH0F19U2MXXy
baS+gtvY8vs9aW+kvuJ0d+eBuTTPUAF39vaK8tCieYZauHz45MCRzjTP0MRx
XA+Wpf8soHmGdrib3pdNo0Y2U1/BN4Se9Hu3sJn6Ct5V8P2Jw85m6iv4gp0R
miF6zdRXcP0G7w2Cls3UVxJ4/b5W5jLuzdRX8JikPTGB0c3UV/Bi7vybsqXN
1FfwpQOxgUd6mqmv4Enc5+Z087RQX8F7Ms1KvOe3UF/BBUsl1Xdua6G+gmuv
G/t9v34L9RX8dW5+tNmzFuor+Okcf6XK2BbqK/jsCoE/Eh0t1Ffw79qqqpem
tFJfcfxe2X1FG1a3Ul/BjbrGPD53qpX6Cu6wICExwbqV+gpuPLP3RHtoK/UV
XFRyW7tBVSv1Fdx+X0eC+J9W6iv4rGMGGRKibdRX8AWTB4zcldqor+Abr3X+
Oa3VRn0Fj+sVHCwzbaO+gmcd55KbY99GfcW5v67Pe+rXRn0Fn/n+d6F9dBv1
FXzZeX27xPQ26iu4gHx3SkteG/UVXOFNtZdGYRv1FUc+Z1/7PZjfRn0Fz3n0
Njknu436Cm7o8GhXdGob9RVcad29WrO4Nuor+ODFlPSysDbqK3iu+Pd8w3dt
1Fdwd7umSwk+bdRXHMeF7oIuT/c26iu4TtyFKW9ftlFfweU3Xz9t7NBGfQXv
XvNybdeTNuor+M1VPNMErNqor+DCi2cu/GzWRn0FP3mnQy7xahv1Fcf+rTpX
Y23QRn3Fcbwoy/r3H6dcNcEnJl/KCtlLuWrneD1J040ENlOuuuFC8dI+R+Up
V1/gl860TN8jTbn6DjdbpRJtLUa5+gkfOuGg6yFEuRohyXY+jdNyW2ZSrrjg
ERmfZJcIUK7Gw8M37PscOJtyxQv33NdUJDefcsUPf2+T+Oy0HOVKED6lP8X1
rTLlSgQupXjc4cVOypU4/NDwjVzeQ5QrKXhzi8K3mScoV4vho3c7mSw4S7mS
g38wyxljqEe5UoDLrlqg5qpPuVoLv2iR9uGqPuVqA1z/gX6JjR7lait8KNNC
SPUc5UoVrlOXvZJXl3KlDg/Wlg8+dpZypQHP2HXmYMdZytVR+KeRmT46ekxf
wX+Hv7PWN2T6Cm7+xORBsQnTV/Br89uddM2YvoLfE5NJ1bdi+gre6Wfxd9MT
pq/gugEZPKNtmb6CTzdYukfJhukr+LaP/CeCHjF9BS+2/H15wl2mr+Am080i
lhkzfQVPer16lYoO01dwCcu2T867mb6CP5DzKNNTYPoK7vxy5ODo2UxfwTOt
xwYF/G2lvoILnTzGF1PXSn0FH1TvUb8X3Up9BR+3x6f5oAOdB+M48vlw+U1z
AzoPJsNTwwUmi2yh82AGRx64c3LKhOk8mAvf/3PppeqeFuor+JrG9eOV41uo
rziOO/G4edoPWqiv4Lvtu0Qa1Fqor+DppgGe26e0UF/BF04zPJ+Zy4yv4ApJ
0ufu3WHGV/ArpaE5GkuY8RV8sWj41Y7yJuoreEPjYmPJa03UV/PZrjFFTr1h
RhP1FfyvWtBO2yDm+iCc31VF/OEW5vog/M0q7wszQhqor+DLhye/TC+k6ziC
cO2cpct6O+k6jgh8cf/FROO/tdRXcD0LlWkbeek6jhT8/PzfRutm03XnxXDZ
JsXoWwuqqa/gQpoLy9VXVFFfwW2nmewU28B8HoRPrNZ4oKbOzLfD13WLpS48
xaxngM/UtFj043oZ9RX84dG430PONC+qDt83/947rYQS6it4sWrAKLnPNM9w
FP6Ei6v43DyaZzjOsf1nbL46qFNEfcWxHy8O7ikLYeav4O8yJrRyTWTmr+DB
f4v9PrfmU1/BBTWv1Xjn5VFfwVcqtQl0F+dSX8Gbp3aELvmeQ30F73Xs+P5n
eQ71Ffyb03hNoWfZ1Fdw36qTPif5sqmv4BvlQ3fHBmZRX8FjPj11O66fRX0F
D1TKDLy6i/l+WvjcobSv0zSyqK84ctL0daz7gyzqK/j+1hsNup1Z1FfwW36P
q55cY77nFu42Z7mQ7poc6iv4HPNg9XOyudRXcFE1qwvNqnnUV/DfWlqjne7m
U1/Bb286tEYzvYD6Cn6jJ2j3WwuaF62Ad3P1aWyXLKK+go+y/DjHLrmI+goe
/+2PzqyDxdRXcL+/JusutBVTX8GX1RibmJ1j5q84emP+lsHRH+k6zne4d8Px
rPlazPwVx3FRd3DoTQ4zfyXF9oBfAuP/LGLmr+BHgtSqT5kz81fwtwZZYjHp
Zaz1bLzwYokTzgt+MvNXcA2nzEqd2cz8FbxGYGwyzzJm/gr+wsao2kGRmb+C
C89s8hhcXk59BZ/TJlISMq+c+gqeVSfAs4+nnPoKHpZQ+cO7hVl/BRd91LxE
7QOz/orjfckNu2z71z+svoJvPHZcvUu+jPoK/idz09WbnXQdRxX+1clG7u1T
pq/g3CabbW8tpOs4GvDNeTrHZKNLqK/gEr1fVn1aR9dxjsN9TLLeBkdSrk7D
rZdY1p+YT7nSg0+OWGFX/bCI+opj+0hJbvjVzMy3w3cclLgfsYSZb4fLXrfa
vqE5n/qKIyd7hBeFquVRX8HXBv3qfP2W6Su4jtn4cY2/s2idJMfrdPmcE7Yj
k/oK/qD66rrRr9Opr+BLfvm2pw6lUl9x/Pwax2mLj6RQX8G/ZL59E5yURH0F
t5DiWT5vcSL1Fdz4x2MX7W1x1Fcc+zdvuugEtWjqK46cTD+bKmYYQX0Fz5By
k1nj+YH6Cm618a9wY0Mw9RV8u/o1l2yVd9RX8Ozla9cVf/elvoL/OrDyV2GJ
J/UV/H1feLlrmwv1FXxk4aZpwwH21Fdwd+sbgUvqLKmv4JUjy9zdTPSpr+CN
E4XKi2WMWOuxv8Cl1YuPzm+yovXG8CkfLW32ydBzIX/C9yQHps5If0nrkBdg
+18Xe/nUxZ21fpsLvkRhcvqHNd60Phl+53LzDIFQX9a6bl64/ZaledkDb2k9
PDzOjm+iA8971npvQbjXjpubpvwOonXycBfPR09nnAlhrQMXh+t3FHw+lx5K
6+fhDmJWcYIzaH34Yri44PT2s3vCaV09vFdWfov7jQjWunEF+KI33mv0XkbS
ent4wd97S/eG03MAN8AP/vrl4VoUTevw4UM/Dlzj6YlhrTNXhU/NuD4qaUIc
rc+HbzmudlZmUTxr/bkG/PyzZt+g/Qm0bh8+5d7np4s2JrLWpR+Hv4vPbH9Y
z6znh2+/yfdh+fUk1np1PbhOxp9d/jOTaZ0/PHiFsU9XSDIrV1fgu4eW/dFX
TaH1//DZah8nOLTS8ybM4Du3mSnL3GSexwcvTl96+6cA3U/xEJ4V6MjdE51G
9wvAJ6zZc+mqDn1ftz1c1uCUToog831QHPkc2z8przyDlStXuNxm3UBP50y6
vwCeulWqIV0ri5UrX3heAI++lDhzPwv8V2f0stGt2axchXK831lzK465Ms+j
gZtVn1O/rZbLylUcR672j1sU+T2X7lOAh4kbxljb0H1DGXCrvaKd4+cwz5mC
X9K/dE/eK5+VqyL4GTXb0x9nMc9fg886oBzY/6CAlatauFDGmCta3QV0vwPc
jvcKV8ScQlau2uFazypOBm8ppPsgOI5TYYnHPLqF1Fdw1S7z8SoPmOeswU2L
tSZz+9Lztn7CJ6s8cwlLZZ6zu5DtF3/HRKvUF1JfwcMWPRPL/VZIfQVv27h8
850xdN8cL3x2TeOOal7meWrwO4aN+Run0/10gnDXuQv+LOAvor6CB9w37JWY
SPfZicMnCcw+z/uHee4YXGq6+ISU9kLqK/iBjMytfpnMc4jgqyQj/Z3d6b48
BXhGNk+nkWEh9RW8/UaRqs9yul9vA3zC5mj1nzUF1FfwkSFpHXYKBdRX8E8r
hMSTzShX6vCsgXV2R6LzqK/gXPHXt2Z9Zu5fg+tf2mZWKUbPYzoOHzfK4P7t
QznUV3C7S8f9lB2yqa/gyh8SlfzLsqiv4OazjmhenZVFfQXv5tmlt0I/k/oK
/lWyvXRDBj1/2gy+xVrhYP3iDOoreHxC3Hsnj3TqK7jQaj5jzznp1Ffw6QZl
Owre0H1h9vC72VUmJnJp1Ffw4AMSVV1pdL+YK7xzh9tUe81U6iuO1796kkjy
IN1H5gsPire8q/MkhfoKfiNjoE5XmO4vC4WLnFBTdXVNpr6Ci8bJ8qiK0n1n
cfCdD173Nvkwz/+Cb9paMlJbie5Hy4DLHk5OE21LpL6Cv9d823rQjp5LWwTn
b57iIKvEPN8BPrxmRKp/Lp0Ha+FHFNSPLRzPPD+OI+cu5VNz5eKpr+BnB1f3
HlWJo76Cy6x/ePSGRiz1Fbx1uXmxwvkY6iuO91vtGbbDLZr6Cn7usu/2kyOj
qa+k2X7SoL/e2oGeQ8cF1xyTqHtlTxT1FXzpqITU4HlR1FfwVt6L6xx+RVJf
wWOHnk7cX0j30wnCHb8OB5d4RlJfwUPDL8g9u0rPmxOH998eCLTcHUl9BU/q
fzFdczE9p2MxPD/xm3nNdOb73ODWIvO2DIyPpL6Cr1lQZD/Ax4yv4H/H+KY+
WxBJfQXX+6plsnVfJPUVPEfifKrA00jqK7ikcPGhY5WR1FfwA5kCh+OWRFFf
wXn2Pvh69d9+YfUV/JSOiEr6uGjqK7ig6aRbr+9HU1/BrwZMUXEdH0N9BZep
16pVso2hvoJvvcstsEIwlvoK3uucdpTbI5b6Cn7l10le3QVx1Fdwk9qFZ+/7
x1FfwWfKdR34LRpPfQVXErMe32gRT30Fn5XisG9vVTz1Ffy6mmzeV/4E6iu4
b/jt3N2LEqiv4CvUFE+f+PfvWX3FkU/j97VlqfHUV/CaRdpf07Yzz7OGh3ma
XRyMiqO+gneE7zuvuCiO+gr+ObVopUx4LPUVfN3GOS4RJ5jnyMAvvr4/QXlt
LPUV3Exvso2oSiz1FTwqesdTnfux1Fdwi7DTrXbdsdRXcI/GoQuzLtPzu2vh
lzMPF2TMiqe+gncJNs1UaWH6Cj7coeV2MTWB+oojDwfe+77XTKS+gr9ML9r7
t5F5fjfcf7nC7Im6SdRX8KH9VvfWfEuivpJh++tZ95r9byZTX8Gtz9zu/Dw2
hfoKbhi0YofhY3p+Ny888IeQhNVk5vmP8KQzm07r3E+lvoI3NO3x4v7G3DcN
L5NVEA09SN/vKg7nDxoUf5XEPL8bLjtv5kNj+XTqK/hgnMSnqrh06iv41EUe
h0v2ZFBfwbe6z/C0/5ZBfQWXGYgfJ+5Gz1fdwPG+5lzWGTqcRX0FL+p+aVUu
kU19BZe2Ecp+Nsw8Lxu+q9fTMq41h/oKfk7wll9rITO+gucvHLY9GZ9HfQUf
/vNj4jdv5rnS8C8rnX6om9H3LejBD00547ZoHo3bDeE3tmb03bhJ4/Yr8FNj
XX5mZDPPyYX7Hlq+XmU8PYfXDN6ipJWUqMh8rwW8byDV65RGEfUVx/vqa/Bd
fJL5vgt4ytzXSs1aNG63h6/Xsfaes5P5HgyO11llPzQsS+N2V/iRBTskp05m
vh8D/vKky9fcDhq3+8K36I2+EJ9I4/Z3HNsnZuds3xc0bg/leJ1T/YI+GjPf
pwGfuyKzdcYBGrfHwd+5Tbt3XZ75ng34hnpzoQuChdRX8C7rU8l7+2ncngs3
ihRZphdUQH0FdzHnehR+ivk8yLHfj90TD5jMfB6Ec42MU/7xlnmeOPzY5l7f
12soV+3wVQYTn7umMs9Dh28zNxfmU6HnrX+Bm+wbMLAvYp7nznE8vln7cbUm
fX/FT7hfs8WysM851FeL2F6ZPJ8r3py+14ILPlZ+uExAOIf6Cu4pMjZnVlg2
9RXcIOrHRXW1bOor+Bd7tSU/P2ZRX8G3C+bkxplnUV/BKwykjnqIZFFfwSda
HmrlS8ikvoJnL7p/MV0nk/oKPknhRJz9tEzqK7iH/Kg9fFlMX8EPSOf8eGTJ
9BWc//qko3fUM6iv4NI3Z3mKLcygvuJ4v+Nceh7xZ1BfwZUuX7O/PDWD+gp+
Y+PcdZfm0vNJNeBWJRN5RylnUF9xbP8lwedKdTKor+BPUiwC9tswz/+Fb5D4
XSgWT9/joQe/Hz94PriH+f5eeKGNQ9/gnEzqK3iy2Q97mb3M50G45rB/sMPd
TOorOG9I3dSlwZnUV/Cg0U7rvWsyqa/gpzs0r6SNYp5TzOFPxieWSGRRX8G7
5X0tEjZQrpzhanVRdncPUK5c4b+jfLYUHaNceXLsl7yNQ4tOMPNX8ECd/BP5
OlnUV3D5IcGV5y9nUV/BV02RDdvvwHxPC5zv3FBOZxY9/y4OvkV13liTSczz
ajny8O1QybeD2dRX8N7ehys+vaHzYC58WuL0reH9dB4sgjdZTKsRWU/nwQrO
431S+6WHOdRX8IbtSpUBeTnUV/CZO4p0A7np+3Pa4Ufj8v0S5HOpr+BeY9vW
XNem79X5Au/7myix6j7TV/Dh0X4KswKZvoJve3boxebKXOqrxWwf/6fkQAhP
HvUV/NucX4rb1+dRX8H3j500cdGNPOoruHd2x/yssDzqK/jdneW5Pp151Ffw
4jUBSob8zPcdwZuEbLRfyeVTX8Hfp69QfLaJ+R4kjtcjsvPnrn/O+rXwwxJ9
msGy+dRX8H2/jl97PT6f+gq+cdN2C/Fy5nuT4EncRrduPs+jvoJfNWiZ6XSA
+T4luOBXo6pk/jzqK/hyg7LXBuW51FdwJ1HLHSYuudRX8O0r7mqdO8eMr+CX
E7NdDNcy81dw3qE3OU4zmO9lgj+YzCv1+HsO9RVce+JljdtVOdRXHO/LKfXD
mqQc6it4d92u2I1vc6iv4Gfmvzv72IHOg2bwYHub8ztvMt/vxJG3sOX+/cfo
PPgQLmLxLVVrLfO9T3BlN7cSK4Ec6it4QeCu5J/fme+Dgrc//hFRUZVNfQU3
+nFmklwG8z1R8CvzgqyUE7Opr+A5Dw9WtqQx8+3wxyUOcz6VM/PtHPvR8/PV
+1+yqa/g+oqbxF/w5lBfwZ86BUn6Ls2hvoJbqcodiN2XQ30F71w98VK9cQ71
Fbw5zrh8lSM997MILts6ddA5hOkreE9gTtaOfKav4C8O+bSd/8T0FdzlZez2
gklMX3Ec7y+5b5cvYfqKYz8etp22aBfTV/B1vX0DPaeYvoKrLsnytLjI9BXH
8Tv4tnWxEdNXS9i+WXtE5lEdek4HF5xvgU/GVJVc6iu44AXFC0Fzcqmv4AYj
N3Wkd1Gu+OESYcoj5P1zqK/g9tl8B59p51BfwX86Hox9NzmH+goeemrOr++h
lCspuCzfYUP1XZSrxXCxH2cM/lTTeVAOPiQn1WmokaX03/f/KMCD/e8EFyZl
Ul/Bcx8X7h0WZD4PwmunPX6ifJIZX8EfSPaNn+2VTn0Fv6QRoSjVmkZ9Bd9k
fOas/4I06iv4E8EQ3w9XU6mv4JqGrlUjS1Oor+Bq3+c0r1qXQn0FP292zfVA
FD0/Vw8+QiX/eMwm5vogXGXj0uAJdUnUV3DbHef/9N2keQZTeN3JKVt+itM8
gxl8gegbPbG8ROor+JiaaZNEriZSX8FXnj2kfVQ8kfoKrqXVrLP9RQL1FVw/
u+bnra546iv4YoVfQr9Xx1NfwXutjI6+c4yjvoK7nspKTxoVR30FP3Lc5WfO
/VjqK7jAt8Nnt0nGUl/Bm1YLO/9uiGHlKhIuHfWpyP8dPf8iDr5u3L75U6xj
qK/gWVMDROQvxVBfwc9d5vr1SpuuO+fClW1VvATUY6iv4PML7m2MVo6hvoIv
HJlZKiEdQ30FLzp+eXLrpBjqK46cdN4Z3thF86LtcH8HnffGqdHUV3Cbizkf
F7tHU1/BnYJ15druRlNfweV3xeYaGjDz7Rw5NxK+pXiCmW+XZfv0MyNOKPzz
/7bbKLhqpP9I7kvR1GPw1MTQQV0nuo7PDW9f+uJaeW409RvHz3FfcnvpRNrO
E+Ey5bFP1HfGsL5XnxeefEXusMsD2v5T4EYa+Z/uxsZQH8IPzbIc2t5M+2Um
/KW48/nYgRjqSfiXyg+mS7/T/poF3zS4/qp5VQz1J/xcrUj5dTfaj2Jw0cUr
V3dsjaFehS+4ZiPTVBDNeu6hJLxsJbeJwZpo6lu48eASjbf2Uaz9Lg1/GDqh
W6aJuY4Af5xfKNcgE8nKgyz82b3mZ6X3I6if4Re0T3qvGxHByskK+GVLwRMl
XuE0zoR/r3tyf+HlcFZ+VsEd5q9aOf5UOPU5/MyxKc2vz4azcqUM36AnmKpk
Gk49Dx8149UvC4dwVq42ww34BHRFIsOp/zk84VtEQ104K1cq8MS+nUum/Htf
rPMC3OfLqNxrMyJYuVKDZ6/8qjJVKILOF3DLmoReI54IVq72wfe/lf5q0RVO
5xG47aYFttPTwlm5OgQf+8n7yrGX4XR+4ciPxqux3v+2z3+50uLYj4mF8+wk
wum8A79xwOOtfV4YK1cnObZnmKKi7vEwep4mx89Xe1Ni0/aBlauz8M6CUdIF
Wh/oPAVfNGOEWFBBKCtXBhzHS+i7JlmFUDp/wa/z1E8b7xTCytUluPutztJ1
3cF0XoOvEU5WE1kRzMrVVfilbYJPW42D6HwHH3ov6pio+56Vq5sc27PT56tE
ZyCdBzn2V9kY3vvGAaxcmXPk/LllhI3QWzo/wv3XGo5qrvVj5coSbua4bZRd
ii+dN+H80cc+7yrwYeXKGv73vLncyqE39BwQ+Nk4qw7plW9YubKF36m0O/Hs
ujedZ+F2zQ7GK5K8WLlygld1NA/OH+FF51+4i1PjgPwyT1auXnFsnxXcKZoH
POi8DB/XddjhqLE7K1fu8OOz6y7VeLrR+RquYr3uUVjNa1au3nD0vKX3m6hQ
VzqPw2+eaD4fnuvCytVb+Nc9kjqVc13o/M5xvHz7q7M38hUrV0Fw+8J70Zo2
r+i8D39zWnq44w19L2gYfO5N6eSCL6/o8wvHcbGv9cGbky6sXEXDn/4doST0
y4XGCRz9LLpyX0CEKytXifDz80WOGb54TeMHju1Wvnn/UnU3Vq7SOPZ7VKbx
0jY3GlfAw7wyZlSZu7NylQ1vFv60vEPMg8YbcMNhqy+8CR6sXBVw9LB6/J6t
xzxpHAIvWP66RmKiFytXpRznr6yVn0rzKFcV8Lw541Nne3uzclUF//z6ZECd
1Rsat3C8TrFsrXBdH1au6uFLuX+pBsj70niG43j5lXFoY6svK1ct8Nsf12SY
Hfdj5aodbnLLptPCzY+Vq4/wQI0vgt22fjT+gRdbSzTwLvBj5aoH3hV364Sj
ti+Ni+DauR/+Fq32YeXqG7yv4/GjzmRvGi9xjB96rzy1++PJytUPeMvatYsc
vrrTOAoe8nTzKjmN16xc/YHvmD7mr43BCxpfLWV7kKOGxbhdDjS+grdN9rCp
5beh8RXct+PbPp0QCxpfwc9evhl3yM+YxlfwxVvbBvMjNtD4Ci4988qqsecu
0n098N/Fd/hcd5iz1utO4fj54o8uvfV/ROvn4QomsaJ/r9ix1vHOhE/5sXe9
8DQnWlfP8XoeVR85EPaStb53FnxJuufAtmVutN4eHnXA5d4few/Wul8xeP6H
1X07x3nTOnz4JiMrQzcbH9Z6YEm4lErtnHoZf1qfD2+xurrHszSAtU5YGr5A
o+3R7evvad0+/Ntz7+Lo8cGsdemycP7Wd87GqiG0nh9+x36sSfetUNZ69RXw
eUqBboMuH2idPzxsndz4Tq8w1jr2VfBZtx2/2jwJp/X/8KRtFhO2H4hgrW9X
hltJ/IhY+zOC7gvgyJv2dqPKG5Gsde+b4St7zex3t0TS/QLw2GlDuSPkoljr
4VXgL9Y32vRfiKL7COA7sv7ULnSJYuVKDV51bH/3i7gour8APsEk6NiX0ihW
rvbBe7s27nreEUX3HcDXFjww0R+KYuXqEDzhlqOl0IRouh8Bvk9yzIipgtGs
XGnBdbk/vzozO5ruU+DI80lVg4tTo1m5OgmvvvnQuvMb8z3M8B+Ph1esSIhi
5eos3KFLZtWIy1F0XwPcYo3z07n8UaxcGXD8+8xvdSs9Iul+B/jJolRFtTmR
rFxdgs+M3Hb38dMIug8CrqK8Uy+1N5yVq6vweJORiX/WhdP9EfA4d/VN36+F
sXJ1E/5+9QyVTf/y+d/fzODhkVU7TN6EsnJlDs/aL93x1z6E7qeAf0kzn7Hn
HN0vYAkvHbP5Z6lUEN1nwbG/wqyO83gHsnJlzZHDI4XHjIr86X4xeMRqHaX7
VT6sXNnC72ueea6S6EX3ZcBvpQd9fmvlzsqVE9xfLdLc8dwrul+D4+cYCKTp
2zqwcvUKrn9w9vTdMx/TfRzwmp8Wk+Tv3mTlyh2+uWL81vVlgnR/B3x1rOB2
ye83WJ/338D3JlZajJ7+mMZX8BvDt3p9XzrQ+AoePFk0wHj5KxpfwQulzWTO
TXen8RVHDqXfeyhGetL4Cq7KPeXXstFvaHwFf75u9Po/P3xofMXRYwfCrkS7
+NH4Cq5ZJB8kM+BP4yu42New3uVcATS+gh92v9yXnkfj9mSO84LXnUfVhwNp
fAV/aCJyVy45kMZX8ILbkrJcwu9ofMXRq3szlqpcekfjK/jYtbXrNxW8o/EV
x3mkIVa0ccl7Gl/BKyPrLpg6vqfxFVzZZOOJspFBNL6CL9wY96puVRCNrzh6
r1Vn7bPLQTS+4ni/Rq+tGgLoPo56ePP0R8k1TUE0voI/9jEJ2Tw1mMZX8GOB
mk3Wa4NpHgmeFuohqH0ymMZXcNOixyeF7gbT+Ao+YLHZf/HLYBpfcYwT+Pon
LvELpvEVx363uOR7/m0wja84zlPHNY6N9qTPg985ev5uqXv6M/o8+ANu06Yw
xtA8mMZXcPtzkvxCl4JpfAWXU42sCDwbTOOrZWxXlWkSiDtJzy8YBT+fyX9M
73gwja/g0ofblnFrBtP4Ci626PGEUXuDaXwFL53bPfBxfTCNr+Dfh0bVn14Q
TPNXcDv/M+IlPME0fwUfXl87aUwb81xguP2Fta9fxlOuZsKVPMMeT39JuRKE
71yjdi/1FuVqFjxgy7RrfOeZ+4PgwuXd8W2nKVdi8DVhrUJ7dINo/go+y+5U
7BODIFauJOH+CRI3HxsG0fwV/IvSHofn54Jo/gp+wnzx6tOHg2j+Cj67Z1Oi
y/ogmr+CWz/mNiiUCKL5K7jnqdYanslBNH8F3+NzS+XKiCCav4L7+V84lzWS
5hlWcbyeluMGDfxBNH8Fv13K3TBPMYjmr+DOtz/tVfz3vljjK/jBRU7/x9R9
x+X0v38Ap6SkEiGispKVrSQVJaMolJBokEiUWSg0SFFKoSHae++99957Wplp
ydbv8/jdr77X+dPz0SN3932dc173da73+xyc6xeD/hW5pq4f12h7DPpX5Apz
Dx9ImoW6UiZ/K7lY1FwNdbWXvDqiYfCbPepKjXyEw9R/TSHq6gD5V7X5M4Un
xKF/Rd4Zck1EQToO/SvyK0s65x83iUP/iny65JJ3qb5x6F+Rzz5kNHlOTRz6
V4z3QSiyUflXHPpX5E2flplWisajf0W+Ze8X/5fy8bifQl5ZvvDOzSNYp3aG
/PLr7YrTz8ajf0Wu7ttbvc50vH9Ffljy2YJ24/H+FflgdVzcohPx6F+Rnz7G
Y7NAMR79K/IWbc2PPUJ4Too5+X4NGTadN3HoX5Gf2iSX4/giDv0r8pikaP2T
u+PQv2LUVetn9bYenK+sySd2iUsMnMb56i750PpPpc9aUVd25Fxq+w6dkIpB
/4rcy9e8+tofXAcfkq8OCX3teTQS/SvyUZ9jii/uh6N/RS57znvU5b/v46x8
Rc6TPXbP+1Yw+lfkLjNqy8OPoM/gQc77xzQicOl4/4o8NjVxZVS/D/pX5JYR
jfPfm3ijf0VedjOiPHimB/pXjPq5cPpjW70b8hV5ofXc5yVBzshX5O43bFvk
Ru8jXzGuIx7GBnU37iBfMY4j7djc2ZImyFfk/xp+fV7xRxbrcMkTmkYXJ765
xMrtiYzP5UW2Vd9JK6zPJdfJ1Vm61uI+K7enkZ/5w3NZ29EJ63bJZzbOE7Ys
cmHl9hzynUUOpzYWu2I9L/lyXffzRzWfsHJ7IXnBDpOQkFtPsc6XUVcbuoee
7HvGyu1l5N679Pt3tz/D+l/yNbPDLNYou7NyezX5JL5fzjk57lgXzDi/Ld6t
xHvKg5XbG8hVY51eZqp6Yr0weU3rsXv/rL1Yub2V3Ijb1bCi7znWEZPbiL6r
nXLkBSu3d5FfkDgqtzTpJdYXM7wz+GTnTR9Wbn9Nbu1tGrZ9ui/WHZN3VK+r
jXjpy/o++J58qqrtU2VxP6xHZlxPne/O9/L1Y30f7CcX2CgiMIHdH/sqkK+a
kSVaLIfnEA2TX7N4s2i7sj/2WyC3q/il0yLqz6qrH+Qfxf48m1Tgh30YyOeE
/Yk4utOPVVd/Gddf47qWR+m+2J9hw/+8XEL8ltomX1ZdsZFXPS1Js8rwwb4N
5Pd+Dj65esCHVVec5A0PjbqWvnqJ/RwYvjH/+LyNL1l1xUPuFLH2trj3C/Sv
yJfqnO9RX/oC/SvyN9E8fjPavNG/Ik8vN4uckueN/hX5CqfE2wveeaN/Rb63
qSKVbd8L9K/IByRHOW79RV2JkDeZcR27+hd1tZBcMGOL60AA6moxueVv6UZJ
Q9TVUnKOZ2elVTb6oX9FPnefuOOhn6irleTSYQr79gb5o39F/tfq4I8j6wLQ
vyIfshpZOcMjAP0r8t8Rhg5LXgWgf0Xu7WOa9G56IPpX5Bka+4ayVwSif8V4
nY6nFR6sDET/irx/Uoh5Hn8g+lfkE+sKfM43BaB/RV4w7Fg34UYA+lfk58Jz
AyT/+KN/RR56mrt0n74/+lfk32c0Lv6Z4If+FaMeXphZyf3zRf+KXCIrI/bG
bl/0r8h//lWSlX7hg/4V+SGBVyoy3D7oX5H7612/Kb3mJfpXDDf172p8ibrS
JrfniDdPNkZdnSCXV+jfof/gBfpXjOPCdjPH1Pcv0L8i5w3sfcxl+hL9K/L4
MY7GH/+9Tla+In8v9cXymaEP+lfktXdqKj8X+6B/Rf5LMfLPkyW+6F+RT/2w
hT/jqi/6V+RjV7OyDRN80b8iP+86vDSyzRf9K/JrGaekTrz2Rf+KfI3X4i7+
Cl/0r8ids2bc6HbH+eoO4/358oonRgPnK2vG3zXwffZeXl/0rxjvT7Tyuchq
nK/syH0io4J/Bfmgf0U+41fqdS9vH/SvyGWXvQiqyPJB/4r8n9qyiSqzUVcu
5IX2Rp2JYb7oX5E37/GNC7nmh/4V+d3elYVdZ/3RvyLfVbT1KvfFAPSvyDck
LorutQhE/4rchnPOk7V3g9C/YtSz1EGBxXbB6F8xjot57seC7oSw6iqIfNWn
Ix6/jEOxbwn5yTljAg47wlh1Fc54PQn/mjaNhWE/E/LrMcd1tj4LZ9VVDOP8
2fIw4hZ3BPIVebTtLG3poxHIV+STl301q7aJQL4il0xIb75nH4F8xbhevHJ8
FXomAvmKfHpQj5+8aATyFXnQlFt63OHhyFeM6wW3am8FVzjyFbnc75brXzaG
IV+Rr4y7v1hidSjyFXnmSNax/d+Dka/IT8xWX73tSRDyFfmcC/PLQ6cGIl8x
Xufp3bm2x/yRr8hnnXrEI2OLvmgz43Nvag95x4PzVSt5n5NmYnKlJ/IVueOD
2pPd2k+Rr8i7dZ+9uVftgnxF/nLeYK2KiQPyFXmyZKW3nKIV8hXjejpr5p73
B02Rr8iLf01xG7wjg/4VudbV2M6pcZfRvyJ/yD1nT2mPNfpXjOPxh2ywPcdD
9K8Y5/mjTXtdwx6jf0V+Odv3bfL5Z+hfMXKRWPnWq/ufo39FLuMc+sAt2Af9
K/KQk1ftHVf5o3+18X9+IX3p1NrQQPSvyMf8Xi2K5w9B/4r8wSeDqIvqYehf
kQcOakrzGkSgf0VuU7/bsGkzvg/ykP/KPzmYVRCN/hV5wMH0YQHrGPSvyG+E
ZQ8Z/B7vX5ELTeNM8lWNRf+K/ICw4GDCzVj0r8ilXRveRFrHon9Fni3XZ/z0
VCz6V+QPA57sH1oci/4V+YQ3qieuFoz3r8iTjH+3aimP96/Il0XodQRdiUb/
itwo42RKxYYo9K/IQ6VvHVTvjkD/ivF5qTYK+N0LR/+KPL+r6tKGLWHoX5E3
WUwx+MMZiv4VuaA55yfF8X77ZvI9kxdp5PMFo39FHlnxL+6YahD6V+SZYfHa
t9IC0b8ij/j4verkIdSVArl75qS3NiKB6F+Rv/b9MVdGIBD9K/Lybvu3p9di
XyNlcnajL7qplwLRvyKXiDms/aUhEP0rcjHpWeHrVDEnc4B8fVSP85G6IPSv
yGdtM3iTdRB9hsPkQf1f5g5kB6N/RW7GccLgCE8I+lfkJ/7lVQ5IhKB/RW41
QVuKXRjzDHrkbOpGT3/WBaN/RR528f6JI/uC0b8if5p8S8XaJQj9K8bvMbTf
sSw8EP0r8p+rE1+WBAWgf0U+R/LfcIOjP/pX5PN0L9u3nvZD/4r88KePW79I
+aJ/xfj5oqIjflw+6F8x6vnHGhXOQszJ3CDfV3Ha45CfF/pX5DvVgu8L5Xug
f0XO/SPxItsWd/SvGMe78c+NIpOeoX9Fvr37TWwu51P0r8h7e88tcVr0BP0r
cstHPcWiUm7oX5HrVdzsuLTWFf0r8rgNvluX/HVB/4p8klmD5Ji9M/pX5IsH
DTZIWTmif0Wekj80qWaGPfpXjPPhd1OfFj8b9K/IN9pfmBCsfAP9K8b/m7Zl
VC3mNPpX5Ap2U7kU1x5CviIPGdDODDlghnzFOC588zhWbbiLfEU+vFpLuXTe
I+QrxnFq0jdxyMsN+Yp8Zvzcp8ERHshX5FsbFORFgl8gX5GfNo6ui0xBbk9k
HO9i66Saf6DPkEJuJ7HUdB9XEPIVeWN0Yce3jmDkK/IuASv20vOhyFfkdy4O
v0+ODUO+Il+y7UzO2pfj+YpRt0unXa9cHYF8Rb7lqJPPH90I5CvG9SJL+VqL
fATyFbmnc1He3rZw5Ctyiye98U1y4chX5Nsiz5uY3wxDviKvWfYvss8nFPmK
XFHzirtufgjyFbnoh6qlv0aDka/IWybv6VmvEox8xfh7NybVx5Yht/eSj7h9
4ku8FYR8RX7/vdUtadMg5CvyLxOkndX8g5CvGNdB/gP6N2YEo3/FOE53LVjG
GxuM/hX55dwGnfpLIehfMfJJzarV+w+Gon9FrqbS0xq6Pwz9K8Z5+/aB2nem
4ehfMepHTLSoLB65/Rfj+lv+IuzNrCj0rxif16ukjFtO0ehfbaLPZWwLn/T9
GPSvyPdoBjt77IxF/4q86dujWJ4/mGfgJN+nqFOyPDAO/SvymOSunCWK8ehf
kcfbm9xpbYtH/4q8L5/9UcXFBPSvyC3jX22ez5OI/hX5hV/cj60iEtG/Il8o
/uTZtUNJ6F+R/+gOG9rAnYz+Ffk2/cR5FVXJ6F+Rf/A4HecQnIL+FXnoR6eu
I+6p6F+RbwloEgoMSEP/irzQ/ujx0ap09K/IRdk9PeQFM9G/It+dIfYq/noW
+lfkMi0yj6YMZKN/Rb6m+mvbj9Qc9K/I7214EaB6Jxf9K3KJGs1mlT156F+R
j7xXa9kvkI/+FXmBvNHFUx356F+Rz5rouH2vXwH6V+RL9KLPzjhZiP4V+e9N
MjZHhYvQvyJvsP93YV1NEfpX5J+yKjxSbxSjf0W+Q0zSoG9eCfpXjPd/5OYL
u7gS9K/IbSsm3dKVLUX/irwzbIeQTnop+lfkGls7DSasKkP/ilwu8tT2+kdl
6F+Rm5d0x+m+L0P/irw7JpXtolQ5+lfk8jwXy01ulaN/RV69U1P4RFY5+lfk
+49Nmi3yoxz9K/KWs8+Hnq6qQP+K8f4UdtpbaVegf0XOfzfpj+z9CvSvGMfj
faPJ36Ir0L8iDytWlqurr0D/ivxqh6fhmpEK9K8Y9ZmU9SZmeiX6V+Qzam3u
S0mM76dNbjEasiF8VyX6V+TJxbo7GvUq0b8iP3fKYbKBRSX6V+QT5bKsedzH
97Ml/1KWmX8mEftL25EfzcuZatdQif4VueqEsSUPRirRvyK/vVvH/7tAFfpX
5B9vFy3bvq4K/SvyG97ab0VVqtC/YhxfZlEF1rpV6F+R/+W+4HPEtAr9K/L1
ivv5Da9XoX9Fbn30iIfqjSr0rxjnw9Szo18vVqF/xXj9Jm0rOf/7f1n5ipxX
wMhxp1IV8hW544Ub16sXVSFfkSvJGNt7/qxEvmLUZ7duI1tZJfIVudcbM5/r
rpXIV+QPA10rYzQqka/II7cV8q3iqUS+IvcMGxiKS6lAvmKcJ4cqvLSPViBf
Mc7PGxwqdb+M70POuC4k2Xt/uFyOfEV+PLpM9uenMuQrcs0zpjcdNcqQrxjX
Ne1tPlKRpchX5DcXbFSPGy1BviJ/X+z5Pmw9zlcV5OLr2c5JnixGviKvDPA2
M3hQhHxFXt6sJ7g3phD5ivE5Ttlxa7S5APmK3ERkVfHXyQXIV+Smg8ennZPP
R74i55JJU7KwzkO+Itf/51TvVZuLfMV43wa9w+etyUW+Ii8SVjo83zsH+Ypx
nFqYO0+en4N8RX7ZqDX0qUY28hW5s/OkaT8ccB3sJxfkzB0daMpEviI/xFYw
dbkk9n8eZnwuI3oVB0MykK8Yn2PPqXaJ1RnIV+TDkQuEt5akI1+Rvw441ix2
LR35ilxH13XdVKl05CvJ//nnfdGPWqakI1+Rp8cc3xj9KQ35ijytYnStcWMa
8hX5Ia7cogcZachX5MoCtalnn6UhX5Hz/Ok5/U8nDfmKPCKw2KN1RhryFfnx
jy4umZGYQ55Jrnp75quWtZhDFiQ/oXH6GpdPCvIVeYujxA/biSnIV4zX6bh4
ufux8XxFXrUofNfN+CTkK/LX3caGtrxJyFfkl3yF3zWeT0S+Il965pn8cEsC
8hV5XM3vnq/qCchX5MOiy7vnv4lHviLPv2Ky74FjPPIVedLDqyfq98cjX5GX
yByekbVifL6dXGpxSd652fHIV+Sywiu+eU6LR74i55u7Ou6KQDzyFfmHAb/H
MxfEI1+R271Y/8ZrA+aQFcgbK12EHqjEI1+R67odMeg7FY98Rf7097kqfct4
5CtylR9uy7zckNv3kp9OEQz6EY7crkZunS6uZVwYj3xFnnnmws0Lr+KRr8jz
zvb31bEnIF+Rh7YcW7l6RQLyFfmpphQVFc0E5CvyhMTAoXn2CchXjPpfKlHz
NS8B+Yq8YoLflo9sichX5Oee1lne3IW6Ok0uOOW72tpHichXDHdeF8Hdmoh8
Rb7tpZSk9pIk5CvyYxyhShdMk5CvyC1FeHP2ZCQhX5FPs0opGJg8Pt9OviI1
+tGYWjLyFeP1BIz8GXuWjHxFfsQyiYO3B/vbWzKOi9f2K34tS0G+YhxHufOt
Dl1KQb4i32W2XVEkDesm7pLXCUWvv/QX6ybsyL9GSP5aI411Ew7k6hmxDrxG
WDfxkHHeCNsh/egh1k08YtRJm8CHmd5YN+FC3r8zV7DvGc5Xboy/a1SMU/Y6
zlfPyO/sttRfIIt1Ex7kqa6HI9l6cL56Tu6hyTZlin4K8hW5zSnXhMKyZOQr
cvOGrV+WiycjX5EvuuXy6rl1EvIVeeGL18XNr1BXIYz/9+9gqv0e1FU4ecMV
ufA9KQnIV+TnPxjdaF2fgHxFLhLsn5SThfNVPPn+JTunZ+jhfJVIvjtgF+ek
BThfpZC7GLzaYvUrDvmKPMgvgetkfxzyFeNzkVhj/Gs0DvmKcR6wOJJ6hB/n
qzzG9WV6xtkPm3G+KiTfejjozLKLOF8VM64Lc9xv8KfhfFXGOA/X/61tEkhA
viLfLNmWm2aZgHxFvuO0qpjHKPoMtYzrgpPSQ1NL9BkayNtet77ln56EfEVu
dXqR4v5o9Blayc/GhGtFaKDP0EE+J2JYxeQProNdDOfMS5HwRZ+hl/H5Ljno
rSeLPsNr8lguft66cqzHeUc+42DVD8vdachX5IpmtmJz49KQr8j/rBO0Wsud
jnzF+LsaB5Zrq6cjXzHO8/z6DTsfpSNfkYveidsumpWOfMX43Lv+BJ/qTke+
Ih/7cFJ3YGg8XzHO8w/1rx/9OZ6vGMfvgj6ey8Pj+Urqf/5tuoXH0d7xfEWe
ynFRmCMvHfmKfKR+8EC6azryFfnH4/OW5GmkI1+Rn5H0yIxlT0e+Ij98rufn
y5fj+Yr8b8ZR12fLxvMVeeTl+vSal+P5inyq8awJSznH8xX543niIb664/mK
vGjp5xVc0eP9K3LBT0an3EaTkK/Ik929ZiZvHc9X5AU2Xhkb7XAdXEx+fU3H
Sv72BOQr8tsHFdx6t4znK3IvHV2T8sB45CtyE1ezdxVzxvMVufHAC4HzLnHI
V+QuGg28W6eNrx8k5xTee3KHayzyFfmfJg2tpyKxyFfkOtH+N4/HxiBfkb8S
/BjzUTkG+Yr836UxN88G9EW3keu2lM9LEY5GviK33eoWFGEahXxF3vZqtrFp
ZSTyFXnJKdcjEzdGIl+Rj+mv333PH/32veQVQ3uiMuZEIF+R/xS7JLbLEf32
A+SB/WWzuH+i365B/k60QXaCRhjyFbmvzE+u9qehyFfksjuOCLqlhSBfkSd9
9RYpTka//QT5HBe9vBo79Nv1yK1+dBp5LcO61JOMz9dhuUXrC3/kK3KVWkE7
02HMi54h36MhuGbNmvH5K/J2ca1PZ2OfI1+RKzkJLlv80R35irzly53AqhlP
kK/IP3HtSn0r5YJ8Rd77+57NphoH5CtyqW3bO01O2iBfkS++9X7NDDNz5Cty
t5wX95efN0C+IlddJS95S3YH7g+SP5f13TDocwH3B8lfVjwXiQy6ifuDjNfj
MuGVfaEN7g+Sr1adMOH+fXvcHyTfv63EcNemR7g/SH6idImHidlj3B8k90ho
nPHQ+AnuD5IbCLl399q74/4geX5GV5xBhxfuDzL+3j0LD5wxfIn7g+SZZ3e+
vOnoi/uDjPp8cOhCp5E/7g+SL+S/G+YjHYj5dvLOQ9oGCp+DMN9Ortb3fI+D
RQjm28llkn6kFX7GOvpwxueYeiD89M5wzLeT65lzts18EoH5dvK3JZbthq8i
sX6QXLpN/dKBTdFYP0ju+M1ZdLoy1uOkkC8vN3AyZ8M6rzRyw2URV/8UYJ1X
JuP69eK96oFHWDeRwzjumv+ylWnHY/0gufNcs7vWyxKwfpC8/un8kqD+BKwf
ZFzXxt77nY5IxPpBcnnfnukrdZKwfpD8yuqcI93s2E+mmvxN3J4FVU+xn0wt
+cC68+5vBPDcgQbyJdrWv7zMUrB+kPF3JchU6+XieQSt5Gl/bz1I+ZaC9YPk
ucNCS2YKp2L9IOP3ZJxpeLotFesHyU/Vty7vN0zF+kHyLU+yzE54pGL9ILlQ
yUr+v22pWD9IvqOlfMP99eP7UzHOA9yqZm5+aZi/YvyetKpGq2XYz3+A/G62
wkmprHTMX5EvOhH4TeM49vn/xrgedWZfcJ2Afex/MK5f3zfIi/hnYv6K/J7v
wKrb8lmYvyKf8I0jcmZNFuavNv/PJ/X161QdyMb8Fbl7xjeJPUXZmL8in8DD
Xrx9bg7mr8gtBAdnfN2Hfdi4yUv8J25dZYPnevCQ9yl3+p1Ow/5s08jz1Nc9
XfwNz/uYTm7cket6b1Mu5q/IX4QNcKjeysX8FeP3f+VWv1SXi/krcqPWEeXS
jXmYvyIf1d6z/01wHuavyGVXTmjjWI398RaSN7vNLlQrycf8FXm9+T0ZmasF
mL8iNxARvqu9dnz/efItUzU3Tx4pxPwV+caGc3oT08f3pSdXZzcqnG6FfYzX
kp+NObPCTGF8/2fystb+hvW/sb/xJvKA7N+5sUHYv3czudOTWW3ztpVh/or8
WO0E+995ZZi/Yvy9+boK/iuxv+g2ckN1LbYp5tg/U4F8e9YHSddQ7DuqRB78
dcckm0Lsq7mLXNdAbvBtHfYjVWZ8vv+0JXe2YL/NveTLBLlmfGjDPqVq5AuU
riy82o19OA8w/t6R09c+jO8zqUE+nGm5kpd9fN9X8v0SeTE7Vldg/orx9xbX
CE27PL4fLPml4uESvaYKzF+RH5Wxfz16ZHwffvJMVeNFkaOVmL8iN+WNKZsX
Or4/P/ma5frVd4yqMX9FHvoo/JXOPDxv6xy58ms74X13sS/9BXJzt8azWwfH
9/Mn3ytcWdSnXYv5K/JNM7ccCy+sxfwVuYtPap3U8jrMX5H7Cdw+6HuvDvNX
5JaJmzaFdtVh/oqca/LsKW/X12P+irzUaYplum098hV5R3zNXK7GeuQr8r+8
Fe/XLWlAviKf7CS3R+hSA/IVuUesiRp7VgPyFfmOmd4faic3Yj9Jxv+b79lw
WaUR+Yr8zYROPZ4HjchX5JEz7ftaChqRr8hv+6/25vnRiHxFfurmXlO2JU3I
V4zPveLYgoDdTchX5MubpIJMTzchX5FbR4jX/7BsQr4it9ExGtV41IR8Rb6+
0dhjlmcT8hX5yePbN3l7NyFfMY4Lz8Sqqx5NyFfknzYFa5k6NiFfkS+2Wt0W
fL0J+Yp8Hr/NlYsnmpCvyM3CRafv3NqEfEXeucv17UeBJuQrxnljrnhH7rtG
5CvyBzbbBHOTGpGvyG29mzi47zUiX5GncrFFnNdsRL5iHO+FZ2eJLG9EviJf
ty0zqvQf6qqMfMoH/vZ3zairCnL+aTd9axIaWHVVTd579uq/sicNyFfkFxPG
eHhvNiBfMeoqWz+09FQD8hXjc3T5mL5TvQH5ijzqicHg2M4G5CvylJPrU9K2
NSBfkX9eL7/BcXsD8hU5u4yXZ5xyA/IV4zrlN/xa9HgD8hV5UnDOD6XrDchX
jOvIfck0hZcNyFfkTbafObZWNyBfMerfyybQeUoj8hW5vN3f5bGqjchX5Ifz
5TyuvmhEviJvX3rZ8vT3RuQrcikhU+c3mqirX4zztuXZ9klpTchXjPwQvOnL
BpFm5Ctpej+Navi0rZqRr8ibxiyDO3qbka/IO24pmp+Ta0G+Il8oJN3V96QF
+Yp8wNCt/GFfC/IV+dvUKukzG1qRr8gd/z2IVb/RinxFfvGuXalJZivyFfnt
3x/Xpv1tRb4iX31/UveITBvyFfl3BevrVuZtyFfkknKTKgbj2pCvyNe69Me+
/dCGfEW+uNymzX5eO/IV+cyr7d1Ld7YjX5HzOgSesD3TjnzF+P3z9GRNrduR
r8jLVZ+vm/GkHfmKPP/zj3ojv3bkK3J+/10+pyLaka/ICx9sG1JLaEe+Yny+
o38zfqW1I1+Rc9v2Tx7OaUe+Ipdd/7jOq6gd+Yp8zvVi/g0V7chX5EYNnpe+
1LYjX5G7+4l6bmlpR74i57N30RXqaUe+ItfoU4ni/dSOfEWeOke/2eVXO/IV
eVVC41H/aR3IV+SJHUuX+KzoQL4it/WTinVS6UC+Im/e76ZtfakD+YpcSs2q
7u3LDuQr8qcCC4/GNHQgX5GPjsjl683oRL4ilzb9/FVNqxP5ilxrSo+EWkQn
8hX59tzVB/gmdyFfkf+VjF7882QX8hXj5+Xa3R7ndSFfkb/f9jFmnmg38hX5
j1b1XCezbuQr8k5rgWsXyrqRr8hLvn7skp3ag3xFbs9n+3O9RA/yFTnbk3Ur
byv3IF+RC3T/e/Rdvwf5ivH7V+00mWjWg3xF/vp+t8cBux7kK8bvL0yW8XDr
Qb4id0nsfqj6sgf5ivzbqMWAdXAP8hX5hBcJ6u0RPchX5G5/u0SKo3qQr8iz
1ihfK/rv51n5inzTorjz94J6kK/If9ZvuFHr1YN8RT7D90a1ycMe5CvyM1/Z
YwXMe5CvyEWuWPnpn+hBvmKcb62dbvPJ9yBfMY67Et4pPXN7kK8Yf9fdK2+N
O7uRr8itIiaqiN3sRr4i36O2ukKOtxv5inEeMF34Z7tbF/IV+XRhITP26V3I
V+RFbmbNB+92Il8x6uG174jJSAfyFbluyPyDdvodyFeMOim+f76yHuerNMb5
0OqS5JS9OF9lkrs+vLcsoaoN+Yr8wmL2O3t12pCvyAPvBF0IndCGfEWeO9F6
wrL4VuQr8nmtk3InXmlFvmIcRxNWfayVa0W+Im/T/95hOQ3XwWpybb2oh/2v
WpCvGO/zIO/A86QW5CvySsmK2Ga7FuQr8ok7M8091VuQr8hj1l5ewS3YgnzF
qH85+0/7apqRr8hv7l8Wc+52M/IVeaPrKqntS5uRrxjvQ1Uyv2kxcvs7cu+5
XHz7DJDb3zPe/zHxB24Tkds/MfKGzSSpfO9G5CvGdXZ/8VN7mfF8Re45WLBn
uKMB+Yr8/Lb5kypsGpCvyFfyzakwXNuAfEXO8Uw3fENvPfIV+YboxjBv13rk
K8Z1/AFPrawSvg9O2ELvQ+9+DZWROuQrcu/exg7Vl3XIV+SWmy+n6u2oQ74i
b2rfGRnTg+fKcZP/Wq31e9nFWuQr8nRF9kmpwzXIV+QWP33mBBvWIF+Ra4Zn
yG30rEa+IucSKU+7vKcK+Yr81a7Bxo4u9Bnmkn/8tLNjpzaeDzKf/Htg68Kz
+ePPFyOXXTDkOHF2CfIVuePqktcTNYuQr8j7Vzhz3bs73r8iX1n4Yr9rUB7y
FeP1j+mO9KflIF+RS1Rd/zPPPhP5irw6XuHrOsdU5CvyTlsFq5wHichX5Lyr
Yu7LOWNftU3kx1qjumtUwpGvyCdc9zhdHumPfEX+0quwLj/OHfmKXGZyk72B
/V3kK/KHy+ZuSRDWx/1Bcj8LlfMltg9xf5B8zGqgd8sKD9wfJN8oo5TLbuOL
+4Pk23vVlcJHAnF/kDyuunb05GBoNitfkc86XDEkZxmJ+4Pk7WUPDnmpxuD+
ILnzI96deyNjcX+Q/Jxh5PI9vXG4P0juutLoZM1gPO4Pku+wkT8o9HZ8/orc
reY6z+usRNwfJNcwXtp25g7m+k6Ss/95nvtxeTLuD5InKstfU89Ixv1B8pMH
eM24tqTg/iC58Y/+9WlBKbg/SN5ob6BlOzkV9wfJ68JvWnRpp+L+IHng3nax
hvBU3B8kr30RxMY1kor7g+RPHuu6O29Kw/1B8vVp3t/aTNNwf5Cc2+Rc2UhQ
Gu4Pki/74hd1sTUN81fkM58anN3KjXmGu+T2y6R+qMtgnsGOfHhp/sfHFzDP
4ECeE5abaB2IeYaHjDo38CtM70ln1dUj8sNftLZvE83A/BX53PmSER0nMjB/
RX6nni9byjsD81fk83kH2qJbMjB/Rf6tX/hfDH8m5q/I0/zOKHooZWL+iryt
wV1H3zwT81fkgw0fLoqHZWL+itzr6omGgvZMzF+RLxU+wy7El4X5K8b7FqE5
u1UhC/NXjPNV+gbTfgvMIUeRn9G/G8uTk4X5K0ad6xve+zgtG/NX5Acs3as7
TbIxf8U4Lwmv8Xj9KhvzV+TKszaHfdqUg/kr8hN519a23cvB/BX5tYilVSVv
czB/xTiu5ef8+e8rBuavyPVvq7+bU5uL+SvG53UgO9NYOw/zV+QNyy8cXTCS
h/kr8pjru1Skn+Zj/oo8ZWqG8cNtBay6qibfJFhs1DBQgPkrxvXCbuO5soDx
+XZyE7493VpaRZi/Ip9yJk2Wk78Y81fkxxdGXRAuLMb8Ffl9m4h15tdLMH/F
qEP7CtFJEqWYvyLP3zNy7Xp3KeavGPXZ+6v1hHMZ5q/IVTQmWvLJl2P+inz0
cZ9cwMdyzF+R9/0WfPbPBetx+snVZq8Q5NyIdRMD5M/4YjIcarBuYphcYcy/
YfrZKsxfkdd/3GL5ZEI15q/IvzY8lN7sWY35K8Z1YaJbzoz5NZi/Ijfs2/s3
/nwN5q9k/ue5X26u3plXg/krcldjTp+pQrWYvyLPSa48selqLeavyKsNls+v
r6/F/BV5XUBMZ/umOsxfMX5+39FLwl51rLqaRr5B7mXYX7Z6zF+R35ji4mxg
XI/5K3KvS9+2z2mqx/wV+ZWrY3dE5Rswf0X+OEDk8tugBsxfkddwG3j85WnE
/BX54l1aCt9NGzF/RX6O5/M0m7pGzF+Rj/AsN4tf14T5K3L55qzF352aMH/F
eP99RrxaPjZh/op888V51yqVmjF/Rf75dkakiE8z5q/Iw7aGXsn/2Yz5K3Kx
lFvWBw+2YP6KfErjK68toS2YvyLPfuYlO+NfC+avyEc/+4vG7m/F/BXjdXqr
r+L1bcX8FfnH3NRw3q+tyFfkEhv37jfb0oZ8RT55afDzCTZtyFfkEWr+MfdL
2pCvyNlUrGcoTG1HviLnirHRC1RpR74i5+yZkC/r0I58RS7ksaD9anE78hX5
Za+pf3TYO5CvyG33bL78RLYD+Yo8a3VJqc7VDuQr8qdVX3g4wjqQr8jfGIu9
+NPWgXzF8IiX7OxcnchX5MPVs7u413UiX5H3piXf4tXsRL4i/x4517X6Wify
Ffm95Q5sOY87ka/I70gmta8N7US+Ip+ZdTHiTWon8hX5yl8qmocLO5GvyAeD
H0ZfruhEviL35s8zW1LTiXzF+Bw3rf+3ubYT+Ypc1PHVqPV/P////7pDfvTN
xiW1VZ3IV+Q/Uo/JNf/3/7LyFeN4d7RXXF3eiXxF7r9tF+fmsk7kK8b7r/TJ
qbG0E/mKcT45Xx5x4j9n5StGfWoILuEr6US+Ild1fj107b/3h5WvyD/ZGmu6
5HYiXzGOr3O3hK9kdCJfka/epf1bIKkT+Yq8Kq9v+6aoTuQr8qiVX9XuBnQi
X5Fb/KqbG+2OuvJn/L0XlvHvd0BdBZFzR/DteGeOugohl5z43a3pJOoqnDxZ
WqbTShl1FcU4n+9Mn626CnUVQx6bZz4Wx4W6imfUpyKXsWF3B/IVow4zEx47
xXQgX5GHszkO+1p0IF8xzjOBi9et2NGBfMX4HLd1Jz7l7EC+Iq91PZOr9N95
gJWvyLVsKhf52LQjX5Hv+NnHJi7bjnzFeD0WP5pNRnC+KiPX/WTtsyGsDfmK
/OU3zW5DnTbkK/L40Cfha2e1IV+Rf+uVu5te0Yp8xTje33RIiNi1Il+Rqz9O
5l6n1Ip8Re70RKDMmrMV+Yrcj1dC+3JVC/IVucp7hWBpzxbkK/I9eUJfio1a
kK/Izb53PS+Sb0G+IncRG5Hyn9OCfEW+6NGMjQ9GmpGvGPX/+FS8UR2ug/2M
ur2sdHlmLK6DA+QOlyaN3n2E6+Aw+V22IzLTzjcjX5GX7/t8ZsueZuQr8t31
FbdcFzcjX5FPkpDivfu7CfmKcfweOLz5Vk0T8tXW//lnyz/HDvk1IV+RK/+4
MHTjYhPyFfmd+J9KGXJNyFfkHDWyK7u5m5CvyAMPcJw819SIfEVudW1yZZxv
I/IVuZp3cdCYcSPyFeP1xK03Sd7ciHxF3vqw644BRyPyFXnD8bDc2PrxfEWu
Uu0+VTVgPF+RayqVJvaZNSBfkfNLv7oqrNaAfEXek73a8fqKBuQrckn56Kf6
3A3IV+Qnr34oZ/taj3xFzi324cailnrkK/JZqisG+Arrka/I/w3vCy5KqEe+
Il9zfEbQ1qB65CtyTk7ZUmP3euQr8qn6XpYaDvXIV+RK8/ZGvL1Rj3xFXsm+
zvvvmXrkK0Y9rPSLeKxej3xFfsTpkNi6LfXIV4zXv+euuapwPfIVuVDhd/Gx
v3XIV4zXeTPtjX5nHfIV+UDXlIX7M5Db95K75tZMOjme29XIr3xdd2rzzTrk
K3KFNIe3j7XrkK/IbZKaHutuq0O+IvdcH7XIU7wO+YpcZIvy5vYZdchX5LP1
sv9+m1iHfEWeu8C4b/JILfIVuXzbHXO297XIV+TJvjq/ZTprka/IV9bXx1v8
972Gla/Inx5yassoq0W+YtTh8jUyzXm1yFfke+fPrr6YXot8Rf7ETiZzSUIt
8hV5YpmlVmRELfIVeZGT9IkfAbXIV4zj9/eR0SnetchX5IpcXzq73WqRr8jT
e8WFDR/WIl+RR1uLstnY1CJfMY6XDKGOSTfwffAu+T0xjTU+Jvg+aEfela6Y
MXgS3wcdyJ/bXtzqpFmLfEW+2GyqssiuWuQr8giDdD6XTbXIV4x6EEyZKLuo
FvmKPLz/hEwOby3yFaOuVnB5Zf6oQb5i1EOleG/K6xrkK8bfVV8h/qeqBvmK
USdfes7rpNUgX5Ev63r4VTqwBvmK/NOLbRuCnGqQr8hNi9Zx1F+tQb4iV79u
VT1fqwb5ivx9QOn7kS01yFfkHjc51mYL1iBfkUsn2x4t6q5GviJPuPfDTu9e
NfIVubnSowKFJegzpJCHrN+jKJVehXzFOC8pdljN2VeFfMU4byys3nm8Hft+
5JBPCDh6UsoQ+37kMT6Xhe8jJw1VIF+RHyzPPuVtWYF8RZ5kIOy+lacC+Yrc
rHfgwjqfcuQrclWx2TEOMuXIV+QHlG6K1nWXIV+R/xFb/5HTqQz5inH+HJK4
nrAT+8k0k9ezm7e/m4L9ZFrJfU4tWKraXIp8Rf5wkfyyO1GlyFfkXqUthgse
jfevyNkm7zvibj7ev2IcR5fnCsafLUW+Il++oGpZmG4p8hXjc/QVEk47Vop8
xTg/SEq4ZxwtRb4iH9VYdF1SqxT5ivH+H86V/KhdinxF7l+8e7OOXinyFflN
BwW7uNOlyFfkNdFvNxWeK0W+Ynjwv3m2JqXIV+T9d05umHSxFPlK9n8+zZyt
4OF/P8/KV+RB59JEk4xKka/IRY+FrbPVx74fnOSpEcOflA6XIl+Rp4eM8aju
KUW+Io8IdNlbvbkU+YpcSkl6Z68Y9imaTj6dXbT6OT/2KZpJLvDc4PaCnyXI
V+RZZ2aI7+8uQb4iTzK/fcM1rwT5ivxdsl71Z1/0RUXIfYVfs6lZlCBfkf8d
sCmt3l+CfEV+XCRdN0ikBPmK/PvB0i6Bt8XIV+SbXaLCFP2Lka/Iv6U/em54
pBj5irzeefXh5ZOKka/Io3/mr/0VVIR8RS45adr2pu1FyFfkp4Q61pU0FiJf
kb90rk74dLIQ+Ypczdhy8rT+AuQr8vnfhC59vDa+/xX5I5/4DfITC5CvyB01
tq1odcpHviJ/PefK3rsL8pGvyM0D7rcWJqHfrky+f2iO/6mDechX5E/ade/K
jOQiX5F/HVxf6fQ8F/mK3Lngx/wm5VzkK/KAf7ybhP7lIF+RD9puGb6QmIN8
Rf6lPr9I1DQH+Yo8NO2BSJpEDvIV+Tzz6ktWHdnIV+Qcnw2+2pzKRr4i39j5
a5HEtyzkK/KE7LUn5jnjPs4Z8llD2dfdJXEf5xx5cyj/Eq0PmchX5D8ODx/O
DcZ+Mqbksts875mZYD+Zy+Se7LnfVslmIl+RL7g9MjmUNxP5inyv9fS6bV0Z
yFfkcvZfRJ9HZCBfkd+MXuvsdy0D+YqcO+10r7JMBvIV4+99rRt75Pf4/UHG
59udea43Zfz+IOPzyi6pFL02fn+QfOJDj+iSjeP3B8nji1aJLB1NQ74iD+8f
nX0nHeudXcg1a45Pm3wvDfmKvHPv8lxOzTTkK/KGkwLnXFakIV+RPzwU/rp/
Ip5r+ZzcIX3XDNO2VOQr8txzt/NK4lKRrxifo6Kcwgd7rKP3J18z6+PzuBNY
Rx9EzmY8Jt+1Bs+1DCEv5WLL2PkH953DGXX4qap4fz7uO0eR51y9af/WFs+1
jCH/zHfu5pzteK5lPON8aJqi9uo79v1IJA/kucHLE4p9P1LI2d9WLV6ggX0/
0sjFBU6Wqf/A81IzGdep3G2Kz9ySkK/Iazy6puaKJyFfMY6LxFLl0ZhE5Cvy
HZuy6h3XJiJfkV9rH90RHpKAfEXeFhK0MWL++P4M5Ntb9vE0P4pHviJfuDQt
/vwk7CdTSx475fGchJtxyFfkb6blh/iMYp6hmdzH5OZqu2uxyFfkP4sihZT+
xiBfkY9N77rw5WEM8hV5tv9atRniMchXjONF/cgbXvdo5CvG7/FMFMz5FoV8
RT5j+fyZVqeikK/IX4kuHFz6KhL5inE97b1yWPd8JPIV43o6Mk1xNUck8hX5
mQ550XsheC7AMOP6VankVqGJ5wJ8I7eeUdvwgB/PBfjBqJ+IMk7t5nDkK/Ld
/l/Oz4wMR74iP/o2wzbrcTjyldz/XM4jq7TVDs8FYCM3HDq7OckB+9ZykH9/
82Kmg0c48hW5xN3nlwTiw5GvyPXm3Su71xSOfEVu39HWtYQ9AvmKvF/z+NPz
UhHIV+T+6w51LTeNQL4i99HQd0787/1k5Styngk+0V87IpCvyK01RD8FcUci
X5FXmOW/XL0uEvmK8T6snJnxQy0S+Yrc8cDqxaOnIpGvyIVef/Dfcy4S+Yqc
L0NrlsOxSOQrxvvwfoXQIwnU1Uryxz3DvAvaIpCvyAv8Eg7GHotAviKfa1F0
flpUOPIVucCQWuPzSuxbu4lcdW3zL5mUUOQr8mSzzDYVkxDkK3LRtTp+t78H
IV+Rj+14ovlYc/z5OIzXudTJwcnFH/mKvOvdksEdkXiOiRK5uJv0xQGdl8hX
5HXCl27M2+GFfEVeeqBqVEMIz/Pay/gcY9508H17jHxF3p5wbEZDgSPyFbma
qPxgfcNd5CvynClaS9bJWyBfkZfcrttZ+cQI+YrcVVfGXXf6Bsy3k7d4JfnZ
H7mA+Xbyt18ynIY9LTDfTt42/GjgYYot5tsZr393ceTxagfMt5MHHvc7+V0B
z4k7Qz44yq4c8+4x5tvJK08IZ4qpPMF8O/mSlrLY3UbPMN9Oniki/kpE0QPz
7eRTRaP0Pds9Md9O7mYUcvmt7HPMt5PrB+ikb7wyvn87uVZUhIW93QvMt5OH
eU1eLGn1EvPt5E8W55kslvTBfDv5Ra7ZrxPCfDDfTr5Ze8YVJTFfzLeTD98W
GGyO8MV8O/mN7ok+X3f6Yb6dXLg/yDpu1A/z7eQp7IPPejL9Md9OLrXi+FO9
FwGYbycvmhwz+tUzEPPt5MsNPbTmJgVhvp28JyJu+aGBYMy3k9s6ieVp7ArF
fDv5SIK01o7kMMy3kw/Y6wXYbI3AfDu5ZLqA2MGGSMy3k8vwe764aoHnTYQw
3s8Byb5bHnheajj5+bsGK07exHN4oxjvm8o0+68n4zDfTr6wQGWzvTqeaxlP
bmnFY3NLOQHz7eQzji+baLU7EfPt5PJS3ooH9yZhvp28IeGQJq9GMubbyc9K
3WrMO56C+XbyiLHh202GqZhvZ1yPAk6sGzJNw3w7+fufeQ8HzNIx307uEMtj
KmqRgfl2Rt1GLxU2t8zEfDv510/+6joWWZhvJ9/hEzdf6no25tvJD6QoXhXc
koP5dvKDz2atfZmUg/l2Rl1xB/wcXYd19K3kH3o3WN0Pz8V8O3n4kS8d5ouw
jr6L3ObRh5evnuRhvp1ce29zwp9JWEf/mnEebrE4LGSSj/l2cq6id/Mf1edj
vp1c+f2th17rCjDfTv6uIzj28v0CzLeTexmeD7vVXID5dnJ3B/WB/z4ozLcz
cstt5VfpJwox304+861wtbZ7oXzq/+crcm7N0e0HKwox307OUdD2aP7vQsy3
M/LG5zULlokVYb5d/n++YDB15QflIsy3ky/vUr0aZlyE+XbGzxvInJJ1KMJ8
O/n8UumsP35FmG8nf/+5/5RwUhHm28mvCG79MJBXhPl28mslvOJfSoow304e
8t3l6PPiIsy3k8ttvHKvLqsI8+3kXEp7++dFF2G+nfyHkNjXIo8izLeTj63Z
u+PinSLMt5M//v1hT9CpIsy3k59OiuFv3jU+305+YeqHt7dXFmG+ndx9gnjH
tulFmG8nTzq6eH3br/H9GcinC0z8Nf9jIebbyZ0UXO919hRivp1cQNNU3b8H
dbWBvPeDzrQPH1BXm8gDb+zckvIbdbWZ/GtAd5H8zCLMt5OvanIySF1XhPl2
cpOtiusbDqKutpHbyT795XQNdaVAfn16+eI2L9SVEnlxZuCdR7moq13kM+Nn
7R97h7pSJr9U8lfWlKcY6wfJp9m3bfm4vhjrB8kPCmdlux8rxvpB8q02U7Ye
tSvG+kHyKXsfXXBLKsb6QXJT/94ZGh+KsX6QvGvKRV4H0RLkK/IEBeN/ykdL
kK/Ih2dLbMh5inUTeuTew2NCn5tLkK8Yr4dbN915finyFfniBhNRlVOlyFfk
Bt5t/+KiSpGvyH2nzjI+8bsU+Yrc7LOwfuWeMuQrxnHaonZOx6MM+Yp8xYfZ
i/Q+lCFfkR+6vylTRLqcVVfm5GGaVwU+25UjXzHeB49NnAsby5GvyDWvDMlx
LahAvmK8z9/PhOcbViBfMd6fXrdvu8MrkK/Ib5sUK9z8UIF8Rc52cFGCwsJK
5CvG3zUl1srjQCXyFeN4bKs5mXS9EvmK/JZjSo2KRyXyFfkk99c+1jGVyFeM
ejtXyluZXYl8RZ5m7p/5p7gS+YpR5883rTxfVol8xTiuX00Q6S2pRL4iD66b
unxtIfb98CV/5N9371MO9v3wJ5966MiXsYxK5CvybXafboSnViJfMX7edqXs
26RK5CvG5zsqHVOSUIl8RR4p8XB7fHwl8hW5yEfVXPH/fp6Vrxi//7KDZuJ/
v5+Vr8hnZXyc259eyaqrFPKGOzOenCioRL4i/yWl6OxUU4l8Rb7TLUrkW08l
8hXj/FZbsCrxWyXyFbmtcbWlNl8V8hV5v9AfdbYVVchX5Cc1iuYF76pCvmJc
N39KyF49XYV8xfi7tKf2NN+tQr4iv+8tregUWIV8xTjf8uxLDCisQr5inJe+
H/Xf/g7rvJrJbRYNLL3KWY18RW5R8Wan2PJq5CtymaeZ8yarVCNfkTeyayr7
GlcjX5HraRZeuOJYjXzFOM/MsH7HF1mNfEX+doL+qHA59pN5Tz7v+YpO075q
5CvyvkX2s39MwH4y/YzrwhEbOSVe7CczwPgcn/lqucypQb4iL6/sCcxZVIN8
xfg9Ij03w1bWIF8x8oMyd4DohhrkK8Z1fMbuJYOba5CvyDPYbyt821qDfLXt
fx4nFCrHIV/Det8mki/cOuP1T7ka5C7yEpGYPcH//Z7/fz/ZyaW+22RUSdUg
j5E/TYnPEFhbI///l4XJ5EmhuevZxGqQ08hjxJquic+uYb3/XOSlYzLFSuw1
yG/k/OGaQRNb8blMJT92OT78cUA1ch15es/lek2jatbnxUfeUrDrmd3KajwP
kVx1odaQx4cq1ufIT566aeXp9UGo/+mM941v/6oy/SrW5ytAbjpt5jSpBTgu
ZpKfN1LX9+rC+WQWOYfq3ZFab5yHBckX16zvaj1eyfoeN4dcMavryi8RnJ/n
kr+/8SYopreCVSdC5IbsbEL3g7Bf03zyZUUhA4PnK1j1I0zeFs47wr0Z+ziJ
kDcbvekynoTr4ALyj3pp6/fWlSOXkst8Gi6s8MG+WIvI65OHvsmYlCOvkk8U
W76GVxb7ZYmRB9RbWSVMKWfV1VLyFZ93ONs1lLHqSpzxPnd6G6U8L0O+JV+z
zmj2Gb0yVl2tIH9s5ropY2EZci+5sM5fJ77OUlZdrSL/5Wv7T80VuWU1+eQA
Lo/tSqWsulrDeJ8dGlctGylBTiaPl9Y12uVbwqqrdeQ7KuVvu+wb39+MPJLH
6Y77T+TDjeSSlR2vkwKLkavJH3WY1KgdRG6UIjdPS/XoHyvCelLyvxraz7eM
f0+RJk9T8jrWrjuew8ktdQLW7J6F7y9byf+t3BLlXIHvfbLkChOf7zt6r5BV
V3Lk0158LhFUKERuJ2+/fvaW5lgBq662kx8SURcryyxAnifXqRZfqWhZwKor
RfKV5wwHvWULkPPJa/8ENib/y2fV1U5yv1n1d07n5CP/k2vxbeS4YY3v47sZ
dbVISqlyRz6+FzDOM46cA5qc+ay6UiHPMXgssrwsD98XyOV2dQfpOuax6kqV
fOO/VdNnHcjDczbJ3ySbBh+alceqq/3kFiNaXcvbcvH9gvF79GJKH77MZdWV
Ovn9bRIa5wyw36AG+dRnR5+Hr8xl1dUhRv1v6jwmOYT+yWHymvBpwj9Tclh1
dYQ8ujdldc/tHHxPYRwXtzzbc3fmsOpKizxWt3z+Tt4cfH8h5zP61lcTmM2q
q+OM405Di2vl6mx8ryHvsw5qdYzDPpC65POSj2/lW5+F7zuM88xzb4Wy8ExW
XemTj5krbm0WycT3IPKUpgu5Jg4ZrLoyIA+K+7Fbtz+dVVenyc/1G12RUEEf
zJBxPm84VFXgm4bvTeQ/xVZMWzycyqorI/LvQb+jtm9LxfcpRj18ePV5qUMK
q66Myb+W5aV8qk3G9yzyL8qL/2TMwX6nJuSTxhLXNuok4fsX+dpn5tpmIYms
urpInvygXvD9cAK+l5HbytsZnFNMYNXVFfJ7WhoSfO7x+L7GqDcz4USeoThW
XZmRD/h7vLy3Pw59ckZO4OCYPhiL5w5fZ/weMbPQ4pnYh/YGufdXz7pesxhW
XVmQ1+Wzd9QlRON7H+P94Z130N0silVXt8hncwdXq0pF4vsgub1jvf7W4XBW
XVmRZ9aXORqFheF7IrnBnGT96mOhrLqyYZyXpJ/K9UzG86Dvkj+vCbbpDQ9i
1dU9Rm4pc7QKVsHzfO3I+y0HRJb0+bPq6j7jOBW/N6R02w/fN8nFbk46NWeW
L6uuHjDyjKBqv4v6S3wPJVfe77xf0vI5q66cGPVwaHpWUagH9mcmX//5UVBv
+1NWXTkzfj5XO95klhu+t5LnSl6Yk6TpwqorV8Z1OaXZy3GrI77PMt7PvaHB
kxvsWHX1hJHfFFZaKZpa43su+ZVdiT09wjdYdeXO8Lc95w+nX8D3X/InfG7C
x60PsurKkzx8x2Y1P80jmOtgnOeTr327kGPKug/oTb5L4mBI7bGbmPcgn/LZ
POzpkDXr/qAPuftLgUtrJO5jDoRxHCWF5+pqO7LuG/qRdwwbFh2Sd8F8CHnD
p+UrRktdWfcTA8nlrcuGn6s9zf7/ugpiXI9KZcql691Z9xmDyQWTnAKnHfHC
PAnj+tLy8DZbrzfr/mMYI+/Z7M3asxn7n4eT6yvy8TjZ+rLuS0YwjtN2iQab
Jj/Mn5C3XjTz2bMmgLWffDS5xP7Uo5aPAjGXwrj+asRf+D4axLqPGUsuPvQ9
iN0gBPMqjPNeX59eZEso6/5mAvlLz/k6FvvDMcfCuK6dFVy4vAz305PJpcoX
Cn1UiMJ8C+P46ljW9yE5mnU/NJWR03I4bA+4Yp//NEZuSfzml70zllVXGYz3
IeL6QYnRWMzDkM/9NOQu6BfHqqss8vz67piZKnjuUg4j76lELz0+GM+qq1zy
C0O7ao3dEjA/w6iTnFlPhtbjOQv55EdixYW3lI/P1ZDv/broUOixJFZdFTGO
X82/bVyvkzBvQ1786aXHkC72xyhhvA/8+RNkm5Ixh0O+XGvq6cgdmF8qJ2+b
uXa/RFQK5nMY7/+KGH+Fmamsuqoi3xay8uxHMzyvp5px/Dr6Ofi0Yp+NGvLH
XtmKbtKYE6slTw+YZv3nWRqrrurJE1XLT+/6hvmxBnInR/mJMw7iOSON5Ftu
8wWyRadj/ofxeqa8GQzgwfPdWhjHtdiT8ivnsB9FKyMPzPLrFqnAnF4beWVV
+++ENdinooNxPGrN5/R8lsmqq05yHhPfE5s4sjBHRO4S4SV3+XoWq656yD8W
HUteO5KF+SLG76+4enf9lWxWXb1inP/dt16v/I45ydfkO5K22RfL5bDq6i2j
rh6FcG60zmHV1TvGefJz3++MwhxWXfUx8vC2IqsJU3Ixp0Tu2f98c7pKLquu
PpL3LBWbXuWYi/klcv6OtztXV+ey6uoz4/pulcxfMy0Pc03kJ+4b73iplseq
q6+M86ptms49pzzMO5G77ZradqUij1VXg+Qx3MvitKbkYw6K8XfdOpbOqZTP
qqsRRv6ZKdjCfjsf81GMz6vvXN2LpHxWXX1nvA9hNhyKn/IxN0V+7d0JnsL5
eN7iT8braVAu0FcpwDwVucjj254WZgWsuvrDeD2t87o1fDFv/JeRlz4fz2cr
LWDV1T9ydsNdafb9mEOesP1/LhYnovB9eiGrriaSp5+r+Ht+A57Py0aeaHdj
jFO9kFVX7OTaWks3BZoWYl6LvGvF8KeuB4WsuppMbni2JmZ1QCHmuMg9dcUz
5qQWsuqKi9xYe9J36bJCzHeRX25WmXewuZBVV1PJ71uJp+n0FGLui1z+tfnn
oLeFrLriI5+zSibaoa8Qz+shV34e0qH3rpBVV/zk/Ad+mpx5VYg5MfJ51tfM
CtoLWXUlQH5I98+Ch3XYt2QmucT8yWdrigpZdTWLvPHJj/DQlELMlZEPOnVH
S4VgLn0O+ZPQlanPnxRi3oz89YH7h3/cwby6EPnOJ9XsV4wKMYdGvk1y4K/J
wUJWXQmTL7u38/AL6ULMp5Ff3Oyk0bOgkFVXC8hbtV4umT4FdbWQXNPnvM/Q
EObeF5FfFwkcWd1dgHk28qkme8RPVBWw6kqM3N5DZSFPbgHm3Mh1pfhm5yYX
sOpKnHw0nWchb3wB5t/Iq3rebjL7z1n9K/Lui6mRcqkFmIsjFzy17pt4QQGr
rlaRb/Ssj/SsL8C8HPn2/FNFQ+8KWHW1htzmvo56zN8CzNGRRxTKzrksiLpa
R744O3N71wbU1QbycM0db+8cRF1tJPdVOSRVcQl1tYk8iuOrw2Q31JUU4304
n7tROXF8vQP5jim9+t6NqCtp8uoZz0LmjoyvgyCvf6UUvpC/iFVXW8nvWN38
fm15Eeb3yGsqpY34txWx6kqO8fkq8ch2qRdhro9c/EEef8ypIlZdbSe/sT1i
7ZZLRZj3I286+eLtDIsiVl0pkodyimwMtRp/zjjjOI19+WS/dRGrrnaS6zfL
zjliOf78cUa9PQl5P+e//5fVvyK/5RD8jE+3CHOD5HmyUieFdhWx6kqFcVxP
mtcQK16EeULyRRf7ZELZilh1pUrucdNNoqkF5ys1cnPzxY49YThf7Wd8jnMn
Hd53HXV1gPySTXdwwA7UlTp5/sqGoAe8qCsN8pe/fp4raChg1dUhcqXYsbb5
Xni+8GFyA27VhON6Bay6OkJeK/hGeccyXAePkuss4nO5NYDny2sxjsdtad+D
0vA8Ym1yIV3Dj7vs8Nz544zrDqcUx3vNfKwrIb/rt2HpzBX5rLrSZdR/d+hM
3Yn5WG9C7qS8PV6/M49VV/rkP13ehsVk5WEdCuP9kRm51RaYx6orA/LUgxwT
jF3zsD6FUYcSsnn1dthHy5C88mZh+xabPKxbIXfXPD/Z9i7W+xiR92sdXWX4
X/5h9a8Yn2O8IPdVb6wDMibfWnWgWjAO+eoCOffogR2B5chXJuRTumxWXf6A
fGXKOK8myBh3c+ez6uoiea7b5EalNchXl8ld3M5FdxxCvrpCXsQ5MdTBEvnq
KvmrMotl/QHIV2bkvw4+dnUsQ74yJ68oXKDO8SWfVVfXGdeX6JAJG6ciX90g
/6yvV3p4CfKVBfmZjZM3j0ghX1mSSz/czBeohHx1i3FeykmetGQf8tUdcpmq
sTP6qgWsurJi1M/VOfy39uA6aE3+j+NpsK8croM25Gvf65h8k8B18C7jOsLB
4xUpiOvgPfLIL6UXV/3BejE7ci57/ttTOvJZdXWfXEu8NX44OR/rfRj/r7Pl
Z1fnfFZdPSC/uX+5u81p7Of2kHH9mvnaWGdLPquunMjjM9Yv7uXJx/NbGce7
s2JRbxfqypl8/0XfbsVY5HYX8gL5TV8abPNYdeVKPibAnymrlYf1RIzXEzpz
O/v6PFZdPSFfEfJC8CZPHtYZka+RPMyZ8yGXVVfu5B2XUs4XleZi/RHjuP4+
cbdVRC6rrjzJL1Tv2jzikov+FXnM7AkGq27kon9FLhAWYiRpkIv+FfmPWEc9
cfVc9K8YuevWOyvJHXjeui/5CasVqZmbsY+fH/nzez8tONbhOez+jPPb3s15
7BLY3y+Q8f8mH7hzZFUu1j2RT1ffecx+dS76V+S2glzu6zfg+2AIIzdqNXCy
bcH3wTBGTk568PiRAr4PhjPy4VP15F178X0wgnF+Zj8ad0MzF/0r8uU7V+pe
0c1F/4qcV8Qmw/5sLvpX5M9GOe4KXcQ6x1jG9UJgrez9a7noX5HHZfjFrbmO
9Y8J5OfTv2kbmueif0Uu27TZxfJyLvpX5EFmMWXNZ1FXKYzjTlbRYscx1FUq
eUn+ZrE1u1FXaeSO6RNSz61DXWWQm2qf+VkniLrKJL96/j0X3x+sr8xivM5N
IQa+XeP7QJLHCohETcrJQf+K8frthTNcfHLQvyJ/f9Gq1OBODvpXjDxcGTZ0
QQd9hkLyFv/7D1xlc1h1VUQ+f4Lq+xIh9BmKyQ8c33R7SX82+leMXHHiD+/r
gGz0r8g7L9tYZB3NRv+K/MizLIN4nmz0rxjnH4OZkd8ysW9nFSMn7Kpk+3E+
C/0rctXJSx7ICWM/zxryPRMbhudXZKJ/RX7KyCk94AbWh9YzcnjDUeXCZZno
X5Gv9JzKeaUpA/0rxvE79Wp/lg32TW1m5Ml1xXz5a8f7V4zj5fUiV8/OdPSv
GNd902V/NBzwXN02ch+rU2MjkunoX5GneYTttn2N/Wk7GedV3QPBh53T0L8i
N9y3Z8tuOexb20Ou1/bP7Gk/1l32kg9ocJ975peK/hV5sIV0u8Wx8ecak3NO
u9qtKJSK/hXj/bf25jPpTsF6OnLhyStOPw3D88f7yB0ClpZZ3khB/4q859t9
9Zh9KehfMerzTuGjkUXoi35i5N6Dro7Hfiajf0Uu4bC+gK8mGf0r8t9TPPIE
gpLRvyLPmu+4Se5GMvpX5JN01/SpqSSjf0We8/l+ovycZPSvyA8npNc69ySh
f8XIye5RlpoBSehfkd84VBTVchLPrf7OqAceHy1Z0ST0rxi5Lusvx/WmRPSv
yAMn6w1dsE9E/4o8ycFXm3dzIvpX5P5u9tVarxLQvyLPbLBd5nAf+0X/I7+T
JSHybUUC+lcK//Of8pzLLpWh3z6R3E19Veo/QzxPnI18kozwK7tJ8ehfkadX
HlnU7ROH/hV5xyT+sVLZOFZdTSa/NGXkEW9HLPpX5CZGG7+oWsSif0Uuq6ut
XSsSi/4VuVpm4xvT/Bj0r8h9VXVi356NQf+KfM8qMdO/02PQvyI/7G8xd59Z
NPpX5NFJur+KK6PQvyLnnea73Vc8Cv0r8kGpnRNP3Y1E/4rx96abCb3vG1//
SN58+PbB2fuxbnQWuftxd/nMrHD0r8hzTI6kum0MR/+KPM3A7LpGXBj6V+TF
rTdsSzaHoX9Ffv236K/wklD0r8glAnMXbtcPRf+KfM0CzsbFHKHoX5FP6Z2s
8DQmBP0r8n3xQqtfnQxB/4r874ha1h2REPSvyOv1ly7n6wlG/4o8Tj/9uFxI
MPpX5JnN7o+nmwWjf8V432ZvE2bbF4z+FbnhfS3elhXB6F+Re/g7ZOtOD0b/
ipxDMOPS/onB6F+R71itm7X3dxD6V+SOh+6q/RoLQv+KvKMjX7xoWjD6V+Qv
tVO0zP97Paz+FXn3q2ZvIbVg9K/Ib4SFVupYBKN/RW5aFCYyKzYY/StyibMz
L27/HIz+FfluleceghIh6F+RP7pSZSZyOQT9K/IV6X/ZHmeFoH9FvsBQcvA0
fyj6V+TKxXU9ZWdRV1vJObeURqaXo65kyX8fD+79LRmG/hX5p70Lf8pEhKF/
RX5ZoH6O8qpw9K8Y7+e1y9HCKVgHrUBurD+R3e6/44vVvyI/q7fg0vVvEehf
kc9KWe4cFIj1vzvJlw411/w8EYX+FbnJ77lbDUSj0b8iV8/j8FF4G43+FXmM
zQWnF4dxvlIhT/+q48WRhfPVXvLe1YHSImKx6F+RxzVNPTr3YSz6V+Tflk1/
KDYUi/4V+ZS+Y0+cNePQv2L8vWerxGpT8Fx4dXKO1o29V+bEo39FvmAiVwDX
1Xj0r8jTevLtp1bFo39FvtD2j9zgogT0r8hdOjceXXg5Af0r8nmTN/99m5mA
/hXj9evN69Jhw3VQm/ymj/h5d/lE9K/Ii7vLIl5cSUT/iny5++Knzj6J6F+R
b1VcZ+qZN/48BfItIwJz2doS0b8iN6gXGFv1DvedT5L/U5GS9n6H+84G5Hq5
klY//6+pO4+qaW/jAC5dDa4oDeYpVwoRStQrkVSGi6JBaaL5NJJEy5WhlKR0
o3muo3nOGZIGZYgMpehmCEfJFRGZ4rXe/fU++0+fZbWOc57z29t3Pd/dz5/D
5Ffkp6Jm5Ms34DkPLuSZjy3LOlMqkV+Rv7Pm2q/xqkR+Ra5qMN1Ge3El8ity
k3Dj/KwePBeCQ/5v8R7Z6OgK5Fes98fM48eKRRXIr8hPSI9eKVlXjvyK/EXy
2CQ3IzxHwpd8v9vIBfX1mKs95AWNXg12S/F8ib3kHapmKhHxpcivyBucD7Wd
+1CC/Ip800PHxQNGJcivyHuCdq/JUsY+QyB5k7+1cvLP7zWTX5HHKlw7bjKl
APkVeePX9X2/h+QhvyKPCI0P+NpzHvkVuaXau2ula7jIr8jHvB43QeZcNvIr
cs31FT7rRejXHyGPK3BbdEA9A/kVeaTulLtd3mnIr8iPuX1PuW+VjPyK3DNr
3qDTdfw+lFDye0fVpfYuOYv8ilzrzaWwtTFnkF+RX555p7+46xTyK3KRQVJH
fHgI8ivynCk3kt84H0J+RZ7fp5ek6eaN/Iq8dU9zf6u+BvIr8jPPtndzTTyw
f0Vep6Ktb7kqCPtX5FI8P8f5Dsexf0UunCyQKYmKwP4V+SEHvcq+1mjsX5Er
WMXc1Nsai/0r8h388LqmS3HYvyK/c8r67JUZSdi/Io8oE9c/4JuKXhK57Ktj
3XY70pm9vmRyed2IYxWDGegrkTs7H9pWE5rF7PWlkacbLnmeKp+DHhO53Sy5
65FxXGavL4P8E6ftSp0S9voyyW+W6iU6ReYxe33Z5NdMHtgm/8hH74m8zcv3
Q6h7IbPXxyVPe78k1PhWEfpQ5C9mte3+rlTC7PXlsf7+P1/8jBp+9dDJ89pF
s4w4pcxeXwG55cRpH9PlytCfYv38zKzAobIyZq+vmDxSjrfm3eZy9KrIQzf/
Lbamt5yZq1LynPANOZEHsS9aznqfX/WE+ElXMnNVQZ4QbFAcHF2JHha5eM1b
MVP5KmauLpDHLpyw6VBkFfrv5AGDfvO4Iy8wc8Und94fctbH+wJ6W+Q2bWnV
p9suMHNVTa7915MpA4t56HORFy26eOlaKI+ZqxryvtwToXvbf/XoyUsltQbW
Tuczc1VHLsbb07zf7le/nnydyq2begl8Zq4aWK9fXCGkqYWPXhj5MuXNcubD
fGaumshX6ySWOKkI0BcjH76XKl+4HnvIV8n3//XbHEkPAXpk5MmWMgeNTgiY
uWomt9fXt52VKUC/jPX3eWaNs6oFzFy1kNclGV4UtAqYubpFHiDjf8igT8DM
1W3yb43dHZ0/BOijkVc59JfuVBAyc9VKvk9aYt7JuUL01MibCqTS568QMnN1
j7zx85TySSZC9NfIix7POLjcQsjM1X3y7BIZdZddQvTayD1FKo2BnkJmrjrJ
/1iR26zrL0TfjTzS8pyW3wEhM1cPyWMnJCt2BAnRg2O9flEuZ9JP/9+fnrDe
T1FSgyhAiH4c+arcOe393kJmrp6Sr9UMr3398/Uz+RW5i7nXcKqZkJkrEfm2
i0pzHugJ0acjv2x0/F32HOy395Brq9lomUoJ0bMj/2fugP/aHsxVH/nmM3zD
e/WYq1fkW8vstTUTMVf/kqduN65x9MFc9ZMbu0eO3LQGc/WG9fp35U3tlcVc
vSU3D1zXqdPFZ+ZqgDwkcbavRRYfPT7y9c5GHpvd+MxcDZIv2XJbbN58Pvp9
5C8ME/zfvuQxczVE/iSoT70lm4ffG0getEJ88Rw7HjNXn8kLLuVYH1TioQ9I
fsWnf63FDZxX38hn5xcGLwjG8z2GybNlP4bZaF1g5uo7OSfXqXTtyyr0Bw3+
75fsMvbpJlehP0hu6tlqcXRrFfqD5NWJM19vkKhCf5D8hOr34GphJfqD5D3u
UZrDvpXMXEmQD3nkFq1Qq0R/kPyPr0WaSd0V6A+S9ylXNmolVqA/SD4c75v9
eHsF+oPkMvwTynpyFegPko8KLt8nulGO/iB5p/KSoYAT5egPkut6VHvkG+A6
KEt+3PsvHf3vZegPkk86/DZ/8EIZ+oPkXYtHlR/yKUN/kHzPLUlO1Nwy9AfJ
VUPVqx52laI/SG5emtCpFlWK/iB5W0uas+9q9CYmkbvYyXXIDJSgP0j+mW+q
kZyK3sRU8vTRus8aNpWgP0juU9Q+T+ZTMfqDrM+rKd05YXsx+oPkSzV9ugYq
itAfJD8/NVz+pVIR+oPkC27/LuQEFaI/SB56dGeh74sC9AfJtb3VE2u3F+A5
GOQCI29h7PV89AfJF8am9vutzUd/kPW57EhNdK3PQ3+QXKKZ+yPcIA/9QXK7
yIGERVdy0R8kn+i0xrJrYy76g+R/byhtUm07j/4geYa+YH69zXn0B8n1eVob
97/goj9I/lu68urlvlz0B8krAobuDn7LQX+QvPX9d1FMWA76g+SHpV5LflDK
QX+Q/Gu+0GM4Kxv9QXKrsDtSZ5dmoz9IvoY3Ijm1Pgv9QfIPxu9burdmoT9I
Psb8wYrR3ZnoD5LHyj2dWe+dif4g+WgXkXbNcAb6g+STO3mcmvAM9AfJjQpO
B59UykB/kHzaQ67Fm7R09AfJ6yY4vC5RS0d/kNw5yVQnqSSNmat15MZTcppP
aaWhP0hetO6N9bif/09h8ivyP4cby1z2pKA/yJrDb90+MX7J6A+SHx046Tzg
lYT+IPmDT5b5ja6J6A+y5ly0jG9sn4D+ILncXhddwfZ49AfJv7gG2DuZxKE/
SP7vwTSHeN1z6A+SXz95+HbjgrPoD5JbB3Det0+LRX+Q3KPqUpCX7N/oD7LO
Nx8bxRSJGPQHyZdLiLfvHnkG/UHWOSD1qs1qVDT6g+T3z386flA2Cv1BcrGJ
GYYWxpHoD5KfLk8VfDocgf4g+d2eQP0JzeHoD5Ln2rdnb50bhv4g67qgE7Up
/mwo+oOseXB0HZ49OQT9QXKF2kRJ2/Jj6A+Sfxv7NjJ311E8X4X1/gfZjx2c
fwT9QXKboz5vF40JRn+Q9f11HT6tKX4Y/UHyGr3553OmH0J/kHyRt02vkm0Q
+oPk3Magjqj6A+gPkj/SzPN0XR+I/iD5QMyf/KfvA9AfZL1vOZ5i/dX70B8k
Nzkz02l5pj/6g+R54xT9XLP2oj9IHm/leXVjzR70B8nvPdPOHOr3Q3+QPFEt
5vf7mn7oD7LOTxkxw5pIX/QHWfc5tQ8Gz3/1QX+QNW/Gj1WiD/igP0he38Z9
bjnaB/1B8gv23gU1Zt7oD7K+L1N8Z6uXeKE/SG4f9HmkoqoX+oPkZpnVnGq+
J/qDrH+vdFnJsKMn+oOs79ejaimNmZ7oD7Kup4JXFa2vOMxchbDOyXv33udc
4qA/yJoTObEDn2M56A+Sf1zoMtPNnYP+IPkEZYdFXB0O+oPk4mUrt9VKcNAf
JE+JuiMjftsD/UHyh94rbaPPeaA/SP7c84b1lZ0e6A+SP64s33pQ+Vd+Rf7X
vBWiKJE78ivW5+Uquc2C6478inzD0OZxjq7uyK/I3e0eZYlU3ZFfsa5rq/7c
Mq/XDfkV+fs3L5cUZrkhv2JdZ8N9c67ZuCG/Ip++N01Vd5wb8ityyYUhKWpC
V+RX5Dpyj78M2LkivyK3aFaxG/jmgvyK/GLsDKuUaBfkV6zzKjzSSXq6C/Ir
8svW0x9Nz3RGfkX+RnVyyyZlZ+RXrOtFBK9WMtkJ+RXr+/Kly/mEghPyK9b7
Mxin8DJsN/Ir1v2kphVP4/su5Fesc89NxmuH3y7kV+Qjbs5Nte1xRH5Fzruy
MEnN1hH5FbmW15iK4x0OyK9Y93Xyn+W6zRyQX5FrcFcVS7faI79iXa+DP44w
2maP/Ip8fPW3H2GFdsivyIOGXqrcLLdFfkUeWH1fmCnYifyKdb3mjvOPq7NB
fsW6D0ysvapx1Rr5FXmLrnnD45s7kF+xrqfXJwgm37VCfsW6rygZf3V/myXy
K9b8m76Y1tRmgfyKdT3q1dst12qO/IrcO8EvPf/WduRX5NciK2Olm7chvyIv
LN5/NL3RDPkV6z5qkrXE00umyK/I1179LKsj2Ir8inWd4m7onVm5BfkVuW1v
hq2242bkV+QGqg52gTs3Ib9i3VecmrRg8s4NyK/It+y+++yMgwnyK9Z1Tdoq
2cfdCPkV+Qy3+i/X9hkiv2Kde+dVrdeFGCC/Ilc2n+q3L2E18ivWeXv142GR
1yrkV+Qd9i+qNjbqIr8i9+v9uqxh9XLkV6xzQ6Gu/XGfJvIr8rYBJ40Tlxcj
v2J9LrJXCtUy1JFfsc7PI6dSCv5QRX7FOsfk4448kZ+N/Ip1f6u6TSP1+VTk
V6z7KKdp482OKCC/Io8Rja0J+CGN/Ip8pfnwUmnHz3pMfkXecPjaA8PaWj0m
vyLPXtT8xXrEuxomv2KdP6UtjWGhYti/Itf9MjzrXYYU9q/Id7q4mC7zGYv9
K/I5/pNaJobKYf+K/K2sVL7zRnnsX5Ebmn+aI4pRwP4V+bmBJYPPXRSxf0U+
8tSEs4/uKGL/ivw/vRq74joVsX9FnvPVSOxumCL2r8i7f2QWj3yhgP0rct/g
6lk+g/LYvyKPmHQ6MIA/HvtXrHN12W5R43I57F+x7hPk5/c/7xuL/SvyURpy
O3Sej8b+Fbm69/Lx1o4S2L8ifz3baouTuxj2r8jHvtzw5cFvn2qY/Ip137ji
wE3/pt4aJr8iL5jfvbLQ6OZ/mPyK/L/rnfbb
        "], 
       Attributes[$CellContext`timeiv$65018] = {
        Temporary}, $CellContext`timeiv$65018 = 20, 
       Attributes[$CellContext`buildingresp3D$65018] = {
        Temporary}, $CellContext`buildingresp3D$65018 = CompressedData["
1:eJxU3Xc8Vo/7P3B7a6pUMkuDpnYKlYakRUmFdmkQkbRUSlMqpYEQUqmERGZG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        "], 
       Attributes[$CellContext`spheresize$65018] = {
        Temporary}, $CellContext`spheresize$65018 = 0.5, 
       Attributes[$CellContext`inptrace1D$65018] = {
        Temporary}, $CellContext`inptrace1D$65018 = CompressedData["
1:eJwcV3c81d//V5GMSpKMQokUopRZXqL6SCQaKCuhzERGIisrlD2SvVdcex97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        "], 
       Attributes[$CellContext`posdamper$65018] = {
        Temporary}, $CellContext`posdamper$65018 = -3, 
       Attributes[$CellContext`swayingCylinder$65018] = {
        Temporary}, $CellContext`swayingCylinder$65018[
         Pattern[$CellContext`t$, 
          Blank[]]] := Partition[
         Table[
          
          With[{$CellContext`pt$ = {
             0., 0., Floor[($CellContext`z$65018 - 1)/
                2] + $CellContext`d$65018 (-1)^$CellContext`z$65018}}, {(
              1/$CellContext`nz$65018) $CellContext`scale$65018 
             Part[$CellContext`pt$, 3] 
             Exp[Part[$CellContext`pt$, 3]/$CellContext`nz$65018] (
              Part[$CellContext`responseOfSDOFoscillator$65018, \
$CellContext`t$] - Part[$CellContext`inptrace1D$65018, $CellContext`t$]) + 
            Part[$CellContext`inptrace1D$65018, $CellContext`t$], 
            Part[$CellContext`pt$, 2], 
            Part[$CellContext`pt$, 3]}], {$CellContext`z$65018, 
           2 $CellContext`height$65018}], 2], 
       Attributes[$CellContext`t$] = {Temporary}, 
       Attributes[$CellContext`pt$] = {Temporary}, 
       Attributes[$CellContext`z$65018] = {Temporary}, 
       Attributes[$CellContext`d$65018] = {Temporary}, $CellContext`d$65018 = 
       0.5, Attributes[$CellContext`nz$65018] = {
        Temporary}, $CellContext`nz$65018 = 6, 
       Attributes[$CellContext`scale$65018] = {
        Temporary}, $CellContext`scale$65018 = 0.4361996229216517, 
       Attributes[$CellContext`responseOfSDOFoscillator$65018] = {
        Temporary}, $CellContext`responseOfSDOFoscillator$65018 = \
CompressedData["
1:eJwsWnk0Vd/7vua5JEnIWBQqISH1HkRl7CMiFUqppMiUaJAUSpKIMoSQZCaZ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