(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Wolfram 14.2' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       154,          7]
NotebookDataLength[  32687345,     643904]
NotebookOptionsPosition[  32480670,     640310]
NotebookOutlinePosition[  32517064,     641027]
CellTagsIndexPosition[  32516491,     641006]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "Chapter 5 Figures & Tables for ",
 StyleBox["Fundamental Concepts of \nProbabilistic Seismic Hazard Analysis ", 
  "Subtitle",
  FontSize->48]
}], "Title",
 CellChangeTimes->{{3.947391415550271*^9, 3.947391424639997*^9}, 
   3.947393193223259*^9, {3.95189962865685*^9, 3.9518996357662354`*^9}, {
   3.955792481086474*^9, 
   3.955792482091988*^9}},ExpressionUUID->"b99c0fc9-af8f-454b-ba56-\
360e80e2d96a"],

Cell[CellGroupData[{

Cell["Warranty Disclaimer", "Section",
 CellChangeTimes->{{3.95162435258323*^9, 3.951624383820673*^9}, {
  3.9516668189919157`*^9, 3.951666836375389*^9}, {3.951718418324568*^9, 
  3.951718418763173*^9}, {3.951730306823305*^9, 3.951730313723783*^9}, {
  3.95173243157547*^9, 3.9517324338531847`*^9}, {3.951733794512895*^9, 
  3.9517337992616243`*^9}},ExpressionUUID->"406d69e8-5f63-4384-9143-\
459b0a5cd393"],

Cell["\<\
This software is provided \[OpenCurlyDoubleQuote]as is,\
\[CloseCurlyDoubleQuote] without any express or implied warranties, including \
but not limited to warranties of merchantability, fitness for a particular \
purpose, or non-infringement. In no event shall the author be liable for any \
claim, damages, or other liability arising from the use or inability to use \
this software. Use at your own risk.\
\>", "Text",
 CellChangeTimes->{{3.951733887645832*^9, 3.951733900624896*^9}, {
   3.951789880822382*^9, 3.951789882112493*^9}, 
   3.951899289915662*^9},ExpressionUUID->"f5cde957-d66f-441c-82a7-\
3b0ba3368e06"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["General definitions", "Section"]], "Chapter",
 CellChangeTimes->{{3.551606318467031*^9, 3.5516063376815357`*^9}, {
   3.551606927739052*^9, 3.551606929779048*^9}, {3.551607356500638*^9, 
   3.551607362899152*^9}, {3.5516077024987803`*^9, 3.551607709561294*^9}, 
   3.9473904389895573`*^9, {3.9473935757603807`*^9, 3.947393577947782*^9}, {
   3.9518991962427473`*^9, 3.951899202707754*^9}, {3.955785512871771*^9, 
   3.9557855200443907`*^9}},ExpressionUUID->"ac2c09ed-c9ed-49fa-bf86-\
8edde09ea6f2"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"iSize", "=", " ", "350"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"labFontSize", " ", "=", " ", "14"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"fs", " ", "=", " ", "20"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ls", " ", "=", " ", "15"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ff", " ", "=", " ", "\"\<Times\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ms", " ", "=", " ", "10"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"$MultiDistRefFileDir", "=", 
  RowBox[{"NotebookDirectory", "[", "]"}]}]}], "Input",
 CellChangeTimes->{{3.5517713586813107`*^9, 3.5517714849521017`*^9}, {
   3.551771951043*^9, 3.551771956466942*^9}, 3.551772077751997*^9, {
   3.5520223809767*^9, 3.5520224480666533`*^9}, {3.552029639239017*^9, 
   3.552029655604446*^9}, {3.552029764413485*^9, 3.5520297822572937`*^9}, {
   3.552030322982337*^9, 3.55203032356559*^9}, {3.552099179603568*^9, 
   3.552099186634179*^9}, {3.572088103250422*^9, 3.572088117389421*^9}, 
   3.572088703842696*^9, {3.572333339064139*^9, 3.572333339384529*^9}, {
   3.572424962365041*^9, 3.57242496329135*^9}, {3.9473904694386044`*^9, 
   3.947390469716896*^9}, {3.947390578614436*^9, 3.947390610428872*^9}, {
   3.951972615608345*^9, 3.951972618290917*^9}, {3.95215286388087*^9, 
   3.952152864333845*^9}},
 CellLabel->"In[22]:=",ExpressionUUID->"c497e324-27a1-4079-bf49-a93760ed3836"],

Cell[BoxData["\<\"/Users/fs/Paclets/FCPSHA/FundConcOfPSHA/WolframMedia/\
Chapter5/\"\>"], "Output",
 CellChangeTimes->{3.952152866086093*^9, 3.9557855648356857`*^9},
 CellLabel->"Out[28]=",ExpressionUUID->"48585c93-e768-4180-a39d-56484cab9c7e"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Code for GMMs", "Section",
 CellChangeTimes->{{3.951974637300342*^9, 3.9519746565799713`*^9}, {
  3.95578491807878*^9, 
  3.955784919320737*^9}},ExpressionUUID->"643e0a2c-8e2a-4e36-973a-\
2e722fcbcaa3"],

Cell[CellGroupData[{

Cell["InterpolateCoefficientList", "Subsubsection",
 CellChangeTimes->{{3.9519747461859493`*^9, 
  3.951974753661378*^9}},ExpressionUUID->"31afe080-82e8-4320-9b97-\
115fafb61798"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"ilenALL", "=", "0"}], ";"}], " ", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"interpolation", " ", "window"}], "=", 
    RowBox[{
     RowBox[{"2", "*", "ilen"}], "+", "1"}]}], "*)"}]}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"ipolorderALL", "=", "1"}], ";"}], " ", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"interpolation", " ", "order"}], ",", 
    RowBox[{"default", " ", "3"}]}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{" ", 
  RowBox[{
   RowBox[{"ipolTypeAll", "=", "\"\<LOGLIN\>\""}], ";"}]}]}], "Input",
 CellChangeTimes->{3.95197515542708*^9},
 CellLabel->"In[29]:=",ExpressionUUID->"45fe37f7-af60-46f7-b816-1edd115d70f4"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"InterpolateCoefficientList", "::", "usage"}], 
   "=", "\"\<InterpolateCoefficientList[x,xlist,ylist] performs an \
interpolation of the data values ylist (defined at the positions given in \
xlist) at position x. For a given x, the module performs a piecewise \
polynomial interpolation between the closest coefficients. The length of the \
interpolation window is controlled by the Option IpolWindowLength (default 3; \
window length = 2 * IpolWindowLength +1), the order of the polynomial by the \
Option IpolOrder (default 3) and the type of interpolation by the option \
IpolType (\\\"LOGLIN\\\" or \\\"LINLIN\\\"; default \\\"LOGLIN\\\").\>\""}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"IpolHalfWindowLength", "::", "usage"}], 
   "=", "\"\<IpolHalfWindowLength is an option for \
InterpolateCoefficientList. Default value 3; window length = 2 * \
IpolHalfWindowLength + 1.\>\""}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"IpolOrder", "::", "usage"}], 
   "=", "\"\<IpolOrder is an option for InterpolateCoefficientList. Default \
value 3.\>\""}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"IpolType", "::", "usage"}], 
   "=", "\"\<IpolType is an option for InterpolateCoefficientList which can \
be  \\\"LOGLIN\\\" or \\\"LINLIN\\\". Default \\\"LOGLIN\\\".\>\""}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.951974660087632*^9, 3.951974689285653*^9}, {
  3.951974879056468*^9, 3.951974888041625*^9}, {3.951975125958349*^9, 
  3.9519751618984203`*^9}},
 CellLabel->"In[32]:=",ExpressionUUID->"19790c8e-c620-4c5e-8727-493989abfa71"],

Cell[BoxData[
 RowBox[{
  RowBox[{
  "(*", "****************************************************************************)"}\
], 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Options", "[", "InterpolateCoefficientList", "]"}], "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"IpolHalfWindowLength", "->", "3"}], ",", 
       RowBox[{"IpolOrder", "->", "3"}], ",", 
       RowBox[{"IpolType", "->", "\"\<LOGLIN\>\""}]}], "}"}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"InterpolateCoefficientList", "[", 
      RowBox[{"xval_", ",", "xlist_", ",", "zlist_", ",", "opts___"}], "]"}], 
     ":=", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "len", ",", "startindex", ",", "endindex", ",", "data", ",", "f", ",",
          "xsel", ",", "xsel0", ",", "ysel0", ",", "datasel", ",", "ysel", ",",
          "minX", ",", "minY", ",", "xmin", ",", "xmax", ",", "ymin", ",", 
         "ymax", ",", "ilen", ",", "ipolorder", ",", "ipoltype", ",", 
         "logres", ",", "res"}], "}"}], ",", 
       RowBox[{
        RowBox[{"minX", "=", "0.001"}], ";", "\[IndentingNewLine]", 
        RowBox[{"minY", "=", "0.001"}], ";", "\[IndentingNewLine]", 
        RowBox[{"len", "=", 
         RowBox[{"Length", "[", "xlist", "]"}]}], ";", "\[IndentingNewLine]", 
        
        RowBox[{
         RowBox[{"{", 
          RowBox[{"ilen", ",", "ipolorder", ",", "ipoltype"}], "}"}], "=", 
         RowBox[{
          RowBox[{
           RowBox[{"{", 
            RowBox[{
            "IpolHalfWindowLength", ",", "IpolOrder", ",", "IpolType"}], 
            "}"}], "/.", " ", 
           RowBox[{"{", "opts", "}"}]}], "/.", " ", 
          RowBox[{"Options", "[", "InterpolateCoefficientList", "]"}]}]}], ";",
         "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"Order", "[", 
            RowBox[{
             RowBox[{"xlist", "[", 
              RowBox[{"[", "1", "]"}], "]"}], ",", 
             RowBox[{"xlist", "[", 
              RowBox[{"[", "len", "]"}], "]"}]}], "]"}], ">", "0"}], ",", 
          RowBox[{"(*", 
           RowBox[{"increasing", " ", "periods", " ", "in", " ", "list"}], 
           "*)"}], 
          RowBox[{
           RowBox[{"startindex", "=", "1"}], ";", "\[IndentingNewLine]", 
           RowBox[{"While", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"xval", ">=", 
               RowBox[{"xlist", "[", 
                RowBox[{"[", "startindex", "]"}], "]"}]}], "&&", 
              RowBox[{"startindex", "<", "len"}]}], ",", 
             RowBox[{"startindex", "++"}]}], "]"}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"startindex", ">", "1"}], ",", 
             RowBox[{"startindex", "--"}]}], "]"}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"endindex", "=", 
            RowBox[{"startindex", "+", "1"}]}], ";"}], ",", 
          RowBox[{"(*", 
           RowBox[{"decreasing", " ", "periods"}], "*)"}], 
          RowBox[{
           RowBox[{"startindex", "=", "1"}], ";", "\[IndentingNewLine]", 
           RowBox[{"While", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"xval", "<=", 
               RowBox[{"xlist", "[", 
                RowBox[{"[", "startindex", "]"}], "]"}]}], "&&", 
              RowBox[{"startindex", "<", "len"}]}], ",", 
             RowBox[{"startindex", "++"}]}], "]"}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"startindex", ">", "1"}], ",", 
             RowBox[{"startindex", "--"}]}], "]"}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"endindex", "=", 
            RowBox[{"startindex", "+", "1"}]}], ";"}]}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"startindex", "=", 
         RowBox[{"Max", "[", 
          RowBox[{
           RowBox[{"startindex", "-", "ilen"}], ",", "1"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"endindex", "=", 
         RowBox[{"Min", "[", 
          RowBox[{
           RowBox[{"endindex", "+", "ilen"}], ",", "len"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{
          RowBox[{"Print", "[", 
           
           RowBox[{"\"\<START: \>\"", ",", "startindex", 
            ",", "\"\< ENDINDEX: \>\"", ",", "endindex"}], "]"}], ";"}], 
         "*)"}], 
        RowBox[{"(*", 
         RowBox[{
          RowBox[{
           RowBox[{"OLD", " ", "CODE", "\[IndentingNewLine]", 
            RowBox[{"(*", 
             RowBox[{
             "determine", " ", "start", " ", "and", " ", "end", " ", 
              "index"}], "*)"}], " ", "closest"}], "=", 
           RowBox[{
            RowBox[{"Ordering", "[", 
             RowBox[{"Abs", "[", 
              RowBox[{"xlist", "-", "xval"}], "]"}], "]"}], "[", 
            RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"(*", 
           RowBox[{
            RowBox[{"Print", "[", 
             RowBox[{"\"\<CLOSEST: \>\"", ",", "closest"}], "]"}], ";"}], 
           "*)"}], 
          RowBox[{"(*", 
           RowBox[{
           "position", " ", "of", " ", "closest", " ", "x", " ", "value"}], 
           "*)"}], 
          RowBox[{"(*", 
           RowBox[{
           "search", " ", "direction", " ", "for", " ", "next", " ", 
            "index"}], "*)"}], 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"Sign", "[", 
               RowBox[{"xval", " ", 
                RowBox[{"xlist", "[", 
                 RowBox[{"[", "closest", "]"}], "]"}]}], "]"}], ">", "0"}], "&&", 
             RowBox[{
              RowBox[{"Abs", "[", "xval", "]"}], ">", 
              RowBox[{"Abs", "[", 
               RowBox[{"xlist", "[", 
                RowBox[{"[", "closest", "]"}], "]"}], "]"}]}]}], ",", 
            RowBox[{"dir", "=", "1"}], ",", 
            RowBox[{"dir", "=", 
             RowBox[{"-", "1"}]}]}], "]"}], ";", "\[IndentingNewLine]", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"dir", "==", 
             RowBox[{"-", "1"}]}], ",", 
            RowBox[{"closest", "-=", "1"}]}], "]"}], ";", 
          RowBox[{"(*", 
           RowBox[{
            RowBox[{
            "if", " ", "xvalue", " ", "is", " ", "below", " ", "center", " ", 
             "index"}], ",", 
            RowBox[{
            "reduce", " ", "center", " ", "index", " ", "by", " ", "one"}], ",", 
            RowBox[{
             RowBox[{"otherwise", " ", "for", " ", "ilen"}], "=", 
             RowBox[{
             "0", " ", "extrapolation", " ", "will", " ", "be", " ", "done", " ",
               "too", " ", "often", " ", "from", " ", "neigboring", " ", 
              "intervals"}]}]}], "*)"}], 
          RowBox[{"(*", 
           RowBox[{
            RowBox[{"Print", "[", 
             RowBox[{"\"\<DIR: \>\"", ",", "dir"}], "]"}], ";"}], "*)"}], 
          RowBox[{"startindex", "=", 
           RowBox[{"Min", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Max", "[", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"closest", "-", "ilen"}], ",", "1"}], "}"}], "]"}], ",", 
              RowBox[{"len", "-", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"2", "*", "ilen"}], "+", "1"}], ")"}]}]}], "}"}], 
            "]"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"endindex", "=", 
           RowBox[{"startindex", "+", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", "*", "ilen"}], "+", "1"}], ")"}]}]}], ";"}], 
         "*)"}], 
        RowBox[{"xmin", "=", 
         RowBox[{"xlist", "[", 
          RowBox[{"[", "startindex", "]"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"xmax", "=", 
         RowBox[{"xlist", "[", 
          RowBox[{"[", "endindex", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"ymin", "=", 
         RowBox[{"zlist", "[", 
          RowBox[{"[", "startindex", "]"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"ymax", "=", 
         RowBox[{"zlist", "[", 
          RowBox[{"[", "endindex", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{
          RowBox[{"Print", "[", 
           
           RowBox[{"\"\<START: \>\"", ",", "startindex", 
            ",", "\"\< STOP: \>\"", ",", "endindex"}], "]"}], ";"}], "*)"}], 
        RowBox[{"data", "=", 
         RowBox[{"Take", "[", 
          RowBox[{
           RowBox[{"Transpose", "[", 
            RowBox[{"{", 
             RowBox[{"xlist", ",", "zlist"}], "}"}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"startindex", ",", "endindex"}], "}"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"Which", "[", 
         RowBox[{
          RowBox[{"ipoltype", "===", "\"\<LOGLIN\>\""}], ",", 
          RowBox[{
           RowBox[{"xsel0", "=", 
            RowBox[{
             RowBox[{"Transpose", "[", "data", "]"}], "[", 
             RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"(*", 
            RowBox[{
             RowBox[{"For", "[", 
              RowBox[{
               RowBox[{"i", "=", "1"}], ",", 
               RowBox[{"i", "<=", 
                RowBox[{"Length", "[", "xsel0", "]"}]}], ",", 
               RowBox[{"i", "++"}], ",", 
               RowBox[{
                RowBox[{"If", "[", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"xsel0", "[", 
                    RowBox[{"[", "i", "]"}], "]"}], "<=", "minX"}], ",", 
                  RowBox[{"xsel0", "=", 
                   RowBox[{"ReplacePart", "[", 
                    RowBox[{"xsel0", ",", "minX", ",", "i"}], "]"}]}]}], 
                 "]"}], ";"}]}], "]"}], ";"}], "*)"}], 
           RowBox[{"xsel0", "=", 
            RowBox[{
             RowBox[{
              RowBox[{"Max", "[", 
               RowBox[{"#", ",", "minX"}], "]"}], "&"}], "/@", "xsel0"}]}], ";",
            "\[IndentingNewLine]", 
           RowBox[{"xsel", "=", 
            RowBox[{"Log", "[", 
             RowBox[{"10", ",", "xsel0"}], "]"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"ysel", "=", 
            RowBox[{
             RowBox[{"Transpose", "[", "data", "]"}], "[", 
             RowBox[{"[", "2", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"datasel", "=", 
            RowBox[{"Transpose", "[", 
             RowBox[{"{", 
              RowBox[{"xsel", ",", "ysel"}], "}"}], "]"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"ilen", "==", "0"}], ",", 
             RowBox[{
              RowBox[{"res", "=", 
               RowBox[{"ymin", "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"ymax", "-", "ymin"}], ")"}], " ", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"Log", "[", 
                    RowBox[{"10", ",", "xval"}], "]"}], "-", 
                    RowBox[{"Log", "[", 
                    RowBox[{"10", ",", "xmin"}], "]"}]}], ")"}], "/", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"Log", "[", 
                    RowBox[{"10", ",", "xmax"}], "]"}], "-", 
                    RowBox[{"Log", "[", 
                    RowBox[{"10", ",", "xmin"}], "]"}]}], ")"}]}]}]}]}], ";", 
              "\[IndentingNewLine]", 
              RowBox[{"(*", 
               RowBox[{
                RowBox[{"Print", "[", 
                 
                 RowBox[{"\"\<xmin: \>\"", ",", "xmin", ",", "\"\< ymin: \>\"",
                   ",", "ymin", ",", "\"\< xmax: \>\"", ",", "xmax", 
                  ",", "\"\< ymax: \>\"", ",", "ymax", ",", "\"\< x: \>\"", ",",
                   "xval", ",", "\"\< res: \>\"", ",", "res"}], "]"}], ";"}], 
               "*)"}], 
              RowBox[{"Return", "[", "res", "]"}], ";"}], ",", 
             RowBox[{
              RowBox[{"f", "=", 
               RowBox[{"Interpolation", "[", 
                RowBox[{"datasel", ",", 
                 RowBox[{"InterpolationOrder", "->", "ipolorder"}]}], "]"}]}],
               ";", "\[IndentingNewLine]", 
              RowBox[{"Return", "[", 
               RowBox[{"f", "[", 
                RowBox[{"Log", "[", 
                 RowBox[{"10", ",", "xval"}], "]"}], "]"}], "]"}], ";"}]}], 
            "]"}], ";"}], ",", 
          RowBox[{"ipoltype", "===", "\"\<LOGLOG\>\""}], ",", 
          RowBox[{
           RowBox[{"xsel0", "=", 
            RowBox[{
             RowBox[{"Transpose", "[", "data", "]"}], "[", 
             RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"xsel0", "=", 
            RowBox[{
             RowBox[{
              RowBox[{"Max", "[", 
               RowBox[{"#", ",", "minX"}], "]"}], "&"}], "/@", "xsel0"}]}], ";",
            "\[IndentingNewLine]", 
           RowBox[{"xsel", "=", 
            RowBox[{"Log", "[", 
             RowBox[{"10", ",", "xsel0"}], "]"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"ysel0", "=", 
            RowBox[{
             RowBox[{"Transpose", "[", "data", "]"}], "[", 
             RowBox[{"[", "2", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"ysel0", "=", 
            RowBox[{
             RowBox[{
              RowBox[{"Max", "[", 
               RowBox[{"#", ",", "minY"}], "]"}], "&"}], "/@", "ysel0"}]}], ";",
            "\[IndentingNewLine]", 
           RowBox[{"ysel", "=", 
            RowBox[{"Log", "[", 
             RowBox[{"10", ",", "ysel0"}], "]"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"datasel", "=", 
            RowBox[{"Transpose", "[", 
             RowBox[{"{", 
              RowBox[{"xsel", ",", "ysel"}], "}"}], "]"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"ilen", "==", "0"}], ",", 
             RowBox[{
              RowBox[{"logres", "=", 
               RowBox[{
                RowBox[{"Log", "[", 
                 RowBox[{"10", ",", "ymin"}], "]"}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"Log", "[", 
                    RowBox[{"10", ",", "ymax"}], "]"}], "-", 
                   RowBox[{"Log", "[", 
                    RowBox[{"10", ",", "ymin"}], "]"}]}], ")"}], " ", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"Log", "[", 
                    RowBox[{"10", ",", "xval"}], "]"}], "-", 
                    RowBox[{"Log", "[", 
                    RowBox[{"10", ",", "xmin"}], "]"}]}], ")"}], "/", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"Log", "[", 
                    RowBox[{"10", ",", "xmax"}], "]"}], "-", 
                    RowBox[{"Log", "[", 
                    RowBox[{"10", ",", "xmin"}], "]"}]}], ")"}]}]}]}]}], ";", 
              "\[IndentingNewLine]", 
              RowBox[{"Return", "[", 
               RowBox[{"Power", "[", 
                RowBox[{"10", ",", "logres"}], "]"}], "]"}], ";"}], ",", 
             RowBox[{
              RowBox[{"f", "=", 
               RowBox[{"Interpolation", "[", 
                RowBox[{"datasel", ",", 
                 RowBox[{"InterpolationOrder", "->", "ipolorder"}]}], "]"}]}],
               ";", "\[IndentingNewLine]", 
              RowBox[{"Return", "[", 
               RowBox[{"Power", "[", 
                RowBox[{"10", ",", 
                 RowBox[{"f", "[", 
                  RowBox[{"Log", "[", 
                   RowBox[{"10", ",", "xval"}], "]"}], "]"}]}], "]"}], "]"}], 
              ";"}]}], "]"}], ";"}], ",", 
          RowBox[{"ipoltype", "===", "\"\<LINLIN\>\""}], ",", 
          RowBox[{"(*", "LINLIN", "*)"}], 
          RowBox[{
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"ilen", "==", "0"}], ",", 
             RowBox[{
              RowBox[{"res", "=", 
               RowBox[{"ymin", "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"ymax", "-", "ymin"}], ")"}], " ", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"xval", "-", "xmin"}], ")"}], "/", 
                  RowBox[{"(", 
                   RowBox[{"xmax", "-", "xmin"}], ")"}]}]}]}]}], ";", 
              "\[IndentingNewLine]", 
              RowBox[{"Return", "[", "res", "]"}], ";"}], ",", 
             RowBox[{
              RowBox[{"f", "=", 
               RowBox[{"Interpolation", "[", 
                RowBox[{"data", ",", 
                 RowBox[{"InterpolationOrder", "->", "ipolorder"}]}], "]"}]}],
               ";", "\[IndentingNewLine]", 
              RowBox[{"Return", "[", 
               RowBox[{"f", "[", "xval", "]"}], "]"}], ";"}]}], "]"}], 
           ";"}]}], "]"}], ";"}]}], "]"}]}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.951974693048994*^9, 3.951974693050585*^9}},
 CellLabel->"In[36]:=",ExpressionUUID->"68ff42d5-d6d3-4de5-9271-819599b3fc72"]
}, Closed]],

Cell[CellGroupData[{

Cell["BooreAndAtkinson2008Hor", "Subsubsection",
 CellChangeTimes->{{3.9519747063299017`*^9, 3.951974732209299*^9}, 
   3.9519747670098867`*^9},ExpressionUUID->"1be43014-42aa-4eeb-90df-\
d379b8b03c64"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"BooreAndAtkinson2008Hor", "::", "usage"}], 
    "=", "\"\<BooreAndAtkinson2008Hor[p,options] returns {Subscript[a, \
SA](p), \[Sigma], \\!\\(\n\\*SubscriptBox[\\(\[PartialD]\\), \\(R\\)]\\(\n\
SubscriptBox[\\(a\\), \\(SA\\)](p)\\)\\), \\!\\(\n\\*SubscriptBox[\\(\
\[PartialD]\\), \\(M\\)]\\(\nSubscriptBox[\\(a\\), \\(SA\\)](p)\\)\\)}, a \
list of expected ground-motion parameters for a given earthquake scenario \
using the model of Boore & Atkinson (2008), which is part of the Next \
Generation of Attenuation (NGA) project. The model is based on 1574 \
recordings from 54 earthquakes from the PEER NGA database. To obtain PGA, use \
a period below 0.01s (minimum period used for regression), for PGV use a \
period below 0s;\>\""}], ";"}], "\n"}]], "Input",
 CellChangeTimes->{{3.951974557622685*^9, 3.951974559097123*^9}, {
   3.95197470080582*^9, 3.9519747031593657`*^9}, 3.9519748615498953`*^9},
 CellLabel->"In[38]:=",ExpressionUUID->"ca003959-a1d6-45c0-a316-01c49be97aa3"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
     RowBox[{
     "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**",
       "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**",
       "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**",
       "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", 
      "NGa"}], " ", "model", " ", "of", " ", "Boore", " ", "and", " ", 
     "Atkinson"}], ",", 
    RowBox[{
    "as", " ", "published", " ", "in", " ", "Earthquake", " ", "Spectra", " ",
      "2008"}]}], 
   "*************************************************************************************************)"}\
], 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Options", "[", "BooreAndAtkinson2008Hor", "]"}], "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"MagMW", "->", "6."}], ",", 
       RowBox[{"DistJB", "->", "10."}], ",", 
       RowBox[{"Vs30", "->", "760."}], ",", 
       RowBox[{"FaultTypeNSSR", "->", "\"\<U\>\""}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"BooreAndAtkinson2008Hor", "[", 
      RowBox[{"per_", ",", 
       RowBox[{"opts", ":", 
        RowBox[{"OptionsPattern", "[", "]"}]}]}], "]"}], ":=", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "mw", ",", "rjb", ",", "vs30", ",", "faulttypeinp", ",", "periodlist",
          ",", "c1list", ",", "c2list", ",", "c3list", ",", "hlist", ",", 
         "e1list", ",", "e2list", ",", "e3list", ",", "e4list", ",", "e5list",
          ",", "e6list", ",", "e7list", ",", "mhlist", ",", "blinlist", ",", 
         "b1list", ",", "b2list", ",", "c1", ",", "c2", ",", "c3", ",", "h", ",",
          "e1", ",", "e2", ",", "e3", ",", "e4", ",", "e5", ",", "e6", ",", 
         "e7", ",", "mh", ",", "blin", ",", "b1", ",", "b2", ",", "a1", ",", 
         "pgalow", ",", "a2", ",", "v1", ",", "v2", ",", "vref", ",", "u", ",",
          "ss", ",", "rs", ",", "ns", ",", "mref", ",", "rref", ",", "fm", ",",
          "fd", ",", "fd4nl", ",", "flin", ",", "fnl", ",", "pga4nl", ",", 
         "c", ",", "d", ",", "dx", ",", "dy", ",", "bnl", ",", "saval", ",", 
         "sigmatot", ",", "siglist", ",", "sigtulist", ",", "sigtmlist", ",", 
         "tauulist", ",", "taumlist", ",", "sig", ",", "sigtm", ",", "sigtu", 
         ",", "tauu", ",", "taum", ",", "lny", ",", "pddist", ",", "pdmag", ",",
          "out", ",", "fmpga", ",", "rrefpga", ",", "mrefpga"}], "}"}], ",", 
       RowBox[{"(*", 
        RowBox[{"**", "**", "Options"}], "******)"}], 
       RowBox[{
        RowBox[{"mw", "=", 
         RowBox[{"OptionValue", "[", "MagMW", "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"rjb", "=", 
         RowBox[{"OptionValue", "[", "DistJB", "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"vs30", "=", 
         RowBox[{"OptionValue", "[", "Vs30", "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"faulttypeinp", "=", 
         RowBox[{"OptionValue", "[", "FaultTypeNSSR", "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"periodlist", "=", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1."}], ",", "0.", ",", "0.01", ",", "0.02", ",", 
           "0.03", ",", "0.05", ",", "0.075", ",", "0.1", ",", "0.15", ",", 
           "0.2", ",", "0.25", ",", "0.3", ",", "0.4", ",", "0.5", ",", 
           "0.75", ",", "1.", ",", "1.5", ",", "2.", ",", "3.", ",", "4.", ",",
            "5.", ",", "7.5", ",", "10."}], "}"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"c1list", "=", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.8737`"}], ",", 
           RowBox[{"-", "0.6605`"}], ",", 
           RowBox[{"-", "0.6622`"}], ",", 
           RowBox[{"-", "0.666`"}], ",", 
           RowBox[{"-", "0.6901`"}], ",", 
           RowBox[{"-", "0.717`"}], ",", 
           RowBox[{"-", "0.7205`"}], ",", 
           RowBox[{"-", "0.7081`"}], ",", 
           RowBox[{"-", "0.6961`"}], ",", 
           RowBox[{"-", "0.583`"}], ",", 
           RowBox[{"-", "0.5726`"}], ",", 
           RowBox[{"-", "0.5543`"}], ",", 
           RowBox[{"-", "0.6443`"}], ",", 
           RowBox[{"-", "0.6914`"}], ",", 
           RowBox[{"-", "0.7408`"}], ",", 
           RowBox[{"-", "0.8183`"}], ",", 
           RowBox[{"-", "0.8303`"}], ",", 
           RowBox[{"-", "0.8285`"}], ",", 
           RowBox[{"-", "0.7844`"}], ",", 
           RowBox[{"-", "0.6854`"}], ",", 
           RowBox[{"-", "0.5096`"}], ",", 
           RowBox[{"-", "0.3724`"}], ",", 
           RowBox[{"-", "0.09824`"}]}], "}"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"c2list", "=", 
         RowBox[{"{", 
          RowBox[{
          "0.1006`", ",", "0.1197`", ",", "0.12`", ",", "0.1228`", ",", 
           "0.1283`", ",", "0.1317`", ",", "0.1237`", ",", "0.1117`", ",", 
           "0.09884`", ",", "0.04273`", ",", "0.02977`", ",", "0.01955`", ",",
            "0.04394`", ",", "0.0608`", ",", "0.07518`", ",", "0.1027`", ",", 
           "0.09793`", ",", "0.09432`", ",", "0.07282`", ",", "0.03758`", ",", 
           RowBox[{"-", "0.02391`"}], ",", 
           RowBox[{"-", "0.06568`"}], ",", 
           RowBox[{"-", "0.138`"}]}], "}"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"c3list", "=", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.00334`"}], ",", 
           RowBox[{"-", "0.01151`"}], ",", 
           RowBox[{"-", "0.01151`"}], ",", 
           RowBox[{"-", "0.01151`"}], ",", 
           RowBox[{"-", "0.01151`"}], ",", 
           RowBox[{"-", "0.01151`"}], ",", 
           RowBox[{"-", "0.01151`"}], ",", 
           RowBox[{"-", "0.01151`"}], ",", 
           RowBox[{"-", "0.01113`"}], ",", 
           RowBox[{"-", "0.00952`"}], ",", 
           RowBox[{"-", "0.00837`"}], ",", 
           RowBox[{"-", "0.0075`"}], ",", 
           RowBox[{"-", "0.00626`"}], ",", 
           RowBox[{"-", "0.0054`"}], ",", 
           RowBox[{"-", "0.00409`"}], ",", 
           RowBox[{"-", "0.00334`"}], ",", 
           RowBox[{"-", "0.00255`"}], ",", 
           RowBox[{"-", "0.00217`"}], ",", 
           RowBox[{"-", "0.00191`"}], ",", 
           RowBox[{"-", "0.00191`"}], ",", 
           RowBox[{"-", "0.00191`"}], ",", 
           RowBox[{"-", "0.00191`"}], ",", 
           RowBox[{"-", "0.00191`"}]}], "}"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"hlist", "=", 
         RowBox[{"{", 
          RowBox[{
          "2.54`", ",", "1.35`", ",", "1.35`", ",", "1.35`", ",", "1.35`", ",",
            "1.35`", ",", "1.55`", ",", "1.68`", ",", "1.86`", ",", "1.98`", ",",
            "2.07`", ",", "2.14`", ",", "2.24`", ",", "2.32`", ",", "2.46`", ",",
            "2.54`", ",", "2.66`", ",", "2.73`", ",", "2.83`", ",", "2.89`", ",",
            "2.93`", ",", "3.`", ",", "3.04`"}], "}"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"e1list", "=", 
         RowBox[{"{", 
          RowBox[{"5.00121`", ",", 
           RowBox[{"-", "0.53804`"}], ",", 
           RowBox[{"-", "0.52883`"}], ",", 
           RowBox[{"-", "0.52192`"}], ",", 
           RowBox[{"-", "0.45285`"}], ",", 
           RowBox[{"-", "0.28476`"}], ",", "0.00767`", ",", "0.20109`", ",", 
           "0.46128`", ",", "0.5718`", ",", "0.51884`", ",", "0.43825`", ",", 
           "0.3922`", ",", "0.18957`", ",", 
           RowBox[{"-", "0.21338`"}], ",", 
           RowBox[{"-", "0.46896`"}], ",", 
           RowBox[{"-", "0.86271`"}], ",", 
           RowBox[{"-", "1.22652`"}], ",", 
           RowBox[{"-", "1.82979`"}], ",", 
           RowBox[{"-", "2.24656`"}], ",", 
           RowBox[{"-", "1.28408`"}], ",", 
           RowBox[{"-", "1.43145`"}], ",", 
           RowBox[{"-", "2.15446`"}]}], "}"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"e2list", "=", 
         RowBox[{"{", 
          RowBox[{"5.04727`", ",", 
           RowBox[{"-", "0.5035`"}], ",", 
           RowBox[{"-", "0.49429`"}], ",", 
           RowBox[{"-", "0.48508`"}], ",", 
           RowBox[{"-", "0.41831`"}], ",", 
           RowBox[{"-", "0.25022`"}], ",", "0.04912`", ",", "0.23102`", ",", 
           "0.48661`", ",", "0.59253`", ",", "0.53496`", ",", "0.44516`", ",",
            "0.40602`", ",", "0.19878`", ",", 
           RowBox[{"-", "0.19496`"}], ",", 
           RowBox[{"-", "0.43443`"}], ",", 
           RowBox[{"-", "0.79593`"}], ",", 
           RowBox[{"-", "1.15514`"}], ",", 
           RowBox[{"-", "1.7469`"}], ",", 
           RowBox[{"-", "2.15906`"}], ",", 
           RowBox[{"-", "1.2127`"}], ",", 
           RowBox[{"-", "1.31632`"}], ",", 
           RowBox[{"-", "2.16137`"}]}], "}"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"e3list", "=", 
         RowBox[{"{", 
          RowBox[{"4.63188`", ",", 
           RowBox[{"-", "0.75472`"}], ",", 
           RowBox[{"-", "0.74551`"}], ",", 
           RowBox[{"-", "0.73906`"}], ",", 
           RowBox[{"-", "0.66722`"}], ",", 
           RowBox[{"-", "0.48462`"}], ",", 
           RowBox[{"-", "0.20578`"}], ",", "0.03058`", ",", "0.30185`", ",", 
           "0.4086`", ",", "0.3388`", ",", "0.25356`", ",", "0.21398`", ",", 
           "0.00967`", ",", 
           RowBox[{"-", "0.49176`"}], ",", 
           RowBox[{"-", "0.78465`"}], ",", 
           RowBox[{"-", "1.20902`"}], ",", 
           RowBox[{"-", "1.57697`"}], ",", 
           RowBox[{"-", "2.22584`"}], ",", 
           RowBox[{"-", "2.58228`"}], ",", 
           RowBox[{"-", "1.50904`"}], ",", 
           RowBox[{"-", "1.81022`"}], ",", 
           RowBox[{"-", "2.53323`"}]}], "}"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"e4list", "=", 
         RowBox[{"{", 
          RowBox[{"5.0821`", ",", 
           RowBox[{"-", "0.5097`"}], ",", 
           RowBox[{"-", "0.49966`"}], ",", 
           RowBox[{"-", "0.48895`"}], ",", 
           RowBox[{"-", "0.42229`"}], ",", 
           RowBox[{"-", "0.26092`"}], ",", "0.02706`", ",", "0.22193`", ",", 
           "0.49328`", ",", "0.61472`", ",", "0.57747`", ",", "0.5199`", ",", 
           "0.4608`", ",", "0.26337`", ",", 
           RowBox[{"-", "0.10813`"}], ",", 
           RowBox[{"-", "0.3933`"}], ",", 
           RowBox[{"-", "0.88085`"}], ",", 
           RowBox[{"-", "1.27669`"}], ",", 
           RowBox[{"-", "1.91814`"}], ",", 
           RowBox[{"-", "2.38168`"}], ",", 
           RowBox[{"-", "1.41093`"}], ",", 
           RowBox[{"-", "1.59217`"}], ",", 
           RowBox[{"-", "2.14635`"}]}], "}"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"e5list", "=", 
         RowBox[{"{", 
          RowBox[{
          "0.18322`", ",", "0.28805`", ",", "0.28897`", ",", "0.25144`", ",", 
           "0.17976`", ",", "0.06369`", ",", "0.0117`", ",", "0.04697`", ",", 
           "0.1799`", ",", "0.52729`", ",", "0.6088`", ",", "0.64472`", ",", 
           "0.7861`", ",", "0.76837`", ",", "0.75179`", ",", "0.6788`", ",", 
           "0.70689`", ",", "0.77989`", ",", "0.77966`", ",", "1.24961`", ",",
            "0.14271`", ",", "0.52407`", ",", "0.40387`"}], "}"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"e6list", "=", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.12736`"}], ",", 
           RowBox[{"-", "0.10164`"}], ",", 
           RowBox[{"-", "0.10019`"}], ",", 
           RowBox[{"-", "0.11006`"}], ",", 
           RowBox[{"-", "0.12858`"}], ",", 
           RowBox[{"-", "0.15752`"}], ",", 
           RowBox[{"-", "0.17051`"}], ",", 
           RowBox[{"-", "0.15948`"}], ",", 
           RowBox[{"-", "0.14539`"}], ",", 
           RowBox[{"-", "0.12964`"}], ",", 
           RowBox[{"-", "0.13843`"}], ",", 
           RowBox[{"-", "0.15694`"}], ",", 
           RowBox[{"-", "0.07843`"}], ",", 
           RowBox[{"-", "0.09054`"}], ",", 
           RowBox[{"-", "0.14053`"}], ",", 
           RowBox[{"-", "0.18257`"}], ",", 
           RowBox[{"-", "0.2595`"}], ",", 
           RowBox[{"-", "0.29657`"}], ",", 
           RowBox[{"-", "0.45384`"}], ",", 
           RowBox[{"-", "0.35874`"}], ",", 
           RowBox[{"-", "0.39006`"}], ",", 
           RowBox[{"-", "0.37578`"}], ",", 
           RowBox[{"-", "0.48492`"}]}], "}"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"e7list", "=", 
         RowBox[{"{", 
          RowBox[{
          "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",",
            "0.`", ",", "0.`", ",", "0.`", ",", "0.00102`", ",", "0.08607`", ",",
            "0.10601`", ",", "0.02262`", ",", "0.`", ",", "0.10302`", ",", 
           "0.05393`", ",", "0.19082`", ",", "0.29888`", ",", "0.67466`", ",",
            "0.79508`", ",", "0.`", ",", "0.`", ",", "0.`"}], "}"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"mhlist", "=", 
         RowBox[{"{", 
          RowBox[{
          "8.5`", ",", "6.75`", ",", "6.75`", ",", "6.75`", ",", "6.75`", ",",
            "6.75`", ",", "6.75`", ",", "6.75`", ",", "6.75`", ",", "6.75`", ",",
            "6.75`", ",", "6.75`", ",", "6.75`", ",", "6.75`", ",", "6.75`", ",",
            "6.75`", ",", "6.75`", ",", "6.75`", ",", "6.75`", ",", "6.75`", ",",
            "8.5`", ",", "8.5`", ",", "8.5`"}], "}"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"blinlist", "=", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.6`"}], ",", 
           RowBox[{"-", "0.36`"}], ",", 
           RowBox[{"-", "0.36`"}], ",", 
           RowBox[{"-", "0.34`"}], ",", 
           RowBox[{"-", "0.33`"}], ",", 
           RowBox[{"-", "0.29`"}], ",", 
           RowBox[{"-", "0.23`"}], ",", 
           RowBox[{"-", "0.25`"}], ",", 
           RowBox[{"-", "0.28`"}], ",", 
           RowBox[{"-", "0.31`"}], ",", 
           RowBox[{"-", "0.39`"}], ",", 
           RowBox[{"-", "0.44`"}], ",", 
           RowBox[{"-", "0.5`"}], ",", 
           RowBox[{"-", "0.6`"}], ",", 
           RowBox[{"-", "0.69`"}], ",", 
           RowBox[{"-", "0.7`"}], ",", 
           RowBox[{"-", "0.72`"}], ",", 
           RowBox[{"-", "0.73`"}], ",", 
           RowBox[{"-", "0.74`"}], ",", 
           RowBox[{"-", "0.75`"}], ",", 
           RowBox[{"-", "0.75`"}], ",", 
           RowBox[{"-", "0.692`"}], ",", 
           RowBox[{"-", "0.65`"}]}], "}"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"b1list", "=", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.5`"}], ",", 
           RowBox[{"-", "0.64`"}], ",", 
           RowBox[{"-", "0.64`"}], ",", 
           RowBox[{"-", "0.63`"}], ",", 
           RowBox[{"-", "0.62`"}], ",", 
           RowBox[{"-", "0.64`"}], ",", 
           RowBox[{"-", "0.64`"}], ",", 
           RowBox[{"-", "0.6`"}], ",", 
           RowBox[{"-", "0.53`"}], ",", 
           RowBox[{"-", "0.52`"}], ",", 
           RowBox[{"-", "0.52`"}], ",", 
           RowBox[{"-", "0.52`"}], ",", 
           RowBox[{"-", "0.51`"}], ",", 
           RowBox[{"-", "0.5`"}], ",", 
           RowBox[{"-", "0.47`"}], ",", 
           RowBox[{"-", "0.44`"}], ",", 
           RowBox[{"-", "0.4`"}], ",", 
           RowBox[{"-", "0.38`"}], ",", 
           RowBox[{"-", "0.34`"}], ",", 
           RowBox[{"-", "0.31`"}], ",", 
           RowBox[{"-", "0.291`"}], ",", 
           RowBox[{"-", "0.247`"}], ",", 
           RowBox[{"-", "0.215`"}]}], "}"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"b2list", "=", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.06`"}], ",", 
           RowBox[{"-", "0.14`"}], ",", 
           RowBox[{"-", "0.14`"}], ",", 
           RowBox[{"-", "0.12`"}], ",", 
           RowBox[{"-", "0.11`"}], ",", 
           RowBox[{"-", "0.11`"}], ",", 
           RowBox[{"-", "0.11`"}], ",", 
           RowBox[{"-", "0.13`"}], ",", 
           RowBox[{"-", "0.18`"}], ",", 
           RowBox[{"-", "0.19`"}], ",", 
           RowBox[{"-", "0.16`"}], ",", 
           RowBox[{"-", "0.14`"}], ",", 
           RowBox[{"-", "0.1`"}], ",", 
           RowBox[{"-", "0.06`"}], ",", "0.`", ",", "0.`", ",", "0.`", ",", 
           "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", 
           "0.`"}], "}"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"siglist", "=", 
         RowBox[{"{", 
          RowBox[{
          "0.5`", ",", "0.502`", ",", "0.502`", ",", "0.502`", ",", "0.507`", 
           ",", "0.516`", ",", "0.513`", ",", "0.52`", ",", "0.518`", ",", 
           "0.523`", ",", "0.527`", ",", "0.546`", ",", "0.541`", ",", 
           "0.555`", ",", "0.571`", ",", "0.573`", ",", "0.566`", ",", 
           "0.58`", ",", "0.566`", ",", "0.583`", ",", "0.601`", ",", 
           "0.626`", ",", "0.645`"}], "}"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"tauulist", "=", 
         RowBox[{"{", 
          RowBox[{
          "0.286`", ",", "0.265`", ",", "0.267`", ",", "0.267`", ",", 
           "0.276`", ",", "0.286`", ",", "0.322`", ",", "0.313`", ",", 
           "0.288`", ",", "0.283`", ",", "0.267`", ",", "0.272`", ",", 
           "0.267`", ",", "0.265`", ",", "0.311`", ",", "0.318`", ",", 
           "0.382`", ",", "0.398`", ",", "0.41`", ",", "0.394`", ",", 
           "0.414`", ",", "0.465`", ",", "0.355`"}], "}"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"sigtulist", "=", 
         RowBox[{"{", 
          RowBox[{
          "0.576`", ",", "0.566`", ",", "0.569`", ",", "0.569`", ",", 
           "0.578`", ",", "0.589`", ",", "0.606`", ",", "0.608`", ",", 
           "0.592`", ",", "0.596`", ",", "0.592`", ",", "0.608`", ",", 
           "0.603`", ",", "0.615`", ",", "0.649`", ",", "0.654`", ",", 
           "0.684`", ",", "0.702`", ",", "0.7`", ",", "0.702`", ",", "0.73`", 
           ",", "0.781`", ",", "0.735`"}], "}"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"taumlist", "=", 
         RowBox[{"{", 
          RowBox[{
          "0.256`", ",", "0.26`", ",", "0.262`", ",", "0.262`", ",", "0.274`",
            ",", "0.286`", ",", "0.32`", ",", "0.318`", ",", "0.29`", ",", 
           "0.288`", ",", "0.267`", ",", "0.269`", ",", "0.267`", ",", 
           "0.265`", ",", "0.299`", ",", "0.302`", ",", "0.373`", ",", 
           "0.389`", ",", "0.401`", ",", "0.385`", ",", "0.437`", ",", 
           "0.477`", ",", "0.477`"}], "}"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"sigtmlist", "=", 
         RowBox[{"{", 
          RowBox[{
          "0.56`", ",", "0.564`", ",", "0.566`", ",", "0.566`", ",", "0.576`",
            ",", "0.589`", ",", "0.606`", ",", "0.608`", ",", "0.594`", ",", 
           "0.596`", ",", "0.592`", ",", "0.608`", ",", "0.603`", ",", 
           "0.615`", ",", "0.645`", ",", "0.647`", ",", "0.679`", ",", "0.7`",
            ",", "0.695`", ",", "0.698`", ",", "0.744`", ",", "0.787`", ",", 
           "0.801`"}], "}"}]}], ";", "\[IndentingNewLine]", 
        "\[IndentingNewLine]", 
        RowBox[{"SetOptions", "[", 
         RowBox[{"InterpolateCoefficientList", ",", 
          RowBox[{"IpolHalfWindowLength", "->", "ilenALL"}], ",", 
          RowBox[{"IpolOrder", "->", "ipolorderALL"}], ",", 
          RowBox[{"IpolType", "->", "ipolTypeAll"}]}], "]"}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"Which", "[", 
         RowBox[{
          RowBox[{"per", "<", "0."}], ",", 
          RowBox[{"(*", "PGV", "*)"}], 
          RowBox[{
           RowBox[{"c1", "=", 
            RowBox[{"c1list", "[", 
             RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"c2", "=", 
            RowBox[{"c2list", "[", 
             RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"c3", "=", 
            RowBox[{"c3list", "[", 
             RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"h", "=", 
            RowBox[{"hlist", "[", 
             RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"e1", "=", 
            RowBox[{"e1list", "[", 
             RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"e2", "=", 
            RowBox[{"e2list", "[", 
             RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"e3", "=", 
            RowBox[{"e3list", "[", 
             RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"e4", "=", 
            RowBox[{"e4list", "[", 
             RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"e5", "=", 
            RowBox[{"e5list", "[", 
             RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"e6", "=", 
            RowBox[{"e6list", "[", 
             RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"e7", "=", 
            RowBox[{"e7list", "[", 
             RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"mh", "=", 
            RowBox[{"mhlist", "[", 
             RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"blin", "=", 
            RowBox[{"blinlist", "[", 
             RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"b1", "=", 
            RowBox[{"b1list", "[", 
             RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"b2", "=", 
            RowBox[{"b2list", "[", 
             RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"sig", "=", 
            RowBox[{"siglist", "[", 
             RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"tauu", "=", 
            RowBox[{"tauulist", "[", 
             RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"sigtu", "=", 
            RowBox[{"sigtulist", "[", 
             RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"taum", "=", 
            RowBox[{"taumlist", "[", 
             RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"sigtm", "=", 
            RowBox[{"sigtmlist", "[", 
             RowBox[{"[", "1", "]"}], "]"}]}], ";"}], ",", 
          RowBox[{"0.", "<=", "per", "<", "0.01"}], ",", 
          RowBox[{"(*", "PGA", "*)"}], 
          RowBox[{
           RowBox[{"c1", "=", 
            RowBox[{"c1list", "[", 
             RowBox[{"[", "2", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"c2", "=", 
            RowBox[{"c2list", "[", 
             RowBox[{"[", "2", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"c3", "=", 
            RowBox[{"c3list", "[", 
             RowBox[{"[", "2", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"h", "=", 
            RowBox[{"hlist", "[", 
             RowBox[{"[", "2", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"e1", "=", 
            RowBox[{"e1list", "[", 
             RowBox[{"[", "2", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"e2", "=", 
            RowBox[{"e2list", "[", 
             RowBox[{"[", "2", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"e3", "=", 
            RowBox[{"e3list", "[", 
             RowBox[{"[", "2", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"e4", "=", 
            RowBox[{"e4list", "[", 
             RowBox[{"[", "2", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"e5", "=", 
            RowBox[{"e5list", "[", 
             RowBox[{"[", "2", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"e6", "=", 
            RowBox[{"e6list", "[", 
             RowBox[{"[", "2", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"e7", "=", 
            RowBox[{"e7list", "[", 
             RowBox[{"[", "2", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"mh", "=", 
            RowBox[{"mhlist", "[", 
             RowBox[{"[", "2", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"blin", "=", 
            RowBox[{"blinlist", "[", 
             RowBox[{"[", "2", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"b1", "=", 
            RowBox[{"b1list", "[", 
             RowBox[{"[", "2", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"b2", "=", 
            RowBox[{"b2list", "[", 
             RowBox[{"[", "2", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"sig", "=", 
            RowBox[{"siglist", "[", 
             RowBox[{"[", "2", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"tauu", "=", 
            RowBox[{"tauulist", "[", 
             RowBox[{"[", "2", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"sigtu", "=", 
            RowBox[{"sigtulist", "[", 
             RowBox[{"[", "2", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"taum", "=", 
            RowBox[{"taumlist", "[", 
             RowBox[{"[", "2", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"sigtm", "=", 
            RowBox[{"sigtmlist", "[", 
             RowBox[{"[", "2", "]"}], "]"}]}], ";"}], ",", 
          RowBox[{"0.01", "<=", "per"}], ",", 
          RowBox[{"(*", 
           RowBox[{"else", " ", "PSA"}], "*)"}], 
          RowBox[{
           RowBox[{"c1", "=", 
            RowBox[{"InterpolateCoefficientList", "[", 
             RowBox[{"per", ",", "periodlist", ",", "c1list"}], "]"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"c2", "=", 
            RowBox[{"InterpolateCoefficientList", "[", 
             RowBox[{"per", ",", "periodlist", ",", "c2list"}], "]"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"c3", "=", 
            RowBox[{"InterpolateCoefficientList", "[", 
             RowBox[{"per", ",", "periodlist", ",", "c3list"}], "]"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"h", "=", 
            RowBox[{"InterpolateCoefficientList", "[", 
             RowBox[{"per", ",", "periodlist", ",", "hlist"}], "]"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"e1", "=", 
            RowBox[{"InterpolateCoefficientList", "[", 
             RowBox[{"per", ",", "periodlist", ",", "e1list"}], "]"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"e2", "=", 
            RowBox[{"InterpolateCoefficientList", "[", 
             RowBox[{"per", ",", "periodlist", ",", "e2list"}], "]"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"e3", "=", 
            RowBox[{"InterpolateCoefficientList", "[", 
             RowBox[{"per", ",", "periodlist", ",", "e3list"}], "]"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"e4", "=", 
            RowBox[{"InterpolateCoefficientList", "[", 
             RowBox[{"per", ",", "periodlist", ",", "e4list"}], "]"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"e5", "=", 
            RowBox[{"InterpolateCoefficientList", "[", 
             RowBox[{"per", ",", "periodlist", ",", "e5list"}], "]"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"e6", "=", 
            RowBox[{"InterpolateCoefficientList", "[", 
             RowBox[{"per", ",", "periodlist", ",", "e6list"}], "]"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"e7", "=", 
            RowBox[{"InterpolateCoefficientList", "[", 
             RowBox[{"per", ",", "periodlist", ",", "e7list"}], "]"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"mh", "=", 
            RowBox[{"InterpolateCoefficientList", "[", 
             RowBox[{"per", ",", "periodlist", ",", "mhlist"}], "]"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"blin", "=", 
            RowBox[{"InterpolateCoefficientList", "[", 
             RowBox[{"per", ",", "periodlist", ",", "blinlist"}], "]"}]}], ";",
            "\[IndentingNewLine]", 
           RowBox[{"b1", "=", 
            RowBox[{"InterpolateCoefficientList", "[", 
             RowBox[{"per", ",", "periodlist", ",", "b1list"}], "]"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"b2", "=", 
            RowBox[{"InterpolateCoefficientList", "[", 
             RowBox[{"per", ",", "periodlist", ",", "b2list"}], "]"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"sig", "=", 
            RowBox[{"InterpolateCoefficientList", "[", 
             RowBox[{"per", ",", "periodlist", ",", "siglist"}], "]"}]}], ";",
            "\[IndentingNewLine]", 
           RowBox[{"tauu", "=", 
            RowBox[{"InterpolateCoefficientList", "[", 
             RowBox[{"per", ",", "periodlist", ",", "tauulist"}], "]"}]}], ";",
            "\[IndentingNewLine]", 
           RowBox[{"sigtu", "=", 
            RowBox[{"InterpolateCoefficientList", "[", 
             RowBox[{"per", ",", "periodlist", ",", "sigtulist"}], "]"}]}], ";",
            "\[IndentingNewLine]", 
           RowBox[{"taum", "=", 
            RowBox[{"InterpolateCoefficientList", "[", 
             RowBox[{"per", ",", "periodlist", ",", "taumlist"}], "]"}]}], ";",
            "\[IndentingNewLine]", 
           RowBox[{"sigtm", "=", 
            RowBox[{"InterpolateCoefficientList", "[", 
             RowBox[{"per", ",", "periodlist", ",", "sigtmlist"}], "]"}]}], 
           ";"}]}], "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"a1", "=", "0.03"}], ";", "\[IndentingNewLine]", 
        RowBox[{"pgalow", "=", "0.06"}], ";", "\[IndentingNewLine]", 
        RowBox[{"a2", "=", "0.09"}], ";", "\[IndentingNewLine]", 
        RowBox[{"v1", "=", "180"}], ";", "\[IndentingNewLine]", 
        RowBox[{"v2", "=", "300"}], ";", "\[IndentingNewLine]", 
        RowBox[{"vref", "=", "760"}], ";", "\[IndentingNewLine]", 
        RowBox[{"mref", "=", "4.5"}], ";", "\[IndentingNewLine]", 
        RowBox[{"rref", "=", "1."}], ";", "\[IndentingNewLine]", 
        RowBox[{"rrefpga", "=", "5."}], ";", 
        RowBox[{"(*", 
         RowBox[{
          RowBox[{
          "this", " ", "is", " ", "different", " ", "from", " ", "the", " ", 
           "Hazard39", " ", "code"}], "-", 
          RowBox[{
          "there", " ", "a", " ", "value", " ", "of", " ", "1.", " ", "is", " ",
            "used"}]}], "*)"}], 
        RowBox[{"mrefpga", "=", "4.5"}], ";", 
        RowBox[{"(*", 
         RowBox[{
          RowBox[{
          "this", " ", "is", " ", "different", " ", "from", " ", "the", " ", 
           "Hazard39", " ", "code"}], "-", 
          RowBox[{
          "there", " ", "a", " ", "value", " ", "of", " ", "6.75", " ", "is", 
           " ", "used"}]}], "*)"}], 
        RowBox[{"(*", 
         RowBox[{"magnitude", " ", "scaling", " ", "eq", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"5", "a"}], ",", "b"}], ")"}]}], "*)"}], 
        RowBox[{"u", "=", "0"}], ";", "\[IndentingNewLine]", 
        RowBox[{"ss", "=", "0"}], ";", "\[IndentingNewLine]", 
        RowBox[{"rs", "=", "0"}], ";", "\[IndentingNewLine]", 
        RowBox[{"ns", "=", "0"}], ";", "\[IndentingNewLine]", 
        RowBox[{"Which", "[", 
         RowBox[{
          RowBox[{"faulttypeinp", "==", "\"\<U\>\""}], ",", 
          RowBox[{
           RowBox[{"u", "=", "1"}], ";"}], ",", 
          RowBox[{"faulttypeinp", "==", "\"\<STRIKE SLIP\>\""}], ",", 
          RowBox[{
           RowBox[{"ss", "=", "1"}], ";"}], ",", 
          RowBox[{"faulttypeinp", "==", "\"\<NORMAL\>\""}], ",", 
          RowBox[{
           RowBox[{"ns", "=", "1"}], ";"}], ",", 
          RowBox[{"faulttypeinp", "==", "\"\<REVERSE\>\""}], ",", 
          RowBox[{
           RowBox[{"rs", "=", "1"}], ";"}], ",", "True", ",", 
          RowBox[{
           RowBox[{"Message", "[", 
            RowBox[{
             RowBox[{"EmpiricalEquation", "::", "option"}], ",", 
             "faulttypeinp", ",", "FaultTypeNSSR"}], "]"}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"Return", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", "999"}], ",", 
              RowBox[{"-", "999"}], ",", 
              RowBox[{"-", "999"}], ",", 
              RowBox[{"-", "999"}]}], "}"}], "]"}], ";"}]}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"Which", "[", 
         RowBox[{
          RowBox[{"mw", "<=", "mh"}], ",", 
          RowBox[{
           RowBox[{"fm", "=", 
            RowBox[{
             RowBox[{"e1", " ", "u"}], "+", 
             RowBox[{"e2", " ", "ss"}], "+", 
             RowBox[{"e3", " ", "ns"}], "+", 
             RowBox[{"e4", " ", "rs"}], "+", 
             RowBox[{"e5", "*", 
              RowBox[{"(", 
               RowBox[{"mw", "-", "mh"}], ")"}]}], "+", 
             RowBox[{"e6", "*", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"mw", "-", "mh"}], ")"}], "^", "2"}]}]}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"fmpga", "=", 
            RowBox[{
             RowBox[{
              RowBox[{"e1list", "[", 
               RowBox[{"[", "2", "]"}], "]"}], " ", "u"}], "+", 
             RowBox[{
              RowBox[{"e2list", "[", 
               RowBox[{"[", "2", "]"}], "]"}], " ", "ss"}], "+", 
             RowBox[{
              RowBox[{"e3list", "[", 
               RowBox[{"[", "2", "]"}], "]"}], " ", "ns"}], "+", 
             RowBox[{
              RowBox[{"e4list", "[", 
               RowBox[{"[", "2", "]"}], "]"}], " ", "rs"}], "+", 
             RowBox[{
              RowBox[{"e5list", "[", 
               RowBox[{"[", "2", "]"}], "]"}], " ", 
              RowBox[{"(", 
               RowBox[{"mw", "-", 
                RowBox[{"mhlist", "[", 
                 RowBox[{"[", "2", "]"}], "]"}]}], ")"}]}], "+", 
             RowBox[{
              RowBox[{"e6list", "[", 
               RowBox[{"[", "2", "]"}], "]"}], " ", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"mw", "-", 
                 RowBox[{"mhlist", "[", 
                  RowBox[{"[", "2", "]"}], "]"}]}], ")"}], "^", "2"}]}]}]}], 
           ";"}], ",", 
          RowBox[{"mw", ">", "mh"}], ",", 
          RowBox[{
           RowBox[{"fm", "=", 
            RowBox[{
             RowBox[{"e1", " ", "u"}], "+", 
             RowBox[{"e2", " ", "ss"}], "+", 
             RowBox[{"e3", " ", "ns"}], "+", 
             RowBox[{"e4", " ", "rs"}], "+", 
             RowBox[{"e7", "*", 
              RowBox[{"(", 
               RowBox[{"mw", "-", "mh"}], ")"}]}]}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"fmpga", "=", 
            RowBox[{
             RowBox[{
              RowBox[{"e1list", "[", 
               RowBox[{"[", "2", "]"}], "]"}], " ", "u"}], "+", 
             RowBox[{
              RowBox[{"e2list", "[", 
               RowBox[{"[", "2", "]"}], "]"}], " ", "ss"}], "+", 
             RowBox[{
              RowBox[{"e3list", "[", 
               RowBox[{"[", "2", "]"}], "]"}], " ", "ns"}], "+", 
             RowBox[{
              RowBox[{"e4list", "[", 
               RowBox[{"[", "2", "]"}], "]"}], " ", "rs"}], "+", 
             RowBox[{
              RowBox[{"e7list", "[", 
               RowBox[{"[", "2", "]"}], "]"}], " ", 
              RowBox[{"(", 
               RowBox[{"mw", "-", 
                RowBox[{"mhlist", "[", 
                 RowBox[{"[", "2", "]"}], "]"}]}], ")"}]}]}]}], ";"}]}], 
         "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{"distance", " ", "scaling", " ", "eq", " ", 
          RowBox[{"(", 
           RowBox[{"3", ",", "4"}], ")"}]}], "*)"}], 
        RowBox[{"fd", "=", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"c1", "+", 
             RowBox[{"c2", "*", 
              RowBox[{"(", 
               RowBox[{"mw", "-", "mref"}], ")"}]}]}], ")"}], " ", 
           RowBox[{"Log", "[", 
            RowBox[{
             RowBox[{"Sqrt", "[", 
              RowBox[{
               RowBox[{"rjb", "^", "2"}], "+", 
               RowBox[{"h", "^", "2"}]}], "]"}], "/", "rref"}], "]"}]}], "+", 
          
          RowBox[{"c3", "*", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"Sqrt", "[", 
              RowBox[{
               RowBox[{"rjb", "^", "2"}], "+", 
               RowBox[{"h", "^", "2"}]}], "]"}], "-", "rref"}], ")"}]}]}]}], ";",
         "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{
          RowBox[{"distance", " ", "scaling", " ", "for", " ", 
           RowBox[{"pga4nl", ":", "rref"}]}], "=", 
          RowBox[{"5.", " ", 
           RowBox[{"(", 
            RowBox[{"table", " ", "6"}], ")"}]}]}], "*)"}], 
        RowBox[{"fd4nl", "=", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"c1list", "[", 
              RowBox[{"[", "2", "]"}], "]"}], "+", 
             RowBox[{
              RowBox[{"c2list", "[", 
               RowBox[{"[", "2", "]"}], "]"}], " ", 
              RowBox[{"(", 
               RowBox[{"mw", "-", "mrefpga"}], ")"}]}]}], ")"}], " ", 
           RowBox[{"Log", "[", 
            RowBox[{
             RowBox[{"Sqrt", "[", 
              RowBox[{
               RowBox[{"rjb", "^", "2"}], "+", 
               RowBox[{
                RowBox[{"hlist", "[", 
                 RowBox[{"[", "2", "]"}], "]"}], "^", "2"}]}], "]"}], "/", 
             "rrefpga"}], "]"}]}], "+", 
          RowBox[{
           RowBox[{"c3list", "[", 
            RowBox[{"[", "2", "]"}], "]"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"Sqrt", "[", 
              RowBox[{
               RowBox[{"rjb", "^", "2"}], "+", 
               RowBox[{
                RowBox[{"hlist", "[", 
                 RowBox[{"[", "2", "]"}], "]"}], "^", "2"}]}], "]"}], "-", 
             "rrefpga"}], ")"}]}]}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{"site", " ", "term", " ", 
          RowBox[{"eq", ".", 
           RowBox[{"(", "6", ")"}]}]}], "*)"}], 
        RowBox[{"(*", 
         RowBox[{"linear", " ", 
          RowBox[{"eq", ".", 
           RowBox[{"(", "7", ")"}]}]}], "*)"}], 
        RowBox[{"flin", "=", 
         RowBox[{"blin", " ", 
          RowBox[{"Log", "[", 
           RowBox[{"vs30", "/", "vref"}], "]"}]}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{
          RowBox[{"nonlinear", " ", 
           RowBox[{"eq", ".", 
            RowBox[{"(", "8", ")"}]}]}], "-", 
          RowBox[{"(", "13", ")"}]}], "*)"}], 
        RowBox[{"pga4nl", "=", 
         RowBox[{"Exp", "[", 
          RowBox[{"fmpga", "+", "fd4nl"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"Which", "[", 
         RowBox[{
          RowBox[{"vs30", "<=", "v1"}], ",", 
          RowBox[{
           RowBox[{"bnl", "=", "b1"}], ";"}], ",", 
          RowBox[{"v1", "<", "vs30", "<=", "v2"}], ",", 
          RowBox[{
           RowBox[{"bnl", "=", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{"b1", "-", "b2"}], ")"}], " ", 
              RowBox[{
               RowBox[{"Log", "[", 
                RowBox[{"vs30", "/", "v2"}], "]"}], "/", 
               RowBox[{"Log", "[", 
                RowBox[{"v1", "/", "v2"}], "]"}]}]}], "+", "b2"}]}], ";"}], ",", 
          RowBox[{"v2", "<", "vs30", "<", "vref"}], ",", 
          RowBox[{
           RowBox[{"bnl", "=", 
            RowBox[{"b2", " ", 
             RowBox[{
              RowBox[{"Log", "[", 
               RowBox[{"vs30", "/", "vref"}], "]"}], "/", 
              RowBox[{"Log", "[", 
               RowBox[{"v2", "/", "vref"}], "]"}]}]}]}], ";"}], ",", 
          RowBox[{"vref", "<=", "vs30"}], ",", 
          RowBox[{
           RowBox[{"bnl", "=", "0."}], ";"}]}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"Which", "[", 
         RowBox[{
          RowBox[{"pga4nl", "<=", "a1"}], ",", 
          RowBox[{
           RowBox[{"fnl", "=", 
            RowBox[{"bnl", " ", 
             RowBox[{"Log", "[", 
              RowBox[{"pgalow", "/", "0.1"}], "]"}]}]}], ";"}], ",", 
          RowBox[{"a1", "<", "pga4nl", "<=", "a2"}], ",", 
          RowBox[{
           RowBox[{"dx", "=", 
            RowBox[{"Log", "[", 
             RowBox[{"a2", "/", "a1"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"dy", "=", 
            RowBox[{"bnl", " ", 
             RowBox[{"Log", "[", 
              RowBox[{"a2", "/", "pgalow"}], "]"}]}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"c", "=", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"3", " ", "dy"}], "-", 
               RowBox[{"bnl", " ", "dx"}]}], ")"}], "/", 
             RowBox[{"dx", "^", "2"}]}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"d", "=", 
            RowBox[{
             RowBox[{"-", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"2", " ", "dy"}], "-", 
                RowBox[{"bnl", " ", "dx"}]}], ")"}]}], "/", 
             RowBox[{"dx", "^", "3"}]}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"fnl", "=", 
            RowBox[{
             RowBox[{"bnl", " ", 
              RowBox[{"Log", "[", 
               RowBox[{"pgalow", "/", "0.1"}], "]"}]}], "+", 
             RowBox[{"c", " ", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"Log", "[", 
                 RowBox[{"pga4nl", "/", "a1"}], "]"}], ")"}], "^", "2"}]}], "+", 
             RowBox[{"d", " ", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"Log", "[", 
                 RowBox[{"pga4nl", "/", "a1"}], "]"}], ")"}], "^", 
               "3"}]}]}]}], ";"}], ",", 
          RowBox[{"a2", "<", "pga4nl"}], ",", 
          RowBox[{
           RowBox[{"fnl", "=", 
            RowBox[{"bnl", " ", 
             RowBox[{"Log", "[", 
              RowBox[{"pga4nl", "/", "0.1"}], "]"}]}]}], ";"}]}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{"putting", " ", "it", " ", "all", " ", "together"}], "*)"}], 
        
        RowBox[{"lny", "=", 
         RowBox[{"fm", "+", "fd", "+", "flin", "+", "fnl"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"Which", "[", 
         RowBox[{
          RowBox[{"per", "<", "0."}], ",", 
          RowBox[{
           RowBox[{"saval", "=", 
            RowBox[{
             RowBox[{"1", "/", "100"}], " ", 
             RowBox[{"Exp", "[", "lny", "]"}]}]}], ";"}], ",", 
          RowBox[{"(*", "PGV", "*)"}], 
          RowBox[{"0.", "<=", "per"}], ",", 
          RowBox[{
           RowBox[{"saval", "=", 
            RowBox[{"9.81", " ", 
             RowBox[{"Exp", "[", "lny", "]"}]}]}], ";"}]}], " ", 
         RowBox[{"(*", 
          RowBox[{"PGA", " ", "and", " ", "PSA"}], "*)"}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{"variance", " ", "model"}], "*)"}], 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"faulttypeinp", "===", "\"\<U\>\""}], ",", 
          RowBox[{
           RowBox[{"sigmatot", "=", "sigtu"}], ";"}], ",", 
          RowBox[{
           RowBox[{"sigmatot", "=", "sigtm"}], ";"}]}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{
         "partial", " ", "derivative", " ", "with", " ", "respect", " ", "to",
           " ", "distance"}], "*)"}], 
        RowBox[{"pddist", "=", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"c1", "+", 
               RowBox[{"c2", "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "mref"}], "+", "mw"}], ")"}]}]}], ")"}], " ", 
             "rjb"}], ")"}], "/", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"h", "^", "2"}], "+", 
             RowBox[{"rjb", "^", "2"}]}], ")"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"c3", " ", "rjb"}], ")"}], "/", 
           RowBox[{"Sqrt", "[", 
            RowBox[{
             RowBox[{"h", "^", "2"}], "+", 
             RowBox[{"rjb", "^", "2"}]}], "]"}]}]}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{
         "partial", " ", "derivative", " ", "with", " ", "respect", " ", "to",
           " ", "magnitude"}], "*)"}], 
        RowBox[{"Which", "[", 
         RowBox[{
          RowBox[{"mw", "<=", "mh"}], ",", 
          RowBox[{
           RowBox[{"pdmag", "=", 
            RowBox[{"e5", "+", 
             RowBox[{"2", " ", "e6", " ", 
              RowBox[{"(", 
               RowBox[{"mw", "-", "mh"}], ")"}]}], "+", 
             RowBox[{"c2", " ", 
              RowBox[{"Log", "[", 
               RowBox[{
                RowBox[{"Sqrt", "[", 
                 RowBox[{
                  RowBox[{"h", "^", "2"}], "+", 
                  RowBox[{"rjb", "^", "2"}]}], "]"}], "/", "rref"}], 
               "]"}]}]}]}], ";"}], ",", 
          RowBox[{"mw", ">", "mh"}], ",", 
          RowBox[{
           RowBox[{"pdmag", "=", 
            RowBox[{"e7", "+", 
             RowBox[{"c2", " ", 
              RowBox[{"Log", "[", 
               RowBox[{
                RowBox[{"Sqrt", "[", 
                 RowBox[{
                  RowBox[{"h", "^", "2"}], "+", 
                  RowBox[{"rjb", "^", "2"}]}], "]"}], "/", "rref"}], 
               "]"}]}]}]}], ";"}]}], "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"out", "=", 
         RowBox[{"{", 
          RowBox[{"saval", ",", "sigmatot", ",", "pddist", ",", "pdmag"}], 
          "}"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"Return", "[", "out", "]"}], ";"}]}], "]"}]}], ";"}], 
   "\n"}]}]], "Input",
 CellChangeTimes->{{3.9519745867421513`*^9, 3.951974586743602*^9}, {
   3.9519748720429897`*^9, 3.951974873580778*^9}, {3.95197639995187*^9, 
   3.951976402722827*^9}, {3.951976442475004*^9, 3.951976497301921*^9}, 
   3.952173462919324*^9},
 CellLabel->"In[39]:=",ExpressionUUID->"1797a747-6c4e-42c1-bf0c-967dfdbce834"]
}, Closed]],

Cell[CellGroupData[{

Cell["AkkarEtal2013RepiHor", "Subsubsection",
 CellChangeTimes->{{3.9519747063299017`*^9, 3.951974732209299*^9}, {
  3.9519747670098867`*^9, 
  3.9519747862578783`*^9}},ExpressionUUID->"431e9056-51d0-4cd8-ada1-\
5dcd7a3cf33f"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"pgaAkkarEtal2013RepiHor", "::", "usage"}], 
   "=", "\"\<pgaAkkarEtal2013RepiHor[options] returns PGA using the model of \
Akkar et al.  (2013) for the epicentral distance distance as intrinsic \
distance metric.\>\""}], ";"}]], "Input",
 CellChangeTimes->{{3.951976612608939*^9, 3.9519766194038277`*^9}},
 CellLabel->"In[41]:=",ExpressionUUID->"c633533f-e2cf-4a05-a3f2-1950501b4427"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"AkkarEtal2013RepiHor", "::", "usage"}], 
   "=", "\"\<AkkarEtal2013RepiHor[p,options] returns \
{as,sigma,partasr,partasm}  for resonator period p  using the model of Akkar \
et al.  (2013) for the epicentral distance distance as intrinsic distance \
metric.\>\""}], ";"}]], "Input",
 CellChangeTimes->{{3.951974844050159*^9, 3.951974855330942*^9}},
 CellLabel->"In[42]:=",ExpressionUUID->"304ce2c0-2754-48d4-b0fe-5bc2d319f4d8"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
     RowBox[{
     "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**",
       "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**",
       "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**",
       "**", "**", "**", "**", "**", "**", "**", "**", "**"}], "*", 
     RowBox[{"++", 
      RowBox[{"+", "Models"}]}], " ", "of", " ", "Akkar", " ", "et", " ", 
     RowBox[{"al", ".", 
      RowBox[{"(", 
       RowBox[{"BEE", " ", "2013"}], ")"}]}]}], ",", 
    RowBox[{"for", " ", "European", " ", "earthquakes", " ", 
     RowBox[{"{", 
      RowBox[{"\"\<NORMAL\>\"", ",", "\"\<STRIKE SLIP\>\"", 
       ",", "\"\<REVERSE\>\""}], "}"}]}]}], 
   "****************************************************************************************************)"}\
], 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**",
      "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", 
     "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**",
      "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", 
     "**"}], "*"}], "*)"}], 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Options", "[", "AkkarEtal2013RepiHor", "]"}], "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"MagMW", "->", "6."}], ",", 
       RowBox[{"DistEPI", "->", "10."}], ",", 
       RowBox[{"Vs30", "->", "760."}], ",", 
       RowBox[{"FaultTypeNSSR", "->", "\"\<STRIKE SLIP\>\""}]}], "}"}]}], 
    ";"}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"AkkarEtal2013RepiHor", "[", 
      RowBox[{"per_", ",", 
       RowBox[{"opts", ":", 
        RowBox[{"OptionsPattern", "[", "]"}]}]}], "]"}], ":=", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "mw", ",", "rdist", ",", "vs30", ",", "faulttypeinp", ",", 
         "periodlist", ",", "a1list", ",", "a2list", ",", "a3list", ",", 
         "a4list", ",", "a5list", ",", "a6list", ",", "a7list", ",", "a8list",
          ",", "a9list", ",", "c1list", ",", "vconlist", ",", "vreflist", ",",
          "clist", ",", "nlist", ",", "b1list", ",", "b2list", ",", "sd1list",
          ",", "sd2list", ",", "sdlist", ",", "nreclist", ",", "neqlist", ",",
          "nstlist", ",", "a1", ",", "a2", ",", "a3", ",", "a4", ",", "a5", ",",
          "a6", ",", "a7", ",", "a8", ",", "a9", ",", "c1", ",", "vcon", ",", 
         "vref", ",", "c", ",", "n", ",", "b1", ",", "b2", ",", "sd1", ",", 
         "sd2", ",", "sd", ",", "nrec", ",", "neq", ",", "nst", ",", "fn", ",",
          "fr", ",", "lnPGAref", ",", "lns", ",", "lnrefy", ",", "saval", ",",
          "sigtotal", ",", "pddist", ",", "pdmag"}], "}"}], ",", 
       RowBox[{"(*", 
        RowBox[{"**", 
         RowBox[{"*", "Options"}]}], "****)"}], 
       RowBox[{
        RowBox[{"mw", "=", 
         RowBox[{"OptionValue", "[", "MagMW", "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"rdist", "=", 
         RowBox[{"OptionValue", "[", "DistEPI", "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"vs30", "=", 
         RowBox[{"OptionValue", "[", "Vs30", "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"faulttypeinp", "=", 
         RowBox[{"OptionValue", "[", "FaultTypeNSSR", "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{
          RowBox[{"Print", "[", 
           RowBox[{"\"\<Mw: \>\"", ",", "mw"}], "]"}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"Print", "[", 
           RowBox[{"\"\<Repi: \>\"", ",", "rdist"}], "]"}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"Print", "[", 
           RowBox[{"\"\<Vs30: \>\"", ",", "vs30"}], "]"}], ";"}], "*)"}], 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
          "periodlist", ",", "a1list", ",", "a2list", ",", "a3list", ",", 
           "a4list", ",", "a5list", ",", "a6list", ",", "a7list", ",", 
           "a8list", ",", "a9list", ",", "c1list", ",", "vconlist", ",", 
           "vreflist", ",", "clist", ",", "nlist", ",", "b1list", ",", 
           "b2list", ",", "sd1list", ",", "sd2list", ",", "sdlist", ",", 
           "nreclist", ",", "neqlist", ",", "nstlist"}], "}"}], "=", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"-", "1.`"}], ",", "0.`", ",", "0.01`", ",", "0.02`", ",",
              "0.03`", ",", "0.04`", ",", "0.05`", ",", "0.075`", ",", "0.1`",
              ",", "0.11`", ",", "0.12`", ",", "0.13`", ",", "0.14`", ",", 
             "0.15`", ",", "0.16`", ",", "0.17`", ",", "0.18`", ",", "0.19`", 
             ",", "0.2`", ",", "0.22`", ",", "0.24`", ",", "0.26`", ",", 
             "0.28`", ",", "0.3`", ",", "0.32`", ",", "0.34`", ",", "0.36`", ",",
              "0.38`", ",", "0.4`", ",", "0.42`", ",", "0.44`", ",", "0.46`", 
             ",", "0.48`", ",", "0.5`", ",", "0.55`", ",", "0.6`", ",", 
             "0.65`", ",", "0.7`", ",", "0.75`", ",", "0.8`", ",", "0.85`", ",",
              "0.9`", ",", "0.95`", ",", "1", ",", "1.1`", ",", "1.2`", ",", 
             "1.3`", ",", "1.4`", ",", "1.5`", ",", "1.6`", ",", "1.7`", ",", 
             "1.8`", ",", "1.9`", ",", "2", ",", "2.2`", ",", "2.4`", ",", 
             "2.6`", ",", "2.8`", ",", "3", ",", "3.2`", ",", "3.4`", ",", 
             "3.6`", ",", "3.8`", ",", "4"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
            "6.13498`", ",", "2.52977`", ",", "2.54832`", ",", "2.6442`", ",",
              "2.77723`", ",", "2.92666`", ",", "3.09355`", ",", "3.38462`", ",",
              "3.61906`", ",", "3.66537`", ",", "3.68544`", ",", "3.70155`", ",",
              "3.70871`", ",", "3.70477`", ",", "3.65565`", ",", "3.59764`", ",",
              "3.53732`", ",", "3.47722`", ",", "3.40112`", ",", "3.27214`", ",",
              "3.15842`", ",", "3.09498`", ",", "2.9809`", ",", "2.87449`", ",",
              "2.72364`", ",", "2.60904`", ",", "2.54266`", ",", "2.46615`", ",",
              "2.40119`", ",", "2.3454`", ",", "2.28213`", ",", "2.2344`", ",",
              "2.20123`", ",", "2.16953`", ",", "2.03012`", ",", "1.84644`", ",",
              "1.6676`", ",", "1.53432`", ",", "1.38296`", ",", "1.28662`", ",",
              "1.20114`", ",", "1.09991`", ",", "1.01256`", ",", "0.94162`", ",",
              "0.78017`", ",", "0.63219`", ",", "0.48905`", ",", "0.38492`", ",",
              "0.36315`", ",", "0.28812`", ",", "0.18172`", ",", "0.13021`", ",",
              "0.05074`", ",", 
             RowBox[{"-", "0.02806`"}], ",", 
             RowBox[{"-", "0.15016`"}], ",", 
             RowBox[{"-", "0.26608`"}], ",", 
             RowBox[{"-", "0.39025`"}], ",", 
             RowBox[{"-", "0.49742`"}], ",", 
             RowBox[{"-", "0.64241`"}], ",", 
             RowBox[{"-", "0.7667`"}], ",", 
             RowBox[{"-", "0.80566`"}], ",", 
             RowBox[{"-", "0.945`"}], ",", 
             RowBox[{"-", "0.98457`"}], ",", 
             RowBox[{"-", "0.93329`"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
            "0.0029`", ",", "0.0029`", ",", "0.0029`", ",", "0.0029`", ",", 
             "0.0029`", ",", "0.0029`", ",", "0.0029`", ",", "0.0029`", ",", 
             "0.0029`", ",", "0.0029`", ",", "0.0029`", ",", "0.0029`", ",", 
             "0.0029`", ",", "0.0029`", ",", "0.0029`", ",", "0.0029`", ",", 
             "0.0029`", ",", "0.0029`", ",", "0.0029`", ",", "0.0029`", ",", 
             "0.0029`", ",", "0.0029`", ",", "0.0029`", ",", "0.0029`", ",", 
             "0.0029`", ",", "0.0029`", ",", "0.0029`", ",", "0.0029`", ",", 
             "0.0029`", ",", "0.0029`", ",", "0.0029`", ",", "0.0029`", ",", 
             "0.0029`", ",", "0.0029`", ",", "0.0029`", ",", "0.0029`", ",", 
             "0.0029`", ",", "0.0029`", ",", "0.0029`", ",", "0.0029`", ",", 
             "0.0029`", ",", "0.0029`", ",", "0.0029`", ",", "0.0029`", ",", 
             "0.0029`", ",", "0.0029`", ",", "0.0029`", ",", "0.0029`", ",", 
             "0.0029`", ",", "0.0029`", ",", "0.0029`", ",", "0.0029`", ",", 
             "0.0029`", ",", "0.0029`", ",", "0.0029`", ",", "0.0029`", ",", 
             "0.0029`", ",", "0.0029`", ",", "0.0029`", ",", "0.0029`", ",", 
             "0.0029`", ",", "0.0029`", ",", "0.0029`", ",", "0.0029`"}], 
            "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"-", "0.12091`"}], ",", 
             RowBox[{"-", "0.05496`"}], ",", 
             RowBox[{"-", "0.05434`"}], ",", 
             RowBox[{"-", "0.05452`"}], ",", 
             RowBox[{"-", "0.05196`"}], ",", 
             RowBox[{"-", "0.04657`"}], ",", 
             RowBox[{"-", "0.04168`"}], ",", 
             RowBox[{"-", "0.03506`"}], ",", 
             RowBox[{"-", "0.03936`"}], ",", 
             RowBox[{"-", "0.04081`"}], ",", 
             RowBox[{"-", "0.04295`"}], ",", 
             RowBox[{"-", "0.04581`"}], ",", 
             RowBox[{"-", "0.04848`"}], ",", 
             RowBox[{"-", "0.05156`"}], ",", 
             RowBox[{"-", "0.0535`"}], ",", 
             RowBox[{"-", "0.05583`"}], ",", 
             RowBox[{"-", "0.0583`"}], ",", 
             RowBox[{"-", "0.0609`"}], ",", 
             RowBox[{"-", "0.0621`"}], ",", 
             RowBox[{"-", "0.06461`"}], ",", 
             RowBox[{"-", "0.06791`"}], ",", 
             RowBox[{"-", "0.07344`"}], ",", 
             RowBox[{"-", "0.07698`"}], ",", 
             RowBox[{"-", "0.08126`"}], ",", 
             RowBox[{"-", "0.08387`"}], ",", 
             RowBox[{"-", "0.08816`"}], ",", 
             RowBox[{"-", "0.09239`"}], ",", 
             RowBox[{"-", "0.09576`"}], ",", 
             RowBox[{"-", "0.09885`"}], ",", 
             RowBox[{"-", "0.10198`"}], ",", 
             RowBox[{"-", "0.10464`"}], ",", 
             RowBox[{"-", "0.10771`"}], ",", 
             RowBox[{"-", "0.11199`"}], ",", 
             RowBox[{"-", "0.11604`"}], ",", 
             RowBox[{"-", "0.12344`"}], ",", 
             RowBox[{"-", "0.12745`"}], ",", 
             RowBox[{"-", "0.13195`"}], ",", 
             RowBox[{"-", "0.13715`"}], ",", 
             RowBox[{"-", "0.14169`"}], ",", 
             RowBox[{"-", "0.14485`"}], ",", 
             RowBox[{"-", "0.14922`"}], ",", 
             RowBox[{"-", "0.1532`"}], ",", 
             RowBox[{"-", "0.157`"}], ",", 
             RowBox[{"-", "0.16069`"}], ",", 
             RowBox[{"-", "0.16727`"}], ",", 
             RowBox[{"-", "0.17174`"}], ",", 
             RowBox[{"-", "0.17712`"}], ",", 
             RowBox[{"-", "0.18237`"}], ",", 
             RowBox[{"-", "0.1879`"}], ",", 
             RowBox[{"-", "0.19363`"}], ",", 
             RowBox[{"-", "0.19545`"}], ",", 
             RowBox[{"-", "0.20069`"}], ",", 
             RowBox[{"-", "0.20386`"}], ",", 
             RowBox[{"-", "0.20666`"}], ",", 
             RowBox[{"-", "0.21319`"}], ",", 
             RowBox[{"-", "0.2196`"}], ",", 
             RowBox[{"-", "0.2233`"}], ",", 
             RowBox[{"-", "0.22716`"}], ",", 
             RowBox[{"-", "0.23038`"}], ",", 
             RowBox[{"-", "0.23049`"}], ",", 
             RowBox[{"-", "0.23726`"}], ",", 
             RowBox[{"-", "0.24437`"}], ",", 
             RowBox[{"-", "0.2493`"}], ",", 
             RowBox[{"-", "0.25756`"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"-", "1.04013`"}], ",", 
             RowBox[{"-", "1.31001`"}], ",", 
             RowBox[{"-", "1.31268`"}], ",", 
             RowBox[{"-", "1.33135`"}], ",", 
             RowBox[{"-", "1.35509`"}], ",", 
             RowBox[{"-", "1.38259`"}], ",", 
             RowBox[{"-", "1.41008`"}], ",", 
             RowBox[{"-", "1.44268`"}], ",", 
             RowBox[{"-", "1.4687`"}], ",", 
             RowBox[{"-", "1.47079`"}], ",", 
             RowBox[{"-", "1.4652`"}], ",", 
             RowBox[{"-", "1.45986`"}], ",", 
             RowBox[{"-", "1.45433`"}], ",", 
             RowBox[{"-", "1.44613`"}], ",", 
             RowBox[{"-", "1.42989`"}], ",", 
             RowBox[{"-", "1.4111`"}], ",", 
             RowBox[{"-", "1.39329`"}], ",", 
             RowBox[{"-", "1.37648`"}], ",", 
             RowBox[{"-", "1.3577`"}], ",", 
             RowBox[{"-", "1.32624`"}], ",", 
             RowBox[{"-", "1.29833`"}], ",", 
             RowBox[{"-", "1.27945`"}], ",", 
             RowBox[{"-", "1.25442`"}], ",", 
             RowBox[{"-", "1.22665`"}], ",", 
             RowBox[{"-", "1.19143`"}], ",", 
             RowBox[{"-", "1.16231`"}], ",", 
             RowBox[{"-", "1.14444`"}], ",", 
             RowBox[{"-", "1.127`"}], ",", 
             RowBox[{"-", "1.11318`"}], ",", 
             RowBox[{"-", "1.10318`"}], ",", 
             RowBox[{"-", "1.09241`"}], ",", 
             RowBox[{"-", "1.08445`"}], ",", 
             RowBox[{"-", "1.07592`"}], ",", 
             RowBox[{"-", "1.06795`"}], ",", 
             RowBox[{"-", "1.04242`"}], ",", 
             RowBox[{"-", "1.01046`"}], ",", 
             RowBox[{"-", "0.97801`"}], ",", 
             RowBox[{"-", "0.95428`"}], ",", 
             RowBox[{"-", "0.92585`"}], ",", 
             RowBox[{"-", "0.91241`"}], ",", 
             RowBox[{"-", "0.89909`"}], ",", 
             RowBox[{"-", "0.88377`"}], ",", 
             RowBox[{"-", "0.8705`"}], ",", 
             RowBox[{"-", "0.86109`"}], ",", 
             RowBox[{"-", "0.83743`"}], ",", 
             RowBox[{"-", "0.81877`"}], ",", 
             RowBox[{"-", "0.79698`"}], ",", 
             RowBox[{"-", "0.78548`"}], ",", 
             RowBox[{"-", "0.79498`"}], ",", 
             RowBox[{"-", "0.78665`"}], ",", 
             RowBox[{"-", "0.77778`"}], ",", 
             RowBox[{"-", "0.77282`"}], ",", 
             RowBox[{"-", "0.76574`"}], ",", 
             RowBox[{"-", "0.7626`"}], ",", 
             RowBox[{"-", "0.75952`"}], ",", 
             RowBox[{"-", "0.75011`"}], ",", 
             RowBox[{"-", "0.74326`"}], ",", 
             RowBox[{"-", "0.74185`"}], ",", 
             RowBox[{"-", "0.73634`"}], ",", 
             RowBox[{"-", "0.72149`"}], ",", 
             RowBox[{"-", "0.72539`"}], ",", 
             RowBox[{"-", "0.70115`"}], ",", 
             RowBox[{"-", "0.69696`"}], ",", 
             RowBox[{"-", "0.7121`"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
            "0.2529`", ",", "0.2529`", ",", "0.2529`", ",", "0.2529`", ",", 
             "0.2529`", ",", "0.2529`", ",", "0.2529`", ",", "0.2529`", ",", 
             "0.2529`", ",", "0.2529`", ",", "0.2529`", ",", "0.2529`", ",", 
             "0.2529`", ",", "0.2529`", ",", "0.2529`", ",", "0.2529`", ",", 
             "0.2529`", ",", "0.2529`", ",", "0.2529`", ",", "0.2529`", ",", 
             "0.2529`", ",", "0.2529`", ",", "0.2529`", ",", "0.2529`", ",", 
             "0.2529`", ",", "0.2529`", ",", "0.2529`", ",", "0.2529`", ",", 
             "0.2529`", ",", "0.2529`", ",", "0.2529`", ",", "0.2529`", ",", 
             "0.2529`", ",", "0.2529`", ",", "0.2529`", ",", "0.2529`", ",", 
             "0.2529`", ",", "0.2529`", ",", "0.2529`", ",", "0.2529`", ",", 
             "0.2529`", ",", "0.2529`", ",", "0.2529`", ",", "0.2529`", ",", 
             "0.2529`", ",", "0.2529`", ",", "0.2529`", ",", "0.2529`", ",", 
             "0.2529`", ",", "0.2529`", ",", "0.2529`", ",", "0.2529`", ",", 
             "0.2529`", ",", "0.2529`", ",", "0.2529`", ",", "0.2529`", ",", 
             "0.2529`", ",", "0.2529`", ",", "0.2529`", ",", "0.2529`", ",", 
             "0.2529`", ",", "0.2529`", ",", "0.2529`", ",", "0.2529`"}], 
            "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
            "7.5`", ",", "7.5`", ",", "7.5`", ",", "7.5`", ",", "7.5`", ",", 
             "7.5`", ",", "7.5`", ",", "7.5`", ",", "7.5`", ",", "7.5`", ",", 
             "7.5`", ",", "7.5`", ",", "7.5`", ",", "7.5`", ",", "7.5`", ",", 
             "7.5`", ",", "7.5`", ",", "7.5`", ",", "7.5`", ",", "7.5`", ",", 
             "7.5`", ",", "7.5`", ",", "7.5`", ",", "7.5`", ",", "7.5`", ",", 
             "7.5`", ",", "7.5`", ",", "7.5`", ",", "7.5`", ",", "7.5`", ",", 
             "7.5`", ",", "7.5`", ",", "7.5`", ",", "7.5`", ",", "7.5`", ",", 
             "7.5`", ",", "7.5`", ",", "7.5`", ",", "7.5`", ",", "7.5`", ",", 
             "7.5`", ",", "7.5`", ",", "7.5`", ",", "7.5`", ",", "7.5`", ",", 
             "7.5`", ",", "7.5`", ",", "7.5`", ",", "7.5`", ",", "7.5`", ",", 
             "7.5`", ",", "7.5`", ",", "7.5`", ",", "7.5`", ",", "7.5`", ",", 
             "7.5`", ",", "7.5`", ",", "7.5`", ",", "7.5`", ",", "7.5`", ",", 
             "7.5`", ",", "7.5`", ",", "7.5`", ",", "7.5`"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"-", "0.5096`"}], ",", 
             RowBox[{"-", "0.5096`"}], ",", 
             RowBox[{"-", "0.5096`"}], ",", 
             RowBox[{"-", "0.5096`"}], ",", 
             RowBox[{"-", "0.5096`"}], ",", 
             RowBox[{"-", "0.5096`"}], ",", 
             RowBox[{"-", "0.5096`"}], ",", 
             RowBox[{"-", "0.5096`"}], ",", 
             RowBox[{"-", "0.5096`"}], ",", 
             RowBox[{"-", "0.5096`"}], ",", 
             RowBox[{"-", "0.5096`"}], ",", 
             RowBox[{"-", "0.5096`"}], ",", 
             RowBox[{"-", "0.5096`"}], ",", 
             RowBox[{"-", "0.5096`"}], ",", 
             RowBox[{"-", "0.5096`"}], ",", 
             RowBox[{"-", "0.5096`"}], ",", 
             RowBox[{"-", "0.5096`"}], ",", 
             RowBox[{"-", "0.5096`"}], ",", 
             RowBox[{"-", "0.5096`"}], ",", 
             RowBox[{"-", "0.5096`"}], ",", 
             RowBox[{"-", "0.5096`"}], ",", 
             RowBox[{"-", "0.5096`"}], ",", 
             RowBox[{"-", "0.5096`"}], ",", 
             RowBox[{"-", "0.5096`"}], ",", 
             RowBox[{"-", "0.5096`"}], ",", 
             RowBox[{"-", "0.5096`"}], ",", 
             RowBox[{"-", "0.5096`"}], ",", 
             RowBox[{"-", "0.5096`"}], ",", 
             RowBox[{"-", "0.5096`"}], ",", 
             RowBox[{"-", "0.5096`"}], ",", 
             RowBox[{"-", "0.5096`"}], ",", 
             RowBox[{"-", "0.5096`"}], ",", 
             RowBox[{"-", "0.5096`"}], ",", 
             RowBox[{"-", "0.5096`"}], ",", 
             RowBox[{"-", "0.5096`"}], ",", 
             RowBox[{"-", "0.5096`"}], ",", 
             RowBox[{"-", "0.5096`"}], ",", 
             RowBox[{"-", "0.5096`"}], ",", 
             RowBox[{"-", "0.5096`"}], ",", 
             RowBox[{"-", "0.5096`"}], ",", 
             RowBox[{"-", "0.5096`"}], ",", 
             RowBox[{"-", "0.5096`"}], ",", 
             RowBox[{"-", "0.5096`"}], ",", 
             RowBox[{"-", "0.5096`"}], ",", 
             RowBox[{"-", "0.5096`"}], ",", 
             RowBox[{"-", "0.5096`"}], ",", 
             RowBox[{"-", "0.5096`"}], ",", 
             RowBox[{"-", "0.5096`"}], ",", 
             RowBox[{"-", "0.5096`"}], ",", 
             RowBox[{"-", "0.5096`"}], ",", 
             RowBox[{"-", "0.5096`"}], ",", 
             RowBox[{"-", "0.5096`"}], ",", 
             RowBox[{"-", "0.5096`"}], ",", 
             RowBox[{"-", "0.5096`"}], ",", 
             RowBox[{"-", "0.5096`"}], ",", 
             RowBox[{"-", "0.5096`"}], ",", 
             RowBox[{"-", "0.5096`"}], ",", 
             RowBox[{"-", "0.5096`"}], ",", 
             RowBox[{"-", "0.5096`"}], ",", 
             RowBox[{"-", "0.5096`"}], ",", 
             RowBox[{"-", "0.5096`"}], ",", 
             RowBox[{"-", "0.5096`"}], ",", 
             RowBox[{"-", "0.5096`"}], ",", 
             RowBox[{"-", "0.5096`"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"-", "0.0616`"}], ",", 
             RowBox[{"-", "0.1091`"}], ",", 
             RowBox[{"-", "0.1115`"}], ",", 
             RowBox[{"-", "0.104`"}], ",", 
             RowBox[{"-", "0.0973`"}], ",", 
             RowBox[{"-", "0.0884`"}], ",", 
             RowBox[{"-", "0.0853`"}], ",", 
             RowBox[{"-", "0.0779`"}], ",", 
             RowBox[{"-", "0.0749`"}], ",", 
             RowBox[{"-", "0.0704`"}], ",", 
             RowBox[{"-", "0.0604`"}], ",", 
             RowBox[{"-", "0.049`"}], ",", 
             RowBox[{"-", "0.0377`"}], ",", 
             RowBox[{"-", "0.0265`"}], ",", 
             RowBox[{"-", "0.0194`"}], ",", 
             RowBox[{"-", "0.0125`"}], ",", 
             RowBox[{"-", "0.0056`"}], ",", "0", ",", "0", ",", "0", ",", "0",
              ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",",
              "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0",
              ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",",
              "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0",
              ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",",
              "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0",
              ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
            "0.063`", ",", "0.0937`", ",", "0.0953`", ",", "0.1029`", ",", 
             "0.1148`", ",", "0.1073`", ",", "0.1052`", ",", "0.0837`", ",", 
             "0.0761`", ",", "0.0707`", ",", "0.0653`", ",", "0.0617`", ",", 
             "0.0581`", ",", "0.0545`", ",", "0.0509`", ",", "0.0507`", ",", 
             "0.0502`", ",", "0.0497`", ",", "0.0493`", ",", "0.0488`", ",", 
             "0.0483`", ",", "0.0478`", ",", "0.0474`", ",", "0.0469`", ",", 
             "0.0464`", ",", "0.0459`", ",", "0.0459`", ",", "0.0429`", ",", 
             "0.04`", ",", "0.0374`", ",", "0.0349`", ",", "0.0323`", ",", 
             "0.0297`", ",", "0.0271`", ",", "0.0245`", ",", "0.0219`", ",", 
             "0.0193`", ",", "0.0167`", ",", "0.0141`", ",", "0.0115`", ",", 
             "0.0089`", ",", "0.0062`", ",", "0.0016`", ",", "0", ",", "0", ",",
              "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
             RowBox[{"-", "0.003`"}], ",", 
             RowBox[{"-", "0.006`"}], ",", 
             RowBox[{"-", "0.009`"}], ",", 
             RowBox[{"-", "0.0141`"}], ",", 
             RowBox[{"-", "0.0284`"}], ",", 
             RowBox[{"-", "0.0408`"}], ",", 
             RowBox[{"-", "0.0534`"}], ",", 
             RowBox[{"-", "0.0683`"}], ",", 
             RowBox[{"-", "0.078`"}], ",", 
             RowBox[{"-", "0.0943`"}], ",", 
             RowBox[{"-", "0.1278`"}], ",", 
             RowBox[{"-", "0.1744`"}], ",", 
             RowBox[{"-", "0.2231`"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
            "6.75`", ",", "6.75`", ",", "6.75`", ",", "6.75`", ",", "6.75`", ",",
              "6.75`", ",", "6.75`", ",", "6.75`", ",", "6.75`", ",", "6.75`",
              ",", "6.75`", ",", "6.75`", ",", "6.75`", ",", "6.75`", ",", 
             "6.75`", ",", "6.75`", ",", "6.75`", ",", "6.75`", ",", "6.75`", 
             ",", "6.75`", ",", "6.75`", ",", "6.75`", ",", "6.75`", ",", 
             "6.75`", ",", "6.75`", ",", "6.75`", ",", "6.75`", ",", "6.75`", 
             ",", "6.75`", ",", "6.75`", ",", "6.75`", ",", "6.75`", ",", 
             "6.75`", ",", "6.75`", ",", "6.75`", ",", "6.75`", ",", "6.75`", 
             ",", "6.75`", ",", "6.75`", ",", "6.75`", ",", "6.75`", ",", 
             "6.75`", ",", "6.75`", ",", "6.75`", ",", "6.75`", ",", "6.75`", 
             ",", "6.75`", ",", "6.75`", ",", "6.75`", ",", "6.75`", ",", 
             "6.75`", ",", "6.75`", ",", "6.75`", ",", "6.75`", ",", "6.75`", 
             ",", "6.75`", ",", "6.75`", ",", "6.75`", ",", "6.75`", ",", 
             "6.75`", ",", "6.75`", ",", "6.75`", ",", "6.75`", ",", 
             "6.75`"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
            "1000", ",", "1000", ",", "1000", ",", "1000", ",", "1000", ",", 
             "1000", ",", "1000", ",", "1000", ",", "1000", ",", "1000", ",", 
             "1000", ",", "1000", ",", "1000", ",", "1000", ",", "1000", ",", 
             "1000", ",", "1000", ",", "1000", ",", "1000", ",", "1000", ",", 
             "1000", ",", "1000", ",", "1000", ",", "1000", ",", "1000", ",", 
             "1000", ",", "1000", ",", "1000", ",", "1000", ",", "1000", ",", 
             "1000", ",", "1000", ",", "1000", ",", "1000", ",", "1000", ",", 
             "1000", ",", "1000", ",", "1000", ",", "1000", ",", "1000", ",", 
             "1000", ",", "1000", ",", "1000", ",", "1000", ",", "1000", ",", 
             "1000", ",", "1000", ",", "1000", ",", "1000", ",", "1000", ",", 
             "1000", ",", "1000", ",", "1000", ",", "1000", ",", "1000", ",", 
             "1000", ",", "1000", ",", "1000", ",", "1000", ",", "1000", ",", 
             "1000", ",", "1000", ",", "1000", ",", "1000"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
            "750", ",", "750", ",", "750", ",", "750", ",", "750", ",", "750",
              ",", "750", ",", "750", ",", "750", ",", "750", ",", "750", ",",
              "750", ",", "750", ",", "750", ",", "750", ",", "750", ",", 
             "750", ",", "750", ",", "750", ",", "750", ",", "750", ",", 
             "750", ",", "750", ",", "750", ",", "750", ",", "750", ",", 
             "750", ",", "750", ",", "750", ",", "750", ",", "750", ",", 
             "750", ",", "750", ",", "750", ",", "750", ",", "750", ",", 
             "750", ",", "750", ",", "750", ",", "750", ",", "750", ",", 
             "750", ",", "750", ",", "750", ",", "750", ",", "750", ",", 
             "750", ",", "750", ",", "750", ",", "750", ",", "750", ",", 
             "750", ",", "750", ",", "750", ",", "750", ",", "750", ",", 
             "750", ",", "750", ",", "750", ",", "750", ",", "750", ",", 
             "750", ",", "750", ",", "750"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
            "2.5`", ",", "2.5`", ",", "2.5`", ",", "2.5`", ",", "2.5`", ",", 
             "2.5`", ",", "2.5`", ",", "2.5`", ",", "2.5`", ",", "2.5`", ",", 
             "2.5`", ",", "2.5`", ",", "2.5`", ",", "2.5`", ",", "2.5`", ",", 
             "2.5`", ",", "2.5`", ",", "2.5`", ",", "2.5`", ",", "2.5`", ",", 
             "2.5`", ",", "2.5`", ",", "2.5`", ",", "2.5`", ",", "2.5`", ",", 
             "2.5`", ",", "2.5`", ",", "2.5`", ",", "2.5`", ",", "2.5`", ",", 
             "2.5`", ",", "2.5`", ",", "2.5`", ",", "2.5`", ",", "2.5`", ",", 
             "2.5`", ",", "2.5`", ",", "2.5`", ",", "2.5`", ",", "2.5`", ",", 
             "2.5`", ",", "2.5`", ",", "2.5`", ",", "2.5`", ",", "2.5`", ",", 
             "2.5`", ",", "2.5`", ",", "2.5`", ",", "2.5`", ",", "2.5`", ",", 
             "2.5`", ",", "2.5`", ",", "2.5`", ",", "2.5`", ",", "2.5`", ",", 
             "2.5`", ",", "2.5`", ",", "2.5`", ",", "2.5`", ",", "2.5`", ",", 
             "2.5`", ",", "2.5`", ",", "2.5`", ",", "2.5`"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
            "3.2`", ",", "3.2`", ",", "3.2`", ",", "3.2`", ",", "3.2`", ",", 
             "3.2`", ",", "3.2`", ",", "3.2`", ",", "3.2`", ",", "3.2`", ",", 
             "3.2`", ",", "3.2`", ",", "3.2`", ",", "3.2`", ",", "3.2`", ",", 
             "3.2`", ",", "3.2`", ",", "3.2`", ",", "3.2`", ",", "3.2`", ",", 
             "3.2`", ",", "3.2`", ",", "3.2`", ",", "3.2`", ",", "3.2`", ",", 
             "3.2`", ",", "3.2`", ",", "3.2`", ",", "3.2`", ",", "3.2`", ",", 
             "3.2`", ",", "3.2`", ",", "3.2`", ",", "3.2`", ",", "3.2`", ",", 
             "3.2`", ",", "3.2`", ",", "3.2`", ",", "3.2`", ",", "3.2`", ",", 
             "3.2`", ",", "3.2`", ",", "3.2`", ",", "3.2`", ",", "3.2`", ",", 
             "3.2`", ",", "3.2`", ",", "3.2`", ",", "3.2`", ",", "3.2`", ",", 
             "3.2`", ",", "3.2`", ",", "3.2`", ",", "3.2`", ",", "3.2`", ",", 
             "3.2`", ",", "3.2`", ",", "3.2`", ",", "3.2`", ",", "3.2`", ",", 
             "3.2`", ",", "3.2`", ",", "3.2`", ",", "3.2`"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"-", "0.72057`"}], ",", 
             RowBox[{"-", "0.41997`"}], ",", 
             RowBox[{"-", "0.41729`"}], ",", 
             RowBox[{"-", "0.39998`"}], ",", 
             RowBox[{"-", "0.34799`"}], ",", 
             RowBox[{"-", "0.27572`"}], ",", 
             RowBox[{"-", "0.21231`"}], ",", 
             RowBox[{"-", "0.14427`"}], ",", 
             RowBox[{"-", "0.27064`"}], ",", 
             RowBox[{"-", "0.31025`"}], ",", 
             RowBox[{"-", "0.34796`"}], ",", 
             RowBox[{"-", "0.39668`"}], ",", 
             RowBox[{"-", "0.43996`"}], ",", 
             RowBox[{"-", "0.48313`"}], ",", 
             RowBox[{"-", "0.52431`"}], ",", 
             RowBox[{"-", "0.5568`"}], ",", 
             RowBox[{"-", "0.58922`"}], ",", 
             RowBox[{"-", "0.62635`"}], ",", 
             RowBox[{"-", "0.65315`"}], ",", 
             RowBox[{"-", "0.68711`"}], ",", 
             RowBox[{"-", "0.72744`"}], ",", 
             RowBox[{"-", "0.77335`"}], ",", 
             RowBox[{"-", "0.80508`"}], ",", 
             RowBox[{"-", "0.82609`"}], ",", 
             RowBox[{"-", "0.8408`"}], ",", 
             RowBox[{"-", "0.86251`"}], ",", 
             RowBox[{"-", "0.87479`"}], ",", 
             RowBox[{"-", "0.88522`"}], ",", 
             RowBox[{"-", "0.89517`"}], ",", 
             RowBox[{"-", "0.90875`"}], ",", 
             RowBox[{"-", "0.91922`"}], ",", 
             RowBox[{"-", "0.9267`"}], ",", 
             RowBox[{"-", "0.9372`"}], ",", 
             RowBox[{"-", "0.94614`"}], ",", 
             RowBox[{"-", "0.96564`"}], ",", 
             RowBox[{"-", "0.98499`"}], ",", 
             RowBox[{"-", "0.99733`"}], ",", 
             RowBox[{"-", "1.00469`"}], ",", 
             RowBox[{"-", "1.00786`"}], ",", 
             RowBox[{"-", "1.00606`"}], ",", 
             RowBox[{"-", "1.01093`"}], ",", 
             RowBox[{"-", "1.01576`"}], ",", 
             RowBox[{"-", "1.01353`"}], ",", 
             RowBox[{"-", "1.01331`"}], ",", 
             RowBox[{"-", "1.0124`"}], ",", 
             RowBox[{"-", "1.00489`"}], ",", 
             RowBox[{"-", "0.98876`"}], ",", 
             RowBox[{"-", "0.9776`"}], ",", 
             RowBox[{"-", "0.98071`"}], ",", 
             RowBox[{"-", "0.96369`"}], ",", 
             RowBox[{"-", "0.94634`"}], ",", 
             RowBox[{"-", "0.93606`"}], ",", 
             RowBox[{"-", "0.91408`"}], ",", 
             RowBox[{"-", "0.91007`"}], ",", 
             RowBox[{"-", "0.89376`"}], ",", 
             RowBox[{"-", "0.87052`"}], ",", 
             RowBox[{"-", "0.85889`"}], ",", 
             RowBox[{"-", "0.86106`"}], ",", 
             RowBox[{"-", "0.85793`"}], ",", 
             RowBox[{"-", "0.82094`"}], ",", 
             RowBox[{"-", "0.84449`"}], ",", 
             RowBox[{"-", "0.83216`"}], ",", 
             RowBox[{"-", "0.79216`"}], ",", 
             RowBox[{"-", "0.75645`"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"-", "0.19688`"}], ",", 
             RowBox[{"-", "0.28846`"}], ",", 
             RowBox[{"-", "0.28685`"}], ",", 
             RowBox[{"-", "0.28241`"}], ",", 
             RowBox[{"-", "0.26842`"}], ",", 
             RowBox[{"-", "0.24759`"}], ",", 
             RowBox[{"-", "0.22385`"}], ",", 
             RowBox[{"-", "0.17525`"}], ",", 
             RowBox[{"-", "0.29293`"}], ",", 
             RowBox[{"-", "0.31837`"}], ",", 
             RowBox[{"-", "0.3386`"}], ",", 
             RowBox[{"-", "0.36646`"}], ",", 
             RowBox[{"-", "0.38417`"}], ",", 
             RowBox[{"-", "0.39551`"}], ",", 
             RowBox[{"-", "0.40869`"}], ",", 
             RowBox[{"-", "0.41528`"}], ",", 
             RowBox[{"-", "0.42717`"}], ",", 
             RowBox[{"-", "0.4413`"}], ",", 
             RowBox[{"-", "0.44644`"}], ",", 
             RowBox[{"-", "0.44872`"}], ",", 
             RowBox[{"-", "0.46341`"}], ",", 
             RowBox[{"-", "0.48705`"}], ",", 
             RowBox[{"-", "0.47334`"}], ",", 
             RowBox[{"-", "0.4573`"}], ",", 
             RowBox[{"-", "0.44267`"}], ",", 
             RowBox[{"-", "0.43888`"}], ",", 
             RowBox[{"-", "0.4382`"}], ",", 
             RowBox[{"-", "0.43678`"}], ",", 
             RowBox[{"-", "0.43008`"}], ",", 
             RowBox[{"-", "0.4219`"}], ",", 
             RowBox[{"-", "0.40903`"}], ",", 
             RowBox[{"-", "0.39442`"}], ",", 
             RowBox[{"-", "0.38462`"}], ",", 
             RowBox[{"-", "0.37408`"}], ",", 
             RowBox[{"-", "0.35582`"}], ",", 
             RowBox[{"-", "0.34053`"}], ",", 
             RowBox[{"-", "0.30949`"}], ",", 
             RowBox[{"-", "0.28772`"}], ",", 
             RowBox[{"-", "0.28957`"}], ",", 
             RowBox[{"-", "0.28555`"}], ",", 
             RowBox[{"-", "0.28364`"}], ",", 
             RowBox[{"-", "0.28037`"}], ",", 
             RowBox[{"-", "0.2839`"}], ",", 
             RowBox[{"-", "0.28702`"}], ",", 
             RowBox[{"-", "0.27669`"}], ",", 
             RowBox[{"-", "0.27538`"}], ",", 
             RowBox[{"-", "0.25008`"}], ",", 
             RowBox[{"-", "0.23508`"}], ",", 
             RowBox[{"-", "0.24695`"}], ",", 
             RowBox[{"-", "0.2287`"}], ",", 
             RowBox[{"-", "0.21655`"}], ",", 
             RowBox[{"-", "0.20302`"}], ",", 
             RowBox[{"-", "0.18228`"}], ",", 
             RowBox[{"-", "0.17336`"}], ",", 
             RowBox[{"-", "0.15463`"}], ",", 
             RowBox[{"-", "0.13181`"}], ",", 
             RowBox[{"-", "0.14066`"}], ",", 
             RowBox[{"-", "0.13882`"}], ",", 
             RowBox[{"-", "0.13336`"}], ",", 
             RowBox[{"-", "0.1377`"}], ",", 
             RowBox[{"-", "0.15337`"}], ",", 
             RowBox[{"-", "0.10884`"}], ",", 
             RowBox[{"-", "0.08884`"}], ",", 
             RowBox[{"-", "0.07749`"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
            "0.6143`", ",", "0.6375`", ",", "0.6389`", ",", "0.6434`", ",", 
             "0.6569`", ",", "0.6693`", ",", "0.6773`", ",", "0.6791`", ",", 
             "0.6851`", ",", "0.6884`", ",", "0.696`", ",", "0.6997`", ",", 
             "0.7032`", ",", "0.7011`", ",", "0.6997`", ",", "0.697`", ",", 
             "0.6956`", ",", "0.6915`", ",", "0.6922`", ",", "0.6893`", ",", 
             "0.6942`", ",", "0.6938`", ",", "0.6877`", ",", "0.6897`", ",", 
             "0.6947`", ",", "0.6939`", ",", "0.6945`", ",", "0.6971`", ",", 
             "0.6971`", ",", "0.6955`", ",", "0.6891`", ",", "0.6825`", ",", 
             "0.6785`", ",", "0.6751`", ",", "0.6788`", ",", "0.6845`", ",", 
             "0.6857`", ",", "0.6902`", ",", "0.6937`", ",", "0.6884`", ",", 
             "0.6866`", ",", "0.6881`", ",", "0.6904`", ",", "0.6922`", ",", 
             "0.7047`", ",", "0.7138`", ",", "0.7137`", ",", "0.7263`", ",", 
             "0.7287`", ",", "0.7307`", ",", "0.7322`", ",", "0.7316`", ",", 
             "0.7341`", ",", "0.7333`", ",", "0.7277`", ",", "0.7199`", ",", 
             "0.7171`", ",", "0.7175`", ",", "0.7051`", ",", "0.6876`", ",", 
             "0.675`", ",", "0.6571`", ",", "0.6438`", ",", "0.6241`"}], 
            "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
            "0.3485`", ",", "0.3581`", ",", "0.3607`", ",", "0.3615`", ",", 
             "0.3617`", ",", "0.353`", ",", "0.3612`", ",", "0.3853`", ",", 
             "0.416`", ",", "0.4163`", ",", "0.4118`", ",", "0.4102`", ",", 
             "0.4028`", ",", "0.3978`", ",", "0.3989`", ",", "0.403`", ",", 
             "0.4041`", ",", "0.4017`", ",", "0.3965`", ",", "0.4005`", ",", 
             "0.3919`", ",", "0.3898`", ",", "0.3883`", ",", "0.3894`", ",", 
             "0.3941`", ",", "0.3937`", ",", "0.3997`", ",", "0.4012`", ",", 
             "0.4012`", ",", "0.3946`", ",", "0.3985`", ",", "0.4056`", ",", 
             "0.4068`", ",", "0.4065`", ",", "0.4087`", ",", "0.4085`", ",", 
             "0.4128`", ",", "0.4101`", ",", "0.4011`", ",", "0.3962`", ",", 
             "0.3951`", ",", "0.3979`", ",", "0.3955`", ",", "0.3965`", ",", 
             "0.3819`", ",", "0.3807`", ",", "0.3827`", ",", "0.3787`", ",", 
             "0.3821`", ",", "0.3854`", ",", "0.3751`", ",", "0.3749`", ",", 
             "0.3761`", ",", "0.3734`", ",", "0.3794`", ",", "0.4025`", ",", 
             "0.4049`", ",", "0.409`", ",", "0.4115`", ",", "0.428`", ",", 
             "0.4029`", ",", "0.4252`", ",", "0.4243`", ",", "0.3659`"}], 
            "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
            "0.7063`", ",", "0.7312`", ",", "0.7337`", ",", "0.738`", ",", 
             "0.7499`", ",", "0.7567`", ",", "0.7676`", ",", "0.7808`", ",", 
             "0.8015`", ",", "0.8045`", ",", "0.8087`", ",", "0.8111`", ",", 
             "0.8104`", ",", "0.8061`", ",", "0.8054`", ",", "0.8051`", ",", 
             "0.8045`", ",", "0.7997`", ",", "0.7977`", ",", "0.7972`", ",", 
             "0.7972`", ",", "0.7958`", ",", "0.7898`", ",", "0.792`", ",", 
             "0.7987`", ",", "0.7978`", ",", "0.8013`", ",", "0.8043`", ",", 
             "0.8043`", ",", "0.7996`", ",", "0.796`", ",", "0.7939`", ",", 
             "0.7911`", ",", "0.788`", ",", "0.7923`", ",", "0.7971`", ",", 
             "0.8004`", ",", "0.8028`", ",", "0.8013`", ",", "0.7943`", ",", 
             "0.7922`", ",", "0.7949`", ",", "0.7957`", ",", "0.7977`", ",", 
             "0.8015`", ",", "0.809`", ",", "0.8098`", ",", "0.8191`", ",", 
             "0.8228`", ",", "0.8261`", ",", "0.8227`", ",", "0.8221`", ",", 
             "0.8248`", ",", "0.8229`", ",", "0.8207`", ",", "0.8248`", ",", 
             "0.8235`", ",", "0.8259`", ",", "0.8164`", ",", "0.8099`", ",", 
             "0.7861`", ",", "0.7827`", ",", "0.771`", ",", "0.7235`"}], 
            "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
            "1041", ",", "1041", ",", "1041", ",", "1041", ",", "1041", ",", 
             "1041", ",", "1041", ",", "1041", ",", "1041", ",", "1041", ",", 
             "1041", ",", "1041", ",", "1041", ",", "1041", ",", "1041", ",", 
             "1041", ",", "1041", ",", "1041", ",", "1041", ",", "1041", ",", 
             "1041", ",", "1041", ",", "1041", ",", "1041", ",", "1041", ",", 
             "1041", ",", "1041", ",", "1041", ",", "1041", ",", "1041", ",", 
             "1041", ",", "1041", ",", "1041", ",", "1041", ",", "1041", ",", 
             "1040", ",", "1038", ",", "1037", ",", "1032", ",", "1028", ",", 
             "1028", ",", "1024", ",", "1023", ",", "1023", ",", "1020", ",", 
             "1008", ",", "1006", ",", "1004", ",", "990", ",", "983", ",", 
             "978", ",", "960", ",", "953", ",", "953", ",", "948", ",", 
             "914", ",", "900", ",", "892", ",", "858", ",", "817", ",", 
             "785", ",", "722", ",", "690", ",", "659"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
            "221", ",", "221", ",", "221", ",", "221", ",", "221", ",", "221",
              ",", "221", ",", "221", ",", "221", ",", "221", ",", "221", ",",
              "221", ",", "221", ",", "221", ",", "221", ",", "221", ",", 
             "221", ",", "221", ",", "221", ",", "221", ",", "221", ",", 
             "221", ",", "221", ",", "221", ",", "221", ",", "221", ",", 
             "221", ",", "221", ",", "221", ",", "221", ",", "221", ",", 
             "221", ",", "221", ",", "221", ",", "221", ",", "221", ",", 
             "221", ",", "221", ",", "221", ",", "220", ",", "220", ",", 
             "220", ",", "220", ",", "220", ",", "220", ",", "217", ",", 
             "217", ",", "217", ",", "215", ",", "214", ",", "213", ",", 
             "209", ",", "209", ",", "209", ",", "209", ",", "199", ",", 
             "198", ",", "197", ",", "195", ",", "188", ",", "183", ",", 
             "170", ",", "166", ",", "160"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
            "322", ",", "322", ",", "322", ",", "322", ",", "322", ",", "322",
              ",", "322", ",", "322", ",", "322", ",", "322", ",", "322", ",",
              "322", ",", "322", ",", "322", ",", "322", ",", "322", ",", 
             "322", ",", "322", ",", "322", ",", "322", ",", "322", ",", 
             "322", ",", "322", ",", "322", ",", "322", ",", "322", ",", 
             "322", ",", "322", ",", "322", ",", "322", ",", "322", ",", 
             "322", ",", "322", ",", "322", ",", "322", ",", "322", ",", 
             "321", ",", "321", ",", "321", ",", "321", ",", "321", ",", 
             "320", ",", "319", ",", "319", ",", "319", ",", "317", ",", 
             "316", ",", "315", ",", "312", ",", "308", ",", "307", ",", 
             "302", ",", "300", ",", "300", ",", "299", ",", "292", ",", 
             "291", ",", "287", ",", "278", ",", "275", ",", "269", ",", 
             "248", ",", "242", ",", "238"}], "}"}]}], "}"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"SetOptions", "[", 
         RowBox[{"InterpolateCoefficientList", ",", 
          RowBox[{"IpolHalfWindowLength", "->", "ilenALL"}], ",", 
          RowBox[{"IpolOrder", "->", "ipolorderALL"}], ",", 
          RowBox[{"IpolType", "->", "ipolTypeAll"}]}], "]"}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"Which", "[", 
         RowBox[{
          RowBox[{"per", "<", 
           RowBox[{"periodlist", "[", 
            RowBox[{"[", "2", "]"}], "]"}]}], ",", 
          RowBox[{"(*", "PGV", "*)"}], 
          RowBox[{
           RowBox[{"a1", "=", 
            RowBox[{"a1list", "[", 
             RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"a2", "=", 
            RowBox[{"a2list", "[", 
             RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"a3", "=", 
            RowBox[{"a3list", "[", 
             RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"a4", "=", 
            RowBox[{"a4list", "[", 
             RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"a5", "=", 
            RowBox[{"a5list", "[", 
             RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"a6", "=", 
            RowBox[{"a6list", "[", 
             RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"a7", "=", 
            RowBox[{"a7list", "[", 
             RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"a8", "=", 
            RowBox[{"a8list", "[", 
             RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"a9", "=", 
            RowBox[{"a9list", "[", 
             RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"c1", "=", 
            RowBox[{"c1list", "[", 
             RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"vcon", "=", 
            RowBox[{"vconlist", "[", 
             RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"vref", "=", 
            RowBox[{"vreflist", "[", 
             RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"c", "=", 
            RowBox[{"clist", "[", 
             RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"n", "=", 
            RowBox[{"nlist", "[", 
             RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"b1", "=", 
            RowBox[{"b1list", "[", 
             RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"b2", "=", 
            RowBox[{"b2list", "[", 
             RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"sd1", "=", 
            RowBox[{"sd1list", "[", 
             RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"sd2", "=", 
            RowBox[{"sd2list", "[", 
             RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"sd", "=", 
            RowBox[{"sdlist", "[", 
             RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"nrec", "=", 
            RowBox[{"nreclist", "[", 
             RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"neq", "=", 
            RowBox[{"neqlist", "[", 
             RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"nst", "=", 
            RowBox[{"nstlist", "[", 
             RowBox[{"[", "1", "]"}], "]"}]}], ";"}], ",", 
          RowBox[{"0.", "<=", "per", "<", 
           RowBox[{"periodlist", "[", 
            RowBox[{"[", "3", "]"}], "]"}]}], ",", 
          RowBox[{"(*", "PGA", "*)"}], 
          RowBox[{
           RowBox[{"a1", "=", 
            RowBox[{"a1list", "[", 
             RowBox[{"[", "2", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"a2", "=", 
            RowBox[{"a2list", "[", 
             RowBox[{"[", "2", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"a3", "=", 
            RowBox[{"a3list", "[", 
             RowBox[{"[", "2", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"a4", "=", 
            RowBox[{"a4list", "[", 
             RowBox[{"[", "2", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"a5", "=", 
            RowBox[{"a5list", "[", 
             RowBox[{"[", "2", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"a6", "=", 
            RowBox[{"a6list", "[", 
             RowBox[{"[", "2", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"a7", "=", 
            RowBox[{"a7list", "[", 
             RowBox[{"[", "2", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"a8", "=", 
            RowBox[{"a8list", "[", 
             RowBox[{"[", "2", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"a9", "=", 
            RowBox[{"a9list", "[", 
             RowBox[{"[", "2", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"c1", "=", 
            RowBox[{"c1list", "[", 
             RowBox[{"[", "2", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"vcon", "=", 
            RowBox[{"vconlist", "[", 
             RowBox[{"[", "2", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"vref", "=", 
            RowBox[{"vreflist", "[", 
             RowBox[{"[", "2", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"c", "=", 
            RowBox[{"clist", "[", 
             RowBox[{"[", "2", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"n", "=", 
            RowBox[{"nlist", "[", 
             RowBox[{"[", "2", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"b1", "=", 
            RowBox[{"b1list", "[", 
             RowBox[{"[", "2", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"b2", "=", 
            RowBox[{"b2list", "[", 
             RowBox[{"[", "2", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"sd1", "=", 
            RowBox[{"sd1list", "[", 
             RowBox[{"[", "2", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"sd2", "=", 
            RowBox[{"sd2list", "[", 
             RowBox[{"[", "2", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"sd", "=", 
            RowBox[{"sdlist", "[", 
             RowBox[{"[", "2", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"nrec", "=", 
            RowBox[{"nreclist", "[", 
             RowBox[{"[", "2", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"neq", "=", 
            RowBox[{"neqlist", "[", 
             RowBox[{"[", "2", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"nst", "=", 
            RowBox[{"nstlist", "[", 
             RowBox[{"[", "2", "]"}], "]"}]}], ";"}], ",", 
          RowBox[{
           RowBox[{"periodlist", "[", 
            RowBox[{"[", "3", "]"}], "]"}], "<=", "per"}], ",", 
          RowBox[{"(*", "PSA", "*)"}], 
          RowBox[{
           RowBox[{"a1", "=", 
            RowBox[{"InterpolateCoefficientList", "[", 
             RowBox[{"per", ",", "periodlist", ",", "a1list"}], "]"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"a2", "=", 
            RowBox[{"InterpolateCoefficientList", "[", 
             RowBox[{"per", ",", "periodlist", ",", "a2list"}], "]"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"a3", "=", 
            RowBox[{"InterpolateCoefficientList", "[", 
             RowBox[{"per", ",", "periodlist", ",", "a3list"}], "]"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"a4", "=", 
            RowBox[{"InterpolateCoefficientList", "[", 
             RowBox[{"per", ",", "periodlist", ",", "a4list"}], "]"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"a5", "=", 
            RowBox[{"InterpolateCoefficientList", "[", 
             RowBox[{"per", ",", "periodlist", ",", "a5list"}], "]"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"a6", "=", 
            RowBox[{"InterpolateCoefficientList", "[", 
             RowBox[{"per", ",", "periodlist", ",", "a6list"}], "]"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"a7", "=", 
            RowBox[{"InterpolateCoefficientList", "[", 
             RowBox[{"per", ",", "periodlist", ",", "a7list"}], "]"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"a8", "=", 
            RowBox[{"InterpolateCoefficientList", "[", 
             RowBox[{"per", ",", "periodlist", ",", "a8list"}], "]"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"a9", "=", 
            RowBox[{"InterpolateCoefficientList", "[", 
             RowBox[{"per", ",", "periodlist", ",", "a9list"}], "]"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"c1", "=", 
            RowBox[{"InterpolateCoefficientList", "[", 
             RowBox[{"per", ",", "periodlist", ",", "c1list"}], "]"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"vcon", "=", 
            RowBox[{"InterpolateCoefficientList", "[", 
             RowBox[{"per", ",", "periodlist", ",", "vconlist"}], "]"}]}], ";",
            "\[IndentingNewLine]", 
           RowBox[{"vref", "=", 
            RowBox[{"InterpolateCoefficientList", "[", 
             RowBox[{"per", ",", "periodlist", ",", "vreflist"}], "]"}]}], ";",
            "\[IndentingNewLine]", 
           RowBox[{"c", "=", 
            RowBox[{"InterpolateCoefficientList", "[", 
             RowBox[{"per", ",", "periodlist", ",", "clist"}], "]"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"n", "=", 
            RowBox[{"InterpolateCoefficientList", "[", 
             RowBox[{"per", ",", "periodlist", ",", "nlist"}], "]"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"b1", "=", 
            RowBox[{"InterpolateCoefficientList", "[", 
             RowBox[{"per", ",", "periodlist", ",", "b1list"}], "]"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"b2", "=", 
            RowBox[{"InterpolateCoefficientList", "[", 
             RowBox[{"per", ",", "periodlist", ",", "b2list"}], "]"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"sd1", "=", 
            RowBox[{"InterpolateCoefficientList", "[", 
             RowBox[{"per", ",", "periodlist", ",", "sd1list"}], "]"}]}], ";",
            "\[IndentingNewLine]", 
           RowBox[{"sd2", "=", 
            RowBox[{"InterpolateCoefficientList", "[", 
             RowBox[{"per", ",", "periodlist", ",", "sd2list"}], "]"}]}], ";",
            "\[IndentingNewLine]", 
           RowBox[{"sd", "=", 
            RowBox[{"InterpolateCoefficientList", "[", 
             RowBox[{"per", ",", "periodlist", ",", "sdlist"}], "]"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"nrec", "=", 
            RowBox[{"InterpolateCoefficientList", "[", 
             RowBox[{"per", ",", "periodlist", ",", "nreclist"}], "]"}]}], ";",
            "\[IndentingNewLine]", 
           RowBox[{"neq", "=", 
            RowBox[{"InterpolateCoefficientList", "[", 
             RowBox[{"per", ",", "periodlist", ",", "neqlist"}], "]"}]}], ";",
            "\[IndentingNewLine]", 
           RowBox[{"nst", "=", 
            RowBox[{"InterpolateCoefficientList", "[", 
             RowBox[{"per", ",", "periodlist", ",", "nstlist"}], "]"}]}], 
           ";"}]}], "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"Which", "[", 
         RowBox[{
          RowBox[{"faulttypeinp", "==", "\"\<NORMAL\>\""}], ",", 
          RowBox[{
           RowBox[{"fn", "=", "1."}], ";", "\[IndentingNewLine]", 
           RowBox[{"fr", "=", "0."}], ";"}], ",", 
          RowBox[{"faulttypeinp", "==", "\"\<STRIKE SLIP\>\""}], ",", 
          RowBox[{
           RowBox[{"fn", "=", "0."}], ";", "\[IndentingNewLine]", 
           RowBox[{"fr", "=", "0."}], ";"}], ",", 
          RowBox[{"faulttypeinp", "==", "\"\<REVERSE\>\""}], ",", 
          RowBox[{
           RowBox[{"fn", "=", "0."}], ";", "\[IndentingNewLine]", 
           RowBox[{"fr", "=", "1."}], ";"}], ",", "True", ",", 
          RowBox[{
           RowBox[{"Message", "[", 
            RowBox[{
             RowBox[{"EmpiricalEquation", "::", "option"}], ",", 
             "faulttypeinp", ",", "FaultTypeNSSR"}], "]"}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"Return", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", "999."}], ",", 
              RowBox[{"-", "999."}], ",", 
              RowBox[{"-", "999."}], ",", 
              RowBox[{"-", "999."}]}], "}"}], "]"}], ";"}]}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{
          RowBox[{"Print", "[", 
           RowBox[{"\"\<fn, fr: \>\"", ",", 
            RowBox[{"{", 
             RowBox[{"fn", ",", "fr"}], "}"}]}], "]"}], ";"}], "*)"}], 
        RowBox[{"(*", 
         RowBox[{"*", "PGA", " ", "ref"}], "**)"}], 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"mw", "<=", "c1"}], ",", 
          RowBox[{
           RowBox[{"lnPGAref", "=", 
            RowBox[{
             RowBox[{"a1list", "[", 
              RowBox[{"[", "2", "]"}], "]"}], "+", 
             RowBox[{
              RowBox[{"a2list", "[", 
               RowBox[{"[", "2", "]"}], "]"}], " ", 
              RowBox[{"(", 
               RowBox[{"mw", "-", 
                RowBox[{"c1list", "[", 
                 RowBox[{"[", "2", "]"}], "]"}]}], ")"}]}], "+", 
             RowBox[{
              RowBox[{"a3list", "[", 
               RowBox[{"[", "2", "]"}], "]"}], " ", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"8.5", "-", "mw"}], ")"}], "^", "2"}]}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"a4list", "[", 
                 RowBox[{"[", "2", "]"}], "]"}], "+", 
                RowBox[{
                 RowBox[{"a5list", "[", 
                  RowBox[{"[", "2", "]"}], "]"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"mw", "-", 
                   RowBox[{"c1list", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], ")"}]}]}], ")"}], " ", 
              RowBox[{"Log", "[", 
               RowBox[{"Sqrt", "[", 
                RowBox[{
                 RowBox[{"rdist", "^", "2"}], "+", 
                 RowBox[{
                  RowBox[{"a6list", "[", 
                   RowBox[{"[", "2", "]"}], "]"}], "^", "2"}]}], "]"}], 
               "]"}]}], "+", 
             RowBox[{
              RowBox[{"a8list", "[", 
               RowBox[{"[", "2", "]"}], "]"}], " ", "fn"}], "+", 
             RowBox[{
              RowBox[{"a9list", "[", 
               RowBox[{"[", "2", "]"}], "]"}], " ", "fr"}]}]}], ";"}], ",", 
          RowBox[{"(*", 
           RowBox[{
            RowBox[{"else", " ", "mw"}], ">", "c1"}], "*)"}], 
          RowBox[{
           RowBox[{"lnPGAref", "=", 
            RowBox[{
             RowBox[{"a1list", "[", 
              RowBox[{"[", "2", "]"}], "]"}], "+", 
             RowBox[{
              RowBox[{"a7list", "[", 
               RowBox[{"[", "2", "]"}], "]"}], " ", 
              RowBox[{"(", 
               RowBox[{"mw", "-", 
                RowBox[{"c1list", "[", 
                 RowBox[{"[", "2", "]"}], "]"}]}], ")"}]}], "+", 
             RowBox[{
              RowBox[{"a3list", "[", 
               RowBox[{"[", "2", "]"}], "]"}], " ", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"8.5", "-", "mw"}], ")"}], "^", "2"}]}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"a4list", "[", 
                 RowBox[{"[", "2", "]"}], "]"}], "+", 
                RowBox[{
                 RowBox[{"a5list", "[", 
                  RowBox[{"[", "2", "]"}], "]"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"mw", "-", 
                   RowBox[{"c1list", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], ")"}]}]}], ")"}], " ", 
              RowBox[{"Log", "[", 
               RowBox[{"Sqrt", "[", 
                RowBox[{
                 RowBox[{"rdist", "^", "2"}], "+", 
                 RowBox[{
                  RowBox[{"a6list", "[", 
                   RowBox[{"[", "2", "]"}], "]"}], "^", "2"}]}], "]"}], 
               "]"}]}], "+", 
             RowBox[{
              RowBox[{"a8list", "[", 
               RowBox[{"[", "2", "]"}], "]"}], " ", "fn"}], "+", 
             RowBox[{
              RowBox[{"a9list", "[", 
               RowBox[{"[", "2", "]"}], "]"}], " ", "fr"}]}]}], ";"}]}], 
         "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{
          RowBox[{"Print", "[", 
           RowBox[{"\"\<PGAref: \>\"", ",", 
            RowBox[{"Exp", "[", "lnPGAref", "]"}]}], "]"}], ";"}], "*)"}], 
        RowBox[{"(*", 
         RowBox[{"*", "site", " ", "amplification"}], "**)"}], 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"vs30", "<=", "vref"}], ",", 
          RowBox[{
           RowBox[{"lns", "=", 
            RowBox[{
             RowBox[{"b1", " ", 
              RowBox[{"Log", "[", 
               RowBox[{"vs30", "/", "vref"}], "]"}]}], "+", 
             RowBox[{"b2", " ", 
              RowBox[{"Log", "[", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"Exp", "[", "lnPGAref", "]"}], "+", 
                  RowBox[{"c", " ", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"vs30", "/", "vref"}], ")"}], "^", "n"}]}]}], 
                 ")"}], "/", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"Exp", "[", "lnPGAref", "]"}], "+", "c"}], ")"}], 
                  
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"vs30", "/", "vref"}], ")"}], "^", "n"}]}], 
                 ")"}]}], "]"}]}]}]}], ";"}], ",", 
          RowBox[{
           RowBox[{"lns", "=", 
            RowBox[{"b1", " ", 
             RowBox[{"Log", "[", 
              RowBox[{
               RowBox[{"Min", "[", 
                RowBox[{"vs30", ",", "vcon"}], "]"}], "/", "vref"}], 
              "]"}]}]}], ";"}]}], "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{"*", "lnY"}], "**)"}], 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"mw", "<=", "c1"}], ",", 
          RowBox[{
           RowBox[{"lnrefy", "=", 
            RowBox[{"a1", "+", 
             RowBox[{"a2", "*", 
              RowBox[{"(", 
               RowBox[{"mw", "-", "c1"}], ")"}]}], "+", 
             RowBox[{"a3", "*", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"8.5", "-", "mw"}], ")"}], "^", "2"}]}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"a4", "+", 
                RowBox[{"a5", "*", 
                 RowBox[{"(", 
                  RowBox[{"mw", "-", "c1"}], ")"}]}]}], ")"}], 
              RowBox[{"Log", "[", 
               RowBox[{"Sqrt", "[", 
                RowBox[{
                 RowBox[{"rdist", "^", "2"}], "+", 
                 RowBox[{"a6", "^", "2"}]}], "]"}], "]"}]}], "+", 
             RowBox[{"a8", "*", "fn"}], "+", 
             RowBox[{"a9", " ", "fr"}]}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"(*", 
            RowBox[{
            "partials", " ", "copied", " ", "over", " ", "from", " ", "Akkar",
              " ", "and", " ", "Cagna", " ", "model", " ", "and", " ", 
             "modified", " ", "coeffiecients"}], "*)"}], 
           RowBox[{"pddist", "=", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"a4", "+", 
                 RowBox[{"a5", "*", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "c1"}], "+", "mw"}], ")"}]}]}], ")"}], "*", 
               "rdist"}], ")"}], "/", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"a6", "^", "2"}], "+", 
               RowBox[{"rdist", "^", "2"}]}], ")"}]}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"pdmag", "=", 
            RowBox[{"a2", "-", 
             RowBox[{"2", "*", "a3", "*", 
              RowBox[{"(", 
               RowBox[{"8.5", "-", "mw"}], ")"}]}], "+", 
             RowBox[{"a5", "*", 
              RowBox[{"Log", "[", 
               RowBox[{"Sqrt", "[", 
                RowBox[{
                 RowBox[{"a6", "^", "2"}], "+", 
                 RowBox[{"rdist", "^", "2"}]}], "]"}], "]"}]}]}]}], ";"}], ",", 
          RowBox[{"(*", 
           RowBox[{
            RowBox[{"else", " ", "mw"}], ">", "c1"}], "*)"}], 
          RowBox[{
           RowBox[{"lnrefy", "=", 
            RowBox[{"a1", "+", 
             RowBox[{"a7", "*", 
              RowBox[{"(", 
               RowBox[{"mw", "-", "c1"}], ")"}]}], "+", 
             RowBox[{"a3", "*", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"8.5", "-", "mw"}], ")"}], "^", "2"}]}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"a4", "+", 
                RowBox[{"a5", "*", 
                 RowBox[{"(", 
                  RowBox[{"mw", "-", "c1"}], ")"}]}]}], ")"}], " ", 
              RowBox[{"Log", "[", 
               RowBox[{"Sqrt", "[", 
                RowBox[{
                 RowBox[{"rdist", "^", "2"}], "+", 
                 RowBox[{"a6", "^", "2"}]}], "]"}], "]"}]}], "+", 
             RowBox[{"a8", " ", "fn"}], "+", 
             RowBox[{"a9", "*", "fr"}]}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"pddist", "=", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"a4", "+", 
                 RowBox[{"a5", "*", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "c1"}], "+", "mw"}], ")"}]}]}], ")"}], "*", 
               "rdist"}], ")"}], "/", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"a6", "^", "2"}], "+", 
               RowBox[{"rdist", "^", "2"}]}], ")"}]}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"pdmag", "=", 
            RowBox[{"a7", "-", 
             RowBox[{"2", "*", "a3", "*", 
              RowBox[{"(", 
               RowBox[{"8.5", "-", "mw"}], ")"}]}], "+", 
             RowBox[{"a5", "*", 
              RowBox[{"Log", "[", 
               RowBox[{"Sqrt", "[", 
                RowBox[{
                 RowBox[{"a6", "^", "2"}], "+", 
                 RowBox[{"rdist", "^", "2"}]}], "]"}], "]"}]}]}]}]}]}], "]"}],
         ";", "\[IndentingNewLine]", 
        RowBox[{"Which", "[", 
         RowBox[{
          RowBox[{"per", "<", 
           RowBox[{"periodlist", "[", 
            RowBox[{"[", "2", "]"}], "]"}]}], ",", 
          RowBox[{"(*", "PGV", "*)"}], 
          RowBox[{"(*", 
           RowBox[{"PGV", " ", "in", " ", 
            RowBox[{"m", "/", "s"}]}], "*)"}], 
          RowBox[{
           RowBox[{"saval", "=", 
            RowBox[{".01", " ", 
             RowBox[{"Exp", "[", 
              RowBox[{"lnrefy", "+", "lns"}], "]"}]}]}], ";"}], ",", 
          RowBox[{"0.", "<=", "per", "<", 
           RowBox[{"periodlist", "[", 
            RowBox[{"[", "3", "]"}], "]"}]}], ",", 
          RowBox[{"(*", "PGA", "*)"}], 
          RowBox[{"(*", 
           RowBox[{"PGA", " ", "in", " ", 
            RowBox[{"m", "/", "s"}], "*", "s"}], "*)"}], 
          RowBox[{
           RowBox[{"saval", "=", 
            RowBox[{"9.81", "*", 
             RowBox[{"Exp", "[", 
              RowBox[{"lnrefy", "+", "lns"}], "]"}]}]}], ";"}], ",", 
          RowBox[{
           RowBox[{"periodlist", "[", 
            RowBox[{"[", "3", "]"}], "]"}], "<=", "per"}], ",", 
          RowBox[{"(*", "PSA", "*)"}], 
          RowBox[{"(*", 
           RowBox[{"SA", " ", "in", " ", 
            RowBox[{"m", "/", "s"}], "*", "s"}], "*)"}], 
          RowBox[{
           RowBox[{"saval", "=", 
            RowBox[{"9.81", "*", 
             RowBox[{"Exp", "[", 
              RowBox[{"lnrefy", "+", "lns"}], "]"}]}]}], ";"}]}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"sigtotal", "=", "sd"}], ";", "\[IndentingNewLine]", 
        RowBox[{"Return", "[", 
         RowBox[{"{", 
          RowBox[{"saval", ",", "sigtotal", ",", "pddist", ",", "pdmag"}], 
          "}"}], "]"}], ";"}]}], "]"}]}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.95197501234096*^9, 3.9519750123424053`*^9}, {
   3.951975065786376*^9, 3.951975109512088*^9}, 3.9519764204734707`*^9, 
   3.9519765063853416`*^9, 3.952173476104514*^9},
 CellLabel->"In[43]:=",ExpressionUUID->"21fb90bb-cbc8-4f36-9f7b-d517a06b75cb"]
}, Closed]],

Cell[CellGroupData[{

Cell["AkkarEtal2013RhypHor", "Subsubsection",
 CellChangeTimes->{{3.952169552360321*^9, 
  3.952169577087267*^9}},ExpressionUUID->"56fc729c-49b8-4334-9be0-\
b0235a552441"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"AkkarEtal2013RhypHor", "::", "usage"}], 
  "=", "\"\<AkkarEtal2013RhypHor[p,options] returns \
{as,sigma,partasr,partasm}  for resonator period p  using the model of Akkar \
et al.  (2013) for the hypocentral distance distance as intrinsic distance \
metric.\>\""}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"DistHYP", "::", "usage"}], 
   "=", "\"\<Option for ground-motion prediction equations to input the \
hypocentral distance. Default setting: DistHYP -> 10. \>\""}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.952169142107052*^9, 3.95216914210942*^9}, {
  3.952169391417952*^9, 3.9521693947802*^9}},
 CellLabel->"In[45]:=",ExpressionUUID->"1949de98-3f54-4208-acbd-154407f30320"],

Cell[BoxData["\<\"AkkarEtal2013RhypHor[p,options] returns \
{as,sigma,partasr,partasm}  for resonator period p  using the model of Akkar \
et al.  (2013) for the hypocentral distance distance as intrinsic distance \
metric.\"\>"], "Output",
 CellChangeTimes->{3.952169586363741*^9, 3.955785564921013*^9},
 CellLabel->"Out[45]=",ExpressionUUID->"7a147f0c-ce0e-44ec-a490-072e11ae87cb"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Options", "[", "AkkarEtal2013RhypHor", "]"}], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"MagMW", "->", "6."}], ",", 
     RowBox[{"DistHYP", "->", "10."}], ",", 
     RowBox[{"Vs30", "->", "760."}], ",", 
     RowBox[{"FaultTypeNSSR", "->", "\"\<STRIKE SLIP\>\""}]}], "}"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"AkkarEtal2013RhypHor", "[", 
    RowBox[{"per_", ",", 
     RowBox[{"opts", ":", 
      RowBox[{"OptionsPattern", "[", "]"}]}]}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "mw", ",", "rdist", ",", "vs30", ",", "faulttypeinp", ",", "periodlist",
        ",", "a1list", ",", "a2list", ",", "a3list", ",", "a4list", ",", 
       "a5list", ",", "a6list", ",", "a7list", ",", "a8list", ",", "a9list", ",",
        "c1list", ",", "vconlist", ",", "vreflist", ",", "clist", ",", 
       "nlist", ",", "b1list", ",", "b2list", ",", "sd1list", ",", "sd2list", 
       ",", "sdlist", ",", "nreclist", ",", "neqlist", ",", "nstlist", ",", 
       "a1", ",", "a2", ",", "a3", ",", "a4", ",", "a5", ",", "a6", ",", "a7",
        ",", "a8", ",", "a9", ",", "c1", ",", "vcon", ",", "vref", ",", "c", ",",
        "n", ",", "b1", ",", "b2", ",", "sd1", ",", "sd2", ",", "sd", ",", 
       "nrec", ",", "neq", ",", "nst", ",", "fn", ",", "fr", ",", "lnPGAref", 
       ",", "lns", ",", "lnrefy", ",", "saval", ",", "sigtotal", ",", 
       "pddist", ",", "pdmag"}], "}"}], ",", 
     RowBox[{"(*", 
      RowBox[{"**", 
       RowBox[{"*", "Options"}]}], "****)"}], 
     RowBox[{
      RowBox[{"mw", "=", 
       RowBox[{"OptionValue", "[", "MagMW", "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"rdist", "=", 
       RowBox[{"OptionValue", "[", "DistHYP", "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"vs30", "=", 
       RowBox[{"OptionValue", "[", "Vs30", "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"faulttypeinp", "=", 
       RowBox[{"OptionValue", "[", "FaultTypeNSSR", "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{"Print", "[", 
         RowBox[{"\"\<Mw: \>\"", ",", "mw"}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"Print", "[", 
         RowBox[{"\"\<Repi: \>\"", ",", "rdist"}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"Print", "[", 
         RowBox[{"\"\<Vs30: \>\"", ",", "vs30"}], "]"}], ";"}], "*)"}], 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "periodlist", ",", "a1list", ",", "a2list", ",", "a3list", ",", 
         "a4list", ",", "a5list", ",", "a6list", ",", "a7list", ",", "a8list",
          ",", "a9list", ",", "c1list", ",", "vconlist", ",", "vreflist", ",",
          "clist", ",", "nlist", ",", "b1list", ",", "b2list", ",", "sd1list",
          ",", "sd2list", ",", "sdlist", ",", "nreclist", ",", "neqlist", ",",
          "nstlist"}], "}"}], "=", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1."}], ",", "0.", ",", "0.01", ",", "0.02", ",", 
           "0.03", ",", "0.04", ",", "0.05", ",", "0.075", ",", "0.1", ",", 
           "0.11", ",", "0.12", ",", "0.13", ",", "0.14", ",", "0.15", ",", 
           "0.16", ",", "0.17", ",", "0.18", ",", "0.19", ",", "0.2", ",", 
           "0.22", ",", "0.24", ",", "0.26", ",", "0.28", ",", "0.3", ",", 
           "0.32", ",", "0.34", ",", "0.36", ",", "0.38", ",", "0.4", ",", 
           "0.42", ",", "0.44", ",", "0.46", ",", "0.48", ",", "0.5", ",", 
           "0.55", ",", "0.6", ",", "0.65", ",", "0.7", ",", "0.75", ",", 
           "0.8", ",", "0.85", ",", "0.9", ",", "0.95", ",", "1", ",", "1.1", 
           ",", "1.2", ",", "1.3", ",", "1.4", ",", "1.5", ",", "1.6", ",", 
           "1.7", ",", "1.8", ",", "1.9", ",", "2", ",", "2.2", ",", "2.4", ",",
            "2.6", ",", "2.8", ",", "3", ",", "3.2", ",", "3.4", ",", "3.6", ",",
            "3.8", ",", "4"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
          "6.72743", ",", "3.26685", ",", "3.28656", ",", "3.38936", ",", 
           "3.53155", ",", "3.68895", ",", "3.86581", ",", "4.18224", ",", 
           "4.4375", ",", "4.48828", ",", "4.51414", ",", "4.5329", ",", 
           "4.53834", ",", "4.52949", ",", "4.47016", ",", "4.40011", ",", 
           "4.33238", ",", "4.26395", ",", "4.1775", ",", "4.03111", ",", 
           "3.90131", ",", "3.82611", ",", "3.6978", ",", "3.57698", ",", 
           "3.40759", ",", "3.2758", ",", "3.19725", ",", "3.11035", ",", 
           "3.03752", ",", "2.97485", ",", "2.90617", ",", "2.85484", ",", 
           "2.8172", ",", "2.77997", ",", "2.62299", ",", "2.42234", ",", 
           "2.2277", ",", "2.08102", ",", "1.91625", ",", "1.81167", ",", 
           "1.71853", ",", "1.60822", ",", "1.51532", ",", "1.43982", ",", 
           "1.26728", ",", "1.11475", ",", "0.95965", ",", "0.85203", ",", 
           "0.83007", ",", "0.74487", ",", "0.63568", ",", "0.56996", ",", 
           "0.485", ",", "0.40614", ",", "0.28608", ",", "0.15432", ",", 
           "0.0225", ",", 
           RowBox[{"-", "0.07822"}], ",", 
           RowBox[{"-", "0.22534"}], ",", 
           RowBox[{"-", "0.36165"}], ",", 
           RowBox[{"-", "0.39423"}], ",", 
           RowBox[{"-", "0.54126"}], ",", 
           RowBox[{"-", "0.59607"}], ",", 
           RowBox[{"-", "0.51893"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
          "0.0029", ",", "0.0029", ",", "0.0029", ",", "0.0029", ",", 
           "0.0029", ",", "0.0029", ",", "0.0029", ",", "0.0029", ",", 
           "0.0029", ",", "0.0029", ",", "0.0029", ",", "0.0029", ",", 
           "0.0029", ",", "0.0029", ",", "0.0029", ",", "0.0029", ",", 
           "0.0029", ",", "0.0029", ",", "0.0029", ",", "0.0029", ",", 
           "0.0029", ",", "0.0029", ",", "0.0029", ",", "0.0029", ",", 
           "0.0029", ",", "0.0029", ",", "0.0029", ",", "0.0029", ",", 
           "0.0029", ",", "0.0029", ",", "0.0029", ",", "0.0029", ",", 
           "0.0029", ",", "0.0029", ",", "0.0029", ",", "0.0029", ",", 
           "0.0029", ",", "0.0029", ",", "0.0029", ",", "0.0029", ",", 
           "0.0029", ",", "0.0029", ",", "0.0029", ",", "0.0029", ",", 
           "0.0029", ",", "0.0029", ",", "0.0029", ",", "0.0029", ",", 
           "0.0029", ",", "0.0029", ",", "0.0029", ",", "0.0029", ",", 
           "0.0029", ",", "0.0029", ",", "0.0029", ",", "0.0029", ",", 
           "0.0029", ",", "0.0029", ",", "0.0029", ",", "0.0029", ",", 
           "0.0029", ",", "0.0029", ",", "0.0029", ",", "0.0029"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.11474"}], ",", 
           RowBox[{"-", "0.04846"}], ",", 
           RowBox[{"-", "0.04784"}], ",", 
           RowBox[{"-", "0.04796"}], ",", 
           RowBox[{"-", "0.04537"}], ",", 
           RowBox[{"-", "0.03991"}], ",", 
           RowBox[{"-", "0.0349"}], ",", 
           RowBox[{"-", "0.02826"}], ",", 
           RowBox[{"-", "0.03256"}], ",", 
           RowBox[{"-", "0.03407"}], ",", 
           RowBox[{"-", "0.03635"}], ",", 
           RowBox[{"-", "0.03929"}], ",", 
           RowBox[{"-", "0.042"}], ",", 
           RowBox[{"-", "0.04509"}], ",", 
           RowBox[{"-", "0.04701"}], ",", 
           RowBox[{"-", "0.04932"}], ",", 
           RowBox[{"-", "0.05181"}], ",", 
           RowBox[{"-", "0.05442"}], ",", 
           RowBox[{"-", "0.05565"}], ",", 
           RowBox[{"-", "0.05817"}], ",", 
           RowBox[{"-", "0.06152"}], ",", 
           RowBox[{"-", "0.06706"}], ",", 
           RowBox[{"-", "0.0706"}], ",", 
           RowBox[{"-", "0.0749"}], ",", 
           RowBox[{"-", "0.07756"}], ",", 
           RowBox[{"-", "0.08183"}], ",", 
           RowBox[{"-", "0.08602"}], ",", 
           RowBox[{"-", "0.08937"}], ",", 
           RowBox[{"-", "0.09243"}], ",", 
           RowBox[{"-", "0.09556"}], ",", 
           RowBox[{"-", "0.09822"}], ",", 
           RowBox[{"-", "0.10132"}], ",", 
           RowBox[{"-", "0.1056"}], ",", 
           RowBox[{"-", "0.10964"}], ",", 
           RowBox[{"-", "0.11701"}], ",", 
           RowBox[{"-", "0.12106"}], ",", 
           RowBox[{"-", "0.12555"}], ",", 
           RowBox[{"-", "0.13074"}], ",", 
           RowBox[{"-", "0.13547"}], ",", 
           RowBox[{"-", "0.13856"}], ",", 
           RowBox[{"-", "0.14294"}], ",", 
           RowBox[{"-", "0.14669"}], ",", 
           RowBox[{"-", "0.15056"}], ",", 
           RowBox[{"-", "0.15427"}], ",", 
           RowBox[{"-", "0.16107"}], ",", 
           RowBox[{"-", "0.1663"}], ",", 
           RowBox[{"-", "0.1717"}], ",", 
           RowBox[{"-", "0.17699"}], ",", 
           RowBox[{"-", "0.18248"}], ",", 
           RowBox[{"-", "0.18787"}], ",", 
           RowBox[{"-", "0.18961"}], ",", 
           RowBox[{"-", "0.19551"}], ",", 
           RowBox[{"-", "0.19853"}], ",", 
           RowBox[{"-", "0.20136"}], ",", 
           RowBox[{"-", "0.20791"}], ",", 
           RowBox[{"-", "0.2148"}], ",", 
           RowBox[{"-", "0.21843"}], ",", 
           RowBox[{"-", "0.22224"}], ",", 
           RowBox[{"-", "0.22564"}], ",", 
           RowBox[{"-", "0.22496"}], ",", 
           RowBox[{"-", "0.23237"}], ",", 
           RowBox[{"-", "0.24003"}], ",", 
           RowBox[{"-", "0.24448"}], ",", 
           RowBox[{"-", "0.25256"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1.17694"}], ",", 
           RowBox[{"-", "1.47905"}], ",", 
           RowBox[{"-", "1.48197"}], ",", 
           RowBox[{"-", "1.50214"}], ",", 
           RowBox[{"-", "1.52781"}], ",", 
           RowBox[{"-", "1.55693"}], ",", 
           RowBox[{"-", "1.58672"}], ",", 
           RowBox[{"-", "1.62527"}], ",", 
           RowBox[{"-", "1.65601"}], ",", 
           RowBox[{"-", "1.65903"}], ",", 
           RowBox[{"-", "1.6547"}], ",", 
           RowBox[{"-", "1.64994"}], ",", 
           RowBox[{"-", "1.64398"}], ",", 
           RowBox[{"-", "1.63467"}], ",", 
           RowBox[{"-", "1.61626"}], ",", 
           RowBox[{"-", "1.59485"}], ",", 
           RowBox[{"-", "1.57545"}], ",", 
           RowBox[{"-", "1.55685"}], ",", 
           RowBox[{"-", "1.53574"}], ",", 
           RowBox[{"-", "1.50045"}], ",", 
           RowBox[{"-", "1.46889"}], ",", 
           RowBox[{"-", "1.44738"}], ",", 
           RowBox[{"-", "1.41925"}], ",", 
           RowBox[{"-", "1.38832"}], ",", 
           RowBox[{"-", "1.34898"}], ",", 
           RowBox[{"-", "1.31609"}], ",", 
           RowBox[{"-", "1.29558"}], ",", 
           RowBox[{"-", "1.27591"}], ",", 
           RowBox[{"-", "1.26045"}], ",", 
           RowBox[{"-", "1.24891"}], ",", 
           RowBox[{"-", "1.237"}], ",", 
           RowBox[{"-", "1.22822"}], ",", 
           RowBox[{"-", "1.21874"}], ",", 
           RowBox[{"-", "1.20953"}], ",", 
           RowBox[{"-", "1.1801"}], ",", 
           RowBox[{"-", "1.14424"}], ",", 
           RowBox[{"-", "1.10853"}], ",", 
           RowBox[{"-", "1.08192"}], ",", 
           RowBox[{"-", "1.05027"}], ",", 
           RowBox[{"-", "1.03514"}], ",", 
           RowBox[{"-", "1.0201"}], ",", 
           RowBox[{"-", "1.00315"}], ",", 
           RowBox[{"-", "0.98859"}], ",", 
           RowBox[{"-", "0.97812"}], ",", 
           RowBox[{"-", "0.95163"}], ",", 
           RowBox[{"-", "0.93048"}], ",", 
           RowBox[{"-", "0.90604"}], ",", 
           RowBox[{"-", "0.89379"}], ",", 
           RowBox[{"-", "0.90319"}], ",", 
           RowBox[{"-", "0.89323"}], ",", 
           RowBox[{"-", "0.88392"}], ",", 
           RowBox[{"-", "0.87459"}], ",", 
           RowBox[{"-", "0.86659"}], ",", 
           RowBox[{"-", "0.86343"}], ",", 
           RowBox[{"-", "0.86086"}], ",", 
           RowBox[{"-", "0.84778"}], ",", 
           RowBox[{"-", "0.83937"}], ",", 
           RowBox[{"-", "0.83964"}], ",", 
           RowBox[{"-", "0.83314"}], ",", 
           RowBox[{"-", "0.81702"}], ",", 
           RowBox[{"-", "0.82109"}], ",", 
           RowBox[{"-", "0.79431"}], ",", 
           RowBox[{"-", "0.78785"}], ",", 
           RowBox[{"-", "0.80922"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
          "0.2529", ",", "0.2529", ",", "0.2529", ",", "0.2529", ",", 
           "0.2529", ",", "0.2529", ",", "0.2529", ",", "0.2529", ",", 
           "0.2529", ",", "0.2529", ",", "0.2529", ",", "0.2529", ",", 
           "0.2529", ",", "0.2529", ",", "0.2529", ",", "0.2529", ",", 
           "0.2529", ",", "0.2529", ",", "0.2529", ",", "0.2529", ",", 
           "0.2529", ",", "0.2529", ",", "0.2529", ",", "0.2529", ",", 
           "0.2529", ",", "0.2529", ",", "0.2529", ",", "0.2529", ",", 
           "0.2529", ",", "0.2529", ",", "0.2529", ",", "0.2529", ",", 
           "0.2529", ",", "0.2529", ",", "0.2529", ",", "0.2529", ",", 
           "0.2529", ",", "0.2529", ",", "0.2529", ",", "0.2529", ",", 
           "0.2529", ",", "0.2529", ",", "0.2529", ",", "0.2529", ",", 
           "0.2529", ",", "0.2529", ",", "0.2529", ",", "0.2529", ",", 
           "0.2529", ",", "0.2529", ",", "0.2529", ",", "0.2529", ",", 
           "0.2529", ",", "0.2529", ",", "0.2529", ",", "0.2529", ",", 
           "0.2529", ",", "0.2529", ",", "0.2529", ",", "0.2529", ",", 
           "0.2529", ",", "0.2529", ",", "0.2529", ",", "0.2529"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
          "7.5", ",", "7.5", ",", "7.5", ",", "7.5", ",", "7.5", ",", "7.5", ",",
            "7.5", ",", "7.5", ",", "7.5", ",", "7.5", ",", "7.5", ",", "7.5",
            ",", "7.5", ",", "7.5", ",", "7.5", ",", "7.5", ",", "7.5", ",", 
           "7.5", ",", "7.5", ",", "7.5", ",", "7.5", ",", "7.5", ",", "7.5", 
           ",", "7.5", ",", "7.5", ",", "7.5", ",", "7.5", ",", "7.5", ",", 
           "7.5", ",", "7.5", ",", "7.5", ",", "7.5", ",", "7.5", ",", "7.5", 
           ",", "7.5", ",", "7.5", ",", "7.5", ",", "7.5", ",", "7.5", ",", 
           "7.5", ",", "7.5", ",", "7.5", ",", "7.5", ",", "7.5", ",", "7.5", 
           ",", "7.5", ",", "7.5", ",", "7.5", ",", "7.5", ",", "7.5", ",", 
           "7.5", ",", "7.5", ",", "7.5", ",", "7.5", ",", "7.5", ",", "7.5", 
           ",", "7.5", ",", "7.5", ",", "7.5", ",", "7.5", ",", "7.5", ",", 
           "7.5", ",", "7.5", ",", "7.5"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.5096"}], ",", 
           RowBox[{"-", "0.5096"}], ",", 
           RowBox[{"-", "0.5096"}], ",", 
           RowBox[{"-", "0.5096"}], ",", 
           RowBox[{"-", "0.5096"}], ",", 
           RowBox[{"-", "0.5096"}], ",", 
           RowBox[{"-", "0.5096"}], ",", 
           RowBox[{"-", "0.5096"}], ",", 
           RowBox[{"-", "0.5096"}], ",", 
           RowBox[{"-", "0.5096"}], ",", 
           RowBox[{"-", "0.5096"}], ",", 
           RowBox[{"-", "0.5096"}], ",", 
           RowBox[{"-", "0.5096"}], ",", 
           RowBox[{"-", "0.5096"}], ",", 
           RowBox[{"-", "0.5096"}], ",", 
           RowBox[{"-", "0.5096"}], ",", 
           RowBox[{"-", "0.5096"}], ",", 
           RowBox[{"-", "0.5096"}], ",", 
           RowBox[{"-", "0.5096"}], ",", 
           RowBox[{"-", "0.5096"}], ",", 
           RowBox[{"-", "0.5096"}], ",", 
           RowBox[{"-", "0.5096"}], ",", 
           RowBox[{"-", "0.5096"}], ",", 
           RowBox[{"-", "0.5096"}], ",", 
           RowBox[{"-", "0.5096"}], ",", 
           RowBox[{"-", "0.5096"}], ",", 
           RowBox[{"-", "0.5096"}], ",", 
           RowBox[{"-", "0.5096"}], ",", 
           RowBox[{"-", "0.5096"}], ",", 
           RowBox[{"-", "0.5096"}], ",", 
           RowBox[{"-", "0.5096"}], ",", 
           RowBox[{"-", "0.5096"}], ",", 
           RowBox[{"-", "0.5096"}], ",", 
           RowBox[{"-", "0.5096"}], ",", 
           RowBox[{"-", "0.5096"}], ",", 
           RowBox[{"-", "0.5096"}], ",", 
           RowBox[{"-", "0.5096"}], ",", 
           RowBox[{"-", "0.5096"}], ",", 
           RowBox[{"-", "0.5096"}], ",", 
           RowBox[{"-", "0.5096"}], ",", 
           RowBox[{"-", "0.5096"}], ",", 
           RowBox[{"-", "0.5096"}], ",", 
           RowBox[{"-", "0.5096"}], ",", 
           RowBox[{"-", "0.5096"}], ",", 
           RowBox[{"-", "0.5096"}], ",", 
           RowBox[{"-", "0.5096"}], ",", 
           RowBox[{"-", "0.5096"}], ",", 
           RowBox[{"-", "0.5096"}], ",", 
           RowBox[{"-", "0.5096"}], ",", 
           RowBox[{"-", "0.5096"}], ",", 
           RowBox[{"-", "0.5096"}], ",", 
           RowBox[{"-", "0.5096"}], ",", 
           RowBox[{"-", "0.5096"}], ",", 
           RowBox[{"-", "0.5096"}], ",", 
           RowBox[{"-", "0.5096"}], ",", 
           RowBox[{"-", "0.5096"}], ",", 
           RowBox[{"-", "0.5096"}], ",", 
           RowBox[{"-", "0.5096"}], ",", 
           RowBox[{"-", "0.5096"}], ",", 
           RowBox[{"-", "0.5096"}], ",", 
           RowBox[{"-", "0.5096"}], ",", 
           RowBox[{"-", "0.5096"}], ",", 
           RowBox[{"-", "0.5096"}], ",", 
           RowBox[{"-", "0.5096"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.0616"}], ",", 
           RowBox[{"-", "0.1091"}], ",", 
           RowBox[{"-", "0.1115"}], ",", 
           RowBox[{"-", "0.104"}], ",", 
           RowBox[{"-", "0.0973"}], ",", 
           RowBox[{"-", "0.0884"}], ",", 
           RowBox[{"-", "0.0853"}], ",", 
           RowBox[{"-", "0.0779"}], ",", 
           RowBox[{"-", "0.0749"}], ",", 
           RowBox[{"-", "0.0704"}], ",", 
           RowBox[{"-", "0.0604"}], ",", 
           RowBox[{"-", "0.049"}], ",", 
           RowBox[{"-", "0.0377"}], ",", 
           RowBox[{"-", "0.0265"}], ",", 
           RowBox[{"-", "0.0194"}], ",", 
           RowBox[{"-", "0.0125"}], ",", 
           RowBox[{"-", "0.0056"}], ",", "0", ",", "0", ",", "0", ",", "0", ",",
            "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",",
            "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",",
            "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",",
            "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",",
            "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",",
            "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",",
            "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
          "0.063", ",", "0.0937", ",", "0.0953", ",", "0.1029", ",", "0.1148",
            ",", "0.1073", ",", "0.1052", ",", "0.0837", ",", "0.0761", ",", 
           "0.0707", ",", "0.0653", ",", "0.0617", ",", "0.0581", ",", 
           "0.0545", ",", "0.0509", ",", "0.0507", ",", "0.0502", ",", 
           "0.0497", ",", "0.0493", ",", "0.0488", ",", "0.0483", ",", 
           "0.0478", ",", "0.0474", ",", "0.0469", ",", "0.0464", ",", 
           "0.0459", ",", "0.0459", ",", "0.0429", ",", "0.04", ",", "0.0374",
            ",", "0.0349", ",", "0.0323", ",", "0.0297", ",", "0.0271", ",", 
           "0.0245", ",", "0.0219", ",", "0.0193", ",", "0.0167", ",", 
           "0.0141", ",", "0.0115", ",", "0.0089", ",", "0.0062", ",", 
           "0.0016", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
           "0", ",", "0", ",", "0", ",", 
           RowBox[{"-", "0.003"}], ",", 
           RowBox[{"-", "0.006"}], ",", 
           RowBox[{"-", "0.009"}], ",", 
           RowBox[{"-", "0.0141"}], ",", 
           RowBox[{"-", "0.0284"}], ",", 
           RowBox[{"-", "0.0408"}], ",", 
           RowBox[{"-", "0.0534"}], ",", 
           RowBox[{"-", "0.0683"}], ",", 
           RowBox[{"-", "0.078"}], ",", 
           RowBox[{"-", "0.0943"}], ",", 
           RowBox[{"-", "0.1278"}], ",", 
           RowBox[{"-", "0.1744"}], ",", 
           RowBox[{"-", "0.2231"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
          "6.75", ",", "6.75", ",", "6.75", ",", "6.75", ",", "6.75", ",", 
           "6.75", ",", "6.75", ",", "6.75", ",", "6.75", ",", "6.75", ",", 
           "6.75", ",", "6.75", ",", "6.75", ",", "6.75", ",", "6.75", ",", 
           "6.75", ",", "6.75", ",", "6.75", ",", "6.75", ",", "6.75", ",", 
           "6.75", ",", "6.75", ",", "6.75", ",", "6.75", ",", "6.75", ",", 
           "6.75", ",", "6.75", ",", "6.75", ",", "6.75", ",", "6.75", ",", 
           "6.75", ",", "6.75", ",", "6.75", ",", "6.75", ",", "6.75", ",", 
           "6.75", ",", "6.75", ",", "6.75", ",", "6.75", ",", "6.75", ",", 
           "6.75", ",", "6.75", ",", "6.75", ",", "6.75", ",", "6.75", ",", 
           "6.75", ",", "6.75", ",", "6.75", ",", "6.75", ",", "6.75", ",", 
           "6.75", ",", "6.75", ",", "6.75", ",", "6.75", ",", "6.75", ",", 
           "6.75", ",", "6.75", ",", "6.75", ",", "6.75", ",", "6.75", ",", 
           "6.75", ",", "6.75", ",", "6.75", ",", "6.75"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
          "1000", ",", "1000", ",", "1000", ",", "1000", ",", "1000", ",", 
           "1000", ",", "1000", ",", "1000", ",", "1000", ",", "1000", ",", 
           "1000", ",", "1000", ",", "1000", ",", "1000", ",", "1000", ",", 
           "1000", ",", "1000", ",", "1000", ",", "1000", ",", "1000", ",", 
           "1000", ",", "1000", ",", "1000", ",", "1000", ",", "1000", ",", 
           "1000", ",", "1000", ",", "1000", ",", "1000", ",", "1000", ",", 
           "1000", ",", "1000", ",", "1000", ",", "1000", ",", "1000", ",", 
           "1000", ",", "1000", ",", "1000", ",", "1000", ",", "1000", ",", 
           "1000", ",", "1000", ",", "1000", ",", "1000", ",", "1000", ",", 
           "1000", ",", "1000", ",", "1000", ",", "1000", ",", "1000", ",", 
           "1000", ",", "1000", ",", "1000", ",", "1000", ",", "1000", ",", 
           "1000", ",", "1000", ",", "1000", ",", "1000", ",", "1000", ",", 
           "1000", ",", "1000", ",", "1000", ",", "1000"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
          "750", ",", "750", ",", "750", ",", "750", ",", "750", ",", "750", ",",
            "750", ",", "750", ",", "750", ",", "750", ",", "750", ",", "750",
            ",", "750", ",", "750", ",", "750", ",", "750", ",", "750", ",", 
           "750", ",", "750", ",", "750", ",", "750", ",", "750", ",", "750", 
           ",", "750", ",", "750", ",", "750", ",", "750", ",", "750", ",", 
           "750", ",", "750", ",", "750", ",", "750", ",", "750", ",", "750", 
           ",", "750", ",", "750", ",", "750", ",", "750", ",", "750", ",", 
           "750", ",", "750", ",", "750", ",", "750", ",", "750", ",", "750", 
           ",", "750", ",", "750", ",", "750", ",", "750", ",", "750", ",", 
           "750", ",", "750", ",", "750", ",", "750", ",", "750", ",", "750", 
           ",", "750", ",", "750", ",", "750", ",", "750", ",", "750", ",", 
           "750", ",", "750", ",", "750"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
          "2.5", ",", "2.5", ",", "2.5", ",", "2.5", ",", "2.5", ",", "2.5", ",",
            "2.5", ",", "2.5", ",", "2.5", ",", "2.5", ",", "2.5", ",", "2.5",
            ",", "2.5", ",", "2.5", ",", "2.5", ",", "2.5", ",", "2.5", ",", 
           "2.5", ",", "2.5", ",", "2.5", ",", "2.5", ",", "2.5", ",", "2.5", 
           ",", "2.5", ",", "2.5", ",", "2.5", ",", "2.5", ",", "2.5", ",", 
           "2.5", ",", "2.5", ",", "2.5", ",", "2.5", ",", "2.5", ",", "2.5", 
           ",", "2.5", ",", "2.5", ",", "2.5", ",", "2.5", ",", "2.5", ",", 
           "2.5", ",", "2.5", ",", "2.5", ",", "2.5", ",", "2.5", ",", "2.5", 
           ",", "2.5", ",", "2.5", ",", "2.5", ",", "2.5", ",", "2.5", ",", 
           "2.5", ",", "2.5", ",", "2.5", ",", "2.5", ",", "2.5", ",", "2.5", 
           ",", "2.5", ",", "2.5", ",", "2.5", ",", "2.5", ",", "2.5", ",", 
           "2.5", ",", "2.5", ",", "2.5"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
          "3.2", ",", "3.2", ",", "3.2", ",", "3.2", ",", "3.2", ",", "3.2", ",",
            "3.2", ",", "3.2", ",", "3.2", ",", "3.2", ",", "3.2", ",", "3.2",
            ",", "3.2", ",", "3.2", ",", "3.2", ",", "3.2", ",", "3.2", ",", 
           "3.2", ",", "3.2", ",", "3.2", ",", "3.2", ",", "3.2", ",", "3.2", 
           ",", "3.2", ",", "3.2", ",", "3.2", ",", "3.2", ",", "3.2", ",", 
           "3.2", ",", "3.2", ",", "3.2", ",", "3.2", ",", "3.2", ",", "3.2", 
           ",", "3.2", ",", "3.2", ",", "3.2", ",", "3.2", ",", "3.2", ",", 
           "3.2", ",", "3.2", ",", "3.2", ",", "3.2", ",", "3.2", ",", "3.2", 
           ",", "3.2", ",", "3.2", ",", "3.2", ",", "3.2", ",", "3.2", ",", 
           "3.2", ",", "3.2", ",", "3.2", ",", "3.2", ",", "3.2", ",", "3.2", 
           ",", "3.2", ",", "3.2", ",", "3.2", ",", "3.2", ",", "3.2", ",", 
           "3.2", ",", "3.2", ",", "3.2"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.72057"}], ",", 
           RowBox[{"-", "0.41997"}], ",", 
           RowBox[{"-", "0.41729"}], ",", 
           RowBox[{"-", "0.39998"}], ",", 
           RowBox[{"-", "0.34799"}], ",", 
           RowBox[{"-", "0.27572"}], ",", 
           RowBox[{"-", "0.21231"}], ",", 
           RowBox[{"-", "0.14427"}], ",", 
           RowBox[{"-", "0.27064"}], ",", 
           RowBox[{"-", "0.31025"}], ",", 
           RowBox[{"-", "0.34796"}], ",", 
           RowBox[{"-", "0.39668"}], ",", 
           RowBox[{"-", "0.43996"}], ",", 
           RowBox[{"-", "0.48313"}], ",", 
           RowBox[{"-", "0.52431"}], ",", 
           RowBox[{"-", "0.5568"}], ",", 
           RowBox[{"-", "0.58922"}], ",", 
           RowBox[{"-", "0.62635"}], ",", 
           RowBox[{"-", "0.65315"}], ",", 
           RowBox[{"-", "0.68711"}], ",", 
           RowBox[{"-", "0.72744"}], ",", 
           RowBox[{"-", "0.77335"}], ",", 
           RowBox[{"-", "0.80508"}], ",", 
           RowBox[{"-", "0.82609"}], ",", 
           RowBox[{"-", "0.8408"}], ",", 
           RowBox[{"-", "0.86251"}], ",", 
           RowBox[{"-", "0.87479"}], ",", 
           RowBox[{"-", "0.88522"}], ",", 
           RowBox[{"-", "0.89517"}], ",", 
           RowBox[{"-", "0.90875"}], ",", 
           RowBox[{"-", "0.91922"}], ",", 
           RowBox[{"-", "0.9267"}], ",", 
           RowBox[{"-", "0.9372"}], ",", 
           RowBox[{"-", "0.94614"}], ",", 
           RowBox[{"-", "0.96564"}], ",", 
           RowBox[{"-", "0.98499"}], ",", 
           RowBox[{"-", "0.99733"}], ",", 
           RowBox[{"-", "1.00469"}], ",", 
           RowBox[{"-", "1.00786"}], ",", 
           RowBox[{"-", "1.00606"}], ",", 
           RowBox[{"-", "1.01093"}], ",", 
           RowBox[{"-", "1.01576"}], ",", 
           RowBox[{"-", "1.01353"}], ",", 
           RowBox[{"-", "1.01331"}], ",", 
           RowBox[{"-", "1.0124"}], ",", 
           RowBox[{"-", "1.00489"}], ",", 
           RowBox[{"-", "0.98876"}], ",", 
           RowBox[{"-", "0.9776"}], ",", 
           RowBox[{"-", "0.98071"}], ",", 
           RowBox[{"-", "0.96369"}], ",", 
           RowBox[{"-", "0.94634"}], ",", 
           RowBox[{"-", "0.93606"}], ",", 
           RowBox[{"-", "0.91408"}], ",", 
           RowBox[{"-", "0.91007"}], ",", 
           RowBox[{"-", "0.89376"}], ",", 
           RowBox[{"-", "0.87052"}], ",", 
           RowBox[{"-", "0.85889"}], ",", 
           RowBox[{"-", "0.86106"}], ",", 
           RowBox[{"-", "0.85793"}], ",", 
           RowBox[{"-", "0.82094"}], ",", 
           RowBox[{"-", "0.84449"}], ",", 
           RowBox[{"-", "0.83216"}], ",", 
           RowBox[{"-", "0.79216"}], ",", 
           RowBox[{"-", "0.75645"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.19688"}], ",", 
           RowBox[{"-", "0.28846"}], ",", 
           RowBox[{"-", "0.28685"}], ",", 
           RowBox[{"-", "0.28241"}], ",", 
           RowBox[{"-", "0.26842"}], ",", 
           RowBox[{"-", "0.24759"}], ",", 
           RowBox[{"-", "0.22385"}], ",", 
           RowBox[{"-", "0.17525"}], ",", 
           RowBox[{"-", "0.29293"}], ",", 
           RowBox[{"-", "0.31837"}], ",", 
           RowBox[{"-", "0.3386"}], ",", 
           RowBox[{"-", "0.36646"}], ",", 
           RowBox[{"-", "0.38417"}], ",", 
           RowBox[{"-", "0.39551"}], ",", 
           RowBox[{"-", "0.40869"}], ",", 
           RowBox[{"-", "0.41528"}], ",", 
           RowBox[{"-", "0.42717"}], ",", 
           RowBox[{"-", "0.4413"}], ",", 
           RowBox[{"-", "0.44644"}], ",", 
           RowBox[{"-", "0.44872"}], ",", 
           RowBox[{"-", "0.46341"}], ",", 
           RowBox[{"-", "0.48705"}], ",", 
           RowBox[{"-", "0.47334"}], ",", 
           RowBox[{"-", "0.4573"}], ",", 
           RowBox[{"-", "0.44267"}], ",", 
           RowBox[{"-", "0.43888"}], ",", 
           RowBox[{"-", "0.4382"}], ",", 
           RowBox[{"-", "0.43678"}], ",", 
           RowBox[{"-", "0.43008"}], ",", 
           RowBox[{"-", "0.4219"}], ",", 
           RowBox[{"-", "0.40903"}], ",", 
           RowBox[{"-", "0.39442"}], ",", 
           RowBox[{"-", "0.38462"}], ",", 
           RowBox[{"-", "0.37408"}], ",", 
           RowBox[{"-", "0.35582"}], ",", 
           RowBox[{"-", "0.34053"}], ",", 
           RowBox[{"-", "0.30949"}], ",", 
           RowBox[{"-", "0.28772"}], ",", 
           RowBox[{"-", "0.28957"}], ",", 
           RowBox[{"-", "0.28555"}], ",", 
           RowBox[{"-", "0.28364"}], ",", 
           RowBox[{"-", "0.28037"}], ",", 
           RowBox[{"-", "0.2839"}], ",", 
           RowBox[{"-", "0.28702"}], ",", 
           RowBox[{"-", "0.27669"}], ",", 
           RowBox[{"-", "0.27538"}], ",", 
           RowBox[{"-", "0.25008"}], ",", 
           RowBox[{"-", "0.23508"}], ",", 
           RowBox[{"-", "0.24695"}], ",", 
           RowBox[{"-", "0.2287"}], ",", 
           RowBox[{"-", "0.21655"}], ",", 
           RowBox[{"-", "0.20302"}], ",", 
           RowBox[{"-", "0.18228"}], ",", 
           RowBox[{"-", "0.17336"}], ",", 
           RowBox[{"-", "0.15463"}], ",", 
           RowBox[{"-", "0.13181"}], ",", 
           RowBox[{"-", "0.14066"}], ",", 
           RowBox[{"-", "0.13882"}], ",", 
           RowBox[{"-", "0.13336"}], ",", 
           RowBox[{"-", "0.1377"}], ",", 
           RowBox[{"-", "0.15337"}], ",", 
           RowBox[{"-", "0.10884"}], ",", 
           RowBox[{"-", "0.08884"}], ",", 
           RowBox[{"-", "0.07749"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
          "0.628", ",", "0.6475", ",", "0.6492", ",", "0.6543", ",", "0.6685",
            ",", "0.6816", ",", "0.6899", ",", "0.6881", ",", "0.6936", ",", 
           "0.6965", ",", "0.7022", ",", "0.7043", ",", "0.7071", ",", 
           "0.7048", ",", "0.7032", ",", "0.7011", ",", "0.6992", ",", 
           "0.6947", ",", "0.6954", ",", "0.6925", ",", "0.6973", ",", 
           "0.6973", ",", "0.6914", ",", "0.6934", ",", "0.6992", ",", 
           "0.699", ",", "0.7006", ",", "0.7036", ",", "0.7037", ",", 
           "0.7023", ",", "0.6956", ",", "0.6893", ",", "0.6852", ",", 
           "0.6821", ",", "0.6866", ",", "0.6926", ",", "0.6949", ",", 
           "0.6993", ",", "0.7028", ",", "0.6981", ",", "0.6959", ",", 
           "0.6983", ",", "0.7006", ",", "0.7022", ",", "0.7137", ",", 
           "0.7224", ",", "0.7226", ",", "0.7349", ",", "0.7378", ",", 
           "0.7406", ",", "0.7418", ",", "0.7431", ",", "0.7457", ",", 
           "0.7446", ",", "0.7391", ",", "0.7311", ",", "0.7281", ",", 
           "0.7279", ",", "0.7154", ",", "0.6984", ",", "0.6867", ",", 
           "0.6687", ",", "0.6565", ",", "0.6364"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
          "0.3312", ",", "0.3472", ",", "0.3481", ",", "0.3508", ",", 
           "0.3526", ",", "0.3513", ",", "0.3659", ",", "0.3942", ",", 
           "0.4122", ",", "0.4065", ",", "0.3964", ",", "0.3937", ",", 
           "0.3853", ",", "0.3779", ",", "0.3851", ",", "0.39", ",", "0.3889",
            ",", "0.3903", ",", "0.3848", ",", "0.3891", ",", "0.3839", ",", 
           "0.3839", ",", "0.3865", ",", "0.3896", ",", "0.3908", ",", 
           "0.3888", ",", "0.3916", ",", "0.3913", ",", "0.3894", ",", 
           "0.3847", ",", "0.3908", ",", "0.3986", ",", "0.4017", ",", 
           "0.4017", ",", "0.4044", ",", "0.4005", ",", "0.3981", ",", 
           "0.3967", ",", "0.389", ",", "0.3824", ",", "0.3831", ",", 
           "0.3825", ",", "0.3797", ",", "0.3826", ",", "0.3721", ",", 
           "0.3723", ",", "0.3746", ",", "0.3697", ",", "0.3758", ",", 
           "0.3794", ",", "0.3686", ",", "0.3692", ",", "0.3705", ",", 
           "0.3676", ",", "0.3718", ",", "0.3941", ",", "0.3967", ",", 
           "0.3987", ",", "0.4019", ",", "0.4113", ",", "0.38", ",", "0.4009",
            ",", "0.3952", ",", "0.3318"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
          "0.71", ",", "0.7347", ",", "0.7366", ",", "0.7424", ",", "0.7558", 
           ",", "0.7668", ",", "0.7809", ",", "0.793", ",", "0.8068", ",", 
           "0.8064", ",", "0.8064", ",", "0.8069", ",", "0.8053", ",", 
           "0.7997", ",", "0.8017", ",", "0.8023", ",", "0.8001", ",", 
           "0.7968", ",", "0.7948", ",", "0.7943", ",", "0.796", ",", "0.796",
            ",", "0.7921", ",", "0.7954", ",", "0.801", ",", "0.7999", ",", 
           "0.8026", ",", "0.8051", ",", "0.8043", ",", "0.8008", ",", 
           "0.7979", ",", "0.7963", ",", "0.7943", ",", "0.7916", ",", 
           "0.7968", ",", "0.8001", ",", "0.8009", ",", "0.804", ",", 
           "0.8033", ",", "0.796", ",", "0.7944", ",", "0.7962", ",", 
           "0.7969", ",", "0.7997", ",", "0.8049", ",", "0.8127", ",", 
           "0.8139", ",", "0.8227", ",", "0.828", ",", "0.8321", ",", 
           "0.8283", ",", "0.8298", ",", "0.8327", ",", "0.8304", ",", 
           "0.8273", ",", "0.8306", ",", "0.8292", ",", "0.8299", ",", 
           "0.8206", ",", "0.8105", ",", "0.7848", ",", "0.7797", ",", 
           "0.7663", ",", "0.7177"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
          "1041", ",", "1041", ",", "1041", ",", "1041", ",", "1041", ",", 
           "1041", ",", "1041", ",", "1041", ",", "1041", ",", "1041", ",", 
           "1041", ",", "1041", ",", "1041", ",", "1041", ",", "1041", ",", 
           "1041", ",", "1041", ",", "1041", ",", "1041", ",", "1041", ",", 
           "1041", ",", "1041", ",", "1041", ",", "1041", ",", "1041", ",", 
           "1041", ",", "1041", ",", "1041", ",", "1041", ",", "1041", ",", 
           "1041", ",", "1041", ",", "1041", ",", "1041", ",", "1041", ",", 
           "1040", ",", "1038", ",", "1037", ",", "1032", ",", "1028", ",", 
           "1028", ",", "1024", ",", "1023", ",", "1023", ",", "1020", ",", 
           "1008", ",", "1006", ",", "1004", ",", "990", ",", "983", ",", 
           "978", ",", "960", ",", "953", ",", "953", ",", "948", ",", "914", 
           ",", "900", ",", "892", ",", "858", ",", "817", ",", "785", ",", 
           "722", ",", "690", ",", "659"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
          "221", ",", "221", ",", "221", ",", "221", ",", "221", ",", "221", ",",
            "221", ",", "221", ",", "221", ",", "221", ",", "221", ",", "221",
            ",", "221", ",", "221", ",", "221", ",", "221", ",", "221", ",", 
           "221", ",", "221", ",", "221", ",", "221", ",", "221", ",", "221", 
           ",", "221", ",", "221", ",", "221", ",", "221", ",", "221", ",", 
           "221", ",", "221", ",", "221", ",", "221", ",", "221", ",", "221", 
           ",", "221", ",", "221", ",", "221", ",", "221", ",", "221", ",", 
           "220", ",", "220", ",", "220", ",", "220", ",", "220", ",", "220", 
           ",", "217", ",", "217", ",", "217", ",", "215", ",", "214", ",", 
           "213", ",", "209", ",", "209", ",", "209", ",", "209", ",", "199", 
           ",", "198", ",", "197", ",", "195", ",", "188", ",", "183", ",", 
           "170", ",", "166", ",", "160"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
          "322", ",", "322", ",", "322", ",", "322", ",", "322", ",", "322", ",",
            "322", ",", "322", ",", "322", ",", "322", ",", "322", ",", "322",
            ",", "322", ",", "322", ",", "322", ",", "322", ",", "322", ",", 
           "322", ",", "322", ",", "322", ",", "322", ",", "322", ",", "322", 
           ",", "322", ",", "322", ",", "322", ",", "322", ",", "322", ",", 
           "322", ",", "322", ",", "322", ",", "322", ",", "322", ",", "322", 
           ",", "322", ",", "322", ",", "321", ",", "321", ",", "321", ",", 
           "321", ",", "321", ",", "320", ",", "319", ",", "319", ",", "319", 
           ",", "317", ",", "316", ",", "315", ",", "312", ",", "308", ",", 
           "307", ",", "302", ",", "300", ",", "300", ",", "299", ",", "292", 
           ",", "291", ",", "287", ",", "278", ",", "275", ",", "269", ",", 
           "248", ",", "242", ",", "238"}], "}"}]}], "}"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"SetOptions", "[", 
       RowBox[{"InterpolateCoefficientList", ",", 
        RowBox[{"IpolHalfWindowLength", "->", "ilenALL"}], ",", 
        RowBox[{"IpolOrder", "->", "ipolorderALL"}], ",", 
        RowBox[{"IpolType", "->", "ipolTypeAll"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Which", "[", 
       RowBox[{
        RowBox[{"per", "<", 
         RowBox[{"periodlist", "[", 
          RowBox[{"[", "2", "]"}], "]"}]}], ",", 
        RowBox[{"(*", "PGV", "*)"}], 
        RowBox[{
         RowBox[{"a1", "=", 
          RowBox[{"a1list", "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"a2", "=", 
          RowBox[{"a2list", "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"a3", "=", 
          RowBox[{"a3list", "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"a4", "=", 
          RowBox[{"a4list", "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"a5", "=", 
          RowBox[{"a5list", "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"a6", "=", 
          RowBox[{"a6list", "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"a7", "=", 
          RowBox[{"a7list", "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"a8", "=", 
          RowBox[{"a8list", "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"a9", "=", 
          RowBox[{"a9list", "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"c1", "=", 
          RowBox[{"c1list", "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"vcon", "=", 
          RowBox[{"vconlist", "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"vref", "=", 
          RowBox[{"vreflist", "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"c", "=", 
          RowBox[{"clist", "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"n", "=", 
          RowBox[{"nlist", "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"b1", "=", 
          RowBox[{"b1list", "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"b2", "=", 
          RowBox[{"b2list", "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"sd1", "=", 
          RowBox[{"sd1list", "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"sd2", "=", 
          RowBox[{"sd2list", "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"sd", "=", 
          RowBox[{"sdlist", "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"nrec", "=", 
          RowBox[{"nreclist", "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"neq", "=", 
          RowBox[{"neqlist", "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"nst", "=", 
          RowBox[{"nstlist", "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], ";"}], ",", 
        RowBox[{"0.", "<=", "per", "<", 
         RowBox[{"periodlist", "[", 
          RowBox[{"[", "3", "]"}], "]"}]}], ",", 
        RowBox[{"(*", "PGA", "*)"}], 
        RowBox[{
         RowBox[{"a1", "=", 
          RowBox[{"a1list", "[", 
           RowBox[{"[", "2", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"a2", "=", 
          RowBox[{"a2list", "[", 
           RowBox[{"[", "2", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"a3", "=", 
          RowBox[{"a3list", "[", 
           RowBox[{"[", "2", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"a4", "=", 
          RowBox[{"a4list", "[", 
           RowBox[{"[", "2", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"a5", "=", 
          RowBox[{"a5list", "[", 
           RowBox[{"[", "2", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"a6", "=", 
          RowBox[{"a6list", "[", 
           RowBox[{"[", "2", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"a7", "=", 
          RowBox[{"a7list", "[", 
           RowBox[{"[", "2", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"a8", "=", 
          RowBox[{"a8list", "[", 
           RowBox[{"[", "2", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"a9", "=", 
          RowBox[{"a9list", "[", 
           RowBox[{"[", "2", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"c1", "=", 
          RowBox[{"c1list", "[", 
           RowBox[{"[", "2", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"vcon", "=", 
          RowBox[{"vconlist", "[", 
           RowBox[{"[", "2", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"vref", "=", 
          RowBox[{"vreflist", "[", 
           RowBox[{"[", "2", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"c", "=", 
          RowBox[{"clist", "[", 
           RowBox[{"[", "2", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"n", "=", 
          RowBox[{"nlist", "[", 
           RowBox[{"[", "2", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"b1", "=", 
          RowBox[{"b1list", "[", 
           RowBox[{"[", "2", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"b2", "=", 
          RowBox[{"b2list", "[", 
           RowBox[{"[", "2", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"sd1", "=", 
          RowBox[{"sd1list", "[", 
           RowBox[{"[", "2", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"sd2", "=", 
          RowBox[{"sd2list", "[", 
           RowBox[{"[", "2", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"sd", "=", 
          RowBox[{"sdlist", "[", 
           RowBox[{"[", "2", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"nrec", "=", 
          RowBox[{"nreclist", "[", 
           RowBox[{"[", "2", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"neq", "=", 
          RowBox[{"neqlist", "[", 
           RowBox[{"[", "2", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"nst", "=", 
          RowBox[{"nstlist", "[", 
           RowBox[{"[", "2", "]"}], "]"}]}], ";"}], ",", 
        RowBox[{
         RowBox[{"periodlist", "[", 
          RowBox[{"[", "3", "]"}], "]"}], "<=", "per"}], ",", 
        RowBox[{"(*", "PSA", "*)"}], 
        RowBox[{
         RowBox[{"a1", "=", 
          RowBox[{"InterpolateCoefficientList", "[", 
           RowBox[{"per", ",", "periodlist", ",", "a1list"}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"a2", "=", 
          RowBox[{"InterpolateCoefficientList", "[", 
           RowBox[{"per", ",", "periodlist", ",", "a2list"}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"a3", "=", 
          RowBox[{"InterpolateCoefficientList", "[", 
           RowBox[{"per", ",", "periodlist", ",", "a3list"}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"a4", "=", 
          RowBox[{"InterpolateCoefficientList", "[", 
           RowBox[{"per", ",", "periodlist", ",", "a4list"}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"a5", "=", 
          RowBox[{"InterpolateCoefficientList", "[", 
           RowBox[{"per", ",", "periodlist", ",", "a5list"}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"a6", "=", 
          RowBox[{"InterpolateCoefficientList", "[", 
           RowBox[{"per", ",", "periodlist", ",", "a6list"}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"a7", "=", 
          RowBox[{"InterpolateCoefficientList", "[", 
           RowBox[{"per", ",", "periodlist", ",", "a7list"}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"a8", "=", 
          RowBox[{"InterpolateCoefficientList", "[", 
           RowBox[{"per", ",", "periodlist", ",", "a8list"}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"a9", "=", 
          RowBox[{"InterpolateCoefficientList", "[", 
           RowBox[{"per", ",", "periodlist", ",", "a9list"}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"c1", "=", 
          RowBox[{"InterpolateCoefficientList", "[", 
           RowBox[{"per", ",", "periodlist", ",", "c1list"}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"vcon", "=", 
          RowBox[{"InterpolateCoefficientList", "[", 
           RowBox[{"per", ",", "periodlist", ",", "vconlist"}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"vref", "=", 
          RowBox[{"InterpolateCoefficientList", "[", 
           RowBox[{"per", ",", "periodlist", ",", "vreflist"}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"c", "=", 
          RowBox[{"InterpolateCoefficientList", "[", 
           RowBox[{"per", ",", "periodlist", ",", "clist"}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"n", "=", 
          RowBox[{"InterpolateCoefficientList", "[", 
           RowBox[{"per", ",", "periodlist", ",", "nlist"}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"b1", "=", 
          RowBox[{"InterpolateCoefficientList", "[", 
           RowBox[{"per", ",", "periodlist", ",", "b1list"}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"b2", "=", 
          RowBox[{"InterpolateCoefficientList", "[", 
           RowBox[{"per", ",", "periodlist", ",", "b2list"}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"sd1", "=", 
          RowBox[{"InterpolateCoefficientList", "[", 
           RowBox[{"per", ",", "periodlist", ",", "sd1list"}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"sd2", "=", 
          RowBox[{"InterpolateCoefficientList", "[", 
           RowBox[{"per", ",", "periodlist", ",", "sd2list"}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"sd", "=", 
          RowBox[{"InterpolateCoefficientList", "[", 
           RowBox[{"per", ",", "periodlist", ",", "sdlist"}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"nrec", "=", 
          RowBox[{"InterpolateCoefficientList", "[", 
           RowBox[{"per", ",", "periodlist", ",", "nreclist"}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"neq", "=", 
          RowBox[{"InterpolateCoefficientList", "[", 
           RowBox[{"per", ",", "periodlist", ",", "neqlist"}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"nst", "=", 
          RowBox[{"InterpolateCoefficientList", "[", 
           RowBox[{"per", ",", "periodlist", ",", "nstlist"}], "]"}]}], 
         ";"}]}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"Which", "[", 
       RowBox[{
        RowBox[{"faulttypeinp", "==", "\"\<NORMAL\>\""}], ",", 
        RowBox[{
         RowBox[{"fn", "=", "1."}], ";", "\[IndentingNewLine]", 
         RowBox[{"fr", "=", "0."}], ";"}], ",", 
        RowBox[{"faulttypeinp", "==", "\"\<STRIKE SLIP\>\""}], ",", 
        RowBox[{
         RowBox[{"fn", "=", "0."}], ";", "\[IndentingNewLine]", 
         RowBox[{"fr", "=", "0."}], ";"}], ",", 
        RowBox[{"faulttypeinp", "==", "\"\<REVERSE\>\""}], ",", 
        RowBox[{
         RowBox[{"fn", "=", "0."}], ";", "\[IndentingNewLine]", 
         RowBox[{"fr", "=", "1."}], ";"}], ",", "True", ",", 
        RowBox[{
         RowBox[{"Message", "[", 
          RowBox[{
           RowBox[{"EmpiricalEquation", "::", "option"}], ",", "faulttypeinp",
            ",", "FaultTypeNSSR"}], "]"}], ";", "\[IndentingNewLine]", 
         RowBox[{"Return", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "999."}], ",", 
            RowBox[{"-", "999."}], ",", 
            RowBox[{"-", "999."}], ",", 
            RowBox[{"-", "999."}]}], "}"}], "]"}], ";"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{"Print", "[", 
         RowBox[{"\"\<fn, fr: \>\"", ",", 
          RowBox[{"{", 
           RowBox[{"fn", ",", "fr"}], "}"}]}], "]"}], ";"}], "*)"}], 
      RowBox[{"(*", 
       RowBox[{"*", "PGA", " ", "ref"}], "**)"}], 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"mw", "<=", "c1"}], ",", 
        RowBox[{
         RowBox[{"lnPGAref", "=", 
          RowBox[{
           RowBox[{"a1list", "[", 
            RowBox[{"[", "2", "]"}], "]"}], "+", 
           RowBox[{
            RowBox[{"a2list", "[", 
             RowBox[{"[", "2", "]"}], "]"}], " ", 
            RowBox[{"(", 
             RowBox[{"mw", "-", 
              RowBox[{"c1list", "[", 
               RowBox[{"[", "2", "]"}], "]"}]}], ")"}]}], "+", 
           RowBox[{
            RowBox[{"a3list", "[", 
             RowBox[{"[", "2", "]"}], "]"}], " ", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"8.5", "-", "mw"}], ")"}], "^", "2"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"a4list", "[", 
               RowBox[{"[", "2", "]"}], "]"}], "+", 
              RowBox[{
               RowBox[{"a5list", "[", 
                RowBox[{"[", "2", "]"}], "]"}], " ", 
               RowBox[{"(", 
                RowBox[{"mw", "-", 
                 RowBox[{"c1list", "[", 
                  RowBox[{"[", "2", "]"}], "]"}]}], ")"}]}]}], ")"}], " ", 
            RowBox[{"Log", "[", 
             RowBox[{"Sqrt", "[", 
              RowBox[{
               RowBox[{"rdist", "^", "2"}], "+", 
               RowBox[{
                RowBox[{"a6list", "[", 
                 RowBox[{"[", "2", "]"}], "]"}], "^", "2"}]}], "]"}], "]"}]}],
            "+", 
           RowBox[{
            RowBox[{"a8list", "[", 
             RowBox[{"[", "2", "]"}], "]"}], " ", "fn"}], "+", 
           RowBox[{
            RowBox[{"a9list", "[", 
             RowBox[{"[", "2", "]"}], "]"}], " ", "fr"}]}]}], ";"}], ",", 
        RowBox[{"(*", 
         RowBox[{
          RowBox[{"else", " ", "mw"}], ">", "c1"}], "*)"}], 
        RowBox[{
         RowBox[{"lnPGAref", "=", 
          RowBox[{
           RowBox[{"a1list", "[", 
            RowBox[{"[", "2", "]"}], "]"}], "+", 
           RowBox[{
            RowBox[{"a7list", "[", 
             RowBox[{"[", "2", "]"}], "]"}], " ", 
            RowBox[{"(", 
             RowBox[{"mw", "-", 
              RowBox[{"c1list", "[", 
               RowBox[{"[", "2", "]"}], "]"}]}], ")"}]}], "+", 
           RowBox[{
            RowBox[{"a3list", "[", 
             RowBox[{"[", "2", "]"}], "]"}], " ", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"8.5", "-", "mw"}], ")"}], "^", "2"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"a4list", "[", 
               RowBox[{"[", "2", "]"}], "]"}], "+", 
              RowBox[{
               RowBox[{"a5list", "[", 
                RowBox[{"[", "2", "]"}], "]"}], " ", 
               RowBox[{"(", 
                RowBox[{"mw", "-", 
                 RowBox[{"c1list", "[", 
                  RowBox[{"[", "2", "]"}], "]"}]}], ")"}]}]}], ")"}], " ", 
            RowBox[{"Log", "[", 
             RowBox[{"Sqrt", "[", 
              RowBox[{
               RowBox[{"rdist", "^", "2"}], "+", 
               RowBox[{
                RowBox[{"a6list", "[", 
                 RowBox[{"[", "2", "]"}], "]"}], "^", "2"}]}], "]"}], "]"}]}],
            "+", 
           RowBox[{
            RowBox[{"a8list", "[", 
             RowBox[{"[", "2", "]"}], "]"}], " ", "fn"}], "+", 
           RowBox[{
            RowBox[{"a9list", "[", 
             RowBox[{"[", "2", "]"}], "]"}], " ", "fr"}]}]}], ";"}]}], "]"}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{"Print", "[", 
         RowBox[{"\"\<PGAref: \>\"", ",", 
          RowBox[{"Exp", "[", "lnPGAref", "]"}]}], "]"}], ";"}], "*)"}], 
      RowBox[{"(*", 
       RowBox[{"*", "site", " ", "amplification"}], "**)"}], 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"vs30", "<=", "vref"}], ",", 
        RowBox[{
         RowBox[{"lns", "=", 
          RowBox[{
           RowBox[{"b1", " ", 
            RowBox[{"Log", "[", 
             RowBox[{"vs30", "/", "vref"}], "]"}]}], "+", 
           RowBox[{"b2", " ", 
            RowBox[{"Log", "[", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"Exp", "[", "lnPGAref", "]"}], "+", 
                RowBox[{"c", " ", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"vs30", "/", "vref"}], ")"}], "^", "n"}]}]}], 
               ")"}], "/", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"Exp", "[", "lnPGAref", "]"}], "+", "c"}], ")"}], 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"vs30", "/", "vref"}], ")"}], "^", "n"}]}], ")"}]}],
              "]"}]}]}]}], ";"}], ",", 
        RowBox[{
         RowBox[{"lns", "=", 
          RowBox[{"b1", " ", 
           RowBox[{"Log", "[", 
            RowBox[{
             RowBox[{"Min", "[", 
              RowBox[{"vs30", ",", "vcon"}], "]"}], "/", "vref"}], "]"}]}]}], 
         ";"}]}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"(*", 
       RowBox[{"*", "lnY"}], "**)"}], 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"mw", "<=", "c1"}], ",", 
        RowBox[{
         RowBox[{"lnrefy", "=", 
          RowBox[{"a1", "+", 
           RowBox[{"a2", "*", 
            RowBox[{"(", 
             RowBox[{"mw", "-", "c1"}], ")"}]}], "+", 
           RowBox[{"a3", "*", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"8.5", "-", "mw"}], ")"}], "^", "2"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"a4", "+", 
              RowBox[{"a5", "*", 
               RowBox[{"(", 
                RowBox[{"mw", "-", "c1"}], ")"}]}]}], ")"}], " ", 
            RowBox[{"Log", "[", 
             RowBox[{"Sqrt", "[", 
              RowBox[{
               RowBox[{"rdist", "^", "2"}], "+", 
               RowBox[{"a6", "^", "2"}]}], "]"}], "]"}]}], "+", 
           RowBox[{"a8", " ", "fn"}], "+", 
           RowBox[{"a9", " ", "fr"}]}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"(*", 
          RowBox[{
          "partials", " ", "copied", " ", "over", " ", "from", " ", "Akkar", " ",
            "and", " ", "Cagna", " ", "model", " ", "and", " ", "modified", " ",
            "coeffiecients"}], "*)"}], 
         RowBox[{"pddist", "=", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"a4", "+", 
               RowBox[{"a5", "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "c1"}], "+", "mw"}], ")"}]}]}], ")"}], "*", 
             "rdist"}], ")"}], "/", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"a6", "^", "2"}], "+", 
             RowBox[{"rdist", "^", "2"}]}], ")"}]}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"pdmag", "=", 
          RowBox[{"a2", "-", 
           RowBox[{"2", "*", "a3", "*", 
            RowBox[{"(", 
             RowBox[{"8.5", "-", "mw"}], ")"}]}], "+", 
           RowBox[{"a5", "*", 
            RowBox[{"Log", "[", 
             RowBox[{"Sqrt", "[", 
              RowBox[{
               RowBox[{"a6", "^", "2"}], "+", 
               RowBox[{"rdist", "^", "2"}]}], "]"}], "]"}]}]}]}], ";"}], ",", 
        
        RowBox[{"(*", 
         RowBox[{
          RowBox[{"else", " ", "mw"}], ">", "c1"}], "*)"}], 
        RowBox[{
         RowBox[{"lnrefy", "=", 
          RowBox[{"a1", "+", 
           RowBox[{"a7", "*", 
            RowBox[{"(", 
             RowBox[{"mw", "-", "c1"}], ")"}]}], "+", 
           RowBox[{"a3", "*", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"8.5", "-", "mw"}], ")"}], "^", "2"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"a4", "+", 
              RowBox[{"a5", "*", 
               RowBox[{"(", 
                RowBox[{"mw", "-", "c1"}], ")"}]}]}], ")"}], " ", 
            RowBox[{"Log", "[", 
             RowBox[{"Sqrt", "[", 
              RowBox[{
               RowBox[{"rdist", "^", "2"}], "+", 
               RowBox[{"a6", "^", "2"}]}], "]"}], "]"}]}], "+", 
           RowBox[{"a8", " ", "fn"}], "+", 
           RowBox[{"a9", " ", "fr"}]}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"pddist", "=", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"a4", "+", 
               RowBox[{"a5", "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "c1"}], "+", "mw"}], ")"}]}]}], ")"}], "*", 
             "rdist"}], ")"}], "/", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"a6", "^", "2"}], "+", 
             RowBox[{"rdist", "^", "2"}]}], ")"}]}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"pdmag", "=", 
          RowBox[{"a7", "-", 
           RowBox[{"2", "*", "a3", "*", 
            RowBox[{"(", 
             RowBox[{"8.5", "-", "mw"}], ")"}]}], "+", 
           RowBox[{"a5", "*", 
            RowBox[{"Log", "[", 
             RowBox[{"Sqrt", "[", 
              RowBox[{
               RowBox[{"a6", "^", "2"}], "+", 
               RowBox[{"rdist", "^", "2"}]}], "]"}], "]"}]}]}]}]}]}], "]"}], ";",
       "\[IndentingNewLine]", 
      RowBox[{"Which", "[", 
       RowBox[{
        RowBox[{"per", "<", 
         RowBox[{"periodlist", "[", 
          RowBox[{"[", "2", "]"}], "]"}]}], ",", 
        RowBox[{"(*", "PGV", "*)"}], 
        RowBox[{"(*", 
         RowBox[{"PGV", " ", "in", " ", 
          RowBox[{"m", "/", "s"}]}], "*)"}], 
        RowBox[{
         RowBox[{"saval", "=", 
          RowBox[{".01", " ", 
           RowBox[{"Exp", "[", 
            RowBox[{"lnrefy", "+", "lns"}], "]"}]}]}], ";"}], ",", 
        RowBox[{"0.", "<=", "per", "<", 
         RowBox[{"periodlist", "[", 
          RowBox[{"[", "3", "]"}], "]"}]}], ",", 
        RowBox[{"(*", "PGA", "*)"}], 
        RowBox[{"(*", 
         RowBox[{"PGA", " ", "in", " ", 
          RowBox[{"m", "/", "s"}], "*", "s"}], "*)"}], 
        RowBox[{
         RowBox[{"saval", "=", 
          RowBox[{"9.81", "*", 
           RowBox[{"Exp", "[", 
            RowBox[{"lnrefy", "+", "lns"}], "]"}]}]}], ";"}], ",", 
        RowBox[{
         RowBox[{"periodlist", "[", 
          RowBox[{"[", "3", "]"}], "]"}], "<=", "per"}], ",", 
        RowBox[{"(*", "PSA", "*)"}], 
        RowBox[{"(*", 
         RowBox[{"SA", " ", "in", " ", 
          RowBox[{"m", "/", "s"}], "*", "s"}], "*)"}], 
        RowBox[{
         RowBox[{"saval", "=", 
          RowBox[{"9.81", "*", 
           RowBox[{"Exp", "[", 
            RowBox[{"lnrefy", "+", "lns"}], "]"}]}]}], ";"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"sigtotal", "=", "sd"}], ";", "\[IndentingNewLine]", 
      RowBox[{"Return", "[", 
       RowBox[{"{", 
        RowBox[{"saval", ",", "sigtotal", ",", "pddist", ",", "pdmag"}], 
        "}"}], "]"}], ";"}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.952169363343212*^9, 3.952169363344571*^9}, 
   3.952169421896105*^9, {3.952169484684043*^9, 3.952169491195623*^9}, 
   3.952173486345992*^9},
 CellLabel->"In[47]:=",ExpressionUUID->"2fed103b-13f9-42dd-835e-80e45b203a98"]
}, Closed]],

Cell[CellGroupData[{

Cell["AkkarEtal2013RJBHor", "Subsubsection",
 CellChangeTimes->{{3.952169552360321*^9, 3.952169577087267*^9}, 
   3.952172831298647*^9},ExpressionUUID->"9d75d02e-7ca8-4a55-96fc-\
ad9aa14ebbb0"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"AkkarEtal2013RJBHor", "::", "usage"}], 
   "=", "\"\<AkkarEtal2013RJBHor[p,options] returns \
{as,sigma,partasr,partasm}  for resonator period p  using the model of Akkar \
et al.  (2013) for the Joyner-Boore distance distance as intrinsic distance \
metric.\>\""}], ";"}]], "Input",
 CellChangeTimes->{{3.9521728225134687`*^9, 3.952172822515813*^9}, {
  3.952172931790595*^9, 3.952172941589902*^9}},
 CellLabel->"In[49]:=",ExpressionUUID->"3d868c20-8d28-410c-909a-2e86fd650c63"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Options", "[", "AkkarEtal2013RJBHor", "]"}], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"MagMW", "->", "6."}], ",", 
     RowBox[{"DistJB", "->", "10."}], ",", 
     RowBox[{"Vs30", "->", "760."}], ",", 
     RowBox[{"FaultTypeNSSR", "->", "\"\<STRIKE SLIP\>\""}]}], "}"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"AkkarEtal2013RJBHor", "[", 
    RowBox[{"per_", ",", 
     RowBox[{"opts", ":", 
      RowBox[{"OptionsPattern", "[", "]"}]}]}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "mw", ",", "rdist", ",", "vs30", ",", "faulttypeinp", ",", "periodlist",
        ",", "a1list", ",", "a2list", ",", "a3list", ",", "a4list", ",", 
       "a5list", ",", "a6list", ",", "a7list", ",", "a8list", ",", "a9list", ",",
        "c1list", ",", "vconlist", ",", "vreflist", ",", "clist", ",", 
       "nlist", ",", "b1list", ",", "b2list", ",", "sd1list", ",", "sd2list", 
       ",", "sdlist", ",", "nreclist", ",", "neqlist", ",", "nstlist", ",", 
       "a1", ",", "a2", ",", "a3", ",", "a4", ",", "a5", ",", "a6", ",", "a7",
        ",", "a8", ",", "a9", ",", "c1", ",", "vcon", ",", "vref", ",", "c", ",",
        "n", ",", "b1", ",", "b2", ",", "sd1", ",", "sd2", ",", "sd", ",", 
       "nrec", ",", "neq", ",", "nst", ",", "fn", ",", "fr", ",", "lnPGAref", 
       ",", "lns", ",", "lnrefy", ",", "saval", ",", "sigtotal", ",", 
       "pddist", ",", "pdmag"}], "}"}], ",", 
     RowBox[{"(*", 
      RowBox[{"**", 
       RowBox[{"*", "Options"}]}], "****)"}], 
     RowBox[{
      RowBox[{"mw", "=", 
       RowBox[{"OptionValue", "[", "MagMW", "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"rdist", "=", 
       RowBox[{"OptionValue", "[", "DistJB", "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"vs30", "=", 
       RowBox[{"OptionValue", "[", "Vs30", "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"faulttypeinp", "=", 
       RowBox[{"OptionValue", "[", "FaultTypeNSSR", "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{"Print", "[", 
         RowBox[{"\"\<Mw: \>\"", ",", "mw"}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"Print", "[", 
         RowBox[{"\"\<Repi: \>\"", ",", "rdist"}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"Print", "[", 
         RowBox[{"\"\<Vs30: \>\"", ",", "vs30"}], "]"}], ";"}], "*)"}], 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "periodlist", ",", "a1list", ",", "a2list", ",", "a3list", ",", 
         "a4list", ",", "a5list", ",", "a6list", ",", "a7list", ",", "a8list",
          ",", "a9list", ",", "c1list", ",", "vconlist", ",", "vreflist", ",",
          "clist", ",", "nlist", ",", "b1list", ",", "b2list", ",", "sd1list",
          ",", "sd2list", ",", "sdlist", ",", "nreclist", ",", "neqlist", ",",
          "nstlist"}], "}"}], "=", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1."}], ",", "0.", ",", "0.01", ",", "0.02", ",", 
           "0.03", ",", "0.04", ",", "0.05", ",", "0.075", ",", "0.1", ",", 
           "0.11", ",", "0.12", ",", "0.13", ",", "0.14", ",", "0.15", ",", 
           "0.16", ",", "0.17", ",", "0.18", ",", "0.19", ",", "0.2", ",", 
           "0.22", ",", "0.24", ",", "0.26", ",", "0.28", ",", "0.3", ",", 
           "0.32", ",", "0.34", ",", "0.36", ",", "0.38", ",", "0.4", ",", 
           "0.42", ",", "0.44", ",", "0.46", ",", "0.48", ",", "0.5", ",", 
           "0.55", ",", "0.6", ",", "0.65", ",", "0.7", ",", "0.75", ",", 
           "0.8", ",", "0.85", ",", "0.9", ",", "0.95", ",", "1", ",", "1.1", 
           ",", "1.2", ",", "1.3", ",", "1.4", ",", "1.5", ",", "1.6", ",", 
           "1.7", ",", "1.8", ",", "1.9", ",", "2", ",", "2.2", ",", "2.4", ",",
            "2.6", ",", "2.8", ",", "3", ",", "3.2", ",", "3.4", ",", "3.6", ",",
            "3.8", ",", "4"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
          "5.61201", ",", "1.85329", ",", "1.87032", ",", "1.95279", ",", 
           "2.07006", ",", "2.20452", ",", "2.35413", ",", "2.63078", ",", 
           "2.85412", ",", "2.89772", ",", "2.92748", ",", "2.95162", ",", 
           "2.96299", ",", "2.96622", ",", "2.93166", ",", "2.88988", ",", 
           "2.84627", ",", "2.79778", ",", "2.73872", ",", "2.63479", ",", 
           "2.53886", ",", "2.48747", ",", "2.38739", ",", "2.3015", ",", 
           "2.17298", ",", "2.07474", ",", "2.01953", ",", "1.95078", ",", 
           "1.89372", ",", "1.83717", ",", "1.77528", ",", "1.73155", ",", 
           "1.70132", ",", "1.67127", ",", "1.53838", ",", "1.37505", ",", 
           "1.21156", ",", "1.09262", ",", "0.95211", ",", "0.85227", ",", 
           "0.76564", ",", "0.66856", ",", "0.58739", ",", "0.52349", ",", 
           "0.3768", ",", "0.23251", ",", "0.10481", ",", "0.00887", ",", 
           RowBox[{"-", "0.01867"}], ",", 
           RowBox[{"-", "0.0996"}], ",", 
           RowBox[{"-", "0.21166"}], ",", 
           RowBox[{"-", "0.273"}], ",", 
           RowBox[{"-", "0.35366"}], ",", 
           RowBox[{"-", "0.42891"}], ",", 
           RowBox[{"-", "0.55307"}], ",", 
           RowBox[{"-", "0.67806"}], ",", 
           RowBox[{"-", "0.80494"}], ",", 
           RowBox[{"-", "0.91278"}], ",", 
           RowBox[{"-", "1.05642"}], ",", 
           RowBox[{"-", "1.17715"}], ",", 
           RowBox[{"-", "1.22091"}], ",", 
           RowBox[{"-", "1.34547"}], ",", 
           RowBox[{"-", "1.3979"}], ",", 
           RowBox[{"-", "1.37536"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
          "0.0029", ",", "0.0029", ",", "0.0029", ",", "0.0029", ",", 
           "0.0029", ",", "0.0029", ",", "0.0029", ",", "0.0029", ",", 
           "0.0029", ",", "0.0029", ",", "0.0029", ",", "0.0029", ",", 
           "0.0029", ",", "0.0029", ",", "0.0029", ",", "0.0029", ",", 
           "0.0029", ",", "0.0029", ",", "0.0029", ",", "0.0029", ",", 
           "0.0029", ",", "0.0029", ",", "0.0029", ",", "0.0029", ",", 
           "0.0029", ",", "0.0029", ",", "0.0029", ",", "0.0029", ",", 
           "0.0029", ",", "0.0029", ",", "0.0029", ",", "0.0029", ",", 
           "0.0029", ",", "0.0029", ",", "0.0029", ",", "0.0029", ",", 
           "0.0029", ",", "0.0029", ",", "0.0029", ",", "0.0029", ",", 
           "0.0029", ",", "0.0029", ",", "0.0029", ",", "0.0029", ",", 
           "0.0029", ",", "0.0029", ",", "0.0029", ",", "0.0029", ",", 
           "0.0029", ",", "0.0029", ",", "0.0029", ",", "0.0029", ",", 
           "0.0029", ",", "0.0029", ",", "0.0029", ",", "0.0029", ",", 
           "0.0029", ",", "0.0029", ",", "0.0029", ",", "0.0029", ",", 
           "0.0029", ",", "0.0029", ",", "0.0029", ",", "0.0029"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.0998"}], ",", 
           RowBox[{"-", "0.02807"}], ",", 
           RowBox[{"-", "0.0274"}], ",", 
           RowBox[{"-", "0.02715"}], ",", 
           RowBox[{"-", "0.02403"}], ",", 
           RowBox[{"-", "0.01797"}], ",", 
           RowBox[{"-", "0.01248"}], ",", 
           RowBox[{"-", "0.00532"}], ",", 
           RowBox[{"-", "0.00925"}], ",", 
           RowBox[{"-", "0.01062"}], ",", 
           RowBox[{"-", "0.01291"}], ",", 
           RowBox[{"-", "0.01592"}], ",", 
           RowBox[{"-", "0.01866"}], ",", 
           RowBox[{"-", "0.02193"}], ",", 
           RowBox[{"-", "0.02429"}], ",", 
           RowBox[{"-", "0.02712"}], ",", 
           RowBox[{"-", "0.03003"}], ",", 
           RowBox[{"-", "0.033"}], ",", 
           RowBox[{"-", "0.03462"}], ",", 
           RowBox[{"-", "0.03789"}], ",", 
           RowBox[{"-", "0.04173"}], ",", 
           RowBox[{"-", "0.04768"}], ",", 
           RowBox[{"-", "0.05178"}], ",", 
           RowBox[{"-", "0.05672"}], ",", 
           RowBox[{"-", "0.06015"}], ",", 
           RowBox[{"-", "0.06508"}], ",", 
           RowBox[{"-", "0.06974"}], ",", 
           RowBox[{"-", "0.07346"}], ",", 
           RowBox[{"-", "0.07684"}], ",", 
           RowBox[{"-", "0.0801"}], ",", 
           RowBox[{"-", "0.08296"}], ",", 
           RowBox[{"-", "0.08623"}], ",", 
           RowBox[{"-", "0.0907"}], ",", 
           RowBox[{"-", "0.0949"}], ",", 
           RowBox[{"-", "0.10275"}], ",", 
           RowBox[{"-", "0.10747"}], ",", 
           RowBox[{"-", "0.11262"}], ",", 
           RowBox[{"-", "0.11835"}], ",", 
           RowBox[{"-", "0.12347"}], ",", 
           RowBox[{"-", "0.12678"}], ",", 
           RowBox[{"-", "0.13133"}], ",", 
           RowBox[{"-", "0.13551"}], ",", 
           RowBox[{"-", "0.13957"}], ",", 
           RowBox[{"-", "0.14345"}], ",", 
           RowBox[{"-", "0.15051"}], ",", 
           RowBox[{"-", "0.15527"}], ",", 
           RowBox[{"-", "0.16106"}], ",", 
           RowBox[{"-", "0.16654"}], ",", 
           RowBox[{"-", "0.17187"}], ",", 
           RowBox[{"-", "0.17728"}], ",", 
           RowBox[{"-", "0.17908"}], ",", 
           RowBox[{"-", "0.18438"}], ",", 
           RowBox[{"-", "0.18741"}], ",", 
           RowBox[{"-", "0.19029"}], ",", 
           RowBox[{"-", "0.19683"}], ",", 
           RowBox[{"-", "0.20339"}], ",", 
           RowBox[{"-", "0.20703"}], ",", 
           RowBox[{"-", "0.21074"}], ",", 
           RowBox[{"-", "0.21392"}], ",", 
           RowBox[{"-", "0.21361"}], ",", 
           RowBox[{"-", "0.21951"}], ",", 
           RowBox[{"-", "0.22724"}], ",", 
           RowBox[{"-", "0.2318"}], ",", 
           RowBox[{"-", "0.23848"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.98388"}], ",", 
           RowBox[{"-", "1.23452"}], ",", 
           RowBox[{"-", "1.23698"}], ",", 
           RowBox[{"-", "1.25363"}], ",", 
           RowBox[{"-", "1.27525"}], ",", 
           RowBox[{"-", "1.30123"}], ",", 
           RowBox[{"-", "1.32632"}], ",", 
           RowBox[{"-", "1.35722"}], ",", 
           RowBox[{"-", "1.38182"}], ",", 
           RowBox[{"-", "1.38345"}], ",", 
           RowBox[{"-", "1.37997"}], ",", 
           RowBox[{"-", "1.37627"}], ",", 
           RowBox[{"-", "1.37155"}], ",", 
           RowBox[{"-", "1.3646"}], ",", 
           RowBox[{"-", "1.35074"}], ",", 
           RowBox[{"-", "1.33454"}], ",", 
           RowBox[{"-", "1.31959"}], ",", 
           RowBox[{"-", "1.3045"}], ",", 
           RowBox[{"-", "1.28877"}], ",", 
           RowBox[{"-", "1.26125"}], ",", 
           RowBox[{"-", "1.236"}], ",", 
           RowBox[{"-", "1.21882"}], ",", 
           RowBox[{"-", "1.19543"}], ",", 
           RowBox[{"-", "1.17072"}], ",", 
           RowBox[{"-", "1.13847"}], ",", 
           RowBox[{"-", "1.11131"}], ",", 
           RowBox[{"-", "1.09484"}], ",", 
           RowBox[{"-", "1.07812"}], ",", 
           RowBox[{"-", "1.0653"}], ",", 
           RowBox[{"-", "1.05451"}], ",", 
           RowBox[{"-", "1.04332"}], ",", 
           RowBox[{"-", "1.03572"}], ",", 
           RowBox[{"-", "1.02724"}], ",", 
           RowBox[{"-", "1.01909"}], ",", 
           RowBox[{"-", "0.99351"}], ",", 
           RowBox[{"-", "0.96429"}], ",", 
           RowBox[{"-", "0.93347"}], ",", 
           RowBox[{"-", "0.91162"}], ",", 
           RowBox[{"-", "0.88393"}], ",", 
           RowBox[{"-", "0.86884"}], ",", 
           RowBox[{"-", "0.85442"}], ",", 
           RowBox[{"-", "0.83929"}], ",", 
           RowBox[{"-", "0.82668"}], ",", 
           RowBox[{"-", "0.81838"}], ",", 
           RowBox[{"-", "0.79691"}], ",", 
           RowBox[{"-", "0.77813"}], ",", 
           RowBox[{"-", "0.75888"}], ",", 
           RowBox[{"-", "0.74871"}], ",", 
           RowBox[{"-", "0.75751"}], ",", 
           RowBox[{"-", "0.74823"}], ",", 
           RowBox[{"-", "0.73766"}], ",", 
           RowBox[{"-", "0.72996"}], ",", 
           RowBox[{"-", "0.72279"}], ",", 
           RowBox[{"-", "0.72033"}], ",", 
           RowBox[{"-", "0.71662"}], ",", 
           RowBox[{"-", "0.70452"}], ",", 
           RowBox[{"-", "0.69691"}], ",", 
           RowBox[{"-", "0.6956"}], ",", 
           RowBox[{"-", "0.69085"}], ",", 
           RowBox[{"-", "0.67711"}], ",", 
           RowBox[{"-", "0.68177"}], ",", 
           RowBox[{"-", "0.65918"}], ",", 
           RowBox[{"-", "0.65298"}], ",", 
           RowBox[{"-", "0.66482"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
          "0.2529", ",", "0.2529", ",", "0.2529", ",", "0.2529", ",", 
           "0.2529", ",", "0.2529", ",", "0.2529", ",", "0.2529", ",", 
           "0.2529", ",", "0.2529", ",", "0.2529", ",", "0.2529", ",", 
           "0.2529", ",", "0.2529", ",", "0.2529", ",", "0.2529", ",", 
           "0.2529", ",", "0.2529", ",", "0.2529", ",", "0.2529", ",", 
           "0.2529", ",", "0.2529", ",", "0.2529", ",", "0.2529", ",", 
           "0.2529", ",", "0.2529", ",", "0.2529", ",", "0.2529", ",", 
           "0.2529", ",", "0.2529", ",", "0.2529", ",", "0.2529", ",", 
           "0.2529", ",", "0.2529", ",", "0.2529", ",", "0.2529", ",", 
           "0.2529", ",", "0.2529", ",", "0.2529", ",", "0.2529", ",", 
           "0.2529", ",", "0.2529", ",", "0.2529", ",", "0.2529", ",", 
           "0.2529", ",", "0.2529", ",", "0.2529", ",", "0.2529", ",", 
           "0.2529", ",", "0.2529", ",", "0.2529", ",", "0.2529", ",", 
           "0.2529", ",", "0.2529", ",", "0.2529", ",", "0.2529", ",", 
           "0.2529", ",", "0.2529", ",", "0.2529", ",", "0.2529", ",", 
           "0.2529", ",", "0.2529", ",", "0.2529", ",", "0.2529"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
          "7.5", ",", "7.5", ",", "7.5", ",", "7.5", ",", "7.5", ",", "7.5", ",",
            "7.5", ",", "7.5", ",", "7.5", ",", "7.5", ",", "7.5", ",", "7.5",
            ",", "7.5", ",", "7.5", ",", "7.5", ",", "7.5", ",", "7.5", ",", 
           "7.5", ",", "7.5", ",", "7.5", ",", "7.5", ",", "7.5", ",", "7.5", 
           ",", "7.5", ",", "7.5", ",", "7.5", ",", "7.5", ",", "7.5", ",", 
           "7.5", ",", "7.5", ",", "7.5", ",", "7.5", ",", "7.5", ",", "7.5", 
           ",", "7.5", ",", "7.5", ",", "7.5", ",", "7.5", ",", "7.5", ",", 
           "7.5", ",", "7.5", ",", "7.5", ",", "7.5", ",", "7.5", ",", "7.5", 
           ",", "7.5", ",", "7.5", ",", "7.5", ",", "7.5", ",", "7.5", ",", 
           "7.5", ",", "7.5", ",", "7.5", ",", "7.5", ",", "7.5", ",", "7.5", 
           ",", "7.5", ",", "7.5", ",", "7.5", ",", "7.5", ",", "7.5", ",", 
           "7.5", ",", "7.5", ",", "7.5"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.5096"}], ",", 
           RowBox[{"-", "0.5096"}], ",", 
           RowBox[{"-", "0.5096"}], ",", 
           RowBox[{"-", "0.5096"}], ",", 
           RowBox[{"-", "0.5096"}], ",", 
           RowBox[{"-", "0.5096"}], ",", 
           RowBox[{"-", "0.5096"}], ",", 
           RowBox[{"-", "0.5096"}], ",", 
           RowBox[{"-", "0.5096"}], ",", 
           RowBox[{"-", "0.5096"}], ",", 
           RowBox[{"-", "0.5096"}], ",", 
           RowBox[{"-", "0.5096"}], ",", 
           RowBox[{"-", "0.5096"}], ",", 
           RowBox[{"-", "0.5096"}], ",", 
           RowBox[{"-", "0.5096"}], ",", 
           RowBox[{"-", "0.5096"}], ",", 
           RowBox[{"-", "0.5096"}], ",", 
           RowBox[{"-", "0.5096"}], ",", 
           RowBox[{"-", "0.5096"}], ",", 
           RowBox[{"-", "0.5096"}], ",", 
           RowBox[{"-", "0.5096"}], ",", 
           RowBox[{"-", "0.5096"}], ",", 
           RowBox[{"-", "0.5096"}], ",", 
           RowBox[{"-", "0.5096"}], ",", 
           RowBox[{"-", "0.5096"}], ",", 
           RowBox[{"-", "0.5096"}], ",", 
           RowBox[{"-", "0.5096"}], ",", 
           RowBox[{"-", "0.5096"}], ",", 
           RowBox[{"-", "0.5096"}], ",", 
           RowBox[{"-", "0.5096"}], ",", 
           RowBox[{"-", "0.5096"}], ",", 
           RowBox[{"-", "0.5096"}], ",", 
           RowBox[{"-", "0.5096"}], ",", 
           RowBox[{"-", "0.5096"}], ",", 
           RowBox[{"-", "0.5096"}], ",", 
           RowBox[{"-", "0.5096"}], ",", 
           RowBox[{"-", "0.5096"}], ",", 
           RowBox[{"-", "0.5096"}], ",", 
           RowBox[{"-", "0.5096"}], ",", 
           RowBox[{"-", "0.5096"}], ",", 
           RowBox[{"-", "0.5096"}], ",", 
           RowBox[{"-", "0.5096"}], ",", 
           RowBox[{"-", "0.5096"}], ",", 
           RowBox[{"-", "0.5096"}], ",", 
           RowBox[{"-", "0.5096"}], ",", 
           RowBox[{"-", "0.5096"}], ",", 
           RowBox[{"-", "0.5096"}], ",", 
           RowBox[{"-", "0.5096"}], ",", 
           RowBox[{"-", "0.5096"}], ",", 
           RowBox[{"-", "0.5096"}], ",", 
           RowBox[{"-", "0.5096"}], ",", 
           RowBox[{"-", "0.5096"}], ",", 
           RowBox[{"-", "0.5096"}], ",", 
           RowBox[{"-", "0.5096"}], ",", 
           RowBox[{"-", "0.5096"}], ",", 
           RowBox[{"-", "0.5096"}], ",", 
           RowBox[{"-", "0.5096"}], ",", 
           RowBox[{"-", "0.5096"}], ",", 
           RowBox[{"-", "0.5096"}], ",", 
           RowBox[{"-", "0.5096"}], ",", 
           RowBox[{"-", "0.5096"}], ",", 
           RowBox[{"-", "0.5096"}], ",", 
           RowBox[{"-", "0.5096"}], ",", 
           RowBox[{"-", "0.5096"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.0616"}], ",", 
           RowBox[{"-", "0.1091"}], ",", 
           RowBox[{"-", "0.1115"}], ",", 
           RowBox[{"-", "0.104"}], ",", 
           RowBox[{"-", "0.0973"}], ",", 
           RowBox[{"-", "0.0884"}], ",", 
           RowBox[{"-", "0.0853"}], ",", 
           RowBox[{"-", "0.0779"}], ",", 
           RowBox[{"-", "0.0749"}], ",", 
           RowBox[{"-", "0.0704"}], ",", 
           RowBox[{"-", "0.0604"}], ",", 
           RowBox[{"-", "0.049"}], ",", 
           RowBox[{"-", "0.0377"}], ",", 
           RowBox[{"-", "0.0265"}], ",", 
           RowBox[{"-", "0.0194"}], ",", 
           RowBox[{"-", "0.0125"}], ",", 
           RowBox[{"-", "0.0056"}], ",", "0", ",", "0", ",", "0", ",", "0", ",",
            "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",",
            "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",",
            "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",",
            "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",",
            "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",",
            "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",",
            "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
          "0.063", ",", "0.0937", ",", "0.0953", ",", "0.1029", ",", "0.1148",
            ",", "0.1073", ",", "0.1052", ",", "0.0837", ",", "0.0761", ",", 
           "0.0707", ",", "0.0653", ",", "0.0617", ",", "0.0581", ",", 
           "0.0545", ",", "0.0509", ",", "0.0507", ",", "0.0502", ",", 
           "0.0497", ",", "0.0493", ",", "0.0488", ",", "0.0483", ",", 
           "0.0478", ",", "0.0474", ",", "0.0469", ",", "0.0464", ",", 
           "0.0459", ",", "0.0459", ",", "0.0429", ",", "0.04", ",", "0.0374",
            ",", "0.0349", ",", "0.0323", ",", "0.0297", ",", "0.0271", ",", 
           "0.0245", ",", "0.0219", ",", "0.0193", ",", "0.0167", ",", 
           "0.0141", ",", "0.0115", ",", "0.0089", ",", "0.0062", ",", 
           "0.0016", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
           "0", ",", "0", ",", "0", ",", 
           RowBox[{"-", "0.003"}], ",", 
           RowBox[{"-", "0.006"}], ",", 
           RowBox[{"-", "0.009"}], ",", 
           RowBox[{"-", "0.0141"}], ",", 
           RowBox[{"-", "0.0284"}], ",", 
           RowBox[{"-", "0.0408"}], ",", 
           RowBox[{"-", "0.0534"}], ",", 
           RowBox[{"-", "0.0683"}], ",", 
           RowBox[{"-", "0.078"}], ",", 
           RowBox[{"-", "0.0943"}], ",", 
           RowBox[{"-", "0.1278"}], ",", 
           RowBox[{"-", "0.1744"}], ",", 
           RowBox[{"-", "0.2231"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
          "6.75", ",", "6.75", ",", "6.75", ",", "6.75", ",", "6.75", ",", 
           "6.75", ",", "6.75", ",", "6.75", ",", "6.75", ",", "6.75", ",", 
           "6.75", ",", "6.75", ",", "6.75", ",", "6.75", ",", "6.75", ",", 
           "6.75", ",", "6.75", ",", "6.75", ",", "6.75", ",", "6.75", ",", 
           "6.75", ",", "6.75", ",", "6.75", ",", "6.75", ",", "6.75", ",", 
           "6.75", ",", "6.75", ",", "6.75", ",", "6.75", ",", "6.75", ",", 
           "6.75", ",", "6.75", ",", "6.75", ",", "6.75", ",", "6.75", ",", 
           "6.75", ",", "6.75", ",", "6.75", ",", "6.75", ",", "6.75", ",", 
           "6.75", ",", "6.75", ",", "6.75", ",", "6.75", ",", "6.75", ",", 
           "6.75", ",", "6.75", ",", "6.75", ",", "6.75", ",", "6.75", ",", 
           "6.75", ",", "6.75", ",", "6.75", ",", "6.75", ",", "6.75", ",", 
           "6.75", ",", "6.75", ",", "6.75", ",", "6.75", ",", "6.75", ",", 
           "6.75", ",", "6.75", ",", "6.75", ",", "6.75"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
          "1000", ",", "1000", ",", "1000", ",", "1000", ",", "1000", ",", 
           "1000", ",", "1000", ",", "1000", ",", "1000", ",", "1000", ",", 
           "1000", ",", "1000", ",", "1000", ",", "1000", ",", "1000", ",", 
           "1000", ",", "1000", ",", "1000", ",", "1000", ",", "1000", ",", 
           "1000", ",", "1000", ",", "1000", ",", "1000", ",", "1000", ",", 
           "1000", ",", "1000", ",", "1000", ",", "1000", ",", "1000", ",", 
           "1000", ",", "1000", ",", "1000", ",", "1000", ",", "1000", ",", 
           "1000", ",", "1000", ",", "1000", ",", "1000", ",", "1000", ",", 
           "1000", ",", "1000", ",", "1000", ",", "1000", ",", "1000", ",", 
           "1000", ",", "1000", ",", "1000", ",", "1000", ",", "1000", ",", 
           "1000", ",", "1000", ",", "1000", ",", "1000", ",", "1000", ",", 
           "1000", ",", "1000", ",", "1000", ",", "1000", ",", "1000", ",", 
           "1000", ",", "1000", ",", "1000", ",", "1000"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
          "750", ",", "750", ",", "750", ",", "750", ",", "750", ",", "750", ",",
            "750", ",", "750", ",", "750", ",", "750", ",", "750", ",", "750",
            ",", "750", ",", "750", ",", "750", ",", "750", ",", "750", ",", 
           "750", ",", "750", ",", "750", ",", "750", ",", "750", ",", "750", 
           ",", "750", ",", "750", ",", "750", ",", "750", ",", "750", ",", 
           "750", ",", "750", ",", "750", ",", "750", ",", "750", ",", "750", 
           ",", "750", ",", "750", ",", "750", ",", "750", ",", "750", ",", 
           "750", ",", "750", ",", "750", ",", "750", ",", "750", ",", "750", 
           ",", "750", ",", "750", ",", "750", ",", "750", ",", "750", ",", 
           "750", ",", "750", ",", "750", ",", "750", ",", "750", ",", "750", 
           ",", "750", ",", "750", ",", "750", ",", "750", ",", "750", ",", 
           "750", ",", "750", ",", "750"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
          "2.5", ",", "2.5", ",", "2.5", ",", "2.5", ",", "2.5", ",", "2.5", ",",
            "2.5", ",", "2.5", ",", "2.5", ",", "2.5", ",", "2.5", ",", "2.5",
            ",", "2.5", ",", "2.5", ",", "2.5", ",", "2.5", ",", "2.5", ",", 
           "2.5", ",", "2.5", ",", "2.5", ",", "2.5", ",", "2.5", ",", "2.5", 
           ",", "2.5", ",", "2.5", ",", "2.5", ",", "2.5", ",", "2.5", ",", 
           "2.5", ",", "2.5", ",", "2.5", ",", "2.5", ",", "2.5", ",", "2.5", 
           ",", "2.5", ",", "2.5", ",", "2.5", ",", "2.5", ",", "2.5", ",", 
           "2.5", ",", "2.5", ",", "2.5", ",", "2.5", ",", "2.5", ",", "2.5", 
           ",", "2.5", ",", "2.5", ",", "2.5", ",", "2.5", ",", "2.5", ",", 
           "2.5", ",", "2.5", ",", "2.5", ",", "2.5", ",", "2.5", ",", "2.5", 
           ",", "2.5", ",", "2.5", ",", "2.5", ",", "2.5", ",", "2.5", ",", 
           "2.5", ",", "2.5", ",", "2.5"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
          "3.2", ",", "3.2", ",", "3.2", ",", "3.2", ",", "3.2", ",", "3.2", ",",
            "3.2", ",", "3.2", ",", "3.2", ",", "3.2", ",", "3.2", ",", "3.2",
            ",", "3.2", ",", "3.2", ",", "3.2", ",", "3.2", ",", "3.2", ",", 
           "3.2", ",", "3.2", ",", "3.2", ",", "3.2", ",", "3.2", ",", "3.2", 
           ",", "3.2", ",", "3.2", ",", "3.2", ",", "3.2", ",", "3.2", ",", 
           "3.2", ",", "3.2", ",", "3.2", ",", "3.2", ",", "3.2", ",", "3.2", 
           ",", "3.2", ",", "3.2", ",", "3.2", ",", "3.2", ",", "3.2", ",", 
           "3.2", ",", "3.2", ",", "3.2", ",", "3.2", ",", "3.2", ",", "3.2", 
           ",", "3.2", ",", "3.2", ",", "3.2", ",", "3.2", ",", "3.2", ",", 
           "3.2", ",", "3.2", ",", "3.2", ",", "3.2", ",", "3.2", ",", "3.2", 
           ",", "3.2", ",", "3.2", ",", "3.2", ",", "3.2", ",", "3.2", ",", 
           "3.2", ",", "3.2", ",", "3.2"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.72057"}], ",", 
           RowBox[{"-", "0.41997"}], ",", 
           RowBox[{"-", "0.41729"}], ",", 
           RowBox[{"-", "0.39998"}], ",", 
           RowBox[{"-", "0.34799"}], ",", 
           RowBox[{"-", "0.27572"}], ",", 
           RowBox[{"-", "0.21231"}], ",", 
           RowBox[{"-", "0.14427"}], ",", 
           RowBox[{"-", "0.27064"}], ",", 
           RowBox[{"-", "0.31025"}], ",", 
           RowBox[{"-", "0.34796"}], ",", 
           RowBox[{"-", "0.39668"}], ",", 
           RowBox[{"-", "0.43996"}], ",", 
           RowBox[{"-", "0.48313"}], ",", 
           RowBox[{"-", "0.52431"}], ",", 
           RowBox[{"-", "0.5568"}], ",", 
           RowBox[{"-", "0.58922"}], ",", 
           RowBox[{"-", "0.62635"}], ",", 
           RowBox[{"-", "0.65315"}], ",", 
           RowBox[{"-", "0.68711"}], ",", 
           RowBox[{"-", "0.72744"}], ",", 
           RowBox[{"-", "0.77335"}], ",", 
           RowBox[{"-", "0.80508"}], ",", 
           RowBox[{"-", "0.82609"}], ",", 
           RowBox[{"-", "0.8408"}], ",", 
           RowBox[{"-", "0.86251"}], ",", 
           RowBox[{"-", "0.87479"}], ",", 
           RowBox[{"-", "0.88522"}], ",", 
           RowBox[{"-", "0.89517"}], ",", 
           RowBox[{"-", "0.90875"}], ",", 
           RowBox[{"-", "0.91922"}], ",", 
           RowBox[{"-", "0.9267"}], ",", 
           RowBox[{"-", "0.9372"}], ",", 
           RowBox[{"-", "0.94614"}], ",", 
           RowBox[{"-", "0.96564"}], ",", 
           RowBox[{"-", "0.98499"}], ",", 
           RowBox[{"-", "0.99733"}], ",", 
           RowBox[{"-", "1.00469"}], ",", 
           RowBox[{"-", "1.00786"}], ",", 
           RowBox[{"-", "1.00606"}], ",", 
           RowBox[{"-", "1.01093"}], ",", 
           RowBox[{"-", "1.01576"}], ",", 
           RowBox[{"-", "1.01353"}], ",", 
           RowBox[{"-", "1.01331"}], ",", 
           RowBox[{"-", "1.0124"}], ",", 
           RowBox[{"-", "1.00489"}], ",", 
           RowBox[{"-", "0.98876"}], ",", 
           RowBox[{"-", "0.9776"}], ",", 
           RowBox[{"-", "0.98071"}], ",", 
           RowBox[{"-", "0.96369"}], ",", 
           RowBox[{"-", "0.94634"}], ",", 
           RowBox[{"-", "0.93606"}], ",", 
           RowBox[{"-", "0.91408"}], ",", 
           RowBox[{"-", "0.91007"}], ",", 
           RowBox[{"-", "0.89376"}], ",", 
           RowBox[{"-", "0.87052"}], ",", 
           RowBox[{"-", "0.85889"}], ",", 
           RowBox[{"-", "0.86106"}], ",", 
           RowBox[{"-", "0.85793"}], ",", 
           RowBox[{"-", "0.82094"}], ",", 
           RowBox[{"-", "0.84449"}], ",", 
           RowBox[{"-", "0.83216"}], ",", 
           RowBox[{"-", "0.79216"}], ",", 
           RowBox[{"-", "0.75645"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.19688"}], ",", 
           RowBox[{"-", "0.28846"}], ",", 
           RowBox[{"-", "0.28685"}], ",", 
           RowBox[{"-", "0.28241"}], ",", 
           RowBox[{"-", "0.26842"}], ",", 
           RowBox[{"-", "0.24759"}], ",", 
           RowBox[{"-", "0.22385"}], ",", 
           RowBox[{"-", "0.17525"}], ",", 
           RowBox[{"-", "0.29293"}], ",", 
           RowBox[{"-", "0.31837"}], ",", 
           RowBox[{"-", "0.3386"}], ",", 
           RowBox[{"-", "0.36646"}], ",", 
           RowBox[{"-", "0.38417"}], ",", 
           RowBox[{"-", "0.39551"}], ",", 
           RowBox[{"-", "0.40869"}], ",", 
           RowBox[{"-", "0.41528"}], ",", 
           RowBox[{"-", "0.42717"}], ",", 
           RowBox[{"-", "0.4413"}], ",", 
           RowBox[{"-", "0.44644"}], ",", 
           RowBox[{"-", "0.44872"}], ",", 
           RowBox[{"-", "0.46341"}], ",", 
           RowBox[{"-", "0.48705"}], ",", 
           RowBox[{"-", "0.47334"}], ",", 
           RowBox[{"-", "0.4573"}], ",", 
           RowBox[{"-", "0.44267"}], ",", 
           RowBox[{"-", "0.43888"}], ",", 
           RowBox[{"-", "0.4382"}], ",", 
           RowBox[{"-", "0.43678"}], ",", 
           RowBox[{"-", "0.43008"}], ",", 
           RowBox[{"-", "0.4219"}], ",", 
           RowBox[{"-", "0.40903"}], ",", 
           RowBox[{"-", "0.39442"}], ",", 
           RowBox[{"-", "0.38462"}], ",", 
           RowBox[{"-", "0.37408"}], ",", 
           RowBox[{"-", "0.35582"}], ",", 
           RowBox[{"-", "0.34053"}], ",", 
           RowBox[{"-", "0.30949"}], ",", 
           RowBox[{"-", "0.28772"}], ",", 
           RowBox[{"-", "0.28957"}], ",", 
           RowBox[{"-", "0.28555"}], ",", 
           RowBox[{"-", "0.28364"}], ",", 
           RowBox[{"-", "0.28037"}], ",", 
           RowBox[{"-", "0.2839"}], ",", 
           RowBox[{"-", "0.28702"}], ",", 
           RowBox[{"-", "0.27669"}], ",", 
           RowBox[{"-", "0.27538"}], ",", 
           RowBox[{"-", "0.25008"}], ",", 
           RowBox[{"-", "0.23508"}], ",", 
           RowBox[{"-", "0.24695"}], ",", 
           RowBox[{"-", "0.2287"}], ",", 
           RowBox[{"-", "0.21655"}], ",", 
           RowBox[{"-", "0.20302"}], ",", 
           RowBox[{"-", "0.18228"}], ",", 
           RowBox[{"-", "0.17336"}], ",", 
           RowBox[{"-", "0.15463"}], ",", 
           RowBox[{"-", "0.13181"}], ",", 
           RowBox[{"-", "0.14066"}], ",", 
           RowBox[{"-", "0.13882"}], ",", 
           RowBox[{"-", "0.13336"}], ",", 
           RowBox[{"-", "0.1377"}], ",", 
           RowBox[{"-", "0.15337"}], ",", 
           RowBox[{"-", "0.10884"}], ",", 
           RowBox[{"-", "0.08884"}], ",", 
           RowBox[{"-", "0.07749"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
          "0.6014", ",", "0.6201", ",", "0.6215", ",", "0.6266", ",", "0.641",
            ",", "0.6534", ",", "0.6622", ",", "0.6626", ",", "0.667", ",", 
           "0.6712", ",", "0.6768", ",", "0.6789", ",", "0.6822", ",", 
           "0.6796", ",", "0.6762", ",", "0.6723", ",", "0.6694", ",", 
           "0.6647", ",", "0.6645", ",", "0.66", ",", "0.6651", ",", "0.665", 
           ",", "0.659", ",", "0.6599", ",", "0.6654", ",", "0.6651", ",", 
           "0.6662", ",", "0.6698", ",", "0.6697", ",", "0.6696", ",", 
           "0.6641", ",", "0.6575", ",", "0.654", ",", "0.6512", ",", "0.657",
            ",", "0.663", ",", "0.6652", ",", "0.6696", ",", "0.6744", ",", 
           "0.6716", ",", "0.6713", ",", "0.6738", ",", "0.6767", ",", 
           "0.6787", ",", "0.6912", ",", "0.7015", ",", "0.7017", ",", 
           "0.7141", ",", "0.7164", ",", "0.7198", ",", "0.7226", ",", 
           "0.7241", ",", "0.7266", ",", "0.7254", ",", "0.7207", ",", 
           "0.7144", ",", "0.7122", ",", "0.7129", ",", "0.6997", ",", 
           "0.682", ",", "0.6682", ",", "0.6508", ",", "0.6389", ",", 
           "0.6196"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
          "0.3311", ",", "0.3501", ",", "0.3526", ",", "0.3555", ",", 
           "0.3565", ",", "0.3484", ",", "0.3551", ",", "0.3759", ",", 
           "0.4067", ",", "0.4059", ",", "0.4022", ",", "0.4017", ",", 
           "0.3945", ",", "0.3893", ",", "0.3928", ",", "0.396", ",", "0.396",
            ",", "0.3932", ",", "0.3842", ",", "0.3887", ",", "0.3792", ",", 
           "0.3754", ",", "0.3757", ",", "0.3816", ",", "0.3866", ",", 
           "0.3881", ",", "0.3924", ",", "0.3945", ",", "0.3962", ",", 
           "0.389", ",", "0.3929", ",", "0.4009", ",", "0.4022", ",", 
           "0.4021", ",", "0.4057", ",", "0.406", ",", "0.4124", ",", 
           "0.4135", ",", "0.4043", ",", "0.3974", ",", "0.3971", ",", 
           "0.3986", ",", "0.3949", ",", "0.3943", ",", "0.3806", ",", 
           "0.3802", ",", "0.3803", ",", "0.3766", ",", "0.3799", ",", 
           "0.3817", ",", "0.3724", ",", "0.371", ",", "0.3745", ",", 
           "0.3717", ",", "0.3758", ",", "0.3973", ",", "0.4001", ",", 
           "0.4025", ",", "0.4046", ",", "0.4194", ",", "0.3971", ",", 
           "0.4211", ",", "0.415", ",", "0.3566"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
          "0.6865", ",", "0.7121", ",", "0.7146", ",", "0.7204", ",", 
           "0.7335", ",", "0.7405", ",", "0.7514", ",", "0.7618", ",", 
           "0.7812", ",", "0.7844", ",", "0.7873", ",", "0.7888", ",", 
           "0.7881", ",", "0.7832", ",", "0.782", ",", "0.7803", ",", 
           "0.7778", ",", "0.7723", ",", "0.7676", ",", "0.766", ",", 
           "0.7656", ",", "0.7636", ",", "0.7586", ",", "0.7623", ",", 
           "0.7696", ",", "0.7701", ",", "0.7732", ",", "0.7773", ",", 
           "0.7781", ",", "0.7744", ",", "0.7716", ",", "0.7701", ",", 
           "0.7678", ",", "0.7653", ",", "0.7722", ",", "0.7774", ",", 
           "0.7827", ",", "0.787", ",", "0.7863", ",", "0.7804", ",", "0.78", 
           ",", "0.7829", ",", "0.7835", ",", "0.7849", ",", "0.7891", ",", 
           "0.7979", ",", "0.7981", ",", "0.8073", ",", "0.8109", ",", 
           "0.8147", ",", "0.8129", ",", "0.8136", ",", "0.8174", ",", 
           "0.8151", ",", "0.8128", ",", "0.8174", ",", "0.8169", ",", 
           "0.8187", ",", "0.8083", ",", "0.8006", ",", "0.7773", ",", 
           "0.7752", ",", "0.7619", ",", "0.7149"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
          "1041", ",", "1041", ",", "1041", ",", "1041", ",", "1041", ",", 
           "1041", ",", "1041", ",", "1041", ",", "1041", ",", "1041", ",", 
           "1041", ",", "1041", ",", "1041", ",", "1041", ",", "1041", ",", 
           "1041", ",", "1041", ",", "1041", ",", "1041", ",", "1041", ",", 
           "1041", ",", "1041", ",", "1041", ",", "1041", ",", "1041", ",", 
           "1041", ",", "1041", ",", "1041", ",", "1041", ",", "1041", ",", 
           "1041", ",", "1041", ",", "1041", ",", "1041", ",", "1041", ",", 
           "1040", ",", "1038", ",", "1037", ",", "1032", ",", "1028", ",", 
           "1028", ",", "1024", ",", "1023", ",", "1023", ",", "1020", ",", 
           "1008", ",", "1006", ",", "1004", ",", "990", ",", "983", ",", 
           "978", ",", "960", ",", "953", ",", "953", ",", "948", ",", "914", 
           ",", "900", ",", "892", ",", "858", ",", "817", ",", "785", ",", 
           "722", ",", "690", ",", "659"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
          "221", ",", "221", ",", "221", ",", "221", ",", "221", ",", "221", ",",
            "221", ",", "221", ",", "221", ",", "221", ",", "221", ",", "221",
            ",", "221", ",", "221", ",", "221", ",", "221", ",", "221", ",", 
           "221", ",", "221", ",", "221", ",", "221", ",", "221", ",", "221", 
           ",", "221", ",", "221", ",", "221", ",", "221", ",", "221", ",", 
           "221", ",", "221", ",", "221", ",", "221", ",", "221", ",", "221", 
           ",", "221", ",", "221", ",", "221", ",", "221", ",", "221", ",", 
           "220", ",", "220", ",", "220", ",", "220", ",", "220", ",", "220", 
           ",", "217", ",", "217", ",", "217", ",", "215", ",", "214", ",", 
           "213", ",", "209", ",", "209", ",", "209", ",", "209", ",", "199", 
           ",", "198", ",", "197", ",", "195", ",", "188", ",", "183", ",", 
           "170", ",", "166", ",", "160"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
          "322", ",", "322", ",", "322", ",", "322", ",", "322", ",", "322", ",",
            "322", ",", "322", ",", "322", ",", "322", ",", "322", ",", "322",
            ",", "322", ",", "322", ",", "322", ",", "322", ",", "322", ",", 
           "322", ",", "322", ",", "322", ",", "322", ",", "322", ",", "322", 
           ",", "322", ",", "322", ",", "322", ",", "322", ",", "322", ",", 
           "322", ",", "322", ",", "322", ",", "322", ",", "322", ",", "322", 
           ",", "322", ",", "322", ",", "321", ",", "321", ",", "321", ",", 
           "321", ",", "321", ",", "320", ",", "319", ",", "319", ",", "319", 
           ",", "317", ",", "316", ",", "315", ",", "312", ",", "308", ",", 
           "307", ",", "302", ",", "300", ",", "300", ",", "299", ",", "292", 
           ",", "291", ",", "287", ",", "278", ",", "275", ",", "269", ",", 
           "248", ",", "242", ",", "238"}], "}"}]}], "}"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"SetOptions", "[", 
       RowBox[{"InterpolateCoefficientList", ",", 
        RowBox[{"IpolHalfWindowLength", "->", "ilenALL"}], ",", 
        RowBox[{"IpolOrder", "->", "ipolorderALL"}], ",", 
        RowBox[{"IpolType", "->", "ipolTypeAll"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{"SetOptions", "[", 
         RowBox[{"InterpolateCoefficientList", ",", 
          RowBox[{"IpolHalfWindowLength", "->", "ilenALL"}], ",", 
          RowBox[{"IpolOrder", "->", "ipolorderALL"}], ",", 
          RowBox[{"IpolType", "->", "ipolTypeAll"}]}], "]"}], ";"}], "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"Which", "[", 
       RowBox[{
        RowBox[{"per", "<", 
         RowBox[{"periodlist", "[", 
          RowBox[{"[", "2", "]"}], "]"}]}], ",", 
        RowBox[{"(*", "PGV", "*)"}], 
        RowBox[{
         RowBox[{"a1", "=", 
          RowBox[{"a1list", "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"a2", "=", 
          RowBox[{"a2list", "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"a3", "=", 
          RowBox[{"a3list", "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"a4", "=", 
          RowBox[{"a4list", "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"a5", "=", 
          RowBox[{"a5list", "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"a6", "=", 
          RowBox[{"a6list", "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"a7", "=", 
          RowBox[{"a7list", "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"a8", "=", 
          RowBox[{"a8list", "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"a9", "=", 
          RowBox[{"a9list", "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"c1", "=", 
          RowBox[{"c1list", "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"vcon", "=", 
          RowBox[{"vconlist", "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"vref", "=", 
          RowBox[{"vreflist", "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"c", "=", 
          RowBox[{"clist", "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"n", "=", 
          RowBox[{"nlist", "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"b1", "=", 
          RowBox[{"b1list", "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"b2", "=", 
          RowBox[{"b2list", "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"sd1", "=", 
          RowBox[{"sd1list", "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"sd2", "=", 
          RowBox[{"sd2list", "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"sd", "=", 
          RowBox[{"sdlist", "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"nrec", "=", 
          RowBox[{"nreclist", "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"neq", "=", 
          RowBox[{"neqlist", "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"nst", "=", 
          RowBox[{"nstlist", "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], ";"}], ",", 
        RowBox[{"0.", "<=", "per", "<", 
         RowBox[{"periodlist", "[", 
          RowBox[{"[", "3", "]"}], "]"}]}], ",", 
        RowBox[{"(*", "PGA", "*)"}], 
        RowBox[{
         RowBox[{"a1", "=", 
          RowBox[{"a1list", "[", 
           RowBox[{"[", "2", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"a2", "=", 
          RowBox[{"a2list", "[", 
           RowBox[{"[", "2", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"a3", "=", 
          RowBox[{"a3list", "[", 
           RowBox[{"[", "2", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"a4", "=", 
          RowBox[{"a4list", "[", 
           RowBox[{"[", "2", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"a5", "=", 
          RowBox[{"a5list", "[", 
           RowBox[{"[", "2", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"a6", "=", 
          RowBox[{"a6list", "[", 
           RowBox[{"[", "2", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"a7", "=", 
          RowBox[{"a7list", "[", 
           RowBox[{"[", "2", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"a8", "=", 
          RowBox[{"a8list", "[", 
           RowBox[{"[", "2", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"a9", "=", 
          RowBox[{"a9list", "[", 
           RowBox[{"[", "2", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"c1", "=", 
          RowBox[{"c1list", "[", 
           RowBox[{"[", "2", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"vcon", "=", 
          RowBox[{"vconlist", "[", 
           RowBox[{"[", "2", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"vref", "=", 
          RowBox[{"vreflist", "[", 
           RowBox[{"[", "2", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"c", "=", 
          RowBox[{"clist", "[", 
           RowBox[{"[", "2", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"n", "=", 
          RowBox[{"nlist", "[", 
           RowBox[{"[", "2", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"b1", "=", 
          RowBox[{"b1list", "[", 
           RowBox[{"[", "2", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"b2", "=", 
          RowBox[{"b2list", "[", 
           RowBox[{"[", "2", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"sd1", "=", 
          RowBox[{"sd1list", "[", 
           RowBox[{"[", "2", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"sd2", "=", 
          RowBox[{"sd2list", "[", 
           RowBox[{"[", "2", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"sd", "=", 
          RowBox[{"sdlist", "[", 
           RowBox[{"[", "2", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"nrec", "=", 
          RowBox[{"nreclist", "[", 
           RowBox[{"[", "2", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"neq", "=", 
          RowBox[{"neqlist", "[", 
           RowBox[{"[", "2", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"nst", "=", 
          RowBox[{"nstlist", "[", 
           RowBox[{"[", "2", "]"}], "]"}]}], ";"}], ",", 
        RowBox[{
         RowBox[{"periodlist", "[", 
          RowBox[{"[", "3", "]"}], "]"}], "<=", "per"}], ",", 
        RowBox[{"(*", "PSA", "*)"}], 
        RowBox[{
         RowBox[{"a1", "=", 
          RowBox[{"InterpolateCoefficientList", "[", 
           RowBox[{"per", ",", "periodlist", ",", "a1list"}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"a2", "=", 
          RowBox[{"InterpolateCoefficientList", "[", 
           RowBox[{"per", ",", "periodlist", ",", "a2list"}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"a3", "=", 
          RowBox[{"InterpolateCoefficientList", "[", 
           RowBox[{"per", ",", "periodlist", ",", "a3list"}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"a4", "=", 
          RowBox[{"InterpolateCoefficientList", "[", 
           RowBox[{"per", ",", "periodlist", ",", "a4list"}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"a5", "=", 
          RowBox[{"InterpolateCoefficientList", "[", 
           RowBox[{"per", ",", "periodlist", ",", "a5list"}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"a6", "=", 
          RowBox[{"InterpolateCoefficientList", "[", 
           RowBox[{"per", ",", "periodlist", ",", "a6list"}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"a7", "=", 
          RowBox[{"InterpolateCoefficientList", "[", 
           RowBox[{"per", ",", "periodlist", ",", "a7list"}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"a8", "=", 
          RowBox[{"InterpolateCoefficientList", "[", 
           RowBox[{"per", ",", "periodlist", ",", "a8list"}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"a9", "=", 
          RowBox[{"InterpolateCoefficientList", "[", 
           RowBox[{"per", ",", "periodlist", ",", "a9list"}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"c1", "=", 
          RowBox[{"InterpolateCoefficientList", "[", 
           RowBox[{"per", ",", "periodlist", ",", "c1list"}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"vcon", "=", 
          RowBox[{"InterpolateCoefficientList", "[", 
           RowBox[{"per", ",", "periodlist", ",", "vconlist"}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"vref", "=", 
          RowBox[{"InterpolateCoefficientList", "[", 
           RowBox[{"per", ",", "periodlist", ",", "vreflist"}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"c", "=", 
          RowBox[{"InterpolateCoefficientList", "[", 
           RowBox[{"per", ",", "periodlist", ",", "clist"}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"n", "=", 
          RowBox[{"InterpolateCoefficientList", "[", 
           RowBox[{"per", ",", "periodlist", ",", "nlist"}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"b1", "=", 
          RowBox[{"InterpolateCoefficientList", "[", 
           RowBox[{"per", ",", "periodlist", ",", "b1list"}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"b2", "=", 
          RowBox[{"InterpolateCoefficientList", "[", 
           RowBox[{"per", ",", "periodlist", ",", "b2list"}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"sd1", "=", 
          RowBox[{"InterpolateCoefficientList", "[", 
           RowBox[{"per", ",", "periodlist", ",", "sd1list"}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"sd2", "=", 
          RowBox[{"InterpolateCoefficientList", "[", 
           RowBox[{"per", ",", "periodlist", ",", "sd2list"}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"sd", "=", 
          RowBox[{"InterpolateCoefficientList", "[", 
           RowBox[{"per", ",", "periodlist", ",", "sdlist"}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"nrec", "=", 
          RowBox[{"InterpolateCoefficientList", "[", 
           RowBox[{"per", ",", "periodlist", ",", "nreclist"}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"neq", "=", 
          RowBox[{"InterpolateCoefficientList", "[", 
           RowBox[{"per", ",", "periodlist", ",", "neqlist"}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"nst", "=", 
          RowBox[{"InterpolateCoefficientList", "[", 
           RowBox[{"per", ",", "periodlist", ",", "nstlist"}], "]"}]}], 
         ";"}]}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"Which", "[", 
       RowBox[{
        RowBox[{"faulttypeinp", "==", "\"\<NORMAL\>\""}], ",", 
        RowBox[{
         RowBox[{"fn", "=", "1."}], ";", "\[IndentingNewLine]", 
         RowBox[{"fr", "=", "0."}], ";"}], ",", 
        RowBox[{"faulttypeinp", "==", "\"\<STRIKE SLIP\>\""}], ",", 
        RowBox[{
         RowBox[{"fn", "=", "0."}], ";", "\[IndentingNewLine]", 
         RowBox[{"fr", "=", "0."}], ";"}], ",", 
        RowBox[{"faulttypeinp", "==", "\"\<REVERSE\>\""}], ",", 
        RowBox[{
         RowBox[{"fn", "=", "0."}], ";", "\[IndentingNewLine]", 
         RowBox[{"fr", "=", "1."}], ";"}], ",", "True", ",", 
        RowBox[{
         RowBox[{"Message", "[", 
          RowBox[{
           RowBox[{"EmpiricalEquation", "::", "option"}], ",", "faulttypeinp",
            ",", "FaultTypeNSSR"}], "]"}], ";", "\[IndentingNewLine]", 
         RowBox[{"Return", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "999."}], ",", 
            RowBox[{"-", "999."}], ",", 
            RowBox[{"-", "999."}], ",", 
            RowBox[{"-", "999."}]}], "}"}], "]"}], ";"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{"Print", "[", 
         RowBox[{"\"\<fn, fr: \>\"", ",", 
          RowBox[{"{", 
           RowBox[{"fn", ",", "fr"}], "}"}]}], "]"}], ";"}], "*)"}], 
      RowBox[{"(*", 
       RowBox[{"*", "PGA", " ", "ref"}], "**)"}], 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"mw", "<=", "c1"}], ",", 
        RowBox[{
         RowBox[{"lnPGAref", "=", 
          RowBox[{
           RowBox[{"a1list", "[", 
            RowBox[{"[", "2", "]"}], "]"}], "+", 
           RowBox[{
            RowBox[{"a2list", "[", 
             RowBox[{"[", "2", "]"}], "]"}], " ", 
            RowBox[{"(", 
             RowBox[{"mw", "-", 
              RowBox[{"c1list", "[", 
               RowBox[{"[", "2", "]"}], "]"}]}], ")"}]}], "+", 
           RowBox[{
            RowBox[{"a3list", "[", 
             RowBox[{"[", "2", "]"}], "]"}], " ", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"8.5", "-", "mw"}], ")"}], "^", "2"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"a4list", "[", 
               RowBox[{"[", "2", "]"}], "]"}], "+", 
              RowBox[{
               RowBox[{"a5list", "[", 
                RowBox[{"[", "2", "]"}], "]"}], " ", 
               RowBox[{"(", 
                RowBox[{"mw", "-", 
                 RowBox[{"c1list", "[", 
                  RowBox[{"[", "2", "]"}], "]"}]}], ")"}]}]}], ")"}], " ", 
            RowBox[{"Log", "[", 
             RowBox[{"Sqrt", "[", 
              RowBox[{
               RowBox[{"rdist", "^", "2"}], "+", 
               RowBox[{
                RowBox[{"a6list", "[", 
                 RowBox[{"[", "2", "]"}], "]"}], "^", "2"}]}], "]"}], "]"}]}],
            "+", 
           RowBox[{
            RowBox[{"a8list", "[", 
             RowBox[{"[", "2", "]"}], "]"}], " ", "fn"}], "+", 
           RowBox[{
            RowBox[{"a9list", "[", 
             RowBox[{"[", "2", "]"}], "]"}], " ", "fr"}]}]}], ";"}], ",", 
        RowBox[{"(*", 
         RowBox[{
          RowBox[{"else", " ", "mw"}], ">", "c1"}], "*)"}], 
        RowBox[{
         RowBox[{"lnPGAref", "=", 
          RowBox[{
           RowBox[{"a1list", "[", 
            RowBox[{"[", "2", "]"}], "]"}], "+", 
           RowBox[{
            RowBox[{"a7list", "[", 
             RowBox[{"[", "2", "]"}], "]"}], " ", 
            RowBox[{"(", 
             RowBox[{"mw", "-", 
              RowBox[{"c1list", "[", 
               RowBox[{"[", "2", "]"}], "]"}]}], ")"}]}], "+", 
           RowBox[{
            RowBox[{"a3list", "[", 
             RowBox[{"[", "2", "]"}], "]"}], " ", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"8.5", "-", "mw"}], ")"}], "^", "2"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"a4list", "[", 
               RowBox[{"[", "2", "]"}], "]"}], "+", 
              RowBox[{
               RowBox[{"a5list", "[", 
                RowBox[{"[", "2", "]"}], "]"}], " ", 
               RowBox[{"(", 
                RowBox[{"mw", "-", 
                 RowBox[{"c1list", "[", 
                  RowBox[{"[", "2", "]"}], "]"}]}], ")"}]}]}], ")"}], " ", 
            RowBox[{"Log", "[", 
             RowBox[{"Sqrt", "[", 
              RowBox[{
               RowBox[{"rdist", "^", "2"}], "+", 
               RowBox[{
                RowBox[{"a6list", "[", 
                 RowBox[{"[", "2", "]"}], "]"}], "^", "2"}]}], "]"}], "]"}]}],
            "+", 
           RowBox[{
            RowBox[{"a8list", "[", 
             RowBox[{"[", "2", "]"}], "]"}], " ", "fn"}], "+", 
           RowBox[{
            RowBox[{"a9list", "[", 
             RowBox[{"[", "2", "]"}], "]"}], " ", "fr"}]}]}], ";"}]}], "]"}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{"Print", "[", 
         RowBox[{"\"\<PGAref: \>\"", ",", 
          RowBox[{"Exp", "[", "lnPGAref", "]"}]}], "]"}], ";"}], "*)"}], 
      RowBox[{"(*", 
       RowBox[{"*", "site", " ", "amplification"}], "**)"}], 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"vs30", "<=", "vref"}], ",", 
        RowBox[{
         RowBox[{"lns", "=", 
          RowBox[{
           RowBox[{"b1", " ", 
            RowBox[{"Log", "[", 
             RowBox[{"vs30", "/", "vref"}], "]"}]}], "+", 
           RowBox[{"b2", " ", 
            RowBox[{"Log", "[", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"Exp", "[", "lnPGAref", "]"}], "+", 
                RowBox[{"c", " ", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"vs30", "/", "vref"}], ")"}], "^", "n"}]}]}], 
               ")"}], "/", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"Exp", "[", "lnPGAref", "]"}], "+", "c"}], ")"}], 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"vs30", "/", "vref"}], ")"}], "^", "n"}]}], ")"}]}],
              "]"}]}]}]}], ";"}], ",", 
        RowBox[{
         RowBox[{"lns", "=", 
          RowBox[{"b1", " ", 
           RowBox[{"Log", "[", 
            RowBox[{
             RowBox[{"Min", "[", 
              RowBox[{"vs30", ",", "vcon"}], "]"}], "/", "vref"}], "]"}]}]}], 
         ";"}]}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"(*", 
       RowBox[{"*", "lnY"}], "**)"}], 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"mw", "<=", "c1"}], ",", 
        RowBox[{
         RowBox[{"lnrefy", "=", 
          RowBox[{"a1", "+", 
           RowBox[{"a2", "*", 
            RowBox[{"(", 
             RowBox[{"mw", "-", "c1"}], ")"}]}], "+", 
           RowBox[{"a3", "*", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"8.5", "-", "mw"}], ")"}], "^", "2"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"a4", "+", 
              RowBox[{"a5", "*", 
               RowBox[{"(", 
                RowBox[{"mw", "-", "c1"}], ")"}]}]}], ")"}], " ", 
            RowBox[{"Log", "[", 
             RowBox[{"Sqrt", "[", 
              RowBox[{
               RowBox[{"rdist", "^", "2"}], "+", 
               RowBox[{"a6", "^", "2"}]}], "]"}], "]"}]}], "+", 
           RowBox[{"a8", " ", "fn"}], "+", 
           RowBox[{"a9", " ", "fr"}]}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"(*", 
          RowBox[{
          "partials", " ", "copied", " ", "over", " ", "from", " ", "Akkar", " ",
            "and", " ", "Cagna", " ", "model", " ", "and", " ", "modified", " ",
            "coeffiecients"}], "*)"}], 
         RowBox[{"pddist", "=", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"a4", "+", 
               RowBox[{"a5", "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "c1"}], "+", "mw"}], ")"}]}]}], ")"}], "*", 
             "rdist"}], ")"}], "/", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"a6", "^", "2"}], "+", 
             RowBox[{"rdist", "^", "2"}]}], ")"}]}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"pdmag", "=", 
          RowBox[{"a2", "-", 
           RowBox[{"2", "*", "a3", "*", 
            RowBox[{"(", 
             RowBox[{"8.5", "-", "mw"}], ")"}]}], "+", 
           RowBox[{"a5", "*", 
            RowBox[{"Log", "[", 
             RowBox[{"Sqrt", "[", 
              RowBox[{
               RowBox[{"a6", "^", "2"}], "+", 
               RowBox[{"rdist", "^", "2"}]}], "]"}], "]"}]}]}]}], ";"}], ",", 
        
        RowBox[{"(*", 
         RowBox[{
          RowBox[{"else", " ", "mw"}], ">", "c1"}], "*)"}], 
        RowBox[{
         RowBox[{"lnrefy", "=", 
          RowBox[{"a1", "+", 
           RowBox[{"a7", "*", 
            RowBox[{"(", 
             RowBox[{"mw", "-", "c1"}], ")"}]}], "+", 
           RowBox[{"a3", "*", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"8.5", "-", "mw"}], ")"}], "^", "2"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"a4", "+", 
              RowBox[{"a5", "*", 
               RowBox[{"(", 
                RowBox[{"mw", "-", "c1"}], ")"}]}]}], ")"}], " ", 
            RowBox[{"Log", "[", 
             RowBox[{"Sqrt", "[", 
              RowBox[{
               RowBox[{"rdist", "^", "2"}], "+", 
               RowBox[{"a6", "^", "2"}]}], "]"}], "]"}]}], "+", 
           RowBox[{"a8", " ", "fn"}], "+", 
           RowBox[{"a9", " ", "fr"}]}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"pddist", "=", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"a4", "+", 
               RowBox[{"a5", "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "c1"}], "+", "mw"}], ")"}]}]}], ")"}], "*", 
             "rdist"}], ")"}], "/", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"a6", "^", "2"}], "+", 
             RowBox[{"rdist", "^", "2"}]}], ")"}]}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"pdmag", "=", 
          RowBox[{"a7", "-", 
           RowBox[{"2", "*", "a3", "*", 
            RowBox[{"(", 
             RowBox[{"8.5", "-", "mw"}], ")"}]}], "+", 
           RowBox[{"a5", "*", 
            RowBox[{"Log", "[", 
             RowBox[{"Sqrt", "[", 
              RowBox[{
               RowBox[{"a6", "^", "2"}], "+", 
               RowBox[{"rdist", "^", "2"}]}], "]"}], "]"}]}]}]}]}]}], "]"}], ";",
       "\[IndentingNewLine]", 
      RowBox[{"Which", "[", 
       RowBox[{
        RowBox[{"per", "<", 
         RowBox[{"periodlist", "[", 
          RowBox[{"[", "2", "]"}], "]"}]}], ",", 
        RowBox[{"(*", "PGV", "*)"}], 
        RowBox[{"(*", 
         RowBox[{"PGV", " ", "in", " ", 
          RowBox[{"m", "/", "s"}]}], "*)"}], 
        RowBox[{
         RowBox[{"saval", "=", 
          RowBox[{".01", " ", 
           RowBox[{"Exp", "[", 
            RowBox[{"lnrefy", "+", "lns"}], "]"}]}]}], ";"}], ",", 
        RowBox[{"0.", "<=", "per", "<", 
         RowBox[{"periodlist", "[", 
          RowBox[{"[", "3", "]"}], "]"}]}], ",", 
        RowBox[{"(*", "PGA", "*)"}], 
        RowBox[{"(*", 
         RowBox[{"PGA", " ", "in", " ", 
          RowBox[{"m", "/", "s"}], "*", "s"}], "*)"}], 
        RowBox[{
         RowBox[{"saval", "=", 
          RowBox[{"9.81", "*", 
           RowBox[{"Exp", "[", 
            RowBox[{"lnrefy", "+", "lns"}], "]"}]}]}], ";"}], ",", 
        RowBox[{
         RowBox[{"periodlist", "[", 
          RowBox[{"[", "3", "]"}], "]"}], "<=", "per"}], ",", 
        RowBox[{"(*", "PSA", "*)"}], 
        RowBox[{"(*", 
         RowBox[{"SA", " ", "in", " ", 
          RowBox[{"m", "/", "s"}], "*", "s"}], "*)"}], 
        RowBox[{
         RowBox[{"saval", "=", 
          RowBox[{"9.81", "*", 
           RowBox[{"Exp", "[", 
            RowBox[{"lnrefy", "+", "lns"}], "]"}]}]}], ";"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"sigtotal", "=", "sd"}], ";", "\[IndentingNewLine]", 
      RowBox[{"Return", "[", 
       RowBox[{"{", 
        RowBox[{"saval", ",", "sigtotal", ",", "pddist", ",", "pdmag"}], 
        "}"}], "]"}], ";"}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.952172885290853*^9, 3.952172914000705*^9}, 
   3.952173499051793*^9},
 CellLabel->"In[50]:=",ExpressionUUID->"da4afd98-75ee-4265-886a-d57027dfe149"]
}, Closed]],

Cell[CellGroupData[{

Cell["pgaAkkarEtal2013RepiHor", "Subsubsection",
 CellChangeTimes->{{3.9519747063299017`*^9, 3.951974732209299*^9}, {
   3.9519747670098867`*^9, 3.9519747862578783`*^9}, 
   3.951976656724259*^9},ExpressionUUID->"1c3a7f32-e467-4a82-a987-\
edbe14c09fd8"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**",
      "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", 
     "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**",
      "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", 
     "**"}], "*"}], "*)"}], 
  RowBox[{"(*", 
   RowBox[{
   "Extract", " ", "PGA", " ", "as", " ", "separate", " ", "model", " ", 
    "for", " ", "examples"}], "*)"}], 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Options", "[", "pgaAkkarEtal2013RepiHor", "]"}], "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"MagMW", "->", "6."}], ",", 
       RowBox[{"DistEPI", "->", "10."}], ",", 
       RowBox[{"Vs30", "->", "760."}], ",", 
       RowBox[{"FaultTypeNSSR", "->", "\"\<STRIKE SLIP\>\""}]}], "}"}]}], 
    ";"}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"pgaAkkarEtal2013RepiHor", "[", 
      RowBox[{"opts", ":", 
       RowBox[{"OptionsPattern", "[", "]"}]}], "]"}], ":=", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "mw", ",", "rdist", ",", "vs30", ",", "faulttypeinp", ",", "a1", ",", 
         "a2", ",", "a3", ",", "a4", ",", "a5", ",", "a6", ",", "a7", ",", 
         "a8", ",", "a9", ",", "c1", ",", "vcon", ",", "vref", ",", "c", ",", 
         "n", ",", "b1", ",", "b2", ",", "sd1", ",", "sd2", ",", "sd", ",", 
         "nrec", ",", "neq", ",", "nst", ",", "fn", ",", "fr", ",", 
         "lnPGAref", ",", "lns", ",", "lny", ",", "saval", ",", "sigtotal"}], 
        "}"}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"{", 
          RowBox[{
          "a1", ",", "a2", ",", "a3", ",", "a4", ",", "a5", ",", "a6", ",", 
           "a7", ",", "a8", ",", "a9", ",", "c1", ",", "vcon", ",", "vref", ",",
            "c", ",", "n", ",", "b1", ",", "b2", ",", "sd1", ",", "sd2", ",", 
           "sd", ",", "nrec", ",", "neq", ",", "nst"}], "}"}], "=", 
         RowBox[{"{", 
          RowBox[{"2.52977`", ",", "0.0029`", ",", 
           RowBox[{"-", "0.05496`"}], ",", 
           RowBox[{"-", "1.31001`"}], ",", "0.2529`", ",", "7.5`", ",", 
           RowBox[{"-", "0.5096`"}], ",", 
           RowBox[{"-", "0.1091`"}], ",", "0.0937`", ",", "6.75`", ",", 
           "1000", ",", "750", ",", "2.5`", ",", "3.2`", ",", 
           RowBox[{"-", "0.41997`"}], ",", 
           RowBox[{"-", "0.28846`"}], ",", "0.6375`", ",", "0.3581`", ",", 
           "0.7312`", ",", "1041", ",", "221", ",", "322"}], "}"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{"**", 
          RowBox[{"*", "Options"}]}], "****)"}], 
        RowBox[{"mw", "=", 
         RowBox[{"OptionValue", "[", "MagMW", "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"rdist", "=", 
         RowBox[{"OptionValue", "[", "DistEPI", "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"vs30", "=", 
         RowBox[{"OptionValue", "[", "Vs30", "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"faulttypeinp", "=", 
         RowBox[{"OptionValue", "[", "FaultTypeNSSR", "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"Which", "[", 
         RowBox[{
          RowBox[{"faulttypeinp", "==", "\"\<NORMAL\>\""}], ",", 
          RowBox[{
           RowBox[{"fn", "=", "1."}], ";", "\[IndentingNewLine]", 
           RowBox[{"fr", "=", "0."}], ";"}], ",", 
          RowBox[{"faulttypeinp", "==", "\"\<STRIKE SLIP\>\""}], ",", 
          RowBox[{
           RowBox[{"fn", "=", "0."}], ";", "\[IndentingNewLine]", 
           RowBox[{"fr", "=", "0."}], ";"}], ",", 
          RowBox[{"faulttypeinp", "==", "\"\<REVERSE\>\""}], ",", 
          RowBox[{
           RowBox[{"fn", "=", "0."}], ";", "\[IndentingNewLine]", 
           RowBox[{"fr", "=", "1."}], ";"}], ",", "True", ",", 
          RowBox[{
           RowBox[{"Message", "[", 
            RowBox[{
             RowBox[{"EmpiricalEquation", "::", "option"}], ",", 
             "faulttypeinp", ",", "FaultTypeNSSR"}], "]"}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"Return", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", "999."}], ",", 
              RowBox[{"-", "999."}], ",", 
              RowBox[{"-", "999."}], ",", 
              RowBox[{"-", "999."}]}], "}"}], "]"}], ";"}]}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"mw", "<=", "c1"}], ",", 
          RowBox[{
           RowBox[{"lnPGAref", "=", 
            RowBox[{"a1", "+", 
             RowBox[{"a2", "*", 
              RowBox[{"(", 
               RowBox[{"mw", "-", "c1"}], ")"}]}], "+", 
             RowBox[{"a3", "*", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"8.5", "-", "mw"}], ")"}], "^", "2"}]}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"a4", "+", 
                RowBox[{"a5", "*", 
                 RowBox[{"(", 
                  RowBox[{"mw", "-", "c1"}], ")"}]}]}], ")"}], " ", 
              RowBox[{"Log", "[", 
               RowBox[{"Sqrt", "[", 
                RowBox[{
                 RowBox[{"rdist", "^", "2"}], "+", 
                 RowBox[{"a6", "^", "2"}]}], "]"}], "]"}]}], "+", 
             RowBox[{"a8", "*", "fn"}], "+", 
             RowBox[{"a9", "*", "fr"}]}]}], ";"}], ",", 
          RowBox[{"(*", 
           RowBox[{
            RowBox[{"else", " ", "mw"}], ">", "c1"}], "*)"}], 
          RowBox[{
           RowBox[{"lnPGAref", "=", 
            RowBox[{"a1", "+", 
             RowBox[{"a7", "*", 
              RowBox[{"(", 
               RowBox[{"mw", "-", "c1"}], ")"}]}], "+", 
             RowBox[{"a3", "*", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"8.5", "-", "mw"}], ")"}], "^", "2"}]}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"a4", "+", 
                RowBox[{"a5", "*", 
                 RowBox[{"(", 
                  RowBox[{"mw", "-", "c1"}], ")"}]}]}], ")"}], " ", 
              RowBox[{"Log", "[", 
               RowBox[{"Sqrt", "[", 
                RowBox[{
                 RowBox[{"rdist", "^", "2"}], "+", 
                 RowBox[{"a6", "^", "2"}]}], "]"}], "]"}]}], "+", 
             RowBox[{"a8", "*", "fn"}], "+", 
             RowBox[{"a9", "*", "fr"}]}]}], ";"}]}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"vs30", "<=", "vref"}], ",", 
          RowBox[{
           RowBox[{"lns", "=", 
            RowBox[{
             RowBox[{"b1", " ", 
              RowBox[{"Log", "[", 
               RowBox[{"vs30", "/", "vref"}], "]"}]}], "+", 
             RowBox[{"b2", " ", 
              RowBox[{"Log", "[", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"Exp", "[", "lnPGAref", "]"}], "+", 
                  RowBox[{"c", " ", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"vs30", "/", "vref"}], ")"}], "^", "n"}]}]}], 
                 ")"}], "/", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"Exp", "[", "lnPGAref", "]"}], "+", "c"}], ")"}], 
                  " ", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"vs30", "/", "vref"}], ")"}], "^", "n"}]}], 
                 ")"}]}], "]"}]}]}]}], ";"}], ",", 
          RowBox[{
           RowBox[{"lns", "=", 
            RowBox[{"b1", " ", 
             RowBox[{"Log", "[", 
              RowBox[{
               RowBox[{"Min", "[", 
                RowBox[{"vs30", ",", "vcon"}], "]"}], "/", "vref"}], 
              "]"}]}]}], ";"}]}], "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{"*", "lnY"}], "**)"}], 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"mw", "<=", "c1"}], ",", 
          RowBox[{
           RowBox[{"lny", "=", 
            RowBox[{"a1", "+", 
             RowBox[{"a2", "*", 
              RowBox[{"(", 
               RowBox[{"mw", "-", "c1"}], ")"}]}], "+", 
             RowBox[{"a3", "*", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"8.5", "-", "mw"}], ")"}], "^", "2"}]}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"a4", "+", 
                RowBox[{"a5", "*", 
                 RowBox[{"(", 
                  RowBox[{"mw", "-", "c1"}], ")"}]}]}], ")"}], " ", 
              RowBox[{"Log", "[", 
               RowBox[{"Sqrt", "[", 
                RowBox[{
                 RowBox[{"rdist", "^", "2"}], "+", 
                 RowBox[{"a6", "^", "2"}]}], "]"}], "]"}]}], "+", 
             RowBox[{"a8", "*", "fn"}], "+", 
             RowBox[{"a9", "*", "fr"}], "+", "lns"}]}], ";"}], ",", 
          RowBox[{"(*", 
           RowBox[{
            RowBox[{"else", " ", "mw"}], ">", "c1"}], "*)"}], 
          RowBox[{
           RowBox[{"lny", "=", 
            RowBox[{"a1", "+", 
             RowBox[{"a7", "*", 
              RowBox[{"(", 
               RowBox[{"mw", "-", "c1"}], ")"}]}], "+", 
             RowBox[{"a3", "*", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"8.5", "-", "mw"}], ")"}], "^", "2"}]}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"a4", "+", 
                RowBox[{"a5", "*", 
                 RowBox[{"(", 
                  RowBox[{"mw", "-", "c1"}], ")"}]}]}], ")"}], "*", 
              RowBox[{"Log", "[", 
               RowBox[{"Sqrt", "[", 
                RowBox[{
                 RowBox[{"rdist", "^", "2"}], "+", 
                 RowBox[{"a6", "^", "2"}]}], "]"}], "]"}]}], "+", 
             RowBox[{"a8", "*", "fn"}], "+", 
             RowBox[{"a9", "*", "fr"}], "+", "lns"}]}], ";"}]}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"(*", "PGA", "*)"}], 
        RowBox[{"(*", 
         RowBox[{"PGA", " ", "in", " ", 
          RowBox[{"m", "/", "s"}], "*", "s"}], "*)"}], 
        RowBox[{"saval", "=", 
         RowBox[{"9.81", "*", 
          RowBox[{"Exp", "[", "lny", "]"}]}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"sigtotal", "=", "sd"}], ";", "\[IndentingNewLine]", 
        RowBox[{"Return", "[", 
         RowBox[{"{", 
          RowBox[{"saval", ",", "sigtotal"}], "}"}], "]"}], ";"}]}], "]"}]}], 
    ";"}]}]}]], "Input",
 CellChangeTimes->{{3.951976552154933*^9, 3.9519765521575537`*^9}},
 CellLabel->"In[52]:=",ExpressionUUID->"2b005e04-0a6a-44ec-8747-b90199f343b4"]
}, Closed]],

Cell[CellGroupData[{

Cell["ConvertDistanceMetric", "Subsubsection",
 CellChangeTimes->{{3.952169552360321*^9, 3.952169577087267*^9}, 
   3.952172831298647*^9, 3.952173326385323*^9, 
   3.952176465178631*^9},ExpressionUUID->"c64208e8-6ae1-4d3c-9544-\
d77a664bcf37"],

Cell[BoxData[
 RowBox[{
  RowBox[{"$DistConvCoeffdatalist", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\"\<NORWAYNF\>\"", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          
          RowBox[{"\"\<#FILEBEGIN\>\"", 
           ",", "\"\<NORWAYNF_CVCOEFFS.txt\>\""}], "}"}], ",", 
         RowBox[{"{", "\"\<#COMMENTBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<comment\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#COMMENTEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<NORWAY\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<NF\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2REPI\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "4.25", ",", "\"\<MAXMAG:\>\"",
            ",", "6.75", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<MEAN\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "17.98909299453699"}], ",", "8.290785582579282", ",", 
           
           RowBox[{"-", "0.3713828198215281"}], ",", 
           RowBox[{"-", "0.2813714196177921"}], ",", "0.03604375630775099"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"8.509366281367782", ",", 
           RowBox[{"-", "6.587348859587308"}], ",", "1.904045465878872", ",", 
           
           RowBox[{"-", "0.2439218618595946"}], ",", "0.01171317647636416"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.05963191413336361"}], ",", "0.04608648343116027", ",", 
           RowBox[{"-", "0.01330308304924612"}], ",", "0.001702946582185377", 
           ",", 
           RowBox[{"-", "0.00008179992731025982"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.000111208729225368", ",", 
           RowBox[{"-", "0.00008577507965898949"}], ",", 
           "0.00002472414585491668", ",", 
           RowBox[{"-", "3.164075737987538*^-6"}], ",", 
           "1.52240243243552*^-7"}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<NORWAY\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<NF\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2REPI\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "4.25", ",", "\"\<MAXMAG:\>\"",
            ",", "6.75", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<SIGMA\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"48.14966192950806", ",", 
           RowBox[{"-", "44.5623273530827"}], ",", "15.39781867367432", ",", 
           RowBox[{"-", "2.365244903896844"}], ",", "0.1379269758341757"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"6.473941651726939", ",", 
           RowBox[{"-", "4.991757990174191"}], ",", "1.435646128126741", ",", 
           
           RowBox[{"-", "0.1826935716717295"}], ",", "0.008690666986064143"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.04441021916836895"}], ",", "0.03430482498467104", ",", 
           RowBox[{"-", "0.00989264776271435"}], ",", "0.001263688217168037", 
           ",", 
           RowBox[{"-", "0.00006042907780600865"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.00007912705653393405", ",", 
           RowBox[{"-", "0.00006128924916638575"}], ",", 
           "0.00001774538141722523", ",", 
           RowBox[{"-", "2.279672237122133*^-6"}], ",", 
           "1.098643591784194*^-7"}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<NORWAY\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<NF\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2REPI\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "6.75", ",", "\"\<MAXMAG:\>\"",
            ",", "8.25", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<MEAN\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "14453.76520917848"}], ",", "7469.268753530946", ",", 
           
           RowBox[{"-", "1429.557013080002"}], ",", "119.634449940807", ",", 
           RowBox[{"-", "3.667484830877979"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1864.188943037384", ",", 
           RowBox[{"-", "1003.025278428576"}], ",", "201.9942475610792", ",", 
           
           RowBox[{"-", "18.04722537657118"}], ",", "0.6037445030528545"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "21.71795248375855"}], ",", "11.74518052796359", ",", 
           
           RowBox[{"-", "2.378066327836171"}], ",", "0.2136685412215029", ",", 
           RowBox[{"-", "0.007189630920606213"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.05909717249877755", ",", 
           RowBox[{"-", "0.03206366069180848"}], ",", "0.006513742385150143", 
           ",", 
           RowBox[{"-", "0.0005872772382483405"}], ",", 
           "0.00001983061315453665"}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<NORWAY\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<NF\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2REPI\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "6.75", ",", "\"\<MAXMAG:\>\"",
            ",", "8.25", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<SIGMA\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "46635.85550271347"}], ",", "24968.61117686975", ",", 
           
           RowBox[{"-", "4989.22368349647"}], ",", "440.5762303586444", ",", 
           RowBox[{"-", "14.48538704891832"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2616.240739767832", ",", 
           RowBox[{"-", "1413.516704264547"}], ",", "285.8138489484256", ",", 
           
           RowBox[{"-", "25.63367974344155"}], ",", "0.8604342263814045"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "24.42013673269834"}], ",", "13.19145980263026", ",", 
           
           RowBox[{"-", "2.667003778699126"}], ",", "0.2391849694282456", ",", 
           RowBox[{"-", "0.008029065241064873"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.06300027669128186", ",", 
           RowBox[{"-", "0.03406217020366122"}], ",", "0.006893253083944935", 
           ",", 
           RowBox[{"-", "0.000618865090668905"}], ",", 
           "0.00002079853822609738"}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<NORWAY\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<NF\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2RHYP\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "4.25", ",", "\"\<MAXMAG:\>\"",
            ",", "6.75", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<MEAN\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"102.3805355041007", ",", 
           RowBox[{"-", "85.13555375666195"}], ",", "27.34883685120301", ",", 
           
           RowBox[{"-", "3.846714263216646"}], ",", "0.2025174704804029"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"4.533384929092083", ",", 
           RowBox[{"-", "3.504019632221007"}], ",", "1.001838950024831", ",", 
           
           RowBox[{"-", "0.1287805624778286"}], ",", "0.006338518663133583"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.02641693388176863"}], ",", "0.02035134647473449", ",", 
           RowBox[{"-", "0.005805547953171445"}], ",", "0.000748568838695691",
            ",", 
           RowBox[{"-", "0.00003725815417409946"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.00003081020159661845", ",", 
           RowBox[{"-", "0.00002353674498583843"}], ",", 
           "6.637628222187369*^-6", ",", 
           RowBox[{"-", "8.655356369051759*^-7"}], ",", 
           "4.50007192663118*^-8"}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<NORWAY\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<NF\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2RHYP\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "4.25", ",", "\"\<MAXMAG:\>\"",
            ",", "6.75", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<SIGMA\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"219.017685017561", ",", 
           RowBox[{"-", "174.1943930863316"}], ",", "52.72878456080132", ",", 
           
           RowBox[{"-", "7.094495441558506"}], ",", "0.357756240958212"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.951141465832111", ",", 
           RowBox[{"-", "0.7955574377562089"}], ",", "0.2393192856733206", ",", 
           RowBox[{"-", "0.03310281681199968"}], ",", 
           "0.001817378532496957"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.001348192782058604", ",", 
           RowBox[{"-", "0.0003560667698659067"}], ",", 
           RowBox[{"-", "0.00007365726545930446"}], ",", 
           "0.00004438724527106166", ",", 
           RowBox[{"-", "4.746410361868009*^-6"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.00003130358929205159"}], ",", 
           "0.00002213566449859402", ",", 
           RowBox[{"-", "5.789437893836722*^-6"}], ",", 
           "6.303908124167847*^-7", ",", 
           RowBox[{"-", "2.25459158532676*^-8"}]}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<NORWAY\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<NF\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2RHYP\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "6.75", ",", "\"\<MAXMAG:\>\"",
            ",", "8.25", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<MEAN\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "19082.85012334676"}], ",", "9989.2137839087", ",", 
           RowBox[{"-", "1942.393056557818"}], ",", "165.9240221967145", ",", 
           
           RowBox[{"-", "5.232475838126112"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1932.810602048809", ",", 
           RowBox[{"-", "1040.677981947808"}], ",", "209.7121841168851", ",", 
           
           RowBox[{"-", "18.74843988475888"}], ",", "0.6276013441480774"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "22.10798568899094"}], ",", "11.96071592018032", ",", 
           
           RowBox[{"-", "2.422531784090745"}], ",", "0.2177324238093254", ",", 
           RowBox[{"-", "0.007328675403613279"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.05980002220753899", ",", 
           RowBox[{"-", "0.03245504810466471"}], ",", "0.006595040572376278", 
           ",", 
           RowBox[{"-", "0.0005947537832443641"}], ",", 
           "0.00002008793493655393"}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<NORWAY\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<NF\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2RHYP\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "6.75", ",", "\"\<MAXMAG:\>\"",
            ",", "8.25", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<SIGMA\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "43570.64725876887"}], ",", "23320.25170074303", ",", 
           
           RowBox[{"-", "4656.715045682604"}], ",", "410.7485782850081", ",", 
           
           RowBox[{"-", "13.48181882575708"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2553.197179444619", ",", 
           RowBox[{"-", "1379.790489796588"}], ",", "279.0452334399264", ",", 
           
           RowBox[{"-", "25.02944005057303"}], ",", "0.8401953096023356"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "23.95324422227321"}], ",", "12.94207218895263", ",", 
           
           RowBox[{"-", "2.617040457872393"}], ",", "0.2347332966681819", ",", 
           RowBox[{"-", "0.007880263767799798"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.06193330302019301", ",", 
           RowBox[{"-", "0.03349236106815154"}], ",", "0.006779133635823717", 
           ",", 
           RowBox[{"-", "0.0006087022274859155"}], ",", 
           "0.00002045904907591742"}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<NORWAY\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<NF\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2RRUP\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "4.25", ",", "\"\<MAXMAG:\>\"",
            ",", "6.75", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<MEAN\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"22.71428627730379", ",", 
           RowBox[{"-", "13.77353393087021"}], ",", "4.919435539722301", ",", 
           
           RowBox[{"-", "0.698135297845928"}], ",", "0.03277408836448071"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1.284677152838735"}], ",", "0.921816808170134", ",", 
           
           RowBox[{"-", "0.2865316643597891"}], ",", "0.0379868804604098", ",", 
           RowBox[{"-", "0.001781778845408295"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.01165015167082572", ",", 
           RowBox[{"-", "0.008533474453772503"}], ",", "0.002608081942684524",
            ",", 
           RowBox[{"-", "0.0003425525407132128"}], ",", 
           "0.00001606980911556298"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.0000284387159343338"}], ",", 
           "0.00002099105052934722", ",", 
           RowBox[{"-", "6.378938665041826*^-6"}], ",", 
           "8.351661640227398*^-7", ",", 
           RowBox[{"-", "3.918905987008943*^-8"}]}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<NORWAY\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<NF\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2RRUP\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "4.25", ",", "\"\<MAXMAG:\>\"",
            ",", "6.75", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<SIGMA\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"29.39727948328508", ",", 
           RowBox[{"-", "21.89942689482777"}], ",", "6.923014502079337", ",", 
           
           RowBox[{"-", "0.980394583722756"}], ",", "0.05188140790706198"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1.109497625006572"}], ",", "0.8522381748864185", ",", 
           RowBox[{"-", "0.2582228426375915"}], ",", "0.03464524444020769", ",", 
           RowBox[{"-", "0.001720774640600373"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.00943462142931657", ",", 
           RowBox[{"-", "0.007272891164400726"}], ",", "0.002177669017934875",
            ",", 
           RowBox[{"-", "0.0002878859465809478"}], ",", 
           "0.00001405261330017732"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.00002222508826925456"}], ",", 
           "0.00001714766425559387", ",", 
           RowBox[{"-", "5.109590406405392*^-6"}], ",", 
           "6.713522727154183*^-7", ",", 
           RowBox[{"-", "3.252909500542446*^-8"}]}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<NORWAY\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<NF\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2RRUP\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "6.75", ",", "\"\<MAXMAG:\>\"",
            ",", "8.25", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<MEAN\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "2408.084692355884"}], ",", "1346.311818160884", ",", 
           
           RowBox[{"-", "278.9784099794505"}], ",", "25.49056892876205", ",", 
           
           RowBox[{"-", "0.8675075078179687"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"127.8305124514769", ",", 
           RowBox[{"-", "69.99185604299424"}], ",", "14.28641331981294", ",", 
           
           RowBox[{"-", "1.290116656542966"}], ",", "0.04351168498845709"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1.274002984222835"}], ",", "0.6942431839346764", ",", 
           RowBox[{"-", "0.1411930400569164"}], ",", "0.01271327526970401", ",", 
           RowBox[{"-", "0.0004277928349214896"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.003362597745461997", ",", 
           RowBox[{"-", "0.001828594065724418"}], ",", 
           "0.0003713018386332241", ",", 
           RowBox[{"-", "0.00003338980346310412"}], ",", 
           "1.12239218079069*^-6"}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<NORWAY\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<NF\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2RRUP\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "6.75", ",", "\"\<MAXMAG:\>\"",
            ",", "8.25", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<SIGMA\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"9175.18456944095", ",", 
           RowBox[{"-", "4910.381811709456"}], ",", "982.451353988322", ",", 
           RowBox[{"-", "87.07825593048753"}], ",", "2.885813277244609"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "217.7555089772746"}], ",", "116.2749039068869", ",", 
           
           RowBox[{"-", "23.21588732240247"}], ",", "2.054162269705095", ",", 
           
           RowBox[{"-", "0.06797712465539885"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1.590513856201686", ",", 
           RowBox[{"-", "0.8486565907522139"}], ",", "0.1693331509613504", ",", 
           RowBox[{"-", "0.01497460588763365"}], ",", 
           "0.0004953244072644419"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.00353445705754098"}], ",", "0.00188521904870212", ",", 
           RowBox[{"-", "0.0003760388209881771"}], ",", 
           "0.00003324550407529564", ",", 
           RowBox[{"-", "1.09944794466111*^-6"}]}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<NORWAY\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<NF\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2RSEIS\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "4.25", ",", "\"\<MAXMAG:\>\"",
            ",", "6.75", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<MEAN\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"70.63880321828866", ",", 
           RowBox[{"-", "52.05047700771539"}], ",", "16.37334128563666", ",", 
           
           RowBox[{"-", "2.221997891717828"}], ",", "0.1090051151463057"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1.506112208663697"}], ",", "1.113583677363671", ",", 
           
           RowBox[{"-", "0.3490333940620652"}], ",", "0.04708097216781", ",", 
           
           RowBox[{"-", "0.002281558244073805"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.01126678915401694", ",", 
           RowBox[{"-", "0.008391450724819165"}], ",", "0.002621859883154127",
            ",", 
           RowBox[{"-", "0.0003529317987484439"}], ",", 
           "0.00001707960502722752"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.00002374724596527213"}], ",", 
           "0.00001773322436521138", ",", 
           RowBox[{"-", "5.570850012212454*^-6"}], ",", 
           "7.52841130665114*^-7", ",", 
           RowBox[{"-", "3.650759629888012*^-8"}]}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<NORWAY\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<NF\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2RSEIS\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "4.25", ",", "\"\<MAXMAG:\>\"",
            ",", "6.75", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<SIGMA\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"36.64585208598316", ",", 
           RowBox[{"-", "26.9118298972171"}], ",", "8.123626595128494", ",", 
           RowBox[{"-", "1.089331170039934"}], ",", "0.05403320772920012"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1.658881677706341"}], ",", "1.26418574510812", ",", 
           RowBox[{"-", "0.3717673010219676"}], ",", "0.04818607155761547", ",", 
           RowBox[{"-", "0.002301813267369447"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.01657252449795184", ",", 
           RowBox[{"-", "0.01271199571879191"}], ",", "0.003711947212463113", 
           ",", 
           RowBox[{"-", "0.0004772341935097065"}], ",", 
           "0.00002263071898068964"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.00004175913759795326"}], ",", 
           "0.00003205755430719599", ",", 
           RowBox[{"-", "9.32706637462385*^-6"}], ",", 
           "1.194156394617469*^-6", ",", 
           RowBox[{"-", "5.638872847671634*^-8"}]}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<NORWAY\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<NF\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2RSEIS\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "6.75", ",", "\"\<MAXMAG:\>\"",
            ",", "8.25", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<MEAN\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"6713.451516158754", ",", 
           RowBox[{"-", "3529.776765796099"}], ",", "694.2954648106725", ",", 
           
           RowBox[{"-", "60.49127161824536"}], ",", "1.970600595289956"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "40.04115744626611"}], ",", "21.13825874965593", ",", 
           
           RowBox[{"-", "4.198185100364625"}], ",", "0.3702716029886773", ",", 
           RowBox[{"-", "0.01222911278427818"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.3434896123396083", ",", 
           RowBox[{"-", "0.1828741348078866"}], ",", "0.03662586503780075", ",", 
           RowBox[{"-", "0.003259794357908396"}], ",", 
           "0.0001087108964151527"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.000925460972949693"}], ",", 
           "0.0004956374769638181", ",", 
           RowBox[{"-", "0.0000998027501986459"}], ",", 
           "8.931608004008817*^-6", ",", 
           RowBox[{"-", "2.995423221660854*^-7"}]}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<NORWAY\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<NF\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2RSEIS\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "6.75", ",", "\"\<MAXMAG:\>\"",
            ",", "8.25", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<SIGMA\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "3015.760207825753"}], ",", "1589.938303339309", ",", 
           
           RowBox[{"-", "313.1423078477466"}], ",", "27.33507713771957", ",", 
           
           RowBox[{"-", "0.8927734587767013"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"39.0582667784673", ",", 
           RowBox[{"-", "18.67804864562047"}], ",", "3.286647737574417", ",", 
           
           RowBox[{"-", "0.251484581228429"}], ",", "0.007028900948090555"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.2344175505410324", ",", 
           RowBox[{"-", "0.1391518746900393"}], ",", "0.03061217539613021", ",", 
           RowBox[{"-", "0.002960162802866965"}], ",", 
           "0.0001062521645195396"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.001228546138782387"}], ",", 
           "0.0006832788817010597", ",", 
           RowBox[{"-", "0.0001419421265236783"}], ",", 
           "0.00001305150128181349", ",", 
           RowBox[{"-", "4.481907213696738*^-7"}]}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<NORWAY\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<NF\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2RRMS\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "4.25", ",", "\"\<MAXMAG:\>\"",
            ",", "6.75", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<MEAN\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"178.3515925002436", ",", 
           RowBox[{"-", "138.2045166502013"}], ",", "42.30992881606517", ",", 
           
           RowBox[{"-", "5.710164037685912"}], ",", "0.2889547894730331"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1.706494576775892"}], ",", "1.199293452014567", ",", 
           
           RowBox[{"-", "0.3479440190044425"}], ",", "0.0423808868282098", ",", 
           RowBox[{"-", "0.001755943167270712"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.02966841678483346", ",", 
           RowBox[{"-", "0.02219094359982649"}], ",", "0.006431805685752088", 
           ",", 
           RowBox[{"-", "0.000807417589299672"}], ",", 
           "0.00003657643209093297"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.00008410870655342338"}], ",", 
           "0.00006350071695712552", ",", 
           RowBox[{"-", "0.00001840334007765838"}], ",", 
           "2.320494392460673*^-6", ",", 
           RowBox[{"-", "1.063974738897808*^-7"}]}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<NORWAY\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<NF\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2RRMS\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "4.25", ",", "\"\<MAXMAG:\>\"",
            ",", "6.75", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<SIGMA\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"101.4389311174926", ",", 
           RowBox[{"-", "78.78794014147853"}], ",", "23.66599575752367", ",", 
           
           RowBox[{"-", "3.151712921697506"}], ",", "0.1561030103367795"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.176678610040809", ",", 
           RowBox[{"-", "0.2402227297251895"}], ",", "0.0930406969694743", ",", 
           RowBox[{"-", "0.01617840301106076"}], ",", 
           "0.001078811330687047"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.004939502110284043", ",", 
           RowBox[{"-", "0.003014033513604193"}], ",", 
           "0.0006629396361522493", ",", 
           RowBox[{"-", "0.00004817312535786285"}], ",", 
           RowBox[{"-", "1.807635870172223*^-7"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.00001717444811115993"}], ",", 
           "0.00001139260909385985", ",", 
           RowBox[{"-", "2.780704369492343*^-6"}], ",", 
           "2.674262447160146*^-7", ",", 
           RowBox[{"-", "6.955865984722437*^-9"}]}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<NORWAY\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<NF\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2RRMS\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "6.75", ",", "\"\<MAXMAG:\>\"",
            ",", "8.25", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<MEAN\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"4579.54996545577", ",", 
           RowBox[{"-", "2619.972542846696"}], ",", "567.2916497658028", ",", 
           
           RowBox[{"-", "55.04772172941398"}], ",", "2.025439690153277"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"700.5540204964758", ",", 
           RowBox[{"-", "380.2761345178764"}], ",", "77.29147832251383", ",", 
           
           RowBox[{"-", "6.97548005259101"}], ",", "0.2360053123812014"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "7.478805909583433"}], ",", "4.07141789505995", ",", 
           RowBox[{"-", "0.8297526130402637"}], ",", "0.0750504004616432", ",", 
           RowBox[{"-", "0.002542788141682095"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.01896157134858103", ",", 
           RowBox[{"-", "0.01035305969419464"}], ",", "0.002116161834385708", 
           ",", 
           RowBox[{"-", "0.0001919529329912831"}], ",", 
           "6.521083901792907*^-6"}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<NORWAY\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<NF\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2RRMS\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "6.75", ",", "\"\<MAXMAG:\>\"",
            ",", "8.25", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<SIGMA\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "7198.050527753414"}], ",", "3895.73914421032", ",", 
           RowBox[{"-", "789.6003563675945"}], ",", "71.03204553015648", ",", 
           
           RowBox[{"-", "2.391715687470644"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"43.2948414925377", ",", 
           RowBox[{"-", "16.94834621462237"}], ",", "2.103549314058155", ",", 
           
           RowBox[{"-", "0.0702589969232183"}], ",", 
           RowBox[{"-", "0.00147826353136798"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "4.472990307344753"}], ",", "2.370223443492021", ",", 
           
           RowBox[{"-", "0.4695174435493165"}], ",", "0.04121072071508956", ",", 
           RowBox[{"-", "0.001352768069417703"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.01721355809720593", ",", 
           RowBox[{"-", "0.00922539338300601"}], ",", "0.001849871551417665", 
           ",", 
           RowBox[{"-", "0.0001644932388833845"}], ",", 
           "5.473829405381985*^-6"}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<NORWAY\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<NF\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2RRMSSEIS\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "4.25", ",", "\"\<MAXMAG:\>\"",
            ",", "6.75", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<MEAN\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"161.7751564260191", ",", 
           RowBox[{"-", "124.5632294249244"}], ",", "38.08795829961097", ",", 
           
           RowBox[{"-", "5.128722021173454"}], ",", "0.2589690111358722"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1.521644251154177"}], ",", "1.036669320697683", ",", 
           
           RowBox[{"-", "0.2944001410062501"}], ",", "0.03459883473017224", ",", 
           RowBox[{"-", "0.001336669045283858"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.02977041657981363", ",", 
           RowBox[{"-", "0.02209464020489541"}], ",", "0.006346623589940748", 
           ",", 
           RowBox[{"-", "0.0007885249532792492"}], ",", 
           "0.00003527546710489945"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.00008804889461479116"}], ",", 
           "0.00006607663041923299", ",", 
           RowBox[{"-", "0.00001899408933637103"}], ",", 
           "2.374777381914377*^-6", ",", 
           RowBox[{"-", "1.079355036700375*^-7"}]}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<NORWAY\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<NF\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2RRMSSEIS\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "4.25", ",", "\"\<MAXMAG:\>\"",
            ",", "6.75", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<SIGMA\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"80.99877868095429", ",", 
           RowBox[{"-", "61.15795985457201"}], ",", "18.02042607734152", ",", 
           
           RowBox[{"-", "2.354916815671653"}], ",", "0.1146695893210748"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1.085160826713173", ",", 
           RowBox[{"-", "0.988994325603093"}], ",", "0.3224307491416829", ",", 
           RowBox[{"-", "0.04712874339316557"}], ",", 
           "0.002621999287849557"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.003456678119420287"}], ",", "0.003801982542394043",
            ",", 
           RowBox[{"-", "0.001394328497452256"}], ",", 
           "0.0002253223720342782", ",", 
           RowBox[{"-", "0.00001363240820310697"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"3.821960766977157*^-6", ",", 
           RowBox[{"-", "5.529704667427598*^-6"}], ",", 
           "2.290862690087788*^-6", ",", 
           RowBox[{"-", "4.020939645677603*^-7"}], ",", 
           "2.576350080207449*^-8"}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<NORWAY\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<NF\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2RRMSSEIS\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "6.75", ",", "\"\<MAXMAG:\>\"",
            ",", "8.25", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<MEAN\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1843.301888944289", ",", 
           RowBox[{"-", "1135.658190439964"}], ",", "266.3525521848854", ",", 
           
           RowBox[{"-", "28.00475857187741"}], ",", "1.115681932556184"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"792.9036535734249", ",", 
           RowBox[{"-", "430.2441105661502"}], ",", "87.40572245743743", ",", 
           
           RowBox[{"-", "7.883543269450211"}], ",", "0.2665359014626581"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "8.421951060483808"}], ",", "4.581211549413618", ",", 
           
           RowBox[{"-", "0.932864301142595"}], ",", "0.08430212790811231", ",", 
           RowBox[{"-", "0.0028536327557207"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.02155108577102843", ",", 
           RowBox[{"-", "0.01175257162163592"}], ",", "0.00239921500580484", ",", 
           RowBox[{"-", "0.000217349349470477"}], ",", 
           "7.374288701597109*^-6"}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<NORWAY\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<NF\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2RRMSSEIS\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "6.75", ",", "\"\<MAXMAG:\>\"",
            ",", "8.25", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<SIGMA\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "7944.724306401797"}], ",", "4299.155901106092", ",", 
           
           RowBox[{"-", "870.9667547769801"}], ",", "78.30226971345428", ",", 
           
           RowBox[{"-", "2.634828070781611"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"46.69618189362492", ",", 
           RowBox[{"-", "18.82004101975053"}], ",", "2.484118003723852", ",", 
           
           RowBox[{"-", "0.1043446239796597"}], ",", 
           RowBox[{"-", "0.0003384455183782064"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "4.447451116512936"}], ",", "2.356427320149182", ",", 
           
           RowBox[{"-", "0.4666935611276495"}], ",", "0.04095254218730296", ",", 
           RowBox[{"-", "0.001343908058920433"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.01697642007307032", ",", 
           RowBox[{"-", "0.00909672018346706"}], ",", "0.001823670683459514", 
           ",", 
           RowBox[{"-", "0.000162123227779548"}], ",", 
           "5.39354337229473*^-6"}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#FILEEND\>\"", "}"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\"\<NORWAYSS\>\"", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          
          RowBox[{"\"\<#FILEBEGIN\>\"", 
           ",", "\"\<NORWAYSS_CVCOEFFS.txt\>\""}], "}"}], ",", 
         RowBox[{"{", "\"\<#COMMENTBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<comment\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#COMMENTEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<NORWAY\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<SS\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2REPI\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "4.25", ",", "\"\<MAXMAG:\>\"",
            ",", "6.75", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<MEAN\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"26.13459238977467", ",", 
           RowBox[{"-", "23.38314141154198"}], ",", "7.90294845768595", ",", 
           RowBox[{"-", "1.20485314983985"}], ",", "0.07194942988299582"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.07062374147445877"}], ",", 
           RowBox[{"-", "0.08567358134739932"}], ",", "0.0753975979834394", ",", 
           RowBox[{"-", "0.01781345375204309"}], ",", 
           "0.001350156234959809"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.0104923710535794", ",", 
           RowBox[{"-", "0.006910431139557689"}], ",", "0.001563336530465599",
            ",", 
           RowBox[{"-", "0.0001305889779323988"}], ",", 
           "2.038707374362162*^-6"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.00004260619923304691"}], ",", 
           "0.00003010021502108461", ",", 
           RowBox[{"-", "7.670845557447493*^-6"}], ",", 
           "8.171637026197827*^-7", ",", 
           RowBox[{"-", "2.912496991944009*^-8"}]}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<NORWAY\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<SS\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2REPI\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "4.25", ",", "\"\<MAXMAG:\>\"",
            ",", "6.75", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<SIGMA\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"124.8991932521743", ",", 
           RowBox[{"-", "101.4904629332619"}], ",", "31.029700182771", ",", 
           RowBox[{"-", "4.248466758049468"}], ",", "0.2219437137056416"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1.410758299298385", ",", 
           RowBox[{"-", "1.135292453294288"}], ",", "0.34493098911853", ",", 
           RowBox[{"-", "0.0470158675865872"}], ",", "0.002432549257670241"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.01937388389089944"}], ",", "0.01523085759053763", ",", 
           RowBox[{"-", "0.004498427371537195"}], ",", 
           "0.0005931512151273615", ",", 
           RowBox[{"-", "0.00002955717565917746"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.00006184883120294524", ",", 
           RowBox[{"-", "0.00004814527405397507"}], ",", 
           "0.00001404126655540992", ",", 
           RowBox[{"-", "1.822705109050936*^-6"}], ",", 
           "8.914163266289115*^-8"}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<NORWAY\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<SS\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2REPI\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "6.75", ",", "\"\<MAXMAG:\>\"",
            ",", "8.25", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<MEAN\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"19254.23939907838", ",", 
           RowBox[{"-", "10881.16428548657"}], ",", "2309.269679681074", ",", 
           
           RowBox[{"-", "218.2391042364849"}], ",", "7.757186161131246"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1079.359407808972"}], ",", "588.632194641241", ",", 
           RowBox[{"-", "120.0993574512125"}], ",", "10.86148204221756", ",", 
           
           RowBox[{"-", "0.3671504268532036"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"10.31325267952889", ",", 
           RowBox[{"-", "5.558461887817353"}], ",", "1.120260244592591", ",", 
           
           RowBox[{"-", "0.1000269459645793"}], ",", "0.003336614527914636"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.02817646886772221"}], ",", "0.01510665328960402", ",", 
           RowBox[{"-", "0.003027877639295037"}], ",", 
           "0.0002687990271046724", ",", 
           RowBox[{"-", "8.91264264751476*^-6"}]}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<NORWAY\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<SS\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2REPI\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "6.75", ",", "\"\<MAXMAG:\>\"",
            ",", "8.25", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<SIGMA\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "15404.46108761816"}], ",", "8039.549604823812", ",", 
           
           RowBox[{"-", "1553.30522459976"}], ",", "131.1144076908924", ",", 
           RowBox[{"-", "4.049286147108375"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"557.8236829434069", ",", 
           RowBox[{"-", "303.6966564191133"}], ",", "61.87967677501491", ",", 
           
           RowBox[{"-", "5.593409388280208"}], ",", "0.1893251601431032"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.6381483842397371"}], ",", "0.3594161971209331", ",", 
           RowBox[{"-", "0.07570897806711555"}], ",", "0.007079439884346596", 
           ",", 
           RowBox[{"-", "0.0002486399306067394"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.004933518917911985"}], ",", "0.002616580370124065",
            ",", 
           RowBox[{"-", "0.0005185221828813779"}], ",", 
           "0.00004546749919923772", ",", 
           RowBox[{"-", "1.486298019772516*^-6"}]}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<NORWAY\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<SS\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2RHYP\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "4.25", ",", "\"\<MAXMAG:\>\"",
            ",", "6.75", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<MEAN\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"260.7282885196813", ",", 
           RowBox[{"-", "194.5251353747963"}], ",", "55.26320151697637", ",", 
           
           RowBox[{"-", "6.955766256556559"}], ",", "0.3292065927342929"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "4.533329999807307"}], ",", "3.187621038710039", ",", 
           
           RowBox[{"-", "0.8343757555825095"}], ",", "0.0930961194827465", ",", 
           RowBox[{"-", "0.003624161523156336"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.04238344034180766", ",", 
           RowBox[{"-", "0.03041492842380169"}], ",", "0.00811437188361148", ",", 
           RowBox[{"-", "0.000931420475990954"}], ",", 
           "0.00003806106993015244"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.0001142427015948078"}], ",", 
           "0.00008308895076069011", ",", 
           RowBox[{"-", "0.00002247080549714027"}], ",", 
           "2.630142159251248*^-6", ",", 
           RowBox[{"-", "1.108639781701277*^-7"}]}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<NORWAY\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<SS\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2RHYP\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "4.25", ",", "\"\<MAXMAG:\>\"",
            ",", "6.75", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<SIGMA\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"300.3977425211305", ",", 
           RowBox[{"-", "234.6844116238829"}], ",", "69.38061374533584", ",", 
           
           RowBox[{"-", "9.10586828350963"}], ",", "0.4477157252323503"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "3.927546596455224"}], ",", "2.944018404242002", ",", 
           
           RowBox[{"-", "0.8251026520453835"}], ",", "0.1001429397680584", ",", 
           RowBox[{"-", "0.004366826754793324"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.02494001310873585", ",", 
           RowBox[{"-", "0.01861555928312942"}], ",", "0.005170885491729756", 
           ",", 
           RowBox[{"-", "0.0006174573135246129"}], ",", 
           "0.00002617671163225999"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.00004478011319568975"}], ",", 
           "0.000033221294054965", ",", 
           RowBox[{"-", "9.14563631922183*^-6"}], ",", 
           "1.072705101208435*^-6", ",", 
           RowBox[{"-", "4.389070389894512*^-8"}]}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<NORWAY\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<SS\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2RHYP\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "6.75", ",", "\"\<MAXMAG:\>\"",
            ",", "8.25", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<MEAN\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"26701.48458595338", ",", 
           RowBox[{"-", "14846.89353997093"}], ",", "3099.775302097126", ",", 
           
           RowBox[{"-", "288.0926481426669"}], ",", "10.06449199680766"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1269.618741160997"}], ",", "690.2319718075689", ",", 
           
           RowBox[{"-", "140.4112167048154"}], ",", "12.66233114097183", ",", 
           
           RowBox[{"-", "0.4268635346311728"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"11.77502794384752", ",", 
           RowBox[{"-", "6.339850459815137"}], ",", "1.276637737819878", ",", 
           
           RowBox[{"-", "0.1139073627265597"}], ",", "0.003797478368359438"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.03154945274337079"}], ",", "0.0169106956133237", ",", 
           RowBox[{"-", "0.003389125449984207"}], ",", 
           "0.0003008845830510665", ",", 
           RowBox[{"-", "9.97873516462573*^-6"}]}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<NORWAY\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<SS\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2RHYP\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "6.75", ",", "\"\<MAXMAG:\>\"",
            ",", "8.25", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<SIGMA\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "19305.77137509926"}], ",", "10123.87346041947", ",", 
           
           RowBox[{"-", "1969.05445033453"}], ",", "167.797808178992", ",", 
           RowBox[{"-", "5.257687209741826"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"657.6814942949097", ",", 
           RowBox[{"-", "357.5606119179095"}], ",", "72.73172237972574", ",", 
           
           RowBox[{"-", "6.561033316894199"}], ",", "0.2215506266012633"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1.341250422198652"}], ",", "0.7404294214832898", ",", 
           RowBox[{"-", "0.1528256930140954"}], ",", "0.01398717980289157", ",", 
           RowBox[{"-", "0.0004797513037999035"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.00346349033254766"}], ",", "0.001817109940504643", 
           ",", 
           RowBox[{"-", "0.0003561544715783178"}], ",", 
           "0.00003087551970694133", ",", 
           RowBox[{"-", "9.96548227244486*^-7"}]}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<NORWAY\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<SS\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2RRUP\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "4.25", ",", "\"\<MAXMAG:\>\"",
            ",", "6.75", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<MEAN\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"154.1630918682782", ",", 
           RowBox[{"-", "104.5744776742912"}], ",", "28.07498268526816", ",", 
           
           RowBox[{"-", "3.271372255409943"}], ",", "0.1364447267466377"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "2.447588904057441"}], ",", "1.604527656801372", ",", 
           
           RowBox[{"-", "0.4225792697276258"}], ",", "0.04768044916243336", ",", 
           RowBox[{"-", "0.001869429467202384"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.01552630075765389", ",", 
           RowBox[{"-", "0.01005053459722282"}], ",", "0.00262664456714985", ",", 
           RowBox[{"-", "0.0002918995744237813"}], ",", 
           "0.0000110893519909223"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.00003189893167818868"}], ",", 
           "0.00002050157019744683", ",", 
           RowBox[{"-", "5.336631157916778*^-6"}], ",", 
           "5.876660916786654*^-7", ",", 
           RowBox[{"-", "2.187377728538252*^-8"}]}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<NORWAY\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<SS\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2RRUP\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "4.25", ",", "\"\<MAXMAG:\>\"",
            ",", "6.75", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<SIGMA\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"145.4963622658178", ",", 
           RowBox[{"-", "107.9623269849684"}], ",", "30.47248773781913", ",", 
           
           RowBox[{"-", "3.790974273266084"}], ",", "0.174592564905399"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "3.095860057436534"}], ",", "2.276587621715664", ",", 
           
           RowBox[{"-", "0.6323789664797095"}], ",", "0.07704730192056945", ",", 
           RowBox[{"-", "0.003452697839043778"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.02056044821193352", ",", 
           RowBox[{"-", "0.01500593915880477"}], ",", "0.00412697423069707", ",", 
           RowBox[{"-", "0.0004964895288755097"}], ",", 
           "0.00002188935036808468"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.00004279622689069574"}], ",", 
           "0.00003105763795081416", ",", 
           RowBox[{"-", "8.482047733158712*^-6"}], ",", 
           "1.011401290929014*^-6", ",", 
           RowBox[{"-", "4.408221701025808*^-8"}]}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<NORWAY\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<SS\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2RRUP\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "6.75", ",", "\"\<MAXMAG:\>\"",
            ",", "8.25", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<MEAN\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "5367.268506735424"}], ",", "3003.540679080782", ",", 
           
           RowBox[{"-", "624.9661198432217"}], ",", "57.39320488537627", ",", 
           
           RowBox[{"-", "1.964472776720623"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"170.9774039458036", ",", 
           RowBox[{"-", "94.2444383591652"}], ",", "19.35609576224638", ",", 
           RowBox[{"-", "1.757130308783297"}], ",", "0.05952644328246627"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1.371011101561051"}], ",", "0.7521175062695621", ",", 
           RowBox[{"-", "0.1538110356819782"}], ",", "0.01390823432201095", ",", 
           RowBox[{"-", "0.000469472248594411"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.003183734770076855", ",", 
           RowBox[{"-", "0.001742648651031004"}], ",", 
           "0.0003556517013338787", ",", 
           RowBox[{"-", "0.00003209868446259688"}], ",", 
           "1.08157673971722*^-6"}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<NORWAY\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<SS\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2RRUP\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "6.75", ",", "\"\<MAXMAG:\>\"",
            ",", "8.25", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<SIGMA\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"3438.959936271962", ",", 
           RowBox[{"-", "1836.720875983595"}], ",", "366.7434656855294", ",", 
           
           RowBox[{"-", "32.4352650098589"}], ",", "1.072379466323865"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "86.53980865813725"}], ",", "46.03388325667958", ",", 
           
           RowBox[{"-", "9.15955532397743"}], ",", "0.807896181174697", ",", 
           RowBox[{"-", "0.02665575772719317"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.65042918753375", ",", 
           RowBox[{"-", "0.3459223937590306"}], ",", "0.06883237297941769", ",", 
           RowBox[{"-", "0.006073187354690903"}], ",", 
           "0.0002004930054465712"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.001476960698558991"}], ",", 
           "0.0007857127666333391", ",", 
           RowBox[{"-", "0.000156404422460466"}], ",", 
           "0.00001380726086252439", ",", 
           RowBox[{"-", "4.561194141172693*^-7"}]}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<NORWAY\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<SS\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2RSEIS\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "4.25", ",", "\"\<MAXMAG:\>\"",
            ",", "6.75", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<MEAN\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"367.8604470282276", ",", 
           RowBox[{"-", "271.4288767261228"}], ",", "76.69662810546457", ",", 
           
           RowBox[{"-", "9.54229095039638"}], ",", "0.4388166335806135"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "7.041256347697441"}], ",", "5.190210794238908", ",", 
           
           RowBox[{"-", "1.466982611022695"}], ",", "0.1822933054930252", ",", 
           RowBox[{"-", "0.008354293750264398"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.04876391343119463", ",", 
           RowBox[{"-", "0.0359920517831769"}], ",", "0.01018138689178659", ",", 
           RowBox[{"-", "0.001265397969117994"}], ",", 
           "0.00005797139267172904"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.0001060793110369378"}], ",", 
           "0.00007838543334236383", ",", 
           RowBox[{"-", "0.00002218904515682623"}], ",", 
           "2.758528139386777*^-6", ",", 
           RowBox[{"-", "1.263760490130803*^-7"}]}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<NORWAY\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<SS\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2RSEIS\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "4.25", ",", "\"\<MAXMAG:\>\"",
            ",", "6.75", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<SIGMA\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"222.3999792010615", ",", 
           RowBox[{"-", "167.5092722311931"}], ",", "47.55506036866799", ",", 
           
           RowBox[{"-", "5.938000815620924"}], ",", "0.2738865848439322"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "5.775816086882887"}], ",", "4.343274960266928", ",", 
           
           RowBox[{"-", "1.223828490311348"}], ",", "0.1513888892576489", ",", 
           RowBox[{"-", "0.00690586749753267"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.04179348728794536", ",", 
           RowBox[{"-", "0.03136438954088566"}], ",", "0.008805275523126897", 
           ",", 
           RowBox[{"-", "0.00108436686092959"}], ",", 
           "0.00004920852162655174"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.0000916744862654874"}], ",", 
           "0.00006869588760894551", ",", 
           RowBox[{"-", "0.00001924178437107478"}], ",", 
           "2.363129106355807*^-6", ",", 
           RowBox[{"-", "1.068979378975612*^-7"}]}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<NORWAY\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<SS\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2RSEIS\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "6.75", ",", "\"\<MAXMAG:\>\"",
            ",", "8.25", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<MEAN\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2169.501272947019", ",", 
           RowBox[{"-", "1154.818232774399"}], ",", "230.3502127225917", ",", 
           
           RowBox[{"-", "20.3487045588511"}], ",", "0.671910559224668"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"9.90745001196192", ",", 
           RowBox[{"-", "5.309134857758059"}], ",", "1.048377483317976", ",", 
           
           RowBox[{"-", "0.0916510617726466"}], ",", "0.002997876664760009"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.2040751376593586"}], ",", "0.1081937572871202", ",", 
           RowBox[{"-", "0.02133183401162467"}], ",", "0.001862492778091902", 
           ",", 
           RowBox[{"-", "0.00006080245913030927"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.00065976079738361", ",", 
           RowBox[{"-", "0.0003488687384777378"}], ",", 
           "0.00006870531403940645", ",", 
           RowBox[{"-", "5.991599168041048*^-6"}], ",", 
           "1.953228607132765*^-7"}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<NORWAY\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<SS\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2RSEIS\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "6.75", ",", "\"\<MAXMAG:\>\"",
            ",", "8.25", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<SIGMA\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"280.0250121165131", ",", 
           RowBox[{"-", "142.3375960340327"}], ",", "27.05301569298479", ",", 
           
           RowBox[{"-", "2.271864168043937"}], ",", "0.07111723850511828"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"13.57642748300586", ",", 
           RowBox[{"-", "7.303894768576856"}], ",", "1.469818121819174", ",", 
           
           RowBox[{"-", "0.1310960870285548"}], ",", "0.004373101922344779"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.02800854499794347"}], ",", "0.01601631286646424", ",", 
           RowBox[{"-", "0.003418209781927732"}], ",", 
           "0.0003219647132748874", ",", 
           RowBox[{"-", "0.00001129371263529833"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.0001065625376311418", ",", 
           RowBox[{"-", "0.00006047265278753156"}], ",", 
           "0.00001280942436210207", ",", 
           RowBox[{"-", "1.198431804357865*^-6"}], ",", 
           "4.178918882114676*^-8"}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<NORWAY\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<SS\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2RRMS\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "4.25", ",", "\"\<MAXMAG:\>\"",
            ",", "6.75", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<MEAN\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"294.8807310716014", ",", 
           RowBox[{"-", "218.3017995328813"}], ",", "62.67120749028874", ",", 
           
           RowBox[{"-", "7.971135710010484"}], ",", "0.3806565666778833"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "4.396828599957886"}], ",", "3.107261003082868", ",", 
           
           RowBox[{"-", "0.8507996921791916"}], ",", "0.1006142011393272", ",", 
           RowBox[{"-", "0.004254831168924653"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.03445956234574848", ",", 
           RowBox[{"-", "0.02495407142504911"}], ",", "0.006976517344765563", 
           ",", 
           RowBox[{"-", "0.000846314678168489"}], ",", 
           "0.00003705736047784398"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.00007879820677203721"}], ",", 
           "0.00005789011427441287", ",", 
           RowBox[{"-", "0.00001639594896326215"}], ",", 
           "2.018564917242785*^-6", ",", 
           RowBox[{"-", "9.002921643809613*^-8"}]}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<NORWAY\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<SS\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2RRMS\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "4.25", ",", "\"\<MAXMAG:\>\"",
            ",", "6.75", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<SIGMA\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"236.691786953623", ",", 
           RowBox[{"-", "181.8473657902559"}], ",", "52.85026176731316", ",", 
           
           RowBox[{"-", "6.792672444529815"}], ",", "0.3249446194853219"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "6.266515157442228"}], ",", "4.722654660941101", ",", 
           
           RowBox[{"-", "1.327764157497842"}], ",", "0.1629040172973523", ",", 
           RowBox[{"-", "0.007297581054392432"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.05935828326289095", ",", 
           RowBox[{"-", "0.04497265379820889"}], ",", "0.01268462893253498", ",", 
           RowBox[{"-", "0.001564269992918487"}], ",", 
           "0.00007076698673201849"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.000155538326574616"}], ",", 
           "0.0001181060921705031", ",", 
           RowBox[{"-", "0.00003336114838329409"}], ",", 
           "4.124456905977127*^-6", ",", 
           RowBox[{"-", "1.87478498626845*^-7"}]}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<NORWAY\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<SS\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2RRMS\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "6.75", ",", "\"\<MAXMAG:\>\"",
            ",", "8.25", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<MEAN\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"31786.35020858883", ",", 
           RowBox[{"-", "17562.74784863289"}], ",", "3639.49792479362", ",", 
           RowBox[{"-", "335.268182476705"}], ",", "11.59175981945562"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "630.9374741177818"}], ",", "340.4993204914058", ",", 
           
           RowBox[{"-", "68.72383615410561"}], ",", "6.143453150034125", ",", 
           
           RowBox[{"-", "0.2050535311183121"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"7.037817353270648", ",", 
           RowBox[{"-", "3.768904271735839"}], ",", "0.7548461195620768", ",", 
           RowBox[{"-", "0.06698377793657262"}], ",", 
           "0.002221064917973484"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.01916417122068471"}], ",", "0.01022523093033332", ",", 
           RowBox[{"-", "0.002040135486035623"}], ",", 
           "0.0001803390101721757", ",", 
           RowBox[{"-", "5.956984648251256*^-6"}]}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<NORWAY\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<SS\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2RRMS\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "6.75", ",", "\"\<MAXMAG:\>\"",
            ",", "8.25", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<SIGMA\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"7261.751916984268", ",", 
           RowBox[{"-", "3922.134702393774"}], ",", "792.1190561772712", ",", 
           
           RowBox[{"-", "70.87583845746153"}], ",", "2.371009875986455"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "908.521494570605"}], ",", "498.5662794969466", ",", 
           RowBox[{"-", "102.4400669770978"}], ",", "9.33765761719497", ",", 
           RowBox[{"-", "0.3184467011367839"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"4.189931177089474", ",", 
           RowBox[{"-", "2.29942316094012"}], ",", "0.4728958185114604", ",", 
           
           RowBox[{"-", "0.04318543899352201"}], ",", 
           "0.001476905645641484"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.005574393782747104"}], ",", "0.00303101480980732", 
           ",", 
           RowBox[{"-", "0.0006180321322804363"}], ",", 
           "0.00005599810314411189", ",", 
           RowBox[{"-", "1.901302368812866*^-6"}]}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<NORWAY\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<SS\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2RRMSSEIS\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "4.25", ",", "\"\<MAXMAG:\>\"",
            ",", "6.75", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<MEAN\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"199.8712072771777", ",", 
           RowBox[{"-", "143.5167923212303"}], ",", "40.71054445787054", ",", 
           
           RowBox[{"-", "5.119842716025579"}], ",", "0.2425899215469782"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "2.349426460613448"}], ",", "1.503081408705254", ",", 
           
           RowBox[{"-", "0.382114383895278"}], ",", "0.04011569502127482", ",", 
           RowBox[{"-", "0.001345709397923469"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.02032656151705063", ",", 
           RowBox[{"-", "0.01389848012708883"}], ",", "0.003751973017054165", 
           ",", 
           RowBox[{"-", "0.0004308856732196994"}], ",", 
           "0.00001712728380813215"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.00004857712954314678"}], ",", 
           "0.00003427143995161637", ",", 
           RowBox[{"-", "9.51348090864575*^-6"}], ",", 
           "1.132736450331408*^-6", ",", 
           RowBox[{"-", "4.758024863465323*^-8"}]}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<NORWAY\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<SS\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2RRMSSEIS\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "4.25", ",", "\"\<MAXMAG:\>\"",
            ",", "6.75", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<SIGMA\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"224.373926956289", ",", 
           RowBox[{"-", "169.5754295702094"}], ",", "48.46224086276081", ",", 
           
           RowBox[{"-", "6.116643436210651"}], ",", "0.2872996649098772"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "5.349447615990447"}], ",", "3.945477854800022", ",", 
           
           RowBox[{"-", "1.083452669084458"}], ",", "0.1291433364025111", ",", 
           RowBox[{"-", "0.005577175833303544"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.05059726583668445", ",", 
           RowBox[{"-", "0.03769953768772395"}], ",", "0.01044243197043256", ",", 
           RowBox[{"-", "0.001260220608278116"}], ",", 
           "0.00005553728888462611"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.0001336458925289645"}], ",", 
           "0.0001000704008492255", ",", 
           RowBox[{"-", "0.00002784222045222641"}], ",", 
           "3.381558275093976*^-6", ",", 
           RowBox[{"-", "1.505204592821338*^-7"}]}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<NORWAY\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<SS\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2RRMSSEIS\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "6.75", ",", "\"\<MAXMAG:\>\"",
            ",", "8.25", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<MEAN\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"27911.28850147136", ",", 
           RowBox[{"-", "15433.36425725702"}], ",", "3201.872104610442", ",", 
           
           RowBox[{"-", "295.3864799555191"}], ",", "10.23093345218357"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "556.96557274783"}], ",", "299.9517583611485", ",", 
           RowBox[{"-", "60.40840908115952"}], ",", "5.386948783765225", ",", 
           
           RowBox[{"-", "0.1792721095932659"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"6.576744616379806", ",", 
           RowBox[{"-", "3.515979377956148"}], ",", "0.702935453992848", ",", 
           
           RowBox[{"-", "0.0622568510025905"}], ",", "0.00205979602155053"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.01822008845507388"}], ",", "0.00970691872927036", ",", 
           RowBox[{"-", "0.001933665292320441"}], ",", 
           "0.0001706350243917937", ",", 
           RowBox[{"-", "5.625575037164226*^-6"}]}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<NORWAY\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<SS\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2RRMSSEIS\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "6.75", ",", "\"\<MAXMAG:\>\"",
            ",", "8.25", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<SIGMA\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"9018.21354037767", ",", 
           RowBox[{"-", "4915.771619858952"}], ",", "1002.750519440977", ",", 
           
           RowBox[{"-", "90.6923982205211"}], ",", "3.068797975262505"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "956.71736011562"}], ",", "525.6506832135286", ",", 
           RowBox[{"-", "108.1463720116846"}], ",", "9.87154483711152", ",", 
           RowBox[{"-", "0.3371537006914155"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"4.544811692252184", ",", 
           RowBox[{"-", "2.498748293139847"}], ",", "0.5148745381647906", ",", 
           RowBox[{"-", "0.04711207953524357"}], ",", 
           "0.001614481883105377"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.006370058537984748"}], ",", "0.003477760917559674",
            ",", 
           RowBox[{"-", "0.000712091689897753"}], ",", 
           "0.00006479439611004906", ",", 
           RowBox[{"-", "2.209451623762924*^-6"}]}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#FILEEND\>\"", "}"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\"\<NORWAYTF\>\"", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          
          RowBox[{"\"\<#FILEBEGIN\>\"", 
           ",", "\"\<NORWAYTF_CVCOEFFS.txt\>\""}], "}"}], ",", 
         RowBox[{"{", "\"\<#COMMENTBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<comment\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#COMMENTEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<NORWAY\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<TF\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2REPI\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "4.25", ",", "\"\<MAXMAG:\>\"",
            ",", "6.75", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<MEAN\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"67.61687677875153", ",", 
           RowBox[{"-", "56.27422573479913"}], ",", "17.78617781729772", ",", 
           
           RowBox[{"-", "2.53887170082347"}], ",", "0.1411376265219335"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"4.024591829468863", ",", 
           RowBox[{"-", "3.210832536338597"}], ",", "0.958530161282887", ",", 
           
           RowBox[{"-", "0.1271626873457321"}], ",", "0.006346736909215132"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.01964643770672825"}], ",", "0.01612350881711341", ",", 
           RowBox[{"-", "0.004955135035910736"}], ",", 
           "0.0006776386656544382", ",", 
           RowBox[{"-", "0.00003494609715553102"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.00001328444081958754", ",", 
           RowBox[{"-", "0.00001263963749374253"}], ",", 
           "4.421464767377707*^-6", ",", 
           RowBox[{"-", "6.802136572429325*^-7"}], ",", 
           "3.92202781987256*^-8"}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<NORWAY\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<TF\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2REPI\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "4.25", ",", "\"\<MAXMAG:\>\"",
            ",", "6.75", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<SIGMA\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"196.9570285113488", ",", 
           RowBox[{"-", "157.5470520634864"}], ",", "47.34619667822891", ",", 
           
           RowBox[{"-", "6.352778207746185"}], ",", "0.3233192933020597"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1.692881061529763", ",", 
           RowBox[{"-", "1.36240457116401"}], ",", "0.4098824286763166", ",", 
           
           RowBox[{"-", "0.05466552960823038"}], ",", 
           "0.002729990663366196"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.005359289453911689"}], ",", "0.00471095974948933", 
           ",", 
           RowBox[{"-", "0.001541305409351082"}], ",", "0.000222615909598309",
            ",", 
           RowBox[{"-", "0.00001199654282700514"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.00001565581392984061"}], ",", 
           "0.00001044968274479892", ",", 
           RowBox[{"-", "2.473017150141532*^-6"}], ",", 
           "2.373443080598147*^-7", ",", 
           RowBox[{"-", "7.06891128623569*^-9"}]}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<NORWAY\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<TF\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2REPI\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "6.75", ",", "\"\<MAXMAG:\>\"",
            ",", "8.25", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<MEAN\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"25574.36567933765", ",", 
           RowBox[{"-", "14182.79838996319"}], ",", "2949.474483851741", ",", 
           
           RowBox[{"-", "272.7598274902382"}], ",", "9.47560567701941"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1364.489699229327"}], ",", "744.0292293116121", ",", 
           
           RowBox[{"-", "151.9519791265629"}], ",", "13.77351812948102", ",", 
           
           RowBox[{"-", "0.4674043325681984"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"16.92459625226252", ",", 
           RowBox[{"-", "9.16915945956586"}], ",", "1.860137257513416", ",", 
           RowBox[{"-", "0.1674594622214771"}], ",", "0.005643527885056491"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.04907969479438943"}], ",", "0.02649903740220592", ",", 
           RowBox[{"-", "0.005356944598127591"}], ",", 
           "0.0004805261584137778", ",", 
           RowBox[{"-", "0.00001613518887116124"}]}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<NORWAY\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<TF\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2REPI\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "6.75", ",", "\"\<MAXMAG:\>\"",
            ",", "8.25", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<SIGMA\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"28185.03378893221", ",", 
           RowBox[{"-", "15563.35433840363"}], ",", "3224.031676863046", ",", 
           
           RowBox[{"-", "297.1541689203219"}], ",", "10.29393107047442"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "2008.273358261266"}], ",", "1090.640437494039", ",", 
           
           RowBox[{"-", "221.8323337631448"}], ",", "20.02715091384743", ",", 
           
           RowBox[{"-", "0.677077436585277"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"24.30852886467065", ",", 
           RowBox[{"-", "13.15591397019924"}], ",", "2.666287950135467", ",", 
           
           RowBox[{"-", "0.2398210106916696"}], ",", "0.008076877793076222"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.0689573075377901"}], ",", "0.03723240166252711", ",", 
           RowBox[{"-", "0.007527414421545879"}], ",", 
           "0.0006753465553590693", ",", 
           RowBox[{"-", "0.00002268552368793203"}]}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<NORWAY\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<TF\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2RHYP\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "4.25", ",", "\"\<MAXMAG:\>\"",
            ",", "6.75", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<MEAN\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "485.1569849061697"}], ",", "364.6448668342626", ",", 
           
           RowBox[{"-", "98.5023501681417"}], ",", "11.69224148898788", ",", 
           RowBox[{"-", "0.511864439373935"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"15.00500790710418", ",", 
           RowBox[{"-", "11.50407358136351"}], ",", "3.234506416049185", ",", 
           
           RowBox[{"-", "0.4035686417116964"}], ",", "0.01892957177819983"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.0950208093898707"}], ",", "0.07280195725499941", ",", 
           RowBox[{"-", "0.02045548817716219"}], ",", "0.002552641504502813", 
           ",", 
           RowBox[{"-", "0.0001199366683840768"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.0001764124288966513", ",", 
           RowBox[{"-", "0.0001349423092242706"}], ",", 
           "0.0000377893631591653", ",", 
           RowBox[{"-", "4.706133605588827*^-6"}], ",", 
           "2.212019555893053*^-7"}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<NORWAY\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<TF\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2RHYP\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "4.25", ",", "\"\<MAXMAG:\>\"",
            ",", "6.75", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<SIGMA\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"918.899891641817", ",", 
           RowBox[{"-", "684.3199733790552"}], ",", "191.2061388386268", ",", 
           
           RowBox[{"-", "23.5816814443701"}], ",", "1.083367156781744"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "12.72152704927255"}], ",", "9.13877644989823", ",", 
           RowBox[{"-", "2.440263816734445"}], ",", "0.2834945128159232", ",", 
           RowBox[{"-", "0.01201519458633596"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.0881242789570507", ",", 
           RowBox[{"-", "0.06318053590466023"}], ",", "0.01679569777823223", ",", 
           RowBox[{"-", "0.001939492922250582"}], ",", 
           "0.00008158762162625612"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.0002108266685867626"}], ",", 
           "0.0001520038988237765", ",", 
           RowBox[{"-", "0.00004062428988580869"}], ",", 
           "4.723618751169651*^-6", ",", 
           RowBox[{"-", "2.006483421690486*^-7"}]}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<NORWAY\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<TF\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2RHYP\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "6.75", ",", "\"\<MAXMAG:\>\"",
            ",", "8.25", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<MEAN\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"13052.98881477395", ",", 
           RowBox[{"-", "7237.535436269626"}], ",", "1511.695905791586", ",", 
           
           RowBox[{"-", "140.9487170267022"}], ",", "4.958558510567681"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1035.96205570182"}], ",", "563.6343152699425", ",", 
           RowBox[{"-", "114.9424846779339"}], ",", "10.40874922854139", ",", 
           
           RowBox[{"-", "0.3529850918263712"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"14.1924569681567", ",", 
           RowBox[{"-", "7.675137839543817"}], ",", "1.554762725345093", ",", 
           
           RowBox[{"-", "0.1397918831439635"}], ",", "0.004705760589468964"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.04239638591638684"}], ",", "0.02285211346394823", ",", 
           RowBox[{"-", "0.004612943733872812"}], ",", 
           "0.0004132386556548578", ",", 
           RowBox[{"-", "0.00001385841999466668"}]}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<NORWAY\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<TF\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2RHYP\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "6.75", ",", "\"\<MAXMAG:\>\"",
            ",", "8.25", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<SIGMA\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"30653.35166282808", ",", 
           RowBox[{"-", "16866.16750097104"}], ",", "3483.698794039989", ",", 
           
           RowBox[{"-", "320.3011279220474"}], ",", "11.0710399655654"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "2031.967903486448"}], ",", "1103.179669742539", ",", 
           
           RowBox[{"-", "224.3682183467147"}], ",", "20.25890733430078", ",", 
           
           RowBox[{"-", "0.6851124006284718"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"24.40729411937474", ",", 
           RowBox[{"-", "13.20875895294836"}], ",", "2.677239928938125", ",", 
           
           RowBox[{"-", "0.2408567828839233"}], ",", "0.008114211776790243"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.06911807841807124"}], ",", "0.03731978820657714", ",", 
           RowBox[{"-", "0.007545996356524867"}], ",", 
           "0.0006771590657302143", ",", 
           RowBox[{"-", "0.00002275293393862182"}]}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<NORWAY\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<TF\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2RRUP\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "4.25", ",", "\"\<MAXMAG:\>\"",
            ",", "6.75", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<MEAN\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "615.0903246528692"}], ",", "468.5886066943181", ",", 
           
           RowBox[{"-", "129.4082714030386"}], ",", "15.79442157356845", ",", 
           
           RowBox[{"-", "0.7198523762218662"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"11.82310578282994", ",", 
           RowBox[{"-", "8.966046918632156"}], ",", "2.465126722906843", ",", 
           
           RowBox[{"-", "0.2993552767013734"}], ",", "0.0135741185262081"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.07860117707909792"}], ",", "0.05948282094482074", ",", 
           RowBox[{"-", "0.01631902851571768"}], ",", "0.001977208815429966", 
           ",", 
           RowBox[{"-", "0.00008945968906141311"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.0001666619151943515", ",", 
           RowBox[{"-", "0.0001259559182229015"}], ",", 
           "0.00003451115732735322", ",", 
           RowBox[{"-", "4.176081418017954*^-6"}], ",", 
           "1.88735089027742*^-7"}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<NORWAY\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<TF\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2RRUP\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "4.25", ",", "\"\<MAXMAG:\>\"",
            ",", "6.75", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<SIGMA\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"569.8829946487617", ",", 
           RowBox[{"-", "411.7326994400129"}], ",", "111.8497855270659", ",", 
           
           RowBox[{"-", "13.37899746490387"}], ",", "0.5946109572980947"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "10.81253796059191"}], ",", "7.861293154997617", ",", 
           
           RowBox[{"-", "2.143418200788688"}], ",", "0.257079211468842", ",", 
           
           RowBox[{"-", "0.01143918910631012"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.07018154963212281", ",", 
           RowBox[{"-", "0.05111571852271413"}], ",", "0.01394704445881963", ",", 
           RowBox[{"-", "0.001673060833187487"}], ",", 
           "0.00007439745493758542"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.0001446229744900177"}], ",", 
           "0.0001053861133780498", ",", 
           RowBox[{"-", "0.00002875395501295101"}], ",", 
           "3.447729186171898*^-6", ",", 
           RowBox[{"-", "1.531578944112916*^-7"}]}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<NORWAY\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<TF\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2RRUP\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "6.75", ",", "\"\<MAXMAG:\>\"",
            ",", "8.25", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<MEAN\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "4206.693876413589"}], ",", "2422.590204844656", ",", 
           
           RowBox[{"-", "517.5012144640937"}], ",", "48.80269458699296", ",", 
           
           RowBox[{"-", "1.715466250875"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"189.154491329639", ",", 
           RowBox[{"-", "104.4403905193243"}], ",", "21.52594053004502", ",", 
           
           RowBox[{"-", "1.965958772294615"}], ",", "0.06714832454738379"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1.702962943039111"}], ",", "0.932838100346152", ",", 
           
           RowBox[{"-", "0.1909104777536527"}], ",", "0.01732112610339578", ",", 
           RowBox[{"-", "0.0005879853088949332"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.004234405367766067", ",", 
           RowBox[{"-", "0.00231211325605698"}], ",", "0.0004718413153161133",
            ",", 
           RowBox[{"-", "0.00004269555569916478"}], ",", 
           "1.445730050401684*^-6"}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<NORWAY\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<TF\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2RRUP\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "6.75", ",", "\"\<MAXMAG:\>\"",
            ",", "8.25", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<SIGMA\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "10900.80116038252"}], ",", "5839.966190021334", ",", 
           
           RowBox[{"-", "1169.309122623611"}], ",", "103.7378758550884", ",", 
           
           RowBox[{"-", "3.439475755747829"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"256.1478450854571", ",", 
           RowBox[{"-", "136.5583679816226"}], ",", "27.21167938647636", ",", 
           
           RowBox[{"-", "2.402599266730603"}], ",", "0.07929503768740596"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1.870970353042219"}], ",", "0.99530968300743", ",", 
           RowBox[{"-", "0.1979133235523063"}], ",", "0.01743750130822206", ",", 
           RowBox[{"-", "0.000574340687735614"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.004170171835387255", ",", 
           RowBox[{"-", "0.002215827414801125"}], ",", 
           "0.0004401021220988145", ",", 
           RowBox[{"-", "0.00003873183107991943"}], ",", 
           "1.27432522551487*^-6"}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<NORWAY\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<TF\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2RSEIS\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "4.25", ",", "\"\<MAXMAG:\>\"",
            ",", "6.75", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<MEAN\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "607.2628252989814"}], ",", "462.4657983645281", ",", 
           
           RowBox[{"-", "127.6240991284808"}], ",", "15.56482354245313", ",", 
           
           RowBox[{"-", "0.7088343178438489"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"11.99211568799267", ",", 
           RowBox[{"-", "9.09544132189889"}], ",", "2.502004067253898", ",", 
           RowBox[{"-", "0.3039926447157665"}], ",", "0.01379117599059279"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.08044406998352166"}], ",", "0.06089887420485293", ",", 
           RowBox[{"-", "0.01672411007874706"}], ",", "0.002028343201951075", 
           ",", 
           RowBox[{"-", "0.0000918627366583387"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.0001716189292658834", ",", 
           RowBox[{"-", "0.000129771012142985"}], ",", 
           "0.00003560431742710367", ",", 
           RowBox[{"-", "4.314303044903195*^-6"}], ",", 
           "1.952418727837713*^-7"}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<NORWAY\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<TF\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2RSEIS\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "4.25", ",", "\"\<MAXMAG:\>\"",
            ",", "6.75", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<SIGMA\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"551.3792772106701", ",", 
           RowBox[{"-", "397.2876665349864"}], ",", "107.6490747962815", ",", 
           
           RowBox[{"-", "12.83954218620374"}], ",", "0.5687782540247189"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "10.71947746042027"}], ",", "7.786691745352868", ",", 
           
           RowBox[{"-", "2.121148990793299"}], ",", "0.2541450763382906", ",", 
           RowBox[{"-", "0.01129497114114809"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.07033311879293452", ",", 
           RowBox[{"-", "0.05121621084371979"}], ",", "0.01397095896729897", ",", 
           RowBox[{"-", "0.001675432838421337"}], ",", 
           "0.00007447505178434169"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.0001450963830938485"}], ",", 
           "0.0001057232535908948", ",", 
           RowBox[{"-", "0.00002884220078219878"}], ",", 
           "3.457748761530576*^-6", ",", 
           RowBox[{"-", "1.535680249953404*^-7"}]}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<NORWAY\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<TF\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2RSEIS\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "6.75", ",", "\"\<MAXMAG:\>\"",
            ",", "8.25", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<MEAN\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "2232.324784415867"}], ",", "1347.234454136359", ",", 
           
           RowBox[{"-", "298.0907024273838"}], ",", "28.92570974811769", ",", 
           
           RowBox[{"-", "1.040808807617691"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"220.0669526420415", ",", 
           RowBox[{"-", "121.0969483058038"}], ",", "24.88720476952168", ",", 
           
           RowBox[{"-", "2.267025245820711"}], ",", "0.07724690657465201"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1.941158275921894"}], ",", "1.061194213816026", ",", 
           
           RowBox[{"-", "0.2168195932113667"}], ",", "0.01964286965947783", ",", 
           RowBox[{"-", "0.0006659131860153876"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.004732065836581918", ",", 
           RowBox[{"-", "0.002580620906956282"}], ",", 
           "0.0005261181998537259", ",", 
           RowBox[{"-", "0.00004756716285905201"}], ",", 
           "1.609528432322975*^-6"}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<NORWAY\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<TF\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2RSEIS\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "6.75", ",", "\"\<MAXMAG:\>\"",
            ",", "8.25", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<SIGMA\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "14151.91425180605"}], ",", "7601.89961038748", ",", 
           RowBox[{"-", "1526.958765145127"}], ",", "135.9659547448482", ",", 
           
           RowBox[{"-", "4.527316273745921"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"258.7777973556273", ",", 
           RowBox[{"-", "137.9931114896317"}], ",", "27.50405433075459", ",", 
           
           RowBox[{"-", "2.428982517352116"}], ",", "0.08018549781934495"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1.754929200141349"}], ",", "0.932853680024182", ",", 
           
           RowBox[{"-", "0.185316765626842"}], ",", "0.01630916565668646", ",", 
           RowBox[{"-", "0.0005364704917990703"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.003834832652407892", ",", 
           RowBox[{"-", "0.002035079387083207"}], ",", 
           "0.0004035976719550724", ",", 
           RowBox[{"-", "0.00003545771851563166"}], ",", 
           "1.164299892883153*^-6"}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<NORWAY\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<TF\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2RRMS\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "4.25", ",", "\"\<MAXMAG:\>\"",
            ",", "6.75", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<MEAN\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "426.4933255907916"}], ",", "318.9648026356076", ",", 
           
           RowBox[{"-", "84.91608423264431"}], ",", "9.91069923744483", ",", 
           RowBox[{"-", "0.4251290837984146"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"12.17879747812959", ",", 
           RowBox[{"-", "9.30195375136433"}], ",", "2.58591055402454", ",", 
           RowBox[{"-", "0.3191053938421784"}], ",", "0.01482360507556617"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.07273123307121332"}], ",", "0.0553092967337295", ",", 
           RowBox[{"-", "0.0152673812486208"}], ",", "0.001871839704063365", ",", 
           RowBox[{"-", "0.00008653771882032096"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.0001396756693518943", ",", 
           RowBox[{"-", "0.0001058351617659899"}], ",", 
           "0.00002902973409393675", ",", 
           RowBox[{"-", "3.539098757754176*^-6"}], ",", 
           "1.629790144138382*^-7"}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<NORWAY\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<TF\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2RRMS\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "4.25", ",", "\"\<MAXMAG:\>\"",
            ",", "6.75", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<SIGMA\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"612.7339415759425", ",", 
           RowBox[{"-", "444.8808427664509"}], ",", "121.3855095006429", ",", 
           
           RowBox[{"-", "14.58368213716209"}], ",", "0.6506144879694644"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "8.60200383085942"}], ",", "5.982124141437737", ",", 
           RowBox[{"-", "1.546573957655462"}], ",", "0.1731013389377274", ",", 
           RowBox[{"-", "0.007020518749258783"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.06089220740441847", ",", 
           RowBox[{"-", "0.04264877999558278"}], ",", "0.01110004883294458", ",", 
           RowBox[{"-", "0.001253880217166825"}], ",", 
           "0.00005158179764308748"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.0001445196540331208"}], ",", "0.0001023235982239", 
           ",", 
           RowBox[{"-", "0.00002693397578130711"}], ",", 
           "3.087087760794978*^-6", ",", 
           RowBox[{"-", "1.295386660524531*^-7"}]}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<NORWAY\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<TF\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2RRMS\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "6.75", ",", "\"\<MAXMAG:\>\"",
            ",", "8.25", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<MEAN\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"3285.652555110633", ",", 
           RowBox[{"-", "1703.490674514672"}], ",", "335.6864497641962", ",", 
           
           RowBox[{"-", "29.82745881708574"}], ",", "1.018678631612384"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "261.2823519606219"}], ",", "134.8402112774184", ",", 
           
           RowBox[{"-", "26.0120014175922"}], ",", "2.218518905132025", ",", 
           RowBox[{"-", "0.07041380156638119"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"4.394974663260704", ",", 
           RowBox[{"-", "2.30963874036582"}], ",", "0.4541974276051317", ",", 
           
           RowBox[{"-", "0.0395894822169849"}], ",", "0.001289724615331516"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.01462742210138434"}], ",", "0.007714034576340477", 
           ",", 
           RowBox[{"-", "0.001522335669063817"}], ",", 
           "0.0001331953885394955", ",", 
           RowBox[{"-", "4.358009276500589*^-6"}]}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<NORWAY\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<TF\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2RRMS\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "6.75", ",", "\"\<MAXMAG:\>\"",
            ",", "8.25", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<SIGMA\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"295.549334821931", ",", 
           RowBox[{"-", "129.6350613809295"}], ",", "21.20474772026713", ",", 
           
           RowBox[{"-", "1.50710472356735"}], ",", "0.03979449594729721"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"34.82469110743654", ",", 
           RowBox[{"-", "17.97188907614012"}], ",", "3.438934475757316", ",", 
           
           RowBox[{"-", "0.2915536938724696"}], ",", "0.00936545507633481"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1.668644906846792"}], ",", "0.8923588668601584", ",", 
           RowBox[{"-", "0.1782195074574016"}], ",", "0.01576633712292548", ",", 
           RowBox[{"-", "0.0005218568389569338"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.005834380482113152", ",", 
           RowBox[{"-", "0.003137250694184493"}], ",", 
           "0.0006305093586410871", ",", 
           RowBox[{"-", "0.00005615454827015083"}], ",", 
           "1.871040893407122*^-6"}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<NORWAY\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<TF\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2RRMSSEIS\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "4.25", ",", "\"\<MAXMAG:\>\"",
            ",", "6.75", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<MEAN\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "446.5212020660471"}], ",", "334.4592524843703", ",", 
           
           RowBox[{"-", "89.37712776521394"}], ",", "10.47660154871036", ",", 
           
           RowBox[{"-", "0.4515805220990377"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"12.44294962115266", ",", 
           RowBox[{"-", "9.4919054064503"}], ",", "2.636475516720016", ",", 
           RowBox[{"-", "0.3249939002890269"}], ",", "0.01507298664815643"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.07342285389158557"}], ",", "0.05567291718262993", ",", 
           RowBox[{"-", "0.01532279618405875"}], ",", "0.001872553142449602", 
           ",", 
           RowBox[{"-", "0.00008625135736775542"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.0001381188934774175", ",", 
           RowBox[{"-", "0.0001041487916622755"}], ",", 
           "0.00002840514156575138", ",", 
           RowBox[{"-", "3.441924406140942*^-6"}], ",", 
           "1.57499946599633*^-7"}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<NORWAY\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<TF\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2RRMSSEIS\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "4.25", ",", "\"\<MAXMAG:\>\"",
            ",", "6.75", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<SIGMA\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"605.3458544709865", ",", 
           RowBox[{"-", "438.6317258480118"}], ",", "119.4410282206897", ",", 
           
           RowBox[{"-", "14.31905117075267"}], ",", "0.6375782745279603"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "8.52435109768336"}], ",", "5.923211029665933", ",", 
           RowBox[{"-", "1.530440177683071"}], ",", "0.1712237238989235", ",", 
           RowBox[{"-", "0.006947356693222634"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.06150336145371573", ",", 
           RowBox[{"-", "0.04314136065611084"}], ",", "0.01125105218264614", ",", 
           RowBox[{"-", "0.001274701397523617"}], ",", 
           "0.00005269327752621352"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.000149109407738546"}], ",", 
           "0.0001058694526909569", ",", 
           RowBox[{"-", "0.00002796034055323147"}], ",", 
           "3.219095310237388*^-6", ",", 
           RowBox[{"-", "1.359579567531234*^-7"}]}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<NORWAY\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<TF\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2RRMSSEIS\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "6.75", ",", "\"\<MAXMAG:\>\"",
            ",", "8.25", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<MEAN\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"5880.575433160049", ",", 
           RowBox[{"-", "3085.339154464365"}], ",", "611.2831722038059", ",", 
           
           RowBox[{"-", "54.23040845218367"}], ",", "1.828510027325917"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "290.1801139207576"}], ",", "149.8118409444901", ",", 
           
           RowBox[{"-", "28.91761615944812"}], ",", "2.469057427342578", ",", 
           
           RowBox[{"-", "0.07852262808432532"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"4.434023031206394", ",", 
           RowBox[{"-", "2.325607307425782"}], ",", "0.4564629449164946", ",", 
           RowBox[{"-", "0.03971388975895834"}], ",", 
           "0.001291569372786214"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.01451300322710547"}], ",", "0.007641061379286227", 
           ",", 
           RowBox[{"-", "0.001505526669997982"}], ",", "0.000131523964543597",
            ",", 
           RowBox[{"-", "4.297211648500447*^-6"}]}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<NORWAY\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<TF\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2RRMSSEIS\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "6.75", ",", "\"\<MAXMAG:\>\"",
            ",", "8.25", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<SIGMA\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"10997.76853512765", ",", 
           RowBox[{"-", "5906.535867083285"}], ",", "1188.317492977567", ",", 
           
           RowBox[{"-", "106.0914018104444"}], ",", "3.546830024205122"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "244.2007572933603"}], ",", "132.9094275474901", ",", 
           
           RowBox[{"-", "27.09127095821492"}], ",", "2.447945733965701", ",", 
           
           RowBox[{"-", "0.08260550637164574"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.3539434716785679", ",", 
           RowBox[{"-", "0.2016625512691743"}], ",", "0.04318854561046551", ",", 
           RowBox[{"-", "0.004101728831296234"}], ",", 
           "0.0001451113051483819"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.001590975895009094", ",", 
           RowBox[{"-", "0.0008418903130994234"}], ",", 
           "0.0001660092691227613", ",", 
           RowBox[{"-", "0.0000144807715425358"}], ",", 
           "4.725007482577429*^-7"}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#FILEEND\>\"", "}"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\"\<SPAINGEN\>\"", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          
          RowBox[{"\"\<#FILEBEGIN\>\"", 
           ",", "\"\<SPAINGEN_CVCOEFFS.txt\>\""}], "}"}], ",", 
         RowBox[{"{", "\"\<#COMMENTBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<comment\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#COMMENTEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<SPAIN\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<GEN\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2REPI\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "4.25", ",", "\"\<MAXMAG:\>\"",
            ",", "6.75", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<MEAN\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"55.94176914632659", ",", 
           RowBox[{"-", "49.56308261415867"}], ",", "16.45766601674025", ",", 
           
           RowBox[{"-", "2.43577840684466"}], ",", "0.1378235933126868"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "4.040482257481584"}], ",", "3.026851445906523", ",", 
           
           RowBox[{"-", "0.8354966074385273"}], ",", "0.100131450581046", ",", 
           RowBox[{"-", "0.004351436511991777"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.04166924122493249", ",", 
           RowBox[{"-", "0.03155972068380217"}], ",", "0.008842972000887166", 
           ",", 
           RowBox[{"-", "0.001082398132912902"}], ",", 
           "0.00004852201612734637"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.0000958942875578751"}], ",", 
           "0.00007307264642695582", ",", 
           RowBox[{"-", "0.00002063049111128778"}], ",", 
           "2.549060235824888*^-6", ",", 
           RowBox[{"-", "1.156213025233665*^-7"}]}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<SPAIN\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<GEN\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2REPI\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "4.25", ",", "\"\<MAXMAG:\>\"",
            ",", "6.75", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<SIGMA\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"21.46272375847198", ",", 
           RowBox[{"-", "23.78276145951348"}], ",", "9.38938348587427", ",", 
           RowBox[{"-", "1.601813380859739"}], ",", "0.1020004105065219"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.3631621195751744"}], ",", "0.1972232538007248", ",", 
           RowBox[{"-", "0.02795825549629034"}], ",", 
           RowBox[{"-", "0.0008874128709714366"}], ",", 
           "0.0003009723375472463"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.01582329527052791", ",", 
           RowBox[{"-", "0.01147137822736067"}], ",", "0.003040503201074264", 
           ",", 
           RowBox[{"-", "0.0003461549504344748"}], ",", 
           "0.00001404935630466952"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.00005092050977633697"}], ",", 
           "0.00003763885773474535", ",", 
           RowBox[{"-", "0.0000102372094360729"}], ",", 
           "1.208327741135163*^-6", ",", 
           RowBox[{"-", "5.177914150333857*^-8"}]}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<SPAIN\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<GEN\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2REPI\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "6.75", ",", "\"\<MAXMAG:\>\"",
            ",", "8.25", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<MEAN\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "25815.93868798836"}], ",", "13912.03025888285", ",", 
           
           RowBox[{"-", "2794.745095889309"}], ",", "247.7448957171004", ",", 
           
           RowBox[{"-", "8.160038489817309"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1165.113169394254"}], ",", "637.7315974756589", ",", 
           
           RowBox[{"-", "130.7518282348335"}], ",", "11.89734045258231", ",", 
           
           RowBox[{"-", "0.4051640654528008"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"16.37914930867665", ",", 
           RowBox[{"-", "8.90717499965304"}], ",", "1.81388681908271", ",", 
           RowBox[{"-", "0.1639093679503774"}], ",", "0.005543631197734983"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.05247077016902158"}], ",", "0.02846810095316803", ",", 
           RowBox[{"-", "0.005783165409662496"}], ",", 
           "0.0005212656295716124", ",", 
           RowBox[{"-", "0.00001758514374385879"}]}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<SPAIN\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<GEN\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2REPI\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "6.75", ",", "\"\<MAXMAG:\>\"",
            ",", "8.25", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<SIGMA\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "57367.17854830076"}], ",", "30961.60090688586", ",", 
           
           RowBox[{"-", "6241.489139773476"}], ",", "556.5767569841065", ",", 
           
           RowBox[{"-", "18.50316811299507"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1254.016878283113", ",", 
           RowBox[{"-", "674.8736441205308"}], ",", "135.8753471521009", ",", 
           
           RowBox[{"-", "12.13012596344576"}], ",", "0.4052099106640797"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "8.046465301209953"}], ",", "4.300866463763503", ",", 
           
           RowBox[{"-", "0.8594829489226931"}], ",", "0.0761130751973275", ",", 
           RowBox[{"-", "0.002520755487420917"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.01285730956686727", ",", 
           RowBox[{"-", "0.00681389768274333"}], ",", "0.001348816926380943", 
           ",", 
           RowBox[{"-", "0.0001182045768551873"}], ",", 
           "3.870741402317957*^-6"}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<SPAIN\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<GEN\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2RHYP\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "4.25", ",", "\"\<MAXMAG:\>\"",
            ",", "6.75", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<MEAN\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"73.43895686495746", ",", 
           RowBox[{"-", "68.85932607626232"}], ",", "24.55566927140282", ",", 
           
           RowBox[{"-", "3.783899579125771"}], ",", "0.2157281062027231"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "4.725469113890293"}], ",", "3.663683672541759", ",", 
           
           RowBox[{"-", "1.068667122844654"}], ",", "0.1360108498415457", ",", 
           RowBox[{"-", "0.006320909806126905"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.04766421642639339", ",", 
           RowBox[{"-", "0.03687750262487734"}], ",", "0.01070488742361226", ",", 
           RowBox[{"-", "0.001360598355407677"}], ",", 
           "0.00006348385668230534"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.0001102942678316324"}], ",", 
           "0.00008559953704859375", ",", 
           RowBox[{"-", "0.00002493375901416152"}], ",", 
           "3.183683407281296*^-6", ",", 
           RowBox[{"-", "1.494351512205528*^-7"}]}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<SPAIN\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<GEN\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2RHYP\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "4.25", ",", "\"\<MAXMAG:\>\"",
            ",", "6.75", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<SIGMA\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"126.9983128678118", ",", 
           RowBox[{"-", "104.4155264320518"}], ",", "33.05569400893916", ",", 
           
           RowBox[{"-", "4.651490605618404"}], ",", "0.2455061850641051"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "2.871085213266877"}], ",", "2.139201031780681", ",", 
           
           RowBox[{"-", "0.5996825388190412"}], ",", "0.07250590755364034", ",", 
           RowBox[{"-", "0.003124741647190395"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.03422681178537523", ",", 
           RowBox[{"-", "0.02575295209654237"}], ",", "0.007235820332302821", 
           ",", 
           RowBox[{"-", "0.0008822634451558292"}], ",", 
           "0.00003892561255191685"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.0000917256449811531"}], ",", 
           "0.00006931926766397245", ",", 
           RowBox[{"-", "0.00001952869079364583"}], ",", 
           "2.392340739292598*^-6", ",", 
           RowBox[{"-", "1.065230528725164*^-7"}]}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<SPAIN\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<GEN\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2RHYP\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "6.75", ",", "\"\<MAXMAG:\>\"",
            ",", "8.25", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<MEAN\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "32992.38264760668"}], ",", "17728.14938253812", ",", 
           
           RowBox[{"-", "3553.088171326776"}], ",", "314.5410939693779", ",", 
           
           RowBox[{"-", "10.36142509918591"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1034.713348663192"}], ",", "568.2633670325557", ",", 
           
           RowBox[{"-", "116.9259015007782"}], ",", "10.67795560319017", ",", 
           
           RowBox[{"-", "0.3649318550010281"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"15.5095063443224", ",", 
           RowBox[{"-", "8.443372194010971"}], ",", "1.721485834532974", ",", 
           
           RowBox[{"-", "0.1557525780744498"}], ",", "0.00527427945006826"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.05058604284270081"}], ",", "0.02746211284616215", ",", 
           RowBox[{"-", "0.005582590305760076"}], ",", 
           "0.0005035462560433216", ",", 
           RowBox[{"-", "0.00001699959024519853"}]}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<SPAIN\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<GEN\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2RHYP\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "6.75", ",", "\"\<MAXMAG:\>\"",
            ",", "8.25", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<SIGMA\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "57133.65455424258"}], ",", "30842.39627676309", ",", 
           
           RowBox[{"-", "6218.165744363638"}], ",", "554.4980761793877", ",", 
           
           RowBox[{"-", "18.43223068921382"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1251.556265020148", ",", 
           RowBox[{"-", "673.7420687829159"}], ",", "135.6728050983211", ",", 
           
           RowBox[{"-", "12.11304218863974"}], ",", "0.4046358904737452"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "8.048153735763641"}], ",", "4.303173554244139", ",", 
           
           RowBox[{"-", "0.8601359570375742"}], ",", "0.07617946465055787", ",", 
           RowBox[{"-", "0.002522987613030092"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.0128886719767113", ",", 
           RowBox[{"-", "0.006833860552152167"}], ",", "0.001353257228050942",
            ",", 
           RowBox[{"-", "0.0001186197425345867"}], ",", 
           "3.88468401641889*^-6"}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<SPAIN\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<GEN\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2RRUP\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "4.25", ",", "\"\<MAXMAG:\>\"",
            ",", "6.75", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<MEAN\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "79.8639266037422"}], ",", "55.9659632611469", ",", 
           RowBox[{"-", "13.33096919866771"}], ",", "1.334591570384491", ",", 
           
           RowBox[{"-", "0.04708207293604218"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2.012483357150632", ",", 
           RowBox[{"-", "1.45131761193116"}], ",", "0.3630432568106496", ",", 
           
           RowBox[{"-", "0.0390904392030495"}], ",", "0.001545587997011835"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.01466483080172756"}], ",", "0.01068030198950977", ",", 
           RowBox[{"-", "0.002708179713907883"}], ",", 
           "0.0002969737554948724", ",", 
           RowBox[{"-", "0.00001204100830244418"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.00003296985192826826", ",", 
           RowBox[{"-", "0.00002415204715633189"}], ",", 
           "6.174639130009271*^-6", ",", 
           RowBox[{"-", "6.842921059561381*^-7"}], ",", 
           "2.812258254535538*^-8"}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<SPAIN\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<GEN\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2RRUP\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "4.25", ",", "\"\<MAXMAG:\>\"",
            ",", "6.75", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<SIGMA\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"103.279062022725", ",", 
           RowBox[{"-", "77.44684930846653"}], ",", "22.29839734877706", ",", 
           
           RowBox[{"-", "2.827956577914999"}], ",", "0.1328222236642704"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1.603720627887994"}], ",", "1.167498053004966", ",", 
           
           RowBox[{"-", "0.3279987500199751"}], ",", "0.04033735281448646", ",", 
           RowBox[{"-", "0.001817259926988674"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.00944180505999024", ",", 
           RowBox[{"-", "0.006690265866034181"}], ",", "0.001834619165441944",
            ",", 
           RowBox[{"-", "0.0002188869237239968"}], ",", 
           "9.46221703816579*^-6"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.00001785838814029247"}], ",", 
           "0.00001233396203265887", ",", 
           RowBox[{"-", "3.304807786569631*^-6"}], ",", 
           "3.825684818776178*^-7", ",", 
           RowBox[{"-", "1.583041493729665*^-8"}]}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<SPAIN\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<GEN\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2RRUP\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "6.75", ",", "\"\<MAXMAG:\>\"",
            ",", "8.25", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<MEAN\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "2676.902558274818"}], ",", "1473.127005779423", ",", 
           
           RowBox[{"-", "302.0319434888229"}], ",", "27.38335886750341", ",", 
           
           RowBox[{"-", "0.926712115010603"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"87.38852793267712", ",", 
           RowBox[{"-", "48.03750068075296"}], ",", "9.84442815924332", ",", 
           RowBox[{"-", "0.8922481559428089"}], ",", "0.0301930709656877"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.7391618752423069"}], ",", "0.4053162620363969", ",", 
           RowBox[{"-", "0.08289476917653606"}], ",", "0.007500174308338919", 
           ",", 
           RowBox[{"-", "0.0002534308242503188"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.001768339640286152", ",", 
           RowBox[{"-", "0.00096851326499991"}], ",", "0.00019788426474773", ",", 
           RowBox[{"-", "0.00001788907020689132"}], ",", 
           "6.040359232903608*^-7"}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<SPAIN\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<GEN\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2RRUP\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "6.75", ",", "\"\<MAXMAG:\>\"",
            ",", "8.25", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<SIGMA\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1323.74623210924", ",", 
           RowBox[{"-", "710.2207101275203"}], ",", "142.5052612254748", ",", 
           
           RowBox[{"-", "12.65326690726739"}], ",", "0.4196999188251236"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "16.65099250356801"}], ",", "8.454495375689566", ",", 
           
           RowBox[{"-", "1.605695884186674"}], ",", "0.1349014679385797", ",", 
           RowBox[{"-", "0.004229319951753277"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.05595259047111744", ",", 
           RowBox[{"-", "0.02553410135138735"}], ",", "0.00427304500137365", ",", 
           RowBox[{"-", "0.0003067959518125774"}], ",", 
           "7.83313982725736*^-6"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.00002435633301891203"}], ",", 
           "2.177333177434662*^-6", ",", "1.630426572596702*^-6", ",", 
           RowBox[{"-", "3.225930469105188*^-7"}], ",", 
           "1.647641709951443*^-8"}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<SPAIN\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<GEN\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2RSEIS\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "4.25", ",", "\"\<MAXMAG:\>\"",
            ",", "6.75", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<MEAN\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "106.1992582097108"}], ",", "76.94335835869767", ",", 
           
           RowBox[{"-", "19.53881098943413"}], ",", "2.141936804726831", ",", 
           
           RowBox[{"-", "0.0858593359464991"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2.454161405248705", ",", 
           RowBox[{"-", "1.807235551970223"}], ",", "0.4696084745556184", ",", 
           RowBox[{"-", "0.05311257031341123"}], ",", 
           "0.002226736715876661"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.01798100933121822"}], ",", "0.0133561861917644", ",", 
           RowBox[{"-", "0.003510410742262605"}], ",", 
           "0.0004026713948607513", ",", 
           RowBox[{"-", "0.00001718238743561472"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.00004055737641324072", ",", 
           RowBox[{"-", "0.00003027809457065513"}], ",", 
           "8.012321139966418*^-6", ",", 
           RowBox[{"-", "9.26575439365185*^-7"}], ",", 
           "3.99174048272317*^-8"}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<SPAIN\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<GEN\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2RSEIS\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "4.25", ",", "\"\<MAXMAG:\>\"",
            ",", "6.75", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<SIGMA\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"119.7803778680102", ",", 
           RowBox[{"-", "90.7743957435847"}], ",", "26.29259172341403", ",", 
           RowBox[{"-", "3.353056882548576"}], ",", "0.1582257845691142"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1.782892781149655"}], ",", "1.320599357451594", ",", 
           
           RowBox[{"-", "0.3762350961326716"}], ",", "0.04695854817478104", ",", 
           RowBox[{"-", "0.002148611255681545"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.00997320492676996", ",", 
           RowBox[{"-", "0.00721197674087316"}], ",", "0.002016663915883884", 
           ",", 
           RowBox[{"-", "0.0002458323612973913"}], ",", 
           "0.0000108810446261237"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.00001795493249104736"}], ",", 
           "0.00001267424054457931", ",", 
           RowBox[{"-", "3.479235324883523*^-6"}], ",", 
           "4.139346393336923*^-7", ",", 
           RowBox[{"-", "1.766692055358691*^-8"}]}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<SPAIN\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<GEN\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2RSEIS\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "6.75", ",", "\"\<MAXMAG:\>\"",
            ",", "8.25", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<MEAN\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1883.408198947238", ",", 
           RowBox[{"-", "967.366241356725"}], ",", "186.251383144211", ",", 
           RowBox[{"-", "15.90650293111097"}], ",", "0.5085279544539727"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"26.54431161718611", ",", 
           RowBox[{"-", "15.33154979495955"}], ",", "3.274034065950788", ",", 
           
           RowBox[{"-", "0.3075907332789239"}], ",", "0.0107462012398394"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.3097719810870872"}], ",", "0.174403091222902", ",", 
           RowBox[{"-", "0.03648974684034278"}], ",", "0.003369806534697534", 
           ",", 
           RowBox[{"-", "0.0001160215928119936"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.0008415075930792498", ",", 
           RowBox[{"-", "0.0004699309944215515"}], ",", 
           "0.0000976661593558354", ",", 
           RowBox[{"-", "8.967976721826452*^-6"}], ",", 
           "3.072435595765009*^-7"}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<SPAIN\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<GEN\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2RSEIS\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "6.75", ",", "\"\<MAXMAG:\>\"",
            ",", "8.25", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<SIGMA\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "2022.017216969306"}], ",", "1080.446539482024", ",", 
           
           RowBox[{"-", "215.9054696945426"}], ",", "19.1438864821694", ",", 
           RowBox[{"-", "0.6354785517861454"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"37.76910659014203", ",", 
           RowBox[{"-", "20.78390494616717"}], ",", "4.269507517735349", ",", 
           
           RowBox[{"-", "0.3883607399865806"}], ",", "0.01320018625257324"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.3653686392341144"}], ",", "0.2009576195884341", ",", 
           RowBox[{"-", "0.04126829288801263"}], ",", "0.003752224651723124", 
           ",", 
           RowBox[{"-", "0.0001274772342348622"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.001019756939973055", ",", 
           RowBox[{"-", "0.0005586548130703988"}], ",", "0.00011431551715896",
            ",", 
           RowBox[{"-", "0.00001035951428057774"}], ",", 
           "3.508784165470807*^-7"}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<SPAIN\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<GEN\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2RRMS\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "4.25", ",", "\"\<MAXMAG:\>\"",
            ",", "6.75", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<MEAN\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "18.43128597900583"}], ",", "3.797148059856008", ",", 
           "3.376701169506758", ",", 
           RowBox[{"-", "1.058963077261051"}], ",", "0.08533960391179986"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "3.182786920202026"}], ",", "2.474777439885155", ",", 
           
           RowBox[{"-", "0.7337639374246431"}], ",", "0.0945196817377459", ",", 
           RowBox[{"-", "0.004420088583471034"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.04522331446995422", ",", 
           RowBox[{"-", "0.03514737823496127"}], ",", "0.01030030417446383", ",", 
           RowBox[{"-", "0.001322248505950198"}], ",", 
           "0.00006240597080012084"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.0001369666900173627"}], ",", 
           "0.0001064057348909465", ",", 
           RowBox[{"-", "0.00003107444038588929"}], ",", 
           "3.984251768873931*^-6", ",", 
           RowBox[{"-", "1.884974984428758*^-7"}]}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<SPAIN\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<GEN\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2RRMS\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "4.25", ",", "\"\<MAXMAG:\>\"",
            ",", "6.75", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<SIGMA\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"113.5377920572902", ",", 
           RowBox[{"-", "86.80597718478079"}], ",", "25.52829979758308", ",", 
           
           RowBox[{"-", "3.322553862563822"}], ",", "0.1611032098346965"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "3.408956175661839"}], ",", "2.465319360242086", ",", 
           
           RowBox[{"-", "0.6660001102413657"}], ",", "0.07736884657121107", ",", 
           RowBox[{"-", "0.003194465048256987"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.0421143043637382", ",", 
           RowBox[{"-", "0.03116320165033465"}], ",", "0.00859437319674379", ",", 
           RowBox[{"-", "0.001031122902555055"}], ",", 
           "0.00004502117856480215"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.0001246921032181311"}], ",", 
           "0.0000929594059997758", ",", 
           RowBox[{"-", "0.00002580968299984"}], ",", "3.128811784385259*^-6",
            ",", 
           RowBox[{"-", "1.389565786407243*^-7"}]}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<SPAIN\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<GEN\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2RRMS\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "6.75", ",", "\"\<MAXMAG:\>\"",
            ",", "8.25", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<MEAN\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1591.723988912716", ",", 
           RowBox[{"-", "1082.857791083844"}], ",", "272.3830793918153", ",", 
           
           RowBox[{"-", "30.07556896557291"}], ",", "1.237626159256271"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "810.035892679508"}], ",", "440.2483192707564", ",", 
           RowBox[{"-", "89.58786408538901"}], ",", "8.085295079354992", ",", 
           
           RowBox[{"-", "0.2728485510625254"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"11.39425711622017", ",", 
           RowBox[{"-", "6.150035314416001"}], ",", "1.24301691075605", ",", 
           RowBox[{"-", "0.1114728557599951"}], ",", "0.003741362492635909"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.03647494873507647"}], ",", "0.01965236443163139", ",", 
           RowBox[{"-", "0.003964839923438198"}], ",", 
           "0.0003549359842917008", ",", 
           RowBox[{"-", "0.00001189364998696972"}]}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<SPAIN\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<GEN\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2RRMS\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "6.75", ",", "\"\<MAXMAG:\>\"",
            ",", "8.25", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<SIGMA\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"12015.81823209084", ",", 
           RowBox[{"-", "6594.683971759755"}], ",", "1355.653207549705", ",", 
           
           RowBox[{"-", "123.6767637104451"}], ",", "4.225092983513326"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "682.2846825295126"}], ",", "381.8510803869273", ",", 
           
           RowBox[{"-", "80.04512260770221"}], ",", "7.445203475829427", ",", 
           
           RowBox[{"-", "0.2590886917974304"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2.222284325962173", ",", 
           RowBox[{"-", "1.270513129319001"}], ",", "0.2725442394768", ",", 
           RowBox[{"-", "0.02597880110507147"}], ",", 
           "0.000927420047725866"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.001878142612524538"}], ",", "0.001114897981381525",
            ",", 
           RowBox[{"-", "0.0002490889967789742"}], ",", 
           "0.00002476549059674438", ",", 
           RowBox[{"-", "9.2210566001739*^-7"}]}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<SPAIN\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<GEN\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2RRMSSEIS\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "4.25", ",", "\"\<MAXMAG:\>\"",
            ",", "6.75", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<MEAN\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"25.73958660676468", ",", 
           RowBox[{"-", "30.39826195780483"}], ",", "13.19711839471902", ",", 
           
           RowBox[{"-", "2.298199096484552"}], ",", "0.1431508363427979"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "4.040299659564692"}], ",", "3.149473140696982", ",", 
           
           RowBox[{"-", "0.930862274138232"}], ",", "0.1198600123824584", ",", 
           RowBox[{"-", "0.005627696131292174"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.05062074901607144", ",", 
           RowBox[{"-", "0.03944791518489914"}], ",", "0.01157227097904049", ",", 
           RowBox[{"-", "0.001487836377371316"}], ",", 
           "0.00007039968237215879"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.00014769544165865"}], ",", "0.0001150521235998597",
            ",", 
           RowBox[{"-", "0.0000336593613294392"}], ",", 
           "4.324243141715216*^-6", ",", 
           RowBox[{"-", "2.050759051253699*^-7"}]}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<SPAIN\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<GEN\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2RRMSSEIS\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "4.25", ",", "\"\<MAXMAG:\>\"",
            ",", "6.75", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<SIGMA\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"109.5489711759204", ",", 
           RowBox[{"-", "82.25646034352177"}], ",", "23.76261956944334", ",", 
           
           RowBox[{"-", "3.035257645884883"}], ",", "0.1445972090508978"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "3.03748339616926"}], ",", "2.138649009225674", ",", 
           RowBox[{"-", "0.5600670603364482"}], ",", "0.0623481904210936", ",", 
           RowBox[{"-", "0.002415522544894763"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.03830651270967978", ",", 
           RowBox[{"-", "0.02793355613702266"}], ",", "0.007580015549430013", 
           ",", 
           RowBox[{"-", "0.0008913966901306126"}], ",", 
           "0.00003795192986086826"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.0001151914583949169"}], ",", 
           "0.00008498291901544962", ",", 
           RowBox[{"-", "0.00002332874703253665"}], ",", 
           "2.790294558472237*^-6", ",", 
           RowBox[{"-", "1.219782679076547*^-7"}]}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<SPAIN\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<GEN\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2RRMSSEIS\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "6.75", ",", "\"\<MAXMAG:\>\"",
            ",", "8.25", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<MEAN\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"907.94052932634", ",", 
           RowBox[{"-", "703.5493369763892"}], ",", "194.2515306331663", ",", 
           
           RowBox[{"-", "22.97738249054477"}], ",", "0.996775648159378"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "824.2114536790547"}], ",", "447.8341144760474", ",", 
           
           RowBox[{"-", "91.1158802387208"}], ",", "8.22230020264689", ",", 
           RowBox[{"-", "0.2774448291697627"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"11.58929260131586", ",", 
           RowBox[{"-", "6.255148883008562"}], ",", "1.264273969440132", ",", 
           
           RowBox[{"-", "0.1133823096189903"}], ",", "0.003805525286083924"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.03699626761997456"}], ",", "0.01993365142259431", ",", 
           RowBox[{"-", "0.004021756640384348"}], ",", 
           "0.0003600495785400276", ",", 
           RowBox[{"-", "0.00001206551064241264"}]}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<SPAIN\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<GEN\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2RRMSSEIS\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "6.75", ",", "\"\<MAXMAG:\>\"",
            ",", "8.25", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<SIGMA\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"8405.666257718565", ",", 
           RowBox[{"-", "4616.380083426717"}], ",", "950.160607513204", ",", 
           RowBox[{"-", "86.82810980481861"}], ",", "2.972420485338594"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "588.7623984029294"}], ",", "330.5374063069036", ",", 
           
           RowBox[{"-", "69.51509172567359"}], ",", "6.487288967170517", ",", 
           
           RowBox[{"-", "0.226493936477563"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1.533966980589013", ",", 
           RowBox[{"-", "0.8926932307345695"}], ",", "0.1949841435434966", ",", 
           RowBox[{"-", "0.01892095813163422"}], ",", 
           "0.0006872004943149841"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.0003800621867242428"}], ",", 
           "0.0002919587731213786", ",", 
           RowBox[{"-", "0.00008003258591316808"}], ",", 
           "9.37144563489207*^-6", ",", 
           RowBox[{"-", "3.978355026670474*^-7"}]}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#FILEEND\>\"", "}"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\"\<WCGEN\>\"", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\"\<#FILEBEGIN\>\"", ",", "\"\<WCGEN_CVCOEFFS.txt\>\""}], 
          "}"}], ",", 
         RowBox[{"{", "\"\<#COMMENTBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<comment\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#COMMENTEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<WC\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<GEN\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2REPI\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "3.25", ",", "\"\<MAXMAG:\>\"",
            ",", "6.75", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<MEAN\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"37.56823491544904", ",", 
           RowBox[{"-", "34.79240446642353"}], ",", "12.03165043415702", ",", 
           
           RowBox[{"-", "1.848790428245894"}], ",", "0.1090071080638259"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.08570922004737586", ",", 
           RowBox[{"-", "0.1204378855373826"}], ",", "0.05815267595430025", ",", 
           RowBox[{"-", "0.01182937207279993"}], ",", "0.00087151505976398"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.002003679634478654"}], ",", "0.002068960696728719",
            ",", 
           RowBox[{"-", "0.0008034959839166398"}], ",", 
           "0.0001394269006193326", ",", 
           RowBox[{"-", "9.14199882601714*^-6"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"9.3189532539538*^-6", ",", 
           RowBox[{"-", "8.766409768480058*^-6"}], ",", 
           "3.095546393706173*^-6", ",", 
           RowBox[{"-", "4.892056319514348*^-7"}], ",", 
           "2.938155513301348*^-8"}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<WC\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<GEN\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2REPI\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "3.25", ",", "\"\<MAXMAG:\>\"",
            ",", "6.75", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<SIGMA\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"54.52004876372663", ",", 
           RowBox[{"-", "50.53031934435768"}], ",", "17.44405480437523", ",", 
           
           RowBox[{"-", "2.66754113165889"}], ",", "0.1541479818149187"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.270748630890583"}], ",", "0.2065669082479948", ",", 
           RowBox[{"-", "0.05423915245786365"}], ",", "0.005449599465644776", 
           ",", 
           RowBox[{"-", "0.0001395971269912178"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.001526773480556006", ",", 
           RowBox[{"-", "0.001046719577839023"}], ",", 
           "0.0002218383458568911", ",", 
           RowBox[{"-", "0.00001106800566002623"}], ",", 
           RowBox[{"-", "7.293819521276374*^-7"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "9.19226666007283*^-7"}], ",", 
           "8.664893544198687*^-8", ",", "2.549866046113387*^-7", ",", 
           RowBox[{"-", "8.482918272059111*^-8"}], ",", 
           "7.550703413523224*^-9"}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<WC\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<GEN\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2REPI\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "6.75", ",", "\"\<MAXMAG:\>\"",
            ",", "8.25", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<MEAN\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"9573.31486837819", ",", 
           RowBox[{"-", "5621.310410233716"}], ",", "1238.630376057894", ",", 
           
           RowBox[{"-", "121.4725237445739"}], ",", "4.481090354269162"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"543.748591139641", ",", 
           RowBox[{"-", "289.8376445711757"}], ",", "57.79524645993229", ",", 
           
           RowBox[{"-", "5.112048935713558"}], ",", "0.1693923286480993"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "12.08974798862174"}], ",", "6.492698621162019", ",", 
           
           RowBox[{"-", "1.30525958024886"}], ",", "0.1164401943576273", ",", 
           
           RowBox[{"-", "0.003890603060881886"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.04256019993319328", ",", 
           RowBox[{"-", "0.02286568777548439"}], ",", "0.004598944279754574", 
           ",", 
           RowBox[{"-", "0.0004104624296650141"}], ",", 
           "0.00001372006050526491"}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<WC\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<GEN\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2REPI\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "6.75", ",", "\"\<MAXMAG:\>\"",
            ",", "8.25", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<SIGMA\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "13603.35300138971"}], ",", "6854.368328779642", ",", 
           
           RowBox[{"-", "1271.461193921812"}], ",", "102.1511169225927", ",", 
           
           RowBox[{"-", "2.958209732766884"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1098.130069967275", ",", 
           RowBox[{"-", "590.4555191053805"}], ",", "118.7259826085666", ",", 
           
           RowBox[{"-", "10.58089731243092"}], ",", "0.3526830451912465"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "12.11296168749473"}], ",", "6.49611327702054", ",", 
           RowBox[{"-", "1.303023513987198"}], ",", "0.1158632832328704", ",", 
           RowBox[{"-", "0.003853918534925648"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.0370355724324722", ",", 
           RowBox[{"-", "0.01986529248827982"}], ",", "0.003986043192880435", 
           ",", 
           RowBox[{"-", "0.000354619662267759"}], ",", 
           "0.00001180382168588406"}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<WC\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<GEN\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2RHYP\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "3.25", ",", "\"\<MAXMAG:\>\"",
            ",", "6.75", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<MEAN\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"45.72293713599094", ",", 
           RowBox[{"-", "37.52555965352602"}], ",", "12.92455001479265", ",", 
           
           RowBox[{"-", "1.981946583849783"}], ",", "0.1162250829511986"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.1131623335897262"}], ",", 
           RowBox[{"-", "0.04244074377574306"}], ",", "0.03305096547130661", ",", 
           RowBox[{"-", "0.008139610383228002"}], ",", 
           "0.0006774590062947497"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.000613275048467681"}], ",", "0.001534702119088349",
            ",", 
           RowBox[{"-", "0.0006322367304285377"}], ",", 
           "0.0001140866216711953", ",", 
           RowBox[{"-", "7.805690858500496*^-6"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"6.218866643922299*^-6", ",", 
           RowBox[{"-", "7.557978344529947*^-6"}], ",", 
           "2.710084293474603*^-6", ",", 
           RowBox[{"-", "4.322179606513657*^-7"}], ",", 
           "2.637633928891481*^-8"}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<WC\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<GEN\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2RHYP\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "3.25", ",", "\"\<MAXMAG:\>\"",
            ",", "6.75", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<SIGMA\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"50.16769196730002", ",", 
           RowBox[{"-", "44.52961639349291"}], ",", "15.68996005115899", ",", 
           
           RowBox[{"-", "2.434297480353377"}], ",", "0.1402742654661071"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.3416137089307287"}], ",", "0.2156648340482812", ",", 
           RowBox[{"-", "0.05607874731645975"}], ",", "0.004963579174207349", 
           ",", 
           RowBox[{"-", "0.00001315917627095404"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.002473115349027236", ",", 
           RowBox[{"-", "0.001471695795440213"}], ",", 
           "0.0003307444356715051", ",", 
           RowBox[{"-", "0.00001750164592846243"}], ",", 
           RowBox[{"-", "1.30854982105624*^-6"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "3.626342604295634*^-6"}], ",", 
           "1.526784156394455*^-6", ",", 
           RowBox[{"-", "1.201606000726288*^-7"}], ",", 
           RowBox[{"-", "5.614513938946728*^-8"}], ",", 
           "8.305603199250711*^-9"}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<WC\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<GEN\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2RHYP\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "6.75", ",", "\"\<MAXMAG:\>\"",
            ",", "8.25", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<MEAN\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "550.6331373513584"}], ",", 
           RowBox[{"-", "223.6622588210744"}], ",", "162.4413841803194", ",", 
           
           RowBox[{"-", "26.30627914898658"}], ",", "1.330763376444716"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"752.3590499507392", ",", 
           RowBox[{"-", "401.243128837063"}], ",", "80.03898146176442", ",", 
           RowBox[{"-", "7.08132240543056"}], ",", "0.2346418496012735"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "13.5426079586776"}], ",", "7.269229280613729", ",", 
           RowBox[{"-", "1.460421686813001"}], ",", "0.1301858115893852", ",", 
           RowBox[{"-", "0.0043462941456736"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.04572154492354106", ",", 
           RowBox[{"-", "0.02455633895526037"}], ",", "0.004936936211309257", 
           ",", 
           RowBox[{"-", "0.0004404184696248897"}], ",", 
           "0.00001471355196939261"}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<WC\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<GEN\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2RHYP\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "6.75", ",", "\"\<MAXMAG:\>\"",
            ",", "8.25", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<SIGMA\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "10494.44707593767"}], ",", "5227.381726348098", ",", 
           
           RowBox[{"-", "952.208275681684"}], ",", "74.30302471430551", ",", 
           RowBox[{"-", "2.047212660369147"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1027.973042751375", ",", 
           RowBox[{"-", "553.7279158731939"}], ",", "111.5168462750435", ",", 
           
           RowBox[{"-", "9.95183169483868"}], ",", "0.3320953602684801"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "11.61457976258274"}], ",", "6.23502092114931", ",", 
           RowBox[{"-", "1.251736395389597"}], ",", "0.1113845182171963", ",", 
           RowBox[{"-", "0.003707220088493305"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.03593465420837824", ",", 
           RowBox[{"-", "0.01928812997237287"}], ",", "0.003872585607866495", 
           ",", 
           RowBox[{"-", "0.0003447042315253004"}], ",", 
           "0.0000114787988725708"}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<WC\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<GEN\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2RRUP\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "3.25", ",", "\"\<MAXMAG:\>\"",
            ",", "6.75", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<MEAN\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "2.209990929329987"}], ",", "7.053528639527169", ",", 
           
           RowBox[{"-", "2.229911906475452"}], ",", "0.297001981485286", ",", 
           
           RowBox[{"-", "0.01448610085911401"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.0719329993066071", ",", 
           RowBox[{"-", "0.1837653582977645"}], ",", "0.06091747543629485", ",", 
           RowBox[{"-", "0.008608794670931386"}], ",", 
           "0.0004559813963402166"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.0006546493432919246"}], ",", "0.00145747218725043",
            ",", 
           RowBox[{"-", "0.0004888673653895293"}], ",", 
           "0.00007007892110676243", ",", 
           RowBox[{"-", "3.772903691152081*^-6"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1.671097552262351*^-6", ",", 
           RowBox[{"-", "3.439595400043074*^-6"}], ",", 
           "1.159257408145093*^-6", ",", 
           RowBox[{"-", "1.671802960820699*^-7"}], ",", 
           "9.05512525543506*^-9"}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<WC\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<GEN\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2RRUP\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "3.25", ",", "\"\<MAXMAG:\>\"",
            ",", "6.75", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<SIGMA\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "15.82728773584186"}], ",", "16.19092327775289", ",", 
           
           RowBox[{"-", "5.011735107417234"}], ",", "0.664566774583645", ",", 
           
           RowBox[{"-", "0.03179773622782387"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.4892138653617799", ",", 
           RowBox[{"-", "0.4738495207990904"}], ",", "0.1488837940443247", ",", 
           RowBox[{"-", "0.02029883756543968"}], ",", 
           "0.001019530425425681"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.003951058492592401"}], ",", "0.003772327053633583",
            ",", 
           RowBox[{"-", "0.001192264909095345"}], ",", 
           "0.0001640055442118847", ",", 
           RowBox[{"-", "8.343227042563015*^-6"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"9.27293964856598*^-6", ",", 
           RowBox[{"-", "8.801517015803954*^-6"}], ",", 
           "2.79135009922025*^-6", ",", 
           RowBox[{"-", "3.857589024878572*^-7"}], ",", 
           "1.974140204488314*^-8"}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<WC\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<GEN\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2RRUP\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "6.75", ",", "\"\<MAXMAG:\>\"",
            ",", "8.25", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<MEAN\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "9155.41536104597"}], ",", "4876.272488498576", ",", 
           RowBox[{"-", "970.82172006675"}], ",", "85.678776702457", ",", 
           RowBox[{"-", "2.82835382663075"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"193.6805628516809", ",", 
           RowBox[{"-", "102.7864365490186"}], ",", "20.37935912485927", ",", 
           
           RowBox[{"-", "1.790157817881604"}], ",", "0.05879543939654525"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1.308365012504238"}], ",", "0.6927281541266923", ",", 
           RowBox[{"-", "0.1369879776511283"}], ",", "0.01199885836769092", ",", 
           RowBox[{"-", "0.0003928868660983465"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.002846238983709736", ",", 
           RowBox[{"-", "0.001505692982362038"}], ",", 
           "0.0002974804993594429", ",", 
           RowBox[{"-", "0.00002603116149986519"}], ",", 
           "8.515054274551235*^-7"}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<WC\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<GEN\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2RRUP\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "6.75", ",", "\"\<MAXMAG:\>\"",
            ",", "8.25", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<SIGMA\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"4558.927173116687", ",", 
           RowBox[{"-", "2366.679244203115"}], ",", "458.7501990467688", ",", 
           
           RowBox[{"-", "39.3287490160529"}], ",", "1.25885313566882"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "90.8669572371153"}], ",", "46.80450903051801", ",", 
           RowBox[{"-", "9.004707452060291"}], ",", "0.7665685680342438", ",", 
           RowBox[{"-", "0.02437203768279376"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.6520277000980549", ",", 
           RowBox[{"-", "0.3356054259777586"}], ",", "0.06454110679993472", ",", 
           RowBox[{"-", "0.005494521563624221"}], ",", 
           "0.000174759298527192"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.001450937733107419"}], ",", 
           "0.0007468890630110889", ",", 
           RowBox[{"-", "0.0001436783556708109"}], ",", 
           "0.00001223821962464345", ",", 
           RowBox[{"-", "3.895411366606081*^-7"}]}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<WC\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<GEN\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2RSEIS\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "3.25", ",", "\"\<MAXMAG:\>\"",
            ",", "6.75", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<MEAN\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "2.627619335048146"}], ",", "7.418268185091499", ",", 
           
           RowBox[{"-", "2.34286060508899"}], ",", "0.3112795754176229", ",", 
           
           RowBox[{"-", "0.01505116041515459"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.08070916333985095", ",", 
           RowBox[{"-", "0.1914244346029379"}], ",", "0.06332116305644098", ",", 
           RowBox[{"-", "0.008924661054465422"}], ",", 
           "0.0004698006480422866"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.0007259503346590383"}], ",", 
           "0.001520853855404231", ",", 
           RowBox[{"-", "0.0005091994293897485"}], ",", 
           "0.00007282603582700878", ",", 
           RowBox[{"-", "3.898453854407414*^-6"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1.815524685724554*^-6", ",", 
           RowBox[{"-", "3.571859999440164*^-6"}], ",", 
           "1.202961302877744*^-6", ",", 
           RowBox[{"-", "1.732613655323795*^-7"}], ",", 
           "9.34144678623129*^-9"}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<WC\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<GEN\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2RSEIS\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "3.25", ",", "\"\<MAXMAG:\>\"",
            ",", "6.75", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<SIGMA\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "15.17176336380971"}], ",", "15.60017396372937", ",", 
           
           RowBox[{"-", "4.820538754490709"}], ",", "0.6386503478114467", ",", 
           RowBox[{"-", "0.03061810039287956"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.4743127951740396", ",", 
           RowBox[{"-", "0.4605855723285298"}], ",", "0.1446161038245868", ",", 
           RowBox[{"-", "0.01971799256651941"}], ",", 
           "0.000992501286159505"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.003847224511127522"}], ",", "0.003679312186026411",
            ",", 
           RowBox[{"-", "0.001162042064120706"}], ",", 
           "0.0001598290520293273", ",", 
           RowBox[{"-", "8.144133097838456*^-6"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"9.03472689812552*^-6", ",", 
           RowBox[{"-", "8.58661010436089*^-6"}], ",", 
           "2.720870907261023*^-6", ",", 
           RowBox[{"-", "3.758960784576466*^-7"}], ",", 
           "1.926212457729922*^-8"}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<WC\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<GEN\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2RSEIS\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "6.75", ",", "\"\<MAXMAG:\>\"",
            ",", "8.25", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<MEAN\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "9590.53304818063"}], ",", "5169.394473212633", ",", 
           RowBox[{"-", "1041.829308540119"}], ",", "93.0910667286447", ",", 
           RowBox[{"-", "3.111439917508617"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"161.499873413596", ",", 
           RowBox[{"-", "86.27948080917375"}], ",", "17.22190628550968", ",", 
           
           RowBox[{"-", "1.52329221017268"}], ",", "0.05038693236964407"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.980895729674803"}], ",", "0.5221501697314931", ",", 
           RowBox[{"-", "0.1037926417894759"}], ",", "0.0091385181997141", ",", 
           RowBox[{"-", "0.0003007964301485089"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.001858449788075212", ",", 
           RowBox[{"-", "0.000985933289957918"}], ",", 
           "0.0001952133821038953", ",", 
           RowBox[{"-", "0.00001711305471477209"}], ",", 
           "5.606414848136319*^-7"}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<WC\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<GEN\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2RSEIS\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "6.75", ",", "\"\<MAXMAG:\>\"",
            ",", "8.25", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<SIGMA\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"5227.630852109403", ",", 
           RowBox[{"-", "2767.019280409308"}], ",", "547.5712986036855", ",", 
           
           RowBox[{"-", "47.99265645359748"}], ",", "1.572486618897087"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "78.10227206204667"}], ",", "40.40045577596577", ",", 
           
           RowBox[{"-", "7.811793992877719"}], ",", "0.6689227956827757", ",", 
           RowBox[{"-", "0.02141239844265059"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.5276652601561479", ",", 
           RowBox[{"-", "0.2716075723446402"}], ",", "0.05227591684842697", ",", 
           RowBox[{"-", "0.004457732813059324"}], ",", 
           "0.000142162009710473"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.001239463766637707"}], ",", 
           "0.0006394845920271956", ",", 
           RowBox[{"-", "0.0001234234191678904"}], ",", 
           "0.00001055971916950871", ",", 
           RowBox[{"-", "3.38047476000354*^-7"}]}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<WC\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<GEN\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2RRMS\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "3.25", ",", "\"\<MAXMAG:\>\"",
            ",", "6.75", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<MEAN\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"24.89213780336948", ",", 
           RowBox[{"-", "18.26378176441585"}], ",", "6.663662093071457", ",", 
           
           RowBox[{"-", "1.093301400616572"}], ",", "0.06988096437869085"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.3816672412729068", ",", 
           RowBox[{"-", "0.4914705258699672"}], ",", "0.1748759677066014", ",", 
           RowBox[{"-", "0.02754582256663874"}], ",", 
           "0.001642603521489551"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.003764588673354255"}], ",", "0.004392076888582521",
            ",", 
           RowBox[{"-", "0.001520758570563632"}], ",", 
           "0.0002327656187516842", ",", 
           RowBox[{"-", "0.00001348284099948103"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.00001183864069157956", ",", 
           RowBox[{"-", "0.00001275262282632329"}], ",", 
           "4.326410496712876*^-6", ",", 
           RowBox[{"-", "6.471046553675754*^-7"}], ",", 
           "3.649205665657315*^-8"}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<WC\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<GEN\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2RRMS\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "3.25", ",", "\"\<MAXMAG:\>\"",
            ",", "6.75", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<SIGMA\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "13.87755462001545"}], ",", "14.102969058566", ",", 
           RowBox[{"-", "4.180574776342477"}], ",", "0.5225487757662389", ",", 
           RowBox[{"-", "0.02308652371420295"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.6320875625948469", ",", 
           RowBox[{"-", "0.6485817178366701"}], ",", "0.225200279498628", ",", 
           RowBox[{"-", "0.03465076527294023"}], ",", "0.00201008208715239"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.002823676082344198"}], ",", "0.003138878096919877",
            ",", 
           RowBox[{"-", "0.001130665432692331"}], ",", 
           "0.0001807845283796541", ",", 
           RowBox[{"-", "0.00001089987813172137"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"3.026937777176525*^-6", ",", 
           RowBox[{"-", "4.085439326450264*^-6"}], ",", 
           "1.576444427020586*^-6", ",", 
           RowBox[{"-", "2.691560538921312*^-7"}], ",", 
           "1.726175747753287*^-8"}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<WC\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<GEN\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2RRMS\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "6.75", ",", "\"\<MAXMAG:\>\"",
            ",", "8.25", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<MEAN\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"18689.13933499332", ",", 
           RowBox[{"-", "10515.29093289037"}], ",", "2218.192204507569", ",", 
           
           RowBox[{"-", "207.9269248868285"}], ",", "7.314338557762002"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"121.437514322732", ",", 
           RowBox[{"-", "62.65094632264491"}], ",", "12.07883337470946", ",", 
           
           RowBox[{"-", "1.035506066017802"}], ",", "0.0335017803787068"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "3.724854621864271"}], ",", "1.965424255086621", ",", 
           
           RowBox[{"-", "0.3878898802273698"}], ",", "0.03395862613641309", ",", 
           RowBox[{"-", "0.001113802629725785"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.01088729950960446", ",", 
           RowBox[{"-", "0.005706399969052511"}], ",", "0.0011182531271284", ",", 
           RowBox[{"-", "0.0000971490353024885"}], ",", 
           "3.15903740327784*^-6"}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<WC\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<GEN\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2RRMS\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "6.75", ",", "\"\<MAXMAG:\>\"",
            ",", "8.25", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<SIGMA\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"38460.42528237493", ",", 
           RowBox[{"-", "20756.23974919051"}], ",", "4193.33198188716", ",", 
           RowBox[{"-", "375.8348076532238"}], ",", "12.60925838310497"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1447.213010200779"}], ",", "783.6747732400372", ",", 
           
           RowBox[{"-", "158.8991191225214"}], ",", "14.29531420509605", ",", 
           
           RowBox[{"-", "0.4813257881104147"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"9.33374148450888", ",", 
           RowBox[{"-", "5.062834600887969"}], ",", "1.028767334333911", ",", 
           
           RowBox[{"-", "0.0928028011574348"}], ",", "0.003135085370832902"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.01966073446886474"}], ",", "0.01066189841044999", ",", 
           RowBox[{"-", "0.002166358394806616"}], ",", 
           "0.0001954489858077995", ",", 
           RowBox[{"-", "6.605132825368549*^-6"}]}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<WC\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<GEN\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2RRMSSEIS\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "3.25", ",", "\"\<MAXMAG:\>\"",
            ",", "6.75", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<MEAN\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"27.08254108164949", ",", 
           RowBox[{"-", "20.17537312839788"}], ",", "7.279098842749315", ",", 
           
           RowBox[{"-", "1.181469637677201"}], ",", "0.07457498830416331"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.2873397131652322", ",", 
           RowBox[{"-", "0.4080433870528111"}], ",", "0.1476429508260128", ",", 
           RowBox[{"-", "0.02361773481884634"}], ",", 
           "0.001431842814098906"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.002918160280069894"}], ",", "0.00364265524544484", 
           ",", 
           RowBox[{"-", "0.001275941493549057"}], ",", 
           "0.0001974922512489425", ",", 
           RowBox[{"-", "0.00001159329672337777"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"9.71991933195163*^-6", ",", 
           RowBox[{"-", "0.00001087557076383544"}], ",", 
           "3.712948512938719*^-6", ",", 
           RowBox[{"-", "5.587573429462235*^-7"}], ",", 
           "3.176357528742282*^-8"}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<WC\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<GEN\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2RRMSSEIS\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "3.25", ",", "\"\<MAXMAG:\>\"",
            ",", "6.75", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<SIGMA\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "16.69807092144941"}], ",", "16.86416666203058", ",", 
           
           RowBox[{"-", "5.164084366253825"}], ",", "0.6743246563386383", ",", 
           RowBox[{"-", "0.03145095861150077"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.7350251761042662", ",", 
           RowBox[{"-", "0.7446640819985877"}], ",", "0.2579405704790237", ",", 
           RowBox[{"-", "0.03948480661658591"}], ",", 
           "0.002266740018833148"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.00357927641448794"}], ",", "0.003838879413106607", 
           ",", 
           RowBox[{"-", "0.001367288624835424"}], ",", "0.000215420385170525",
            ",", 
           RowBox[{"-", "0.00001272234936336613"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"4.590135274829455*^-6", ",", 
           RowBox[{"-", "5.533181864554115*^-6"}], ",", 
           "2.065249021823107*^-6", ",", 
           RowBox[{"-", "3.40564851144508*^-7"}], ",", 
           "2.100564181966117*^-8"}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<WC\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<GEN\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2RRMSSEIS\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "6.75", ",", "\"\<MAXMAG:\>\"",
            ",", "8.25", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<MEAN\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"11566.92457146743", ",", 
           RowBox[{"-", "6744.458123180541"}], ",", "1470.949771797997", ",", 
           
           RowBox[{"-", "142.2238177417213"}], ",", "5.150731721197306"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"257.8046524292231", ",", 
           RowBox[{"-", "134.6531647683609"}], ",", "26.31125475711277", ",", 
           
           RowBox[{"-", "2.284123848187222"}], ",", "0.07453888340268683"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "4.728945443771324"}], ",", "2.496246472098687", ",", 
           
           RowBox[{"-", "0.4929645276046858"}], ",", "0.0431915041684591", ",", 
           RowBox[{"-", "0.001417773267240502"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.01325638844319902", ",", 
           RowBox[{"-", "0.006961972036898773"}], ",", "0.001367449387604495",
            ",", 
           RowBox[{"-", "0.0001191068303171156"}], ",", 
           "3.88402595215987*^-6"}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<WC\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<GEN\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2RRMSSEIS\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "6.75", ",", "\"\<MAXMAG:\>\"",
            ",", "8.25", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<SIGMA\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"37431.84280727491", ",", 
           RowBox[{"-", "20199.97068808599"}], ",", "4080.877553818739", ",", 
           
           RowBox[{"-", "365.7568564914868"}], ",", "12.27127875476099"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1403.23236256009"}], ",", "760.1571660632693", ",", 
           RowBox[{"-", "154.1961834700558"}], ",", "13.87832981394993", ",", 
           
           RowBox[{"-", "0.4674912425382492"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"8.987346976502128", ",", 
           RowBox[{"-", "4.878704192057685"}], ",", "0.992171776801921", ",", 
           
           RowBox[{"-", "0.08957883862925739"}], ",", 
           "0.003028839471136207"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.01885556021253082"}], ",", "0.01023538074129979", ",", 
           RowBox[{"-", "0.002081900477204484"}], ",", "0.000188037699087573",
            ",", 
           RowBox[{"-", "6.361922147059214*^-6"}]}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#FILEEND\>\"", "}"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\"\<WCSHD\>\"", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\"\<#FILEBEGIN\>\"", ",", "\"\<WCSHD_CVCOEFFS.txt\>\""}], 
          "}"}], ",", 
         RowBox[{"{", "\"\<#COMMENTBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<comment\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#COMMENTEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<WC\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<SHD\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2REPI\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "3.25", ",", "\"\<MAXMAG:\>\"",
            ",", "6.75", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<MEAN\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"4.090700486564408", ",", 
           RowBox[{"-", "5.555742389450765"}], ",", "2.677574696555561", ",", 
           
           RowBox[{"-", "0.5499958452019773"}], ",", "0.04327211192911038"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.6060046061703703", ",", 
           RowBox[{"-", "0.5738279563779418"}], ",", "0.202710248837305", ",", 
           RowBox[{"-", "0.03177169525452546"}], ",", 
           "0.001873726239181299"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.005590050932816633"}], ",", "0.005201789972230854",
            ",", 
           RowBox[{"-", "0.001803316420224026"}], ",", "0.000277137067544981",
            ",", 
           RowBox[{"-", "0.00001602736780991626"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.00001469746030169346", ",", 
           RowBox[{"-", "0.00001347084736665821"}], ",", 
           "4.592085535150223*^-6", ",", 
           RowBox[{"-", "6.931359011179071*^-7"}], ",", 
           "3.936150938454412*^-8"}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<WC\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<SHD\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2REPI\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "3.25", ",", "\"\<MAXMAG:\>\"",
            ",", "6.75", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<SIGMA\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"31.34036942192245", ",", 
           RowBox[{"-", "30.28494950445759"}], ",", "10.96838351387378", ",", 
           
           RowBox[{"-", "1.768867662930903"}], ",", "0.1084807171206562"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.03258679169898326", ",", 
           RowBox[{"-", "0.05024301000831404"}], ",", "0.02456489670482515", ",", 
           RowBox[{"-", "0.004885259073544547"}], ",", 
           "0.0003454848636073151"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.0007292093059861518"}], ",", 
           "0.0008299345218413432", ",", 
           RowBox[{"-", "0.0003401359484874436"}], ",", 
           "0.00006009152334351207", ",", 
           RowBox[{"-", "3.898713551096355*^-6"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1.438090126499185*^-6", ",", 
           RowBox[{"-", "1.669696556702064*^-6"}], ",", 
           "6.934233387386358*^-7", ",", 
           RowBox[{"-", "1.237847639882526*^-7"}], ",", 
           "8.11523173635114*^-9"}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<WC\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<SHD\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2REPI\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "6.75", ",", "\"\<MAXMAG:\>\"",
            ",", "8.25", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<MEAN\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "33934.35032291418"}], ",", "18308.67235687744", ",", 
           
           RowBox[{"-", "3688.892109569613"}], ",", "328.6968538153843", ",", 
           
           RowBox[{"-", "10.91287217215889"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "20.35978293948578"}], ",", "7.818160344975484", ",", 
           
           RowBox[{"-", "0.952552498745381"}], ",", "0.02866308296465876", ",",
            "0.001089153679198359"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1.244248746572202", ",", 
           RowBox[{"-", "0.6548450051151425"}], ",", "0.1289367556777978", ",", 
           RowBox[{"-", "0.01124034407199228"}], ",", 
           "0.0003648955147007571"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.004428261877699863"}], ",", "0.002366665770060894",
            ",", 
           RowBox[{"-", "0.0004732355163388837"}], ",", 
           "0.00004192022886225463", ",", 
           RowBox[{"-", "1.385271543364932*^-6"}]}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<WC\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<SHD\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2REPI\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "6.75", ",", "\"\<MAXMAG:\>\"",
            ",", "8.25", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<SIGMA\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "9477.45940191008"}], ",", "4780.152528511499", ",", 
           RowBox[{"-", "884.7856082017249"}], ",", "70.54530262586339", ",", 
           
           RowBox[{"-", "2.005634861670893"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "431.3842337106423"}], ",", "239.2051050102718", ",", 
           
           RowBox[{"-", "49.7340295997401"}], ",", "4.593624852630951", ",", 
           RowBox[{"-", "0.1589510644299146"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"5.06584421059207", ",", 
           RowBox[{"-", "2.814820160457748"}], ",", "0.5861361138566884", ",", 
           RowBox[{"-", "0.05419507503078683"}], ",", 
           "0.001876579401576279"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.01275767455138052"}], ",", "0.007119551226860116", 
           ",", 
           RowBox[{"-", "0.001488453809953406"}], ",", 
           "0.0001381273832314067", ",", 
           RowBox[{"-", "4.798665500081835*^-6"}]}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<WC\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<SHD\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2RHYP\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "3.25", ",", "\"\<MAXMAG:\>\"",
            ",", "6.75", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<MEAN\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"19.28919796735596", ",", 
           RowBox[{"-", "15.48643946938874"}], ",", "6.405369714855239", ",", 
           
           RowBox[{"-", "1.141209913973639"}], ",", "0.07577018051791379"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.317813574185675", ",", 
           RowBox[{"-", "0.3846275088183007"}], ",", "0.127956558098381", ",", 
           RowBox[{"-", "0.01953301152223018"}], ",", 
           "0.001192352586480186"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.003704474852719131"}], ",", "0.003968736142409724",
            ",", 
           RowBox[{"-", "0.001301619350286719"}], ",", 
           "0.0001935333388271672", ",", 
           RowBox[{"-", "0.00001133582024156039"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.00001076453688165119", ",", 
           RowBox[{"-", "0.00001091211738521698"}], ",", 
           "3.531086129817944*^-6", ",", 
           RowBox[{"-", "5.143521290483406*^-7"}], ",", 
           "2.92786347097297*^-8"}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<WC\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<SHD\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2RHYP\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "3.25", ",", "\"\<MAXMAG:\>\"",
            ",", "6.75", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<SIGMA\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"56.68127899661574", ",", 
           RowBox[{"-", "50.24481134132762"}], ",", "17.48082926171514", ",", 
           
           RowBox[{"-", "2.691096204958939"}], ",", "0.1543911159502446"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.8487275085892805"}], ",", "0.6768990817777741", ",", 
           RowBox[{"-", "0.209695843608393"}], ",", "0.02758339935526887", ",", 
           RowBox[{"-", "0.001252008423108062"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.00631730664191732", ",", 
           RowBox[{"-", "0.005017971218698941"}], ",", "0.001531604748918564",
            ",", 
           RowBox[{"-", "0.0001971813382339114"}], ",", 
           "8.67705300852188*^-6"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.00001485356381223564"}], ",", 
           "0.00001186214481355596", ",", 
           RowBox[{"-", "3.619405147379303*^-6"}], ",", 
           "4.661012516071541*^-7", ",", 
           RowBox[{"-", "2.05968165426031*^-8"}]}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<WC\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<SHD\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2RHYP\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "6.75", ",", "\"\<MAXMAG:\>\"",
            ",", "8.25", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<MEAN\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "34438.04917044781"}], ",", "18526.97137297537", ",", 
           
           RowBox[{"-", "3721.379565949328"}], ",", "330.5559706751866", ",", 
           
           RowBox[{"-", "10.94067168695619"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"16.7497273209909", ",", 
           RowBox[{"-", "10.75324205158584"}], ",", "2.486597211988217", ",", 
           
           RowBox[{"-", "0.2510943742664964"}], ",", "0.00952971583827746"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.8607570839192024", ",", 
           RowBox[{"-", "0.4593815023565432"}], ",", "0.0919033402453684", ",", 
           RowBox[{"-", "0.008144615755834892"}], ",", 
           "0.0002684642453303892"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.003392317995383795"}], ",", "0.001834428700968119",
            ",", 
           RowBox[{"-", "0.0003714204576388755"}], ",", 
           "0.00003331414730060483", ",", 
           RowBox[{"-", "1.113812719444546*^-6"}]}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<WC\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<SHD\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2RHYP\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "6.75", ",", "\"\<MAXMAG:\>\"",
            ",", "8.25", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<SIGMA\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "9164.30002160376"}], ",", "4633.733925649307", ",", 
           RowBox[{"-", "859.4052037342636"}], ",", "68.60611078726383", ",", 
           
           RowBox[{"-", "1.95057432651896"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "447.9147137373036"}], ",", "247.3806685240219", ",", 
           
           RowBox[{"-", "51.24316452245039"}], ",", "4.717068314168674", ",", 
           
           RowBox[{"-", "0.1627273254412177"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"5.220202794888356", ",", 
           RowBox[{"-", "2.892012569072452"}], ",", "0.6005514987459982", ",", 
           RowBox[{"-", "0.05538811085661329"}], ",", 
           "0.001913507843911284"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.01314443915506483"}], ",", "0.007313826244161127", 
           ",", 
           RowBox[{"-", "0.001524899376588319"}], ",", 
           "0.0001411572120645901", ",", 
           RowBox[{"-", "4.89286016214592*^-6"}]}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<WC\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<SHD\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2RRUP\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "3.25", ",", "\"\<MAXMAG:\>\"",
            ",", "6.75", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<MEAN\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"14.05462945194167", ",", 
           RowBox[{"-", "8.557008701468485"}], ",", "3.471982602367843", ",", 
           
           RowBox[{"-", "0.5938910586048101"}], ",", "0.03555684885418097"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.2418436256554031"}], ",", "0.1348519422760474", ",", 
           RowBox[{"-", "0.06018307173934792"}], ",", "0.01081882049000014", ",", 
           RowBox[{"-", "0.0006554962437571861"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.001441858703167834", ",", 
           RowBox[{"-", "0.0007310643084812885"}], ",", 
           "0.0003580637977927338", ",", 
           RowBox[{"-", "0.0000672944703066979"}], ",", 
           "4.138945906522597*^-6"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "2.722834683598215*^-6"}], ",", 
           "1.232290995475855*^-6", ",", 
           RowBox[{"-", "6.707911828070163*^-7"}], ",", 
           "1.318691071978205*^-7", ",", 
           RowBox[{"-", "8.245188617469822*^-9"}]}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<WC\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<SHD\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2RRUP\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "3.25", ",", "\"\<MAXMAG:\>\"",
            ",", "6.75", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<SIGMA\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "3.021744484320618"}], ",", "5.280739977003811", ",", 
           
           RowBox[{"-", "1.654071206633097"}], ",", "0.2043699187570159", ",", 
           RowBox[{"-", "0.008016987610825485"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.08858260200339818", ",", 
           RowBox[{"-", "0.1325160544834986"}], ",", "0.04319693711564625", ",", 
           RowBox[{"-", "0.005829357124617661"}], ",", 
           "0.0002791946256836127"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.0007369116251259045"}], ",", 
           "0.001032520267901483", ",", 
           RowBox[{"-", "0.0003422883548637756"}], ",", 
           "0.00004770271778068759", ",", 
           RowBox[{"-", "2.416289022524249*^-6"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1.780643279671288*^-6", ",", 
           RowBox[{"-", "2.409650229908671*^-6"}], ",", 
           "8.054674546449515*^-7", ",", 
           RowBox[{"-", "1.139769979639555*^-7"}], ",", 
           "5.913808880659966*^-9"}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<WC\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<SHD\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2RRUP\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "6.75", ",", "\"\<MAXMAG:\>\"",
            ",", "8.25", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<MEAN\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "5348.153768682878"}], ",", "2907.440208721821", ",", 
           
           RowBox[{"-", "590.8483071818813"}], ",", "53.24946854852149", ",", 
           
           RowBox[{"-", "1.795607025942964"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"200.9571980394489", ",", 
           RowBox[{"-", "108.2692667728799"}], ",", "21.81144670507173", ",", 
           
           RowBox[{"-", "1.948450705186693"}], ",", "0.0651314136918799"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1.645206436136303"}], ",", "0.8842088546309104", ",", 
           RowBox[{"-", "0.1777017628011765"}], ",", "0.01583619153234355", ",", 
           RowBox[{"-", "0.0005281079754744701"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.003806727184232405", ",", 
           RowBox[{"-", "0.002043561972307308"}], ",", 
           "0.0004102348091113843", ",", 
           RowBox[{"-", "0.00003651719160773324"}], ",", 
           "1.216419281584669*^-6"}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<WC\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<SHD\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2RRUP\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "6.75", ",", "\"\<MAXMAG:\>\"",
            ",", "8.25", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<SIGMA\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"5231.352283028746", ",", 
           RowBox[{"-", "2718.656516073282"}], ",", "527.409353900825", ",", 
           RowBox[{"-", "45.24445302214237"}], ",", "1.448913525801584"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "74.34720957575423"}], ",", "37.90693958406522", ",", 
           
           RowBox[{"-", "7.205111558894313"}], ",", "0.6046508151375675", ",", 
           RowBox[{"-", "0.01890874301090661"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.4087490906133521", ",", 
           RowBox[{"-", "0.2053496676372913"}], ",", "0.03839537794826897", ",", 
           RowBox[{"-", "0.00316320120520022"}], ",", 
           "0.0000968777336951922"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.0007482008782732018"}], ",", 
           "0.0003710898711338481", ",", 
           RowBox[{"-", "0.00006836824725656252"}], ",", 
           "5.536427687151125*^-6", ",", 
           RowBox[{"-", "1.661590454025364*^-7"}]}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<WC\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<SHD\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2RSEIS\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "3.25", ",", "\"\<MAXMAG:\>\"",
            ",", "6.75", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<MEAN\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"16.98250740088299", ",", 
           RowBox[{"-", "11.20306340978637"}], ",", "4.355999166165301", ",", 
           
           RowBox[{"-", "0.723373836757879"}], ",", "0.04258515543135597"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.2807287303547139"}], ",", "0.1692959670496964", ",", 
           RowBox[{"-", "0.07145333921561496"}], ",", "0.01243436821762222", ",", 
           RowBox[{"-", "0.0007412743259235448"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.001802687312966796", ",", 
           RowBox[{"-", "0.001048470579962326"}], ",", 
           "0.0004611068852353604", ",", 
           RowBox[{"-", "0.00008193794970641283"}], ",", 
           "4.909181604872571*^-6"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "3.696622635576812*^-6"}], ",", 
           "2.087301540219361*^-6", ",", 
           RowBox[{"-", "9.47669274090782*^-7"}], ",", "1.7109161227168*^-7", 
           ",", 
           RowBox[{"-", "1.030000178573473*^-8"}]}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<WC\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<SHD\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2RSEIS\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "3.25", ",", "\"\<MAXMAG:\>\"",
            ",", "6.75", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<SIGMA\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "6.162570222363231"}], ",", "8.127010396958147", ",", 
           
           RowBox[{"-", "2.609165667023521"}], ",", "0.3450993356878368", ",", 
           RowBox[{"-", "0.01571729768459255"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.1250293140570767", ",", 
           RowBox[{"-", "0.1655974081806111"}], ",", "0.05436032784221131", ",", 
           RowBox[{"-", "0.007489433436447876"}], ",", 
           "0.000371208873297654"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.0008317066104120579"}], ",", 
           "0.001119285572384682", ",", 
           RowBox[{"-", "0.0003723105176169242"}], ",", 
           "0.00005234432958277456", ",", 
           RowBox[{"-", "2.687342573268505*^-6"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1.752003770785481*^-6", ",", 
           RowBox[{"-", "2.387802578047914*^-6"}], ",", 
           "8.013608335050506*^-7", ",", 
           RowBox[{"-", "1.14104912657221*^-7"}], ",", 
           "5.97713362659479*^-9"}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<WC\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<SHD\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2RSEIS\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "6.75", ",", "\"\<MAXMAG:\>\"",
            ",", "8.25", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<MEAN\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "6800.991502375354"}], ",", "3748.742420728044", ",", 
           
           RowBox[{"-", "772.2487166366722"}], ",", "70.51003762603273", ",", 
           
           RowBox[{"-", "2.40699214055335"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"138.7895973044785", ",", 
           RowBox[{"-", "75.22109257151257"}], ",", "15.23752284036116", ",", 
           
           RowBox[{"-", "1.368464916137075"}], ",", "0.04597984974211015"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1.135057411750556"}], ",", "0.6119331499465045", ",", 
           RowBox[{"-", "0.1233148401951465"}], ",", "0.01101709954387813", ",", 
           RowBox[{"-", "0.0003682686475797365"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.00266421924780133", ",", 
           RowBox[{"-", "0.001432480862956838"}], ",", 
           "0.0002879000664870495", ",", 
           RowBox[{"-", "0.00002565248858768966"}], ",", 
           "8.552102088921629*^-7"}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<WC\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<SHD\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2RSEIS\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "6.75", ",", "\"\<MAXMAG:\>\"",
            ",", "8.25", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<SIGMA\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"7986.713591576827", ",", 
           RowBox[{"-", "4261.411986704521"}], ",", "850.2041347873732", ",", 
           
           RowBox[{"-", "75.14973530989826"}], ",", "2.48363227349265"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "64.17193420358376"}], ",", "33.07343031920323", ",", 
           
           RowBox[{"-", "6.364564886577488"}], ",", "0.5417266789933323", ",", 
           RowBox[{"-", "0.01721888909544809"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.166718398837611", ",", 
           RowBox[{"-", "0.07884209174490756"}], ",", "0.01370865344909965", ",", 
           RowBox[{"-", "0.001032237621360366"}], ",", 
           "0.00002823855413072526"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.0002276884449584784"}], ",", 
           "0.0000991379847314956", ",", 
           RowBox[{"-", "0.00001533362322091016"}], ",", 
           "9.6254430960765*^-7", ",", 
           RowBox[{"-", "1.90058639147227*^-8"}]}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<WC\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<SHD\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2RRMS\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "3.25", ",", "\"\<MAXMAG:\>\"",
            ",", "6.75", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<MEAN\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"13.89917492237762", ",", 
           RowBox[{"-", "10.05062147588289"}], ",", "4.708815805402686", ",", 
           
           RowBox[{"-", "0.911497065908873"}], ",", "0.06450414747013795"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.2268738515994543", ",", 
           RowBox[{"-", "0.3139815261797788"}], ",", "0.1000631821650356", ",", 
           RowBox[{"-", "0.01475388533335122"}], ",", 
           "0.0008892395772658809"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.0006979110435413378"}], ",", 
           "0.001364587911352014", ",", 
           RowBox[{"-", "0.0004084134881507272"}], ",", 
           "0.00005888567810547156", ",", 
           RowBox[{"-", "3.773994253261037*^-6"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"5.761162370223779*^-7", ",", 
           RowBox[{"-", "2.062522198405746*^-6"}], ",", 
           "5.596438049697138*^-7", ",", 
           RowBox[{"-", "7.647613672526637*^-8"}], ",", 
           "5.277576337348065*^-9"}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<WC\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<SHD\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2RRMS\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "3.25", ",", "\"\<MAXMAG:\>\"",
            ",", "6.75", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<SIGMA\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"5.698103865487377", ",", 
           RowBox[{"-", "2.629766820682763"}], ",", "0.991137683255189", ",", 
           
           RowBox[{"-", "0.1798109749846046"}], ",", "0.01225812162231813"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.2030083386343681", ",", 
           RowBox[{"-", "0.2764813934926004"}], ",", "0.108055225834843", ",", 
           RowBox[{"-", "0.01839870694977153"}], ",", 
           "0.001169683809298498"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.001657863706701928"}], ",", "0.002130888013842177",
            ",", 
           RowBox[{"-", "0.0008180698012353742"}], ",", 
           "0.0001369834414563052", ",", 
           RowBox[{"-", "8.549859149395902*^-6"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"5.153102048140557*^-6", ",", 
           RowBox[{"-", "5.97145116483403*^-6"}], ",", 
           "2.204053319701249*^-6", ",", 
           RowBox[{"-", "3.560319137606655*^-7"}], ",", 
           "2.145630404378251*^-8"}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<WC\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<SHD\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2RRMS\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "6.75", ",", "\"\<MAXMAG:\>\"",
            ",", "8.25", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<MEAN\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "18980.27303218824"}], ",", "10185.56375472669", ",", 
           
           RowBox[{"-", "2040.893726348337"}], ",", "180.8663953635244", ",", 
           
           RowBox[{"-", "5.970682487584489"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1251.082187879676", ",", 
           RowBox[{"-", "678.7359321047852"}], ",", "137.8775095955024", ",", 
           
           RowBox[{"-", "12.43285898648359"}], ",", "0.4200535085635827"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "15.41267017280718"}], ",", "8.348476122885522", ",", 
           
           RowBox[{"-", "1.692841759597248"}], ",", "0.1523146234828389", ",", 
           RowBox[{"-", "0.00513173407135851"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.04477408751745727", ",", 
           RowBox[{"-", "0.02423576283937898"}], ",", "0.004910737745736775", 
           ",", 
           RowBox[{"-", "0.0004414833003717979"}], ",", 
           "0.00001485991500281258"}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<WC\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<SHD\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2RRMS\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "6.75", ",", "\"\<MAXMAG:\>\"",
            ",", "8.25", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<SIGMA\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "2486.460669507377"}], ",", "1389.932050429555", ",", 
           
           RowBox[{"-", "290.9697721585296"}], ",", "27.05282213686116", ",", 
           
           RowBox[{"-", "0.941712410374299"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"222.2475397685593", ",", 
           RowBox[{"-", "115.6129411888441"}], ",", "22.4601708039393", ",", 
           RowBox[{"-", "1.933446318082952"}], ",", "0.06235889593107144"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "6.09285579067302"}], ",", "3.250338917274103", ",", 
           RowBox[{"-", "0.6483646477482252"}], ",", "0.05732313640398077", ",", 
           RowBox[{"-", "0.001895786937589388"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.02083016455916038", ",", 
           RowBox[{"-", "0.01115865636734262"}], ",", "0.002235843601384251", 
           ",", 
           RowBox[{"-", "0.0001986026714970975"}], ",", 
           "6.599467272451055*^-6"}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<WC\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<SHD\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2RRMSSEIS\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "3.25", ",", "\"\<MAXMAG:\>\"",
            ",", "6.75", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<MEAN\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"12.00989924184855", ",", 
           RowBox[{"-", "8.326565032252486"}], ",", "4.125853297768538", ",", 
           
           RowBox[{"-", "0.8256683843603587"}], ",", "0.05982935822326391"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.2603319195470407", ",", 
           RowBox[{"-", "0.343687145881026"}], ",", "0.1098418964091293", ",", 
           RowBox[{"-", "0.01614791971324324"}], ",", "0.00096200893311122"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.001003568492017554"}], ",", "0.00163069829186127", 
           ",", 
           RowBox[{"-", "0.0004940701804931477"}], ",", 
           "0.00007080983355542406", ",", 
           RowBox[{"-", "4.379245917549341*^-6"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1.500134117527983*^-6", ",", 
           RowBox[{"-", "2.86340297736597*^-6"}], ",", "8.15705477395138*^-7",
            ",", 
           RowBox[{"-", "1.119030232947755*^-7"}], ",", 
           "7.064474789610354*^-9"}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<WC\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<SHD\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2RRMSSEIS\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "3.25", ",", "\"\<MAXMAG:\>\"",
            ",", "6.75", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<SIGMA\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"8.564068840163245", ",", 
           RowBox[{"-", "4.97147546816243"}], ",", "1.687488305795798", ",", 
           RowBox[{"-", "0.2680736112558418"}], ",", "0.01639579809993136"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.1483779544656452", ",", 
           RowBox[{"-", "0.2314935801121756"}], ",", "0.0944311190195612", ",", 
           RowBox[{"-", "0.01661165453136454"}], ",", 
           "0.001080983825376372"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.001290329096833645"}], ",", "0.001826537349325464",
            ",", 
           RowBox[{"-", "0.0007248995869527374"}], ",", 
           "0.0001245483009527597", ",", 
           RowBox[{"-", "7.917113874679762*^-6"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"4.443750723100634*^-6", ",", 
           RowBox[{"-", "5.385384601509775*^-6"}], ",", 
           "2.024314289531001*^-6", ",", 
           RowBox[{"-", "3.318940330713174*^-7"}], ",", 
           "2.020978129493374*^-8"}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<WC\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<SHD\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2RRMSSEIS\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "6.75", ",", "\"\<MAXMAG:\>\"",
            ",", "8.25", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<MEAN\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "17752.94790107153"}], ",", "9463.00070692144", ",", 
           RowBox[{"-", "1883.17202291153"}], ",", "165.7311902541473", ",", 
           RowBox[{"-", "5.431928214351561"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1216.090527590104", ",", 
           RowBox[{"-", "658.5807604834356"}], ",", "133.5633730573928", ",", 
           
           RowBox[{"-", "12.02613709807818"}], ",", "0.4058058123102527"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "15.10882436020506"}], ",", "8.175719358376986", ",", 
           
           RowBox[{"-", "1.656288926593584"}], ",", "0.148903905490342", ",", 
           
           RowBox[{"-", "0.005013343782009735"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.04395253344947479", ",", 
           RowBox[{"-", "0.02377388545502781"}], ",", "0.004813986372162299", 
           ",", 
           RowBox[{"-", "0.0004325354883866473"}], ",", 
           "0.00001455174699580978"}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<WC\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<SHD\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2RRMSSEIS\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "6.75", ",", "\"\<MAXMAG:\>\"",
            ",", "8.25", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<SIGMA\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "5535.582844055042"}], ",", "3031.910186569646", ",", 
           
           RowBox[{"-", "621.5649183725407"}], ",", "56.55043418980779", ",", 
           
           RowBox[{"-", "1.925907122533751"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"278.6060426257393", ",", 
           RowBox[{"-", "145.8893519171878"}], ",", "28.53760687254798", ",", 
           
           RowBox[{"-", "2.473748144348045"}], ",", "0.08030992556303893"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "6.409062046817928"}], ",", "3.418963357449708", ",", 
           
           RowBox[{"-", "0.68193524416647"}], ",", "0.06028052561486982", ",", 
           RowBox[{"-", "0.00199305897524992"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.02140794453177003", ",", 
           RowBox[{"-", "0.01146312145078356"}], ",", "0.002295662511843636", 
           ",", 
           RowBox[{"-", "0.0002037958826220847"}], ",", 
           "6.767533313995112*^-6"}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#FILEEND\>\"", "}"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\"\<WCSS\>\"", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\"\<#FILEBEGIN\>\"", ",", "\"\<WCSS_CVCOEFFS.txt\>\""}], 
          "}"}], ",", 
         RowBox[{"{", "\"\<#COMMENTBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<comment\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#COMMENTEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<WC\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<SS\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2REPI\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "3.25", ",", "\"\<MAXMAG:\>\"",
            ",", "6.75", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<MEAN\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"25.28590868583115", ",", 
           RowBox[{"-", "24.75791327627452"}], ",", "9.1067957463996", ",", 
           RowBox[{"-", "1.492453779475335"}], ",", "0.0943269381528877"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1.025801546805058", ",", 
           RowBox[{"-", "0.954661017333796"}], ",", "0.3306850146342025", ",", 
           RowBox[{"-", "0.05070227843863549"}], ",", 
           "0.002916662019154829"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.008784762375665868"}], ",", "0.008078532233003432",
            ",", 
           RowBox[{"-", "0.002761625440386715"}], ",", 
           "0.0004175139082105201", ",", 
           RowBox[{"-", "0.00002367503486237922"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.00002107449675103113", ",", 
           RowBox[{"-", "0.0000192014444487017"}], ",", 
           "6.497669450341637*^-6", ",", 
           RowBox[{"-", "9.71965766553861*^-7"}], ",", 
           "5.453958974800602*^-8"}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<WC\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<SS\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2REPI\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "3.25", ",", "\"\<MAXMAG:\>\"",
            ",", "6.75", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<SIGMA\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"50.46506083210515", ",", 
           RowBox[{"-", "48.06765071624843"}], ",", "17.10527395858921", ",", 
           
           RowBox[{"-", "2.702294175468058"}], ",", "0.1613658945296022"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.7371820139324183", ",", 
           RowBox[{"-", "0.6752613552999844"}], ",", "0.2293488841655954", ",", 
           RowBox[{"-", "0.0343077682523219"}], ",", "0.001913021070025459"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.00566665375006154"}], ",", "0.005188239491884263", 
           ",", 
           RowBox[{"-", "0.001762595528423811"}], ",", 
           "0.0002639958785809116", ",", 
           RowBox[{"-", "0.00001475809617623376"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.00001134037822830231", ",", 
           RowBox[{"-", "0.00001038853802384356"}], ",", 
           "3.536442138542001*^-6", ",", 
           RowBox[{"-", "5.318502327921239*^-7"}], ",", 
           "2.993179330997839*^-8"}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<WC\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<SS\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2REPI\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "6.75", ",", "\"\<MAXMAG:\>\"",
            ",", "8.25", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<MEAN\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"41330.57149988436", ",", 
           RowBox[{"-", "22733.3089137796"}], ",", "4692.748016223723", ",", 
           RowBox[{"-", "431.0891719028691"}], ",", "14.88285510780118"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "2416.16571885248"}], ",", "1313.685427961999", ",", 
           RowBox[{"-", "267.3983125250977"}], ",", "24.14696822601784", ",", 
           
           RowBox[{"-", "0.8160573655126291"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"20.7418579312278", ",", 
           RowBox[{"-", "11.26340771658464"}], ",", "2.289837839430492", ",", 
           
           RowBox[{"-", "0.2065409463610855"}], ",", "0.006973022799902221"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.05187823596609101"}], ",", "0.02811541337267671", ",", 
           RowBox[{"-", "0.005704482358182801"}], ",", 
           "0.0005135358899694038", ",", 
           RowBox[{"-", "0.00001730532317845751"}]}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<WC\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<SS\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2REPI\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "6.75", ",", "\"\<MAXMAG:\>\"",
            ",", "8.25", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<SIGMA\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"12207.5188429977", ",", 
           RowBox[{"-", "7001.440753274707"}], ",", "1515.673326010253", ",", 
           
           RowBox[{"-", "146.9128521790823"}], ",", "5.388523704157005"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1318.616744839668"}], ",", "718.2859670897642", ",", 
           
           RowBox[{"-", "146.5419249479895"}], ",", "13.26883483789629", ",", 
           
           RowBox[{"-", "0.4497899372783945"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"14.94952783396862", ",", 
           RowBox[{"-", "8.130118233687151"}], ",", "1.655826852574841", ",", 
           
           RowBox[{"-", "0.1496655480247293"}], ",", "0.005064664293217846"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.04145031809696918"}], ",", "0.02248274526078473", ",", 
           RowBox[{"-", "0.004566514640980082"}], ",", 
           "0.0004116109653196737", ",", 
           RowBox[{"-", "0.00001389017811025167"}]}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<WC\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<SS\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2RHYP\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "3.25", ",", "\"\<MAXMAG:\>\"",
            ",", "6.75", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<MEAN\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1.221186057747073", ",", 
           RowBox[{"-", "3.181459077755588"}], ",", "2.784568309186977", ",", 
           
           RowBox[{"-", "0.6754458218436697"}], ",", "0.05453416679024935"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1.627246672961594", ",", 
           RowBox[{"-", "1.485516296695702"}], ",", "0.4857975459521144", ",", 
           RowBox[{"-", "0.0706413303672241"}], ",", "0.003884213888886294"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.01327871057673544"}], ",", "0.01202674272050409", ",", 
           RowBox[{"-", "0.003914904705940812"}], ",", 
           "0.0005655271782889883", ",", 
           RowBox[{"-", "0.0000308449865394522"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.00003122597632228296", ",", 
           RowBox[{"-", "0.00002810153771526226"}], ",", 
           "9.09758399867417*^-6", ",", 
           RowBox[{"-", "1.305404985275216*^-6"}], ",", 
           "7.067550059797194*^-8"}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<WC\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<SS\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2RHYP\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "3.25", ",", "\"\<MAXMAG:\>\"",
            ",", "6.75", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<SIGMA\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"75.1861083398763", ",", 
           RowBox[{"-", "69.74272387447587"}], ",", "24.65702643049996", ",", 
           
           RowBox[{"-", "3.836649134237316"}], ",", "0.2218116651298605"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.06465579470834097"}], ",", "0.03466353575818555", ",", 
           RowBox[{"-", "0.01297519681310157"}], ",", "0.001275798405335009", 
           ",", "0.00004808289496626676"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.0008679898277547315", ",", 
           RowBox[{"-", "0.0005946762435688566"}], ",", 
           "0.0001940010874338441", ",", 
           RowBox[{"-", "0.00002076697269909323"}], ",", 
           "6.692883656162135*^-8"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "3.908969481921322*^-6"}], ",", 
           "3.096318223832965*^-6", ",", 
           RowBox[{"-", "1.007004879910212*^-6"}], ",", 
           "1.266421490778974*^-7", ",", 
           RowBox[{"-", "4.239480481919471*^-9"}]}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<WC\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<SS\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2RHYP\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "6.75", ",", "\"\<MAXMAG:\>\"",
            ",", "8.25", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<MEAN\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"44193.84790354806", ",", 
           RowBox[{"-", "24291.41434915176"}], ",", "5010.545322582305", ",", 
           
           RowBox[{"-", "459.8459807726828"}], ",", "15.85620401004557"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "2463.050016896053"}], ",", "1339.333219050647", ",", 
           
           RowBox[{"-", "272.6599888835708"}], ",", "24.6259837402755", ",", 
           RowBox[{"-", "0.8323692757230708"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"21.0437590211045", ",", 
           RowBox[{"-", "11.42893019654195"}], ",", "2.323876295082119", ",", 
           
           RowBox[{"-", "0.2096473913905064"}], ",", "0.007079063083449699"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.0525172043470792"}], ",", "0.02846607501369938", ",", 
           RowBox[{"-", "0.005776665625235559"}], ",", 
           "0.0005201302600018525", ",", 
           RowBox[{"-", "0.00001753064960477127"}]}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<WC\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<SS\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2RHYP\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "6.75", ",", "\"\<MAXMAG:\>\"",
            ",", "8.25", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<SIGMA\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"11692.93762265109", ",", 
           RowBox[{"-", "6695.199488226491"}], ",", "1448.404927348543", ",", 
           
           RowBox[{"-", "140.4412120732248"}], ",", "5.157853732812017"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1316.691266564158"}], ",", "716.3602230297492", ",", 
           
           RowBox[{"-", "145.981987802212"}], ",", "13.20432072916135", ",", 
           RowBox[{"-", "0.4471774360098991"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"14.97102728407672", ",", 
           RowBox[{"-", "8.134667829720826"}], ",", "1.655379777830415", ",", 
           
           RowBox[{"-", "0.1495101982872694"}], ",", "0.005055825438175332"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.04153547143612928"}], ",", "0.02251242135071564", ",", 
           RowBox[{"-", "0.00456935100778838"}], ",", "0.0004115980029657899",
            ",", 
           RowBox[{"-", "0.00001388131824160071"}]}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<WC\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<SS\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2RRUP\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "3.25", ",", "\"\<MAXMAG:\>\"",
            ",", "6.75", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<MEAN\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "25.41755708253059"}], ",", "24.32907608143488", ",", 
           
           RowBox[{"-", "7.297176087069156"}], ",", "0.958670132277858", ",", 
           
           RowBox[{"-", "0.04674359920224049"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.6337548964695525", ",", 
           RowBox[{"-", "0.600052816521846"}], ",", "0.180311952335235", ",", 
           
           RowBox[{"-", "0.02372756010817927"}], ",", 
           "0.001164410386356847"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.0047147950910862"}], ",", "0.004458731839776", ",", 
           RowBox[{"-", "0.001343411999160811"}], ",", 
           "0.0001772728912133292", ",", 
           RowBox[{"-", "8.738547767658155*^-6"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.00001056471880687294", ",", 
           RowBox[{"-", "9.99529116313407*^-6"}], ",", 
           "3.016515633560498*^-6", ",", 
           RowBox[{"-", "3.987225558328742*^-7"}], ",", 
           "1.970480884863499*^-8"}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<WC\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<SS\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2RRUP\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "3.25", ",", "\"\<MAXMAG:\>\"",
            ",", "6.75", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<SIGMA\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2.850727186667307", ",", 
           RowBox[{"-", "1.243853678949373"}], ",", "0.5773079105052226", ",", 
           RowBox[{"-", "0.113975095677706"}], ",", "0.008107827417690026"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.0963267019979631"}], ",", "0.06063851057007109", ",", 
           RowBox[{"-", "0.0237935669635311"}], ",", "0.004061929162350795", ",", 
           RowBox[{"-", "0.000249743537367762"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.0008258651366335938", ",", 
           RowBox[{"-", "0.0005596549200063754"}], ",", 
           "0.0002098052813639994", ",", 
           RowBox[{"-", "0.00003431825842485819"}], ",", 
           "2.017540234201415*^-6"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1.986760258598519*^-6"}], ",", 
           "1.382364274078653*^-6", ",", 
           RowBox[{"-", "5.082866721578408*^-7"}], ",", 
           "8.160954832080706*^-8", ",", 
           RowBox[{"-", "4.702172655210106*^-9"}]}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<WC\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<SS\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2RRUP\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "6.75", ",", "\"\<MAXMAG:\>\"",
            ",", "8.25", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<MEAN\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1680.870166280341"}], ",", "925.360887330897", ",", 
           RowBox[{"-", "189.7441531765867"}], ",", "17.22017087665873", ",", 
           
           RowBox[{"-", "0.5838033599759795"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"89.38383102614279", ",", 
           RowBox[{"-", "48.48480816895083"}], ",", "9.82275978121867", ",", 
           RowBox[{"-", "0.8818126985952083"}], ",", "0.02960389392413941"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.7703542893931865"}], ",", "0.4165895135500108", ",", 
           RowBox[{"-", "0.08416777909114989"}], ",", "0.007536243089856938", 
           ",", 
           RowBox[{"-", "0.0002523784505945915"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.001829234785950453", ",", 
           RowBox[{"-", "0.000987631944653348"}], ",", 
           "0.0001992426500884336", ",", 
           RowBox[{"-", "0.00001781371803735086"}], ",", 
           "5.957054004199511*^-7"}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<WC\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<SS\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2RRUP\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "6.75", ",", "\"\<MAXMAG:\>\"",
            ",", "8.25", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<SIGMA\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2585.311224236867", ",", 
           RowBox[{"-", "1383.256603641265"}], ",", "276.4352458467179", ",", 
           
           RowBox[{"-", "24.43720106466598"}], ",", "0.8067262089751347"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "46.24719401580013"}], ",", "24.5555938953288", ",", 
           RowBox[{"-", "4.868030048469999"}], ",", "0.4267722901419221", ",", 
           RowBox[{"-", "0.01396780388457656"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.2998449626562121", ",", 
           RowBox[{"-", "0.1585587524323431"}], ",", "0.03129864199541309", ",", 
           RowBox[{"-", "0.002731643597838555"}], ",", 
           "0.0000889873084595593"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.0006281475825719076"}], ",", 
           "0.0003313660780203875", ",", 
           RowBox[{"-", "0.0000652438242523976"}], ",", 
           "5.679230601713642*^-6", ",", 
           RowBox[{"-", "1.844991841072298*^-7"}]}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<WC\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<SS\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2RSEIS\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "3.25", ",", "\"\<MAXMAG:\>\"",
            ",", "6.75", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<MEAN\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "22.67024822739124"}], ",", "21.76957251999093", ",", 
           
           RowBox[{"-", "6.409507247938735"}], ",", "0.822705542458141", ",", 
           
           RowBox[{"-", "0.03895031866385722"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.5752251791980375", ",", 
           RowBox[{"-", "0.5469267823734244"}], ",", "0.1624214007549364", ",", 
           RowBox[{"-", "0.02107530949073759"}], ",", 
           "0.001017796604092056"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.004179354555088413"}], ",", "0.003975023384333185",
            ",", 
           RowBox[{"-", "0.001181500164851311"}], ",", 
           "0.0001534498831396811", ",", 
           RowBox[{"-", "7.434446765395089*^-6"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"9.12732200098569*^-6", ",", 
           RowBox[{"-", "8.701242524754087*^-6"}], ",", 
           "2.585278086288463*^-6", ",", 
           RowBox[{"-", "3.356236817224393*^-7"}], ",", 
           "1.627535146664398*^-8"}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<WC\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<SS\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2RSEIS\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "3.25", ",", "\"\<MAXMAG:\>\"",
            ",", "6.75", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<SIGMA\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
          "1.376757416657397", ",", "0.1878150362155377", ",", 
           "0.05404489842970496", ",", 
           RowBox[{"-", "0.02875958704875219"}], ",", 
           "0.002858339091284212"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.04903847761521763"}], ",", "0.01642565439979825", ",", 
           RowBox[{"-", "0.00832671827193854"}], ",", "0.001659350177051812", 
           ",", 
           RowBox[{"-", "0.0001090316095890116"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.0006566202927687831", ",", 
           RowBox[{"-", "0.0003990343358189509"}], ",", 
           "0.0001521522490650565", ",", 
           RowBox[{"-", "0.00002504380288773448"}], ",", 
           "1.448943828741718*^-6"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1.921575378061917*^-6"}], ",", 
           "1.304521367896374*^-6", ",", 
           RowBox[{"-", "4.724263171366105*^-7"}], ",", 
           "7.43145916791911*^-8", ",", 
           RowBox[{"-", "4.146691317826431*^-9"}]}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<WC\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<SS\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2RSEIS\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "6.75", ",", "\"\<MAXMAG:\>\"",
            ",", "8.25", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<MEAN\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"5088.347524495255", ",", 
           RowBox[{"-", "2652.886305999819"}], ",", "517.3128622646307", ",", 
           
           RowBox[{"-", "44.68479066061424"}], ",", "1.443049698487749"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.1076199428410095", ",", 
           RowBox[{"-", "0.7709391684738484"}], ",", "0.2840984009610608", ",", 
           RowBox[{"-", "0.03641618985615037"}], ",", 
           "0.001573171759453113"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.1962231263358277"}], ",", "0.1098229279588994", ",", 
           RowBox[{"-", "0.02285294991937357"}], ",", "0.002102789413858847", 
           ",", 
           RowBox[{"-", "0.00007223935050400378"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.0007241327924162851", ",", 
           RowBox[{"-", "0.0003983000325805142"}], ",", 
           "0.00008168322024438932", ",", 
           RowBox[{"-", "7.417306274095321*^-6"}], ",", 
           "2.517453364503766*^-7"}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<WC\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<SS\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2RSEIS\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "6.75", ",", "\"\<MAXMAG:\>\"",
            ",", "8.25", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<SIGMA\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "3318.071077216053"}], ",", "1708.885247297683", ",", 
           
           RowBox[{"-", "328.7535133312294"}], ",", "28.02377232963443", ",", 
           
           RowBox[{"-", "0.8933313616975447"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"32.67647471113524", ",", 
           RowBox[{"-", "16.39722652033685"}], ",", "3.065623042920862", ",", 
           
           RowBox[{"-", "0.2532891282879568"}], ",", "0.007799954206222342"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.0823899050159302"}], ",", "0.04074217170107258", ",", 
           RowBox[{"-", "0.007504354183374555"}], ",", 
           "0.0006111366874996286", ",", 
           RowBox[{"-", "0.00001852391595686867"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.0001322270203888067", ",", 
           RowBox[{"-", "0.00006910874442679929"}], ",", 
           "0.00001355494498209275", ",", 
           RowBox[{"-", "1.184229987846228*^-6"}], ",", 
           "3.87632687613264*^-8"}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<WC\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<SS\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2RRMS\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "3.25", ",", "\"\<MAXMAG:\>\"",
            ",", "6.75", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<MEAN\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "16.09671048023596"}], ",", "14.3058530081674", ",", 
           RowBox[{"-", "3.203098055970412"}], ",", "0.2210252728311762", ",",
            "0.005072978722806184"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1.382626750318608", ",", 
           RowBox[{"-", "1.307517450331997"}], ",", "0.4288814687398313", ",", 
           RowBox[{"-", "0.0626097568206136"}], ",", "0.00345788857758341"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.008316690720974193"}], ",", "0.007859307513439143",
            ",", 
           RowBox[{"-", "0.00253928812794819"}], ",", "0.0003658706231250056",
            ",", 
           RowBox[{"-", "0.00002005172446566336"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.00001585060295130734", ",", 
           RowBox[{"-", "0.00001498231040546662"}], ",", 
           "4.773630195985967*^-6", ",", 
           RowBox[{"-", "6.794771313207766*^-7"}], ",", 
           "3.698323336622898*^-8"}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<WC\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<SS\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2RRMS\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "3.25", ",", "\"\<MAXMAG:\>\"",
            ",", "6.75", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<SIGMA\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"4.299346441701984", ",", 
           RowBox[{"-", "3.682663167206229"}], ",", "1.814030827515771", ",", 
           
           RowBox[{"-", "0.3602528544883856"}], ",", "0.02491561400558778"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.6260310489906205", ",", 
           RowBox[{"-", "0.6167508568281272"}], ",", "0.2139756069259101", ",", 
           RowBox[{"-", "0.03317053199225332"}], ",", 
           "0.001955720579311413"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.003743277038663266"}], ",", "0.003761517472437079",
            ",", 
           RowBox[{"-", "0.001321359278822574"}], ",", 
           "0.0002078095745400378", ",", 
           RowBox[{"-", "0.00001244130875008572"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"8.32664052979499*^-6", ",", 
           RowBox[{"-", "8.35672808281036*^-6"}], ",", 
           "2.935332147062909*^-6", ",", 
           RowBox[{"-", "4.612436892661694*^-7"}], ",", 
           "2.75601380891701*^-8"}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<WC\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<SS\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2RRMS\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "6.75", ",", "\"\<MAXMAG:\>\"",
            ",", "8.25", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<MEAN\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"9854.35499529838", ",", 
           RowBox[{"-", "5467.465552885904"}], ",", "1142.121992126982", ",", 
           
           RowBox[{"-", "106.5081084021854"}], ",", "3.748862483747715"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"10.6911596416887", ",", 
           RowBox[{"-", "9.92327850331957"}], ",", "2.874217398825675", ",", 
           RowBox[{"-", "0.3418549855171134"}], ",", "0.01468730722408299"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1.827442641237224"}], ",", "1.033564907929986", ",", 
           
           RowBox[{"-", "0.2182119287375205"}], ",", "0.02039906726559176", ",", 
           RowBox[{"-", "0.000713199080774801"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.005067697073412147", ",", 
           RowBox[{"-", "0.002875992367790348"}], ",", 
           "0.0006088871975192265", ",", 
           RowBox[{"-", "0.00005702440395049702"}], ",", 
           "1.994509115790615*^-6"}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<WC\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<SS\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2RRMS\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "6.75", ",", "\"\<MAXMAG:\>\"",
            ",", "8.25", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<SIGMA\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"12492.3126512362", ",", 
           RowBox[{"-", "6823.150621141384"}], ",", "1394.952185571162", ",", 
           
           RowBox[{"-", "126.4869445864385"}], ",", "4.29206860356396"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "777.649179295111"}], ",", "430.5610016941982", ",", 
           RowBox[{"-", "89.27681504094983"}], ",", "8.21341628539128", ",", 
           RowBox[{"-", "0.2827154615227463"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"3.109528209675284", ",", 
           RowBox[{"-", "1.76748876239263"}], ",", "0.3765092107436558", ",", 
           
           RowBox[{"-", "0.03560852804838764"}], ",", 
           "0.001260691699175885"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.004256212924685273"}], ",", "0.002503052169763848",
            ",", 
           RowBox[{"-", "0.0005509032685816721"}], ",", 
           "0.00005375654132101006", ",", 
           RowBox[{"-", "1.960774777448681*^-6"}]}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<WC\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<SS\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2RRMSSEIS\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "3.25", ",", "\"\<MAXMAG:\>\"",
            ",", "6.75", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<MEAN\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "17.48324233934242"}], ",", "15.51207654324826", ",", 
           
           RowBox[{"-", "3.595216664681969"}], ",", "0.2761887763126505", ",",
            "0.002264415979631998"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1.413542733280465", ",", 
           RowBox[{"-", "1.334799529411025"}], ",", "0.4378991902046108", ",", 
           RowBox[{"-", "0.0638995448809339"}], ",", "0.003524207671845298"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.008551052062460355"}], ",", "0.008068833042977088",
            ",", 
           RowBox[{"-", "0.002609466214759555"}], ",", "0.000376048750137371",
            ",", 
           RowBox[{"-", "0.00002058196820138184"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.00001641012023137316", ",", 
           RowBox[{"-", "0.00001548630439506518"}], ",", 
           "4.943530723316602*^-6", ",", 
           RowBox[{"-", "7.042819719082225*^-7"}], ",", 
           "3.82841751241542*^-8"}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<WC\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<SS\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2RRMSSEIS\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "3.25", ",", "\"\<MAXMAG:\>\"",
            ",", "6.75", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<SIGMA\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"4.826649617118479", ",", 
           RowBox[{"-", "4.037828470088762"}], ",", "1.892108362977726", ",", 
           
           RowBox[{"-", "0.3638337308963392"}], ",", "0.02475136019258395"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.6612130427070048", ",", 
           RowBox[{"-", "0.6507437779314202"}], ",", "0.2258390243322615", ",", 
           RowBox[{"-", "0.03497961438056114"}], ",", 
           "0.002053550250315584"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.004242595621217013"}], ",", "0.004216515002120103",
            ",", 
           RowBox[{"-", "0.001472028100669906"}], ",", 
           "0.0002295224258809334", ",", 
           RowBox[{"-", "0.0000135632846498402"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"9.8137851319315*^-6", ",", 
           RowBox[{"-", "9.68699506698492*^-6"}], ",", "3.36803667219051*^-6",
            ",", 
           RowBox[{"-", "5.223572460737541*^-7"}], ",", 
           "3.06632477646504*^-8"}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<WC\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<SS\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2RRMSSEIS\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "6.75", ",", "\"\<MAXMAG:\>\"",
            ",", "8.25", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<MEAN\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"6160.139781222612", ",", 
           RowBox[{"-", "3516.954512268065"}], ",", "757.1347542514333", ",", 
           
           RowBox[{"-", "72.83216706515155"}], ",", "2.64687873170038"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"104.4602657960533", ",", 
           RowBox[{"-", "59.46920271124882"}], ",", "12.66410320479165", ",", 
           
           RowBox[{"-", "1.199435408112728"}], ",", "0.0427993393648867"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "2.484990714982799"}], ",", "1.38089809979191", ",", 
           RowBox[{"-", "0.2868241441011858"}], ",", "0.02640809057555491", ",", 
           RowBox[{"-", "0.000910146279983074"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.006479948691465786", ",", 
           RowBox[{"-", "0.003621848749115453"}], ",", 
           "0.0007561965077638768", ",", 
           RowBox[{"-", "0.00006992326243609995"}], ",", 
           "2.417195544929177*^-6"}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\"\<MODEL:\>\"", ",", "\"\<WC\>\"", 
           ",", "\"\<FAULTTYPE:\>\"", ",", "\"\<SS\>\"", 
           ",", "\"\<CONVTYPE:\>\"", ",", "\"\<RJB2RRMSSEIS\>\"", 
           ",", "\"\<MINDIST:\>\"", ",", "0", ",", "\"\<MAXDIST:\>\"", ",", 
           "250", ",", "\"\<MINMAG:\>\"", ",", "6.75", ",", "\"\<MAXMAG:\>\"",
            ",", "8.25", ",", "\"\<PARAMETERTYPE:\>\"", ",", "\"\<SIGMA\>\"", 
           ",", "\"\<NROWS:\>\"", ",", "4", ",", "\"\<NCOLS:\>\"", ",", "5"}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"11260.50111214217", ",", 
           RowBox[{"-", "6152.840052783865"}], ",", "1258.701191338341", ",", 
           
           RowBox[{"-", "114.2209800052664"}], ",", "3.879270480239624"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "762.59886119733"}], ",", "422.2014653099121", ",", 
           RowBox[{"-", "87.54763568390881"}], ",", "8.05537444598479", ",", 
           RowBox[{"-", "0.2773258908568229"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"3.044492231038952", ",", 
           RowBox[{"-", "1.730351161546926"}], ",", "0.3686519292839823", ",", 
           RowBox[{"-", "0.03487675775599791"}], ",", 
           "0.001235335307540258"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.004200597184004564"}], ",", "0.002467671070151036",
            ",", 
           RowBox[{"-", "0.0005428001383152796"}], ",", 
           "0.00005295420858692228", ",", 
           RowBox[{"-", "1.931573305464493*^-6"}]}], "}"}], ",", 
         RowBox[{"{", "\"\<#DATABLOCKEND\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<#FILEEND\>\"", "}"}]}], "}"}]}], "}"}]}], "}"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{
  3.952177146669427*^9, {3.952177323488109*^9, 3.952177352657154*^9}},
 CellLabel->"In[54]:=",ExpressionUUID->"548b1c6e-2dec-4ef5-bd5c-7ed2ee7e17a6"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"ConvertDistanceMetric", "::", "usage"}], 
   "=", "\"\<ConvertDistanceMetric[mw, dist] converts (for a moment magnitude \
mw) the distance dist which is of a type defined by the hostdist option into \
the type defined by the targetdist option. \nE.g. ConvertDistanceMetric[6.5, \
17.5 ,CMDhostdist->\\\"RJB\\\",CMDtargetdist->\\\"RHYP\\\", CMDcatalog \
->\\\"WCSS\\\"] the RJB distance for a Mw=6.5 event in  17.5 km into \
hypocentral distance using the WCSS (strike slip) model.\n\\nReturns: {mean \
value, standard deviation, median, mode} \n\\nImplemented host distance type \
combinations at present are \n\\n\\thost type: \\\"RJB\\\" with target \
distance types: \\\"REPI\\\",\\\"RHYP\\\",\\\"RRUP\\\",\\\"RSEIS\\\",\\\"RRMS\
\\\",\\\"RRMSSEIS\\\"\n\\n\\tcatalogs:  \n\\n\\t\\t \\\"WCGEN\\\" (ALL), \
\\\"WCSHD\\\" (shallow dipping events), \\\"WCSS\\\" (strike slip events) \n\
\\n\\t\\t \\\"NORWAYNF\\\" ,\\\"NORWAYTF\\\" ,\\\"NORWAYSS\\\"\n\\n\\t\\t \
\\\"SPAINGEN\\\" \>\""}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"CDMhostdist", "::", "usage"}], 
   "=", "\"\<Option ConvertDistanceMetric[]. Host distance type from which to \
convert to. If a  host distance other than \\\"RJB\\\" is selected, the \
distances are determined iteratively such that input distance is interpreted \
as the CDMCouplingType ( e. g. the median) of  the target distance \
distribution with \\\"RJB\\\" as CDMhosttype.   \>\""}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"CDMtargetdist", "::", "usage"}], 
   "=", "\"\<Option ConvertDistanceMetric[]. \\\"REPI\\\", \\\"RHYP\\\", \
\\\"RRUP\\\", \\\"RSEIS\\\", \\\"RRMS\\\",  \\\"RRMSSEIS\\\", and \\\"ATSCA\\\
\" (see Scherbaum et al. 2004)\>\""}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"CDMcatalog", "::", "usage"}], 
   "=", "\"\<Option ConvertDistanceMetric[]. Catalog types from Scherbaum et \
al. 2004): \\\"WCGEN\\\"  (generic), \\\"WCSHD\\\" (shallow dipping events), \
\\\"WCSS\\\" (strike-slip events). From Douglas et al. \
(2005):\\\"NORWAYNF\\\" (Norwegian normal faulting events),\\\"NORWAYTF\\\" \
(Norwegian thrust faulting events) ,\\\"NORWAYS\\\" (Norwegian strike-slip \
events) ,\\\"SPAINGEN\\\" (Spain, unspecified) \>\""}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"CDMseisdepth", "::", "usage"}], 
   "=", "\"\<Option ConvertDistanceMetric[]. Assumed depth to seismogenic \
zone for the depths measures \\\"RSEIS\\\", and \\\"RRMSSEIS\\\".\>\""}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"CDMfocdepth", "::", "usage"}], 
   "=", "\"\<Option ConvertDistanceMetric[]. Assumed focal depth for the \
conversion to hypocentral distance.\>\""}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"CDMcouplingtype", "::", "usage"}], 
   "=", "\"\<Option ConvertDistanceMetric[]. \\\"MEAN\\\", \\\"MEDIAN\\\", or \
\\\"MODE\\\". Relevant only if host distance is not \\\"RJB\\\" (see \
above).\>\""}], ";"}]}], "Input",
 CellChangeTimes->{{3.952173841424727*^9, 3.9521738414267263`*^9}, {
  3.952175418723976*^9, 3.9521754421797247`*^9}},
 CellLabel->"In[55]:=",ExpressionUUID->"d0c5faf1-561f-48cb-af52-c70762da840d"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Options", "[", "ConvertDistanceMetric", "]"}], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"CDMhostdist", "->", "\"\<RJB\>\""}], ",", 
     RowBox[{"CDMtargetdist", "->", "\"\<RRUP\>\""}], ",", 
     RowBox[{"CDMcatalog", "->", "\"\<WCGEN\>\""}], ",", 
     RowBox[{"CDMseisdepth", "->", "3"}], ",", 
     RowBox[{"CDMfocdepth", "->", "10"}], ",", 
     RowBox[{"CDMcouplingtype", "->", "\"\<MEDIAN\>\""}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ConvertDistanceMetric", "[", 
    RowBox[{"maginp_", ",", "distinp_", ",", 
     RowBox[{"opts", ":", 
      RowBox[{"OptionsPattern", "[", 
       RowBox[{"{", "ConvertDistanceMetric", "}"}], "]"}]}]}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "host", ",", "target", ",", "cat", ",", "sdepth", ",", "fdepth", ",", 
       "hdist", ",", "mag", ",", "mean", ",", "std", ",", "median", ",", 
       "mode", ",", "tdistmode", ",", "tdistmedian", ",", "tdistmean", ",", 
       "rjbinvmean", ",", "rjbinvstd", ",", "rjbinvmedian", ",", "rjbinvmode",
        ",", "cpldist", ",", "cpltype", ",", "h", ",", "hosttarget"}], 
      "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{
       ",", "hosttarget", ",", "i", ",", "index", ",", "si", ",", "mi", ",", 
        "modal2", ",", "resfunc", ",", "di", ",", "targetmean", ",", 
        "targetmodal", ",", "targetmedian", ",", "found", ",", "std", ",", 
        "alpha", ",", "beta", ",", "data", ",", "dist2", ",", "dist", ",", 
        "dist3", ",", "dist2B", ",", "resfit", ",", "y"}], "*)"}], "}"}], ",", 
     RowBox[{
      RowBox[{"host", "=", 
       RowBox[{"OptionValue", "[", "CDMhostdist", "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"target", "=", 
       RowBox[{"OptionValue", "[", "CDMtargetdist", "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"cat", "=", 
       RowBox[{"OptionValue", "[", "CDMcatalog", "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"sdepth", "=", 
       RowBox[{"OptionValue", "[", "CDMseisdepth", "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"fdepth", "=", 
       RowBox[{"OptionValue", "[", "CDMfocdepth", "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"cpltype", "=", 
       RowBox[{"OptionValue", "[", "CDMcouplingtype", "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"hdist", "=", "distinp"}], ";", "\[IndentingNewLine]", 
      RowBox[{"mag", "=", "maginp"}], ";", "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"host", "==", "target"}], ",", 
        RowBox[{"(*", 
         RowBox[{
          RowBox[{"Print", "[", 
           RowBox[{
           "host", ",", "\"\< -> \>\"", ",", "target", ",", "\"\< : \>\"", ",",
             "dist"}], "]"}], ";"}], "*)"}], "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"Return", "[", 
          RowBox[{"{", 
           RowBox[{"hdist", ",", "0.", ",", "hdist", ",", "hdist"}], "}"}], 
          "]"}], ";"}]}], "\[IndentingNewLine]", "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", 
       RowBox[{"possible", " ", "host", " ", "distance", " ", 
        RowBox[{"metrics", ":", "\"\<RJB\>\""}]}], "*)"}], 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{"possible", " ", "target", " ", "distance", " ", 
         RowBox[{"metrics", ":", "\"\<RHYP\>\""}]}], ",", "\"\<REPI\>\"", 
        ",", "\"\<RRUP\>\"", ",", "\"\<RSEIS\>\"", ",", "\"\<RRMS\>\"", 
        ",", "\"\<RRMSSEIS\>\"", ",", "\"\<ATSCA\>\""}], "*)"}], 
      RowBox[{"(*", 
       RowBox[{
       "all", " ", "other", " ", "combinations", " ", "are", " ", "at", " ", 
        "present", " ", "iteratively", " ", "solved"}], "*)"}], 
      RowBox[{"(*", 
       RowBox[{
       "the", " ", "string", " ", "given", " ", "by", " ", "cat", " ", 
        "defines", " ", "which", " ", "conversion", " ", "is", " ", "being", " ",
         "used"}], "*)"}], 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{"current", " ", 
         RowBox[{"options", ":", "\"\<WCGEN\>\""}]}], ",", "\"\<WCSS\>\"", ",", \
"\"\<WCSHD\>\""}], "*)"}], 
      RowBox[{"hosttarget", "=", 
       RowBox[{"StringJoin", "[", 
        RowBox[{"host", ",", "\"\<2\>\"", ",", "target"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"mean", "=", 
       RowBox[{"gettargetresidual", "[", 
        RowBox[{
        "cat", ",", "hosttarget", ",", "mag", ",", "distinp", 
         ",", "\"\<MEAN\>\""}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"std", "=", 
       RowBox[{"gettargetresidual", "[", 
        RowBox[{
        "cat", ",", "hosttarget", ",", "mag", ",", "distinp", 
         ",", "\"\<SIGMA\>\""}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"host", "==", "\"\<RJB\>\""}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"{", 
           RowBox[{"median", ",", "mode"}], "}"}], "=", 
          RowBox[{"gammadistribparams", "[", 
           RowBox[{"mean", ",", "std"}], "]"}]}], ";", "\[IndentingNewLine]", 
         
         RowBox[{"Which", "[", 
          RowBox[{
           RowBox[{"hosttarget", "==", "\"\<RJB2RHYP\>\""}], ",", 
           RowBox[{
            RowBox[{"tdistmean", "=", 
             RowBox[{
              RowBox[{"Sqrt", "[", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"hdist", "^", "2"}], "+", 
                 RowBox[{"sdepth", "^", "2"}]}], ")"}], "]"}], "+", 
              "mean"}]}], ";", "\[IndentingNewLine]", 
            RowBox[{"tdistmedian", "=", 
             RowBox[{
              RowBox[{"Sqrt", "[", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"hdist", "^", "2"}], "+", 
                 RowBox[{"sdepth", "^", "2"}]}], ")"}], "]"}], "+", 
              "median"}]}], ";", "\[IndentingNewLine]", 
            RowBox[{"tdistmode", "=", 
             RowBox[{
              RowBox[{"Sqrt", "[", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"hdist", "^", "2"}], "+", 
                 RowBox[{"sdepth", "^", "2"}]}], ")"}], "]"}], "+", 
              "mode"}]}], ";"}], ",", 
           RowBox[{"hosttarget", "===", "\"\<RJB2ATSCA\>\""}], ",", 
           RowBox[{
            RowBox[{"h", "=", 
             RowBox[{"Power", "[", 
              RowBox[{"10", ",", 
               RowBox[{
                RowBox[{"-", "0.05"}], "+", 
                RowBox[{"0.15", " ", "mag"}]}]}], "]"}]}], ";", 
            "\[IndentingNewLine]", 
            RowBox[{"tdistmean", "=", 
             RowBox[{"Sqrt", "[", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"hdist", "+", "mean"}], ")"}], "^", "2"}], "+", 
                RowBox[{"h", "^", "2"}]}], ")"}], "]"}]}], ";", 
            "\[IndentingNewLine]", 
            RowBox[{"tdistmedian", "=", 
             RowBox[{"Sqrt", "[", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"hdist", "+", "median"}], ")"}], "^", "2"}], "+", 
                RowBox[{"h", "^", "2"}]}], ")"}], "]"}]}], ";", 
            "\[IndentingNewLine]", 
            RowBox[{"tdistmode", "=", 
             RowBox[{"Sqrt", "[", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"hdist", "+", "mode"}], ")"}], "^", "2"}], "+", 
                RowBox[{"h", "^", "2"}]}], ")"}], "]"}]}], ";"}], ",", "True",
            ",", 
           RowBox[{"(*", "default", "*)"}], 
           RowBox[{
            RowBox[{"tdistmean", "=", 
             RowBox[{"hdist", "+", "mean"}]}], ";", "\[IndentingNewLine]", 
            RowBox[{"tdistmedian", "=", 
             RowBox[{"hdist", "+", "median"}]}], ";", "\[IndentingNewLine]", 
            RowBox[{"tdistmode", "=", 
             RowBox[{"hdist", "+", "mode"}]}], ";"}]}], "]"}], ";"}], ",", 
        RowBox[{"(*", 
         RowBox[{
         "Other", " ", "host", " ", "distances", " ", "are", " ", "currently",
           " ", "treated", " ", "iteratively"}], "*)"}], 
        RowBox[{
         RowBox[{
          RowBox[{"{", 
           RowBox[{
           "rjbinvmean", ",", "rjbinvstd", ",", "rjbinvmedian", ",", 
            "rjbinvmode"}], "}"}], "=", 
          RowBox[{"cv2rjb", "[", 
           RowBox[{"mag", ",", "distinp", ",", "fdepth", ",", "host"}], 
           "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"Which", "[", 
          RowBox[{
           RowBox[{"cpltype", "==", "\"\<MEAN\>\""}], ",", 
           RowBox[{
            RowBox[{"cpldist", "=", "rjbinvmean"}], ";"}], ",", 
           RowBox[{"cpltype", "==", "\"\<MEDIAN\>\""}], ",", 
           RowBox[{
            RowBox[{"cpldist", "=", "rjbinvmedian"}], ";"}], ",", 
           RowBox[{"cpltype", "==", "\"\<MODE\>\""}], ",", 
           RowBox[{
            RowBox[{"cpldist", "=", "rjbinvmode"}], ";"}], ",", "True", ",", 
           RowBox[{
            RowBox[{"cpldist", "=", "rjbinvmedian"}], ";"}]}], "]"}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"target", "==", "\"\<RJB\>\""}], ",", 
           RowBox[{
            RowBox[{
             RowBox[{"{", 
              RowBox[{
              "tdistmean", ",", "std", ",", "tdistmedian", ",", "tdistmode"}],
               "}"}], "=", 
             RowBox[{"{", 
              RowBox[{
              "rjbinvmean", ",", "rjbinvstd", ",", "rjbinvmedian", ",", 
               "rjbinvmode"}], "}"}]}], ";"}], ",", 
           RowBox[{
            RowBox[{
             RowBox[{"{", 
              RowBox[{
              "tdistmean", ",", "std", ",", "tdistmedian", ",", "tdistmode"}],
               "}"}], "=", 
             RowBox[{"ConvertDistanceMetric", "[", 
              RowBox[{"mag", ",", "cpldist", ",", 
               RowBox[{"CDMhostdist", "->", "\"\<RJB\>\""}], ",", 
               RowBox[{"CDMtargetdist", "->", "target"}], ",", 
               RowBox[{"CDMfocdepth", "->", "fdepth"}]}], "]"}]}], ";"}]}], 
          "]"}], ";"}]}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"Return", "[", 
       RowBox[{"{", 
        RowBox[{
        "tdistmean", ",", "std", ",", "tdistmedian", ",", "tdistmode"}], 
        "}"}], "]"}], ";"}]}], "]"}]}], ";"}], "\n"}], "Input",
 CellChangeTimes->{{3.952175379169753*^9, 3.9521753791712103`*^9}, {
  3.952176334102768*^9, 3.952176345512372*^9}, {3.9521768690439672`*^9, 
  3.952176869322795*^9}},
 CellLabel->"In[62]:=",ExpressionUUID->"7b86a85e-eb1f-41ba-b541-d831b3bd71d2"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**",
      "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", 
     "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**",
      "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", 
     "**"}], "*"}], "*)"}], 
  RowBox[{
   RowBox[{
    RowBox[{"ReadEntryfromDistConvCoeffdatalist", "[", 
     RowBox[{"model_", ",", "dccoefflist_"}], "]"}], ":=", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "pos", ",", "idx", ",", "j", ",", "i", ",", "k", ",", "cat", ",", 
        "header", ",", "nrows", ",", "matrix", ",", "entry"}], "}"}], ",", 
      RowBox[{
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Length", "[", 
           RowBox[{"pos", "=", 
            RowBox[{"Position", "[", 
             RowBox[{"dccoefflist", ",", "model"}], "]"}]}], "]"}], ">", 
          "0"}], ",", 
         RowBox[{
          RowBox[{"idx", "=", 
           RowBox[{
            RowBox[{"pos", "[", 
             RowBox[{"[", "1", "]"}], "]"}], "[", 
            RowBox[{"[", "1", "]"}], "]"}]}], ";"}], ",", 
         RowBox[{
          RowBox[{"Print", "[", 
           
           RowBox[{"\"\<Model: \>\"", ",", "model", 
            ",", "\"\< NOT FOUND in DistConvCoeffdatalist.\>\""}], "]"}], ";",
           "\[IndentingNewLine]", 
          RowBox[{"Return", "[", 
           RowBox[{"-", "1"}], "]"}], ";"}]}], "]"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"cat", "=", 
        RowBox[{
         RowBox[{"dccoefflist", "[", 
          RowBox[{"[", "idx", "]"}], "]"}], "[", 
         RowBox[{"[", "2", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"j", "=", "1"}], ";", "\[IndentingNewLine]", 
       RowBox[{"For", "[", 
        RowBox[{
         RowBox[{"i", "=", "1"}], ",", 
         RowBox[{"i", "<=", 
          RowBox[{"Length", "[", "cat", "]"}]}], ",", 
         RowBox[{"i", "++"}], ",", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"cat", "[", 
             RowBox[{"[", "i", "]"}], "]"}], "==", 
            RowBox[{"{", "\"\<#DATABLOCKBEGIN\>\"", "}"}]}], ",", 
           RowBox[{
            RowBox[{"i", "++"}], ";", "\[IndentingNewLine]", 
            RowBox[{"header", "=", 
             RowBox[{"cat", "[", 
              RowBox[{"[", "i", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
            RowBox[{"nrows", "=", 
             RowBox[{"header", "[", 
              RowBox[{"[", "18", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
            RowBox[{"i", "++"}], ";", "\[IndentingNewLine]", 
            RowBox[{"matrix", "=", 
             RowBox[{"{", "}"}]}], ";", "\[IndentingNewLine]", 
            RowBox[{"For", "[", 
             RowBox[{
              RowBox[{"k", "=", "1"}], ",", 
              RowBox[{"k", "<=", "nrows"}], ",", 
              RowBox[{"k", "++"}], ",", 
              RowBox[{
               RowBox[{"AppendTo", "[", 
                RowBox[{"matrix", ",", 
                 RowBox[{"cat", "[", 
                  RowBox[{"[", "i", "]"}], "]"}]}], "]"}], ";", 
               "\[IndentingNewLine]", 
               RowBox[{"i", "++"}], ";"}]}], "]"}], ";", 
            "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"entry", "[", "j", "]"}], "=", 
             RowBox[{"{", 
              RowBox[{"header", ",", "matrix"}], "}"}]}], ";", 
            "\[IndentingNewLine]", 
            RowBox[{"j", "++"}], ";"}]}], "]"}]}], "]"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"(*", 
        RowBox[{
         RowBox[{"Print", "[", 
          RowBox[{"\"\<number of entries in file: \>\"", ",", 
           RowBox[{"j", "-", "1"}]}], "]"}], ";"}], "*)"}], 
       "\[IndentingNewLine]", 
       RowBox[{"Return", "[", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"entry", "[", "i", "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"i", ",", "1", ",", 
            RowBox[{"j", "-", "1"}]}], "}"}]}], "]"}], "]"}], ";"}]}], 
     "]"}]}], "\n", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
     "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**",
       "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**",
       "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**",
       "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**",
       "**"}], "*"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"FindCoeffMat", "[", 
     RowBox[{
     "cat_", ",", "hosttarget_", ",", "mag_", ",", "r_", ",", "type_"}], 
     "]"}], ":=", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "i", ",", "ht", ",", "mmin", ",", "t", ",", "mmax", ",", "dmin", ",", 
        "dmax", ",", "matrix"}], "}"}], ",", 
      RowBox[{
       RowBox[{"For", "[", 
        RowBox[{
         RowBox[{"i", "=", "1"}], ",", 
         RowBox[{"i", "<=", 
          RowBox[{"Length", "[", "cat", "]"}]}], ",", 
         RowBox[{"i", "++"}], ",", 
         RowBox[{
          RowBox[{"ht", "=", 
           RowBox[{"cat", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "1", ",", "6"}], "]"}], "]"}]}], ";", 
          RowBox[{"(*", "CONVTYPE", "*)"}], 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"ht", "==", "hosttarget"}], ",", 
            RowBox[{
             RowBox[{"dmin", "=", 
              RowBox[{"cat", "[", 
               RowBox[{"[", 
                RowBox[{"i", ",", "1", ",", "8"}], "]"}], "]"}]}], ";", 
             RowBox[{"(*", "MINDIST", "*)"}], 
             RowBox[{"dmax", "=", 
              RowBox[{"cat", "[", 
               RowBox[{"[", 
                RowBox[{"i", ",", "1", ",", "10"}], "]"}], "]"}]}], ";", 
             RowBox[{"(*", "MAXDIST", "*)"}], 
             RowBox[{"mmin", "=", 
              RowBox[{"cat", "[", 
               RowBox[{"[", 
                RowBox[{"i", ",", "1", ",", "12"}], "]"}], "]"}]}], ";", 
             RowBox[{"(*", "MINMAG", "*)"}], 
             RowBox[{"mmax", "=", 
              RowBox[{"cat", "[", 
               RowBox[{"[", 
                RowBox[{"i", ",", "1", ",", "14"}], "]"}], "]"}]}], ";", 
             RowBox[{"(*", "MAXMAG", "*)"}], 
             RowBox[{"t", "=", 
              RowBox[{"cat", "[", 
               RowBox[{"[", 
                RowBox[{"i", ",", "1", ",", "16"}], "]"}], "]"}]}], ";", 
             RowBox[{"(*", "PARAMETERTYPE", "*)"}], 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{
                RowBox[{"mag", ">=", "mmin"}], "&&", 
                RowBox[{"mag", "<=", "mmax"}], "&&", 
                RowBox[{"r", ">=", "dmin"}], "&&", 
                RowBox[{"r", "<=", "dmax"}], "&&", 
                RowBox[{"type", "==", "t"}]}], ",", 
               RowBox[{
                RowBox[{"matrix", "=", 
                 RowBox[{"cat", "[", 
                  RowBox[{"[", 
                   RowBox[{"i", ",", "2"}], "]"}], "]"}]}], ";"}]}], "]"}], 
             ";"}]}], "]"}], ";"}]}], "]"}], ";", "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Length", "[", "matrix", "]"}], ">", "0"}], ",", 
         RowBox[{
          RowBox[{"Return", "[", "matrix", "]"}], ";"}], ",", 
         RowBox[{
          RowBox[{"Return", "[", 
           RowBox[{"-", "1"}], "]"}], ";"}]}], "]"}], ";"}]}], 
     "]"}]}]}]}]], "Input",
 CellChangeTimes->{{3.952175551381997*^9, 3.9521755513841743`*^9}, 
   3.952177060486964*^9},
 CellLabel->"In[64]:=",ExpressionUUID->"33f804b6-8b62-4458-bb4e-c3be985ad605"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**",
      "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", 
     "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**",
      "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", 
     "**"}], "*"}], "*)"}], 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"gettargetresidual", "[", 
      RowBox[{"model_", ",", "hosttargetinp_", ",", "mag_", ",", "r_", ",", 
       RowBox[{"label_", ":", "\"\<MEAN\>\""}]}], "]"}], ":=", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "cat", ",", "matm", ",", "nrow", ",", "ncol", ",", "magvec", ",", 
         "mw", ",", "poly", ",", "res", ",", "hosttarget", ",", "i"}], "}"}], 
       ",", 
       RowBox[{"(*", 
        RowBox[{
        "The", " ", "list", " ", "containing", " ", "the", " ", "conversion", 
         " ", "coefficients", " ", 
         RowBox[{"is", ":", 
          RowBox[{
          "DistConvCoeffdatalist", " ", "It", " ", "is", " ", "kept", " ", 
           "in", " ", "an", " ", "extra", " ", "file", " ", "called", 
           " ", "\"\<DistConvCoeffdatalist.m\>\"", " ", "which", " ", "is", " ",
            "included", " ", "at", " ", "the", " ", "beginning", " ", "of", " ",
            "the", " ", "package"}]}]}], "*)"}], 
       RowBox[{
        RowBox[{"cat", "=", 
         RowBox[{"ReadEntryfromDistConvCoeffdatalist", "[", 
          RowBox[{"model", ",", "$DistConvCoeffdatalist"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"cat", "=!=", 
           RowBox[{"-", "1"}]}], ",", 
          RowBox[{
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"hosttargetinp", "===", "\"\<RJB2ATSCA\>\""}], ",", 
             RowBox[{
              RowBox[{"hosttarget", "=", "\"\<RJB2RRUP\>\""}], ";"}], ",", 
             RowBox[{
              RowBox[{"hosttarget", "=", "hosttargetinp"}], ";"}]}], "]"}], ";",
            "\[IndentingNewLine]", 
           RowBox[{"matm", "=", 
            RowBox[{"FindCoeffMat", "[", 
             RowBox[{
             "cat", ",", "hosttarget", ",", "mag", ",", "r", ",", "label"}], 
             "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"matm", "=!=", 
              RowBox[{"-", "1"}]}], ",", 
             RowBox[{
              RowBox[{"nrow", "=", 
               RowBox[{"Length", "[", "matm", "]"}]}], ";", 
              "\[IndentingNewLine]", 
              RowBox[{"ncol", "=", 
               RowBox[{"Length", "[", 
                RowBox[{"matm", "[", 
                 RowBox[{"[", "1", "]"}], "]"}], "]"}]}], ";", 
              "\[IndentingNewLine]", 
              RowBox[{"magvec", "=", 
               RowBox[{"Table", "[", 
                RowBox[{
                 RowBox[{"mw", "^", "i"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"i", ",", "0", ",", 
                   RowBox[{"ncol", "-", "1"}]}], "}"}]}], "]"}]}], ";", 
              "\[IndentingNewLine]", 
              RowBox[{
               RowBox[{"poly", "[", "d_", "]"}], "=", 
               RowBox[{
                RowBox[{
                 RowBox[{"Table", "[", 
                  RowBox[{
                   RowBox[{"d", "^", "i"}], ",", 
                   RowBox[{"{", 
                    RowBox[{"i", ",", "0", ",", 
                    RowBox[{"nrow", "-", "1"}]}], "}"}]}], "]"}], ".", "matm",
                  ".", "magvec"}], "/.", " ", 
                RowBox[{"mw", "->", "mag"}]}]}], ";", "\[IndentingNewLine]", 
              RowBox[{"res", "=", 
               RowBox[{"poly", "[", "r", "]"}]}], ";", "\[IndentingNewLine]", 
              
              RowBox[{"Return", "[", "res", "]"}], ";"}], ",", 
             RowBox[{
              RowBox[{"Return", "[", 
               RowBox[{"-", "999"}], "]"}], ";"}]}], "]"}], ";"}]}], "]"}], 
        ";"}]}], " ", 
      RowBox[{"(*", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"cat", "=!=", 
          RowBox[{"-", "1"}]}], ","}], "]"}], "*)"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"determine", ",", 
     RowBox[{
     "median", " ", "and", " ", "modal", " ", "values", " ", "for", " ", 
      "the", " ", "gamma", " ", "distribution"}]}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
    "Modal", " ", "value", " ", "turned", " ", "of", " ", "for", " ", 
     "speed"}], "*)"}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"gammadistribparams", "[", 
      RowBox[{"meanin_", ",", "stdin_"}], "]"}], ":=", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "alpha", ",", "beta", ",", "f", ",", "median", ",", "x", ",", "mode", 
         ",", "mean", ",", "std"}], "}"}], ",", 
       RowBox[{
        RowBox[{"mean", "=", "meanin"}], ";", "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{
          RowBox[{
          "computations", " ", "blow", " ", "up", " ", "for", " ", 
           "distributions", " ", "where", " ", "std"}], ">=", "mean"}], 
         "*)"}], 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"stdin", "<", "mean"}], ",", 
          RowBox[{"std", "=", "stdin"}], ",", 
          RowBox[{"std", "=", 
           RowBox[{"0.999", " ", "mean"}]}]}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"alpha", "=", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"mean", "/", "std"}], ")"}], "^", "2"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"beta", "=", 
         RowBox[{
          RowBox[{"std", "^", "2"}], "/", "mean"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"beta", ">", "0"}], ",", 
          RowBox[{
           RowBox[{"Clear", "[", 
            RowBox[{"f", ",", "x"}], "]"}], ";", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"f", "[", "x_", "]"}], ":=", 
            RowBox[{"PDF", "[", 
             RowBox[{
              RowBox[{"GammaDistribution", "[", 
               RowBox[{"alpha", ",", "beta"}], "]"}], ",", "x"}], "]"}]}], ";",
            "\[IndentingNewLine]", 
           RowBox[{"median", "=", 
            RowBox[{
             RowBox[{"Quantile", "[", 
              RowBox[{
               RowBox[{"GammaDistribution", "[", 
                RowBox[{"alpha", ",", "beta"}], "]"}], ",", 
               RowBox[{"1", "/", "2"}]}], "]"}], "//", "N"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"(*", 
            RowBox[{
             RowBox[{"data", "=", 
              RowBox[{"Table", "[", 
               RowBox[{
                RowBox[{"f", "[", "x", "]"}], ",", 
                RowBox[{"{", 
                 RowBox[{"x", ",", "0.", ",", "median", ",", 
                  RowBox[{"median", "/", "200."}]}], "}"}]}], "]"}]}], ";", 
             "\[IndentingNewLine]", 
             RowBox[{"pos", "=", 
              RowBox[{"Position", "[", 
               RowBox[{"data", ",", 
                RowBox[{"Max", "[", "data", "]"}]}], "]"}]}], ";", 
             "\[IndentingNewLine]", 
             RowBox[{"mode", "=", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"Flatten", "[", "pos", "]"}], "[", 
                  RowBox[{"[", "1", "]"}], "]"}], "-", "1"}], ")"}], "*", 
               RowBox[{"median", "/", "200."}]}]}], ";"}], "*)"}], 
           RowBox[{"mode", "=", "0."}], ";"}], ",", 
          RowBox[{
           RowBox[{"median", "=", "0."}], ";", "\[IndentingNewLine]", 
           RowBox[{"mode", "=", "0."}], ";"}]}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"Return", "[", 
         RowBox[{"{", 
          RowBox[{"median", ",", "mode"}], "}"}], "]"}], ";"}]}], "]"}]}], 
    ";"}]}]}]], "Input",
 CellChangeTimes->{{3.9521755000078297`*^9, 3.952175500010042*^9}, {
   3.9521756089078827`*^9, 3.952175656214077*^9}, 3.952175760040327*^9, 
   3.952176402435186*^9, 3.9521764406795397`*^9, {3.952176959250539*^9, 
   3.952176962010356*^9}, {3.9521770195873823`*^9, 3.952177034597478*^9}, 
   3.952177133318802*^9},
 CellLabel->"In[66]:=",ExpressionUUID->"a8c0f42e-ec15-4dcc-9024-777052311cf4"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"cvrseis2rjb", "[", 
    RowBox[{"ma_", ",", "rin_", ",", "depthin_"}], "]"}], ":=", 
   RowBox[{"cv2rjb", "[", 
    RowBox[{"ma", ",", "rin", ",", "depthin", ",", "\"\<RSEIS\>\""}], "]"}]}],
   ";"}]], "Input",
 CellChangeTimes->{3.952175763085651*^9},
 CellLabel->"In[68]:=",ExpressionUUID->"96c3ce97-460b-4960-9f94-28a55c0cee46"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
    "For", " ", "the", " ", "lack", " ", "of", " ", "a", " ", "proper", " ", 
     "treatment"}], ",", 
    RowBox[{
    "the", " ", "conversions", " ", "to", " ", "rjb", " ", "are", " ", 
     "performed", " ", "iteratively"}]}], "*)"}], 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
     RowBox[{"cv2rjb", " ", "finds", " ", "the", " ", "three", " ", "rjb"}], "-", 
     RowBox[{"distance", " ", "values", " ", "which"}], "-", 
     RowBox[{
     "in", " ", "the", " ", "input", " ", "distance", " ", "distribution"}], "-", 
     RowBox[{"correspond", " ", "to", " ", "the", " ", "mean"}]}], ",", 
    RowBox[{
    "the", " ", "median", " ", "and", " ", "the", " ", "modal", " ", 
     "value"}], ",", "respectively"}], "*)"}], 
  RowBox[{
   RowBox[{
    RowBox[{"cv2rjb", "[", 
     RowBox[{"ma_", ",", "rin_", ",", "depthin_", ",", "fromdist_"}], "]"}], ":=", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "x", ",", "y", ",", "median", ",", "std", ",", "dummy2", ",", "dummy3",
         ",", "mag", ",", "depth", ",", "step", ",", "dummy"}], "}"}], ",", 
      RowBox[{
       RowBox[{"step", "=", ".25"}], ";", 
       RowBox[{"(*", 
        RowBox[{"step", " ", "width", " ", "in", " ", "km"}], "*)"}], 
       RowBox[{"y", "=", "rin"}], ";", "\[IndentingNewLine]", 
       RowBox[{"mag", "=", "ma"}], ";", "\[IndentingNewLine]", 
       RowBox[{"depth", "=", "depthin"}], ";", "\[IndentingNewLine]", 
       RowBox[{"(*", "median", "*)"}], 
       RowBox[{"x", "=", 
        RowBox[{
         RowBox[{"ConvertDistanceMetric", "[", 
          RowBox[{"mag", ",", "y", ",", 
           RowBox[{"CDMhostdist", "->", "\"\<RJB\>\""}], ",", 
           RowBox[{"CDMtargetdist", "->", "fromdist"}], ",", 
           RowBox[{"CDMfocdepth", "->", "depth"}]}], "]"}], "[", 
         RowBox[{"[", "3", "]"}], "]"}]}], ";", 
       RowBox[{"(*", 
        RowBox[{"coupled", " ", "through", " ", "median", " ", "value"}], 
        "*)"}], 
       RowBox[{"(*", 
        RowBox[{
         RowBox[{"Print", "[", 
          
          RowBox[{"\"\<Median R: \>\"", ",", "y", ",", "\"\< -> \>\"", ",", 
           "x"}], "]"}], ";"}], "*)"}], 
       RowBox[{"While", "[", 
        RowBox[{
         RowBox[{"x", ">", "rin"}], ",", 
         RowBox[{
          RowBox[{"y", "-=", "step"}], ";", "\[IndentingNewLine]", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"y", ">", "0"}], ",", 
            RowBox[{
             RowBox[{"x", "=", 
              RowBox[{
               RowBox[{"ConvertDistanceMetric", "[", 
                RowBox[{"mag", ",", "y", ",", 
                 RowBox[{"CDMhostdist", "->", "\"\<RJB\>\""}], ",", 
                 RowBox[{"CDMtargetdist", "->", "fromdist"}], ",", 
                 RowBox[{"CDMfocdepth", "->", "depth"}]}], "]"}], "[", 
               RowBox[{"[", "3", "]"}], "]"}]}], ";"}], " ", 
            RowBox[{"(*", 
             RowBox[{"coupled", " ", "through", " ", "median", " ", "value"}],
              "*)"}], ",", 
            RowBox[{
             RowBox[{"y", "=", "0"}], ";", "\[IndentingNewLine]", 
             RowBox[{"x", "=", "0"}], ";"}]}], "]"}], ";"}]}], "]"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"median", "=", "y"}], ";", "\[IndentingNewLine]", 
       RowBox[{"(*", 
        RowBox[{
         RowBox[{"Print", "[", 
          
          RowBox[{"\"\<Median: \>\"", ",", "y", ",", "\"\< -> \>\"", ",", 
           "median"}], "]"}], ";"}], "*)"}], 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"dummy", ",", "std", ",", "dummy2", ",", "dummy3"}], "}"}], "=", 
        RowBox[{"ConvertDistanceMetric", "[", 
         RowBox[{"mag", ",", "median", ",", 
          RowBox[{"CDMhostdist", "->", "\"\<RJB\>\""}], ",", 
          RowBox[{"CDMtargetdist", "->", "fromdist"}], ",", 
          RowBox[{"CDMfocdepth", "->", "depth"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"(*", 
        RowBox[{
         RowBox[{
         "to", " ", "speed", " ", "up", " ", "the", " ", "calculation", " ", 
          "for", " ", "now"}], ",", 
         RowBox[{
         "since", " ", "median", " ", "is", " ", "used", " ", "anyway"}], ",", 
         RowBox[{"ignore", " ", "the", " ", "other", " ", "options"}]}], 
        "*)"}], 
       RowBox[{"(*", 
        RowBox[{"(*", "mean", "*)"}], 
        RowBox[{
         RowBox[{"y", "=", "rin"}], ";", "\[IndentingNewLine]", 
         RowBox[{"x", "=", 
          RowBox[{
           RowBox[{"ConvertDistanceMetric", "[", 
            RowBox[{"mag", ",", "y", ",", 
             RowBox[{"CDMhostdist", "->", "\"\<RJB\>\""}], ",", 
             RowBox[{"CDMtargetdist", "->", "fromdist"}], ",", 
             RowBox[{"CDMfocdepth", "->", "depth"}]}], "]"}], "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], ";", 
         RowBox[{"(*", 
          RowBox[{"coupled", " ", "through", " ", "mean", " ", "value"}], 
          "*)"}], 
         RowBox[{"(*", 
          RowBox[{
           RowBox[{"Print", "[", 
            
            RowBox[{"\"\<Mean input R: \>\"", ",", "y", ",", "\"\< -> \>\"", ",",
              "x"}], "]"}], ";"}], "*)"}], 
         RowBox[{"While", "[", 
          RowBox[{
           RowBox[{"x", ">", "rin"}], ",", 
           RowBox[{
            RowBox[{"y", "-=", "step"}], ";", "\[IndentingNewLine]", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{"y", ">", "0"}], ",", 
              RowBox[{
               RowBox[{"x", "=", 
                RowBox[{
                 RowBox[{"ConvertDistanceMetric", "[", 
                  RowBox[{"mag", ",", "y", ",", 
                   RowBox[{"CDMhostdist", "->", "\"\<RJB\>\""}], ",", 
                   RowBox[{"CDMtargetdist", "->", "fromdist"}], ",", 
                   RowBox[{"CDMfocdepth", "->", "depth"}]}], "]"}], "[", 
                 RowBox[{"[", "1", "]"}], "]"}]}], ";"}], " ", 
              RowBox[{"(*", 
               RowBox[{"coupled", " ", "through", " ", "mean", " ", "value"}],
                "*)"}], ",", 
              RowBox[{
               RowBox[{"y", "=", "0"}], ";", "\[IndentingNewLine]", 
               RowBox[{"x", "=", "0"}], ";"}]}], "]"}], ";"}]}], "]"}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"mean", "=", "y"}], ";", "\[IndentingNewLine]", 
         RowBox[{"(*", 
          RowBox[{
           RowBox[{"Print", "[", 
            
            RowBox[{"\"\<Mean R: \>\"", ",", "y", ",", "\"\< -> \>\"", ",", 
             "x"}], "]"}], ";"}], "*)"}], 
         RowBox[{"(*", "mode", "*)"}], 
         RowBox[{"y", "=", "rin"}], ";", "\[IndentingNewLine]", 
         RowBox[{"(*", 
          RowBox[{
           RowBox[{"Print", "[", 
            RowBox[{"\"\<Mode input: \>\"", ",", "y"}], "]"}], ";"}], "*)"}], 
         
         RowBox[{"x", "=", 
          RowBox[{
           RowBox[{"ConvertDistanceMetric", "[", 
            RowBox[{"mag", ",", "y", ",", 
             RowBox[{"CDMhostdist", "->", "\"\<RJB\>\""}], ",", 
             RowBox[{"CDMtargetdist", "->", "fromdist"}], ",", 
             RowBox[{"CDMfocdepth", "->", "depth"}]}], "]"}], "[", 
           RowBox[{"[", "4", "]"}], "]"}]}], ";", 
         RowBox[{"(*", 
          RowBox[{"coupled", " ", "through", " ", "modal", " ", "value"}], 
          "*)"}], 
         RowBox[{"(*", 
          RowBox[{
           RowBox[{"Print", "[", 
            
            RowBox[{"\"\<Mode R: \>\"", ",", "y", ",", "\"\< -> \>\"", ",", 
             "x"}], "]"}], ";"}], "*)"}], 
         RowBox[{"While", "[", 
          RowBox[{
           RowBox[{"x", ">", "rin"}], ",", 
           RowBox[{
            RowBox[{"y", "-=", "step"}], ";", "\[IndentingNewLine]", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{"y", ">", "0"}], ",", 
              RowBox[{
               RowBox[{"x", "=", 
                RowBox[{
                 RowBox[{"ConvertDistanceMetric", "[", 
                  RowBox[{"mag", ",", "y", ",", 
                   RowBox[{"CDMhostdist", "->", "\"\<RJB\>\""}], ",", 
                   RowBox[{"CDMtargetdist", "->", "fromdist"}], ",", 
                   RowBox[{"CDMfocdepth", "->", "depth"}]}], "]"}], "[", 
                 RowBox[{"[", "4", "]"}], "]"}]}], ";"}], " ", 
              RowBox[{"(*", 
               RowBox[{
               "coupled", " ", "through", " ", "modal", " ", "value"}], 
               "*)"}], ",", 
              RowBox[{
               RowBox[{"y", "=", "0"}], ";", "\[IndentingNewLine]", 
               RowBox[{"x", "=", "0"}], ";"}]}], "]"}], ";"}]}], "]"}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"mode", "=", "y"}], ";"}], "*)"}], 
       RowBox[{"(*", 
        RowBox[{
         RowBox[{"Print", "[", 
          
          RowBox[{"\"\<Mode R: \>\"", ",", "y", ",", "\"\< -> \>\"", ",", 
           "x"}], "]"}], ";"}], "*)"}], "\[IndentingNewLine]", 
       RowBox[{"Return", "[", 
        RowBox[{"{", 
         RowBox[{"median", ",", "std", ",", "median", ",", "median"}], "}"}], 
        "]"}], ";"}]}], "]"}]}], ";"}]}]], "Input",
 CellChangeTimes->{{3.952175718299144*^9, 3.952175718301571*^9}, 
   3.9521765843422832`*^9},
 CellLabel->"In[69]:=",ExpressionUUID->"909d6862-5ec5-4746-a50d-29a13351a671"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**",
      "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", 
     "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**",
      "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", 
     "**"}], "*"}], "*)"}], 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
        "The", " ", "Icon", " ", "below", " ", "contains", " ", "ONLY", " ", 
         "the", " ", "list", " ", "DistConvCoeffdatalist", " ", "which", " ", 
         "contains", " ", "all", " ", "conversion", " ", "coefficients", " ", 
         "for", " ", "distance", " ", "conversions", " ", "accessible", " ", 
         "through", " ", 
         RowBox[{
          RowBox[{"convertdistances", "[", "]"}], ".", "It"}], " ", "is", " ",
          "actually", " ", "used", " ", "in", " ", "module", " ", 
         RowBox[{"gettargetresidual", "[", "]"}], " ", "in", " ", 
         RowBox[{"gmmsupport", ".", "m"}], " ", "The", " ", "preparation", " ",
          "of", " ", "this", " ", "file", " ", "is", " ", "done", " ", "in", " ",
          "notebook", " ", "PrepareDistanceConversionCoefficients", " ", 
         "located", " ", "in", " ", "the", " ", "subdirectory", " ", 
         "Distanceconversion", " ", "It", " ", "is", " ", "based", " ", "on", 
         " ", "some", " ", "naming", " ", 
         RowBox[{"conventions", ":", "1"}]}], ")"}], " ", "The", " ", "file", 
       " ", "name", " ", "containing", " ", "the", " ", "coefficients", " ", 
       "has", " ", "to", " ", "start", " ", "with", " ", "the", " ", "label", 
       " ", "identifying", " ", "the", " ", "model", " ", "and", " ", "the", " ",
        "faulttype", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"e", ".", "g", ".", "WCGEN"}], " ", "for", " ", "the", " ",
            "Wells"}], "&"}], "Coppersmith", " ", "model", " ", "for", " ", 
         "the", " ", "generic", " ", "dip", " ", "angles"}], ")"}], " ", 
       "followede", " ", "by", " ", "an", " ", 
       RowBox[{"underscore", ".", "The"}], " ", "rest", " ", "of", " ", "the",
        " ", "filename", " ", "is", " ", "usually", " ", 
       RowBox[{"CVCOEFFS", ".", "txt", ".", "2"}]}], ")"}], " ", "The", " ", 
     "directory", " ", "distconvdir", " ", "must", " ", "NOT", " ", "contain",
      " ", "any", " ", "files", " ", "other", " ", "than", " ", "files", " ", 
     "containing", " ", "conversion", " ", "coefficient", " ", "In", " ", 
     "other", " ", "words"}], ",", 
    RowBox[{
    "all", " ", "files", " ", "within", " ", "this", " ", "directory", " ", 
     "have", " ", "to", " ", "obey", " ", "the", " ", "naming", " ", 
     RowBox[{"convention", ".", "Check"}], " ", "the", " ", "file", " ", 
     "list", " ", 
     RowBox[{"above", "."}]}]}], "*)"}], 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**",
      "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", 
     "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**",
      "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", 
     "**"}], "*"}], "*)"}], 
  RowBox[{
   RowBox[{"DistConvCoeffdatalist", "=", 
    InterpretationBox[
     DynamicModuleBox[{Typeset`open = False}, 
      TemplateBox[{"Expression", 
        StyleBox[
        "\"DistConvCoeffdatalist \"", "IconizedCustomName", StripOnInput -> 
         False], 
        GridBox[{{
           RowBox[{
             TagBox["\"Head: \"", "IconizedLabel"], "\[InvisibleSpace]", 
             TagBox["Symbol", "IconizedItem"]}]}, {
           RowBox[{
             TagBox["\"Byte count: \"", "IconizedLabel"], "\[InvisibleSpace]", 
             TagBox["0", "IconizedItem"]}]}}, 
         GridBoxAlignment -> {"Columns" -> {{Left}}}, DefaultBaseStyle -> 
         "Column", 
         GridBoxItemSize -> {
          "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
        Dynamic[Typeset`open]},
       "IconizedObject"]],
     Null,
     SelectWithContents->True,
     Selectable->False]}], ";"}]}]], "Input",
 CellChangeTimes->{{3.952175875514715*^9, 3.952175878581953*^9}, 
   3.95217593272929*^9, 3.952176022791711*^9, 3.952176124417823*^9, {
   3.952176162047345*^9, 3.952176217609655*^9}, {3.95217655239393*^9, 
   3.952176600878787*^9}},
 CellLabel->"In[70]:=",ExpressionUUID->"1163e53b-ff27-4c18-9eac-932199615964"]
}, Closed]],

Cell[CellGroupData[{

Cell["AbrahamsonAndSilva2008Hor", "Subsubsection",
 CellChangeTimes->{{3.952169552360321*^9, 3.952169577087267*^9}, 
   3.952172831298647*^9, 
   3.952173326385323*^9},ExpressionUUID->"b5d0cdb5-80ea-43f8-a59e-\
5951d27245cd"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"AbrahamsonAndSilva2008Hor", "::", "usage"}], 
   "=", "\"\<AbrahamsonAndSilva2008Hor[p,options] returns {Subscript[a, \
SA](p), \[Sigma], \\!\\(\n\\*SubscriptBox[\\(\[PartialD]\\), \\(R\\)]\\(\n\
SubscriptBox[\\(a\\), \\(SA\\)](p)\\)\\), \\!\\(\n\\*SubscriptBox[\\(\
\[PartialD]\\), \\(M\\)]\\(\nSubscriptBox[\\(a\\), \\(SA\\)](p)\\)\\)}, a \
list of expected ground-motion parameters for a given earthquake scenario \
using the NGA model of Abrahamson and Silva (2008). The model is based on \
2754 recordings from 135 earthquakes from the NGA dataset.\>\""}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"DistRUP", "::", "usage"}], 
   "=", "\"\<Option for ground-motion prediction equations to input the \
rupture distance. Default setting: DistRUP -> 10. \>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"DistHWJB", "::", "usage"}], 
   "=", "\"\<Option for ground-motion prediction equations that have a \
hanging-wall term which makes use of the ratio between rupture and \
JoynerBoore distance.\>\""}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"HangingWallFlag", "::", "usage"}], 
   "=", "\"\<True or False for a point on or off the hanging wall of a fault, \
respectively.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"DepthToTopOfRupture", "::", "usage"}], 
   "=", "\"\<Depth to top of the rupture (\\!\\(z\\_tor\\)) in km.\>\""}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"FaultDip", "::", "usage"}], 
   "=", "\"\<Fault dip in degrees.\>\""}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"DownDipRuptureWidth", "::", "usage"}], 
   "=", "\"\<Rupture width in the dip rupture direction\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"BasinDepthZ10", "::", "usage"}], 
   "=", "\"\<Basin depth proxy. Depth to a shear wave velocity of 1 km/s. \
Must be given in meters\>\""}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"VS30Determination", "::", "usage"}], 
   "=", "\"\<\\\"ESTIMATED\\\" or \\\"MEASURED\\\".\>\""}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.9521733525091457`*^9, 3.9521733579012527`*^9}, {
  3.952173562414713*^9, 3.952173571367897*^9}, {3.952173618727248*^9, 
  3.952173640935*^9}, {3.95217367166626*^9, 3.952173745652939*^9}},
 CellLabel->"In[71]:=",ExpressionUUID->"6d4d6baf-7f09-48d3-be3a-5e1e5aa1b850"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
     RowBox[{
     "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**",
       "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**",
       "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**",
       "**", "**", "**", "**", "**", "The"}], " ", "next", " ", "model", " ", 
     "is", " ", "the", " ", "NGA", " ", "model", " ", "of", " ", "Abrahamson",
      " ", "and", " ", "Silva", " ", 
     RowBox[{
      RowBox[{"(", "2008", ")"}], ".", "The"}], " ", "implementation", " ", 
     "here", " ", "follows", " ", "the", " ", "Fortran", " ", "code", " ", 
     "of", " ", "the", " ", "HAZARD39", " ", "program"}], ",", 
    RowBox[{"written", " ", "by", " ", "Norm", " ", 
     RowBox[{"Abrahamson", "."}]}]}], 
   "**************************************************************************************)"}\
], 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Options", "[", "AbrahamsonAndSilva2008Hor", "]"}], "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"MagMW", "->", "6."}], ",", 
       RowBox[{"DistRUP", "->", "10."}], ",", 
       RowBox[{"DistHWJB", "->", "Automatic"}], ",", 
       RowBox[{"FaultTypeNSSR", "->", "\"\<REVERSE\>\""}], ",", 
       RowBox[{"DepthToTopOfRupture", "->", "1."}], ",", 
       RowBox[{"HangingWallFlag", "->", "True"}], ",", 
       RowBox[{"FaultDip", "->", "60."}], ",", 
       RowBox[{"Vs30", "->", "760."}], ",", 
       RowBox[{"DownDipRuptureWidth", "->", "10."}], ",", 
       RowBox[{"BasinDepthZ10", "->", "\"\<Default\>\""}], ",", 
       RowBox[{"VS30Determination", "->", "\"\<MEASURED\>\""}]}], "}"}]}], 
    ";"}], "\[IndentingNewLine]", "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"AbrahamsonAndSilva2008Hor", "[", 
      RowBox[{"per_", ",", 
       RowBox[{"opts", ":", 
        RowBox[{"OptionsPattern", "[", "]"}]}]}], "]"}], ":=", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "mw", ",", "rrup", ",", "rjb", ",", "faulttypeinp", ",", "ztor", ",", 
         "hw", ",", "delta", ",", "vs30", ",", "ddrw", ",", "basin", ",", 
         "vs30class", ",", "srcsitea", ",", "vs30rock", ",", "basinrock", ",",
          "perpga", ",", "pgarock", ",", "frv", ",", "fn", ",", "td", ",", 
         "lnsatd", ",", "lnsarock", ",", "lnsa1", ",", "lnsa2", ",", "lnsa", ",",
          "sigma", ",", "tau", ",", "sigmatot", ",", "saval", ",", "out", ",",
          "defaultdepth", ",", "pdmag", ",", "pddist", ",", "basinopt"}], 
        "}"}], ",", 
       RowBox[{"(*", 
        RowBox[{"**", "**", "Options"}], "****)"}], 
       RowBox[{
        RowBox[{"mw", "=", 
         RowBox[{"OptionValue", "[", "MagMW", "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"rrup", "=", 
         RowBox[{"OptionValue", "[", "DistRUP", "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"rjb", "=", 
         RowBox[{"OptionValue", "[", "DistHWJB", "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"faulttypeinp", "=", 
         RowBox[{"OptionValue", "[", "FaultTypeNSSR", "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"ztor", "=", 
         RowBox[{"OptionValue", "[", "DepthToTopOfRupture", "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"hw", "=", 
         RowBox[{"OptionValue", "[", "HangingWallFlag", "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"delta", "=", 
         RowBox[{"OptionValue", "[", "FaultDip", "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"vs30", "=", 
         RowBox[{"OptionValue", "[", "Vs30", "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"ddrw", "=", 
         RowBox[{"OptionValue", "[", "DownDipRuptureWidth", "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"basinopt", "=", 
         RowBox[{"OptionValue", "[", "BasinDepthZ10", "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"vs30class", "=", 
         RowBox[{"OptionValue", "[", "VS30Determination", "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{
          RowBox[{"HW", " ", 
           RowBox[{"factors", ":", 
            RowBox[{"For", " ", "now"}]}]}], ",", 
          RowBox[{
          "convert", " ", "hwflag", " ", "to", " ", "an", " ", "equivalent", " ",
            "srcSiteA"}]}], "*)"}], 
        RowBox[{"If", "[", 
         RowBox[{"hw", ",", 
          RowBox[{
           RowBox[{"srcsitea", "=", "90."}], ";"}], ",", 
          RowBox[{
           RowBox[{"srcsitea", "=", "0."}], ";"}]}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{"style", " ", "of", " ", "faulting"}], "*)"}], 
        RowBox[{"Which", "[", 
         RowBox[{
          RowBox[{"faulttypeinp", "==", "\"\<REVERSE\>\""}], ",", 
          RowBox[{
           RowBox[{"frv", "=", "1."}], ";", "\[IndentingNewLine]", 
           RowBox[{"fn", "=", "0."}], ";"}], ",", 
          RowBox[{"faulttypeinp", "==", "\"\<NORMAL\>\""}], ",", 
          RowBox[{
           RowBox[{"frv", "=", "0."}], ";", "\[IndentingNewLine]", 
           RowBox[{"fn", "=", "1."}], ";"}], ",", 
          RowBox[{"faulttypeinp", "==", "\"\<STRIKE SLIP\>\""}], ",", 
          RowBox[{
           RowBox[{"frv", "=", "0."}], ";", "\[IndentingNewLine]", 
           RowBox[{"fn", "=", "0."}], ";"}], ",", "True", ",", 
          RowBox[{
           RowBox[{"Message", "[", 
            RowBox[{
             RowBox[{"EmpiricalEquation", "::", "option"}], ",", 
             "faulttypeinp", ",", "FaultTypeNSSR"}], "]"}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"Return", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", "999."}], ",", 
              RowBox[{"-", "999."}], ",", 
              RowBox[{"-", "999."}], ",", 
              RowBox[{"-", "999."}]}], "}"}], "]"}], ";"}]}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{"distance", " ", "conversion"}], "*)"}], 
        RowBox[{"defaultdepth", "=", "10."}], ";", "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"rjb", "===", "Automatic"}], ",", 
          RowBox[{
           RowBox[{"rjb", "=", 
            RowBox[{
             RowBox[{"ConvertDistanceMetric", "[", 
              RowBox[{"mw", ",", "rrup", ",", 
               RowBox[{"CDMhostdist", "->", "\"\<RRUP\>\""}], ",", 
               RowBox[{"CDMtargetdist", "->", "\"\<RJB\>\""}]}], "]"}], "[", 
             RowBox[{"[", "3", "]"}], "]"}]}], " ", 
           RowBox[{"(*", 
            RowBox[{"median", " ", "value", " ", "for", " ", "rjb"}], "*)"}], 
           ";"}]}], "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{
         "calculate", " ", "basin", " ", "depth", " ", "from", " ", "vs30", " ",
           "when", " ", "unknown"}], "*)"}], 
        RowBox[{"Which", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"StringQ", "[", "basinopt", "]"}], "&&", 
           RowBox[{"StringMatchQ", "[", 
            RowBox[{"basinopt", ",", "\"\<Default\>\""}], "]"}]}], ",", 
          RowBox[{
           RowBox[{"Which", "[", 
            RowBox[{
             RowBox[{"vs30", "<", "180."}], ",", 
             RowBox[{
              RowBox[{"basin", "=", 
               RowBox[{"Exp", "[", "6.745", "]"}]}], ";"}], ",", 
             RowBox[{"180.", "<=", "vs30", "<=", "500."}], ",", 
             RowBox[{
              RowBox[{"basin", "=", 
               RowBox[{"Exp", "[", 
                RowBox[{"6.745", "-", 
                 RowBox[{"1.35", " ", 
                  RowBox[{"Log", "[", 
                   RowBox[{"vs30", "/", "180."}], "]"}]}]}], "]"}]}], ";"}], ",", 
             RowBox[{"vs30", ">", "500."}], ",", 
             RowBox[{
              RowBox[{"basin", "=", 
               RowBox[{"Exp", "[", 
                RowBox[{"5.394", "-", 
                 RowBox[{"4.48", " ", 
                  RowBox[{"Log", "[", 
                   RowBox[{"vs30", "/", "500."}], "]"}]}]}], "]"}]}], ";"}]}],
             "]"}], ";", "\[IndentingNewLine]", 
           RowBox[{"basin", "=", 
            RowBox[{"basin", "/", "1000."}]}], ";"}], ",", 
          RowBox[{"NumericQ", "[", "basinopt", "]"}], ",", 
          RowBox[{
           RowBox[{"basin", "=", 
            RowBox[{"basinopt", "/", "1000."}]}], ";"}], ",", "True", ",", 
          RowBox[{
           RowBox[{"Message", "[", 
            RowBox[{
             RowBox[{"EmpiricalEquation", "::", "basin"}], ",", 
             "BasinDepthZ10"}], "]"}], ";", "\[IndentingNewLine]", 
           RowBox[{"Return", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", "999."}], ",", 
              RowBox[{"-", "999."}], ",", 
              RowBox[{"-", "999."}], ",", 
              RowBox[{"-", "999."}]}], "}"}], "]"}], ";"}]}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{"compute", " ", "pga", " ", "on", " ", "rock"}], "*)"}], 
        RowBox[{"vs30rock", "=", "1100."}], ";", "\[IndentingNewLine]", 
        RowBox[{"basinrock", "=", "0.006"}], ";", "\[IndentingNewLine]", 
        RowBox[{"perpga", "=", "0."}], ";", "\[IndentingNewLine]", 
        RowBox[{"pgarock", "=", "0."}], ";", "\[IndentingNewLine]", 
        RowBox[{"pgarock", "=", 
         RowBox[{
          RowBox[{"as2008", "[", 
           RowBox[{
           "perpga", ",", "mw", ",", "rrup", ",", "rjb", ",", "frv", ",", 
            "fn", ",", "delta", ",", "ztor", ",", "srcsitea", ",", "vs30rock",
             ",", "basinrock", ",", "ddrw", ",", "hw", ",", "vs30class", ",", 
            "pgarock"}], "]"}], "[", 
          RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"pgarock", "=", 
         RowBox[{"Exp", "[", "pgarock", "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{
         "compute", " ", "spectral", " ", "period", " ", "for", " ", 
          "constant", " ", "displacement", " ", "model", " ", 
          RowBox[{"(", 
           RowBox[{"eq", " ", "21"}], ")"}]}], "*)"}], 
        RowBox[{"td", "=", 
         RowBox[{"10", "^", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1.25"}], "+", 
            RowBox[{"0.3", " ", "mw"}]}], ")"}]}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"per", ">=", "td"}], ",", 
          RowBox[{"(*", 
           RowBox[{
            RowBox[{
            "Compute", " ", "Sa", " ", "at", " ", "TD", " ", "spectral", " ", 
             "period", " ", "for", " ", "Vs30"}], "=", 
            RowBox[{"1100", 
             RowBox[{"m", "/", "sec"}]}]}], "*)"}], 
          RowBox[{
           RowBox[{"lnsatd", "=", 
            RowBox[{
             RowBox[{"as2008", "[", 
              RowBox[{
              "td", ",", "mw", ",", "rrup", ",", "rjb", ",", "frv", ",", "fn",
                ",", "delta", ",", "ztor", ",", "srcsitea", ",", "vs30rock", ",",
                "basinrock", ",", "ddrw", ",", "hw", ",", "vs30class", ",", 
               "pgarock"}], "]"}], "[", 
             RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"lnsarock", "=", 
            RowBox[{"lnsatd", "+", 
             RowBox[{"Log", "[", 
              RowBox[{
               RowBox[{"td", "^", "2"}], "/", 
               RowBox[{"per", "^", "2"}]}], "]"}]}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"(*", 
            RowBox[{
            "Compute", " ", "Sa", " ", "at", " ", "spectral", " ", "period", " ",
              "for", " ", "Vs30"}], "*)"}], 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
             "lnsa1", ",", "sigma", ",", "tau", ",", "pddist", ",", "pdmag"}],
              "}"}], "=", 
            RowBox[{"as2008", "[", 
             RowBox[{
             "per", ",", "mw", ",", "rrup", ",", "rjb", ",", "frv", ",", "fn",
               ",", "delta", ",", "ztor", ",", "srcsitea", ",", "vs30", ",", 
              "basin", ",", "ddrw", ",", "hw", ",", "vs30class", ",", 
              "pgarock"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"(*", 
            RowBox[{
             RowBox[{
             "Compute", " ", "Sa", " ", "at", " ", "spectral", " ", "period", 
              " ", "for", " ", "Vs30"}], "=", 
             RowBox[{"1100", 
              RowBox[{"m", "/", "s"}]}]}], "*)"}], 
           RowBox[{"lnsa2", "=", 
            RowBox[{
             RowBox[{"as2008", "[", 
              RowBox[{
              "per", ",", "mw", ",", "rrup", ",", "rjb", ",", "frv", ",", 
               "fn", ",", "delta", ",", "ztor", ",", "srcsitea", ",", 
               "vs30rock", ",", "basinrock", ",", "ddrw", ",", "hw", ",", 
               "vs30class", ",", "pgarock"}], "]"}], "[", 
             RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"(*", 
            RowBox[{"Compute", " ", "soil", " ", "amplification", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"i", ".", "e", "."}], ",", 
               RowBox[{
                RowBox[{"'", "lnSa1"}], "-", 
                RowBox[{"lnSa2", "'"}]}]}], ")"}], " ", "and", " ", "add", " ",
              "to", " ", "Constant", " ", "displcaement", " ", "rock", " ", 
             "spectrum"}], "*)"}], 
           RowBox[{"lnsa", "=", 
            RowBox[{"lnsarock", "+", 
             RowBox[{"(", 
              RowBox[{"lnsa1", "-", "lnsa2"}], ")"}]}]}], ";"}], ",", 
          RowBox[{"(*", 
           RowBox[{
            RowBox[{"else", " ", "per"}], "<", "td"}], "*)"}], 
          RowBox[{"(*", 
           RowBox[{
            RowBox[{"For", " ", "cases", " ", "where", " ", "specT"}], "<", 
            RowBox[{
            "TD", " ", "compute", " ", "regular", " ", "ground", " ", 
             RowBox[{"motions", "."}]}]}], "*)"}], 
          RowBox[{
           RowBox[{
            RowBox[{"{", 
             RowBox[{
             "lnsa", ",", "sigma", ",", "tau", ",", "pddist", ",", "pdmag"}], 
             "}"}], "=", 
            RowBox[{"as2008", "[", 
             RowBox[{
             "per", ",", "mw", ",", "rrup", ",", "rjb", ",", "frv", ",", "fn",
               ",", "delta", ",", "ztor", ",", "srcsitea", ",", "vs30", ",", 
              "basin", ",", "ddrw", ",", "hw", ",", "vs30class", ",", 
              "pgarock"}], "]"}]}], ";"}]}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"sigmatot", "=", 
         RowBox[{"Sqrt", "[", 
          RowBox[{
           RowBox[{"sigma", "^", "2"}], "+", 
           RowBox[{"tau", "^", "2"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"saval", "=", 
         RowBox[{"9.81", " ", 
          RowBox[{"Exp", "[", "lnsa", "]"}]}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"out", "=", 
         RowBox[{"{", 
          RowBox[{"saval", ",", "sigmatot", ",", "pddist", ",", "pdmag"}], 
          "}"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"Return", "[", "out", "]"}], ";"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"as2008", "[", 
      RowBox[{
      "per_", ",", "mw_", ",", "rrup_", ",", "rjb_", ",", "frv_", ",", "fn_", 
       ",", "delta_", ",", "ztor_", ",", "srcsitea_", ",", "vs30_", ",", 
       "basin_", ",", "ddrw_", ",", "hw_", ",", "vs30class_", ",", 
       "pgarock_"}], "]"}], ":=", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "a1list", ",", "a2list", ",", "a3list", ",", "a4list", ",", "a5list", 
         ",", "a6list", ",", "a7list", ",", "a8list", ",", "a9list", ",", 
         "a10list", ",", "a11list", ",", "a12list", ",", "a13list", ",", 
         "a14list", ",", "a15list", ",", "c4list", ",", "a16list", ",", 
         "a17list", ",", "a18list", ",", "s1elist", ",", "s2elist", ",", 
         "s1mlist", ",", "s2mlist", ",", "s3list", ",", "s4list", ",", "a1", ",",
          "a2", ",", "a3", ",", "a4", ",", "a5", ",", "a6", ",", "a7", ",", 
         "a8", ",", "a9", ",", "a10", ",", "a11", ",", "a12", ",", "a13", ",",
          "a14", ",", "a15", ",", "c4", ",", "a16", ",", "a17", ",", "a18", ",",
          "s1", ",", "s2", ",", "s3", ",", "s4", ",", "periodlist", ",", 
         "vlinlist", ",", "bsoillist", ",", "sigcorrlist", ",", "taucorrlist",
          ",", "vlin", ",", "bsoil", ",", "sigcorr", ",", "taucorr", ",", "n",
          ",", "c", ",", "sigamp", ",", "pos", ",", "r", ",", "rx", ",", "c1",
          ",", "taper1", ",", "taper2", ",", "taper3", ",", "taper4", ",", 
         "taper5", ",", "v1", ",", "vsstar", ",", "a21", ",", "a22", ",", 
         "e2", ",", "c2", ",", "test", ",", "testv1", ",", "zhat", ",", 
         "soilamp", ",", "f1", ",", "f4", ",", "f6", ",", "f8", ",", "f10", ",",
          "t6", ",", "sigmanot", ",", "sigmanotpga", ",", "sigmab", ",", 
         "sigmabpga", ",", "taunot", ",", "taunotpga", ",", "dampdpga", ",", 
         "sigma", ",", "tau", ",", "lny", ",", "pddist", ",", "pdmag"}], 
        "}"}], ",", 
       RowBox[{
        RowBox[{"periodlist", "=", 
         RowBox[{"{", 
          RowBox[{"0.0", ",", 
           RowBox[{"-", "1.0"}], ",", 
           RowBox[{"-", "2.0"}], ",", "0.01", ",", "0.02", ",", "0.022", ",", 
           "0.025", ",", "0.029", ",", "0.03", ",", "0.032", ",", "0.035", ",",
            "0.036", ",", "0.04", ",", "0.042", ",", "0.044", ",", "0.045", ",",
            "0.046", ",", "0.048", ",", "0.05", ",", "0.055", ",", "0.06", ",",
            "0.065", ",", "0.067", ",", "0.07", ",", "0.075", ",", "0.08", ",",
            "0.085", ",", "0.09", ",", "0.095", ",", "0.1", ",", "0.11", ",", 
           "0.12", ",", "0.13", ",", "0.133", ",", "0.14", ",", "0.15", ",", 
           "0.16", ",", "0.17", ",", "0.18", ",", "0.19", ",", "0.2", ",", 
           "0.22", ",", "0.24", ",", "0.25", ",", "0.26", ",", "0.28", ",", 
           "0.29", ",", "0.3", ",", "0.32", ",", "0.34", ",", "0.35", ",", 
           "0.36", ",", "0.38", ",", "0.4", ",", "0.42", ",", "0.44", ",", 
           "0.45", ",", "0.46", ",", "0.48", ",", "0.5", ",", "0.55", ",", 
           "0.6", ",", "0.65", ",", "0.667", ",", "0.7", ",", "0.75", ",", 
           "0.8", ",", "0.85", ",", "0.9", ",", "0.95", ",", "1.0", ",", 
           "1.1", ",", "1.2", ",", "1.3", ",", "1.4", ",", "1.5", ",", "1.6", 
           ",", "1.7", ",", "1.8", ",", "1.9", ",", "2.0", ",", "2.2", ",", 
           "2.4", ",", "2.5", ",", "2.6", ",", "2.8", ",", "3.0", ",", "3.2", 
           ",", "3.4", ",", "3.5", ",", "3.6", ",", "3.8", ",", "4.0", ",", 
           "4.2", ",", "4.4", ",", "4.6", ",", "4.8", ",", "5.0", ",", "5.5", 
           ",", "6.0", ",", "6.5", ",", "7.0", ",", "7.5", ",", "8.0", ",", 
           "8.5", ",", "9.0", ",", "9.5", ",", "10.0"}], "}"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"vlinlist", "=", 
         RowBox[{"{", 
          RowBox[{
          "865.1", ",", "400.0", ",", "400.0", ",", "865.1", ",", "865.1", ",",
            "865.1", ",", "865.1", ",", "898.6", ",", "907.8", ",", "926.4", ",",
            "953.6", ",", "962.3", ",", "994.5", ",", "1008.9", ",", "1022.0",
            ",", "1028.0", ",", "1033.8", ",", "1044.3", ",", "1053.5", ",", 
           "1071.5", ",", "1082.8", ",", "1088.3", ",", "1089.1", ",", "1089",
            ",", "1085.7", ",", "1079.2", ",", "1070.1", ",", "1059.0", ",", 
           "1046.3", ",", "1032.5", ",", "1002.5", ",", "970.9", ",", "939.1",
            ",", "929.7", ",", "907.8", ",", "877.6", ",", "848.7", ",", 
           "821.2", ",", "795.3", ",", "771.0", ",", "748.2", ",", "706.8", ",",
            "670.6", ",", "654.3", ",", "639.0", ",", "611.4", ",", "598.9", ",",
            "587.1", ",", "565.9", ",", "547.1", ",", "538.6", ",", "530.6", ",",
            "516.0", ",", "503.0", ",", "491.5", ",", "481.2", ",", "476.5", ",",
            "472.1", ",", "463.9", ",", "456.6", ",", "441.6", ",", "430.3", ",",
            "421.7", ",", "419.3", ",", "415.2", ",", "410.5", ",", "407.0", ",",
            "404.6", ",", "402.9", ",", "401.8", ",", "400.0", ",", "400.0", ",",
            "400.0", ",", "400.0", ",", "400.0", ",", "400.0", ",", "400.0", ",",
            "400.0", ",", "400.0", ",", "400.0", ",", "400.0", ",", "400.0", ",",
            "400.0", ",", "400.0", ",", "400.0", ",", "400.0", ",", "400.0", ",",
            "400.0", ",", "400.0", ",", "400.0", ",", "400.0", ",", "400.0", ",",
            "400.0", ",", "400.0", ",", "400.0", ",", "400.0", ",", "400.0", ",",
            "400.0", ",", "400.0", ",", "400.0", ",", "400.0", ",", "400.0", ",",
            "400.0", ",", "400.0", ",", "400.0", ",", "400.0", ",", "400.0", ",",
            "400.0"}], "}"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"bsoillist", "=", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1.186"}], ",", 
           RowBox[{"-", "1.955"}], ",", "0.0", ",", 
           RowBox[{"-", "1.186"}], ",", 
           RowBox[{"-", "1.219"}], ",", 
           RowBox[{"-", "1.232"}], ",", 
           RowBox[{"-", "1.25"}], ",", 
           RowBox[{"-", "1.269"}], ",", 
           RowBox[{"-", "1.273"}], ",", 
           RowBox[{"-", "1.281"}], ",", 
           RowBox[{"-", "1.291"}], ",", 
           RowBox[{"-", "1.295"}], ",", 
           RowBox[{"-", "1.308"}], ",", 
           RowBox[{"-", "1.315"}], ",", 
           RowBox[{"-", "1.323"}], ",", 
           RowBox[{"-", "1.326"}], ",", 
           RowBox[{"-", "1.33"}], ",", 
           RowBox[{"-", "1.338"}], ",", 
           RowBox[{"-", "1.346"}], ",", 
           RowBox[{"-", "1.367"}], ",", 
           RowBox[{"-", "1.391"}], ",", 
           RowBox[{"-", "1.416"}], ",", 
           RowBox[{"-", "1.426"}], ",", 
           RowBox[{"-", "1.443"}], ",", 
           RowBox[{"-", "1.471"}], ",", 
           RowBox[{"-", "1.5"}], ",", 
           RowBox[{"-", "1.53"}], ",", 
           RowBox[{"-", "1.561"}], ",", 
           RowBox[{"-", "1.592"}], ",", 
           RowBox[{"-", "1.624"}], ",", 
           RowBox[{"-", "1.687"}], ",", 
           RowBox[{"-", "1.751"}], ",", 
           RowBox[{"-", "1.813"}], ",", 
           RowBox[{"-", "1.831"}], ",", 
           RowBox[{"-", "1.873"}], ",", 
           RowBox[{"-", "1.931"}], ",", 
           RowBox[{"-", "1.988"}], ",", 
           RowBox[{"-", "2.041"}], ",", 
           RowBox[{"-", "2.093"}], ",", 
           RowBox[{"-", "2.141"}], ",", 
           RowBox[{"-", "2.188"}], ",", 
           RowBox[{"-", "2.272"}], ",", 
           RowBox[{"-", "2.347"}], ",", 
           RowBox[{"-", "2.381"}], ",", 
           RowBox[{"-", "2.412"}], ",", 
           RowBox[{"-", "2.469"}], ",", 
           RowBox[{"-", "2.494"}], ",", 
           RowBox[{"-", "2.518"}], ",", 
           RowBox[{"-", "2.558"}], ",", 
           RowBox[{"-", "2.592"}], ",", 
           RowBox[{"-", "2.607"}], ",", 
           RowBox[{"-", "2.62"}], ",", 
           RowBox[{"-", "2.641"}], ",", 
           RowBox[{"-", "2.657"}], ",", 
           RowBox[{"-", "2.668"}], ",", 
           RowBox[{"-", "2.674"}], ",", 
           RowBox[{"-", "2.676"}], ",", 
           RowBox[{"-", "2.676"}], ",", 
           RowBox[{"-", "2.675"}], ",", 
           RowBox[{"-", "2.669"}], ",", 
           RowBox[{"-", "2.643"}], ",", 
           RowBox[{"-", "2.599"}], ",", 
           RowBox[{"-", "2.543"}], ",", 
           RowBox[{"-", "2.521"}], ",", 
           RowBox[{"-", "2.476"}], ",", 
           RowBox[{"-", "2.401"}], ",", 
           RowBox[{"-", "2.319"}], ",", 
           RowBox[{"-", "2.233"}], ",", 
           RowBox[{"-", "2.142"}], ",", 
           RowBox[{"-", "2.049"}], ",", 
           RowBox[{"-", "1.955"}], ",", 
           RowBox[{"-", "1.762"}], ",", 
           RowBox[{"-", "1.57"}], ",", 
           RowBox[{"-", "1.382"}], ",", 
           RowBox[{"-", "1.199"}], ",", 
           RowBox[{"-", "1.025"}], ",", 
           RowBox[{"-", "0.859"}], ",", 
           RowBox[{"-", "0.703"}], ",", 
           RowBox[{"-", "0.558"}], ",", 
           RowBox[{"-", "0.423"}], ",", 
           RowBox[{"-", "0.299"}], ",", 
           RowBox[{"-", "0.086"}], ",", "0.0", ",", "0.0", ",", "0.0", ",", 
           "0.0", ",", "0.0", ",", "0.0", ",", "0.0", ",", "0.0", ",", "0.0", 
           ",", "0.0", ",", "0.0", ",", "0.0", ",", "0.0", ",", "0.0", ",", 
           "0.0", ",", "0.0", ",", "0.0", ",", "0.0", ",", "0.0", ",", "0.0", 
           ",", "0.0", ",", "0.0", ",", "0.0", ",", "0.0", ",", "0.0", ",", 
           "0.0"}], "}"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"c4list", "=", 
         RowBox[{"{", 
          RowBox[{
          "4.5", ",", "4.5", ",", "4.5", ",", "4.5", ",", "4.5", ",", "4.5", ",",
            "4.5", ",", "4.5", ",", "4.5", ",", "4.5", ",", "4.5", ",", "4.5",
            ",", "4.5", ",", "4.5", ",", "4.5", ",", "4.5", ",", "4.5", ",", 
           "4.5", ",", "4.5", ",", "4.5", ",", "4.5", ",", "4.5", ",", "4.5", 
           ",", "4.5", ",", "4.5", ",", "4.5", ",", "4.5", ",", "4.5", ",", 
           "4.5", ",", "4.5", ",", "4.5", ",", "4.5", ",", "4.5", ",", "4.5", 
           ",", "4.5", ",", "4.5", ",", "4.5", ",", "4.5", ",", "4.5", ",", 
           "4.5", ",", "4.5", ",", "4.5", ",", "4.5", ",", "4.5", ",", "4.5", 
           ",", "4.5", ",", "4.5", ",", "4.5", ",", "4.5", ",", "4.5", ",", 
           "4.5", ",", "4.5", ",", "4.5", ",", "4.5", ",", "4.5", ",", "4.5", 
           ",", "4.5", ",", "4.5", ",", "4.5", ",", "4.5", ",", "4.5", ",", 
           "4.5", ",", "4.5", ",", "4.5", ",", "4.5", ",", "4.5", ",", "4.5", 
           ",", "4.5", ",", "4.5", ",", "4.5", ",", "4.5", ",", "4.5", ",", 
           "4.5", ",", "4.5", ",", "4.5", ",", "4.5", ",", "4.5", ",", "4.5", 
           ",", "4.5", ",", "4.5", ",", "4.5", ",", "4.5", ",", "4.5", ",", 
           "4.5", ",", "4.5", ",", "4.5", ",", "4.5", ",", "4.5", ",", "4.5", 
           ",", "4.5", ",", "4.5", ",", "4.5", ",", "4.5", ",", "4.5", ",", 
           "4.5", ",", "4.5", ",", "4.5", ",", "4.5", ",", "4.5", ",", "4.5", 
           ",", "4.5", ",", "4.5", ",", "4.5", ",", "4.5", ",", "4.5", ",", 
           "4.5", ",", "4.5", ",", "4.5"}], "}"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"a1list", "=", 
         RowBox[{"{", 
          RowBox[{
          "0.8039", ",", "5.7578", ",", "4.9995", ",", "0.8109", ",", 
           "0.8554", ",", "0.8785", ",", "0.9139", ",", "0.952", ",", 
           "0.9617", ",", "0.9747", ",", "0.9953", ",", "1.0031", ",", 
           "1.037", ",", "1.0556", ",", "1.0754", ",", "1.086", ",", "1.095", 
           ",", "1.1146", ",", "1.1331", ",", "1.185", ",", "1.2374", ",", 
           "1.2867", ",", "1.304", ",", "1.3296", ",", "1.3751", ",", 
           "1.4158", ",", "1.4538", ",", "1.4877", ",", "1.5278", ",", 
           "1.5628", ",", "1.6179", ",", "1.6603", ",", "1.6889", ",", 
           "1.6953", ",", "1.7051", ",", "1.7155", ",", "1.719", ",", 
           "1.7141", ",", "1.7064", ",", "1.6991", ",", "1.687", ",", 
           "1.6716", ",", "1.655", ",", "1.6463", ",", "1.6374", ",", 
           "1.6193", ",", "1.6101", ",", "1.6008", ",", "1.5845", ",", 
           "1.5605", ",", "1.5507", ",", "1.5443", ",", "1.5289", ",", 
           "1.5105", ",", "1.4921", ",", "1.4696", ",", "1.4572", ",", 
           "1.4449", ",", "1.4207", ",", "1.3972", ",", "1.3406", ",", 
           "1.2866", ",", "1.2349", ",", "1.2178", ",", "1.1851", ",", 
           "1.137", ",", "1.0903", ",", "1.0449", ",", "1.0006", ",", 
           "0.9574", ",", "0.9152", ",", "0.8276", ",", "0.7517", ",", 
           "0.6653", ",", "0.585", ",", "0.5099", ",", "0.4394", ",", 
           "0.3727", ",", "0.3094", ",", "0.2492", ",", "0.1917", ",", 
           "0.0837", ",", 
           RowBox[{"-", "0.0163"}], ",", 
           RowBox[{"-", "0.0637"}], ",", 
           RowBox[{"-", "0.1096"}], ",", 
           RowBox[{"-", "0.1973"}], ",", 
           RowBox[{"-", "0.2801"}], ",", 
           RowBox[{"-", "0.3586"}], ",", 
           RowBox[{"-", "0.4335"}], ",", 
           RowBox[{"-", "0.4696"}], ",", 
           RowBox[{"-", "0.505"}], ",", 
           RowBox[{"-", "0.5735"}], ",", 
           RowBox[{"-", "0.6394"}], ",", 
           RowBox[{"-", "0.7029"}], ",", 
           RowBox[{"-", "0.7641"}], ",", 
           RowBox[{"-", "0.8234"}], ",", 
           RowBox[{"-", "0.8808"}], ",", 
           RowBox[{"-", "0.9364"}], ",", 
           RowBox[{"-", "1.0689"}], ",", 
           RowBox[{"-", "1.1931"}], ",", 
           RowBox[{"-", "1.3102"}], ",", 
           RowBox[{"-", "1.4212"}], ",", 
           RowBox[{"-", "1.5268"}], ",", 
           RowBox[{"-", "1.6277"}], ",", 
           RowBox[{"-", "1.7243"}], ",", 
           RowBox[{"-", "1.8171"}], ",", 
           RowBox[{"-", "1.9065"}], ",", 
           RowBox[{"-", "1.9928"}]}], "}"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"a2list", "=", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.9679"}], ",", 
           RowBox[{"-", "0.9046"}], ",", 
           RowBox[{"-", "0.8739"}], ",", 
           RowBox[{"-", "0.9679"}], ",", 
           RowBox[{"-", "0.9774"}], ",", 
           RowBox[{"-", "0.9816"}], ",", 
           RowBox[{"-", "0.9889"}], ",", 
           RowBox[{"-", "0.9996"}], ",", 
           RowBox[{"-", "1.0024"}], ",", 
           RowBox[{"-", "1.0079"}], ",", 
           RowBox[{"-", "1.016"}], ",", 
           RowBox[{"-", "1.0187"}], ",", 
           RowBox[{"-", "1.0289"}], ",", 
           RowBox[{"-", "1.0337"}], ",", 
           RowBox[{"-", "1.0383"}], ",", 
           RowBox[{"-", "1.0406"}], ",", 
           RowBox[{"-", "1.0427"}], ",", 
           RowBox[{"-", "1.0469"}], ",", 
           RowBox[{"-", "1.0508"}], ",", 
           RowBox[{"-", "1.0596"}], ",", 
           RowBox[{"-", "1.0669"}], ",", 
           RowBox[{"-", "1.0728"}], ",", 
           RowBox[{"-", "1.0749"}], ",", 
           RowBox[{"-", "1.0775"}], ",", 
           RowBox[{"-", "1.081"}], ",", 
           RowBox[{"-", "1.0833"}], ",", 
           RowBox[{"-", "1.0847"}], ",", 
           RowBox[{"-", "1.0851"}], ",", 
           RowBox[{"-", "1.0847"}], ",", 
           RowBox[{"-", "1.0833"}], ",", 
           RowBox[{"-", "1.0781"}], ",", 
           RowBox[{"-", "1.0702"}], ",", 
           RowBox[{"-", "1.06"}], ",", 
           RowBox[{"-", "1.0567"}], ",", 
           RowBox[{"-", "1.0484"}], ",", 
           RowBox[{"-", "1.0357"}], ",", 
           RowBox[{"-", "1.0224"}], ",", 
           RowBox[{"-", "1.0089"}], ",", 
           RowBox[{"-", "0.9956"}], ",", 
           RowBox[{"-", "0.9825"}], ",", 
           RowBox[{"-", "0.97"}], ",", 
           RowBox[{"-", "0.9473"}], ",", 
           RowBox[{"-", "0.9282"}], ",", 
           RowBox[{"-", "0.9202"}], ",", 
           RowBox[{"-", "0.9133"}], ",", 
           RowBox[{"-", "0.903"}], ",", 
           RowBox[{"-", "0.8997"}], ",", 
           RowBox[{"-", "0.8974"}], ",", 
           RowBox[{"-", "0.8906"}], ",", 
           RowBox[{"-", "0.8842"}], ",", 
           RowBox[{"-", "0.8812"}], ",", 
           RowBox[{"-", "0.8783"}], ",", 
           RowBox[{"-", "0.8728"}], ",", 
           RowBox[{"-", "0.8677"}], ",", 
           RowBox[{"-", "0.863"}], ",", 
           RowBox[{"-", "0.8587"}], ",", 
           RowBox[{"-", "0.8566"}], ",", 
           RowBox[{"-", "0.8546"}], ",", 
           RowBox[{"-", "0.8509"}], ",", 
           RowBox[{"-", "0.8475"}], ",", 
           RowBox[{"-", "0.84"}], ",", 
           RowBox[{"-", "0.8338"}], ",", 
           RowBox[{"-", "0.8286"}], ",", 
           RowBox[{"-", "0.827"}], ",", 
           RowBox[{"-", "0.8242"}], ",", 
           RowBox[{"-", "0.8206"}], ",", 
           RowBox[{"-", "0.8175"}], ",", 
           RowBox[{"-", "0.8148"}], ",", 
           RowBox[{"-", "0.8125"}], ",", 
           RowBox[{"-", "0.8106"}], ",", 
           RowBox[{"-", "0.8088"}], ",", 
           RowBox[{"-", "0.806"}], ",", 
           RowBox[{"-", "0.8038"}], ",", 
           RowBox[{"-", "0.802"}], ",", 
           RowBox[{"-", "0.8006"}], ",", 
           RowBox[{"-", "0.7995"}], ",", 
           RowBox[{"-", "0.7985"}], ",", 
           RowBox[{"-", "0.7977"}], ",", 
           RowBox[{"-", "0.797"}], ",", 
           RowBox[{"-", "0.7965"}], ",", 
           RowBox[{"-", "0.796"}], ",", 
           RowBox[{"-", "0.796"}], ",", 
           RowBox[{"-", "0.796"}], ",", 
           RowBox[{"-", "0.796"}], ",", 
           RowBox[{"-", "0.796"}], ",", 
           RowBox[{"-", "0.796"}], ",", 
           RowBox[{"-", "0.796"}], ",", 
           RowBox[{"-", "0.796"}], ",", 
           RowBox[{"-", "0.796"}], ",", 
           RowBox[{"-", "0.796"}], ",", 
           RowBox[{"-", "0.796"}], ",", 
           RowBox[{"-", "0.796"}], ",", 
           RowBox[{"-", "0.796"}], ",", 
           RowBox[{"-", "0.796"}], ",", 
           RowBox[{"-", "0.796"}], ",", 
           RowBox[{"-", "0.796"}], ",", 
           RowBox[{"-", "0.796"}], ",", 
           RowBox[{"-", "0.796"}], ",", 
           RowBox[{"-", "0.796"}], ",", 
           RowBox[{"-", "0.796"}], ",", 
           RowBox[{"-", "0.796"}], ",", 
           RowBox[{"-", "0.796"}], ",", 
           RowBox[{"-", "0.796"}], ",", 
           RowBox[{"-", "0.796"}], ",", 
           RowBox[{"-", "0.796"}], ",", 
           RowBox[{"-", "0.796"}], ",", 
           RowBox[{"-", "0.796"}], ",", 
           RowBox[{"-", "0.796"}]}], "}"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"a3list", "=", 
         RowBox[{"{", 
          RowBox[{
          "0.265", ",", "0.265", ",", "0.265", ",", "0.265", ",", "0.265", ",",
            "0.265", ",", "0.265", ",", "0.265", ",", "0.265", ",", "0.265", ",",
            "0.265", ",", "0.265", ",", "0.265", ",", "0.265", ",", "0.265", ",",
            "0.265", ",", "0.265", ",", "0.265", ",", "0.265", ",", "0.265", ",",
            "0.265", ",", "0.265", ",", "0.265", ",", "0.265", ",", "0.265", ",",
            "0.265", ",", "0.265", ",", "0.265", ",", "0.265", ",", "0.265", ",",
            "0.265", ",", "0.265", ",", "0.265", ",", "0.265", ",", "0.265", ",",
            "0.265", ",", "0.265", ",", "0.265", ",", "0.265", ",", "0.265", ",",
            "0.265", ",", "0.265", ",", "0.265", ",", "0.265", ",", "0.265", ",",
            "0.265", ",", "0.265", ",", "0.265", ",", "0.265", ",", "0.265", ",",
            "0.265", ",", "0.265", ",", "0.265", ",", "0.265", ",", "0.265", ",",
            "0.265", ",", "0.265", ",", "0.265", ",", "0.265", ",", "0.265", ",",
            "0.265", ",", "0.265", ",", "0.265", ",", "0.265", ",", "0.265", ",",
            "0.265", ",", "0.265", ",", "0.265", ",", "0.265", ",", "0.265", ",",
            "0.265", ",", "0.265", ",", "0.265", ",", "0.265", ",", "0.265", ",",
            "0.265", ",", "0.265", ",", "0.265", ",", "0.265", ",", "0.265", ",",
            "0.265", ",", "0.265", ",", "0.265", ",", "0.265", ",", "0.265", ",",
            "0.265", ",", "0.265", ",", "0.265", ",", "0.265", ",", "0.265", ",",
            "0.265", ",", "0.265", ",", "0.265", ",", "0.265", ",", "0.265", ",",
            "0.265", ",", "0.265", ",", "0.265", ",", "0.265", ",", "0.265", ",",
            "0.265", ",", "0.265", ",", "0.265", ",", "0.265", ",", "0.265", ",",
            "0.265", ",", "0.265", ",", "0.265"}], "}"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"a4list", "=", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.231"}], ",", 
           RowBox[{"-", "0.231"}], ",", 
           RowBox[{"-", "0.231"}], ",", 
           RowBox[{"-", "0.231"}], ",", 
           RowBox[{"-", "0.231"}], ",", 
           RowBox[{"-", "0.231"}], ",", 
           RowBox[{"-", "0.231"}], ",", 
           RowBox[{"-", "0.231"}], ",", 
           RowBox[{"-", "0.231"}], ",", 
           RowBox[{"-", "0.231"}], ",", 
           RowBox[{"-", "0.231"}], ",", 
           RowBox[{"-", "0.231"}], ",", 
           RowBox[{"-", "0.231"}], ",", 
           RowBox[{"-", "0.231"}], ",", 
           RowBox[{"-", "0.231"}], ",", 
           RowBox[{"-", "0.231"}], ",", 
           RowBox[{"-", "0.231"}], ",", 
           RowBox[{"-", "0.231"}], ",", 
           RowBox[{"-", "0.231"}], ",", 
           RowBox[{"-", "0.231"}], ",", 
           RowBox[{"-", "0.231"}], ",", 
           RowBox[{"-", "0.231"}], ",", 
           RowBox[{"-", "0.231"}], ",", 
           RowBox[{"-", "0.231"}], ",", 
           RowBox[{"-", "0.231"}], ",", 
           RowBox[{"-", "0.231"}], ",", 
           RowBox[{"-", "0.231"}], ",", 
           RowBox[{"-", "0.231"}], ",", 
           RowBox[{"-", "0.231"}], ",", 
           RowBox[{"-", "0.231"}], ",", 
           RowBox[{"-", "0.231"}], ",", 
           RowBox[{"-", "0.231"}], ",", 
           RowBox[{"-", "0.231"}], ",", 
           RowBox[{"-", "0.231"}], ",", 
           RowBox[{"-", "0.231"}], ",", 
           RowBox[{"-", "0.231"}], ",", 
           RowBox[{"-", "0.231"}], ",", 
           RowBox[{"-", "0.231"}], ",", 
           RowBox[{"-", "0.231"}], ",", 
           RowBox[{"-", "0.231"}], ",", 
           RowBox[{"-", "0.231"}], ",", 
           RowBox[{"-", "0.231"}], ",", 
           RowBox[{"-", "0.231"}], ",", 
           RowBox[{"-", "0.231"}], ",", 
           RowBox[{"-", "0.231"}], ",", 
           RowBox[{"-", "0.231"}], ",", 
           RowBox[{"-", "0.231"}], ",", 
           RowBox[{"-", "0.231"}], ",", 
           RowBox[{"-", "0.231"}], ",", 
           RowBox[{"-", "0.231"}], ",", 
           RowBox[{"-", "0.231"}], ",", 
           RowBox[{"-", "0.231"}], ",", 
           RowBox[{"-", "0.231"}], ",", 
           RowBox[{"-", "0.231"}], ",", 
           RowBox[{"-", "0.231"}], ",", 
           RowBox[{"-", "0.231"}], ",", 
           RowBox[{"-", "0.231"}], ",", 
           RowBox[{"-", "0.231"}], ",", 
           RowBox[{"-", "0.231"}], ",", 
           RowBox[{"-", "0.231"}], ",", 
           RowBox[{"-", "0.231"}], ",", 
           RowBox[{"-", "0.231"}], ",", 
           RowBox[{"-", "0.231"}], ",", 
           RowBox[{"-", "0.231"}], ",", 
           RowBox[{"-", "0.231"}], ",", 
           RowBox[{"-", "0.231"}], ",", 
           RowBox[{"-", "0.231"}], ",", 
           RowBox[{"-", "0.231"}], ",", 
           RowBox[{"-", "0.231"}], ",", 
           RowBox[{"-", "0.231"}], ",", 
           RowBox[{"-", "0.231"}], ",", 
           RowBox[{"-", "0.231"}], ",", 
           RowBox[{"-", "0.231"}], ",", 
           RowBox[{"-", "0.231"}], ",", 
           RowBox[{"-", "0.231"}], ",", 
           RowBox[{"-", "0.231"}], ",", 
           RowBox[{"-", "0.231"}], ",", 
           RowBox[{"-", "0.231"}], ",", 
           RowBox[{"-", "0.231"}], ",", 
           RowBox[{"-", "0.231"}], ",", 
           RowBox[{"-", "0.231"}], ",", 
           RowBox[{"-", "0.231"}], ",", 
           RowBox[{"-", "0.231"}], ",", 
           RowBox[{"-", "0.231"}], ",", 
           RowBox[{"-", "0.231"}], ",", 
           RowBox[{"-", "0.231"}], ",", 
           RowBox[{"-", "0.231"}], ",", 
           RowBox[{"-", "0.231"}], ",", 
           RowBox[{"-", "0.231"}], ",", 
           RowBox[{"-", "0.231"}], ",", 
           RowBox[{"-", "0.231"}], ",", 
           RowBox[{"-", "0.231"}], ",", 
           RowBox[{"-", "0.231"}], ",", 
           RowBox[{"-", "0.231"}], ",", 
           RowBox[{"-", "0.231"}], ",", 
           RowBox[{"-", "0.231"}], ",", 
           RowBox[{"-", "0.231"}], ",", 
           RowBox[{"-", "0.231"}], ",", 
           RowBox[{"-", "0.231"}], ",", 
           RowBox[{"-", "0.231"}], ",", 
           RowBox[{"-", "0.231"}], ",", 
           RowBox[{"-", "0.231"}], ",", 
           RowBox[{"-", "0.231"}], ",", 
           RowBox[{"-", "0.231"}], ",", 
           RowBox[{"-", "0.231"}], ",", 
           RowBox[{"-", "0.231"}], ",", 
           RowBox[{"-", "0.231"}], ",", 
           RowBox[{"-", "0.231"}]}], "}"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"a5list", "=", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.398"}], ",", 
           RowBox[{"-", "0.398"}], ",", 
           RowBox[{"-", "0.398"}], ",", 
           RowBox[{"-", "0.398"}], ",", 
           RowBox[{"-", "0.398"}], ",", 
           RowBox[{"-", "0.398"}], ",", 
           RowBox[{"-", "0.398"}], ",", 
           RowBox[{"-", "0.398"}], ",", 
           RowBox[{"-", "0.398"}], ",", 
           RowBox[{"-", "0.398"}], ",", 
           RowBox[{"-", "0.398"}], ",", 
           RowBox[{"-", "0.398"}], ",", 
           RowBox[{"-", "0.398"}], ",", 
           RowBox[{"-", "0.398"}], ",", 
           RowBox[{"-", "0.398"}], ",", 
           RowBox[{"-", "0.398"}], ",", 
           RowBox[{"-", "0.398"}], ",", 
           RowBox[{"-", "0.398"}], ",", 
           RowBox[{"-", "0.398"}], ",", 
           RowBox[{"-", "0.398"}], ",", 
           RowBox[{"-", "0.398"}], ",", 
           RowBox[{"-", "0.398"}], ",", 
           RowBox[{"-", "0.398"}], ",", 
           RowBox[{"-", "0.398"}], ",", 
           RowBox[{"-", "0.398"}], ",", 
           RowBox[{"-", "0.398"}], ",", 
           RowBox[{"-", "0.398"}], ",", 
           RowBox[{"-", "0.398"}], ",", 
           RowBox[{"-", "0.398"}], ",", 
           RowBox[{"-", "0.398"}], ",", 
           RowBox[{"-", "0.398"}], ",", 
           RowBox[{"-", "0.398"}], ",", 
           RowBox[{"-", "0.398"}], ",", 
           RowBox[{"-", "0.398"}], ",", 
           RowBox[{"-", "0.398"}], ",", 
           RowBox[{"-", "0.398"}], ",", 
           RowBox[{"-", "0.398"}], ",", 
           RowBox[{"-", "0.398"}], ",", 
           RowBox[{"-", "0.398"}], ",", 
           RowBox[{"-", "0.398"}], ",", 
           RowBox[{"-", "0.398"}], ",", 
           RowBox[{"-", "0.398"}], ",", 
           RowBox[{"-", "0.398"}], ",", 
           RowBox[{"-", "0.398"}], ",", 
           RowBox[{"-", "0.398"}], ",", 
           RowBox[{"-", "0.398"}], ",", 
           RowBox[{"-", "0.398"}], ",", 
           RowBox[{"-", "0.398"}], ",", 
           RowBox[{"-", "0.398"}], ",", 
           RowBox[{"-", "0.398"}], ",", 
           RowBox[{"-", "0.398"}], ",", 
           RowBox[{"-", "0.398"}], ",", 
           RowBox[{"-", "0.398"}], ",", 
           RowBox[{"-", "0.398"}], ",", 
           RowBox[{"-", "0.398"}], ",", 
           RowBox[{"-", "0.398"}], ",", 
           RowBox[{"-", "0.398"}], ",", 
           RowBox[{"-", "0.398"}], ",", 
           RowBox[{"-", "0.398"}], ",", 
           RowBox[{"-", "0.398"}], ",", 
           RowBox[{"-", "0.398"}], ",", 
           RowBox[{"-", "0.398"}], ",", 
           RowBox[{"-", "0.398"}], ",", 
           RowBox[{"-", "0.398"}], ",", 
           RowBox[{"-", "0.398"}], ",", 
           RowBox[{"-", "0.398"}], ",", 
           RowBox[{"-", "0.398"}], ",", 
           RowBox[{"-", "0.398"}], ",", 
           RowBox[{"-", "0.398"}], ",", 
           RowBox[{"-", "0.398"}], ",", 
           RowBox[{"-", "0.398"}], ",", 
           RowBox[{"-", "0.398"}], ",", 
           RowBox[{"-", "0.398"}], ",", 
           RowBox[{"-", "0.398"}], ",", 
           RowBox[{"-", "0.398"}], ",", 
           RowBox[{"-", "0.398"}], ",", 
           RowBox[{"-", "0.398"}], ",", 
           RowBox[{"-", "0.398"}], ",", 
           RowBox[{"-", "0.398"}], ",", 
           RowBox[{"-", "0.398"}], ",", 
           RowBox[{"-", "0.398"}], ",", 
           RowBox[{"-", "0.398"}], ",", 
           RowBox[{"-", "0.398"}], ",", 
           RowBox[{"-", "0.398"}], ",", 
           RowBox[{"-", "0.398"}], ",", 
           RowBox[{"-", "0.398"}], ",", 
           RowBox[{"-", "0.398"}], ",", 
           RowBox[{"-", "0.398"}], ",", 
           RowBox[{"-", "0.398"}], ",", 
           RowBox[{"-", "0.398"}], ",", 
           RowBox[{"-", "0.398"}], ",", 
           RowBox[{"-", "0.398"}], ",", 
           RowBox[{"-", "0.398"}], ",", 
           RowBox[{"-", "0.398"}], ",", 
           RowBox[{"-", "0.398"}], ",", 
           RowBox[{"-", "0.398"}], ",", 
           RowBox[{"-", "0.398"}], ",", 
           RowBox[{"-", "0.398"}], ",", 
           RowBox[{"-", "0.398"}], ",", 
           RowBox[{"-", "0.398"}], ",", 
           RowBox[{"-", "0.398"}], ",", 
           RowBox[{"-", "0.398"}], ",", 
           RowBox[{"-", "0.398"}], ",", 
           RowBox[{"-", "0.398"}], ",", 
           RowBox[{"-", "0.398"}], ",", 
           RowBox[{"-", "0.398"}], ",", 
           RowBox[{"-", "0.398"}], ",", 
           RowBox[{"-", "0.398"}]}], "}"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"a6list", "=", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1.45"}], ",", 
           RowBox[{"-", "1.46"}], ",", 
           RowBox[{"-", "1.53"}], ",", 
           RowBox[{"-", "1.45"}], ",", 
           RowBox[{"-", "1.45"}], ",", 
           RowBox[{"-", "1.45"}], ",", 
           RowBox[{"-", "1.45"}], ",", 
           RowBox[{"-", "1.45"}], ",", 
           RowBox[{"-", "1.45"}], ",", 
           RowBox[{"-", "1.45"}], ",", 
           RowBox[{"-", "1.45"}], ",", 
           RowBox[{"-", "1.45"}], ",", 
           RowBox[{"-", "1.45"}], ",", 
           RowBox[{"-", "1.45"}], ",", 
           RowBox[{"-", "1.45"}], ",", 
           RowBox[{"-", "1.45"}], ",", 
           RowBox[{"-", "1.45"}], ",", 
           RowBox[{"-", "1.45"}], ",", 
           RowBox[{"-", "1.45"}], ",", 
           RowBox[{"-", "1.45"}], ",", 
           RowBox[{"-", "1.45"}], ",", 
           RowBox[{"-", "1.45"}], ",", 
           RowBox[{"-", "1.45"}], ",", 
           RowBox[{"-", "1.45"}], ",", 
           RowBox[{"-", "1.45"}], ",", 
           RowBox[{"-", "1.45"}], ",", 
           RowBox[{"-", "1.45"}], ",", 
           RowBox[{"-", "1.45"}], ",", 
           RowBox[{"-", "1.45"}], ",", 
           RowBox[{"-", "1.45"}], ",", 
           RowBox[{"-", "1.45"}], ",", 
           RowBox[{"-", "1.45"}], ",", 
           RowBox[{"-", "1.45"}], ",", 
           RowBox[{"-", "1.45"}], ",", 
           RowBox[{"-", "1.45"}], ",", 
           RowBox[{"-", "1.45"}], ",", 
           RowBox[{"-", "1.45"}], ",", 
           RowBox[{"-", "1.45"}], ",", 
           RowBox[{"-", "1.45"}], ",", 
           RowBox[{"-", "1.45"}], ",", 
           RowBox[{"-", "1.45"}], ",", 
           RowBox[{"-", "1.4366"}], ",", 
           RowBox[{"-", "1.4244"}], ",", 
           RowBox[{"-", "1.4186"}], ",", 
           RowBox[{"-", "1.4131"}], ",", 
           RowBox[{"-", "1.4027"}], ",", 
           RowBox[{"-", "1.3978"}], ",", 
           RowBox[{"-", "1.393"}], ",", 
           RowBox[{"-", "1.3839"}], ",", 
           RowBox[{"-", "1.3754"}], ",", 
           RowBox[{"-", "1.3713"}], ",", 
           RowBox[{"-", "1.3674"}], ",", 
           RowBox[{"-", "1.3598"}], ",", 
           RowBox[{"-", "1.3525"}], ",", 
           RowBox[{"-", "1.3457"}], ",", 
           RowBox[{"-", "1.3391"}], ",", 
           RowBox[{"-", "1.336"}], ",", 
           RowBox[{"-", "1.3329"}], ",", 
           RowBox[{"-", "1.3269"}], ",", 
           RowBox[{"-", "1.3212"}], ",", 
           RowBox[{"-", "1.3078"}], ",", 
           RowBox[{"-", "1.2955"}], ",", 
           RowBox[{"-", "1.2843"}], ",", 
           RowBox[{"-", "1.2807"}], ",", 
           RowBox[{"-", "1.2739"}], ",", 
           RowBox[{"-", "1.2642"}], ",", 
           RowBox[{"-", "1.2551"}], ",", 
           RowBox[{"-", "1.2466"}], ",", 
           RowBox[{"-", "1.2385"}], ",", 
           RowBox[{"-", "1.2309"}], ",", 
           RowBox[{"-", "1.2237"}], ",", 
           RowBox[{"-", "1.2103"}], ",", 
           RowBox[{"-", "1.1981"}], ",", 
           RowBox[{"-", "1.1868"}], ",", 
           RowBox[{"-", "1.1764"}], ",", 
           RowBox[{"-", "1.1667"}], ",", 
           RowBox[{"-", "1.1576"}], ",", 
           RowBox[{"-", "1.1491"}], ",", 
           RowBox[{"-", "1.1411"}], ",", 
           RowBox[{"-", "1.1335"}], ",", 
           RowBox[{"-", "1.1263"}], ",", 
           RowBox[{"-", "1.1129"}], ",", 
           RowBox[{"-", "1.1006"}], ",", 
           RowBox[{"-", "1.0949"}], ",", 
           RowBox[{"-", "1.0894"}], ",", 
           RowBox[{"-", "1.079"}], ",", 
           RowBox[{"-", "1.0693"}], ",", 
           RowBox[{"-", "1.0602"}], ",", 
           RowBox[{"-", "1.0517"}], ",", 
           RowBox[{"-", "1.0476"}], ",", 
           RowBox[{"-", "1.0436"}], ",", 
           RowBox[{"-", "1.036"}], ",", 
           RowBox[{"-", "1.0288"}], ",", 
           RowBox[{"-", "1.022"}], ",", 
           RowBox[{"-", "1.0154"}], ",", 
           RowBox[{"-", "1.0092"}], ",", 
           RowBox[{"-", "1.0032"}], ",", 
           RowBox[{"-", "0.9975"}], ",", 
           RowBox[{"-", "0.9841"}], ",", 
           RowBox[{"-", "0.9718"}], ",", 
           RowBox[{"-", "0.9606"}], ",", 
           RowBox[{"-", "0.9501"}], ",", 
           RowBox[{"-", "0.9404"}], ",", 
           RowBox[{"-", "0.9314"}], ",", 
           RowBox[{"-", "0.9228"}], ",", 
           RowBox[{"-", "0.9148"}], ",", 
           RowBox[{"-", "0.9072"}], ",", 
           RowBox[{"-", "0.9"}]}], "}"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"a7list", "=", 
         RowBox[{"{", 
          RowBox[{
          "0.8", ",", "0.96", ",", "0.8", ",", "0.8", ",", "0.8", ",", 
           "0.7927", ",", "0.7829", ",", "0.7715", ",", "0.7689", ",", 
           "0.764", ",", "0.7571", ",", "0.7549", ",", "0.7468", ",", 
           "0.7431", ",", "0.7395", ",", "0.7378", ",", "0.7361", ",", 
           "0.7329", ",", "0.7297", ",", "0.7224", ",", "0.7158", ",", 
           "0.7096", ",", "0.7073", ",", "0.7039", ",", "0.6986", ",", 
           "0.6937", ",", "0.689", ",", "0.6847", ",", "0.6805", ",", 
           "0.6766", ",", "0.6693", ",", "0.6626", ",", "0.6565", ",", 
           "0.6547", ",", "0.6508", ",", "0.6455", ",", "0.6405", ",", 
           "0.6359", ",", "0.6315", ",", "0.6274", ",", "0.6234", ",", 
           "0.6161", ",", "0.6094", ",", "0.6063", ",", "0.6033", ",", 
           "0.5976", ",", "0.5949", ",", "0.5923", ",", "0.5874", ",", 
           "0.5827", ",", "0.5805", ",", "0.5783", ",", "0.5742", ",", 
           "0.5703", ",", "0.5665", ",", "0.563", ",", "0.5612", ",", 
           "0.5595", ",", "0.5563", ",", "0.5532", ",", "0.5458", ",", 
           "0.5392", ",", "0.533", ",", "0.5311", ",", "0.5274", ",", 
           "0.5221", ",", "0.5171", ",", "0.5125", ",", "0.5081", ",", 
           "0.5039", ",", "0.5", ",", "0.5", ",", "0.5", ",", "0.5", ",", 
           "0.5", ",", "0.5", ",", "0.5", ",", "0.5", ",", "0.5", ",", "0.5", 
           ",", "0.5", ",", "0.5", ",", "0.5", ",", "0.5", ",", "0.5", ",", 
           "0.5", ",", "0.5", ",", "0.5", ",", "0.5", ",", "0.5", ",", "0.5", 
           ",", "0.5", ",", "0.5", ",", "0.5", ",", "0.5", ",", "0.5", ",", 
           "0.5", ",", "0.5", ",", "0.5", ",", "0.5", ",", "0.5", ",", "0.5", 
           ",", "0.5", ",", "0.5", ",", "0.5", ",", "0.5", ",", "0.5", ",", 
           "0.5"}], "}"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"a8list", "=", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.0372"}], ",", 
           RowBox[{"-", "0.12"}], ",", 
           RowBox[{"-", "0.25"}], ",", 
           RowBox[{"-", "0.0372"}], ",", 
           RowBox[{"-", "0.0372"}], ",", 
           RowBox[{"-", "0.0372"}], ",", 
           RowBox[{"-", "0.0372"}], ",", 
           RowBox[{"-", "0.0372"}], ",", 
           RowBox[{"-", "0.0372"}], ",", 
           RowBox[{"-", "0.0359"}], ",", 
           RowBox[{"-", "0.0341"}], ",", 
           RowBox[{"-", "0.0336"}], ",", 
           RowBox[{"-", "0.0315"}], ",", 
           RowBox[{"-", "0.0305"}], ",", 
           RowBox[{"-", "0.0296"}], ",", 
           RowBox[{"-", "0.0292"}], ",", 
           RowBox[{"-", "0.0287"}], ",", 
           RowBox[{"-", "0.0279"}], ",", 
           RowBox[{"-", "0.0271"}], ",", 
           RowBox[{"-", "0.0252"}], ",", 
           RowBox[{"-", "0.0235"}], ",", 
           RowBox[{"-", "0.0219"}], ",", 
           RowBox[{"-", "0.0213"}], ",", 
           RowBox[{"-", "0.0204"}], ",", 
           RowBox[{"-", "0.0191"}], ",", 
           RowBox[{"-", "0.0178"}], ",", 
           RowBox[{"-", "0.0166"}], ",", 
           RowBox[{"-", "0.0155"}], ",", 
           RowBox[{"-", "0.0161"}], ",", 
           RowBox[{"-", "0.0166"}], ",", 
           RowBox[{"-", "0.0177"}], ",", 
           RowBox[{"-", "0.0187"}], ",", 
           RowBox[{"-", "0.0196"}], ",", 
           RowBox[{"-", "0.0205"}], ",", 
           RowBox[{"-", "0.0226"}], ",", 
           RowBox[{"-", "0.0254"}], ",", 
           RowBox[{"-", "0.0281"}], ",", 
           RowBox[{"-", "0.0305"}], ",", 
           RowBox[{"-", "0.0329"}], ",", 
           RowBox[{"-", "0.0363"}], ",", 
           RowBox[{"-", "0.0396"}], ",", 
           RowBox[{"-", "0.0457"}], ",", 
           RowBox[{"-", "0.0513"}], ",", 
           RowBox[{"-", "0.0539"}], ",", 
           RowBox[{"-", "0.0564"}], ",", 
           RowBox[{"-", "0.0612"}], ",", 
           RowBox[{"-", "0.0634"}], ",", 
           RowBox[{"-", "0.0656"}], ",", 
           RowBox[{"-", "0.069"}], ",", 
           RowBox[{"-", "0.0722"}], ",", 
           RowBox[{"-", "0.0737"}], ",", 
           RowBox[{"-", "0.0752"}], ",", 
           RowBox[{"-", "0.078"}], ",", 
           RowBox[{"-", "0.0807"}], ",", 
           RowBox[{"-", "0.0833"}], ",", 
           RowBox[{"-", "0.0857"}], ",", 
           RowBox[{"-", "0.0869"}], ",", 
           RowBox[{"-", "0.0881"}], ",", 
           RowBox[{"-", "0.0903"}], ",", 
           RowBox[{"-", "0.0924"}], ",", 
           RowBox[{"-", "0.0975"}], ",", 
           RowBox[{"-", "0.102"}], ",", 
           RowBox[{"-", "0.1062"}], ",", 
           RowBox[{"-", "0.1076"}], ",", 
           RowBox[{"-", "0.1101"}], ",", 
           RowBox[{"-", "0.1137"}], ",", 
           RowBox[{"-", "0.1171"}], ",", 
           RowBox[{"-", "0.1203"}], ",", 
           RowBox[{"-", "0.1233"}], ",", 
           RowBox[{"-", "0.1262"}], ",", 
           RowBox[{"-", "0.1289"}], ",", 
           RowBox[{"-", "0.1346"}], ",", 
           RowBox[{"-", "0.1399"}], ",", 
           RowBox[{"-", "0.1447"}], ",", 
           RowBox[{"-", "0.1492"}], ",", 
           RowBox[{"-", "0.1534"}], ",", 
           RowBox[{"-", "0.1573"}], ",", 
           RowBox[{"-", "0.161"}], ",", 
           RowBox[{"-", "0.1645"}], ",", 
           RowBox[{"-", "0.1677"}], ",", 
           RowBox[{"-", "0.1708"}], ",", 
           RowBox[{"-", "0.1766"}], ",", 
           RowBox[{"-", "0.1819"}], ",", 
           RowBox[{"-", "0.1844"}], ",", 
           RowBox[{"-", "0.1867"}], ",", 
           RowBox[{"-", "0.1912"}], ",", 
           RowBox[{"-", "0.1954"}], ",", 
           RowBox[{"-", "0.1993"}], ",", 
           RowBox[{"-", "0.203"}], ",", 
           RowBox[{"-", "0.2047"}], ",", 
           RowBox[{"-", "0.2064"}], ",", 
           RowBox[{"-", "0.2097"}], ",", 
           RowBox[{"-", "0.2128"}], ",", 
           RowBox[{"-", "0.2158"}], ",", 
           RowBox[{"-", "0.2186"}], ",", 
           RowBox[{"-", "0.2213"}], ",", 
           RowBox[{"-", "0.2239"}], ",", 
           RowBox[{"-", "0.2263"}], ",", 
           RowBox[{"-", "0.2321"}], ",", 
           RowBox[{"-", "0.2374"}], ",", 
           RowBox[{"-", "0.2422"}], ",", 
           RowBox[{"-", "0.2467"}], ",", 
           RowBox[{"-", "0.2509"}], ",", 
           RowBox[{"-", "0.2548"}], ",", 
           RowBox[{"-", "0.2585"}], ",", 
           RowBox[{"-", "0.2619"}], ",", 
           RowBox[{"-", "0.2652"}], ",", 
           RowBox[{"-", "0.2683"}]}], "}"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"a9list", "=", 
         RowBox[{"{", 
          RowBox[{
          "0.0", ",", "0.0", ",", "0.0", ",", "0.0", ",", "0.0", ",", "0.0", ",",
            "0.0", ",", "0.0", ",", "0.0", ",", "0.0", ",", "0.0", ",", "0.0",
            ",", "0.0", ",", "0.0", ",", "0.0", ",", "0.0", ",", "0.0", ",", 
           "0.0", ",", "0.0", ",", "0.0", ",", "0.0", ",", "0.0", ",", "0.0", 
           ",", "0.0", ",", "0.0", ",", "0.0", ",", "0.0", ",", "0.0", ",", 
           "0.0", ",", "0.0", ",", "0.0", ",", "0.0", ",", "0.0", ",", "0.0", 
           ",", "0.0", ",", "0.0", ",", "0.0", ",", "0.0", ",", "0.0", ",", 
           "0.0", ",", "0.0", ",", "0.0", ",", "0.0", ",", "0.0", ",", "0.0", 
           ",", "0.0", ",", "0.0", ",", "0.0", ",", "0.0", ",", "0.0", ",", 
           "0.0", ",", "0.0", ",", "0.0", ",", "0.0", ",", "0.0", ",", "0.0", 
           ",", "0.0", ",", "0.0", ",", "0.0", ",", "0.0", ",", "0.0", ",", 
           "0.0", ",", "0.0", ",", "0.0", ",", "0.0", ",", "0.0", ",", "0.0", 
           ",", "0.0", ",", "0.0", ",", "0.0", ",", "0.0", ",", "0.0", ",", 
           "0.0", ",", "0.0", ",", "0.0", ",", "0.0", ",", "0.0", ",", "0.0", 
           ",", "0.0", ",", "0.0", ",", "0.0", ",", "0.0", ",", "0.0", ",", 
           "0.0", ",", "0.0", ",", "0.0", ",", "0.0", ",", "0.0", ",", "0.0", 
           ",", "0.0", ",", "0.0", ",", "0.0", ",", "0.0", ",", "0.0", ",", 
           "0.0", ",", "0.0", ",", "0.0", ",", "0.0", ",", "0.0", ",", "0.0", 
           ",", "0.0", ",", "0.0", ",", "0.0", ",", "0.0", ",", "0.0", ",", 
           "0.0", ",", "0.0", ",", "0.0"}], "}"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"a10list", "=", 
         RowBox[{"{", 
          RowBox[{"0.9445", ",", "1.539", ",", 
           RowBox[{"-", "1.006"}], ",", "0.9445", ",", "0.9834", ",", 
           "0.9988", ",", "1.02", ",", "1.0424", ",", "1.0471", ",", "1.0566",
            ",", "1.0684", ",", "1.0731", ",", "1.0884", ",", "1.0967", ",", 
           "1.1061", ",", "1.1097", ",", "1.1144", ",", "1.1238", ",", 
           "1.1333", ",", "1.1581", ",", "1.1864", ",", "1.2159", ",", 
           "1.2277", ",", "1.2477", ",", "1.2808", ",", "1.315", ",", 
           "1.3504", ",", "1.387", ",", "1.4236", ",", "1.4613", ",", 
           "1.5357", ",", "1.6112", ",", "1.6843", ",", "1.703", ",", 
           "1.7466", ",", "1.8071", ",", "1.867", ",", "1.9225", ",", 
           "1.9773", ",", "2.0277", ",", "2.0773", ",", "2.1655", ",", 
           "2.244", ",", "2.2794", ",", "2.3114", ",", "2.3702", ",", 
           "2.3956", ",", "2.4201", ",", "2.4598", ",", "2.493", ",", 
           "2.5074", ",", "2.5195", ",", "2.538", ",", "2.551", ",", "2.5584",
            ",", "2.5601", ",", "2.5599", ",", "2.5574", ",", "2.5513", ",", 
           "2.5395", ",", "2.4914", ",", "2.4236", ",", "2.3429", ",", 
           "2.3123", ",", "2.2504", ",", "2.1493", ",", "2.0407", ",", 
           "1.9282", ",", "1.8104", ",", "1.6908", ",", "1.5705", ",", 
           "1.3254", ",", "1.0829", ",", "0.8465", ",", "0.617", ",", 
           "0.3991", ",", "0.1914", ",", 
           RowBox[{"-", "0.0037"}], ",", 
           RowBox[{"-", "0.1852"}], ",", 
           RowBox[{"-", "0.3544"}], ",", 
           RowBox[{"-", "0.6072"}], ",", 
           RowBox[{"-", "0.8585"}], ",", 
           RowBox[{"-", "0.96"}], ",", 
           RowBox[{"-", "0.96"}], ",", 
           RowBox[{"-", "0.96"}], ",", 
           RowBox[{"-", "0.96"}], ",", 
           RowBox[{"-", "0.96"}], ",", 
           RowBox[{"-", "0.96"}], ",", 
           RowBox[{"-", "0.96"}], ",", 
           RowBox[{"-", "0.96"}], ",", 
           RowBox[{"-", "0.96"}], ",", 
           RowBox[{"-", "0.96"}], ",", 
           RowBox[{"-", "0.96"}], ",", 
           RowBox[{"-", "0.96"}], ",", 
           RowBox[{"-", "0.96"}], ",", 
           RowBox[{"-", "0.9518"}], ",", 
           RowBox[{"-", "0.936"}], ",", 
           RowBox[{"-", "0.9208"}], ",", 
           RowBox[{"-", "0.8854"}], ",", 
           RowBox[{"-", "0.853"}], ",", 
           RowBox[{"-", "0.8232"}], ",", 
           RowBox[{"-", "0.7956"}], ",", 
           RowBox[{"-", "0.77"}], ",", 
           RowBox[{"-", "0.746"}], ",", 
           RowBox[{"-", "0.7234"}], ",", 
           RowBox[{"-", "0.7021"}], ",", 
           RowBox[{"-", "0.682"}], ",", 
           RowBox[{"-", "0.663"}]}], "}"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"a11list", "=", 
         RowBox[{"{", 
          RowBox[{
          "0.0", ",", "0.0", ",", "0.0", ",", "0.0", ",", "0.0", ",", "0.0", ",",
            "0.0", ",", "0.0", ",", "0.0", ",", "0.0", ",", "0.0", ",", "0.0",
            ",", "0.0", ",", "0.0", ",", "0.0", ",", "0.0", ",", "0.0", ",", 
           "0.0", ",", "0.0", ",", "0.0", ",", "0.0", ",", "0.0", ",", "0.0", 
           ",", "0.0", ",", "0.0", ",", "0.0", ",", "0.0", ",", "0.0", ",", 
           "0.0", ",", "0.0", ",", "0.0", ",", "0.0", ",", "0.0", ",", "0.0", 
           ",", "0.0", ",", "0.0", ",", "0.0", ",", "0.0", ",", "0.0", ",", 
           "0.0", ",", "0.0", ",", "0.0", ",", "0.0", ",", "0.0", ",", "0.0", 
           ",", "0.0", ",", "0.0", ",", "0.0", ",", "0.0", ",", "0.0", ",", 
           "0.0", ",", "0.0", ",", "0.0", ",", "0.0", ",", "0.0", ",", "0.0", 
           ",", "0.0", ",", "0.0", ",", "0.0", ",", "0.0", ",", "0.0", ",", 
           "0.0", ",", "0.0", ",", "0.0", ",", "0.0", ",", "0.0", ",", "0.0", 
           ",", "0.0", ",", "0.0", ",", "0.0", ",", "0.0", ",", "0.0", ",", 
           "0.0", ",", "0.0", ",", "0.0", ",", "0.0", ",", "0.0", ",", "0.0", 
           ",", "0.0", ",", "0.0", ",", "0.0", ",", "0.0", ",", "0.0", ",", 
           "0.0", ",", "0.0", ",", "0.0", ",", "0.0", ",", "0.0", ",", "0.0", 
           ",", "0.0", ",", "0.0", ",", "0.0", ",", "0.0", ",", "0.0", ",", 
           "0.0", ",", "0.0", ",", "0.0", ",", "0.0", ",", "0.0", ",", "0.0", 
           ",", "0.0", ",", "0.0", ",", "0.0", ",", "0.0", ",", "0.0", ",", 
           "0.0", ",", "0.0", ",", "0.0"}], "}"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"a12list", "=", 
         RowBox[{"{", 
          RowBox[{
          "0.0", ",", "0.08", ",", "0.08", ",", "0.0", ",", "0.0", ",", "0.0",
            ",", "0.0", ",", "0.0", ",", "0.0", ",", "0.0", ",", "0.0", ",", 
           "0.0", ",", "0.0", ",", "0.0", ",", "0.0", ",", "0.0", ",", "0.0", 
           ",", "0.0", ",", "0.0", ",", "0.0", ",", "0.0", ",", "0.0", ",", 
           "0.0", ",", "0.0", ",", "0.0", ",", "0.0", ",", "0.0", ",", "0.0", 
           ",", "0.0", ",", "0.0", ",", "0.0043", ",", "0.0081", ",", 
           "0.0117", ",", "0.0127", ",", "0.015", ",", "0.0181", ",", "0.021",
            ",", "0.0237", ",", "0.0262", ",", "0.0287", ",", "0.0309", ",", 
           "0.0352", ",", "0.0391", ",", "0.0409", ",", "0.0427", ",", 
           "0.046", ",", "0.0475", ",", "0.0491", ",", "0.0519", ",", 
           "0.0546", ",", "0.0559", ",", "0.0572", ",", "0.0596", ",", 
           "0.0619", ",", "0.0641", ",", "0.0662", ",", "0.0672", ",", 
           "0.0681", ",", "0.07", ",", "0.0719", ",", "0.0761", ",", "0.08", ",",
            "0.08", ",", "0.08", ",", "0.08", ",", "0.08", ",", "0.08", ",", 
           "0.08", ",", "0.08", ",", "0.08", ",", "0.08", ",", "0.08", ",", 
           "0.08", ",", "0.08", ",", "0.08", ",", "0.08", ",", "0.08", ",", 
           "0.08", ",", "0.08", ",", "0.08", ",", "0.08", ",", "0.08", ",", 
           "0.08", ",", "0.08", ",", "0.08", ",", "0.08", ",", "0.08", ",", 
           "0.08", ",", "0.08", ",", "0.08", ",", "0.08", ",", "0.08", ",", 
           "0.08", ",", "0.08", ",", "0.08", ",", "0.08", ",", "0.08", ",", 
           "0.08", ",", "0.08", ",", "0.08", ",", "0.08", ",", "0.08", ",", 
           "0.08", ",", "0.08", ",", "0.08", ",", "0.08", ",", "0.08", ",", 
           "0.08"}], "}"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"a13list", "=", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.06"}], ",", 
           RowBox[{"-", "0.06"}], ",", 
           RowBox[{"-", "0.06"}], ",", 
           RowBox[{"-", "0.06"}], ",", 
           RowBox[{"-", "0.06"}], ",", 
           RowBox[{"-", "0.06"}], ",", 
           RowBox[{"-", "0.06"}], ",", 
           RowBox[{"-", "0.06"}], ",", 
           RowBox[{"-", "0.06"}], ",", 
           RowBox[{"-", "0.06"}], ",", 
           RowBox[{"-", "0.06"}], ",", 
           RowBox[{"-", "0.06"}], ",", 
           RowBox[{"-", "0.06"}], ",", 
           RowBox[{"-", "0.06"}], ",", 
           RowBox[{"-", "0.06"}], ",", 
           RowBox[{"-", "0.06"}], ",", 
           RowBox[{"-", "0.06"}], ",", 
           RowBox[{"-", "0.06"}], ",", 
           RowBox[{"-", "0.06"}], ",", 
           RowBox[{"-", "0.06"}], ",", 
           RowBox[{"-", "0.06"}], ",", 
           RowBox[{"-", "0.06"}], ",", 
           RowBox[{"-", "0.06"}], ",", 
           RowBox[{"-", "0.06"}], ",", 
           RowBox[{"-", "0.06"}], ",", 
           RowBox[{"-", "0.06"}], ",", 
           RowBox[{"-", "0.06"}], ",", 
           RowBox[{"-", "0.06"}], ",", 
           RowBox[{"-", "0.06"}], ",", 
           RowBox[{"-", "0.06"}], ",", 
           RowBox[{"-", "0.06"}], ",", 
           RowBox[{"-", "0.06"}], ",", 
           RowBox[{"-", "0.06"}], ",", 
           RowBox[{"-", "0.06"}], ",", 
           RowBox[{"-", "0.06"}], ",", 
           RowBox[{"-", "0.06"}], ",", 
           RowBox[{"-", "0.06"}], ",", 
           RowBox[{"-", "0.06"}], ",", 
           RowBox[{"-", "0.06"}], ",", 
           RowBox[{"-", "0.06"}], ",", 
           RowBox[{"-", "0.06"}], ",", 
           RowBox[{"-", "0.06"}], ",", 
           RowBox[{"-", "0.06"}], ",", 
           RowBox[{"-", "0.06"}], ",", 
           RowBox[{"-", "0.06"}], ",", 
           RowBox[{"-", "0.06"}], ",", 
           RowBox[{"-", "0.06"}], ",", 
           RowBox[{"-", "0.06"}], ",", 
           RowBox[{"-", "0.06"}], ",", 
           RowBox[{"-", "0.06"}], ",", 
           RowBox[{"-", "0.06"}], ",", 
           RowBox[{"-", "0.06"}], ",", 
           RowBox[{"-", "0.06"}], ",", 
           RowBox[{"-", "0.06"}], ",", 
           RowBox[{"-", "0.06"}], ",", 
           RowBox[{"-", "0.06"}], ",", 
           RowBox[{"-", "0.06"}], ",", 
           RowBox[{"-", "0.06"}], ",", 
           RowBox[{"-", "0.06"}], ",", 
           RowBox[{"-", "0.06"}], ",", 
           RowBox[{"-", "0.06"}], ",", 
           RowBox[{"-", "0.06"}], ",", 
           RowBox[{"-", "0.06"}], ",", 
           RowBox[{"-", "0.06"}], ",", 
           RowBox[{"-", "0.06"}], ",", 
           RowBox[{"-", "0.06"}], ",", 
           RowBox[{"-", "0.06"}], ",", 
           RowBox[{"-", "0.06"}], ",", 
           RowBox[{"-", "0.06"}], ",", 
           RowBox[{"-", "0.06"}], ",", 
           RowBox[{"-", "0.06"}], ",", 
           RowBox[{"-", "0.06"}], ",", 
           RowBox[{"-", "0.06"}], ",", 
           RowBox[{"-", "0.06"}], ",", 
           RowBox[{"-", "0.06"}], ",", 
           RowBox[{"-", "0.06"}], ",", 
           RowBox[{"-", "0.06"}], ",", 
           RowBox[{"-", "0.06"}], ",", 
           RowBox[{"-", "0.06"}], ",", 
           RowBox[{"-", "0.06"}], ",", 
           RowBox[{"-", "0.06"}], ",", 
           RowBox[{"-", "0.06"}], ",", 
           RowBox[{"-", "0.06"}], ",", 
           RowBox[{"-", "0.06"}], ",", 
           RowBox[{"-", "0.06"}], ",", 
           RowBox[{"-", "0.06"}], ",", 
           RowBox[{"-", "0.06"}], ",", 
           RowBox[{"-", "0.06"}], ",", 
           RowBox[{"-", "0.06"}], ",", 
           RowBox[{"-", "0.06"}], ",", 
           RowBox[{"-", "0.06"}], ",", 
           RowBox[{"-", "0.06"}], ",", 
           RowBox[{"-", "0.06"}], ",", 
           RowBox[{"-", "0.06"}], ",", 
           RowBox[{"-", "0.06"}], ",", 
           RowBox[{"-", "0.06"}], ",", 
           RowBox[{"-", "0.06"}], ",", 
           RowBox[{"-", "0.06"}], ",", 
           RowBox[{"-", "0.06"}], ",", 
           RowBox[{"-", "0.06"}], ",", 
           RowBox[{"-", "0.06"}], ",", 
           RowBox[{"-", "0.06"}], ",", 
           RowBox[{"-", "0.06"}], ",", 
           RowBox[{"-", "0.06"}], ",", 
           RowBox[{"-", "0.06"}], ",", 
           RowBox[{"-", "0.06"}], ",", 
           RowBox[{"-", "0.06"}], ",", 
           RowBox[{"-", "0.06"}]}], "}"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"a14list", "=", 
         RowBox[{"{", 
          RowBox[{
          "1.08", ",", "0.7", ",", "0.5", ",", "1.08", ",", "1.08", ",", 
           "1.0925", ",", "1.1092", ",", "1.1287", ",", "1.1331", ",", 
           "1.1416", ",", "1.1533", ",", "1.157", ",", "1.1708", ",", 
           "1.1772", ",", "1.1833", ",", "1.1862", ",", "1.1891", ",", 
           "1.1947", ",", "1.2", ",", "1.2", ",", "1.2", ",", "1.2", ",", 
           "1.2", ",", "1.2", ",", "1.2", ",", "1.2", ",", "1.2", ",", "1.2", 
           ",", "1.2", ",", "1.2", ",", "1.2", ",", "1.2", ",", "1.1886", ",",
            "1.1854", ",", "1.1781", ",", "1.1683", ",", "1.1591", ",", 
           "1.1505", ",", "1.1424", ",", "1.1347", ",", "1.1274", ",", 
           "1.1138", ",", "1.1015", ",", "1.0956", ",", "1.0901", ",", 
           "1.0795", ",", "1.0745", ",", "1.0697", ",", "1.0605", ",", 
           "1.0519", ",", "1.0478", ",", "1.0438", ",", "1.0361", ",", 
           "1.0288", ",", "1.0219", ",", "1.0153", ",", "1.0121", ",", 
           "1.009", ",", "1.0029", ",", "0.9971", ",", "0.9835", ",", 
           "0.9712", ",", "0.9598", ",", "0.9561", ",", "0.9493", ",", 
           "0.9395", ",", "0.9303", ",", "0.9217", ",", "0.9135", ",", 
           "0.9058", ",", "0.8985", ",", "0.885", ",", "0.8726", ",", 
           "0.8612", ",", "0.8507", ",", "0.8409", ",", "0.8317", ",", 
           "0.8231", ",", "0.815", ",", "0.8073", ",", "0.8", ",", "0.7246", ",",
            "0.6558", ",", "0.6235", ",", "0.5925", ",", "0.5339", ",", 
           "0.4793", ",", "0.4283", ",", "0.3804", ",", "0.3574", ",", 
           "0.3352", ",", "0.2924", ",", "0.2518", ",", "0.2133", ",", 
           "0.1765", ",", "0.1413", ",", "0.1077", ",", "0.0754", ",", "0.0", 
           ",", "0.0", ",", "0.0", ",", "0.0", ",", "0.0", ",", "0.0", ",", 
           "0.0", ",", "0.0", ",", "0.0", ",", "0.0"}], "}"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"a15list", "=", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.35"}], ",", 
           RowBox[{"-", "0.39"}], ",", 
           RowBox[{"-", "0.56"}], ",", 
           RowBox[{"-", "0.35"}], ",", 
           RowBox[{"-", "0.35"}], ",", 
           RowBox[{"-", "0.35"}], ",", 
           RowBox[{"-", "0.35"}], ",", 
           RowBox[{"-", "0.35"}], ",", 
           RowBox[{"-", "0.35"}], ",", 
           RowBox[{"-", "0.35"}], ",", 
           RowBox[{"-", "0.35"}], ",", 
           RowBox[{"-", "0.35"}], ",", 
           RowBox[{"-", "0.35"}], ",", 
           RowBox[{"-", "0.35"}], ",", 
           RowBox[{"-", "0.35"}], ",", 
           RowBox[{"-", "0.35"}], ",", 
           RowBox[{"-", "0.35"}], ",", 
           RowBox[{"-", "0.35"}], ",", 
           RowBox[{"-", "0.35"}], ",", 
           RowBox[{"-", "0.35"}], ",", 
           RowBox[{"-", "0.35"}], ",", 
           RowBox[{"-", "0.35"}], ",", 
           RowBox[{"-", "0.35"}], ",", 
           RowBox[{"-", "0.35"}], ",", 
           RowBox[{"-", "0.35"}], ",", 
           RowBox[{"-", "0.35"}], ",", 
           RowBox[{"-", "0.35"}], ",", 
           RowBox[{"-", "0.35"}], ",", 
           RowBox[{"-", "0.35"}], ",", 
           RowBox[{"-", "0.35"}], ",", 
           RowBox[{"-", "0.35"}], ",", 
           RowBox[{"-", "0.35"}], ",", 
           RowBox[{"-", "0.35"}], ",", 
           RowBox[{"-", "0.35"}], ",", 
           RowBox[{"-", "0.35"}], ",", 
           RowBox[{"-", "0.35"}], ",", 
           RowBox[{"-", "0.35"}], ",", 
           RowBox[{"-", "0.35"}], ",", 
           RowBox[{"-", "0.35"}], ",", 
           RowBox[{"-", "0.35"}], ",", 
           RowBox[{"-", "0.35"}], ",", 
           RowBox[{"-", "0.35"}], ",", 
           RowBox[{"-", "0.35"}], ",", 
           RowBox[{"-", "0.35"}], ",", 
           RowBox[{"-", "0.35"}], ",", 
           RowBox[{"-", "0.35"}], ",", 
           RowBox[{"-", "0.35"}], ",", 
           RowBox[{"-", "0.35"}], ",", 
           RowBox[{"-", "0.35"}], ",", 
           RowBox[{"-", "0.35"}], ",", 
           RowBox[{"-", "0.35"}], ",", 
           RowBox[{"-", "0.35"}], ",", 
           RowBox[{"-", "0.35"}], ",", 
           RowBox[{"-", "0.35"}], ",", 
           RowBox[{"-", "0.3432"}], ",", 
           RowBox[{"-", "0.3368"}], ",", 
           RowBox[{"-", "0.3337"}], ",", 
           RowBox[{"-", "0.3306"}], ",", 
           RowBox[{"-", "0.3247"}], ",", 
           RowBox[{"-", "0.3191"}], ",", 
           RowBox[{"-", "0.3059"}], ",", 
           RowBox[{"-", "0.2938"}], ",", 
           RowBox[{"-", "0.2827"}], ",", 
           RowBox[{"-", "0.2791"}], ",", 
           RowBox[{"-", "0.2725"}], ",", 
           RowBox[{"-", "0.2629"}], ",", 
           RowBox[{"-", "0.2539"}], ",", 
           RowBox[{"-", "0.2455"}], ",", 
           RowBox[{"-", "0.2376"}], ",", 
           RowBox[{"-", "0.2301"}], ",", 
           RowBox[{"-", "0.223"}], ",", 
           RowBox[{"-", "0.2098"}], ",", 
           RowBox[{"-", "0.1978"}], ",", 
           RowBox[{"-", "0.1867"}], ",", 
           RowBox[{"-", "0.1764"}], ",", 
           RowBox[{"-", "0.1668"}], ",", 
           RowBox[{"-", "0.1579"}], ",", 
           RowBox[{"-", "0.1495"}], ",", 
           RowBox[{"-", "0.1416"}], ",", 
           RowBox[{"-", "0.1341"}], ",", 
           RowBox[{"-", "0.127"}], ",", 
           RowBox[{"-", "0.1138"}], ",", 
           RowBox[{"-", "0.1017"}], ",", 
           RowBox[{"-", "0.0961"}], ",", 
           RowBox[{"-", "0.0906"}], ",", 
           RowBox[{"-", "0.0803"}], ",", 
           RowBox[{"-", "0.0708"}], ",", 
           RowBox[{"-", "0.0618"}], ",", 
           RowBox[{"-", "0.0534"}], ",", 
           RowBox[{"-", "0.0494"}], ",", 
           RowBox[{"-", "0.0455"}], ",", 
           RowBox[{"-", "0.038"}], ",", 
           RowBox[{"-", "0.0309"}], ",", 
           RowBox[{"-", "0.0242"}], ",", 
           RowBox[{"-", "0.0177"}], ",", 
           RowBox[{"-", "0.0116"}], ",", 
           RowBox[{"-", "0.0057"}], ",", "0.0", ",", "0.0", ",", "0.0", ",", 
           "0.0", ",", "0.0", ",", "0.0", ",", "0.0", ",", "0.0", ",", "0.0", 
           ",", "0.0", ",", "0.0"}], "}"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"a16list", "=", 
         RowBox[{"{", 
          RowBox[{
          "0.9", ",", "0.63", ",", "0.17", ",", "0.9", ",", "0.9", ",", "0.9",
            ",", "0.9", ",", "0.9", ",", "0.9", ",", "0.9", ",", "0.9", ",", 
           "0.9", ",", "0.9", ",", "0.9", ",", "0.9", ",", "0.9", ",", "0.9", 
           ",", "0.9", ",", "0.9", ",", "0.9", ",", "0.9", ",", "0.9", ",", 
           "0.9", ",", "0.9", ",", "0.9", ",", "0.9", ",", "0.9", ",", "0.9", 
           ",", "0.9", ",", "0.9", ",", "0.9", ",", "0.9", ",", "0.9", ",", 
           "0.9", ",", "0.9", ",", "0.9", ",", "0.9", ",", "0.9", ",", "0.9", 
           ",", "0.9", ",", "0.9", ",", "0.9", ",", "0.9", ",", "0.9", ",", 
           "0.9", ",", "0.9", ",", "0.9", ",", "0.9", ",", "0.9", ",", "0.9", 
           ",", "0.9", ",", "0.8878", ",", "0.8644", ",", "0.8423", ",", 
           "0.8212", ",", "0.801", ",", "0.7913", ",", "0.7818", ",", 
           "0.7634", ",", "0.7458", ",", "0.7045", ",", "0.6669", ",", 
           "0.6323", ",", "0.6211", ",", "0.6002", ",", "0.5704", ",", 
           "0.5425", ",", "0.5163", ",", "0.4916", ",", "0.4682", ",", 
           "0.446", ",", "0.4048", ",", "0.3672", ",", "0.3325", ",", 
           "0.3005", ",", "0.2707", ",", "0.2427", ",", "0.2165", ",", 
           "0.1918", ",", "0.1684", ",", "0.1463", ",", "0.105", ",", 
           "0.0674", ",", "0.0498", ",", "0.0328", ",", "0.0007", ",", 
           RowBox[{"-", "0.0291"}], ",", 
           RowBox[{"-", "0.057"}], ",", 
           RowBox[{"-", "0.0832"}], ",", 
           RowBox[{"-", "0.0958"}], ",", 
           RowBox[{"-", "0.1079"}], ",", 
           RowBox[{"-", "0.1313"}], ",", 
           RowBox[{"-", "0.1535"}], ",", 
           RowBox[{"-", "0.1746"}], ",", 
           RowBox[{"-", "0.1947"}], ",", 
           RowBox[{"-", "0.2139"}], ",", 
           RowBox[{"-", "0.2323"}], ",", 
           RowBox[{"-", "0.25"}], ",", 
           RowBox[{"-", "0.25"}], ",", 
           RowBox[{"-", "0.25"}], ",", 
           RowBox[{"-", "0.25"}], ",", 
           RowBox[{"-", "0.25"}], ",", 
           RowBox[{"-", "0.25"}], ",", 
           RowBox[{"-", "0.25"}], ",", 
           RowBox[{"-", "0.25"}], ",", 
           RowBox[{"-", "0.25"}], ",", 
           RowBox[{"-", "0.25"}], ",", 
           RowBox[{"-", "0.25"}]}], "}"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"a17list", "=", 
         RowBox[{"{", 
          RowBox[{
          "0.9", ",", "0.63", ",", "0.17", ",", "0.9", ",", "0.9", ",", "0.9",
            ",", "0.9", ",", "0.9", ",", "0.9", ",", "0.9", ",", "0.9", ",", 
           "0.9", ",", "0.9", ",", "0.9", ",", "0.9", ",", "0.9", ",", "0.9", 
           ",", "0.9", ",", "0.9", ",", "0.9", ",", "0.9", ",", "0.9", ",", 
           "0.9", ",", "0.9", ",", "0.9", ",", "0.9", ",", "0.9", ",", "0.9", 
           ",", "0.9", ",", "0.9", ",", "0.9", ",", "0.9", ",", "0.9", ",", 
           "0.9", ",", "0.9", ",", "0.9", ",", "0.9", ",", "0.9", ",", "0.9", 
           ",", "0.9", ",", "0.9", ",", "0.9", ",", "0.9", ",", "0.9", ",", 
           "0.9", ",", "0.9", ",", "0.9", ",", "0.9", ",", "0.9", ",", "0.9", 
           ",", "0.9", ",", "0.8878", ",", "0.8644", ",", "0.8423", ",", 
           "0.8212", ",", "0.801", ",", "0.7913", ",", "0.7818", ",", 
           "0.7634", ",", "0.7458", ",", "0.7045", ",", "0.6669", ",", 
           "0.6323", ",", "0.6211", ",", "0.6002", ",", "0.5704", ",", 
           "0.5425", ",", "0.5163", ",", "0.4916", ",", "0.4682", ",", 
           "0.446", ",", "0.4048", ",", "0.3672", ",", "0.3325", ",", 
           "0.3005", ",", "0.2707", ",", "0.2427", ",", "0.2165", ",", 
           "0.1918", ",", "0.1684", ",", "0.1463", ",", "0.105", ",", 
           "0.0674", ",", "0.0498", ",", "0.0328", ",", "0.0007", ",", 
           RowBox[{"-", "0.0291"}], ",", 
           RowBox[{"-", "0.057"}], ",", 
           RowBox[{"-", "0.0832"}], ",", 
           RowBox[{"-", "0.0958"}], ",", 
           RowBox[{"-", "0.1079"}], ",", 
           RowBox[{"-", "0.1313"}], ",", 
           RowBox[{"-", "0.1535"}], ",", 
           RowBox[{"-", "0.1746"}], ",", 
           RowBox[{"-", "0.1947"}], ",", 
           RowBox[{"-", "0.2139"}], ",", 
           RowBox[{"-", "0.2323"}], ",", 
           RowBox[{"-", "0.25"}], ",", 
           RowBox[{"-", "0.25"}], ",", 
           RowBox[{"-", "0.25"}], ",", 
           RowBox[{"-", "0.25"}], ",", 
           RowBox[{"-", "0.25"}], ",", 
           RowBox[{"-", "0.25"}], ",", 
           RowBox[{"-", "0.25"}], ",", 
           RowBox[{"-", "0.25"}], ",", 
           RowBox[{"-", "0.25"}], ",", 
           RowBox[{"-", "0.25"}], ",", 
           RowBox[{"-", "0.25"}]}], "}"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"a18list", "=", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.0067"}], ",", "0.0", ",", "0.0", ",", 
           RowBox[{"-", "0.0067"}], ",", 
           RowBox[{"-", "0.0067"}], ",", 
           RowBox[{"-", "0.0067"}], ",", 
           RowBox[{"-", "0.0067"}], ",", 
           RowBox[{"-", "0.0067"}], ",", 
           RowBox[{"-", "0.0067"}], ",", 
           RowBox[{"-", "0.0067"}], ",", 
           RowBox[{"-", "0.0067"}], ",", 
           RowBox[{"-", "0.0067"}], ",", 
           RowBox[{"-", "0.0067"}], ",", 
           RowBox[{"-", "0.0069"}], ",", 
           RowBox[{"-", "0.0071"}], ",", 
           RowBox[{"-", "0.0072"}], ",", 
           RowBox[{"-", "0.0073"}], ",", 
           RowBox[{"-", "0.0075"}], ",", 
           RowBox[{"-", "0.0076"}], ",", 
           RowBox[{"-", "0.008"}], ",", 
           RowBox[{"-", "0.0084"}], ",", 
           RowBox[{"-", "0.0087"}], ",", 
           RowBox[{"-", "0.0088"}], ",", 
           RowBox[{"-", "0.009"}], ",", 
           RowBox[{"-", "0.0093"}], ",", 
           RowBox[{"-", "0.0093"}], ",", 
           RowBox[{"-", "0.0093"}], ",", 
           RowBox[{"-", "0.0093"}], ",", 
           RowBox[{"-", "0.0093"}], ",", 
           RowBox[{"-", "0.0093"}], ",", 
           RowBox[{"-", "0.0093"}], ",", 
           RowBox[{"-", "0.0093"}], ",", 
           RowBox[{"-", "0.0093"}], ",", 
           RowBox[{"-", "0.0093"}], ",", 
           RowBox[{"-", "0.0093"}], ",", 
           RowBox[{"-", "0.0093"}], ",", 
           RowBox[{"-", "0.0093"}], ",", 
           RowBox[{"-", "0.0093"}], ",", 
           RowBox[{"-", "0.0089"}], ",", 
           RowBox[{"-", "0.0086"}], ",", 
           RowBox[{"-", "0.0083"}], ",", 
           RowBox[{"-", "0.0077"}], ",", 
           RowBox[{"-", "0.0071"}], ",", 
           RowBox[{"-", "0.0069"}], ",", 
           RowBox[{"-", "0.0066"}], ",", 
           RowBox[{"-", "0.0062"}], ",", 
           RowBox[{"-", "0.006"}], ",", 
           RowBox[{"-", "0.0057"}], ",", 
           RowBox[{"-", "0.0053"}], ",", 
           RowBox[{"-", "0.005"}], ",", 
           RowBox[{"-", "0.0048"}], ",", 
           RowBox[{"-", "0.0046"}], ",", 
           RowBox[{"-", "0.0043"}], ",", 
           RowBox[{"-", "0.0039"}], ",", 
           RowBox[{"-", "0.0036"}], ",", 
           RowBox[{"-", "0.0033"}], ",", 
           RowBox[{"-", "0.0032"}], ",", 
           RowBox[{"-", "0.0031"}], ",", 
           RowBox[{"-", "0.0028"}], ",", 
           RowBox[{"-", "0.0025"}], ",", 
           RowBox[{"-", "0.0019"}], ",", 
           RowBox[{"-", "0.0014"}], ",", 
           RowBox[{"-", "0.0009"}], ",", 
           RowBox[{"-", "0.0007"}], ",", 
           RowBox[{"-", "0.0004"}], ",", "0.0", ",", "0.0", ",", "0.0", ",", 
           "0.0", ",", "0.0", ",", "0.0", ",", "0.0", ",", "0.0", ",", "0.0", 
           ",", "0.0", ",", "0.0", ",", "0.0", ",", "0.0", ",", "0.0", ",", 
           "0.0", ",", "0.0", ",", "0.0", ",", "0.0", ",", "0.0", ",", "0.0", 
           ",", "0.0", ",", "0.0", ",", "0.0", ",", "0.0", ",", "0.0", ",", 
           "0.0", ",", "0.0", ",", "0.0", ",", "0.0", ",", "0.0", ",", "0.0", 
           ",", "0.0", ",", "0.0", ",", "0.0", ",", "0.0", ",", "0.0", ",", 
           "0.0", ",", "0.0", ",", "0.0", ",", "0.0", ",", "0.0", ",", "0.0", 
           ",", "0.0"}], "}"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"s1elist", "=", 
         RowBox[{"{", 
          RowBox[{
          "0.59", ",", "0.59", ",", "0.73333", ",", "0.59", ",", "0.59", ",", 
           "0.593", ",", "0.598", ",", "0.604", ",", "0.605", ",", "0.607", ",",
            "0.61", ",", "0.611", ",", "0.615", ",", "0.617", ",", "0.619", ",",
            "0.62", ",", "0.62", ",", "0.622", ",", "0.623", ",", "0.627", ",",
            "0.63", ",", "0.63", ",", "0.63", ",", "0.63", ",", "0.63", ",", 
           "0.63", ",", "0.63", ",", "0.63", ",", "0.63", ",", "0.63", ",", 
           "0.63", ",", "0.63", ",", "0.63", ",", "0.63", ",", "0.63", ",", 
           "0.63", ",", "0.63", ",", "0.63", ",", "0.63", ",", "0.63", ",", 
           "0.63", ",", "0.63", ",", "0.63", ",", "0.63", ",", "0.63", ",", 
           "0.63", ",", "0.63", ",", "0.63", ",", "0.63", ",", "0.63", ",", 
           "0.63", ",", "0.63", ",", "0.63", ",", "0.63", ",", "0.63", ",", 
           "0.63", ",", "0.63", ",", "0.63", ",", "0.63", ",", "0.63", ",", 
           "0.63", ",", "0.63", ",", "0.63", ",", "0.63", ",", "0.63", ",", 
           "0.63", ",", "0.63", ",", "0.63", ",", "0.63", ",", "0.63", ",", 
           "0.63", ",", "0.626", ",", "0.623", ",", "0.62", ",", "0.617", ",",
            "0.615", ",", "0.612", ",", "0.61", ",", "0.608", ",", "0.606", ",",
            "0.604", ",", "0.601", ",", "0.597", ",", "0.596", ",", "0.594", ",",
            "0.592", ",", "0.589", ",", "0.587", ",", "0.584", ",", "0.583", ",",
            "0.582", ",", "0.58", ",", "0.578", ",", "0.576", ",", "0.575", ",",
            "0.573", ",", "0.572", ",", "0.57", ",", "0.58", ",", "0.588", ",",
            "0.596", ",", "0.604", ",", "0.611", ",", "0.617", ",", "0.624", ",",
            "0.629", ",", "0.635", ",", "0.64"}], "}"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"s2elist", "=", 
         RowBox[{"{", 
          RowBox[{
          "0.47", ",", "0.47", ",", "0.7395", ",", "0.47", ",", "0.47", ",", 
           "0.472", ",", "0.474", ",", "0.477", ",", "0.478", ",", "0.479", ",",
            "0.481", ",", "0.481", ",", "0.483", ",", "0.484", ",", "0.485", ",",
            "0.486", ",", "0.486", ",", "0.487", ",", "0.488", ",", "0.489", ",",
            "0.491", ",", "0.493", ",", "0.493", ",", "0.494", ",", "0.495", ",",
            "0.497", ",", "0.498", ",", "0.499", ",", "0.5", ",", "0.501", ",",
            "0.503", ",", "0.504", ",", "0.506", ",", "0.506", ",", "0.507", ",",
            "0.509", ",", "0.51", ",", "0.511", ",", "0.512", ",", "0.513", ",",
            "0.514", ",", "0.516", ",", "0.518", ",", "0.518", ",", "0.519", ",",
            "0.521", ",", "0.521", ",", "0.522", ",", "0.523", ",", "0.524", ",",
            "0.525", ",", "0.525", ",", "0.526", ",", "0.527", ",", "0.528", ",",
            "0.529", ",", "0.53", ",", "0.53", ",", "0.531", ",", "0.532", ",",
            "0.534", ",", "0.535", ",", "0.537", ",", "0.537", ",", "0.538", ",",
            "0.539", ",", "0.541", ",", "0.542", ",", "0.543", ",", "0.544", ",",
            "0.545", ",", "0.547", ",", "0.548", ",", "0.55", ",", "0.551", ",",
            "0.552", ",", "0.553", ",", "0.555", ",", "0.556", ",", "0.557", ",",
            "0.558", ",", "0.559", ",", "0.561", ",", "0.562", ",", "0.562", ",",
            "0.564", ",", "0.565", ",", "0.566", ",", "0.567", ",", "0.568", ",",
            "0.568", ",", "0.569", ",", "0.57", ",", "0.574", ",", "0.577", ",",
            "0.581", ",", "0.584", ",", "0.587", ",", "0.594", ",", "0.601", ",",
            "0.607", ",", "0.613", ",", "0.618", ",", "0.623", ",", "0.628", ",",
            "0.632", ",", "0.636", ",", "0.64"}], "}"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"s3list", "=", 
         RowBox[{"{", 
          RowBox[{
          "0.47", ",", "0.42", ",", "0.6864", ",", "0.42", ",", "0.42", ",", 
           "0.43", ",", "0.443", ",", "0.459", ",", "0.462", ",", "0.469", ",",
            "0.478", ",", "0.481", ",", "0.492", ",", "0.497", ",", "0.502", ",",
            "0.504", ",", "0.506", ",", "0.511", ",", "0.515", ",", "0.525", ",",
            "0.534", ",", "0.542", ",", "0.545", ",", "0.55", ",", "0.55", ",",
            "0.55", ",", "0.55", ",", "0.55", ",", "0.55", ",", "0.55", ",", 
           "0.55", ",", "0.55", ",", "0.55", ",", "0.55", ",", "0.55", ",", 
           "0.55", ",", "0.543", ",", "0.537", ",", "0.531", ",", "0.526", ",",
            "0.52", ",", "0.511", ",", "0.502", ",", "0.497", ",", "0.493", ",",
            "0.486", ",", "0.482", ",", "0.479", ",", "0.472", ",", "0.466", ",",
            "0.463", ",", "0.46", ",", "0.454", ",", "0.449", ",", "0.444", ",",
            "0.439", ",", "0.437", ",", "0.435", ",", "0.43", ",", "0.426", ",",
            "0.416", ",", "0.408", ",", "0.399", ",", "0.397", ",", "0.392", ",",
            "0.385", ",", "0.378", ",", "0.372", ",", "0.366", ",", "0.36", ",",
            "0.35", ",", "0.35", ",", "0.35", ",", "0.35", ",", "0.35", ",", 
           "0.35", ",", "0.35", ",", "0.35", ",", "0.35", ",", "0.35", ",", 
           "0.35", ",", "0.35", ",", "0.35", ",", "0.35", ",", "0.35", ",", 
           "0.35", ",", "0.35", ",", "0.35", ",", "0.35", ",", "0.35", ",", 
           "0.35", ",", "0.35", ",", "0.35", ",", "0.35", ",", "0.35", ",", 
           "0.35", ",", "0.35", ",", "0.35", ",", "0.35", ",", "0.35", ",", 
           "0.35", ",", "0.35", ",", "0.35", ",", "0.35", ",", "0.35", ",", 
           "0.35", ",", "0.35", ",", "0.35"}], "}"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"s4list", "=", 
         RowBox[{"{", 
          RowBox[{
          "0.3", ",", "0.3", ",", "0.4414", ",", "0.3", ",", "0.3", ",", 
           "0.301", ",", "0.303", ",", "0.305", ",", "0.305", ",", "0.306", ",",
            "0.307", ",", "0.308", ",", "0.309", ",", "0.309", ",", "0.31", ",",
            "0.31", ",", "0.311", ",", "0.311", ",", "0.312", ",", "0.313", ",",
            "0.314", ",", "0.315", ",", "0.315", ",", "0.316", ",", "0.317", ",",
            "0.318", ",", "0.318", ",", "0.319", ",", "0.32", ",", "0.321", ",",
            "0.322", ",", "0.323", ",", "0.324", ",", "0.324", ",", "0.325", ",",
            "0.326", ",", "0.327", ",", "0.327", ",", "0.328", ",", "0.329", ",",
            "0.329", ",", "0.331", ",", "0.332", ",", "0.332", ",", "0.333", ",",
            "0.334", ",", "0.334", ",", "0.335", ",", "0.335", ",", "0.336", ",",
            "0.337", ",", "0.337", ",", "0.338", ",", "0.338", ",", "0.339", ",",
            "0.34", ",", "0.34", ",", "0.34", ",", "0.341", ",", "0.341", ",",
            "0.342", ",", "0.343", ",", "0.344", ",", "0.345", ",", "0.345", ",",
            "0.346", ",", "0.347", ",", "0.348", ",", "0.349", ",", "0.349", ",",
            "0.35", ",", "0.35", ",", "0.35", ",", "0.35", ",", "0.35", ",", 
           "0.35", ",", "0.35", ",", "0.35", ",", "0.35", ",", "0.35", ",", 
           "0.35", ",", "0.35", ",", "0.35", ",", "0.35", ",", "0.35", ",", 
           "0.35", ",", "0.35", ",", "0.35", ",", "0.35", ",", "0.35", ",", 
           "0.35", ",", "0.35", ",", "0.35", ",", "0.35", ",", "0.35", ",", 
           "0.35", ",", "0.35", ",", "0.35", ",", "0.35", ",", "0.35", ",", 
           "0.35", ",", "0.35", ",", "0.35", ",", "0.35", ",", "0.35", ",", 
           "0.35", ",", "0.35", ",", "0.35"}], "}"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"s1mlist", "=", 
         RowBox[{"{", 
          RowBox[{
          "0.576", ",", "0.576", ",", "0.6887", ",", "0.576", ",", "0.576", ",",
            "0.58", ",", "0.585", ",", "0.59", ",", "0.591", ",", "0.594", ",",
            "0.597", ",", "0.598", ",", "0.602", ",", "0.604", ",", "0.606", ",",
            "0.607", ",", "0.607", ",", "0.609", ",", "0.61", ",", "0.614", ",",
            "0.617", ",", "0.617", ",", "0.617", ",", "0.617", ",", "0.617", ",",
            "0.617", ",", "0.617", ",", "0.617", ",", "0.617", ",", "0.617", ",",
            "0.617", ",", "0.617", ",", "0.617", ",", "0.617", ",", "0.617", ",",
            "0.616", ",", "0.616", ",", "0.615", ",", "0.615", ",", "0.615", ",",
            "0.614", ",", "0.613", ",", "0.613", ",", "0.612", ",", "0.612", ",",
            "0.611", ",", "0.611", ",", "0.611", ",", "0.61", ",", "0.61", ",",
            "0.61", ",", "0.609", ",", "0.609", ",", "0.608", ",", "0.608", ",",
            "0.608", ",", "0.607", ",", "0.607", ",", "0.607", ",", "0.606", ",",
            "0.606", ",", "0.605", ",", "0.604", ",", "0.604", ",", "0.603", 
           ",", "0.602", ",", "0.6", ",", "0.598", ",", "0.597", ",", "0.595",
            ",", "0.594", ",", "0.588", ",", "0.582", ",", "0.576", ",", 
           "0.571", ",", "0.566", ",", "0.561", ",", "0.556", ",", "0.552", ",",
            "0.548", ",", "0.544", ",", "0.54", ",", "0.536", ",", "0.534", ",",
            "0.533", ",", "0.53", ",", "0.527", ",", "0.524", ",", "0.522", ",",
            "0.52", ",", "0.519", ",", "0.517", ",", "0.515", ",", "0.513", ",",
            "0.511", ",", "0.509", ",", "0.509", ",", "0.51", ",", "0.525", ",",
            "0.539", ",", "0.551", ",", "0.562", ",", "0.572", ",", "0.581", ",",
            "0.59", ",", "0.598", ",", "0.605", ",", "0.612"}], "}"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"s2mlist", "=", 
         RowBox[{"{", 
          RowBox[{
          "0.453", ",", "0.453", ",", "0.6953", ",", "0.453", ",", "0.453", ",",
            "0.455", ",", "0.457", ",", "0.46", ",", "0.461", ",", "0.462", ",",
            "0.464", ",", "0.464", ",", "0.466", ",", "0.467", ",", "0.468", ",",
            "0.469", ",", "0.469", ",", "0.47", ",", "0.471", ",", "0.473", ",",
            "0.475", ",", "0.476", ",", "0.477", ",", "0.478", ",", "0.479", ",",
            "0.48", ",", "0.481", ",", "0.483", ",", "0.484", ",", "0.485", ",",
            "0.487", ",", "0.488", ",", "0.49", ",", "0.49", ",", "0.491", ",",
            "0.491", ",", "0.492", ",", "0.493", ",", "0.493", ",", "0.494", ",",
            "0.495", ",", "0.496", ",", "0.496", ",", "0.497", ",", "0.497", ",",
            "0.498", ",", "0.498", ",", "0.499", ",", "0.499", ",", "0.5", ",",
            "0.5", ",", "0.5", ",", "0.501", ",", "0.501", ",", "0.502", ",", 
           "0.502", ",", "0.503", ",", "0.503", ",", "0.503", ",", "0.504", ",",
            "0.504", ",", "0.505", ",", "0.506", ",", "0.506", ",", "0.506", ",",
            "0.506", ",", "0.505", ",", "0.505", ",", "0.504", ",", "0.504", ",",
            "0.503", ",", "0.502", ",", "0.501", ",", "0.499", ",", "0.498", ",",
            "0.497", ",", "0.496", ",", "0.495", ",", "0.493", ",", "0.492", ",",
            "0.491", ",", "0.493", ",", "0.495", ",", "0.496", ",", "0.497", ",",
            "0.498", ",", "0.5", ",", "0.501", ",", "0.502", ",", "0.503", ",",
            "0.503", ",", "0.504", ",", "0.505", ",", "0.51", ",", "0.514", ",",
            "0.517", ",", "0.523", ",", "0.529", ",", "0.541", ",", "0.552", ",",
            "0.562", ",", "0.571", ",", "0.579", ",", "0.587", ",", "0.594", ",",
            "0.601", ",", "0.607", ",", "0.612"}], "}"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"sigcorrlist", "=", 
         RowBox[{"{", 
          RowBox[{
          "1.000", ",", "0.74", ",", "0.47", ",", "1.000", ",", "1.000", ",", 
           "0.998", ",", "0.996", ",", "0.992", ",", "0.991", ",", "0.989", ",",
            "0.987", ",", "0.986", ",", "0.982", ",", "0.98", ",", "0.978", ",",
            "0.978", ",", "0.977", ",", "0.975", ",", "0.973", ",", "0.969", ",",
            "0.965", ",", "0.961", ",", "0.96", ",", "0.957", ",", "0.952", ",",
            "0.946", ",", "0.942", ",", "0.937", ",", "0.933", ",", "0.929", ",",
            "0.921", ",", "0.914", ",", "0.908", ",", "0.906", ",", "0.902", ",",
            "0.896", ",", "0.891", ",", "0.886", ",", "0.882", ",", "0.878", ",",
            "0.874", ",", "0.866", ",", "0.859", ",", "0.856", ",", "0.853", ",",
            "0.847", ",", "0.844", ",", "0.841", ",", "0.836", ",", "0.831", ",",
            "0.829", ",", "0.827", ",", "0.823", ",", "0.818", ",", "0.815", ",",
            "0.811", ",", "0.81", ",", "0.804", ",", "0.794", ",", "0.783", ",",
            "0.759", ",", "0.737", ",", "0.717", ",", "0.71", ",", "0.698", ",",
            "0.68", ",", "0.664", ",", "0.648", ",", "0.634", ",", "0.62", ",",
            "0.607", ",", "0.583", ",", "0.561", ",", "0.541", ",", "0.522", ",",
            "0.504", ",", "0.488", ",", "0.472", ",", "0.458", ",", "0.444", ",",
            "0.431", ",", "0.407", ",", "0.385", ",", "0.374", ",", "0.364", ",",
            "0.346", ",", "0.328", ",", "0.312", ",", "0.296", ",", "0.289", ",",
            "0.282", ",", "0.268", ",", "0.255", ",", "0.243", ",", "0.231", ",",
            "0.22", ",", "0.209", ",", "0.2", ",", "0.2", ",", "0.2", ",", 
           "0.2", ",", "0.2", ",", "0.2", ",", "0.2", ",", "0.2", ",", "0.2", 
           ",", "0.2", ",", "0.2"}], "}"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"taucorrlist", "=", 
         RowBox[{"{", 
          RowBox[{
          "1.000", ",", "0.74", ",", "0.47", ",", "1.000", ",", "1.000", ",", 
           "0.998", ",", "0.996", ",", "0.992", ",", "0.991", ",", "0.989", ",",
            "0.987", ",", "0.986", ",", "0.982", ",", "0.98", ",", "0.978", ",",
            "0.978", ",", "0.977", ",", "0.975", ",", "0.973", ",", "0.969", ",",
            "0.965", ",", "0.961", ",", "0.96", ",", "0.957", ",", "0.952", ",",
            "0.946", ",", "0.942", ",", "0.937", ",", "0.933", ",", "0.929", ",",
            "0.921", ",", "0.914", ",", "0.908", ",", "0.906", ",", "0.902", ",",
            "0.896", ",", "0.891", ",", "0.886", ",", "0.882", ",", "0.878", ",",
            "0.874", ",", "0.866", ",", "0.859", ",", "0.856", ",", "0.853", ",",
            "0.847", ",", "0.844", ",", "0.841", ",", "0.836", ",", "0.831", ",",
            "0.829", ",", "0.827", ",", "0.823", ",", "0.818", ",", "0.815", ",",
            "0.811", ",", "0.81", ",", "0.804", ",", "0.794", ",", "0.783", ",",
            "0.759", ",", "0.737", ",", "0.717", ",", "0.71", ",", "0.698", ",",
            "0.68", ",", "0.664", ",", "0.648", ",", "0.634", ",", "0.62", ",",
            "0.607", ",", "0.583", ",", "0.561", ",", "0.541", ",", "0.522", ",",
            "0.504", ",", "0.488", ",", "0.472", ",", "0.458", ",", "0.444", ",",
            "0.431", ",", "0.407", ",", "0.385", ",", "0.374", ",", "0.364", ",",
            "0.346", ",", "0.328", ",", "0.312", ",", "0.296", ",", "0.289", ",",
            "0.282", ",", "0.268", ",", "0.255", ",", "0.243", ",", "0.231", ",",
            "0.22", ",", "0.209", ",", "0.2", ",", "0.2", ",", "0.2", ",", 
           "0.2", ",", "0.2", ",", "0.2", ",", "0.2", ",", "0.2", ",", "0.2", 
           ",", "0.2", ",", "0.2"}], "}"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"n", "=", "1.18"}], ";", "\[IndentingNewLine]", 
        RowBox[{"c", "=", "1.88"}], ";", "\[IndentingNewLine]", 
        RowBox[{"sigamp", "=", "0.3"}], ";", "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{"PGA", ",", 
          RowBox[{"PGV", " ", "or", " ", "PGD"}]}], "*)"}], 
        RowBox[{"Which", "[", 
         RowBox[{
          RowBox[{"per", ">=", "0.01"}], ",", 
          RowBox[{
           RowBox[{"pos", "=", "0"}], ";"}], ",", 
          RowBox[{"(*", "PSA", "*)"}], 
          RowBox[{"0.", "<=", "per", "<", "0.01"}], ",", 
          RowBox[{
           RowBox[{"pos", "=", "1"}], ";"}], ",", 
          RowBox[{"(*", "PGA", "*)"}], 
          RowBox[{
           RowBox[{"-", "1."}], "<=", "per", "<", "0."}], ",", 
          RowBox[{
           RowBox[{"pos", "=", "2"}], ";"}], ",", 
          RowBox[{"(*", "PGV", "*)"}], 
          RowBox[{"per", "<", 
           RowBox[{"-", "1."}]}], ",", 
          RowBox[{
           RowBox[{"pos", "=", "3"}], ";"}]}], " ", 
         RowBox[{"(*", "PGD", "*)"}], "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"SetOptions", "[", 
         RowBox[{"InterpolateCoefficientList", ",", 
          RowBox[{"IpolHalfWindowLength", "->", "ilenALL"}], ",", 
          RowBox[{"IpolOrder", "->", "ipolorderALL"}], ",", 
          RowBox[{"IpolType", "->", "ipolTypeAll"}]}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"per", "<", "0.01"}], ",", 
          RowBox[{"(*", 
           RowBox[{"PGA", ",", 
            RowBox[{"PGV", " ", "or", " ", "PGD"}]}], "*)"}], 
          RowBox[{
           RowBox[{"a1", "=", 
            RowBox[{"a1list", "[", 
             RowBox[{"[", "pos", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"a2", "=", 
            RowBox[{"a2list", "[", 
             RowBox[{"[", "pos", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"a3", "=", 
            RowBox[{"a3list", "[", 
             RowBox[{"[", "pos", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"a4", "=", 
            RowBox[{"a4list", "[", 
             RowBox[{"[", "pos", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"a5", "=", 
            RowBox[{"a5list", "[", 
             RowBox[{"[", "pos", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"a6", "=", 
            RowBox[{"a6list", "[", 
             RowBox[{"[", "pos", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"a7", "=", 
            RowBox[{"a7list", "[", 
             RowBox[{"[", "pos", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"a8", "=", 
            RowBox[{"a8list", "[", 
             RowBox[{"[", "pos", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"a9", "=", 
            RowBox[{"a9list", "[", 
             RowBox[{"[", "pos", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"a10", "=", 
            RowBox[{"a10list", "[", 
             RowBox[{"[", "pos", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"a11", "=", 
            RowBox[{"a11list", "[", 
             RowBox[{"[", "pos", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"a12", "=", 
            RowBox[{"a12list", "[", 
             RowBox[{"[", "pos", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"a13", "=", 
            RowBox[{"a13list", "[", 
             RowBox[{"[", "pos", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"a14", "=", 
            RowBox[{"a14list", "[", 
             RowBox[{"[", "pos", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"a15", "=", 
            RowBox[{"a15list", "[", 
             RowBox[{"[", "pos", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"a16", "=", 
            RowBox[{"a16list", "[", 
             RowBox[{"[", "pos", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"a17", "=", 
            RowBox[{"a17list", "[", 
             RowBox[{"[", "pos", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"a18", "=", 
            RowBox[{"a18list", "[", 
             RowBox[{"[", "pos", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"c4", "=", 
            RowBox[{"c4list", "[", 
             RowBox[{"[", "pos", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"bsoil", "=", 
            RowBox[{"bsoillist", "[", 
             RowBox[{"[", "pos", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"vlin", "=", 
            RowBox[{"vlinlist", "[", 
             RowBox[{"[", "pos", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"Which", "[", 
            RowBox[{
             RowBox[{"vs30class", "==", "\"\<ESTIMATED\>\""}], ",", 
             RowBox[{
              RowBox[{"s1", "=", 
               RowBox[{"s1elist", "[", 
                RowBox[{"[", "pos", "]"}], "]"}]}], ";", 
              "\[IndentingNewLine]", 
              RowBox[{"s2", "=", 
               RowBox[{"s2elist", "[", 
                RowBox[{"[", "pos", "]"}], "]"}]}], ";"}], ",", 
             RowBox[{"vs30class", "==", "\"\<MEASURED\>\""}], ",", 
             RowBox[{
              RowBox[{"s1", "=", 
               RowBox[{"s1mlist", "[", 
                RowBox[{"[", "pos", "]"}], "]"}]}], ";", 
              "\[IndentingNewLine]", 
              RowBox[{"s2", "=", 
               RowBox[{"s2mlist", "[", 
                RowBox[{"[", "pos", "]"}], "]"}]}], ";"}]}], "]"}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"s3", "=", 
            RowBox[{"s3list", "[", 
             RowBox[{"[", "pos", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"s4", "=", 
            RowBox[{"s4list", "[", 
             RowBox[{"[", "pos", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"sigcorr", "=", 
            RowBox[{"sigcorrlist", "[", 
             RowBox[{"[", "pos", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"taucorr", "=", 
            RowBox[{"taucorrlist", "[", 
             RowBox[{"[", "pos", "]"}], "]"}]}], ";"}], ",", 
          RowBox[{"(*", 
           RowBox[{"else", " ", "PSA"}], "*)"}], 
          RowBox[{
           RowBox[{"a1", "=", 
            RowBox[{"InterpolateCoefficientList", "[", 
             RowBox[{"per", ",", "periodlist", ",", "a1list"}], "]"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"a2", "=", 
            RowBox[{"InterpolateCoefficientList", "[", 
             RowBox[{"per", ",", "periodlist", ",", "a2list"}], "]"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"a3", "=", 
            RowBox[{"InterpolateCoefficientList", "[", 
             RowBox[{"per", ",", "periodlist", ",", "a3list"}], "]"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"a4", "=", 
            RowBox[{"InterpolateCoefficientList", "[", 
             RowBox[{"per", ",", "periodlist", ",", "a4list"}], "]"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"a5", "=", 
            RowBox[{"InterpolateCoefficientList", "[", 
             RowBox[{"per", ",", "periodlist", ",", "a5list"}], "]"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"a6", "=", 
            RowBox[{"InterpolateCoefficientList", "[", 
             RowBox[{"per", ",", "periodlist", ",", "a6list"}], "]"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"a7", "=", 
            RowBox[{"InterpolateCoefficientList", "[", 
             RowBox[{"per", ",", "periodlist", ",", "a7list"}], "]"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"a8", "=", 
            RowBox[{"InterpolateCoefficientList", "[", 
             RowBox[{"per", ",", "periodlist", ",", "a8list"}], "]"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"a9", "=", 
            RowBox[{"InterpolateCoefficientList", "[", 
             RowBox[{"per", ",", "periodlist", ",", "a9list"}], "]"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"a10", "=", 
            RowBox[{"InterpolateCoefficientList", "[", 
             RowBox[{"per", ",", "periodlist", ",", "a10list"}], "]"}]}], ";",
            "\[IndentingNewLine]", 
           RowBox[{"a11", "=", 
            RowBox[{"InterpolateCoefficientList", "[", 
             RowBox[{"per", ",", "periodlist", ",", "a11list"}], "]"}]}], ";",
            "\[IndentingNewLine]", 
           RowBox[{"a12", "=", 
            RowBox[{"InterpolateCoefficientList", "[", 
             RowBox[{"per", ",", "periodlist", ",", "a12list"}], "]"}]}], ";",
            "\[IndentingNewLine]", 
           RowBox[{"a13", "=", 
            RowBox[{"InterpolateCoefficientList", "[", 
             RowBox[{"per", ",", "periodlist", ",", "a13list"}], "]"}]}], ";",
            "\[IndentingNewLine]", 
           RowBox[{"a14", "=", 
            RowBox[{"InterpolateCoefficientList", "[", 
             RowBox[{"per", ",", "periodlist", ",", "a14list"}], "]"}]}], ";",
            "\[IndentingNewLine]", 
           RowBox[{"a15", "=", 
            RowBox[{"InterpolateCoefficientList", "[", 
             RowBox[{"per", ",", "periodlist", ",", "a15list"}], "]"}]}], ";",
            "\[IndentingNewLine]", 
           RowBox[{"a16", "=", 
            RowBox[{"InterpolateCoefficientList", "[", 
             RowBox[{"per", ",", "periodlist", ",", "a16list"}], "]"}]}], ";",
            "\[IndentingNewLine]", 
           RowBox[{"a17", "=", 
            RowBox[{"InterpolateCoefficientList", "[", 
             RowBox[{"per", ",", "periodlist", ",", "a17list"}], "]"}]}], ";",
            "\[IndentingNewLine]", 
           RowBox[{"a18", "=", 
            RowBox[{"InterpolateCoefficientList", "[", 
             RowBox[{"per", ",", "periodlist", ",", "a18list"}], "]"}]}], ";",
            "\[IndentingNewLine]", 
           RowBox[{"c4", "=", 
            RowBox[{"InterpolateCoefficientList", "[", 
             RowBox[{"per", ",", "periodlist", ",", "c4list"}], "]"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"bsoil", "=", 
            RowBox[{"InterpolateCoefficientList", "[", 
             RowBox[{"per", ",", "periodlist", ",", "bsoillist"}], "]"}]}], ";",
            "\[IndentingNewLine]", 
           RowBox[{"vlin", "=", 
            RowBox[{"InterpolateCoefficientList", "[", 
             RowBox[{"per", ",", "periodlist", ",", "vlinlist"}], "]"}]}], ";",
            "\[IndentingNewLine]", 
           RowBox[{"Which", "[", 
            RowBox[{
             RowBox[{"vs30class", "==", "\"\<ESTIMATED\>\""}], ",", 
             RowBox[{
              RowBox[{"s1", "=", 
               RowBox[{"InterpolateCoefficientList", "[", 
                RowBox[{"per", ",", "periodlist", ",", "s1elist"}], "]"}]}], ";",
               "\[IndentingNewLine]", 
              RowBox[{"s2", "=", 
               RowBox[{"InterpolateCoefficientList", "[", 
                RowBox[{"per", ",", "periodlist", ",", "s2elist"}], "]"}]}], 
              ";"}], ",", 
             RowBox[{"vs30class", "==", "\"\<MEASURED\>\""}], ",", 
             RowBox[{
              RowBox[{"s1", "=", 
               RowBox[{"InterpolateCoefficientList", "[", 
                RowBox[{"per", ",", "periodlist", ",", "s1mlist"}], "]"}]}], ";",
               "\[IndentingNewLine]", 
              RowBox[{"s2", "=", 
               RowBox[{"InterpolateCoefficientList", "[", 
                RowBox[{"per", ",", "periodlist", ",", "s2mlist"}], "]"}]}], 
              ";"}]}], "]"}], ";", "\[IndentingNewLine]", 
           RowBox[{"s3", "=", 
            RowBox[{"InterpolateCoefficientList", "[", 
             RowBox[{"per", ",", "periodlist", ",", "s3list"}], "]"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"s4", "=", 
            RowBox[{"InterpolateCoefficientList", "[", 
             RowBox[{"per", ",", "periodlist", ",", "s4list"}], "]"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"sigcorr", "=", 
            RowBox[{"InterpolateCoefficientList", "[", 
             RowBox[{"per", ",", "periodlist", ",", "sigcorrlist"}], "]"}]}], 
           ";", "\[IndentingNewLine]", 
           RowBox[{"taucorr", "=", 
            RowBox[{"InterpolateCoefficientList", "[", 
             RowBox[{"per", ",", "periodlist", ",", "taucorrlist"}], "]"}]}], 
           ";"}]}], "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"c1", "=", "6.75"}], ";", "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{"set", " ", "distance", " ", 
          RowBox[{"(", 
           RowBox[{"eq", " ", 
            RowBox[{"(", "3", ")"}]}], ")"}]}], "*)"}], 
        RowBox[{"r", "=", 
         RowBox[{"Sqrt", "[", 
          RowBox[{
           RowBox[{"rrup", "^", "2"}], "+", 
           RowBox[{"c4", "^", "2"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{
         "compute", " ", "rx", " ", "value", " ", "given", " ", "source", " ",
           "to", " ", "site", " ", "azimuth"}], "*)"}], 
        RowBox[{"Which", "[", 
         RowBox[{
          RowBox[{"srcsitea", "==", "90."}], ",", 
          RowBox[{
           RowBox[{"rx", "=", 
            RowBox[{
             RowBox[{"rrup", "/", 
              RowBox[{"Sin", "[", 
               RowBox[{"delta", " ", 
                RowBox[{"N", "@", "Degree"}]}], "]"}]}], "-", 
             RowBox[{"ztor", "/", 
              RowBox[{"Tan", "[", 
               RowBox[{"delta", " ", 
                RowBox[{"N", "@", "Degree"}]}], "]"}]}]}]}], ";"}], ",", 
          RowBox[{"srcsitea", ">", "0."}], ",", 
          RowBox[{
           RowBox[{"rx", "=", 
            RowBox[{"rjb", " ", 
             RowBox[{"Tan", "[", 
              RowBox[{"srcsitea", " ", 
               RowBox[{"N", "@", "Degree"}]}], "]"}]}]}], ";"}], ",", 
          RowBox[{"srcsitea", "<=", "0."}], ",", 
          RowBox[{
           RowBox[{"rx", "=", "0."}], ";"}]}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{"set", " ", "taper", " ", "models", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"eq", ".", "8"}], "-", "12"}], ")"}]}], "*)"}], 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"rjb", ">=", "30."}], ",", 
          RowBox[{
           RowBox[{"taper1", "=", "0."}], ";"}], ",", 
          RowBox[{
           RowBox[{"taper1", "=", 
            RowBox[{"1", "-", 
             RowBox[{"rjb", "/", "30."}]}]}], ";"}]}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"delta", "==", "90."}], "||", 
           RowBox[{"rx", ">", 
            RowBox[{"ddrw", " ", 
             RowBox[{"Cos", "[", 
              RowBox[{"delta", " ", 
               RowBox[{"N", "@", "Degree"}]}], "]"}]}]}]}], ",", 
          RowBox[{
           RowBox[{"taper2", "=", "1."}], ";"}], ",", 
          RowBox[{
           RowBox[{"taper2", "=", 
            RowBox[{"0.5", "+", 
             RowBox[{"rx", "/", 
              RowBox[{"(", 
               RowBox[{"2.", " ", "ddrw", " ", 
                RowBox[{"Cos", "[", 
                 RowBox[{"delta", " ", 
                  RowBox[{"N", "@", "Degree"}]}], "]"}]}], ")"}]}]}]}], 
           ";"}]}], "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"rx", ">=", "ztor"}], ",", 
          RowBox[{
           RowBox[{"taper3", "=", "1."}], ";"}], ",", 
          RowBox[{
           RowBox[{"taper3", "=", 
            RowBox[{"rx", "/", "ztor"}]}], ";"}]}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"Which", "[", 
         RowBox[{
          RowBox[{"mw", ">=", "7."}], ",", 
          RowBox[{
           RowBox[{"taper4", "=", "1."}], ";"}], ",", 
          RowBox[{"6.", "<", "mw", "<", "7."}], ",", 
          RowBox[{
           RowBox[{"taper4", "=", 
            RowBox[{"mw", "-", "6."}]}], ";"}], ",", 
          RowBox[{"mw", "<=", "6."}], ",", 
          RowBox[{
           RowBox[{"taper4", "=", "0."}], ";"}]}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{"changed", " ", "due", " ", "to", " ", "erratum"}], "*)"}], 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"delta", "<", "30"}], ",", 
          RowBox[{
           RowBox[{"taper5", "=", "1."}], ";"}], ",", 
          RowBox[{
           RowBox[{"taper5", "=", 
            RowBox[{"1", "-", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"delta", "-", "30"}], ")"}], "/", "60."}]}]}], ";"}]}],
          "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{"base", " ", "model", " ", 
          RowBox[{"(", 
           RowBox[{"eq", " ", 
            RowBox[{"(", "2", ")"}]}], ")"}]}], "*)"}], 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"mw", "<=", "c1"}], ",", 
          RowBox[{
           RowBox[{"f1", "=", 
            RowBox[{"a1", "+", 
             RowBox[{"a4", "*", 
              RowBox[{"(", 
               RowBox[{"mw", "-", "c1"}], ")"}]}], "+", 
             RowBox[{"a8", "*", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"8.5", "-", "mw"}], ")"}], "^", "2"}]}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"a2", "+", 
                RowBox[{"a3", "*", 
                 RowBox[{"(", 
                  RowBox[{"mw", "-", "c1"}], ")"}]}]}], ")"}], " ", 
              RowBox[{"Log", "[", "r", "]"}]}]}]}], ";"}], ",", 
          RowBox[{
           RowBox[{"f1", "=", 
            RowBox[{"a1", "+", 
             RowBox[{"a5", "*", 
              RowBox[{"(", 
               RowBox[{"mw", "-", "c1"}], ")"}]}], "+", 
             RowBox[{"a8", "*", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"8.5", "-", "mw"}], ")"}], "^", "2"}]}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"a2", "+", 
                RowBox[{"a3", "*", 
                 RowBox[{"(", 
                  RowBox[{"mw", "-", "c1"}], ")"}]}]}], ")"}], " ", 
              RowBox[{"Log", "[", "r", "]"}]}]}]}], ";"}]}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{"style", " ", "of", " ", "faulting"}], "*)"}], 
        RowBox[{"f1", "=", 
         RowBox[{"f1", "+", 
          RowBox[{"a12", " ", "frv"}], "+", 
          RowBox[{"a13", " ", "fn"}]}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{"**", 
          RowBox[{"*", "site", " ", "response"}]}], "****)"}], 
        RowBox[{"(*", 
         RowBox[{
         "set", " ", "velocity", " ", "for", " ", "break", " ", "in", " ", 
          "slope", " ", 
          RowBox[{"(", 
           RowBox[{"eq", " ", "6"}], ")"}]}], "*)"}], 
        RowBox[{"Which", "[", 
         RowBox[{
          RowBox[{"per", "<", 
           RowBox[{"-", "1."}]}], ",", 
          RowBox[{
           RowBox[{"v1", "=", "700."}], ";"}], ",", 
          RowBox[{"(*", "PGD", "*)"}], 
          RowBox[{
           RowBox[{"-", "1."}], "<=", "per", "<", "0."}], ",", 
          RowBox[{
           RowBox[{"v1", "=", "862."}], ";"}], ",", 
          RowBox[{"(*", "PGV", "*)"}], 
          RowBox[{"per", ">=", "2."}], ",", 
          RowBox[{
           RowBox[{"v1", "=", "700."}], ";"}], ",", 
          RowBox[{"1.", "<", "per", "<", "2."}], ",", 
          RowBox[{
           RowBox[{"v1", "=", 
            RowBox[{"Exp", "[", 
             RowBox[{"6.76", "-", 
              RowBox[{"0.297", " ", 
               RowBox[{"Log", "[", "per", "]"}]}]}], "]"}]}], ";"}], ",", 
          RowBox[{"0.5", "<", "per", "<=", "1."}], ",", 
          RowBox[{
           RowBox[{"v1", "=", 
            RowBox[{"Exp", "[", 
             RowBox[{"8.", "-", 
              RowBox[{"0.795", " ", 
               RowBox[{"Log", "[", 
                RowBox[{"per", "/", "0.21"}], "]"}]}]}], "]"}]}], ";"}], ",", 
          
          RowBox[{"0.", "<=", "per", "<=", "0.5"}], ",", 
          RowBox[{
           RowBox[{"v1", "=", "1500"}], ";"}]}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{"set", " ", "vs30", "*", 
          RowBox[{"(", 
           RowBox[{"eq", " ", "5"}], ")"}]}], "*)"}], 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"vs30", "<", "v1"}], ",", 
          RowBox[{
           RowBox[{"vsstar", "=", "vs30"}], ";"}], ",", 
          RowBox[{
           RowBox[{"vsstar", "=", "v1"}], ";"}]}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{"compute", " ", "site", " ", "amplification", " ", 
          RowBox[{"(", 
           RowBox[{"eq", " ", "4"}], ")"}]}], "*)"}], 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"vs30", "<", "vlin"}], ",", 
          RowBox[{
           RowBox[{"soilamp", "=", 
            RowBox[{
             RowBox[{"a10", " ", 
              RowBox[{"Log", "[", 
               RowBox[{"vsstar", "/", "vlin"}], "]"}]}], "-", 
             RowBox[{"bsoil", " ", 
              RowBox[{"Log", "[", 
               RowBox[{"c", "+", "pgarock"}], "]"}]}], "+", 
             RowBox[{"bsoil", " ", 
              RowBox[{"Log", "[", 
               RowBox[{"pgarock", "+", 
                RowBox[{"c", " ", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"vsstar", "/", "vlin"}], ")"}], "^", "n"}]}]}], 
               "]"}]}]}]}], ";"}], ",", 
          RowBox[{
           RowBox[{"soilamp", "=", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"a10", "+", 
               RowBox[{"bsoil", " ", "n"}]}], ")"}], " ", 
             RowBox[{"Log", "[", 
              RowBox[{"vsstar", "/", "vlin"}], "]"}]}]}], ";"}]}], "]"}], ";",
         "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{
          RowBox[{"**", "soil"}], " ", "depth", " ", "model"}], "***)"}], 
        RowBox[{"(*", 
         RowBox[{"eq", " ", "17"}], "*)"}], 
        RowBox[{"Which", "[", 
         RowBox[{
          RowBox[{"vs30", "<", "180."}], ",", 
          RowBox[{
           RowBox[{"zhat", "=", 
            RowBox[{"Exp", "[", "6.745", "]"}]}], ";"}], ",", 
          RowBox[{"180.", "<=", "vs30", "<=", "500."}], ",", 
          RowBox[{
           RowBox[{"zhat", "=", 
            RowBox[{"Exp", "[", 
             RowBox[{"6.745", "-", 
              RowBox[{"1.35", " ", 
               RowBox[{"Log", "[", 
                RowBox[{"vs30", "/", "180."}], "]"}]}]}], "]"}]}], ";"}], ",", 
          RowBox[{"vs30", ">", "500."}], ",", 
          RowBox[{
           RowBox[{"zhat", "=", 
            RowBox[{"Exp", "[", 
             RowBox[{"5.394", "-", 
              RowBox[{"4.48", " ", 
               RowBox[{"Log", "[", 
                RowBox[{"vs30", "/", "500."}], "]"}]}]}], "]"}]}], ";"}]}], 
         "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{"eq", " ", "19"}], "*)"}], 
        RowBox[{"Which", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"vs30", ">", "1000."}], "||", 
           RowBox[{"per", "<", "0.35"}]}], ",", 
          RowBox[{
           RowBox[{"e2", "=", "0."}], ";"}], ",", 
          RowBox[{"0.35", "<=", "per", "<=", "2."}], ",", 
          RowBox[{
           RowBox[{"e2", "=", 
            RowBox[{
             RowBox[{"-", "0.25"}], " ", 
             RowBox[{"Log", "[", 
              RowBox[{"vs30", "/", "1000"}], "]"}], " ", 
             RowBox[{"Log", "[", 
              RowBox[{"per", "/", "0.35"}], "]"}]}]}], ";"}], ",", 
          RowBox[{"per", ">", "2."}], ",", 
          RowBox[{
           RowBox[{"e2", "=", 
            RowBox[{
             RowBox[{"-", "0.25"}], " ", 
             RowBox[{"Log", "[", 
              RowBox[{"vs30", "/", "1000."}], "]"}], " ", 
             RowBox[{"Log", "[", 
              RowBox[{"2.", "/", "0.35"}], "]"}]}]}], ";"}]}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{"eq", " ", "20"}], "*)"}], 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"per", ">=", "2."}], ",", 
          RowBox[{
           RowBox[{"a22", "=", 
            RowBox[{"0.0625", " ", 
             RowBox[{"(", 
              RowBox[{"per", "-", "2."}], ")"}]}]}], ";"}], ",", 
          RowBox[{
           RowBox[{"a22", "=", "0."}], ";"}]}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{"test", " ", "value", " ", "for", " ", "eq", " ", "18"}], 
         "*)"}], 
        RowBox[{"c2", "=", "50."}], ";", "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"v1", "<", "1000."}], ",", 
          RowBox[{
           RowBox[{"testv1", "=", "v1"}], ";"}], ",", 
          RowBox[{
           RowBox[{"testv1", "=", "1000."}], ";"}]}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"basin", ">", "0."}], ",", 
          RowBox[{
           RowBox[{"test", "=", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{"a10", "+", 
                RowBox[{"bsoil", " ", "n"}]}], ")"}], " ", 
              RowBox[{"Log", "[", 
               RowBox[{"vsstar", "/", "testv1"}], "]"}]}], "+", 
             RowBox[{"e2", " ", 
              RowBox[{"Log", "[", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"basin", " ", "1000."}], "+", "c2"}], ")"}], "/", 
                RowBox[{"(", 
                 RowBox[{"zhat", "+", "c2"}], ")"}]}], "]"}]}]}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"(*", 
            RowBox[{"eq", " ", "18"}], "*)"}], 
           RowBox[{"Which", "[", 
            RowBox[{
             RowBox[{"vs30", ">=", "1000."}], ",", 
             RowBox[{
              RowBox[{"a21", "=", "0."}], ";"}], ",", 
             RowBox[{"test", "<", "0."}], ",", 
             RowBox[{
              RowBox[{"a21", "=", 
               RowBox[{
                RowBox[{"-", "1."}], " ", 
                RowBox[{"(", 
                 RowBox[{"a10", "+", 
                  RowBox[{"bsoil", " ", "n"}]}], ")"}], " ", 
                RowBox[{
                 RowBox[{"Log", "[", 
                  RowBox[{"vsstar", "/", "testv1"}], "]"}], "/", 
                 RowBox[{"Log", "[", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"basin", " ", "1000."}], "+", "c2"}], ")"}], "/", 
                   
                   RowBox[{"(", 
                    RowBox[{"zhat", "+", "c2"}], ")"}]}], "]"}]}]}]}], ";"}], 
             ",", "True", ",", 
             RowBox[{
              RowBox[{"a21", "=", "e2"}], ";"}]}], "]"}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"(*", 
            RowBox[{"eq", " ", "16"}], "*)"}], 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"basin", " ", "1000."}], ">=", "200."}], ",", 
             RowBox[{
              RowBox[{"f10", "=", 
               RowBox[{
                RowBox[{"a21", " ", 
                 RowBox[{"Log", "[", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"basin", " ", "1000."}], "+", "c2"}], ")"}], "/", 
                   
                   RowBox[{"(", 
                    RowBox[{"zhat", "+", "c2"}], ")"}]}], "]"}]}], "+", 
                RowBox[{"a22", " ", 
                 RowBox[{"Log", "[", 
                  RowBox[{"basin", " ", 
                   RowBox[{"1000.", "/", "200."}]}], "]"}]}]}]}], ";"}], ",", 
             
             RowBox[{
              RowBox[{"f10", "=", 
               RowBox[{"a21", " ", 
                RowBox[{"Log", "[", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"basin", " ", "1000."}], "+", "c2"}], ")"}], "/", 
                  
                  RowBox[{"(", 
                   RowBox[{"zhat", "+", "c2"}], ")"}]}], "]"}]}]}], ";"}]}], 
            "]"}], ";"}], ",", 
          RowBox[{"(*", 
           RowBox[{
           "set", " ", "f10", " ", "to", " ", "zero", " ", "if", " ", "the", " ",
             "soil", " ", "depth", " ", "is", " ", "below", " ", "zero"}], 
           "*)"}], 
          RowBox[{
           RowBox[{"f10", "=", "0"}], ";"}]}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{
          RowBox[{"**", "**", "hanging"}], " ", "wall", " ", "model", " ", 
          RowBox[{"(", 
           RowBox[{"eq", " ", "7"}], ")"}]}], "*****)"}], 
        RowBox[{"If", "[", 
         RowBox[{"hw", ",", 
          RowBox[{
           RowBox[{"f4", "=", 
            RowBox[{
            "a14", " ", "taper1", " ", "taper2", " ", "taper3", " ", "taper4",
              " ", "taper5"}]}], ";"}], ",", 
          RowBox[{
           RowBox[{"f4", "=", "0."}], ";"}]}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{
          RowBox[{"**", "**", "depth"}], "-", "to", "-", "top", "-", "of", "-", 
          RowBox[{"rupture", " ", "model"}]}], "*****)"}], 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"ztor", "<", "10."}], ",", 
          RowBox[{
           RowBox[{"f6", "=", 
            RowBox[{"a16", " ", 
             RowBox[{"ztor", "/", "10."}]}]}], ";"}], ",", 
          RowBox[{
           RowBox[{"f6", "=", "a16"}], ";"}]}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{
          RowBox[{"**", "**", "large"}], " ", "distance", " ", "model"}], 
         "*****)"}], 
        RowBox[{"Which", "[", 
         RowBox[{
          RowBox[{"mw", "<", "5.5"}], ",", 
          RowBox[{
           RowBox[{"t6", "=", "1"}], ";"}], ",", 
          RowBox[{"5.5", "<=", "mw", "<=", "6.5"}], ",", 
          RowBox[{
           RowBox[{"t6", "=", 
            RowBox[{
             RowBox[{"0.5", " ", 
              RowBox[{"(", 
               RowBox[{"6.5", "-", "mw"}], ")"}]}], "+", "0.5"}]}], ";"}], ",", 
          RowBox[{"(*", 
           RowBox[{
            RowBox[{
            "here", " ", "the", " ", "fortran", " ", "code", " ", "and", " ", 
             "the", " ", "paper", " ", "differ"}], "-", 
            RowBox[{
            "I", " ", "use", " ", "the", " ", "version", " ", "of", " ", 
             "paper", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"N", ".", "Abrahamsons"}], " ", "mail", " ", "says", " ",
                "in", " ", "his", " ", "mail", " ", "from", " ", "4.12", 
               ".08", " ", "that", " ", "the", " ", "paper", " ", "is", " ", 
               "correct"}], ")"}]}]}], "*)"}], 
          RowBox[{"6.5", "<", "mw"}], ",", 
          RowBox[{
           RowBox[{"t6", "=", "0.5"}], ";"}]}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"rrup", "<", "100."}], ",", 
          RowBox[{
           RowBox[{"f8", "=", "0."}], ";"}], ",", 
          RowBox[{
           RowBox[{"f8", "=", 
            RowBox[{"a18", " ", 
             RowBox[{"(", 
              RowBox[{"rrup", "-", "100."}], ")"}], " ", "t6"}]}], ";"}]}], 
         "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{"putting", " ", "it", " ", "all", " ", "together"}], "*)"}], 
        
        RowBox[{"lny", "=", 
         RowBox[{
         "soilamp", "+", "f1", "+", "f4", "+", "f6", "+", "f8", "+", 
          "f10"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{
          RowBox[{"**", "**", "**"}], "*", "set", " ", "the", " ", "sigma", " ",
           "values"}], "******)"}], 
        RowBox[{"(*", 
         RowBox[{"partial", " ", "derivative", " ", "of", " ", "log", 
          RowBox[{"(", "soil", ")"}], " ", "wrt", " ", "log", 
          RowBox[{"(", "rockpga", ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"eq", " ", "26"}], ")"}]}], "*)"}], 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"vsstar", ">=", "vlin"}], ",", 
          RowBox[{
           RowBox[{"dampdpga", "=", "0."}], ";"}], ",", 
          RowBox[{
           RowBox[{"dampdpga", "=", 
            RowBox[{"bsoil", " ", "pgarock", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "1."}], "/", 
                RowBox[{"(", 
                 RowBox[{"pgarock", "+", "c"}], ")"}]}], "+", 
               RowBox[{"1.", "/", 
                RowBox[{"(", 
                 RowBox[{"pgarock", "+", 
                  RowBox[{"c", " ", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"vsstar", "/", "vlin"}], ")"}], "^", "n"}]}]}], 
                 ")"}]}]}], ")"}]}]}], ";"}]}], " ", 
         RowBox[{"(*", 
          RowBox[{
           RowBox[{
            RowBox[{
            "the", " ", "fortran", " ", "code", " ", "and", " ", "the", " ", 
             "paper", " ", "differ"}], "-", 
            RowBox[{
            "in", " ", "the", " ", "fortran", " ", "code", " ", "vsstar", " ",
              "is", " ", "used"}]}], ",", 
           RowBox[{
            RowBox[{"in", " ", "the", " ", "paper", " ", "vs30"}], ";", 
            RowBox[{
            "I", " ", "use", " ", "the", " ", "version", " ", "of", " ", 
             "the", " ", "fortran", " ", "code", " ", 
             RowBox[{"(", 
              RowBox[{
              "this", " ", "is", " ", "correct", " ", "as", " ", "of", " ", 
               RowBox[{"N", ".", "Abrahamsons"}], " ", "mail"}], ")"}]}]}]}], 
          "*)"}], "\[IndentingNewLine]", 
         RowBox[{"(*", 
          RowBox[{
           RowBox[{"dampdpga", "=", 
            RowBox[{"bsoil", " ", "pgarock", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "1."}], "/", 
                RowBox[{"(", 
                 RowBox[{"pgarock", "+", "c"}], ")"}]}], "+", 
               RowBox[{"1.", "/", 
                RowBox[{"(", 
                 RowBox[{"pgarock", "+", 
                  RowBox[{"c", " ", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"vsstar", "/", "vlin"}], ")"}], "^", "n"}]}]}], 
                 ")"}]}]}], ")"}]}]}], ";"}], "*)"}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{"eq", " ", "27", " ", "and", " ", "28"}], "*)"}], 
        RowBox[{"Which", "[", 
         RowBox[{
          RowBox[{"mw", "<", "5."}], ",", 
          RowBox[{
           RowBox[{"sigmanot", "=", "s1"}], ";", "\[IndentingNewLine]", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"vs30class", "==", "\"\<ESTIMATED\>\""}], ",", 
             RowBox[{
              RowBox[{"sigmanotpga", "=", 
               RowBox[{"s1elist", "[", 
                RowBox[{"[", "1", "]"}], "]"}]}], ";"}], ",", 
             RowBox[{
              RowBox[{"sigmanotpga", "=", 
               RowBox[{"s1mlist", "[", 
                RowBox[{"[", "1", "]"}], "]"}]}], ";"}]}], "]"}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"taunot", "=", "s3"}], ";", "\[IndentingNewLine]", 
           RowBox[{"taunotpga", "=", 
            RowBox[{"s3list", "[", 
             RowBox[{"[", "1", "]"}], "]"}]}], ";"}], ",", 
          RowBox[{"5.", "<=", "mw", "<=", "7."}], ",", 
          RowBox[{
           RowBox[{"sigmanot", "=", 
            RowBox[{"s1", "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"s2", "-", "s1"}], ")"}], "/", "2."}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{"mw", "-", "5."}], ")"}]}]}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"vs30class", "==", "\"\<ESTIMATED\>\""}], ",", 
             RowBox[{
              RowBox[{"sigmanotpga", "=", 
               RowBox[{
                RowBox[{"s1elist", "[", 
                 RowBox[{"[", "1", "]"}], "]"}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"s2elist", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "-", 
                    RowBox[{"s1elist", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], ")"}], "/", "2."}], 
                  ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"mw", "-", "5."}], ")"}]}]}]}], ";"}], ",", 
             RowBox[{
              RowBox[{"sigmanotpga", "=", 
               RowBox[{
                RowBox[{"s1mlist", "[", 
                 RowBox[{"[", "1", "]"}], "]"}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"s2mlist", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "-", 
                    RowBox[{"s1mlist", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], ")"}], "/", "2."}], 
                  ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"mw", "-", "5."}], ")"}]}]}]}], ";"}]}], "]"}], ";",
            "\[IndentingNewLine]", 
           RowBox[{"taunot", "=", 
            RowBox[{"s3", "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"s4", "-", "s3"}], ")"}], "/", "2."}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{"mw", "-", "5."}], ")"}]}]}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"taunotpga", "=", 
            RowBox[{
             RowBox[{"s3list", "[", 
              RowBox[{"[", "1", "]"}], "]"}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"s4list", "[", 
                   RowBox[{"[", "1", "]"}], "]"}], "-", 
                  RowBox[{"s3list", "[", 
                   RowBox[{"[", "1", "]"}], "]"}]}], ")"}], "/", "2."}], 
               ")"}], " ", 
              RowBox[{"(", 
               RowBox[{"mw", "-", "5."}], ")"}]}]}]}], ";"}], ",", 
          RowBox[{"mw", ">", "7."}], ",", 
          RowBox[{
           RowBox[{"sigmanot", "=", "s2"}], ";", "\[IndentingNewLine]", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"vs30class", "==", "\"\<ESTIMATED\>\""}], ",", 
             RowBox[{
              RowBox[{"sigmanotpga", "=", 
               RowBox[{"s2elist", "[", 
                RowBox[{"[", "1", "]"}], "]"}]}], ";"}], ",", 
             RowBox[{
              RowBox[{"sigmanotpga", "=", 
               RowBox[{"s2mlist", "[", 
                RowBox[{"[", "1", "]"}], "]"}]}], ";"}]}], "]"}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"taunot", "=", "s4"}], ";", "\[IndentingNewLine]", 
           RowBox[{"taunotpga", "=", 
            RowBox[{"s4list", "[", 
             RowBox[{"[", "1", "]"}], "]"}]}], ";"}]}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{"eq", " ", "23"}], "*)"}], 
        RowBox[{"sigmab", "=", 
         RowBox[{"Sqrt", "[", 
          RowBox[{
           RowBox[{"sigmanot", "^", "2"}], "-", 
           RowBox[{"sigamp", "^", "2"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"sigmabpga", "=", 
         RowBox[{"Sqrt", "[", 
          RowBox[{
           RowBox[{"sigmanotpga", "^", "2"}], "-", 
           RowBox[{"sigamp", "^", "2"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{"eq", " ", "24"}], "*)"}], 
        RowBox[{"sigma", "=", 
         RowBox[{"Sqrt", "[", 
          RowBox[{
           RowBox[{"sigmab", "^", "2"}], "+", 
           RowBox[{"sigamp", "^", "2"}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"dampdpga", " ", "sigmabpga"}], ")"}], "^", "2"}], "+", 
           RowBox[{
           "2.", " ", "dampdpga", " ", "sigmabpga", " ", "sigmab", " ", 
            "sigcorr"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{
          RowBox[{"sigma", "=", 
           RowBox[{"Sqrt", "[", 
            RowBox[{
             RowBox[{"sigmanot", "^", "2"}], "+", 
             RowBox[{"sigamp", "^", "2"}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"dampdpga", " ", "sigmabpga"}], ")"}], "^", "2"}], "+", 
             RowBox[{
             "2.", " ", "dampdpga", " ", "sigmabpga", " ", "sigmab", " ", 
              "sigcorr"}]}], "]"}]}], ";"}], "*)"}], 
        RowBox[{"(*", 
         RowBox[{"eq", " ", "25"}], "*)"}], 
        RowBox[{"tau", "=", 
         RowBox[{"Sqrt", "[", 
          RowBox[{
           RowBox[{"taunot", "^", "2"}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"dampdpga", " ", "taunotpga"}], ")"}], "^", "2"}], "+", 
           RowBox[{
           "2.", " ", "dampdpga", " ", "taunotpga", " ", "taunot", " ", 
            "taucorr"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{
          RowBox[{
          "both", " ", "of", " ", "the", " ", "above", " ", "equations", " ", 
           "differ", " ", "from", " ", "the", " ", "paper", " ", 
           RowBox[{"(", 
            RowBox[{
            "also", " ", "from", " ", "the", " ", "NGA", " ", "report", " ", 
             "from", " ", "072007"}], ")"}]}], "-", 
          RowBox[{
          "the", " ", "version", " ", "from", " ", "the", " ", "fortran", " ",
            "code", " ", "is", " ", "used"}]}], "*)"}], 
        RowBox[{"(*", 
         RowBox[{
          RowBox[{
           RowBox[{"**", "**", "**"}], "*", "partial", " ", "derivatives"}], "-", 
          RowBox[{
          "both", " ", "only", " ", "for", " ", "the", " ", "base", " ", 
           "model"}]}], "********)"}], 
        RowBox[{"(*", 
         RowBox[{"partial", " ", "derivative", " ", 
          RowBox[{"w", ".", "r", ".", "t", ".", "magnitude"}]}], "*)"}], 
        RowBox[{"pdmag", "=", 
         RowBox[{"Piecewise", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"a4", "-", 
                RowBox[{"2", "*", "a8", "*", 
                 RowBox[{"(", 
                  RowBox[{"8.5", "-", "mw"}], ")"}]}], "+", 
                RowBox[{"a3", "*", 
                 RowBox[{"Log", "[", 
                  RowBox[{"Sqrt", "[", 
                   RowBox[{
                    RowBox[{"c4", "^", "2"}], "+", 
                    RowBox[{"rrup", "^", "2"}]}], "]"}], "]"}]}]}], ",", 
               RowBox[{
                RowBox[{"c1", "-", "mw"}], ">=", "0"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"a5", "-", 
                RowBox[{"2", "*", "a8", "*", 
                 RowBox[{"(", 
                  RowBox[{"8.5", "-", "mw"}], ")"}]}], "+", 
                RowBox[{"a3", "*", 
                 RowBox[{"Log", "[", 
                  RowBox[{"Sqrt", "[", 
                   RowBox[{
                    RowBox[{"c4", "^", "2"}], "+", 
                    RowBox[{"rrup", "^", "2"}]}], "]"}], "]"}]}]}], ",", 
               RowBox[{
                RowBox[{"c1", "-", "mw"}], "<", "0"}]}], "}"}]}], "}"}], ",", 
           "0"}], "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{"partial", " ", "derivative", " ", 
          RowBox[{"w", ".", "r", ".", "t", ".", "distance"}]}], "*)"}], 
        RowBox[{"pddist", "=", 
         RowBox[{"Piecewise", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"a2", "+", 
                   RowBox[{"a3", "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "c1"}], "+", "mw"}], ")"}]}]}], ")"}], "*", 
                 "rrup"}], ")"}], "/", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"c4", "^", "2"}], "+", 
                 RowBox[{"rrup", "^", "2"}]}], ")"}]}], ",", 
              RowBox[{
               RowBox[{
                RowBox[{"c1", "-", "mw"}], ">=", "0"}], "||", 
               RowBox[{
                RowBox[{"c1", "-", "mw"}], "<", "0"}]}]}], "}"}], "}"}], ",", 
           "0"}], "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"Return", "[", 
         RowBox[{"{", 
          RowBox[{
          "lny", ",", "sigma", ",", "tau", ",", "pddist", ",", "pdmag"}], 
          "}"}], "]"}], ";"}]}], "]"}]}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.952173415304887*^9, 3.952173415306196*^9}},
 CellLabel->"In[80]:=",ExpressionUUID->"2ca4ea5d-32e0-4cf8-ba9d-629ac775b65b"]
}, Closed]],

Cell[CellGroupData[{

Cell["ChiouAndYoungs2008Hor", "Subsubsection",
 CellChangeTimes->{{3.952169552360321*^9, 3.952169577087267*^9}, 
   3.952172831298647*^9, 3.952173326385323*^9, {3.952177531679336*^9, 
   3.9521775537979603`*^9}},ExpressionUUID->"ab23f2c5-c469-4144-99cb-\
400d3b6d7252"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"ChiouAndYoungs2008Hor", "::", "usage"}], 
    "=", "\"\<ChiouAndYoungs2008Hor[p,options] returns {Subscript[a, SA](p), \
\[Sigma], \\!\\(\n\\*SubscriptBox[\\(\[PartialD]\\), \\(R\\)]\\(\n\
SubscriptBox[\\(a\\), \\(SA\\)](p)\\)\\), \\!\\(\n\\*SubscriptBox[\\(\
\[PartialD]\\), \\(M\\)]\\(\nSubscriptBox[\\(a\\), \\(SA\\)](p)\\)\\)}, a \
list of expected ground-motion parameters for a given earthquake scenario \
using the model of Chiou & Youngs (2008), which is part of the Next \
Generation of Attenuation (NGA) project. The model is based on 1950 \
recordings from 125 earthquakes from the PEER NGA database. To obtain PGA, \
use a period below 0.01s (minimum period used for regression), for PGV use a \
period below 0s;\>\""}], ";"}], "\n"}]], "Input",
 CellChangeTimes->{{3.952177540281135*^9, 3.952177540283432*^9}, 
   3.952177614946669*^9},
 CellLabel->"In[83]:=",ExpressionUUID->"130dda2e-3422-4454-a4fb-fcec28ea9082"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
     RowBox[{
     "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**",
       "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**",
       "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**",
       "**", "**", "**", "**", "**", "**", "**", "**", "**", "NGA"}], " ", 
     "project"}], ",", 
    RowBox[{
     RowBox[{"Chiou", " ", "and", " ", "Youngs", " ", 
      RowBox[{"(", "2008", ")"}]}], "-", 
     RowBox[{
     "the", " ", "model", " ", "differs", " ", "slightly", " ", "from", " ", 
      "the", " ", "one", " ", "published", " ", "in", " ", "Earthquake", " ", 
      "Spectra"}], "-", 
     RowBox[{
     "the", " ", "model", " ", "here", " ", "takes", " ", "the", " ", 
      "coefficients", " ", "from", " ", "the", " ", "Hazard39", " ", 
      "program", " ", "by", " ", "Norm", " ", "Abrahamson"}]}], ",", 
    RowBox[{"since", " ", "this", " ", "has", " ", "more", " ", 
     RowBox[{"periods", ".", "That"}], " ", "code", " ", "does", " ", "not", " ",
      "consider", " ", "the", " ", "aftershock", " ", "dependency"}], ",", 
    RowBox[{
    "so", " ", "it", " ", "is", " ", "also", " ", "not", " ", "considered", " ", 
     RowBox[{"here", "."}]}]}], 
   "********************************************************************************************)"}\
], 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Options", "[", "ChiouAndYoungs2008Hor", "]"}], "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"MagMW", "->", "6."}], ",", 
       RowBox[{"DistRUP", "->", "10."}], ",", 
       RowBox[{"DistHWJB", "->", "Automatic"}], ",", 
       RowBox[{"FaultDip", "->", "70."}], ",", 
       RowBox[{"DepthToTopOfRupture", "->", "1."}], ",", 
       RowBox[{"FaultTypeNSSR", "->", "\"\<REVERSE\>\""}], ",", 
       RowBox[{"Vs30", "->", "760."}], ",", 
       RowBox[{"BasinDepthZ10", "->", "\"\<Default\>\""}], ",", 
       RowBox[{"VS30Determination", "->", "\"\<ESTIMATED\>\""}], ",", 
       RowBox[{"HangingWallFlag", "->", "True"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"ChiouAndYoungs2008Hor", "[", 
      RowBox[{"per_", ",", 
       RowBox[{"opts", ":", 
        RowBox[{"OptionsPattern", "[", "]"}]}]}], "]"}], ":=", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "mw", ",", "rrup", ",", "rjb", ",", "rx", ",", "delta", ",", "ztor", ",",
          "faulttypeinp", ",", "vs30", ",", "z10", ",", "vs30det", ",", 
         "defaultdepth", ",", "periodlist", ",", "phi1list", ",", "phi2list", 
         ",", "phi3list", ",", "phi4list", ",", "phi5list", ",", "phi6list", ",",
          "phi7list", ",", "phi8list", ",", "phi1", ",", "phi2", ",", "phi3", 
         ",", "phi4", ",", "phi5", ",", "phi6", ",", "phi7", ",", "phi8", ",",
          "c1list", ",", "c1alist", ",", "c1blist", ",", "cnlist", ",", 
         "cmlist", ",", "c5list", ",", "c6list", ",", "c7list", ",", "c9list",
          ",", "c9alist", ",", "cg1list", ",", "cg2list", ",", "c1", ",", 
         "c1a", ",", "c1b", ",", "cn", ",", "cm", ",", "c5", ",", "c6", ",", 
         "c7", ",", "c9", ",", "c9a", ",", "cg1", ",", "cg2", ",", "c2", ",", 
         "c3", ",", "c4", ",", "c4a", ",", "crb", ",", "chm", ",", "cg3", ",",
          "frv", ",", "fnm", ",", "hw", ",", "f1", ",", "f2", ",", "f3", ",", 
         "f4", ",", "f5", ",", "f6", ",", "lnyref", ",", "yref", ",", "fsite",
          ",", "fsed", ",", "lny", ",", "saval", ",", "tau1list", ",", 
         "tau2list", ",", "sig1list", ",", "sig2list", ",", "sig3list", ",", 
         "tau1", ",", "tau2", ",", "sig1", ",", "sig2", ",", "sig3", ",", 
         "tau", ",", "sig", ",", "sigmatot", ",", "finf", ",", "fmeas", ",", 
         "srcsitea", ",", "b", ",", "c", ",", "nl0", ",", "pos", ",", 
         "pddist", ",", "pdmag", ",", "basinopt", ",", "basin"}], "}"}], ",", 
       
       RowBox[{
        RowBox[{"mw", "=", 
         RowBox[{"OptionValue", "[", "MagMW", "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"rrup", "=", 
         RowBox[{"OptionValue", "[", "DistRUP", "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"rjb", "=", 
         RowBox[{"OptionValue", "[", "DistHWJB", "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"hw", "=", 
         RowBox[{"OptionValue", "[", "HangingWallFlag", "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"delta", "=", 
         RowBox[{"OptionValue", "[", "FaultDip", "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"ztor", "=", 
         RowBox[{"OptionValue", "[", "DepthToTopOfRupture", "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"faulttypeinp", "=", 
         RowBox[{"OptionValue", "[", "FaultTypeNSSR", "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"vs30", "=", 
         RowBox[{"OptionValue", "[", "Vs30", "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"basinopt", "=", 
         RowBox[{"OptionValue", "[", "BasinDepthZ10", "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"vs30det", "=", 
         RowBox[{"OptionValue", "[", "VS30Determination", "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{"distance", " ", "conversion"}], "*)"}], 
        RowBox[{"defaultdepth", "=", "10."}], ";", "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"rjb", "===", "Automatic"}], ",", 
          RowBox[{
           RowBox[{"rjb", "=", 
            RowBox[{
             RowBox[{"ConvertDistanceMetric", "[", 
              RowBox[{"mw", ",", "rrup", ",", 
               RowBox[{"CDMhostdist", "->", "\"\<RRUP\>\""}], ",", 
               RowBox[{"CDMtargetdist", "->", "\"\<RJB\>\""}]}], "]"}], "[", 
             RowBox[{"[", "3", "]"}], "]"}]}], " ", 
           RowBox[{"(*", 
            RowBox[{"median", " ", "value", " ", "for", " ", "rjb"}], "*)"}], 
           ";"}]}], "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"periodlist", "=", 
         RowBox[{"{", 
          RowBox[{"0.", ",", 
           RowBox[{"-", "1."}], ",", "0.01", ",", "0.02", ",", "0.022", ",", 
           "0.025", ",", "0.029", ",", "0.03", ",", "0.032", ",", "0.035", ",",
            "0.036", ",", "0.04", ",", "0.042", ",", "0.044", ",", "0.045", ",",
            "0.046", ",", "0.048", ",", "0.05", ",", "0.055", ",", "0.06", ",",
            "0.065", ",", ".067", ",", "0.07", ",", "0.075", ",", "0.08", ",",
            "0.085", ",", "0.09", ",", "0.095", ",", "0.1", ",", "0.11", ",", 
           "0.12", ",", "0.13", ",", "0.133", ",", "0.14", ",", "0.15", ",", 
           "0.16", ",", "0.17", ",", "0.18", ",", "0.19", ",", "0.2", ",", 
           "0.22", ",", "0.24", ",", "0.25", ",", "0.26", ",", "0.28", ",", 
           "0.29", ",", "0.3", ",", "0.32", ",", "0.34", ",", "0.35", ",", 
           "0.36", ",", "0.38", ",", "0.4", ",", "0.42", ",", "0.44", ",", 
           "0.45", ",", "0.46", ",", "0.48", ",", "0.5", ",", "0.55", ",", 
           "0.6", ",", "0.65", ",", "0.667", ",", "0.7", ",", "0.75", ",", 
           "0.8", ",", "0.85", ",", "0.9", ",", "0.95", ",", "1.", ",", "1.1",
            ",", "1.2", ",", "1.3", ",", "1.4", ",", "1.5", ",", "1.6", ",", 
           "1.7", ",", "1.8", ",", "1.9", ",", "2.", ",", "2.2", ",", "2.4", ",",
            "2.5", ",", "2.6", ",", "2.8", ",", "3.", ",", "3.2", ",", "3.4", 
           ",", "3.5", ",", "3.6", ",", "3.8", ",", "4.", ",", "4.2", ",", 
           "4.4", ",", "4.6", ",", "4.8", ",", "5.", ",", "5.5", ",", "6.", ",",
            "6.5", ",", "7.", ",", "7.5", ",", "8.", ",", "8.5", ",", "9.", ",",
            "9.5", ",", "10."}], "}"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"c1list", "=", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1.2687`"}], ",", "2.2884`", ",", 
           RowBox[{"-", "1.268694`"}], ",", 
           RowBox[{"-", "1.251478`"}], ",", 
           RowBox[{"-", "1.238087`"}], ",", 
           RowBox[{"-", "1.216428`"}], ",", 
           RowBox[{"-", "1.18418`"}], ",", 
           RowBox[{"-", "1.174374`"}], ",", 
           RowBox[{"-", "1.154467`"}], ",", 
           RowBox[{"-", "1.123314`"}], ",", 
           RowBox[{"-", "1.111874`"}], ",", 
           RowBox[{"-", "1.067114`"}], ",", 
           RowBox[{"-", "1.043071`"}], ",", 
           RowBox[{"-", "1.018824`"}], ",", 
           RowBox[{"-", "1.00656`"}], ",", 
           RowBox[{"-", "0.994327`"}], ",", 
           RowBox[{"-", "0.970216`"}], ",", 
           RowBox[{"-", "0.946391`"}], ",", 
           RowBox[{"-", "0.889485`"}], ",", 
           RowBox[{"-", "0.836096`"}], ",", 
           RowBox[{"-", "0.787293`"}], ",", 
           RowBox[{"-", "0.769389`"}], ",", 
           RowBox[{"-", "0.743954`"}], ",", 
           RowBox[{"-", "0.705072`"}], ",", 
           RowBox[{"-", "0.670827`"}], ",", 
           RowBox[{"-", "0.640929`"}], ",", 
           RowBox[{"-", "0.6151`"}], ",", 
           RowBox[{"-", "0.593104`"}], ",", 
           RowBox[{"-", "0.574699`"}], ",", 
           RowBox[{"-", "0.545283`"}], ",", 
           RowBox[{"-", "0.527572`"}], ",", 
           RowBox[{"-", "0.519988`"}], ",", 
           RowBox[{"-", "0.520317`"}], ",", 
           RowBox[{"-", "0.522696`"}], ",", 
           RowBox[{"-", "0.530869`"}], ",", 
           RowBox[{"-", "0.544692`"}], ",", 
           RowBox[{"-", "0.562955`"}], ",", 
           RowBox[{"-", "0.584664`"}], ",", 
           RowBox[{"-", "0.608982`"}], ",", 
           RowBox[{"-", "0.635236`"}], ",", 
           RowBox[{"-", "0.689254`"}], ",", 
           RowBox[{"-", "0.746535`"}], ",", 
           RowBox[{"-", "0.776564`"}], ",", 
           RowBox[{"-", "0.806831`"}], ",", 
           RowBox[{"-", "0.866612`"}], ",", 
           RowBox[{"-", "0.897204`"}], ",", 
           RowBox[{"-", "0.92776`"}], ",", 
           RowBox[{"-", "0.987694`"}], ",", 
           RowBox[{"-", "1.046911`"}], ",", 
           RowBox[{"-", "1.076381`"}], ",", 
           RowBox[{"-", "1.10551`"}], ",", 
           RowBox[{"-", "1.162283`"}], ",", 
           RowBox[{"-", "1.217597`"}], ",", 
           RowBox[{"-", "1.271357`"}], ",", 
           RowBox[{"-", "1.323477`"}], ",", 
           RowBox[{"-", "1.348959`"}], ",", 
           RowBox[{"-", "1.373988`"}], ",", 
           RowBox[{"-", "1.422616`"}], ",", 
           RowBox[{"-", "1.469453`"}], ",", 
           RowBox[{"-", "1.578991`"}], ",", 
           RowBox[{"-", "1.678576`"}], ",", 
           RowBox[{"-", "1.769127`"}], ",", 
           RowBox[{"-", "1.797932`"}], ",", 
           RowBox[{"-", "1.8516`"}], ",", 
           RowBox[{"-", "1.927839`"}], ",", 
           RowBox[{"-", "1.998837`"}], ",", 
           RowBox[{"-", "2.06549`"}], ",", 
           RowBox[{"-", "2.128468`"}], ",", 
           RowBox[{"-", "2.188278`"}], ",", 
           RowBox[{"-", "2.245326`"}], ",", 
           RowBox[{"-", "2.352111`"}], ",", 
           RowBox[{"-", "2.451947`"}], ",", 
           RowBox[{"-", "2.547437`"}], ",", 
           RowBox[{"-", "2.640124`"}], ",", 
           RowBox[{"-", "2.730652`"}], ",", 
           RowBox[{"-", "2.818867`"}], ",", 
           RowBox[{"-", "2.904397`"}], ",", 
           RowBox[{"-", "2.986847`"}], ",", 
           RowBox[{"-", "3.065866`"}], ",", 
           RowBox[{"-", "3.141253`"}], ",", 
           RowBox[{"-", "3.281536`"}], ",", 
           RowBox[{"-", "3.409571`"}], ",", 
           RowBox[{"-", "3.469751`"}], ",", 
           RowBox[{"-", "3.527743`"}], ",", 
           RowBox[{"-", "3.637785`"}], ",", 
           RowBox[{"-", "3.741264`"}], ",", 
           RowBox[{"-", "3.838964`"}], ",", 
           RowBox[{"-", "3.931396`"}], ",", 
           RowBox[{"-", "3.975878`"}], ",", 
           RowBox[{"-", "4.019205`"}], ",", 
           RowBox[{"-", "4.102464`"}], ",", 
           RowBox[{"-", "4.181358`"}], ",", 
           RowBox[{"-", "4.256034`"}], ",", 
           RowBox[{"-", "4.326756`"}], ",", 
           RowBox[{"-", "4.39387`"}], ",", 
           RowBox[{"-", "4.457747`"}], ",", 
           RowBox[{"-", "4.518726`"}], ",", 
           RowBox[{"-", "4.660582`"}], ",", 
           RowBox[{"-", "4.789382`"}], ",", 
           RowBox[{"-", "4.907897`"}], ",", 
           RowBox[{"-", "5.018331`"}], ",", 
           RowBox[{"-", "5.12243`"}], ",", 
           RowBox[{"-", "5.221536`"}], ",", 
           RowBox[{"-", "5.316573`"}], ",", 
           RowBox[{"-", "5.40817`"}], ",", 
           RowBox[{"-", "5.496751`"}], ",", 
           RowBox[{"-", "5.587222`"}]}], "}"}]}], ";", "\[IndentingNewLine]", 
        
        RowBox[{"c1alist", "=", 
         RowBox[{"{", 
          RowBox[{
          "0.1`", ",", "0.1094`", ",", "0.1`", ",", "0.1`", ",", "0.1`", ",", 
           "0.1`", ",", "0.1`", ",", "0.1`", ",", "0.1`", ",", "0.1`", ",", 
           "0.1`", ",", "0.1`", ",", "0.1`", ",", "0.1`", ",", "0.1`", ",", 
           "0.1`", ",", "0.1`", ",", "0.1`", ",", "0.1`", ",", "0.1`", ",", 
           "0.1`", ",", "0.1`", ",", "0.1`", ",", "0.1`", ",", "0.1`", ",", 
           "0.1`", ",", "0.1`", ",", "0.1`", ",", "0.1`", ",", "0.1`", ",", 
           "0.1`", ",", "0.1`", ",", "0.1`", ",", "0.1`", ",", "0.1`", ",", 
           "0.1`", ",", "0.1`", ",", "0.1`", ",", "0.1`", ",", "0.1`", ",", 
           "0.1`", ",", "0.1`", ",", "0.1`", ",", "0.1`", ",", "0.0999`", ",",
            "0.0999`", ",", "0.0999`", ",", "0.0999`", ",", "0.0999`", ",", 
           "0.0998`", ",", "0.0998`", ",", "0.0998`", ",", "0.0997`", ",", 
           "0.0996`", ",", "0.0995`", ",", "0.0995`", ",", "0.0994`", ",", 
           "0.0993`", ",", "0.0991`", ",", "0.0986`", ",", "0.0978`", ",", 
           "0.0968`", ",", "0.0963`", ",", "0.0954`", ",", "0.0936`", ",", 
           "0.0914`", ",", "0.0887`", ",", "0.0853`", ",", "0.0813`", ",", 
           "0.0766`", ",", "0.0651`", ",", "0.0512`", ",", "0.0355`", ",", 
           "0.0188`", ",", "0.0022`", ",", 
           RowBox[{"-", "0.0135`"}], ",", 
           RowBox[{"-", "0.0275`"}], ",", 
           RowBox[{"-", "0.0399`"}], ",", 
           RowBox[{"-", "0.0504`"}], ",", 
           RowBox[{"-", "0.0591`"}], ",", 
           RowBox[{"-", "0.0722`"}], ",", 
           RowBox[{"-", "0.0808`"}], ",", 
           RowBox[{"-", "0.084`"}], ",", 
           RowBox[{"-", "0.0866`"}], ",", 
           RowBox[{"-", "0.0905`"}], ",", 
           RowBox[{"-", "0.0931`"}], ",", 
           RowBox[{"-", "0.0949`"}], ",", 
           RowBox[{"-", "0.0962`"}], ",", 
           RowBox[{"-", "0.0967`"}], ",", 
           RowBox[{"-", "0.0971`"}], ",", 
           RowBox[{"-", "0.0978`"}], ",", 
           RowBox[{"-", "0.0982`"}], ",", 
           RowBox[{"-", "0.0986`"}], ",", 
           RowBox[{"-", "0.0989`"}], ",", 
           RowBox[{"-", "0.0991`"}], ",", 
           RowBox[{"-", "0.0993`"}], ",", 
           RowBox[{"-", "0.0994`"}], ",", 
           RowBox[{"-", "0.0996`"}], ",", 
           RowBox[{"-", "0.0998`"}], ",", 
           RowBox[{"-", "0.0998`"}], ",", 
           RowBox[{"-", "0.0999`"}], ",", 
           RowBox[{"-", "0.0999`"}], ",", 
           RowBox[{"-", "0.0999`"}], ",", 
           RowBox[{"-", "0.1`"}], ",", 
           RowBox[{"-", "0.1`"}], ",", 
           RowBox[{"-", "0.1`"}], ",", 
           RowBox[{"-", "0.1`"}]}], "}"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"c1blist", "=", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.255`"}], ",", 
           RowBox[{"-", "0.0626`"}], ",", 
           RowBox[{"-", "0.255`"}], ",", 
           RowBox[{"-", "0.255`"}], ",", 
           RowBox[{"-", "0.255`"}], ",", 
           RowBox[{"-", "0.255`"}], ",", 
           RowBox[{"-", "0.255`"}], ",", 
           RowBox[{"-", "0.255`"}], ",", 
           RowBox[{"-", "0.255`"}], ",", 
           RowBox[{"-", "0.255`"}], ",", 
           RowBox[{"-", "0.255`"}], ",", 
           RowBox[{"-", "0.255`"}], ",", 
           RowBox[{"-", "0.255`"}], ",", 
           RowBox[{"-", "0.255`"}], ",", 
           RowBox[{"-", "0.255`"}], ",", 
           RowBox[{"-", "0.255`"}], ",", 
           RowBox[{"-", "0.255`"}], ",", 
           RowBox[{"-", "0.255`"}], ",", 
           RowBox[{"-", "0.255`"}], ",", 
           RowBox[{"-", "0.255`"}], ",", 
           RowBox[{"-", "0.2547`"}], ",", 
           RowBox[{"-", "0.254`"}], ",", 
           RowBox[{"-", "0.254`"}], ",", 
           RowBox[{"-", "0.254`"}], ",", 
           RowBox[{"-", "0.254`"}], ",", 
           RowBox[{"-", "0.254`"}], ",", 
           RowBox[{"-", "0.254`"}], ",", 
           RowBox[{"-", "0.253`"}], ",", 
           RowBox[{"-", "0.253`"}], ",", 
           RowBox[{"-", "0.2529`"}], ",", 
           RowBox[{"-", "0.252`"}], ",", 
           RowBox[{"-", "0.251`"}], ",", 
           RowBox[{"-", "0.251`"}], ",", 
           RowBox[{"-", "0.2504`"}], ",", 
           RowBox[{"-", "0.25`"}], ",", 
           RowBox[{"-", "0.249`"}], ",", 
           RowBox[{"-", "0.248`"}], ",", 
           RowBox[{"-", "0.247`"}], ",", 
           RowBox[{"-", "0.246`"}], ",", 
           RowBox[{"-", "0.2449`"}], ",", 
           RowBox[{"-", "0.2428`"}], ",", 
           RowBox[{"-", "0.24`"}], ",", 
           RowBox[{"-", "0.2382`"}], ",", 
           RowBox[{"-", "0.237`"}], ",", 
           RowBox[{"-", "0.2343`"}], ",", 
           RowBox[{"-", "0.2328`"}], ",", 
           RowBox[{"-", "0.2313`"}], ",", 
           RowBox[{"-", "0.2275`"}], ",", 
           RowBox[{"-", "0.2247`"}], ",", 
           RowBox[{"-", "0.2226`"}], ",", 
           RowBox[{"-", "0.2214`"}], ",", 
           RowBox[{"-", "0.218`"}], ",", 
           RowBox[{"-", "0.2146`"}], ",", 
           RowBox[{"-", "0.2107`"}], ",", 
           RowBox[{"-", "0.2073`"}], ",", 
           RowBox[{"-", "0.2054`"}], ",", 
           RowBox[{"-", "0.2037`"}], ",", 
           RowBox[{"-", "0.2008`"}], ",", 
           RowBox[{"-", "0.1972`"}], ",", 
           RowBox[{"-", "0.1889`"}], ",", 
           RowBox[{"-", "0.1814`"}], ",", 
           RowBox[{"-", "0.1744`"}], ",", 
           RowBox[{"-", "0.1722`"}], ",", 
           RowBox[{"-", "0.168`"}], ",", 
           RowBox[{"-", "0.162`"}], ",", 
           RowBox[{"-", "0.1564`"}], ",", 
           RowBox[{"-", "0.1511`"}], ",", 
           RowBox[{"-", "0.1472`"}], ",", 
           RowBox[{"-", "0.1432`"}], ",", 
           RowBox[{"-", "0.14`"}], ",", 
           RowBox[{"-", "0.1337`"}], ",", 
           RowBox[{"-", "0.1282`"}], ",", 
           RowBox[{"-", "0.1246`"}], ",", 
           RowBox[{"-", "0.1214`"}], ",", 
           RowBox[{"-", "0.1184`"}], ",", 
           RowBox[{"-", "0.1166`"}], ",", 
           RowBox[{"-", "0.114`"}], ",", 
           RowBox[{"-", "0.1125`"}], ",", 
           RowBox[{"-", "0.1111`"}], ",", 
           RowBox[{"-", "0.11`"}], ",", 
           RowBox[{"-", "0.108`"}], ",", 
           RowBox[{"-", "0.107`"}], ",", 
           RowBox[{"-", "0.106`"}], ",", 
           RowBox[{"-", "0.106`"}], ",", 
           RowBox[{"-", "0.105`"}], ",", 
           RowBox[{"-", "0.104`"}], ",", 
           RowBox[{"-", "0.104`"}], ",", 
           RowBox[{"-", "0.103`"}], ",", 
           RowBox[{"-", "0.103`"}], ",", 
           RowBox[{"-", "0.103`"}], ",", 
           RowBox[{"-", "0.102`"}], ",", 
           RowBox[{"-", "0.102`"}], ",", 
           RowBox[{"-", "0.102`"}], ",", 
           RowBox[{"-", "0.102`"}], ",", 
           RowBox[{"-", "0.102`"}], ",", 
           RowBox[{"-", "0.101`"}], ",", 
           RowBox[{"-", "0.101`"}], ",", 
           RowBox[{"-", "0.101`"}], ",", 
           RowBox[{"-", "0.101`"}], ",", 
           RowBox[{"-", "0.101`"}], ",", 
           RowBox[{"-", "0.101`"}], ",", 
           RowBox[{"-", "0.101`"}], ",", 
           RowBox[{"-", "0.1`"}], ",", 
           RowBox[{"-", "0.1`"}], ",", 
           RowBox[{"-", "0.1`"}], ",", 
           RowBox[{"-", "0.1`"}], ",", 
           RowBox[{"-", "0.1`"}]}], "}"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"cnlist", "=", 
         RowBox[{"{", 
          RowBox[{
          "2.996`", ",", "1.648`", ",", "2.996`", ",", "3.2924`", ",", 
           "3.3516`", ",", "3.4293`", ",", "3.5012`", ",", "3.5137`", ",", 
           "3.5331`", ",", "3.5512`", ",", "3.5549`", ",", "3.563`", ",", 
           "3.5627`", ",", "3.5607`", ",", "3.5594`", ",", "3.5574`", ",", 
           "3.5526`", ",", "3.5473`", ",", "3.5308`", ",", "3.5129`", ",", 
           "3.493`", ",", "3.4844`", ",", "3.4714`", ",", "3.448`", ",", 
           "3.4232`", ",", "3.3966`", ",", "3.3689`", ",", "3.3407`", ",", 
           "3.312`", ",", "3.2549`", ",", "3.1992`", ",", "3.1447`", ",", 
           "3.1288`", ",", "3.0932`", ",", "3.0436`", ",", "2.997`", ",", 
           "2.9522`", ",", "2.91`", ",", "2.8701`", ",", "2.8312`", ",", 
           "2.7596`", ",", "2.6916`", ",", "2.6579`", ",", "2.6256`", ",", 
           "2.5637`", ",", "2.5334`", ",", "2.5048`", ",", "2.4487`", ",", 
           "2.397`", ",", "2.3719`", ",", "2.348`", ",", "2.3034`", ",", 
           "2.2611`", ",", "2.2218`", ",", "2.1848`", ",", "2.1672`", ",", 
           "2.15`", ",", "2.1178`", ",", "2.0868`", ",", "2.0174`", ",", 
           "1.957`", ",", "1.9036`", ",", "1.8868`", ",", "1.8554`", ",", 
           "1.8119`", ",", "1.7727`", ",", "1.7368`", ",", "1.7039`", ",", 
           "1.6747`", ",", "1.648`", ",", "1.6046`", ",", "1.5717`", ",", 
           "1.5462`", ",", "1.5263`", ",", "1.511`", ",", "1.4984`", ",", 
           "1.4889`", ",", "1.4814`", ",", "1.4744`", ",", "1.4698`", ",", 
           "1.4625`", ",", "1.458`", ",", "1.4562`", ",", "1.456`", ",", 
           "1.455`", ",", "1.4557`", ",", "1.4565`", ",", "1.4581`", ",", 
           "1.4594`", ",", "1.4606`", ",", "1.463`", ",", "1.4652`", ",", 
           "1.4676`", ",", "1.4703`", ",", "1.4733`", ",", "1.4752`", ",", 
           "1.4779`", ",", "1.4831`", ",", "1.4878`", ",", "1.4923`", ",", 
           "1.4955`", ",", "1.4975`", ",", "1.499`", ",", "1.5`", ",", 
           "1.501`", ",", "1.501`", ",", "1.502`"}], "}"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"cmlist", "=", 
         RowBox[{"{", 
          RowBox[{
          "4.184`", ",", "4.2979`", ",", "4.184`", ",", "4.1879`", ",", 
           "4.1828`", ",", "4.1734`", ",", "4.1593`", ",", "4.1556`", ",", 
           "4.1485`", ",", "4.1382`", ",", "4.1351`", ",", "4.1226`", ",", 
           "4.1174`", ",", "4.1123`", ",", "4.1104`", ",", "4.1084`", ",", 
           "4.1038`", ",", "4.1011`", ",", "4.094`", ",", "4.0892`", ",", 
           "4.0867`", ",", "4.086`", ",", "4.086`", ",", "4.086`", ",", 
           "4.0873`", ",", "4.0899`", ",", "4.0938`", ",", "4.0985`", ",", 
           "4.103`", ",", "4.1144`", ",", "4.1277`", ",", "4.1416`", ",", 
           "4.1459`", ",", "4.1565`", ",", "4.1717`", ",", "4.1871`", ",", 
           "4.2023`", ",", "4.2172`", ",", "4.2323`", ",", "4.2476`", ",", 
           "4.2759`", ",", "4.3042`", ",", "4.3184`", ",", "4.332`", ",", 
           "4.3584`", ",", "4.3712`", ",", "4.3844`", ",", "4.4086`", ",", 
           "4.4323`", ",", "4.4441`", ",", "4.4557`", ",", "4.4768`", ",", 
           "4.4979`", ",", "4.5172`", ",", "4.5361`", ",", "4.5452`", ",", 
           "4.5545`", ",", "4.5712`", ",", "4.5881`", ",", "4.6273`", ",", 
           "4.6632`", ",", "4.6959`", ",", "4.7071`", ",", "4.7276`", ",", 
           "4.7571`", ",", "4.7851`", ",", "4.8114`", ",", "4.8362`", ",", 
           "4.8597`", ",", "4.882`", ",", "4.9245`", ",", "4.9641`", ",", 
           "5.0013`", ",", "5.0367`", ",", "5.0697`", ",", "5.1019`", ",", 
           "5.1325`", ",", "5.1623`", ",", "5.1905`", ",", "5.2173`", ",", 
           "5.2691`", ",", "5.3173`", ",", "5.3393`", ",", "5.361`", ",", 
           "5.4013`", ",", "5.4385`", ",", "5.4737`", ",", "5.5069`", ",", 
           "5.5229`", ",", "5.5382`", ",", "5.5687`", ",", "5.5977`", ",", 
           "5.6252`", ",", "5.6518`", ",", "5.6776`", ",", "5.7027`", ",", 
           "5.7276`", ",", "5.7855`", ",", "5.8404`", ",", "5.8924`", ",", 
           "5.9422`", ",", "5.9891`", ",", "6.0339`", ",", "6.077`", ",", 
           "6.1172`", ",", "6.1561`", ",", "6.193`"}], "}"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"c5list", "=", 
         RowBox[{"{", 
          RowBox[{
          "6.16`", ",", "5.17`", ",", "6.16`", ",", "6.158`", ",", "6.158`", ",",
            "6.157`", ",", "6.1558`", ",", "6.155`", ",", "6.1545`", ",", 
           "6.153`", ",", "6.153`", ",", "6.1508`", ",", "6.1497`", ",", 
           "6.1487`", ",", "6.1477`", ",", "6.147`", ",", "6.1459`", ",", 
           "6.1441`", ",", "6.1409`", ",", "6.1362`", ",", "6.1314`", ",", 
           "6.1294`", ",", "6.126`", ",", "6.12`", ",", "6.1144`", ",", 
           "6.1072`", ",", "6.1007`", ",", "6.0929`", ",", "6.085`", ",", 
           "6.0683`", ",", "6.0494`", ",", "6.0296`", ",", "6.0237`", ",", 
           "6.0087`", ",", "5.9871`", ",", "5.9647`", ",", "5.9416`", ",", 
           "5.9177`", ",", "5.8942`", ",", "5.8699`", ",", "5.8231`", ",", 
           "5.7767`", ",", "5.7547`", ",", "5.7335`", ",", "5.6917`", ",", 
           "5.6719`", ",", "5.6527`", ",", "5.6163`", ",", "5.5832`", ",", 
           "5.5681`", ",", "5.5528`", ",", "5.5252`", ",", "5.4997`", ",", 
           "5.4764`", ",", "5.4555`", ",", "5.4458`", ",", "5.4362`", ",", 
           "5.4189`", ",", "5.4029`", ",", "5.3697`", ",", "5.3431`", ",", 
           "5.3213`", ",", "5.3149`", ",", "5.3045`", ",", "5.29`", ",", 
           "5.2788`", ",", "5.2692`", ",", "5.2607`", ",", "5.2537`", ",", 
           "5.248`", ",", "5.2387`", ",", "5.2321`", ",", "5.2266`", ",", 
           "5.2224`", ",", "5.2194`", ",", "5.2166`", ",", "5.214`", ",", 
           "5.2125`", ",", "5.2111`", ",", "5.2099`", ",", "5.208`", ",", 
           "5.206`", ",", "5.206`", ",", "5.205`", ",", "5.2043`", ",", 
           "5.204`", ",", "5.203`", ",", "5.203`", ",", "5.203`", ",", 
           "5.2024`", ",", "5.202`", ",", "5.202`", ",", "5.202`", ",", 
           "5.2017`", ",", "5.201`", ",", "5.201`", ",", "5.201`", ",", 
           "5.201`", ",", "5.201`", ",", "5.201`", ",", "5.201`", ",", "5.2`",
            ",", "5.2`", ",", "5.2`", ",", "5.2`", ",", "5.2`", ",", "5.2`"}],
           "}"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"c6list", "=", 
         RowBox[{"{", 
          RowBox[{
          "0.4893`", ",", "0.4407`", ",", "0.4893`", ",", "0.4892`", ",", 
           "0.4892`", ",", "0.4891`", ",", "0.4891`", ",", "0.489`", ",", 
           "0.489`", ",", "0.4889`", ",", "0.4889`", ",", "0.4888`", ",", 
           "0.4887`", ",", "0.4887`", ",", "0.4886`", ",", "0.4886`", ",", 
           "0.4885`", ",", "0.4884`", ",", "0.4883`", ",", "0.488`", ",", 
           "0.4878`", ",", "0.4876`", ",", "0.4875`", ",", "0.4872`", ",", 
           "0.4869`", ",", "0.4865`", ",", "0.4862`", ",", "0.4858`", ",", 
           "0.4854`", ",", "0.4846`", ",", "0.4837`", ",", "0.4828`", ",", 
           "0.4825`", ",", "0.4818`", ",", "0.4808`", ",", "0.4797`", ",", 
           "0.4787`", ",", "0.4776`", ",", "0.4765`", ",", "0.4755`", ",", 
           "0.4735`", ",", "0.4715`", ",", "0.4706`", ",", "0.4698`", ",", 
           "0.468`", ",", "0.4673`", ",", "0.4665`", ",", "0.4651`", ",", 
           "0.4638`", ",", "0.4632`", ",", "0.4626`", ",", "0.4616`", ",", 
           "0.4607`", ",", "0.4598`", ",", "0.4591`", ",", "0.4587`", ",", 
           "0.4583`", ",", "0.4578`", ",", "0.4571`", ",", "0.456`", ",", 
           "0.455`", ",", "0.4542`", ",", "0.454`", ",", "0.4536`", ",", 
           "0.4531`", ",", "0.4528`", ",", "0.4524`", ",", "0.4522`", ",", 
           "0.4519`", ",", "0.4517`", ",", "0.4514`", ",", "0.4511`", ",", 
           "0.451`", ",", "0.4508`", ",", "0.4507`", ",", "0.4506`", ",", 
           "0.4505`", ",", "0.4504`", ",", "0.4504`", ",", "0.4504`", ",", 
           "0.4503`", ",", "0.4502`", ",", "0.4502`", ",", "0.4502`", ",", 
           "0.4502`", ",", "0.4501`", ",", "0.4501`", ",", "0.4501`", ",", 
           "0.4501`", ",", "0.4501`", ",", "0.4501`", ",", "0.4501`", ",", 
           "0.4501`", ",", "0.4501`", ",", "0.4501`", ",", "0.45`", ",", 
           "0.45`", ",", "0.45`", ",", "0.45`", ",", "0.45`", ",", "0.45`", ",",
            "0.45`", ",", "0.45`", ",", "0.45`", ",", "0.45`", ",", "0.45`", ",",
            "0.45`"}], "}"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"c7list", "=", 
         RowBox[{"{", 
          RowBox[{
          "0.0512`", ",", "0.0207`", ",", "0.0512`", ",", "0.0512`", ",", 
           "0.0512`", ",", "0.0512`", ",", "0.0511`", ",", "0.0511`", ",", 
           "0.0511`", ",", "0.051`", ",", "0.0509`", ",", "0.0508`", ",", 
           "0.0507`", ",", "0.0506`", ",", "0.0506`", ",", "0.0505`", ",", 
           "0.0505`", ",", "0.0504`", ",", "0.0502`", ",", "0.05`", ",", 
           "0.0499`", ",", "0.0498`", ",", "0.0497`", ",", "0.0495`", ",", 
           "0.0494`", ",", "0.0492`", ",", "0.0491`", ",", "0.049`", ",", 
           "0.0489`", ",", "0.0486`", ",", "0.0484`", ",", "0.0482`", ",", 
           "0.0482`", ",", "0.0481`", ",", "0.0479`", ",", "0.0477`", ",", 
           "0.0476`", ",", "0.0474`", ",", "0.0473`", ",", "0.0471`", ",", 
           "0.0468`", ",", "0.0466`", ",", "0.0464`", ",", "0.0463`", ",", 
           "0.046`", ",", "0.0459`", ",", "0.0458`", ",", "0.0455`", ",", 
           "0.0453`", ",", "0.0452`", ",", "0.045`", ",", "0.0448`", ",", 
           "0.0445`", ",", "0.0442`", ",", "0.0439`", ",", "0.0437`", ",", 
           "0.0436`", ",", "0.0432`", ",", "0.0429`", ",", "0.0421`", ",", 
           "0.0412`", ",", "0.0404`", ",", "0.0401`", ",", "0.0395`", ",", 
           "0.0387`", ",", "0.0379`", ",", "0.0372`", ",", "0.0364`", ",", 
           "0.0357`", ",", "0.035`", ",", "0.0336`", ",", "0.0322`", ",", 
           "0.0308`", ",", "0.0294`", ",", "0.028`", ",", "0.0266`", ",", 
           "0.0253`", ",", "0.024`", ",", "0.0227`", ",", "0.0213`", ",", 
           "0.0188`", ",", "0.0165`", ",", "0.0154`", ",", "0.0144`", ",", 
           "0.0124`", ",", "0.0106`", ",", "0.009`", ",", "0.0076`", ",", 
           "0.0069`", ",", "0.0063`", ",", "0.0052`", ",", "0.0041`", ",", 
           "0.0033`", ",", "0.0025`", ",", "0.0019`", ",", "0.0014`", ",", 
           "0.001`", ",", "0.0002`", ",", "0.`", ",", "0.`", ",", "0.`", ",", 
           "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", 
           "0.`"}], "}"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"c9list", "=", 
         RowBox[{"{", 
          RowBox[{
          "0.79`", ",", "0.3079`", ",", "0.79`", ",", "0.8129`", ",", 
           "0.8188`", ",", "0.828`", ",", "0.8407`", ",", "0.8439`", ",", 
           "0.8502`", ",", "0.8594`", ",", "0.8624`", ",", "0.874`", ",", 
           "0.8795`", ",", "0.8848`", ",", "0.8874`", ",", "0.8899`", ",", 
           "0.8949`", ",", "0.8996`", ",", "0.9105`", ",", "0.9204`", ",", 
           "0.9292`", ",", "0.9325`", ",", "0.9371`", ",", "0.9442`", ",", 
           "0.9505`", ",", "0.9559`", ",", "0.9606`", ",", "0.9645`", ",", 
           "0.9677`", ",", "0.9718`", ",", "0.9733`", ",", "0.9725`", ",", 
           "0.9719`", ",", "0.9699`", ",", "0.966`", ",", "0.9609`", ",", 
           "0.9549`", ",", "0.9482`", ",", "0.941`", ",", "0.9334`", ",", 
           "0.9179`", ",", "0.9023`", ",", "0.8946`", ",", "0.8871`", ",", 
           "0.8726`", ",", "0.8657`", ",", "0.859`", ",", "0.8462`", ",", 
           "0.8342`", ",", "0.8284`", ",", "0.8228`", ",", "0.8121`", ",", 
           "0.8019`", ",", "0.7922`", ",", "0.783`", ",", "0.7786`", ",", 
           "0.7743`", ",", "0.7659`", ",", "0.7578`", ",", "0.7391`", ",", 
           "0.7221`", ",", "0.7065`", ",", "0.7015`", ",", "0.6922`", ",", 
           "0.6788`", ",", "0.6662`", ",", "0.654`", ",", "0.6423`", ",", 
           "0.6308`", ",", "0.6196`", ",", "0.5975`", ",", "0.5756`", ",", 
           "0.5538`", ",", "0.532`", ",", "0.5101`", ",", "0.4877`", ",", 
           "0.4649`", ",", "0.4412`", ",", "0.4169`", ",", "0.3917`", ",", 
           "0.339`", ",", "0.2833`", ",", "0.2546`", ",", "0.2262`", ",", 
           "0.1722`", ",", "0.1244`", ",", "0.0846`", ",", "0.0538`", ",", 
           "0.042`", ",", "0.0322`", ",", "0.0177`", ",", "0.0086`", ",", 
           "0.0031`", ",", "0.0004`", ",", "0.`", ",", "0.`", ",", "0.`", ",",
            "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`",
            ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`"}], "}"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"c9alist", "=", 
         RowBox[{"{", 
          RowBox[{
          "1.5005`", ",", "2.669`", ",", "1.500502`", ",", "1.502755`", ",", 
           "1.503506`", ",", "1.504559`", ",", "1.506667`", ",", "1.507119`", 
           ",", "1.508175`", ",", "1.510438`", ",", "1.511043`", ",", 
           "1.513765`", ",", "1.515734`", ",", "1.517706`", ",", "1.518617`", 
           ",", "1.519528`", ",", "1.521353`", ",", "1.523027`", ",", 
           "1.529743`", ",", "1.535875`", ",", "1.542802`", ",", "1.546354`", 
           ",", "1.551621`", ",", "1.55971`", ",", "1.567842`", ",", 
           "1.579171`", ",", "1.590105`", ",", "1.600474`", ",", "1.610428`", 
           ",", "1.638367`", ",", "1.664459`", ",", "1.692658`", ",", 
           "1.702334`", ",", "1.724608`", ",", "1.754879`", ",", "1.784789`", 
           ",", "1.819388`", ",", "1.852804`", ",", "1.884759`", ",", 
           "1.915732`", ",", "1.9806`", ",", "2.041531`", ",", "2.070935`", ",",
            "2.098242`", ",", "2.150499`", ",", "2.175808`", ",", "2.200534`",
            ",", "2.246784`", ",", "2.284621`", ",", "2.302971`", ",", 
           "2.321004`", ",", "2.355846`", ",", "2.388582`", ",", "2.412588`", 
           ",", "2.435617`", ",", "2.446846`", ",", "2.457882`", ",", 
           "2.479359`", ",", "2.500023`", ",", "2.533749`", ",", "2.564594`", 
           ",", "2.589332`", ",", "2.595295`", ",", "2.606478`", ",", 
           "2.622426`", ",", "2.636626`", ",", "2.645606`", ",", "2.65382`", ",",
            "2.661527`", ",", "2.66899`", ",", "2.677276`", ",", "2.685052`", 
           ",", "2.690965`", ",", "2.694735`", ",", "2.698511`", ",", 
           "2.701481`", ",", "2.703372`", ",", "2.705265`", ",", "2.706889`", 
           ",", "2.708514`", ",", "2.710139`", ",", "2.711766`", ",", 
           "2.712308`", ",", "2.712851`", ",", "2.713665`", ",", "2.714479`", 
           ",", "2.715022`", ",", "2.715293`", ",", "2.715565`", ",", 
           "2.715836`", ",", "2.716108`", ",", "2.71638`", ",", "2.716651`", ",",
            "2.716651`", ",", "2.716923`", ",", "2.716923`", ",", "2.717195`",
            ",", "2.717466`", ",", "2.717466`", ",", "2.717738`", ",", 
           "2.717738`", ",", "2.717738`", ",", "2.71801`", ",", "2.71801`", ",",
            "2.71801`", ",", "2.71801`", ",", "2.71801`"}], "}"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"cg1list", "=", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.00804`"}], ",", 
           RowBox[{"-", "0.00275`"}], ",", 
           RowBox[{"-", "0.00804`"}], ",", 
           RowBox[{"-", "0.008113`"}], ",", 
           RowBox[{"-", "0.008155`"}], ",", 
           RowBox[{"-", "0.00823`"}], ",", 
           RowBox[{"-", "0.008351`"}], ",", 
           RowBox[{"-", "0.008387`"}], ",", 
           RowBox[{"-", "0.008454`"}], ",", 
           RowBox[{"-", "0.008564`"}], ",", 
           RowBox[{"-", "0.008599`"}], ",", 
           RowBox[{"-", "0.008754`"}], ",", 
           RowBox[{"-", "0.008833`"}], ",", 
           RowBox[{"-", "0.008906`"}], ",", 
           RowBox[{"-", "0.008945`"}], ",", 
           RowBox[{"-", "0.008984`"}], ",", 
           RowBox[{"-", "0.00905`"}], ",", 
           RowBox[{"-", "0.009121`"}], ",", 
           RowBox[{"-", "0.009288`"}], ",", 
           RowBox[{"-", "0.009433`"}], ",", 
           RowBox[{"-", "0.009561`"}], ",", 
           RowBox[{"-", "0.009603`"}], ",", 
           RowBox[{"-", "0.009656`"}], ",", 
           RowBox[{"-", "0.009733`"}], ",", 
           RowBox[{"-", "0.009782`"}], ",", 
           RowBox[{"-", "0.009808`"}], ",", 
           RowBox[{"-", "0.009809`"}], ",", 
           RowBox[{"-", "0.009788`"}], ",", 
           RowBox[{"-", "0.009753`"}], ",", 
           RowBox[{"-", "0.009627`"}], ",", 
           RowBox[{"-", "0.00946`"}], ",", 
           RowBox[{"-", "0.009269`"}], ",", 
           RowBox[{"-", "0.009205`"}], ",", 
           RowBox[{"-", "0.009054`"}], ",", 
           RowBox[{"-", "0.008832`"}], ",", 
           RowBox[{"-", "0.00861`"}], ",", 
           RowBox[{"-", "0.008398`"}], ",", 
           RowBox[{"-", "0.008183`"}], ",", 
           RowBox[{"-", "0.007976`"}], ",", 
           RowBox[{"-", "0.007776`"}], ",", 
           RowBox[{"-", "0.007397`"}], ",", 
           RowBox[{"-", "0.007044`"}], ",", 
           RowBox[{"-", "0.006877`"}], ",", 
           RowBox[{"-", "0.006715`"}], ",", 
           RowBox[{"-", "0.006408`"}], ",", 
           RowBox[{"-", "0.006263`"}], ",", 
           RowBox[{"-", "0.006123`"}], ",", 
           RowBox[{"-", "0.005859`"}], ",", 
           RowBox[{"-", "0.005614`"}], ",", 
           RowBox[{"-", "0.005497`"}], ",", 
           RowBox[{"-", "0.005386`"}], ",", 
           RowBox[{"-", "0.005175`"}], ",", 
           RowBox[{"-", "0.00498`"}], ",", 
           RowBox[{"-", "0.004799`"}], ",", 
           RowBox[{"-", "0.004632`"}], ",", 
           RowBox[{"-", "0.004552`"}], ",", 
           RowBox[{"-", "0.004477`"}], ",", 
           RowBox[{"-", "0.004332`"}], ",", 
           RowBox[{"-", "0.004199`"}], ",", 
           RowBox[{"-", "0.003903`"}], ",", 
           RowBox[{"-", "0.003652`"}], ",", 
           RowBox[{"-", "0.003435`"}], ",", 
           RowBox[{"-", "0.003368`"}], ",", 
           RowBox[{"-", "0.003246`"}], ",", 
           RowBox[{"-", "0.003078`"}], ",", 
           RowBox[{"-", "0.002929`"}], ",", 
           RowBox[{"-", "0.002795`"}], ",", 
           RowBox[{"-", "0.002674`"}], ",", 
           RowBox[{"-", "0.002564`"}], ",", 
           RowBox[{"-", "0.002464`"}], ",", 
           RowBox[{"-", "0.002287`"}], ",", 
           RowBox[{"-", "0.002138`"}], ",", 
           RowBox[{"-", "0.00201`"}], ",", 
           RowBox[{"-", "0.001898`"}], ",", 
           RowBox[{"-", "0.001802`"}], ",", 
           RowBox[{"-", "0.001717`"}], ",", 
           RowBox[{"-", "0.001643`"}], ",", 
           RowBox[{"-", "0.001578`"}], ",", 
           RowBox[{"-", "0.001519`"}], ",", 
           RowBox[{"-", "0.001467`"}], ",", 
           RowBox[{"-", "0.001381`"}], ",", 
           RowBox[{"-", "0.001311`"}], ",", 
           RowBox[{"-", "0.001281`"}], ",", 
           RowBox[{"-", "0.001255`"}], ",", 
           RowBox[{"-", "0.001209`"}], ",", 
           RowBox[{"-", "0.001172`"}], ",", 
           RowBox[{"-", "0.001142`"}], ",", 
           RowBox[{"-", "0.001117`"}], ",", 
           RowBox[{"-", "0.001106`"}], ",", 
           RowBox[{"-", "0.001096`"}], ",", 
           RowBox[{"-", "0.001079`"}], ",", 
           RowBox[{"-", "0.001065`"}], ",", 
           RowBox[{"-", "0.001052`"}], ",", 
           RowBox[{"-", "0.001042`"}], ",", 
           RowBox[{"-", "0.001032`"}], ",", 
           RowBox[{"-", "0.001024`"}], ",", 
           RowBox[{"-", "0.001016`"}], ",", 
           RowBox[{"-", "0.000999`"}], ",", 
           RowBox[{"-", "0.000987`"}], ",", 
           RowBox[{"-", "0.000977`"}], ",", 
           RowBox[{"-", "0.000968`"}], ",", 
           RowBox[{"-", "0.000961`"}], ",", 
           RowBox[{"-", "0.000955`"}], ",", 
           RowBox[{"-", "0.00095`"}], ",", 
           RowBox[{"-", "0.000945`"}], ",", 
           RowBox[{"-", "0.000941`"}], ",", 
           RowBox[{"-", "0.000937`"}]}], "}"}]}], ";", "\[IndentingNewLine]", 
        
        RowBox[{"cg2list", "=", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.00785`"}], ",", 
           RowBox[{"-", "0.00625`"}], ",", 
           RowBox[{"-", "0.00785`"}], ",", 
           RowBox[{"-", "0.007921`"}], ",", 
           RowBox[{"-", "0.007962`"}], ",", 
           RowBox[{"-", "0.008035`"}], ",", 
           RowBox[{"-", "0.008154`"}], ",", 
           RowBox[{"-", "0.008189`"}], ",", 
           RowBox[{"-", "0.008255`"}], ",", 
           RowBox[{"-", "0.008362`"}], ",", 
           RowBox[{"-", "0.008396`"}], ",", 
           RowBox[{"-", "0.008547`"}], ",", 
           RowBox[{"-", "0.008624`"}], ",", 
           RowBox[{"-", "0.008696`"}], ",", 
           RowBox[{"-", "0.008734`"}], ",", 
           RowBox[{"-", "0.008771`"}], ",", 
           RowBox[{"-", "0.008836`"}], ",", 
           RowBox[{"-", "0.008906`"}], ",", 
           RowBox[{"-", "0.009068`"}], ",", 
           RowBox[{"-", "0.00921`"}], ",", 
           RowBox[{"-", "0.009335`"}], ",", 
           RowBox[{"-", "0.009376`"}], ",", 
           RowBox[{"-", "0.009428`"}], ",", 
           RowBox[{"-", "0.009503`"}], ",", 
           RowBox[{"-", "0.00955`"}], ",", 
           RowBox[{"-", "0.009577`"}], ",", 
           RowBox[{"-", "0.009577`"}], ",", 
           RowBox[{"-", "0.009557`"}], ",", 
           RowBox[{"-", "0.009522`"}], ",", 
           RowBox[{"-", "0.0094`"}], ",", 
           RowBox[{"-", "0.009236`"}], ",", 
           RowBox[{"-", "0.00905`"}], ",", 
           RowBox[{"-", "0.008988`"}], ",", 
           RowBox[{"-", "0.00884`"}], ",", 
           RowBox[{"-", "0.008623`"}], ",", 
           RowBox[{"-", "0.008406`"}], ",", 
           RowBox[{"-", "0.008199`"}], ",", 
           RowBox[{"-", "0.007989`"}], ",", 
           RowBox[{"-", "0.007787`"}], ",", 
           RowBox[{"-", "0.007592`"}], ",", 
           RowBox[{"-", "0.007222`"}], ",", 
           RowBox[{"-", "0.006878`"}], ",", 
           RowBox[{"-", "0.006714`"}], ",", 
           RowBox[{"-", "0.006556`"}], ",", 
           RowBox[{"-", "0.006257`"}], ",", 
           RowBox[{"-", "0.006115`"}], ",", 
           RowBox[{"-", "0.005979`"}], ",", 
           RowBox[{"-", "0.00572`"}], ",", 
           RowBox[{"-", "0.005481`"}], ",", 
           RowBox[{"-", "0.005368`"}], ",", 
           RowBox[{"-", "0.005259`"}], ",", 
           RowBox[{"-", "0.005053`"}], ",", 
           RowBox[{"-", "0.004862`"}], ",", 
           RowBox[{"-", "0.004686`"}], ",", 
           RowBox[{"-", "0.004522`"}], ",", 
           RowBox[{"-", "0.004445`"}], ",", 
           RowBox[{"-", "0.004371`"}], ",", 
           RowBox[{"-", "0.00423`"}], ",", 
           RowBox[{"-", "0.0041`"}], ",", 
           RowBox[{"-", "0.003811`"}], ",", 
           RowBox[{"-", "0.003565`"}], ",", 
           RowBox[{"-", "0.003354`"}], ",", 
           RowBox[{"-", "0.003288`"}], ",", 
           RowBox[{"-", "0.003169`"}], ",", 
           RowBox[{"-", "0.003005`"}], ",", 
           RowBox[{"-", "0.00286`"}], ",", 
           RowBox[{"-", "0.002729`"}], ",", 
           RowBox[{"-", "0.002611`"}], ",", 
           RowBox[{"-", "0.002504`"}], ",", 
           RowBox[{"-", "0.002406`"}], ",", 
           RowBox[{"-", "0.002233`"}], ",", 
           RowBox[{"-", "0.002087`"}], ",", 
           RowBox[{"-", "0.001962`"}], ",", 
           RowBox[{"-", "0.001854`"}], ",", 
           RowBox[{"-", "0.001759`"}], ",", 
           RowBox[{"-", "0.001677`"}], ",", 
           RowBox[{"-", "0.001604`"}], ",", 
           RowBox[{"-", "0.00154`"}], ",", 
           RowBox[{"-", "0.001483`"}], ",", 
           RowBox[{"-", "0.001433`"}], ",", 
           RowBox[{"-", "0.001348`"}], ",", 
           RowBox[{"-", "0.00128`"}], ",", 
           RowBox[{"-", "0.001251`"}], ",", 
           RowBox[{"-", "0.001225`"}], ",", 
           RowBox[{"-", "0.001181`"}], ",", 
           RowBox[{"-", "0.001145`"}], ",", 
           RowBox[{"-", "0.001115`"}], ",", 
           RowBox[{"-", "0.001091`"}], ",", 
           RowBox[{"-", "0.00108`"}], ",", 
           RowBox[{"-", "0.001071`"}], ",", 
           RowBox[{"-", "0.001054`"}], ",", 
           RowBox[{"-", "0.00104`"}], ",", 
           RowBox[{"-", "0.001027`"}], ",", 
           RowBox[{"-", "0.001017`"}], ",", 
           RowBox[{"-", "0.001007`"}], ",", 
           RowBox[{"-", "0.000999`"}], ",", 
           RowBox[{"-", "0.000992`"}], ",", 
           RowBox[{"-", "0.000976`"}], ",", 
           RowBox[{"-", "0.000964`"}], ",", 
           RowBox[{"-", "0.000954`"}], ",", 
           RowBox[{"-", "0.000945`"}], ",", 
           RowBox[{"-", "0.000938`"}], ",", 
           RowBox[{"-", "0.000933`"}], ",", 
           RowBox[{"-", "0.000927`"}], ",", 
           RowBox[{"-", "0.000923`"}], ",", 
           RowBox[{"-", "0.000919`"}], ",", 
           RowBox[{"-", "0.000914`"}]}], "}"}]}], ";", "\[IndentingNewLine]", 
        
        RowBox[{"phi1list", "=", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.4417`"}], ",", 
           RowBox[{"-", "0.7861`"}], ",", 
           RowBox[{"-", "0.4417`"}], ",", 
           RowBox[{"-", "0.434`"}], ",", 
           RowBox[{"-", "0.4313`"}], ",", 
           RowBox[{"-", "0.4267`"}], ",", 
           RowBox[{"-", "0.4196`"}], ",", 
           RowBox[{"-", "0.4177`"}], ",", 
           RowBox[{"-", "0.4139`"}], ",", 
           RowBox[{"-", "0.4082`"}], ",", 
           RowBox[{"-", "0.4064`"}], ",", 
           RowBox[{"-", "0.4`"}], ",", 
           RowBox[{"-", "0.3973`"}], ",", 
           RowBox[{"-", "0.3949`"}], ",", 
           RowBox[{"-", "0.3939`"}], ",", 
           RowBox[{"-", "0.393`"}], ",", 
           RowBox[{"-", "0.3914`"}], ",", 
           RowBox[{"-", "0.3903`"}], ",", 
           RowBox[{"-", "0.3892`"}], ",", 
           RowBox[{"-", "0.3903`"}], ",", 
           RowBox[{"-", "0.3934`"}], ",", 
           RowBox[{"-", "0.3951`"}], ",", 
           RowBox[{"-", "0.3981`"}], ",", 
           RowBox[{"-", "0.404`"}], ",", 
           RowBox[{"-", "0.4108`"}], ",", 
           RowBox[{"-", "0.4182`"}], ",", 
           RowBox[{"-", "0.4261`"}], ",", 
           RowBox[{"-", "0.4341`"}], ",", 
           RowBox[{"-", "0.4423`"}], ",", 
           RowBox[{"-", "0.4585`"}], ",", 
           RowBox[{"-", "0.4743`"}], ",", 
           RowBox[{"-", "0.4892`"}], ",", 
           RowBox[{"-", "0.4935`"}], ",", 
           RowBox[{"-", "0.5032`"}], ",", 
           RowBox[{"-", "0.5162`"}], ",", 
           RowBox[{"-", "0.5283`"}], ",", 
           RowBox[{"-", "0.5396`"}], ",", 
           RowBox[{"-", "0.5502`"}], ",", 
           RowBox[{"-", "0.5602`"}], ",", 
           RowBox[{"-", "0.5697`"}], ",", 
           RowBox[{"-", "0.5873`"}], ",", 
           RowBox[{"-", "0.6034`"}], ",", 
           RowBox[{"-", "0.6109`"}], ",", 
           RowBox[{"-", "0.6182`"}], ",", 
           RowBox[{"-", "0.6319`"}], ",", 
           RowBox[{"-", "0.6383`"}], ",", 
           RowBox[{"-", "0.6444`"}], ",", 
           RowBox[{"-", "0.6559`"}], ",", 
           RowBox[{"-", "0.6665`"}], ",", 
           RowBox[{"-", "0.6715`"}], ",", 
           RowBox[{"-", "0.6762`"}], ",", 
           RowBox[{"-", "0.685`"}], ",", 
           RowBox[{"-", "0.6931`"}], ",", 
           RowBox[{"-", "0.7005`"}], ",", 
           RowBox[{"-", "0.7072`"}], ",", 
           RowBox[{"-", "0.7104`"}], ",", 
           RowBox[{"-", "0.7135`"}], ",", 
           RowBox[{"-", "0.7193`"}], ",", 
           RowBox[{"-", "0.7246`"}], ",", 
           RowBox[{"-", "0.7365`"}], ",", 
           RowBox[{"-", "0.7468`"}], ",", 
           RowBox[{"-", "0.7557`"}], ",", 
           RowBox[{"-", "0.7585`"}], ",", 
           RowBox[{"-", "0.7636`"}], ",", 
           RowBox[{"-", "0.7708`"}], ",", 
           RowBox[{"-", "0.7773`"}], ",", 
           RowBox[{"-", "0.7833`"}], ",", 
           RowBox[{"-", "0.7888`"}], ",", 
           RowBox[{"-", "0.7941`"}], ",", 
           RowBox[{"-", "0.799`"}], ",", 
           RowBox[{"-", "0.8082`"}], ",", 
           RowBox[{"-", "0.8165`"}], ",", 
           RowBox[{"-", "0.8243`"}], ",", 
           RowBox[{"-", "0.8315`"}], ",", 
           RowBox[{"-", "0.8382`"}], ",", 
           RowBox[{"-", "0.8445`"}], ",", 
           RowBox[{"-", "0.8504`"}], ",", 
           RowBox[{"-", "0.856`"}], ",", 
           RowBox[{"-", "0.8613`"}], ",", 
           RowBox[{"-", "0.8663`"}], ",", 
           RowBox[{"-", "0.8755`"}], ",", 
           RowBox[{"-", "0.8836`"}], ",", 
           RowBox[{"-", "0.8874`"}], ",", 
           RowBox[{"-", "0.8909`"}], ",", 
           RowBox[{"-", "0.8974`"}], ",", 
           RowBox[{"-", "0.9032`"}], ",", 
           RowBox[{"-", "0.9083`"}], ",", 
           RowBox[{"-", "0.913`"}], ",", 
           RowBox[{"-", "0.9151`"}], ",", 
           RowBox[{"-", "0.917`"}], ",", 
           RowBox[{"-", "0.9205`"}], ",", 
           RowBox[{"-", "0.9231`"}], ",", 
           RowBox[{"-", "0.9249`"}], ",", 
           RowBox[{"-", "0.9257`"}], ",", 
           RowBox[{"-", "0.9255`"}], ",", 
           RowBox[{"-", "0.9243`"}], ",", 
           RowBox[{"-", "0.9222`"}], ",", 
           RowBox[{"-", "0.9129`"}], ",", 
           RowBox[{"-", "0.8982`"}], ",", 
           RowBox[{"-", "0.8791`"}], ",", 
           RowBox[{"-", "0.8572`"}], ",", 
           RowBox[{"-", "0.8346`"}], ",", 
           RowBox[{"-", "0.8126`"}], ",", 
           RowBox[{"-", "0.7914`"}], ",", 
           RowBox[{"-", "0.7711`"}], ",", 
           RowBox[{"-", "0.7517`"}], ",", 
           RowBox[{"-", "0.7332`"}]}], "}"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"phi2list", "=", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.1417`"}], ",", 
           RowBox[{"-", "0.0699`"}], ",", 
           RowBox[{"-", "0.1417`"}], ",", 
           RowBox[{"-", "0.1364`"}], ",", 
           RowBox[{"-", "0.1361`"}], ",", 
           RowBox[{"-", "0.1365`"}], ",", 
           RowBox[{"-", "0.1392`"}], ",", 
           RowBox[{"-", "0.1403`"}], ",", 
           RowBox[{"-", "0.143`"}], ",", 
           RowBox[{"-", "0.1482`"}], ",", 
           RowBox[{"-", "0.1502`"}], ",", 
           RowBox[{"-", "0.1591`"}], ",", 
           RowBox[{"-", "0.1641`"}], ",", 
           RowBox[{"-", "0.1694`"}], ",", 
           RowBox[{"-", "0.1721`"}], ",", 
           RowBox[{"-", "0.1748`"}], ",", 
           RowBox[{"-", "0.1804`"}], ",", 
           RowBox[{"-", "0.1862`"}], ",", 
           RowBox[{"-", "0.2008`"}], ",", 
           RowBox[{"-", "0.2153`"}], ",", 
           RowBox[{"-", "0.2291`"}], ",", 
           RowBox[{"-", "0.2344`"}], ",", 
           RowBox[{"-", "0.242`"}], ",", 
           RowBox[{"-", "0.2538`"}], ",", 
           RowBox[{"-", "0.2644`"}], ",", 
           RowBox[{"-", "0.2739`"}], ",", 
           RowBox[{"-", "0.2819`"}], ",", 
           RowBox[{"-", "0.2887`"}], ",", 
           RowBox[{"-", "0.2943`"}], ",", 
           RowBox[{"-", "0.3025`"}], ",", 
           RowBox[{"-", "0.3077`"}], ",", 
           RowBox[{"-", "0.3106`"}], ",", 
           RowBox[{"-", "0.3111`"}], ",", 
           RowBox[{"-", "0.3118`"}], ",", 
           RowBox[{"-", "0.3113`"}], ",", 
           RowBox[{"-", "0.3093`"}], ",", 
           RowBox[{"-", "0.3062`"}], ",", 
           RowBox[{"-", "0.3022`"}], ",", 
           RowBox[{"-", "0.2976`"}], ",", 
           RowBox[{"-", "0.2927`"}], ",", 
           RowBox[{"-", "0.2823`"}], ",", 
           RowBox[{"-", "0.2716`"}], ",", 
           RowBox[{"-", "0.2662`"}], ",", 
           RowBox[{"-", "0.2609`"}], ",", 
           RowBox[{"-", "0.2505`"}], ",", 
           RowBox[{"-", "0.2455`"}], ",", 
           RowBox[{"-", "0.2405`"}], ",", 
           RowBox[{"-", "0.231`"}], ",", 
           RowBox[{"-", "0.222`"}], ",", 
           RowBox[{"-", "0.2177`"}], ",", 
           RowBox[{"-", "0.2135`"}], ",", 
           RowBox[{"-", "0.2053`"}], ",", 
           RowBox[{"-", "0.1975`"}], ",", 
           RowBox[{"-", "0.1901`"}], ",", 
           RowBox[{"-", "0.183`"}], ",", 
           RowBox[{"-", "0.1795`"}], ",", 
           RowBox[{"-", "0.1762`"}], ",", 
           RowBox[{"-", "0.1696`"}], ",", 
           RowBox[{"-", "0.1633`"}], ",", 
           RowBox[{"-", "0.1487`"}], ",", 
           RowBox[{"-", "0.1353`"}], ",", 
           RowBox[{"-", "0.1232`"}], ",", 
           RowBox[{"-", "0.1194`"}], ",", 
           RowBox[{"-", "0.1124`"}], ",", 
           RowBox[{"-", "0.1028`"}], ",", 
           RowBox[{"-", "0.0943`"}], ",", 
           RowBox[{"-", "0.0869`"}], ",", 
           RowBox[{"-", "0.0805`"}], ",", 
           RowBox[{"-", "0.0748`"}], ",", 
           RowBox[{"-", "0.0699`"}], ",", 
           RowBox[{"-", "0.0617`"}], ",", 
           RowBox[{"-", "0.0552`"}], ",", 
           RowBox[{"-", "0.0501`"}], ",", 
           RowBox[{"-", "0.0459`"}], ",", 
           RowBox[{"-", "0.0425`"}], ",", 
           RowBox[{"-", "0.0395`"}], ",", 
           RowBox[{"-", "0.0369`"}], ",", 
           RowBox[{"-", "0.0346`"}], ",", 
           RowBox[{"-", "0.0323`"}], ",", 
           RowBox[{"-", "0.0302`"}], ",", 
           RowBox[{"-", "0.0262`"}], ",", 
           RowBox[{"-", "0.0225`"}], ",", 
           RowBox[{"-", "0.0207`"}], ",", 
           RowBox[{"-", "0.019`"}], ",", 
           RowBox[{"-", "0.0159`"}], ",", 
           RowBox[{"-", "0.0129`"}], ",", 
           RowBox[{"-", "0.0102`"}], ",", 
           RowBox[{"-", "0.0077`"}], ",", 
           RowBox[{"-", "0.0066`"}], ",", 
           RowBox[{"-", "0.0055`"}], ",", 
           RowBox[{"-", "0.0036`"}], ",", 
           RowBox[{"-", "0.0016`"}], ",", "0.`", ",", "0.`", ",", "0.`", ",", 
           "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", 
           ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", 
           "0.`"}], "}"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"phi3list", "=", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.00701`"}], ",", 
           RowBox[{"-", "0.008444`"}], ",", 
           RowBox[{"-", "0.00701`"}], ",", 
           RowBox[{"-", "0.007279`"}], ",", 
           RowBox[{"-", "0.007301`"}], ",", 
           RowBox[{"-", "0.007364`"}], ",", 
           RowBox[{"-", "0.007378`"}], ",", 
           RowBox[{"-", "0.007354`"}], ",", 
           RowBox[{"-", "0.007281`"}], ",", 
           RowBox[{"-", "0.007162`"}], ",", 
           RowBox[{"-", "0.007129`"}], ",", 
           RowBox[{"-", "0.006977`"}], ",", 
           RowBox[{"-", "0.006878`"}], ",", 
           RowBox[{"-", "0.006765`"}], ",", 
           RowBox[{"-", "0.00671`"}], ",", 
           RowBox[{"-", "0.006656`"}], ",", 
           RowBox[{"-", "0.006556`"}], ",", 
           RowBox[{"-", "0.006467`"}], ",", 
           RowBox[{"-", "0.006279`"}], ",", 
           RowBox[{"-", "0.006117`"}], ",", 
           RowBox[{"-", "0.00597`"}], ",", 
           RowBox[{"-", "0.005914`"}], ",", 
           RowBox[{"-", "0.005835`"}], ",", 
           RowBox[{"-", "0.005734`"}], ",", 
           RowBox[{"-", "0.00567`"}], ",", 
           RowBox[{"-", "0.005632`"}], ",", 
           RowBox[{"-", "0.005607`"}], ",", 
           RowBox[{"-", "0.005597`"}], ",", 
           RowBox[{"-", "0.005604`"}], ",", 
           RowBox[{"-", "0.005644`"}], ",", 
           RowBox[{"-", "0.005696`"}], ",", 
           RowBox[{"-", "0.005744`"}], ",", 
           RowBox[{"-", "0.005758`"}], ",", 
           RowBox[{"-", "0.005794`"}], ",", 
           RowBox[{"-", "0.005845`"}], ",", 
           RowBox[{"-", "0.005901`"}], ",", 
           RowBox[{"-", "0.005959`"}], ",", 
           RowBox[{"-", "0.006019`"}], ",", 
           RowBox[{"-", "0.00608`"}], ",", 
           RowBox[{"-", "0.006141`"}], ",", 
           RowBox[{"-", "0.006262`"}], ",", 
           RowBox[{"-", "0.006381`"}], ",", 
           RowBox[{"-", "0.006439`"}], ",", 
           RowBox[{"-", "0.006495`"}], ",", 
           RowBox[{"-", "0.006604`"}], ",", 
           RowBox[{"-", "0.006655`"}], ",", 
           RowBox[{"-", "0.006704`"}], ",", 
           RowBox[{"-", "0.006795`"}], ",", 
           RowBox[{"-", "0.006882`"}], ",", 
           RowBox[{"-", "0.006923`"}], ",", 
           RowBox[{"-", "0.006965`"}], ",", 
           RowBox[{"-", "0.007047`"}], ",", 
           RowBox[{"-", "0.007125`"}], ",", 
           RowBox[{"-", "0.007194`"}], ",", 
           RowBox[{"-", "0.007259`"}], ",", 
           RowBox[{"-", "0.00729`"}], ",", 
           RowBox[{"-", "0.00732`"}], ",", 
           RowBox[{"-", "0.007378`"}], ",", 
           RowBox[{"-", "0.007435`"}], ",", 
           RowBox[{"-", "0.007579`"}], ",", 
           RowBox[{"-", "0.00772`"}], ",", 
           RowBox[{"-", "0.007863`"}], ",", 
           RowBox[{"-", "0.007911`"}], ",", 
           RowBox[{"-", "0.008001`"}], ",", 
           RowBox[{"-", "0.00812`"}], ",", 
           RowBox[{"-", "0.008223`"}], ",", 
           RowBox[{"-", "0.008313`"}], ",", 
           RowBox[{"-", "0.008381`"}], ",", 
           RowBox[{"-", "0.008423`"}], ",", 
           RowBox[{"-", "0.008444`"}], ",", 
           RowBox[{"-", "0.0085`"}], ",", 
           RowBox[{"-", "0.008478`"}], ",", 
           RowBox[{"-", "0.008307`"}], ",", 
           RowBox[{"-", "0.008042`"}], ",", 
           RowBox[{"-", "0.007707`"}], ",", 
           RowBox[{"-", "0.007317`"}], ",", 
           RowBox[{"-", "0.006862`"}], ",", 
           RowBox[{"-", "0.006265`"}], ",", 
           RowBox[{"-", "0.005541`"}], ",", 
           RowBox[{"-", "0.004792`"}], ",", 
           RowBox[{"-", "0.003555`"}], ",", 
           RowBox[{"-", "0.002764`"}], ",", 
           RowBox[{"-", "0.002497`"}], ",", 
           RowBox[{"-", "0.002292`"}], ",", 
           RowBox[{"-", "0.002007`"}], ",", 
           RowBox[{"-", "0.001828`"}], ",", 
           RowBox[{"-", "0.001713`"}], ",", 
           RowBox[{"-", "0.001636`"}], ",", 
           RowBox[{"-", "0.001608`"}], ",", 
           RowBox[{"-", "0.001585`"}], ",", 
           RowBox[{"-", "0.001549`"}], ",", 
           RowBox[{"-", "0.001523`"}], ",", 
           RowBox[{"-", "0.001501`"}], ",", 
           RowBox[{"-", "0.001483`"}], ",", 
           RowBox[{"-", "0.001467`"}], ",", 
           RowBox[{"-", "0.001453`"}], ",", 
           RowBox[{"-", "0.00144`"}], ",", 
           RowBox[{"-", "0.001416`"}], ",", 
           RowBox[{"-", "0.001397`"}], ",", 
           RowBox[{"-", "0.001384`"}], ",", 
           RowBox[{"-", "0.001375`"}], ",", 
           RowBox[{"-", "0.001369`"}], ",", 
           RowBox[{"-", "0.001364`"}], ",", 
           RowBox[{"-", "0.001362`"}], ",", 
           RowBox[{"-", "0.00136`"}], ",", 
           RowBox[{"-", "0.00136`"}], ",", 
           RowBox[{"-", "0.001361`"}]}], "}"}]}], ";", "\[IndentingNewLine]", 
        
        RowBox[{"phi4list", "=", 
         RowBox[{"{", 
          RowBox[{
          "0.102151`", ",", "5.41`", ",", "0.102151`", ",", "0.10836`", ",", 
           "0.110372`", ",", "0.11371`", ",", "0.1186`", ",", "0.119888`", ",",
            "0.122493`", ",", "0.12654`", ",", "0.127926`", ",", "0.133641`", 
           ",", "0.136572`", ",", "0.139596`", ",", "0.141112`", ",", 
           "0.142659`", ",", "0.145774`", ",", "0.148927`", ",", "0.157001`", 
           ",", "0.165249`", ",", "0.173635`", ",", "0.177001`", ",", 
           "0.182082`", ",", "0.190596`", ",", "0.199129`", ",", "0.207505`", 
           ",", "0.215628`", ",", "0.223398`", ",", "0.230662`", ",", 
           "0.243315`", ",", "0.253169`", ",", "0.260175`", ",", "0.261767`", 
           ",", "0.264504`", ",", "0.266468`", ",", "0.266468`", ",", 
           "0.26506`", ",", "0.262501`", ",", "0.259163`", ",", "0.255253`", ",",
            "0.246252`", ",", "0.236525`", ",", "0.231541`", ",", "0.22657`", 
           ",", "0.216796`", ",", "0.211993`", ",", "0.207277`", ",", 
           "0.198077`", ",", "0.189304`", ",", "0.185074`", ",", "0.18092`", ",",
            "0.172976`", ",", "0.165464`", ",", "0.158358`", ",", "0.151662`",
            ",", "0.148466`", ",", "0.145352`", ",", "0.139415`", ",", 
           "0.133828`", ",", "0.121226`", ",", "0.110339`", ",", "0.100842`", 
           ",", "0.097891`", ",", "0.092504`", ",", "0.085153`", ",", 
           "0.078622`", ",", "0.072788`", ",", "0.067563`", ",", "0.06285`", ",",
            "0.058595`", ",", "0.051206`", ",", "0.045054`", ",", "0.039879`",
            ",", "0.035504`", ",", "0.031787`", ",", "0.028613`", ",", 
           "0.02589`", ",", "0.023537`", ",", "0.021496`", ",", "0.019716`", ",",
            "0.016771`", ",", "0.014434`", ",", "0.013436`", ",", "0.012534`",
            ",", "0.010962`", ",", "0.009643`", ",", "0.008521`", ",", 
           "0.007561`", ",", "0.00713`", ",", "0.00673`", ",", "0.006008`", ",",
            "0.005379`", ",", "0.00483`", ",", "0.004349`", ",", "0.003925`", 
           ",", "0.003553`", ",", "0.003223`", ",", "0.002551`", ",", 
           "0.002047`", ",", "0.001662`", ",", "0.001366`", ",", "0.001134`", 
           ",", "0.000952`", ",", "0.000806`", ",", "0.000689`", ",", 
           "0.000593`", ",", "0.000515`"}], "}"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"phi5list", "=", 
         RowBox[{"{", 
          RowBox[{
          "0.2289`", ",", "0.2899`", ",", "0.2289`", ",", "0.2289`", ",", 
           "0.2289`", ",", "0.2289`", ",", "0.2289`", ",", "0.2289`", ",", 
           "0.2289`", ",", "0.2289`", ",", "0.2289`", ",", "0.2289`", ",", 
           "0.2289`", ",", "0.229`", ",", "0.229`", ",", "0.229`", ",", 
           "0.229`", ",", "0.229`", ",", "0.229`", ",", "0.229`", ",", 
           "0.2291`", ",", "0.2291`", ",", "0.2291`", ",", "0.2292`", ",", 
           "0.2293`", ",", "0.2294`", ",", "0.2295`", ",", "0.2296`", ",", 
           "0.2297`", ",", "0.2302`", ",", "0.2305`", ",", "0.2311`", ",", 
           "0.2313`", ",", "0.2319`", ",", "0.2326`", ",", "0.2334`", ",", 
           "0.2348`", ",", "0.2361`", ",", "0.2374`", ",", "0.2386`", ",", 
           "0.2433`", ",", "0.2477`", ",", "0.2497`", ",", "0.2533`", ",", 
           "0.2606`", ",", "0.2641`", ",", "0.2674`", ",", "0.2746`", ",", 
           "0.2847`", ",", "0.2895`", ",", "0.2942`", ",", "0.3032`", ",", 
           "0.312`", ",", "0.3227`", ",", "0.3329`", ",", "0.3378`", ",", 
           "0.3427`", ",", "0.352`", ",", "0.361`", ",", "0.381`", ",", 
           "0.3993`", ",", "0.4142`", ",", "0.418`", ",", "0.4252`", ",", 
           "0.4353`", ",", "0.4444`", ",", "0.4494`", ",", "0.4542`", ",", 
           "0.4587`", ",", "0.4629`", ",", "0.4668`", ",", "0.4703`", ",", 
           "0.4729`", ",", "0.4743`", ",", "0.4756`", ",", "0.4767`", ",", 
           "0.4772`", ",", "0.4777`", ",", "0.4781`", ",", "0.4785`", ",", 
           "0.4789`", ",", "0.4792`", ",", "0.4793`", ",", "0.4794`", ",", 
           "0.4795`", ",", "0.4796`", ",", "0.4797`", ",", "0.4798`", ",", 
           "0.4798`", ",", "0.4798`", ",", "0.4798`", ",", "0.4799`", ",", 
           "0.4799`", ",", "0.4799`", ",", "0.4799`", ",", "0.4799`", ",", 
           "0.4799`", ",", "0.48`", ",", "0.48`", ",", "0.48`", ",", "0.48`", 
           ",", "0.48`", ",", "0.48`", ",", "0.48`", ",", "0.48`", ",", 
           "0.48`", ",", "0.48`"}], "}"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"phi6list", "=", 
         RowBox[{"{", 
          RowBox[{
          "0.014996`", ",", "0.006718`", ",", "0.014996`", ",", "0.014996`", ",",
            "0.014996`", ",", "0.014996`", ",", "0.014996`", ",", "0.014996`",
            ",", "0.014996`", ",", "0.014996`", ",", "0.014996`", ",", 
           "0.014996`", ",", "0.014996`", ",", "0.014996`", ",", "0.014996`", 
           ",", "0.014996`", ",", "0.014996`", ",", "0.014996`", ",", 
           "0.014996`", ",", "0.014996`", ",", "0.014996`", ",", "0.014996`", 
           ",", "0.014996`", ",", "0.014996`", ",", "0.014996`", ",", 
           "0.014996`", ",", "0.014996`", ",", "0.014996`", ",", "0.014996`", 
           ",", "0.014994`", ",", "0.014994`", ",", "0.014993`", ",", 
           "0.014993`", ",", "0.014991`", ",", "0.014988`", ",", "0.014987`", 
           ",", "0.014981`", ",", "0.014975`", ",", "0.01497`", ",", 
           "0.014964`", ",", "0.014928`", ",", "0.014895`", ",", "0.014881`", 
           ",", "0.014832`", ",", "0.014731`", ",", "0.014684`", ",", 
           "0.014639`", ",", "0.014513`", ",", "0.014239`", ",", "0.01411`", ",",
            "0.013985`", ",", "0.013747`", ",", "0.013493`", ",", "0.012938`",
            ",", "0.012429`", ",", "0.01219`", ",", "0.011962`", ",", 
           "0.011532`", ",", "0.011133`", ",", "0.009769`", ",", "0.00866`", ",",
            "0.007829`", ",", "0.00762`", ",", "0.007244`", ",", "0.006739`", 
           ",", "0.006325`", ",", "0.006163`", ",", "0.006014`", ",", 
           "0.005876`", ",", "0.005749`", ",", "0.005678`", ",", "0.005613`", 
           ",", "0.005573`", ",", "0.005558`", ",", "0.005544`", ",", 
           "0.005533`", ",", "0.005529`", ",", "0.005527`", ",", "0.005524`", 
           ",", "0.005521`", ",", "0.005519`", ",", "0.005518`", ",", 
           "0.005518`", ",", "0.005518`", ",", "0.005517`", ",", "0.005517`", 
           ",", "0.005517`", ",", "0.005517`", ",", "0.005517`", ",", 
           "0.005517`", ",", "0.005517`", ",", "0.005517`", ",", "0.005517`", 
           ",", "0.005517`", ",", "0.005517`", ",", "0.005517`", ",", 
           "0.005517`", ",", "0.005517`", ",", "0.005517`", ",", "0.005517`", 
           ",", "0.005517`", ",", "0.005517`", ",", "0.005517`", ",", 
           "0.005517`", ",", "0.005517`", ",", "0.005517`", ",", 
           "0.005517`"}], "}"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"phi7list", "=", 
         RowBox[{"{", 
          RowBox[{
          "580.`", ",", "459.`", ",", "580.`", ",", "580.`", ",", "580.`", ",",
            "580.`", ",", "580.`", ",", "580.`", ",", "580.`", ",", "580.`", ",",
            "580.`", ",", "579.9`", ",", "579.9`", ",", "579.9`", ",", 
           "579.9`", ",", "579.9`", ",", "579.9`", ",", "579.9`", ",", 
           "579.8`", ",", "579.8`", ",", "579.8`", ",", "579.7`", ",", 
           "579.7`", ",", "579.6`", ",", "579.6`", ",", "579.5`", ",", 
           "579.4`", ",", "579.3`", ",", "579.2`", ",", "578.8`", ",", 
           "578.6`", ",", "578.2`", ",", "578.`", ",", "577.7`", ",", 
           "577.2`", ",", "576.7`", ",", "576.`", ",", "575.2`", ",", 
           "574.6`", ",", "573.9`", ",", "571.6`", ",", "569.5`", ",", 
           "568.5`", ",", "566.9`", ",", "563.6`", ",", "562.`", ",", 
           "560.5`", ",", "557.3`", ",", "552.6`", ",", "550.4`", ",", 
           "548.3`", ",", "544.1`", ",", "540.`", ",", "534.`", ",", "528.4`",
            ",", "525.7`", ",", "523.`", ",", "517.8`", ",", "512.9`", ",", 
           "497.1`", ",", "482.7`", ",", "468.7`", ",", "463.9`", ",", 
           "454.8`", ",", "441.9`", ",", "429.9`", ",", "419.5`", ",", 
           "409.8`", ",", "400.5`", ",", "391.8`", ",", "379.6`", ",", 
           "368.5`", ",", "359.8`", ",", "353.7`", ",", "348.1`", ",", 
           "343.1`", ",", "340.2`", ",", "337.5`", ",", "334.9`", ",", 
           "332.5`", ",", "330.`", ",", "327.8`", ",", "326.7`", ",", 
           "326.1`", ",", "325.1`", ",", "324.1`", ",", "323.3`", ",", 
           "322.9`", ",", "322.7`", ",", "322.5`", ",", "322.1`", ",", 
           "321.7`", ",", "321.6`", ",", "321.4`", ",", "321.2`", ",", 
           "321.1`", ",", "320.9`", ",", "320.7`", ",", "320.6`", ",", 
           "320.4`", ",", "320.4`", ",", "320.3`", ",", "320.2`", ",", 
           "320.2`", ",", "320.2`", ",", "320.1`", ",", "320.1`"}], "}"}]}], ";",
         "\[IndentingNewLine]", 
        RowBox[{"phi8list", "=", 
         RowBox[{"{", 
          RowBox[{
          "0.07`", ",", "0.1138`", ",", "0.07`", ",", "0.07`", ",", "0.07`", ",",
            "0.07`", ",", "0.07`", ",", "0.07`", ",", "0.07`", ",", "0.07`", ",",
            "0.07`", ",", "0.07`", ",", "0.07`", ",", "0.07`", ",", "0.07`", ",",
            "0.07`", ",", "0.07`", ",", "0.07`", ",", "0.07`", ",", "0.0698`",
            ",", "0.0696`", ",", "0.0694`", ",", "0.0692`", ",", "0.0686`", ",",
            "0.0679`", ",", "0.0671`", ",", "0.0662`", ",", "0.0654`", ",", 
           "0.0646`", ",", "0.0635`", ",", "0.0625`", ",", "0.0602`", ",", 
           "0.0592`", ",", "0.056`", ",", "0.0494`", ",", "0.0407`", ",", 
           "0.0306`", ",", "0.0199`", ",", "0.0089`", ",", 
           RowBox[{"-", "0.0019`"}], ",", 
           RowBox[{"-", "0.0223`"}], ",", 
           RowBox[{"-", "0.0401`"}], ",", 
           RowBox[{"-", "0.0479`"}], ",", 
           RowBox[{"-", "0.0548`"}], ",", 
           RowBox[{"-", "0.0665`"}], ",", 
           RowBox[{"-", "0.0713`"}], ",", 
           RowBox[{"-", "0.0756`"}], ",", 
           RowBox[{"-", "0.0825`"}], ",", 
           RowBox[{"-", "0.0875`"}], ",", 
           RowBox[{"-", "0.0895`"}], ",", 
           RowBox[{"-", "0.0912`"}], ",", 
           RowBox[{"-", "0.0939`"}], ",", 
           RowBox[{"-", "0.096`"}], ",", 
           RowBox[{"-", "0.0975`"}], ",", 
           RowBox[{"-", "0.0987`"}], ",", 
           RowBox[{"-", "0.0991`"}], ",", 
           RowBox[{"-", "0.0994`"}], ",", 
           RowBox[{"-", "0.0998`"}], ",", 
           RowBox[{"-", "0.0998`"}], ",", 
           RowBox[{"-", "0.0983`"}], ",", 
           RowBox[{"-", "0.0948`"}], ",", 
           RowBox[{"-", "0.0896`"}], ",", 
           RowBox[{"-", "0.0876`"}], ",", 
           RowBox[{"-", "0.0834`"}], ",", 
           RowBox[{"-", "0.0765`"}], ",", 
           RowBox[{"-", "0.0693`"}], ",", 
           RowBox[{"-", "0.062`"}], ",", 
           RowBox[{"-", "0.0549`"}], ",", 
           RowBox[{"-", "0.0479`"}], ",", 
           RowBox[{"-", "0.0412`"}], ",", 
           RowBox[{"-", "0.0285`"}], ",", 
           RowBox[{"-", "0.0167`"}], ",", 
           RowBox[{"-", "0.0057`"}], ",", "0.0045`", ",", "0.014`", ",", 
           "0.0229`", ",", "0.0313`", ",", "0.0393`", ",", "0.0469`", ",", 
           "0.0544`", ",", "0.0687`", ",", "0.0826`", ",", "0.0895`", ",", 
           "0.0963`", ",", "0.1098`", ",", "0.1232`", ",", "0.1366`", ",", 
           "0.1498`", ",", "0.1562`", ",", "0.1625`", ",", "0.1746`", ",", 
           "0.1859`", ",", "0.1964`", ",", "0.206`", ",", "0.2147`", ",", 
           "0.2225`", ",", "0.2295`", ",", "0.2435`", ",", "0.2532`", ",", 
           "0.2595`", ",", "0.2635`", ",", "0.266`", ",", "0.2675`", ",", 
           "0.2683`", ",", "0.2686`", ",", "0.2685`", ",", "0.2682`"}], 
          "}"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"tau1list", "=", 
         RowBox[{"{", 
          RowBox[{
          "0.3437`", ",", "0.2539`", ",", "0.3437`", ",", "0.3471`", ",", 
           "0.3505`", ",", "0.3538`", ",", "0.3571`", ",", "0.3603`", ",", 
           "0.3633`", ",", "0.3663`", ",", "0.3691`", ",", "0.3718`", ",", 
           "0.3744`", ",", "0.3768`", ",", "0.3791`", ",", "0.3811`", ",", 
           "0.3831`", ",", "0.3848`", ",", "0.3863`", ",", "0.3876`", ",", 
           "0.3877`", ",", "0.3881`", ",", "0.3883`", ",", "0.3878`", ",", 
           "0.3872`", ",", "0.3865`", ",", "0.3856`", ",", "0.3846`", ",", 
           "0.3835`", ",", "0.3816`", ",", "0.3795`", ",", "0.3775`", ",", 
           "0.3761`", ",", "0.3742`", ",", "0.3719`", ",", "0.3696`", ",", 
           "0.3672`", ",", "0.3649`", ",", "0.3626`", ",", "0.3601`", ",", 
           "0.3572`", ",", "0.3543`", ",", "0.3522`", ",", "0.35`", ",", 
           "0.3474`", ",", "0.3455`", ",", "0.3438`", ",", "0.3417`", ",", 
           "0.3398`", ",", "0.3386`", ",", "0.3375`", ",", "0.3362`", ",", 
           "0.3351`", ",", "0.3344`", ",", "0.3339`", ",", "0.334`", ",", 
           "0.3344`", ",", "0.3346`", ",", "0.3353`", ",", "0.3354`", ",", 
           "0.336`", ",", "0.3369`", ",", "0.339`", ",", "0.3409`", ",", 
           "0.3429`", ",", "0.3452`", ",", "0.3478`", ",", "0.3508`", ",", 
           "0.3541`", ",", "0.3577`", ",", "0.3608`", ",", "0.3644`", ",", 
           "0.3682`", ",", "0.3725`", ",", "0.3769`", ",", "0.3816`", ",", 
           "0.3865`", ",", "0.3916`", ",", "0.3968`", ",", "0.4023`", ",", 
           "0.4085`", ",", "0.4149`", ",", "0.4212`", ",", "0.4277`", ",", 
           "0.4341`", ",", "0.4406`", ",", "0.447`", ",", "0.4534`", ",", 
           "0.4598`", ",", "0.4661`", ",", "0.4723`", ",", "0.4784`", ",", 
           "0.4845`", ",", "0.4904`", ",", "0.4962`", ",", "0.5019`", ",", 
           "0.5074`", ",", "0.5128`", ",", "0.5181`", ",", "0.5232`", ",", 
           "0.5281`", ",", "0.5328`", ",", "0.5374`", ",", "0.5419`", ",", 
           "0.5461`", ",", "0.5502`", ",", "0.5542`"}], "}"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"tau2list", "=", 
         RowBox[{"{", 
          RowBox[{
          "0.2637`", ",", "0.2381`", ",", "0.2637`", ",", "0.2671`", ",", 
           "0.2705`", ",", "0.2738`", ",", "0.2771`", ",", "0.2803`", ",", 
           "0.2833`", ",", "0.2863`", ",", "0.2891`", ",", "0.2918`", ",", 
           "0.2944`", ",", "0.2968`", ",", "0.2991`", ",", "0.3011`", ",", 
           "0.3031`", ",", "0.3048`", ",", "0.3063`", ",", "0.3076`", ",", 
           "0.3095`", ",", "0.3106`", ",", "0.3118`", ",", "0.3129`", ",", 
           "0.3138`", ",", "0.3145`", ",", "0.3149`", ",", "0.3151`", ",", 
           "0.3152`", ",", "0.3154`", ",", "0.3153`", ",", "0.3151`", ",", 
           "0.3143`", ",", "0.3135`", ",", "0.3128`", ",", "0.312`", ",", 
           "0.311`", ",", "0.31`", ",", "0.3089`", ",", "0.3076`", ",", 
           "0.3068`", ",", "0.306`", ",", "0.3047`", ",", "0.3034`", ",", 
           "0.3026`", ",", "0.3015`", ",", "0.3005`", ",", "0.2999`", ",", 
           "0.2993`", ",", "0.2988`", ",", "0.2983`", ",", "0.2983`", ",", 
           "0.2984`", ",", "0.2987`", ",", "0.2993`", ",", "0.2999`", ",", 
           "0.3008`", ",", "0.3021`", ",", "0.3036`", ",", "0.306`", ",", 
           "0.3085`", ",", "0.3113`", ",", "0.3139`", ",", "0.3169`", ",", 
           "0.3205`", ",", "0.3243`", ",", "0.3283`", ",", "0.3326`", ",", 
           "0.3371`", ",", "0.3419`", ",", "0.3472`", ",", "0.3527`", ",", 
           "0.3584`", ",", "0.3643`", ",", "0.3703`", ",", "0.3765`", ",", 
           "0.3828`", ",", "0.3892`", ",", "0.3957`", ",", "0.4023`", ",", 
           "0.4085`", ",", "0.4149`", ",", "0.4212`", ",", "0.4277`", ",", 
           "0.4341`", ",", "0.4406`", ",", "0.447`", ",", "0.4534`", ",", 
           "0.4598`", ",", "0.4661`", ",", "0.4723`", ",", "0.4784`", ",", 
           "0.4845`", ",", "0.4904`", ",", "0.4962`", ",", "0.5019`", ",", 
           "0.5074`", ",", "0.5128`", ",", "0.5181`", ",", "0.5232`", ",", 
           "0.5281`", ",", "0.5328`", ",", "0.5374`", ",", "0.5419`", ",", 
           "0.5461`", ",", "0.5502`", ",", "0.5542`"}], "}"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"sig1list", "=", 
         RowBox[{"{", 
          RowBox[{
          "0.4458`", ",", "0.4496`", ",", "0.4458`", ",", "0.4458`", ",", 
           "0.4476`", ",", "0.45`", ",", "0.4529`", ",", "0.4535`", ",", 
           "0.4547`", ",", "0.4564`", ",", "0.4569`", ",", "0.4589`", ",", 
           "0.4598`", ",", "0.4607`", ",", "0.4611`", ",", "0.4615`", ",", 
           "0.4623`", ",", "0.463`", ",", "0.4647`", ",", "0.4663`", ",", 
           "0.4677`", ",", "0.4682`", ",", "0.469`", ",", "0.4702`", ",", 
           "0.4712`", ",", "0.4722`", ",", "0.4731`", ",", "0.474`", ",", 
           "0.4747`", ",", "0.4761`", ",", "0.4773`", ",", "0.4782`", ",", 
           "0.4785`", ",", "0.4791`", ",", "0.4798`", ",", "0.4803`", ",", 
           "0.4808`", ",", "0.4811`", ",", "0.4814`", ",", "0.4816`", ",", 
           "0.4817`", ",", "0.4816`", ",", "0.4815`", ",", "0.4813`", ",", 
           "0.4808`", ",", "0.4805`", ",", "0.4801`", ",", "0.4794`", ",", 
           "0.4786`", ",", "0.4781`", ",", "0.4777`", ",", "0.4768`", ",", 
           "0.4758`", ",", "0.4748`", ",", "0.4738`", ",", "0.4734`", ",", 
           "0.4729`", ",", "0.4719`", ",", "0.471`", ",", "0.4688`", ",", 
           "0.4667`", ",", "0.465`", ",", "0.4644`", ",", "0.4634`", ",", 
           "0.4621`", ",", "0.461`", ",", "0.46`", ",", "0.4592`", ",", 
           "0.4586`", ",", "0.4581`", ",", "0.4555`", ",", "0.4535`", ",", 
           "0.4518`", ",", "0.4505`", ",", "0.4493`", ",", "0.4484`", ",", 
           "0.4476`", ",", "0.4469`", ",", "0.4463`", ",", "0.4459`", ",", 
           "0.4451`", ",", "0.4444`", ",", "0.4442`", ",", "0.444`", ",", 
           "0.4436`", ",", "0.4433`", ",", "0.443`", ",", "0.4428`", ",", 
           "0.4427`", ",", "0.4426`", ",", "0.4425`", ",", "0.4424`", ",", 
           "0.4423`", ",", "0.4422`", ",", "0.4421`", ",", "0.442`", ",", 
           "0.442`", ",", "0.4418`", ",", "0.4417`", ",", "0.4417`", ",", 
           "0.4416`", ",", "0.4416`", ",", "0.4415`", ",", "0.4415`", ",", 
           "0.4415`", ",", "0.4415`", ",", "0.4414`"}], "}"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"sig2list", "=", 
         RowBox[{"{", 
          RowBox[{
          "0.3459`", ",", "0.3554`", ",", "0.3459`", ",", "0.3459`", ",", 
           "0.3477`", ",", "0.3502`", ",", "0.353`", ",", "0.3537`", ",", 
           "0.3549`", ",", "0.3566`", ",", "0.3572`", ",", "0.3592`", ",", 
           "0.3602`", ",", "0.3611`", ",", "0.3615`", ",", "0.3619`", ",", 
           "0.3627`", ",", "0.3635`", ",", "0.3654`", ",", "0.367`", ",", 
           "0.3686`", ",", "0.3692`", ",", "0.37`", ",", "0.3713`", ",", 
           "0.3726`", ",", "0.3738`", ",", "0.3749`", ",", "0.3759`", ",", 
           "0.3769`", ",", "0.3787`", ",", "0.3804`", ",", "0.3819`", ",", 
           "0.3824`", ",", "0.3834`", ",", "0.3847`", ",", "0.3859`", ",", 
           "0.3871`", ",", "0.3882`", ",", "0.3893`", ",", "0.3902`", ",", 
           "0.3921`", ",", "0.3938`", ",", "0.3946`", ",", "0.3953`", ",", 
           "0.3967`", ",", "0.3974`", ",", "0.3981`", ",", "0.3993`", ",", 
           "0.4005`", ",", "0.401`", ",", "0.4016`", ",", "0.4026`", ",", 
           "0.4036`", ",", "0.4046`", ",", "0.4054`", ",", "0.4059`", ",", 
           "0.4063`", ",", "0.4071`", ",", "0.4079`", ",", "0.4098`", ",", 
           "0.4114`", ",", "0.413`", ",", "0.4135`", ",", "0.4144`", ",", 
           "0.4157`", ",", "0.417`", ",", "0.4181`", ",", "0.4192`", ",", 
           "0.4203`", ",", "0.4213`", ",", "0.4213`", ",", "0.4213`", ",", 
           "0.4213`", ",", "0.4213`", ",", "0.4213`", ",", "0.4213`", ",", 
           "0.4213`", ",", "0.4213`", ",", "0.4213`", ",", "0.4213`", ",", 
           "0.4213`", ",", "0.4213`", ",", "0.4213`", ",", "0.4213`", ",", 
           "0.4213`", ",", "0.4213`", ",", "0.4213`", ",", "0.4213`", ",", 
           "0.4213`", ",", "0.4213`", ",", "0.4213`", ",", "0.4213`", ",", 
           "0.4213`", ",", "0.4213`", ",", "0.4213`", ",", "0.4213`", ",", 
           "0.4213`", ",", "0.4213`", ",", "0.4213`", ",", "0.4213`", ",", 
           "0.4213`", ",", "0.4213`", ",", "0.4213`", ",", "0.4213`", ",", 
           "0.4213`", ",", "0.4213`", ",", "0.4213`"}], "}"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"sig3list", "=", 
         RowBox[{"{", 
          RowBox[{
          "0.8`", ",", "0.7504`", ",", "0.8`", ",", "0.8`", ",", "0.8`", ",", 
           "0.8`", ",", "0.8`", ",", "0.8`", ",", "0.8`", ",", "0.8`", ",", 
           "0.8`", ",", "0.8`", ",", "0.8`", ",", "0.8`", ",", "0.8`", ",", 
           "0.8`", ",", "0.8`", ",", "0.8`", ",", "0.8`", ",", "0.8`", ",", 
           "0.8`", ",", "0.8`", ",", "0.8`", ",", "0.8`", ",", "0.8`", ",", 
           "0.8`", ",", "0.8`", ",", "0.8`", ",", "0.8`", ",", "0.8`", ",", 
           "0.8`", ",", "0.8`", ",", "0.8`", ",", "0.8`", ",", "0.8`", ",", 
           "0.8`", ",", "0.8`", ",", "0.8`", ",", "0.8`", ",", "0.8`", ",", 
           "0.7999`", ",", "0.7999`", ",", "0.7999`", ",", "0.7998`", ",", 
           "0.7998`", ",", "0.7997`", ",", "0.7997`", ",", "0.7996`", ",", 
           "0.7994`", ",", "0.7993`", ",", "0.7992`", ",", "0.799`", ",", 
           "0.7988`", ",", "0.7983`", ",", "0.7979`", ",", "0.7976`", ",", 
           "0.7974`", ",", "0.797`", ",", "0.7966`", ",", "0.794`", ",", 
           "0.7917`", ",", "0.7884`", ",", "0.7867`", ",", "0.7836`", ",", 
           "0.7792`", ",", "0.7747`", ",", "0.7681`", ",", "0.7619`", ",", 
           "0.756`", ",", "0.7504`", ",", "0.74`", ",", "0.7304`", ",", 
           "0.723`", ",", "0.7182`", ",", "0.7136`", ",", "0.7097`", ",", 
           "0.708`", ",", "0.7064`", ",", "0.7049`", ",", "0.7035`", ",", 
           "0.7025`", ",", "0.7017`", ",", "0.7012`", ",", "0.7011`", ",", 
           "0.7008`", ",", "0.7006`", ",", "0.7004`", ",", "0.7003`", ",", 
           "0.7003`", ",", "0.7002`", ",", "0.7002`", ",", "0.7001`", ",", 
           "0.7001`", ",", "0.7001`", ",", "0.7001`", ",", "0.7001`", ",", 
           "0.7`", ",", "0.7`", ",", "0.7`", ",", "0.7`", ",", "0.7`", ",", 
           "0.7`", ",", "0.7`", ",", "0.7`", ",", "0.7`", ",", "0.7`", ",", 
           "0.7`"}], "}"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{"PGA", " ", "or", " ", "PGV"}], "*)"}], 
        RowBox[{"Which", "[", 
         RowBox[{
          RowBox[{"per", "<", "0."}], ",", 
          RowBox[{
           RowBox[{"pos", "=", "2"}], ";"}], ",", 
          RowBox[{"0.", "<=", "per", "<", "0.01"}], ",", 
          RowBox[{
           RowBox[{"pos", "=", "1"}], ";"}], ",", 
          RowBox[{"0.01", "<=", "per"}], ",", 
          RowBox[{"1", ";"}]}], "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"SetOptions", "[", 
         RowBox[{"InterpolateCoefficientList", ",", 
          RowBox[{"IpolHalfWindowLength", "->", "ilenALL"}], ",", 
          RowBox[{"IpolOrder", "->", "ipolorderALL"}], ",", 
          RowBox[{"IpolType", "->", "ipolTypeAll"}]}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"Which", "[", 
         RowBox[{
          RowBox[{"per", "<", "0.01"}], ",", 
          RowBox[{"(*", "PGA", "*)"}], 
          RowBox[{
           RowBox[{"c1", "=", 
            RowBox[{"c1list", "[", 
             RowBox[{"[", "pos", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"c1a", "=", 
            RowBox[{"c1alist", "[", 
             RowBox[{"[", "pos", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"c1b", "=", 
            RowBox[{"c1blist", "[", 
             RowBox[{"[", "pos", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"cn", "=", 
            RowBox[{"cnlist", "[", 
             RowBox[{"[", "pos", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"cm", "=", 
            RowBox[{"cmlist", "[", 
             RowBox[{"[", "pos", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"c5", "=", 
            RowBox[{"c5list", "[", 
             RowBox[{"[", "pos", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"c6", "=", 
            RowBox[{"c6list", "[", 
             RowBox[{"[", "pos", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"c7", "=", 
            RowBox[{"c7list", "[", 
             RowBox[{"[", "pos", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"c9", "=", 
            RowBox[{"c9list", "[", 
             RowBox[{"[", "pos", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"c9a", "=", 
            RowBox[{"c9alist", "[", 
             RowBox[{"[", "pos", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"cg1", "=", 
            RowBox[{"cg1list", "[", 
             RowBox[{"[", "pos", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"cg2", "=", 
            RowBox[{"cg2list", "[", 
             RowBox[{"[", "pos", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"phi1", "=", 
            RowBox[{"phi1list", "[", 
             RowBox[{"[", "pos", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"phi2", "=", 
            RowBox[{"phi2list", "[", 
             RowBox[{"[", "pos", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"phi3", "=", 
            RowBox[{"phi3list", "[", 
             RowBox[{"[", "pos", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"phi4", "=", 
            RowBox[{"phi4list", "[", 
             RowBox[{"[", "pos", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"phi5", "=", 
            RowBox[{"phi5list", "[", 
             RowBox[{"[", "pos", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"phi6", "=", 
            RowBox[{"phi6list", "[", 
             RowBox[{"[", "pos", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"phi7", "=", 
            RowBox[{"phi7list", "[", 
             RowBox[{"[", "pos", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"phi8", "=", 
            RowBox[{"phi8list", "[", 
             RowBox[{"[", "pos", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"tau1", "=", 
            RowBox[{"tau1list", "[", 
             RowBox[{"[", "pos", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"tau2", "=", 
            RowBox[{"tau2list", "[", 
             RowBox[{"[", "pos", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"sig1", "=", 
            RowBox[{"sig1list", "[", 
             RowBox[{"[", "pos", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"sig2", "=", 
            RowBox[{"sig2list", "[", 
             RowBox[{"[", "pos", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"sig3", "=", 
            RowBox[{"sig3list", "[", 
             RowBox[{"[", "pos", "]"}], "]"}]}], ";"}], ",", 
          RowBox[{"0.01", "<=", "per"}], ",", 
          RowBox[{"(*", 
           RowBox[{"else", " ", "response", " ", "spectrum"}], "*)"}], 
          RowBox[{
           RowBox[{"c1", "=", 
            RowBox[{"InterpolateCoefficientList", "[", 
             RowBox[{"per", ",", "periodlist", ",", "c1list"}], "]"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"c1a", "=", 
            RowBox[{"InterpolateCoefficientList", "[", 
             RowBox[{"per", ",", "periodlist", ",", "c1alist"}], "]"}]}], ";",
            "\[IndentingNewLine]", 
           RowBox[{"c1b", "=", 
            RowBox[{"InterpolateCoefficientList", "[", 
             RowBox[{"per", ",", "periodlist", ",", "c1blist"}], "]"}]}], ";",
            "\[IndentingNewLine]", 
           RowBox[{"cn", "=", 
            RowBox[{"InterpolateCoefficientList", "[", 
             RowBox[{"per", ",", "periodlist", ",", "cnlist"}], "]"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"cm", "=", 
            RowBox[{"InterpolateCoefficientList", "[", 
             RowBox[{"per", ",", "periodlist", ",", "cmlist"}], "]"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"c5", "=", 
            RowBox[{"InterpolateCoefficientList", "[", 
             RowBox[{"per", ",", "periodlist", ",", "c5list"}], "]"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"c6", "=", 
            RowBox[{"InterpolateCoefficientList", "[", 
             RowBox[{"per", ",", "periodlist", ",", "c6list"}], "]"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"c7", "=", 
            RowBox[{"InterpolateCoefficientList", "[", 
             RowBox[{"per", ",", "periodlist", ",", "c7list"}], "]"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"c9", "=", 
            RowBox[{"InterpolateCoefficientList", "[", 
             RowBox[{"per", ",", "periodlist", ",", "c9list"}], "]"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"c9a", "=", 
            RowBox[{"InterpolateCoefficientList", "[", 
             RowBox[{"per", ",", "periodlist", ",", "c9alist"}], "]"}]}], ";",
            "\[IndentingNewLine]", 
           RowBox[{"cg1", "=", 
            RowBox[{"InterpolateCoefficientList", "[", 
             RowBox[{"per", ",", "periodlist", ",", "cg1list"}], "]"}]}], ";",
            "\[IndentingNewLine]", 
           RowBox[{"cg2", "=", 
            RowBox[{"InterpolateCoefficientList", "[", 
             RowBox[{"per", ",", "periodlist", ",", "cg2list"}], "]"}]}], ";",
            "\[IndentingNewLine]", 
           RowBox[{"phi1", "=", 
            RowBox[{"InterpolateCoefficientList", "[", 
             RowBox[{"per", ",", "periodlist", ",", "phi1list"}], "]"}]}], ";",
            "\[IndentingNewLine]", 
           RowBox[{"phi2", "=", 
            RowBox[{"InterpolateCoefficientList", "[", 
             RowBox[{"per", ",", "periodlist", ",", "phi2list"}], "]"}]}], ";",
            "\[IndentingNewLine]", 
           RowBox[{"phi3", "=", 
            RowBox[{"InterpolateCoefficientList", "[", 
             RowBox[{"per", ",", "periodlist", ",", "phi3list"}], "]"}]}], ";",
            "\[IndentingNewLine]", 
           RowBox[{"phi4", "=", 
            RowBox[{"InterpolateCoefficientList", "[", 
             RowBox[{"per", ",", "periodlist", ",", "phi4list"}], "]"}]}], ";",
            "\[IndentingNewLine]", 
           RowBox[{"phi5", "=", 
            RowBox[{"InterpolateCoefficientList", "[", 
             RowBox[{"per", ",", "periodlist", ",", "phi5list"}], "]"}]}], ";",
            "\[IndentingNewLine]", 
           RowBox[{"phi6", "=", 
            RowBox[{"InterpolateCoefficientList", "[", 
             RowBox[{"per", ",", "periodlist", ",", "phi6list"}], "]"}]}], ";",
            "\[IndentingNewLine]", 
           RowBox[{"phi7", "=", 
            RowBox[{"InterpolateCoefficientList", "[", 
             RowBox[{"per", ",", "periodlist", ",", "phi7list"}], "]"}]}], ";",
            "\[IndentingNewLine]", 
           RowBox[{"phi8", "=", 
            RowBox[{"InterpolateCoefficientList", "[", 
             RowBox[{"per", ",", "periodlist", ",", "phi8list"}], "]"}]}], ";",
            "\[IndentingNewLine]", 
           RowBox[{"tau1", "=", 
            RowBox[{"InterpolateCoefficientList", "[", 
             RowBox[{"per", ",", "periodlist", ",", "tau1list"}], "]"}]}], ";",
            "\[IndentingNewLine]", 
           RowBox[{"tau2", "=", 
            RowBox[{"InterpolateCoefficientList", "[", 
             RowBox[{"per", ",", "periodlist", ",", "tau2list"}], "]"}]}], ";",
            "\[IndentingNewLine]", 
           RowBox[{"sig1", "=", 
            RowBox[{"InterpolateCoefficientList", "[", 
             RowBox[{"per", ",", "periodlist", ",", "sig1list"}], "]"}]}], ";",
            "\[IndentingNewLine]", 
           RowBox[{"sig2", "=", 
            RowBox[{"InterpolateCoefficientList", "[", 
             RowBox[{"per", ",", "periodlist", ",", "sig2list"}], "]"}]}], ";",
            "\[IndentingNewLine]", 
           RowBox[{"sig3", "=", 
            RowBox[{"InterpolateCoefficientList", "[", 
             RowBox[{"per", ",", "periodlist", ",", "sig3list"}], "]"}]}], 
           ";"}]}], "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"c2", "=", "1.06"}], ";", "\[IndentingNewLine]", 
        RowBox[{"c3", "=", "3.45"}], ";", "\[IndentingNewLine]", 
        RowBox[{"c4", "=", 
         RowBox[{"-", "2.1"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"c4a", "=", 
         RowBox[{"-", "0.5"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"crb", "=", "50."}], ";", "\[IndentingNewLine]", 
        RowBox[{"chm", "=", "3."}], ";", "\[IndentingNewLine]", 
        RowBox[{"cg3", "=", "4."}], ";", "\[IndentingNewLine]", 
        RowBox[{"frv", "=", "0."}], ";", "\[IndentingNewLine]", 
        RowBox[{"fnm", "=", "0."}], ";", "\[IndentingNewLine]", 
        RowBox[{"Which", "[", 
         RowBox[{
          RowBox[{"faulttypeinp", "===", "\"\<REVERSE\>\""}], ",", 
          RowBox[{
           RowBox[{"frv", "=", "1."}], ";"}], ",", 
          RowBox[{"faulttypeinp", "===", "\"\<NORMAL\>\""}], ",", 
          RowBox[{
           RowBox[{"fnm", "=", "1."}], ";"}], ",", 
          RowBox[{"faulttypeinp", "===", "\"\<STRIKE SLIP\>\""}], ",", 
          RowBox[{"1", ";"}], ",", "True", ",", 
          RowBox[{
           RowBox[{"Message", "[", 
            RowBox[{
             RowBox[{"EmpiricalEquation", "::", "option"}], ",", 
             "faulttypeinp", ",", "FaultTypeNSSR"}], "]"}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"Return", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", "999"}], ",", 
              RowBox[{"-", "999"}], ",", 
              RowBox[{"-", "999"}], ",", 
              RowBox[{"-", "999"}]}], "}"}], "]"}], ";"}]}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{
         "calculate", " ", "basin", " ", "depth", " ", "from", " ", "vs30", " ",
           "when", " ", "unknown"}], "*)"}], 
        RowBox[{"Which", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"StringQ", "[", "basinopt", "]"}], "&&", 
           RowBox[{"StringMatchQ", "[", 
            RowBox[{"basinopt", ",", "\"\<Default\>\""}], "]"}]}], ",", 
          RowBox[{
           RowBox[{"basin", "=", 
            RowBox[{"28.5", "-", 
             RowBox[{
              RowBox[{"3.82", "/", "8"}], " ", 
              RowBox[{"Log", "[", 
               RowBox[{
                RowBox[{"vs30", "^", "8"}], "+", 
                RowBox[{"378", "^", "8"}]}], "]"}]}]}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"z10", "=", 
            RowBox[{
             RowBox[{"Exp", "[", "basin", "]"}], "/", "1000."}]}], ";"}], ",", 
          RowBox[{"NumericQ", "[", "basinopt", "]"}], ",", 
          RowBox[{
           RowBox[{"z10", "=", 
            RowBox[{"basinopt", "/", "1000"}]}], ";"}], ",", "True", ",", 
          RowBox[{
           RowBox[{"Message", "[", 
            RowBox[{
             RowBox[{"EmpiricalEquation", "::", "basin"}], ",", 
             "BasinDepthZ10"}], "]"}], ";", "\[IndentingNewLine]", 
           RowBox[{"Return", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", "999"}], ",", 
              RowBox[{"-", "999"}], ",", 
              RowBox[{"-", "999"}], ",", 
              RowBox[{"-", "999"}]}], "}"}], "]"}], ";"}]}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{
          RowBox[{"HW", " ", 
           RowBox[{"factors", ":", 
            RowBox[{"For", " ", "now"}]}]}], ",", 
          RowBox[{
          "convert", " ", "hwflag", " ", "to", " ", "an", " ", "equivalent", " ",
            "srcSiteA"}]}], "*)"}], 
        RowBox[{"If", "[", 
         RowBox[{"hw", ",", 
          RowBox[{
           RowBox[{"srcsitea", "=", "90."}], ";"}], ",", 
          RowBox[{
           RowBox[{"srcsitea", "=", "0."}], ";"}]}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{
         "compute", " ", "rx", " ", "value", " ", "given", " ", "source", " ",
           "to", " ", "site", " ", "azimuth"}], "*)"}], 
        RowBox[{"Which", "[", 
         RowBox[{
          RowBox[{"srcsitea", "==", "90."}], ",", 
          RowBox[{
           RowBox[{"rx", "=", 
            RowBox[{
             RowBox[{"rrup", "/", 
              RowBox[{"Sin", "[", 
               RowBox[{"delta", " ", 
                RowBox[{"N", "@", "Degree"}]}], "]"}]}], "-", 
             RowBox[{"ztor", "/", 
              RowBox[{"Tan", "[", 
               RowBox[{"delta", " ", 
                RowBox[{"N", "@", "Degree"}]}], "]"}]}]}]}], ";"}], ",", 
          RowBox[{"srcsitea", ">", "0."}], ",", 
          RowBox[{
           RowBox[{"rx", "=", 
            RowBox[{"rjb", " ", 
             RowBox[{"Tan", "[", 
              RowBox[{"srcsitea", " ", 
               RowBox[{"N", "@", "Degree"}]}], "]"}]}]}], ";"}], ",", 
          RowBox[{"srcsitea", "<=", "0."}], ",", 
          RowBox[{
           RowBox[{"rx", "=", "0."}], ";"}]}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{"calculate", " ", "lnyref", " ", "by", " ", 
          RowBox[{"eq", ".", 
           RowBox[{"(", 
            RowBox[{"13", "a"}], ")"}]}]}], "*)"}], 
        RowBox[{"(*", 
         RowBox[{
         "This", " ", "model", " ", "differs", " ", "slightly", " ", "from", " ",
           "the", " ", "one", " ", "implemented", " ", "in", " ", "Hazard39", 
          " ", "by", " ", 
          RowBox[{"N", ".", "Abrahamson", ".", "The"}], " ", "hazard", " ", 
          "code", " ", "does", " ", "not", " ", "consider", " ", 
          "aftershocks"}], "*)"}], 
        RowBox[{"f1", "=", 
         RowBox[{"c1", "+", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"c1a", " ", "frv"}], "+", 
            RowBox[{"c1b", " ", "fnm"}], "+", 
            RowBox[{"c7", "*", 
             RowBox[{"(", 
              RowBox[{"ztor", "-", "4"}], ")"}]}]}], ")"}]}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"f2", "=", 
         RowBox[{
          RowBox[{"c2", "*", 
           RowBox[{"(", 
            RowBox[{"mw", "-", "6"}], ")"}]}], "+", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{"c2", "-", "c3"}], ")"}], "/", "cn"}], " ", 
           RowBox[{"Log", "[", 
            RowBox[{"1", "+", 
             RowBox[{"Exp", "[", 
              RowBox[{"cn", "*", 
               RowBox[{"(", 
                RowBox[{"cm", "-", "mw"}], ")"}]}], "]"}]}], "]"}]}]}]}], ";",
         "\[IndentingNewLine]", 
        RowBox[{"f3", "=", 
         RowBox[{"c4", " ", 
          RowBox[{"Log", "[", 
           RowBox[{"rrup", "+", 
            RowBox[{"c5", " ", 
             RowBox[{"Cosh", "[", 
              RowBox[{"c6", " ", 
               RowBox[{"Max", "[", 
                RowBox[{
                 RowBox[{"mw", "-", "chm"}], ",", "0"}], "]"}]}], "]"}]}]}], 
           "]"}]}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"f4", "=", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"c4a", "-", "c4"}], ")"}], " ", 
          RowBox[{"Log", "[", 
           RowBox[{"Sqrt", "[", 
            RowBox[{
             RowBox[{"rrup", "^", "2"}], "+", 
             RowBox[{"crb", "^", "2"}]}], "]"}], "]"}]}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"f5", "=", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"cg1", "+", 
            RowBox[{"cg2", "/", 
             RowBox[{"Cosh", "[", 
              RowBox[{"Max", "[", 
               RowBox[{
                RowBox[{"mw", "-", "cg3"}], ",", "0"}], "]"}], "]"}]}]}], 
           ")"}], " ", "rrup"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{
          RowBox[{"f6", "=", 
           RowBox[{"c9", " ", "hw", " ", 
            RowBox[{"Tanh", "[", 
             RowBox[{"rx", " ", 
              RowBox[{
               RowBox[{
                RowBox[{"Cos", "[", 
                 RowBox[{"delta", " ", 
                  RowBox[{"N", "@", "Degree"}]}], "]"}], "^", "2"}], "/", 
               "c9a"}]}], "]"}], " ", 
            RowBox[{"(", 
             RowBox[{"1", "-", 
              RowBox[{
               RowBox[{"Sqrt", "[", 
                RowBox[{
                 RowBox[{"rjb", "^", "2"}], "+", 
                 RowBox[{"ztor", "^", "2"}]}], "]"}], "/", 
               RowBox[{"(", 
                RowBox[{"rrup", "+", "0.001"}], ")"}]}]}], ")"}]}]}], ";"}], 
         "*)"}], 
        RowBox[{"(*", 
         RowBox[{"hanging", " ", "wall", " ", "effect"}], "*)"}], 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"rx", "<", "0."}], ",", 
          RowBox[{
           RowBox[{"f6", "=", "0."}], ";"}], ",", 
          RowBox[{
           RowBox[{"f6", "=", 
            RowBox[{"c9", " ", 
             RowBox[{"Tanh", "[", 
              RowBox[{"rx", " ", 
               RowBox[{
                RowBox[{
                 RowBox[{"Cos", "[", 
                  RowBox[{"delta", " ", 
                   RowBox[{"N", "@", "Degree"}]}], "]"}], "^", "2"}], "/", 
                "c9a"}]}], "]"}], " ", 
             RowBox[{"(", 
              RowBox[{"1", "-", 
               RowBox[{
                RowBox[{"Sqrt", "[", 
                 RowBox[{
                  RowBox[{"rjb", "^", "2"}], "+", 
                  RowBox[{"ztor", "^", "2"}]}], "]"}], "/", 
                RowBox[{"(", 
                 RowBox[{"rrup", "+", "0.001"}], ")"}]}]}], ")"}]}]}], 
           ";"}]}], "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"lnyref", "=", 
         RowBox[{
         "f1", "+", "f2", "+", "f3", "+", "f4", "+", "f5", "+", "f6"}]}], ";",
         "\[IndentingNewLine]", 
        RowBox[{"yref", "=", 
         RowBox[{"Exp", "[", "lnyref", "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{
         "site", " ", "effects", " ", "and", " ", "sediment", " ", "term", " ",
           "as", " ", "in", " ", 
          RowBox[{"eq", ".", 
           RowBox[{"(", 
            RowBox[{"13", "b"}], ")"}]}]}], "*)"}], 
        RowBox[{"(*", 
         RowBox[{
         "here", " ", "we", " ", "set", " ", "etai", " ", "to", " ", "its", " ", 
          RowBox[{"mean", "/", "median"}], " ", 
          RowBox[{"(", "0", ")"}]}], "*)"}], 
        RowBox[{"b", "=", 
         RowBox[{"phi2", "*", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"Exp", "[", 
             RowBox[{"phi3", "*", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"Min", "[", 
                 RowBox[{"vs30", ",", "1130."}], "]"}], "-", "360."}], 
               ")"}]}], "]"}], "-", 
            RowBox[{"Exp", "[", 
             RowBox[{"phi3", "*", 
              RowBox[{"(", 
               RowBox[{"1130.", "-", "360."}], ")"}]}], "]"}]}], ")"}]}]}], ";",
         "\[IndentingNewLine]", 
        RowBox[{"c", "=", "phi4"}], ";", "\[IndentingNewLine]", 
        RowBox[{"fsite", "=", 
         RowBox[{
          RowBox[{"phi1", " ", 
           RowBox[{"Min", "[", 
            RowBox[{
             RowBox[{"Log", "[", 
              RowBox[{"vs30", "/", "1130."}], "]"}], ",", "0"}], "]"}]}], "+", 
          RowBox[{"b", " ", 
           RowBox[{"Log", "[", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"yref", "+", "c"}], ")"}], "/", "c"}], "]"}]}]}]}], ";",
         "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"z10", "<", "0."}], ",", 
          RowBox[{
           RowBox[{"fsed", "=", "0."}], ";"}], ",", 
          RowBox[{"(*", "else", "*)"}], 
          RowBox[{
           RowBox[{"fsed", "=", 
            RowBox[{
             RowBox[{"phi5", "*", 
              RowBox[{"(", 
               RowBox[{"1", "-", 
                RowBox[{"1", "/", 
                 RowBox[{"(", 
                  RowBox[{"Cosh", "[", 
                   RowBox[{"phi6", " ", 
                    RowBox[{"Max", "[", 
                    RowBox[{"0", ",", 
                    RowBox[{
                    RowBox[{"z10", " ", "1000."}], "-", "phi7"}]}], "]"}]}], 
                   "]"}], ")"}]}]}], ")"}]}], "+", 
             RowBox[{"phi8", "/", 
              RowBox[{"(", 
               RowBox[{"Cosh", "[", 
                RowBox[{"0.15", " ", 
                 RowBox[{"Min", "[", 
                  RowBox[{
                   RowBox[{"Max", "[", 
                    RowBox[{"0", ",", 
                    RowBox[{
                    RowBox[{"z10", " ", "1000."}], "-", "15."}]}], "]"}], ",",
                    "300"}], "]"}]}], "]"}], ")"}]}]}]}], ";"}]}], "]"}], ";",
         "\[IndentingNewLine]", 
        RowBox[{"lny", "=", 
         RowBox[{"lnyref", "+", "fsite", "+", "fsed"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"per", "<", "0."}], ",", 
          RowBox[{"(*", "PGV", "*)"}], 
          RowBox[{
           RowBox[{"saval", "=", 
            RowBox[{
             RowBox[{"1", "/", "100"}], " ", 
             RowBox[{"Exp", "[", "lny", "]"}]}]}], ";"}], ",", 
          RowBox[{"(*", 
           RowBox[{"else", " ", "PGA", " ", "and", " ", "PSA"}], "*)"}], 
          RowBox[{
           RowBox[{"saval", "=", 
            RowBox[{"9.81", " ", 
             RowBox[{"Exp", "[", "lny", "]"}]}]}], ";"}]}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{"variance", " ", "model"}], "*)"}], 
        RowBox[{"(*", 
         RowBox[{"inter", " ", "event", " ", "term", " ", "eq", " ", 
          RowBox[{"(", "19", ")"}]}], "*)"}], 
        RowBox[{"tau", "=", 
         RowBox[{"tau1", "+", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{"tau2", "-", "tau1"}], ")"}], "/", "2"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"Min", "[", 
              RowBox[{
               RowBox[{"Max", "[", 
                RowBox[{"mw", ",", "5"}], "]"}], ",", "7"}], "]"}], "-", 
             "5"}], ")"}]}]}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{"intra", " ", "event", " ", "term", " ", 
          RowBox[{"eq", ".", 
           RowBox[{"(", "20", ")"}]}]}], "*)"}], 
        RowBox[{"finf", "=", "0."}], ";", "\[IndentingNewLine]", 
        RowBox[{"fmeas", "=", "0."}], ";", "\[IndentingNewLine]", 
        RowBox[{"Which", "[", 
         RowBox[{
          RowBox[{"vs30det", "===", "\"\<ESTIMATED\>\""}], ",", 
          RowBox[{
           RowBox[{"finf", "=", "1."}], ";"}], ",", 
          RowBox[{"vs30det", "===", "\"\<MEASURED\>\""}], ",", 
          RowBox[{
           RowBox[{"fmeas", "=", "1."}], ";"}], ",", "True", ",", 
          RowBox[{
           RowBox[{"Message", "[", 
            RowBox[{
             RowBox[{"EmpiricalEquation", "::", "option"}], ",", "vs30det", ",",
              "VS30Determination"}], "]"}], ";", "\[IndentingNewLine]", 
           RowBox[{"Return", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", "999"}], ",", 
              RowBox[{"-", "999"}], ",", 
              RowBox[{"-", "999"}], ",", 
              RowBox[{"-", "999"}]}], "}"}], "]"}], ";"}]}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"nl0", "=", 
         RowBox[{"b", " ", 
          RowBox[{"yref", "/", 
           RowBox[{"(", 
            RowBox[{"yref", "+", "c"}], ")"}]}]}]}], ";", 
        RowBox[{"(*", 
         RowBox[{
          RowBox[{"don", "'"}], "t", " ", "know", " ", 
          RowBox[{"what", "'"}], "s", " ", "b", " ", "and", " ", "c"}], 
         "*)"}], 
        RowBox[{"sig", "=", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"sig1", "+", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{"sig2", "-", "sig1"}], ")"}], "/", "2"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"Min", "[", 
                RowBox[{
                 RowBox[{"Max", "[", 
                  RowBox[{"mw", ",", "5"}], "]"}], ",", "7"}], "]"}], "-", 
               "5"}], ")"}]}]}], ")"}], " ", 
          RowBox[{"Sqrt", "[", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"sig3", " ", "finf"}], "+", 
              RowBox[{"0.7", " ", "fmeas"}]}], ")"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "+", "nl0"}], ")"}], "^", "2"}]}], "]"}]}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{"total", " ", "variance", " ", 
          RowBox[{"eq", ".", 
           RowBox[{"(", "21", ")"}]}]}], "*)"}], 
        RowBox[{"sigmatot", "=", 
         RowBox[{"Sqrt", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "+", "nl0"}], ")"}], "^", "2"}], " ", 
            RowBox[{"tau", "^", "2"}]}], "+", 
           RowBox[{"sig", "^", "2"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{
          RowBox[{"**", "**", "**", "**", "partial"}], " ", "derivatives"}], 
         "****************)"}], 
        RowBox[{"pdmag", "=", 
         RowBox[{"c2", "-", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"c2", "-", "c3"}], ")"}], "*", 
             RowBox[{"E", "^", 
              RowBox[{"(", 
               RowBox[{"cn", "*", 
                RowBox[{"(", 
                 RowBox[{"cm", "-", "mw"}], ")"}]}], ")"}]}]}], ")"}], "/", 
           RowBox[{"(", 
            RowBox[{"1", "+", 
             RowBox[{"E", "^", 
              RowBox[{"(", 
               RowBox[{"cn", "*", 
                RowBox[{"(", 
                 RowBox[{"cm", "-", "mw"}], ")"}]}], ")"}]}]}], ")"}]}], "+", 
          
          RowBox[{
           RowBox[{"(", 
            RowBox[{"c4", "*", "c5", "*", "c6", "*", 
             RowBox[{"Piecewise", "[", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"{", 
                 RowBox[{"1", ",", 
                  RowBox[{
                   RowBox[{"chm", "-", "mw"}], "<", "0"}]}], "}"}], "}"}], ",",
                "0"}], "]"}], "*", 
             RowBox[{"Sinh", "[", 
              RowBox[{"c6", "*", 
               RowBox[{"Max", "[", 
                RowBox[{"0", ",", 
                 RowBox[{
                  RowBox[{"-", "chm"}], "+", "mw"}]}], "]"}]}], "]"}]}], 
            ")"}], "/", 
           RowBox[{"(", 
            RowBox[{"rrup", "+", 
             RowBox[{"c5", "*", 
              RowBox[{"Cosh", "[", 
               RowBox[{"c6", "*", 
                RowBox[{"Max", "[", 
                 RowBox[{"0", ",", 
                  RowBox[{
                   RowBox[{"-", "chm"}], "+", "mw"}]}], "]"}]}], "]"}]}]}], 
            ")"}]}], "-", 
          RowBox[{"cg2", "*", "rrup", "*", 
           RowBox[{"Piecewise", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"{", 
               RowBox[{"1", ",", 
                RowBox[{
                 RowBox[{"cg3", "-", "mw"}], "<", "0"}]}], "}"}], "}"}], ",", 
             "0"}], "]"}], "*", 
           RowBox[{"Sech", "[", 
            RowBox[{"Max", "[", 
             RowBox[{"0", ",", 
              RowBox[{
               RowBox[{"-", "cg3"}], "+", "mw"}]}], "]"}], "]"}], "*", 
           RowBox[{"Tanh", "[", 
            RowBox[{"Max", "[", 
             RowBox[{"0", ",", 
              RowBox[{
               RowBox[{"-", "cg3"}], "+", "mw"}]}], "]"}], "]"}]}]}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{
          RowBox[{"partial", " ", "derivative", " ", 
           RowBox[{"w", ".", "r", ".", "t", ".", "distance"}]}], "-", 
          RowBox[{
          "neglect", " ", "the", " ", "hanging", " ", "wall", " ", "term"}]}],
          "*)"}], 
        RowBox[{"pddist", "=", 
         RowBox[{
          RowBox[{"-", "cg1"}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "c4"}], "+", "c4a"}], ")"}], "*", "rrup"}], ")"}],
            "/", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"crb", "^", "2"}], "+", 
             RowBox[{"rrup", "^", "2"}]}], ")"}]}], "+", 
          RowBox[{"c4", "/", 
           RowBox[{"(", 
            RowBox[{"rrup", "+", 
             RowBox[{"c5", "*", 
              RowBox[{"Cosh", "[", 
               RowBox[{"c6", "*", 
                RowBox[{"Max", "[", 
                 RowBox[{"0", ",", 
                  RowBox[{
                   RowBox[{"-", "chm"}], "+", "mw"}]}], "]"}]}], "]"}]}]}], 
            ")"}]}], "+", 
          RowBox[{"cg2", "*", 
           RowBox[{"Sech", "[", 
            RowBox[{"Max", "[", 
             RowBox[{"0", ",", 
              RowBox[{
               RowBox[{"-", "cg3"}], "+", "mw"}]}], "]"}], "]"}]}]}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"Return", "[", 
         RowBox[{"{", 
          RowBox[{"saval", ",", "sigmatot", ",", "pddist", ",", "pdmag"}], 
          "}"}], "]"}], ";"}]}], "]"}]}], ";"}], "\n"}]}]], "Input",
 CellChangeTimes->{{3.9521775958563013`*^9, 3.952177595857615*^9}},
 CellLabel->"In[84]:=",ExpressionUUID->"38f32c75-713a-40c4-bfa6-f0fafa1f9cf0"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Code for PolygonCoordsForCircle[]", "Section",
 CellChangeTimes->{{3.9520623963778763`*^9, 3.9520624163207607`*^9}, {
  3.955785269681137*^9, 
  3.955785271435461*^9}},ExpressionUUID->"50bc2ade-ee3e-42c6-b572-\
8f7a95706fed"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", "Messages", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"ProbOfExcLogNormTrunc", "::", "plIntVal"}], 
     "=", "\"\<x-value of `1` for AxisType-> \\\"LOGLIN\\\"  invalid. Set to \
non-zero value.\>\""}], ";"}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"LonLatFromUTMXY", "::", "zoneval"}], 
     "=", "\"\<LonLatFromUTMXY: Zone `1` outside range (-61,60)\>\""}], ";"}],
    "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"LonLatFromXY", "::", "zoneval"}], 
     "=", "\"\<LonLatFromXY: UTMZone `1` unresolvable. Take default value \
from LonLatFromUTMXY[] `2`.\>\""}], ";"}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"UTMXYFromLonLat", "::", "undefspheroid"}], 
     "=", "\"\<Undefined spheroid type: `1`\>\""}], ";"}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"LonLatFromUTMXY", "::", "undefspheroid"}], 
     "=", "\"\<Undefined spheroid type: `1`\>\""}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{"GeneralTools", "::", "undefrefpoint"}], 
     "=", "\"\<Warning! Undefined reference point: `1`\>\""}], "*)"}], "\n", 
   RowBox[{
    RowBox[{"UTMToLonLat", "::", "zoneval"}], 
    "=", "\"\<UTMToLonLat: Zone `1` outside range (-61,60)\>\""}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"PolygonCoordsForCircle", "::", "usage"}], 
     "=", "\"\<PolygonCoordsForCircle[refpt,radius,segs] gives the polygon \
vertex coordinates for a circular seismic zone with defined radius around \
refpt {lon,lat}. The number of segments used for the discretization of the \
circle is given by segs (default 12).\>\""}], ";"}], "\n", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{
     "calculate", " ", "the", " ", "polygon", " ", "coordinates", " ", "for", 
      " ", "the", " ", "circle", " ", "defined", " ", "by", " ", "center", " ",
       "point", " ", "lon"}], ",", 
     RowBox[{"lat", " ", "and", " ", "radius", " ", 
      RowBox[{"(", 
       RowBox[{"in", " ", "km"}], ")"}], " ", "into", " ", "fileout", " ", 
      "in", " ", "Leydecker4s", " ", "format"}]}], "*)"}], 
   RowBox[{
    RowBox[{
     RowBox[{"PolygonCoordsForCircle", "[", 
      RowBox[{"refpt_", ",", "radius_", ",", 
       RowBox[{"segs_", ":", "12"}], ",", 
       RowBox[{"startangledeg_", ":", "0."}]}], "]"}], ":=", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "x0", ",", "y0", ",", "x1", ",", "y1", ",", "nosegs", ",", "polyc"}], 
        "}"}], ",", 
       RowBox[{
        RowBox[{"nosegs", "=", "segs"}], ";", "\[IndentingNewLine]", 
        RowBox[{"polyc", "=", 
         RowBox[{"{", "}"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"x0", ",", "y0"}], "}"}], "=", 
         RowBox[{"XYFromLonLat", "[", "refpt", "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"For", "[", 
         RowBox[{
          RowBox[{"i", "=", "0"}], ",", 
          RowBox[{"i", "<=", "nosegs"}], ",", 
          RowBox[{"i", "++"}], ",", 
          RowBox[{
           RowBox[{
            RowBox[{"{", 
             RowBox[{"x1", ",", "y1"}], "}"}], "=", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"x0", ",", "y0"}], "}"}], "+", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{
                RowBox[{"Sin", "[", 
                 RowBox[{
                  RowBox[{"startangledeg", " ", "Degree"}], "+", 
                  RowBox[{"i", " ", "2", 
                   RowBox[{"Pi", "/", "nosegs"}]}]}], "]"}], ",", 
                RowBox[{"Cos", "[", 
                 RowBox[{
                  RowBox[{"startangledeg", " ", "Degree"}], "+", 
                  RowBox[{"i", " ", "2", " ", 
                   RowBox[{"Pi", "/", "nosegs"}]}]}], "]"}]}], "}"}], " ", 
              "radius"}]}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"AppendTo", "[", 
            RowBox[{"polyc", ",", 
             RowBox[{"LonLatFromXY", "[", 
              RowBox[{"{", 
               RowBox[{"x1", ",", "y1"}], "}"}], "]"}]}], "]"}], ";"}]}], 
         "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"Return", "[", "polyc", "]"}], ";"}]}], "]"}]}], 
    ";"}]}]}]], "Input",
 CellChangeTimes->{{3.952061059383746*^9, 3.952061067400371*^9}, 
   3.952061107607739*^9, {3.952062302976562*^9, 3.9520623095779943`*^9}, 
   3.952062412592339*^9, {3.952062561871241*^9, 3.952062599116015*^9}, {
   3.952062675940214*^9, 3.952062712780637*^9}},
 CellLabel->"In[86]:=",ExpressionUUID->"511c6373-0eb9-4c5e-a908-e4326f9ad082"],

Cell[BoxData["\<\"UTMToLonLat: Zone `1` outside range (-61,60)\"\>"], "Output",
 CellChangeTimes->{{3.952062692401937*^9, 3.952062708094026*^9}, 
   3.9557855651813507`*^9},
 CellLabel->"Out[91]=",ExpressionUUID->"03a863fa-18d5-486a-9cba-2092d6d5da7a"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Spheroid", "::", "usage"}], 
   "=", "\"\<Spheroid defines the reference spheroid for several geodetic \
functions used in PSHAtools. Possible settings are given by \
GeodesyData[\\\"ReferenceEllipsoid\\\"].\>\""}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"UTMZone", "::", "usage"}], 
   "=", "\"\<UTMZone is an option to  UTMXYFromLonLat and LonLatFromUTMXY \
which defines the UTM zone to work in.\>\""}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"RefPoint", "::", "usage"}], 
   "=", "\"\<RefPoint given as {\[Lambda]-ref, \[Phi]-ref} in decimal degrees \
defines the reference point. If the reference point list is empty, the \
coordinates are simply the UTM coordinates of {\[Lambda], \[Phi]} in \
km.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"XYFromLonLat", "::", "usage"}], 
   "=", "\"\<XYFromLonLat[{Lambda, Phi}] gives  the Cartesian coordinates \
xlon and xlat in km relative to a reference point which is defined through \
the option RefPoint. Internally, the calculations are done via transformation \
into UTM coordinates.\>\""}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"LonLatFromXY", "::", "usage"}], 
   "=", "\"\<LonLatFromXY[{xlon,xlat}] gives the geographical longitude \
Lambda  and latitude Phi  for the Cartesian coordinates xlon and xlat in km \
relative to a reference point. The reference point is defined through the \
option RefPoint. Internally, the calculations are done via transformation \
into UTM coordinates.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"$DefaultUTMZone", "::", "usage"}], 
   "=", "\"\<$DefaultUTMZone is the default UTM zone for the UTM functions.\>\
\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"UTMZoneGet", "::", "usage"}], 
    "=", "\"\<UTMZoneGet[{Lambda, Phi}] gives  the UTM-zone of the point \
{Lambda, Phi}. The  longitude Lambda  and latitude Phi  need to be given in \
decimal degrees.\>\""}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Options", "[", "XYFromLonLat", "]"}], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"RefPoint", "->", 
      RowBox[{"{", 
       RowBox[{"9.5", ",", "52."}], "}"}]}], ",", 
     RowBox[{"Spheroid", "->", "\"\<WGS84\>\""}], ",", 
     RowBox[{"UTMZone", "->", "Automatic"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"XYFromLonLat", "[", 
     RowBox[{"pt_", ",", 
      RowBox[{"opts", ":", 
       RowBox[{"OptionsPattern", "[", 
        RowBox[{"{", "XYFromLonLat", "}"}], "]"}]}]}], "]"}], ":=", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "x", ",", "y", ",", "refpt", ",", "spheroidname", ",", "zone", ",", 
        "inpzone"}], "}"}], ",", 
      RowBox[{
       RowBox[{"refpt", "=", 
        RowBox[{"OptionValue", "[", "RefPoint", "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"spheroidname", "=", 
        RowBox[{"OptionValue", "[", "Spheroid", "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"inpzone", "=", 
        RowBox[{"OptionValue", "[", "UTMZone", "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"inpzone", "===", "Automatic"}], ",", 
         RowBox[{
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"Length", "[", "refpt", "]"}], "!=", "2"}], " ", 
            RowBox[{"(*", 
             RowBox[{"reference", " ", "point", " ", "not", " ", "given"}], 
             "*)"}], ",", 
            RowBox[{"(*", 
             RowBox[{
              RowBox[{
               RowBox[{"{", "zone", "}"}], "=", 
               RowBox[{
                RowBox[{"{", "UTMZone", "}"}], "/.", " ", 
                RowBox[{"Options", "[", "LonLatFromUTMXY", "]"}]}]}], ";"}], 
             "*)"}], 
            RowBox[{"(*", 
             RowBox[{"take", " ", "default", " ", "value", " ", "from", " ", 
              RowBox[{"LonLatFromUTMXY", "[", "]"}]}], "*)"}], 
            RowBox[{
             RowBox[{"zone", "=", 
              RowBox[{"UTMZoneGet", "[", "pt", "]"}]}], ";"}], "   ", 
            RowBox[{"(*", 
             RowBox[{
             "calculate", " ", "UTM", " ", "zone", " ", "from", " ", "input", 
              " ", "point"}], "*)"}], ",", 
            RowBox[{
             RowBox[{"zone", "=", 
              RowBox[{"UTMZoneGet", "[", "refpt", "]"}]}], ";"}]}], "   ", 
           RowBox[{"(*", 
            RowBox[{
            "calculate", " ", "UTM", " ", "zone", " ", "from", " ", 
             "reference", " ", "point"}], "*)"}], "]"}], ";"}], ",", 
         RowBox[{
          RowBox[{"zone", "=", "inpzone"}], ";"}]}], "]"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"SetOptions", "[", 
        RowBox[{"UTMXYFromLonLat", ",", 
         RowBox[{"Spheroid", "->", "spheroidname"}], ",", 
         RowBox[{"UTMZone", "->", "zone"}]}], "]"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Length", "[", "refpt", "]"}], "!=", "2"}], ",", 
         RowBox[{"(*", 
          RowBox[{
           RowBox[{"Message", "[", 
            RowBox[{
             RowBox[{"GeneralTools", "::", "undefrefpoint"}], ",", "refpt"}], 
            "]"}], ";"}], "*)"}], 
         RowBox[{
          RowBox[{
           RowBox[{"{", 
            RowBox[{"x", ",", "y"}], "}"}], "=", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"UTMXYFromLonLat", "[", "pt", "]"}], ")"}], "/", 
            "1000."}]}], ";"}], " ", 
         RowBox[{"(*", 
          RowBox[{
           RowBox[{"no", " ", "reference", " ", "point", " ", "given"}], ",", 
           
           RowBox[{
           "take", " ", "raw", " ", "UTM", " ", "coordinates", " ", "in", " ",
             "m", " ", "and", " ", "convert", " ", "to", " ", "km"}]}], 
          "*)"}], ",", 
         RowBox[{
          RowBox[{
           RowBox[{"{", 
            RowBox[{"x", ",", "y"}], "}"}], "=", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"UTMXYFromLonLat", "[", "pt", "]"}], "-", 
              RowBox[{"UTMXYFromLonLat", "[", "refpt", "]"}]}], ")"}], "/", 
            "1000."}]}], ";"}]}], "]"}], ";", "\[IndentingNewLine]", 
       RowBox[{"Return", "[", 
        RowBox[{"{", 
         RowBox[{"x", ",", "y"}], "}"}], "]"}], ";"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"Options", "[", "LonLatFromXY", "]"}], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"RefPoint", "->", 
      RowBox[{"{", 
       RowBox[{"9.5", ",", "52."}], "}"}]}], ",", 
     RowBox[{"Spheroid", "->", "\"\<WGS84\>\""}], ",", 
     RowBox[{"UTMZone", "->", "Automatic"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"LonLatFromXY", "[", 
    RowBox[{"pt_", ",", 
     RowBox[{"opts", ":", 
      RowBox[{"OptionsPattern", "[", 
       RowBox[{"{", "LonLatFromXY", "}"}], "]"}]}]}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "x", ",", "y", ",", "lon", ",", "lat", ",", "refpt", ",", 
       "spheroidname", ",", "inpzone", ",", "zone"}], "}"}], ",", 
     RowBox[{
      RowBox[{"refpt", "=", 
       RowBox[{"OptionValue", "[", "RefPoint", "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"spheroidname", "=", 
       RowBox[{"OptionValue", "[", "Spheroid", "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"inpzone", "=", 
       RowBox[{"OptionValue", "[", "UTMZone", "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"inpzone", "===", "Automatic"}], ",", 
        RowBox[{
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"Length", "[", "refpt", "]"}], "!=", "2"}], " ", 
           RowBox[{"(*", 
            RowBox[{"reference", " ", "point", " ", "not", " ", "given"}], 
            "*)"}], ",", 
           RowBox[{
            RowBox[{"zone", "=", 
             RowBox[{"OptionValue", "[", 
              RowBox[{"LonLatFromUTMXY", ",", "UTMZone"}], "]"}]}], ";"}], 
           "   ", 
           RowBox[{"(*", 
            RowBox[{
             RowBox[{"take", " ", "default", " ", "value", " ", "from", " ", 
              RowBox[{"LonLatFromUTMXY", "[", "]"}], " ", "which"}], ",", 
             RowBox[{
             "if", " ", "not", " ", "set", " ", "otherwise", " ", "is", " ", 
              "set", " ", "to", " ", "$DefaultUTMZone"}]}], "*)"}], 
           "\[IndentingNewLine]", 
           RowBox[{"(*", 
            RowBox[{
             RowBox[{"Message", "[", 
              RowBox[{
               RowBox[{"LonLatFromXY", "::", "zoneval"}], ",", "inpzone", ",",
                "zone"}], "]"}], ";"}], "*)"}], ",", 
           RowBox[{
            RowBox[{"zone", "=", 
             RowBox[{"UTMZoneGet", "[", "refpt", "]"}]}], ";"}]}], "   ", 
          RowBox[{"(*", 
           RowBox[{
           "calculate", " ", "UTM", " ", "zone", " ", "from", " ", 
            "reference", " ", "point"}], "*)"}], "]"}], ";"}], ",", 
        RowBox[{
         RowBox[{"zone", "=", "inpzone"}], ";"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"SetOptions", "[", 
       RowBox[{"UTMXYFromLonLat", ",", 
        RowBox[{"Spheroid", "->", "spheroidname"}], ",", 
        RowBox[{"UTMZone", "->", "zone"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"SetOptions", "[", 
       RowBox[{"LonLatFromUTMXY", ",", 
        RowBox[{"Spheroid", "->", "spheroidname"}], ",", 
        RowBox[{"UTMZone", "->", "zone"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Length", "[", "refpt", "]"}], "!=", "2"}], " ", 
        RowBox[{"(*", 
         RowBox[{"reference", " ", "point", " ", "not", " ", "given"}], 
         "*)"}], ",", 
        RowBox[{"(*", 
         RowBox[{
          RowBox[{"Message", "[", 
           RowBox[{
            RowBox[{"GeneralTools", "::", "undefrefpoint"}], ",", "refpt"}], 
           "]"}], ";"}], "*)"}], 
        RowBox[{
         RowBox[{
          RowBox[{"{", 
           RowBox[{"x", ",", "y"}], "}"}], "=", 
          RowBox[{"1000.", " ", "pt"}]}], ";"}], " ", 
        RowBox[{"(*", 
         RowBox[{
          RowBox[{"no", " ", "reference", " ", "point", " ", "given"}], ",", 
          RowBox[{
          "simply", " ", "convert", " ", "input", " ", "point", " ", "to", " ",
            "m"}]}], "*)"}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"{", 
           RowBox[{"x", ",", "y"}], "}"}], "=", 
          RowBox[{
           RowBox[{"UTMXYFromLonLat", "[", "refpt", "]"}], " ", 
           RowBox[{"(*", 
            RowBox[{"in", " ", "m"}], "*)"}], "+", 
           RowBox[{"1000.", " ", "pt"}]}]}], ";"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"lon", ",", "lat"}], "}"}], "=", 
       RowBox[{"LonLatFromUTMXY", "[", 
        RowBox[{"{", 
         RowBox[{"x", ",", "y"}], "}"}], "]"}]}], ";", "\[IndentingNewLine]", 
      
      RowBox[{"Return", "[", 
       RowBox[{"{", 
        RowBox[{"lon", ",", "lat"}], "}"}], "]"}], ";"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"calculate", " ", "UTM", " ", "zone", " ", "for", " ", "a", " ", 
    RowBox[{"{", 
     RowBox[{"lon", ",", "lat"}], "}"}], " ", "point"}], "*)"}], 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{
           "The", " ", "NATO", " ", "UTM", " ", "system", " ", "divides", " ",
             "the", " ", "earth", " ", "into", " ", "60", " ", "longitude", " ",
             "zones"}], ",", 
           RowBox[{"each", " ", "six", " ", "degrees", " ", 
            RowBox[{"wide", ".", "The"}], " ", "numbering", " ", "begins", " ",
             "at", " ", "Zone", " ", "1", " ", "at", " ", "180", " ", 
            RowBox[{"(", 
             RowBox[{"0", " ", "West"}], ")"}], " ", "and", " ", "proceeds", " ", 
            RowBox[{"eastwards", ".", "To"}], " ", "find", " ", "the", " ", 
            "grid", " ", "zone", " ", "for", " ", "any", " ", 
            RowBox[{"longitude", ":", "1"}]}]}], ")"}], " ", "Treat", " ", 
         "west", " ", "longitude", " ", "as", " ", "negative", " ", "and", " ",
          "east", " ", "as", " ", 
         RowBox[{"positive", ".", "2"}]}], ")"}], " ", "Add", " ", "180", " ", 
       RowBox[{"(", "0", ")"}]}], ";", 
      RowBox[{
      "this", " ", "converts", " ", "the", " ", "longitude", " ", "to", " ", 
       "a", " ", "number", " ", "between", " ", "zero", " ", "and", " ", 
       "360", " ", 
       RowBox[{
        RowBox[{"(", "0", ")"}], ".", "3"}]}]}], ")"}], " ", "Divide", " ", 
    "by", " ", "6", " ", "and", " ", "round", " ", "up", " ", "to", " ", 
    "the", " ", "next", " ", "higher", " ", 
    RowBox[{"number", "."}]}], "*)"}], 
  RowBox[{
   RowBox[{
    RowBox[{"UTMZoneGet", "[", "pt_", "]"}], ":=", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"lon", ",", "lat", ",", "slon", ",", "iiz", ",", "izone"}], 
       "}"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{"lon", ",", "lat"}], "}"}], "=", "pt"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"slon", "=", 
        RowBox[{"-", "lon"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"iiz", "=", 
        RowBox[{"IntegerPart", "[", 
         RowBox[{"slon", "/", "6"}], "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"izone", "=", 
        RowBox[{"31", "-", "iiz"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"lon", "<", "0."}], ",", 
         RowBox[{"izone", "=", 
          RowBox[{"31", "-", "iiz"}]}]}], "]"}], ";", "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"lat", "<", "0"}], ",", 
         RowBox[{"izone", "=", 
          RowBox[{"-", 
           RowBox[{"Abs", "[", "izone", "]"}]}]}]}], "]"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"Return", "[", "izone", "]"}], ";"}]}], "]"}]}], 
   ";"}]}]}], "Input",
 CellChangeTimes->{{3.95206126319475*^9, 3.952061302881629*^9}, {
  3.952061363962861*^9, 3.9520613732016153`*^9}, {3.9520614911739483`*^9, 
  3.9520614917226686`*^9}, {3.952061569839644*^9, 3.952061573749713*^9}, {
  3.952061734246717*^9, 3.952061740583124*^9}, {3.952061851355394*^9, 
  3.952061886487434*^9}},
 CellLabel->"In[94]:=",ExpressionUUID->"27abc89e-589f-4e82-b6ac-c765d9e4ccff"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"LonLatFromUTMXY", "::", "usage"}], 
   "=", "\"\<LonLatFromUTMXY[{x (easting in m), y (northing in m)}] gives the \
longitude, latitude pair corresponding to the input UTM coordinates {x \
(easting), y (northing)}. x needs to be given in meters within the chosen  \
UTM zone (default 32). The middle meridian always has an easting of 500000.\>\
\""}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"UTMXYFromLonLat", "::", "usage"}], 
   "=", "\"\<UTMXYFromLonLat[{Lambda, Phi}] gives the UTM {x (easting), y \
(northing)} coordinates in m for the point defined by the geographical \
coordinates {Lambda, Phi}. The  longitude  Lambda  and latitude Phi need to \
be given in decimal degrees.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
  "(*", "******************************************************************************************************************)"}\
], 
  RowBox[{
   RowBox[{
    RowBox[{"Options", "[", "LonLatFromUTMXY", "]"}], "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Spheroid", "->", "\"\<WGS84\>\""}], ",", 
      RowBox[{"UTMZone", "->", "$DefaultUTMZone"}]}], "}"}]}], ";"}]}], "\n", 

 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"LonLatFromUTMXY", "[", 
     RowBox[{"pt_", ",", 
      RowBox[{"opts", ":", 
       RowBox[{"OptionsPattern", "[", 
        RowBox[{"{", "LonLatFromUTMXY", "}"}], "]"}]}]}], "]"}], ":=", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "x", ",", "y", ",", "lon", ",", "lat", ",", "spheroidname", ",", 
        "zone"}], "}"}], ",", 
      RowBox[{
       RowBox[{"spheroidname", "=", 
        RowBox[{"OptionValue", "[", "Spheroid", "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"zone", "=", 
        RowBox[{"OptionValue", "[", "UTMZone", "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"zone", ">", "60"}], "||", 
          RowBox[{"zone", "<", 
           RowBox[{"-", "61"}]}]}], ",", 
         RowBox[{"Message", "[", 
          RowBox[{
           RowBox[{"LonLatFromUTMXY", "::", "zoneval"}], ",", "zone"}], 
          "]"}]}], "]"}], ";", "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"MemberQ", "[", 
          RowBox[{
           RowBox[{"GeodesyData", "[", "]"}], ",", "spheroidname"}], "]"}], ",", 
         RowBox[{
          RowBox[{
           RowBox[{"{", 
            RowBox[{"x", ",", "y"}], "}"}], "=", 
           RowBox[{"pt", "*", "1."}]}], ";", 
          RowBox[{"(*", 
           RowBox[{
           "Multiply", " ", "by", " ", "1.", " ", "to", " ", "make", " ", 
            "it", " ", "a", " ", "real", " ", "number", " ", "in", " ", "any",
             " ", "case"}], "*)"}], 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"lon", ",", "lat"}], "}"}], "=", 
           RowBox[{"FromUTMToLonLat", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"x", ",", "y"}], "}"}], ",", "zone"}], "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"Return", "[", 
           RowBox[{"{", 
            RowBox[{"lon", ",", "lat"}], "}"}], "]"}], ";"}], ",", 
         RowBox[{
          RowBox[{"Message", "[", 
           RowBox[{
            RowBox[{"LonLatFromUTMXY", "::", "undefspheroid"}], ",", 
            "spheroidname"}], "]"}], ";", "\[IndentingNewLine]", 
          RowBox[{"Return", "[", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"-", "1"}], ",", 
             RowBox[{"-", "1"}]}], "}"}], "]"}], ";"}]}], "]"}], ";"}]}], 
     "]"}]}], ";"}], "\n"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Clear", "[", 
   RowBox[{"UTMXYFromLonLat", ",", "Spheroid", ",", "UTMZone"}], "]"}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"Options", "[", "UTMXYFromLonLat", "]"}], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Spheroid", "->", "\"\<WGS84\>\""}], ",", 
     RowBox[{"UTMZone", "->", "Automatic"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"UTMXYFromLonLat", "[", 
    RowBox[{"pt_", ",", 
     RowBox[{"opts", ":", 
      RowBox[{"OptionsPattern", "[", 
       RowBox[{"{", "UTMXYFromLonLat", "}"}], "]"}]}]}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "x", ",", "y", ",", "lon", ",", "lat", ",", "spheroidname", ",", 
       "zone"}], "}"}], ",", 
     RowBox[{
      RowBox[{"spheroidname", "=", 
       RowBox[{"OptionValue", "[", "Spheroid", "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"zone", "=", 
       RowBox[{"OptionValue", "[", "UTMZone", "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"MemberQ", "[", 
         RowBox[{
          RowBox[{"GeodesyData", "[", "]"}], ",", "spheroidname"}], "]"}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"{", 
           RowBox[{"lon", ",", "lat"}], "}"}], "=", 
          RowBox[{"pt", "*", "1."}]}], ";", 
         RowBox[{"(*", 
          RowBox[{
          "Multiply", " ", "by", " ", "1.", " ", "to", " ", "make", " ", "it",
            " ", "a", " ", "real", " ", "number", " ", "in", " ", "any", " ", 
           "case"}], "*)"}], 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"x", ",", "y"}], "}"}], "=", 
          RowBox[{"FromLonLatToUTM", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"lon", ",", "lat"}], "}"}], ",", "zone", ",", 
            "spheroidname"}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"Return", "[", 
          RowBox[{"{", 
           RowBox[{"x", ",", "y"}], "}"}], "]"}], ";"}], ",", 
        RowBox[{
         RowBox[{"Message", "[", 
          RowBox[{
           RowBox[{"UTMXYFromLonLat", "::", "undefspheroid"}], ",", 
           "spheroidname"}], "]"}], ";", "\[IndentingNewLine]", 
         RowBox[{"Return", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "1"}], ",", 
            RowBox[{"-", "1"}]}], "}"}], "]"}], ";"}]}], "]"}], ";"}]}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"The", " ", "functions", " ", 
     RowBox[{"FromLonLatToUTM", "[", "]"}], " ", "and", " ", 
     RowBox[{"FromUTMToLonLat", "[", "]"}], " ", "are", " ", "based", " ", 
     "on", " ", "code", " ", "from", " ", 
     RowBox[{"https", ":"}]}], "//", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"mathematica", ".", "stackexchange", ".", "com"}], "/", 
        "questions"}], "/", "40976"}], "/", "how"}], "-", "to", "-", 
     "calculate", "-", "the", "-", "distance", "-", "between", "-", "utm", "-",
      "projected", "-", "coordinates"}]}], "*)"}], 
  RowBox[{
   RowBox[{
    RowBox[{"FromLonLatToUTM", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"lon_", ",", "lat_"}], "}"}], ",", 
      RowBox[{"inpzone_", ":", "Automatic"}], ",", 
      RowBox[{"spheroid_", ":", "\"\<WGS84\>\""}]}], "]"}], ":=", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", "zone", "}"}], ",", 
      RowBox[{
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"inpzone", "===", "Automatic"}], ",", 
         RowBox[{"zone", "=", 
          RowBox[{"UTMZoneGet", "[", 
           RowBox[{"{", 
            RowBox[{"lon", ",", "lat"}], "}"}], "]"}]}], ",", 
         RowBox[{"zone", "=", "inpzone"}]}], "]"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"GeoGridPosition", "[", 
         RowBox[{
          RowBox[{"GeoPosition", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"lat", ",", "lon"}], "}"}], ",", "spheroid"}], "]"}], ",", 
          RowBox[{"\"\<UTMZone\>\"", "~~", 
           RowBox[{"ToString", "[", "zone", "]"}]}]}], "]"}], 
        "[", "\"\<GridXY\>\"", "]"}]}]}], "]"}]}], ";"}], "\n"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"FromUTMToLonLat", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"easting_", ",", "northing_"}], "}"}], ",", "zone_"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", "}"}], ",", 
    RowBox[{
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"zone", ">", "60"}], "||", 
        RowBox[{"zone", "<", 
         RowBox[{"-", "61"}]}]}], ",", 
       RowBox[{"Message", "[", 
        RowBox[{
         RowBox[{"FromUTMToLonLat", "::", "zoneval"}], ",", "zone"}], "]"}]}],
       "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"Return", "[", 
      RowBox[{
       RowBox[{"GeoPosition", "[", 
        RowBox[{"GeoGridPosition", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"easting", ",", "northing"}], "}"}], ",", 
          RowBox[{"\"\<UTMZone\>\"", "~~", 
           RowBox[{"ToString", "[", "zone", "]"}]}]}], "]"}], "]"}], 
       "[", "\"\<LongitudeLatitude\>\"", "]"}], "]"}], ";"}]}], 
   "]"}]}]}], "Input",
 CellChangeTimes->{{3.95206126319475*^9, 3.952061302881629*^9}, {
   3.952061363962861*^9, 3.9520613732016153`*^9}, 3.952061560593614*^9, {
   3.952061685977705*^9, 3.9520617073575583`*^9}, {3.95206223498351*^9, 
   3.9520622359309807`*^9}, {3.9520625190492573`*^9, 3.952062529695719*^9}},
 CellLabel->
  "In[106]:=",ExpressionUUID->"1cbca60c-4e45-4306-aa51-b21cf86eb3e0"]
}, Closed]],

Cell[CellGroupData[{

Cell["Code for SingleSourceHazard", "Section",
 CellChangeTimes->{{3.95206126319475*^9, 3.952061302881629*^9}, {
   3.952061363962861*^9, 3.9520613732016153`*^9}, 3.952061560593614*^9, {
   3.952061685977705*^9, 3.952061691702258*^9}, 3.952061725115889*^9, 
   3.952061872014447*^9, {3.952062448825807*^9, 3.952062463054028*^9}, 
   3.9557852779497223`*^9},ExpressionUUID->"b172f161-8c39-4fca-9d46-\
7e526a5a97a6"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"SingleSourceHazard", "::", "usage"}], 
    "=", "\"\<SingleSourceHazard[options]calculates a variety of hazard \
parameters  for a single areal source zone or a fault source.  The input is \
controlled via the list of options below. It returns the list {lambda, \
hazcurve, disagglist} with lambda being the total rate of occurrence of all \
earthquakes considered in the calculation, hazcurve the list of annual \
exceedance frequencies (hazard curve), and disagglist a list of lists \
conatining information usabel for disaggregation.  disagglist has the form \
{syngmvallist, distlist, timelist, maglist, ruplen, rupwidth, hwflag, site, \
poly, hyposout, cornersout, epsilonlist}.\>\""}], ";"}], "\n"}]], "Input",
 CellChangeTimes->{{3.952062976084207*^9, 3.952062986791732*^9}},
 CellLabel->
  "In[115]:=",ExpressionUUID->"ec29758f-374a-4799-b1ef-23e86f98d27d"],

Cell[BoxData[
 RowBox[{
  RowBox[{
  "(*", "****************************************************************************)"}\
], 
  RowBox[{
   RowBox[{
    RowBox[{"polylist", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"6.829", ",", "50.591"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7.197", ",", "50.851"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7.973", ",", "50.41"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8.566", ",", "50.216"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7.872", ",", "49.942"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7.686", ",", "50.102"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7.3", ",", "50.34"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6.829", ",", "50.591"}], "}"}]}], "}"}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{"mMIN", "=", "4.0"}], ";"}], "\n", 
   RowBox[{
    RowBox[{"mMAX", "=", "6.0"}], ";"}], "\n", 
   RowBox[{
    RowBox[{"aSTU", "=", "2.19"}], ";"}], "\n", 
   RowBox[{
    RowBox[{"bSTU", "=", "0.84"}], ";"}], "\n", 
   RowBox[{
    RowBox[{"ncum", "=", 
     RowBox[{
      RowBox[{"Power", "[", 
       RowBox[{"10", ",", 
        RowBox[{"aSTU", "-", 
         RowBox[{"bSTU", " ", "mMIN"}]}]}], "]"}], "-", 
      RowBox[{"Power", "[", 
       RowBox[{"10", ",", 
        RowBox[{"aSTU", "-", 
         RowBox[{"bSTU", " ", "mMAX"}]}]}], "]"}]}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{"b", "=", "bSTU"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
   "(*", "****************************************************************************)"}\
]}]}]], "Input",
 CellChangeTimes->{{3.952063069779632*^9, 3.9520630697811613`*^9}, 
   3.952063107402096*^9},
 CellLabel->
  "In[116]:=",ExpressionUUID->"73731a22-a85d-4b35-ba6e-a1d5cf27d952"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"GroundMotionValues", "::", "usage"}], 
   "=", "\"\<List of ground motion values for which the annual exceedance \
frequencies are calculated.\>\""}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"GroundMotionPeriod", "::", "usage"}], 
   "=", "\"\<Response spectral period for which the hazard is evaluated. If \
GroundMotionModel is set  to Automatic, the ground motion period is set to \
the lowest valuein the default ground motion model (PGA).\>\""}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"MagLowHazCalc", "::", "usage"}], 
   "=", "\"\<Lowest magnitude to be included in the hazard calculations. Only \
 events with magnitudes equal or larger are conisdered of engineering \
relevance.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"GroundMotionModel", "::", "usage"}], 
   "=", "\"\<Defines the ground motion model to use in GMMFunctions[]. \
Depending on the setting of this option, the ground motion model  functions \
correspond to different types of ground motions (e. g. PGA, response spectral \
values, macroseismic intensities) with different distribution forms (normal \
or log-normal) and different cutoff values.\>\""}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"HazardCalcMethod", "::", "usage"}], 
   "=", "\"\<Possible options: \\\"MonteCarlo\\\", \\\"Integration\\\", or \\\
\"TimeDependent\\\".\>\""}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"SiteCoordinates", "::", "usage"}], 
   "=", "\"\<Site coordinates in either {lon, lat, z below NN in km} or \
{x-east , y-north, up} in km.\>\""}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"SiteCoordinateType", "::", "usage"}], 
   "=", "\"\<Coordinate system in which the site coordinates are given. If \
not  \\\"LONLAT\\\", it is assumed to be cartesian with{x-east , y-north, up} \
in km.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SynCatRefPoint", "::", "usage"}], 
   "=", "\"\<Reference point in {longitude, latitude} for transformation to \
Cartesian coordinates. If the reference point list is empty, the \
transformation is done into UTM coordinates. Output is in  km, \
however.\>\""}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"SynCatUTMZone", "::", "usage"}], 
   "=", "\"\<UTM-zone to work in. If set to Automatic, the UTM zone of the \
reference point is taken.\>\""}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"CatalogDuration", "::", "usage"}], 
   "=", "\"\<Catalog duration in years.\>\""}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"MainshockSeismicityModel", "::", "usage"}], 
   "=", "\"\<Defines seismicity model for the Poissonian part of the catalog \
calulated using MagnitudesFromDistribution[nevents].  Options: \
{\\\"DOUBLETRUNCATEDEXPONENTIAL\\\", {mMIN,mMAX,ncum,bSTU}}\>\""}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"AftershockSeismicityModel", "::", "usage"}], 
   "=", "\"\<Aftershock model calculated using  ETASTimesAndGRMags[].  \
Options {\\\"ETAS\\\",{0.5,1.25,0.08,3.,7.,0.8,1.} \
(*branchingfacAS,omoriP,omoriC,Mag-minAS,Mag-maxAS,alphaAS,bvalueAS*)} for \
ETAS model or {\\\"NONE\\\",{}(*no aftershocks*)} if only Poissonian catalog \
is generated.\>\""}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"SCDepthDistributionInfo", "::", "usage"}], 
   "=", "\"\<This list defines how the depth distribution is quantified. \
Possible settings are: {\\\"DEPTHBINS\\\" ,{depthbinlist,binweightlist}} \
{\\\"TRUNCATEDNORMAL\\\",{mean,sigma,dmin,dmax}} \
{\\\"UNIFORM\\\",{dmin,dmax}} \
{\\\"DEPTHLIST\\\",{depthlist,weightlist}}.\>\""}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"DepthDistFname", "::", "usage"}], 
   "=", "\"\<File name to which the CDF for the depth distribution is \
written.\>\""}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"FocmecDistribution", "::", "usage"}], 
   "=", "\"\<RandomFocmec[].  Output focal mechanism is  randomly generated \
from the list of focal mechanisms and fractions thereof. Mechanism can be one \
of the following types: \\\"R\\\"= reverse and thrust, \\\"TH\\\" = pure \
thrust (only CBZ), \\\"RO\\\" = reverse/oblique, \\\"RV\\\" = purely reverse \
(only CBZ) \\\"U\\\" = unspecified, \\\"SS\\\" = strike slip,  \\\"N\\\" = \
normal faulting\>\""}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"HangingWallEffect", "::", "usage"}], 
   "=", "\"\<Automatic, True, or False.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SeismicFractions", "::", "usage"}], 
   "=", "\"\<Defines upper and lower borders of aseismic parts of rupture \
planes as fraction of down-dip rupture width.\>\""}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"SeismogenicDepths", "::", "usage"}], 
   "=", "\"\<Upper and lower depth of seismogenic layer in km.\>\""}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"RandomNumberSeed", "::", "usage"}], 
   "=", "\"\<Seed value for the internal random number generators to be used \
if reproducable distributions are supposed to be generated.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SpatialModel", "::", "usage"}], 
   "=", "\"\<The individual earthqakes can either be fractally distributed \
within a polygon or according to a weighting fanction based on historical \
seismicity represented by an earthqake catalog. Alternatively, the \
earthquakes can be distributed around a fault model. Example for either case: \
a) {\\\"FRACTALINPOLYGON\\\",{polylist,\\\"LONLAT\\\",2.,(*dip*){\\\"UNIFORM\\\
\",{30 Degree,60. Degree}},(*strike*){\\\"UNIFORM\\\",{.0 Degree,360. \
Degree}}}} b) \
{\\\"CATALOGWEIGHTEDPOLYGON\\\",{polylist,\\\"LONLAT\\\",None,Automatic,\
Automatic,\\\"RANDOM\\\",(*dip*){\\\"UNIFORM\\\",{30 Degree,60. \
Degree}},(*strike*){\\\"UNIFORM\\\",{.0 Degree,360. Degree}}}} c) \
{\\\"FAULT\\\",{FaultEndPts->{{6.57874,51.0007,0.},{7.13905,50.5717,0.}}, \
FaultEndPtsCoordType->\\\"LONLAT\\\",FaultDip->75.,FaultDepthRange->{5.,25.} \
,FaultID->\\\"ERFT B\\\",SingleEventDipScatter->{10. \
Degree,1.,1.},SingleEventStrikeScatter->{10. \
Degree,1.,1.},SingleEventHypoScatter->{1.,1.,1.}}}.\>\""}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"Disaggregation", "::", "usage"}], 
   "=", "\"\<If set to \\\"ON\\\", all disaggregation information is \
returned. Otherwise, an empty list for the disaggregation info is returned.\>\
\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ModelName", "::", "usage"}], 
   "=", "\"\<Name of the model to be used for the calculation of the rupture \
length and width. E.g. \\\"WELLS&COPPERSMITH-GENERIC\\\".\>\""}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"IgnoreVariability", "::", "usage"}], 
    "=", "\"\<If set to True, the variability of the rupture length and width \
is ignored.\>\""}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"GMMSpectrumFaultStyle", "::", "usage"}], 
   "=", "\"\<\\\"N\\\", \\\"N/SS\\\", \\\"SS/N\\\", \\\"SS\\\", \\\"SS/R\\\", \
\\\"R/SS\\\", \\\"R\\\", \\\"T\\\", based on Table 1 from Bommer et al. \
(2003).\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"GMMSpectrumHangingWallFlag", "::", "usage"}], 
   "=", "\"\<True if site is on the hanging wall and false otherwise.\>\""}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.9520632375768023`*^9, 3.952063272256524*^9}, {
   3.95206336934794*^9, 3.952063417360647*^9}, {3.952063530353119*^9, 
   3.95206357707864*^9}, 3.952063670667694*^9, {3.9520637458310137`*^9, 
   3.952063773682823*^9}, 3.952063930732047*^9, {3.952063985513544*^9, 
   3.95206400246389*^9}, {3.952064035867285*^9, 3.95206410990357*^9}, {
   3.952064149072463*^9, 3.952064164100685*^9}, {3.952148674084817*^9, 
   3.952148674813826*^9}},
 CellLabel->
  "In[123]:=",ExpressionUUID->"244ddebf-0793-46df-90d8-39329beda84d"],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Options", "[", "SingleSourceHazard", "]"}], "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"GroundMotionValues", "->", 
        RowBox[{"{", 
         RowBox[{"0.1", ",", "0.5", ",", "1.0", ",", "1.5", ",", "2.5"}], 
         "}"}]}], ",", 
       RowBox[{"(*", 
        RowBox[{
        "same", " ", "units", " ", "as", " ", "the", " ", "ground", " ", 
         "motion", " ", "tables"}], "*)"}], "\[IndentingNewLine]", 
       RowBox[{"GroundMotionPeriod", "->", "0.02"}], ",", 
       RowBox[{"(*", "PGA", "*)"}], "\[IndentingNewLine]", 
       RowBox[{"MagLowHazCalc", "->", "5.0"}], ",", 
       RowBox[{"(*", 
        RowBox[{
        "Lowest", " ", "magnitude", " ", "to", " ", "be", " ", "iconisdered", 
         " ", "of", " ", "engineering", " ", "relevance", " ", "and", " ", 
         "included", " ", "in", " ", "hazard", " ", "calcualtions"}], "*)"}], 
       "\[IndentingNewLine]", 
       RowBox[{"GroundMotionModel", "->", "Automatic"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"HazardCalcMethod", "->", "\"\<MonteCarlo\>\""}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"SiteCoordinates", "->", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"N", "[", 
           RowBox[{"7", "+", 
            RowBox[{"29.5", "/", "60."}]}], "]"}], ",", 
          RowBox[{"N", "[", 
           RowBox[{"50", "+", 
            RowBox[{"24.5", "/", "60"}]}], "]"}], ",", "0."}], "}"}]}], ",", 
       RowBox[{"(*", 
        RowBox[{"Lon", ",", "lat", ",", 
         RowBox[{"z", " ", "below", " ", "NN", " ", "in", " ", "km"}]}], 
        "*)"}], 
       RowBox[{"SiteCoordinateType", "->", "\"\<LONLAT\>\""}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"SynCatRefPoint", "->", 
        RowBox[{"Mean", "[", "polylist", "]"}]}], ",", "\[IndentingNewLine]", 
       
       RowBox[{"SynCatUTMZone", "->", "Automatic"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"CatalogDuration", "->", "10000."}], ",", 
       RowBox[{"(*", "years", "*)"}], 
       RowBox[{"MainshockSeismicityModel", "->", 
        RowBox[{"{", 
         RowBox[{"\"\<DOUBLETRUNCATEDEXPONENTIAL\>\"", ",", 
          RowBox[{"{", 
           RowBox[{"mMIN", ",", "mMAX", ",", "ncum", ",", "bSTU"}], "}"}]}], 
         " ", 
         RowBox[{"(*", 
          RowBox[{
           RowBox[{"Mag", "-", "low"}], ",", 
           RowBox[{"Mag", "-", "upp"}], ",", 
           RowBox[{"annual", " ", "rate"}], ",", 
           RowBox[{
            RowBox[{"GR", " ", "b"}], "-", "value"}], ",", 
           RowBox[{
           "for", " ", "the", " ", "Poissonian", " ", "part", " ", "of", " ", 
            "the", " ", "seismicty"}]}], "*)"}], "}"}]}], ",", 
       RowBox[{"(*", 
        RowBox[{
         RowBox[{"AftershockSeismicityModel", "->", 
          RowBox[{"{", 
           RowBox[{"\"\<ETAS\>\"", ",", 
            RowBox[{"{", 
             RowBox[{
             "0.5", ",", "1.25", ",", "0.08", ",", "3.", ",", "7.", ",", 
              "0.8", ",", "1."}], "}"}]}], " ", 
           RowBox[{"(*", 
            RowBox[{"branchingfacAS", ",", "omoriP", ",", "omoriC", ",", 
             RowBox[{"Mag", "-", "minAS"}], ",", 
             RowBox[{"Mag", "-", "maxAS"}], ",", "alphaAS", ",", "bvalueAS"}],
             "*)"}], "}"}]}], ","}], "*)"}], "\[IndentingNewLine]", 
       RowBox[{"AftershockSeismicityModel", "->", 
        RowBox[{"{", 
         RowBox[{"\"\<NONE\>\"", ",", 
          RowBox[{"{", "}"}]}], 
         RowBox[{"(*", 
          RowBox[{"no", " ", "aftershocks"}], "*)"}], "}"}]}], ",", 
       RowBox[{"SCDepthDistributionInfo", "->", 
        RowBox[{"{", 
         RowBox[{"\"\<TRUNCATEDNORMAL\>\"", ",", 
          RowBox[{"{", 
           RowBox[{"10.", ",", "5.", ",", "3.", ",", "20."}], "}"}]}], 
         "}"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"DepthDistFname", "->", "\"\<CumProb2.dat\>\""}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"FocmecDistribution", "->", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"\"\<R\>\"", ",", 
            RowBox[{"1", "/", "3"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"\"\<SS\>\"", ",", 
            RowBox[{"1", "/", "3"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"\"\<N\>\"", ",", 
            RowBox[{"1", "/", "3"}]}], "}"}]}], "}"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"HangingWallEffect", "->", "Automatic"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"SeismicFractions", "->", 
        RowBox[{"{", 
         RowBox[{"0.2", ",", "0.8"}], "}"}]}], ",", 
       RowBox[{"(*", 
        RowBox[{
         RowBox[{
         "Defines", " ", "upper", " ", "and", " ", "lower", " ", "seismic", " ",
           "portion", " ", "of", " ", "rupture", " ", "planes", " ", "as", " ",
           "fraction", " ", "of", " ", "down"}], "-", 
         RowBox[{"dip", " ", "rupture", " ", "width"}]}], "*)"}], 
       "\[IndentingNewLine]", 
       RowBox[{"SeismogenicDepths", "->", 
        RowBox[{"{", 
         RowBox[{"3.", ",", "20."}], "}"}]}], ",", 
       RowBox[{"(*", 
        RowBox[{
        "Upper", " ", "and", " ", "lower", " ", "depth", " ", "of", " ", 
         "seismogenic", " ", "layer", " ", "in", " ", "km"}], "*)"}], 
       RowBox[{"(*", 
        RowBox[{
         RowBox[{"SpatialModel", "->", 
          RowBox[{"{", 
           RowBox[{"\"\<FRACTALINPOLYGON\>\"", ",", 
            RowBox[{"{", 
             RowBox[{"polylist", ",", "\"\<LONLAT\>\"", ",", "2.", ",", 
              RowBox[{"(*", "dip", "*)"}], 
              RowBox[{"{", 
               RowBox[{"\"\<UNIFORM\>\"", ",", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"30", " ", "Degree"}], ",", 
                  RowBox[{"60.", " ", "Degree"}]}], "}"}]}], "}"}], ",", 
              RowBox[{"(*", "strike", "*)"}], 
              RowBox[{"{", 
               RowBox[{"\"\<UNIFORM\>\"", ",", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{".0", " ", "Degree"}], ",", 
                  RowBox[{"360.", " ", "Degree"}]}], "}"}]}], "}"}]}], 
             "}"}]}], "}"}]}], ","}], "*)"}], "\[IndentingNewLine]", 
       RowBox[{"RandomNumberSeed", "->", "12345"}], ",", 
       RowBox[{"SpatialModel", "->", 
        RowBox[{"{", 
         RowBox[{"\"\<CATALOGWEIGHTEDPOLYGON\>\"", ",", 
          RowBox[{"{", 
           RowBox[{
           "polylist", ",", "\"\<LONLAT\>\"", ",", "None", ",", "Automatic", ",",
             "Automatic", ",", "\"\<RANDOM\>\"", ",", 
            RowBox[{"(*", "dip", "*)"}], 
            RowBox[{"{", 
             RowBox[{"\"\<UNIFORM\>\"", ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"30", " ", "Degree"}], ",", 
                RowBox[{"60.", " ", "Degree"}]}], "}"}]}], "}"}], ",", 
            RowBox[{"(*", "strike", "*)"}], 
            RowBox[{"{", 
             RowBox[{"\"\<UNIFORM\>\"", ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{".0", " ", "Degree"}], ",", 
                RowBox[{"360.", " ", "Degree"}]}], "}"}]}], "}"}]}], "}"}]}], 
         "}"}]}], ",", 
       RowBox[{"Disaggregation", "->", "\"\<OFF\>\""}], ",", 
       RowBox[{"(*", 
        RowBox[{"SingleSourceHazard", "[", 
         RowBox[{"opts", ":", 
          RowBox[{"OptionsPattern", "[", "]"}]}], "]"}], "*)"}], 
       RowBox[{"(*", 
        RowBox[{
        "options", " ", "for", " ", "rupturelength", " ", "and", " ", 
         "rupturewidth"}], "*)"}], "\[IndentingNewLine]", 
       RowBox[{"ModelName", "->", "\"\<WELLS&COPPERSMITH-GENERIC\>\""}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"IgnoreVariability", "->", "False"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"SingleSourceHazard", "[", 
      RowBox[{"opts", ":", 
       RowBox[{"OptionsPattern", "[", 
        RowBox[{"{", 
         RowBox[{
         "SingleSourceHazard", ",", "FullEQCatalogWithAllDistances", ",", 
          "ProbOfExcLogNormTrunc", ",", "ProbOfExcNormTrunc"}], "}"}], 
        "]"}]}], "]"}], ":=", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "tdur", ",", "gmamps", ",", "res", ",", "repi", ",", "rhyp", ",", 
         "rjb", ",", "rrup", ",", "rrms", ",", "rseis", ",", "hypdepth", ",", 
         "timelist", ",", "maglist", ",", "ruplen", ",", "rupwidth", ",", 
         "hwflag", ",", "site", ",", "poly", ",", "logdir", ",", "maglowcalc",
          ",", "gmmperiod", ",", "poeopts", ",", "gmm", ",", "distmetric", ",",
          "distlist", ",", "len", ",", "problist", ",", "epsilonlist", ",", 
         "medianfunc", ",", "sigmafunc", ",", "cut1func", ",", "i", ",", 
         "med", ",", "sigma", ",", "maxgm", ",", "debugON", ",", 
         "hazeventIDs", ",", "lambda", ",", "len2", ",", "maglist2", ",", 
         "distlist2", ",", "hazcalcmethod", ",", "pdfR", ",", "smlendist", ",",
          "rMIN", ",", "rMAX", ",", "r", ",", "smlenmag", ",", "mMIN", ",", 
         "mMAX", ",", "pdfM", ",", "magdist", ",", "magdistscale", ",", 
         "probexc", ",", "deltaM", ",", "deltaR", ",", "intfunc", ",", "m", ",",
          "excrate", ",", "hazintegral", ",", "condExcProb", ",", "testVAL", ",",
          "j", ",", "hazcurve", ",", "st", ",", "syngmvallist", ",", 
         "syngmval", ",", "noexc", ",", "pelist", ",", "distribtype", ",", 
         "disaggregval", ",", "hyposout", ",", "cornersout", ",", 
         "disagglist", ",", "focmecdistrib", ",", "fmeclist", ",", "hwON", ",",
          "opts3", ",", "modcomplx", ",", "distmetric2", ",", 
         "distmetriclist", ",", "distlist3", ",", "distlistGMM"}], "}"}], ",", 
       RowBox[{
        RowBox[{"tdur", "=", 
         RowBox[{"OptionValue", "[", "CatalogDuration", "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"gmamps", "=", 
         RowBox[{"OptionValue", "[", "GroundMotionValues", "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"gmm", "=", 
         RowBox[{"OptionValue", "[", "GroundMotionModel", "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"gmmperiod", "=", 
         RowBox[{"OptionValue", "[", "GroundMotionPeriod", "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"maglowcalc", "=", 
         RowBox[{"OptionValue", "[", "MagLowHazCalc", "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"hazcalcmethod", "=", 
         RowBox[{"OptionValue", "[", "HazardCalcMethod", "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"disaggregval", "=", 
         RowBox[{"OptionValue", "[", "Disaggregation", "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"focmecdistrib", "=", 
         RowBox[{"OptionValue", "[", "FocmecDistribution", "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"hwON", "=", 
         RowBox[{"OptionValue", "[", "HangingWallEffect", "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"disagglist", "=", 
         RowBox[{"{", "}"}]}], ";", 
        RowBox[{"(*", "default", "*)"}], 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"disaggregval", "===", "\"\<ON\>\""}], ",", 
          RowBox[{
           RowBox[{"hazcalcmethod", "=", "\"\<MonteCarlo\>\""}], ";"}]}], 
         "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{
          RowBox[{"showstate", "[", "\"\< \>\"", "]"}], ";"}], "*)"}], 
        RowBox[{"(*", "*)"}], 
        RowBox[{"(*", 
         RowBox[{
          RowBox[{"Print", "[", "\"\<In SingleSourceHazard:\>\"", "]"}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"Print", "[", 
           RowBox[{"Options", "[", "SingleSourceHazard", "]"}], "]"}], ";"}], 
         "*)"}], 
        RowBox[{"(*", 
         RowBox[{
         "Pass", " ", "all", " ", "relevant", " ", "options", " ", "which", " ",
           "might", " ", "have", " ", "been", " ", "set", " ", "to", " ", 
          "SingleSourceHazard", " ", "on", " ", "to", " ", 
          "FullEQCatalogWithAllDistances"}], "*)"}], 
        RowBox[{"SetOptions", "[", 
         RowBox[{"FullEQCatalogWithAllDistances", ",", 
          RowBox[{"Apply", "[", 
           RowBox[{"Sequence", ",", 
            RowBox[{"FilterRules", "[", 
             RowBox[{
              RowBox[{"Options", "[", "SingleSourceHazard", "]"}], ",", 
              RowBox[{
              "Options", "[", "FullEQCatalogWithAllDistances", "]"}]}], 
             "]"}]}], "]"}]}], "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"SetOptions", "[", 
         RowBox[{"FullEQCatalogWithAllDistances", ",", 
          RowBox[{"Apply", "[", 
           RowBox[{"Sequence", ",", 
            RowBox[{"FilterRules", "[", 
             RowBox[{
              RowBox[{"{", "opts", "}"}], ",", 
              RowBox[{
              "Options", "[", "FullEQCatalogWithAllDistances", "]"}]}], 
             "]"}]}], "]"}]}], "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"res", "=", 
         RowBox[{"FullEQCatalogWithAllDistances", "[", 
          RowBox[{
           RowBox[{"CatalogDuration", "->", "tdur"}], ",", 
           RowBox[{"Apply", "[", 
            RowBox[{"Sequence", ",", 
             RowBox[{"FilterRules", "[", 
              RowBox[{
               RowBox[{"{", "opts", "}"}], ",", 
               RowBox[{
               "Options", "[", "FullEQCatalogWithAllDistances", "]"}]}], 
              "]"}]}], "]"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
          "repi", ",", "rhyp", ",", "rjb", ",", "rrup", ",", "rrms", ",", 
           "rseis", ",", "hypdepth", ",", "timelist", ",", "maglist", ",", 
           "ruplen", ",", "rupwidth", ",", "hwflag", ",", "site", ",", "poly",
            ",", "logdir", ",", "hyposout", ",", "cornersout"}], "}"}], "=", 
         "res"}], ";", "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{
          RowBox[{"Return", "[", "res", "]"}], ";"}], "*)"}], 
        "\[IndentingNewLine]", 
        RowBox[{"fmeclist", "=", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"RandomFocmec", "[", 
            RowBox[{"FocmecFractions", "->", "focmecdistrib"}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"Length", "[", "hwflag", "]"}], "}"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{
          RowBox[{
          "Get", " ", "functions", " ", "to", " ", "describe", " ", "ground", 
           " ", "motion", " ", "model", " ", "as", " ", "function", " ", "of",
            " ", "mag"}], ",", "dist", ",", "period"}], "*)"}], 
        RowBox[{"(*", 
         RowBox[{
         "Pass", " ", "all", " ", "relevant", " ", "options", " ", "which", " ",
           "might", " ", "have", " ", "been", " ", "set", " ", "to", " ", 
          "SingleSourceHazard", " ", "on", " ", "to", " ", "GMMFunctions"}], 
         "*)"}], 
        RowBox[{"(*", 
         RowBox[{
          RowBox[{"SetOptions", "[", 
           RowBox[{"GMMFunctions", ",", 
            RowBox[{"Apply", "[", 
             RowBox[{"Sequence", ",", 
              RowBox[{"FilterRules", "[", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"Options", "[", "SingleSourceHazard", "]"}], "}"}], ",", 
                RowBox[{"Options", "[", "GMMFunctions", "]"}]}], "]"}]}], 
             "]"}]}], "]"}], ";"}], "*)"}], 
        RowBox[{"SetOptions", "[", 
         RowBox[{"GMMFunctions", ",", 
          RowBox[{"Apply", "[", 
           RowBox[{"Sequence", ",", 
            RowBox[{"FilterRules", "[", 
             RowBox[{
              RowBox[{"Options", "[", "SingleSourceHazard", "]"}], ",", 
              RowBox[{"Options", "[", "GMMFunctions", "]"}]}], "]"}]}], 
           "]"}]}], "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"SetOptions", "[", 
         RowBox[{"GMMFunctions", ",", 
          RowBox[{"Apply", "[", 
           RowBox[{"Sequence", ",", 
            RowBox[{"FilterRules", "[", 
             RowBox[{
              RowBox[{"{", "opts", "}"}], ",", 
              RowBox[{"Options", "[", "GMMFunctions", "]"}]}], "]"}]}], 
           "]"}]}], "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"res", "=", 
         RowBox[{"GMMFunctions", "[", "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
          "medianfunc", ",", "sigmafunc", ",", "cut1func", ",", 
           "distmetriclist", ",", "distribtype", ",", "modcomplx"}], "}"}], "=",
          "res"}], ";", "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{
          RowBox[{"Print", "[", 
           RowBox[{"\"\<Distmetric: \>\"", ",", "distmetriclist"}], "]"}], 
          ";"}], "*)"}], 
        RowBox[{"distmetric", "=", 
         RowBox[{"distmetriclist", "[", 
          RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{"select", " ", "proper", " ", "distance", " ", "list"}], 
         "*)"}], 
        RowBox[{"Which", "[", 
         RowBox[{
          RowBox[{"distmetric", "==", "\"\<REPI\>\""}], ",", 
          RowBox[{
           RowBox[{"distlist", "=", "repi"}], ";"}], ",", 
          RowBox[{"distmetric", "==", "\"\<RHYP\>\""}], ",", 
          RowBox[{
           RowBox[{"distlist", "=", "rhyp"}], ";"}], ",", 
          RowBox[{"distmetric", "==", "\"\<RJB\>\""}], ",", 
          RowBox[{
           RowBox[{"distlist", "=", "rjb"}], ";"}], ",", 
          RowBox[{"distmetric", "==", "\"\<RRUP\>\""}], ",", 
          RowBox[{
           RowBox[{"distlist", "=", "rrup"}], ";"}], ",", 
          RowBox[{"distmetric", "==", "\"\<RRMS\>\""}], ",", 
          RowBox[{
           RowBox[{"distlist", "=", "rrms"}], ";"}], ",", 
          RowBox[{"distmetric", "==", "\"\<RSEIS\>\""}], ",", 
          RowBox[{
           RowBox[{"distlist", "=", "rseis"}], ";"}], ",", "True", ",", 
          RowBox[{
           RowBox[{"Message", "[", 
            RowBox[{
             RowBox[{"HazardBasics", "::", "distanceMetric"}], ",", 
             "distmetric"}], "]"}], ";", "\[IndentingNewLine]", 
           RowBox[{"Return", "[", 
            RowBox[{"{", "}"}], "]"}], ";"}]}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{
         "For", " ", "intensities", " ", "more", " ", "than", " ", "one", " ",
           "distance", " ", "metric", " ", "might", " ", "be", " ", "needed", 
          " ", "in", " ", "case", " ", "the", " ", "intensity", " ", 
          "calulation", " ", "is", " ", "driven", " ", "by", " ", "a", " ", 
          "ground", " ", "motion", " ", "value"}], "*)"}], 
        RowBox[{"distlistGMM", "=", "distlist"}], ";", "\[IndentingNewLine]", 
        
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"Length", "[", "distmetriclist", "]"}], ">", "1"}], ",", 
          RowBox[{
           RowBox[{"distmetric2", "=", 
            RowBox[{"distmetriclist", "[", 
             RowBox[{"[", "2", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"distmetric2", "=!=", "\"\<REPI\>\""}], "&&", 
              RowBox[{"distmetric2", "=!=", "\"\<RHYP\>\""}], "&&", 
              RowBox[{"distmetric2", "=!=", "\"\<RJB\>\""}], "&&", 
              RowBox[{"distmetric2", "=!=", "\"\<RRUP\>\""}], "&&", 
              RowBox[{"distmetric2", "=!=", "\"\<RRMS\>\""}], "&&", 
              RowBox[{"distmetric2", "=!=", "\"\<RSEIS\>\""}]}], ",", 
             RowBox[{
              RowBox[{"distlistGMM", "=", "distlist"}], ";"}], ",", 
             RowBox[{"(*", 
              RowBox[{"select", " ", "proper", " ", "distance", " ", "list"}],
               "*)"}], 
             RowBox[{
              RowBox[{"Which", "[", 
               RowBox[{
                RowBox[{"distmetric2", "==", "\"\<REPI\>\""}], ",", 
                RowBox[{
                 RowBox[{"distlistGMM", "=", "repi"}], ";"}], ",", 
                RowBox[{"distmetric2", "==", "\"\<RHYP\>\""}], ",", 
                RowBox[{
                 RowBox[{"distlistGMM", "=", "rhyp"}], ";"}], ",", 
                RowBox[{"distmetric2", "==", "\"\<RJB\>\""}], ",", 
                RowBox[{
                 RowBox[{"distlistGMM", "=", "rjb"}], ";"}], ",", 
                RowBox[{"distmetric2", "==", "\"\<RRUP\>\""}], ",", 
                RowBox[{
                 RowBox[{"distlistGMM", "=", "rrup"}], ";"}], ",", 
                RowBox[{"distmetric2", "==", "\"\<RRMS\>\""}], ",", 
                RowBox[{
                 RowBox[{"distlistGMM", "=", "rrms"}], ";"}], ",", 
                RowBox[{"distmetric2", "==", "\"\<RSEIS\>\""}], ",", 
                RowBox[{
                 RowBox[{"distlistGMM", "=", "rseis"}], ";"}], ",", "True", ",", 
                RowBox[{
                 RowBox[{"Message", "[", 
                  RowBox[{
                   RowBox[{"HazardBasics", "::", "distanceMetric"}], ",", 
                   "distmetric2"}], "]"}], ";", "\[IndentingNewLine]", 
                 RowBox[{"Return", "[", 
                  RowBox[{"{", "}"}], "]"}], ";"}]}], "]"}], ";"}]}], "]"}], 
           ";"}]}], "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"(*", "*)"}], 
        RowBox[{"len", "=", 
         RowBox[{"Length", "[", "maglist", "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{
         "determine", " ", "event", " ", "numbers", " ", "above", " ", 
          "maglowcalc"}], "*)"}], 
        RowBox[{"hazeventIDs", "=", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"Transpose", "@", 
            RowBox[{"Select", "[", 
             RowBox[{
              RowBox[{"Transpose", "[", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"Table", "[", 
                  RowBox[{"i", ",", 
                   RowBox[{"{", 
                    RowBox[{"i", ",", "1", ",", "len"}], "}"}]}], "]"}], ",", 
                 "maglist"}], "}"}], "]"}], ",", 
              RowBox[{
               RowBox[{
                RowBox[{"#", "[", 
                 RowBox[{"[", "2", "]"}], "]"}], ">=", "maglowcalc"}], 
               "&"}]}], "]"}]}], ")"}], "[", 
          RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"maglist2", "=", 
         RowBox[{"maglist", "[", 
          RowBox[{"[", "hazeventIDs", "]"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"distlist2", "=", 
         RowBox[{"distlist", "[", 
          RowBox[{"[", "hazeventIDs", "]"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"distlist3", "=", 
         RowBox[{"distlistGMM", "[", 
          RowBox[{"[", "hazeventIDs", "]"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"len2", "=", 
         RowBox[{"Length", "[", "maglist2", "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{
          RowBox[{"Print", "[", 
           RowBox[{"\"\<Length of catalog: \>\"", ",", "len2"}], "]"}], ";"}],
          "*)"}], 
        RowBox[{"lambda", "=", 
         RowBox[{"len2", "/", "tdur"}]}], ";", 
        RowBox[{"(*", 
         RowBox[{
         "corresponding", " ", "number", " ", "of", " ", "events", " ", "per",
           " ", "year"}], "*)"}], 
        RowBox[{"(*", 
         RowBox[{
          RowBox[{"Print", "[", 
           RowBox[{"\"\<Period :\>\"", ",", "gmmperiod"}], "]"}], ";"}], 
         "*)"}], 
        RowBox[{"(*", 
         RowBox[{"Probability", " ", "of", " ", "exceedance"}], "*)"}], 
        RowBox[{"Clear", "[", "probexc", "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"probexc", "[", 
          RowBox[{"mag_", ",", "d_", ",", "val_", ",", "dtype_", ",", 
           RowBox[{"dGMM_", ":", 
            RowBox[{"-", "999."}]}], ",", "opts2___"}], "]"}], ":=", 
         RowBox[{"Module", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
            "med1", ",", "sigma1", ",", "cut1", ",", "trunclimits", ",", "ep",
              ",", "pexc", ",", "plot1", ",", "resperiod"}], "}"}], ",", 
           RowBox[{
            RowBox[{"resperiod", "=", "gmmperiod"}], ";", 
            RowBox[{"(*", 
             RowBox[{"resonator", " ", "period"}], "*)"}], 
            RowBox[{"med1", "=", 
             RowBox[{"medianfunc", "[", 
              RowBox[{
              "mag", ",", "d", ",", "resperiod", ",", "dGMM", ",", "opts2"}], 
              "]"}]}], ";", "\[IndentingNewLine]", 
            RowBox[{"sigma1", "=", 
             RowBox[{"sigmafunc", "[", 
              RowBox[{
              "mag", ",", "d", ",", "resperiod", ",", "dGMM", ",", "opts2"}], 
              "]"}]}], ";", "\[IndentingNewLine]", 
            RowBox[{"cut1", "=", 
             RowBox[{"cut1func", "[", 
              RowBox[{
              "mag", ",", "d", ",", "resperiod", ",", "dGMM", ",", "opts2"}], 
              "]"}]}], ";", "\[IndentingNewLine]", 
            RowBox[{"trunclimits", "=", 
             RowBox[{"{", 
              RowBox[{"0.", ",", "cut1"}], "}"}]}], ";", 
            "\[IndentingNewLine]", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{"dtype", "===", "\"\<LOGNORMAL\>\""}], ",", 
              RowBox[{
               RowBox[{"trunclimits", "=", 
                RowBox[{"{", 
                 RowBox[{"0.", ",", "cut1"}], "}"}]}], ";", 
               "\[IndentingNewLine]", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"pexc", ",", "plot1"}], "}"}], "=", 
                RowBox[{"ProbOfExcLogNormTrunc", "[", 
                 RowBox[{"val", ",", 
                  RowBox[{"LNDMedian", "->", "med1"}], ",", 
                  RowBox[{"LNDSigma", "->", "sigma1"}], ",", 
                  RowBox[{"TruncationLimits", "->", "trunclimits"}], ",", 
                  RowBox[{"PlotOn", "->", "\"\<OFF\>\""}], ",", 
                  RowBox[{"Outfile", "->", "\"\<\>\""}]}], "]"}]}], ";", 
               "\[IndentingNewLine]", 
               RowBox[{"ep", "=", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"Log", "[", "val", "]"}], "-", 
                   RowBox[{"Log", "[", "med1", "]"}]}], ")"}], "/", 
                 "sigma1"}]}], ";"}], ",", 
              RowBox[{
               RowBox[{"trunclimits", "=", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "Infinity"}], ",", "cut1"}], "}"}]}], ";", 
               "\[IndentingNewLine]", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"pexc", ",", "plot1"}], "}"}], "=", 
                RowBox[{"ProbOfExcNormTrunc", "[", 
                 RowBox[{"val", ",", 
                  RowBox[{"NDMean", "->", "med1"}], ",", 
                  RowBox[{"NDSigma", "->", "sigma1"}], ",", 
                  RowBox[{"TruncationLimits", "->", "trunclimits"}], ",", 
                  RowBox[{"PlotOn", "->", "\"\<OFF\>\""}], ",", 
                  RowBox[{"Outfile", "->", "\"\<\>\""}]}], "]"}]}], ";", 
               "\[IndentingNewLine]", 
               RowBox[{"ep", "=", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"val", "-", "med1"}], ")"}], "/", "sigma1"}]}], 
               ";"}]}], "]"}], ";", "\[IndentingNewLine]", 
            RowBox[{"Return", "[", 
             RowBox[{"{", 
              RowBox[{"pexc", ",", "ep"}], "}"}], "]"}], ";"}]}], "]"}]}], ";",
         "\[IndentingNewLine]", 
        RowBox[{"Which", "[", 
         RowBox[{
          RowBox[{"hazcalcmethod", "===", "\"\<HazardIntegral\>\""}], ",", 
          RowBox[{"(*", 
           RowBox[{"full", " ", "hazard", " ", "integral"}], "*)"}], 
          RowBox[{
           RowBox[{"Print", "[", 
            RowBox[{"\"\<Method: \>\"", ",", "hazcalcmethod"}], "]"}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"(*", 
            RowBox[{
            "smoothing", " ", "length", " ", "for", " ", "distance", " ", 
             "and", " ", "magnitudes"}], "*)"}], 
           RowBox[{"smlendist", "=", "1."}], ";", 
           RowBox[{"(*", 
            RowBox[{
            "changed", " ", "from", " ", "7.5", " ", "to", " ", "1", " ", 
             "by", " ", "NK", " ", "on", " ", "27.01", ".09"}], "*)"}], 
           RowBox[{"smlenmag", "=", ".2"}], ";", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"rMIN", ",", "rMAX", ",", "pdfR"}], "}"}], "=", 
            RowBox[{"DataList2PDF", "[", 
             RowBox[{
              RowBox[{"distlist", "/", "1000."}], ",", 
              RowBox[{"DFSmoothing", "->", "smlendist"}]}], "]"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"mMIN", ",", "mMAX", ",", "pdfM"}], "}"}], "=", 
            RowBox[{"DataList2PDF", "[", 
             RowBox[{"maglist", ",", 
              RowBox[{"DFSmoothing", "->", "smlenmag"}], ",", 
              RowBox[{"ScaleEndLow", "->", "maglowcalc"}]}], "]"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"(*", 
            RowBox[{
             RowBox[{
             "Below", " ", "is", " ", "the", " ", "exact", " ", "PDF", " ", 
              "for", " ", "magnitudes", " ", "for", " ", "doubly", " ", 
              "truncated", " ", 
              RowBox[{"exponential", ".", "However"}]}], ",", 
             RowBox[{"in", " ", "the", " ", "genral", " ", "case"}], ",", 
             RowBox[{
              RowBox[{
               RowBox[{
               "the", " ", "distribution", " ", "could", " ", "also", " ", 
                "be", " ", "uniform", " ", "or", " ", "Youngs"}], "&"}], " ", 
              
              RowBox[{"Coppersmith", ".", "Therefore"}]}], ",", 
             RowBox[{"take", " ", "the", " ", "empircal", " ", 
              RowBox[{"one", "."}]}]}], "*)"}], 
           RowBox[{"(*", 
            RowBox[{
             RowBox[{"Clear", "[", "pdfGR", "]"}], ";", "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"pdfGR", "[", 
               RowBox[{"mag_", ",", "magmin_", ",", "magmax_", ",", "b_"}], 
               "]"}], ":=", 
              RowBox[{"Piecewise", "[", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{"0.", ",", 
                   RowBox[{"mag", "<", "magmin"}]}], "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"b", " ", 
                    RowBox[{"Log", "[", "10.", "]"}], " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"Exp", "[", 
                    RowBox[{
                    RowBox[{"-", "b"}], " ", 
                    RowBox[{"Log", "[", "10.", "]"}], 
                    RowBox[{"(", 
                    RowBox[{"mag", "-", "magmin"}], ")"}]}], "]"}], ")"}], "/", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", 
                    RowBox[{"Exp", "[", 
                    RowBox[{
                    RowBox[{"-", "b"}], " ", 
                    RowBox[{"Log", "[", "10.", "]"}], 
                    RowBox[{"(", 
                    RowBox[{"magmax", "-", "magmin"}], ")"}]}], "]"}]}], 
                    ")"}]}]}], ",", 
                   RowBox[{"magmin", "<=", "mag", "<=", "magmax"}]}], "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"0.", ",", 
                   RowBox[{"mag", ">", "magmax"}]}], "}"}]}], "}"}], "]"}]}], 
             ";", "\[IndentingNewLine]", 
             RowBox[{"Clear", "[", "pdfM", "]"}], ";", "\[IndentingNewLine]", 
             
             RowBox[{
              RowBox[{"pdfM", "[", "mag_", "]"}], "=", 
              RowBox[{"pdfGR", "[", 
               RowBox[{"mag", ",", "mMIN", ",", "mMAX", ",", "bSTU"}], 
               "]"}]}], ";"}], "*)"}], 
           RowBox[{"(*", "*)"}], 
           RowBox[{"(*", 
            RowBox[{
             RowBox[{"Joint", " ", "magnitude"}], "-", 
             RowBox[{
             "distance", " ", "distribution", " ", "equals", " ", "product", " ",
               "of", " ", "PDF", " ", "for", " ", "magnitude", " ", "and", " ",
               "for", " ", "distance"}]}], "*)"}], 
           RowBox[{
            RowBox[{"magdist", "[", 
             RowBox[{"m2_", ",", "r2_"}], "]"}], ":=", 
            RowBox[{
             RowBox[{"pdfM", "[", "m2", "]"}], " ", 
             RowBox[{"pdfR", "[", "r2", "]"}]}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"(*", 
            RowBox[{
            "normalization", " ", "factor", " ", "of", " ", "joint", " ", 
             "distribution"}], "*)"}], 
           RowBox[{"Off", "[", 
            RowBox[{"NIntegrate", "::", "\"\<slwcon\>\""}], "]"}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"magdistscale", "=", 
            RowBox[{"NIntegrate", "[", 
             RowBox[{
              RowBox[{"magdist", "[", 
               RowBox[{"m", ",", "r"}], "]"}], ",", 
              RowBox[{"{", 
               RowBox[{"m", ",", "mMIN", ",", "mMAX"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"r", ",", "rMIN", ",", "rMAX"}], "}"}]}], "]"}]}], ";",
            "\[IndentingNewLine]", 
           RowBox[{"On", "[", 
            RowBox[{"NIntegrate", "::", "\"\<slwcon\>\""}], "]"}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"magdistscale", "=", "1."}], ";", "\[IndentingNewLine]", 
           RowBox[{"deltaM", "=", ".2"}], ";", "\[IndentingNewLine]", 
           RowBox[{"deltaR", "=", "1."}], ";", "\[IndentingNewLine]", 
           RowBox[{"(*", 
            RowBox[{
             RowBox[{"showstate", "[", "\"\< \>\"", "]"}], ";"}], "*)"}], 
           RowBox[{"hazcurve", "=", 
            RowBox[{"{", "}"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"For", "[", 
            RowBox[{
             RowBox[{"j", "=", "1"}], ",", 
             RowBox[{"j", "<=", 
              RowBox[{"Length", "[", "gmamps", "]"}]}], ",", 
             RowBox[{"j", "++"}], ",", 
             RowBox[{
              RowBox[{"testVAL", "=", 
               RowBox[{"gmamps", "[", 
                RowBox[{"[", "j", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
              
              RowBox[{"intfunc", "=", 
               RowBox[{"ListInterpolation", "[", 
                RowBox[{
                 RowBox[{"Table", "[", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"probexc", "[", 
                    RowBox[{
                    "m", ",", "r", ",", "testVAL", ",", "distribtype"}], 
                    "]"}], "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ",", 
                   RowBox[{"{", 
                    RowBox[{"m", ",", "mMIN", ",", "mMAX", ",", "deltaM"}], 
                    "}"}], ",", 
                   RowBox[{"{", 
                    RowBox[{"r", ",", "rMIN", ",", "rMAX", ",", "deltaR"}], 
                    "}"}]}], "]"}], ",", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"{", 
                    RowBox[{"mMIN", ",", "mMAX"}], "}"}], ",", 
                   RowBox[{"{", 
                    RowBox[{"rMIN", ",", "rMAX"}], "}"}]}], "}"}]}], "]"}]}], 
              ";", "\[IndentingNewLine]", 
              RowBox[{"Clear", "[", "condExcProb", "]"}], ";", 
              "\[IndentingNewLine]", 
              RowBox[{
               RowBox[{"condExcProb", "[", 
                RowBox[{"m_", ",", "r_"}], "]"}], "=", 
               RowBox[{"Piecewise", "[", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"intfunc", "[", 
                    RowBox[{"m", ",", "r"}], "]"}], ",", 
                    RowBox[{
                    RowBox[{"mMIN", "<=", "m", "<=", "mMAX"}], "&&", 
                    RowBox[{"rMIN", "<=", "r", "<=", "rMAX"}]}]}], "}"}], ",", 
                  RowBox[{"{", 
                   RowBox[{"0.", ",", 
                    RowBox[{
                    RowBox[{"m", "<", "mMIN"}], "||", 
                    RowBox[{"m", ">", "mMAX"}], "||", 
                    RowBox[{"r", "<", "rMIN"}], "||", 
                    RowBox[{"r", ">", "rMAX"}]}]}], "}"}]}], "}"}], "]"}]}], ";",
               "\[IndentingNewLine]", 
              RowBox[{"(*", 
               RowBox[{
                RowBox[{"Off", "[", 
                 RowBox[{"NIntegrate", "::", "\"\<slwcon\>\""}], "]"}], ";"}],
                "*)"}], 
              RowBox[{"hazintegral", "=", 
               RowBox[{"NIntegrate", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"magdist", "[", 
                   RowBox[{"m", ",", "r"}], "]"}], " ", 
                  RowBox[{
                   RowBox[{"condExcProb", "[", 
                    RowBox[{"m", ",", "r"}], "]"}], "/", "magdistscale"}]}], ",", 
                 RowBox[{"{", 
                  RowBox[{"m", ",", "mMIN", ",", "mMAX"}], "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"r", ",", "rMIN", ",", "rMAX"}], "}"}], ",", 
                 RowBox[{"Method", "->", "\"\<AdaptiveMonteCarlo\>\""}]}], 
                "]"}]}], ";", "\[IndentingNewLine]", 
              RowBox[{"(*", 
               RowBox[{
                RowBox[{"On", "[", 
                 RowBox[{"NIntegrate", "::", "\"\<slwcon\>\""}], "]"}], ";"}],
                "*)"}], 
              RowBox[{"excrate", "=", 
               RowBox[{"lambda", " ", "hazintegral"}]}], ";", 
              "\[IndentingNewLine]", 
              RowBox[{"st", "=", 
               RowBox[{
                RowBox[{"ToString", "[", "j", "]"}], "<>", "\"\< out of: \>\"",
                 "<>", 
                RowBox[{"ToString", "[", 
                 RowBox[{"Length", "[", "gmamps", "]"}], "]"}]}]}], ";", 
              "\[IndentingNewLine]", 
              RowBox[{"AppendTo", "[", 
               RowBox[{"hazcurve", ",", 
                RowBox[{"{", 
                 RowBox[{"testVAL", ",", "excrate"}], "}"}]}], "]"}], ";"}]}],
             "\[IndentingNewLine]", 
            RowBox[{"(*", 
             RowBox[{
              RowBox[{"showstate", "[", "st", "]"}], ";"}], "*)"}], "]"}], ";",
            "\[IndentingNewLine]", 
           RowBox[{"Return", "[", 
            RowBox[{"{", 
             RowBox[{"lambda", ",", "hazcurve", ",", "disagglist"}], "}"}], 
            "]"}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", ",", 
          RowBox[{"hazcalcmethod", "===", "\"\<MonteCarlo\>\""}], ",", 
          RowBox[{"(*", 
           RowBox[{
           "generate", " ", "sample", " ", "of", " ", "synthetic", " ", 
            "ground", " ", "motion", " ", "values", " ", "from", " ", 
            "catalog"}], "*)"}], 
          RowBox[{
           RowBox[{"Print", "[", 
            RowBox[{"\"\<Method: \>\"", ",", "hazcalcmethod"}], "]"}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"syngmvallist", "=", 
            RowBox[{"{", "}"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"epsilonlist", "=", 
            RowBox[{"{", "}"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"(*", 
            RowBox[{
             RowBox[{"showstate", "[", "\"\< \>\"", "]"}], ";"}], "*)"}], 
           "\[IndentingNewLine]", "\[IndentingNewLine]", 
           RowBox[{"(*", " ", 
            RowBox[{
            "Not", " ", "sure", " ", "yet", " ", "if", " ", "the", " ", 
             "following", " ", "will", " ", "be", " ", "needed", " ", "in", " ",
              "the", " ", 
             RowBox[{"end", ".", " ", "Depends"}], " ", "on", " ", "which", " ",
              "GMMs", " ", "I", " ", "will", " ", 
             RowBox[{"implement", "."}]}], " ", "*)"}], "\[IndentingNewLine]", 
           RowBox[{"For", "[", 
            RowBox[{
             RowBox[{"i", "=", "1"}], ",", 
             RowBox[{"i", "<=", "len2"}], ",", 
             RowBox[{"i", "++"}], ",", 
             RowBox[{
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{"hwON", "=!=", "Automatic"}], ",", 
                RowBox[{
                 RowBox[{"opts3", "=", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"GMMSpectrumFaultStyle", "->", 
                    RowBox[{"fmeclist", "[", 
                    RowBox[{"[", "i", "]"}], "]"}]}], ",", 
                    RowBox[{"GMMSpectrumHangingWallFlag", "->", "hwON"}]}], 
                   "}"}]}], ";"}], ",", 
                RowBox[{"opts3", "=", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"GMMSpectrumFaultStyle", "->", 
                    RowBox[{"fmeclist", "[", 
                    RowBox[{"[", "i", "]"}], "]"}]}], ",", 
                   RowBox[{"GMMSpectrumHangingWallFlag", "->", 
                    RowBox[{"hwflag", "[", 
                    RowBox[{"[", "i", "]"}], "]"}]}]}], "}"}]}]}], "]"}], ";",
               "\[IndentingNewLine]", "\[IndentingNewLine]", 
              RowBox[{"med", "=", 
               RowBox[{"N", "[", 
                RowBox[{"medianfunc", "[", 
                 RowBox[{
                  RowBox[{"maglist2", "[", 
                   RowBox[{"[", "i", "]"}], "]"}], ",", 
                  RowBox[{
                   RowBox[{"distlist2", "[", 
                    RowBox[{"[", "i", "]"}], "]"}], "/", "1000."}], ",", 
                  "gmmperiod", ",", 
                  RowBox[{
                   RowBox[{"distlist3", "[", 
                    RowBox[{"[", "i", "]"}], "]"}], "/", "1000."}], ",", 
                  RowBox[{"Apply", "[", 
                   RowBox[{"Sequence", ",", "opts3"}], "]"}]}], "]"}], 
                "]"}]}], ";", "\[IndentingNewLine]", 
              RowBox[{"sigma", "=", 
               RowBox[{"N", "[", 
                RowBox[{"sigmafunc", "[", 
                 RowBox[{
                  RowBox[{"maglist2", "[", 
                   RowBox[{"[", "i", "]"}], "]"}], ",", 
                  RowBox[{
                   RowBox[{"distlist2", "[", 
                    RowBox[{"[", "i", "]"}], "]"}], "/", "1000."}], ",", 
                  "gmmperiod", ",", 
                  RowBox[{
                   RowBox[{"distlist3", "[", 
                    RowBox[{"[", "i", "]"}], "]"}], "/", "1000."}], ",", 
                  RowBox[{"Apply", "[", 
                   RowBox[{"Sequence", ",", "opts3"}], "]"}]}], "]"}], 
                "]"}]}], ";", "\[IndentingNewLine]", 
              RowBox[{"maxgm", "=", 
               RowBox[{"N", "[", 
                RowBox[{"cut1func", "[", 
                 RowBox[{
                  RowBox[{"maglist2", "[", 
                   RowBox[{"[", "i", "]"}], "]"}], ",", 
                  RowBox[{
                   RowBox[{"distlist2", "[", 
                    RowBox[{"[", "i", "]"}], "]"}], "/", "1000."}], ",", 
                  "gmmperiod", ",", 
                  RowBox[{
                   RowBox[{"distlist3", "[", 
                    RowBox[{"[", "i", "]"}], "]"}], "/", "1000."}], ",", 
                  RowBox[{"Apply", "[", 
                   RowBox[{"Sequence", ",", "opts3"}], "]"}]}], "]"}], 
                "]"}]}], ";", "\[IndentingNewLine]", 
              RowBox[{"If", "[", 
               RowBox[{"debugON", ",", 
                RowBox[{"Print", "[", 
                 
                 RowBox[{"\"\<Median: \>\"", ",", "med", 
                  ",", "\"\< sigma: \>\"", ",", "sigma", 
                  ",", "\"\< maxgm : \>\"", ",", "maxgm"}], "]"}]}], "]"}], ";",
               "\[IndentingNewLine]", 
              RowBox[{"(*", 
               RowBox[{
                RowBox[{
                "randomly", " ", "select", " ", "gm", " ", "values", " ", 
                 "either", " ", "from", " ", "a", " ", "log"}], "-", 
                RowBox[{
                "normal", " ", "or", " ", "a", " ", "normal", " ", 
                 "distribution", " ", "depending", " ", "on", " ", 
                 "distribtype"}]}], "*)"}], 
              RowBox[{"syngmval", "=", 
               RowBox[{"Dice", "[", 
                RowBox[{"DiceInfo", "->", 
                 RowBox[{"{", 
                  RowBox[{"distribtype", ",", 
                   RowBox[{"{", 
                    RowBox[{"med", ",", "sigma", ",", "0.", ",", "maxgm"}], 
                    "}"}]}], "}"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
              RowBox[{"(*", 
               RowBox[{
                RowBox[{"Print", "[", 
                 RowBox[{
                 "distribtype", ",", "\"\< Med: \>\"", ",", "med", 
                  ",", "\"\< sigma: \>\"", ",", "sigma", 
                  ",", "\"\< maxgm : \>\"", ",", "maxgm", 
                  ",", "\"\< val: \>\"", ",", "syngmval"}], "]"}], ";"}], 
               "*)"}], 
              RowBox[{"(*", 
               RowBox[{
                RowBox[{"If", "[", 
                 RowBox[{
                  RowBox[{"i", "==", "1"}], ",", 
                  RowBox[{
                   RowBox[{"Print", "[", 
                    RowBox[{
                    "distribtype", ",", "\"\< Med: \>\"", ",", "med", 
                    ",", "\"\< sigma: \>\"", ",", "sigma", 
                    ",", "\"\< maxgm : \>\"", ",", "maxgm", 
                    ",", "\"\< val: \>\"", ",", "syngmval"}], "]"}], ";"}]}], 
                 "]"}], ";"}], "*)"}], 
              RowBox[{"AppendTo", "[", 
               RowBox[{"syngmvallist", ",", "syngmval"}], "]"}], ";", 
              "\[IndentingNewLine]", 
              RowBox[{"(*", 
               RowBox[{
                RowBox[{
                "the", " ", "epsilon", " ", "value", " ", "refers", " ", "to",
                  " ", "the", " ", "sigma", " ", "of", " ", "the", " ", 
                 "GMM"}], ",", "which", ",", "however", ",", 
                RowBox[{"may", " ", "be", " ", "overwritten"}]}], "*)"}], 
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{"disaggregval", "===", "\"\<ON\>\""}], ",", 
                RowBox[{
                 RowBox[{"If", "[", 
                  RowBox[{
                   RowBox[{"distribtype", "===", "\"\<LOGNORMAL\>\""}], ",", 
                   RowBox[{
                    RowBox[{"AppendTo", "[", 
                    RowBox[{"epsilonlist", ",", 
                    RowBox[{
                    RowBox[{"Log", "[", 
                    RowBox[{"syngmval", "/", "med"}], "]"}], "/", "sigma"}]}],
                     "]"}], ";"}], ",", 
                   RowBox[{
                    RowBox[{"AppendTo", "[", 
                    RowBox[{"epsilonlist", ",", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"syngmval", "-", "med"}], ")"}], "/", "sigma"}]}],
                     "]"}], ";"}]}], "]"}], ";"}]}], "]"}], ";", 
              "\[IndentingNewLine]", 
              RowBox[{"(*", 
               RowBox[{
                RowBox[{"If", "[", 
                 RowBox[{
                  RowBox[{
                   RowBox[{
                    RowBox[{"Log", "[", 
                    RowBox[{"syngmval", "/", "med"}], "]"}], "/", "sigma"}], ">",
                    "2."}], ",", 
                  RowBox[{
                   RowBox[{"Print", "[", 
                    RowBox[{"\"\<EPS: \>\"", ",", 
                    RowBox[{
                    RowBox[{"Log", "[", 
                    RowBox[{"syngmval", "/", "med"}], "]"}], "/", "sigma"}]}],
                     "]"}], ";"}]}], "]"}], ";"}], "*)"}], 
              RowBox[{"st", "=", 
               RowBox[{"\"\<(\>\"", "<>", 
                RowBox[{"ToString", "[", "i", "]"}], "<>", "\"\< of \>\"", "<>", 
                RowBox[{"ToString", "[", "len2", "]"}], "<>", "\"\<)\>\""}]}],
               ";"}]}], "\[IndentingNewLine]", 
            RowBox[{"(*", 
             RowBox[{
              RowBox[{"st", "=", 
               RowBox[{"\"\<(\>\"", "<>", 
                RowBox[{"ToString", "[", "i", "]"}], "<>", "\"\< of \>\"", "<>", 
                RowBox[{"ToString", "[", "len2", "]"}], "<>", "\"\<) : \>\"", 
                "<>", 
                RowBox[{"ToString", "[", "syngmval", "]"}], 
                "<>", "\"\< EPS: \>\"", "<>", 
                RowBox[{"ToString", "[", 
                 RowBox[{
                  RowBox[{"Log", "[", 
                   RowBox[{"syngmval", "/", "med"}], "]"}], "/", "sigma"}], 
                 "]"}]}]}], ";"}], "*)"}], "\[IndentingNewLine]", 
            RowBox[{"(*", 
             RowBox[{
              RowBox[{"showstate", "[", "st", "]"}], ";"}], "*)"}], "]"}], ";",
            "\[IndentingNewLine]", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"disaggregval", "===", "\"\<ON\>\""}], ",", 
             RowBox[{
              RowBox[{"disagglist", "=", 
               RowBox[{"{", 
                RowBox[{
                "syngmvallist", ",", "distlist", ",", "timelist", ",", 
                 "maglist", ",", "ruplen", ",", "rupwidth", ",", "hwflag", ",",
                  "site", ",", "poly", ",", "hyposout", ",", "cornersout", ",",
                  "epsilonlist", ",", "hazeventIDs"}], "}"}]}], ";"}]}], 
            "]"}], ";", "\[IndentingNewLine]", 
           RowBox[{"(*", 
            RowBox[{"count", " ", "exceedances", " ", "in", " ", "catalog"}], 
            "*)"}], 
           RowBox[{"hazcurve", "=", 
            RowBox[{"{", "}"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"For", "[", 
            RowBox[{
             RowBox[{"j", "=", "1"}], ",", 
             RowBox[{"j", "<=", 
              RowBox[{"Length", "[", "gmamps", "]"}]}], ",", 
             RowBox[{"j", "++"}], ",", 
             RowBox[{
              RowBox[{"testVAL", "=", 
               RowBox[{"gmamps", "[", 
                RowBox[{"[", "j", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
              
              RowBox[{"noexc", "=", 
               RowBox[{"Length", "[", 
                RowBox[{"Select", "[", 
                 RowBox[{"syngmvallist", ",", 
                  RowBox[{
                   RowBox[{"testVAL", "<=", "#"}], "&"}]}], "]"}], "]"}]}], ";",
               "\[IndentingNewLine]", 
              RowBox[{"st", "=", 
               RowBox[{"\"\<(\>\"", "<>", 
                RowBox[{"ToString", "[", "j", "]"}], "<>", "\"\< of \>\"", "<>", 
                RowBox[{"ToString", "[", 
                 RowBox[{"Length", "[", "gmamps", "]"}], "]"}], 
                "<>", "\"\<) : \>\"", "<>", 
                RowBox[{"ToString", "[", "noexc", "]"}], "<>", "\"\</\>\"", "<>", 
                RowBox[{"ToString", "[", 
                 RowBox[{"Length", "[", "len2", "]"}], "]"}]}]}], ";", 
              "\[IndentingNewLine]", 
              RowBox[{"AppendTo", "[", 
               RowBox[{"hazcurve", ",", 
                RowBox[{"{", 
                 RowBox[{"testVAL", ",", 
                  RowBox[{"lambda", " ", 
                   RowBox[{"noexc", "/", "len2"}]}]}], "}"}]}], "]"}], 
              ";"}]}], "\[IndentingNewLine]", 
            RowBox[{"(*", 
             RowBox[{
              RowBox[{"showstate", "[", "st", "]"}], ";"}], "*)"}], "]"}], ";",
            "\[IndentingNewLine]", 
           RowBox[{"Return", "[", 
            RowBox[{"{", 
             RowBox[{"lambda", ",", "hazcurve", ",", "disagglist"}], "}"}], 
            "]"}], ";"}], ",", 
          RowBox[{"hazcalcmethod", "===", "\"\<TimeDependent\>\""}], ",", 
          RowBox[{"(*", 
           RowBox[{
            RowBox[{"Print", "[", 
             RowBox[{"\"\<Method: \>\"", ",", "hazcalcmethod"}], "]"}], ";"}],
            "*)"}], 
          RowBox[{
           RowBox[{"problist", "=", 
            RowBox[{"{", "}"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"(*", 
            RowBox[{
            "Pass", " ", "all", " ", "relevant", " ", "options", " ", "which",
              " ", "might", " ", "have", " ", "been", " ", "set", " ", "to", " ",
              "SingleSourceHazard"}], "*)"}], 
           RowBox[{"poeopts", "=", 
            RowBox[{"FilterRules", "[", 
             RowBox[{
              RowBox[{"{", "opts", "}"}], ",", 
              RowBox[{"Options", "[", "ProbOfExcLogNormTrunc", "]"}]}], 
             "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"SetOptions", "[", 
            RowBox[{"ProbOfExcLogNormTrunc", ",", 
             RowBox[{"Apply", "[", 
              RowBox[{"Sequence", ",", "poeopts"}], "]"}]}], "]"}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"poeopts", "=", 
            RowBox[{"FilterRules", "[", 
             RowBox[{
              RowBox[{"{", "opts", "}"}], ",", 
              RowBox[{"Options", "[", "ProbOfExcNormTrunc", "]"}]}], "]"}]}], 
           ";", "\[IndentingNewLine]", 
           RowBox[{"SetOptions", "[", 
            RowBox[{"ProbOfExcNormTrunc", ",", 
             RowBox[{"Apply", "[", 
              RowBox[{"Sequence", ",", "poeopts"}], "]"}]}], "]"}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"For", "[", 
            RowBox[{
             RowBox[{"i", "=", "1"}], ",", 
             RowBox[{"i", "<=", "len2"}], ",", 
             RowBox[{"i", "++"}], ",", 
             RowBox[{"(*", 
              RowBox[{
              "list", " ", "of", " ", "exceedance", " ", "probabilities", " ",
                "for", " ", "each", " ", "event", " ", "at", " ", "site"}], 
              "*)"}], 
             RowBox[{
              RowBox[{"pelist", "=", 
               RowBox[{
                RowBox[{
                 RowBox[{
                  RowBox[{"probexc", "[", 
                   RowBox[{
                    RowBox[{"maglist2", "[", 
                    RowBox[{"[", "i", "]"}], "]"}], ",", 
                    RowBox[{
                    RowBox[{"distlist2", "[", 
                    RowBox[{"[", "i", "]"}], "]"}], "/", "1000."}], ",", "#", 
                    ",", "distribtype", ",", 
                    RowBox[{
                    RowBox[{"distlist3", "[", 
                    RowBox[{"[", "i", "]"}], "]"}], "/", "1000."}]}], "]"}], "[", 
                  RowBox[{"[", "1", "]"}], "]"}], "&"}], "/@", "gmamps"}]}], ";",
               "\[IndentingNewLine]", 
              RowBox[{"(*", 
               RowBox[{
               "list", " ", "of", " ", "epsilon", " ", "values", " ", "for", " ",
                 "each", " ", "event", " ", "at", " ", "site"}], "*)"}], 
              RowBox[{"(*", 
               RowBox[{
                RowBox[{"epslist", "=", 
                 RowBox[{
                  RowBox[{
                   RowBox[{
                    RowBox[{"probexc", "[", 
                    RowBox[{
                    RowBox[{"maglist2", "[", 
                    RowBox[{"[", "i", "]"}], "]"}], ",", 
                    RowBox[{
                    RowBox[{"distlist2", "[", 
                    RowBox[{"[", "i", "]"}], "]"}], "/", "1000."}], ",", "#", 
                    ",", "distribtype"}], "]"}], "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "&"}], "/@", "gmamps"}]}],
                 ";"}], "*)"}], 
              RowBox[{"AppendTo", "[", 
               RowBox[{"problist", ",", "pelist"}], "]"}], ";", 
              "\[IndentingNewLine]", 
              RowBox[{"st", "=", 
               RowBox[{
                RowBox[{"ToString", "[", "i", "]"}], "<>", "\"\< of \>\"", "<>", 
                RowBox[{"ToString", "[", "len2", "]"}]}]}], ";"}]}], 
            "\[IndentingNewLine]", 
            RowBox[{"(*", 
             RowBox[{
              RowBox[{"showstate", "[", "st", "]"}], ";"}], "*)"}], "]"}], ";",
            "\[IndentingNewLine]", 
           RowBox[{"hazcurve", "=", 
            RowBox[{"Transpose", "[", 
             RowBox[{"{", 
              RowBox[{"gmamps", ",", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"lambda", "/", "len2"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"Apply", "[", 
                    RowBox[{"Plus", ",", "#"}], "]"}], "&"}], "/@", 
                  RowBox[{"Transpose", "[", "problist", "]"}]}], ")"}]}]}], 
              "}"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"Return", "[", 
            RowBox[{"{", 
             RowBox[{"lambda", ",", "hazcurve", ",", "disagglist"}], "}"}], 
            "]"}], ";"}], ",", "True", ",", 
          RowBox[{
           RowBox[{"Message", "[", 
            RowBox[{
             RowBox[{"HazardBasics", "::", "hazcalcMethod"}], ",", 
             "hazcalcmethod"}], "]"}], ";", "\[IndentingNewLine]", 
           RowBox[{"Return", "[", 
            RowBox[{"{", "}"}], "]"}], ";"}]}], "]"}], ";"}]}], "]"}]}], 
    ";"}]}]}]], "Input",
 CellChangeTimes->{{3.952063069779632*^9, 3.9520630697811613`*^9}, 
   3.952063107402096*^9, {3.9520634299498577`*^9, 3.95206349273689*^9}, {
   3.9520638405701237`*^9, 3.952063851458652*^9}, 3.952084597217225*^9, {
   3.9521409907738934`*^9, 3.9521410293401823`*^9}, 3.952148285424753*^9, {
   3.952148389608656*^9, 3.952148390449389*^9}, {3.952148606239477*^9, 
   3.952148639832842*^9}, 3.9521546032595377`*^9, {3.9521546506242447`*^9, 
   3.952154656205105*^9}, {3.952155001381235*^9, 3.952155001975766*^9}},
 CellLabel->
  "In[148]:=",ExpressionUUID->"d9a6a322-633d-43f0-b259-d3f9f5bc625e"],

Cell[CellGroupData[{

Cell["ProbOfExcNormTrunc", "Subsection",
 CellChangeTimes->{
  3.9520646644258738`*^9, {3.952065204004053*^9, 
   3.9520652115822887`*^9}},ExpressionUUID->"e9e6a1fc-6f9a-4468-8230-\
66bca4bf944d"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"ProbOfExcNormTrunc", "::", "usage"}], 
   "=", "\"\<ProbOfExcNormTrunc[value] calculates and plots the probability \
of exceedance of  value for a doubly truncated normal distribution.\>\""}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"NDMean", "::", "usage"}], 
   "=", "\"\<NDMean defines the mean value (\[Mu]) of the normal distribution\
\>\""}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"NDSigma", "::", "usage"}], 
    "=", "\"\<NDSigma defines the standard deviation (\[Sigma]) of the normal \
distribution.\>\""}], ";"}], "\n", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"LogNormTrunc", "::", "usage"}], "=", 
    RowBox[{
     RowBox[{"\"\<LogNormTrunc returns either a single or a list of sampled \
values of the PDF or CDF  of  a possibly truncated Log-Normal distribution \
for which the parameters are given through the options.\>\"", "\n", 
      RowBox[{"LogSampleVals", "::", "usage"}]}], "=", 
     RowBox[{
      RowBox[{"\"\<LogSampleVals is an option to  LogNormTrunc. Sample range \
{xmin, xmax, Delta-Log-x} defines the sampling range. Sampling takes place in \
Log-10 steps of Delta-Log-x  from Log-10 (xmin)  to Log-10 (xmax). If only a \
single value is given, the corresponding PDF or CDF value is returned\>\"", "\n", 
       RowBox[{"DistribMode", "::", "usage"}]}], 
      "=", "\"\<DistribMode is an option for NormTrunc and LogNormTrunc \
defining the type of distribution function from which to draw samples.  \
\\\"PDF\\\" or \\\"CDF\\\" for probability density function or cumulative \
probability density function, respectively. \>\""}]}]}], "*)"}], "\n", 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"NormTrunc", "::", "usage"}], "=", 
    RowBox[{
     RowBox[{"\"\<NormTrunc returns either a single or a list of sampled \
values of the PDF or CDF  of a possibly truncated Normal distribution.\>\"", "\n", 
      RowBox[{"NDSampleVals", "::", "usage"}]}], 
     "=", "\"\<NDSampleVals given as {xmin, xmax Delta-x} is an option to \
NormTrunc which defines the sampling range. Sampling takes place in steps of \
Delta-x from xmin to xmax. If only a single value is given, the corresponding \
PDF or CDF value is returned\>\""}]}], "*)"}], "\n"}], "\[IndentingNewLine]", 

 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Options", "[", "ProbOfExcNormTrunc", "]"}], "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"NDMean", "->", "0."}], ",", 
      RowBox[{"NDSigma", "->", "1."}], ",", 
      RowBox[{"EnforcedEpsilon", "->", "None"}], ",", 
      RowBox[{"TruncationLimits", "->", "None"}], ",", 
      RowBox[{"PlotOn", "->", "\"\<OFF\>\""}], ",", 
      RowBox[{"PlotInterval", "->", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "5."}], ",", "5."}], "}"}]}], ",", 
      RowBox[{"Xticks", "->", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "5."}], ",", 
         RowBox[{"-", "4."}], ",", 
         RowBox[{"-", "3"}], ",", 
         RowBox[{"-", "2."}], ",", 
         RowBox[{"-", "1."}], ",", "0.", ",", "1.", ",", "2.", ",", "3.", ",",
          "4.", ",", "5."}], "}"}]}], ",", 
      RowBox[{"XtickLabels", "->", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "5"}], ",", 
         RowBox[{"-", "4"}], ",", 
         RowBox[{"-", "3"}], ",", 
         RowBox[{"-", "2"}], ",", 
         RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "2", ",", "3", ",", "4",
          ",", "5"}], "}"}]}], ",", 
      RowBox[{"Outfile", "->", "None"}], ",", 
      RowBox[{"GraphicsFormat", "->", "Automatic"}]}], "}"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"ProbOfExcNormTrunc", "[", 
    RowBox[{"testval_", ",", 
     RowBox[{"opts", ":", 
      RowBox[{"OptionsPattern", "[", 
       RowBox[{"{", 
        RowBox[{"ProbOfExcNormTrunc", ",", "Graphics"}], "}"}], "]"}]}]}], 
    "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "ndist", ",", "cdf", ",", "p", ",", "excprob", ",", "p1", ",", "p2", ",",
        "x", ",", "x1", ",", "x2", ",", "y2", ",", "plot", ",", "y", ",", 
       "pdfrenorm", ",", "cdfrenorm", ",", "toplabel", ",", "sigmaln", ",", 
       "epsilon", ",", "areared", ",", "me", ",", "std", ",", "pl3", ",", 
       "xt", ",", "tix", ",", "tilabx", ",", "ti", ",", "xmin", ",", "xmax", ",",
        "z", ",", "lnsigmain", ",", "tlimin", ",", "basename", ",", 
       "grformat", ",", "plopts", ",", "zt1type", ",", "lowerlimit", ",", 
       "ploton", ",", "pliv", ",", "tickx", ",", "labelx", ",", "zt1", ",", 
       "zt2", ",", "zmin", ",", "zmax", ",", "zt2type", ",", "format"}], 
      "}"}], ",", 
     RowBox[{
      RowBox[{"lowerlimit", "=", 
       RowBox[{"-", "Infinity"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"z", "=", 
       RowBox[{"OptionValue", "[", "NDMean", "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"lnsigmain", "=", 
       RowBox[{"OptionValue", "[", "NDSigma", "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"epsilon", "=", 
       RowBox[{"OptionValue", "[", "EnforcedEpsilon", "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"tlimin", "=", 
       RowBox[{"OptionValue", "[", "TruncationLimits", "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"ploton", "=", 
       RowBox[{"OptionValue", "[", "PlotOn", "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"pliv", "=", 
       RowBox[{"OptionValue", "[", "PlotInterval", "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"tickx", "=", 
       RowBox[{"OptionValue", "[", "Xticks", "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"labelx", "=", 
       RowBox[{"OptionValue", "[", "XtickLabels", "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"basename", "=", 
       RowBox[{"OptionValue", "[", "Outfile", "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"grformat", "=", 
       RowBox[{"OptionValue", "[", "GraphicsFormat", "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"epsilon", "=!=", "None"}], ",", 
        RowBox[{
         RowBox[{"z", "=", 
          RowBox[{"z", "+", 
           RowBox[{"epsilon", " ", "lnsigmain"}]}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"lnsigmain", "=", "0."}], ";"}]}], "\[IndentingNewLine]", 
       RowBox[{"(*", 
        RowBox[{
         RowBox[{"Print", "[", 
          
          RowBox[{"\"\<New median: \>\"", ",", "z", ",", "\"\< sigma: \>\"", ",",
            "lnsigmain"}], "]"}], ";"}], "*)"}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"xmin", ",", "xmax"}], "}"}], "=", "pliv"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"tlimin", "=!=", "None"}], ",", 
        RowBox[{"Which", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"Length", "[", "tlimin", "]"}], "==", "2"}], ",", 
          RowBox[{
           RowBox[{
            RowBox[{"{", 
             RowBox[{"zt1", ",", "zt2"}], "}"}], "=", "tlimin"}], ";"}], ",", 
          
          RowBox[{
           RowBox[{"Length", "[", "tlimin", "]"}], "==", "4"}], ",", 
          RowBox[{
           RowBox[{
            RowBox[{"{", 
             RowBox[{"zt1", ",", "zt2", ",", "zt1type", ",", "zt2type"}], 
             "}"}], "=", "tlimin"}], ";", "\[IndentingNewLine]", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"zt1type", "===", "\"\<REL2SIGMA\>\""}], ",", 
             RowBox[{"zt1", "=", 
              RowBox[{"z", "+", 
               RowBox[{"zt1", " ", "lnsigmain"}]}]}]}], "]"}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"zt2type", "===", "\"\<REL2SIGMA\>\""}], ",", 
             RowBox[{"zt2", "=", 
              RowBox[{"z", "+", 
               RowBox[{"zt2", " ", "lnsigmain"}]}]}]}], "]"}], ";"}], ",", 
          "True", ",", 
          RowBox[{"(*", "Default", "*)"}], 
          RowBox[{
           RowBox[{
            RowBox[{"{", 
             RowBox[{"zt1", ",", "zt2"}], "}"}], "=", 
            RowBox[{"{", 
             RowBox[{"lowerlimit", ",", "Infinity"}], "}"}]}], ";"}]}], "]"}],
         ",", 
        RowBox[{
         RowBox[{
          RowBox[{"{", 
           RowBox[{"zt1", ",", "zt2"}], "}"}], "=", 
          RowBox[{"{", 
           RowBox[{"lowerlimit", ",", "Infinity"}], "}"}]}], ";"}]}], "]"}], ";",
       "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"zt1", "<", "lowerlimit"}], ",", 
        RowBox[{"zmin", "=", "lowerlimit"}], ",", 
        RowBox[{
         RowBox[{"zmin", "=", "zt1"}], ";"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"zmax", "=", "zt2"}], ";", "\[IndentingNewLine]", 
      RowBox[{"x1", "=", "xmin"}], ";", "\[IndentingNewLine]", 
      RowBox[{"x2", "=", "xmax"}], ";", "\[IndentingNewLine]", 
      RowBox[{"plopts", "=", 
       RowBox[{"FilterOptions", "[", 
        RowBox[{"Plot", ",", 
         RowBox[{"PlotRange", "->", "All"}], ",", 
         RowBox[{"Frame", "->", "True"}], ",", 
         RowBox[{"FrameTicks", "->", "ti"}], ",", 
         RowBox[{"Axes", "->", "False"}], ",", 
         RowBox[{"DisplayFunction", "->", "$DisplayFunction"}], ",", 
         RowBox[{"PlotLabel", "->", "toplabel"}], ",", 
         RowBox[{"FrameLabel", "->", 
          RowBox[{"{", 
           
           RowBox[{"\"\<VALUE\>\"", ",", "\"\<PDF\>\"", ",", "\"\< \>\"", 
            ",", "\"\< \>\""}], "}"}]}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"SetOptions", "[", 
       RowBox[{"Plot", ",", "plopts"}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"lnsigmain", "<=", "0.01"}], ",", 
        RowBox[{
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"testval", "<=", "z"}], ",", 
           RowBox[{
            RowBox[{"excprob", "=", "1"}], ";"}], ",", 
           RowBox[{"excprob", "=", "0"}]}], "]"}], ";", "\[IndentingNewLine]", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"ploton", "=!=", "\"\<OFF\>\""}], ",", 
           RowBox[{
            RowBox[{"plopts", "=", 
             RowBox[{"FilterOptions", "[", 
              RowBox[{"Graphics", ",", 
               RowBox[{"PlotRange", "->", "All"}], ",", 
               RowBox[{"Frame", "->", "True"}], ",", 
               RowBox[{"FrameTicks", "->", "ti"}], ",", 
               RowBox[{"Axes", "->", "False"}], ",", 
               RowBox[{"DisplayFunction", "->", "$DisplayFunction"}], ",", 
               RowBox[{"PlotLabel", "->", "toplabel"}], ",", 
               RowBox[{"FrameLabel", "->", 
                RowBox[{"{", 
                 
                 RowBox[{"\"\<VALUE\>\"", ",", "\"\<PDF\>\"", ",", "\"\< \>\"",
                   ",", "\"\< \>\""}], "}"}]}]}], "]"}]}], ";", 
            "\[IndentingNewLine]", 
            RowBox[{"SetOptions", "[", 
             RowBox[{"Graphics", ",", "plopts"}], "]"}], ";", 
            "\[IndentingNewLine]", 
            RowBox[{"p1", "=", 
             RowBox[{"Show", "[", 
              RowBox[{
               RowBox[{"Graphics", "[", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"AbsoluteThickness", "[", "2", "]"}], ",", 
                  RowBox[{"RGBColor", "[", 
                   RowBox[{"0", ",", "0", ",", "0"}], "]"}], ",", 
                  RowBox[{"Line", "[", 
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"z", ",", "0."}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"z", ",", "10."}], "}"}]}], "}"}], "]"}]}], "}"}],
                 "]"}], ",", 
               RowBox[{"DisplayFunction", "->", "Identity"}]}], "]"}]}], ";", 
            "\[IndentingNewLine]", 
            RowBox[{"p2", "=", 
             RowBox[{"Show", "[", 
              RowBox[{
               RowBox[{"Graphics", "[", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"AbsoluteThickness", "[", "2", "]"}], ",", 
                  RowBox[{"RGBColor", "[", 
                   RowBox[{"0", ",", "0", ",", "0"}], "]"}], ",", 
                  RowBox[{"Line", "[", 
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"x1", ",", "0."}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"x2", ",", "0."}], "}"}]}], "}"}], "]"}]}], "}"}],
                 "]"}], ",", 
               RowBox[{"DisplayFunction", "->", "Identity"}]}], "]"}]}], ";", 
            "\[IndentingNewLine]", 
            RowBox[{"pl3", "=", 
             RowBox[{"Show", "[", 
              RowBox[{
               RowBox[{"Graphics", "[", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"AbsoluteThickness", "[", "2", "]"}], ",", 
                  RowBox[{"Dashing", "[", 
                   RowBox[{"{", 
                    RowBox[{"0.015", ",", "0.015"}], "}"}], "]"}], ",", 
                  RowBox[{"RGBColor", "[", 
                   RowBox[{"0", ",", "0", ",", "1"}], "]"}], ",", 
                  RowBox[{"Line", "[", 
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"testval", ",", "0."}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"testval", ",", "10."}], "}"}]}], "}"}], "]"}]}], 
                 "}"}], "]"}], ",", 
               RowBox[{"DisplayFunction", "->", "Identity"}]}], "]"}]}], 
            ";"}]}], "]"}], ";"}], ",", 
        RowBox[{
         RowBox[{"sigmaln", "=", "lnsigmain"}], ";", "\[IndentingNewLine]", 
         RowBox[{"Clear", "[", "ndist", "]"}], ";", "\[IndentingNewLine]", 
         RowBox[{"ndist", "=", 
          RowBox[{"NormalDistribution", "[", 
           RowBox[{"z", ",", "sigmaln"}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"Clear", "[", 
          RowBox[{"cdf", ",", "y2"}], "]"}], ";", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"cdf", "[", "y2_", "]"}], ":=", 
          RowBox[{"CDF", "[", 
           RowBox[{"ndist", ",", "y2"}], "]"}]}], ";", "\[IndentingNewLine]", 
         
         RowBox[{"(*", "renormalize", "*)"}], 
         RowBox[{"areared", "=", 
          RowBox[{
           RowBox[{"cdf", "[", "zmin", "]"}], "+", 
           RowBox[{"(", 
            RowBox[{"1", "-", 
             RowBox[{"cdf", "[", "zmax", "]"}]}], ")"}]}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"Clear", "[", 
          RowBox[{"pdfrenorm", ",", "cdfrenorm", ",", "y"}], "]"}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"pdfrenorm", "[", "y_", "]"}], ":=", 
          RowBox[{"Which", "[", 
           RowBox[{
            RowBox[{"y", "<=", "zmin"}], ",", "0.", ",", 
            RowBox[{"zmin", "<=", "y", "<=", "zmax"}], ",", 
            RowBox[{
             RowBox[{"PDF", "[", 
              RowBox[{"ndist", ",", "y"}], "]"}], "/", 
             RowBox[{"(", 
              RowBox[{"1", "-", "areared"}], ")"}]}], ",", 
            RowBox[{"y", ">", "zmax"}], ",", "0."}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"cdfrenorm", "[", "y_", "]"}], ":=", 
          RowBox[{"Which", "[", 
           RowBox[{
            RowBox[{"y", "<=", "zmin"}], ",", "0.", ",", 
            RowBox[{"zmin", "<=", "y", "<=", "zmax"}], ",", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"cdf", "[", "y", "]"}], "-", 
               RowBox[{"cdf", "[", "zmin", "]"}]}], ")"}], "/", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"cdf", "[", "zmax", "]"}], "-", 
               RowBox[{"cdf", "[", "zmin", "]"}]}], ")"}]}], ",", 
            RowBox[{"y", ">", "zmax"}], ",", "1"}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"p", "=", 
          RowBox[{"cdfrenorm", "[", "testval", "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"excprob", "=", 
          RowBox[{"1", "-", "p"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"me", "=", "z"}], ";", "\[IndentingNewLine]", 
         RowBox[{"std", "=", "sigmaln"}], ";", "\[IndentingNewLine]", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"ploton", "=!=", "\"\<OFF\>\""}], ",", 
           RowBox[{
            RowBox[{"p1", "=", 
             RowBox[{"Plot", "[", 
              RowBox[{
               RowBox[{"pdfrenorm", "[", "x", "]"}], ",", 
               RowBox[{"{", 
                RowBox[{"x", ",", "x1", ",", "x2"}], "}"}], ",", 
               RowBox[{"PlotStyle", "->", 
                RowBox[{"{", 
                 RowBox[{"AbsoluteThickness", "[", "2", "]"}], "}"}]}]}], 
              "]"}]}], ";", "\[IndentingNewLine]", 
            RowBox[{"p2", "=", 
             RowBox[{"Plot", "[", 
              RowBox[{
               RowBox[{"pdfrenorm", "[", "x", "]"}], ",", 
               RowBox[{"{", 
                RowBox[{"x", ",", "testval", ",", "x2"}], "}"}], ",", 
               RowBox[{"Filling", "->", "Axis"}], ",", 
               RowBox[{"FillingStyle", "->", 
                RowBox[{"RGBColor", "[", 
                 RowBox[{"1", ",", "0", ",", "0"}], "]"}]}]}], "]"}]}], ";", 
            "\[IndentingNewLine]", 
            RowBox[{"pl3", "=", 
             RowBox[{"Show", "[", 
              RowBox[{"Graphics", "[", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"AbsoluteThickness", "[", "2", "]"}], ",", 
                 RowBox[{"Dashing", "[", 
                  RowBox[{"{", 
                   RowBox[{"0.015", ",", "0.015"}], "}"}], "]"}], ",", 
                 RowBox[{"RGBColor", "[", 
                  RowBox[{"0.5", ",", "0", ",", ".5"}], "]"}], ",", 
                 RowBox[{"Line", "[", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{"testval", ",", "0."}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"testval", ",", 
                    RowBox[{"pdfrenorm", "[", "testval", "]"}]}], "}"}]}], 
                   "}"}], "]"}]}], "}"}], "]"}], "]"}]}], ";"}]}], "]"}], 
         ";"}]}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"ploton", "=!=", "\"\<OFF\>\""}], ",", 
        RowBox[{"(*", 
         RowBox[{
          RowBox[{"Print", "[", "excprob", "]"}], ";"}], "*)"}], 
        RowBox[{
         RowBox[{"toplabel", "=", 
          RowBox[{"\"\<Pe: \>\"", "<>", 
           RowBox[{"ToString", "[", "excprob", "]"}]}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"xt", "[", "xval_", "]"}], ":=", "xval"}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"(*", 
          RowBox[{
           RowBox[{"tix", "=", 
            RowBox[{"Transpose", "[", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"xt", "[", "tickx", "]"}], ",", 
               RowBox[{"Map", "[", 
                RowBox[{"ToString", ",", "tickx"}], "]"}]}], "}"}], "]"}]}], 
           ";"}], "*)"}], 
         RowBox[{"tix", "=", 
          RowBox[{"Transpose", "[", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"xt", "[", "tickx", "]"}], ",", 
             RowBox[{"Table", "[", 
              RowBox[{"\"\<\>\"", ",", 
               RowBox[{"{", 
                RowBox[{"Length", "[", "tickx", "]"}], "}"}]}], "]"}]}], 
            "}"}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"tilabx", "=", 
          RowBox[{"Transpose", "[", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"xt", "[", "labelx", "]"}], ",", 
             RowBox[{"Map", "[", 
              RowBox[{"ToString", ",", "labelx"}], "]"}]}], "}"}], "]"}]}], ";",
          "\[IndentingNewLine]", 
         RowBox[{"ti", "=", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Join", "[", 
             RowBox[{"tix", ",", "tilabx"}], "]"}], ",", "Automatic", ",", 
            "None", ",", "Automatic"}], "}"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"toplabel", "=", 
          RowBox[{"\"\<P(x > \>\"", "<>", 
           RowBox[{"ToString", "[", "testval", "]"}], "<>", "\"\< ) = \>\"", "<>", 
           RowBox[{"ToString", "[", "excprob", "]"}]}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"(*", 
          RowBox[{"Default", " ", "plot", " ", "setting"}], "*)"}], 
         RowBox[{"plot", "=", 
          RowBox[{"Show", "[", 
           RowBox[{"p1", ",", "p2", ",", "pl3", ",", 
            RowBox[{"FilterOptions", "[", 
             RowBox[{"Graphics", ",", "opts"}], "]"}], ",", 
            RowBox[{"DisplayFunction", "->", "$DisplayFunction"}]}], "]"}]}], 
         ";", "\[IndentingNewLine]", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"Head", "[", "basename", "]"}], "===", "String"}], ",", 
           RowBox[{
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{"grformat", "=!=", "Automatic"}], ",", 
              RowBox[{"format", "=", "grformat"}], ",", 
              RowBox[{"format", "=", "DefaultGraphicsFormat"}]}], "]"}], ";", 
            "\[IndentingNewLine]", 
            RowBox[{"Export", "[", 
             RowBox[{
              RowBox[{"StringJoin", "[", 
               RowBox[{"basename", ",", "\"\<.\>\"", ",", 
                RowBox[{"ToLowerCase", "[", "format", "]"}]}], "]"}], ",", 
              "plot", ",", "format"}], "]"}], ";", "\[IndentingNewLine]", 
            RowBox[{"Print", "[", 
             RowBox[{"StringJoin", "[", 
              RowBox[{
               RowBox[{"Directory", "[", "]"}], ",", "\"\<\\nImage file: \>\"",
                ",", "basename", ",", "\"\<.\>\"", ",", 
               RowBox[{"ToLowe