(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Wolfram 14.2' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       154,          7]
NotebookDataLength[  40334569,     664808]
NotebookOptionsPosition[  40331543,     664755]
NotebookOutlinePosition[  40331939,     664771]
CellTagsIndexPosition[  40331896,     664768]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "Title figure for ",
 StyleBox["Fundamental Concepts of \nProbabilistic Seismic Hazard Analysis ", 
  "Subtitle",
  FontSize->48]
}], "Title",
 CellChangeTimes->{{3.947391415550271*^9, 3.947391424639997*^9}, 
   3.947393193223259*^9, {3.947575011347905*^9, 3.9475750117033157`*^9}, {
   3.947575483096147*^9, 3.9475754891537447`*^9}, {3.955768705453294*^9, 
   3.9557687222746267`*^9}, {3.9557689855667143`*^9, 3.955769004750822*^9}, {
   3.9557916918024397`*^9, 3.955791727183477*^9}, {3.955792368613742*^9, 
   3.955792369092197*^9}, {3.9557925239082603`*^9, 
   3.9557925251376553`*^9}},ExpressionUUID->"07f56d04-032b-47a2-942d-\
3bc77494944d"],

Cell["", "Text",
 CellChangeTimes->{{3.947399008867056*^9, 3.9473991502999763`*^9}, 
   3.947575888073802*^9},ExpressionUUID->"800b62f0-dd63-4494-87de-\
0c23a9561e71"],

Cell[CellGroupData[{

Cell["titleImage", "Section",
 CellChangeTimes->{{3.9518090431712923`*^9, 
  3.951809056593793*^9}},ExpressionUUID->"923e51c3-713d-4909-9e4e-\
110f30fb1377"],

Cell[CellGroupData[{

Cell["Initialization code for titleImage", "Subsection",
 CellChangeTimes->{{3.951809062774835*^9, 3.95180908054949*^9}, {
  3.9557689701166973`*^9, 3.955768978231146*^9}},
 $CellContext`InitializationGroup -> 
 True,ExpressionUUID->"c6e2f5e8-e527-447a-8c9a-d4cd4f370add"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", 
   RowBox[{
   "mlow", ",", " ", "mupp", ",", " ", "bval", ",", " ", "sig", ",", " ", 
    "testval", ",", " ", "dm", ",", " ", "accmin", ",", " ", "accmax", ",", 
    " ", "acclevels", ",", " ", "haz", ",", "i"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"mlow", " ", "=", " ", "5."}], ";"}], "\n", 
 RowBox[{
  RowBox[{"mupp", " ", "=", " ", "7.5"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"bval", " ", "=", " ", "1."}], ";"}], "\n", 
 RowBox[{
  RowBox[{"sig", " ", "=", 
   RowBox[{
    RowBox[{"pgaPredicted", "[", 
     RowBox[{"6.", ",", "50."}], "]"}], "[", 
    RowBox[{"[", "2", "]"}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"testval", "=", "1."}], ";"}], "\n", 
 RowBox[{
  RowBox[{"dm", " ", "=", " ", "0.1"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"accmin", " ", "=", " ", "0.1"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"accmax", " ", "=", " ", "3."}], ";"}], "\n", 
 RowBox[{
  RowBox[{"acclevels", " ", "=", " ", 
   RowBox[{"Range", "[", 
    RowBox[{"accmin", ",", " ", "accmax", ",", " ", "0.1"}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"fs", " ", "=", "28"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tifs", " ", "=", " ", "20"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"is", " ", "=", "500"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ls", " ", "=", " ", "8"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"ff", " ", "=", " ", "\"\<Helvetica\>\""}], ";"}], "\n", 
 RowBox[{
  RowBox[{"ms", " ", "=", " ", "10"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"dist", " ", "=", " ", "50"}], ";"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{"same", " ", "as", " ", "in", " ", "deagg"}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"accCut", "=", " ", "1."}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"theme", "=", "\"\<Classic\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"colorfc", "=", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"ColorData", "[", "\"\<GrayTones\>\"", "]"}], "[", 
      RowBox[{
       RowBox[{"#", " ", "0."}], " ", "+", ".85"}], "]"}], "&"}], ")"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"colorfc", "=", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"ColorData", "[", "\"\<GrayYellowTones\>\"", "]"}], "[", 
      RowBox[{
       RowBox[{"#", " ", "0."}], " ", "+", ".85"}], "]"}], "&"}], ")"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"colorfc", "=", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"ColorData", "[", "\"\<Atoms\>\"", "]"}], "[", 
      RowBox[{
       RowBox[{"#", " ", "0."}], " ", "+", ".85"}], "]"}], "&"}], ")"}]}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.444468449984375*^9, 3.4444684715625*^9}, {
   3.4444688455*^9, 3.44446884578125*^9}, {3.4446557133168383`*^9, 
   3.4446557211251993`*^9}, {3.444655817196527*^9, 3.4446558175624123`*^9}, {
   3.444656992368403*^9, 3.444657046927991*^9}, {3.58121913175458*^9, 
   3.581219137074251*^9}, {3.581221034830701*^9, 3.581221037101153*^9}, 
   3.581221152478397*^9, {3.581221539755909*^9, 3.581221574405258*^9}, {
   3.581221666589314*^9, 3.581221672708246*^9}, {3.58122183718064*^9, 
   3.58122183745503*^9}, {3.581222355140291*^9, 3.58122235557489*^9}, {
   3.581222589803516*^9, 3.581222594358007*^9}, {3.581222648899173*^9, 
   3.5812226606896563`*^9}, {3.581222690941532*^9, 3.581222696339675*^9}, {
   3.581642412721005*^9, 3.581642440691822*^9}, {3.581924195145583*^9, 
   3.581924199803396*^9}, {3.582273543243823*^9, 3.5822735726089153`*^9}, {
   3.582273831516593*^9, 3.582273872041696*^9}, {3.5822739582982388`*^9, 
   3.582274000512347*^9}, {3.582274087072227*^9, 3.58227412977563*^9}, {
   3.5822742065637302`*^9, 3.58227424552957*^9}, {3.5822742807396812`*^9, 
   3.582274286648278*^9}, {3.582274316875572*^9, 3.582274354169106*^9}, {
   3.582275920406168*^9, 3.5822759539401617`*^9}, {3.5822760770199337`*^9, 
   3.582276082186221*^9}, {3.582346286479251*^9, 3.582346336878213*^9}, {
   3.582346533283373*^9, 3.582346538310746*^9}, {3.58234659142481*^9, 
   3.5823465963950663`*^9}, {3.5823466347101307`*^9, 3.582346791243641*^9}, 
   3.582436669237298*^9, {3.582436722074024*^9, 3.5824367227614307`*^9}, {
   3.5824367704814167`*^9, 3.582436814357757*^9}, {3.5824368974159527`*^9, 
   3.582436944435255*^9}, {3.582436986295556*^9, 3.582436986581717*^9}, 
   3.582437021488227*^9, {3.582964343789329*^9, 3.582964347764642*^9}, 
   3.582964387213871*^9, {3.582964489655973*^9, 3.582964505270217*^9}, {
   3.582964592066121*^9, 3.582964666008772*^9}, {3.943701660599636*^9, 
   3.943701689517393*^9}, 3.9465633487732573`*^9, {3.94689920737202*^9, 
   3.9468992408965807`*^9}, {3.9468993223060293`*^9, 3.946899367184115*^9}, {
   3.9468995310428343`*^9, 3.946899532701831*^9}, {3.9468998418351717`*^9, 
   3.946899843560075*^9}, {3.946899898868642*^9, 3.946899942480484*^9}, {
   3.946900484348753*^9, 3.9469004955884447`*^9}, 3.946900545872278*^9, {
   3.946900596622279*^9, 3.9469006018387527`*^9}, {3.946900813058353*^9, 
   3.946900849814069*^9}, {3.947575771265171*^9, 3.947575838011989*^9}},
 CellLabel->"In[1]:=",
 $CellContext`InitializationGroup -> 
 True,ExpressionUUID->"1f08b265-1c1c-4387-995f-3edc8af73517"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"pgaAkkarEtal2013RepiHor", "::", "usage"}], 
   "=", "\"\<pgaAkkarEtal2013RepiHor[options] returns PGA using the model of \
Akkar et al.  (2013) for the epicentral distance distance as intrinsic \
distance metric.\>\""}], ";"}], "\n", 
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**",
      "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", 
     "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**",
      "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", 
     "**"}], "*"}], "*)"}], 
  RowBox[{"(*", 
   RowBox[{
   "Extract", " ", "PGA", " ", "as", " ", "separate", " ", "model", " ", 
    "for", " ", "examples"}], "*)"}], 
  RowBox[{
   RowBox[{
    RowBox[{"Options", "[", "pgaAkkarEtal2013RepiHor", "]"}], "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"MagMW", "->", "6."}], ",", 
      RowBox[{"DistEPI", "->", "10."}], ",", 
      RowBox[{"Vs30", "->", "760."}], ",", 
      RowBox[{"FaultTypeNSSR", "->", "\"\<STRIKE SLIP\>\""}]}], "}"}]}], 
   ";"}]}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"pgaAkkarEtal2013RepiHor", "[", 
    RowBox[{"opts", ":", 
     RowBox[{"OptionsPattern", "[", "]"}]}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "mw", ",", "rdist", ",", "vs30", ",", "faulttypeinp", ",", "a1", ",", 
       "a2", ",", "a3", ",", "a4", ",", "a5", ",", "a6", ",", "a7", ",", "a8",
        ",", "a9", ",", "c1", ",", "vcon", ",", "vref", ",", "c", ",", "n", ",",
        "b1", ",", "b2", ",", "sd1", ",", "sd2", ",", "sd", ",", "nrec", ",", 
       "neq", ",", "nst", ",", "fn", ",", "fr", ",", "lnPGAref", ",", "lns", ",",
        "lny", ",", "saval", ",", "sigtotal"}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "a1", ",", "a2", ",", "a3", ",", "a4", ",", "a5", ",", "a6", ",", 
         "a7", ",", "a8", ",", "a9", ",", "c1", ",", "vcon", ",", "vref", ",",
          "c", ",", "n", ",", "b1", ",", "b2", ",", "sd1", ",", "sd2", ",", 
         "sd", ",", "nrec", ",", "neq", ",", "nst"}], "}"}], "=", 
       RowBox[{"{", 
        RowBox[{"2.52977`", ",", "0.0029`", ",", 
         RowBox[{"-", "0.05496`"}], ",", 
         RowBox[{"-", "1.31001`"}], ",", "0.2529`", ",", "7.5`", ",", 
         RowBox[{"-", "0.5096`"}], ",", 
         RowBox[{"-", "0.1091`"}], ",", "0.0937`", ",", "6.75`", ",", "1000", 
         ",", "750", ",", "2.5`", ",", "3.2`", ",", 
         RowBox[{"-", "0.41997`"}], ",", 
         RowBox[{"-", "0.28846`"}], ",", "0.6375`", ",", "0.3581`", ",", 
         "0.7312`", ",", "1041", ",", "221", ",", "322"}], "}"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", 
       RowBox[{"**", 
        RowBox[{"*", "Options"}]}], "****)"}], 
      RowBox[{"mw", "=", 
       RowBox[{"OptionValue", "[", "MagMW", "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"rdist", "=", 
       RowBox[{"OptionValue", "[", "DistEPI", "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"vs30", "=", 
       RowBox[{"OptionValue", "[", "Vs30", "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"faulttypeinp", "=", 
       RowBox[{"OptionValue", "[", "FaultTypeNSSR", "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Which", "[", 
       RowBox[{
        RowBox[{"faulttypeinp", "==", "\"\<NORMAL\>\""}], ",", 
        RowBox[{
         RowBox[{"fn", "=", "1."}], ";", "\[IndentingNewLine]", 
         RowBox[{"fr", "=", "0."}], ";"}], ",", 
        RowBox[{"faulttypeinp", "==", "\"\<STRIKE SLIP\>\""}], ",", 
        RowBox[{
         RowBox[{"fn", "=", "0."}], ";", "\[IndentingNewLine]", 
         RowBox[{"fr", "=", "0."}], ";"}], ",", 
        RowBox[{"faulttypeinp", "==", "\"\<REVERSE\>\""}], ",", 
        RowBox[{
         RowBox[{"fn", "=", "0."}], ";", "\[IndentingNewLine]", 
         RowBox[{"fr", "=", "1."}], ";"}], ",", "True", ",", 
        RowBox[{
         RowBox[{"Message", "[", 
          RowBox[{
           RowBox[{"EmpiricalEquation", "::", "option"}], ",", "faulttypeinp",
            ",", "FaultTypeNSSR"}], "]"}], ";", "\[IndentingNewLine]", 
         RowBox[{"Return", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "999."}], ",", 
            RowBox[{"-", "999."}], ",", 
            RowBox[{"-", "999."}], ",", 
            RowBox[{"-", "999."}]}], "}"}], "]"}], ";"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"mw", "<=", "c1"}], ",", 
        RowBox[{
         RowBox[{"lnPGAref", "=", 
          RowBox[{"a1", "+", 
           RowBox[{"a2", "*", 
            RowBox[{"(", 
             RowBox[{"mw", "-", "c1"}], ")"}]}], "+", 
           RowBox[{"a3", "*", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"8.5", "-", "mw"}], ")"}], "^", "2"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"a4", "+", 
              RowBox[{"a5", "*", 
               RowBox[{"(", 
                RowBox[{"mw", "-", "c1"}], ")"}]}]}], ")"}], " ", 
            RowBox[{"Log", "[", 
             RowBox[{"Sqrt", "[", 
              RowBox[{
               RowBox[{"rdist", "^", "2"}], "+", 
               RowBox[{"a6", "^", "2"}]}], "]"}], "]"}]}], "+", 
           RowBox[{"a8", "*", "fn"}], "+", 
           RowBox[{"a9", "*", "fr"}]}]}], ";"}], ",", 
        RowBox[{"(*", 
         RowBox[{
          RowBox[{"else", " ", "mw"}], ">", "c1"}], "*)"}], 
        RowBox[{
         RowBox[{"lnPGAref", "=", 
          RowBox[{"a1", "+", 
           RowBox[{"a7", "*", 
            RowBox[{"(", 
             RowBox[{"mw", "-", "c1"}], ")"}]}], "+", 
           RowBox[{"a3", "*", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"8.5", "-", "mw"}], ")"}], "^", "2"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"a4", "+", 
              RowBox[{"a5", "*", 
               RowBox[{"(", 
                RowBox[{"mw", "-", "c1"}], ")"}]}]}], ")"}], " ", 
            RowBox[{"Log", "[", 
             RowBox[{"Sqrt", "[", 
              RowBox[{
               RowBox[{"rdist", "^", "2"}], "+", 
               RowBox[{"a6", "^", "2"}]}], "]"}], "]"}]}], "+", 
           RowBox[{"a8", "*", "fn"}], "+", 
           RowBox[{"a9", "*", "fr"}]}]}], ";"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"vs30", "<=", "vref"}], ",", 
        RowBox[{
         RowBox[{"lns", "=", 
          RowBox[{
           RowBox[{"b1", " ", 
            RowBox[{"Log", "[", 
             RowBox[{"vs30", "/", "vref"}], "]"}]}], "+", 
           RowBox[{"b2", " ", 
            RowBox[{"Log", "[", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"Exp", "[", "lnPGAref", "]"}], "+", 
                RowBox[{"c", " ", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"vs30", "/", "vref"}], ")"}], "^", "n"}]}]}], 
               ")"}], "/", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"Exp", "[", "lnPGAref", "]"}], "+", "c"}], ")"}], " ", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"vs30", "/", "vref"}], ")"}], "^", "n"}]}], ")"}]}],
              "]"}]}]}]}], ";"}], ",", 
        RowBox[{
         RowBox[{"lns", "=", 
          RowBox[{"b1", " ", 
           RowBox[{"Log", "[", 
            RowBox[{
             RowBox[{"Min", "[", 
              RowBox[{"vs30", ",", "vcon"}], "]"}], "/", "vref"}], "]"}]}]}], 
         ";"}]}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"(*", 
       RowBox[{"*", "lnY"}], "**)"}], 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"mw", "<=", "c1"}], ",", 
        RowBox[{
         RowBox[{"lny", "=", 
          RowBox[{"a1", "+", 
           RowBox[{"a2", "*", 
            RowBox[{"(", 
             RowBox[{"mw", "-", "c1"}], ")"}]}], "+", 
           RowBox[{"a3", "*", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"8.5", "-", "mw"}], ")"}], "^", "2"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"a4", "+", 
              RowBox[{"a5", "*", 
               RowBox[{"(", 
                RowBox[{"mw", "-", "c1"}], ")"}]}]}], ")"}], " ", 
            RowBox[{"Log", "[", 
             RowBox[{"Sqrt", "[", 
              RowBox[{
               RowBox[{"rdist", "^", "2"}], "+", 
               RowBox[{"a6", "^", "2"}]}], "]"}], "]"}]}], "+", 
           RowBox[{"a8", "*", "fn"}], "+", 
           RowBox[{"a9", "*", "fr"}], "+", "lns"}]}], ";"}], ",", 
        RowBox[{"(*", 
         RowBox[{
          RowBox[{"else", " ", "mw"}], ">", "c1"}], "*)"}], 
        RowBox[{
         RowBox[{"lny", "=", 
          RowBox[{"a1", "+", 
           RowBox[{"a7", "*", 
            RowBox[{"(", 
             RowBox[{"mw", "-", "c1"}], ")"}]}], "+", 
           RowBox[{"a3", "*", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"8.5", "-", "mw"}], ")"}], "^", "2"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"a4", "+", 
              RowBox[{"a5", "*", 
               RowBox[{"(", 
                RowBox[{"mw", "-", "c1"}], ")"}]}]}], ")"}], "*", 
            RowBox[{"Log", "[", 
             RowBox[{"Sqrt", "[", 
              RowBox[{
               RowBox[{"rdist", "^", "2"}], "+", 
               RowBox[{"a6", "^", "2"}]}], "]"}], "]"}]}], "+", 
           RowBox[{"a8", "*", "fn"}], "+", 
           RowBox[{"a9", "*", "fr"}], "+", "lns"}]}], ";"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", "PGA", "*)"}], 
      RowBox[{"(*", 
       RowBox[{"PGA", " ", "in", " ", 
        RowBox[{"m", "/", "s"}], "*", "s"}], "*)"}], 
      RowBox[{"saval", "=", 
       RowBox[{"9.81", "*", 
        RowBox[{"Exp", "[", "lny", "]"}]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"sigtotal", "=", "sd"}], ";", "\[IndentingNewLine]", 
      RowBox[{"Return", "[", 
       RowBox[{"{", 
        RowBox[{"saval", ",", "sigtotal"}], "}"}], "]"}], ";"}]}], "]"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.95180862967173*^9, 3.9518086296737013`*^9}, {
  3.9518087123912983`*^9, 3.9518087213801517`*^9}},
 CellLabel->"In[23]:=",
 $CellContext`InitializationGroup -> 
 True,ExpressionUUID->"d6144291-b1a4-4a5b-a512-b74ee5f04814"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Clear", "[", 
   RowBox[{
   "pdfGR", ",", "pgaPredicted", ",", "ProbOfExcLogNormTrunc2", ",", "cdfGR", 
    ",", "deagg", ",", "flog", ",", "make3Dhistplot"}], "]"}], ";"}]], "Input",\

 CellChangeTimes->{{3.946562951129045*^9, 3.946562955450391*^9}, {
  3.946563071413239*^9, 3.9465630859569902`*^9}, {3.946899704302788*^9, 
  3.946899706868841*^9}},
 CellLabel->"In[26]:=",
 $CellContext`InitializationGroup -> 
 True,ExpressionUUID->"0287a0a0-f9e0-4f4f-b870-291d8ff94ddc"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"pdfGR", "[", 
    RowBox[{"mag_", ",", "magmin_", ",", "magmax_", ",", "b_"}], "]"}], ":=", 
   
   RowBox[{"Piecewise", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0.", ",", 
        RowBox[{"mag", "<", "magmin"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"b", " ", 
         RowBox[{"Log", "[", "10.", "]"}], " ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"Exp", "[", 
            RowBox[{
             RowBox[{"-", "b"}], " ", 
             RowBox[{"Log", "[", "10.", "]"}], 
             RowBox[{"(", 
              RowBox[{"mag", "-", "magmin"}], ")"}]}], "]"}], ")"}], "/", 
          RowBox[{"(", 
           RowBox[{"1", "-", 
            RowBox[{"Exp", "[", 
             RowBox[{
              RowBox[{"-", "b"}], " ", 
              RowBox[{"Log", "[", "10.", "]"}], 
              RowBox[{"(", 
               RowBox[{"magmax", "-", "magmin"}], ")"}]}], "]"}]}], ")"}]}]}],
         ",", 
        RowBox[{"magmin", "\[LessEqual]", "mag", "\[LessEqual]", "magmax"}]}],
        "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.", ",", 
        RowBox[{"mag", ">", "magmax"}]}], "}"}]}], "}"}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.946562951129045*^9, 3.946562955450391*^9}, {
  3.946563071413239*^9, 3.946563078904408*^9}},
 CellLabel->"In[27]:=",
 $CellContext`InitializationGroup -> 
 True,ExpressionUUID->"bf6fde50-d681-4e49-bda4-2f9850debd48"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"pgaPredicted", "[", 
    RowBox[{"mw_", ",", "repi_", ",", 
     RowBox[{"vs30_", ":", "760."}]}], "]"}], ":=", 
   RowBox[{"pgaAkkarEtal2013RepiHor", "[", 
    RowBox[{
     RowBox[{"MagMW", "\[Rule]", "mw"}], ",", 
     RowBox[{"DistEPI", "\[Rule]", "repi"}], ",", 
     RowBox[{"Vs30", "\[Rule]", "vs30"}], ",", 
     RowBox[{"FaultTypeNSSR", "\[Rule]", "\"\<STRIKE SLIP\>\""}]}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.946562951129045*^9, 3.946562955450391*^9}, 
   3.946563071413239*^9},
 CellLabel->"In[28]:=",
 $CellContext`InitializationGroup -> 
 True,ExpressionUUID->"d6384f60-0a72-4d8b-be7c-0ffde6cc79f8"],

Cell[BoxData[
 RowBox[{
  RowBox[{"cdfGR", "[", 
   RowBox[{"mag_", ",", "magmin_", ",", "magmax_", ",", "b_"}], "]"}], " ", ":=",
   " ", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"1", "-", 
     RowBox[{"Exp", "[", 
      RowBox[{
       RowBox[{"-", "b"}], " ", 
       RowBox[{"Log", "[", "10.", "]"}], " ", 
       RowBox[{"(", 
        RowBox[{"mag", "-", "magmin"}], ")"}]}], "]"}]}], ")"}], "/", 
   RowBox[{"(", 
    RowBox[{"1", "-", 
     RowBox[{"Exp", "[", 
      RowBox[{
       RowBox[{"-", "b"}], " ", 
       RowBox[{"Log", "[", "10.", "]"}], 
       RowBox[{"(", 
        RowBox[{"magmax", "-", "magmin"}], ")"}]}], "]"}]}], 
    ")"}]}]}]], "Input",
 CellLabel->"In[29]:=",
 $CellContext`InitializationGroup -> 
 True,ExpressionUUID->"36bd2b4b-8ac5-4e95-b822-aa36931a098b"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ProbOfExcLogNormTrunc2", "[", 
    RowBox[{"testval_", ",", "med_", ",", "sigma_", ",", "tlimits_"}], "]"}], 
   ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "ndist", ",", "cdf", ",", "p", ",", "excprob", ",", "p1", ",", "p2", ",",
        "x", ",", "x1", ",", "x2", ",", "plot", ",", "y", ",", "pdfrenorm", ",",
        "cdfrenorm", ",", "toplabel", ",", "sigmaln", ",", "epsilon", ",", 
       "areared", ",", "pl3", ",", "xt", ",", "tix", ",", "tilabx", ",", "ti",
        ",", "xmin", ",", "xmax", ",", "lnsigmain", ",", "tlimin", ",", 
       "basename", ",", "grformat", ",", "zt1type", ",", "lowerlimit", ",", 
       "ploton", ",", "pliv", ",", "tickx", ",", "labelx", ",", "zt1", ",", 
       "zt2", ",", "zmin", ",", "zmax", ",", "zt2type", ",", "zin", ",", 
       "axtype", ",", "opts2", ",", "format", ",", "mu", ",", "plrange", ",", 
       "pw", ",", "maxplotval", ",", "maxval", ",", "lnsigmamin"}], "}"}], ",",
      "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"zt1", ",", "zt2"}], "}"}], "=", "tlimits"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"mu", " ", "=", " ", 
       RowBox[{"Log", "[", "med", "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"zmin", "=", 
       RowBox[{"Max", "[", 
        RowBox[{
         RowBox[{"Re", "[", 
          RowBox[{"Exp", "[", 
           RowBox[{"mu", "+", 
            RowBox[{"zt1", " ", "sigma"}]}], "]"}], "]"}], ",", "0."}], 
        "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"zmax", "=", 
       RowBox[{"Max", "[", 
        RowBox[{
         RowBox[{"Re", "[", 
          RowBox[{"Exp", "[", 
           RowBox[{"mu", "+", 
            RowBox[{"zt2", " ", "sigma"}]}], "]"}], "]"}], ",", "0."}], 
        "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Clear", "[", "ndist", "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"Clear", "[", 
       RowBox[{"pdfrenorm", ",", "cdfrenorm", ",", "y"}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{"ndist", "=", 
         RowBox[{"LogNormalDistribution", "[", 
          RowBox[{"med", ",", "sigma"}], "]"}]}], ";"}], "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"ndist", "=", 
       RowBox[{"LogNormalDistribution", "[", 
        RowBox[{"mu", ",", "sigma"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"cdfrenorm", "[", "y_", "]"}], ":=", 
       RowBox[{"Which", "[", 
        RowBox[{
         RowBox[{"y", "<", "zmin"}], ",", "0.", ",", 
         RowBox[{"zmin", "\[LessEqual]", "y", "\[LessEqual]", "zmax"}], ",", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"CDF", "[", 
             RowBox[{"ndist", ",", "y"}], "]"}], "-", 
            RowBox[{"CDF", "[", 
             RowBox[{"ndist", ",", "zmin"}], "]"}]}], ")"}], "/", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"CDF", "[", 
             RowBox[{"ndist", ",", "zmax"}], "]"}], "-", 
            RowBox[{"CDF", "[", 
             RowBox[{"ndist", ",", "zmin"}], "]"}]}], ")"}]}], ",", 
         RowBox[{"y", ">", "zmax"}], ",", "1"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"p", "=", 
       RowBox[{"cdfrenorm", "[", "testval", "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"excprob", "=", 
       RowBox[{"1", "-", "p"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Return", "[", "excprob", "]"}], ";"}]}], "\[IndentingNewLine]",
     "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.946563091633555*^9, 3.946563125789336*^9}},
 CellLabel->"In[30]:=",
 $CellContext`InitializationGroup -> 
 True,ExpressionUUID->"5265a405-1bdd-4a3e-93f8-67158bd5318d"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"deagg", "[", 
    RowBox[{
    "mlow_", ",", "mupp_", ",", "bval_", ",", "sig_", ",", "testval_"}], 
    "]"}], " ", ":=", " ", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "dist", ",", "mmin", ",", "dm", ",", "tlim", ",", "magrange", ",", 
       "magrangemean", ",", "probmag", ",", "med", ",", "probexc", ",", 
       "probmagexc", ",", "lambda", ",", "hazard"}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"dist", " ", "=", " ", "50"}], ";", "\[IndentingNewLine]", 
      RowBox[{"mmin", " ", "=", " ", "5"}], ";", "\[IndentingNewLine]", 
      RowBox[{"dm", " ", "=", " ", "0.1"}], ";", "\[IndentingNewLine]", 
      RowBox[{"tlim", " ", "=", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "Infinity"}], ",", "Infinity"}], "}"}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"magrange", " ", "=", " ", 
       RowBox[{"Range", "[", 
        RowBox[{"mlow", ",", "mupp", ",", "dm"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"magrangemean", " ", "=", " ", 
       RowBox[{"Range", "[", 
        RowBox[{
         RowBox[{"mlow", "+", 
          RowBox[{"dm", "/", "2"}]}], ",", 
         RowBox[{"mupp", "-", 
          RowBox[{"dm", "/", "2"}]}], ",", "dm"}], "]"}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"probmag", " ", "=", " ", 
       RowBox[{"Differences", "[", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"cdfGR", "[", 
           RowBox[{"i", ",", "mmin", ",", "mupp", ",", "bval"}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"i", ",", "mlow", ",", "mupp", ",", "dm"}], "}"}]}], "]"}],
         "]"}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"med", " ", "=", " ", 
       RowBox[{"Map", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"pgaPredicted", "[", 
            RowBox[{"#", ",", "dist"}], "]"}], "[", 
           RowBox[{"[", "1", "]"}], "]"}], "&"}], ",", "magrangemean"}], 
        "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"probexc", " ", "=", " ", 
       RowBox[{"Map", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"ProbOfExcLogNormTrunc2", "[", 
           RowBox[{"testval", ",", "#", ",", "sig", ",", "tlim"}], "]"}], 
          "&"}], ",", "med"}], "]"}]}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"probmagexc", " ", "=", " ", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"probmag", "[", 
           RowBox[{"[", "i", "]"}], "]"}], " ", 
          RowBox[{"probexc", "[", 
           RowBox[{"[", "i", "]"}], "]"}]}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", 
           RowBox[{"Length", "[", "probmag", "]"}]}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"lambda", " ", "=", " ", 
       RowBox[{"pdfGR", "[", 
        RowBox[{"mlow", ",", "mmin", ",", "mupp", ",", "bval"}], "]"}]}], ";",
       "\[IndentingNewLine]", 
      RowBox[{"hazard", " ", "=", " ", 
       RowBox[{"lambda", " ", 
        RowBox[{"Total", "[", "probmagexc", "]"}]}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"Return", "[", 
       RowBox[{"{", 
        RowBox[{
        "magrangemean", ",", "probmag", ",", "probexc", ",", "probmagexc", ",",
          "hazard"}], "}"}], "]"}], ";"}]}], "\[IndentingNewLine]", "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{3.946563027557007*^9},
 CellLabel->"In[31]:=",
 $CellContext`InitializationGroup -> 
 True,ExpressionUUID->"4c43151e-0ae3-4768-87f0-1825f99a75cf"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"flog", "[", 
    RowBox[{"m_", ",", "r_", ",", "pga_"}], "]"}], " ", ":=", " ", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"me", ",", "std", ",", "out"}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"me", ",", "std"}], "}"}], " ", "=", " ", 
       RowBox[{"pgaPredicted", "[", 
        RowBox[{"m", ",", " ", "r"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"out", " ", "=", " ", 
       RowBox[{"PDF", "[", 
        RowBox[{
         RowBox[{"NormalDistribution", "[", 
          RowBox[{
           RowBox[{"Log", "[", "me", "]"}], ",", "std"}], "]"}], ",", 
         RowBox[{"Re", "[", "pga", "]"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Return", "[", 
       RowBox[{"Re", "[", "out", "]"}], "]"}], ";"}]}], "\[IndentingNewLine]",
     "]"}]}], ";"}]], "Input",
 CellLabel->"In[32]:=",
 $CellContext`InitializationGroup -> 
 True,ExpressionUUID->"75adb483-f9aa-4440-a1f0-729100bdc9b4"],

Cell[BoxData[
 RowBox[{
  RowBox[{"make3Dhistplot", "[", 
   RowBox[{"scfac_", ",", "logpgaplot_", ",", "prm_", ",", "maglist_"}], 
   "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", "i", "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EdgeForm", "[", "Green", "]"}], ",", "Black", ",", 
        RowBox[{"Opacity", "[", "1.", "]"}], ",", 
        RowBox[{"Polygon", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"maglist", "[", 
              RowBox[{"[", "i", "]"}], "]"}], ",", "logpgaplot", ",", "0"}], 
            "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"maglist", "[", 
              RowBox[{"[", 
               RowBox[{"i", "+", "1"}], "]"}], "]"}], ",", "logpgaplot", ",", 
             "0"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"maglist", "[", 
              RowBox[{"[", 
               RowBox[{"i", "+", "1"}], "]"}], "]"}], ",", "logpgaplot", ",", 
             
             RowBox[{"scfac", " ", 
              RowBox[{"prm", "[", 
               RowBox[{"[", "i", "]"}], "]"}]}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"maglist", "[", 
              RowBox[{"[", "i", "]"}], "]"}], ",", "logpgaplot", ",", 
             RowBox[{"scfac", " ", 
              RowBox[{"prm", "[", 
               RowBox[{"[", "i", "]"}], "]"}]}]}], "}"}]}], "}"}], "]"}]}], 
       "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", 
        RowBox[{"Length", "[", "prm", "]"}]}], "}"}]}], "]"}]}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", "]"}]}]], "Input",
 CellChangeTimes->{3.946899695791361*^9},
 CellLabel->"In[33]:=",
 $CellContext`InitializationGroup -> 
 True,ExpressionUUID->"3b1beb01-f5a1-4090-9911-adbc787d488f"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"MagnitudesFromDistribution", "::", "usage"}], 
   "=", "\"\<MagnitudesFromDistribution [n] returns a list  of n  synthetic \
magnitudes. The type of distribution  is determined by the option \
MagnitudeDistribution. \>\""}], "\[IndentingNewLine]"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"MagnitudeDistribution", "::", "usage"}], 
   "=", "\"\<Option for MagnitudesFromDistribution[]\>\""}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Options", "[", "MagnitudesFromDistribution", "]"}], "=", 
   RowBox[{"{", 
    RowBox[{"MagnitudeDistribution", "->", 
     RowBox[{"{", 
      RowBox[{"\"\<DOUBLETRUNCATEDEXPONENTIAL\>\"", ",", 
       RowBox[{"{", 
        RowBox[{"4.", ",", "8.", ",", "1."}], "}"}]}], "}"}]}], 
    RowBox[{"(*", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Name", " ", "of", " ", "distribution"}], ",", 
       RowBox[{"{", 
        RowBox[{"magmin", ",", "magmax", ",", 
         RowBox[{"b", "-", "value"}]}], "}"}]}]}], "*)"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"MagnitudesFromDistribution", "[", 
     RowBox[{"n_", ",", 
      RowBox[{"opts", ":", 
       RowBox[{"OptionsPattern", "[", 
        RowBox[{"{", "MagnitudesFromDistribution", "}"}], "]"}]}]}], "]"}], ":=", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "magdistrib", ",", "dtype", ",", "mmin", ",", "mmax", ",", "b", ",", 
        "fracGR", ",", "n1", ",", "n2", ",", "grmr", ",", "umr", ",", 
        RowBox[{"deltam", "=", "0.5"}], " ", 
        RowBox[{"(*", 
         RowBox[{
         "width", " ", "of", " ", "characteristic", " ", "magnitude"}], 
         "*)"}], ",", "maglist1", ",", "maglist2", ",", "maglist"}], "}"}], ",", 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{
         RowBox[{"{", "magdistrib", "}"}], "=", 
         RowBox[{
          RowBox[{
           RowBox[{"{", "MagnitudeDistribution", "}"}], "/.", " ", 
           RowBox[{"{", "opts", "}"}]}], "/.", " ", 
          RowBox[{"Options", "[", "MagnitudesFromDistribution", "]"}]}]}], 
        ";"}], "*)"}], 
      RowBox[{
       RowBox[{"magdistrib", "=", 
        RowBox[{"OptionValue", "[", "MagnitudeDistribution", "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"dtype", "=", 
        RowBox[{"magdistrib", "[", 
         RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"Which", "[", 
        RowBox[{
         RowBox[{"dtype", "===", "\"\<DOUBLETRUNCATEDEXPONENTIAL\>\""}], ",", 
         
         RowBox[{
          RowBox[{
           RowBox[{"{", 
            RowBox[{"mmin", ",", "mmax", ",", "b"}], "}"}], "=", 
           RowBox[{"magdistrib", "[", 
            RowBox[{"[", "2", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"maglist", "=", 
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"GRInverseCDF", "[", 
              RowBox[{
               RowBox[{"RandomReal", "[", "]"}], ",", "b", ",", "mmin", ",", 
               "mmax"}], "]"}], ",", 
             RowBox[{"{", "n", "}"}]}], "]"}]}], ";"}], ",", 
         RowBox[{"dtype", "===", "\"\<UNIFORM\>\""}], ",", 
         RowBox[{
          RowBox[{
           RowBox[{"{", 
            RowBox[{"mmin", ",", "mmax"}], "}"}], "=", 
           RowBox[{"magdistrib", "[", 
            RowBox[{"[", "2", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"maglist", "=", 
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"RandomReal", "[", 
              RowBox[{"{", 
               RowBox[{"mmin", ",", "mmax"}], "}"}], "]"}], ",", 
             RowBox[{"{", "n", "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]",
          ",", "True", ",", 
         RowBox[{"(*", 
          RowBox[{"Default", " ", "\"\<DOUBLETRUNCATEDEXPONENTIAL\>\""}], 
          "*)"}], 
         RowBox[{
          RowBox[{
           RowBox[{"{", 
            RowBox[{"mmin", ",", "mmax", ",", "b"}], "}"}], "=", 
           RowBox[{"magdistrib", "[", 
            RowBox[{"[", "2", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"maglist", "=", 
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"GRInverseCDF", "[", 
              RowBox[{
               RowBox[{"RandomReal", "[", "]"}], ",", "b", ",", "mmin", ",", 
               "mmax"}], "]"}], ",", 
             RowBox[{"{", "n", "}"}]}], "]"}]}], ";"}]}], "]"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"Return", "[", "maglist", "]"}], ";"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]", "\n", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
      "Inverse", " ", "CDF", " ", "of", " ", "the", " ", "doubly", " ", 
       "truncated", " ", "Gutenberg", " ", "Richter", " ", "distribution", " ",
        "obtained", " ", "by", " ", "setting", " ", "beta"}], "=", 
      RowBox[{"b", "*", "ln", " ", "10", " ", "in", " ", 
       RowBox[{"GRAbsoluteNumberOfEventsAboveM", "[", "]"}], " ", "and", " ", 
       
       RowBox[{"GRRelativeNumberOfEventsBelowM", "[", "]"}], " ", 
       "temporarily", " ", "to", " ", "suppress", " ", "evaluation", " ", 
       "and", " ", "solve", " ", 
       RowBox[{"with", ":", 
        RowBox[{
         RowBox[{
          RowBox[{"Solve", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"Evaluate", "[", 
              RowBox[{"cumn", "[", 
               RowBox[{"m", ",", "nm0", ",", "b", ",", "mlow", ",", "mupp"}], 
               "]"}], "]"}], "==", "x"}], ",", "m"}], "]"}], " ", "For", " ", 
          "0"}], "<=", "x", "<=", "1"}]}]}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"GRInverseCDF", "[", 
         RowBox[{"x", ",", "b", ",", "mlow", ",", "mupp"}], "]"}], " ", 
        "returns", " ", "a", " ", "magnitude", " ", "value", " ", "that", " ",
         "is", " ", "distributed", " ", "according", " ", "to", " ", "a", " ",
         "truncated", " ", "Gutenberg", " ", "Richter", " ", "distribution", " ", 
        RowBox[{"Syntax", ":", "m"}]}], "=", 
       RowBox[{"invcum", "[", 
        RowBox[{"x", ",", "b", ",", "mlow", ",", "mupp"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"m", ":", 
       RowBox[{"magnitude", " ", "b"}], ":", 
       RowBox[{"b", "-", 
        RowBox[{"value", " ", 
         RowBox[{"mlow", ":", 
          RowBox[{"lower", " ", "bound", " ", "magnitude", " ", "mupp"}], ":", 
          RowBox[{"upper", " ", "bound", " ", "assymptote", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"N", 
              RowBox[{"(", "mupp", ")"}]}], "=", "0"}], ")"}]}]}]}]}]}]}]}], 
    ")"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"GRInverseCDF", "::", "usage"}], 
   "=", "\"\<GRInverseCDF[m, b, Subscript[m, low], Subscript[m, upp]] returns \
the inverse cumulative distribution function (CDF) of  the doubly  truncated \
Gutenberg-Richter distribution. For 0 <= x <= 1, GRInverseCDF[x, b, \
Subscript[m, low], Subscript[m, upp]] returns a magnitude value that is \
distributed according to a truncated Gutenberg-Richter distribution.\>\""}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"GRInverseCDF", "[", 
    RowBox[{"x_", ",", "b_", ",", "mlow_", ",", "mupp_"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"m", ",", "beta", ",", "z"}], "}"}], ",", 
     RowBox[{
      RowBox[{"beta", "=", 
       RowBox[{"b", "*", 
        RowBox[{"Log", "[", "10", "]"}]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"z", "=", 
       RowBox[{"Exp", "[", 
        RowBox[{
         RowBox[{"-", "beta"}], " ", 
         RowBox[{"(", 
          RowBox[{"mupp", "-", "mlow"}], ")"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"m", "=", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "/", "beta"}], ")"}], "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "beta"}], " ", "mlow"}], "+", 
          RowBox[{"Log", "[", 
           RowBox[{
            RowBox[{"-", 
             RowBox[{"(", 
              RowBox[{"z", "-", "1"}], ")"}]}], "*", 
            RowBox[{"(", 
             RowBox[{"1", "+", 
              RowBox[{"z", "/", 
               RowBox[{"(", 
                RowBox[{"1", "-", "z"}], ")"}]}], "-", "x"}], ")"}]}], 
           "]"}]}], ")"}]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Return", "[", 
       RowBox[{"N", "[", "m", "]"}], "]"}], ";"}]}], "]"}]}], ";"}]}], "Input",\

 CellChangeTimes->{{3.9517131719561863`*^9, 3.951713211075246*^9}, {
   3.951713295195024*^9, 3.951713296815063*^9}, {3.951713360591592*^9, 
   3.951713402893182*^9}, {3.9517134951324987`*^9, 3.951713506707913*^9}, 
   3.951808460128837*^9},
 CellLabel->"In[34]:=",
 $CellContext`InitializationGroup -> 
 True,ExpressionUUID->"c80c917b-994b-4674-83ed-71a59cdba8e2"],

Cell[BoxData["\<\"MagnitudesFromDistribution [n] returns a list  of n  \
synthetic magnitudes. The type of distribution  is determined by the option \
MagnitudeDistribution. \"\>"], "Output",
 CellChangeTimes->{3.951808547113049*^9, 3.9518087703548203`*^9, 
  3.955768791092022*^9},
 CellLabel->"Out[34]=",
 $CellContext`InitializationGroup -> 
 True,ExpressionUUID->"65299a81-5dc3-4f5b-9cd9-6f6fed8dc09d"],

Cell[BoxData["\<\"Option for MagnitudesFromDistribution[]\"\>"], "Output",
 CellChangeTimes->{3.951808547113049*^9, 3.9518087703548203`*^9, 
  3.955768791092602*^9},
 CellLabel->"Out[35]=",
 $CellContext`InitializationGroup -> 
 True,ExpressionUUID->"3fc82984-2a9f-481b-8b5a-bcb9a3b4d2be"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["titleImage", "Subsection",
 CellChangeTimes->{{3.951809089757803*^9, 
  3.9518091043069973`*^9}},ExpressionUUID->"4f398579-f00d-41d8-87c9-\
928e59d850ea"],

Cell[BoxData[
 RowBox[{"Clear", "[", "titleImage", "]"}]], "Input",
 CellChangeTimes->{{3.955768937043172*^9, 3.955768941441985*^9}},
 CellLabel->"In[60]:=",ExpressionUUID->"e68f98d6-8ee7-4001-91f2-dac288a52445"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"pl3dmag1", " ", "=", " ", 
   RowBox[{"Plot3D", "[", 
    RowBox[{
     RowBox[{"flog", "[", 
      RowBox[{"m", ",", "dist", ",", "p"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"m", ",", "5", ",", "7.6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"p", ",", 
       RowBox[{"-", "5."}], ",", 
       RowBox[{"Log", "[", 
        RowBox[{"10", ",", " ", "accCut"}], "]"}]}], "}"}], ",", 
     RowBox[{"AxesLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Style", "[", 
         RowBox[{"\"\<  M \>\"", ",", "20"}], "]"}], ",", 
        RowBox[{"Style", "[", 
         RowBox[{"\"\<  (m/\!\(\*SuperscriptBox[\(s\), \(2\)]\))  \>\"", ",", 
          "20"}], "]"}], ",", 
        RowBox[{"Style", "[", 
         RowBox[{"\"\<   PDF  \>\"", ",", "fs"}], "]"}]}], "}"}]}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"Opacity", "[", "1.", "]"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{"ColorFunction", "\[Rule]", "colorfc"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"PlotTheme", "\[Rule]", "theme"}], ",", "\[IndentingNewLine]", 
     RowBox[{"ViewPoint", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"1.33", ",", 
        RowBox[{"-", "0.1"}], ",", "2.75"}], "}"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Ticks", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"All", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "4"}], 
            ",", "\"\<\!\(\*SuperscriptBox[\(10\), \(-4\)]\)\>\""}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "3"}], 
            ",", "\"\<\!\(\*SuperscriptBox[\(10\), \(-3\)]\)\>\""}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "2"}], ",", "\"\<0.01\>\""}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "1"}], ",", "\"\<0.1\>\""}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "\"\<1\>\""}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "\"\<10\>\""}], "}"}]}], "}"}], ",", " ", 
        "Automatic"}], "}"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{"Axes", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"True", ",", "True", ",", "True"}], "}"}]}], ",", 
     RowBox[{"Boxed", "\[Rule]", " ", "False"}], ",", 
     RowBox[{"TicksStyle", "\[Rule]", 
      RowBox[{"Directive", "[", 
       RowBox[{"FontSize", "\[Rule]", "tifs"}], "]"}]}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "is"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"pl3dmag2", " ", "=", " ", 
   RowBox[{"Plot3D", "[", 
    RowBox[{
     RowBox[{"flog", "[", 
      RowBox[{"m", ",", "dist", ",", "p"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"m", ",", "5", ",", "7.6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"p", ",", "1.2", ",", 
       RowBox[{"Log", "[", 
        RowBox[{"10", ",", "100."}], "]"}]}], "}"}], ",", 
     RowBox[{"AxesLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Style", "[", 
         RowBox[{"\"\<  M \>\"", ",", "20"}], "]"}], ",", 
        RowBox[{"Style", "[", 
         RowBox[{"\"\<  (m/\!\(\*SuperscriptBox[\(s\), \(2\)]\))  \>\"", ",", 
          "20"}], "]"}], ",", 
        RowBox[{"Style", "[", 
         RowBox[{"\"\<   PDF  \>\"", ",", "fs"}], "]"}]}], "}"}]}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"Opacity", "[", "1.", "]"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{"ColorFunction", "\[Rule]", "colorfc"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"PlotTheme", "\[Rule]", "theme"}], ",", "\[IndentingNewLine]", 
     RowBox[{"ViewPoint", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"1.33", ",", 
        RowBox[{"-", "0.1"}], ",", "2.75"}], "}"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"PlotRange", "\[Rule]", " ", "All"}], ",", 
     RowBox[{"Mesh", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"14", ",", "2"}], "}"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{"Ticks", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"All", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "2"}], ",", "\"\<0.01\>\""}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "1"}], ",", "\"\<0.1\>\""}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "\"\<1\>\""}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "\"\<10\>\""}], "}"}]}], "}"}], ",", " ", 
        "Automatic"}], "}"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{"Axes", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"True", ",", "True", ",", "True"}], "}"}]}], ",", 
     RowBox[{"Boxed", "\[Rule]", " ", "False"}], ",", 
     RowBox[{"TicksStyle", "\[Rule]", 
      RowBox[{"Directive", "[", 
       RowBox[{"FontSize", "\[Rule]", "tifs"}], "]"}]}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "is"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"pl3dmagStripe", " ", "=", " ", 
   RowBox[{"Plot3D", "[", 
    RowBox[{
     RowBox[{"flog", "[", 
      RowBox[{"m", ",", "dist", ",", "p"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"m", ",", "5", ",", "7.6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"p", ",", 
       RowBox[{"Log", "[", 
        RowBox[{"10", ",", "accCut"}], "]"}], ",", 
       RowBox[{"Log", "[", 
        RowBox[{"10", ",", "100"}], "]"}]}], "}"}], ",", 
     RowBox[{"AxesLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Style", "[", 
         RowBox[{"\"\<  M \>\"", ",", "20"}], "]"}], ",", 
        RowBox[{"Style", "[", 
         RowBox[{"\"\<  (m/\!\(\*SuperscriptBox[\(s\), \(2\)]\))  \>\"", ",", 
          "20"}], "]"}], ",", 
        RowBox[{"Style", "[", 
         RowBox[{"\"\<   PDF  \>\"", ",", "fs"}], "]"}]}], "}"}]}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Opacity", "[", "1.", "]"}], "}"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"ColorFunction", "\[Rule]", "colorfc"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"PlotTheme", "\[Rule]", "theme"}], ",", "\[IndentingNewLine]", 
     RowBox[{"ViewPoint", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"1.33", ",", 
        RowBox[{"-", "0.1"}], ",", "2.75"}], "}"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Mesh", "\[Rule]", " ", "None"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", " ", "All"}], ",", "\[IndentingNewLine]", 
     RowBox[{"Ticks", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"All", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "2"}], ",", "\"\<0.01\>\""}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "1"}], ",", "\"\<0.1\>\""}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "\"\<1\>\""}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "\"\<10\>\""}], "}"}]}], "}"}], ",", " ", 
        "Automatic"}], "}"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{"Axes", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"True", ",", "True", ",", "True"}], "}"}]}], ",", 
     RowBox[{"Boxed", "\[Rule]", " ", "False"}], ",", 
     RowBox[{"TicksStyle", "\[Rule]", 
      RowBox[{"Directive", "[", 
       RowBox[{"FontSize", "\[Rule]", "tifs"}], "]"}]}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "is"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"SeedRandom", "[", "1234", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"magdata", "=", 
   StyleBox[
    RowBox[{"MagnitudesFromDistribution", "[", 
     RowBox[{"1000", ",", 
      RowBox[{"MagnitudeDistribution", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"\"\<DOUBLETRUNCATEDEXPONENTIAL\>\"", ",", 
         RowBox[{"{", 
          RowBox[{"5.1", ",", "7.5", ",", "1."}], "}"}]}], "}"}]}]}], "]"}],
    FontFamily->"Courier New"]}], 
  StyleBox[";",
   FontFamily->"Courier New"]}], "\n", 
 RowBox[{
  RowBox[{"SeedRandom", "[", "1266", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"problist", " ", "=", " ", 
   RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"For", "[", 
   RowBox[{
    RowBox[{"i", "=", "1"}], ",", 
    RowBox[{"i", "\[LessEqual]", 
     RowBox[{"Length", "[", "magdata", "]"}]}], ",", 
    RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{"mu", ",", "sig"}], "}"}], " ", "=", "  ", 
      RowBox[{"pgaPredicted", "[", 
       RowBox[{
        RowBox[{"magdata", "[", 
         RowBox[{"[", "i", "]"}], "]"}], ",", " ", "dist"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"tmp", " ", "=", " ", 
      RowBox[{"RandomReal", "[", 
       RowBox[{"NormalDistribution", "[", 
        RowBox[{
         RowBox[{"Log", "[", "mu", "]"}], ",", "sig"}], "]"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"lh", "=", " ", 
      RowBox[{"PDF", "[", 
       RowBox[{
        RowBox[{"NormalDistribution", "[", 
         RowBox[{
          RowBox[{"Log", "[", "mu", "]"}], ",", "sig"}], "]"}], ",", "tmp"}], 
       "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"AppendTo", "[", 
      RowBox[{"problist", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"magdata", "[", 
          RowBox[{"[", "i", "]"}], "]"}], ",", "tmp", ",", "lh"}], "}"}]}], 
      "]"}], ";"}]}], "\[IndentingNewLine]", "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"pl3ddistdata", " ", "=", " ", 
   RowBox[{"ListPointPlot3D", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"problist", "[", 
       RowBox[{"[", "All", "]"}], "]"}], "}"}], ",", 
     RowBox[{"Filling", "\[Rule]", "Bottom"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
     RowBox[{"ViewPoint", "\[Rule]", " ", 
      RowBox[{"{", 
       RowBox[{"1.33", ",", 
        RowBox[{"-", "0.1"}], ",", "2.75"}], "}"}]}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"Red", ",", 
         RowBox[{"AbsolutePointSize", "[", ".0001", "]"}]}], "}"}], "}"}]}]}],
     "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", "x_", "]"}], ":=", " ", 
   RowBox[{
    StyleBox["{", "Code"], 
    RowBox[{
     RowBox[{"EdgeForm", "[", 
      RowBox[{"Directive", "[", 
       RowBox[{
        RowBox[{"AbsoluteThickness", "[", ".001", "]"}], ",", "Black"}], 
       "]"}], "]"}], ",", "Red", ",", " ", 
     RowBox[{"Cylinder", "[", 
      RowBox[{
       RowBox[{
        StyleBox["{", "Code"], 
        RowBox[{"x", ",", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0", ",", ".01"}], "}"}], "+", "x"}]}], "}"}], ",",
        ".03"}], "]"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"pl3ddistdata", " ", "=", " ", 
   RowBox[{"Graphics3D", "[", 
    RowBox[{
     RowBox[{"f", " ", "/@", " ", 
      RowBox[{"problist", "[", 
       RowBox[{"[", "All", "]"}], "]"}]}], ",", 
     RowBox[{"ViewPoint", "\[Rule]", " ", 
      RowBox[{"{", 
       RowBox[{"1.33", ",", 
        RowBox[{"-", "0.1"}], ",", "2.75"}], "}"}]}]}], "]"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"ml1", "=", "5"}], ";", " ", 
  RowBox[{"mu1", "=", "7.5"}], ";", 
  RowBox[{"dm1", "=", "0.1"}], ";", 
  RowBox[{"bval1", "=", "1."}], ";", 
  RowBox[{"sig1", "=", "0.5"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"mags1", ",", "prm1", ",", "pre1", ",", "prme1", ",", "ha1"}], 
    "}"}], " ", "=", " ", 
   RowBox[{"deagg", "[", 
    RowBox[{"ml1", ",", "mu1", ",", "bval1", ",", "sig1", ",", "1."}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"magrec1", " ", "=", " ", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Rectangle", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"Range", "[", 
           RowBox[{"ml1", ",", "mu1", ",", "dm1"}], "]"}], "[", 
          RowBox[{"[", "i", "]"}], "]"}], ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"Range", "[", 
           RowBox[{"ml1", ",", "mu1", ",", "dm1"}], "]"}], "[", 
          RowBox[{"[", 
           RowBox[{"i", "+", "1"}], "]"}], "]"}], ",", 
         RowBox[{"prm1", "[", 
          RowBox[{"[", "i", "]"}], "]"}]}], "}"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", 
       RowBox[{"Length", "[", "prm1", "]"}]}], "}"}]}], "]"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"plGR", "=", 
   RowBox[{"Graphics3D", "[", 
    RowBox[{"make3Dhistplot", "[", 
     RowBox[{"350.", ",", 
      RowBox[{"-", "5."}], ",", 
      RowBox[{".01", " ", "prm1"}], ",", 
      RowBox[{"Range", "[", 
       RowBox[{"ml1", ",", "mu1", ",", "dm1"}], "]"}]}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"plfs", "=", "20"}], ";"}], "\n", 
 RowBox[{"Show", "[", 
  RowBox[{
  "pl3dmag1", ",", "pl3dmagStripe", ",", "pl3ddistdata", ",", "plGR", ",", 
   RowBox[{"Graphics3D", "[", 
    RowBox[{"Text", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Style", "[", 
        RowBox[{"\"\<  Many \>\"", ",", "Black", ",", "Bold", ",", "Italic", ",",
          "plfs"}], "]"}], 
       RowBox[{"Style", "[", 
        RowBox[{"\"\<small earthquakes: \\nlikely to sample tail of PDF \>\"",
          ",", "Black", ",", "Italic", ",", "plfs"}], "]"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"5", ",", 
        RowBox[{"-", "1.7"}], ",", ".8"}], "}"}], ",", 
      RowBox[{"Background", "\[Rule]", "LightGray"}]}], "]"}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Graphics3D", "[", 
    RowBox[{"Text", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Style", "[", 
        RowBox[{"\"\<     Few \>\"", ",", "Black", ",", "Bold", ",", "Italic",
          ",", "plfs"}], "]"}], 
       RowBox[{"Style", "[", 
        RowBox[{"\"\<large earthquakes: \\nlikely to sample center of PDF \
\>\"", ",", "Black", ",", "Italic", ",", "plfs"}], "]"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"7.7", ",", 
        RowBox[{"-", "2.3"}], ",", ".5"}], "}"}], ",", 
      RowBox[{"Background", "\[Rule]", "LightGray"}]}], "]"}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"PlotRange", "\[Rule]", " ", "All"}], ",", 
   RowBox[{"ViewPoint", "\[Rule]", " ", 
    RowBox[{"{", 
     RowBox[{"1.33", ",", ".5", ",", "2."}], "}"}]}], ",", 
   RowBox[{"Axes", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"True", ",", "True", ",", "False"}], "}"}]}], ",", 
   RowBox[{"Boxed", "\[Rule]", " ", "False"}], ",", 
   RowBox[{"AxesEdge", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", 
        RowBox[{"-", "1"}]}], "}"}], ",", "Automatic"}], "}"}]}], ",", 
   RowBox[{"ImageSize", "\[Rule]", "750"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.444468449984375*^9, 3.4444684715625*^9}, {
   3.4444688455*^9, 3.44446884578125*^9}, {3.4446557133168383`*^9, 
   3.4446557211251993`*^9}, {3.444655817196527*^9, 3.4446558175624123`*^9}, {
   3.444656992368403*^9, 3.444657046927991*^9}, {3.58121913175458*^9, 
   3.581219137074251*^9}, {3.581221034830701*^9, 3.581221037101153*^9}, 
   3.581221152478397*^9, {3.581221539755909*^9, 3.581221574405258*^9}, {
   3.581221666589314*^9, 3.581221672708246*^9}, {3.58122183718064*^9, 
   3.58122183745503*^9}, {3.581222355140291*^9, 3.58122235557489*^9}, {
   3.581222589803516*^9, 3.581222594358007*^9}, {3.581222648899173*^9, 
   3.5812226606896563`*^9}, {3.581222690941532*^9, 3.581222696339675*^9}, {
   3.581642412721005*^9, 3.581642440691822*^9}, {3.581924195145583*^9, 
   3.581924199803396*^9}, {3.582273543243823*^9, 3.5822735726089153`*^9}, {
   3.582273831516593*^9, 3.582273872041696*^9}, {3.5822739582982388`*^9, 
   3.582274000512347*^9}, {3.582274087072227*^9, 3.58227412977563*^9}, {
   3.5822742065637302`*^9, 3.58227424552957*^9}, {3.5822742807396812`*^9, 
   3.582274286648278*^9}, {3.582274316875572*^9, 3.582274354169106*^9}, {
   3.582275920406168*^9, 3.5822759539401617`*^9}, {3.5822760770199337`*^9, 
   3.582276082186221*^9}, {3.582346286479251*^9, 3.582346336878213*^9}, {
   3.582346533283373*^9, 3.582346538310746*^9}, {3.58234659142481*^9, 
   3.5823465963950663`*^9}, {3.5823466347101307`*^9, 3.582346791243641*^9}, 
   3.582436669237298*^9, {3.582436722074024*^9, 3.5824367227614307`*^9}, {
   3.5824367704814167`*^9, 3.582436814357757*^9}, {3.5824368974159527`*^9, 
   3.582436944435255*^9}, {3.582436986295556*^9, 3.582436986581717*^9}, 
   3.582437021488227*^9, {3.582964343789329*^9, 3.582964347764642*^9}, 
   3.582964387213871*^9, {3.582964489655973*^9, 3.582964505270217*^9}, {
   3.582964592066121*^9, 3.582964666008772*^9}, {3.943701660599636*^9, 
   3.943701689517393*^9}, 3.9465633487732573`*^9, {3.946899247747601*^9, 
   3.9468992764259243`*^9}, 3.946899987819008*^9, 3.946900512582148*^9, 
   3.955768924025546*^9},
 CellLabel->"In[61]:=",ExpressionUUID->"37ae42ba-9eb3-4306-8ba2-06488bc4ebf7"],

Cell["\<\

The following figure explains the reason why both, small and large \
earthquakes contribute to the seismic hazard. This is why it was chosen as  \
cover figure (without the verbal explanation, however).\
\>", "Text",
 CellChangeTimes->{{3.955769019680769*^9, 
  3.9557691924106417`*^9}},ExpressionUUID->"7c5e31c5-d358-4091-8179-\
22351cd11f57"],

Cell[BoxData[
 Graphics3DBox[{{GraphicsComplex3DBox[CompressedData["
1:eJx1vXk0Vd//+E/GJIRUSAOaJEpFyj2SMjSSSEWkTCWhQiOJSkTIUMlYGTIl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     "], {{
       {GrayLevel[1], Opacity[1.], EdgeForm[None], 
        StyleBox[GraphicsGroup3DBox[
          TagBox[{Polygon3DBox[CompressedData["
1:eJwtmgncVkMbxp/znDkTRZZkK5FUlqyhyNIqpA0pW0Jlr6hQQomolJJI9qWU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             "]], Polygon3DBox[CompressedData["
1:eJwtmwf8T9Ufxu+9554rlbISWtKgNCRp7x1SpKWsBkVJO1pWO030V6JBKGlQ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             "]], Polygon3DBox[CompressedData["
1:eJwt13m8VtMex/Fznuc8J9KgeZ5HmiiESqm4VOQmQ6jcJhleRYlcXA0oRIgK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             "]], 
            Polygon3DBox[{{1258, 729, 866, 1556, 1094, 1095}, {1095, 1094, 
             1571, 974, 975, 1572}}]},
           Annotation[#, "Charting`Private`Tag$49456#1"]& ]],
         Lighting->"Neutral"]}, {}, {}, {}, {}}, {
       {GrayLevel[0], Line3DBox[CompressedData["
1:eJwt0jssnlEYAOCD36WuXRqDxO932wiRbro03aqGjkUH22/QuN/FxiK2dhFb
u3RspZGmTRoVEbGg7pTZLkRcnhOG93vek+875z3vmy/V+eFtd0YIYVpUSWKe
9LjgeVYIT3nFJPMSIdSzlC9YyxY+Zxsbs33LV9ZdLHPOe/mIvIszHOAnTvEL
57jIBf5lkzOuWWPvFlPxQqInM4RtaS//sY877OduPJd7HOQ+hzgsDuQjPOQo
jzjGY47zhBP8z0me8o1+b2J/6p6xMs5FLLnjpvVXLnOe3znLz3E/P8a7JR7m
meYwO9gu0vKXfBf75GtWs5nPWMcclrPBHC7je3VLWME7brCY6yziGgu5ygKu
MJ/LfMI/zONv/hK58p/M4RKVCT+obFik1sM3GkVotbh9/C/uAfOIQO4=
         "],
         VertexColors->None]}, 
       {GrayLevel[0], 
        Line3DBox[{1003, 1326, 639, 1002, 1575, 1210, 1004, 1576, 1211, 1005, 
         1577, 1212, 1006, 1578, 1213, 1007, 1579, 1214, 1008, 1580, 1476, 
         1677, 1009, 1581, 1215, 1010, 1582, 1216, 1011, 1583, 1217, 1012, 
         1584, 1218, 1013, 1585, 1219, 1014, 1586, 1220, 1015, 1758, 1327, 
         1221, 1328},
         VertexColors->None], 
        Line3DBox[{1017, 1477, 1678, 1016, 654, 1018, 1587, 1222, 1019, 1588, 
         1223, 1020, 1589, 1224, 1021, 1590, 1225, 1022, 1591, 1478, 1679, 
         1023, 1479, 1680, 1024, 1592, 1226, 1025, 1593, 1227, 1026, 1594, 
         1228, 1027, 1595, 1229, 1028, 1596, 1230, 1029, 1597, 1231, 1030},
         VertexColors->None], 
        Line3DBox[{1032, 1480, 1681, 1031, 1481, 1682, 1033, 1598, 1232, 1034,
          1599, 1233, 1035, 1600, 1234, 1036, 1601, 1235, 1037, 1602, 1482, 
         1683, 1038, 1483, 1684, 1039, 1484, 1685, 1040, 1603, 1236, 1041, 
         1604, 1237, 1042, 1605, 1238, 1043, 1606, 1239, 1044, 1607, 1240, 
         1045},
         VertexColors->None], 
        Line3DBox[{1047, 1485, 1686, 1046, 1486, 1687, 1048, 1487, 1688, 1049,
          1608, 1241, 1050, 1609, 1242, 1051, 1610, 1243, 1052, 1611, 1488, 
         1689, 1053, 1489, 1690, 1054, 1490, 1691, 1055, 1491, 1692, 1056, 
         1612, 1244, 1057, 1613, 1245, 1058, 1614, 1246, 1059, 1615, 1247, 
         1060},
         VertexColors->None], 
        Line3DBox[{1062, 1492, 1693, 1061, 1493, 1694, 1063, 1494, 1695, 1064,
          1495, 1696, 1065, 1616, 1248, 1066, 1617, 1249, 1067, 1618, 1496, 
         1697, 1068, 1497, 1698, 1069, 1498, 1699, 1070, 1499, 1700, 1071, 
         1500, 1701, 1072, 1619, 1250, 1073, 1620, 1251, 1074, 1621, 1252, 
         1075},
         VertexColors->None], 
        Line3DBox[{1077, 1394, 1395, 1778, 1076, 1399, 1702, 1561, 1078, 1449,
          1703, 1570, 1079, 1501, 1704, 1080, 1502, 1705, 1081, 1622, 1253, 
         1082, 1623, 1503, 1706, 1083, 1504, 1707, 1084, 1505, 1708, 1085, 
         1506, 1709, 1086, 1507, 1710, 1087, 1508, 1711, 1088, 1624, 1254, 
         1089, 1625, 1255, 1090},
         VertexColors->None], 
        Line3DBox[{1092, 1306, 1334, 1351, 1759, 1256, 1333, 1307, 1335, 1557,
          1760, 1257, 1353, 1352, 1403, 1779, 1258, 1095, 1572, 1626, 1454, 
         1259, 1097, 1627, 1260, 1099, 1628, 1261, 1101, 1630, 1631, 1262, 
         1103, 1632, 1263, 1105, 1633, 1264, 1107, 1634, 1265, 1109, 1635, 
         1266, 1111, 1636, 1267, 1113, 1637, 1268, 1115, 1639, 1270, 1117},
         VertexColors->None], 
        Line3DBox[{1116, 1269, 1638, 1114, 1723, 1517, 1112, 1722, 1516, 1110,
          1721, 1515, 1108, 1720, 1514, 1106, 1719, 1513, 1104, 1718, 1512, 
         1102, 1717, 1511, 1629, 1100, 1716, 1510, 1098, 1715, 1509, 1096, 
         1453, 1714, 1571, 1094, 1556, 1713, 1450, 1452, 1451, 1093, 1429, 
         1785, 1566, 1400, 1402, 1401, 1091, 1550, 1712, 1396, 1398, 1397, 
         1329},
         VertexColors->None], 
        Line3DBox[{1118, 1308, 1355, 1430, 1518, 1786, 1336, 1309, 1357, 1567,
          1768, 1271, 1337, 1310, 1338, 1769, 1359, 1272, 1358, 1558, 1640, 
         1405, 1273, 1119, 1562, 1641, 1406, 1274, 1120, 1573, 1642, 1455, 
         1275, 1121, 1643, 1519, 1724, 1122, 1644, 1276, 1123, 1645, 1277, 
         1124, 1646, 1278, 1125, 1647, 1279, 1126, 1648, 1280, 1127, 1649, 
         1281, 1128, 1650, 1282, 1129},
         VertexColors->None], 
        Line3DBox[{1130, 1354, 1520, 1766, 1444, 1356, 1521, 1767, 1404, 1311,
          1361, 1787, 1431, 1432, 1339, 1551, 1651, 1341, 1362, 1363, 1340, 
         1552, 1652, 1342, 1366, 1367, 1365, 1770, 1364, 1408, 1283, 1131, 
         1793, 1456, 1457, 1522, 1792, 1132, 1523, 1725, 1133, 1653, 1284, 
         1134, 1654, 1285, 1135, 1655, 1286, 1136, 1656, 1287, 1137, 1657, 
         1288, 1138, 1658, 1289, 1139},
         VertexColors->None], 
        Line3DBox[{1141, 1524, 1726, 1140, 1525, 1727, 1142, 1360, 1659, 1290,
          1407, 1553, 1660, 1369, 1433, 1434, 1343, 1761, 1312, 1373, 1435, 
         1436, 1344, 1762, 1313, 1345, 1377, 1378, 1376, 1774, 1375, 1409, 
         1526, 1773, 1143, 1411, 1412, 1527, 1780, 1144, 1458, 1459, 1528, 
         1794, 1145, 1661, 1291, 1146, 1662, 1292, 1147, 1663, 1293, 1148, 
         1664, 1294, 1149, 1665, 1295, 1150},
         VertexColors->None], 
        Line3DBox[{1152, 1529, 1728, 1151, 1530, 1729, 1153, 1531, 1730, 1154,
          1559, 1771, 1370, 1368, 1445, 1155, 1772, 1371, 1374, 1372, 1437, 
         1156, 1563, 1756, 1314, 1346, 1315, 1157, 1564, 1757, 1316, 1410, 
         1317, 1763, 1158, 1414, 1318, 1413, 1319, 1788, 1568, 1159, 1461, 
         1382, 1460, 1383, 1776, 1160, 1462, 1463, 1795, 1161, 1666, 1296, 
         1162, 1667, 1297, 1163, 1668, 1298, 1164, 1669, 1299, 1165},
         VertexColors->None], 
        Line3DBox[{1167, 1532, 1731, 1166, 1533, 1732, 1168, 1534, 1733, 1169,
          1535, 1734, 1170, 1670, 1300, 1171, 1775, 1379, 1381, 1380, 1438, 
         1172, 1781, 1415, 1320, 1347, 1321, 1764, 1173, 1350, 1322, 1348, 
         1323, 1765, 1174, 1417, 1324, 1416, 1325, 1789, 1441, 1175, 1465, 
         1388, 1464, 1735, 1560, 1176, 1574, 1736, 1466, 1177, 1671, 1301, 
         1178, 1672, 1302, 1179, 1673, 1303, 1180},
         VertexColors->None], 
        Line3DBox[{1182, 1536, 1737, 1181, 1537, 1738, 1183, 1538, 1739, 1184,
          1539, 1740, 1185, 1540, 1741, 1186, 1674, 1304, 1187, 1777, 1384, 
         1385, 1447, 1446, 1790, 1188, 1386, 1387, 1440, 1439, 1782, 1189, 
         1418, 1419, 1349, 1742, 1554, 1190, 1421, 1422, 1420, 1743, 1443, 
         1442, 1191, 1468, 1469, 1796, 1467, 1391, 1192, 1541, 1744, 1193, 
         1675, 1305, 1194, 1783, 1423, 1424, 1195},
         VertexColors->None], 
        Line3DBox[{1209, 1332, 1425, 1428, 1427, 1784, 1208, 1426, 1755, 1565,
          1207, 1754, 1549, 1206, 1470, 1473, 1797, 1475, 1474, 1205, 1471, 
         1472, 1753, 1393, 1392, 1204, 1448, 1791, 1569, 1390, 1389, 1203, 
         1752, 1548, 1202, 1751, 1547, 1676, 1201, 1750, 1546, 1200, 1749, 
         1545, 1199, 1748, 1544, 1198, 1747, 1543, 1197, 1746, 1542, 1196, 
         1555, 1745, 1330, 1331},
         VertexColors->None]}, 
       {GrayLevel[0], 
        Line3DBox[{435, 640, 1575, 436, 654, 464, 1682, 669, 479, 1687, 684, 
         494, 1694, 699, 509, 1702, 910, 714, 524, 1785, 943, 817, 867, 868, 
         869, 1760, 539, 819, 849, 945, 946, 1768, 553, 947, 870, 911, 1767, 
         752, 565, 1727, 762, 576, 1729, 773, 587, 1732, 784, 600, 1738, 795, 
         613, 1746, 805, 626},
         VertexColors->None], 
        Line3DBox[{437, 641, 1576, 438, 655, 1587, 465, 670, 1598, 480, 1688, 
         685, 495, 1695, 700, 510, 1703, 973, 715, 525, 1713, 866, 729, 1779, 
         540, 948, 820, 873, 875, 1769, 876, 554, 821, 850, 949, 1787, 950, 
         566, 951, 877, 918, 763, 1659, 577, 1730, 774, 588, 1733, 785, 601, 
         1739, 796, 614, 1747, 806, 627},
         VertexColors->None], 
        Line3DBox[{439, 642, 1577, 440, 656, 1588, 466, 671, 1599, 481, 686, 
         1608, 496, 1696, 701, 511, 1704, 716, 526, 1714, 974, 975, 1626, 976,
          977, 871, 874, 872, 1640, 912, 913, 822, 851, 823, 1651, 853, 920, 
         826, 919, 827, 1660, 882, 1771, 880, 881, 589, 1734, 786, 602, 1740, 
         797, 615, 1748, 807, 628},
         VertexColors->None], 
        Line3DBox[{441, 643, 1578, 442, 657, 1589, 467, 672, 1600, 482, 687, 
         1609, 497, 702, 1616, 512, 1705, 717, 527, 1715, 730, 1627, 541, 914,
          915, 1641, 916, 917, 824, 852, 825, 1652, 854, 864, 828, 855, 1761, 
         829, 885, 883, 1772, 967, 884, 590, 787, 1670, 603, 1741, 798, 616, 
         1749, 808, 629},
         VertexColors->None], 
        Line3DBox[{443, 644, 1579, 444, 658, 1590, 468, 673, 1601, 483, 688, 
         1610, 498, 703, 1617, 513, 718, 1622, 528, 1716, 731, 1628, 542, 978,
          979, 1642, 980, 981, 982, 879, 1770, 878, 921, 922, 923, 856, 1762, 
         830, 857, 925, 926, 1756, 924, 831, 891, 889, 1775, 890, 604, 799, 
         1674, 617, 1750, 809, 630},
         VertexColors->None], 
        Line3DBox[{445, 645, 1580, 447, 659, 1591, 469, 674, 1602, 484, 689, 
         1611, 499, 704, 1618, 514, 719, 1623, 529, 732, 1629, 1630, 543, 742,
          1643, 555, 983, 1793, 985, 986, 987, 988, 888, 1774, 887, 927, 928, 
         929, 1757, 858, 833, 860, 932, 1781, 933, 931, 835, 898, 896, 1777, 
         897, 618, 810, 1676, 631},
         VertexColors->None], 
        Line3DBox[{449, 647, 1581, 450, 1680, 661, 471, 1684, 676, 486, 1690, 
         691, 501, 1698, 706, 516, 1707, 721, 531, 1718, 734, 1632, 545, 744, 
         1644, 557, 1725, 754, 568, 930, 1780, 765, 579, 952, 953, 1788, 894, 
         895, 776, 592, 836, 1765, 862, 955, 789, 606, 956, 1782, 957, 934, 
         801, 620, 1752, 812, 633},
         VertexColors->None], 
        Line3DBox[{451, 648, 1582, 452, 662, 1592, 472, 1685, 677, 487, 1691, 
         692, 502, 1699, 707, 517, 1708, 722, 532, 1719, 735, 1633, 546, 745, 
         1645, 558, 755, 1653, 569, 989, 1794, 766, 580, 893, 1776, 777, 593, 
         958, 837, 1789, 900, 901, 902, 607, 1742, 838, 863, 959, 960, 621, 
         1791, 972, 903, 971, 813, 634},
         VertexColors->None], 
        Line3DBox[{453, 649, 1583, 454, 663, 1593, 473, 678, 1603, 488, 1692, 
         693, 503, 1700, 708, 518, 1709, 723, 533, 1720, 736, 1634, 547, 746, 
         1646, 559, 756, 1654, 570, 767, 1661, 581, 990, 1795, 778, 594, 1735,
          899, 790, 608, 961, 1743, 839, 907, 962, 963, 622, 999, 1753, 906, 
         997, 814, 635},
         VertexColors->None], 
        Line3DBox[{455, 650, 1584, 456, 664, 1594, 474, 679, 1604, 489, 694, 
         1612, 504, 1701, 709, 519, 1710, 724, 534, 1721, 737, 1635, 548, 747,
          1647, 560, 757, 1655, 571, 768, 1662, 582, 779, 1666, 595, 1736, 
         991, 992, 993, 994, 1796, 904, 908, 905, 1000, 1001, 1797, 995, 998, 
         996, 636},
         VertexColors->None], 
        Line3DBox[{457, 651, 1585, 458, 665, 1595, 475, 680, 1605, 490, 695, 
         1613, 505, 710, 1619, 520, 1711, 725, 535, 1722, 738, 1636, 549, 748,
          1648, 561, 758, 1656, 572, 769, 1663, 583, 780, 1667, 596, 791, 
         1671, 609, 1744, 802, 623, 1754, 815, 637},
         VertexColors->None], 
        Line3DBox[{459, 652, 1586, 460, 666, 1596, 476, 681, 1606, 491, 696, 
         1614, 506, 711, 1620, 521, 726, 1624, 536, 1723, 739, 1637, 550, 749,
          1649, 562, 759, 1657, 573, 770, 1664, 584, 781, 1668, 597, 792, 
         1672, 610, 803, 1675, 624, 1755, 938, 939, 638},
         VertexColors->None], 
        Line3DBox[{461, 841, 1758, 842, 462, 667, 1597, 477, 682, 1607, 492, 
         697, 1615, 507, 712, 1621, 522, 727, 1625, 537, 740, 1638, 1639, 551,
          750, 1650, 563, 760, 1658, 574, 771, 1665, 585, 782, 1669, 598, 793,
          1673, 611, 935, 1783, 936, 937, 941, 1784, 942, 940, 844, 845},
         VertexColors->None], 
        Line3DBox[{625, 804, 843, 1745, 612, 794, 1737, 599, 783, 1731, 586, 
         772, 1728, 575, 761, 1726, 564, 751, 1766, 964, 966, 965, 552, 741, 
         1786, 944, 848, 818, 538, 1759, 728, 865, 847, 816, 1712, 523, 713, 
         1778, 909, 508, 698, 1693, 493, 683, 1686, 478, 668, 1681, 463, 653, 
         1678, 434, 639, 840, 846},
         VertexColors->None], 
        Line3DBox[{632, 811, 1751, 619, 800, 968, 970, 1790, 969, 605, 788, 
         954, 861, 1764, 834, 591, 775, 892, 859, 1763, 832, 578, 764, 1773, 
         886, 567, 753, 1792, 984, 556, 743, 1724, 544, 1631, 733, 1717, 530, 
         720, 1706, 515, 705, 1697, 500, 690, 1689, 485, 675, 1683, 470, 660, 
         1679, 448, 646, 1677, 446},
         VertexColors->None]}, {}, {}}},
     VertexColors->{
       ColorDataFunction[
       "Atoms", 
        "Named", {{
         "H", "He", "Li", "Be", "B", "C", "N", "O", "F", "Ne", "Na", "Mg", 
          "Al", "Si", "P", "S", "Cl", "Ar", "K", "Ca", "Sc", "Ti", "V", "Cr", 
          "Mn", "Fe", "Co", "Ni", "Cu", "Zn", "Ga", "Ge", "As", "Se", "Br", 
          "Kr", "Rb", "Sr", "Y", "Zr", "Nb", "Mo", "Tc", "Ru", "Rh", "Pd", 
          "Ag", "Cd", "In", "Sn", "Sb", "Te", "I", "Xe", "Cs", "Ba", "La", 
          "Ce", "Pr", "Nd", "Pm", "Sm", "Eu", "Gd", "Tb", "Dy", "Ho", "Er", 
          "Tm", "Yb", "Lu", "Hf", "Ta", "W", "Re", "Os", "Ir", "Pt", "Au", 
          "Hg", "Tl", "Pb", "Bi", "Po", "At", "Rn", "Fr", "Ra", "Ac", "Th", 
          "Pa", "U", "Np", "Pu", "Am", "Cm", "Bk", "Cf", "Es", "Fm", "Md", 
          "No", "Lr", "Rf", "Db", "Sg", "Bh", "Hs", "Mt", "Ds", "Rg", "Cn", 
          "Nh", "Fl", "Mc", "Lv", "Ts", "Og", "Uub", "Uut", "Uuq", "Uup", 
          "Uuh", "Uus", "Uuo"}, {
         "h", "he", "li", "be", "b", "c", "n", "o", "f", "ne", "na", "mg", 
          "al", "si", "p", "s", "cl", "ar", "k", "ca", "sc", "ti", "v", "cr", 
          "mn", "fe", "co", "ni", "cu", "zn", "ga", "ge", "as", "se", "br", 
          "kr", "rb", "sr", "y", "zr", "nb", "mo", "tc", "ru", "rh", "pd", 
          "ag", "cd", "in", "sn", "sb", "te", "i", "xe", "cs", "ba", "la", 
          "ce", "pr", "nd", "pm", "sm", "eu", "gd", "tb", "dy", "ho", "er", 
          "tm", "yb", "lu", "hf", "ta", "w", "re", "os", "ir", "pt", "au", 
          "hg", "tl", "pb", "bi", "po", "at", "rn", "fr", "ra", "ac", "th", 
          "pa", "u", "np", "pu", "am", "cm", "bk", "cf", "es", "fm", "md", 
          "no", "lr", "rf", "db", "sg", "bh", "hs", "mt", "ds", "rg", "cn", 
          "nh", "fl", "mc", "lv", "ts", "og", "uub", "uut", "uuq", "uup", 
          "uuh", "uus", "uuo"}}, Replace[#, 
         Dispatch[{
          "h" -> RGBColor[0.65, 0.7, 0.7], "he" -> RGBColor[0.836713, 1., 1.],
            "li" -> RGBColor[0.799435, 0.543572, 0.997559], "be" -> 
           RGBColor[0.770565, 0.964309, 0.0442359], "b" -> 
           RGBColor[1., 0.709804, 0.709804], "c" -> RGBColor[0.4, 0.4, 0.4], 
           "n" -> RGBColor[0.291989, 0.437977, 0.888609], "o" -> 
           RGBColor[0.800498, 0.201504, 0.192061], "f" -> 
           RGBColor[0.578462, 0.85539, 0.408855], "ne" -> 
           RGBColor[0.677263, 0.928423, 0.955287], "na" -> 
           RGBColor[0.658708, 0.492173, 0.842842], "mg" -> 
           RGBColor[0.628274, 0.850553, 0.0782731], "al" -> 
           RGBColor[0.8913, 0.631904, 0.627399], "si" -> 
           RGBColor[0.941176, 0.784314, 0.627451], "p" -> 
           RGBColor[1., 0.501961, 0], "s" -> 
           RGBColor[0.90443, 0.97015, 0.13504], "cl" -> 
           RGBColor[0.412698, 0.932689, 0.166398], "ar" -> 
           RGBColor[0.546138, 0.844244, 0.892092], "k" -> 
           RGBColor[0.534026, 0.420729, 0.705621], "ca" -> 
           RGBColor[0.480072, 0.744591, 0.0955222], "sc" -> 
           RGBColor[0.901961, 0.901961, 0.901961], "ti" -> 
           RGBColor[0.74902, 0.760784, 0.780392], "v" -> 
           RGBColor[0.65098, 0.65098, 0.670588], "cr" -> 
           RGBColor[0.541176, 0.6, 0.780392], "mn" -> 
           RGBColor[0.611765, 0.478431, 0.780392], "fe" -> 
           RGBColor[0.878431, 0.4, 0.2], "co" -> 
           RGBColor[0.941176, 0.564706, 0.627451], "ni" -> 
           RGBColor[0.313725, 0.815686, 0.313725], "cu" -> 
           RGBColor[0.784314, 0.501961, 0.2], "zn" -> 
           RGBColor[0.490196, 0.501961, 0.690196], "ga" -> 
           RGBColor[0.800757, 0.542666, 0.533513], "ge" -> 
           RGBColor[0.60508, 0.632465, 0.576489], "as" -> 
           RGBColor[0.741176, 0.501961, 0.890196], "se" -> 
           RGBColor[0.917248, 0.657833, 0.0706628], "br" -> 
           RGBColor[0.58847, 0.22163, 0.16064], "kr" -> 
           RGBColor[0.426019, 0.747462, 0.810413], "rb" -> 
           RGBColor[0.425391, 0.329242, 0.585895], "sr" -> 
           RGBColor[0.325959, 0.646423, 0.095983], "y" -> 
           RGBColor[0.531014, 1., 1.], "zr" -> 
           RGBColor[0.458599, 0.917466, 0.918573], "nb" -> 
           RGBColor[0.385036, 0.834854, 0.841681], "mo" -> 
           RGBColor[0.310325, 0.752163, 0.769323], "tc" -> 
           RGBColor[0.234466, 0.669394, 0.701499], "ru" -> 
           RGBColor[0.157459, 0.586546, 0.638209], "rh" -> 
           RGBColor[0.0793033, 0.50362, 0.579453], "pd" -> 
           RGBColor[0., 0.420615, 0.525231], "ag" -> 
           RGBColor[0.752941, 0.752941, 0.752941], "cd" -> 
           RGBColor[1., 0.85098, 0.560784], "in" -> 
           RGBColor[0.728371, 0.440594, 0.422196], "sn" -> 
           RGBColor[0.39799, 0.491477, 0.495586], "sb" -> 
           RGBColor[0.619608, 0.388235, 0.709804], "te" -> 
           RGBColor[0.816706, 0.451332, 0.0100947], "i" -> 
           RGBColor[0.580392, 0, 0.580392], "xe" -> 
           RGBColor[0.316906, 0.638078, 0.710252], "cs" -> 
           RGBColor[0.332803, 0.217712, 0.483666], "ba" -> 
           RGBColor[0.165935, 0.55605, 0.0796556], "la" -> 
           RGBColor[0.928084, 0.716075, 0.329427], "ce" -> 
           RGBColor[0.894824, 0.731424, 0.325131], "pr" -> 
           RGBColor[0.86523, 0.707999, 0.315261], "nd" -> 
           RGBColor[0.837836, 0.662974, 0.301635], "pm" -> 
           RGBColor[0.811992, 0.607859, 0.285626], "sm" -> 
           RGBColor[0.787563, 0.549894, 0.268279], "eu" -> 
           RGBColor[0.764628, 0.493261, 0.250405], "gd" -> 
           RGBColor[0.743177, 0.440115, 0.23269], "tb" -> 
           RGBColor[0.72281, 0.39143, 0.215783], "dy" -> 
           RGBColor[0.702434, 0.347663, 0.200392], "ho" -> 
           RGBColor[0.679962, 0.309234, 0.187368], "er" -> 
           RGBColor[0.652012, 0.276823, 0.17779], "tm" -> 
           RGBColor[0.613603, 0.251489, 0.173042], "yb" -> 
           RGBColor[0.557855, 0.234598, 0.17489], "lu" -> 
           RGBColor[0.475685, 0.227573, 0.18555], "hf" -> 
           RGBColor[0.781537, 0.717388, 0.716579], "ta" -> 
           RGBColor[0.734443, 0.544489, 0.683471], "w" -> 
           RGBColor[0.681179, 0.360409, 0.63675], "re" -> 
           RGBColor[0.605181, 0.367584, 0.556343], "os" -> 
           RGBColor[0.521806, 0.382125, 0.469204], "ir" -> 
           RGBColor[0.445624, 0.373159, 0.399069], "pt" -> 
           RGBColor[0.815686, 0.815686, 0.878431], "au" -> 
           RGBColor[1., 0.819608, 0.137255], "hg" -> 
           RGBColor[0.721569, 0.721569, 0.815686], "tl" -> 
           RGBColor[0.65098, 0.329412, 0.301961], "pb" -> 
           RGBColor[0.341176, 0.34902, 0.380392], "bi" -> 
           RGBColor[0.619608, 0.309804, 0.709804], "po" -> 
           RGBColor[0.670588, 0.360784, 0], "at" -> 
           RGBColor[0.458824, 0.309804, 0.270588], "rn" -> 
           RGBColor[0.218799, 0.516091, 0.591608], "fr" -> 
           RGBColor[0.25626, 0.0861372, 0.398932], "ra" -> 
           RGBColor[0., 0.473472, 0.04654], "ac" -> 
           RGBColor[0.322042, 0.71693, 0.988479], "th" -> 
           RGBColor[0.3608, 0.67166, 0.943003], "pa" -> 
           RGBColor[0.397469, 0.628, 0.898853], "u" -> 
           RGBColor[0.43205, 0.58595, 0.856029], "np" -> 
           RGBColor[0.464542, 0.54551, 0.814532], "pu" -> 
           RGBColor[0.494945, 0.506679, 0.774361], "am" -> 
           RGBColor[0.52326, 0.469458, 0.735517], "cm" -> 
           RGBColor[0.549486, 0.433847, 0.697999], "bk" -> 
           RGBColor[0.573624, 0.399845, 0.661808], "cf" -> 
           RGBColor[0.595673, 0.367454, 0.626942], "es" -> 
           RGBColor[0.615633, 0.336672, 0.593404], "fm" -> 
           RGBColor[0.633505, 0.307499, 0.561191], "md" -> 
           RGBColor[0.649288, 0.279937, 0.530305], "no" -> 
           RGBColor[0.662982, 0.253984, 0.500746], "lr" -> 
           RGBColor[0.674588, 0.22964, 0.472513], "rf" -> 
           RGBColor[0.684106, 0.206907, 0.445606], "db" -> 
           RGBColor[0.691534, 0.185783, 0.420025], "sg" -> 
           RGBColor[0.696874, 0.166269, 0.395772], "bh" -> 
           RGBColor[0.700126, 0.148365, 0.372844], "hs" -> 
           RGBColor[0.701289, 0.13207, 0.351243], "mt" -> 
           RGBColor[0.700363, 0.117385, 0.330968], "ds" -> 
           RGBColor[0.697348, 0.10431, 0.31202], "rg" -> 
           RGBColor[0.692245, 0.0928444, 0.294398], "cn" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "nh" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "fl" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "mc" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "lv" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "ts" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "og" -> 
           RGBColor[0.635401, 0.0528, 0.226184], "uub" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "uut" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "uuq" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "uup" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "uuh" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "uus" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "uuo" -> 
           RGBColor[0.635401, 0.0528, 0.226184]}]]& ][0.85], 
       ColorDataFunction[
       "Atoms", 
        "Named", {{
         "H", "He", "Li", "Be", "B", "C", "N", "O", "F", "Ne", "Na", "Mg", 
          "Al", "Si", "P", "S", "Cl", "Ar", "K", "Ca", "Sc", "Ti", "V", "Cr", 
          "Mn", "Fe", "Co", "Ni", "Cu", "Zn", "Ga", "Ge", "As", "Se", "Br", 
          "Kr", "Rb", "Sr", "Y", "Zr", "Nb", "Mo", "Tc", "Ru", "Rh", "Pd", 
          "Ag", "Cd", "In", "Sn", "Sb", "Te", "I", "Xe", "Cs", "Ba", "La", 
          "Ce", "Pr", "Nd", "Pm", "Sm", "Eu", "Gd", "Tb", "Dy", "Ho", "Er", 
          "Tm", "Yb", "Lu", "Hf", "Ta", "W", "Re", "Os", "Ir", "Pt", "Au", 
          "Hg", "Tl", "Pb", "Bi", "Po", "At", "Rn", "Fr", "Ra", "Ac", "Th", 
          "Pa", "U", "Np", "Pu", "Am", "Cm", "Bk", "Cf", "Es", "Fm", "Md", 
          "No", "Lr", "Rf", "Db", "Sg", "Bh", "Hs", "Mt", "Ds", "Rg", "Cn", 
          "Nh", "Fl", "Mc", "Lv", "Ts", "Og", "Uub", "Uut", "Uuq", "Uup", 
          "Uuh", "Uus", "Uuo"}, {
         "h", "he", "li", "be", "b", "c", "n", "o", "f", "ne", "na", "mg", 
          "al", "si", "p", "s", "cl", "ar", "k", "ca", "sc", "ti", "v", "cr", 
          "mn", "fe", "co", "ni", "cu", "zn", "ga", "ge", "as", "se", "br", 
          "kr", "rb", "sr", "y", "zr", "nb", "mo", "tc", "ru", "rh", "pd", 
          "ag", "cd", "in", "sn", "sb", "te", "i", "xe", "cs", "ba", "la", 
          "ce", "pr", "nd", "pm", "sm", "eu", "gd", "tb", "dy", "ho", "er", 
          "tm", "yb", "lu", "hf", "ta", "w", "re", "os", "ir", "pt", "au", 
          "hg", "tl", "pb", "bi", "po", "at", "rn", "fr", "ra", "ac", "th", 
          "pa", "u", "np", "pu", "am", "cm", "bk", "cf", "es", "fm", "md", 
          "no", "lr", "rf", "db", "sg", "bh", "hs", "mt", "ds", "rg", "cn", 
          "nh", "fl", "mc", "lv", "ts", "og", "uub", "uut", "uuq", "uup", 
          "uuh", "uus", "uuo"}}, Replace[#, 
         Dispatch[{
          "h" -> RGBColor[0.65, 0.7, 0.7], "he" -> RGBColor[0.836713, 1., 1.],
            "li" -> RGBColor[0.799435, 0.543572, 0.997559], "be" -> 
           RGBColor[0.770565, 0.964309, 0.0442359], "b" -> 
           RGBColor[1., 0.709804, 0.709804], "c" -> RGBColor[0.4, 0.4, 0.4], 
           "n" -> RGBColor[0.291989, 0.437977, 0.888609], "o" -> 
           RGBColor[0.800498, 0.201504, 0.192061], "f" -> 
           RGBColor[0.578462, 0.85539, 0.408855], "ne" -> 
           RGBColor[0.677263, 0.928423, 0.955287], "na" -> 
           RGBColor[0.658708, 0.492173, 0.842842], "mg" -> 
           RGBColor[0.628274, 0.850553, 0.0782731], "al" -> 
           RGBColor[0.8913, 0.631904, 0.627399], "si" -> 
           RGBColor[0.941176, 0.784314, 0.627451], "p" -> 
           RGBColor[1., 0.501961, 0], "s" -> 
           RGBColor[0.90443, 0.97015, 0.13504], "cl" -> 
           RGBColor[0.412698, 0.932689, 0.166398], "ar" -> 
           RGBColor[0.546138, 0.844244, 0.892092], "k" -> 
           RGBColor[0.534026, 0.420729, 0.705621], "ca" -> 
           RGBColor[0.480072, 0.744591, 0.0955222], "sc" -> 
           RGBColor[0.901961, 0.901961, 0.901961], "ti" -> 
           RGBColor[0.74902, 0.760784, 0.780392], "v" -> 
           RGBColor[0.65098, 0.65098, 0.670588], "cr" -> 
           RGBColor[0.541176, 0.6, 0.780392], "mn" -> 
           RGBColor[0.611765, 0.478431, 0.780392], "fe" -> 
           RGBColor[0.878431, 0.4, 0.2], "co" -> 
           RGBColor[0.941176, 0.564706, 0.627451], "ni" -> 
           RGBColor[0.313725, 0.815686, 0.313725], "cu" -> 
           RGBColor[0.784314, 0.501961, 0.2], "zn" -> 
           RGBColor[0.490196, 0.501961, 0.690196], "ga" -> 
           RGBColor[0.800757, 0.542666, 0.533513], "ge" -> 
           RGBColor[0.60508, 0.632465, 0.576489], "as" -> 
           RGBColor[0.741176, 0.501961, 0.890196], "se" -> 
           RGBColor[0.917248, 0.657833, 0.0706628], "br" -> 
           RGBColor[0.58847, 0.22163, 0.16064], "kr" -> 
           RGBColor[0.426019, 0.747462, 0.810413], "rb" -> 
           RGBColor[0.425391, 0.329242, 0.585895], "sr" -> 
           RGBColor[0.325959, 0.646423, 0.095983], "y" -> 
           RGBColor[0.531014, 1., 1.], "zr" -> 
           RGBColor[0.458599, 0.917466, 0.918573], "nb" -> 
           RGBColor[0.385036, 0.834854, 0.841681], "mo" -> 
           RGBColor[0.310325, 0.752163, 0.769323], "tc" -> 
           RGBColor[0.234466, 0.669394, 0.701499], "ru" -> 
           RGBColor[0.157459, 0.586546, 0.638209], "rh" -> 
           RGBColor[0.0793033, 0.50362, 0.579453], "pd" -> 
           RGBColor[0., 0.420615, 0.525231], "ag" -> 
           RGBColor[0.752941, 0.752941, 0.752941], "cd" -> 
           RGBColor[1., 0.85098, 0.560784], "in" -> 
           RGBColor[0.728371, 0.440594, 0.422196], "sn" -> 
           RGBColor[0.39799, 0.491477, 0.495586], "sb" -> 
           RGBColor[0.619608, 0.388235, 0.709804], "te" -> 
           RGBColor[0.816706, 0.451332, 0.0100947], "i" -> 
           RGBColor[0.580392, 0, 0.580392], "xe" -> 
           RGBColor[0.316906, 0.638078, 0.710252], "cs" -> 
           RGBColor[0.332803, 0.217712, 0.483666], "ba" -> 
           RGBColor[0.165935, 0.55605, 0.0796556], "la" -> 
           RGBColor[0.928084, 0.716075, 0.329427], "ce" -> 
           RGBColor[0.894824, 0.731424, 0.325131], "pr" -> 
           RGBColor[0.86523, 0.707999, 0.315261], "nd" -> 
           RGBColor[0.837836, 0.662974, 0.301635], "pm" -> 
           RGBColor[0.811992, 0.607859, 0.285626], "sm" -> 
           RGBColor[0.787563, 0.549894, 0.268279], "eu" -> 
           RGBColor[0.764628, 0.493261, 0.250405], "gd" -> 
           RGBColor[0.743177, 0.440115, 0.23269], "tb" -> 
           RGBColor[0.72281, 0.39143, 0.215783], "dy" -> 
           RGBColor[0.702434, 0.347663, 0.200392], "ho" -> 
           RGBColor[0.679962, 0.309234, 0.187368], "er" -> 
           RGBColor[0.652012, 0.276823, 0.17779], "tm" -> 
           RGBColor[0.613603, 0.251489, 0.173042], "yb" -> 
           RGBColor[0.557855, 0.234598, 0.17489], "lu" -> 
           RGBColor[0.475685, 0.227573, 0.18555], "hf" -> 
           RGBColor[0.781537, 0.717388, 0.716579], "ta" -> 
           RGBColor[0.734443, 0.544489, 0.683471], "w" -> 
           RGBColor[0.681179, 0.360409, 0.63675], "re" -> 
           RGBColor[0.605181, 0.367584, 0.556343], "os" -> 
           RGBColor[0.521806, 0.382125, 0.469204], "ir" -> 
           RGBColor[0.445624, 0.373159, 0.399069], "pt" -> 
           RGBColor[0.815686, 0.815686, 0.878431], "au" -> 
           RGBColor[1., 0.819608, 0.137255], "hg" -> 
           RGBColor[0.721569, 0.721569, 0.815686], "tl" -> 
           RGBColor[0.65098, 0.329412, 0.301961], "pb" -> 
           RGBColor[0.341176, 0.34902, 0.380392], "bi" -> 
           RGBColor[0.619608, 0.309804, 0.709804], "po" -> 
           RGBColor[0.670588, 0.360784, 0], "at" -> 
           RGBColor[0.458824, 0.309804, 0.270588], "rn" -> 
           RGBColor[0.218799, 0.516091, 0.591608], "fr" -> 
           RGBColor[0.25626, 0.0861372, 0.398932], "ra" -> 
           RGBColor[0., 0.473472, 0.04654], "ac" -> 
           RGBColor[0.322042, 0.71693, 0.988479], "th" -> 
           RGBColor[0.3608, 0.67166, 0.943003], "pa" -> 
           RGBColor[0.397469, 0.628, 0.898853], "u" -> 
           RGBColor[0.43205, 0.58595, 0.856029], "np" -> 
           RGBColor[0.464542, 0.54551, 0.814532], "pu" -> 
           RGBColor[0.494945, 0.506679, 0.774361], "am" -> 
           RGBColor[0.52326, 0.469458, 0.735517], "cm" -> 
           RGBColor[0.549486, 0.433847, 0.697999], "bk" -> 
           RGBColor[0.573624, 0.399845, 0.661808], "cf" -> 
           RGBColor[0.595673, 0.367454, 0.626942], "es" -> 
           RGBColor[0.615633, 0.336672, 0.593404], "fm" -> 
           RGBColor[0.633505, 0.307499, 0.561191], "md" -> 
           RGBColor[0.649288, 0.279937, 0.530305], "no" -> 
           RGBColor[0.662982, 0.253984, 0.500746], "lr" -> 
           RGBColor[0.674588, 0.22964, 0.472513], "rf" -> 
           RGBColor[0.684106, 0.206907, 0.445606], "db" -> 
           RGBColor[0.691534, 0.185783, 0.420025], "sg" -> 
           RGBColor[0.696874, 0.166269, 0.395772], "bh" -> 
           RGBColor[0.700126, 0.148365, 0.372844], "hs" -> 
           RGBColor[0.701289, 0.13207, 0.351243], "mt" -> 
           RGBColor[0.700363, 0.117385, 0.330968], "ds" -> 
           RGBColor[0.697348, 0.10431, 0.31202], "rg" -> 
           RGBColor[0.692245, 0.0928444, 0.294398], "cn" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "nh" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "fl" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "mc" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "lv" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "ts" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "og" -> 
           RGBColor[0.635401, 0.0528, 0.226184], "uub" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "uut" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "uuq" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "uup" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "uuh" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "uus" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "uuo" -> 
           RGBColor[0.635401, 0.0528, 0.226184]}]]& ][0.85], 
       ColorDataFunction[
       "Atoms", 
        "Named", {{
         "H", "He", "Li", "Be", "B", "C", "N", "O", "F", "Ne", "Na", "Mg", 
          "Al", "Si", "P", "S", "Cl", "Ar", "K", "Ca", "Sc", "Ti", "V", "Cr", 
          "Mn", "Fe", "Co", "Ni", "Cu", "Zn", "Ga", "Ge", "As", "Se", "Br", 
          "Kr", "Rb", "Sr", "Y", "Zr", "Nb", "Mo", "Tc", "Ru", "Rh", "Pd", 
          "Ag", "Cd", "In", "Sn", "Sb", "Te", "I", "Xe", "Cs", "Ba", "La", 
          "Ce", "Pr", "Nd", "Pm", "Sm", "Eu", "Gd", "Tb", "Dy", "Ho", "Er", 
          "Tm", "Yb", "Lu", "Hf", "Ta", "W", "Re", "Os", "Ir", "Pt", "Au", 
          "Hg", "Tl", "Pb", "Bi", "Po", "At", "Rn", "Fr", "Ra", "Ac", "Th", 
          "Pa", "U", "Np", "Pu", "Am", "Cm", "Bk", "Cf", "Es", "Fm", "Md", 
          "No", "Lr", "Rf", "Db", "Sg", "Bh", "Hs", "Mt", "Ds", "Rg", "Cn", 
          "Nh", "Fl", "Mc", "Lv", "Ts", "Og", "Uub", "Uut", "Uuq", "Uup", 
          "Uuh", "Uus", "Uuo"}, {
         "h", "he", "li", "be", "b", "c", "n", "o", "f", "ne", "na", "mg", 
          "al", "si", "p", "s", "cl", "ar", "k", "ca", "sc", "ti", "v", "cr", 
          "mn", "fe", "co", "ni", "cu", "zn", "ga", "ge", "as", "se", "br", 
          "kr", "rb", "sr", "y", "zr", "nb", "mo", "tc", "ru", "rh", "pd", 
          "ag", "cd", "in", "sn", "sb", "te", "i", "xe", "cs", "ba", "la", 
          "ce", "pr", "nd", "pm", "sm", "eu", "gd", "tb", "dy", "ho", "er", 
          "tm", "yb", "lu", "hf", "ta", "w", "re", "os", "ir", "pt", "au", 
          "hg", "tl", "pb", "bi", "po", "at", "rn", "fr", "ra", "ac", "th", 
          "pa", "u", "np", "pu", "am", "cm", "bk", "cf", "es", "fm", "md", 
          "no", "lr", "rf", "db", "sg", "bh", "hs", "mt", "ds", "rg", "cn", 
          "nh", "fl", "mc", "lv", "ts", "og", "uub", "uut", "uuq", "uup", 
          "uuh", "uus", "uuo"}}, Replace[#, 
         Dispatch[{
          "h" -> RGBColor[0.65, 0.7, 0.7], "he" -> RGBColor[0.836713, 1., 1.],
            "li" -> RGBColor[0.799435, 0.543572, 0.997559], "be" -> 
           RGBColor[0.770565, 0.964309, 0.0442359], "b" -> 
           RGBColor[1., 0.709804, 0.709804], "c" -> RGBColor[0.4, 0.4, 0.4], 
           "n" -> RGBColor[0.291989, 0.437977, 0.888609], "o" -> 
           RGBColor[0.800498, 0.201504, 0.192061], "f" -> 
           RGBColor[0.578462, 0.85539, 0.408855], "ne" -> 
           RGBColor[0.677263, 0.928423, 0.955287], "na" -> 
           RGBColor[0.658708, 0.492173, 0.842842], "mg" -> 
           RGBColor[0.628274, 0.850553, 0.0782731], "al" -> 
           RGBColor[0.8913, 0.631904, 0.627399], "si" -> 
           RGBColor[0.941176, 0.784314, 0.627451], "p" -> 
           RGBColor[1., 0.501961, 0], "s" -> 
           RGBColor[0.90443, 0.97015, 0.13504], "cl" -> 
           RGBColor[0.412698, 0.932689, 0.166398], "ar" -> 
           RGBColor[0.546138, 0.844244, 0.892092], "k" -> 
           RGBColor[0.534026, 0.420729, 0.705621], "ca" -> 
           RGBColor[0.480072, 0.744591, 0.0955222], "sc" -> 
           RGBColor[0.901961, 0.901961, 0.901961], "ti" -> 
           RGBColor[0.74902, 0.760784, 0.780392], "v" -> 
           RGBColor[0.65098, 0.65098, 0.670588], "cr" -> 
           RGBColor[0.541176, 0.6, 0.780392], "mn" -> 
           RGBColor[0.611765, 0.478431, 0.780392], "fe" -> 
           RGBColor[0.878431, 0.4, 0.2], "co" -> 
           RGBColor[0.941176, 0.564706, 0.627451], "ni" -> 
           RGBColor[0.313725, 0.815686, 0.313725], "cu" -> 
           RGBColor[0.784314, 0.501961, 0.2], "zn" -> 
           RGBColor[0.490196, 0.501961, 0.690196], "ga" -> 
           RGBColor[0.800757, 0.542666, 0.533513], "ge" -> 
           RGBColor[0.60508, 0.632465, 0.576489], "as" -> 
           RGBColor[0.741176, 0.501961, 0.890196], "se" -> 
           RGBColor[0.917248, 0.657833, 0.0706628], "br" -> 
           RGBColor[0.58847, 0.22163, 0.16064], "kr" -> 
           RGBColor[0.426019, 0.747462, 0.810413], "rb" -> 
           RGBColor[0.425391, 0.329242, 0.585895], "sr" -> 
           RGBColor[0.325959, 0.646423, 0.095983], "y" -> 
           RGBColor[0.531014, 1., 1.], "zr" -> 
           RGBColor[0.458599, 0.917466, 0.918573], "nb" -> 
           RGBColor[0.385036, 0.834854, 0.841681], "mo" -> 
           RGBColor[0.310325, 0.752163, 0.769323], "tc" -> 
           RGBColor[0.234466, 0.669394, 0.701499], "ru" -> 
           RGBColor[0.157459, 0.586546, 0.638209], "rh" -> 
           RGBColor[0.0793033, 0.50362, 0.579453], "pd" -> 
           RGBColor[0., 0.420615, 0.525231], "ag" -> 
           RGBColor[0.752941, 0.752941, 0.752941], "cd" -> 
           RGBColor[1., 0.85098, 0.560784], "in" -> 
           RGBColor[0.728371, 0.440594, 0.422196], "sn" -> 
           RGBColor[0.39799, 0.491477, 0.495586], "sb" -> 
           RGBColor[0.619608, 0.388235, 0.709804], "te" -> 
           RGBColor[0.816706, 0.451332, 0.0100947], "i" -> 
           RGBColor[0.580392, 0, 0.580392], "xe" -> 
           RGBColor[0.316906, 0.638078, 0.710252], "cs" -> 
           RGBColor[0.332803, 0.217712, 0.483666], "ba" -> 
           RGBColor[0.165935, 0.55605, 0.0796556], "la" -> 
           RGBColor[0.928084, 0.716075, 0.329427], "ce" -> 
           RGBColor[0.894824, 0.731424, 0.325131], "pr" -> 
           RGBColor[0.86523, 0.707999, 0.315261], "nd" -> 
           RGBColor[0.837836, 0.662974, 0.301635], "pm" -> 
           RGBColor[0.811992, 0.607859, 0.285626], "sm" -> 
           RGBColor[0.787563, 0.549894, 0.268279], "eu" -> 
           RGBColor[0.764628, 0.493261, 0.250405], "gd" -> 
           RGBColor[0.743177, 0.440115, 0.23269], "tb" -> 
           RGBColor[0.72281, 0.39143, 0.215783], "dy" -> 
           RGBColor[0.702434, 0.347663, 0.200392], "ho" -> 
           RGBColor[0.679962, 0.309234, 0.187368], "er" -> 
           RGBColor[0.652012, 0.276823, 0.17779], "tm" -> 
           RGBColor[0.613603, 0.251489, 0.173042], "yb" -> 
           RGBColor[0.557855, 0.234598, 0.17489], "lu" -> 
           RGBColor[0.475685, 0.227573, 0.18555], "hf" -> 
           RGBColor[0.781537, 0.717388, 0.716579], "ta" -> 
           RGBColor[0.734443, 0.544489, 0.683471], "w" -> 
           RGBColor[0.681179, 0.360409, 0.63675], "re" -> 
           RGBColor[0.605181, 0.367584, 0.556343], "os" -> 
           RGBColor[0.521806, 0.382125, 0.469204], "ir" -> 
           RGBColor[0.445624, 0.373159, 0.399069], "pt" -> 
           RGBColor[0.815686, 0.815686, 0.878431], "au" -> 
           RGBColor[1., 0.819608, 0.137255], "hg" -> 
           RGBColor[0.721569, 0.721569, 0.815686], "tl" -> 
           RGBColor[0.65098, 0.329412, 0.301961], "pb" -> 
           RGBColor[0.341176, 0.34902, 0.380392], "bi" -> 
           RGBColor[0.619608, 0.309804, 0.709804], "po" -> 
           RGBColor[0.670588, 0.360784, 0], "at" -> 
           RGBColor[0.458824, 0.309804, 0.270588], "rn" -> 
           RGBColor[0.218799, 0.516091, 0.591608], "fr" -> 
           RGBColor[0.25626, 0.0861372, 0.398932], "ra" -> 
           RGBColor[0., 0.473472, 0.04654], "ac" -> 
           RGBColor[0.322042, 0.71693, 0.988479], "th" -> 
           RGBColor[0.3608, 0.67166, 0.943003], "pa" -> 
           RGBColor[0.397469, 0.628, 0.898853], "u" -> 
           RGBColor[0.43205, 0.58595, 0.856029], "np" -> 
           RGBColor[0.464542, 0.54551, 0.814532], "pu" -> 
           RGBColor[0.494945, 0.506679, 0.774361], "am" -> 
           RGBColor[0.52326, 0.469458, 0.735517], "cm" -> 
           RGBColor[0.549486, 0.433847, 0.697999], "bk" -> 
           RGBColor[0.573624, 0.399845, 0.661808], "cf" -> 
           RGBColor[0.595673, 0.367454, 0.626942], "es" -> 
           RGBColor[0.615633, 0.336672, 0.593404], "fm" -> 
           RGBColor[0.633505, 0.307499, 0.561191], "md" -> 
           RGBColor[0.649288, 0.279937, 0.530305], "no" -> 
           RGBColor[0.662982, 0.253984, 0.500746], "lr" -> 
           RGBColor[0.674588, 0.22964, 0.472513], "rf" -> 
           RGBColor[0.684106, 0.206907, 0.445606], "db" -> 
           RGBColor[0.691534, 0.185783, 0.420025], "sg" -> 
           RGBColor[0.696874, 0.166269, 0.395772], "bh" -> 
           RGBColor[0.700126, 0.148365, 0.372844], "hs" -> 
           RGBColor[0.701289, 0.13207, 0.351243], "mt" -> 
           RGBColor[0.700363, 0.117385, 0.330968], "ds" -> 
           RGBColor[0.697348, 0.10431, 0.31202], "rg" -> 
           RGBColor[0.692245, 0.0928444, 0.294398], "cn" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "nh" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "fl" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "mc" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "lv" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "ts" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "og" -> 
           RGBColor[0.635401, 0.0528, 0.226184], "uub" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "uut" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "uuq" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "uup" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "uuh" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "uus" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "uuo" -> 
           RGBColor[0.635401, 0.0528, 0.226184]}]]& ][0.85], 
       ColorDataFunction[
       "Atoms", 
        "Named", {{
         "H", "He", "Li", "Be", "B", "C", "N", "O", "F", "Ne", "Na", "Mg", 
          "Al", "Si", "P", "S", "Cl", "Ar", "K", "Ca", "Sc", "Ti", "V", "Cr", 
          "Mn", "Fe", "Co", "Ni", "Cu", "Zn", "Ga", "Ge", "As", "Se", "Br", 
          "Kr", "Rb", "Sr", "Y", "Zr", "Nb", "Mo", "Tc", "Ru", "Rh", "Pd", 
          "Ag", "Cd", "In", "Sn", "Sb", "Te", "I", "Xe", "Cs", "Ba", "La", 
          "Ce", "Pr", "Nd", "Pm", "Sm", "Eu", "Gd", "Tb", "Dy", "Ho", "Er", 
          "Tm", "Yb", "Lu", "Hf", "Ta", "W", "Re", "Os", "Ir", "Pt", "Au", 
          "Hg", "Tl", "Pb", "Bi", "Po", "At", "Rn", "Fr", "Ra", "Ac", "Th", 
          "Pa", "U", "Np", "Pu", "Am", "Cm", "Bk", "Cf", "Es", "Fm", "Md", 
          "No", "Lr", "Rf", "Db", "Sg", "Bh", "Hs", "Mt", "Ds", "Rg", "Cn", 
          "Nh", "Fl", "Mc", "Lv", "Ts", "Og", "Uub", "Uut", "Uuq", "Uup", 
          "Uuh", "Uus", "Uuo"}, {
         "h", "he", "li", "be", "b", "c", "n", "o", "f", "ne", "na", "mg", 
          "al", "si", "p", "s", "cl", "ar", "k", "ca", "sc", "ti", "v", "cr", 
          "mn", "fe", "co", "ni", "cu", "zn", "ga", "ge", "as", "se", "br", 
          "kr", "rb", "sr", "y", "zr", "nb", "mo", "tc", "ru", "rh", "pd", 
          "ag", "cd", "in", "sn", "sb", "te", "i", "xe", "cs", "ba", "la", 
          "ce", "pr", "nd", "pm", "sm", "eu", "gd", "tb", "dy", "ho", "er", 
          "tm", "yb", "lu", "hf", "ta", "w", "re", "os", "ir", "pt", "au", 
          "hg", "tl", "pb", "bi", "po", "at", "rn", "fr", "ra", "ac", "th", 
          "pa", "u", "np", "pu", "am", "cm", "bk", "cf", "es", "fm", "md", 
          "no", "lr", "rf", "db", "sg", "bh", "hs", "mt", "ds", "rg", "cn", 
          "nh", "fl", "mc", "lv", "ts", "og", "uub", "uut", "uuq", "uup", 
          "uuh", "uus", "uuo"}}, Replace[#, 
         Dispatch[{
          "h" -> RGBColor[0.65, 0.7, 0.7], "he" -> RGBColor[0.836713, 1., 1.],
            "li" -> RGBColor[0.799435, 0.543572, 0.997559], "be" -> 
           RGBColor[0.770565, 0.964309, 0.0442359], "b" -> 
           RGBColor[1., 0.709804, 0.709804], "c" -> RGBColor[0.4, 0.4, 0.4], 
           "n" -> RGBColor[0.291989, 0.437977, 0.888609], "o" -> 
           RGBColor[0.800498, 0.201504, 0.192061], "f" -> 
           RGBColor[0.578462, 0.85539, 0.408855], "ne" -> 
           RGBColor[0.677263, 0.928423, 0.955287], "na" -> 
           RGBColor[0.658708, 0.492173, 0.842842], "mg" -> 
           RGBColor[0.628274, 0.850553, 0.0782731], "al" -> 
           RGBColor[0.8913, 0.631904, 0.627399], "si" -> 
           RGBColor[0.941176, 0.784314, 0.627451], "p" -> 
           RGBColor[1., 0.501961, 0], "s" -> 
           RGBColor[0.90443, 0.97015, 0.13504], "cl" -> 
           RGBColor[0.412698, 0.932689, 0.166398], "ar" -> 
           RGBColor[0.546138, 0.844244, 0.892092], "k" -> 
           RGBColor[0.534026, 0.420729, 0.705621], "ca" -> 
           RGBColor[0.480072, 0.744591, 0.0955222], "sc" -> 
           RGBColor[0.901961, 0.901961, 0.901961], "ti" -> 
           RGBColor[0.74902, 0.760784, 0.780392], "v" -> 
           RGBColor[0.65098, 0.65098, 0.670588], "cr" -> 
           RGBColor[0.541176, 0.6, 0.780392], "mn" -> 
           RGBColor[0.611765, 0.478431, 0.780392], "fe" -> 
           RGBColor[0.878431, 0.4, 0.2], "co" -> 
           RGBColor[0.941176, 0.564706, 0.627451], "ni" -> 
           RGBColor[0.313725, 0.815686, 0.313725], "cu" -> 
           RGBColor[0.784314, 0.501961, 0.2], "zn" -> 
           RGBColor[0.490196, 0.501961, 0.690196], "ga" -> 
           RGBColor[0.800757, 0.542666, 0.533513], "ge" -> 
           RGBColor[0.60508, 0.632465, 0.576489], "as" -> 
           RGBColor[0.741176, 0.501961, 0.890196], "se" -> 
           RGBColor[0.917248, 0.657833, 0.0706628], "br" -> 
           RGBColor[0.58847, 0.22163, 0.16064], "kr" -> 
           RGBColor[0.426019, 0.747462, 0.810413], "rb" -> 
           RGBColor[0.425391, 0.329242, 0.585895], "sr" -> 
           RGBColor[0.325959, 0.646423, 0.095983], "y" -> 
           RGBColor[0.531014, 1., 1.], "zr" -> 
           RGBColor[0.458599, 0.917466, 0.918573], "nb" -> 
           RGBColor[0.385036, 0.834854, 0.841681], "mo" -> 
           RGBColor[0.310325, 0.752163, 0.769323], "tc" -> 
           RGBColor[0.234466, 0.669394, 0.701499], "ru" -> 
           RGBColor[0.157459, 0.586546, 0.638209], "rh" -> 
           RGBColor[0.0793033, 0.50362, 0.579453], "pd" -> 
           RGBColor[0., 0.420615, 0.525231], "ag" -> 
           RGBColor[0.752941, 0.752941, 0.752941], "cd" -> 
           RGBColor[1., 0.85098, 0.560784], "in" -> 
           RGBColor[0.728371, 0.440594, 0.422196], "sn" -> 
           RGBColor[0.39799, 0.491477, 0.495586], "sb" -> 
           RGBColor[0.619608, 0.388235, 0.709804], "te" -> 
           RGBColor[0.816706, 0.451332, 0.0100947], "i" -> 
           RGBColor[0.580392, 0, 0.580392], "xe" -> 
           RGBColor[0.316906, 0.638078, 0.710252], "cs" -> 
           RGBColor[0.332803, 0.217712, 0.483666], "ba" -> 
           RGBColor[0.165935, 0.55605, 0.0796556], "la" -> 
           RGBColor[0.928084, 0.716075, 0.329427], "ce" -> 
           RGBColor[0.894824, 0.731424, 0.325131], "pr" -> 
           RGBColor[0.86523, 0.707999, 0.315261], "nd" -> 
           RGBColor[0.837836, 0.662974, 0.301635], "pm" -> 
           RGBColor[0.811992, 0.607859, 0.285626], "sm" -> 
           RGBColor[0.787563, 0.549894, 0.268279], "eu" -> 
           RGBColor[0.764628, 0.493261, 0.250405], "gd" -> 
           RGBColor[0.743177, 0.440115, 0.23269], "tb" -> 
           RGBColor[0.72281, 0.39143, 0.215783], "dy" -> 
           RGBColor[0.702434, 0.347663, 0.200392], "ho" -> 
           RGBColor[0.679962, 0.309234, 0.187368], "er" -> 
           RGBColor[0.652012, 0.276823, 0.17779], "tm" -> 
           RGBColor[0.613603, 0.251489, 0.173042], "yb" -> 
           RGBColor[0.557855, 0.234598, 0.17489], "lu" -> 
           RGBColor[0.475685, 0.227573, 0.18555], "hf" -> 
           RGBColor[0.781537, 0.717388, 0.716579], "ta" -> 
           RGBColor[0.734443, 0.544489, 0.683471], "w" -> 
           RGBColor[0.681179, 0.360409, 0.63675], "re" -> 
           RGBColor[0.605181, 0.367584, 0.556343], "os" -> 
           RGBColor[0.521806, 0.382125, 0.469204], "ir" -> 
           RGBColor[0.445624, 0.373159, 0.399069], "pt" -> 
           RGBColor[0.815686, 0.815686, 0.878431], "au" -> 
           RGBColor[1., 0.819608, 0.137255], "hg" -> 
           RGBColor[0.721569, 0.721569, 0.815686], "tl" -> 
           RGBColor[0.65098, 0.329412, 0.301961], "pb" -> 
           RGBColor[0.341176, 0.34902, 0.380392], "bi" -> 
           RGBColor[0.619608, 0.309804, 0.709804], "po" -> 
           RGBColor[0.670588, 0.360784, 0], "at" -> 
           RGBColor[0.458824, 0.309804, 0.270588], "rn" -> 
           RGBColor[0.218799, 0.516091, 0.591608], "fr" -> 
           RGBColor[0.25626, 0.0861372, 0.398932], "ra" -> 
           RGBColor[0., 0.473472, 0.04654], "ac" -> 
           RGBColor[0.322042, 0.71693, 0.988479], "th" -> 
           RGBColor[0.3608, 0.67166, 0.943003], "pa" -> 
           RGBColor[0.397469, 0.628, 0.898853], "u" -> 
           RGBColor[0.43205, 0.58595, 0.856029], "np" -> 
           RGBColor[0.464542, 0.54551, 0.814532], "pu" -> 
           RGBColor[0.494945, 0.506679, 0.774361], "am" -> 
           RGBColor[0.52326, 0.469458, 0.735517], "cm" -> 
           RGBColor[0.549486, 0.433847, 0.697999], "bk" -> 
           RGBColor[0.573624, 0.399845, 0.661808], "cf" -> 
           RGBColor[0.595673, 0.367454, 0.626942], "es" -> 
           RGBColor[0.615633, 0.336672, 0.593404], "fm" -> 
           RGBColor[0.633505, 0.307499, 0.561191], "md" -> 
           RGBColor[0.649288, 0.279937, 0.530305], "no" -> 
           RGBColor[0.662982, 0.253984, 0.500746], "lr" -> 
           RGBColor[0.674588, 0.22964, 0.472513], "rf" -> 
           RGBColor[0.684106, 0.206907, 0.445606], "db" -> 
           RGBColor[0.691534, 0.185783, 0.420025], "sg" -> 
           RGBColor[0.696874, 0.166269, 0.395772], "bh" -> 
           RGBColor[0.700126, 0.148365, 0.372844], "hs" -> 
           RGBColor[0.701289, 0.13207, 0.351243], "mt" -> 
           RGBColor[0.700363, 0.117385, 0.330968], "ds" -> 
           RGBColor[0.697348, 0.10431, 0.31202], "rg" -> 
           RGBColor[0.692245, 0.0928444, 0.294398], "cn" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "nh" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "fl" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "mc" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "lv" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "ts" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "og" -> 
           RGBColor[0.635401, 0.0528, 0.226184], "uub" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "uut" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "uuq" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "uup" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "uuh" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "uus" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "uuo" -> 
           RGBColor[0.635401, 0.0528, 0.226184]}]]& ][0.85], 
       ColorDataFunction[
       "Atoms", 
        "Named", {{
         "H", "He", "Li", "Be", "B", "C", "N", "O", "F", "Ne", "Na", "Mg", 
          "Al", "Si", "P", "S", "Cl", "Ar", "K", "Ca", "Sc", "Ti", "V", "Cr", 
          "Mn", "Fe", "Co", "Ni", "Cu", "Zn", "Ga", "Ge", "As", "Se", "Br", 
          "Kr", "Rb", "Sr", "Y", "Zr", "Nb", "Mo", "Tc", "Ru", "Rh", "Pd", 
          "Ag", "Cd", "In", "Sn", "Sb", "Te", "I", "Xe", "Cs", "Ba", "La", 
          "Ce", "Pr", "Nd", "Pm", "Sm", "Eu", "Gd", "Tb", "Dy", "Ho", "Er", 
          "Tm", "Yb", "Lu", "Hf", "Ta", "W", "Re", "Os", "Ir", "Pt", "Au", 
          "Hg", "Tl", "Pb", "Bi", "Po", "At", "Rn", "Fr", "Ra", "Ac", "Th", 
          "Pa", "U", "Np", "Pu", "Am", "Cm", "Bk", "Cf", "Es", "Fm", "Md", 
          "No", "Lr", "Rf", "Db", "Sg", "Bh", "Hs", "Mt", "Ds", "Rg", "Cn", 
          "Nh", "Fl", "Mc", "Lv", "Ts", "Og", "Uub", "Uut", "Uuq", "Uup", 
          "Uuh", "Uus", "Uuo"}, {
         "h", "he", "li", "be", "b", "c", "n", "o", "f", "ne", "na", "mg", 
          "al", "si", "p", "s", "cl", "ar", "k", "ca", "sc", "ti", "v", "cr", 
          "mn", "fe", "co", "ni", "cu", "zn", "ga", "ge", "as", "se", "br", 
          "kr", "rb", "sr", "y", "zr", "nb", "mo", "tc", "ru", "rh", "pd", 
          "ag", "cd", "in", "sn", "sb", "te", "i", "xe", "cs", "ba", "la", 
          "ce", "pr", "nd", "pm", "sm", "eu", "gd", "tb", "dy", "ho", "er", 
          "tm", "yb", "lu", "hf", "ta", "w", "re", "os", "ir", "pt", "au", 
          "hg", "tl", "pb", "bi", "po", "at", "rn", "fr", "ra", "ac", "th", 
          "pa", "u", "np", "pu", "am", "cm", "bk", "cf", "es", "fm", "md", 
          "no", "lr", "rf", "db", "sg", "bh", "hs", "mt", "ds", "rg", "cn", 
          "nh", "fl", "mc", "lv", "ts", "og", "uub", "uut", "uuq", "uup", 
          "uuh", "uus", "uuo"}}, Replace[#, 
         Dispatch[{
          "h" -> RGBColor[0.65, 0.7, 0.7], "he" -> RGBColor[0.836713, 1., 1.],
            "li" -> RGBColor[0.799435, 0.543572, 0.997559], "be" -> 
           RGBColor[0.770565, 0.964309, 0.0442359], "b" -> 
           RGBColor[1., 0.709804, 0.709804], "c" -> RGBColor[0.4, 0.4, 0.4], 
           "n" -> RGBColor[0.291989, 0.437977, 0.888609], "o" -> 
           RGBColor[0.800498, 0.201504, 0.192061], "f" -> 
           RGBColor[0.578462, 0.85539, 0.408855], "ne" -> 
           RGBColor[0.677263, 0.928423, 0.955287], "na" -> 
           RGBColor[0.658708, 0.492173, 0.842842], "mg" -> 
           RGBColor[0.628274, 0.850553, 0.0782731], "al" -> 
           RGBColor[0.8913, 0.631904, 0.627399], "si" -> 
           RGBColor[0.941176, 0.784314, 0.627451], "p" -> 
           RGBColor[1., 0.501961, 0], "s" -> 
           RGBColor[0.90443, 0.97015, 0.13504], "cl" -> 
           RGBColor[0.412698, 0.932689, 0.166398], "ar" -> 
           RGBColor[0.546138, 0.844244, 0.892092], "k" -> 
           RGBColor[0.534026, 0.420729, 0.705621], "ca" -> 
           RGBColor[0.480072, 0.744591, 0.0955222], "sc" -> 
           RGBColor[0.901961, 0.901961, 0.901961], "ti" -> 
           RGBColor[0.74902, 0.760784, 0.780392], "v" -> 
           RGBColor[0.65098, 0.65098, 0.670588], "cr" -> 
           RGBColor[0.541176, 0.6, 0.780392], "mn" -> 
           RGBColor[0.611765, 0.478431, 0.780392], "fe" -> 
           RGBColor[0.878431, 0.4, 0.2], "co" -> 
           RGBColor[0.941176, 0.564706, 0.627451], "ni" -> 
           RGBColor[0.313725, 0.815686, 0.313725], "cu" -> 
           RGBColor[0.784314, 0.501961, 0.2], "zn" -> 
           RGBColor[0.490196, 0.501961, 0.690196], "ga" -> 
           RGBColor[0.800757, 0.542666, 0.533513], "ge" -> 
           RGBColor[0.60508, 0.632465, 0.576489], "as" -> 
           RGBColor[0.741176, 0.501961, 0.890196], "se" -> 
           RGBColor[0.917248, 0.657833, 0.0706628], "br" -> 
           RGBColor[0.58847, 0.22163, 0.16064], "kr" -> 
           RGBColor[0.426019, 0.747462, 0.810413], "rb" -> 
           RGBColor[0.425391, 0.329242, 0.585895], "sr" -> 
           RGBColor[0.325959, 0.646423, 0.095983], "y" -> 
           RGBColor[0.531014, 1., 1.], "zr" -> 
           RGBColor[0.458599, 0.917466, 0.918573], "nb" -> 
           RGBColor[0.385036, 0.834854, 0.841681], "mo" -> 
           RGBColor[0.310325, 0.752163, 0.769323], "tc" -> 
           RGBColor[0.234466, 0.669394, 0.701499], "ru" -> 
           RGBColor[0.157459, 0.586546, 0.638209], "rh" -> 
           RGBColor[0.0793033, 0.50362, 0.579453], "pd" -> 
           RGBColor[0., 0.420615, 0.525231], "ag" -> 
           RGBColor[0.752941, 0.752941, 0.752941], "cd" -> 
           RGBColor[1., 0.85098, 0.560784], "in" -> 
           RGBColor[0.728371, 0.440594, 0.422196], "sn" -> 
           RGBColor[0.39799, 0.491477, 0.495586], "sb" -> 
           RGBColor[0.619608, 0.388235, 0.709804], "te" -> 
           RGBColor[0.816706, 0.451332, 0.0100947], "i" -> 
           RGBColor[0.580392, 0, 0.580392], "xe" -> 
           RGBColor[0.316906, 0.638078, 0.710252], "cs" -> 
           RGBColor[0.332803, 0.217712, 0.483666], "ba" -> 
           RGBColor[0.165935, 0.55605, 0.0796556], "la" -> 
           RGBColor[0.928084, 0.716075, 0.329427], "ce" -> 
           RGBColor[0.894824, 0.731424, 0.325131], "pr" -> 
           RGBColor[0.86523, 0.707999, 0.315261], "nd" -> 
           RGBColor[0.837836, 0.662974, 0.301635], "pm" -> 
           RGBColor[0.811992, 0.607859, 0.285626], "sm" -> 
           RGBColor[0.787563, 0.549894, 0.268279], "eu" -> 
           RGBColor[0.764628, 0.493261, 0.250405], "gd" -> 
           RGBColor[0.743177, 0.440115, 0.23269], "tb" -> 
           RGBColor[0.72281, 0.39143, 0.215783], "dy" -> 
           RGBColor[0.702434, 0.347663, 0.200392], "ho" -> 
           RGBColor[0.679962, 0.309234, 0.187368], "er" -> 
           RGBColor[0.652012, 0.276823, 0.17779], "tm" -> 
           RGBColor[0.613603, 0.251489, 0.173042], "yb" -> 
           RGBColor[0.557855, 0.234598, 0.17489], "lu" -> 
           RGBColor[0.475685, 0.227573, 0.18555], "hf" -> 
           RGBColor[0.781537, 0.717388, 0.716579], "ta" -> 
           RGBColor[0.734443, 0.544489, 0.683471], "w" -> 
           RGBColor[0.681179, 0.360409, 0.63675], "re" -> 
           RGBColor[0.605181, 0.367584, 0.556343], "os" -> 
           RGBColor[0.521806, 0.382125, 0.469204], "ir" -> 
           RGBColor[0.445624, 0.373159, 0.399069], "pt" -> 
           RGBColor[0.815686, 0.815686, 0.878431], "au" -> 
           RGBColor[1., 0.819608, 0.137255], "hg" -> 
           RGBColor[0.721569, 0.721569, 0.815686], "tl" -> 
           RGBColor[0.65098, 0.329412, 0.301961], "pb" -> 
           RGBColor[0.341176, 0.34902, 0.380392], "bi" -> 
           RGBColor[0.619608, 0.309804, 0.709804], "po" -> 
           RGBColor[0.670588, 0.360784, 0], "at" -> 
           RGBColor[0.458824, 0.309804, 0.270588], "rn" -> 
           RGBColor[0.218799, 0.516091, 0.591608], "fr" -> 
           RGBColor[0.25626, 0.0861372, 0.398932], "ra" -> 
           RGBColor[0., 0.473472, 0.04654], "ac" -> 
           RGBColor[0.322042, 0.71693, 0.988479], "th" -> 
           RGBColor[0.3608, 0.67166, 0.943003], "pa" -> 
           RGBColor[0.397469, 0.628, 0.898853], "u" -> 
           RGBColor[0.43205, 0.58595, 0.856029], "np" -> 
           RGBColor[0.464542, 0.54551, 0.814532], "pu" -> 
           RGBColor[0.494945, 0.506679, 0.774361], "am" -> 
           RGBColor[0.52326, 0.469458, 0.735517], "cm" -> 
           RGBColor[0.549486, 0.433847, 0.697999], "bk" -> 
           RGBColor[0.573624, 0.399845, 0.661808], "cf" -> 
           RGBColor[0.595673, 0.367454, 0.626942], "es" -> 
           RGBColor[0.615633, 0.336672, 0.593404], "fm" -> 
           RGBColor[0.633505, 0.307499, 0.561191], "md" -> 
           RGBColor[0.649288, 0.279937, 0.530305], "no" -> 
           RGBColor[0.662982, 0.253984, 0.500746], "lr" -> 
           RGBColor[0.674588, 0.22964, 0.472513], "rf" -> 
           RGBColor[0.684106, 0.206907, 0.445606], "db" -> 
           RGBColor[0.691534, 0.185783, 0.420025], "sg" -> 
           RGBColor[0.696874, 0.166269, 0.395772], "bh" -> 
           RGBColor[0.700126, 0.148365, 0.372844], "hs" -> 
           RGBColor[0.701289, 0.13207, 0.351243], "mt" -> 
           RGBColor[0.700363, 0.117385, 0.330968], "ds" -> 
           RGBColor[0.697348, 0.10431, 0.31202], "rg" -> 
           RGBColor[0.692245, 0.0928444, 0.294398], "cn" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "nh" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "fl" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "mc" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "lv" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "ts" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "og" -> 
           RGBColor[0.635401, 0.0528, 0.226184], "uub" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "uut" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "uuq" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "uup" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "uuh" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "uus" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "uuo" -> 
           RGBColor[0.635401, 0.0528, 0.226184]}]]& ][0.85], 
       ColorDataFunction[
       "Atoms", 
        "Named", {{
         "H", "He", "Li", "Be", "B", "C", "N", "O", "F", "Ne", "Na", "Mg", 
          "Al", "Si", "P", "S", "Cl", "Ar", "K", "Ca", "Sc", "Ti", "V", "Cr", 
          "Mn", "Fe", "Co", "Ni", "Cu", "Zn", "Ga", "Ge", "As", "Se", "Br", 
          "Kr", "Rb", "Sr", "Y", "Zr", "Nb", "Mo", "Tc", "Ru", "Rh", "Pd", 
          "Ag", "Cd", "In", "Sn", "Sb", "Te", "I", "Xe", "Cs", "Ba", "La", 
          "Ce", "Pr", "Nd", "Pm", "Sm", "Eu", "Gd", "Tb", "Dy", "Ho", "Er", 
          "Tm", "Yb", "Lu", "Hf", "Ta", "W", "Re", "Os", "Ir", "Pt", "Au", 
          "Hg", "Tl", "Pb", "Bi", "Po", "At", "Rn", "Fr", "Ra", "Ac", "Th", 
          "Pa", "U", "Np", "Pu", "Am", "Cm", "Bk", "Cf", "Es", "Fm", "Md", 
          "No", "Lr", "Rf", "Db", "Sg", "Bh", "Hs", "Mt", "Ds", "Rg", "Cn", 
          "Nh", "Fl", "Mc", "Lv", "Ts", "Og", "Uub", "Uut", "Uuq", "Uup", 
          "Uuh", "Uus", "Uuo"}, {
         "h", "he", "li", "be", "b", "c", "n", "o", "f", "ne", "na", "mg", 
          "al", "si", "p", "s", "cl", "ar", "k", "ca", "sc", "ti", "v", "cr", 
          "mn", "fe", "co", "ni", "cu", "zn", "ga", "ge", "as", "se", "br", 
          "kr", "rb", "sr", "y", "zr", "nb", "mo", "tc", "ru", "rh", "pd", 
          "ag", "cd", "in", "sn", "sb", "te", "i", "xe", "cs", "ba", "la", 
          "ce", "pr", "nd", "pm", "sm", "eu", "gd", "tb", "dy", "ho", "er", 
          "tm", "yb", "lu", "hf", "ta", "w", "re", "os", "ir", "pt", "au", 
          "hg", "tl", "pb", "bi", "po", "at", "rn", "fr", "ra", "ac", "th", 
          "pa", "u", "np", "pu", "am", "cm", "bk", "cf", "es", "fm", "md", 
          "no", "lr", "rf", "db", "sg", "bh", "hs", "mt", "ds", "rg", "cn", 
          "nh", "fl", "mc", "lv", "ts", "og", "uub", "uut", "uuq", "uup", 
          "uuh", "uus", "uuo"}}, Replace[#, 
         Dispatch[{
          "h" -> RGBColor[0.65, 0.7, 0.7], "he" -> RGBColor[0.836713, 1., 1.],
            "li" -> RGBColor[0.799435, 0.543572, 0.997559], "be" -> 
           RGBColor[0.770565, 0.964309, 0.0442359], "b" -> 
           RGBColor[1., 0.709804, 0.709804], "c" -> RGBColor[0.4, 0.4, 0.4], 
           "n" -> RGBColor[0.291989, 0.437977, 0.888609], "o" -> 
           RGBColor[0.800498, 0.201504, 0.192061], "f" -> 
           RGBColor[0.578462, 0.85539, 0.408855], "ne" -> 
           RGBColor[0.677263, 0.928423, 0.955287], "na" -> 
           RGBColor[0.658708, 0.492173, 0.842842], "mg" -> 
           RGBColor[0.628274, 0.850553, 0.0782731], "al" -> 
           RGBColor[0.8913, 0.631904, 0.627399], "si" -> 
           RGBColor[0.941176, 0.784314, 0.627451], "p" -> 
           RGBColor[1., 0.501961, 0], "s" -> 
           RGBColor[0.90443, 0.97015, 0.13504], "cl" -> 
           RGBColor[0.412698, 0.932689, 0.166398], "ar" -> 
           RGBColor[0.546138, 0.844244, 0.892092], "k" -> 
           RGBColor[0.534026, 0.420729, 0.705621], "ca" -> 
           RGBColor[0.480072, 0.744591, 0.0955222], "sc" -> 
           RGBColor[0.901961, 0.901961, 0.901961], "ti" -> 
           RGBColor[0.74902, 0.760784, 0.780392], "v" -> 
           RGBColor[0.65098, 0.65098, 0.670588], "cr" -> 
           RGBColor[0.541176, 0.6, 0.780392], "mn" -> 
           RGBColor[0.611765, 0.478431, 0.780392], "fe" -> 
           RGBColor[0.878431, 0.4, 0.2], "co" -> 
           RGBColor[0.941176, 0.564706, 0.627451], "ni" -> 
           RGBColor[0.313725, 0.815686, 0.313725], "cu" -> 
           RGBColor[0.784314, 0.501961, 0.2], "zn" -> 
           RGBColor[0.490196, 0.501961, 0.690196], "ga" -> 
           RGBColor[0.800757, 0.542666, 0.533513], "ge" -> 
           RGBColor[0.60508, 0.632465, 0.576489], "as" -> 
           RGBColor[0.741176, 0.501961, 0.890196], "se" -> 
           RGBColor[0.917248, 0.657833, 0.0706628], "br" -> 
           RGBColor[0.58847, 0.22163, 0.16064], "kr" -> 
           RGBColor[0.426019, 0.747462, 0.810413], "rb" -> 
           RGBColor[0.425391, 0.329242, 0.585895], "sr" -> 
           RGBColor[0.325959, 0.646423, 0.095983], "y" -> 
           RGBColor[0.531014, 1., 1.], "zr" -> 
           RGBColor[0.458599, 0.917466, 0.918573], "nb" -> 
           RGBColor[0.385036, 0.834854, 0.841681], "mo" -> 
           RGBColor[0.310325, 0.752163, 0.769323], "tc" -> 
           RGBColor[0.234466, 0.669394, 0.701499], "ru" -> 
           RGBColor[0.157459, 0.586546, 0.638209], "rh" -> 
           RGBColor[0.0793033, 0.50362, 0.579453], "pd" -> 
           RGBColor[0., 0.420615, 0.525231], "ag" -> 
           RGBColor[0.752941, 0.752941, 0.752941], "cd" -> 
           RGBColor[1., 0.85098, 0.560784], "in" -> 
           RGBColor[0.728371, 0.440594, 0.422196], "sn" -> 
           RGBColor[0.39799, 0.491477, 0.495586], "sb" -> 
           RGBColor[0.619608, 0.388235, 0.709804], "te" -> 
           RGBColor[0.816706, 0.451332, 0.0100947], "i" -> 
           RGBColor[0.580392, 0, 0.580392], "xe" -> 
           RGBColor[0.316906, 0.638078, 0.710252], "cs" -> 
           RGBColor[0.332803, 0.217712, 0.483666], "ba" -> 
           RGBColor[0.165935, 0.55605, 0.0796556], "la" -> 
           RGBColor[0.928084, 0.716075, 0.329427], "ce" -> 
           RGBColor[0.894824, 0.731424, 0.325131], "pr" -> 
           RGBColor[0.86523, 0.707999, 0.315261], "nd" -> 
           RGBColor[0.837836, 0.662974, 0.301635], "pm" -> 
           RGBColor[0.811992, 0.607859, 0.285626], "sm" -> 
           RGBColor[0.787563, 0.549894, 0.268279], "eu" -> 
           RGBColor[0.764628, 0.493261, 0.250405], "gd" -> 
           RGBColor[0.743177, 0.440115, 0.23269], "tb" -> 
           RGBColor[0.72281, 0.39143, 0.215783], "dy" -> 
           RGBColor[0.702434, 0.347663, 0.200392], "ho" -> 
           RGBColor[0.679962, 0.309234, 0.187368], "er" -> 
           RGBColor[0.652012, 0.276823, 0.17779], "tm" -> 
           RGBColor[0.613603, 0.251489, 0.173042], "yb" -> 
           RGBColor[0.557855, 0.234598, 0.17489], "lu" -> 
           RGBColor[0.475685, 0.227573, 0.18555], "hf" -> 
           RGBColor[0.781537, 0.717388, 0.716579], "ta" -> 
           RGBColor[0.734443, 0.544489, 0.683471], "w" -> 
           RGBColor[0.681179, 0.360409, 0.63675], "re" -> 
           RGBColor[0.605181, 0.367584, 0.556343], "os" -> 
           RGBColor[0.521806, 0.382125, 0.469204], "ir" -> 
           RGBColor[0.445624, 0.373159, 0.399069], "pt" -> 
           RGBColor[0.815686, 0.815686, 0.878431], "au" -> 
           RGBColor[1., 0.819608, 0.137255], "hg" -> 
           RGBColor[0.721569, 0.721569, 0.815686], "tl" -> 
           RGBColor[0.65098, 0.329412, 0.301961], "pb" -> 
           RGBColor[0.341176, 0.34902, 0.380392], "bi" -> 
           RGBColor[0.619608, 0.309804, 0.709804], "po" -> 
           RGBColor[0.670588, 0.360784, 0], "at" -> 
           RGBColor[0.458824, 0.309804, 0.270588], "rn" -> 
           RGBColor[0.218799, 0.516091, 0.591608], "fr" -> 
           RGBColor[0.25626, 0.0861372, 0.398932], "ra" -> 
           RGBColor[0., 0.473472, 0.04654], "ac" -> 
           RGBColor[0.322042, 0.71693, 0.988479], "th" -> 
           RGBColor[0.3608, 0.67166, 0.943003], "pa" -> 
           RGBColor[0.397469, 0.628, 0.898853], "u" -> 
           RGBColor[0.43205, 0.58595, 0.856029], "np" -> 
           RGBColor[0.464542, 0.54551, 0.814532], "pu" -> 
           RGBColor[0.494945, 0.506679, 0.774361], "am" -> 
           RGBColor[0.52326, 0.469458, 0.735517], "cm" -> 
           RGBColor[0.549486, 0.433847, 0.697999], "bk" -> 
           RGBColor[0.573624, 0.399845, 0.661808], "cf" -> 
           RGBColor[0.595673, 0.367454, 0.626942], "es" -> 
           RGBColor[0.615633, 0.336672, 0.593404], "fm" -> 
           RGBColor[0.633505, 0.307499, 0.561191], "md" -> 
           RGBColor[0.649288, 0.279937, 0.530305], "no" -> 
           RGBColor[0.662982, 0.253984, 0.500746], "lr" -> 
           RGBColor[0.674588, 0.22964, 0.472513], "rf" -> 
           RGBColor[0.684106, 0.206907, 0.445606], "db" -> 
           RGBColor[0.691534, 0.185783, 0.420025], "sg" -> 
           RGBColor[0.696874, 0.166269, 0.395772], "bh" -> 
           RGBColor[0.700126, 0.148365, 0.372844], "hs" -> 
           RGBColor[0.701289, 0.13207, 0.351243], "mt" -> 
           RGBColor[0.700363, 0.117385, 0.330968], "ds" -> 
           RGBColor[0.697348, 0.10431, 0.31202], "rg" -> 
           RGBColor[0.692245, 0.0928444, 0.294398], "cn" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "nh" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "fl" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "mc" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "lv" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "ts" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "og" -> 
           RGBColor[0.635401, 0.0528, 0.226184], "uub" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "uut" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "uuq" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "uup" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "uuh" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "uus" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "uuo" -> 
           RGBColor[0.635401, 0.0528, 0.226184]}]]& ][0.85], 
       ColorDataFunction[
       "Atoms", 
        "Named", {{
         "H", "He", "Li", "Be", "B", "C", "N", "O", "F", "Ne", "Na", "Mg", 
          "Al", "Si", "P", "S", "Cl", "Ar", "K", "Ca", "Sc", "Ti", "V", "Cr", 
          "Mn", "Fe", "Co", "Ni", "Cu", "Zn", "Ga", "Ge", "As", "Se", "Br", 
          "Kr", "Rb", "Sr", "Y", "Zr", "Nb", "Mo", "Tc", "Ru", "Rh", "Pd", 
          "Ag", "Cd", "In", "Sn", "Sb", "Te", "I", "Xe", "Cs", "Ba", "La", 
          "Ce", "Pr", "Nd", "Pm", "Sm", "Eu", "Gd", "Tb", "Dy", "Ho", "Er", 
          "Tm", "Yb", "Lu", "Hf", "Ta", "W", "Re", "Os", "Ir", "Pt", "Au", 
          "Hg", "Tl", "Pb", "Bi", "Po", "At", "Rn", "Fr", "Ra", "Ac", "Th", 
          "Pa", "U", "Np", "Pu", "Am", "Cm", "Bk", "Cf", "Es", "Fm", "Md", 
          "No", "Lr", "Rf", "Db", "Sg", "Bh", "Hs", "Mt", "Ds", "Rg", "Cn", 
          "Nh", "Fl", "Mc", "Lv", "Ts", "Og", "Uub", "Uut", "Uuq", "Uup", 
          "Uuh", "Uus", "Uuo"}, {
         "h", "he", "li", "be", "b", "c", "n", "o", "f", "ne", "na", "mg", 
          "al", "si", "p", "s", "cl", "ar", "k", "ca", "sc", "ti", "v", "cr", 
          "mn", "fe", "co", "ni", "cu", "zn", "ga", "ge", "as", "se", "br", 
          "kr", "rb", "sr", "y", "zr", "nb", "mo", "tc", "ru", "rh", "pd", 
          "ag", "cd", "in", "sn", "sb", "te", "i", "xe", "cs", "ba", "la", 
          "ce", "pr", "nd", "pm", "sm", "eu", "gd", "tb", "dy", "ho", "er", 
          "tm", "yb", "lu", "hf", "ta", "w", "re", "os", "ir", "pt", "au", 
          "hg", "tl", "pb", "bi", "po", "at", "rn", "fr", "ra", "ac", "th", 
          "pa", "u", "np", "pu", "am", "cm", "bk", "cf", "es", "fm", "md", 
          "no", "lr", "rf", "db", "sg", "bh", "hs", "mt", "ds", "rg", "cn", 
          "nh", "fl", "mc", "lv", "ts", "og", "uub", "uut", "uuq", "uup", 
          "uuh", "uus", "uuo"}}, Replace[#, 
         Dispatch[{
          "h" -> RGBColor[0.65, 0.7, 0.7], "he" -> RGBColor[0.836713, 1., 1.],
            "li" -> RGBColor[0.799435, 0.543572, 0.997559], "be" -> 
           RGBColor[0.770565, 0.964309, 0.0442359], "b" -> 
           RGBColor[1., 0.709804, 0.709804], "c" -> RGBColor[0.4, 0.4, 0.4], 
           "n" -> RGBColor[0.291989, 0.437977, 0.888609], "o" -> 
           RGBColor[0.800498, 0.201504, 0.192061], "f" -> 
           RGBColor[0.578462, 0.85539, 0.408855], "ne" -> 
           RGBColor[0.677263, 0.928423, 0.955287], "na" -> 
           RGBColor[0.658708, 0.492173, 0.842842], "mg" -> 
           RGBColor[0.628274, 0.850553, 0.0782731], "al" -> 
           RGBColor[0.8913, 0.631904, 0.627399], "si" -> 
           RGBColor[0.941176, 0.784314, 0.627451], "p" -> 
           RGBColor[1., 0.501961, 0], "s" -> 
           RGBColor[0.90443, 0.97015, 0.13504], "cl" -> 
           RGBColor[0.412698, 0.932689, 0.166398], "ar" -> 
           RGBColor[0.546138, 0.844244, 0.892092], "k" -> 
           RGBColor[0.534026, 0.420729, 0.705621], "ca" -> 
           RGBColor[0.480072, 0.744591, 0.0955222], "sc" -> 
           RGBColor[0.901961, 0.901961, 0.901961], "ti" -> 
           RGBColor[0.74902, 0.760784, 0.780392], "v" -> 
           RGBColor[0.65098, 0.65098, 0.670588], "cr" -> 
           RGBColor[0.541176, 0.6, 0.780392], "mn" -> 
           RGBColor[0.611765, 0.478431, 0.780392], "fe" -> 
           RGBColor[0.878431, 0.4, 0.2], "co" -> 
           RGBColor[0.941176, 0.564706, 0.627451], "ni" -> 
           RGBColor[0.313725, 0.815686, 0.313725], "cu" -> 
           RGBColor[0.784314, 0.501961, 0.2], "zn" -> 
           RGBColor[0.490196, 0.501961, 0.690196], "ga" -> 
           RGBColor[0.800757, 0.542666, 0.533513], "ge" -> 
           RGBColor[0.60508, 0.632465, 0.576489], "as" -> 
           RGBColor[0.741176, 0.501961, 0.890196], "se" -> 
           RGBColor[0.917248, 0.657833, 0.0706628], "br" -> 
           RGBColor[0.58847, 0.22163, 0.16064], "kr" -> 
           RGBColor[0.426019, 0.747462, 0.810413], "rb" -> 
           RGBColor[0.425391, 0.329242, 0.585895], "sr" -> 
           RGBColor[0.325959, 0.646423, 0.095983], "y" -> 
           RGBColor[0.531014, 1., 1.], "zr" -> 
           RGBColor[0.458599, 0.917466, 0.918573], "nb" -> 
           RGBColor[0.385036, 0.834854, 0.841681], "mo" -> 
           RGBColor[0.310325, 0.752163, 0.769323], "tc" -> 
           RGBColor[0.234466, 0.669394, 0.701499], "ru" -> 
           RGBColor[0.157459, 0.586546, 0.638209], "rh" -> 
           RGBColor[0.0793033, 0.50362, 0.579453], "pd" -> 
           RGBColor[0., 0.420615, 0.525231], "ag" -> 
           RGBColor[0.752941, 0.752941, 0.752941], "cd" -> 
           RGBColor[1., 0.85098, 0.560784], "in" -> 
           RGBColor[0.728371, 0.440594, 0.422196], "sn" -> 
           RGBColor[0.39799, 0.491477, 0.495586], "sb" -> 
           RGBColor[0.619608, 0.388235, 0.709804], "te" -> 
           RGBColor[0.816706, 0.451332, 0.0100947], "i" -> 
           RGBColor[0.580392, 0, 0.580392], "xe" -> 
           RGBColor[0.316906, 0.638078, 0.710252], "cs" -> 
           RGBColor[0.332803, 0.217712, 0.483666], "ba" -> 
           RGBColor[0.165935, 0.55605, 0.0796556], "la" -> 
           RGBColor[0.928084, 0.716075, 0.329427], "ce" -> 
           RGBColor[0.894824, 0.731424, 0.325131], "pr" -> 
           RGBColor[0.86523, 0.707999, 0.315261], "nd" -> 
           RGBColor[0.837836, 0.662974, 0.301635], "pm" -> 
           RGBColor[0.811992, 0.607859, 0.285626], "sm" -> 
           RGBColor[0.787563, 0.549894, 0.268279], "eu" -> 
           RGBColor[0.764628, 0.493261, 0.250405], "gd" -> 
           RGBColor[0.743177, 0.440115, 0.23269], "tb" -> 
           RGBColor[0.72281, 0.39143, 0.215783], "dy" -> 
           RGBColor[0.702434, 0.347663, 0.200392], "ho" -> 
           RGBColor[0.679962, 0.309234, 0.187368], "er" -> 
           RGBColor[0.652012, 0.276823, 0.17779], "tm" -> 
           RGBColor[0.613603, 0.251489, 0.173042], "yb" -> 
           RGBColor[0.557855, 0.234598, 0.17489], "lu" -> 
           RGBColor[0.475685, 0.227573, 0.18555], "hf" -> 
           RGBColor[0.781537, 0.717388, 0.716579], "ta" -> 
           RGBColor[0.734443, 0.544489, 0.683471], "w" -> 
           RGBColor[0.681179, 0.360409, 0.63675], "re" -> 
           RGBColor[0.605181, 0.367584, 0.556343], "os" -> 
           RGBColor[0.521806, 0.382125, 0.469204], "ir" -> 
           RGBColor[0.445624, 0.373159, 0.399069], "pt" -> 
           RGBColor[0.815686, 0.815686, 0.878431], "au" -> 
           RGBColor[1., 0.819608, 0.137255], "hg" -> 
           RGBColor[0.721569, 0.721569, 0.815686], "tl" -> 
           RGBColor[0.65098, 0.329412, 0.301961], "pb" -> 
           RGBColor[0.341176, 0.34902, 0.380392], "bi" -> 
           RGBColor[0.619608, 0.309804, 0.709804], "po" -> 
           RGBColor[0.670588, 0.360784, 0], "at" -> 
           RGBColor[0.458824, 0.309804, 0.270588], "rn" -> 
           RGBColor[0.218799, 0.516091, 0.591608], "fr" -> 
           RGBColor[0.25626, 0.0861372, 0.398932], "ra" -> 
           RGBColor[0., 0.473472, 0.04654], "ac" -> 
           RGBColor[0.322042, 0.71693, 0.988479], "th" -> 
           RGBColor[0.3608, 0.67166, 0.943003], "pa" -> 
           RGBColor[0.397469, 0.628, 0.898853], "u" -> 
           RGBColor[0.43205, 0.58595, 0.856029], "np" -> 
           RGBColor[0.464542, 0.54551, 0.814532], "pu" -> 
           RGBColor[0.494945, 0.506679, 0.774361], "am" -> 
           RGBColor[0.52326, 0.469458, 0.735517], "cm" -> 
           RGBColor[0.549486, 0.433847, 0.697999], "bk" -> 
           RGBColor[0.573624, 0.399845, 0.661808], "cf" -> 
           RGBColor[0.595673, 0.367454, 0.626942], "es" -> 
           RGBColor[0.615633, 0.336672, 0.593404], "fm" -> 
           RGBColor[0.633505, 0.307499, 0.561191], "md" -> 
           RGBColor[0.649288, 0.279937, 0.530305], "no" -> 
           RGBColor[0.662982, 0.253984, 0.500746], "lr" -> 
           RGBColor[0.674588, 0.22964, 0.472513], "rf" -> 
           RGBColor[0.684106, 0.206907, 0.445606], "db" -> 
           RGBColor[0.691534, 0.185783, 0.420025], "sg" -> 
           RGBColor[0.696874, 0.166269, 0.395772], "bh" -> 
           RGBColor[0.700126, 0.148365, 0.372844], "hs" -> 
           RGBColor[0.701289, 0.13207, 0.351243], "mt" -> 
           RGBColor[0.700363, 0.117385, 0.330968], "ds" -> 
           RGBColor[0.697348, 0.10431, 0.31202], "rg" -> 
           RGBColor[0.692245, 0.0928444, 0.294398], "cn" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "nh" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "fl" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "mc" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "lv" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "ts" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "og" -> 
           RGBColor[0.635401, 0.0528, 0.226184], "uub" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "uut" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "uuq" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "uup" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "uuh" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "uus" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "uuo" -> 
           RGBColor[0.635401, 0.0528, 0.226184]}]]& ][0.85], 
       ColorDataFunction[
       "Atoms", 
        "Named", {{
         "H", "He", "Li", "Be", "B", "C", "N", "O", "F", "Ne", "Na", "Mg", 
          "Al", "Si", "P", "S", "Cl", "Ar", "K", "Ca", "Sc", "Ti", "V", "Cr", 
          "Mn", "Fe", "Co", "Ni", "Cu", "Zn", "Ga", "Ge", "As", "Se", "Br", 
          "Kr", "Rb", "Sr", "Y", "Zr", "Nb", "Mo", "Tc", "Ru", "Rh", "Pd", 
          "Ag", "Cd", "In", "Sn", "Sb", "Te", "I", "Xe", "Cs", "Ba", "La", 
          "Ce", "Pr", "Nd", "Pm", "Sm", "Eu", "Gd", "Tb", "Dy", "Ho", "Er", 
          "Tm", "Yb", "Lu", "Hf", "Ta", "W", "Re", "Os", "Ir", "Pt", "Au", 
          "Hg", "Tl", "Pb", "Bi", "Po", "At", "Rn", "Fr", "Ra", "Ac", "Th", 
          "Pa", "U", "Np", "Pu", "Am", "Cm", "Bk", "Cf", "Es", "Fm", "Md", 
          "No", "Lr", "Rf", "Db", "Sg", "Bh", "Hs", "Mt", "Ds", "Rg", "Cn", 
          "Nh", "Fl", "Mc", "Lv", "Ts", "Og", "Uub", "Uut", "Uuq", "Uup", 
          "Uuh", "Uus", "Uuo"}, {
         "h", "he", "li", "be", "b", "c", "n", "o", "f", "ne", "na", "mg", 
          "al", "si", "p", "s", "cl", "ar", "k", "ca", "sc", "ti", "v", "cr", 
          "mn", "fe", "co", "ni", "cu", "zn", "ga", "ge", "as", "se", "br", 
          "kr", "rb", "sr", "y", "zr", "nb", "mo", "tc", "ru", "rh", "pd", 
          "ag", "cd", "in", "sn", "sb", "te", "i", "xe", "cs", "ba", "la", 
          "ce", "pr", "nd", "pm", "sm", "eu", "gd", "tb", "dy", "ho", "er", 
          "tm", "yb", "lu", "hf", "ta", "w", "re", "os", "ir", "pt", "au", 
          "hg", "tl", "pb", "bi", "po", "at", "rn", "fr", "ra", "ac", "th", 
          "pa", "u", "np", "pu", "am", "cm", "bk", "cf", "es", "fm", "md", 
          "no", "lr", "rf", "db", "sg", "bh", "hs", "mt", "ds", "rg", "cn", 
          "nh", "fl", "mc", "lv", "ts", "og", "uub", "uut", "uuq", "uup", 
          "uuh", "uus", "uuo"}}, Replace[#, 
         Dispatch[{
          "h" -> RGBColor[0.65, 0.7, 0.7], "he" -> RGBColor[0.836713, 1., 1.],
            "li" -> RGBColor[0.799435, 0.543572, 0.997559], "be" -> 
           RGBColor[0.770565, 0.964309, 0.0442359], "b" -> 
           RGBColor[1., 0.709804, 0.709804], "c" -> RGBColor[0.4, 0.4, 0.4], 
           "n" -> RGBColor[0.291989, 0.437977, 0.888609], "o" -> 
           RGBColor[0.800498, 0.201504, 0.192061], "f" -> 
           RGBColor[0.578462, 0.85539, 0.408855], "ne" -> 
           RGBColor[0.677263, 0.928423, 0.955287], "na" -> 
           RGBColor[0.658708, 0.492173, 0.842842], "mg" -> 
           RGBColor[0.628274, 0.850553, 0.0782731], "al" -> 
           RGBColor[0.8913, 0.631904, 0.627399], "si" -> 
           RGBColor[0.941176, 0.784314, 0.627451], "p" -> 
           RGBColor[1., 0.501961, 0], "s" -> 
           RGBColor[0.90443, 0.97015, 0.13504], "cl" -> 
           RGBColor[0.412698, 0.932689, 0.166398], "ar" -> 
           RGBColor[0.546138, 0.844244, 0.892092], "k" -> 
           RGBColor[0.534026, 0.420729, 0.705621], "ca" -> 
           RGBColor[0.480072, 0.744591, 0.0955222], "sc" -> 
           RGBColor[0.901961, 0.901961, 0.901961], "ti" -> 
           RGBColor[0.74902, 0.760784, 0.780392], "v" -> 
           RGBColor[0.65098, 0.65098, 0.670588], "cr" -> 
           RGBColor[0.541176, 0.6, 0.780392], "mn" -> 
           RGBColor[0.611765, 0.478431, 0.780392], "fe" -> 
           RGBColor[0.878431, 0.4, 0.2], "co" -> 
           RGBColor[0.941176, 0.564706, 0.627451], "ni" -> 
           RGBColor[0.313725, 0.815686, 0.313725], "cu" -> 
           RGBColor[0.784314, 0.501961, 0.2], "zn" -> 
           RGBColor[0.490196, 0.501961, 0.690196], "ga" -> 
           RGBColor[0.800757, 0.542666, 0.533513], "ge" -> 
           RGBColor[0.60508, 0.632465, 0.576489], "as" -> 
           RGBColor[0.741176, 0.501961, 0.890196], "se" -> 
           RGBColor[0.917248, 0.657833, 0.0706628], "br" -> 
           RGBColor[0.58847, 0.22163, 0.16064], "kr" -> 
           RGBColor[0.426019, 0.747462, 0.810413], "rb" -> 
           RGBColor[0.425391, 0.329242, 0.585895], "sr" -> 
           RGBColor[0.325959, 0.646423, 0.095983], "y" -> 
           RGBColor[0.531014, 1., 1.], "zr" -> 
           RGBColor[0.458599, 0.917466, 0.918573], "nb" -> 
           RGBColor[0.385036, 0.834854, 0.841681], "mo" -> 
           RGBColor[0.310325, 0.752163, 0.769323], "tc" -> 
           RGBColor[0.234466, 0.669394, 0.701499], "ru" -> 
           RGBColor[0.157459, 0.586546, 0.638209], "rh" -> 
           RGBColor[0.0793033, 0.50362, 0.579453], "pd" -> 
           RGBColor[0., 0.420615, 0.525231], "ag" -> 
           RGBColor[0.752941, 0.752941, 0.752941], "cd" -> 
           RGBColor[1., 0.85098, 0.560784], "in" -> 
           RGBColor[0.728371, 0.440594, 0.422196], "sn" -> 
           RGBColor[0.39799, 0.491477, 0.495586], "sb" -> 
           RGBColor[0.619608, 0.388235, 0.709804], "te" -> 
           RGBColor[0.816706, 0.451332, 0.0100947], "i" -> 
           RGBColor[0.580392, 0, 0.580392], "xe" -> 
           RGBColor[0.316906, 0.638078, 0.710252], "cs" -> 
           RGBColor[0.332803, 0.217712, 0.483666], "ba" -> 
           RGBColor[0.165935, 0.55605, 0.0796556], "la" -> 
           RGBColor[0.928084, 0.716075, 0.329427], "ce" -> 
           RGBColor[0.894824, 0.731424, 0.325131], "pr" -> 
           RGBColor[0.86523, 0.707999, 0.315261], "nd" -> 
           RGBColor[0.837836, 0.662974, 0.301635], "pm" -> 
           RGBColor[0.811992, 0.607859, 0.285626], "sm" -> 
           RGBColor[0.787563, 0.549894, 0.268279], "eu" -> 
           RGBColor[0.764628, 0.493261, 0.250405], "gd" -> 
           RGBColor[0.743177, 0.440115, 0.23269], "tb" -> 
           RGBColor[0.72281, 0.39143, 0.215783], "dy" -> 
           RGBColor[0.702434, 0.347663, 0.200392], "ho" -> 
           RGBColor[0.679962, 0.309234, 0.187368], "er" -> 
           RGBColor[0.652012, 0.276823, 0.17779], "tm" -> 
           RGBColor[0.613603, 0.251489, 0.173042], "yb" -> 
           RGBColor[0.557855, 0.234598, 0.17489], "lu" -> 
           RGBColor[0.475685, 0.227573, 0.18555], "hf" -> 
           RGBColor[0.781537, 0.717388, 0.716579], "ta" -> 
           RGBColor[0.734443, 0.544489, 0.683471], "w" -> 
           RGBColor[0.681179, 0.360409, 0.63675], "re" -> 
           RGBColor[0.605181, 0.367584, 0.556343], "os" -> 
           RGBColor[0.521806, 0.382125, 0.469204], "ir" -> 
           RGBColor[0.445624, 0.373159, 0.399069], "pt" -> 
           RGBColor[0.815686, 0.815686, 0.878431], "au" -> 
           RGBColor[1., 0.819608, 0.137255], "hg" -> 
           RGBColor[0.721569, 0.721569, 0.815686], "tl" -> 
           RGBColor[0.65098, 0.329412, 0.301961], "pb" -> 
           RGBColor[0.341176, 0.34902, 0.380392], "bi" -> 
           RGBColor[0.619608, 0.309804, 0.709804], "po" -> 
           RGBColor[0.670588, 0.360784, 0], "at" -> 
           RGBColor[0.458824, 0.309804, 0.270588], "rn" -> 
           RGBColor[0.218799, 0.516091, 0.591608], "fr" -> 
           RGBColor[0.25626, 0.0861372, 0.398932], "ra" -> 
           RGBColor[0., 0.473472, 0.04654], "ac" -> 
           RGBColor[0.322042, 0.71693, 0.988479], "th" -> 
           RGBColor[0.3608, 0.67166, 0.943003], "pa" -> 
           RGBColor[0.397469, 0.628, 0.898853], "u" -> 
           RGBColor[0.43205, 0.58595, 0.856029], "np" -> 
           RGBColor[0.464542, 0.54551, 0.814532], "pu" -> 
           RGBColor[0.494945, 0.506679, 0.774361], "am" -> 
           RGBColor[0.52326, 0.469458, 0.735517], "cm" -> 
           RGBColor[0.549486, 0.433847, 0.697999], "bk" -> 
           RGBColor[0.573624, 0.399845, 0.661808], "cf" -> 
           RGBColor[0.595673, 0.367454, 0.626942], "es" -> 
           RGBColor[0.615633, 0.336672, 0.593404], "fm" -> 
           RGBColor[0.633505, 0.307499, 0.561191], "md" -> 
           RGBColor[0.649288, 0.279937, 0.530305], "no" -> 
           RGBColor[0.662982, 0.253984, 0.500746], "lr" -> 
           RGBColor[0.674588, 0.22964, 0.472513], "rf" -> 
           RGBColor[0.684106, 0.206907, 0.445606], "db" -> 
           RGBColor[0.691534, 0.185783, 0.420025], "sg" -> 
           RGBColor[0.696874, 0.166269, 0.395772], "bh" -> 
           RGBColor[0.700126, 0.148365, 0.372844], "hs" -> 
           RGBColor[0.701289, 0.13207, 0.351243], "mt" -> 
           RGBColor[0.700363, 0.117385, 0.330968], "ds" -> 
           RGBColor[0.697348, 0.10431, 0.31202], "rg" -> 
           RGBColor[0.692245, 0.0928444, 0.294398], "cn" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "nh" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "fl" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "mc" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "lv" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "ts" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "og" -> 
           RGBColor[0.635401, 0.0528, 0.226184], "uub" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "uut" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "uuq" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "uup" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "uuh" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "uus" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "uuo" -> 
           RGBColor[0.635401, 0.0528, 0.226184]}]]& ][0.85], 
       ColorDataFunction[
       "Atoms", 
        "Named", {{
         "H", "He", "Li", "Be", "B", "C", "N", "O", "F", "Ne", "Na", "Mg", 
          "Al", "Si", "P", "S", "Cl", "Ar", "K", "Ca", "Sc", "Ti", "V", "Cr", 
          "Mn", "Fe", "Co", "Ni", "Cu", "Zn", "Ga", "Ge", "As", "Se", "Br", 
          "Kr", "Rb", "Sr", "Y", "Zr", "Nb", "Mo", "Tc", "Ru", "Rh", "Pd", 
          "Ag", "Cd", "In", "Sn", "Sb", "Te", "I", "Xe", "Cs", "Ba", "La", 
          "Ce", "Pr", "Nd", "Pm", "Sm", "Eu", "Gd", "Tb", "Dy", "Ho", "Er", 
          "Tm", "Yb", "Lu", "Hf", "Ta", "W", "Re", "Os", "Ir", "Pt", "Au", 
          "Hg", "Tl", "Pb", "Bi", "Po", "At", "Rn", "Fr", "Ra", "Ac", "Th", 
          "Pa", "U", "Np", "Pu", "Am", "Cm", "Bk", "Cf", "Es", "Fm", "Md", 
          "No", "Lr", "Rf", "Db", "Sg", "Bh", "Hs", "Mt", "Ds", "Rg", "Cn", 
          "Nh", "Fl", "Mc", "Lv", "Ts", "Og", "Uub", "Uut", "Uuq", "Uup", 
          "Uuh", "Uus", "Uuo"}, {
         "h", "he", "li", "be", "b", "c", "n", "o", "f", "ne", "na", "mg", 
          "al", "si", "p", "s", "cl", "ar", "k", "ca", "sc", "ti", "v", "cr", 
          "mn", "fe", "co", "ni", "cu", "zn", "ga", "ge", "as", "se", "br", 
          "kr", "rb", "sr", "y", "zr", "nb", "mo", "tc", "ru", "rh", "pd", 
          "ag", "cd", "in", "sn", "sb", "te", "i", "xe", "cs", "ba", "la", 
          "ce", "pr", "nd", "pm", "sm", "eu", "gd", "tb", "dy", "ho", "er", 
          "tm", "yb", "lu", "hf", "ta", "w", "re", "os", "ir", "pt", "au", 
          "hg", "tl", "pb", "bi", "po", "at", "rn", "fr", "ra", "ac", "th", 
          "pa", "u", "np", "pu", "am", "cm", "bk", "cf", "es", "fm", "md", 
          "no", "lr", "rf", "db", "sg", "bh", "hs", "mt", "ds", "rg", "cn", 
          "nh", "fl", "mc", "lv", "ts", "og", "uub", "uut", "uuq", "uup", 
          "uuh", "uus", "uuo"}}, Replace[#, 
         Dispatch[{
          "h" -> RGBColor[0.65, 0.7, 0.7], "he" -> RGBColor[0.836713, 1., 1.],
            "li" -> RGBColor[0.799435, 0.543572, 0.997559], "be" -> 
           RGBColor[0.770565, 0.964309, 0.0442359], "b" -> 
           RGBColor[1., 0.709804, 0.709804], "c" -> RGBColor[0.4, 0.4, 0.4], 
           "n" -> RGBColor[0.291989, 0.437977, 0.888609], "o" -> 
           RGBColor[0.800498, 0.201504, 0.192061], "f" -> 
           RGBColor[0.578462, 0.85539, 0.408855], "ne" -> 
           RGBColor[0.677263, 0.928423, 0.955287], "na" -> 
           RGBColor[0.658708, 0.492173, 0.842842], "mg" -> 
           RGBColor[0.628274, 0.850553, 0.0782731], "al" -> 
           RGBColor[0.8913, 0.631904, 0.627399], "si" -> 
           RGBColor[0.941176, 0.784314, 0.627451], "p" -> 
           RGBColor[1., 0.501961, 0], "s" -> 
           RGBColor[0.90443, 0.97015, 0.13504], "cl" -> 
           RGBColor[0.412698, 0.932689, 0.166398], "ar" -> 
           RGBColor[0.546138, 0.844244, 0.892092], "k" -> 
           RGBColor[0.534026, 0.420729, 0.705621], "ca" -> 
           RGBColor[0.480072, 0.744591, 0.0955222], "sc" -> 
           RGBColor[0.901961, 0.901961, 0.901961], "ti" -> 
           RGBColor[0.74902, 0.760784, 0.780392], "v" -> 
           RGBColor[0.65098, 0.65098, 0.670588], "cr" -> 
           RGBColor[0.541176, 0.6, 0.780392], "mn" -> 
           RGBColor[0.611765, 0.478431, 0.780392], "fe" -> 
           RGBColor[0.878431, 0.4, 0.2], "co" -> 
           RGBColor[0.941176, 0.564706, 0.627451], "ni" -> 
           RGBColor[0.313725, 0.815686, 0.313725], "cu" -> 
           RGBColor[0.784314, 0.501961, 0.2], "zn" -> 
           RGBColor[0.490196, 0.501961, 0.690196], "ga" -> 
           RGBColor[0.800757, 0.542666, 0.533513], "ge" -> 
           RGBColor[0.60508, 0.632465, 0.576489], "as" -> 
           RGBColor[0.741176, 0.501961, 0.890196], "se" -> 
           RGBColor[0.917248, 0.657833, 0.0706628], "br" -> 
           RGBColor[0.58847, 0.22163, 0.16064], "kr" -> 
           RGBColor[0.426019, 0.747462, 0.810413], "rb" -> 
           RGBColor[0.425391, 0.329242, 0.585895], "sr" -> 
           RGBColor[0.325959, 0.646423, 0.095983], "y" -> 
           RGBColor[0.531014, 1., 1.], "zr" -> 
           RGBColor[0.458599, 0.917466, 0.918573], "nb" -> 
           RGBColor[0.385036, 0.834854, 0.841681], "mo" -> 
           RGBColor[0.310325, 0.752163, 0.769323], "tc" -> 
           RGBColor[0.234466, 0.669394, 0.701499], "ru" -> 
           RGBColor[0.157459, 0.586546, 0.638209], "rh" -> 
           RGBColor[0.0793033, 0.50362, 0.579453], "pd" -> 
           RGBColor[0., 0.420615, 0.525231], "ag" -> 
           RGBColor[0.752941, 0.752941, 0.752941], "cd" -> 
           RGBColor[1., 0.85098, 0.560784], "in" -> 
           RGBColor[0.728371, 0.440594, 0.422196], "sn" -> 
           RGBColor[0.39799, 0.491477, 0.495586], "sb" -> 
           RGBColor[0.619608, 0.388235, 0.709804], "te" -> 
           RGBColor[0.816706, 0.451332, 0.0100947], "i" -> 
           RGBColor[0.580392, 0, 0.580392], "xe" -> 
           RGBColor[0.316906, 0.638078, 0.710252], "cs" -> 
           RGBColor[0.332803, 0.217712, 0.483666], "ba" -> 
           RGBColor[0.165935, 0.55605, 0.0796556], "la" -> 
           RGBColor[0.928084, 0.716075, 0.329427], "ce" -> 
           RGBColor[0.894824, 0.731424, 0.325131], "pr" -> 
           RGBColor[0.86523, 0.707999, 0.315261], "nd" -> 
           RGBColor[0.837836, 0.662974, 0.301635], "pm" -> 
           RGBColor[0.811992, 0.607859, 0.285626], "sm" -> 
           RGBColor[0.787563, 0.549894, 0.268279], "eu" -> 
           RGBColor[0.764628, 0.493261, 0.250405], "gd" -> 
           RGBColor[0.743177, 0.440115, 0.23269], "tb" -> 
           RGBColor[0.72281, 0.39143, 0.215783], "dy" -> 
           RGBColor[0.702434, 0.347663, 0.200392], "ho" -> 
           RGBColor[0.679962, 0.309234, 0.187368], "er" -> 
           RGBColor[0.652012, 0.276823, 0.17779], "tm" -> 
           RGBColor[0.613603, 0.251489, 0.173042], "yb" -> 
           RGBColor[0.557855, 0.234598, 0.17489], "lu" -> 
           RGBColor[0.475685, 0.227573, 0.18555], "hf" -> 
           RGBColor[0.781537, 0.717388, 0.716579], "ta" -> 
           RGBColor[0.734443, 0.544489, 0.683471], "w" -> 
           RGBColor[0.681179, 0.360409, 0.63675], "re" -> 
           RGBColor[0.605181, 0.367584, 0.556343], "os" -> 
           RGBColor[0.521806, 0.382125, 0.469204], "ir" -> 
           RGBColor[0.445624, 0.373159, 0.399069], "pt" -> 
           RGBColor[0.815686, 0.815686, 0.878431], "au" -> 
           RGBColor[1., 0.819608, 0.137255], "hg" -> 
           RGBColor[0.721569, 0.721569, 0.815686], "tl" -> 
           RGBColor[0.65098, 0.329412, 0.301961], "pb" -> 
           RGBColor[0.341176, 0.34902, 0.380392], "bi" -> 
           RGBColor[0.619608, 0.309804, 0.709804], "po" -> 
           RGBColor[0.670588, 0.360784, 0], "at" -> 
           RGBColor[0.458824, 0.309804, 0.270588], "rn" -> 
           RGBColor[0.218799, 0.516091, 0.591608], "fr" -> 
           RGBColor[0.25626, 0.0861372, 0.398932], "ra" -> 
           RGBColor[0., 0.473472, 0.04654], "ac" -> 
           RGBColor[0.322042, 0.71693, 0.988479], "th" -> 
           RGBColor[0.3608, 0.67166, 0.943003], "pa" -> 
           RGBColor[0.397469, 0.628, 0.898853], "u" -> 
           RGBColor[0.43205, 0.58595, 0.856029], "np" -> 
           RGBColor[0.464542, 0.54551, 0.814532], "pu" -> 
           RGBColor[0.494945, 0.506679, 0.774361], "am" -> 
           RGBColor[0.52326, 0.469458, 0.735517], "cm" -> 
           RGBColor[0.549486, 0.433847, 0.697999], "bk" -> 
           RGBColor[0.573624, 0.399845, 0.661808], "cf" -> 
           RGBColor[0.595673, 0.367454, 0.626942], "es" -> 
           RGBColor[0.615633, 0.336672, 0.593404], "fm" -> 
           RGBColor[0.633505, 0.307499, 0.561191], "md" -> 
           RGBColor[0.649288, 0.279937, 0.530305], "no" -> 
           RGBColor[0.662982, 0.253984, 0.500746], "lr" -> 
           RGBColor[0.674588, 0.22964, 0.472513], "rf" -> 
           RGBColor[0.684106, 0.206907, 0.445606], "db" -> 
           RGBColor[0.691534, 0.185783, 0.420025], "sg" -> 
           RGBColor[0.696874, 0.166269, 0.395772], "bh" -> 
           RGBColor[0.700126, 0.148365, 0.372844], "hs" -> 
           RGBColor[0.701289, 0.13207, 0.351243], "mt" -> 
           RGBColor[0.700363, 0.117385, 0.330968], "ds" -> 
           RGBColor[0.697348, 0.10431, 0.31202], "rg" -> 
           RGBColor[0.692245, 0.0928444, 0.294398], "cn" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "nh" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "fl" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "mc" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "lv" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "ts" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "og" -> 
           RGBColor[0.635401, 0.0528, 0.226184], "uub" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "uut" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "uuq" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "uup" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "uuh" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "uus" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "uuo" -> 
           RGBColor[0.635401, 0.0528, 0.226184]}]]& ][0.85], 
       ColorDataFunction[
       "Atoms", 
        "Named", {{
         "H", "He", "Li", "Be", "B", "C", "N", "O", "F", "Ne", "Na", "Mg", 
          "Al", "Si", "P", "S", "Cl", "Ar", "K", "Ca", "Sc", "Ti", "V", "Cr", 
          "Mn", "Fe", "Co", "Ni", "Cu", "Zn", "Ga", "Ge", "As", "Se", "Br", 
          "Kr", "Rb", "Sr", "Y", "Zr", "Nb", "Mo", "Tc", "Ru", "Rh", "Pd", 
          "Ag", "Cd", "In", "Sn", "Sb", "Te", "I", "Xe", "Cs", "Ba", "La", 
          "Ce", "Pr", "Nd", "Pm", "Sm", "Eu", "Gd", "Tb", "Dy", "Ho", "Er", 
          "Tm", "Yb", "Lu", "Hf", "Ta", "W", "Re", "Os", "Ir", "Pt", "Au", 
          "Hg", "Tl", "Pb", "Bi", "Po", "At", "Rn", "Fr", "Ra", "Ac", "Th", 
          "Pa", "U", "Np", "Pu", "Am", "Cm", "Bk", "Cf", "Es", "Fm", "Md", 
          "No", "Lr", "Rf", "Db", "Sg", "Bh", "Hs", "Mt", "Ds", "Rg", "Cn", 
          "Nh", "Fl", "Mc", "Lv", "Ts", "Og", "Uub", "Uut", "Uuq", "Uup", 
          "Uuh", "Uus", "Uuo"}, {
         "h", "he", "li", "be", "b", "c", "n", "o", "f", "ne", "na", "mg", 
          "al", "si", "p", "s", "cl", "ar", "k", "ca", "sc", "ti", "v", "cr", 
          "mn", "fe", "co", "ni", "cu", "zn", "ga", "ge", "as", "se", "br", 
          "kr", "rb", "sr", "y", "zr", "nb", "mo", "tc", "ru", "rh", "pd", 
          "ag", "cd", "in", "sn", "sb", "te", "i", "xe", "cs", "ba", "la", 
          "ce", "pr", "nd", "pm", "sm", "eu", "gd", "tb", "dy", "ho", "er", 
          "tm", "yb", "lu", "hf", "ta", "w", "re", "os", "ir", "pt", "au", 
          "hg", "tl", "pb", "bi", "po", "at", "rn", "fr", "ra", "ac", "th", 
          "pa", "u", "np", "pu", "am", "cm", "bk", "cf", "es", "fm", "md", 
          "no", "lr", "rf", "db", "sg", "bh", "hs", "mt", "ds", "rg", "cn", 
          "nh", "fl", "mc", "lv", "ts", "og", "uub", "uut", "uuq", "uup", 
          "uuh", "uus", "uuo"}}, Replace[#, 
         Dispatch[{
          "h" -> RGBColor[0.65, 0.7, 0.7], "he" -> RGBColor[0.836713, 1., 1.],
            "li" -> RGBColor[0.799435, 0.543572, 0.997559], "be" -> 
           RGBColor[0.770565, 0.964309, 0.0442359], "b" -> 
           RGBColor[1., 0.709804, 0.709804], "c" -> RGBColor[0.4, 0.4, 0.4], 
           "n" -> RGBColor[0.291989, 0.437977, 0.888609], "o" -> 
           RGBColor[0.800498, 0.201504, 0.192061], "f" -> 
           RGBColor[0.578462, 0.85539, 0.408855], "ne" -> 
           RGBColor[0.677263, 0.928423, 0.955287], "na" -> 
           RGBColor[0.658708, 0.492173, 0.842842], "mg" -> 
           RGBColor[0.628274, 0.850553, 0.0782731], "al" -> 
           RGBColor[0.8913, 0.631904, 0.627399], "si" -> 
           RGBColor[0.941176, 0.784314, 0.627451], "p" -> 
           RGBColor[1., 0.501961, 0], "s" -> 
           RGBColor[0.90443, 0.97015, 0.13504], "cl" -> 
           RGBColor[0.412698, 0.932689, 0.166398], "ar" -> 
           RGBColor[0.546138, 0.844244, 0.892092], "k" -> 
           RGBColor[0.534026, 0.420729, 0.705621], "ca" -> 
           RGBColor[0.480072, 0.744591, 0.0955222], "sc" -> 
           RGBColor[0.901961, 0.901961, 0.901961], "ti" -> 
           RGBColor[0.74902, 0.760784, 0.780392], "v" -> 
           RGBColor[0.65098, 0.65098, 0.670588], "cr" -> 
           RGBColor[0.541176, 0.6, 0.780392], "mn" -> 
           RGBColor[0.611765, 0.478431, 0.780392], "fe" -> 
           RGBColor[0.878431, 0.4, 0.2], "co" -> 
           RGBColor[0.941176, 0.564706, 0.627451], "ni" -> 
           RGBColor[0.313725, 0.815686, 0.313725], "cu" -> 
           RGBColor[0.784314, 0.501961, 0.2], "zn" -> 
           RGBColor[0.490196, 0.501961, 0.690196], "ga" -> 
           RGBColor[0.800757, 0.542666, 0.533513], "ge" -> 
           RGBColor[0.60508, 0.632465, 0.576489], "as" -> 
           RGBColor[0.741176, 0.501961, 0.890196], "se" -> 
           RGBColor[0.917248, 0.657833, 0.0706628], "br" -> 
           RGBColor[0.58847, 0.22163, 0.16064], "kr" -> 
           RGBColor[0.426019, 0.747462, 0.810413], "rb" -> 
           RGBColor[0.425391, 0.329242, 0.585895], "sr" -> 
           RGBColor[0.325959, 0.646423, 0.095983], "y" -> 
           RGBColor[0.531014, 1., 1.], "zr" -> 
           RGBColor[0.458599, 0.917466, 0.918573], "nb" -> 
           RGBColor[0.385036, 0.834854, 0.841681], "mo" -> 
           RGBColor[0.310325, 0.752163, 0.769323], "tc" -> 
           RGBColor[0.234466, 0.669394, 0.701499], "ru" -> 
           RGBColor[0.157459, 0.586546, 0.638209], "rh" -> 
           RGBColor[0.0793033, 0.50362, 0.579453], "pd" -> 
           RGBColor[0., 0.420615, 0.525231], "ag" -> 
           RGBColor[0.752941, 0.752941, 0.752941], "cd" -> 
           RGBColor[1., 0.85098, 0.560784], "in" -> 
           RGBColor[0.728371, 0.440594, 0.422196], "sn" -> 
           RGBColor[0.39799, 0.491477, 0.495586], "sb" -> 
           RGBColor[0.619608, 0.388235, 0.709804], "te" -> 
           RGBColor[0.816706, 0.451332, 0.0100947], "i" -> 
           RGBColor[0.580392, 0, 0.580392], "xe" -> 
           RGBColor[0.316906, 0.638078, 0.710252], "cs" -> 
           RGBColor[0.332803, 0.217712, 0.483666], "ba" -> 
           RGBColor[0.165935, 0.55605, 0.0796556], "la" -> 
           RGBColor[0.928084, 0.716075, 0.329427], "ce" -> 
           RGBColor[0.894824, 0.731424, 0.325131], "pr" -> 
           RGBColor[0.86523, 0.707999, 0.315261], "nd" -> 
           RGBColor[0.837836, 0.662974, 0.301635], "pm" -> 
           RGBColor[0.811992, 0.607859, 0.285626], "sm" -> 
           RGBColor[0.787563, 0.549894, 0.268279], "eu" -> 
           RGBColor[0.764628, 0.493261, 0.250405], "gd" -> 
           RGBColor[0.743177, 0.440115, 0.23269], "tb" -> 
           RGBColor[0.72281, 0.39143, 0.215783], "dy" -> 
           RGBColor[0.702434, 0.347663, 0.200392], "ho" -> 
           RGBColor[0.679962, 0.309234, 0.187368], "er" -> 
           RGBColor[0.652012, 0.276823, 0.17779], "tm" -> 
           RGBColor[0.613603, 0.251489, 0.173042], "yb" -> 
           RGBColor[0.557855, 0.234598, 0.17489], "lu" -> 
           RGBColor[0.475685, 0.227573, 0.18555], "hf" -> 
           RGBColor[0.781537, 0.717388, 0.716579], "ta" -> 
           RGBColor[0.734443, 0.544489, 0.683471], "w" -> 
           RGBColor[0.681179, 0.360409, 0.63675], "re" -> 
           RGBColor[0.605181, 0.367584, 0.556343], "os" -> 
           RGBColor[0.521806, 0.382125, 0.469204], "ir" -> 
           RGBColor[0.445624, 0.373159, 0.399069], "pt" -> 
           RGBColor[0.815686, 0.815686, 0.878431], "au" -> 
           RGBColor[1., 0.819608, 0.137255], "hg" -> 
           RGBColor[0.721569, 0.721569, 0.815686], "tl" -> 
           RGBColor[0.65098, 0.329412, 0.301961], "pb" -> 
           RGBColor[0.341176, 0.34902, 0.380392], "bi" -> 
           RGBColor[0.619608, 0.309804, 0.709804], "po" -> 
           RGBColor[0.670588, 0.360784, 0], "at" -> 
           RGBColor[0.458824, 0.309804, 0.270588], "rn" -> 
           RGBColor[0.218799, 0.516091, 0.591608], "fr" -> 
           RGBColor[0.25626, 0.0861372, 0.398932], "ra" -> 
           RGBColor[0., 0.473472, 0.04654], "ac" -> 
           RGBColor[0.322042, 0.71693, 0.988479], "th" -> 
           RGBColor[0.3608, 0.67166, 0.943003], "pa" -> 
           RGBColor[0.397469, 0.628, 0.898853], "u" -> 
           RGBColor[0.43205, 0.58595, 0.856029], "np" -> 
           RGBColor[0.464542, 0.54551, 0.814532], "pu" -> 
           RGBColor[0.494945, 0.506679, 0.774361], "am" -> 
           RGBColor[0.52326, 0.469458, 0.735517], "cm" -> 
           RGBColor[0.549486, 0.433847, 0.697999], "bk" -> 
           RGBColor[0.573624, 0.399845, 0.661808], "cf" -> 
           RGBColor[0.595673, 0.367454, 0.626942], "es" -> 
           RGBColor[0.615633, 0.336672, 0.593404], "fm" -> 
           RGBColor[0.633505, 0.307499, 0.561191], "md" -> 
           RGBColor[0.649288, 0.279937, 0.530305], "no" -> 
           RGBColor[0.662982, 0.253984, 0.500746], "lr" -> 
           RGBColor[0.674588, 0.22964, 0.472513], "rf" -> 
           RGBColor[0.684106, 0.206907, 0.445606], "db" -> 
           RGBColor[0.691534, 0.185783, 0.420025], "sg" -> 
           RGBColor[0.696874, 0.166269, 0.395772], "bh" -> 
           RGBColor[0.700126, 0.148365, 0.372844], "hs" -> 
           RGBColor[0.701289, 0.13207, 0.351243], "mt" -> 
           RGBColor[0.700363, 0.117385, 0.330968], "ds" -> 
           RGBColor[0.697348, 0.10431, 0.31202], "rg" -> 
           RGBColor[0.692245, 0.0928444, 0.294398], "cn" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "nh" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "fl" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "mc" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "lv" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "ts" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "og" -> 
           RGBColor[0.635401, 0.0528, 0.226184], "uub" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "uut" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "uuq" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "uup" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "uuh" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "uus" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "uuo" -> 
           RGBColor[0.635401, 0.0528, 0.226184]}]]& ][0.85], 
       ColorDataFunction[
       "Atoms", 
        "Named", {{
         "H", "He", "Li", "Be", "B", "C", "N", "O", "F", "Ne", "Na", "Mg", 
          "Al", "Si", "P", "S", "Cl", "Ar", "K", "Ca", "Sc", "Ti", "V", "Cr", 
          "Mn", "Fe", "Co", "Ni", "Cu", "Zn", "Ga", "Ge", "As", "Se", "Br", 
          "Kr", "Rb", "Sr", "Y", "Zr", "Nb", "Mo", "Tc", "Ru", "Rh", "Pd", 
          "Ag", "Cd", "In", "Sn", "Sb", "Te", "I", "Xe", "Cs", "Ba", "La", 
          "Ce", "Pr", "Nd", "Pm", "Sm", "Eu", "Gd", "Tb", "Dy", "Ho", "Er", 
          "Tm", "Yb", "Lu", "Hf", "Ta", "W", "Re", "Os", "Ir", "Pt", "Au", 
          "Hg", "Tl", "Pb", "Bi", "Po", "At", "Rn", "Fr", "Ra", "Ac", "Th", 
          "Pa", "U", "Np", "Pu", "Am", "Cm", "Bk", "Cf", "Es", "Fm", "Md", 
          "No", "Lr", "Rf", "Db", "Sg", "Bh", "Hs", "Mt", "Ds", "Rg", "Cn", 
          "Nh", "Fl", "Mc", "Lv", "Ts", "Og", "Uub", "Uut", "Uuq", "Uup", 
          "Uuh", "Uus", "Uuo"}, {
         "h", "he", "li", "be", "b", "c", "n", "o", "f", "ne", "na", "mg", 
          "al", "si", "p", "s", "cl", "ar", "k", "ca", "sc", "ti", "v", "cr", 
          "mn", "fe", "co", "ni", "cu", "zn", "ga", "ge", "as", "se", "br", 
          "kr", "rb", "sr", "y", "zr", "nb", "mo", "tc", "ru", "rh", "pd", 
          "ag", "cd", "in", "sn", "sb", "te", "i", "xe", "cs", "ba", "la", 
          "ce", "pr", "nd", "pm", "sm", "eu", "gd", "tb", "dy", "ho", "er", 
          "tm", "yb", "lu", "hf", "ta", "w", "re", "os", "ir", "pt", "au", 
          "hg", "tl", "pb", "bi", "po", "at", "rn", "fr", "ra", "ac", "th", 
          "pa", "u", "np", "pu", "am", "cm", "bk", "cf", "es", "fm", "md", 
          "no", "lr", "rf", "db", "sg", "bh", "hs", "mt", "ds", "rg", "cn", 
          "nh", "fl", "mc", "lv", "ts", "og", "uub", "uut", "uuq", "uup", 
          "uuh", "uus", "uuo"}}, Replace[#, 
         Dispatch[{
          "h" -> RGBColor[0.65, 0.7, 0.7], "he" -> RGBColor[0.836713, 1., 1.],
            "li" -> RGBColor[0.799435, 0.543572, 0.997559], "be" -> 
           RGBColor[0.770565, 0.964309, 0.0442359], "b" -> 
           RGBColor[1., 0.709804, 0.709804], "c" -> RGBColor[0.4, 0.4, 0.4], 
           "n" -> RGBColor[0.291989, 0.437977, 0.888609], "o" -> 
           RGBColor[0.800498, 0.201504, 0.192061], "f" -> 
           RGBColor[0.578462, 0.85539, 0.408855], "ne" -> 
           RGBColor[0.677263, 0.928423, 0.955287], "na" -> 
           RGBColor[0.658708, 0.492173, 0.842842], "mg" -> 
           RGBColor[0.628274, 0.850553, 0.0782731], "al" -> 
           RGBColor[0.8913, 0.631904, 0.627399], "si" -> 
           RGBColor[0.941176, 0.784314, 0.627451], "p" -> 
           RGBColor[1., 0.501961, 0], "s" -> 
           RGBColor[0.90443, 0.97015, 0.13504], "cl" -> 
           RGBColor[0.412698, 0.932689, 0.166398], "ar" -> 
           RGBColor[0.546138, 0.844244, 0.892092], "k" -> 
           RGBColor[0.534026, 0.420729, 0.705621], "ca" -> 
           RGBColor[0.480072, 0.744591, 0.0955222], "sc" -> 
           RGBColor[0.901961, 0.901961, 0.901961], "ti" -> 
           RGBColor[0.74902, 0.760784, 0.780392], "v" -> 
           RGBColor[0.65098, 0.65098, 0.670588], "cr" -> 
           RGBColor[0.541176, 0.6, 0.780392], "mn" -> 
           RGBColor[0.611765, 0.478431, 0.780392], "fe" -> 
           RGBColor[0.878431, 0.4, 0.2], "co" -> 
           RGBColor[0.941176, 0.564706, 0.627451], "ni" -> 
           RGBColor[0.313725, 0.815686, 0.313725], "cu" -> 
           RGBColor[0.784314, 0.501961, 0.2], "zn" -> 
           RGBColor[0.490196, 0.501961, 0.690196], "ga" -> 
           RGBColor[0.800757, 0.542666, 0.533513], "ge" -> 
           RGBColor[0.60508, 0.632465, 0.576489], "as" -> 
           RGBColor[0.741176, 0.501961, 0.890196], "se" -> 
           RGBColor[0.917248, 0.657833, 0.0706628], "br" -> 
           RGBColor[0.58847, 0.22163, 0.16064], "kr" -> 
           RGBColor[0.426019, 0.747462, 0.810413], "rb" -> 
           RGBColor[0.425391, 0.329242, 0.585895], "sr" -> 
           RGBColor[0.325959, 0.646423, 0.095983], "y" -> 
           RGBColor[0.531014, 1., 1.], "zr" -> 
           RGBColor[0.458599, 0.917466, 0.918573], "nb" -> 
           RGBColor[0.385036, 0.834854, 0.841681], "mo" -> 
           RGBColor[0.310325, 0.752163, 0.769323], "tc" -> 
           RGBColor[0.234466, 0.669394, 0.701499], "ru" -> 
           RGBColor[0.157459, 0.586546, 0.638209], "rh" -> 
           RGBColor[0.0793033, 0.50362, 0.579453], "pd" -> 
           RGBColor[0., 0.420615, 0.525231], "ag" -> 
           RGBColor[0.752941, 0.752941, 0.752941], "cd" -> 
           RGBColor[1., 0.85098, 0.560784], "in" -> 
           RGBColor[0.728371, 0.440594, 0.422196], "sn" -> 
           RGBColor[0.39799, 0.491477, 0.495586], "sb" -> 
           RGBColor[0.619608, 0.388235, 0.709804], "te" -> 
           RGBColor[0.816706, 0.451332, 0.0100947], "i" -> 
           RGBColor[0.580392, 0, 0.580392], "xe" -> 
           RGBColor[0.316906, 0.638078, 0.710252], "cs" -> 
           RGBColor[0.332803, 0.217712, 0.483666], "ba" -> 
           RGBColor[0.165935, 0.55605, 0.0796556], "la" -> 
           RGBColor[0.928084, 0.716075, 0.329427], "ce" -> 
           RGBColor[0.894824, 0.731424, 0.325131], "pr" -> 
           RGBColor[0.86523, 0.707999, 0.315261], "nd" -> 
           RGBColor[0.837836, 0.662974, 0.301635], "pm" -> 
           RGBColor[0.811992, 0.607859, 0.285626], "sm" -> 
           RGBColor[0.787563, 0.549894, 0.268279], "eu" -> 
           RGBColor[0.764628, 0.493261, 0.250405], "gd" -> 
           RGBColor[0.743177, 0.440115, 0.23269], "tb" -> 
           RGBColor[0.72281, 0.39143, 0.215783], "dy" -> 
           RGBColor[0.702434, 0.347663, 0.200392], "ho" -> 
           RGBColor[0.679962, 0.309234, 0.187368], "er" -> 
           RGBColor[0.652012, 0.276823, 0.17779], "tm" -> 
           RGBColor[0.613603, 0.251489, 0.173042], "yb" -> 
           RGBColor[0.557855, 0.234598, 0.17489], "lu" -> 
           RGBColor[0.475685, 0.227573, 0.18555], "hf" -> 
           RGBColor[0.781537, 0.717388, 0.716579], "ta" -> 
           RGBColor[0.734443, 0.544489, 0.683471], "w" -> 
           RGBColor[0.681179, 0.360409, 0.63675], "re" -> 
           RGBColor[0.605181, 0.367584, 0.556343], "os" -> 
           RGBColor[0.521806, 0.382125, 0.469204], "ir" -> 
           RGBColor[0.445624, 0.373159, 0.399069], "pt" -> 
           RGBColor[0.815686, 0.815686, 0.878431], "au" -> 
           RGBColor[1., 0.819608, 0.137255], "hg" -> 
           RGBColor[0.721569, 0.721569, 0.815686], "tl" -> 
           RGBColor[0.65098, 0.329412, 0.301961], "pb" -> 
           RGBColor[0.341176, 0.34902, 0.380392], "bi" -> 
           RGBColor[0.619608, 0.309804, 0.709804], "po" -> 
           RGBColor[0.670588, 0.360784, 0], "at" -> 
           RGBColor[0.458824, 0.309804, 0.270588], "rn" -> 
           RGBColor[0.218799, 0.516091, 0.591608], "fr" -> 
           RGBColor[0.25626, 0.0861372, 0.398932], "ra" -> 
           RGBColor[0., 0.473472, 0.04654], "ac" -> 
           RGBColor[0.322042, 0.71693, 0.988479], "th" -> 
           RGBColor[0.3608, 0.67166, 0.943003], "pa" -> 
           RGBColor[0.397469, 0.628, 0.898853], "u" -> 
           RGBColor[0.43205, 0.58595, 0.856029], "np" -> 
           RGBColor[0.464542, 0.54551, 0.814532], "pu" -> 
           RGBColor[0.494945, 0.506679, 0.774361], "am" -> 
           RGBColor[0.52326, 0.469458, 0.735517], "cm" -> 
           RGBColor[0.549486, 0.433847, 0.697999], "bk" -> 
           RGBColor[0.573624, 0.399845, 0.661808], "cf" -> 
           RGBColor[0.595673, 0.367454, 0.626942], "es" -> 
           RGBColor[0.615633, 0.336672, 0.593404], "fm" -> 
           RGBColor[0.633505, 0.307499, 0.561191], "md" -> 
           RGBColor[0.649288, 0.279937, 0.530305], "no" -> 
           RGBColor[0.662982, 0.253984, 0.500746], "lr" -> 
           RGBColor[0.674588, 0.22964, 0.472513], "rf" -> 
           RGBColor[0.684106, 0.206907, 0.445606], "db" -> 
           RGBColor[0.691534, 0.185783, 0.420025], "sg" -> 
           RGBColor[0.696874, 0.166269, 0.395772], "bh" -> 
           RGBColor[0.700126, 0.148365, 0.372844], "hs" -> 
           RGBColor[0.701289, 0.13207, 0.351243], "mt" -> 
           RGBColor[0.700363, 0.117385, 0.330968], "ds" -> 
           RGBColor[0.697348, 0.10431, 0.31202], "rg" -> 
           RGBColor[0.692245, 0.0928444, 0.294398], "cn" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "nh" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "fl" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "mc" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "lv" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "ts" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "og" -> 
           RGBColor[0.635401, 0.0528, 0.226184], "uub" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "uut" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "uuq" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "uup" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "uuh" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "uus" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "uuo" -> 
           RGBColor[0.635401, 0.0528, 0.226184]}]]& ][0.85], 
       ColorDataFunction[
       "Atoms", 
        "Named", {{
         "H", "He", "Li", "Be", "B", "C", "N", "O", "F", "Ne", "Na", "Mg", 
          "Al", "Si", "P", "S", "Cl", "Ar", "K", "Ca", "Sc", "Ti", "V", "Cr", 
          "Mn", "Fe", "Co", "Ni", "Cu", "Zn", "Ga", "Ge", "As", "Se", "Br", 
          "Kr", "Rb", "Sr", "Y", "Zr", "Nb", "Mo", "Tc", "Ru", "Rh", "Pd", 
          "Ag", "Cd", "In", "Sn", "Sb", "Te", "I", "Xe", "Cs", "Ba", "La", 
          "Ce", "Pr", "Nd", "Pm", "Sm", "Eu", "Gd", "Tb", "Dy", "Ho", "Er", 
          "Tm", "Yb", "Lu", "Hf", "Ta", "W", "Re", "Os", "Ir", "Pt", "Au", 
          "Hg", "Tl", "Pb", "Bi", "Po", "At", "Rn", "Fr", "Ra", "Ac", "Th", 
          "Pa", "U", "Np", "Pu", "Am", "Cm", "Bk", "Cf", "Es", "Fm", "Md", 
          "No", "Lr", "Rf", "Db", "Sg", "Bh", "Hs", "Mt", "Ds", "Rg", "Cn", 
          "Nh", "Fl", "Mc", "Lv", "Ts", "Og", "Uub", "Uut", "Uuq", "Uup", 
          "Uuh", "Uus", "Uuo"}, {
         "h", "he", "li", "be", "b", "c", "n", "o", "f", "ne", "na", "mg", 
          "al", "si", "p", "s", "cl", "ar", "k", "ca", "sc", "ti", "v", "cr", 
          "mn", "fe", "co", "ni", "cu", "zn", "ga", "ge", "as", "se", "br", 
          "kr", "rb", "sr", "y", "zr", "nb", "mo", "tc", "ru", "rh", "pd", 
          "ag", "cd", "in", "sn", "sb", "te", "i", "xe", "cs", "ba", "la", 
          "ce", "pr", "nd", "pm", "sm", "eu", "gd", "tb", "dy", "ho", "er", 
          "tm", "yb", "lu", "hf", "ta", "w", "re", "os", "ir", "pt", "au", 
          "hg", "tl", "pb", "bi", "po", "at", "rn", "fr", "ra", "ac", "th", 
          "pa", "u", "np", "pu", "am", "cm", "bk", "cf", "es", "fm", "md", 
          "no", "lr", "rf", "db", "sg", "bh", "hs", "mt", "ds", "rg", "cn", 
          "nh", "fl", "mc", "lv", "ts", "og", "uub", "uut", "uuq", "uup", 
          "uuh", "uus", "uuo"}}, Replace[#, 
         Dispatch[{
          "h" -> RGBColor[0.65, 0.7, 0.7], "he" -> RGBColor[0.836713, 1., 1.],
            "li" -> RGBColor[0.799435, 0.543572, 0.997559], "be" -> 
           RGBColor[0.770565, 0.964309, 0.0442359], "b" -> 
           RGBColor[1., 0.709804, 0.709804], "c" -> RGBColor[0.4, 0.4, 0.4], 
           "n" -> RGBColor[0.291989, 0.437977, 0.888609], "o" -> 
           RGBColor[0.800498, 0.201504, 0.192061], "f" -> 
           RGBColor[0.578462, 0.85539, 0.408855], "ne" -> 
           RGBColor[0.677263, 0.928423, 0.955287], "na" -> 
           RGBColor[0.658708, 0.492173, 0.842842], "mg" -> 
           RGBColor[0.628274, 0.850553, 0.0782731], "al" -> 
           RGBColor[0.8913, 0.631904, 0.627399], "si" -> 
           RGBColor[0.941176, 0.784314, 0.627451], "p" -> 
           RGBColor[1., 0.501961, 0], "s" -> 
           RGBColor[0.90443, 0.97015, 0.13504], "cl" -> 
           RGBColor[0.412698, 0.932689, 0.166398], "ar" -> 
           RGBColor[0.546138, 0.844244, 0.892092], "k" -> 
           RGBColor[0.534026, 0.420729, 0.705621], "ca" -> 
           RGBColor[0.480072, 0.744591, 0.0955222], "sc" -> 
           RGBColor[0.901961, 0.901961, 0.901961], "ti" -> 
           RGBColor[0.74902, 0.760784, 0.780392], "v" -> 
           RGBColor[0.65098, 0.65098, 0.670588], "cr" -> 
           RGBColor[0.541176, 0.6, 0.780392], "mn" -> 
           RGBColor[0.611765, 0.478431, 0.780392], "fe" -> 
           RGBColor[0.878431, 0.4, 0.2], "co" -> 
           RGBColor[0.941176, 0.564706, 0.627451], "ni" -> 
           RGBColor[0.313725, 0.815686, 0.313725], "cu" -> 
           RGBColor[0.784314, 0.501961, 0.2], "zn" -> 
           RGBColor[0.490196, 0.501961, 0.690196], "ga" -> 
           RGBColor[0.800757, 0.542666, 0.533513], "ge" -> 
           RGBColor[0.60508, 0.632465, 0.576489], "as" -> 
           RGBColor[0.741176, 0.501961, 0.890196], "se" -> 
           RGBColor[0.917248, 0.657833, 0.0706628], "br" -> 
           RGBColor[0.58847, 0.22163, 0.16064], "kr" -> 
           RGBColor[0.426019, 0.747462, 0.810413], "rb" -> 
           RGBColor[0.425391, 0.329242, 0.585895], "sr" -> 
           RGBColor[0.325959, 0.646423, 0.095983], "y" -> 
           RGBColor[0.531014, 1., 1.], "zr" -> 
           RGBColor[0.458599, 0.917466, 0.918573], "nb" -> 
           RGBColor[0.385036, 0.834854, 0.841681], "mo" -> 
           RGBColor[0.310325, 0.752163, 0.769323], "tc" -> 
           RGBColor[0.234466, 0.669394, 0.701499], "ru" -> 
           RGBColor[0.157459, 0.586546, 0.638209], "rh" -> 
           RGBColor[0.0793033, 0.50362, 0.579453], "pd" -> 
           RGBColor[0., 0.420615, 0.525231], "ag" -> 
           RGBColor[0.752941, 0.752941, 0.752941], "cd" -> 
           RGBColor[1., 0.85098, 0.560784], "in" -> 
           RGBColor[0.728371, 0.440594, 0.422196], "sn" -> 
           RGBColor[0.39799, 0.491477, 0.495586], "sb" -> 
           RGBColor[0.619608, 0.388235, 0.709804], "te" -> 
           RGBColor[0.816706, 0.451332, 0.0100947], "i" -> 
           RGBColor[0.580392, 0, 0.580392], "xe" -> 
           RGBColor[0.316906, 0.638078, 0.710252], "cs" -> 
           RGBColor[0.332803, 0.217712, 0.483666], "ba" -> 
           RGBColor[0.165935, 0.55605, 0.0796556], "la" -> 
           RGBColor[0.928084, 0.716075, 0.329427], "ce" -> 
           RGBColor[0.894824, 0.731424, 0.325131], "pr" -> 
           RGBColor[0.86523, 0.707999, 0.315261], "nd" -> 
           RGBColor[0.837836, 0.662974, 0.301635], "pm" -> 
           RGBColor[0.811992, 0.607859, 0.285626], "sm" -> 
           RGBColor[0.787563, 0.549894, 0.268279], "eu" -> 
           RGBColor[0.764628, 0.493261, 0.250405], "gd" -> 
           RGBColor[0.743177, 0.440115, 0.23269], "tb" -> 
           RGBColor[0.72281, 0.39143, 0.215783], "dy" -> 
           RGBColor[0.702434, 0.347663, 0.200392], "ho" -> 
           RGBColor[0.679962, 0.309234, 0.187368], "er" -> 
           RGBColor[0.652012, 0.276823, 0.17779], "tm" -> 
           RGBColor[0.613603, 0.251489, 0.173042], "yb" -> 
           RGBColor[0.557855, 0.234598, 0.17489], "lu" -> 
           RGBColor[0.475685, 0.227573, 0.18555], "hf" -> 
           RGBColor[0.781537, 0.717388, 0.716579], "ta" -> 
           RGBColor[0.734443, 0.544489, 0.683471], "w" -> 
           RGBColor[0.681179, 0.360409, 0.63675], "re" -> 
           RGBColor[0.605181, 0.367584, 0.556343], "os" -> 
           RGBColor[0.521806, 0.382125, 0.469204], "ir" -> 
           RGBColor[0.445624, 0.373159, 0.399069], "pt" -> 
           RGBColor[0.815686, 0.815686, 0.878431], "au" -> 
           RGBColor[1., 0.819608, 0.137255], "hg" -> 
           RGBColor[0.721569, 0.721569, 0.815686], "tl" -> 
           RGBColor[0.65098, 0.329412, 0.301961], "pb" -> 
           RGBColor[0.341176, 0.34902, 0.380392], "bi" -> 
           RGBColor[0.619608, 0.309804, 0.709804], "po" -> 
           RGBColor[0.670588, 0.360784, 0], "at" -> 
           RGBColor[0.458824, 0.309804, 0.270588], "rn" -> 
           RGBColor[0.218799, 0.516091, 0.591608], "fr" -> 
           RGBColor[0.25626, 0.0861372, 0.398932], "ra" -> 
           RGBColor[0., 0.473472, 0.04654], "ac" -> 
           RGBColor[0.322042, 0.71693, 0.988479], "th" -> 
           RGBColor[0.3608, 0.67166, 0.943003], "pa" -> 
           RGBColor[0.397469, 0.628, 0.898853], "u" -> 
           RGBColor[0.43205, 0.58595, 0.856029], "np" -> 
           RGBColor[0.464542, 0.54551, 0.814532], "pu" -> 
           RGBColor[0.494945, 0.506679, 0.774361], "am" -> 
           RGBColor[0.52326, 0.469458, 0.735517], "cm" -> 
           RGBColor[0.549486, 0.433847, 0.697999], "bk" -> 
           RGBColor[0.573624, 0.399845, 0.661808], "cf" -> 
           RGBColor[0.595673, 0.367454, 0.626942], "es" -> 
           RGBColor[0.615633, 0.336672, 0.593404], "fm" -> 
           RGBColor[0.633505, 0.307499, 0.561191], "md" -> 
           RGBColor[0.649288, 0.279937, 0.530305], "no" -> 
           RGBColor[0.662982, 0.253984, 0.500746], "lr" -> 
           RGBColor[0.674588, 0.22964, 0.472513], "rf" -> 
           RGBColor[0.684106, 0.206907, 0.445606], "db" -> 
           RGBColor[0.691534, 0.185783, 0.420025], "sg" -> 
           RGBColor[0.696874, 0.166269, 0.395772], "bh" -> 
           RGBColor[0.700126, 0.148365, 0.372844], "hs" -> 
           RGBColor[0.701289, 0.13207, 0.351243], "mt" -> 
           RGBColor[0.700363, 0.117385, 0.330968], "ds" -> 
           RGBColor[0.697348, 0.10431, 0.31202], "rg" -> 
           RGBColor[0.692245, 0.0928444, 0.294398], "cn" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "nh" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "fl" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "mc" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "lv" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "ts" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "og" -> 
           RGBColor[0.635401, 0.0528, 0.226184], "uub" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "uut" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "uuq" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "uup" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "uuh" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "uus" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "uuo" -> 
           RGBColor[0.635401, 0.0528, 0.226184]}]]& ][0.85], 
       ColorDataFunction[
       "Atoms", 
        "Named", {{
         "H", "He", "Li", "Be", "B", "C", "N", "O", "F", "Ne", "Na", "Mg", 
          "Al", "Si", "P", "S", "Cl", "Ar", "K", "Ca", "Sc", "Ti", "V", "Cr", 
          "Mn", "Fe", "Co", "Ni", "Cu", "Zn", "Ga", "Ge", "As", "Se", "Br", 
          "Kr", "Rb", "Sr", "Y", "Zr", "Nb", "Mo", "Tc", "Ru", "Rh", "Pd", 
          "Ag", "Cd", "In", "Sn", "Sb", "Te", "I", "Xe", "Cs", "Ba", "La", 
          "Ce", "Pr", "Nd", "Pm", "Sm", "Eu", "Gd", "Tb", "Dy", "Ho", "Er", 
          "Tm", "Yb", "Lu", "Hf", "Ta", "W", "Re", "Os", "Ir", "Pt", "Au", 
          "Hg", "Tl", "Pb", "Bi", "Po", "At", "Rn", "Fr", "Ra", "Ac", "Th", 
          "Pa", "U", "Np", "Pu", "Am", "Cm", "Bk", "Cf", "Es", "Fm", "Md", 
          "No", "Lr", "Rf", "Db", "Sg", "Bh", "Hs", "Mt", "Ds", "Rg", "Cn", 
          "Nh", "Fl", "Mc", "Lv", "Ts", "Og", "Uub", "Uut", "Uuq", "Uup", 
          "Uuh", "Uus", "Uuo"}, {
         "h", "he", "li", "be", "b", "c", "n", "o", "f", "ne", "na", "mg", 
          "al", "si", "p", "s", "cl", "ar", "k", "ca", "sc", "ti", "v", "cr", 
          "mn", "fe", "co", "ni", "cu", "zn", "ga", "ge", "as", "se", "br", 
          "kr", "rb", "sr", "y", "zr", "nb", "mo", "tc", "ru", "rh", "pd", 
          "ag", "cd", "in", "sn", "sb", "te", "i", "xe", "cs", "ba", "la", 
          "ce", "pr", "nd", "pm", "sm", "eu", "gd", "tb", "dy", "ho", "er", 
          "tm", "yb", "lu", "hf", "ta", "w", "re", "os", "ir", "pt", "au", 
          "hg", "tl", "pb", "bi", "po", "at", "rn", "fr", "ra", "ac", "th", 
          "pa", "u", "np", "pu", "am", "cm", "bk", "cf", "es", "fm", "md", 
          "no", "lr", "rf", "db", "sg", "bh", "hs", "mt", "ds", "rg", "cn", 
          "nh", "fl", "mc", "lv", "ts", "og", "uub", "uut", "uuq", "uup", 
          "uuh", "uus", "uuo"}}, Replace[#, 
         Dispatch[{
          "h" -> RGBColor[0.65, 0.7, 0.7], "he" -> RGBColor[0.836713, 1., 1.],
            "li" -> RGBColor[0.799435, 0.543572, 0.997559], "be" -> 
           RGBColor[0.770565, 0.964309, 0.0442359], "b" -> 
           RGBColor[1., 0.709804, 0.709804], "c" -> RGBColor[0.4, 0.4, 0.4], 
           "n" -> RGBColor[0.291989, 0.437977, 0.888609], "o" -> 
           RGBColor[0.800498, 0.201504, 0.192061], "f" -> 
           RGBColor[0.578462, 0.85539, 0.408855], "ne" -> 
           RGBColor[0.677263, 0.928423, 0.955287], "na" -> 
           RGBColor[0.658708, 0.492173, 0.842842], "mg" -> 
           RGBColor[0.628274, 0.850553, 0.0782731], "al" -> 
           RGBColor[0.8913, 0.631904, 0.627399], "si" -> 
           RGBColor[0.941176, 0.784314, 0.627451], "p" -> 
           RGBColor[1., 0.501961, 0], "s" -> 
           RGBColor[0.90443, 0.97015, 0.13504], "cl" -> 
           RGBColor[0.412698, 0.932689, 0.166398], "ar" -> 
           RGBColor[0.546138, 0.844244, 0.892092], "k" -> 
           RGBColor[0.534026, 0.420729, 0.705621], "ca" -> 
           RGBColor[0.480072, 0.744591, 0.0955222], "sc" -> 
           RGBColor[0.901961, 0.901961, 0.901961], "ti" -> 
           RGBColor[0.74902, 0.760784, 0.780392], "v" -> 
           RGBColor[0.65098, 0.65098, 0.670588], "cr" -> 
           RGBColor[0.541176, 0.6, 0.780392], "mn" -> 
           RGBColor[0.611765, 0.478431, 0.780392], "fe" -> 
           RGBColor[0.878431, 0.4, 0.2], "co" -> 
           RGBColor[0.941176, 0.564706, 0.627451], "ni" -> 
           RGBColor[0.313725, 0.815686, 0.313725], "cu" -> 
           RGBColor[0.784314, 0.501961, 0.2], "zn" -> 
           RGBColor[0.490196, 0.501961, 0.690196], "ga" -> 
           RGBColor[0.800757, 0.542666, 0.533513], "ge" -> 
           RGBColor[0.60508, 0.632465, 0.576489], "as" -> 
           RGBColor[0.741176, 0.501961, 0.890196], "se" -> 
           RGBColor[0.917248, 0.657833, 0.0706628], "br" -> 
           RGBColor[0.58847, 0.22163, 0.16064], "kr" -> 
           RGBColor[0.426019, 0.747462, 0.810413], "rb" -> 
           RGBColor[0.425391, 0.329242, 0.585895], "sr" -> 
           RGBColor[0.325959, 0.646423, 0.095983], "y" -> 
           RGBColor[0.531014, 1., 1.], "zr" -> 
           RGBColor[0.458599, 0.917466, 0.918573], "nb" -> 
           RGBColor[0.385036, 0.834854, 0.841681], "mo" -> 
           RGBColor[0.310325, 0.752163, 0.769323], "tc" -> 
           RGBColor[0.234466, 0.669394, 0.701499], "ru" -> 
           RGBColor[0.157459, 0.586546, 0.638209], "rh" -> 
           RGBColor[0.0793033, 0.50362, 0.579453], "pd" -> 
           RGBColor[0., 0.420615, 0.525231], "ag" -> 
           RGBColor[0.752941, 0.752941, 0.752941], "cd" -> 
           RGBColor[1., 0.85098, 0.560784], "in" -> 
           RGBColor[0.728371, 0.440594, 0.422196], "sn" -> 
           RGBColor[0.39799, 0.491477, 0.495586], "sb" -> 
           RGBColor[0.619608, 0.388235, 0.709804], "te" -> 
           RGBColor[0.816706, 0.451332, 0.0100947], "i" -> 
           RGBColor[0.580392, 0, 0.580392], "xe" -> 
           RGBColor[0.316906, 0.638078, 0.710252], "cs" -> 
           RGBColor[0.332803, 0.217712, 0.483666], "ba" -> 
           RGBColor[0.165935, 0.55605, 0.0796556], "la" -> 
           RGBColor[0.928084, 0.716075, 0.329427], "ce" -> 
           RGBColor[0.894824, 0.731424, 0.325131], "pr" -> 
           RGBColor[0.86523, 0.707999, 0.315261], "nd" -> 
           RGBColor[0.837836, 0.662974, 0.301635], "pm" -> 
           RGBColor[0.811992, 0.607859, 0.285626], "sm" -> 
           RGBColor[0.787563, 0.549894, 0.268279], "eu" -> 
           RGBColor[0.764628, 0.493261, 0.250405], "gd" -> 
           RGBColor[0.743177, 0.440115, 0.23269], "tb" -> 
           RGBColor[0.72281, 0.39143, 0.215783], "dy" -> 
           RGBColor[0.702434, 0.347663, 0.200392], "ho" -> 
           RGBColor[0.679962, 0.309234, 0.187368], "er" -> 
           RGBColor[0.652012, 0.276823, 0.17779], "tm" -> 
           RGBColor[0.613603, 0.251489, 0.173042], "yb" -> 
           RGBColor[0.557855, 0.234598, 0.17489], "lu" -> 
           RGBColor[0.475685, 0.227573, 0.18555], "hf" -> 
           RGBColor[0.781537, 0.717388, 0.716579], "ta" -> 
           RGBColor[0.734443, 0.544489, 0.683471], "w" -> 
           RGBColor[0.681179, 0.360409, 0.63675], "re" -> 
           RGBColor[0.605181, 0.367584, 0.556343], "os" -> 
           RGBColor[0.521806, 0.382125, 0.469204], "ir" -> 
           RGBColor[0.445624, 0.373159, 0.399069], "pt" -> 
           RGBColor[0.815686, 0.815686, 0.878431], "au" -> 
           RGBColor[1., 0.819608, 0.137255], "hg" -> 
           RGBColor[0.721569, 0.721569, 0.815686], "tl" -> 
           RGBColor[0.65098, 0.329412, 0.301961], "pb" -> 
           RGBColor[0.341176, 0.34902, 0.380392], "bi" -> 
           RGBColor[0.619608, 0.309804, 0.709804], "po" -> 
           RGBColor[0.670588, 0.360784, 0], "at" -> 
           RGBColor[0.458824, 0.309804, 0.270588], "rn" -> 
           RGBColor[0.218799, 0.516091, 0.591608], "fr" -> 
           RGBColor[0.25626, 0.0861372, 0.398932], "ra" -> 
           RGBColor[0., 0.473472, 0.04654], "ac" -> 
           RGBColor[0.322042, 0.71693, 0.988479], "th" -> 
           RGBColor[0.3608, 0.67166, 0.943003], "pa" -> 
           RGBColor[0.397469, 0.628, 0.898853], "u" -> 
           RGBColor[0.43205, 0.58595, 0.856029], "np" -> 
           RGBColor[0.464542, 0.54551, 0.814532], "pu" -> 
           RGBColor[0.494945, 0.506679, 0.774361], "am" -> 
           RGBColor[0.52326, 0.469458, 0.735517], "cm" -> 
           RGBColor[0.549486, 0.433847, 0.697999], "bk" -> 
           RGBColor[0.573624, 0.399845, 0.661808], "cf" -> 
           RGBColor[0.595673, 0.367454, 0.626942], "es" -> 
           RGBColor[0.615633, 0.336672, 0.593404], "fm" -> 
           RGBColor[0.633505, 0.307499, 0.561191], "md" -> 
           RGBColor[0.649288, 0.279937, 0.530305], "no" -> 
           RGBColor[0.662982, 0.253984, 0.500746], "lr" -> 
           RGBColor[0.674588, 0.22964, 0.472513], "rf" -> 
           RGBColor[0.684106, 0.206907, 0.445606], "db" -> 
           RGBColor[0.691534, 0.185783, 0.420025], "sg" -> 
           RGBColor[0.696874, 0.166269, 0.395772], "bh" -> 
           RGBColor[0.700126, 0.148365, 0.372844], "hs" -> 
           RGBColor[0.701289, 0.13207, 0.351243], "mt" -> 
           RGBColor[0.700363, 0.117385, 0.330968], "ds" -> 
           RGBColor[0.697348, 0.10431, 0.31202], "rg" -> 
           RGBColor[0.692245, 0.0928444, 0.294398], "cn" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "nh" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "fl" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "mc" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "lv" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "ts" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "og" -> 
           RGBColor[0.635401, 0.0528, 0.226184], "uub" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "uut" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "uuq" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "uup" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "uuh" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "uus" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "uuo" -> 
           RGBColor[0.635401, 0.0528, 0.226184]}]]& ][0.85], 
       ColorDataFunction[
       "Atoms", 
        "Named", {{
         "H", "He", "Li", "Be", "B", "C", "N", "O", "F", "Ne", "Na", "Mg", 
          "Al", "Si", "P", "S", "Cl", "Ar", "K", "Ca", "Sc", "Ti", "V", "Cr", 
          "Mn", "Fe", "Co", "Ni", "Cu", "Zn", "Ga", "Ge", "As", "Se", "Br", 
          "Kr", "Rb", "Sr", "Y", "Zr", "Nb", "Mo", "Tc", "Ru", "Rh", "Pd", 
          "Ag", "Cd", "In", "Sn", "Sb", "Te", "I", "Xe", "Cs", "Ba", "La", 
          "Ce", "Pr", "Nd", "Pm", "Sm", "Eu", "Gd", "Tb", "Dy", "Ho", "Er", 
          "Tm", "Yb", "Lu", "Hf", "Ta", "W", "Re", "Os", "Ir", "Pt", "Au", 
          "Hg", "Tl", "Pb", "Bi", "Po", "At", "Rn", "Fr", "Ra", "Ac", "Th", 
          "Pa", "U", "Np", "Pu", "Am", "Cm", "Bk", "Cf", "Es", "Fm", "Md", 
          "No", "Lr", "Rf", "Db", "Sg", "Bh", "Hs", "Mt", "Ds", "Rg", "Cn", 
          "Nh", "Fl", "Mc", "Lv", "Ts", "Og", "Uub", "Uut", "Uuq", "Uup", 
          "Uuh", "Uus", "Uuo"}, {
         "h", "he", "li", "be", "b", "c", "n", "o", "f", "ne", "na", "mg", 
          "al", "si", "p", "s", "cl", "ar", "k", "ca", "sc", "ti", "v", "cr", 
          "mn", "fe", "co", "ni", "cu", "zn", "ga", "ge", "as", "se", "br", 
          "kr", "rb", "sr", "y", "zr", "nb", "mo", "tc", "ru", "rh", "pd", 
          "ag", "cd", "in", "sn", "sb", "te", "i", "xe", "cs", "ba", "la", 
          "ce", "pr", "nd", "pm", "sm", "eu", "gd", "tb", "dy", "ho", "er", 
          "tm", "yb", "lu", "hf", "ta", "w", "re", "os", "ir", "pt", "au", 
          "hg", "tl", "pb", "bi", "po", "at", "rn", "fr", "ra", "ac", "th", 
          "pa", "u", "np", "pu", "am", "cm", "bk", "cf", "es", "fm", "md", 
          "no", "lr", "rf", "db", "sg", "bh", "hs", "mt", "ds", "rg", "cn", 
          "nh", "fl", "mc", "lv", "ts", "og", "uub", "uut", "uuq", "uup", 
          "uuh", "uus", "uuo"}}, Replace[#, 
         Dispatch[{
          "h" -> RGBColor[0.65, 0.7, 0.7], "he" -> RGBColor[0.836713, 1., 1.],
            "li" -> RGBColor[0.799435, 0.543572, 0.997559], "be" -> 
           RGBColor[0.770565, 0.964309, 0.0442359], "b" -> 
           RGBColor[1., 0.709804, 0.709804], "c" -> RGBColor[0.4, 0.4, 0.4], 
           "n" -> RGBColor[0.291989, 0.437977, 0.888609], "o" -> 
           RGBColor[0.800498, 0.201504, 0.192061], "f" -> 
           RGBColor[0.578462, 0.85539, 0.408855], "ne" -> 
           RGBColor[0.677263, 0.928423, 0.955287], "na" -> 
           RGBColor[0.658708, 0.492173, 0.842842], "mg" -> 
           RGBColor[0.628274, 0.850553, 0.0782731], "al" -> 
           RGBColor[0.8913, 0.631904, 0.627399], "si" -> 
           RGBColor[0.941176, 0.784314, 0.627451], "p" -> 
           RGBColor[1., 0.501961, 0], "s" -> 
           RGBColor[0.90443, 0.97015, 0.13504], "cl" -> 
           RGBColor[0.412698, 0.932689, 0.166398], "ar" -> 
           RGBColor[0.546138, 0.844244, 0.892092], "k" -> 
           RGBColor[0.534026, 0.420729, 0.705621], "ca" -> 
           RGBColor[0.480072, 0.744591, 0.0955222], "sc" -> 
           RGBColor[0.901961, 0.901961, 0.901961], "ti" -> 
           RGBColor[0.74902, 0.760784, 0.780392], "v" -> 
           RGBColor[0.65098, 0.65098, 0.670588], "cr" -> 
           RGBColor[0.541176, 0.6, 0.780392], "mn" -> 
           RGBColor[0.611765, 0.478431, 0.780392], "fe" -> 
           RGBColor[0.878431, 0.4, 0.2], "co" -> 
           RGBColor[0.941176, 0.564706, 0.627451], "ni" -> 
           RGBColor[0.313725, 0.815686, 0.313725], "cu" -> 
           RGBColor[0.784314, 0.501961, 0.2], "zn" -> 
           RGBColor[0.490196, 0.501961, 0.690196], "ga" -> 
           RGBColor[0.800757, 0.542666, 0.533513], "ge" -> 
           RGBColor[0.60508, 0.632465, 0.576489], "as" -> 
           RGBColor[0.741176, 0.501961, 0.890196], "se" -> 
           RGBColor[0.917248, 0.657833, 0.0706628], "br" -> 
           RGBColor[0.58847, 0.22163, 0.16064], "kr" -> 
           RGBColor[0.426019, 0.747462, 0.810413], "rb" -> 
           RGBColor[0.425391, 0.329242, 0.585895], "sr" -> 
           RGBColor[0.325959, 0.646423, 0.095983], "y" -> 
           RGBColor[0.531014, 1., 1.], "zr" -> 
           RGBColor[0.458599, 0.917466, 0.918573], "nb" -> 
           RGBColor[0.385036, 0.834854, 0.841681], "mo" -> 
           RGBColor[0.310325, 0.752163, 0.769323], "tc" -> 
           RGBColor[0.234466, 0.669394, 0.701499], "ru" -> 
           RGBColor[0.157459, 0.586546, 0.638209], "rh" -> 
           RGBColor[0.0793033, 0.50362, 0.579453], "pd" -> 
           RGBColor[0., 0.420615, 0.525231], "ag" -> 
           RGBColor[0.752941, 0.752941, 0.752941], "cd" -> 
           RGBColor[1., 0.85098, 0.560784], "in" -> 
           RGBColor[0.728371, 0.440594, 0.422196], "sn" -> 
           RGBColor[0.39799, 0.491477, 0.495586], "sb" -> 
           RGBColor[0.619608, 0.388235, 0.709804], "te" -> 
           RGBColor[0.816706, 0.451332, 0.0100947], "i" -> 
           RGBColor[0.580392, 0, 0.580392], "xe" -> 
           RGBColor[0.316906, 0.638078, 0.710252], "cs" -> 
           RGBColor[0.332803, 0.217712, 0.483666], "ba" -> 
           RGBColor[0.165935, 0.55605, 0.0796556], "la" -> 
           RGBColor[0.928084, 0.716075, 0.329427], "ce" -> 
           RGBColor[0.894824, 0.731424, 0.325131], "pr" -> 
           RGBColor[0.86523, 0.707999, 0.315261], "nd" -> 
           RGBColor[0.837836, 0.662974, 0.301635], "pm" -> 
           RGBColor[0.811992, 0.607859, 0.285626], "sm" -> 
           RGBColor[0.787563, 0.549894, 0.268279], "eu" -> 
           RGBColor[0.764628, 0.493261, 0.250405], "gd" -> 
           RGBColor[0.743177, 0.440115, 0.23269], "tb" -> 
           RGBColor[0.72281, 0.39143, 0.215783], "dy" -> 
           RGBColor[0.702434, 0.347663, 0.200392], "ho" -> 
           RGBColor[0.679962, 0.309234, 0.187368], "er" -> 
           RGBColor[0.652012, 0.276823, 0.17779], "tm" -> 
           RGBColor[0.613603, 0.251489, 0.173042], "yb" -> 
           RGBColor[0.557855, 0.234598, 0.17489], "lu" -> 
           RGBColor[0.475685, 0.227573, 0.18555], "hf" -> 
           RGBColor[0.781537, 0.717388, 0.716579], "ta" -> 
           RGBColor[0.734443, 0.544489, 0.683471], "w" -> 
           RGBColor[0.681179, 0.360409, 0.63675], "re" -> 
           RGBColor[0.605181, 0.367584, 0.556343], "os" -> 
           RGBColor[0.521806, 0.382125, 0.469204], "ir" -> 
           RGBColor[0.445624, 0.373159, 0.399069], "pt" -> 
           RGBColor[0.815686, 0.815686, 0.878431], "au" -> 
           RGBColor[1., 0.819608, 0.137255], "hg" -> 
           RGBColor[0.721569, 0.721569, 0.815686], "tl" -> 
           RGBColor[0.65098, 0.329412, 0.301961], "pb" -> 
           RGBColor[0.341176, 0.34902, 0.380392], "bi" -> 
           RGBColor[0.619608, 0.309804, 0.709804], "po" -> 
           RGBColor[0.670588, 0.360784, 0], "at" -> 
           RGBColor[0.458824, 0.309804, 0.270588], "rn" -> 
           RGBColor[0.218799, 0.516091, 0.591608], "fr" -> 
           RGBColor[0.25626, 0.0861372, 0.398932], "ra" -> 
           RGBColor[0., 0.473472, 0.04654], "ac" -> 
           RGBColor[0.322042, 0.71693, 0.988479], "th" -> 
           RGBColor[0.3608, 0.67166, 0.943003], "pa" -> 
           RGBColor[0.397469, 0.628, 0.898853], "u" -> 
           RGBColor[0.43205, 0.58595, 0.856029], "np" -> 
           RGBColor[0.464542, 0.54551, 0.814532], "pu" -> 
           RGBColor[0.494945, 0.506679, 0.774361], "am" -> 
           RGBColor[0.52326, 0.469458, 0.735517], "cm" -> 
           RGBColor[0.549486, 0.433847, 0.697999], "bk" -> 
           RGBColor[0.573624, 0.399845, 0.661808], "cf" -> 
           RGBColor[0.595673, 0.367454, 0.626942], "es" -> 
           RGBColor[0.615633, 0.336672, 0.593404], "fm" -> 
           RGBColor[0.633505, 0.307499, 0.561191], "md" -> 
           RGBColor[0.649288, 0.279937, 0.530305], "no" -> 
           RGBColor[0.662982, 0.253984, 0.500746], "lr" -> 
           RGBColor[0.674588, 0.22964, 0.472513], "rf" -> 
           RGBColor[0.684106, 0.206907, 0.445606], "db" -> 
           RGBColor[0.691534, 0.185783, 0.420025], "sg" -> 
           RGBColor[0.696874, 0.166269, 0.395772], "bh" -> 
           RGBColor[0.700126, 0.148365, 0.372844], "hs" -> 
           RGBColor[0.701289, 0.13207, 0.351243], "mt" -> 
           RGBColor[0.700363, 0.117385, 0.330968], "ds" -> 
           RGBColor[0.697348, 0.10431, 0.31202], "rg" -> 
           RGBColor[0.692245, 0.0928444, 0.294398], "cn" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "nh" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "fl" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "mc" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "lv" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "ts" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "og" -> 
           RGBColor[0.635401, 0.0528, 0.226184], "uub" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "uut" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "uuq" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "uup" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "uuh" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "uus" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "uuo" -> 
           RGBColor[0.635401, 0.0528, 0.226184]}]]& ][0.85], 
       ColorDataFunction[
       "Atoms", 
        "Named", {{
         "H", "He", "Li", "Be", "B", "C", "N", "O", "F", "Ne", "Na", "Mg", 
          "Al", "Si", "P", "S", "Cl", "Ar", "K", "Ca", "Sc", "Ti", "V", "Cr", 
          "Mn", "Fe", "Co", "Ni", "Cu", "Zn", "Ga", "Ge", "As", "Se", "Br", 
          "Kr", "Rb", "Sr", "Y", "Zr", "Nb", "Mo", "Tc", "Ru", "Rh", "Pd", 
          "Ag", "Cd", "In", "Sn", "Sb", "Te", "I", "Xe", "Cs", "Ba", "La", 
          "Ce", "Pr", "Nd", "Pm", "Sm", "Eu", "Gd", "Tb", "Dy", "Ho", "Er", 
          "Tm", "Yb", "Lu", "Hf", "Ta", "W", "Re", "Os", "Ir", "Pt", "Au", 
          "Hg", "Tl", "Pb", "Bi", "Po", "At", "Rn", "Fr", "Ra", "Ac", "Th", 
          "Pa", "U", "Np", "Pu", "Am", "Cm", "Bk", "Cf", "Es", "Fm", "Md", 
          "No", "Lr", "Rf", "Db", "Sg", "Bh", "Hs", "Mt", "Ds", "Rg", "Cn", 
          "Nh", "Fl", "Mc", "Lv", "Ts", "Og", "Uub", "Uut", "Uuq", "Uup", 
          "Uuh", "Uus", "Uuo"}, {
         "h", "he", "li", "be", "b", "c", "n", "o", "f", "ne", "na", "mg", 
          "al", "si", "p", "s", "cl", "ar", "k", "ca", "sc", "ti", "v", "cr", 
          "mn", "fe", "co", "ni", "cu", "zn", "ga", "ge", "as", "se", "br", 
          "kr", "rb", "sr", "y", "zr", "nb", "mo", "tc", "ru", "rh", "pd", 
          "ag", "cd", "in", "sn", "sb", "te", "i", "xe", "cs", "ba", "la", 
          "ce", "pr", "nd", "pm", "sm", "eu", "gd", "tb", "dy", "ho", "er", 
          "tm", "yb", "lu", "hf", "ta", "w", "re", "os", "ir", "pt", "au", 
          "hg", "tl", "pb", "bi", "po", "at", "rn", "fr", "ra", "ac", "th", 
          "pa", "u", "np", "pu", "am", "cm", "bk", "cf", "es", "fm", "md", 
          "no", "lr", "rf", "db", "sg", "bh", "hs", "mt", "ds", "rg", "cn", 
          "nh", "fl", "mc", "lv", "ts", "og", "uub", "uut", "uuq", "uup", 
          "uuh", "uus", "uuo"}}, Replace[#, 
         Dispatch[{
          "h" -> RGBColor[0.65, 0.7, 0.7], "he" -> RGBColor[0.836713, 1., 1.],
            "li" -> RGBColor[0.799435, 0.543572, 0.997559], "be" -> 
           RGBColor[0.770565, 0.964309, 0.0442359], "b" -> 
           RGBColor[1., 0.709804, 0.709804], "c" -> RGBColor[0.4, 0.4, 0.4], 
           "n" -> RGBColor[0.291989, 0.437977, 0.888609], "o" -> 
           RGBColor[0.800498, 0.201504, 0.192061], "f" -> 
           RGBColor[0.578462, 0.85539, 0.408855], "ne" -> 
           RGBColor[0.677263, 0.928423, 0.955287], "na" -> 
           RGBColor[0.658708, 0.492173, 0.842842], "mg" -> 
           RGBColor[0.628274, 0.850553, 0.0782731], "al" -> 
           RGBColor[0.8913, 0.631904, 0.627399], "si" -> 
           RGBColor[0.941176, 0.784314, 0.627451], "p" -> 
           RGBColor[1., 0.501961, 0], "s" -> 
           RGBColor[0.90443, 0.97015, 0.13504], "cl" -> 
           RGBColor[0.412698, 0.932689, 0.166398], "ar" -> 
           RGBColor[0.546138, 0.844244, 0.892092], "k" -> 
           RGBColor[0.534026, 0.420729, 0.705621], "ca" -> 
           RGBColor[0.480072, 0.744591, 0.0955222], "sc" -> 
           RGBColor[0.901961, 0.901961, 0.901961], "ti" -> 
           RGBColor[0.74902, 0.760784, 0.780392], "v" -> 
           RGBColor[0.65098, 0.65098, 0.670588], "cr" -> 
           RGBColor[0.541176, 0.6, 0.780392], "mn" -> 
           RGBColor[0.611765, 0.478431, 0.780392], "fe" -> 
           RGBColor[0.878431, 0.4, 0.2], "co" -> 
           RGBColor[0.941176, 0.564706, 0.627451], "ni" -> 
           RGBColor[0.313725, 0.815686, 0.313725], "cu" -> 
           RGBColor[0.784314, 0.501961, 0.2], "zn" -> 
           RGBColor[0.490196, 0.501961, 0.690196], "ga" -> 
           RGBColor[0.800757, 0.542666, 0.533513], "ge" -> 
           RGBColor[0.60508, 0.632465, 0.576489], "as" -> 
           RGBColor[0.741176, 0.501961, 0.890196], "se" -> 
           RGBColor[0.917248, 0.657833, 0.0706628], "br" -> 
           RGBColor[0.58847, 0.22163, 0.16064], "kr" -> 
           RGBColor[0.426019, 0.747462, 0.810413], "rb" -> 
           RGBColor[0.425391, 0.329242, 0.585895], "sr" -> 
           RGBColor[0.325959, 0.646423, 0.095983], "y" -> 
           RGBColor[0.531014, 1., 1.], "zr" -> 
           RGBColor[0.458599, 0.917466, 0.918573], "nb" -> 
           RGBColor[0.385036, 0.834854, 0.841681], "mo" -> 
           RGBColor[0.310325, 0.752163, 0.769323], "tc" -> 
           RGBColor[0.234466, 0.669394, 0.701499], "ru" -> 
           RGBColor[0.157459, 0.586546, 0.638209], "rh" -> 
           RGBColor[0.0793033, 0.50362, 0.579453], "pd" -> 
           RGBColor[0., 0.420615, 0.525231], "ag" -> 
           RGBColor[0.752941, 0.752941, 0.752941], "cd" -> 
           RGBColor[1., 0.85098, 0.560784], "in" -> 
           RGBColor[0.728371, 0.440594, 0.422196], "sn" -> 
           RGBColor[0.39799, 0.491477, 0.495586], "sb" -> 
           RGBColor[0.619608, 0.388235, 0.709804], "te" -> 
           RGBColor[0.816706, 0.451332, 0.0100947], "i" -> 
           RGBColor[0.580392, 0, 0.580392], "xe" -> 
           RGBColor[0.316906, 0.638078, 0.710252], "cs" -> 
           RGBColor[0.332803, 0.217712, 0.483666], "ba" -> 
           RGBColor[0.165935, 0.55605, 0.0796556], "la" -> 
           RGBColor[0.928084, 0.716075, 0.329427], "ce" -> 
           RGBColor[0.894824, 0.731424, 0.325131], "pr" -> 
           RGBColor[0.86523, 0.707999, 0.315261], "nd" -> 
           RGBColor[0.837836, 0.662974, 0.301635], "pm" -> 
           RGBColor[0.811992, 0.607859, 0.285626], "sm" -> 
           RGBColor[0.787563, 0.549894, 0.268279], "eu" -> 
           RGBColor[0.764628, 0.493261, 0.250405], "gd" -> 
           RGBColor[0.743177, 0.440115, 0.23269], "tb" -> 
           RGBColor[0.72281, 0.39143, 0.215783], "dy" -> 
           RGBColor[0.702434, 0.347663, 0.200392], "ho" -> 
           RGBColor[0.679962, 0.309234, 0.187368], "er" -> 
           RGBColor[0.652012, 0.276823, 0.17779], "tm" -> 
           RGBColor[0.613603, 0.251489, 0.173042], "yb" -> 
           RGBColor[0.557855, 0.234598, 0.17489], "lu" -> 
           RGBColor[0.475685, 0.227573, 0.18555], "hf" -> 
           RGBColor[0.781537, 0.717388, 0.716579], "ta" -> 
           RGBColor[0.734443, 0.544489, 0.683471], "w" -> 
           RGBColor[0.681179, 0.360409, 0.63675], "re" -> 
           RGBColor[0.605181, 0.367584, 0.556343], "os" -> 
           RGBColor[0.521806, 0.382125, 0.469204], "ir" -> 
           RGBColor[0.445624, 0.373159, 0.399069], "pt" -> 
           RGBColor[0.815686, 0.815686, 0.878431], "au" -> 
           RGBColor[1., 0.819608, 0.137255], "hg" -> 
           RGBColor[0.721569, 0.721569, 0.815686], "tl" -> 
           RGBColor[0.65098, 0.329412, 0.301961], "pb" -> 
           RGBColor[0.341176, 0.34902, 0.380392], "bi" -> 
           RGBColor[0.619608, 0.309804, 0.709804], "po" -> 
           RGBColor[0.670588, 0.360784, 0], "at" -> 
           RGBColor[0.458824, 0.309804, 0.270588], "rn" -> 
           RGBColor[0.218799, 0.516091, 0.591608], "fr" -> 
           RGBColor[0.25626, 0.0861372, 0.398932], "ra" -> 
           RGBColor[0., 0.473472, 0.04654], "ac" -> 
           RGBColor[0.322042, 0.71693, 0.988479], "th" -> 
           RGBColor[0.3608, 0.67166, 0.943003], "pa" -> 
           RGBColor[0.397469, 0.628, 0.898853], "u" -> 
           RGBColor[0.43205, 0.58595, 0.856029], "np" -> 
           RGBColor[0.464542, 0.54551, 0.814532], "pu" -> 
           RGBColor[0.494945, 0.506679, 0.774361], "am" -> 
           RGBColor[0.52326, 0.469458, 0.735517], "cm" -> 
           RGBColor[0.549486, 0.433847, 0.697999], "bk" -> 
           RGBColor[0.573624, 0.399845, 0.661808], "cf" -> 
           RGBColor[0.595673, 0.367454, 0.626942], "es" -> 
           RGBColor[0.615633, 0.336672, 0.593404], "fm" -> 
           RGBColor[0.633505, 0.307499, 0.561191], "md" -> 
           RGBColor[0.649288, 0.279937, 0.530305], "no" -> 
           RGBColor[0.662982, 0.253984, 0.500746], "lr" -> 
           RGBColor[0.674588, 0.22964, 0.472513], "rf" -> 
           RGBColor[0.684106, 0.206907, 0.445606], "db" -> 
           RGBColor[0.691534, 0.185783, 0.420025], "sg" -> 
           RGBColor[0.696874, 0.166269, 0.395772], "bh" -> 
           RGBColor[0.700126, 0.148365, 0.372844], "hs" -> 
           RGBColor[0.701289, 0.13207, 0.351243], "mt" -> 
           RGBColor[0.700363, 0.117385, 0.330968], "ds" -> 
           RGBColor[0.697348, 0.10431, 0.31202], "rg" -> 
           RGBColor[0.692245, 0.0928444, 0.294398], "cn" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "nh" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "fl" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "mc" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "lv" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "ts" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "og" -> 
           RGBColor[0.635401, 0.0528, 0.226184], "uub" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "uut" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "uuq" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "uup" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "uuh" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "uus" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "uuo" -> 
           RGBColor[0.635401, 0.0528, 0.226184]}]]& ][0.85], 
       ColorDataFunction[
       "Atoms", 
        "Named", {{
         "H", "He", "Li", "Be", "B", "C", "N", "O", "F", "Ne", "Na", "Mg", 
          "Al", "Si", "P", "S", "Cl", "Ar", "K", "Ca", "Sc", "Ti", "V", "Cr", 
          "Mn", "Fe", "Co", "Ni", "Cu", "Zn", "Ga", "Ge", "As", "Se", "Br", 
          "Kr", "Rb", "Sr", "Y", "Zr", "Nb", "Mo", "Tc", "Ru", "Rh", "Pd", 
          "Ag", "Cd", "In", "Sn", "Sb", "Te", "I", "Xe", "Cs", "Ba", "La", 
          "Ce", "Pr", "Nd", "Pm", "Sm", "Eu", "Gd", "Tb", "Dy", "Ho", "Er", 
          "Tm", "Yb", "Lu", "Hf", "Ta", "W", "Re", "Os", "Ir", "Pt", "Au", 
          "Hg", "Tl", "Pb", "Bi", "Po", "At", "Rn", "Fr", "Ra", "Ac", "Th", 
          "Pa", "U", "Np", "Pu", "Am", "Cm", "Bk", "Cf", "Es", "Fm", "Md", 
          "No", "Lr", "Rf", "Db", "Sg", "Bh", "Hs", "Mt", "Ds", "Rg", "Cn", 
          "Nh", "Fl", "Mc", "Lv", "Ts", "Og", "Uub", "Uut", "Uuq", "Uup", 
          "Uuh", "Uus", "Uuo"}, {
         "h", "he", "li", "be", "b", "c", "n", "o", "f", "ne", "na", "mg", 
          "al", "si", "p", "s", "cl", "ar", "k", "ca", "sc", "ti", "v", "cr", 
          "mn", "fe", "co", "ni", "cu", "zn", "ga", "ge", "as", "se", "br", 
          "kr", "rb", "sr", "y", "zr", "nb", "mo", "tc", "ru", "rh", "pd", 
          "ag", "cd", "in", "sn", "sb", "te", "i", "xe", "cs", "ba", "la", 
          "ce", "pr", "nd", "pm", "sm", "eu", "gd", "tb", "dy", "ho", "er", 
          "tm", "yb", "lu", "hf", "ta", "w", "re", "os", "ir", "pt", "au", 
          "hg", "tl", "pb", "bi", "po", "at", "rn", "fr", "ra", "ac", "th", 
          "pa", "u", "np", "pu", "am", "cm", "bk", "cf", "es", "fm", "md", 
          "no", "lr", "rf", "db", "sg", "bh", "hs", "mt", "ds", "rg", "cn", 
          "nh", "fl", "mc", "lv", "ts", "og", "uub", "uut", "uuq", "uup", 
          "uuh", "uus", "uuo"}}, Replace[#, 
         Dispatch[{
          "h" -> RGBColor[0.65, 0.7, 0.7], "he" -> RGBColor[0.836713, 1., 1.],
            "li" -> RGBColor[0.799435, 0.543572, 0.997559], "be" -> 
           RGBColor[0.770565, 0.964309, 0.0442359], "b" -> 
           RGBColor[1., 0.709804, 0.709804], "c" -> RGBColor[0.4, 0.4, 0.4], 
           "n" -> RGBColor[0.291989, 0.437977, 0.888609], "o" -> 
           RGBColor[0.800498, 0.201504, 0.192061], "f" -> 
           RGBColor[0.578462, 0.85539, 0.408855], "ne" -> 
           RGBColor[0.677263, 0.928423, 0.955287], "na" -> 
           RGBColor[0.658708, 0.492173, 0.842842], "mg" -> 
           RGBColor[0.628274, 0.850553, 0.0782731], "al" -> 
           RGBColor[0.8913, 0.631904, 0.627399], "si" -> 
           RGBColor[0.941176, 0.784314, 0.627451], "p" -> 
           RGBColor[1., 0.501961, 0], "s" -> 
           RGBColor[0.90443, 0.97015, 0.13504], "cl" -> 
           RGBColor[0.412698, 0.932689, 0.166398], "ar" -> 
           RGBColor[0.546138, 0.844244, 0.892092], "k" -> 
           RGBColor[0.534026, 0.420729, 0.705621], "ca" -> 
           RGBColor[0.480072, 0.744591, 0.0955222], "sc" -> 
           RGBColor[0.901961, 0.901961, 0.901961], "ti" -> 
           RGBColor[0.74902, 0.760784, 0.780392], "v" -> 
           RGBColor[0.65098, 0.65098, 0.670588], "cr" -> 
           RGBColor[0.541176, 0.6, 0.780392], "mn" -> 
           RGBColor[0.611765, 0.478431, 0.780392], "fe" -> 
           RGBColor[0.878431, 0.4, 0.2], "co" -> 
           RGBColor[0.941176, 0.564706, 0.627451], "ni" -> 
           RGBColor[0.313725, 0.815686, 0.313725], "cu" -> 
           RGBColor[0.784314, 0.501961, 0.2], "zn" -> 
           RGBColor[0.490196, 0.501961, 0.690196], "ga" -> 
           RGBColor[0.800757, 0.542666, 0.533513], "ge" -> 
           RGBColor[0.60508, 0.632465, 0.576489], "as" -> 
           RGBColor[0.741176, 0.501961, 0.890196], "se" -> 
           RGBColor[0.917248, 0.657833, 0.0706628], "br" -> 
           RGBColor[0.58847, 0.22163, 0.16064], "kr" -> 
           RGBColor[0.426019, 0.747462, 0.810413], "rb" -> 
           RGBColor[0.425391, 0.329242, 0.585895], "sr" -> 
           RGBColor[0.325959, 0.646423, 0.095983], "y" -> 
           RGBColor[0.531014, 1., 1.], "zr" -> 
           RGBColor[0.458599, 0.917466, 0.918573], "nb" -> 
           RGBColor[0.385036, 0.834854, 0.841681], "mo" -> 
           RGBColor[0.310325, 0.752163, 0.769323], "tc" -> 
           RGBColor[0.234466, 0.669394, 0.701499], "ru" -> 
           RGBColor[0.157459, 0.586546, 0.638209], "rh" -> 
           RGBColor[0.0793033, 0.50362, 0.579453], "pd" -> 
           RGBColor[0., 0.420615, 0.525231], "ag" -> 
           RGBColor[0.752941, 0.752941, 0.752941], "cd" -> 
           RGBColor[1., 0.85098, 0.560784], "in" -> 
           RGBColor[0.728371, 0.440594, 0.422196], "sn" -> 
           RGBColor[0.39799, 0.491477, 0.495586], "sb" -> 
           RGBColor[0.619608, 0.388235, 0.709804], "te" -> 
           RGBColor[0.816706, 0.451332, 0.0100947], "i" -> 
           RGBColor[0.580392, 0, 0.580392], "xe" -> 
           RGBColor[0.316906, 0.638078, 0.710252], "cs" -> 
           RGBColor[0.332803, 0.217712, 0.483666], "ba" -> 
           RGBColor[0.165935, 0.55605, 0.0796556], "la" -> 
           RGBColor[0.928084, 0.716075, 0.329427], "ce" -> 
           RGBColor[0.894824, 0.731424, 0.325131], "pr" -> 
           RGBColor[0.86523, 0.707999, 0.315261], "nd" -> 
           RGBColor[0.837836, 0.662974, 0.301635], "pm" -> 
           RGBColor[0.811992, 0.607859, 0.285626], "sm" -> 
           RGBColor[0.787563, 0.549894, 0.268279], "eu" -> 
           RGBColor[0.764628, 0.493261, 0.250405], "gd" -> 
           RGBColor[0.743177, 0.440115, 0.23269], "tb" -> 
           RGBColor[0.72281, 0.39143, 0.215783], "dy" -> 
           RGBColor[0.702434, 0.347663, 0.200392], "ho" -> 
           RGBColor[0.679962, 0.309234, 0.187368], "er" -> 
           RGBColor[0.652012, 0.276823, 0.17779], "tm" -> 
           RGBColor[0.613603, 0.251489, 0.173042], "yb" -> 
           RGBColor[0.557855, 0.234598, 0.17489], "lu" -> 
           RGBColor[0.475685, 0.227573, 0.18555], "hf" -> 
           RGBColor[0.781537, 0.717388, 0.716579], "ta" -> 
           RGBColor[0.734443, 0.544489, 0.683471], "w" -> 
           RGBColor[0.681179, 0.360409, 0.63675], "re" -> 
           RGBColor[0.605181, 0.367584, 0.556343], "os" -> 
           RGBColor[0.521806, 0.382125, 0.469204], "ir" -> 
           RGBColor[0.445624, 0.373159, 0.399069], "pt" -> 
           RGBColor[0.815686, 0.815686, 0.878431], "au" -> 
           RGBColor[1., 0.819608, 0.137255], "hg" -> 
           RGBColor[0.721569, 0.721569, 0.815686], "tl" -> 
           RGBColor[0.65098, 0.329412, 0.301961], "pb" -> 
           RGBColor[0.341176, 0.34902, 0.380392], "bi" -> 
           RGBColor[0.619608, 0.309804, 0.709804], "po" -> 
           RGBColor[0.670588, 0.360784, 0], "at" -> 
           RGBColor[0.458824, 0.309804, 0.270588], "rn" -> 
           RGBColor[0.218799, 0.516091, 0.591608], "fr" -> 
           RGBColor[0.25626, 0.0861372, 0.398932], "ra" -> 
           RGBColor[0., 0.473472, 0.04654], "ac" -> 
           RGBColor[0.322042, 0.71693, 0.988479], "th" -> 
           RGBColor[0.3608, 0.67166, 0.943003], "pa" -> 
           RGBColor[0.397469, 0.628, 0.898853], "u" -> 
           RGBColor[0.43205, 0.58595, 0.856029], "np" -> 
           RGBColor[0.464542, 0.54551, 0.814532], "pu" -> 
           RGBColor[0.494945, 0.506679, 0.774361], "am" -> 
           RGBColor[0.52326, 0.469458, 0.735517], "cm" -> 
           RGBColor[0.549486, 0.433847, 0.697999], "bk" -> 
           RGBColor[0.573624, 0.399845, 0.661808], "cf" -> 
           RGBColor[0.595673, 0.367454, 0.626942], "es" -> 
           RGBColor[0.615633, 0.336672, 0.593404], "fm" -> 
           RGBColor[0.633505, 0.307499, 0.561191], "md" -> 
           RGBColor[0.649288, 0.279937, 0.530305], "no" -> 
           RGBColor[0.662982, 0.253984, 0.500746], "lr" -> 
           RGBColor[0.674588, 0.22964, 0.472513], "rf" -> 
           RGBColor[0.684106, 0.206907, 0.445606], "db" -> 
           RGBColor[0.691534, 0.185783, 0.420025], "sg" -> 
           RGBColor[0.696874, 0.166269, 0.395772], "bh" -> 
           RGBColor[0.700126, 0.148365, 0.372844], "hs" -> 
           RGBColor[0.701289, 0.13207, 0.351243], "mt" -> 
           RGBColor[0.700363, 0.117385, 0.330968], "ds" -> 
           RGBColor[0.697348, 0.10431, 0.31202], "rg" -> 
           RGBColor[0.692245, 0.0928444, 0.294398], "cn" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "nh" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "fl" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "mc" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "lv" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "ts" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "og" -> 
           RGBColor[0.635401, 0.0528, 0.226184], "uub" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "uut" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "uuq" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "uup" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "uuh" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "uus" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "uuo" -> 
           RGBColor[0.635401, 0.0528, 0.226184]}]]& ][0.85], 
       ColorDataFunction[
       "Atoms", 
        "Named", {{
         "H", "He", "Li", "Be", "B", "C", "N", "O", "F", "Ne", "Na", "Mg", 
          "Al", "Si", "P", "S", "Cl", "Ar", "K", "Ca", "Sc", "Ti", "V", "Cr", 
          "Mn", "Fe", "Co", "Ni", "Cu", "Zn", "Ga", "Ge", "As", "Se", "Br", 
          "Kr", "Rb", "Sr", "Y", "Zr", "Nb", "Mo", "Tc", "Ru", "Rh", "Pd", 
          "Ag", "Cd", "In", "Sn", "Sb", "Te", "I", "Xe", "Cs", "Ba", "La", 
          "Ce", "Pr", "Nd", "Pm", "Sm", "Eu", "Gd", "Tb", "Dy", "Ho", "Er", 
          "Tm", "Yb", "Lu", "Hf", "Ta", "W", "Re", "Os", "Ir", "Pt", "Au", 
          "Hg", "Tl", "Pb", "Bi", "Po", "At", "Rn", "Fr", "Ra", "Ac", "Th", 
          "Pa", "U", "Np", "Pu", "Am", "Cm", "Bk", "Cf", "Es", "Fm", "Md", 
          "No", "Lr", "Rf", "Db", "Sg", "Bh", "Hs", "Mt", "Ds", "Rg", "Cn", 
          "Nh", "Fl", "Mc", "Lv", "Ts", "Og", "Uub", "Uut", "Uuq", "Uup", 
          "Uuh", "Uus", "Uuo"}, {
         "h", "he", "li", "be", "b", "c", "n", "o", "f", "ne", "na", "mg", 
          "al", "si", "p", "s", "cl", "ar", "k", "ca", "sc", "ti", "v", "cr", 
          "mn", "fe", "co", "ni", "cu", "zn", "ga", "ge", "as", "se", "br", 
          "kr", "rb", "sr", "y", "zr", "nb", "mo", "tc", "ru", "rh", "pd", 
          "ag", "cd", "in", "sn", "sb", "te", "i", "xe", "cs", "ba", "la", 
          "ce", "pr", "nd", "pm", "sm", "eu", "gd", "tb", "dy", "ho", "er", 
          "tm", "yb", "lu", "hf", "ta", "w", "re", "os", "ir", "pt", "au", 
          "hg", "tl", "pb", "bi", "po", "at", "rn", "fr", "ra", "ac", "th", 
          "pa", "u", "np", "pu", "am", "cm", "bk", "cf", "es", "fm", "md", 
          "no", "lr", "rf", "db", "sg", "bh", "hs", "mt", "ds", "rg", "cn", 
          "nh", "fl", "mc", "lv", "ts", "og", "uub", "uut", "uuq", "uup", 
          "uuh", "uus", "uuo"}}, Replace[#, 
         Dispatch[{
          "h" -> RGBColor[0.65, 0.7, 0.7], "he" -> RGBColor[0.836713, 1., 1.],
            "li" -> RGBColor[0.799435, 0.543572, 0.997559], "be" -> 
           RGBColor[0.770565, 0.964309, 0.0442359], "b" -> 
           RGBColor[1., 0.709804, 0.709804], "c" -> RGBColor[0.4, 0.4, 0.4], 
           "n" -> RGBColor[0.291989, 0.437977, 0.888609], "o" -> 
           RGBColor[0.800498, 0.201504, 0.192061], "f" -> 
           RGBColor[0.578462, 0.85539, 0.408855], "ne" -> 
           RGBColor[0.677263, 0.928423, 0.955287], "na" -> 
           RGBColor[0.658708, 0.492173, 0.842842], "mg" -> 
           RGBColor[0.628274, 0.850553, 0.0782731], "al" -> 
           RGBColor[0.8913, 0.631904, 0.627399], "si" -> 
           RGBColor[0.941176, 0.784314, 0.627451], "p" -> 
           RGBColor[1., 0.501961, 0], "s" -> 
           RGBColor[0.90443, 0.97015, 0.13504], "cl" -> 
           RGBColor[0.412698, 0.932689, 0.166398], "ar" -> 
           RGBColor[0.546138, 0.844244, 0.892092], "k" -> 
           RGBColor[0.534026, 0.420729, 0.705621], "ca" -> 
           RGBColor[0.480072, 0.744591, 0.0955222], "sc" -> 
           RGBColor[0.901961, 0.901961, 0.901961], "ti" -> 
           RGBColor[0.74902, 0.760784, 0.780392], "v" -> 
           RGBColor[0.65098, 0.65098, 0.670588], "cr" -> 
           RGBColor[0.541176, 0.6, 0.780392], "mn" -> 
           RGBColor[0.611765, 0.478431, 0.780392], "fe" -> 
           RGBColor[0.878431, 0.4, 0.2], "co" -> 
           RGBColor[0.941176, 0.564706, 0.627451], "ni" -> 
           RGBColor[0.313725, 0.815686, 0.313725], "cu" -> 
           RGBColor[0.784314, 0.501961, 0.2], "zn" -> 
           RGBColor[0.490196, 0.501961, 0.690196], "ga" -> 
           RGBColor[0.800757, 0.542666, 0.533513], "ge" -> 
           RGBColor[0.60508, 0.632465, 0.576489], "as" -> 
           RGBColor[0.741176, 0.501961, 0.890196], "se" -> 
           RGBColor[0.917248, 0.657833, 0.0706628], "br" -> 
           RGBColor[0.58847, 0.22163, 0.16064], "kr" -> 
           RGBColor[0.426019, 0.747462, 0.810413], "rb" -> 
           RGBColor[0.425391, 0.329242, 0.585895], "sr" -> 
           RGBColor[0.325959, 0.646423, 0.095983], "y" -> 
           RGBColor[0.531014, 1., 1.], "zr" -> 
           RGBColor[0.458599, 0.917466, 0.918573], "nb" -> 
           RGBColor[0.385036, 0.834854, 0.841681], "mo" -> 
           RGBColor[0.310325, 0.752163, 0.769323], "tc" -> 
           RGBColor[0.234466, 0.669394, 0.701499], "ru" -> 
           RGBColor[0.157459, 0.586546, 0.638209], "rh" -> 
           RGBColor[0.0793033, 0.50362, 0.579453], "pd" -> 
           RGBColor[0., 0.420615, 0.525231], "ag" -> 
           RGBColor[0.752941, 0.752941, 0.752941], "cd" -> 
           RGBColor[1., 0.85098, 0.560784], "in" -> 
           RGBColor[0.728371, 0.440594, 0.422196], "sn" -> 
           RGBColor[0.39799, 0.491477, 0.495586], "sb" -> 
           RGBColor[0.619608, 0.388235, 0.709804], "te" -> 
           RGBColor[0.816706, 0.451332, 0.0100947], "i" -> 
           RGBColor[0.580392, 0, 0.580392], "xe" -> 
           RGBColor[0.316906, 0.638078, 0.710252], "cs" -> 
           RGBColor[0.332803, 0.217712, 0.483666], "ba" -> 
           RGBColor[0.165935, 0.55605, 0.0796556], "la" -> 
           RGBColor[0.928084, 0.716075, 0.329427], "ce" -> 
           RGBColor[0.894824, 0.731424, 0.325131], "pr" -> 
           RGBColor[0.86523, 0.707999, 0.315261], "nd" -> 
           RGBColor[0.837836, 0.662974, 0.301635], "pm" -> 
           RGBColor[0.811992, 0.607859, 0.285626], "sm" -> 
           RGBColor[0.787563, 0.549894, 0.268279], "eu" -> 
           RGBColor[0.764628, 0.493261, 0.250405], "gd" -> 
           RGBColor[0.743177, 0.440115, 0.23269], "tb" -> 
           RGBColor[0.72281, 0.39143, 0.215783], "dy" -> 
           RGBColor[0.702434, 0.347663, 0.200392], "ho" -> 
           RGBColor[0.679962, 0.309234, 0.187368], "er" -> 
           RGBColor[0.652012, 0.276823, 0.17779], "tm" -> 
           RGBColor[0.613603, 0.251489, 0.173042], "yb" -> 
           RGBColor[0.557855, 0.234598, 0.17489], "lu" -> 
           RGBColor[0.475685, 0.227573, 0.18555], "hf" -> 
           RGBColor[0.781537, 0.717388, 0.716579], "ta" -> 
           RGBColor[0.734443, 0.544489, 0.683471], "w" -> 
           RGBColor[0.681179, 0.360409, 0.63675], "re" -> 
           RGBColor[0.605181, 0.367584, 0.556343], "os" -> 
           RGBColor[0.521806, 0.382125, 0.469204], "ir" -> 
           RGBColor[0.445624, 0.373159, 0.399069], "pt" -> 
           RGBColor[0.815686, 0.815686, 0.878431], "au" -> 
           RGBColor[1., 0.819608, 0.137255], "hg" -> 
           RGBColor[0.721569, 0.721569, 0.815686], "tl" -> 
           RGBColor[0.65098, 0.329412, 0.301961], "pb" -> 
           RGBColor[0.341176, 0.34902, 0.380392], "bi" -> 
           RGBColor[0.619608, 0.309804, 0.709804], "po" -> 
           RGBColor[0.670588, 0.360784, 0], "at" -> 
           RGBColor[0.458824, 0.309804, 0.270588], "rn" -> 
           RGBColor[0.218799, 0.516091, 0.591608], "fr" -> 
           RGBColor[0.25626, 0.0861372, 0.398932], "ra" -> 
           RGBColor[0., 0.473472, 0.04654], "ac" -> 
           RGBColor[0.322042, 0.71693, 0.988479], "th" -> 
           RGBColor[0.3608, 0.67166, 0.943003], "pa" -> 
           RGBColor[0.397469, 0.628, 0.898853], "u" -> 
           RGBColor[0.43205, 0.58595, 0.856029], "np" -> 
           RGBColor[0.464542, 0.54551, 0.814532], "pu" -> 
           RGBColor[0.494945, 0.506679, 0.774361], "am" -> 
           RGBColor[0.52326, 0.469458, 0.735517], "cm" -> 
           RGBColor[0.549486, 0.433847, 0.697999], "bk" -> 
           RGBColor[0.573624, 0.399845, 0.661808], "cf" -> 
           RGBColor[0.595673, 0.367454, 0.626942], "es" -> 
           RGBColor[0.615633, 0.336672, 0.593404], "fm" -> 
           RGBColor[0.633505, 0.307499, 0.561191], "md" -> 
           RGBColor[0.649288, 0.279937, 0.530305], "no" -> 
           RGBColor[0.662982, 0.253984, 0.500746], "lr" -> 
           RGBColor[0.674588, 0.22964, 0.472513], "rf" -> 
           RGBColor[0.684106, 0.206907, 0.445606], "db" -> 
           RGBColor[0.691534, 0.185783, 0.420025], "sg" -> 
           RGBColor[0.696874, 0.166269, 0.395772], "bh" -> 
           RGBColor[0.700126, 0.148365, 0.372844], "hs" -> 
           RGBColor[0.701289, 0.13207, 0.351243], "mt" -> 
           RGBColor[0.700363, 0.117385, 0.330968], "ds" -> 
           RGBColor[0.697348, 0.10431, 0.31202], "rg" -> 
           RGBColor[0.692245, 0.0928444, 0.294398], "cn" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "nh" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "fl" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "mc" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "lv" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "ts" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "og" -> 
           RGBColor[0.635401, 0.0528, 0.226184], "uub" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "uut" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "uuq" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "uup" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "uuh" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "uus" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "uuo" -> 
           RGBColor[0.635401, 0.0528, 0.226184]}]]& ][0.85], 
       ColorDataFunction[
       "Atoms", 
        "Named", {{
         "H", "He", "Li", "Be", "B", "C", "N", "O", "F", "Ne", "Na", "Mg", 
          "Al", "Si", "P", "S", "Cl", "Ar", "K", "Ca", "Sc", "Ti", "V", "Cr", 
          "Mn", "Fe", "Co", "Ni", "Cu", "Zn", "Ga", "Ge", "As", "Se", "Br", 
          "Kr", "Rb", "Sr", "Y", "Zr", "Nb", "Mo", "Tc", "Ru", "Rh", "Pd", 
          "Ag", "Cd", "In", "Sn", "Sb", "Te", "I", "Xe", "Cs", "Ba", "La", 
          "Ce", "Pr", "Nd", "Pm", "Sm", "Eu", "Gd", "Tb", "Dy", "Ho", "Er", 
          "Tm", "Yb", "Lu", "Hf", "Ta", "W", "Re", "Os", "Ir", "Pt", "Au", 
          "Hg", "Tl", "Pb", "Bi", "Po", "At", "Rn", "Fr", "Ra", "Ac", "Th", 
          "Pa", "U", "Np", "Pu", "Am", "Cm", "Bk", "Cf", "Es", "Fm", "Md", 
          "No", "Lr", "Rf", "Db", "Sg", "Bh", "Hs", "Mt", "Ds", "Rg", "Cn", 
          "Nh", "Fl", "Mc", "Lv", "Ts", "Og", "Uub", "Uut", "Uuq", "Uup", 
          "Uuh", "Uus", "Uuo"}, {
         "h", "he", "li", "be", "b", "c", "n", "o", "f", "ne", "na", "mg", 
          "al", "si", "p", "s", "cl", "ar", "k", "ca", "sc", "ti", "v", "cr", 
          "mn", "fe", "co", "ni", "cu", "zn", "ga", "ge", "as", "se", "br", 
          "kr", "rb", "sr", "y", "zr", "nb", "mo", "tc", "ru", "rh", "pd", 
          "ag", "cd", "in", "sn", "sb", "te", "i", "xe", "cs", "ba", "la", 
          "ce", "pr", "nd", "pm", "sm", "eu", "gd", "tb", "dy", "ho", "er", 
          "tm", "yb", "lu", "hf", "ta", "w", "re", "os", "ir", "pt", "au", 
          "hg", "tl", "pb", "bi", "po", "at", "rn", "fr", "ra", "ac", "th", 
          "pa", "u", "np", "pu", "am", "cm", "bk", "cf", "es", "fm", "md", 
          "no", "lr", "rf", "db", "sg", "bh", "hs", "mt", "ds", "rg", "cn", 
          "nh", "fl", "mc", "lv", "ts", "og", "uub", "uut", "uuq", "uup", 
          "uuh", "uus", "uuo"}}, Replace[#, 
         Dispatch[{
          "h" -> RGBColor[0.65, 0.7, 0.7], "he" -> RGBColor[0.836713, 1., 1.],
            "li" -> RGBColor[0.799435, 0.543572, 0.997559], "be" -> 
           RGBColor[0.770565, 0.964309, 0.0442359], "b" -> 
           RGBColor[1., 0.709804, 0.709804], "c" -> RGBColor[0.4, 0.4, 0.4], 
           "n" -> RGBColor[0.291989, 0.437977, 0.888609], "o" -> 
           RGBColor[0.800498, 0.201504, 0.192061], "f" -> 
           RGBColor[0.578462, 0.85539, 0.408855], "ne" -> 
           RGBColor[0.677263, 0.928423, 0.955287], "na" -> 
           RGBColor[0.658708, 0.492173, 0.842842], "mg" -> 
           RGBColor[0.628274, 0.850553, 0.0782731], "al" -> 
           RGBColor[0.8913, 0.631904, 0.627399], "si" -> 
           RGBColor[0.941176, 0.784314, 0.627451], "p" -> 
           RGBColor[1., 0.501961, 0], "s" -> 
           RGBColor[0.90443, 0.97015, 0.13504], "cl" -> 
           RGBColor[0.412698, 0.932689, 0.166398], "ar" -> 
           RGBColor[0.546138, 0.844244, 0.892092], "k" -> 
           RGBColor[0.534026, 0.420729, 0.705621], "ca" -> 
           RGBColor[0.480072, 0.744591, 0.0955222], "sc" -> 
           RGBColor[0.901961, 0.901961, 0.901961], "ti" -> 
           RGBColor[0.74902, 0.760784, 0.780392], "v" -> 
           RGBColor[0.65098, 0.65098, 0.670588], "cr" -> 
           RGBColor[0.541176, 0.6, 0.780392], "mn" -> 
           RGBColor[0.611765, 0.478431, 0.780392], "fe" -> 
           RGBColor[0.878431, 0.4, 0.2], "co" -> 
           RGBColor[0.941176, 0.564706, 0.627451], "ni" -> 
           RGBColor[0.313725, 0.815686, 0.313725], "cu" -> 
           RGBColor[0.784314, 0.501961, 0.2], "zn" -> 
           RGBColor[0.490196, 0.501961, 0.690196], "ga" -> 
           RGBColor[0.800757, 0.542666, 0.533513], "ge" -> 
           RGBColor[0.60508, 0.632465, 0.576489], "as" -> 
           RGBColor[0.741176, 0.501961, 0.890196], "se" -> 
           RGBColor[0.917248, 0.657833, 0.0706628], "br" -> 
           RGBColor[0.58847, 0.22163, 0.16064], "kr" -> 
           RGBColor[0.426019, 0.747462, 0.810413], "rb" -> 
           RGBColor[0.425391, 0.329242, 0.585895], "sr" -> 
           RGBColor[0.325959, 0.646423, 0.095983], "y" -> 
           RGBColor[0.531014, 1., 1.], "zr" -> 
           RGBColor[0.458599, 0.917466, 0.918573], "nb" -> 
           RGBColor[0.385036, 0.834854, 0.841681], "mo" -> 
           RGBColor[0.310325, 0.752163, 0.769323], "tc" -> 
           RGBColor[0.234466, 0.669394, 0.701499], "ru" -> 
           RGBColor[0.157459, 0.586546, 0.638209], "rh" -> 
           RGBColor[0.0793033, 0.50362, 0.579453], "pd" -> 
           RGBColor[0., 0.420615, 0.525231], "ag" -> 
           RGBColor[0.752941, 0.752941, 0.752941], "cd" -> 
           RGBColor[1., 0.85098, 0.560784], "in" -> 
           RGBColor[0.728371, 0.440594, 0.422196], "sn" -> 
           RGBColor[0.39799, 0.491477, 0.495586], "sb" -> 
           RGBColor[0.619608, 0.388235, 0.709804], "te" -> 
           RGBColor[0.816706, 0.451332, 0.0100947], "i" -> 
           RGBColor[0.580392, 0, 0.580392], "xe" -> 
           RGBColor[0.316906, 0.638078, 0.710252], "cs" -> 
           RGBColor[0.332803, 0.217712, 0.483666], "ba" -> 
           RGBColor[0.165935, 0.55605, 0.0796556], "la" -> 
           RGBColor[0.928084, 0.716075, 0.329427], "ce" -> 
           RGBColor[0.894824, 0.731424, 0.325131], "pr" -> 
           RGBColor[0.86523, 0.707999, 0.315261], "nd" -> 
           RGBColor[0.837836, 0.662974, 0.301635], "pm" -> 
           RGBColor[0.811992, 0.607859, 0.285626], "sm" -> 
           RGBColor[0.787563, 0.549894, 0.268279], "eu" -> 
           RGBColor[0.764628, 0.493261, 0.250405], "gd" -> 
           RGBColor[0.743177, 0.440115, 0.23269], "tb" -> 
           RGBColor[0.72281, 0.39143, 0.215783], "dy" -> 
           RGBColor[0.702434, 0.347663, 0.200392], "ho" -> 
           RGBColor[0.679962, 0.309234, 0.187368], "er" -> 
           RGBColor[0.652012, 0.276823, 0.17779], "tm" -> 
           RGBColor[0.613603, 0.251489, 0.173042], "yb" -> 
           RGBColor[0.557855, 0.234598, 0.17489], "lu" -> 
           RGBColor[0.475685, 0.227573, 0.18555], "hf" -> 
           RGBColor[0.781537, 0.717388, 0.716579], "ta" -> 
           RGBColor[0.734443, 0.544489, 0.683471], "w" -> 
           RGBColor[0.681179, 0.360409, 0.63675], "re" -> 
           RGBColor[0.605181, 0.367584, 0.556343], "os" -> 
           RGBColor[0.521806, 0.382125, 0.469204], "ir" -> 
           RGBColor[0.445624, 0.373159, 0.399069], "pt" -> 
           RGBColor[0.815686, 0.815686, 0.878431], "au" -> 
           RGBColor[1., 0.819608, 0.137255], "hg" -> 
           RGBColor[0.721569, 0.721569, 0.815686], "tl" -> 
           RGBColor[0.65098, 0.329412, 0.301961], "pb" -> 
           RGBColor[0.341176, 0.34902, 0.380392], "bi" -> 
           RGBColor[0.619608, 0.309804, 0.709804], "po" -> 
           RGBColor[0.670588, 0.360784, 0], "at" -> 
           RGBColor[0.458824, 0.309804, 0.270588], "rn" -> 
           RGBColor[0.218799, 0.516091, 0.591608], "fr" -> 
           RGBColor[0.25626, 0.0861372, 0.398932], "ra" -> 
           RGBColor[0., 0.473472, 0.04654], "ac" -> 
           RGBColor[0.322042, 0.71693, 0.988479], "th" -> 
           RGBColor[0.3608, 0.67166, 0.943003], "pa" -> 
           RGBColor[0.397469, 0.628, 0.898853], "u" -> 
           RGBColor[0.43205, 0.58595, 0.856029], "np" -> 
           RGBColor[0.464542, 0.54551, 0.814532], "pu" -> 
           RGBColor[0.494945, 0.506679, 0.774361], "am" -> 
           RGBColor[0.52326, 0.469458, 0.735517], "cm" -> 
           RGBColor[0.549486, 0.433847, 0.697999], "bk" -> 
           RGBColor[0.573624, 0.399845, 0.661808], "cf" -> 
           RGBColor[0.595673, 0.367454, 0.626942], "es" -> 
           RGBColor[0.615633, 0.336672, 0.593404], "fm" -> 
           RGBColor[0.633505, 0.307499, 0.561191], "md" -> 
           RGBColor[0.649288, 0.279937, 0.530305], "no" -> 
           RGBColor[0.662982, 0.253984, 0.500746], "lr" -> 
           RGBColor[0.674588, 0.22964, 0.472513], "rf" -> 
           RGBColor[0.684106, 0.206907, 0.445606], "db" -> 
           RGBColor[0.691534, 0.185783, 0.420025], "sg" -> 
           RGBColor[0.696874, 0.166269, 0.395772], "bh" -> 
           RGBColor[0.700126, 0.148365, 0.372844], "hs" -> 
           RGBColor[0.701289, 0.13207, 0.351243], "mt" -> 
           RGBColor[0.700363, 0.117385, 0.330968], "ds" -> 
           RGBColor[0.697348, 0.10431, 0.31202], "rg" -> 
           RGBColor[0.692245, 0.0928444, 0.294398], "cn" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "nh" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "fl" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "mc" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "lv" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "ts" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "og" -> 
           RGBColor[0.635401, 0.0528, 0.226184], "uub" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "uut" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "uuq" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "uup" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "uuh" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "uus" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "uuo" -> 
           RGBColor[0.635401, 0.0528, 0.226184]}]]& ][0.85], 
       ColorDataFunction[
       "Atoms", 
        "Named", {{
         "H", "He", "Li", "Be", "B", "C", "N", "O", "F", "Ne", "Na", "Mg", 
          "Al", "Si", "P", "S", "Cl", "Ar", "K", "Ca", "Sc", "Ti", "V", "Cr", 
          "Mn", "Fe", "Co", "Ni", "Cu", "Zn", "Ga", "Ge", "As", "Se", "Br", 
          "Kr", "Rb", "Sr", "Y", "Zr", "Nb", "Mo", "Tc", "Ru", "Rh", "Pd", 
          "Ag", "Cd", "In", "Sn", "Sb", "Te", "I", "Xe", "Cs", "Ba", "La", 
          "Ce", "Pr", "Nd", "Pm", "Sm", "Eu", "Gd", "Tb", "Dy", "Ho", "Er", 
          "Tm", "Yb", "Lu", "Hf", "Ta", "W", "Re", "Os", "Ir", "Pt", "Au", 
          "Hg", "Tl", "Pb", "Bi", "Po", "At", "Rn", "Fr", "Ra", "Ac", "Th", 
          "Pa", "U", "Np", "Pu", "Am", "Cm", "Bk", "Cf", "Es", "Fm", "Md", 
          "No", "Lr", "Rf", "Db", "Sg", "Bh", "Hs", "Mt", "Ds", "Rg", "Cn", 
          "Nh", "Fl", "Mc", "Lv", "Ts", "Og", "Uub", "Uut", "Uuq", "Uup", 
          "Uuh", "Uus", "Uuo"}, {
         "h", "he", "li", "be", "b", "c", "n", "o", "f", "ne", "na", "mg", 
          "al", "si", "p", "s", "cl", "ar", "k", "ca", "sc", "ti", "v", "cr", 
          "mn", "fe", "co", "ni", "cu", "zn", "ga", "ge", "as", "se", "br", 
          "kr", "rb", "sr", "y", "zr", "nb", "mo", "tc", "ru", "rh", "pd", 
          "ag", "cd", "in", "sn", "sb", "te", "i", "xe", "cs", "ba", "la", 
          "ce", "pr", "nd", "pm", "sm", "eu", "gd", "tb", "dy", "ho", "er", 
          "tm", "yb", "lu", "hf", "ta", "w", "re", "os", "ir", "pt", "au", 
          "hg", "tl", "pb", "bi", "po", "at", "rn", "fr", "ra", "ac", "th", 
          "pa", "u", "np", "pu", "am", "cm", "bk", "cf", "es", "fm", "md", 
          "no", "lr", "rf", "db", "sg", "bh", "hs", "mt", "ds", "rg", "cn", 
          "nh", "fl", "mc", "lv", "ts", "og", "uub", "uut", "uuq", "uup", 
          "uuh", "uus", "uuo"}}, Replace[#, 
         Dispatch[{
          "h" -> RGBColor[0.65, 0.7, 0.7], "he" -> RGBColor[0.836713, 1., 1.],
            "li" -> RGBColor[0.799435, 0.543572, 0.997559], "be" -> 
           RGBColor[0.770565, 0.964309, 0.0442359], "b" -> 
           RGBColor[1., 0.709804, 0.709804], "c" -> RGBColor[0.4, 0.4, 0.4], 
           "n" -> RGBColor[0.291989, 0.437977, 0.888609], "o" -> 
           RGBColor[0.800498, 0.201504, 0.192061], "f" -> 
           RGBColor[0.578462, 0.85539, 0.408855], "ne" -> 
           RGBColor[0.677263, 0.928423, 0.955287], "na" -> 
           RGBColor[0.658708, 0.492173, 0.842842], "mg" -> 
           RGBColor[0.628274, 0.850553, 0.0782731], "al" -> 
           RGBColor[0.8913, 0.631904, 0.627399], "si" -> 
           RGBColor[0.941176, 0.784314, 0.627451], "p" -> 
           RGBColor[1., 0.501961, 0], "s" -> 
           RGBColor[0.90443, 0.97015, 0.13504], "cl" -> 
           RGBColor[0.412698, 0.932689, 0.166398], "ar" -> 
           RGBColor[0.546138, 0.844244, 0.892092], "k" -> 
           RGBColor[0.534026, 0.420729, 0.705621], "ca" -> 
           RGBColor[0.480072, 0.744591, 0.0955222], "sc" -> 
           RGBColor[0.901961, 0.901961, 0.901961], "ti" -> 
           RGBColor[0.74902, 0.760784, 0.780392], "v" -> 
           RGBColor[0.65098, 0.65098, 0.670588], "cr" -> 
           RGBColor[0.541176, 0.6, 0.780392], "mn" -> 
           RGBColor[0.611765, 0.478431, 0.780392], "fe" -> 
           RGBColor[0.878431, 0.4, 0.2], "co" -> 
           RGBColor[0.941176, 0.564706, 0.627451], "ni" -> 
           RGBColor[0.313725, 0.815686, 0.313725], "cu" -> 
           RGBColor[0.784314, 0.501961, 0.2], "zn" -> 
           RGBColor[0.490196, 0.501961, 0.690196], "ga" -> 
           RGBColor[0.800757, 0.542666, 0.533513], "ge" -> 
           RGBColor[0.60508, 0.632465, 0.576489], "as" -> 
           RGBColor[0.741176, 0.501961, 0.890196], "se" -> 
           RGBColor[0.917248, 0.657833, 0.0706628], "br" -> 
           RGBColor[0.58847, 0.22163, 0.16064], "kr" -> 
           RGBColor[0.426019, 0.747462, 0.810413], "rb" -> 
           RGBColor[0.425391, 0.329242, 0.585895], "sr" -> 
           RGBColor[0.325959, 0.646423, 0.095983], "y" -> 
           RGBColor[0.531014, 1., 1.], "zr" -> 
           RGBColor[0.458599, 0.917466, 0.918573], "nb" -> 
           RGBColor[0.385036, 0.834854, 0.841681], "mo" -> 
           RGBColor[0.310325, 0.752163, 0.769323], "tc" -> 
           RGBColor[0.234466, 0.669394, 0.701499], "ru" -> 
           RGBColor[0.157459, 0.586546, 0.638209], "rh" -> 
           RGBColor[0.0793033, 0.50362, 0.579453], "pd" -> 
           RGBColor[0., 0.420615, 0.525231], "ag" -> 
           RGBColor[0.752941, 0.752941, 0.752941], "cd" -> 
           RGBColor[1., 0.85098, 0.560784], "in" -> 
           RGBColor[0.728371, 0.440594, 0.422196], "sn" -> 
           RGBColor[0.39799, 0.491477, 0.495586], "sb" -> 
           RGBColor[0.619608, 0.388235, 0.709804], "te" -> 
           RGBColor[0.816706, 0.451332, 0.0100947], "i" -> 
           RGBColor[0.580392, 0, 0.580392], "xe" -> 
           RGBColor[0.316906, 0.638078, 0.710252], "cs" -> 
           RGBColor[0.332803, 0.217712, 0.483666], "ba" -> 
           RGBColor[0.165935, 0.55605, 0.0796556], "la" -> 
           RGBColor[0.928084, 0.716075, 0.329427], "ce" -> 
           RGBColor[0.894824, 0.731424, 0.325131], "pr" -> 
           RGBColor[0.86523, 0.707999, 0.315261], "nd" -> 
           RGBColor[0.837836, 0.662974, 0.301635], "pm" -> 
           RGBColor[0.811992, 0.607859, 0.285626], "sm" -> 
           RGBColor[0.787563, 0.549894, 0.268279], "eu" -> 
           RGBColor[0.764628, 0.493261, 0.250405], "gd" -> 
           RGBColor[0.743177, 0.440115, 0.23269], "tb" -> 
           RGBColor[0.72281, 0.39143, 0.215783], "dy" -> 
           RGBColor[0.702434, 0.347663, 0.200392], "ho" -> 
           RGBColor[0.679962, 0.309234, 0.187368], "er" -> 
           RGBColor[0.652012, 0.276823, 0.17779], "tm" -> 
           RGBColor[0.613603, 0.251489, 0.173042], "yb" -> 
           RGBColor[0.557855, 0.234598, 0.17489], "lu" -> 
           RGBColor[0.475685, 0.227573, 0.18555], "hf" -> 
           RGBColor[0.781537, 0.717388, 0.716579], "ta" -> 
           RGBColor[0.734443, 0.544489, 0.683471], "w" -> 
           RGBColor[0.681179, 0.360409, 0.63675], "re" -> 
           RGBColor[0.605181, 0.367584, 0.556343], "os" -> 
           RGBColor[0.521806, 0.382125, 0.469204], "ir" -> 
           RGBColor[0.445624, 0.373159, 0.399069], "pt" -> 
           RGBColor[0.815686, 0.815686, 0.878431], "au" -> 
           RGBColor[1., 0.819608, 0.137255], "hg" -> 
           RGBColor[0.721569, 0.721569, 0.815686], "tl" -> 
           RGBColor[0.65098, 0.329412, 0.301961], "pb" -> 
           RGBColor[0.341176, 0.34902, 0.380392], "bi" -> 
           RGBColor[0.619608, 0.309804, 0.709804], "po" -> 
           RGBColor[0.670588, 0.360784, 0], "at" -> 
           RGBColor[0.458824, 0.309804, 0.270588], "rn" -> 
           RGBColor[0.218799, 0.516091, 0.591608], "fr" -> 
           RGBColor[0.25626, 0.0861372, 0.398932], "ra" -> 
           RGBColor[0., 0.473472, 0.04654], "ac" -> 
           RGBColor[0.322042, 0.71693, 0.988479], "th" -> 
           RGBColor[0.3608, 0.67166, 0.943003], "pa" -> 
           RGBColor[0.397469, 0.628, 0.898853], "u" -> 
           RGBColor[0.43205, 0.58595, 0.856029], "np" -> 
           RGBColor[0.464542, 0.54551, 0.814532], "pu" -> 
           RGBColor[0.494945, 0.506679, 0.774361], "am" -> 
           RGBColor[0.52326, 0.469458, 0.735517], "cm" -> 
           RGBColor[0.549486, 0.433847, 0.697999], "bk" -> 
           RGBColor[0.573624, 0.399845, 0.661808], "cf" -> 
           RGBColor[0.595673, 0.367454, 0.626942], "es" -> 
           RGBColor[0.615633, 0.336672, 0.593404], "fm" -> 
           RGBColor[0.633505, 0.307499, 0.561191], "md" -> 
           RGBColor[0.649288, 0.279937, 0.530305], "no" -> 
           RGBColor[0.662982, 0.253984, 0.500746], "lr" -> 
           RGBColor[0.674588, 0.22964, 0.472513], "rf" -> 
           RGBColor[0.684106, 0.206907, 0.445606], "db" -> 
           RGBColor[0.691534, 0.185783, 0.420025], "sg" -> 
           RGBColor[0.696874, 0.166269, 0.395772], "bh" -> 
           RGBColor[0.700126, 0.148365, 0.372844], "hs" -> 
           RGBColor[0.701289, 0.13207, 0.351243], "mt" -> 
           RGBColor[0.700363, 0.117385, 0.330968], "ds" -> 
           RGBColor[0.697348, 0.10431, 0.31202], "rg" -> 
           RGBColor[0.692245, 0.0928444, 0.294398], "cn" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "nh" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "fl" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "mc" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "lv" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "ts" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "og" -> 
           RGBColor[0.635401, 0.0528, 0.226184], "uub" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "uut" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "uuq" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "uup" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "uuh" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "uus" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "uuo" -> 
           RGBColor[0.635401, 0.0528, 0.226184]}]]& ][0.85], 
       ColorDataFunction[
       "Atoms", 
        "Named", {{
         "H", "He", "Li", "Be", "B", "C", "N", "O", "F", "Ne", "Na", "Mg", 
          "Al", "Si", "P", "S", "Cl", "Ar", "K", "Ca", "Sc", "Ti", "V", "Cr", 
          "Mn", "Fe", "Co", "Ni", "Cu", "Zn", "Ga", "Ge", "As", "Se", "Br", 
          "Kr", "Rb", "Sr", "Y", "Zr", "Nb", "Mo", "Tc", "Ru", "Rh", "Pd", 
          "Ag", "Cd", "In", "Sn", "Sb", "Te", "I", "Xe", "Cs", "Ba", "La", 
          "Ce", "Pr", "Nd", "Pm", "Sm", "Eu", "Gd", "Tb", "Dy", "Ho", "Er", 
          "Tm", "Yb", "Lu", "Hf", "Ta", "W", "Re", "Os", "Ir", "Pt", "Au", 
          "Hg", "Tl", "Pb", "Bi", "Po", "At", "Rn", "Fr", "Ra", "Ac", "Th", 
          "Pa", "U", "Np", "Pu", "Am", "Cm", "Bk", "Cf", "Es", "Fm", "Md", 
          "No", "Lr", "Rf", "Db", "Sg", "Bh", "Hs", "Mt", "Ds", "Rg", "Cn", 
          "Nh", "Fl", "Mc", "Lv", "Ts", "Og", "Uub", "Uut", "Uuq", "Uup", 
          "Uuh", "Uus", "Uuo"}, {
         "h", "he", "li", "be", "b", "c", "n", "o", "f", "ne", "na", "mg", 
          "al", "si", "p", "s", "cl", "ar", "k", "ca", "sc", "ti", "v", "cr", 
          "mn", "fe", "co", "ni", "cu", "zn", "ga", "ge", "as", "se", "br", 
          "kr", "rb", "sr", "y", "zr", "nb", "mo", "tc", "ru", "rh", "pd", 
          "ag", "cd", "in", "sn", "sb", "te", "i", "xe", "cs", "ba", "la", 
          "ce", "pr", "nd", "pm", "sm", "eu", "gd", "tb", "dy", "ho", "er", 
          "tm", "yb", "lu", "hf", "ta", "w", "re", "os", "ir", "pt", "au", 
          "hg", "tl", "pb", "bi", "po", "at", "rn", "fr", "ra", "ac", "th", 
          "pa", "u", "np", "pu", "am", "cm", "bk", "cf", "es", "fm", "md", 
          "no", "lr", "rf", "db", "sg", "bh", "hs", "mt", "ds", "rg", "cn", 
          "nh", "fl", "mc", "lv", "ts", "og", "uub", "uut", "uuq", "uup", 
          "uuh", "uus", "uuo"}}, Replace[#, 
         Dispatch[{
          "h" -> RGBColor[0.65, 0.7, 0.7], "he" -> RGBColor[0.836713, 1., 1.],
            "li" -> RGBColor[0.799435, 0.543572, 0.997559], "be" -> 
           RGBColor[0.770565, 0.964309, 0.0442359], "b" -> 
           RGBColor[1., 0.709804, 0.709804], "c" -> RGBColor[0.4, 0.4, 0.4], 
           "n" -> RGBColor[0.291989, 0.437977, 0.888609], "o" -> 
           RGBColor[0.800498, 0.201504, 0.192061], "f" -> 
           RGBColor[0.578462, 0.85539, 0.408855], "ne" -> 
           RGBColor[0.677263, 0.928423, 0.955287], "na" -> 
           RGBColor[0.658708, 0.492173, 0.842842], "mg" -> 
           RGBColor[0.628274, 0.850553, 0.0782731], "al" -> 
           RGBColor[0.8913, 0.631904, 0.627399], "si" -> 
           RGBColor[0.941176, 0.784314, 0.627451], "p" -> 
           RGBColor[1., 0.501961, 0], "s" -> 
           RGBColor[0.90443, 0.97015, 0.13504], "cl" -> 
           RGBColor[0.412698, 0.932689, 0.166398], "ar" -> 
           RGBColor[0.546138, 0.844244, 0.892092], "k" -> 
           RGBColor[0.534026, 0.420729, 0.705621], "ca" -> 
           RGBColor[0.480072, 0.744591, 0.0955222], "sc" -> 
           RGBColor[0.901961, 0.901961, 0.901961], "ti" -> 
           RGBColor[0.74902, 0.760784, 0.780392], "v" -> 
           RGBColor[0.65098, 0.65098, 0.670588], "cr" -> 
           RGBColor[0.541176, 0.6, 0.780392], "mn" -> 
           RGBColor[0.611765, 0.478431, 0.780392], "fe" -> 
           RGBColor[0.878431, 0.4, 0.2], "co" -> 
           RGBColor[0.941176, 0.564706, 0.627451], "ni" -> 
           RGBColor[0.313725, 0.815686, 0.313725], "cu" -> 
           RGBColor[0.784314, 0.501961, 0.2], "zn" -> 
           RGBColor[0.490196, 0.501961, 0.690196], "ga" -> 
           RGBColor[0.800757, 0.542666, 0.533513], "ge" -> 
           RGBColor[0.60508, 0.632465, 0.576489], "as" -> 
           RGBColor[0.741176, 0.501961, 0.890196], "se" -> 
           RGBColor[0.917248, 0.657833, 0.0706628], "br" -> 
           RGBColor[0.58847, 0.22163, 0.16064], "kr" -> 
           RGBColor[0.426019, 0.747462, 0.810413], "rb" -> 
           RGBColor[0.425391, 0.329242, 0.585895], "sr" -> 
           RGBColor[0.325959, 0.646423, 0.095983], "y" -> 
           RGBColor[0.531014, 1., 1.], "zr" -> 
           RGBColor[0.458599, 0.917466, 0.918573], "nb" -> 
           RGBColor[0.385036, 0.834854, 0.841681], "mo" -> 
           RGBColor[0.310325, 0.752163, 0.769323], "tc" -> 
           RGBColor[0.234466, 0.669394, 0.701499], "ru" -> 
           RGBColor[0.157459, 0.586546, 0.638209], "rh" -> 
           RGBColor[0.0793033, 0.50362, 0.579453], "pd" -> 
           RGBColor[0., 0.420615, 0.525231], "ag" -> 
           RGBColor[0.752941, 0.752941, 0.752941], "cd" -> 
           RGBColor[1., 0.85098, 0.560784], "in" -> 
           RGBColor[0.728371, 0.440594, 0.422196], "sn" -> 
           RGBColor[0.39799, 0.491477, 0.495586], "sb" -> 
           RGBColor[0.619608, 0.388235, 0.709804], "te" -> 
           RGBColor[0.816706, 0.451332, 0.0100947], "i" -> 
           RGBColor[0.580392, 0, 0.580392], "xe" -> 
           RGBColor[0.316906, 0.638078, 0.710252], "cs" -> 
           RGBColor[0.332803, 0.217712, 0.483666], "ba" -> 
           RGBColor[0.165935, 0.55605, 0.0796556], "la" -> 
           RGBColor[0.928084, 0.716075, 0.329427], "ce" -> 
           RGBColor[0.894824, 0.731424, 0.325131], "pr" -> 
           RGBColor[0.86523, 0.707999, 0.315261], "nd" -> 
           RGBColor[0.837836, 0.662974, 0.301635], "pm" -> 
           RGBColor[0.811992, 0.607859, 0.285626], "sm" -> 
           RGBColor[0.787563, 0.549894, 0.268279], "eu" -> 
           RGBColor[0.764628, 0.493261, 0.250405], "gd" -> 
           RGBColor[0.743177, 0.440115, 0.23269], "tb" -> 
           RGBColor[0.72281, 0.39143, 0.215783], "dy" -> 
           RGBColor[0.702434, 0.347663, 0.200392], "ho" -> 
           RGBColor[0.679962, 0.309234, 0.187368], "er" -> 
           RGBColor[0.652012, 0.276823, 0.17779], "tm" -> 
           RGBColor[0.613603, 0.251489, 0.173042], "yb" -> 
           RGBColor[0.557855, 0.234598, 0.17489], "lu" -> 
           RGBColor[0.475685, 0.227573, 0.18555], "hf" -> 
           RGBColor[0.781537, 0.717388, 0.716579], "ta" -> 
           RGBColor[0.734443, 0.544489, 0.683471], "w" -> 
           RGBColor[0.681179, 0.360409, 0.63675], "re" -> 
           RGBColor[0.605181, 0.367584, 0.556343], "os" -> 
           RGBColor[0.521806, 0.382125, 0.469204], "ir" -> 
           RGBColor[0.445624, 0.373159, 0.399069], "pt" -> 
           RGBColor[0.815686, 0.815686, 0.878431], "au" -> 
           RGBColor[1., 0.819608, 0.137255], "hg" -> 
           RGBColor[0.721569, 0.721569, 0.815686], "tl" -> 
           RGBColor[0.65098, 0.329412, 0.301961], "pb" -> 
           RGBColor[0.341176, 0.34902, 0.380392], "bi" -> 
           RGBColor[0.619608, 0.309804, 0.709804], "po" -> 
           RGBColor[0.670588, 0.360784, 0], "at" -> 
           RGBColor[0.458824, 0.309804, 0.270588], "rn" -> 
           RGBColor[0.218799, 0.516091, 0.591608], "fr" -> 
           RGBColor[0.25626, 0.0861372, 0.398932], "ra" -> 
           RGBColor[0., 0.473472, 0.04654], "ac" -> 
           RGBColor[0.322042, 0.71693, 0.988479], "th" -> 
           RGBColor[0.3608, 0.67166, 0.943003], "pa" -> 
           RGBColor[0.397469, 0.628, 0.898853], "u" -> 
           RGBColor[0.43205, 0.58595, 0.856029], "np" -> 
           RGBColor[0.464542, 0.54551, 0.814532], "pu" -> 
           RGBColor[0.494945, 0.506679, 0.774361], "am" -> 
           RGBColor[0.52326, 0.469458, 0.735517], "cm" -> 
           RGBColor[0.549486, 0.433847, 0.697999], "bk" -> 
           RGBColor[0.573624, 0.399845, 0.661808], "cf" -> 
           RGBColor[0.595673, 0.367454, 0.626942], "es" -> 
           RGBColor[0.615633, 0.336672, 0.593404], "fm" -> 
           RGBColor[0.633505, 0.307499, 0.561191], "md" -> 
           RGBColor[0.649288, 0.279937, 0.530305], "no" -> 
           RGBColor[0.662982, 0.253984, 0.500746], "lr" -> 
           RGBColor[0.674588, 0.22964, 0.472513], "rf" -> 
           RGBColor[0.684106, 0.206907, 0.445606], "db" -> 
           RGBColor[0.691534, 0.185783, 0.420025], "sg" -> 
           RGBColor[0.696874, 0.166269, 0.395772], "bh" -> 
           RGBColor[0.700126, 0.148365, 0.372844], "hs" -> 
           RGBColor[0.701289, 0.13207, 0.351243], "mt" -> 
           RGBColor[0.700363, 0.117385, 0.330968], "ds" -> 
           RGBColor[0.697348, 0.10431, 0.31202], "rg" -> 
           RGBColor[0.692245, 0.0928444, 0.294398], "cn" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "nh" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "fl" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "mc" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "lv" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "ts" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "og" -> 
           RGBColor[0.635401, 0.0528, 0.226184], "uub" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "uut" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "uuq" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "uup" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "uuh" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "uus" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "uuo" -> 
           RGBColor[0.635401, 0.0528, 0.226184]}]]& ][0.85], 
       ColorDataFunction[
       "Atoms", 
        "Named", {{
         "H", "He", "Li", "Be", "B", "C", "N", "O", "F", "Ne", "Na", "Mg", 
          "Al", "Si", "P", "S", "Cl", "Ar", "K", "Ca", "Sc", "Ti", "V", "Cr", 
          "Mn", "Fe", "Co", "Ni", "Cu", "Zn", "Ga", "Ge", "As", "Se", "Br", 
          "Kr", "Rb", "Sr", "Y", "Zr", "Nb", "Mo", "Tc", "Ru", "Rh", "Pd", 
          "Ag", "Cd", "In", "Sn", "Sb", "Te", "I", "Xe", "Cs", "Ba", "La", 
          "Ce", "Pr", "Nd", "Pm", "Sm", "Eu", "Gd", "Tb", "Dy", "Ho", "Er", 
          "Tm", "Yb", "Lu", "Hf", "Ta", "W", "Re", "Os", "Ir", "Pt", "Au", 
          "Hg", "Tl", "Pb", "Bi", "Po", "At", "Rn", "Fr", "Ra", "Ac", "Th", 
          "Pa", "U", "Np", "Pu", "Am", "Cm", "Bk", "Cf", "Es", "Fm", "Md", 
          "No", "Lr", "Rf", "Db", "Sg", "Bh", "Hs", "Mt", "Ds", "Rg", "Cn", 
          "Nh", "Fl", "Mc", "Lv", "Ts", "Og", "Uub", "Uut", "Uuq", "Uup", 
          "Uuh", "Uus", "Uuo"}, {
         "h", "he", "li", "be", "b", "c", "n", "o", "f", "ne", "na", "mg", 
          "al", "si", "p", "s", "cl", "ar", "k", "ca", "sc", "ti", "v", "cr", 
          "mn", "fe", "co", "ni", "cu", "zn", "ga", "ge", "as", "se", "br", 
          "kr", "rb", "sr", "y", "zr", "nb", "mo", "tc", "ru", "rh", "pd", 
          "ag", "cd", "in", "sn", "sb", "te", "i", "xe", "cs", "ba", "la", 
          "ce", "pr", "nd", "pm", "sm", "eu", "gd", "tb", "dy", "ho", "er", 
          "tm", "yb", "lu", "hf", "ta", "w", "re", "os", "ir", "pt", "au", 
          "hg", "tl", "pb", "bi", "po", "at", "rn", "fr", "ra", "ac", "th", 
          "pa", "u", "np", "pu", "am", "cm", "bk", "cf", "es", "fm", "md", 
          "no", "lr", "rf", "db", "sg", "bh", "hs", "mt", "ds", "rg", "cn", 
          "nh", "fl", "mc", "lv", "ts", "og", "uub", "uut", "uuq", "uup", 
          "uuh", "uus", "uuo"}}, Replace[#, 
         Dispatch[{
          "h" -> RGBColor[0.65, 0.7, 0.7], "he" -> RGBColor[0.836713, 1., 1.],
            "li" -> RGBColor[0.799435, 0.543572, 0.997559], "be" -> 
           RGBColor[0.770565, 0.964309, 0.0442359], "b" -> 
           RGBColor[1., 0.709804, 0.709804], "c" -> RGBColor[0.4, 0.4, 0.4], 
           "n" -> RGBColor[0.291989, 0.437977, 0.888609], "o" -> 
           RGBColor[0.800498, 0.201504, 0.192061], "f" -> 
           RGBColor[0.578462, 0.85539, 0.408855], "ne" -> 
           RGBColor[0.677263, 0.928423, 0.955287], "na" -> 
           RGBColor[0.658708, 0.492173, 0.842842], "mg" -> 
           RGBColor[0.628274, 0.850553, 0.0782731], "al" -> 
           RGBColor[0.8913, 0.631904, 0.627399], "si" -> 
           RGBColor[0.941176, 0.784314, 0.627451], "p" -> 
           RGBColor[1., 0.501961, 0], "s" -> 
           RGBColor[0.90443, 0.97015, 0.13504], "cl" -> 
           RGBColor[0.412698, 0.932689, 0.166398], "ar" -> 
           RGBColor[0.546138, 0.844244, 0.892092], "k" -> 
           RGBColor[0.534026, 0.420729, 0.705621], "ca" -> 
           RGBColor[0.480072, 0.744591, 0.0955222], "sc" -> 
           RGBColor[0.901961, 0.901961, 0.901961], "ti" -> 
           RGBColor[0.74902, 0.760784, 0.780392], "v" -> 
           RGBColor[0.65098, 0.65098, 0.670588], "cr" -> 
           RGBColor[0.541176, 0.6, 0.780392], "mn" -> 
           RGBColor[0.611765, 0.478431, 0.780392], "fe" -> 
           RGBColor[0.878431, 0.4, 0.2], "co" -> 
           RGBColor[0.941176, 0.564706, 0.627451], "ni" -> 
           RGBColor[0.313725, 0.815686, 0.313725], "cu" -> 
           RGBColor[0.784314, 0.501961, 0.2], "zn" -> 
           RGBColor[0.490196, 0.501961, 0.690196], "ga" -> 
           RGBColor[0.800757, 0.542666, 0.533513], "ge" -> 
           RGBColor[0.60508, 0.632465, 0.576489], "as" -> 
           RGBColor[0.741176, 0.501961, 0.890196], "se" -> 
           RGBColor[0.917248, 0.657833, 0.0706628], "br" -> 
           RGBColor[0.58847, 0.22163, 0.16064], "kr" -> 
           RGBColor[0.426019, 0.747462, 0.810413], "rb" -> 
           RGBColor[0.425391, 0.329242, 0.585895], "sr" -> 
           RGBColor[0.325959, 0.646423, 0.095983], "y" -> 
           RGBColor[0.531014, 1., 1.], "zr" -> 
           RGBColor[0.458599, 0.917466, 0.918573], "nb" -> 
           RGBColor[0.385036, 0.834854, 0.841681], "mo" -> 
           RGBColor[0.310325, 0.752163, 0.769323], "tc" -> 
           RGBColor[0.234466, 0.669394, 0.701499], "ru" -> 
           RGBColor[0.157459, 0.586546, 0.638209], "rh" -> 
           RGBColor[0.0793033, 0.50362, 0.579453], "pd" -> 
           RGBColor[0., 0.420615, 0.525231], "ag" -> 
           RGBColor[0.752941, 0.752941, 0.752941], "cd" -> 
           RGBColor[1., 0.85098, 0.560784], "in" -> 
           RGBColor[0.728371, 0.440594, 0.422196], "sn" -> 
           RGBColor[0.39799, 0.491477, 0.495586], "sb" -> 
           RGBColor[0.619608, 0.388235, 0.709804], "te" -> 
           RGBColor[0.816706, 0.451332, 0.0100947], "i" -> 
           RGBColor[0.580392, 0, 0.580392], "xe" -> 
           RGBColor[0.316906, 0.638078, 0.710252], "cs" -> 
           RGBColor[0.332803, 0.217712, 0.483666], "ba" -> 
           RGBColor[0.165935, 0.55605, 0.0796556], "la" -> 
           RGBColor[0.928084, 0.716075, 0.329427], "ce" -> 
           RGBColor[0.894824, 0.731424, 0.325131], "pr" -> 
           RGBColor[0.86523, 0.707999, 0.315261], "nd" -> 
           RGBColor[0.837836, 0.662974, 0.301635], "pm" -> 
           RGBColor[0.811992, 0.607859, 0.285626], "sm" -> 
           RGBColor[0.787563, 0.549894, 0.268279], "eu" -> 
           RGBColor[0.764628, 0.493261, 0.250405], "gd" -> 
           RGBColor[0.743177, 0.440115, 0.23269], "tb" -> 
           RGBColor[0.72281, 0.39143, 0.215783], "dy" -> 
           RGBColor[0.702434, 0.347663, 0.200392], "ho" -> 
           RGBColor[0.679962, 0.309234, 0.187368], "er" -> 
           RGBColor[0.652012, 0.276823, 0.17779], "tm" -> 
           RGBColor[0.613603, 0.251489, 0.173042], "yb" -> 
           RGBColor[0.557855, 0.234598, 0.17489], "lu" -> 
           RGBColor[0.475685, 0.227573, 0.18555], "hf" -> 
           RGBColor[0.781537, 0.717388, 0.716579], "ta" -> 
           RGBColor[0.734443, 0.544489, 0.683471], "w" -> 
           RGBColor[0.681179, 0.360409, 0.63675], "re" -> 
           RGBColor[0.605181, 0.367584, 0.556343], "os" -> 
           RGBColor[0.521806, 0.382125, 0.469204], "ir" -> 
           RGBColor[0.445624, 0.373159, 0.399069], "pt" -> 
           RGBColor[0.815686, 0.815686, 0.878431], "au" -> 
           RGBColor[1., 0.819608, 0.137255], "hg" -> 
           RGBColor[0.721569, 0.721569, 0.815686], "tl" -> 
           RGBColor[0.65098, 0.329412, 0.301961], "pb" -> 
           RGBColor[0.341176, 0.34902, 0.380392], "bi" -> 
           RGBColor[0.619608, 0.309804, 0.709804], "po" -> 
           RGBColor[0.670588, 0.360784, 0], "at" -> 
           RGBColor[0.458824, 0.309804, 0.270588], "rn" -> 
           RGBColor[0.218799, 0.516091, 0.591608], "fr" -> 
           RGBColor[0.25626, 0.0861372, 0.398932], "ra" -> 
           RGBColor[0., 0.473472, 0.04654], "ac" -> 
           RGBColor[0.322042, 0.71693, 0.988479], "th" -> 
           RGBColor[0.3608, 0.67166, 0.943003], "pa" -> 
           RGBColor[0.397469, 0.628, 0.898853], "u" -> 
           RGBColor[0.43205, 0.58595, 0.856029], "np" -> 
           RGBColor[0.464542, 0.54551, 0.814532], "pu" -> 
           RGBColor[0.494945, 0.506679, 0.774361], "am" -> 
           RGBColor[0.52326, 0.469458, 0.735517], "cm" -> 
           RGBColor[0.549486, 0.433847, 0.697999], "bk" -> 
           RGBColor[0.573624, 0.399845, 0.661808], "cf" -> 
           RGBColor[0.595673, 0.367454, 0.626942], "es" -> 
           RGBColor[0.615633, 0.336672, 0.593404], "fm" -> 
           RGBColor[0.633505, 0.307499, 0.561191], "md" -> 
           RGBColor[0.649288, 0.279937, 0.530305], "no" -> 
           RGBColor[0.662982, 0.253984, 0.500746], "lr" -> 
           RGBColor[0.674588, 0.22964, 0.472513], "rf" -> 
           RGBColor[0.684106, 0.206907, 0.445606], "db" -> 
           RGBColor[0.691534, 0.185783, 0.420025], "sg" -> 
           RGBColor[0.696874, 0.166269, 0.395772], "bh" -> 
           RGBColor[0.700126, 0.148365, 0.372844], "hs" -> 
           RGBColor[0.701289, 0.13207, 0.351243], "mt" -> 
           RGBColor[0.700363, 0.117385, 0.330968], "ds" -> 
           RGBColor[0.697348, 0.10431, 0.31202], "rg" -> 
           RGBColor[0.692245, 0.0928444, 0.294398], "cn" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "nh" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "fl" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "mc" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "lv" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "ts" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "og" -> 
           RGBColor[0.635401, 0.0528, 0.226184], "uub" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "uut" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "uuq" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "uup" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "uuh" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "uus" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "uuo" -> 
           RGBColor[0.635401, 0.0528, 0.226184]}]]& ][0.85], 
       ColorDataFunction[
       "Atoms", 
        "Named", {{
         "H", "He", "Li", "Be", "B", "C", "N", "O", "F", "Ne", "Na", "Mg", 
          "Al", "Si", "P", "S", "Cl", "Ar", "K", "Ca", "Sc", "Ti", "V", "Cr", 
          "Mn", "Fe", "Co", "Ni", "Cu", "Zn", "Ga", "Ge", "As", "Se", "Br", 
          "Kr", "Rb", "Sr", "Y", "Zr", "Nb", "Mo", "Tc", "Ru", "Rh", "Pd", 
          "Ag", "Cd", "In", "Sn", "Sb", "Te", "I", "Xe", "Cs", "Ba", "La", 
          "Ce", "Pr", "Nd", "Pm", "Sm", "Eu", "Gd", "Tb", "Dy", "Ho", "Er", 
          "Tm", "Yb", "Lu", "Hf", "Ta", "W", "Re", "Os", "Ir", "Pt", "Au", 
          "Hg", "Tl", "Pb", "Bi", "Po", "At", "Rn", "Fr", "Ra", "Ac", "Th", 
          "Pa", "U", "Np", "Pu", "Am", "Cm", "Bk", "Cf", "Es", "Fm", "Md", 
          "No", "Lr", "Rf", "Db", "Sg", "Bh", "Hs", "Mt", "Ds", "Rg", "Cn", 
          "Nh", "Fl", "Mc", "Lv", "Ts", "Og", "Uub", "Uut", "Uuq", "Uup", 
          "Uuh", "Uus", "Uuo"}, {
         "h", "he", "li", "be", "b", "c", "n", "o", "f", "ne", "na", "mg", 
          "al", "si", "p", "s", "cl", "ar", "k", "ca", "sc", "ti", "v", "cr", 
          "mn", "fe", "co", "ni", "cu", "zn", "ga", "ge", "as", "se", "br", 
          "kr", "rb", "sr", "y", "zr", "nb", "mo", "tc", "ru", "rh", "pd", 
          "ag", "cd", "in", "sn", "sb", "te", "i", "xe", "cs", "ba", "la", 
          "ce", "pr", "nd", "pm", "sm", "eu", "gd", "tb", "dy", "ho", "er", 
          "tm", "yb", "lu", "hf", "ta", "w", "re", "os", "ir", "pt", "au", 
          "hg", "tl", "pb", "bi", "po", "at", "rn", "fr", "ra", "ac", "th", 
          "pa", "u", "np", "pu", "am", "cm", "bk", "cf", "es", "fm", "md", 
          "no", "lr", "rf", "db", "sg", "bh", "hs", "mt", "ds", "rg", "cn", 
          "nh", "fl", "mc", "lv", "ts", "og", "uub", "uut", "uuq", "uup", 
          "uuh", "uus", "uuo"}}, Replace[#, 
         Dispatch[{
          "h" -> RGBColor[0.65, 0.7, 0.7], "he" -> RGBColor[0.836713, 1., 1.],
            "li" -> RGBColor[0.799435, 0.543572, 0.997559], "be" -> 
           RGBColor[0.770565, 0.964309, 0.0442359], "b" -> 
           RGBColor[1., 0.709804, 0.709804], "c" -> RGBColor[0.4, 0.4, 0.4], 
           "n" -> RGBColor[0.291989, 0.437977, 0.888609], "o" -> 
           RGBColor[0.800498, 0.201504, 0.192061], "f" -> 
           RGBColor[0.578462, 0.85539, 0.408855], "ne" -> 
           RGBColor[0.677263, 0.928423, 0.955287], "na" -> 
           RGBColor[0.658708, 0.492173, 0.842842], "mg" -> 
           RGBColor[0.628274, 0.850553, 0.0782731], "al" -> 
           RGBColor[0.8913, 0.631904, 0.627399], "si" -> 
           RGBColor[0.941176, 0.784314, 0.627451], "p" -> 
           RGBColor[1., 0.501961, 0], "s" -> 
           RGBColor[0.90443, 0.97015, 0.13504], "cl" -> 
           RGBColor[0.412698, 0.932689, 0.166398], "ar" -> 
           RGBColor[0.546138, 0.844244, 0.892092], "k" -> 
           RGBColor[0.534026, 0.420729, 0.705621], "ca" -> 
           RGBColor[0.480072, 0.744591, 0.0955222], "sc" -> 
           RGBColor[0.901961, 0.901961, 0.901961], "ti" -> 
           RGBColor[0.74902, 0.760784, 0.780392], "v" -> 
           RGBColor[0.65098, 0.65098, 0.670588], "cr" -> 
           RGBColor[0.541176, 0.6, 0.780392], "mn" -> 
           RGBColor[0.611765, 0.478431, 0.780392], "fe" -> 
           RGBColor[0.878431, 0.4, 0.2], "co" -> 
           RGBColor[0.941176, 0.564706, 0.627451], "ni" -> 
           RGBColor[0.313725, 0.815686, 0.313725], "cu" -> 
           RGBColor[0.784314, 0.501961, 0.2], "zn" -> 
           RGBColor[0.490196, 0.501961, 0.690196], "ga" -> 
           RGBColor[0.800757, 0.542666, 0.533513], "ge" -> 
           RGBColor[0.60508, 0.632465, 0.576489], "as" -> 
           RGBColor[0.741176, 0.501961, 0.890196], "se" -> 
           RGBColor[0.917248, 0.657833, 0.0706628], "br" -> 
           RGBColor[0.58847, 0.22163, 0.16064], "kr" -> 
           RGBColor[0.426019, 0.747462, 0.810413], "rb" -> 
           RGBColor[0.425391, 0.329242, 0.585895], "sr" -> 
           RGBColor[0.325959, 0.646423, 0.095983], "y" -> 
           RGBColor[0.531014, 1., 1.], "zr" -> 
           RGBColor[0.458599, 0.917466, 0.918573], "nb" -> 
           RGBColor[0.385036, 0.834854, 0.841681], "mo" -> 
           RGBColor[0.310325, 0.752163, 0.769323], "tc" -> 
           RGBColor[0.234466, 0.669394, 0.701499], "ru" -> 
           RGBColor[0.157459, 0.586546, 0.638209], "rh" -> 
           RGBColor[0.0793033, 0.50362, 0.579453], "pd" -> 
           RGBColor[0., 0.420615, 0.525231], "ag" -> 
           RGBColor[0.752941, 0.752941, 0.752941], "cd" -> 
           RGBColor[1., 0.85098, 0.560784], "in" -> 
           RGBColor[0.728371, 0.440594, 0.422196], "sn" -> 
           RGBColor[0.39799, 0.491477, 0.495586], "sb" -> 
           RGBColor[0.619608, 0.388235, 0.709804], "te" -> 
           RGBColor[0.816706, 0.451332, 0.0100947], "i" -> 
           RGBColor[0.580392, 0, 0.580392], "xe" -> 
           RGBColor[0.316906, 0.638078, 0.710252], "cs" -> 
           RGBColor[0.332803, 0.217712, 0.483666], "ba" -> 
           RGBColor[0.165935, 0.55605, 0.0796556], "la" -> 
           RGBColor[0.928084, 0.716075, 0.329427], "ce" -> 
           RGBColor[0.894824, 0.731424, 0.325131], "pr" -> 
           RGBColor[0.86523, 0.707999, 0.315261], "nd" -> 
           RGBColor[0.837836, 0.662974, 0.301635], "pm" -> 
           RGBColor[0.811992, 0.607859, 0.285626], "sm" -> 
           RGBColor[0.787563, 0.549894, 0.268279], "eu" -> 
           RGBColor[0.764628, 0.493261, 0.250405], "gd" -> 
           RGBColor[0.743177, 0.440115, 0.23269], "tb" -> 
           RGBColor[0.72281, 0.39143, 0.215783], "dy" -> 
           RGBColor[0.702434, 0.347663, 0.200392], "ho" -> 
           RGBColor[0.679962, 0.309234, 0.187368], "er" -> 
           RGBColor[0.652012, 0.276823, 0.17779], "tm" -> 
           RGBColor[0.613603, 0.251489, 0.173042], "yb" -> 
           RGBColor[0.557855, 0.234598, 0.17489], "lu" -> 
           RGBColor[0.475685, 0.227573, 0.18555], "hf" -> 
           RGBColor[0.781537, 0.717388, 0.716579], "ta" -> 
           RGBColor[0.734443, 0.544489, 0.683471], "w" -> 
           RGBColor[0.681179, 0.360409, 0.63675], "re" -> 
           RGBColor[0.605181, 0.367584, 0.556343], "os" -> 
           RGBColor[0.521806, 0.382125, 0.469204], "ir" -> 
           RGBColor[0.445624, 0.373159, 0.399069], "pt" -> 
           RGBColor[0.815686, 0.815686, 0.878431], "au" -> 
           RGBColor[1., 0.819608, 0.137255], "hg" -> 
           RGBColor[0.721569, 0.721569, 0.815686], "tl" -> 
           RGBColor[0.65098, 0.329412, 0.301961], "pb" -> 
           RGBColor[0.341176, 0.34902, 0.380392], "bi" -> 
           RGBColor[0.619608, 0.309804, 0.709804], "po" -> 
           RGBColor[0.670588, 0.360784, 0], "at" -> 
           RGBColor[0.458824, 0.309804, 0.270588], "rn" -> 
           RGBColor[0.218799, 0.516091, 0.591608], "fr" -> 
           RGBColor[0.25626, 0.0861372, 0.398932], "ra" -> 
           RGBColor[0., 0.473472, 0.04654], "ac" -> 
           RGBColor[0.322042, 0.71693, 0.988479], "th" -> 
           RGBColor[0.3608, 0.67166, 0.943003], "pa" -> 
           RGBColor[0.397469, 0.628, 0.898853], "u" -> 
           RGBColor[0.43205, 0.58595, 0.856029], "np" -> 
           RGBColor[0.464542, 0.54551, 0.814532], "pu" -> 
           RGBColor[0.494945, 0.506679, 0.774361], "am" -> 
           RGBColor[0.52326, 0.469458, 0.735517], "cm" -> 
           RGBColor[0.549486, 0.433847, 0.697999], "bk" -> 
           RGBColor[0.573624, 0.399845, 0.661808], "cf" -> 
           RGBColor[0.595673, 0.367454, 0.626942], "es" -> 
           RGBColor[0.615633, 0.336672, 0.593404], "fm" -> 
           RGBColor[0.633505, 0.307499, 0.561191], "md" -> 
           RGBColor[0.649288, 0.279937, 0.530305], "no" -> 
           RGBColor[0.662982, 0.253984, 0.500746], "lr" -> 
           RGBColor[0.674588, 0.22964, 0.472513], "rf" -> 
           RGBColor[0.684106, 0.206907, 0.445606], "db" -> 
           RGBColor[0.691534, 0.185783, 0.420025], "sg" -> 
           RGBColor[0.696874, 0.166269, 0.395772], "bh" -> 
           RGBColor[0.700126, 0.148365, 0.372844], "hs" -> 
           RGBColor[0.701289, 0.13207, 0.351243], "mt" -> 
           RGBColor[0.700363, 0.117385, 0.330968], "ds" -> 
           RGBColor[0.697348, 0.10431, 0.31202], "rg" -> 
           RGBColor[0.692245, 0.0928444, 0.294398], "cn" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "nh" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "fl" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "mc" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "lv" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "ts" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "og" -> 
           RGBColor[0.635401, 0.0528, 0.226184], "uub" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "uut" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "uuq" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "uup" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "uuh" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "uus" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "uuo" -> 
           RGBColor[0.635401, 0.0528, 0.226184]}]]& ][0.85], 
       ColorDataFunction[
       "Atoms", 
        "Named", {{
         "H", "He", "Li", "Be", "B", "C", "N", "O", "F", "Ne", "Na", "Mg", 
          "Al", "Si", "P", "S", "Cl", "Ar", "K", "Ca", "Sc", "Ti", "V", "Cr", 
          "Mn", "Fe", "Co", "Ni", "Cu", "Zn", "Ga", "Ge", "As", "Se", "Br", 
          "Kr", "Rb", "Sr", "Y", "Zr", "Nb", "Mo", "Tc", "Ru", "Rh", "Pd", 
          "Ag", "Cd", "In", "Sn", "Sb", "Te", "I", "Xe", "Cs", "Ba", "La", 
          "Ce", "Pr", "Nd", "Pm", "Sm", "Eu", "Gd", "Tb", "Dy", "Ho", "Er", 
          "Tm", "Yb", "Lu", "Hf", "Ta", "W", "Re", "Os", "Ir", "Pt", "Au", 
          "Hg", "Tl", "Pb", "Bi", "Po", "At", "Rn", "Fr", "Ra", "Ac", "Th", 
          "Pa", "U", "Np", "Pu", "Am", "Cm", "Bk", "Cf", "Es", "Fm", "Md", 
          "No", "Lr", "Rf", "Db", "Sg", "Bh", "Hs", "Mt", "Ds", "Rg", "Cn", 
          "Nh", "Fl", "Mc", "Lv", "Ts", "Og", "Uub", "Uut", "Uuq", "Uup", 
          "Uuh", "Uus", "Uuo"}, {
         "h", "he", "li", "be", "b", "c", "n", "o", "f", "ne", "na", "mg", 
          "al", "si", "p", "s", "cl", "ar", "k", "ca", "sc", "ti", "v", "cr", 
          "mn", "fe", "co", "ni", "cu", "zn", "ga", "ge", "as", "se", "br", 
          "kr", "rb", "sr", "y", "zr", "nb", "mo", "tc", "ru", "rh", "pd", 
          "ag", "cd", "in", "sn", "sb", "te", "i", "xe", "cs", "ba", "la", 
          "ce", "pr", "nd", "pm", "sm", "eu", "gd", "tb", "dy", "ho", "er", 
          "tm", "yb", "lu", "hf", "ta", "w", "re", "os", "ir", "pt", "au", 
          "hg", "tl", "pb", "bi", "po", "at", "rn", "fr", "ra", "ac", "th", 
          "pa", "u", "np", "pu", "am", "cm", "bk", "cf", "es", "fm", "md", 
          "no", "lr", "rf", "db", "sg", "bh", "hs", "mt", "ds", "rg", "cn", 
          "nh", "fl", "mc", "lv", "ts", "og", "uub", "uut", "uuq", "uup", 
          "uuh", "uus", "uuo"}}, Replace[#, 
         Dispatch[{
          "h" -> RGBColor[0.65, 0.7, 0.7], "he" -> RGBColor[0.836713, 1., 1.],
            "li" -> RGBColor[0.799435, 0.543572, 0.997559], "be" -> 
           RGBColor[0.770565, 0.964309, 0.0442359], "b" -> 
           RGBColor[1., 0.709804, 0.709804], "c" -> RGBColor[0.4, 0.4, 0.4], 
           "n" -> RGBColor[0.291989, 0.437977, 0.888609], "o" -> 
           RGBColor[0.800498, 0.201504, 0.192061], "f" -> 
           RGBColor[0.578462, 0.85539, 0.408855], "ne" -> 
           RGBColor[0.677263, 0.928423, 0.955287], "na" -> 
           RGBColor[0.658708, 0.492173, 0.842842], "mg" -> 
           RGBColor[0.628274, 0.850553, 0.0782731], "al" -> 
           RGBColor[0.8913, 0.631904, 0.627399], "si" -> 
           RGBColor[0.941176, 0.784314, 0.627451], "p" -> 
           RGBColor[1., 0.501961, 0], "s" -> 
           RGBColor[0.90443, 0.97015, 0.13504], "cl" -> 
           RGBColor[0.412698, 0.932689, 0.166398], "ar" -> 
           RGBColor[0.546138, 0.844244, 0.892092], "k" -> 
           RGBColor[0.534026, 0.420729, 0.705621], "ca" -> 
           RGBColor[0.480072, 0.744591, 0.0955222], "sc" -> 
           RGBColor[0.901961, 0.901961, 0.901961], "ti" -> 
           RGBColor[0.74902, 0.760784, 0.780392], "v" -> 
           RGBColor[0.65098, 0.65098, 0.670588], "cr" -> 
           RGBColor[0.541176, 0.6, 0.780392], "mn" -> 
           RGBColor[0.611765, 0.478431, 0.780392], "fe" -> 
           RGBColor[0.878431, 0.4, 0.2], "co" -> 
           RGBColor[0.941176, 0.564706, 0.627451], "ni" -> 
           RGBColor[0.313725, 0.815686, 0.313725], "cu" -> 
           RGBColor[0.784314, 0.501961, 0.2], "zn" -> 
           RGBColor[0.490196, 0.501961, 0.690196], "ga" -> 
           RGBColor[0.800757, 0.542666, 0.533513], "ge" -> 
           RGBColor[0.60508, 0.632465, 0.576489], "as" -> 
           RGBColor[0.741176, 0.501961, 0.890196], "se" -> 
           RGBColor[0.917248, 0.657833, 0.0706628], "br" -> 
           RGBColor[0.58847, 0.22163, 0.16064], "kr" -> 
           RGBColor[0.426019, 0.747462, 0.810413], "rb" -> 
           RGBColor[0.425391, 0.329242, 0.585895], "sr" -> 
           RGBColor[0.325959, 0.646423, 0.095983], "y" -> 
           RGBColor[0.531014, 1., 1.], "zr" -> 
           RGBColor[0.458599, 0.917466, 0.918573], "nb" -> 
           RGBColor[0.385036, 0.834854, 0.841681], "mo" -> 
           RGBColor[0.310325, 0.752163, 0.769323], "tc" -> 
           RGBColor[0.234466, 0.669394, 0.701499], "ru" -> 
           RGBColor[0.157459, 0.586546, 0.638209], "rh" -> 
           RGBColor[0.0793033, 0.50362, 0.579453], "pd" -> 
           RGBColor[0., 0.420615, 0.525231], "ag" -> 
           RGBColor[0.752941, 0.752941, 0.752941], "cd" -> 
           RGBColor[1., 0.85098, 0.560784], "in" -> 
           RGBColor[0.728371, 0.440594, 0.422196], "sn" -> 
           RGBColor[0.39799, 0.491477, 0.495586], "sb" -> 
           RGBColor[0.619608, 0.388235, 0.709804], "te" -> 
           RGBColor[0.816706, 0.451332, 0.0100947], "i" -> 
           RGBColor[0.580392, 0, 0.580392], "xe" -> 
           RGBColor[0.316906, 0.638078, 0.710252], "cs" -> 
           RGBColor[0.332803, 0.217712, 0.483666], "ba" -> 
           RGBColor[0.165935, 0.55605, 0.0796556], "la" -> 
           RGBColor[0.928084, 0.716075, 0.329427], "ce" -> 
           RGBColor[0.894824, 0.731424, 0.325131], "pr" -> 
           RGBColor[0.86523, 0.707999, 0.315261], "nd" -> 
           RGBColor[0.837836, 0.662974, 0.301635], "pm" -> 
           RGBColor[0.811992, 0.607859, 0.285626], "sm" -> 
           RGBColor[0.787563, 0.549894, 0.268279], "eu" -> 
           RGBColor[0.764628, 0.493261, 0.250405], "gd" -> 
           RGBColor[0.743177, 0.440115, 0.23269], "tb" -> 
           RGBColor[0.72281, 0.39143, 0.215783], "dy" -> 
           RGBColor[0.702434, 0.347663, 0.200392], "ho" -> 
           RGBColor[0.679962, 0.309234, 0.187368], "er" -> 
           RGBColor[0.652012, 0.276823, 0.17779], "tm" -> 
           RGBColor[0.613603, 0.251489, 0.173042], "yb" -> 
           RGBColor[0.557855, 0.234598, 0.17489], "lu" -> 
           RGBColor[0.475685, 0.227573, 0.18555], "hf" -> 
           RGBColor[0.781537, 0.717388, 0.716579], "ta" -> 
           RGBColor[0.734443, 0.544489, 0.683471], "w" -> 
           RGBColor[0.681179, 0.360409, 0.63675], "re" -> 
           RGBColor[0.605181, 0.367584, 0.556343], "os" -> 
           RGBColor[0.521806, 0.382125, 0.469204], "ir" -> 
           RGBColor[0.445624, 0.373159, 0.399069], "pt" -> 
           RGBColor[0.815686, 0.815686, 0.878431], "au" -> 
           RGBColor[1., 0.819608, 0.137255], "hg" -> 
           RGBColor[0.721569, 0.721569, 0.815686], "tl" -> 
           RGBColor[0.65098, 0.329412, 0.301961], "pb" -> 
           RGBColor[0.341176, 0.34902, 0.380392], "bi" -> 
           RGBColor[0.619608, 0.309804, 0.709804], "po" -> 
           RGBColor[0.670588, 0.360784, 0], "at" -> 
           RGBColor[0.458824, 0.309804, 0.270588], "rn" -> 
           RGBColor[0.218799, 0.516091, 0.591608], "fr" -> 
           RGBColor[0.25626, 0.0861372, 0.398932], "ra" -> 
           RGBColor[0., 0.473472, 0.04654], "ac" -> 
           RGBColor[0.322042, 0.71693, 0.988479], "th" -> 
           RGBColor[0.3608, 0.67166, 0.943003], "pa" -> 
           RGBColor[0.397469, 0.628, 0.898853], "u" -> 
           RGBColor[0.43205, 0.58595, 0.856029], "np" -> 
           RGBColor[0.464542, 0.54551, 0.814532], "pu" -> 
           RGBColor[0.494945, 0.506679, 0.774361], "am" -> 
           RGBColor[0.52326, 0.469458, 0.735517], "cm" -> 
           RGBColor[0.549486, 0.433847, 0.697999], "bk" -> 
           RGBColor[0.573624, 0.399845, 0.661808], "cf" -> 
           RGBColor[0.595673, 0.367454, 0.626942], "es" -> 
           RGBColor[0.615633, 0.336672, 0.593404], "fm" -> 
           RGBColor[0.633505, 0.307499, 0.561191], "md" -> 
           RGBColor[0.649288, 0.279937, 0.530305], "no" -> 
           RGBColor[0.662982, 0.253984, 0.500746], "lr" -> 
           RGBColor[0.674588, 0.22964, 0.472513], "rf" -> 
           RGBColor[0.684106, 0.206907, 0.445606], "db" -> 
           RGBColor[0.691534, 0.185783, 0.420025], "sg" -> 
           RGBColor[0.696874, 0.166269, 0.395772], "bh" -> 
           RGBColor[0.700126, 0.148365, 0.372844], "hs" -> 
           RGBColor[0.701289, 0.13207, 0.351243], "mt" -> 
           RGBColor[0.700363, 0.117385, 0.330968], "ds" -> 
           RGBColor[0.697348, 0.10431, 0.31202], "rg" -> 
           RGBColor[0.692245, 0.0928444, 0.294398], "cn" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "nh" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "fl" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "mc" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "lv" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "ts" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "og" -> 
           RGBColor[0.635401, 0.0528, 0.226184], "uub" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "uut" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "uuq" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "uup" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "uuh" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "uus" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "uuo" -> 
           RGBColor[0.635401, 0.0528, 0.226184]}]]& ][0.85], 
       ColorDataFunction[
       "Atoms", 
        "Named", {{
         "H", "He", "Li", "Be", "B", "C", "N", "O", "F", "Ne", "Na", "Mg", 
          "Al", "Si", "P", "S", "Cl", "Ar", "K", "Ca", "Sc", "Ti", "V", "Cr", 
          "Mn", "Fe", "Co", "Ni", "Cu", "Zn", "Ga", "Ge", "As", "Se", "Br", 
          "Kr", "Rb", "Sr", "Y", "Zr", "Nb", "Mo", "Tc", "Ru", "Rh", "Pd", 
          "Ag", "Cd", "In", "Sn", "Sb", "Te", "I", "Xe", "Cs", "Ba", "La", 
          "Ce", "Pr", "Nd", "Pm", "Sm", "Eu", "Gd", "Tb", "Dy", "Ho", "Er", 
          "Tm", "Yb", "Lu", "Hf", "Ta", "W", "Re", "Os", "Ir", "Pt", "Au", 
          "Hg", "Tl", "Pb", "Bi", "Po", "At", "Rn", "Fr", "Ra", "Ac", "Th", 
          "Pa", "U", "Np", "Pu", "Am", "Cm", "Bk", "Cf", "Es", "Fm", "Md", 
          "No", "Lr", "Rf", "Db", "Sg", "Bh", "Hs", "Mt", "Ds", "Rg", "Cn", 
          "Nh", "Fl", "Mc", "Lv", "Ts", "Og", "Uub", "Uut", "Uuq", "Uup", 
          "Uuh", "Uus", "Uuo"}, {
         "h", "he", "li", "be", "b", "c", "n", "o", "f", "ne", "na", "mg", 
          "al", "si", "p", "s", "cl", "ar", "k", "ca", "sc", "ti", "v", "cr", 
          "mn", "fe", "co", "ni", "cu", "zn", "ga", "ge", "as", "se", "br", 
          "kr", "rb", "sr", "y", "zr", "nb", "mo", "tc", "ru", "rh", "pd", 
          "ag", "cd", "in", "sn", "sb", "te", "i", "xe", "cs", "ba", "la", 
          "ce", "pr", "nd", "pm", "sm", "eu", "gd", "tb", "dy", "ho", "er", 
          "tm", "yb", "lu", "hf", "ta", "w", "re", "os", "ir", "pt", "au", 
          "hg", "tl", "pb", "bi", "po", "at", "rn", "fr", "ra", "ac", "th", 
          "pa", "u", "np", "pu", "am", "cm", "bk", "cf", "es", "fm", "md", 
          "no", "lr", "rf", "db", "sg", "bh", "hs", "mt", "ds", "rg", "cn", 
          "nh", "fl", "mc", "lv", "ts", "og", "uub", "uut", "uuq", "uup", 
          "uuh", "uus", "uuo"}}, Replace[#, 
         Dispatch[{
          "h" -> RGBColor[0.65, 0.7, 0.7], "he" -> RGBColor[0.836713, 1., 1.],
            "li" -> RGBColor[0.799435, 0.543572, 0.997559], "be" -> 
           RGBColor[0.770565, 0.964309, 0.0442359], "b" -> 
           RGBColor[1., 0.709804, 0.709804], "c" -> RGBColor[0.4, 0.4, 0.4], 
           "n" -> RGBColor[0.291989, 0.437977, 0.888609], "o" -> 
           RGBColor[0.800498, 0.201504, 0.192061], "f" -> 
           RGBColor[0.578462, 0.85539, 0.408855], "ne" -> 
           RGBColor[0.677263, 0.928423, 0.955287], "na" -> 
           RGBColor[0.658708, 0.492173, 0.842842], "mg" -> 
           RGBColor[0.628274, 0.850553, 0.0782731], "al" -> 
           RGBColor[0.8913, 0.631904, 0.627399], "si" -> 
           RGBColor[0.941176, 0.784314, 0.627451], "p" -> 
           RGBColor[1., 0.501961, 0], "s" -> 
           RGBColor[0.90443, 0.97015, 0.13504], "cl" -> 
           RGBColor[0.412698, 0.932689, 0.166398], "ar" -> 
           RGBColor[0.546138, 0.844244, 0.892092], "k" -> 
           RGBColor[0.534026, 0.420729, 0.705621], "ca" -> 
           RGBColor[0.480072, 0.744591, 0.0955222], "sc" -> 
           RGBColor[0.901961, 0.901961, 0.901961], "ti" -> 
           RGBColor[0.74902, 0.760784, 0.780392], "v" -> 
           RGBColor[0.65098, 0.65098, 0.670588], "cr" -> 
           RGBColor[0.541176, 0.6, 0.780392], "mn" -> 
           RGBColor[0.611765, 0.478431, 0.780392], "fe" -> 
           RGBColor[0.878431, 0.4, 0.2], "co" -> 
           RGBColor[0.941176, 0.564706, 0.627451], "ni" -> 
           RGBColor[0.313725, 0.815686, 0.313725], "cu" -> 
           RGBColor[0.784314, 0.501961, 0.2], "zn" -> 
           RGBColor[0.490196, 0.501961, 0.690196], "ga" -> 
           RGBColor[0.800757, 0.542666, 0.533513], "ge" -> 
           RGBColor[0.60508, 0.632465, 0.576489], "as" -> 
           RGBColor[0.741176, 0.501961, 0.890196], "se" -> 
           RGBColor[0.917248, 0.657833, 0.0706628], "br" -> 
           RGBColor[0.58847, 0.22163, 0.16064], "kr" -> 
           RGBColor[0.426019, 0.747462, 0.810413], "rb" -> 
           RGBColor[0.425391, 0.329242, 0.585895], "sr" -> 
           RGBColor[0.325959, 0.646423, 0.095983], "y" -> 
           RGBColor[0.531014, 1., 1.], "zr" -> 
           RGBColor[0.458599, 0.917466, 0.918573], "nb" -> 
           RGBColor[0.385036, 0.834854, 0.841681], "mo" -> 
           RGBColor[0.310325, 0.752163, 0.769323], "tc" -> 
           RGBColor[0.234466, 0.669394, 0.701499], "ru" -> 
           RGBColor[0.157459, 0.586546, 0.638209], "rh" -> 
           RGBColor[0.0793033, 0.50362, 0.579453], "pd" -> 
           RGBColor[0., 0.420615, 0.525231], "ag" -> 
           RGBColor[0.752941, 0.752941, 0.752941], "cd" -> 
           RGBColor[1., 0.85098, 0.560784], "in" -> 
           RGBColor[0.728371, 0.440594, 0.422196], "sn" -> 
           RGBColor[0.39799, 0.491477, 0.495586], "sb" -> 
           RGBColor[0.619608, 0.388235, 0.709804], "te" -> 
           RGBColor[0.816706, 0.451332, 0.0100947], "i" -> 
           RGBColor[0.580392, 0, 0.580392], "xe" -> 
           RGBColor[0.316906, 0.638078, 0.710252], "cs" -> 
           RGBColor[0.332803, 0.217712, 0.483666], "ba" -> 
           RGBColor[0.165935, 0.55605, 0.0796556], "la" -> 
           RGBColor[0.928084, 0.716075, 0.329427], "ce" -> 
           RGBColor[0.894824, 0.731424, 0.325131], "pr" -> 
           RGBColor[0.86523, 0.707999, 0.315261], "nd" -> 
           RGBColor[0.837836, 0.662974, 0.301635], "pm" -> 
           RGBColor[0.811992, 0.607859, 0.285626], "sm" -> 
           RGBColor[0.787563, 0.549894, 0.268279], "eu" -> 
           RGBColor[0.764628, 0.493261, 0.250405], "gd" -> 
           RGBColor[0.743177, 0.440115, 0.23269], "tb" -> 
           RGBColor[0.72281, 0.39143, 0.215783], "dy" -> 
           RGBColor[0.702434, 0.347663, 0.200392], "ho" -> 
           RGBColor[0.679962, 0.309234, 0.187368], "er" -> 
           RGBColor[0.652012, 0.276823, 0.17779], "tm" -> 
           RGBColor[0.613603, 0.251489, 0.173042], "yb" -> 
           RGBColor[0.557855, 0.234598, 0.17489], "lu" -> 
           RGBColor[0.475685, 0.227573, 0.18555], "hf" -> 
           RGBColor[0.781537, 0.717388, 0.716579], "ta" -> 
           RGBColor[0.734443, 0.544489, 0.683471], "w" -> 
           RGBColor[0.681179, 0.360409, 0.63675], "re" -> 
           RGBColor[0.605181, 0.367584, 0.556343], "os" -> 
           RGBColor[0.521806, 0.382125, 0.469204], "ir" -> 
           RGBColor[0.445624, 0.373159, 0.399069], "pt" -> 
           RGBColor[0.815686, 0.815686, 0.878431], "au" -> 
           RGBColor[1., 0.819608, 0.137255], "hg" -> 
           RGBColor[0.721569, 0.721569, 0.815686], "tl" -> 
           RGBColor[0.65098, 0.329412, 0.301961], "pb" -> 
           RGBColor[0.341176, 0.34902, 0.380392], "bi" -> 
           RGBColor[0.619608, 0.309804, 0.709804], "po" -> 
           RGBColor[0.670588, 0.360784, 0], "at" -> 
           RGBColor[0.458824, 0.309804, 0.270588], "rn" -> 
           RGBColor[0.218799, 0.516091, 0.591608], "fr" -> 
           RGBColor[0.25626, 0.0861372, 0.398932], "ra" -> 
           RGBColor[0., 0.473472, 0.04654], "ac" -> 
           RGBColor[0.322042, 0.71693, 0.988479], "th" -> 
           RGBColor[0.3608, 0.67166, 0.943003], "pa" -> 
           RGBColor[0.397469, 0.628, 0.898853], "u" -> 
           RGBColor[0.43205, 0.58595, 0.856029], "np" -> 
           RGBColor[0.464542, 0.54551, 0.814532], "pu" -> 
           RGBColor[0.494945, 0.506679, 0.774361], "am" -> 
           RGBColor[0.52326, 0.469458, 0.735517], "cm" -> 
           RGBColor[0.549486, 0.433847, 0.697999], "bk" -> 
           RGBColor[0.573624, 0.399845, 0.661808], "cf" -> 
           RGBColor[0.595673, 0.367454, 0.626942], "es" -> 
           RGBColor[0.615633, 0.336672, 0.593404], "fm" -> 
           RGBColor[0.633505, 0.307499, 0.561191], "md" -> 
           RGBColor[0.649288, 0.279937, 0.530305], "no" -> 
           RGBColor[0.662982, 0.253984, 0.500746], "lr" -> 
           RGBColor[0.674588, 0.22964, 0.472513], "rf" -> 
           RGBColor[0.684106, 0.206907, 0.445606], "db" -> 
           RGBColor[0.691534, 0.185783, 0.420025], "sg" -> 
           RGBColor[0.696874, 0.166269, 0.395772], "bh" -> 
           RGBColor[0.700126, 0.148365, 0.372844], "hs" -> 
           RGBColor[0.701289, 0.13207, 0.351243], "mt" -> 
           RGBColor[0.700363, 0.117385, 0.330968], "ds" -> 
           RGBColor[0.697348, 0.10431, 0.31202], "rg" -> 
           RGBColor[0.692245, 0.0928444, 0.294398], "cn" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "nh" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "fl" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "mc" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "lv" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "ts" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "og" -> 
           RGBColor[0.635401, 0.0528, 0.226184], "uub" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "uut" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "uuq" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "uup" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "uuh" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "uus" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "uuo" -> 
           RGBColor[0.635401, 0.0528, 0.226184]}]]& ][0.85], 
       ColorDataFunction[
       "Atoms", 
        "Named", {{
         "H", "He", "Li", "Be", "B", "C", "N", "O", "F", "Ne", "Na", "Mg", 
          "Al", "Si", "P", "S", "Cl", "Ar", "K", "Ca", "Sc", "Ti", "V", "Cr", 
          "Mn", "Fe", "Co", "Ni", "Cu", "Zn", "Ga", "Ge", "As", "Se", "Br", 
          "Kr", "Rb", "Sr", "Y", "Zr", "Nb", "Mo", "Tc", "Ru", "Rh", "Pd", 
          "Ag", "Cd", "In", "Sn", "Sb", "Te", "I", "Xe", "Cs", "Ba", "La", 
          "Ce", "Pr", "Nd", "Pm", "Sm", "Eu", "Gd", "Tb", "Dy", "Ho", "Er", 
          "Tm", "Yb", "Lu", "Hf", "Ta", "W", "Re", "Os", "Ir", "Pt", "Au", 
          "Hg", "Tl", "Pb", "Bi", "Po", "At", "Rn", "Fr", "Ra", "Ac", "Th", 
          "Pa", "U", "Np", "Pu", "Am", "Cm", "Bk", "Cf", "Es", "Fm", "Md", 
          "No", "Lr", "Rf", "Db", "Sg", "Bh", "Hs", "Mt", "Ds", "Rg", "Cn", 
          "Nh", "Fl", "Mc", "Lv", "Ts", "Og", "Uub", "Uut", "Uuq", "Uup", 
          "Uuh", "Uus", "Uuo"}, {
         "h", "he", "li", "be", "b", "c", "n", "o", "f", "ne", "na", "mg", 
          "al", "si", "p", "s", "cl", "ar", "k", "ca", "sc", "ti", "v", "cr", 
          "mn", "fe", "co", "ni", "cu", "zn", "ga", "ge", "as", "se", "br", 
          "kr", "rb", "sr", "y", "zr", "nb", "mo", "tc", "ru", "rh", "pd", 
          "ag", "cd", "in", "sn", "sb", "te", "i", "xe", "cs", "ba", "la", 
          "ce", "pr", "nd", "pm", "sm", "eu", "gd", "tb", "dy", "ho", "er", 
          "tm", "yb", "lu", "hf", "ta", "w", "re", "os", "ir", "pt", "au", 
          "hg", "tl", "pb", "bi", "po", "at", "rn", "fr", "ra", "ac", "th", 
          "pa", "u", "np", "pu", "am", "cm", "bk", "cf", "es", "fm", "md", 
          "no", "lr", "rf", "db", "sg", "bh", "hs", "mt", "ds", "rg", "cn", 
          "nh", "fl", "mc", "lv", "ts", "og", "uub", "uut", "uuq", "uup", 
          "uuh", "uus", "uuo"}}, Replace[#, 
         Dispatch[{
          "h" -> RGBColor[0.65, 0.7, 0.7], "he" -> RGBColor[0.836713, 1., 1.],
            "li" -> RGBColor[0.799435, 0.543572, 0.997559], "be" -> 
           RGBColor[0.770565, 0.964309, 0.0442359], "b" -> 
           RGBColor[1., 0.709804, 0.709804], "c" -> RGBColor[0.4, 0.4, 0.4], 
           "n" -> RGBColor[0.291989, 0.437977, 0.888609], "o" -> 
           RGBColor[0.800498, 0.201504, 0.192061], "f" -> 
           RGBColor[0.578462, 0.85539, 0.408855], "ne" -> 
           RGBColor[0.677263, 0.928423, 0.955287], "na" -> 
           RGBColor[0.658708, 0.492173, 0.842842], "mg" -> 
           RGBColor[0.628274, 0.850553, 0.0782731], "al" -> 
           RGBColor[0.8913, 0.631904, 0.627399], "si" -> 
           RGBColor[0.941176, 0.784314, 0.627451], "p" -> 
           RGBColor[1., 0.501961, 0], "s" -> 
           RGBColor[0.90443, 0.97015, 0.13504], "cl" -> 
           RGBColor[0.412698, 0.932689, 0.166398], "ar" -> 
           RGBColor[0.546138, 0.844244, 0.892092], "k" -> 
           RGBColor[0.534026, 0.420729, 0.705621], "ca" -> 
           RGBColor[0.480072, 0.744591, 0.0955222], "sc" -> 
           RGBColor[0.901961, 0.901961, 0.901961], "ti" -> 
           RGBColor[0.74902, 0.760784, 0.780392], "v" -> 
           RGBColor[0.65098, 0.65098, 0.670588], "cr" -> 
           RGBColor[0.541176, 0.6, 0.780392], "mn" -> 
           RGBColor[0.611765, 0.478431, 0.780392], "fe" -> 
           RGBColor[0.878431, 0.4, 0.2], "co" -> 
           RGBColor[0.941176, 0.564706, 0.627451], "ni" -> 
           RGBColor[0.313725, 0.815686, 0.313725], "cu" -> 
           RGBColor[0.784314, 0.501961, 0.2], "zn" -> 
           RGBColor[0.490196, 0.501961, 0.690196], "ga" -> 
           RGBColor[0.800757, 0.542666, 0.533513], "ge" -> 
           RGBColor[0.60508, 0.632465, 0.576489], "as" -> 
           RGBColor[0.741176, 0.501961, 0.890196], "se" -> 
           RGBColor[0.917248, 0.657833, 0.0706628], "br" -> 
           RGBColor[0.58847, 0.22163, 0.16064], "kr" -> 
           RGBColor[0.426019, 0.747462, 0.810413], "rb" -> 
           RGBColor[0.425391, 0.329242, 0.585895], "sr" -> 
           RGBColor[0.325959, 0.646423, 0.095983], "y" -> 
           RGBColor[0.531014, 1., 1.], "zr" -> 
           RGBColor[0.458599, 0.917466, 0.918573], "nb" -> 
           RGBColor[0.385036, 0.834854, 0.841681], "mo" -> 
           RGBColor[0.310325, 0.752163, 0.769323], "tc" -> 
           RGBColor[0.234466, 0.669394, 0.701499], "ru" -> 
           RGBColor[0.157459, 0.586546, 0.638209], "rh" -> 
           RGBColor[0.0793033, 0.50362, 0.579453], "pd" -> 
           RGBColor[0., 0.420615, 0.525231], "ag" -> 
           RGBColor[0.752941, 0.752941, 0.752941], "cd" -> 
           RGBColor[1., 0.85098, 0.560784], "in" -> 
           RGBColor[0.728371, 0.440594, 0.422196], "sn" -> 
           RGBColor[0.39799, 0.491477, 0.495586], "sb" -> 
           RGBColor[0.619608, 0.388235, 0.709804], "te" -> 
           RGBColor[0.816706, 0.451332, 0.0100947], "i" -> 
           RGBColor[0.580392, 0, 0.580392], "xe" -> 
           RGBColor[0.316906, 0.638078, 0.710252], "cs" -> 
           RGBColor[0.332803, 0.217712, 0.483666], "ba" -> 
           RGBColor[0.165935, 0.55605, 0.0796556], "la" -> 
           RGBColor[0.928084, 0.716075, 0.329427], "ce" -> 
           RGBColor[0.894824, 0.731424, 0.325131], "pr" -> 
           RGBColor[0.86523, 0.707999, 0.315261], "nd" -> 
           RGBColor[0.837836, 0.662974, 0.301635], "pm" -> 
           RGBColor[0.811992, 0.607859, 0.285626], "sm" -> 
           RGBColor[0.787563, 0.549894, 0.268279], "eu" -> 
           RGBColor[0.764628, 0.493261, 0.250405], "gd" -> 
           RGBColor[0.743177, 0.440115, 0.23269], "tb" -> 
           RGBColor[0.72281, 0.39143, 0.215783], "dy" -> 
           RGBColor[0.702434, 0.347663, 0.200392], "ho" -> 
           RGBColor[0.679962, 0.309234, 0.187368], "er" -> 
           RGBColor[0.652012, 0.276823, 0.17779], "tm" -> 
           RGBColor[0.613603, 0.251489, 0.173042], "yb" -> 
           RGBColor[0.557855, 0.234598, 0.17489], "lu" -> 
           RGBColor[0.475685, 0.227573, 0.18555], "hf" -> 
           RGBColor[0.781537, 0.717388, 0.716579], "ta" -> 
           RGBColor[0.734443, 0.544489, 0.683471], "w" -> 
           RGBColor[0.681179, 0.360409, 0.63675], "re" -> 
           RGBColor[0.605181, 0.367584, 0.556343], "os" -> 
           RGBColor[0.521806, 0.382125, 0.469204], "ir" -> 
           RGBColor[0.445624, 0.373159, 0.399069], "pt" -> 
           RGBColor[0.815686, 0.815686, 0.878431], "au" -> 
           RGBColor[1., 0.819608, 0.137255], "hg" -> 
           RGBColor[0.721569, 0.721569, 0.815686], "tl" -> 
           RGBColor[0.65098, 0.329412, 0.301961], "pb" -> 
           RGBColor[0.341176, 0.34902, 0.380392], "bi" -> 
           RGBColor[0.619608, 0.309804, 0.709804], "po" -> 
           RGBColor[0.670588, 0.360784, 0], "at" -> 
           RGBColor[0.458824, 0.309804, 0.270588], "rn" -> 
           RGBColor[0.218799, 0.516091, 0.591608], "fr" -> 
           RGBColor[0.25626, 0.0861372, 0.398932], "ra" -> 
           RGBColor[0., 0.473472, 0.04654], "ac" -> 
           RGBColor[0.322042, 0.71693, 0.988479], "th" -> 
           RGBColor[0.3608, 0.67166, 0.943003], "pa" -> 
           RGBColor[0.397469, 0.628, 0.898853], "u" -> 
           RGBColor[0.43205, 0.58595, 0.856029], "np" -> 
           RGBColor[0.464542, 0.54551, 0.814532], "pu" -> 
           RGBColor[0.494945, 0.506679, 0.774361], "am" -> 
           RGBColor[0.52326, 0.469458, 0.735517], "cm" -> 
           RGBColor[0.549486, 0.433847, 0.697999], "bk" -> 
           RGBColor[0.573624, 0.399845, 0.661808], "cf" -> 
           RGBColor[0.595673, 0.367454, 0.626942], "es" -> 
           RGBColor[0.615633, 0.336672, 0.593404], "fm" -> 
           RGBColor[0.633505, 0.307499, 0.561191], "md" -> 
           RGBColor[0.649288, 0.279937, 0.530305], "no" -> 
           RGBColor[0.662982, 0.253984, 0.500746], "lr" -> 
           RGBColor[0.674588, 0.22964, 0.472513], "rf" -> 
           RGBColor[0.684106, 0.206907, 0.445606], "db" -> 
           RGBColor[0.691534, 0.185783, 0.420025], "sg" -> 
           RGBColor[0.696874, 0.166269, 0.395772], "bh" -> 
           RGBColor[0.700126, 0.148365, 0.372844], "hs" -> 
           RGBColor[0.701289, 0.13207, 0.351243], "mt" -> 
           RGBColor[0.700363, 0.117385, 0.330968], "ds" -> 
           RGBColor[0.697348, 0.10431, 0.31202], "rg" -> 
           RGBColor[0.692245, 0.0928444, 0.294398], "cn" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "nh" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "fl" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "mc" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "lv" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "ts" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "og" -> 
           RGBColor[0.635401, 0.0528, 0.226184], "uub" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "uut" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "uuq" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "uup" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "uuh" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "uus" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "uuo" -> 
           RGBColor[0.635401, 0.0528, 0.226184]}]]& ][0.85], 
       ColorDataFunction[
       "Atoms", 
        "Named", {{
         "H", "He", "Li", "Be", "B", "C", "N", "O", "F", "Ne", "Na", "Mg", 
          "Al", "Si", "P", "S", "Cl", "Ar", "K", "Ca", "Sc", "Ti", "V", "Cr", 
          "Mn", "Fe", "Co", "Ni", "Cu", "Zn", "Ga", "Ge", "As", "Se", "Br", 
          "Kr", "Rb", "Sr", "Y", "Zr", "Nb", "Mo", "Tc", "Ru", "Rh", "Pd", 
          "Ag", "Cd", "In", "Sn", "Sb", "Te", "I", "Xe", "Cs", "Ba", "La", 
          "Ce", "Pr", "Nd", "Pm", "Sm", "Eu", "Gd", "Tb", "Dy", "Ho", "Er", 
          "Tm", "Yb", "Lu", "Hf", "Ta", "W", "Re", "Os", "Ir", "Pt", "Au", 
          "Hg", "Tl", "Pb", "Bi", "Po", "At", "Rn", "Fr", "Ra", "Ac", "Th", 
          "Pa", "U", "Np", "Pu", "Am", "Cm", "Bk", "Cf", "Es", "Fm", "Md", 
          "No", "Lr", "Rf", "Db", "Sg", "Bh", "Hs", "Mt", "Ds", "Rg", "Cn", 
          "Nh", "Fl", "Mc", "Lv", "Ts", "Og", "Uub", "Uut", "Uuq", "Uup", 
          "Uuh", "Uus", "Uuo"}, {
         "h", "he", "li", "be", "b", "c", "n", "o", "f", "ne", "na", "mg", 
          "al", "si", "p", "s", "cl", "ar", "k", "ca", "sc", "ti", "v", "cr", 
          "mn", "fe", "co", "ni", "cu", "zn", "ga", "ge", "as", "se", "br", 
          "kr", "rb", "sr", "y", "zr", "nb", "mo", "tc", "ru", "rh", "pd", 
          "ag", "cd", "in", "sn", "sb", "te", "i", "xe", "cs", "ba", "la", 
          "ce", "pr", "nd", "pm", "sm", "eu", "gd", "tb", "dy", "ho", "er", 
          "tm", "yb", "lu", "hf", "ta", "w", "re", "os", "ir", "pt", "au", 
          "hg", "tl", "pb", "bi", "po", "at", "rn", "fr", "ra", "ac", "th", 
          "pa", "u", "np", "pu", "am", "cm", "bk", "cf", "es", "fm", "md", 
          "no", "lr", "rf", "db", "sg", "bh", "hs", "mt", "ds", "rg", "cn", 
          "nh", "fl", "mc", "lv", "ts", "og", "uub", "uut", "uuq", "uup", 
          "uuh", "uus", "uuo"}}, Replace[#, 
         Dispatch[{
          "h" -> RGBColor[0.65, 0.7, 0.7], "he" -> RGBColor[0.836713, 1., 1.],
            "li" -> RGBColor[0.799435, 0.543572, 0.997559], "be" -> 
           RGBColor[0.770565, 0.964309, 0.0442359], "b" -> 
           RGBColor[1., 0.709804, 0.709804], "c" -> RGBColor[0.4, 0.4, 0.4], 
           "n" -> RGBColor[0.291989, 0.437977, 0.888609], "o" -> 
           RGBColor[0.800498, 0.201504, 0.192061], "f" -> 
           RGBColor[0.578462, 0.85539, 0.408855], "ne" -> 
           RGBColor[0.677263, 0.928423, 0.955287], "na" -> 
           RGBColor[0.658708, 0.492173, 0.842842], "mg" -> 
           RGBColor[0.628274, 0.850553, 0.0782731], "al" -> 
           RGBColor[0.8913, 0.631904, 0.627399], "si" -> 
           RGBColor[0.941176, 0.784314, 0.627451], "p" -> 
           RGBColor[1., 0.501961, 0], "s" -> 
           RGBColor[0.90443, 0.97015, 0.13504], "cl" -> 
           RGBColor[0.412698, 0.932689, 0.166398], "ar" -> 
           RGBColor[0.546138, 0.844244, 0.892092], "k" -> 
           RGBColor[0.534026, 0.420729, 0.705621], "ca" -> 
           RGBColor[0.480072, 0.744591, 0.0955222], "sc" -> 
           RGBColor[0.901961, 0.901961, 0.901961], "ti" -> 
           RGBColor[0.74902, 0.760784, 0.780392], "v" -> 
           RGBColor[0.65098, 0.65098, 0.670588], "cr" -> 
           RGBColor[0.541176, 0.6, 0.780392], "mn" -> 
           RGBColor[0.611765, 0.478431, 0.780392], "fe" -> 
           RGBColor[0.878431, 0.4, 0.2], "co" -> 
           RGBColor[0.941176, 0.564706, 0.627451], "ni" -> 
           RGBColor[0.313725, 0.815686, 0.313725], "cu" -> 
           RGBColor[0.784314, 0.501961, 0.2], "zn" -> 
           RGBColor[0.490196, 0.501961, 0.690196], "ga" -> 
           RGBColor[0.800757, 0.542666, 0.533513], "ge" -> 
           RGBColor[0.60508, 0.632465, 0.576489], "as" -> 
           RGBColor[0.741176, 0.501961, 0.890196], "se" -> 
           RGBColor[0.917248, 0.657833, 0.0706628], "br" -> 
           RGBColor[0.58847, 0.22163, 0.16064], "kr" -> 
           RGBColor[0.426019, 0.747462, 0.810413], "rb" -> 
           RGBColor[0.425391, 0.329242, 0.585895], "sr" -> 
           RGBColor[0.325959, 0.646423, 0.095983], "y" -> 
           RGBColor[0.531014, 1., 1.], "zr" -> 
           RGBColor[0.458599, 0.917466, 0.918573], "nb" -> 
           RGBColor[0.385036, 0.834854, 0.841681], "mo" -> 
           RGBColor[0.310325, 0.752163, 0.769323], "tc" -> 
           RGBColor[0.234466, 0.669394, 0.701499], "ru" -> 
           RGBColor[0.157459, 0.586546, 0.638209], "rh" -> 
           RGBColor[0.0793033, 0.50362, 0.579453], "pd" -> 
           RGBColor[0., 0.420615, 0.525231], "ag" -> 
           RGBColor[0.752941, 0.752941, 0.752941], "cd" -> 
           RGBColor[1., 0.85098, 0.560784], "in" -> 
           RGBColor[0.728371, 0.440594, 0.422196], "sn" -> 
           RGBColor[0.39799, 0.491477, 0.495586], "sb" -> 
           RGBColor[0.619608, 0.388235, 0.709804], "te" -> 
           RGBColor[0.816706, 0.451332, 0.0100947], "i" -> 
           RGBColor[0.580392, 0, 0.580392], "xe" -> 
           RGBColor[0.316906, 0.638078, 0.710252], "cs" -> 
           RGBColor[0.332803, 0.217712, 0.483666], "ba" -> 
           RGBColor[0.165935, 0.55605, 0.0796556], "la" -> 
           RGBColor[0.928084, 0.716075, 0.329427], "ce" -> 
           RGBColor[0.894824, 0.731424, 0.325131], "pr" -> 
           RGBColor[0.86523, 0.707999, 0.315261], "nd" -> 
           RGBColor[0.837836, 0.662974, 0.301635], "pm" -> 
           RGBColor[0.811992, 0.607859, 0.285626], "sm" -> 
           RGBColor[0.787563, 0.549894, 0.268279], "eu" -> 
           RGBColor[0.764628, 0.493261, 0.250405], "gd" -> 
           RGBColor[0.743177, 0.440115, 0.23269], "tb" -> 
           RGBColor[0.72281, 0.39143, 0.215783], "dy" -> 
           RGBColor[0.702434, 0.347663, 0.200392], "ho" -> 
           RGBColor[0.679962, 0.309234, 0.187368], "er" -> 
           RGBColor[0.652012, 0.276823, 0.17779], "tm" -> 
           RGBColor[0.613603, 0.251489, 0.173042], "yb" -> 
           RGBColor[0.557855, 0.234598, 0.17489], "lu" -> 
           RGBColor[0.475685, 0.227573, 0.18555], "hf" -> 
           RGBColor[0.781537, 0.717388, 0.716579], "ta" -> 
           RGBColor[0.734443, 0.544489, 0.683471], "w" -> 
           RGBColor[0.681179, 0.360409, 0.63675], "re" -> 
           RGBColor[0.605181, 0.367584, 0.556343], "os" -> 
           RGBColor[0.521806, 0.382125, 0.469204], "ir" -> 
           RGBColor[0.445624, 0.373159, 0.399069], "pt" -> 
           RGBColor[0.815686, 0.815686, 0.878431], "au" -> 
           RGBColor[1., 0.819608, 0.137255], "hg" -> 
           RGBColor[0.721569, 0.721569, 0.815686], "tl" -> 
           RGBColor[0.65098, 0.329412, 0.301961], "pb" -> 
           RGBColor[0.341176, 0.34902, 0.380392], "bi" -> 
           RGBColor[0.619608, 0.309804, 0.709804], "po" -> 
           RGBColor[0.670588, 0.360784, 0], "at" -> 
           RGBColor[0.458824, 0.309804, 0.270588], "rn" -> 
           RGBColor[0.218799, 0.516091, 0.591608], "fr" -> 
           RGBColor[0.25626, 0.0861372, 0.398932], "ra" -> 
           RGBColor[0., 0.473472, 0.04654], "ac" -> 
           RGBColor[0.322042, 0.71693, 0.988479], "th" -> 
           RGBColor[0.3608, 0.67166, 0.943003], "pa" -> 
           RGBColor[0.397469, 0.628, 0.898853], "u" -> 
           RGBColor[0.43205, 0.58595, 0.856029], "np" -> 
           RGBColor[0.464542, 0.54551, 0.814532], "pu" -> 
           RGBColor[0.494945, 0.506679, 0.774361], "am" -> 
           RGBColor[0.52326, 0.469458, 0.735517], "cm" -> 
           RGBColor[0.549486, 0.433847, 0.697999], "bk" -> 
           RGBColor[0.573624, 0.399845, 0.661808], "cf" -> 
           RGBColor[0.595673, 0.367454, 0.626942], "es" -> 
           RGBColor[0.615633, 0.336672, 0.593404], "fm" -> 
           RGBColor[0.633505, 0.307499, 0.561191], "md" -> 
           RGBColor[0.649288, 0.279937, 0.530305], "no" -> 
           RGBColor[0.662982, 0.253984, 0.500746], "lr" -> 
           RGBColor[0.674588, 0.22964, 0.472513], "rf" -> 
           RGBColor[0.684106, 0.206907, 0.445606], "db" -> 
           RGBColor[0.691534, 0.185783, 0.420025], "sg" -> 
           RGBColor[0.696874, 0.166269, 0.395772], "bh" -> 
           RGBColor[0.700126, 0.148365, 0.372844], "hs" -> 
           RGBColor[0.701289, 0.13207, 0.351243], "mt" -> 
           RGBColor[0.700363, 0.117385, 0.330968], "ds" -> 
           RGBColor[0.697348, 0.10431, 0.31202], "rg" -> 
           RGBColor[0.692245, 0.0928444, 0.294398], "cn" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "nh" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "fl" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "mc" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "lv" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "ts" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "og" -> 
           RGBColor[0.635401, 0.0528, 0.226184], "uub" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "uut" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "uuq" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "uup" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "uuh" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "uus" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "uuo" -> 
           RGBColor[0.635401, 0.0528, 0.226184]}]]& ][0.85], 
       ColorDataFunction[
       "Atoms", 
        "Named", {{
         "H", "He", "Li", "Be", "B", "C", "N", "O", "F", "Ne", "Na", "Mg", 
          "Al", "Si", "P", "S", "Cl", "Ar", "K", "Ca", "Sc", "Ti", "V", "Cr", 
          "Mn", "Fe", "Co", "Ni", "Cu", "Zn", "Ga", "Ge", "As", "Se", "Br", 
          "Kr", "Rb", "Sr", "Y", "Zr", "Nb", "Mo", "Tc", "Ru", "Rh", "Pd", 
          "Ag", "Cd", "In", "Sn", "Sb", "Te", "I", "Xe", "Cs", "Ba", "La", 
          "Ce", "Pr", "Nd", "Pm", "Sm", "Eu", "Gd", "Tb", "Dy", "Ho", "Er", 
          "Tm", "Yb", "Lu", "Hf", "Ta", "W", "Re", "Os", "Ir", "Pt", "Au", 
          "Hg", "Tl", "Pb", "Bi", "Po", "At", "Rn", "Fr", "Ra", "Ac", "Th", 
          "Pa", "U", "Np", "Pu", "Am", "Cm", "Bk", "Cf", "Es", "Fm", "Md", 
          "No", "Lr", "Rf", "Db", "Sg", "Bh", "Hs", "Mt", "Ds", "Rg", "Cn", 
          "Nh", "Fl", "Mc", "Lv", "Ts", "Og", "Uub", "Uut", "Uuq", "Uup", 
          "Uuh", "Uus", "Uuo"}, {
         "h", "he", "li", "be", "b", "c", "n", "o", "f", "ne", "na", "mg", 
          "al", "si", "p", "s", "cl", "ar", "k", "ca", "sc", "ti", "v", "cr", 
          "mn", "fe", "co", "ni", "cu", "zn", "ga", "ge", "as", "se", "br", 
          "kr", "rb", "sr", "y", "zr", "nb", "mo", "tc", "ru", "rh", "pd", 
          "ag", "cd", "in", "sn", "sb", "te", "i", "xe", "cs", "ba", "la", 
          "ce", "pr", "nd", "pm", "sm", "eu", "gd", "tb", "dy", "ho", "er", 
          "tm", "yb", "lu", "hf", "ta", "w", "re", "os", "ir", "pt", "au", 
          "hg", "tl", "pb", "bi", "po", "at", "rn", "fr", "ra", "ac", "th", 
          "pa", "u", "np", "pu", "am", "cm", "bk", "cf", "es", "fm", "md", 
          "no", "lr", "rf", "db", "sg", "bh", "hs", "mt", "ds", "rg", "cn", 
          "nh", "fl", "mc", "lv", "ts", "og", "uub", "uut", "uuq", "uup", 
          "uuh", "uus", "uuo"}}, Replace[#, 
         Dispatch[{
          "h" -> RGBColor[0.65, 0.7, 0.7], "he" -> RGBColor[0.836713, 1., 1.],
            "li" -> RGBColor[0.799435, 0.543572, 0.997559], "be" -> 
           RGBColor[0.770565, 0.964309, 0.0442359], "b" -> 
           RGBColor[1., 0.709804, 0.709804], "c" -> RGBColor[0.4, 0.4, 0.4], 
           "n" -> RGBColor[0.291989, 0.437977, 0.888609], "o" -> 
           RGBColor[0.800498, 0.201504, 0.192061], "f" -> 
           RGBColor[0.578462, 0.85539, 0.408855], "ne" -> 
           RGBColor[0.677263, 0.928423, 0.955287], "na" -> 
           RGBColor[0.658708, 0.492173, 0.842842], "mg" -> 
           RGBColor[0.628274, 0.850553, 0.0782731], "al" -> 
           RGBColor[0.8913, 0.631904, 0.627399], "si" -> 
           RGBColor[0.941176, 0.784314, 0.627451], "p" -> 
           RGBColor[1., 0.501961, 0], "s" -> 
           RGBColor[0.90443, 0.97015, 0.13504], "cl" -> 
           RGBColor[0.412698, 0.932689, 0.166398], "ar" -> 
           RGBColor[0.546138, 0.844244, 0.892092], "k" -> 
           RGBColor[0.534026, 0.420729, 0.705621], "ca" -> 
           RGBColor[0.480072, 0.744591, 0.0955222], "sc" -> 
           RGBColor[0.901961, 0.901961, 0.901961], "ti" -> 
           RGBColor[0.74902, 0.760784, 0.780392], "v" -> 
           RGBColor[0.65098, 0.65098, 0.670588], "cr" -> 
           RGBColor[0.541176, 0.6, 0.780392], "mn" -> 
           RGBColor[0.611765, 0.478431, 0.780392], "fe" -> 
           RGBColor[0.878431, 0.4, 0.2], "co" -> 
           RGBColor[0.941176, 0.564706, 0.627451], "ni" -> 
           RGBColor[0.313725, 0.815686, 0.313725], "cu" -> 
           RGBColor[0.784314, 0.501961, 0.2], "zn" -> 
           RGBColor[0.490196, 0.501961, 0.690196], "ga" -> 
           RGBColor[0.800757, 0.542666, 0.533513], "ge" -> 
           RGBColor[0.60508, 0.632465, 0.576489], "as" -> 
           RGBColor[0.741176, 0.501961, 0.890196], "se" -> 
           RGBColor[0.917248, 0.657833, 0.0706628], "br" -> 
           RGBColor[0.58847, 0.22163, 0.16064], "kr" -> 
           RGBColor[0.426019, 0.747462, 0.810413], "rb" -> 
           RGBColor[0.425391, 0.329242, 0.585895], "sr" -> 
           RGBColor[0.325959, 0.646423, 0.095983], "y" -> 
           RGBColor[0.531014, 1., 1.], "zr" -> 
           RGBColor[0.458599, 0.917466, 0.918573], "nb" -> 
           RGBColor[0.385036, 0.834854, 0.841681], "mo" -> 
           RGBColor[0.310325, 0.752163, 0.769323], "tc" -> 
           RGBColor[0.234466, 0.669394, 0.701499], "ru" -> 
           RGBColor[0.157459, 0.586546, 0.638209], "rh" -> 
           RGBColor[0.0793033, 0.50362, 0.579453], "pd" -> 
           RGBColor[0., 0.420615, 0.525231], "ag" -> 
           RGBColor[0.752941, 0.752941, 0.752941], "cd" -> 
           RGBColor[1., 0.85098, 0.560784], "in" -> 
           RGBColor[0.728371, 0.440594, 0.422196], "sn" -> 
           RGBColor[0.39799, 0.491477, 0.495586], "sb" -> 
           RGBColor[0.619608, 0.388235, 0.709804], "te" -> 
           RGBColor[0.816706, 0.451332, 0.0100947], "i" -> 
           RGBColor[0.580392, 0, 0.580392], "xe" -> 
           RGBColor[0.316906, 0.638078, 0.710252], "cs" -> 
           RGBColor[0.332803, 0.217712, 0.483666], "ba" -> 
           RGBColor[0.165935, 0.55605, 0.0796556], "la" -> 
           RGBColor[0.928084, 0.716075, 0.329427], "ce" -> 
           RGBColor[0.894824, 0.731424, 0.325131], "pr" -> 
           RGBColor[0.86523, 0.707999, 0.315261], "nd" -> 
           RGBColor[0.837836, 0.662974, 0.301635], "pm" -> 
           RGBColor[0.811992, 0.607859, 0.285626], "sm" -> 
           RGBColor[0.787563, 0.549894, 0.268279], "eu" -> 
           RGBColor[0.764628, 0.493261, 0.250405], "gd" -> 
           RGBColor[0.743177, 0.440115, 0.23269], "tb" -> 
           RGBColor[0.72281, 0.39143, 0.215783], "dy" -> 
           RGBColor[0.702434, 0.347663, 0.200392], "ho" -> 
           RGBColor[0.679962, 0.309234, 0.187368], "er" -> 
           RGBColor[0.652012, 0.276823, 0.17779], "tm" -> 
           RGBColor[0.613603, 0.251489, 0.173042], "yb" -> 
           RGBColor[0.557855, 0.234598, 0.17489], "lu" -> 
           RGBColor[0.475685, 0.227573, 0.18555], "hf" -> 
           RGBColor[0.781537, 0.717388, 0.716579], "ta" -> 
           RGBColor[0.734443, 0.544489, 0.683471], "w" -> 
           RGBColor[0.681179, 0.360409, 0.63675], "re" -> 
           RGBColor[0.605181, 0.367584, 0.556343], "os" -> 
           RGBColor[0.521806, 0.382125, 0.469204], "ir" -> 
           RGBColor[0.445624, 0.373159, 0.399069], "pt" -> 
           RGBColor[0.815686, 0.815686, 0.878431], "au" -> 
           RGBColor[1., 0.819608, 0.137255], "hg" -> 
           RGBColor[0.721569, 0.721569, 0.815686], "tl" -> 
           RGBColor[0.65098, 0.329412, 0.301961], "pb" -> 
           RGBColor[0.341176, 0.34902, 0.380392], "bi" -> 
           RGBColor[0.619608, 0.309804, 0.709804], "po" -> 
           RGBColor[0.670588, 0.360784, 0], "at" -> 
           RGBColor[0.458824, 0.309804, 0.270588], "rn" -> 
           RGBColor[0.218799, 0.516091, 0.591608], "fr" -> 
           RGBColor[0.25626, 0.0861372, 0.398932], "ra" -> 
           RGBColor[0., 0.473472, 0.04654], "ac" -> 
           RGBColor[0.322042, 0.71693, 0.988479], "th" -> 
           RGBColor[0.3608, 0.67166, 0.943003], "pa" -> 
           RGBColor[0.397469, 0.628, 0.898853], "u" -> 
           RGBColor[0.43205, 0.58595, 0.856029], "np" -> 
           RGBColor[0.464542, 0.54551, 0.814532], "pu" -> 
           RGBColor[0.494945, 0.506679, 0.774361], "am" -> 
           RGBColor[0.52326, 0.469458, 0.735517], "cm" -> 
           RGBColor[0.549486, 0.433847, 0.697999], "bk" -> 
           RGBColor[0.573624, 0.399845, 0.661808], "cf" -> 
           RGBColor[0.595673, 0.367454, 0.626942], "es" -> 
           RGBColor[0.615633, 0.336672, 0.593404], "fm" -> 
           RGBColor[0.633505, 0.307499, 0.561191], "md" -> 
           RGBColor[0.649288, 0.279937, 0.530305], "no" -> 
           RGBColor[0.662982, 0.253984, 0.500746], "lr" -> 
           RGBColor[0.674588, 0.22964, 0.472513], "rf" -> 
           RGBColor[0.684106, 0.206907, 0.445606], "db" -> 
           RGBColor[0.691534, 0.185783, 0.420025], "sg" -> 
           RGBColor[0.696874, 0.166269, 0.395772], "bh" -> 
           RGBColor[0.700126, 0.148365, 0.372844], "hs" -> 
           RGBColor[0.701289, 0.13207, 0.351243], "mt" -> 
           RGBColor[0.700363, 0.117385, 0.330968], "ds" -> 
           RGBColor[0.697348, 0.10431, 0.31202], "rg" -> 
           RGBColor[0.692245, 0.0928444, 0.294398], "cn" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "nh" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "fl" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "mc" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "lv" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "ts" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "og" -> 
           RGBColor[0.635401, 0.0528, 0.226184], "uub" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "uut" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "uuq" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "uup" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "uuh" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "uus" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "uuo" -> 
           RGBColor[0.635401, 0.0528, 0.226184]}]]& ][0.85], 
       ColorDataFunction[
       "Atoms", 
        "Named", {{
         "H", "He", "Li", "Be", "B", "C", "N", "O", "F", "Ne", "Na", "Mg", 
          "Al", "Si", "P", "S", "Cl", "Ar", "K", "Ca", "Sc", "Ti", "V", "Cr", 
          "Mn", "Fe", "Co", "Ni", "Cu", "Zn", "Ga", "Ge", "As", "Se", "Br", 
          "Kr", "Rb", "Sr", "Y", "Zr", "Nb", "Mo", "Tc", "Ru", "Rh", "Pd", 
          "Ag", "Cd", "In", "Sn", "Sb", "Te", "I", "Xe", "Cs", "Ba", "La", 
          "Ce", "Pr", "Nd", "Pm", "Sm", "Eu", "Gd", "Tb", "Dy", "Ho", "Er", 
          "Tm", "Yb", "Lu", "Hf", "Ta", "W", "Re", "Os", "Ir", "Pt", "Au", 
          "Hg", "Tl", "Pb", "Bi", "Po", "At", "Rn", "Fr", "Ra", "Ac", "Th", 
          "Pa", "U", "Np", "Pu", "Am", "Cm", "Bk", "Cf", "Es", "Fm", "Md", 
          "No", "Lr", "Rf", "Db", "Sg", "Bh", "Hs", "Mt", "Ds", "Rg", "Cn", 
          "Nh", "Fl", "Mc", "Lv", "Ts", "Og", "Uub", "Uut", "Uuq", "Uup", 
          "Uuh", "Uus", "Uuo"}, {
         "h", "he", "li", "be", "b", "c", "n", "o", "f", "ne", "na", "mg", 
          "al", "si", "p", "s", "cl", "ar", "k", "ca", "sc", "ti", "v", "cr", 
          "mn", "fe", "co", "ni", "cu", "zn", "ga", "ge", "as", "se", "br", 
          "kr", "rb", "sr", "y", "zr", "nb", "mo", "tc", "ru", "rh", "pd", 
          "ag", "cd", "in", "sn", "sb", "te", "i", "xe", "cs", "ba", "la", 
          "ce", "pr", "nd", "pm", "sm", "eu", "gd", "tb", "dy", "ho", "er", 
          "tm", "yb", "lu", "hf", "ta", "w", "re", "os", "ir", "pt", "au", 
          "hg", "tl", "pb", "bi", "po", "at", "rn", "fr", "ra", "ac", "th", 
          "pa", "u", "np", "pu", "am", "cm", "bk", "cf", "es", "fm", "md", 
          "no", "lr", "rf", "db", "sg", "bh", "hs", "mt", "ds", "rg", "cn", 
          "nh", "fl", "mc", "lv", "ts", "og", "uub", "uut", "uuq", "uup", 
          "uuh", "uus", "uuo"}}, Replace[#, 
         Dispatch[{
          "h" -> RGBColor[0.65, 0.7, 0.7], "he" -> RGBColor[0.836713, 1., 1.],
            "li" -> RGBColor[0.799435, 0.543572, 0.997559], "be" -> 
           RGBColor[0.770565, 0.964309, 0.0442359], "b" -> 
           RGBColor[1., 0.709804, 0.709804], "c" -> RGBColor[0.4, 0.4, 0.4], 
           "n" -> RGBColor[0.291989, 0.437977, 0.888609], "o" -> 
           RGBColor[0.800498, 0.201504, 0.192061], "f" -> 
           RGBColor[0.578462, 0.85539, 0.408855], "ne" -> 
           RGBColor[0.677263, 0.928423, 0.955287], "na" -> 
           RGBColor[0.658708, 0.492173, 0.842842], "mg" -> 
           RGBColor[0.628274, 0.850553, 0.0782731], "al" -> 
           RGBColor[0.8913, 0.631904, 0.627399], "si" -> 
           RGBColor[0.941176, 0.784314, 0.627451], "p" -> 
           RGBColor[1., 0.501961, 0], "s" -> 
           RGBColor[0.90443, 0.97015, 0.13504], "cl" -> 
           RGBColor[0.412698, 0.932689, 0.166398], "ar" -> 
           RGBColor[0.546138, 0.844244, 0.892092], "k" -> 
           RGBColor[0.534026, 0.420729, 0.705621], "ca" -> 
           RGBColor[0.480072, 0.744591, 0.0955222], "sc" -> 
           RGBColor[0.901961, 0.901961, 0.901961], "ti" -> 
           RGBColor[0.74902, 0.760784, 0.780392], "v" -> 
           RGBColor[0.65098, 0.65098, 0.670588], "cr" -> 
           RGBColor[0.541176, 0.6, 0.780392], "mn" -> 
           RGBColor[0.611765, 0.478431, 0.780392], "fe" -> 
           RGBColor[0.878431, 0.4, 0.2], "co" -> 
           RGBColor[0.941176, 0.564706, 0.627451], "ni" -> 
           RGBColor[0.313725, 0.815686, 0.313725], "cu" -> 
           RGBColor[0.784314, 0.501961, 0.2], "zn" -> 
           RGBColor[0.490196, 0.501961, 0.690196], "ga" -> 
           RGBColor[0.800757, 0.542666, 0.533513], "ge" -> 
           RGBColor[0.60508, 0.632465, 0.576489], "as" -> 
           RGBColor[0.741176, 0.501961, 0.890196], "se" -> 
           RGBColor[0.917248, 0.657833, 0.0706628], "br" -> 
           RGBColor[0.58847, 0.22163, 0.16064], "kr" -> 
           RGBColor[0.426019, 0.747462, 0.810413], "rb" -> 
           RGBColor[0.425391, 0.329242, 0.585895], "sr" -> 
           RGBColor[0.325959, 0.646423, 0.095983], "y" -> 
           RGBColor[0.531014, 1., 1.], "zr" -> 
           RGBColor[0.458599, 0.917466, 0.918573], "nb" -> 
           RGBColor[0.385036, 0.834854, 0.841681], "mo" -> 
           RGBColor[0.310325, 0.752163, 0.769323], "tc" -> 
           RGBColor[0.234466, 0.669394, 0.701499], "ru" -> 
           RGBColor[0.157459, 0.586546, 0.638209], "rh" -> 
           RGBColor[0.0793033, 0.50362, 0.579453], "pd" -> 
           RGBColor[0., 0.420615, 0.525231], "ag" -> 
           RGBColor[0.752941, 0.752941, 0.752941], "cd" -> 
           RGBColor[1., 0.85098, 0.560784], "in" -> 
           RGBColor[0.728371, 0.440594, 0.422196], "sn" -> 
           RGBColor[0.39799, 0.491477, 0.495586], "sb" -> 
           RGBColor[0.619608, 0.388235, 0.709804], "te" -> 
           RGBColor[0.816706, 0.451332, 0.0100947], "i" -> 
           RGBColor[0.580392, 0, 0.580392], "xe" -> 
           RGBColor[0.316906, 0.638078, 0.710252], "cs" -> 
           RGBColor[0.332803, 0.217712, 0.483666], "ba" -> 
           RGBColor[0.165935, 0.55605, 0.0796556], "la" -> 
           RGBColor[0.928084, 0.716075, 0.329427], "ce" -> 
           RGBColor[0.894824, 0.731424, 0.325131], "pr" -> 
           RGBColor[0.86523, 0.707999, 0.315261], "nd" -> 
           RGBColor[0.837836, 0.662974, 0.301635], "pm" -> 
           RGBColor[0.811992, 0.607859, 0.285626], "sm" -> 
           RGBColor[0.787563, 0.549894, 0.268279], "eu" -> 
           RGBColor[0.764628, 0.493261, 0.250405], "gd" -> 
           RGBColor[0.743177, 0.440115, 0.23269], "tb" -> 
           RGBColor[0.72281, 0.39143, 0.215783], "dy" -> 
           RGBColor[0.702434, 0.347663, 0.200392], "ho" -> 
           RGBColor[0.679962, 0.309234, 0.187368], "er" -> 
           RGBColor[0.652012, 0.276823, 0.17779], "tm" -> 
           RGBColor[0.613603, 0.251489, 0.173042], "yb" -> 
           RGBColor[0.557855, 0.234598, 0.17489], "lu" -> 
           RGBColor[0.475685, 0.227573, 0.18555], "hf" -> 
           RGBColor[0.781537, 0.717388, 0.716579], "ta" -> 
           RGBColor[0.734443, 0.544489, 0.683471], "w" -> 
           RGBColor[0.681179, 0.360409, 0.63675], "re" -> 
           RGBColor[0.605181, 0.367584, 0.556343], "os" -> 
           RGBColor[0.521806, 0.382125, 0.469204], "ir" -> 
           RGBColor[0.445624, 0.373159, 0.399069], "pt" -> 
           RGBColor[0.815686, 0.815686, 0.878431], "au" -> 
           RGBColor[1., 0.819608, 0.137255], "hg" -> 
           RGBColor[0.721569, 0.721569, 0.815686], "tl" -> 
           RGBColor[0.65098, 0.329412, 0.301961], "pb" -> 
           RGBColor[0.341176, 0.34902, 0.380392], "bi" -> 
           RGBColor[0.619608, 0.309804, 0.709804], "po" -> 
           RGBColor[0.670588, 0.360784, 0], "at" -> 
           RGBColor[0.458824, 0.309804, 0.270588], "rn" -> 
           RGBColor[0.218799, 0.516091, 0.591608], "fr" -> 
           RGBColor[0.25626, 0.0861372, 0.398932], "ra" -> 
           RGBColor[0., 0.473472, 0.04654], "ac" -> 
           RGBColor[0.322042, 0.71693, 0.988479], "th" -> 
           RGBColor[0.3608, 0.67166, 0.943003], "pa" -> 
           RGBColor[0.397469, 0.628, 0.898853], "u" -> 
           RGBColor[0.43205, 0.58595, 0.856029], "np" -> 
           RGBColor[0.464542, 0.54551, 0.814532], "pu" -> 
           RGBColor[0.494945, 0.506679, 0.774361], "am" -> 
           RGBColor[0.52326, 0.469458, 0.735517], "cm" -> 
           RGBColor[0.549486, 0.433847, 0.697999], "bk" -> 
           RGBColor[0.573624, 0.399845, 0.661808], "cf" -> 
           RGBColor[0.595673, 0.367454, 0.626942], "es" -> 
           RGBColor[0.615633, 0.336672, 0.593404], "fm" -> 
           RGBColor[0.633505, 0.307499, 0.561191], "md" -> 
           RGBColor[0.649288, 0.279937, 0.530305], "no" -> 
           RGBColor[0.662982, 0.253984, 0.500746], "lr" -> 
           RGBColor[0.674588, 0.22964, 0.472513], "rf" -> 
           RGBColor[0.684106, 0.206907, 0.445606], "db" -> 
           RGBColor[0.691534, 0.185783, 0.420025], "sg" -> 
           RGBColor[0.696874, 0.166269, 0.395772], "bh" -> 
           RGBColor[0.700126, 0.148365, 0.372844], "hs" -> 
           RGBColor[0.701289, 0.13207, 0.351243], "mt" -> 
           RGBColor[0.700363, 0.117385, 0.330968], "ds" -> 
           RGBColor[0.697348, 0.10431, 0.31202], "rg" -> 
           RGBColor[0.692245, 0.0928444, 0.294398], "cn" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "nh" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "fl" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "mc" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "lv" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "ts" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "og" -> 
           RGBColor[0.635401, 0.0528, 0.226184], "uub" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "uut" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "uuq" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "uup" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "uuh" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "uus" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "uuo" -> 
           RGBColor[0.635401, 0.0528, 0.226184]}]]& ][0.85], 
       ColorDataFunction[
       "Atoms", 
        "Named", {{
         "H", "He", "Li", "Be", "B", "C", "N", "O", "F", "Ne", "Na", "Mg", 
          "Al", "Si", "P", "S", "Cl", "Ar", "K", "Ca", "Sc", "Ti", "V", "Cr", 
          "Mn", "Fe", "Co", "Ni", "Cu", "Zn", "Ga", "Ge", "As", "Se", "Br", 
          "Kr", "Rb", "Sr", "Y", "Zr", "Nb", "Mo", "Tc", "Ru", "Rh", "Pd", 
          "Ag", "Cd", "In", "Sn", "Sb", "Te", "I", "Xe", "Cs", "Ba", "La", 
          "Ce", "Pr", "Nd", "Pm", "Sm", "Eu", "Gd", "Tb", "Dy", "Ho", "Er", 
          "Tm", "Yb", "Lu", "Hf", "Ta", "W", "Re", "Os", "Ir", "Pt", "Au", 
          "Hg", "Tl", "Pb", "Bi", "Po", "At", "Rn", "Fr", "Ra", "Ac", "Th", 
          "Pa", "U", "Np", "Pu", "Am", "Cm", "Bk", "Cf", "Es", "Fm", "Md", 
          "No", "Lr", "Rf", "Db", "Sg", "Bh", "Hs", "Mt", "Ds", "Rg", "Cn", 
          "Nh", "Fl", "Mc", "Lv", "Ts", "Og", "Uub", "Uut", "Uuq", "Uup", 
          "Uuh", "Uus", "Uuo"}, {
         "h", "he", "li", "be", "b", "c", "n", "o", "f", "ne", "na", "mg", 
          "al", "si", "p", "s", "cl", "ar", "k", "ca", "sc", "ti", "v", "cr", 
          "mn", "fe", "co", "ni", "cu", "zn", "ga", "ge", "as", "se", "br", 
          "kr", "rb", "sr", "y", "zr", "nb", "mo", "tc", "ru", "rh", "pd", 
          "ag", "cd", "in", "sn", "sb", "te", "i", "xe", "cs", "ba", "la", 
          "ce", "pr", "nd", "pm", "sm", "eu", "gd", "tb", "dy", "ho", "er", 
          "tm", "yb", "lu", "hf", "ta", "w", "re", "os", "ir", "pt", "au", 
          "hg", "tl", "pb", "bi", "po", "at", "rn", "fr", "ra", "ac", "th", 
          "pa", "u", "np", "pu", "am", "cm", "bk", "cf", "es", "fm", "md", 
          "no", "lr", "rf", "db", "sg", "bh", "hs", "mt", "ds", "rg", "cn", 
          "nh", "fl", "mc", "lv", "ts", "og", "uub", "uut", "uuq", "uup", 
          "uuh", "uus", "uuo"}}, Replace[#, 
         Dispatch[{
          "h" -> RGBColor[0.65, 0.7, 0.7], "he" -> RGBColor[0.836713, 1., 1.],
            "li" -> RGBColor[0.799435, 0.543572, 0.997559], "be" -> 
           RGBColor[0.770565, 0.964309, 0.0442359], "b" -> 
           RGBColor[1., 0.709804, 0.709804], "c" -> RGBColor[0.4, 0.4, 0.4], 
           "n" -> RGBColor[0.291989, 0.437977, 0.888609], "o" -> 
           RGBColor[0.800498, 0.201504, 0.192061], "f" -> 
           RGBColor[0.578462, 0.85539, 0.408855], "ne" -> 
           RGBColor[0.677263, 0.928423, 0.955287], "na" -> 
           RGBColor[0.658708, 0.492173, 0.842842], "mg" -> 
           RGBColor[0.628274, 0.850553, 0.0782731], "al" -> 
           RGBColor[0.8913, 0.631904, 0.627399], "si" -> 
           RGBColor[0.941176, 0.784314, 0.627451], "p" -> 
           RGBColor[1., 0.501961, 0], "s" -> 
           RGBColor[0.90443, 0.97015, 0.13504], "cl" -> 
           RGBColor[0.412698, 0.932689, 0.166398], "ar" -> 
           RGBColor[0.546138, 0.844244, 0.892092], "k" -> 
           RGBColor[0.534026, 0.420729, 0.705621], "ca" -> 
           RGBColor[0.480072, 0.744591, 0.0955222], "sc" -> 
           RGBColor[0.901961, 0.901961, 0.901961], "ti" -> 
           RGBColor[0.74902, 0.760784, 0.780392], "v" -> 
           RGBColor[0.65098, 0.65098, 0.670588], "cr" -> 
           RGBColor[0.541176, 0.6, 0.780392], "mn" -> 
           RGBColor[0.611765, 0.478431, 0.780392], "fe" -> 
           RGBColor[0.878431, 0.4, 0.2], "co" -> 
           RGBColor[0.941176, 0.564706, 0.627451], "ni" -> 
           RGBColor[0.313725, 0.815686, 0.313725], "cu" -> 
           RGBColor[0.784314, 0.501961, 0.2], "zn" -> 
           RGBColor[0.490196, 0.501961, 0.690196], "ga" -> 
           RGBColor[0.800757, 0.542666, 0.533513], "ge" -> 
           RGBColor[0.60508, 0.632465, 0.576489], "as" -> 
           RGBColor[0.741176, 0.501961, 0.890196], "se" -> 
           RGBColor[0.917248, 0.657833, 0.0706628], "br" -> 
           RGBColor[0.58847, 0.22163, 0.16064], "kr" -> 
           RGBColor[0.426019, 0.747462, 0.810413], "rb" -> 
           RGBColor[0.425391, 0.329242, 0.585895], "sr" -> 
           RGBColor[0.325959, 0.646423, 0.095983], "y" -> 
           RGBColor[0.531014, 1., 1.], "zr" -> 
           RGBColor[0.458599, 0.917466, 0.918573], "nb" -> 
           RGBColor[0.385036, 0.834854, 0.841681], "mo" -> 
           RGBColor[0.310325, 0.752163, 0.769323], "tc" -> 
           RGBColor[0.234466, 0.669394, 0.701499], "ru" -> 
           RGBColor[0.157459, 0.586546, 0.638209], "rh" -> 
           RGBColor[0.0793033, 0.50362, 0.579453], "pd" -> 
           RGBColor[0., 0.420615, 0.525231], "ag" -> 
           RGBColor[0.752941, 0.752941, 0.752941], "cd" -> 
           RGBColor[1., 0.85098, 0.560784], "in" -> 
           RGBColor[0.728371, 0.440594, 0.422196], "sn" -> 
           RGBColor[0.39799, 0.491477, 0.495586], "sb" -> 
           RGBColor[0.619608, 0.388235, 0.709804], "te" -> 
           RGBColor[0.816706, 0.451332, 0.0100947], "i" -> 
           RGBColor[0.580392, 0, 0.580392], "xe" -> 
           RGBColor[0.316906, 0.638078, 0.710252], "cs" -> 
           RGBColor[0.332803, 0.217712, 0.483666], "ba" -> 
           RGBColor[0.165935, 0.55605, 0.0796556], "la" -> 
           RGBColor[0.928084, 0.716075, 0.329427], "ce" -> 
           RGBColor[0.894824, 0.731424, 0.325131], "pr" -> 
           RGBColor[0.86523, 0.707999, 0.315261], "nd" -> 
           RGBColor[0.837836, 0.662974, 0.301635], "pm" -> 
           RGBColor[0.811992, 0.607859, 0.285626], "sm" -> 
           RGBColor[0.787563, 0.549894, 0.268279], "eu" -> 
           RGBColor[0.764628, 0.493261, 0.250405], "gd" -> 
           RGBColor[0.743177, 0.440115, 0.23269], "tb" -> 
           RGBColor[0.72281, 0.39143, 0.215783], "dy" -> 
           RGBColor[0.702434, 0.347663, 0.200392], "ho" -> 
           RGBColor[0.679962, 0.309234, 0.187368], "er" -> 
           RGBColor[0.652012, 0.276823, 0.17779], "tm" -> 
           RGBColor[0.613603, 0.251489, 0.173042], "yb" -> 
           RGBColor[0.557855, 0.234598, 0.17489], "lu" -> 
           RGBColor[0.475685, 0.227573, 0.18555], "hf" -> 
           RGBColor[0.781537, 0.717388, 0.716579], "ta" -> 
           RGBColor[0.734443, 0.544489, 0.683471], "w" -> 
           RGBColor[0.681179, 0.360409, 0.63675], "re" -> 
           RGBColor[0.605181, 0.367584, 0.556343], "os" -> 
           RGBColor[0.521806, 0.382125, 0.469204], "ir" -> 
           RGBColor[0.445624, 0.373159, 0.399069], "pt" -> 
           RGBColor[0.815686, 0.815686, 0.878431], "au" -> 
           RGBColor[1., 0.819608, 0.137255], "hg" -> 
           RGBColor[0.721569, 0.721569, 0.815686], "tl" -> 
           RGBColor[0.65098, 0.329412, 0.301961], "pb" -> 
           RGBColor[0.341176, 0.34902, 0.380392], "bi" -> 
           RGBColor[0.619608, 0.309804, 0.709804], "po" -> 
           RGBColor[0.670588, 0.360784, 0], "at" -> 
           RGBColor[0.458824, 0.309804, 0.270588], "rn" -> 
           RGBColor[0.218799, 0.516091, 0.591608], "fr" -> 
           RGBColor[0.25626, 0.0861372, 0.398932], "ra" -> 
           RGBColor[0., 0.473472, 0.04654], "ac" -> 
           RGBColor[0.322042, 0.71693, 0.988479], "th" -> 
           RGBColor[0.3608, 0.67166, 0.943003], "pa" -> 
           RGBColor[0.397469, 0.628, 0.898853], "u" -> 
           RGBColor[0.43205, 0.58595, 0.856029], "np" -> 
           RGBColor[0.464542, 0.54551, 0.814532], "pu" -> 
           RGBColor[0.494945, 0.506679, 0.774361], "am" -> 
           RGBColor[0.52326, 0.469458, 0.735517], "cm" -> 
           RGBColor[0.549486, 0.433847, 0.697999], "bk" -> 
           RGBColor[0.573624, 0.399845, 0.661808], "cf" -> 
           RGBColor[0.595673, 0.367454, 0.626942], "es" -> 
           RGBColor[0.615633, 0.336672, 0.593404], "fm" -> 
           RGBColor[0.633505, 0.307499, 0.561191], "md" -> 
           RGBColor[0.649288, 0.279937, 0.530305], "no" -> 
           RGBColor[0.662982, 0.253984, 0.500746], "lr" -> 
           RGBColor[0.674588, 0.22964, 0.472513], "rf" -> 
           RGBColor[0.684106, 0.206907, 0.445606], "db" -> 
           RGBColor[0.691534, 0.185783, 0.420025], "sg" -> 
           RGBColor[0.696874, 0.166269, 0.395772], "bh" -> 
           RGBColor[0.700126, 0.148365, 0.372844], "hs" -> 
           RGBColor[0.701289, 0.13207, 0.351243], "mt" -> 
           RGBColor[0.700363, 0.117385, 0.330968], "ds" -> 
           RGBColor[0.697348, 0.10431, 0.31202], "rg" -> 
           RGBColor[0.692245, 0.0928444, 0.294398], "cn" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "nh" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "fl" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "mc" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "lv" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "ts" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "og" -> 
           RGBColor[0.635401, 0.0528, 0.226184], "uub" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "uut" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "uuq" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "uup" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "uuh" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "uus" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "uuo" -> 
           RGBColor[0.635401, 0.0528, 0.226184]}]]& ][0.85], 
       ColorDataFunction[
       "Atoms", 
        "Named", {{
         "H", "He", "Li", "Be", "B", "C", "N", "O", "F", "Ne", "Na", "Mg", 
          "Al", "Si", "P", "S", "Cl", "Ar", "K", "Ca", "Sc", "Ti", "V", "Cr", 
          "Mn", "Fe", "Co", "Ni", "Cu", "Zn", "Ga", "Ge", "As", "Se", "Br", 
          "Kr", "Rb", "Sr", "Y", "Zr", "Nb", "Mo", "Tc", "Ru", "Rh", "Pd", 
          "Ag", "Cd", "In", "Sn", "Sb", "Te", "I", "Xe", "Cs", "Ba", "La", 
          "Ce", "Pr", "Nd", "Pm", "Sm", "Eu", "Gd", "Tb", "Dy", "Ho", "Er", 
          "Tm", "Yb", "Lu", "Hf", "Ta", "W", "Re", "Os", "Ir", "Pt", "Au", 
          "Hg", "Tl", "Pb", "Bi", "Po", "At", "Rn", "Fr", "Ra", "Ac", "Th", 
          "Pa", "U", "Np", "Pu", "Am", "Cm", "Bk", "Cf", "Es", "Fm", "Md", 
          "No", "Lr", "Rf", "Db", "Sg", "Bh", "Hs", "Mt", "Ds", "Rg", "Cn", 
          "Nh", "Fl", "Mc", "Lv", "Ts", "Og", "Uub", "Uut", "Uuq", "Uup", 
          "Uuh", "Uus", "Uuo"}, {
         "h", "he", "li", "be", "b", "c", "n", "o", "f", "ne", "na", "mg", 
          "al", "si", "p", "s", "cl", "ar", "k", "ca", "sc", "ti", "v", "cr", 
          "mn", "fe", "co", "ni", "cu", "zn", "ga", "ge", "as", "se", "br", 
          "kr", "rb", "sr", "y", "zr", "nb", "mo", "tc", "ru", "rh", "pd", 
          "ag", "cd", "in", "sn", "sb", "te", "i", "xe", "cs", "ba", "la", 
          "ce", "pr", "nd", "pm", "sm", "eu", "gd", "tb", "dy", "ho", "er", 
          "tm", "yb", "lu", "hf", "ta", "w", "re", "os", "ir", "pt", "au", 
          "hg", "tl", "pb", "bi", "po", "at", "rn", "fr", "ra", "ac", "th", 
          "pa", "u", "np", "pu", "am", "cm", "bk", "cf", "es", "fm", "md", 
          "no", "lr", "rf", "db", "sg", "bh", "hs", "mt", "ds", "rg", "cn", 
          "nh", "fl", "mc", "lv", "ts", "og", "uub", "uut", "uuq", "uup", 
          "uuh", "uus", "uuo"}}, Replace[#, 
         Dispatch[{
          "h" -> RGBColor[0.65, 0.7, 0.7], "he" -> RGBColor[0.836713, 1., 1.],
            "li" -> RGBColor[0.799435, 0.543572, 0.997559], "be" -> 
           RGBColor[0.770565, 0.964309, 0.0442359], "b" -> 
           RGBColor[1., 0.709804, 0.709804], "c" -> RGBColor[0.4, 0.4, 0.4], 
           "n" -> RGBColor[0.291989, 0.437977, 0.888609], "o" -> 
           RGBColor[0.800498, 0.201504, 0.192061], "f" -> 
           RGBColor[0.578462, 0.85539, 0.408855], "ne" -> 
           RGBColor[0.677263, 0.928423, 0.955287], "na" -> 
           RGBColor[0.658708, 0.492173, 0.842842], "mg" -> 
           RGBColor[0.628274, 0.850553, 0.0782731], "al" -> 
           RGBColor[0.8913, 0.631904, 0.627399], "si" -> 
           RGBColor[0.941176, 0.784314, 0.627451], "p" -> 
           RGBColor[1., 0.501961, 0], "s" -> 
           RGBColor[0.90443, 0.97015, 0.13504], "cl" -> 
           RGBColor[0.412698, 0.932689, 0.166398], "ar" -> 
           RGBColor[0.546138, 0.844244, 0.892092], "k" -> 
           RGBColor[0.534026, 0.420729, 0.705621], "ca" -> 
           RGBColor[0.480072, 0.744591, 0.0955222], "sc" -> 
           RGBColor[0.901961, 0.901961, 0.901961], "ti" -> 
           RGBColor[0.74902, 0.760784, 0.780392], "v" -> 
           RGBColor[0.65098, 0.65098, 0.670588], "cr" -> 
           RGBColor[0.541176, 0.6, 0.780392], "mn" -> 
           RGBColor[0.611765, 0.478431, 0.780392], "fe" -> 
           RGBColor[0.878431, 0.4, 0.2], "co" -> 
           RGBColor[0.941176, 0.564706, 0.627451], "ni" -> 
           RGBColor[0.313725, 0.815686, 0.313725], "cu" -> 
           RGBColor[0.784314, 0.501961, 0.2], "zn" -> 
           RGBColor[0.490196, 0.501961, 0.690196], "ga" -> 
           RGBColor[0.800757, 0.542666, 0.533513], "ge" -> 
           RGBColor[0.60508, 0.632465, 0.576489], "as" -> 
           RGBColor[0.741176, 0.501961, 0.890196], "se" -> 
           RGBColor[0.917248, 0.657833, 0.0706628], "br" -> 
           RGBColor[0.58847, 0.22163, 0.16064], "kr" -> 
           RGBColor[0.426019, 0.747462, 0.810413], "rb" -> 
           RGBColor[0.425391, 0.329242, 0.585895], "sr" -> 
           RGBColor[0.325959, 0.646423, 0.095983], "y" -> 
           RGBColor[0.531014, 1., 1.], "zr" -> 
           RGBColor[0.458599, 0.917466, 0.918573], "nb" -> 
           RGBColor[0.385036, 0.834854, 0.841681], "mo" -> 
           RGBColor[0.310325, 0.752163, 0.769323], "tc" -> 
           RGBColor[0.234466, 0.669394, 0.701499], "ru" -> 
           RGBColor[0.157459, 0.586546, 0.638209], "rh" -> 
           RGBColor[0.0793033, 0.50362, 0.579453], "pd" -> 
           RGBColor[0., 0.420615, 0.525231], "ag" -> 
           RGBColor[0.752941, 0.752941, 0.752941], "cd" -> 
           RGBColor[1., 0.85098, 0.560784], "in" -> 
           RGBColor[0.728371, 0.440594, 0.422196], "sn" -> 
           RGBColor[0.39799, 0.491477, 0.495586], "sb" -> 
           RGBColor[0.619608, 0.388235, 0.709804], "te" -> 
           RGBColor[0.816706, 0.451332, 0.0100947], "i" -> 
           RGBColor[0.580392, 0, 0.580392], "xe" -> 
           RGBColor[0.316906, 0.638078, 0.710252], "cs" -> 
           RGBColor[0.332803, 0.217712, 0.483666], "ba" -> 
           RGBColor[0.165935, 0.55605, 0.0796556], "la" -> 
           RGBColor[0.928084, 0.716075, 0.329427], "ce" -> 
           RGBColor[0.894824, 0.731424, 0.325131], "pr" -> 
           RGBColor[0.86523, 0.707999, 0.315261], "nd" -> 
           RGBColor[0.837836, 0.662974, 0.301635], "pm" -> 
           RGBColor[0.811992, 0.607859, 0.285626], "sm" -> 
           RGBColor[0.787563, 0.549894, 0.268279], "eu" -> 
           RGBColor[0.764628, 0.493261, 0.250405], "gd" -> 
           RGBColor[0.743177, 0.440115, 0.23269], "tb" -> 
           RGBColor[0.72281, 0.39143, 0.215783], "dy" -> 
           RGBColor[0.702434, 0.347663, 0.200392], "ho" -> 
           RGBColor[0.679962, 0.309234, 0.187368], "er" -> 
           RGBColor[0.652012, 0.276823, 0.17779], "tm" -> 
           RGBColor[0.613603, 0.251489, 0.173042], "yb" -> 
           RGBColor[0.557855, 0.234598, 0.17489], "lu" -> 
           RGBColor[0.475685, 0.227573, 0.18555], "hf" -> 
           RGBColor[0.781537, 0.717388, 0.716579], "ta" -> 
           RGBColor[0.734443, 0.544489, 0.683471], "w" -> 
           RGBColor[0.681179, 0.360409, 0.63675], "re" -> 
           RGBColor[0.605181, 0.367584, 0.556343], "os" -> 
           RGBColor[0.521806, 0.382125, 0.469204], "ir" -> 
           RGBColor[0.445624, 0.373159, 0.399069], "pt" -> 
           RGBColor[0.815686, 0.815686, 0.878431], "au" -> 
           RGBColor[1., 0.819608, 0.137255], "hg" -> 
           RGBColor[0.721569, 0.721569, 0.815686], "tl" -> 
           RGBColor[0.65098, 0.329412, 0.301961], "pb" -> 
           RGBColor[0.341176, 0.34902, 0.380392], "bi" -> 
           RGBColor[0.619608, 0.309804, 0.709804], "po" -> 
           RGBColor[0.670588, 0.360784, 0], "at" -> 
           RGBColor[0.458824, 0.309804, 0.270588], "rn" -> 
           RGBColor[0.218799, 0.516091, 0.591608], "fr" -> 
           RGBColor[0.25626, 0.0861372, 0.398932], "ra" -> 
           RGBColor[0., 0.473472, 0.04654], "ac" -> 
           RGBColor[0.322042, 0.71693, 0.988479], "th" -> 
           RGBColor[0.3608, 0.67166, 0.943003], "pa" -> 
           RGBColor[0.397469, 0.628, 0.898853], "u" -> 
           RGBColor[0.43205, 0.58595, 0.856029], "np" -> 
           RGBColor[0.464542, 0.54551, 0.814532], "pu" -> 
           RGBColor[0.494945, 0.506679, 0.774361], "am" -> 
           RGBColor[0.52326, 0.469458, 0.735517], "cm" -> 
           RGBColor[0.549486, 0.433847, 0.697999], "bk" -> 
           RGBColor[0.573624, 0.399845, 0.661808], "cf" -> 
           RGBColor[0.595673, 0.367454, 0.626942], "es" -> 
           RGBColor[0.615633, 0.336672, 0.593404], "fm" -> 
           RGBColor[0.633505, 0.307499, 0.561191], "md" -> 
           RGBColor[0.649288, 0.279937, 0.530305], "no" -> 
           RGBColor[0.662982, 0.253984, 0.500746], "lr" -> 
           RGBColor[0.674588, 0.22964, 0.472513], "rf" -> 
           RGBColor[0.684106, 0.206907, 0.445606], "db" -> 
           RGBColor[0.691534, 0.185783, 0.420025], "sg" -> 
           RGBColor[0.696874, 0.166269, 0.395772], "bh" -> 
           RGBColor[0.700126, 0.148365, 0.372844], "hs" -> 
           RGBColor[0.701289, 0.13207, 0.351243], "mt" -> 
           RGBColor[0.700363, 0.117385, 0.330968], "ds" -> 
           RGBColor[0.697348, 0.10431, 0.31202], "rg" -> 
           RGBColor[0.692245, 0.0928444, 0.294398], "cn" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "nh" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "fl" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "mc" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "lv" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "ts" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "og" -> 
           RGBColor[0.635401, 0.0528, 0.226184], "uub" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "uut" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "uuq" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "uup" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "uuh" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "uus" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "uuo" -> 
           RGBColor[0.635401, 0.0528, 0.226184]}]]& ][0.85], 
       ColorDataFunction[
       "Atoms", 
        "Named", {{
         "H", "He", "Li", "Be", "B", "C", "N", "O", "F", "Ne", "Na", "Mg", 
          "Al", "Si", "P", "S", "Cl", "Ar", "K", "Ca", "Sc", "Ti", "V", "Cr", 
          "Mn", "Fe", "Co", "Ni", "Cu", "Zn", "Ga", "Ge", "As", "Se", "Br", 
          "Kr", "Rb", "Sr", "Y", "Zr", "Nb", "Mo", "Tc", "Ru", "Rh", "Pd", 
          "Ag", "Cd", "In", "Sn", "Sb", "Te", "I", "Xe", "Cs", "Ba", "La", 
          "Ce", "Pr", "Nd", "Pm", "Sm", "Eu", "Gd", "Tb", "Dy", "Ho", "Er", 
          "Tm", "Yb", "Lu", "Hf", "Ta", "W", "Re", "Os", "Ir", "Pt", "Au", 
          "Hg", "Tl", "Pb", "Bi", "Po", "At", "Rn", "Fr", "Ra", "Ac", "Th", 
          "Pa", "U", "Np", "Pu", "Am", "Cm", "Bk", "Cf", "Es", "Fm", "Md", 
          "No", "Lr", "Rf", "Db", "Sg", "Bh", "Hs", "Mt", "Ds", "Rg", "Cn", 
          "Nh", "Fl", "Mc", "Lv", "Ts", "Og", "Uub", "Uut", "Uuq", "Uup", 
          "Uuh", "Uus", "Uuo"}, {
         "h", "he", "li", "be", "b", "c", "n", "o", "f", "ne", "na", "mg", 
          "al", "si", "p", "s", "cl", "ar", "k", "ca", "sc", "ti", "v", "cr", 
          "mn", "fe", "co", "ni", "cu", "zn", "ga", "ge", "as", "se", "br", 
          "kr", "rb", "sr", "y", "zr", "nb", "mo", "tc", "ru", "rh", "pd", 
          "ag", "cd", "in", "sn", "sb", "te", "i", "xe", "cs", "ba", "la", 
          "ce", "pr", "nd", "pm", "sm", "eu", "gd", "tb", "dy", "ho", "er", 
          "tm", "yb", "lu", "hf", "ta", "w", "re", "os", "ir", "pt", "au", 
          "hg", "tl", "pb", "bi", "po", "at", "rn", "fr", "ra", "ac", "th", 
          "pa", "u", "np", "pu", "am", "cm", "bk", "cf", "es", "fm", "md", 
          "no", "lr", "rf", "db", "sg", "bh", "hs", "mt", "ds", "rg", "cn", 
          "nh", "fl", "mc", "lv", "ts", "og", "uub", "uut", "uuq", "uup", 
          "uuh", "uus", "uuo"}}, Replace[#, 
         Dispatch[{
          "h" -> RGBColor[0.65, 0.7, 0.7], "he" -> RGBColor[0.836713, 1., 1.],
            "li" -> RGBColor[0.799435, 0.543572, 0.997559], "be" -> 
           RGBColor[0.770565, 0.964309, 0.0442359], "b" -> 
           RGBColor[1., 0.709804, 0.709804], "c" -> RGBColor[0.4, 0.4, 0.4], 
           "n" -> RGBColor[0.291989, 0.437977, 0.888609], "o" -> 
           RGBColor[0.800498, 0.201504, 0.192061], "f" -> 
           RGBColor[0.578462, 0.85539, 0.408855], "ne" -> 
           RGBColor[0.677263, 0.928423, 0.955287], "na" -> 
           RGBColor[0.658708, 0.492173, 0.842842], "mg" -> 
           RGBColor[0.628274, 0.850553, 0.0782731], "al" -> 
           RGBColor[0.8913, 0.631904, 0.627399], "si" -> 
           RGBColor[0.941176, 0.784314, 0.627451], "p" -> 
           RGBColor[1., 0.501961, 0], "s" -> 
           RGBColor[0.90443, 0.97015, 0.13504], "cl" -> 
           RGBColor[0.412698, 0.932689, 0.166398], "ar" -> 
           RGBColor[0.546138, 0.844244, 0.892092], "k" -> 
           RGBColor[0.534026, 0.420729, 0.705621], "ca" -> 
           RGBColor[0.480072, 0.744591, 0.0955222], "sc" -> 
           RGBColor[0.901961, 0.901961, 0.901961], "ti" -> 
           RGBColor[0.74902, 0.760784, 0.780392], "v" -> 
           RGBColor[0.65098, 0.65098, 0.670588], "cr" -> 
           RGBColor[0.541176, 0.6, 0.780392], "mn" -> 
           RGBColor[0.611765, 0.478431, 0.780392], "fe" -> 
           RGBColor[0.878431, 0.4, 0.2], "co" -> 
           RGBColor[0.941176, 0.564706, 0.627451], "ni" -> 
           RGBColor[0.313725, 0.815686, 0.313725], "cu" -> 
           RGBColor[0.784314, 0.501961, 0.2], "zn" -> 
           RGBColor[0.490196, 0.501961, 0.690196], "ga" -> 
           RGBColor[0.800757, 0.542666, 0.533513], "ge" -> 
           RGBColor[0.60508, 0.632465, 0.576489], "as" -> 
           RGBColor[0.741176, 0.501961, 0.890196], "se" -> 
           RGBColor[0.917248, 0.657833, 0.0706628], "br" -> 
           RGBColor[0.58847, 0.22163, 0.16064], "kr" -> 
           RGBColor[0.426019, 0.747462, 0.810413], "rb" -> 
           RGBColor[0.425391, 0.329242, 0.585895], "sr" -> 
           RGBColor[0.325959, 0.646423, 0.095983], "y" -> 
           RGBColor[0.531014, 1., 1.], "zr" -> 
           RGBColor[0.458599, 0.917466, 0.918573], "nb" -> 
           RGBColor[0.385036, 0.834854, 0.841681], "mo" -> 
           RGBColor[0.310325, 0.752163, 0.769323], "tc" -> 
           RGBColor[0.234466, 0.669394, 0.701499], "ru" -> 
           RGBColor[0.157459, 0.586546, 0.638209], "rh" -> 
           RGBColor[0.0793033, 0.50362, 0.579453], "pd" -> 
           RGBColor[0., 0.420615, 0.525231], "ag" -> 
           RGBColor[0.752941, 0.752941, 0.752941], "cd" -> 
           RGBColor[1., 0.85098, 0.560784], "in" -> 
           RGBColor[0.728371, 0.440594, 0.422196], "sn" -> 
           RGBColor[0.39799, 0.491477, 0.495586], "sb" -> 
           RGBColor[0.619608, 0.388235, 0.709804], "te" -> 
           RGBColor[0.816706, 0.451332, 0.0100947], "i" -> 
           RGBColor[0.580392, 0, 0.580392], "xe" -> 
           RGBColor[0.316906, 0.638078, 0.710252], "cs" -> 
           RGBColor[0.332803, 0.217712, 0.483666], "ba" -> 
           RGBColor[0.165935, 0.55605, 0.0796556], "la" -> 
           RGBColor[0.928084, 0.716075, 0.329427], "ce" -> 
           RGBColor[0.894824, 0.731424, 0.325131], "pr" -> 
           RGBColor[0.86523, 0.707999, 0.315261], "nd" -> 
           RGBColor[0.837836, 0.662974, 0.301635], "pm" -> 
           RGBColor[0.811992, 0.607859, 0.285626], "sm" -> 
           RGBColor[0.787563, 0.549894, 0.268279], "eu" -> 
           RGBColor[0.764628, 0.493261, 0.250405], "gd" -> 
           RGBColor[0.743177, 0.440115, 0.23269], "tb" -> 
           RGBColor[0.72281, 0.39143, 0.215783], "dy" -> 
           RGBColor[0.702434, 0.347663, 0.200392], "ho" -> 
           RGBColor[0.679962, 0.309234, 0.187368], "er" -> 
           RGBColor[0.652012, 0.276823, 0.17779], "tm" -> 
           RGBColor[0.613603, 0.251489, 0.173042], "yb" -> 
           RGBColor[0.557855, 0.234598, 0.17489], "lu" -> 
           RGBColor[0.475685, 0.227573, 0.18555], "hf" -> 
           RGBColor[0.781537, 0.717388, 0.716579], "ta" -> 
           RGBColor[0.734443, 0.544489, 0.683471], "w" -> 
           RGBColor[0.681179, 0.360409, 0.63675], "re" -> 
           RGBColor[0.605181, 0.367584, 0.556343], "os" -> 
           RGBColor[0.521806, 0.382125, 0.469204], "ir" -> 
           RGBColor[0.445624, 0.373159, 0.399069], "pt" -> 
           RGBColor[0.815686, 0.815686, 0.878431], "au" -> 
           RGBColor[1., 0.819608, 0.137255], "hg" -> 
           RGBColor[0.721569, 0.721569, 0.815686], "tl" -> 
           RGBColor[0.65098, 0.329412, 0.301961], "pb" -> 
           RGBColor[0.341176, 0.34902, 0.380392], "bi" -> 
           RGBColor[0.619608, 0.309804, 0.709804], "po" -> 
           RGBColor[0.670588, 0.360784, 0], "at" -> 
           RGBColor[0.458824, 0.309804, 0.270588], "rn" -> 
           RGBColor[0.218799, 0.516091, 0.591608], "fr" -> 
           RGBColor[0.25626, 0.0861372, 0.398932], "ra" -> 
           RGBColor[0., 0.473472, 0.04654], "ac" -> 
           RGBColor[0.322042, 0.71693, 0.988479], "th" -> 
           RGBColor[0.3608, 0.67166, 0.943003], "pa" -> 
           RGBColor[0.397469, 0.628, 0.898853], "u" -> 
           RGBColor[0.43205, 0.58595, 0.856029], "np" -> 
           RGBColor[0.464542, 0.54551, 0.814532], "pu" -> 
           RGBColor[0.494945, 0.506679, 0.774361], "am" -> 
           RGBColor[0.52326, 0.469458, 0.735517], "cm" -> 
           RGBColor[0.549486, 0.433847, 0.697999], "bk" -> 
           RGBColor[0.573624, 0.399845, 0.661808], "cf" -> 
           RGBColor[0.595673, 0.367454, 0.626942], "es" -> 
           RGBColor[0.615633, 0.336672, 0.593404], "fm" -> 
           RGBColor[0.633505, 0.307499, 0.561191], "md" -> 
           RGBColor[0.649288, 0.279937, 0.530305], "no" -> 
           RGBColor[0.662982, 0.253984, 0.500746], "lr" -> 
           RGBColor[0.674588, 0.22964, 0.472513], "rf" -> 
           RGBColor[0.684106, 0.206907, 0.445606], "db" -> 
           RGBColor[0.691534, 0.185783, 0.420025], "sg" -> 
           RGBColor[0.696874, 0.166269, 0.395772], "bh" -> 
           RGBColor[0.700126, 0.148365, 0.372844], "hs" -> 
           RGBColor[0.701289, 0.13207, 0.351243], "mt" -> 
           RGBColor[0.700363, 0.117385, 0.330968], "ds" -> 
           RGBColor[0.697348, 0.10431, 0.31202], "rg" -> 
           RGBColor[0.692245, 0.0928444, 0.294398], "cn" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "nh" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "fl" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "mc" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "lv" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "ts" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "og" -> 
           RGBColor[0.635401, 0.0528, 0.226184], "uub" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "uut" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "uuq" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "uup" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "uuh" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "uus" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "uuo" -> 
           RGBColor[0.635401, 0.0528, 0.226184]}]]& ][0.85], 
       ColorDataFunction[
       "Atoms", 
        "Named", {{
         "H", "He", "Li", "Be", "B", "C", "N", "O", "F", "Ne", "Na", "Mg", 
          "Al", "Si", "P", "S", "Cl", "Ar", "K", "Ca", "Sc", "Ti", "V", "Cr", 
          "Mn", "Fe", "Co", "Ni", "Cu", "Zn", "Ga", "Ge", "As", "Se", "Br", 
          "Kr", "Rb", "Sr", "Y", "Zr", "Nb", "Mo", "Tc", "Ru", "Rh", "Pd", 
          "Ag", "Cd", "In", "Sn", "Sb", "Te", "I", "Xe", "Cs", "Ba", "La", 
          "Ce", "Pr", "Nd", "Pm", "Sm", "Eu", "Gd", "Tb", "Dy", "Ho", "Er", 
          "Tm", "Yb", "Lu", "Hf", "Ta", "W", "Re", "Os", "Ir", "Pt", "Au", 
          "Hg", "Tl", "Pb", "Bi", "Po", "At", "Rn", "Fr", "Ra", "Ac", "Th", 
          "Pa", "U", "Np", "Pu", "Am", "Cm", "Bk", "Cf", "Es", "Fm", "Md", 
          "No", "Lr", "Rf", "Db", "Sg", "Bh", "Hs", "Mt", "Ds", "Rg", "Cn", 
          "Nh", "Fl", "Mc", "Lv", "Ts", "Og", "Uub", "Uut", "Uuq", "Uup", 
          "Uuh", "Uus", "Uuo"}, {
         "h", "he", "li", "be", "b", "c", "n", "o", "f", "ne", "na", "mg", 
          "al", "si", "p", "s", "cl", "ar", "k", "ca", "sc", "ti", "v", "cr", 
          "mn", "fe", "co", "ni", "cu", "zn", "ga", "ge", "as", "se", "br", 
          "kr", "rb", "sr", "y", "zr", "nb", "mo", "tc", "ru", "rh", "pd", 
          "ag", "cd", "in", "sn", "sb", "te", "i", "xe", "cs", "ba", "la", 
          "ce", "pr", "nd", "pm", "sm", "eu", "gd", "tb", "dy", "ho", "er", 
          "tm", "yb", "lu", "hf", "ta", "w", "re", "os", "ir", "pt", "au", 
          "hg", "tl", "pb", "bi", "po", "at", "rn", "fr", "ra", "ac", "th", 
          "pa", "u", "np", "pu", "am", "cm", "bk", "cf", "es", "fm", "md", 
          "no", "lr", "rf", "db", "sg", "bh", "hs", "mt", "ds", "rg", "cn", 
          "nh", "fl", "mc", "lv", "ts", "og", "uub", "uut", "uuq", "uup", 
          "uuh", "uus", "uuo"}}, Replace[#, 
         Dispatch[{
          "h" -> RGBColor[0.65, 0.7, 0.7], "he" -> RGBColor[0.836713, 1., 1.],
            "li" -> RGBColor[0.799435, 0.543572, 0.997559], "be" -> 
           RGBColor[0.770565, 0.964309, 0.0442359], "b" -> 
           RGBColor[1., 0.709804, 0.709804], "c" -> RGBColor[0.4, 0.4, 0.4], 
           "n" -> RGBColor[0.291989, 0.437977, 0.888609], "o" -> 
           RGBColor[0.800498, 0.201504, 0.192061], "f" -> 
           RGBColor[0.578462, 0.85539, 0.408855], "ne" -> 
           RGBColor[0.677263, 0.928423, 0.955287], "na" -> 
           RGBColor[0.658708, 0.492173, 0.842842], "mg" -> 
           RGBColor[0.628274, 0.850553, 0.0782731], "al" -> 
           RGBColor[0.8913, 0.631904, 0.627399], "si" -> 
           RGBColor[0.941176, 0.784314, 0.627451], "p" -> 
           RGBColor[1., 0.501961, 0], "s" -> 
           RGBColor[0.90443, 0.97015, 0.13504], "cl" -> 
           RGBColor[0.412698, 0.932689, 0.166398], "ar" -> 
           RGBColor[0.546138, 0.844244, 0.892092], "k" -> 
           RGBColor[0.534026, 0.420729, 0.705621], "ca" -> 
           RGBColor[0.480072, 0.744591, 0.0955222], "sc" -> 
           RGBColor[0.901961, 0.901961, 0.901961], "ti" -> 
           RGBColor[0.74902, 0.760784, 0.780392], "v" -> 
           RGBColor[0.65098, 0.65098, 0.670588], "cr" -> 
           RGBColor[0.541176, 0.6, 0.780392], "mn" -> 
           RGBColor[0.611765, 0.478431, 0.780392], "fe" -> 
           RGBColor[0.878431, 0.4, 0.2], "co" -> 
           RGBColor[0.941176, 0.564706, 0.627451], "ni" -> 
           RGBColor[0.313725, 0.815686, 0.313725], "cu" -> 
           RGBColor[0.784314, 0.501961, 0.2], "zn" -> 
           RGBColor[0.490196, 0.501961, 0.690196], "ga" -> 
           RGBColor[0.800757, 0.542666, 0.533513], "ge" -> 
           RGBColor[0.60508, 0.632465, 0.576489], "as" -> 
           RGBColor[0.741176, 0.501961, 0.890196], "se" -> 
           RGBColor[0.917248, 0.657833, 0.0706628], "br" -> 
           RGBColor[0.58847, 0.22163, 0.16064], "kr" -> 
           RGBColor[0.426019, 0.747462, 0.810413], "rb" -> 
           RGBColor[0.425391, 0.329242, 0.585895], "sr" -> 
           RGBColor[0.325959, 0.646423, 0.095983], "y" -> 
           RGBColor[0.531014, 1., 1.], "zr" -> 
           RGBColor[0.458599, 0.917466, 0.918573], "nb" -> 
           RGBColor[0.385036, 0.834854, 0.841681], "mo" -> 
           RGBColor[0.310325, 0.752163, 0.769323], "tc" -> 
           RGBColor[0.234466, 0.669394, 0.701499], "ru" -> 
           RGBColor[0.157459, 0.586546, 0.638209], "rh" -> 
           RGBColor[0.0793033, 0.50362, 0.579453], "pd" -> 
           RGBColor[0., 0.420615, 0.525231], "ag" -> 
           RGBColor[0.752941, 0.752941, 0.752941], "cd" -> 
           RGBColor[1., 0.85098, 0.560784], "in" -> 
           RGBColor[0.728371, 0.440594, 0.422196], "sn" -> 
           RGBColor[0.39799, 0.491477, 0.495586], "sb" -> 
           RGBColor[0.619608, 0.388235, 0.709804], "te" -> 
           RGBColor[0.816706, 0.451332, 0.0100947], "i" -> 
           RGBColor[0.580392, 0, 0.580392], "xe" -> 
           RGBColor[0.316906, 0.638078, 0.710252], "cs" -> 
           RGBColor[0.332803, 0.217712, 0.483666], "ba" -> 
           RGBColor[0.165935, 0.55605, 0.0796556], "la" -> 
           RGBColor[0.928084, 0.716075, 0.329427], "ce" -> 
           RGBColor[0.894824, 0.731424, 0.325131], "pr" -> 
           RGBColor[0.86523, 0.707999, 0.315261], "nd" -> 
           RGBColor[0.837836, 0.662974, 0.301635], "pm" -> 
           RGBColor[0.811992, 0.607859, 0.285626], "sm" -> 
           RGBColor[0.787563, 0.549894, 0.268279], "eu" -> 
           RGBColor[0.764628, 0.493261, 0.250405], "gd" -> 
           RGBColor[0.743177, 0.440115, 0.23269], "tb" -> 
           RGBColor[0.72281, 0.39143, 0.215783], "dy" -> 
           RGBColor[0.702434, 0.347663, 0.200392], "ho" -> 
           RGBColor[0.679962, 0.309234, 0.187368], "er" -> 
           RGBColor[0.652012, 0.276823, 0.17779], "tm" -> 
           RGBColor[0.613603, 0.251489, 0.173042], "yb" -> 
           RGBColor[0.557855, 0.234598, 0.17489], "lu" -> 
           RGBColor[0.475685, 0.227573, 0.18555], "hf" -> 
           RGBColor[0.781537, 0.717388, 0.716579], "ta" -> 
           RGBColor[0.734443, 0.544489, 0.683471], "w" -> 
           RGBColor[0.681179, 0.360409, 0.63675], "re" -> 
           RGBColor[0.605181, 0.367584, 0.556343], "os" -> 
           RGBColor[0.521806, 0.382125, 0.469204], "ir" -> 
           RGBColor[0.445624, 0.373159, 0.399069], "pt" -> 
           RGBColor[0.815686, 0.815686, 0.878431], "au" -> 
           RGBColor[1., 0.819608, 0.137255], "hg" -> 
           RGBColor[0.721569, 0.721569, 0.815686], "tl" -> 
           RGBColor[0.65098, 0.329412, 0.301961], "pb" -> 
           RGBColor[0.341176, 0.34902, 0.380392], "bi" -> 
           RGBColor[0.619608, 0.309804, 0.709804], "po" -> 
           RGBColor[0.670588, 0.360784, 0], "at" -> 
           RGBColor[0.458824, 0.309804, 0.270588], "rn" -> 
           RGBColor[0.218799, 0.516091, 0.591608], "fr" -> 
           RGBColor[0.25626, 0.0861372, 0.398932], "ra" -> 
           RGBColor[0., 0.473472, 0.04654], "ac" -> 
           RGBColor[0.322042, 0.71693, 0.988479], "th" -> 
           RGBColor[0.3608, 0.67166, 0.943003], "pa" -> 
           RGBColor[0.397469, 0.628, 0.898853], "u" -> 
           RGBColor[0.43205, 0.58595, 0.856029], "np" -> 
           RGBColor[0.464542, 0.54551, 0.814532], "pu" -> 
           RGBColor[0.494945, 0.506679, 0.774361], "am" -> 
           RGBColor[0.52326, 0.469458, 0.735517], "cm" -> 
           RGBColor[0.549486, 0.433847, 0.697999], "bk" -> 
           RGBColor[0.573624, 0.399845, 0.661808], "cf" -> 
           RGBColor[0.595673, 0.367454, 0.626942], "es" -> 
           RGBColor[0.615633, 0.336672, 0.593404], "fm" -> 
           RGBColor[0.633505, 0.307499, 0.561191], "md" -> 
           RGBColor[0.649288, 0.279937, 0.530305], "no" -> 
           RGBColor[0.662982, 0.253984, 0.500746], "lr" -> 
           RGBColor[0.674588, 0.22964, 0.472513], "rf" -> 
           RGBColor[0.684106, 0.206907, 0.445606], "db" -> 
           RGBColor[0.691534, 0.185783, 0.420025], "sg" -> 
           RGBColor[0.696874, 0.166269, 0.395772], "bh" -> 
           RGBColor[0.700126, 0.148365, 0.372844], "hs" -> 
           RGBColor[0.701289, 0.13207, 0.351243], "mt" -> 
           RGBColor[0.700363, 0.117385, 0.330968], "ds" -> 
           RGBColor[0.697348, 0.10431, 0.31202], "rg" -> 
           RGBColor[0.692245, 0.0928444, 0.294398], "cn" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "nh" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "fl" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "mc" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "lv" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "ts" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "og" -> 
           RGBColor[0.635401, 0.0528, 0.226184], "uub" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "uut" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "uuq" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "uup" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "uuh" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "uus" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "uuo" -> 
           RGBColor[0.635401, 0.0528, 0.226184]}]]& ][0.85], 
       ColorDataFunction[
       "Atoms", 
        "Named", {{
         "H", "He", "Li", "Be", "B", "C", "N", "O", "F", "Ne", "Na", "Mg", 
          "Al", "Si", "P", "S", "Cl", "Ar", "K", "Ca", "Sc", "Ti", "V", "Cr", 
          "Mn", "Fe", "Co", "Ni", "Cu", "Zn", "Ga", "Ge", "As", "Se", "Br", 
          "Kr", "Rb", "Sr", "Y", "Zr", "Nb", "Mo", "Tc", "Ru", "Rh", "Pd", 
          "Ag", "Cd", "In", "Sn", "Sb", "Te", "I", "Xe", "Cs", "Ba", "La", 
          "Ce", "Pr", "Nd", "Pm", "Sm", "Eu", "Gd", "Tb", "Dy", "Ho", "Er", 
          "Tm", "Yb", "Lu", "Hf", "Ta", "W", "Re", "Os", "Ir", "Pt", "Au", 
          "Hg", "Tl", "Pb", "Bi", "Po", "At", "Rn", "Fr", "Ra", "Ac", "Th", 
          "Pa", "U", "Np", "Pu", "Am", "Cm", "Bk", "Cf", "Es", "Fm", "Md", 
          "No", "Lr", "Rf", "Db", "Sg", "Bh", "Hs", "Mt", "Ds", "Rg", "Cn", 
          "Nh", "Fl", "Mc", "Lv", "Ts", "Og", "Uub", "Uut", "Uuq", "Uup", 
          "Uuh", "Uus", "Uuo"}, {
         "h", "he", "li", "be", "b", "c", "n", "o", "f", "ne", "na", "mg", 
          "al", "si", "p", "s", "cl", "ar", "k", "ca", "sc", "ti", "v", "cr", 
          "mn", "fe", "co", "ni", "cu", "zn", "ga", "ge", "as", "se", "br", 
          "kr", "rb", "sr", "y", "zr", "nb", "mo", "tc", "ru", "rh", "pd", 
          "ag", "cd", "in", "sn", "sb", "te", "i", "xe", "cs", "ba", "la", 
          "ce", "pr", "nd", "pm", "sm", "eu", "gd", "tb", "dy", "ho", "er", 
          "tm", "yb", "lu", "hf", "ta", "w", "re", "os", "ir", "pt", "au", 
          "hg", "tl", "pb", "bi", "po", "at", "rn", "fr", "ra", "ac", "th", 
          "pa", "u", "np", "pu", "am", "cm", "bk", "cf", "es", "fm", "md", 
          "no", "lr", "rf", "db", "sg", "bh", "hs", "mt", "ds", "rg", "cn", 
          "nh", "fl", "mc", "lv", "ts", "og", "uub", "uut", "uuq", "uup", 
          "uuh", "uus", "uuo"}}, Replace[#, 
         Dispatch[{
          "h" -> RGBColor[0.65, 0.7, 0.7], "he" -> RGBColor[0.836713, 1., 1.],
            "li" -> RGBColor[0.799435, 0.543572, 0.997559], "be" -> 
           RGBColor[0.770565, 0.964309, 0.0442359], "b" -> 
           RGBColor[1., 0.709804, 0.709804], "c" -> RGBColor[0.4, 0.4, 0.4], 
           "n" -> RGBColor[0.291989, 0.437977, 0.888609], "o" -> 
           RGBColor[0.800498, 0.201504, 0.192061], "f" -> 
           RGBColor[0.578462, 0.85539, 0.408855], "ne" -> 
           RGBColor[0.677263, 0.928423, 0.955287], "na" -> 
           RGBColor[0.658708, 0.492173, 0.842842], "mg" -> 
           RGBColor[0.628274, 0.850553, 0.0782731], "al" -> 
           RGBColor[0.8913, 0.631904, 0.627399], "si" -> 
           RGBColor[0.941176, 0.784314, 0.627451], "p" -> 
           RGBColor[1., 0.501961, 0], "s" -> 
           RGBColor[0.90443, 0.97015, 0.13504], "cl" -> 
           RGBColor[0.412698, 0.932689, 0.166398], "ar" -> 
           RGBColor[0.546138, 0.844244, 0.892092], "k" -> 
           RGBColor[0.534026, 0.420729, 0.705621], "ca" -> 
           RGBColor[0.480072, 0.744591, 0.0955222], "sc" -> 
           RGBColor[0.901961, 0.901961, 0.901961], "ti" -> 
           RGBColor[0.74902, 0.760784, 0.780392], "v" -> 
           RGBColor[0.65098, 0.65098, 0.670588], "cr" -> 
           RGBColor[0.541176, 0.6, 0.780392], "mn" -> 
           RGBColor[0.611765, 0.478431, 0.780392], "fe" -> 
           RGBColor[0.878431, 0.4, 0.2], "co" -> 
           RGBColor[0.941176, 0.564706, 0.627451], "ni" -> 
           RGBColor[0.313725, 0.815686, 0.313725], "cu" -> 
           RGBColor[0.784314, 0.501961, 0.2], "zn" -> 
           RGBColor[0.490196, 0.501961, 0.690196], "ga" -> 
           RGBColor[0.800757, 0.542666, 0.533513], "ge" -> 
           RGBColor[0.60508, 0.632465, 0.576489], "as" -> 
           RGBColor[0.741176, 0.501961, 0.890196], "se" -> 
           RGBColor[0.917248, 0.657833, 0.0706628], "br" -> 
           RGBColor[0.58847, 0.22163, 0.16064], "kr" -> 
           RGBColor[0.426019, 0.747462, 0.810413], "rb" -> 
           RGBColor[0.425391, 0.329242, 0.585895], "sr" -> 
           RGBColor[0.325959, 0.646423, 0.095983], "y" -> 
           RGBColor[0.531014, 1., 1.], "zr" -> 
           RGBColor[0.458599, 0.917466, 0.918573], "nb" -> 
           RGBColor[0.385036, 0.834854, 0.841681], "mo" -> 
           RGBColor[0.310325, 0.752163, 0.769323], "tc" -> 
           RGBColor[0.234466, 0.669394, 0.701499], "ru" -> 
           RGBColor[0.157459, 0.586546, 0.638209], "rh" -> 
           RGBColor[0.0793033, 0.50362, 0.579453], "pd" -> 
           RGBColor[0., 0.420615, 0.525231], "ag" -> 
           RGBColor[0.752941, 0.752941, 0.752941], "cd" -> 
           RGBColor[1., 0.85098, 0.560784], "in" -> 
           RGBColor[0.728371, 0.440594, 0.422196], "sn" -> 
           RGBColor[0.39799, 0.491477, 0.495586], "sb" -> 
           RGBColor[0.619608, 0.388235, 0.709804], "te" -> 
           RGBColor[0.816706, 0.451332, 0.0100947], "i" -> 
           RGBColor[0.580392, 0, 0.580392], "xe" -> 
           RGBColor[0.316906, 0.638078, 0.710252], "cs" -> 
           RGBColor[0.332803, 0.217712, 0.483666], "ba" -> 
           RGBColor[0.165935, 0.55605, 0.0796556], "la" -> 
           RGBColor[0.928084, 0.716075, 0.329427], "ce" -> 
           RGBColor[0.894824, 0.731424, 0.325131], "pr" -> 
           RGBColor[0.86523, 0.707999, 0.315261], "nd" -> 
           RGBColor[0.837836, 0.662974, 0.301635], "pm" -> 
           RGBColor[0.811992, 0.607859, 0.285626], "sm" -> 
           RGBColor[0.787563, 0.549894, 0.268279], "eu" -> 
           RGBColor[0.764628, 0.493261, 0.250405], "gd" -> 
           RGBColor[0.743177, 0.440115, 0.23269], "tb" -> 
           RGBColor[0.72281, 0.39143, 0.215783], "dy" -> 
           RGBColor[0.702434, 0.347663, 0.200392], "ho" -> 
           RGBColor[0.679962, 0.309234, 0.187368], "er" -> 
           RGBColor[0.652012, 0.276823, 0.17779], "tm" -> 
           RGBColor[0.613603, 0.251489, 0.173042], "yb" -> 
           RGBColor[0.557855, 0.234598, 0.17489], "lu" -> 
           RGBColor[0.475685, 0.227573, 0.18555], "hf" -> 
           RGBColor[0.781537, 0.717388, 0.716579], "ta" -> 
           RGBColor[0.734443, 0.544489, 0.683471], "w" -> 
           RGBColor[0.681179, 0.360409, 0.63675], "re" -> 
           RGBColor[0.605181, 0.367584, 0.556343], "os" -> 
           RGBColor[0.521806, 0.382125, 0.469204], "ir" -> 
           RGBColor[0.445624, 0.373159, 0.399069], "pt" -> 
           RGBColor[0.815686, 0.815686, 0.878431], "au" -> 
           RGBColor[1., 0.819608, 0.137255], "hg" -> 
           RGBColor[0.721569, 0.721569, 0.815686], "tl" -> 
           RGBColor[0.65098, 0.329412, 0.301961], "pb" -> 
           RGBColor[0.341176, 0.34902, 0.380392], "bi" -> 
           RGBColor[0.619608, 0.309804, 0.709804], "po" -> 
           RGBColor[0.670588, 0.360784, 0], "at" -> 
           RGBColor[0.458824, 0.309804, 0.270588], "rn" -> 
           RGBColor[0.218799, 0.516091, 0.591608], "fr" -> 
           RGBColor[0.25626, 0.0861372, 0.398932], "ra" -> 
           RGBColor[0., 0.473472, 0.04654], "ac" -> 
           RGBColor[0.322042, 0.71693, 0.988479], "th" -> 
           RGBColor[0.3608, 0.67166, 0.943003], "pa" -> 
           RGBColor[0.397469, 0.628, 0.898853], "u" -> 
           RGBColor[0.43205, 0.58595, 0.856029], "np" -> 
           RGBColor[0.464542, 0.54551, 0.814532], "pu" -> 
           RGBColor[0.494945, 0.506679, 0.774361], "am" -> 
           RGBColor[0.52326, 0.469458, 0.735517], "cm" -> 
           RGBColor[0.549486, 0.433847, 0.697999], "bk" -> 
           RGBColor[0.573624, 0.399845, 0.661808], "cf" -> 
           RGBColor[0.595673, 0.367454, 0.626942], "es" -> 
           RGBColor[0.615633, 0.336672, 0.593404], "fm" -> 
           RGBColor[0.633505, 0.307499, 0.561191], "md" -> 
           RGBColor[0.649288, 0.279937, 0.530305], "no" -> 
           RGBColor[0.662982, 0.253984, 0.500746], "lr" -> 
           RGBColor[0.674588, 0.22964, 0.472513], "rf" -> 
           RGBColor[0.684106, 0.206907, 0.445606], "db" -> 
           RGBColor[0.691534, 0.185783, 0.420025], "sg" -> 
           RGBColor[0.696874, 0.166269, 0.395772], "bh" -> 
           RGBColor[0.700126, 0.148365, 0.372844], "hs" -> 
           RGBColor[0.701289, 0.13207, 0.351243], "mt" -> 
           RGBColor[0.700363, 0.117385, 0.330968], "ds" -> 
           RGBColor[0.697348, 0.10431, 0.31202], "rg" -> 
           RGBColor[0.692245, 0.0928444, 0.294398], "cn" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "nh" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "fl" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "mc" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "lv" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "ts" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "og" -> 
           RGBColor[0.635401, 0.0528, 0.226184], "uub" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "uut" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "uuq" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "uup" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "uuh" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "uus" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "uuo" -> 
           RGBColor[0.635401, 0.0528, 0.226184]}]]& ][0.85], 
       ColorDataFunction[
       "Atoms", 
        "Named", {{
         "H", "He", "Li", "Be", "B", "C", "N", "O", "F", "Ne", "Na", "Mg", 
          "Al", "Si", "P", "S", "Cl", "Ar", "K", "Ca", "Sc", "Ti", "V", "Cr", 
          "Mn", "Fe", "Co", "Ni", "Cu", "Zn", "Ga", "Ge", "As", "Se", "Br", 
          "Kr", "Rb", "Sr", "Y", "Zr", "Nb", "Mo", "Tc", "Ru", "Rh", "Pd", 
          "Ag", "Cd", "In", "Sn", "Sb", "Te", "I", "Xe", "Cs", "Ba", "La", 
          "Ce", "Pr", "Nd", "Pm", "Sm", "Eu", "Gd", "Tb", "Dy", "Ho", "Er", 
          "Tm", "Yb", "Lu", "Hf", "Ta", "W", "Re", "Os", "Ir", "Pt", "Au", 
          "Hg", "Tl", "Pb", "Bi", "Po", "At", "Rn", "Fr", "Ra", "Ac", "Th", 
          "Pa", "U", "Np", "Pu", "Am", "Cm", "Bk", "Cf", "Es", "Fm", "Md", 
          "No", "Lr", "Rf", "Db", "Sg", "Bh", "Hs", "Mt", "Ds", "Rg", "Cn", 
          "Nh", "Fl", "Mc", "Lv", "Ts", "Og", "Uub", "Uut", "Uuq", "Uup", 
          "Uuh", "Uus", "Uuo"}, {
         "h", "he", "li", "be", "b", "c", "n", "o", "f", "ne", "na", "mg", 
          "al", "si", "p", "s", "cl", "ar", "k", "ca", "sc", "ti", "v", "cr", 
          "mn", "fe", "co", "ni", "cu", "zn", "ga", "ge", "as", "se", "br", 
          "kr", "rb", "sr", "y", "zr", "nb", "mo", "tc", "ru", "rh", "pd", 
          "ag", "cd", "in", "sn", "sb", "te", "i", "xe", "cs", "ba", "la", 
          "ce", "pr", "nd", "pm", "sm", "eu", "gd", "tb", "dy", "ho", "er", 
          "tm", "yb", "lu", "hf", "ta", "w", "re", "os", "ir", "pt", "au", 
          "hg", "tl", "pb", "bi", "po", "at", "rn", "fr", "ra", "ac", "th", 
          "pa", "u", "np", "pu", "am", "cm", "bk", "cf", "es", "fm", "md", 
          "no", "lr", "rf", "db", "sg", "bh", "hs", "mt", "ds", "rg", "cn", 
          "nh", "fl", "mc", "lv", "ts", "og", "uub", "uut", "uuq", "uup", 
          "uuh", "uus", "uuo"}}, Replace[#, 
         Dispatch[{
          "h" -> RGBColor[0.65, 0.7, 0.7], "he" -> RGBColor[0.836713, 1., 1.],
            "li" -> RGBColor[0.799435, 0.543572, 0.997559], "be" -> 
           RGBColor[0.770565, 0.964309, 0.0442359], "b" -> 
           RGBColor[1., 0.709804, 0.709804], "c" -> RGBColor[0.4, 0.4, 0.4], 
           "n" -> RGBColor[0.291989, 0.437977, 0.888609], "o" -> 
           RGBColor[0.800498, 0.201504, 0.192061], "f" -> 
           RGBColor[0.578462, 0.85539, 0.408855], "ne" -> 
           RGBColor[0.677263, 0.928423, 0.955287], "na" -> 
           RGBColor[0.658708, 0.492173, 0.842842], "mg" -> 
           RGBColor[0.628274, 0.850553, 0.0782731], "al" -> 
           RGBColor[0.8913, 0.631904, 0.627399], "si" -> 
           RGBColor[0.941176, 0.784314, 0.627451], "p" -> 
           RGBColor[1., 0.501961, 0], "s" -> 
           RGBColor[0.90443, 0.97015, 0.13504], "cl" -> 
           RGBColor[0.412698, 0.932689, 0.166398], "ar" -> 
           RGBColor[0.546138, 0.844244, 0.892092], "k" -> 
           RGBColor[0.534026, 0.420729, 0.705621], "ca" -> 
           RGBColor[0.480072, 0.744591, 0.0955222], "sc" -> 
           RGBColor[0.901961, 0.901961, 0.901961], "ti" -> 
           RGBColor[0.74902, 0.760784, 0.780392], "v" -> 
           RGBColor[0.65098, 0.65098, 0.670588], "cr" -> 
           RGBColor[0.541176, 0.6, 0.780392], "mn" -> 
           RGBColor[0.611765, 0.478431, 0.780392], "fe" -> 
           RGBColor[0.878431, 0.4, 0.2], "co" -> 
           RGBColor[0.941176, 0.564706, 0.627451], "ni" -> 
           RGBColor[0.313725, 0.815686, 0.313725], "cu" -> 
           RGBColor[0.784314, 0.501961, 0.2], "zn" -> 
           RGBColor[0.490196, 0.501961, 0.690196], "ga" -> 
           RGBColor[0.800757, 0.542666, 0.533513], "ge" -> 
           RGBColor[0.60508, 0.632465, 0.576489], "as" -> 
           RGBColor[0.741176, 0.501961, 0.890196], "se" -> 
           RGBColor[0.917248, 0.657833, 0.0706628], "br" -> 
           RGBColor[0.58847, 0.22163, 0.16064], "kr" -> 
           RGBColor[0.426019, 0.747462, 0.810413], "rb" -> 
           RGBColor[0.425391, 0.329242, 0.585895], "sr" -> 
           RGBColor[0.325959, 0.646423, 0.095983], "y" -> 
           RGBColor[0.531014, 1., 1.], "zr" -> 
           RGBColor[0.458599, 0.917466, 0.918573], "nb" -> 
           RGBColor[0.385036, 0.834854, 0.841681], "mo" -> 
           RGBColor[0.310325, 0.752163, 0.769323], "tc" -> 
           RGBColor[0.234466, 0.669394, 0.701499], "ru" -> 
           RGBColor[0.157459, 0.586546, 0.638209], "rh" -> 
           RGBColor[0.0793033, 0.50362, 0.579453], "pd" -> 
           RGBColor[0., 0.420615, 0.525231], "ag" -> 
           RGBColor[0.752941, 0.752941, 0.752941], "cd" -> 
           RGBColor[1., 0.85098, 0.560784], "in" -> 
           RGBColor[0.728371, 0.440594, 0.422196], "sn" -> 
           RGBColor[0.39799, 0.491477, 0.495586], "sb" -> 
           RGBColor[0.619608, 0.388235, 0.709804], "te" -> 
           RGBColor[0.816706, 0.451332, 0.0100947], "i" -> 
           RGBColor[0.580392, 0, 0.580392], "xe" -> 
           RGBColor[0.316906, 0.638078, 0.710252], "cs" -> 
           RGBColor[0.332803, 0.217712, 0.483666], "ba" -> 
           RGBColor[0.165935, 0.55605, 0.0796556], "la" -> 
           RGBColor[0.928084, 0.716075, 0.329427], "ce" -> 
           RGBColor[0.894824, 0.731424, 0.325131], "pr" -> 
           RGBColor[0.86523, 0.707999, 0.315261], "nd" -> 
           RGBColor[0.837836, 0.662974, 0.301635], "pm" -> 
           RGBColor[0.811992, 0.607859, 0.285626], "sm" -> 
           RGBColor[0.787563, 0.549894, 0.268279], "eu" -> 
           RGBColor[0.764628, 0.493261, 0.250405], "gd" -> 
           RGBColor[0.743177, 0.440115, 0.23269], "tb" -> 
           RGBColor[0.72281, 0.39143, 0.215783], "dy" -> 
           RGBColor[0.702434, 0.347663, 0.200392], "ho" -> 
           RGBColor[0.679962, 0.309234, 0.187368], "er" -> 
           RGBColor[0.652012, 0.276823, 0.17779], "tm" -> 
           RGBColor[0.613603, 0.251489, 0.173042], "yb" -> 
           RGBColor[0.557855, 0.234598, 0.17489], "lu" -> 
           RGBColor[0.475685, 0.227573, 0.18555], "hf" -> 
           RGBColor[0.781537, 0.717388, 0.716579], "ta" -> 
           RGBColor[0.734443, 0.544489, 0.683471], "w" -> 
           RGBColor[0.681179, 0.360409, 0.63675], "re" -> 
           RGBColor[0.605181, 0.367584, 0.556343], "os" -> 
           RGBColor[0.521806, 0.382125, 0.469204], "ir" -> 
           RGBColor[0.445624, 0.373159, 0.399069], "pt" -> 
           RGBColor[0.815686, 0.815686, 0.878431], "au" -> 
           RGBColor[1., 0.819608, 0.137255], "hg" -> 
           RGBColor[0.721569, 0.721569, 0.815686], "tl" -> 
           RGBColor[0.65098, 0.329412, 0.301961], "pb" -> 
           RGBColor[0.341176, 0.34902, 0.380392], "bi" -> 
           RGBColor[0.619608, 0.309804, 0.709804], "po" -> 
           RGBColor[0.670588, 0.360784, 0], "at" -> 
           RGBColor[0.458824, 0.309804, 0.270588], "rn" -> 
           RGBColor[0.218799, 0.516091, 0.591608], "fr" -> 
           RGBColor[0.25626, 0.0861372, 0.398932], "ra" -> 
           RGBColor[0., 0.473472, 0.04654], "ac" -> 
           RGBColor[0.322042, 0.71693, 0.988479], "th" -> 
           RGBColor[0.3608, 0.67166, 0.943003], "pa" -> 
           RGBColor[0.397469, 0.628, 0.898853], "u" -> 
           RGBColor[0.43205, 0.58595, 0.856029], "np" -> 
           RGBColor[0.464542, 0.54551, 0.814532], "pu" -> 
           RGBColor[0.494945, 0.506679, 0.774361], "am" -> 
           RGBColor[0.52326, 0.469458, 0.735517], "cm" -> 
           RGBColor[0.549486, 0.433847, 0.697999], "bk" -> 
           RGBColor[0.573624, 0.399845, 0.661808], "cf" -> 
           RGBColor[0.595673, 0.367454, 0.626942], "es" -> 
           RGBColor[0.615633, 0.336672, 0.593404], "fm" -> 
           RGBColor[0.633505, 0.307499, 0.561191], "md" -> 
           RGBColor[0.649288, 0.279937, 0.530305], "no" -> 
           RGBColor[0.662982, 0.253984, 0.500746], "lr" -> 
           RGBColor[0.674588, 0.22964, 0.472513], "rf" -> 
           RGBColor[0.684106, 0.206907, 0.445606], "db" -> 
           RGBColor[0.691534, 0.185783, 0.420025], "sg" -> 
           RGBColor[0.696874, 0.166269, 0.395772], "bh" -> 
           RGBColor[0.700126, 0.148365, 0.372844], "hs" -> 
           RGBColor[0.701289, 0.13207, 0.351243], "mt" -> 
           RGBColor[0.700363, 0.117385, 0.330968], "ds" -> 
           RGBColor[0.697348, 0.10431, 0.31202], "rg" -> 
           RGBColor[0.692245, 0.0928444, 0.294398], "cn" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "nh" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "fl" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "mc" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "lv" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "ts" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "og" -> 
           RGBColor[0.635401, 0.0528, 0.226184], "uub" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "uut" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "uuq" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "uup" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "uuh" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "uus" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "uuo" -> 
           RGBColor[0.635401, 0.0528, 0.226184]}]]& ][0.85], 
       ColorDataFunction[
       "Atoms", 
        "Named", {{
         "H", "He", "Li", "Be", "B", "C", "N", "O", "F", "Ne", "Na", "Mg", 
          "Al", "Si", "P", "S", "Cl", "Ar", "K", "Ca", "Sc", "Ti", "V", "Cr", 
          "Mn", "Fe", "Co", "Ni", "Cu", "Zn", "Ga", "Ge", "As", "Se", "Br", 
          "Kr", "Rb", "Sr", "Y", "Zr", "Nb", "Mo", "Tc", "Ru", "Rh", "Pd", 
          "Ag", "Cd", "In", "Sn", "Sb", "Te", "I", "Xe", "Cs", "Ba", "La", 
          "Ce", "Pr", "Nd", "Pm", "Sm", "Eu", "Gd", "Tb", "Dy", "Ho", "Er", 
          "Tm", "Yb", "Lu", "Hf", "Ta", "W", "Re", "Os", "Ir", "Pt", "Au", 
          "Hg", "Tl", "Pb", "Bi", "Po", "At", "Rn", "Fr", "Ra", "Ac", "Th", 
          "Pa", "U", "Np", "Pu", "Am", "Cm", "Bk", "Cf", "Es", "Fm", "Md", 
          "No", "Lr", "Rf", "Db", "Sg", "Bh", "Hs", "Mt", "Ds", "Rg", "Cn", 
          "Nh", "Fl", "Mc", "Lv", "Ts", "Og", "Uub", "Uut", "Uuq", "Uup", 
          "Uuh", "Uus", "Uuo"}, {
         "h", "he", "li", "be", "b", "c", "n", "o", "f", "ne", "na", "mg", 
          "al", "si", "p", "s", "cl", "ar", "k", "ca", "sc", "ti", "v", "cr", 
          "mn", "fe", "co", "ni", "cu", "zn", "ga", "ge", "as", "se", "br", 
          "kr", "rb", "sr", "y", "zr", "nb", "mo", "tc", "ru", "rh", "pd", 
          "ag", "cd", "in", "sn", "sb", "te", "i", "xe", "cs", "ba", "la", 
          "ce", "pr", "nd", "pm", "sm", "eu", "gd", "tb", "dy", "ho", "er", 
          "tm", "yb", "lu", "hf", "ta", "w", "re", "os", "ir", "pt", "au", 
          "hg", "tl", "pb", "bi", "po", "at", "rn", "fr", "ra", "ac", "th", 
          "pa", "u", "np", "pu", "am", "cm", "bk", "cf", "es", "fm", "md", 
          "no", "lr", "rf", "db", "sg", "bh", "hs", "mt", "ds", "rg", "cn", 
          "nh", "fl", "mc", "lv", "ts", "og", "uub", "uut", "uuq", "uup", 
          "uuh", "uus", "uuo"}}, Replace[#, 
         Dispatch[{
          "h" -> RGBColor[0.65, 0.7, 0.7], "he" -> RGBColor[0.836713, 1., 1.],
            "li" -> RGBColor[0.799435, 0.543572, 0.997559], "be" -> 
           RGBColor[0.770565, 0.964309, 0.0442359], "b" -> 
           RGBColor[1., 0.709804, 0.709804], "c" -> RGBColor[0.4, 0.4, 0.4], 
           "n" -> RGBColor[0.291989, 0.437977, 0.888609], "o" -> 
           RGBColor[0.800498, 0.201504, 0.192061], "f" -> 
           RGBColor[0.578462, 0.85539, 0.408855], "ne" -> 
           RGBColor[0.677263, 0.928423, 0.955287], "na" -> 
           RGBColor[0.658708, 0.492173, 0.842842], "mg" -> 
           RGBColor[0.628274, 0.850553, 0.0782731], "al" -> 
           RGBColor[0.8913, 0.631904, 0.627399], "si" -> 
           RGBColor[0.941176, 0.784314, 0.627451], "p" -> 
           RGBColor[1., 0.501961, 0], "s" -> 
           RGBColor[0.90443, 0.97015, 0.13504], "cl" -> 
           RGBColor[0.412698, 0.932689, 0.166398], "ar" -> 
           RGBColor[0.546138, 0.844244, 0.892092], "k" -> 
           RGBColor[0.534026, 0.420729, 0.705621], "ca" -> 
           RGBColor[0.480072, 0.744591, 0.0955222], "sc" -> 
           RGBColor[0.901961, 0.901961, 0.901961], "ti" -> 
           RGBColor[0.74902, 0.760784, 0.780392], "v" -> 
           RGBColor[0.65098, 0.65098, 0.670588], "cr" -> 
           RGBColor[0.541176, 0.6, 0.780392], "mn" -> 
           RGBColor[0.611765, 0.478431, 0.780392], "fe" -> 
           RGBColor[0.878431, 0.4, 0.2], "co" -> 
           RGBColor[0.941176, 0.564706, 0.627451], "ni" -> 
           RGBColor[0.313725, 0.815686, 0.313725], "cu" -> 
           RGBColor[0.784314, 0.501961, 0.2], "zn" -> 
           RGBColor[0.490196, 0.501961, 0.690196], "ga" -> 
           RGBColor[0.800757, 0.542666, 0.533513], "ge" -> 
           RGBColor[0.60508, 0.632465, 0.576489], "as" -> 
           RGBColor[0.741176, 0.501961, 0.890196], "se" -> 
           RGBColor[0.917248, 0.657833, 0.0706628], "br" -> 
           RGBColor[0.58847, 0.22163, 0.16064], "kr" -> 
           RGBColor[0.426019, 0.747462, 0.810413], "rb" -> 
           RGBColor[0.425391, 0.329242, 0.585895], "sr" -> 
           RGBColor[0.325959, 0.646423, 0.095983], "y" -> 
           RGBColor[0.531014, 1., 1.], "zr" -> 
           RGBColor[0.458599, 0.917466, 0.918573], "nb" -> 
           RGBColor[0.385036, 0.834854, 0.841681], "mo" -> 
           RGBColor[0.310325, 0.752163, 0.769323], "tc" -> 
           RGBColor[0.234466, 0.669394, 0.701499], "ru" -> 
           RGBColor[0.157459, 0.586546, 0.638209], "rh" -> 
           RGBColor[0.0793033, 0.50362, 0.579453], "pd" -> 
           RGBColor[0., 0.420615, 0.525231], "ag" -> 
           RGBColor[0.752941, 0.752941, 0.752941], "cd" -> 
           RGBColor[1., 0.85098, 0.560784], "in" -> 
           RGBColor[0.728371, 0.440594, 0.422196], "sn" -> 
           RGBColor[0.39799, 0.491477, 0.495586], "sb" -> 
           RGBColor[0.619608, 0.388235, 0.709804], "te" -> 
           RGBColor[0.816706, 0.451332, 0.0100947], "i" -> 
           RGBColor[0.580392, 0, 0.580392], "xe" -> 
           RGBColor[0.316906, 0.638078, 0.710252], "cs" -> 
           RGBColor[0.332803, 0.217712, 0.483666], "ba" -> 
           RGBColor[0.165935, 0.55605, 0.0796556], "la" -> 
           RGBColor[0.928084, 0.716075, 0.329427], "ce" -> 
           RGBColor[0.894824, 0.731424, 0.325131], "pr" -> 
           RGBColor[0.86523, 0.707999, 0.315261], "nd" -> 
           RGBColor[0.837836, 0.662974, 0.301635], "pm" -> 
           RGBColor[0.811992, 0.607859, 0.285626], "sm" -> 
           RGBColor[0.787563, 0.549894, 0.268279], "eu" -> 
           RGBColor[0.764628, 0.493261, 0.250405], "gd" -> 
           RGBColor[0.743177, 0.440115, 0.23269], "tb" -> 
           RGBColor[0.72281, 0.39143, 0.215783], "dy" -> 
           RGBColor[0.702434, 0.347663, 0.200392], "ho" -> 
           RGBColor[0.679962, 0.309234, 0.187368], "er" -> 
           RGBColor[0.652012, 0.276823, 0.17779], "tm" -> 
           RGBColor[0.613603, 0.251489, 0.173042], "yb" -> 
           RGBColor[0.557855, 0.234598, 0.17489], "lu" -> 
           RGBColor[0.475685, 0.227573, 0.18555], "hf" -> 
           RGBColor[0.781537, 0.717388, 0.716579], "ta" -> 
           RGBColor[0.734443, 0.544489, 0.683471], "w" -> 
           RGBColor[0.681179, 0.360409, 0.63675], "re" -> 
           RGBColor[0.605181, 0.367584, 0.556343], "os" -> 
           RGBColor[0.521806, 0.382125, 0.469204], "ir" -> 
           RGBColor[0.445624, 0.373159, 0.399069], "pt" -> 
           RGBColor[0.815686, 0.815686, 0.878431], "au" -> 
           RGBColor[1., 0.819608, 0.137255], "hg" -> 
           RGBColor[0.721569, 0.721569, 0.815686], "tl" -> 
           RGBColor[0.65098, 0.329412, 0.301961], "pb" -> 
           RGBColor[0.341176, 0.34902, 0.380392], "bi" -> 
           RGBColor[0.619608, 0.309804, 0.709804], "po" -> 
           RGBColor[0.670588, 0.360784, 0], "at" -> 
           RGBColor[0.458824, 0.309804, 0.270588], "rn" -> 
           RGBColor[0.218799, 0.516091, 0.591608], "fr" -> 
           RGBColor[0.25626, 0.0861372, 0.398932], "ra" -> 
           RGBColor[0., 0.473472, 0.04654], "ac" -> 
           RGBColor[0.322042, 0.71693, 0.988479], "th" -> 
           RGBColor[0.3608, 0.67166, 0.943003], "pa" -> 
           RGBColor[0.397469, 0.628, 0.898853], "u" -> 
           RGBColor[0.43205, 0.58595, 0.856029], "np" -> 
           RGBColor[0.464542, 0.54551, 0.814532], "pu" -> 
           RGBColor[0.494945, 0.506679, 0.774361], "am" -> 
           RGBColor[0.52326, 0.469458, 0.735517], "cm" -> 
           RGBColor[0.549486, 0.433847, 0.697999], "bk" -> 
           RGBColor[0.573624, 0.399845, 0.661808], "cf" -> 
           RGBColor[0.595673, 0.367454, 0.626942], "es" -> 
           RGBColor[0.615633, 0.336672, 0.593404], "fm" -> 
           RGBColor[0.633505, 0.307499, 0.561191], "md" -> 
           RGBColor[0.649288, 0.279937, 0.530305], "no" -> 
           RGBColor[0.662982, 0.253984, 0.500746], "lr" -> 
           RGBColor[0.674588, 0.22964, 0.472513], "rf" -> 
           RGBColor[0.684106, 0.206907, 0.445606], "db" -> 
           RGBColor[0.691534, 0.185783, 0.420025], "sg" -> 
           RGBColor[0.696874, 0.166269, 0.395772], "bh" -> 
           RGBColor[0.700126, 0.148365, 0.372844], "hs" -> 
           RGBColor[0.701289, 0.13207, 0.351243], "mt" -> 
           RGBColor[0.700363, 0.117385, 0.330968], "ds" -> 
           RGBColor[0.697348, 0.10431, 0.31202], "rg" -> 
           RGBColor[0.692245, 0.0928444, 0.294398], "cn" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "nh" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "fl" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "mc" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "lv" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "ts" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "og" -> 
           RGBColor[0.635401, 0.0528, 0.226184], "uub" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "uut" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "uuq" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "uup" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "uuh" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "uus" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "uuo" -> 
           RGBColor[0.635401, 0.0528, 0.226184]}]]& ][0.85], 
       ColorDataFunction[
       "Atoms", 
        "Named", {{
         "H", "He", "Li", "Be", "B", "C", "N", "O", "F", "Ne", "Na", "Mg", 
          "Al", "Si", "P", "S", "Cl", "Ar", "K", "Ca", "Sc", "Ti", "V", "Cr", 
          "Mn", "Fe", "Co", "Ni", "Cu", "Zn", "Ga", "Ge", "As", "Se", "Br", 
          "Kr", "Rb", "Sr", "Y", "Zr", "Nb", "Mo", "Tc", "Ru", "Rh", "Pd", 
          "Ag", "Cd", "In", "Sn", "Sb", "Te", "I", "Xe", "Cs", "Ba", "La", 
          "Ce", "Pr", "Nd", "Pm", "Sm", "Eu", "Gd", "Tb", "Dy", "Ho", "Er", 
          "Tm", "Yb", "Lu", "Hf", "Ta", "W", "Re", "Os", "Ir", "Pt", "Au", 
          "Hg", "Tl", "Pb", "Bi", "Po", "At", "Rn", "Fr", "Ra", "Ac", "Th", 
          "Pa", "U", "Np", "Pu", "Am", "Cm", "Bk", "Cf", "Es", "Fm", "Md", 
          "No", "Lr", "Rf", "Db", "Sg", "Bh", "Hs", "Mt", "Ds", "Rg", "Cn", 
          "Nh", "Fl", "Mc", "Lv", "Ts", "Og", "Uub", "Uut", "Uuq", "Uup", 
          "Uuh", "Uus", "Uuo"}, {
         "h", "he", "li", "be", "b", "c", "n", "o", "f", "ne", "na", "mg", 
          "al", "si", "p", "s", "cl", "ar", "k", "ca", "sc", "ti", "v", "cr", 
          "mn", "fe", "co", "ni", "cu", "zn", "ga", "ge", "as", "se", "br", 
          "kr", "rb", "sr", "y", "zr", "nb", "mo", "tc", "ru", "rh", "pd", 
          "ag", "cd", "in", "sn", "sb", "te", "i", "xe", "cs", "ba", "la", 
          "ce", "pr", "nd", "pm", "sm", "eu", "gd", "tb", "dy", "ho", "er", 
          "tm", "yb", "lu", "hf", "ta", "w", "re", "os", "ir", "pt", "au", 
          "hg", "tl", "pb", "bi", "po", "at", "rn", "fr", "ra", "ac", "th", 
          "pa", "u", "np", "pu", "am", "cm", "bk", "cf", "es", "fm", "md", 
          "no", "lr", "rf", "db", "sg", "bh", "hs", "mt", "ds", "rg", "cn", 
          "nh", "fl", "mc", "lv", "ts", "og", "uub", "uut", "uuq", "uup", 
          "uuh", "uus", "uuo"}}, Replace[#, 
         Dispatch[{
          "h" -> RGBColor[0.65, 0.7, 0.7], "he" -> RGBColor[0.836713, 1., 1.],
            "li" -> RGBColor[0.799435, 0.543572, 0.997559], "be" -> 
           RGBColor[0.770565, 0.964309, 0.0442359], "b" -> 
           RGBColor[1., 0.709804, 0.709804], "c" -> RGBColor[0.4, 0.4, 0.4], 
           "n" -> RGBColor[0.291989, 0.437977, 0.888609], "o" -> 
           RGBColor[0.800498, 0.201504, 0.192061], "f" -> 
           RGBColor[0.578462, 0.85539, 0.408855], "ne" -> 
           RGBColor[0.677263, 0.928423, 0.955287], "na" -> 
           RGBColor[0.658708, 0.492173, 0.842842], "mg" -> 
           RGBColor[0.628274, 0.850553, 0.0782731], "al" -> 
           RGBColor[0.8913, 0.631904, 0.627399], "si" -> 
           RGBColor[0.941176, 0.784314, 0.627451], "p" -> 
           RGBColor[1., 0.501961, 0], "s" -> 
           RGBColor[0.90443, 0.97015, 0.13504], "cl" -> 
           RGBColor[0.412698, 0.932689, 0.166398], "ar" -> 
           RGBColor[0.546138, 0.844244, 0.892092], "k" -> 
           RGBColor[0.534026, 0.420729, 0.705621], "ca" -> 
           RGBColor[0.480072, 0.744591, 0.0955222], "sc" -> 
           RGBColor[0.901961, 0.901961, 0.901961], "ti" -> 
           RGBColor[0.74902, 0.760784, 0.780392], "v" -> 
           RGBColor[0.65098, 0.65098, 0.670588], "cr" -> 
           RGBColor[0.541176, 0.6, 0.780392], "mn" -> 
           RGBColor[0.611765, 0.478431, 0.780392], "fe" -> 
           RGBColor[0.878431, 0.4, 0.2], "co" -> 
           RGBColor[0.941176, 0.564706, 0.627451], "ni" -> 
           RGBColor[0.313725, 0.815686, 0.313725], "cu" -> 
           RGBColor[0.784314, 0.501961, 0.2], "zn" -> 
           RGBColor[0.490196, 0.501961, 0.690196], "ga" -> 
           RGBColor[0.800757, 0.542666, 0.533513], "ge" -> 
           RGBColor[0.60508, 0.632465, 0.576489], "as" -> 
           RGBColor[0.741176, 0.501961, 0.890196], "se" -> 
           RGBColor[0.917248, 0.657833, 0.0706628], "br" -> 
           RGBColor[0.58847, 0.22163, 0.16064], "kr" -> 
           RGBColor[0.426019, 0.747462, 0.810413], "rb" -> 
           RGBColor[0.425391, 0.329242, 0.585895], "sr" -> 
           RGBColor[0.325959, 0.646423, 0.095983], "y" -> 
           RGBColor[0.531014, 1., 1.], "zr" -> 
           RGBColor[0.458599, 0.917466, 0.918573], "nb" -> 
           RGBColor[0.385036, 0.834854, 0.841681], "mo" -> 
           RGBColor[0.310325, 0.752163, 0.769323], "tc" -> 
           RGBColor[0.234466, 0.669394, 0.701499], "ru" -> 
           RGBColor[0.157459, 0.586546, 0.638209], "rh" -> 
           RGBColor[0.0793033, 0.50362, 0.579453], "pd" -> 
           RGBColor[0., 0.420615, 0.525231], "ag" -> 
           RGBColor[0.752941, 0.752941, 0.752941], "cd" -> 
           RGBColor[1., 0.85098, 0.560784], "in" -> 
           RGBColor[0.728371, 0.440594, 0.422196], "sn" -> 
           RGBColor[0.39799, 0.491477, 0.495586], "sb" -> 
           RGBColor[0.619608, 0.388235, 0.709804], "te" -> 
           RGBColor[0.816706, 0.451332, 0.0100947], "i" -> 
           RGBColor[0.580392, 0, 0.580392], "xe" -> 
           RGBColor[0.316906, 0.638078, 0.710252], "cs" -> 
           RGBColor[0.332803, 0.217712, 0.483666], "ba" -> 
           RGBColor[0.165935, 0.55605, 0.0796556], "la" -> 
           RGBColor[0.928084, 0.716075, 0.329427], "ce" -> 
           RGBColor[0.894824, 0.731424, 0.325131], "pr" -> 
           RGBColor[0.86523, 0.707999, 0.315261], "nd" -> 
           RGBColor[0.837836, 0.662974, 0.301635], "pm" -> 
           RGBColor[0.811992, 0.607859, 0.285626], "sm" -> 
           RGBColor[0.787563, 0.549894, 0.268279], "eu" -> 
           RGBColor[0.764628, 0.493261, 0.250405], "gd" -> 
           RGBColor[0.743177, 0.440115, 0.23269], "tb" -> 
           RGBColor[0.72281, 0.39143, 0.215783], "dy" -> 
           RGBColor[0.702434, 0.347663, 0.200392], "ho" -> 
           RGBColor[0.679962, 0.309234, 0.187368], "er" -> 
           RGBColor[0.652012, 0.276823, 0.17779], "tm" -> 
           RGBColor[0.613603, 0.251489, 0.173042], "yb" -> 
           RGBColor[0.557855, 0.234598, 0.17489], "lu" -> 
           RGBColor[0.475685, 0.227573, 0.18555], "hf" -> 
           RGBColor[0.781537, 0.717388, 0.716579], "ta" -> 
           RGBColor[0.734443, 0.544489, 0.683471], "w" -> 
           RGBColor[0.681179, 0.360409, 0.63675], "re" -> 
           RGBColor[0.605181, 0.367584, 0.556343], "os" -> 
           RGBColor[0.521806, 0.382125, 0.469204], "ir" -> 
           RGBColor[0.445624, 0.373159, 0.399069], "pt" -> 
           RGBColor[0.815686, 0.815686, 0.878431], "au" -> 
           RGBColor[1., 0.819608, 0.137255], "hg" -> 
           RGBColor[0.721569, 0.721569, 0.815686], "tl" -> 
           RGBColor[0.65098, 0.329412, 0.301961], "pb" -> 
           RGBColor[0.341176, 0.34902, 0.380392], "bi" -> 
           RGBColor[0.619608, 0.309804, 0.709804], "po" -> 
           RGBColor[0.670588, 0.360784, 0], "at" -> 
           RGBColor[0.458824, 0.309804, 0.270588], "rn" -> 
           RGBColor[0.218799, 0.516091, 0.591608], "fr" -> 
           RGBColor[0.25626, 0.0861372, 0.398932], "ra" -> 
           RGBColor[0., 0.473472, 0.04654], "ac" -> 
           RGBColor[0.322042, 0.71693, 0.988479], "th" -> 
           RGBColor[0.3608, 0.67166, 0.943003], "pa" -> 
           RGBColor[0.397469, 0.628, 0.898853], "u" -> 
           RGBColor[0.43205, 0.58595, 0.856029], "np" -> 
           RGBColor[0.464542, 0.54551, 0.814532], "pu" -> 
           RGBColor[0.494945, 0.506679, 0.774361], "am" -> 
           RGBColor[0.52326, 0.469458, 0.735517], "cm" -> 
           RGBColor[0.549486, 0.433847, 0.697999], "bk" -> 
           RGBColor[0.573624, 0.399845, 0.661808], "cf" -> 
           RGBColor[0.595673, 0.367454, 0.626942], "es" -> 
           RGBColor[0.615633, 0.336672, 0.593404], "fm" -> 
           RGBColor[0.633505, 0.307499, 0.561191], "md" -> 
           RGBColor[0.649288, 0.279937, 0.530305], "no" -> 
           RGBColor[0.662982, 0.253984, 0.500746], "lr" -> 
           RGBColor[0.674588, 0.22964, 0.472513], "rf" -> 
           RGBColor[0.684106, 0.206907, 0.445606], "db" -> 
           RGBColor[0.691534, 0.185783, 0.420025], "sg" -> 
           RGBColor[0.696874, 0.166269, 0.395772], "bh" -> 
           RGBColor[0.700126, 0.148365, 0.372844], "hs" -> 
           RGBColor[0.701289, 0.13207, 0.351243], "mt" -> 
           RGBColor[0.700363, 0.117385, 0.330968], "ds" -> 
           RGBColor[0.697348, 0.10431, 0.31202], "rg" -> 
           RGBColor[0.692245, 0.0928444, 0.294398], "cn" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "nh" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "fl" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "mc" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "lv" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "ts" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "og" -> 
           RGBColor[0.635401, 0.0528, 0.226184], "uub" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "uut" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "uuq" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "uup" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "uuh" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "uus" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "uuo" -> 
           RGBColor[0.635401, 0.0528, 0.226184]}]]& ][0.85], 
       ColorDataFunction[
       "Atoms", 
        "Named", {{
         "H", "He", "Li", "Be", "B", "C", "N", "O", "F", "Ne", "Na", "Mg", 
          "Al", "Si", "P", "S", "Cl", "Ar", "K", "Ca", "Sc", "Ti", "V", "Cr", 
          "Mn", "Fe", "Co", "Ni", "Cu", "Zn", "Ga", "Ge", "As", "Se", "Br", 
          "Kr", "Rb", "Sr", "Y", "Zr", "Nb", "Mo", "Tc", "Ru", "Rh", "Pd", 
          "Ag", "Cd", "In", "Sn", "Sb", "Te", "I", "Xe", "Cs", "Ba", "La", 
          "Ce", "Pr", "Nd", "Pm", "Sm", "Eu", "Gd", "Tb", "Dy", "Ho", "Er", 
          "Tm", "Yb", "Lu", "Hf", "Ta", "W", "Re", "Os", "Ir", "Pt", "Au", 
          "Hg", "Tl", "Pb", "Bi", "Po", "At", "Rn", "Fr", "Ra", "Ac", "Th", 
          "Pa", "U", "Np", "Pu", "Am", "Cm", "Bk", "Cf", "Es", "Fm", "Md", 
          "No", "Lr", "Rf", "Db", "Sg", "Bh", "Hs", "Mt", "Ds", "Rg", "Cn", 
          "Nh", "Fl", "Mc", "Lv", "Ts", "Og", "Uub", "Uut", "Uuq", "Uup", 
          "Uuh", "Uus", "Uuo"}, {
         "h", "he", "li", "be", "b", "c", "n", "o", "f", "ne", "na", "mg", 
          "al", "si", "p", "s", "cl", "ar", "k", "ca", "sc", "ti", "v", "cr", 
          "mn", "fe", "co", "ni", "cu", "zn", "ga", "ge", "as", "se", "br", 
          "kr", "rb", "sr", "y", "zr", "nb", "mo", "tc", "ru", "rh", "pd", 
          "ag", "cd", "in", "sn", "sb", "te", "i", "xe", "cs", "ba", "la", 
          "ce", "pr", "nd", "pm", "sm", "eu", "gd", "tb", "dy", "ho", "er", 
          "tm", "yb", "lu", "hf", "ta", "w", "re", "os", "ir", "pt", "au", 
          "hg", "tl", "pb", "bi", "po", "at", "rn", "fr", "ra", "ac", "th", 
          "pa", "u", "np", "pu", "am", "cm", "bk", "cf", "es", "fm", "md", 
          "no", "lr", "rf", "db", "sg", "bh", "hs", "mt", "ds", "rg", "cn", 
          "nh", "fl", "mc", "lv", "ts", "og", "uub", "uut", "uuq", "uup", 
          "uuh", "uus", "uuo"}}, Replace[#, 
         Dispatch[{
          "h" -> RGBColor[0.65, 0.7, 0.7], "he" -> RGBColor[0.836713, 1., 1.],
            "li" -> RGBColor[0.799435, 0.543572, 0.997559], "be" -> 
           RGBColor[0.770565, 0.964309, 0.0442359], "b" -> 
           RGBColor[1., 0.709804, 0.709804], "c" -> RGBColor[0.4, 0.4, 0.4], 
           "n" -> RGBColor[0.291989, 0.437977, 0.888609], "o" -> 
           RGBColor[0.800498, 0.201504, 0.192061], "f" -> 
           RGBColor[0.578462, 0.85539, 0.408855], "ne" -> 
           RGBColor[0.677263, 0.928423, 0.955287], "na" -> 
           RGBColor[0.658708, 0.492173, 0.842842], "mg" -> 
           RGBColor[0.628274, 0.850553, 0.0782731], "al" -> 
           RGBColor[0.8913, 0.631904, 0.627399], "si" -> 
           RGBColor[0.941176, 0.784314, 0.627451], "p" -> 
           RGBColor[1., 0.501961, 0], "s" -> 
           RGBColor[0.90443, 0.97015, 0.13504], "cl" -> 
           RGBColor[0.412698, 0.932689, 0.166398], "ar" -> 
           RGBColor[0.546138, 0.844244, 0.892092], "k" -> 
           RGBColor[0.534026, 0.420729, 0.705621], "ca" -> 
           RGBColor[0.480072, 0.744591, 0.0955222], "sc" -> 
           RGBColor[0.901961, 0.901961, 0.901961], "ti" -> 
           RGBColor[0.74902, 0.760784, 0.780392], "v" -> 
           RGBColor[0.65098, 0.65098, 0.670588], "cr" -> 
           RGBColor[0.541176, 0.6, 0.780392], "mn" -> 
           RGBColor[0.611765, 0.478431, 0.780392], "fe" -> 
           RGBColor[0.878431, 0.4, 0.2], "co" -> 
           RGBColor[0.941176, 0.564706, 0.627451], "ni" -> 
           RGBColor[0.313725, 0.815686, 0.313725], "cu" -> 
           RGBColor[0.784314, 0.501961, 0.2], "zn" -> 
           RGBColor[0.490196, 0.501961, 0.690196], "ga" -> 
           RGBColor[0.800757, 0.542666, 0.533513], "ge" -> 
           RGBColor[0.60508, 0.632465, 0.576489], "as" -> 
           RGBColor[0.741176, 0.501961, 0.890196], "se" -> 
           RGBColor[0.917248, 0.657833, 0.0706628], "br" -> 
           RGBColor[0.58847, 0.22163, 0.16064], "kr" -> 
           RGBColor[0.426019, 0.747462, 0.810413], "rb" -> 
           RGBColor[0.425391, 0.329242, 0.585895], "sr" -> 
           RGBColor[0.325959, 0.646423, 0.095983], "y" -> 
           RGBColor[0.531014, 1., 1.], "zr" -> 
           RGBColor[0.458599, 0.917466, 0.918573], "nb" -> 
           RGBColor[0.385036, 0.834854, 0.841681], "mo" -> 
           RGBColor[0.310325, 0.752163, 0.769323], "tc" -> 
           RGBColor[0.234466, 0.669394, 0.701499], "ru" -> 
           RGBColor[0.157459, 0.586546, 0.638209], "rh" -> 
           RGBColor[0.0793033, 0.50362, 0.579453], "pd" -> 
           RGBColor[0., 0.420615, 0.525231], "ag" -> 
           RGBColor[0.752941, 0.752941, 0.752941], "cd" -> 
           RGBColor[1., 0.85098, 0.560784], "in" -> 
           RGBColor[0.728371, 0.440594, 0.422196], "sn" -> 
           RGBColor[0.39799, 0.491477, 0.495586], "sb" -> 
           RGBColor[0.619608, 0.388235, 0.709804], "te" -> 
           RGBColor[0.816706, 0.451332, 0.0100947], "i" -> 
           RGBColor[0.580392, 0, 0.580392], "xe" -> 
           RGBColor[0.316906, 0.638078, 0.710252], "cs" -> 
           RGBColor[0.332803, 0.217712, 0.483666], "ba" -> 
           RGBColor[0.165935, 0.55605, 0.0796556], "la" -> 
           RGBColor[0.928084, 0.716075, 0.329427], "ce" -> 
           RGBColor[0.894824, 0.731424, 0.325131], "pr" -> 
           RGBColor[0.86523, 0.707999, 0.315261], "nd" -> 
           RGBColor[0.837836, 0.662974, 0.301635], "pm" -> 
           RGBColor[0.811992, 0.607859, 0.285626], "sm" -> 
           RGBColor[0.787563, 0.549894, 0.268279], "eu" -> 
           RGBColor[0.764628, 0.493261, 0.250405], "gd" -> 
           RGBColor[0.743177, 0.440115, 0.23269], "tb" -> 
           RGBColor[0.72281, 0.39143, 0.215783], "dy" -> 
           RGBColor[0.702434, 0.347663, 0.200392], "ho" -> 
           RGBColor[0.679962, 0.309234, 0.187368], "er" -> 
           RGBColor[0.652012, 0.276823, 0.17779], "tm" -> 
           RGBColor[0.613603, 0.251489, 0.173042], "yb" -> 
           RGBColor[0.557855, 0.234598, 0.17489], "lu" -> 
           RGBColor[0.475685, 0.227573, 0.18555], "hf" -> 
           RGBColor[0.781537, 0.717388, 0.716579], "ta" -> 
           RGBColor[0.734443, 0.544489, 0.683471], "w" -> 
           RGBColor[0.681179, 0.360409, 0.63675], "re" -> 
           RGBColor[0.605181, 0.367584, 0.556343], "os" -> 
           RGBColor[0.521806, 0.382125, 0.469204], "ir" -> 
           RGBColor[0.445624, 0.373159, 0.399069], "pt" -> 
           RGBColor[0.815686, 0.815686, 0.878431], "au" -> 
           RGBColor[1., 0.819608, 0.137255], "hg" -> 
           RGBColor[0.721569, 0.721569, 0.815686], "tl" -> 
           RGBColor[0.65098, 0.329412, 0.301961], "pb" -> 
           RGBColor[0.341176, 0.34902, 0.380392], "bi" -> 
           RGBColor[0.619608, 0.309804, 0.709804], "po" -> 
           RGBColor[0.670588, 0.360784, 0], "at" -> 
           RGBColor[0.458824, 0.309804, 0.270588], "rn" -> 
           RGBColor[0.218799, 0.516091, 0.591608], "fr" -> 
           RGBColor[0.25626, 0.0861372, 0.398932], "ra" -> 
           RGBColor[0., 0.473472, 0.04654], "ac" -> 
           RGBColor[0.322042, 0.71693, 0.988479], "th" -> 
           RGBColor[0.3608, 0.67166, 0.943003], "pa" -> 
           RGBColor[0.397469, 0.628, 0.898853], "u" -> 
           RGBColor[0.43205, 0.58595, 0.856029], "np" -> 
           RGBColor[0.464542, 0.54551, 0.814532], "pu" -> 
           RGBColor[0.494945, 0.506679, 0.774361], "am" -> 
           RGBColor[0.52326, 0.469458, 0.735517], "cm" -> 
           RGBColor[0.549486, 0.433847, 0.697999], "bk" -> 
           RGBColor[0.573624, 0.399845, 0.661808], "cf" -> 
           RGBColor[0.595673, 0.367454, 0.626942], "es" -> 
           RGBColor[0.615633, 0.336672, 0.593404], "fm" -> 
           RGBColor[0.633505, 0.307499, 0.561191], "md" -> 
           RGBColor[0.649288, 0.279937, 0.530305], "no" -> 
           RGBColor[0.662982, 0.253984, 0.500746], "lr" -> 
           RGBColor[0.674588, 0.22964, 0.472513], "rf" -> 
           RGBColor[0.684106, 0.206907, 0.445606], "db" -> 
           RGBColor[0.691534, 0.185783, 0.420025], "sg" -> 
           RGBColor[0.696874, 0.166269, 0.395772], "bh" -> 
           RGBColor[0.700126, 0.148365, 0.372844], "hs" -> 
           RGBColor[0.701289, 0.13207, 0.351243], "mt" -> 
           RGBColor[0.700363, 0.117385, 0.330968], "ds" -> 
           RGBColor[0.697348, 0.10431, 0.31202], "rg" -> 
           RGBColor[0.692245, 0.0928444, 0.294398], "cn" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "nh" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "fl" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "mc" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "lv" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "ts" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "og" -> 
           RGBColor[0.635401, 0.0528, 0.226184], "uub" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "uut" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "uuq" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "uup" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "uuh" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "uus" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "uuo" -> 
           RGBColor[0.635401, 0.0528, 0.226184]}]]& ][0.85], 
       ColorDataFunction[
       "Atoms", 
        "Named", {{
         "H", "He", "Li", "Be", "B", "C", "N", "O", "F", "Ne", "Na", "Mg", 
          "Al", "Si", "P", "S", "Cl", "Ar", "K", "Ca", "Sc", "Ti", "V", "Cr", 
          "Mn", "Fe", "Co", "Ni", "Cu", "Zn", "Ga", "Ge", "As", "Se", "Br", 
          "Kr", "Rb", "Sr", "Y", "Zr", "Nb", "Mo", "Tc", "Ru", "Rh", "Pd", 
          "Ag", "Cd", "In", "Sn", "Sb", "Te", "I", "Xe", "Cs", "Ba", "La", 
          "Ce", "Pr", "Nd", "Pm", "Sm", "Eu", "Gd", "Tb", "Dy", "Ho", "Er", 
          "Tm", "Yb", "Lu", "Hf", "Ta", "W", "Re", "Os", "Ir", "Pt", "Au", 
          "Hg", "Tl", "Pb", "Bi", "Po", "At", "Rn", "Fr", "Ra", "Ac", "Th", 
          "Pa", "U", "Np", "Pu", "Am", "Cm", "Bk", "Cf", "Es", "Fm", "Md", 
          "No", "Lr", "Rf", "Db", "Sg", "Bh", "Hs", "Mt", "Ds", "Rg", "Cn", 
          "Nh", "Fl", "Mc", "Lv", "Ts", "Og", "Uub", "Uut", "Uuq", "Uup", 
          "Uuh", "Uus", "Uuo"}, {
         "h", "he", "li", "be", "b", "c", "n", "o", "f", "ne", "na", "mg", 
          "al", "si", "p", "s", "cl", "ar", "k", "ca", "sc", "ti", "v", "cr", 
          "mn", "fe", "co", "ni", "cu", "zn", "ga", "ge", "as", "se", "br", 
          "kr", "rb", "sr", "y", "zr", "nb", "mo", "tc", "ru", "rh", "pd", 
          "ag", "cd", "in", "sn", "sb", "te", "i", "xe", "cs", "ba", "la", 
          "ce", "pr", "nd", "pm", "sm", "eu", "gd", "tb", "dy", "ho", "er", 
          "tm", "yb", "lu", "hf", "ta", "w", "re", "os", "ir", "pt", "au", 
          "hg", "tl", "pb", "bi", "po", "at", "rn", "fr", "ra", "ac", "th", 
          "pa", "u", "np", "pu", "am", "cm", "bk", "cf", "es", "fm", "md", 
          "no", "lr", "rf", "db", "sg", "bh", "hs", "mt", "ds", "rg", "cn", 
          "nh", "fl", "mc", "lv", "ts", "og", "uub", "uut", "uuq", "uup", 
          "uuh", "uus", "uuo"}}, Replace[#, 
         Dispatch[{
          "h" -> RGBColor[0.65, 0.7, 0.7], "he" -> RGBColor[0.836713, 1., 1.],
            "li" -> RGBColor[0.799435, 0.543572, 0.997559], "be" -> 
           RGBColor[0.770565, 0.964309, 0.0442359], "b" -> 
           RGBColor[1., 0.709804, 0.709804], "c" -> RGBColor[0.4, 0.4, 0.4], 
           "n" -> RGBColor[0.291989, 0.437977, 0.888609], "o" -> 
           RGBColor[0.800498, 0.201504, 0.192061], "f" -> 
           RGBColor[0.578462, 0.85539, 0.408855], "ne" -> 
           RGBColor[0.677263, 0.928423, 0.955287], "na" -> 
           RGBColor[0.658708, 0.492173, 0.842842], "mg" -> 
           RGBColor[0.628274, 0.850553, 0.0782731], "al" -> 
           RGBColor[0.8913, 0.631904, 0.627399], "si" -> 
           RGBColor[0.941176, 0.784314, 0.627451], "p" -> 
           RGBColor[1., 0.501961, 0], "s" -> 
           RGBColor[0.90443, 0.97015, 0.13504], "cl" -> 
           RGBColor[0.412698, 0.932689, 0.166398], "ar" -> 
           RGBColor[0.546138, 0.844244, 0.892092], "k" -> 
           RGBColor[0.534026, 0.420729, 0.705621], "ca" -> 
           RGBColor[0.480072, 0.744591, 0.0955222], "sc" -> 
           RGBColor[0.901961, 0.901961, 0.901961], "ti" -> 
           RGBColor[0.74902, 0.760784, 0.780392], "v" -> 
           RGBColor[0.65098, 0.65098, 0.670588], "cr" -> 
           RGBColor[0.541176, 0.6, 0.780392], "mn" -> 
           RGBColor[0.611765, 0.478431, 0.780392], "fe" -> 
           RGBColor[0.878431, 0.4, 0.2], "co" -> 
           RGBColor[0.941176, 0.564706, 0.627451], "ni" -> 
           RGBColor[0.313725, 0.815686, 0.313725], "cu" -> 
           RGBColor[0.784314, 0.501961, 0.2], "zn" -> 
           RGBColor[0.490196, 0.501961, 0.690196], "ga" -> 
           RGBColor[0.800757, 0.542666, 0.533513], "ge" -> 
           RGBColor[0.60508, 0.632465, 0.576489], "as" -> 
           RGBColor[0.741176, 0.501961, 0.890196], "se" -> 
           RGBColor[0.917248, 0.657833, 0.0706628], "br" -> 
           RGBColor[0.58847, 0.22163, 0.16064], "kr" -> 
           RGBColor[0.426019, 0.747462, 0.810413], "rb" -> 
           RGBColor[0.425391, 0.329242, 0.585895], "sr" -> 
           RGBColor[0.325959, 0.646423, 0.095983], "y" -> 
           RGBColor[0.531014, 1., 1.], "zr" -> 
           RGBColor[0.458599, 0.917466, 0.918573], "nb" -> 
           RGBColor[0.385036, 0.834854, 0.841681], "mo" -> 
           RGBColor[0.310325, 0.752163, 0.769323], "tc" -> 
           RGBColor[0.234466, 0.669394, 0.701499], "ru" -> 
           RGBColor[0.157459, 0.586546, 0.638209], "rh" -> 
           RGBColor[0.0793033, 0.50362, 0.579453], "pd" -> 
           RGBColor[0., 0.420615, 0.525231], "ag" -> 
           RGBColor[0.752941, 0.752941, 0.752941], "cd" -> 
           RGBColor[1., 0.85098, 0.560784], "in" -> 
           RGBColor[0.728371, 0.440594, 0.422196], "sn" -> 
           RGBColor[0.39799, 0.491477, 0.495586], "sb" -> 
           RGBColor[0.619608, 0.388235, 0.709804], "te" -> 
           RGBColor[0.816706, 0.451332, 0.0100947], "i" -> 
           RGBColor[0.580392, 0, 0.580392], "xe" -> 
           RGBColor[0.316906, 0.638078, 0.710252], "cs" -> 
           RGBColor[0.332803, 0.217712, 0.483666], "ba" -> 
           RGBColor[0.165935, 0.55605, 0.0796556], "la" -> 
           RGBColor[0.928084, 0.716075, 0.329427], "ce" -> 
           RGBColor[0.894824, 0.731424, 0.325131], "pr" -> 
           RGBColor[0.86523, 0.707999, 0.315261], "nd" -> 
           RGBColor[0.837836, 0.662974, 0.301635], "pm" -> 
           RGBColor[0.811992, 0.607859, 0.285626], "sm" -> 
           RGBColor[0.787563, 0.549894, 0.268279], "eu" -> 
           RGBColor[0.764628, 0.493261, 0.250405], "gd" -> 
           RGBColor[0.743177, 0.440115, 0.23269], "tb" -> 
           RGBColor[0.72281, 0.39143, 0.215783], "dy" -> 
           RGBColor[0.702434, 0.347663, 0.200392], "ho" -> 
           RGBColor[0.679962, 0.309234, 0.187368], "er" -> 
           RGBColor[0.652012, 0.276823, 0.17779], "tm" -> 
           RGBColor[0.613603, 0.251489, 0.173042], "yb" -> 
           RGBColor[0.557855, 0.234598, 0.17489], "lu" -> 
           RGBColor[0.475685, 0.227573, 0.18555], "hf" -> 
           RGBColor[0.781537, 0.717388, 0.716579], "ta" -> 
           RGBColor[0.734443, 0.544489, 0.683471], "w" -> 
           RGBColor[0.681179, 0.360409, 0.63675], "re" -> 
           RGBColor[0.605181, 0.367584, 0.556343], "os" -> 
           RGBColor[0.521806, 0.382125, 0.469204], "ir" -> 
           RGBColor[0.445624, 0.373159, 0.399069], "pt" -> 
           RGBColor[0.815686, 0.815686, 0.878431], "au" -> 
           RGBColor[1., 0.819608, 0.137255], "hg" -> 
           RGBColor[0.721569, 0.721569, 0.815686], "tl" -> 
           RGBColor[0.65098, 0.329412, 0.301961], "pb" -> 
           RGBColor[0.341176, 0.34902, 0.380392], "bi" -> 
           RGBColor[0.619608, 0.309804, 0.709804], "po" -> 
           RGBColor[0.670588, 0.360784, 0], "at" -> 
           RGBColor[0.458824, 0.309804, 0.270588], "rn" -> 
           RGBColor[0.218799, 0.516091, 0.591608], "fr" -> 
           RGBColor[0.25626, 0.0861372, 0.398932], "ra" -> 
           RGBColor[0., 0.473472, 0.04654], "ac" -> 
           RGBColor[0.322042, 0.71693, 0.988479], "th" -> 
           RGBColor[0.3608, 0.67166, 0.943003], "pa" -> 
           RGBColor[0.397469, 0.628, 0.898853], "u" -> 
           RGBColor[0.43205, 0.58595, 0.856029], "np" -> 
           RGBColor[0.464542, 0.54551, 0.814532], "pu" -> 
           RGBColor[0.494945, 0.506679, 0.774361], "am" -> 
           RGBColor[0.52326, 0.469458, 0.735517], "cm" -> 
           RGBColor[0.549486, 0.433847, 0.697999], "bk" -> 
           RGBColor[0.573624, 0.399845, 0.661808], "cf" -> 
           RGBColor[0.595673, 0.367454, 0.626942], "es" -> 
           RGBColor[0.615633, 0.336672, 0.593404], "fm" -> 
           RGBColor[0.633505, 0.307499, 0.561191], "md" -> 
           RGBColor[0.649288, 0.279937, 0.530305], "no" -> 
           RGBColor[0.662982, 0.253984, 0.500746], "lr" -> 
           RGBColor[0.674588, 0.22964, 0.472513], "rf" -> 
           RGBColor[0.684106, 0.206907, 0.445606], "db" -> 
           RGBColor[0.691534, 0.185783, 0.420025], "sg" -> 
           RGBColor[0.696874, 0.166269, 0.395772], "bh" -> 
           RGBColor[0.700126, 0.148365, 0.372844], "hs" -> 
           RGBColor[0.701289, 0.13207, 0.351243], "mt" -> 
           RGBColor[0.700363, 0.117385, 0.330968], "ds" -> 
           RGBColor[0.697348, 0.10431, 0.31202], "rg" -> 
           RGBColor[0.692245, 0.0928444, 0.294398], "cn" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "nh" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "fl" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "mc" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "lv" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "ts" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "og" -> 
           RGBColor[0.635401, 0.0528, 0.226184], "uub" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "uut" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "uuq" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "uup" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "uuh" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "uus" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "uuo" -> 
           RGBColor[0.635401, 0.0528, 0.226184]}]]& ][0.85], 
       ColorDataFunction[
       "Atoms", 
        "Named", {{
         "H", "He", "Li", "Be", "B", "C", "N", "O", "F", "Ne", "Na", "Mg", 
          "Al", "Si", "P", "S", "Cl", "Ar", "K", "Ca", "Sc", "Ti", "V", "Cr", 
          "Mn", "Fe", "Co", "Ni", "Cu", "Zn", "Ga", "Ge", "As", "Se", "Br", 
          "Kr", "Rb", "Sr", "Y", "Zr", "Nb", "Mo", "Tc", "Ru", "Rh", "Pd", 
          "Ag", "Cd", "In", "Sn", "Sb", "Te", "I", "Xe", "Cs", "Ba", "La", 
          "Ce", "Pr", "Nd", "Pm", "Sm", "Eu", "Gd", "Tb", "Dy", "Ho", "Er", 
          "Tm", "Yb", "Lu", "Hf", "Ta", "W", "Re", "Os", "Ir", "Pt", "Au", 
          "Hg", "Tl", "Pb", "Bi", "Po", "At", "Rn", "Fr", "Ra", "Ac", "Th", 
          "Pa", "U", "Np", "Pu", "Am", "Cm", "Bk", "Cf", "Es", "Fm", "Md", 
          "No", "Lr", "Rf", "Db", "Sg", "Bh", "Hs", "Mt", "Ds", "Rg", "Cn", 
          "Nh", "Fl", "Mc", "Lv", "Ts", "Og", "Uub", "Uut", "Uuq", "Uup", 
          "Uuh", "Uus", "Uuo"}, {
         "h", "he", "li", "be", "b", "c", "n", "o", "f", "ne", "na", "mg", 
          "al", "si", "p", "s", "cl", "ar", "k", "ca", "sc", "ti", "v", "cr", 
          "mn", "fe", "co", "ni", "cu", "zn", "ga", "ge", "as", "se", "br", 
          "kr", "rb", "sr", "y", "zr", "nb", "mo", "tc", "ru", "rh", "pd", 
          "ag", "cd", "in", "sn", "sb", "te", "i", "xe", "cs", "ba", "la", 
          "ce", "pr", "nd", "pm", "sm", "eu", "gd", "tb", "dy", "ho", "er", 
          "tm", "yb", "lu", "hf", "ta", "w", "re", "os", "ir", "pt", "au", 
          "hg", "tl", "pb", "bi", "po", "at", "rn", "fr", "ra", "ac", "th", 
          "pa", "u", "np", "pu", "am", "cm", "bk", "cf", "es", "fm", "md", 
          "no", "lr", "rf", "db", "sg", "bh", "hs", "mt", "ds", "rg", "cn", 
          "nh", "fl", "mc", "lv", "ts", "og", "uub", "uut", "uuq", "uup", 
          "uuh", "uus", "uuo"}}, Replace[#, 
         Dispatch[{
          "h" -> RGBColor[0.65, 0.7, 0.7], "he" -> RGBColor[0.836713, 1., 1.],
            "li" -> RGBColor[0.799435, 0.543572, 0.997559], "be" -> 
           RGBColor[0.770565, 0.964309, 0.0442359], "b" -> 
           RGBColor[1., 0.709804, 0.709804], "c" -> RGBColor[0.4, 0.4, 0.4], 
           "n" -> RGBColor[0.291989, 0.437977, 0.888609], "o" -> 
           RGBColor[0.800498, 0.201504, 0.192061], "f" -> 
           RGBColor[0.578462, 0.85539, 0.408855], "ne" -> 
           RGBColor[0.677263, 0.928423, 0.955287], "na" -> 
           RGBColor[0.658708, 0.492173, 0.842842], "mg" -> 
           RGBColor[0.628274, 0.850553, 0.0782731], "al" -> 
           RGBColor[0.8913, 0.631904, 0.627399], "si" -> 
           RGBColor[0.941176, 0.784314, 0.627451], "p" -> 
           RGBColor[1., 0.501961, 0], "s" -> 
           RGBColor[0.90443, 0.97015, 0.13504], "cl" -> 
           RGBColor[0.412698, 0.932689, 0.166398], "ar" -> 
           RGBColor[0.546138, 0.844244, 0.892092], "k" -> 
           RGBColor[0.534026, 0.420729, 0.705621], "ca" -> 
           RGBColor[0.480072, 0.744591, 0.0955222], "sc" -> 
           RGBColor[0.901961, 0.901961, 0.901961], "ti" -> 
           RGBColor[0.74902, 0.760784, 0.780392], "v" -> 
           RGBColor[0.65098, 0.65098, 0.670588], "cr" -> 
           RGBColor[0.541176, 0.6, 0.780392], "mn" -> 
           RGBColor[0.611765, 0.478431, 0.780392], "fe" -> 
           RGBColor[0.878431, 0.4, 0.2], "co" -> 
           RGBColor[0.941176, 0.564706, 0.627451], "ni" -> 
           RGBColor[0.313725, 0.815686, 0.313725], "cu" -> 
           RGBColor[0.784314, 0.501961, 0.2], "zn" -> 
           RGBColor[0.490196, 0.501961, 0.690196], "ga" -> 
           RGBColor[0.800757, 0.542666, 0.533513], "ge" -> 
           RGBColor[0.60508, 0.632465, 0.576489], "as" -> 
           RGBColor[0.741176, 0.501961, 0.890196], "se" -> 
           RGBColor[0.917248, 0.657833, 0.0706628], "br" -> 
           RGBColor[0.58847, 0.22163, 0.16064], "kr" -> 
           RGBColor[0.426019, 0.747462, 0.810413], "rb" -> 
           RGBColor[0.425391, 0.329242, 0.585895], "sr" -> 
           RGBColor[0.325959, 0.646423, 0.095983], "y" -> 
           RGBColor[0.531014, 1., 1.], "zr" -> 
           RGBColor[0.458599, 0.917466, 0.918573], "nb" -> 
           RGBColor[0.385036, 0.834854, 0.841681], "mo" -> 
           RGBColor[0.310325, 0.752163, 0.769323], "tc" -> 
           RGBColor[0.234466, 0.669394, 0.701499], "ru" -> 
           RGBColor[0.157459, 0.586546, 0.638209], "rh" -> 
           RGBColor[0.0793033, 0.50362, 0.579453], "pd" -> 
           RGBColor[0., 0.420615, 0.525231], "ag" -> 
           RGBColor[0.752941, 0.752941, 0.752941], "cd" -> 
           RGBColor[1., 0.85098, 0.560784], "in" -> 
           RGBColor[0.728371, 0.440594, 0.422196], "sn" -> 
           RGBColor[0.39799, 0.491477, 0.495586], "sb" -> 
           RGBColor[0.619608, 0.388235, 0.709804], "te" -> 
           RGBColor[0.816706, 0.451332, 0.0100947], "i" -> 
           RGBColor[0.580392, 0, 0.580392], "xe" -> 
           RGBColor[0.316906, 0.638078, 0.710252], "cs" -> 
           RGBColor[0.332803, 0.217712, 0.483666], "ba" -> 
           RGBColor[0.165935, 0.55605, 0.0796556], "la" -> 
           RGBColor[0.928084, 0.716075, 0.329427], "ce" -> 
           RGBColor[0.894824, 0.731424, 0.325131], "pr" -> 
           RGBColor[0.86523, 0.707999, 0.315261], "nd" -> 
           RGBColor[0.837836, 0.662974, 0.301635], "pm" -> 
           RGBColor[0.811992, 0.607859, 0.285626], "sm" -> 
           RGBColor[0.787563, 0.549894, 0.268279], "eu" -> 
           RGBColor[0.764628, 0.493261, 0.250405], "gd" -> 
           RGBColor[0.743177, 0.440115, 0.23269], "tb" -> 
           RGBColor[0.72281, 0.39143, 0.215783], "dy" -> 
           RGBColor[0.702434, 0.347663, 0.200392], "ho" -> 
           RGBColor[0.679962, 0.309234, 0.187368], "er" -> 
           RGBColor[0.652012, 0.276823, 0.17779], "tm" -> 
           RGBColor[0.613603, 0.251489, 0.173042], "yb" -> 
           RGBColor[0.557855, 0.234598, 0.17489], "lu" -> 
           RGBColor[0.475685, 0.227573, 0.18555], "hf" -> 
           RGBColor[0.781537, 0.717388, 0.716579], "ta" -> 
           RGBColor[0.734443, 0.544489, 0.683471], "w" -> 
           RGBColor[0.681179, 0.360409, 0.63675], "re" -> 
           RGBColor[0.605181, 0.367584, 0.556343], "os" -> 
           RGBColor[0.521806, 0.382125, 0.469204], "ir" -> 
           RGBColor[0.445624, 0.373159, 0.399069], "pt" -> 
           RGBColor[0.815686, 0.815686, 0.878431], "au" -> 
           RGBColor[1., 0.819608, 0.137255], "hg" -> 
           RGBColor[0.721569, 0.721569, 0.815686], "tl" -> 
           RGBColor[0.65098, 0.329412, 0.301961], "pb" -> 
           RGBColor[0.341176, 0.34902, 0.380392], "bi" -> 
           RGBColor[0.619608, 0.309804, 0.709804], "po" -> 
           RGBColor[0.670588, 0.360784, 0], "at" -> 
           RGBColor[0.458824, 0.309804, 0.270588], "rn" -> 
           RGBColor[0.218799, 0.516091, 0.591608], "fr" -> 
           RGBColor[0.25626, 0.0861372, 0.398932], "ra" -> 
           RGBColor[0., 0.473472, 0.04654], "ac" -> 
           RGBColor[0.322042, 0.71693, 0.988479], "th" -> 
           RGBColor[0.3608, 0.67166, 0.943003], "pa" -> 
           RGBColor[0.397469, 0.628, 0.898853], "u" -> 
           RGBColor[0.43205, 0.58595, 0.856029], "np" -> 
           RGBColor[0.464542, 0.54551, 0.814532], "pu" -> 
           RGBColor[0.494945, 0.506679, 0.774361], "am" -> 
           RGBColor[0.52326, 0.469458, 0.735517], "cm" -> 
           RGBColor[0.549486, 0.433847, 0.697999], "bk" -> 
           RGBColor[0.573624, 0.399845, 0.661808], "cf" -> 
           RGBColor[0.595673, 0.367454, 0.626942], "es" -> 
           RGBColor[0.615633, 0.336672, 0.593404], "fm" -> 
           RGBColor[0.633505, 0.307499, 0.561191], "md" -> 
           RGBColor[0.649288, 0.279937, 0.530305], "no" -> 
           RGBColor[0.662982, 0.253984, 0.500746], "lr" -> 
           RGBColor[0.674588, 0.22964, 0.472513], "rf" -> 
           RGBColor[0.684106, 0.206907, 0.445606], "db" -> 
           RGBColor[0.691534, 0.185783, 0.420025], "sg" -> 
           RGBColor[0.696874, 0.166269, 0.395772], "bh" -> 
           RGBColor[0.700126, 0.148365, 0.372844], "hs" -> 
           RGBColor[0.701289, 0.13207, 0.351243], "mt" -> 
           RGBColor[0.700363, 0.117385, 0.330968], "ds" -> 
           RGBColor[0.697348, 0.10431, 0.31202], "rg" -> 
           RGBColor[0.692245, 0.0928444, 0.294398], "cn" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "nh" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "fl" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "mc" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "lv" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "ts" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "og" -> 
           RGBColor[0.635401, 0.0528, 0.226184], "uub" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "uut" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "uuq" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "uup" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "uuh" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "uus" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "uuo" -> 
           RGBColor[0.635401, 0.0528, 0.226184]}]]& ][0.85], 
       ColorDataFunction[
       "Atoms", 
        "Named", {{
         "H", "He", "Li", "Be", "B", "C", "N", "O", "F", "Ne", "Na", "Mg", 
          "Al", "Si", "P", "S", "Cl", "Ar", "K", "Ca", "Sc", "Ti", "V", "Cr", 
          "Mn", "Fe", "Co", "Ni", "Cu", "Zn", "Ga", "Ge", "As", "Se", "Br", 
          "Kr", "Rb", "Sr", "Y", "Zr", "Nb", "Mo", "Tc", "Ru", "Rh", "Pd", 
          "Ag", "Cd", "In", "Sn", "Sb", "Te", "I", "Xe", "Cs", "Ba", "La", 
          "Ce", "Pr", "Nd", "Pm", "Sm", "Eu", "Gd", "Tb", "Dy", "Ho", "Er", 
          "Tm", "Yb", "Lu", "Hf", "Ta", "W", "Re", "Os", "Ir", "Pt", "Au", 
          "Hg", "Tl", "Pb", "Bi", "Po", "At", "Rn", "Fr", "Ra", "Ac", "Th", 
          "Pa", "U", "Np", "Pu", "Am", "Cm", "Bk", "Cf", "Es", "Fm", "Md", 
          "No", "Lr", "Rf", "Db", "Sg", "Bh", "Hs", "Mt", "Ds", "Rg", "Cn", 
          "Nh", "Fl", "Mc", "Lv", "Ts", "Og", "Uub", "Uut", "Uuq", "Uup", 
          "Uuh", "Uus", "Uuo"}, {
         "h", "he", "li", "be", "b", "c", "n", "o", "f", "ne", "na", "mg", 
          "al", "si", "p", "s", "cl", "ar", "k", "ca", "sc", "ti", "v", "cr", 
          "mn", "fe", "co", "ni", "cu", "zn", "ga", "ge", "as", "se", "br", 
          "kr", "rb", "sr", "y", "zr", "nb", "mo", "tc", "ru", "rh", "pd", 
          "ag", "cd", "in", "sn", "sb", "te", "i", "xe", "cs", "ba", "la", 
          "ce", "pr", "nd", "pm", "sm", "eu", "gd", "tb", "dy", "ho", "er", 
          "tm", "yb", "lu", "hf", "ta", "w", "re", "os", "ir", "pt", "au", 
          "hg", "tl", "pb", "bi", "po", "at", "rn", "fr", "ra", "ac", "th", 
          "pa", "u", "np", "pu", "am", "cm", "bk", "cf", "es", "fm", "md", 
          "no", "lr", "rf", "db", "sg", "bh", "hs", "mt", "ds", "rg", "cn", 
          "nh", "fl", "mc", "lv", "ts", "og", "uub", "uut", "uuq", "uup", 
          "uuh", "uus", "uuo"}}, Replace[#, 
         Dispatch[{
          "h" -> RGBColor[0.65, 0.7, 0.7], "he" -> RGBColor[0.836713, 1., 1.],
            "li" -> RGBColor[0.799435, 0.543572, 0.997559], "be" -> 
           RGBColor[0.770565, 0.964309, 0.0442359], "b" -> 
           RGBColor[1., 0.709804, 0.709804], "c" -> RGBColor[0.4, 0.4, 0.4], 
           "n" -> RGBColor[0.291989, 0.437977, 0.888609], "o" -> 
           RGBColor[0.800498, 0.201504, 0.192061], "f" -> 
           RGBColor[0.578462, 0.85539, 0.408855], "ne" -> 
           RGBColor[0.677263, 0.928423, 0.955287], "na" -> 
           RGBColor[0.658708, 0.492173, 0.842842], "mg" -> 
           RGBColor[0.628274, 0.850553, 0.0782731], "al" -> 
           RGBColor[0.8913, 0.631904, 0.627399], "si" -> 
           RGBColor[0.941176, 0.784314, 0.627451], "p" -> 
           RGBColor[1., 0.501961, 0], "s" -> 
           RGBColor[0.90443, 0.97015, 0.13504], "cl" -> 
           RGBColor[0.412698, 0.932689, 0.166398], "ar" -> 
           RGBColor[0.546138, 0.844244, 0.892092], "k" -> 
           RGBColor[0.534026, 0.420729, 0.705621], "ca" -> 
           RGBColor[0.480072, 0.744591, 0.0955222], "sc" -> 
           RGBColor[0.901961, 0.901961, 0.901961], "ti" -> 
           RGBColor[0.74902, 0.760784, 0.780392], "v" -> 
           RGBColor[0.65098, 0.65098, 0.670588], "cr" -> 
           RGBColor[0.541176, 0.6, 0.780392], "mn" -> 
           RGBColor[0.611765, 0.478431, 0.780392], "fe" -> 
           RGBColor[0.878431, 0.4, 0.2], "co" -> 
           RGBColor[0.941176, 0.564706, 0.627451], "ni" -> 
           RGBColor[0.313725, 0.815686, 0.313725], "cu" -> 
           RGBColor[0.784314, 0.501961, 0.2], "zn" -> 
           RGBColor[0.490196, 0.501961, 0.690196], "ga" -> 
           RGBColor[0.800757, 0.542666, 0.533513], "ge" -> 
           RGBColor[0.60508, 0.632465, 0.576489], "as" -> 
           RGBColor[0.741176, 0.501961, 0.890196], "se" -> 
           RGBColor[0.917248, 0.657833, 0.0706628], "br" -> 
           RGBColor[0.58847, 0.22163, 0.16064], "kr" -> 
           RGBColor[0.426019, 0.747462, 0.810413], "rb" -> 
           RGBColor[0.425391, 0.329242, 0.585895], "sr" -> 
           RGBColor[0.325959, 0.646423, 0.095983], "y" -> 
           RGBColor[0.531014, 1., 1.], "zr" -> 
           RGBColor[0.458599, 0.917466, 0.918573], "nb" -> 
           RGBColor[0.385036, 0.834854, 0.841681], "mo" -> 
           RGBColor[0.310325, 0.752163, 0.769323], "tc" -> 
           RGBColor[0.234466, 0.669394, 0.701499], "ru" -> 
           RGBColor[0.157459, 0.586546, 0.638209], "rh" -> 
           RGBColor[0.0793033, 0.50362, 0.579453], "pd" -> 
           RGBColor[0., 0.420615, 0.525231], "ag" -> 
           RGBColor[0.752941, 0.752941, 0.752941], "cd" -> 
           RGBColor[1., 0.85098, 0.560784], "in" -> 
           RGBColor[0.728371, 0.440594, 0.422196], "sn" -> 
           RGBColor[0.39799, 0.491477, 0.495586], "sb" -> 
           RGBColor[0.619608, 0.388235, 0.709804], "te" -> 
           RGBColor[0.816706, 0.451332, 0.0100947], "i" -> 
           RGBColor[0.580392, 0, 0.580392], "xe" -> 
           RGBColor[0.316906, 0.638078, 0.710252], "cs" -> 
           RGBColor[0.332803, 0.217712, 0.483666], "ba" -> 
           RGBColor[0.165935, 0.55605, 0.0796556], "la" -> 
           RGBColor[0.928084, 0.716075, 0.329427], "ce" -> 
           RGBColor[0.894824, 0.731424, 0.325131], "pr" -> 
           RGBColor[0.86523, 0.707999, 0.315261], "nd" -> 
           RGBColor[0.837836, 0.662974, 0.301635], "pm" -> 
           RGBColor[0.811992, 0.607859, 0.285626], "sm" -> 
           RGBColor[0.787563, 0.549894, 0.268279], "eu" -> 
           RGBColor[0.764628, 0.493261, 0.250405], "gd" -> 
           RGBColor[0.743177, 0.440115, 0.23269], "tb" -> 
           RGBColor[0.72281, 0.39143, 0.215783], "dy" -> 
           RGBColor[0.702434, 0.347663, 0.200392], "ho" -> 
           RGBColor[0.679962, 0.309234, 0.187368], "er" -> 
           RGBColor[0.652012, 0.276823, 0.17779], "tm" -> 
           RGBColor[0.613603, 0.251489, 0.173042], "yb" -> 
           RGBColor[0.557855, 0.234598, 0.17489], "lu" -> 
           RGBColor[0.475685, 0.227573, 0.18555], "hf" -> 
           RGBColor[0.781537, 0.717388, 0.716579], "ta" -> 
           RGBColor[0.734443, 0.544489, 0.683471], "w" -> 
           RGBColor[0.681179, 0.360409, 0.63675], "re" -> 
           RGBColor[0.605181, 0.367584, 0.556343], "os" -> 
           RGBColor[0.521806, 0.382125, 0.469204], "ir" -> 
           RGBColor[0.445624, 0.373159, 0.399069], "pt" -> 
           RGBColor[0.815686, 0.815686, 0.878431], "au" -> 
           RGBColor[1., 0.819608, 0.137255], "hg" -> 
           RGBColor[0.721569, 0.721569, 0.815686], "tl" -> 
           RGBColor[0.65098, 0.329412, 0.301961], "pb" -> 
           RGBColor[0.341176, 0.34902, 0.380392], "bi" -> 
           RGBColor[0.619608, 0.309804, 0.709804], "po" -> 
           RGBColor[0.670588, 0.360784, 0], "at" -> 
           RGBColor[0.458824, 0.309804, 0.270588], "rn" -> 
           RGBColor[0.218799, 0.516091, 0.591608], "fr" -> 
           RGBColor[0.25626, 0.0861372, 0.398932], "ra" -> 
           RGBColor[0., 0.473472, 0.04654], "ac" -> 
           RGBColor[0.322042, 0.71693, 0.988479], "th" -> 
           RGBColor[0.3608, 0.67166, 0.943003], "pa" -> 
           RGBColor[0.397469, 0.628, 0.898853], "u" -> 
           RGBColor[0.43205, 0.58595, 0.856029], "np" -> 
           RGBColor[0.464542, 0.54551, 0.814532], "pu" -> 
           RGBColor[0.494945, 0.506679, 0.774361], "am" -> 
           RGBColor[0.52326, 0.469458, 0.735517], "cm" -> 
           RGBColor[0.549486, 0.433847, 0.697999], "bk" -> 
           RGBColor[0.573624, 0.399845, 0.661808], "cf" -> 
           RGBColor[0.595673, 0.367454, 0.626942], "es" -> 
           RGBColor[0.615633, 0.336672, 0.593404], "fm" -> 
           RGBColor[0.633505, 0.307499, 0.561191], "md" -> 
           RGBColor[0.649288, 0.279937, 0.530305], "no" -> 
           RGBColor[0.662982, 0.253984, 0.500746], "lr" -> 
           RGBColor[0.674588, 0.22964, 0.472513], "rf" -> 
           RGBColor[0.684106, 0.206907, 0.445606], "db" -> 
           RGBColor[0.691534, 0.185783, 0.420025], "sg" -> 
           RGBColor[0.696874, 0.166269, 0.395772], "bh" -> 
           RGBColor[0.700126, 0.148365, 0.372844], "hs" -> 
           RGBColor[0.701289, 0.13207, 0.351243], "mt" -> 
           RGBColor[0.700363, 0.117385, 0.330968], "ds" -> 
           RGBColor[0.697348, 0.10431, 0.31202], "rg" -> 
           RGBColor[0.692245, 0.0928444, 0.294398], "cn" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "nh" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "fl" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "mc" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "lv" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "ts" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "og" -> 
           RGBColor[0.635401, 0.0528, 0.226184], "uub" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "uut" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "uuq" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "uup" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "uuh" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "uus" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "uuo" -> 
           RGBColor[0.635401, 0.0528, 0.226184]}]]& ][0.85], 
       ColorDataFunction[
       "Atoms", 
        "Named", {{
         "H", "He", "Li", "Be", "B", "C", "N", "O", "F", "Ne", "Na", "Mg", 
          "Al", "Si", "P", "S", "Cl", "Ar", "K", "Ca", "Sc", "Ti", "V", "Cr", 
          "Mn", "Fe", "Co", "Ni", "Cu", "Zn", "Ga", "Ge", "As", "Se", "Br", 
          "Kr", "Rb", "Sr", "Y", "Zr", "Nb", "Mo", "Tc", "Ru", "Rh", "Pd", 
          "Ag", "Cd", "In", "Sn", "Sb", "Te", "I", "Xe", "Cs", "Ba", "La", 
          "Ce", "Pr", "Nd", "Pm", "Sm", "Eu", "Gd", "Tb", "Dy", "Ho", "Er", 
          "Tm", "Yb", "Lu", "Hf", "Ta", "W", "Re", "Os", "Ir", "Pt", "Au", 
          "Hg", "Tl", "Pb", "Bi", "Po", "At", "Rn", "Fr", "Ra", "Ac", "Th", 
          "Pa", "U", "Np", "Pu", "Am", "Cm", "Bk", "Cf", "Es", "Fm", "Md", 
          "No", "Lr", "Rf", "Db", "Sg", "Bh", "Hs", "Mt", "Ds", "Rg", "Cn", 
          "Nh", "Fl", "Mc", "Lv", "Ts", "Og", "Uub", "Uut", "Uuq", "Uup", 
          "Uuh", "Uus", "Uuo"}, {
         "h", "he", "li", "be", "b", "c", "n", "o", "f", "ne", "na", "mg", 
          "al", "si", "p", "s", "cl", "ar", "k", "ca", "sc", "ti", "v", "cr", 
          "mn", "fe", "co", "ni", "cu", "zn", "ga", "ge", "as", "se", "br", 
          "kr", "rb", "sr", "y", "zr", "nb", "mo", "tc", "ru", "rh", "pd", 
          "ag", "cd", "in", "sn", "sb", "te", "i", "xe", "cs", "ba", "la", 
          "ce", "pr", "nd", "pm", "sm", "eu", "gd", "tb", "dy", "ho", "er", 
          "tm", "yb", "lu", "hf", "ta", "w", "re", "os", "ir", "pt", "au", 
          "hg", "tl", "pb", "bi", "po", "at", "rn", "fr", "ra", "ac", "th", 
          "pa", "u", "np", "pu", "am", "cm", "bk", "cf", "es", "fm", "md", 
          "no", "lr", "rf", "db", "sg", "bh", "hs", "mt", "ds", "rg", "cn", 
          "nh", "fl", "mc", "lv", "ts", "og", "uub", "uut", "uuq", "uup", 
          "uuh", "uus", "uuo"}}, Replace[#, 
         Dispatch[{
          "h" -> RGBColor[0.65, 0.7, 0.7], "he" -> RGBColor[0.836713, 1., 1.],
            "li" -> RGBColor[0.799435, 0.543572, 0.997559], "be" -> 
           RGBColor[0.770565, 0.964309, 0.0442359], "b" -> 
           RGBColor[1., 0.709804, 0.709804], "c" -> RGBColor[0.4, 0.4, 0.4], 
           "n" -> RGBColor[0.291989, 0.437977, 0.888609], "o" -> 
           RGBColor[0.800498, 0.201504, 0.192061], "f" -> 
           RGBColor[0.578462, 0.85539, 0.408855], "ne" -> 
           RGBColor[0.677263, 0.928423, 0.955287], "na" -> 
           RGBColor[0.658708, 0.492173, 0.842842], "mg" -> 
           RGBColor[0.628274, 0.850553, 0.0782731], "al" -> 
           RGBColor[0.8913, 0.631904, 0.627399], "si" -> 
           RGBColor[0.941176, 0.784314, 0.627451], "p" -> 
           RGBColor[1., 0.501961, 0], "s" -> 
           RGBColor[0.90443, 0.97015, 0.13504], "cl" -> 
           RGBColor[0.412698, 0.932689, 0.166398], "ar" -> 
           RGBColor[0.546138, 0.844244, 0.892092], "k" -> 
           RGBColor[0.534026, 0.420729, 0.705621], "ca" -> 
           RGBColor[0.480072, 0.744591, 0.0955222], "sc" -> 
           RGBColor[0.901961, 0.901961, 0.901961], "ti" -> 
           RGBColor[0.74902, 0.760784, 0.780392], "v" -> 
           RGBColor[0.65098, 0.65098, 0.670588], "cr" -> 
           RGBColor[0.541176, 0.6, 0.780392], "mn" -> 
           RGBColor[0.611765, 0.478431, 0.780392], "fe" -> 
           RGBColor[0.878431, 0.4, 0.2], "co" -> 
           RGBColor[0.941176, 0.564706, 0.627451], "ni" -> 
           RGBColor[0.313725, 0.815686, 0.313725], "cu" -> 
           RGBColor[0.784314, 0.501961, 0.2], "zn" -> 
           RGBColor[0.490196, 0.501961, 0.690196], "ga" -> 
           RGBColor[0.800757, 0.542666, 0.533513], "ge" -> 
           RGBColor[0.60508, 0.632465, 0.576489], "as" -> 
           RGBColor[0.741176, 0.501961, 0.890196], "se" -> 
           RGBColor[0.917248, 0.657833, 0.0706628], "br" -> 
           RGBColor[0.58847, 0.22163, 0.16064], "kr" -> 
           RGBColor[0.426019, 0.747462, 0.810413], "rb" -> 
           RGBColor[0.425391, 0.329242, 0.585895], "sr" -> 
           RGBColor[0.325959, 0.646423, 0.095983], "y" -> 
           RGBColor[0.531014, 1., 1.], "zr" -> 
           RGBColor[0.458599, 0.917466, 0.918573], "nb" -> 
           RGBColor[0.385036, 0.834854, 0.841681], "mo" -> 
           RGBColor[0.310325, 0.752163, 0.769323], "tc" -> 
           RGBColor[0.234466, 0.669394, 0.701499], "ru" -> 
           RGBColor[0.157459, 0.586546, 0.638209], "rh" -> 
           RGBColor[0.0793033, 0.50362, 0.579453], "pd" -> 
           RGBColor[0., 0.420615, 0.525231], "ag" -> 
           RGBColor[0.752941, 0.752941, 0.752941], "cd" -> 
           RGBColor[1., 0.85098, 0.560784], "in" -> 
           RGBColor[0.728371, 0.440594, 0.422196], "sn" -> 
           RGBColor[0.39799, 0.491477, 0.495586], "sb" -> 
           RGBColor[0.619608, 0.388235, 0.709804], "te" -> 
           RGBColor[0.816706, 0.451332, 0.0100947], "i" -> 
           RGBColor[0.580392, 0, 0.580392], "xe" -> 
           RGBColor[0.316906, 0.638078, 0.710252], "cs" -> 
           RGBColor[0.332803, 0.217712, 0.483666], "ba" -> 
           RGBColor[0.165935, 0.55605, 0.0796556], "la" -> 
           RGBColor[0.928084, 0.716075, 0.329427], "ce" -> 
           RGBColor[0.894824, 0.731424, 0.325131], "pr" -> 
           RGBColor[0.86523, 0.707999, 0.315261], "nd" -> 
           RGBColor[0.837836, 0.662974, 0.301635], "pm" -> 
           RGBColor[0.811992, 0.607859, 0.285626], "sm" -> 
           RGBColor[0.787563, 0.549894, 0.268279], "eu" -> 
           RGBColor[0.764628, 0.493261, 0.250405], "gd" -> 
           RGBColor[0.743177, 0.440115, 0.23269], "tb" -> 
           RGBColor[0.72281, 0.39143, 0.215783], "dy" -> 
           RGBColor[0.702434, 0.347663, 0.200392], "ho" -> 
           RGBColor[0.679962, 0.309234, 0.187368], "er" -> 
           RGBColor[0.652012, 0.276823, 0.17779], "tm" -> 
           RGBColor[0.613603, 0.251489, 0.173042], "yb" -> 
           RGBColor[0.557855, 0.234598, 0.17489], "lu" -> 
           RGBColor[0.475685, 0.227573, 0.18555], "hf" -> 
           RGBColor[0.781537, 0.717388, 0.716579], "ta" -> 
           RGBColor[0.734443, 0.544489, 0.683471], "w" -> 
           RGBColor[0.681179, 0.360409, 0.63675], "re" -> 
           RGBColor[0.605181, 0.367584, 0.556343], "os" -> 
           RGBColor[0.521806, 0.382125, 0.469204], "ir" -> 
           RGBColor[0.445624, 0.373159, 0.399069], "pt" -> 
           RGBColor[0.815686, 0.815686, 0.878431], "au" -> 
           RGBColor[1., 0.819608, 0.137255], "hg" -> 
           RGBColor[0.721569, 0.721569, 0.815686], "tl" -> 
           RGBColor[0.65098, 0.329412, 0.301961], "pb" -> 
           RGBColor[0.341176, 0.34902, 0.380392], "bi" -> 
           RGBColor[0.619608, 0.309804, 0.709804], "po" -> 
           RGBColor[0.670588, 0.360784, 0], "at" -> 
           RGBColor[0.458824, 0.309804, 0.270588], "rn" -> 
           RGBColor[0.218799, 0.516091, 0.591608], "fr" -> 
           RGBColor[0.25626, 0.0861372, 0.398932], "ra" -> 
           RGBColor[0., 0.473472, 0.04654], "ac" -> 
           RGBColor[0.322042, 0.71693, 0.988479], "th" -> 
           RGBColor[0.3608, 0.67166, 0.943003], "pa" -> 
           RGBColor[0.397469, 0.628, 0.898853], "u" -> 
           RGBColor[0.43205, 0.58595, 0.856029], "np" -> 
           RGBColor[0.464542, 0.54551, 0.814532], "pu" -> 
           RGBColor[0.494945, 0.506679, 0.774361], "am" -> 
           RGBColor[0.52326, 0.469458, 0.735517], "cm" -> 
           RGBColor[0.549486, 0.433847, 0.697999], "bk" -> 
           RGBColor[0.573624, 0.399845, 0.661808], "cf" -> 
           RGBColor[0.595673, 0.367454, 0.626942], "es" -> 
           RGBColor[0.615633, 0.336672, 0.593404], "fm" -> 
           RGBColor[0.633505, 0.307499, 0.561191], "md" -> 
           RGBColor[0.649288, 0.279937, 0.530305], "no" -> 
           RGBColor[0.662982, 0.253984, 0.500746], "lr" -> 
           RGBColor[0.674588, 0.22964, 0.472513], "rf" -> 
           RGBColor[0.684106, 0.206907, 0.445606], "db" -> 
           RGBColor[0.691534, 0.185783, 0.420025], "sg" -> 
           RGBColor[0.696874, 0.166269, 0.395772], "bh" -> 
           RGBColor[0.700126, 0.148365, 0.372844], "hs" -> 
           RGBColor[0.701289, 0.13207, 0.351243], "mt" -> 
           RGBColor[0.700363, 0.117385, 0.330968], "ds" -> 
           RGBColor[0.697348, 0.10431, 0.31202], "rg" -> 
           RGBColor[0.692245, 0.0928444, 0.294398], "cn" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "nh" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "fl" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "mc" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "lv" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "ts" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "og" -> 
           RGBColor[0.635401, 0.0528, 0.226184], "uub" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "uut" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "uuq" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "uup" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "uuh" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "uus" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "uuo" -> 
           RGBColor[0.635401, 0.0528, 0.226184]}]]& ][0.85], 
       ColorDataFunction[
       "Atoms", 
        "Named", {{
         "H", "He", "Li", "Be", "B", "C", "N", "O", "F", "Ne", "Na", "Mg", 
          "Al", "Si", "P", "S", "Cl", "Ar", "K", "Ca", "Sc", "Ti", "V", "Cr", 
          "Mn", "Fe", "Co", "Ni", "Cu", "Zn", "Ga", "Ge", "As", "Se", "Br", 
          "Kr", "Rb", "Sr", "Y", "Zr", "Nb", "Mo", "Tc", "Ru", "Rh", "Pd", 
          "Ag", "Cd", "In", "Sn", "Sb", "Te", "I", "Xe", "Cs", "Ba", "La", 
          "Ce", "Pr", "Nd", "Pm", "Sm", "Eu", "Gd", "Tb", "Dy", "Ho", "Er", 
          "Tm", "Yb", "Lu", "Hf", "Ta", "W", "Re", "Os", "Ir", "Pt", "Au", 
          "Hg", "Tl", "Pb", "Bi", "Po", "At", "Rn", "Fr", "Ra", "Ac", "Th", 
          "Pa", "U", "Np", "Pu", "Am", "Cm", "Bk", "Cf", "Es", "Fm", "Md", 
          "No", "Lr", "Rf", "Db", "Sg", "Bh", "Hs", "Mt", "Ds", "Rg", "Cn", 
          "Nh", "Fl", "Mc", "Lv", "Ts", "Og", "Uub", "Uut", "Uuq", "Uup", 
          "Uuh", "Uus", "Uuo"}, {
         "h", "he", "li", "be", "b", "c", "n", "o", "f", "ne", "na", "mg", 
          "al", "si", "p", "s", "cl", "ar", "k", "ca", "sc", "ti", "v", "cr", 
          "mn", "fe", "co", "ni", "cu", "zn", "ga", "ge", "as", "se", "br", 
          "kr", "rb", "sr", "y", "zr", "nb", "mo", "tc", "ru", "rh", "pd", 
          "ag", "cd", "in", "sn", "sb", "te", "i", "xe", "cs", "ba", "la", 
          "ce", "pr", "nd", "pm", "sm", "eu", "gd", "tb", "dy", "ho", "er", 
          "tm", "yb", "lu", "hf", "ta", "w", "re", "os", "ir", "pt", "au", 
          "hg", "tl", "pb", "bi", "po", "at", "rn", "fr", "ra", "ac", "th", 
          "pa", "u", "np", "pu", "am", "cm", "bk", "cf", "es", "fm", "md", 
          "no", "lr", "rf", "db", "sg", "bh", "hs", "mt", "ds", "rg", "cn", 
          "nh", "fl", "mc", "lv", "ts", "og", "uub", "uut", "uuq", "uup", 
          "uuh", "uus", "uuo"}}, Replace[#, 
         Dispatch[{
          "h" -> RGBColor[0.65, 0.7, 0.7], "he" -> RGBColor[0.836713, 1., 1.],
            "li" -> RGBColor[0.799435, 0.543572, 0.997559], "be" -> 
           RGBColor[0.770565, 0.964309, 0.0442359], "b" -> 
           RGBColor[1., 0.709804, 0.709804], "c" -> RGBColor[0.4, 0.4, 0.4], 
           "n" -> RGBColor[0.291989, 0.437977, 0.888609], "o" -> 
           RGBColor[0.800498, 0.201504, 0.192061], "f" -> 
           RGBColor[0.578462, 0.85539, 0.408855], "ne" -> 
           RGBColor[0.677263, 0.928423, 0.955287], "na" -> 
           RGBColor[0.658708, 0.492173, 0.842842], "mg" -> 
           RGBColor[0.628274, 0.850553, 0.0782731], "al" -> 
           RGBColor[0.8913, 0.631904, 0.627399], "si" -> 
           RGBColor[0.941176, 0.784314, 0.627451], "p" -> 
           RGBColor[1., 0.501961, 0], "s" -> 
           RGBColor[0.90443, 0.97015, 0.13504], "cl" -> 
           RGBColor[0.412698, 0.932689, 0.166398], "ar" -> 
           RGBColor[0.546138, 0.844244, 0.892092], "k" -> 
           RGBColor[0.534026, 0.420729, 0.705621], "ca" -> 
           RGBColor[0.480072, 0.744591, 0.0955222], "sc" -> 
           RGBColor[0.901961, 0.901961, 0.901961], "ti" -> 
           RGBColor[0.74902, 0.760784, 0.780392], "v" -> 
           RGBColor[0.65098, 0.65098, 0.670588], "cr" -> 
           RGBColor[0.541176, 0.6, 0.780392], "mn" -> 
           RGBColor[0.611765, 0.478431, 0.780392], "fe" -> 
           RGBColor[0.878431, 0.4, 0.2], "co" -> 
           RGBColor[0.941176, 0.564706, 0.627451], "ni" -> 
           RGBColor[0.313725, 0.815686, 0.313725], "cu" -> 
           RGBColor[0.784314, 0.501961, 0.2], "zn" -> 
           RGBColor[0.490196, 0.501961, 0.690196], "ga" -> 
           RGBColor[0.800757, 0.542666, 0.533513], "ge" -> 
           RGBColor[0.60508, 0.632465, 0.576489], "as" -> 
           RGBColor[0.741176, 0.501961, 0.890196], "se" -> 
           RGBColor[0.917248, 0.657833, 0.0706628], "br" -> 
           RGBColor[0.58847, 0.22163, 0.16064], "kr" -> 
           RGBColor[0.426019, 0.747462, 0.810413], "rb" -> 
           RGBColor[0.425391, 0.329242, 0.585895], "sr" -> 
           RGBColor[0.325959, 0.646423, 0.095983], "y" -> 
           RGBColor[0.531014, 1., 1.], "zr" -> 
           RGBColor[0.458599, 0.917466, 0.918573], "nb" -> 
           RGBColor[0.385036, 0.834854, 0.841681], "mo" -> 
           RGBColor[0.310325, 0.752163, 0.769323], "tc" -> 
           RGBColor[0.234466, 0.669394, 0.701499], "ru" -> 
           RGBColor[0.157459, 0.586546, 0.638209], "rh" -> 
           RGBColor[0.0793033, 0.50362, 0.579453], "pd" -> 
           RGBColor[0., 0.420615, 0.525231], "ag" -> 
           RGBColor[0.752941, 0.752941, 0.752941], "cd" -> 
           RGBColor[1., 0.85098, 0.560784], "in" -> 
           RGBColor[0.728371, 0.440594, 0.422196], "sn" -> 
           RGBColor[0.39799, 0.491477, 0.495586], "sb" -> 
           RGBColor[0.619608, 0.388235, 0.709804], "te" -> 
           RGBColor[0.816706, 0.451332, 0.0100947], "i" -> 
           RGBColor[0.580392, 0, 0.580392], "xe" -> 
           RGBColor[0.316906, 0.638078, 0.710252], "cs" -> 
           RGBColor[0.332803, 0.217712, 0.483666], "ba" -> 
           RGBColor[0.165935, 0.55605, 0.0796556], "la" -> 
           RGBColor[0.928084, 0.716075, 0.329427], "ce" -> 
           RGBColor[0.894824, 0.731424, 0.325131], "pr" -> 
           RGBColor[0.86523, 0.707999, 0.315261], "nd" -> 
           RGBColor[0.837836, 0.662974, 0.301635], "pm" -> 
           RGBColor[0.811992, 0.607859, 0.285626], "sm" -> 
           RGBColor[0.787563, 0.549894, 0.268279], "eu" -> 
           RGBColor[0.764628, 0.493261, 0.250405], "gd" -> 
           RGBColor[0.743177, 0.440115, 0.23269], "tb" -> 
           RGBColor[0.72281, 0.39143, 0.215783], "dy" -> 
           RGBColor[0.702434, 0.347663, 0.200392], "ho" -> 
           RGBColor[0.679962, 0.309234, 0.187368], "er" -> 
           RGBColor[0.652012, 0.276823, 0.17779], "tm" -> 
           RGBColor[0.613603, 0.251489, 0.173042], "yb" -> 
           RGBColor[0.557855, 0.234598, 0.17489], "lu" -> 
           RGBColor[0.475685, 0.227573, 0.18555], "hf" -> 
           RGBColor[0.781537, 0.717388, 0.716579], "ta" -> 
           RGBColor[0.734443, 0.544489, 0.683471], "w" -> 
           RGBColor[0.681179, 0.360409, 0.63675], "re" -> 
           RGBColor[0.605181, 0.367584, 0.556343], "os" -> 
           RGBColor[0.521806, 0.382125, 0.469204], "ir" -> 
           RGBColor[0.445624, 0.373159, 0.399069], "pt" -> 
           RGBColor[0.815686, 0.815686, 0.878431], "au" -> 
           RGBColor[1., 0.819608, 0.137255], "hg" -> 
           RGBColor[0.721569, 0.721569, 0.815686], "tl" -> 
           RGBColor[0.65098, 0.329412, 0.301961], "pb" -> 
           RGBColor[0.341176, 0.34902, 0.380392], "bi" -> 
           RGBColor[0.619608, 0.309804, 0.709804], "po" -> 
           RGBColor[0.670588, 0.360784, 0], "at" -> 
           RGBColor[0.458824, 0.309804, 0.270588], "rn" -> 
           RGBColor[0.218799, 0.516091, 0.591608], "fr" -> 
           RGBColor[0.25626, 0.0861372, 0.398932], "ra" -> 
           RGBColor[0., 0.473472, 0.04654], "ac" -> 
           RGBColor[0.322042, 0.71693, 0.988479], "th" -> 
           RGBColor[0.3608, 0.67166, 0.943003], "pa" -> 
           RGBColor[0.397469, 0.628, 0.898853], "u" -> 
           RGBColor[0.43205, 0.58595, 0.856029], "np" -> 
           RGBColor[0.464542, 0.54551, 0.814532], "pu" -> 
           RGBColor[0.494945, 0.506679, 0.774361], "am" -> 
           RGBColor[0.52326, 0.469458, 0.735517], "cm" -> 
           RGBColor[0.549486, 0.433847, 0.697999], "bk" -> 
           RGBColor[0.573624, 0.399845, 0.661808], "cf" -> 
           RGBColor[0.595673, 0.367454, 0.626942], "es" -> 
           RGBColor[0.615633, 0.336672, 0.593404], "fm" -> 
           RGBColor[0.633505, 0.307499, 0.561191], "md" -> 
           RGBColor[0.649288, 0.279937, 0.530305], "no" -> 
           RGBColor[0.662982, 0.253984, 0.500746], "lr" -> 
           RGBColor[0.674588, 0.22964, 0.472513], "rf" -> 
           RGBColor[0.684106, 0.206907, 0.445606], "db" -> 
           RGBColor[0.691534, 0.185783, 0.420025], "sg" -> 
           RGBColor[0.696874, 0.166269, 0.395772], "bh" -> 
           RGBColor[0.700126, 0.148365, 0.372844], "hs" -> 
           RGBColor[0.701289, 0.13207, 0.351243], "mt" -> 
           RGBColor[0.700363, 0.117385, 0.330968], "ds" -> 
           RGBColor[0.697348, 0.10431, 0.31202], "rg" -> 
           RGBColor[0.692245, 0.0928444, 0.294398], "cn" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "nh" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "fl" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "mc" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "lv" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "ts" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "og" -> 
           RGBColor[0.635401, 0.0528, 0.226184], "uub" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "uut" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "uuq" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "uup" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "uuh" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "uus" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "uuo" -> 
           RGBColor[0.635401, 0.0528, 0.226184]}]]& ][0.85], 
       ColorDataFunction[
       "Atoms", 
        "Named", {{
         "H", "He", "Li", "Be", "B", "C", "N", "O", "F", "Ne", "Na", "Mg", 
          "Al", "Si", "P", "S", "Cl", "Ar", "K", "Ca", "Sc", "Ti", "V", "Cr", 
          "Mn", "Fe", "Co", "Ni", "Cu", "Zn", "Ga", "Ge", "As", "Se", "Br", 
          "Kr", "Rb", "Sr", "Y", "Zr", "Nb", "Mo", "Tc", "Ru", "Rh", "Pd", 
          "Ag", "Cd", "In", "Sn", "Sb", "Te", "I", "Xe", "Cs", "Ba", "La", 
          "Ce", "Pr", "Nd", "Pm", "Sm", "Eu", "Gd", "Tb", "Dy", "Ho", "Er", 
          "Tm", "Yb", "Lu", "Hf", "Ta", "W", "Re", "Os", "Ir", "Pt", "Au", 
          "Hg", "Tl", "Pb", "Bi", "Po", "At", "Rn", "Fr", "Ra", "Ac", "Th", 
          "Pa", "U", "Np", "Pu", "Am", "Cm", "Bk", "Cf", "Es", "Fm", "Md", 
          "No", "Lr", "Rf", "Db", "Sg", "Bh", "Hs", "Mt", "Ds", "Rg", "Cn", 
          "Nh", "Fl", "Mc", "Lv", "Ts", "Og", "Uub", "Uut", "Uuq", "Uup", 
          "Uuh", "Uus", "Uuo"}, {
         "h", "he", "li", "be", "b", "c", "n", "o", "f", "ne", "na", "mg", 
          "al", "si", "p", "s", "cl", "ar", "k", "ca", "sc", "ti", "v", "cr", 
          "mn", "fe", "co", "ni", "cu", "zn", "ga", "ge", "as", "se", "br", 
          "kr", "rb", "sr", "y", "zr", "nb", "mo", "tc", "ru", "rh", "pd", 
          "ag", "cd", "in", "sn", "sb", "te", "i", "xe", "cs", "ba", "la", 
          "ce", "pr", "nd", "pm", "sm", "eu", "gd", "tb", "dy", "ho", "er", 
          "tm", "yb", "lu", "hf", "ta", "w", "re", "os", "ir", "pt", "au", 
          "hg", "tl", "pb", "bi", "po", "at", "rn", "fr", "ra", "ac", "th", 
          "pa", "u", "np", "pu", "am", "cm", "bk", "cf", "es", "fm", "md", 
          "no", "lr", "rf", "db", "sg", "bh", "hs", "mt", "ds", "rg", "cn", 
          "nh", "fl", "mc", "lv", "ts", "og", "uub", "uut", "uuq", "uup", 
          "uuh", "uus", "uuo"}}, Replace[#, 
         Dispatch[{
          "h" -> RGBColor[0.65, 0.7, 0.7], "he" -> RGBColor[0.836713, 1., 1.],
            "li" -> RGBColor[0.799435, 0.543572, 0.997559], "be" -> 
           RGBColor[0.770565, 0.964309, 0.0442359], "b" -> 
           RGBColor[1., 0.709804, 0.709804], "c" -> RGBColor[0.4, 0.4, 0.4], 
           "n" -> RGBColor[0.291989, 0.437977, 0.888609], "o" -> 
           RGBColor[0.800498, 0.201504, 0.192061], "f" -> 
           RGBColor[0.578462, 0.85539, 0.408855], "ne" -> 
           RGBColor[0.677263, 0.928423, 0.955287], "na" -> 
           RGBColor[0.658708, 0.492173, 0.842842], "mg" -> 
           RGBColor[0.628274, 0.850553, 0.0782731], "al" -> 
           RGBColor[0.8913, 0.631904, 0.627399], "si" -> 
           RGBColor[0.941176, 0.784314, 0.627451], "p" -> 
           RGBColor[1., 0.501961, 0], "s" -> 
           RGBColor[0.90443, 0.97015, 0.13504], "cl" -> 
           RGBColor[0.412698, 0.932689, 0.166398], "ar" -> 
           RGBColor[0.546138, 0.844244, 0.892092], "k" -> 
           RGBColor[0.534026, 0.420729, 0.705621], "ca" -> 
           RGBColor[0.480072, 0.744591, 0.0955222], "sc" -> 
           RGBColor[0.901961, 0.901961, 0.901961], "ti" -> 
           RGBColor[0.74902, 0.760784, 0.780392], "v" -> 
           RGBColor[0.65098, 0.65098, 0.670588], "cr" -> 
           RGBColor[0.541176, 0.6, 0.780392], "mn" -> 
           RGBColor[0.611765, 0.478431, 0.780392], "fe" -> 
           RGBColor[0.878431, 0.4, 0.2], "co" -> 
           RGBColor[0.941176, 0.564706, 0.627451], "ni" -> 
           RGBColor[0.313725, 0.815686, 0.313725], "cu" -> 
           RGBColor[0.784314, 0.501961, 0.2], "zn" -> 
           RGBColor[0.490196, 0.501961, 0.690196], "ga" -> 
           RGBColor[0.800757, 0.542666, 0.533513], "ge" -> 
           RGBColor[0.60508, 0.632465, 0.576489], "as" -> 
           RGBColor[0.741176, 0.501961, 0.890196], "se" -> 
           RGBColor[0.917248, 0.657833, 0.0706628], "br" -> 
           RGBColor[0.58847, 0.22163, 0.16064], "kr" -> 
           RGBColor[0.426019, 0.747462, 0.810413], "rb" -> 
           RGBColor[0.425391, 0.329242, 0.585895], "sr" -> 
           RGBColor[0.325959, 0.646423, 0.095983], "y" -> 
           RGBColor[0.531014, 1., 1.], "zr" -> 
           RGBColor[0.458599, 0.917466, 0.918573], "nb" -> 
           RGBColor[0.385036, 0.834854, 0.841681], "mo" -> 
           RGBColor[0.310325, 0.752163, 0.769323], "tc" -> 
           RGBColor[0.234466, 0.669394, 0.701499], "ru" -> 
           RGBColor[0.157459, 0.586546, 0.638209], "rh" -> 
           RGBColor[0.0793033, 0.50362, 0.579453], "pd" -> 
           RGBColor[0., 0.420615, 0.525231], "ag" -> 
           RGBColor[0.752941, 0.752941, 0.752941], "cd" -> 
           RGBColor[1., 0.85098, 0.560784], "in" -> 
           RGBColor[0.728371, 0.440594, 0.422196], "sn" -> 
           RGBColor[0.39799, 0.491477, 0.495586], "sb" -> 
           RGBColor[0.619608, 0.388235, 0.709804], "te" -> 
           RGBColor[0.816706, 0.451332, 0.0100947], "i" -> 
           RGBColor[0.580392, 0, 0.580392], "xe" -> 
           RGBColor[0.316906, 0.638078, 0.710252], "cs" -> 
           RGBColor[0.332803, 0.217712, 0.483666], "ba" -> 
           RGBColor[0.165935, 0.55605, 0.0796556], "la" -> 
           RGBColor[0.928084, 0.716075, 0.329427], "ce" -> 
           RGBColor[0.894824, 0.731424, 0.325131], "pr" -> 
           RGBColor[0.86523, 0.707999, 0.315261], "nd" -> 
           RGBColor[0.837836, 0.662974, 0.301635], "pm" -> 
           RGBColor[0.811992, 0.607859, 0.285626], "sm" -> 
           RGBColor[0.787563, 0.549894, 0.268279], "eu" -> 
           RGBColor[0.764628, 0.493261, 0.250405], "gd" -> 
           RGBColor[0.743177, 0.440115, 0.23269], "tb" -> 
           RGBColor[0.72281, 0.39143, 0.215783], "dy" -> 
           RGBColor[0.702434, 0.347663, 0.200392], "ho" -> 
           RGBColor[0.679962, 0.309234, 0.187368], "er" -> 
           RGBColor[0.652012, 0.276823, 0.17779], "tm" -> 
           RGBColor[0.613603, 0.251489, 0.173042], "yb" -> 
           RGBColor[0.557855, 0.234598, 0.17489], "lu" -> 
           RGBColor[0.475685, 0.227573, 0.18555], "hf" -> 
           RGBColor[0.781537, 0.717388, 0.716579], "ta" -> 
           RGBColor[0.734443, 0.544489, 0.683471], "w" -> 
           RGBColor[0.681179, 0.360409, 0.63675], "re" -> 
           RGBColor[0.605181, 0.367584, 0.556343], "os" -> 
           RGBColor[0.521806, 0.382125, 0.469204], "ir" -> 
           RGBColor[0.445624, 0.373159, 0.399069], "pt" -> 
           RGBColor[0.815686, 0.815686, 0.878431], "au" -> 
           RGBColor[1., 0.819608, 0.137255], "hg" -> 
           RGBColor[0.721569, 0.721569, 0.815686], "tl" -> 
           RGBColor[0.65098, 0.329412, 0.301961], "pb" -> 
           RGBColor[0.341176, 0.34902, 0.380392], "bi" -> 
           RGBColor[0.619608, 0.309804, 0.709804], "po" -> 
           RGBColor[0.670588, 0.360784, 0], "at" -> 
           RGBColor[0.458824, 0.309804, 0.270588], "rn" -> 
           RGBColor[0.218799, 0.516091, 0.591608], "fr" -> 
           RGBColor[0.25626, 0.0861372, 0.398932], "ra" -> 
           RGBColor[0., 0.473472, 0.04654], "ac" -> 
           RGBColor[0.322042, 0.71693, 0.988479], "th" -> 
           RGBColor[0.3608, 0.67166, 0.943003], "pa" -> 
           RGBColor[0.397469, 0.628, 0.898853], "u" -> 
           RGBColor[0.43205, 0.58595, 0.856029], "np" -> 
           RGBColor[0.464542, 0.54551, 0.814532], "pu" -> 
           RGBColor[0.494945, 0.506679, 0.774361], "am" -> 
           RGBColor[0.52326, 0.469458, 0.735517], "cm" -> 
           RGBColor[0.549486, 0.433847, 0.697999], "bk" -> 
           RGBColor[0.573624, 0.399845, 0.661808], "cf" -> 
           RGBColor[0.595673, 0.367454, 0.626942], "es" -> 
           RGBColor[0.615633, 0.336672, 0.593404], "fm" -> 
           RGBColor[0.633505, 0.307499, 0.561191], "md" -> 
           RGBColor[0.649288, 0.279937, 0.530305], "no" -> 
           RGBColor[0.662982, 0.253984, 0.500746], "lr" -> 
           RGBColor[0.674588, 0.22964, 0.472513], "rf" -> 
           RGBColor[0.684106, 0.206907, 0.445606], "db" -> 
           RGBColor[0.691534, 0.185783, 0.420025], "sg" -> 
           RGBColor[0.696874, 0.166269, 0.395772], "bh" -> 
           RGBColor[0.700126, 0.148365, 0.372844], "hs" -> 
           RGBColor[0.701289, 0.13207, 0.351243], "mt" -> 
           RGBColor[0.700363, 0.117385, 0.330968], "ds" -> 
           RGBColor[0.697348, 0.10431, 0.31202], "rg" -> 
           RGBColor[0.692245, 0.0928444, 0.294398], "cn" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "nh" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "fl" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "mc" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "lv" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "ts" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "og" -> 
           RGBColor[0.635401, 0.0528, 0.226184], "uub" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "uut" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "uuq" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "uup" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "uuh" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "uus" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "uuo" -> 
           RGBColor[0.635401, 0.0528, 0.226184]}]]& ][0.85], 
       ColorDataFunction[
       "Atoms", 
        "Named", {{
         "H", "He", "Li", "Be", "B", "C", "N", "O", "F", "Ne", "Na", "Mg", 
          "Al", "Si", "P", "S", "Cl", "Ar", "K", "Ca", "Sc", "Ti", "V", "Cr", 
          "Mn", "Fe", "Co", "Ni", "Cu", "Zn", "Ga", "Ge", "As", "Se", "Br", 
          "Kr", "Rb", "Sr", "Y", "Zr", "Nb", "Mo", "Tc", "Ru", "Rh", "Pd", 
          "Ag", "Cd", "In", "Sn", "Sb", "Te", "I", "Xe", "Cs", "Ba", "La", 
          "Ce", "Pr", "Nd", "Pm", "Sm", "Eu", "Gd", "Tb", "Dy", "Ho", "Er", 
          "Tm", "Yb", "Lu", "Hf", "Ta", "W", "Re", "Os", "Ir", "Pt", "Au", 
          "Hg", "Tl", "Pb", "Bi", "Po", "At", "Rn", "Fr", "Ra", "Ac", "Th", 
          "Pa", "U", "Np", "Pu", "Am", "Cm", "Bk", "Cf", "Es", "Fm", "Md", 
          "No", "Lr", "Rf", "Db", "Sg", "Bh", "Hs", "Mt", "Ds", "Rg", "Cn", 
          "Nh", "Fl", "Mc", "Lv", "Ts", "Og", "Uub", "Uut", "Uuq", "Uup", 
          "Uuh", "Uus", "Uuo"}, {
         "h", "he", "li", "be", "b", "c", "n", "o", "f", "ne", "na", "mg", 
          "al", "si", "p", "s", "cl", "ar", "k", "ca", "sc", "ti", "v", "cr", 
          "mn", "fe", "co", "ni", "cu", "zn", "ga", "ge", "as", "se", "br", 
          "kr", "rb", "sr", "y", "zr", "nb", "mo", "tc", "ru", "rh", "pd", 
          "ag", "cd", "in", "sn", "sb", "te", "i", "xe", "cs", "ba", "la", 
          "ce", "pr", "nd", "pm", "sm", "eu", "gd", "tb", "dy", "ho", "er", 
          "tm", "yb", "lu", "hf", "ta", "w", "re", "os", "ir", "pt", "au", 
          "hg", "tl", "pb", "bi", "po", "at", "rn", "fr", "ra", "ac", "th", 
          "pa", "u", "np", "pu", "am", "cm", "bk", "cf", "es", "fm", "md", 
          "no", "lr", "rf", "db", "sg", "bh", "hs", "mt", "ds", "rg", "cn", 
          "nh", "fl", "mc", "lv", "ts", "og", "uub", "uut", "uuq", "uup", 
          "uuh", "uus", "uuo"}}, Replace[#, 
         Dispatch[{
          "h" -> RGBColor[0.65, 0.7, 0.7], "he" -> RGBColor[0.836713, 1., 1.],
            "li" -> RGBColor[0.799435, 0.543572, 0.997559], "be" -> 
           RGBColor[0.770565, 0.964309, 0.0442359], "b" -> 
           RGBColor[1., 0.709804, 0.709804], "c" -> RGBColor[0.4, 0.4, 0.4], 
           "n" -> RGBColor[0.291989, 0.437977, 0.888609], "o" -> 
           RGBColor[0.800498, 0.201504, 0.192061], "f" -> 
           RGBColor[0.578462, 0.85539, 0.408855], "ne" -> 
           RGBColor[0.677263, 0.928423, 0.955287], "na" -> 
           RGBColor[0.658708, 0.492173, 0.842842], "mg" -> 
           RGBColor[0.628274, 0.850553, 0.0782731], "al" -> 
           RGBColor[0.8913, 0.631904, 0.627399], "si" -> 
           RGBColor[0.941176, 0.784314, 0.627451], "p" -> 
           RGBColor[1., 0.501961, 0], "s" -> 
           RGBColor[0.90443, 0.97015, 0.13504], "cl" -> 
           RGBColor[0.412698, 0.932689, 0.166398], "ar" -> 
           RGBColor[0.546138, 0.844244, 0.892092], "k" -> 
           RGBColor[0.534026, 0.420729, 0.705621], "ca" -> 
           RGBColor[0.480072, 0.744591, 0.0955222], "sc" -> 
           RGBColor[0.901961, 0.901961, 0.901961], "ti" -> 
           RGBColor[0.74902, 0.760784, 0.780392], "v" -> 
           RGBColor[0.65098, 0.65098, 0.670588], "cr" -> 
           RGBColor[0.541176, 0.6, 0.780392], "mn" -> 
           RGBColor[0.611765, 0.478431, 0.780392], "fe" -> 
           RGBColor[0.878431, 0.4, 0.2], "co" -> 
           RGBColor[0.941176, 0.564706, 0.627451], "ni" -> 
           RGBColor[0.313725, 0.815686, 0.313725], "cu" -> 
           RGBColor[0.784314, 0.501961, 0.2], "zn" -> 
           RGBColor[0.490196, 0.501961, 0.690196], "ga" -> 
           RGBColor[0.800757, 0.542666, 0.533513], "ge" -> 
           RGBColor[0.60508, 0.632465, 0.576489], "as" -> 
           RGBColor[0.741176, 0.501961, 0.890196], "se" -> 
           RGBColor[0.917248, 0.657833, 0.0706628], "br" -> 
           RGBColor[0.58847, 0.22163, 0.16064], "kr" -> 
           RGBColor[0.426019, 0.747462, 0.810413], "rb" -> 
           RGBColor[0.425391, 0.329242, 0.585895], "sr" -> 
           RGBColor[0.325959, 0.646423, 0.095983], "y" -> 
           RGBColor[0.531014, 1., 1.], "zr" -> 
           RGBColor[0.458599, 0.917466, 0.918573], "nb" -> 
           RGBColor[0.385036, 0.834854, 0.841681], "mo" -> 
           RGBColor[0.310325, 0.752163, 0.769323], "tc" -> 
           RGBColor[0.234466, 0.669394, 0.701499], "ru" -> 
           RGBColor[0.157459, 0.586546, 0.638209], "rh" -> 
           RGBColor[0.0793033, 0.50362, 0.579453], "pd" -> 
           RGBColor[0., 0.420615, 0.525231], "ag" -> 
           RGBColor[0.752941, 0.752941, 0.752941], "cd" -> 
           RGBColor[1., 0.85098, 0.560784], "in" -> 
           RGBColor[0.728371, 0.440594, 0.422196], "sn" -> 
           RGBColor[0.39799, 0.491477, 0.495586], "sb" -> 
           RGBColor[0.619608, 0.388235, 0.709804], "te" -> 
           RGBColor[0.816706, 0.451332, 0.0100947], "i" -> 
           RGBColor[0.580392, 0, 0.580392], "xe" -> 
           RGBColor[0.316906, 0.638078, 0.710252], "cs" -> 
           RGBColor[0.332803, 0.217712, 0.483666], "ba" -> 
           RGBColor[0.165935, 0.55605, 0.0796556], "la" -> 
           RGBColor[0.928084, 0.716075, 0.329427], "ce" -> 
           RGBColor[0.894824, 0.731424, 0.325131], "pr" -> 
           RGBColor[0.86523, 0.707999, 0.315261], "nd" -> 
           RGBColor[0.837836, 0.662974, 0.301635], "pm" -> 
           RGBColor[0.811992, 0.607859, 0.285626], "sm" -> 
           RGBColor[0.787563, 0.549894, 0.268279], "eu" -> 
           RGBColor[0.764628, 0.493261, 0.250405], "gd" -> 
           RGBColor[0.743177, 0.440115, 0.23269], "tb" -> 
           RGBColor[0.72281, 0.39143, 0.215783], "dy" -> 
           RGBColor[0.702434, 0.347663, 0.200392], "ho" -> 
           RGBColor[0.679962, 0.309234, 0.187368], "er" -> 
           RGBColor[0.652012, 0.276823, 0.17779], "tm" -> 
           RGBColor[0.613603, 0.251489, 0.173042], "yb" -> 
           RGBColor[0.557855, 0.234598, 0.17489], "lu" -> 
           RGBColor[0.475685, 0.227573, 0.18555], "hf" -> 
           RGBColor[0.781537, 0.717388, 0.716579], "ta" -> 
           RGBColor[0.734443, 0.544489, 0.683471], "w" -> 
           RGBColor[0.681179, 0.360409, 0.63675], "re" -> 
           RGBColor[0.605181, 0.367584, 0.556343], "os" -> 
           RGBColor[0.521806, 0.382125, 0.469204], "ir" -> 
           RGBColor[0.445624, 0.373159, 0.399069], "pt" -> 
           RGBColor[0.815686, 0.815686, 0.878431], "au" -> 
           RGBColor[1., 0.819608, 0.137255], "hg" -> 
           RGBColor[0.721569, 0.721569, 0.815686], "tl" -> 
           RGBColor[0.65098, 0.329412, 0.301961], "pb" -> 
           RGBColor[0.341176, 0.34902, 0.380392], "bi" -> 
           RGBColor[0.619608, 0.309804, 0.709804], "po" -> 
           RGBColor[0.670588, 0.360784, 0], "at" -> 
           RGBColor[0.458824, 0.309804, 0.270588], "rn" -> 
           RGBColor[0.218799, 0.516091, 0.591608], "fr" -> 
           RGBColor[0.25626, 0.0861372, 0.398932], "ra" -> 
           RGBColor[0., 0.473472, 0.04654], "ac" -> 
           RGBColor[0.322042, 0.71693, 0.988479], "th" -> 
           RGBColor[0.3608, 0.67166, 0.943003], "pa" -> 
           RGBColor[0.397469, 0.628, 0.898853], "u" -> 
           RGBColor[0.43205, 0.58595, 0.856029], "np" -> 
           RGBColor[0.464542, 0.54551, 0.814532], "pu" -> 
           RGBColor[0.494945, 0.506679, 0.774361], "am" -> 
           RGBColor[0.52326, 0.469458, 0.735517], "cm" -> 
           RGBColor[0.549486, 0.433847, 0.697999], "bk" -> 
           RGBColor[0.573624, 0.399845, 0.661808], "cf" -> 
           RGBColor[0.595673, 0.367454, 0.626942], "es" -> 
           RGBColor[0.615633, 0.336672, 0.593404], "fm" -> 
           RGBColor[0.633505, 0.307499, 0.561191], "md" -> 
           RGBColor[0.649288, 0.279937, 0.530305], "no" -> 
           RGBColor[0.662982, 0.253984, 0.500746], "lr" -> 
           RGBColor[0.674588, 0.22964, 0.472513], "rf" -> 
           RGBColor[0.684106, 0.206907, 0.445606], "db" -> 
           RGBColor[0.691534, 0.185783, 0.420025], "sg" -> 
           RGBColor[0.696874, 0.166269, 0.395772], "bh" -> 
           RGBColor[0.700126, 0.148365, 0.372844], "hs" -> 
           RGBColor[0.701289, 0.13207, 0.351243], "mt" -> 
           RGBColor[0.700363, 0.117385, 0.330968], "ds" -> 
           RGBColor[0.697348, 0.10431, 0.31202], "rg" -> 
           RGBColor[0.692245, 0.0928444, 0.294398], "cn" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "nh" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "fl" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "mc" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "lv" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "ts" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "og" -> 
           RGBColor[0.635401, 0.0528, 0.226184], "uub" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "uut" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "uuq" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "uup" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "uuh" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "uus" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "uuo" -> 
           RGBColor[0.635401, 0.0528, 0.226184]}]]& ][0.85], 
       ColorDataFunction[
       "Atoms", 
        "Named", {{
         "H", "He", "Li", "Be", "B", "C", "N", "O", "F", "Ne", "Na", "Mg", 
          "Al", "Si", "P", "S", "Cl", "Ar", "K", "Ca", "Sc", "Ti", "V", "Cr", 
          "Mn", "Fe", "Co", "Ni", "Cu", "Zn", "Ga", "Ge", "As", "Se", "Br", 
          "Kr", "Rb", "Sr", "Y", "Zr", "Nb", "Mo", "Tc", "Ru", "Rh", "Pd", 
          "Ag", "Cd", "In", "Sn", "Sb", "Te", "I", "Xe", "Cs", "Ba", "La", 
          "Ce", "Pr", "Nd", "Pm", "Sm", "Eu", "Gd", "Tb", "Dy", "Ho", "Er", 
          "Tm", "Yb", "Lu", "Hf", "Ta", "W", "Re", "Os", "Ir", "Pt", "Au", 
          "Hg", "Tl", "Pb", "Bi", "Po", "At", "Rn", "Fr", "Ra", "Ac", "Th", 
          "Pa", "U", "Np", "Pu", "Am", "Cm", "Bk", "Cf", "Es", "Fm", "Md", 
          "No", "Lr", "Rf", "Db", "Sg", "Bh", "Hs", "Mt", "Ds", "Rg", "Cn", 
          "Nh", "Fl", "Mc", "Lv", "Ts", "Og", "Uub", "Uut", "Uuq", "Uup", 
          "Uuh", "Uus", "Uuo"}, {
         "h", "he", "li", "be", "b", "c", "n", "o", "f", "ne", "na", "mg", 
          "al", "si", "p", "s", "cl", "ar", "k", "ca", "sc", "ti", "v", "cr", 
          "mn", "fe", "co", "ni", "cu", "zn", "ga", "ge", "as", "se", "br", 
          "kr", "rb", "sr", "y", "zr", "nb", "mo", "tc", "ru", "rh", "pd", 
          "ag", "cd", "in", "sn", "sb", "te", "i", "xe", "cs", "ba", "la", 
          "ce", "pr", "nd", "pm", "sm", "eu", "gd", "tb", "dy", "ho", "er", 
          "tm", "yb", "lu", "hf", "ta", "w", "re", "os", "ir", "pt", "au", 
          "hg", "tl", "pb", "bi", "po", "at", "rn", "fr", "ra", "ac", "th", 
          "pa", "u", "np", "pu", "am", "cm", "bk", "cf", "es", "fm", "md", 
          "no", "lr", "rf", "db", "sg", "bh", "hs", "mt", "ds", "rg", "cn", 
          "nh", "fl", "mc", "lv", "ts", "og", "uub", "uut", "uuq", "uup", 
          "uuh", "uus", "uuo"}}, Replace[#, 
         Dispatch[{
          "h" -> RGBColor[0.65, 0.7, 0.7], "he" -> RGBColor[0.836713, 1., 1.],
            "li" -> RGBColor[0.799435, 0.543572, 0.997559], "be" -> 
           RGBColor[0.770565, 0.964309, 0.0442359], "b" -> 
           RGBColor[1., 0.709804, 0.709804], "c" -> RGBColor[0.4, 0.4, 0.4], 
           "n" -> RGBColor[0.291989, 0.437977, 0.888609], "o" -> 
           RGBColor[0.800498, 0.201504, 0.192061], "f" -> 
           RGBColor[0.578462, 0.85539, 0.408855], "ne" -> 
           RGBColor[0.677263, 0.928423, 0.955287], "na" -> 
           RGBColor[0.658708, 0.492173, 0.842842], "mg" -> 
           RGBColor[0.628274, 0.850553, 0.0782731], "al" -> 
           RGBColor[0.8913, 0.631904, 0.627399], "si" -> 
           RGBColor[0.941176, 0.784314, 0.627451], "p" -> 
           RGBColor[1., 0.501961, 0], "s" -> 
           RGBColor[0.90443, 0.97015, 0.13504], "cl" -> 
           RGBColor[0.412698, 0.932689, 0.166398], "ar" -> 
           RGBColor[0.546138, 0.844244, 0.892092], "k" -> 
           RGBColor[0.534026, 0.420729, 0.705621], "ca" -> 
           RGBColor[0.480072, 0.744591, 0.0955222], "sc" -> 
           RGBColor[0.901961, 0.901961, 0.901961], "ti" -> 
           RGBColor[0.74902, 0.760784, 0.780392], "v" -> 
           RGBColor[0.65098, 0.65098, 0.670588], "cr" -> 
           RGBColor[0.541176, 0.6, 0.780392], "mn" -> 
           RGBColor[0.611765, 0.478431, 0.780392], "fe" -> 
           RGBColor[0.878431, 0.4, 0.2], "co" -> 
           RGBColor[0.941176, 0.564706, 0.627451], "ni" -> 
           RGBColor[0.313725, 0.815686, 0.313725], "cu" -> 
           RGBColor[0.784314, 0.501961, 0.2], "zn" -> 
           RGBColor[0.490196, 0.501961, 0.690196], "ga" -> 
           RGBColor[0.800757, 0.542666, 0.533513], "ge" -> 
           RGBColor[0.60508, 0.632465, 0.576489], "as" -> 
           RGBColor[0.741176, 0.501961, 0.890196], "se" -> 
           RGBColor[0.917248, 0.657833, 0.0706628], "br" -> 
           RGBColor[0.58847, 0.22163, 0.16064], "kr" -> 
           RGBColor[0.426019, 0.747462, 0.810413], "rb" -> 
           RGBColor[0.425391, 0.329242, 0.585895], "sr" -> 
           RGBColor[0.325959, 0.646423, 0.095983], "y" -> 
           RGBColor[0.531014, 1., 1.], "zr" -> 
           RGBColor[0.458599, 0.917466, 0.918573], "nb" -> 
           RGBColor[0.385036, 0.834854, 0.841681], "mo" -> 
           RGBColor[0.310325, 0.752163, 0.769323], "tc" -> 
           RGBColor[0.234466, 0.669394, 0.701499], "ru" -> 
           RGBColor[0.157459, 0.586546, 0.638209], "rh" -> 
           RGBColor[0.0793033, 0.50362, 0.579453], "pd" -> 
           RGBColor[0., 0.420615, 0.525231], "ag" -> 
           RGBColor[0.752941, 0.752941, 0.752941], "cd" -> 
           RGBColor[1., 0.85098, 0.560784], "in" -> 
           RGBColor[0.728371, 0.440594, 0.422196], "sn" -> 
           RGBColor[0.39799, 0.491477, 0.495586], "sb" -> 
           RGBColor[0.619608, 0.388235, 0.709804], "te" -> 
           RGBColor[0.816706, 0.451332, 0.0100947], "i" -> 
           RGBColor[0.580392, 0, 0.580392], "xe" -> 
           RGBColor[0.316906, 0.638078, 0.710252], "cs" -> 
           RGBColor[0.332803, 0.217712, 0.483666], "ba" -> 
           RGBColor[0.165935, 0.55605, 0.0796556], "la" -> 
           RGBColor[0.928084, 0.716075, 0.329427], "ce" -> 
           RGBColor[0.894824, 0.731424, 0.325131], "pr" -> 
           RGBColor[0.86523, 0.707999, 0.315261], "nd" -> 
           RGBColor[0.837836, 0.662974, 0.301635], "pm" -> 
           RGBColor[0.811992, 0.607859, 0.285626], "sm" -> 
           RGBColor[0.787563, 0.549894, 0.268279], "eu" -> 
           RGBColor[0.764628, 0.493261, 0.250405], "gd" -> 
           RGBColor[0.743177, 0.440115, 0.23269], "tb" -> 
           RGBColor[0.72281, 0.39143, 0.215783], "dy" -> 
           RGBColor[0.702434, 0.347663, 0.200392], "ho" -> 
           RGBColor[0.679962, 0.309234, 0.187368], "er" -> 
           RGBColor[0.652012, 0.276823, 0.17779], "tm" -> 
           RGBColor[0.613603, 0.251489, 0.173042], "yb" -> 
           RGBColor[0.557855, 0.234598, 0.17489], "lu" -> 
           RGBColor[0.475685, 0.227573, 0.18555], "hf" -> 
           RGBColor[0.781537, 0.717388, 0.716579], "ta" -> 
           RGBColor[0.734443, 0.544489, 0.683471], "w" -> 
           RGBColor[0.681179, 0.360409, 0.63675], "re" -> 
           RGBColor[0.605181, 0.367584, 0.556343], "os" -> 
           RGBColor[0.521806, 0.382125, 0.469204], "ir" -> 
           RGBColor[0.445624, 0.373159, 0.399069], "pt" -> 
           RGBColor[0.815686, 0.815686, 0.878431], "au" -> 
           RGBColor[1., 0.819608, 0.137255], "hg" -> 
           RGBColor[0.721569, 0.721569, 0.815686], "tl" -> 
           RGBColor[0.65098, 0.329412, 0.301961], "pb" -> 
           RGBColor[0.341176, 0.34902, 0.380392], "bi" -> 
           RGBColor[0.619608, 0.309804, 0.709804], "po" -> 
           RGBColor[0.670588, 0.360784, 0], "at" -> 
           RGBColor[0.458824, 0.309804, 0.270588], "rn" -> 
           RGBColor[0.218799, 0.516091, 0.591608], "fr" -> 
           RGBColor[0.25626, 0.0861372, 0.398932], "ra" -> 
           RGBColor[0., 0.473472, 0.04654], "ac" -> 
           RGBColor[0.322042, 0.71693, 0.988479], "th" -> 
           RGBColor[0.3608, 0.67166, 0.943003], "pa" -> 
           RGBColor[0.397469, 0.628, 0.898853], "u" -> 
           RGBColor[0.43205, 0.58595, 0.856029], "np" -> 
           RGBColor[0.464542, 0.54551, 0.814532], "pu" -> 
           RGBColor[0.494945, 0.506679, 0.774361], "am" -> 
           RGBColor[0.52326, 0.469458, 0.735517], "cm" -> 
           RGBColor[0.549486, 0.433847, 0.697999], "bk" -> 
           RGBColor[0.573624, 0.399845, 0.661808], "cf" -> 
           RGBColor[0.595673, 0.367454, 0.626942], "es" -> 
           RGBColor[0.615633, 0.336672, 0.593404], "fm" -> 
           RGBColor[0.633505, 0.307499, 0.561191], "md" -> 
           RGBColor[0.649288, 0.279937, 0.530305], "no" -> 
           RGBColor[0.662982, 0.253984, 0.500746], "lr" -> 
           RGBColor[0.674588, 0.22964, 0.472513], "rf" -> 
           RGBColor[0.684106, 0.206907, 0.445606], "db" -> 
           RGBColor[0.691534, 0.185783, 0.420025], "sg" -> 
           RGBColor[0.696874, 0.166269, 0.395772], "bh" -> 
           RGBColor[0.700126, 0.148365, 0.372844], "hs" -> 
           RGBColor[0.701289, 0.13207, 0.351243], "mt" -> 
           RGBColor[0.700363, 0.117385, 0.330968], "ds" -> 
           RGBColor[0.697348, 0.10431, 0.31202], "rg" -> 
           RGBColor[0.692245, 0.0928444, 0.294398], "cn" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "nh" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "fl" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "mc" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "lv" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "ts" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "og" -> 
           RGBColor[0.635401, 0.0528, 0.226184], "uub" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "uut" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "uuq" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "uup" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "uuh" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "uus" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "uuo" -> 
           RGBColor[0.635401, 0.0528, 0.226184]}]]& ][0.85], 
       ColorDataFunction[
       "Atoms", 
        "Named", {{
         "H", "He", "Li", "Be", "B", "C", "N", "O", "F", "Ne", "Na", "Mg", 
          "Al", "Si", "P", "S", "Cl", "Ar", "K", "Ca", "Sc", "Ti", "V", "Cr", 
          "Mn", "Fe", "Co", "Ni", "Cu", "Zn", "Ga", "Ge", "As", "Se", "Br", 
          "Kr", "Rb", "Sr", "Y", "Zr", "Nb", "Mo", "Tc", "Ru", "Rh", "Pd", 
          "Ag", "Cd", "In", "Sn", "Sb", "Te", "I", "Xe", "Cs", "Ba", "La", 
          "Ce", "Pr", "Nd", "Pm", "Sm", "Eu", "Gd", "Tb", "Dy", "Ho", "Er", 
          "Tm", "Yb", "Lu", "Hf", "Ta", "W", "Re", "Os", "Ir", "Pt", "Au", 
          "Hg", "Tl", "Pb", "Bi", "Po", "At", "Rn", "Fr", "Ra", "Ac", "Th", 
          "Pa", "U", "Np", "Pu", "Am", "Cm", "Bk", "Cf", "Es", "Fm", "Md", 
          "No", "Lr", "Rf", "Db", "Sg", "Bh", "Hs", "Mt", "Ds", "Rg", "Cn", 
          "Nh", "Fl", "Mc", "Lv", "Ts", "Og", "Uub", "Uut", "Uuq", "Uup", 
          "Uuh", "Uus", "Uuo"}, {
         "h", "he", "li", "be", "b", "c", "n", "o", "f", "ne", "na", "mg", 
          "al", "si", "p", "s", "cl", "ar", "k", "ca", "sc", "ti", "v", "cr", 
          "mn", "fe", "co", "ni", "cu", "zn", "ga", "ge", "as", "se", "br", 
          "kr", "rb", "sr", "y", "zr", "nb", "mo", "tc", "ru", "rh", "pd", 
          "ag", "cd", "in", "sn", "sb", "te", "i", "xe", "cs", "ba", "la", 
          "ce", "pr", "nd", "pm", "sm", "eu", "gd", "tb", "dy", "ho", "er", 
          "tm", "yb", "lu", "hf", "ta", "w", "re", "os", "ir", "pt", "au", 
          "hg", "tl", "pb", "bi", "po", "at", "rn", "fr", "ra", "ac", "th", 
          "pa", "u", "np", "pu", "am", "cm", "bk", "cf", "es", "fm", "md", 
          "no", "lr", "rf", "db", "sg", "bh", "hs", "mt", "ds", "rg", "cn", 
          "nh", "fl", "mc", "lv", "ts", "og", "uub", "uut", "uuq", "uup", 
          "uuh", "uus", "uuo"}}, Replace[#, 
         Dispatch[{
          "h" -> RGBColor[0.65, 0.7, 0.7], "he" -> RGBColor[0.836713, 1., 1.],
            "li" -> RGBColor[0.799435, 0.543572, 0.997559], "be" -> 
           RGBColor[0.770565, 0.964309, 0.0442359], "b" -> 
           RGBColor[1., 0.709804, 0.709804], "c" -> RGBColor[0.4, 0.4, 0.4], 
           "n" -> RGBColor[0.291989, 0.437977, 0.888609], "o" -> 
           RGBColor[0.800498, 0.201504, 0.192061], "f" -> 
           RGBColor[0.578462, 0.85539, 0.408855], "ne" -> 
           RGBColor[0.677263, 0.928423, 0.955287], "na" -> 
           RGBColor[0.658708, 0.492173, 0.842842], "mg" -> 
           RGBColor[0.628274, 0.850553, 0.0782731], "al" -> 
           RGBColor[0.8913, 0.631904, 0.627399], "si" -> 
           RGBColor[0.941176, 0.784314, 0.627451], "p" -> 
           RGBColor[1., 0.501961, 0], "s" -> 
           RGBColor[0.90443, 0.97015, 0.13504], "cl" -> 
           RGBColor[0.412698, 0.932689, 0.166398], "ar" -> 
           RGBColor[0.546138, 0.844244, 0.892092], "k" -> 
           RGBColor[0.534026, 0.420729, 0.705621], "ca" -> 
           RGBColor[0.480072, 0.744591, 0.0955222], "sc" -> 
           RGBColor[0.901961, 0.901961, 0.901961], "ti" -> 
           RGBColor[0.74902, 0.760784, 0.780392], "v" -> 
           RGBColor[0.65098, 0.65098, 0.670588], "cr" -> 
           RGBColor[0.541176, 0.6, 0.780392], "mn" -> 
           RGBColor[0.611765, 0.478431, 0.780392], "fe" -> 
           RGBColor[0.878431, 0.4, 0.2], "co" -> 
           RGBColor[0.941176, 0.564706, 0.627451], "ni" -> 
           RGBColor[0.313725, 0.815686, 0.313725], "cu" -> 
           RGBColor[0.784314, 0.501961, 0.2], "zn" -> 
           RGBColor[0.490196, 0.501961, 0.690196], "ga" -> 
           RGBColor[0.800757, 0.542666, 0.533513], "ge" -> 
           RGBColor[0.60508, 0.632465, 0.576489], "as" -> 
           RGBColor[0.741176, 0.501961, 0.890196], "se" -> 
           RGBColor[0.917248, 0.657833, 0.0706628], "br" -> 
           RGBColor[0.58847, 0.22163, 0.16064], "kr" -> 
           RGBColor[0.426019, 0.747462, 0.810413], "rb" -> 
           RGBColor[0.425391, 0.329242, 0.585895], "sr" -> 
           RGBColor[0.325959, 0.646423, 0.095983], "y" -> 
           RGBColor[0.531014, 1., 1.], "zr" -> 
           RGBColor[0.458599, 0.917466, 0.918573], "nb" -> 
           RGBColor[0.385036, 0.834854, 0.841681], "mo" -> 
           RGBColor[0.310325, 0.752163, 0.769323], "tc" -> 
           RGBColor[0.234466, 0.669394, 0.701499], "ru" -> 
           RGBColor[0.157459, 0.586546, 0.638209], "rh" -> 
           RGBColor[0.0793033, 0.50362, 0.579453], "pd" -> 
           RGBColor[0., 0.420615, 0.525231], "ag" -> 
           RGBColor[0.752941, 0.752941, 0.752941], "cd" -> 
           RGBColor[1., 0.85098, 0.560784], "in" -> 
           RGBColor[0.728371, 0.440594, 0.422196], "sn" -> 
           RGBColor[0.39799, 0.491477, 0.495586], "sb" -> 
           RGBColor[0.619608, 0.388235, 0.709804], "te" -> 
           RGBColor[0.816706, 0.451332, 0.0100947], "i" -> 
           RGBColor[0.580392, 0, 0.580392], "xe" -> 
           RGBColor[0.316906, 0.638078, 0.710252], "cs" -> 
           RGBColor[0.332803, 0.217712, 0.483666], "ba" -> 
           RGBColor[0.165935, 0.55605, 0.0796556], "la" -> 
           RGBColor[0.928084, 0.716075, 0.329427], "ce" -> 
           RGBColor[0.894824, 0.731424, 0.325131], "pr" -> 
           RGBColor[0.86523, 0.707999, 0.315261], "nd" -> 
           RGBColor[0.837836, 0.662974, 0.301635], "pm" -> 
           RGBColor[0.811992, 0.607859, 0.285626], "sm" -> 
           RGBColor[0.787563, 0.549894, 0.268279], "eu" -> 
           RGBColor[0.764628, 0.493261, 0.250405], "gd" -> 
           RGBColor[0.743177, 0.440115, 0.23269], "tb" -> 
           RGBColor[0.72281, 0.39143, 0.215783], "dy" -> 
           RGBColor[0.702434, 0.347663, 0.200392], "ho" -> 
           RGBColor[0.679962, 0.309234, 0.187368], "er" -> 
           RGBColor[0.652012, 0.276823, 0.17779], "tm" -> 
           RGBColor[0.613603, 0.251489, 0.173042], "yb" -> 
           RGBColor[0.557855, 0.234598, 0.17489], "lu" -> 
           RGBColor[0.475685, 0.227573, 0.18555], "hf" -> 
           RGBColor[0.781537, 0.717388, 0.716579], "ta" -> 
           RGBColor[0.734443, 0.544489, 0.683471], "w" -> 
           RGBColor[0.681179, 0.360409, 0.63675], "re" -> 
           RGBColor[0.605181, 0.367584, 0.556343], "os" -> 
           RGBColor[0.521806, 0.382125, 0.469204], "ir" -> 
           RGBColor[0.445624, 0.373159, 0.399069], "pt" -> 
           RGBColor[0.815686, 0.815686, 0.878431], "au" -> 
           RGBColor[1., 0.819608, 0.137255], "hg" -> 
           RGBColor[0.721569, 0.721569, 0.815686], "tl" -> 
           RGBColor[0.65098, 0.329412, 0.301961], "pb" -> 
           RGBColor[0.341176, 0.34902, 0.380392], "bi" -> 
           RGBColor[0.619608, 0.309804, 0.709804], "po" -> 
           RGBColor[0.670588, 0.360784, 0], "at" -> 
           RGBColor[0.458824, 0.309804, 0.270588], "rn" -> 
           RGBColor[0.218799, 0.516091, 0.591608], "fr" -> 
           RGBColor[0.25626, 0.0861372, 0.398932], "ra" -> 
           RGBColor[0., 0.473472, 0.04654], "ac" -> 
           RGBColor[0.322042, 0.71693, 0.988479], "th" -> 
           RGBColor[0.3608, 0.67166, 0.943003], "pa" -> 
           RGBColor[0.397469, 0.628, 0.898853], "u" -> 
           RGBColor[0.43205, 0.58595, 0.856029], "np" -> 
           RGBColor[0.464542, 0.54551, 0.814532], "pu" -> 
           RGBColor[0.494945, 0.506679, 0.774361], "am" -> 
           RGBColor[0.52326, 0.469458, 0.735517], "cm" -> 
           RGBColor[0.549486, 0.433847, 0.697999], "bk" -> 
           RGBColor[0.573624, 0.399845, 0.661808], "cf" -> 
           RGBColor[0.595673, 0.367454, 0.626942], "es" -> 
           RGBColor[0.615633, 0.336672, 0.593404], "fm" -> 
           RGBColor[0.633505, 0.307499, 0.561191], "md" -> 
           RGBColor[0.649288, 0.279937, 0.530305], "no" -> 
           RGBColor[0.662982, 0.253984, 0.500746], "lr" -> 
           RGBColor[0.674588, 0.22964, 0.472513], "rf" -> 
           RGBColor[0.684106, 0.206907, 0.445606], "db" -> 
           RGBColor[0.691534, 0.185783, 0.420025], "sg" -> 
           RGBColor[0.696874, 0.166269, 0.395772], "bh" -> 
           RGBColor[0.700126, 0.148365, 0.372844], "hs" -> 
           RGBColor[0.701289, 0.13207, 0.351243], "mt" -> 
           RGBColor[0.700363, 0.117385, 0.330968], "ds" -> 
           RGBColor[0.697348, 0.10431, 0.31202], "rg" -> 
           RGBColor[0.692245, 0.0928444, 0.294398], "cn" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "nh" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "fl" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "mc" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "lv" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "ts" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "og" -> 
           RGBColor[0.635401, 0.0528, 0.226184], "uub" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "uut" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "uuq" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "uup" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "uuh" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "uus" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "uuo" -> 
           RGBColor[0.635401, 0.0528, 0.226184]}]]& ][0.85], 
       ColorDataFunction[
       "Atoms", 
        "Named", {{
         "H", "He", "Li", "Be", "B", "C", "N", "O", "F", "Ne", "Na", "Mg", 
          "Al", "Si", "P", "S", "Cl", "Ar", "K", "Ca", "Sc", "Ti", "V", "Cr", 
          "Mn", "Fe", "Co", "Ni", "Cu", "Zn", "Ga", "Ge", "As", "Se", "Br", 
          "Kr", "Rb", "Sr", "Y", "Zr", "Nb", "Mo", "Tc", "Ru", "Rh", "Pd", 
          "Ag", "Cd", "In", "Sn", "Sb", "Te", "I", "Xe", "Cs", "Ba", "La", 
          "Ce", "Pr", "Nd", "Pm", "Sm", "Eu", "Gd", "Tb", "Dy", "Ho", "Er", 
          "Tm", "Yb", "Lu", "Hf", "Ta", "W", "Re", "Os", "Ir", "Pt", "Au", 
          "Hg", "Tl", "Pb", "Bi", "Po", "At", "Rn", "Fr", "Ra", "Ac", "Th", 
          "Pa", "U", "Np", "Pu", "Am", "Cm", "Bk", "Cf", "Es", "Fm", "Md", 
          "No", "Lr", "Rf", "Db", "Sg", "Bh", "Hs", "Mt", "Ds", "Rg", "Cn", 
          "Nh", "Fl", "Mc", "Lv", "Ts", "Og", "Uub", "Uut", "Uuq", "Uup", 
          "Uuh", "Uus", "Uuo"}, {
         "h", "he", "li", "be", "b", "c", "n", "o", "f", "ne", "na", "mg", 
          "al", "si", "p", "s", "cl", "ar", "k", "ca", "sc", "ti", "v", "cr", 
          "mn", "fe", "co", "ni", "cu", "zn", "ga", "ge", "as", "se", "br", 
          "kr", "rb", "sr", "y", "zr", "nb", "mo", "tc", "ru", "rh", "pd", 
          "ag", "cd", "in", "sn", "sb", "te", "i", "xe", "cs", "ba", "la", 
          "ce", "pr", "nd", "pm", "sm", "eu", "gd", "tb", "dy", "ho", "er", 
          "tm", "yb", "lu", "hf", "ta", "w", "re", "os", "ir", "pt", "au", 
          "hg", "tl", "pb", "bi", "po", "at", "rn", "fr", "ra", "ac", "th", 
          "pa", "u", "np", "pu", "am", "cm", "bk", "cf", "es", "fm", "md", 
          "no", "lr", "rf", "db", "sg", "bh", "hs", "mt", "ds", "rg", "cn", 
          "nh", "fl", "mc", "lv", "ts", "og", "uub", "uut", "uuq", "uup", 
          "uuh", "uus", "uuo"}}, Replace[#, 
         Dispatch[{
          "h" -> RGBColor[0.65, 0.7, 0.7], "he" -> RGBColor[0.836713, 1., 1.],
            "li" -> RGBColor[0.799435, 0.543572, 0.997559], "be" -> 
           RGBColor[0.770565, 0.964309, 0.0442359], "b" -> 
           RGBColor[1., 0.709804, 0.709804], "c" -> RGBColor[0.4, 0.4, 0.4], 
           "n" -> RGBColor[0.291989, 0.437977, 0.888609], "o" -> 
           RGBColor[0.800498, 0.201504, 0.192061], "f" -> 
           RGBColor[0.578462, 0.85539, 0.408855], "ne" -> 
           RGBColor[0.677263, 0.928423, 0.955287], "na" -> 
           RGBColor[0.658708, 0.492173, 0.842842], "mg" -> 
           RGBColor[0.628274, 0.850553, 0.0782731], "al" -> 
           RGBColor[0.8913, 0.631904, 0.627399], "si" -> 
           RGBColor[0.941176, 0.784314, 0.627451], "p" -> 
           RGBColor[1., 0.501961, 0], "s" -> 
           RGBColor[0.90443, 0.97015, 0.13504], "cl" -> 
           RGBColor[0.412698, 0.932689, 0.166398], "ar" -> 
           RGBColor[0.546138, 0.844244, 0.892092], "k" -> 
           RGBColor[0.534026, 0.420729, 0.705621], "ca" -> 
           RGBColor[0.480072, 0.744591, 0.0955222], "sc" -> 
           RGBColor[0.901961, 0.901961, 0.901961], "ti" -> 
           RGBColor[0.74902, 0.760784, 0.780392], "v" -> 
           RGBColor[0.65098, 0.65098, 0.670588], "cr" -> 
           RGBColor[0.541176, 0.6, 0.780392], "mn" -> 
           RGBColor[0.611765, 0.478431, 0.780392], "fe" -> 
           RGBColor[0.878431, 0.4, 0.2], "co" -> 
           RGBColor[0.941176, 0.564706, 0.627451], "ni" -> 
           RGBColor[0.313725, 0.815686, 0.313725], "cu" -> 
           RGBColor[0.784314, 0.501961, 0.2], "zn" -> 
           RGBColor[0.490196, 0.501961, 0.690196], "ga" -> 
           RGBColor[0.800757, 0.542666, 0.533513], "ge" -> 
           RGBColor[0.60508, 0.632465, 0.576489], "as" -> 
           RGBColor[0.741176, 0.501961, 0.890196], "se" -> 
           RGBColor[0.917248, 0.657833, 0.0706628], "br" -> 
           RGBColor[0.58847, 0.22163, 0.16064], "kr" -> 
           RGBColor[0.426019, 0.747462, 0.810413], "rb" -> 
           RGBColor[0.425391, 0.329242, 0.585895], "sr" -> 
           RGBColor[0.325959, 0.646423, 0.095983], "y" -> 
           RGBColor[0.531014, 1., 1.], "zr" -> 
           RGBColor[0.458599, 0.917466, 0.918573], "nb" -> 
           RGBColor[0.385036, 0.834854, 0.841681], "mo" -> 
           RGBColor[0.310325, 0.752163, 0.769323], "tc" -> 
           RGBColor[0.234466, 0.669394, 0.701499], "ru" -> 
           RGBColor[0.157459, 0.586546, 0.638209], "rh" -> 
           RGBColor[0.0793033, 0.50362, 0.579453], "pd" -> 
           RGBColor[0., 0.420615, 0.525231], "ag" -> 
           RGBColor[0.752941, 0.752941, 0.752941], "cd" -> 
           RGBColor[1., 0.85098, 0.560784], "in" -> 
           RGBColor[0.728371, 0.440594, 0.422196], "sn" -> 
           RGBColor[0.39799, 0.491477, 0.495586], "sb" -> 
           RGBColor[0.619608, 0.388235, 0.709804], "te" -> 
           RGBColor[0.816706, 0.451332, 0.0100947], "i" -> 
           RGBColor[0.580392, 0, 0.580392], "xe" -> 
           RGBColor[0.316906, 0.638078, 0.710252], "cs" -> 
           RGBColor[0.332803, 0.217712, 0.483666], "ba" -> 
           RGBColor[0.165935, 0.55605, 0.0796556], "la" -> 
           RGBColor[0.928084, 0.716075, 0.329427], "ce" -> 
           RGBColor[0.894824, 0.731424, 0.325131], "pr" -> 
           RGBColor[0.86523, 0.707999, 0.315261], "nd" -> 
           RGBColor[0.837836, 0.662974, 0.301635], "pm" -> 
           RGBColor[0.811992, 0.607859, 0.285626], "sm" -> 
           RGBColor[0.787563, 0.549894, 0.268279], "eu" -> 
           RGBColor[0.764628, 0.493261, 0.250405], "gd" -> 
           RGBColor[0.743177, 0.440115, 0.23269], "tb" -> 
           RGBColor[0.72281, 0.39143, 0.215783], "dy" -> 
           RGBColor[0.702434, 0.347663, 0.200392], "ho" -> 
           RGBColor[0.679962, 0.309234, 0.187368], "er" -> 
           RGBColor[0.652012, 0.276823, 0.17779], "tm" -> 
           RGBColor[0.613603, 0.251489, 0.173042], "yb" -> 
           RGBColor[0.557855, 0.234598, 0.17489], "lu" -> 
           RGBColor[0.475685, 0.227573, 0.18555], "hf" -> 
           RGBColor[0.781537, 0.717388, 0.716579], "ta" -> 
           RGBColor[0.734443, 0.544489, 0.683471], "w" -> 
           RGBColor[0.681179, 0.360409, 0.63675], "re" -> 
           RGBColor[0.605181, 0.367584, 0.556343], "os" -> 
           RGBColor[0.521806, 0.382125, 0.469204], "ir" -> 
           RGBColor[0.445624, 0.373159, 0.399069], "pt" -> 
           RGBColor[0.815686, 0.815686, 0.878431], "au" -> 
           RGBColor[1., 0.819608, 0.137255], "hg" -> 
           RGBColor[0.721569, 0.721569, 0.815686], "tl" -> 
           RGBColor[0.65098, 0.329412, 0.301961], "pb" -> 
           RGBColor[0.341176, 0.34902, 0.380392], "bi" -> 
           RGBColor[0.619608, 0.309804, 0.709804], "po" -> 
           RGBColor[0.670588, 0.360784, 0], "at" -> 
           RGBColor[0.458824, 0.309804, 0.270588], "rn" -> 
           RGBColor[0.218799, 0.516091, 0.591608], "fr" -> 
           RGBColor[0.25626, 0.0861372, 0.398932], "ra" -> 
           RGBColor[0., 0.473472, 0.04654], "ac" -> 
           RGBColor[0.322042, 0.71693, 0.988479], "th" -> 
           RGBColor[0.3608, 0.67166, 0.943003], "pa" -> 
           RGBColor[0.397469, 0.628, 0.898853], "u" -> 
           RGBColor[0.43205, 0.58595, 0.856029], "np" -> 
           RGBColor[0.464542, 0.54551, 0.814532], "pu" -> 
           RGBColor[0.494945, 0.506679, 0.774361], "am" -> 
           RGBColor[0.52326, 0.469458, 0.735517], "cm" -> 
           RGBColor[0.549486, 0.433847, 0.697999], "bk" -> 
           RGBColor[0.573624, 0.399845, 0.661808], "cf" -> 
           RGBColor[0.595673, 0.367454, 0.626942], "es" -> 
           RGBColor[0.615633, 0.336672, 0.593404], "fm" -> 
           RGBColor[0.633505, 0.307499, 0.561191], "md" -> 
           RGBColor[0.649288, 0.279937, 0.530305], "no" -> 
           RGBColor[0.662982, 0.253984, 0.500746], "lr" -> 
           RGBColor[0.674588, 0.22964, 0.472513], "rf" -> 
           RGBColor[0.684106, 0.206907, 0.445606], "db" -> 
           RGBColor[0.691534, 0.185783, 0.420025], "sg" -> 
           RGBColor[0.696874, 0.166269, 0.395772], "bh" -> 
           RGBColor[0.700126, 0.148365, 0.372844], "hs" -> 
           RGBColor[0.701289, 0.13207, 0.351243], "mt" -> 
           RGBColor[0.700363, 0.117385, 0.330968], "ds" -> 
           RGBColor[0.697348, 0.10431, 0.31202], "rg" -> 
           RGBColor[0.692245, 0.0928444, 0.294398], "cn" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "nh" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "fl" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "mc" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "lv" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "ts" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "og" -> 
           RGBColor[0.635401, 0.0528, 0.226184], "uub" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "uut" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "uuq" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "uup" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "uuh" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "uus" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "uuo" -> 
           RGBColor[0.635401, 0.0528, 0.226184]}]]& ][0.85], 
       ColorDataFunction[
       "Atoms", 
        "Named", {{
         "H", "He", "Li", "Be", "B", "C", "N", "O", "F", "Ne", "Na", "Mg", 
          "Al", "Si", "P", "S", "Cl", "Ar", "K", "Ca", "Sc", "Ti", "V", "Cr", 
          "Mn", "Fe", "Co", "Ni", "Cu", "Zn", "Ga", "Ge", "As", "Se", "Br", 
          "Kr", "Rb", "Sr", "Y", "Zr", "Nb", "Mo", "Tc", "Ru", "Rh", "Pd", 
          "Ag", "Cd", "In", "Sn", "Sb", "Te", "I", "Xe", "Cs", "Ba", "La", 
          "Ce", "Pr", "Nd", "Pm", "Sm", "Eu", "Gd", "Tb", "Dy", "Ho", "Er", 
          "Tm", "Yb", "Lu", "Hf", "Ta", "W", "Re", "Os", "Ir", "Pt", "Au", 
          "Hg", "Tl", "Pb", "Bi", "Po", "At", "Rn", "Fr", "Ra", "Ac", "Th", 
          "Pa", "U", "Np", "Pu", "Am", "Cm", "Bk", "Cf", "Es", "Fm", "Md", 
          "No", "Lr", "Rf", "Db", "Sg", "Bh", "Hs", "Mt", "Ds", "Rg", "Cn", 
          "Nh", "Fl", "Mc", "Lv", "Ts", "Og", "Uub", "Uut", "Uuq", "Uup", 
          "Uuh", "Uus", "Uuo"}, {
         "h", "he", "li", "be", "b", "c", "n", "o", "f", "ne", "na", "mg", 
          "al", "si", "p", "s", "cl", "ar", "k", "ca", "sc", "ti", "v", "cr", 
          "mn", "fe", "co", "ni", "cu", "zn", "ga", "ge", "as", "se", "br", 
          "kr", "rb", "sr", "y", "zr", "nb", "mo", "tc", "ru", "rh", "pd", 
          "ag", "cd", "in", "sn", "sb", "te", "i", "xe", "cs", "ba", "la", 
          "ce", "pr", "nd", "pm", "sm", "eu", "gd", "tb", "dy", "ho", "er", 
          "tm", "yb", "lu", "hf", "ta", "w", "re", "os", "ir", "pt", "au", 
          "hg", "tl", "pb", "bi", "po", "at", "rn", "fr", "ra", "ac", "th", 
          "pa", "u", "np", "pu", "am", "cm", "bk", "cf", "es", "fm", "md", 
          "no", "lr", "rf", "db", "sg", "bh", "hs", "mt", "ds", "rg", "cn", 
          "nh", "fl", "mc", "lv", "ts", "og", "uub", "uut", "uuq", "uup", 
          "uuh", "uus", "uuo"}}, Replace[#, 
         Dispatch[{
          "h" -> RGBColor[0.65, 0.7, 0.7], "he" -> RGBColor[0.836713, 1., 1.],
            "li" -> RGBColor[0.799435, 0.543572, 0.997559], "be" -> 
           RGBColor[0.770565, 0.964309, 0.0442359], "b" -> 
           RGBColor[1., 0.709804, 0.709804], "c" -> RGBColor[0.4, 0.4, 0.4], 
           "n" -> RGBColor[0.291989, 0.437977, 0.888609], "o" -> 
           RGBColor[0.800498, 0.201504, 0.192061], "f" -> 
           RGBColor[0.578462, 0.85539, 0.408855], "ne" -> 
           RGBColor[0.677263, 0.928423, 0.955287], "na" -> 
           RGBColor[0.658708, 0.492173, 0.842842], "mg" -> 
           RGBColor[0.628274, 0.850553, 0.0782731], "al" -> 
           RGBColor[0.8913, 0.631904, 0.627399], "si" -> 
           RGBColor[0.941176, 0.784314, 0.627451], "p" -> 
           RGBColor[1., 0.501961, 0], "s" -> 
           RGBColor[0.90443, 0.97015, 0.13504], "cl" -> 
           RGBColor[0.412698, 0.932689, 0.166398], "ar" -> 
           RGBColor[0.546138, 0.844244, 0.892092], "k" -> 
           RGBColor[0.534026, 0.420729, 0.705621], "ca" -> 
           RGBColor[0.480072, 0.744591, 0.0955222], "sc" -> 
           RGBColor[0.901961, 0.901961, 0.901961], "ti" -> 
           RGBColor[0.74902, 0.760784, 0.780392], "v" -> 
           RGBColor[0.65098, 0.65098, 0.670588], "cr" -> 
           RGBColor[0.541176, 0.6, 0.780392], "mn" -> 
           RGBColor[0.611765, 0.478431, 0.780392], "fe" -> 
           RGBColor[0.878431, 0.4, 0.2], "co" -> 
           RGBColor[0.941176, 0.564706, 0.627451], "ni" -> 
           RGBColor[0.313725, 0.815686, 0.313725], "cu" -> 
           RGBColor[0.784314, 0.501961, 0.2], "zn" -> 
           RGBColor[0.490196, 0.501961, 0.690196], "ga" -> 
           RGBColor[0.800757, 0.542666, 0.533513], "ge" -> 
           RGBColor[0.60508, 0.632465, 0.576489], "as" -> 
           RGBColor[0.741176, 0.501961, 0.890196], "se" -> 
           RGBColor[0.917248, 0.657833, 0.0706628], "br" -> 
           RGBColor[0.58847, 0.22163, 0.16064], "kr" -> 
           RGBColor[0.426019, 0.747462, 0.810413], "rb" -> 
           RGBColor[0.425391, 0.329242, 0.585895], "sr" -> 
           RGBColor[0.325959, 0.646423, 0.095983], "y" -> 
           RGBColor[0.531014, 1., 1.], "zr" -> 
           RGBColor[0.458599, 0.917466, 0.918573], "nb" -> 
           RGBColor[0.385036, 0.834854, 0.841681], "mo" -> 
           RGBColor[0.310325, 0.752163, 0.769323], "tc" -> 
           RGBColor[0.234466, 0.669394, 0.701499], "ru" -> 
           RGBColor[0.157459, 0.586546, 0.638209], "rh" -> 
           RGBColor[0.0793033, 0.50362, 0.579453], "pd" -> 
           RGBColor[0., 0.420615, 0.525231], "ag" -> 
           RGBColor[0.752941, 0.752941, 0.752941], "cd" -> 
           RGBColor[1., 0.85098, 0.560784], "in" -> 
           RGBColor[0.728371, 0.440594, 0.422196], "sn" -> 
           RGBColor[0.39799, 0.491477, 0.495586], "sb" -> 
           RGBColor[0.619608, 0.388235, 0.709804], "te" -> 
           RGBColor[0.816706, 0.451332, 0.0100947], "i" -> 
           RGBColor[0.580392, 0, 0.580392], "xe" -> 
           RGBColor[0.316906, 0.638078, 0.710252], "cs" -> 
           RGBColor[0.332803, 0.217712, 0.483666], "ba" -> 
           RGBColor[0.165935, 0.55605, 0.0796556], "la" -> 
           RGBColor[0.928084, 0.716075, 0.329427], "ce" -> 
           RGBColor[0.894824, 0.731424, 0.325131], "pr" -> 
           RGBColor[0.86523, 0.707999, 0.315261], "nd" -> 
           RGBColor[0.837836, 0.662974, 0.301635], "pm" -> 
           RGBColor[0.811992, 0.607859, 0.285626], "sm" -> 
           RGBColor[0.787563, 0.549894, 0.268279], "eu" -> 
           RGBColor[0.764628, 0.493261, 0.250405], "gd" -> 
           RGBColor[0.743177, 0.440115, 0.23269], "tb" -> 
           RGBColor[0.72281, 0.39143, 0.215783], "dy" -> 
           RGBColor[0.702434, 0.347663, 0.200392], "ho" -> 
           RGBColor[0.679962, 0.309234, 0.187368], "er" -> 
           RGBColor[0.652012, 0.276823, 0.17779], "tm" -> 
           RGBColor[0.613603, 0.251489, 0.173042], "yb" -> 
           RGBColor[0.557855, 0.234598, 0.17489], "lu" -> 
           RGBColor[0.475685, 0.227573, 0.18555], "hf" -> 
           RGBColor[0.781537, 0.717388, 0.716579], "ta" -> 
           RGBColor[0.734443, 0.544489, 0.683471], "w" -> 
           RGBColor[0.681179, 0.360409, 0.63675], "re" -> 
           RGBColor[0.605181, 0.367584, 0.556343], "os" -> 
           RGBColor[0.521806, 0.382125, 0.469204], "ir" -> 
           RGBColor[0.445624, 0.373159, 0.399069], "pt" -> 
           RGBColor[0.815686, 0.815686, 0.878431], "au" -> 
           RGBColor[1., 0.819608, 0.137255], "hg" -> 
           RGBColor[0.721569, 0.721569, 0.815686], "tl" -> 
           RGBColor[0.65098, 0.329412, 0.301961], "pb" -> 
           RGBColor[0.341176, 0.34902, 0.380392], "bi" -> 
           RGBColor[0.619608, 0.309804, 0.709804], "po" -> 
           RGBColor[0.670588, 0.360784, 0], "at" -> 
           RGBColor[0.458824, 0.309804, 0.270588], "rn" -> 
           RGBColor[0.218799, 0.516091, 0.591608], "fr" -> 
           RGBColor[0.25626, 0.0861372, 0.398932], "ra" -> 
           RGBColor[0., 0.473472, 0.04654], "ac" -> 
           RGBColor[0.322042, 0.71693, 0.988479], "th" -> 
           RGBColor[0.3608, 0.67166, 0.943003], "pa" -> 
           RGBColor[0.397469, 0.628, 0.898853], "u" -> 
           RGBColor[0.43205, 0.58595, 0.856029], "np" -> 
           RGBColor[0.464542, 0.54551, 0.814532], "pu" -> 
           RGBColor[0.494945, 0.506679, 0.774361], "am" -> 
           RGBColor[0.52326, 0.469458, 0.735517], "cm" -> 
           RGBColor[0.549486, 0.433847, 0.697999], "bk" -> 
           RGBColor[0.573624, 0.399845, 0.661808], "cf" -> 
           RGBColor[0.595673, 0.367454, 0.626942], "es" -> 
           RGBColor[0.615633, 0.336672, 0.593404], "fm" -> 
           RGBColor[0.633505, 0.307499, 0.561191], "md" -> 
           RGBColor[0.649288, 0.279937, 0.530305], "no" -> 
           RGBColor[0.662982, 0.253984, 0.500746], "lr" -> 
           RGBColor[0.674588, 0.22964, 0.472513], "rf" -> 
           RGBColor[0.684106, 0.206907, 0.445606], "db" -> 
           RGBColor[0.691534, 0.185783, 0.420025], "sg" -> 
           RGBColor[0.696874, 0.166269, 0.395772], "bh" -> 
           RGBColor[0.700126, 0.148365, 0.372844], "hs" -> 
           RGBColor[0.701289, 0.13207, 0.351243], "mt" -> 
           RGBColor[0.700363, 0.117385, 0.330968], "ds" -> 
           RGBColor[0.697348, 0.10431, 0.31202], "rg" -> 
           RGBColor[0.692245, 0.0928444, 0.294398], "cn" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "nh" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "fl" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "mc" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "lv" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "ts" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "og" -> 
           RGBColor[0.635401, 0.0528, 0.226184], "uub" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "uut" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "uuq" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "uup" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "uuh" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "uus" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "uuo" -> 
           RGBColor[0.635401, 0.0528, 0.226184]}]]& ][0.85], 
       ColorDataFunction[
       "Atoms", 
        "Named", {{
         "H", "He", "Li", "Be", "B", "C", "N", "O", "F", "Ne", "Na", "Mg", 
          "Al", "Si", "P", "S", "Cl", "Ar", "K", "Ca", "Sc", "Ti", "V", "Cr", 
          "Mn", "Fe", "Co", "Ni", "Cu", "Zn", "Ga", "Ge", "As", "Se", "Br", 
          "Kr", "Rb", "Sr", "Y", "Zr", "Nb", "Mo", "Tc", "Ru", "Rh", "Pd", 
          "Ag", "Cd", "In", "Sn", "Sb", "Te", "I", "Xe", "Cs", "Ba", "La", 
          "Ce", "Pr", "Nd", "Pm", "Sm", "Eu", "Gd", "Tb", "Dy", "Ho", "Er", 
          "Tm", "Yb", "Lu", "Hf", "Ta", "W", "Re", "Os", "Ir", "Pt", "Au", 
          "Hg", "Tl", "Pb", "Bi", "Po", "At", "Rn", "Fr", "Ra", "Ac", "Th", 
          "Pa", "U", "Np", "Pu", "Am", "Cm", "Bk", "Cf", "Es", "Fm", "Md", 
          "No", "Lr", "Rf", "Db", "Sg", "Bh", "Hs", "Mt", "Ds", "Rg", "Cn", 
          "Nh", "Fl", "Mc", "Lv", "Ts", "Og", "Uub", "Uut", "Uuq", "Uup", 
          "Uuh", "Uus", "Uuo"}, {
         "h", "he", "li", "be", "b", "c", "n", "o", "f", "ne", "na", "mg", 
          "al", "si", "p", "s", "cl", "ar", "k", "ca", "sc", "ti", "v", "cr", 
          "mn", "fe", "co", "ni", "cu", "zn", "ga", "ge", "as", "se", "br", 
          "kr", "rb", "sr", "y", "zr", "nb", "mo", "tc", "ru", "rh", "pd", 
          "ag", "cd", "in", "sn", "sb", "te", "i", "xe", "cs", "ba", "la", 
          "ce", "pr", "nd", "pm", "sm", "eu", "gd", "tb", "dy", "ho", "er", 
          "tm", "yb", "lu", "hf", "ta", "w", "re", "os", "ir", "pt", "au", 
          "hg", "tl", "pb", "bi", "po", "at", "rn", "fr", "ra", "ac", "th", 
          "pa", "u", "np", "pu", "am", "cm", "bk", "cf", "es", "fm", "md", 
          "no", "lr", "rf", "db", "sg", "bh", "hs", "mt", "ds", "rg", "cn", 
          "nh", "fl", "mc", "lv", "ts", "og", "uub", "uut", "uuq", "uup", 
          "uuh", "uus", "uuo"}}, Replace[#, 
         Dispatch[{
          "h" -> RGBColor[0.65, 0.7, 0.7], "he" -> RGBColor[0.836713, 1., 1.],
            "li" -> RGBColor[0.799435, 0.543572, 0.997559], "be" -> 
           RGBColor[0.770565, 0.964309, 0.0442359], "b" -> 
           RGBColor[1., 0.709804, 0.709804], "c" -> RGBColor[0.4, 0.4, 0.4], 
           "n" -> RGBColor[0.291989, 0.437977, 0.888609], "o" -> 
           RGBColor[0.800498, 0.201504, 0.192061], "f" -> 
           RGBColor[0.578462, 0.85539, 0.408855], "ne" -> 
           RGBColor[0.677263, 0.928423, 0.955287], "na" -> 
           RGBColor[0.658708, 0.492173, 0.842842], "mg" -> 
           RGBColor[0.628274, 0.850553, 0.0782731], "al" -> 
           RGBColor[0.8913, 0.631904, 0.627399], "si" -> 
           RGBColor[0.941176, 0.784314, 0.627451], "p" -> 
           RGBColor[1., 0.501961, 0], "s" -> 
           RGBColor[0.90443, 0.97015, 0.13504], "cl" -> 
           RGBColor[0.412698, 0.932689, 0.166398], "ar" -> 
           RGBColor[0.546138, 0.844244, 0.892092], "k" -> 
           RGBColor[0.534026, 0.420729, 0.705621], "ca" -> 
           RGBColor[0.480072, 0.744591, 0.0955222], "sc" -> 
           RGBColor[0.901961, 0.901961, 0.901961], "ti" -> 
           RGBColor[0.74902, 0.760784, 0.780392], "v" -> 
           RGBColor[0.65098, 0.65098, 0.670588], "cr" -> 
           RGBColor[0.541176, 0.6, 0.780392], "mn" -> 
           RGBColor[0.611765, 0.478431, 0.780392], "fe" -> 
           RGBColor[0.878431, 0.4, 0.2], "co" -> 
           RGBColor[0.941176, 0.564706, 0.627451], "ni" -> 
           RGBColor[0.313725, 0.815686, 0.313725], "cu" -> 
           RGBColor[0.784314, 0.501961, 0.2], "zn" -> 
           RGBColor[0.490196, 0.501961, 0.690196], "ga" -> 
           RGBColor[0.800757, 0.542666, 0.533513], "ge" -> 
           RGBColor[0.60508, 0.632465, 0.576489], "as" -> 
           RGBColor[0.741176, 0.501961, 0.890196], "se" -> 
           RGBColor[0.917248, 0.657833, 0.0706628], "br" -> 
           RGBColor[0.58847, 0.22163, 0.16064], "kr" -> 
           RGBColor[0.426019, 0.747462, 0.810413], "rb" -> 
           RGBColor[0.425391, 0.329242, 0.585895], "sr" -> 
           RGBColor[0.325959, 0.646423, 0.095983], "y" -> 
           RGBColor[0.531014, 1., 1.], "zr" -> 
           RGBColor[0.458599, 0.917466, 0.918573], "nb" -> 
           RGBColor[0.385036, 0.834854, 0.841681], "mo" -> 
           RGBColor[0.310325, 0.752163, 0.769323], "tc" -> 
           RGBColor[0.234466, 0.669394, 0.701499], "ru" -> 
           RGBColor[0.157459, 0.586546, 0.638209], "rh" -> 
           RGBColor[0.0793033, 0.50362, 0.579453], "pd" -> 
           RGBColor[0., 0.420615, 0.525231], "ag" -> 
           RGBColor[0.752941, 0.752941, 0.752941], "cd" -> 
           RGBColor[1., 0.85098, 0.560784], "in" -> 
           RGBColor[0.728371, 0.440594, 0.422196], "sn" -> 
           RGBColor[0.39799, 0.491477, 0.495586], "sb" -> 
           RGBColor[0.619608, 0.388235, 0.709804], "te" -> 
           RGBColor[0.816706, 0.451332, 0.0100947], "i" -> 
           RGBColor[0.580392, 0, 0.580392], "xe" -> 
           RGBColor[0.316906, 0.638078, 0.710252], "cs" -> 
           RGBColor[0.332803, 0.217712, 0.483666], "ba" -> 
           RGBColor[0.165935, 0.55605, 0.0796556], "la" -> 
           RGBColor[0.928084, 0.716075, 0.329427], "ce" -> 
           RGBColor[0.894824, 0.731424, 0.325131], "pr" -> 
           RGBColor[0.86523, 0.707999, 0.315261], "nd" -> 
           RGBColor[0.837836, 0.662974, 0.301635], "pm" -> 
           RGBColor[0.811992, 0.607859, 0.285626], "sm" -> 
           RGBColor[0.787563, 0.549894, 0.268279], "eu" -> 
           RGBColor[0.764628, 0.493261, 0.250405], "gd" -> 
           RGBColor[0.743177, 0.440115, 0.23269], "tb" -> 
           RGBColor[0.72281, 0.39143, 0.215783], "dy" -> 
           RGBColor[0.702434, 0.347663, 0.200392], "ho" -> 
           RGBColor[0.679962, 0.309234, 0.187368], "er" -> 
           RGBColor[0.652012, 0.276823, 0.17779], "tm" -> 
           RGBColor[0.613603, 0.251489, 0.173042], "yb" -> 
           RGBColor[0.557855, 0.234598, 0.17489], "lu" -> 
           RGBColor[0.475685, 0.227573, 0.18555], "hf" -> 
           RGBColor[0.781537, 0.717388, 0.716579], "ta" -> 
           RGBColor[0.734443, 0.544489, 0.683471], "w" -> 
           RGBColor[0.681179, 0.360409, 0.63675], "re" -> 
           RGBColor[0.605181, 0.367584, 0.556343], "os" -> 
           RGBColor[0.521806, 0.382125, 0.469204], "ir" -> 
           RGBColor[0.445624, 0.373159, 0.399069], "pt" -> 
           RGBColor[0.815686, 0.815686, 0.878431], "au" -> 
           RGBColor[1., 0.819608, 0.137255], "hg" -> 
           RGBColor[0.721569, 0.721569, 0.815686], "tl" -> 
           RGBColor[0.65098, 0.329412, 0.301961], "pb" -> 
           RGBColor[0.341176, 0.34902, 0.380392], "bi" -> 
           RGBColor[0.619608, 0.309804, 0.709804], "po" -> 
           RGBColor[0.670588, 0.360784, 0], "at" -> 
           RGBColor[0.458824, 0.309804, 0.270588], "rn" -> 
           RGBColor[0.218799, 0.516091, 0.591608], "fr" -> 
           RGBColor[0.25626, 0.0861372, 0.398932], "ra" -> 
           RGBColor[0., 0.473472, 0.04654], "ac" -> 
           RGBColor[0.322042, 0.71693, 0.988479], "th" -> 
           RGBColor[0.3608, 0.67166, 0.943003], "pa" -> 
           RGBColor[0.397469, 0.628, 0.898853], "u" -> 
           RGBColor[0.43205, 0.58595, 0.856029], "np" -> 
           RGBColor[0.464542, 0.54551, 0.814532], "pu" -> 
           RGBColor[0.494945, 0.506679, 0.774361], "am" -> 
           RGBColor[0.52326, 0.469458, 0.735517], "cm" -> 
           RGBColor[0.549486, 0.433847, 0.697999], "bk" -> 
           RGBColor[0.573624, 0.399845, 0.661808], "cf" -> 
           RGBColor[0.595673, 0.367454, 0.626942], "es" -> 
           RGBColor[0.615633, 0.336672, 0.593404], "fm" -> 
           RGBColor[0.633505, 0.307499, 0.561191], "md" -> 
           RGBColor[0.649288, 0.279937, 0.530305], "no" -> 
           RGBColor[0.662982, 0.253984, 0.500746], "lr" -> 
           RGBColor[0.674588, 0.22964, 0.472513], "rf" -> 
           RGBColor[0.684106, 0.206907, 0.445606], "db" -> 
           RGBColor[0.691534, 0.185783, 0.420025], "sg" -> 
           RGBColor[0.696874, 0.166269, 0.395772], "bh" -> 
           RGBColor[0.700126, 0.148365, 0.372844], "hs" -> 
           RGBColor[0.701289, 0.13207, 0.351243], "mt" -> 
           RGBColor[0.700363, 0.117385, 0.330968], "ds" -> 
           RGBColor[0.697348, 0.10431, 0.31202], "rg" -> 
           RGBColor[0.692245, 0.0928444, 0.294398], "cn" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "nh" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "fl" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "mc" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "lv" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "ts" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "og" -> 
           RGBColor[0.635401, 0.0528, 0.226184], "uub" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "uut" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "uuq" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "uup" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "uuh" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "uus" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "uuo" -> 
           RGBColor[0.635401, 0.0528, 0.226184]}]]& ][0.85], 
       ColorDataFunction[
       "Atoms", 
        "Named", {{
         "H", "He", "Li", "Be", "B", "C", "N", "O", "F", "Ne", "Na", "Mg", 
          "Al", "Si", "P", "S", "Cl", "Ar", "K", "Ca", "Sc", "Ti", "V", "Cr", 
          "Mn", "Fe", "Co", "Ni", "Cu", "Zn", "Ga", "Ge", "As", "Se", "Br", 
          "Kr", "Rb", "Sr", "Y", "Zr", "Nb", "Mo", "Tc", "Ru", "Rh", "Pd", 
          "Ag", "Cd", "In", "Sn", "Sb", "Te", "I", "Xe", "Cs", "Ba", "La", 
          "Ce", "Pr", "Nd", "Pm", "Sm", "Eu", "Gd", "Tb", "Dy", "Ho", "Er", 
          "Tm", "Yb", "Lu", "Hf", "Ta", "W", "Re", "Os", "Ir", "Pt", "Au", 
          "Hg", "Tl", "Pb", "Bi", "Po", "At", "Rn", "Fr", "Ra", "Ac", "Th", 
          "Pa", "U", "Np", "Pu", "Am", "Cm", "Bk", "Cf", "Es", "Fm", "Md", 
          "No", "Lr", "Rf", "Db", "Sg", "Bh", "Hs", "Mt", "Ds", "Rg", "Cn", 
          "Nh", "Fl", "Mc", "Lv", "Ts", "Og", "Uub", "Uut", "Uuq", "Uup", 
          "Uuh", "Uus", "Uuo"}, {
         "h", "he", "li", "be", "b", "c", "n", "o", "f", "ne", "na", "mg", 
          "al", "si", "p", "s", "cl", "ar", "k", "ca", "sc", "ti", "v", "cr", 
          "mn", "fe", "co", "ni", "cu", "zn", "ga", "ge", "as", "se", "br", 
          "kr", "rb", "sr", "y", "zr", "nb", "mo", "tc", "ru", "rh", "pd", 
          "ag", "cd", "in", "sn", "sb", "te", "i", "xe", "cs", "ba", "la", 
          "ce", "pr", "nd", "pm", "sm", "eu", "gd", "tb", "dy", "ho", "er", 
          "tm", "yb", "lu", "hf", "ta", "w", "re", "os", "ir", "pt", "au", 
          "hg", "tl", "pb", "bi", "po", "at", "rn", "fr", "ra", "ac", "th", 
          "pa", "u", "np", "pu", "am", "cm", "bk", "cf", "es", "fm", "md", 
          "no", "lr", "rf", "db", "sg", "bh", "hs", "mt", "ds", "rg", "cn", 
          "nh", "fl", "mc", "lv", "ts", "og", "uub", "uut", "uuq", "uup", 
          "uuh", "uus", "uuo"}}, Replace[#, 
         Dispatch[{
          "h" -> RGBColor[0.65, 0.7, 0.7], "he" -> RGBColor[0.836713, 1., 1.],
            "li" -> RGBColor[0.799435, 0.543572, 0.997559], "be" -> 
           RGBColor[0.770565, 0.964309, 0.0442359], "b" -> 
           RGBColor[1., 0.709804, 0.709804], "c" -> RGBColor[0.4, 0.4, 0.4], 
           "n" -> RGBColor[0.291989, 0.437977, 0.888609], "o" -> 
           RGBColor[0.800498, 0.201504, 0.192061], "f" -> 
           RGBColor[0.578462, 0.85539, 0.408855], "ne" -> 
           RGBColor[0.677263, 0.928423, 0.955287], "na" -> 
           RGBColor[0.658708, 0.492173, 0.842842], "mg" -> 
           RGBColor[0.628274, 0.850553, 0.0782731], "al" -> 
           RGBColor[0.8913, 0.631904, 0.627399], "si" -> 
           RGBColor[0.941176, 0.784314, 0.627451], "p" -> 
           RGBColor[1., 0.501961, 0], "s" -> 
           RGBColor[0.90443, 0.97015, 0.13504], "cl" -> 
           RGBColor[0.412698, 0.932689, 0.166398], "ar" -> 
           RGBColor[0.546138, 0.844244, 0.892092], "k" -> 
           RGBColor[0.534026, 0.420729, 0.705621], "ca" -> 
           RGBColor[0.480072, 0.744591, 0.0955222], "sc" -> 
           RGBColor[0.901961, 0.901961, 0.901961], "ti" -> 
           RGBColor[0.74902, 0.760784, 0.780392], "v" -> 
           RGBColor[0.65098, 0.65098, 0.670588], "cr" -> 
           RGBColor[0.541176, 0.6, 0.780392], "mn" -> 
           RGBColor[0.611765, 0.478431, 0.780392], "fe" -> 
           RGBColor[0.878431, 0.4, 0.2], "co" -> 
           RGBColor[0.941176, 0.564706, 0.627451], "ni" -> 
           RGBColor[0.313725, 0.815686, 0.313725], "cu" -> 
           RGBColor[0.784314, 0.501961, 0.2], "zn" -> 
           RGBColor[0.490196, 0.501961, 0.690196], "ga" -> 
           RGBColor[0.800757, 0.542666, 0.533513], "ge" -> 
           RGBColor[0.60508, 0.632465, 0.576489], "as" -> 
           RGBColor[0.741176, 0.501961, 0.890196], "se" -> 
           RGBColor[0.917248, 0.657833, 0.0706628], "br" -> 
           RGBColor[0.58847, 0.22163, 0.16064], "kr" -> 
           RGBColor[0.426019, 0.747462, 0.810413], "rb" -> 
           RGBColor[0.425391, 0.329242, 0.585895], "sr" -> 
           RGBColor[0.325959, 0.646423, 0.095983], "y" -> 
           RGBColor[0.531014, 1., 1.], "zr" -> 
           RGBColor[0.458599, 0.917466, 0.918573], "nb" -> 
           RGBColor[0.385036, 0.834854, 0.841681], "mo" -> 
           RGBColor[0.310325, 0.752163, 0.769323], "tc" -> 
           RGBColor[0.234466, 0.669394, 0.701499], "ru" -> 
           RGBColor[0.157459, 0.586546, 0.638209], "rh" -> 
           RGBColor[0.0793033, 0.50362, 0.579453], "pd" -> 
           RGBColor[0., 0.420615, 0.525231], "ag" -> 
           RGBColor[0.752941, 0.752941, 0.752941], "cd" -> 
           RGBColor[1., 0.85098, 0.560784], "in" -> 
           RGBColor[0.728371, 0.440594, 0.422196], "sn" -> 
           RGBColor[0.39799, 0.491477, 0.495586], "sb" -> 
           RGBColor[0.619608, 0.388235, 0.709804], "te" -> 
           RGBColor[0.816706, 0.451332, 0.0100947], "i" -> 
           RGBColor[0.580392, 0, 0.580392], "xe" -> 
           RGBColor[0.316906, 0.638078, 0.710252], "cs" -> 
           RGBColor[0.332803, 0.217712, 0.483666], "ba" -> 
           RGBColor[0.165935, 0.55605, 0.0796556], "la" -> 
           RGBColor[0.928084, 0.716075, 0.329427], "ce" -> 
           RGBColor[0.894824, 0.731424, 0.325131], "pr" -> 
           RGBColor[0.86523, 0.707999, 0.315261], "nd" -> 
           RGBColor[0.837836, 0.662974, 0.301635], "pm" -> 
           RGBColor[0.811992, 0.607859, 0.285626], "sm" -> 
           RGBColor[0.787563, 0.549894, 0.268279], "eu" -> 
           RGBColor[0.764628, 0.493261, 0.250405], "gd" -> 
           RGBColor[0.743177, 0.440115, 0.23269], "tb" -> 
           RGBColor[0.72281, 0.39143, 0.215783], "dy" -> 
           RGBColor[0.702434, 0.347663, 0.200392], "ho" -> 
           RGBColor[0.679962, 0.309234, 0.187368], "er" -> 
           RGBColor[0.652012, 0.276823, 0.17779], "tm" -> 
           RGBColor[0.613603, 0.251489, 0.173042], "yb" -> 
           RGBColor[0.557855, 0.234598, 0.17489], "lu" -> 
           RGBColor[0.475685, 0.227573, 0.18555], "hf" -> 
           RGBColor[0.781537, 0.717388, 0.716579], "ta" -> 
           RGBColor[0.734443, 0.544489, 0.683471], "w" -> 
           RGBColor[0.681179, 0.360409, 0.63675], "re" -> 
           RGBColor[0.605181, 0.367584, 0.556343], "os" -> 
           RGBColor[0.521806, 0.382125, 0.469204], "ir" -> 
           RGBColor[0.445624, 0.373159, 0.399069], "pt" -> 
           RGBColor[0.815686, 0.815686, 0.878431], "au" -> 
           RGBColor[1., 0.819608, 0.137255], "hg" -> 
           RGBColor[0.721569, 0.721569, 0.815686], "tl" -> 
           RGBColor[0.65098, 0.329412, 0.301961], "pb" -> 
           RGBColor[0.341176, 0.34902, 0.380392], "bi" -> 
           RGBColor[0.619608, 0.309804, 0.709804], "po" -> 
           RGBColor[0.670588, 0.360784, 0], "at" -> 
           RGBColor[0.458824, 0.309804, 0.270588], "rn" -> 
           RGBColor[0.218799, 0.516091, 0.591608], "fr" -> 
           RGBColor[0.25626, 0.0861372, 0.398932], "ra" -> 
           RGBColor[0., 0.473472, 0.04654], "ac" -> 
           RGBColor[0.322042, 0.71693, 0.988479], "th" -> 
           RGBColor[0.3608, 0.67166, 0.943003], "pa" -> 
           RGBColor[0.397469, 0.628, 0.898853], "u" -> 
           RGBColor[0.43205, 0.58595, 0.856029], "np" -> 
           RGBColor[0.464542, 0.54551, 0.814532], "pu" -> 
           RGBColor[0.494945, 0.506679, 0.774361], "am" -> 
           RGBColor[0.52326, 0.469458, 0.735517], "cm" -> 
           RGBColor[0.549486, 0.433847, 0.697999], "bk" -> 
           RGBColor[0.573624, 0.399845, 0.661808], "cf" -> 
           RGBColor[0.595673, 0.367454, 0.626942], "es" -> 
           RGBColor[0.615633, 0.336672, 0.593404], "fm" -> 
           RGBColor[0.633505, 0.307499, 0.561191], "md" -> 
           RGBColor[0.649288, 0.279937, 0.530305], "no" -> 
           RGBColor[0.662982, 0.253984, 0.500746], "lr" -> 
           RGBColor[0.674588, 0.22964, 0.472513], "rf" -> 
           RGBColor[0.684106, 0.206907, 0.445606], "db" -> 
           RGBColor[0.691534, 0.185783, 0.420025], "sg" -> 
           RGBColor[0.696874, 0.166269, 0.395772], "bh" -> 
           RGBColor[0.700126, 0.148365, 0.372844], "hs" -> 
           RGBColor[0.701289, 0.13207, 0.351243], "mt" -> 
           RGBColor[0.700363, 0.117385, 0.330968], "ds" -> 
           RGBColor[0.697348, 0.10431, 0.31202], "rg" -> 
           RGBColor[0.692245, 0.0928444, 0.294398], "cn" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "nh" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "fl" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "mc" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "lv" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "ts" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "og" -> 
           RGBColor[0.635401, 0.0528, 0.226184], "uub" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "uut" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "uuq" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "uup" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "uuh" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "uus" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "uuo" -> 
           RGBColor[0.635401, 0.0528, 0.226184]}]]& ][0.85], 
       ColorDataFunction[
       "Atoms", 
        "Named", {{
         "H", "He", "Li", "Be", "B", "C", "N", "O", "F", "Ne", "Na", "Mg", 
          "Al", "Si", "P", "S", "Cl", "Ar", "K", "Ca", "Sc", "Ti", "V", "Cr", 
          "Mn", "Fe", "Co", "Ni", "Cu", "Zn", "Ga", "Ge", "As", "Se", "Br", 
          "Kr", "Rb", "Sr", "Y", "Zr", "Nb", "Mo", "Tc", "Ru", "Rh", "Pd", 
          "Ag", "Cd", "In", "Sn", "Sb", "Te", "I", "Xe", "Cs", "Ba", "La", 
          "Ce", "Pr", "Nd", "Pm", "Sm", "Eu", "Gd", "Tb", "Dy", "Ho", "Er", 
          "Tm", "Yb", "Lu", "Hf", "Ta", "W", "Re", "Os", "Ir", "Pt", "Au", 
          "Hg", "Tl", "Pb", "Bi", "Po", "At", "Rn", "Fr", "Ra", "Ac", "Th", 
          "Pa", "U", "Np", "Pu", "Am", "Cm", "Bk", "Cf", "Es", "Fm", "Md", 
          "No", "Lr", "Rf", "Db", "Sg", "Bh", "Hs", "Mt", "Ds", "Rg", "Cn", 
          "Nh", "Fl", "Mc", "Lv", "Ts", "Og", "Uub", "Uut", "Uuq", "Uup", 
          "Uuh", "Uus", "Uuo"}, {
         "h", "he", "li", "be", "b", "c", "n", "o", "f", "ne", "na", "mg", 
          "al", "si", "p", "s", "cl", "ar", "k", "ca", "sc", "ti", "v", "cr", 
          "mn", "fe", "co", "ni", "cu", "zn", "ga", "ge", "as", "se", "br", 
          "kr", "rb", "sr", "y", "zr", "nb", "mo", "tc", "ru", "rh", "pd", 
          "ag", "cd", "in", "sn", "sb", "te", "i", "xe", "cs", "ba", "la", 
          "ce", "pr", "nd", "pm", "sm", "eu", "gd", "tb", "dy", "ho", "er", 
          "tm", "yb", "lu", "hf", "ta", "w", "re", "os", "ir", "pt", "au", 
          "hg", "tl", "pb", "bi", "po", "at", "rn", "fr", "ra", "ac", "th", 
          "pa", "u", "np", "pu", "am", "cm", "bk", "cf", "es", "fm", "md", 
          "no", "lr", "rf", "db", "sg", "bh", "hs", "mt", "ds", "rg", "cn", 
          "nh", "fl", "mc", "lv", "ts", "og", "uub", "uut", "uuq", "uup", 
          "uuh", "uus", "uuo"}}, Replace[#, 
         Dispatch[{
          "h" -> RGBColor[0.65, 0.7, 0.7], "he" -> RGBColor[0.836713, 1., 1.],
            "li" -> RGBColor[0.799435, 0.543572, 0.997559], "be" -> 
           RGBColor[0.770565, 0.964309, 0.0442359], "b" -> 
           RGBColor[1., 0.709804, 0.709804], "c" -> RGBColor[0.4, 0.4, 0.4], 
           "n" -> RGBColor[0.291989, 0.437977, 0.888609], "o" -> 
           RGBColor[0.800498, 0.201504, 0.192061], "f" -> 
           RGBColor[0.578462, 0.85539, 0.408855], "ne" -> 
           RGBColor[0.677263, 0.928423, 0.955287], "na" -> 
           RGBColor[0.658708, 0.492173, 0.842842], "mg" -> 
           RGBColor[0.628274, 0.850553, 0.0782731], "al" -> 
           RGBColor[0.8913, 0.631904, 0.627399], "si" -> 
           RGBColor[0.941176, 0.784314, 0.627451], "p" -> 
           RGBColor[1., 0.501961, 0], "s" -> 
           RGBColor[0.90443, 0.97015, 0.13504], "cl" -> 
           RGBColor[0.412698, 0.932689, 0.166398], "ar" -> 
           RGBColor[0.546138, 0.844244, 0.892092], "k" -> 
           RGBColor[0.534026, 0.420729, 0.705621], "ca" -> 
           RGBColor[0.480072, 0.744591, 0.0955222], "sc" -> 
           RGBColor[0.901961, 0.901961, 0.901961], "ti" -> 
           RGBColor[0.74902, 0.760784, 0.780392], "v" -> 
           RGBColor[0.65098, 0.65098, 0.670588], "cr" -> 
           RGBColor[0.541176, 0.6, 0.780392], "mn" -> 
           RGBColor[0.611765, 0.478431, 0.780392], "fe" -> 
           RGBColor[0.878431, 0.4, 0.2], "co" -> 
           RGBColor[0.941176, 0.564706, 0.627451], "ni" -> 
           RGBColor[0.313725, 0.815686, 0.313725], "cu" -> 
           RGBColor[0.784314, 0.501961, 0.2], "zn" -> 
           RGBColor[0.490196, 0.501961, 0.690196], "ga" -> 
           RGBColor[0.800757, 0.542666, 0.533513], "ge" -> 
           RGBColor[0.60508, 0.632465, 0.576489], "as" -> 
           RGBColor[0.741176, 0.501961, 0.890196], "se" -> 
           RGBColor[0.917248, 0.657833, 0.0706628], "br" -> 
           RGBColor[0.58847, 0.22163, 0.16064], "kr" -> 
           RGBColor[0.426019, 0.747462, 0.810413], "rb" -> 
           RGBColor[0.425391, 0.329242, 0.585895], "sr" -> 
           RGBColor[0.325959, 0.646423, 0.095983], "y" -> 
           RGBColor[0.531014, 1., 1.], "zr" -> 
           RGBColor[0.458599, 0.917466, 0.918573], "nb" -> 
           RGBColor[0.385036, 0.834854, 0.841681], "mo" -> 
           RGBColor[0.310325, 0.752163, 0.769323], "tc" -> 
           RGBColor[0.234466, 0.669394, 0.701499], "ru" -> 
           RGBColor[0.157459, 0.586546, 0.638209], "rh" -> 
           RGBColor[0.0793033, 0.50362, 0.579453], "pd" -> 
           RGBColor[0., 0.420615, 0.525231], "ag" -> 
           RGBColor[0.752941, 0.752941, 0.752941], "cd" -> 
           RGBColor[1., 0.85098, 0.560784], "in" -> 
           RGBColor[0.728371, 0.440594, 0.422196], "sn" -> 
           RGBColor[0.39799, 0.491477, 0.495586], "sb" -> 
           RGBColor[0.619608, 0.388235, 0.709804], "te" -> 
           RGBColor[0.816706, 0.451332, 0.0100947], "i" -> 
           RGBColor[0.580392, 0, 0.580392], "xe" -> 
           RGBColor[0.316906, 0.638078, 0.710252], "cs" -> 
           RGBColor[0.332803, 0.217712, 0.483666], "ba" -> 
           RGBColor[0.165935, 0.55605, 0.0796556], "la" -> 
           RGBColor[0.928084, 0.716075, 0.329427], "ce" -> 
           RGBColor[0.894824, 0.731424, 0.325131], "pr" -> 
           RGBColor[0.86523, 0.707999, 0.315261], "nd" -> 
           RGBColor[0.837836, 0.662974, 0.301635], "pm" -> 
           RGBColor[0.811992, 0.607859, 0.285626], "sm" -> 
           RGBColor[0.787563, 0.549894, 0.268279], "eu" -> 
           RGBColor[0.764628, 0.493261, 0.250405], "gd" -> 
           RGBColor[0.743177, 0.440115, 0.23269], "tb" -> 
           RGBColor[0.72281, 0.39143, 0.215783], "dy" -> 
           RGBColor[0.702434, 0.347663, 0.200392], "ho" -> 
           RGBColor[0.679962, 0.309234, 0.187368], "er" -> 
           RGBColor[0.652012, 0.276823, 0.17779], "tm" -> 
           RGBColor[0.613603, 0.251489, 0.173042], "yb" -> 
           RGBColor[0.557855, 0.234598, 0.17489], "lu" -> 
           RGBColor[0.475685, 0.227573, 0.18555], "hf" -> 
           RGBColor[0.781537, 0.717388, 0.716579], "ta" -> 
           RGBColor[0.734443, 0.544489, 0.683471], "w" -> 
           RGBColor[0.681179, 0.360409, 0.63675], "re" -> 
           RGBColor[0.605181, 0.367584, 0.556343], "os" -> 
           RGBColor[0.521806, 0.382125, 0.469204], "ir" -> 
           RGBColor[0.445624, 0.373159, 0.399069], "pt" -> 
           RGBColor[0.815686, 0.815686, 0.878431], "au" -> 
           RGBColor[1., 0.819608, 0.137255], "hg" -> 
           RGBColor[0.721569, 0.721569, 0.815686], "tl" -> 
           RGBColor[0.65098, 0.329412, 0.301961], "pb" -> 
           RGBColor[0.341176, 0.34902, 0.380392], "bi" -> 
           RGBColor[0.619608, 0.309804, 0.709804], "po" -> 
           RGBColor[0.670588, 0.360784, 0], "at" -> 
           RGBColor[0.458824, 0.309804, 0.270588], "rn" -> 
           RGBColor[0.218799, 0.516091, 0.591608], "fr" -> 
           RGBColor[0.25626, 0.0861372, 0.398932], "ra" -> 
           RGBColor[0., 0.473472, 0.04654], "ac" -> 
           RGBColor[0.322042, 0.71693, 0.988479], "th" -> 
           RGBColor[0.3608, 0.67166, 0.943003], "pa" -> 
           RGBColor[0.397469, 0.628, 0.898853], "u" -> 
           RGBColor[0.43205, 0.58595, 0.856029], "np" -> 
           RGBColor[0.464542, 0.54551, 0.814532], "pu" -> 
           RGBColor[0.494945, 0.506679, 0.774361], "am" -> 
           RGBColor[0.52326, 0.469458, 0.735517], "cm" -> 
           RGBColor[0.549486, 0.433847, 0.697999], "bk" -> 
           RGBColor[0.573624, 0.399845, 0.661808], "cf" -> 
           RGBColor[0.595673, 0.367454, 0.626942], "es" -> 
           RGBColor[0.615633, 0.336672, 0.593404], "fm" -> 
           RGBColor[0.633505, 0.307499, 0.561191], "md" -> 
           RGBColor[0.649288, 0.279937, 0.530305], "no" -> 
           RGBColor[0.662982, 0.253984, 0.500746], "lr" -> 
           RGBColor[0.674588, 0.22964, 0.472513], "rf" -> 
           RGBColor[0.684106, 0.206907, 0.445606], "db" -> 
           RGBColor[0.691534, 0.185783, 0.420025], "sg" -> 
           RGBColor[0.696874, 0.166269, 0.395772], "bh" -> 
           RGBColor[0.700126, 0.148365, 0.372844], "hs" -> 
           RGBColor[0.701289, 0.13207, 0.351243], "mt" -> 
           RGBColor[0.700363, 0.117385, 0.330968], "ds" -> 
           RGBColor[0.697348, 0.10431, 0.31202], "rg" -> 
           RGBColor[0.692245, 0.0928444, 0.294398], "cn" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "nh" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "fl" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "mc" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "lv" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "ts" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "og" -> 
           RGBColor[0.635401, 0.0528, 0.226184], "uub" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "uut" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "uuq" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "uup" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "uuh" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "uus" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "uuo" -> 
           RGBColor[0.635401, 0.0528, 0.226184]}]]& ][0.85], 
       ColorDataFunction[
       "Atoms", 
        "Named", {{
         "H", "He", "Li", "Be", "B", "C", "N", "O", "F", "Ne", "Na", "Mg", 
          "Al", "Si", "P", "S", "Cl", "Ar", "K", "Ca", "Sc", "Ti", "V", "Cr", 
          "Mn", "Fe", "Co", "Ni", "Cu", "Zn", "Ga", "Ge", "As", "Se", "Br", 
          "Kr", "Rb", "Sr", "Y", "Zr", "Nb", "Mo", "Tc", "Ru", "Rh", "Pd", 
          "Ag", "Cd", "In", "Sn", "Sb", "Te", "I", "Xe", "Cs", "Ba", "La", 
          "Ce", "Pr", "Nd", "Pm", "Sm", "Eu", "Gd", "Tb", "Dy", "Ho", "Er", 
          "Tm", "Yb", "Lu", "Hf", "Ta", "W", "Re", "Os", "Ir", "Pt", "Au", 
          "Hg", "Tl", "Pb", "Bi", "Po", "At", "Rn", "Fr", "Ra", "Ac", "Th", 
          "Pa", "U", "Np", "Pu", "Am", "Cm", "Bk", "Cf", "Es", "Fm", "Md", 
          "No", "Lr", "Rf", "Db", "Sg", "Bh", "Hs", "Mt", "Ds", "Rg", "Cn", 
          "Nh", "Fl", "Mc", "Lv", "Ts", "Og", "Uub", "Uut", "Uuq", "Uup", 
          "Uuh", "Uus", "Uuo"}, {
         "h", "he", "li", "be", "b", "c", "n", "o", "f", "ne", "na", "mg", 
          "al", "si", "p", "s", "cl", "ar", "k", "ca", "sc", "ti", "v", "cr", 
          "mn", "fe", "co", "ni", "cu", "zn", "ga", "ge", "as", "se", "br", 
          "kr", "rb", "sr", "y", "zr", "nb", "mo", "tc", "ru", "rh", "pd", 
          "ag", "cd", "in", "sn", "sb", "te", "i", "xe", "cs", "ba", "la", 
          "ce", "pr", "nd", "pm", "sm", "eu", "gd", "tb", "dy", "ho", "er", 
          "tm", "yb", "lu", "hf", "ta", "w", "re", "os", "ir", "pt", "au", 
          "hg", "tl", "pb", "bi", "po", "at", "rn", "fr", "ra", "ac", "th", 
          "pa", "u", "np", "pu", "am", "cm", "bk", "cf", "es", "fm", "md", 
          "no", "lr", "rf", "db", "sg", "bh", "hs", "mt", "ds", "rg", "cn", 
          "nh", "fl", "mc", "lv", "ts", "og", "uub", "uut", "uuq", "uup", 
          "uuh", "uus", "uuo"}}, Replace[#, 
         Dispatch[{
          "h" -> RGBColor[0.65, 0.7, 0.7], "he" -> RGBColor[0.836713, 1., 1.],
            "li" -> RGBColor[0.799435, 0.543572, 0.997559], "be" -> 
           RGBColor[0.770565, 0.964309, 0.0442359], "b" -> 
           RGBColor[1., 0.709804, 0.709804], "c" -> RGBColor[0.4, 0.4, 0.4], 
           "n" -> RGBColor[0.291989, 0.437977, 0.888609], "o" -> 
           RGBColor[0.800498, 0.201504, 0.192061], "f" -> 
           RGBColor[0.578462, 0.85539, 0.408855], "ne" -> 
           RGBColor[0.677263, 0.928423, 0.955287], "na" -> 
           RGBColor[0.658708, 0.492173, 0.842842], "mg" -> 
           RGBColor[0.628274, 0.850553, 0.0782731], "al" -> 
           RGBColor[0.8913, 0.631904, 0.627399], "si" -> 
           RGBColor[0.941176, 0.784314, 0.627451], "p" -> 
           RGBColor[1., 0.501961, 0], "s" -> 
           RGBColor[0.90443, 0.97015, 0.13504], "cl" -> 
           RGBColor[0.412698, 0.932689, 0.166398], "ar" -> 
           RGBColor[0.546138, 0.844244, 0.892092], "k" -> 
           RGBColor[0.534026, 0.420729, 0.705621], "ca" -> 
           RGBColor[0.480072, 0.744591, 0.0955222], "sc" -> 
           RGBColor[0.901961, 0.901961, 0.901961], "ti" -> 
           RGBColor[0.74902, 0.760784, 0.780392], "v" -> 
           RGBColor[0.65098, 0.65098, 0.670588], "cr" -> 
           RGBColor[0.541176, 0.6, 0.780392], "mn" -> 
           RGBColor[0.611765, 0.478431, 0.780392], "fe" -> 
           RGBColor[0.878431, 0.4, 0.2], "co" -> 
           RGBColor[0.941176, 0.564706, 0.627451], "ni" -> 
           RGBColor[0.313725, 0.815686, 0.313725], "cu" -> 
           RGBColor[0.784314, 0.501961, 0.2], "zn" -> 
           RGBColor[0.490196, 0.501961, 0.690196], "ga" -> 
           RGBColor[0.800757, 0.542666, 0.533513], "ge" -> 
           RGBColor[0.60508, 0.632465, 0.576489], "as" -> 
           RGBColor[0.741176, 0.501961, 0.890196], "se" -> 
           RGBColor[0.917248, 0.657833, 0.0706628], "br" -> 
           RGBColor[0.58847, 0.22163, 0.16064], "kr" -> 
           RGBColor[0.426019, 0.747462, 0.810413], "rb" -> 
           RGBColor[0.425391, 0.329242, 0.585895], "sr" -> 
           RGBColor[0.325959, 0.646423, 0.095983], "y" -> 
           RGBColor[0.531014, 1., 1.], "zr" -> 
           RGBColor[0.458599, 0.917466, 0.918573], "nb" -> 
           RGBColor[0.385036, 0.834854, 0.841681], "mo" -> 
           RGBColor[0.310325, 0.752163, 0.769323], "tc" -> 
           RGBColor[0.234466, 0.669394, 0.701499], "ru" -> 
           RGBColor[0.157459, 0.586546, 0.638209], "rh" -> 
           RGBColor[0.0793033, 0.50362, 0.579453], "pd" -> 
           RGBColor[0., 0.420615, 0.525231], "ag" -> 
           RGBColor[0.752941, 0.752941, 0.752941], "cd" -> 
           RGBColor[1., 0.85098, 0.560784], "in" -> 
           RGBColor[0.728371, 0.440594, 0.422196], "sn" -> 
           RGBColor[0.39799, 0.491477, 0.495586], "sb" -> 
           RGBColor[0.619608, 0.388235, 0.709804], "te" -> 
           RGBColor[0.816706, 0.451332, 0.0100947], "i" -> 
           RGBColor[0.580392, 0, 0.580392], "xe" -> 
           RGBColor[0.316906, 0.638078, 0.710252], "cs" -> 
           RGBColor[0.332803, 0.217712, 0.483666], "ba" -> 
           RGBColor[0.165935, 0.55605, 0.0796556], "la" -> 
           RGBColor[0.928084, 0.716075, 0.329427], "ce" -> 
           RGBColor[0.894824, 0.731424, 0.325131], "pr" -> 
           RGBColor[0.86523, 0.707999, 0.315261], "nd" -> 
           RGBColor[0.837836, 0.662974, 0.301635], "pm" -> 
           RGBColor[0.811992, 0.607859, 0.285626], "sm" -> 
           RGBColor[0.787563, 0.549894, 0.268279], "eu" -> 
           RGBColor[0.764628, 0.493261, 0.250405], "gd" -> 
           RGBColor[0.743177, 0.440115, 0.23269], "tb" -> 
           RGBColor[0.72281, 0.39143, 0.215783], "dy" -> 
           RGBColor[0.702434, 0.347663, 0.200392], "ho" -> 
           RGBColor[0.679962, 0.309234, 0.187368], "er" -> 
           RGBColor[0.652012, 0.276823, 0.17779], "tm" -> 
           RGBColor[0.613603, 0.251489, 0.173042], "yb" -> 
           RGBColor[0.557855, 0.234598, 0.17489], "lu" -> 
           RGBColor[0.475685, 0.227573, 0.18555], "hf" -> 
           RGBColor[0.781537, 0.717388, 0.716579], "ta" -> 
           RGBColor[0.734443, 0.544489, 0.683471], "w" -> 
           RGBColor[0.681179, 0.360409, 0.63675], "re" -> 
           RGBColor[0.605181, 0.367584, 0.556343], "os" -> 
           RGBColor[0.521806, 0.382125, 0.469204], "ir" -> 
           RGBColor[0.445624, 0.373159, 0.399069], "pt" -> 
           RGBColor[0.815686, 0.815686, 0.878431], "au" -> 
           RGBColor[1., 0.819608, 0.137255], "hg" -> 
           RGBColor[0.721569, 0.721569, 0.815686], "tl" -> 
           RGBColor[0.65098, 0.329412, 0.301961], "pb" -> 
           RGBColor[0.341176, 0.34902, 0.380392], "bi" -> 
           RGBColor[0.619608, 0.309804, 0.709804], "po" -> 
           RGBColor[0.670588, 0.360784, 0], "at" -> 
           RGBColor[0.458824, 0.309804, 0.270588], "rn" -> 
           RGBColor[0.218799, 0.516091, 0.591608], "fr" -> 
           RGBColor[0.25626, 0.0861372, 0.398932], "ra" -> 
           RGBColor[0., 0.473472, 0.04654], "ac" -> 
           RGBColor[0.322042, 0.71693, 0.988479], "th" -> 
           RGBColor[0.3608, 0.67166, 0.943003], "pa" -> 
           RGBColor[0.397469, 0.628, 0.898853], "u" -> 
           RGBColor[0.43205, 0.58595, 0.856029], "np" -> 
           RGBColor[0.464542, 0.54551, 0.814532], "pu" -> 
           RGBColor[0.494945, 0.506679, 0.774361], "am" -> 
           RGBColor[0.52326, 0.469458, 0.735517], "cm" -> 
           RGBColor[0.549486, 0.433847, 0.697999], "bk" -> 
           RGBColor[0.573624, 0.399845, 0.661808], "cf" -> 
           RGBColor[0.595673, 0.367454, 0.626942], "es" -> 
           RGBColor[0.615633, 0.336672, 0.593404], "fm" -> 
           RGBColor[0.633505, 0.307499, 0.561191], "md" -> 
           RGBColor[0.649288, 0.279937, 0.530305], "no" -> 
           RGBColor[0.662982, 0.253984, 0.500746], "lr" -> 
           RGBColor[0.674588, 0.22964, 0.472513], "rf" -> 
           RGBColor[0.684106, 0.206907, 0.445606], "db" -> 
           RGBColor[0.691534, 0.185783, 0.420025], "sg" -> 
           RGBColor[0.696874, 0.166269, 0.395772], "bh" -> 
           RGBColor[0.700126, 0.148365, 0.372844], "hs" -> 
           RGBColor[0.701289, 0.13207, 0.351243], "mt" -> 
           RGBColor[0.700363, 0.117385, 0.330968], "ds" -> 
           RGBColor[0.697348, 0.10431, 0.31202], "rg" -> 
           RGBColor[0.692245, 0.0928444, 0.294398], "cn" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "nh" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "fl" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "mc" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "lv" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "ts" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "og" -> 
           RGBColor[0.635401, 0.0528, 0.226184], "uub" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "uut" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "uuq" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "uup" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "uuh" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "uus" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "uuo" -> 
           RGBColor[0.635401, 0.0528, 0.226184]}]]& ][0.85], 
       ColorDataFunction[
       "Atoms", 
        "Named", {{
         "H", "He", "Li", "Be", "B", "C", "N", "O", "F", "Ne", "Na", "Mg", 
          "Al", "Si", "P", "S", "Cl", "Ar", "K", "Ca", "Sc", "Ti", "V", "Cr", 
          "Mn", "Fe", "Co", "Ni", "Cu", "Zn", "Ga", "Ge", "As", "Se", "Br", 
          "Kr", "Rb", "Sr", "Y", "Zr", "Nb", "Mo", "Tc", "Ru", "Rh", "Pd", 
          "Ag", "Cd", "In", "Sn", "Sb", "Te", "I", "Xe", "Cs", "Ba", "La", 
          "Ce", "Pr", "Nd", "Pm", "Sm", "Eu", "Gd", "Tb", "Dy", "Ho", "Er", 
          "Tm", "Yb", "Lu", "Hf", "Ta", "W", "Re", "Os", "Ir", "Pt", "Au", 
          "Hg", "Tl", "Pb", "Bi", "Po", "At", "Rn", "Fr", "Ra", "Ac", "Th", 
          "Pa", "U", "Np", "Pu", "Am", "Cm", "Bk", "Cf", "Es", "Fm", "Md", 
          "No", "Lr", "Rf", "Db", "Sg", "Bh", "Hs", "Mt", "Ds", "Rg", "Cn", 
          "Nh", "Fl", "Mc", "Lv", "Ts", "Og", "Uub", "Uut", "Uuq", "Uup", 
          "Uuh", "Uus", "Uuo"}, {
         "h", "he", "li", "be", "b", "c", "n", "o", "f", "ne", "na", "mg", 
          "al", "si", "p", "s", "cl", "ar", "k", "ca", "sc", "ti", "v", "cr", 
          "mn", "fe", "co", "ni", "cu", "zn", "ga", "ge", "as", "se", "br", 
          "kr", "rb", "sr", "y", "zr", "nb", "mo", "tc", "ru", "rh", "pd", 
          "ag", "cd", "in", "sn", "sb", "te", "i", "xe", "cs", "ba", "la", 
          "ce", "pr", "nd", "pm", "sm", "eu", "gd", "tb", "dy", "ho", "er", 
          "tm", "yb", "lu", "hf", "ta", "w", "re", "os", "ir", "pt", "au", 
          "hg", "tl", "pb", "bi", "po", "at", "rn", "fr", "ra", "ac", "th", 
          "pa", "u", "np", "pu", "am", "cm", "bk", "cf", "es", "fm", "md", 
          "no", "lr", "rf", "db", "sg", "bh", "hs", "mt", "ds", "rg", "cn", 
          "nh", "fl", "mc", "lv", "ts", "og", "uub", "uut", "uuq", "uup", 
          "uuh", "uus", "uuo"}}, Replace[#, 
         Dispatch[{
          "h" -> RGBColor[0.65, 0.7, 0.7], "he" -> RGBColor[0.836713, 1., 1.],
            "li" -> RGBColor[0.799435, 0.543572, 0.997559], "be" -> 
           RGBColor[0.770565, 0.964309, 0.0442359], "b" -> 
           RGBColor[1., 0.709804, 0.709804], "c" -> RGBColor[0.4, 0.4, 0.4], 
           "n" -> RGBColor[0.291989, 0.437977, 0.888609], "o" -> 
           RGBColor[0.800498, 0.201504, 0.192061], "f" -> 
           RGBColor[0.578462, 0.85539, 0.408855], "ne" -> 
           RGBColor[0.677263, 0.928423, 0.955287], "na" -> 
           RGBColor[0.658708, 0.492173, 0.842842], "mg" -> 
           RGBColor[0.628274, 0.850553, 0.0782731], "al" -> 
           RGBColor[0.8913, 0.631904, 0.627399], "si" -> 
           RGBColor[0.941176, 0.784314, 0.627451], "p" -> 
           RGBColor[1., 0.501961, 0], "s" -> 
           RGBColor[0.90443, 0.97015, 0.13504], "cl" -> 
           RGBColor[0.412698, 0.932689, 0.166398], "ar" -> 
           RGBColor[0.546138, 0.844244, 0.892092], "k" -> 
           RGBColor[0.534026, 0.420729, 0.705621], "ca" -> 
           RGBColor[0.480072, 0.744591, 0.0955222], "sc" -> 
           RGBColor[0.901961, 0.901961, 0.901961], "ti" -> 
           RGBColor[0.74902, 0.760784, 0.780392], "v" -> 
           RGBColor[0.65098, 0.65098, 0.670588], "cr" -> 
           RGBColor[0.541176, 0.6, 0.780392], "mn" -> 
           RGBColor[0.611765, 0.478431, 0.780392], "fe" -> 
           RGBColor[0.878431, 0.4, 0.2], "co" -> 
           RGBColor[0.941176, 0.564706, 0.627451], "ni" -> 
           RGBColor[0.313725, 0.815686, 0.313725], "cu" -> 
           RGBColor[0.784314, 0.501961, 0.2], "zn" -> 
           RGBColor[0.490196, 0.501961, 0.690196], "ga" -> 
           RGBColor[0.800757, 0.542666, 0.533513], "ge" -> 
           RGBColor[0.60508, 0.632465, 0.576489], "as" -> 
           RGBColor[0.741176, 0.501961, 0.890196], "se" -> 
           RGBColor[0.917248, 0.657833, 0.0706628], "br" -> 
           RGBColor[0.58847, 0.22163, 0.16064], "kr" -> 
           RGBColor[0.426019, 0.747462, 0.810413], "rb" -> 
           RGBColor[0.425391, 0.329242, 0.585895], "sr" -> 
           RGBColor[0.325959, 0.646423, 0.095983], "y" -> 
           RGBColor[0.531014, 1., 1.], "zr" -> 
           RGBColor[0.458599, 0.917466, 0.918573], "nb" -> 
           RGBColor[0.385036, 0.834854, 0.841681], "mo" -> 
           RGBColor[0.310325, 0.752163, 0.769323], "tc" -> 
           RGBColor[0.234466, 0.669394, 0.701499], "ru" -> 
           RGBColor[0.157459, 0.586546, 0.638209], "rh" -> 
           RGBColor[0.0793033, 0.50362, 0.579453], "pd" -> 
           RGBColor[0., 0.420615, 0.525231], "ag" -> 
           RGBColor[0.752941, 0.752941, 0.752941], "cd" -> 
           RGBColor[1., 0.85098, 0.560784], "in" -> 
           RGBColor[0.728371, 0.440594, 0.422196], "sn" -> 
           RGBColor[0.39799, 0.491477, 0.495586], "sb" -> 
           RGBColor[0.619608, 0.388235, 0.709804], "te" -> 
           RGBColor[0.816706, 0.451332, 0.0100947], "i" -> 
           RGBColor[0.580392, 0, 0.580392], "xe" -> 
           RGBColor[0.316906, 0.638078, 0.710252], "cs" -> 
           RGBColor[0.332803, 0.217712, 0.483666], "ba" -> 
           RGBColor[0.165935, 0.55605, 0.0796556], "la" -> 
           RGBColor[0.928084, 0.716075, 0.329427], "ce" -> 
           RGBColor[0.894824, 0.731424, 0.325131], "pr" -> 
           RGBColor[0.86523, 0.707999, 0.315261], "nd" -> 
           RGBColor[0.837836, 0.662974, 0.301635], "pm" -> 
           RGBColor[0.811992, 0.607859, 0.285626], "sm" -> 
           RGBColor[0.787563, 0.549894, 0.268279], "eu" -> 
           RGBColor[0.764628, 0.493261, 0.250405], "gd" -> 
           RGBColor[0.743177, 0.440115, 0.23269], "tb" -> 
           RGBColor[0.72281, 0.39143, 0.215783], "dy" -> 
           RGBColor[0.702434, 0.347663, 0.200392], "ho" -> 
           RGBColor[0.679962, 0.309234, 0.187368], "er" -> 
           RGBColor[0.652012, 0.276823, 0.17779], "tm" -> 
           RGBColor[0.613603, 0.251489, 0.173042], "yb" -> 
           RGBColor[0.557855, 0.234598, 0.17489], "lu" -> 
           RGBColor[0.475685, 0.227573, 0.18555], "hf" -> 
           RGBColor[0.781537, 0.717388, 0.716579], "ta" -> 
           RGBColor[0.734443, 0.544489, 0.683471], "w" -> 
           RGBColor[0.681179, 0.360409, 0.63675], "re" -> 
           RGBColor[0.605181, 0.367584, 0.556343], "os" -> 
           RGBColor[0.521806, 0.382125, 0.469204], "ir" -> 
           RGBColor[0.445624, 0.373159, 0.399069], "pt" -> 
           RGBColor[0.815686, 0.815686, 0.878431], "au" -> 
           RGBColor[1., 0.819608, 0.137255], "hg" -> 
           RGBColor[0.721569, 0.721569, 0.815686], "tl" -> 
           RGBColor[0.65098, 0.329412, 0.301961], "pb" -> 
           RGBColor[0.341176, 0.34902, 0.380392], "bi" -> 
           RGBColor[0.619608, 0.309804, 0.709804], "po" -> 
           RGBColor[0.670588, 0.360784, 0], "at" -> 
           RGBColor[0.458824, 0.309804, 0.270588], "rn" -> 
           RGBColor[0.218799, 0.516091, 0.591608], "fr" -> 
           RGBColor[0.25626, 0.0861372, 0.398932], "ra" -> 
           RGBColor[0., 0.473472, 0.04654], "ac" -> 
           RGBColor[0.322042, 0.71693, 0.988479], "th" -> 
           RGBColor[0.3608, 0.67166, 0.943003], "pa" -> 
           RGBColor[0.397469, 0.628, 0.898853], "u" -> 
           RGBColor[0.43205, 0.58595, 0.856029], "np" -> 
           RGBColor[0.464542, 0.54551, 0.814532], "pu" -> 
           RGBColor[0.494945, 0.506679, 0.774361], "am" -> 
           RGBColor[0.52326, 0.469458, 0.735517], "cm" -> 
           RGBColor[0.549486, 0.433847, 0.697999], "bk" -> 
           RGBColor[0.573624, 0.399845, 0.661808], "cf" -> 
           RGBColor[0.595673, 0.367454, 0.626942], "es" -> 
           RGBColor[0.615633, 0.336672, 0.593404], "fm" -> 
           RGBColor[0.633505, 0.307499, 0.561191], "md" -> 
           RGBColor[0.649288, 0.279937, 0.530305], "no" -> 
           RGBColor[0.662982, 0.253984, 0.500746], "lr" -> 
           RGBColor[0.674588, 0.22964, 0.472513], "rf" -> 
           RGBColor[0.684106, 0.206907, 0.445606], "db" -> 
           RGBColor[0.691534, 0.185783, 0.420025], "sg" -> 
           RGBColor[0.696874, 0.166269, 0.395772], "bh" -> 
           RGBColor[0.700126, 0.148365, 0.372844], "hs" -> 
           RGBColor[0.701289, 0.13207, 0.351243], "mt" -> 
           RGBColor[0.700363, 0.117385, 0.330968], "ds" -> 
           RGBColor[0.697348, 0.10431, 0.31202], "rg" -> 
           RGBColor[0.692245, 0.0928444, 0.294398], "cn" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "nh" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "fl" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "mc" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "lv" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "ts" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "og" -> 
           RGBColor[0.635401, 0.0528, 0.226184], "uub" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "uut" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "uuq" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "uup" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "uuh" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "uus" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "uuo" -> 
           RGBColor[0.635401, 0.0528, 0.226184]}]]& ][0.85], 
       ColorDataFunction[
       "Atoms", 
        "Named", {{
         "H", "He", "Li", "Be", "B", "C", "N", "O", "F", "Ne", "Na", "Mg", 
          "Al", "Si", "P", "S", "Cl", "Ar", "K", "Ca", "Sc", "Ti", "V", "Cr", 
          "Mn", "Fe", "Co", "Ni", "Cu", "Zn", "Ga", "Ge", "As", "Se", "Br", 
          "Kr", "Rb", "Sr", "Y", "Zr", "Nb", "Mo", "Tc", "Ru", "Rh", "Pd", 
          "Ag", "Cd", "In", "Sn", "Sb", "Te", "I", "Xe", "Cs", "Ba", "La", 
          "Ce", "Pr", "Nd", "Pm", "Sm", "Eu", "Gd", "Tb", "Dy", "Ho", "Er", 
          "Tm", "Yb", "Lu", "Hf", "Ta", "W", "Re", "Os", "Ir", "Pt", "Au", 
          "Hg", "Tl", "Pb", "Bi", "Po", "At", "Rn", "Fr", "Ra", "Ac", "Th", 
          "Pa", "U", "Np", "Pu", "Am", "Cm", "Bk", "Cf", "Es", "Fm", "Md", 
          "No", "Lr", "Rf", "Db", "Sg", "Bh", "Hs", "Mt", "Ds", "Rg", "Cn", 
          "Nh", "Fl", "Mc", "Lv", "Ts", "Og", "Uub", "Uut", "Uuq", "Uup", 
          "Uuh", "Uus", "Uuo"}, {
         "h", "he", "li", "be", "b", "c", "n", "o", "f", "ne", "na", "mg", 
          "al", "si", "p", "s", "cl", "ar", "k", "ca", "sc", "ti", "v", "cr", 
          "mn", "fe", "co", "ni", "cu", "zn", "ga", "ge", "as", "se", "br", 
          "kr", "rb", "sr", "y", "zr", "nb", "mo", "tc", "ru", "rh", "pd", 
          "ag", "cd", "in", "sn", "sb", "te", "i", "xe", "cs", "ba", "la", 
          "ce", "pr", "nd", "pm", "sm", "eu", "gd", "tb", "dy", "ho", "er", 
          "tm", "yb", "lu", "hf", "ta", "w", "re", "os", "ir", "pt", "au", 
          "hg", "tl", "pb", "bi", "po", "at", "rn", "fr", "ra", "ac", "th", 
          "pa", "u", "np", "pu", "am", "cm", "bk", "cf", "es", "fm", "md", 
          "no", "lr", "rf", "db", "sg", "bh", "hs", "mt", "ds", "rg", "cn", 
          "nh", "fl", "mc", "lv", "ts", "og", "uub", "uut", "uuq", "uup", 
          "uuh", "uus", "uuo"}}, Replace[#, 
         Dispatch[{
          "h" -> RGBColor[0.65, 0.7, 0.7], "he" -> RGBColor[0.836713, 1., 1.],
            "li" -> RGBColor[0.799435, 0.543572, 0.997559], "be" -> 
           RGBColor[0.770565, 0.964309, 0.0442359], "b" -> 
           RGBColor[1., 0.709804, 0.709804], "c" -> RGBColor[0.4, 0.4, 0.4], 
           "n" -> RGBColor[0.291989, 0.437977, 0.888609], "o" -> 
           RGBColor[0.800498, 0.201504, 0.192061], "f" -> 
           RGBColor[0.578462, 0.85539, 0.408855], "ne" -> 
           RGBColor[0.677263, 0.928423, 0.955287], "na" -> 
           RGBColor[0.658708, 0.492173, 0.842842], "mg" -> 
           RGBColor[0.628274, 0.850553, 0.0782731], "al" -> 
           RGBColor[0.8913, 0.631904, 0.627399], "si" -> 
           RGBColor[0.941176, 0.784314, 0.627451], "p" -> 
           RGBColor[1., 0.501961, 0], "s" -> 
           RGBColor[0.90443, 0.97015, 0.13504], "cl" -> 
           RGBColor[0.412698, 0.932689, 0.166398], "ar" -> 
           RGBColor[0.546138, 0.844244, 0.892092], "k" -> 
           RGBColor[0.534026, 0.420729, 0.705621], "ca" -> 
           RGBColor[0.480072, 0.744591, 0.0955222], "sc" -> 
           RGBColor[0.901961, 0.901961, 0.901961], "ti" -> 
           RGBColor[0.74902, 0.760784, 0.780392], "v" -> 
           RGBColor[0.65098, 0.65098, 0.670588], "cr" -> 
           RGBColor[0.541176, 0.6, 0.780392], "mn" -> 
           RGBColor[0.611765, 0.478431, 0.780392], "fe" -> 
           RGBColor[0.878431, 0.4, 0.2], "co" -> 
           RGBColor[0.941176, 0.564706, 0.627451], "ni" -> 
           RGBColor[0.313725, 0.815686, 0.313725], "cu" -> 
           RGBColor[0.784314, 0.501961, 0.2], "zn" -> 
           RGBColor[0.490196, 0.501961, 0.690196], "ga" -> 
           RGBColor[0.800757, 0.542666, 0.533513], "ge" -> 
           RGBColor[0.60508, 0.632465, 0.576489], "as" -> 
           RGBColor[0.741176, 0.501961, 0.890196], "se" -> 
           RGBColor[0.917248, 0.657833, 0.0706628], "br" -> 
           RGBColor[0.58847, 0.22163, 0.16064], "kr" -> 
           RGBColor[0.426019, 0.747462, 0.810413], "rb" -> 
           RGBColor[0.425391, 0.329242, 0.585895], "sr" -> 
           RGBColor[0.325959, 0.646423, 0.095983], "y" -> 
           RGBColor[0.531014, 1., 1.], "zr" -> 
           RGBColor[0.458599, 0.917466, 0.918573], "nb" -> 
           RGBColor[0.385036, 0.834854, 0.841681], "mo" -> 
           RGBColor[0.310325, 0.752163, 0.769323], "tc" -> 
           RGBColor[0.234466, 0.669394, 0.701499], "ru" -> 
           RGBColor[0.157459, 0.586546, 0.638209], "rh" -> 
           RGBColor[0.0793033, 0.50362, 0.579453], "pd" -> 
           RGBColor[0., 0.420615, 0.525231], "ag" -> 
           RGBColor[0.752941, 0.752941, 0.752941], "cd" -> 
           RGBColor[1., 0.85098, 0.560784], "in" -> 
           RGBColor[0.728371, 0.440594, 0.422196], "sn" -> 
           RGBColor[0.39799, 0.491477, 0.495586], "sb" -> 
           RGBColor[0.619608, 0.388235, 0.709804], "te" -> 
           RGBColor[0.816706, 0.451332, 0.0100947], "i" -> 
           RGBColor[0.580392, 0, 0.580392], "xe" -> 
           RGBColor[0.316906, 0.638078, 0.710252], "cs" -> 
           RGBColor[0.332803, 0.217712, 0.483666], "ba" -> 
           RGBColor[0.165935, 0.55605, 0.0796556], "la" -> 
           RGBColor[0.928084, 0.716075, 0.329427], "ce" -> 
           RGBColor[0.894824, 0.731424, 0.325131], "pr" -> 
           RGBColor[0.86523, 0.707999, 0.315261], "nd" -> 
           RGBColor[0.837836, 0.662974, 0.301635], "pm" -> 
           RGBColor[0.811992, 0.607859, 0.285626], "sm" -> 
           RGBColor[0.787563, 0.549894, 0.268279], "eu" -> 
           RGBColor[0.764628, 0.493261, 0.250405], "gd" -> 
           RGBColor[0.743177, 0.440115, 0.23269], "tb" -> 
           RGBColor[0.72281, 0.39143, 0.215783], "dy" -> 
           RGBColor[0.702434, 0.347663, 0.200392], "ho" -> 
           RGBColor[0.679962, 0.309234, 0.187368], "er" -> 
           RGBColor[0.652012, 0.276823, 0.17779], "tm" -> 
           RGBColor[0.613603, 0.251489, 0.173042], "yb" -> 
           RGBColor[0.557855, 0.234598, 0.17489], "lu" -> 
           RGBColor[0.475685, 0.227573, 0.18555], "hf" -> 
           RGBColor[0.781537, 0.717388, 0.716579], "ta" -> 
           RGBColor[0.734443, 0.544489, 0.683471], "w" -> 
           RGBColor[0.681179, 0.360409, 0.63675], "re" -> 
           RGBColor[0.605181, 0.367584, 0.556343], "os" -> 
           RGBColor[0.521806, 0.382125, 0.469204], "ir" -> 
           RGBColor[0.445624, 0.373159, 0.399069], "pt" -> 
           RGBColor[0.815686, 0.815686, 0.878431], "au" -> 
           RGBColor[1., 0.819608, 0.137255], "hg" -> 
           RGBColor[0.721569, 0.721569, 0.815686], "tl" -> 
           RGBColor[0.65098, 0.329412, 0.301961], "pb" -> 
           RGBColor[0.341176, 0.34902, 0.380392], "bi" -> 
           RGBColor[0.619608, 0.309804, 0.709804], "po" -> 
           RGBColor[0.670588, 0.360784, 0], "at" -> 
           RGBColor[0.458824, 0.309804, 0.270588], "rn" -> 
           RGBColor[0.218799, 0.516091, 0.591608], "fr" -> 
           RGBColor[0.25626, 0.0861372, 0.398932], "ra" -> 
           RGBColor[0., 0.473472, 0.04654], "ac" -> 
           RGBColor[0.322042, 0.71693, 0.988479], "th" -> 
           RGBColor[0.3608, 0.67166, 0.943003], "pa" -> 
           RGBColor[0.397469, 0.628, 0.898853], "u" -> 
           RGBColor[0.43205, 0.58595, 0.856029], "np" -> 
           RGBColor[0.464542, 0.54551, 0.814532], "pu" -> 
           RGBColor[0.494945, 0.506679, 0.774361], "am" -> 
           RGBColor[0.52326, 0.469458, 0.735517], "cm" -> 
           RGBColor[0.549486, 0.433847, 0.697999], "bk" -> 
           RGBColor[0.573624, 0.399845, 0.661808], "cf" -> 
           RGBColor[0.595673, 0.367454, 0.626942], "es" -> 
           RGBColor[0.615633, 0.336672, 0.593404], "fm" -> 
           RGBColor[0.633505, 0.307499, 0.561191], "md" -> 
           RGBColor[0.649288, 0.279937, 0.530305], "no" -> 
           RGBColor[0.662982, 0.253984, 0.500746], "lr" -> 
           RGBColor[0.674588, 0.22964, 0.472513], "rf" -> 
           RGBColor[0.684106, 0.206907, 0.445606], "db" -> 
           RGBColor[0.691534, 0.185783, 0.420025], "sg" -> 
           RGBColor[0.696874, 0.166269, 0.395772], "bh" -> 
           RGBColor[0.700126, 0.148365, 0.372844], "hs" -> 
           RGBColor[0.701289, 0.13207, 0.351243], "mt" -> 
           RGBColor[0.700363, 0.117385, 0.330968], "ds" -> 
           RGBColor[0.697348, 0.10431, 0.31202], "rg" -> 
           RGBColor[0.692245, 0.0928444, 0.294398], "cn" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "nh" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "fl" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "mc" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "lv" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "ts" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "og" -> 
           RGBColor[0.635401, 0.0528, 0.226184], "uub" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "uut" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "uuq" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "uup" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "uuh" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "uus" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "uuo" -> 
           RGBColor[0.635401, 0.0528, 0.226184]}]]& ][0.85], 
       ColorDataFunction[
       "Atoms", 
        "Named", {{
         "H", "He", "Li", "Be", "B", "C", "N", "O", "F", "Ne", "Na", "Mg", 
          "Al", "Si", "P", "S", "Cl", "Ar", "K", "Ca", "Sc", "Ti", "V", "Cr", 
          "Mn", "Fe", "Co", "Ni", "Cu", "Zn", "Ga", "Ge", "As", "Se", "Br", 
          "Kr", "Rb", "Sr", "Y", "Zr", "Nb", "Mo", "Tc", "Ru", "Rh", "Pd", 
          "Ag", "Cd", "In", "Sn", "Sb", "Te", "I", "Xe", "Cs", "Ba", "La", 
          "Ce", "Pr", "Nd", "Pm", "Sm", "Eu", "Gd", "Tb", "Dy", "Ho", "Er", 
          "Tm", "Yb", "Lu", "Hf", "Ta", "W", "Re", "Os", "Ir", "Pt", "Au", 
          "Hg", "Tl", "Pb", "Bi", "Po", "At", "Rn", "Fr", "Ra", "Ac", "Th", 
          "Pa", "U", "Np", "Pu", "Am", "Cm", "Bk", "Cf", "Es", "Fm", "Md", 
          "No", "Lr", "Rf", "Db", "Sg", "Bh", "Hs", "Mt", "Ds", "Rg", "Cn", 
          "Nh", "Fl", "Mc", "Lv", "Ts", "Og", "Uub", "Uut", "Uuq", "Uup", 
          "Uuh", "Uus", "Uuo"}, {
         "h", "he", "li", "be", "b", "c", "n", "o", "f", "ne", "na", "mg", 
          "al", "si", "p", "s", "cl", "ar", "k", "ca", "sc", "ti", "v", "cr", 
          "mn", "fe", "co", "ni", "cu", "zn", "ga", "ge", "as", "se", "br", 
          "kr", "rb", "sr", "y", "zr", "nb", "mo", "tc", "ru", "rh", "pd", 
          "ag", "cd", "in", "sn", "sb", "te", "i", "xe", "cs", "ba", "la", 
          "ce", "pr", "nd", "pm", "sm", "eu", "gd", "tb", "dy", "ho", "er", 
          "tm", "yb", "lu", "hf", "ta", "w", "re", "os", "ir", "pt", "au", 
          "hg", "tl", "pb", "bi", "po", "at", "rn", "fr", "ra", "ac", "th", 
          "pa", "u", "np", "pu", "am", "cm", "bk", "cf", "es", "fm", "md", 
          "no", "lr", "rf", "db", "sg", "bh", "hs", "mt", "ds", "rg", "cn", 
          "nh", "fl", "mc", "lv", "ts", "og", "uub", "uut", "uuq", "uup", 
          "uuh", "uus", "uuo"}}, Replace[#, 
         Dispatch[{
          "h" -> RGBColor[0.65, 0.7, 0.7], "he" -> RGBColor[0.836713, 1., 1.],
            "li" -> RGBColor[0.799435, 0.543572, 0.997559], "be" -> 
           RGBColor[0.770565, 0.964309, 0.0442359], "b" -> 
           RGBColor[1., 0.709804, 0.709804], "c" -> RGBColor[0.4, 0.4, 0.4], 
           "n" -> RGBColor[0.291989, 0.437977, 0.888609], "o" -> 
           RGBColor[0.800498, 0.201504, 0.192061], "f" -> 
           RGBColor[0.578462, 0.85539, 0.408855], "ne" -> 
           RGBColor[0.677263, 0.928423, 0.955287], "na" -> 
           RGBColor[0.658708, 0.492173, 0.842842], "mg" -> 
           RGBColor[0.628274, 0.850553, 0.0782731], "al" -> 
           RGBColor[0.8913, 0.631904, 0.627399], "si" -> 
           RGBColor[0.941176, 0.784314, 0.627451], "p" -> 
           RGBColor[1., 0.501961, 0], "s" -> 
           RGBColor[0.90443, 0.97015, 0.13504], "cl" -> 
           RGBColor[0.412698, 0.932689, 0.166398], "ar" -> 
           RGBColor[0.546138, 0.844244, 0.892092], "k" -> 
           RGBColor[0.534026, 0.420729, 0.705621], "ca" -> 
           RGBColor[0.480072, 0.744591, 0.0955222], "sc" -> 
           RGBColor[0.901961, 0.901961, 0.901961], "ti" -> 
           RGBColor[0.74902, 0.760784, 0.780392], "v" -> 
           RGBColor[0.65098, 0.65098, 0.670588], "cr" -> 
           RGBColor[0.541176, 0.6, 0.780392], "mn" -> 
           RGBColor[0.611765, 0.478431, 0.780392], "fe" -> 
           RGBColor[0.878431, 0.4, 0.2], "co" -> 
           RGBColor[0.941176, 0.564706, 0.627451], "ni" -> 
           RGBColor[0.313725, 0.815686, 0.313725], "cu" -> 
           RGBColor[0.784314, 0.501961, 0.2], "zn" -> 
           RGBColor[0.490196, 0.501961, 0.690196], "ga" -> 
           RGBColor[0.800757, 0.542666, 0.533513], "ge" -> 
           RGBColor[0.60508, 0.632465, 0.576489], "as" -> 
           RGBColor[0.741176, 0.501961, 0.890196], "se" -> 
           RGBColor[0.917248, 0.657833, 0.0706628], "br" -> 
           RGBColor[0.58847, 0.22163, 0.16064], "kr" -> 
           RGBColor[0.426019, 0.747462, 0.810413], "rb" -> 
           RGBColor[0.425391, 0.329242, 0.585895], "sr" -> 
           RGBColor[0.325959, 0.646423, 0.095983], "y" -> 
           RGBColor[0.531014, 1., 1.], "zr" -> 
           RGBColor[0.458599, 0.917466, 0.918573], "nb" -> 
           RGBColor[0.385036, 0.834854, 0.841681], "mo" -> 
           RGBColor[0.310325, 0.752163, 0.769323], "tc" -> 
           RGBColor[0.234466, 0.669394, 0.701499], "ru" -> 
           RGBColor[0.157459, 0.586546, 0.638209], "rh" -> 
           RGBColor[0.0793033, 0.50362, 0.579453], "pd" -> 
           RGBColor[0., 0.420615, 0.525231], "ag" -> 
           RGBColor[0.752941, 0.752941, 0.752941], "cd" -> 
           RGBColor[1., 0.85098, 0.560784], "in" -> 
           RGBColor[0.728371, 0.440594, 0.422196], "sn" -> 
           RGBColor[0.39799, 0.491477, 0.495586], "sb" -> 
           RGBColor[0.619608, 0.388235, 0.709804], "te" -> 
           RGBColor[0.816706, 0.451332, 0.0100947], "i" -> 
           RGBColor[0.580392, 0, 0.580392], "xe" -> 
           RGBColor[0.316906, 0.638078, 0.710252], "cs" -> 
           RGBColor[0.332803, 0.217712, 0.483666], "ba" -> 
           RGBColor[0.165935, 0.55605, 0.0796556], "la" -> 
           RGBColor[0.928084, 0.716075, 0.329427], "ce" -> 
           RGBColor[0.894824, 0.731424, 0.325131], "pr" -> 
           RGBColor[0.86523, 0.707999, 0.315261], "nd" -> 
           RGBColor[0.837836, 0.662974, 0.301635], "pm" -> 
           RGBColor[0.811992, 0.607859, 0.285626], "sm" -> 
           RGBColor[0.787563, 0.549894, 0.268279], "eu" -> 
           RGBColor[0.764628, 0.493261, 0.250405], "gd" -> 
           RGBColor[0.743177, 0.440115, 0.23269], "tb" -> 
           RGBColor[0.72281, 0.39143, 0.215783], "dy" -> 
           RGBColor[0.702434, 0.347663, 0.200392], "ho" -> 
           RGBColor[0.679962, 0.309234, 0.187368], "er" -> 
           RGBColor[0.652012, 0.276823, 0.17779], "tm" -> 
           RGBColor[0.613603, 0.251489, 0.173042], "yb" -> 
           RGBColor[0.557855, 0.234598, 0.17489], "lu" -> 
           RGBColor[0.475685, 0.227573, 0.18555], "hf" -> 
           RGBColor[0.781537, 0.717388, 0.716579], "ta" -> 
           RGBColor[0.734443, 0.544489, 0.683471], "w" -> 
           RGBColor[0.681179, 0.360409, 0.63675], "re" -> 
           RGBColor[0.605181, 0.367584, 0.556343], "os" -> 
           RGBColor[0.521806, 0.382125, 0.469204], "ir" -> 
           RGBColor[0.445624, 0.373159, 0.399069], "pt" -> 
           RGBColor[0.815686, 0.815686, 0.878431], "au" -> 
           RGBColor[1., 0.819608, 0.137255], "hg" -> 
           RGBColor[0.721569, 0.721569, 0.815686], "tl" -> 
           RGBColor[0.65098, 0.329412, 0.301961], "pb" -> 
           RGBColor[0.341176, 0.34902, 0.380392], "bi" -> 
           RGBColor[0.619608, 0.309804, 0.709804], "po" -> 
           RGBColor[0.670588, 0.360784, 0], "at" -> 
           RGBColor[0.458824, 0.309804, 0.270588], "rn" -> 
           RGBColor[0.218799, 0.516091, 0.591608], "fr" -> 
           RGBColor[0.25626, 0.0861372, 0.398932], "ra" -> 
           RGBColor[0., 0.473472, 0.04654], "ac" -> 
           RGBColor[0.322042, 0.71693, 0.988479], "th" -> 
           RGBColor[0.3608, 0.67166, 0.943003], "pa" -> 
           RGBColor[0.397469, 0.628, 0.898853], "u" -> 
           RGBColor[0.43205, 0.58595, 0.856029], "np" -> 
           RGBColor[0.464542, 0.54551, 0.814532], "pu" -> 
           RGBColor[0.494945, 0.506679, 0.774361], "am" -> 
           RGBColor[0.52326, 0.469458, 0.735517], "cm" -> 
           RGBColor[0.549486, 0.433847, 0.697999], "bk" -> 
           RGBColor[0.573624, 0.399845, 0.661808], "cf" -> 
           RGBColor[0.595673, 0.367454, 0.626942], "es" -> 
           RGBColor[0.615633, 0.336672, 0.593404], "fm" -> 
           RGBColor[0.633505, 0.307499, 0.561191], "md" -> 
           RGBColor[0.649288, 0.279937, 0.530305], "no" -> 
           RGBColor[0.662982, 0.253984, 0.500746], "lr" -> 
           RGBColor[0.674588, 0.22964, 0.472513], "rf" -> 
           RGBColor[0.684106, 0.206907, 0.445606], "db" -> 
           RGBColor[0.691534, 0.185783, 0.420025], "sg" -> 
           RGBColor[0.696874, 0.166269, 0.395772], "bh" -> 
           RGBColor[0.700126, 0.148365, 0.372844], "hs" -> 
           RGBColor[0.701289, 0.13207, 0.351243], "mt" -> 
           RGBColor[0.700363, 0.117385, 0.330968], "ds" -> 
           RGBColor[0.697348, 0.10431, 0.31202], "rg" -> 
           RGBColor[0.692245, 0.0928444, 0.294398], "cn" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "nh" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "fl" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "mc" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "lv" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "ts" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "og" -> 
           RGBColor[0.635401, 0.0528, 0.226184], "uub" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "uut" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "uuq" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "uup" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "uuh" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "uus" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "uuo" -> 
           RGBColor[0.635401, 0.0528, 0.226184]}]]& ][0.85], 
       ColorDataFunction[
       "Atoms", 
        "Named", {{
         "H", "He", "Li", "Be", "B", "C", "N", "O", "F", "Ne", "Na", "Mg", 
          "Al", "Si", "P", "S", "Cl", "Ar", "K", "Ca", "Sc", "Ti", "V", "Cr", 
          "Mn", "Fe", "Co", "Ni", "Cu", "Zn", "Ga", "Ge", "As", "Se", "Br", 
          "Kr", "Rb", "Sr", "Y", "Zr", "Nb", "Mo", "Tc", "Ru", "Rh", "Pd", 
          "Ag", "Cd", "In", "Sn", "Sb", "Te", "I", "Xe", "Cs", "Ba", "La", 
          "Ce", "Pr", "Nd", "Pm", "Sm", "Eu", "Gd", "Tb", "Dy", "Ho", "Er", 
          "Tm", "Yb", "Lu", "Hf", "Ta", "W", "Re", "Os", "Ir", "Pt", "Au", 
          "Hg", "Tl", "Pb", "Bi", "Po", "At", "Rn", "Fr", "Ra", "Ac", "Th", 
          "Pa", "U", "Np", "Pu", "Am", "Cm", "Bk", "Cf", "Es", "Fm", "Md", 
          "No", "Lr", "Rf", "Db", "Sg", "Bh", "Hs", "Mt", "Ds", "Rg", "Cn", 
          "Nh", "Fl", "Mc", "Lv", "Ts", "Og", "Uub", "Uut", "Uuq", "Uup", 
          "Uuh", "Uus", "Uuo"}, {
         "h", "he", "li", "be", "b", "c", "n", "o", "f", "ne", "na", "mg", 
          "al", "si", "p", "s", "cl", "ar", "k", "ca", "sc", "ti", "v", "cr", 
          "mn", "fe", "co", "ni", "cu", "zn", "ga", "ge", "as", "se", "br", 
          "kr", "rb", "sr", "y", "zr", "nb", "mo", "tc", "ru", "rh", "pd", 
          "ag", "cd", "in", "sn", "sb", "te", "i", "xe", "cs", "ba", "la", 
          "ce", "pr", "nd", "pm", "sm", "eu", "gd", "tb", "dy", "ho", "er", 
          "tm", "yb", "lu", "hf", "ta", "w", "re", "os", "ir", "pt", "au", 
          "hg", "tl", "pb", "bi", "po", "at", "rn", "fr", "ra", "ac", "th", 
          "pa", "u", "np", "pu", "am", "cm", "bk", "cf", "es", "fm", "md", 
          "no", "lr", "rf", "db", "sg", "bh", "hs", "mt", "ds", "rg", "cn", 
          "nh", "fl", "mc", "lv", "ts", "og", "uub", "uut", "uuq", "uup", 
          "uuh", "uus", "uuo"}}, Replace[#, 
         Dispatch[{
          "h" -> RGBColor[0.65, 0.7, 0.7], "he" -> RGBColor[0.836713, 1., 1.],
            "li" -> RGBColor[0.799435, 0.543572, 0.997559], "be" -> 
           RGBColor[0.770565, 0.964309, 0.0442359], "b" -> 
           RGBColor[1., 0.709804, 0.709804], "c" -> RGBColor[0.4, 0.4, 0.4], 
           "n" -> RGBColor[0.291989, 0.437977, 0.888609], "o" -> 
           RGBColor[0.800498, 0.201504, 0.192061], "f" -> 
           RGBColor[0.578462, 0.85539, 0.408855], "ne" -> 
           RGBColor[0.677263, 0.928423, 0.955287], "na" -> 
           RGBColor[0.658708, 0.492173, 0.842842], "mg" -> 
           RGBColor[0.628274, 0.850553, 0.0782731], "al" -> 
           RGBColor[0.8913, 0.631904, 0.627399], "si" -> 
           RGBColor[0.941176, 0.784314, 0.627451], "p" -> 
           RGBColor[1., 0.501961, 0], "s" -> 
           RGBColor[0.90443, 0.97015, 0.13504], "cl" -> 
           RGBColor[0.412698, 0.932689, 0.166398], "ar" -> 
           RGBColor[0.546138, 0.844244, 0.892092], "k" -> 
           RGBColor[0.534026, 0.420729, 0.705621], "ca" -> 
           RGBColor[0.480072, 0.744591, 0.0955222], "sc" -> 
           RGBColor[0.901961, 0.901961, 0.901961], "ti" -> 
           RGBColor[0.74902, 0.760784, 0.780392], "v" -> 
           RGBColor[0.65098, 0.65098, 0.670588], "cr" -> 
           RGBColor[0.541176, 0.6, 0.780392], "mn" -> 
           RGBColor[0.611765, 0.478431, 0.780392], "fe" -> 
           RGBColor[0.878431, 0.4, 0.2], "co" -> 
           RGBColor[0.941176, 0.564706, 0.627451], "ni" -> 
           RGBColor[0.313725, 0.815686, 0.313725], "cu" -> 
           RGBColor[0.784314, 0.501961, 0.2], "zn" -> 
           RGBColor[0.490196, 0.501961, 0.690196], "ga" -> 
           RGBColor[0.800757, 0.542666, 0.533513], "ge" -> 
           RGBColor[0.60508, 0.632465, 0.576489], "as" -> 
           RGBColor[0.741176, 0.501961, 0.890196], "se" -> 
           RGBColor[0.917248, 0.657833, 0.0706628], "br" -> 
           RGBColor[0.58847, 0.22163, 0.16064], "kr" -> 
           RGBColor[0.426019, 0.747462, 0.810413], "rb" -> 
           RGBColor[0.425391, 0.329242, 0.585895], "sr" -> 
           RGBColor[0.325959, 0.646423, 0.095983], "y" -> 
           RGBColor[0.531014, 1., 1.], "zr" -> 
           RGBColor[0.458599, 0.917466, 0.918573], "nb" -> 
           RGBColor[0.385036, 0.834854, 0.841681], "mo" -> 
           RGBColor[0.310325, 0.752163, 0.769323], "tc" -> 
           RGBColor[0.234466, 0.669394, 0.701499], "ru" -> 
           RGBColor[0.157459, 0.586546, 0.638209], "rh" -> 
           RGBColor[0.0793033, 0.50362, 0.579453], "pd" -> 
           RGBColor[0., 0.420615, 0.525231], "ag" -> 
           RGBColor[0.752941, 0.752941, 0.752941], "cd" -> 
           RGBColor[1., 0.85098, 0.560784], "in" -> 
           RGBColor[0.728371, 0.440594, 0.422196], "sn" -> 
           RGBColor[0.39799, 0.491477, 0.495586], "sb" -> 
           RGBColor[0.619608, 0.388235, 0.709804], "te" -> 
           RGBColor[0.816706, 0.451332, 0.0100947], "i" -> 
           RGBColor[0.580392, 0, 0.580392], "xe" -> 
           RGBColor[0.316906, 0.638078, 0.710252], "cs" -> 
           RGBColor[0.332803, 0.217712, 0.483666], "ba" -> 
           RGBColor[0.165935, 0.55605, 0.0796556], "la" -> 
           RGBColor[0.928084, 0.716075, 0.329427], "ce" -> 
           RGBColor[0.894824, 0.731424, 0.325131], "pr" -> 
           RGBColor[0.86523, 0.707999, 0.315261], "nd" -> 
           RGBColor[0.837836, 0.662974, 0.301635], "pm" -> 
           RGBColor[0.811992, 0.607859, 0.285626], "sm" -> 
           RGBColor[0.787563, 0.549894, 0.268279], "eu" -> 
           RGBColor[0.764628, 0.493261, 0.250405], "gd" -> 
           RGBColor[0.743177, 0.440115, 0.23269], "tb" -> 
           RGBColor[0.72281, 0.39143, 0.215783], "dy" -> 
           RGBColor[0.702434, 0.347663, 0.200392], "ho" -> 
           RGBColor[0.679962, 0.309234, 0.187368], "er" -> 
           RGBColor[0.652012, 0.276823, 0.17779], "tm" -> 
           RGBColor[0.613603, 0.251489, 0.173042], "yb" -> 
           RGBColor[0.557855, 0.234598, 0.17489], "lu" -> 
           RGBColor[0.475685, 0.227573, 0.18555], "hf" -> 
           RGBColor[0.781537, 0.717388, 0.716579], "ta" -> 
           RGBColor[0.734443, 0.544489, 0.683471], "w" -> 
           RGBColor[0.681179, 0.360409, 0.63675], "re" -> 
           RGBColor[0.605181, 0.367584, 0.556343], "os" -> 
           RGBColor[0.521806, 0.382125, 0.469204], "ir" -> 
           RGBColor[0.445624, 0.373159, 0.399069], "pt" -> 
           RGBColor[0.815686, 0.815686, 0.878431], "au" -> 
           RGBColor[1., 0.819608, 0.137255], "hg" -> 
           RGBColor[0.721569, 0.721569, 0.815686], "tl" -> 
           RGBColor[0.65098, 0.329412, 0.301961], "pb" -> 
           RGBColor[0.341176, 0.34902, 0.380392], "bi" -> 
           RGBColor[0.619608, 0.309804, 0.709804], "po" -> 
           RGBColor[0.670588, 0.360784, 0], "at" -> 
           RGBColor[0.458824, 0.309804, 0.270588], "rn" -> 
           RGBColor[0.218799, 0.516091, 0.591608], "fr" -> 
           RGBColor[0.25626, 0.0861372, 0.398932], "ra" -> 
           RGBColor[0., 0.473472, 0.04654], "ac" -> 
           RGBColor[0.322042, 0.71693, 0.988479], "th" -> 
           RGBColor[0.3608, 0.67166, 0.943003], "pa" -> 
           RGBColor[0.397469, 0.628, 0.898853], "u" -> 
           RGBColor[0.43205, 0.58595, 0.856029], "np" -> 
           RGBColor[0.464542, 0.54551, 0.814532], "pu" -> 
           RGBColor[0.494945, 0.506679, 0.774361], "am" -> 
           RGBColor[0.52326, 0.469458, 0.735517], "cm" -> 
           RGBColor[0.549486, 0.433847, 0.697999], "bk" -> 
           RGBColor[0.573624, 0.399845, 0.661808], "cf" -> 
           RGBColor[0.595673, 0.367454, 0.626942], "es" -> 
           RGBColor[0.615633, 0.336672, 0.593404], "fm" -> 
           RGBColor[0.633505, 0.307499, 0.561191], "md" -> 
           RGBColor[0.649288, 0.279937, 0.530305], "no" -> 
           RGBColor[0.662982, 0.253984, 0.500746], "lr" -> 
           RGBColor[0.674588, 0.22964, 0.472513], "rf" -> 
           RGBColor[0.684106, 0.206907, 0.445606], "db" -> 
           RGBColor[0.691534, 0.185783, 0.420025], "sg" -> 
           RGBColor[0.696874, 0.166269, 0.395772], "bh" -> 
           RGBColor[0.700126, 0.148365, 0.372844], "hs" -> 
           RGBColor[0.701289, 0.13207, 0.351243], "mt" -> 
           RGBColor[0.700363, 0.117385, 0.330968], "ds" -> 
           RGBColor[0.697348, 0.10431, 0.31202], "rg" -> 
           RGBColor[0.692245, 0.0928444, 0.294398], "cn" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "nh" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "fl" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "mc" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "lv" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "ts" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "og" -> 
           RGBColor[0.635401, 0.0528, 0.226184], "uub" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "uut" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "uuq" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "uup" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "uuh" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "uus" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "uuo" -> 
           RGBColor[0.635401, 0.0528, 0.226184]}]]& ][0.85], 
       ColorDataFunction[
       "Atoms", 
        "Named", {{
         "H", "He", "Li", "Be", "B", "C", "N", "O", "F", "Ne", "Na", "Mg", 
          "Al", "Si", "P", "S", "Cl", "Ar", "K", "Ca", "Sc", "Ti", "V", "Cr", 
          "Mn", "Fe", "Co", "Ni", "Cu", "Zn", "Ga", "Ge", "As", "Se", "Br", 
          "Kr", "Rb", "Sr", "Y", "Zr", "Nb", "Mo", "Tc", "Ru", "Rh", "Pd", 
          "Ag", "Cd", "In", "Sn", "Sb", "Te", "I", "Xe", "Cs", "Ba", "La", 
          "Ce", "Pr", "Nd", "Pm", "Sm", "Eu", "Gd", "Tb", "Dy", "Ho", "Er", 
          "Tm", "Yb", "Lu", "Hf", "Ta", "W", "Re", "Os", "Ir", "Pt", "Au", 
          "Hg", "Tl", "Pb", "Bi", "Po", "At", "Rn", "Fr", "Ra", "Ac", "Th", 
          "Pa", "U", "Np", "Pu", "Am", "Cm", "Bk", "Cf", "Es", "Fm", "Md", 
          "No", "Lr", "Rf", "Db", "Sg", "Bh", "Hs", "Mt", "Ds", "Rg", "Cn", 
          "Nh", "Fl", "Mc", "Lv", "Ts", "Og", "Uub", "Uut", "Uuq", "Uup", 
          "Uuh", "Uus", "Uuo"}, {
         "h", "he", "li", "be", "b", "c", "n", "o", "f", "ne", "na", "mg", 
          "al", "si", "p", "s", "cl", "ar", "k", "ca", "sc", "ti", "v", "cr", 
          "mn", "fe", "co", "ni", "cu", "zn", "ga", "ge", "as", "se", "br", 
          "kr", "rb", "sr", "y", "zr", "nb", "mo", "tc", "ru", "rh", "pd", 
          "ag", "cd", "in", "sn", "sb", "te", "i", "xe", "cs", "ba", "la", 
          "ce", "pr", "nd", "pm", "sm", "eu", "gd", "tb", "dy", "ho", "er", 
          "tm", "yb", "lu", "hf", "ta", "w", "re", "os", "ir", "pt", "au", 
          "hg", "tl", "pb", "bi", "po", "at", "rn", "fr", "ra", "ac", "th", 
          "pa", "u", "np", "pu", "am", "cm", "bk", "cf", "es", "fm", "md", 
          "no", "lr", "rf", "db", "sg", "bh", "hs", "mt", "ds", "rg", "cn", 
          "nh", "fl", "mc", "lv", "ts", "og", "uub", "uut", "uuq", "uup", 
          "uuh", "uus", "uuo"}}, Replace[#, 
         Dispatch[{
          "h" -> RGBColor[0.65, 0.7, 0.7], "he" -> RGBColor[0.836713, 1., 1.],
            "li" -> RGBColor[0.799435, 0.543572, 0.997559], "be" -> 
           RGBColor[0.770565, 0.964309, 0.0442359], "b" -> 
           RGBColor[1., 0.709804, 0.709804], "c" -> RGBColor[0.4, 0.4, 0.4], 
           "n" -> RGBColor[0.291989, 0.437977, 0.888609], "o" -> 
           RGBColor[0.800498, 0.201504, 0.192061], "f" -> 
           RGBColor[0.578462, 0.85539, 0.408855], "ne" -> 
           RGBColor[0.677263, 0.928423, 0.955287], "na" -> 
           RGBColor[0.658708, 0.492173, 0.842842], "mg" -> 
           RGBColor[0.628274, 0.850553, 0.0782731], "al" -> 
           RGBColor[0.8913, 0.631904, 0.627399], "si" -> 
           RGBColor[0.941176, 0.784314, 0.627451], "p" -> 
           RGBColor[1., 0.501961, 0], "s" -> 
           RGBColor[0.90443, 0.97015, 0.13504], "cl" -> 
           RGBColor[0.412698, 0.932689, 0.166398], "ar" -> 
           RGBColor[0.546138, 0.844244, 0.892092], "k" -> 
           RGBColor[0.534026, 0.420729, 0.705621], "ca" -> 
           RGBColor[0.480072, 0.744591, 0.0955222], "sc" -> 
           RGBColor[0.901961, 0.901961, 0.901961], "ti" -> 
           RGBColor[0.74902, 0.760784, 0.780392], "v" -> 
           RGBColor[0.65098, 0.65098, 0.670588], "cr" -> 
           RGBColor[0.541176, 0.6, 0.780392], "mn" -> 
           RGBColor[0.611765, 0.478431, 0.780392], "fe" -> 
           RGBColor[0.878431, 0.4, 0.2], "co" -> 
           RGBColor[0.941176, 0.564706, 0.627451], "ni" -> 
           RGBColor[0.313725, 0.815686, 0.313725], "cu" -> 
           RGBColor[0.784314, 0.501961, 0.2], "zn" -> 
           RGBColor[0.490196, 0.501961, 0.690196], "ga" -> 
           RGBColor[0.800757, 0.542666, 0.533513], "ge" -> 
           RGBColor[0.60508, 0.632465, 0.576489], "as" -> 
           RGBColor[0.741176, 0.501961, 0.890196], "se" -> 
           RGBColor[0.917248, 0.657833, 0.0706628], "br" -> 
           RGBColor[0.58847, 0.22163, 0.16064], "kr" -> 
           RGBColor[0.426019, 0.747462, 0.810413], "rb" -> 
           RGBColor[0.425391, 0.329242, 0.585895], "sr" -> 
           RGBColor[0.325959, 0.646423, 0.095983], "y" -> 
           RGBColor[0.531014, 1., 1.], "zr" -> 
           RGBColor[0.458599, 0.917466, 0.918573], "nb" -> 
           RGBColor[0.385036, 0.834854, 0.841681], "mo" -> 
           RGBColor[0.310325, 0.752163, 0.769323], "tc" -> 
           RGBColor[0.234466, 0.669394, 0.701499], "ru" -> 
           RGBColor[0.157459, 0.586546, 0.638209], "rh" -> 
           RGBColor[0.0793033, 0.50362, 0.579453], "pd" -> 
           RGBColor[0., 0.420615, 0.525231], "ag" -> 
           RGBColor[0.752941, 0.752941, 0.752941], "cd" -> 
           RGBColor[1., 0.85098, 0.560784], "in" -> 
           RGBColor[0.728371, 0.440594, 0.422196], "sn" -> 
           RGBColor[0.39799, 0.491477, 0.495586], "sb" -> 
           RGBColor[0.619608, 0.388235, 0.709804], "te" -> 
           RGBColor[0.816706, 0.451332, 0.0100947], "i" -> 
           RGBColor[0.580392, 0, 0.580392], "xe" -> 
           RGBColor[0.316906, 0.638078, 0.710252], "cs" -> 
           RGBColor[0.332803, 0.217712, 0.483666], "ba" -> 
           RGBColor[0.165935, 0.55605, 0.0796556], "la" -> 
           RGBColor[0.928084, 0.716075, 0.329427], "ce" -> 
           RGBColor[0.894824, 0.731424, 0.325131], "pr" -> 
           RGBColor[0.86523, 0.707999, 0.315261], "nd" -> 
           RGBColor[0.837836, 0.662974, 0.301635], "pm" -> 
           RGBColor[0.811992, 0.607859, 0.285626], "sm" -> 
           RGBColor[0.787563, 0.549894, 0.268279], "eu" -> 
           RGBColor[0.764628, 0.493261, 0.250405], "gd" -> 
           RGBColor[0.743177, 0.440115, 0.23269], "tb" -> 
           RGBColor[0.72281, 0.39143, 0.215783], "dy" -> 
           RGBColor[0.702434, 0.347663, 0.200392], "ho" -> 
           RGBColor[0.679962, 0.309234, 0.187368], "er" -> 
           RGBColor[0.652012, 0.276823, 0.17779], "tm" -> 
           RGBColor[0.613603, 0.251489, 0.173042], "yb" -> 
           RGBColor[0.557855, 0.234598, 0.17489], "lu" -> 
           RGBColor[0.475685, 0.227573, 0.18555], "hf" -> 
           RGBColor[0.781537, 0.717388, 0.716579], "ta" -> 
           RGBColor[0.734443, 0.544489, 0.683471], "w" -> 
           RGBColor[0.681179, 0.360409, 0.63675], "re" -> 
           RGBColor[0.605181, 0.367584, 0.556343], "os" -> 
           RGBColor[0.521806, 0.382125, 0.469204], "ir" -> 
           RGBColor[0.445624, 0.373159, 0.399069], "pt" -> 
           RGBColor[0.815686, 0.815686, 0.878431], "au" -> 
           RGBColor[1., 0.819608, 0.137255], "hg" -> 
           RGBColor[0.721569, 0.721569, 0.815686], "tl" -> 
           RGBColor[0.65098, 0.329412, 0.301961], "pb" -> 
           RGBColor[0.341176, 0.34902, 0.380392], "bi" -> 
           RGBColor[0.619608, 0.309804, 0.709804], "po" -> 
           RGBColor[0.670588, 0.360784, 0], "at" -> 
           RGBColor[0.458824, 0.309804, 0.270588], "rn" -> 
           RGBColor[0.218799, 0.516091, 0.591608], "fr" -> 
           RGBColor[0.25626, 0.0861372, 0.398932], "ra" -> 
           RGBColor[0., 0.473472, 0.04654], "ac" -> 
           RGBColor[0.322042, 0.71693, 0.988479], "th" -> 
           RGBColor[0.3608, 0.67166, 0.943003], "pa" -> 
           RGBColor[0.397469, 0.628, 0.898853], "u" -> 
           RGBColor[0.43205, 0.58595, 0.856029], "np" -> 
           RGBColor[0.464542, 0.54551, 0.814532], "pu" -> 
           RGBColor[0.494945, 0.506679, 0.774361], "am" -> 
           RGBColor[0.52326, 0.469458, 0.735517], "cm" -> 
           RGBColor[0.549486, 0.433847, 0.697999], "bk" -> 
           RGBColor[0.573624, 0.399845, 0.661808], "cf" -> 
           RGBColor[0.595673, 0.367454, 0.626942], "es" -> 
           RGBColor[0.615633, 0.336672, 0.593404], "fm" -> 
           RGBColor[0.633505, 0.307499, 0.561191], "md" -> 
           RGBColor[0.649288, 0.279937, 0.530305], "no" -> 
           RGBColor[0.662982, 0.253984, 0.500746], "lr" -> 
           RGBColor[0.674588, 0.22964, 0.472513], "rf" -> 
           RGBColor[0.684106, 0.206907, 0.445606], "db" -> 
           RGBColor[0.691534, 0.185783, 0.420025], "sg" -> 
           RGBColor[0.696874, 0.166269, 0.395772], "bh" -> 
           RGBColor[0.700126, 0.148365, 0.372844], "hs" -> 
           RGBColor[0.701289, 0.13207, 0.351243], "mt" -> 
           RGBColor[0.700363, 0.117385, 0.330968], "ds" -> 
           RGBColor[0.697348, 0.10431, 0.31202], "rg" -> 
           RGBColor[0.692245, 0.0928444, 0.294398], "cn" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "nh" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "fl" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "mc" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "lv" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "ts" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "og" -> 
           RGBColor[0.635401, 0.0528, 0.226184], "uub" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "uut" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "uuq" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "uup" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "uuh" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "uus" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "uuo" -> 
           RGBColor[0.635401, 0.0528, 0.226184]}]]& ][0.85], 
       ColorDataFunction[
       "Atoms", 
        "Named", {{
         "H", "He", "Li", "Be", "B", "C", "N", "O", "F", "Ne", "Na", "Mg", 
          "Al", "Si", "P", "S", "Cl", "Ar", "K", "Ca", "Sc", "Ti", "V", "Cr", 
          "Mn", "Fe", "Co", "Ni", "Cu", "Zn", "Ga", "Ge", "As", "Se", "Br", 
          "Kr", "Rb", "Sr", "Y", "Zr", "Nb", "Mo", "Tc", "Ru", "Rh", "Pd", 
          "Ag", "Cd", "In", "Sn", "Sb", "Te", "I", "Xe", "Cs", "Ba", "La", 
          "Ce", "Pr", "Nd", "Pm", "Sm", "Eu", "Gd", "Tb", "Dy", "Ho", "Er", 
          "Tm", "Yb", "Lu", "Hf", "Ta", "W", "Re", "Os", "Ir", "Pt", "Au", 
          "Hg", "Tl", "Pb", "Bi", "Po", "At", "Rn", "Fr", "Ra", "Ac", "Th", 
          "Pa", "U", "Np", "Pu", "Am", "Cm", "Bk", "Cf", "Es", "Fm", "Md", 
          "No", "Lr", "Rf", "Db", "Sg", "Bh", "Hs", "Mt", "Ds", "Rg", "Cn", 
          "Nh", "Fl", "Mc", "Lv", "Ts", "Og", "Uub", "Uut", "Uuq", "Uup", 
          "Uuh", "Uus", "Uuo"}, {
         "h", "he", "li", "be", "b", "c", "n", "o", "f", "ne", "na", "mg", 
          "al", "si", "p", "s", "cl", "ar", "k", "ca", "sc", "ti", "v", "cr", 
          "mn", "fe", "co", "ni", "cu", "zn", "ga", "ge", "as", "se", "br", 
          "kr", "rb", "sr", "y", "zr", "nb", "mo", "tc", "ru", "rh", "pd", 
          "ag", "cd", "in", "sn", "sb", "te", "i", "xe", "cs", "ba", "la", 
          "ce", "pr", "nd", "pm", "sm", "eu", "gd", "tb", "dy", "ho", "er", 
          "tm", "yb", "lu", "hf", "ta", "w", "re", "os", "ir", "pt", "au", 
          "hg", "tl", "pb", "bi", "po", "at", "rn", "fr", "ra", "ac", "th", 
          "pa", "u", "np", "pu", "am", "cm", "bk", "cf", "es", "fm", "md", 
          "no", "lr", "rf", "db", "sg", "bh", "hs", "mt", "ds", "rg", "cn", 
          "nh", "fl", "mc", "lv", "ts", "og", "uub", "uut", "uuq", "uup", 
          "uuh", "uus", "uuo"}}, Replace[#, 
         Dispatch[{
          "h" -> RGBColor[0.65, 0.7, 0.7], "he" -> RGBColor[0.836713, 1., 1.],
            "li" -> RGBColor[0.799435, 0.543572, 0.997559], "be" -> 
           RGBColor[0.770565, 0.964309, 0.0442359], "b" -> 
           RGBColor[1., 0.709804, 0.709804], "c" -> RGBColor[0.4, 0.4, 0.4], 
           "n" -> RGBColor[0.291989, 0.437977, 0.888609], "o" -> 
           RGBColor[0.800498, 0.201504, 0.192061], "f" -> 
           RGBColor[0.578462, 0.85539, 0.408855], "ne" -> 
           RGBColor[0.677263, 0.928423, 0.955287], "na" -> 
           RGBColor[0.658708, 0.492173, 0.842842], "mg" -> 
           RGBColor[0.628274, 0.850553, 0.0782731], "al" -> 
           RGBColor[0.8913, 0.631904, 0.627399], "si" -> 
           RGBColor[0.941176, 0.784314, 0.627451], "p" -> 
           RGBColor[1., 0.501961, 0], "s" -> 
           RGBColor[0.90443, 0.97015, 0.13504], "cl" -> 
           RGBColor[0.412698, 0.932689, 0.166398], "ar" -> 
           RGBColor[0.546138, 0.844244, 0.892092], "k" -> 
           RGBColor[0.534026, 0.420729, 0.705621], "ca" -> 
           RGBColor[0.480072, 0.744591, 0.0955222], "sc" -> 
           RGBColor[0.901961, 0.901961, 0.901961], "ti" -> 
           RGBColor[0.74902, 0.760784, 0.780392], "v" -> 
           RGBColor[0.65098, 0.65098, 0.670588], "cr" -> 
           RGBColor[0.541176, 0.6, 0.780392], "mn" -> 
           RGBColor[0.611765, 0.478431, 0.780392], "fe" -> 
           RGBColor[0.878431, 0.4, 0.2], "co" -> 
           RGBColor[0.941176, 0.564706, 0.627451], "ni" -> 
           RGBColor[0.313725, 0.815686, 0.313725], "cu" -> 
           RGBColor[0.784314, 0.501961, 0.2], "zn" -> 
           RGBColor[0.490196, 0.501961, 0.690196], "ga" -> 
           RGBColor[0.800757, 0.542666, 0.533513], "ge" -> 
           RGBColor[0.60508, 0.632465, 0.576489], "as" -> 
           RGBColor[0.741176, 0.501961, 0.890196], "se" -> 
           RGBColor[0.917248, 0.657833, 0.0706628], "br" -> 
           RGBColor[0.58847, 0.22163, 0.16064], "kr" -> 
           RGBColor[0.426019, 0.747462, 0.810413], "rb" -> 
           RGBColor[0.425391, 0.329242, 0.585895], "sr" -> 
           RGBColor[0.325959, 0.646423, 0.095983], "y" -> 
           RGBColor[0.531014, 1., 1.], "zr" -> 
           RGBColor[0.458599, 0.917466, 0.918573], "nb" -> 
           RGBColor[0.385036, 0.834854, 0.841681], "mo" -> 
           RGBColor[0.310325, 0.752163, 0.769323], "tc" -> 
           RGBColor[0.234466, 0.669394, 0.701499], "ru" -> 
           RGBColor[0.157459, 0.586546, 0.638209], "rh" -> 
           RGBColor[0.0793033, 0.50362, 0.579453], "pd" -> 
           RGBColor[0., 0.420615, 0.525231], "ag" -> 
           RGBColor[0.752941, 0.752941, 0.752941], "cd" -> 
           RGBColor[1., 0.85098, 0.560784], "in" -> 
           RGBColor[0.728371, 0.440594, 0.422196], "sn" -> 
           RGBColor[0.39799, 0.491477, 0.495586], "sb" -> 
           RGBColor[0.619608, 0.388235, 0.709804], "te" -> 
           RGBColor[0.816706, 0.451332, 0.0100947], "i" -> 
           RGBColor[0.580392, 0, 0.580392], "xe" -> 
           RGBColor[0.316906, 0.638078, 0.710252], "cs" -> 
           RGBColor[0.332803, 0.217712, 0.483666], "ba" -> 
           RGBColor[0.165935, 0.55605, 0.0796556], "la" -> 
           RGBColor[0.928084, 0.716075, 0.329427], "ce" -> 
           RGBColor[0.894824, 0.731424, 0.325131], "pr" -> 
           RGBColor[0.86523, 0.707999, 0.315261], "nd" -> 
           RGBColor[0.837836, 0.662974, 0.301635], "pm" -> 
           RGBColor[0.811992, 0.607859, 0.285626], "sm" -> 
           RGBColor[0.787563, 0.549894, 0.268279], "eu" -> 
           RGBColor[0.764628, 0.493261, 0.250405], "gd" -> 
           RGBColor[0.743177, 0.440115, 0.23269], "tb" -> 
           RGBColor[0.72281, 0.39143, 0.215783], "dy" -> 
           RGBColor[0.702434, 0.347663, 0.200392], "ho" -> 
           RGBColor[0.679962, 0.309234, 0.187368], "er" -> 
           RGBColor[0.652012, 0.276823, 0.17779], "tm" -> 
           RGBColor[0.613603, 0.251489, 0.173042], "yb" -> 
           RGBColor[0.557855, 0.234598, 0.17489], "lu" -> 
           RGBColor[0.475685, 0.227573, 0.18555], "hf" -> 
           RGBColor[0.781537, 0.717388, 0.716579], "ta" -> 
           RGBColor[0.734443, 0.544489, 0.683471], "w" -> 
           RGBColor[0.681179, 0.360409, 0.63675], "re" -> 
           RGBColor[0.605181, 0.367584, 0.556343], "os" -> 
           RGBColor[0.521806, 0.382125, 0.469204], "ir" -> 
           RGBColor[0.445624, 0.373159, 0.399069], "pt" -> 
           RGBColor[0.815686, 0.815686, 0.878431], "au" -> 
           RGBColor[1., 0.819608, 0.137255], "hg" -> 
           RGBColor[0.721569, 0.721569, 0.815686], "tl" -> 
           RGBColor[0.65098, 0.329412, 0.301961], "pb" -> 
           RGBColor[0.341176, 0.34902, 0.380392], "bi" -> 
           RGBColor[0.619608, 0.309804, 0.709804], "po" -> 
           RGBColor[0.670588, 0.360784, 0], "at" -> 
           RGBColor[0.458824, 0.309804, 0.270588], "rn" -> 
           RGBColor[0.218799, 0.516091, 0.591608], "fr" -> 
           RGBColor[0.25626, 0.0861372, 0.398932], "ra" -> 
           RGBColor[0., 0.473472, 0.04654], "ac" -> 
           RGBColor[0.322042, 0.71693, 0.988479], "th" -> 
           RGBColor[0.3608, 0.67166, 0.943003], "pa" -> 
           RGBColor[0.397469, 0.628, 0.898853], "u" -> 
           RGBColor[0.43205, 0.58595, 0.856029], "np" -> 
           RGBColor[0.464542, 0.54551, 0.814532], "pu" -> 
           RGBColor[0.494945, 0.506679, 0.774361], "am" -> 
           RGBColor[0.52326, 0.469458, 0.735517], "cm" -> 
           RGBColor[0.549486, 0.433847, 0.697999], "bk" -> 
           RGBColor[0.573624, 0.399845, 0.661808], "cf" -> 
           RGBColor[0.595673, 0.367454, 0.626942], "es" -> 
           RGBColor[0.615633, 0.336672, 0.593404], "fm" -> 
           RGBColor[0.633505, 0.307499, 0.561191], "md" -> 
           RGBColor[0.649288, 0.279937, 0.530305], "no" -> 
           RGBColor[0.662982, 0.253984, 0.500746], "lr" -> 
           RGBColor[0.674588, 0.22964, 0.472513], "rf" -> 
           RGBColor[0.684106, 0.206907, 0.445606], "db" -> 
           RGBColor[0.691534, 0.185783, 0.420025], "sg" -> 
           RGBColor[0.696874, 0.166269, 0.395772], "bh" -> 
           RGBColor[0.700126, 0.148365, 0.372844], "hs" -> 
           RGBColor[0.701289, 0.13207, 0.351243], "mt" -> 
           RGBColor[0.700363, 0.117385, 0.330968], "ds" -> 
           RGBColor[0.697348, 0.10431, 0.31202], "rg" -> 
           RGBColor[0.692245, 0.0928444, 0.294398], "cn" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "nh" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "fl" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "mc" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "lv" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "ts" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "og" -> 
           RGBColor[0.635401, 0.0528, 0.226184], "uub" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "uut" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "uuq" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "uup" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "uuh" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "uus" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "uuo" -> 
           RGBColor[0.635401, 0.0528, 0.226184]}]]& ][0.85], 
       ColorDataFunction[
       "Atoms", 
        "Named", {{
         "H", "He", "Li", "Be", "B", "C", "N", "O", "F", "Ne", "Na", "Mg", 
          "Al", "Si", "P", "S", "Cl", "Ar", "K", "Ca", "Sc", "Ti", "V", "Cr", 
          "Mn", "Fe", "Co", "Ni", "Cu", "Zn", "Ga", "Ge", "As", "Se", "Br", 
          "Kr", "Rb", "Sr", "Y", "Zr", "Nb", "Mo", "Tc", "Ru", "Rh", "Pd", 
          "Ag", "Cd", "In", "Sn", "Sb", "Te", "I", "Xe", "Cs", "Ba", "La", 
          "Ce", "Pr", "Nd", "Pm", "Sm", "Eu", "Gd", "Tb", "Dy", "Ho", "Er", 
          "Tm", "Yb", "Lu", "Hf", "Ta", "W", "Re", "Os", "Ir", "Pt", "Au", 
          "Hg", "Tl", "Pb", "Bi", "Po", "At", "Rn", "Fr", "Ra", "Ac", "Th", 
          "Pa", "U", "Np", "Pu", "Am", "Cm", "Bk", "Cf", "Es", "Fm", "Md", 
          "No", "Lr", "Rf", "Db", "Sg", "Bh", "Hs", "Mt", "Ds", "Rg", "Cn", 
          "Nh", "Fl", "Mc", "Lv", "Ts", "Og", "Uub", "Uut", "Uuq", "Uup", 
          "Uuh", "Uus", "Uuo"}, {
         "h", "he", "li", "be", "b", "c", "n", "o", "f", "ne", "na", "mg", 
          "al", "si", "p", "s", "cl", "ar", "k", "ca", "sc", "ti", "v", "cr", 
          "mn", "fe", "co", "ni", "cu", "zn", "ga", "ge", "as", "se", "br", 
          "kr", "rb", "sr", "y", "zr", "nb", "mo", "tc", "ru", "rh", "pd", 
          "ag", "cd", "in", "sn", "sb", "te", "i", "xe", "cs", "ba", "la", 
          "ce", "pr", "nd", "pm", "sm", "eu", "gd", "tb", "dy", "ho", "er", 
          "tm", "yb", "lu", "hf", "ta", "w", "re", "os", "ir", "pt", "au", 
          "hg", "tl", "pb", "bi", "po", "at", "rn", "fr", "ra", "ac", "th", 
          "pa", "u", "np", "pu", "am", "cm", "bk", "cf", "es", "fm", "md", 
          "no", "lr", "rf", "db", "sg", "bh", "hs", "mt", "ds", "rg", "cn", 
          "nh", "fl", "mc", "lv", "ts", "og", "uub", "uut", "uuq", "uup", 
          "uuh", "uus", "uuo"}}, Replace[#, 
         Dispatch[{
          "h" -> RGBColor[0.65, 0.7, 0.7], "he" -> RGBColor[0.836713, 1., 1.],
            "li" -> RGBColor[0.799435, 0.543572, 0.997559], "be" -> 
           RGBColor[0.770565, 0.964309, 0.0442359], "b" -> 
           RGBColor[1., 0.709804, 0.709804], "c" -> RGBColor[0.4, 0.4, 0.4], 
           "n" -> RGBColor[0.291989, 0.437977, 0.888609], "o" -> 
           RGBColor[0.800498, 0.201504, 0.192061], "f" -> 
           RGBColor[0.578462, 0.85539, 0.408855], "ne" -> 
           RGBColor[0.677263, 0.928423, 0.955287], "na" -> 
           RGBColor[0.658708, 0.492173, 0.842842], "mg" -> 
           RGBColor[0.628274, 0.850553, 0.0782731], "al" -> 
           RGBColor[0.8913, 0.631904, 0.627399], "si" -> 
           RGBColor[0.941176, 0.784314, 0.627451], "p" -> 
           RGBColor[1., 0.501961, 0], "s" -> 
           RGBColor[0.90443, 0.97015, 0.13504], "cl" -> 
           RGBColor[0.412698, 0.932689, 0.166398], "ar" -> 
           RGBColor[0.546138, 0.844244, 0.892092], "k" -> 
           RGBColor[0.534026, 0.420729, 0.705621], "ca" -> 
           RGBColor[0.480072, 0.744591, 0.0955222], "sc" -> 
           RGBColor[0.901961, 0.901961, 0.901961], "ti" -> 
           RGBColor[0.74902, 0.760784, 0.780392], "v" -> 
           RGBColor[0.65098, 0.65098, 0.670588], "cr" -> 
           RGBColor[0.541176, 0.6, 0.780392], "mn" -> 
           RGBColor[0.611765, 0.478431, 0.780392], "fe" -> 
           RGBColor[0.878431, 0.4, 0.2], "co" -> 
           RGBColor[0.941176, 0.564706, 0.627451], "ni" -> 
           RGBColor[0.313725, 0.815686, 0.313725], "cu" -> 
           RGBColor[0.784314, 0.501961, 0.2], "zn" -> 
           RGBColor[0.490196, 0.501961, 0.690196], "ga" -> 
           RGBColor[0.800757, 0.542666, 0.533513], "ge" -> 
           RGBColor[0.60508, 0.632465, 0.576489], "as" -> 
           RGBColor[0.741176, 0.501961, 0.890196], "se" -> 
           RGBColor[0.917248, 0.657833, 0.0706628], "br" -> 
           RGBColor[0.58847, 0.22163, 0.16064], "kr" -> 
           RGBColor[0.426019, 0.747462, 0.810413], "rb" -> 
           RGBColor[0.425391, 0.329242, 0.585895], "sr" -> 
           RGBColor[0.325959, 0.646423, 0.095983], "y" -> 
           RGBColor[0.531014, 1., 1.], "zr" -> 
           RGBColor[0.458599, 0.917466, 0.918573], "nb" -> 
           RGBColor[0.385036, 0.834854, 0.841681], "mo" -> 
           RGBColor[0.310325, 0.752163, 0.769323], "tc" -> 
           RGBColor[0.234466, 0.669394, 0.701499], "ru" -> 
           RGBColor[0.157459, 0.586546, 0.638209], "rh" -> 
           RGBColor[0.0793033, 0.50362, 0.579453], "pd" -> 
           RGBColor[0., 0.420615, 0.525231], "ag" -> 
           RGBColor[0.752941, 0.752941, 0.752941], "cd" -> 
           RGBColor[1., 0.85098, 0.560784], "in" -> 
           RGBColor[0.728371, 0.440594, 0.422196], "sn" -> 
           RGBColor[0.39799, 0.491477, 0.495586], "sb" -> 
           RGBColor[0.619608, 0.388235, 0.709804], "te" -> 
           RGBColor[0.816706, 0.451332, 0.0100947], "i" -> 
           RGBColor[0.580392, 0, 0.580392], "xe" -> 
           RGBColor[0.316906, 0.638078, 0.710252], "cs" -> 
           RGBColor[0.332803, 0.217712, 0.483666], "ba" -> 
           RGBColor[0.165935, 0.55605, 0.0796556], "la" -> 
           RGBColor[0.928084, 0.716075, 0.329427], "ce" -> 
           RGBColor[0.894824, 0.731424, 0.325131], "pr" -> 
           RGBColor[0.86523, 0.707999, 0.315261], "nd" -> 
           RGBColor[0.837836, 0.662974, 0.301635], "pm" -> 
           RGBColor[0.811992, 0.607859, 0.285626], "sm" -> 
           RGBColor[0.787563, 0.549894, 0.268279], "eu" -> 
           RGBColor[0.764628, 0.493261, 0.250405], "gd" -> 
           RGBColor[0.743177, 0.440115, 0.23269], "tb" -> 
           RGBColor[0.72281, 0.39143, 0.215783], "dy" -> 
           RGBColor[0.702434, 0.347663, 0.200392], "ho" -> 
           RGBColor[0.679962, 0.309234, 0.187368], "er" -> 
           RGBColor[0.652012, 0.276823, 0.17779], "tm" -> 
           RGBColor[0.613603, 0.251489, 0.173042], "yb" -> 
           RGBColor[0.557855, 0.234598, 0.17489], "lu" -> 
           RGBColor[0.475685, 0.227573, 0.18555], "hf" -> 
           RGBColor[0.781537, 0.717388, 0.716579], "ta" -> 
           RGBColor[0.734443, 0.544489, 0.683471], "w" -> 
           RGBColor[0.681179, 0.360409, 0.63675], "re" -> 
           RGBColor[0.605181, 0.367584, 0.556343], "os" -> 
           RGBColor[0.521806, 0.382125, 0.469204], "ir" -> 
           RGBColor[0.445624, 0.373159, 0.399069], "pt" -> 
           RGBColor[0.815686, 0.815686, 0.878431], "au" -> 
           RGBColor[1., 0.819608, 0.137255], "hg" -> 
           RGBColor[0.721569, 0.721569, 0.815686], "tl" -> 
           RGBColor[0.65098, 0.329412, 0.301961], "pb" -> 
           RGBColor[0.341176, 0.34902, 0.380392], "bi" -> 
           RGBColor[0.619608, 0.309804, 0.709804], "po" -> 
           RGBColor[0.670588, 0.360784, 0], "at" -> 
           RGBColor[0.458824, 0.309804, 0.270588], "rn" -> 
           RGBColor[0.218799, 0.516091, 0.591608], "fr" -> 
           RGBColor[0.25626, 0.0861372, 0.398932], "ra" -> 
           RGBColor[0., 0.473472, 0.04654], "ac" -> 
           RGBColor[0.322042, 0.71693, 0.988479], "th" -> 
           RGBColor[0.3608, 0.67166, 0.943003], "pa" -> 
           RGBColor[0.397469, 0.628, 0.898853], "u" -> 
           RGBColor[0.43205, 0.58595, 0.856029], "np" -> 
           RGBColor[0.464542, 0.54551, 0.814532], "pu" -> 
           RGBColor[0.494945, 0.506679, 0.774361], "am" -> 
           RGBColor[0.52326, 0.469458, 0.735517], "cm" -> 
           RGBColor[0.549486, 0.433847, 0.697999], "bk" -> 
           RGBColor[0.573624, 0.399845, 0.661808], "cf" -> 
           RGBColor[0.595673, 0.367454, 0.626942], "es" -> 
           RGBColor[0.615633, 0.336672, 0.593404], "fm" -> 
           RGBColor[0.633505, 0.307499, 0.561191], "md" -> 
           RGBColor[0.649288, 0.279937, 0.530305], "no" -> 
           RGBColor[0.662982, 0.253984, 0.500746], "lr" -> 
           RGBColor[0.674588, 0.22964, 0.472513], "rf" -> 
           RGBColor[0.684106, 0.206907, 0.445606], "db" -> 
           RGBColor[0.691534, 0.185783, 0.420025], "sg" -> 
           RGBColor[0.696874, 0.166269, 0.395772], "bh" -> 
           RGBColor[0.700126, 0.148365, 0.372844], "hs" -> 
           RGBColor[0.701289, 0.13207, 0.351243], "mt" -> 
           RGBColor[0.700363, 0.117385, 0.330968], "ds" -> 
           RGBColor[0.697348, 0.10431, 0.31202], "rg" -> 
           RGBColor[0.692245, 0.0928444, 0.294398], "cn" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "nh" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "fl" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "mc" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "lv" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "ts" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "og" -> 
           RGBColor[0.635401, 0.0528, 0.226184], "uub" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "uut" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "uuq" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "uup" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "uuh" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "uus" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "uuo" -> 
           RGBColor[0.635401, 0.0528, 0.226184]}]]& ][0.85], 
       ColorDataFunction[
       "Atoms", 
        "Named", {{
         "H", "He", "Li", "Be", "B", "C", "N", "O", "F", "Ne", "Na", "Mg", 
          "Al", "Si", "P", "S", "Cl", "Ar", "K", "Ca", "Sc", "Ti", "V", "Cr", 
          "Mn", "Fe", "Co", "Ni", "Cu", "Zn", "Ga", "Ge", "As", "Se", "Br", 
          "Kr", "Rb", "Sr", "Y", "Zr", "Nb", "Mo", "Tc", "Ru", "Rh", "Pd", 
          "Ag", "Cd", "In", "Sn", "Sb", "Te", "I", "Xe", "Cs", "Ba", "La", 
          "Ce", "Pr", "Nd", "Pm", "Sm", "Eu", "Gd", "Tb", "Dy", "Ho", "Er", 
          "Tm", "Yb", "Lu", "Hf", "Ta", "W", "Re", "Os", "Ir", "Pt", "Au", 
          "Hg", "Tl", "Pb", "Bi", "Po", "At", "Rn", "Fr", "Ra", "Ac", "Th", 
          "Pa", "U", "Np", "Pu", "Am", "Cm", "Bk", "Cf", "Es", "Fm", "Md", 
          "No", "Lr", "Rf", "Db", "Sg", "Bh", "Hs", "Mt", "Ds", "Rg", "Cn", 
          "Nh", "Fl", "Mc", "Lv", "Ts", "Og", "Uub", "Uut", "Uuq", "Uup", 
          "Uuh", "Uus", "Uuo"}, {
         "h", "he", "li", "be", "b", "c", "n", "o", "f", "ne", "na", "mg", 
          "al", "si", "p", "s", "cl", "ar", "k", "ca", "sc", "ti", "v", "cr", 
          "mn", "fe", "co", "ni", "cu", "zn", "ga", "ge", "as", "se", "br", 
          "kr", "rb", "sr", "y", "zr", "nb", "mo", "tc", "ru", "rh", "pd", 
          "ag", "cd", "in", "sn", "sb", "te", "i", "xe", "cs", "ba", "la", 
          "ce", "pr", "nd", "pm", "sm", "eu", "gd", "tb", "dy", "ho", "er", 
          "tm", "yb", "lu", "hf", "ta", "w", "re", "os", "ir", "pt", "au", 
          "hg", "tl", "pb", "bi", "po", "at", "rn", "fr", "ra", "ac", "th", 
          "pa", "u", "np", "pu", "am", "cm", "bk", "cf", "es", "fm", "md", 
          "no", "lr", "rf", "db", "sg", "bh", "hs", "mt", "ds", "rg", "cn", 
          "nh", "fl", "mc", "lv", "ts", "og", "uub", "uut", "uuq", "uup", 
          "uuh", "uus", "uuo"}}, Replace[#, 
         Dispatch[{
          "h" -> RGBColor[0.65, 0.7, 0.7], "he" -> RGBColor[0.836713, 1., 1.],
            "li" -> RGBColor[0.799435, 0.543572, 0.997559], "be" -> 
           RGBColor[0.770565, 0.964309, 0.0442359], "b" -> 
           RGBColor[1., 0.709804, 0.709804], "c" -> RGBColor[0.4, 0.4, 0.4], 
           "n" -> RGBColor[0.291989, 0.437977, 0.888609], "o" -> 
           RGBColor[0.800498, 0.201504, 0.192061], "f" -> 
           RGBColor[0.578462, 0.85539, 0.408855], "ne" -> 
           RGBColor[0.677263, 0.928423, 0.955287], "na" -> 
           RGBColor[0.658708, 0.492173, 0.842842], "mg" -> 
           RGBColor[0.628274, 0.850553, 0.0782731], "al" -> 
           RGBColor[0.8913, 0.631904, 0.627399], "si" -> 
           RGBColor[0.941176, 0.784314, 0.627451], "p" -> 
           RGBColor[1., 0.501961, 0], "s" -> 
           RGBColor[0.90443, 0.97015, 0.13504], "cl" -> 
           RGBColor[0.412698, 0.932689, 0.166398], "ar" -> 
           RGBColor[0.546138, 0.844244, 0.892092], "k" -> 
           RGBColor[0.534026, 0.420729, 0.705621], "ca" -> 
           RGBColor[0.480072, 0.744591, 0.0955222], "sc" -> 
           RGBColor[0.901961, 0.901961, 0.901961], "ti" -> 
           RGBColor[0.74902, 0.760784, 0.780392], "v" -> 
           RGBColor[0.65098, 0.65098, 0.670588], "cr" -> 
           RGBColor[0.541176, 0.6, 0.780392], "mn" -> 
           RGBColor[0.611765, 0.478431, 0.780392], "fe" -> 
           RGBColor[0.878431, 0.4, 0.2], "co" -> 
           RGBColor[0.941176, 0.564706, 0.627451], "ni" -> 
           RGBColor[0.313725, 0.815686, 0.313725], "cu" -> 
           RGBColor[0.784314, 0.501961, 0.2], "zn" -> 
           RGBColor[0.490196, 0.501961, 0.690196], "ga" -> 
           RGBColor[0.800757, 0.542666, 0.533513], "ge" -> 
           RGBColor[0.60508, 0.632465, 0.576489], "as" -> 
           RGBColor[0.741176, 0.501961, 0.890196], "se" -> 
           RGBColor[0.917248, 0.657833, 0.0706628], "br" -> 
           RGBColor[0.58847, 0.22163, 0.16064], "kr" -> 
           RGBColor[0.426019, 0.747462, 0.810413], "rb" -> 
           RGBColor[0.425391, 0.329242, 0.585895], "sr" -> 
           RGBColor[0.325959, 0.646423, 0.095983], "y" -> 
           RGBColor[0.531014, 1., 1.], "zr" -> 
           RGBColor[0.458599, 0.917466, 0.918573], "nb" -> 
           RGBColor[0.385036, 0.834854, 0.841681], "mo" -> 
           RGBColor[0.310325, 0.752163, 0.769323], "tc" -> 
           RGBColor[0.234466, 0.669394, 0.701499], "ru" -> 
           RGBColor[0.157459, 0.586546, 0.638209], "rh" -> 
           RGBColor[0.0793033, 0.50362, 0.579453], "pd" -> 
           RGBColor[0., 0.420615, 0.525231], "ag" -> 
           RGBColor[0.752941, 0.752941, 0.752941], "cd" -> 
           RGBColor[1., 0.85098, 0.560784], "in" -> 
           RGBColor[0.728371, 0.440594, 0.422196], "sn" -> 
           RGBColor[0.39799, 0.491477, 0.495586], "sb" -> 
           RGBColor[0.619608, 0.388235, 0.709804], "te" -> 
           RGBColor[0.816706, 0.451332, 0.0100947], "i" -> 
           RGBColor[0.580392, 0, 0.580392], "xe" -> 
           RGBColor[0.316906, 0.638078, 0.710252], "cs" -> 
           RGBColor[0.332803, 0.217712, 0.483666], "ba" -> 
           RGBColor[0.165935, 0.55605, 0.0796556], "la" -> 
           RGBColor[0.928084, 0.716075, 0.329427], "ce" -> 
           RGBColor[0.894824, 0.731424, 0.325131], "pr" -> 
           RGBColor[0.86523, 0.707999, 0.315261], "nd" -> 
           RGBColor[0.837836, 0.662974, 0.301635], "pm" -> 
           RGBColor[0.811992, 0.607859, 0.285626], "sm" -> 
           RGBColor[0.787563, 0.549894, 0.268279], "eu" -> 
           RGBColor[0.764628, 0.493261, 0.250405], "gd" -> 
           RGBColor[0.743177, 0.440115, 0.23269], "tb" -> 
           RGBColor[0.72281, 0.39143, 0.215783], "dy" -> 
           RGBColor[0.702434, 0.347663, 0.200392], "ho" -> 
           RGBColor[0.679962, 0.309234, 0.187368], "er" -> 
           RGBColor[0.652012, 0.276823, 0.17779], "tm" -> 
           RGBColor[0.613603, 0.251489, 0.173042], "yb" -> 
           RGBColor[0.557855, 0.234598, 0.17489], "lu" -> 
           RGBColor[0.475685, 0.227573, 0.18555], "hf" -> 
           RGBColor[0.781537, 0.717388, 0.716579], "ta" -> 
           RGBColor[0.734443, 0.544489, 0.683471], "w" -> 
           RGBColor[0.681179, 0.360409, 0.63675], "re" -> 
           RGBColor[0.605181, 0.367584, 0.556343], "os" -> 
           RGBColor[0.521806, 0.382125, 0.469204], "ir" -> 
           RGBColor[0.445624, 0.373159, 0.399069], "pt" -> 
           RGBColor[0.815686, 0.815686, 0.878431], "au" -> 
           RGBColor[1., 0.819608, 0.137255], "hg" -> 
           RGBColor[0.721569, 0.721569, 0.815686], "tl" -> 
           RGBColor[0.65098, 0.329412, 0.301961], "pb" -> 
           RGBColor[0.341176, 0.34902, 0.380392], "bi" -> 
           RGBColor[0.619608, 0.309804, 0.709804], "po" -> 
           RGBColor[0.670588, 0.360784, 0], "at" -> 
           RGBColor[0.458824, 0.309804, 0.270588], "rn" -> 
           RGBColor[0.218799, 0.516091, 0.591608], "fr" -> 
           RGBColor[0.25626, 0.0861372, 0.398932], "ra" -> 
           RGBColor[0., 0.473472, 0.04654], "ac" -> 
           RGBColor[0.322042, 0.71693, 0.988479], "th" -> 
           RGBColor[0.3608, 0.67166, 0.943003], "pa" -> 
           RGBColor[0.397469, 0.628, 0.898853], "u" -> 
           RGBColor[0.43205, 0.58595, 0.856029], "np" -> 
           RGBColor[0.464542, 0.54551, 0.814532], "pu" -> 
           RGBColor[0.494945, 0.506679, 0.774361], "am" -> 
           RGBColor[0.52326, 0.469458, 0.735517], "cm" -> 
           RGBColor[0.549486, 0.433847, 0.697999], "bk" -> 
           RGBColor[0.573624, 0.399845, 0.661808], "cf" -> 
           RGBColor[0.595673, 0.367454, 0.626942], "es" -> 
           RGBColor[0.615633, 0.336672, 0.593404], "fm" -> 
           RGBColor[0.633505, 0.307499, 0.561191], "md" -> 
           RGBColor[0.649288, 0.279937, 0.530305], "no" -> 
           RGBColor[0.662982, 0.253984, 0.500746], "lr" -> 
           RGBColor[0.674588, 0.22964, 0.472513], "rf" -> 
           RGBColor[0.684106, 0.206907, 0.445606], "db" -> 
           RGBColor[0.691534, 0.185783, 0.420025], "sg" -> 
           RGBColor[0.696874, 0.166269, 0.395772], "bh" -> 
           RGBColor[0.700126, 0.148365, 0.372844], "hs" -> 
           RGBColor[0.701289, 0.13207, 0.351243], "mt" -> 
           RGBColor[0.700363, 0.117385, 0.330968], "ds" -> 
           RGBColor[0.697348, 0.10431, 0.31202], "rg" -> 
           RGBColor[0.692245, 0.0928444, 0.294398], "cn" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "nh" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "fl" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "mc" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "lv" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "ts" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "og" -> 
           RGBColor[0.635401, 0.0528, 0.226184], "uub" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "uut" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "uuq" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "uup" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "uuh" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "uus" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "uuo" -> 
           RGBColor[0.635401, 0.0528, 0.226184]}]]& ][0.85], 
       ColorDataFunction[
       "Atoms", 
        "Named", {{
         "H", "He", "Li", "Be", "B", "C", "N", "O", "F", "Ne", "Na", "Mg", 
          "Al", "Si", "P", "S", "Cl", "Ar", "K", "Ca", "Sc", "Ti", "V", "Cr", 
          "Mn", "Fe", "Co", "Ni", "Cu", "Zn", "Ga", "Ge", "As", "Se", "Br", 
          "Kr", "Rb", "Sr", "Y", "Zr", "Nb", "Mo", "Tc", "Ru", "Rh", "Pd", 
          "Ag", "Cd", "In", "Sn", "Sb", "Te", "I", "Xe", "Cs", "Ba", "La", 
          "Ce", "Pr", "Nd", "Pm", "Sm", "Eu", "Gd", "Tb", "Dy", "Ho", "Er", 
          "Tm", "Yb", "Lu", "Hf", "Ta", "W", "Re", "Os", "Ir", "Pt", "Au", 
          "Hg", "Tl", "Pb", "Bi", "Po", "At", "Rn", "Fr", "Ra", "Ac", "Th", 
          "Pa", "U", "Np", "Pu", "Am", "Cm", "Bk", "Cf", "Es", "Fm", "Md", 
          "No", "Lr", "Rf", "Db", "Sg", "Bh", "Hs", "Mt", "Ds", "Rg", "Cn", 
          "Nh", "Fl", "Mc", "Lv", "Ts", "Og", "Uub", "Uut", "Uuq", "Uup", 
          "Uuh", "Uus", "Uuo"}, {
         "h", "he", "li", "be", "b", "c", "n", "o", "f", "ne", "na", "mg", 
          "al", "si", "p", "s", "cl", "ar", "k", "ca", "sc", "ti", "v", "cr", 
          "mn", "fe", "co", "ni", "cu", "zn", "ga", "ge", "as", "se", "br", 
          "kr", "rb", "sr", "y", "zr", "nb", "mo", "tc", "ru", "rh", "pd", 
          "ag", "cd", "in", "sn", "sb", "te", "i", "xe", "cs", "ba", "la", 
          "ce", "pr", "nd", "pm", "sm", "eu", "gd", "tb", "dy", "ho", "er", 
          "tm", "yb", "lu", "hf", "ta", "w", "re", "os", "ir", "pt", "au", 
          "hg", "tl", "pb", "bi", "po", "at", "rn", "fr", "ra", "ac", "th", 
          "pa", "u", "np", "pu", "am", "cm", "bk", "cf", "es", "fm", "md", 
          "no", "lr", "rf", "db", "sg", "bh", "hs", "mt", "ds", "rg", "cn", 
          "nh", "fl", "mc", "lv", "ts", "og", "uub", "uut", "uuq", "uup", 
          "uuh", "uus", "uuo"}}, Replace[#, 
         Dispatch[{
          "h" -> RGBColor[0.65, 0.7, 0.7], "he" -> RGBColor[0.836713, 1., 1.],
            "li" -> RGBColor[0.799435, 0.543572, 0.997559], "be" -> 
           RGBColor[0.770565, 0.964309, 0.0442359], "b" -> 
           RGBColor[1., 0.709804, 0.709804], "c" -> RGBColor[0.4, 0.4, 0.4], 
           "n" -> RGBColor[0.291989, 0.437977, 0.888609], "o" -> 
           RGBColor[0.800498, 0.201504, 0.192061], "f" -> 
           RGBColor[0.578462, 0.85539, 0.408855], "ne" -> 
           RGBColor[0.677263, 0.928423, 0.955287], "na" -> 
           RGBColor[0.658708, 0.492173, 0.842842], "mg" -> 
           RGBColor[0.628274, 0.850553, 0.0782731], "al" -> 
           RGBColor[0.8913, 0.631904, 0.627399], "si" -> 
           RGBColor[0.941176, 0.784314, 0.627451], "p" -> 
           RGBColor[1., 0.501961, 0], "s" -> 
           RGBColor[0.90443, 0.97015, 0.13504], "cl" -> 
           RGBColor[0.412698, 0.932689, 0.166398], "ar" -> 
           RGBColor[0.546138, 0.844244, 0.892092], "k" -> 
           RGBColor[0.534026, 0.420729, 0.705621], "ca" -> 
           RGBColor[0.480072, 0.744591, 0.0955222], "sc" -> 
           RGBColor[0.901961, 0.901961, 0.901961], "ti" -> 
           RGBColor[0.74902, 0.760784, 0.780392], "v" -> 
           RGBColor[0.65098, 0.65098, 0.670588], "cr" -> 
           RGBColor[0.541176, 0.6, 0.780392], "mn" -> 
           RGBColor[0.611765, 0.478431, 0.780392], "fe" -> 
           RGBColor[0.878431, 0.4, 0.2], "co" -> 
           RGBColor[0.941176, 0.564706, 0.627451], "ni" -> 
           RGBColor[0.313725, 0.815686, 0.313725], "cu" -> 
           RGBColor[0.784314, 0.501961, 0.2], "zn" -> 
           RGBColor[0.490196, 0.501961, 0.690196], "ga" -> 
           RGBColor[0.800757, 0.542666, 0.533513], "ge" -> 
           RGBColor[0.60508, 0.632465, 0.576489], "as" -> 
           RGBColor[0.741176, 0.501961, 0.890196], "se" -> 
           RGBColor[0.917248, 0.657833, 0.0706628], "br" -> 
           RGBColor[0.58847, 0.22163, 0.16064], "kr" -> 
           RGBColor[0.426019, 0.747462, 0.810413], "rb" -> 
           RGBColor[0.425391, 0.329242, 0.585895], "sr" -> 
           RGBColor[0.325959, 0.646423, 0.095983], "y" -> 
           RGBColor[0.531014, 1., 1.], "zr" -> 
           RGBColor[0.458599, 0.917466, 0.918573], "nb" -> 
           RGBColor[0.385036, 0.834854, 0.841681], "mo" -> 
           RGBColor[0.310325, 0.752163, 0.769323], "tc" -> 
           RGBColor[0.234466, 0.669394, 0.701499], "ru" -> 
           RGBColor[0.157459, 0.586546, 0.638209], "rh" -> 
           RGBColor[0.0793033, 0.50362, 0.579453], "pd" -> 
           RGBColor[0., 0.420615, 0.525231], "ag" -> 
           RGBColor[0.752941, 0.752941, 0.752941], "cd" -> 
           RGBColor[1., 0.85098, 0.560784], "in" -> 
           RGBColor[0.728371, 0.440594, 0.422196], "sn" -> 
           RGBColor[0.39799, 0.491477, 0.495586], "sb" -> 
           RGBColor[0.619608, 0.388235, 0.709804], "te" -> 
           RGBColor[0.816706, 0.451332, 0.0100947], "i" -> 
           RGBColor[0.580392, 0, 0.580392], "xe" -> 
           RGBColor[0.316906, 0.638078, 0.710252], "cs" -> 
           RGBColor[0.332803, 0.217712, 0.483666], "ba" -> 
           RGBColor[0.165935, 0.55605, 0.0796556], "la" -> 
           RGBColor[0.928084, 0.716075, 0.329427], "ce" -> 
           RGBColor[0.894824, 0.731424, 0.325131], "pr" -> 
           RGBColor[0.86523, 0.707999, 0.315261], "nd" -> 
           RGBColor[0.837836, 0.662974, 0.301635], "pm" -> 
           RGBColor[0.811992, 0.607859, 0.285626], "sm" -> 
           RGBColor[0.787563, 0.549894, 0.268279], "eu" -> 
           RGBColor[0.764628, 0.493261, 0.250405], "gd" -> 
           RGBColor[0.743177, 0.440115, 0.23269], "tb" -> 
           RGBColor[0.72281, 0.39143, 0.215783], "dy" -> 
           RGBColor[0.702434, 0.347663, 0.200392], "ho" -> 
           RGBColor[0.679962, 0.309234, 0.187368], "er" -> 
           RGBColor[0.652012, 0.276823, 0.17779], "tm" -> 
           RGBColor[0.613603, 0.251489, 0.173042], "yb" -> 
           RGBColor[0.557855, 0.234598, 0.17489], "lu" -> 
           RGBColor[0.475685, 0.227573, 0.18555], "hf" -> 
           RGBColor[0.781537, 0.717388, 0.716579], "ta" -> 
           RGBColor[0.734443, 0.544489, 0.683471], "w" -> 
           RGBColor[0.681179, 0.360409, 0.63675], "re" -> 
           RGBColor[0.605181, 0.367584, 0.556343], "os" -> 
           RGBColor[0.521806, 0.382125, 0.469204], "ir" -> 
           RGBColor[0.445624, 0.373159, 0.399069], "pt" -> 
           RGBColor[0.815686, 0.815686, 0.878431], "au" -> 
           RGBColor[1., 0.819608, 0.137255], "hg" -> 
           RGBColor[0.721569, 0.721569, 0.815686], "tl" -> 
           RGBColor[0.65098, 0.329412, 0.301961], "pb" -> 
           RGBColor[0.341176, 0.34902, 0.380392], "bi" -> 
           RGBColor[0.619608, 0.309804, 0.709804], "po" -> 
           RGBColor[0.670588, 0.360784, 0], "at" -> 
           RGBColor[0.458824, 0.309804, 0.270588], "rn" -> 
           RGBColor[0.218799, 0.516091, 0.591608], "fr" -> 
           RGBColor[0.25626, 0.0861372, 0.398932], "ra" -> 
           RGBColor[0., 0.473472, 0.04654], "ac" -> 
           RGBColor[0.322042, 0.71693, 0.988479], "th" -> 
           RGBColor[0.3608, 0.67166, 0.943003], "pa" -> 
           RGBColor[0.397469, 0.628, 0.898853], "u" -> 
           RGBColor[0.43205, 0.58595, 0.856029], "np" -> 
           RGBColor[0.464542, 0.54551, 0.814532], "pu" -> 
           RGBColor[0.494945, 0.506679, 0.774361], "am" -> 
           RGBColor[0.52326, 0.469458, 0.735517], "cm" -> 
           RGBColor[0.549486, 0.433847, 0.697999], "bk" -> 
           RGBColor[0.573624, 0.399845, 0.661808], "cf" -> 
           RGBColor[0.595673, 0.367454, 0.626942], "es" -> 
           RGBColor[0.615633, 0.336672, 0.593404], "fm" -> 
           RGBColor[0.633505, 0.307499, 0.561191], "md" -> 
           RGBColor[0.649288, 0.279937, 0.530305], "no" -> 
           RGBColor[0.662982, 0.253984, 0.500746], "lr" -> 
           RGBColor[0.674588, 0.22964, 0.472513], "rf" -> 
           RGBColor[0.684106, 0.206907, 0.445606], "db" -> 
           RGBColor[0.691534, 0.185783, 0.420025], "sg" -> 
           RGBColor[0.696874, 0.166269, 0.395772], "bh" -> 
           RGBColor[0.700126, 0.148365, 0.372844], "hs" -> 
           RGBColor[0.701289, 0.13207, 0.351243], "mt" -> 
           RGBColor[0.700363, 0.117385, 0.330968], "ds" -> 
           RGBColor[0.697348, 0.10431, 0.31202], "rg" -> 
           RGBColor[0.692245, 0.0928444, 0.294398], "cn" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "nh" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "fl" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "mc" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "lv" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "ts" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "og" -> 
           RGBColor[0.635401, 0.0528, 0.226184], "uub" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "uut" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "uuq" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "uup" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "uuh" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "uus" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "uuo" -> 
           RGBColor[0.635401, 0.0528, 0.226184]}]]& ][0.85], 
       ColorDataFunction[
       "Atoms", 
        "Named", {{
         "H", "He", "Li", "Be", "B", "C", "N", "O", "F", "Ne", "Na", "Mg", 
          "Al", "Si", "P", "S", "Cl", "Ar", "K", "Ca", "Sc", "Ti", "V", "Cr", 
          "Mn", "Fe", "Co", "Ni", "Cu", "Zn", "Ga", "Ge", "As", "Se", "Br", 
          "Kr", "Rb", "Sr", "Y", "Zr", "Nb", "Mo", "Tc", "Ru", "Rh", "Pd", 
          "Ag", "Cd", "In", "Sn", "Sb", "Te", "I", "Xe", "Cs", "Ba", "La", 
          "Ce", "Pr", "Nd", "Pm", "Sm", "Eu", "Gd", "Tb", "Dy", "Ho", "Er", 
          "Tm", "Yb", "Lu", "Hf", "Ta", "W", "Re", "Os", "Ir", "Pt", "Au", 
          "Hg", "Tl", "Pb", "Bi", "Po", "At", "Rn", "Fr", "Ra", "Ac", "Th", 
          "Pa", "U", "Np", "Pu", "Am", "Cm", "Bk", "Cf", "Es", "Fm", "Md", 
          "No", "Lr", "Rf", "Db", "Sg", "Bh", "Hs", "Mt", "Ds", "Rg", "Cn", 
          "Nh", "Fl", "Mc", "Lv", "Ts", "Og", "Uub", "Uut", "Uuq", "Uup", 
          "Uuh", "Uus", "Uuo"}, {
         "h", "he", "li", "be", "b", "c", "n", "o", "f", "ne", "na", "mg", 
          "al", "si", "p", "s", "cl", "ar", "k", "ca", "sc", "ti", "v", "cr", 
          "mn", "fe", "co", "ni", "cu", "zn", "ga", "ge", "as", "se", "br", 
          "kr", "rb", "sr", "y", "zr", "nb", "mo", "tc", "ru", "rh", "pd", 
          "ag", "cd", "in", "sn", "sb", "te", "i", "xe", "cs", "ba", "la", 
          "ce", "pr", "nd", "pm", "sm", "eu", "gd", "tb", "dy", "ho", "er", 
          "tm", "yb", "lu", "hf", "ta", "w", "re", "os", "ir", "pt", "au", 
          "hg", "tl", "pb", "bi", "po", "at", "rn", "fr", "ra", "ac", "th", 
          "pa", "u", "np", "pu", "am", "cm", "bk", "cf", "es", "fm", "md", 
          "no", "lr", "rf", "db", "sg", "bh", "hs", "mt", "ds", "rg", "cn", 
          "nh", "fl", "mc", "lv", "ts", "og", "uub", "uut", "uuq", "uup", 
          "uuh", "uus", "uuo"}}, Replace[#, 
         Dispatch[{
          "h" -> RGBColor[0.65, 0.7, 0.7], "he" -> RGBColor[0.836713, 1., 1.],
            "li" -> RGBColor[0.799435, 0.543572, 0.997559], "be" -> 
           RGBColor[0.770565, 0.964309, 0.0442359], "b" -> 
           RGBColor[1., 0.709804, 0.709804], "c" -> RGBColor[0.4, 0.4, 0.4], 
           "n" -> RGBColor[0.291989, 0.437977, 0.888609], "o" -> 
           RGBColor[0.800498, 0.201504, 0.192061], "f" -> 
           RGBColor[0.578462, 0.85539, 0.408855], "ne" -> 
           RGBColor[0.677263, 0.928423, 0.955287], "na" -> 
           RGBColor[0.658708, 0.492173, 0.842842], "mg" -> 
           RGBColor[0.628274, 0.850553, 0.0782731], "al" -> 
           RGBColor[0.8913, 0.631904, 0.627399], "si" -> 
           RGBColor[0.941176, 0.784314, 0.627451], "p" -> 
           RGBColor[1., 0.501961, 0], "s" -> 
           RGBColor[0.90443, 0.97015, 0.13504], "cl" -> 
           RGBColor[0.412698, 0.932689, 0.166398], "ar" -> 
           RGBColor[0.546138, 0.844244, 0.892092], "k" -> 
           RGBColor[0.534026, 0.420729, 0.705621], "ca" -> 
           RGBColor[0.480072, 0.744591, 0.0955222], "sc" -> 
           RGBColor[0.901961, 0.901961, 0.901961], "ti" -> 
           RGBColor[0.74902, 0.760784, 0.780392], "v" -> 
           RGBColor[0.65098, 0.65098, 0.670588], "cr" -> 
           RGBColor[0.541176, 0.6, 0.780392], "mn" -> 
           RGBColor[0.611765, 0.478431, 0.780392], "fe" -> 
           RGBColor[0.878431, 0.4, 0.2], "co" -> 
           RGBColor[0.941176, 0.564706, 0.627451], "ni" -> 
           RGBColor[0.313725, 0.815686, 0.313725], "cu" -> 
           RGBColor[0.784314, 0.501961, 0.2], "zn" -> 
           RGBColor[0.490196, 0.501961, 0.690196], "ga" -> 
           RGBColor[0.800757, 0.542666, 0.533513], "ge" -> 
           RGBColor[0.60508, 0.632465, 0.576489], "as" -> 
           RGBColor[0.741176, 0.501961, 0.890196], "se" -> 
           RGBColor[0.917248, 0.657833, 0.0706628], "br" -> 
           RGBColor[0.58847, 0.22163, 0.16064], "kr" -> 
           RGBColor[0.426019, 0.747462, 0.810413], "rb" -> 
           RGBColor[0.425391, 0.329242, 0.585895], "sr" -> 
           RGBColor[0.325959, 0.646423, 0.095983], "y" -> 
           RGBColor[0.531014, 1., 1.], "zr" -> 
           RGBColor[0.458599, 0.917466, 0.918573], "nb" -> 
           RGBColor[0.385036, 0.834854, 0.841681], "mo" -> 
           RGBColor[0.310325, 0.752163, 0.769323], "tc" -> 
           RGBColor[0.234466, 0.669394, 0.701499], "ru" -> 
           RGBColor[0.157459, 0.586546, 0.638209], "rh" -> 
           RGBColor[0.0793033, 0.50362, 0.579453], "pd" -> 
           RGBColor[0., 0.420615, 0.525231], "ag" -> 
           RGBColor[0.752941, 0.752941, 0.752941], "cd" -> 
           RGBColor[1., 0.85098, 0.560784], "in" -> 
           RGBColor[0.728371, 0.440594, 0.422196], "sn" -> 
           RGBColor[0.39799, 0.491477, 0.495586], "sb" -> 
           RGBColor[0.619608, 0.388235, 0.709804], "te" -> 
           RGBColor[0.816706, 0.451332, 0.0100947], "i" -> 
           RGBColor[0.580392, 0, 0.580392], "xe" -> 
           RGBColor[0.316906, 0.638078, 0.710252], "cs" -> 
           RGBColor[0.332803, 0.217712, 0.483666], "ba" -> 
           RGBColor[0.165935, 0.55605, 0.0796556], "la" -> 
           RGBColor[0.928084, 0.716075, 0.329427], "ce" -> 
           RGBColor[0.894824, 0.731424, 0.325131], "pr" -> 
           RGBColor[0.86523, 0.707999, 0.315261], "nd" -> 
           RGBColor[0.837836, 0.662974, 0.301635], "pm" -> 
           RGBColor[0.811992, 0.607859, 0.285626], "sm" -> 
           RGBColor[0.787563, 0.549894, 0.268279], "eu" -> 
           RGBColor[0.764628, 0.493261, 0.250405], "gd" -> 
           RGBColor[0.743177, 0.440115, 0.23269], "tb" -> 
           RGBColor[0.72281, 0.39143, 0.215783], "dy" -> 
           RGBColor[0.702434, 0.347663, 0.200392], "ho" -> 
           RGBColor[0.679962, 0.309234, 0.187368], "er" -> 
           RGBColor[0.652012, 0.276823, 0.17779], "tm" -> 
           RGBColor[0.613603, 0.251489, 0.173042], "yb" -> 
           RGBColor[0.557855, 0.234598, 0.17489], "lu" -> 
           RGBColor[0.475685, 0.227573, 0.18555], "hf" -> 
           RGBColor[0.781537, 0.717388, 0.716579], "ta" -> 
           RGBColor[0.734443, 0.544489, 0.683471], "w" -> 
           RGBColor[0.681179, 0.360409, 0.63675], "re" -> 
           RGBColor[0.605181, 0.367584, 0.556343], "os" -> 
           RGBColor[0.521806, 0.382125, 0.469204], "ir" -> 
           RGBColor[0.445624, 0.373159, 0.399069], "pt" -> 
           RGBColor[0.815686, 0.815686, 0.878431], "au" -> 
           RGBColor[1., 0.819608, 0.137255], "hg" -> 
           RGBColor[0.721569, 0.721569, 0.815686], "tl" -> 
           RGBColor[0.65098, 0.329412, 0.301961], "pb" -> 
           RGBColor[0.341176, 0.34902, 0.380392], "bi" -> 
           RGBColor[0.619608, 0.309804, 0.709804], "po" -> 
           RGBColor[0.670588, 0.360784, 0], "at" -> 
           RGBColor[0.458824, 0.309804, 0.270588], "rn" -> 
           RGBColor[0.218799, 0.516091, 0.591608], "fr" -> 
           RGBColor[0.25626, 0.0861372, 0.398932], "ra" -> 
           RGBColor[0., 0.473472, 0.04654], "ac" -> 
           RGBColor[0.322042, 0.71693, 0.988479], "th" -> 
           RGBColor[0.3608, 0.67166, 0.943003], "pa" -> 
           RGBColor[0.397469, 0.628, 0.898853], "u" -> 
           RGBColor[0.43205, 0.58595, 0.856029], "np" -> 
           RGBColor[0.464542, 0.54551, 0.814532], "pu" -> 
           RGBColor[0.494945, 0.506679, 0.774361], "am" -> 
           RGBColor[0.52326, 0.469458, 0.735517], "cm" -> 
           RGBColor[0.549486, 0.433847, 0.697999], "bk" -> 
           RGBColor[0.573624, 0.399845, 0.661808], "cf" -> 
           RGBColor[0.595673, 0.367454, 0.626942], "es" -> 
           RGBColor[0.615633, 0.336672, 0.593404], "fm" -> 
           RGBColor[0.633505, 0.307499, 0.561191], "md" -> 
           RGBColor[0.649288, 0.279937, 0.530305], "no" -> 
           RGBColor[0.662982, 0.253984, 0.500746], "lr" -> 
           RGBColor[0.674588, 0.22964, 0.472513], "rf" -> 
           RGBColor[0.684106, 0.206907, 0.445606], "db" -> 
           RGBColor[0.691534, 0.185783, 0.420025], "sg" -> 
           RGBColor[0.696874, 0.166269, 0.395772], "bh" -> 
           RGBColor[0.700126, 0.148365, 0.372844], "hs" -> 
           RGBColor[0.701289, 0.13207, 0.351243], "mt" -> 
           RGBColor[0.700363, 0.117385, 0.330968], "ds" -> 
           RGBColor[0.697348, 0.10431, 0.31202], "rg" -> 
           RGBColor[0.692245, 0.0928444, 0.294398], "cn" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "nh" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "fl" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "mc" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "lv" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "ts" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "og" -> 
           RGBColor[0.635401, 0.0528, 0.226184], "uub" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "uut" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "uuq" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "uup" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "uuh" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "uus" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "uuo" -> 
           RGBColor[0.635401, 0.0528, 0.226184]}]]& ][0.85], 
       ColorDataFunction[
       "Atoms", 
        "Named", {{
         "H", "He", "Li", "Be", "B", "C", "N", "O", "F", "Ne", "Na", "Mg", 
          "Al", "Si", "P", "S", "Cl", "Ar", "K", "Ca", "Sc", "Ti", "V", "Cr", 
          "Mn", "Fe", "Co", "Ni", "Cu", "Zn", "Ga", "Ge", "As", "Se", "Br", 
          "Kr", "Rb", "Sr", "Y", "Zr", "Nb", "Mo", "Tc", "Ru", "Rh", "Pd", 
          "Ag", "Cd", "In", "Sn", "Sb", "Te", "I", "Xe", "Cs", "Ba", "La", 
          "Ce", "Pr", "Nd", "Pm", "Sm", "Eu", "Gd", "Tb", "Dy", "Ho", "Er", 
          "Tm", "Yb", "Lu", "Hf", "Ta", "W", "Re", "Os", "Ir", "Pt", "Au", 
          "Hg", "Tl", "Pb", "Bi", "Po", "At", "Rn", "Fr", "Ra", "Ac", "Th", 
          "Pa", "U", "Np", "Pu", "Am", "Cm", "Bk", "Cf", "Es", "Fm", "Md", 
          "No", "Lr", "Rf", "Db", "Sg", "Bh", "Hs", "Mt", "Ds", "Rg", "Cn", 
          "Nh", "Fl", "Mc", "Lv", "Ts", "Og", "Uub", "Uut", "Uuq", "Uup", 
          "Uuh", "Uus", "Uuo"}, {
         "h", "he", "li", "be", "b", "c", "n", "o", "f", "ne", "na", "mg", 
          "al", "si", "p", "s", "cl", "ar", "k", "ca", "sc", "ti", "v", "cr", 
          "mn", "fe", "co", "ni", "cu", "zn", "ga", "ge", "as", "se", "br", 
          "kr", "rb", "sr", "y", "zr", "nb", "mo", "tc", "ru", "rh", "pd", 
          "ag", "cd", "in", "sn", "sb", "te", "i", "xe", "cs", "ba", "la", 
          "ce", "pr", "nd", "pm", "sm", "eu", "gd", "tb", "dy", "ho", "er", 
          "tm", "yb", "lu", "hf", "ta", "w", "re", "os", "ir", "pt", "au", 
          "hg", "tl", "pb", "bi", "po", "at", "rn", "fr", "ra", "ac", "th", 
          "pa", "u", "np", "pu", "am", "cm", "bk", "cf", "es", "fm", "md", 
          "no", "lr", "rf", "db", "sg", "bh", "hs", "mt", "ds", "rg", "cn", 
          "nh", "fl", "mc", "lv", "ts", "og", "uub", "uut", "uuq", "uup", 
          "uuh", "uus", "uuo"}}, Replace[#, 
         Dispatch[{
          "h" -> RGBColor[0.65, 0.7, 0.7], "he" -> RGBColor[0.836713, 1., 1.],
            "li" -> RGBColor[0.799435, 0.543572, 0.997559], "be" -> 
           RGBColor[0.770565, 0.964309, 0.0442359], "b" -> 
           RGBColor[1., 0.709804, 0.709804], "c" -> RGBColor[0.4, 0.4, 0.4], 
           "n" -> RGBColor[0.291989, 0.437977, 0.888609], "o" -> 
           RGBColor[0.800498, 0.201504, 0.192061], "f" -> 
           RGBColor[0.578462, 0.85539, 0.408855], "ne" -> 
           RGBColor[0.677263, 0.928423, 0.955287], "na" -> 
           RGBColor[0.658708, 0.492173, 0.842842], "mg" -> 
           RGBColor[0.628274, 0.850553, 0.0782731], "al" -> 
           RGBColor[0.8913, 0.631904, 0.627399], "si" -> 
           RGBColor[0.941176, 0.784314, 0.627451], "p" -> 
           RGBColor[1., 0.501961, 0], "s" -> 
           RGBColor[0.90443, 0.97015, 0.13504], "cl" -> 
           RGBColor[0.412698, 0.932689, 0.166398], "ar" -> 
           RGBColor[0.546138, 0.844244, 0.892092], "k" -> 
           RGBColor[0.534026, 0.420729, 0.705621], "ca" -> 
           RGBColor[0.480072, 0.744591, 0.0955222], "sc" -> 
           RGBColor[0.901961, 0.901961, 0.901961], "ti" -> 
           RGBColor[0.74902, 0.760784, 0.780392], "v" -> 
           RGBColor[0.65098, 0.65098, 0.670588], "cr" -> 
           RGBColor[0.541176, 0.6, 0.780392], "mn" -> 
           RGBColor[0.611765, 0.478431, 0.780392], "fe" -> 
           RGBColor[0.878431, 0.4, 0.2], "co" -> 
           RGBColor[0.941176, 0.564706, 0.627451], "ni" -> 
           RGBColor[0.313725, 0.815686, 0.313725], "cu" -> 
           RGBColor[0.784314, 0.501961, 0.2], "zn" -> 
           RGBColor[0.490196, 0.501961, 0.690196], "ga" -> 
           RGBColor[0.800757, 0.542666, 0.533513], "ge" -> 
           RGBColor[0.60508, 0.632465, 0.576489], "as" -> 
           RGBColor[0.741176, 0.501961, 0.890196], "se" -> 
           RGBColor[0.917248, 0.657833, 0.0706628], "br" -> 
           RGBColor[0.58847, 0.22163, 0.16064], "kr" -> 
           RGBColor[0.426019, 0.747462, 0.810413], "rb" -> 
           RGBColor[0.425391, 0.329242, 0.585895], "sr" -> 
           RGBColor[0.325959, 0.646423, 0.095983], "y" -> 
           RGBColor[0.531014, 1., 1.], "zr" -> 
           RGBColor[0.458599, 0.917466, 0.918573], "nb" -> 
           RGBColor[0.385036, 0.834854, 0.841681], "mo" -> 
           RGBColor[0.310325, 0.752163, 0.769323], "tc" -> 
           RGBColor[0.234466, 0.669394, 0.701499], "ru" -> 
           RGBColor[0.157459, 0.586546, 0.638209], "rh" -> 
           RGBColor[0.0793033, 0.50362, 0.579453], "pd" -> 
           RGBColor[0., 0.420615, 0.525231], "ag" -> 
           RGBColor[0.752941, 0.752941, 0.752941], "cd" -> 
           RGBColor[1., 0.85098, 0.560784], "in" -> 
           RGBColor[0.728371, 0.440594, 0.422196], "sn" -> 
           RGBColor[0.39799, 0.491477, 0.495586], "sb" -> 
           RGBColor[0.619608, 0.388235, 0.709804], "te" -> 
           RGBColor[0.816706, 0.451332, 0.0100947], "i" -> 
           RGBColor[0.580392, 0, 0.580392], "xe" -> 
           RGBColor[0.316906, 0.638078, 0.710252], "cs" -> 
           RGBColor[0.332803, 0.217712, 0.483666], "ba" -> 
           RGBColor[0.165935, 0.55605, 0.0796556], "la" -> 
           RGBColor[0.928084, 0.716075, 0.329427], "ce" -> 
           RGBColor[0.894824, 0.731424, 0.325131], "pr" -> 
           RGBColor[0.86523, 0.707999, 0.315261], "nd" -> 
           RGBColor[0.837836, 0.662974, 0.301635], "pm" -> 
           RGBColor[0.811992, 0.607859, 0.285626], "sm" -> 
           RGBColor[0.787563, 0.549894, 0.268279], "eu" -> 
           RGBColor[0.764628, 0.493261, 0.250405], "gd" -> 
           RGBColor[0.743177, 0.440115, 0.23269], "tb" -> 
           RGBColor[0.72281, 0.39143, 0.215783], "dy" -> 
           RGBColor[0.702434, 0.347663, 0.200392], "ho" -> 
           RGBColor[0.679962, 0.309234, 0.187368], "er" -> 
           RGBColor[0.652012, 0.276823, 0.17779], "tm" -> 
           RGBColor[0.613603, 0.251489, 0.173042], "yb" -> 
           RGBColor[0.557855, 0.234598, 0.17489], "lu" -> 
           RGBColor[0.475685, 0.227573, 0.18555], "hf" -> 
           RGBColor[0.781537, 0.717388, 0.716579], "ta" -> 
           RGBColor[0.734443, 0.544489, 0.683471], "w" -> 
           RGBColor[0.681179, 0.360409, 0.63675], "re" -> 
           RGBColor[0.605181, 0.367584, 0.556343], "os" -> 
           RGBColor[0.521806, 0.382125, 0.469204], "ir" -> 
           RGBColor[0.445624, 0.373159, 0.399069], "pt" -> 
           RGBColor[0.815686, 0.815686, 0.878431], "au" -> 
           RGBColor[1., 0.819608, 0.137255], "hg" -> 
           RGBColor[0.721569, 0.721569, 0.815686], "tl" -> 
           RGBColor[0.65098, 0.329412, 0.301961], "pb" -> 
           RGBColor[0.341176, 0.34902, 0.380392], "bi" -> 
           RGBColor[0.619608, 0.309804, 0.709804], "po" -> 
           RGBColor[0.670588, 0.360784, 0], "at" -> 
           RGBColor[0.458824, 0.309804, 0.270588], "rn" -> 
           RGBColor[0.218799, 0.516091, 0.591608], "fr" -> 
           RGBColor[0.25626, 0.0861372, 0.398932], "ra" -> 
           RGBColor[0., 0.473472, 0.04654], "ac" -> 
           RGBColor[0.322042, 0.71693, 0.988479], "th" -> 
           RGBColor[0.3608, 0.67166, 0.943003], "pa" -> 
           RGBColor[0.397469, 0.628, 0.898853], "u" -> 
           RGBColor[0.43205, 0.58595, 0.856029], "np" -> 
           RGBColor[0.464542, 0.54551, 0.814532], "pu" -> 
           RGBColor[0.494945, 0.506679, 0.774361], "am" -> 
           RGBColor[0.52326, 0.469458, 0.735517], "cm" -> 
           RGBColor[0.549486, 0.433847, 0.697999], "bk" -> 
           RGBColor[0.573624, 0.399845, 0.661808], "cf" -> 
           RGBColor[0.595673, 0.367454, 0.626942], "es" -> 
           RGBColor[0.615633, 0.336672, 0.593404], "fm" -> 
           RGBColor[0.633505, 0.307499, 0.561191], "md" -> 
           RGBColor[0.649288, 0.279937, 0.530305], "no" -> 
           RGBColor[0.662982, 0.253984, 0.500746], "lr" -> 
           RGBColor[0.674588, 0.22964, 0.472513], "rf" -> 
           RGBColor[0.684106, 0.206907, 0.445606], "db" -> 
           RGBColor[0.691534, 0.185783, 0.420025], "sg" -> 
           RGBColor[0.696874, 0.166269, 0.395772], "bh" -> 
           RGBColor[0.700126, 0.148365, 0.372844], "hs" -> 
           RGBColor[0.701289, 0.13207, 0.351243], "mt" -> 
           RGBColor[0.700363, 0.117385, 0.330968], "ds" -> 
           RGBColor[0.697348, 0.10431, 0.31202], "rg" -> 
           RGBColor[0.692245, 0.0928444, 0.294398], "cn" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "nh" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "fl" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "mc" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "lv" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "ts" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "og" -> 
           RGBColor[0.635401, 0.0528, 0.226184], "uub" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "uut" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "uuq" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "uup" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "uuh" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "uus" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "uuo" -> 
           RGBColor[0.635401, 0.0528, 0.226184]}]]& ][0.85], 
       ColorDataFunction[
       "Atoms", 
        "Named", {{
         "H", "He", "Li", "Be", "B", "C", "N", "O", "F", "Ne", "Na", "Mg", 
          "Al", "Si", "P", "S", "Cl", "Ar", "K", "Ca", "Sc", "Ti", "V", "Cr", 
          "Mn", "Fe", "Co", "Ni", "Cu", "Zn", "Ga", "Ge", "As", "Se", "Br", 
          "Kr", "Rb", "Sr", "Y", "Zr", "Nb", "Mo", "Tc", "Ru", "Rh", "Pd", 
          "Ag", "Cd", "In", "Sn", "Sb", "Te", "I", "Xe", "Cs", "Ba", "La", 
          "Ce", "Pr", "Nd", "Pm", "Sm", "Eu", "Gd", "Tb", "Dy", "Ho", "Er", 
          "Tm", "Yb", "Lu", "Hf", "Ta", "W", "Re", "Os", "Ir", "Pt", "Au", 
          "Hg", "Tl", "Pb", "Bi", "Po", "At", "Rn", "Fr", "Ra", "Ac", "Th", 
          "Pa", "U", "Np", "Pu", "Am", "Cm", "Bk", "Cf", "Es", "Fm", "Md", 
          "No", "Lr", "Rf", "Db", "Sg", "Bh", "Hs", "Mt", "Ds", "Rg", "Cn", 
          "Nh", "Fl", "Mc", "Lv", "Ts", "Og", "Uub", "Uut", "Uuq", "Uup", 
          "Uuh", "Uus", "Uuo"}, {
         "h", "he", "li", "be", "b", "c", "n", "o", "f", "ne", "na", "mg", 
          "al", "si", "p", "s", "cl", "ar", "k", "ca", "sc", "ti", "v", "cr", 
          "mn", "fe", "co", "ni", "cu", "zn", "ga", "ge", "as", "se", "br", 
          "kr", "rb", "sr", "y", "zr", "nb", "mo", "tc", "ru", "rh", "pd", 
          "ag", "cd", "in", "sn", "sb", "te", "i", "xe", "cs", "ba", "la", 
          "ce", "pr", "nd", "pm", "sm", "eu", "gd", "tb", "dy", "ho", "er", 
          "tm", "yb", "lu", "hf", "ta", "w", "re", "os", "ir", "pt", "au", 
          "hg", "tl", "pb", "bi", "po", "at", "rn", "fr", "ra", "ac", "th", 
          "pa", "u", "np", "pu", "am", "cm", "bk", "cf", "es", "fm", "md", 
          "no", "lr", "rf", "db", "sg", "bh", "hs", "mt", "ds", "rg", "cn", 
          "nh", "fl", "mc", "lv", "ts", "og", "uub", "uut", "uuq", "uup", 
          "uuh", "uus", "uuo"}}, Replace[#, 
         Dispatch[{
          "h" -> RGBColor[0.65, 0.7, 0.7], "he" -> RGBColor[0.836713, 1., 1.],
            "li" -> RGBColor[0.799435, 0.543572, 0.997559], "be" -> 
           RGBColor[0.770565, 0.964309, 0.0442359], "b" -> 
           RGBColor[1., 0.709804, 0.709804], "c" -> RGBColor[0.4, 0.4, 0.4], 
           "n" -> RGBColor[0.291989, 0.437977, 0.888609], "o" -> 
           RGBColor[0.800498, 0.201504, 0.192061], "f" -> 
           RGBColor[0.578462, 0.85539, 0.408855], "ne" -> 
           RGBColor[0.677263, 0.928423, 0.955287], "na" -> 
           RGBColor[0.658708, 0.492173, 0.842842], "mg" -> 
           RGBColor[0.628274, 0.850553, 0.0782731], "al" -> 
           RGBColor[0.8913, 0.631904, 0.627399], "si" -> 
           RGBColor[0.941176, 0.784314, 0.627451], "p" -> 
           RGBColor[1., 0.501961, 0], "s" -> 
           RGBColor[0.90443, 0.97015, 0.13504], "cl" -> 
           RGBColor[0.412698, 0.932689, 0.166398], "ar" -> 
           RGBColor[0.546138, 0.844244, 0.892092], "k" -> 
           RGBColor[0.534026, 0.420729, 0.705621], "ca" -> 
           RGBColor[0.480072, 0.744591, 0.0955222], "sc" -> 
           RGBColor[0.901961, 0.901961, 0.901961], "ti" -> 
           RGBColor[0.74902, 0.760784, 0.780392], "v" -> 
           RGBColor[0.65098, 0.65098, 0.670588], "cr" -> 
           RGBColor[0.541176, 0.6, 0.780392], "mn" -> 
           RGBColor[0.611765, 0.478431, 0.780392], "fe" -> 
           RGBColor[0.878431, 0.4, 0.2], "co" -> 
           RGBColor[0.941176, 0.564706, 0.627451], "ni" -> 
           RGBColor[0.313725, 0.815686, 0.313725], "cu" -> 
           RGBColor[0.784314, 0.501961, 0.2], "zn" -> 
           RGBColor[0.490196, 0.501961, 0.690196], "ga" -> 
           RGBColor[0.800757, 0.542666, 0.533513], "ge" -> 
           RGBColor[0.60508, 0.632465, 0.576489], "as" -> 
           RGBColor[0.741176, 0.501961, 0.890196], "se" -> 
           RGBColor[0.917248, 0.657833, 0.0706628], "br" -> 
           RGBColor[0.58847, 0.22163, 0.16064], "kr" -> 
           RGBColor[0.426019, 0.747462, 0.810413], "rb" -> 
           RGBColor[0.425391, 0.329242, 0.585895], "sr" -> 
           RGBColor[0.325959, 0.646423, 0.095983], "y" -> 
           RGBColor[0.531014, 1., 1.], "zr" -> 
           RGBColor[0.458599, 0.917466, 0.918573], "nb" -> 
           RGBColor[0.385036, 0.834854, 0.841681], "mo" -> 
           RGBColor[0.310325, 0.752163, 0.769323], "tc" -> 
           RGBColor[0.234466, 0.669394, 0.701499], "ru" -> 
           RGBColor[0.157459, 0.586546, 0.638209], "rh" -> 
           RGBColor[0.0793033, 0.50362, 0.579453], "pd" -> 
           RGBColor[0., 0.420615, 0.525231], "ag" -> 
           RGBColor[0.752941, 0.752941, 0.752941], "cd" -> 
           RGBColor[1., 0.85098, 0.560784], "in" -> 
           RGBColor[0.728371, 0.440594, 0.422196], "sn" -> 
           RGBColor[0.39799, 0.491477, 0.495586], "sb" -> 
           RGBColor[0.619608, 0.388235, 0.709804], "te" -> 
           RGBColor[0.816706, 0.451332, 0.0100947], "i" -> 
           RGBColor[0.580392, 0, 0.580392], "xe" -> 
           RGBColor[0.316906, 0.638078, 0.710252], "cs" -> 
           RGBColor[0.332803, 0.217712, 0.483666], "ba" -> 
           RGBColor[0.165935, 0.55605, 0.0796556], "la" -> 
           RGBColor[0.928084, 0.716075, 0.329427], "ce" -> 
           RGBColor[0.894824, 0.731424, 0.325131], "pr" -> 
           RGBColor[0.86523, 0.707999, 0.315261], "nd" -> 
           RGBColor[0.837836, 0.662974, 0.301635], "pm" -> 
           RGBColor[0.811992, 0.607859, 0.285626], "sm" -> 
           RGBColor[0.787563, 0.549894, 0.268279], "eu" -> 
           RGBColor[0.764628, 0.493261, 0.250405], "gd" -> 
           RGBColor[0.743177, 0.440115, 0.23269], "tb" -> 
           RGBColor[0.72281, 0.39143, 0.215783], "dy" -> 
           RGBColor[0.702434, 0.347663, 0.200392], "ho" -> 
           RGBColor[0.679962, 0.309234, 0.187368], "er" -> 
           RGBColor[0.652012, 0.276823, 0.17779], "tm" -> 
           RGBColor[0.613603, 0.251489, 0.173042], "yb" -> 
           RGBColor[0.557855, 0.234598, 0.17489], "lu" -> 
           RGBColor[0.475685, 0.227573, 0.18555], "hf" -> 
           RGBColor[0.781537, 0.717388, 0.716579], "ta" -> 
           RGBColor[0.734443, 0.544489, 0.683471], "w" -> 
           RGBColor[0.681179, 0.360409, 0.63675], "re" -> 
           RGBColor[0.605181, 0.367584, 0.556343], "os" -> 
           RGBColor[0.521806, 0.382125, 0.469204], "ir" -> 
           RGBColor[0.445624, 0.373159, 0.399069], "pt" -> 
           RGBColor[0.815686, 0.815686, 0.878431], "au" -> 
           RGBColor[1., 0.819608, 0.137255], "hg" -> 
           RGBColor[0.721569, 0.721569, 0.815686], "tl" -> 
           RGBColor[0.65098, 0.329412, 0.301961], "pb" -> 
           RGBColor[0.341176, 0.34902, 0.380392], "bi" -> 
           RGBColor[0.619608, 0.309804, 0.709804], "po" -> 
           RGBColor[0.670588, 0.360784, 0], "at" -> 
           RGBColor[0.458824, 0.309804, 0.270588], "rn" -> 
           RGBColor[0.218799, 0.516091, 0.591608], "fr" -> 
           RGBColor[0.25626, 0.0861372, 0.398932], "ra" -> 
           RGBColor[0., 0.473472, 0.04654], "ac" -> 
           RGBColor[0.322042, 0.71693, 0.988479], "th" -> 
           RGBColor[0.3608, 0.67166, 0.943003], "pa" -> 
           RGBColor[0.397469, 0.628, 0.898853], "u" -> 
           RGBColor[0.43205, 0.58595, 0.856029], "np" -> 
           RGBColor[0.464542, 0.54551, 0.814532], "pu" -> 
           RGBColor[0.494945, 0.506679, 0.774361], "am" -> 
           RGBColor[0.52326, 0.469458, 0.735517], "cm" -> 
           RGBColor[0.549486, 0.433847, 0.697999], "bk" -> 
           RGBColor[0.573624, 0.399845, 0.661808], "cf" -> 
           RGBColor[0.595673, 0.367454, 0.626942], "es" -> 
           RGBColor[0.615633, 0.336672, 0.593404], "fm" -> 
           RGBColor[0.633505, 0.307499, 0.561191], "md" -> 
           RGBColor[0.649288, 0.279937, 0.530305], "no" -> 
           RGBColor[0.662982, 0.253984, 0.500746], "lr" -> 
           RGBColor[0.674588, 0.22964, 0.472513], "rf" -> 
           RGBColor[0.684106, 0.206907, 0.445606], "db" -> 
           RGBColor[0.691534, 0.185783, 0.420025], "sg" -> 
           RGBColor[0.696874, 0.166269, 0.395772], "bh" -> 
           RGBColor[0.700126, 0.148365, 0.372844], "hs" -> 
           RGBColor[0.701289, 0.13207, 0.351243], "mt" -> 
           RGBColor[0.700363, 0.117385, 0.330968], "ds" -> 
           RGBColor[0.697348, 0.10431, 0.31202], "rg" -> 
           RGBColor[0.692245, 0.0928444, 0.294398], "cn" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "nh" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "fl" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "mc" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "lv" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "ts" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "og" -> 
           RGBColor[0.635401, 0.0528, 0.226184], "uub" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "uut" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "uuq" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "uup" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "uuh" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "uus" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "uuo" -> 
           RGBColor[0.635401, 0.0528, 0.226184]}]]& ][0.85], 
       ColorDataFunction[
       "Atoms", 
        "Named", {{
         "H", "He", "Li", "Be", "B", "C", "N", "O", "F", "Ne", "Na", "Mg", 
          "Al", "Si", "P", "S", "Cl", "Ar", "K", "Ca", "Sc", "Ti", "V", "Cr", 
          "Mn", "Fe", "Co", "Ni", "Cu", "Zn", "Ga", "Ge", "As", "Se", "Br", 
          "Kr", "Rb", "Sr", "Y", "Zr", "Nb", "Mo", "Tc", "Ru", "Rh", "Pd", 
          "Ag", "Cd", "In", "Sn", "Sb", "Te", "I", "Xe", "Cs", "Ba", "La", 
          "Ce", "Pr", "Nd", "Pm", "Sm", "Eu", "Gd", "Tb", "Dy", "Ho", "Er", 
          "Tm", "Yb", "Lu", "Hf", "Ta", "W", "Re", "Os", "Ir", "Pt", "Au", 
          "Hg", "Tl", "Pb", "Bi", "Po", "At", "Rn", "Fr", "Ra", "Ac", "Th", 
          "Pa", "U", "Np", "Pu", "Am", "Cm", "Bk", "Cf", "Es", "Fm", "Md", 
          "No", "Lr", "Rf", "Db", "Sg", "Bh", "Hs", "Mt", "Ds", "Rg", "Cn", 
          "Nh", "Fl", "Mc", "Lv", "Ts", "Og", "Uub", "Uut", "Uuq", "Uup", 
          "Uuh", "Uus", "Uuo"}, {
         "h", "he", "li", "be", "b", "c", "n", "o", "f", "ne", "na", "mg", 
          "al", "si", "p", "s", "cl", "ar", "k", "ca", "sc", "ti", "v", "cr", 
          "mn", "fe", "co", "ni", "cu", "zn", "ga", "ge", "as", "se", "br", 
          "kr", "rb", "sr", "y", "zr", "nb", "mo", "tc", "ru", "rh", "pd", 
          "ag", "cd", "in", "sn", "sb", "te", "i", "xe", "cs", "ba", "la", 
          "ce", "pr", "nd", "pm", "sm", "eu", "gd", "tb", "dy", "ho", "er", 
          "tm", "yb", "lu", "hf", "ta", "w", "re", "os", "ir", "pt", "au", 
          "hg", "tl", "pb", "bi", "po", "at", "rn", "fr", "ra", "ac", "th", 
          "pa", "u", "np", "pu", "am", "cm", "bk", "cf", "es", "fm", "md", 
          "no", "lr", "rf", "db", "sg", "bh", "hs", "mt", "ds", "rg", "cn", 
          "nh", "fl", "mc", "lv", "ts", "og", "uub", "uut", "uuq", "uup", 
          "uuh", "uus", "uuo"}}, Replace[#, 
         Dispatch[{
          "h" -> RGBColor[0.65, 0.7, 0.7], "he" -> RGBColor[0.836713, 1., 1.],
            "li" -> RGBColor[0.799435, 0.543572, 0.997559], "be" -> 
           RGBColor[0.770565, 0.964309, 0.0442359], "b" -> 
           RGBColor[1., 0.709804, 0.709804], "c" -> RGBColor[0.4, 0.4, 0.4], 
           "n" -> RGBColor[0.291989, 0.437977, 0.888609], "o" -> 
           RGBColor[0.800498, 0.201504, 0.192061], "f" -> 
           RGBColor[0.578462, 0.85539, 0.408855], "ne" -> 
           RGBColor[0.677263, 0.928423, 0.955287], "na" -> 
           RGBColor[0.658708, 0.492173, 0.842842], "mg" -> 
           RGBColor[0.628274, 0.850553, 0.0782731], "al" -> 
           RGBColor[0.8913, 0.631904, 0.627399], "si" -> 
           RGBColor[0.941176, 0.784314, 0.627451], "p" -> 
           RGBColor[1., 0.501961, 0], "s" -> 
           RGBColor[0.90443, 0.97015, 0.13504], "cl" -> 
           RGBColor[0.412698, 0.932689, 0.166398], "ar" -> 
           RGBColor[0.546138, 0.844244, 0.892092], "k" -> 
           RGBColor[0.534026, 0.420729, 0.705621], "ca" -> 
           RGBColor[0.480072, 0.744591, 0.0955222], "sc" -> 
           RGBColor[0.901961, 0.901961, 0.901961], "ti" -> 
           RGBColor[0.74902, 0.760784, 0.780392], "v" -> 
           RGBColor[0.65098, 0.65098, 0.670588], "cr" -> 
           RGBColor[0.541176, 0.6, 0.780392], "mn" -> 
           RGBColor[0.611765, 0.478431, 0.780392], "fe" -> 
           RGBColor[0.878431, 0.4, 0.2], "co" -> 
           RGBColor[0.941176, 0.564706, 0.627451], "ni" -> 
           RGBColor[0.313725, 0.815686, 0.313725], "cu" -> 
           RGBColor[0.784314, 0.501961, 0.2], "zn" -> 
           RGBColor[0.490196, 0.501961, 0.690196], "ga" -> 
           RGBColor[0.800757, 0.542666, 0.533513], "ge" -> 
           RGBColor[0.60508, 0.632465, 0.576489], "as" -> 
           RGBColor[0.741176, 0.501961, 0.890196], "se" -> 
           RGBColor[0.917248, 0.657833, 0.0706628], "br" -> 
           RGBColor[0.58847, 0.22163, 0.16064], "kr" -> 
           RGBColor[0.426019, 0.747462, 0.810413], "rb" -> 
           RGBColor[0.425391, 0.329242, 0.585895], "sr" -> 
           RGBColor[0.325959, 0.646423, 0.095983], "y" -> 
           RGBColor[0.531014, 1., 1.], "zr" -> 
           RGBColor[0.458599, 0.917466, 0.918573], "nb" -> 
           RGBColor[0.385036, 0.834854, 0.841681], "mo" -> 
           RGBColor[0.310325, 0.752163, 0.769323], "tc" -> 
           RGBColor[0.234466, 0.669394, 0.701499], "ru" -> 
           RGBColor[0.157459, 0.586546, 0.638209], "rh" -> 
           RGBColor[0.0793033, 0.50362, 0.579453], "pd" -> 
           RGBColor[0., 0.420615, 0.525231], "ag" -> 
           RGBColor[0.752941, 0.752941, 0.752941], "cd" -> 
           RGBColor[1., 0.85098, 0.560784], "in" -> 
           RGBColor[0.728371, 0.440594, 0.422196], "sn" -> 
           RGBColor[0.39799, 0.491477, 0.495586], "sb" -> 
           RGBColor[0.619608, 0.388235, 0.709804], "te" -> 
           RGBColor[0.816706, 0.451332, 0.0100947], "i" -> 
           RGBColor[0.580392, 0, 0.580392], "xe" -> 
           RGBColor[0.316906, 0.638078, 0.710252], "cs" -> 
           RGBColor[0.332803, 0.217712, 0.483666], "ba" -> 
           RGBColor[0.165935, 0.55605, 0.0796556], "la" -> 
           RGBColor[0.928084, 0.716075, 0.329427], "ce" -> 
           RGBColor[0.894824, 0.731424, 0.325131], "pr" -> 
           RGBColor[0.86523, 0.707999, 0.315261], "nd" -> 
           RGBColor[0.837836, 0.662974, 0.301635], "pm" -> 
           RGBColor[0.811992, 0.607859, 0.285626], "sm" -> 
           RGBColor[0.787563, 0.549894, 0.268279], "eu" -> 
           RGBColor[0.764628, 0.493261, 0.250405], "gd" -> 
           RGBColor[0.743177, 0.440115, 0.23269], "tb" -> 
           RGBColor[0.72281, 0.39143, 0.215783], "dy" -> 
           RGBColor[0.702434, 0.347663, 0.200392], "ho" -> 
           RGBColor[0.679962, 0.309234, 0.187368], "er" -> 
           RGBColor[0.652012, 0.276823, 0.17779], "tm" -> 
           RGBColor[0.613603, 0.251489, 0.173042], "yb" -> 
           RGBColor[0.557855, 0.234598, 0.17489], "lu" -> 
           RGBColor[0.475685, 0.227573, 0.18555], "hf" -> 
           RGBColor[0.781537, 0.717388, 0.716579], "ta" -> 
           RGBColor[0.734443, 0.544489, 0.683471], "w" -> 
           RGBColor[0.681179, 0.360409, 0.63675], "re" -> 
           RGBColor[0.605181, 0.367584, 0.556343], "os" -> 
           RGBColor[0.521806, 0.382125, 0.469204], "ir" -> 
           RGBColor[0.445624, 0.373159, 0.399069], "pt" -> 
           RGBColor[0.815686, 0.815686, 0.878431], "au" -> 
           RGBColor[1., 0.819608, 0.137255], "hg" -> 
           RGBColor[0.721569, 0.721569, 0.815686], "tl" -> 
           RGBColor[0.65098, 0.329412, 0.301961], "pb" -> 
           RGBColor[0.341176, 0.34902, 0.380392], "bi" -> 
           RGBColor[0.619608, 0.309804, 0.709804], "po" -> 
           RGBColor[0.670588, 0.360784, 0], "at" -> 
           RGBColor[0.458824, 0.309804, 0.270588], "rn" -> 
           RGBColor[0.218799, 0.516091, 0.591608], "fr" -> 
           RGBColor[0.25626, 0.0861372, 0.398932], "ra" -> 
           RGBColor[0., 0.473472, 0.04654], "ac" -> 
           RGBColor[0.322042, 0.71693, 0.988479], "th" -> 
           RGBColor[0.3608, 0.67166, 0.943003], "pa" -> 
           RGBColor[0.397469, 0.628, 0.898853], "u" -> 
           RGBColor[0.43205, 0.58595, 0.856029], "np" -> 
           RGBColor[0.464542, 0.54551, 0.814532], "pu" -> 
           RGBColor[0.494945, 0.506679, 0.774361], "am" -> 
           RGBColor[0.52326, 0.469458, 0.735517], "cm" -> 
           RGBColor[0.549486, 0.433847, 0.697999], "bk" -> 
           RGBColor[0.573624, 0.399845, 0.661808], "cf" -> 
           RGBColor[0.595673, 0.367454, 0.626942], "es" -> 
           RGBColor[0.615633, 0.336672, 0.593404], "fm" -> 
           RGBColor[0.633505, 0.307499, 0.561191], "md" -> 
           RGBColor[0.649288, 0.279937, 0.530305], "no" -> 
           RGBColor[0.662982, 0.253984, 0.500746], "lr" -> 
           RGBColor[0.674588, 0.22964, 0.472513], "rf" -> 
           RGBColor[0.684106, 0.206907, 0.445606], "db" -> 
           RGBColor[0.691534, 0.185783, 0.420025], "sg" -> 
           RGBColor[0.696874, 0.166269, 0.395772], "bh" -> 
           RGBColor[0.700126, 0.148365, 0.372844], "hs" -> 
           RGBColor[0.701289, 0.13207, 0.351243], "mt" -> 
           RGBColor[0.700363, 0.117385, 0.330968], "ds" -> 
           RGBColor[0.697348, 0.10431, 0.31202], "rg" -> 
           RGBColor[0.692245, 0.0928444, 0.294398], "cn" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "nh" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "fl" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "mc" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "lv" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "ts" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "og" -> 
           RGBColor[0.635401, 0.0528, 0.226184], "uub" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "uut" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "uuq" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "uup" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "uuh" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "uus" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "uuo" -> 
           RGBColor[0.635401, 0.0528, 0.226184]}]]& ][0.85], 
       ColorDataFunction[
       "Atoms", 
        "Named", {{
         "H", "He", "Li", "Be", "B", "C", "N", "O", "F", "Ne", "Na", "Mg", 
          "Al", "Si", "P", "S", "Cl", "Ar", "K", "Ca", "Sc", "Ti", "V", "Cr", 
          "Mn", "Fe", "Co", "Ni", "Cu", "Zn", "Ga", "Ge", "As", "Se", "Br", 
          "Kr", "Rb", "Sr", "Y", "Zr", "Nb", "Mo", "Tc", "Ru", "Rh", "Pd", 
          "Ag", "Cd", "In", "Sn", "Sb", "Te", "I", "Xe", "Cs", "Ba", "La", 
          "Ce", "Pr", "Nd", "Pm", "Sm", "Eu", "Gd", "Tb", "Dy", "Ho", "Er", 
          "Tm", "Yb", "Lu", "Hf", "Ta", "W", "Re", "Os", "Ir", "Pt", "Au", 
          "Hg", "Tl", "Pb", "Bi", "Po", "At", "Rn", "Fr", "Ra", "Ac", "Th", 
          "Pa", "U", "Np", "Pu", "Am", "Cm", "Bk", "Cf", "Es", "Fm", "Md", 
          "No", "Lr", "Rf", "Db", "Sg", "Bh", "Hs", "Mt", "Ds", "Rg", "Cn", 
          "Nh", "Fl", "Mc", "Lv", "Ts", "Og", "Uub", "Uut", "Uuq", "Uup", 
          "Uuh", "Uus", "Uuo"}, {
         "h", "he", "li", "be", "b", "c", "n", "o", "f", "ne", "na", "mg", 
          "al", "si", "p", "s", "cl", "ar", "k", "ca", "sc", "ti", "v", "cr", 
          "mn", "fe", "co", "ni", "cu", "zn", "ga", "ge", "as", "se", "br", 
          "kr", "rb", "sr", "y", "zr", "nb", "mo", "tc", "ru", "rh", "pd", 
          "ag", "cd", "in", "sn", "sb", "te", "i", "xe", "cs", "ba", "la", 
          "ce", "pr", "nd", "pm", "sm", "eu", "gd", "tb", "dy", "ho", "er", 
          "tm", "yb", "lu", "hf", "ta", "w", "re", "os", "ir", "pt", "au", 
          "hg", "tl", "pb", "bi", "po", "at", "rn", "fr", "ra", "ac", "th", 
          "pa", "u", "np", "pu", "am", "cm", "bk", "cf", "es", "fm", "md", 
          "no", "lr", "rf", "db", "sg", "bh", "hs", "mt", "ds", "rg", "cn", 
          "nh", "fl", "mc", "lv", "ts", "og", "uub", "uut", "uuq", "uup", 
          "uuh", "uus", "uuo"}}, Replace[#, 
         Dispatch[{
          "h" -> RGBColor[0.65, 0.7, 0.7], "he" -> RGBColor[0.836713, 1., 1.],
            "li" -> RGBColor[0.799435, 0.543572, 0.997559], "be" -> 
           RGBColor[0.770565, 0.964309, 0.0442359], "b" -> 
           RGBColor[1., 0.709804, 0.709804], "c" -> RGBColor[0.4, 0.4, 0.4], 
           "n" -> RGBColor[0.291989, 0.437977, 0.888609], "o" -> 
           RGBColor[0.800498, 0.201504, 0.192061], "f" -> 
           RGBColor[0.578462, 0.85539, 0.408855], "ne" -> 
           RGBColor[0.677263, 0.928423, 0.955287], "na" -> 
           RGBColor[0.658708, 0.492173, 0.842842], "mg" -> 
           RGBColor[0.628274, 0.850553, 0.0782731], "al" -> 
           RGBColor[0.8913, 0.631904, 0.627399], "si" -> 
           RGBColor[0.941176, 0.784314, 0.627451], "p" -> 
           RGBColor[1., 0.501961, 0], "s" -> 
           RGBColor[0.90443, 0.97015, 0.13504], "cl" -> 
           RGBColor[0.412698, 0.932689, 0.166398], "ar" -> 
           RGBColor[0.546138, 0.844244, 0.892092], "k" -> 
           RGBColor[0.534026, 0.420729, 0.705621], "ca" -> 
           RGBColor[0.480072, 0.744591, 0.0955222], "sc" -> 
           RGBColor[0.901961, 0.901961, 0.901961], "ti" -> 
           RGBColor[0.74902, 0.760784, 0.780392], "v" -> 
           RGBColor[0.65098, 0.65098, 0.670588], "cr" -> 
           RGBColor[0.541176, 0.6, 0.780392], "mn" -> 
           RGBColor[0.611765, 0.478431, 0.780392], "fe" -> 
           RGBColor[0.878431, 0.4, 0.2], "co" -> 
           RGBColor[0.941176, 0.564706, 0.627451], "ni" -> 
           RGBColor[0.313725, 0.815686, 0.313725], "cu" -> 
           RGBColor[0.784314, 0.501961, 0.2], "zn" -> 
           RGBColor[0.490196, 0.501961, 0.690196], "ga" -> 
           RGBColor[0.800757, 0.542666, 0.533513], "ge" -> 
           RGBColor[0.60508, 0.632465, 0.576489], "as" -> 
           RGBColor[0.741176, 0.501961, 0.890196], "se" -> 
           RGBColor[0.917248, 0.657833, 0.0706628], "br" -> 
           RGBColor[0.58847, 0.22163, 0.16064], "kr" -> 
           RGBColor[0.426019, 0.747462, 0.810413], "rb" -> 
           RGBColor[0.425391, 0.329242, 0.585895], "sr" -> 
           RGBColor[0.325959, 0.646423, 0.095983], "y" -> 
           RGBColor[0.531014, 1., 1.], "zr" -> 
           RGBColor[0.458599, 0.917466, 0.918573], "nb" -> 
           RGBColor[0.385036, 0.834854, 0.841681], "mo" -> 
           RGBColor[0.310325, 0.752163, 0.769323], "tc" -> 
           RGBColor[0.234466, 0.669394, 0.701499], "ru" -> 
           RGBColor[0.157459, 0.586546, 0.638209], "rh" -> 
           RGBColor[0.0793033, 0.50362, 0.579453], "pd" -> 
           RGBColor[0., 0.420615, 0.525231], "ag" -> 
           RGBColor[0.752941, 0.752941, 0.752941], "cd" -> 
           RGBColor[1., 0.85098, 0.560784], "in" -> 
           RGBColor[0.728371, 0.440594, 0.422196], "sn" -> 
           RGBColor[0.39799, 0.491477, 0.495586], "sb" -> 
           RGBColor[0.619608, 0.388235, 0.709804], "te" -> 
           RGBColor[0.816706, 0.451332, 0.0100947], "i" -> 
           RGBColor[0.580392, 0, 0.580392], "xe" -> 
           RGBColor[0.316906, 0.638078, 0.710252], "cs" -> 
           RGBColor[0.332803, 0.217712, 0.483666], "ba" -> 
           RGBColor[0.165935, 0.55605, 0.0796556], "la" -> 
           RGBColor[0.928084, 0.716075, 0.329427], "ce" -> 
           RGBColor[0.894824, 0.731424, 0.325131], "pr" -> 
           RGBColor[0.86523, 0.707999, 0.315261], "nd" -> 
           RGBColor[0.837836, 0.662974, 0.301635], "pm" -> 
           RGBColor[0.811992, 0.607859, 0.285626], "sm" -> 
           RGBColor[0.787563, 0.549894, 0.268279], "eu" -> 
           RGBColor[0.764628, 0.493261, 0.250405], "gd" -> 
           RGBColor[0.743177, 0.440115, 0.23269], "tb" -> 
           RGBColor[0.72281, 0.39143, 0.215783], "dy" -> 
           RGBColor[0.702434, 0.347663, 0.200392], "ho" -> 
           RGBColor[0.679962, 0.309234, 0.187368], "er" -> 
           RGBColor[0.652012, 0.276823, 0.17779], "tm" -> 
           RGBColor[0.613603, 0.251489, 0.173042], "yb" -> 
           RGBColor[0.557855, 0.234598, 0.17489], "lu" -> 
           RGBColor[0.475685, 0.227573, 0.18555], "hf" -> 
           RGBColor[0.781537, 0.717388, 0.716579], "ta" -> 
           RGBColor[0.734443, 0.544489, 0.683471], "w" -> 
           RGBColor[0.681179, 0.360409, 0.63675], "re" -> 
           RGBColor[0.605181, 0.367584, 0.556343], "os" -> 
           RGBColor[0.521806, 0.382125, 0.469204], "ir" -> 
           RGBColor[0.445624, 0.373159, 0.399069], "pt" -> 
           RGBColor[0.815686, 0.815686, 0.878431], "au" -> 
           RGBColor[1., 0.819608, 0.137255], "hg" -> 
           RGBColor[0.721569, 0.721569, 0.815686], "tl" -> 
           RGBColor[0.65098, 0.329412, 0.301961], "pb" -> 
           RGBColor[0.341176, 0.34902, 0.380392], "bi" -> 
           RGBColor[0.619608, 0.309804, 0.709804], "po" -> 
           RGBColor[0.670588, 0.360784, 0], "at" -> 
           RGBColor[0.458824, 0.309804, 0.270588], "rn" -> 
           RGBColor[0.218799, 0.516091, 0.591608], "fr" -> 
           RGBColor[0.25626, 0.0861372, 0.398932], "ra" -> 
           RGBColor[0., 0.473472, 0.04654], "ac" -> 
           RGBColor[0.322042, 0.71693, 0.988479], "th" -> 
           RGBColor[0.3608, 0.67166, 0.943003], "pa" -> 
           RGBColor[0.397469, 0.628, 0.898853], "u" -> 
           RGBColor[0.43205, 0.58595, 0.856029], "np" -> 
           RGBColor[0.464542, 0.54551, 0.814532], "pu" -> 
           RGBColor[0.494945, 0.506679, 0.774361], "am" -> 
           RGBColor[0.52326, 0.469458, 0.735517], "cm" -> 
           RGBColor[0.549486, 0.433847, 0.697999], "bk" -> 
           RGBColor[0.573624, 0.399845, 0.661808], "cf" -> 
           RGBColor[0.595673, 0.367454, 0.626942], "es" -> 
           RGBColor[0.615633, 0.336672, 0.593404], "fm" -> 
           RGBColor[0.633505, 0.307499, 0.561191], "md" -> 
           RGBColor[0.649288, 0.279937, 0.530305], "no" -> 
           RGBColor[0.662982, 0.253984, 0.500746], "lr" -> 
           RGBColor[0.674588, 0.22964, 0.472513], "rf" -> 
           RGBColor[0.684106, 0.206907, 0.445606], "db" -> 
           RGBColor[0.691534, 0.185783, 0.420025], "sg" -> 
           RGBColor[0.696874, 0.166269, 0.395772], "bh" -> 
           RGBColor[0.700126, 0.148365, 0.372844], "hs" -> 
           RGBColor[0.701289, 0.13207, 0.351243], "mt" -> 
           RGBColor[0.700363, 0.117385, 0.330968], "ds" -> 
           RGBColor[0.697348, 0.10431, 0.31202], "rg" -> 
           RGBColor[0.692245, 0.0928444, 0.294398], "cn" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "nh" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "fl" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "mc" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "lv" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "ts" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "og" -> 
           RGBColor[0.635401, 0.0528, 0.226184], "uub" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "uut" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "uuq" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "uup" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "uuh" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "uus" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "uuo" -> 
           RGBColor[0.635401, 0.0528, 0.226184]}]]& ][0.85], 
       ColorDataFunction[
       "Atoms", 
        "Named", {{
         "H", "He", "Li", "Be", "B", "C", "N", "O", "F", "Ne", "Na", "Mg", 
          "Al", "Si", "P", "S", "Cl", "Ar", "K", "Ca", "Sc", "Ti", "V", "Cr", 
          "Mn", "Fe", "Co", "Ni", "Cu", "Zn", "Ga", "Ge", "As", "Se", "Br", 
          "Kr", "Rb", "Sr", "Y", "Zr", "Nb", "Mo", "Tc", "Ru", "Rh", "Pd", 
          "Ag", "Cd", "In", "Sn", "Sb", "Te", "I", "Xe", "Cs", "Ba", "La", 
          "Ce", "Pr", "Nd", "Pm", "Sm", "Eu", "Gd", "Tb", "Dy", "Ho", "Er", 
          "Tm", "Yb", "Lu", "Hf", "Ta", "W", "Re", "Os", "Ir", "Pt", "Au", 
          "Hg", "Tl", "Pb", "Bi", "Po", "At", "Rn", "Fr", "Ra", "Ac", "Th", 
          "Pa", "U", "Np", "Pu", "Am", "Cm", "Bk", "Cf", "Es", "Fm", "Md", 
          "No", "Lr", "Rf", "Db", "Sg", "Bh", "Hs", "Mt", "Ds", "Rg", "Cn", 
          "Nh", "Fl", "Mc", "Lv", "Ts", "Og", "Uub", "Uut", "Uuq", "Uup", 
          "Uuh", "Uus", "Uuo"}, {
         "h", "he", "li", "be", "b", "c", "n", "o", "f", "ne", "na", "mg", 
          "al", "si", "p", "s", "cl", "ar", "k", "ca", "sc", "ti", "v", "cr", 
          "mn", "fe", "co", "ni", "cu", "zn", "ga", "ge", "as", "se", "br", 
          "kr", "rb", "sr", "y", "zr", "nb", "mo", "tc", "ru", "rh", "pd", 
          "ag", "cd", "in", "sn", "sb", "te", "i", "xe", "cs", "ba", "la", 
          "ce", "pr", "nd", "pm", "sm", "eu", "gd", "tb", "dy", "ho", "er", 
          "tm", "yb", "lu", "hf", "ta", "w", "re", "os", "ir", "pt", "au", 
          "hg", "tl", "pb", "bi", "po", "at", "rn", "fr", "ra", "ac", "th", 
          "pa", "u", "np", "pu", "am", "cm", "bk", "cf", "es", "fm", "md", 
          "no", "lr", "rf", "db", "sg", "bh", "hs", "mt", "ds", "rg", "cn", 
          "nh", "fl", "mc", "lv", "ts", "og", "uub", "uut", "uuq", "uup", 
          "uuh", "uus", "uuo"}}, Replace[#, 
         Dispatch[{
          "h" -> RGBColor[0.65, 0.7, 0.7], "he" -> RGBColor[0.836713, 1., 1.],
            "li" -> RGBColor[0.799435, 0.543572, 0.997559], "be" -> 
           RGBColor[0.770565, 0.964309, 0.0442359], "b" -> 
           RGBColor[1., 0.709804, 0.709804], "c" -> RGBColor[0.4, 0.4, 0.4], 
           "n" -> RGBColor[0.291989, 0.437977, 0.888609], "o" -> 
           RGBColor[0.800498, 0.201504, 0.192061], "f" -> 
           RGBColor[0.578462, 0.85539, 0.408855], "ne" -> 
           RGBColor[0.677263, 0.928423, 0.955287], "na" -> 
           RGBColor[0.658708, 0.492173, 0.842842], "mg" -> 
           RGBColor[0.628274, 0.850553, 0.0782731], "al" -> 
           RGBColor[0.8913, 0.631904, 0.627399], "si" -> 
           RGBColor[0.941176, 0.784314, 0.627451], "p" -> 
           RGBColor[1., 0.501961, 0], "s" -> 
           RGBColor[0.90443, 0.97015, 0.13504], "cl" -> 
           RGBColor[0.412698, 0.932689, 0.166398], "ar" -> 
           RGBColor[0.546138, 0.844244, 0.892092], "k" -> 
           RGBColor[0.534026, 0.420729, 0.705621], "ca" -> 
           RGBColor[0.480072, 0.744591, 0.0955222], "sc" -> 
           RGBColor[0.901961, 0.901961, 0.901961], "ti" -> 
           RGBColor[0.74902, 0.760784, 0.780392], "v" -> 
           RGBColor[0.65098, 0.65098, 0.670588], "cr" -> 
           RGBColor[0.541176, 0.6, 0.780392], "mn" -> 
           RGBColor[0.611765, 0.478431, 0.780392], "fe" -> 
           RGBColor[0.878431, 0.4, 0.2], "co" -> 
           RGBColor[0.941176, 0.564706, 0.627451], "ni" -> 
           RGBColor[0.313725, 0.815686, 0.313725], "cu" -> 
           RGBColor[0.784314, 0.501961, 0.2], "zn" -> 
           RGBColor[0.490196, 0.501961, 0.690196], "ga" -> 
           RGBColor[0.800757, 0.542666, 0.533513], "ge" -> 
           RGBColor[0.60508, 0.632465, 0.576489], "as" -> 
           RGBColor[0.741176, 0.501961, 0.890196], "se" -> 
           RGBColor[0.917248, 0.657833, 0.0706628], "br" -> 
           RGBColor[0.58847, 0.22163, 0.16064], "kr" -> 
           RGBColor[0.426019, 0.747462, 0.810413], "rb" -> 
           RGBColor[0.425391, 0.329242, 0.585895], "sr" -> 
           RGBColor[0.325959, 0.646423, 0.095983], "y" -> 
           RGBColor[0.531014, 1., 1.], "zr" -> 
           RGBColor[0.458599, 0.917466, 0.918573], "nb" -> 
           RGBColor[0.385036, 0.834854, 0.841681], "mo" -> 
           RGBColor[0.310325, 0.752163, 0.769323], "tc" -> 
           RGBColor[0.234466, 0.669394, 0.701499], "ru" -> 
           RGBColor[0.157459, 0.586546, 0.638209], "rh" -> 
           RGBColor[0.0793033, 0.50362, 0.579453], "pd" -> 
           RGBColor[0., 0.420615, 0.525231], "ag" -> 
           RGBColor[0.752941, 0.752941, 0.752941], "cd" -> 
           RGBColor[1., 0.85098, 0.560784], "in" -> 
           RGBColor[0.728371, 0.440594, 0.422196], "sn" -> 
           RGBColor[0.39799, 0.491477, 0.495586], "sb" -> 
           RGBColor[0.619608, 0.388235, 0.709804], "te" -> 
           RGBColor[0.816706, 0.451332, 0.0100947], "i" -> 
           RGBColor[0.580392, 0, 0.580392], "xe" -> 
           RGBColor[0.316906, 0.638078, 0.710252], "cs" -> 
           RGBColor[0.332803, 0.217712, 0.483666], "ba" -> 
           RGBColor[0.165935, 0.55605, 0.0796556], "la" -> 
           RGBColor[0.928084, 0.716075, 0.329427], "ce" -> 
           RGBColor[0.894824, 0.731424, 0.325131], "pr" -> 
           RGBColor[0.86523, 0.707999, 0.315261], "nd" -> 
           RGBColor[0.837836, 0.662974, 0.301635], "pm" -> 
           RGBColor[0.811992, 0.607859, 0.285626], "sm" -> 
           RGBColor[0.787563, 0.549894, 0.268279], "eu" -> 
           RGBColor[0.764628, 0.493261, 0.250405], "gd" -> 
           RGBColor[0.743177, 0.440115, 0.23269], "tb" -> 
           RGBColor[0.72281, 0.39143, 0.215783], "dy" -> 
           RGBColor[0.702434, 0.347663, 0.200392], "ho" -> 
           RGBColor[0.679962, 0.309234, 0.187368], "er" -> 
           RGBColor[0.652012, 0.276823, 0.17779], "tm" -> 
           RGBColor[0.613603, 0.251489, 0.173042], "yb" -> 
           RGBColor[0.557855, 0.234598, 0.17489], "lu" -> 
           RGBColor[0.475685, 0.227573, 0.18555], "hf" -> 
           RGBColor[0.781537, 0.717388, 0.716579], "ta" -> 
           RGBColor[0.734443, 0.544489, 0.683471], "w" -> 
           RGBColor[0.681179, 0.360409, 0.63675], "re" -> 
           RGBColor[0.605181, 0.367584, 0.556343], "os" -> 
           RGBColor[0.521806, 0.382125, 0.469204], "ir" -> 
           RGBColor[0.445624, 0.373159, 0.399069], "pt" -> 
           RGBColor[0.815686, 0.815686, 0.878431], "au" -> 
           RGBColor[1., 0.819608, 0.137255], "hg" -> 
           RGBColor[0.721569, 0.721569, 0.815686], "tl" -> 
           RGBColor[0.65098, 0.329412, 0.301961], "pb" -> 
           RGBColor[0.341176, 0.34902, 0.380392], "bi" -> 
           RGBColor[0.619608, 0.309804, 0.709804], "po" -> 
           RGBColor[0.670588, 0.360784, 0], "at" -> 
           RGBColor[0.458824, 0.309804, 0.270588], "rn" -> 
           RGBColor[0.218799, 0.516091, 0.591608], "fr" -> 
           RGBColor[0.25626, 0.0861372, 0.398932], "ra" -> 
           RGBColor[0., 0.473472, 0.04654], "ac" -> 
           RGBColor[0.322042, 0.71693, 0.988479], "th" -> 
           RGBColor[0.3608, 0.67166, 0.943003], "pa" -> 
           RGBColor[0.397469, 0.628, 0.898853], "u" -> 
           RGBColor[0.43205, 0.58595, 0.856029], "np" -> 
           RGBColor[0.464542, 0.54551, 0.814532], "pu" -> 
           RGBColor[0.494945, 0.506679, 0.774361], "am" -> 
           RGBColor[0.52326, 0.469458, 0.735517], "cm" -> 
           RGBColor[0.549486, 0.433847, 0.697999], "bk" -> 
           RGBColor[0.573624, 0.399845, 0.661808], "cf" -> 
           RGBColor[0.595673, 0.367454, 0.626942], "es" -> 
           RGBColor[0.615633, 0.336672, 0.593404], "fm" -> 
           RGBColor[0.633505, 0.307499, 0.561191], "md" -> 
           RGBColor[0.649288, 0.279937, 0.530305], "no" -> 
           RGBColor[0.662982, 0.253984, 0.500746], "lr" -> 
           RGBColor[0.674588, 0.22964, 0.472513], "rf" -> 
           RGBColor[0.684106, 0.206907, 0.445606], "db" -> 
           RGBColor[0.691534, 0.185783, 0.420025], "sg" -> 
           RGBColor[0.696874, 0.166269, 0.395772], "bh" -> 
           RGBColor[0.700126, 0.148365, 0.372844], "hs" -> 
           RGBColor[0.701289, 0.13207, 0.351243], "mt" -> 
           RGBColor[0.700363, 0.117385, 0.330968], "ds" -> 
           RGBColor[0.697348, 0.10431, 0.31202], "rg" -> 
           RGBColor[0.692245, 0.0928444, 0.294398], "cn" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "nh" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "fl" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "mc" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "lv" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "ts" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "og" -> 
           RGBColor[0.635401, 0.0528, 0.226184], "uub" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "uut" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "uuq" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "uup" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "uuh" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "uus" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "uuo" -> 
           RGBColor[0.635401, 0.0528, 0.226184]}]]& ][0.85], 
       ColorDataFunction[
       "Atoms", 
        "Named", {{
         "H", "He", "Li", "Be", "B", "C", "N", "O", "F", "Ne", "Na", "Mg", 
          "Al", "Si", "P", "S", "Cl", "Ar", "K", "Ca", "Sc", "Ti", "V", "Cr", 
          "Mn", "Fe", "Co", "Ni", "Cu", "Zn", "Ga", "Ge", "As", "Se", "Br", 
          "Kr", "Rb", "Sr", "Y", "Zr", "Nb", "Mo", "Tc", "Ru", "Rh", "Pd", 
          "Ag", "Cd", "In", "Sn", "Sb", "Te", "I", "Xe", "Cs", "Ba", "La", 
          "Ce", "Pr", "Nd", "Pm", "Sm", "Eu", "Gd", "Tb", "Dy", "Ho", "Er", 
          "Tm", "Yb", "Lu", "Hf", "Ta", "W", "Re", "Os", "Ir", "Pt", "Au", 
          "Hg", "Tl", "Pb", "Bi", "Po", "At", "Rn", "Fr", "Ra", "Ac", "Th", 
          "Pa", "U", "Np", "Pu", "Am", "Cm", "Bk", "Cf", "Es", "Fm", "Md", 
          "No", "Lr", "Rf", "Db", "Sg", "Bh", "Hs", "Mt", "Ds", "Rg", "Cn", 
          "Nh", "Fl", "Mc", "Lv", "Ts", "Og", "Uub", "Uut", "Uuq", "Uup", 
          "Uuh", "Uus", "Uuo"}, {
         "h", "he", "li", "be", "b", "c", "n", "o", "f", "ne", "na", "mg", 
          "al", "si", "p", "s", "cl", "ar", "k", "ca", "sc", "ti", "v", "cr", 
          "mn", "fe", "co", "ni", "cu", "zn", "ga", "ge", "as", "se", "br", 
          "kr", "rb", "sr", "y", "zr", "nb", "mo", "tc", "ru", "rh", "pd", 
          "ag", "cd", "in", "sn", "sb", "te", "i", "xe", "cs", "ba", "la", 
          "ce", "pr", "nd", "pm", "sm", "eu", "gd", "tb", "dy", "ho", "er", 
          "tm", "yb", "lu", "hf", "ta", "w", "re", "os", "ir", "pt", "au", 
          "hg", "tl", "pb", "bi", "po", "at", "rn", "fr", "ra", "ac", "th", 
          "pa", "u", "np", "pu", "am", "cm", "bk", "cf", "es", "fm", "md", 
          "no", "lr", "rf", "db", "sg", "bh", "hs", "mt", "ds", "rg", "cn", 
          "nh", "fl", "mc", "lv", "ts", "og", "uub", "uut", "uuq", "uup", 
          "uuh", "uus", "uuo"}}, Replace[#, 
         Dispatch[{
          "h" -> RGBColor[0.65, 0.7, 0.7], "he" -> RGBColor[0.836713, 1., 1.],
            "li" -> RGBColor[0.799435, 0.543572, 0.997559], "be" -> 
           RGBColor[0.770565, 0.964309, 0.0442359], "b" -> 
           RGBColor[1., 0.709804, 0.709804], "c" -> RGBColor[0.4, 0.4, 0.4], 
           "n" -> RGBColor[0.291989, 0.437977, 0.888609], "o" -> 
           RGBColor[0.800498, 0.201504, 0.192061], "f" -> 
           RGBColor[0.578462, 0.85539, 0.408855], "ne" -> 
           RGBColor[0.677263, 0.928423, 0.955287], "na" -> 
           RGBColor[0.658708, 0.492173, 0.842842], "mg" -> 
           RGBColor[0.628274, 0.850553, 0.0782731], "al" -> 
           RGBColor[0.8913, 0.631904, 0.627399], "si" -> 
           RGBColor[0.941176, 0.784314, 0.627451], "p" -> 
           RGBColor[1., 0.501961, 0], "s" -> 
           RGBColor[0.90443, 0.97015, 0.13504], "cl" -> 
           RGBColor[0.412698, 0.932689, 0.166398], "ar" -> 
           RGBColor[0.546138, 0.844244, 0.892092], "k" -> 
           RGBColor[0.534026, 0.420729, 0.705621], "ca" -> 
           RGBColor[0.480072, 0.744591, 0.0955222], "sc" -> 
           RGBColor[0.901961, 0.901961, 0.901961], "ti" -> 
           RGBColor[0.74902, 0.760784, 0.780392], "v" -> 
           RGBColor[0.65098, 0.65098, 0.670588], "cr" -> 
           RGBColor[0.541176, 0.6, 0.780392], "mn" -> 
           RGBColor[0.611765, 0.478431, 0.780392], "fe" -> 
           RGBColor[0.878431, 0.4, 0.2], "co" -> 
           RGBColor[0.941176, 0.564706, 0.627451], "ni" -> 
           RGBColor[0.313725, 0.815686, 0.313725], "cu" -> 
           RGBColor[0.784314, 0.501961, 0.2], "zn" -> 
           RGBColor[0.490196, 0.501961, 0.690196], "ga" -> 
           RGBColor[0.800757, 0.542666, 0.533513], "ge" -> 
           RGBColor[0.60508, 0.632465, 0.576489], "as" -> 
           RGBColor[0.741176, 0.501961, 0.890196], "se" -> 
           RGBColor[0.917248, 0.657833, 0.0706628], "br" -> 
           RGBColor[0.58847, 0.22163, 0.16064], "kr" -> 
           RGBColor[0.426019, 0.747462, 0.810413], "rb" -> 
           RGBColor[0.425391, 0.329242, 0.585895], "sr" -> 
           RGBColor[0.325959, 0.646423, 0.095983], "y" -> 
           RGBColor[0.531014, 1., 1.], "zr" -> 
           RGBColor[0.458599, 0.917466, 0.918573], "nb" -> 
           RGBColor[0.385036, 0.834854, 0.841681], "mo" -> 
           RGBColor[0.310325, 0.752163, 0.769323], "tc" -> 
           RGBColor[0.234466, 0.669394, 0.701499], "ru" -> 
           RGBColor[0.157459, 0.586546, 0.638209], "rh" -> 
           RGBColor[0.0793033, 0.50362, 0.579453], "pd" -> 
           RGBColor[0., 0.420615, 0.525231], "ag" -> 
           RGBColor[0.752941, 0.752941, 0.752941], "cd" -> 
           RGBColor[1., 0.85098, 0.560784], "in" -> 
           RGBColor[0.728371, 0.440594, 0.422196], "sn" -> 
           RGBColor[0.39799, 0.491477, 0.495586], "sb" -> 
           RGBColor[0.619608, 0.388235, 0.709804], "te" -> 
           RGBColor[0.816706, 0.451332, 0.0100947], "i" -> 
           RGBColor[0.580392, 0, 0.580392], "xe" -> 
           RGBColor[0.316906, 0.638078, 0.710252], "cs" -> 
           RGBColor[0.332803, 0.217712, 0.483666], "ba" -> 
           RGBColor[0.165935, 0.55605, 0.0796556], "la" -> 
           RGBColor[0.928084, 0.716075, 0.329427], "ce" -> 
           RGBColor[0.894824, 0.731424, 0.325131], "pr" -> 
           RGBColor[0.86523, 0.707999, 0.315261], "nd" -> 
           RGBColor[0.837836, 0.662974, 0.301635], "pm" -> 
           RGBColor[0.811992, 0.607859, 0.285626], "sm" -> 
           RGBColor[0.787563, 0.549894, 0.268279], "eu" -> 
           RGBColor[0.764628, 0.493261, 0.250405], "gd" -> 
           RGBColor[0.743177, 0.440115, 0.23269], "tb" -> 
           RGBColor[0.72281, 0.39143, 0.215783], "dy" -> 
           RGBColor[0.702434, 0.347663, 0.200392], "ho" -> 
           RGBColor[0.679962, 0.309234, 0.187368], "er" -> 
           RGBColor[0.652012, 0.276823, 0.17779], "tm" -> 
           RGBColor[0.613603, 0.251489, 0.173042], "yb" -> 
           RGBColor[0.557855, 0.234598, 0.17489], "lu" -> 
           RGBColor[0.475685, 0.227573, 0.18555], "hf" -> 
           RGBColor[0.781537, 0.717388, 0.716579], "ta" -> 
           RGBColor[0.734443, 0.544489, 0.683471], "w" -> 
           RGBColor[0.681179, 0.360409, 0.63675], "re" -> 
           RGBColor[0.605181, 0.367584, 0.556343], "os" -> 
           RGBColor[0.521806, 0.382125, 0.469204], "ir" -> 
           RGBColor[0.445624, 0.373159, 0.399069], "pt" -> 
           RGBColor[0.815686, 0.815686, 0.878431], "au" -> 
           RGBColor[1., 0.819608, 0.137255], "hg" -> 
           RGBColor[0.721569, 0.721569, 0.815686], "tl" -> 
           RGBColor[0.65098, 0.329412, 0.301961], "pb" -> 
           RGBColor[0.341176, 0.34902, 0.380392], "bi" -> 
           RGBColor[0.619608, 0.309804, 0.709804], "po" -> 
           RGBColor[0.670588, 0.360784, 0], "at" -> 
           RGBColor[0.458824, 0.309804, 0.270588], "rn" -> 
           RGBColor[0.218799, 0.516091, 0.591608], "fr" -> 
           RGBColor[0.25626, 0.0861372, 0.398932], "ra" -> 
           RGBColor[0., 0.473472, 0.04654], "ac" -> 
           RGBColor[0.322042, 0.71693, 0.988479], "th" -> 
           RGBColor[0.3608, 0.67166, 0.943003], "pa" -> 
           RGBColor[0.397469, 0.628, 0.898853], "u" -> 
           RGBColor[0.43205, 0.58595, 0.856029], "np" -> 
           RGBColor[0.464542, 0.54551, 0.814532], "pu" -> 
           RGBColor[0.494945, 0.506679, 0.774361], "am" -> 
           RGBColor[0.52326, 0.469458, 0.735517], "cm" -> 
           RGBColor[0.549486, 0.433847, 0.697999], "bk" -> 
           RGBColor[0.573624, 0.399845, 0.661808], "cf" -> 
           RGBColor[0.595673, 0.367454, 0.626942], "es" -> 
           RGBColor[0.615633, 0.336672, 0.593404], "fm" -> 
           RGBColor[0.633505, 0.307499, 0.561191], "md" -> 
           RGBColor[0.649288, 0.279937, 0.530305], "no" -> 
           RGBColor[0.662982, 0.253984, 0.500746], "lr" -> 
           RGBColor[0.674588, 0.22964, 0.472513], "rf" -> 
           RGBColor[0.684106, 0.206907, 0.445606], "db" -> 
           RGBColor[0.691534, 0.185783, 0.420025], "sg" -> 
           RGBColor[0.696874, 0.166269, 0.395772], "bh" -> 
           RGBColor[0.700126, 0.148365, 0.372844], "hs" -> 
           RGBColor[0.701289, 0.13207, 0.351243], "mt" -> 
           RGBColor[0.700363, 0.117385, 0.330968], "ds" -> 
           RGBColor[0.697348, 0.10431, 0.31202], "rg" -> 
           RGBColor[0.692245, 0.0928444, 0.294398], "cn" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "nh" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "fl" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "mc" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "lv" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "ts" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "og" -> 
           RGBColor[0.635401, 0.0528, 0.226184], "uub" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "uut" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "uuq" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "uup" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "uuh" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "uus" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "uuo" -> 
           RGBColor[0.635401, 0.0528, 0.226184]}]]& ][0.85], 
       ColorDataFunction[
       "Atoms", 
        "Named", {{
         "H", "He", "Li", "Be", "B", "C", "N", "O", "F", "Ne", "Na", "Mg", 
          "Al", "Si", "P", "S", "Cl", "Ar", "K", "Ca", "Sc", "Ti", "V", "Cr", 
          "Mn", "Fe", "Co", "Ni", "Cu", "Zn", "Ga", "Ge", "As", "Se", "Br", 
          "Kr", "Rb", "Sr", "Y", "Zr", "Nb", "Mo", "Tc", "Ru", "Rh", "Pd", 
          "Ag", "Cd", "In", "Sn", "Sb", "Te", "I", "Xe", "Cs", "Ba", "La", 
          "Ce", "Pr", "Nd", "Pm", "Sm", "Eu", "Gd", "Tb", "Dy", "Ho", "Er", 
          "Tm", "Yb", "Lu", "Hf", "Ta", "W", "Re", "Os", "Ir", "Pt", "Au", 
          "Hg", "Tl", "Pb", "Bi", "Po", "At", "Rn", "Fr", "Ra", "Ac", "Th", 
          "Pa", "U", "Np", "Pu", "Am", "Cm", "Bk", "Cf", "Es", "Fm", "Md", 
          "No", "Lr", "Rf", "Db", "Sg", "Bh", "Hs", "Mt", "Ds", "Rg", "Cn", 
          "Nh", "Fl", "Mc", "Lv", "Ts", "Og", "Uub", "Uut", "Uuq", "Uup", 
          "Uuh", "Uus", "Uuo"}, {
         "h", "he", "li", "be", "b", "c", "n", "o", "f", "ne", "na", "mg", 
          "al", "si", "p", "s", "cl", "ar", "k", "ca", "sc", "ti", "v", "cr", 
          "mn", "fe", "co", "ni", "cu", "zn", "ga", "ge", "as", "se", "br", 
          "kr", "rb", "sr", "y", "zr", "nb", "mo", "tc", "ru", "rh", "pd", 
          "ag", "cd", "in", "sn", "sb", "te", "i", "xe", "cs", "ba", "la", 
          "ce", "pr", "nd", "pm", "sm", "eu", "gd", "tb", "dy", "ho", "er", 
          "tm", "yb", "lu", "hf", "ta", "w", "re", "os", "ir", "pt", "au", 
          "hg", "tl", "pb", "bi", "po", "at", "rn", "fr", "ra", "ac", "th", 
          "pa", "u", "np", "pu", "am", "cm", "bk", "cf", "es", "fm", "md", 
          "no", "lr", "rf", "db", "sg", "bh", "hs", "mt", "ds", "rg", "cn", 
          "nh", "fl", "mc", "lv", "ts", "og", "uub", "uut", "uuq", "uup", 
          "uuh", "uus", "uuo"}}, Replace[#, 
         Dispatch[{
          "h" -> RGBColor[0.65, 0.7, 0.7], "he" -> RGBColor[0.836713, 1., 1.],
            "li" -> RGBColor[0.799435, 0.543572, 0.997559], "be" -> 
           RGBColor[0.770565, 0.964309, 0.0442359], "b" -> 
           RGBColor[1., 0.709804, 0.709804], "c" -> RGBColor[0.4, 0.4, 0.4], 
           "n" -> RGBColor[0.291989, 0.437977, 0.888609], "o" -> 
           RGBColor[0.800498, 0.201504, 0.192061], "f" -> 
           RGBColor[0.578462, 0.85539, 0.408855], "ne" -> 
           RGBColor[0.677263, 0.928423, 0.955287], "na" -> 
           RGBColor[0.658708, 0.492173, 0.842842], "mg" -> 
           RGBColor[0.628274, 0.850553, 0.0782731], "al" -> 
           RGBColor[0.8913, 0.631904, 0.627399], "si" -> 
           RGBColor[0.941176, 0.784314, 0.627451], "p" -> 
           RGBColor[1., 0.501961, 0], "s" -> 
           RGBColor[0.90443, 0.97015, 0.13504], "cl" -> 
           RGBColor[0.412698, 0.932689, 0.166398], "ar" -> 
           RGBColor[0.546138, 0.844244, 0.892092], "k" -> 
           RGBColor[0.534026, 0.420729, 0.705621], "ca" -> 
           RGBColor[0.480072, 0.744591, 0.0955222], "sc" -> 
           RGBColor[0.901961, 0.901961, 0.901961], "ti" -> 
           RGBColor[0.74902, 0.760784, 0.780392], "v" -> 
           RGBColor[0.65098, 0.65098, 0.670588], "cr" -> 
           RGBColor[0.541176, 0.6, 0.780392], "mn" -> 
           RGBColor[0.611765, 0.478431, 0.780392], "fe" -> 
           RGBColor[0.878431, 0.4, 0.2], "co" -> 
           RGBColor[0.941176, 0.564706, 0.627451], "ni" -> 
           RGBColor[0.313725, 0.815686, 0.313725], "cu" -> 
           RGBColor[0.784314, 0.501961, 0.2], "zn" -> 
           RGBColor[0.490196, 0.501961, 0.690196], "ga" -> 
           RGBColor[0.800757, 0.542666, 0.533513], "ge" -> 
           RGBColor[0.60508, 0.632465, 0.576489], "as" -> 
           RGBColor[0.741176, 0.501961, 0.890196], "se" -> 
           RGBColor[0.917248, 0.657833, 0.0706628], "br" -> 
           RGBColor[0.58847, 0.22163, 0.16064], "kr" -> 
           RGBColor[0.426019, 0.747462, 0.810413], "rb" -> 
           RGBColor[0.425391, 0.329242, 0.585895], "sr" -> 
           RGBColor[0.325959, 0.646423, 0.095983], "y" -> 
           RGBColor[0.531014, 1., 1.], "zr" -> 
           RGBColor[0.458599, 0.917466, 0.918573], "nb" -> 
           RGBColor[0.385036, 0.834854, 0.841681], "mo" -> 
           RGBColor[0.310325, 0.752163, 0.769323], "tc" -> 
           RGBColor[0.234466, 0.669394, 0.701499], "ru" -> 
           RGBColor[0.157459, 0.586546, 0.638209], "rh" -> 
           RGBColor[0.0793033, 0.50362, 0.579453], "pd" -> 
           RGBColor[0., 0.420615, 0.525231], "ag" -> 
           RGBColor[0.752941, 0.752941, 0.752941], "cd" -> 
           RGBColor[1., 0.85098, 0.560784], "in" -> 
           RGBColor[0.728371, 0.440594, 0.422196], "sn" -> 
           RGBColor[0.39799, 0.491477, 0.495586], "sb" -> 
           RGBColor[0.619608, 0.388235, 0.709804], "te" -> 
           RGBColor[0.816706, 0.451332, 0.0100947], "i" -> 
           RGBColor[0.580392, 0, 0.580392], "xe" -> 
           RGBColor[0.316906, 0.638078, 0.710252], "cs" -> 
           RGBColor[0.332803, 0.217712, 0.483666], "ba" -> 
           RGBColor[0.165935, 0.55605, 0.0796556], "la" -> 
           RGBColor[0.928084, 0.716075, 0.329427], "ce" -> 
           RGBColor[0.894824, 0.731424, 0.325131], "pr" -> 
           RGBColor[0.86523, 0.707999, 0.315261], "nd" -> 
           RGBColor[0.837836, 0.662974, 0.301635], "pm" -> 
           RGBColor[0.811992, 0.607859, 0.285626], "sm" -> 
           RGBColor[0.787563, 0.549894, 0.268279], "eu" -> 
           RGBColor[0.764628, 0.493261, 0.250405], "gd" -> 
           RGBColor[0.743177, 0.440115, 0.23269], "tb" -> 
           RGBColor[0.72281, 0.39143, 0.215783], "dy" -> 
           RGBColor[0.702434, 0.347663, 0.200392], "ho" -> 
           RGBColor[0.679962, 0.309234, 0.187368], "er" -> 
           RGBColor[0.652012, 0.276823, 0.17779], "tm" -> 
           RGBColor[0.613603, 0.251489, 0.173042], "yb" -> 
           RGBColor[0.557855, 0.234598, 0.17489], "lu" -> 
           RGBColor[0.475685, 0.227573, 0.18555], "hf" -> 
           RGBColor[0.781537, 0.717388, 0.716579], "ta" -> 
           RGBColor[0.734443, 0.544489, 0.683471], "w" -> 
           RGBColor[0.681179, 0.360409, 0.63675], "re" -> 
           RGBColor[0.605181, 0.367584, 0.556343], "os" -> 
           RGBColor[0.521806, 0.382125, 0.469204], "ir" -> 
           RGBColor[0.445624, 0.373159, 0.399069], "pt" -> 
           RGBColor[0.815686, 0.815686, 0.878431], "au" -> 
           RGBColor[1., 0.819608, 0.137255], "hg" -> 
           RGBColor[0.721569, 0.721569, 0.815686], "tl" -> 
           RGBColor[0.65098, 0.329412, 0.301961], "pb" -> 
           RGBColor[0.341176, 0.34902, 0.380392], "bi" -> 
           RGBColor[0.619608, 0.309804, 0.709804], "po" -> 
           RGBColor[0.670588, 0.360784, 0], "at" -> 
           RGBColor[0.458824, 0.309804, 0.270588], "rn" -> 
           RGBColor[0.218799, 0.516091, 0.591608], "fr" -> 
           RGBColor[0.25626, 0.0861372, 0.398932], "ra" -> 
           RGBColor[0., 0.473472, 0.04654], "ac" -> 
           RGBColor[0.322042, 0.71693, 0.988479], "th" -> 
           RGBColor[0.3608, 0.67166, 0.943003], "pa" -> 
           RGBColor[0.397469, 0.628, 0.898853], "u" -> 
           RGBColor[0.43205, 0.58595, 0.856029], "np" -> 
           RGBColor[0.464542, 0.54551, 0.814532], "pu" -> 
           RGBColor[0.494945, 0.506679, 0.774361], "am" -> 
           RGBColor[0.52326, 0.469458, 0.735517], "cm" -> 
           RGBColor[0.549486, 0.433847, 0.697999], "bk" -> 
           RGBColor[0.573624, 0.399845, 0.661808], "cf" -> 
           RGBColor[0.595673, 0.367454, 0.626942], "es" -> 
           RGBColor[0.615633, 0.336672, 0.593404], "fm" -> 
           RGBColor[0.633505, 0.307499, 0.561191], "md" -> 
           RGBColor[0.649288, 0.279937, 0.530305], "no" -> 
           RGBColor[0.662982, 0.253984, 0.500746], "lr" -> 
           RGBColor[0.674588, 0.22964, 0.472513], "rf" -> 
           RGBColor[0.684106, 0.206907, 0.445606], "db" -> 
           RGBColor[0.691534, 0.185783, 0.420025], "sg" -> 
           RGBColor[0.696874, 0.166269, 0.395772], "bh" -> 
           RGBColor[0.700126, 0.148365, 0.372844], "hs" -> 
           RGBColor[0.701289, 0.13207, 0.351243], "mt" -> 
           RGBColor[0.700363, 0.117385, 0.330968], "ds" -> 
           RGBColor[0.697348, 0.10431, 0.31202], "rg" -> 
           RGBColor[0.692245, 0.0928444, 0.294398], "cn" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "nh" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "fl" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "mc" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "lv" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "ts" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "og" -> 
           RGBColor[0.635401, 0.0528, 0.226184], "uub" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "uut" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "uuq" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "uup" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "uuh" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "uus" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "uuo" -> 
           RGBColor[0.635401, 0.0528, 0.226184]}]]& ][0.85], 
       ColorDataFunction[
       "Atoms", 
        "Named", {{
         "H", "He", "Li", "Be", "B", "C", "N", "O", "F", "Ne", "Na", "Mg", 
          "Al", "Si", "P", "S", "Cl", "Ar", "K", "Ca", "Sc", "Ti", "V", "Cr", 
          "Mn", "Fe", "Co", "Ni", "Cu", "Zn", "Ga", "Ge", "As", "Se", "Br", 
          "Kr", "Rb", "Sr", "Y", "Zr", "Nb", "Mo", "Tc", "Ru", "Rh", "Pd", 
          "Ag", "Cd", "In", "Sn", "Sb", "Te", "I", "Xe", "Cs", "Ba", "La", 
          "Ce", "Pr", "Nd", "Pm", "Sm", "Eu", "Gd", "Tb", "Dy", "Ho", "Er", 
          "Tm", "Yb", "Lu", "Hf", "Ta", "W", "Re", "Os", "Ir", "Pt", "Au", 
          "Hg", "Tl", "Pb", "Bi", "Po", "At", "Rn", "Fr", "Ra", "Ac", "Th", 
          "Pa", "U", "Np", "Pu", "Am", "Cm", "Bk", "Cf", "Es", "Fm", "Md", 
          "No", "Lr", "Rf", "Db", "Sg", "Bh", "Hs", "Mt", "Ds", "Rg", "Cn", 
          "Nh", "Fl", "Mc", "Lv", "Ts", "Og", "Uub", "Uut", "Uuq", "Uup", 
          "Uuh", "Uus", "Uuo"}, {
         "h", "he", "li", "be", "b", "c", "n", "o", "f", "ne", "na", "mg", 
          "al", "si", "p", "s", "cl", "ar", "k", "ca", "sc", "ti", "v", "cr", 
          "mn", "fe", "co", "ni", "cu", "zn", "ga", "ge", "as", "se", "br", 
          "kr", "rb", "sr", "y", "zr", "nb", "mo", "tc", "ru", "rh", "pd", 
          "ag", "cd", "in", "sn", "sb", "te", "i", "xe", "cs", "ba", "la", 
          "ce", "pr", "nd", "pm", "sm", "eu", "gd", "tb", "dy", "ho", "er", 
          "tm", "yb", "lu", "hf", "ta", "w", "re", "os", "ir", "pt", "au", 
          "hg", "tl", "pb", "bi", "po", "at", "rn", "fr", "ra", "ac", "th", 
          "pa", "u", "np", "pu", "am", "cm", "bk", "cf", "es", "fm", "md", 
          "no", "lr", "rf", "db", "sg", "bh", "hs", "mt", "ds", "rg", "cn", 
          "nh", "fl", "mc", "lv", "ts", "og", "uub", "uut", "uuq", "uup", 
          "uuh", "uus", "uuo"}}, Replace[#, 
         Dispatch[{
          "h" -> RGBColor[0.65, 0.7, 0.7], "he" -> RGBColor[0.836713, 1., 1.],
            "li" -> RGBColor[0.799435, 0.543572, 0.997559], "be" -> 
           RGBColor[0.770565, 0.964309, 0.0442359], "b" -> 
           RGBColor[1., 0.709804, 0.709804], "c" -> RGBColor[0.4, 0.4, 0.4], 
           "n" -> RGBColor[0.291989, 0.437977, 0.888609], "o" -> 
           RGBColor[0.800498, 0.201504, 0.192061], "f" -> 
           RGBColor[0.578462, 0.85539, 0.408855], "ne" -> 
           RGBColor[0.677263, 0.928423, 0.955287], "na" -> 
           RGBColor[0.658708, 0.492173, 0.842842], "mg" -> 
           RGBColor[0.628274, 0.850553, 0.0782731], "al" -> 
           RGBColor[0.8913, 0.631904, 0.627399], "si" -> 
           RGBColor[0.941176, 0.784314, 0.627451], "p" -> 
           RGBColor[1., 0.501961, 0], "s" -> 
           RGBColor[0.90443, 0.97015, 0.13504], "cl" -> 
           RGBColor[0.412698, 0.932689, 0.166398], "ar" -> 
           RGBColor[0.546138, 0.844244, 0.892092], "k" -> 
           RGBColor[0.534026, 0.420729, 0.705621], "ca" -> 
           RGBColor[0.480072, 0.744591, 0.0955222], "sc" -> 
           RGBColor[0.901961, 0.901961, 0.901961], "ti" -> 
           RGBColor[0.74902, 0.760784, 0.780392], "v" -> 
           RGBColor[0.65098, 0.65098, 0.670588], "cr" -> 
           RGBColor[0.541176, 0.6, 0.780392], "mn" -> 
           RGBColor[0.611765, 0.478431, 0.780392], "fe" -> 
           RGBColor[0.878431, 0.4, 0.2], "co" -> 
           RGBColor[0.941176, 0.564706, 0.627451], "ni" -> 
           RGBColor[0.313725, 0.815686, 0.313725], "cu" -> 
           RGBColor[0.784314, 0.501961, 0.2], "zn" -> 
           RGBColor[0.490196, 0.501961, 0.690196], "ga" -> 
           RGBColor[0.800757, 0.542666, 0.533513], "ge" -> 
           RGBColor[0.60508, 0.632465, 0.576489], "as" -> 
           RGBColor[0.741176, 0.501961, 0.890196], "se" -> 
           RGBColor[0.917248, 0.657833, 0.0706628], "br" -> 
           RGBColor[0.58847, 0.22163, 0.16064], "kr" -> 
           RGBColor[0.426019, 0.747462, 0.810413], "rb" -> 
           RGBColor[0.425391, 0.329242, 0.585895], "sr" -> 
           RGBColor[0.325959, 0.646423, 0.095983], "y" -> 
           RGBColor[0.531014, 1., 1.], "zr" -> 
           RGBColor[0.458599, 0.917466, 0.918573], "nb" -> 
           RGBColor[0.385036, 0.834854, 0.841681], "mo" -> 
           RGBColor[0.310325, 0.752163, 0.769323], "tc" -> 
           RGBColor[0.234466, 0.669394, 0.701499], "ru" -> 
           RGBColor[0.157459, 0.586546, 0.638209], "rh" -> 
           RGBColor[0.0793033, 0.50362, 0.579453], "pd" -> 
           RGBColor[0., 0.420615, 0.525231], "ag" -> 
           RGBColor[0.752941, 0.752941, 0.752941], "cd" -> 
           RGBColor[1., 0.85098, 0.560784], "in" -> 
           RGBColor[0.728371, 0.440594, 0.422196], "sn" -> 
           RGBColor[0.39799, 0.491477, 0.495586], "sb" -> 
           RGBColor[0.619608, 0.388235, 0.709804], "te" -> 
           RGBColor[0.816706, 0.451332, 0.0100947], "i" -> 
           RGBColor[0.580392, 0, 0.580392], "xe" -> 
           RGBColor[0.316906, 0.638078, 0.710252], "cs" -> 
           RGBColor[0.332803, 0.217712, 0.483666], "ba" -> 
           RGBColor[0.165935, 0.55605, 0.0796556], "la" -> 
           RGBColor[0.928084, 0.716075, 0.329427], "ce" -> 
           RGBColor[0.894824, 0.731424, 0.325131], "pr" -> 
           RGBColor[0.86523, 0.707999, 0.315261], "nd" -> 
           RGBColor[0.837836, 0.662974, 0.301635], "pm" -> 
           RGBColor[0.811992, 0.607859, 0.285626], "sm" -> 
           RGBColor[0.787563, 0.549894, 0.268279], "eu" -> 
           RGBColor[0.764628, 0.493261, 0.250405], "gd" -> 
           RGBColor[0.743177, 0.440115, 0.23269], "tb" -> 
           RGBColor[0.72281, 0.39143, 0.215783], "dy" -> 
           RGBColor[0.702434, 0.347663, 0.200392], "ho" -> 
           RGBColor[0.679962, 0.309234, 0.187368], "er" -> 
           RGBColor[0.652012, 0.276823, 0.17779], "tm" -> 
           RGBColor[0.613603, 0.251489, 0.173042], "yb" -> 
           RGBColor[0.557855, 0.234598, 0.17489], "lu" -> 
           RGBColor[0.475685, 0.227573, 0.18555], "hf" -> 
           RGBColor[0.781537, 0.717388, 0.716579], "ta" -> 
           RGBColor[0.734443, 0.544489, 0.683471], "w" -> 
           RGBColor[0.681179, 0.360409, 0.63675], "re" -> 
           RGBColor[0.605181, 0.367584, 0.556343], "os" -> 
           RGBColor[0.521806, 0.382125, 0.469204], "ir" -> 
           RGBColor[0.445624, 0.373159, 0.399069], "pt" -> 
           RGBColor[0.815686, 0.815686, 0.878431], "au" -> 
           RGBColor[1., 0.819608, 0.137255], "hg" -> 
           RGBColor[0.721569, 0.721569, 0.815686], "tl" -> 
           RGBColor[0.65098, 0.329412, 0.301961], "pb" -> 
           RGBColor[0.341176, 0.34902, 0.380392], "bi" -> 
           RGBColor[0.619608, 0.309804, 0.709804], "po" -> 
           RGBColor[0.670588, 0.360784, 0], "at" -> 
           RGBColor[0.458824, 0.309804, 0.270588], "rn" -> 
           RGBColor[0.218799, 0.516091, 0.591608], "fr" -> 
           RGBColor[0.25626, 0.0861372, 0.398932], "ra" -> 
           RGBColor[0., 0.473472, 0.04654], "ac" -> 
           RGBColor[0.322042, 0.71693, 0.988479], "th" -> 
           RGBColor[0.3608, 0.67166, 0.943003], "pa" -> 
           RGBColor[0.397469, 0.628, 0.898853], "u" -> 
           RGBColor[0.43205, 0.58595, 0.856029], "np" -> 
           RGBColor[0.464542, 0.54551, 0.814532], "pu" -> 
           RGBColor[0.494945, 0.506679, 0.774361], "am" -> 
           RGBColor[0.52326, 0.469458, 0.735517], "cm" -> 
           RGBColor[0.549486, 0.433847, 0.697999], "bk" -> 
           RGBColor[0.573624, 0.399845, 0.661808], "cf" -> 
           RGBColor[0.595673, 0.367454, 0.626942], "es" -> 
           RGBColor[0.615633, 0.336672, 0.593404], "fm" -> 
           RGBColor[0.633505, 0.307499, 0.561191], "md" -> 
           RGBColor[0.649288, 0.279937, 0.530305], "no" -> 
           RGBColor[0.662982, 0.253984, 0.500746], "lr" -> 
           RGBColor[0.674588, 0.22964, 0.472513], "rf" -> 
           RGBColor[0.684106, 0.206907, 0.445606], "db" -> 
           RGBColor[0.691534, 0.185783, 0.420025], "sg" -> 
           RGBColor[0.696874, 0.166269, 0.395772], "bh" -> 
           RGBColor[0.700126, 0.148365, 0.372844], "hs" -> 
           RGBColor[0.701289, 0.13207, 0.351243], "mt" -> 
           RGBColor[0.700363, 0.117385, 0.330968], "ds" -> 
           RGBColor[0.697348, 0.10431, 0.31202], "rg" -> 
           RGBColor[0.692245, 0.0928444, 0.294398], "cn" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "nh" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "fl" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "mc" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "lv" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "ts" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "og" -> 
           RGBColor[0.635401, 0.0528, 0.226184], "uub" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "uut" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "uuq" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "uup" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "uuh" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "uus" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "uuo" -> 
           RGBColor[0.635401, 0.0528, 0.226184]}]]& ][0.85], 
       ColorDataFunction[
       "Atoms", 
        "Named", {{
         "H", "He", "Li", "Be", "B", "C", "N", "O", "F", "Ne", "Na", "Mg", 
          "Al", "Si", "P", "S", "Cl", "Ar", "K", "Ca", "Sc", "Ti", "V", "Cr", 
          "Mn", "Fe", "Co", "Ni", "Cu", "Zn", "Ga", "Ge", "As", "Se", "Br", 
          "Kr", "Rb", "Sr", "Y", "Zr", "Nb", "Mo", "Tc", "Ru", "Rh", "Pd", 
          "Ag", "Cd", "In", "Sn", "Sb", "Te", "I", "Xe", "Cs", "Ba", "La", 
          "Ce", "Pr", "Nd", "Pm", "Sm", "Eu", "Gd", "Tb", "Dy", "Ho", "Er", 
          "Tm", "Yb", "Lu", "Hf", "Ta", "W", "Re", "Os", "Ir", "Pt", "Au", 
          "Hg", "Tl", "Pb", "Bi", "Po", "At", "Rn", "Fr", "Ra", "Ac", "Th", 
          "Pa", "U", "Np", "Pu", "Am", "Cm", "Bk", "Cf", "Es", "Fm", "Md", 
          "No", "Lr", "Rf", "Db", "Sg", "Bh", "Hs", "Mt", "Ds", "Rg", "Cn", 
          "Nh", "Fl", "Mc", "Lv", "Ts", "Og", "Uub", "Uut", "Uuq", "Uup", 
          "Uuh", "Uus", "Uuo"}, {
         "h", "he", "li", "be", "b", "c", "n", "o", "f", "ne", "na", "mg", 
          "al", "si", "p", "s", "cl", "ar", "k", "ca", "sc", "ti", "v", "cr", 
          "mn", "fe", "co", "ni", "cu", "zn", "ga", "ge", "as", "se", "br", 
          "kr", "rb", "sr", "y", "zr", "nb", "mo", "tc", "ru", "rh", "pd", 
          "ag", "cd", "in", "sn", "sb", "te", "i", "xe", "cs", "ba", "la", 
          "ce", "pr", "nd", "pm", "sm", "eu", "gd", "tb", "dy", "ho", "er", 
          "tm", "yb", "lu", "hf", "ta", "w", "re", "os", "ir", "pt", "au", 
          "hg", "tl", "pb", "bi", "po", "at", "rn", "fr", "ra", "ac", "th", 
          "pa", "u", "np", "pu", "am", "cm", "bk", "cf", "es", "fm", "md", 
          "no", "lr", "rf", "db", "sg", "bh", "hs", "mt", "ds", "rg", "cn", 
          "nh", "fl", "mc", "lv", "ts", "og", "uub", "uut", "uuq", "uup", 
          "uuh", "uus", "uuo"}}, Replace[#, 
         Dispatch[{
          "h" -> RGBColor[0.65, 0.7, 0.7], "he" -> RGBColor[0.836713, 1., 1.],
            "li" -> RGBColor[0.799435, 0.543572, 0.997559], "be" -> 
           RGBColor[0.770565, 0.964309, 0.0442359], "b" -> 
           RGBColor[1., 0.709804, 0.709804], "c" -> RGBColor[0.4, 0.4, 0.4], 
           "n" -> RGBColor[0.291989, 0.437977, 0.888609], "o" -> 
           RGBColor[0.800498, 0.201504, 0.192061], "f" -> 
           RGBColor[0.578462, 0.85539, 0.408855], "ne" -> 
           RGBColor[0.677263, 0.928423, 0.955287], "na" -> 
           RGBColor[0.658708, 0.492173, 0.842842], "mg" -> 
           RGBColor[0.628274, 0.850553, 0.0782731], "al" -> 
           RGBColor[0.8913, 0.631904, 0.627399], "si" -> 
           RGBColor[0.941176, 0.784314, 0.627451], "p" -> 
           RGBColor[1., 0.501961, 0], "s" -> 
           RGBColor[0.90443, 0.97015, 0.13504], "cl" -> 
           RGBColor[0.412698, 0.932689, 0.166398], "ar" -> 
           RGBColor[0.546138, 0.844244, 0.892092], "k" -> 
           RGBColor[0.534026, 0.420729, 0.705621], "ca" -> 
           RGBColor[0.480072, 0.744591, 0.0955222], "sc" -> 
           RGBColor[0.901961, 0.901961, 0.901961], "ti" -> 
           RGBColor[0.74902, 0.760784, 0.780392], "v" -> 
           RGBColor[0.65098, 0.65098, 0.670588], "cr" -> 
           RGBColor[0.541176, 0.6, 0.780392], "mn" -> 
           RGBColor[0.611765, 0.478431, 0.780392], "fe" -> 
           RGBColor[0.878431, 0.4, 0.2], "co" -> 
           RGBColor[0.941176, 0.564706, 0.627451], "ni" -> 
           RGBColor[0.313725, 0.815686, 0.313725], "cu" -> 
           RGBColor[0.784314, 0.501961, 0.2], "zn" -> 
           RGBColor[0.490196, 0.501961, 0.690196], "ga" -> 
           RGBColor[0.800757, 0.542666, 0.533513], "ge" -> 
           RGBColor[0.60508, 0.632465, 0.576489], "as" -> 
           RGBColor[0.741176, 0.501961, 0.890196], "se" -> 
           RGBColor[0.917248, 0.657833, 0.0706628], "br" -> 
           RGBColor[0.58847, 0.22163, 0.16064], "kr" -> 
           RGBColor[0.426019, 0.747462, 0.810413], "rb" -> 
           RGBColor[0.425391, 0.329242, 0.585895], "sr" -> 
           RGBColor[0.325959, 0.646423, 0.095983], "y" -> 
           RGBColor[0.531014, 1., 1.], "zr" -> 
           RGBColor[0.458599, 0.917466, 0.918573], "nb" -> 
           RGBColor[0.385036, 0.834854, 0.841681], "mo" -> 
           RGBColor[0.310325, 0.752163, 0.769323], "tc" -> 
           RGBColor[0.234466, 0.669394, 0.701499], "ru" -> 
           RGBColor[0.157459, 0.586546, 0.638209], "rh" -> 
           RGBColor[0.0793033, 0.50362, 0.579453], "pd" -> 
           RGBColor[0., 0.420615, 0.525231], "ag" -> 
           RGBColor[0.752941, 0.752941, 0.752941], "cd" -> 
           RGBColor[1., 0.85098, 0.560784], "in" -> 
           RGBColor[0.728371, 0.440594, 0.422196], "sn" -> 
           RGBColor[0.39799, 0.491477, 0.495586], "sb" -> 
           RGBColor[0.619608, 0.388235, 0.709804], "te" -> 
           RGBColor[0.816706, 0.451332, 0.0100947], "i" -> 
           RGBColor[0.580392, 0, 0.580392], "xe" -> 
           RGBColor[0.316906, 0.638078, 0.710252], "cs" -> 
           RGBColor[0.332803, 0.217712, 0.483666], "ba" -> 
           RGBColor[0.165935, 0.55605, 0.0796556], "la" -> 
           RGBColor[0.928084, 0.716075, 0.329427], "ce" -> 
           RGBColor[0.894824, 0.731424, 0.325131], "pr" -> 
           RGBColor[0.86523, 0.707999, 0.315261], "nd" -> 
           RGBColor[0.837836, 0.662974, 0.301635], "pm" -> 
           RGBColor[0.811992, 0.607859, 0.285626], "sm" -> 
           RGBColor[0.787563, 0.549894, 0.268279], "eu" -> 
           RGBColor[0.764628, 0.493261, 0.250405], "gd" -> 
           RGBColor[0.743177, 0.440115, 0.23269], "tb" -> 
           RGBColor[0.72281, 0.39143, 0.215783], "dy" -> 
           RGBColor[0.702434, 0.347663, 0.200392], "ho" -> 
           RGBColor[0.679962, 0.309234, 0.187368], "er" -> 
           RGBColor[0.652012, 0.276823, 0.17779], "tm" -> 
           RGBColor[0.613603, 0.251489, 0.173042], "yb" -> 
           RGBColor[0.557855, 0.234598, 0.17489], "lu" -> 
           RGBColor[0.475685, 0.227573, 0.18555], "hf" -> 
           RGBColor[0.781537, 0.717388, 0.716579], "ta" -> 
           RGBColor[0.734443, 0.544489, 0.683471], "w" -> 
           RGBColor[0.681179, 0.360409, 0.63675], "re" -> 
           RGBColor[0.605181, 0.367584, 0.556343], "os" -> 
           RGBColor[0.521806, 0.382125, 0.469204], "ir" -> 
           RGBColor[0.445624, 0.373159, 0.399069], "pt" -> 
           RGBColor[0.815686, 0.815686, 0.878431], "au" -> 
           RGBColor[1., 0.819608, 0.137255], "hg" -> 
           RGBColor[0.721569, 0.721569, 0.815686], "tl" -> 
           RGBColor[0.65098, 0.329412, 0.301961], "pb" -> 
           RGBColor[0.341176, 0.34902, 0.380392], "bi" -> 
           RGBColor[0.619608, 0.309804, 0.709804], "po" -> 
           RGBColor[0.670588, 0.360784, 0], "at" -> 
           RGBColor[0.458824, 0.309804, 0.270588], "rn" -> 
           RGBColor[0.218799, 0.516091, 0.591608], "fr" -> 
           RGBColor[0.25626, 0.0861372, 0.398932], "ra" -> 
           RGBColor[0., 0.473472, 0.04654], "ac" -> 
           RGBColor[0.322042, 0.71693, 0.988479], "th" -> 
           RGBColor[0.3608, 0.67166, 0.943003], "pa" -> 
           RGBColor[0.397469, 0.628, 0.898853], "u" -> 
           RGBColor[0.43205, 0.58595, 0.856029], "np" -> 
           RGBColor[0.464542, 0.54551, 0.814532], "pu" -> 
           RGBColor[0.494945, 0.506679, 0.774361], "am" -> 
           RGBColor[0.52326, 0.469458, 0.735517], "cm" -> 
           RGBColor[0.549486, 0.433847, 0.697999], "bk" -> 
           RGBColor[0.573624, 0.399845, 0.661808], "cf" -> 
           RGBColor[0.595673, 0.367454, 0.626942], "es" -> 
           RGBColor[0.615633, 0.336672, 0.593404], "fm" -> 
           RGBColor[0.633505, 0.307499, 0.561191], "md" -> 
           RGBColor[0.649288, 0.279937, 0.530305], "no" -> 
           RGBColor[0.662982, 0.253984, 0.500746], "lr" -> 
           RGBColor[0.674588, 0.22964, 0.472513], "rf" -> 
           RGBColor[0.684106, 0.206907, 0.445606], "db" -> 
           RGBColor[0.691534, 0.185783, 0.420025], "sg" -> 
           RGBColor[0.696874, 0.166269, 0.395772], "bh" -> 
           RGBColor[0.700126, 0.148365, 0.372844], "hs" -> 
           RGBColor[0.701289, 0.13207, 0.351243], "mt" -> 
           RGBColor[0.700363, 0.117385, 0.330968], "ds" -> 
           RGBColor[0.697348, 0.10431, 0.31202], "rg" -> 
           RGBColor[0.692245, 0.0928444, 0.294398], "cn" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "nh" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "fl" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "mc" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "lv" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "ts" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "og" -> 
           RGBColor[0.635401, 0.0528, 0.226184], "uub" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "uut" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "uuq" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "uup" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "uuh" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "uus" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "uuo" -> 
           RGBColor[0.635401, 0.0528, 0.226184]}]]& ][0.85], 
       ColorDataFunction[
       "Atoms", 
        "Named", {{
         "H", "He", "Li", "Be", "B", "C", "N", "O", "F", "Ne", "Na", "Mg", 
          "Al", "Si", "P", "S", "Cl", "Ar", "K", "Ca", "Sc", "Ti", "V", "Cr", 
          "Mn", "Fe", "Co", "Ni", "Cu", "Zn", "Ga", "Ge", "As", "Se", "Br", 
          "Kr", "Rb", "Sr", "Y", "Zr", "Nb", "Mo", "Tc", "Ru", "Rh", "Pd", 
          "Ag", "Cd", "In", "Sn", "Sb", "Te", "I", "Xe", "Cs", "Ba", "La", 
          "Ce", "Pr", "Nd", "Pm", "Sm", "Eu", "Gd", "Tb", "Dy", "Ho", "Er", 
          "Tm", "Yb", "Lu", "Hf", "Ta", "W", "Re", "Os", "Ir", "Pt", "Au", 
          "Hg", "Tl", "Pb", "Bi", "Po", "At", "Rn", "Fr", "Ra", "Ac", "Th", 
          "Pa", "U", "Np", "Pu", "Am", "Cm", "Bk", "Cf", "Es", "Fm", "Md", 
          "No", "Lr", "Rf", "Db", "Sg", "Bh", "Hs", "Mt", "Ds", "Rg", "Cn", 
          "Nh", "Fl", "Mc", "Lv", "Ts", "Og", "Uub", "Uut", "Uuq", "Uup", 
          "Uuh", "Uus", "Uuo"}, {
         "h", "he", "li", "be", "b", "c", "n", "o", "f", "ne", "na", "mg", 
          "al", "si", "p", "s", "cl", "ar", "k", "ca", "sc", "ti", "v", "cr", 
          "mn", "fe", "co", "ni", "cu", "zn", "ga", "ge", "as", "se", "br", 
          "kr", "rb", "sr", "y", "zr", "nb", "mo", "tc", "ru", "rh", "pd", 
          "ag", "cd", "in", "sn", "sb", "te", "i", "xe", "cs", "ba", "la", 
          "ce", "pr", "nd", "pm", "sm", "eu", "gd", "tb", "dy", "ho", "er", 
          "tm", "yb", "lu", "hf", "ta", "w", "re", "os", "ir", "pt", "au", 
          "hg", "tl", "pb", "bi", "po", "at", "rn", "fr", "ra", "ac", "th", 
          "pa", "u", "np", "pu", "am", "cm", "bk", "cf", "es", "fm", "md", 
          "no", "lr", "rf", "db", "sg", "bh", "hs", "mt", "ds", "rg", "cn", 
          "nh", "fl", "mc", "lv", "ts", "og", "uub", "uut", "uuq", "uup", 
          "uuh", "uus", "uuo"}}, Replace[#, 
         Dispatch[{
          "h" -> RGBColor[0.65, 0.7, 0.7], "he" -> RGBColor[0.836713, 1., 1.],
            "li" -> RGBColor[0.799435, 0.543572, 0.997559], "be" -> 
           RGBColor[0.770565, 0.964309, 0.0442359], "b" -> 
           RGBColor[1., 0.709804, 0.709804], "c" -> RGBColor[0.4, 0.4, 0.4], 
           "n" -> RGBColor[0.291989, 0.437977, 0.888609], "o" -> 
           RGBColor[0.800498, 0.201504, 0.192061], "f" -> 
           RGBColor[0.578462, 0.85539, 0.408855], "ne" -> 
           RGBColor[0.677263, 0.928423, 0.955287], "na" -> 
           RGBColor[0.658708, 0.492173, 0.842842], "mg" -> 
           RGBColor[0.628274, 0.850553, 0.0782731], "al" -> 
           RGBColor[0.8913, 0.631904, 0.627399], "si" -> 
           RGBColor[0.941176, 0.784314, 0.627451], "p" -> 
           RGBColor[1., 0.501961, 0], "s" -> 
           RGBColor[0.90443, 0.97015, 0.13504], "cl" -> 
           RGBColor[0.412698, 0.932689, 0.166398], "ar" -> 
           RGBColor[0.546138, 0.844244, 0.892092], "k" -> 
           RGBColor[0.534026, 0.420729, 0.705621], "ca" -> 
           RGBColor[0.480072, 0.744591, 0.0955222], "sc" -> 
           RGBColor[0.901961, 0.901961, 0.901961], "ti" -> 
           RGBColor[0.74902, 0.760784, 0.780392], "v" -> 
           RGBColor[0.65098, 0.65098, 0.670588], "cr" -> 
           RGBColor[0.541176, 0.6, 0.780392], "mn" -> 
           RGBColor[0.611765, 0.478431, 0.780392], "fe" -> 
           RGBColor[0.878431, 0.4, 0.2], "co" -> 
           RGBColor[0.941176, 0.564706, 0.627451], "ni" -> 
           RGBColor[0.313725, 0.815686, 0.313725], "cu" -> 
           RGBColor[0.784314, 0.501961, 0.2], "zn" -> 
           RGBColor[0.490196, 0.501961, 0.690196], "ga" -> 
           RGBColor[0.800757, 0.542666, 0.533513], "ge" -> 
           RGBColor[0.60508, 0.632465, 0.576489], "as" -> 
           RGBColor[0.741176, 0.501961, 0.890196], "se" -> 
           RGBColor[0.917248, 0.657833, 0.0706628], "br" -> 
           RGBColor[0.58847, 0.22163, 0.16064], "kr" -> 
           RGBColor[0.426019, 0.747462, 0.810413], "rb" -> 
           RGBColor[0.425391, 0.329242, 0.585895], "sr" -> 
           RGBColor[0.325959, 0.646423, 0.095983], "y" -> 
           RGBColor[0.531014, 1., 1.], "zr" -> 
           RGBColor[0.458599, 0.917466, 0.918573], "nb" -> 
           RGBColor[0.385036, 0.834854, 0.841681], "mo" -> 
           RGBColor[0.310325, 0.752163, 0.769323], "tc" -> 
           RGBColor[0.234466, 0.669394, 0.701499], "ru" -> 
           RGBColor[0.157459, 0.586546, 0.638209], "rh" -> 
           RGBColor[0.0793033, 0.50362, 0.579453], "pd" -> 
           RGBColor[0., 0.420615, 0.525231], "ag" -> 
           RGBColor[0.752941, 0.752941, 0.752941], "cd" -> 
           RGBColor[1., 0.85098, 0.560784], "in" -> 
           RGBColor[0.728371, 0.440594, 0.422196], "sn" -> 
           RGBColor[0.39799, 0.491477, 0.495586], "sb" -> 
           RGBColor[0.619608, 0.388235, 0.709804], "te" -> 
           RGBColor[0.816706, 0.451332, 0.0100947], "i" -> 
           RGBColor[0.580392, 0, 0.580392], "xe" -> 
           RGBColor[0.316906, 0.638078, 0.710252], "cs" -> 
           RGBColor[0.332803, 0.217712, 0.483666], "ba" -> 
           RGBColor[0.165935, 0.55605, 0.0796556], "la" -> 
           RGBColor[0.928084, 0.716075, 0.329427], "ce" -> 
           RGBColor[0.894824, 0.731424, 0.325131], "pr" -> 
           RGBColor[0.86523, 0.707999, 0.315261], "nd" -> 
           RGBColor[0.837836, 0.662974, 0.301635], "pm" -> 
           RGBColor[0.811992, 0.607859, 0.285626], "sm" -> 
           RGBColor[0.787563, 0.549894, 0.268279], "eu" -> 
           RGBColor[0.764628, 0.493261, 0.250405], "gd" -> 
           RGBColor[0.743177, 0.440115, 0.23269], "tb" -> 
           RGBColor[0.72281, 0.39143, 0.215783], "dy" -> 
           RGBColor[0.702434, 0.347663, 0.200392], "ho" -> 
           RGBColor[0.679962, 0.309234, 0.187368], "er" -> 
           RGBColor[0.652012, 0.276823, 0.17779], "tm" -> 
           RGBColor[0.613603, 0.251489, 0.173042], "yb" -> 
           RGBColor[0.557855, 0.234598, 0.17489], "lu" -> 
           RGBColor[0.475685, 0.227573, 0.18555], "hf" -> 
           RGBColor[0.781537, 0.717388, 0.716579], "ta" -> 
           RGBColor[0.734443, 0.544489, 0.683471], "w" -> 
           RGBColor[0.681179, 0.360409, 0.63675], "re" -> 
           RGBColor[0.605181, 0.367584, 0.556343], "os" -> 
           RGBColor[0.521806, 0.382125, 0.469204], "ir" -> 
           RGBColor[0.445624, 0.373159, 0.399069], "pt" -> 
           RGBColor[0.815686, 0.815686, 0.878431], "au" -> 
           RGBColor[1., 0.819608, 0.137255], "hg" -> 
           RGBColor[0.721569, 0.721569, 0.815686], "tl" -> 
           RGBColor[0.65098, 0.329412, 0.301961], "pb" -> 
           RGBColor[0.341176, 0.34902, 0.380392], "bi" -> 
           RGBColor[0.619608, 0.309804, 0.709804], "po" -> 
           RGBColor[0.670588, 0.360784, 0], "at" -> 
           RGBColor[0.458824, 0.309804, 0.270588], "rn" -> 
           RGBColor[0.218799, 0.516091, 0.591608], "fr" -> 
           RGBColor[0.25626, 0.0861372, 0.398932], "ra" -> 
           RGBColor[0., 0.473472, 0.04654], "ac" -> 
           RGBColor[0.322042, 0.71693, 0.988479], "th" -> 
           RGBColor[0.3608, 0.67166, 0.943003], "pa" -> 
           RGBColor[0.397469, 0.628, 0.898853], "u" -> 
           RGBColor[0.43205, 0.58595, 0.856029], "np" -> 
           RGBColor[0.464542, 0.54551, 0.814532], "pu" -> 
           RGBColor[0.494945, 0.506679, 0.774361], "am" -> 
           RGBColor[0.52326, 0.469458, 0.735517], "cm" -> 
           RGBColor[0.549486, 0.433847, 0.697999], "bk" -> 
           RGBColor[0.573624, 0.399845, 0.661808], "cf" -> 
           RGBColor[0.595673, 0.367454, 0.626942], "es" -> 
           RGBColor[0.615633, 0.336672, 0.593404], "fm" -> 
           RGBColor[0.633505, 0.307499, 0.561191], "md" -> 
           RGBColor[0.649288, 0.279937, 0.530305], "no" -> 
           RGBColor[0.662982, 0.253984, 0.500746], "lr" -> 
           RGBColor[0.674588, 0.22964, 0.472513], "rf" -> 
           RGBColor[0.684106, 0.206907, 0.445606], "db" -> 
           RGBColor[0.691534, 0.185783, 0.420025], "sg" -> 
           RGBColor[0.696874, 0.166269, 0.395772], "bh" -> 
           RGBColor[0.700126, 0.148365, 0.372844], "hs" -> 
           RGBColor[0.701289, 0.13207, 0.351243], "mt" -> 
           RGBColor[0.700363, 0.117385, 0.330968], "ds" -> 
           RGBColor[0.697348, 0.10431, 0.31202], "rg" -> 
           RGBColor[0.692245, 0.0928444, 0.294398], "cn" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "nh" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "fl" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "mc" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "lv" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "ts" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "og" -> 
           RGBColor[0.635401, 0.0528, 0.226184], "uub" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "uut" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "uuq" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "uup" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "uuh" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "uus" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "uuo" -> 
           RGBColor[0.635401, 0.0528, 0.226184]}]]& ][0.85], 
       ColorDataFunction[
       "Atoms", 
        "Named", {{
         "H", "He", "Li", "Be", "B", "C", "N", "O", "F", "Ne", "Na", "Mg", 
          "Al", "Si", "P", "S", "Cl", "Ar", "K", "Ca", "Sc", "Ti", "V", "Cr", 
          "Mn", "Fe", "Co", "Ni", "Cu", "Zn", "Ga", "Ge", "As", "Se", "Br", 
          "Kr", "Rb", "Sr", "Y", "Zr", "Nb", "Mo", "Tc", "Ru", "Rh", "Pd", 
          "Ag", "Cd", "In", "Sn", "Sb", "Te", "I", "Xe", "Cs", "Ba", "La", 
          "Ce", "Pr", "Nd", "Pm", "Sm", "Eu", "Gd", "Tb", "Dy", "Ho", "Er", 
          "Tm", "Yb", "Lu", "Hf", "Ta", "W", "Re", "Os", "Ir", "Pt", "Au", 
          "Hg", "Tl", "Pb", "Bi", "Po", "At", "Rn", "Fr", "Ra", "Ac", "Th", 
          "Pa", "U", "Np", "Pu", "Am", "Cm", "Bk", "Cf", "Es", "Fm", "Md", 
          "No", "Lr", "Rf", "Db", "Sg", "Bh", "Hs", "Mt", "Ds", "Rg", "Cn", 
          "Nh", "Fl", "Mc", "Lv", "Ts", "Og", "Uub", "Uut", "Uuq", "Uup", 
          "Uuh", "Uus", "Uuo"}, {
         "h", "he", "li", "be", "b", "c", "n", "o", "f", "ne", "na", "mg", 
          "al", "si", "p", "s", "cl", "ar", "k", "ca", "sc", "ti", "v", "cr", 
          "mn", "fe", "co", "ni", "cu", "zn", "ga", "ge", "as", "se", "br", 
          "kr", "rb", "sr", "y", "zr", "nb", "mo", "tc", "ru", "rh", "pd", 
          "ag", "cd", "in", "sn", "sb", "te", "i", "xe", "cs", "ba", "la", 
          "ce", "pr", "nd", "pm", "sm", "eu", "gd", "tb", "dy", "ho", "er", 
          "tm", "yb", "lu", "hf", "ta", "w", "re", "os", "ir", "pt", "au", 
          "hg", "tl", "pb", "bi", "po", "at", "rn", "fr", "ra", "ac", "th", 
          "pa", "u", "np", "pu", "am", "cm", "bk", "cf", "es", "fm", "md", 
          "no", "lr", "rf", "db", "sg", "bh", "hs", "mt", "ds", "rg", "cn", 
          "nh", "fl", "mc", "lv", "ts", "og", "uub", "uut", "uuq", "uup", 
          "uuh", "uus", "uuo"}}, Replace[#, 
         Dispatch[{
          "h" -> RGBColor[0.65, 0.7, 0.7], "he" -> RGBColor[0.836713, 1., 1.],
            "li" -> RGBColor[0.799435, 0.543572, 0.997559], "be" -> 
           RGBColor[0.770565, 0.964309, 0.0442359], "b" -> 
           RGBColor[1., 0.709804, 0.709804], "c" -> RGBColor[0.4, 0.4, 0.4], 
           "n" -> RGBColor[0.291989, 0.437977, 0.888609], "o" -> 
           RGBColor[0.800498, 0.201504, 0.192061], "f" -> 
           RGBColor[0.578462, 0.85539, 0.408855], "ne" -> 
           RGBColor[0.677263, 0.928423, 0.955287], "na" -> 
           RGBColor[0.658708, 0.492173, 0.842842], "mg" -> 
           RGBColor[0.628274, 0.850553, 0.0782731], "al" -> 
           RGBColor[0.8913, 0.631904, 0.627399], "si" -> 
           RGBColor[0.941176, 0.784314, 0.627451], "p" -> 
           RGBColor[1., 0.501961, 0], "s" -> 
           RGBColor[0.90443, 0.97015, 0.13504], "cl" -> 
           RGBColor[0.412698, 0.932689, 0.166398], "ar" -> 
           RGBColor[0.546138, 0.844244, 0.892092], "k" -> 
           RGBColor[0.534026, 0.420729, 0.705621], "ca" -> 
           RGBColor[0.480072, 0.744591, 0.0955222], "sc" -> 
           RGBColor[0.901961, 0.901961, 0.901961], "ti" -> 
           RGBColor[0.74902, 0.760784, 0.780392], "v" -> 
           RGBColor[0.65098, 0.65098, 0.670588], "cr" -> 
           RGBColor[0.541176, 0.6, 0.780392], "mn" -> 
           RGBColor[0.611765, 0.478431, 0.780392], "fe" -> 
           RGBColor[0.878431, 0.4, 0.2], "co" -> 
           RGBColor[0.941176, 0.564706, 0.627451], "ni" -> 
           RGBColor[0.313725, 0.815686, 0.313725], "cu" -> 
           RGBColor[0.784314, 0.501961, 0.2], "zn" -> 
           RGBColor[0.490196, 0.501961, 0.690196], "ga" -> 
           RGBColor[0.800757, 0.542666, 0.533513], "ge" -> 
           RGBColor[0.60508, 0.632465, 0.576489], "as" -> 
           RGBColor[0.741176, 0.501961, 0.890196], "se" -> 
           RGBColor[0.917248, 0.657833, 0.0706628], "br" -> 
           RGBColor[0.58847, 0.22163, 0.16064], "kr" -> 
           RGBColor[0.426019, 0.747462, 0.810413], "rb" -> 
           RGBColor[0.425391, 0.329242, 0.585895], "sr" -> 
           RGBColor[0.325959, 0.646423, 0.095983], "y" -> 
           RGBColor[0.531014, 1., 1.], "zr" -> 
           RGBColor[0.458599, 0.917466, 0.918573], "nb" -> 
           RGBColor[0.385036, 0.834854, 0.841681], "mo" -> 
           RGBColor[0.310325, 0.752163, 0.769323], "tc" -> 
           RGBColor[0.234466, 0.669394, 0.701499], "ru" -> 
           RGBColor[0.157459, 0.586546, 0.638209], "rh" -> 
           RGBColor[0.0793033, 0.50362, 0.579453], "pd" -> 
           RGBColor[0., 0.420615, 0.525231], "ag" -> 
           RGBColor[0.752941, 0.752941, 0.752941], "cd" -> 
           RGBColor[1., 0.85098, 0.560784], "in" -> 
           RGBColor[0.728371, 0.440594, 0.422196], "sn" -> 
           RGBColor[0.39799, 0.491477, 0.495586], "sb" -> 
           RGBColor[0.619608, 0.388235, 0.709804], "te" -> 
           RGBColor[0.816706, 0.451332, 0.0100947], "i" -> 
           RGBColor[0.580392, 0, 0.580392], "xe" -> 
           RGBColor[0.316906, 0.638078, 0.710252], "cs" -> 
           RGBColor[0.332803, 0.217712, 0.483666], "ba" -> 
           RGBColor[0.165935, 0.55605, 0.0796556], "la" -> 
           RGBColor[0.928084, 0.716075, 0.329427], "ce" -> 
           RGBColor[0.894824, 0.731424, 0.325131], "pr" -> 
           RGBColor[0.86523, 0.707999, 0.315261], "nd" -> 
           RGBColor[0.837836, 0.662974, 0.301635], "pm" -> 
           RGBColor[0.811992, 0.607859, 0.285626], "sm" -> 
           RGBColor[0.787563, 0.549894, 0.268279], "eu" -> 
           RGBColor[0.764628, 0.493261, 0.250405], "gd" -> 
           RGBColor[0.743177, 0.440115, 0.23269], "tb" -> 
           RGBColor[0.72281, 0.39143, 0.215783], "dy" -> 
           RGBColor[0.702434, 0.347663, 0.200392], "ho" -> 
           RGBColor[0.679962, 0.309234, 0.187368], "er" -> 
           RGBColor[0.652012, 0.276823, 0.17779], "tm" -> 
           RGBColor[0.613603, 0.251489, 0.173042], "yb" -> 
           RGBColor[0.557855, 0.234598, 0.17489], "lu" -> 
           RGBColor[0.475685, 0.227573, 0.18555], "hf" -> 
           RGBColor[0.781537, 0.717388, 0.716579], "ta" -> 
           RGBColor[0.734443, 0.544489, 0.683471], "w" -> 
           RGBColor[0.681179, 0.360409, 0.63675], "re" -> 
           RGBColor[0.605181, 0.367584, 0.556343], "os" -> 
           RGBColor[0.521806, 0.382125, 0.469204], "ir" -> 
           RGBColor[0.445624, 0.373159, 0.399069], "pt" -> 
           RGBColor[0.815686, 0.815686, 0.878431], "au" -> 
           RGBColor[1., 0.819608, 0.137255], "hg" -> 
           RGBColor[0.721569, 0.721569, 0.815686], "tl" -> 
           RGBColor[0.65098, 0.329412, 0.301961], "pb" -> 
           RGBColor[0.341176, 0.34902, 0.380392], "bi" -> 
           RGBColor[0.619608, 0.309804, 0.709804], "po" -> 
           RGBColor[0.670588, 0.360784, 0], "at" -> 
           RGBColor[0.458824, 0.309804, 0.270588], "rn" -> 
           RGBColor[0.218799, 0.516091, 0.591608], "fr" -> 
           RGBColor[0.25626, 0.0861372, 0.398932], "ra" -> 
           RGBColor[0., 0.473472, 0.04654], "ac" -> 
           RGBColor[0.322042, 0.71693, 0.988479], "th" -> 
           RGBColor[0.3608, 0.67166, 0.943003], "pa" -> 
           RGBColor[0.397469, 0.628, 0.898853], "u" -> 
           RGBColor[0.43205, 0.58595, 0.856029], "np" -> 
           RGBColor[0.464542, 0.54551, 0.814532], "pu" -> 
           RGBColor[0.494945, 0.506679, 0.774361], "am" -> 
           RGBColor[0.52326, 0.469458, 0.735517], "cm" -> 
           RGBColor[0.549486, 0.433847, 0.697999], "bk" -> 
           RGBColor[0.573624, 0.399845, 0.661808], "cf" -> 
           RGBColor[0.595673, 0.367454, 0.626942], "es" -> 
           RGBColor[0.615633, 0.336672, 0.593404], "fm" -> 
           RGBColor[0.633505, 0.307499, 0.561191], "md" -> 
           RGBColor[0.649288, 0.279937, 0.530305], "no" -> 
           RGBColor[0.662982, 0.253984, 0.500746], "lr" -> 
           RGBColor[0.674588, 0.22964, 0.472513], "rf" -> 
           RGBColor[0.684106, 0.206907, 0.445606], "db" -> 
           RGBColor[0.691534, 0.185783, 0.420025], "sg" -> 
           RGBColor[0.696874, 0.166269, 0.395772], "bh" -> 
           RGBColor[0.700126, 0.148365, 0.372844], "hs" -> 
           RGBColor[0.701289, 0.13207, 0.351243], "mt" -> 
           RGBColor[0.700363, 0.117385, 0.330968], "ds" -> 
           RGBColor[0.697348, 0.10431, 0.31202], "rg" -> 
           RGBColor[0.692245, 0.0928444, 0.294398], "cn" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "nh" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "fl" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "mc" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "lv" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "ts" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "og" -> 
           RGBColor[0.635401, 0.0528, 0.226184], "uub" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "uut" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "uuq" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "uup" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "uuh" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "uus" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "uuo" -> 
           RGBColor[0.635401, 0.0528, 0.226184]}]]& ][0.85], 
       ColorDataFunction[
       "Atoms", 
        "Named", {{
         "H", "He", "Li", "Be", "B", "C", "N", "O", "F", "Ne", "Na", "Mg", 
          "Al", "Si", "P", "S", "Cl", "Ar", "K", "Ca", "Sc", "Ti", "V", "Cr", 
          "Mn", "Fe", "Co", "Ni", "Cu", "Zn", "Ga", "Ge", "As", "Se", "Br", 
          "Kr", "Rb", "Sr", "Y", "Zr", "Nb", "Mo", "Tc", "Ru", "Rh", "Pd", 
          "Ag", "Cd", "In", "Sn", "Sb", "Te", "I", "Xe", "Cs", "Ba", "La", 
          "Ce", "Pr", "Nd", "Pm", "Sm", "Eu", "Gd", "Tb", "Dy", "Ho", "Er", 
          "Tm", "Yb", "Lu", "Hf", "Ta", "W", "Re", "Os", "Ir", "Pt", "Au", 
          "Hg", "Tl", "Pb", "Bi", "Po", "At", "Rn", "Fr", "Ra", "Ac", "Th", 
          "Pa", "U", "Np", "Pu", "Am", "Cm", "Bk", "Cf", "Es", "Fm", "Md", 
          "No", "Lr", "Rf", "Db", "Sg", "Bh", "Hs", "Mt", "Ds", "Rg", "Cn", 
          "Nh", "Fl", "Mc", "Lv", "Ts", "Og", "Uub", "Uut", "Uuq", "Uup", 
          "Uuh", "Uus", "Uuo"}, {
         "h", "he", "li", "be", "b", "c", "n", "o", "f", "ne", "na", "mg", 
          "al", "si", "p", "s", "cl", "ar", "k", "ca", "sc", "ti", "v", "cr", 
          "mn", "fe", "co", "ni", "cu", "zn", "ga", "ge", "as", "se", "br", 
          "kr", "rb", "sr", "y", "zr", "nb", "mo", "tc", "ru", "rh", "pd", 
          "ag", "cd", "in", "sn", "sb", "te", "i", "xe", "cs", "ba", "la", 
          "ce", "pr", "nd", "pm", "sm", "eu", "gd", "tb", "dy", "ho", "er", 
          "tm", "yb", "lu", "hf", "ta", "w", "re", "os", "ir", "pt", "au", 
          "hg", "tl", "pb", "bi", "po", "at", "rn", "fr", "ra", "ac", "th", 
          "pa", "u", "np", "pu", "am", "cm", "bk", "cf", "es", "fm", "md", 
          "no", "lr", "rf", "db", "sg", "bh", "hs", "mt", "ds", "rg", "cn", 
          "nh", "fl", "mc", "lv", "ts", "og", "uub", "uut", "uuq", "uup", 
          "uuh", "uus", "uuo"}}, Replace[#, 
         Dispatch[{
          "h" -> RGBColor[0.65, 0.7, 0.7], "he" -> RGBColor[0.836713, 1., 1.],
            "li" -> RGBColor[0.799435, 0.543572, 0.997559], "be" -> 
           RGBColor[0.770565, 0.964309, 0.0442359], "b" -> 
           RGBColor[1., 0.709804, 0.709804], "c" -> RGBColor[0.4, 0.4, 0.4], 
           "n" -> RGBColor[0.291989, 0.437977, 0.888609], "o" -> 
           RGBColor[0.800498, 0.201504, 0.192061], "f" -> 
           RGBColor[0.578462, 0.85539, 0.408855], "ne" -> 
           RGBColor[0.677263, 0.928423, 0.955287], "na" -> 
           RGBColor[0.658708, 0.492173, 0.842842], "mg" -> 
           RGBColor[0.628274, 0.850553, 0.0782731], "al" -> 
           RGBColor[0.8913, 0.631904, 0.627399], "si" -> 
           RGBColor[0.941176, 0.784314, 0.627451], "p" -> 
           RGBColor[1., 0.501961, 0], "s" -> 
           RGBColor[0.90443, 0.97015, 0.13504], "cl" -> 
           RGBColor[0.412698, 0.932689, 0.166398], "ar" -> 
           RGBColor[0.546138, 0.844244, 0.892092], "k" -> 
           RGBColor[0.534026, 0.420729, 0.705621], "ca" -> 
           RGBColor[0.480072, 0.744591, 0.0955222], "sc" -> 
           RGBColor[0.901961, 0.901961, 0.901961], "ti" -> 
           RGBColor[0.74902, 0.760784, 0.780392], "v" -> 
           RGBColor[0.65098, 0.65098, 0.670588], "cr" -> 
           RGBColor[0.541176, 0.6, 0.780392], "mn" -> 
           RGBColor[0.611765, 0.478431, 0.780392], "fe" -> 
           RGBColor[0.878431, 0.4, 0.2], "co" -> 
           RGBColor[0.941176, 0.564706, 0.627451], "ni" -> 
           RGBColor[0.313725, 0.815686, 0.313725], "cu" -> 
           RGBColor[0.784314, 0.501961, 0.2], "zn" -> 
           RGBColor[0.490196, 0.501961, 0.690196], "ga" -> 
           RGBColor[0.800757, 0.542666, 0.533513], "ge" -> 
           RGBColor[0.60508, 0.632465, 0.576489], "as" -> 
           RGBColor[0.741176, 0.501961, 0.890196], "se" -> 
           RGBColor[0.917248, 0.657833, 0.0706628], "br" -> 
           RGBColor[0.58847, 0.22163, 0.16064], "kr" -> 
           RGBColor[0.426019, 0.747462, 0.810413], "rb" -> 
           RGBColor[0.425391, 0.329242, 0.585895], "sr" -> 
           RGBColor[0.325959, 0.646423, 0.095983], "y" -> 
           RGBColor[0.531014, 1., 1.], "zr" -> 
           RGBColor[0.458599, 0.917466, 0.918573], "nb" -> 
           RGBColor[0.385036, 0.834854, 0.841681], "mo" -> 
           RGBColor[0.310325, 0.752163, 0.769323], "tc" -> 
           RGBColor[0.234466, 0.669394, 0.701499], "ru" -> 
           RGBColor[0.157459, 0.586546, 0.638209], "rh" -> 
           RGBColor[0.0793033, 0.50362, 0.579453], "pd" -> 
           RGBColor[0., 0.420615, 0.525231], "ag" -> 
           RGBColor[0.752941, 0.752941, 0.752941], "cd" -> 
           RGBColor[1., 0.85098, 0.560784], "in" -> 
           RGBColor[0.728371, 0.440594, 0.422196], "sn" -> 
           RGBColor[0.39799, 0.491477, 0.495586], "sb" -> 
           RGBColor[0.619608, 0.388235, 0.709804], "te" -> 
           RGBColor[0.816706, 0.451332, 0.0100947], "i" -> 
           RGBColor[0.580392, 0, 0.580392], "xe" -> 
           RGBColor[0.316906, 0.638078, 0.710252], "cs" -> 
           RGBColor[0.332803, 0.217712, 0.483666], "ba" -> 
           RGBColor[0.165935, 0.55605, 0.0796556], "la" -> 
           RGBColor[0.928084, 0.716075, 0.329427], "ce" -> 
           RGBColor[0.894824, 0.731424, 0.325131], "pr" -> 
           RGBColor[0.86523, 0.707999, 0.315261], "nd" -> 
           RGBColor[0.837836, 0.662974, 0.301635], "pm" -> 
           RGBColor[0.811992, 0.607859, 0.285626], "sm" -> 
           RGBColor[0.787563, 0.549894, 0.268279], "eu" -> 
           RGBColor[0.764628, 0.493261, 0.250405], "gd" -> 
           RGBColor[0.743177, 0.440115, 0.23269], "tb" -> 
           RGBColor[0.72281, 0.39143, 0.215783], "dy" -> 
           RGBColor[0.702434, 0.347663, 0.200392], "ho" -> 
           RGBColor[0.679962, 0.309234, 0.187368], "er" -> 
           RGBColor[0.652012, 0.276823, 0.17779], "tm" -> 
           RGBColor[0.613603, 0.251489, 0.173042], "yb" -> 
           RGBColor[0.557855, 0.234598, 0.17489], "lu" -> 
           RGBColor[0.475685, 0.227573, 0.18555], "hf" -> 
           RGBColor[0.781537, 0.717388, 0.716579], "ta" -> 
           RGBColor[0.734443, 0.544489, 0.683471], "w" -> 
           RGBColor[0.681179, 0.360409, 0.63675], "re" -> 
           RGBColor[0.605181, 0.367584, 0.556343], "os" -> 
           RGBColor[0.521806, 0.382125, 0.469204], "ir" -> 
           RGBColor[0.445624, 0.373159, 0.399069], "pt" -> 
           RGBColor[0.815686, 0.815686, 0.878431], "au" -> 
           RGBColor[1., 0.819608, 0.137255], "hg" -> 
           RGBColor[0.721569, 0.721569, 0.815686], "tl" -> 
           RGBColor[0.65098, 0.329412, 0.301961], "pb" -> 
           RGBColor[0.341176, 0.34902, 0.380392], "bi" -> 
           RGBColor[0.619608, 0.309804, 0.709804], "po" -> 
           RGBColor[0.670588, 0.360784, 0], "at" -> 
           RGBColor[0.458824, 0.309804, 0.270588], "rn" -> 
           RGBColor[0.218799, 0.516091, 0.591608], "fr" -> 
           RGBColor[0.25626, 0.0861372, 0.398932], "ra" -> 
           RGBColor[0., 0.473472, 0.04654], "ac" -> 
           RGBColor[0.322042, 0.71693, 0.988479], "th" -> 
           RGBColor[0.3608, 0.67166, 0.943003], "pa" -> 
           RGBColor[0.397469, 0.628, 0.898853], "u" -> 
           RGBColor[0.43205, 0.58595, 0.856029], "np" -> 
           RGBColor[0.464542, 0.54551, 0.814532], "pu" -> 
           RGBColor[0.494945, 0.506679, 0.774361], "am" -> 
           RGBColor[0.52326, 0.469458, 0.735517], "cm" -> 
           RGBColor[0.549486, 0.433847, 0.697999], "bk" -> 
           RGBColor[0.573624, 0.399845, 0.661808], "cf" -> 
           RGBColor[0.595673, 0.367454, 0.626942], "es" -> 
           RGBColor[0.615633, 0.336672, 0.593404], "fm" -> 
           RGBColor[0.633505, 0.307499, 0.561191], "md" -> 
           RGBColor[0.649288, 0.279937, 0.530305], "no" -> 
           RGBColor[0.662982, 0.253984, 0.500746], "lr" -> 
           RGBColor[0.674588, 0.22964, 0.472513], "rf" -> 
           RGBColor[0.684106, 0.206907, 0.445606], "db" -> 
           RGBColor[0.691534, 0.185783, 0.420025], "sg" -> 
           RGBColor[0.696874, 0.166269, 0.395772], "bh" -> 
           RGBColor[0.700126, 0.148365, 0.372844], "hs" -> 
           RGBColor[0.701289, 0.13207, 0.351243], "mt" -> 
           RGBColor[0.700363, 0.117385, 0.330968], "ds" -> 
           RGBColor[0.697348, 0.10431, 0.31202], "rg" -> 
           RGBColor[0.692245, 0.0928444, 0.294398], "cn" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "nh" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "fl" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "mc" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "lv" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "ts" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "og" -> 
           RGBColor[0.635401, 0.0528, 0.226184], "uub" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "uut" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "uuq" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "uup" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "uuh" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "uus" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "uuo" -> 
           RGBColor[0.635401, 0.0528, 0.226184]}]]& ][0.85], 
       ColorDataFunction[
       "Atoms", 
        "Named", {{
         "H", "He", "Li", "Be", "B", "C", "N", "O", "F", "Ne", "Na", "Mg", 
          "Al", "Si", "P", "S", "Cl", "Ar", "K", "Ca", "Sc", "Ti", "V", "Cr", 
          "Mn", "Fe", "Co", "Ni", "Cu", "Zn", "Ga", "Ge", "As", "Se", "Br", 
          "Kr", "Rb", "Sr", "Y", "Zr", "Nb", "Mo", "Tc", "Ru", "Rh", "Pd", 
          "Ag", "Cd", "In", "Sn", "Sb", "Te", "I", "Xe", "Cs", "Ba", "La", 
          "Ce", "Pr", "Nd", "Pm", "Sm", "Eu", "Gd", "Tb", "Dy", "Ho", "Er", 
          "Tm", "Yb", "Lu", "Hf", "Ta", "W", "Re", "Os", "Ir", "Pt", "Au", 
          "Hg", "Tl", "Pb", "Bi", "Po", "At", "Rn", "Fr", "Ra", "Ac", "Th", 
          "Pa", "U", "Np", "Pu", "Am", "Cm", "Bk", "Cf", "Es", "Fm", "Md", 
          "No", "Lr", "Rf", "Db", "Sg", "Bh", "Hs", "Mt", "Ds", "Rg", "Cn", 
          "Nh", "Fl", "Mc", "Lv", "Ts", "Og", "Uub", "Uut", "Uuq", "Uup", 
          "Uuh", "Uus", "Uuo"}, {
         "h", "he", "li", "be", "b", "c", "n", "o", "f", "ne", "na", "mg", 
          "al", "si", "p", "s", "cl", "ar", "k", "ca", "sc", "ti", "v", "cr", 
          "mn", "fe", "co", "ni", "cu", "zn", "ga", "ge", "as", "se", "br", 
          "kr", "rb", "sr", "y", "zr", "nb", "mo", "tc", "ru", "rh", "pd", 
          "ag", "cd", "in", "sn", "sb", "te", "i", "xe", "cs", "ba", "la", 
          "ce", "pr", "nd", "pm", "sm", "eu", "gd", "tb", "dy", "ho", "er", 
          "tm", "yb", "lu", "hf", "ta", "w", "re", "os", "ir", "pt", "au", 
          "hg", "tl", "pb", "bi", "po", "at", "rn", "fr", "ra", "ac", "th", 
          "pa", "u", "np", "pu", "am", "cm", "bk", "cf", "es", "fm", "md", 
          "no", "lr", "rf", "db", "sg", "bh", "hs", "mt", "ds", "rg", "cn", 
          "nh", "fl", "mc", "lv", "ts", "og", "uub", "uut", "uuq", "uup", 
          "uuh", "uus", "uuo"}}, Replace[#, 
         Dispatch[{
          "h" -> RGBColor[0.65, 0.7, 0.7], "he" -> RGBColor[0.836713, 1., 1.],
            "li" -> RGBColor[0.799435, 0.543572, 0.997559], "be" -> 
           RGBColor[0.770565, 0.964309, 0.0442359], "b" -> 
           RGBColor[1., 0.709804, 0.709804], "c" -> RGBColor[0.4, 0.4, 0.4], 
           "n" -> RGBColor[0.291989, 0.437977, 0.888609], "o" -> 
           RGBColor[0.800498, 0.201504, 0.192061], "f" -> 
           RGBColor[0.578462, 0.85539, 0.408855], "ne" -> 
           RGBColor[0.677263, 0.928423, 0.955287], "na" -> 
           RGBColor[0.658708, 0.492173, 0.842842], "mg" -> 
           RGBColor[0.628274, 0.850553, 0.0782731], "al" -> 
           RGBColor[0.8913, 0.631904, 0.627399], "si" -> 
           RGBColor[0.941176, 0.784314, 0.627451], "p" -> 
           RGBColor[1., 0.501961, 0], "s" -> 
           RGBColor[0.90443, 0.97015, 0.13504], "cl" -> 
           RGBColor[0.412698, 0.932689, 0.166398], "ar" -> 
           RGBColor[0.546138, 0.844244, 0.892092], "k" -> 
           RGBColor[0.534026, 0.420729, 0.705621], "ca" -> 
           RGBColor[0.480072, 0.744591, 0.0955222], "sc" -> 
           RGBColor[0.901961, 0.901961, 0.901961], "ti" -> 
           RGBColor[0.74902, 0.760784, 0.780392], "v" -> 
           RGBColor[0.65098, 0.65098, 0.670588], "cr" -> 
           RGBColor[0.541176, 0.6, 0.780392], "mn" -> 
           RGBColor[0.611765, 0.478431, 0.780392], "fe" -> 
           RGBColor[0.878431, 0.4, 0.2], "co" -> 
           RGBColor[0.941176, 0.564706, 0.627451], "ni" -> 
           RGBColor[0.313725, 0.815686, 0.313725], "cu" -> 
           RGBColor[0.784314, 0.501961, 0.2], "zn" -> 
           RGBColor[0.490196, 0.501961, 0.690196], "ga" -> 
           RGBColor[0.800757, 0.542666, 0.533513], "ge" -> 
           RGBColor[0.60508, 0.632465, 0.576489], "as" -> 
           RGBColor[0.741176, 0.501961, 0.890196], "se" -> 
           RGBColor[0.917248, 0.657833, 0.0706628], "br" -> 
           RGBColor[0.58847, 0.22163, 0.16064], "kr" -> 
           RGBColor[0.426019, 0.747462, 0.810413], "rb" -> 
           RGBColor[0.425391, 0.329242, 0.585895], "sr" -> 
           RGBColor[0.325959, 0.646423, 0.095983], "y" -> 
           RGBColor[0.531014, 1., 1.], "zr" -> 
           RGBColor[0.458599, 0.917466, 0.918573], "nb" -> 
           RGBColor[0.385036, 0.834854, 0.841681], "mo" -> 
           RGBColor[0.310325, 0.752163, 0.769323], "tc" -> 
           RGBColor[0.234466, 0.669394, 0.701499], "ru" -> 
           RGBColor[0.157459, 0.586546, 0.638209], "rh" -> 
           RGBColor[0.0793033, 0.50362, 0.579453], "pd" -> 
           RGBColor[0., 0.420615, 0.525231], "ag" -> 
           RGBColor[0.752941, 0.752941, 0.752941], "cd" -> 
           RGBColor[1., 0.85098, 0.560784], "in" -> 
           RGBColor[0.728371, 0.440594, 0.422196], "sn" -> 
           RGBColor[0.39799, 0.491477, 0.495586], "sb" -> 
           RGBColor[0.619608, 0.388235, 0.709804], "te" -> 
           RGBColor[0.816706, 0.451332, 0.0100947], "i" -> 
           RGBColor[0.580392, 0, 0.580392], "xe" -> 
           RGBColor[0.316906, 0.638078, 0.710252], "cs" -> 
           RGBColor[0.332803, 0.217712, 0.483666], "ba" -> 
           RGBColor[0.165935, 0.55605, 0.0796556], "la" -> 
           RGBColor[0.928084, 0.716075, 0.329427], "ce" -> 
           RGBColor[0.894824, 0.731424, 0.325131], "pr" -> 
           RGBColor[0.86523, 0.707999, 0.315261], "nd" -> 
           RGBColor[0.837836, 0.662974, 0.301635], "pm" -> 
           RGBColor[0.811992, 0.607859, 0.285626], "sm" -> 
           RGBColor[0.787563, 0.549894, 0.268279], "eu" -> 
           RGBColor[0.764628, 0.493261, 0.250405], "gd" -> 
           RGBColor[0.743177, 0.440115, 0.23269], "tb" -> 
           RGBColor[0.72281, 0.39143, 0.215783], "dy" -> 
           RGBColor[0.702434, 0.347663, 0.200392], "ho" -> 
           RGBColor[0.679962, 0.309234, 0.187368], "er" -> 
           RGBColor[0.652012, 0.276823, 0.17779], "tm" -> 
           RGBColor[0.613603, 0.251489, 0.173042], "yb" -> 
           RGBColor[0.557855, 0.234598, 0.17489], "lu" -> 
           RGBColor[0.475685, 0.227573, 0.18555], "hf" -> 
           RGBColor[0.781537, 0.717388, 0.716579], "ta" -> 
           RGBColor[0.734443, 0.544489, 0.683471], "w" -> 
           RGBColor[0.681179, 0.360409, 0.63675], "re" -> 
           RGBColor[0.605181, 0.367584, 0.556343], "os" -> 
           RGBColor[0.521806, 0.382125, 0.469204], "ir" -> 
           RGBColor[0.445624, 0.373159, 0.399069], "pt" -> 
           RGBColor[0.815686, 0.815686, 0.878431], "au" -> 
           RGBColor[1., 0.819608, 0.137255], "hg" -> 
           RGBColor[0.721569, 0.721569, 0.815686], "tl" -> 
           RGBColor[0.65098, 0.329412, 0.301961], "pb" -> 
           RGBColor[0.341176, 0.34902, 0.380392], "bi" -> 
           RGBColor[0.619608, 0.309804, 0.709804], "po" -> 
           RGBColor[0.670588, 0.360784, 0], "at" -> 
           RGBColor[0.458824, 0.309804, 0.270588], "rn" -> 
           RGBColor[0.218799, 0.516091, 0.591608], "fr" -> 
           RGBColor[0.25626, 0.0861372, 0.398932], "ra" -> 
           RGBColor[0., 0.473472, 0.04654], "ac" -> 
           RGBColor[0.322042, 0.71693, 0.988479], "th" -> 
           RGBColor[0.3608, 0.67166, 0.943003], "pa" -> 
           RGBColor[0.397469, 0.628, 0.898853], "u" -> 
           RGBColor[0.43205, 0.58595, 0.856029], "np" -> 
           RGBColor[0.464542, 0.54551, 0.814532], "pu" -> 
           RGBColor[0.494945, 0.506679, 0.774361], "am" -> 
           RGBColor[0.52326, 0.469458, 0.735517], "cm" -> 
           RGBColor[0.549486, 0.433847, 0.697999], "bk" -> 
           RGBColor[0.573624, 0.399845, 0.661808], "cf" -> 
           RGBColor[0.595673, 0.367454, 0.626942], "es" -> 
           RGBColor[0.615633, 0.336672, 0.593404], "fm" -> 
           RGBColor[0.633505, 0.307499, 0.561191], "md" -> 
           RGBColor[0.649288, 0.279937, 0.530305], "no" -> 
           RGBColor[0.662982, 0.253984, 0.500746], "lr" -> 
           RGBColor[0.674588, 0.22964, 0.472513], "rf" -> 
           RGBColor[0.684106, 0.206907, 0.445606], "db" -> 
           RGBColor[0.691534, 0.185783, 0.420025], "sg" -> 
           RGBColor[0.696874, 0.166269, 0.395772], "bh" -> 
           RGBColor[0.700126, 0.148365, 0.372844], "hs" -> 
           RGBColor[0.701289, 0.13207, 0.351243], "mt" -> 
           RGBColor[0.700363, 0.117385, 0.330968], "ds" -> 
           RGBColor[0.697348, 0.10431, 0.31202], "rg" -> 
           RGBColor[0.692245, 0.0928444, 0.294398], "cn" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "nh" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "fl" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "mc" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "lv" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "ts" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "og" -> 
           RGBColor[0.635401, 0.0528, 0.226184], "uub" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "uut" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "uuq" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "uup" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "uuh" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "uus" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "uuo" -> 
           RGBColor[0.635401, 0.0528, 0.226184]}]]& ][0.85], 
       ColorDataFunction[
       "Atoms", 
        "Named", {{
         "H", "He", "Li", "Be", "B", "C", "N", "O", "F", "Ne", "Na", "Mg", 
          "Al", "Si", "P", "S", "Cl", "Ar", "K", "Ca", "Sc", "Ti", "V", "Cr", 
          "Mn", "Fe", "Co", "Ni", "Cu", "Zn", "Ga", "Ge", "As", "Se", "Br", 
          "Kr", "Rb", "Sr", "Y", "Zr", "Nb", "Mo", "Tc", "Ru", "Rh", "Pd", 
          "Ag", "Cd", "In", "Sn", "Sb", "Te", "I", "Xe", "Cs", "Ba", "La", 
          "Ce", "Pr", "Nd", "Pm", "Sm", "Eu", "Gd", "Tb", "Dy", "Ho", "Er", 
          "Tm", "Yb", "Lu", "Hf", "Ta", "W", "Re", "Os", "Ir", "Pt", "Au", 
          "Hg", "Tl", "Pb", "Bi", "Po", "At", "Rn", "Fr", "Ra", "Ac", "Th", 
          "Pa", "U", "Np", "Pu", "Am", "Cm", "Bk", "Cf", "Es", "Fm", "Md", 
          "No", "Lr", "Rf", "Db", "Sg", "Bh", "Hs", "Mt", "Ds", "Rg", "Cn", 
          "Nh", "Fl", "Mc", "Lv", "Ts", "Og", "Uub", "Uut", "Uuq", "Uup", 
          "Uuh", "Uus", "Uuo"}, {
         "h", "he", "li", "be", "b", "c", "n", "o", "f", "ne", "na", "mg", 
          "al", "si", "p", "s", "cl", "ar", "k", "ca", "sc", "ti", "v", "cr", 
          "mn", "fe", "co", "ni", "cu", "zn", "ga", "ge", "as", "se", "br", 
          "kr", "rb", "sr", "y", "zr", "nb", "mo", "tc", "ru", "rh", "pd", 
          "ag", "cd", "in", "sn", "sb", "te", "i", "xe", "cs", "ba", "la", 
          "ce", "pr", "nd", "pm", "sm", "eu", "gd", "tb", "dy", "ho", "er", 
          "tm", "yb", "lu", "hf", "ta", "w", "re", "os", "ir", "pt", "au", 
          "hg", "tl", "pb", "bi", "po", "at", "rn", "fr", "ra", "ac", "th", 
          "pa", "u", "np", "pu", "am", "cm", "bk", "cf", "es", "fm", "md", 
          "no", "lr", "rf", "db", "sg", "bh", "hs", "mt", "ds", "rg", "cn", 
          "nh", "fl", "mc", "lv", "ts", "og", "uub", "uut", "uuq", "uup", 
          "uuh", "uus", "uuo"}}, Replace[#, 
         Dispatch[{
          "h" -> RGBColor[0.65, 0.7, 0.7], "he" -> RGBColor[0.836713, 1., 1.],
            "li" -> RGBColor[0.799435, 0.543572, 0.997559], "be" -> 
           RGBColor[0.770565, 0.964309, 0.0442359], "b" -> 
           RGBColor[1., 0.709804, 0.709804], "c" -> RGBColor[0.4, 0.4, 0.4], 
           "n" -> RGBColor[0.291989, 0.437977, 0.888609], "o" -> 
           RGBColor[0.800498, 0.201504, 0.192061], "f" -> 
           RGBColor[0.578462, 0.85539, 0.408855], "ne" -> 
           RGBColor[0.677263, 0.928423, 0.955287], "na" -> 
           RGBColor[0.658708, 0.492173, 0.842842], "mg" -> 
           RGBColor[0.628274, 0.850553, 0.0782731], "al" -> 
           RGBColor[0.8913, 0.631904, 0.627399], "si" -> 
           RGBColor[0.941176, 0.784314, 0.627451], "p" -> 
           RGBColor[1., 0.501961, 0], "s" -> 
           RGBColor[0.90443, 0.97015, 0.13504], "cl" -> 
           RGBColor[0.412698, 0.932689, 0.166398], "ar" -> 
           RGBColor[0.546138, 0.844244, 0.892092], "k" -> 
           RGBColor[0.534026, 0.420729, 0.705621], "ca" -> 
           RGBColor[0.480072, 0.744591, 0.0955222], "sc" -> 
           RGBColor[0.901961, 0.901961, 0.901961], "ti" -> 
           RGBColor[0.74902, 0.760784, 0.780392], "v" -> 
           RGBColor[0.65098, 0.65098, 0.670588], "cr" -> 
           RGBColor[0.541176, 0.6, 0.780392], "mn" -> 
           RGBColor[0.611765, 0.478431, 0.780392], "fe" -> 
           RGBColor[0.878431, 0.4, 0.2], "co" -> 
           RGBColor[0.941176, 0.564706, 0.627451], "ni" -> 
           RGBColor[0.313725, 0.815686, 0.313725], "cu" -> 
           RGBColor[0.784314, 0.501961, 0.2], "zn" -> 
           RGBColor[0.490196, 0.501961, 0.690196], "ga" -> 
           RGBColor[0.800757, 0.542666, 0.533513], "ge" -> 
           RGBColor[0.60508, 0.632465, 0.576489], "as" -> 
           RGBColor[0.741176, 0.501961, 0.890196], "se" -> 
           RGBColor[0.917248, 0.657833, 0.0706628], "br" -> 
           RGBColor[0.58847, 0.22163, 0.16064], "kr" -> 
           RGBColor[0.426019, 0.747462, 0.810413], "rb" -> 
           RGBColor[0.425391, 0.329242, 0.585895], "sr" -> 
           RGBColor[0.325959, 0.646423, 0.095983], "y" -> 
           RGBColor[0.531014, 1., 1.], "zr" -> 
           RGBColor[0.458599, 0.917466, 0.918573], "nb" -> 
           RGBColor[0.385036, 0.834854, 0.841681], "mo" -> 
           RGBColor[0.310325, 0.752163, 0.769323], "tc" -> 
           RGBColor[0.234466, 0.669394, 0.701499], "ru" -> 
           RGBColor[0.157459, 0.586546, 0.638209], "rh" -> 
           RGBColor[0.0793033, 0.50362, 0.579453], "pd" -> 
           RGBColor[0., 0.420615, 0.525231], "ag" -> 
           RGBColor[0.752941, 0.752941, 0.752941], "cd" -> 
           RGBColor[1., 0.85098, 0.560784], "in" -> 
           RGBColor[0.728371, 0.440594, 0.422196], "sn" -> 
           RGBColor[0.39799, 0.491477, 0.495586], "sb" -> 
           RGBColor[0.619608, 0.388235, 0.709804], "te" -> 
           RGBColor[0.816706, 0.451332, 0.0100947], "i" -> 
           RGBColor[0.580392, 0, 0.580392], "xe" -> 
           RGBColor[0.316906, 0.638078, 0.710252], "cs" -> 
           RGBColor[0.332803, 0.217712, 0.483666], "ba" -> 
           RGBColor[0.165935, 0.55605, 0.0796556], "la" -> 
           RGBColor[0.928084, 0.716075, 0.329427], "ce" -> 
           RGBColor[0.894824, 0.731424, 0.325131], "pr" -> 
           RGBColor[0.86523, 0.707999, 0.315261], "nd" -> 
           RGBColor[0.837836, 0.662974, 0.301635], "pm" -> 
           RGBColor[0.811992, 0.607859, 0.285626], "sm" -> 
           RGBColor[0.787563, 0.549894, 0.268279], "eu" -> 
           RGBColor[0.764628, 0.493261, 0.250405], "gd" -> 
           RGBColor[0.743177, 0.440115, 0.23269], "tb" -> 
           RGBColor[0.72281, 0.39143, 0.215783], "dy" -> 
           RGBColor[0.702434, 0.347663, 0.200392], "ho" -> 
           RGBColor[0.679962, 0.309234, 0.187368], "er" -> 
           RGBColor[0.652012, 0.276823, 0.17779], "tm" -> 
           RGBColor[0.613603, 0.251489, 0.173042], "yb" -> 
           RGBColor[0.557855, 0.234598, 0.17489], "lu" -> 
           RGBColor[0.475685, 0.227573, 0.18555], "hf" -> 
           RGBColor[0.781537, 0.717388, 0.716579], "ta" -> 
           RGBColor[0.734443, 0.544489, 0.683471], "w" -> 
           RGBColor[0.681179, 0.360409, 0.63675], "re" -> 
           RGBColor[0.605181, 0.367584, 0.556343], "os" -> 
           RGBColor[0.521806, 0.382125, 0.469204], "ir" -> 
           RGBColor[0.445624, 0.373159, 0.399069], "pt" -> 
           RGBColor[0.815686, 0.815686, 0.878431], "au" -> 
           RGBColor[1., 0.819608, 0.137255], "hg" -> 
           RGBColor[0.721569, 0.721569, 0.815686], "tl" -> 
           RGBColor[0.65098, 0.329412, 0.301961], "pb" -> 
           RGBColor[0.341176, 0.34902, 0.380392], "bi" -> 
           RGBColor[0.619608, 0.309804, 0.709804], "po" -> 
           RGBColor[0.670588, 0.360784, 0], "at" -> 
           RGBColor[0.458824, 0.309804, 0.270588], "rn" -> 
           RGBColor[0.218799, 0.516091, 0.591608], "fr" -> 
           RGBColor[0.25626, 0.0861372, 0.398932], "ra" -> 
           RGBColor[0., 0.473472, 0.04654], "ac" -> 
           RGBColor[0.322042, 0.71693, 0.988479], "th" -> 
           RGBColor[0.3608, 0.67166, 0.943003], "pa" -> 
           RGBColor[0.397469, 0.628, 0.898853], "u" -> 
           RGBColor[0.43205, 0.58595, 0.856029], "np" -> 
           RGBColor[0.464542, 0.54551, 0.814532], "pu" -> 
           RGBColor[0.494945, 0.506679, 0.774361], "am" -> 
           RGBColor[0.52326, 0.469458, 0.735517], "cm" -> 
           RGBColor[0.549486, 0.433847, 0.697999], "bk" -> 
           RGBColor[0.573624, 0.399845, 0.661808], "cf" -> 
           RGBColor[0.595673, 0.367454, 0.626942], "es" -> 
           RGBColor[0.615633, 0.336672, 0.593404], "fm" -> 
           RGBColor[0.633505, 0.307499, 0.561191], "md" -> 
           RGBColor[0.649288, 0.279937, 0.530305], "no" -> 
           RGBColor[0.662982, 0.253984, 0.500746], "lr" -> 
           RGBColor[0.674588, 0.22964, 0.472513], "rf" -> 
           RGBColor[0.684106, 0.206907, 0.445606], "db" -> 
           RGBColor[0.691534, 0.185783, 0.420025], "sg" -> 
           RGBColor[0.696874, 0.166269, 0.395772], "bh" -> 
           RGBColor[0.700126, 0.148365, 0.372844], "hs" -> 
           RGBColor[0.701289, 0.13207, 0.351243], "mt" -> 
           RGBColor[0.700363, 0.117385, 0.330968], "ds" -> 
           RGBColor[0.697348, 0.10431, 0.31202], "rg" -> 
           RGBColor[0.692245, 0.0928444, 0.294398], "cn" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "nh" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "fl" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "mc" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "lv" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "ts" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "og" -> 
           RGBColor[0.635401, 0.0528, 0.226184], "uub" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "uut" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "uuq" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "uup" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "uuh" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "uus" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "uuo" -> 
           RGBColor[0.635401, 0.0528, 0.226184]}]]& ][0.85], 
       ColorDataFunction[
       "Atoms", 
        "Named", {{
         "H", "He", "Li", "Be", "B", "C", "N", "O", "F", "Ne", "Na", "Mg", 
          "Al", "Si", "P", "S", "Cl", "Ar", "K", "Ca", "Sc", "Ti", "V", "Cr", 
          "Mn", "Fe", "Co", "Ni", "Cu", "Zn", "Ga", "Ge", "As", "Se", "Br", 
          "Kr", "Rb", "Sr", "Y", "Zr", "Nb", "Mo", "Tc", "Ru", "Rh", "Pd", 
          "Ag", "Cd", "In", "Sn", "Sb", "Te", "I", "Xe", "Cs", "Ba", "La", 
          "Ce", "Pr", "Nd", "Pm", "Sm", "Eu", "Gd", "Tb", "Dy", "Ho", "Er", 
          "Tm", "Yb", "Lu", "Hf", "Ta", "W", "Re", "Os", "Ir", "Pt", "Au", 
          "Hg", "Tl", "Pb", "Bi", "Po", "At", "Rn", "Fr", "Ra", "Ac", "Th", 
          "Pa", "U", "Np", "Pu", "Am", "Cm", "Bk", "Cf", "Es", "Fm", "Md", 
          "No", "Lr", "Rf", "Db", "Sg", "Bh", "Hs", "Mt", "Ds", "Rg", "Cn", 
          "Nh", "Fl", "Mc", "Lv", "Ts", "Og", "Uub", "Uut", "Uuq", "Uup", 
          "Uuh", "Uus", "Uuo"}, {
         "h", "he", "li", "be", "b", "c", "n", "o", "f", "ne", "na", "mg", 
          "al", "si", "p", "s", "cl", "ar", "k", "ca", "sc", "ti", "v", "cr", 
          "mn", "fe", "co", "ni", "cu", "zn", "ga", "ge", "as", "se", "br", 
          "kr", "rb", "sr", "y", "zr", "nb", "mo", "tc", "ru", "rh", "pd", 
          "ag", "cd", "in", "sn", "sb", "te", "i", "xe", "cs", "ba", "la", 
          "ce", "pr", "nd", "pm", "sm", "eu", "gd", "tb", "dy", "ho", "er", 
          "tm", "yb", "lu", "hf", "ta", "w", "re", "os", "ir", "pt", "au", 
          "hg", "tl", "pb", "bi", "po", "at", "rn", "fr", "ra", "ac", "th", 
          "pa", "u", "np", "pu", "am", "cm", "bk", "cf", "es", "fm", "md", 
          "no", "lr", "rf", "db", "sg", "bh", "hs", "mt", "ds", "rg", "cn", 
          "nh", "fl", "mc", "lv", "ts", "og", "uub", "uut", "uuq", "uup", 
          "uuh", "uus", "uuo"}}, Replace[#, 
         Dispatch[{
          "h" -> RGBColor[0.65, 0.7, 0.7], "he" -> RGBColor[0.836713, 1., 1.],
            "li" -> RGBColor[0.799435, 0.543572, 0.997559], "be" -> 
           RGBColor[0.770565, 0.964309, 0.0442359], "b" -> 
           RGBColor[1., 0.709804, 0.709804], "c" -> RGBColor[0.4, 0.4, 0.4], 
           "n" -> RGBColor[0.291989, 0.437977, 0.888609], "o" -> 
           RGBColor[0.800498, 0.201504, 0.192061], "f" -> 
           RGBColor[0.578462, 0.85539, 0.408855], "ne" -> 
           RGBColor[0.677263, 0.928423, 0.955287], "na" -> 
           RGBColor[0.658708, 0.492173, 0.842842], "mg" -> 
           RGBColor[0.628274, 0.850553, 0.0782731], "al" -> 
           RGBColor[0.8913, 0.631904, 0.627399], "si" -> 
           RGBColor[0.941176, 0.784314, 0.627451], "p" -> 
           RGBColor[1., 0.501961, 0], "s" -> 
           RGBColor[0.90443, 0.97015, 0.13504], "cl" -> 
           RGBColor[0.412698, 0.932689, 0.166398], "ar" -> 
           RGBColor[0.546138, 0.844244, 0.892092], "k" -> 
           RGBColor[0.534026, 0.420729, 0.705621], "ca" -> 
           RGBColor[0.480072, 0.744591, 0.0955222], "sc" -> 
           RGBColor[0.901961, 0.901961, 0.901961], "ti" -> 
           RGBColor[0.74902, 0.760784, 0.780392], "v" -> 
           RGBColor[0.65098, 0.65098, 0.670588], "cr" -> 
           RGBColor[0.541176, 0.6, 0.780392], "mn" -> 
           RGBColor[0.611765, 0.478431, 0.780392], "fe" -> 
           RGBColor[0.878431, 0.4, 0.2], "co" -> 
           RGBColor[0.941176, 0.564706, 0.627451], "ni" -> 
           RGBColor[0.313725, 0.815686, 0.313725], "cu" -> 
           RGBColor[0.784314, 0.501961, 0.2], "zn" -> 
           RGBColor[0.490196, 0.501961, 0.690196], "ga" -> 
           RGBColor[0.800757, 0.542666, 0.533513], "ge" -> 
           RGBColor[0.60508, 0.632465, 0.576489], "as" -> 
           RGBColor[0.741176, 0.501961, 0.890196], "se" -> 
           RGBColor[0.917248, 0.657833, 0.0706628], "br" -> 
           RGBColor[0.58847, 0.22163, 0.16064], "kr" -> 
           RGBColor[0.426019, 0.747462, 0.810413], "rb" -> 
           RGBColor[0.425391, 0.329242, 0.585895], "sr" -> 
           RGBColor[0.325959, 0.646423, 0.095983], "y" -> 
           RGBColor[0.531014, 1., 1.], "zr" -> 
           RGBColor[0.458599, 0.917466, 0.918573], "nb" -> 
           RGBColor[0.385036, 0.834854, 0.841681], "mo" -> 
           RGBColor[0.310325, 0.752163, 0.769323], "tc" -> 
           RGBColor[0.234466, 0.669394, 0.701499], "ru" -> 
           RGBColor[0.157459, 0.586546, 0.638209], "rh" -> 
           RGBColor[0.0793033, 0.50362, 0.579453], "pd" -> 
           RGBColor[0., 0.420615, 0.525231], "ag" -> 
           RGBColor[0.752941, 0.752941, 0.752941], "cd" -> 
           RGBColor[1., 0.85098, 0.560784], "in" -> 
           RGBColor[0.728371, 0.440594, 0.422196], "sn" -> 
           RGBColor[0.39799, 0.491477, 0.495586], "sb" -> 
           RGBColor[0.619608, 0.388235, 0.709804], "te" -> 
           RGBColor[0.816706, 0.451332, 0.0100947], "i" -> 
           RGBColor[0.580392, 0, 0.580392], "xe" -> 
           RGBColor[0.316906, 0.638078, 0.710252], "cs" -> 
           RGBColor[0.332803, 0.217712, 0.483666], "ba" -> 
           RGBColor[0.165935, 0.55605, 0.0796556], "la" -> 
           RGBColor[0.928084, 0.716075, 0.329427], "ce" -> 
           RGBColor[0.894824, 0.731424, 0.325131], "pr" -> 
           RGBColor[0.86523, 0.707999, 0.315261], "nd" -> 
           RGBColor[0.837836, 0.662974, 0.301635], "pm" -> 
           RGBColor[0.811992, 0.607859, 0.285626], "sm" -> 
           RGBColor[0.787563, 0.549894, 0.268279], "eu" -> 
           RGBColor[0.764628, 0.493261, 0.250405], "gd" -> 
           RGBColor[0.743177, 0.440115, 0.23269], "tb" -> 
           RGBColor[0.72281, 0.39143, 0.215783], "dy" -> 
           RGBColor[0.702434, 0.347663, 0.200392], "ho" -> 
           RGBColor[0.679962, 0.309234, 0.187368], "er" -> 
           RGBColor[0.652012, 0.276823, 0.17779], "tm" -> 
           RGBColor[0.613603, 0.251489, 0.173042], "yb" -> 
           RGBColor[0.557855, 0.234598, 0.17489], "lu" -> 
           RGBColor[0.475685, 0.227573, 0.18555], "hf" -> 
           RGBColor[0.781537, 0.717388, 0.716579], "ta" -> 
           RGBColor[0.734443, 0.544489, 0.683471], "w" -> 
           RGBColor[0.681179, 0.360409, 0.63675], "re" -> 
           RGBColor[0.605181, 0.367584, 0.556343], "os" -> 
           RGBColor[0.521806, 0.382125, 0.469204], "ir" -> 
           RGBColor[0.445624, 0.373159, 0.399069], "pt" -> 
           RGBColor[0.815686, 0.815686, 0.878431], "au" -> 
           RGBColor[1., 0.819608, 0.137255], "hg" -> 
           RGBColor[0.721569, 0.721569, 0.815686], "tl" -> 
           RGBColor[0.65098, 0.329412, 0.301961], "pb" -> 
           RGBColor[0.341176, 0.34902, 0.380392], "bi" -> 
           RGBColor[0.619608, 0.309804, 0.709804], "po" -> 
           RGBColor[0.670588, 0.360784, 0], "at" -> 
           RGBColor[0.458824, 0.309804, 0.270588], "rn" -> 
           RGBColor[0.218799, 0.516091, 0.591608], "fr" -> 
           RGBColor[0.25626, 0.0861372, 0.398932], "ra" -> 
           RGBColor[0., 0.473472, 0.04654], "ac" -> 
           RGBColor[0.322042, 0.71693, 0.988479], "th" -> 
           RGBColor[0.3608, 0.67166, 0.943003], "pa" -> 
           RGBColor[0.397469, 0.628, 0.898853], "u" -> 
           RGBColor[0.43205, 0.58595, 0.856029], "np" -> 
           RGBColor[0.464542, 0.54551, 0.814532], "pu" -> 
           RGBColor[0.494945, 0.506679, 0.774361], "am" -> 
           RGBColor[0.52326, 0.469458, 0.735517], "cm" -> 
           RGBColor[0.549486, 0.433847, 0.697999], "bk" -> 
           RGBColor[0.573624, 0.399845, 0.661808], "cf" -> 
           RGBColor[0.595673, 0.367454, 0.626942], "es" -> 
           RGBColor[0.615633, 0.336672, 0.593404], "fm" -> 
           RGBColor[0.633505, 0.307499, 0.561191], "md" -> 
           RGBColor[0.649288, 0.279937, 0.530305], "no" -> 
           RGBColor[0.662982, 0.253984, 0.500746], "lr" -> 
           RGBColor[0.674588, 0.22964, 0.472513], "rf" -> 
           RGBColor[0.684106, 0.206907, 0.445606], "db" -> 
           RGBColor[0.691534, 0.185783, 0.420025], "sg" -> 
           RGBColor[0.696874, 0.166269, 0.395772], "bh" -> 
           RGBColor[0.700126, 0.148365, 0.372844], "hs" -> 
           RGBColor[0.701289, 0.13207, 0.351243], "mt" -> 
           RGBColor[0.700363, 0.117385, 0.330968], "ds" -> 
           RGBColor[0.697348, 0.10431, 0.31202], "rg" -> 
           RGBColor[0.692245, 0.0928444, 0.294398], "cn" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "nh" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "fl" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "mc" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "lv" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "ts" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "og" -> 
           RGBColor[0.635401, 0.0528, 0.226184], "uub" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "uut" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "uuq" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "uup" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "uuh" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "uus" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "uuo" -> 
           RGBColor[0.635401, 0.0528, 0.226184]}]]& ][0.85], 
       ColorDataFunction[
       "Atoms", 
        "Named", {{
         "H", "He", "Li", "Be", "B", "C", "N", "O", "F", "Ne", "Na", "Mg", 
          "Al", "Si", "P", "S", "Cl", "Ar", "K", "Ca", "Sc", "Ti", "V", "Cr", 
          "Mn", "Fe", "Co", "Ni", "Cu", "Zn", "Ga", "Ge", "As", "Se", "Br", 
          "Kr", "Rb", "Sr", "Y", "Zr", "Nb", "Mo", "Tc", "Ru", "Rh", "Pd", 
          "Ag", "Cd", "In", "Sn", "Sb", "Te", "I", "Xe", "Cs", "Ba", "La", 
          "Ce", "Pr", "Nd", "Pm", "Sm", "Eu", "Gd", "Tb", "Dy", "Ho", "Er", 
          "Tm", "Yb", "Lu", "Hf", "Ta", "W", "Re", "Os", "Ir", "Pt", "Au", 
          "Hg", "Tl", "Pb", "Bi", "Po", "At", "Rn", "Fr", "Ra", "Ac", "Th", 
          "Pa", "U", "Np", "Pu", "Am", "Cm", "Bk", "Cf", "Es", "Fm", "Md", 
          "No", "Lr", "Rf", "Db", "Sg", "Bh", "Hs", "Mt", "Ds", "Rg", "Cn", 
          "Nh", "Fl", "Mc", "Lv", "Ts", "Og", "Uub", "Uut", "Uuq", "Uup", 
          "Uuh", "Uus", "Uuo"}, {
         "h", "he", "li", "be", "b", "c", "n", "o", "f", "ne", "na", "mg", 
          "al", "si", "p", "s", "cl", "ar", "k", "ca", "sc", "ti", "v", "cr", 
          "mn", "fe", "co", "ni", "cu", "zn", "ga", "ge", "as", "se", "br", 
          "kr", "rb", "sr", "y", "zr", "nb", "mo", "tc", "ru", "rh", "pd", 
          "ag", "cd", "in", "sn", "sb", "te", "i", "xe", "cs", "ba", "la", 
          "ce", "pr", "nd", "pm", "sm", "eu", "gd", "tb", "dy", "ho", "er", 
          "tm", "yb", "lu", "hf", "ta", "w", "re", "os", "ir", "pt", "au", 
          "hg", "tl", "pb", "bi", "po", "at", "rn", "fr", "ra", "ac", "th", 
          "pa", "u", "np", "pu", "am", "cm", "bk", "cf", "es", "fm", "md", 
          "no", "lr", "rf", "db", "sg", "bh", "hs", "mt", "ds", "rg", "cn", 
          "nh", "fl", "mc", "lv", "ts", "og", "uub", "uut", "uuq", "uup", 
          "uuh", "uus", "uuo"}}, Replace[#, 
         Dispatch[{
          "h" -> RGBColor[0.65, 0.7, 0.7], "he" -> RGBColor[0.836713, 1., 1.],
            "li" -> RGBColor[0.799435, 0.543572, 0.997559], "be" -> 
           RGBColor[0.770565, 0.964309, 0.0442359], "b" -> 
           RGBColor[1., 0.709804, 0.709804], "c" -> RGBColor[0.4, 0.4, 0.4], 
           "n" -> RGBColor[0.291989, 0.437977, 0.888609], "o" -> 
           RGBColor[0.800498, 0.201504, 0.192061], "f" -> 
           RGBColor[0.578462, 0.85539, 0.408855], "ne" -> 
           RGBColor[0.677263, 0.928423, 0.955287], "na" -> 
           RGBColor[0.658708, 0.492173, 0.842842], "mg" -> 
           RGBColor[0.628274, 0.850553, 0.0782731], "al" -> 
           RGBColor[0.8913, 0.631904, 0.627399], "si" -> 
           RGBColor[0.941176, 0.784314, 0.627451], "p" -> 
           RGBColor[1., 0.501961, 0], "s" -> 
           RGBColor[0.90443, 0.97015, 0.13504], "cl" -> 
           RGBColor[0.412698, 0.932689, 0.166398], "ar" -> 
           RGBColor[0.546138, 0.844244, 0.892092], "k" -> 
           RGBColor[0.534026, 0.420729, 0.705621], "ca" -> 
           RGBColor[0.480072, 0.744591, 0.0955222], "sc" -> 
           RGBColor[0.901961, 0.901961, 0.901961], "ti" -> 
           RGBColor[0.74902, 0.760784, 0.780392], "v" -> 
           RGBColor[0.65098, 0.65098, 0.670588], "cr" -> 
           RGBColor[0.541176, 0.6, 0.780392], "mn" -> 
           RGBColor[0.611765, 0.478431, 0.780392], "fe" -> 
           RGBColor[0.878431, 0.4, 0.2], "co" -> 
           RGBColor[0.941176, 0.564706, 0.627451], "ni" -> 
           RGBColor[0.313725, 0.815686, 0.313725], "cu" -> 
           RGBColor[0.784314, 0.501961, 0.2], "zn" -> 
           RGBColor[0.490196, 0.501961, 0.690196], "ga" -> 
           RGBColor[0.800757, 0.542666, 0.533513], "ge" -> 
           RGBColor[0.60508, 0.632465, 0.576489], "as" -> 
           RGBColor[0.741176, 0.501961, 0.890196], "se" -> 
           RGBColor[0.917248, 0.657833, 0.0706628], "br" -> 
           RGBColor[0.58847, 0.22163, 0.16064], "kr" -> 
           RGBColor[0.426019, 0.747462, 0.810413], "rb" -> 
           RGBColor[0.425391, 0.329242, 0.585895], "sr" -> 
           RGBColor[0.325959, 0.646423, 0.095983], "y" -> 
           RGBColor[0.531014, 1., 1.], "zr" -> 
           RGBColor[0.458599, 0.917466, 0.918573], "nb" -> 
           RGBColor[0.385036, 0.834854, 0.841681], "mo" -> 
           RGBColor[0.310325, 0.752163, 0.769323], "tc" -> 
           RGBColor[0.234466, 0.669394, 0.701499], "ru" -> 
           RGBColor[0.157459, 0.586546, 0.638209], "rh" -> 
           RGBColor[0.0793033, 0.50362, 0.579453], "pd" -> 
           RGBColor[0., 0.420615, 0.525231], "ag" -> 
           RGBColor[0.752941, 0.752941, 0.752941], "cd" -> 
           RGBColor[1., 0.85098, 0.560784], "in" -> 
           RGBColor[0.728371, 0.440594, 0.422196], "sn" -> 
           RGBColor[0.39799, 0.491477, 0.495586], "sb" -> 
           RGBColor[0.619608, 0.388235, 0.709804], "te" -> 
           RGBColor[0.816706, 0.451332, 0.0100947], "i" -> 
           RGBColor[0.580392, 0, 0.580392], "xe" -> 
           RGBColor[0.316906, 0.638078, 0.710252], "cs" -> 
           RGBColor[0.332803, 0.217712, 0.483666], "ba" -> 
           RGBColor[0.165935, 0.55605, 0.0796556], "la" -> 
           RGBColor[0.928084, 0.716075, 0.329427], "ce" -> 
           RGBColor[0.894824, 0.731424, 0.325131], "pr" -> 
           RGBColor[0.86523, 0.707999, 0.315261], "nd" -> 
           RGBColor[0.837836, 0.662974, 0.301635], "pm" -> 
           RGBColor[0.811992, 0.607859, 0.285626], "sm" -> 
           RGBColor[0.787563, 0.549894, 0.268279], "eu" -> 
           RGBColor[0.764628, 0.493261, 0.250405], "gd" -> 
           RGBColor[0.743177, 0.440115, 0.23269], "tb" -> 
           RGBColor[0.72281, 0.39143, 0.215783], "dy" -> 
           RGBColor[0.702434, 0.347663, 0.200392], "ho" -> 
           RGBColor[0.679962, 0.309234, 0.187368], "er" -> 
           RGBColor[0.652012, 0.276823, 0.17779], "tm" -> 
           RGBColor[0.613603, 0.251489, 0.173042], "yb" -> 
           RGBColor[0.557855, 0.234598, 0.17489], "lu" -> 
           RGBColor[0.475685, 0.227573, 0.18555], "hf" -> 
           RGBColor[0.781537, 0.717388, 0.716579], "ta" -> 
           RGBColor[0.734443, 0.544489, 0.683471], "w" -> 
           RGBColor[0.681179, 0.360409, 0.63675], "re" -> 
           RGBColor[0.605181, 0.367584, 0.556343], "os" -> 
           RGBColor[0.521806, 0.382125, 0.469204], "ir" -> 
           RGBColor[0.445624, 0.373159, 0.399069], "pt" -> 
           RGBColor[0.815686, 0.815686, 0.878431], "au" -> 
           RGBColor[1., 0.819608, 0.137255], "hg" -> 
           RGBColor[0.721569, 0.721569, 0.815686], "tl" -> 
           RGBColor[0.65098, 0.329412, 0.301961], "pb" -> 
           RGBColor[0.341176, 0.34902, 0.380392], "bi" -> 
           RGBColor[0.619608, 0.309804, 0.709804], "po" -> 
           RGBColor[0.670588, 0.360784, 0], "at" -> 
           RGBColor[0.458824, 0.309804, 0.270588], "rn" -> 
           RGBColor[0.218799, 0.516091, 0.591608], "fr" -> 
           RGBColor[0.25626, 0.0861372, 0.398932], "ra" -> 
           RGBColor[0., 0.473472, 0.04654], "ac" -> 
           RGBColor[0.322042, 0.71693, 0.988479], "th" -> 
           RGBColor[0.3608, 0.67166, 0.943003], "pa" -> 
           RGBColor[0.397469, 0.628, 0.898853], "u" -> 
           RGBColor[0.43205, 0.58595, 0.856029], "np" -> 
           RGBColor[0.464542, 0.54551, 0.814532], "pu" -> 
           RGBColor[0.494945, 0.506679, 0.774361], "am" -> 
           RGBColor[0.52326, 0.469458, 0.735517], "cm" -> 
           RGBColor[0.549486, 0.433847, 0.697999], "bk" -> 
           RGBColor[0.573624, 0.399845, 0.661808], "cf" -> 
           RGBColor[0.595673, 0.367454, 0.626942], "es" -> 
           RGBColor[0.615633, 0.336672, 0.593404], "fm" -> 
           RGBColor[0.633505, 0.307499, 0.561191], "md" -> 
           RGBColor[0.649288, 0.279937, 0.530305], "no" -> 
           RGBColor[0.662982, 0.253984, 0.500746], "lr" -> 
           RGBColor[0.674588, 0.22964, 0.472513], "rf" -> 
           RGBColor[0.684106, 0.206907, 0.445606], "db" -> 
           RGBColor[0.691534, 0.185783, 0.420025], "sg" -> 
           RGBColor[0.696874, 0.166269, 0.395772], "bh" -> 
           RGBColor[0.700126, 0.148365, 0.372844], "hs" -> 
           RGBColor[0.701289, 0.13207, 0.351243], "mt" -> 
           RGBColor[0.700363, 0.117385, 0.330968], "ds" -> 
           RGBColor[0.697348, 0.10431, 0.31202], "rg" -> 
           RGBColor[0.692245, 0.0928444, 0.294398], "cn" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "nh" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "fl" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "mc" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "lv" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "ts" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "og" -> 
           RGBColor[0.635401, 0.0528, 0.226184], "uub" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "uut" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "uuq" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "uup" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "uuh" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "uus" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "uuo" -> 
           RGBColor[0.635401, 0.0528, 0.226184]}]]& ][0.85], 
       ColorDataFunction[
       "Atoms", 
        "Named", {{
         "H", "He", "Li", "Be", "B", "C", "N", "O", "F", "Ne", "Na", "Mg", 
          "Al", "Si", "P", "S", "Cl", "Ar", "K", "Ca", "Sc", "Ti", "V", "Cr", 
          "Mn", "Fe", "Co", "Ni", "Cu", "Zn", "Ga", "Ge", "As", "Se", "Br", 
          "Kr", "Rb", "Sr", "Y", "Zr", "Nb", "Mo", "Tc", "Ru", "Rh", "Pd", 
          "Ag", "Cd", "In", "Sn", "Sb", "Te", "I", "Xe", "Cs", "Ba", "La", 
          "Ce", "Pr", "Nd", "Pm", "Sm", "Eu", "Gd", "Tb", "Dy", "Ho", "Er", 
          "Tm", "Yb", "Lu", "Hf", "Ta", "W", "Re", "Os", "Ir", "Pt", "Au", 
          "Hg", "Tl", "Pb", "Bi", "Po", "At", "Rn", "Fr", "Ra", "Ac", "Th", 
          "Pa", "U", "Np", "Pu", "Am", "Cm", "Bk", "Cf", "Es", "Fm", "Md", 
          "No", "Lr", "Rf", "Db", "Sg", "Bh", "Hs", "Mt", "Ds", "Rg", "Cn", 
          "Nh", "Fl", "Mc", "Lv", "Ts", "Og", "Uub", "Uut", "Uuq", "Uup", 
          "Uuh", "Uus", "Uuo"}, {
         "h", "he", "li", "be", "b", "c", "n", "o", "f", "ne", "na", "mg", 
          "al", "si", "p", "s", "cl", "ar", "k", "ca", "sc", "ti", "v", "cr", 
          "mn", "fe", "co", "ni", "cu", "zn", "ga", "ge", "as", "se", "br", 
          "kr", "rb", "sr", "y", "zr", "nb", "mo", "tc", "ru", "rh", "pd", 
          "ag", "cd", "in", "sn", "sb", "te", "i", "xe", "cs", "ba", "la", 
          "ce", "pr", "nd", "pm", "sm", "eu", "gd", "tb", "dy", "ho", "er", 
          "tm", "yb", "lu", "hf", "ta", "w", "re", "os", "ir", "pt", "au", 
          "hg", "tl", "pb", "bi", "po", "at", "rn", "fr", "ra", "ac", "th", 
          "pa", "u", "np", "pu", "am", "cm", "bk", "cf", "es", "fm", "md", 
          "no", "lr", "rf", "db", "sg", "bh", "hs", "mt", "ds", "rg", "cn", 
          "nh", "fl", "mc", "lv", "ts", "og", "uub", "uut", "uuq", "uup", 
          "uuh", "uus", "uuo"}}, Replace[#, 
         Dispatch[{
          "h" -> RGBColor[0.65, 0.7, 0.7], "he" -> RGBColor[0.836713, 1., 1.],
            "li" -> RGBColor[0.799435, 0.543572, 0.997559], "be" -> 
           RGBColor[0.770565, 0.964309, 0.0442359], "b" -> 
           RGBColor[1., 0.709804, 0.709804], "c" -> RGBColor[0.4, 0.4, 0.4], 
           "n" -> RGBColor[0.291989, 0.437977, 0.888609], "o" -> 
           RGBColor[0.800498, 0.201504, 0.192061], "f" -> 
           RGBColor[0.578462, 0.85539, 0.408855], "ne" -> 
           RGBColor[0.677263, 0.928423, 0.955287], "na" -> 
           RGBColor[0.658708, 0.492173, 0.842842], "mg" -> 
           RGBColor[0.628274, 0.850553, 0.0782731], "al" -> 
           RGBColor[0.8913, 0.631904, 0.627399], "si" -> 
           RGBColor[0.941176, 0.784314, 0.627451], "p" -> 
           RGBColor[1., 0.501961, 0], "s" -> 
           RGBColor[0.90443, 0.97015, 0.13504], "cl" -> 
           RGBColor[0.412698, 0.932689, 0.166398], "ar" -> 
           RGBColor[0.546138, 0.844244, 0.892092], "k" -> 
           RGBColor[0.534026, 0.420729, 0.705621], "ca" -> 
           RGBColor[0.480072, 0.744591, 0.0955222], "sc" -> 
           RGBColor[0.901961, 0.901961, 0.901961], "ti" -> 
           RGBColor[0.74902, 0.760784, 0.780392], "v" -> 
           RGBColor[0.65098, 0.65098, 0.670588], "cr" -> 
           RGBColor[0.541176, 0.6, 0.780392], "mn" -> 
           RGBColor[0.611765, 0.478431, 0.780392], "fe" -> 
           RGBColor[0.878431, 0.4, 0.2], "co" -> 
           RGBColor[0.941176, 0.564706, 0.627451], "ni" -> 
           RGBColor[0.313725, 0.815686, 0.313725], "cu" -> 
           RGBColor[0.784314, 0.501961, 0.2], "zn" -> 
           RGBColor[0.490196, 0.501961, 0.690196], "ga" -> 
           RGBColor[0.800757, 0.542666, 0.533513], "ge" -> 
           RGBColor[0.60508, 0.632465, 0.576489], "as" -> 
           RGBColor[0.741176, 0.501961, 0.890196], "se" -> 
           RGBColor[0.917248, 0.657833, 0.0706628], "br" -> 
           RGBColor[0.58847, 0.22163, 0.16064], "kr" -> 
           RGBColor[0.426019, 0.747462, 0.810413], "rb" -> 
           RGBColor[0.425391, 0.329242, 0.585895], "sr" -> 
           RGBColor[0.325959, 0.646423, 0.095983], "y" -> 
           RGBColor[0.531014, 1., 1.], "zr" -> 
           RGBColor[0.458599, 0.917466, 0.918573], "nb" -> 
           RGBColor[0.385036, 0.834854, 0.841681], "mo" -> 
           RGBColor[0.310325, 0.752163, 0.769323], "tc" -> 
           RGBColor[0.234466, 0.669394, 0.701499], "ru" -> 
           RGBColor[0.157459, 0.586546, 0.638209], "rh" -> 
           RGBColor[0.0793033, 0.50362, 0.579453], "pd" -> 
           RGBColor[0., 0.420615, 0.525231], "ag" -> 
           RGBColor[0.752941, 0.752941, 0.752941], "cd" -> 
           RGBColor[1., 0.85098, 0.560784], "in" -> 
           RGBColor[0.728371, 0.440594, 0.422196], "sn" -> 
           RGBColor[0.39799, 0.491477, 0.495586], "sb" -> 
           RGBColor[0.619608, 0.388235, 0.709804], "te" -> 
           RGBColor[0.816706, 0.451332, 0.0100947], "i" -> 
           RGBColor[0.580392, 0, 0.580392], "xe" -> 
           RGBColor[0.316906, 0.638078, 0.710252], "cs" -> 
           RGBColor[0.332803, 0.217712, 0.483666], "ba" -> 
           RGBColor[0.165935, 0.55605, 0.0796556], "la" -> 
           RGBColor[0.928084, 0.716075, 0.329427], "ce" -> 
           RGBColor[0.894824, 0.731424, 0.325131], "pr" -> 
           RGBColor[0.86523, 0.707999, 0.315261], "nd" -> 
           RGBColor[0.837836, 0.662974, 0.301635], "pm" -> 
           RGBColor[0.811992, 0.607859, 0.285626], "sm" -> 
           RGBColor[0.787563, 0.549894, 0.268279], "eu" -> 
           RGBColor[0.764628, 0.493261, 0.250405], "gd" -> 
           RGBColor[0.743177, 0.440115, 0.23269], "tb" -> 
           RGBColor[0.72281, 0.39143, 0.215783], "dy" -> 
           RGBColor[0.702434, 0.347663, 0.200392], "ho" -> 
           RGBColor[0.679962, 0.309234, 0.187368], "er" -> 
           RGBColor[0.652012, 0.276823, 0.17779], "tm" -> 
           RGBColor[0.613603, 0.251489, 0.173042], "yb" -> 
           RGBColor[0.557855, 0.234598, 0.17489], "lu" -> 
           RGBColor[0.475685, 0.227573, 0.18555], "hf" -> 
           RGBColor[0.781537, 0.717388, 0.716579], "ta" -> 
           RGBColor[0.734443, 0.544489, 0.683471], "w" -> 
           RGBColor[0.681179, 0.360409, 0.63675], "re" -> 
           RGBColor[0.605181, 0.367584, 0.556343], "os" -> 
           RGBColor[0.521806, 0.382125, 0.469204], "ir" -> 
           RGBColor[0.445624, 0.373159, 0.399069], "pt" -> 
           RGBColor[0.815686, 0.815686, 0.878431], "au" -> 
           RGBColor[1., 0.819608, 0.137255], "hg" -> 
           RGBColor[0.721569, 0.721569, 0.815686], "tl" -> 
           RGBColor[0.65098, 0.329412, 0.301961], "pb" -> 
           RGBColor[0.341176, 0.34902, 0.380392], "bi" -> 
           RGBColor[0.619608, 0.309804, 0.709804], "po" -> 
           RGBColor[0.670588, 0.360784, 0], "at" -> 
           RGBColor[0.458824, 0.309804, 0.270588], "rn" -> 
           RGBColor[0.218799, 0.516091, 0.591608], "fr" -> 
           RGBColor[0.25626, 0.0861372, 0.398932], "ra" -> 
           RGBColor[0., 0.473472, 0.04654], "ac" -> 
           RGBColor[0.322042, 0.71693, 0.988479], "th" -> 
           RGBColor[0.3608, 0.67166, 0.943003], "pa" -> 
           RGBColor[0.397469, 0.628, 0.898853], "u" -> 
           RGBColor[0.43205, 0.58595, 0.856029], "np" -> 
           RGBColor[0.464542, 0.54551, 0.814532], "pu" -> 
           RGBColor[0.494945, 0.506679, 0.774361], "am" -> 
           RGBColor[0.52326, 0.469458, 0.735517], "cm" -> 
           RGBColor[0.549486, 0.433847, 0.697999], "bk" -> 
           RGBColor[0.573624, 0.399845, 0.661808], "cf" -> 
           RGBColor[0.595673, 0.367454, 0.626942], "es" -> 
           RGBColor[0.615633, 0.336672, 0.593404], "fm" -> 
           RGBColor[0.633505, 0.307499, 0.561191], "md" -> 
           RGBColor[0.649288, 0.279937, 0.530305], "no" -> 
           RGBColor[0.662982, 0.253984, 0.500746], "lr" -> 
           RGBColor[0.674588, 0.22964, 0.472513], "rf" -> 
           RGBColor[0.684106, 0.206907, 0.445606], "db" -> 
           RGBColor[0.691534, 0.185783, 0.420025], "sg" -> 
           RGBColor[0.696874, 0.166269, 0.395772], "bh" -> 
           RGBColor[0.700126, 0.148365, 0.372844], "hs" -> 
           RGBColor[0.701289, 0.13207, 0.351243], "mt" -> 
           RGBColor[0.700363, 0.117385, 0.330968], "ds" -> 
           RGBColor[0.697348, 0.10431, 0.31202], "rg" -> 
           RGBColor[0.692245, 0.0928444, 0.294398], "cn" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "nh" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "fl" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "mc" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "lv" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "ts" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "og" -> 
           RGBColor[0.635401, 0.0528, 0.226184], "uub" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "uut" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "uuq" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "uup" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "uuh" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "uus" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "uuo" -> 
           RGBColor[0.635401, 0.0528, 0.226184]}]]& ][0.85], 
       ColorDataFunction[
       "Atoms", 
        "Named", {{
         "H", "He", "Li", "Be", "B", "C", "N", "O", "F", "Ne", "Na", "Mg", 
          "Al", "Si", "P", "S", "Cl", "Ar", "K", "Ca", "Sc", "Ti", "V", "Cr", 
          "Mn", "Fe", "Co", "Ni", "Cu", "Zn", "Ga", "Ge", "As", "Se", "Br", 
          "Kr", "Rb", "Sr", "Y", "Zr", "Nb", "Mo", "Tc", "Ru", "Rh", "Pd", 
          "Ag", "Cd", "In", "Sn", "Sb", "Te", "I", "Xe", "Cs", "Ba", "La", 
          "Ce", "Pr", "Nd", "Pm", "Sm", "Eu", "Gd", "Tb", "Dy", "Ho", "Er", 
          "Tm", "Yb", "Lu", "Hf", "Ta", "W", "Re", "Os", "Ir", "Pt", "Au", 
          "Hg", "Tl", "Pb", "Bi", "Po", "At", "Rn", "Fr", "Ra", "Ac", "Th", 
          "Pa", "U", "Np", "Pu", "Am", "Cm", "Bk", "Cf", "Es", "Fm", "Md", 
          "No", "Lr", "Rf", "Db", "Sg", "Bh", "Hs", "Mt", "Ds", "Rg", "Cn", 
          "Nh", "Fl", "Mc", "Lv", "Ts", "Og", "Uub", "Uut", "Uuq", "Uup", 
          "Uuh", "Uus", "Uuo"}, {
         "h", "he", "li", "be", "b", "c", "n", "o", "f", "ne", "na", "mg", 
          "al", "si", "p", "s", "cl", "ar", "k", "ca", "sc", "ti", "v", "cr", 
          "mn", "fe", "co", "ni", "cu", "zn", "ga", "ge", "as", "se", "br", 
          "kr", "rb", "sr", "y", "zr", "nb", "mo", "tc", "ru", "rh", "pd", 
          "ag", "cd", "in", "sn", "sb", "te", "i", "xe", "cs", "ba", "la", 
          "ce", "pr", "nd", "pm", "sm", "eu", "gd", "tb", "dy", "ho", "er", 
          "tm", "yb", "lu", "hf", "ta", "w", "re", "os", "ir", "pt", "au", 
          "hg", "tl", "pb", "bi", "po", "at", "rn", "fr", "ra", "ac", "th", 
          "pa", "u", "np", "pu", "am", "cm", "bk", "cf", "es", "fm", "md", 
          "no", "lr", "rf", "db", "sg", "bh", "hs", "mt", "ds", "rg", "cn", 
          "nh", "fl", "mc", "lv", "ts", "og", "uub", "uut", "uuq", "uup", 
          "uuh", "uus", "uuo"}}, Replace[#, 
         Dispatch[{
          "h" -> RGBColor[0.65, 0.7, 0.7], "he" -> RGBColor[0.836713, 1., 1.],
            "li" -> RGBColor[0.799435, 0.543572, 0.997559], "be" -> 
           RGBColor[0.770565, 0.964309, 0.0442359], "b" -> 
           RGBColor[1., 0.709804, 0.709804], "c" -> RGBColor[0.4, 0.4, 0.4], 
           "n" -> RGBColor[0.291989, 0.437977, 0.888609], "o" -> 
           RGBColor[0.800498, 0.201504, 0.192061], "f" -> 
           RGBColor[0.578462, 0.85539, 0.408855], "ne" -> 
           RGBColor[0.677263, 0.928423, 0.955287], "na" -> 
           RGBColor[0.658708, 0.492173, 0.842842], "mg" -> 
           RGBColor[0.628274, 0.850553, 0.0782731], "al" -> 
           RGBColor[0.8913, 0.631904, 0.627399], "si" -> 
           RGBColor[0.941176, 0.784314, 0.627451], "p" -> 
           RGBColor[1., 0.501961, 0], "s" -> 
           RGBColor[0.90443, 0.97015, 0.13504], "cl" -> 
           RGBColor[0.412698, 0.932689, 0.166398], "ar" -> 
           RGBColor[0.546138, 0.844244, 0.892092], "k" -> 
           RGBColor[0.534026, 0.420729, 0.705621], "ca" -> 
           RGBColor[0.480072, 0.744591, 0.0955222], "sc" -> 
           RGBColor[0.901961, 0.901961, 0.901961], "ti" -> 
           RGBColor[0.74902, 0.760784, 0.780392], "v" -> 
           RGBColor[0.65098, 0.65098, 0.670588], "cr" -> 
           RGBColor[0.541176, 0.6, 0.780392], "mn" -> 
           RGBColor[0.611765, 0.478431, 0.780392], "fe" -> 
           RGBColor[0.878431, 0.4, 0.2], "co" -> 
           RGBColor[0.941176, 0.564706, 0.627451], "ni" -> 
           RGBColor[0.313725, 0.815686, 0.313725], "cu" -> 
           RGBColor[0.784314, 0.501961, 0.2], "zn" -> 
           RGBColor[0.490196, 0.501961, 0.690196], "ga" -> 
           RGBColor[0.800757, 0.542666, 0.533513], "ge" -> 
           RGBColor[0.60508, 0.632465, 0.576489], "as" -> 
           RGBColor[0.741176, 0.501961, 0.890196], "se" -> 
           RGBColor[0.917248, 0.657833, 0.0706628], "br" -> 
           RGBColor[0.58847, 0.22163, 0.16064], "kr" -> 
           RGBColor[0.426019, 0.747462, 0.810413], "rb" -> 
           RGBColor[0.425391, 0.329242, 0.585895], "sr" -> 
           RGBColor[0.325959, 0.646423, 0.095983], "y" -> 
           RGBColor[0.531014, 1., 1.], "zr" -> 
           RGBColor[0.458599, 0.917466, 0.918573], "nb" -> 
           RGBColor[0.385036, 0.834854, 0.841681], "mo" -> 
           RGBColor[0.310325, 0.752163, 0.769323], "tc" -> 
           RGBColor[0.234466, 0.669394, 0.701499], "ru" -> 
           RGBColor[0.157459, 0.586546, 0.638209], "rh" -> 
           RGBColor[0.0793033, 0.50362, 0.579453], "pd" -> 
           RGBColor[0., 0.420615, 0.525231], "ag" -> 
           RGBColor[0.752941, 0.752941, 0.752941], "cd" -> 
           RGBColor[1., 0.85098, 0.560784], "in" -> 
           RGBColor[0.728371, 0.440594, 0.422196], "sn" -> 
           RGBColor[0.39799, 0.491477, 0.495586], "sb" -> 
           RGBColor[0.619608, 0.388235, 0.709804], "te" -> 
           RGBColor[0.816706, 0.451332, 0.0100947], "i" -> 
           RGBColor[0.580392, 0, 0.580392], "xe" -> 
           RGBColor[0.316906, 0.638078, 0.710252], "cs" -> 
           RGBColor[0.332803, 0.217712, 0.483666], "ba" -> 
           RGBColor[0.165935, 0.55605, 0.0796556], "la" -> 
           RGBColor[0.928084, 0.716075, 0.329427], "ce" -> 
           RGBColor[0.894824, 0.731424, 0.325131], "pr" -> 
           RGBColor[0.86523, 0.707999, 0.315261], "nd" -> 
           RGBColor[0.837836, 0.662974, 0.301635], "pm" -> 
           RGBColor[0.811992, 0.607859, 0.285626], "sm" -> 
           RGBColor[0.787563, 0.549894, 0.268279], "eu" -> 
           RGBColor[0.764628, 0.493261, 0.250405], "gd" -> 
           RGBColor[0.743177, 0.440115, 0.23269], "tb" -> 
           RGBColor[0.72281, 0.39143, 0.215783], "dy" -> 
           RGBColor[0.702434, 0.347663, 0.200392], "ho" -> 
           RGBColor[0.679962, 0.309234, 0.187368], "er" -> 
           RGBColor[0.652012, 0.276823, 0.17779], "tm" -> 
           RGBColor[0.613603, 0.251489, 0.173042], "yb" -> 
           RGBColor[0.557855, 0.234598, 0.17489], "lu" -> 
           RGBColor[0.475685, 0.227573, 0.18555], "hf" -> 
           RGBColor[0.781537, 0.717388, 0.716579], "ta" -> 
           RGBColor[0.734443, 0.544489, 0.683471], "w" -> 
           RGBColor[0.681179, 0.360409, 0.63675], "re" -> 
           RGBColor[0.605181, 0.367584, 0.556343], "os" -> 
           RGBColor[0.521806, 0.382125, 0.469204], "ir" -> 
           RGBColor[0.445624, 0.373159, 0.399069], "pt" -> 
           RGBColor[0.815686, 0.815686, 0.878431], "au" -> 
           RGBColor[1., 0.819608, 0.137255], "hg" -> 
           RGBColor[0.721569, 0.721569, 0.815686], "tl" -> 
           RGBColor[0.65098, 0.329412, 0.301961], "pb" -> 
           RGBColor[0.341176, 0.34902, 0.380392], "bi" -> 
           RGBColor[0.619608, 0.309804, 0.709804], "po" -> 
           RGBColor[0.670588, 0.360784, 0], "at" -> 
           RGBColor[0.458824, 0.309804, 0.270588], "rn" -> 
           RGBColor[0.218799, 0.516091, 0.591608], "fr" -> 
           RGBColor[0.25626, 0.0861372, 0.398932], "ra" -> 
           RGBColor[0., 0.473472, 0.04654], "ac" -> 
           RGBColor[0.322042, 0.71693, 0.988479], "th" -> 
           RGBColor[0.3608, 0.67166, 0.943003], "pa" -> 
           RGBColor[0.397469, 0.628, 0.898853], "u" -> 
           RGBColor[0.43205, 0.58595, 0.856029], "np" -> 
           RGBColor[0.464542, 0.54551, 0.814532], "pu" -> 
           RGBColor[0.494945, 0.506679, 0.774361], "am" -> 
           RGBColor[0.52326, 0.469458, 0.735517], "cm" -> 
           RGBColor[0.549486, 0.433847, 0.697999], "bk" -> 
           RGBColor[0.573624, 0.399845, 0.661808], "cf" -> 
           RGBColor[0.595673, 0.367454, 0.626942], "es" -> 
           RGBColor[0.615633, 0.336672, 0.593404], "fm" -> 
           RGBColor[0.633505, 0.307499, 0.561191], "md" -> 
           RGBColor[0.649288, 0.279937, 0.530305], "no" -> 
           RGBColor[0.662982, 0.253984, 0.500746], "lr" -> 
           RGBColor[0.674588, 0.22964, 0.472513], "rf" -> 
           RGBColor[0.684106, 0.206907, 0.445606], "db" -> 
           RGBColor[0.691534, 0.185783, 0.420025], "sg" -> 
           RGBColor[0.696874, 0.166269, 0.395772], "bh" -> 
           RGBColor[0.700126, 0.148365, 0.372844], "hs" -> 
           RGBColor[0.701289, 0.13207, 0.351243], "mt" -> 
           RGBColor[0.700363, 0.117385, 0.330968], "ds" -> 
           RGBColor[0.697348, 0.10431, 0.31202], "rg" -> 
           RGBColor[0.692245, 0.0928444, 0.294398], "cn" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "nh" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "fl" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "mc" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "lv" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "ts" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "og" -> 
           RGBColor[0.635401, 0.0528, 0.226184], "uub" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "uut" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "uuq" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "uup" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "uuh" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "uus" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "uuo" -> 
           RGBColor[0.635401, 0.0528, 0.226184]}]]& ][0.85], 
       ColorDataFunction[
       "Atoms", 
        "Named", {{
         "H", "He", "Li", "Be", "B", "C", "N", "O", "F", "Ne", "Na", "Mg", 
          "Al", "Si", "P", "S", "Cl", "Ar", "K", "Ca", "Sc", "Ti", "V", "Cr", 
          "Mn", "Fe", "Co", "Ni", "Cu", "Zn", "Ga", "Ge", "As", "Se", "Br", 
          "Kr", "Rb", "Sr", "Y", "Zr", "Nb", "Mo", "Tc", "Ru", "Rh", "Pd", 
          "Ag", "Cd", "In", "Sn", "Sb", "Te", "I", "Xe", "Cs", "Ba", "La", 
          "Ce", "Pr", "Nd", "Pm", "Sm", "Eu", "Gd", "Tb", "Dy", "Ho", "Er", 
          "Tm", "Yb", "Lu", "Hf", "Ta", "W", "Re", "Os", "Ir", "Pt", "Au", 
          "Hg", "Tl", "Pb", "Bi", "Po", "At", "Rn", "Fr", "Ra", "Ac", "Th", 
          "Pa", "U", "Np", "Pu", "Am", "Cm", "Bk", "Cf", "Es", "Fm", "Md", 
          "No", "Lr", "Rf", "Db", "Sg", "Bh", "Hs", "Mt", "Ds", "Rg", "Cn", 
          "Nh", "Fl", "Mc", "Lv", "Ts", "Og", "Uub", "Uut", "Uuq", "Uup", 
          "Uuh", "Uus", "Uuo"}, {
         "h", "he", "li", "be", "b", "c", "n", "o", "f", "ne", "na", "mg", 
          "al", "si", "p", "s", "cl", "ar", "k", "ca", "sc", "ti", "v", "cr", 
          "mn", "fe", "co", "ni", "cu", "zn", "ga", "ge", "as", "se", "br", 
          "kr", "rb", "sr", "y", "zr", "nb", "mo", "tc", "ru", "rh", "pd", 
          "ag", "cd", "in", "sn", "sb", "te", "i", "xe", "cs", "ba", "la", 
          "ce", "pr", "nd", "pm", "sm", "eu", "gd", "tb", "dy", "ho", "er", 
          "tm", "yb", "lu", "hf", "ta", "w", "re", "os", "ir", "pt", "au", 
          "hg", "tl", "pb", "bi", "po", "at", "rn", "fr", "ra", "ac", "th", 
          "pa", "u", "np", "pu", "am", "cm", "bk", "cf", "es", "fm", "md", 
          "no", "lr", "rf", "db", "sg", "bh", "hs", "mt", "ds", "rg", "cn", 
          "nh", "fl", "mc", "lv", "ts", "og", "uub", "uut", "uuq", "uup", 
          "uuh", "uus", "uuo"}}, Replace[#, 
         Dispatch[{
          "h" -> RGBColor[0.65, 0.7, 0.7], "he" -> RGBColor[0.836713, 1., 1.],
            "li" -> RGBColor[0.799435, 0.543572, 0.997559], "be" -> 
           RGBColor[0.770565, 0.964309, 0.0442359], "b" -> 
           RGBColor[1., 0.709804, 0.709804], "c" -> RGBColor[0.4, 0.4, 0.4], 
           "n" -> RGBColor[0.291989, 0.437977, 0.888609], "o" -> 
           RGBColor[0.800498, 0.201504, 0.192061], "f" -> 
           RGBColor[0.578462, 0.85539, 0.408855], "ne" -> 
           RGBColor[0.677263, 0.928423, 0.955287], "na" -> 
           RGBColor[0.658708, 0.492173, 0.842842], "mg" -> 
           RGBColor[0.628274, 0.850553, 0.0782731], "al" -> 
           RGBColor[0.8913, 0.631904, 0.627399], "si" -> 
           RGBColor[0.941176, 0.784314, 0.627451], "p" -> 
           RGBColor[1., 0.501961, 0], "s" -> 
           RGBColor[0.90443, 0.97015, 0.13504], "cl" -> 
           RGBColor[0.412698, 0.932689, 0.166398], "ar" -> 
           RGBColor[0.546138, 0.844244, 0.892092], "k" -> 
           RGBColor[0.534026, 0.420729, 0.705621], "ca" -> 
           RGBColor[0.480072, 0.744591, 0.0955222], "sc" -> 
           RGBColor[0.901961, 0.901961, 0.901961], "ti" -> 
           RGBColor[0.74902, 0.760784, 0.780392], "v" -> 
           RGBColor[0.65098, 0.65098, 0.670588], "cr" -> 
           RGBColor[0.541176, 0.6, 0.780392], "mn" -> 
           RGBColor[0.611765, 0.478431, 0.780392], "fe" -> 
           RGBColor[0.878431, 0.4, 0.2], "co" -> 
           RGBColor[0.941176, 0.564706, 0.627451], "ni" -> 
           RGBColor[0.313725, 0.815686, 0.313725], "cu" -> 
           RGBColor[0.784314, 0.501961, 0.2], "zn" -> 
           RGBColor[0.490196, 0.501961, 0.690196], "ga" -> 
           RGBColor[0.800757, 0.542666, 0.533513], "ge" -> 
           RGBColor[0.60508, 0.632465, 0.576489], "as" -> 
           RGBColor[0.741176, 0.501961, 0.890196], "se" -> 
           RGBColor[0.917248, 0.657833, 0.0706628], "br" -> 
           RGBColor[0.58847, 0.22163, 0.16064], "kr" -> 
           RGBColor[0.426019, 0.747462, 0.810413], "rb" -> 
           RGBColor[0.425391, 0.329242, 0.585895], "sr" -> 
           RGBColor[0.325959, 0.646423, 0.095983], "y" -> 
           RGBColor[0.531014, 1., 1.], "zr" -> 
           RGBColor[0.458599, 0.917466, 0.918573], "nb" -> 
           RGBColor[0.385036, 0.834854, 0.841681], "mo" -> 
           RGBColor[0.310325, 0.752163, 0.769323], "tc" -> 
           RGBColor[0.234466, 0.669394, 0.701499], "ru" -> 
           RGBColor[0.157459, 0.586546, 0.638209], "rh" -> 
           RGBColor[0.0793033, 0.50362, 0.579453], "pd" -> 
           RGBColor[0., 0.420615, 0.525231], "ag" -> 
           RGBColor[0.752941, 0.752941, 0.752941], "cd" -> 
           RGBColor[1., 0.85098, 0.560784], "in" -> 
           RGBColor[0.728371, 0.440594, 0.422196], "sn" -> 
           RGBColor[0.39799, 0.491477, 0.495586], "sb" -> 
           RGBColor[0.619608, 0.388235, 0.709804], "te" -> 
           RGBColor[0.816706, 0.451332, 0.0100947], "i" -> 
           RGBColor[0.580392, 0, 0.580392], "xe" -> 
           RGBColor[0.316906, 0.638078, 0.710252], "cs" -> 
           RGBColor[0.332803, 0.217712, 0.483666], "ba" -> 
           RGBColor[0.165935, 0.55605, 0.0796556], "la" -> 
           RGBColor[0.928084, 0.716075, 0.329427], "ce" -> 
           RGBColor[0.894824, 0.731424, 0.325131], "pr" -> 
           RGBColor[0.86523, 0.707999, 0.315261], "nd" -> 
           RGBColor[0.837836, 0.662974, 0.301635], "pm" -> 
           RGBColor[0.811992, 0.607859, 0.285626], "sm" -> 
           RGBColor[0.787563, 0.549894, 0.268279], "eu" -> 
           RGBColor[0.764628, 0.493261, 0.250405], "gd" -> 
           RGBColor[0.743177, 0.440115, 0.23269], "tb" -> 
           RGBColor[0.72281, 0.39143, 0.215783], "dy" -> 
           RGBColor[0.702434, 0.347663, 0.200392], "ho" -> 
           RGBColor[0.679962, 0.309234, 0.187368], "er" -> 
           RGBColor[0.652012, 0.276823, 0.17779], "tm" -> 
           RGBColor[0.613603, 0.251489, 0.173042], "yb" -> 
           RGBColor[0.557855, 0.234598, 0.17489], "lu" -> 
           RGBColor[0.475685, 0.227573, 0.18555], "hf" -> 
           RGBColor[0.781537, 0.717388, 0.716579], "ta" -> 
           RGBColor[0.734443, 0.544489, 0.683471], "w" -> 
           RGBColor[0.681179, 0.360409, 0.63675], "re" -> 
           RGBColor[0.605181, 0.367584, 0.556343], "os" -> 
           RGBColor[0.521806, 0.382125, 0.469204], "ir" -> 
           RGBColor[0.445624, 0.373159, 0.399069], "pt" -> 
           RGBColor[0.815686, 0.815686, 0.878431], "au" -> 
           RGBColor[1., 0.819608, 0.137255], "hg" -> 
           RGBColor[0.721569, 0.721569, 0.815686], "tl" -> 
           RGBColor[0.65098, 0.329412, 0.301961], "pb" -> 
           RGBColor[0.341176, 0.34902, 0.380392], "bi" -> 
           RGBColor[0.619608, 0.309804, 0.709804], "po" -> 
           RGBColor[0.670588, 0.360784, 0], "at" -> 
           RGBColor[0.458824, 0.309804, 0.270588], "rn" -> 
           RGBColor[0.218799, 0.516091, 0.591608], "fr" -> 
           RGBColor[0.25626, 0.0861372, 0.398932], "ra" -> 
           RGBColor[0., 0.473472, 0.04654], "ac" -> 
           RGBColor[0.322042, 0.71693, 0.988479], "th" -> 
           RGBColor[0.3608, 0.67166, 0.943003], "pa" -> 
           RGBColor[0.397469, 0.628, 0.898853], "u" -> 
           RGBColor[0.43205, 0.58595, 0.856029], "np" -> 
           RGBColor[0.464542, 0.54551, 0.814532], "pu" -> 
           RGBColor[0.494945, 0.506679, 0.774361], "am" -> 
           RGBColor[0.52326, 0.469458, 0.735517], "cm" -> 
           RGBColor[0.549486, 0.433847, 0.697999], "bk" -> 
           RGBColor[0.573624, 0.399845, 0.661808], "cf" -> 
           RGBColor[0.595673, 0.367454, 0.626942], "es" -> 
           RGBColor[0.615633, 0.336672, 0.593404], "fm" -> 
           RGBColor[0.633505, 0.307499, 0.561191], "md" -> 
           RGBColor[0.649288, 0.279937, 0.530305], "no" -> 
           RGBColor[0.662982, 0.253984, 0.500746], "lr" -> 
           RGBColor[0.674588, 0.22964, 0.472513], "rf" -> 
           RGBColor[0.684106, 0.206907, 0.445606], "db" -> 
           RGBColor[0.691534, 0.185783, 0.420025], "sg" -> 
           RGBColor[0.696874, 0.166269, 0.395772], "bh" -> 
           RGBColor[0.700126, 0.148365, 0.372844], "hs" -> 
           RGBColor[0.701289, 0.13207, 0.351243], "mt" -> 
           RGBColor[0.700363, 0.117385, 0.330968], "ds" -> 
           RGBColor[0.697348, 0.10431, 0.31202], "rg" -> 
           RGBColor[0.692245, 0.0928444, 0.294398], "cn" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "nh" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "fl" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "mc" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "lv" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "ts" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "og" -> 
           RGBColor[0.635401, 0.0528, 0.226184], "uub" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "uut" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "uuq" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "uup" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "uuh" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "uus" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "uuo" -> 
           RGBColor[0.635401, 0.0528, 0.226184]}]]& ][0.85], 
       ColorDataFunction[
       "Atoms", 
        "Named", {{
         "H", "He", "Li", "Be", "B", "C", "N", "O", "F", "Ne", "Na", "Mg", 
          "Al", "Si", "P", "S", "Cl", "Ar", "K", "Ca", "Sc", "Ti", "V", "Cr", 
          "Mn", "Fe", "Co", "Ni", "Cu", "Zn", "Ga", "Ge", "As", "Se", "Br", 
          "Kr", "Rb", "Sr", "Y", "Zr", "Nb", "Mo", "Tc", "Ru", "Rh", "Pd", 
          "Ag", "Cd", "In", "Sn", "Sb", "Te", "I", "Xe", "Cs", "Ba", "La", 
          "Ce", "Pr", "Nd", "Pm", "Sm", "Eu", "Gd", "Tb", "Dy", "Ho", "Er", 
          "Tm", "Yb", "Lu", "Hf", "Ta", "W", "Re", "Os", "Ir", "Pt", "Au", 
          "Hg", "Tl", "Pb", "Bi", "Po", "At", "Rn", "Fr", "Ra", "Ac", "Th", 
          "Pa", "U", "Np", "Pu", "Am", "Cm", "Bk", "Cf", "Es", "Fm", "Md", 
          "No", "Lr", "Rf", "Db", "Sg", "Bh", "Hs", "Mt", "Ds", "Rg", "Cn", 
          "Nh", "Fl", "Mc", "Lv", "Ts", "Og", "Uub", "Uut", "Uuq", "Uup", 
          "Uuh", "Uus", "Uuo"}, {
         "h", "he", "li", "be", "b", "c", "n", "o", "f", "ne", "na", "mg", 
          "al", "si", "p", "s", "cl", "ar", "k", "ca", "sc", "ti", "v", "cr", 
          "mn", "fe", "co", "ni", "cu", "zn", "ga", "ge", "as", "se", "br", 
          "kr", "rb", "sr", "y", "zr", "nb", "mo", "tc", "ru", "rh", "pd", 
          "ag", "cd", "in", "sn", "sb", "te", "i", "xe", "cs", "ba", "la", 
          "ce", "pr", "nd", "pm", "sm", "eu", "gd", "tb", "dy", "ho", "er", 
          "tm", "yb", "lu", "hf", "ta", "w", "re", "os", "ir", "pt", "au", 
          "hg", "tl", "pb", "bi", "po", "at", "rn", "fr", "ra", "ac", "th", 
          "pa", "u", "np", "pu", "am", "cm", "bk", "cf", "es", "fm", "md", 
          "no", "lr", "rf", "db", "sg", "bh", "hs", "mt", "ds", "rg", "cn", 
          "nh", "fl", "mc", "lv", "ts", "og", "uub", "uut", "uuq", "uup", 
          "uuh", "uus", "uuo"}}, Replace[#, 
         Dispatch[{
          "h" -> RGBColor[0.65, 0.7, 0.7], "he" -> RGBColor[0.836713, 1., 1.],
            "li" -> RGBColor[0.799435, 0.543572, 0.997559], "be" -> 
           RGBColor[0.770565, 0.964309, 0.0442359], "b" -> 
           RGBColor[1., 0.709804, 0.709804], "c" -> RGBColor[0.4, 0.4, 0.4], 
           "n" -> RGBColor[0.291989, 0.437977, 0.888609], "o" -> 
           RGBColor[0.800498, 0.201504, 0.192061], "f" -> 
           RGBColor[0.578462, 0.85539, 0.408855], "ne" -> 
           RGBColor[0.677263, 0.928423, 0.955287], "na" -> 
           RGBColor[0.658708, 0.492173, 0.842842], "mg" -> 
           RGBColor[0.628274, 0.850553, 0.0782731], "al" -> 
           RGBColor[0.8913, 0.631904, 0.627399], "si" -> 
           RGBColor[0.941176, 0.784314, 0.627451], "p" -> 
           RGBColor[1., 0.501961, 0], "s" -> 
           RGBColor[0.90443, 0.97015, 0.13504], "cl" -> 
           RGBColor[0.412698, 0.932689, 0.166398], "ar" -> 
           RGBColor[0.546138, 0.844244, 0.892092], "k" -> 
           RGBColor[0.534026, 0.420729, 0.705621], "ca" -> 
           RGBColor[0.480072, 0.744591, 0.0955222], "sc" -> 
           RGBColor[0.901961, 0.901961, 0.901961], "ti" -> 
           RGBColor[0.74902, 0.760784, 0.780392], "v" -> 
           RGBColor[0.65098, 0.65098, 0.670588], "cr" -> 
           RGBColor[0.541176, 0.6, 0.780392], "mn" -> 
           RGBColor[0.611765, 0.478431, 0.780392], "fe" -> 
           RGBColor[0.878431, 0.4, 0.2], "co" -> 
           RGBColor[0.941176, 0.564706, 0.627451], "ni" -> 
           RGBColor[0.313725, 0.815686, 0.313725], "cu" -> 
           RGBColor[0.784314, 0.501961, 0.2], "zn" -> 
           RGBColor[0.490196, 0.501961, 0.690196], "ga" -> 
           RGBColor[0.800757, 0.542666, 0.533513], "ge" -> 
           RGBColor[0.60508, 0.632465, 0.576489], "as" -> 
           RGBColor[0.741176, 0.501961, 0.890196], "se" -> 
           RGBColor[0.917248, 0.657833, 0.0706628], "br" -> 
           RGBColor[0.58847, 0.22163, 0.16064], "kr" -> 
           RGBColor[0.426019, 0.747462, 0.810413], "rb" -> 
           RGBColor[0.425391, 0.329242, 0.585895], "sr" -> 
           RGBColor[0.325959, 0.646423, 0.095983], "y" -> 
           RGBColor[0.531014, 1., 1.], "zr" -> 
           RGBColor[0.458599, 0.917466, 0.918573], "nb" -> 
           RGBColor[0.385036, 0.834854, 0.841681], "mo" -> 
           RGBColor[0.310325, 0.752163, 0.769323], "tc" -> 
           RGBColor[0.234466, 0.669394, 0.701499], "ru" -> 
           RGBColor[0.157459, 0.586546, 0.638209], "rh" -> 
           RGBColor[0.0793033, 0.50362, 0.579453], "pd" -> 
           RGBColor[0., 0.420615, 0.525231], "ag" -> 
           RGBColor[0.752941, 0.752941, 0.752941], "cd" -> 
           RGBColor[1., 0.85098, 0.560784], "in" -> 
           RGBColor[0.728371, 0.440594, 0.422196], "sn" -> 
           RGBColor[0.39799, 0.491477, 0.495586], "sb" -> 
           RGBColor[0.619608, 0.388235, 0.709804], "te" -> 
           RGBColor[0.816706, 0.451332, 0.0100947], "i" -> 
           RGBColor[0.580392, 0, 0.580392], "xe" -> 
           RGBColor[0.316906, 0.638078, 0.710252], "cs" -> 
           RGBColor[0.332803, 0.217712, 0.483666], "ba" -> 
           RGBColor[0.165935, 0.55605, 0.0796556], "la" -> 
           RGBColor[0.928084, 0.716075, 0.329427], "ce" -> 
           RGBColor[0.894824, 0.731424, 0.325131], "pr" -> 
           RGBColor[0.86523, 0.707999, 0.315261], "nd" -> 
           RGBColor[0.837836, 0.662974, 0.301635], "pm" -> 
           RGBColor[0.811992, 0.607859, 0.285626], "sm" -> 
           RGBColor[0.787563, 0.549894, 0.268279], "eu" -> 
           RGBColor[0.764628, 0.493261, 0.250405], "gd" -> 
           RGBColor[0.743177, 0.440115, 0.23269], "tb" -> 
           RGBColor[0.72281, 0.39143, 0.215783], "dy" -> 
           RGBColor[0.702434, 0.347663, 0.200392], "ho" -> 
           RGBColor[0.679962, 0.309234, 0.187368], "er" -> 
           RGBColor[0.652012, 0.276823, 0.17779], "tm" -> 
           RGBColor[0.613603, 0.251489, 0.173042], "yb" -> 
           RGBColor[0.557855, 0.234598, 0.17489], "lu" -> 
           RGBColor[0.475685, 0.227573, 0.18555], "hf" -> 
           RGBColor[0.781537, 0.717388, 0.716579], "ta" -> 
           RGBColor[0.734443, 0.544489, 0.683471], "w" -> 
           RGBColor[0.681179, 0.360409, 0.63675], "re" -> 
           RGBColor[0.605181, 0.367584, 0.556343], "os" -> 
           RGBColor[0.521806, 0.382125, 0.469204], "ir" -> 
           RGBColor[0.445624, 0.373159, 0.399069], "pt" -> 
           RGBColor[0.815686, 0.815686, 0.878431], "au" -> 
           RGBColor[1., 0.819608, 0.137255], "hg" -> 
           RGBColor[0.721569, 0.721569, 0.815686], "tl" -> 
           RGBColor[0.65098, 0.329412, 0.301961], "pb" -> 
           RGBColor[0.341176, 0.34902, 0.380392], "bi" -> 
           RGBColor[0.619608, 0.309804, 0.709804], "po" -> 
           RGBColor[0.670588, 0.360784, 0], "at" -> 
           RGBColor[0.458824, 0.309804, 0.270588], "rn" -> 
           RGBColor[0.218799, 0.516091, 0.591608], "fr" -> 
           RGBColor[0.25626, 0.0861372, 0.398932], "ra" -> 
           RGBColor[0., 0.473472, 0.04654], "ac" -> 
           RGBColor[0.322042, 0.71693, 0.988479], "th" -> 
           RGBColor[0.3608, 0.67166, 0.943003], "pa" -> 
           RGBColor[0.397469, 0.628, 0.898853], "u" -> 
           RGBColor[0.43205, 0.58595, 0.856029], "np" -> 
           RGBColor[0.464542, 0.54551, 0.814532], "pu" -> 
           RGBColor[0.494945, 0.506679, 0.774361], "am" -> 
           RGBColor[0.52326, 0.469458, 0.735517], "cm" -> 
           RGBColor[0.549486, 0.433847, 0.697999], "bk" -> 
           RGBColor[0.573624, 0.399845, 0.661808], "cf" -> 
           RGBColor[0.595673, 0.367454, 0.626942], "es" -> 
           RGBColor[0.615633, 0.336672, 0.593404], "fm" -> 
           RGBColor[0.633505, 0.307499, 0.561191], "md" -> 
           RGBColor[0.649288, 0.279937, 0.530305], "no" -> 
           RGBColor[0.662982, 0.253984, 0.500746], "lr" -> 
           RGBColor[0.674588, 0.22964, 0.472513], "rf" -> 
           RGBColor[0.684106, 0.206907, 0.445606], "db" -> 
           RGBColor[0.691534, 0.185783, 0.420025], "sg" -> 
           RGBColor[0.696874, 0.166269, 0.395772], "bh" -> 
           RGBColor[0.700126, 0.148365, 0.372844], "hs" -> 
           RGBColor[0.701289, 0.13207, 0.351243], "mt" -> 
           RGBColor[0.700363, 0.117385, 0.330968], "ds" -> 
           RGBColor[0.697348, 0.10431, 0.31202], "rg" -> 
           RGBColor[0.692245, 0.0928444, 0.294398], "cn" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "nh" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "fl" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "mc" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "lv" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "ts" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "og" -> 
           RGBColor[0.635401, 0.0528, 0.226184], "uub" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "uut" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "uuq" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "uup" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "uuh" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "uus" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "uuo" -> 
           RGBColor[0.635401, 0.0528, 0.226184]}]]& ][0.85], 
       ColorDataFunction[
       "Atoms", 
        "Named", {{
         "H", "He", "Li", "Be", "B", "C", "N", "O", "F", "Ne", "Na", "Mg", 
          "Al", "Si", "P", "S", "Cl", "Ar", "K", "Ca", "Sc", "Ti", "V", "Cr", 
          "Mn", "Fe", "Co", "Ni", "Cu", "Zn", "Ga", "Ge", "As", "Se", "Br", 
          "Kr", "Rb", "Sr", "Y", "Zr", "Nb", "Mo", "Tc", "Ru", "Rh", "Pd", 
          "Ag", "Cd", "In", "Sn", "Sb", "Te", "I", "Xe", "Cs", "Ba", "La", 
          "Ce", "Pr", "Nd", "Pm", "Sm", "Eu", "Gd", "Tb", "Dy", "Ho", "Er", 
          "Tm", "Yb", "Lu", "Hf", "Ta", "W", "Re", "Os", "Ir", "Pt", "Au", 
          "Hg", "Tl", "Pb", "Bi", "Po", "At", "Rn", "Fr", "Ra", "Ac", "Th", 
          "Pa", "U", "Np", "Pu", "Am", "Cm", "Bk", "Cf", "Es", "Fm", "Md", 
          "No", "Lr", "Rf", "Db", "Sg", "Bh", "Hs", "Mt", "Ds", "Rg", "Cn", 
          "Nh", "Fl", "Mc", "Lv", "Ts", "Og", "Uub", "Uut", "Uuq", "Uup", 
          "Uuh", "Uus", "Uuo"}, {
         "h", "he", "li", "be", "b", "c", "n", "o", "f", "ne", "na", "mg", 
          "al", "si", "p", "s", "cl", "ar", "k", "ca", "sc", "ti", "v", "cr", 
          "mn", "fe", "co", "ni", "cu", "zn", "ga", "ge", "as", "se", "br", 
          "kr", "rb", "sr", "y", "zr", "nb", "mo", "tc", "ru", "rh", "pd", 
          "ag", "cd", "in", "sn", "sb", "te", "i", "xe", "cs", "ba", "la", 
          "ce", "pr", "nd", "pm", "sm", "eu", "gd", "tb", "dy", "ho", "er", 
          "tm", "yb", "lu", "hf", "ta", "w", "re", "os", "ir", "pt", "au", 
          "hg", "tl", "pb", "bi", "po", "at", "rn", "fr", "ra", "ac", "th", 
          "pa", "u", "np", "pu", "am", "cm", "bk", "cf", "es", "fm", "md", 
          "no", "lr", "rf", "db", "sg", "bh", "hs", "mt", "ds", "rg", "cn", 
          "nh", "fl", "mc", "lv", "ts", "og", "uub", "uut", "uuq", "uup", 
          "uuh", "uus", "uuo"}}, Replace[#, 
         Dispatch[{
          "h" -> RGBColor[0.65, 0.7, 0.7], "he" -> RGBColor[0.836713, 1., 1.],
            "li" -> RGBColor[0.799435, 0.543572, 0.997559], "be" -> 
           RGBColor[0.770565, 0.964309, 0.0442359], "b" -> 
           RGBColor[1., 0.709804, 0.709804], "c" -> RGBColor[0.4, 0.4, 0.4], 
           "n" -> RGBColor[0.291989, 0.437977, 0.888609], "o" -> 
           RGBColor[0.800498, 0.201504, 0.192061], "f" -> 
           RGBColor[0.578462, 0.85539, 0.408855], "ne" -> 
           RGBColor[0.677263, 0.928423, 0.955287], "na" -> 
           RGBColor[0.658708, 0.492173, 0.842842], "mg" -> 
           RGBColor[0.628274, 0.850553, 0.0782731], "al" -> 
           RGBColor[0.8913, 0.631904, 0.627399], "si" -> 
           RGBColor[0.941176, 0.784314, 0.627451], "p" -> 
           RGBColor[1., 0.501961, 0], "s" -> 
           RGBColor[0.90443, 0.97015, 0.13504], "cl" -> 
           RGBColor[0.412698, 0.932689, 0.166398], "ar" -> 
           RGBColor[0.546138, 0.844244, 0.892092], "k" -> 
           RGBColor[0.534026, 0.420729, 0.705621], "ca" -> 
           RGBColor[0.480072, 0.744591, 0.0955222], "sc" -> 
           RGBColor[0.901961, 0.901961, 0.901961], "ti" -> 
           RGBColor[0.74902, 0.760784, 0.780392], "v" -> 
           RGBColor[0.65098, 0.65098, 0.670588], "cr" -> 
           RGBColor[0.541176, 0.6, 0.780392], "mn" -> 
           RGBColor[0.611765, 0.478431, 0.780392], "fe" -> 
           RGBColor[0.878431, 0.4, 0.2], "co" -> 
           RGBColor[0.941176, 0.564706, 0.627451], "ni" -> 
           RGBColor[0.313725, 0.815686, 0.313725], "cu" -> 
           RGBColor[0.784314, 0.501961, 0.2], "zn" -> 
           RGBColor[0.490196, 0.501961, 0.690196], "ga" -> 
           RGBColor[0.800757, 0.542666, 0.533513], "ge" -> 
           RGBColor[0.60508, 0.632465, 0.576489], "as" -> 
           RGBColor[0.741176, 0.501961, 0.890196], "se" -> 
           RGBColor[0.917248, 0.657833, 0.0706628], "br" -> 
           RGBColor[0.58847, 0.22163, 0.16064], "kr" -> 
           RGBColor[0.426019, 0.747462, 0.810413], "rb" -> 
           RGBColor[0.425391, 0.329242, 0.585895], "sr" -> 
           RGBColor[0.325959, 0.646423, 0.095983], "y" -> 
           RGBColor[0.531014, 1., 1.], "zr" -> 
           RGBColor[0.458599, 0.917466, 0.918573], "nb" -> 
           RGBColor[0.385036, 0.834854, 0.841681], "mo" -> 
           RGBColor[0.310325, 0.752163, 0.769323], "tc" -> 
           RGBColor[0.234466, 0.669394, 0.701499], "ru" -> 
           RGBColor[0.157459, 0.586546, 0.638209], "rh" -> 
           RGBColor[0.0793033, 0.50362, 0.579453], "pd" -> 
           RGBColor[0., 0.420615, 0.525231], "ag" -> 
           RGBColor[0.752941, 0.752941, 0.752941], "cd" -> 
           RGBColor[1., 0.85098, 0.560784], "in" -> 
           RGBColor[0.728371, 0.440594, 0.422196], "sn" -> 
           RGBColor[0.39799, 0.491477, 0.495586], "sb" -> 
           RGBColor[0.619608, 0.388235, 0.709804], "te" -> 
           RGBColor[0.816706, 0.451332, 0.0100947], "i" -> 
           RGBColor[0.580392, 0, 0.580392], "xe" -> 
           RGBColor[0.316906, 0.638078, 0.710252], "cs" -> 
           RGBColor[0.332803, 0.217712, 0.483666], "ba" -> 
           RGBColor[0.165935, 0.55605, 0.0796556], "la" -> 
           RGBColor[0.928084, 0.716075, 0.329427], "ce" -> 
           RGBColor[0.894824, 0.731424, 0.325131], "pr" -> 
           RGBColor[0.86523, 0.707999, 0.315261], "nd" -> 
           RGBColor[0.837836, 0.662974, 0.301635], "pm" -> 
           RGBColor[0.811992, 0.607859, 0.285626], "sm" -> 
           RGBColor[0.787563, 0.549894, 0.268279], "eu" -> 
           RGBColor[0.764628, 0.493261, 0.250405], "gd" -> 
           RGBColor[0.743177, 0.440115, 0.23269], "tb" -> 
           RGBColor[0.72281, 0.39143, 0.215783], "dy" -> 
           RGBColor[0.702434, 0.347663, 0.200392], "ho" -> 
           RGBColor[0.679962, 0.309234, 0.187368], "er" -> 
           RGBColor[0.652012, 0.276823, 0.17779], "tm" -> 
           RGBColor[0.613603, 0.251489, 0.173042], "yb" -> 
           RGBColor[0.557855, 0.234598, 0.17489], "lu" -> 
           RGBColor[0.475685, 0.227573, 0.18555], "hf" -> 
           RGBColor[0.781537, 0.717388, 0.716579], "ta" -> 
           RGBColor[0.734443, 0.544489, 0.683471], "w" -> 
           RGBColor[0.681179, 0.360409, 0.63675], "re" -> 
           RGBColor[0.605181, 0.367584, 0.556343], "os" -> 
           RGBColor[0.521806, 0.382125, 0.469204], "ir" -> 
           RGBColor[0.445624, 0.373159, 0.399069], "pt" -> 
           RGBColor[0.815686, 0.815686, 0.878431], "au" -> 
           RGBColor[1., 0.819608, 0.137255], "hg" -> 
           RGBColor[0.721569, 0.721569, 0.815686], "tl" -> 
           RGBColor[0.65098, 0.329412, 0.301961], "pb" -> 
           RGBColor[0.341176, 0.34902, 0.380392], "bi" -> 
           RGBColor[0.619608, 0.309804, 0.709804], "po" -> 
           RGBColor[0.670588, 0.360784, 0], "at" -> 
           RGBColor[0.458824, 0.309804, 0.270588], "rn" -> 
           RGBColor[0.218799, 0.516091, 0.591608], "fr" -> 
           RGBColor[0.25626, 0.0861372, 0.398932], "ra" -> 
           RGBColor[0., 0.473472, 0.04654], "ac" -> 
           RGBColor[0.322042, 0.71693, 0.988479], "th" -> 
           RGBColor[0.3608, 0.67166, 0.943003], "pa" -> 
           RGBColor[0.397469, 0.628, 0.898853], "u" -> 
           RGBColor[0.43205, 0.58595, 0.856029], "np" -> 
           RGBColor[0.464542, 0.54551, 0.814532], "pu" -> 
           RGBColor[0.494945, 0.506679, 0.774361], "am" -> 
           RGBColor[0.52326, 0.469458, 0.735517], "cm" -> 
           RGBColor[0.549486, 0.433847, 0.697999], "bk" -> 
           RGBColor[0.573624, 0.399845, 0.661808], "cf" -> 
           RGBColor[0.595673, 0.367454, 0.626942], "es" -> 
           RGBColor[0.615633, 0.336672, 0.593404], "fm" -> 
           RGBColor[0.633505, 0.307499, 0.561191], "md" -> 
           RGBColor[0.649288, 0.279937, 0.530305], "no" -> 
           RGBColor[0.662982, 0.253984, 0.500746], "lr" -> 
           RGBColor[0.674588, 0.22964, 0.472513], "rf" -> 
           RGBColor[0.684106, 0.206907, 0.445606], "db" -> 
           RGBColor[0.691534, 0.185783, 0.420025], "sg" -> 
           RGBColor[0.696874, 0.166269, 0.395772], "bh" -> 
           RGBColor[0.700126, 0.148365, 0.372844], "hs" -> 
           RGBColor[0.701289, 0.13207, 0.351243], "mt" -> 
           RGBColor[0.700363, 0.117385, 0.330968], "ds" -> 
           RGBColor[0.697348, 0.10431, 0.31202], "rg" -> 
           RGBColor[0.692245, 0.0928444, 0.294398], "cn" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "nh" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "fl" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "mc" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "lv" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "ts" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "og" -> 
           RGBColor[0.635401, 0.0528, 0.226184], "uub" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "uut" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "uuq" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "uup" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "uuh" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "uus" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "uuo" -> 
           RGBColor[0.635401, 0.0528, 0.226184]}]]& ][0.85], 
       ColorDataFunction[
       "Atoms", 
        "Named", {{
         "H", "He", "Li", "Be", "B", "C", "N", "O", "F", "Ne", "Na", "Mg", 
          "Al", "Si", "P", "S", "Cl", "Ar", "K", "Ca", "Sc", "Ti", "V", "Cr", 
          "Mn", "Fe", "Co", "Ni", "Cu", "Zn", "Ga", "Ge", "As", "Se", "Br", 
          "Kr", "Rb", "Sr", "Y", "Zr", "Nb", "Mo", "Tc", "Ru", "Rh", "Pd", 
          "Ag", "Cd", "In", "Sn", "Sb", "Te", "I", "Xe", "Cs", "Ba", "La", 
          "Ce", "Pr", "Nd", "Pm", "Sm", "Eu", "Gd", "Tb", "Dy", "Ho", "Er", 
          "Tm", "Yb", "Lu", "Hf", "Ta", "W", "Re", "Os", "Ir", "Pt", "Au", 
          "Hg", "Tl", "Pb", "Bi", "Po", "At", "Rn", "Fr", "Ra", "Ac", "Th", 
          "Pa", "U", "Np", "Pu", "Am", "Cm", "Bk", "Cf", "Es", "Fm", "Md", 
          "No", "Lr", "Rf", "Db", "Sg", "Bh", "Hs", "Mt", "Ds", "Rg", "Cn", 
          "Nh", "Fl", "Mc", "Lv", "Ts", "Og", "Uub", "Uut", "Uuq", "Uup", 
          "Uuh", "Uus", "Uuo"}, {
         "h", "he", "li", "be", "b", "c", "n", "o", "f", "ne", "na", "mg", 
          "al", "si", "p", "s", "cl", "ar", "k", "ca", "sc", "ti", "v", "cr", 
          "mn", "fe", "co", "ni", "cu", "zn", "ga", "ge", "as", "se", "br", 
          "kr", "rb", "sr", "y", "zr", "nb", "mo", "tc", "ru", "rh", "pd", 
          "ag", "cd", "in", "sn", "sb", "te", "i", "xe", "cs", "ba", "la", 
          "ce", "pr", "nd", "pm", "sm", "eu", "gd", "tb", "dy", "ho", "er", 
          "tm", "yb", "lu", "hf", "ta", "w", "re", "os", "ir", "pt", "au", 
          "hg", "tl", "pb", "bi", "po", "at", "rn", "fr", "ra", "ac", "th", 
          "pa", "u", "np", "pu", "am", "cm", "bk", "cf", "es", "fm", "md", 
          "no", "lr", "rf", "db", "sg", "bh", "hs", "mt", "ds", "rg", "cn", 
          "nh", "fl", "mc", "lv", "ts", "og", "uub", "uut", "uuq", "uup", 
          "uuh", "uus", "uuo"}}, Replace[#, 
         Dispatch[{
          "h" -> RGBColor[0.65, 0.7, 0.7], "he" -> RGBColor[0.836713, 1., 1.],
            "li" -> RGBColor[0.799435, 0.543572, 0.997559], "be" -> 
           RGBColor[0.770565, 0.964309, 0.0442359], "b" -> 
           RGBColor[1., 0.709804, 0.709804], "c" -> RGBColor[0.4, 0.4, 0.4], 
           "n" -> RGBColor[0.291989, 0.437977, 0.888609], "o" -> 
           RGBColor[0.800498, 0.201504, 0.192061], "f" -> 
           RGBColor[0.578462, 0.85539, 0.408855], "ne" -> 
           RGBColor[0.677263, 0.928423, 0.955287], "na" -> 
           RGBColor[0.658708, 0.492173, 0.842842], "mg" -> 
           RGBColor[0.628274, 0.850553, 0.0782731], "al" -> 
           RGBColor[0.8913, 0.631904, 0.627399], "si" -> 
           RGBColor[0.941176, 0.784314, 0.627451], "p" -> 
           RGBColor[1., 0.501961, 0], "s" -> 
           RGBColor[0.90443, 0.97015, 0.13504], "cl" -> 
           RGBColor[0.412698, 0.932689, 0.166398], "ar" -> 
           RGBColor[0.546138, 0.844244, 0.892092], "k" -> 
           RGBColor[0.534026, 0.420729, 0.705621], "ca" -> 
           RGBColor[0.480072, 0.744591, 0.0955222], "sc" -> 
           RGBColor[0.901961, 0.901961, 0.901961], "ti" -> 
           RGBColor[0.74902, 0.760784, 0.780392], "v" -> 
           RGBColor[0.65098, 0.65098, 0.670588], "cr" -> 
           RGBColor[0.541176, 0.6, 0.780392], "mn" -> 
           RGBColor[0.611765, 0.478431, 0.780392], "fe" -> 
           RGBColor[0.878431, 0.4, 0.2], "co" -> 
           RGBColor[0.941176, 0.564706, 0.627451], "ni" -> 
           RGBColor[0.313725, 0.815686, 0.313725], "cu" -> 
           RGBColor[0.784314, 0.501961, 0.2], "zn" -> 
           RGBColor[0.490196, 0.501961, 0.690196], "ga" -> 
           RGBColor[0.800757, 0.542666, 0.533513], "ge" -> 
           RGBColor[0.60508, 0.632465, 0.576489], "as" -> 
           RGBColor[0.741176, 0.501961, 0.890196], "se" -> 
           RGBColor[0.917248, 0.657833, 0.0706628], "br" -> 
           RGBColor[0.58847, 0.22163, 0.16064], "kr" -> 
           RGBColor[0.426019, 0.747462, 0.810413], "rb" -> 
           RGBColor[0.425391, 0.329242, 0.585895], "sr" -> 
           RGBColor[0.325959, 0.646423, 0.095983], "y" -> 
           RGBColor[0.531014, 1., 1.], "zr" -> 
           RGBColor[0.458599, 0.917466, 0.918573], "nb" -> 
           RGBColor[0.385036, 0.834854, 0.841681], "mo" -> 
           RGBColor[0.310325, 0.752163, 0.769323], "tc" -> 
           RGBColor[0.234466, 0.669394, 0.701499], "ru" -> 
           RGBColor[0.157459, 0.586546, 0.638209], "rh" -> 
           RGBColor[0.0793033, 0.50362, 0.579453], "pd" -> 
           RGBColor[0., 0.420615, 0.525231], "ag" -> 
           RGBColor[0.752941, 0.752941, 0.752941], "cd" -> 
           RGBColor[1., 0.85098, 0.560784], "in" -> 
           RGBColor[0.728371, 0.440594, 0.422196], "sn" -> 
           RGBColor[0.39799, 0.491477, 0.495586], "sb" -> 
           RGBColor[0.619608, 0.388235, 0.709804], "te" -> 
           RGBColor[0.816706, 0.451332, 0.0100947], "i" -> 
           RGBColor[0.580392, 0, 0.580392], "xe" -> 
           RGBColor[0.316906, 0.638078, 0.710252], "cs" -> 
           RGBColor[0.332803, 0.217712, 0.483666], "ba" -> 
           RGBColor[0.165935, 0.55605, 0.0796556], "la" -> 
           RGBColor[0.928084, 0.716075, 0.329427], "ce" -> 
           RGBColor[0.894824, 0.731424, 0.325131], "pr" -> 
           RGBColor[0.86523, 0.707999, 0.315261], "nd" -> 
           RGBColor[0.837836, 0.662974, 0.301635], "pm" -> 
           RGBColor[0.811992, 0.607859, 0.285626], "sm" -> 
           RGBColor[0.787563, 0.549894, 0.268279], "eu" -> 
           RGBColor[0.764628, 0.493261, 0.250405], "gd" -> 
           RGBColor[0.743177, 0.440115, 0.23269], "tb" -> 
           RGBColor[0.72281, 0.39143, 0.215783], "dy" -> 
           RGBColor[0.702434, 0.347663, 0.200392], "ho" -> 
           RGBColor[0.679962, 0.309234, 0.187368], "er" -> 
           RGBColor[0.652012, 0.276823, 0.17779], "tm" -> 
           RGBColor[0.613603, 0.251489, 0.173042], "yb" -> 
           RGBColor[0.557855, 0.234598, 0.17489], "lu" -> 
           RGBColor[0.475685, 0.227573, 0.18555], "hf" -> 
           RGBColor[0.781537, 0.717388, 0.716579], "ta" -> 
           RGBColor[0.734443, 0.544489, 0.683471], "w" -> 
           RGBColor[0.681179, 0.360409, 0.63675], "re" -> 
           RGBColor[0.605181, 0.367584, 0.556343], "os" -> 
           RGBColor[0.521806, 0.382125, 0.469204], "ir" -> 
           RGBColor[0.445624, 0.373159, 0.399069], "pt" -> 
           RGBColor[0.815686, 0.815686, 0.878431], "au" -> 
           RGBColor[1., 0.819608, 0.137255], "hg" -> 
           RGBColor[0.721569, 0.721569, 0.815686], "tl" -> 
           RGBColor[0.65098, 0.329412, 0.301961], "pb" -> 
           RGBColor[0.341176, 0.34902, 0.380392], "bi" -> 
           RGBColor[0.619608, 0.309804, 0.709804], "po" -> 
           RGBColor[0.670588, 0.360784, 0], "at" -> 
           RGBColor[0.458824, 0.309804, 0.270588], "rn" -> 
           RGBColor[0.218799, 0.516091, 0.591608], "fr" -> 
           RGBColor[0.25626, 0.0861372, 0.398932], "ra" -> 
           RGBColor[0., 0.473472, 0.04654], "ac" -> 
           RGBColor[0.322042, 0.71693, 0.988479], "th" -> 
           RGBColor[0.3608, 0.67166, 0.943003], "pa" -> 
           RGBColor[0.397469, 0.628, 0.898853], "u" -> 
           RGBColor[0.43205, 0.58595, 0.856029], "np" -> 
           RGBColor[0.464542, 0.54551, 0.814532], "pu" -> 
           RGBColor[0.494945, 0.506679, 0.774361], "am" -> 
           RGBColor[0.52326, 0.469458, 0.735517], "cm" -> 
           RGBColor[0.549486, 0.433847, 0.697999], "bk" -> 
           RGBColor[0.573624, 0.399845, 0.661808], "cf" -> 
           RGBColor[0.595673, 0.367454, 0.626942], "es" -> 
           RGBColor[0.615633, 0.336672, 0.593404], "fm" -> 
           RGBColor[0.633505, 0.307499, 0.561191], "md" -> 
           RGBColor[0.649288, 0.279937, 0.530305], "no" -> 
           RGBColor[0.662982, 0.253984, 0.500746], "lr" -> 
           RGBColor[0.674588, 0.22964, 0.472513], "rf" -> 
           RGBColor[0.684106, 0.206907, 0.445606], "db" -> 
           RGBColor[0.691534, 0.185783, 0.420025], "sg" -> 
           RGBColor[0.696874, 0.166269, 0.395772], "bh" -> 
           RGBColor[0.700126, 0.148365, 0.372844], "hs" -> 
           RGBColor[0.701289, 0.13207, 0.351243], "mt" -> 
           RGBColor[0.700363, 0.117385, 0.330968], "ds" -> 
           RGBColor[0.697348, 0.10431, 0.31202], "rg" -> 
           RGBColor[0.692245, 0.0928444, 0.294398], "cn" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "nh" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "fl" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "mc" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "lv" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "ts" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "og" -> 
           RGBColor[0.635401, 0.0528, 0.226184], "uub" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "uut" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "uuq" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "uup" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "uuh" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "uus" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "uuo" -> 
           RGBColor[0.635401, 0.0528, 0.226184]}]]& ][0.85], 
       ColorDataFunction[
       "Atoms", 
        "Named", {{
         "H", "He", "Li", "Be", "B", "C", "N", "O", "F", "Ne", "Na", "Mg", 
          "Al", "Si", "P", "S", "Cl", "Ar", "K", "Ca", "Sc", "Ti", "V", "Cr", 
          "Mn", "Fe", "Co", "Ni", "Cu", "Zn", "Ga", "Ge", "As", "Se", "Br", 
          "Kr", "Rb", "Sr", "Y", "Zr", "Nb", "Mo", "Tc", "Ru", "Rh", "Pd", 
          "Ag", "Cd", "In", "Sn", "Sb", "Te", "I", "Xe", "Cs", "Ba", "La", 
          "Ce", "Pr", "Nd", "Pm", "Sm", "Eu", "Gd", "Tb", "Dy", "Ho", "Er", 
          "Tm", "Yb", "Lu", "Hf", "Ta", "W", "Re", "Os", "Ir", "Pt", "Au", 
          "Hg", "Tl", "Pb", "Bi", "Po", "At", "Rn", "Fr", "Ra", "Ac", "Th", 
          "Pa", "U", "Np", "Pu", "Am", "Cm", "Bk", "Cf", "Es", "Fm", "Md", 
          "No", "Lr", "Rf", "Db", "Sg", "Bh", "Hs", "Mt", "Ds", "Rg", "Cn", 
          "Nh", "Fl", "Mc", "Lv", "Ts", "Og", "Uub", "Uut", "Uuq", "Uup", 
          "Uuh", "Uus", "Uuo"}, {
         "h", "he", "li", "be", "b", "c", "n", "o", "f", "ne", "na", "mg", 
          "al", "si", "p", "s", "cl", "ar", "k", "ca", "sc", "ti", "v", "cr", 
          "mn", "fe", "co", "ni", "cu", "zn", "ga", "ge", "as", "se", "br", 
          "kr", "rb", "sr", "y", "zr", "nb", "mo", "tc", "ru", "rh", "pd", 
          "ag", "cd", "in", "sn", "sb", "te", "i", "xe", "cs", "ba", "la", 
          "ce", "pr", "nd", "pm", "sm", "eu", "gd", "tb", "dy", "ho", "er", 
          "tm", "yb", "lu", "hf", "ta", "w", "re", "os", "ir", "pt", "au", 
          "hg", "tl", "pb", "bi", "po", "at", "rn", "fr", "ra", "ac", "th", 
          "pa", "u", "np", "pu", "am", "cm", "bk", "cf", "es", "fm", "md", 
          "no", "lr", "rf", "db", "sg", "bh", "hs", "mt", "ds", "rg", "cn", 
          "nh", "fl", "mc", "lv", "ts", "og", "uub", "uut", "uuq", "uup", 
          "uuh", "uus", "uuo"}}, Replace[#, 
         Dispatch[{
          "h" -> RGBColor[0.65, 0.7, 0.7], "he" -> RGBColor[0.836713, 1., 1.],
            "li" -> RGBColor[0.799435, 0.543572, 0.997559], "be" -> 
           RGBColor[0.770565, 0.964309, 0.0442359], "b" -> 
           RGBColor[1., 0.709804, 0.709804], "c" -> RGBColor[0.4, 0.4, 0.4], 
           "n" -> RGBColor[0.291989, 0.437977, 0.888609], "o" -> 
           RGBColor[0.800498, 0.201504, 0.192061], "f" -> 
           RGBColor[0.578462, 0.85539, 0.408855], "ne" -> 
           RGBColor[0.677263, 0.928423, 0.955287], "na" -> 
           RGBColor[0.658708, 0.492173, 0.842842], "mg" -> 
           RGBColor[0.628274, 0.850553, 0.0782731], "al" -> 
           RGBColor[0.8913, 0.631904, 0.627399], "si" -> 
           RGBColor[0.941176, 0.784314, 0.627451], "p" -> 
           RGBColor[1., 0.501961, 0], "s" -> 
           RGBColor[0.90443, 0.97015, 0.13504], "cl" -> 
           RGBColor[0.412698, 0.932689, 0.166398], "ar" -> 
           RGBColor[0.546138, 0.844244, 0.892092], "k" -> 
           RGBColor[0.534026, 0.420729, 0.705621], "ca" -> 
           RGBColor[0.480072, 0.744591, 0.0955222], "sc" -> 
           RGBColor[0.901961, 0.901961, 0.901961], "ti" -> 
           RGBColor[0.74902, 0.760784, 0.780392], "v" -> 
           RGBColor[0.65098, 0.65098, 0.670588], "cr" -> 
           RGBColor[0.541176, 0.6, 0.780392], "mn" -> 
           RGBColor[0.611765, 0.478431, 0.780392], "fe" -> 
           RGBColor[0.878431, 0.4, 0.2], "co" -> 
           RGBColor[0.941176, 0.564706, 0.627451], "ni" -> 
           RGBColor[0.313725, 0.815686, 0.313725], "cu" -> 
           RGBColor[0.784314, 0.501961, 0.2], "zn" -> 
           RGBColor[0.490196, 0.501961, 0.690196], "ga" -> 
           RGBColor[0.800757, 0.542666, 0.533513], "ge" -> 
           RGBColor[0.60508, 0.632465, 0.576489], "as" -> 
           RGBColor[0.741176, 0.501961, 0.890196], "se" -> 
           RGBColor[0.917248, 0.657833, 0.0706628], "br" -> 
           RGBColor[0.58847, 0.22163, 0.16064], "kr" -> 
           RGBColor[0.426019, 0.747462, 0.810413], "rb" -> 
           RGBColor[0.425391, 0.329242, 0.585895], "sr" -> 
           RGBColor[0.325959, 0.646423, 0.095983], "y" -> 
           RGBColor[0.531014, 1., 1.], "zr" -> 
           RGBColor[0.458599, 0.917466, 0.918573], "nb" -> 
           RGBColor[0.385036, 0.834854, 0.841681], "mo" -> 
           RGBColor[0.310325, 0.752163, 0.769323], "tc" -> 
           RGBColor[0.234466, 0.669394, 0.701499], "ru" -> 
           RGBColor[0.157459, 0.586546, 0.638209], "rh" -> 
           RGBColor[0.0793033, 0.50362, 0.579453], "pd" -> 
           RGBColor[0., 0.420615, 0.525231], "ag" -> 
           RGBColor[0.752941, 0.752941, 0.752941], "cd" -> 
           RGBColor[1., 0.85098, 0.560784], "in" -> 
           RGBColor[0.728371, 0.440594, 0.422196], "sn" -> 
           RGBColor[0.39799, 0.491477, 0.495586], "sb" -> 
           RGBColor[0.619608, 0.388235, 0.709804], "te" -> 
           RGBColor[0.816706, 0.451332, 0.0100947], "i" -> 
           RGBColor[0.580392, 0, 0.580392], "xe" -> 
           RGBColor[0.316906, 0.638078, 0.710252], "cs" -> 
           RGBColor[0.332803, 0.217712, 0.483666], "ba" -> 
           RGBColor[0.165935, 0.55605, 0.0796556], "la" -> 
           RGBColor[0.928084, 0.716075, 0.329427], "ce" -> 
           RGBColor[0.894824, 0.731424, 0.325131], "pr" -> 
           RGBColor[0.86523, 0.707999, 0.315261], "nd" -> 
           RGBColor[0.837836, 0.662974, 0.301635], "pm" -> 
           RGBColor[0.811992, 0.607859, 0.285626], "sm" -> 
           RGBColor[0.787563, 0.549894, 0.268279], "eu" -> 
           RGBColor[0.764628, 0.493261, 0.250405], "gd" -> 
           RGBColor[0.743177, 0.440115, 0.23269], "tb" -> 
           RGBColor[0.72281, 0.39143, 0.215783], "dy" -> 
           RGBColor[0.702434, 0.347663, 0.200392], "ho" -> 
           RGBColor[0.679962, 0.309234, 0.187368], "er" -> 
           RGBColor[0.652012, 0.276823, 0.17779], "tm" -> 
           RGBColor[0.613603, 0.251489, 0.173042], "yb" -> 
           RGBColor[0.557855, 0.234598, 0.17489], "lu" -> 
           RGBColor[0.475685, 0.227573, 0.18555], "hf" -> 
           RGBColor[0.781537, 0.717388, 0.716579], "ta" -> 
           RGBColor[0.734443, 0.544489, 0.683471], "w" -> 
           RGBColor[0.681179, 0.360409, 0.63675], "re" -> 
           RGBColor[0.605181, 0.367584, 0.556343], "os" -> 
           RGBColor[0.521806, 0.382125, 0.469204], "ir" -> 
           RGBColor[0.445624, 0.373159, 0.399069], "pt" -> 
           RGBColor[0.815686, 0.815686, 0.878431], "au" -> 
           RGBColor[1., 0.819608, 0.137255], "hg" -> 
           RGBColor[0.721569, 0.721569, 0.815686], "tl" -> 
           RGBColor[0.65098, 0.329412, 0.301961], "pb" -> 
           RGBColor[0.341176, 0.34902, 0.380392], "bi" -> 
           RGBColor[0.619608, 0.309804, 0.709804], "po" -> 
           RGBColor[0.670588, 0.360784, 0], "at" -> 
           RGBColor[0.458824, 0.309804, 0.270588], "rn" -> 
           RGBColor[0.218799, 0.516091, 0.591608], "fr" -> 
           RGBColor[0.25626, 0.0861372, 0.398932], "ra" -> 
           RGBColor[0., 0.473472, 0.04654], "ac" -> 
           RGBColor[0.322042, 0.71693, 0.988479], "th" -> 
           RGBColor[0.3608, 0.67166, 0.943003], "pa" -> 
           RGBColor[0.397469, 0.628, 0.898853], "u" -> 
           RGBColor[0.43205, 0.58595, 0.856029], "np" -> 
           RGBColor[0.464542, 0.54551, 0.814532], "pu" -> 
           RGBColor[0.494945, 0.506679, 0.774361], "am" -> 
           RGBColor[0.52326, 0.469458, 0.735517], "cm" -> 
           RGBColor[0.549486, 0.433847, 0.697999], "bk" -> 
           RGBColor[0.573624, 0.399845, 0.661808], "cf" -> 
           RGBColor[0.595673, 0.367454, 0.626942], "es" -> 
           RGBColor[0.615633, 0.336672, 0.593404], "fm" -> 
           RGBColor[0.633505, 0.307499, 0.561191], "md" -> 
           RGBColor[0.649288, 0.279937, 0.530305], "no" -> 
           RGBColor[0.662982, 0.253984, 0.500746], "lr" -> 
           RGBColor[0.674588, 0.22964, 0.472513], "rf" -> 
           RGBColor[0.684106, 0.206907, 0.445606], "db" -> 
           RGBColor[0.691534, 0.185783, 0.420025], "sg" -> 
           RGBColor[0.696874, 0.166269, 0.395772], "bh" -> 
           RGBColor[0.700126, 0.148365, 0.372844], "hs" -> 
           RGBColor[0.701289, 0.13207, 0.351243], "mt" -> 
           RGBColor[0.700363, 0.117385, 0.330968], "ds" -> 
           RGBColor[0.697348, 0.10431, 0.31202], "rg" -> 
           RGBColor[0.692245, 0.0928444, 0.294398], "cn" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "nh" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "fl" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "mc" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "lv" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "ts" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "og" -> 
           RGBColor[0.635401, 0.0528, 0.226184], "uub" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "uut" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "uuq" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "uup" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "uuh" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "uus" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "uuo" -> 
           RGBColor[0.635401, 0.0528, 0.226184]}]]& ][0.85], 
       ColorDataFunction[
       "Atoms", 
        "Named", {{
         "H", "He", "Li", "Be", "B", "C", "N", "O", "F", "Ne", "Na", "Mg", 
          "Al", "Si", "P", "S", "Cl", "Ar", "K", "Ca", "Sc", "Ti", "V", "Cr", 
          "Mn", "Fe", "Co", "Ni", "Cu", "Zn", "Ga", "Ge", "As", "Se", "Br", 
          "Kr", "Rb", "Sr", "Y", "Zr", "Nb", "Mo", "Tc", "Ru", "Rh", "Pd", 
          "Ag", "Cd", "In", "Sn", "Sb", "Te", "I", "Xe", "Cs", "Ba", "La", 
          "Ce", "Pr", "Nd", "Pm", "Sm", "Eu", "Gd", "Tb", "Dy", "Ho", "Er", 
          "Tm", "Yb", "Lu", "Hf", "Ta", "W", "Re", "Os", "Ir", "Pt", "Au", 
          "Hg", "Tl", "Pb", "Bi", "Po", "At", "Rn", "Fr", "Ra", "Ac", "Th", 
          "Pa", "U", "Np", "Pu", "Am", "Cm", "Bk", "Cf", "Es", "Fm", "Md", 
          "No", "Lr", "Rf", "Db", "Sg", "Bh", "Hs", "Mt", "Ds", "Rg", "Cn", 
          "Nh", "Fl", "Mc", "Lv", "Ts", "Og", "Uub", "Uut", "Uuq", "Uup", 
          "Uuh", "Uus", "Uuo"}, {
         "h", "he", "li", "be", "b", "c", "n", "o", "f", "ne", "na", "mg", 
          "al", "si", "p", "s", "cl", "ar", "k", "ca", "sc", "ti", "v", "cr", 
          "mn", "fe", "co", "ni", "cu", "zn", "ga", "ge", "as", "se", "br", 
          "kr", "rb", "sr", "y", "zr", "nb", "mo", "tc", "ru", "rh", "pd", 
          "ag", "cd", "in", "sn", "sb", "te", "i", "xe", "cs", "ba", "la", 
          "ce", "pr", "nd", "pm", "sm", "eu", "gd", "tb", "dy", "ho", "er", 
          "tm", "yb", "lu", "hf", "ta", "w", "re", "os", "ir", "pt", "au", 
          "hg", "tl", "pb", "bi", "po", "at", "rn", "fr", "ra", "ac", "th", 
          "pa", "u", "np", "pu", "am", "cm", "bk", "cf", "es", "fm", "md", 
          "no", "lr", "rf", "db", "sg", "bh", "hs", "mt", "ds", "rg", "cn", 
          "nh", "fl", "mc", "lv", "ts", "og", "uub", "uut", "uuq", "uup", 
          "uuh", "uus", "uuo"}}, Replace[#, 
         Dispatch[{
          "h" -> RGBColor[0.65, 0.7, 0.7], "he" -> RGBColor[0.836713, 1., 1.],
            "li" -> RGBColor[0.799435, 0.543572, 0.997559], "be" -> 
           RGBColor[0.770565, 0.964309, 0.0442359], "b" -> 
           RGBColor[1., 0.709804, 0.709804], "c" -> RGBColor[0.4, 0.4, 0.4], 
           "n" -> RGBColor[0.291989, 0.437977, 0.888609], "o" -> 
           RGBColor[0.800498, 0.201504, 0.192061], "f" -> 
           RGBColor[0.578462, 0.85539, 0.408855], "ne" -> 
           RGBColor[0.677263, 0.928423, 0.955287], "na" -> 
           RGBColor[0.658708, 0.492173, 0.842842], "mg" -> 
           RGBColor[0.628274, 0.850553, 0.0782731], "al" -> 
           RGBColor[0.8913, 0.631904, 0.627399], "si" -> 
           RGBColor[0.941176, 0.784314, 0.627451], "p" -> 
           RGBColor[1., 0.501961, 0], "s" -> 
           RGBColor[0.90443, 0.97015, 0.13504], "cl" -> 
           RGBColor[0.412698, 0.932689, 0.166398], "ar" -> 
           RGBColor[0.546138, 0.844244, 0.892092], "k" -> 
           RGBColor[0.534026, 0.420729, 0.705621], "ca" -> 
           RGBColor[0.480072, 0.744591, 0.0955222], "sc" -> 
           RGBColor[0.901961, 0.901961, 0.901961], "ti" -> 
           RGBColor[0.74902, 0.760784, 0.780392], "v" -> 
           RGBColor[0.65098, 0.65098, 0.670588], "cr" -> 
           RGBColor[0.541176, 0.6, 0.780392], "mn" -> 
           RGBColor[0.611765, 0.478431, 0.780392], "fe" -> 
           RGBColor[0.878431, 0.4, 0.2], "co" -> 
           RGBColor[0.941176, 0.564706, 0.627451], "ni" -> 
           RGBColor[0.313725, 0.815686, 0.313725], "cu" -> 
           RGBColor[0.784314, 0.501961, 0.2], "zn" -> 
           RGBColor[0.490196, 0.501961, 0.690196], "ga" -> 
           RGBColor[0.800757, 0.542666, 0.533513], "ge" -> 
           RGBColor[0.60508, 0.632465, 0.576489], "as" -> 
           RGBColor[0.741176, 0.501961, 0.890196], "se" -> 
           RGBColor[0.917248, 0.657833, 0.0706628], "br" -> 
           RGBColor[0.58847, 0.22163, 0.16064], "kr" -> 
           RGBColor[0.426019, 0.747462, 0.810413], "rb" -> 
           RGBColor[0.425391, 0.329242, 0.585895], "sr" -> 
           RGBColor[0.325959, 0.646423, 0.095983], "y" -> 
           RGBColor[0.531014, 1., 1.], "zr" -> 
           RGBColor[0.458599, 0.917466, 0.918573], "nb" -> 
           RGBColor[0.385036, 0.834854, 0.841681], "mo" -> 
           RGBColor[0.310325, 0.752163, 0.769323], "tc" -> 
           RGBColor[0.234466, 0.669394, 0.701499], "ru" -> 
           RGBColor[0.157459, 0.586546, 0.638209], "rh" -> 
           RGBColor[0.0793033, 0.50362, 0.579453], "pd" -> 
           RGBColor[0., 0.420615, 0.525231], "ag" -> 
           RGBColor[0.752941, 0.752941, 0.752941], "cd" -> 
           RGBColor[1., 0.85098, 0.560784], "in" -> 
           RGBColor[0.728371, 0.440594, 0.422196], "sn" -> 
           RGBColor[0.39799, 0.491477, 0.495586], "sb" -> 
           RGBColor[0.619608, 0.388235, 0.709804], "te" -> 
           RGBColor[0.816706, 0.451332, 0.0100947], "i" -> 
           RGBColor[0.580392, 0, 0.580392], "xe" -> 
           RGBColor[0.316906, 0.638078, 0.710252], "cs" -> 
           RGBColor[0.332803, 0.217712, 0.483666], "ba" -> 
           RGBColor[0.165935, 0.55605, 0.0796556], "la" -> 
           RGBColor[0.928084, 0.716075, 0.329427], "ce" -> 
           RGBColor[0.894824, 0.731424, 0.325131], "pr" -> 
           RGBColor[0.86523, 0.707999, 0.315261], "nd" -> 
           RGBColor[0.837836, 0.662974, 0.301635], "pm" -> 
           RGBColor[0.811992, 0.607859, 0.285626], "sm" -> 
           RGBColor[0.787563, 0.549894, 0.268279], "eu" -> 
           RGBColor[0.764628, 0.493261, 0.250405], "gd" -> 
           RGBColor[0.743177, 0.440115, 0.23269], "tb" -> 
           RGBColor[0.72281, 0.39143, 0.215783], "dy" -> 
           RGBColor[0.702434, 0.347663, 0.200392], "ho" -> 
           RGBColor[0.679962, 0.309234, 0.187368], "er" -> 
           RGBColor[0.652012, 0.276823, 0.17779], "tm" -> 
           RGBColor[0.613603, 0.251489, 0.173042], "yb" -> 
           RGBColor[0.557855, 0.234598, 0.17489], "lu" -> 
           RGBColor[0.475685, 0.227573, 0.18555], "hf" -> 
           RGBColor[0.781537, 0.717388, 0.716579], "ta" -> 
           RGBColor[0.734443, 0.544489, 0.683471], "w" -> 
           RGBColor[0.681179, 0.360409, 0.63675], "re" -> 
           RGBColor[0.605181, 0.367584, 0.556343], "os" -> 
           RGBColor[0.521806, 0.382125, 0.469204], "ir" -> 
           RGBColor[0.445624, 0.373159, 0.399069], "pt" -> 
           RGBColor[0.815686, 0.815686, 0.878431], "au" -> 
           RGBColor[1., 0.819608, 0.137255], "hg" -> 
           RGBColor[0.721569, 0.721569, 0.815686], "tl" -> 
           RGBColor[0.65098, 0.329412, 0.301961], "pb" -> 
           RGBColor[0.341176, 0.34902, 0.380392], "bi" -> 
           RGBColor[0.619608, 0.309804, 0.709804], "po" -> 
           RGBColor[0.670588, 0.360784, 0], "at" -> 
           RGBColor[0.458824, 0.309804, 0.270588], "rn" -> 
           RGBColor[0.218799, 0.516091, 0.591608], "fr" -> 
           RGBColor[0.25626, 0.0861372, 0.398932], "ra" -> 
           RGBColor[0., 0.473472, 0.04654], "ac" -> 
           RGBColor[0.322042, 0.71693, 0.988479], "th" -> 
           RGBColor[0.3608, 0.67166, 0.943003], "pa" -> 
           RGBColor[0.397469, 0.628, 0.898853], "u" -> 
           RGBColor[0.43205, 0.58595, 0.856029], "np" -> 
           RGBColor[0.464542, 0.54551, 0.814532], "pu" -> 
           RGBColor[0.494945, 0.506679, 0.774361], "am" -> 
           RGBColor[0.52326, 0.469458, 0.735517], "cm" -> 
           RGBColor[0.549486, 0.433847, 0.697999], "bk" -> 
           RGBColor[0.573624, 0.399845, 0.661808], "cf" -> 
           RGBColor[0.595673, 0.367454, 0.626942], "es" -> 
           RGBColor[0.615633, 0.336672, 0.593404], "fm" -> 
           RGBColor[0.633505, 0.307499, 0.561191], "md" -> 
           RGBColor[0.649288, 0.279937, 0.530305], "no" -> 
           RGBColor[0.662982, 0.253984, 0.500746], "lr" -> 
           RGBColor[0.674588, 0.22964, 0.472513], "rf" -> 
           RGBColor[0.684106, 0.206907, 0.445606], "db" -> 
           RGBColor[0.691534, 0.185783, 0.420025], "sg" -> 
           RGBColor[0.696874, 0.166269, 0.395772], "bh" -> 
           RGBColor[0.700126, 0.148365, 0.372844], "hs" -> 
           RGBColor[0.701289, 0.13207, 0.351243], "mt" -> 
           RGBColor[0.700363, 0.117385, 0.330968], "ds" -> 
           RGBColor[0.697348, 0.10431, 0.31202], "rg" -> 
           RGBColor[0.692245, 0.0928444, 0.294398], "cn" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "nh" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "fl" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "mc" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "lv" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "ts" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "og" -> 
           RGBColor[0.635401, 0.0528, 0.226184], "uub" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "uut" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "uuq" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "uup" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "uuh" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "uus" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "uuo" -> 
           RGBColor[0.635401, 0.0528, 0.226184]}]]& ][0.85], 
       ColorDataFunction[
       "Atoms", 
        "Named", {{
         "H", "He", "Li", "Be", "B", "C", "N", "O", "F", "Ne", "Na", "Mg", 
          "Al", "Si", "P", "S", "Cl", "Ar", "K", "Ca", "Sc", "Ti", "V", "Cr", 
          "Mn", "Fe", "Co", "Ni", "Cu", "Zn", "Ga", "Ge", "As", "Se", "Br", 
          "Kr", "Rb", "Sr", "Y", "Zr", "Nb", "Mo", "Tc", "Ru", "Rh", "Pd", 
          "Ag", "Cd", "In", "Sn", "Sb", "Te", "I", "Xe", "Cs", "Ba", "La", 
          "Ce", "Pr", "Nd", "Pm", "Sm", "Eu", "Gd", "Tb", "Dy", "Ho", "Er", 
          "Tm", "Yb", "Lu", "Hf", "Ta", "W", "Re", "Os", "Ir", "Pt", "Au", 
          "Hg", "Tl", "Pb", "Bi", "Po", "At", "Rn", "Fr", "Ra", "Ac", "Th", 
          "Pa", "U", "Np", "Pu", "Am", "Cm", "Bk", "Cf", "Es", "Fm", "Md", 
          "No", "Lr", "Rf", "Db", "Sg", "Bh", "Hs", "Mt", "Ds", "Rg", "Cn", 
          "Nh", "Fl", "Mc", "Lv", "Ts", "Og", "Uub", "Uut", "Uuq", "Uup", 
          "Uuh", "Uus", "Uuo"}, {
         "h", "he", "li", "be", "b", "c", "n", "o", "f", "ne", "na", "mg", 
          "al", "si", "p", "s", "cl", "ar", "k", "ca", "sc", "ti", "v", "cr", 
          "mn", "fe", "co", "ni", "cu", "zn", "ga", "ge", "as", "se", "br", 
          "kr", "rb", "sr", "y", "zr", "nb", "mo", "tc", "ru", "rh", "pd", 
          "ag", "cd", "in", "sn", "sb", "te", "i", "xe", "cs", "ba", "la", 
          "ce", "pr", "nd", "pm", "sm", "eu", "gd", "tb", "dy", "ho", "er", 
          "tm", "yb", "lu", "hf", "ta", "w", "re", "os", "ir", "pt", "au", 
          "hg", "tl", "pb", "bi", "po", "at", "rn", "fr", "ra", "ac", "th", 
          "pa", "u", "np", "pu", "am", "cm", "bk", "cf", "es", "fm", "md", 
          "no", "lr", "rf", "db", "sg", "bh", "hs", "mt", "ds", "rg", "cn", 
          "nh", "fl", "mc", "lv", "ts", "og", "uub", "uut", "uuq", "uup", 
          "uuh", "uus", "uuo"}}, Replace[#, 
         Dispatch[{
          "h" -> RGBColor[0.65, 0.7, 0.7], "he" -> RGBColor[0.836713, 1., 1.],
            "li" -> RGBColor[0.799435, 0.543572, 0.997559], "be" -> 
           RGBColor[0.770565, 0.964309, 0.0442359], "b" -> 
           RGBColor[1., 0.709804, 0.709804], "c" -> RGBColor[0.4, 0.4, 0.4], 
           "n" -> RGBColor[0.291989, 0.437977, 0.888609], "o" -> 
           RGBColor[0.800498, 0.201504, 0.192061], "f" -> 
           RGBColor[0.578462, 0.85539, 0.408855], "ne" -> 
           RGBColor[0.677263, 0.928423, 0.955287], "na" -> 
           RGBColor[0.658708, 0.492173, 0.842842], "mg" -> 
           RGBColor[0.628274, 0.850553, 0.0782731], "al" -> 
           RGBColor[0.8913, 0.631904, 0.627399], "si" -> 
           RGBColor[0.941176, 0.784314, 0.627451], "p" -> 
           RGBColor[1., 0.501961, 0], "s" -> 
           RGBColor[0.90443, 0.97015, 0.13504], "cl" -> 
           RGBColor[0.412698, 0.932689, 0.166398], "ar" -> 
           RGBColor[0.546138, 0.844244, 0.892092], "k" -> 
           RGBColor[0.534026, 0.420729, 0.705621], "ca" -> 
           RGBColor[0.480072, 0.744591, 0.0955222], "sc" -> 
           RGBColor[0.901961, 0.901961, 0.901961], "ti" -> 
           RGBColor[0.74902, 0.760784, 0.780392], "v" -> 
           RGBColor[0.65098, 0.65098, 0.670588], "cr" -> 
           RGBColor[0.541176, 0.6, 0.780392], "mn" -> 
           RGBColor[0.611765, 0.478431, 0.780392], "fe" -> 
           RGBColor[0.878431, 0.4, 0.2], "co" -> 
           RGBColor[0.941176, 0.564706, 0.627451], "ni" -> 
           RGBColor[0.313725, 0.815686, 0.313725], "cu" -> 
           RGBColor[0.784314, 0.501961, 0.2], "zn" -> 
           RGBColor[0.490196, 0.501961, 0.690196], "ga" -> 
           RGBColor[0.800757, 0.542666, 0.533513], "ge" -> 
           RGBColor[0.60508, 0.632465, 0.576489], "as" -> 
           RGBColor[0.741176, 0.501961, 0.890196], "se" -> 
           RGBColor[0.917248, 0.657833, 0.0706628], "br" -> 
           RGBColor[0.58847, 0.22163, 0.16064], "kr" -> 
           RGBColor[0.426019, 0.747462, 0.810413], "rb" -> 
           RGBColor[0.425391, 0.329242, 0.585895], "sr" -> 
           RGBColor[0.325959, 0.646423, 0.095983], "y" -> 
           RGBColor[0.531014, 1., 1.], "zr" -> 
           RGBColor[0.458599, 0.917466, 0.918573], "nb" -> 
           RGBColor[0.385036, 0.834854, 0.841681], "mo" -> 
           RGBColor[0.310325, 0.752163, 0.769323], "tc" -> 
           RGBColor[0.234466, 0.669394, 0.701499], "ru" -> 
           RGBColor[0.157459, 0.586546, 0.638209], "rh" -> 
           RGBColor[0.0793033, 0.50362, 0.579453], "pd" -> 
           RGBColor[0., 0.420615, 0.525231], "ag" -> 
           RGBColor[0.752941, 0.752941, 0.752941], "cd" -> 
           RGBColor[1., 0.85098, 0.560784], "in" -> 
           RGBColor[0.728371, 0.440594, 0.422196], "sn" -> 
           RGBColor[0.39799, 0.491477, 0.495586], "sb" -> 
           RGBColor[0.619608, 0.388235, 0.709804], "te" -> 
           RGBColor[0.816706, 0.451332, 0.0100947], "i" -> 
           RGBColor[0.580392, 0, 0.580392], "xe" -> 
           RGBColor[0.316906, 0.638078, 0.710252], "cs" -> 
           RGBColor[0.332803, 0.217712, 0.483666], "ba" -> 
           RGBColor[0.165935, 0.55605, 0.0796556], "la" -> 
           RGBColor[0.928084, 0.716075, 0.329427], "ce" -> 
           RGBColor[0.894824, 0.731424, 0.325131], "pr" -> 
           RGBColor[0.86523, 0.707999, 0.315261], "nd" -> 
           RGBColor[0.837836, 0.662974, 0.301635], "pm" -> 
           RGBColor[0.811992, 0.607859, 0.285626], "sm" -> 
           RGBColor[0.787563, 0.549894, 0.268279], "eu" -> 
           RGBColor[0.764628, 0.493261, 0.250405], "gd" -> 
           RGBColor[0.743177, 0.440115, 0.23269], "tb" -> 
           RGBColor[0.72281, 0.39143, 0.215783], "dy" -> 
           RGBColor[0.702434, 0.347663, 0.200392], "ho" -> 
           RGBColor[0.679962, 0.309234, 0.187368], "er" -> 
           RGBColor[0.652012, 0.276823, 0.17779], "tm" -> 
           RGBColor[0.613603, 0.251489, 0.173042], "yb" -> 
           RGBColor[0.557855, 0.234598, 0.17489], "lu" -> 
           RGBColor[0.475685, 0.227573, 0.18555], "hf" -> 
           RGBColor[0.781537, 0.717388, 0.716579], "ta" -> 
           RGBColor[0.734443, 0.544489, 0.683471], "w" -> 
           RGBColor[0.681179, 0.360409, 0.63675], "re" -> 
           RGBColor[0.605181, 0.367584, 0.556343], "os" -> 
           RGBColor[0.521806, 0.382125, 0.469204], "ir" -> 
           RGBColor[0.445624, 0.373159, 0.399069], "pt" -> 
           RGBColor[0.815686, 0.815686, 0.878431], "au" -> 
           RGBColor[1., 0.819608, 0.137255], "hg" -> 
           RGBColor[0.721569, 0.721569, 0.815686], "tl" -> 
           RGBColor[0.65098, 0.329412, 0.301961], "pb" -> 
           RGBColor[0.341176, 0.34902, 0.380392], "bi" -> 
           RGBColor[0.619608, 0.309804, 0.709804], "po" -> 
           RGBColor[0.670588, 0.360784, 0], "at" -> 
           RGBColor[0.458824, 0.309804, 0.270588], "rn" -> 
           RGBColor[0.218799, 0.516091, 0.591608], "fr" -> 
           RGBColor[0.25626, 0.0861372, 0.398932], "ra" -> 
           RGBColor[0., 0.473472, 0.04654], "ac" -> 
           RGBColor[0.322042, 0.71693, 0.988479], "th" -> 
           RGBColor[0.3608, 0.67166, 0.943003], "pa" -> 
           RGBColor[0.397469, 0.628, 0.898853], "u" -> 
           RGBColor[0.43205, 0.58595, 0.856029], "np" -> 
           RGBColor[0.464542, 0.54551, 0.814532], "pu" -> 
           RGBColor[0.494945, 0.506679, 0.774361], "am" -> 
           RGBColor[0.52326, 0.469458, 0.735517], "cm" -> 
           RGBColor[0.549486, 0.433847, 0.697999], "bk" -> 
           RGBColor[0.573624, 0.399845, 0.661808], "cf" -> 
           RGBColor[0.595673, 0.367454, 0.626942], "es" -> 
           RGBColor[0.615633, 0.336672, 0.593404], "fm" -> 
           RGBColor[0.633505, 0.307499, 0.561191], "md" -> 
           RGBColor[0.649288, 0.279937, 0.530305], "no" -> 
           RGBColor[0.662982, 0.253984, 0.500746], "lr" -> 
           RGBColor[0.674588, 0.22964, 0.472513], "rf" -> 
           RGBColor[0.684106, 0.206907, 0.445606], "db" -> 
           RGBColor[0.691534, 0.185783, 0.420025], "sg" -> 
           RGBColor[0.696874, 0.166269, 0.395772], "bh" -> 
           RGBColor[0.700126, 0.148365, 0.372844], "hs" -> 
           RGBColor[0.701289, 0.13207, 0.351243], "mt" -> 
           RGBColor[0.700363, 0.117385, 0.330968], "ds" -> 
           RGBColor[0.697348, 0.10431, 0.31202], "rg" -> 
           RGBColor[0.692245, 0.0928444, 0.294398], "cn" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "nh" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "fl" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "mc" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "lv" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "ts" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "og" -> 
           RGBColor[0.635401, 0.0528, 0.226184], "uub" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "uut" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "uuq" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "uup" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "uuh" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "uus" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "uuo" -> 
           RGBColor[0.635401, 0.0528, 0.226184]}]]& ][0.85], 
       ColorDataFunction[
       "Atoms", 
        "Named", {{
         "H", "He", "Li", "Be", "B", "C", "N", "O", "F", "Ne", "Na", "Mg", 
          "Al", "Si", "P", "S", "Cl", "Ar", "K", "Ca", "Sc", "Ti", "V", "Cr", 
          "Mn", "Fe", "Co", "Ni", "Cu", "Zn", "Ga", "Ge", "As", "Se", "Br", 
          "Kr", "Rb", "Sr", "Y", "Zr", "Nb", "Mo", "Tc", "Ru", "Rh", "Pd", 
          "Ag", "Cd", "In", "Sn", "Sb", "Te", "I", "Xe", "Cs", "Ba", "La", 
          "Ce", "Pr", "Nd", "Pm", "Sm", "Eu", "Gd", "Tb", "Dy", "Ho", "Er", 
          "Tm", "Yb", "Lu", "Hf", "Ta", "W", "Re", "Os", "Ir", "Pt", "Au", 
          "Hg", "Tl", "Pb", "Bi", "Po", "At", "Rn", "Fr", "Ra", "Ac", "Th", 
          "Pa", "U", "Np", "Pu", "Am", "Cm", "Bk", "Cf", "Es", "Fm", "Md", 
          "No", "Lr", "Rf", "Db", "Sg", "Bh", "Hs", "Mt", "Ds", "Rg", "Cn", 
          "Nh", "Fl", "Mc", "Lv", "Ts", "Og", "Uub", "Uut", "Uuq", "Uup", 
          "Uuh", "Uus", "Uuo"}, {
         "h", "he", "li", "be", "b", "c", "n", "o", "f", "ne", "na", "mg", 
          "al", "si", "p", "s", "cl", "ar", "k", "ca", "sc", "ti", "v", "cr", 
          "mn", "fe", "co", "ni", "cu", "zn", "ga", "ge", "as", "se", "br", 
          "kr", "rb", "sr", "y", "zr", "nb", "mo", "tc", "ru", "rh", "pd", 
          "ag", "cd", "in", "sn", "sb", "te", "i", "xe", "cs", "ba", "la", 
          "ce", "pr", "nd", "pm", "sm", "eu", "gd", "tb", "dy", "ho", "er", 
          "tm", "yb", "lu", "hf", "ta", "w", "re", "os", "ir", "pt", "au", 
          "hg", "tl", "pb", "bi", "po", "at", "rn", "fr", "ra", "ac", "th", 
          "pa", "u", "np", "pu", "am", "cm", "bk", "cf", "es", "fm", "md", 
          "no", "lr", "rf", "db", "sg", "bh", "hs", "mt", "ds", "rg", "cn", 
          "nh", "fl", "mc", "lv", "ts", "og", "uub", "uut", "uuq", "uup", 
          "uuh", "uus", "uuo"}}, Replace[#, 
         Dispatch[{
          "h" -> RGBColor[0.65, 0.7, 0.7], "he" -> RGBColor[0.836713, 1., 1.],
            "li" -> RGBColor[0.799435, 0.543572, 0.997559], "be" -> 
           RGBColor[0.770565, 0.964309, 0.0442359], "b" -> 
           RGBColor[1., 0.709804, 0.709804], "c" -> RGBColor[0.4, 0.4, 0.4], 
           "n" -> RGBColor[0.291989, 0.437977, 0.888609], "o" -> 
           RGBColor[0.800498, 0.201504, 0.192061], "f" -> 
           RGBColor[0.578462, 0.85539, 0.408855], "ne" -> 
           RGBColor[0.677263, 0.928423, 0.955287], "na" -> 
           RGBColor[0.658708, 0.492173, 0.842842], "mg" -> 
           RGBColor[0.628274, 0.850553, 0.0782731], "al" -> 
           RGBColor[0.8913, 0.631904, 0.627399], "si" -> 
           RGBColor[0.941176, 0.784314, 0.627451], "p" -> 
           RGBColor[1., 0.501961, 0], "s" -> 
           RGBColor[0.90443, 0.97015, 0.13504], "cl" -> 
           RGBColor[0.412698, 0.932689, 0.166398], "ar" -> 
           RGBColor[0.546138, 0.844244, 0.892092], "k" -> 
           RGBColor[0.534026, 0.420729, 0.705621], "ca" -> 
           RGBColor[0.480072, 0.744591, 0.0955222], "sc" -> 
           RGBColor[0.901961, 0.901961, 0.901961], "ti" -> 
           RGBColor[0.74902, 0.760784, 0.780392], "v" -> 
           RGBColor[0.65098, 0.65098, 0.670588], "cr" -> 
           RGBColor[0.541176, 0.6, 0.780392], "mn" -> 
           RGBColor[0.611765, 0.478431, 0.780392], "fe" -> 
           RGBColor[0.878431, 0.4, 0.2], "co" -> 
           RGBColor[0.941176, 0.564706, 0.627451], "ni" -> 
           RGBColor[0.313725, 0.815686, 0.313725], "cu" -> 
           RGBColor[0.784314, 0.501961, 0.2], "zn" -> 
           RGBColor[0.490196, 0.501961, 0.690196], "ga" -> 
           RGBColor[0.800757, 0.542666, 0.533513], "ge" -> 
           RGBColor[0.60508, 0.632465, 0.576489], "as" -> 
           RGBColor[0.741176, 0.501961, 0.890196], "se" -> 
           RGBColor[0.917248, 0.657833, 0.0706628], "br" -> 
           RGBColor[0.58847, 0.22163, 0.16064], "kr" -> 
           RGBColor[0.426019, 0.747462, 0.810413], "rb" -> 
           RGBColor[0.425391, 0.329242, 0.585895], "sr" -> 
           RGBColor[0.325959, 0.646423, 0.095983], "y" -> 
           RGBColor[0.531014, 1., 1.], "zr" -> 
           RGBColor[0.458599, 0.917466, 0.918573], "nb" -> 
           RGBColor[0.385036, 0.834854, 0.841681], "mo" -> 
           RGBColor[0.310325, 0.752163, 0.769323], "tc" -> 
           RGBColor[0.234466, 0.669394, 0.701499], "ru" -> 
           RGBColor[0.157459, 0.586546, 0.638209], "rh" -> 
           RGBColor[0.0793033, 0.50362, 0.579453], "pd" -> 
           RGBColor[0., 0.420615, 0.525231], "ag" -> 
           RGBColor[0.752941, 0.752941, 0.752941], "cd" -> 
           RGBColor[1., 0.85098, 0.560784], "in" -> 
           RGBColor[0.728371, 0.440594, 0.422196], "sn" -> 
           RGBColor[0.39799, 0.491477, 0.495586], "sb" -> 
           RGBColor[0.619608, 0.388235, 0.709804], "te" -> 
           RGBColor[0.816706, 0.451332, 0.0100947], "i" -> 
           RGBColor[0.580392, 0, 0.580392], "xe" -> 
           RGBColor[0.316906, 0.638078, 0.710252], "cs" -> 
           RGBColor[0.332803, 0.217712, 0.483666], "ba" -> 
           RGBColor[0.165935, 0.55605, 0.0796556], "la" -> 
           RGBColor[0.928084, 0.716075, 0.329427], "ce" -> 
           RGBColor[0.894824, 0.731424, 0.325131], "pr" -> 
           RGBColor[0.86523, 0.707999, 0.315261], "nd" -> 
           RGBColor[0.837836, 0.662974, 0.301635], "pm" -> 
           RGBColor[0.811992, 0.607859, 0.285626], "sm" -> 
           RGBColor[0.787563, 0.549894, 0.268279], "eu" -> 
           RGBColor[0.764628, 0.493261, 0.250405], "gd" -> 
           RGBColor[0.743177, 0.440115, 0.23269], "tb" -> 
           RGBColor[0.72281, 0.39143, 0.215783], "dy" -> 
           RGBColor[0.702434, 0.347663, 0.200392], "ho" -> 
           RGBColor[0.679962, 0.309234, 0.187368], "er" -> 
           RGBColor[0.652012, 0.276823, 0.17779], "tm" -> 
           RGBColor[0.613603, 0.251489, 0.173042], "yb" -> 
           RGBColor[0.557855, 0.234598, 0.17489], "lu" -> 
           RGBColor[0.475685, 0.227573, 0.18555], "hf" -> 
           RGBColor[0.781537, 0.717388, 0.716579], "ta" -> 
           RGBColor[0.734443, 0.544489, 0.683471], "w" -> 
           RGBColor[0.681179, 0.360409, 0.63675], "re" -> 
           RGBColor[0.605181, 0.367584, 0.556343], "os" -> 
           RGBColor[0.521806, 0.382125, 0.469204], "ir" -> 
           RGBColor[0.445624, 0.373159, 0.399069], "pt" -> 
           RGBColor[0.815686, 0.815686, 0.878431], "au" -> 
           RGBColor[1., 0.819608, 0.137255], "hg" -> 
           RGBColor[0.721569, 0.721569, 0.815686], "tl" -> 
           RGBColor[0.65098, 0.329412, 0.301961], "pb" -> 
           RGBColor[0.341176, 0.34902, 0.380392], "bi" -> 
           RGBColor[0.619608, 0.309804, 0.709804], "po" -> 
           RGBColor[0.670588, 0.360784, 0], "at" -> 
           RGBColor[0.458824, 0.309804, 0.270588], "rn" -> 
           RGBColor[0.218799, 0.516091, 0.591608], "fr" -> 
           RGBColor[0.25626, 0.0861372, 0.398932], "ra" -> 
           RGBColor[0., 0.473472, 0.04654], "ac" -> 
           RGBColor[0.322042, 0.71693, 0.988479], "th" -> 
           RGBColor[0.3608, 0.67166, 0.943003], "pa" -> 
           RGBColor[0.397469, 0.628, 0.898853], "u" -> 
           RGBColor[0.43205, 0.58595, 0.856029], "np" -> 
           RGBColor[0.464542, 0.54551, 0.814532], "pu" -> 
           RGBColor[0.494945, 0.506679, 0.774361], "am" -> 
           RGBColor[0.52326, 0.469458, 0.735517], "cm" -> 
           RGBColor[0.549486, 0.433847, 0.697999], "bk" -> 
           RGBColor[0.573624, 0.399845, 0.661808], "cf" -> 
           RGBColor[0.595673, 0.367454, 0.626942], "es" -> 
           RGBColor[0.615633, 0.336672, 0.593404], "fm" -> 
           RGBColor[0.633505, 0.307499, 0.561191], "md" -> 
           RGBColor[0.649288, 0.279937, 0.530305], "no" -> 
           RGBColor[0.662982, 0.253984, 0.500746], "lr" -> 
           RGBColor[0.674588, 0.22964, 0.472513], "rf" -> 
           RGBColor[0.684106, 0.206907, 0.445606], "db" -> 
           RGBColor[0.691534, 0.185783, 0.420025], "sg" -> 
           RGBColor[0.696874, 0.166269, 0.395772], "bh" -> 
           RGBColor[0.700126, 0.148365, 0.372844], "hs" -> 
           RGBColor[0.701289, 0.13207, 0.351243], "mt" -> 
           RGBColor[0.700363, 0.117385, 0.330968], "ds" -> 
           RGBColor[0.697348, 0.10431, 0.31202], "rg" -> 
           RGBColor[0.692245, 0.0928444, 0.294398], "cn" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "nh" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "fl" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "mc" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "lv" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "ts" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "og" -> 
           RGBColor[0.635401, 0.0528, 0.226184], "uub" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "uut" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "uuq" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "uup" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "uuh" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "uus" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "uuo" -> 
           RGBColor[0.635401, 0.0528, 0.226184]}]]& ][0.85], 
       ColorDataFunction[
       "Atoms", 
        "Named", {{
         "H", "He", "Li", "Be", "B", "C", "N", "O", "F", "Ne", "Na", "Mg", 
          "Al", "Si", "P", "S", "Cl", "Ar", "K", "Ca", "Sc", "Ti", "V", "Cr", 
          "Mn", "Fe", "Co", "Ni", "Cu", "Zn", "Ga", "Ge", "As", "Se", "Br", 
          "Kr", "Rb", "Sr", "Y", "Zr", "Nb", "Mo", "Tc", "Ru", "Rh", "Pd", 
          "Ag", "Cd", "In", "Sn", "Sb", "Te", "I", "Xe", "Cs", "Ba", "La", 
          "Ce", "Pr", "Nd", "Pm", "Sm", "Eu", "Gd", "Tb", "Dy", "Ho", "Er", 
          "Tm", "Yb", "Lu", "Hf", "Ta", "W", "Re", "Os", "Ir", "Pt", "Au", 
          "Hg", "Tl", "Pb", "Bi", "Po", "At", "Rn", "Fr", "Ra", "Ac", "Th", 
          "Pa", "U", "Np", "Pu", "Am", "Cm", "Bk", "Cf", "Es", "Fm", "Md", 
          "No", "Lr", "Rf", "Db", "Sg", "Bh", "Hs", "Mt", "Ds", "Rg", "Cn", 
          "Nh", "Fl", "Mc", "Lv", "Ts", "Og", "Uub", "Uut", "Uuq", "Uup", 
          "Uuh", "Uus", "Uuo"}, {
         "h", "he", "li", "be", "b", "c", "n", "o", "f", "ne", "na", "mg", 
          "al", "si", "p", "s", "cl", "ar", "k", "ca", "sc", "ti", "v", "cr", 
          "mn", "fe", "co", "ni", "cu", "zn", "ga", "ge", "as", "se", "br", 
          "kr", "rb", "sr", "y", "zr", "nb", "mo", "tc", "ru", "rh", "pd", 
          "ag", "cd", "in", "sn", "sb", "te", "i", "xe", "cs", "ba", "la", 
          "ce", "pr", "nd", "pm", "sm", "eu", "gd", "tb", "dy", "ho", "er", 
          "tm", "yb", "lu", "hf", "ta", "w", "re", "os", "ir", "pt", "au", 
          "hg", "tl", "pb", "bi", "po", "at", "rn", "fr", "ra", "ac", "th", 
          "pa", "u", "np", "pu", "am", "cm", "bk", "cf", "es", "fm", "md", 
          "no", "lr", "rf", "db", "sg", "bh", "hs", "mt", "ds", "rg", "cn", 
          "nh", "fl", "mc", "lv", "ts", "og", "uub", "uut", "uuq", "uup", 
          "uuh", "uus", "uuo"}}, Replace[#, 
         Dispatch[{
          "h" -> RGBColor[0.65, 0.7, 0.7], "he" -> RGBColor[0.836713, 1., 1.],
            "li" -> RGBColor[0.799435, 0.543572, 0.997559], "be" -> 
           RGBColor[0.770565, 0.964309, 0.0442359], "b" -> 
           RGBColor[1., 0.709804, 0.709804], "c" -> RGBColor[0.4, 0.4, 0.4], 
           "n" -> RGBColor[0.291989, 0.437977, 0.888609], "o" -> 
           RGBColor[0.800498, 0.201504, 0.192061], "f" -> 
           RGBColor[0.578462, 0.85539, 0.408855], "ne" -> 
           RGBColor[0.677263, 0.928423, 0.955287], "na" -> 
           RGBColor[0.658708, 0.492173, 0.842842], "mg" -> 
           RGBColor[0.628274, 0.850553, 0.0782731], "al" -> 
           RGBColor[0.8913, 0.631904, 0.627399], "si" -> 
           RGBColor[0.941176, 0.784314, 0.627451], "p" -> 
           RGBColor[1., 0.501961, 0], "s" -> 
           RGBColor[0.90443, 0.97015, 0.13504], "cl" -> 
           RGBColor[0.412698, 0.932689, 0.166398], "ar" -> 
           RGBColor[0.546138, 0.844244, 0.892092], "k" -> 
           RGBColor[0.534026, 0.420729, 0.705621], "ca" -> 
           RGBColor[0.480072, 0.744591, 0.0955222], "sc" -> 
           RGBColor[0.901961, 0.901961, 0.901961], "ti" -> 
           RGBColor[0.74902, 0.760784, 0.780392], "v" -> 
           RGBColor[0.65098, 0.65098, 0.670588], "cr" -> 
           RGBColor[0.541176, 0.6, 0.780392], "mn" -> 
           RGBColor[0.611765, 0.478431, 0.780392], "fe" -> 
           RGBColor[0.878431, 0.4, 0.2], "co" -> 
           RGBColor[0.941176, 0.564706, 0.627451], "ni" -> 
           RGBColor[0.313725, 0.815686, 0.313725], "cu" -> 
           RGBColor[0.784314, 0.501961, 0.2], "zn" -> 
           RGBColor[0.490196, 0.501961, 0.690196], "ga" -> 
           RGBColor[0.800757, 0.542666, 0.533513], "ge" -> 
           RGBColor[0.60508, 0.632465, 0.576489], "as" -> 
           RGBColor[0.741176, 0.501961, 0.890196], "se" -> 
           RGBColor[0.917248, 0.657833, 0.0706628], "br" -> 
           RGBColor[0.58847, 0.22163, 0.16064], "kr" -> 
           RGBColor[0.426019, 0.747462, 0.810413], "rb" -> 
           RGBColor[0.425391, 0.329242, 0.585895], "sr" -> 
           RGBColor[0.325959, 0.646423, 0.095983], "y" -> 
           RGBColor[0.531014, 1., 1.], "zr" -> 
           RGBColor[0.458599, 0.917466, 0.918573], "nb" -> 
           RGBColor[0.385036, 0.834854, 0.841681], "mo" -> 
           RGBColor[0.310325, 0.752163, 0.769323], "tc" -> 
           RGBColor[0.234466, 0.669394, 0.701499], "ru" -> 
           RGBColor[0.157459, 0.586546, 0.638209], "rh" -> 
           RGBColor[0.0793033, 0.50362, 0.579453], "pd" -> 
           RGBColor[0., 0.420615, 0.525231], "ag" -> 
           RGBColor[0.752941, 0.752941, 0.752941], "cd" -> 
           RGBColor[1., 0.85098, 0.560784], "in" -> 
           RGBColor[0.728371, 0.440594, 0.422196], "sn" -> 
           RGBColor[0.39799, 0.491477, 0.495586], "sb" -> 
           RGBColor[0.619608, 0.388235, 0.709804], "te" -> 
           RGBColor[0.816706, 0.451332, 0.0100947], "i" -> 
           RGBColor[0.580392, 0, 0.580392], "xe" -> 
           RGBColor[0.316906, 0.638078, 0.710252], "cs" -> 
           RGBColor[0.332803, 0.217712, 0.483666], "ba" -> 
           RGBColor[0.165935, 0.55605, 0.0796556], "la" -> 
           RGBColor[0.928084, 0.716075, 0.329427], "ce" -> 
           RGBColor[0.894824, 0.731424, 0.325131], "pr" -> 
           RGBColor[0.86523, 0.707999, 0.315261], "nd" -> 
           RGBColor[0.837836, 0.662974, 0.301635], "pm" -> 
           RGBColor[0.811992, 0.607859, 0.285626], "sm" -> 
           RGBColor[0.787563, 0.549894, 0.268279], "eu" -> 
           RGBColor[0.764628, 0.493261, 0.250405], "gd" -> 
           RGBColor[0.743177, 0.440115, 0.23269], "tb" -> 
           RGBColor[0.72281, 0.39143, 0.215783], "dy" -> 
           RGBColor[0.702434, 0.347663, 0.200392], "ho" -> 
           RGBColor[0.679962, 0.309234, 0.187368], "er" -> 
           RGBColor[0.652012, 0.276823, 0.17779], "tm" -> 
           RGBColor[0.613603, 0.251489, 0.173042], "yb" -> 
           RGBColor[0.557855, 0.234598, 0.17489], "lu" -> 
           RGBColor[0.475685, 0.227573, 0.18555], "hf" -> 
           RGBColor[0.781537, 0.717388, 0.716579], "ta" -> 
           RGBColor[0.734443, 0.544489, 0.683471], "w" -> 
           RGBColor[0.681179, 0.360409, 0.63675], "re" -> 
           RGBColor[0.605181, 0.367584, 0.556343], "os" -> 
           RGBColor[0.521806, 0.382125, 0.469204], "ir" -> 
           RGBColor[0.445624, 0.373159, 0.399069], "pt" -> 
           RGBColor[0.815686, 0.815686, 0.878431], "au" -> 
           RGBColor[1., 0.819608, 0.137255], "hg" -> 
           RGBColor[0.721569, 0.721569, 0.815686], "tl" -> 
           RGBColor[0.65098, 0.329412, 0.301961], "pb" -> 
           RGBColor[0.341176, 0.34902, 0.380392], "bi" -> 
           RGBColor[0.619608, 0.309804, 0.709804], "po" -> 
           RGBColor[0.670588, 0.360784, 0], "at" -> 
           RGBColor[0.458824, 0.309804, 0.270588], "rn" -> 
           RGBColor[0.218799, 0.516091, 0.591608], "fr" -> 
           RGBColor[0.25626, 0.0861372, 0.398932], "ra" -> 
           RGBColor[0., 0.473472, 0.04654], "ac" -> 
           RGBColor[0.322042, 0.71693, 0.988479], "th" -> 
           RGBColor[0.3608, 0.67166, 0.943003], "pa" -> 
           RGBColor[0.397469, 0.628, 0.898853], "u" -> 
           RGBColor[0.43205, 0.58595, 0.856029], "np" -> 
           RGBColor[0.464542, 0.54551, 0.814532], "pu" -> 
           RGBColor[0.494945, 0.506679, 0.774361], "am" -> 
           RGBColor[0.52326, 0.469458, 0.735517], "cm" -> 
           RGBColor[0.549486, 0.433847, 0.697999], "bk" -> 
           RGBColor[0.573624, 0.399845, 0.661808], "cf" -> 
           RGBColor[0.595673, 0.367454, 0.626942], "es" -> 
           RGBColor[0.615633, 0.336672, 0.593404], "fm" -> 
           RGBColor[0.633505, 0.307499, 0.561191], "md" -> 
           RGBColor[0.649288, 0.279937, 0.530305], "no" -> 
           RGBColor[0.662982, 0.253984, 0.500746], "lr" -> 
           RGBColor[0.674588, 0.22964, 0.472513], "rf" -> 
           RGBColor[0.684106, 0.206907, 0.445606], "db" -> 
           RGBColor[0.691534, 0.185783, 0.420025], "sg" -> 
           RGBColor[0.696874, 0.166269, 0.395772], "bh" -> 
           RGBColor[0.700126, 0.148365, 0.372844], "hs" -> 
           RGBColor[0.701289, 0.13207, 0.351243], "mt" -> 
           RGBColor[0.700363, 0.117385, 0.330968], "ds" -> 
           RGBColor[0.697348, 0.10431, 0.31202], "rg" -> 
           RGBColor[0.692245, 0.0928444, 0.294398], "cn" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "nh" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "fl" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "mc" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "lv" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "ts" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "og" -> 
           RGBColor[0.635401, 0.0528, 0.226184], "uub" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "uut" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "uuq" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "uup" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "uuh" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "uus" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "uuo" -> 
           RGBColor[0.635401, 0.0528, 0.226184]}]]& ][0.85], 
       ColorDataFunction[
       "Atoms", 
        "Named", {{
         "H", "He", "Li", "Be", "B", "C", "N", "O", "F", "Ne", "Na", "Mg", 
          "Al", "Si", "P", "S", "Cl", "Ar", "K", "Ca", "Sc", "Ti", "V", "Cr", 
          "Mn", "Fe", "Co", "Ni", "Cu", "Zn", "Ga", "Ge", "As", "Se", "Br", 
          "Kr", "Rb", "Sr", "Y", "Zr", "Nb", "Mo", "Tc", "Ru", "Rh", "Pd", 
          "Ag", "Cd", "In", "Sn", "Sb", "Te", "I", "Xe", "Cs", "Ba", "La", 
          "Ce", "Pr", "Nd", "Pm", "Sm", "Eu", "Gd", "Tb", "Dy", "Ho", "Er", 
          "Tm", "Yb", "Lu", "Hf", "Ta", "W", "Re", "Os", "Ir", "Pt", "Au", 
          "Hg", "Tl", "Pb", "Bi", "Po", "At", "Rn", "Fr", "Ra", "Ac", "Th", 
          "Pa", "U", "Np", "Pu", "Am", "Cm", "Bk", "Cf", "Es", "Fm", "Md", 
          "No", "Lr", "Rf", "Db", "Sg", "Bh", "Hs", "Mt", "Ds", "Rg", "Cn", 
          "Nh", "Fl", "Mc", "Lv", "Ts", "Og", "Uub", "Uut", "Uuq", "Uup", 
          "Uuh", "Uus", "Uuo"}, {
         "h", "he", "li", "be", "b", "c", "n", "o", "f", "ne", "na", "mg", 
          "al", "si", "p", "s", "cl", "ar", "k", "ca", "sc", "ti", "v", "cr", 
          "mn", "fe", "co", "ni", "cu", "zn", "ga", "ge", "as", "se", "br", 
          "kr", "rb", "sr", "y", "zr", "nb", "mo", "tc", "ru", "rh", "pd", 
          "ag", "cd", "in", "sn", "sb", "te", "i", "xe", "cs", "ba", "la", 
          "ce", "pr", "nd", "pm", "sm", "eu", "gd", "tb", "dy", "ho", "er", 
          "tm", "yb", "lu", "hf", "ta", "w", "re", "os", "ir", "pt", "au", 
          "hg", "tl", "pb", "bi", "po", "at", "rn", "fr", "ra", "ac", "th", 
          "pa", "u", "np", "pu", "am", "cm", "bk", "cf", "es", "fm", "md", 
          "no", "lr", "rf", "db", "sg", "bh", "hs", "mt", "ds", "rg", "cn", 
          "nh", "fl", "mc", "lv", "ts", "og", "uub", "uut", "uuq", "uup", 
          "uuh", "uus", "uuo"}}, Replace[#, 
         Dispatch[{
          "h" -> RGBColor[0.65, 0.7, 0.7], "he" -> RGBColor[0.836713, 1., 1.],
            "li" -> RGBColor[0.799435, 0.543572, 0.997559], "be" -> 
           RGBColor[0.770565, 0.964309, 0.0442359], "b" -> 
           RGBColor[1., 0.709804, 0.709804], "c" -> RGBColor[0.4, 0.4, 0.4], 
           "n" -> RGBColor[0.291989, 0.437977, 0.888609], "o" -> 
           RGBColor[0.800498, 0.201504, 0.192061], "f" -> 
           RGBColor[0.578462, 0.85539, 0.408855], "ne" -> 
           RGBColor[0.677263, 0.928423, 0.955287], "na" -> 
           RGBColor[0.658708, 0.492173, 0.842842], "mg" -> 
           RGBColor[0.628274, 0.850553, 0.0782731], "al" -> 
           RGBColor[0.8913, 0.631904, 0.627399], "si" -> 
           RGBColor[0.941176, 0.784314, 0.627451], "p" -> 
           RGBColor[1., 0.501961, 0], "s" -> 
           RGBColor[0.90443, 0.97015, 0.13504], "cl" -> 
           RGBColor[0.412698, 0.932689, 0.166398], "ar" -> 
           RGBColor[0.546138, 0.844244, 0.892092], "k" -> 
           RGBColor[0.534026, 0.420729, 0.705621], "ca" -> 
           RGBColor[0.480072, 0.744591, 0.0955222], "sc" -> 
           RGBColor[0.901961, 0.901961, 0.901961], "ti" -> 
           RGBColor[0.74902, 0.760784, 0.780392], "v" -> 
           RGBColor[0.65098, 0.65098, 0.670588], "cr" -> 
           RGBColor[0.541176, 0.6, 0.780392], "mn" -> 
           RGBColor[0.611765, 0.478431, 0.780392], "fe" -> 
           RGBColor[0.878431, 0.4, 0.2], "co" -> 
           RGBColor[0.941176, 0.564706, 0.627451], "ni" -> 
           RGBColor[0.313725, 0.815686, 0.313725], "cu" -> 
           RGBColor[0.784314, 0.501961, 0.2], "zn" -> 
           RGBColor[0.490196, 0.501961, 0.690196], "ga" -> 
           RGBColor[0.800757, 0.542666, 0.533513], "ge" -> 
           RGBColor[0.60508, 0.632465, 0.576489], "as" -> 
           RGBColor[0.741176, 0.501961, 0.890196], "se" -> 
           RGBColor[0.917248, 0.657833, 0.0706628], "br" -> 
           RGBColor[0.58847, 0.22163, 0.16064], "kr" -> 
           RGBColor[0.426019, 0.747462, 0.810413], "rb" -> 
           RGBColor[0.425391, 0.329242, 0.585895], "sr" -> 
           RGBColor[0.325959, 0.646423, 0.095983], "y" -> 
           RGBColor[0.531014, 1., 1.], "zr" -> 
           RGBColor[0.458599, 0.917466, 0.918573], "nb" -> 
           RGBColor[0.385036, 0.834854, 0.841681], "mo" -> 
           RGBColor[0.310325, 0.752163, 0.769323], "tc" -> 
           RGBColor[0.234466, 0.669394, 0.701499], "ru" -> 
           RGBColor[0.157459, 0.586546, 0.638209], "rh" -> 
           RGBColor[0.0793033, 0.50362, 0.579453], "pd" -> 
           RGBColor[0., 0.420615, 0.525231], "ag" -> 
           RGBColor[0.752941, 0.752941, 0.752941], "cd" -> 
           RGBColor[1., 0.85098, 0.560784], "in" -> 
           RGBColor[0.728371, 0.440594, 0.422196], "sn" -> 
           RGBColor[0.39799, 0.491477, 0.495586], "sb" -> 
           RGBColor[0.619608, 0.388235, 0.709804], "te" -> 
           RGBColor[0.816706, 0.451332, 0.0100947], "i" -> 
           RGBColor[0.580392, 0, 0.580392], "xe" -> 
           RGBColor[0.316906, 0.638078, 0.710252], "cs" -> 
           RGBColor[0.332803, 0.217712, 0.483666], "ba" -> 
           RGBColor[0.165935, 0.55605, 0.0796556], "la" -> 
           RGBColor[0.928084, 0.716075, 0.329427], "ce" -> 
           RGBColor[0.894824, 0.731424, 0.325131], "pr" -> 
           RGBColor[0.86523, 0.707999, 0.315261], "nd" -> 
           RGBColor[0.837836, 0.662974, 0.301635], "pm" -> 
           RGBColor[0.811992, 0.607859, 0.285626], "sm" -> 
           RGBColor[0.787563, 0.549894, 0.268279], "eu" -> 
           RGBColor[0.764628, 0.493261, 0.250405], "gd" -> 
           RGBColor[0.743177, 0.440115, 0.23269], "tb" -> 
           RGBColor[0.72281, 0.39143, 0.215783], "dy" -> 
           RGBColor[0.702434, 0.347663, 0.200392], "ho" -> 
           RGBColor[0.679962, 0.309234, 0.187368], "er" -> 
           RGBColor[0.652012, 0.276823, 0.17779], "tm" -> 
           RGBColor[0.613603, 0.251489, 0.173042], "yb" -> 
           RGBColor[0.557855, 0.234598, 0.17489], "lu" -> 
           RGBColor[0.475685, 0.227573, 0.18555], "hf" -> 
           RGBColor[0.781537, 0.717388, 0.716579], "ta" -> 
           RGBColor[0.734443, 0.544489, 0.683471], "w" -> 
           RGBColor[0.681179, 0.360409, 0.63675], "re" -> 
           RGBColor[0.605181, 0.367584, 0.556343], "os" -> 
           RGBColor[0.521806, 0.382125, 0.469204], "ir" -> 
           RGBColor[0.445624, 0.373159, 0.399069], "pt" -> 
           RGBColor[0.815686, 0.815686, 0.878431], "au" -> 
           RGBColor[1., 0.819608, 0.137255], "hg" -> 
           RGBColor[0.721569, 0.721569, 0.815686], "tl" -> 
           RGBColor[0.65098, 0.329412, 0.301961], "pb" -> 
           RGBColor[0.341176, 0.34902, 0.380392], "bi" -> 
           RGBColor[0.619608, 0.309804, 0.709804], "po" -> 
           RGBColor[0.670588, 0.360784, 0], "at" -> 
           RGBColor[0.458824, 0.309804, 0.270588], "rn" -> 
           RGBColor[0.218799, 0.516091, 0.591608], "fr" -> 
           RGBColor[0.25626, 0.0861372, 0.398932], "ra" -> 
           RGBColor[0., 0.473472, 0.04654], "ac" -> 
           RGBColor[0.322042, 0.71693, 0.988479], "th" -> 
           RGBColor[0.3608, 0.67166, 0.943003], "pa" -> 
           RGBColor[0.397469, 0.628, 0.898853], "u" -> 
           RGBColor[0.43205, 0.58595, 0.856029], "np" -> 
           RGBColor[0.464542, 0.54551, 0.814532], "pu" -> 
           RGBColor[0.494945, 0.506679, 0.774361], "am" -> 
           RGBColor[0.52326, 0.469458, 0.735517], "cm" -> 
           RGBColor[0.549486, 0.433847, 0.697999], "bk" -> 
           RGBColor[0.573624, 0.399845, 0.661808], "cf" -> 
           RGBColor[0.595673, 0.367454, 0.626942], "es" -> 
           RGBColor[0.615633, 0.336672, 0.593404], "fm" -> 
           RGBColor[0.633505, 0.307499, 0.561191], "md" -> 
           RGBColor[0.649288, 0.279937, 0.530305], "no" -> 
           RGBColor[0.662982, 0.253984, 0.500746], "lr" -> 
           RGBColor[0.674588, 0.22964, 0.472513], "rf" -> 
           RGBColor[0.684106, 0.206907, 0.445606], "db" -> 
           RGBColor[0.691534, 0.185783, 0.420025], "sg" -> 
           RGBColor[0.696874, 0.166269, 0.395772], "bh" -> 
           RGBColor[0.700126, 0.148365, 0.372844], "hs" -> 
           RGBColor[0.701289, 0.13207, 0.351243], "mt" -> 
           RGBColor[0.700363, 0.117385, 0.330968], "ds" -> 
           RGBColor[0.697348, 0.10431, 0.31202], "rg" -> 
           RGBColor[0.692245, 0.0928444, 0.294398], "cn" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "nh" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "fl" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "mc" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "lv" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "ts" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "og" -> 
           RGBColor[0.635401, 0.0528, 0.226184], "uub" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "uut" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "uuq" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "uup" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "uuh" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "uus" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "uuo" -> 
           RGBColor[0.635401, 0.0528, 0.226184]}]]& ][0.85], 
       ColorDataFunction[
       "Atoms", 
        "Named", {{
         "H", "He", "Li", "Be", "B", "C", "N", "O", "F", "Ne", "Na", "Mg", 
          "Al", "Si", "P", "S", "Cl", "Ar", "K", "Ca", "Sc", "Ti", "V", "Cr", 
          "Mn", "Fe", "Co", "Ni", "Cu", "Zn", "Ga", "Ge", "As", "Se", "Br", 
          "Kr", "Rb", "Sr", "Y", "Zr", "Nb", "Mo", "Tc", "Ru", "Rh", "Pd", 
          "Ag", "Cd", "In", "Sn", "Sb", "Te", "I", "Xe", "Cs", "Ba", "La", 
          "Ce", "Pr", "Nd", "Pm", "Sm", "Eu", "Gd", "Tb", "Dy", "Ho", "Er", 
          "Tm", "Yb", "Lu", "Hf", "Ta", "W", "Re", "Os", "Ir", "Pt", "Au", 
          "Hg", "Tl", "Pb", "Bi", "Po", "At", "Rn", "Fr", "Ra", "Ac", "Th", 
          "Pa", "U", "Np", "Pu", "Am", "Cm", "Bk", "Cf", "Es", "Fm", "Md", 
          "No", "Lr", "Rf", "Db", "Sg", "Bh", "Hs", "Mt", "Ds", "Rg", "Cn", 
          "Nh", "Fl", "Mc", "Lv", "Ts", "Og", "Uub", "Uut", "Uuq", "Uup", 
          "Uuh", "Uus", "Uuo"}, {
         "h", "he", "li", "be", "b", "c", "n", "o", "f", "ne", "na", "mg", 
          "al", "si", "p", "s", "cl", "ar", "k", "ca", "sc", "ti", "v", "cr", 
          "mn", "fe", "co", "ni", "cu", "zn", "ga", "ge", "as", "se", "br", 
          "kr", "rb", "sr", "y", "zr", "nb", "mo", "tc", "ru", "rh", "pd", 
          "ag", "cd", "in", "sn", "sb", "te", "i", "xe", "cs", "ba", "la", 
          "ce", "pr", "nd", "pm", "sm", "eu", "gd", "tb", "dy", "ho", "er", 
          "tm", "yb", "lu", "hf", "ta", "w", "re", "os", "ir", "pt", "au", 
          "hg", "tl", "pb", "bi", "po", "at", "rn", "fr", "ra", "ac", "th", 
          "pa", "u", "np", "pu", "am", "cm", "bk", "cf", "es", "fm", "md", 
          "no", "lr", "rf", "db", "sg", "bh", "hs", "mt", "ds", "rg", "cn", 
          "nh", "fl", "mc", "lv", "ts", "og", "uub", "uut", "uuq", "uup", 
          "uuh", "uus", "uuo"}}, Replace[#, 
         Dispatch[{
          "h" -> RGBColor[0.65, 0.7, 0.7], "he" -> RGBColor[0.836713, 1., 1.],
            "li" -> RGBColor[0.799435, 0.543572, 0.997559], "be" -> 
           RGBColor[0.770565, 0.964309, 0.0442359], "b" -> 
           RGBColor[1., 0.709804, 0.709804], "c" -> RGBColor[0.4, 0.4, 0.4], 
           "n" -> RGBColor[0.291989, 0.437977, 0.888609], "o" -> 
           RGBColor[0.800498, 0.201504, 0.192061], "f" -> 
           RGBColor[0.578462, 0.85539, 0.408855], "ne" -> 
           RGBColor[0.677263, 0.928423, 0.955287], "na" -> 
           RGBColor[0.658708, 0.492173, 0.842842], "mg" -> 
           RGBColor[0.628274, 0.850553, 0.0782731], "al" -> 
           RGBColor[0.8913, 0.631904, 0.627399], "si" -> 
           RGBColor[0.941176, 0.784314, 0.627451], "p" -> 
           RGBColor[1., 0.501961, 0], "s" -> 
           RGBColor[0.90443, 0.97015, 0.13504], "cl" -> 
           RGBColor[0.412698, 0.932689, 0.166398], "ar" -> 
           RGBColor[0.546138, 0.844244, 0.892092], "k" -> 
           RGBColor[0.534026, 0.420729, 0.705621], "ca" -> 
           RGBColor[0.480072, 0.744591, 0.0955222], "sc" -> 
           RGBColor[0.901961, 0.901961, 0.901961], "ti" -> 
           RGBColor[0.74902, 0.760784, 0.780392], "v" -> 
           RGBColor[0.65098, 0.65098, 0.670588], "cr" -> 
           RGBColor[0.541176, 0.6, 0.780392], "mn" -> 
           RGBColor[0.611765, 0.478431, 0.780392], "fe" -> 
           RGBColor[0.878431, 0.4, 0.2], "co" -> 
           RGBColor[0.941176, 0.564706, 0.627451], "ni" -> 
           RGBColor[0.313725, 0.815686, 0.313725], "cu" -> 
           RGBColor[0.784314, 0.501961, 0.2], "zn" -> 
           RGBColor[0.490196, 0.501961, 0.690196], "ga" -> 
           RGBColor[0.800757, 0.542666, 0.533513], "ge" -> 
           RGBColor[0.60508, 0.632465, 0.576489], "as" -> 
           RGBColor[0.741176, 0.501961, 0.890196], "se" -> 
           RGBColor[0.917248, 0.657833, 0.0706628], "br" -> 
           RGBColor[0.58847, 0.22163, 0.16064], "kr" -> 
           RGBColor[0.426019, 0.747462, 0.810413], "rb" -> 
           RGBColor[0.425391, 0.329242, 0.585895], "sr" -> 
           RGBColor[0.325959, 0.646423, 0.095983], "y" -> 
           RGBColor[0.531014, 1., 1.], "zr" -> 
           RGBColor[0.458599, 0.917466, 0.918573], "nb" -> 
           RGBColor[0.385036, 0.834854, 0.841681], "mo" -> 
           RGBColor[0.310325, 0.752163, 0.769323], "tc" -> 
           RGBColor[0.234466, 0.669394, 0.701499], "ru" -> 
           RGBColor[0.157459, 0.586546, 0.638209], "rh" -> 
           RGBColor[0.0793033, 0.50362, 0.579453], "pd" -> 
           RGBColor[0., 0.420615, 0.525231], "ag" -> 
           RGBColor[0.752941, 0.752941, 0.752941], "cd" -> 
           RGBColor[1., 0.85098, 0.560784], "in" -> 
           RGBColor[0.728371, 0.440594, 0.422196], "sn" -> 
           RGBColor[0.39799, 0.491477, 0.495586], "sb" -> 
           RGBColor[0.619608, 0.388235, 0.709804], "te" -> 
           RGBColor[0.816706, 0.451332, 0.0100947], "i" -> 
           RGBColor[0.580392, 0, 0.580392], "xe" -> 
           RGBColor[0.316906, 0.638078, 0.710252], "cs" -> 
           RGBColor[0.332803, 0.217712, 0.483666], "ba" -> 
           RGBColor[0.165935, 0.55605, 0.0796556], "la" -> 
           RGBColor[0.928084, 0.716075, 0.329427], "ce" -> 
           RGBColor[0.894824, 0.731424, 0.325131], "pr" -> 
           RGBColor[0.86523, 0.707999, 0.315261], "nd" -> 
           RGBColor[0.837836, 0.662974, 0.301635], "pm" -> 
           RGBColor[0.811992, 0.607859, 0.285626], "sm" -> 
           RGBColor[0.787563, 0.549894, 0.268279], "eu" -> 
           RGBColor[0.764628, 0.493261, 0.250405], "gd" -> 
           RGBColor[0.743177, 0.440115, 0.23269], "tb" -> 
           RGBColor[0.72281, 0.39143, 0.215783], "dy" -> 
           RGBColor[0.702434, 0.347663, 0.200392], "ho" -> 
           RGBColor[0.679962, 0.309234, 0.187368], "er" -> 
           RGBColor[0.652012, 0.276823, 0.17779], "tm" -> 
           RGBColor[0.613603, 0.251489, 0.173042], "yb" -> 
           RGBColor[0.557855, 0.234598, 0.17489], "lu" -> 
           RGBColor[0.475685, 0.227573, 0.18555], "hf" -> 
           RGBColor[0.781537, 0.717388, 0.716579], "ta" -> 
           RGBColor[0.734443, 0.544489, 0.683471], "w" -> 
           RGBColor[0.681179, 0.360409, 0.63675], "re" -> 
           RGBColor[0.605181, 0.367584, 0.556343], "os" -> 
           RGBColor[0.521806, 0.382125, 0.469204], "ir" -> 
           RGBColor[0.445624, 0.373159, 0.399069], "pt" -> 
           RGBColor[0.815686, 0.815686, 0.878431], "au" -> 
           RGBColor[1., 0.819608, 0.137255], "hg" -> 
           RGBColor[0.721569, 0.721569, 0.815686], "tl" -> 
           RGBColor[0.65098, 0.329412, 0.301961], "pb" -> 
           RGBColor[0.341176, 0.34902, 0.380392], "bi" -> 
           RGBColor[0.619608, 0.309804, 0.709804], "po" -> 
           RGBColor[0.670588, 0.360784, 0], "at" -> 
           RGBColor[0.458824, 0.309804, 0.270588], "rn" -> 
           RGBColor[0.218799, 0.516091, 0.591608], "fr" -> 
           RGBColor[0.25626, 0.0861372, 0.398932], "ra" -> 
           RGBColor[0., 0.473472, 0.04654], "ac" -> 
           RGBColor[0.322042, 0.71693, 0.988479], "th" -> 
           RGBColor[0.3608, 0.67166, 0.943003], "pa" -> 
           RGBColor[0.397469, 0.628, 0.898853], "u" -> 
           RGBColor[0.43205, 0.58595, 0.856029], "np" -> 
           RGBColor[0.464542, 0.54551, 0.814532], "pu" -> 
           RGBColor[0.494945, 0.506679, 0.774361], "am" -> 
           RGBColor[0.52326, 0.469458, 0.735517], "cm" -> 
           RGBColor[0.549486, 0.433847, 0.697999], "bk" -> 
           RGBColor[0.573624, 0.399845, 0.661808], "cf" -> 
           RGBColor[0.595673, 0.367454, 0.626942], "es" -> 
           RGBColor[0.615633, 0.336672, 0.593404], "fm" -> 
           RGBColor[0.633505, 0.307499, 0.561191], "md" -> 
           RGBColor[0.649288, 0.279937, 0.530305], "no" -> 
           RGBColor[0.662982, 0.253984, 0.500746], "lr" -> 
           RGBColor[0.674588, 0.22964, 0.472513], "rf" -> 
           RGBColor[0.684106, 0.206907, 0.445606], "db" -> 
           RGBColor[0.691534, 0.185783, 0.420025], "sg" -> 
           RGBColor[0.696874, 0.166269, 0.395772], "bh" -> 
           RGBColor[0.700126, 0.148365, 0.372844], "hs" -> 
           RGBColor[0.701289, 0.13207, 0.351243], "mt" -> 
           RGBColor[0.700363, 0.117385, 0.330968], "ds" -> 
           RGBColor[0.697348, 0.10431, 0.31202], "rg" -> 
           RGBColor[0.692245, 0.0928444, 0.294398], "cn" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "nh" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "fl" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "mc" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "lv" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "ts" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "og" -> 
           RGBColor[0.635401, 0.0528, 0.226184], "uub" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "uut" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "uuq" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "uup" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "uuh" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "uus" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "uuo" -> 
           RGBColor[0.635401, 0.0528, 0.226184]}]]& ][0.85], 
       ColorDataFunction[
       "Atoms", 
        "Named", {{
         "H", "He", "Li", "Be", "B", "C", "N", "O", "F", "Ne", "Na", "Mg", 
          "Al", "Si", "P", "S", "Cl", "Ar", "K", "Ca", "Sc", "Ti", "V", "Cr", 
          "Mn", "Fe", "Co", "Ni", "Cu", "Zn", "Ga", "Ge", "As", "Se", "Br", 
          "Kr", "Rb", "Sr", "Y", "Zr", "Nb", "Mo", "Tc", "Ru", "Rh", "Pd", 
          "Ag", "Cd", "In", "Sn", "Sb", "Te", "I", "Xe", "Cs", "Ba", "La", 
          "Ce", "Pr", "Nd", "Pm", "Sm", "Eu", "Gd", "Tb", "Dy", "Ho", "Er", 
          "Tm", "Yb", "Lu", "Hf", "Ta", "W", "Re", "Os", "Ir", "Pt", "Au", 
          "Hg", "Tl", "Pb", "Bi", "Po", "At", "Rn", "Fr", "Ra", "Ac", "Th", 
          "Pa", "U", "Np", "Pu", "Am", "Cm", "Bk", "Cf", "Es", "Fm", "Md", 
          "No", "Lr", "Rf", "Db", "Sg", "Bh", "Hs", "Mt", "Ds", "Rg", "Cn", 
          "Nh", "Fl", "Mc", "Lv", "Ts", "Og", "Uub", "Uut", "Uuq", "Uup", 
          "Uuh", "Uus", "Uuo"}, {
         "h", "he", "li", "be", "b", "c", "n", "o", "f", "ne", "na", "mg", 
          "al", "si", "p", "s", "cl", "ar", "k", "ca", "sc", "ti", "v", "cr", 
          "mn", "fe", "co", "ni", "cu", "zn", "ga", "ge", "as", "se", "br", 
          "kr", "rb", "sr", "y", "zr", "nb", "mo", "tc", "ru", "rh", "pd", 
          "ag", "cd", "in", "sn", "sb", "te", "i", "xe", "cs", "ba", "la", 
          "ce", "pr", "nd", "pm", "sm", "eu", "gd", "tb", "dy", "ho", "er", 
          "tm", "yb", "lu", "hf", "ta", "w", "re", "os", "ir", "pt", "au", 
          "hg", "tl", "pb", "bi", "po", "at", "rn", "fr", "ra", "ac", "th", 
          "pa", "u", "np", "pu", "am", "cm", "bk", "cf", "es", "fm", "md", 
          "no", "lr", "rf", "db", "sg", "bh", "hs", "mt", "ds", "rg", "cn", 
          "nh", "fl", "mc", "lv", "ts", "og", "uub", "uut", "uuq", "uup", 
          "uuh", "uus", "uuo"}}, Replace[#, 
         Dispatch[{
          "h" -> RGBColor[0.65, 0.7, 0.7], "he" -> RGBColor[0.836713, 1., 1.],
            "li" -> RGBColor[0.799435, 0.543572, 0.997559], "be" -> 
           RGBColor[0.770565, 0.964309, 0.0442359], "b" -> 
           RGBColor[1., 0.709804, 0.709804], "c" -> RGBColor[0.4, 0.4, 0.4], 
           "n" -> RGBColor[0.291989, 0.437977, 0.888609], "o" -> 
           RGBColor[0.800498, 0.201504, 0.192061], "f" -> 
           RGBColor[0.578462, 0.85539, 0.408855], "ne" -> 
           RGBColor[0.677263, 0.928423, 0.955287], "na" -> 
           RGBColor[0.658708, 0.492173, 0.842842], "mg" -> 
           RGBColor[0.628274, 0.850553, 0.0782731], "al" -> 
           RGBColor[0.8913, 0.631904, 0.627399], "si" -> 
           RGBColor[0.941176, 0.784314, 0.627451], "p" -> 
           RGBColor[1., 0.501961, 0], "s" -> 
           RGBColor[0.90443, 0.97015, 0.13504], "cl" -> 
           RGBColor[0.412698, 0.932689, 0.166398], "ar" -> 
           RGBColor[0.546138, 0.844244, 0.892092], "k" -> 
           RGBColor[0.534026, 0.420729, 0.705621], "ca" -> 
           RGBColor[0.480072, 0.744591, 0.0955222], "sc" -> 
           RGBColor[0.901961, 0.901961, 0.901961], "ti" -> 
           RGBColor[0.74902, 0.760784, 0.780392], "v" -> 
           RGBColor[0.65098, 0.65098, 0.670588], "cr" -> 
           RGBColor[0.541176, 0.6, 0.780392], "mn" -> 
           RGBColor[0.611765, 0.478431, 0.780392], "fe" -> 
           RGBColor[0.878431, 0.4, 0.2], "co" -> 
           RGBColor[0.941176, 0.564706, 0.627451], "ni" -> 
           RGBColor[0.313725, 0.815686, 0.313725], "cu" -> 
           RGBColor[0.784314, 0.501961, 0.2], "zn" -> 
           RGBColor[0.490196, 0.501961, 0.690196], "ga" -> 
           RGBColor[0.800757, 0.542666, 0.533513], "ge" -> 
           RGBColor[0.60508, 0.632465, 0.576489], "as" -> 
           RGBColor[0.741176, 0.501961, 0.890196], "se" -> 
           RGBColor[0.917248, 0.657833, 0.0706628], "br" -> 
           RGBColor[0.58847, 0.22163, 0.16064], "kr" -> 
           RGBColor[0.426019, 0.747462, 0.810413], "rb" -> 
           RGBColor[0.425391, 0.329242, 0.585895], "sr" -> 
           RGBColor[0.325959, 0.646423, 0.095983], "y" -> 
           RGBColor[0.531014, 1., 1.], "zr" -> 
           RGBColor[0.458599, 0.917466, 0.918573], "nb" -> 
           RGBColor[0.385036, 0.834854, 0.841681], "mo" -> 
           RGBColor[0.310325, 0.752163, 0.769323], "tc" -> 
           RGBColor[0.234466, 0.669394, 0.701499], "ru" -> 
           RGBColor[0.157459, 0.586546, 0.638209], "rh" -> 
           RGBColor[0.0793033, 0.50362, 0.579453], "pd" -> 
           RGBColor[0., 0.420615, 0.525231], "ag" -> 
           RGBColor[0.752941, 0.752941, 0.752941], "cd" -> 
           RGBColor[1., 0.85098, 0.560784], "in" -> 
           RGBColor[0.728371, 0.440594, 0.422196], "sn" -> 
           RGBColor[0.39799, 0.491477, 0.495586], "sb" -> 
           RGBColor[0.619608, 0.388235, 0.709804], "te" -> 
           RGBColor[0.816706, 0.451332, 0.0100947], "i" -> 
           RGBColor[0.580392, 0, 0.580392], "xe" -> 
           RGBColor[0.316906, 0.638078, 0.710252], "cs" -> 
           RGBColor[0.332803, 0.217712, 0.483666], "ba" -> 
           RGBColor[0.165935, 0.55605, 0.0796556], "la" -> 
           RGBColor[0.928084, 0.716075, 0.329427], "ce" -> 
           RGBColor[0.894824, 0.731424, 0.325131], "pr" -> 
           RGBColor[0.86523, 0.707999, 0.315261], "nd" -> 
           RGBColor[0.837836, 0.662974, 0.301635], "pm" -> 
           RGBColor[0.811992, 0.607859, 0.285626], "sm" -> 
           RGBColor[0.787563, 0.549894, 0.268279], "eu" -> 
           RGBColor[0.764628, 0.493261, 0.250405], "gd" -> 
           RGBColor[0.743177, 0.440115, 0.23269], "tb" -> 
           RGBColor[0.72281, 0.39143, 0.215783], "dy" -> 
           RGBColor[0.702434, 0.347663, 0.200392], "ho" -> 
           RGBColor[0.679962, 0.309234, 0.187368], "er" -> 
           RGBColor[0.652012, 0.276823, 0.17779], "tm" -> 
           RGBColor[0.613603, 0.251489, 0.173042], "yb" -> 
           RGBColor[0.557855, 0.234598, 0.17489], "lu" -> 
           RGBColor[0.475685, 0.227573, 0.18555], "hf" -> 
           RGBColor[0.781537, 0.717388, 0.716579], "ta" -> 
           RGBColor[0.734443, 0.544489, 0.683471], "w" -> 
           RGBColor[0.681179, 0.360409, 0.63675], "re" -> 
           RGBColor[0.605181, 0.367584, 0.556343], "os" -> 
           RGBColor[0.521806, 0.382125, 0.469204], "ir" -> 
           RGBColor[0.445624, 0.373159, 0.399069], "pt" -> 
           RGBColor[0.815686, 0.815686, 0.878431], "au" -> 
           RGBColor[1., 0.819608, 0.137255], "hg" -> 
           RGBColor[0.721569, 0.721569, 0.815686], "tl" -> 
           RGBColor[0.65098, 0.329412, 0.301961], "pb" -> 
           RGBColor[0.341176, 0.34902, 0.380392], "bi" -> 
           RGBColor[0.619608, 0.309804, 0.709804], "po" -> 
           RGBColor[0.670588, 0.360784, 0], "at" -> 
           RGBColor[0.458824, 0.309804, 0.270588], "rn" -> 
           RGBColor[0.218799, 0.516091, 0.591608], "fr" -> 
           RGBColor[0.25626, 0.0861372, 0.398932], "ra" -> 
           RGBColor[0., 0.473472, 0.04654], "ac" -> 
           RGBColor[0.322042, 0.71693, 0.988479], "th" -> 
           RGBColor[0.3608, 0.67166, 0.943003], "pa" -> 
           RGBColor[0.397469, 0.628, 0.898853], "u" -> 
           RGBColor[0.43205, 0.58595, 0.856029], "np" -> 
           RGBColor[0.464542, 0.54551, 0.814532], "pu" -> 
           RGBColor[0.494945, 0.506679, 0.774361], "am" -> 
           RGBColor[0.52326, 0.469458, 0.735517], "cm" -> 
           RGBColor[0.549486, 0.433847, 0.697999], "bk" -> 
           RGBColor[0.573624, 0.399845, 0.661808], "cf" -> 
           RGBColor[0.595673, 0.367454, 0.626942], "es" -> 
           RGBColor[0.615633, 0.336672, 0.593404], "fm" -> 
           RGBColor[0.633505, 0.307499, 0.561191], "md" -> 
           RGBColor[0.649288, 0.279937, 0.530305], "no" -> 
           RGBColor[0.662982, 0.253984, 0.500746], "lr" -> 
           RGBColor[0.674588, 0.22964, 0.472513], "rf" -> 
           RGBColor[0.684106, 0.206907, 0.445606], "db" -> 
           RGBColor[0.691534, 0.185783, 0.420025], "sg" -> 
           RGBColor[0.696874, 0.166269, 0.395772], "bh" -> 
           RGBColor[0.700126, 0.148365, 0.372844], "hs" -> 
           RGBColor[0.701289, 0.13207, 0.351243], "mt" -> 
           RGBColor[0.700363, 0.117385, 0.330968], "ds" -> 
           RGBColor[0.697348, 0.10431, 0.31202], "rg" -> 
           RGBColor[0.692245, 0.0928444, 0.294398], "cn" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "nh" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "fl" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "mc" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "lv" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "ts" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "og" -> 
           RGBColor[0.635401, 0.0528, 0.226184], "uub" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "uut" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "uuq" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "uup" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "uuh" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "uus" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "uuo" -> 
           RGBColor[0.635401, 0.0528, 0.226184]}]]& ][0.85], 
       ColorDataFunction[
       "Atoms", 
        "Named", {{
         "H", "He", "Li", "Be", "B", "C", "N", "O", "F", "Ne", "Na", "Mg", 
          "Al", "Si", "P", "S", "Cl", "Ar", "K", "Ca", "Sc", "Ti", "V", "Cr", 
          "Mn", "Fe", "Co", "Ni", "Cu", "Zn", "Ga", "Ge", "As", "Se", "Br", 
          "Kr", "Rb", "Sr", "Y", "Zr", "Nb", "Mo", "Tc", "Ru", "Rh", "Pd", 
          "Ag", "Cd", "In", "Sn", "Sb", "Te", "I", "Xe", "Cs", "Ba", "La", 
          "Ce", "Pr", "Nd", "Pm", "Sm", "Eu", "Gd", "Tb", "Dy", "Ho", "Er", 
          "Tm", "Yb", "Lu", "Hf", "Ta", "W", "Re", "Os", "Ir", "Pt", "Au", 
          "Hg", "Tl", "Pb", "Bi", "Po", "At", "Rn", "Fr", "Ra", "Ac", "Th", 
          "Pa", "U", "Np", "Pu", "Am", "Cm", "Bk", "Cf", "Es", "Fm", "Md", 
          "No", "Lr", "Rf", "Db", "Sg", "Bh", "Hs", "Mt", "Ds", "Rg", "Cn", 
          "Nh", "Fl", "Mc", "Lv", "Ts", "Og", "Uub", "Uut", "Uuq", "Uup", 
          "Uuh", "Uus", "Uuo"}, {
         "h", "he", "li", "be", "b", "c", "n", "o", "f", "ne", "na", "mg", 
          "al", "si", "p", "s", "cl", "ar", "k", "ca", "sc", "ti", "v", "cr", 
          "mn", "fe", "co", "ni", "cu", "zn", "ga", "ge", "as", "se", "br", 
          "kr", "rb", "sr", "y", "zr", "nb", "mo", "tc", "ru", "rh", "pd", 
          "ag", "cd", "in", "sn", "sb", "te", "i", "xe", "cs", "ba", "la", 
          "ce", "pr", "nd", "pm", "sm", "eu", "gd", "tb", "dy", "ho", "er", 
          "tm", "yb", "lu", "hf", "ta", "w", "re", "os", "ir", "pt", "au", 
          "hg", "tl", "pb", "bi", "po", "at", "rn", "fr", "ra", "ac", "th", 
          "pa", "u", "np", "pu", "am", "cm", "bk", "cf", "es", "fm", "md", 
          "no", "lr", "rf", "db", "sg", "bh", "hs", "mt", "ds", "rg", "cn", 
          "nh", "fl", "mc", "lv", "ts", "og", "uub", "uut", "uuq", "uup", 
          "uuh", "uus", "uuo"}}, Replace[#, 
         Dispatch[{
          "h" -> RGBColor[0.65, 0.7, 0.7], "he" -> RGBColor[0.836713, 1., 1.],
            "li" -> RGBColor[0.799435, 0.543572, 0.997559], "be" -> 
           RGBColor[0.770565, 0.964309, 0.0442359], "b" -> 
           RGBColor[1., 0.709804, 0.709804], "c" -> RGBColor[0.4, 0.4, 0.4], 
           "n" -> RGBColor[0.291989, 0.437977, 0.888609], "o" -> 
           RGBColor[0.800498, 0.201504, 0.192061], "f" -> 
           RGBColor[0.578462, 0.85539, 0.408855], "ne" -> 
           RGBColor[0.677263, 0.928423, 0.955287], "na" -> 
           RGBColor[0.658708, 0.492173, 0.842842], "mg" -> 
           RGBColor[0.628274, 0.850553, 0.0782731], "al" -> 
           RGBColor[0.8913, 0.631904, 0.627399], "si" -> 
           RGBColor[0.941176, 0.784314, 0.627451], "p" -> 
           RGBColor[1., 0.501961, 0], "s" -> 
           RGBColor[0.90443, 0.97015, 0.13504], "cl" -> 
           RGBColor[0.412698, 0.932689, 0.166398], "ar" -> 
           RGBColor[0.546138, 0.844244, 0.892092], "k" -> 
           RGBColor[0.534026, 0.420729, 0.705621], "ca" -> 
           RGBColor[0.480072, 0.744591, 0.0955222], "sc" -> 
           RGBColor[0.901961, 0.901961, 0.901961], "ti" -> 
           RGBColor[0.74902, 0.760784, 0.780392], "v" -> 
           RGBColor[0.65098, 0.65098, 0.670588], "cr" -> 
           RGBColor[0.541176, 0.6, 0.780392], "mn" -> 
           RGBColor[0.611765, 0.478431, 0.780392], "fe" -> 
           RGBColor[0.878431, 0.4, 0.2], "co" -> 
           RGBColor[0.941176, 0.564706, 0.627451], "ni" -> 
           RGBColor[0.313725, 0.815686, 0.313725], "cu" -> 
           RGBColor[0.784314, 0.501961, 0.2], "zn" -> 
           RGBColor[0.490196, 0.501961, 0.690196], "ga" -> 
           RGBColor[0.800757, 0.542666, 0.533513], "ge" -> 
           RGBColor[0.60508, 0.632465, 0.576489], "as" -> 
           RGBColor[0.741176, 0.501961, 0.890196], "se" -> 
           RGBColor[0.917248, 0.657833, 0.0706628], "br" -> 
           RGBColor[0.58847, 0.22163, 0.16064], "kr" -> 
           RGBColor[0.426019, 0.747462, 0.810413], "rb" -> 
           RGBColor[0.425391, 0.329242, 0.585895], "sr" -> 
           RGBColor[0.325959, 0.646423, 0.095983], "y" -> 
           RGBColor[0.531014, 1., 1.], "zr" -> 
           RGBColor[0.458599, 0.917466, 0.918573], "nb" -> 
           RGBColor[0.385036, 0.834854, 0.841681], "mo" -> 
           RGBColor[0.310325, 0.752163, 0.769323], "tc" -> 
           RGBColor[0.234466, 0.669394, 0.701499], "ru" -> 
           RGBColor[0.157459, 0.586546, 0.638209], "rh" -> 
           RGBColor[0.0793033, 0.50362, 0.579453], "pd" -> 
           RGBColor[0., 0.420615, 0.525231], "ag" -> 
           RGBColor[0.752941, 0.752941, 0.752941], "cd" -> 
           RGBColor[1., 0.85098, 0.560784], "in" -> 
           RGBColor[0.728371, 0.440594, 0.422196], "sn" -> 
           RGBColor[0.39799, 0.491477, 0.495586], "sb" -> 
           RGBColor[0.619608, 0.388235, 0.709804], "te" -> 
           RGBColor[0.816706, 0.451332, 0.0100947], "i" -> 
           RGBColor[0.580392, 0, 0.580392], "xe" -> 
           RGBColor[0.316906, 0.638078, 0.710252], "cs" -> 
           RGBColor[0.332803, 0.217712, 0.483666], "ba" -> 
           RGBColor[0.165935, 0.55605, 0.0796556], "la" -> 
           RGBColor[0.928084, 0.716075, 0.329427], "ce" -> 
           RGBColor[0.894824, 0.731424, 0.325131], "pr" -> 
           RGBColor[0.86523, 0.707999, 0.315261], "nd" -> 
           RGBColor[0.837836, 0.662974, 0.301635], "pm" -> 
           RGBColor[0.811992, 0.607859, 0.285626], "sm" -> 
           RGBColor[0.787563, 0.549894, 0.268279], "eu" -> 
           RGBColor[0.764628, 0.493261, 0.250405], "gd" -> 
           RGBColor[0.743177, 0.440115, 0.23269], "tb" -> 
           RGBColor[0.72281, 0.39143, 0.215783], "dy" -> 
           RGBColor[0.702434, 0.347663, 0.200392], "ho" -> 
           RGBColor[0.679962, 0.309234, 0.187368], "er" -> 
           RGBColor[0.652012, 0.276823, 0.17779], "tm" -> 
           RGBColor[0.613603, 0.251489, 0.173042], "yb" -> 
           RGBColor[0.557855, 0.234598, 0.17489], "lu" -> 
           RGBColor[0.475685, 0.227573, 0.18555], "hf" -> 
           RGBColor[0.781537, 0.717388, 0.716579], "ta" -> 
           RGBColor[0.734443, 0.544489, 0.683471], "w" -> 
           RGBColor[0.681179, 0.360409, 0.63675], "re" -> 
           RGBColor[0.605181, 0.367584, 0.556343], "os" -> 
           RGBColor[0.521806, 0.382125, 0.469204], "ir" -> 
           RGBColor[0.445624, 0.373159, 0.399069], "pt" -> 
           RGBColor[0.815686, 0.815686, 0.878431], "au" -> 
           RGBColor[1., 0.819608, 0.137255], "hg" -> 
           RGBColor[0.721569, 0.721569, 0.815686], "tl" -> 
           RGBColor[0.65098, 0.329412, 0.301961], "pb" -> 
           RGBColor[0.341176, 0.34902, 0.380392], "bi" -> 
           RGBColor[0.619608, 0.309804, 0.709804], "po" -> 
           RGBColor[0.670588, 0.360784, 0], "at" -> 
           RGBColor[0.458824, 0.309804, 0.270588], "rn" -> 
           RGBColor[0.218799, 0.516091, 0.591608], "fr" -> 
           RGBColor[0.25626, 0.0861372, 0.398932], "ra" -> 
           RGBColor[0., 0.473472, 0.04654], "ac" -> 
           RGBColor[0.322042, 0.71693, 0.988479], "th" -> 
           RGBColor[0.3608, 0.67166, 0.943003], "pa" -> 
           RGBColor[0.397469, 0.628, 0.898853], "u" -> 
           RGBColor[0.43205, 0.58595, 0.856029], "np" -> 
           RGBColor[0.464542, 0.54551, 0.814532], "pu" -> 
           RGBColor[0.494945, 0.506679, 0.774361], "am" -> 
           RGBColor[0.52326, 0.469458, 0.735517], "cm" -> 
           RGBColor[0.549486, 0.433847, 0.697999], "bk" -> 
           RGBColor[0.573624, 0.399845, 0.661808], "cf" -> 
           RGBColor[0.595673, 0.367454, 0.626942], "es" -> 
           RGBColor[0.615633, 0.336672, 0.593404], "fm" -> 
           RGBColor[0.633505, 0.307499, 0.561191], "md" -> 
           RGBColor[0.649288, 0.279937, 0.530305], "no" -> 
           RGBColor[0.662982, 0.253984, 0.500746], "lr" -> 
           RGBColor[0.674588, 0.22964, 0.472513], "rf" -> 
           RGBColor[0.684106, 0.206907, 0.445606], "db" -> 
           RGBColor[0.691534, 0.185783, 0.420025], "sg" -> 
           RGBColor[0.696874, 0.166269, 0.395772], "bh" -> 
           RGBColor[0.700126, 0.148365, 0.372844], "hs" -> 
           RGBColor[0.701289, 0.13207, 0.351243], "mt" -> 
           RGBColor[0.700363, 0.117385, 0.330968], "ds" -> 
           RGBColor[0.697348, 0.10431, 0.31202], "rg" -> 
           RGBColor[0.692245, 0.0928444, 0.294398], "cn" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "nh" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "fl" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "mc" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "lv" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "ts" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "og" -> 
           RGBColor[0.635401, 0.0528, 0.226184], "uub" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "uut" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "uuq" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "uup" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "uuh" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "uus" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "uuo" -> 
           RGBColor[0.635401, 0.0528, 0.226184]}]]& ][0.85], 
       ColorDataFunction[
       "Atoms", 
        "Named", {{
         "H", "He", "Li", "Be", "B", "C", "N", "O", "F", "Ne", "Na", "Mg", 
          "Al", "Si", "P", "S", "Cl", "Ar", "K", "Ca", "Sc", "Ti", "V", "Cr", 
          "Mn", "Fe", "Co", "Ni", "Cu", "Zn", "Ga", "Ge", "As", "Se", "Br", 
          "Kr", "Rb", "Sr", "Y", "Zr", "Nb", "Mo", "Tc", "Ru", "Rh", "Pd", 
          "Ag", "Cd", "In", "Sn", "Sb", "Te", "I", "Xe", "Cs", "Ba", "La", 
          "Ce", "Pr", "Nd", "Pm", "Sm", "Eu", "Gd", "Tb", "Dy", "Ho", "Er", 
          "Tm", "Yb", "Lu", "Hf", "Ta", "W", "Re", "Os", "Ir", "Pt", "Au", 
          "Hg", "Tl", "Pb", "Bi", "Po", "At", "Rn", "Fr", "Ra", "Ac", "Th", 
          "Pa", "U", "Np", "Pu", "Am", "Cm", "Bk", "Cf", "Es", "Fm", "Md", 
          "No", "Lr", "Rf", "Db", "Sg", "Bh", "Hs", "Mt", "Ds", "Rg", "Cn", 
          "Nh", "Fl", "Mc", "Lv", "Ts", "Og", "Uub", "Uut", "Uuq", "Uup", 
          "Uuh", "Uus", "Uuo"}, {
         "h", "he", "li", "be", "b", "c", "n", "o", "f", "ne", "na", "mg", 
          "al", "si", "p", "s", "cl", "ar", "k", "ca", "sc", "ti", "v", "cr", 
          "mn", "fe", "co", "ni", "cu", "zn", "ga", "ge", "as", "se", "br", 
          "kr", "rb", "sr", "y", "zr", "nb", "mo", "tc", "ru", "rh", "pd", 
          "ag", "cd", "in", "sn", "sb", "te", "i", "xe", "cs", "ba", "la", 
          "ce", "pr", "nd", "pm", "sm", "eu", "gd", "tb", "dy", "ho", "er", 
          "tm", "yb", "lu", "hf", "ta", "w", "re", "os", "ir", "pt", "au", 
          "hg", "tl", "pb", "bi", "po", "at", "rn", "fr", "ra", "ac", "th", 
          "pa", "u", "np", "pu", "am", "cm", "bk", "cf", "es", "fm", "md", 
          "no", "lr", "rf", "db", "sg", "bh", "hs", "mt", "ds", "rg", "cn", 
          "nh", "fl", "mc", "lv", "ts", "og", "uub", "uut", "uuq", "uup", 
          "uuh", "uus", "uuo"}}, Replace[#, 
         Dispatch[{
          "h" -> RGBColor[0.65, 0.7, 0.7], "he" -> RGBColor[0.836713, 1., 1.],
            "li" -> RGBColor[0.799435, 0.543572, 0.997559], "be" -> 
           RGBColor[0.770565, 0.964309, 0.0442359], "b" -> 
           RGBColor[1., 0.709804, 0.709804], "c" -> RGBColor[0.4, 0.4, 0.4], 
           "n" -> RGBColor[0.291989, 0.437977, 0.888609], "o" -> 
           RGBColor[0.800498, 0.201504, 0.192061], "f" -> 
           RGBColor[0.578462, 0.85539, 0.408855], "ne" -> 
           RGBColor[0.677263, 0.928423, 0.955287], "na" -> 
           RGBColor[0.658708, 0.492173, 0.842842], "mg" -> 
           RGBColor[0.628274, 0.850553, 0.0782731], "al" -> 
           RGBColor[0.8913, 0.631904, 0.627399], "si" -> 
           RGBColor[0.941176, 0.784314, 0.627451], "p" -> 
           RGBColor[1., 0.501961, 0], "s" -> 
           RGBColor[0.90443, 0.97015, 0.13504], "cl" -> 
           RGBColor[0.412698, 0.932689, 0.166398], "ar" -> 
           RGBColor[0.546138, 0.844244, 0.892092], "k" -> 
           RGBColor[0.534026, 0.420729, 0.705621], "ca" -> 
           RGBColor[0.480072, 0.744591, 0.0955222], "sc" -> 
           RGBColor[0.901961, 0.901961, 0.901961], "ti" -> 
           RGBColor[0.74902, 0.760784, 0.780392], "v" -> 
           RGBColor[0.65098, 0.65098, 0.670588], "cr" -> 
           RGBColor[0.541176, 0.6, 0.780392], "mn" -> 
           RGBColor[0.611765, 0.478431, 0.780392], "fe" -> 
           RGBColor[0.878431, 0.4, 0.2], "co" -> 
           RGBColor[0.941176, 0.564706, 0.627451], "ni" -> 
           RGBColor[0.313725, 0.815686, 0.313725], "cu" -> 
           RGBColor[0.784314, 0.501961, 0.2], "zn" -> 
           RGBColor[0.490196, 0.501961, 0.690196], "ga" -> 
           RGBColor[0.800757, 0.542666, 0.533513], "ge" -> 
           RGBColor[0.60508, 0.632465, 0.576489], "as" -> 
           RGBColor[0.741176, 0.501961, 0.890196], "se" -> 
           RGBColor[0.917248, 0.657833, 0.0706628], "br" -> 
           RGBColor[0.58847, 0.22163, 0.16064], "kr" -> 
           RGBColor[0.426019, 0.747462, 0.810413], "rb" -> 
           RGBColor[0.425391, 0.329242, 0.585895], "sr" -> 
           RGBColor[0.325959, 0.646423, 0.095983], "y" -> 
           RGBColor[0.531014, 1., 1.], "zr" -> 
           RGBColor[0.458599, 0.917466, 0.918573], "nb" -> 
           RGBColor[0.385036, 0.834854, 0.841681], "mo" -> 
           RGBColor[0.310325, 0.752163, 0.769323], "tc" -> 
           RGBColor[0.234466, 0.669394, 0.701499], "ru" -> 
           RGBColor[0.157459, 0.586546, 0.638209], "rh" -> 
           RGBColor[0.0793033, 0.50362, 0.579453], "pd" -> 
           RGBColor[0., 0.420615, 0.525231], "ag" -> 
           RGBColor[0.752941, 0.752941, 0.752941], "cd" -> 
           RGBColor[1., 0.85098, 0.560784], "in" -> 
           RGBColor[0.728371, 0.440594, 0.422196], "sn" -> 
           RGBColor[0.39799, 0.491477, 0.495586], "sb" -> 
           RGBColor[0.619608, 0.388235, 0.709804], "te" -> 
           RGBColor[0.816706, 0.451332, 0.0100947], "i" -> 
           RGBColor[0.580392, 0, 0.580392], "xe" -> 
           RGBColor[0.316906, 0.638078, 0.710252], "cs" -> 
           RGBColor[0.332803, 0.217712, 0.483666], "ba" -> 
           RGBColor[0.165935, 0.55605, 0.0796556], "la" -> 
           RGBColor[0.928084, 0.716075, 0.329427], "ce" -> 
           RGBColor[0.894824, 0.731424, 0.325131], "pr" -> 
           RGBColor[0.86523, 0.707999, 0.315261], "nd" -> 
           RGBColor[0.837836, 0.662974, 0.301635], "pm" -> 
           RGBColor[0.811992, 0.607859, 0.285626], "sm" -> 
           RGBColor[0.787563, 0.549894, 0.268279], "eu" -> 
           RGBColor[0.764628, 0.493261, 0.250405], "gd" -> 
           RGBColor[0.743177, 0.440115, 0.23269], "tb" -> 
           RGBColor[0.72281, 0.39143, 0.215783], "dy" -> 
           RGBColor[0.702434, 0.347663, 0.200392], "ho" -> 
           RGBColor[0.679962, 0.309234, 0.187368], "er" -> 
           RGBColor[0.652012, 0.276823, 0.17779], "tm" -> 
           RGBColor[0.613603, 0.251489, 0.173042], "yb" -> 
           RGBColor[0.557855, 0.234598, 0.17489], "lu" -> 
           RGBColor[0.475685, 0.227573, 0.18555], "hf" -> 
           RGBColor[0.781537, 0.717388, 0.716579], "ta" -> 
           RGBColor[0.734443, 0.544489, 0.683471], "w" -> 
           RGBColor[0.681179, 0.360409, 0.63675], "re" -> 
           RGBColor[0.605181, 0.367584, 0.556343], "os" -> 
           RGBColor[0.521806, 0.382125, 0.469204], "ir" -> 
           RGBColor[0.445624, 0.373159, 0.399069], "pt" -> 
           RGBColor[0.815686, 0.815686, 0.878431], "au" -> 
           RGBColor[1., 0.819608, 0.137255], "hg" -> 
           RGBColor[0.721569, 0.721569, 0.815686], "tl" -> 
           RGBColor[0.65098, 0.329412, 0.301961], "pb" -> 
           RGBColor[0.341176, 0.34902, 0.380392], "bi" -> 
           RGBColor[0.619608, 0.309804, 0.709804], "po" -> 
           RGBColor[0.670588, 0.360784, 0], "at" -> 
           RGBColor[0.458824, 0.309804, 0.270588], "rn" -> 
           RGBColor[0.218799, 0.516091, 0.591608], "fr" -> 
           RGBColor[0.25626, 0.0861372, 0.398932], "ra" -> 
           RGBColor[0., 0.473472, 0.04654], "ac" -> 
           RGBColor[0.322042, 0.71693, 0.988479], "th" -> 
           RGBColor[0.3608, 0.67166, 0.943003], "pa" -> 
           RGBColor[0.397469, 0.628, 0.898853], "u" -> 
           RGBColor[0.43205, 0.58595, 0.856029], "np" -> 
           RGBColor[0.464542, 0.54551, 0.814532], "pu" -> 
           RGBColor[0.494945, 0.506679, 0.774361], "am" -> 
           RGBColor[0.52326, 0.469458, 0.735517], "cm" -> 
           RGBColor[0.549486, 0.433847, 0.697999], "bk" -> 
           RGBColor[0.573624, 0.399845, 0.661808], "cf" -> 
           RGBColor[0.595673, 0.367454, 0.626942], "es" -> 
           RGBColor[0.615633, 0.336672, 0.593404], "fm" -> 
           RGBColor[0.633505, 0.307499, 0.561191], "md" -> 
           RGBColor[0.649288, 0.279937, 0.530305], "no" -> 
           RGBColor[0.662982, 0.253984, 0.500746], "lr" -> 
           RGBColor[0.674588, 0.22964, 0.472513], "rf" -> 
           RGBColor[0.684106, 0.206907, 0.445606], "db" -> 
           RGBColor[0.691534, 0.185783, 0.420025], "sg" -> 
           RGBColor[0.696874, 0.166269, 0.395772], "bh" -> 
           RGBColor[0.700126, 0.148365, 0.372844], "hs" -> 
           RGBColor[0.701289, 0.13207, 0.351243], "mt" -> 
           RGBColor[0.700363, 0.117385, 0.330968], "ds" -> 
           RGBColor[0.697348, 0.10431, 0.31202], "rg" -> 
           RGBColor[0.692245, 0.0928444, 0.294398], "cn" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "nh" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "fl" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "mc" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "lv" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "ts" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "og" -> 
           RGBColor[0.635401, 0.0528, 0.226184], "uub" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "uut" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "uuq" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "uup" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "uuh" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "uus" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "uuo" -> 
           RGBColor[0.635401, 0.0528, 0.226184]}]]& ][0.85], 
       ColorDataFunction[
       "Atoms", 
        "Named", {{
         "H", "He", "Li", "Be", "B", "C", "N", "O", "F", "Ne", "Na", "Mg", 
          "Al", "Si", "P", "S", "Cl", "Ar", "K", "Ca", "Sc", "Ti", "V", "Cr", 
          "Mn", "Fe", "Co", "Ni", "Cu", "Zn", "Ga", "Ge", "As", "Se", "Br", 
          "Kr", "Rb", "Sr", "Y", "Zr", "Nb", "Mo", "Tc", "Ru", "Rh", "Pd", 
          "Ag", "Cd", "In", "Sn", "Sb", "Te", "I", "Xe", "Cs", "Ba", "La", 
          "Ce", "Pr", "Nd", "Pm", "Sm", "Eu", "Gd", "Tb", "Dy", "Ho", "Er", 
          "Tm", "Yb", "Lu", "Hf", "Ta", "W", "Re", "Os", "Ir", "Pt", "Au", 
          "Hg", "Tl", "Pb", "Bi", "Po", "At", "Rn", "Fr", "Ra", "Ac", "Th", 
          "Pa", "U", "Np", "Pu", "Am", "Cm", "Bk", "Cf", "Es", "Fm", "Md", 
          "No", "Lr", "Rf", "Db", "Sg", "Bh", "Hs", "Mt", "Ds", "Rg", "Cn", 
          "Nh", "Fl", "Mc", "Lv", "Ts", "Og", "Uub", "Uut", "Uuq", "Uup", 
          "Uuh", "Uus", "Uuo"}, {
         "h", "he", "li", "be", "b", "c", "n", "o", "f", "ne", "na", "mg", 
          "al", "si", "p", "s", "cl", "ar", "k", "ca", "sc", "ti", "v", "cr", 
          "mn", "fe", "co", "ni", "cu", "zn", "ga", "ge", "as", "se", "br", 
          "kr", "rb", "sr", "y", "zr", "nb", "mo", "tc", "ru", "rh", "pd", 
          "ag", "cd", "in", "sn", "sb", "te", "i", "xe", "cs", "ba", "la", 
          "ce", "pr", "nd", "pm", "sm", "eu", "gd", "tb", "dy", "ho", "er", 
          "tm", "yb", "lu", "hf", "ta", "w", "re", "os", "ir", "pt", "au", 
          "hg", "tl", "pb", "bi", "po", "at", "rn", "fr", "ra", "ac", "th", 
          "pa", "u", "np", "pu", "am", "cm", "bk", "cf", "es", "fm", "md", 
          "no", "lr", "rf", "db", "sg", "bh", "hs", "mt", "ds", "rg", "cn", 
          "nh", "fl", "mc", "lv", "ts", "og", "uub", "uut", "uuq", "uup", 
          "uuh", "uus", "uuo"}}, Replace[#, 
         Dispatch[{
          "h" -> RGBColor[0.65, 0.7, 0.7], "he" -> RGBColor[0.836713, 1., 1.],
            "li" -> RGBColor[0.799435, 0.543572, 0.997559], "be" -> 
           RGBColor[0.770565, 0.964309, 0.0442359], "b" -> 
           RGBColor[1., 0.709804, 0.709804], "c" -> RGBColor[0.4, 0.4, 0.4], 
           "n" -> RGBColor[0.291989, 0.437977, 0.888609], "o" -> 
           RGBColor[0.800498, 0.201504, 0.192061], "f" -> 
           RGBColor[0.578462, 0.85539, 0.408855], "ne" -> 
           RGBColor[0.677263, 0.928423, 0.955287], "na" -> 
           RGBColor[0.658708, 0.492173, 0.842842], "mg" -> 
           RGBColor[0.628274, 0.850553, 0.0782731], "al" -> 
           RGBColor[0.8913, 0.631904, 0.627399], "si" -> 
           RGBColor[0.941176, 0.784314, 0.627451], "p" -> 
           RGBColor[1., 0.501961, 0], "s" -> 
           RGBColor[0.90443, 0.97015, 0.13504], "cl" -> 
           RGBColor[0.412698, 0.932689, 0.166398], "ar" -> 
           RGBColor[0.546138, 0.844244, 0.892092], "k" -> 
           RGBColor[0.534026, 0.420729, 0.705621], "ca" -> 
           RGBColor[0.480072, 0.744591, 0.0955222], "sc" -> 
           RGBColor[0.901961, 0.901961, 0.901961], "ti" -> 
           RGBColor[0.74902, 0.760784, 0.780392], "v" -> 
           RGBColor[0.65098, 0.65098, 0.670588], "cr" -> 
           RGBColor[0.541176, 0.6, 0.780392], "mn" -> 
           RGBColor[0.611765, 0.478431, 0.780392], "fe" -> 
           RGBColor[0.878431, 0.4, 0.2], "co" -> 
           RGBColor[0.941176, 0.564706, 0.627451], "ni" -> 
           RGBColor[0.313725, 0.815686, 0.313725], "cu" -> 
           RGBColor[0.784314, 0.501961, 0.2], "zn" -> 
           RGBColor[0.490196, 0.501961, 0.690196], "ga" -> 
           RGBColor[0.800757, 0.542666, 0.533513], "ge" -> 
           RGBColor[0.60508, 0.632465, 0.576489], "as" -> 
           RGBColor[0.741176, 0.501961, 0.890196], "se" -> 
           RGBColor[0.917248, 0.657833, 0.0706628], "br" -> 
           RGBColor[0.58847, 0.22163, 0.16064], "kr" -> 
           RGBColor[0.426019, 0.747462, 0.810413], "rb" -> 
           RGBColor[0.425391, 0.329242, 0.585895], "sr" -> 
           RGBColor[0.325959, 0.646423, 0.095983], "y" -> 
           RGBColor[0.531014, 1., 1.], "zr" -> 
           RGBColor[0.458599, 0.917466, 0.918573], "nb" -> 
           RGBColor[0.385036, 0.834854, 0.841681], "mo" -> 
           RGBColor[0.310325, 0.752163, 0.769323], "tc" -> 
           RGBColor[0.234466, 0.669394, 0.701499], "ru" -> 
           RGBColor[0.157459, 0.586546, 0.638209], "rh" -> 
           RGBColor[0.0793033, 0.50362, 0.579453], "pd" -> 
           RGBColor[0., 0.420615, 0.525231], "ag" -> 
           RGBColor[0.752941, 0.752941, 0.752941], "cd" -> 
           RGBColor[1., 0.85098, 0.560784], "in" -> 
           RGBColor[0.728371, 0.440594, 0.422196], "sn" -> 
           RGBColor[0.39799, 0.491477, 0.495586], "sb" -> 
           RGBColor[0.619608, 0.388235, 0.709804], "te" -> 
           RGBColor[0.816706, 0.451332, 0.0100947], "i" -> 
           RGBColor[0.580392, 0, 0.580392], "xe" -> 
           RGBColor[0.316906, 0.638078, 0.710252], "cs" -> 
           RGBColor[0.332803, 0.217712, 0.483666], "ba" -> 
           RGBColor[0.165935, 0.55605, 0.0796556], "la" -> 
           RGBColor[0.928084, 0.716075, 0.329427], "ce" -> 
           RGBColor[0.894824, 0.731424, 0.325131], "pr" -> 
           RGBColor[0.86523, 0.707999, 0.315261], "nd" -> 
           RGBColor[0.837836, 0.662974, 0.301635], "pm" -> 
           RGBColor[0.811992, 0.607859, 0.285626], "sm" -> 
           RGBColor[0.787563, 0.549894, 0.268279], "eu" -> 
           RGBColor[0.764628, 0.493261, 0.250405], "gd" -> 
           RGBColor[0.743177, 0.440115, 0.23269], "tb" -> 
           RGBColor[0.72281, 0.39143, 0.215783], "dy" -> 
           RGBColor[0.702434, 0.347663, 0.200392], "ho" -> 
           RGBColor[0.679962, 0.309234, 0.187368], "er" -> 
           RGBColor[0.652012, 0.276823, 0.17779], "tm" -> 
           RGBColor[0.613603, 0.251489, 0.173042], "yb" -> 
           RGBColor[0.557855, 0.234598, 0.17489], "lu" -> 
           RGBColor[0.475685, 0.227573, 0.18555], "hf" -> 
           RGBColor[0.781537, 0.717388, 0.716579], "ta" -> 
           RGBColor[0.734443, 0.544489, 0.683471], "w" -> 
           RGBColor[0.681179, 0.360409, 0.63675], "re" -> 
           RGBColor[0.605181, 0.367584, 0.556343], "os" -> 
           RGBColor[0.521806, 0.382125, 0.469204], "ir" -> 
           RGBColor[0.445624, 0.373159, 0.399069], "pt" -> 
           RGBColor[0.815686, 0.815686, 0.878431], "au" -> 
           RGBColor[1., 0.819608, 0.137255], "hg" -> 
           RGBColor[0.721569, 0.721569, 0.815686], "tl" -> 
           RGBColor[0.65098, 0.329412, 0.301961], "pb" -> 
           RGBColor[0.341176, 0.34902, 0.380392], "bi" -> 
           RGBColor[0.619608, 0.309804, 0.709804], "po" -> 
           RGBColor[0.670588, 0.360784, 0], "at" -> 
           RGBColor[0.458824, 0.309804, 0.270588], "rn" -> 
           RGBColor[0.218799, 0.516091, 0.591608], "fr" -> 
           RGBColor[0.25626, 0.0861372, 0.398932], "ra" -> 
           RGBColor[0., 0.473472, 0.04654], "ac" -> 
           RGBColor[0.322042, 0.71693, 0.988479], "th" -> 
           RGBColor[0.3608, 0.67166, 0.943003], "pa" -> 
           RGBColor[0.397469, 0.628, 0.898853], "u" -> 
           RGBColor[0.43205, 0.58595, 0.856029], "np" -> 
           RGBColor[0.464542, 0.54551, 0.814532], "pu" -> 
           RGBColor[0.494945, 0.506679, 0.774361], "am" -> 
           RGBColor[0.52326, 0.469458, 0.735517], "cm" -> 
           RGBColor[0.549486, 0.433847, 0.697999], "bk" -> 
           RGBColor[0.573624, 0.399845, 0.661808], "cf" -> 
           RGBColor[0.595673, 0.367454, 0.626942], "es" -> 
           RGBColor[0.615633, 0.336672, 0.593404], "fm" -> 
           RGBColor[0.633505, 0.307499, 0.561191], "md" -> 
           RGBColor[0.649288, 0.279937, 0.530305], "no" -> 
           RGBColor[0.662982, 0.253984, 0.500746], "lr" -> 
           RGBColor[0.674588, 0.22964, 0.472513], "rf" -> 
           RGBColor[0.684106, 0.206907, 0.445606], "db" -> 
           RGBColor[0.691534, 0.185783, 0.420025], "sg" -> 
           RGBColor[0.696874, 0.166269, 0.395772], "bh" -> 
           RGBColor[0.700126, 0.148365, 0.372844], "hs" -> 
           RGBColor[0.701289, 0.13207, 0.351243], "mt" -> 
           RGBColor[0.700363, 0.117385, 0.330968], "ds" -> 
           RGBColor[0.697348, 0.10431, 0.31202], "rg" -> 
           RGBColor[0.692245, 0.0928444, 0.294398], "cn" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "nh" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "fl" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "mc" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "lv" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "ts" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "og" -> 
           RGBColor[0.635401, 0.0528, 0.226184], "uub" -> 
           RGBColor[0.685054, 0.0829886, 0.278102], "uut" -> 
           RGBColor[0.675773, 0.0747426, 0.263133], "uuq" -> 
           RGBColor[0.664405, 0.0681063, 0.249491], "uup" -> 
           RGBColor[0.650947, 0.0630797, 0.237174], "uuh" -> 
           RGBColor[0.635401, 0.0596628, 0.226184], "uus" -> 
           RGBColor[0.635401, 0.056628, 0.226184], "uuo" -> 
           RGBColor[0.635401, 0.0528, 0.226184]}]]& ][0.85], 
       ColorDataFunction[
       "Atoms", 
        "Named", {{
         "H", "He", "Li", "Be", "B", "C", "N", "O", "F", "Ne", "Na", "Mg", 
          "Al", "Si", "P", "S", "Cl", "Ar", "K", "Ca", "Sc", "Ti", "V", "Cr", 
          "Mn", "Fe", "Co", "Ni", "Cu", "Zn", "Ga", "Ge", "As", "Se", "Br", 
          "Kr", "Rb", "Sr", "Y", "Zr", "Nb", "Mo", "Tc", "Ru", "Rh", "Pd", 
          "Ag", "Cd", "In", "Sn", "Sb", "Te", "I", "Xe", "Cs", "Ba", "La", 
          "Ce", "Pr", "Nd", "Pm", "Sm", "Eu", "Gd", "Tb", "Dy", "Ho", "Er", 
          "Tm", "Yb", "Lu", "Hf", "Ta", "W", "Re", "Os", "Ir", "Pt", "Au", 
          "Hg", "Tl", "Pb", "Bi", "Po", "At", "Rn", "Fr", "Ra", "Ac", "Th", 
          "Pa", "U", "Np", "Pu", "Am", "Cm", "Bk", "Cf", "Es", "Fm", "Md", 
          "No", "Lr", "Rf", "Db", "Sg", "Bh", "Hs", "Mt", "Ds", "Rg", "Cn", 
          "Nh", "Fl", "Mc", "Lv", "Ts", "Og", "Uub", "Uut", "Uuq", "Uup", 
          "Uuh", "Uus", "Uuo"}, {
         "h", "he", "li", "be", "b", "c", "n", "o", "f", "ne", "na", "mg", 
          "al", "si", "p", "s", "cl", "ar", "k", "ca", "sc", "ti", "v", "cr", 
          "mn", "fe", "co", "ni", "cu", "zn", "ga", "ge", "as", "se", "br", 
          "kr", "rb", "sr", "y", "zr", "nb", "mo", "tc", "ru", "rh", "pd", 
          "ag", "cd", "in", "sn", "sb", "te", "i", "xe", "cs", "ba", "la", 
          "ce", "pr", "nd", "pm", "sm", "eu", "gd", "tb", "dy", "ho", "er", 
          "tm", "yb", "lu", "hf", "ta", "w", "re", "os", "ir", "pt", "au", 
          "hg", "tl", "pb", "bi", "po", "at", "rn", "fr", "ra", "ac", "th", 
          "pa", "u", "np", "pu", "am", "cm", "bk", "cf", "es", "fm", "md", 
          "no", "lr", "rf", "db", "sg", "bh", "hs", "mt", "ds", "rg", "cn", 
          "nh", "fl", "mc", "lv", "ts", "og", "uub", "uut", "uuq", "uup", 
          "uuh", "uus", "uuo"}}, Replace[#, 
         Dispatch[{
          "h" -> RGBColor[0.65, 0.7, 0.7], "he" -> RGBColor[0.836713, 1., 1.],
            "li" -> RGBColor[0.799435, 0.543572, 0.997559], "be" -> 
           RGBColor[0.770565, 0.964309, 0.0442359], "b" -> 
           RGBColor[1., 0.709804, 0.709804], "c" -> RGBColor[0.4, 0.4, 0.4], 
           "n" -> RGBColor[0.291989, 0.437977, 0.888609], "o" -> 
           RGBColor[0.800498, 0.201504, 0.192061], "f" -> 
           RGBColor[0.578462, 0.85539, 0.408855], "ne" -> 
           RGBColor[0.677263, 0.928423, 0.955287], "na" -> 
           RGBColor[0.658708, 0.492173, 0.842842], "mg" -> 
           RGBColor[0.628274, 0.850553, 0.0782731], "al" -> 
           RGBColor[0.8913, 0.631904, 0.627399], "si" -> 
           RGBColor[0.941176, 0.784314, 0.627451], "p" -> 
           RGBColor[1., 0.501961, 0], "s" -> 
           RGBColor[0.90443, 0.97015, 0.13504], "cl" -> 
           RGBColor[0.412698, 0.932689, 0.166398], "ar" -> 
           RGBColor[0.546138, 0.844244, 0.892092], "k" -> 
           RGBColor[0.534026, 0.420729, 0.705621], "ca" -> 
           RGBColor[0.480072, 0.744591, 0.0955222], "sc" -> 
           RGBColor[0.901961, 0.901961, 0.901961], "ti" -> 
           RGBColor[0.74902, 0.760784, 0.780392], "v" -> 
           RGBColor[0.65098, 0.65098, 0.670588], "cr" -> 
           RGBColor[0.541176, 0.6, 0.780392], "mn" -> 
           RGBColor[0.611765, 0.478431, 0.780392], "fe" -> 
           RGBColor[0.878431, 0.4, 0.2], "co" -> 
           RGBColor[0.941176, 0.564706, 0.627451], "ni" -> 
           RGBColor[0.313725, 0.815686, 0.313725], "cu" -> 
           RGBColor[0.784314, 0.501961, 0.2], "zn" -> 
           RGBColor[0.490196, 0.501961, 0.690196], "ga" -> 
           RGBColor[0.800757, 0.542666, 0.533513], "ge" -> 
           RGBColor[0.60508, 0.632465, 0.576489], "as" -> 
           RGBColor[0.741176, 0.501961, 0.890196], "se" -> 
           RGBColor[0.917248, 0.657833, 0.0706628], "br" -> 
           RGBColor[0.58847, 0.22163, 0.16064], "kr" -> 
           RGBColor[0.426019, 0.747462, 0.810413], "rb" -> 
           RGBColor[0.425391, 0.329242, 0.585895], "sr" -> 
           RGBColor[0.325959, 0.646423, 0.095983], "y" -> 
           RGBColor[0.531014, 1., 1.], "zr" -> 
           RGBColor[0.458599, 0.917466, 0.918573], "nb" -> 
           RGBColor[0.385036, 0.834854, 0.841681], "mo" -> 
           RGBColor[0.310325, 0.752163, 0.769323], "tc" -> 
           RGBColor[0.234466, 0.669394, 0.701499], "ru" -> 
           RGBColor[0.157459, 0.586546, 0.638209], "rh" -> 
           RGBColor[0.0793033, 0.50362, 0.579453], "pd" -> 
           RGBColor[0., 0.420615, 0.525231], "ag" -> 
           RGBColor[0.752941, 0.752941, 0.752941], "cd" -> 
           RGBColor[1., 0.85098, 0.560784], "in" -> 
           RGBColor[0.728371, 0.440594, 0.422196], "sn" -> 
           RGBColor[0.39799, 0.491477, 0.495586], "sb" -> 
           RGBColor[0.619608, 0.388235, 0.709804], "te" -> 
           RGBColor[0.816706, 0.451332, 0.0100947], "i" -> 
           RGBColor[0.580392, 0, 0.580392], "xe" -> 
           RGBColor[0.316906, 0.638078, 0.710252], "cs" -> 
           RGBColor[0.332803, 0.217712, 0.483666], "ba" -> 
           RGBColor[0.165935, 0.55605, 0.0796556], "la" -> 
           RGBColor[0.928084, 0.716075, 0.329427], "ce" -> 
           RGBColor[0.894824, 0.731424, 0.325131], "pr" -> 
           RGBColor[0.86523, 0.707999, 0.315261], "nd" -> 
           RGBColor[0.837836, 0.662974, 0.301635], "pm" -> 
           RGBColor[0.811992, 0.607859, 0.285626], "sm" -> 
           RGBColor[0.787563, 0.549894, 0.268279], "eu" -> 
           RGBColor[0.764628, 0.493261, 0.250405], "gd" -> 
           RGBColor[0.743177, 0.440115, 0.23269], "tb" -> 
           RGBColor[0.72281, 0.39143, 0.215783], "dy" -> 
           RGBColor[0.702434, 0.347663, 0.200392], "ho" -> 
           RGBColor[0.679962, 0.309234, 0.187368], "er" -> 
           RGBColor[0.652012, 0.276823, 0.17779], "tm" -> 
           RGBColor[0.613603, 0.251489, 0.173042], "yb" -> 
           RGBColor[0.557855, 0.234598, 0.17489], "lu" -> 
           RGBColor[0.475685, 0.227573, 0.18555], "hf" -> 
           RGBColor[0.781537, 0.717388, 0.716579], "ta" -> 
           RGBColor[0.734443, 0.544489, 0.683471], "w" -> 
           RGBColor[0.681179, 0.360409, 0.63675], "re" -> 
           RGBColor[0.605181, 0.367584, 0.556343], "os" -> 
           RGBColor[0.521806, 0.382125, 0.469204], "ir" -> 
           RGBColor[0.445624, 0.373159, 0.399069], "pt" -> 
           RGBColor[0.815686, 0.815686, 0.878431], "au" -> 
           RGBColor[1., 0.819608, 0.137255], "hg" -> 
           RGBColor[0.721569, 0.721569, 0.815686], "tl" -> 
           RGBColor[0.65098, 0.329412, 0.301961], "pb" -> 
           RGBColor[0.341176, 0.34902, 0.380392], "bi" -> 
           RGBColor[0.619608, 0.309804, 0.709804], "po" -> 
           RGBColor[0.670588, 0.360784, 0], "at" -> 
           RGBColor[0.458824, 0.309804, 0.270588], "rn" -> 
           RGBColor[0.218799, 0.516091, 0.591608], "fr" -> 
           RGBColor[0.25626, 0.0861372, 0.398932], "ra" -> 
           RGBColor[0., 0.473472, 0.04654], "ac" -> 
           RGBColor[0.322042, 0.71693, 0.988479], "th" -> 
           RGBColor[0.3608, 0.67166, 0.943003], "pa" -> 
           RGBColor[0.397469, 0.628, 0.898853], "u" -> 
           RGBColor[0.43205, 0.58595, 0.856029], "np" -> 
           RGBColor[0.464542, 0.54551, 0.814532], "pu" -> 
           RGBColor[0.494945, 0.506679, 0.774361], "am" -> 
           RGBColor[0.52326, 0.469458, 0.735517], "cm" -> 
           RGBColor[0.549486, 0.433847, 0.697999], "bk" -> 
           RGBColor[0.573624, 0.399845, 0.661808], "cf" -> 
           RGBColor[0.595673, 0.367454, 0.626942], "es" -> 
           RGBColor[0.615633, 0.336672, 0.593404], "fm" -> 
           RGBColor[0.633505, 0.307499, 0.561191], "md" -> 
           RGBColor[0.649288, 0.279937, 0.530305], "no" -> 
           RGBColor[0.662982, 0.253984, 0.500746], "lr" -> 
           RGBColor[0.674588, 0.22964, 0.472513], "rf" -> 
           RGBColor[0.684106, 0.206907, 0.445606], "d